/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 378
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy18;
  EJoinType yy36;
  ENullOrder yy109;
  EOperatorType yy128;
  bool yy173;
  SDataType yy196;
  EOrder yy218;
  SAlterOption yy389;
  int32_t yy424;
  SToken yy533;
  SNode* yy560;
  int64_t yy585;
  SNodeList* yy712;
  int8_t yy719;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             666
#define YYNRULE              489
#define YYNTOKEN             255
#define YY_MAX_SHIFT         665
#define YY_MIN_SHIFTREDUCE   970
#define YY_MAX_SHIFTREDUCE   1458
#define YY_ERROR_ACTION      1459
#define YY_ACCEPT_ACTION     1460
#define YY_NO_ACTION         1461
#define YY_MIN_REDUCE        1462
#define YY_MAX_REDUCE        1950
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2318)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   529, 1700,  433,  552,  434, 1497,  441, 1589,  434, 1497,
 /*    10 */  1772,  113,   39,   37,  386,   62,  517, 1585,  471,  380,
 /*    20 */   338, 1768, 1259, 1003,  324,   79, 1785, 1697, 1600,   30,
 /*    30 */   260,  122,  143, 1335,  103, 1257, 1556,  102,  101,  100,
 /*    40 */    99,   98,   97,   96,   95,   94, 1593, 1764, 1770,  327,
 /*    50 */    71,  302,  557, 1928, 1803,  555, 1330, 1514, 1285,  574,
 /*    60 */  1928,   14,  581, 1007, 1008,  500, 1927, 1754, 1265,  580,
 /*    70 */  1925,  120, 1596,  159,   39,   37, 1398, 1925,  498,  487,
 /*    80 */   496,  529,  338,  557, 1259,    1,  250, 1870,  551, 1020,
 /*    90 */   550, 1019,  164, 1928, 1816, 1335,   61, 1257,   89, 1786,
 /*   100 */   583, 1788, 1789,  579,  469,  574,  161,  662, 1862, 1600,
 /*   110 */  1925,  343,  305, 1858, 1645, 1647,   71,   61, 1330, 1021,
 /*   120 */    43, 1337, 1338,   14, 1928, 1463, 1928,   33,   32,  117,
 /*   130 */  1265,   40,   38,   36,   35,   34,  475,  161, 1595,  160,
 /*   140 */   142, 1925, 1474, 1925, 1485, 1785,  103,    2,  214,  102,
 /*   150 */   101,  100,   99,   98,   97,   96,   95,   94,  474, 1156,
 /*   160 */  1157,  486,  485,  484,  170, 1928, 1260,  483, 1258,  662,
 /*   170 */   118,  480,  325, 1803,  479,  478,  477, 1460, 1926,   74,
 /*   180 */   140,  556, 1925, 1337, 1338, 1754, 1754,  555,  580, 1602,
 /*   190 */  1646, 1647,   69, 1263, 1264,   68, 1313, 1314, 1316, 1317,
 /*   200 */  1318, 1319, 1320,  576,  572, 1328, 1329, 1331, 1332, 1333,
 /*   210 */  1334, 1336, 1339, 1816,   36,   35,   34,   90, 1786,  583,
 /*   220 */  1788, 1789,  579,  529,  574,  162,  371, 1862, 1260,  555,
 /*   230 */  1258,  329, 1858,  154,  113,  419,  162,  350, 1484,   33,
 /*   240 */    32,  476,  450,   40,   38,   36,   35,   34,  373,  369,
 /*   250 */  1285, 1600,  552, 1889, 1395, 1263, 1264,  162, 1313, 1314,
 /*   260 */  1316, 1317, 1318, 1319, 1320,  576,  572, 1328, 1329, 1331,
 /*   270 */  1332, 1333, 1334, 1336, 1339,   39,   37, 1455, 1928, 1754,
 /*   280 */   122,  174,  173,  338,  220, 1259,   40,   38,   36,   35,
 /*   290 */    34,  159,  306,   61,   42, 1925, 1335, 1741, 1257, 1114,
 /*   300 */   605,  604,  603, 1118,  602, 1120, 1121,  601, 1123,  598,
 /*   310 */  1803, 1129,  595, 1131, 1132,  592,  589, 1298,  545, 1330,
 /*   320 */   120, 1785,   33,   32,   14, 1357,   40,   38,   36,   35,
 /*   330 */    34, 1265,   39,   37,  554,  155, 1870, 1871,   86, 1875,
 /*   340 */   338,  552, 1259, 1772,  359, 1652, 1239, 1240,    2, 1803,
 /*   350 */   341,  119,  326, 1335, 1768, 1257,  544,  581,  140, 1592,
 /*   360 */   344, 1650, 1754,  529,  580, 1402, 1454, 1602,  140,  122,
 /*   370 */   662, 1284, 1284,  379,  165,  378, 1330, 1602,  557, 1358,
 /*   380 */  1764, 1770,  333, 1578, 1337, 1338, 1462,  432, 1265, 1816,
 /*   390 */   436, 1600,  574,   89, 1786,  583, 1788, 1789,  579, 1483,
 /*   400 */   574,  440, 1363, 1862,  436,    8,  215,  305, 1858,  120,
 /*   410 */   112,  111,  110,  109,  108,  107,  106,  105,  104, 1928,
 /*   420 */   482,  481,  632,  630,  156, 1870, 1871,  662, 1875, 1260,
 /*   430 */   208, 1258,  159,  162,  162,   61, 1925,   75,  516, 1482,
 /*   440 */  1754, 1337, 1338,  450,   29,  336, 1352, 1353, 1354, 1355,
 /*   450 */  1356, 1360, 1361, 1362, 1481,  315, 1263, 1264,  546, 1313,
 /*   460 */  1314, 1316, 1317, 1318, 1319, 1320,  576,  572, 1328, 1329,
 /*   470 */  1331, 1332, 1333, 1334, 1336, 1339, 1394,   33,   32, 1928,
 /*   480 */  1754,   40,   38,   36,   35,   34, 1260, 1359, 1258,   73,
 /*   490 */   304, 1652,  159,  519,  541, 1754, 1925,   33,   32,  348,
 /*   500 */  1286,   40,   38,   36,   35,   34,  316, 1651,  314,  313,
 /*   510 */  1364,  473,  616, 1263, 1264,  475, 1313, 1314, 1316, 1317,
 /*   520 */  1318, 1319, 1320,  576,  572, 1328, 1329, 1331, 1332, 1333,
 /*   530 */  1334, 1336, 1339,   39,   37, 1340,  438,  474, 1007, 1008,
 /*   540 */  1928,  338, 1282, 1259, 1785,  162, 1877, 1480, 1315, 1020,
 /*   550 */   306, 1019,   27,  159, 1335, 1429, 1257, 1925, 1591,   33,
 /*   560 */    32,  221,  222,   40,   38,   36,   35,   34, 1287, 1768,
 /*   570 */  1874,  552, 1803,  547,  542,  162, 1576, 1330, 1283, 1021,
 /*   580 */   556,  529,  529, 1357,  153, 1754, 1479,  580, 1754, 1265,
 /*   590 */    39,   37,  384,  385,   22, 1764, 1770, 1639,  338,  122,
 /*   600 */  1259, 1524, 1076,   11,   10,  140,    9,  574, 1652, 1600,
 /*   610 */  1600, 1335, 1816, 1257, 1603,  342,   90, 1786,  583, 1788,
 /*   620 */  1789,  579,  304,  574, 1650,  519, 1862, 1754,  662,  529,
 /*   630 */   329, 1858,  154,  252, 1330, 1078,  616, 1358, 1877,  120,
 /*   640 */   389, 1557, 1337, 1338,  158, 1345, 1265, 1696, 1690,  299,
 /*   650 */   517, 1284, 1888, 1265,  157, 1870, 1871, 1600, 1875,  172,
 /*   660 */  1363, 1698, 1873,    9,  639,  638,  637,  636,  346, 1587,
 /*   670 */   635,  634,  633,  123,  628,  627,  626,  625,  624,  623,
 /*   680 */   622,  621,  133,  617, 1527,  662, 1284, 1260, 1371, 1258,
 /*   690 */    33,   32, 1877, 1478,   40,   38,   36,   35,   34, 1337,
 /*   700 */  1338,  232,   29,  336, 1352, 1353, 1354, 1355, 1356, 1360,
 /*   710 */  1361, 1362,    7, 1477, 1263, 1264, 1872, 1313, 1314, 1316,
 /*   720 */  1317, 1318, 1319, 1320,  576,  572, 1328, 1329, 1331, 1332,
 /*   730 */  1333, 1334, 1336, 1339, 1754,   33,   32, 1882, 1391,   40,
 /*   740 */    38,   36,   35,   34, 1260,  561, 1258,  486,  485,  484,
 /*   750 */    44,    4, 1259,  483, 1754,  272,  118,  480, 1630,  608,
 /*   760 */   479,  478,  477, 1476,  619, 1257, 1419, 1695, 1409,  299,
 /*   770 */   612, 1263, 1264, 1643, 1313, 1314, 1316, 1317, 1318, 1319,
 /*   780 */  1320,  576,  572, 1328, 1329, 1331, 1332, 1333, 1334, 1336,
 /*   790 */  1339,   39,   37,  301,  613, 1282,  614, 1643, 1265,  338,
 /*   800 */  1583, 1259,  412, 1785, 1754,  424, 1268,  538, 1417, 1418,
 /*   810 */  1420, 1421, 1335, 1298, 1257,  131,  130,  611,  610,  609,
 /*   820 */    11,   10,  397,  529,  425,  211,  399,  631, 1315,  529,
 /*   830 */   529, 1803,  529, 1473,  404, 1330,  620,  662, 1572,  581,
 /*   840 */   405,  449,   26, 1597, 1754,   59,  580, 1265,   33,   32,
 /*   850 */  1509, 1600,   40,   38,   36,   35,   34, 1600, 1600,  390,
 /*   860 */  1600,   33,   32, 1315,    2,   40,   38,   36,   35,   34,
 /*   870 */   374, 1816,  489,  570, 1754,   91, 1786,  583, 1788, 1789,
 /*   880 */   579,   28,  574, 1457, 1458, 1862,  662,   33,   32, 1861,
 /*   890 */  1858,   40,   38,   36,   35,   34, 1260, 1391, 1258,  423,
 /*   900 */  1337, 1338,  418,  417,  416,  415,  414,  411,  410,  409,
 /*   910 */   408,  407,  403,  402,  401,  400,  394,  393,  392,  391,
 /*   920 */   575,  388,  387, 1263, 1264,  529,  564,  529, 1507,  141,
 /*   930 */  1472,  529,  199,  529,  278,  197, 1729,  201,  510, 1271,
 /*   940 */   200, 1047,  514,  194,  527, 1260,  562, 1258,  276,   58,
 /*   950 */   492,  203,   57, 1600,  202, 1600,  607,  146,  502, 1600,
 /*   960 */   509, 1600,  467,  463,  459,  455,  193, 1785,  177,  429,
 /*   970 */   427, 1754, 1263, 1264, 1048, 1313, 1314, 1316, 1317, 1318,
 /*   980 */  1319, 1320,  576,  572, 1328, 1329, 1331, 1332, 1333, 1334,
 /*   990 */  1336, 1339,  335,  334,   72, 1803,   61,  191,  529, 1928,
 /*  1000 */   529,  205, 1273,  581,  204, 1349,  139, 1475, 1754,  528,
 /*  1010 */   580,  261,  159, 1335, 1773, 1266, 1925,   52,  513,  529,
 /*  1020 */   255,  539,   85,  468, 1471, 1768, 1600, 1470, 1600, 1267,
 /*  1030 */   345, 1469,   82,   41,   88, 1816, 1330, 1577, 1468,   90,
 /*  1040 */  1786,  583, 1788, 1789,  579, 1785,  574, 1600, 1265, 1862,
 /*  1050 */  1467, 1764, 1770,  329, 1858, 1941, 1503,  503,  244,  190,
 /*  1060 */   183, 1575,  188,  574, 1896, 1754,  446, 1466, 1754,   66,
 /*  1070 */    65,  383, 1754, 1803,  169, 1465, 1207, 1804,  347, 1754,
 /*  1080 */   377,  581,  219,  125,  559,  181, 1754,  569,  580, 1775,
 /*  1090 */  1498, 1754, 1640,  300,  128,  129,  367,   50,  365,  361,
 /*  1100 */   357,  166,  352,  349,  657, 1892,  236,   50, 1754,   41,
 /*  1110 */   249,  553,  254, 1816,  257,  259, 1754,   90, 1786,  583,
 /*  1120 */  1788, 1789,  579, 1785,  574,  223,  522, 1862, 1777,  565,
 /*  1130 */    80,  329, 1858, 1941,  614,    3,  162,  229, 1107,   41,
 /*  1140 */  1416,   53, 1919,    5,  351, 1282, 1274,  354, 1269,  239,
 /*  1150 */  1365, 1803, 1321,  131,  130,  611,  610,  609,  614,  581,
 /*  1160 */   587,  128, 1270,  358, 1754, 1785,  580,  311, 1076,  129,
 /*  1170 */   114,  128,  312, 1277, 1279, 1223,  268,  131,  130,  611,
 /*  1180 */   610,  609,  271,  406,  572, 1328, 1329, 1331, 1332, 1333,
 /*  1190 */  1334, 1816, 1692, 1803,  171,   90, 1786,  583, 1788, 1789,
 /*  1200 */   579,  581,  574, 1135, 1139, 1862, 1754,  413,  580,  329,
 /*  1210 */  1858, 1941, 1146, 1144,  132,  421,  426,  420,  422,  428,
 /*  1220 */  1881,  430,  557, 1288,  431,  439, 1785,  180, 1291,  442,
 /*  1230 */   443,  182, 1290, 1816,  444, 1292, 1785,  285, 1786,  583,
 /*  1240 */  1788, 1789,  579,  445,  574,  491,  185,  447, 1289,  187,
 /*  1250 */   448,  189,   70,  451, 1803,  192,  470,  472, 1590,  196,
 /*  1260 */   501, 1586,  581, 1928, 1803,  303, 1734, 1754,   93,  580,
 /*  1270 */   198,  209,  581,  269,  207,  134,  161, 1754,  135,  580,
 /*  1280 */  1925, 1588,  504,  557, 1584,  136,  137,  508,  494,  505,
 /*  1290 */   212,  511,  488, 1785, 1816,  515,  216,  206,  285, 1786,
 /*  1300 */   583, 1788, 1789,  579, 1816,  574,  537, 1785,   91, 1786,
 /*  1310 */   583, 1788, 1789,  579,  126,  574,  518, 1733, 1862, 1702,
 /*  1320 */   321, 1803,  568, 1858, 1928,   56,  520,  523,   55,  578,
 /*  1330 */   323,  127,  524,  525, 1754, 1803,  580,  159,  225,  227,
 /*  1340 */   270, 1925, 1601,  581,   78, 1287,  533,  540, 1754,  535,
 /*  1350 */   580,  234, 1893, 1903,  536, 1902,  238, 1785,  328,  543,
 /*  1360 */     6, 1816, 1884,  549,  534,  293, 1786,  583, 1788, 1789,
 /*  1370 */   579,  577,  574,  571, 1834, 1816,  243, 1785,  148,  144,
 /*  1380 */  1786,  583, 1788, 1789,  579, 1803,  574,  532,  531,  248,
 /*  1390 */  1391,  245,  246,  581,  121,  247, 1286, 1878, 1754,  566,
 /*  1400 */   580,  563,   48,  330,  253, 1803, 1924, 1573, 1644,  273,
 /*  1410 */   322,  658,  585,  581,  560, 1944, 1843,  264, 1754,  661,
 /*  1420 */   580,   51,  659,  558, 1942, 1816,  147,  277,  256,   91,
 /*  1430 */  1786,  583, 1788, 1789,  579, 1748,  574,  286,  275, 1862,
 /*  1440 */   567,  258,  296, 1785, 1859, 1816,   63,  295, 1747,  294,
 /*  1450 */  1786,  583, 1788, 1789,  579, 1785,  574, 1746,   64, 1745,
 /*  1460 */   353, 1742,  355, 1251,  356, 1785, 1252,  167,  360, 1740,
 /*  1470 */   364, 1803,  362,  363, 1739,  366,  530, 1738,  368,  581,
 /*  1480 */  1737, 1736,  370, 1803, 1754, 1719,  580,  372,  168,  375,
 /*  1490 */   376,  581, 1226, 1803, 1225, 1713, 1754, 1712,  580,  381,
 /*  1500 */   382,  581, 1711, 1710, 1195, 1685, 1754, 1684,  580, 1683,
 /*  1510 */    67, 1816, 1682, 1681, 1680,  294, 1786,  583, 1788, 1789,
 /*  1520 */   579, 1785,  574, 1816, 1679, 1678,  396,  289, 1786,  583,
 /*  1530 */  1788, 1789,  579, 1816,  574, 1785,  395,  144, 1786,  583,
 /*  1540 */  1788, 1789,  579, 1677,  574,  398, 1676, 1675, 1674, 1803,
 /*  1550 */   124, 1662, 1661, 1660, 1659, 1658, 1657,  578, 1673, 1672,
 /*  1560 */  1671, 1670, 1754, 1803,  580,  548, 1669, 1668,  337, 1667,
 /*  1570 */  1666,  581, 1665, 1664, 1663, 1656, 1754, 1655,  580, 1197,
 /*  1580 */  1654, 1653, 1943, 1529,  175, 1528,  176, 1526, 1785, 1816,
 /*  1590 */  1494,  178, 1010,  293, 1786,  583, 1788, 1789,  579, 1493,
 /*  1600 */   574,  115, 1835, 1816,  179, 1009,  152,  294, 1786,  583,
 /*  1610 */  1788, 1789,  579,  665,  574,  453, 1803,  435,  116, 1727,
 /*  1620 */  1721,  339,  437, 1709,  581,  184, 1708,  267,  186, 1754,
 /*  1630 */  1785,  580, 1694, 1579, 1525, 1523,  452,  454, 1521,  456,
 /*  1640 */   457,  151, 1519,  460, 1785,  458,  655,  651,  647,  643,
 /*  1650 */   265, 1040,  461,  462, 1517,  466, 1816,  464, 1803,  465,
 /*  1660 */   294, 1786,  583, 1788, 1789,  579,  581,  574, 1506, 1505,
 /*  1670 */  1490, 1754, 1803,  580, 1581, 1150,   49, 1149,   87, 1580,
 /*  1680 */   581,  230, 1075, 1074,  195, 1754, 1073,  580, 1072,  629,
 /*  1690 */  1515, 1069,  631, 1068, 1067, 1066, 1510,  317, 1816,  318,
 /*  1700 */  1508,  490,  279, 1786,  583, 1788, 1789,  579, 1785,  574,
 /*  1710 */   319,  493, 1816, 1489,  526,  495,  280, 1786,  583, 1788,
 /*  1720 */  1789,  579, 1488,  574,  497, 1487,  499,   92, 1726, 1233,
 /*  1730 */  1785, 1720,  506, 1707, 1705, 1706, 1803,   54, 1704, 1703,
 /*  1740 */  1701, 1693,  226,  231,  581,   82,  217,  213,  507, 1754,
 /*  1750 */  1785,  580,  218,  320,   41,   16,   15,  512, 1803, 1431,
 /*  1760 */   138,  521,  228,  224,   47,  242,  581, 1231,   76,  210,
 /*  1770 */    77, 1754,   23,  580,   17,  241, 1816, 1243, 1803,  235,
 /*  1780 */   281, 1786,  583, 1788, 1789,  579,  581,  574, 1413, 1775,
 /*  1790 */   233, 1754, 1785,  580,  237,   25,  251,  145, 1816,   46,
 /*  1800 */  1415,  240,  288, 1786,  583, 1788, 1789,  579, 1785,  574,
 /*  1810 */  1408,   24,   81, 1774,  149, 1388, 1387,   18, 1816, 1443,
 /*  1820 */  1803, 1442,  290, 1786,  583, 1788, 1789,  579,  581,  574,
 /*  1830 */    45, 1448, 1437, 1754,  331,  580, 1803, 1447,   13, 1446,
 /*  1840 */   332,   10, 1275,   19,  581, 1819, 1306, 1325,  573, 1754,
 /*  1850 */  1323,  580, 1322,  150, 1350,   31,   12,   20,  163,  582,
 /*  1860 */  1816, 1785,   21,  586,  282, 1786,  583, 1788, 1789,  579,
 /*  1870 */   340,  574,  584, 1785, 1136,  588, 1816, 1133,  590,  591,
 /*  1880 */   291, 1786,  583, 1788, 1789,  579,  593,  574,  594, 1803,
 /*  1890 */   596,  599, 1130, 1113, 1124,  597,  600,  581, 1128, 1122,
 /*  1900 */    83, 1803, 1754,   84,  580, 1127, 1126, 1125, 1145,  581,
 /*  1910 */   262,  606,   60, 1141, 1754, 1785,  580, 1063, 1082, 1038,
 /*  1920 */   615,  618,  263, 1061, 1060, 1785, 1056, 1059, 1058, 1816,
 /*  1930 */  1057, 1055, 1054,  283, 1786,  583, 1788, 1789,  579, 1785,
 /*  1940 */   574, 1816, 1079, 1803, 1077,  292, 1786,  583, 1788, 1789,
 /*  1950 */   579,  581,  574, 1803, 1051, 1050, 1754, 1049,  580, 1046,
 /*  1960 */  1045,  581, 1044, 1043, 1522,  640, 1754, 1803,  580, 1520,
 /*  1970 */   641,  642,  644,  645,  646,  581, 1518,  648,  649, 1516,
 /*  1980 */  1754,  652,  580, 1816,  650,  653,  654,  284, 1786,  583,
 /*  1990 */  1788, 1789,  579, 1816,  574, 1785, 1504,  297, 1786,  583,
 /*  2000 */  1788, 1789,  579,  656,  574, 1785, 1000, 1816, 1486,  266,
 /*  2010 */   660,  298, 1786,  583, 1788, 1789,  579, 1785,  574, 1261,
 /*  2020 */   274,  663,  664, 1803, 1461, 1461, 1461, 1461, 1461, 1461,
 /*  2030 */  1461,  581, 1461, 1803, 1461, 1461, 1754, 1461,  580, 1461,
 /*  2040 */  1461,  581, 1461, 1461, 1461, 1803, 1754, 1461,  580, 1461,
 /*  2050 */  1461, 1461, 1461,  581, 1461, 1461, 1461, 1461, 1754, 1461,
 /*  2060 */   580, 1461, 1461, 1816, 1461, 1461, 1461, 1797, 1786,  583,
 /*  2070 */  1788, 1789,  579, 1816,  574, 1461, 1461, 1796, 1786,  583,
 /*  2080 */  1788, 1789,  579, 1785,  574, 1816, 1461, 1461, 1461, 1795,
 /*  2090 */  1786,  583, 1788, 1789,  579, 1785,  574, 1461, 1461, 1461,
 /*  2100 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*  2110 */  1461, 1803, 1461, 1461, 1461, 1461, 1461, 1461, 1461,  581,
 /*  2120 */  1461, 1461, 1461, 1803, 1754, 1461,  580, 1461, 1461, 1461,
 /*  2130 */  1461,  581, 1461, 1461, 1461, 1461, 1754, 1461,  580, 1461,
 /*  2140 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1785, 1461,
 /*  2150 */  1461, 1816, 1461, 1461, 1461,  309, 1786,  583, 1788, 1789,
 /*  2160 */   579, 1461,  574, 1816, 1461, 1461, 1461,  308, 1786,  583,
 /*  2170 */  1788, 1789,  579, 1461,  574, 1461, 1803, 1461, 1461, 1461,
 /*  2180 */  1461, 1461, 1461, 1461,  581, 1461, 1461, 1461, 1461, 1754,
 /*  2190 */  1461,  580, 1461, 1461, 1461, 1461, 1461, 1461, 1785, 1461,
 /*  2200 */  1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1785, 1461,
 /*  2210 */   552, 1461, 1461, 1461, 1461, 1461, 1816, 1461, 1461, 1461,
 /*  2220 */   310, 1786,  583, 1788, 1789,  579, 1803,  574, 1461, 1461,
 /*  2230 */  1461, 1461, 1461, 1461,  581, 1461, 1803, 1461,  122, 1754,
 /*  2240 */  1461,  580, 1461, 1461,  581, 1461, 1461, 1461, 1461, 1754,
 /*  2250 */  1461,  580, 1461, 1461, 1461, 1461, 1461, 1461, 1461,  557,
 /*  2260 */  1461, 1461, 1461, 1461, 1461, 1461, 1816, 1461, 1461, 1461,
 /*  2270 */   307, 1786,  583, 1788, 1789,  579, 1816,  574,  120, 1461,
 /*  2280 */   287, 1786,  583, 1788, 1789,  579, 1461,  574, 1461, 1461,
 /*  2290 */  1461, 1461, 1461,  250, 1870,  551, 1461,  550, 1461, 1461,
 /*  2300 */  1928, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
 /*  2310 */  1461, 1461, 1461,  159, 1461, 1461, 1461, 1925,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   266,    0,  262,  266,  264,  265,  262,  287,  264,  265,
 /*    10 */   288,  277,   12,   13,  266,    4,  301,  287,  284,  315,
 /*    20 */    20,  299,   22,    4,  309,  268,  258,  312,  294,  341,
 /*    30 */   342,  294,  271,   33,   21,   35,  275,   24,   25,   26,
 /*    40 */    27,   28,   29,   30,   31,   32,  289,  325,  326,  327,
 /*    50 */   270,  303,  315,  356,  286,   20,   56,    0,   20,  337,
 /*    60 */   356,   61,  294,   44,   45,   21,  369,  299,   68,  301,
 /*    70 */   373,  334,  292,  369,   12,   13,   14,  373,   34,   22,
 /*    80 */    36,  266,   20,  315,   22,   85,  349,  350,  351,   20,
 /*    90 */   353,   22,  277,  356,  326,   33,   85,   35,  330,  331,
 /*   100 */   332,  333,  334,  335,   35,  337,  369,  107,  340,  294,
 /*   110 */   373,  297,  344,  345,  300,  301,  270,   85,   56,   50,
 /*   120 */    85,  121,  122,   61,  356,    0,  356,    8,    9,  283,
 /*   130 */    68,   12,   13,   14,   15,   16,   97,  369,  292,  369,
 /*   140 */   257,  373,  259,  373,  258,  258,   21,   85,   56,   24,
 /*   150 */    25,   26,   27,   28,   29,   30,   31,   32,  119,  121,
 /*   160 */   122,   63,   64,   65,   56,  356,  166,   69,  168,  107,
 /*   170 */    72,   73,  278,  286,   76,   77,   78,  255,  369,   87,
 /*   180 */   286,  294,  373,  121,  122,  299,  299,   20,  301,  295,
 /*   190 */   300,  301,   84,  193,  194,   87,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  326,   14,   15,   16,  330,  331,  332,
 /*   220 */   333,  334,  335,  266,  337,  225,  161,  340,  166,   20,
 /*   230 */   168,  344,  345,  346,  277,   79,  225,  315,  258,    8,
 /*   240 */     9,  284,   60,   12,   13,   14,   15,   16,  183,  184,
 /*   250 */    20,  294,  266,  366,    4,  193,  194,  225,  196,  197,
 /*   260 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   270 */   208,  209,  210,  211,  212,   12,   13,  158,  356,  299,
 /*   280 */   294,  125,  126,   20,  116,   22,   12,   13,   14,   15,
 /*   290 */    16,  369,   61,   85,   85,  373,   33,    0,   35,   98,
 /*   300 */    99,  100,  101,  102,  103,  104,  105,  106,  107,  108,
 /*   310 */   286,  110,  111,  112,  113,  114,  115,   86,  294,   56,
 /*   320 */   334,  258,    8,    9,   61,   94,   12,   13,   14,   15,
 /*   330 */    16,   68,   12,   13,  348,  349,  350,  351,  268,  353,
 /*   340 */    20,  266,   22,  288,   47,  286,  178,  179,   85,  286,
 /*   350 */   278,  281,  293,   33,  299,   35,  332,  294,  286,  289,
 /*   360 */   278,  302,  299,  266,  301,   14,  247,  295,  286,  294,
 /*   370 */   107,   20,   20,  165,  277,  167,   56,  295,  315,  148,
 /*   380 */   325,  326,  327,    0,  121,  122,    0,  263,   68,  326,
 /*   390 */   266,  294,  337,  330,  331,  332,  333,  334,  335,  258,
 /*   400 */   337,  263,  171,  340,  266,   85,   56,  344,  345,  334,
 /*   410 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  356,
 /*   420 */   272,  273,  272,  273,  349,  350,  351,  107,  353,  166,
 /*   430 */   117,  168,  369,  225,  225,   85,  373,   87,  315,  258,
 /*   440 */   299,  121,  122,   60,  213,  214,  215,  216,  217,  218,
 /*   450 */   219,  220,  221,  222,  258,   37,  193,  194,   20,  196,
 /*   460 */   197,  198,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   470 */   207,  208,  209,  210,  211,  212,  226,    8,    9,  356,
 /*   480 */   299,   12,   13,   14,   15,   16,  166,  148,  168,  176,
 /*   490 */   177,  286,  369,  180,  151,  299,  373,    8,    9,  315,
 /*   500 */    20,   12,   13,   14,   15,   16,   88,  302,   90,   91,
 /*   510 */   171,   93,   60,  193,  194,   97,  196,  197,  198,  199,
 /*   520 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   530 */   210,  211,  212,   12,   13,   14,   14,  119,   44,   45,
 /*   540 */   356,   20,   20,   22,  258,  225,  328,  258,  197,   20,
 /*   550 */    61,   22,  213,  369,   33,   86,   35,  373,  288,    8,
 /*   560 */     9,  116,  117,   12,   13,   14,   15,   16,   20,  299,
 /*   570 */   352,  266,  286,  230,  231,  225,    0,   56,   20,   50,
 /*   580 */   294,  266,  266,   94,  285,  299,  258,  301,  299,   68,
 /*   590 */    12,   13,  277,  277,   43,  325,  326,  298,   20,  294,
 /*   600 */    22,    0,   35,    1,    2,  286,   85,  337,  286,  294,
 /*   610 */   294,   33,  326,   35,  295,  293,  330,  331,  332,  333,
 /*   620 */   334,  335,  177,  337,  302,  180,  340,  299,  107,  266,
 /*   630 */   344,  345,  346,  153,   56,   68,   60,  148,  328,  334,
 /*   640 */   277,  275,  121,  122,  358,   14,   68,  311,  294,  313,
 /*   650 */   301,   20,  366,   68,  349,  350,  351,  294,  353,  305,
 /*   660 */   171,  312,  352,   85,   63,   64,   65,   66,   67,  287,
 /*   670 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   680 */    79,   80,   81,   82,    0,  107,   20,  166,   86,  168,
 /*   690 */     8,    9,  328,  258,   12,   13,   14,   15,   16,  121,
 /*   700 */   122,  153,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   710 */   221,  222,   39,  258,  193,  194,  352,  196,  197,  198,
 /*   720 */   199,  200,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   730 */   209,  210,  211,  212,  299,    8,    9,  223,  224,   12,
 /*   740 */    13,   14,   15,   16,  166,   43,  168,   63,   64,   65,
 /*   750 */    42,   43,   22,   69,  299,  279,   72,   73,  282,   96,
 /*   760 */    76,   77,   78,  258,   68,   35,  193,  311,   86,  313,
 /*   770 */   296,  193,  194,  299,  196,  197,  198,  199,  200,  201,
 /*   780 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   790 */   212,   12,   13,   18,  296,   20,   97,  299,   68,   20,
 /*   800 */   287,   22,   27,  258,  299,   30,   35,  234,  235,  236,
 /*   810 */   237,  238,   33,   86,   35,  116,  117,  118,  119,  120,
 /*   820 */     1,    2,   47,  266,   49,  287,   51,   43,  197,  266,
 /*   830 */   266,  286,  266,  258,  277,   56,  274,  107,  276,  294,
 /*   840 */   277,  277,    2,  277,  299,    3,  301,   68,    8,    9,
 /*   850 */     0,  294,   12,   13,   14,   15,   16,  294,  294,   84,
 /*   860 */   294,    8,    9,  197,   85,   12,   13,   14,   15,   16,
 /*   870 */    86,  326,   22,   61,  299,  330,  331,  332,  333,  334,
 /*   880 */   335,    2,  337,  121,  122,  340,  107,    8,    9,  344,
 /*   890 */   345,   12,   13,   14,   15,   16,  166,  224,  168,  124,
 /*   900 */   121,  122,  127,  128,  129,  130,  131,  132,  133,  134,
 /*   910 */   135,  136,  137,  138,  139,  140,  141,  142,  143,  144,
 /*   920 */   287,  146,  147,  193,  194,  266,   43,  266,    0,   18,
 /*   930 */   258,  266,   89,  266,   23,   92,  277,   89,  277,  168,
 /*   940 */    92,   35,  277,   33,  277,  166,  244,  168,   37,   38,
 /*   950 */    22,   89,   41,  294,   92,  294,  287,   47,  315,  294,
 /*   960 */   319,  294,   52,   53,   54,   55,   56,  258,   57,   58,
 /*   970 */    59,  299,  193,  194,   68,  196,  197,  198,  199,  200,
 /*   980 */   201,  202,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   990 */   211,  212,   12,   13,   84,  286,   85,   87,  266,  356,
 /*  1000 */   266,   89,   22,  294,   92,  193,  153,  259,  299,  277,
 /*  1010 */   301,  277,  369,   33,  288,   35,  373,  153,  154,  266,
 /*  1020 */   376,  367,   85,  267,  258,  299,  294,  258,  294,   35,
 /*  1030 */   277,  258,   95,   43,  123,  326,   56,    0,  258,  330,
 /*  1040 */   331,  332,  333,  334,  335,  258,  337,  294,   68,  340,
 /*  1050 */   258,  325,  326,  344,  345,  346,    0,  322,  363,  149,
 /*  1060 */   150,    0,  152,  337,  355,  299,  156,  258,  299,  158,
 /*  1070 */   159,  160,  299,  286,  163,  258,   86,  286,  267,  299,
 /*  1080 */   169,  294,   43,   43,  242,  175,  299,  107,  301,   46,
 /*  1090 */   265,  299,  298,  182,   43,   43,  185,   43,  187,  188,
 /*  1100 */   189,  190,  191,  192,   48,  329,   43,   43,  299,   43,
 /*  1110 */   347,  354,  370,  326,  370,  370,  299,  330,  331,  332,
 /*  1120 */   333,  334,  335,  258,  337,   86,   86,  340,   85,  246,
 /*  1130 */    85,  344,  345,  346,   97,  357,  225,   86,   86,   43,
 /*  1140 */    86,  290,  355,  227,  324,   20,  166,  266,  168,   86,
 /*  1150 */    86,  286,   86,  116,  117,  118,  119,  120,   97,  294,
 /*  1160 */    43,   43,  168,   47,  299,  258,  301,  323,   35,   43,
 /*  1170 */    43,   43,  272,  193,  194,  164,  317,  116,  117,  118,
 /*  1180 */   119,  120,   86,  266,  204,  205,  206,  207,  208,  209,
 /*  1190 */   210,  326,  266,  286,   42,  330,  331,  332,  333,  334,
 /*  1200 */   335,  294,  337,   86,   86,  340,  299,  306,  301,  344,
 /*  1210 */   345,  346,   86,   86,   86,  148,  266,  304,  304,  266,
 /*  1220 */   355,  266,  315,   20,  260,  260,  258,  270,   20,  321,
 /*  1230 */   301,  270,   20,  326,  314,   20,  258,  330,  331,  332,
 /*  1240 */   333,  334,  335,  316,  337,    4,  270,  314,   20,  270,
 /*  1250 */   307,  270,  270,  266,  286,  270,  260,  286,  286,  286,
 /*  1260 */    19,  286,  294,  356,  286,  260,  299,  299,  266,  301,
 /*  1270 */   286,  268,  294,  321,   33,  286,  369,  299,  286,  301,
 /*  1280 */   373,  286,  174,  315,  286,  286,  286,  301,   47,  320,
 /*  1290 */   268,  266,   51,  258,  326,  266,  268,   56,  330,  331,
 /*  1300 */   332,  333,  334,  335,  326,  337,  232,  258,  330,  331,
 /*  1310 */   332,  333,  334,  335,  310,  337,  299,  299,  340,  299,
 /*  1320 */   314,  286,  344,  345,  356,   84,  299,  150,   87,  294,
 /*  1330 */   299,  310,  308,  307,  299,  286,  301,  369,  294,  268,
 /*  1340 */   282,  373,  294,  294,  268,   20,  299,  233,  299,  299,
 /*  1350 */   301,  310,  329,  362,  299,  362,  310,  258,  299,  299,
 /*  1360 */   239,  326,  365,  157,  241,  330,  331,  332,  333,  334,
 /*  1370 */   335,  336,  337,  338,  339,  326,  364,  258,  362,  330,
 /*  1380 */   331,  332,  333,  334,  335,  286,  337,  240,  228,  324,
 /*  1390 */   224,  361,  360,  294,  294,  359,   20,  328,  299,  245,
 /*  1400 */   301,  243,   85,  248,  371,  286,  372,  276,  299,  266,
 /*  1410 */   291,   36,  290,  294,  372,  377,  343,  268,  299,  260,
 /*  1420 */   301,  318,  261,  374,  375,  326,  313,  256,  371,  330,
 /*  1430 */   331,  332,  333,  334,  335,    0,  337,  280,  269,  340,
 /*  1440 */   372,  371,  280,  258,  345,  326,  176,  280,    0,  330,
 /*  1450 */   331,  332,  333,  334,  335,  258,  337,    0,   42,    0,
 /*  1460 */    76,    0,   35,   35,  186,  258,   35,   35,  186,    0,
 /*  1470 */   186,  286,   35,   35,    0,  186,  291,    0,   35,  294,
 /*  1480 */     0,    0,   22,  286,  299,    0,  301,   35,   85,  171,
 /*  1490 */   170,  294,  168,  286,  166,    0,  299,    0,  301,  162,
 /*  1500 */   161,  294,    0,    0,   46,    0,  299,    0,  301,    0,
 /*  1510 */   145,  326,    0,    0,    0,  330,  331,  332,  333,  334,
 /*  1520 */   335,  258,  337,  326,    0,    0,   35,  330,  331,  332,
 /*  1530 */   333,  334,  335,  326,  337,  258,  140,  330,  331,  332,
 /*  1540 */   333,  334,  335,    0,  337,  140,    0,    0,    0,  286,
 /*  1550 */    42,    0,    0,    0,    0,    0,    0,  294,    0,    0,
 /*  1560 */     0,    0,  299,  286,  301,  368,    0,    0,  291,    0,
 /*  1570 */     0,  294,    0,    0,    0,    0,  299,    0,  301,   22,
 /*  1580 */     0,    0,  375,    0,   56,    0,   56,    0,  258,  326,
 /*  1590 */     0,   42,   14,  330,  331,  332,  333,  334,  335,    0,
 /*  1600 */   337,   39,  339,  326,   40,   14,   43,  330,  331,  332,
 /*  1610 */   333,  334,  335,   19,  337,   47,  286,   46,   39,    0,
 /*  1620 */     0,  291,   46,    0,  294,   39,    0,   33,  157,  299,
 /*  1630 */   258,  301,    0,    0,    0,    0,   35,   39,    0,   35,
 /*  1640 */    47,   47,    0,   35,  258,   39,   52,   53,   54,   55,
 /*  1650 */    56,   62,   47,   39,    0,   39,  326,   35,  286,   47,
 /*  1660 */   330,  331,  332,  333,  334,  335,  294,  337,    0,    0,
 /*  1670 */     0,  299,  286,  301,    0,   35,   94,   22,   84,    0,
 /*  1680 */   294,   87,   35,   35,   92,  299,   35,  301,   35,   43,
 /*  1690 */     0,   35,   43,   35,   35,   35,    0,   22,  326,   22,
 /*  1700 */     0,   49,  330,  331,  332,  333,  334,  335,  258,  337,
 /*  1710 */    22,   35,  326,    0,  120,   35,  330,  331,  332,  333,
 /*  1720 */   334,  335,    0,  337,   35,    0,   22,   20,    0,   35,
 /*  1730 */   258,    0,   22,    0,    0,    0,  286,  153,    0,    0,
 /*  1740 */     0,    0,   39,   46,  294,   95,  152,  150,  153,  299,
 /*  1750 */   258,  301,   86,  153,   43,  229,   85,  155,  286,   86,
 /*  1760 */   172,  151,  149,   85,   43,   46,  294,  173,   85,  175,
 /*  1770 */    85,  299,   85,  301,  229,   43,  326,  181,  286,   86,
 /*  1780 */   330,  331,  332,  333,  334,  335,  294,  337,   86,   46,
 /*  1790 */    85,  299,  258,  301,   85,   43,   46,   85,  326,   43,
 /*  1800 */    86,   85,  330,  331,  332,  333,  334,  335,  258,  337,
 /*  1810 */    86,   85,   85,   46,   46,   86,   86,   43,  326,   35,
 /*  1820 */   286,   35,  330,  331,  332,  333,  334,  335,  294,  337,
 /*  1830 */   223,   86,   86,  299,   35,  301,  286,   35,  229,   35,
 /*  1840 */    35,    2,   22,   43,  294,   85,   22,   86,   85,  299,
 /*  1850 */    86,  301,   86,   46,  193,   85,   85,   85,   46,  195,
 /*  1860 */   326,  258,   85,   35,  330,  331,  332,  333,  334,  335,
 /*  1870 */    35,  337,   96,  258,   86,   85,  326,   86,   35,   85,
 /*  1880 */   330,  331,  332,  333,  334,  335,   35,  337,   85,  286,
 /*  1890 */    35,   35,   86,   22,   86,   85,   85,  294,  109,   86,
 /*  1900 */    85,  286,  299,   85,  301,  109,  109,  109,   35,  294,
 /*  1910 */    43,   97,   85,   22,  299,  258,  301,   35,   68,   62,
 /*  1920 */    61,   83,   43,   35,   35,  258,   22,   35,   35,  326,
 /*  1930 */    35,   35,   35,  330,  331,  332,  333,  334,  335,  258,
 /*  1940 */   337,  326,   68,  286,   35,  330,  331,  332,  333,  334,
 /*  1950 */   335,  294,  337,  286,   35,   35,  299,   35,  301,   35,
 /*  1960 */    35,  294,   35,   35,    0,   35,  299,  286,  301,    0,
 /*  1970 */    47,   39,   35,   47,   39,  294,    0,   35,   47,    0,
 /*  1980 */   299,   35,  301,  326,   39,   47,   39,  330,  331,  332,
 /*  1990 */   333,  334,  335,  326,  337,  258,    0,  330,  331,  332,
 /*  2000 */   333,  334,  335,   35,  337,  258,   35,  326,    0,   22,
 /*  2010 */    21,  330,  331,  332,  333,  334,  335,  258,  337,   22,
 /*  2020 */    22,   21,   20,  286,  378,  378,  378,  378,  378,  378,
 /*  2030 */   378,  294,  378,  286,  378,  378,  299,  378,  301,  378,
 /*  2040 */   378,  294,  378,  378,  378,  286,  299,  378,  301,  378,
 /*  2050 */   378,  378,  378,  294,  378,  378,  378,  378,  299,  378,
 /*  2060 */   301,  378,  378,  326,  378,  378,  378,  330,  331,  332,
 /*  2070 */   333,  334,  335,  326,  337,  378,  378,  330,  331,  332,
 /*  2080 */   333,  334,  335,  258,  337,  326,  378,  378,  378,  330,
 /*  2090 */   331,  332,  333,  334,  335,  258,  337,  378,  378,  378,
 /*  2100 */   378,  378,  378,  378,  378,  378,  378,  378,  378,  378,
 /*  2110 */   378,  286,  378,  378,  378,  378,  378,  378,  378,  294,
 /*  2120 */   378,  378,  378,  286,  299,  378,  301,  378,  378,  378,
 /*  2130 */   378,  294,  378,  378,  378,  378,  299,  378,  301,  378,
 /*  2140 */   378,  378,  378,  378,  378,  378,  378,  378,  258,  378,
 /*  2150 */   378,  326,  378,  378,  378,  330,  331,  332,  333,  334,
 /*  2160 */   335,  378,  337,  326,  378,  378,  378,  330,  331,  332,
 /*  2170 */   333,  334,  335,  378,  337,  378,  286,  378,  378,  378,
 /*  2180 */   378,  378,  378,  378,  294,  378,  378,  378,  378,  299,
 /*  2190 */   378,  301,  378,  378,  378,  378,  378,  378,  258,  378,
 /*  2200 */   378,  378,  378,  378,  378,  378,  378,  378,  258,  378,
 /*  2210 */   266,  378,  378,  378,  378,  378,  326,  378,  378,  378,
 /*  2220 */   330,  331,  332,  333,  334,  335,  286,  337,  378,  378,
 /*  2230 */   378,  378,  378,  378,  294,  378,  286,  378,  294,  299,
 /*  2240 */   378,  301,  378,  378,  294,  378,  378,  378,  378,  299,
 /*  2250 */   378,  301,  378,  378,  378,  378,  378,  378,  378,  315,
 /*  2260 */   378,  378,  378,  378,  378,  378,  326,  378,  378,  378,
 /*  2270 */   330,  331,  332,  333,  334,  335,  326,  337,  334,  378,
 /*  2280 */   330,  331,  332,  333,  334,  335,  378,  337,  378,  378,
 /*  2290 */   378,  378,  378,  349,  350,  351,  378,  353,  378,  378,
 /*  2300 */   356,  378,  378,  378,  378,  378,  378,  378,  378,  378,
 /*  2310 */   378,  378,  378,  369,  378,  378,  378,  373,
};
#define YY_SHIFT_COUNT    (665)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2008)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   911,    0,    0,   62,   62,  263,  263,  263,  320,  320,
 /*    10 */   263,  263,  521,  578,  779,  578,  578,  578,  578,  578,
 /*    20 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    30 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    40 */   578,  578,  209,  209,   35,   35,   35,  980,  980,  980,
 /*    50 */   980,  208,  350,   32,   32,  167,  167,   19,   19,   11,
 /*    60 */    38,   32,   32,  167,  167,  167,  167,  167,  167,  167,
 /*    70 */   167,  167,  182,  167,  167,  167,  230,  352,  167,  167,
 /*    80 */   352,  438,  167,  352,  352,  352,  167,  452,  775,  231,
 /*    90 */   489,  489,   13,   98,  730,  730,  730,  730,  730,  730,
 /*   100 */   730,  730,  730,  730,  730,  730,  730,  730,  730,  730,
 /*   110 */   730,  730,  730,  418,   38,  522,  522,  383,  567,  576,
 /*   120 */   480,  480,  480,  567,  558,  230,    1,    1,  352,  352,
 /*   130 */   585,  585,  663,  696,  201,  201,  201,  201,  201,  201,
 /*   140 */   201, 1594,  125,  684,  119,  573,   69,  313,  343,  351,
 /*   150 */   631,  529,  494,   39,  548,  514,  673,  514,  708,  842,
 /*   160 */   842,  842,  250,  666, 1045,  916, 1125, 1116, 1133, 1011,
 /*   170 */  1125, 1125, 1152, 1067, 1067, 1125, 1125, 1125, 1203, 1203,
 /*   180 */  1208,  182,  230,  182, 1212, 1215,  182, 1212,  182, 1228,
 /*   190 */   182,  182, 1125,  182, 1203,  352,  352,  352,  352,  352,
 /*   200 */   352,  352,  352,  352,  352,  352, 1125, 1203,  585, 1208,
 /*   210 */   452, 1108,  230,  452, 1125, 1125, 1212,  452, 1074,  585,
 /*   220 */   585,  585,  585, 1074,  585, 1177,  558, 1228,  452,  663,
 /*   230 */   452,  558, 1325,  585, 1114, 1074,  585,  585, 1114, 1074,
 /*   240 */   585,  585,  352, 1121, 1206, 1114, 1123, 1147, 1160,  916,
 /*   250 */  1166,  558, 1376, 1154, 1158, 1155, 1154, 1158, 1154, 1158,
 /*   260 */  1317, 1045,  585,  696, 1125,  452, 1375, 1203, 2318, 2318,
 /*   270 */  2318, 2318, 2318, 2318, 2318,  601,  910,  386, 1241,  469,
 /*   280 */   551,  682,  840,  879,  853,  727, 1037,  314,  314,  314,
 /*   290 */   314,  314,  314,  314,  314, 1061,  699,  274,  274,  445,
 /*   300 */    65,  108,  156,   44,  168,  602,  339,  200,  200,  200,
 /*   310 */   200,  297,  784,  843,  848,  862,  912,   57,  850,  928,
 /*   320 */    92,  864,  990, 1039, 1040, 1051, 1052, 1054, 1063,  819,
 /*   330 */   762,  702,  883, 1064,  771,  994,  812, 1066, 1043, 1096,
 /*   340 */  1117, 1118, 1126, 1127, 1128,  937,  906, 1056, 1435, 1270,
 /*   350 */  1448, 1457, 1416, 1459, 1384, 1461, 1427, 1278, 1428, 1431,
 /*   360 */  1432, 1282, 1469, 1437, 1438, 1284, 1474, 1289, 1477, 1443,
 /*   370 */  1480, 1460, 1481, 1452, 1485, 1403, 1318, 1320, 1324, 1328,
 /*   380 */  1495, 1497, 1337, 1339, 1502, 1503, 1458, 1505, 1507, 1509,
 /*   390 */  1365, 1512, 1513, 1514, 1524, 1525, 1396, 1491, 1543, 1405,
 /*   400 */  1546, 1547, 1548, 1558, 1559, 1560, 1561, 1566, 1567, 1569,
 /*   410 */  1570, 1572, 1573, 1574, 1508, 1551, 1552, 1553, 1554, 1555,
 /*   420 */  1556, 1557, 1575, 1577, 1580, 1581, 1583, 1528, 1585, 1530,
 /*   430 */  1587, 1590, 1549, 1562, 1563, 1578, 1571, 1591, 1576, 1599,
 /*   440 */  1564, 1579, 1619, 1620, 1623, 1586, 1471, 1626, 1632, 1633,
 /*   450 */  1589, 1634, 1635, 1601, 1568, 1598, 1638, 1604, 1593, 1606,
 /*   460 */  1642, 1608, 1605, 1614, 1654, 1622, 1612, 1616, 1668, 1669,
 /*   470 */  1670, 1674, 1582, 1592, 1640, 1655, 1679, 1647, 1648, 1651,
 /*   480 */  1653, 1646, 1649, 1656, 1658, 1659, 1660, 1690, 1675, 1696,
 /*   490 */  1677, 1652, 1700, 1688, 1676, 1713, 1680, 1722, 1689, 1725,
 /*   500 */  1704, 1707, 1728, 1584, 1694, 1731, 1588, 1710, 1595, 1597,
 /*   510 */  1733, 1734, 1600, 1602, 1735, 1738, 1739, 1671, 1666, 1596,
 /*   520 */  1740, 1678, 1610, 1683, 1741, 1703, 1613, 1685, 1650, 1697,
 /*   530 */  1711, 1526, 1687, 1673, 1705, 1693, 1702, 1709, 1721, 1714,
 /*   540 */  1712, 1716, 1726, 1724, 1732, 1719, 1743, 1727, 1752, 1545,
 /*   550 */  1729, 1730, 1750, 1607, 1756, 1767, 1768, 1745, 1774, 1609,
 /*   560 */  1746, 1784, 1786, 1799, 1802, 1804, 1805, 1746, 1839, 1820,
 /*   570 */  1661, 1800, 1760, 1761, 1763, 1764, 1770, 1766, 1807, 1771,
 /*   580 */  1772, 1812, 1824, 1664, 1777, 1776, 1788, 1828, 1835, 1790,
 /*   590 */  1791, 1843, 1794, 1806, 1851, 1803, 1808, 1855, 1810, 1813,
 /*   600 */  1856, 1811, 1789, 1796, 1797, 1798, 1871, 1814, 1815, 1818,
 /*   610 */  1873, 1827, 1867, 1867, 1891, 1857, 1859, 1882, 1850, 1838,
 /*   620 */  1879, 1888, 1889, 1892, 1893, 1895, 1904, 1896, 1897, 1874,
 /*   630 */  1646, 1909, 1649, 1919, 1920, 1922, 1924, 1925, 1927, 1928,
 /*   640 */  1964, 1930, 1923, 1932, 1969, 1937, 1926, 1935, 1976, 1942,
 /*   650 */  1931, 1945, 1979, 1946, 1938, 1947, 1996, 1968, 1971, 2008,
 /*   660 */  1987, 1989, 1997, 1998, 2000, 2002,
};
#define YY_REDUCE_COUNT (274)
#define YY_REDUCE_MIN   (-312)
#define YY_REDUCE_MAX   (1950)
static const short yy_reduce_ofst[] = {
 /*     0 */   -78, -232,   63,  286, -113,  709,  787,  865,  907,  968,
 /*    10 */   545,  978, 1035, 1049, 1099, 1119, 1185, 1197, 1207, 1263,
 /*    20 */  1277, 1330, 1372, 1386, 1450, 1472, 1492, 1534, 1550, 1603,
 /*    30 */  1615, 1657, 1667, 1681, 1737, 1747, 1759, 1825, 1837, 1890,
 /*    40 */  1940, 1950, -263, 1944,  -14,   75,  305, -278,   55,  270,
 /*    50 */   726, -296,  123,  184,  643, -266,  -43, -260, -256, -303,
 /*    60 */  -186, -230, -191, -185,   97,  315,  316,  363,  557,  563,
 /*    70 */   564,  566, -154,  659,  661,  665, -285, -106,  667,  732,
 /*    80 */    59,   24,  734,   72,  322,   82,  753,   70, -252, -312,
 /*    90 */  -312, -312, -117, -239, -114,  -20,  141,  181,  196,  289,
 /*   100 */   328,  435,  455,  505,  575,  672,  766,  769,  773,  780,
 /*   110 */   792,  809,  817,  299, -110,  124,  138, -220,  148, -243,
 /*   120 */   218,  310,  364,  150,  354,  349,  336,  456,  319,  205,
 /*   130 */   474,  498,  476,  562, -280, -270,  382,  513,  538,  633,
 /*   140 */   669,  641,  748,  366,  644,  654,  756,  735,  695,  791,
 /*   150 */   791,  811,  825,  794,  776,  757,  757,  757,  763,  742,
 /*   160 */   744,  745,  778,  791,  851,  820,  881,  844,  900,  859,
 /*   170 */   917,  926,  901,  913,  914,  950,  953,  955,  964,  965,
 /*   180 */   908,  957,  929,  961,  920,  927,  976,  933,  979,  943,
 /*   190 */   981,  982,  987,  985,  996,  971,  972,  973,  975,  984,
 /*   200 */   989,  992,  995,  998,  999, 1000, 1002, 1005,  967,  952,
 /*   210 */  1003,  969,  986, 1022, 1025, 1029, 1006, 1028, 1004, 1017,
 /*   220 */  1018, 1020, 1027, 1021, 1031, 1024, 1044, 1026, 1071, 1058,
 /*   230 */  1076, 1048, 1023, 1047,  991, 1041, 1050, 1055,  993, 1046,
 /*   240 */  1059, 1060,  791,  997, 1012, 1016, 1030, 1032, 1036, 1065,
 /*   250 */   757, 1100, 1069, 1034, 1033, 1038, 1042, 1057, 1068, 1070,
 /*   260 */  1073, 1122, 1109, 1131, 1143, 1149, 1161, 1159, 1103, 1113,
 /*   270 */  1157, 1162, 1167, 1169, 1171,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    10 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    20 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    30 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    40 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    50 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    60 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    70 */  1459, 1459, 1533, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*    80 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1531, 1686, 1459,
 /*    90 */  1864, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   100 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   110 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1533, 1459, 1531,
 /*   120 */  1876, 1876, 1876, 1459, 1459, 1459, 1730, 1730, 1459, 1459,
 /*   130 */  1459, 1459, 1629, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   140 */  1459, 1722, 1459, 1459, 1945, 1459, 1459, 1728, 1899, 1459,
 /*   150 */  1459, 1459, 1459, 1582, 1891, 1868, 1882, 1869, 1866, 1930,
 /*   160 */  1930, 1930, 1885, 1459, 1598, 1895, 1459, 1459, 1459, 1714,
 /*   170 */  1459, 1459, 1691, 1688, 1688, 1459, 1459, 1459, 1459, 1459,
 /*   180 */  1459, 1533, 1459, 1533, 1459, 1459, 1533, 1459, 1533, 1459,
 /*   190 */  1533, 1533, 1459, 1533, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   200 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   210 */  1531, 1724, 1459, 1531, 1459, 1459, 1459, 1531, 1904, 1459,
 /*   220 */  1459, 1459, 1459, 1904, 1459, 1459, 1459, 1459, 1531, 1459,
 /*   230 */  1531, 1459, 1459, 1459, 1906, 1904, 1459, 1459, 1906, 1904,
 /*   240 */  1459, 1459, 1459, 1918, 1914, 1906, 1922, 1920, 1897, 1895,
 /*   250 */  1882, 1459, 1459, 1936, 1932, 1948, 1936, 1932, 1936, 1932,
 /*   260 */  1459, 1598, 1459, 1459, 1459, 1531, 1491, 1459, 1716, 1730,
 /*   270 */  1632, 1632, 1632, 1534, 1464, 1459, 1459, 1459, 1459, 1459,
 /*   280 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1802, 1917, 1916,
 /*   290 */  1840, 1839, 1838, 1836, 1801, 1459, 1594, 1800, 1799, 1459,
 /*   300 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1793, 1794, 1792,
 /*   310 */  1791, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   320 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1865,
 /*   330 */  1459, 1933, 1937, 1459, 1459, 1459, 1459, 1459, 1776, 1459,
 /*   340 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   350 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   360 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   370 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   380 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   390 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   400 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   410 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   420 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   430 */  1459, 1459, 1459, 1459, 1496, 1459, 1459, 1459, 1459, 1459,
 /*   440 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   450 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   460 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   470 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   480 */  1459, 1563, 1562, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   490 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   500 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   510 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   520 */  1734, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   530 */  1898, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   540 */  1459, 1459, 1459, 1459, 1459, 1459, 1776, 1459, 1915, 1459,
 /*   550 */  1875, 1871, 1459, 1459, 1867, 1775, 1459, 1459, 1931, 1459,
 /*   560 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1860, 1459,
 /*   570 */  1459, 1833, 1818, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   580 */  1459, 1459, 1459, 1787, 1459, 1459, 1459, 1459, 1459, 1626,
 /*   590 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   600 */  1459, 1459, 1611, 1609, 1608, 1607, 1459, 1604, 1459, 1459,
 /*   610 */  1459, 1459, 1635, 1634, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   620 */  1554, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   630 */  1545, 1459, 1544, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   640 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   650 */  1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459,
 /*   660 */  1459, 1459, 1459, 1459, 1459, 1459,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /* CACHELASTSIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  249,  /*  NK_BITNOT => ID */
  249,  /*     VALUES => ID */
  249,  /*     IMPORT => ID */
  249,  /*    NK_SEMI => ID */
  249,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHELAST",
  /*   65 */ "CACHELASTSIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "FSYNC",
  /*   70 */ "MAXROWS",
  /*   71 */ "MINROWS",
  /*   72 */ "KEEP",
  /*   73 */ "PAGES",
  /*   74 */ "PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "WAL",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "NK_COLON",
  /*   84 */ "TABLE",
  /*   85 */ "NK_LP",
  /*   86 */ "NK_RP",
  /*   87 */ "STABLE",
  /*   88 */ "ADD",
  /*   89 */ "COLUMN",
  /*   90 */ "MODIFY",
  /*   91 */ "RENAME",
  /*   92 */ "TAG",
  /*   93 */ "SET",
  /*   94 */ "NK_EQ",
  /*   95 */ "USING",
  /*   96 */ "TAGS",
  /*   97 */ "COMMENT",
  /*   98 */ "BOOL",
  /*   99 */ "TINYINT",
  /*  100 */ "SMALLINT",
  /*  101 */ "INT",
  /*  102 */ "INTEGER",
  /*  103 */ "BIGINT",
  /*  104 */ "FLOAT",
  /*  105 */ "DOUBLE",
  /*  106 */ "BINARY",
  /*  107 */ "TIMESTAMP",
  /*  108 */ "NCHAR",
  /*  109 */ "UNSIGNED",
  /*  110 */ "JSON",
  /*  111 */ "VARCHAR",
  /*  112 */ "MEDIUMBLOB",
  /*  113 */ "BLOB",
  /*  114 */ "VARBINARY",
  /*  115 */ "DECIMAL",
  /*  116 */ "MAX_DELAY",
  /*  117 */ "WATERMARK",
  /*  118 */ "ROLLUP",
  /*  119 */ "TTL",
  /*  120 */ "SMA",
  /*  121 */ "FIRST",
  /*  122 */ "LAST",
  /*  123 */ "SHOW",
  /*  124 */ "DATABASES",
  /*  125 */ "TABLES",
  /*  126 */ "STABLES",
  /*  127 */ "MNODES",
  /*  128 */ "MODULES",
  /*  129 */ "QNODES",
  /*  130 */ "FUNCTIONS",
  /*  131 */ "INDEXES",
  /*  132 */ "ACCOUNTS",
  /*  133 */ "APPS",
  /*  134 */ "CONNECTIONS",
  /*  135 */ "LICENCE",
  /*  136 */ "GRANTS",
  /*  137 */ "QUERIES",
  /*  138 */ "SCORES",
  /*  139 */ "TOPICS",
  /*  140 */ "VARIABLES",
  /*  141 */ "BNODES",
  /*  142 */ "SNODES",
  /*  143 */ "CLUSTER",
  /*  144 */ "TRANSACTIONS",
  /*  145 */ "DISTRIBUTED",
  /*  146 */ "CONSUMERS",
  /*  147 */ "SUBSCRIPTIONS",
  /*  148 */ "LIKE",
  /*  149 */ "INDEX",
  /*  150 */ "FUNCTION",
  /*  151 */ "INTERVAL",
  /*  152 */ "TOPIC",
  /*  153 */ "AS",
  /*  154 */ "WITH",
  /*  155 */ "META",
  /*  156 */ "CONSUMER",
  /*  157 */ "GROUP",
  /*  158 */ "DESC",
  /*  159 */ "DESCRIBE",
  /*  160 */ "RESET",
  /*  161 */ "QUERY",
  /*  162 */ "CACHE",
  /*  163 */ "EXPLAIN",
  /*  164 */ "ANALYZE",
  /*  165 */ "VERBOSE",
  /*  166 */ "NK_BOOL",
  /*  167 */ "RATIO",
  /*  168 */ "NK_FLOAT",
  /*  169 */ "COMPACT",
  /*  170 */ "VNODES",
  /*  171 */ "IN",
  /*  172 */ "OUTPUTTYPE",
  /*  173 */ "AGGREGATE",
  /*  174 */ "BUFSIZE",
  /*  175 */ "STREAM",
  /*  176 */ "INTO",
  /*  177 */ "TRIGGER",
  /*  178 */ "AT_ONCE",
  /*  179 */ "WINDOW_CLOSE",
  /*  180 */ "IGNORE",
  /*  181 */ "EXPIRED",
  /*  182 */ "KILL",
  /*  183 */ "CONNECTION",
  /*  184 */ "TRANSACTION",
  /*  185 */ "BALANCE",
  /*  186 */ "VGROUP",
  /*  187 */ "MERGE",
  /*  188 */ "REDISTRIBUTE",
  /*  189 */ "SPLIT",
  /*  190 */ "SYNCDB",
  /*  191 */ "DELETE",
  /*  192 */ "INSERT",
  /*  193 */ "NULL",
  /*  194 */ "NK_QUESTION",
  /*  195 */ "NK_ARROW",
  /*  196 */ "ROWTS",
  /*  197 */ "TBNAME",
  /*  198 */ "QSTARTTS",
  /*  199 */ "QENDTS",
  /*  200 */ "WSTARTTS",
  /*  201 */ "WENDTS",
  /*  202 */ "WDURATION",
  /*  203 */ "CAST",
  /*  204 */ "NOW",
  /*  205 */ "TODAY",
  /*  206 */ "TIMEZONE",
  /*  207 */ "CLIENT_VERSION",
  /*  208 */ "SERVER_VERSION",
  /*  209 */ "SERVER_STATUS",
  /*  210 */ "CURRENT_USER",
  /*  211 */ "COUNT",
  /*  212 */ "LAST_ROW",
  /*  213 */ "BETWEEN",
  /*  214 */ "IS",
  /*  215 */ "NK_LT",
  /*  216 */ "NK_GT",
  /*  217 */ "NK_LE",
  /*  218 */ "NK_GE",
  /*  219 */ "NK_NE",
  /*  220 */ "MATCH",
  /*  221 */ "NMATCH",
  /*  222 */ "CONTAINS",
  /*  223 */ "JOIN",
  /*  224 */ "INNER",
  /*  225 */ "SELECT",
  /*  226 */ "DISTINCT",
  /*  227 */ "WHERE",
  /*  228 */ "PARTITION",
  /*  229 */ "BY",
  /*  230 */ "SESSION",
  /*  231 */ "STATE_WINDOW",
  /*  232 */ "SLIDING",
  /*  233 */ "FILL",
  /*  234 */ "VALUE",
  /*  235 */ "NONE",
  /*  236 */ "PREV",
  /*  237 */ "LINEAR",
  /*  238 */ "NEXT",
  /*  239 */ "HAVING",
  /*  240 */ "RANGE",
  /*  241 */ "EVERY",
  /*  242 */ "ORDER",
  /*  243 */ "SLIMIT",
  /*  244 */ "SOFFSET",
  /*  245 */ "LIMIT",
  /*  246 */ "OFFSET",
  /*  247 */ "ASC",
  /*  248 */ "NULLS",
  /*  249 */ "ID",
  /*  250 */ "NK_BITNOT",
  /*  251 */ "VALUES",
  /*  252 */ "IMPORT",
  /*  253 */ "NK_SEMI",
  /*  254 */ "FILE",
  /*  255 */ "cmd",
  /*  256 */ "account_options",
  /*  257 */ "alter_account_options",
  /*  258 */ "literal",
  /*  259 */ "alter_account_option",
  /*  260 */ "user_name",
  /*  261 */ "sysinfo_opt",
  /*  262 */ "privileges",
  /*  263 */ "priv_level",
  /*  264 */ "priv_type_list",
  /*  265 */ "priv_type",
  /*  266 */ "db_name",
  /*  267 */ "dnode_endpoint",
  /*  268 */ "not_exists_opt",
  /*  269 */ "db_options",
  /*  270 */ "exists_opt",
  /*  271 */ "alter_db_options",
  /*  272 */ "integer_list",
  /*  273 */ "variable_list",
  /*  274 */ "retention_list",
  /*  275 */ "alter_db_option",
  /*  276 */ "retention",
  /*  277 */ "full_table_name",
  /*  278 */ "column_def_list",
  /*  279 */ "tags_def_opt",
  /*  280 */ "table_options",
  /*  281 */ "multi_create_clause",
  /*  282 */ "tags_def",
  /*  283 */ "multi_drop_clause",
  /*  284 */ "alter_table_clause",
  /*  285 */ "alter_table_options",
  /*  286 */ "column_name",
  /*  287 */ "type_name",
  /*  288 */ "signed_literal",
  /*  289 */ "create_subtable_clause",
  /*  290 */ "specific_cols_opt",
  /*  291 */ "expression_list",
  /*  292 */ "drop_table_clause",
  /*  293 */ "col_name_list",
  /*  294 */ "table_name",
  /*  295 */ "column_def",
  /*  296 */ "duration_list",
  /*  297 */ "rollup_func_list",
  /*  298 */ "alter_table_option",
  /*  299 */ "duration_literal",
  /*  300 */ "rollup_func_name",
  /*  301 */ "function_name",
  /*  302 */ "col_name",
  /*  303 */ "db_name_cond_opt",
  /*  304 */ "like_pattern_opt",
  /*  305 */ "table_name_cond",
  /*  306 */ "from_db_opt",
  /*  307 */ "index_name",
  /*  308 */ "index_options",
  /*  309 */ "func_list",
  /*  310 */ "sliding_opt",
  /*  311 */ "sma_stream_opt",
  /*  312 */ "func",
  /*  313 */ "stream_options",
  /*  314 */ "topic_name",
  /*  315 */ "query_expression",
  /*  316 */ "cgroup_name",
  /*  317 */ "analyze_opt",
  /*  318 */ "explain_options",
  /*  319 */ "agg_func_opt",
  /*  320 */ "bufsize_opt",
  /*  321 */ "stream_name",
  /*  322 */ "into_opt",
  /*  323 */ "dnode_list",
  /*  324 */ "where_clause_opt",
  /*  325 */ "signed",
  /*  326 */ "literal_func",
  /*  327 */ "literal_list",
  /*  328 */ "table_alias",
  /*  329 */ "column_alias",
  /*  330 */ "expression",
  /*  331 */ "pseudo_column",
  /*  332 */ "column_reference",
  /*  333 */ "function_expression",
  /*  334 */ "subquery",
  /*  335 */ "star_func",
  /*  336 */ "star_func_para_list",
  /*  337 */ "noarg_func",
  /*  338 */ "other_para_list",
  /*  339 */ "star_func_para",
  /*  340 */ "predicate",
  /*  341 */ "compare_op",
  /*  342 */ "in_op",
  /*  343 */ "in_predicate_value",
  /*  344 */ "boolean_value_expression",
  /*  345 */ "boolean_primary",
  /*  346 */ "common_expression",
  /*  347 */ "from_clause_opt",
  /*  348 */ "table_reference_list",
  /*  349 */ "table_reference",
  /*  350 */ "table_primary",
  /*  351 */ "joined_table",
  /*  352 */ "alias_opt",
  /*  353 */ "parenthesized_joined_table",
  /*  354 */ "join_type",
  /*  355 */ "search_condition",
  /*  356 */ "query_specification",
  /*  357 */ "set_quantifier_opt",
  /*  358 */ "select_list",
  /*  359 */ "partition_by_clause_opt",
  /*  360 */ "range_opt",
  /*  361 */ "every_opt",
  /*  362 */ "fill_opt",
  /*  363 */ "twindow_clause_opt",
  /*  364 */ "group_by_clause_opt",
  /*  365 */ "having_clause_opt",
  /*  366 */ "select_item",
  /*  367 */ "fill_mode",
  /*  368 */ "group_by_list",
  /*  369 */ "query_expression_body",
  /*  370 */ "order_by_clause_opt",
  /*  371 */ "slimit_clause_opt",
  /*  372 */ "limit_clause_opt",
  /*  373 */ "query_primary",
  /*  374 */ "sort_specification_list",
  /*  375 */ "sort_specification",
  /*  376 */ "ordering_specification_opt",
  /*  377 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  75 */ "db_options ::= db_options CACHELASTSIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  80 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  82 */ "db_options ::= db_options KEEP integer_list",
 /*  83 */ "db_options ::= db_options KEEP variable_list",
 /*  84 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  85 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  89 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  90 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  91 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  92 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  93 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  94 */ "alter_db_options ::= alter_db_option",
 /*  95 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  96 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  97 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  98 */ "alter_db_option ::= CACHELASTSIZE NK_INTEGER",
 /*  99 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /* 100 */ "alter_db_option ::= KEEP integer_list",
 /* 101 */ "alter_db_option ::= KEEP variable_list",
 /* 102 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 103 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 104 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 105 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 106 */ "integer_list ::= NK_INTEGER",
 /* 107 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 108 */ "variable_list ::= NK_VARIABLE",
 /* 109 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 110 */ "retention_list ::= retention",
 /* 111 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 112 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 113 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 114 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 115 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 116 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 117 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 118 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 119 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 120 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 121 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 122 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 123 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 125 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 127 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 129 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 130 */ "multi_create_clause ::= create_subtable_clause",
 /* 131 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 132 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 133 */ "multi_drop_clause ::= drop_table_clause",
 /* 134 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 135 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 136 */ "specific_cols_opt ::=",
 /* 137 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 138 */ "full_table_name ::= table_name",
 /* 139 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 140 */ "column_def_list ::= column_def",
 /* 141 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 142 */ "column_def ::= column_name type_name",
 /* 143 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 144 */ "type_name ::= BOOL",
 /* 145 */ "type_name ::= TINYINT",
 /* 146 */ "type_name ::= SMALLINT",
 /* 147 */ "type_name ::= INT",
 /* 148 */ "type_name ::= INTEGER",
 /* 149 */ "type_name ::= BIGINT",
 /* 150 */ "type_name ::= FLOAT",
 /* 151 */ "type_name ::= DOUBLE",
 /* 152 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 153 */ "type_name ::= TIMESTAMP",
 /* 154 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 155 */ "type_name ::= TINYINT UNSIGNED",
 /* 156 */ "type_name ::= SMALLINT UNSIGNED",
 /* 157 */ "type_name ::= INT UNSIGNED",
 /* 158 */ "type_name ::= BIGINT UNSIGNED",
 /* 159 */ "type_name ::= JSON",
 /* 160 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 161 */ "type_name ::= MEDIUMBLOB",
 /* 162 */ "type_name ::= BLOB",
 /* 163 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 164 */ "type_name ::= DECIMAL",
 /* 165 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 167 */ "tags_def_opt ::=",
 /* 168 */ "tags_def_opt ::= tags_def",
 /* 169 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 170 */ "table_options ::=",
 /* 171 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 172 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 173 */ "table_options ::= table_options WATERMARK duration_list",
 /* 174 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 175 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 176 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 177 */ "alter_table_options ::= alter_table_option",
 /* 178 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 179 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 180 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 181 */ "duration_list ::= duration_literal",
 /* 182 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 183 */ "rollup_func_list ::= rollup_func_name",
 /* 184 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 185 */ "rollup_func_name ::= function_name",
 /* 186 */ "rollup_func_name ::= FIRST",
 /* 187 */ "rollup_func_name ::= LAST",
 /* 188 */ "col_name_list ::= col_name",
 /* 189 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 190 */ "col_name ::= column_name",
 /* 191 */ "cmd ::= SHOW DNODES",
 /* 192 */ "cmd ::= SHOW USERS",
 /* 193 */ "cmd ::= SHOW DATABASES",
 /* 194 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 195 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 196 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 197 */ "cmd ::= SHOW MNODES",
 /* 198 */ "cmd ::= SHOW MODULES",
 /* 199 */ "cmd ::= SHOW QNODES",
 /* 200 */ "cmd ::= SHOW FUNCTIONS",
 /* 201 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 202 */ "cmd ::= SHOW STREAMS",
 /* 203 */ "cmd ::= SHOW ACCOUNTS",
 /* 204 */ "cmd ::= SHOW APPS",
 /* 205 */ "cmd ::= SHOW CONNECTIONS",
 /* 206 */ "cmd ::= SHOW LICENCE",
 /* 207 */ "cmd ::= SHOW GRANTS",
 /* 208 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 209 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 210 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 211 */ "cmd ::= SHOW QUERIES",
 /* 212 */ "cmd ::= SHOW SCORES",
 /* 213 */ "cmd ::= SHOW TOPICS",
 /* 214 */ "cmd ::= SHOW VARIABLES",
 /* 215 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 216 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 217 */ "cmd ::= SHOW BNODES",
 /* 218 */ "cmd ::= SHOW SNODES",
 /* 219 */ "cmd ::= SHOW CLUSTER",
 /* 220 */ "cmd ::= SHOW TRANSACTIONS",
 /* 221 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 222 */ "cmd ::= SHOW CONSUMERS",
 /* 223 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 224 */ "db_name_cond_opt ::=",
 /* 225 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 226 */ "like_pattern_opt ::=",
 /* 227 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 228 */ "table_name_cond ::= table_name",
 /* 229 */ "from_db_opt ::=",
 /* 230 */ "from_db_opt ::= FROM db_name",
 /* 231 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 232 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 233 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 234 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 235 */ "func_list ::= func",
 /* 236 */ "func_list ::= func_list NK_COMMA func",
 /* 237 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 238 */ "sma_stream_opt ::=",
 /* 239 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 240 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 242 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 243 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 245 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 246 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 247 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 248 */ "cmd ::= DESC full_table_name",
 /* 249 */ "cmd ::= DESCRIBE full_table_name",
 /* 250 */ "cmd ::= RESET QUERY CACHE",
 /* 251 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 252 */ "analyze_opt ::=",
 /* 253 */ "analyze_opt ::= ANALYZE",
 /* 254 */ "explain_options ::=",
 /* 255 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 256 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 257 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 258 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 259 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 260 */ "agg_func_opt ::=",
 /* 261 */ "agg_func_opt ::= AGGREGATE",
 /* 262 */ "bufsize_opt ::=",
 /* 263 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 264 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 265 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 266 */ "into_opt ::=",
 /* 267 */ "into_opt ::= INTO full_table_name",
 /* 268 */ "stream_options ::=",
 /* 269 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 270 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 271 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 272 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 273 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 274 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 275 */ "cmd ::= KILL QUERY NK_STRING",
 /* 276 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 277 */ "cmd ::= BALANCE VGROUP",
 /* 278 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 279 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 280 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 281 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 282 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 283 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 284 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 285 */ "cmd ::= query_expression",
 /* 286 */ "cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression",
 /* 287 */ "literal ::= NK_INTEGER",
 /* 288 */ "literal ::= NK_FLOAT",
 /* 289 */ "literal ::= NK_STRING",
 /* 290 */ "literal ::= NK_BOOL",
 /* 291 */ "literal ::= TIMESTAMP NK_STRING",
 /* 292 */ "literal ::= duration_literal",
 /* 293 */ "literal ::= NULL",
 /* 294 */ "literal ::= NK_QUESTION",
 /* 295 */ "duration_literal ::= NK_VARIABLE",
 /* 296 */ "signed ::= NK_INTEGER",
 /* 297 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 298 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 299 */ "signed ::= NK_FLOAT",
 /* 300 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 301 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 302 */ "signed_literal ::= signed",
 /* 303 */ "signed_literal ::= NK_STRING",
 /* 304 */ "signed_literal ::= NK_BOOL",
 /* 305 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 306 */ "signed_literal ::= duration_literal",
 /* 307 */ "signed_literal ::= NULL",
 /* 308 */ "signed_literal ::= literal_func",
 /* 309 */ "signed_literal ::= NK_QUESTION",
 /* 310 */ "literal_list ::= signed_literal",
 /* 311 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 312 */ "db_name ::= NK_ID",
 /* 313 */ "table_name ::= NK_ID",
 /* 314 */ "column_name ::= NK_ID",
 /* 315 */ "function_name ::= NK_ID",
 /* 316 */ "table_alias ::= NK_ID",
 /* 317 */ "column_alias ::= NK_ID",
 /* 318 */ "user_name ::= NK_ID",
 /* 319 */ "index_name ::= NK_ID",
 /* 320 */ "topic_name ::= NK_ID",
 /* 321 */ "stream_name ::= NK_ID",
 /* 322 */ "cgroup_name ::= NK_ID",
 /* 323 */ "expression ::= literal",
 /* 324 */ "expression ::= pseudo_column",
 /* 325 */ "expression ::= column_reference",
 /* 326 */ "expression ::= function_expression",
 /* 327 */ "expression ::= subquery",
 /* 328 */ "expression ::= NK_LP expression NK_RP",
 /* 329 */ "expression ::= NK_PLUS expression",
 /* 330 */ "expression ::= NK_MINUS expression",
 /* 331 */ "expression ::= expression NK_PLUS expression",
 /* 332 */ "expression ::= expression NK_MINUS expression",
 /* 333 */ "expression ::= expression NK_STAR expression",
 /* 334 */ "expression ::= expression NK_SLASH expression",
 /* 335 */ "expression ::= expression NK_REM expression",
 /* 336 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 337 */ "expression ::= expression NK_BITAND expression",
 /* 338 */ "expression ::= expression NK_BITOR expression",
 /* 339 */ "expression_list ::= expression",
 /* 340 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 341 */ "column_reference ::= column_name",
 /* 342 */ "column_reference ::= table_name NK_DOT column_name",
 /* 343 */ "pseudo_column ::= ROWTS",
 /* 344 */ "pseudo_column ::= TBNAME",
 /* 345 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 346 */ "pseudo_column ::= QSTARTTS",
 /* 347 */ "pseudo_column ::= QENDTS",
 /* 348 */ "pseudo_column ::= WSTARTTS",
 /* 349 */ "pseudo_column ::= WENDTS",
 /* 350 */ "pseudo_column ::= WDURATION",
 /* 351 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 352 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 353 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 354 */ "function_expression ::= literal_func",
 /* 355 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 356 */ "literal_func ::= NOW",
 /* 357 */ "noarg_func ::= NOW",
 /* 358 */ "noarg_func ::= TODAY",
 /* 359 */ "noarg_func ::= TIMEZONE",
 /* 360 */ "noarg_func ::= DATABASE",
 /* 361 */ "noarg_func ::= CLIENT_VERSION",
 /* 362 */ "noarg_func ::= SERVER_VERSION",
 /* 363 */ "noarg_func ::= SERVER_STATUS",
 /* 364 */ "noarg_func ::= CURRENT_USER",
 /* 365 */ "noarg_func ::= USER",
 /* 366 */ "star_func ::= COUNT",
 /* 367 */ "star_func ::= FIRST",
 /* 368 */ "star_func ::= LAST",
 /* 369 */ "star_func ::= LAST_ROW",
 /* 370 */ "star_func_para_list ::= NK_STAR",
 /* 371 */ "star_func_para_list ::= other_para_list",
 /* 372 */ "other_para_list ::= star_func_para",
 /* 373 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 374 */ "star_func_para ::= expression",
 /* 375 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 376 */ "predicate ::= expression compare_op expression",
 /* 377 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 378 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 379 */ "predicate ::= expression IS NULL",
 /* 380 */ "predicate ::= expression IS NOT NULL",
 /* 381 */ "predicate ::= expression in_op in_predicate_value",
 /* 382 */ "compare_op ::= NK_LT",
 /* 383 */ "compare_op ::= NK_GT",
 /* 384 */ "compare_op ::= NK_LE",
 /* 385 */ "compare_op ::= NK_GE",
 /* 386 */ "compare_op ::= NK_NE",
 /* 387 */ "compare_op ::= NK_EQ",
 /* 388 */ "compare_op ::= LIKE",
 /* 389 */ "compare_op ::= NOT LIKE",
 /* 390 */ "compare_op ::= MATCH",
 /* 391 */ "compare_op ::= NMATCH",
 /* 392 */ "compare_op ::= CONTAINS",
 /* 393 */ "in_op ::= IN",
 /* 394 */ "in_op ::= NOT IN",
 /* 395 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 396 */ "boolean_value_expression ::= boolean_primary",
 /* 397 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 398 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 399 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 400 */ "boolean_primary ::= predicate",
 /* 401 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 402 */ "common_expression ::= expression",
 /* 403 */ "common_expression ::= boolean_value_expression",
 /* 404 */ "from_clause_opt ::=",
 /* 405 */ "from_clause_opt ::= FROM table_reference_list",
 /* 406 */ "table_reference_list ::= table_reference",
 /* 407 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 408 */ "table_reference ::= table_primary",
 /* 409 */ "table_reference ::= joined_table",
 /* 410 */ "table_primary ::= table_name alias_opt",
 /* 411 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 412 */ "table_primary ::= subquery alias_opt",
 /* 413 */ "table_primary ::= parenthesized_joined_table",
 /* 414 */ "alias_opt ::=",
 /* 415 */ "alias_opt ::= table_alias",
 /* 416 */ "alias_opt ::= AS table_alias",
 /* 417 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 418 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 419 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 420 */ "join_type ::=",
 /* 421 */ "join_type ::= INNER",
 /* 422 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 423 */ "set_quantifier_opt ::=",
 /* 424 */ "set_quantifier_opt ::= DISTINCT",
 /* 425 */ "set_quantifier_opt ::= ALL",
 /* 426 */ "select_list ::= select_item",
 /* 427 */ "select_list ::= select_list NK_COMMA select_item",
 /* 428 */ "select_item ::= NK_STAR",
 /* 429 */ "select_item ::= common_expression",
 /* 430 */ "select_item ::= common_expression column_alias",
 /* 431 */ "select_item ::= common_expression AS column_alias",
 /* 432 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 433 */ "where_clause_opt ::=",
 /* 434 */ "where_clause_opt ::= WHERE search_condition",
 /* 435 */ "partition_by_clause_opt ::=",
 /* 436 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 437 */ "twindow_clause_opt ::=",
 /* 438 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 439 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 440 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 441 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 442 */ "sliding_opt ::=",
 /* 443 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 444 */ "fill_opt ::=",
 /* 445 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 446 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 447 */ "fill_mode ::= NONE",
 /* 448 */ "fill_mode ::= PREV",
 /* 449 */ "fill_mode ::= NULL",
 /* 450 */ "fill_mode ::= LINEAR",
 /* 451 */ "fill_mode ::= NEXT",
 /* 452 */ "group_by_clause_opt ::=",
 /* 453 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 454 */ "group_by_list ::= expression",
 /* 455 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 456 */ "having_clause_opt ::=",
 /* 457 */ "having_clause_opt ::= HAVING search_condition",
 /* 458 */ "range_opt ::=",
 /* 459 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 460 */ "every_opt ::=",
 /* 461 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 462 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 463 */ "query_expression_body ::= query_primary",
 /* 464 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 465 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 466 */ "query_primary ::= query_specification",
 /* 467 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 468 */ "order_by_clause_opt ::=",
 /* 469 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 470 */ "slimit_clause_opt ::=",
 /* 471 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 472 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 473 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 474 */ "limit_clause_opt ::=",
 /* 475 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 476 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 477 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 478 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 479 */ "search_condition ::= common_expression",
 /* 480 */ "sort_specification_list ::= sort_specification",
 /* 481 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 482 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 483 */ "ordering_specification_opt ::=",
 /* 484 */ "ordering_specification_opt ::= ASC",
 /* 485 */ "ordering_specification_opt ::= DESC",
 /* 486 */ "null_ordering_opt ::=",
 /* 487 */ "null_ordering_opt ::= NULLS FIRST",
 /* 488 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 255: /* cmd */
    case 258: /* literal */
    case 269: /* db_options */
    case 271: /* alter_db_options */
    case 276: /* retention */
    case 277: /* full_table_name */
    case 280: /* table_options */
    case 284: /* alter_table_clause */
    case 285: /* alter_table_options */
    case 288: /* signed_literal */
    case 289: /* create_subtable_clause */
    case 292: /* drop_table_clause */
    case 295: /* column_def */
    case 299: /* duration_literal */
    case 300: /* rollup_func_name */
    case 302: /* col_name */
    case 303: /* db_name_cond_opt */
    case 304: /* like_pattern_opt */
    case 305: /* table_name_cond */
    case 306: /* from_db_opt */
    case 308: /* index_options */
    case 310: /* sliding_opt */
    case 311: /* sma_stream_opt */
    case 312: /* func */
    case 313: /* stream_options */
    case 315: /* query_expression */
    case 318: /* explain_options */
    case 322: /* into_opt */
    case 324: /* where_clause_opt */
    case 325: /* signed */
    case 326: /* literal_func */
    case 330: /* expression */
    case 331: /* pseudo_column */
    case 332: /* column_reference */
    case 333: /* function_expression */
    case 334: /* subquery */
    case 339: /* star_func_para */
    case 340: /* predicate */
    case 343: /* in_predicate_value */
    case 344: /* boolean_value_expression */
    case 345: /* boolean_primary */
    case 346: /* common_expression */
    case 347: /* from_clause_opt */
    case 348: /* table_reference_list */
    case 349: /* table_reference */
    case 350: /* table_primary */
    case 351: /* joined_table */
    case 353: /* parenthesized_joined_table */
    case 355: /* search_condition */
    case 356: /* query_specification */
    case 360: /* range_opt */
    case 361: /* every_opt */
    case 362: /* fill_opt */
    case 363: /* twindow_clause_opt */
    case 365: /* having_clause_opt */
    case 366: /* select_item */
    case 369: /* query_expression_body */
    case 371: /* slimit_clause_opt */
    case 372: /* limit_clause_opt */
    case 373: /* query_primary */
    case 375: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy560)); 
}
      break;
    case 256: /* account_options */
    case 257: /* alter_account_options */
    case 259: /* alter_account_option */
    case 320: /* bufsize_opt */
{
 
}
      break;
    case 260: /* user_name */
    case 263: /* priv_level */
    case 266: /* db_name */
    case 267: /* dnode_endpoint */
    case 286: /* column_name */
    case 294: /* table_name */
    case 301: /* function_name */
    case 307: /* index_name */
    case 314: /* topic_name */
    case 316: /* cgroup_name */
    case 321: /* stream_name */
    case 328: /* table_alias */
    case 329: /* column_alias */
    case 335: /* star_func */
    case 337: /* noarg_func */
    case 352: /* alias_opt */
{
 
}
      break;
    case 261: /* sysinfo_opt */
{
 
}
      break;
    case 262: /* privileges */
    case 264: /* priv_type_list */
    case 265: /* priv_type */
{
 
}
      break;
    case 268: /* not_exists_opt */
    case 270: /* exists_opt */
    case 317: /* analyze_opt */
    case 319: /* agg_func_opt */
    case 357: /* set_quantifier_opt */
{
 
}
      break;
    case 272: /* integer_list */
    case 273: /* variable_list */
    case 274: /* retention_list */
    case 278: /* column_def_list */
    case 279: /* tags_def_opt */
    case 281: /* multi_create_clause */
    case 282: /* tags_def */
    case 283: /* multi_drop_clause */
    case 290: /* specific_cols_opt */
    case 291: /* expression_list */
    case 293: /* col_name_list */
    case 296: /* duration_list */
    case 297: /* rollup_func_list */
    case 309: /* func_list */
    case 323: /* dnode_list */
    case 327: /* literal_list */
    case 336: /* star_func_para_list */
    case 338: /* other_para_list */
    case 358: /* select_list */
    case 359: /* partition_by_clause_opt */
    case 364: /* group_by_clause_opt */
    case 368: /* group_by_list */
    case 370: /* order_by_clause_opt */
    case 374: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy712)); 
}
      break;
    case 275: /* alter_db_option */
    case 298: /* alter_table_option */
{
 
}
      break;
    case 287: /* type_name */
{
 
}
      break;
    case 341: /* compare_op */
    case 342: /* in_op */
{
 
}
      break;
    case 354: /* join_type */
{
 
}
      break;
    case 367: /* fill_mode */
{
 
}
      break;
    case 376: /* ordering_specification_opt */
{
 
}
      break;
    case 377: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  255,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  255,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  256,    0 }, /* (2) account_options ::= */
  {  256,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  256,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  256,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  256,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  256,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  256,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  256,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  256,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  256,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  257,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  257,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  259,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  259,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  259,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  259,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  259,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  259,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  259,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  259,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  259,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  259,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  255,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  255,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  255,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  255,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  255,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  261,    0 }, /* (29) sysinfo_opt ::= */
  {  261,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  255,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  255,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  262,   -1 }, /* (33) privileges ::= ALL */
  {  262,   -1 }, /* (34) privileges ::= priv_type_list */
  {  264,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  264,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  265,   -1 }, /* (37) priv_type ::= READ */
  {  265,   -1 }, /* (38) priv_type ::= WRITE */
  {  263,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  263,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  255,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  255,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  255,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  255,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  255,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  255,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  255,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  255,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  267,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  267,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  267,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  255,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  255,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  255,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  255,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  255,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  255,   -2 }, /* (64) cmd ::= USE db_name */
  {  255,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  255,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  255,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  268,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  268,    0 }, /* (69) not_exists_opt ::= */
  {  270,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  270,    0 }, /* (71) exists_opt ::= */
  {  269,    0 }, /* (72) db_options ::= */
  {  269,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  269,   -3 }, /* (74) db_options ::= db_options CACHELAST NK_INTEGER */
  {  269,   -3 }, /* (75) db_options ::= db_options CACHELASTSIZE NK_INTEGER */
  {  269,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  269,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  269,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  269,   -3 }, /* (79) db_options ::= db_options FSYNC NK_INTEGER */
  {  269,   -3 }, /* (80) db_options ::= db_options MAXROWS NK_INTEGER */
  {  269,   -3 }, /* (81) db_options ::= db_options MINROWS NK_INTEGER */
  {  269,   -3 }, /* (82) db_options ::= db_options KEEP integer_list */
  {  269,   -3 }, /* (83) db_options ::= db_options KEEP variable_list */
  {  269,   -3 }, /* (84) db_options ::= db_options PAGES NK_INTEGER */
  {  269,   -3 }, /* (85) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  269,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  269,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  269,   -3 }, /* (88) db_options ::= db_options STRICT NK_INTEGER */
  {  269,   -3 }, /* (89) db_options ::= db_options WAL NK_INTEGER */
  {  269,   -3 }, /* (90) db_options ::= db_options VGROUPS NK_INTEGER */
  {  269,   -3 }, /* (91) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  269,   -3 }, /* (92) db_options ::= db_options RETENTIONS retention_list */
  {  269,   -3 }, /* (93) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  271,   -1 }, /* (94) alter_db_options ::= alter_db_option */
  {  271,   -2 }, /* (95) alter_db_options ::= alter_db_options alter_db_option */
  {  275,   -2 }, /* (96) alter_db_option ::= BUFFER NK_INTEGER */
  {  275,   -2 }, /* (97) alter_db_option ::= CACHELAST NK_INTEGER */
  {  275,   -2 }, /* (98) alter_db_option ::= CACHELASTSIZE NK_INTEGER */
  {  275,   -2 }, /* (99) alter_db_option ::= FSYNC NK_INTEGER */
  {  275,   -2 }, /* (100) alter_db_option ::= KEEP integer_list */
  {  275,   -2 }, /* (101) alter_db_option ::= KEEP variable_list */
  {  275,   -2 }, /* (102) alter_db_option ::= PAGES NK_INTEGER */
  {  275,   -2 }, /* (103) alter_db_option ::= REPLICA NK_INTEGER */
  {  275,   -2 }, /* (104) alter_db_option ::= STRICT NK_INTEGER */
  {  275,   -2 }, /* (105) alter_db_option ::= WAL NK_INTEGER */
  {  272,   -1 }, /* (106) integer_list ::= NK_INTEGER */
  {  272,   -3 }, /* (107) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  273,   -1 }, /* (108) variable_list ::= NK_VARIABLE */
  {  273,   -3 }, /* (109) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  274,   -1 }, /* (110) retention_list ::= retention */
  {  274,   -3 }, /* (111) retention_list ::= retention_list NK_COMMA retention */
  {  276,   -3 }, /* (112) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  255,   -9 }, /* (113) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  255,   -3 }, /* (114) cmd ::= CREATE TABLE multi_create_clause */
  {  255,   -9 }, /* (115) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  255,   -3 }, /* (116) cmd ::= DROP TABLE multi_drop_clause */
  {  255,   -4 }, /* (117) cmd ::= DROP STABLE exists_opt full_table_name */
  {  255,   -3 }, /* (118) cmd ::= ALTER TABLE alter_table_clause */
  {  255,   -3 }, /* (119) cmd ::= ALTER STABLE alter_table_clause */
  {  284,   -2 }, /* (120) alter_table_clause ::= full_table_name alter_table_options */
  {  284,   -5 }, /* (121) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  284,   -4 }, /* (122) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  284,   -5 }, /* (123) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  284,   -5 }, /* (124) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  284,   -5 }, /* (125) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  284,   -4 }, /* (126) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  284,   -5 }, /* (127) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  284,   -5 }, /* (128) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  284,   -6 }, /* (129) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  281,   -1 }, /* (130) multi_create_clause ::= create_subtable_clause */
  {  281,   -2 }, /* (131) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  289,  -10 }, /* (132) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  283,   -1 }, /* (133) multi_drop_clause ::= drop_table_clause */
  {  283,   -2 }, /* (134) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  292,   -2 }, /* (135) drop_table_clause ::= exists_opt full_table_name */
  {  290,    0 }, /* (136) specific_cols_opt ::= */
  {  290,   -3 }, /* (137) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  277,   -1 }, /* (138) full_table_name ::= table_name */
  {  277,   -3 }, /* (139) full_table_name ::= db_name NK_DOT table_name */
  {  278,   -1 }, /* (140) column_def_list ::= column_def */
  {  278,   -3 }, /* (141) column_def_list ::= column_def_list NK_COMMA column_def */
  {  295,   -2 }, /* (142) column_def ::= column_name type_name */
  {  295,   -4 }, /* (143) column_def ::= column_name type_name COMMENT NK_STRING */
  {  287,   -1 }, /* (144) type_name ::= BOOL */
  {  287,   -1 }, /* (145) type_name ::= TINYINT */
  {  287,   -1 }, /* (146) type_name ::= SMALLINT */
  {  287,   -1 }, /* (147) type_name ::= INT */
  {  287,   -1 }, /* (148) type_name ::= INTEGER */
  {  287,   -1 }, /* (149) type_name ::= BIGINT */
  {  287,   -1 }, /* (150) type_name ::= FLOAT */
  {  287,   -1 }, /* (151) type_name ::= DOUBLE */
  {  287,   -4 }, /* (152) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  287,   -1 }, /* (153) type_name ::= TIMESTAMP */
  {  287,   -4 }, /* (154) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  287,   -2 }, /* (155) type_name ::= TINYINT UNSIGNED */
  {  287,   -2 }, /* (156) type_name ::= SMALLINT UNSIGNED */
  {  287,   -2 }, /* (157) type_name ::= INT UNSIGNED */
  {  287,   -2 }, /* (158) type_name ::= BIGINT UNSIGNED */
  {  287,   -1 }, /* (159) type_name ::= JSON */
  {  287,   -4 }, /* (160) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  287,   -1 }, /* (161) type_name ::= MEDIUMBLOB */
  {  287,   -1 }, /* (162) type_name ::= BLOB */
  {  287,   -4 }, /* (163) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  287,   -1 }, /* (164) type_name ::= DECIMAL */
  {  287,   -4 }, /* (165) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  287,   -6 }, /* (166) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  279,    0 }, /* (167) tags_def_opt ::= */
  {  279,   -1 }, /* (168) tags_def_opt ::= tags_def */
  {  282,   -4 }, /* (169) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  280,    0 }, /* (170) table_options ::= */
  {  280,   -3 }, /* (171) table_options ::= table_options COMMENT NK_STRING */
  {  280,   -3 }, /* (172) table_options ::= table_options MAX_DELAY duration_list */
  {  280,   -3 }, /* (173) table_options ::= table_options WATERMARK duration_list */
  {  280,   -5 }, /* (174) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  280,   -3 }, /* (175) table_options ::= table_options TTL NK_INTEGER */
  {  280,   -5 }, /* (176) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  285,   -1 }, /* (177) alter_table_options ::= alter_table_option */
  {  285,   -2 }, /* (178) alter_table_options ::= alter_table_options alter_table_option */
  {  298,   -2 }, /* (179) alter_table_option ::= COMMENT NK_STRING */
  {  298,   -2 }, /* (180) alter_table_option ::= TTL NK_INTEGER */
  {  296,   -1 }, /* (181) duration_list ::= duration_literal */
  {  296,   -3 }, /* (182) duration_list ::= duration_list NK_COMMA duration_literal */
  {  297,   -1 }, /* (183) rollup_func_list ::= rollup_func_name */
  {  297,   -3 }, /* (184) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  300,   -1 }, /* (185) rollup_func_name ::= function_name */
  {  300,   -1 }, /* (186) rollup_func_name ::= FIRST */
  {  300,   -1 }, /* (187) rollup_func_name ::= LAST */
  {  293,   -1 }, /* (188) col_name_list ::= col_name */
  {  293,   -3 }, /* (189) col_name_list ::= col_name_list NK_COMMA col_name */
  {  302,   -1 }, /* (190) col_name ::= column_name */
  {  255,   -2 }, /* (191) cmd ::= SHOW DNODES */
  {  255,   -2 }, /* (192) cmd ::= SHOW USERS */
  {  255,   -2 }, /* (193) cmd ::= SHOW DATABASES */
  {  255,   -4 }, /* (194) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  255,   -4 }, /* (195) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  255,   -3 }, /* (196) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  255,   -2 }, /* (197) cmd ::= SHOW MNODES */
  {  255,   -2 }, /* (198) cmd ::= SHOW MODULES */
  {  255,   -2 }, /* (199) cmd ::= SHOW QNODES */
  {  255,   -2 }, /* (200) cmd ::= SHOW FUNCTIONS */
  {  255,   -5 }, /* (201) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  255,   -2 }, /* (202) cmd ::= SHOW STREAMS */
  {  255,   -2 }, /* (203) cmd ::= SHOW ACCOUNTS */
  {  255,   -2 }, /* (204) cmd ::= SHOW APPS */
  {  255,   -2 }, /* (205) cmd ::= SHOW CONNECTIONS */
  {  255,   -2 }, /* (206) cmd ::= SHOW LICENCE */
  {  255,   -2 }, /* (207) cmd ::= SHOW GRANTS */
  {  255,   -4 }, /* (208) cmd ::= SHOW CREATE DATABASE db_name */
  {  255,   -4 }, /* (209) cmd ::= SHOW CREATE TABLE full_table_name */
  {  255,   -4 }, /* (210) cmd ::= SHOW CREATE STABLE full_table_name */
  {  255,   -2 }, /* (211) cmd ::= SHOW QUERIES */
  {  255,   -2 }, /* (212) cmd ::= SHOW SCORES */
  {  255,   -2 }, /* (213) cmd ::= SHOW TOPICS */
  {  255,   -2 }, /* (214) cmd ::= SHOW VARIABLES */
  {  255,   -3 }, /* (215) cmd ::= SHOW LOCAL VARIABLES */
  {  255,   -4 }, /* (216) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  255,   -2 }, /* (217) cmd ::= SHOW BNODES */
  {  255,   -2 }, /* (218) cmd ::= SHOW SNODES */
  {  255,   -2 }, /* (219) cmd ::= SHOW CLUSTER */
  {  255,   -2 }, /* (220) cmd ::= SHOW TRANSACTIONS */
  {  255,   -4 }, /* (221) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  255,   -2 }, /* (222) cmd ::= SHOW CONSUMERS */
  {  255,   -2 }, /* (223) cmd ::= SHOW SUBSCRIPTIONS */
  {  303,    0 }, /* (224) db_name_cond_opt ::= */
  {  303,   -2 }, /* (225) db_name_cond_opt ::= db_name NK_DOT */
  {  304,    0 }, /* (226) like_pattern_opt ::= */
  {  304,   -2 }, /* (227) like_pattern_opt ::= LIKE NK_STRING */
  {  305,   -1 }, /* (228) table_name_cond ::= table_name */
  {  306,    0 }, /* (229) from_db_opt ::= */
  {  306,   -2 }, /* (230) from_db_opt ::= FROM db_name */
  {  255,   -8 }, /* (231) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  255,   -4 }, /* (232) cmd ::= DROP INDEX exists_opt index_name */
  {  308,  -10 }, /* (233) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  308,  -12 }, /* (234) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  309,   -1 }, /* (235) func_list ::= func */
  {  309,   -3 }, /* (236) func_list ::= func_list NK_COMMA func */
  {  312,   -4 }, /* (237) func ::= function_name NK_LP expression_list NK_RP */
  {  311,    0 }, /* (238) sma_stream_opt ::= */
  {  311,   -3 }, /* (239) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  311,   -3 }, /* (240) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  255,   -6 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  255,   -7 }, /* (242) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  255,   -9 }, /* (243) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  255,   -7 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  255,   -9 }, /* (245) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  255,   -4 }, /* (246) cmd ::= DROP TOPIC exists_opt topic_name */
  {  255,   -7 }, /* (247) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  255,   -2 }, /* (248) cmd ::= DESC full_table_name */
  {  255,   -2 }, /* (249) cmd ::= DESCRIBE full_table_name */
  {  255,   -3 }, /* (250) cmd ::= RESET QUERY CACHE */
  {  255,   -4 }, /* (251) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  317,    0 }, /* (252) analyze_opt ::= */
  {  317,   -1 }, /* (253) analyze_opt ::= ANALYZE */
  {  318,    0 }, /* (254) explain_options ::= */
  {  318,   -3 }, /* (255) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  318,   -3 }, /* (256) explain_options ::= explain_options RATIO NK_FLOAT */
  {  255,   -6 }, /* (257) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  255,  -10 }, /* (258) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  255,   -4 }, /* (259) cmd ::= DROP FUNCTION exists_opt function_name */
  {  319,    0 }, /* (260) agg_func_opt ::= */
  {  319,   -1 }, /* (261) agg_func_opt ::= AGGREGATE */
  {  320,    0 }, /* (262) bufsize_opt ::= */
  {  320,   -2 }, /* (263) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  255,   -8 }, /* (264) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  255,   -4 }, /* (265) cmd ::= DROP STREAM exists_opt stream_name */
  {  322,    0 }, /* (266) into_opt ::= */
  {  322,   -2 }, /* (267) into_opt ::= INTO full_table_name */
  {  313,    0 }, /* (268) stream_options ::= */
  {  313,   -3 }, /* (269) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  313,   -3 }, /* (270) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  313,   -4 }, /* (271) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  313,   -3 }, /* (272) stream_options ::= stream_options WATERMARK duration_literal */
  {  313,   -3 }, /* (273) stream_options ::= stream_options IGNORE EXPIRED */
  {  255,   -3 }, /* (274) cmd ::= KILL CONNECTION NK_INTEGER */
  {  255,   -3 }, /* (275) cmd ::= KILL QUERY NK_STRING */
  {  255,   -3 }, /* (276) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  255,   -2 }, /* (277) cmd ::= BALANCE VGROUP */
  {  255,   -4 }, /* (278) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  255,   -4 }, /* (279) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  255,   -3 }, /* (280) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  323,   -2 }, /* (281) dnode_list ::= DNODE NK_INTEGER */
  {  323,   -3 }, /* (282) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  255,   -3 }, /* (283) cmd ::= SYNCDB db_name REPLICA */
  {  255,   -4 }, /* (284) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  255,   -1 }, /* (285) cmd ::= query_expression */
  {  255,   -5 }, /* (286) cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression */
  {  258,   -1 }, /* (287) literal ::= NK_INTEGER */
  {  258,   -1 }, /* (288) literal ::= NK_FLOAT */
  {  258,   -1 }, /* (289) literal ::= NK_STRING */
  {  258,   -1 }, /* (290) literal ::= NK_BOOL */
  {  258,   -2 }, /* (291) literal ::= TIMESTAMP NK_STRING */
  {  258,   -1 }, /* (292) literal ::= duration_literal */
  {  258,   -1 }, /* (293) literal ::= NULL */
  {  258,   -1 }, /* (294) literal ::= NK_QUESTION */
  {  299,   -1 }, /* (295) duration_literal ::= NK_VARIABLE */
  {  325,   -1 }, /* (296) signed ::= NK_INTEGER */
  {  325,   -2 }, /* (297) signed ::= NK_PLUS NK_INTEGER */
  {  325,   -2 }, /* (298) signed ::= NK_MINUS NK_INTEGER */
  {  325,   -1 }, /* (299) signed ::= NK_FLOAT */
  {  325,   -2 }, /* (300) signed ::= NK_PLUS NK_FLOAT */
  {  325,   -2 }, /* (301) signed ::= NK_MINUS NK_FLOAT */
  {  288,   -1 }, /* (302) signed_literal ::= signed */
  {  288,   -1 }, /* (303) signed_literal ::= NK_STRING */
  {  288,   -1 }, /* (304) signed_literal ::= NK_BOOL */
  {  288,   -2 }, /* (305) signed_literal ::= TIMESTAMP NK_STRING */
  {  288,   -1 }, /* (306) signed_literal ::= duration_literal */
  {  288,   -1 }, /* (307) signed_literal ::= NULL */
  {  288,   -1 }, /* (308) signed_literal ::= literal_func */
  {  288,   -1 }, /* (309) signed_literal ::= NK_QUESTION */
  {  327,   -1 }, /* (310) literal_list ::= signed_literal */
  {  327,   -3 }, /* (311) literal_list ::= literal_list NK_COMMA signed_literal */
  {  266,   -1 }, /* (312) db_name ::= NK_ID */
  {  294,   -1 }, /* (313) table_name ::= NK_ID */
  {  286,   -1 }, /* (314) column_name ::= NK_ID */
  {  301,   -1 }, /* (315) function_name ::= NK_ID */
  {  328,   -1 }, /* (316) table_alias ::= NK_ID */
  {  329,   -1 }, /* (317) column_alias ::= NK_ID */
  {  260,   -1 }, /* (318) user_name ::= NK_ID */
  {  307,   -1 }, /* (319) index_name ::= NK_ID */
  {  314,   -1 }, /* (320) topic_name ::= NK_ID */
  {  321,   -1 }, /* (321) stream_name ::= NK_ID */
  {  316,   -1 }, /* (322) cgroup_name ::= NK_ID */
  {  330,   -1 }, /* (323) expression ::= literal */
  {  330,   -1 }, /* (324) expression ::= pseudo_column */
  {  330,   -1 }, /* (325) expression ::= column_reference */
  {  330,   -1 }, /* (326) expression ::= function_expression */
  {  330,   -1 }, /* (327) expression ::= subquery */
  {  330,   -3 }, /* (328) expression ::= NK_LP expression NK_RP */
  {  330,   -2 }, /* (329) expression ::= NK_PLUS expression */
  {  330,   -2 }, /* (330) expression ::= NK_MINUS expression */
  {  330,   -3 }, /* (331) expression ::= expression NK_PLUS expression */
  {  330,   -3 }, /* (332) expression ::= expression NK_MINUS expression */
  {  330,   -3 }, /* (333) expression ::= expression NK_STAR expression */
  {  330,   -3 }, /* (334) expression ::= expression NK_SLASH expression */
  {  330,   -3 }, /* (335) expression ::= expression NK_REM expression */
  {  330,   -3 }, /* (336) expression ::= column_reference NK_ARROW NK_STRING */
  {  330,   -3 }, /* (337) expression ::= expression NK_BITAND expression */
  {  330,   -3 }, /* (338) expression ::= expression NK_BITOR expression */
  {  291,   -1 }, /* (339) expression_list ::= expression */
  {  291,   -3 }, /* (340) expression_list ::= expression_list NK_COMMA expression */
  {  332,   -1 }, /* (341) column_reference ::= column_name */
  {  332,   -3 }, /* (342) column_reference ::= table_name NK_DOT column_name */
  {  331,   -1 }, /* (343) pseudo_column ::= ROWTS */
  {  331,   -1 }, /* (344) pseudo_column ::= TBNAME */
  {  331,   -3 }, /* (345) pseudo_column ::= table_name NK_DOT TBNAME */
  {  331,   -1 }, /* (346) pseudo_column ::= QSTARTTS */
  {  331,   -1 }, /* (347) pseudo_column ::= QENDTS */
  {  331,   -1 }, /* (348) pseudo_column ::= WSTARTTS */
  {  331,   -1 }, /* (349) pseudo_column ::= WENDTS */
  {  331,   -1 }, /* (350) pseudo_column ::= WDURATION */
  {  333,   -4 }, /* (351) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  333,   -4 }, /* (352) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  333,   -6 }, /* (353) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  333,   -1 }, /* (354) function_expression ::= literal_func */
  {  326,   -3 }, /* (355) literal_func ::= noarg_func NK_LP NK_RP */
  {  326,   -1 }, /* (356) literal_func ::= NOW */
  {  337,   -1 }, /* (357) noarg_func ::= NOW */
  {  337,   -1 }, /* (358) noarg_func ::= TODAY */
  {  337,   -1 }, /* (359) noarg_func ::= TIMEZONE */
  {  337,   -1 }, /* (360) noarg_func ::= DATABASE */
  {  337,   -1 }, /* (361) noarg_func ::= CLIENT_VERSION */
  {  337,   -1 }, /* (362) noarg_func ::= SERVER_VERSION */
  {  337,   -1 }, /* (363) noarg_func ::= SERVER_STATUS */
  {  337,   -1 }, /* (364) noarg_func ::= CURRENT_USER */
  {  337,   -1 }, /* (365) noarg_func ::= USER */
  {  335,   -1 }, /* (366) star_func ::= COUNT */
  {  335,   -1 }, /* (367) star_func ::= FIRST */
  {  335,   -1 }, /* (368) star_func ::= LAST */
  {  335,   -1 }, /* (369) star_func ::= LAST_ROW */
  {  336,   -1 }, /* (370) star_func_para_list ::= NK_STAR */
  {  336,   -1 }, /* (371) star_func_para_list ::= other_para_list */
  {  338,   -1 }, /* (372) other_para_list ::= star_func_para */
  {  338,   -3 }, /* (373) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  339,   -1 }, /* (374) star_func_para ::= expression */
  {  339,   -3 }, /* (375) star_func_para ::= table_name NK_DOT NK_STAR */
  {  340,   -3 }, /* (376) predicate ::= expression compare_op expression */
  {  340,   -5 }, /* (377) predicate ::= expression BETWEEN expression AND expression */
  {  340,   -6 }, /* (378) predicate ::= expression NOT BETWEEN expression AND expression */
  {  340,   -3 }, /* (379) predicate ::= expression IS NULL */
  {  340,   -4 }, /* (380) predicate ::= expression IS NOT NULL */
  {  340,   -3 }, /* (381) predicate ::= expression in_op in_predicate_value */
  {  341,   -1 }, /* (382) compare_op ::= NK_LT */
  {  341,   -1 }, /* (383) compare_op ::= NK_GT */
  {  341,   -1 }, /* (384) compare_op ::= NK_LE */
  {  341,   -1 }, /* (385) compare_op ::= NK_GE */
  {  341,   -1 }, /* (386) compare_op ::= NK_NE */
  {  341,   -1 }, /* (387) compare_op ::= NK_EQ */
  {  341,   -1 }, /* (388) compare_op ::= LIKE */
  {  341,   -2 }, /* (389) compare_op ::= NOT LIKE */
  {  341,   -1 }, /* (390) compare_op ::= MATCH */
  {  341,   -1 }, /* (391) compare_op ::= NMATCH */
  {  341,   -1 }, /* (392) compare_op ::= CONTAINS */
  {  342,   -1 }, /* (393) in_op ::= IN */
  {  342,   -2 }, /* (394) in_op ::= NOT IN */
  {  343,   -3 }, /* (395) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  344,   -1 }, /* (396) boolean_value_expression ::= boolean_primary */
  {  344,   -2 }, /* (397) boolean_value_expression ::= NOT boolean_primary */
  {  344,   -3 }, /* (398) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  344,   -3 }, /* (399) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  345,   -1 }, /* (400) boolean_primary ::= predicate */
  {  345,   -3 }, /* (401) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  346,   -1 }, /* (402) common_expression ::= expression */
  {  346,   -1 }, /* (403) common_expression ::= boolean_value_expression */
  {  347,    0 }, /* (404) from_clause_opt ::= */
  {  347,   -2 }, /* (405) from_clause_opt ::= FROM table_reference_list */
  {  348,   -1 }, /* (406) table_reference_list ::= table_reference */
  {  348,   -3 }, /* (407) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  349,   -1 }, /* (408) table_reference ::= table_primary */
  {  349,   -1 }, /* (409) table_reference ::= joined_table */
  {  350,   -2 }, /* (410) table_primary ::= table_name alias_opt */
  {  350,   -4 }, /* (411) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  350,   -2 }, /* (412) table_primary ::= subquery alias_opt */
  {  350,   -1 }, /* (413) table_primary ::= parenthesized_joined_table */
  {  352,    0 }, /* (414) alias_opt ::= */
  {  352,   -1 }, /* (415) alias_opt ::= table_alias */
  {  352,   -2 }, /* (416) alias_opt ::= AS table_alias */
  {  353,   -3 }, /* (417) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  353,   -3 }, /* (418) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  351,   -6 }, /* (419) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  354,    0 }, /* (420) join_type ::= */
  {  354,   -1 }, /* (421) join_type ::= INNER */
  {  356,  -12 }, /* (422) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  357,    0 }, /* (423) set_quantifier_opt ::= */
  {  357,   -1 }, /* (424) set_quantifier_opt ::= DISTINCT */
  {  357,   -1 }, /* (425) set_quantifier_opt ::= ALL */
  {  358,   -1 }, /* (426) select_list ::= select_item */
  {  358,   -3 }, /* (427) select_list ::= select_list NK_COMMA select_item */
  {  366,   -1 }, /* (428) select_item ::= NK_STAR */
  {  366,   -1 }, /* (429) select_item ::= common_expression */
  {  366,   -2 }, /* (430) select_item ::= common_expression column_alias */
  {  366,   -3 }, /* (431) select_item ::= common_expression AS column_alias */
  {  366,   -3 }, /* (432) select_item ::= table_name NK_DOT NK_STAR */
  {  324,    0 }, /* (433) where_clause_opt ::= */
  {  324,   -2 }, /* (434) where_clause_opt ::= WHERE search_condition */
  {  359,    0 }, /* (435) partition_by_clause_opt ::= */
  {  359,   -3 }, /* (436) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  363,    0 }, /* (437) twindow_clause_opt ::= */
  {  363,   -6 }, /* (438) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  363,   -4 }, /* (439) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  363,   -6 }, /* (440) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  363,   -8 }, /* (441) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  310,    0 }, /* (442) sliding_opt ::= */
  {  310,   -4 }, /* (443) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  362,    0 }, /* (444) fill_opt ::= */
  {  362,   -4 }, /* (445) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  362,   -6 }, /* (446) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  367,   -1 }, /* (447) fill_mode ::= NONE */
  {  367,   -1 }, /* (448) fill_mode ::= PREV */
  {  367,   -1 }, /* (449) fill_mode ::= NULL */
  {  367,   -1 }, /* (450) fill_mode ::= LINEAR */
  {  367,   -1 }, /* (451) fill_mode ::= NEXT */
  {  364,    0 }, /* (452) group_by_clause_opt ::= */
  {  364,   -3 }, /* (453) group_by_clause_opt ::= GROUP BY group_by_list */
  {  368,   -1 }, /* (454) group_by_list ::= expression */
  {  368,   -3 }, /* (455) group_by_list ::= group_by_list NK_COMMA expression */
  {  365,    0 }, /* (456) having_clause_opt ::= */
  {  365,   -2 }, /* (457) having_clause_opt ::= HAVING search_condition */
  {  360,    0 }, /* (458) range_opt ::= */
  {  360,   -6 }, /* (459) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  361,    0 }, /* (460) every_opt ::= */
  {  361,   -4 }, /* (461) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  315,   -4 }, /* (462) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  369,   -1 }, /* (463) query_expression_body ::= query_primary */
  {  369,   -4 }, /* (464) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  369,   -3 }, /* (465) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  373,   -1 }, /* (466) query_primary ::= query_specification */
  {  373,   -6 }, /* (467) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  370,    0 }, /* (468) order_by_clause_opt ::= */
  {  370,   -3 }, /* (469) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  371,    0 }, /* (470) slimit_clause_opt ::= */
  {  371,   -2 }, /* (471) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  371,   -4 }, /* (472) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  371,   -4 }, /* (473) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  372,    0 }, /* (474) limit_clause_opt ::= */
  {  372,   -2 }, /* (475) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  372,   -4 }, /* (476) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  372,   -4 }, /* (477) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  334,   -3 }, /* (478) subquery ::= NK_LP query_expression NK_RP */
  {  355,   -1 }, /* (479) search_condition ::= common_expression */
  {  374,   -1 }, /* (480) sort_specification_list ::= sort_specification */
  {  374,   -3 }, /* (481) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  375,   -3 }, /* (482) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  376,    0 }, /* (483) ordering_specification_opt ::= */
  {  376,   -1 }, /* (484) ordering_specification_opt ::= ASC */
  {  376,   -1 }, /* (485) ordering_specification_opt ::= DESC */
  {  377,    0 }, /* (486) null_ordering_opt ::= */
  {  377,   -2 }, /* (487) null_ordering_opt ::= NULLS FIRST */
  {  377,   -2 }, /* (488) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,256,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,257,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,256,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,258,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,259,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,257,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,259,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,258,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy533, &yymsp[-1].minor.yy0, yymsp[0].minor.yy719); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy533, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy533, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy533, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy533); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy719 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy719 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy585, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy533); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy585, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy533); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy585 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy585 = yymsp[0].minor.yy585; }
  yymsp[0].minor.yy585 = yylhsminor.yy585;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy585 = yymsp[-2].minor.yy585 | yymsp[0].minor.yy585; }
  yymsp[-2].minor.yy585 = yylhsminor.yy585;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy585 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy585 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy533 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy533 = yylhsminor.yy533;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy533 = yymsp[-2].minor.yy533; }
  yymsp[-2].minor.yy533 = yylhsminor.yy533;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy533, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy533); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 312: /* db_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* table_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* column_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* function_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* table_alias ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* column_alias ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* user_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* index_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* topic_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* stream_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 357: /* noarg_func ::= NOW */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= TODAY */ yytestcase(yyruleno==358);
      case 359: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= USER */ yytestcase(yyruleno==365);
      case 366: /* star_func ::= COUNT */ yytestcase(yyruleno==366);
      case 367: /* star_func ::= FIRST */ yytestcase(yyruleno==367);
      case 368: /* star_func ::= LAST */ yytestcase(yyruleno==368);
      case 369: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==369);
{ yylhsminor.yy533 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy533 = yylhsminor.yy533;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy173, &yymsp[-1].minor.yy533, yymsp[0].minor.yy560); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy533); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy533); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy533, yymsp[0].minor.yy560); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy533); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy533); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy173 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 252: /* analyze_opt ::= */ yytestcase(yyruleno==252);
      case 260: /* agg_func_opt ::= */ yytestcase(yyruleno==260);
      case 423: /* set_quantifier_opt ::= */ yytestcase(yyruleno==423);
{ yymsp[1].minor.yy173 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy173 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy560 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 74: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 75: /* db_options ::= db_options CACHELASTSIZE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_CACHELASTSIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 79: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 80: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 81: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 82: /* db_options ::= db_options KEEP integer_list */
      case 83: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==83);
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_KEEP, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 84: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 85: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 88: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 89: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 90: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 91: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 92: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_RETENTIONS, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 93: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy560 = setDatabaseOption(pCxt, yymsp[-2].minor.yy560, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 94: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy560 = createAlterDatabaseOptions(pCxt); yylhsminor.yy560 = setAlterDatabaseOption(pCxt, yylhsminor.yy560, &yymsp[0].minor.yy389); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 95: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy560 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy560, &yymsp[0].minor.yy389); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 96: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= CACHELASTSIZE NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_CACHELASTSIZE; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= KEEP integer_list */
      case 101: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==101);
{ yymsp[-1].minor.yy389.type = DB_OPTION_KEEP; yymsp[-1].minor.yy389.pList = yymsp[0].minor.yy712; }
        break;
      case 102: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_PAGES; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_STRICT; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy389.type = DB_OPTION_WAL; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 106: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy712 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 107: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 282: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==282);
{ yylhsminor.yy712 = addNodeToList(pCxt, yymsp[-2].minor.yy712, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 108: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy712 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 109: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy712 = addNodeToList(pCxt, yymsp[-2].minor.yy712, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 110: /* retention_list ::= retention */
      case 130: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==130);
      case 133: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==133);
      case 140: /* column_def_list ::= column_def */ yytestcase(yyruleno==140);
      case 183: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==183);
      case 188: /* col_name_list ::= col_name */ yytestcase(yyruleno==188);
      case 235: /* func_list ::= func */ yytestcase(yyruleno==235);
      case 310: /* literal_list ::= signed_literal */ yytestcase(yyruleno==310);
      case 372: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==372);
      case 426: /* select_list ::= select_item */ yytestcase(yyruleno==426);
      case 480: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==480);
{ yylhsminor.yy712 = createNodeList(pCxt, yymsp[0].minor.yy560); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 111: /* retention_list ::= retention_list NK_COMMA retention */
      case 141: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==141);
      case 184: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==184);
      case 189: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==189);
      case 236: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==236);
      case 311: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==311);
      case 373: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==373);
      case 427: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==427);
      case 481: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==481);
{ yylhsminor.yy712 = addNodeToList(pCxt, yymsp[-2].minor.yy712, yymsp[0].minor.yy560); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 112: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy560 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 113: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 115: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==115);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy173, yymsp[-5].minor.yy560, yymsp[-3].minor.yy712, yymsp[-1].minor.yy712, yymsp[0].minor.yy560); }
        break;
      case 114: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy712); }
        break;
      case 116: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy712); }
        break;
      case 117: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy173, yymsp[0].minor.yy560); }
        break;
      case 118: /* cmd ::= ALTER TABLE alter_table_clause */
      case 285: /* cmd ::= query_expression */ yytestcase(yyruleno==285);
{ pCxt->pRootNode = yymsp[0].minor.yy560; }
        break;
      case 119: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy560); }
        break;
      case 120: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy560 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 121: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy533, yymsp[0].minor.yy196); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 122: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy560 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy560, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy533); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 123: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy533, yymsp[0].minor.yy196); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 124: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy560 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy533, &yymsp[0].minor.yy533); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 125: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy533, yymsp[0].minor.yy196); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 126: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy560 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy560, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy533); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 127: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy560 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy533, yymsp[0].minor.yy196); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 128: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy560 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy560, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy533, &yymsp[0].minor.yy533); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 129: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy560 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy560, &yymsp[-2].minor.yy533, yymsp[0].minor.yy560); }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 131: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 134: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==134);
{ yylhsminor.yy712 = addNodeToList(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy560); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 132: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy560 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy173, yymsp[-8].minor.yy560, yymsp[-6].minor.yy560, yymsp[-5].minor.yy712, yymsp[-2].minor.yy712, yymsp[0].minor.yy560); }
  yymsp[-9].minor.yy560 = yylhsminor.yy560;
        break;
      case 135: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy560 = createDropTableClause(pCxt, yymsp[-1].minor.yy173, yymsp[0].minor.yy560); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 136: /* specific_cols_opt ::= */
      case 167: /* tags_def_opt ::= */ yytestcase(yyruleno==167);
      case 435: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==435);
      case 452: /* group_by_clause_opt ::= */ yytestcase(yyruleno==452);
      case 468: /* order_by_clause_opt ::= */ yytestcase(yyruleno==468);
{ yymsp[1].minor.yy712 = NULL; }
        break;
      case 137: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy712 = yymsp[-1].minor.yy712; }
        break;
      case 138: /* full_table_name ::= table_name */
{ yylhsminor.yy560 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy533, NULL); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 139: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy560 = createRealTableNode(pCxt, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy533, NULL); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 142: /* column_def ::= column_name type_name */
{ yylhsminor.yy560 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy533, yymsp[0].minor.yy196, NULL); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 143: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy560 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy533, yymsp[-2].minor.yy196, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 144: /* type_name ::= BOOL */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 145: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 146: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 147: /* type_name ::= INT */
      case 148: /* type_name ::= INTEGER */ yytestcase(yyruleno==148);
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 149: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 150: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 151: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 152: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy196 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 153: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 154: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy196 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 155: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy196 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 156: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy196 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 157: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy196 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 158: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy196 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 159: /* type_name ::= JSON */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 160: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy196 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 161: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 162: /* type_name ::= BLOB */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 163: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy196 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 164: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy196 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 165: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy196 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 166: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy196 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 168: /* tags_def_opt ::= tags_def */
      case 371: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==371);
{ yylhsminor.yy712 = yymsp[0].minor.yy712; }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 169: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy712 = yymsp[-1].minor.yy712; }
        break;
      case 170: /* table_options ::= */
{ yymsp[1].minor.yy560 = createDefaultTableOptions(pCxt); }
        break;
      case 171: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 172: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 173: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 174: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-4].minor.yy560, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy712); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 175: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-2].minor.yy560, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 176: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-4].minor.yy560, TABLE_OPTION_SMA, yymsp[-1].minor.yy712); }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 177: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy560 = createAlterTableOptions(pCxt); yylhsminor.yy560 = setTableOption(pCxt, yylhsminor.yy560, yymsp[0].minor.yy389.type, &yymsp[0].minor.yy389.val); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 178: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy560 = setTableOption(pCxt, yymsp[-1].minor.yy560, yymsp[0].minor.yy389.type, &yymsp[0].minor.yy389.val); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 179: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy389.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 180: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy389.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy389.val = yymsp[0].minor.yy0; }
        break;
      case 181: /* duration_list ::= duration_literal */
      case 339: /* expression_list ::= expression */ yytestcase(yyruleno==339);
{ yylhsminor.yy712 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy560)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 182: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 340: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==340);
{ yylhsminor.yy712 = addNodeToList(pCxt, yymsp[-2].minor.yy712, releaseRawExprNode(pCxt, yymsp[0].minor.yy560)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 185: /* rollup_func_name ::= function_name */
{ yylhsminor.yy560 = createFunctionNode(pCxt, &yymsp[0].minor.yy533, NULL); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 186: /* rollup_func_name ::= FIRST */
      case 187: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==187);
{ yylhsminor.yy560 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 190: /* col_name ::= column_name */
{ yylhsminor.yy560 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy533); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 191: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 192: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 193: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 194: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy560, yymsp[0].minor.yy560, OP_TYPE_LIKE); }
        break;
      case 195: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy560, yymsp[0].minor.yy560, OP_TYPE_LIKE); }
        break;
      case 196: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy560, NULL, OP_TYPE_LIKE); }
        break;
      case 197: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 198: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 199: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 200: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 201: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy560, yymsp[-1].minor.yy560, OP_TYPE_EQUAL); }
        break;
      case 202: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 203: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 204: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 205: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 206: /* cmd ::= SHOW LICENCE */
      case 207: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==207);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 208: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy533); }
        break;
      case 209: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy560); }
        break;
      case 210: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy560); }
        break;
      case 211: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 212: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 213: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 214: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 215: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 216: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 217: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 218: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 219: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 220: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 221: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy560); }
        break;
      case 222: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 223: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 224: /* db_name_cond_opt ::= */
      case 229: /* from_db_opt ::= */ yytestcase(yyruleno==229);
{ yymsp[1].minor.yy560 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 225: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy533); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 226: /* like_pattern_opt ::= */
      case 266: /* into_opt ::= */ yytestcase(yyruleno==266);
      case 404: /* from_clause_opt ::= */ yytestcase(yyruleno==404);
      case 433: /* where_clause_opt ::= */ yytestcase(yyruleno==433);
      case 437: /* twindow_clause_opt ::= */ yytestcase(yyruleno==437);
      case 442: /* sliding_opt ::= */ yytestcase(yyruleno==442);
      case 444: /* fill_opt ::= */ yytestcase(yyruleno==444);
      case 456: /* having_clause_opt ::= */ yytestcase(yyruleno==456);
      case 458: /* range_opt ::= */ yytestcase(yyruleno==458);
      case 460: /* every_opt ::= */ yytestcase(yyruleno==460);
      case 470: /* slimit_clause_opt ::= */ yytestcase(yyruleno==470);
      case 474: /* limit_clause_opt ::= */ yytestcase(yyruleno==474);
{ yymsp[1].minor.yy560 = NULL; }
        break;
      case 227: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 228: /* table_name_cond ::= table_name */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy533); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 230: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy533); }
        break;
      case 231: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy173, &yymsp[-3].minor.yy533, &yymsp[-1].minor.yy533, NULL, yymsp[0].minor.yy560); }
        break;
      case 232: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy533); }
        break;
      case 233: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy560 = createIndexOption(pCxt, yymsp[-7].minor.yy712, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), NULL, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 234: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy560 = createIndexOption(pCxt, yymsp[-9].minor.yy712, releaseRawExprNode(pCxt, yymsp[-5].minor.yy560), releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 237: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy560 = createFunctionNode(pCxt, &yymsp[-3].minor.yy533, yymsp[-1].minor.yy712); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 238: /* sma_stream_opt ::= */
      case 268: /* stream_options ::= */ yytestcase(yyruleno==268);
{ yymsp[1].minor.yy560 = createStreamOptions(pCxt); }
        break;
      case 239: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 272: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==272);
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 240: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy173, &yymsp[-2].minor.yy533, yymsp[0].minor.yy560); }
        break;
      case 242: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy173, &yymsp[-3].minor.yy533, &yymsp[0].minor.yy533, false); }
        break;
      case 243: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy173, &yymsp[-5].minor.yy533, &yymsp[0].minor.yy533, true); }
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy173, &yymsp[-3].minor.yy533, yymsp[0].minor.yy560, false); }
        break;
      case 245: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy173, &yymsp[-5].minor.yy533, yymsp[0].minor.yy560, true); }
        break;
      case 246: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy533); }
        break;
      case 247: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy173, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy533); }
        break;
      case 248: /* cmd ::= DESC full_table_name */
      case 249: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==249);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy560); }
        break;
      case 250: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 251: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy173, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 253: /* analyze_opt ::= ANALYZE */
      case 261: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==261);
      case 424: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==424);
{ yymsp[0].minor.yy173 = true; }
        break;
      case 254: /* explain_options ::= */
{ yymsp[1].minor.yy560 = createDefaultExplainOptions(pCxt); }
        break;
      case 255: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy560 = setExplainVerbose(pCxt, yymsp[-2].minor.yy560, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 256: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy560 = setExplainRatio(pCxt, yymsp[-2].minor.yy560, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 257: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy712); }
        break;
      case 258: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy173, yymsp[-8].minor.yy173, &yymsp[-5].minor.yy533, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy196, yymsp[0].minor.yy424); }
        break;
      case 259: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy533); }
        break;
      case 262: /* bufsize_opt ::= */
{ yymsp[1].minor.yy424 = 0; }
        break;
      case 263: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy424 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 264: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy173, &yymsp[-4].minor.yy533, yymsp[-2].minor.yy560, yymsp[-3].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 265: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy533); }
        break;
      case 267: /* into_opt ::= INTO full_table_name */
      case 405: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==405);
      case 434: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==434);
      case 457: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==457);
{ yymsp[-1].minor.yy560 = yymsp[0].minor.yy560; }
        break;
      case 269: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 270: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 271: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy560)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy560)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); yylhsminor.yy560 = yymsp[-3].minor.yy560; }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 273: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy560)->ignoreExpired = true; yylhsminor.yy560 = yymsp[-2].minor.yy560; }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 274: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 275: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 276: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 277: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 278: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy712); }
        break;
      case 280: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 281: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy712 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 283: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy533); }
        break;
      case 284: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 286: /* cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-2].minor.yy560, yymsp[-1].minor.yy712, yymsp[0].minor.yy560); }
        break;
      case 287: /* literal ::= NK_INTEGER */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 288: /* literal ::= NK_FLOAT */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 289: /* literal ::= NK_STRING */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 290: /* literal ::= NK_BOOL */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 291: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 292: /* literal ::= duration_literal */
      case 302: /* signed_literal ::= signed */ yytestcase(yyruleno==302);
      case 323: /* expression ::= literal */ yytestcase(yyruleno==323);
      case 324: /* expression ::= pseudo_column */ yytestcase(yyruleno==324);
      case 325: /* expression ::= column_reference */ yytestcase(yyruleno==325);
      case 326: /* expression ::= function_expression */ yytestcase(yyruleno==326);
      case 327: /* expression ::= subquery */ yytestcase(yyruleno==327);
      case 354: /* function_expression ::= literal_func */ yytestcase(yyruleno==354);
      case 396: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==396);
      case 400: /* boolean_primary ::= predicate */ yytestcase(yyruleno==400);
      case 402: /* common_expression ::= expression */ yytestcase(yyruleno==402);
      case 403: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==403);
      case 406: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==406);
      case 408: /* table_reference ::= table_primary */ yytestcase(yyruleno==408);
      case 409: /* table_reference ::= joined_table */ yytestcase(yyruleno==409);
      case 413: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==413);
      case 463: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==463);
      case 466: /* query_primary ::= query_specification */ yytestcase(yyruleno==466);
{ yylhsminor.yy560 = yymsp[0].minor.yy560; }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 293: /* literal ::= NULL */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 294: /* literal ::= NK_QUESTION */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 295: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 296: /* signed ::= NK_INTEGER */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 297: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 298: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 299: /* signed ::= NK_FLOAT */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 300: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 301: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 303: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 304: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 305: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 306: /* signed_literal ::= duration_literal */
      case 308: /* signed_literal ::= literal_func */ yytestcase(yyruleno==308);
      case 374: /* star_func_para ::= expression */ yytestcase(yyruleno==374);
      case 429: /* select_item ::= common_expression */ yytestcase(yyruleno==429);
      case 479: /* search_condition ::= common_expression */ yytestcase(yyruleno==479);
{ yylhsminor.yy560 = releaseRawExprNode(pCxt, yymsp[0].minor.yy560); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 307: /* signed_literal ::= NULL */
{ yylhsminor.yy560 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 309: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy560 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 328: /* expression ::= NK_LP expression NK_RP */
      case 401: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==401);
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 329: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy560));
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 330: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy560), NULL));
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 331: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 332: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 333: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 334: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 335: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 336: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 337: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 338: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 341: /* column_reference ::= column_name */
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy533, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy533)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 342: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy533, createColumnNode(pCxt, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy533)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 343: /* pseudo_column ::= ROWTS */
      case 344: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==344);
      case 346: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==346);
      case 347: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==347);
      case 348: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==348);
      case 349: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==349);
      case 350: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==350);
      case 356: /* literal_func ::= NOW */ yytestcase(yyruleno==356);
{ yylhsminor.yy560 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 345: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy533)))); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 351: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 352: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==352);
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy533, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy533, yymsp[-1].minor.yy712)); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 353: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), yymsp[-1].minor.yy196)); }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 355: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy533, NULL)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 370: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy712 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 375: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 432: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==432);
{ yylhsminor.yy560 = createColumnNode(pCxt, &yymsp[-2].minor.yy533, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 376: /* predicate ::= expression compare_op expression */
      case 381: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==381);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy128, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 377: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy560), releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-4].minor.yy560 = yylhsminor.yy560;
        break;
      case 378: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy560), releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 379: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), NULL));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 380: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), NULL));
                                                                                  }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 382: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_THAN; }
        break;
      case 383: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_THAN; }
        break;
      case 384: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 385: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 386: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy128 = OP_TYPE_NOT_EQUAL; }
        break;
      case 387: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy128 = OP_TYPE_EQUAL; }
        break;
      case 388: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy128 = OP_TYPE_LIKE; }
        break;
      case 389: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_LIKE; }
        break;
      case 390: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_MATCH; }
        break;
      case 391: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_NMATCH; }
        break;
      case 392: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy128 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 393: /* in_op ::= IN */
{ yymsp[0].minor.yy128 = OP_TYPE_IN; }
        break;
      case 394: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_IN; }
        break;
      case 395: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy712)); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 397: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy560), NULL));
                                                                                  }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 398: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 399: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy560);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy560);
                                                                                    yylhsminor.yy560 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), releaseRawExprNode(pCxt, yymsp[0].minor.yy560)));
                                                                                  }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 407: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy560 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy560, yymsp[0].minor.yy560, NULL); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 410: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy560 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy533, &yymsp[0].minor.yy533); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 411: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy560 = createRealTableNode(pCxt, &yymsp[-3].minor.yy533, &yymsp[-1].minor.yy533, &yymsp[0].minor.yy533); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 412: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy560 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560), &yymsp[0].minor.yy533); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 414: /* alias_opt ::= */
{ yymsp[1].minor.yy533 = nil_token;  }
        break;
      case 415: /* alias_opt ::= table_alias */
{ yylhsminor.yy533 = yymsp[0].minor.yy533; }
  yymsp[0].minor.yy533 = yylhsminor.yy533;
        break;
      case 416: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy533 = yymsp[0].minor.yy533; }
        break;
      case 417: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 418: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==418);
{ yymsp[-2].minor.yy560 = yymsp[-1].minor.yy560; }
        break;
      case 419: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy560 = createJoinTableNode(pCxt, yymsp[-4].minor.yy36, yymsp[-5].minor.yy560, yymsp[-2].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-5].minor.yy560 = yylhsminor.yy560;
        break;
      case 420: /* join_type ::= */
{ yymsp[1].minor.yy36 = JOIN_TYPE_INNER; }
        break;
      case 421: /* join_type ::= INNER */
{ yymsp[0].minor.yy36 = JOIN_TYPE_INNER; }
        break;
      case 422: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy560 = createSelectStmt(pCxt, yymsp[-10].minor.yy173, yymsp[-9].minor.yy712, yymsp[-8].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addWhereClause(pCxt, yymsp[-11].minor.yy560, yymsp[-7].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addPartitionByClause(pCxt, yymsp[-11].minor.yy560, yymsp[-6].minor.yy712);
                                                                                    yymsp[-11].minor.yy560 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy560, yymsp[-2].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addGroupByClause(pCxt, yymsp[-11].minor.yy560, yymsp[-1].minor.yy712);
                                                                                    yymsp[-11].minor.yy560 = addHavingClause(pCxt, yymsp[-11].minor.yy560, yymsp[0].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addRangeClause(pCxt, yymsp[-11].minor.yy560, yymsp[-5].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addEveryClause(pCxt, yymsp[-11].minor.yy560, yymsp[-4].minor.yy560);
                                                                                    yymsp[-11].minor.yy560 = addFillClause(pCxt, yymsp[-11].minor.yy560, yymsp[-3].minor.yy560);
                                                                                  }
        break;
      case 425: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy173 = false; }
        break;
      case 428: /* select_item ::= NK_STAR */
{ yylhsminor.yy560 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy560 = yylhsminor.yy560;
        break;
      case 430: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy560 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560), &yymsp[0].minor.yy533); }
  yymsp[-1].minor.yy560 = yylhsminor.yy560;
        break;
      case 431: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy560 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), &yymsp[0].minor.yy533); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 436: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 453: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==453);
      case 469: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==469);
{ yymsp[-2].minor.yy712 = yymsp[0].minor.yy712; }
        break;
      case 438: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy560 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
        break;
      case 439: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy560 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
        break;
      case 440: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy560 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), NULL, yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 441: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy560 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy560), releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), yymsp[-1].minor.yy560, yymsp[0].minor.yy560); }
        break;
      case 443: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 461: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==461);
{ yymsp[-3].minor.yy560 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy560); }
        break;
      case 445: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy560 = createFillNode(pCxt, yymsp[-1].minor.yy18, NULL); }
        break;
      case 446: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy560 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy712)); }
        break;
      case 447: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy18 = FILL_MODE_NONE; }
        break;
      case 448: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy18 = FILL_MODE_PREV; }
        break;
      case 449: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy18 = FILL_MODE_NULL; }
        break;
      case 450: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy18 = FILL_MODE_LINEAR; }
        break;
      case 451: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy18 = FILL_MODE_NEXT; }
        break;
      case 454: /* group_by_list ::= expression */
{ yylhsminor.yy712 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 455: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy712 = addNodeToList(pCxt, yymsp[-2].minor.yy712, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy560))); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 459: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy560 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy560), releaseRawExprNode(pCxt, yymsp[-1].minor.yy560)); }
        break;
      case 462: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy560 = addOrderByClause(pCxt, yymsp[-3].minor.yy560, yymsp[-2].minor.yy712);
                                                                                    yylhsminor.yy560 = addSlimitClause(pCxt, yylhsminor.yy560, yymsp[-1].minor.yy560);
                                                                                    yylhsminor.yy560 = addLimitClause(pCxt, yylhsminor.yy560, yymsp[0].minor.yy560);
                                                                                  }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 464: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy560 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-3].minor.yy560 = yylhsminor.yy560;
        break;
      case 465: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy560 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy560, yymsp[0].minor.yy560); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 467: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy560 = addOrderByClause(pCxt, yymsp[-4].minor.yy560, yymsp[-3].minor.yy712);
                                                                                    yymsp[-5].minor.yy560 = addSlimitClause(pCxt, yymsp[-5].minor.yy560, yymsp[-2].minor.yy560);
                                                                                    yymsp[-5].minor.yy560 = addLimitClause(pCxt, yymsp[-5].minor.yy560, yymsp[-1].minor.yy560);
                                                                                  }
        break;
      case 471: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 475: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==475);
{ yymsp[-1].minor.yy560 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 472: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 476: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==476);
{ yymsp[-3].minor.yy560 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 473: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 477: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==477);
{ yymsp[-3].minor.yy560 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 478: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy560 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy560); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 482: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy560 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy560), yymsp[-1].minor.yy218, yymsp[0].minor.yy109); }
  yymsp[-2].minor.yy560 = yylhsminor.yy560;
        break;
      case 483: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy218 = ORDER_ASC; }
        break;
      case 484: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy218 = ORDER_ASC; }
        break;
      case 485: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy218 = ORDER_DESC; }
        break;
      case 486: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy109 = NULL_ORDER_DEFAULT; }
        break;
      case 487: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_FIRST; }
        break;
      case 488: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
