import sys
from util.log import *
from util.cases import *
from util.sql import *
from util.dnodes import tdDnodes
from math import inf, nan


class TDTestCase:
    def caseDescription(self):
        """
        case1<shenglian zhou>: [TD-14122]: fix failed test on arm64 by converting from sim tst to python test to overcome NaN value and its string representation
        """
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)
        self._conn = conn

    def restartTaosd(self, index=1, dbname="db"):
        tdDnodes.stop(index)
        tdDnodes.startWithoutSleep(index)
        tdSql.execute(f"use db0")

    def run(self):
        print("running {}".format(__file__))
        tdSql.execute("drop database if exists db0")
        tdSql.execute("create database if not exists db0")
        tdSql.execute("use db0")
        tdSql.execute(
            "create table st0 (ts timestamp, c1 int, c2 float, c3 bigint, c4 smallint, c5 tinyint, c6 double, c7 bool, c8 nchar(5), c9 binary(10)) TAGS (tgcol int);"
        )

        tdSql.execute("create table ct0 using st0 tags( 0 );")
        tdSql.execute(
            "insert into ct0 values (1601481600000 , 0 , 0.25 , 0 , 0 , 0 , 0.25 , 0 , 0 , 0 );"
        )
        for i in range(1, 50):
            tdSql.execute(
                "insert into ct0 values ({}, {}, {}, {}, {}, {}, {}, {}, {}, {});".format(
                    1601481600000 + i * 60000, i, i, i, i, i, i, i, i, i
                )
            )

        tdSql.execute("create table ct1 using st0 tags( 1 );")
        tdSql.execute(
            "insert into ct1 values (1601481600000 , 0 , 0.25 , 0 , 0 , 0 , 0.25 , 0 , 0 , 0 );"
        )
        for i in range(1, 50):
            tdSql.execute(
                "insert into ct1 values ({}, {}, {}, {}, {}, {}, {}, {}, {}, {});".format(
                    1601481600000 + i * 60000, i, i, i, i, i, i, i, i, i
                )
            )

        tdSql.query(
            "select c1, sin(c1), cos(c1), tan(c1), asin(c1), acos(c1), atan(c1) from ct1;"
        )
        tdSql.checkRows(50)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, 0.0)
        tdSql.checkData(0, 4, 0.0)
        tdSql.checkData(0, 5, 1.5707963267948966)
        tdSql.checkData(0, 6, 0.0)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.8414709848078965)
        tdSql.checkData(1, 2, 0.5403023058681398)
        tdSql.checkData(1, 3, 1.5574077246549023)
        tdSql.checkData(1, 4, 1.5707963267948966)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, 0.7853981633974483)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(2, 1, 0.9092974268256817)
        tdSql.checkData(2, 2, -0.4161468365471424)
        tdSql.checkData(2, 3, -2.185039863261519)
        tdSql.checkData(2, 4, nan)
        tdSql.checkData(2, 5, nan)
        tdSql.checkData(2, 6, 1.1071487177940904)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, 0.1411200080598672)
        tdSql.checkData(3, 2, -0.9899924966004454)
        tdSql.checkData(3, 3, -0.1425465430742778)
        tdSql.checkData(3, 4, nan)
        tdSql.checkData(3, 5, nan)
        tdSql.checkData(3, 6, 1.2490457723982544)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, -0.7568024953079282)
        tdSql.checkData(4, 2, -0.6536436208636119)
        tdSql.checkData(4, 3, 1.1578212823495775)
        tdSql.checkData(4, 4, nan)
        tdSql.checkData(4, 5, nan)
        tdSql.checkData(4, 6, 1.3258176636680326)
        tdSql.checkData(5, 0, 5)
        tdSql.checkData(5, 1, -0.9589242746631385)
        tdSql.checkData(5, 2, 0.28366218546322625)
        tdSql.checkData(5, 3, -3.380515006246586)
        tdSql.checkData(5, 4, nan)
        tdSql.checkData(5, 5, nan)
        tdSql.checkData(5, 6, 1.373400766945016)
        tdSql.checkData(6, 0, 6)
        tdSql.checkData(6, 1, -0.27941549819892586)
        tdSql.checkData(6, 2, 0.960170286650366)
        tdSql.checkData(6, 3, -0.29100619138474915)
        tdSql.checkData(6, 4, nan)
        tdSql.checkData(6, 5, nan)
        tdSql.checkData(6, 6, 1.4056476493802699)
        tdSql.checkData(7, 0, 7)
        tdSql.checkData(7, 1, 0.6569865987187891)
        tdSql.checkData(7, 2, 0.7539022543433046)
        tdSql.checkData(7, 3, 0.8714479827243188)
        tdSql.checkData(7, 4, nan)
        tdSql.checkData(7, 5, nan)
        tdSql.checkData(7, 6, 1.4288992721907328)
        tdSql.checkData(8, 0, 8)
        tdSql.checkData(8, 1, 0.9893582466233818)
        tdSql.checkData(8, 2, -0.14550003380861354)
        tdSql.checkData(8, 3, -6.799711455220379)
        tdSql.checkData(8, 4, nan)
        tdSql.checkData(8, 5, nan)
        tdSql.checkData(8, 6, 1.446441332248135)
        tdSql.checkData(9, 0, 9)
        tdSql.checkData(9, 1, 0.4121184852417566)
        tdSql.checkData(9, 2, -0.9111302618846769)
        tdSql.checkData(9, 3, -0.45231565944180985)
        tdSql.checkData(9, 4, nan)
        tdSql.checkData(9, 5, nan)
        tdSql.checkData(9, 6, 1.460139105621001)
        tdSql.checkData(10, 0, 10)
        tdSql.checkData(10, 1, -0.5440211108893698)
        tdSql.checkData(10, 2, -0.8390715290764524)
        tdSql.checkData(10, 3, 0.6483608274590866)
        tdSql.checkData(10, 4, nan)
        tdSql.checkData(10, 5, nan)
        tdSql.checkData(10, 6, 1.4711276743037347)
        tdSql.checkData(11, 0, 11)
        tdSql.checkData(11, 1, -0.9999902065507035)
        tdSql.checkData(11, 2, 0.004425697988050785)
        tdSql.checkData(11, 3, -225.95084645419513)
        tdSql.checkData(11, 4, nan)
        tdSql.checkData(11, 5, nan)
        tdSql.checkData(11, 6, 1.4801364395941514)
        tdSql.checkData(12, 0, 12)
        tdSql.checkData(12, 1, -0.5365729180004349)
        tdSql.checkData(12, 2, 0.8438539587324921)
        tdSql.checkData(12, 3, -0.6358599286615808)
        tdSql.checkData(12, 4, nan)
        tdSql.checkData(12, 5, nan)
        tdSql.checkData(12, 6, 1.4876550949064553)
        tdSql.checkData(13, 0, 13)
        tdSql.checkData(13, 1, 0.4201670368266409)
        tdSql.checkData(13, 2, 0.9074467814501962)
        tdSql.checkData(13, 3, 0.4630211329364896)
        tdSql.checkData(13, 4, nan)
        tdSql.checkData(13, 5, nan)
        tdSql.checkData(13, 6, 1.4940244355251187)
        tdSql.checkData(14, 0, 14)
        tdSql.checkData(14, 1, 0.9906073556948704)
        tdSql.checkData(14, 2, 0.1367372182078336)
        tdSql.checkData(14, 3, 7.2446066160948055)
        tdSql.checkData(14, 4, nan)
        tdSql.checkData(14, 5, nan)
        tdSql.checkData(14, 6, 1.4994888620096063)
        tdSql.checkData(15, 0, 15)
        tdSql.checkData(15, 1, 0.6502878401571168)
        tdSql.checkData(15, 2, -0.7596879128588213)
        tdSql.checkData(15, 3, -0.8559934009085187)
        tdSql.checkData(15, 4, nan)
        tdSql.checkData(15, 5, nan)
        tdSql.checkData(15, 6, 1.5042281630190728)
        tdSql.checkData(16, 0, 16)
        tdSql.checkData(16, 1, -0.2879033166650653)
        tdSql.checkData(16, 2, -0.9576594803233847)
        tdSql.checkData(16, 3, 0.3006322420239034)
        tdSql.checkData(16, 4, nan)
        tdSql.checkData(16, 5, nan)
        tdSql.checkData(16, 6, 1.5083775167989393)
        tdSql.checkData(17, 0, 17)
        tdSql.checkData(17, 1, -0.9613974918795568)
        tdSql.checkData(17, 2, -0.27516333805159693)
        tdSql.checkData(17, 3, 3.49391564547484)
        tdSql.checkData(17, 4, nan)
        tdSql.checkData(17, 5, nan)
        tdSql.checkData(17, 6, 1.512040504079174)
        tdSql.checkData(18, 0, 18)
        tdSql.checkData(18, 1, -0.750987246771676)
        tdSql.checkData(18, 2, 0.6603167082440802)
        tdSql.checkData(18, 3, -1.1373137123376869)
        tdSql.checkData(18, 4, nan)
        tdSql.checkData(18, 5, nan)
        tdSql.checkData(18, 6, 1.5152978215491797)
        tdSql.checkData(19, 0, 19)
        tdSql.checkData(19, 1, 0.14987720966295234)
        tdSql.checkData(19, 2, 0.9887046181866692)
        tdSql.checkData(19, 3, 0.15158947061240008)
        tdSql.checkData(19, 4, nan)
        tdSql.checkData(19, 5, nan)
        tdSql.checkData(19, 6, 1.5182132651839548)
        tdSql.checkData(20, 0, 20)
        tdSql.checkData(20, 1, 0.9129452507276277)
        tdSql.checkData(20, 2, 0.40808206181339196)
        tdSql.checkData(20, 3, 2.237160944224742)
        tdSql.checkData(20, 4, nan)
        tdSql.checkData(20, 5, nan)
        tdSql.checkData(20, 6, 1.5208379310729538)
        tdSql.checkData(21, 0, 21)
        tdSql.checkData(21, 1, 0.8366556385360561)
        tdSql.checkData(21, 2, -0.5477292602242684)
        tdSql.checkData(21, 3, -1.5274985276366035)
        tdSql.checkData(21, 4, nan)
        tdSql.checkData(21, 5, nan)
        tdSql.checkData(21, 6, 1.5232132235179132)
        tdSql.checkData(22, 0, 22)
        tdSql.checkData(22, 1, -0.008851309290403876)
        tdSql.checkData(22, 2, -0.9999608263946371)
        tdSql.checkData(22, 3, 0.00885165604168446)
        tdSql.checkData(22, 4, nan)
        tdSql.checkData(22, 5, nan)
        tdSql.checkData(22, 6, 1.5253730473733196)
        tdSql.checkData(23, 0, 23)
        tdSql.checkData(23, 1, -0.8462204041751706)
        tdSql.checkData(23, 2, -0.5328330203333975)
        tdSql.checkData(23, 3, 1.5881530833912738)
        tdSql.checkData(23, 4, nan)
        tdSql.checkData(23, 5, nan)
        tdSql.checkData(23, 6, 1.5273454314033659)
        tdSql.checkData(24, 0, 24)
        tdSql.checkData(24, 1, -0.9055783620066239)
        tdSql.checkData(24, 2, 0.424179007336997)
        tdSql.checkData(24, 3, -2.1348966977217008)
        tdSql.checkData(24, 4, nan)
        tdSql.checkData(24, 5, nan)
        tdSql.checkData(24, 6, 1.5291537476963082)
        tdSql.checkData(25, 0, 25)
        tdSql.checkData(25, 1, -0.13235175009777303)
        tdSql.checkData(25, 2, 0.9912028118634736)
        tdSql.checkData(25, 3, -0.13352640702153587)
        tdSql.checkData(25, 4, nan)
        tdSql.checkData(25, 5, nan)
        tdSql.checkData(25, 6, 1.5308176396716067)
        tdSql.checkData(26, 0, 26)
        tdSql.checkData(26, 1, 0.7625584504796027)
        tdSql.checkData(26, 2, 0.6469193223286404)
        tdSql.checkData(26, 3, 1.1787535542062797)
        tdSql.checkData(26, 4, nan)
        tdSql.checkData(26, 5, nan)
        tdSql.checkData(26, 6, 1.5323537367737086)
        tdSql.checkData(27, 0, 27)
        tdSql.checkData(27, 1, 0.956375928404503)
        tdSql.checkData(27, 2, -0.2921388087338362)
        tdSql.checkData(27, 3, -3.273703800428119)
        tdSql.checkData(27, 4, nan)
        tdSql.checkData(27, 5, nan)
        tdSql.checkData(27, 6, 1.5337762109209665)
        tdSql.checkData(28, 0, 28)
        tdSql.checkData(28, 1, 0.27090578830786904)
        tdSql.checkData(28, 2, -0.9626058663135666)
        tdSql.checkData(28, 3, -0.28142960456426525)
        tdSql.checkData(28, 4, nan)
        tdSql.checkData(28, 5, nan)
        tdSql.checkData(28, 6, 1.5350972141155725)
        tdSql.checkData(29, 0, 29)
        tdSql.checkData(29, 1, -0.6636338842129675)
        tdSql.checkData(29, 2, -0.7480575296890003)
        tdSql.checkData(29, 3, 0.8871428437982151)
        tdSql.checkData(29, 4, nan)
        tdSql.checkData(29, 5, nan)
        tdSql.checkData(29, 6, 1.5363272257953886)
        tdSql.checkData(30, 0, 30)
        tdSql.checkData(30, 1, -0.9880316240928618)
        tdSql.checkData(30, 2, 0.15425144988758405)
        tdSql.checkData(30, 3, -6.405331196646276)
        tdSql.checkData(30, 4, nan)
        tdSql.checkData(30, 5, nan)
        tdSql.checkData(30, 6, 1.5374753309166493)
        tdSql.checkData(31, 0, 31)
        tdSql.checkData(31, 1, -0.404037645323065)
        tdSql.checkData(31, 2, 0.9147423578045313)
        tdSql.checkData(31, 3, -0.441695568020698)
        tdSql.checkData(31, 4, nan)
        tdSql.checkData(31, 5, nan)
        tdSql.checkData(31, 6, 1.5385494443596428)
        tdSql.checkData(32, 0, 32)
        tdSql.checkData(32, 1, 0.5514266812416906)
        tdSql.checkData(32, 2, 0.8342233605065102)
        tdSql.checkData(32, 3, 0.6610060414837631)
        tdSql.checkData(32, 4, nan)
        tdSql.checkData(32, 5, nan)
        tdSql.checkData(32, 6, 1.5395564933646284)
        tdSql.checkData(33, 0, 33)
        tdSql.checkData(33, 1, 0.9999118601072672)
        tdSql.checkData(33, 2, -0.013276747223059479)
        tdSql.checkData(33, 3, -75.31301480008509)
        tdSql.checkData(33, 4, nan)
        tdSql.checkData(33, 5, nan)
        tdSql.checkData(33, 6, 1.5405025668761214)
        tdSql.checkData(34, 0, 34)
        tdSql.checkData(34, 1, 0.5290826861200238)
        tdSql.checkData(34, 2, -0.8485702747846052)
        tdSql.checkData(34, 3, -0.6234989627162255)
        tdSql.checkData(34, 4, nan)
        tdSql.checkData(34, 5, nan)
        tdSql.checkData(34, 6, 1.5413930385908916)
        tdSql.checkData(35, 0, 35)
        tdSql.checkData(35, 1, -0.428182669496151)
        tdSql.checkData(35, 2, -0.9036922050915067)
        tdSql.checkData(35, 3, 0.473814720414451)
        tdSql.checkData(35, 4, nan)
        tdSql.checkData(35, 5, nan)
        tdSql.checkData(35, 6, 1.5422326689561365)
        tdSql.checkData(36, 0, 36)
        tdSql.checkData(36, 1, -0.9917788534431158)
        tdSql.checkData(36, 2, -0.12796368962740468)
        tdSql.checkData(36, 3, 7.750470905699148)
        tdSql.checkData(36, 4, nan)
        tdSql.checkData(36, 5, nan)
        tdSql.checkData(36, 6, 1.5430256902014756)
        tdSql.checkData(37, 0, 37)
        tdSql.checkData(37, 1, -0.6435381333569995)
        tdSql.checkData(37, 2, 0.7654140519453434)
        tdSql.checkData(37, 3, -0.8407712554027597)
        tdSql.checkData(37, 4, nan)
        tdSql.checkData(37, 5, nan)
        tdSql.checkData(37, 6, 1.5437758776076318)
        tdSql.checkData(38, 0, 38)
        tdSql.checkData(38, 1, 0.2963685787093853)
        tdSql.checkData(38, 2, 0.9550736440472949)
        tdSql.checkData(38, 3, 0.310309660994801)
        tdSql.checkData(38, 4, nan)
        tdSql.checkData(38, 5, nan)
        tdSql.checkData(38, 6, 1.5444866095419745)
        tdSql.checkData(39, 0, 39)
        tdSql.checkData(39, 1, 0.9637953862840878)
        tdSql.checkData(39, 2, 0.26664293235993725)
        tdSql.checkData(39, 3, 3.614554407101535)
        tdSql.checkData(39, 4, nan)
        tdSql.checkData(39, 5, nan)
        tdSql.checkData(39, 6, 1.545160918273219)
        tdSql.checkData(40, 0, 40)
        tdSql.checkData(40, 1, 0.7451131604793488)
        tdSql.checkData(40, 2, -0.6669380616522619)
        tdSql.checkData(40, 3, -1.117214930923896)
        tdSql.checkData(40, 4, nan)
        tdSql.checkData(40, 5, nan)
        tdSql.checkData(40, 6, 1.5458015331759765)
        tdSql.checkData(41, 0, 41)
        tdSql.checkData(41, 1, -0.158622668804709)
        tdSql.checkData(41, 2, -0.9873392775238264)
        tdSql.checkData(41, 3, 0.16065669868064283)
        tdSql.checkData(41, 4, nan)
        tdSql.checkData(41, 5, nan)
        tdSql.checkData(41, 6, 1.546410917622178)
        tdSql.checkData(42, 0, 42)
        tdSql.checkData(42, 1, -0.9165215479156338)
        tdSql.checkData(42, 2, -0.39998531498835127)
        tdSql.checkData(42, 3, 2.2913879924374863)
        tdSql.checkData(42, 4, nan)
        tdSql.checkData(42, 5, nan)
        tdSql.checkData(42, 6, 1.5469913006098266)
        tdSql.checkData(43, 0, 43)
        tdSql.checkData(43, 1, -0.8317747426285983)
        tdSql.checkData(43, 2, 0.5551133015206257)
        tdSql.checkData(43, 3, -1.4983873388551707)
        tdSql.checkData(43, 4, nan)
        tdSql.checkData(43, 5, nan)
        tdSql.checkData(43, 6, 1.5475447039844337)
        tdSql.checkData(44, 0, 44)
        tdSql.checkData(44, 1, 0.017701925105413577)
        tdSql.checkData(44, 2, 0.9998433086476912)
        tdSql.checkData(44, 3, 0.017704699278685777)
        tdSql.checkData(44, 4, nan)
        tdSql.checkData(44, 5, nan)
        tdSql.checkData(44, 6, 1.5480729659532555)
        tdSql.checkData(45, 0, 45)
        tdSql.checkData(45, 1, 0.8509035245341184)
        tdSql.checkData(45, 2, 0.5253219888177297)
        tdSql.checkData(45, 3, 1.6197751905438615)
        tdSql.checkData(45, 4, nan)
        tdSql.checkData(45, 5, nan)
        tdSql.checkData(45, 6, 1.5485777614681775)
        tdSql.checkData(46, 0, 46)
        tdSql.checkData(46, 1, 0.9017883476488092)
        tdSql.checkData(46, 2, -0.4321779448847783)
        tdSql.checkData(46, 3, -2.086613531121382)
        tdSql.checkData(46, 4, nan)
        tdSql.checkData(46, 5, nan)
        tdSql.checkData(46, 6, 1.5490606199531038)
        tdSql.checkData(47, 0, 47)
        tdSql.checkData(47, 1, 0.123573122745224)
        tdSql.checkData(47, 2, -0.9923354691509287)
        tdSql.checkData(47, 3, -0.12452756813273719)
        tdSql.checkData(47, 4, nan)
        tdSql.checkData(47, 5, nan)
        tdSql.checkData(47, 6, 1.5495229407708355)
        tdSql.checkData(48, 0, 48)
        tdSql.checkData(48, 1, -0.7682546613236668)
        tdSql.checkData(48, 2, -0.6401443394691997)
        tdSql.checkData(48, 3, 1.2001272431162864)
        tdSql.checkData(48, 4, nan)
        tdSql.checkData(48, 5, nan)
        tdSql.checkData(48, 6, 1.5499660067586796)
        tdSql.checkData(49, 0, 49)
        tdSql.checkData(49, 1, -0.9537526527594719)
        tdSql.checkData(49, 2, 0.3005925437436371)
        tdSql.checkData(49, 3, -3.172908552159191)
        tdSql.checkData(49, 4, nan)
        tdSql.checkData(49, 5, nan)
        tdSql.checkData(49, 6, 1.5503909961083586)

        tdSql.query(
            "select c1, sin(c2)+2, cos(c2)+2, cos(pow(c2,2)+2), tan(pow(c2,3)+log(c3, 2)+pow(c5,2)) as v4, asin(pow(c4, 4.5)+pow(c3, 2)), acos(log(c1,2)+log(c3,4)+pow(c6,2.8)+2) as v6 from ct1 where ts == 1601481600000;"
        )
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 2.2474039592545227)
        tdSql.checkData(0, 2, 2.9689124217106446)
        tdSql.checkData(0, 3, -0.4721284112969602)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, nan)

        tdSql.query(
            "select c1, sin(c2), cos(c1+2), tan(c2+2)+2, sin(c2+3)+cos(c3+2)+tan(c5+2) as v4, sin(c4+4.5)+tan(c3+2), sin(c1+2)+cos(c3+4)+acos(c6+2.8)+2 as v6 from st0 where ts == 1601481600000;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.24740395925452294)
        tdSql.checkData(0, 2, -0.4161468365471424)
        tdSql.checkData(0, 3, 0.7613723837759034)
        tdSql.checkData(0, 4, -2.7093818343387697)
        tdSql.checkData(0, 5, -3.162569980926616)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, 0.24740395925452294)
        tdSql.checkData(1, 2, -0.4161468365471424)
        tdSql.checkData(1, 3, 0.7613723837759034)
        tdSql.checkData(1, 4, -2.7093818343387697)
        tdSql.checkData(1, 5, -3.162569980926616)
        tdSql.checkData(1, 6, nan)

        tdSql.query(
            "select c1, tan(c2+ 2), sin(pow(c1,2)), cos(pow(c2,2)+2), tan(pow(c2,3)+log(c3, 2)+pow(c5,2)) as v4, asin(pow(c4, 4.5)+pow(c3, 2)), acos(log(c1,2)+log(c3,4)+pow(c6,2.8)+2) as v6 from st0 where c1 == 0;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.2386276162240966)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, -0.4721284112969602)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, -1.2386276162240966)
        tdSql.checkData(1, 2, 0.0)
        tdSql.checkData(1, 3, -0.4721284112969602)
        tdSql.checkData(1, 4, nan)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, nan)

        tdSql.query(
            "select c1, atan(c2+2), asin(c1+2), acos(c2+c1)+2, acos(c2+c3)+asin(c3+c2)+pow(c5,2) as v4, acos(c4/4.5)+asin(c3-2), asin(c1/2)+log(c3,c4)+pow(c6, 2.8)+2 as v6 from st0 where c1 == 0;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 1.1525719972156676)
        tdSql.checkData(0, 2, nan)
        tdSql.checkData(0, 3, 3.3181160716528177)
        tdSql.checkData(0, 4, 1.5707963267948966)
        tdSql.checkData(0, 5, nan)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, 1.1525719972156676)
        tdSql.checkData(1, 2, nan)
        tdSql.checkData(1, 3, 3.3181160716528177)
        tdSql.checkData(1, 4, 1.5707963267948966)
        tdSql.checkData(1, 5, nan)
        tdSql.checkData(1, 6, nan)

        tdSql.query(
            "select c1, cos(c2+2), cos(ceil(pow(c1,2))), sin(floor(pow(c2,2)+2)), sin(ceil(c2)+floor(c3+c2)+round(c5+c2)) as v4, atan(pow(c4, 4.5)+pow(c3, 2)), tan(log(c1,2)+cos(c3+4)+pow(c6,2.8)+2) as v6 from st0 order by ts desc;"
        )
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, 49)
        tdSql.checkData(0, 1, 0.7421541968137826)
        tdSql.checkData(0, 2, 0.6798687696126814)
        tdSql.checkData(0, 3, 0.3130283835205022)
        tdSql.checkData(0, 4, -0.04421256322855966)
        tdSql.checkData(0, 5, 1.5707963020154387)
        tdSql.checkData(0, 6, 0.03652568194248612)
        tdSql.checkData(1, 0, 49)
        tdSql.checkData(1, 1, 0.7421541968137826)
        tdSql.checkData(1, 2, 0.6798687696126814)
        tdSql.checkData(1, 3, 0.3130283835205022)
        tdSql.checkData(1, 4, -0.04421256322855966)
        tdSql.checkData(1, 5, 1.5707963020154387)
        tdSql.checkData(1, 6, 0.03652568194248612)
        tdSql.checkData(2, 0, 48)
        tdSql.checkData(2, 1, 0.9649660284921133)
        tdSql.checkData(2, 2, -0.3505997332287945)
        tdSql.checkData(2, 3, 0.07093264777739541)
        tdSql.checkData(2, 4, 0.9454451549211168)
        tdSql.checkData(2, 5, 1.5707962996062728)
        tdSql.checkData(2, 6, -2.3765070948049045)
        tdSql.checkData(3, 0, 48)
        tdSql.checkData(3, 1, 0.9649660284921133)
        tdSql.checkData(3, 2, -0.3505997332287945)
        tdSql.checkData(3, 3, 0.07093264777739541)
        tdSql.checkData(3, 4, 0.9454451549211168)
        tdSql.checkData(3, 5, 1.5707962996062728)
        tdSql.checkData(3, 6, -2.3765070948049045)
        tdSql.checkData(4, 0, 47)
        tdSql.checkData(4, 1, 0.3005925437436371)
        tdSql.checkData(4, 2, -0.8958906072013385)
        tdSql.checkData(4, 3, -0.6297475077924276)
        tdSql.checkData(4, 4, 0.5805866409896447)
        tdSql.checkData(4, 5, 1.5707962969045492)
        tdSql.checkData(4, 6, -0.7609930344795104)
        tdSql.checkData(5, 0, 47)
        tdSql.checkData(5, 1, 0.3005925437436371)
        tdSql.checkData(5, 2, -0.8958906072013385)
        tdSql.checkData(5, 3, -0.6297475077924276)
        tdSql.checkData(5, 4, 0.5805866409896447)
        tdSql.checkData(5, 5, 1.5707962969045492)
        tdSql.checkData(5, 6, -0.7609930344795104)
        tdSql.checkData(6, 0, 46)
        tdSql.checkData(6, 1, -0.6401443394691997)
        tdSql.checkData(6, 2, 0.13691638327939556)
        tdSql.checkData(6, 3, 0.5367255338147858)
        tdSql.checkData(6, 4, -0.6160642040533645)
        tdSql.checkData(6, 5, 1.5707962938673405)
        tdSql.checkData(6, 6, -1.9292699714079746)
        tdSql.checkData(7, 0, 46)
        tdSql.checkData(7, 1, -0.6401443394691997)
        tdSql.checkData(7, 2, 0.13691638327939556)
        tdSql.checkData(7, 3, 0.5367255338147858)
        tdSql.checkData(7, 4, -0.6160642040533645)
        tdSql.checkData(7, 5, 1.5707962938673405)
        tdSql.checkData(7, 6, -1.9292699714079746)
        tdSql.checkData(8, 0, 45)
        tdSql.checkData(8, 1, -0.9923354691509287)
        tdSql.checkData(8, 2, -0.24113458224528692)
        tdSql.checkData(8, 3, -0.6231301003179452)
        tdSql.checkData(8, 4, -0.9300948780045254)
        tdSql.checkData(8, 5, 1.5707962904442854)
        tdSql.checkData(8, 6, -7.205947408999204)
        tdSql.checkData(9, 0, 45)
        tdSql.checkData(9, 1, -0.9923354691509287)
        tdSql.checkData(9, 2, -0.24113458224528692)
        tdSql.checkData(9, 3, -0.6231301003179452)
        tdSql.checkData(9, 4, -0.9300948780045254)
        tdSql.checkData(9, 5, 1.5707962904442854)
        tdSql.checkData(9, 6, -7.205947408999204)
        tdSql.checkData(10, 0, 44)
        tdSql.checkData(10, 1, -0.4321779448847783)
        tdSql.checkData(10, 2, 0.7116688794089422)
        tdSql.checkData(10, 3, 0.3547692619733851)
        tdSql.checkData(10, 4, 0.08839871248753149)
        tdSql.checkData(10, 5, 1.5707962865760938)
        tdSql.checkData(10, 6, 0.20475275676724466)
        tdSql.checkData(11, 0, 44)
        tdSql.checkData(11, 1, -0.4321779448847783)
        tdSql.checkData(11, 2, 0.7116688794089422)
        tdSql.checkData(11, 3, 0.3547692619733851)
        tdSql.checkData(11, 4, 0.08839871248753149)
        tdSql.checkData(11, 5, 1.5707962865760938)
        tdSql.checkData(11, 6, 0.20475275676724466)
        tdSql.checkData(12, 0, 43)
        tdSql.checkData(12, 1, 0.5253219888177297)
        tdSql.checkData(12, 2, -0.17186582286471372)
        tdSql.checkData(12, 3, -0.5662318751422317)
        tdSql.checkData(12, 4, 0.9802456219572225)
        tdSql.checkData(12, 5, 1.570796282192712)
        tdSql.checkData(12, 6, -0.367384536387167)
        tdSql.checkData(13, 0, 43)
        tdSql.checkData(13, 1, 0.5253219888177297)
        tdSql.checkData(13, 2, -0.17186582286471372)
        tdSql.checkData(13, 3, -0.5662318751422317)
        tdSql.checkData(13, 4, 0.9802456219572225)
        tdSql.checkData(13, 5, 1.570796282192712)
        tdSql.checkData(13, 6, -0.367384536387167)
        tdSql.checkData(14, 0, 42)
        tdSql.checkData(14, 1, 0.9998433086476912)
        tdSql.checkData(14, 2, -0.004274977647617749)
        tdSql.checkData(14, 3, 0.412255807723053)
        tdSql.checkData(14, 4, 0.46771851834275896)
        tdSql.checkData(14, 5, 1.570796277211051)
        tdSql.checkData(14, 6, -22.120550530872286)
        tdSql.checkData(15, 0, 42)
        tdSql.checkData(15, 1, 0.9998433086476912)
        tdSql.checkData(15, 2, -0.004274977647617749)
        tdSql.checkData(15, 3, 0.412255807723053)
        tdSql.checkData(15, 4, 0.46771851834275896)
        tdSql.checkData(15, 5, 1.570796277211051)
        tdSql.checkData(15, 6, -22.120550530872286)
        tdSql.checkData(16, 0, 41)
        tdSql.checkData(16, 1, 0.5551133015206257)
        tdSql.checkData(16, 2, -0.9694223908459327)
        tdSql.checkData(16, 3, -0.7793716419485732)
        tdSql.checkData(16, 4, -0.7148975077677643)
        tdSql.checkData(16, 5, 1.5707962715321713)
        tdSql.checkData(16, 6, 0.6057979864116589)
        tdSql.checkData(17, 0, 41)
        tdSql.checkData(17, 1, 0.5551133015206257)
        tdSql.checkData(17, 2, -0.9694223908459327)
        tdSql.checkData(17, 3, -0.7793716419485732)
        tdSql.checkData(17, 4, -0.7148975077677643)
        tdSql.checkData(17, 5, 1.5707962715321713)
        tdSql.checkData(17, 6, 0.6057979864116589)
        tdSql.checkData(18, 0, 40)
        tdSql.checkData(18, 1, -0.39998531498835127)
        tdSql.checkData(18, 2, -0.5983634637950125)
        tdSql.checkData(18, 3, -0.21066319593197044)
        tdSql.checkData(18, 4, -0.8732972972139946)
        tdSql.checkData(18, 5, 1.570796265037764)
        tdSql.checkData(18, 6, -0.0772047427955866)
        tdSql.checkData(19, 0, 40)
        tdSql.checkData(19, 1, -0.39998531498835127)
        tdSql.checkData(19, 2, -0.5983634637950125)
        tdSql.checkData(19, 3, -0.21066319593197044)
        tdSql.checkData(19, 4, -0.8732972972139946)
        tdSql.checkData(19, 5, 1.570796265037764)
        tdSql.checkData(19, 6, -0.0772047427955866)
        tdSql.checkData(20, 0, 39)
        tdSql.checkData(20, 1, -0.9873392775238264)
        tdSql.checkData(20, 2, 0.8919503592036683)
        tdSql.checkData(20, 3, 0.6228943075363607)
        tdSql.checkData(20, 4, 0.21945466799406363)
        tdSql.checkData(20, 5, 1.5707962575857413)
        tdSql.checkData(20, 6, 0.5897115109610915)
        tdSql.checkData(21, 0, 39)
        tdSql.checkData(21, 1, -0.9873392775238264)
        tdSql.checkData(21, 2, 0.8919503592036683)
        tdSql.checkData(21, 3, 0.6228943075363607)
        tdSql.checkData(21, 4, 0.21945466799406363)
        tdSql.checkData(21, 5, 1.5707962575857413)
        tdSql.checkData(21, 6, 0.5897115109610915)
        tdSql.checkData(22, 0, 38)
        tdSql.checkData(22, 1, -0.6669380616522619)
        tdSql.checkData(22, 2, 0.4242881965497543)
        tdSql.checkData(22, 3, 0.7626364487946297)
        tdSql.checkData(22, 4, 0.9977992786806003)
        tdSql.checkData(22, 5, 1.5707962490046714)
        tdSql.checkData(22, 6, 1.138845506389765)
        tdSql.checkData(23, 0, 38)
        tdSql.checkData(23, 1, -0.6669380616522619)
        tdSql.checkData(23, 2, 0.4242881965497543)
        tdSql.checkData(23, 3, 0.7626364487946297)
        tdSql.checkData(23, 4, 0.9977992786806003)
        tdSql.checkData(23, 5, 1.5707962490046714)
        tdSql.checkData(23, 6, 1.138845506389765)
        tdSql.checkData(24, 0, 37)
        tdSql.checkData(24, 1, 0.26664293235993725)
        tdSql.checkData(24, 2, 0.7422350059189753)
        tdSql.checkData(24, 3, 0.9537888904975496)
        tdSql.checkData(24, 4, 0.346621180094276)
        tdSql.checkData(24, 5, 1.570796239086718)
        tdSql.checkData(24, 6, -0.1919260039444686)
        tdSql.checkData(25, 0, 37)
        tdSql.checkData(25, 1, 0.26664293235993725)
        tdSql.checkData(25, 2, 0.7422350059189753)
        tdSql.checkData(25, 3, 0.9537888904975496)
        tdSql.checkData(25, 4, 0.346621180094276)
        tdSql.checkData(25, 5, 1.570796239086718)
        tdSql.checkData(25, 6, -0.1919260039444686)
        tdSql.checkData(26, 0, 36)
        tdSql.checkData(26, 1, 0.9550736440472949)
        tdSql.checkData(26, 2, -0.0928962612844285)
        tdSql.checkData(26, 3, -0.4988176628046754)
        tdSql.checkData(26, 4, -0.8011526357338304)
        tdSql.checkData(26, 5, 1.5707962275786258)
        tdSql.checkData(26, 6, -1.1574711833500264)
        tdSql.checkData(27, 0, 36)
        tdSql.checkData(27, 1, 0.9550736440472949)
        tdSql.checkData(27, 2, -0.0928962612844285)
        tdSql.checkData(27, 3, -0.4988176628046754)
        tdSql.checkData(27, 4, -0.8011526357338304)
        tdSql.checkData(27, 5, 1.5707962275786258)
        tdSql.checkData(27, 6, -1.1574711833500264)
        tdSql.checkData(28, 0, 35)
        tdSql.checkData(28, 1, 0.7654140519453434)
        tdSql.checkData(28, 2, 0.9756491521033712)
        tdSql.checkData(28, 3, 0.9784316739726002)
        tdSql.checkData(28, 4, -0.8011345951780408)
        tdSql.checkData(28, 5, 1.5707962141701366)
        tdSql.checkData(28, 6, -0.2793610475623728)
        tdSql.checkData(29, 0, 35)
        tdSql.checkData(29, 1, 0.7654140519453434)
        tdSql.checkData(29, 2, 0.9756491521033712)
        tdSql.checkData(29, 3, 0.9784316739726002)
        tdSql.checkData(29, 4, -0.8011345951780408)
        tdSql.checkData(29, 5, 1.5707962141701366)
        tdSql.checkData(29, 6, -0.2793610475623728)
        tdSql.checkData(30, 0, 34)
        tdSql.checkData(30, 1, -0.12796368962740468)
        tdSql.checkData(30, 2, 0.9943770416371703)
        tdSql.checkData(30, 3, 0.9482534313435556)
        tdSql.checkData(30, 4, 0.3466494554970303)
        tdSql.checkData(30, 5, 1.5707961984790044)
        tdSql.checkData(30, 6, -3.168873759467214)
        tdSql.checkData(31, 0, 34)
        tdSql.checkData(31, 1, -0.12796368962740468)
        tdSql.checkData(31, 2, 0.9943770416371703)
        tdSql.checkData(31, 3, 0.9482534313435556)
        tdSql.checkData(31, 4, 0.3466494554970303)
        tdSql.checkData(31, 5, 1.5707961984790044)
        tdSql.checkData(31, 6, -3.168873759467214)
        tdSql.checkData(32, 0, 33)
        tdSql.checkData(32, 1, -0.9036922050915067)
        tdSql.checkData(32, 2, -0.42426089982481757)
        tdSql.checkData(32, 3, -0.7626169502553196)
        tdSql.checkData(32, 4, 0.9977972794498907)
        tdSql.checkData(32, 5, 1.5707961800314665)
        tdSql.checkData(32, 6, -0.1738544089832513)
        tdSql.checkData(33, 0, 33)
        tdSql.checkData(33, 1, -0.9036922050915067)
        tdSql.checkData(33, 2, -0.42426089982481757)
        tdSql.checkData(33, 3, -0.7626169502553196)
        tdSql.checkData(33, 4, 0.9977972794498907)
        tdSql.checkData(33, 5, 1.5707961800314665)
        tdSql.checkData(33, 6, -0.1738544089832513)
        tdSql.checkData(34, 0, 32)
        tdSql.checkData(34, 1, -0.8485702747846052)
        tdSql.checkData(34, 2, 0.9873536182198484)
        tdSql.checkData(34, 3, 0.9637712690067693)
        tdSql.checkData(34, 4, 0.21942525837900473)
        tdSql.checkData(34, 5, 1.5707961582366015)
        tdSql.checkData(34, 6, 2.449230012275883)
        tdSql.checkData(35, 0, 32)
        tdSql.checkData(35, 1, -0.8485702747846052)
        tdSql.checkData(35, 2, 0.9873536182198484)
        tdSql.checkData(35, 3, 0.9637712690067693)
        tdSql.checkData(35, 4, 0.21942525837900473)
        tdSql.checkData(35, 5, 1.5707961582366015)
        tdSql.checkData(35, 6, 2.449230012275883)
        tdSql.checkData(36, 0, 31)
        tdSql.checkData(36, 1, -0.013276747223059479)
        tdSql.checkData(36, 2, 0.9468970921774763)
        tdSql.checkData(36, 3, 0.9948176005844565)
        tdSql.checkData(36, 4, -0.8733119827746476)
        tdSql.checkData(36, 5, 1.5707961323523867)
        tdSql.checkData(36, 6, -24.115588387874705)
        tdSql.checkData(37, 0, 31)
        tdSql.checkData(37, 1, -0.013276747223059479)
        tdSql.checkData(37, 2, 0.9468970921774763)
        tdSql.checkData(37, 3, 0.9948176005844565)
        tdSql.checkData(37, 4, -0.8733119827746476)
        tdSql.checkData(37, 5, 1.5707961323523867)
        tdSql.checkData(37, 6, -24.115588387874705)
        tdSql.checkData(38, 0, 30)
        tdSql.checkData(38, 1, 0.8342233605065102)
        tdSql.checkData(38, 2, 0.06624670220315812)
        tdSql.checkData(38, 3, -0.3549947202980643)
        tdSql.checkData(38, 4, -0.7148764296291646)
        tdSql.checkData(38, 5, 1.5707961014403826)
        tdSql.checkData(38, 6, -0.1966943463168791)
        tdSql.checkData(39, 0, 30)
        tdSql.checkData(39, 1, 0.8342233605065102)
        tdSql.checkData(39, 2, 0.06624670220315812)
        tdSql.checkData(39, 3, -0.3549947202980643)
        tdSql.checkData(39, 4, -0.7148764296291646)
        tdSql.checkData(39, 5, 1.5707961014403826)
        tdSql.checkData(39, 6, -0.1966943463168791)
        tdSql.checkData(40, 0, 29)
        tdSql.checkData(40, 1, 0.9147423578045313)
        tdSql.checkData(40, 2, 0.5842577465661262)
        tdSql.checkData(40, 3, 0.8689955898411542)
        tdSql.checkData(40, 4, 0.4677451620451334)
        tdSql.checkData(40, 5, 1.5707960643046768)
        tdSql.checkData(40, 6, -0.039333072296354944)
        tdSql.checkData(41, 0, 29)
        tdSql.checkData(41, 1, 0.9147423578045313)
        tdSql.checkData(41, 2, 0.5842577465661262)
        tdSql.checkData(41, 3, 0.8689955898411542)
        tdSql.checkData(41, 4, 0.4677451620451334)
        tdSql.checkData(41, 5, 1.5707960643046768)
        tdSql.checkData(41, 6, -0.039333072296354944)
        tdSql.checkData(42, 0, 28)
        tdSql.checkData(42, 1, 0.15425144988758405)
        tdSql.checkData(42, 2, 0.17177673471265031)
        tdSql.checkData(42, 3, 0.5661573337391944)
        tdSql.checkData(42, 4, 0.9802396594403116)
        tdSql.checkData(42, 5, 1.5707960194088244)
        tdSql.checkData(42, 6, -0.9135826820615496)
        tdSql.checkData(43, 0, 28)
        tdSql.checkData(43, 1, 0.15425144988758405)
        tdSql.checkData(43, 2, 0.17177673471265031)
        tdSql.checkData(43, 3, 0.5661573337391944)
        tdSql.checkData(43, 4, 0.9802396594403116)
        tdSql.checkData(43, 5, 1.5707960194088244)
        tdSql.checkData(43, 6, -0.9135826820615496)
        tdSql.checkData(44, 0, 27)
        tdSql.checkData(44, 1, -0.7480575296890003)
        tdSql.checkData(44, 2, 0.9886955804866999)
        tdSql.checkData(44, 3, 0.8366226151268321)
        tdSql.checkData(44, 4, 0.08836868610400143)
        tdSql.checkData(44, 5, 1.570795964761674)
        tdSql.checkData(44, 6, 2.19589437576056)
        tdSql.checkData(45, 0, 27)
        tdSql.checkData(45, 1, -0.7480575296890003)
        tdSql.checkData(45, 2, 0.9886955804866999)
        tdSql.checkData(45, 3, 0.8366226151268321)
        tdSql.checkData(45, 4, 0.08836868610400143)
        tdSql.checkData(45, 5, 1.570795964761674)
        tdSql.checkData(45, 6, 2.19589437576056)
        tdSql.checkData(46, 0, 26)
        tdSql.checkData(46, 1, -0.9626058663135666)
        tdSql.checkData(46, 2, -0.848538375531565)
        tdSql.checkData(46, 3, -0.5513763859920506)
        tdSql.checkData(46, 4, -0.9301059501867618)
        tdSql.checkData(46, 5, 1.5707958977586762)
        tdSql.checkData(46, 6, 0.32917637498880103)
        tdSql.checkData(47, 0, 26)
        tdSql.checkData(47, 1, -0.9626058663135666)
        tdSql.checkData(47, 2, -0.848538375531565)
        tdSql.checkData(47, 3, -0.5513763859920506)
        tdSql.checkData(47, 4, -0.9301059501867618)
        tdSql.checkData(47, 5, 1.5707958977586762)
        tdSql.checkData(47, 6, 0.32917637498880103)
        tdSql.checkData(48, 0, 25)
        tdSql.checkData(48, 1, -0.2921388087338362)
        tdSql.checkData(48, 2, -0.9843872569764778)
        tdSql.checkData(48, 3, -0.9683494148893343)
        tdSql.checkData(48, 4, -0.6160404591886565)
        tdSql.checkData(48, 5, 1.5707958149586843)
        tdSql.checkData(48, 6, -9.848194527671561)
        tdSql.checkData(49, 0, 25)
        tdSql.checkData(49, 1, -0.2921388087338362)
        tdSql.checkData(49, 2, -0.9843872569764778)
        tdSql.checkData(49, 3, -0.9683494148893343)
        tdSql.checkData(49, 4, -0.6160404591886565)
        tdSql.checkData(49, 5, 1.5707958149586843)
        tdSql.checkData(49, 6, -9.848194527671561)
        tdSql.checkData(50, 0, 24)
        tdSql.checkData(50, 1, 0.6469193223286404)
        tdSql.checkData(50, 2, -0.4637754567475154)
        tdSql.checkData(50, 3, -0.053023383345603574)
        tdSql.checkData(50, 4, 0.5806111842123143)
        tdSql.checkData(50, 5, 1.5707957117659828)
        tdSql.checkData(50, 6, 0.9961666148069158)
        tdSql.checkData(51, 0, 24)
        tdSql.checkData(51, 1, 0.6469193223286404)
        tdSql.checkData(51, 2, -0.4637754567475154)
        tdSql.checkData(51, 3, -0.053023383345603574)
        tdSql.checkData(51, 4, 0.5806111842123143)
        tdSql.checkData(51, 5, 1.5707957117659828)
        tdSql.checkData(51, 6, 0.9961666148069158)
        tdSql.checkData(52, 0, 23)
        tdSql.checkData(52, 1, 0.9912028118634736)
        tdSql.checkData(52, 2, 0.3507408840091023)
        tdSql.checkData(52, 3, -0.07078230485740782)
        tdSql.checkData(52, 4, 0.9454353340247703)
        tdSql.checkData(52, 5, 1.5707955819710255)
        tdSql.checkData(52, 6, -2.150870213297903)
        tdSql.checkData(53, 0, 23)
        tdSql.checkData(53, 1, 0.9912028118634736)
        tdSql.checkData(53, 2, 0.3507408840091023)
        tdSql.checkData(53, 3, -0.07078230485740782)
        tdSql.checkData(53, 4, 0.9454353340247703)
        tdSql.checkData(53, 5, 1.5707955819710255)
        tdSql.checkData(53, 6, -2.150870213297903)
        tdSql.checkData(54, 0, 22)
        tdSql.checkData(54, 1, 0.424179007336997)
        tdSql.checkData(54, 2, 0.9810996900733364)
        tdSql.checkData(54, 3, 0.8115857761709371)
        tdSql.checkData(54, 4, -0.044242678085070965)
        tdSql.checkData(54, 5, 1.5707954170771377)
        tdSql.checkData(54, 6, -0.6314442572652602)
        tdSql.checkData(55, 0, 22)
        tdSql.checkData(55, 1, 0.424179007336997)
        tdSql.checkData(55, 2, 0.9810996900733364)
        tdSql.checkData(55, 3, 0.8115857761709371)
        tdSql.checkData(55, 4, -0.044242678085070965)
        tdSql.checkData(55, 5, 1.5707954170771377)
        tdSql.checkData(55, 6, -0.6314442572652602)
        tdSql.checkData(56, 0, 21)
        tdSql.checkData(56, 1, -0.5328330203333975)
        tdSql.checkData(56, 2, 0.3836706077176726)
        tdSql.checkData(56, 3, -0.035428428178979524)
        tdSql.checkData(56, 4, -0.9705352835374847)
        tdSql.checkData(56, 5, 1.5707952052973522)
        tdSql.checkData(56, 6, -0.5809225429871196)
        tdSql.checkData(57, 0, 21)
        tdSql.checkData(57, 1, -0.5328330203333975)
        tdSql.checkData(57, 2, 0.3836706077176726)
        tdSql.checkData(57, 3, -0.035428428178979524)
        tdSql.checkData(57, 4, -0.9705352835374847)
        tdSql.checkData(57, 5, 1.5707952052973522)
        tdSql.checkData(57, 6, -0.5809225429871196)
        tdSql.checkData(58, 0, 20)
        tdSql.checkData(58, 1, -0.9999608263946371)
        tdSql.checkData(58, 2, -0.525296338642536)
        tdSql.checkData(58, 3, -0.12354320937804643)
        tdSql.checkData(58, 4, -0.5063656411097588)
        tdSql.checkData(58, 5, 1.5707949300332242)
        tdSql.checkData(58, 6, -0.4029272896258388)
        tdSql.checkData(59, 0, 20)
        tdSql.checkData(59, 1, -0.9999608263946371)
        tdSql.checkData(59, 2, -0.525296338642536)
        tdSql.checkData(59, 3, -0.12354320937804643)
        tdSql.checkData(59, 4, -0.5063656411097588)
        tdSql.checkData(59, 5, 1.5707949300332242)
        tdSql.checkData(59, 6, -0.4029272896258388)
        tdSql.checkData(60, 0, 19)
        tdSql.checkData(60, 1, -0.5477292602242684)
        tdSql.checkData(60, 2, -0.9601787090136331)
        tdSql.checkData(60, 3, -0.9893538601694428)
        tdSql.checkData(60, 4, 0.683261714736121)
        tdSql.checkData(60, 5, 1.5707945675233086)
        tdSql.checkData(60, 6, 3.988678905790852)
        tdSql.checkData(61, 0, 19)
        tdSql.checkData(61, 1, -0.5477292602242684)
        tdSql.checkData(61, 2, -0.9601787090136331)
        tdSql.checkData(61, 3, -0.9893538601694428)
        tdSql.checkData(61, 4, 0.683261714736121)
        tdSql.checkData(61, 5, 1.5707945675233086)
        tdSql.checkData(61, 6, 3.988678905790852)
        tdSql.checkData(62, 0, 18)
        tdSql.checkData(62, 1, 0.40808206181339196)
        tdSql.checkData(62, 2, -0.9147301779353751)
        tdSql.checkData(62, 3, -0.6636113342009432)
        tdSql.checkData(62, 4, 0.8939966636005579)
        tdSql.checkData(62, 5, 1.5707940831304659)
        tdSql.checkData(62, 6, 0.11047679998824196)
        tdSql.checkData(63, 0, 18)
        tdSql.checkData(63, 1, 0.40808206181339196)
        tdSql.checkData(63, 2, -0.9147301779353751)
        tdSql.checkData(63, 3, -0.6636113342009432)
        tdSql.checkData(63, 4, 0.8939966636005579)
        tdSql.checkData(63, 5, 1.5707940831304659)
        tdSql.checkData(63, 6, 0.11047679998824196)
        tdSql.checkData(64, 0, 17)
        tdSql.checkData(64, 1, 0.9887046181866692)
        tdSql.checkData(64, 2, 0.9996482558795381)
        tdSql.checkData(64, 3, 0.9200142254959646)
        tdSql.checkData(64, 4, -0.1760756199485871)
        tdSql.checkData(64, 5, 1.5707934253419198)
        tdSql.checkData(64, 6, 0.46361590355468435)
        tdSql.checkData(65, 0, 17)
        tdSql.checkData(65, 1, 0.9887046181866692)
        tdSql.checkData(65, 2, 0.9996482558795381)
        tdSql.checkData(65, 3, 0.9200142254959646)
        tdSql.checkData(65, 4, -0.1760756199485871)
        tdSql.checkData(65, 5, 1.5707934253419198)
        tdSql.checkData(65, 6, 0.46361590355468435)
        tdSql.checkData(66, 0, 16)
        tdSql.checkData(66, 1, 0.6603167082440802)
        tdSql.checkData(66, 2, -0.03979075993115771)
        tdSql.checkData(66, 3, 0.37963562682930313)
        tdSql.checkData(66, 4, -0.9938886539233752)
        tdSql.checkData(66, 5, 1.5707925158192868)
        tdSql.checkData(66, 6, -0.4154684855612854)
        tdSql.checkData(67, 0, 16)
        tdSql.checkData(67, 1, 0.6603167082440802)
        tdSql.checkData(67, 2, -0.03979075993115771)
        tdSql.checkData(67, 3, 0.37963562682930313)
        tdSql.checkData(67, 4, -0.9938886539233752)
        tdSql.checkData(67, 5, 1.5707925158192868)
        tdSql.checkData(67, 6, -0.4154684855612854)
        tdSql.checkData(68, 0, 15)
        tdSql.checkData(68, 1, -0.27516333805159693)
        tdSql.checkData(68, 2, 0.36731936773024515)
        tdSql.checkData(68, 3, 0.7210585970706318)
        tdSql.checkData(68, 4, -0.38778163540943045)
        tdSql.checkData(68, 5, 1.5707912324159716)
        tdSql.checkData(68, 6, 0.8918850194348307)
        tdSql.checkData(69, 0, 15)
        tdSql.checkData(69, 1, -0.27516333805159693)
        tdSql.checkData(69, 2, 0.36731936773024515)
        tdSql.checkData(69, 3, 0.7210585970706318)
        tdSql.checkData(69, 4, -0.38778163540943045)
        tdSql.checkData(69, 5, 1.5707912324159716)
        tdSql.checkData(69, 6, 0.8918850194348307)
        tdSql.checkData(70, 0, 14)
        tdSql.checkData(70, 1, -0.9576594803233847)
        tdSql.checkData(70, 2, 0.3424664577455166)
        tdSql.checkData(70, 3, -0.07957859166428352)
        tdSql.checkData(70, 4, 0.7738906815578891)
        tdSql.checkData(70, 5, 1.5707893792390168)
        tdSql.checkData(70, 6, 1.3548129828192632)
        tdSql.checkData(71, 0, 14)
        tdSql.checkData(71, 1, -0.9576594803233847)
        tdSql.checkData(71, 2, 0.3424664577455166)
        tdSql.checkData(71, 3, -0.07957859166428352)
        tdSql.checkData(71, 4, 0.7738906815578891)
        tdSql.checkData(71, 5, 1.5707893792390168)
        tdSql.checkData(71, 6, 1.3548129828192632)
        tdSql.checkData(72, 0, 13)
        tdSql.checkData(72, 1, -0.7596879128588213)
        tdSql.checkData(72, 2, 0.7984961861625556)
        tdSql.checkData(72, 3, 0.9765908679435658)
        tdSql.checkData(72, 4, 0.8268286794901034)
        tdSql.checkData(72, 5, 1.5707866319075423)
        tdSql.checkData(72, 6, 3.695640303509019)
        tdSql.checkData(73, 0, 13)
        tdSql.checkData(73, 1, -0.7596879128588213)
        tdSql.checkData(73, 2, 0.7984961861625556)
        tdSql.checkData(73, 3, 0.9765908679435658)
        tdSql.checkData(73, 4, 0.8268286794901034)
        tdSql.checkData(73, 5, 1.5707866319075423)
        tdSql.checkData(73, 6, 3.695640303509019)
        tdSql.checkData(74, 0, 12)
        tdSql.checkData(74, 1, 0.1367372182078336)
        tdSql.checkData(74, 2, 0.8711474010323434)
        tdSql.checkData(74, 3, 0.9964691731217737)
        tdSql.checkData(74, 4, -0.3048106211022167)
        tdSql.checkData(74, 5, 1.570782433199764)
        tdSql.checkData(74, 6, 0.31565238132361734)
        tdSql.checkData(75, 0, 12)
        tdSql.checkData(75, 1, 0.1367372182078336)
        tdSql.checkData(75, 2, 0.8711474010323434)
        tdSql.checkData(75, 3, 0.9964691731217737)
        tdSql.checkData(75, 4, -0.3048106211022167)
        tdSql.checkData(75, 5, 1.570782433199764)
        tdSql.checkData(75, 6, 0.31565238132361734)
        tdSql.checkData(76, 0, 11)
        tdSql.checkData(76, 1, 0.9074467814501962)
        tdSql.checkData(76, 2, -0.04866360920015389)
        tdSql.checkData(76, 3, -0.45990349068959124)
        tdSql.checkData(76, 4, -0.9997551733586199)
        tdSql.checkData(76, 5, 1.5707757843526298)
        tdSql.checkData(76, 6, -0.9008027113130536)
        tdSql.checkData(77, 0, 11)
        tdSql.checkData(77, 1, 0.9074467814501962)
        tdSql.checkData(77, 2, -0.04866360920015389)
        tdSql.checkData(77, 3, -0.45990349068959124)
        tdSql.checkData(77, 4, -0.9997551733586199)
        tdSql.checkData(77, 5, 1.5707757843526298)
        tdSql.checkData(77, 6, -0.9008027113130536)
        tdSql.checkData(78, 0, 10)
        tdSql.checkData(78, 1, 0.8438539587324921)
        tdSql.checkData(78, 2, 0.8623188722876839)
        tdSql.checkData(78, 3, 0.9948267913584063)
        tdSql.checkData(78, 4, -0.26237485370392877)
        tdSql.checkData(78, 5, 1.5707648037030744)
        tdSql.checkData(78, 6, -4.025330871196722)
        tdSql.checkData(79, 0, 10)
        tdSql.checkData(79, 1, 0.8438539587324921)
        tdSql.checkData(79, 2, 0.8623188722876839)
        tdSql.checkData(79, 3, 0.9948267913584063)
        tdSql.checkData(79, 4, -0.26237485370392877)
        tdSql.checkData(79, 5, 1.5707648037030744)
        tdSql.checkData(79, 6, -4.025330871196722)
        tdSql.checkData(80, 0, 9)
        tdSql.checkData(80, 1, 0.004425697988050785)
        tdSql.checkData(80, 2, 0.7766859820216312)
        tdSql.checkData(80, 3, 0.9683644611001854)
        tdSql.checkData(80, 4, 0.8509035245341184)
        tdSql.checkData(80, 5, 1.5707457297498073)
        tdSql.checkData(80, 6, 8.99827042612123)
        tdSql.checkData(81, 0, 9)
        tdSql.checkData(81, 1, 0.004425697988050785)
        tdSql.checkData(81, 2, 0.7766859820216312)
        tdSql.checkData(81, 3, 0.9683644611001854)
        tdSql.checkData(81, 4, 0.8509035245341184)
        tdSql.checkData(81, 5, 1.5707457297498073)
        tdSql.checkData(81, 6, 8.99827042612123)
        tdSql.checkData(82, 0, 8)
        tdSql.checkData(82, 1, -0.8390715290764524)
        tdSql.checkData(82, 2, 0.39185723042955)
        tdSql.checkData(82, 3, -0.026551154023966794)
        tdSql.checkData(82, 4, 0.7451131604793488)
        tdSql.checkData(82, 5, 1.5707104842668094)
        tdSql.checkData(82, 6, 2.605110021628947)
        tdSql.checkData(83, 0, 8)
        tdSql.checkData(83, 1, -0.8390715290764524)
        tdSql.checkData(83, 2, 0.39185723042955)
        tdSql.checkData(83, 3, -0.026551154023966794)
        tdSql.checkData(83, 4, 0.7451131604793488)
        tdSql.checkData(83, 5, 1.5707104842668094)
        tdSql.checkData(83, 6, 2.605110021628947)
        tdSql.checkData(84, 0, 7)
        tdSql.checkData(84, 1, -0.9111302618846769)
        tdSql.checkData(84, 2, 0.3005925437436371)
        tdSql.checkData(84, 3, 0.6702291758433747)
        tdSql.checkData(84, 4, -0.428182669496151)
        tdSql.checkData(84, 5, 1.570640112161644)
        tdSql.checkData(84, 6, -23.751038099429206)
        tdSql.checkData(85, 0, 7)
        tdSql.checkData(85, 1, -0.9111302618846769)
        tdSql.checkData(85, 2, 0.3005925437436371)
        tdSql.checkData(85, 3, 0.6702291758433747)
        tdSql.checkData(85, 4, -0.428182669496151)
        tdSql.checkData(85, 5, 1.570640112161644)
        tdSql.checkData(85, 6, -23.751038099429206)
        tdSql.checkData(86, 0, 6)
        tdSql.checkData(86, 1, -0.14550003380861354)
        tdSql.checkData(86, 2, -0.12796368962740468)
        tdSql.checkData(86, 3, 0.2963685787093853)
        tdSql.checkData(86, 4, -0.9880316240928618)
        tdSql.checkData(86, 5, 1.5704848525972515)
        tdSql.checkData(86, 6, 0.9400535268838884)
        tdSql.checkData(87, 0, 6)
        tdSql.checkData(87, 1, -0.14550003380861354)
        tdSql.checkData(87, 2, -0.12796368962740468)
        tdSql.checkData(87, 3, 0.2963685787093853)
        tdSql.checkData(87, 4, -0.9880316240928618)
        tdSql.checkData(87, 5, 1.5704848525972515)
        tdSql.checkData(87, 6, 0.9400535268838884)
        tdSql.checkData(88, 0, 5)
        tdSql.checkData(88, 1, 0.7539022543433046)
        tdSql.checkData(88, 2, 0.9912028118634736)
        tdSql.checkData(88, 3, 0.956375928404503)
        tdSql.checkData(88, 4, -0.13235175009777303)
        tdSql.checkData(88, 5, 1.5700933602085452)
        tdSql.checkData(88, 6, -0.24421205951965097)
        tdSql.checkData(89, 0, 5)
        tdSql.checkData(89, 1, 0.7539022543433046)
        tdSql.checkData(89, 2, 0.9912028118634736)
        tdSql.checkData(89, 3, 0.956375928404503)
        tdSql.checkData(89, 4, -0.13235175009777303)
        tdSql.checkData(89, 5, 1.5700933602085452)
        tdSql.checkData(89, 6, -0.24421205951965097)
        tdSql.checkData(90, 0, 4)
        tdSql.checkData(90, 1, 0.960170286650366)
        tdSql.checkData(90, 2, -0.9576594803233847)
        tdSql.checkData(90, 3, -0.750987246771676)
        tdSql.checkData(90, 4, 0.9129452507276277)
        tdSql.checkData(90, 5, 1.5689023896654766)
        tdSql.checkData(90, 6, -1.741882365717585)
        tdSql.checkData(91, 0, 4)
        tdSql.checkData(91, 1, 0.960170286650366)
        tdSql.checkData(91, 2, -0.9576594803233847)
        tdSql.checkData(91, 3, -0.750987246771676)
        tdSql.checkData(91, 4, 0.9129452507276277)
        tdSql.checkData(91, 5, 1.5689023896654766)
        tdSql.checkData(91, 6, -1.741882365717585)
        tdSql.checkData(92, 0, 3)
        tdSql.checkData(92, 1, 0.28366218546322625)
        tdSql.checkData(92, 2, -0.9111302618846769)
        tdSql.checkData(92, 3, -0.9999902065507035)
        tdSql.checkData(92, 4, 0.6502878401571168)
        tdSql.checkData(92, 5, 1.5640983290419266)
        tdSql.checkData(92, 6, 1.2100230702966224)
        tdSql.checkData(93, 0, 3)
        tdSql.checkData(93, 1, 0.28366218546322625)
        tdSql.checkData(93, 2, -0.9111302618846769)
        tdSql.checkData(93, 3, -0.9999902065507035)
        tdSql.checkData(93, 4, 0.6502878401571168)
        tdSql.checkData(93, 5, 1.5640983290419266)
        tdSql.checkData(93, 6, 1.2100230702966224)
        tdSql.checkData(94, 0, 2)
        tdSql.checkData(94, 1, -0.6536436208636119)
        tdSql.checkData(94, 2, -0.6536436208636119)
        tdSql.checkData(94, 3, -0.27941549819892586)
        tdSql.checkData(94, 4, -0.5440211108893698)
        tdSql.checkData(94, 5, 1.5332586916349722)
        tdSql.checkData(94, 6, 14.060932856369687)
        tdSql.checkData(95, 0, 2)
        tdSql.checkData(95, 1, -0.6536436208636119)
        tdSql.checkData(95, 2, -0.6536436208636119)
        tdSql.checkData(95, 3, -0.27941549819892586)
        tdSql.checkData(95, 4, -0.5440211108893698)
        tdSql.checkData(95, 5, 1.5332586916349722)
        tdSql.checkData(95, 6, 14.060932856369687)
        tdSql.checkData(96, 0, 1)
        tdSql.checkData(96, 1, -0.9899924966004454)
        tdSql.checkData(96, 2, 0.5403023058681398)
        tdSql.checkData(96, 3, 0.1411200080598672)
        tdSql.checkData(96, 4, -0.9589242746631385)
        tdSql.checkData(96, 5, 1.1071487177940904)
        tdSql.checkData(96, 6, 0.14303314440903753)
        tdSql.checkData(97, 0, 1)
        tdSql.checkData(97, 1, -0.9899924966004454)
        tdSql.checkData(97, 2, 0.5403023058681398)
        tdSql.checkData(97, 3, 0.1411200080598672)
        tdSql.checkData(97, 4, -0.9589242746631385)
        tdSql.checkData(97, 5, 1.1071487177940904)
        tdSql.checkData(97, 6, 0.14303314440903753)
        tdSql.checkData(98, 0, 0)
        tdSql.checkData(98, 1, -0.6281736227227391)
        tdSql.checkData(98, 2, 1.0)
        tdSql.checkData(98, 3, 0.9092974268256817)
        tdSql.checkData(98, 4, 0.8414709848078965)
        tdSql.checkData(98, 5, 0.0)
        tdSql.checkData(98, 6, nan)
        tdSql.checkData(99, 0, 0)
        tdSql.checkData(99, 1, -0.6281736227227391)
        tdSql.checkData(99, 2, 1.0)
        tdSql.checkData(99, 3, 0.9092974268256817)
        tdSql.checkData(99, 4, 0.8414709848078965)
        tdSql.checkData(99, 5, 0.0)
        tdSql.checkData(99, 6, nan)

        tdSql.query(
            "select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5+c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6 from ct1 order by ts limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.7780731968879212)
        tdSql.checkData(0, 2, 0.6143002821164822)
        tdSql.checkData(0, 3, 3.2037266279837113)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.02246988233490299)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.1411200080598672)
        tdSql.checkData(1, 2, 0.6663667453928805)
        tdSql.checkData(1, 3, 1.558041126155035)
        tdSql.checkData(1, 4, 2.1543462689906883)
        tdSql.checkData(1, 5, 0.17204223631998083)
        tdSql.checkData(1, 6, nan)

        tdSql.query(
            "select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6  from (select * from st0 order by ts desc);"
        )
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, 49)
        tdSql.checkData(0, 1, 0.6702291758433747)
        tdSql.checkData(0, 2, 0.9923745526637894)
        tdSql.checkData(0, 3, 0.9298143670243166)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.7136182821549459)
        tdSql.checkData(0, 6, -0.7462904241496138)
        tdSql.checkData(1, 0, 49)
        tdSql.checkData(1, 1, 0.6702291758433747)
        tdSql.checkData(1, 2, 0.9923745526637894)
        tdSql.checkData(1, 3, 0.9298143670243166)
        tdSql.checkData(1, 4, nan)
        tdSql.checkData(1, 5, 0.7136182821549459)
        tdSql.checkData(1, 6, -0.7462904241496138)
        tdSql.checkData(2, 0, 48)
        tdSql.checkData(2, 1, -0.26237485370392877)
        tdSql.checkData(2, 2, 0.6202081141679935)
        tdSql.checkData(2, 3, 1.8175857333771335)
        tdSql.checkData(2, 4, nan)
        tdSql.checkData(2, 5, 1.211884234321115)
        tdSql.checkData(2, 6, 5.183714988550632)
        tdSql.checkData(3, 0, 48)
        tdSql.checkData(3, 1, -0.26237485370392877)
        tdSql.checkData(3, 2, 0.6202081141679935)
        tdSql.checkData(3, 3, 1.8175857333771335)
        tdSql.checkData(3, 4, nan)
        tdSql.checkData(3, 5, 1.211884234321115)
        tdSql.checkData(3, 6, 5.183714988550632)
        tdSql.checkData(4, 0, 47)
        tdSql.checkData(4, 1, -0.9537526527594719)
        tdSql.checkData(4, 2, 0.6593040763085178)
        tdSql.checkData(4, 3, 3.4575106745458637)
        tdSql.checkData(4, 4, nan)
        tdSql.checkData(4, 5, 0.8820838187306987)
        tdSql.checkData(4, 6, 2.6302204463996084)
        tdSql.checkData(5, 0, 47)
        tdSql.checkData(5, 1, -0.9537526527594719)
        tdSql.checkData(5, 2, 0.6593040763085178)
        tdSql.checkData(5, 3, 3.4575106745458637)
        tdSql.checkData(5, 4, nan)
        tdSql.checkData(5, 5, 0.8820838187306987)
        tdSql.checkData(5, 6, 2.6302204463996084)
        tdSql.checkData(6, 0, 46)
        tdSql.checkData(6, 1, -0.7682546613236668)
        tdSql.checkData(6, 2, 0.9998433250151273)
        tdSql.checkData(6, 3, 1.2763169256468458)
        tdSql.checkData(6, 4, nan)
        tdSql.checkData(6, 5, -0.300459258677913)
        tdSql.checkData(6, 6, 0.13392039926281352)
        tdSql.checkData(7, 0, 46)
        tdSql.checkData(7, 1, -0.7682546613236668)
        tdSql.checkData(7, 2, 0.9998433250151273)
        tdSql.checkData(7, 3, 1.2763169256468458)
        tdSql.checkData(7, 4, nan)
        tdSql.checkData(7, 5, -0.300459258677913)
        tdSql.checkData(7, 6, 0.13392039926281352)
        tdSql.checkData(8, 0, 45)
        tdSql.checkData(8, 1, 0.123573122745224)
        tdSql.checkData(8, 2, 0.6735650596658175)
        tdSql.checkData(8, 3, 1.5193186190030223)
        tdSql.checkData(8, 4, nan)
        tdSql.checkData(8, 5, -1.5661895943272113)
        tdSql.checkData(8, 6, 5.513771854144419)
        tdSql.checkData(9, 0, 45)
        tdSql.checkData(9, 1, 0.123573122745224)
        tdSql.checkData(9, 2, 0.6735650596658175)
        tdSql.checkData(9, 3, 1.5193186190030223)
        tdSql.checkData(9, 4, nan)
        tdSql.checkData(9, 5, -1.5661895943272113)
        tdSql.checkData(9, 6, 5.513771854144419)
        tdSql.checkData(10, 0, 44)
        tdSql.checkData(10, 1, 0.9017883476488092)
        tdSql.checkData(10, 2, 0.6085839480802863)
        tdSql.checkData(10, 3, 3.5552629892514687)
        tdSql.checkData(10, 4, nan)
        tdSql.checkData(10, 5, -1.9810692649977342)
        tdSql.checkData(10, 6, 3.0531030020123464)
        tdSql.checkData(11, 0, 44)
        tdSql.checkData(11, 1, 0.9017883476488092)
        tdSql.checkData(11, 2, 0.6085839480802863)
        tdSql.checkData(11, 3, 3.5552629892514687)
        tdSql.checkData(11, 4, nan)
        tdSql.checkData(11, 5, -1.9810692649977342)
        tdSql.checkData(11, 6, 3.0531030020123464)
        tdSql.checkData(12, 0, 43)
        tdSql.checkData(12, 1, 0.8509035245341184)
        tdSql.checkData(12, 2, 0.9874457808369176)
        tdSql.checkData(12, 3, 1.5962924548219202)
        tdSql.checkData(12, 4, nan)
        tdSql.checkData(12, 5, -1.2490970766755156)
        tdSql.checkData(12, 6, 0.5781542141407696)
        tdSql.checkData(13, 0, 43)
        tdSql.checkData(13, 1, 0.8509035245341184)
        tdSql.checkData(13, 2, 0.9874457808369176)
        tdSql.checkData(13, 3, 1.5962924548219202)
        tdSql.checkData(13, 4, nan)
        tdSql.checkData(13, 5, -1.2490970766755156)
        tdSql.checkData(13, 6, 0.5781542141407696)
        tdSql.checkData(14, 0, 42)
        tdSql.checkData(14, 1, 0.017701925105413577)
        tdSql.checkData(14, 2, 0.7350111780599404)
        tdSql.checkData(14, 3, 1.1912997639866574)
        tdSql.checkData(14, 4, nan)
        tdSql.checkData(14, 5, 0.036467324189017214)
        tdSql.checkData(14, 6, 6.024578312510778)
        tdSql.checkData(15, 0, 42)
        tdSql.checkData(15, 1, 0.017701925105413577)
        tdSql.checkData(15, 2, 0.7350111780599404)
        tdSql.checkData(15, 3, 1.1912997639866574)
        tdSql.checkData(15, 4, nan)
        tdSql.checkData(15, 5, 0.036467324189017214)
        tdSql.checkData(15, 6, 6.024578312510778)
        tdSql.checkData(16, 0, 41)
        tdSql.checkData(16, 1, -0.8317747426285983)
        tdSql.checkData(16, 2, 0.5704067143341829)
        tdSql.checkData(16, 3, 3.397430462894578)
        tdSql.checkData(16, 4, nan)
        tdSql.checkData(16, 5, 0.9190273051332304)
        tdSql.checkData(16, 6, 3.473885481113728)
        tdSql.checkData(17, 0, 41)
        tdSql.checkData(17, 1, -0.8317747426285983)
        tdSql.checkData(17, 2, 0.5704067143341829)
        tdSql.checkData(17, 3, 3.397430462894578)
        tdSql.checkData(17, 4, nan)
        tdSql.checkData(17, 5, 0.9190273051332304)
        tdSql.checkData(17, 6, 3.473885481113728)
        tdSql.checkData(18, 0, 40)
        tdSql.checkData(18, 1, -0.9165215479156338)
        tdSql.checkData(18, 2, 0.9564033460276342)
        tdSql.checkData(18, 3, 1.889162191085516)
        tdSql.checkData(18, 4, nan)
        tdSql.checkData(18, 5, 0.90296737936602)
        tdSql.checkData(18, 6, 0.888896415152729)
        tdSql.checkData(19, 0, 40)
        tdSql.checkData(19, 1, -0.9165215479156338)
        tdSql.checkData(19, 2, 0.9564033460276342)
        tdSql.checkData(19, 3, 1.889162191085516)
        tdSql.checkData(19, 4, nan)
        tdSql.checkData(19, 5, 0.90296737936602)
        tdSql.checkData(19, 6, 0.888896415152729)
        tdSql.checkData(20, 0, 39)
        tdSql.checkData(20, 1, -0.158622668804709)
        tdSql.checkData(20, 2, 0.7999777847134487)
        tdSql.checkData(20, 3, 0.8435920138756074)
        tdSql.checkData(20, 4, nan)
        tdSql.checkData(20, 5, 0.3319994538301167)
        tdSql.checkData(20, 6, 7.12853286308907)
        tdSql.checkData(21, 0, 39)
        tdSql.checkData(21, 1, -0.158622668804709)
        tdSql.checkData(21, 2, 0.7999777847134487)
        tdSql.checkData(21, 3, 0.8435920138756074)
        tdSql.checkData(21, 4, nan)
        tdSql.checkData(21, 5, 0.3319994538301167)
        tdSql.checkData(21, 6, 7.12853286308907)
        tdSql.checkData(22, 0, 38)
        tdSql.checkData(22, 1, 0.7451131604793488)
        tdSql.checkData(22, 2, 0.5472018255605284)
        tdSql.checkData(22, 3, 3.081063350979351)
        tdSql.checkData(22, 4, nan)
        tdSql.checkData(22, 5, -0.007381884932924798)
        tdSql.checkData(22, 6, 3.8764172978929814)
        tdSql.checkData(23, 0, 38)
        tdSql.checkData(23, 1, 0.7451131604793488)
        tdSql.checkData(23, 2, 0.5472018255605284)
        tdSql.checkData(23, 3, 3.081063350979351)
        tdSql.checkData(23, 4, nan)
        tdSql.checkData(23, 5, -0.007381884932924798)
        tdSql.checkData(23, 6, 3.8764172978929814)
        tdSql.checkData(24, 0, 37)
        tdSql.checkData(24, 1, 0.9637953862840878)
        tdSql.checkData(24, 2, 0.909721840267583)
        tdSql.checkData(24, 3, 2.1734252903776303)
        tdSql.checkData(24, 4, nan)
        tdSql.checkData(24, 5, 0.32696474077278626)
        tdSql.checkData(24, 6, 1.174082484128993)
        tdSql.checkData(25, 0, 37)
        tdSql.checkData(25, 1, 0.9637953862840878)
        tdSql.checkData(25, 2, 0.909721840267583)
        tdSql.checkData(25, 3, 2.1734252903776303)
        tdSql.checkData(25, 4, nan)
        tdSql.checkData(25, 5, 0.32696474077278626)
        tdSql.checkData(25, 6, 1.174082484128993)
        tdSql.checkData(26, 0, 36)
        tdSql.checkData(26, 1, 0.2963685787093853)
        tdSql.checkData(26, 2, 0.8632704401895588)
        tdSql.checkData(26, 3, 0.5493681603601657)
        tdSql.checkData(26, 4, nan)
        tdSql.checkData(26, 5, 0.9944678850925007)
        tdSql.checkData(26, 6, 11.004294268461184)
        tdSql.checkData(27, 0, 36)
        tdSql.checkData(27, 1, 0.2963685787093853)
        tdSql.checkData(27, 2, 0.8632704401895588)
        tdSql.checkData(27, 3, 0.5493681603601657)
        tdSql.checkData(27, 4, nan)
        tdSql.checkData(27, 5, 0.9944678850925007)
        tdSql.checkData(27, 6, 11.004294268461184)
        tdSql.checkData(28, 0, 35)
        tdSql.checkData(28, 1, -0.6435381333569995)
        tdSql.checkData(28, 2, 0.5403764709316752)
        tdSql.checkData(28, 3, 2.734210799811235)
        tdSql.checkData(28, 4, nan)
        tdSql.checkData(28, 5, 1.1930854189064375)
        tdSql.checkData(28, 6, 4.24770540197234)
        tdSql.checkData(29, 0, 35)
        tdSql.checkData(29, 1, -0.6435381333569995)
        tdSql.checkData(29, 2, 0.5403764709316752)
        tdSql.checkData(29, 3, 2.734210799811235)
        tdSql.checkData(29, 4, nan)
        tdSql.checkData(29, 5, 1.1930854189064375)
        tdSql.checkData(29, 6, 4.24770540197234)
        tdSql.checkData(30, 0, 34)
        tdSql.checkData(30, 1, -0.9917788534431158)
        tdSql.checkData(30, 2, 0.8517779466253769)
        tdSql.checkData(30, 3, 2.470955260231499)
        tdSql.checkData(30, 4, nan)
        tdSql.checkData(30, 5, 0.4428112547200472)
        tdSql.checkData(30, 6, 1.4785733565944832)
        tdSql.checkData(31, 0, 34)
        tdSql.checkData(31, 1, -0.9917788534431158)
        tdSql.checkData(31, 2, 0.8517779466253769)
        tdSql.checkData(31, 3, 2.470955260231499)
        tdSql.checkData(31, 4, nan)
        tdSql.checkData(31, 5, 0.4428112547200472)
        tdSql.checkData(31, 6, 1.4785733565944832)
        tdSql.checkData(32, 0, 33)
        tdSql.checkData(32, 1, -0.428182669496151)
        tdSql.checkData(32, 2, 0.9194811573015673)
        tdSql.checkData(32, 3, 0.4437992589174107)
        tdSql.checkData(32, 4, nan)
        tdSql.checkData(32, 5, -0.9001958571391758)
        tdSql.checkData(32, 6, -72.33956595410905)
        tdSql.checkData(33, 0, 33)
        tdSql.checkData(33, 1, -0.428182669496151)
        tdSql.checkData(33, 2, 0.9194811573015673)
        tdSql.checkData(33, 3, 0.4437992589174107)
        tdSql.checkData(33, 4, nan)
        tdSql.checkData(33, 5, -0.9001958571391758)
        tdSql.checkData(33, 6, -72.33956595410905)
        tdSql.checkData(34, 0, 32)
        tdSql.checkData(34, 1, 0.5290826861200238)
        tdSql.checkData(34, 2, 0.5503344099628432)
        tdSql.checkData(34, 3, 2.413227615833899)
        tdSql.checkData(34, 4, nan)
        tdSql.checkData(34, 5, -1.8893763681780902)
        tdSql.checkData(34, 6, 4.581032079680554)
        tdSql.checkData(35, 0, 32)
        tdSql.checkData(35, 1, 0.5290826861200238)
        tdSql.checkData(35, 2, 0.5503344099628432)
        tdSql.checkData(35, 3, 2.413227615833899)
        tdSql.checkData(35, 4, nan)
        tdSql.checkData(35, 5, -1.8893763681780902)
        tdSql.checkData(35, 6, 4.581032079680554)
        tdSql.checkData(36, 0, 31)
        tdSql.checkData(36, 1, 0.9999118601072672)
        tdSql.checkData(36, 2, 0.7877590247885756)
        tdSql.checkData(36, 3, 2.7979785951133604)
        tdSql.checkData(36, 4, nan)
        tdSql.checkData(36, 5, -1.7874722290307907)
        tdSql.checkData(36, 6, 1.8191237353300793)
        tdSql.checkData(37, 0, 31)
        tdSql.checkData(37, 1, 0.9999118601072672)
        tdSql.checkData(37, 2, 0.7877590247885756)
        tdSql.checkData(37, 3, 2.7979785951133604)
        tdSql.checkData(37, 4, nan)
        tdSql.checkData(37, 5, -1.7874722290307907)
        tdSql.checkData(37, 6, 1.8191237353300793)
        tdSql.checkData(38, 0, 30)
        tdSql.checkData(38, 1, 0.5514266812416906)
        tdSql.checkData(38, 2, 0.9635288988181601)
        tdSql.checkData(38, 3, 0.5944617511422015)
        tdSql.checkData(38, 4, nan)
        tdSql.checkData(38, 5, -0.7022004347538967)
        tdSql.checkData(38, 6, -3.710141817748492)
        tdSql.checkData(39, 0, 30)
        tdSql.checkData(39, 1, 0.5514266812416906)
        tdSql.checkData(39, 2, 0.9635288988181601)
        tdSql.checkData(39, 3, 0.5944617511422015)
        tdSql.checkData(39, 4, nan)
        tdSql.checkData(39, 5, -0.7022004347538967)
        tdSql.checkData(39, 6, -3.710141817748492)
        tdSql.checkData(40, 0, 29)
        tdSql.checkData(40, 1, -0.404037645323065)
        tdSql.checkData(40, 2, 0.5764850221962442)
        tdSql.checkData(40, 3, 2.1197476343754156)
        tdSql.checkData(40, 4, nan)
        tdSql.checkData(40, 5, 0.5162157333804713)
        tdSql.checkData(40, 6, 4.8800154918827525)
        tdSql.checkData(41, 0, 29)
        tdSql.checkData(41, 1, -0.404037645323065)
        tdSql.checkData(41, 2, 0.5764850221962442)
        tdSql.checkData(41, 3, 2.1197476343754156)
        tdSql.checkData(41, 4, nan)
        tdSql.checkData(41, 5, 0.5162157333804713)
        tdSql.checkData(41, 6, 4.8800154918827525)
        tdSql.checkData(42, 0, 28)
        tdSql.checkData(42, 1, -0.9880316240928618)
        tdSql.checkData(42, 2, 0.7230710689951642)
        tdSql.checkData(42, 3, 3.1457526648156393)
        tdSql.checkData(42, 4, nan)
        tdSql.checkData(42, 5, 1.0206076417536643)
        tdSql.checkData(42, 6, 2.197019393348823)
        tdSql.checkData(43, 0, 28)
        tdSql.checkData(43, 1, -0.9880316240928618)
        tdSql.checkData(43, 2, 0.7230710689951642)
        tdSql.checkData(43, 3, 3.1457526648156393)
        tdSql.checkData(43, 4, nan)
        tdSql.checkData(43, 5, 1.0206076417536643)
        tdSql.checkData(43, 6, 2.197019393348823)
        tdSql.checkData(44, 0, 27)
        tdSql.checkData(44, 1, -0.6636338842129675)
        tdSql.checkData(44, 2, 0.9912542848596704)
        tdSql.checkData(44, 3, 0.9080812682077812)
        tdSql.checkData(44, 4, nan)
        tdSql.checkData(44, 5, 0.6788951190016388)
        tdSql.checkData(44, 6, -0.8324928492797357)
        tdSql.checkData(45, 0, 27)
        tdSql.checkData(45, 1, -0.6636338842129675)
        tdSql.checkData(45, 2, 0.9912542848596704)
        tdSql.checkData(45, 3, 0.9080812682077812)
        tdSql.checkData(45, 4, nan)
        tdSql.checkData(45, 5, 0.6788951190016388)
        tdSql.checkData(45, 6, -0.8324928492797357)
        tdSql.checkData(46, 0, 26)
        tdSql.checkData(46, 1, 0.27090578830786904)
        tdSql.checkData(46, 2, 0.6172306382193644)
        tdSql.checkData(46, 3, 1.835550377607515)
        tdSql.checkData(46, 4, nan)
        tdSql.checkData(46, 5, 0.11431954199291106)
        tdSql.checkData(46, 6, 5.165381146246765)
        tdSql.checkData(47, 0, 26)
        tdSql.checkData(47, 1, 0.27090578830786904)
        tdSql.checkData(47, 2, 0.6172306382193644)
        tdSql.checkData(47, 3, 1.835550377607515)
        tdSql.checkData(47, 4, nan)
        tdSql.checkData(47, 5, 0.11431954199291106)
        tdSql.checkData(47, 6, 5.165381146246765)
        tdSql.checkData(48, 0, 25)
        tdSql.checkData(48, 1, 0.956375928404503)
        tdSql.checkData(48, 2, 0.6628179613691831)
        tdSql.checkData(48, 3, 3.4435632194258416)
        tdSql.checkData(48, 4, nan)
        tdSql.checkData(48, 5, 0.05676687083562715)
        tdSql.checkData(48, 6, 2.6040987392745354)
        tdSql.checkData(49, 0, 25)
        tdSql.checkData(49, 1, 0.956375928404503)
        tdSql.checkData(49, 2, 0.6628179613691831)
        tdSql.checkData(49, 3, 3.4435632194258416)
        tdSql.checkData(49, 4, nan)
        tdSql.checkData(49, 5, 0.05676687083562715)
        tdSql.checkData(49, 6, 2.6040987392745354)
        tdSql.checkData(50, 0, 24)
        tdSql.checkData(50, 1, 0.7625584504796027)
        tdSql.checkData(50, 2, 0.999960827417674)
        tdSql.checkData(50, 3, 1.2552318002593996)
        tdSql.checkData(50, 4, nan)
        tdSql.checkData(50, 5, 0.6200983185456957)
        tdSql.checkData(50, 6, 0.09684864095463253)
        tdSql.checkData(51, 0, 24)
        tdSql.checkData(51, 1, 0.7625584504796027)
        tdSql.checkData(51, 2, 0.999960827417674)
        tdSql.checkData(51, 3, 1.2552318002593996)
        tdSql.checkData(51, 4, nan)
        tdSql.checkData(51, 5, 0.6200983185456957)
        tdSql.checkData(51, 6, 0.09684864095463253)
        tdSql.checkData(52, 0, 23)
        tdSql.checkData(52, 1, -0.13235175009777303)
        tdSql.checkData(52, 2, 0.6699494442536529)
        tdSql.checkData(52, 3, 1.5387402975985367)
        tdSql.checkData(52, 4, nan)
        tdSql.checkData(52, 5, 1.1825447904081037)
        tdSql.checkData(52, 6, 5.489941431040083)
        tdSql.checkData(53, 0, 23)
        tdSql.checkData(53, 1, -0.13235175009777303)
        tdSql.checkData(53, 2, 0.6699494442536529)
        tdSql.checkData(53, 3, 1.5387402975985367)
        tdSql.checkData(53, 4, nan)
        tdSql.checkData(53, 5, 1.1825447904081037)
        tdSql.checkData(53, 6, 5.489941431040083)
        tdSql.checkData(54, 0, 22)
        tdSql.checkData(54, 1, -0.9055783620066239)
        tdSql.checkData(54, 2, 0.6114178044194122)
        tdSql.checkData(54, 3, 3.5568711064263105)
        tdSql.checkData(54, 4, nan)
        tdSql.checkData(54, 5, 0.9837833410919679)
        tdSql.checkData(54, 6, 3.0265535811470983)
        tdSql.checkData(55, 0, 22)
        tdSql.checkData(55, 1, -0.9055783620066239)
        tdSql.checkData(55, 2, 0.6114178044194122)
        tdSql.checkData(55, 3, 3.5568711064263105)
        tdSql.checkData(55, 4, nan)
        tdSql.checkData(55, 5, 0.9837833410919679)
        tdSql.checkData(55, 6, 3.0265535811470983)
        tdSql.checkData(56, 0, 21)
        tdSql.checkData(56, 1, -0.8462204041751706)
        tdSql.checkData(56, 2, 0.9887894200405688)
        tdSql.checkData(56, 3, 1.5772240911721418)
        tdSql.checkData(56, 4, nan)
        tdSql.checkData(56, 5, -0.11647857397382422)
        tdSql.checkData(56, 6, 0.5559799244477626)
        tdSql.checkData(57, 0, 21)
        tdSql.checkData(57, 1, -0.8462204041751706)
        tdSql.checkData(57, 2, 0.9887894200405688)
        tdSql.checkData(57, 3, 1.5772240911721418)
        tdSql.checkData(57, 4, nan)
        tdSql.checkData(57, 5, -0.11647857397382422)
        tdSql.checkData(57, 6, 0.5559799244477626)
        tdSql.checkData(58, 0, 20)
        tdSql.checkData(58, 1, -0.008851309290403876)
        tdSql.checkData(58, 2, 0.7310155667453407)
        tdSql.checkData(58, 3, 1.2127175951404974)
        tdSql.checkData(58, 4, nan)
        tdSql.checkData(58, 5, -1.4304290589415767)
        tdSql.checkData(58, 6, 5.982274104704091)
        tdSql.checkData(59, 0, 20)
        tdSql.checkData(59, 1, -0.008851309290403876)
        tdSql.checkData(59, 2, 0.7310155667453407)
        tdSql.checkData(59, 3, 1.2127175951404974)
        tdSql.checkData(59, 4, nan)
        tdSql.checkData(59, 5, -1.4304290589415767)
        tdSql.checkData(59, 6, 5.982274104704091)
        tdSql.checkData(60, 0, 19)
        tdSql.checkData(60, 1, 0.8366556385360561)
        tdSql.checkData(60, 2, 0.5723746128431292)
        tdSql.checkData(60, 3, 3.413484890511323)
        tdSql.checkData(60, 4, nan)
        tdSql.checkData(60, 5, -1.9952541841757747)
        tdSql.checkData(60, 6, 3.4479580493217856)
        tdSql.checkData(61, 0, 19)
        tdSql.checkData(61, 1, 0.8366556385360561)
        tdSql.checkData(61, 2, 0.5723746128431292)
        tdSql.checkData(61, 3, 3.413484890511323)
        tdSql.checkData(61, 4, nan)
        tdSql.checkData(61, 5, -1.9952541841757747)
        tdSql.checkData(61, 6, 3.4479580493217856)
        tdSql.checkData(62, 0, 18)
        tdSql.checkData(62, 1, 0.9129452507276277)
        tdSql.checkData(62, 2, 0.9588413200803038)
        tdSql.checkData(62, 3, 1.8713332491184997)
        tdSql.checkData(62, 4, nan)
        tdSql.checkData(62, 5, -1.3983047743451864)
        tdSql.checkData(62, 6, 0.8709074342191974)
        tdSql.checkData(63, 0, 18)
        tdSql.checkData(63, 1, 0.9129452507276277)
        tdSql.checkData(63, 2, 0.9588413200803038)
        tdSql.checkData(63, 3, 1.8713332491184997)
        tdSql.checkData(63, 4, nan)
        tdSql.checkData(63, 5, -1.3983047743451864)
        tdSql.checkData(63, 6, 0.8709074342191974)
        tdSql.checkData(64, 0, 17)
        tdSql.checkData(64, 1, 0.14987720966295234)
        tdSql.checkData(64, 2, 0.7959095686227995)
        tdSql.checkData(64, 3, 0.864944320724419)
        tdSql.checkData(64, 4, nan)
        tdSql.checkData(64, 5, -0.13037289959062748)
        tdSql.checkData(64, 6, 7.022998331594864)
        tdSql.checkData(65, 0, 17)
        tdSql.checkData(65, 1, 0.14987720966295234)
        tdSql.checkData(65, 2, 0.7959095686227995)
        tdSql.checkData(65, 3, 0.864944320724419)
        tdSql.checkData(65, 4, nan)
        tdSql.checkData(65, 5, -0.13037289959062748)
        tdSql.checkData(65, 6, 7.022998331594864)
        tdSql.checkData(66, 0, 16)
        tdSql.checkData(66, 1, -0.750987246771676)
        tdSql.checkData(66, 2, 0.5481819942730298)
        tdSql.checkData(66, 3, 3.102748784455539)
        tdSql.checkData(66, 4, nan)
        tdSql.checkData(66, 5, 0.8513297604701857)
        tdSql.checkData(66, 6, 3.852058923265594)
        tdSql.checkData(67, 0, 16)
        tdSql.checkData(67, 1, -0.750987246771676)
        tdSql.checkData(67, 2, 0.5481819942730298)
        tdSql.checkData(67, 3, 3.102748784455539)
        tdSql.checkData(67, 4, nan)
        tdSql.checkData(67, 5, 0.8513297604701857)
        tdSql.checkData(67, 6, 3.852058923265594)
        tdSql.checkData(68, 0, 15)
        tdSql.checkData(68, 1, -0.9613974918795568)
        tdSql.checkData(68, 2, 0.9130208165623314)
        tdSql.checkData(68, 3, 2.1554866011151765)
        tdSql.checkData(68, 4, nan)
        tdSql.checkData(68, 5, 0.9521751875546269)
        tdSql.checkData(68, 6, 1.1559749749986195)
        tdSql.checkData(69, 0, 15)
        tdSql.checkData(69, 1, -0.9613974918795568)
        tdSql.checkData(69, 2, 0.9130208165623314)
        tdSql.checkData(69, 3, 2.1554866011151765)
        tdSql.checkData(69, 4, nan)
        tdSql.checkData(69, 5, 0.9521751875546269)
        tdSql.checkData(69, 6, 1.1559749749986195)
        tdSql.checkData(70, 0, 14)
        tdSql.checkData(70, 1, -0.2879033166650653)
        tdSql.checkData(70, 2, 0.859465627274523)
        tdSql.checkData(70, 3, 0.5636905248139659)
        tdSql.checkData(70, 4, nan)
        tdSql.checkData(70, 5, 0.41142163587369207)
        tdSql.checkData(70, 6, 10.515512404402676)
        tdSql.checkData(71, 0, 14)
        tdSql.checkData(71, 1, -0.2879033166650653)
        tdSql.checkData(71, 2, 0.859465627274523)
        tdSql.checkData(71, 3, 0.5636905248139659)
        tdSql.checkData(71, 4, nan)
        tdSql.checkData(71, 5, 0.41142163587369207)
        tdSql.checkData(71, 6, 10.515512404402676)
        tdSql.checkData(72, 0, 13)
        tdSql.checkData(72, 1, 0.6502878401571168)
        tdSql.checkData(72, 2, 0.5403105467456532)
        tdSql.checkData(72, 3, 2.75535470715349)
        tdSql.checkData(72, 4, nan)
        tdSql.checkData(72, 5, 0.0009616202598659029)
        tdSql.checkData(72, 6, 4.225579583416092)
        tdSql.checkData(73, 0, 13)
        tdSql.checkData(73, 1, 0.6502878401571168)
        tdSql.checkData(73, 2, 0.5403105467456532)
        tdSql.checkData(73, 3, 2.75535470715349)
        tdSql.checkData(73, 4, nan)
        tdSql.checkData(73, 5, 0.0009616202598659029)
        tdSql.checkData(73, 6, 4.225579583416092)
        tdSql.checkData(74, 0, 12)
        tdSql.checkData(74, 1, 0.9906073556948704)
        tdSql.checkData(74, 2, 0.8556343548213666)
        tdSql.checkData(74, 3, 2.451594361777497)
        tdSql.checkData(74, 4, nan)
        tdSql.checkData(74, 5, 0.24838494428124291)
        tdSql.checkData(74, 6, 1.4585617093317953)
        tdSql.checkData(75, 0, 12)
        tdSql.checkData(75, 1, 0.9906073556948704)
        tdSql.checkData(75, 2, 0.8556343548213666)
        tdSql.checkData(75, 3, 2.451594361777497)
        tdSql.checkData(75, 4, nan)
        tdSql.checkData(75, 5, 0.24838494428124291)
        tdSql.checkData(75, 6, 1.4585617093317953)
        tdSql.checkData(76, 0, 11)
        tdSql.checkData(76, 1, 0.4201670368266409)
        tdSql.checkData(76, 2, 0.9162743174606308)
        tdSql.checkData(76, 3, 0.44272645708128566)
        tdSql.checkData(76, 4, nan)
        tdSql.checkData(76, 5, 0.9151372562290566)
        tdSql.checkData(76, 6, -222.95969776348554)
        tdSql.checkData(77, 0, 11)
        tdSql.checkData(77, 1, 0.4201670368266409)
        tdSql.checkData(77, 2, 0.9162743174606308)
        tdSql.checkData(77, 3, 0.44272645708128566)
        tdSql.checkData(77, 4, nan)
        tdSql.checkData(77, 5, 0.9151372562290566)
        tdSql.checkData(77, 6, -222.95969776348554)
        tdSql.checkData(78, 0, 10)
        tdSql.checkData(78, 1, -0.5365729180004349)
        tdSql.checkData(78, 2, 0.549226270051226)
        tdSql.checkData(78, 3, 2.432352856101439)
        tdSql.checkData(78, 4, nan)
        tdSql.checkData(78, 5, 1.2185572409879093)
        tdSql.checkData(78, 6, 4.561306078186714)
        tdSql.checkData(79, 0, 10)
        tdSql.checkData(79, 1, -0.5365729180004349)
        tdSql.checkData(79, 2, 0.549226270051226)
        tdSql.checkData(79, 3, 2.432352856101439)
        tdSql.checkData(79, 4, nan)
        tdSql.checkData(79, 5, 1.2185572409879093)
        tdSql.checkData(79, 6, 4.561306078186714)
        tdSql.checkData(80, 0, 9)
        tdSql.checkData(80, 1, -0.9999902065507035)
        tdSql.checkData(80, 2, 0.7918362090144786)
        tdSql.checkData(80, 3, 2.776612511546888)
        tdSql.checkData(80, 4, nan)
        tdSql.checkData(80, 5, 0.5929886271208413)
        tdSql.checkData(80, 6, 1.796697093786514)
        tdSql.checkData(81, 0, 9)
        tdSql.checkData(81, 1, -0.9999902065507035)
        tdSql.checkData(81, 2, 0.7918362090144786)
        tdSql.checkData(81, 3, 2.776612511546888)
        tdSql.checkData(81, 4, nan)
        tdSql.checkData(81, 5, 0.5929886271208413)
        tdSql.checkData(81, 6, 1.796697093786514)
        tdSql.checkData(82, 0, 8)
        tdSql.checkData(82, 1, -0.5440211108893698)
        tdSql.checkData(82, 2, 0.9612168045072789)
        tdSql.checkData(82, 3, 0.5787344727995947)
        tdSql.checkData(82, 4, nan)
        tdSql.checkData(82, 5, -0.7199655182148126)
        tdSql.checkData(82, 6, -4.087614771885445)
        tdSql.checkData(83, 0, 8)
        tdSql.checkData(83, 1, -0.5440211108893698)
        tdSql.checkData(83, 2, 0.9612168045072789)
        tdSql.checkData(83, 3, 0.5787344727995947)
        tdSql.checkData(83, 4, nan)
        tdSql.checkData(83, 5, -0.7199655182148126)
        tdSql.checkData(83, 6, -4.087614771885445)
        tdSql.checkData(84, 0, 7)
        tdSql.checkData(84, 1, 0.4121184852417566)
        tdSql.checkData(84, 2, 0.574400879193934)
        tdSql.checkData(84, 3, 2.137595835197328)
        tdSql.checkData(84, 4, nan)
        tdSql.checkData(84, 5, -1.8119088619792247)
        tdSql.checkData(84, 6, 4.862055338419189)
        tdSql.checkData(85, 0, 7)
        tdSql.checkData(85, 1, 0.4121184852417566)
        tdSql.checkData(85, 2, 0.574400879193934)
        tdSql.checkData(85, 3, 2.137595835197328)
        tdSql.checkData(85, 4, nan)
        tdSql.checkData(85, 5, -1.8119088619792247)
        tdSql.checkData(85, 6, 4.862055338419189)
        tdSql.checkData(86, 0, 6)
        tdSql.checkData(86, 1, 0.9893582466233818)
        tdSql.checkData(86, 2, 0.7270351311688125)
        tdSql.checkData(86, 3, 3.1243204798042576)
        tdSql.checkData(86, 4, nan)
        tdSql.checkData(86, 5, -1.8696882565721156)
        tdSql.checkData(86, 6, 2.172420890614816)
        tdSql.checkData(87, 0, 6)
        tdSql.checkData(87, 1, 0.9893582466233818)
        tdSql.checkData(87, 2, 0.7270351311688125)
        tdSql.checkData(87, 3, 3.1243204798042576)
        tdSql.checkData(87, 4, nan)
        tdSql.checkData(87, 5, -1.8696882565721156)
        tdSql.checkData(87, 6, 2.172420890614816)
        tdSql.checkData(88, 0, 5)
        tdSql.checkData(88, 1, 0.6569865987187891)
        tdSql.checkData(88, 2, 0.9900590857598653)
        tdSql.checkData(88, 3, 0.8864495743441427)
        tdSql.checkData(88, 4, nan)
        tdSql.checkData(88, 5, -0.876294736008743)
        tdSql.checkData(88, 6, -0.9245361171359558)
        tdSql.checkData(89, 0, 5)
        tdSql.checkData(89, 1, 0.6569865987187891)
        tdSql.checkData(89, 2, 0.9900590857598653)
        tdSql.checkData(89, 3, 0.8864495743441427)
        tdSql.checkData(89, 4, nan)
        tdSql.checkData(89, 5, -0.876294736008743)
        tdSql.checkData(89, 6, -0.9245361171359558)
        tdSql.checkData(90, 0, 4)
        tdSql.checkData(90, 1, -0.27941549819892586)
        tdSql.checkData(90, 2, 0.6143002821164822)
        tdSql.checkData(90, 3, 1.853464438509776)
        tdSql.checkData(90, 4, nan)
        tdSql.checkData(90, 5, 0.38234027607634785)
        tdSql.checkData(90, 6, 5.147179528972959)
        tdSql.checkData(91, 0, 4)
        tdSql.checkData(91, 1, -0.27941549819892586)
        tdSql.checkData(91, 2, 0.6143002821164822)
        tdSql.checkData(91, 3, 1.853464438509776)
        tdSql.checkData(91, 4, nan)
        tdSql.checkData(91, 5, 0.38234027607634785)
        tdSql.checkData(91, 6, 5.147179528972959)
        tdSql.checkData(92, 0, 3)
        tdSql.checkData(92, 1, -0.9589242746631385)
        tdSql.checkData(92, 2, 0.6663667453928805)
        tdSql.checkData(92, 3, 3.4288753232277074)
        tdSql.checkData(92, 4, nan)
        tdSql.checkData(92, 5, 1.0087371784424417)
        tdSql.checkData(92, 6, 2.5780379587267963)
        tdSql.checkData(93, 0, 3)
        tdSql.checkData(93, 1, -0.9589242746631385)
        tdSql.checkData(93, 2, 0.6663667453928805)
        tdSql.checkData(93, 3, 3.4288753232277074)
        tdSql.checkData(93, 4, nan)
        tdSql.checkData(93, 5, 1.0087371784424417)
        tdSql.checkData(93, 6, 2.5780379587267963)
        tdSql.checkData(94, 0, 2)
        tdSql.checkData(94, 1, -0.7568024953079282)
        tdSql.checkData(94, 2, 1.0)
        tdSql.checkData(94, 3, 1.2340302976078754)
        tdSql.checkData(94, 4, nan)
        tdSql.checkData(94, 5, 0.7554222939559553)
        tdSql.checkData(94, 6, 0.05815764143055291)
        tdSql.checkData(95, 0, 2)
        tdSql.checkData(95, 1, -0.7568024953079282)
        tdSql.checkData(95, 2, 1.0)
        tdSql.checkData(95, 3, 1.2340302976078754)
        tdSql.checkData(95, 4, nan)
        tdSql.checkData(95, 5, 0.7554222939559553)
        tdSql.checkData(95, 6, 0.05815764143055291)
        tdSql.checkData(96, 0, 1)
        tdSql.checkData(96, 1, 0.1411200080598672)
        tdSql.checkData(96, 2, 0.6663667453928805)
        tdSql.checkData(96, 3, 1.558041126155035)
        tdSql.checkData(96, 4, 1.8325957145940461)
        tdSql.checkData(96, 5, 0.17204223631998083)
        tdSql.checkData(96, 6, nan)
        tdSql.checkData(97, 0, 1)
        tdSql.checkData(97, 1, 0.1411200080598672)
        tdSql.checkData(97, 2, 0.6663667453928805)
        tdSql.checkData(97, 3, 1.558041126155035)
        tdSql.checkData(97, 4, 1.8325957145940461)
        tdSql.checkData(97, 5, 0.17204223631998083)
        tdSql.checkData(97, 6, nan)
        tdSql.checkData(98, 0, 0)
        tdSql.checkData(98, 1, 0.7780731968879212)
        tdSql.checkData(98, 2, 0.6143002821164822)
        tdSql.checkData(98, 3, 3.2037266279837113)
        tdSql.checkData(98, 4, nan)
        tdSql.checkData(98, 5, 0.02246988233490299)
        tdSql.checkData(98, 6, nan)
        tdSql.checkData(99, 0, 0)
        tdSql.checkData(99, 1, 0.7780731968879212)
        tdSql.checkData(99, 2, 0.6143002821164822)
        tdSql.checkData(99, 3, 3.2037266279837113)
        tdSql.checkData(99, 4, nan)
        tdSql.checkData(99, 5, 0.02246988233490299)
        tdSql.checkData(99, 6, nan)

        tdSql.query(
            "select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6 from (select * from ct1 order by ts limit 2);;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.7780731968879212)
        tdSql.checkData(0, 2, 0.6143002821164822)
        tdSql.checkData(0, 3, 3.2037266279837113)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.02246988233490299)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.1411200080598672)
        tdSql.checkData(1, 2, 0.6663667453928805)
        tdSql.checkData(1, 3, 1.558041126155035)
        tdSql.checkData(1, 4, 1.8325957145940461)
        tdSql.checkData(1, 5, 0.17204223631998083)
        tdSql.checkData(1, 6, nan)

        tdSql.query(
            "select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6 from (select * from st0 ) order by ts desc;"
        )
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, 49)
        tdSql.checkData(0, 1, 0.6702291758433747)
        tdSql.checkData(0, 2, 0.9923745526637894)
        tdSql.checkData(0, 3, 0.9298143670243166)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.7136182821549459)
        tdSql.checkData(0, 6, -0.7462904241496138)
        tdSql.checkData(1, 0, 49)
        tdSql.checkData(1, 1, 0.6702291758433747)
        tdSql.checkData(1, 2, 0.9923745526637894)
        tdSql.checkData(1, 3, 0.9298143670243166)
        tdSql.checkData(1, 4, nan)
        tdSql.checkData(1, 5, 0.7136182821549459)
        tdSql.checkData(1, 6, -0.7462904241496138)
        tdSql.checkData(2, 0, 48)
        tdSql.checkData(2, 1, -0.26237485370392877)
        tdSql.checkData(2, 2, 0.6202081141679935)
        tdSql.checkData(2, 3, 1.8175857333771335)
        tdSql.checkData(2, 4, nan)
        tdSql.checkData(2, 5, 1.211884234321115)
        tdSql.checkData(2, 6, 5.183714988550632)
        tdSql.checkData(3, 0, 48)
        tdSql.checkData(3, 1, -0.26237485370392877)
        tdSql.checkData(3, 2, 0.6202081141679935)
        tdSql.checkData(3, 3, 1.8175857333771335)
        tdSql.checkData(3, 4, nan)
        tdSql.checkData(3, 5, 1.211884234321115)
        tdSql.checkData(3, 6, 5.183714988550632)
        tdSql.checkData(4, 0, 47)
        tdSql.checkData(4, 1, -0.9537526527594719)
        tdSql.checkData(4, 2, 0.6593040763085178)
        tdSql.checkData(4, 3, 3.4575106745458637)
        tdSql.checkData(4, 4, nan)
        tdSql.checkData(4, 5, 0.8820838187306987)
        tdSql.checkData(4, 6, 2.6302204463996084)
        tdSql.checkData(5, 0, 47)
        tdSql.checkData(5, 1, -0.9537526527594719)
        tdSql.checkData(5, 2, 0.6593040763085178)
        tdSql.checkData(5, 3, 3.4575106745458637)
        tdSql.checkData(5, 4, nan)
        tdSql.checkData(5, 5, 0.8820838187306987)
        tdSql.checkData(5, 6, 2.6302204463996084)
        tdSql.checkData(6, 0, 46)
        tdSql.checkData(6, 1, -0.7682546613236668)
        tdSql.checkData(6, 2, 0.9998433250151273)
        tdSql.checkData(6, 3, 1.2763169256468458)
        tdSql.checkData(6, 4, nan)
        tdSql.checkData(6, 5, -0.300459258677913)
        tdSql.checkData(6, 6, 0.13392039926281352)
        tdSql.checkData(7, 0, 46)
        tdSql.checkData(7, 1, -0.7682546613236668)
        tdSql.checkData(7, 2, 0.9998433250151273)
        tdSql.checkData(7, 3, 1.2763169256468458)
        tdSql.checkData(7, 4, nan)
        tdSql.checkData(7, 5, -0.300459258677913)
        tdSql.checkData(7, 6, 0.13392039926281352)
        tdSql.checkData(8, 0, 45)
        tdSql.checkData(8, 1, 0.123573122745224)
        tdSql.checkData(8, 2, 0.6735650596658175)
        tdSql.checkData(8, 3, 1.5193186190030223)
        tdSql.checkData(8, 4, nan)
        tdSql.checkData(8, 5, -1.5661895943272113)
        tdSql.checkData(8, 6, 5.513771854144419)
        tdSql.checkData(9, 0, 45)
        tdSql.checkData(9, 1, 0.123573122745224)
        tdSql.checkData(9, 2, 0.6735650596658175)
        tdSql.checkData(9, 3, 1.5193186190030223)
        tdSql.checkData(9, 4, nan)
        tdSql.checkData(9, 5, -1.5661895943272113)
        tdSql.checkData(9, 6, 5.513771854144419)
        tdSql.checkData(10, 0, 44)
        tdSql.checkData(10, 1, 0.9017883476488092)
        tdSql.checkData(10, 2, 0.6085839480802863)
        tdSql.checkData(10, 3, 3.5552629892514687)
        tdSql.checkData(10, 4, nan)
        tdSql.checkData(10, 5, -1.9810692649977342)
        tdSql.checkData(10, 6, 3.0531030020123464)
        tdSql.checkData(11, 0, 44)
        tdSql.checkData(11, 1, 0.9017883476488092)
        tdSql.checkData(11, 2, 0.6085839480802863)
        tdSql.checkData(11, 3, 3.5552629892514687)
        tdSql.checkData(11, 4, nan)
        tdSql.checkData(11, 5, -1.9810692649977342)
        tdSql.checkData(11, 6, 3.0531030020123464)
        tdSql.checkData(12, 0, 43)
        tdSql.checkData(12, 1, 0.8509035245341184)
        tdSql.checkData(12, 2, 0.9874457808369176)
        tdSql.checkData(12, 3, 1.5962924548219202)
        tdSql.checkData(12, 4, nan)
        tdSql.checkData(12, 5, -1.2490970766755156)
        tdSql.checkData(12, 6, 0.5781542141407696)
        tdSql.checkData(13, 0, 43)
        tdSql.checkData(13, 1, 0.8509035245341184)
        tdSql.checkData(13, 2, 0.9874457808369176)
        tdSql.checkData(13, 3, 1.5962924548219202)
        tdSql.checkData(13, 4, nan)
        tdSql.checkData(13, 5, -1.2490970766755156)
        tdSql.checkData(13, 6, 0.5781542141407696)
        tdSql.checkData(14, 0, 42)
        tdSql.checkData(14, 1, 0.017701925105413577)
        tdSql.checkData(14, 2, 0.7350111780599404)
        tdSql.checkData(14, 3, 1.1912997639866574)
        tdSql.checkData(14, 4, nan)
        tdSql.checkData(14, 5, 0.036467324189017214)
        tdSql.checkData(14, 6, 6.024578312510778)
        tdSql.checkData(15, 0, 42)
        tdSql.checkData(15, 1, 0.017701925105413577)
        tdSql.checkData(15, 2, 0.7350111780599404)
        tdSql.checkData(15, 3, 1.1912997639866574)
        tdSql.checkData(15, 4, nan)
        tdSql.checkData(15, 5, 0.036467324189017214)
        tdSql.checkData(15, 6, 6.024578312510778)
        tdSql.checkData(16, 0, 41)
        tdSql.checkData(16, 1, -0.8317747426285983)
        tdSql.checkData(16, 2, 0.5704067143341829)
        tdSql.checkData(16, 3, 3.397430462894578)
        tdSql.checkData(16, 4, nan)
        tdSql.checkData(16, 5, 0.9190273051332304)
        tdSql.checkData(16, 6, 3.473885481113728)
        tdSql.checkData(17, 0, 41)
        tdSql.checkData(17, 1, -0.8317747426285983)
        tdSql.checkData(17, 2, 0.5704067143341829)
        tdSql.checkData(17, 3, 3.397430462894578)
        tdSql.checkData(17, 4, nan)
        tdSql.checkData(17, 5, 0.9190273051332304)
        tdSql.checkData(17, 6, 3.473885481113728)
        tdSql.checkData(18, 0, 40)
        tdSql.checkData(18, 1, -0.9165215479156338)
        tdSql.checkData(18, 2, 0.9564033460276342)
        tdSql.checkData(18, 3, 1.889162191085516)
        tdSql.checkData(18, 4, nan)
        tdSql.checkData(18, 5, 0.90296737936602)
        tdSql.checkData(18, 6, 0.888896415152729)
        tdSql.checkData(19, 0, 40)
        tdSql.checkData(19, 1, -0.9165215479156338)
        tdSql.checkData(19, 2, 0.9564033460276342)
        tdSql.checkData(19, 3, 1.889162191085516)
        tdSql.checkData(19, 4, nan)
        tdSql.checkData(19, 5, 0.90296737936602)
        tdSql.checkData(19, 6, 0.888896415152729)
        tdSql.checkData(20, 0, 39)
        tdSql.checkData(20, 1, -0.158622668804709)
        tdSql.checkData(20, 2, 0.7999777847134487)
        tdSql.checkData(20, 3, 0.8435920138756074)
        tdSql.checkData(20, 4, nan)
        tdSql.checkData(20, 5, 0.3319994538301167)
        tdSql.checkData(20, 6, 7.12853286308907)
        tdSql.checkData(21, 0, 39)
        tdSql.checkData(21, 1, -0.158622668804709)
        tdSql.checkData(21, 2, 0.7999777847134487)
        tdSql.checkData(21, 3, 0.8435920138756074)
        tdSql.checkData(21, 4, nan)
        tdSql.checkData(21, 5, 0.3319994538301167)
        tdSql.checkData(21, 6, 7.12853286308907)
        tdSql.checkData(22, 0, 38)
        tdSql.checkData(22, 1, 0.7451131604793488)
        tdSql.checkData(22, 2, 0.5472018255605284)
        tdSql.checkData(22, 3, 3.081063350979351)
        tdSql.checkData(22, 4, nan)
        tdSql.checkData(22, 5, -0.007381884932924798)
        tdSql.checkData(22, 6, 3.8764172978929814)
        tdSql.checkData(23, 0, 38)
        tdSql.checkData(23, 1, 0.7451131604793488)
        tdSql.checkData(23, 2, 0.5472018255605284)
        tdSql.checkData(23, 3, 3.081063350979351)
        tdSql.checkData(23, 4, nan)
        tdSql.checkData(23, 5, -0.007381884932924798)
        tdSql.checkData(23, 6, 3.8764172978929814)
        tdSql.checkData(24, 0, 37)
        tdSql.checkData(24, 1, 0.9637953862840878)
        tdSql.checkData(24, 2, 0.909721840267583)
        tdSql.checkData(24, 3, 2.1734252903776303)
        tdSql.checkData(24, 4, nan)
        tdSql.checkData(24, 5, 0.32696474077278626)
        tdSql.checkData(24, 6, 1.174082484128993)
        tdSql.checkData(25, 0, 37)
        tdSql.checkData(25, 1, 0.9637953862840878)
        tdSql.checkData(25, 2, 0.909721840267583)
        tdSql.checkData(25, 3, 2.1734252903776303)
        tdSql.checkData(25, 4, nan)
        tdSql.checkData(25, 5, 0.32696474077278626)
        tdSql.checkData(25, 6, 1.174082484128993)
        tdSql.checkData(26, 0, 36)
        tdSql.checkData(26, 1, 0.2963685787093853)
        tdSql.checkData(26, 2, 0.8632704401895588)
        tdSql.checkData(26, 3, 0.5493681603601657)
        tdSql.checkData(26, 4, nan)
        tdSql.checkData(26, 5, 0.9944678850925007)
        tdSql.checkData(26, 6, 11.004294268461184)
        tdSql.checkData(27, 0, 36)
        tdSql.checkData(27, 1, 0.2963685787093853)
        tdSql.checkData(27, 2, 0.8632704401895588)
        tdSql.checkData(27, 3, 0.5493681603601657)
        tdSql.checkData(27, 4, nan)
        tdSql.checkData(27, 5, 0.9944678850925007)
        tdSql.checkData(27, 6, 11.004294268461184)
        tdSql.checkData(28, 0, 35)
        tdSql.checkData(28, 1, -0.6435381333569995)
        tdSql.checkData(28, 2, 0.5403764709316752)
        tdSql.checkData(28, 3, 2.734210799811235)
        tdSql.checkData(28, 4, nan)
        tdSql.checkData(28, 5, 1.1930854189064375)
        tdSql.checkData(28, 6, 4.24770540197234)
        tdSql.checkData(29, 0, 35)
        tdSql.checkData(29, 1, -0.6435381333569995)
        tdSql.checkData(29, 2, 0.5403764709316752)
        tdSql.checkData(29, 3, 2.734210799811235)
        tdSql.checkData(29, 4, nan)
        tdSql.checkData(29, 5, 1.1930854189064375)
        tdSql.checkData(29, 6, 4.24770540197234)
        tdSql.checkData(30, 0, 34)
        tdSql.checkData(30, 1, -0.9917788534431158)
        tdSql.checkData(30, 2, 0.8517779466253769)
        tdSql.checkData(30, 3, 2.470955260231499)
        tdSql.checkData(30, 4, nan)
        tdSql.checkData(30, 5, 0.4428112547200472)
        tdSql.checkData(30, 6, 1.4785733565944832)
        tdSql.checkData(31, 0, 34)
        tdSql.checkData(31, 1, -0.9917788534431158)
        tdSql.checkData(31, 2, 0.8517779466253769)
        tdSql.checkData(31, 3, 2.470955260231499)
        tdSql.checkData(31, 4, nan)
        tdSql.checkData(31, 5, 0.4428112547200472)
        tdSql.checkData(31, 6, 1.4785733565944832)
        tdSql.checkData(32, 0, 33)
        tdSql.checkData(32, 1, -0.428182669496151)
        tdSql.checkData(32, 2, 0.9194811573015673)
        tdSql.checkData(32, 3, 0.4437992589174107)
        tdSql.checkData(32, 4, nan)
        tdSql.checkData(32, 5, -0.9001958571391758)
        tdSql.checkData(32, 6, -72.33956595410905)
        tdSql.checkData(33, 0, 33)
        tdSql.checkData(33, 1, -0.428182669496151)
        tdSql.checkData(33, 2, 0.9194811573015673)
        tdSql.checkData(33, 3, 0.4437992589174107)
        tdSql.checkData(33, 4, nan)
        tdSql.checkData(33, 5, -0.9001958571391758)
        tdSql.checkData(33, 6, -72.33956595410905)
        tdSql.checkData(34, 0, 32)
        tdSql.checkData(34, 1, 0.5290826861200238)
        tdSql.checkData(34, 2, 0.5503344099628432)
        tdSql.checkData(34, 3, 2.413227615833899)
        tdSql.checkData(34, 4, nan)
        tdSql.checkData(34, 5, -1.8893763681780902)
        tdSql.checkData(34, 6, 4.581032079680554)
        tdSql.checkData(35, 0, 32)
        tdSql.checkData(35, 1, 0.5290826861200238)
        tdSql.checkData(35, 2, 0.5503344099628432)
        tdSql.checkData(35, 3, 2.413227615833899)
        tdSql.checkData(35, 4, nan)
        tdSql.checkData(35, 5, -1.8893763681780902)
        tdSql.checkData(35, 6, 4.581032079680554)
        tdSql.checkData(36, 0, 31)
        tdSql.checkData(36, 1, 0.9999118601072672)
        tdSql.checkData(36, 2, 0.7877590247885756)
        tdSql.checkData(36, 3, 2.7979785951133604)
        tdSql.checkData(36, 4, nan)
        tdSql.checkData(36, 5, -1.7874722290307907)
        tdSql.checkData(36, 6, 1.8191237353300793)
        tdSql.checkData(37, 0, 31)
        tdSql.checkData(37, 1, 0.9999118601072672)
        tdSql.checkData(37, 2, 0.7877590247885756)
        tdSql.checkData(37, 3, 2.7979785951133604)
        tdSql.checkData(37, 4, nan)
        tdSql.checkData(37, 5, -1.7874722290307907)
        tdSql.checkData(37, 6, 1.8191237353300793)
        tdSql.checkData(38, 0, 30)
        tdSql.checkData(38, 1, 0.5514266812416906)
        tdSql.checkData(38, 2, 0.9635288988181601)
        tdSql.checkData(38, 3, 0.5944617511422015)
        tdSql.checkData(38, 4, nan)
        tdSql.checkData(38, 5, -0.7022004347538967)
        tdSql.checkData(38, 6, -3.710141817748492)
        tdSql.checkData(39, 0, 30)
        tdSql.checkData(39, 1, 0.5514266812416906)
        tdSql.checkData(39, 2, 0.9635288988181601)
        tdSql.checkData(39, 3, 0.5944617511422015)
        tdSql.checkData(39, 4, nan)
        tdSql.checkData(39, 5, -0.7022004347538967)
        tdSql.checkData(39, 6, -3.710141817748492)
        tdSql.checkData(40, 0, 29)
        tdSql.checkData(40, 1, -0.404037645323065)
        tdSql.checkData(40, 2, 0.5764850221962442)
        tdSql.checkData(40, 3, 2.1197476343754156)
        tdSql.checkData(40, 4, nan)
        tdSql.checkData(40, 5, 0.5162157333804713)
        tdSql.checkData(40, 6, 4.8800154918827525)
        tdSql.checkData(41, 0, 29)
        tdSql.checkData(41, 1, -0.404037645323065)
        tdSql.checkData(41, 2, 0.5764850221962442)
        tdSql.checkData(41, 3, 2.1197476343754156)
        tdSql.checkData(41, 4, nan)
        tdSql.checkData(41, 5, 0.5162157333804713)
        tdSql.checkData(41, 6, 4.8800154918827525)
        tdSql.checkData(42, 0, 28)
        tdSql.checkData(42, 1, -0.9880316240928618)
        tdSql.checkData(42, 2, 0.7230710689951642)
        tdSql.checkData(42, 3, 3.1457526648156393)
        tdSql.checkData(42, 4, nan)
        tdSql.checkData(42, 5, 1.0206076417536643)
        tdSql.checkData(42, 6, 2.197019393348823)
        tdSql.checkData(43, 0, 28)
        tdSql.checkData(43, 1, -0.9880316240928618)
        tdSql.checkData(43, 2, 0.7230710689951642)
        tdSql.checkData(43, 3, 3.1457526648156393)
        tdSql.checkData(43, 4, nan)
        tdSql.checkData(43, 5, 1.0206076417536643)
        tdSql.checkData(43, 6, 2.197019393348823)
        tdSql.checkData(44, 0, 27)
        tdSql.checkData(44, 1, -0.6636338842129675)
        tdSql.checkData(44, 2, 0.9912542848596704)
        tdSql.checkData(44, 3, 0.9080812682077812)
        tdSql.checkData(44, 4, nan)
        tdSql.checkData(44, 5, 0.6788951190016388)
        tdSql.checkData(44, 6, -0.8324928492797357)
        tdSql.checkData(45, 0, 27)
        tdSql.checkData(45, 1, -0.6636338842129675)
        tdSql.checkData(45, 2, 0.9912542848596704)
        tdSql.checkData(45, 3, 0.9080812682077812)
        tdSql.checkData(45, 4, nan)
        tdSql.checkData(45, 5, 0.6788951190016388)
        tdSql.checkData(45, 6, -0.8324928492797357)
        tdSql.checkData(46, 0, 26)
        tdSql.checkData(46, 1, 0.27090578830786904)
        tdSql.checkData(46, 2, 0.6172306382193644)
        tdSql.checkData(46, 3, 1.835550377607515)
        tdSql.checkData(46, 4, nan)
        tdSql.checkData(46, 5, 0.11431954199291106)
        tdSql.checkData(46, 6, 5.165381146246765)
        tdSql.checkData(47, 0, 26)
        tdSql.checkData(47, 1, 0.27090578830786904)
        tdSql.checkData(47, 2, 0.6172306382193644)
        tdSql.checkData(47, 3, 1.835550377607515)
        tdSql.checkData(47, 4, nan)
        tdSql.checkData(47, 5, 0.11431954199291106)
        tdSql.checkData(47, 6, 5.165381146246765)
        tdSql.checkData(48, 0, 25)
        tdSql.checkData(48, 1, 0.956375928404503)
        tdSql.checkData(48, 2, 0.6628179613691831)
        tdSql.checkData(48, 3, 3.4435632194258416)
        tdSql.checkData(48, 4, nan)
        tdSql.checkData(48, 5, 0.05676687083562715)
        tdSql.checkData(48, 6, 2.6040987392745354)
        tdSql.checkData(49, 0, 25)
        tdSql.checkData(49, 1, 0.956375928404503)
        tdSql.checkData(49, 2, 0.6628179613691831)
        tdSql.checkData(49, 3, 3.4435632194258416)
        tdSql.checkData(49, 4, nan)
        tdSql.checkData(49, 5, 0.05676687083562715)
        tdSql.checkData(49, 6, 2.6040987392745354)
        tdSql.checkData(50, 0, 24)
        tdSql.checkData(50, 1, 0.7625584504796027)
        tdSql.checkData(50, 2, 0.999960827417674)
        tdSql.checkData(50, 3, 1.2552318002593996)
        tdSql.checkData(50, 4, nan)
        tdSql.checkData(50, 5, 0.6200983185456957)
        tdSql.checkData(50, 6, 0.09684864095463253)
        tdSql.checkData(51, 0, 24)
        tdSql.checkData(51, 1, 0.7625584504796027)
        tdSql.checkData(51, 2, 0.999960827417674)
        tdSql.checkData(51, 3, 1.2552318002593996)
        tdSql.checkData(51, 4, nan)
        tdSql.checkData(51, 5, 0.6200983185456957)
        tdSql.checkData(51, 6, 0.09684864095463253)
        tdSql.checkData(52, 0, 23)
        tdSql.checkData(52, 1, -0.13235175009777303)
        tdSql.checkData(52, 2, 0.6699494442536529)
        tdSql.checkData(52, 3, 1.5387402975985367)
        tdSql.checkData(52, 4, nan)
        tdSql.checkData(52, 5, 1.1825447904081037)
        tdSql.checkData(52, 6, 5.489941431040083)
        tdSql.checkData(53, 0, 23)
        tdSql.checkData(53, 1, -0.13235175009777303)
        tdSql.checkData(53, 2, 0.6699494442536529)
        tdSql.checkData(53, 3, 1.5387402975985367)
        tdSql.checkData(53, 4, nan)
        tdSql.checkData(53, 5, 1.1825447904081037)
        tdSql.checkData(53, 6, 5.489941431040083)
        tdSql.checkData(54, 0, 22)
        tdSql.checkData(54, 1, -0.9055783620066239)
        tdSql.checkData(54, 2, 0.6114178044194122)
        tdSql.checkData(54, 3, 3.5568711064263105)
        tdSql.checkData(54, 4, nan)
        tdSql.checkData(54, 5, 0.9837833410919679)
        tdSql.checkData(54, 6, 3.0265535811470983)
        tdSql.checkData(55, 0, 22)
        tdSql.checkData(55, 1, -0.9055783620066239)
        tdSql.checkData(55, 2, 0.6114178044194122)
        tdSql.checkData(55, 3, 3.5568711064263105)
        tdSql.checkData(55, 4, nan)
        tdSql.checkData(55, 5, 0.9837833410919679)
        tdSql.checkData(55, 6, 3.0265535811470983)
        tdSql.checkData(56, 0, 21)
        tdSql.checkData(56, 1, -0.8462204041751706)
        tdSql.checkData(56, 2, 0.9887894200405688)
        tdSql.checkData(56, 3, 1.5772240911721418)
        tdSql.checkData(56, 4, nan)
        tdSql.checkData(56, 5, -0.11647857397382422)
        tdSql.checkData(56, 6, 0.5559799244477626)
        tdSql.checkData(57, 0, 21)
        tdSql.checkData(57, 1, -0.8462204041751706)
        tdSql.checkData(57, 2, 0.9887894200405688)
        tdSql.checkData(57, 3, 1.5772240911721418)
        tdSql.checkData(57, 4, nan)
        tdSql.checkData(57, 5, -0.11647857397382422)
        tdSql.checkData(57, 6, 0.5559799244477626)
        tdSql.checkData(58, 0, 20)
        tdSql.checkData(58, 1, -0.008851309290403876)
        tdSql.checkData(58, 2, 0.7310155667453407)
        tdSql.checkData(58, 3, 1.2127175951404974)
        tdSql.checkData(58, 4, nan)
        tdSql.checkData(58, 5, -1.4304290589415767)
        tdSql.checkData(58, 6, 5.982274104704091)
        tdSql.checkData(59, 0, 20)
        tdSql.checkData(59, 1, -0.008851309290403876)
        tdSql.checkData(59, 2, 0.7310155667453407)
        tdSql.checkData(59, 3, 1.2127175951404974)
        tdSql.checkData(59, 4, nan)
        tdSql.checkData(59, 5, -1.4304290589415767)
        tdSql.checkData(59, 6, 5.982274104704091)
        tdSql.checkData(60, 0, 19)
        tdSql.checkData(60, 1, 0.8366556385360561)
        tdSql.checkData(60, 2, 0.5723746128431292)
        tdSql.checkData(60, 3, 3.413484890511323)
        tdSql.checkData(60, 4, nan)
        tdSql.checkData(60, 5, -1.9952541841757747)
        tdSql.checkData(60, 6, 3.4479580493217856)
        tdSql.checkData(61, 0, 19)
        tdSql.checkData(61, 1, 0.8366556385360561)
        tdSql.checkData(61, 2, 0.5723746128431292)
        tdSql.checkData(61, 3, 3.413484890511323)
        tdSql.checkData(61, 4, nan)
        tdSql.checkData(61, 5, -1.9952541841757747)
        tdSql.checkData(61, 6, 3.4479580493217856)
        tdSql.checkData(62, 0, 18)
        tdSql.checkData(62, 1, 0.9129452507276277)
        tdSql.checkData(62, 2, 0.9588413200803038)
        tdSql.checkData(62, 3, 1.8713332491184997)
        tdSql.checkData(62, 4, nan)
        tdSql.checkData(62, 5, -1.3983047743451864)
        tdSql.checkData(62, 6, 0.8709074342191974)
        tdSql.checkData(63, 0, 18)
        tdSql.checkData(63, 1, 0.9129452507276277)
        tdSql.checkData(63, 2, 0.9588413200803038)
        tdSql.checkData(63, 3, 1.8713332491184997)
        tdSql.checkData(63, 4, nan)
        tdSql.checkData(63, 5, -1.3983047743451864)
        tdSql.checkData(63, 6, 0.8709074342191974)
        tdSql.checkData(64, 0, 17)
        tdSql.checkData(64, 1, 0.14987720966295234)
        tdSql.checkData(64, 2, 0.7959095686227995)
        tdSql.checkData(64, 3, 0.864944320724419)
        tdSql.checkData(64, 4, nan)
        tdSql.checkData(64, 5, -0.13037289959062748)
        tdSql.checkData(64, 6, 7.022998331594864)
        tdSql.checkData(65, 0, 17)
        tdSql.checkData(65, 1, 0.14987720966295234)
        tdSql.checkData(65, 2, 0.7959095686227995)
        tdSql.checkData(65, 3, 0.864944320724419)
        tdSql.checkData(65, 4, nan)
        tdSql.checkData(65, 5, -0.13037289959062748)
        tdSql.checkData(65, 6, 7.022998331594864)
        tdSql.checkData(66, 0, 16)
        tdSql.checkData(66, 1, -0.750987246771676)
        tdSql.checkData(66, 2, 0.5481819942730298)
        tdSql.checkData(66, 3, 3.102748784455539)
        tdSql.checkData(66, 4, nan)
        tdSql.checkData(66, 5, 0.8513297604701857)
        tdSql.checkData(66, 6, 3.852058923265594)
        tdSql.checkData(67, 0, 16)
        tdSql.checkData(67, 1, -0.750987246771676)
        tdSql.checkData(67, 2, 0.5481819942730298)
        tdSql.checkData(67, 3, 3.102748784455539)
        tdSql.checkData(67, 4, nan)
        tdSql.checkData(67, 5, 0.8513297604701857)
        tdSql.checkData(67, 6, 3.852058923265594)
        tdSql.checkData(68, 0, 15)
        tdSql.checkData(68, 1, -0.9613974918795568)
        tdSql.checkData(68, 2, 0.9130208165623314)
        tdSql.checkData(68, 3, 2.1554866011151765)
        tdSql.checkData(68, 4, nan)
        tdSql.checkData(68, 5, 0.9521751875546269)
        tdSql.checkData(68, 6, 1.1559749749986195)
        tdSql.checkData(69, 0, 15)
        tdSql.checkData(69, 1, -0.9613974918795568)
        tdSql.checkData(69, 2, 0.9130208165623314)
        tdSql.checkData(69, 3, 2.1554866011151765)
        tdSql.checkData(69, 4, nan)
        tdSql.checkData(69, 5, 0.9521751875546269)
        tdSql.checkData(69, 6, 1.1559749749986195)
        tdSql.checkData(70, 0, 14)
        tdSql.checkData(70, 1, -0.2879033166650653)
        tdSql.checkData(70, 2, 0.859465627274523)
        tdSql.checkData(70, 3, 0.5636905248139659)
        tdSql.checkData(70, 4, nan)
        tdSql.checkData(70, 5, 0.41142163587369207)
        tdSql.checkData(70, 6, 10.515512404402676)
        tdSql.checkData(71, 0, 14)
        tdSql.checkData(71, 1, -0.2879033166650653)
        tdSql.checkData(71, 2, 0.859465627274523)
        tdSql.checkData(71, 3, 0.5636905248139659)
        tdSql.checkData(71, 4, nan)
        tdSql.checkData(71, 5, 0.41142163587369207)
        tdSql.checkData(71, 6, 10.515512404402676)
        tdSql.checkData(72, 0, 13)
        tdSql.checkData(72, 1, 0.6502878401571168)
        tdSql.checkData(72, 2, 0.5403105467456532)
        tdSql.checkData(72, 3, 2.75535470715349)
        tdSql.checkData(72, 4, nan)
        tdSql.checkData(72, 5, 0.0009616202598659029)
        tdSql.checkData(72, 6, 4.225579583416092)
        tdSql.checkData(73, 0, 13)
        tdSql.checkData(73, 1, 0.6502878401571168)
        tdSql.checkData(73, 2, 0.5403105467456532)
        tdSql.checkData(73, 3, 2.75535470715349)
        tdSql.checkData(73, 4, nan)
        tdSql.checkData(73, 5, 0.0009616202598659029)
        tdSql.checkData(73, 6, 4.225579583416092)
        tdSql.checkData(74, 0, 12)
        tdSql.checkData(74, 1, 0.9906073556948704)
        tdSql.checkData(74, 2, 0.8556343548213666)
        tdSql.checkData(74, 3, 2.451594361777497)
        tdSql.checkData(74, 4, nan)
        tdSql.checkData(74, 5, 0.24838494428124291)
        tdSql.checkData(74, 6, 1.4585617093317953)
        tdSql.checkData(75, 0, 12)
        tdSql.checkData(75, 1, 0.9906073556948704)
        tdSql.checkData(75, 2, 0.8556343548213666)
        tdSql.checkData(75, 3, 2.451594361777497)
        tdSql.checkData(75, 4, nan)
        tdSql.checkData(75, 5, 0.24838494428124291)
        tdSql.checkData(75, 6, 1.4585617093317953)
        tdSql.checkData(76, 0, 11)
        tdSql.checkData(76, 1, 0.4201670368266409)
        tdSql.checkData(76, 2, 0.9162743174606308)
        tdSql.checkData(76, 3, 0.44272645708128566)
        tdSql.checkData(76, 4, nan)
        tdSql.checkData(76, 5, 0.9151372562290566)
        tdSql.checkData(76, 6, -222.95969776348554)
        tdSql.checkData(77, 0, 11)
        tdSql.checkData(77, 1, 0.4201670368266409)
        tdSql.checkData(77, 2, 0.9162743174606308)
        tdSql.checkData(77, 3, 0.44272645708128566)
        tdSql.checkData(77, 4, nan)
        tdSql.checkData(77, 5, 0.9151372562290566)
        tdSql.checkData(77, 6, -222.95969776348554)
        tdSql.checkData(78, 0, 10)
        tdSql.checkData(78, 1, -0.5365729180004349)
        tdSql.checkData(78, 2, 0.549226270051226)
        tdSql.checkData(78, 3, 2.432352856101439)
        tdSql.checkData(78, 4, nan)
        tdSql.checkData(78, 5, 1.2185572409879093)
        tdSql.checkData(78, 6, 4.561306078186714)
        tdSql.checkData(79, 0, 10)
        tdSql.checkData(79, 1, -0.5365729180004349)
        tdSql.checkData(79, 2, 0.549226270051226)
        tdSql.checkData(79, 3, 2.432352856101439)
        tdSql.checkData(79, 4, nan)
        tdSql.checkData(79, 5, 1.2185572409879093)
        tdSql.checkData(79, 6, 4.561306078186714)
        tdSql.checkData(80, 0, 9)
        tdSql.checkData(80, 1, -0.9999902065507035)
        tdSql.checkData(80, 2, 0.7918362090144786)
        tdSql.checkData(80, 3, 2.776612511546888)
        tdSql.checkData(80, 4, nan)
        tdSql.checkData(80, 5, 0.5929886271208413)
        tdSql.checkData(80, 6, 1.796697093786514)
        tdSql.checkData(81, 0, 9)
        tdSql.checkData(81, 1, -0.9999902065507035)
        tdSql.checkData(81, 2, 0.7918362090144786)
        tdSql.checkData(81, 3, 2.776612511546888)
        tdSql.checkData(81, 4, nan)
        tdSql.checkData(81, 5, 0.5929886271208413)
        tdSql.checkData(81, 6, 1.796697093786514)
        tdSql.checkData(82, 0, 8)
        tdSql.checkData(82, 1, -0.5440211108893698)
        tdSql.checkData(82, 2, 0.9612168045072789)
        tdSql.checkData(82, 3, 0.5787344727995947)
        tdSql.checkData(82, 4, nan)
        tdSql.checkData(82, 5, -0.7199655182148126)
        tdSql.checkData(82, 6, -4.087614771885445)
        tdSql.checkData(83, 0, 8)
        tdSql.checkData(83, 1, -0.5440211108893698)
        tdSql.checkData(83, 2, 0.9612168045072789)
        tdSql.checkData(83, 3, 0.5787344727995947)
        tdSql.checkData(83, 4, nan)
        tdSql.checkData(83, 5, -0.7199655182148126)
        tdSql.checkData(83, 6, -4.087614771885445)
        tdSql.checkData(84, 0, 7)
        tdSql.checkData(84, 1, 0.4121184852417566)
        tdSql.checkData(84, 2, 0.574400879193934)
        tdSql.checkData(84, 3, 2.137595835197328)
        tdSql.checkData(84, 4, nan)
        tdSql.checkData(84, 5, -1.8119088619792247)
        tdSql.checkData(84, 6, 4.862055338419189)
        tdSql.checkData(85, 0, 7)
        tdSql.checkData(85, 1, 0.4121184852417566)
        tdSql.checkData(85, 2, 0.574400879193934)
        tdSql.checkData(85, 3, 2.137595835197328)
        tdSql.checkData(85, 4, nan)
        tdSql.checkData(85, 5, -1.8119088619792247)
        tdSql.checkData(85, 6, 4.862055338419189)
        tdSql.checkData(86, 0, 6)
        tdSql.checkData(86, 1, 0.9893582466233818)
        tdSql.checkData(86, 2, 0.7270351311688125)
        tdSql.checkData(86, 3, 3.1243204798042576)
        tdSql.checkData(86, 4, nan)
        tdSql.checkData(86, 5, -1.8696882565721156)
        tdSql.checkData(86, 6, 2.172420890614816)
        tdSql.checkData(87, 0, 6)
        tdSql.checkData(87, 1, 0.9893582466233818)
        tdSql.checkData(87, 2, 0.7270351311688125)
        tdSql.checkData(87, 3, 3.1243204798042576)
        tdSql.checkData(87, 4, nan)
        tdSql.checkData(87, 5, -1.8696882565721156)
        tdSql.checkData(87, 6, 2.172420890614816)
        tdSql.checkData(88, 0, 5)
        tdSql.checkData(88, 1, 0.6569865987187891)
        tdSql.checkData(88, 2, 0.9900590857598653)
        tdSql.checkData(88, 3, 0.8864495743441427)
        tdSql.checkData(88, 4, nan)
        tdSql.checkData(88, 5, -0.876294736008743)
        tdSql.checkData(88, 6, -0.9245361171359558)
        tdSql.checkData(89, 0, 5)
        tdSql.checkData(89, 1, 0.6569865987187891)
        tdSql.checkData(89, 2, 0.9900590857598653)
        tdSql.checkData(89, 3, 0.8864495743441427)
        tdSql.checkData(89, 4, nan)
        tdSql.checkData(89, 5, -0.876294736008743)
        tdSql.checkData(89, 6, -0.9245361171359558)
        tdSql.checkData(90, 0, 4)
        tdSql.checkData(90, 1, -0.27941549819892586)
        tdSql.checkData(90, 2, 0.6143002821164822)
        tdSql.checkData(90, 3, 1.853464438509776)
        tdSql.checkData(90, 4, nan)
        tdSql.checkData(90, 5, 0.38234027607634785)
        tdSql.checkData(90, 6, 5.147179528972959)
        tdSql.checkData(91, 0, 4)
        tdSql.checkData(91, 1, -0.27941549819892586)
        tdSql.checkData(91, 2, 0.6143002821164822)
        tdSql.checkData(91, 3, 1.853464438509776)
        tdSql.checkData(91, 4, nan)
        tdSql.checkData(91, 5, 0.38234027607634785)
        tdSql.checkData(91, 6, 5.147179528972959)
        tdSql.checkData(92, 0, 3)
        tdSql.checkData(92, 1, -0.9589242746631385)
        tdSql.checkData(92, 2, 0.6663667453928805)
        tdSql.checkData(92, 3, 3.4288753232277074)
        tdSql.checkData(92, 4, nan)
        tdSql.checkData(92, 5, 1.0087371784424417)
        tdSql.checkData(92, 6, 2.5780379587267963)
        tdSql.checkData(93, 0, 3)
        tdSql.checkData(93, 1, -0.9589242746631385)
        tdSql.checkData(93, 2, 0.6663667453928805)
        tdSql.checkData(93, 3, 3.4288753232277074)
        tdSql.checkData(93, 4, nan)
        tdSql.checkData(93, 5, 1.0087371784424417)
        tdSql.checkData(93, 6, 2.5780379587267963)
        tdSql.checkData(94, 0, 2)
        tdSql.checkData(94, 1, -0.7568024953079282)
        tdSql.checkData(94, 2, 1.0)
        tdSql.checkData(94, 3, 1.2340302976078754)
        tdSql.checkData(94, 4, nan)
        tdSql.checkData(94, 5, 0.7554222939559553)
        tdSql.checkData(94, 6, 0.05815764143055291)
        tdSql.checkData(95, 0, 2)
        tdSql.checkData(95, 1, -0.7568024953079282)
        tdSql.checkData(95, 2, 1.0)
        tdSql.checkData(95, 3, 1.2340302976078754)
        tdSql.checkData(95, 4, nan)
        tdSql.checkData(95, 5, 0.7554222939559553)
        tdSql.checkData(95, 6, 0.05815764143055291)
        tdSql.checkData(96, 0, 1)
        tdSql.checkData(96, 1, 0.1411200080598672)
        tdSql.checkData(96, 2, 0.6663667453928805)
        tdSql.checkData(96, 3, 1.558041126155035)
        tdSql.checkData(96, 4, 1.8325957145940461)
        tdSql.checkData(96, 5, 0.17204223631998083)
        tdSql.checkData(96, 6, nan)
        tdSql.checkData(97, 0, 1)
        tdSql.checkData(97, 1, 0.1411200080598672)
        tdSql.checkData(97, 2, 0.6663667453928805)
        tdSql.checkData(97, 3, 1.558041126155035)
        tdSql.checkData(97, 4, 1.8325957145940461)
        tdSql.checkData(97, 5, 0.17204223631998083)
        tdSql.checkData(97, 6, nan)
        tdSql.checkData(98, 0, 0)
        tdSql.checkData(98, 1, 0.7780731968879212)
        tdSql.checkData(98, 2, 0.6143002821164822)
        tdSql.checkData(98, 3, 3.2037266279837113)
        tdSql.checkData(98, 4, nan)
        tdSql.checkData(98, 5, 0.02246988233490299)
        tdSql.checkData(98, 6, nan)
        tdSql.checkData(99, 0, 0)
        tdSql.checkData(99, 1, 0.7780731968879212)
        tdSql.checkData(99, 2, 0.6143002821164822)
        tdSql.checkData(99, 3, 3.2037266279837113)
        tdSql.checkData(99, 4, nan)
        tdSql.checkData(99, 5, 0.02246988233490299)
        tdSql.checkData(99, 6, nan)

        tdSql.query(
            "select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6 from (select * from st0 );"
        )
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.7780731968879212)
        tdSql.checkData(0, 2, 0.6143002821164822)
        tdSql.checkData(0, 3, 3.2037266279837113)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.02246988233490299)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.1411200080598672)
        tdSql.checkData(1, 2, 0.6663667453928805)
        tdSql.checkData(1, 3, 1.558041126155035)
        tdSql.checkData(1, 4, 1.8325957145940461)
        tdSql.checkData(1, 5, 0.17204223631998083)
        tdSql.checkData(1, 6, nan)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(2, 1, -0.7568024953079282)
        tdSql.checkData(2, 2, 1.0)
        tdSql.checkData(2, 3, 1.2340302976078754)
        tdSql.checkData(2, 4, nan)
        tdSql.checkData(2, 5, 0.7554222939559553)
        tdSql.checkData(2, 6, 0.05815764143055291)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, -0.9589242746631385)
        tdSql.checkData(3, 2, 0.6663667453928805)
        tdSql.checkData(3, 3, 3.4288753232277074)
        tdSql.checkData(3, 4, nan)
        tdSql.checkData(3, 5, 1.0087371784424417)
        tdSql.checkData(3, 6, 2.5780379587267963)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, -0.27941549819892586)
        tdSql.checkData(4, 2, 0.6143002821164822)
        tdSql.checkData(4, 3, 1.853464438509776)
        tdSql.checkData(4, 4, nan)
        tdSql.checkData(4, 5, 0.38234027607634785)
        tdSql.checkData(4, 6, 5.147179528972959)
        tdSql.checkData(5, 0, 5)
        tdSql.checkData(5, 1, 0.6569865987187891)
        tdSql.checkData(5, 2, 0.9900590857598653)
        tdSql.checkData(5, 3, 0.8864495743441427)
        tdSql.checkData(5, 4, nan)
        tdSql.checkData(5, 5, -0.876294736008743)
        tdSql.checkData(5, 6, -0.9245361171359558)
        tdSql.checkData(6, 0, 6)
        tdSql.checkData(6, 1, 0.9893582466233818)
        tdSql.checkData(6, 2, 0.7270351311688125)
        tdSql.checkData(6, 3, 3.1243204798042576)
        tdSql.checkData(6, 4, nan)
        tdSql.checkData(6, 5, -1.8696882565721156)
        tdSql.checkData(6, 6, 2.172420890614816)
        tdSql.checkData(7, 0, 7)
        tdSql.checkData(7, 1, 0.4121184852417566)
        tdSql.checkData(7, 2, 0.574400879193934)
        tdSql.checkData(7, 3, 2.137595835197328)
        tdSql.checkData(7, 4, nan)
        tdSql.checkData(7, 5, -1.8119088619792247)
        tdSql.checkData(7, 6, 4.862055338419189)
        tdSql.checkData(8, 0, 8)
        tdSql.checkData(8, 1, -0.5440211108893698)
        tdSql.checkData(8, 2, 0.9612168045072789)
        tdSql.checkData(8, 3, 0.5787344727995947)
        tdSql.checkData(8, 4, nan)
        tdSql.checkData(8, 5, -0.7199655182148126)
        tdSql.checkData(8, 6, -4.087614771885445)
        tdSql.checkData(9, 0, 9)
        tdSql.checkData(9, 1, -0.9999902065507035)
        tdSql.checkData(9, 2, 0.7918362090144786)
        tdSql.checkData(9, 3, 2.776612511546888)
        tdSql.checkData(9, 4, nan)
        tdSql.checkData(9, 5, 0.5929886271208413)
        tdSql.checkData(9, 6, 1.796697093786514)
        tdSql.checkData(10, 0, 10)
        tdSql.checkData(10, 1, -0.5365729180004349)
        tdSql.checkData(10, 2, 0.549226270051226)
        tdSql.checkData(10, 3, 2.432352856101439)
        tdSql.checkData(10, 4, nan)
        tdSql.checkData(10, 5, 1.2185572409879093)
        tdSql.checkData(10, 6, 4.561306078186714)
        tdSql.checkData(11, 0, 11)
        tdSql.checkData(11, 1, 0.4201670368266409)
        tdSql.checkData(11, 2, 0.9162743174606308)
        tdSql.checkData(11, 3, 0.44272645708128566)
        tdSql.checkData(11, 4, nan)
        tdSql.checkData(11, 5, 0.9151372562290566)
        tdSql.checkData(11, 6, -222.95969776348554)
        tdSql.checkData(12, 0, 12)
        tdSql.checkData(12, 1, 0.9906073556948704)
        tdSql.checkData(12, 2, 0.8556343548213666)
        tdSql.checkData(12, 3, 2.451594361777497)
        tdSql.checkData(12, 4, nan)
        tdSql.checkData(12, 5, 0.24838494428124291)
        tdSql.checkData(12, 6, 1.4585617093317953)
        tdSql.checkData(13, 0, 13)
        tdSql.checkData(13, 1, 0.6502878401571168)
        tdSql.checkData(13, 2, 0.5403105467456532)
        tdSql.checkData(13, 3, 2.75535470715349)
        tdSql.checkData(13, 4, nan)
        tdSql.checkData(13, 5, 0.0009616202598659029)
        tdSql.checkData(13, 6, 4.225579583416092)
        tdSql.checkData(14, 0, 14)
        tdSql.checkData(14, 1, -0.2879033166650653)
        tdSql.checkData(14, 2, 0.859465627274523)
        tdSql.checkData(14, 3, 0.5636905248139659)
        tdSql.checkData(14, 4, nan)
        tdSql.checkData(14, 5, 0.41142163587369207)
        tdSql.checkData(14, 6, 10.515512404402676)
        tdSql.checkData(15, 0, 15)
        tdSql.checkData(15, 1, -0.9613974918795568)
        tdSql.checkData(15, 2, 0.9130208165623314)
        tdSql.checkData(15, 3, 2.1554866011151765)
        tdSql.checkData(15, 4, nan)
        tdSql.checkData(15, 5, 0.9521751875546269)
        tdSql.checkData(15, 6, 1.1559749749986195)
        tdSql.checkData(16, 0, 16)
        tdSql.checkData(16, 1, -0.750987246771676)
        tdSql.checkData(16, 2, 0.5481819942730298)
        tdSql.checkData(16, 3, 3.102748784455539)
        tdSql.checkData(16, 4, nan)
        tdSql.checkData(16, 5, 0.8513297604701857)
        tdSql.checkData(16, 6, 3.852058923265594)
        tdSql.checkData(17, 0, 17)
        tdSql.checkData(17, 1, 0.14987720966295234)
        tdSql.checkData(17, 2, 0.7959095686227995)
        tdSql.checkData(17, 3, 0.864944320724419)
        tdSql.checkData(17, 4, nan)
        tdSql.checkData(17, 5, -0.13037289959062748)
        tdSql.checkData(17, 6, 7.022998331594864)
        tdSql.checkData(18, 0, 18)
        tdSql.checkData(18, 1, 0.9129452507276277)
        tdSql.checkData(18, 2, 0.9588413200803038)
        tdSql.checkData(18, 3, 1.8713332491184997)
        tdSql.checkData(18, 4, nan)
        tdSql.checkData(18, 5, -1.3983047743451864)
        tdSql.checkData(18, 6, 0.8709074342191974)
        tdSql.checkData(19, 0, 19)
        tdSql.checkData(19, 1, 0.8366556385360561)
        tdSql.checkData(19, 2, 0.5723746128431292)
        tdSql.checkData(19, 3, 3.413484890511323)
        tdSql.checkData(19, 4, nan)
        tdSql.checkData(19, 5, -1.9952541841757747)
        tdSql.checkData(19, 6, 3.4479580493217856)
        tdSql.checkData(20, 0, 20)
        tdSql.checkData(20, 1, -0.008851309290403876)
        tdSql.checkData(20, 2, 0.7310155667453407)
        tdSql.checkData(20, 3, 1.2127175951404974)
        tdSql.checkData(20, 4, nan)
        tdSql.checkData(20, 5, -1.4304290589415767)
        tdSql.checkData(20, 6, 5.982274104704091)
        tdSql.checkData(21, 0, 21)
        tdSql.checkData(21, 1, -0.8462204041751706)
        tdSql.checkData(21, 2, 0.9887894200405688)
        tdSql.checkData(21, 3, 1.5772240911721418)
        tdSql.checkData(21, 4, nan)
        tdSql.checkData(21, 5, -0.11647857397382422)
        tdSql.checkData(21, 6, 0.5559799244477626)
        tdSql.checkData(22, 0, 22)
        tdSql.checkData(22, 1, -0.9055783620066239)
        tdSql.checkData(22, 2, 0.6114178044194122)
        tdSql.checkData(22, 3, 3.5568711064263105)
        tdSql.checkData(22, 4, nan)
        tdSql.checkData(22, 5, 0.9837833410919679)
        tdSql.checkData(22, 6, 3.0265535811470983)
        tdSql.checkData(23, 0, 23)
        tdSql.checkData(23, 1, -0.13235175009777303)
        tdSql.checkData(23, 2, 0.6699494442536529)
        tdSql.checkData(23, 3, 1.5387402975985367)
        tdSql.checkData(23, 4, nan)
        tdSql.checkData(23, 5, 1.1825447904081037)
        tdSql.checkData(23, 6, 5.489941431040083)
        tdSql.checkData(24, 0, 24)
        tdSql.checkData(24, 1, 0.7625584504796027)
        tdSql.checkData(24, 2, 0.999960827417674)
        tdSql.checkData(24, 3, 1.2552318002593996)
        tdSql.checkData(24, 4, nan)
        tdSql.checkData(24, 5, 0.6200983185456957)
        tdSql.checkData(24, 6, 0.09684864095463253)
        tdSql.checkData(25, 0, 25)
        tdSql.checkData(25, 1, 0.956375928404503)
        tdSql.checkData(25, 2, 0.6628179613691831)
        tdSql.checkData(25, 3, 3.4435632194258416)
        tdSql.checkData(25, 4, nan)
        tdSql.checkData(25, 5, 0.05676687083562715)
        tdSql.checkData(25, 6, 2.6040987392745354)
        tdSql.checkData(26, 0, 26)
        tdSql.checkData(26, 1, 0.27090578830786904)
        tdSql.checkData(26, 2, 0.6172306382193644)
        tdSql.checkData(26, 3, 1.835550377607515)
        tdSql.checkData(26, 4, nan)
        tdSql.checkData(26, 5, 0.11431954199291106)
        tdSql.checkData(26, 6, 5.165381146246765)
        tdSql.checkData(27, 0, 27)
        tdSql.checkData(27, 1, -0.6636338842129675)
        tdSql.checkData(27, 2, 0.9912542848596704)
        tdSql.checkData(27, 3, 0.9080812682077812)
        tdSql.checkData(27, 4, nan)
        tdSql.checkData(27, 5, 0.6788951190016388)
        tdSql.checkData(27, 6, -0.8324928492797357)
        tdSql.checkData(28, 0, 28)
        tdSql.checkData(28, 1, -0.9880316240928618)
        tdSql.checkData(28, 2, 0.7230710689951642)
        tdSql.checkData(28, 3, 3.1457526648156393)
        tdSql.checkData(28, 4, nan)
        tdSql.checkData(28, 5, 1.0206076417536643)
        tdSql.checkData(28, 6, 2.197019393348823)
        tdSql.checkData(29, 0, 29)
        tdSql.checkData(29, 1, -0.404037645323065)
        tdSql.checkData(29, 2, 0.5764850221962442)
        tdSql.checkData(29, 3, 2.1197476343754156)
        tdSql.checkData(29, 4, nan)
        tdSql.checkData(29, 5, 0.5162157333804713)
        tdSql.checkData(29, 6, 4.8800154918827525)
        tdSql.checkData(30, 0, 30)
        tdSql.checkData(30, 1, 0.5514266812416906)
        tdSql.checkData(30, 2, 0.9635288988181601)
        tdSql.checkData(30, 3, 0.5944617511422015)
        tdSql.checkData(30, 4, nan)
        tdSql.checkData(30, 5, -0.7022004347538967)
        tdSql.checkData(30, 6, -3.710141817748492)
        tdSql.checkData(31, 0, 31)
        tdSql.checkData(31, 1, 0.9999118601072672)
        tdSql.checkData(31, 2, 0.7877590247885756)
        tdSql.checkData(31, 3, 2.7979785951133604)
        tdSql.checkData(31, 4, nan)
        tdSql.checkData(31, 5, -1.7874722290307907)
        tdSql.checkData(31, 6, 1.8191237353300793)
        tdSql.checkData(32, 0, 32)
        tdSql.checkData(32, 1, 0.5290826861200238)
        tdSql.checkData(32, 2, 0.5503344099628432)
        tdSql.checkData(32, 3, 2.413227615833899)
        tdSql.checkData(32, 4, nan)
        tdSql.checkData(32, 5, -1.8893763681780902)
        tdSql.checkData(32, 6, 4.581032079680554)
        tdSql.checkData(33, 0, 33)
        tdSql.checkData(33, 1, -0.428182669496151)
        tdSql.checkData(33, 2, 0.9194811573015673)
        tdSql.checkData(33, 3, 0.4437992589174107)
        tdSql.checkData(33, 4, nan)
        tdSql.checkData(33, 5, -0.9001958571391758)
        tdSql.checkData(33, 6, -72.33956595410905)
        tdSql.checkData(34, 0, 34)
        tdSql.checkData(34, 1, -0.9917788534431158)
        tdSql.checkData(34, 2, 0.8517779466253769)
        tdSql.checkData(34, 3, 2.470955260231499)
        tdSql.checkData(34, 4, nan)
        tdSql.checkData(34, 5, 0.4428112547200472)
        tdSql.checkData(34, 6, 1.4785733565944832)
        tdSql.checkData(35, 0, 35)
        tdSql.checkData(35, 1, -0.6435381333569995)
        tdSql.checkData(35, 2, 0.5403764709316752)
        tdSql.checkData(35, 3, 2.734210799811235)
        tdSql.checkData(35, 4, nan)
        tdSql.checkData(35, 5, 1.1930854189064375)
        tdSql.checkData(35, 6, 4.24770540197234)
        tdSql.checkData(36, 0, 36)
        tdSql.checkData(36, 1, 0.2963685787093853)
        tdSql.checkData(36, 2, 0.8632704401895588)
        tdSql.checkData(36, 3, 0.5493681603601657)
        tdSql.checkData(36, 4, nan)
        tdSql.checkData(36, 5, 0.9944678850925007)
        tdSql.checkData(36, 6, 11.004294268461184)
        tdSql.checkData(37, 0, 37)
        tdSql.checkData(37, 1, 0.9637953862840878)
        tdSql.checkData(37, 2, 0.909721840267583)
        tdSql.checkData(37, 3, 2.1734252903776303)
        tdSql.checkData(37, 4, nan)
        tdSql.checkData(37, 5, 0.32696474077278626)
        tdSql.checkData(37, 6, 1.174082484128993)
        tdSql.checkData(38, 0, 38)
        tdSql.checkData(38, 1, 0.7451131604793488)
        tdSql.checkData(38, 2, 0.5472018255605284)
        tdSql.checkData(38, 3, 3.081063350979351)
        tdSql.checkData(38, 4, nan)
        tdSql.checkData(38, 5, -0.007381884932924798)
        tdSql.checkData(38, 6, 3.8764172978929814)
        tdSql.checkData(39, 0, 39)
        tdSql.checkData(39, 1, -0.158622668804709)
        tdSql.checkData(39, 2, 0.7999777847134487)
        tdSql.checkData(39, 3, 0.8435920138756074)
        tdSql.checkData(39, 4, nan)
        tdSql.checkData(39, 5, 0.3319994538301167)
        tdSql.checkData(39, 6, 7.12853286308907)
        tdSql.checkData(40, 0, 40)
        tdSql.checkData(40, 1, -0.9165215479156338)
        tdSql.checkData(40, 2, 0.9564033460276342)
        tdSql.checkData(40, 3, 1.889162191085516)
        tdSql.checkData(40, 4, nan)
        tdSql.checkData(40, 5, 0.90296737936602)
        tdSql.checkData(40, 6, 0.888896415152729)
        tdSql.checkData(41, 0, 41)
        tdSql.checkData(41, 1, -0.8317747426285983)
        tdSql.checkData(41, 2, 0.5704067143341829)
        tdSql.checkData(41, 3, 3.397430462894578)
        tdSql.checkData(41, 4, nan)
        tdSql.checkData(41, 5, 0.9190273051332304)
        tdSql.checkData(41, 6, 3.473885481113728)
        tdSql.checkData(42, 0, 42)
        tdSql.checkData(42, 1, 0.017701925105413577)
        tdSql.checkData(42, 2, 0.7350111780599404)
        tdSql.checkData(42, 3, 1.1912997639866574)
        tdSql.checkData(42, 4, nan)
        tdSql.checkData(42, 5, 0.036467324189017214)
        tdSql.checkData(42, 6, 6.024578312510778)
        tdSql.checkData(43, 0, 43)
        tdSql.checkData(43, 1, 0.8509035245341184)
        tdSql.checkData(43, 2, 0.9874457808369176)
        tdSql.checkData(43, 3, 1.5962924548219202)
        tdSql.checkData(43, 4, nan)
        tdSql.checkData(43, 5, -1.2490970766755156)
        tdSql.checkData(43, 6, 0.5781542141407696)
        tdSql.checkData(44, 0, 44)
        tdSql.checkData(44, 1, 0.9017883476488092)
        tdSql.checkData(44, 2, 0.6085839480802863)
        tdSql.checkData(44, 3, 3.5552629892514687)
        tdSql.checkData(44, 4, nan)
        tdSql.checkData(44, 5, -1.9810692649977342)
        tdSql.checkData(44, 6, 3.0531030020123464)
        tdSql.checkData(45, 0, 45)
        tdSql.checkData(45, 1, 0.123573122745224)
        tdSql.checkData(45, 2, 0.6735650596658175)
        tdSql.checkData(45, 3, 1.5193186190030223)
        tdSql.checkData(45, 4, nan)
        tdSql.checkData(45, 5, -1.5661895943272113)
        tdSql.checkData(45, 6, 5.513771854144419)
        tdSql.checkData(46, 0, 46)
        tdSql.checkData(46, 1, -0.7682546613236668)
        tdSql.checkData(46, 2, 0.9998433250151273)
        tdSql.checkData(46, 3, 1.2763169256468458)
        tdSql.checkData(46, 4, nan)
        tdSql.checkData(46, 5, -0.300459258677913)
        tdSql.checkData(46, 6, 0.13392039926281352)
        tdSql.checkData(47, 0, 47)
        tdSql.checkData(47, 1, -0.9537526527594719)
        tdSql.checkData(47, 2, 0.6593040763085178)
        tdSql.checkData(47, 3, 3.4575106745458637)
        tdSql.checkData(47, 4, nan)
        tdSql.checkData(47, 5, 0.8820838187306987)
        tdSql.checkData(47, 6, 2.6302204463996084)
        tdSql.checkData(48, 0, 48)
        tdSql.checkData(48, 1, -0.26237485370392877)
        tdSql.checkData(48, 2, 0.6202081141679935)
        tdSql.checkData(48, 3, 1.8175857333771335)
        tdSql.checkData(48, 4, nan)
        tdSql.checkData(48, 5, 1.211884234321115)
        tdSql.checkData(48, 6, 5.183714988550632)
        tdSql.checkData(49, 0, 49)
        tdSql.checkData(49, 1, 0.6702291758433747)
        tdSql.checkData(49, 2, 0.9923745526637894)
        tdSql.checkData(49, 3, 0.9298143670243166)
        tdSql.checkData(49, 4, nan)
        tdSql.checkData(49, 5, 0.7136182821549459)
        tdSql.checkData(49, 6, -0.7462904241496138)
        tdSql.checkData(50, 0, 0)
        tdSql.checkData(50, 1, 0.7780731968879212)
        tdSql.checkData(50, 2, 0.6143002821164822)
        tdSql.checkData(50, 3, 3.2037266279837113)
        tdSql.checkData(50, 4, nan)
        tdSql.checkData(50, 5, 0.02246988233490299)
        tdSql.checkData(50, 6, nan)
        tdSql.checkData(51, 0, 1)
        tdSql.checkData(51, 1, 0.1411200080598672)
        tdSql.checkData(51, 2, 0.6663667453928805)
        tdSql.checkData(51, 3, 1.558041126155035)
        tdSql.checkData(51, 4, 1.8325957145940461)
        tdSql.checkData(51, 5, 0.17204223631998083)
        tdSql.checkData(51, 6, nan)
        tdSql.checkData(52, 0, 2)
        tdSql.checkData(52, 1, -0.7568024953079282)
        tdSql.checkData(52, 2, 1.0)
        tdSql.checkData(52, 3, 1.2340302976078754)
        tdSql.checkData(52, 4, nan)
        tdSql.checkData(52, 5, 0.7554222939559553)
        tdSql.checkData(52, 6, 0.05815764143055291)
        tdSql.checkData(53, 0, 3)
        tdSql.checkData(53, 1, -0.9589242746631385)
        tdSql.checkData(53, 2, 0.6663667453928805)
        tdSql.checkData(53, 3, 3.4288753232277074)
        tdSql.checkData(53, 4, nan)
        tdSql.checkData(53, 5, 1.0087371784424417)
        tdSql.checkData(53, 6, 2.5780379587267963)
        tdSql.checkData(54, 0, 4)
        tdSql.checkData(54, 1, -0.27941549819892586)
        tdSql.checkData(54, 2, 0.6143002821164822)
        tdSql.checkData(54, 3, 1.853464438509776)
        tdSql.checkData(54, 4, nan)
        tdSql.checkData(54, 5, 0.38234027607634785)
        tdSql.checkData(54, 6, 5.147179528972959)
        tdSql.checkData(55, 0, 5)
        tdSql.checkData(55, 1, 0.6569865987187891)
        tdSql.checkData(55, 2, 0.9900590857598653)
        tdSql.checkData(55, 3, 0.8864495743441427)
        tdSql.checkData(55, 4, nan)
        tdSql.checkData(55, 5, -0.876294736008743)
        tdSql.checkData(55, 6, -0.9245361171359558)
        tdSql.checkData(56, 0, 6)
        tdSql.checkData(56, 1, 0.9893582466233818)
        tdSql.checkData(56, 2, 0.7270351311688125)
        tdSql.checkData(56, 3, 3.1243204798042576)
        tdSql.checkData(56, 4, nan)
        tdSql.checkData(56, 5, -1.8696882565721156)
        tdSql.checkData(56, 6, 2.172420890614816)
        tdSql.checkData(57, 0, 7)
        tdSql.checkData(57, 1, 0.4121184852417566)
        tdSql.checkData(57, 2, 0.574400879193934)
        tdSql.checkData(57, 3, 2.137595835197328)
        tdSql.checkData(57, 4, nan)
        tdSql.checkData(57, 5, -1.8119088619792247)
        tdSql.checkData(57, 6, 4.862055338419189)
        tdSql.checkData(58, 0, 8)
        tdSql.checkData(58, 1, -0.5440211108893698)
        tdSql.checkData(58, 2, 0.9612168045072789)
        tdSql.checkData(58, 3, 0.5787344727995947)
        tdSql.checkData(58, 4, nan)
        tdSql.checkData(58, 5, -0.7199655182148126)
        tdSql.checkData(58, 6, -4.087614771885445)
        tdSql.checkData(59, 0, 9)
        tdSql.checkData(59, 1, -0.9999902065507035)
        tdSql.checkData(59, 2, 0.7918362090144786)
        tdSql.checkData(59, 3, 2.776612511546888)
        tdSql.checkData(59, 4, nan)
        tdSql.checkData(59, 5, 0.5929886271208413)
        tdSql.checkData(59, 6, 1.796697093786514)
        tdSql.checkData(60, 0, 10)
        tdSql.checkData(60, 1, -0.5365729180004349)
        tdSql.checkData(60, 2, 0.549226270051226)
        tdSql.checkData(60, 3, 2.432352856101439)
        tdSql.checkData(60, 4, nan)
        tdSql.checkData(60, 5, 1.2185572409879093)
        tdSql.checkData(60, 6, 4.561306078186714)
        tdSql.checkData(61, 0, 11)
        tdSql.checkData(61, 1, 0.4201670368266409)
        tdSql.checkData(61, 2, 0.9162743174606308)
        tdSql.checkData(61, 3, 0.44272645708128566)
        tdSql.checkData(61, 4, nan)
        tdSql.checkData(61, 5, 0.9151372562290566)
        tdSql.checkData(61, 6, -222.95969776348554)
        tdSql.checkData(62, 0, 12)
        tdSql.checkData(62, 1, 0.9906073556948704)
        tdSql.checkData(62, 2, 0.8556343548213666)
        tdSql.checkData(62, 3, 2.451594361777497)
        tdSql.checkData(62, 4, nan)
        tdSql.checkData(62, 5, 0.24838494428124291)
        tdSql.checkData(62, 6, 1.4585617093317953)
        tdSql.checkData(63, 0, 13)
        tdSql.checkData(63, 1, 0.6502878401571168)
        tdSql.checkData(63, 2, 0.5403105467456532)
        tdSql.checkData(63, 3, 2.75535470715349)
        tdSql.checkData(63, 4, nan)
        tdSql.checkData(63, 5, 0.0009616202598659029)
        tdSql.checkData(63, 6, 4.225579583416092)
        tdSql.checkData(64, 0, 14)
        tdSql.checkData(64, 1, -0.2879033166650653)
        tdSql.checkData(64, 2, 0.859465627274523)
        tdSql.checkData(64, 3, 0.5636905248139659)
        tdSql.checkData(64, 4, nan)
        tdSql.checkData(64, 5, 0.41142163587369207)
        tdSql.checkData(64, 6, 10.515512404402676)
        tdSql.checkData(65, 0, 15)
        tdSql.checkData(65, 1, -0.9613974918795568)
        tdSql.checkData(65, 2, 0.9130208165623314)
        tdSql.checkData(65, 3, 2.1554866011151765)
        tdSql.checkData(65, 4, nan)
        tdSql.checkData(65, 5, 0.9521751875546269)
        tdSql.checkData(65, 6, 1.1559749749986195)
        tdSql.checkData(66, 0, 16)
        tdSql.checkData(66, 1, -0.750987246771676)
        tdSql.checkData(66, 2, 0.5481819942730298)
        tdSql.checkData(66, 3, 3.102748784455539)
        tdSql.checkData(66, 4, nan)
        tdSql.checkData(66, 5, 0.8513297604701857)
        tdSql.checkData(66, 6, 3.852058923265594)
        tdSql.checkData(67, 0, 17)
        tdSql.checkData(67, 1, 0.14987720966295234)
        tdSql.checkData(67, 2, 0.7959095686227995)
        tdSql.checkData(67, 3, 0.864944320724419)
        tdSql.checkData(67, 4, nan)
        tdSql.checkData(67, 5, -0.13037289959062748)
        tdSql.checkData(67, 6, 7.022998331594864)
        tdSql.checkData(68, 0, 18)
        tdSql.checkData(68, 1, 0.9129452507276277)
        tdSql.checkData(68, 2, 0.9588413200803038)
        tdSql.checkData(68, 3, 1.8713332491184997)
        tdSql.checkData(68, 4, nan)
        tdSql.checkData(68, 5, -1.3983047743451864)
        tdSql.checkData(68, 6, 0.8709074342191974)
        tdSql.checkData(69, 0, 19)
        tdSql.checkData(69, 1, 0.8366556385360561)
        tdSql.checkData(69, 2, 0.5723746128431292)
        tdSql.checkData(69, 3, 3.413484890511323)
        tdSql.checkData(69, 4, nan)
        tdSql.checkData(69, 5, -1.9952541841757747)
        tdSql.checkData(69, 6, 3.4479580493217856)
        tdSql.checkData(70, 0, 20)
        tdSql.checkData(70, 1, -0.008851309290403876)
        tdSql.checkData(70, 2, 0.7310155667453407)
        tdSql.checkData(70, 3, 1.2127175951404974)
        tdSql.checkData(70, 4, nan)
        tdSql.checkData(70, 5, -1.4304290589415767)
        tdSql.checkData(70, 6, 5.982274104704091)
        tdSql.checkData(71, 0, 21)
        tdSql.checkData(71, 1, -0.8462204041751706)
        tdSql.checkData(71, 2, 0.9887894200405688)
        tdSql.checkData(71, 3, 1.5772240911721418)
        tdSql.checkData(71, 4, nan)
        tdSql.checkData(71, 5, -0.11647857397382422)
        tdSql.checkData(71, 6, 0.5559799244477626)
        tdSql.checkData(72, 0, 22)
        tdSql.checkData(72, 1, -0.9055783620066239)
        tdSql.checkData(72, 2, 0.6114178044194122)
        tdSql.checkData(72, 3, 3.5568711064263105)
        tdSql.checkData(72, 4, nan)
        tdSql.checkData(72, 5, 0.9837833410919679)
        tdSql.checkData(72, 6, 3.0265535811470983)
        tdSql.checkData(73, 0, 23)
        tdSql.checkData(73, 1, -0.13235175009777303)
        tdSql.checkData(73, 2, 0.6699494442536529)
        tdSql.checkData(73, 3, 1.5387402975985367)
        tdSql.checkData(73, 4, nan)
        tdSql.checkData(73, 5, 1.1825447904081037)
        tdSql.checkData(73, 6, 5.489941431040083)
        tdSql.checkData(74, 0, 24)
        tdSql.checkData(74, 1, 0.7625584504796027)
        tdSql.checkData(74, 2, 0.999960827417674)
        tdSql.checkData(74, 3, 1.2552318002593996)
        tdSql.checkData(74, 4, nan)
        tdSql.checkData(74, 5, 0.6200983185456957)
        tdSql.checkData(74, 6, 0.09684864095463253)
        tdSql.checkData(75, 0, 25)
        tdSql.checkData(75, 1, 0.956375928404503)
        tdSql.checkData(75, 2, 0.6628179613691831)
        tdSql.checkData(75, 3, 3.4435632194258416)
        tdSql.checkData(75, 4, nan)
        tdSql.checkData(75, 5, 0.05676687083562715)
        tdSql.checkData(75, 6, 2.6040987392745354)
        tdSql.checkData(76, 0, 26)
        tdSql.checkData(76, 1, 0.27090578830786904)
        tdSql.checkData(76, 2, 0.6172306382193644)
        tdSql.checkData(76, 3, 1.835550377607515)
        tdSql.checkData(76, 4, nan)
        tdSql.checkData(76, 5, 0.11431954199291106)
        tdSql.checkData(76, 6, 5.165381146246765)
        tdSql.checkData(77, 0, 27)
        tdSql.checkData(77, 1, -0.6636338842129675)
        tdSql.checkData(77, 2, 0.9912542848596704)
        tdSql.checkData(77, 3, 0.9080812682077812)
        tdSql.checkData(77, 4, nan)
        tdSql.checkData(77, 5, 0.6788951190016388)
        tdSql.checkData(77, 6, -0.8324928492797357)
        tdSql.checkData(78, 0, 28)
        tdSql.checkData(78, 1, -0.9880316240928618)
        tdSql.checkData(78, 2, 0.7230710689951642)
        tdSql.checkData(78, 3, 3.1457526648156393)
        tdSql.checkData(78, 4, nan)
        tdSql.checkData(78, 5, 1.0206076417536643)
        tdSql.checkData(78, 6, 2.197019393348823)
        tdSql.checkData(79, 0, 29)
        tdSql.checkData(79, 1, -0.404037645323065)
        tdSql.checkData(79, 2, 0.5764850221962442)
        tdSql.checkData(79, 3, 2.1197476343754156)
        tdSql.checkData(79, 4, nan)
        tdSql.checkData(79, 5, 0.5162157333804713)
        tdSql.checkData(79, 6, 4.8800154918827525)
        tdSql.checkData(80, 0, 30)
        tdSql.checkData(80, 1, 0.5514266812416906)
        tdSql.checkData(80, 2, 0.9635288988181601)
        tdSql.checkData(80, 3, 0.5944617511422015)
        tdSql.checkData(80, 4, nan)
        tdSql.checkData(80, 5, -0.7022004347538967)
        tdSql.checkData(80, 6, -3.710141817748492)
        tdSql.checkData(81, 0, 31)
        tdSql.checkData(81, 1, 0.9999118601072672)
        tdSql.checkData(81, 2, 0.7877590247885756)
        tdSql.checkData(81, 3, 2.7979785951133604)
        tdSql.checkData(81, 4, nan)
        tdSql.checkData(81, 5, -1.7874722290307907)
        tdSql.checkData(81, 6, 1.8191237353300793)
        tdSql.checkData(82, 0, 32)
        tdSql.checkData(82, 1, 0.5290826861200238)
        tdSql.checkData(82, 2, 0.5503344099628432)
        tdSql.checkData(82, 3, 2.413227615833899)
        tdSql.checkData(82, 4, nan)
        tdSql.checkData(82, 5, -1.8893763681780902)
        tdSql.checkData(82, 6, 4.581032079680554)
        tdSql.checkData(83, 0, 33)
        tdSql.checkData(83, 1, -0.428182669496151)
        tdSql.checkData(83, 2, 0.9194811573015673)
        tdSql.checkData(83, 3, 0.4437992589174107)
        tdSql.checkData(83, 4, nan)
        tdSql.checkData(83, 5, -0.9001958571391758)
        tdSql.checkData(83, 6, -72.33956595410905)
        tdSql.checkData(84, 0, 34)
        tdSql.checkData(84, 1, -0.9917788534431158)
        tdSql.checkData(84, 2, 0.8517779466253769)
        tdSql.checkData(84, 3, 2.470955260231499)
        tdSql.checkData(84, 4, nan)
        tdSql.checkData(84, 5, 0.4428112547200472)
        tdSql.checkData(84, 6, 1.4785733565944832)
        tdSql.checkData(85, 0, 35)
        tdSql.checkData(85, 1, -0.6435381333569995)
        tdSql.checkData(85, 2, 0.5403764709316752)
        tdSql.checkData(85, 3, 2.734210799811235)
        tdSql.checkData(85, 4, nan)
        tdSql.checkData(85, 5, 1.1930854189064375)
        tdSql.checkData(85, 6, 4.24770540197234)
        tdSql.checkData(86, 0, 36)
        tdSql.checkData(86, 1, 0.2963685787093853)
        tdSql.checkData(86, 2, 0.8632704401895588)
        tdSql.checkData(86, 3, 0.5493681603601657)
        tdSql.checkData(86, 4, nan)
        tdSql.checkData(86, 5, 0.9944678850925007)
        tdSql.checkData(86, 6, 11.004294268461184)
        tdSql.checkData(87, 0, 37)
        tdSql.checkData(87, 1, 0.9637953862840878)
        tdSql.checkData(87, 2, 0.909721840267583)
        tdSql.checkData(87, 3, 2.1734252903776303)
        tdSql.checkData(87, 4, nan)
        tdSql.checkData(87, 5, 0.32696474077278626)
        tdSql.checkData(87, 6, 1.174082484128993)
        tdSql.checkData(88, 0, 38)
        tdSql.checkData(88, 1, 0.7451131604793488)
        tdSql.checkData(88, 2, 0.5472018255605284)
        tdSql.checkData(88, 3, 3.081063350979351)
        tdSql.checkData(88, 4, nan)
        tdSql.checkData(88, 5, -0.007381884932924798)
        tdSql.checkData(88, 6, 3.8764172978929814)
        tdSql.checkData(89, 0, 39)
        tdSql.checkData(89, 1, -0.158622668804709)
        tdSql.checkData(89, 2, 0.7999777847134487)
        tdSql.checkData(89, 3, 0.8435920138756074)
        tdSql.checkData(89, 4, nan)
        tdSql.checkData(89, 5, 0.3319994538301167)
        tdSql.checkData(89, 6, 7.12853286308907)
        tdSql.checkData(90, 0, 40)
        tdSql.checkData(90, 1, -0.9165215479156338)
        tdSql.checkData(90, 2, 0.9564033460276342)
        tdSql.checkData(90, 3, 1.889162191085516)
        tdSql.checkData(90, 4, nan)
        tdSql.checkData(90, 5, 0.90296737936602)
        tdSql.checkData(90, 6, 0.888896415152729)
        tdSql.checkData(91, 0, 41)
        tdSql.checkData(91, 1, -0.8317747426285983)
        tdSql.checkData(91, 2, 0.5704067143341829)
        tdSql.checkData(91, 3, 3.397430462894578)
        tdSql.checkData(91, 4, nan)
        tdSql.checkData(91, 5, 0.9190273051332304)
        tdSql.checkData(91, 6, 3.473885481113728)
        tdSql.checkData(92, 0, 42)
        tdSql.checkData(92, 1, 0.017701925105413577)
        tdSql.checkData(92, 2, 0.7350111780599404)
        tdSql.checkData(92, 3, 1.1912997639866574)
        tdSql.checkData(92, 4, nan)
        tdSql.checkData(92, 5, 0.036467324189017214)
        tdSql.checkData(92, 6, 6.024578312510778)
        tdSql.checkData(93, 0, 43)
        tdSql.checkData(93, 1, 0.8509035245341184)
        tdSql.checkData(93, 2, 0.9874457808369176)
        tdSql.checkData(93, 3, 1.5962924548219202)
        tdSql.checkData(93, 4, nan)
        tdSql.checkData(93, 5, -1.2490970766755156)
        tdSql.checkData(93, 6, 0.5781542141407696)
        tdSql.checkData(94, 0, 44)
        tdSql.checkData(94, 1, 0.9017883476488092)
        tdSql.checkData(94, 2, 0.6085839480802863)
        tdSql.checkData(94, 3, 3.5552629892514687)
        tdSql.checkData(94, 4, nan)
        tdSql.checkData(94, 5, -1.9810692649977342)
        tdSql.checkData(94, 6, 3.0531030020123464)
        tdSql.checkData(95, 0, 45)
        tdSql.checkData(95, 1, 0.123573122745224)
        tdSql.checkData(95, 2, 0.6735650596658175)
        tdSql.checkData(95, 3, 1.5193186190030223)
        tdSql.checkData(95, 4, nan)
        tdSql.checkData(95, 5, -1.5661895943272113)
        tdSql.checkData(95, 6, 5.513771854144419)
        tdSql.checkData(96, 0, 46)
        tdSql.checkData(96, 1, -0.7682546613236668)
        tdSql.checkData(96, 2, 0.9998433250151273)
        tdSql.checkData(96, 3, 1.2763169256468458)
        tdSql.checkData(96, 4, nan)
        tdSql.checkData(96, 5, -0.300459258677913)
        tdSql.checkData(96, 6, 0.13392039926281352)
        tdSql.checkData(97, 0, 47)
        tdSql.checkData(97, 1, -0.9537526527594719)
        tdSql.checkData(97, 2, 0.6593040763085178)
        tdSql.checkData(97, 3, 3.4575106745458637)
        tdSql.checkData(97, 4, nan)
        tdSql.checkData(97, 5, 0.8820838187306987)
        tdSql.checkData(97, 6, 2.6302204463996084)
        tdSql.checkData(98, 0, 48)
        tdSql.checkData(98, 1, -0.26237485370392877)
        tdSql.checkData(98, 2, 0.6202081141679935)
        tdSql.checkData(98, 3, 1.8175857333771335)
        tdSql.checkData(98, 4, nan)
        tdSql.checkData(98, 5, 1.211884234321115)
        tdSql.checkData(98, 6, 5.183714988550632)
        tdSql.checkData(99, 0, 49)
        tdSql.checkData(99, 1, 0.6702291758433747)
        tdSql.checkData(99, 2, 0.9923745526637894)
        tdSql.checkData(99, 3, 0.9298143670243166)
        tdSql.checkData(99, 4, nan)
        tdSql.checkData(99, 5, 0.7136182821549459)
        tdSql.checkData(99, 6, -0.7462904241496138)

        tdSql.query(
            "select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6 from (select * from ct1 ) order by ts limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.7780731968879212)
        tdSql.checkData(0, 2, 0.6143002821164822)
        tdSql.checkData(0, 3, 3.2037266279837113)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.02246988233490299)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.1411200080598672)
        tdSql.checkData(1, 2, 0.6663667453928805)
        tdSql.checkData(1, 3, 1.558041126155035)
        tdSql.checkData(1, 4, 1.8325957145940461)
        tdSql.checkData(1, 5, 0.17204223631998083)
        tdSql.checkData(1, 6, nan)

        tdSql.query(
            "select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6 from (select * from ct1 ) limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.7780731968879212)
        tdSql.checkData(0, 2, 0.6143002821164822)
        tdSql.checkData(0, 3, 3.2037266279837113)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.02246988233490299)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.1411200080598672)
        tdSql.checkData(1, 2, 0.6663667453928805)
        tdSql.checkData(1, 3, 1.558041126155035)
        tdSql.checkData(1, 4, 1.8325957145940461)
        tdSql.checkData(1, 5, 0.17204223631998083)
        tdSql.checkData(1, 6, nan)

        tdSql.query(
            "select * from (select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6, ts from st0 order by ts desc);"
        )
        tdSql.checkRows(100)
        tdSql.checkData(0, 0, 49)
        tdSql.checkData(0, 1, 0.6702291758433747)
        tdSql.checkData(0, 2, 0.9923745526637894)
        tdSql.checkData(0, 3, 0.9298143670243166)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.7136182821549459)
        tdSql.checkData(0, 6, -0.7462904241496138)
        tdSql.checkData(0, 7, datetime.datetime(2020, 10, 1, 0, 49))
        tdSql.checkData(1, 0, 49)
        tdSql.checkData(1, 1, 0.6702291758433747)
        tdSql.checkData(1, 2, 0.9923745526637894)
        tdSql.checkData(1, 3, 0.9298143670243166)
        tdSql.checkData(1, 4, nan)
        tdSql.checkData(1, 5, 0.7136182821549459)
        tdSql.checkData(1, 6, -0.7462904241496138)
        tdSql.checkData(1, 7, datetime.datetime(2020, 10, 1, 0, 49))
        tdSql.checkData(2, 0, 48)
        tdSql.checkData(2, 1, -0.26237485370392877)
        tdSql.checkData(2, 2, 0.6202081141679935)
        tdSql.checkData(2, 3, 1.8175857333771335)
        tdSql.checkData(2, 4, nan)
        tdSql.checkData(2, 5, 1.211884234321115)
        tdSql.checkData(2, 6, 5.183714988550632)
        tdSql.checkData(2, 7, datetime.datetime(2020, 10, 1, 0, 48))
        tdSql.checkData(3, 0, 48)
        tdSql.checkData(3, 1, -0.26237485370392877)
        tdSql.checkData(3, 2, 0.6202081141679935)
        tdSql.checkData(3, 3, 1.8175857333771335)
        tdSql.checkData(3, 4, nan)
        tdSql.checkData(3, 5, 1.211884234321115)
        tdSql.checkData(3, 6, 5.183714988550632)
        tdSql.checkData(3, 7, datetime.datetime(2020, 10, 1, 0, 48))
        tdSql.checkData(4, 0, 47)
        tdSql.checkData(4, 1, -0.9537526527594719)
        tdSql.checkData(4, 2, 0.6593040763085178)
        tdSql.checkData(4, 3, 3.4575106745458637)
        tdSql.checkData(4, 4, nan)
        tdSql.checkData(4, 5, 0.8820838187306987)
        tdSql.checkData(4, 6, 2.6302204463996084)
        tdSql.checkData(4, 7, datetime.datetime(2020, 10, 1, 0, 47))
        tdSql.checkData(5, 0, 47)
        tdSql.checkData(5, 1, -0.9537526527594719)
        tdSql.checkData(5, 2, 0.6593040763085178)
        tdSql.checkData(5, 3, 3.4575106745458637)
        tdSql.checkData(5, 4, nan)
        tdSql.checkData(5, 5, 0.8820838187306987)
        tdSql.checkData(5, 6, 2.6302204463996084)
        tdSql.checkData(5, 7, datetime.datetime(2020, 10, 1, 0, 47))
        tdSql.checkData(6, 0, 46)
        tdSql.checkData(6, 1, -0.7682546613236668)
        tdSql.checkData(6, 2, 0.9998433250151273)
        tdSql.checkData(6, 3, 1.2763169256468458)
        tdSql.checkData(6, 4, nan)
        tdSql.checkData(6, 5, -0.300459258677913)
        tdSql.checkData(6, 6, 0.13392039926281352)
        tdSql.checkData(6, 7, datetime.datetime(2020, 10, 1, 0, 46))
        tdSql.checkData(7, 0, 46)
        tdSql.checkData(7, 1, -0.7682546613236668)
        tdSql.checkData(7, 2, 0.9998433250151273)
        tdSql.checkData(7, 3, 1.2763169256468458)
        tdSql.checkData(7, 4, nan)
        tdSql.checkData(7, 5, -0.300459258677913)
        tdSql.checkData(7, 6, 0.13392039926281352)
        tdSql.checkData(7, 7, datetime.datetime(2020, 10, 1, 0, 46))
        tdSql.checkData(8, 0, 45)
        tdSql.checkData(8, 1, 0.123573122745224)
        tdSql.checkData(8, 2, 0.6735650596658175)
        tdSql.checkData(8, 3, 1.5193186190030223)
        tdSql.checkData(8, 4, nan)
        tdSql.checkData(8, 5, -1.5661895943272113)
        tdSql.checkData(8, 6, 5.513771854144419)
        tdSql.checkData(8, 7, datetime.datetime(2020, 10, 1, 0, 45))
        tdSql.checkData(9, 0, 45)
        tdSql.checkData(9, 1, 0.123573122745224)
        tdSql.checkData(9, 2, 0.6735650596658175)
        tdSql.checkData(9, 3, 1.5193186190030223)
        tdSql.checkData(9, 4, nan)
        tdSql.checkData(9, 5, -1.5661895943272113)
        tdSql.checkData(9, 6, 5.513771854144419)
        tdSql.checkData(9, 7, datetime.datetime(2020, 10, 1, 0, 45))
        tdSql.checkData(10, 0, 44)
        tdSql.checkData(10, 1, 0.9017883476488092)
        tdSql.checkData(10, 2, 0.6085839480802863)
        tdSql.checkData(10, 3, 3.5552629892514687)
        tdSql.checkData(10, 4, nan)
        tdSql.checkData(10, 5, -1.9810692649977342)
        tdSql.checkData(10, 6, 3.0531030020123464)
        tdSql.checkData(10, 7, datetime.datetime(2020, 10, 1, 0, 44))
        tdSql.checkData(11, 0, 44)
        tdSql.checkData(11, 1, 0.9017883476488092)
        tdSql.checkData(11, 2, 0.6085839480802863)
        tdSql.checkData(11, 3, 3.5552629892514687)
        tdSql.checkData(11, 4, nan)
        tdSql.checkData(11, 5, -1.9810692649977342)
        tdSql.checkData(11, 6, 3.0531030020123464)
        tdSql.checkData(11, 7, datetime.datetime(2020, 10, 1, 0, 44))
        tdSql.checkData(12, 0, 43)
        tdSql.checkData(12, 1, 0.8509035245341184)
        tdSql.checkData(12, 2, 0.9874457808369176)
        tdSql.checkData(12, 3, 1.5962924548219202)
        tdSql.checkData(12, 4, nan)
        tdSql.checkData(12, 5, -1.2490970766755156)
        tdSql.checkData(12, 6, 0.5781542141407696)
        tdSql.checkData(12, 7, datetime.datetime(2020, 10, 1, 0, 43))
        tdSql.checkData(13, 0, 43)
        tdSql.checkData(13, 1, 0.8509035245341184)
        tdSql.checkData(13, 2, 0.9874457808369176)
        tdSql.checkData(13, 3, 1.5962924548219202)
        tdSql.checkData(13, 4, nan)
        tdSql.checkData(13, 5, -1.2490970766755156)
        tdSql.checkData(13, 6, 0.5781542141407696)
        tdSql.checkData(13, 7, datetime.datetime(2020, 10, 1, 0, 43))
        tdSql.checkData(14, 0, 42)
        tdSql.checkData(14, 1, 0.017701925105413577)
        tdSql.checkData(14, 2, 0.7350111780599404)
        tdSql.checkData(14, 3, 1.1912997639866574)
        tdSql.checkData(14, 4, nan)
        tdSql.checkData(14, 5, 0.036467324189017214)
        tdSql.checkData(14, 6, 6.024578312510778)
        tdSql.checkData(14, 7, datetime.datetime(2020, 10, 1, 0, 42))
        tdSql.checkData(15, 0, 42)
        tdSql.checkData(15, 1, 0.017701925105413577)
        tdSql.checkData(15, 2, 0.7350111780599404)
        tdSql.checkData(15, 3, 1.1912997639866574)
        tdSql.checkData(15, 4, nan)
        tdSql.checkData(15, 5, 0.036467324189017214)
        tdSql.checkData(15, 6, 6.024578312510778)
        tdSql.checkData(15, 7, datetime.datetime(2020, 10, 1, 0, 42))
        tdSql.checkData(16, 0, 41)
        tdSql.checkData(16, 1, -0.8317747426285983)
        tdSql.checkData(16, 2, 0.5704067143341829)
        tdSql.checkData(16, 3, 3.397430462894578)
        tdSql.checkData(16, 4, nan)
        tdSql.checkData(16, 5, 0.9190273051332304)
        tdSql.checkData(16, 6, 3.473885481113728)
        tdSql.checkData(16, 7, datetime.datetime(2020, 10, 1, 0, 41))
        tdSql.checkData(17, 0, 41)
        tdSql.checkData(17, 1, -0.8317747426285983)
        tdSql.checkData(17, 2, 0.5704067143341829)
        tdSql.checkData(17, 3, 3.397430462894578)
        tdSql.checkData(17, 4, nan)
        tdSql.checkData(17, 5, 0.9190273051332304)
        tdSql.checkData(17, 6, 3.473885481113728)
        tdSql.checkData(17, 7, datetime.datetime(2020, 10, 1, 0, 41))
        tdSql.checkData(18, 0, 40)
        tdSql.checkData(18, 1, -0.9165215479156338)
        tdSql.checkData(18, 2, 0.9564033460276342)
        tdSql.checkData(18, 3, 1.889162191085516)
        tdSql.checkData(18, 4, nan)
        tdSql.checkData(18, 5, 0.90296737936602)
        tdSql.checkData(18, 6, 0.888896415152729)
        tdSql.checkData(18, 7, datetime.datetime(2020, 10, 1, 0, 40))
        tdSql.checkData(19, 0, 40)
        tdSql.checkData(19, 1, -0.9165215479156338)
        tdSql.checkData(19, 2, 0.9564033460276342)
        tdSql.checkData(19, 3, 1.889162191085516)
        tdSql.checkData(19, 4, nan)
        tdSql.checkData(19, 5, 0.90296737936602)
        tdSql.checkData(19, 6, 0.888896415152729)
        tdSql.checkData(19, 7, datetime.datetime(2020, 10, 1, 0, 40))
        tdSql.checkData(20, 0, 39)
        tdSql.checkData(20, 1, -0.158622668804709)
        tdSql.checkData(20, 2, 0.7999777847134487)
        tdSql.checkData(20, 3, 0.8435920138756074)
        tdSql.checkData(20, 4, nan)
        tdSql.checkData(20, 5, 0.3319994538301167)
        tdSql.checkData(20, 6, 7.12853286308907)
        tdSql.checkData(20, 7, datetime.datetime(2020, 10, 1, 0, 39))
        tdSql.checkData(21, 0, 39)
        tdSql.checkData(21, 1, -0.158622668804709)
        tdSql.checkData(21, 2, 0.7999777847134487)
        tdSql.checkData(21, 3, 0.8435920138756074)
        tdSql.checkData(21, 4, nan)
        tdSql.checkData(21, 5, 0.3319994538301167)
        tdSql.checkData(21, 6, 7.12853286308907)
        tdSql.checkData(21, 7, datetime.datetime(2020, 10, 1, 0, 39))
        tdSql.checkData(22, 0, 38)
        tdSql.checkData(22, 1, 0.7451131604793488)
        tdSql.checkData(22, 2, 0.5472018255605284)
        tdSql.checkData(22, 3, 3.081063350979351)
        tdSql.checkData(22, 4, nan)
        tdSql.checkData(22, 5, -0.007381884932924798)
        tdSql.checkData(22, 6, 3.8764172978929814)
        tdSql.checkData(22, 7, datetime.datetime(2020, 10, 1, 0, 38))
        tdSql.checkData(23, 0, 38)
        tdSql.checkData(23, 1, 0.7451131604793488)
        tdSql.checkData(23, 2, 0.5472018255605284)
        tdSql.checkData(23, 3, 3.081063350979351)
        tdSql.checkData(23, 4, nan)
        tdSql.checkData(23, 5, -0.007381884932924798)
        tdSql.checkData(23, 6, 3.8764172978929814)
        tdSql.checkData(23, 7, datetime.datetime(2020, 10, 1, 0, 38))
        tdSql.checkData(24, 0, 37)
        tdSql.checkData(24, 1, 0.9637953862840878)
        tdSql.checkData(24, 2, 0.909721840267583)
        tdSql.checkData(24, 3, 2.1734252903776303)
        tdSql.checkData(24, 4, nan)
        tdSql.checkData(24, 5, 0.32696474077278626)
        tdSql.checkData(24, 6, 1.174082484128993)
        tdSql.checkData(24, 7, datetime.datetime(2020, 10, 1, 0, 37))
        tdSql.checkData(25, 0, 37)
        tdSql.checkData(25, 1, 0.9637953862840878)
        tdSql.checkData(25, 2, 0.909721840267583)
        tdSql.checkData(25, 3, 2.1734252903776303)
        tdSql.checkData(25, 4, nan)
        tdSql.checkData(25, 5, 0.32696474077278626)
        tdSql.checkData(25, 6, 1.174082484128993)
        tdSql.checkData(25, 7, datetime.datetime(2020, 10, 1, 0, 37))
        tdSql.checkData(26, 0, 36)
        tdSql.checkData(26, 1, 0.2963685787093853)
        tdSql.checkData(26, 2, 0.8632704401895588)
        tdSql.checkData(26, 3, 0.5493681603601657)
        tdSql.checkData(26, 4, nan)
        tdSql.checkData(26, 5, 0.9944678850925007)
        tdSql.checkData(26, 6, 11.004294268461184)
        tdSql.checkData(26, 7, datetime.datetime(2020, 10, 1, 0, 36))
        tdSql.checkData(27, 0, 36)
        tdSql.checkData(27, 1, 0.2963685787093853)
        tdSql.checkData(27, 2, 0.8632704401895588)
        tdSql.checkData(27, 3, 0.5493681603601657)
        tdSql.checkData(27, 4, nan)
        tdSql.checkData(27, 5, 0.9944678850925007)
        tdSql.checkData(27, 6, 11.004294268461184)
        tdSql.checkData(27, 7, datetime.datetime(2020, 10, 1, 0, 36))
        tdSql.checkData(28, 0, 35)
        tdSql.checkData(28, 1, -0.6435381333569995)
        tdSql.checkData(28, 2, 0.5403764709316752)
        tdSql.checkData(28, 3, 2.734210799811235)
        tdSql.checkData(28, 4, nan)
        tdSql.checkData(28, 5, 1.1930854189064375)
        tdSql.checkData(28, 6, 4.24770540197234)
        tdSql.checkData(28, 7, datetime.datetime(2020, 10, 1, 0, 35))
        tdSql.checkData(29, 0, 35)
        tdSql.checkData(29, 1, -0.6435381333569995)
        tdSql.checkData(29, 2, 0.5403764709316752)
        tdSql.checkData(29, 3, 2.734210799811235)
        tdSql.checkData(29, 4, nan)
        tdSql.checkData(29, 5, 1.1930854189064375)
        tdSql.checkData(29, 6, 4.24770540197234)
        tdSql.checkData(29, 7, datetime.datetime(2020, 10, 1, 0, 35))
        tdSql.checkData(30, 0, 34)
        tdSql.checkData(30, 1, -0.9917788534431158)
        tdSql.checkData(30, 2, 0.8517779466253769)
        tdSql.checkData(30, 3, 2.470955260231499)
        tdSql.checkData(30, 4, nan)
        tdSql.checkData(30, 5, 0.4428112547200472)
        tdSql.checkData(30, 6, 1.4785733565944832)
        tdSql.checkData(30, 7, datetime.datetime(2020, 10, 1, 0, 34))
        tdSql.checkData(31, 0, 34)
        tdSql.checkData(31, 1, -0.9917788534431158)
        tdSql.checkData(31, 2, 0.8517779466253769)
        tdSql.checkData(31, 3, 2.470955260231499)
        tdSql.checkData(31, 4, nan)
        tdSql.checkData(31, 5, 0.4428112547200472)
        tdSql.checkData(31, 6, 1.4785733565944832)
        tdSql.checkData(31, 7, datetime.datetime(2020, 10, 1, 0, 34))
        tdSql.checkData(32, 0, 33)
        tdSql.checkData(32, 1, -0.428182669496151)
        tdSql.checkData(32, 2, 0.9194811573015673)
        tdSql.checkData(32, 3, 0.4437992589174107)
        tdSql.checkData(32, 4, nan)
        tdSql.checkData(32, 5, -0.9001958571391758)
        tdSql.checkData(32, 6, -72.33956595410905)
        tdSql.checkData(32, 7, datetime.datetime(2020, 10, 1, 0, 33))
        tdSql.checkData(33, 0, 33)
        tdSql.checkData(33, 1, -0.428182669496151)
        tdSql.checkData(33, 2, 0.9194811573015673)
        tdSql.checkData(33, 3, 0.4437992589174107)
        tdSql.checkData(33, 4, nan)
        tdSql.checkData(33, 5, -0.9001958571391758)
        tdSql.checkData(33, 6, -72.33956595410905)
        tdSql.checkData(33, 7, datetime.datetime(2020, 10, 1, 0, 33))
        tdSql.checkData(34, 0, 32)
        tdSql.checkData(34, 1, 0.5290826861200238)
        tdSql.checkData(34, 2, 0.5503344099628432)
        tdSql.checkData(34, 3, 2.413227615833899)
        tdSql.checkData(34, 4, nan)
        tdSql.checkData(34, 5, -1.8893763681780902)
        tdSql.checkData(34, 6, 4.581032079680554)
        tdSql.checkData(34, 7, datetime.datetime(2020, 10, 1, 0, 32))
        tdSql.checkData(35, 0, 32)
        tdSql.checkData(35, 1, 0.5290826861200238)
        tdSql.checkData(35, 2, 0.5503344099628432)
        tdSql.checkData(35, 3, 2.413227615833899)
        tdSql.checkData(35, 4, nan)
        tdSql.checkData(35, 5, -1.8893763681780902)
        tdSql.checkData(35, 6, 4.581032079680554)
        tdSql.checkData(35, 7, datetime.datetime(2020, 10, 1, 0, 32))
        tdSql.checkData(36, 0, 31)
        tdSql.checkData(36, 1, 0.9999118601072672)
        tdSql.checkData(36, 2, 0.7877590247885756)
        tdSql.checkData(36, 3, 2.7979785951133604)
        tdSql.checkData(36, 4, nan)
        tdSql.checkData(36, 5, -1.7874722290307907)
        tdSql.checkData(36, 6, 1.8191237353300793)
        tdSql.checkData(36, 7, datetime.datetime(2020, 10, 1, 0, 31))
        tdSql.checkData(37, 0, 31)
        tdSql.checkData(37, 1, 0.9999118601072672)
        tdSql.checkData(37, 2, 0.7877590247885756)
        tdSql.checkData(37, 3, 2.7979785951133604)
        tdSql.checkData(37, 4, nan)
        tdSql.checkData(37, 5, -1.7874722290307907)
        tdSql.checkData(37, 6, 1.8191237353300793)
        tdSql.checkData(37, 7, datetime.datetime(2020, 10, 1, 0, 31))
        tdSql.checkData(38, 0, 30)
        tdSql.checkData(38, 1, 0.5514266812416906)
        tdSql.checkData(38, 2, 0.9635288988181601)
        tdSql.checkData(38, 3, 0.5944617511422015)
        tdSql.checkData(38, 4, nan)
        tdSql.checkData(38, 5, -0.7022004347538967)
        tdSql.checkData(38, 6, -3.710141817748492)
        tdSql.checkData(38, 7, datetime.datetime(2020, 10, 1, 0, 30))
        tdSql.checkData(39, 0, 30)
        tdSql.checkData(39, 1, 0.5514266812416906)
        tdSql.checkData(39, 2, 0.9635288988181601)
        tdSql.checkData(39, 3, 0.5944617511422015)
        tdSql.checkData(39, 4, nan)
        tdSql.checkData(39, 5, -0.7022004347538967)
        tdSql.checkData(39, 6, -3.710141817748492)
        tdSql.checkData(39, 7, datetime.datetime(2020, 10, 1, 0, 30))
        tdSql.checkData(40, 0, 29)
        tdSql.checkData(40, 1, -0.404037645323065)
        tdSql.checkData(40, 2, 0.5764850221962442)
        tdSql.checkData(40, 3, 2.1197476343754156)
        tdSql.checkData(40, 4, nan)
        tdSql.checkData(40, 5, 0.5162157333804713)
        tdSql.checkData(40, 6, 4.8800154918827525)
        tdSql.checkData(40, 7, datetime.datetime(2020, 10, 1, 0, 29))
        tdSql.checkData(41, 0, 29)
        tdSql.checkData(41, 1, -0.404037645323065)
        tdSql.checkData(41, 2, 0.5764850221962442)
        tdSql.checkData(41, 3, 2.1197476343754156)
        tdSql.checkData(41, 4, nan)
        tdSql.checkData(41, 5, 0.5162157333804713)
        tdSql.checkData(41, 6, 4.8800154918827525)
        tdSql.checkData(41, 7, datetime.datetime(2020, 10, 1, 0, 29))
        tdSql.checkData(42, 0, 28)
        tdSql.checkData(42, 1, -0.9880316240928618)
        tdSql.checkData(42, 2, 0.7230710689951642)
        tdSql.checkData(42, 3, 3.1457526648156393)
        tdSql.checkData(42, 4, nan)
        tdSql.checkData(42, 5, 1.0206076417536643)
        tdSql.checkData(42, 6, 2.197019393348823)
        tdSql.checkData(42, 7, datetime.datetime(2020, 10, 1, 0, 28))
        tdSql.checkData(43, 0, 28)
        tdSql.checkData(43, 1, -0.9880316240928618)
        tdSql.checkData(43, 2, 0.7230710689951642)
        tdSql.checkData(43, 3, 3.1457526648156393)
        tdSql.checkData(43, 4, nan)
        tdSql.checkData(43, 5, 1.0206076417536643)
        tdSql.checkData(43, 6, 2.197019393348823)
        tdSql.checkData(43, 7, datetime.datetime(2020, 10, 1, 0, 28))
        tdSql.checkData(44, 0, 27)
        tdSql.checkData(44, 1, -0.6636338842129675)
        tdSql.checkData(44, 2, 0.9912542848596704)
        tdSql.checkData(44, 3, 0.9080812682077812)
        tdSql.checkData(44, 4, nan)
        tdSql.checkData(44, 5, 0.6788951190016388)
        tdSql.checkData(44, 6, -0.8324928492797357)
        tdSql.checkData(44, 7, datetime.datetime(2020, 10, 1, 0, 27))
        tdSql.checkData(45, 0, 27)
        tdSql.checkData(45, 1, -0.6636338842129675)
        tdSql.checkData(45, 2, 0.9912542848596704)
        tdSql.checkData(45, 3, 0.9080812682077812)
        tdSql.checkData(45, 4, nan)
        tdSql.checkData(45, 5, 0.6788951190016388)
        tdSql.checkData(45, 6, -0.8324928492797357)
        tdSql.checkData(45, 7, datetime.datetime(2020, 10, 1, 0, 27))
        tdSql.checkData(46, 0, 26)
        tdSql.checkData(46, 1, 0.27090578830786904)
        tdSql.checkData(46, 2, 0.6172306382193644)
        tdSql.checkData(46, 3, 1.835550377607515)
        tdSql.checkData(46, 4, nan)
        tdSql.checkData(46, 5, 0.11431954199291106)
        tdSql.checkData(46, 6, 5.165381146246765)
        tdSql.checkData(46, 7, datetime.datetime(2020, 10, 1, 0, 26))
        tdSql.checkData(47, 0, 26)
        tdSql.checkData(47, 1, 0.27090578830786904)
        tdSql.checkData(47, 2, 0.6172306382193644)
        tdSql.checkData(47, 3, 1.835550377607515)
        tdSql.checkData(47, 4, nan)
        tdSql.checkData(47, 5, 0.11431954199291106)
        tdSql.checkData(47, 6, 5.165381146246765)
        tdSql.checkData(47, 7, datetime.datetime(2020, 10, 1, 0, 26))
        tdSql.checkData(48, 0, 25)
        tdSql.checkData(48, 1, 0.956375928404503)
        tdSql.checkData(48, 2, 0.6628179613691831)
        tdSql.checkData(48, 3, 3.4435632194258416)
        tdSql.checkData(48, 4, nan)
        tdSql.checkData(48, 5, 0.05676687083562715)
        tdSql.checkData(48, 6, 2.6040987392745354)
        tdSql.checkData(48, 7, datetime.datetime(2020, 10, 1, 0, 25))
        tdSql.checkData(49, 0, 25)
        tdSql.checkData(49, 1, 0.956375928404503)
        tdSql.checkData(49, 2, 0.6628179613691831)
        tdSql.checkData(49, 3, 3.4435632194258416)
        tdSql.checkData(49, 4, nan)
        tdSql.checkData(49, 5, 0.05676687083562715)
        tdSql.checkData(49, 6, 2.6040987392745354)
        tdSql.checkData(49, 7, datetime.datetime(2020, 10, 1, 0, 25))
        tdSql.checkData(50, 0, 24)
        tdSql.checkData(50, 1, 0.7625584504796027)
        tdSql.checkData(50, 2, 0.999960827417674)
        tdSql.checkData(50, 3, 1.2552318002593996)
        tdSql.checkData(50, 4, nan)
        tdSql.checkData(50, 5, 0.6200983185456957)
        tdSql.checkData(50, 6, 0.09684864095463253)
        tdSql.checkData(50, 7, datetime.datetime(2020, 10, 1, 0, 24))
        tdSql.checkData(51, 0, 24)
        tdSql.checkData(51, 1, 0.7625584504796027)
        tdSql.checkData(51, 2, 0.999960827417674)
        tdSql.checkData(51, 3, 1.2552318002593996)
        tdSql.checkData(51, 4, nan)
        tdSql.checkData(51, 5, 0.6200983185456957)
        tdSql.checkData(51, 6, 0.09684864095463253)
        tdSql.checkData(51, 7, datetime.datetime(2020, 10, 1, 0, 24))
        tdSql.checkData(52, 0, 23)
        tdSql.checkData(52, 1, -0.13235175009777303)
        tdSql.checkData(52, 2, 0.6699494442536529)
        tdSql.checkData(52, 3, 1.5387402975985367)
        tdSql.checkData(52, 4, nan)
        tdSql.checkData(52, 5, 1.1825447904081037)
        tdSql.checkData(52, 6, 5.489941431040083)
        tdSql.checkData(52, 7, datetime.datetime(2020, 10, 1, 0, 23))
        tdSql.checkData(53, 0, 23)
        tdSql.checkData(53, 1, -0.13235175009777303)
        tdSql.checkData(53, 2, 0.6699494442536529)
        tdSql.checkData(53, 3, 1.5387402975985367)
        tdSql.checkData(53, 4, nan)
        tdSql.checkData(53, 5, 1.1825447904081037)
        tdSql.checkData(53, 6, 5.489941431040083)
        tdSql.checkData(53, 7, datetime.datetime(2020, 10, 1, 0, 23))
        tdSql.checkData(54, 0, 22)
        tdSql.checkData(54, 1, -0.9055783620066239)
        tdSql.checkData(54, 2, 0.6114178044194122)
        tdSql.checkData(54, 3, 3.5568711064263105)
        tdSql.checkData(54, 4, nan)
        tdSql.checkData(54, 5, 0.9837833410919679)
        tdSql.checkData(54, 6, 3.0265535811470983)
        tdSql.checkData(54, 7, datetime.datetime(2020, 10, 1, 0, 22))
        tdSql.checkData(55, 0, 22)
        tdSql.checkData(55, 1, -0.9055783620066239)
        tdSql.checkData(55, 2, 0.6114178044194122)
        tdSql.checkData(55, 3, 3.5568711064263105)
        tdSql.checkData(55, 4, nan)
        tdSql.checkData(55, 5, 0.9837833410919679)
        tdSql.checkData(55, 6, 3.0265535811470983)
        tdSql.checkData(55, 7, datetime.datetime(2020, 10, 1, 0, 22))
        tdSql.checkData(56, 0, 21)
        tdSql.checkData(56, 1, -0.8462204041751706)
        tdSql.checkData(56, 2, 0.9887894200405688)
        tdSql.checkData(56, 3, 1.5772240911721418)
        tdSql.checkData(56, 4, nan)
        tdSql.checkData(56, 5, -0.11647857397382422)
        tdSql.checkData(56, 6, 0.5559799244477626)
        tdSql.checkData(56, 7, datetime.datetime(2020, 10, 1, 0, 21))
        tdSql.checkData(57, 0, 21)
        tdSql.checkData(57, 1, -0.8462204041751706)
        tdSql.checkData(57, 2, 0.9887894200405688)
        tdSql.checkData(57, 3, 1.5772240911721418)
        tdSql.checkData(57, 4, nan)
        tdSql.checkData(57, 5, -0.11647857397382422)
        tdSql.checkData(57, 6, 0.5559799244477626)
        tdSql.checkData(57, 7, datetime.datetime(2020, 10, 1, 0, 21))
        tdSql.checkData(58, 0, 20)
        tdSql.checkData(58, 1, -0.008851309290403876)
        tdSql.checkData(58, 2, 0.7310155667453407)
        tdSql.checkData(58, 3, 1.2127175951404974)
        tdSql.checkData(58, 4, nan)
        tdSql.checkData(58, 5, -1.4304290589415767)
        tdSql.checkData(58, 6, 5.982274104704091)
        tdSql.checkData(58, 7, datetime.datetime(2020, 10, 1, 0, 20))
        tdSql.checkData(59, 0, 20)
        tdSql.checkData(59, 1, -0.008851309290403876)
        tdSql.checkData(59, 2, 0.7310155667453407)
        tdSql.checkData(59, 3, 1.2127175951404974)
        tdSql.checkData(59, 4, nan)
        tdSql.checkData(59, 5, -1.4304290589415767)
        tdSql.checkData(59, 6, 5.982274104704091)
        tdSql.checkData(59, 7, datetime.datetime(2020, 10, 1, 0, 20))
        tdSql.checkData(60, 0, 19)
        tdSql.checkData(60, 1, 0.8366556385360561)
        tdSql.checkData(60, 2, 0.5723746128431292)
        tdSql.checkData(60, 3, 3.413484890511323)
        tdSql.checkData(60, 4, nan)
        tdSql.checkData(60, 5, -1.9952541841757747)
        tdSql.checkData(60, 6, 3.4479580493217856)
        tdSql.checkData(60, 7, datetime.datetime(2020, 10, 1, 0, 19))
        tdSql.checkData(61, 0, 19)
        tdSql.checkData(61, 1, 0.8366556385360561)
        tdSql.checkData(61, 2, 0.5723746128431292)
        tdSql.checkData(61, 3, 3.413484890511323)
        tdSql.checkData(61, 4, nan)
        tdSql.checkData(61, 5, -1.9952541841757747)
        tdSql.checkData(61, 6, 3.4479580493217856)
        tdSql.checkData(61, 7, datetime.datetime(2020, 10, 1, 0, 19))
        tdSql.checkData(62, 0, 18)
        tdSql.checkData(62, 1, 0.9129452507276277)
        tdSql.checkData(62, 2, 0.9588413200803038)
        tdSql.checkData(62, 3, 1.8713332491184997)
        tdSql.checkData(62, 4, nan)
        tdSql.checkData(62, 5, -1.3983047743451864)
        tdSql.checkData(62, 6, 0.8709074342191974)
        tdSql.checkData(62, 7, datetime.datetime(2020, 10, 1, 0, 18))
        tdSql.checkData(63, 0, 18)
        tdSql.checkData(63, 1, 0.9129452507276277)
        tdSql.checkData(63, 2, 0.9588413200803038)
        tdSql.checkData(63, 3, 1.8713332491184997)
        tdSql.checkData(63, 4, nan)
        tdSql.checkData(63, 5, -1.3983047743451864)
        tdSql.checkData(63, 6, 0.8709074342191974)
        tdSql.checkData(63, 7, datetime.datetime(2020, 10, 1, 0, 18))
        tdSql.checkData(64, 0, 17)
        tdSql.checkData(64, 1, 0.14987720966295234)
        tdSql.checkData(64, 2, 0.7959095686227995)
        tdSql.checkData(64, 3, 0.864944320724419)
        tdSql.checkData(64, 4, nan)
        tdSql.checkData(64, 5, -0.13037289959062748)
        tdSql.checkData(64, 6, 7.022998331594864)
        tdSql.checkData(64, 7, datetime.datetime(2020, 10, 1, 0, 17))
        tdSql.checkData(65, 0, 17)
        tdSql.checkData(65, 1, 0.14987720966295234)
        tdSql.checkData(65, 2, 0.7959095686227995)
        tdSql.checkData(65, 3, 0.864944320724419)
        tdSql.checkData(65, 4, nan)
        tdSql.checkData(65, 5, -0.13037289959062748)
        tdSql.checkData(65, 6, 7.022998331594864)
        tdSql.checkData(65, 7, datetime.datetime(2020, 10, 1, 0, 17))
        tdSql.checkData(66, 0, 16)
        tdSql.checkData(66, 1, -0.750987246771676)
        tdSql.checkData(66, 2, 0.5481819942730298)
        tdSql.checkData(66, 3, 3.102748784455539)
        tdSql.checkData(66, 4, nan)
        tdSql.checkData(66, 5, 0.8513297604701857)
        tdSql.checkData(66, 6, 3.852058923265594)
        tdSql.checkData(66, 7, datetime.datetime(2020, 10, 1, 0, 16))
        tdSql.checkData(67, 0, 16)
        tdSql.checkData(67, 1, -0.750987246771676)
        tdSql.checkData(67, 2, 0.5481819942730298)
        tdSql.checkData(67, 3, 3.102748784455539)
        tdSql.checkData(67, 4, nan)
        tdSql.checkData(67, 5, 0.8513297604701857)
        tdSql.checkData(67, 6, 3.852058923265594)
        tdSql.checkData(67, 7, datetime.datetime(2020, 10, 1, 0, 16))
        tdSql.checkData(68, 0, 15)
        tdSql.checkData(68, 1, -0.9613974918795568)
        tdSql.checkData(68, 2, 0.9130208165623314)
        tdSql.checkData(68, 3, 2.1554866011151765)
        tdSql.checkData(68, 4, nan)
        tdSql.checkData(68, 5, 0.9521751875546269)
        tdSql.checkData(68, 6, 1.1559749749986195)
        tdSql.checkData(68, 7, datetime.datetime(2020, 10, 1, 0, 15))
        tdSql.checkData(69, 0, 15)
        tdSql.checkData(69, 1, -0.9613974918795568)
        tdSql.checkData(69, 2, 0.9130208165623314)
        tdSql.checkData(69, 3, 2.1554866011151765)
        tdSql.checkData(69, 4, nan)
        tdSql.checkData(69, 5, 0.9521751875546269)
        tdSql.checkData(69, 6, 1.1559749749986195)
        tdSql.checkData(69, 7, datetime.datetime(2020, 10, 1, 0, 15))
        tdSql.checkData(70, 0, 14)
        tdSql.checkData(70, 1, -0.2879033166650653)
        tdSql.checkData(70, 2, 0.859465627274523)
        tdSql.checkData(70, 3, 0.5636905248139659)
        tdSql.checkData(70, 4, nan)
        tdSql.checkData(70, 5, 0.41142163587369207)
        tdSql.checkData(70, 6, 10.515512404402676)
        tdSql.checkData(70, 7, datetime.datetime(2020, 10, 1, 0, 14))
        tdSql.checkData(71, 0, 14)
        tdSql.checkData(71, 1, -0.2879033166650653)
        tdSql.checkData(71, 2, 0.859465627274523)
        tdSql.checkData(71, 3, 0.5636905248139659)
        tdSql.checkData(71, 4, nan)
        tdSql.checkData(71, 5, 0.41142163587369207)
        tdSql.checkData(71, 6, 10.515512404402676)
        tdSql.checkData(71, 7, datetime.datetime(2020, 10, 1, 0, 14))
        tdSql.checkData(72, 0, 13)
        tdSql.checkData(72, 1, 0.6502878401571168)
        tdSql.checkData(72, 2, 0.5403105467456532)
        tdSql.checkData(72, 3, 2.75535470715349)
        tdSql.checkData(72, 4, nan)
        tdSql.checkData(72, 5, 0.0009616202598659029)
        tdSql.checkData(72, 6, 4.225579583416092)
        tdSql.checkData(72, 7, datetime.datetime(2020, 10, 1, 0, 13))
        tdSql.checkData(73, 0, 13)
        tdSql.checkData(73, 1, 0.6502878401571168)
        tdSql.checkData(73, 2, 0.5403105467456532)
        tdSql.checkData(73, 3, 2.75535470715349)
        tdSql.checkData(73, 4, nan)
        tdSql.checkData(73, 5, 0.0009616202598659029)
        tdSql.checkData(73, 6, 4.225579583416092)
        tdSql.checkData(73, 7, datetime.datetime(2020, 10, 1, 0, 13))
        tdSql.checkData(74, 0, 12)
        tdSql.checkData(74, 1, 0.9906073556948704)
        tdSql.checkData(74, 2, 0.8556343548213666)
        tdSql.checkData(74, 3, 2.451594361777497)
        tdSql.checkData(74, 4, nan)
        tdSql.checkData(74, 5, 0.24838494428124291)
        tdSql.checkData(74, 6, 1.4585617093317953)
        tdSql.checkData(74, 7, datetime.datetime(2020, 10, 1, 0, 12))
        tdSql.checkData(75, 0, 12)
        tdSql.checkData(75, 1, 0.9906073556948704)
        tdSql.checkData(75, 2, 0.8556343548213666)
        tdSql.checkData(75, 3, 2.451594361777497)
        tdSql.checkData(75, 4, nan)
        tdSql.checkData(75, 5, 0.24838494428124291)
        tdSql.checkData(75, 6, 1.4585617093317953)
        tdSql.checkData(75, 7, datetime.datetime(2020, 10, 1, 0, 12))
        tdSql.checkData(76, 0, 11)
        tdSql.checkData(76, 1, 0.4201670368266409)
        tdSql.checkData(76, 2, 0.9162743174606308)
        tdSql.checkData(76, 3, 0.44272645708128566)
        tdSql.checkData(76, 4, nan)
        tdSql.checkData(76, 5, 0.9151372562290566)
        tdSql.checkData(76, 6, -222.95969776348554)
        tdSql.checkData(76, 7, datetime.datetime(2020, 10, 1, 0, 11))
        tdSql.checkData(77, 0, 11)
        tdSql.checkData(77, 1, 0.4201670368266409)
        tdSql.checkData(77, 2, 0.9162743174606308)
        tdSql.checkData(77, 3, 0.44272645708128566)
        tdSql.checkData(77, 4, nan)
        tdSql.checkData(77, 5, 0.9151372562290566)
        tdSql.checkData(77, 6, -222.95969776348554)
        tdSql.checkData(77, 7, datetime.datetime(2020, 10, 1, 0, 11))
        tdSql.checkData(78, 0, 10)
        tdSql.checkData(78, 1, -0.5365729180004349)
        tdSql.checkData(78, 2, 0.549226270051226)
        tdSql.checkData(78, 3, 2.432352856101439)
        tdSql.checkData(78, 4, nan)
        tdSql.checkData(78, 5, 1.2185572409879093)
        tdSql.checkData(78, 6, 4.561306078186714)
        tdSql.checkData(78, 7, datetime.datetime(2020, 10, 1, 0, 10))
        tdSql.checkData(79, 0, 10)
        tdSql.checkData(79, 1, -0.5365729180004349)
        tdSql.checkData(79, 2, 0.549226270051226)
        tdSql.checkData(79, 3, 2.432352856101439)
        tdSql.checkData(79, 4, nan)
        tdSql.checkData(79, 5, 1.2185572409879093)
        tdSql.checkData(79, 6, 4.561306078186714)
        tdSql.checkData(79, 7, datetime.datetime(2020, 10, 1, 0, 10))
        tdSql.checkData(80, 0, 9)
        tdSql.checkData(80, 1, -0.9999902065507035)
        tdSql.checkData(80, 2, 0.7918362090144786)
        tdSql.checkData(80, 3, 2.776612511546888)
        tdSql.checkData(80, 4, nan)
        tdSql.checkData(80, 5, 0.5929886271208413)
        tdSql.checkData(80, 6, 1.796697093786514)
        tdSql.checkData(80, 7, datetime.datetime(2020, 10, 1, 0, 9))
        tdSql.checkData(81, 0, 9)
        tdSql.checkData(81, 1, -0.9999902065507035)
        tdSql.checkData(81, 2, 0.7918362090144786)
        tdSql.checkData(81, 3, 2.776612511546888)
        tdSql.checkData(81, 4, nan)
        tdSql.checkData(81, 5, 0.5929886271208413)
        tdSql.checkData(81, 6, 1.796697093786514)
        tdSql.checkData(81, 7, datetime.datetime(2020, 10, 1, 0, 9))
        tdSql.checkData(82, 0, 8)
        tdSql.checkData(82, 1, -0.5440211108893698)
        tdSql.checkData(82, 2, 0.9612168045072789)
        tdSql.checkData(82, 3, 0.5787344727995947)
        tdSql.checkData(82, 4, nan)
        tdSql.checkData(82, 5, -0.7199655182148126)
        tdSql.checkData(82, 6, -4.087614771885445)
        tdSql.checkData(82, 7, datetime.datetime(2020, 10, 1, 0, 8))
        tdSql.checkData(83, 0, 8)
        tdSql.checkData(83, 1, -0.5440211108893698)
        tdSql.checkData(83, 2, 0.9612168045072789)
        tdSql.checkData(83, 3, 0.5787344727995947)
        tdSql.checkData(83, 4, nan)
        tdSql.checkData(83, 5, -0.7199655182148126)
        tdSql.checkData(83, 6, -4.087614771885445)
        tdSql.checkData(83, 7, datetime.datetime(2020, 10, 1, 0, 8))
        tdSql.checkData(84, 0, 7)
        tdSql.checkData(84, 1, 0.4121184852417566)
        tdSql.checkData(84, 2, 0.574400879193934)
        tdSql.checkData(84, 3, 2.137595835197328)
        tdSql.checkData(84, 4, nan)
        tdSql.checkData(84, 5, -1.8119088619792247)
        tdSql.checkData(84, 6, 4.862055338419189)
        tdSql.checkData(84, 7, datetime.datetime(2020, 10, 1, 0, 7))
        tdSql.checkData(85, 0, 7)
        tdSql.checkData(85, 1, 0.4121184852417566)
        tdSql.checkData(85, 2, 0.574400879193934)
        tdSql.checkData(85, 3, 2.137595835197328)
        tdSql.checkData(85, 4, nan)
        tdSql.checkData(85, 5, -1.8119088619792247)
        tdSql.checkData(85, 6, 4.862055338419189)
        tdSql.checkData(85, 7, datetime.datetime(2020, 10, 1, 0, 7))
        tdSql.checkData(86, 0, 6)
        tdSql.checkData(86, 1, 0.9893582466233818)
        tdSql.checkData(86, 2, 0.7270351311688125)
        tdSql.checkData(86, 3, 3.1243204798042576)
        tdSql.checkData(86, 4, nan)
        tdSql.checkData(86, 5, -1.8696882565721156)
        tdSql.checkData(86, 6, 2.172420890614816)
        tdSql.checkData(86, 7, datetime.datetime(2020, 10, 1, 0, 6))
        tdSql.checkData(87, 0, 6)
        tdSql.checkData(87, 1, 0.9893582466233818)
        tdSql.checkData(87, 2, 0.7270351311688125)
        tdSql.checkData(87, 3, 3.1243204798042576)
        tdSql.checkData(87, 4, nan)
        tdSql.checkData(87, 5, -1.8696882565721156)
        tdSql.checkData(87, 6, 2.172420890614816)
        tdSql.checkData(87, 7, datetime.datetime(2020, 10, 1, 0, 6))
        tdSql.checkData(88, 0, 5)
        tdSql.checkData(88, 1, 0.6569865987187891)
        tdSql.checkData(88, 2, 0.9900590857598653)
        tdSql.checkData(88, 3, 0.8864495743441427)
        tdSql.checkData(88, 4, nan)
        tdSql.checkData(88, 5, -0.876294736008743)
        tdSql.checkData(88, 6, -0.9245361171359558)
        tdSql.checkData(88, 7, datetime.datetime(2020, 10, 1, 0, 5))
        tdSql.checkData(89, 0, 5)
        tdSql.checkData(89, 1, 0.6569865987187891)
        tdSql.checkData(89, 2, 0.9900590857598653)
        tdSql.checkData(89, 3, 0.8864495743441427)
        tdSql.checkData(89, 4, nan)
        tdSql.checkData(89, 5, -0.876294736008743)
        tdSql.checkData(89, 6, -0.9245361171359558)
        tdSql.checkData(89, 7, datetime.datetime(2020, 10, 1, 0, 5))
        tdSql.checkData(90, 0, 4)
        tdSql.checkData(90, 1, -0.27941549819892586)
        tdSql.checkData(90, 2, 0.6143002821164822)
        tdSql.checkData(90, 3, 1.853464438509776)
        tdSql.checkData(90, 4, nan)
        tdSql.checkData(90, 5, 0.38234027607634785)
        tdSql.checkData(90, 6, 5.147179528972959)
        tdSql.checkData(90, 7, datetime.datetime(2020, 10, 1, 0, 4))
        tdSql.checkData(91, 0, 4)
        tdSql.checkData(91, 1, -0.27941549819892586)
        tdSql.checkData(91, 2, 0.6143002821164822)
        tdSql.checkData(91, 3, 1.853464438509776)
        tdSql.checkData(91, 4, nan)
        tdSql.checkData(91, 5, 0.38234027607634785)
        tdSql.checkData(91, 6, 5.147179528972959)
        tdSql.checkData(91, 7, datetime.datetime(2020, 10, 1, 0, 4))
        tdSql.checkData(92, 0, 3)
        tdSql.checkData(92, 1, -0.9589242746631385)
        tdSql.checkData(92, 2, 0.6663667453928805)
        tdSql.checkData(92, 3, 3.4288753232277074)
        tdSql.checkData(92, 4, nan)
        tdSql.checkData(92, 5, 1.0087371784424417)
        tdSql.checkData(92, 6, 2.5780379587267963)
        tdSql.checkData(92, 7, datetime.datetime(2020, 10, 1, 0, 3))
        tdSql.checkData(93, 0, 3)
        tdSql.checkData(93, 1, -0.9589242746631385)
        tdSql.checkData(93, 2, 0.6663667453928805)
        tdSql.checkData(93, 3, 3.4288753232277074)
        tdSql.checkData(93, 4, nan)
        tdSql.checkData(93, 5, 1.0087371784424417)
        tdSql.checkData(93, 6, 2.5780379587267963)
        tdSql.checkData(93, 7, datetime.datetime(2020, 10, 1, 0, 3))
        tdSql.checkData(94, 0, 2)
        tdSql.checkData(94, 1, -0.7568024953079282)
        tdSql.checkData(94, 2, 1.0)
        tdSql.checkData(94, 3, 1.2340302976078754)
        tdSql.checkData(94, 4, nan)
        tdSql.checkData(94, 5, 0.7554222939559553)
        tdSql.checkData(94, 6, 0.05815764143055291)
        tdSql.checkData(94, 7, datetime.datetime(2020, 10, 1, 0, 2))
        tdSql.checkData(95, 0, 2)
        tdSql.checkData(95, 1, -0.7568024953079282)
        tdSql.checkData(95, 2, 1.0)
        tdSql.checkData(95, 3, 1.2340302976078754)
        tdSql.checkData(95, 4, nan)
        tdSql.checkData(95, 5, 0.7554222939559553)
        tdSql.checkData(95, 6, 0.05815764143055291)
        tdSql.checkData(95, 7, datetime.datetime(2020, 10, 1, 0, 2))
        tdSql.checkData(96, 0, 1)
        tdSql.checkData(96, 1, 0.1411200080598672)
        tdSql.checkData(96, 2, 0.6663667453928805)
        tdSql.checkData(96, 3, 1.558041126155035)
        tdSql.checkData(96, 4, 1.8325957145940461)
        tdSql.checkData(96, 5, 0.17204223631998083)
        tdSql.checkData(96, 6, nan)
        tdSql.checkData(96, 7, datetime.datetime(2020, 10, 1, 0, 1))
        tdSql.checkData(97, 0, 1)
        tdSql.checkData(97, 1, 0.1411200080598672)
        tdSql.checkData(97, 2, 0.6663667453928805)
        tdSql.checkData(97, 3, 1.558041126155035)
        tdSql.checkData(97, 4, 1.8325957145940461)
        tdSql.checkData(97, 5, 0.17204223631998083)
        tdSql.checkData(97, 6, nan)
        tdSql.checkData(97, 7, datetime.datetime(2020, 10, 1, 0, 1))
        tdSql.checkData(98, 0, 0)
        tdSql.checkData(98, 1, 0.7780731968879212)
        tdSql.checkData(98, 2, 0.6143002821164822)
        tdSql.checkData(98, 3, 3.2037266279837113)
        tdSql.checkData(98, 4, nan)
        tdSql.checkData(98, 5, 0.02246988233490299)
        tdSql.checkData(98, 6, nan)
        tdSql.checkData(98, 7, datetime.datetime(2020, 10, 1, 0, 0))
        tdSql.checkData(99, 0, 0)
        tdSql.checkData(99, 1, 0.7780731968879212)
        tdSql.checkData(99, 2, 0.6143002821164822)
        tdSql.checkData(99, 3, 3.2037266279837113)
        tdSql.checkData(99, 4, nan)
        tdSql.checkData(99, 5, 0.02246988233490299)
        tdSql.checkData(99, 6, nan)
        tdSql.checkData(99, 7, datetime.datetime(2020, 10, 1, 0, 0))

        tdSql.query(
            "select * from (select c1, sin(c2+2), cos(sin(c1-2)), tan(cos(c2*2))+2, asin(acos(c2%3))+acos(c3/2)+atan(c5*c2) as v4, sin(c4+4.5)+cos(c3/2), tan(c1)+log(c3, c4)+sin(c6+c3)+2 as v6, ts from ct1 order by ts limit 2);;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, 0.7780731968879212)
        tdSql.checkData(0, 2, 0.6143002821164822)
        tdSql.checkData(0, 3, 3.2037266279837113)
        tdSql.checkData(0, 4, nan)
        tdSql.checkData(0, 5, 0.02246988233490299)
        tdSql.checkData(0, 6, nan)
        tdSql.checkData(0, 7, datetime.datetime(2020, 10, 1, 0, 0))
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.1411200080598672)
        tdSql.checkData(1, 2, 0.6663667453928805)
        tdSql.checkData(1, 3, 1.558041126155035)
        tdSql.checkData(1, 4, 1.8325957145940461)
        tdSql.checkData(1, 5, 0.17204223631998083)
        tdSql.checkData(1, 6, nan)
        tdSql.checkData(1, 7, datetime.datetime(2020, 10, 1, 0, 1))

        tdSql.execute("drop database db0")

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
