/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 469
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy2;
  SNode* yy42;
  bool yy103;
  EOrder yy106;
  SNodeList* yy110;
  SToken yy225;
  EFillMode yy410;
  SDataType yy448;
  SAlterOption yy459;
  int32_t yy508;
  ENullOrder yy599;
  EJoinType yy638;
  int64_t yy641;
  int8_t yy705;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             737
#define YYNRULE              560
#define YYNTOKEN             328
#define YY_MAX_SHIFT         736
#define YY_MIN_SHIFTREDUCE   1094
#define YY_MAX_SHIFTREDUCE   1653
#define YY_ERROR_ACTION      1654
#define YY_ACCEPT_ACTION     1655
#define YY_NO_ACTION         1656
#define YY_MIN_REDUCE        1657
#define YY_MAX_REDUCE        2216
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2837)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   476, 1680,  477, 1693, 1893,  589, 1799,  607, 2014, 2187,
 /*    10 */  1795, 1863,   45,   43, 1581,  482, 1929,  176,  343, 2010,
 /*    20 */   376,  478, 1430, 1801,  588,  182,  421, 1861,  367, 2188,
 /*    30 */   590, 1926,  613, 1511, 2010, 1428, 2028, 2192,  345, 1912,
 /*    40 */  2014, 2187,   38,   37, 1929, 1996,   44,   42,   41,   40,
 /*    50 */    39, 2010,  564, 2006, 2012,  357, 2187, 2191, 1506, 1927,
 /*    60 */   613, 2188, 2190,   18,  636,  178,  328, 2046, 2006, 2012,
 /*    70 */  1436, 2193,  182,  368,  601,  640, 2188,  590, 1850,  636,
 /*    80 */  1996,  164,  642,   45,   43, 2006, 2012,  358,  589, 1455,
 /*    90 */  1812,  376, 2187, 1430,  164,   14,  636,  338,   44,   42,
 /*   100 */    41,   40,   39, 1813, 1511,  140, 1428,  588,  182,   35,
 /*   110 */   286, 2027, 2188,  590,  166, 2063, 1669,  733,  322, 2029,
 /*   120 */   646, 2031, 2032,  641,  639,  636,  627, 2081,  268, 1506,
 /*   130 */     8, 2015, 1513, 1514,   18, 1788,  381, 1989, 1540, 1856,
 /*   140 */  1858, 1436, 2010,  625, 1253,  668,  667,  666, 1257,  665,
 /*   150 */  1259, 1260,  664, 1262,  661,  439, 1268,  658, 1270, 1271,
 /*   160 */   655,  652, 1486, 1496,  438,   61,   14,   92, 1512, 1515,
 /*   170 */   265, 2124,  600, 1585,  133,  599, 2006, 2012, 2187, 1455,
 /*   180 */  1857, 1858,  564, 1431, 1863, 1429, 2187,  636,  733,  349,
 /*   190 */  1127,  354, 1456,  588,  182, 1541,   61,  494, 2188,  590,
 /*   200 */  1861, 2193,  182, 1513, 1514,  167, 2188,  590, 1434, 1435,
 /*   210 */  1764, 1485, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495,
 /*   220 */   638,  634, 1504, 1505, 1507, 1508, 1509, 1510,    2, 1129,
 /*   230 */   611, 1132, 1133, 1486, 1496,  494,   49,   86,  122, 1512,
 /*   240 */  1515,  121,  120,  119,  118,  117,  116,  115,  114,  113,
 /*   250 */   350,  136,  348,  347, 1431,  517, 1429,   38,   37,  519,
 /*   260 */  1805,   44,   42,   41,   40,   39,  584,   34,  374, 1535,
 /*   270 */  1536, 1537, 1538, 1539, 1543, 1544, 1545, 1546, 1456, 1434,
 /*   280 */  1435,  518, 1485, 1488, 1489, 1490, 1491, 1492, 1493, 1494,
 /*   290 */  1495,  638,  634, 1504, 1505, 1507, 1508, 1509, 1510,    2,
 /*   300 */   379,   11,   45,   43, 1296, 1297, 2046,  220,  161,  612,
 /*   310 */   376, 1863, 1430, 1658,  583,  355,  185, 1812,  364,  680,
 /*   320 */   601, 1487,  171, 1511, 1861, 1428, 2028, 1861,  511,  507,
 /*   330 */   503,  499,  217, 1990,  122,  535, 1574,  121,  120,  119,
 /*   340 */   118,  117,  116,  115,  114,  113, 1454,  185, 1506,   61,
 /*   350 */   545,  140,  485,   18,  477, 1693,  492, 2046, 1922,  582,
 /*   360 */  1436, 1146, 1679, 1145,  233,  643,  234, 2131,   87,  379,
 /*   370 */  1996,  215,  642,   45,   43, 1516,  219,  164,  564,  538,
 /*   380 */   579,  376, 2187, 1430,  532,   14, 1812,  185, 1863,  232,
 /*   390 */  1368, 1369, 1147, 2128, 1511,  369, 1428, 2193,  182,   65,
 /*   400 */  1455, 2027, 2188,  590, 1861, 2063, 1996,  733,  168, 2029,
 /*   410 */   646, 2031, 2032,  641,  553,  636,  181, 2124, 2125, 1506,
 /*   420 */   138, 2129, 1513, 1514, 1650,   69, 1367, 1370,   68,   89,
 /*   430 */   333, 1436,  100,  548,  382,  546,  413,  601,  412,  214,
 /*   440 */   208,  626,  164, 1982,  213, 2131,  626,  490,  612,  565,
 /*   450 */  2153, 1812, 1486, 1496, 1803,  132,   46, 1657, 1512, 1515,
 /*   460 */   132,  411,  515,  206,  585,  580,  573,  520,  140,   86,
 /*   470 */   625, 2127, 1810, 1431, 1726, 1429,  475, 1810,  733,  480,
 /*   480 */  1699,  131,  130,  129,  128,  127,  126,  125,  124,  123,
 /*   490 */    61,  396, 1806, 1513, 1514,  610,  601, 1922, 1434, 1435,
 /*   500 */   185, 1485, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495,
 /*   510 */   638,  634, 1504, 1505, 1507, 1508, 1509, 1510,    2, 2192,
 /*   520 */  2028, 1649, 1521, 1486, 1496, 1787,  625,  140, 1455, 1512,
 /*   530 */  1515,  176,  603,  180, 2124, 2125, 1457,  138, 2129,  530,
 /*   540 */   529,  528, 1351, 1352, 1431,   48, 1429,  137,  524, 1863,
 /*   550 */  1455, 2046,  523, 1913,   13,   12,  380,  522,  527,  604,
 /*   560 */    11,  612,    9,  521, 1996, 1861,  642,  526,  525, 1434,
 /*   570 */  1435, 1678, 1485, 1488, 1489, 1490, 1491, 1492, 1493, 1494,
 /*   580 */  1495,  638,  634, 1504, 1505, 1507, 1508, 1509, 1510,    2,
 /*   590 */    45,   43,  183, 2124, 2125, 2027,  138, 2129,  376, 2063,
 /*   600 */  1430,   48,  109, 2029,  646, 2031, 2032,  641,  621,  636,
 /*   610 */  1922, 1511, 1643, 1428,  179, 1996, 2116, 1863,  459, 2028,
 /*   620 */   370, 2112, 1213,   38,   37,   61,   11,   44,   42,   41,
 /*   630 */    40,   39,  678, 1862,  184, 1458, 1506, 1677,  408,   38,
 /*   640 */    37,  185, 2142,   44,   42,   41,   40,   39, 1436, 1554,
 /*   650 */  2046,  154,  153,  675,  674,  673,  151, 1215,  643,  410,
 /*   660 */   406,   45,   43, 1996, 1457,  642, 1542, 2014, 2192,  376,
 /*   670 */  1487, 1430, 2187,   46, 2131, 1786,  198,  197, 2010,  194,
 /*   680 */   267, 1996, 1511,  235, 1428, 2028,  484,  415, 2191,  480,
 /*   690 */  1699,  414, 2188, 2189, 2027,  733,  185, 2017, 2063,  458,
 /*   700 */  2126,  169, 2029,  646, 2031, 2032,  641, 1506,  636, 1785,
 /*   710 */  1513, 1514, 2006, 2012,  371,   83, 2046,  519,   82, 1436,
 /*   720 */   628,  106, 2088,  636,  643,  277,  278, 1620,  626, 1996,
 /*   730 */   276,  642,  564,  671, 1676,  141, 2187,  680,   32,  518,
 /*   740 */  1486, 1496,  287, 1802,   14, 2019, 1512, 1515, 1547, 1406,
 /*   750 */  1407, 2193,  182,  591, 2208,  142, 2188,  590, 2087, 1810,
 /*   760 */  2027, 1431,  544, 1429, 2063, 1436,  733,  168, 2029,  646,
 /*   770 */  2031, 2032,  641,   52,  636,  542,  185,  540, 1996,  245,
 /*   780 */   563, 1513, 1514,   41,   40,   39, 1434, 1435,  633, 1485,
 /*   790 */  1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495,  638,  634,
 /*   800 */  1504, 1505, 1507, 1508, 1509, 1510,    2,  422,  267, 2154,
 /*   810 */   626, 1486, 1496,  331, 1175, 1453,  678, 1512, 1515, 1908,
 /*   820 */   423,  630,  452, 2088,  187,  466,  704,  702,  465,  693,
 /*   830 */   190, 1780, 1431, 1908, 1429,  154,  153,  675,  674,  673,
 /*   840 */   151, 1810, 1675,  435,  192,  467,   38,   37,  437, 1176,
 /*   850 */    44,   42,   41,   40,   39, 1578, 1458, 1434, 1435, 1966,
 /*   860 */  1485, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495,  638,
 /*   870 */   634, 1504, 1505, 1507, 1508, 1509, 1510,    2,   73, 1674,
 /*   880 */   626,  626,  626,  165, 1132, 1133, 1996, 1908,  306,  346,
 /*   890 */  1723,  530,  529,  528,   54,  419,  420,  692,  196,  137,
 /*   900 */   524,  425,  304,   72,  523,  236,   71, 1652, 1653,  522,
 /*   910 */   527, 1810, 1810, 1810, 1797,  521,  672, 1655,  676, 1854,
 /*   920 */  1146, 1854, 1145, 1996,  202,  472,  470,  677,   81,  300,
 /*   930 */  1854,  463, 1840, 1532,  457,  456,  455,  454,  451,  450,
 /*   940 */   449,  448,  447,  443,  442,  441,  440,  330,  432,  431,
 /*   950 */   430, 1147,  427,  426,  344,  710,  709,  708,  707,  386,
 /*   960 */    61,  706,  705,  144,  700,  699,  698,  697,  696,  695,
 /*   970 */   694,  156,  690,  689,  688,  385,  384,  685,  684,  683,
 /*   980 */   682,  681, 1673,  389,   38,   37, 1672,  388,   44,   42,
 /*   990 */    41,   40,   39, 1671, 1668, 1667,  626, 1458,  225,  108,
 /*  1000 */   191,  223, 1666, 2136, 1574, 2028, 1609, 1455,   38,   37,
 /*  1010 */   429,   31,   44,   42,   41,   40,   39,   38,   37, 1793,
 /*  1020 */    27,   44,   42,   41,   40,   39, 1996, 1810,  564, 2191,
 /*  1030 */  1996, 1665, 2187, 1664, 1663, 1662, 2046, 1996, 1996, 1996,
 /*  1040 */    80,   79,  418,  152,  643,  189, 1996, 2193,  182, 1996,
 /*  1050 */   626,  642, 2188,  590,  596,  576,  575, 1607, 1608, 1610,
 /*  1060 */  1611, 1612,  152,  329,  444,   51,  404,    3,  402,  398,
 /*  1070 */   394,  391,  411, 2028, 1661, 1996, 1660, 1996, 1996, 1996,
 /*  1080 */  2027, 1810,  152,  146, 2063,  134, 1713,  109, 2029,  646,
 /*  1090 */  2031, 2032,  641, 2028,  636, 1401, 1597,  143, 1577,  149,
 /*  1100 */  2087, 2116,  593,  670, 2046,  370, 2112,  227,  531, 1706,
 /*  1110 */   226,  185,  604,  229,   53,   33,  228, 1996, 1996,  642,
 /*  1120 */  1996,   38,   37,  678, 2046,   44,   42,   41,   40,   39,
 /*  1130 */   231,  533,  643,  230, 1404,   13,   12, 1996,  559,  642,
 /*  1140 */   626,  244,  154,  153,  675,  674,  673,  151, 2027, 1487,
 /*  1150 */   626,  243, 2063, 1439,  445,  109, 2029,  646, 2031, 2032,
 /*  1160 */   641, 1704,  636,  240,  493,   63, 2028,  179, 2027, 2116,
 /*  1170 */   637, 1810, 2063,  370, 2112,  109, 2029,  646, 2031, 2032,
 /*  1180 */   641, 1810,  636,  536,   63,  626,  249, 2207,  626, 2116,
 /*  1190 */    90, 1670,  626,  370, 2112, 2143, 1765, 2046, 2156, 1807,
 /*  1200 */  2028,  626,  237,  105, 2150,  643,  560,  152, 1438,   47,
 /*  1210 */  1996,  274,  642,  102,  262,  605, 1810, 1606,   70, 1810,
 /*  1220 */   150,   38,   37, 1810,  152,   44,   42,   41,   40,   39,
 /*  1230 */   577, 2046, 1810,  626, 2028, 2047, 1605,  218,  251,  643,
 /*  1240 */   626, 2027,  256,  626, 1996, 2063,  642,  609,  109, 2029,
 /*  1250 */   646, 2031, 2032,  641,  281,  636,  387,  623, 1694,  608,
 /*  1260 */  2207, 1365, 2116,  279, 1810, 2046,  370, 2112, 2028,  686,
 /*  1270 */   618, 1810,  283,  643, 1810, 2027, 1246, 2163, 1996, 2063,
 /*  1280 */   642,  597,  109, 2029,  646, 2031, 2032,  641,   63,  636,
 /*  1290 */    47, 1194,   47,  592, 2207, 1917, 2116,  650, 1851, 2046,
 /*  1300 */   370, 2112, 2146, 1442,  150,  602,  390,  643,  626, 2027,
 /*  1310 */   626,  571, 1996, 2063,  642,  152,  109, 2029,  646, 2031,
 /*  1320 */  2032,  641,  624,  636,  383,  261,  687,  594, 2207,  551,
 /*  1330 */  2116, 1700,  135,  150,  370, 2112,  264,    1,    4, 1810,
 /*  1340 */  1548, 1810, 1497, 2027,  299, 2181,  395, 2063, 1192, 1274,
 /*  1350 */   109, 2029,  646, 2031, 2032,  641, 1278,  636, 1441,  342,
 /*  1360 */   373,  372, 2207, 1388, 2116,  195,  294, 1285,  370, 2112,
 /*  1370 */  1444,  424, 1458, 2028,  564, 1430, 1918,  163, 2187, 2135,
 /*  1380 */   728, 1511,  461, 1437, 1283,  155,  428,  433, 1428, 1453,
 /*  1390 */   446, 1910,  460, 2193,  182,  453,  468,  462, 2188,  590,
 /*  1400 */  2028,  469,  199,  471, 2046,  473, 1506, 1459,  474,  483,
 /*  1410 */  1461, 1456,  643,  205,  487,  207,  486, 1996, 1436,  642,
 /*  1420 */  1460,  488, 1462, 1436,  489,  210,  550,  491,  212,   84,
 /*  1430 */    85, 2046, 2028,  495,  216, 1149,  514,  512,  513,  643,
 /*  1440 */   516, 1800, 1972,  238, 1996,  552,  642,  332, 2027, 1971,
 /*  1450 */   222,  112, 2063, 1796,  224,  109, 2029,  646, 2031, 2032,
 /*  1460 */   641,  157,  636, 2046, 2028,  632,  158, 2091, 1798, 2116,
 /*  1470 */   733,  643, 1794,  370, 2112, 2027, 1996,  159,  642, 2063,
 /*  1480 */    88,  160,  109, 2029,  646, 2031, 2032,  641,  554,  636,
 /*  1490 */   241,  561, 2147,  558, 2089, 2046, 2116,  568,  295,  578,
 /*  1500 */   370, 2112, 2157,  643, 2162,  148,  616, 2027, 1996, 2161,
 /*  1510 */   642, 2063,  574,  247,  169, 2029,  646, 2031, 2032,  641,
 /*  1520 */   555,  636,  250,  359,  581,    7,  566,  567,  587, 2138,
 /*  1530 */   569, 1445,  260, 1440, 2186,  598, 1431, 2028, 1429, 2027,
 /*  1540 */   360, 2210,  595, 2063, 1574,  258,  109, 2029,  646, 2031,
 /*  1550 */  2032,  641,  363,  636,  172,  139, 1448, 1450,  629,  257,
 /*  1560 */  2116, 1434, 1435, 1457,  370, 2112, 2132, 2209, 2046,  634,
 /*  1570 */  1504, 1505, 1507, 1508, 1509, 1510,  643,  255,  606,  269,
 /*  1580 */    95, 1996,  259,  642, 1463, 1923,  263,  619,  296,  614,
 /*  1590 */   615, 1937, 1936, 1935,  297,  366,  620, 2028,   97,  298,
 /*  1600 */    99, 1811,   60,  101,  648, 2097, 1781, 1855,  301,  729,
 /*  1610 */   730,  290, 2027,  732,  334,  335, 2063, 2028, 1988,  110,
 /*  1620 */  2029,  646, 2031, 2032,  641,   50,  636,  325, 2046,  310,
 /*  1630 */   305,  324, 1987, 2116,  314,  303,  643, 2115, 2112, 1986,
 /*  1640 */    77, 1996, 1983,  642,  392,  393, 1421, 1422, 2046,  188,
 /*  1650 */   397, 1981,  399,  401,  400, 1980,  643,  403, 1979,  405,
 /*  1660 */  1978, 1996,  407,  642, 1977,  409,   78, 1391, 1390, 1949,
 /*  1670 */  1948, 1947, 2027,  416,  417, 1946, 2063, 2028, 1342,  110,
 /*  1680 */  2029,  646, 2031, 2032,  641, 1945,  636, 1901, 1900, 1898,
 /*  1690 */   145, 1897,  644, 2116,  434,  193, 2063,  631, 2112,  110,
 /*  1700 */  2029,  646, 2031, 2032,  641, 2028,  636, 1896, 2046, 1899,
 /*  1710 */  1895, 1894, 1892, 2116, 1891, 1890,  643,  337, 2112, 1889,
 /*  1720 */   436, 1996, 1903,  642, 1888, 1887, 1886, 1885, 1884, 1883,
 /*  1730 */  1882, 1881, 1880, 1879, 1878, 1877, 2046, 1876, 1875, 1874,
 /*  1740 */   147, 1873, 1872, 1871,  643, 1902, 1870, 1869, 1868, 1996,
 /*  1750 */  1867,  642, 2027, 1866, 1865,  464, 2063, 1864, 1344,  110,
 /*  1760 */  2029,  646, 2031, 2032,  641, 1728,  636, 1727, 1725, 1689,
 /*  1770 */  2016, 2028, 1168, 2116,  200, 1221,  201, 1135, 2113, 1688,
 /*  1780 */  2027, 1962, 1956, 1944, 2063, 1134,  203,  316, 2029,  646,
 /*  1790 */  2031, 2032,  641,  177,  636, 2028,  204,   75,  479,  481,
 /*  1800 */    76,  209, 2046, 1943, 1921, 1789, 1724,  365,  211, 1722,
 /*  1810 */   643,  496,  497,  498, 1720, 1996,  502,  642,  501,  500,
 /*  1820 */  1718,  504, 1716,  505,  506,  508, 2046, 1703,  509, 1702,
 /*  1830 */   736,  586,  510, 1685,  640, 1791, 1290, 1289, 1790, 1996,
 /*  1840 */   701,  642, 1212, 1211,  293, 1210, 2027, 1209, 1206, 1714,
 /*  1850 */  2063, 1205, 1204,  323, 2029,  646, 2031, 2032,  641,  175,
 /*  1860 */   636,  221,  703, 2028,   62,  726,  722,  718,  714,  291,
 /*  1870 */  2027, 1203,  351, 1707, 2063,  352,  534,  322, 2029,  646,
 /*  1880 */  2031, 2032,  641, 2028,  636, 1705, 2082,  353, 1684,  537,
 /*  1890 */   539, 1683,  541, 1682, 2046,  111,  543, 1411, 1410,  375,
 /*  1900 */   547, 1961,  643, 1397, 1955,  107,  162, 1996,  284,  642,
 /*  1910 */  1942,  556, 1940, 1413, 2046,   19,   26, 2192,   66,  377,
 /*  1920 */    28,  242,  643,   16, 1622,  570,  246, 1996,  572,  642,
 /*  1930 */    55,   58,   20,  248,   59, 1604,  170,  557, 2027,  252,
 /*  1940 */   253,  622, 2063,   29, 2028,  323, 2029,  646, 2031, 2032,
 /*  1950 */   641,  356,  636,  254, 1596, 2017,   91,   30, 2027,   64,
 /*  1960 */  2028,  562, 2063,    5,   21,  323, 2029,  646, 2031, 2032,
 /*  1970 */   641,    6,  636, 1642, 1643, 2046,  271, 1571, 1637, 1636,
 /*  1980 */   361,  270, 1641,  643, 1640,  362,  266,  173, 1996, 1941,
 /*  1990 */   642, 2046,   57, 1570, 1939, 1938, 1920,   93, 1395,  643,
 /*  2000 */   239,   94,  272,  273, 1996, 1602,  642,  617, 1919, 2028,
 /*  2010 */    22,  275,  280,   67,   96,  285,  282,   98,   23,  549,
 /*  2020 */    12, 1446,   56, 2063,  102, 2028,  318, 2029,  646, 2031,
 /*  2030 */  2032,  641, 1533,  636, 1501, 2027, 2066,  174, 1478, 2063,
 /*  2040 */  2046,   17,  307, 2029,  646, 2031, 2032,  641,  643,  636,
 /*  2050 */    10,  186,  635, 1996, 1499,  642, 2046, 1498,   36,   15,
 /*  2060 */    24, 1523, 1470, 1522,  643,   25,  645, 1275,  649, 1996,
 /*  2070 */   378,  642,  651,  647, 1272,  654,  653, 1269,  656,  657,
 /*  2080 */   659, 1263,  660,  662, 2027, 1252,  669,  663, 2063, 1261,
 /*  2090 */   288,  308, 2029,  646, 2031, 2032,  641,  103,  636, 1284,
 /*  2100 */  2027, 1267, 1266, 2028, 2063, 1265,  104,  309, 2029,  646,
 /*  2110 */  2031, 2032,  641, 1280,  636,   74, 1264, 1166,  679, 2028,
 /*  2120 */  1200, 1199, 1198, 1197, 1196, 1195,  691, 1193, 1191, 1190,
 /*  2130 */  1189, 1219, 1187, 1186, 2046, 1185, 1184, 1183, 1182, 1181,
 /*  2140 */   289, 1216,  643, 1214, 1178, 1177, 1174, 1996, 1173,  642,
 /*  2150 */  2046, 1172, 1171, 1721,  711,  712, 1719,  713,  643,  715,
 /*  2160 */   716,  717, 1717, 1996,  720,  642,  719,  721, 1715,  723,
 /*  2170 */  1701,  724,  725,  727, 1124, 1681, 2028,  292, 2027,  731,
 /*  2180 */   735, 1432, 2063,  302,  734,  315, 2029,  646, 2031, 2032,
 /*  2190 */   641, 1656,  636, 1656, 2027, 2028, 1656, 1656, 2063, 1656,
 /*  2200 */  1656,  319, 2029,  646, 2031, 2032,  641, 2046,  636, 1656,
 /*  2210 */  1656, 1656, 1656, 1656, 1656,  643, 1656, 1656, 1656, 1656,
 /*  2220 */  1996, 1656,  642, 1656, 1656, 1656, 2046, 1656, 1656, 1656,
 /*  2230 */  1656, 1656, 1656, 1656,  643, 1656, 1656, 1656, 1656, 1996,
 /*  2240 */  1656,  642, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2250 */  1656, 2027, 1656, 1656, 2028, 2063, 1656, 1656,  311, 2029,
 /*  2260 */   646, 2031, 2032,  641, 1656,  636, 1656, 1656, 1656, 1656,
 /*  2270 */  2027, 1656, 1656, 2028, 2063, 1656, 1656,  320, 2029,  646,
 /*  2280 */  2031, 2032,  641, 1656,  636, 2046, 1656, 1656, 1656, 1656,
 /*  2290 */  1656, 1656, 1656,  643, 1656, 1656, 1656, 1656, 1996, 1656,
 /*  2300 */   642, 1656, 1656, 1656, 2046, 1656, 1656, 1656, 1656, 1656,
 /*  2310 */  1656, 1656,  643, 1656, 1656, 1656, 1656, 1996, 1656,  642,
 /*  2320 */  1656, 1656, 2028, 1656, 1656, 1656, 1656, 1656, 1656, 2027,
 /*  2330 */  1656, 1656, 1656, 2063, 1656, 1656,  312, 2029,  646, 2031,
 /*  2340 */  2032,  641, 1656,  636, 1656, 1656, 1656, 1656, 2027, 1656,
 /*  2350 */  1656, 1656, 2063, 2046, 1656,  321, 2029,  646, 2031, 2032,
 /*  2360 */   641,  643,  636, 1656, 1656, 1656, 1996, 1656,  642, 1656,
 /*  2370 */  1656, 2028, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2380 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 2028, 1656, 1656,
 /*  2390 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 2027, 1656, 1656,
 /*  2400 */  1656, 2063, 2046, 2028,  313, 2029,  646, 2031, 2032,  641,
 /*  2410 */   643,  636, 1656, 1656, 1656, 1996, 1656,  642, 2046, 1656,
 /*  2420 */  1656, 1656, 1656, 1656, 1656, 1656,  643, 1656, 1656, 1656,
 /*  2430 */  1656, 1996, 1656,  642, 2046, 1656, 1656, 1656, 1656, 1656,
 /*  2440 */  1656, 1656,  643, 1656, 1656, 1656, 2027, 1996, 1656,  642,
 /*  2450 */  2063, 1656, 1656,  326, 2029,  646, 2031, 2032,  641, 1656,
 /*  2460 */   636, 1656, 2027, 1656, 1656, 1656, 2063, 1656, 1656,  327,
 /*  2470 */  2029,  646, 2031, 2032,  641, 1656,  636, 1656, 2027, 2028,
 /*  2480 */  1656, 1656, 2063, 1656, 1656, 2040, 2029,  646, 2031, 2032,
 /*  2490 */   641, 1656,  636, 1656, 1656, 2028, 1656, 1656, 1656, 1656,
 /*  2500 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2510 */  2046, 1656, 1656, 1656, 1656, 1656, 1656, 1656,  643, 1656,
 /*  2520 */  1656, 1656, 1656, 1996, 1656,  642, 2046, 1656, 1656, 1656,
 /*  2530 */  1656, 1656, 1656, 1656,  643, 1656, 1656, 1656, 1656, 1996,
 /*  2540 */  1656,  642, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2550 */  1656, 1656, 2028, 1656, 2027, 1656, 1656, 1656, 2063, 1656,
 /*  2560 */  1656, 2039, 2029,  646, 2031, 2032,  641, 1656,  636, 1656,
 /*  2570 */  2027, 2028, 1656, 1656, 2063, 1656, 1656, 2038, 2029,  646,
 /*  2580 */  2031, 2032,  641, 2046,  636, 1656, 1656, 1656, 1656, 1656,
 /*  2590 */  1656,  643, 1656, 1656, 1656, 1656, 1996, 1656,  642, 1656,
 /*  2600 */  1656, 1656, 2046, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2610 */   643, 1656, 1656, 1656, 1656, 1996, 1656,  642, 1656, 1656,
 /*  2620 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 2027, 1656, 1656,
 /*  2630 */  2028, 2063, 1656, 1656,  339, 2029,  646, 2031, 2032,  641,
 /*  2640 */  1656,  636, 1656, 1656, 1656, 1656, 2027, 1656, 1656, 2028,
 /*  2650 */  2063, 1656, 1656,  340, 2029,  646, 2031, 2032,  641, 1656,
 /*  2660 */   636, 2046, 1656, 1656, 1656, 1656, 1656, 1656, 1656,  643,
 /*  2670 */  1656, 1656, 1656, 1656, 1996, 1656,  642, 1656, 1656, 1656,
 /*  2680 */  2046, 1656, 1656, 1656, 1656, 1656, 1656, 1656,  643, 1656,
 /*  2690 */  1656, 1656, 1656, 1996, 1656,  642, 1656, 1656, 2028, 1656,
 /*  2700 */  1656, 1656, 1656, 1656, 1656, 2027, 1656, 1656, 1656, 2063,
 /*  2710 */  1656, 1656,  336, 2029,  646, 2031, 2032,  641, 1656,  636,
 /*  2720 */  1656, 1656, 1656, 1656, 2027, 1656, 1656, 1656, 2063, 2046,
 /*  2730 */  1656,  341, 2029,  646, 2031, 2032,  641,  643,  636, 1656,
 /*  2740 */  1656, 1656, 1996, 1656,  642, 1656, 1656, 2028, 1656, 1656,
 /*  2750 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2760 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2770 */  1656, 1656, 1656,  644, 1656, 1656, 1656, 2063, 2046, 1656,
 /*  2780 */   318, 2029,  646, 2031, 2032,  641,  643,  636, 1656, 1656,
 /*  2790 */  1656, 1996, 1656,  642, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2800 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2810 */  1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656, 1656,
 /*  2820 */  1656, 1656, 2027, 1656, 1656, 1656, 2063, 1656, 1656,  317,
 /*  2830 */  2029,  646, 2031, 2032,  641, 1656,  636,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   335,  331,  337,  338,    0,  439,  363,  394,  364,  443,
 /*    10 */   363,  362,   12,   13,   14,   14,  377,  362,  369,  375,
 /*    20 */    20,   20,   22,  364,  458,  459,  339,  378,  389,  463,
 /*    30 */   464,  392,  393,   33,  375,   35,  331,  439,  383,  384,
 /*    40 */   364,  443,    8,    9,  377,  375,   12,   13,   14,   15,
 /*    50 */    16,  375,  439,  409,  410,  411,  443,  459,   58,  392,
 /*    60 */   393,  463,  464,   63,  420,  361,  379,  362,  409,  410,
 /*    70 */    70,  458,  459,  354,  339,  370,  463,  464,  374,  420,
 /*    80 */   375,  362,  377,   12,   13,  409,  410,  411,  439,   20,
 /*    90 */   371,   20,  443,   22,  362,   95,  420,   63,   12,   13,
 /*   100 */    14,   15,   16,  371,   33,  370,   35,  458,  459,  428,
 /*   110 */   429,  406,  463,  464,  330,  410,  332,  117,  413,  414,
 /*   120 */   415,  416,  417,  418,  419,  420,  421,  422,   58,   58,
 /*   130 */    39,  364,  132,  133,   63,    0,  373,  394,  104,  376,
 /*   140 */   377,   70,  375,   20,  108,  109,  110,  111,  112,  113,
 /*   150 */   114,  115,  116,  117,  118,  151,  120,  121,  122,  123,
 /*   160 */   124,  125,  162,  163,  160,   95,   95,   97,  168,  169,
 /*   170 */   435,  436,  437,   14,  439,  440,  409,  410,  443,   20,
 /*   180 */   376,  377,  439,  183,  362,  185,  443,  420,  117,   37,
 /*   190 */     4,  369,   20,  458,  459,  161,   95,   62,  463,  464,
 /*   200 */   378,  458,  459,  132,  133,  346,  463,  464,  208,  209,
 /*   210 */   351,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   43,
 /*   230 */    20,   45,   46,  162,  163,   62,   95,  345,   21,  168,
 /*   240 */   169,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   250 */    98,  359,  100,  101,  183,  103,  185,    8,    9,  107,
 /*   260 */   368,   12,   13,   14,   15,   16,   20,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,   20,  208,
 /*   280 */   209,  129,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   300 */   354,  230,   12,   13,  132,  133,  362,   33,  362,  339,
 /*   310 */    20,  362,   22,    0,  370,  369,  246,  371,  369,   62,
 /*   320 */   339,  162,   48,   33,  378,   35,  331,  378,   54,   55,
 /*   330 */    56,   57,   58,  394,   21,    4,  245,   24,   25,   26,
 /*   340 */    27,   28,   29,   30,   31,   32,   20,  246,   58,   95,
 /*   350 */    19,  370,  335,   63,  337,  338,  386,  362,  388,  415,
 /*   360 */    70,   20,  331,   22,   33,  370,  127,  412,   94,  354,
 /*   370 */   375,   97,  377,   12,   13,   14,   35,  362,  439,   48,
 /*   380 */   167,   20,  443,   22,   53,   95,  371,  246,  362,   58,
 /*   390 */   132,  133,   51,  438,   33,  369,   35,  458,  459,    4,
 /*   400 */    20,  406,  463,  464,  378,  410,  375,  117,  413,  414,
 /*   410 */   415,  416,  417,  418,  106,  420,  435,  436,  437,   58,
 /*   420 */   439,  440,  132,  133,  175,   94,  168,  169,   97,  190,
 /*   430 */   191,   70,  343,  194,  354,  196,  182,  339,  184,  165,
 /*   440 */   166,  339,  362,    0,  170,  412,  339,  173,  339,  454,
 /*   450 */   455,  371,  162,  163,  365,  353,   95,    0,  168,  169,
 /*   460 */   353,  207,  360,  189,  251,  252,  253,  360,  370,  345,
 /*   470 */    20,  438,  370,  183,    0,  185,  336,  370,  117,  339,
 /*   480 */   340,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   490 */    95,   48,  368,  132,  133,  386,  339,  388,  208,  209,
 /*   500 */   246,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   510 */   220,  221,  222,  223,  224,  225,  226,  227,  228,    3,
 /*   520 */   331,  272,   14,  162,  163,    0,   20,  370,   20,  168,
 /*   530 */   169,  362,  434,  435,  436,  437,   20,  439,  440,   65,
 /*   540 */    66,   67,  162,  163,  183,   95,  185,   73,   74,  362,
 /*   550 */    20,  362,   78,  384,    1,    2,  369,   83,   84,  370,
 /*   560 */   230,  339,  232,   89,  375,  378,  377,  348,  349,  208,
 /*   570 */   209,  331,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   580 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   590 */    12,   13,  435,  436,  437,  406,  439,  440,   20,  410,
 /*   600 */    22,   95,  413,  414,  415,  416,  417,  418,  386,  420,
 /*   610 */   388,   33,   96,   35,  425,  375,  427,  362,   79,  331,
 /*   620 */   431,  432,   35,    8,    9,   95,  230,   12,   13,   14,
 /*   630 */    15,   16,  107,  378,  445,   20,   58,  331,  178,    8,
 /*   640 */     9,  246,  453,   12,   13,   14,   15,   16,   70,   96,
 /*   650 */   362,  126,  127,  128,  129,  130,  131,   70,  370,  199,
 /*   660 */   200,   12,   13,  375,   20,  377,  161,  364,  439,   20,
 /*   670 */   162,   22,  443,   95,  412,    0,  137,  138,  375,   58,
 /*   680 */   164,  375,   33,  126,   35,  331,  336,  394,  459,  339,
 /*   690 */   340,  398,  463,  464,  406,  117,  246,   47,  410,  160,
 /*   700 */   438,  413,  414,  415,  416,  417,  418,   58,  420,    0,
 /*   710 */   132,  133,  409,  410,  411,   94,  362,  107,   97,   70,
 /*   720 */   424,  343,  426,  420,  370,  126,  127,   96,  339,  375,
 /*   730 */   131,  377,  439,  106,  331,  357,  443,   62,  233,  129,
 /*   740 */   162,  163,  353,  365,   95,   95,  168,  169,  243,  192,
 /*   750 */   193,  458,  459,  465,  466,  423,  463,  464,  426,  370,
 /*   760 */   406,  183,   21,  185,  410,   70,  117,  413,  414,  415,
 /*   770 */   416,  417,  418,  164,  420,   34,  246,   36,  375,  164,
 /*   780 */   171,  132,  133,   14,   15,   16,  208,  209,   63,  211,
 /*   790 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   800 */   222,  223,  224,  225,  226,  227,  228,   22,  164,  455,
 /*   810 */   339,  162,  163,   18,   35,   20,  107,  168,  169,  370,
 /*   820 */    35,  424,   27,  426,  353,   30,  348,  349,   33,  350,
 /*   830 */   381,  352,  183,  370,  185,  126,  127,  128,  129,  130,
 /*   840 */   131,  370,  331,   48,  381,   50,    8,    9,   53,   70,
 /*   850 */    12,   13,   14,   15,   16,    4,   20,  208,  209,  358,
 /*   860 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   870 */   221,  222,  223,  224,  225,  226,  227,  228,  106,  331,
 /*   880 */   339,  339,  339,   18,   45,   46,  375,  370,   23,   94,
 /*   890 */     0,   65,   66,   67,  353,  353,  353,   70,  381,   73,
 /*   900 */    74,  106,   37,   38,   78,  404,   41,  132,  133,   83,
 /*   910 */    84,  370,  370,  370,  363,   89,  372,  328,  372,  375,
 /*   920 */    20,  375,   22,  375,   59,   60,   61,  372,  156,  355,
 /*   930 */   375,  136,  358,  208,  139,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,   51,  157,  158,  159,   65,   66,   67,   68,   69,
 /*   960 */    95,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   970 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   980 */    90,   91,  331,  394,    8,    9,  331,  398,   12,   13,
 /*   990 */    14,   15,   16,  331,  331,  331,  339,   20,   99,  134,
 /*  1000 */   164,  102,  331,  244,  245,  331,  208,   20,    8,    9,
 /*  1010 */   353,    2,   12,   13,   14,   15,   16,    8,    9,  363,
 /*  1020 */    44,   12,   13,   14,   15,   16,  375,  370,  439,    3,
 /*  1030 */   375,  331,  443,  331,  331,  331,  362,  375,  375,  375,
 /*  1040 */   175,  176,  177,   44,  370,  180,  375,  458,  459,  375,
 /*  1050 */   339,  377,  463,  464,   44,  257,  258,  259,  260,  261,
 /*  1060 */   262,  263,   44,  198,  353,   42,  201,   44,  203,  204,
 /*  1070 */   205,  206,  207,  331,  331,  375,  331,  375,  375,  375,
 /*  1080 */   406,  370,   44,   42,  410,   44,    0,  413,  414,  415,
 /*  1090 */   416,  417,  418,  331,  420,   96,   96,  423,  247,  425,
 /*  1100 */   426,  427,   44,  363,  362,  431,  432,   99,   22,    0,
 /*  1110 */   102,  246,  370,   99,   96,    2,  102,  375,  375,  377,
 /*  1120 */   375,    8,    9,  107,  362,   12,   13,   14,   15,   16,
 /*  1130 */    99,   22,  370,  102,   96,    1,    2,  375,  399,  377,
 /*  1140 */   339,  164,  126,  127,  128,  129,  130,  131,  406,  162,
 /*  1150 */   339,   58,  410,   35,  353,  413,  414,  415,  416,  417,
 /*  1160 */   418,    0,  420,  363,  353,   44,  331,  425,  406,  427,
 /*  1170 */   363,  370,  410,  431,  432,  413,  414,  415,  416,  417,
 /*  1180 */   418,  370,  420,   22,   44,  339,   44,  425,  339,  427,
 /*  1190 */    97,  332,  339,  431,  432,  453,  351,  362,  385,  353,
 /*  1200 */   331,  339,  353,   95,  442,  370,  353,   44,   35,   44,
 /*  1210 */   375,   44,  377,  105,  467,  353,  370,   96,   44,  370,
 /*  1220 */    44,    8,    9,  370,   44,   12,   13,   14,   15,   16,
 /*  1230 */   456,  362,  370,  339,  331,  362,   96,  341,   96,  370,
 /*  1240 */   339,  406,  450,  339,  375,  410,  377,  353,  413,  414,
 /*  1250 */   415,  416,  417,  418,  353,  420,  341,  353,  338,   96,
 /*  1260 */   425,   96,  427,   96,  370,  362,  431,  432,  331,   13,
 /*  1270 */    96,  370,   96,  370,  370,  406,   96,  442,  375,  410,
 /*  1280 */   377,  271,  413,  414,  415,  416,  417,  418,   44,  420,
 /*  1290 */    44,   35,   44,  267,  425,  385,  427,   44,  374,  362,
 /*  1300 */   431,  432,  385,  185,   44,  441,  408,  370,  339,  406,
 /*  1310 */   339,  442,  375,  410,  377,   44,  413,  414,  415,  416,
 /*  1320 */   417,  418,  353,  420,  353,  433,   13,  269,  425,  394,
 /*  1330 */   427,    0,   44,   44,  431,  432,  460,  444,  248,  370,
 /*  1340 */    96,  370,   96,  406,   96,  442,   48,  410,   35,   96,
 /*  1350 */   413,  414,  415,  416,  417,  418,   96,  420,  185,  407,
 /*  1360 */    12,   13,  425,  181,  427,   42,  396,   96,  431,  432,
 /*  1370 */    22,  382,   20,  331,  439,   22,  385,  164,  443,  442,
 /*  1380 */    49,   33,  161,   35,   96,   96,  382,  380,   35,   20,
 /*  1390 */   339,  339,  380,  458,  459,  382,   93,  380,  463,  464,
 /*  1400 */   331,  347,  339,  339,  362,  339,   58,   20,  333,  333,
 /*  1410 */    20,   20,  370,  345,  377,  345,  401,  375,   70,  377,
 /*  1420 */    20,  340,   20,   70,  395,  345,  197,  340,  345,  345,
 /*  1430 */   345,  362,  331,  339,  345,   52,  333,  342,  342,  370,
 /*  1440 */   362,  362,  375,  343,  375,  405,  377,  333,  406,  375,
 /*  1450 */   362,  339,  410,  362,  362,  413,  414,  415,  416,  417,
 /*  1460 */   418,  362,  420,  362,  331,  117,  362,  425,  362,  427,
 /*  1470 */   117,  370,  362,  431,  432,  406,  375,  362,  377,  410,
 /*  1480 */    95,  362,  413,  414,  415,  416,  417,  418,  188,  420,
 /*  1490 */   343,  339,  385,  377,  425,  362,  427,  375,  401,  256,
 /*  1500 */   431,  432,  385,  370,  449,  403,  255,  406,  375,  449,
 /*  1510 */   377,  410,  375,  390,  413,  414,  415,  416,  417,  418,
 /*  1520 */   400,  420,  390,  375,  375,  264,  249,  265,  174,  452,
 /*  1530 */   266,  183,  408,  185,  462,  270,  183,  331,  185,  406,
 /*  1540 */   273,  468,  268,  410,  245,  447,  413,  414,  415,  416,
 /*  1550 */   417,  418,  340,  420,  449,  370,  208,  209,  425,  448,
 /*  1560 */   427,  208,  209,   20,  431,  432,  412,  466,  362,  221,
 /*  1570 */   222,  223,  224,  225,  226,  227,  370,  451,  339,  343,
 /*  1580 */   343,  375,  446,  377,   20,  388,  461,  166,  390,  375,
 /*  1590 */   375,  375,  375,  375,  390,  375,  387,  331,  343,  358,
 /*  1600 */   343,  370,   95,   95,  366,  430,  352,  375,  339,   36,
 /*  1610 */   334,  343,  406,  333,  391,  391,  410,  331,    0,  413,
 /*  1620 */   414,  415,  416,  417,  418,  397,  420,  402,  362,  356,
 /*  1630 */   329,  356,    0,  427,  356,  344,  370,  431,  432,    0,
 /*  1640 */    42,  375,    0,  377,   35,  202,   35,   35,  362,   35,
 /*  1650 */   202,    0,   35,  202,   35,    0,  370,  202,    0,   35,
 /*  1660 */     0,  375,   22,  377,    0,   35,  190,  185,  183,    0,
 /*  1670 */     0,    0,  406,  179,  178,    0,  410,  331,   47,  413,
 /*  1680 */   414,  415,  416,  417,  418,    0,  420,    0,    0,    0,
 /*  1690 */    42,    0,  406,  427,   35,  151,  410,  431,  432,  413,
 /*  1700 */   414,  415,  416,  417,  418,  331,  420,    0,  362,    0,
 /*  1710 */     0,    0,    0,  427,    0,    0,  370,  431,  432,    0,
 /*  1720 */   151,  375,    0,  377,    0,    0,    0,    0,    0,    0,
 /*  1730 */     0,    0,    0,    0,    0,    0,  362,    0,    0,    0,
 /*  1740 */    42,    0,    0,    0,  370,    0,    0,    0,    0,  375,
 /*  1750 */     0,  377,  406,    0,    0,  135,  410,    0,   22,  413,
 /*  1760 */   414,  415,  416,  417,  418,    0,  420,    0,    0,    0,
 /*  1770 */    47,  331,   64,  427,   58,   35,   58,   14,  432,    0,
 /*  1780 */   406,    0,    0,    0,  410,   14,   42,  413,  414,  415,
 /*  1790 */   416,  417,  418,   44,  420,  331,   40,   39,   47,   47,
 /*  1800 */    39,   39,  362,    0,    0,    0,    0,  367,  174,    0,
 /*  1810 */   370,   35,   48,   39,    0,  375,   39,  377,   48,   35,
 /*  1820 */     0,   35,    0,   48,   39,   35,  362,    0,   48,    0,
 /*  1830 */    19,  457,   39,    0,  370,    0,   35,   22,    0,  375,
 /*  1840 */    44,  377,   35,   35,   33,   35,  406,   35,   35,    0,
 /*  1850 */   410,   35,   22,  413,  414,  415,  416,  417,  418,   48,
 /*  1860 */   420,  102,   44,  331,  104,   54,   55,   56,   57,   58,
 /*  1870 */   406,   35,   22,    0,  410,   22,   50,  413,  414,  415,
 /*  1880 */   416,  417,  418,  331,  420,    0,  422,   22,    0,   35,
 /*  1890 */    35,    0,   35,    0,  362,   20,   22,   35,   35,  367,
 /*  1900 */   195,    0,  370,   35,    0,   94,  186,  375,   97,  377,
 /*  1910 */     0,   22,    0,   96,  362,   44,   95,    3,   95,  367,
 /*  1920 */    95,  166,  370,  250,   96,  229,   95,  375,  254,  377,
 /*  1930 */   164,   44,  250,   96,   44,   96,   95,  164,  406,   95,
 /*  1940 */    44,  130,  410,   95,  331,  413,  414,  415,  416,  417,
 /*  1950 */   418,  164,  420,   47,   96,   47,   95,   44,  406,    3,
 /*  1960 */   331,  172,  410,  171,   44,  413,  414,  415,  416,  417,
 /*  1970 */   418,  171,  420,   96,   96,  362,  165,   96,   35,   35,
 /*  1980 */    35,  170,   35,  370,   35,   35,   47,   47,  375,    0,
 /*  1990 */   377,  362,   44,   96,    0,    0,    0,   95,  187,  370,
 /*  2000 */   189,   39,   47,   96,  375,   96,  377,  167,    0,  331,
 /*  2010 */    95,   95,   95,   95,   39,   47,  165,   95,   44,  406,
 /*  2020 */     2,   22,  244,  410,  105,  331,  413,  414,  415,  416,
 /*  2030 */   417,  418,  208,  420,   96,  406,   95,   47,   22,  410,
 /*  2040 */   362,  250,  413,  414,  415,  416,  417,  418,  370,  420,
 /*  2050 */   231,   47,   95,  375,   96,  377,  362,   96,   95,   95,
 /*  2060 */    95,  229,   96,  229,  370,   95,  210,   96,   35,  375,
 /*  2070 */    35,  377,   95,  106,   96,   95,   35,   96,   35,   95,
 /*  2080 */    35,   96,   95,   35,  406,   22,  107,   95,  410,   96,
 /*  2090 */    44,  413,  414,  415,  416,  417,  418,   95,  420,   35,
 /*  2100 */   406,  119,  119,  331,  410,  119,   95,  413,  414,  415,
 /*  2110 */   416,  417,  418,   22,  420,   95,  119,   64,   63,  331,
 /*  2120 */    35,   35,   35,   35,   35,   35,   92,   35,   35,   35,
 /*  2130 */    35,   70,   35,   35,  362,   35,   22,   35,   35,   35,
 /*  2140 */    44,   70,  370,   35,   35,   35,   35,  375,   35,  377,
 /*  2150 */   362,   22,   35,    0,   35,   48,    0,   39,  370,   35,
 /*  2160 */    48,   39,    0,  375,   48,  377,   35,   39,    0,   35,
 /*  2170 */     0,   48,   39,   35,   35,    0,  331,   22,  406,   21,
 /*  2180 */    20,   22,  410,   22,   21,  413,  414,  415,  416,  417,
 /*  2190 */   418,  469,  420,  469,  406,  331,  469,  469,  410,  469,
 /*  2200 */   469,  413,  414,  415,  416,  417,  418,  362,  420,  469,
 /*  2210 */   469,  469,  469,  469,  469,  370,  469,  469,  469,  469,
 /*  2220 */   375,  469,  377,  469,  469,  469,  362,  469,  469,  469,
 /*  2230 */   469,  469,  469,  469,  370,  469,  469,  469,  469,  375,
 /*  2240 */   469,  377,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2250 */   469,  406,  469,  469,  331,  410,  469,  469,  413,  414,
 /*  2260 */   415,  416,  417,  418,  469,  420,  469,  469,  469,  469,
 /*  2270 */   406,  469,  469,  331,  410,  469,  469,  413,  414,  415,
 /*  2280 */   416,  417,  418,  469,  420,  362,  469,  469,  469,  469,
 /*  2290 */   469,  469,  469,  370,  469,  469,  469,  469,  375,  469,
 /*  2300 */   377,  469,  469,  469,  362,  469,  469,  469,  469,  469,
 /*  2310 */   469,  469,  370,  469,  469,  469,  469,  375,  469,  377,
 /*  2320 */   469,  469,  331,  469,  469,  469,  469,  469,  469,  406,
 /*  2330 */   469,  469,  469,  410,  469,  469,  413,  414,  415,  416,
 /*  2340 */   417,  418,  469,  420,  469,  469,  469,  469,  406,  469,
 /*  2350 */   469,  469,  410,  362,  469,  413,  414,  415,  416,  417,
 /*  2360 */   418,  370,  420,  469,  469,  469,  375,  469,  377,  469,
 /*  2370 */   469,  331,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2380 */   469,  469,  469,  469,  469,  469,  469,  331,  469,  469,
 /*  2390 */   469,  469,  469,  469,  469,  469,  469,  406,  469,  469,
 /*  2400 */   469,  410,  362,  331,  413,  414,  415,  416,  417,  418,
 /*  2410 */   370,  420,  469,  469,  469,  375,  469,  377,  362,  469,
 /*  2420 */   469,  469,  469,  469,  469,  469,  370,  469,  469,  469,
 /*  2430 */   469,  375,  469,  377,  362,  469,  469,  469,  469,  469,
 /*  2440 */   469,  469,  370,  469,  469,  469,  406,  375,  469,  377,
 /*  2450 */   410,  469,  469,  413,  414,  415,  416,  417,  418,  469,
 /*  2460 */   420,  469,  406,  469,  469,  469,  410,  469,  469,  413,
 /*  2470 */   414,  415,  416,  417,  418,  469,  420,  469,  406,  331,
 /*  2480 */   469,  469,  410,  469,  469,  413,  414,  415,  416,  417,
 /*  2490 */   418,  469,  420,  469,  469,  331,  469,  469,  469,  469,
 /*  2500 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2510 */   362,  469,  469,  469,  469,  469,  469,  469,  370,  469,
 /*  2520 */   469,  469,  469,  375,  469,  377,  362,  469,  469,  469,
 /*  2530 */   469,  469,  469,  469,  370,  469,  469,  469,  469,  375,
 /*  2540 */   469,  377,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2550 */   469,  469,  331,  469,  406,  469,  469,  469,  410,  469,
 /*  2560 */   469,  413,  414,  415,  416,  417,  418,  469,  420,  469,
 /*  2570 */   406,  331,  469,  469,  410,  469,  469,  413,  414,  415,
 /*  2580 */   416,  417,  418,  362,  420,  469,  469,  469,  469,  469,
 /*  2590 */   469,  370,  469,  469,  469,  469,  375,  469,  377,  469,
 /*  2600 */   469,  469,  362,  469,  469,  469,  469,  469,  469,  469,
 /*  2610 */   370,  469,  469,  469,  469,  375,  469,  377,  469,  469,
 /*  2620 */   469,  469,  469,  469,  469,  469,  469,  406,  469,  469,
 /*  2630 */   331,  410,  469,  469,  413,  414,  415,  416,  417,  418,
 /*  2640 */   469,  420,  469,  469,  469,  469,  406,  469,  469,  331,
 /*  2650 */   410,  469,  469,  413,  414,  415,  416,  417,  418,  469,
 /*  2660 */   420,  362,  469,  469,  469,  469,  469,  469,  469,  370,
 /*  2670 */   469,  469,  469,  469,  375,  469,  377,  469,  469,  469,
 /*  2680 */   362,  469,  469,  469,  469,  469,  469,  469,  370,  469,
 /*  2690 */   469,  469,  469,  375,  469,  377,  469,  469,  331,  469,
 /*  2700 */   469,  469,  469,  469,  469,  406,  469,  469,  469,  410,
 /*  2710 */   469,  469,  413,  414,  415,  416,  417,  418,  469,  420,
 /*  2720 */   469,  469,  469,  469,  406,  469,  469,  469,  410,  362,
 /*  2730 */   469,  413,  414,  415,  416,  417,  418,  370,  420,  469,
 /*  2740 */   469,  469,  375,  469,  377,  469,  469,  331,  469,  469,
 /*  2750 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2760 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2770 */   469,  469,  469,  406,  469,  469,  469,  410,  362,  469,
 /*  2780 */   413,  414,  415,  416,  417,  418,  370,  420,  469,  469,
 /*  2790 */   469,  375,  469,  377,  469,  469,  469,  469,  469,  469,
 /*  2800 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2810 */   469,  469,  469,  469,  469,  469,  469,  469,  469,  469,
 /*  2820 */   469,  469,  406,  469,  469,  469,  410,  469,  469,  413,
 /*  2830 */   414,  415,  416,  417,  418,  469,  420,
};
#define YY_SHIFT_COUNT    (736)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2175)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   865,    0,   71,    0,  290,  290,  290,  290,  290,  290,
 /*    10 */   290,  290,  290,  290,  290,  361,  578,  578,  649,  578,
 /*    20 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    30 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    40 */   578,  578,  578,  578,  578,  578,  578,  578,  450,  530,
 /*    50 */   254,  506,   70,  101,  141,  101,  506,  506, 1348, 1348,
 /*    60 */  1348,  101, 1348, 1348,  395,  101,   69,  258,  123,  123,
 /*    70 */   258,  186,  186,  380,  172,    1,    1,  123,  123,  123,
 /*    80 */   123,  123,  123,  123,  210,  123,  123,  173,   69,  123,
 /*    90 */   123,  246,  123,   69,  123,  210,  123,  210,   69,  123,
 /*   100 */   123,   69,  123,   69,   69,   69,  123,  257,  795,   34,
 /*   110 */    34,  217,  826, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   120 */  1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1353,
 /*   130 */  1353, 1353,  152,  516,  380,  172,  135,  587,  644,  644,
 /*   140 */   644,  675,  330,  330,  587,  326,  326,  326,  308,  396,
 /*   150 */    69,  695,   69,  695,  695,  627,  827,   36,   36,   36,
 /*   160 */    36,   36,   36,   36,   36, 1811,  313,  474,  615,  249,
 /*   170 */   798,  341,  213,  159,  508,  900,  836,  839,  610,  977,
 /*   180 */   759,   91, 1026,  759, 1023,  851,  987, 1090, 1298, 1182,
 /*   190 */  1323, 1352, 1323, 1221, 1369, 1369, 1323, 1221, 1221, 1303,
 /*   200 */  1369, 1369, 1369, 1387, 1387, 1390,  173, 1391,  173, 1400,
 /*   210 */  1402,  173, 1400,  173,  173,  173, 1369,  173, 1383, 1383,
 /*   220 */  1387,   69,   69,   69,   69,   69,   69,   69,   69,   69,
 /*   230 */    69,   69, 1369, 1387,  695,  695, 1229, 1385, 1390,  257,
 /*   240 */  1300, 1391,  257, 1369, 1352, 1352,  695, 1243, 1251,  695,
 /*   250 */  1243, 1251,  695,  695,   69, 1261, 1354, 1243, 1264, 1262,
 /*   260 */  1277, 1090, 1267, 1265, 1274, 1299,  326, 1543, 1369, 1400,
 /*   270 */   257,  257, 1564, 1251,  695,  695,  695,  695,  695, 1251,
 /*   280 */   695, 1421,  257,  627,  257,  326, 1507, 1508,  695,  827,
 /*   290 */  1369,  257, 1573, 1387, 2837, 2837, 2837, 2837, 2837, 2837,
 /*   300 */  2837, 2837, 2837,  890,  274,  457,  331,  631,  976, 1000,
 /*   310 */   525, 1009, 1113, 1213,  709,  838,  838,  838,  838,  838,
 /*   320 */   838,  838,  838,  838, 1016,  239,   86,   86,  539,  460,
 /*   330 */     4,  621,  741,  557,  599,  599,  769,  553,  505,  769,
 /*   340 */   769,  769,  443, 1018,  785, 1041,  772,  899, 1008, 1014,
 /*   350 */  1031, 1086, 1109, 1161,  999, 1038, 1093, 1121, 1140, 1142,
 /*   360 */   775, 1058, 1010,  609, 1163, 1165, 1167, 1174, 1176, 1180,
 /*   370 */  1134, 1244, 1118, 1173,  725, 1246,  650, 1248, 1253, 1260,
 /*   380 */  1271, 1288, 1289, 1108, 1256, 1313,  779, 1331, 1618, 1632,
 /*   390 */  1639, 1598, 1642, 1609, 1443, 1611, 1612, 1614, 1448, 1651,
 /*   400 */  1617, 1619, 1451, 1655, 1455, 1658, 1624, 1660, 1640, 1664,
 /*   410 */  1630, 1476, 1482, 1485, 1669, 1670, 1671, 1494, 1496, 1675,
 /*   420 */  1685, 1631, 1687, 1688, 1689, 1648, 1691, 1707, 1709, 1710,
 /*   430 */  1711, 1712, 1714, 1715, 1544, 1659, 1719, 1569, 1722, 1724,
 /*   440 */  1725, 1726, 1727, 1728, 1729, 1730, 1731, 1732, 1733, 1734,
 /*   450 */  1735, 1737, 1738, 1739, 1698, 1741, 1742, 1743, 1745, 1746,
 /*   460 */  1747, 1736, 1748, 1750, 1753, 1620, 1754, 1757, 1740, 1765,
 /*   470 */  1716, 1767, 1718, 1768, 1769, 1744, 1758, 1749, 1723, 1763,
 /*   480 */  1751, 1771, 1752, 1779, 1756, 1761, 1781, 1782, 1783, 1762,
 /*   490 */  1634, 1803, 1804, 1805, 1708, 1806, 1809, 1776, 1764, 1774,
 /*   500 */  1814, 1784, 1770, 1777, 1820, 1786, 1775, 1785, 1822, 1790,
 /*   510 */  1780, 1793, 1827, 1829, 1833, 1835, 1760, 1759, 1801, 1815,
 /*   520 */  1838, 1807, 1808, 1810, 1812, 1796, 1818, 1813, 1816, 1830,
 /*   530 */  1836, 1849, 1850, 1873, 1853, 1826, 1885, 1865, 1854, 1888,
 /*   540 */  1855, 1891, 1857, 1893, 1874, 1875, 1862, 1863, 1705, 1817,
 /*   550 */  1821, 1901, 1766, 1823, 1868, 1904, 1720, 1889, 1773, 1755,
 /*   560 */  1910, 1912, 1787, 1789, 1914, 1871, 1673, 1825, 1828, 1831,
 /*   570 */  1792, 1696, 1800, 1674, 1837, 1887, 1890, 1839, 1841, 1844,
 /*   580 */  1848, 1858, 1896, 1906, 1908, 1861, 1913, 1682, 1877, 1878,
 /*   590 */  1956, 1920, 1791, 1943, 1944, 1945, 1947, 1949, 1950, 1881,
 /*   600 */  1897, 1939, 1778, 1948, 1940, 1989, 1994, 1995, 1996, 1902,
 /*   610 */  1962, 1723, 1955, 1915, 1907, 1909, 1916, 1917, 1840, 1918,
 /*   620 */  2008, 1975, 1851, 1922, 1919, 1723, 1968, 1974, 1832, 1819,
 /*   630 */  1834, 2018, 1999, 1824, 1941, 1938, 1957, 1958, 1963, 1961,
 /*   640 */  1990, 1964, 1965, 2004, 1966, 2016, 1856, 1970, 1967, 1971,
 /*   650 */  2033, 2035, 1977, 1978, 2041, 1980, 1981, 2043, 1984, 1985,
 /*   660 */  2045, 1987, 1993, 2048, 1992, 1982, 1983, 1986, 1997, 2063,
 /*   670 */  1979, 2002, 2046, 2011, 2064, 2020, 2046, 2046, 2091, 2053,
 /*   680 */  2055, 2085, 2086, 2087, 2088, 2089, 2090, 2092, 2093, 2094,
 /*   690 */  2095, 2061, 2034, 2096, 2097, 2098, 2100, 2114, 2102, 2103,
 /*   700 */  2104, 2071, 1796, 2108, 1818, 2109, 2110, 2111, 2113, 2129,
 /*   710 */  2117, 2153, 2119, 2107, 2118, 2156, 2124, 2112, 2122, 2162,
 /*   720 */  2131, 2116, 2128, 2168, 2134, 2123, 2133, 2170, 2138, 2139,
 /*   730 */  2175, 2155, 2158, 2159, 2161, 2163, 2160,
};
#define YY_REDUCE_COUNT (302)
#define YY_REDUCE_MIN   (-434)
#define YY_REDUCE_MAX   (2416)
static const short yy_reduce_ofst[] = {
 /*     0 */   589,  189,  674,  742,  762,  835,  869,  903,  937, 1042,
 /*    10 */  1069, 1133, 1206, 1266, 1286, -295,   -5,  288, 1346,  354,
 /*    20 */  1374, 1101, 1440, 1464, 1532, 1552, 1613, 1629, 1678, 1694,
 /*    30 */  1772, 1788, 1845, 1864, 1923, 1942, 1991, 2040, 2056, 2072,
 /*    40 */  2148, 2164, 2221, 2240, 2299, 2318, 2367, 2416, -265, -351,
 /*    50 */   293,   98, -387, -257,  -61,  935,  -19,  157, -356, -324,
 /*    60 */   303, -434, -341, -233, -402,  229,  -54, -361,  102,  107,
 /*    70 */  -333, -335,   17, -345, -237,  140,  350,  471,  541,  542,
 /*    80 */   543,  657,  711,  801,  -30,  811,  846, -108, -178,  849,
 /*    90 */   853,  -56,  862,  -51,  894,  109,  901,  222, -281,  904,
 /*   100 */   969,   26,  389,   15,  187,   80,  971,  378, -313, -319,
 /*   110 */  -319, -216, -141, -330,   31,  240,  306,  403,  511,  548,
 /*   120 */   651,  655,  662,  663,  664,  671,  700,  702,  703,  704,
 /*   130 */   743,  745, -296,  -45,  169, -196,  124,  219,  -45,   33,
 /*   140 */   262,   89,  296,  397,  478,  449,  463,  517,  501,  332,
 /*   150 */  -268,  544,  255,  546,  555,  574,  479, -357, -353,  551,
 /*   160 */   656,  740,  800,  807,  740,  739,  859,  845,  813,  747,
 /*   170 */   774,  896,  792,  873,  873,  915,  910,  920,  924,  917,
 /*   180 */   864,  864,  876,  864,  892,  893,  873,  898,  952,  970,
 /*   190 */   989,  991, 1004, 1007, 1051, 1052, 1013, 1012, 1017, 1054,
 /*   200 */  1063, 1064, 1066, 1075, 1076, 1015, 1068, 1037, 1070, 1081,
 /*   210 */  1029, 1080, 1087, 1083, 1084, 1085, 1094, 1089, 1095, 1096,
 /*   220 */  1103, 1078, 1079, 1088, 1091, 1092, 1099, 1104, 1106, 1110,
 /*   230 */  1115, 1119, 1112, 1114, 1067, 1074, 1040, 1102, 1097, 1100,
 /*   240 */  1120, 1116, 1147, 1152, 1107, 1117, 1122, 1055, 1123, 1137,
 /*   250 */  1060, 1132, 1148, 1149,  873, 1077, 1126, 1105, 1111, 1098,
 /*   260 */  1136, 1124, 1073, 1072, 1125,  864, 1185, 1154, 1239, 1212,
 /*   270 */  1236, 1237, 1197, 1198, 1214, 1215, 1216, 1217, 1218, 1204,
 /*   280 */  1220, 1209, 1255, 1241, 1257, 1231, 1175, 1238, 1232, 1254,
 /*   290 */  1269, 1268, 1276, 1280, 1228, 1225, 1223, 1224, 1273, 1275,
 /*   300 */  1278, 1291, 1301,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    10 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    20 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    30 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    40 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    50 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    60 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    70 */  1654, 1654, 1654, 1911, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    80 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1732, 1654, 1654,
 /*    90 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   100 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1730, 1904, 2118,
 /*   110 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   120 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   130 */  1654, 1654, 1654, 2130, 1654, 1654, 1732, 1654, 2130, 2130,
 /*   140 */  2130, 1730, 2090, 2090, 1654, 1654, 1654, 1654, 1965, 1654,
 /*   150 */  1654, 1654, 1654, 1654, 1654, 1839, 1654, 1654, 1654, 1654,
 /*   160 */  1654, 1863, 1654, 1654, 1654, 1957, 1654, 1654, 2155, 2211,
 /*   170 */  1654, 1654, 2158, 1654, 1654, 1654, 1916, 1654, 1792, 2145,
 /*   180 */  2122, 2136, 2195, 2123, 2120, 2139, 1654, 2149, 1654, 1950,
 /*   190 */  1909, 1654, 1909, 1906, 1654, 1654, 1909, 1906, 1906, 1783,
 /*   200 */  1654, 1654, 1654, 1654, 1654, 1654, 1732, 1654, 1732, 1654,
 /*   210 */  1654, 1732, 1654, 1732, 1732, 1732, 1654, 1732, 1711, 1711,
 /*   220 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   230 */  1654, 1654, 1654, 1654, 1654, 1654, 1975, 1963, 1654, 1730,
 /*   240 */  1959, 1654, 1730, 1654, 1654, 1654, 1654, 2166, 2164, 1654,
 /*   250 */  2166, 2164, 1654, 1654, 1654, 2180, 2176, 2166, 2184, 2182,
 /*   260 */  2151, 2149, 2214, 2201, 2197, 2136, 1654, 1654, 1654, 1654,
 /*   270 */  1730, 1730, 1654, 2164, 1654, 1654, 1654, 1654, 1654, 2164,
 /*   280 */  1654, 1654, 1730, 1654, 1730, 1654, 1654, 1808, 1654, 1654,
 /*   290 */  1654, 1730, 1686, 1654, 1952, 1968, 1934, 1934, 1842, 1842,
 /*   300 */  1842, 1733, 1659, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   310 */  1654, 1654, 1654, 1654, 1654, 2179, 2178, 2045, 1654, 2094,
 /*   320 */  2093, 2092, 2083, 2044, 1804, 1654, 2043, 2042, 1654, 1654,
 /*   330 */  1654, 1654, 1654, 1654, 1925, 1924, 2036, 1654, 1654, 2037,
 /*   340 */  2035, 2034, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   350 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   360 */  1654, 2198, 2202, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   370 */  2119, 1654, 1654, 1654, 1654, 1654, 2018, 1654, 1654, 1654,
 /*   380 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   390 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   400 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   410 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   420 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   430 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   440 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   450 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   460 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   470 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1691, 2023, 1654,
 /*   480 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   490 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   500 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   510 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   520 */  1654, 1654, 1654, 1654, 1654, 1771, 1770, 1654, 1654, 1654,
 /*   530 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   540 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 2027,
 /*   550 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   560 */  1654, 1654, 1654, 1654, 2194, 2152, 1654, 1654, 1654, 1654,
 /*   570 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   580 */  1654, 1654, 1654, 1654, 2018, 1654, 2177, 1654, 1654, 2192,
 /*   590 */  1654, 2196, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 2129,
 /*   600 */  2125, 1654, 1654, 2121, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   610 */  1654, 2026, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   620 */  1654, 1654, 1654, 1654, 1654, 2017, 1654, 2080, 1654, 1654,
 /*   630 */  1654, 2114, 1654, 1654, 2065, 1654, 1654, 1654, 1654, 1654,
 /*   640 */  1654, 1654, 1654, 1654, 2027, 1654, 2030, 1654, 1654, 1654,
 /*   650 */  1654, 1654, 1836, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   660 */  1654, 1654, 1654, 1654, 1654, 1821, 1819, 1818, 1817, 1654,
 /*   670 */  1814, 1654, 1849, 1654, 1654, 1654, 1845, 1844, 1654, 1654,
 /*   680 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   690 */  1654, 1654, 1654, 1751, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   700 */  1654, 1654, 1743, 1654, 1742, 1654, 1654, 1654, 1654, 1654,
 /*   710 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   720 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*   730 */  1654, 1654, 1654, 1654, 1654, 1654, 1654,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  274,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  274,  /*      AFTER => ABORT */
  274,  /*     ATTACH => ABORT */
  274,  /*     BEFORE => ABORT */
  274,  /*      BEGIN => ABORT */
  274,  /*     BITAND => ABORT */
  274,  /*     BITNOT => ABORT */
  274,  /*      BITOR => ABORT */
  274,  /*     BLOCKS => ABORT */
  274,  /*     CHANGE => ABORT */
  274,  /*      COMMA => ABORT */
  274,  /*    COMPACT => ABORT */
  274,  /*     CONCAT => ABORT */
  274,  /*   CONFLICT => ABORT */
  274,  /*       COPY => ABORT */
  274,  /*   DEFERRED => ABORT */
  274,  /* DELIMITERS => ABORT */
  274,  /*     DETACH => ABORT */
  274,  /*     DIVIDE => ABORT */
  274,  /*        DOT => ABORT */
  274,  /*       EACH => ABORT */
  274,  /*       FAIL => ABORT */
  274,  /*       FILE => ABORT */
  274,  /*        FOR => ABORT */
  274,  /*       GLOB => ABORT */
  274,  /*         ID => ABORT */
  274,  /*  IMMEDIATE => ABORT */
  274,  /*     IMPORT => ABORT */
  274,  /*  INITIALLY => ABORT */
  274,  /*    INSTEAD => ABORT */
  274,  /*     ISNULL => ABORT */
  274,  /*        KEY => ABORT */
  274,  /*    MODULES => ABORT */
  274,  /*  NK_BITNOT => ABORT */
  274,  /*    NK_SEMI => ABORT */
  274,  /*    NOTNULL => ABORT */
  274,  /*         OF => ABORT */
  274,  /*       PLUS => ABORT */
  274,  /*  PRIVILEGE => ABORT */
  274,  /*      RAISE => ABORT */
  274,  /*    REPLACE => ABORT */
  274,  /*   RESTRICT => ABORT */
  274,  /*        ROW => ABORT */
  274,  /*       SEMI => ABORT */
  274,  /*       STAR => ABORT */
  274,  /*  STATEMENT => ABORT */
  274,  /*     STRICT => ABORT */
  274,  /*     STRING => ABORT */
  274,  /*      TIMES => ABORT */
  274,  /*     UPDATE => ABORT */
  274,  /*     VALUES => ABORT */
  274,  /*   VARIABLE => ABORT */
  274,  /*       VIEW => ABORT */
  274,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "ALIVE",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "COUNT",
  /*  169 */ "LAST_ROW",
  /*  170 */ "TOPIC",
  /*  171 */ "WITH",
  /*  172 */ "META",
  /*  173 */ "CONSUMER",
  /*  174 */ "GROUP",
  /*  175 */ "DESC",
  /*  176 */ "DESCRIBE",
  /*  177 */ "RESET",
  /*  178 */ "QUERY",
  /*  179 */ "CACHE",
  /*  180 */ "EXPLAIN",
  /*  181 */ "ANALYZE",
  /*  182 */ "VERBOSE",
  /*  183 */ "NK_BOOL",
  /*  184 */ "RATIO",
  /*  185 */ "NK_FLOAT",
  /*  186 */ "OUTPUTTYPE",
  /*  187 */ "AGGREGATE",
  /*  188 */ "BUFSIZE",
  /*  189 */ "STREAM",
  /*  190 */ "INTO",
  /*  191 */ "TRIGGER",
  /*  192 */ "AT_ONCE",
  /*  193 */ "WINDOW_CLOSE",
  /*  194 */ "IGNORE",
  /*  195 */ "EXPIRED",
  /*  196 */ "FILL_HISTORY",
  /*  197 */ "SUBTABLE",
  /*  198 */ "KILL",
  /*  199 */ "CONNECTION",
  /*  200 */ "TRANSACTION",
  /*  201 */ "BALANCE",
  /*  202 */ "VGROUP",
  /*  203 */ "MERGE",
  /*  204 */ "REDISTRIBUTE",
  /*  205 */ "SPLIT",
  /*  206 */ "DELETE",
  /*  207 */ "INSERT",
  /*  208 */ "NULL",
  /*  209 */ "NK_QUESTION",
  /*  210 */ "NK_ARROW",
  /*  211 */ "ROWTS",
  /*  212 */ "QSTART",
  /*  213 */ "QEND",
  /*  214 */ "QDURATION",
  /*  215 */ "WSTART",
  /*  216 */ "WEND",
  /*  217 */ "WDURATION",
  /*  218 */ "IROWTS",
  /*  219 */ "ISFILLED",
  /*  220 */ "CAST",
  /*  221 */ "NOW",
  /*  222 */ "TODAY",
  /*  223 */ "TIMEZONE",
  /*  224 */ "CLIENT_VERSION",
  /*  225 */ "SERVER_VERSION",
  /*  226 */ "SERVER_STATUS",
  /*  227 */ "CURRENT_USER",
  /*  228 */ "CASE",
  /*  229 */ "END",
  /*  230 */ "WHEN",
  /*  231 */ "THEN",
  /*  232 */ "ELSE",
  /*  233 */ "BETWEEN",
  /*  234 */ "IS",
  /*  235 */ "NK_LT",
  /*  236 */ "NK_GT",
  /*  237 */ "NK_LE",
  /*  238 */ "NK_GE",
  /*  239 */ "NK_NE",
  /*  240 */ "MATCH",
  /*  241 */ "NMATCH",
  /*  242 */ "CONTAINS",
  /*  243 */ "IN",
  /*  244 */ "JOIN",
  /*  245 */ "INNER",
  /*  246 */ "SELECT",
  /*  247 */ "DISTINCT",
  /*  248 */ "WHERE",
  /*  249 */ "PARTITION",
  /*  250 */ "BY",
  /*  251 */ "SESSION",
  /*  252 */ "STATE_WINDOW",
  /*  253 */ "EVENT_WINDOW",
  /*  254 */ "START",
  /*  255 */ "SLIDING",
  /*  256 */ "FILL",
  /*  257 */ "VALUE",
  /*  258 */ "VALUE_F",
  /*  259 */ "NONE",
  /*  260 */ "PREV",
  /*  261 */ "NULL_F",
  /*  262 */ "LINEAR",
  /*  263 */ "NEXT",
  /*  264 */ "HAVING",
  /*  265 */ "RANGE",
  /*  266 */ "EVERY",
  /*  267 */ "ORDER",
  /*  268 */ "SLIMIT",
  /*  269 */ "SOFFSET",
  /*  270 */ "LIMIT",
  /*  271 */ "OFFSET",
  /*  272 */ "ASC",
  /*  273 */ "NULLS",
  /*  274 */ "ABORT",
  /*  275 */ "AFTER",
  /*  276 */ "ATTACH",
  /*  277 */ "BEFORE",
  /*  278 */ "BEGIN",
  /*  279 */ "BITAND",
  /*  280 */ "BITNOT",
  /*  281 */ "BITOR",
  /*  282 */ "BLOCKS",
  /*  283 */ "CHANGE",
  /*  284 */ "COMMA",
  /*  285 */ "COMPACT",
  /*  286 */ "CONCAT",
  /*  287 */ "CONFLICT",
  /*  288 */ "COPY",
  /*  289 */ "DEFERRED",
  /*  290 */ "DELIMITERS",
  /*  291 */ "DETACH",
  /*  292 */ "DIVIDE",
  /*  293 */ "DOT",
  /*  294 */ "EACH",
  /*  295 */ "FAIL",
  /*  296 */ "FILE",
  /*  297 */ "FOR",
  /*  298 */ "GLOB",
  /*  299 */ "ID",
  /*  300 */ "IMMEDIATE",
  /*  301 */ "IMPORT",
  /*  302 */ "INITIALLY",
  /*  303 */ "INSTEAD",
  /*  304 */ "ISNULL",
  /*  305 */ "KEY",
  /*  306 */ "MODULES",
  /*  307 */ "NK_BITNOT",
  /*  308 */ "NK_SEMI",
  /*  309 */ "NOTNULL",
  /*  310 */ "OF",
  /*  311 */ "PLUS",
  /*  312 */ "PRIVILEGE",
  /*  313 */ "RAISE",
  /*  314 */ "REPLACE",
  /*  315 */ "RESTRICT",
  /*  316 */ "ROW",
  /*  317 */ "SEMI",
  /*  318 */ "STAR",
  /*  319 */ "STATEMENT",
  /*  320 */ "STRICT",
  /*  321 */ "STRING",
  /*  322 */ "TIMES",
  /*  323 */ "UPDATE",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "priv_type_list",
  /*  338 */ "priv_type",
  /*  339 */ "db_name",
  /*  340 */ "topic_name",
  /*  341 */ "dnode_endpoint",
  /*  342 */ "force_opt",
  /*  343 */ "not_exists_opt",
  /*  344 */ "db_options",
  /*  345 */ "exists_opt",
  /*  346 */ "alter_db_options",
  /*  347 */ "speed_opt",
  /*  348 */ "integer_list",
  /*  349 */ "variable_list",
  /*  350 */ "retention_list",
  /*  351 */ "alter_db_option",
  /*  352 */ "retention",
  /*  353 */ "full_table_name",
  /*  354 */ "column_def_list",
  /*  355 */ "tags_def_opt",
  /*  356 */ "table_options",
  /*  357 */ "multi_create_clause",
  /*  358 */ "tags_def",
  /*  359 */ "multi_drop_clause",
  /*  360 */ "alter_table_clause",
  /*  361 */ "alter_table_options",
  /*  362 */ "column_name",
  /*  363 */ "type_name",
  /*  364 */ "signed_literal",
  /*  365 */ "create_subtable_clause",
  /*  366 */ "specific_cols_opt",
  /*  367 */ "expression_list",
  /*  368 */ "drop_table_clause",
  /*  369 */ "col_name_list",
  /*  370 */ "table_name",
  /*  371 */ "column_def",
  /*  372 */ "duration_list",
  /*  373 */ "rollup_func_list",
  /*  374 */ "alter_table_option",
  /*  375 */ "duration_literal",
  /*  376 */ "rollup_func_name",
  /*  377 */ "function_name",
  /*  378 */ "col_name",
  /*  379 */ "db_name_cond_opt",
  /*  380 */ "like_pattern_opt",
  /*  381 */ "table_name_cond",
  /*  382 */ "from_db_opt",
  /*  383 */ "tag_list_opt",
  /*  384 */ "tag_item",
  /*  385 */ "column_alias",
  /*  386 */ "full_index_name",
  /*  387 */ "index_options",
  /*  388 */ "index_name",
  /*  389 */ "func_list",
  /*  390 */ "sliding_opt",
  /*  391 */ "sma_stream_opt",
  /*  392 */ "func",
  /*  393 */ "sma_func_name",
  /*  394 */ "query_or_subquery",
  /*  395 */ "cgroup_name",
  /*  396 */ "analyze_opt",
  /*  397 */ "explain_options",
  /*  398 */ "insert_query",
  /*  399 */ "agg_func_opt",
  /*  400 */ "bufsize_opt",
  /*  401 */ "stream_name",
  /*  402 */ "stream_options",
  /*  403 */ "col_list_opt",
  /*  404 */ "tag_def_or_ref_opt",
  /*  405 */ "subtable_opt",
  /*  406 */ "expression",
  /*  407 */ "dnode_list",
  /*  408 */ "where_clause_opt",
  /*  409 */ "signed",
  /*  410 */ "literal_func",
  /*  411 */ "literal_list",
  /*  412 */ "table_alias",
  /*  413 */ "expr_or_subquery",
  /*  414 */ "pseudo_column",
  /*  415 */ "column_reference",
  /*  416 */ "function_expression",
  /*  417 */ "case_when_expression",
  /*  418 */ "star_func",
  /*  419 */ "star_func_para_list",
  /*  420 */ "noarg_func",
  /*  421 */ "other_para_list",
  /*  422 */ "star_func_para",
  /*  423 */ "when_then_list",
  /*  424 */ "case_when_else_opt",
  /*  425 */ "common_expression",
  /*  426 */ "when_then_expr",
  /*  427 */ "predicate",
  /*  428 */ "compare_op",
  /*  429 */ "in_op",
  /*  430 */ "in_predicate_value",
  /*  431 */ "boolean_value_expression",
  /*  432 */ "boolean_primary",
  /*  433 */ "from_clause_opt",
  /*  434 */ "table_reference_list",
  /*  435 */ "table_reference",
  /*  436 */ "table_primary",
  /*  437 */ "joined_table",
  /*  438 */ "alias_opt",
  /*  439 */ "subquery",
  /*  440 */ "parenthesized_joined_table",
  /*  441 */ "join_type",
  /*  442 */ "search_condition",
  /*  443 */ "query_specification",
  /*  444 */ "set_quantifier_opt",
  /*  445 */ "select_list",
  /*  446 */ "partition_by_clause_opt",
  /*  447 */ "range_opt",
  /*  448 */ "every_opt",
  /*  449 */ "fill_opt",
  /*  450 */ "twindow_clause_opt",
  /*  451 */ "group_by_clause_opt",
  /*  452 */ "having_clause_opt",
  /*  453 */ "select_item",
  /*  454 */ "partition_list",
  /*  455 */ "partition_item",
  /*  456 */ "fill_mode",
  /*  457 */ "group_by_list",
  /*  458 */ "query_expression",
  /*  459 */ "query_simple",
  /*  460 */ "order_by_clause_opt",
  /*  461 */ "slimit_clause_opt",
  /*  462 */ "limit_clause_opt",
  /*  463 */ "union_query_expression",
  /*  464 */ "query_simple_or_subquery",
  /*  465 */ "sort_specification_list",
  /*  466 */ "sort_specification",
  /*  467 */ "ordering_specification_opt",
  /*  468 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 246 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 247 */ "db_name_cond_opt ::=",
 /* 248 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 249 */ "like_pattern_opt ::=",
 /* 250 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 251 */ "table_name_cond ::= table_name",
 /* 252 */ "from_db_opt ::=",
 /* 253 */ "from_db_opt ::= FROM db_name",
 /* 254 */ "tag_list_opt ::=",
 /* 255 */ "tag_list_opt ::= tag_item",
 /* 256 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 257 */ "tag_item ::= TBNAME",
 /* 258 */ "tag_item ::= QTAGS",
 /* 259 */ "tag_item ::= column_name",
 /* 260 */ "tag_item ::= column_name column_alias",
 /* 261 */ "tag_item ::= column_name AS column_alias",
 /* 262 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 263 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 264 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 265 */ "full_index_name ::= index_name",
 /* 266 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 267 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "func_list ::= func",
 /* 270 */ "func_list ::= func_list NK_COMMA func",
 /* 271 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 272 */ "sma_func_name ::= function_name",
 /* 273 */ "sma_func_name ::= COUNT",
 /* 274 */ "sma_func_name ::= FIRST",
 /* 275 */ "sma_func_name ::= LAST",
 /* 276 */ "sma_func_name ::= LAST_ROW",
 /* 277 */ "sma_stream_opt ::=",
 /* 278 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 286 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 287 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 288 */ "cmd ::= DESC full_table_name",
 /* 289 */ "cmd ::= DESCRIBE full_table_name",
 /* 290 */ "cmd ::= RESET QUERY CACHE",
 /* 291 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 293 */ "analyze_opt ::=",
 /* 294 */ "analyze_opt ::= ANALYZE",
 /* 295 */ "explain_options ::=",
 /* 296 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 297 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 298 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 299 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 300 */ "agg_func_opt ::=",
 /* 301 */ "agg_func_opt ::= AGGREGATE",
 /* 302 */ "bufsize_opt ::=",
 /* 303 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 304 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 305 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 306 */ "col_list_opt ::=",
 /* 307 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 308 */ "tag_def_or_ref_opt ::=",
 /* 309 */ "tag_def_or_ref_opt ::= tags_def",
 /* 310 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 311 */ "stream_options ::=",
 /* 312 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 313 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 314 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 315 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 316 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 317 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 318 */ "subtable_opt ::=",
 /* 319 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 320 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 321 */ "cmd ::= KILL QUERY NK_STRING",
 /* 322 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 323 */ "cmd ::= BALANCE VGROUP",
 /* 324 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 325 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 326 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 327 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 328 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 329 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 330 */ "cmd ::= query_or_subquery",
 /* 331 */ "cmd ::= insert_query",
 /* 332 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 333 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 334 */ "literal ::= NK_INTEGER",
 /* 335 */ "literal ::= NK_FLOAT",
 /* 336 */ "literal ::= NK_STRING",
 /* 337 */ "literal ::= NK_BOOL",
 /* 338 */ "literal ::= TIMESTAMP NK_STRING",
 /* 339 */ "literal ::= duration_literal",
 /* 340 */ "literal ::= NULL",
 /* 341 */ "literal ::= NK_QUESTION",
 /* 342 */ "duration_literal ::= NK_VARIABLE",
 /* 343 */ "signed ::= NK_INTEGER",
 /* 344 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 345 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 346 */ "signed ::= NK_FLOAT",
 /* 347 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 348 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 349 */ "signed_literal ::= signed",
 /* 350 */ "signed_literal ::= NK_STRING",
 /* 351 */ "signed_literal ::= NK_BOOL",
 /* 352 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 353 */ "signed_literal ::= duration_literal",
 /* 354 */ "signed_literal ::= NULL",
 /* 355 */ "signed_literal ::= literal_func",
 /* 356 */ "signed_literal ::= NK_QUESTION",
 /* 357 */ "literal_list ::= signed_literal",
 /* 358 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 359 */ "db_name ::= NK_ID",
 /* 360 */ "table_name ::= NK_ID",
 /* 361 */ "column_name ::= NK_ID",
 /* 362 */ "function_name ::= NK_ID",
 /* 363 */ "table_alias ::= NK_ID",
 /* 364 */ "column_alias ::= NK_ID",
 /* 365 */ "user_name ::= NK_ID",
 /* 366 */ "topic_name ::= NK_ID",
 /* 367 */ "stream_name ::= NK_ID",
 /* 368 */ "cgroup_name ::= NK_ID",
 /* 369 */ "index_name ::= NK_ID",
 /* 370 */ "expr_or_subquery ::= expression",
 /* 371 */ "expression ::= literal",
 /* 372 */ "expression ::= pseudo_column",
 /* 373 */ "expression ::= column_reference",
 /* 374 */ "expression ::= function_expression",
 /* 375 */ "expression ::= case_when_expression",
 /* 376 */ "expression ::= NK_LP expression NK_RP",
 /* 377 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 378 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 379 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 380 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 382 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 383 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 384 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 385 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 386 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 387 */ "expression_list ::= expr_or_subquery",
 /* 388 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 389 */ "column_reference ::= column_name",
 /* 390 */ "column_reference ::= table_name NK_DOT column_name",
 /* 391 */ "pseudo_column ::= ROWTS",
 /* 392 */ "pseudo_column ::= TBNAME",
 /* 393 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 394 */ "pseudo_column ::= QSTART",
 /* 395 */ "pseudo_column ::= QEND",
 /* 396 */ "pseudo_column ::= QDURATION",
 /* 397 */ "pseudo_column ::= WSTART",
 /* 398 */ "pseudo_column ::= WEND",
 /* 399 */ "pseudo_column ::= WDURATION",
 /* 400 */ "pseudo_column ::= IROWTS",
 /* 401 */ "pseudo_column ::= ISFILLED",
 /* 402 */ "pseudo_column ::= QTAGS",
 /* 403 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 404 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 405 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 406 */ "function_expression ::= literal_func",
 /* 407 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 408 */ "literal_func ::= NOW",
 /* 409 */ "noarg_func ::= NOW",
 /* 410 */ "noarg_func ::= TODAY",
 /* 411 */ "noarg_func ::= TIMEZONE",
 /* 412 */ "noarg_func ::= DATABASE",
 /* 413 */ "noarg_func ::= CLIENT_VERSION",
 /* 414 */ "noarg_func ::= SERVER_VERSION",
 /* 415 */ "noarg_func ::= SERVER_STATUS",
 /* 416 */ "noarg_func ::= CURRENT_USER",
 /* 417 */ "noarg_func ::= USER",
 /* 418 */ "star_func ::= COUNT",
 /* 419 */ "star_func ::= FIRST",
 /* 420 */ "star_func ::= LAST",
 /* 421 */ "star_func ::= LAST_ROW",
 /* 422 */ "star_func_para_list ::= NK_STAR",
 /* 423 */ "star_func_para_list ::= other_para_list",
 /* 424 */ "other_para_list ::= star_func_para",
 /* 425 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 426 */ "star_func_para ::= expr_or_subquery",
 /* 427 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 428 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 429 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 430 */ "when_then_list ::= when_then_expr",
 /* 431 */ "when_then_list ::= when_then_list when_then_expr",
 /* 432 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 433 */ "case_when_else_opt ::=",
 /* 434 */ "case_when_else_opt ::= ELSE common_expression",
 /* 435 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 436 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 437 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 438 */ "predicate ::= expr_or_subquery IS NULL",
 /* 439 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 440 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 441 */ "compare_op ::= NK_LT",
 /* 442 */ "compare_op ::= NK_GT",
 /* 443 */ "compare_op ::= NK_LE",
 /* 444 */ "compare_op ::= NK_GE",
 /* 445 */ "compare_op ::= NK_NE",
 /* 446 */ "compare_op ::= NK_EQ",
 /* 447 */ "compare_op ::= LIKE",
 /* 448 */ "compare_op ::= NOT LIKE",
 /* 449 */ "compare_op ::= MATCH",
 /* 450 */ "compare_op ::= NMATCH",
 /* 451 */ "compare_op ::= CONTAINS",
 /* 452 */ "in_op ::= IN",
 /* 453 */ "in_op ::= NOT IN",
 /* 454 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 455 */ "boolean_value_expression ::= boolean_primary",
 /* 456 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 457 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 458 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 459 */ "boolean_primary ::= predicate",
 /* 460 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 461 */ "common_expression ::= expr_or_subquery",
 /* 462 */ "common_expression ::= boolean_value_expression",
 /* 463 */ "from_clause_opt ::=",
 /* 464 */ "from_clause_opt ::= FROM table_reference_list",
 /* 465 */ "table_reference_list ::= table_reference",
 /* 466 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 467 */ "table_reference ::= table_primary",
 /* 468 */ "table_reference ::= joined_table",
 /* 469 */ "table_primary ::= table_name alias_opt",
 /* 470 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 471 */ "table_primary ::= subquery alias_opt",
 /* 472 */ "table_primary ::= parenthesized_joined_table",
 /* 473 */ "alias_opt ::=",
 /* 474 */ "alias_opt ::= table_alias",
 /* 475 */ "alias_opt ::= AS table_alias",
 /* 476 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 477 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 478 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 479 */ "join_type ::=",
 /* 480 */ "join_type ::= INNER",
 /* 481 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 482 */ "set_quantifier_opt ::=",
 /* 483 */ "set_quantifier_opt ::= DISTINCT",
 /* 484 */ "set_quantifier_opt ::= ALL",
 /* 485 */ "select_list ::= select_item",
 /* 486 */ "select_list ::= select_list NK_COMMA select_item",
 /* 487 */ "select_item ::= NK_STAR",
 /* 488 */ "select_item ::= common_expression",
 /* 489 */ "select_item ::= common_expression column_alias",
 /* 490 */ "select_item ::= common_expression AS column_alias",
 /* 491 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 492 */ "where_clause_opt ::=",
 /* 493 */ "where_clause_opt ::= WHERE search_condition",
 /* 494 */ "partition_by_clause_opt ::=",
 /* 495 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 496 */ "partition_list ::= partition_item",
 /* 497 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 498 */ "partition_item ::= expr_or_subquery",
 /* 499 */ "partition_item ::= expr_or_subquery column_alias",
 /* 500 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 501 */ "twindow_clause_opt ::=",
 /* 502 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 503 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 504 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 505 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 506 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 507 */ "sliding_opt ::=",
 /* 508 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 509 */ "fill_opt ::=",
 /* 510 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 511 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 512 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 513 */ "fill_mode ::= NONE",
 /* 514 */ "fill_mode ::= PREV",
 /* 515 */ "fill_mode ::= NULL",
 /* 516 */ "fill_mode ::= NULL_F",
 /* 517 */ "fill_mode ::= LINEAR",
 /* 518 */ "fill_mode ::= NEXT",
 /* 519 */ "group_by_clause_opt ::=",
 /* 520 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 521 */ "group_by_list ::= expr_or_subquery",
 /* 522 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 523 */ "having_clause_opt ::=",
 /* 524 */ "having_clause_opt ::= HAVING search_condition",
 /* 525 */ "range_opt ::=",
 /* 526 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 527 */ "every_opt ::=",
 /* 528 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 529 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 530 */ "query_simple ::= query_specification",
 /* 531 */ "query_simple ::= union_query_expression",
 /* 532 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 533 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 534 */ "query_simple_or_subquery ::= query_simple",
 /* 535 */ "query_simple_or_subquery ::= subquery",
 /* 536 */ "query_or_subquery ::= query_expression",
 /* 537 */ "query_or_subquery ::= subquery",
 /* 538 */ "order_by_clause_opt ::=",
 /* 539 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 540 */ "slimit_clause_opt ::=",
 /* 541 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 542 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 543 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 544 */ "limit_clause_opt ::=",
 /* 545 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 546 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 547 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 548 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 549 */ "subquery ::= NK_LP subquery NK_RP",
 /* 550 */ "search_condition ::= common_expression",
 /* 551 */ "sort_specification_list ::= sort_specification",
 /* 552 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 553 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 554 */ "ordering_specification_opt ::=",
 /* 555 */ "ordering_specification_opt ::= ASC",
 /* 556 */ "ordering_specification_opt ::= DESC",
 /* 557 */ "null_ordering_opt ::=",
 /* 558 */ "null_ordering_opt ::= NULLS FIRST",
 /* 559 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 344: /* db_options */
    case 346: /* alter_db_options */
    case 352: /* retention */
    case 353: /* full_table_name */
    case 356: /* table_options */
    case 360: /* alter_table_clause */
    case 361: /* alter_table_options */
    case 364: /* signed_literal */
    case 365: /* create_subtable_clause */
    case 368: /* drop_table_clause */
    case 371: /* column_def */
    case 375: /* duration_literal */
    case 376: /* rollup_func_name */
    case 378: /* col_name */
    case 379: /* db_name_cond_opt */
    case 380: /* like_pattern_opt */
    case 381: /* table_name_cond */
    case 382: /* from_db_opt */
    case 384: /* tag_item */
    case 386: /* full_index_name */
    case 387: /* index_options */
    case 390: /* sliding_opt */
    case 391: /* sma_stream_opt */
    case 392: /* func */
    case 394: /* query_or_subquery */
    case 397: /* explain_options */
    case 398: /* insert_query */
    case 402: /* stream_options */
    case 405: /* subtable_opt */
    case 406: /* expression */
    case 408: /* where_clause_opt */
    case 409: /* signed */
    case 410: /* literal_func */
    case 413: /* expr_or_subquery */
    case 414: /* pseudo_column */
    case 415: /* column_reference */
    case 416: /* function_expression */
    case 417: /* case_when_expression */
    case 422: /* star_func_para */
    case 424: /* case_when_else_opt */
    case 425: /* common_expression */
    case 426: /* when_then_expr */
    case 427: /* predicate */
    case 430: /* in_predicate_value */
    case 431: /* boolean_value_expression */
    case 432: /* boolean_primary */
    case 433: /* from_clause_opt */
    case 434: /* table_reference_list */
    case 435: /* table_reference */
    case 436: /* table_primary */
    case 437: /* joined_table */
    case 439: /* subquery */
    case 440: /* parenthesized_joined_table */
    case 442: /* search_condition */
    case 443: /* query_specification */
    case 447: /* range_opt */
    case 448: /* every_opt */
    case 449: /* fill_opt */
    case 450: /* twindow_clause_opt */
    case 452: /* having_clause_opt */
    case 453: /* select_item */
    case 455: /* partition_item */
    case 458: /* query_expression */
    case 459: /* query_simple */
    case 461: /* slimit_clause_opt */
    case 462: /* limit_clause_opt */
    case 463: /* union_query_expression */
    case 464: /* query_simple_or_subquery */
    case 466: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy42)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 347: /* speed_opt */
    case 400: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 336: /* priv_level */
    case 339: /* db_name */
    case 340: /* topic_name */
    case 341: /* dnode_endpoint */
    case 362: /* column_name */
    case 370: /* table_name */
    case 377: /* function_name */
    case 385: /* column_alias */
    case 388: /* index_name */
    case 393: /* sma_func_name */
    case 395: /* cgroup_name */
    case 401: /* stream_name */
    case 412: /* table_alias */
    case 418: /* star_func */
    case 420: /* noarg_func */
    case 438: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 337: /* priv_type_list */
    case 338: /* priv_type */
{
 
}
      break;
    case 342: /* force_opt */
    case 343: /* not_exists_opt */
    case 345: /* exists_opt */
    case 396: /* analyze_opt */
    case 399: /* agg_func_opt */
    case 444: /* set_quantifier_opt */
{
 
}
      break;
    case 348: /* integer_list */
    case 349: /* variable_list */
    case 350: /* retention_list */
    case 354: /* column_def_list */
    case 355: /* tags_def_opt */
    case 357: /* multi_create_clause */
    case 358: /* tags_def */
    case 359: /* multi_drop_clause */
    case 366: /* specific_cols_opt */
    case 367: /* expression_list */
    case 369: /* col_name_list */
    case 372: /* duration_list */
    case 373: /* rollup_func_list */
    case 383: /* tag_list_opt */
    case 389: /* func_list */
    case 403: /* col_list_opt */
    case 404: /* tag_def_or_ref_opt */
    case 407: /* dnode_list */
    case 411: /* literal_list */
    case 419: /* star_func_para_list */
    case 421: /* other_para_list */
    case 423: /* when_then_list */
    case 445: /* select_list */
    case 446: /* partition_by_clause_opt */
    case 451: /* group_by_clause_opt */
    case 454: /* partition_list */
    case 457: /* group_by_list */
    case 460: /* order_by_clause_opt */
    case 465: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy110)); 
}
      break;
    case 351: /* alter_db_option */
    case 374: /* alter_table_option */
{
 
}
      break;
    case 363: /* type_name */
{
 
}
      break;
    case 428: /* compare_op */
    case 429: /* in_op */
{
 
}
      break;
    case 441: /* join_type */
{
 
}
      break;
    case 456: /* fill_mode */
{
 
}
      break;
    case 467: /* ordering_specification_opt */
{
 
}
      break;
    case 468: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  328,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  337,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  337,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  338,   -1 }, /* (38) priv_type ::= READ */
  {  338,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -1 }, /* (42) priv_level ::= topic_name */
  {  328,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  341,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  341,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  341,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  342,    0 }, /* (54) force_opt ::= */
  {  342,   -1 }, /* (55) force_opt ::= FORCE */
  {  328,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (68) cmd ::= USE db_name */
  {  328,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  343,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  343,    0 }, /* (73) not_exists_opt ::= */
  {  345,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  345,    0 }, /* (75) exists_opt ::= */
  {  344,    0 }, /* (76) db_options ::= */
  {  344,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  344,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  344,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  344,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  344,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  344,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  344,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  344,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  344,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  344,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  344,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  344,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  344,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  344,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  344,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  344,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  344,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  344,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  344,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  344,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  344,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  344,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  344,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  344,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  346,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  346,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  351,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  351,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  351,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  351,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  351,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  351,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  351,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  351,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  351,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  351,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  348,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  348,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  349,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  349,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  350,   -1 }, /* (123) retention_list ::= retention */
  {  350,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  352,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  347,    0 }, /* (126) speed_opt ::= */
  {  347,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  328,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  360,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  360,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  360,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  360,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  360,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  360,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  360,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  360,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  360,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  360,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  357,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  357,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  365,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  359,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  359,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  368,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  366,    0 }, /* (151) specific_cols_opt ::= */
  {  366,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  353,   -1 }, /* (153) full_table_name ::= table_name */
  {  353,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  354,   -1 }, /* (155) column_def_list ::= column_def */
  {  354,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  371,   -2 }, /* (157) column_def ::= column_name type_name */
  {  371,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  363,   -1 }, /* (159) type_name ::= BOOL */
  {  363,   -1 }, /* (160) type_name ::= TINYINT */
  {  363,   -1 }, /* (161) type_name ::= SMALLINT */
  {  363,   -1 }, /* (162) type_name ::= INT */
  {  363,   -1 }, /* (163) type_name ::= INTEGER */
  {  363,   -1 }, /* (164) type_name ::= BIGINT */
  {  363,   -1 }, /* (165) type_name ::= FLOAT */
  {  363,   -1 }, /* (166) type_name ::= DOUBLE */
  {  363,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  363,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  363,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  363,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  363,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  363,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  363,   -1 }, /* (174) type_name ::= JSON */
  {  363,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  363,   -1 }, /* (177) type_name ::= BLOB */
  {  363,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  363,   -1 }, /* (179) type_name ::= DECIMAL */
  {  363,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  363,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  355,    0 }, /* (182) tags_def_opt ::= */
  {  355,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  358,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  356,    0 }, /* (185) table_options ::= */
  {  356,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  356,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  356,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  356,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  356,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  356,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  356,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  361,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  361,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  374,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  374,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  372,   -1 }, /* (197) duration_list ::= duration_literal */
  {  372,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  373,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  373,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  376,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  376,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  376,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  369,   -1 }, /* (204) col_name_list ::= col_name */
  {  369,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  378,   -1 }, /* (206) col_name ::= column_name */
  {  328,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (246) cmd ::= SHOW CLUSTER ALIVE */
  {  379,    0 }, /* (247) db_name_cond_opt ::= */
  {  379,   -2 }, /* (248) db_name_cond_opt ::= db_name NK_DOT */
  {  380,    0 }, /* (249) like_pattern_opt ::= */
  {  380,   -2 }, /* (250) like_pattern_opt ::= LIKE NK_STRING */
  {  381,   -1 }, /* (251) table_name_cond ::= table_name */
  {  382,    0 }, /* (252) from_db_opt ::= */
  {  382,   -2 }, /* (253) from_db_opt ::= FROM db_name */
  {  383,    0 }, /* (254) tag_list_opt ::= */
  {  383,   -1 }, /* (255) tag_list_opt ::= tag_item */
  {  383,   -3 }, /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  384,   -1 }, /* (257) tag_item ::= TBNAME */
  {  384,   -1 }, /* (258) tag_item ::= QTAGS */
  {  384,   -1 }, /* (259) tag_item ::= column_name */
  {  384,   -2 }, /* (260) tag_item ::= column_name column_alias */
  {  384,   -3 }, /* (261) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (263) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (264) cmd ::= DROP INDEX exists_opt full_index_name */
  {  386,   -1 }, /* (265) full_index_name ::= index_name */
  {  386,   -3 }, /* (266) full_index_name ::= db_name NK_DOT index_name */
  {  387,  -10 }, /* (267) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,  -12 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  389,   -1 }, /* (269) func_list ::= func */
  {  389,   -3 }, /* (270) func_list ::= func_list NK_COMMA func */
  {  392,   -4 }, /* (271) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  393,   -1 }, /* (272) sma_func_name ::= function_name */
  {  393,   -1 }, /* (273) sma_func_name ::= COUNT */
  {  393,   -1 }, /* (274) sma_func_name ::= FIRST */
  {  393,   -1 }, /* (275) sma_func_name ::= LAST */
  {  393,   -1 }, /* (276) sma_func_name ::= LAST_ROW */
  {  391,    0 }, /* (277) sma_stream_opt ::= */
  {  391,   -3 }, /* (278) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  391,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  391,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (286) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (287) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (288) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (289) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (290) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (291) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  396,    0 }, /* (293) analyze_opt ::= */
  {  396,   -1 }, /* (294) analyze_opt ::= ANALYZE */
  {  397,    0 }, /* (295) explain_options ::= */
  {  397,   -3 }, /* (296) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  397,   -3 }, /* (297) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (298) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (299) cmd ::= DROP FUNCTION exists_opt function_name */
  {  399,    0 }, /* (300) agg_func_opt ::= */
  {  399,   -1 }, /* (301) agg_func_opt ::= AGGREGATE */
  {  400,    0 }, /* (302) bufsize_opt ::= */
  {  400,   -2 }, /* (303) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (304) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (305) cmd ::= DROP STREAM exists_opt stream_name */
  {  403,    0 }, /* (306) col_list_opt ::= */
  {  403,   -3 }, /* (307) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  404,    0 }, /* (308) tag_def_or_ref_opt ::= */
  {  404,   -1 }, /* (309) tag_def_or_ref_opt ::= tags_def */
  {  404,   -4 }, /* (310) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  402,    0 }, /* (311) stream_options ::= */
  {  402,   -3 }, /* (312) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  402,   -3 }, /* (313) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  402,   -4 }, /* (314) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  402,   -3 }, /* (315) stream_options ::= stream_options WATERMARK duration_literal */
  {  402,   -4 }, /* (316) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  402,   -3 }, /* (317) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  405,    0 }, /* (318) subtable_opt ::= */
  {  405,   -4 }, /* (319) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (320) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (321) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (322) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (323) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (324) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (325) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (326) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  407,   -2 }, /* (327) dnode_list ::= DNODE NK_INTEGER */
  {  407,   -3 }, /* (328) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (329) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (330) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (331) cmd ::= insert_query */
  {  398,   -7 }, /* (332) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  398,   -4 }, /* (333) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (334) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (335) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (336) literal ::= NK_STRING */
  {  331,   -1 }, /* (337) literal ::= NK_BOOL */
  {  331,   -2 }, /* (338) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (339) literal ::= duration_literal */
  {  331,   -1 }, /* (340) literal ::= NULL */
  {  331,   -1 }, /* (341) literal ::= NK_QUESTION */
  {  375,   -1 }, /* (342) duration_literal ::= NK_VARIABLE */
  {  409,   -1 }, /* (343) signed ::= NK_INTEGER */
  {  409,   -2 }, /* (344) signed ::= NK_PLUS NK_INTEGER */
  {  409,   -2 }, /* (345) signed ::= NK_MINUS NK_INTEGER */
  {  409,   -1 }, /* (346) signed ::= NK_FLOAT */
  {  409,   -2 }, /* (347) signed ::= NK_PLUS NK_FLOAT */
  {  409,   -2 }, /* (348) signed ::= NK_MINUS NK_FLOAT */
  {  364,   -1 }, /* (349) signed_literal ::= signed */
  {  364,   -1 }, /* (350) signed_literal ::= NK_STRING */
  {  364,   -1 }, /* (351) signed_literal ::= NK_BOOL */
  {  364,   -2 }, /* (352) signed_literal ::= TIMESTAMP NK_STRING */
  {  364,   -1 }, /* (353) signed_literal ::= duration_literal */
  {  364,   -1 }, /* (354) signed_literal ::= NULL */
  {  364,   -1 }, /* (355) signed_literal ::= literal_func */
  {  364,   -1 }, /* (356) signed_literal ::= NK_QUESTION */
  {  411,   -1 }, /* (357) literal_list ::= signed_literal */
  {  411,   -3 }, /* (358) literal_list ::= literal_list NK_COMMA signed_literal */
  {  339,   -1 }, /* (359) db_name ::= NK_ID */
  {  370,   -1 }, /* (360) table_name ::= NK_ID */
  {  362,   -1 }, /* (361) column_name ::= NK_ID */
  {  377,   -1 }, /* (362) function_name ::= NK_ID */
  {  412,   -1 }, /* (363) table_alias ::= NK_ID */
  {  385,   -1 }, /* (364) column_alias ::= NK_ID */
  {  333,   -1 }, /* (365) user_name ::= NK_ID */
  {  340,   -1 }, /* (366) topic_name ::= NK_ID */
  {  401,   -1 }, /* (367) stream_name ::= NK_ID */
  {  395,   -1 }, /* (368) cgroup_name ::= NK_ID */
  {  388,   -1 }, /* (369) index_name ::= NK_ID */
  {  413,   -1 }, /* (370) expr_or_subquery ::= expression */
  {  406,   -1 }, /* (371) expression ::= literal */
  {  406,   -1 }, /* (372) expression ::= pseudo_column */
  {  406,   -1 }, /* (373) expression ::= column_reference */
  {  406,   -1 }, /* (374) expression ::= function_expression */
  {  406,   -1 }, /* (375) expression ::= case_when_expression */
  {  406,   -3 }, /* (376) expression ::= NK_LP expression NK_RP */
  {  406,   -2 }, /* (377) expression ::= NK_PLUS expr_or_subquery */
  {  406,   -2 }, /* (378) expression ::= NK_MINUS expr_or_subquery */
  {  406,   -3 }, /* (379) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  406,   -3 }, /* (380) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  406,   -3 }, /* (381) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  406,   -3 }, /* (382) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  406,   -3 }, /* (383) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  406,   -3 }, /* (384) expression ::= column_reference NK_ARROW NK_STRING */
  {  406,   -3 }, /* (385) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  406,   -3 }, /* (386) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  367,   -1 }, /* (387) expression_list ::= expr_or_subquery */
  {  367,   -3 }, /* (388) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  415,   -1 }, /* (389) column_reference ::= column_name */
  {  415,   -3 }, /* (390) column_reference ::= table_name NK_DOT column_name */
  {  414,   -1 }, /* (391) pseudo_column ::= ROWTS */
  {  414,   -1 }, /* (392) pseudo_column ::= TBNAME */
  {  414,   -3 }, /* (393) pseudo_column ::= table_name NK_DOT TBNAME */
  {  414,   -1 }, /* (394) pseudo_column ::= QSTART */
  {  414,   -1 }, /* (395) pseudo_column ::= QEND */
  {  414,   -1 }, /* (396) pseudo_column ::= QDURATION */
  {  414,   -1 }, /* (397) pseudo_column ::= WSTART */
  {  414,   -1 }, /* (398) pseudo_column ::= WEND */
  {  414,   -1 }, /* (399) pseudo_column ::= WDURATION */
  {  414,   -1 }, /* (400) pseudo_column ::= IROWTS */
  {  414,   -1 }, /* (401) pseudo_column ::= ISFILLED */
  {  414,   -1 }, /* (402) pseudo_column ::= QTAGS */
  {  416,   -4 }, /* (403) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  416,   -4 }, /* (404) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  416,   -6 }, /* (405) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  416,   -1 }, /* (406) function_expression ::= literal_func */
  {  410,   -3 }, /* (407) literal_func ::= noarg_func NK_LP NK_RP */
  {  410,   -1 }, /* (408) literal_func ::= NOW */
  {  420,   -1 }, /* (409) noarg_func ::= NOW */
  {  420,   -1 }, /* (410) noarg_func ::= TODAY */
  {  420,   -1 }, /* (411) noarg_func ::= TIMEZONE */
  {  420,   -1 }, /* (412) noarg_func ::= DATABASE */
  {  420,   -1 }, /* (413) noarg_func ::= CLIENT_VERSION */
  {  420,   -1 }, /* (414) noarg_func ::= SERVER_VERSION */
  {  420,   -1 }, /* (415) noarg_func ::= SERVER_STATUS */
  {  420,   -1 }, /* (416) noarg_func ::= CURRENT_USER */
  {  420,   -1 }, /* (417) noarg_func ::= USER */
  {  418,   -1 }, /* (418) star_func ::= COUNT */
  {  418,   -1 }, /* (419) star_func ::= FIRST */
  {  418,   -1 }, /* (420) star_func ::= LAST */
  {  418,   -1 }, /* (421) star_func ::= LAST_ROW */
  {  419,   -1 }, /* (422) star_func_para_list ::= NK_STAR */
  {  419,   -1 }, /* (423) star_func_para_list ::= other_para_list */
  {  421,   -1 }, /* (424) other_para_list ::= star_func_para */
  {  421,   -3 }, /* (425) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  422,   -1 }, /* (426) star_func_para ::= expr_or_subquery */
  {  422,   -3 }, /* (427) star_func_para ::= table_name NK_DOT NK_STAR */
  {  417,   -4 }, /* (428) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  417,   -5 }, /* (429) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  423,   -1 }, /* (430) when_then_list ::= when_then_expr */
  {  423,   -2 }, /* (431) when_then_list ::= when_then_list when_then_expr */
  {  426,   -4 }, /* (432) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  424,    0 }, /* (433) case_when_else_opt ::= */
  {  424,   -2 }, /* (434) case_when_else_opt ::= ELSE common_expression */
  {  427,   -3 }, /* (435) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  427,   -5 }, /* (436) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  427,   -6 }, /* (437) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  427,   -3 }, /* (438) predicate ::= expr_or_subquery IS NULL */
  {  427,   -4 }, /* (439) predicate ::= expr_or_subquery IS NOT NULL */
  {  427,   -3 }, /* (440) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  428,   -1 }, /* (441) compare_op ::= NK_LT */
  {  428,   -1 }, /* (442) compare_op ::= NK_GT */
  {  428,   -1 }, /* (443) compare_op ::= NK_LE */
  {  428,   -1 }, /* (444) compare_op ::= NK_GE */
  {  428,   -1 }, /* (445) compare_op ::= NK_NE */
  {  428,   -1 }, /* (446) compare_op ::= NK_EQ */
  {  428,   -1 }, /* (447) compare_op ::= LIKE */
  {  428,   -2 }, /* (448) compare_op ::= NOT LIKE */
  {  428,   -1 }, /* (449) compare_op ::= MATCH */
  {  428,   -1 }, /* (450) compare_op ::= NMATCH */
  {  428,   -1 }, /* (451) compare_op ::= CONTAINS */
  {  429,   -1 }, /* (452) in_op ::= IN */
  {  429,   -2 }, /* (453) in_op ::= NOT IN */
  {  430,   -3 }, /* (454) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  431,   -1 }, /* (455) boolean_value_expression ::= boolean_primary */
  {  431,   -2 }, /* (456) boolean_value_expression ::= NOT boolean_primary */
  {  431,   -3 }, /* (457) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  431,   -3 }, /* (458) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  432,   -1 }, /* (459) boolean_primary ::= predicate */
  {  432,   -3 }, /* (460) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  425,   -1 }, /* (461) common_expression ::= expr_or_subquery */
  {  425,   -1 }, /* (462) common_expression ::= boolean_value_expression */
  {  433,    0 }, /* (463) from_clause_opt ::= */
  {  433,   -2 }, /* (464) from_clause_opt ::= FROM table_reference_list */
  {  434,   -1 }, /* (465) table_reference_list ::= table_reference */
  {  434,   -3 }, /* (466) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  435,   -1 }, /* (467) table_reference ::= table_primary */
  {  435,   -1 }, /* (468) table_reference ::= joined_table */
  {  436,   -2 }, /* (469) table_primary ::= table_name alias_opt */
  {  436,   -4 }, /* (470) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  436,   -2 }, /* (471) table_primary ::= subquery alias_opt */
  {  436,   -1 }, /* (472) table_primary ::= parenthesized_joined_table */
  {  438,    0 }, /* (473) alias_opt ::= */
  {  438,   -1 }, /* (474) alias_opt ::= table_alias */
  {  438,   -2 }, /* (475) alias_opt ::= AS table_alias */
  {  440,   -3 }, /* (476) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  440,   -3 }, /* (477) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  437,   -6 }, /* (478) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  441,    0 }, /* (479) join_type ::= */
  {  441,   -1 }, /* (480) join_type ::= INNER */
  {  443,  -12 }, /* (481) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  444,    0 }, /* (482) set_quantifier_opt ::= */
  {  444,   -1 }, /* (483) set_quantifier_opt ::= DISTINCT */
  {  444,   -1 }, /* (484) set_quantifier_opt ::= ALL */
  {  445,   -1 }, /* (485) select_list ::= select_item */
  {  445,   -3 }, /* (486) select_list ::= select_list NK_COMMA select_item */
  {  453,   -1 }, /* (487) select_item ::= NK_STAR */
  {  453,   -1 }, /* (488) select_item ::= common_expression */
  {  453,   -2 }, /* (489) select_item ::= common_expression column_alias */
  {  453,   -3 }, /* (490) select_item ::= common_expression AS column_alias */
  {  453,   -3 }, /* (491) select_item ::= table_name NK_DOT NK_STAR */
  {  408,    0 }, /* (492) where_clause_opt ::= */
  {  408,   -2 }, /* (493) where_clause_opt ::= WHERE search_condition */
  {  446,    0 }, /* (494) partition_by_clause_opt ::= */
  {  446,   -3 }, /* (495) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  454,   -1 }, /* (496) partition_list ::= partition_item */
  {  454,   -3 }, /* (497) partition_list ::= partition_list NK_COMMA partition_item */
  {  455,   -1 }, /* (498) partition_item ::= expr_or_subquery */
  {  455,   -2 }, /* (499) partition_item ::= expr_or_subquery column_alias */
  {  455,   -3 }, /* (500) partition_item ::= expr_or_subquery AS column_alias */
  {  450,    0 }, /* (501) twindow_clause_opt ::= */
  {  450,   -6 }, /* (502) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  450,   -4 }, /* (503) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  450,   -6 }, /* (504) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  450,   -8 }, /* (505) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  450,   -7 }, /* (506) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  390,    0 }, /* (507) sliding_opt ::= */
  {  390,   -4 }, /* (508) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  449,    0 }, /* (509) fill_opt ::= */
  {  449,   -4 }, /* (510) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  449,   -6 }, /* (511) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  449,   -6 }, /* (512) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  456,   -1 }, /* (513) fill_mode ::= NONE */
  {  456,   -1 }, /* (514) fill_mode ::= PREV */
  {  456,   -1 }, /* (515) fill_mode ::= NULL */
  {  456,   -1 }, /* (516) fill_mode ::= NULL_F */
  {  456,   -1 }, /* (517) fill_mode ::= LINEAR */
  {  456,   -1 }, /* (518) fill_mode ::= NEXT */
  {  451,    0 }, /* (519) group_by_clause_opt ::= */
  {  451,   -3 }, /* (520) group_by_clause_opt ::= GROUP BY group_by_list */
  {  457,   -1 }, /* (521) group_by_list ::= expr_or_subquery */
  {  457,   -3 }, /* (522) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  452,    0 }, /* (523) having_clause_opt ::= */
  {  452,   -2 }, /* (524) having_clause_opt ::= HAVING search_condition */
  {  447,    0 }, /* (525) range_opt ::= */
  {  447,   -6 }, /* (526) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  448,    0 }, /* (527) every_opt ::= */
  {  448,   -4 }, /* (528) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  458,   -4 }, /* (529) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  459,   -1 }, /* (530) query_simple ::= query_specification */
  {  459,   -1 }, /* (531) query_simple ::= union_query_expression */
  {  463,   -4 }, /* (532) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  463,   -3 }, /* (533) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  464,   -1 }, /* (534) query_simple_or_subquery ::= query_simple */
  {  464,   -1 }, /* (535) query_simple_or_subquery ::= subquery */
  {  394,   -1 }, /* (536) query_or_subquery ::= query_expression */
  {  394,   -1 }, /* (537) query_or_subquery ::= subquery */
  {  460,    0 }, /* (538) order_by_clause_opt ::= */
  {  460,   -3 }, /* (539) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  461,    0 }, /* (540) slimit_clause_opt ::= */
  {  461,   -2 }, /* (541) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  461,   -4 }, /* (542) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  461,   -4 }, /* (543) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  462,    0 }, /* (544) limit_clause_opt ::= */
  {  462,   -2 }, /* (545) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  462,   -4 }, /* (546) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  462,   -4 }, /* (547) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  439,   -3 }, /* (548) subquery ::= NK_LP query_expression NK_RP */
  {  439,   -3 }, /* (549) subquery ::= NK_LP subquery NK_RP */
  {  442,   -1 }, /* (550) search_condition ::= common_expression */
  {  465,   -1 }, /* (551) sort_specification_list ::= sort_specification */
  {  465,   -3 }, /* (552) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  466,   -3 }, /* (553) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  467,    0 }, /* (554) ordering_specification_opt ::= */
  {  467,   -1 }, /* (555) ordering_specification_opt ::= ASC */
  {  467,   -1 }, /* (556) ordering_specification_opt ::= DESC */
  {  468,    0 }, /* (557) null_ordering_opt ::= */
  {  468,   -2 }, /* (558) null_ordering_opt ::= NULLS FIRST */
  {  468,   -2 }, /* (559) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy0, yymsp[0].minor.yy705); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy705 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy705 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy641, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy641, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy641 = yymsp[0].minor.yy641; }
  yymsp[0].minor.yy641 = yylhsminor.yy641;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy641 = yymsp[-2].minor.yy641 | yymsp[0].minor.yy641; }
  yymsp[-2].minor.yy641 = yylhsminor.yy641;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy641 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy225 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy225 = yylhsminor.yy225;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy225 = yymsp[-2].minor.yy225; }
  yymsp[-2].minor.yy225 = yylhsminor.yy225;
        break;
      case 42: /* priv_level ::= topic_name */
      case 272: /* sma_func_name ::= function_name */ yytestcase(yyruleno==272);
      case 474: /* alias_opt ::= table_alias */ yytestcase(yyruleno==474);
{ yylhsminor.yy225 = yymsp[0].minor.yy225; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy225, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy103); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy103); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 273: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==273);
      case 274: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= LAST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==276);
      case 359: /* db_name ::= NK_ID */ yytestcase(yyruleno==359);
      case 360: /* table_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* column_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* function_name ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* table_alias ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* column_alias ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* user_name ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* topic_name ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* stream_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 368: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==368);
      case 369: /* index_name ::= NK_ID */ yytestcase(yyruleno==369);
      case 409: /* noarg_func ::= NOW */ yytestcase(yyruleno==409);
      case 410: /* noarg_func ::= TODAY */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==413);
      case 414: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==415);
      case 416: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==416);
      case 417: /* noarg_func ::= USER */ yytestcase(yyruleno==417);
      case 418: /* star_func ::= COUNT */ yytestcase(yyruleno==418);
      case 419: /* star_func ::= FIRST */ yytestcase(yyruleno==419);
      case 420: /* star_func ::= LAST */ yytestcase(yyruleno==420);
      case 421: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==421);
{ yylhsminor.yy225 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 293: /* analyze_opt ::= */ yytestcase(yyruleno==293);
      case 300: /* agg_func_opt ::= */ yytestcase(yyruleno==300);
      case 482: /* set_quantifier_opt ::= */ yytestcase(yyruleno==482);
{ yymsp[1].minor.yy103 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 294: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==301);
      case 483: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==483);
{ yymsp[0].minor.yy103 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy103, &yymsp[-1].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy508); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy103 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy103 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy42 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_KEEP, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_RETENTIONS, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-3].minor.yy42, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-3].minor.yy42, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy42 = setDatabaseOption(pCxt, yymsp[-2].minor.yy42, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy42 = createAlterDatabaseOptions(pCxt); yylhsminor.yy42 = setAlterDatabaseOption(pCxt, yylhsminor.yy42, &yymsp[0].minor.yy459); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy42 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy42, &yymsp[0].minor.yy459); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy459.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy459.type = DB_OPTION_KEEP; yymsp[-1].minor.yy459.pList = yymsp[0].minor.yy110; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_PAGES; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_WAL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy459.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy110 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 328: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==328);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy110 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 255: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==255);
      case 269: /* func_list ::= func */ yytestcase(yyruleno==269);
      case 357: /* literal_list ::= signed_literal */ yytestcase(yyruleno==357);
      case 424: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==424);
      case 430: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==430);
      case 485: /* select_list ::= select_item */ yytestcase(yyruleno==485);
      case 496: /* partition_list ::= partition_item */ yytestcase(yyruleno==496);
      case 551: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==551);
{ yylhsminor.yy110 = createNodeList(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==270);
      case 358: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==358);
      case 425: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==425);
      case 486: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==486);
      case 497: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==497);
      case 552: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==552);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy42 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 126: /* speed_opt ::= */
      case 302: /* bufsize_opt ::= */ yytestcase(yyruleno==302);
{ yymsp[1].minor.yy508 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 303: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==303);
{ yymsp[-1].minor.yy508 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy103, yymsp[-5].minor.yy42, yymsp[-3].minor.yy110, yymsp[-1].minor.yy110, yymsp[0].minor.yy42); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy110); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy110); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 330: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==330);
      case 331: /* cmd ::= insert_query */ yytestcase(yyruleno==331);
{ pCxt->pRootNode = yymsp[0].minor.yy42; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy42); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy42 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy42 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy42, &yymsp[-2].minor.yy225, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 431: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==431);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-1].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy110 = yylhsminor.yy110;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy42 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy103, yymsp[-8].minor.yy42, yymsp[-6].minor.yy42, yymsp[-5].minor.yy110, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
  yymsp[-9].minor.yy42 = yylhsminor.yy42;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy42 = createDropTableClause(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 254: /* tag_list_opt ::= */ yytestcase(yyruleno==254);
      case 306: /* col_list_opt ::= */ yytestcase(yyruleno==306);
      case 308: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==308);
      case 494: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==494);
      case 519: /* group_by_clause_opt ::= */ yytestcase(yyruleno==519);
      case 538: /* order_by_clause_opt ::= */ yytestcase(yyruleno==538);
{ yymsp[1].minor.yy110 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 307: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==307);
{ yymsp[-2].minor.yy110 = yymsp[-1].minor.yy110; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448, NULL); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 309: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==309);
      case 423: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==423);
{ yylhsminor.yy110 = yymsp[0].minor.yy110; }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 310: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==310);
{ yymsp[-3].minor.yy110 = yymsp[-1].minor.yy110; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy42 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-4].minor.yy42, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy110); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-4].minor.yy42, TABLE_OPTION_SMA, yymsp[-1].minor.yy110); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-2].minor.yy42, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy110); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy42 = createAlterTableOptions(pCxt); yylhsminor.yy42 = setTableOption(pCxt, yylhsminor.yy42, yymsp[0].minor.yy459.type, &yymsp[0].minor.yy459.val); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy42 = setTableOption(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy459.type, &yymsp[0].minor.yy459.val); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy459.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy459.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy459.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 387: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==387);
{ yylhsminor.yy110 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 388: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==388);
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 258: /* tag_item ::= QTAGS */ yytestcase(yyruleno==258);
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 206: /* col_name ::= column_name */
      case 259: /* tag_item ::= column_name */ yytestcase(yyruleno==259);
{ yylhsminor.yy42 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy42, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy42, yymsp[-1].minor.yy42, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy42); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy42); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy42, yymsp[-1].minor.yy42, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42, yymsp[-3].minor.yy110); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy42,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 247: /* db_name_cond_opt ::= */
      case 252: /* from_db_opt ::= */ yytestcase(yyruleno==252);
{ yymsp[1].minor.yy42 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 248: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy42 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 249: /* like_pattern_opt ::= */
      case 318: /* subtable_opt ::= */ yytestcase(yyruleno==318);
      case 433: /* case_when_else_opt ::= */ yytestcase(yyruleno==433);
      case 463: /* from_clause_opt ::= */ yytestcase(yyruleno==463);
      case 492: /* where_clause_opt ::= */ yytestcase(yyruleno==492);
      case 501: /* twindow_clause_opt ::= */ yytestcase(yyruleno==501);
      case 507: /* sliding_opt ::= */ yytestcase(yyruleno==507);
      case 509: /* fill_opt ::= */ yytestcase(yyruleno==509);
      case 523: /* having_clause_opt ::= */ yytestcase(yyruleno==523);
      case 525: /* range_opt ::= */ yytestcase(yyruleno==525);
      case 527: /* every_opt ::= */ yytestcase(yyruleno==527);
      case 540: /* slimit_clause_opt ::= */ yytestcase(yyruleno==540);
      case 544: /* limit_clause_opt ::= */ yytestcase(yyruleno==544);
{ yymsp[1].minor.yy42 = NULL; }
        break;
      case 250: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 251: /* table_name_cond ::= table_name */
{ yylhsminor.yy42 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 253: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy42 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 257: /* tag_item ::= TBNAME */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 260: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy225), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 261: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy225), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 262: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy103, yymsp[-3].minor.yy42, yymsp[-1].minor.yy42, NULL, yymsp[0].minor.yy42); }
        break;
      case 263: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy103, yymsp[-5].minor.yy42, yymsp[-3].minor.yy42, yymsp[-1].minor.yy110, NULL); }
        break;
      case 264: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy103, yymsp[0].minor.yy42); }
        break;
      case 265: /* full_index_name ::= index_name */
{ yylhsminor.yy42 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 266: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy42 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 267: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy42 = createIndexOption(pCxt, yymsp[-7].minor.yy110, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy42 = createIndexOption(pCxt, yymsp[-9].minor.yy110, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 271: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy110); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 277: /* sma_stream_opt ::= */
      case 311: /* stream_options ::= */ yytestcase(yyruleno==311);
{ yymsp[1].minor.yy42 = createStreamOptions(pCxt); }
        break;
      case 278: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 315: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==315);
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy103, &yymsp[-2].minor.yy225, yymsp[0].minor.yy42); }
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy103, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy225, false); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy103, &yymsp[-5].minor.yy225, &yymsp[0].minor.yy225, true); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy103, &yymsp[-3].minor.yy225, yymsp[0].minor.yy42, false); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy103, &yymsp[-5].minor.yy225, yymsp[0].minor.yy42, true); }
        break;
      case 286: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 287: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy103, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 288: /* cmd ::= DESC full_table_name */
      case 289: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==289);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy42); }
        break;
      case 290: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 291: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==292);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy103, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 295: /* explain_options ::= */
{ yymsp[1].minor.yy42 = createDefaultExplainOptions(pCxt); }
        break;
      case 296: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy42 = setExplainVerbose(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 297: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy42 = setExplainRatio(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 298: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy103, yymsp[-8].minor.yy103, &yymsp[-5].minor.yy225, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy448, yymsp[0].minor.yy508); }
        break;
      case 299: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 304: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy103, &yymsp[-8].minor.yy225, yymsp[-5].minor.yy42, yymsp[-7].minor.yy42, yymsp[-3].minor.yy110, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, yymsp[-4].minor.yy110); }
        break;
      case 305: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy103, &yymsp[0].minor.yy225); }
        break;
      case 312: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 313: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 314: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy42)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy42)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-3].minor.yy42; }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 316: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy42)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy42 = yymsp[-3].minor.yy42; }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 317: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 319: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 508: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==508);
      case 528: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==528);
{ yymsp[-3].minor.yy42 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy42); }
        break;
      case 320: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 321: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 322: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 323: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 324: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 325: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy110); }
        break;
      case 326: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 327: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy110 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 329: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 332: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy42 = createInsertStmt(pCxt, yymsp[-4].minor.yy42, yymsp[-2].minor.yy110, yymsp[0].minor.yy42); }
        break;
      case 333: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy42 = createInsertStmt(pCxt, yymsp[-1].minor.yy42, NULL, yymsp[0].minor.yy42); }
        break;
      case 334: /* literal ::= NK_INTEGER */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 335: /* literal ::= NK_FLOAT */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 336: /* literal ::= NK_STRING */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 337: /* literal ::= NK_BOOL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 338: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 339: /* literal ::= duration_literal */
      case 349: /* signed_literal ::= signed */ yytestcase(yyruleno==349);
      case 370: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==370);
      case 371: /* expression ::= literal */ yytestcase(yyruleno==371);
      case 372: /* expression ::= pseudo_column */ yytestcase(yyruleno==372);
      case 373: /* expression ::= column_reference */ yytestcase(yyruleno==373);
      case 374: /* expression ::= function_expression */ yytestcase(yyruleno==374);
      case 375: /* expression ::= case_when_expression */ yytestcase(yyruleno==375);
      case 406: /* function_expression ::= literal_func */ yytestcase(yyruleno==406);
      case 455: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==455);
      case 459: /* boolean_primary ::= predicate */ yytestcase(yyruleno==459);
      case 461: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==461);
      case 462: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==462);
      case 465: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==465);
      case 467: /* table_reference ::= table_primary */ yytestcase(yyruleno==467);
      case 468: /* table_reference ::= joined_table */ yytestcase(yyruleno==468);
      case 472: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==472);
      case 530: /* query_simple ::= query_specification */ yytestcase(yyruleno==530);
      case 531: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==531);
      case 534: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==534);
      case 536: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==536);
{ yylhsminor.yy42 = yymsp[0].minor.yy42; }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 340: /* literal ::= NULL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 341: /* literal ::= NK_QUESTION */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 342: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 343: /* signed ::= NK_INTEGER */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 344: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 345: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 346: /* signed ::= NK_FLOAT */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 347: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 348: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 350: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 351: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 352: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 353: /* signed_literal ::= duration_literal */
      case 355: /* signed_literal ::= literal_func */ yytestcase(yyruleno==355);
      case 426: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==426);
      case 488: /* select_item ::= common_expression */ yytestcase(yyruleno==488);
      case 498: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==498);
      case 535: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==535);
      case 537: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==537);
      case 550: /* search_condition ::= common_expression */ yytestcase(yyruleno==550);
{ yylhsminor.yy42 = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 354: /* signed_literal ::= NULL */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 356: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy42 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 376: /* expression ::= NK_LP expression NK_RP */
      case 460: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==460);
      case 549: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==549);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 377: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy42));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 378: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 379: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 380: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 381: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 382: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 383: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 384: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 385: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 386: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 389: /* column_reference ::= column_name */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy225, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 390: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 391: /* pseudo_column ::= ROWTS */
      case 392: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==392);
      case 394: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==394);
      case 395: /* pseudo_column ::= QEND */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= WEND */ yytestcase(yyruleno==398);
      case 399: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==400);
      case 401: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==401);
      case 402: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==402);
      case 408: /* literal_func ::= NOW */ yytestcase(yyruleno==408);
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 393: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy225)))); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 403: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 404: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==404);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy110)); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 405: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy448)); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 407: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy225, NULL)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 422: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy110 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 427: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 491: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==491);
{ yylhsminor.yy42 = createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 428: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy110, yymsp[-1].minor.yy42)); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 429: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-2].minor.yy110, yymsp[-1].minor.yy42)); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 432: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy42 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
        break;
      case 434: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy42 = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); }
        break;
      case 435: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 440: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==440);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy2, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 436: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 437: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 438: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), NULL));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 439: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL));
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 441: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy2 = OP_TYPE_LOWER_THAN; }
        break;
      case 442: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy2 = OP_TYPE_GREATER_THAN; }
        break;
      case 443: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy2 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 444: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy2 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 445: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy2 = OP_TYPE_NOT_EQUAL; }
        break;
      case 446: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy2 = OP_TYPE_EQUAL; }
        break;
      case 447: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy2 = OP_TYPE_LIKE; }
        break;
      case 448: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy2 = OP_TYPE_NOT_LIKE; }
        break;
      case 449: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy2 = OP_TYPE_MATCH; }
        break;
      case 450: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy2 = OP_TYPE_NMATCH; }
        break;
      case 451: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy2 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 452: /* in_op ::= IN */
{ yymsp[0].minor.yy2 = OP_TYPE_IN; }
        break;
      case 453: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy2 = OP_TYPE_NOT_IN; }
        break;
      case 454: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 456: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 457: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 458: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 464: /* from_clause_opt ::= FROM table_reference_list */
      case 493: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==493);
      case 524: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==524);
{ yymsp[-1].minor.yy42 = yymsp[0].minor.yy42; }
        break;
      case 466: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 469: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 470: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 471: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy42 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 473: /* alias_opt ::= */
{ yymsp[1].minor.yy225 = nil_token;  }
        break;
      case 475: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy225 = yymsp[0].minor.yy225; }
        break;
      case 476: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 477: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==477);
{ yymsp[-2].minor.yy42 = yymsp[-1].minor.yy42; }
        break;
      case 478: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, yymsp[-4].minor.yy638, yymsp[-5].minor.yy42, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 479: /* join_type ::= */
{ yymsp[1].minor.yy638 = JOIN_TYPE_INNER; }
        break;
      case 480: /* join_type ::= INNER */
{ yymsp[0].minor.yy638 = JOIN_TYPE_INNER; }
        break;
      case 481: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy42 = createSelectStmt(pCxt, yymsp[-10].minor.yy103, yymsp[-9].minor.yy110, yymsp[-8].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addWhereClause(pCxt, yymsp[-11].minor.yy42, yymsp[-7].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addPartitionByClause(pCxt, yymsp[-11].minor.yy42, yymsp[-6].minor.yy110);
                                                                                    yymsp[-11].minor.yy42 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy42, yymsp[-2].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addGroupByClause(pCxt, yymsp[-11].minor.yy42, yymsp[-1].minor.yy110);
                                                                                    yymsp[-11].minor.yy42 = addHavingClause(pCxt, yymsp[-11].minor.yy42, yymsp[0].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addRangeClause(pCxt, yymsp[-11].minor.yy42, yymsp[-5].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addEveryClause(pCxt, yymsp[-11].minor.yy42, yymsp[-4].minor.yy42);
                                                                                    yymsp[-11].minor.yy42 = addFillClause(pCxt, yymsp[-11].minor.yy42, yymsp[-3].minor.yy42);
                                                                                  }
        break;
      case 484: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy103 = false; }
        break;
      case 487: /* select_item ::= NK_STAR */
{ yylhsminor.yy42 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 489: /* select_item ::= common_expression column_alias */
      case 499: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==499);
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 490: /* select_item ::= common_expression AS column_alias */
      case 500: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==500);
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 495: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 520: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==520);
      case 539: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==539);
{ yymsp[-2].minor.yy110 = yymsp[0].minor.yy110; }
        break;
      case 502: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy42 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 503: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy42 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 504: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 505: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 506: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy42 = createEventWindowNode(pCxt, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 510: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy42 = createFillNode(pCxt, yymsp[-1].minor.yy410, NULL); }
        break;
      case 511: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy42 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
        break;
      case 512: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy42 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy110)); }
        break;
      case 513: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy410 = FILL_MODE_NONE; }
        break;
      case 514: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy410 = FILL_MODE_PREV; }
        break;
      case 515: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy410 = FILL_MODE_NULL; }
        break;
      case 516: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy410 = FILL_MODE_NULL_F; }
        break;
      case 517: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy410 = FILL_MODE_LINEAR; }
        break;
      case 518: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy410 = FILL_MODE_NEXT; }
        break;
      case 521: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy110 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[0].minor.yy110 = yylhsminor.yy110;
        break;
      case 522: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy110 = addNodeToList(pCxt, yymsp[-2].minor.yy110, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[-2].minor.yy110 = yylhsminor.yy110;
        break;
      case 526: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy42 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 529: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy42 = addOrderByClause(pCxt, yymsp[-3].minor.yy42, yymsp[-2].minor.yy110);
                                                                                    yylhsminor.yy42 = addSlimitClause(pCxt, yylhsminor.yy42, yymsp[-1].minor.yy42);
                                                                                    yylhsminor.yy42 = addLimitClause(pCxt, yylhsminor.yy42, yymsp[0].minor.yy42);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 532: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy42 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 533: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy42 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 541: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 545: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==545);
{ yymsp[-1].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 542: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 546: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==546);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 543: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 547: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==547);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 548: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy42); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 553: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy42 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), yymsp[-1].minor.yy106, yymsp[0].minor.yy599); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 554: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy106 = ORDER_ASC; }
        break;
      case 555: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy106 = ORDER_ASC; }
        break;
      case 556: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy106 = ORDER_DESC; }
        break;
      case 557: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy599 = NULL_ORDER_DEFAULT; }
        break;
      case 558: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy599 = NULL_ORDER_FIRST; }
        break;
      case 559: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy599 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
