/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 447
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int64_t yy57;
  EJoinType yy114;
  SNodeList* yy148;
  int8_t yy167;
  int32_t yy172;
  bool yy287;
  SAlterOption yy323;
  EOrder yy362;
  SNode* yy392;
  SToken yy677;
  EFillMode yy708;
  EOperatorType yy758;
  ENullOrder yy781;
  SDataType yy838;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             689
#define YYNRULE              518
#define YYNTOKEN             315
#define YY_MAX_SHIFT         688
#define YY_MIN_SHIFTREDUCE   1016
#define YY_MAX_SHIFTREDUCE   1533
#define YY_ERROR_ACTION      1534
#define YY_ACCEPT_ACTION     1535
#define YY_NO_ACTION         1536
#define YY_MIN_REDUCE        1537
#define YY_MAX_REDUCE        2054
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2818)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1858, 1560,  443, 1858,  444, 1572,  451, 1872,  444, 1572,
 /*    10 */  1675, 1854,   44,   42, 1854,  351,   13,   12, 1729, 1731,
 /*    20 */   346, 1854, 1316,   43,   41,   40,   39,   38, 1342, 2030,
 /*    30 */   155,   77, 1549, 1394, 1049, 1314, 1890, 1850, 1856,  334,
 /*    40 */  1850, 1856,  340, 1840,  582,  125, 1343, 1850, 1856, 1840,
 /*    50 */   588,  594,   30,  588, 1679,  542, 1389, 1929,   37,   36,
 /*    60 */   588,   17,   43,   41,   40,   39,   38, 1872, 1322,   44,
 /*    70 */    42, 1464, 1870,  581, 1053, 1054, 1904,  346,  566, 1316,
 /*    80 */    97, 1871, 1873,  598, 1875, 1876,  593, 1066,  588, 1065,
 /*    90 */  1394,   62, 1314,  167,    1, 1957, 1890,   34,  265,  339,
 /*   100 */  1953,  166,  479,  581,  595,  578, 1341, 2025, 1736, 1840,
 /*   110 */  1437,  594,  172, 1389, 1723,  333,  685, 1067,   17,  527,
 /*   120 */  1983, 1523,  565,  170, 1734, 1322,  331, 2026,  567, 1784,
 /*   130 */  1396, 1397,  596,  460,  132,  179, 1904, 1538, 1211, 1212,
 /*   140 */    98,  345, 1873,  598, 1875, 1876,  593,   46,  588, 1890,
 /*   150 */   442,    1, 1066,  446, 1065, 1957,   58,  560,  109,  312,
 /*   160 */  1953,  108,  107,  106,  105,  104,  103,  102,  101,  100,
 /*   170 */  2025,  130,   74,  685, 1972,   73, 1317,   46, 1315,   47,
 /*   180 */    58,   58, 1067,    7, 1559,  565,  170, 1396, 1397,  264,
 /*   190 */  2026,  567,  580,  168, 1965, 1966,  559, 1970, 1730, 1731,
 /*   200 */  1320, 1321, 1969, 1371, 1372, 1374, 1375, 1376, 1377, 1378,
 /*   210 */  1379,  590,  586, 1387, 1388, 1390, 1391, 1392, 1393, 1395,
 /*   220 */  1398,    3,  203, 1537,   37,   36, 1840,  581,   43,   41,
 /*   230 */    40,   39,   38, 1317, 1342, 1315,  160,  231,  232,  173,
 /*   240 */  1468,  477,  473,  469,  465,  202, 1341,  118,  117,  116,
 /*   250 */   115,  114,  113,  112,  111,  110,  391, 1320, 1321,   26,
 /*   260 */  1371, 1372, 1374, 1375, 1376, 1377, 1378, 1379,  590,  586,
 /*   270 */  1387, 1388, 1390, 1391, 1392, 1393, 1395, 1398,    3,   44,
 /*   280 */    42,  485,   78,   77, 1859,  200,   58,  346, 1558, 1316,
 /*   290 */   450, 1490,  173,  446,  308, 1854,  310,  629,  578,  530,
 /*   300 */  1394,  173, 1314,  484,  109,  217, 1680,  108,  107,  106,
 /*   310 */   105,  104,  103,  102,  101,  100,  144,  143,  626,  625,
 /*   320 */   624, 1850, 1856, 1389,  173,  173,  173,  132,   17, 2030,
 /*   330 */  1840, 1872,  225, 1341,  588, 1322,   44,   42, 1736,  553,
 /*   340 */  1488, 1489, 1491, 1492,  346,  350, 1316,  578,  199,  193,
 /*   350 */   448,  198,  561, 1557, 1734,  456, 1339, 1394, 2025, 1314,
 /*   360 */  1890,    1,   79,  310,  130,  540,  530,  384,  582,  383,
 /*   370 */    58,  191,   81, 1840, 2029,  594,  132,  119, 2026, 2028,
 /*   380 */  1389,  380, 1457,  685,  481,   17,  169, 1965, 1966,  142,
 /*   390 */  1970, 1662, 1322, 1404, 1684, 1840, 1870, 1396, 1397, 1341,
 /*   400 */  1904,  382,  378, 1316,   97, 1871, 1873,  598, 1875, 1876,
 /*   410 */   593, 1556,  588,  121,  631,  556, 1314,  167,    1, 1957,
 /*   420 */   623,   37,   36,  339, 1953,   43,   41,   40,   39,   38,
 /*   430 */  1373,  173,   11, 1344,    9,  262, 1965,  577,  428,  576,
 /*   440 */   685,   51, 2025, 1317, 1984, 1315, 1661,  218,  349, 1322,
 /*   450 */  1714,  460,  332, 1840, 1396, 1397,  153,  565,  170, 1659,
 /*   460 */   153, 1555, 2026,  567,  544, 1686, 1929, 1320, 1321, 1686,
 /*   470 */  1371, 1372, 1374, 1375, 1376, 1377, 1378, 1379,  590,  586,
 /*   480 */  1387, 1388, 1390, 1391, 1392, 1393, 1395, 1398,    3,  230,
 /*   490 */    11,   40,   39,   38,  183,  182, 1340,  685,  562,  557,
 /*   500 */  1317,  322, 1315, 1840, 1169,  620,  619,  618, 1173,  617,
 /*   510 */  1175, 1176,  616, 1178,  613,  173, 1184,  610, 1186, 1187,
 /*   520 */   607,  604, 1129, 1787, 1320, 1321, 1554, 1371, 1372, 1374,
 /*   530 */  1375, 1376, 1377, 1378, 1379,  590,  586, 1387, 1388, 1390,
 /*   540 */  1391, 1392, 1393, 1395, 1398,    3,   44,   42,  540, 1294,
 /*   550 */  1295, 2030,  629,   11,  346, 1131, 1316, 1317, 1322, 1315,
 /*   560 */    52,  323, 1343,  321,  320,  629,  483, 1394, 1840, 1314,
 /*   570 */   485,  144,  143,  626,  625,  624,  241, 1684,  507, 1872,
 /*   580 */  2025, 1320, 1321, 1373,  144,  143,  626,  625,  624,  352,
 /*   590 */  1389,  505,  484,  503,  158, 1341, 2029,  153, 1872, 1641,
 /*   600 */  2026, 2027, 1322,   44,   42, 1399, 1686,  540, 1890, 1660,
 /*   610 */  1783,  346,  305, 1316,  643,   94,  595,  490,  489,  175,
 /*   620 */  1553, 1840,  540,  594, 1394, 1736, 1314, 1890,    8,  127,
 /*   630 */   656,  654,  317, 1425,  389,  595, 1684, 1676, 1552, 1551,
 /*   640 */  1840, 1734,  594,  128,  596, 1548, 1928, 1389, 1904,  540,
 /*   650 */   685, 1684,  292,  345, 1873,  598, 1875, 1876,  593, 1322,
 /*   660 */   588,  119, 1840, 1870, 1396, 1397, 1547, 1904,  486,  631,
 /*   670 */   566,   97, 1871, 1873,  598, 1875, 1876,  593, 1684,  588,
 /*   680 */  1840, 1840, 2025, 1546, 2045,    8, 1957, 1840,   37,   36,
 /*   690 */   339, 1953,   43,   41,   40,   39,   38,  565,  170, 2025,
 /*   700 */  1991,   31, 2026,  567,  540,  264, 1344,  685, 1840,  153,
 /*   710 */  1317, 1430, 1315,  570,  565,  170,  390,   32, 1687, 2026,
 /*   720 */   567, 1396, 1397,   37,   36, 1840, 1461,   43,   41,   40,
 /*   730 */    39,   38, 1545, 1684, 1320, 1321, 1544, 1371, 1372, 1374,
 /*   740 */  1375, 1376, 1377, 1378, 1379,  590,  586, 1387, 1388, 1390,
 /*   750 */  1391, 1392, 1393, 1395, 1398,    3,  540,   37,   36, 1972,
 /*   760 */  1535,   43,   41,   40,   39,   38,  518, 1317,  398, 1315,
 /*   770 */  1782,   87,  305,  173, 1840, 1500,   37,   36, 1840, 1373,
 /*   780 */    43,   41,   40,   39,   38, 1684, 1543, 1968, 1542, 1972,
 /*   790 */  1541, 1320, 1321, 1677, 1371, 1372, 1374, 1375, 1376, 1377,
 /*   800 */  1378, 1379,  590,  586, 1387, 1388, 1390, 1391, 1392, 1393,
 /*   810 */  1395, 1398,    3,   44,   42, 1777,  498, 1967, 1053, 1054,
 /*   820 */   361,  346, 1777, 1316, 1977, 1457,  178,  540, 1840,  540,
 /*   830 */  1840,  508, 1840,  181, 1394,  540, 1314,  523,  540,  413,
 /*   840 */  2029,  414,  527,  540, 1480,  216, 1872,  458,  540,  240,
 /*   850 */   459,  627, 1785, 1325, 1727, 1681, 1684, 1389, 1684,  501,
 /*   860 */   136, 1540, 1673,  495, 1684, 1872, 2025, 1684,  215, 1322,
 /*   870 */    44,   42, 1684, 1736, 1550, 1890,  628, 1684,  346, 1727,
 /*   880 */  1316, 2031,  170,  595,  540,   45, 2026,  567, 1840, 1735,
 /*   890 */   594, 1394, 2030, 1314, 1890,    8,  519,  644, 1827, 1654,
 /*   900 */   540, 1669,  595, 1840,  540,   64,  540, 1840,   63,  594,
 /*   910 */   573, 1870,  524, 1684, 1389, 1904,  235,  685,  536,  156,
 /*   920 */  1871, 1873,  598, 1875, 1876,  593, 1322,  588,  571, 1684,
 /*   930 */  1870, 1396, 1397, 1684, 1904, 1684, 1530, 1265,   97, 1871,
 /*   940 */  1873,  598, 1875, 1876,  593,  368,  588,  493,  492,   48,
 /*   950 */     4, 2045,    1, 1957,  126,  392,  277,  339, 1953, 1714,
 /*   960 */   545, 1994, 1460, 1589, 1642,  488,  491, 2019,  393,  540,
 /*   970 */   208,  487,  210,  206,  685,  209,  585, 1317,  385, 1315,
 /*   980 */   526,  538,   50,  522, 1523,  494,   37,   36, 1396, 1397,
 /*   990 */    43,   41,   40,   39,   38,  523, 1328,  523, 1684, 1532,
 /*  1000 */  1533, 1320, 1321, 1671, 1371, 1372, 1374, 1375, 1376, 1377,
 /*  1010 */  1378, 1379,  590,  586, 1387, 1388, 1390, 1391, 1392, 1393,
 /*  1020 */  1395, 1398,    3,  307, 2025, 1339, 2025, 1584, 1582, 1529,
 /*  1030 */   212,  540,  421,  211, 1317,  433, 1315,   13,   12, 2031,
 /*  1040 */   170, 2031,  170,  539, 2026,  567, 2026,  567,  214,  496,
 /*  1050 */   499,  213,  406,  229,  434,  224,  408, 1667, 1320, 1321,
 /*  1060 */  1684, 1371, 1372, 1374, 1375, 1376, 1377, 1378, 1379,  590,
 /*  1070 */   586, 1387, 1388, 1390, 1391, 1392, 1393, 1395, 1398,    3,
 /*  1080 */    37,   36,   60,  137,   43,   41,   40,   39,   38,  154,
 /*  1090 */   540,  540,  637,  569,  283,   80,   93, 1997,  399,  221,
 /*  1100 */   638,  589,  266,  353, 1324,  233,   90,  141,  281,   66,
 /*  1110 */   395, 1599,   65,  259, 1113, 1415,  142,  622,   60, 1684,
 /*  1120 */  1684,  245, 1111, 1861,  554,  478,  253,  574,  187,  439,
 /*  1130 */   437, 1891,  357, 1573, 1431,  533, 1724, 1987,  432, 1093,
 /*  1140 */   578,  427,  426,  425,  424,  423,  420,  419,  418,  417,
 /*  1150 */   416,  412,  411,  410,  409,  403,  402,  401,  400,  237,
 /*  1160 */   397,  396,  319,   45,   45,   58,  261,  602, 1162,  132,
 /*  1170 */  1487, 1863, 1094,  248,  662,  661,  660,  659,  356,  141,
 /*  1180 */   658,  657,  133,  652,  651,  650,  649,  648,  647,  646,
 /*  1190 */   645,  146,  641,  640,  639,  355,  354,  636,  635,  634,
 /*  1200 */   633,  632,  142,   96,   37,   36,  130, 1578,   43,   41,
 /*  1210 */    40,   39,   38,  122, 1872, 1380,  276,    2,  579, 1190,
 /*  1220 */   141,  258,    5,  362,  318,  367, 1281,  273,  171, 1965,
 /*  1230 */  1966, 1194, 1970,  180, 1339,  152,  415,  394, 1779,   71,
 /*  1240 */    70,  388,  422, 1890,  177,  429,  430, 1327,  435,  436,
 /*  1250 */   431,  595,  184,  438, 1201,  680, 1840,  313,  594,  359,
 /*  1260 */   440,  306, 1345,  441,  376, 1199,  374,  370,  366,  363,
 /*  1270 */   360,  449,  145, 1347,  452,  190,  523,  192,  453, 1870,
 /*  1280 */  1346, 1348,  454, 1904,  195,  455, 1872,   97, 1871, 1873,
 /*  1290 */   598, 1875, 1876,  593,  457,  588,  197,   75,  129, 1423,
 /*  1300 */   140, 1928, 1957,   76,  201, 2025,  339, 1953, 1872,  461,
 /*  1310 */   173,  480,  482,  120,  309, 1890, 1674,  205, 1670,  207,
 /*  1320 */  2031,  170,  147,  595,  148, 2026,  567, 1602, 1840, 1672,
 /*  1330 */   594, 1668,  149,  150,  510,  512, 1818, 1890,  274,  219,
 /*  1340 */   514,  513,  517,  222,  520,  595,  525,  226,  552,  528,
 /*  1350 */  1840, 1870,  594,  328, 1424, 1904, 1817, 1789,  138,   97,
 /*  1360 */  1871, 1873,  598, 1875, 1876,  593,  531,  588,  139,  330,
 /*  1370 */   534,  535, 2045, 1870, 1957, 1872,   84, 1904,  339, 1953,
 /*  1380 */   275,   97, 1871, 1873,  598, 1875, 1876,  593, 1976,  588,
 /*  1390 */    86,  493,  492, 1685, 1932, 1344, 1957, 1988,  126,  555,
 /*  1400 */   339, 1953, 1998,  548, 1890,  243,  550,  551,    6,  488,
 /*  1410 */   491,  335,  595,  558,  247,  487,  358, 1840,  564,  594,
 /*  1420 */  2003,  252,   33,  343, 1418, 1419, 1420, 1421, 1422, 1426,
 /*  1430 */  1427, 1428, 1429,  523, 1979, 2002,  549,  547,  336,  254,
 /*  1440 */  1870,  161,  255,  546, 1904,  256,  257, 1872,   97, 1871,
 /*  1450 */  1873,  598, 1875, 1876,  593,  260,  588,  575, 1457,  572,
 /*  1460 */   131, 1930, 2025, 1957, 2024, 1343,   57,  339, 1953, 2048,
 /*  1470 */  1973,  688, 1938,   88,  600, 1728, 1890, 2031,  170, 1655,
 /*  1480 */   278,  269, 2026,  567,  595,  272,  681,  682,  684, 1840,
 /*  1490 */    49,  594,  304,  280, 1834,  282, 1833,   68,  290,  164,
 /*  1500 */  1832, 1831,  301,  300,  678,  674,  670,  666,  270,   69,
 /*  1510 */  1828,  364, 1870,  365, 1308, 1309, 1904,  176,  369, 1826,
 /*  1520 */    97, 1871, 1873,  598, 1875, 1876,  593,  371,  588, 1872,
 /*  1530 */   372,  373, 1825,  543,  375, 1957,  342,  341,  377,  339,
 /*  1540 */  1953, 1824, 1823, 1822,  379,   95, 1330,  381,  238, 1284,
 /*  1550 */  1283, 1800, 1799,  386,  387, 1798, 1797, 1394, 1890, 1323,
 /*  1560 */  1253, 1772, 1771, 1770, 1769,  134,  595, 1768, 1767,  511,
 /*  1570 */    72, 1840, 1766,  594, 1765, 1764, 1763, 1762,  404,  405,
 /*  1580 */  1389,  537, 1761, 1872,  407, 1760,  523, 1759, 1758, 1757,
 /*  1590 */  1756, 1755, 1322, 1255, 1870, 1754, 1753, 1752, 1904, 1751,
 /*  1600 */  1750, 1749,   98, 1871, 1873,  598, 1875, 1876,  593, 1872,
 /*  1610 */   588, 1748, 1890, 1747,  227, 2025, 1746, 1957, 1745, 1744,
 /*  1620 */   595, 1956, 1953,  135, 1743, 1840, 1742,  594, 1741, 1740,
 /*  1630 */  2031,  170, 1288, 1739,  220, 2026,  567, 1738, 1890, 1737,
 /*  1640 */   584, 1137, 1604, 1603, 1601, 1569,  592,  188, 1870, 1056,
 /*  1650 */   185, 1840, 1904,  594,  186,  165,   98, 1871, 1873,  598,
 /*  1660 */  1875, 1876,  593,  445,  588, 1055,  123,  447, 1568, 1813,
 /*  1670 */   189, 1957, 1807,  124, 1870,  583, 1953, 1796, 1904, 1872,
 /*  1680 */   194, 1795,  298, 1871, 1873,  598, 1875, 1876,  593,  591,
 /*  1690 */   588,  541, 1922,  196, 1781, 1663, 1600, 1598, 1086,  462,
 /*  1700 */  1331,  463, 1326, 1596,  464,  466,  467, 1594, 1890,  470,
 /*  1710 */   468, 1592,  472,  471,  474,  476,  595, 1581, 1580, 1565,
 /*  1720 */  1665, 1840,  475,  594, 1334, 1336,   59, 1205, 1204, 1664,
 /*  1730 */   653,  655,  204, 1128, 1127, 1124,  586, 1387, 1388, 1390,
 /*  1740 */  1391, 1392, 1393, 1872, 1870, 1123, 1122, 1590, 1904,  324,
 /*  1750 */  1585,  497,  157, 1871, 1873,  598, 1875, 1876,  593,  325,
 /*  1760 */   588, 1583,  326,  500, 1564,  502, 1563,  504, 1562, 1872,
 /*  1770 */   506,   99, 1890, 1300, 1812, 1806,   25,   53, 1290,  515,
 /*  1780 */   595,  151,  223,  516, 1794, 1840, 1872,  594, 1792, 2030,
 /*  1790 */   521, 1793, 1791, 1790, 1298,  327,  228,  529, 1890,   18,
 /*  1800 */  1788,  532,  234,  329,  568, 2046,  595,   82, 1870, 1780,
 /*  1810 */    83, 1840, 1904,  594,  236, 1890,   98, 1871, 1873,  598,
 /*  1820 */  1875, 1876,  593,  592,  588,   85,   90,  239, 1840, 1406,
 /*  1830 */   594, 1957,   19,   20, 1870,   15, 1954, 1405, 1904, 1872,
 /*  1840 */    27,   56,  299, 1871, 1873,  598, 1875, 1876,  593, 1502,
 /*  1850 */   588, 1870,  242,  250,  246, 1904, 1872,  244, 1484,  298,
 /*  1860 */  1871, 1873,  598, 1875, 1876,  593,  159,  588, 1890, 1923,
 /*  1870 */    10, 1486,  249,   28,  251, 1479,  595, 1861,   29,   89,
 /*  1880 */    61, 1840, 1522,  594,   22, 1890, 1517, 1516,  337, 1523,
 /*  1890 */    21,   16, 1521,  595, 1520,  338, 1454, 1453, 1840,   54,
 /*  1900 */   594,  263, 1860, 1332, 1870,   55, 1907,  162, 1904, 1416,
 /*  1910 */    12, 1872,  156, 1871, 1873,  598, 1875, 1876,  593, 1384,
 /*  1920 */   588, 1870, 1382,  587,   35, 1904,  163, 1381, 1872,  294,
 /*  1930 */  1871, 1873,  598, 1875, 1876,  593,   14,  588,   23,  174,
 /*  1940 */  1890, 1356, 1364,   24,  597,  599,  601,  348,  595, 1191,
 /*  1950 */   605,  608,  603, 1840, 1995,  594,  611, 1890, 1188,  606,
 /*  1960 */   614, 1185,  344,  609,  612,  595, 1179, 1177,  615, 1168,
 /*  1970 */  1840, 1200,  594,  563,  621,  267, 1870,   91,   92, 1872,
 /*  1980 */  1904,   67, 1183, 1196,  157, 1871, 1873,  598, 1875, 1876,
 /*  1990 */   593, 1182,  588, 1870, 1181, 1084, 1180, 1904, 1872,  630,
 /*  2000 */  1119,  299, 1871, 1873,  598, 1875, 1876,  593, 1890,  588,
 /*  2010 */  1118, 1117, 1116,  347, 1115, 1114,  595, 1112, 1110, 1109,
 /*  2020 */  1108, 1840,  642,  594, 1135, 1106, 1105, 1890, 1104,  268,
 /*  2030 */  1103, 1102, 1101, 1100, 1099,  595, 1132, 2047, 1130, 1096,
 /*  2040 */  1840, 1090,  594, 1095, 1870, 1092, 1091, 1089, 1904, 1597,
 /*  2050 */   663, 1595,  299, 1871, 1873,  598, 1875, 1876,  593, 1872,
 /*  2060 */   588,  665,  667,  509,  664,  668, 1593, 1904,  669,  671,
 /*  2070 */   672,  292, 1871, 1873,  598, 1875, 1876,  593,  673,  588,
 /*  2080 */  1591,  675,  676,  677, 1579,  679, 1561, 1046, 1890,  271,
 /*  2090 */   683, 1536, 1318,  279,  686,  687,  595, 1536, 1536, 1536,
 /*  2100 */  1536, 1840, 1536,  594, 1536, 1536, 1536, 1536, 1536, 1536,
 /*  2110 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1872, 1536, 1536,
 /*  2120 */  1536, 1536, 1536, 1536, 1870, 1536, 1536, 1536, 1904, 1536,
 /*  2130 */  1536, 1536,  284, 1871, 1873,  598, 1875, 1876,  593, 1872,
 /*  2140 */   588, 1536, 1536, 1536, 1536, 1536, 1890, 1536, 1536, 1536,
 /*  2150 */  1536, 1536, 1536, 1536,  595, 1536, 1536, 1536, 1536, 1840,
 /*  2160 */  1536,  594, 1536, 1536, 1536, 1536, 1536, 1536, 1890, 1536,
 /*  2170 */  1536, 1536, 1536, 1536, 1536, 1536,  595, 1536, 1536, 1536,
 /*  2180 */  1536, 1840, 1870,  594, 1536, 1536, 1904, 1536, 1536, 1536,
 /*  2190 */   285, 1871, 1873,  598, 1875, 1876,  593, 1536,  588, 1536,
 /*  2200 */  1872, 1536, 1536, 1536, 1870, 1536, 1536, 1536, 1904, 1536,
 /*  2210 */  1536, 1536,  286, 1871, 1873,  598, 1875, 1876,  593, 1872,
 /*  2220 */   588, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1890,
 /*  2230 */  1536, 1536, 1536, 1536, 1536, 1536, 1536,  595, 1536, 1536,
 /*  2240 */  1536, 1536, 1840, 1536,  594, 1536, 1536, 1536, 1890, 1536,
 /*  2250 */  1536, 1536, 1536, 1536, 1536, 1536,  595, 1536, 1536, 1536,
 /*  2260 */  1536, 1840, 1536,  594, 1536, 1870, 1536, 1536, 1536, 1904,
 /*  2270 */  1536, 1536, 1872,  293, 1871, 1873,  598, 1875, 1876,  593,
 /*  2280 */  1536,  588, 1536, 1536, 1870, 1536, 1536, 1536, 1904, 1872,
 /*  2290 */  1536, 1536,  295, 1871, 1873,  598, 1875, 1876,  593, 1536,
 /*  2300 */   588, 1890, 1536, 1536, 1536, 1536, 1536, 1536, 1536,  595,
 /*  2310 */  1536, 1536, 1536, 1536, 1840, 1536,  594, 1536, 1890, 1536,
 /*  2320 */  1536, 1536, 1536, 1536, 1536, 1536,  595, 1536, 1536, 1536,
 /*  2330 */  1536, 1840, 1872,  594, 1536, 1536, 1536, 1870, 1536, 1536,
 /*  2340 */  1536, 1904, 1536, 1536, 1536,  287, 1871, 1873,  598, 1875,
 /*  2350 */  1876,  593, 1536,  588, 1870, 1536, 1872, 1536, 1904, 1536,
 /*  2360 */  1536, 1890,  296, 1871, 1873,  598, 1875, 1876,  593,  595,
 /*  2370 */   588, 1536, 1536, 1536, 1840, 1872,  594, 1536, 1536, 1536,
 /*  2380 */  1536, 1536, 1536, 1536, 1536, 1890, 1536, 1536, 1536, 1536,
 /*  2390 */  1536, 1536, 1536,  595, 1536, 1536, 1536, 1870, 1840, 1536,
 /*  2400 */   594, 1904, 1536, 1536, 1890,  288, 1871, 1873,  598, 1875,
 /*  2410 */  1876,  593,  595,  588, 1536, 1536, 1536, 1840, 1536,  594,
 /*  2420 */  1536, 1870, 1536, 1536, 1536, 1904, 1536, 1536, 1536,  297,
 /*  2430 */  1871, 1873,  598, 1875, 1876,  593, 1872,  588, 1536, 1536,
 /*  2440 */  1870, 1536, 1536, 1536, 1904, 1536, 1536, 1536,  289, 1871,
 /*  2450 */  1873,  598, 1875, 1876,  593, 1872,  588, 1536, 1536, 1536,
 /*  2460 */  1536, 1536, 1536, 1536, 1536, 1890, 1536, 1536, 1536, 1536,
 /*  2470 */  1536, 1536, 1536,  595, 1536, 1536, 1536, 1536, 1840, 1536,
 /*  2480 */   594, 1536, 1536, 1536, 1890, 1536, 1536, 1536, 1536, 1536,
 /*  2490 */  1536, 1536,  595, 1536, 1536, 1536, 1536, 1840, 1536,  594,
 /*  2500 */  1536, 1870, 1536, 1536, 1536, 1904, 1536, 1536, 1536,  302,
 /*  2510 */  1871, 1873,  598, 1875, 1876,  593, 1536,  588, 1536, 1872,
 /*  2520 */  1870, 1536, 1536, 1536, 1904, 1536, 1536, 1536,  303, 1871,
 /*  2530 */  1873,  598, 1875, 1876,  593, 1536,  588, 1872, 1536, 1536,
 /*  2540 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1890, 1536,
 /*  2550 */  1536, 1536, 1536, 1536, 1536, 1536,  595, 1536, 1536, 1536,
 /*  2560 */  1536, 1840, 1536,  594, 1536, 1536, 1890, 1536, 1536, 1536,
 /*  2570 */  1536, 1536, 1536, 1536,  595, 1536, 1536, 1536, 1536, 1840,
 /*  2580 */  1872,  594, 1536, 1536, 1870, 1536, 1536, 1536, 1904, 1536,
 /*  2590 */  1536, 1536, 1884, 1871, 1873,  598, 1875, 1876,  593, 1536,
 /*  2600 */   588, 1536, 1870, 1536, 1536, 1536, 1904, 1536, 1536, 1890,
 /*  2610 */  1883, 1871, 1873,  598, 1875, 1876,  593,  595,  588, 1536,
 /*  2620 */  1536, 1536, 1840, 1536,  594, 1536, 1536, 1536, 1536, 1536,
 /*  2630 */  1536, 1536, 1536, 1872, 1536, 1536, 1536, 1536, 1536, 1536,
 /*  2640 */  1536, 1536, 1536, 1536, 1536, 1870, 1536, 1536, 1536, 1904,
 /*  2650 */  1872, 1536, 1536, 1882, 1871, 1873,  598, 1875, 1876,  593,
 /*  2660 */  1536,  588, 1890, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*  2670 */   595, 1536, 1536, 1536, 1536, 1840, 1536,  594, 1536, 1890,
 /*  2680 */  1536, 1536, 1536, 1536, 1536, 1536, 1536,  595, 1536, 1536,
 /*  2690 */  1536, 1536, 1840, 1872,  594, 1536, 1536, 1536, 1870, 1536,
 /*  2700 */  1536, 1536, 1904, 1536, 1536, 1536,  314, 1871, 1873,  598,
 /*  2710 */  1875, 1876,  593, 1536,  588, 1870, 1536, 1872, 1536, 1904,
 /*  2720 */  1536, 1536, 1890,  315, 1871, 1873,  598, 1875, 1876,  593,
 /*  2730 */   595,  588, 1536, 1536, 1536, 1840, 1872,  594, 1536, 1536,
 /*  2740 */  1536, 1536, 1536, 1536, 1536, 1536, 1890, 1536, 1536, 1536,
 /*  2750 */  1536, 1536, 1536, 1536,  595, 1536, 1536, 1536, 1870, 1840,
 /*  2760 */  1536,  594, 1904, 1536, 1536, 1890,  311, 1871, 1873,  598,
 /*  2770 */  1875, 1876,  593,  595,  588, 1536, 1536, 1536, 1840, 1536,
 /*  2780 */   594, 1536, 1870, 1536, 1536, 1536, 1904, 1536, 1536, 1536,
 /*  2790 */   316, 1871, 1873,  598, 1875, 1876,  593, 1536,  588, 1536,
 /*  2800 */  1536, 1870, 1536, 1536, 1536, 1904, 1536, 1536, 1536,  291,
 /*  2810 */  1871, 1873,  598, 1875, 1876,  593, 1536,  588,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   349,  318,  322,  349,  324,  325,  322,  318,  324,  325,
 /*    10 */   349,  360,   12,   13,  360,  358,    1,    2,  361,  362,
 /*    20 */    20,  360,   22,   12,   13,   14,   15,   16,   20,    3,
 /*    30 */   317,  330,  319,   33,    4,   35,  347,  386,  387,  388,
 /*    40 */   386,  387,  388,  360,  355,  344,   20,  386,  387,  360,
 /*    50 */   399,  362,    2,  399,  353,  403,   56,  405,    8,    9,
 /*    60 */   399,   61,   12,   13,   14,   15,   16,  318,   68,   12,
 /*    70 */    13,   14,  383,   20,   44,   45,  387,   20,  392,   22,
 /*    80 */   391,  392,  393,  394,  395,  396,  397,   20,  399,   22,
 /*    90 */    33,    4,   35,  404,   94,  406,  347,  407,  408,  410,
 /*   100 */   411,  346,   35,   20,  355,  326,   20,  421,  347,  360,
 /*   110 */    95,  362,  423,   56,  359,  354,  116,   50,   61,  362,
 /*   120 */   431,   95,  436,  437,  363,   68,  369,  441,  442,  372,
 /*   130 */   130,  131,  383,   60,  355,   56,  387,    0,  130,  131,
 /*   140 */   391,  392,  393,  394,  395,  396,  397,   94,  399,  347,
 /*   150 */   323,   94,   20,  326,   22,  406,   94,  355,   21,  410,
 /*   160 */   411,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   170 */   421,  392,   93,  116,  389,   96,  176,   94,  178,   94,
 /*   180 */    94,   94,   50,   39,  318,  436,  437,  130,  131,  163,
 /*   190 */   441,  442,  413,  414,  415,  416,  394,  418,  361,  362,
 /*   200 */   200,  201,  417,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,   33,    0,    8,    9,  360,   20,   12,   13,
 /*   230 */    14,   15,   16,  176,   20,  178,   47,  125,  126,  239,
 /*   240 */    14,   52,   53,   54,   55,   56,   20,   24,   25,   26,
 /*   250 */    27,   28,   29,   30,   31,   32,  326,  200,  201,   43,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,   12,
 /*   280 */    13,  106,   93,  330,  349,   96,   94,   20,  318,   22,
 /*   290 */   323,  200,  239,  326,  364,  360,  184,  106,  326,  187,
 /*   300 */    33,  239,   35,  128,   21,  126,  353,   24,   25,   26,
 /*   310 */    27,   28,   29,   30,   31,   32,  125,  126,  127,  128,
 /*   320 */   129,  386,  387,   56,  239,  239,  239,  355,   61,  392,
 /*   330 */   360,  318,   56,   20,  399,   68,   12,   13,  347,  248,
 /*   340 */   249,  250,  251,  252,   20,  354,   22,  326,  159,  160,
 /*   350 */    14,  162,   20,  318,  363,  166,   20,   33,  421,   35,
 /*   360 */   347,   94,  183,  184,  392,  326,  187,  175,  355,  177,
 /*   370 */    94,  182,   96,  360,  437,  362,  355,  338,  441,  442,
 /*   380 */    56,  171,  238,  116,  345,   61,  414,  415,  416,   43,
 /*   390 */   418,    0,   68,   14,  355,  360,  383,  130,  131,   20,
 /*   400 */   387,  191,  192,   22,  391,  392,  393,  394,  395,  396,
 /*   410 */   397,  318,  399,  392,   60,  161,   35,  404,   94,  406,
 /*   420 */   105,    8,    9,  410,  411,   12,   13,   14,   15,   16,
 /*   430 */   204,  239,  223,   20,  225,  414,  415,  416,   78,  418,
 /*   440 */   116,   95,  421,  176,  431,  178,    0,  340,  339,   68,
 /*   450 */   343,   60,  339,  360,  130,  131,  347,  436,  437,    0,
 /*   460 */   347,  318,  441,  442,  403,  356,  405,  200,  201,  356,
 /*   470 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   480 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  125,
 /*   490 */   223,   14,   15,   16,  134,  135,   20,  116,  244,  245,
 /*   500 */   176,   37,  178,  360,  107,  108,  109,  110,  111,  112,
 /*   510 */   113,  114,  115,  116,  117,  239,  119,  120,  121,  122,
 /*   520 */   123,  124,   35,    0,  200,  201,  318,  203,  204,  205,
 /*   530 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   540 */   216,  217,  218,  219,  220,  221,   12,   13,  326,  185,
 /*   550 */   186,  392,  106,  223,   20,   68,   22,  176,   68,  178,
 /*   560 */   338,   97,   20,   99,  100,  106,  102,   33,  360,   35,
 /*   570 */   106,  125,  126,  127,  128,  129,  163,  355,   21,  318,
 /*   580 */   421,  200,  201,  204,  125,  126,  127,  128,  129,  339,
 /*   590 */    56,   34,  128,   36,  331,   20,  437,  347,  318,  336,
 /*   600 */   441,  442,   68,   12,   13,   14,  356,  326,  347,    0,
 /*   610 */   371,   20,  373,   22,   68,  328,  355,  333,  334,  338,
 /*   620 */   318,  360,  326,  362,   33,  347,   35,  347,   94,  342,
 /*   630 */   333,  334,  354,  158,  338,  355,  355,  350,  318,  318,
 /*   640 */   360,  363,  362,  402,  383,  318,  405,   56,  387,  326,
 /*   650 */   116,  355,  391,  392,  393,  394,  395,  396,  397,   68,
 /*   660 */   399,  338,  360,  383,  130,  131,  318,  387,  345,   60,
 /*   670 */   392,  391,  392,  393,  394,  395,  396,  397,  355,  399,
 /*   680 */   360,  360,  421,  318,  404,   94,  406,  360,    8,    9,
 /*   690 */   410,  411,   12,   13,   14,   15,   16,  436,  437,  421,
 /*   700 */   420,  226,  441,  442,  326,  163,   20,  116,  360,  347,
 /*   710 */   176,  236,  178,   43,  436,  437,  338,    2,  356,  441,
 /*   720 */   442,  130,  131,    8,    9,  360,    4,   12,   13,   14,
 /*   730 */    15,   16,  318,  355,  200,  201,  318,  203,  204,  205,
 /*   740 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   750 */   216,  217,  218,  219,  220,  221,  326,    8,    9,  389,
 /*   760 */   315,   12,   13,   14,   15,   16,  379,  176,  338,  178,
 /*   770 */   371,  328,  373,  239,  360,   95,    8,    9,  360,  204,
 /*   780 */    12,   13,   14,   15,   16,  355,  318,  417,  318,  389,
 /*   790 */   318,  200,  201,  350,  203,  204,  205,  206,  207,  208,
 /*   800 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   810 */   219,  220,  221,   12,   13,  355,    4,  417,   44,   45,
 /*   820 */   375,   20,  355,   22,  237,  238,  366,  326,  360,  326,
 /*   830 */   360,   19,  360,  366,   33,  326,   35,  392,  326,  338,
 /*   840 */     3,  338,  362,  326,   95,   33,  318,  338,  326,  163,
 /*   850 */   338,  357,  372,   35,  360,  338,  355,   56,  355,   47,
 /*   860 */   338,  318,  348,   51,  355,  318,  421,  355,   56,   68,
 /*   870 */    12,   13,  355,  347,  319,  347,  357,  355,   20,  360,
 /*   880 */    22,  436,  437,  355,  326,   43,  441,  442,  360,  363,
 /*   890 */   362,   33,    3,   35,  347,   94,  338,  335,    0,  337,
 /*   900 */   326,  348,  355,  360,  326,   93,  326,  360,   96,  362,
 /*   910 */    43,  383,  338,  355,   56,  387,  338,  116,  338,  391,
 /*   920 */   392,  393,  394,  395,  396,  397,   68,  399,  258,  355,
 /*   930 */   383,  130,  131,  355,  387,  355,  168,   95,  391,  392,
 /*   940 */   393,  394,  395,  396,  397,   47,  399,   64,   65,   42,
 /*   950 */    43,  404,   94,  406,   71,   22,  340,  410,  411,  343,
 /*   960 */   432,  433,  240,    0,  336,   82,   83,  420,   35,  326,
 /*   970 */    98,   88,   98,  101,  116,  101,   61,  176,  375,  178,
 /*   980 */   375,  338,  163,  164,   95,   22,    8,    9,  130,  131,
 /*   990 */    12,   13,   14,   15,   16,  392,  178,  392,  355,  130,
 /*  1000 */   131,  200,  201,  348,  203,  204,  205,  206,  207,  208,
 /*  1010 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*  1020 */   219,  220,  221,   18,  421,   20,  421,    0,    0,  261,
 /*  1030 */    98,  326,   27,  101,  176,   30,  178,    1,    2,  436,
 /*  1040 */   437,  436,  437,  338,  441,  442,  441,  442,   98,   22,
 /*  1050 */    22,  101,   47,   43,   49,   56,   51,  348,  200,  201,
 /*  1060 */   355,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*  1070 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*  1080 */     8,    9,   43,   43,   12,   13,   14,   15,   16,   18,
 /*  1090 */   326,  326,   13,  256,   23,   96,   94,  390,   93,  348,
 /*  1100 */    13,  348,  338,  338,   35,   95,  104,   43,   37,   38,
 /*  1110 */   105,    0,   41,  445,   35,  200,   43,  348,   43,  355,
 /*  1120 */   355,   43,   35,   46,  434,  327,  428,  260,   57,   58,
 /*  1130 */    59,  347,  327,  325,   95,   95,  359,  390,  133,   35,
 /*  1140 */   326,  136,  137,  138,  139,  140,  141,  142,  143,  144,
 /*  1150 */   145,  146,  147,  148,  149,  150,  151,  152,  153,   95,
 /*  1160 */   155,  156,  157,   43,   43,   94,  438,   43,   95,  355,
 /*  1170 */    95,   94,   68,   95,   63,   64,   65,   66,   67,   43,
 /*  1180 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*  1190 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  1200 */    89,   90,   43,  132,    8,    9,  392,    0,   12,   13,
 /*  1210 */    14,   15,   16,   43,  318,   95,   95,  422,  419,   95,
 /*  1220 */    43,  412,  241,  385,  384,   47,  174,  377,  414,  415,
 /*  1230 */   416,   95,  418,   42,   20,  163,  326,  367,  326,  168,
 /*  1240 */   169,  170,  367,  347,  173,  365,  158,  178,   92,  332,
 /*  1250 */   365,  355,  326,  326,   95,   48,  360,   61,  362,  375,
 /*  1260 */   326,  190,   20,  320,  193,   95,  195,  196,  197,  198,
 /*  1270 */   199,  320,   95,   20,  381,  330,  392,  330,  362,  383,
 /*  1280 */    20,   20,  374,  387,  330,  376,  318,  391,  392,  393,
 /*  1290 */   394,  395,  396,  397,  374,  399,  330,  330,  402,  103,
 /*  1300 */   404,  405,  406,  330,  330,  421,  410,  411,  318,  326,
 /*  1310 */   239,  320,  347,  326,  320,  347,  347,  347,  347,  347,
 /*  1320 */   436,  437,  347,  355,  347,  441,  442,    0,  360,  347,
 /*  1330 */   362,  347,  347,  347,  189,  382,  360,  347,  381,  328,
 /*  1340 */   380,  181,  362,  328,  326,  355,  326,  328,  246,  360,
 /*  1350 */   360,  383,  362,  374,  158,  387,  360,  360,  370,  391,
 /*  1360 */   392,  393,  394,  395,  396,  397,  360,  399,  370,  360,
 /*  1370 */   160,  368,  404,  383,  406,  318,  328,  387,  410,  411,
 /*  1380 */   343,  391,  392,  393,  394,  395,  396,  397,  420,  399,
 /*  1390 */   328,   64,   65,  355,  404,   20,  406,  390,   71,  247,
 /*  1400 */   410,  411,  390,  360,  347,  370,  360,  360,  253,   82,
 /*  1410 */    83,  360,  355,  360,  370,   88,  375,  360,  167,  362,
 /*  1420 */   427,  429,  226,  227,  228,  229,  230,  231,  232,  233,
 /*  1430 */   234,  235,  236,  392,  430,  427,  255,  254,  262,  426,
 /*  1440 */   383,  427,  425,  242,  387,  424,  385,  318,  391,  392,
 /*  1450 */   393,  394,  395,  396,  397,  439,  399,  259,  238,  257,
 /*  1460 */   355,  404,  421,  406,  440,   20,   94,  410,  411,  446,
 /*  1470 */   389,   19,  409,   94,  351,  360,  347,  436,  437,  337,
 /*  1480 */   326,  328,  441,  442,  355,   33,   36,  321,  320,  360,
 /*  1490 */   378,  362,  373,  329,    0,  316,    0,  183,  341,   47,
 /*  1500 */     0,    0,  341,  341,   52,   53,   54,   55,   56,   42,
 /*  1510 */     0,   35,  383,  194,   35,   35,  387,   35,  194,    0,
 /*  1520 */   391,  392,  393,  394,  395,  396,  397,   35,  399,  318,
 /*  1530 */    35,  194,    0,  404,  194,  406,   12,   13,   35,  410,
 /*  1540 */   411,    0,    0,    0,   22,   93,   22,   35,   96,  178,
 /*  1550 */   176,    0,    0,  172,  171,    0,    0,   33,  347,   35,
 /*  1560 */    46,    0,    0,    0,    0,   42,  355,    0,    0,  375,
 /*  1570 */   154,  360,    0,  362,    0,    0,    0,    0,  149,   35,
 /*  1580 */    56,  129,    0,  318,  149,    0,  392,    0,    0,    0,
 /*  1590 */     0,    0,   68,   22,  383,    0,    0,    0,  387,    0,
 /*  1600 */     0,    0,  391,  392,  393,  394,  395,  396,  397,  318,
 /*  1610 */   399,    0,  347,    0,  162,  421,    0,  406,    0,    0,
 /*  1620 */   355,  410,  411,   42,    0,  360,    0,  362,    0,    0,
 /*  1630 */   436,  437,  180,    0,  182,  441,  442,    0,  347,    0,
 /*  1640 */   116,   35,    0,    0,    0,    0,  355,   42,  383,   14,
 /*  1650 */    56,  360,  387,  362,   56,   43,  391,  392,  393,  394,
 /*  1660 */   395,  396,  397,   46,  399,   14,   39,   46,    0,    0,
 /*  1670 */    40,  406,    0,   39,  383,  410,  411,    0,  387,  318,
 /*  1680 */    39,    0,  391,  392,  393,  394,  395,  396,  397,  398,
 /*  1690 */   399,  400,  401,  167,    0,    0,    0,    0,   62,   35,
 /*  1700 */   176,   47,  178,    0,   39,   35,   47,    0,  347,   35,
 /*  1710 */    39,    0,   39,   47,   35,   39,  355,    0,    0,    0,
 /*  1720 */     0,  360,   47,  362,  200,  201,  103,   35,   22,    0,
 /*  1730 */    43,   43,  101,   35,   35,   35,  212,  213,  214,  215,
 /*  1740 */   216,  217,  218,  318,  383,   35,   22,    0,  387,   22,
 /*  1750 */     0,   49,  391,  392,  393,  394,  395,  396,  397,   22,
 /*  1760 */   399,    0,   22,   35,    0,   35,    0,   35,    0,  318,
 /*  1770 */    22,   20,  347,   95,    0,    0,   94,  163,   35,   22,
 /*  1780 */   355,  179,  160,  163,    0,  360,  318,  362,    0,    3,
 /*  1790 */   165,    0,    0,    0,   35,  163,   95,  188,  347,   94,
 /*  1800 */     0,  161,   94,  352,  443,  444,  355,   94,  383,    0,
 /*  1810 */    39,  360,  387,  362,  159,  347,  391,  392,  393,  394,
 /*  1820 */   395,  396,  397,  355,  399,   94,  104,   46,  360,  222,
 /*  1830 */   362,  406,   43,   43,  383,  243,  411,  222,  387,  318,
 /*  1840 */    94,   43,  391,  392,  393,  394,  395,  396,  397,   95,
 /*  1850 */   399,  383,   94,   43,   94,  387,  318,   95,   95,  391,
 /*  1860 */   392,  393,  394,  395,  396,  397,   94,  399,  347,  401,
 /*  1870 */   224,   95,   94,   94,   46,   95,  355,   46,   43,   94,
 /*  1880 */     3,  360,   95,  362,   43,  347,   35,   35,   35,   95,
 /*  1890 */   243,  243,   35,  355,   35,   35,   95,   95,  360,  237,
 /*  1900 */   362,   46,   46,   22,  383,   43,   94,   46,  387,  200,
 /*  1910 */     2,  318,  391,  392,  393,  394,  395,  396,  397,   95,
 /*  1920 */   399,  383,   95,   94,   94,  387,   46,   95,  318,  391,
 /*  1930 */   392,  393,  394,  395,  396,  397,   94,  399,   94,   46,
 /*  1940 */   347,   95,   22,   94,  202,  105,   35,   35,  355,   95,
 /*  1950 */    35,   35,   94,  360,  433,  362,   35,  347,   95,   94,
 /*  1960 */    35,   95,  352,   94,   94,  355,   95,   95,   94,   22,
 /*  1970 */   360,   35,  362,  435,  106,   43,  383,   94,   94,  318,
 /*  1980 */   387,   94,  118,   22,  391,  392,  393,  394,  395,  396,
 /*  1990 */   397,  118,  399,  383,  118,   62,  118,  387,  318,   61,
 /*  2000 */    35,  391,  392,  393,  394,  395,  396,  397,  347,  399,
 /*  2010 */    35,   35,   35,  352,   35,   35,  355,   35,   35,   35,
 /*  2020 */    35,  360,   91,  362,   68,   35,   35,  347,   22,   43,
 /*  2030 */    35,   22,   35,   35,   35,  355,   68,  444,   35,   35,
 /*  2040 */   360,   22,  362,   35,  383,   35,   35,   35,  387,    0,
 /*  2050 */    35,    0,  391,  392,  393,  394,  395,  396,  397,  318,
 /*  2060 */   399,   39,   35,  383,   47,   47,    0,  387,   39,   35,
 /*  2070 */    47,  391,  392,  393,  394,  395,  396,  397,   39,  399,
 /*  2080 */     0,   35,   47,   39,    0,   35,    0,   35,  347,   22,
 /*  2090 */    21,  447,   22,   22,   21,   20,  355,  447,  447,  447,
 /*  2100 */   447,  360,  447,  362,  447,  447,  447,  447,  447,  447,
 /*  2110 */   447,  447,  447,  447,  447,  447,  447,  318,  447,  447,
 /*  2120 */   447,  447,  447,  447,  383,  447,  447,  447,  387,  447,
 /*  2130 */   447,  447,  391,  392,  393,  394,  395,  396,  397,  318,
 /*  2140 */   399,  447,  447,  447,  447,  447,  347,  447,  447,  447,
 /*  2150 */   447,  447,  447,  447,  355,  447,  447,  447,  447,  360,
 /*  2160 */   447,  362,  447,  447,  447,  447,  447,  447,  347,  447,
 /*  2170 */   447,  447,  447,  447,  447,  447,  355,  447,  447,  447,
 /*  2180 */   447,  360,  383,  362,  447,  447,  387,  447,  447,  447,
 /*  2190 */   391,  392,  393,  394,  395,  396,  397,  447,  399,  447,
 /*  2200 */   318,  447,  447,  447,  383,  447,  447,  447,  387,  447,
 /*  2210 */   447,  447,  391,  392,  393,  394,  395,  396,  397,  318,
 /*  2220 */   399,  447,  447,  447,  447,  447,  447,  447,  447,  347,
 /*  2230 */   447,  447,  447,  447,  447,  447,  447,  355,  447,  447,
 /*  2240 */   447,  447,  360,  447,  362,  447,  447,  447,  347,  447,
 /*  2250 */   447,  447,  447,  447,  447,  447,  355,  447,  447,  447,
 /*  2260 */   447,  360,  447,  362,  447,  383,  447,  447,  447,  387,
 /*  2270 */   447,  447,  318,  391,  392,  393,  394,  395,  396,  397,
 /*  2280 */   447,  399,  447,  447,  383,  447,  447,  447,  387,  318,
 /*  2290 */   447,  447,  391,  392,  393,  394,  395,  396,  397,  447,
 /*  2300 */   399,  347,  447,  447,  447,  447,  447,  447,  447,  355,
 /*  2310 */   447,  447,  447,  447,  360,  447,  362,  447,  347,  447,
 /*  2320 */   447,  447,  447,  447,  447,  447,  355,  447,  447,  447,
 /*  2330 */   447,  360,  318,  362,  447,  447,  447,  383,  447,  447,
 /*  2340 */   447,  387,  447,  447,  447,  391,  392,  393,  394,  395,
 /*  2350 */   396,  397,  447,  399,  383,  447,  318,  447,  387,  447,
 /*  2360 */   447,  347,  391,  392,  393,  394,  395,  396,  397,  355,
 /*  2370 */   399,  447,  447,  447,  360,  318,  362,  447,  447,  447,
 /*  2380 */   447,  447,  447,  447,  447,  347,  447,  447,  447,  447,
 /*  2390 */   447,  447,  447,  355,  447,  447,  447,  383,  360,  447,
 /*  2400 */   362,  387,  447,  447,  347,  391,  392,  393,  394,  395,
 /*  2410 */   396,  397,  355,  399,  447,  447,  447,  360,  447,  362,
 /*  2420 */   447,  383,  447,  447,  447,  387,  447,  447,  447,  391,
 /*  2430 */   392,  393,  394,  395,  396,  397,  318,  399,  447,  447,
 /*  2440 */   383,  447,  447,  447,  387,  447,  447,  447,  391,  392,
 /*  2450 */   393,  394,  395,  396,  397,  318,  399,  447,  447,  447,
 /*  2460 */   447,  447,  447,  447,  447,  347,  447,  447,  447,  447,
 /*  2470 */   447,  447,  447,  355,  447,  447,  447,  447,  360,  447,
 /*  2480 */   362,  447,  447,  447,  347,  447,  447,  447,  447,  447,
 /*  2490 */   447,  447,  355,  447,  447,  447,  447,  360,  447,  362,
 /*  2500 */   447,  383,  447,  447,  447,  387,  447,  447,  447,  391,
 /*  2510 */   392,  393,  394,  395,  396,  397,  447,  399,  447,  318,
 /*  2520 */   383,  447,  447,  447,  387,  447,  447,  447,  391,  392,
 /*  2530 */   393,  394,  395,  396,  397,  447,  399,  318,  447,  447,
 /*  2540 */   447,  447,  447,  447,  447,  447,  447,  447,  347,  447,
 /*  2550 */   447,  447,  447,  447,  447,  447,  355,  447,  447,  447,
 /*  2560 */   447,  360,  447,  362,  447,  447,  347,  447,  447,  447,
 /*  2570 */   447,  447,  447,  447,  355,  447,  447,  447,  447,  360,
 /*  2580 */   318,  362,  447,  447,  383,  447,  447,  447,  387,  447,
 /*  2590 */   447,  447,  391,  392,  393,  394,  395,  396,  397,  447,
 /*  2600 */   399,  447,  383,  447,  447,  447,  387,  447,  447,  347,
 /*  2610 */   391,  392,  393,  394,  395,  396,  397,  355,  399,  447,
 /*  2620 */   447,  447,  360,  447,  362,  447,  447,  447,  447,  447,
 /*  2630 */   447,  447,  447,  318,  447,  447,  447,  447,  447,  447,
 /*  2640 */   447,  447,  447,  447,  447,  383,  447,  447,  447,  387,
 /*  2650 */   318,  447,  447,  391,  392,  393,  394,  395,  396,  397,
 /*  2660 */   447,  399,  347,  447,  447,  447,  447,  447,  447,  447,
 /*  2670 */   355,  447,  447,  447,  447,  360,  447,  362,  447,  347,
 /*  2680 */   447,  447,  447,  447,  447,  447,  447,  355,  447,  447,
 /*  2690 */   447,  447,  360,  318,  362,  447,  447,  447,  383,  447,
 /*  2700 */   447,  447,  387,  447,  447,  447,  391,  392,  393,  394,
 /*  2710 */   395,  396,  397,  447,  399,  383,  447,  318,  447,  387,
 /*  2720 */   447,  447,  347,  391,  392,  393,  394,  395,  396,  397,
 /*  2730 */   355,  399,  447,  447,  447,  360,  318,  362,  447,  447,
 /*  2740 */   447,  447,  447,  447,  447,  447,  347,  447,  447,  447,
 /*  2750 */   447,  447,  447,  447,  355,  447,  447,  447,  383,  360,
 /*  2760 */   447,  362,  387,  447,  447,  347,  391,  392,  393,  394,
 /*  2770 */   395,  396,  397,  355,  399,  447,  447,  447,  360,  447,
 /*  2780 */   362,  447,  383,  447,  447,  447,  387,  447,  447,  447,
 /*  2790 */   391,  392,  393,  394,  395,  396,  397,  447,  399,  447,
 /*  2800 */   447,  383,  447,  447,  447,  387,  447,  447,  447,  391,
 /*  2810 */   392,  393,  394,  395,  396,  397,  447,  399,
};
#define YY_SHIFT_COUNT    (688)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2086)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1071,    0,   57,  267,   57,  324,  324,  324,  534,  324,
 /*    10 */   324,  324,  324,  324,  591,  801,  801,  858,  801,  801,
 /*    20 */   801,  801,  801,  801,  801,  801,  801,  801,  801,  801,
 /*    30 */   801,  801,  801,  801,  801,  801,  801,  801,  801,  801,
 /*    40 */   801,  801,  801,  801,  801,  801,   53,   86,   83,  192,
 /*    50 */   276,   62,   85,   62,   83,   83, 1524, 1524,   62, 1524,
 /*    60 */  1524,   87,   62,  207,  207,   30,   30,    8,  207,  207,
 /*    70 */   207,  207,  207,  207,  207,  207,  207,  207,   73,  207,
 /*    80 */   207,  207,  214,  207,  207,  313,  207,  207,  313,  332,
 /*    90 */   207,  313,  313,  313,  207,  354, 1005, 1196, 1196,  283,
 /*   100 */   381,  381,  381,  381,  381,  381,  381,  381,  381,  381,
 /*   110 */   381,  381,  381,  381,  381,  381,  381,  381,  381,  464,
 /*   120 */   883,   26,    8,  336,  336,  391,  487,  609,  209,  209,
 /*   130 */   542,  542,  542,  487,  476,  476,  315,  214,  523,  523,
 /*   140 */   330,  313,  313,  490,  490,  315,  546,  397,  397,  397,
 /*   150 */   397,  397,  397,  397, 1452,  137,  413,  768, 1327,   91,
 /*   160 */    67,  254,  226,  379,  132,  774,  175,  686,  587,  144,
 /*   170 */   837,  587,  907,  722,  575,  981, 1178, 1052, 1191, 1214,
 /*   180 */  1214, 1191, 1088, 1088, 1156, 1214, 1214, 1214, 1242, 1242,
 /*   190 */  1253,   73,  214,   73, 1260, 1261,   73, 1260,   73,   73,
 /*   200 */    73, 1214,   73, 1242,  313,  313,  313,  313,  313,  313,
 /*   210 */   313,  313,  313,  313,  313, 1214, 1242,  490, 1145, 1253,
 /*   220 */   354, 1160,  214,  354, 1214, 1214, 1260,  354, 1102,  490,
 /*   230 */   490,  490,  490, 1102,  490, 1210,  354,  315,  354,  476,
 /*   240 */  1375, 1375,  490, 1152, 1102,  490,  490, 1152, 1102,  490,
 /*   250 */   490,  313, 1155, 1251, 1152, 1181, 1183, 1201,  981, 1176,
 /*   260 */  1198, 1202, 1220,  476, 1445, 1372, 1379,  490,  546, 1214,
 /*   270 */   354, 1450, 1242, 2818, 2818, 2818, 2818, 2818, 2818, 2818,
 /*   280 */  1111,  189,  223,  812,  680,  216,  749,   50,  715, 1072,
 /*   290 */   446,  978,  978,  978,  978,  978,  978,  978,  978,  978,
 /*   300 */   459,  191,   11,   11,  179,  112,  210,   79,  360,  557,
 /*   310 */   364,  477,   15,  475,  477,  477,  477,  346,  898,  933,
 /*   320 */   872,  874,  932,  950,  963, 1027, 1028,  999,  819,  842,
 /*   330 */  1010, 1040, 1064, 1073, 1075, 1078,  869,  670,  867, 1036,
 /*   340 */  1039,  818, 1069,  915, 1120,  889, 1077, 1121, 1124, 1136,
 /*   350 */  1159, 1170, 1177, 1002, 1079, 1087, 1104, 1207, 1494, 1496,
 /*   360 */  1314, 1500, 1501, 1467, 1510, 1476, 1319, 1479, 1480, 1482,
 /*   370 */  1324, 1519, 1492, 1495, 1337, 1532, 1340, 1541, 1503, 1542,
 /*   380 */  1522, 1543, 1512, 1371, 1374, 1551, 1552, 1381, 1383, 1555,
 /*   390 */  1556, 1514, 1561, 1562, 1563, 1523, 1564, 1567, 1568, 1416,
 /*   400 */  1572, 1574, 1575, 1576, 1577, 1429, 1544, 1582, 1435, 1585,
 /*   410 */  1587, 1588, 1589, 1590, 1591, 1595, 1596, 1597, 1599, 1600,
 /*   420 */  1601, 1611, 1613, 1581, 1616, 1618, 1619, 1624, 1626, 1628,
 /*   430 */  1571, 1629, 1633, 1637, 1639, 1606, 1642, 1594, 1643, 1598,
 /*   440 */  1644, 1645, 1605, 1627, 1612, 1635, 1617, 1651, 1621, 1668,
 /*   450 */  1630, 1634, 1669, 1672, 1677, 1641, 1526, 1681, 1694, 1695,
 /*   460 */  1636, 1696, 1697, 1664, 1654, 1665, 1703, 1670, 1659, 1671,
 /*   470 */  1707, 1674, 1666, 1673, 1711, 1679, 1675, 1676, 1717, 1718,
 /*   480 */  1719, 1720, 1623, 1631, 1692, 1706, 1729, 1698, 1699, 1687,
 /*   490 */  1688, 1700, 1710, 1724, 1747, 1727, 1750, 1737, 1702, 1761,
 /*   500 */  1740, 1728, 1764, 1730, 1766, 1732, 1768, 1748, 1751, 1678,
 /*   510 */  1682, 1774, 1614, 1743, 1775, 1602, 1757, 1620, 1622, 1784,
 /*   520 */  1788, 1632, 1625, 1786, 1791, 1792, 1793, 1705, 1701, 1759,
 /*   530 */  1609, 1800, 1708, 1640, 1713, 1809, 1771, 1655, 1731, 1722,
 /*   540 */  1781, 1789, 1607, 1646, 1615, 1790, 1592, 1746, 1754, 1758,
 /*   550 */  1762, 1763, 1760, 1798, 1776, 1772, 1778, 1779, 1780, 1810,
 /*   560 */  1828, 1831, 1785, 1835, 1647, 1787, 1794, 1877, 1841, 1648,
 /*   570 */  1851, 1852, 1853, 1857, 1859, 1860, 1801, 1802, 1855, 1662,
 /*   580 */  1862, 1856, 1861, 1908, 1881, 1709, 1812, 1824, 1829, 1827,
 /*   590 */  1830, 1832, 1880, 1842, 1844, 1893, 1846, 1920, 1742, 1849,
 /*   600 */  1840, 1854, 1911, 1912, 1858, 1863, 1915, 1865, 1866, 1916,
 /*   610 */  1869, 1871, 1921, 1870, 1872, 1925, 1874, 1864, 1873, 1876,
 /*   620 */  1878, 1947, 1868, 1883, 1884, 1936, 1887, 1932, 1932, 1961,
 /*   630 */  1933, 1938, 1965, 1975, 1976, 1977, 1979, 1980, 1982, 1983,
 /*   640 */  1984, 1985, 1956, 1931, 1986, 1990, 1991, 2006, 1995, 2009,
 /*   650 */  1997, 1998, 1999, 1968, 1687, 2003, 1688, 2004, 2008, 2010,
 /*   660 */  2011, 2019, 2012, 2049, 2015, 2017, 2022, 2051, 2027, 2018,
 /*   670 */  2029, 2066, 2034, 2023, 2039, 2080, 2046, 2035, 2044, 2084,
 /*   680 */  2050, 2052, 2086, 2067, 2069, 2070, 2071, 2073, 2075,
};
#define YY_REDUCE_COUNT (279)
#define YY_REDUCE_MIN   (-349)
#define YY_REDUCE_MAX   (2418)
static const short yy_reduce_ofst[] = {
 /*     0 */   445, -251, -311,  896,   13,  280,  547,  968,  261,  990,
 /*    10 */  1057, 1129, 1211, 1265, 1291,  528, 1361, 1425, 1451, 1468,
 /*    20 */  1521, 1538, 1593, 1610, 1661, 1680, 1741, 1799, 1821, 1882,
 /*    30 */  1901, 1954, 1971, 2014, 2038, 2057, 2118, 2137, 2201, 2219,
 /*    40 */  2262, 2315, 2332, 2375, 2399, 2418,   21,  278, -221,  603,
 /*    50 */   605,  884, 1041, 1194,  -28,  814, -349, -346, -314, -339,
 /*    60 */   -65,  -63,  159,   39,  323, -320, -316, -343,  222,  281,
 /*    70 */   296,  378,  430,  501,  503,  509,  512,  517, -299,  522,
 /*    80 */   558,  574, -243,  578,  580,  113,  643,  705, -239, -198,
 /*    90 */   764,  109,   -9,  250,  765,  287,  -70, -310, -310, -287,
 /*   100 */  -317, -134,  -30,   35,   93,  143,  208,  302,  320,  321,
 /*   110 */   327,  348,  365,  414,  418,  468,  470,  472,  543, -245,
 /*   120 */   263, -215, -163, -173,  -33,  -47,  284,  443, -348,   61,
 /*   130 */  -215,  370,  400,  297,  460,  467,  107,  480,  239,  399,
 /*   140 */   241,  362,  526,  494,  519,  616,  562,  514,  553,  655,
 /*   150 */   709,  751,  753,  769,  387,  555,  707,  668,  628,  690,
 /*   160 */   798,  698,  784,  784,  805,  808,  777,  747,  799,  799,
 /*   170 */   728,  799,  809,  795,  784,  838,  840,  850,  870,  910,
 /*   180 */   912,  875,  880,  885,  917,  926,  927,  934,  943,  951,
 /*   190 */   893,  945,  916,  947,  908,  909,  954,  920,  966,  967,
 /*   200 */   973,  983,  974,  991,  965,  969,  970,  971,  972,  975,
 /*   210 */   977,  982,  984,  985,  986,  987,  994,  976,  953,  957,
 /*   220 */  1011,  960,  980, 1015, 1018, 1020,  979, 1019,  988,  989,
 /*   230 */   996,  997, 1006,  998, 1009, 1003, 1048, 1037, 1062, 1038,
 /*   240 */  1007, 1012, 1043,  993, 1035, 1046, 1047, 1008, 1044, 1051,
 /*   250 */  1053,  784, 1004,  992, 1014, 1013, 1017, 1021, 1061, 1023,
 /*   260 */  1024, 1016,  799, 1105, 1081, 1063, 1123, 1115, 1142, 1154,
 /*   270 */  1153, 1166, 1168, 1112, 1119, 1157, 1161, 1162, 1164, 1179,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    10 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    20 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    30 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    40 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    50 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    60 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    70 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1608, 1534,
 /*    80 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*    90 */  1534, 1534, 1534, 1534, 1534, 1606, 1773, 1959, 1534, 1534,
 /*   100 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   110 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   120 */  1534, 1971, 1534, 1534, 1534, 1608, 1534, 1606, 1931, 1931,
 /*   130 */  1971, 1971, 1971, 1534, 1534, 1534, 1713, 1534, 1814, 1814,
 /*   140 */  1534, 1534, 1534, 1534, 1534, 1713, 1534, 1534, 1534, 1534,
 /*   150 */  1534, 1534, 1534, 1534, 1808, 1534, 1996, 2049, 1534, 1534,
 /*   160 */  1534, 1999, 1534, 1534, 1534, 1534, 1666, 1986, 1963, 1977,
 /*   170 */  2033, 1964, 1961, 1980, 1534, 1990, 1534, 1801, 1778, 1534,
 /*   180 */  1534, 1778, 1775, 1775, 1657, 1534, 1534, 1534, 1534, 1534,
 /*   190 */  1534, 1608, 1534, 1608, 1534, 1534, 1608, 1534, 1608, 1608,
 /*   200 */  1608, 1534, 1608, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   210 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1820, 1534,
 /*   220 */  1606, 1810, 1534, 1606, 1534, 1534, 1534, 1606, 2004, 1534,
 /*   230 */  1534, 1534, 1534, 2004, 1534, 1534, 1606, 1534, 1606, 1534,
 /*   240 */  1534, 1534, 1534, 2006, 2004, 1534, 1534, 2006, 2004, 1534,
 /*   250 */  1534, 1534, 2018, 2014, 2006, 2022, 2020, 1992, 1990, 2052,
 /*   260 */  2039, 2035, 1977, 1534, 1534, 1534, 1682, 1534, 1534, 1534,
 /*   270 */  1606, 1566, 1534, 1803, 1814, 1716, 1716, 1716, 1609, 1539,
 /*   280 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   290 */  1534, 1889, 1534, 2017, 2016, 1935, 1934, 1933, 1924, 1888,
 /*   300 */  1534, 1678, 1887, 1886, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   310 */  1534, 1880, 1534, 1534, 1881, 1879, 1878, 1534, 1534, 1534,
 /*   320 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   330 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 2036, 2040, 1960,
 /*   340 */  1534, 1534, 1534, 1534, 1534, 1871, 1862, 1534, 1534, 1534,
 /*   350 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   360 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   370 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   380 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   390 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   400 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   410 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   420 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   430 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   440 */  1534, 1534, 1534, 1534, 1571, 1534, 1534, 1534, 1534, 1534,
 /*   450 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   460 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   470 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   480 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1647,
 /*   490 */  1646, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   500 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1870,
 /*   510 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   520 */  1534, 1534, 1534, 2032, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   530 */  1534, 1818, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   540 */  1534, 1921, 1534, 1534, 1534, 1993, 1534, 1534, 1534, 1534,
 /*   550 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   560 */  1534, 1862, 1534, 2015, 1534, 1534, 2030, 1534, 2034, 1534,
 /*   570 */  1534, 1534, 1534, 1534, 1534, 1534, 1970, 1966, 1534, 1534,
 /*   580 */  1962, 1861, 1534, 1955, 1534, 1534, 1906, 1534, 1534, 1534,
 /*   590 */  1534, 1534, 1534, 1534, 1534, 1534, 1870, 1534, 1874, 1534,
 /*   600 */  1534, 1534, 1534, 1534, 1710, 1534, 1534, 1534, 1534, 1534,
 /*   610 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1695, 1693, 1692,
 /*   620 */  1691, 1534, 1688, 1534, 1534, 1534, 1534, 1719, 1718, 1534,
 /*   630 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   640 */  1534, 1534, 1534, 1534, 1628, 1534, 1534, 1534, 1534, 1534,
 /*   650 */  1534, 1534, 1534, 1534, 1619, 1534, 1618, 1534, 1534, 1534,
 /*   660 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   670 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
 /*   680 */  1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534, 1534,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  263,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  263,  /*      AFTER => ABORT */
  263,  /*     ATTACH => ABORT */
  263,  /*     BEFORE => ABORT */
  263,  /*      BEGIN => ABORT */
  263,  /*     BITAND => ABORT */
  263,  /*     BITNOT => ABORT */
  263,  /*      BITOR => ABORT */
  263,  /*     BLOCKS => ABORT */
  263,  /*     CHANGE => ABORT */
  263,  /*      COMMA => ABORT */
  263,  /*    COMPACT => ABORT */
  263,  /*     CONCAT => ABORT */
  263,  /*   CONFLICT => ABORT */
  263,  /*       COPY => ABORT */
  263,  /*   DEFERRED => ABORT */
  263,  /* DELIMITERS => ABORT */
  263,  /*     DETACH => ABORT */
  263,  /*     DIVIDE => ABORT */
  263,  /*        DOT => ABORT */
  263,  /*       EACH => ABORT */
  263,  /*       FAIL => ABORT */
  263,  /*       FILE => ABORT */
  263,  /*        FOR => ABORT */
  263,  /*       GLOB => ABORT */
  263,  /*         ID => ABORT */
  263,  /*  IMMEDIATE => ABORT */
  263,  /*     IMPORT => ABORT */
  263,  /*  INITIALLY => ABORT */
  263,  /*    INSTEAD => ABORT */
  263,  /*     ISNULL => ABORT */
  263,  /*        KEY => ABORT */
  263,  /*  NK_BITNOT => ABORT */
  263,  /*    NK_SEMI => ABORT */
  263,  /*    NOTNULL => ABORT */
  263,  /*         OF => ABORT */
  263,  /*       PLUS => ABORT */
  263,  /*  PRIVILEGE => ABORT */
  263,  /*      RAISE => ABORT */
  263,  /*    REPLACE => ABORT */
  263,  /*   RESTRICT => ABORT */
  263,  /*        ROW => ABORT */
  263,  /*       SEMI => ABORT */
  263,  /*       STAR => ABORT */
  263,  /*  STATEMENT => ABORT */
  263,  /*     STRING => ABORT */
  263,  /*      TIMES => ABORT */
  263,  /*     UPDATE => ABORT */
  263,  /*     VALUES => ABORT */
  263,  /*   VARIABLE => ABORT */
  263,  /*       VIEW => ABORT */
  263,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "MODULES",
  /*  138 */ "QNODES",
  /*  139 */ "FUNCTIONS",
  /*  140 */ "INDEXES",
  /*  141 */ "ACCOUNTS",
  /*  142 */ "APPS",
  /*  143 */ "CONNECTIONS",
  /*  144 */ "LICENCES",
  /*  145 */ "GRANTS",
  /*  146 */ "QUERIES",
  /*  147 */ "SCORES",
  /*  148 */ "TOPICS",
  /*  149 */ "VARIABLES",
  /*  150 */ "BNODES",
  /*  151 */ "SNODES",
  /*  152 */ "CLUSTER",
  /*  153 */ "TRANSACTIONS",
  /*  154 */ "DISTRIBUTED",
  /*  155 */ "CONSUMERS",
  /*  156 */ "SUBSCRIPTIONS",
  /*  157 */ "VNODES",
  /*  158 */ "LIKE",
  /*  159 */ "INDEX",
  /*  160 */ "FUNCTION",
  /*  161 */ "INTERVAL",
  /*  162 */ "TOPIC",
  /*  163 */ "AS",
  /*  164 */ "WITH",
  /*  165 */ "META",
  /*  166 */ "CONSUMER",
  /*  167 */ "GROUP",
  /*  168 */ "DESC",
  /*  169 */ "DESCRIBE",
  /*  170 */ "RESET",
  /*  171 */ "QUERY",
  /*  172 */ "CACHE",
  /*  173 */ "EXPLAIN",
  /*  174 */ "ANALYZE",
  /*  175 */ "VERBOSE",
  /*  176 */ "NK_BOOL",
  /*  177 */ "RATIO",
  /*  178 */ "NK_FLOAT",
  /*  179 */ "OUTPUTTYPE",
  /*  180 */ "AGGREGATE",
  /*  181 */ "BUFSIZE",
  /*  182 */ "STREAM",
  /*  183 */ "INTO",
  /*  184 */ "TRIGGER",
  /*  185 */ "AT_ONCE",
  /*  186 */ "WINDOW_CLOSE",
  /*  187 */ "IGNORE",
  /*  188 */ "EXPIRED",
  /*  189 */ "SUBTABLE",
  /*  190 */ "KILL",
  /*  191 */ "CONNECTION",
  /*  192 */ "TRANSACTION",
  /*  193 */ "BALANCE",
  /*  194 */ "VGROUP",
  /*  195 */ "MERGE",
  /*  196 */ "REDISTRIBUTE",
  /*  197 */ "SPLIT",
  /*  198 */ "DELETE",
  /*  199 */ "INSERT",
  /*  200 */ "NULL",
  /*  201 */ "NK_QUESTION",
  /*  202 */ "NK_ARROW",
  /*  203 */ "ROWTS",
  /*  204 */ "TBNAME",
  /*  205 */ "QSTART",
  /*  206 */ "QEND",
  /*  207 */ "QDURATION",
  /*  208 */ "WSTART",
  /*  209 */ "WEND",
  /*  210 */ "WDURATION",
  /*  211 */ "CAST",
  /*  212 */ "NOW",
  /*  213 */ "TODAY",
  /*  214 */ "TIMEZONE",
  /*  215 */ "CLIENT_VERSION",
  /*  216 */ "SERVER_VERSION",
  /*  217 */ "SERVER_STATUS",
  /*  218 */ "CURRENT_USER",
  /*  219 */ "COUNT",
  /*  220 */ "LAST_ROW",
  /*  221 */ "CASE",
  /*  222 */ "END",
  /*  223 */ "WHEN",
  /*  224 */ "THEN",
  /*  225 */ "ELSE",
  /*  226 */ "BETWEEN",
  /*  227 */ "IS",
  /*  228 */ "NK_LT",
  /*  229 */ "NK_GT",
  /*  230 */ "NK_LE",
  /*  231 */ "NK_GE",
  /*  232 */ "NK_NE",
  /*  233 */ "MATCH",
  /*  234 */ "NMATCH",
  /*  235 */ "CONTAINS",
  /*  236 */ "IN",
  /*  237 */ "JOIN",
  /*  238 */ "INNER",
  /*  239 */ "SELECT",
  /*  240 */ "DISTINCT",
  /*  241 */ "WHERE",
  /*  242 */ "PARTITION",
  /*  243 */ "BY",
  /*  244 */ "SESSION",
  /*  245 */ "STATE_WINDOW",
  /*  246 */ "SLIDING",
  /*  247 */ "FILL",
  /*  248 */ "VALUE",
  /*  249 */ "NONE",
  /*  250 */ "PREV",
  /*  251 */ "LINEAR",
  /*  252 */ "NEXT",
  /*  253 */ "HAVING",
  /*  254 */ "RANGE",
  /*  255 */ "EVERY",
  /*  256 */ "ORDER",
  /*  257 */ "SLIMIT",
  /*  258 */ "SOFFSET",
  /*  259 */ "LIMIT",
  /*  260 */ "OFFSET",
  /*  261 */ "ASC",
  /*  262 */ "NULLS",
  /*  263 */ "ABORT",
  /*  264 */ "AFTER",
  /*  265 */ "ATTACH",
  /*  266 */ "BEFORE",
  /*  267 */ "BEGIN",
  /*  268 */ "BITAND",
  /*  269 */ "BITNOT",
  /*  270 */ "BITOR",
  /*  271 */ "BLOCKS",
  /*  272 */ "CHANGE",
  /*  273 */ "COMMA",
  /*  274 */ "COMPACT",
  /*  275 */ "CONCAT",
  /*  276 */ "CONFLICT",
  /*  277 */ "COPY",
  /*  278 */ "DEFERRED",
  /*  279 */ "DELIMITERS",
  /*  280 */ "DETACH",
  /*  281 */ "DIVIDE",
  /*  282 */ "DOT",
  /*  283 */ "EACH",
  /*  284 */ "FAIL",
  /*  285 */ "FILE",
  /*  286 */ "FOR",
  /*  287 */ "GLOB",
  /*  288 */ "ID",
  /*  289 */ "IMMEDIATE",
  /*  290 */ "IMPORT",
  /*  291 */ "INITIALLY",
  /*  292 */ "INSTEAD",
  /*  293 */ "ISNULL",
  /*  294 */ "KEY",
  /*  295 */ "NK_BITNOT",
  /*  296 */ "NK_SEMI",
  /*  297 */ "NOTNULL",
  /*  298 */ "OF",
  /*  299 */ "PLUS",
  /*  300 */ "PRIVILEGE",
  /*  301 */ "RAISE",
  /*  302 */ "REPLACE",
  /*  303 */ "RESTRICT",
  /*  304 */ "ROW",
  /*  305 */ "SEMI",
  /*  306 */ "STAR",
  /*  307 */ "STATEMENT",
  /*  308 */ "STRING",
  /*  309 */ "TIMES",
  /*  310 */ "UPDATE",
  /*  311 */ "VALUES",
  /*  312 */ "VARIABLE",
  /*  313 */ "VIEW",
  /*  314 */ "WAL",
  /*  315 */ "cmd",
  /*  316 */ "account_options",
  /*  317 */ "alter_account_options",
  /*  318 */ "literal",
  /*  319 */ "alter_account_option",
  /*  320 */ "user_name",
  /*  321 */ "sysinfo_opt",
  /*  322 */ "privileges",
  /*  323 */ "priv_level",
  /*  324 */ "priv_type_list",
  /*  325 */ "priv_type",
  /*  326 */ "db_name",
  /*  327 */ "dnode_endpoint",
  /*  328 */ "not_exists_opt",
  /*  329 */ "db_options",
  /*  330 */ "exists_opt",
  /*  331 */ "alter_db_options",
  /*  332 */ "speed_opt",
  /*  333 */ "integer_list",
  /*  334 */ "variable_list",
  /*  335 */ "retention_list",
  /*  336 */ "alter_db_option",
  /*  337 */ "retention",
  /*  338 */ "full_table_name",
  /*  339 */ "column_def_list",
  /*  340 */ "tags_def_opt",
  /*  341 */ "table_options",
  /*  342 */ "multi_create_clause",
  /*  343 */ "tags_def",
  /*  344 */ "multi_drop_clause",
  /*  345 */ "alter_table_clause",
  /*  346 */ "alter_table_options",
  /*  347 */ "column_name",
  /*  348 */ "type_name",
  /*  349 */ "signed_literal",
  /*  350 */ "create_subtable_clause",
  /*  351 */ "specific_cols_opt",
  /*  352 */ "expression_list",
  /*  353 */ "drop_table_clause",
  /*  354 */ "col_name_list",
  /*  355 */ "table_name",
  /*  356 */ "column_def",
  /*  357 */ "duration_list",
  /*  358 */ "rollup_func_list",
  /*  359 */ "alter_table_option",
  /*  360 */ "duration_literal",
  /*  361 */ "rollup_func_name",
  /*  362 */ "function_name",
  /*  363 */ "col_name",
  /*  364 */ "db_name_cond_opt",
  /*  365 */ "like_pattern_opt",
  /*  366 */ "table_name_cond",
  /*  367 */ "from_db_opt",
  /*  368 */ "index_options",
  /*  369 */ "func_list",
  /*  370 */ "sliding_opt",
  /*  371 */ "sma_stream_opt",
  /*  372 */ "func",
  /*  373 */ "stream_options",
  /*  374 */ "topic_name",
  /*  375 */ "query_or_subquery",
  /*  376 */ "cgroup_name",
  /*  377 */ "analyze_opt",
  /*  378 */ "explain_options",
  /*  379 */ "agg_func_opt",
  /*  380 */ "bufsize_opt",
  /*  381 */ "stream_name",
  /*  382 */ "subtable_opt",
  /*  383 */ "expression",
  /*  384 */ "dnode_list",
  /*  385 */ "where_clause_opt",
  /*  386 */ "signed",
  /*  387 */ "literal_func",
  /*  388 */ "literal_list",
  /*  389 */ "table_alias",
  /*  390 */ "column_alias",
  /*  391 */ "expr_or_subquery",
  /*  392 */ "subquery",
  /*  393 */ "pseudo_column",
  /*  394 */ "column_reference",
  /*  395 */ "function_expression",
  /*  396 */ "case_when_expression",
  /*  397 */ "star_func",
  /*  398 */ "star_func_para_list",
  /*  399 */ "noarg_func",
  /*  400 */ "other_para_list",
  /*  401 */ "star_func_para",
  /*  402 */ "when_then_list",
  /*  403 */ "case_when_else_opt",
  /*  404 */ "common_expression",
  /*  405 */ "when_then_expr",
  /*  406 */ "predicate",
  /*  407 */ "compare_op",
  /*  408 */ "in_op",
  /*  409 */ "in_predicate_value",
  /*  410 */ "boolean_value_expression",
  /*  411 */ "boolean_primary",
  /*  412 */ "from_clause_opt",
  /*  413 */ "table_reference_list",
  /*  414 */ "table_reference",
  /*  415 */ "table_primary",
  /*  416 */ "joined_table",
  /*  417 */ "alias_opt",
  /*  418 */ "parenthesized_joined_table",
  /*  419 */ "join_type",
  /*  420 */ "search_condition",
  /*  421 */ "query_specification",
  /*  422 */ "set_quantifier_opt",
  /*  423 */ "select_list",
  /*  424 */ "partition_by_clause_opt",
  /*  425 */ "range_opt",
  /*  426 */ "every_opt",
  /*  427 */ "fill_opt",
  /*  428 */ "twindow_clause_opt",
  /*  429 */ "group_by_clause_opt",
  /*  430 */ "having_clause_opt",
  /*  431 */ "select_item",
  /*  432 */ "partition_list",
  /*  433 */ "partition_item",
  /*  434 */ "fill_mode",
  /*  435 */ "group_by_list",
  /*  436 */ "query_expression",
  /*  437 */ "query_simple",
  /*  438 */ "order_by_clause_opt",
  /*  439 */ "slimit_clause_opt",
  /*  440 */ "limit_clause_opt",
  /*  441 */ "union_query_expression",
  /*  442 */ "query_simple_or_subquery",
  /*  443 */ "sort_specification_list",
  /*  444 */ "sort_specification",
  /*  445 */ "ordering_specification_opt",
  /*  446 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 107 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 108 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "alter_db_option ::= KEEP integer_list",
 /* 110 */ "alter_db_option ::= KEEP variable_list",
 /* 111 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 112 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 113 */ "integer_list ::= NK_INTEGER",
 /* 114 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 115 */ "variable_list ::= NK_VARIABLE",
 /* 116 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 117 */ "retention_list ::= retention",
 /* 118 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 119 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 120 */ "speed_opt ::=",
 /* 121 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 122 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 123 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 124 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 125 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 126 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 127 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 128 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 129 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 130 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 131 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 132 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 134 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 136 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 138 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 139 */ "multi_create_clause ::= create_subtable_clause",
 /* 140 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 141 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 142 */ "multi_drop_clause ::= drop_table_clause",
 /* 143 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 144 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 145 */ "specific_cols_opt ::=",
 /* 146 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 147 */ "full_table_name ::= table_name",
 /* 148 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 149 */ "column_def_list ::= column_def",
 /* 150 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 151 */ "column_def ::= column_name type_name",
 /* 152 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 153 */ "type_name ::= BOOL",
 /* 154 */ "type_name ::= TINYINT",
 /* 155 */ "type_name ::= SMALLINT",
 /* 156 */ "type_name ::= INT",
 /* 157 */ "type_name ::= INTEGER",
 /* 158 */ "type_name ::= BIGINT",
 /* 159 */ "type_name ::= FLOAT",
 /* 160 */ "type_name ::= DOUBLE",
 /* 161 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= TIMESTAMP",
 /* 163 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 164 */ "type_name ::= TINYINT UNSIGNED",
 /* 165 */ "type_name ::= SMALLINT UNSIGNED",
 /* 166 */ "type_name ::= INT UNSIGNED",
 /* 167 */ "type_name ::= BIGINT UNSIGNED",
 /* 168 */ "type_name ::= JSON",
 /* 169 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= MEDIUMBLOB",
 /* 171 */ "type_name ::= BLOB",
 /* 172 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 173 */ "type_name ::= DECIMAL",
 /* 174 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 175 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 176 */ "tags_def_opt ::=",
 /* 177 */ "tags_def_opt ::= tags_def",
 /* 178 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 179 */ "table_options ::=",
 /* 180 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 181 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 182 */ "table_options ::= table_options WATERMARK duration_list",
 /* 183 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 184 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 185 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 186 */ "alter_table_options ::= alter_table_option",
 /* 187 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 188 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 189 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 190 */ "duration_list ::= duration_literal",
 /* 191 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 192 */ "rollup_func_list ::= rollup_func_name",
 /* 193 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 194 */ "rollup_func_name ::= function_name",
 /* 195 */ "rollup_func_name ::= FIRST",
 /* 196 */ "rollup_func_name ::= LAST",
 /* 197 */ "col_name_list ::= col_name",
 /* 198 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 199 */ "col_name ::= column_name",
 /* 200 */ "cmd ::= SHOW DNODES",
 /* 201 */ "cmd ::= SHOW USERS",
 /* 202 */ "cmd ::= SHOW DATABASES",
 /* 203 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 204 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 205 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 206 */ "cmd ::= SHOW MNODES",
 /* 207 */ "cmd ::= SHOW MODULES",
 /* 208 */ "cmd ::= SHOW QNODES",
 /* 209 */ "cmd ::= SHOW FUNCTIONS",
 /* 210 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 211 */ "cmd ::= SHOW STREAMS",
 /* 212 */ "cmd ::= SHOW ACCOUNTS",
 /* 213 */ "cmd ::= SHOW APPS",
 /* 214 */ "cmd ::= SHOW CONNECTIONS",
 /* 215 */ "cmd ::= SHOW LICENCES",
 /* 216 */ "cmd ::= SHOW GRANTS",
 /* 217 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 218 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 219 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 220 */ "cmd ::= SHOW QUERIES",
 /* 221 */ "cmd ::= SHOW SCORES",
 /* 222 */ "cmd ::= SHOW TOPICS",
 /* 223 */ "cmd ::= SHOW VARIABLES",
 /* 224 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 225 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 226 */ "cmd ::= SHOW BNODES",
 /* 227 */ "cmd ::= SHOW SNODES",
 /* 228 */ "cmd ::= SHOW CLUSTER",
 /* 229 */ "cmd ::= SHOW TRANSACTIONS",
 /* 230 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 231 */ "cmd ::= SHOW CONSUMERS",
 /* 232 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 233 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 234 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 235 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 236 */ "db_name_cond_opt ::=",
 /* 237 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 238 */ "like_pattern_opt ::=",
 /* 239 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 240 */ "table_name_cond ::= table_name",
 /* 241 */ "from_db_opt ::=",
 /* 242 */ "from_db_opt ::= FROM db_name",
 /* 243 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 244 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 245 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 246 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 247 */ "func_list ::= func",
 /* 248 */ "func_list ::= func_list NK_COMMA func",
 /* 249 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 250 */ "sma_stream_opt ::=",
 /* 251 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 252 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 253 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 254 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 255 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 256 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 257 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 258 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 259 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 260 */ "cmd ::= DESC full_table_name",
 /* 261 */ "cmd ::= DESCRIBE full_table_name",
 /* 262 */ "cmd ::= RESET QUERY CACHE",
 /* 263 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 264 */ "analyze_opt ::=",
 /* 265 */ "analyze_opt ::= ANALYZE",
 /* 266 */ "explain_options ::=",
 /* 267 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 268 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 269 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 270 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 271 */ "agg_func_opt ::=",
 /* 272 */ "agg_func_opt ::= AGGREGATE",
 /* 273 */ "bufsize_opt ::=",
 /* 274 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 275 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 276 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 277 */ "stream_options ::=",
 /* 278 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 279 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 280 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 281 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 282 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 283 */ "subtable_opt ::=",
 /* 284 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 285 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 286 */ "cmd ::= KILL QUERY NK_STRING",
 /* 287 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 288 */ "cmd ::= BALANCE VGROUP",
 /* 289 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 290 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 291 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 292 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 293 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 294 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 295 */ "cmd ::= query_or_subquery",
 /* 296 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 297 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 298 */ "literal ::= NK_INTEGER",
 /* 299 */ "literal ::= NK_FLOAT",
 /* 300 */ "literal ::= NK_STRING",
 /* 301 */ "literal ::= NK_BOOL",
 /* 302 */ "literal ::= TIMESTAMP NK_STRING",
 /* 303 */ "literal ::= duration_literal",
 /* 304 */ "literal ::= NULL",
 /* 305 */ "literal ::= NK_QUESTION",
 /* 306 */ "duration_literal ::= NK_VARIABLE",
 /* 307 */ "signed ::= NK_INTEGER",
 /* 308 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 309 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 310 */ "signed ::= NK_FLOAT",
 /* 311 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 312 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 313 */ "signed_literal ::= signed",
 /* 314 */ "signed_literal ::= NK_STRING",
 /* 315 */ "signed_literal ::= NK_BOOL",
 /* 316 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 317 */ "signed_literal ::= duration_literal",
 /* 318 */ "signed_literal ::= NULL",
 /* 319 */ "signed_literal ::= literal_func",
 /* 320 */ "signed_literal ::= NK_QUESTION",
 /* 321 */ "literal_list ::= signed_literal",
 /* 322 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 323 */ "db_name ::= NK_ID",
 /* 324 */ "table_name ::= NK_ID",
 /* 325 */ "column_name ::= NK_ID",
 /* 326 */ "function_name ::= NK_ID",
 /* 327 */ "table_alias ::= NK_ID",
 /* 328 */ "column_alias ::= NK_ID",
 /* 329 */ "user_name ::= NK_ID",
 /* 330 */ "topic_name ::= NK_ID",
 /* 331 */ "stream_name ::= NK_ID",
 /* 332 */ "cgroup_name ::= NK_ID",
 /* 333 */ "expr_or_subquery ::= expression",
 /* 334 */ "expr_or_subquery ::= subquery",
 /* 335 */ "expression ::= literal",
 /* 336 */ "expression ::= pseudo_column",
 /* 337 */ "expression ::= column_reference",
 /* 338 */ "expression ::= function_expression",
 /* 339 */ "expression ::= case_when_expression",
 /* 340 */ "expression ::= NK_LP expression NK_RP",
 /* 341 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 342 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 343 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 344 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 345 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 346 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 347 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 348 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 349 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 350 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 351 */ "expression_list ::= expr_or_subquery",
 /* 352 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 353 */ "column_reference ::= column_name",
 /* 354 */ "column_reference ::= table_name NK_DOT column_name",
 /* 355 */ "pseudo_column ::= ROWTS",
 /* 356 */ "pseudo_column ::= TBNAME",
 /* 357 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 358 */ "pseudo_column ::= QSTART",
 /* 359 */ "pseudo_column ::= QEND",
 /* 360 */ "pseudo_column ::= QDURATION",
 /* 361 */ "pseudo_column ::= WSTART",
 /* 362 */ "pseudo_column ::= WEND",
 /* 363 */ "pseudo_column ::= WDURATION",
 /* 364 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 365 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 366 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 367 */ "function_expression ::= literal_func",
 /* 368 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 369 */ "literal_func ::= NOW",
 /* 370 */ "noarg_func ::= NOW",
 /* 371 */ "noarg_func ::= TODAY",
 /* 372 */ "noarg_func ::= TIMEZONE",
 /* 373 */ "noarg_func ::= DATABASE",
 /* 374 */ "noarg_func ::= CLIENT_VERSION",
 /* 375 */ "noarg_func ::= SERVER_VERSION",
 /* 376 */ "noarg_func ::= SERVER_STATUS",
 /* 377 */ "noarg_func ::= CURRENT_USER",
 /* 378 */ "noarg_func ::= USER",
 /* 379 */ "star_func ::= COUNT",
 /* 380 */ "star_func ::= FIRST",
 /* 381 */ "star_func ::= LAST",
 /* 382 */ "star_func ::= LAST_ROW",
 /* 383 */ "star_func_para_list ::= NK_STAR",
 /* 384 */ "star_func_para_list ::= other_para_list",
 /* 385 */ "other_para_list ::= star_func_para",
 /* 386 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 387 */ "star_func_para ::= expr_or_subquery",
 /* 388 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 389 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 390 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 391 */ "when_then_list ::= when_then_expr",
 /* 392 */ "when_then_list ::= when_then_list when_then_expr",
 /* 393 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 394 */ "case_when_else_opt ::=",
 /* 395 */ "case_when_else_opt ::= ELSE common_expression",
 /* 396 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 397 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 398 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 399 */ "predicate ::= expr_or_subquery IS NULL",
 /* 400 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 401 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 402 */ "compare_op ::= NK_LT",
 /* 403 */ "compare_op ::= NK_GT",
 /* 404 */ "compare_op ::= NK_LE",
 /* 405 */ "compare_op ::= NK_GE",
 /* 406 */ "compare_op ::= NK_NE",
 /* 407 */ "compare_op ::= NK_EQ",
 /* 408 */ "compare_op ::= LIKE",
 /* 409 */ "compare_op ::= NOT LIKE",
 /* 410 */ "compare_op ::= MATCH",
 /* 411 */ "compare_op ::= NMATCH",
 /* 412 */ "compare_op ::= CONTAINS",
 /* 413 */ "in_op ::= IN",
 /* 414 */ "in_op ::= NOT IN",
 /* 415 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 416 */ "boolean_value_expression ::= boolean_primary",
 /* 417 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 418 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 419 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 420 */ "boolean_primary ::= predicate",
 /* 421 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 422 */ "common_expression ::= expr_or_subquery",
 /* 423 */ "common_expression ::= boolean_value_expression",
 /* 424 */ "from_clause_opt ::=",
 /* 425 */ "from_clause_opt ::= FROM table_reference_list",
 /* 426 */ "table_reference_list ::= table_reference",
 /* 427 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 428 */ "table_reference ::= table_primary",
 /* 429 */ "table_reference ::= joined_table",
 /* 430 */ "table_primary ::= table_name alias_opt",
 /* 431 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 432 */ "table_primary ::= subquery alias_opt",
 /* 433 */ "table_primary ::= parenthesized_joined_table",
 /* 434 */ "alias_opt ::=",
 /* 435 */ "alias_opt ::= table_alias",
 /* 436 */ "alias_opt ::= AS table_alias",
 /* 437 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 438 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 439 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 440 */ "join_type ::=",
 /* 441 */ "join_type ::= INNER",
 /* 442 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 443 */ "set_quantifier_opt ::=",
 /* 444 */ "set_quantifier_opt ::= DISTINCT",
 /* 445 */ "set_quantifier_opt ::= ALL",
 /* 446 */ "select_list ::= select_item",
 /* 447 */ "select_list ::= select_list NK_COMMA select_item",
 /* 448 */ "select_item ::= NK_STAR",
 /* 449 */ "select_item ::= common_expression",
 /* 450 */ "select_item ::= common_expression column_alias",
 /* 451 */ "select_item ::= common_expression AS column_alias",
 /* 452 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 453 */ "where_clause_opt ::=",
 /* 454 */ "where_clause_opt ::= WHERE search_condition",
 /* 455 */ "partition_by_clause_opt ::=",
 /* 456 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 457 */ "partition_list ::= partition_item",
 /* 458 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 459 */ "partition_item ::= expr_or_subquery",
 /* 460 */ "partition_item ::= expr_or_subquery column_alias",
 /* 461 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 462 */ "twindow_clause_opt ::=",
 /* 463 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 464 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 465 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 466 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 467 */ "sliding_opt ::=",
 /* 468 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 469 */ "fill_opt ::=",
 /* 470 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 471 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 472 */ "fill_mode ::= NONE",
 /* 473 */ "fill_mode ::= PREV",
 /* 474 */ "fill_mode ::= NULL",
 /* 475 */ "fill_mode ::= LINEAR",
 /* 476 */ "fill_mode ::= NEXT",
 /* 477 */ "group_by_clause_opt ::=",
 /* 478 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 479 */ "group_by_list ::= expr_or_subquery",
 /* 480 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 481 */ "having_clause_opt ::=",
 /* 482 */ "having_clause_opt ::= HAVING search_condition",
 /* 483 */ "range_opt ::=",
 /* 484 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 485 */ "every_opt ::=",
 /* 486 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 487 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 488 */ "query_simple ::= query_specification",
 /* 489 */ "query_simple ::= union_query_expression",
 /* 490 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 491 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 492 */ "query_simple_or_subquery ::= query_simple",
 /* 493 */ "query_simple_or_subquery ::= subquery",
 /* 494 */ "query_or_subquery ::= query_expression",
 /* 495 */ "query_or_subquery ::= subquery",
 /* 496 */ "order_by_clause_opt ::=",
 /* 497 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 498 */ "slimit_clause_opt ::=",
 /* 499 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 500 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 501 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 502 */ "limit_clause_opt ::=",
 /* 503 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 504 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 505 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 506 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 507 */ "subquery ::= NK_LP subquery NK_RP",
 /* 508 */ "search_condition ::= common_expression",
 /* 509 */ "sort_specification_list ::= sort_specification",
 /* 510 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 511 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 512 */ "ordering_specification_opt ::=",
 /* 513 */ "ordering_specification_opt ::= ASC",
 /* 514 */ "ordering_specification_opt ::= DESC",
 /* 515 */ "null_ordering_opt ::=",
 /* 516 */ "null_ordering_opt ::= NULLS FIRST",
 /* 517 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 315: /* cmd */
    case 318: /* literal */
    case 329: /* db_options */
    case 331: /* alter_db_options */
    case 337: /* retention */
    case 338: /* full_table_name */
    case 341: /* table_options */
    case 345: /* alter_table_clause */
    case 346: /* alter_table_options */
    case 349: /* signed_literal */
    case 350: /* create_subtable_clause */
    case 353: /* drop_table_clause */
    case 356: /* column_def */
    case 360: /* duration_literal */
    case 361: /* rollup_func_name */
    case 363: /* col_name */
    case 364: /* db_name_cond_opt */
    case 365: /* like_pattern_opt */
    case 366: /* table_name_cond */
    case 367: /* from_db_opt */
    case 368: /* index_options */
    case 370: /* sliding_opt */
    case 371: /* sma_stream_opt */
    case 372: /* func */
    case 373: /* stream_options */
    case 375: /* query_or_subquery */
    case 378: /* explain_options */
    case 382: /* subtable_opt */
    case 383: /* expression */
    case 385: /* where_clause_opt */
    case 386: /* signed */
    case 387: /* literal_func */
    case 391: /* expr_or_subquery */
    case 392: /* subquery */
    case 393: /* pseudo_column */
    case 394: /* column_reference */
    case 395: /* function_expression */
    case 396: /* case_when_expression */
    case 401: /* star_func_para */
    case 403: /* case_when_else_opt */
    case 404: /* common_expression */
    case 405: /* when_then_expr */
    case 406: /* predicate */
    case 409: /* in_predicate_value */
    case 410: /* boolean_value_expression */
    case 411: /* boolean_primary */
    case 412: /* from_clause_opt */
    case 413: /* table_reference_list */
    case 414: /* table_reference */
    case 415: /* table_primary */
    case 416: /* joined_table */
    case 418: /* parenthesized_joined_table */
    case 420: /* search_condition */
    case 421: /* query_specification */
    case 425: /* range_opt */
    case 426: /* every_opt */
    case 427: /* fill_opt */
    case 428: /* twindow_clause_opt */
    case 430: /* having_clause_opt */
    case 431: /* select_item */
    case 433: /* partition_item */
    case 436: /* query_expression */
    case 437: /* query_simple */
    case 439: /* slimit_clause_opt */
    case 440: /* limit_clause_opt */
    case 441: /* union_query_expression */
    case 442: /* query_simple_or_subquery */
    case 444: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy392)); 
}
      break;
    case 316: /* account_options */
    case 317: /* alter_account_options */
    case 319: /* alter_account_option */
    case 332: /* speed_opt */
    case 380: /* bufsize_opt */
{
 
}
      break;
    case 320: /* user_name */
    case 323: /* priv_level */
    case 326: /* db_name */
    case 327: /* dnode_endpoint */
    case 347: /* column_name */
    case 355: /* table_name */
    case 362: /* function_name */
    case 374: /* topic_name */
    case 376: /* cgroup_name */
    case 381: /* stream_name */
    case 389: /* table_alias */
    case 390: /* column_alias */
    case 397: /* star_func */
    case 399: /* noarg_func */
    case 417: /* alias_opt */
{
 
}
      break;
    case 321: /* sysinfo_opt */
{
 
}
      break;
    case 322: /* privileges */
    case 324: /* priv_type_list */
    case 325: /* priv_type */
{
 
}
      break;
    case 328: /* not_exists_opt */
    case 330: /* exists_opt */
    case 377: /* analyze_opt */
    case 379: /* agg_func_opt */
    case 422: /* set_quantifier_opt */
{
 
}
      break;
    case 333: /* integer_list */
    case 334: /* variable_list */
    case 335: /* retention_list */
    case 339: /* column_def_list */
    case 340: /* tags_def_opt */
    case 342: /* multi_create_clause */
    case 343: /* tags_def */
    case 344: /* multi_drop_clause */
    case 351: /* specific_cols_opt */
    case 352: /* expression_list */
    case 354: /* col_name_list */
    case 357: /* duration_list */
    case 358: /* rollup_func_list */
    case 369: /* func_list */
    case 384: /* dnode_list */
    case 388: /* literal_list */
    case 398: /* star_func_para_list */
    case 400: /* other_para_list */
    case 402: /* when_then_list */
    case 423: /* select_list */
    case 424: /* partition_by_clause_opt */
    case 429: /* group_by_clause_opt */
    case 432: /* partition_list */
    case 435: /* group_by_list */
    case 438: /* order_by_clause_opt */
    case 443: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy148)); 
}
      break;
    case 336: /* alter_db_option */
    case 359: /* alter_table_option */
{
 
}
      break;
    case 348: /* type_name */
{
 
}
      break;
    case 407: /* compare_op */
    case 408: /* in_op */
{
 
}
      break;
    case 419: /* join_type */
{
 
}
      break;
    case 434: /* fill_mode */
{
 
}
      break;
    case 445: /* ordering_specification_opt */
{
 
}
      break;
    case 446: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  315,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  315,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  316,    0 }, /* (2) account_options ::= */
  {  316,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  316,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  316,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  316,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  316,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  316,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  316,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  316,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  316,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  317,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  317,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  319,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  319,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  319,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  319,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  319,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  319,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  319,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  319,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  319,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  319,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  315,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  315,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  315,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  315,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  315,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  321,    0 }, /* (29) sysinfo_opt ::= */
  {  321,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  315,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  315,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  322,   -1 }, /* (33) privileges ::= ALL */
  {  322,   -1 }, /* (34) privileges ::= priv_type_list */
  {  324,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  324,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  325,   -1 }, /* (37) priv_type ::= READ */
  {  325,   -1 }, /* (38) priv_type ::= WRITE */
  {  323,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  323,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  315,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  315,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  315,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  315,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  315,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  315,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  315,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  315,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  327,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  327,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  327,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  315,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  315,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  315,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  315,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  315,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  315,   -2 }, /* (64) cmd ::= USE db_name */
  {  315,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  315,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  315,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  328,    0 }, /* (69) not_exists_opt ::= */
  {  330,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  330,    0 }, /* (71) exists_opt ::= */
  {  329,    0 }, /* (72) db_options ::= */
  {  329,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  329,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  329,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  329,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  329,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  329,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  329,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  329,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  329,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  329,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  329,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  329,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  329,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  329,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  329,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  329,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  329,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  329,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  329,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  329,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  329,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  329,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  329,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  329,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  329,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  329,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  329,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  329,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  329,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  329,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  329,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  331,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  331,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  336,   -2 }, /* (106) alter_db_option ::= CACHEMODEL NK_STRING */
  {  336,   -2 }, /* (107) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  336,   -2 }, /* (108) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  336,   -2 }, /* (109) alter_db_option ::= KEEP integer_list */
  {  336,   -2 }, /* (110) alter_db_option ::= KEEP variable_list */
  {  336,   -2 }, /* (111) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  336,   -2 }, /* (112) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  333,   -1 }, /* (113) integer_list ::= NK_INTEGER */
  {  333,   -3 }, /* (114) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  334,   -1 }, /* (115) variable_list ::= NK_VARIABLE */
  {  334,   -3 }, /* (116) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  335,   -1 }, /* (117) retention_list ::= retention */
  {  335,   -3 }, /* (118) retention_list ::= retention_list NK_COMMA retention */
  {  337,   -3 }, /* (119) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  332,    0 }, /* (120) speed_opt ::= */
  {  332,   -2 }, /* (121) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  315,   -9 }, /* (122) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  315,   -3 }, /* (123) cmd ::= CREATE TABLE multi_create_clause */
  {  315,   -9 }, /* (124) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  315,   -3 }, /* (125) cmd ::= DROP TABLE multi_drop_clause */
  {  315,   -4 }, /* (126) cmd ::= DROP STABLE exists_opt full_table_name */
  {  315,   -3 }, /* (127) cmd ::= ALTER TABLE alter_table_clause */
  {  315,   -3 }, /* (128) cmd ::= ALTER STABLE alter_table_clause */
  {  345,   -2 }, /* (129) alter_table_clause ::= full_table_name alter_table_options */
  {  345,   -5 }, /* (130) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  345,   -4 }, /* (131) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  345,   -5 }, /* (132) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  345,   -5 }, /* (133) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  345,   -5 }, /* (134) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  345,   -4 }, /* (135) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  345,   -5 }, /* (136) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  345,   -5 }, /* (137) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  345,   -6 }, /* (138) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  342,   -1 }, /* (139) multi_create_clause ::= create_subtable_clause */
  {  342,   -2 }, /* (140) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  350,  -10 }, /* (141) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  344,   -1 }, /* (142) multi_drop_clause ::= drop_table_clause */
  {  344,   -2 }, /* (143) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  353,   -2 }, /* (144) drop_table_clause ::= exists_opt full_table_name */
  {  351,    0 }, /* (145) specific_cols_opt ::= */
  {  351,   -3 }, /* (146) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  338,   -1 }, /* (147) full_table_name ::= table_name */
  {  338,   -3 }, /* (148) full_table_name ::= db_name NK_DOT table_name */
  {  339,   -1 }, /* (149) column_def_list ::= column_def */
  {  339,   -3 }, /* (150) column_def_list ::= column_def_list NK_COMMA column_def */
  {  356,   -2 }, /* (151) column_def ::= column_name type_name */
  {  356,   -4 }, /* (152) column_def ::= column_name type_name COMMENT NK_STRING */
  {  348,   -1 }, /* (153) type_name ::= BOOL */
  {  348,   -1 }, /* (154) type_name ::= TINYINT */
  {  348,   -1 }, /* (155) type_name ::= SMALLINT */
  {  348,   -1 }, /* (156) type_name ::= INT */
  {  348,   -1 }, /* (157) type_name ::= INTEGER */
  {  348,   -1 }, /* (158) type_name ::= BIGINT */
  {  348,   -1 }, /* (159) type_name ::= FLOAT */
  {  348,   -1 }, /* (160) type_name ::= DOUBLE */
  {  348,   -4 }, /* (161) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  348,   -1 }, /* (162) type_name ::= TIMESTAMP */
  {  348,   -4 }, /* (163) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  348,   -2 }, /* (164) type_name ::= TINYINT UNSIGNED */
  {  348,   -2 }, /* (165) type_name ::= SMALLINT UNSIGNED */
  {  348,   -2 }, /* (166) type_name ::= INT UNSIGNED */
  {  348,   -2 }, /* (167) type_name ::= BIGINT UNSIGNED */
  {  348,   -1 }, /* (168) type_name ::= JSON */
  {  348,   -4 }, /* (169) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  348,   -1 }, /* (170) type_name ::= MEDIUMBLOB */
  {  348,   -1 }, /* (171) type_name ::= BLOB */
  {  348,   -4 }, /* (172) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  348,   -1 }, /* (173) type_name ::= DECIMAL */
  {  348,   -4 }, /* (174) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  348,   -6 }, /* (175) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  340,    0 }, /* (176) tags_def_opt ::= */
  {  340,   -1 }, /* (177) tags_def_opt ::= tags_def */
  {  343,   -4 }, /* (178) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  341,    0 }, /* (179) table_options ::= */
  {  341,   -3 }, /* (180) table_options ::= table_options COMMENT NK_STRING */
  {  341,   -3 }, /* (181) table_options ::= table_options MAX_DELAY duration_list */
  {  341,   -3 }, /* (182) table_options ::= table_options WATERMARK duration_list */
  {  341,   -5 }, /* (183) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  341,   -3 }, /* (184) table_options ::= table_options TTL NK_INTEGER */
  {  341,   -5 }, /* (185) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  346,   -1 }, /* (186) alter_table_options ::= alter_table_option */
  {  346,   -2 }, /* (187) alter_table_options ::= alter_table_options alter_table_option */
  {  359,   -2 }, /* (188) alter_table_option ::= COMMENT NK_STRING */
  {  359,   -2 }, /* (189) alter_table_option ::= TTL NK_INTEGER */
  {  357,   -1 }, /* (190) duration_list ::= duration_literal */
  {  357,   -3 }, /* (191) duration_list ::= duration_list NK_COMMA duration_literal */
  {  358,   -1 }, /* (192) rollup_func_list ::= rollup_func_name */
  {  358,   -3 }, /* (193) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  361,   -1 }, /* (194) rollup_func_name ::= function_name */
  {  361,   -1 }, /* (195) rollup_func_name ::= FIRST */
  {  361,   -1 }, /* (196) rollup_func_name ::= LAST */
  {  354,   -1 }, /* (197) col_name_list ::= col_name */
  {  354,   -3 }, /* (198) col_name_list ::= col_name_list NK_COMMA col_name */
  {  363,   -1 }, /* (199) col_name ::= column_name */
  {  315,   -2 }, /* (200) cmd ::= SHOW DNODES */
  {  315,   -2 }, /* (201) cmd ::= SHOW USERS */
  {  315,   -2 }, /* (202) cmd ::= SHOW DATABASES */
  {  315,   -4 }, /* (203) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  315,   -4 }, /* (204) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  315,   -3 }, /* (205) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  315,   -2 }, /* (206) cmd ::= SHOW MNODES */
  {  315,   -2 }, /* (207) cmd ::= SHOW MODULES */
  {  315,   -2 }, /* (208) cmd ::= SHOW QNODES */
  {  315,   -2 }, /* (209) cmd ::= SHOW FUNCTIONS */
  {  315,   -5 }, /* (210) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  315,   -2 }, /* (211) cmd ::= SHOW STREAMS */
  {  315,   -2 }, /* (212) cmd ::= SHOW ACCOUNTS */
  {  315,   -2 }, /* (213) cmd ::= SHOW APPS */
  {  315,   -2 }, /* (214) cmd ::= SHOW CONNECTIONS */
  {  315,   -2 }, /* (215) cmd ::= SHOW LICENCES */
  {  315,   -2 }, /* (216) cmd ::= SHOW GRANTS */
  {  315,   -4 }, /* (217) cmd ::= SHOW CREATE DATABASE db_name */
  {  315,   -4 }, /* (218) cmd ::= SHOW CREATE TABLE full_table_name */
  {  315,   -4 }, /* (219) cmd ::= SHOW CREATE STABLE full_table_name */
  {  315,   -2 }, /* (220) cmd ::= SHOW QUERIES */
  {  315,   -2 }, /* (221) cmd ::= SHOW SCORES */
  {  315,   -2 }, /* (222) cmd ::= SHOW TOPICS */
  {  315,   -2 }, /* (223) cmd ::= SHOW VARIABLES */
  {  315,   -3 }, /* (224) cmd ::= SHOW LOCAL VARIABLES */
  {  315,   -4 }, /* (225) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  315,   -2 }, /* (226) cmd ::= SHOW BNODES */
  {  315,   -2 }, /* (227) cmd ::= SHOW SNODES */
  {  315,   -2 }, /* (228) cmd ::= SHOW CLUSTER */
  {  315,   -2 }, /* (229) cmd ::= SHOW TRANSACTIONS */
  {  315,   -4 }, /* (230) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  315,   -2 }, /* (231) cmd ::= SHOW CONSUMERS */
  {  315,   -2 }, /* (232) cmd ::= SHOW SUBSCRIPTIONS */
  {  315,   -5 }, /* (233) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  315,   -3 }, /* (234) cmd ::= SHOW VNODES NK_INTEGER */
  {  315,   -3 }, /* (235) cmd ::= SHOW VNODES NK_STRING */
  {  364,    0 }, /* (236) db_name_cond_opt ::= */
  {  364,   -2 }, /* (237) db_name_cond_opt ::= db_name NK_DOT */
  {  365,    0 }, /* (238) like_pattern_opt ::= */
  {  365,   -2 }, /* (239) like_pattern_opt ::= LIKE NK_STRING */
  {  366,   -1 }, /* (240) table_name_cond ::= table_name */
  {  367,    0 }, /* (241) from_db_opt ::= */
  {  367,   -2 }, /* (242) from_db_opt ::= FROM db_name */
  {  315,   -8 }, /* (243) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  315,   -4 }, /* (244) cmd ::= DROP INDEX exists_opt full_table_name */
  {  368,  -10 }, /* (245) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  368,  -12 }, /* (246) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  369,   -1 }, /* (247) func_list ::= func */
  {  369,   -3 }, /* (248) func_list ::= func_list NK_COMMA func */
  {  372,   -4 }, /* (249) func ::= function_name NK_LP expression_list NK_RP */
  {  371,    0 }, /* (250) sma_stream_opt ::= */
  {  371,   -3 }, /* (251) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  371,   -3 }, /* (252) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  315,   -6 }, /* (253) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  315,   -7 }, /* (254) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  315,   -9 }, /* (255) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  315,   -7 }, /* (256) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  315,   -9 }, /* (257) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  315,   -4 }, /* (258) cmd ::= DROP TOPIC exists_opt topic_name */
  {  315,   -7 }, /* (259) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  315,   -2 }, /* (260) cmd ::= DESC full_table_name */
  {  315,   -2 }, /* (261) cmd ::= DESCRIBE full_table_name */
  {  315,   -3 }, /* (262) cmd ::= RESET QUERY CACHE */
  {  315,   -4 }, /* (263) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  377,    0 }, /* (264) analyze_opt ::= */
  {  377,   -1 }, /* (265) analyze_opt ::= ANALYZE */
  {  378,    0 }, /* (266) explain_options ::= */
  {  378,   -3 }, /* (267) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  378,   -3 }, /* (268) explain_options ::= explain_options RATIO NK_FLOAT */
  {  315,  -10 }, /* (269) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  315,   -4 }, /* (270) cmd ::= DROP FUNCTION exists_opt function_name */
  {  379,    0 }, /* (271) agg_func_opt ::= */
  {  379,   -1 }, /* (272) agg_func_opt ::= AGGREGATE */
  {  380,    0 }, /* (273) bufsize_opt ::= */
  {  380,   -2 }, /* (274) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  315,  -11 }, /* (275) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  315,   -4 }, /* (276) cmd ::= DROP STREAM exists_opt stream_name */
  {  373,    0 }, /* (277) stream_options ::= */
  {  373,   -3 }, /* (278) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  373,   -3 }, /* (279) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  373,   -4 }, /* (280) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  373,   -3 }, /* (281) stream_options ::= stream_options WATERMARK duration_literal */
  {  373,   -4 }, /* (282) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  382,    0 }, /* (283) subtable_opt ::= */
  {  382,   -4 }, /* (284) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  315,   -3 }, /* (285) cmd ::= KILL CONNECTION NK_INTEGER */
  {  315,   -3 }, /* (286) cmd ::= KILL QUERY NK_STRING */
  {  315,   -3 }, /* (287) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  315,   -2 }, /* (288) cmd ::= BALANCE VGROUP */
  {  315,   -4 }, /* (289) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  315,   -4 }, /* (290) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  315,   -3 }, /* (291) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  384,   -2 }, /* (292) dnode_list ::= DNODE NK_INTEGER */
  {  384,   -3 }, /* (293) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  315,   -4 }, /* (294) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  315,   -1 }, /* (295) cmd ::= query_or_subquery */
  {  315,   -7 }, /* (296) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  315,   -4 }, /* (297) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  318,   -1 }, /* (298) literal ::= NK_INTEGER */
  {  318,   -1 }, /* (299) literal ::= NK_FLOAT */
  {  318,   -1 }, /* (300) literal ::= NK_STRING */
  {  318,   -1 }, /* (301) literal ::= NK_BOOL */
  {  318,   -2 }, /* (302) literal ::= TIMESTAMP NK_STRING */
  {  318,   -1 }, /* (303) literal ::= duration_literal */
  {  318,   -1 }, /* (304) literal ::= NULL */
  {  318,   -1 }, /* (305) literal ::= NK_QUESTION */
  {  360,   -1 }, /* (306) duration_literal ::= NK_VARIABLE */
  {  386,   -1 }, /* (307) signed ::= NK_INTEGER */
  {  386,   -2 }, /* (308) signed ::= NK_PLUS NK_INTEGER */
  {  386,   -2 }, /* (309) signed ::= NK_MINUS NK_INTEGER */
  {  386,   -1 }, /* (310) signed ::= NK_FLOAT */
  {  386,   -2 }, /* (311) signed ::= NK_PLUS NK_FLOAT */
  {  386,   -2 }, /* (312) signed ::= NK_MINUS NK_FLOAT */
  {  349,   -1 }, /* (313) signed_literal ::= signed */
  {  349,   -1 }, /* (314) signed_literal ::= NK_STRING */
  {  349,   -1 }, /* (315) signed_literal ::= NK_BOOL */
  {  349,   -2 }, /* (316) signed_literal ::= TIMESTAMP NK_STRING */
  {  349,   -1 }, /* (317) signed_literal ::= duration_literal */
  {  349,   -1 }, /* (318) signed_literal ::= NULL */
  {  349,   -1 }, /* (319) signed_literal ::= literal_func */
  {  349,   -1 }, /* (320) signed_literal ::= NK_QUESTION */
  {  388,   -1 }, /* (321) literal_list ::= signed_literal */
  {  388,   -3 }, /* (322) literal_list ::= literal_list NK_COMMA signed_literal */
  {  326,   -1 }, /* (323) db_name ::= NK_ID */
  {  355,   -1 }, /* (324) table_name ::= NK_ID */
  {  347,   -1 }, /* (325) column_name ::= NK_ID */
  {  362,   -1 }, /* (326) function_name ::= NK_ID */
  {  389,   -1 }, /* (327) table_alias ::= NK_ID */
  {  390,   -1 }, /* (328) column_alias ::= NK_ID */
  {  320,   -1 }, /* (329) user_name ::= NK_ID */
  {  374,   -1 }, /* (330) topic_name ::= NK_ID */
  {  381,   -1 }, /* (331) stream_name ::= NK_ID */
  {  376,   -1 }, /* (332) cgroup_name ::= NK_ID */
  {  391,   -1 }, /* (333) expr_or_subquery ::= expression */
  {  391,   -1 }, /* (334) expr_or_subquery ::= subquery */
  {  383,   -1 }, /* (335) expression ::= literal */
  {  383,   -1 }, /* (336) expression ::= pseudo_column */
  {  383,   -1 }, /* (337) expression ::= column_reference */
  {  383,   -1 }, /* (338) expression ::= function_expression */
  {  383,   -1 }, /* (339) expression ::= case_when_expression */
  {  383,   -3 }, /* (340) expression ::= NK_LP expression NK_RP */
  {  383,   -2 }, /* (341) expression ::= NK_PLUS expr_or_subquery */
  {  383,   -2 }, /* (342) expression ::= NK_MINUS expr_or_subquery */
  {  383,   -3 }, /* (343) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  383,   -3 }, /* (344) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  383,   -3 }, /* (345) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  383,   -3 }, /* (346) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  383,   -3 }, /* (347) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  383,   -3 }, /* (348) expression ::= column_reference NK_ARROW NK_STRING */
  {  383,   -3 }, /* (349) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  383,   -3 }, /* (350) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  352,   -1 }, /* (351) expression_list ::= expr_or_subquery */
  {  352,   -3 }, /* (352) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  394,   -1 }, /* (353) column_reference ::= column_name */
  {  394,   -3 }, /* (354) column_reference ::= table_name NK_DOT column_name */
  {  393,   -1 }, /* (355) pseudo_column ::= ROWTS */
  {  393,   -1 }, /* (356) pseudo_column ::= TBNAME */
  {  393,   -3 }, /* (357) pseudo_column ::= table_name NK_DOT TBNAME */
  {  393,   -1 }, /* (358) pseudo_column ::= QSTART */
  {  393,   -1 }, /* (359) pseudo_column ::= QEND */
  {  393,   -1 }, /* (360) pseudo_column ::= QDURATION */
  {  393,   -1 }, /* (361) pseudo_column ::= WSTART */
  {  393,   -1 }, /* (362) pseudo_column ::= WEND */
  {  393,   -1 }, /* (363) pseudo_column ::= WDURATION */
  {  395,   -4 }, /* (364) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  395,   -4 }, /* (365) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  395,   -6 }, /* (366) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  395,   -1 }, /* (367) function_expression ::= literal_func */
  {  387,   -3 }, /* (368) literal_func ::= noarg_func NK_LP NK_RP */
  {  387,   -1 }, /* (369) literal_func ::= NOW */
  {  399,   -1 }, /* (370) noarg_func ::= NOW */
  {  399,   -1 }, /* (371) noarg_func ::= TODAY */
  {  399,   -1 }, /* (372) noarg_func ::= TIMEZONE */
  {  399,   -1 }, /* (373) noarg_func ::= DATABASE */
  {  399,   -1 }, /* (374) noarg_func ::= CLIENT_VERSION */
  {  399,   -1 }, /* (375) noarg_func ::= SERVER_VERSION */
  {  399,   -1 }, /* (376) noarg_func ::= SERVER_STATUS */
  {  399,   -1 }, /* (377) noarg_func ::= CURRENT_USER */
  {  399,   -1 }, /* (378) noarg_func ::= USER */
  {  397,   -1 }, /* (379) star_func ::= COUNT */
  {  397,   -1 }, /* (380) star_func ::= FIRST */
  {  397,   -1 }, /* (381) star_func ::= LAST */
  {  397,   -1 }, /* (382) star_func ::= LAST_ROW */
  {  398,   -1 }, /* (383) star_func_para_list ::= NK_STAR */
  {  398,   -1 }, /* (384) star_func_para_list ::= other_para_list */
  {  400,   -1 }, /* (385) other_para_list ::= star_func_para */
  {  400,   -3 }, /* (386) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  401,   -1 }, /* (387) star_func_para ::= expr_or_subquery */
  {  401,   -3 }, /* (388) star_func_para ::= table_name NK_DOT NK_STAR */
  {  396,   -4 }, /* (389) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  396,   -5 }, /* (390) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  402,   -1 }, /* (391) when_then_list ::= when_then_expr */
  {  402,   -2 }, /* (392) when_then_list ::= when_then_list when_then_expr */
  {  405,   -4 }, /* (393) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  403,    0 }, /* (394) case_when_else_opt ::= */
  {  403,   -2 }, /* (395) case_when_else_opt ::= ELSE common_expression */
  {  406,   -3 }, /* (396) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  406,   -5 }, /* (397) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  406,   -6 }, /* (398) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  406,   -3 }, /* (399) predicate ::= expr_or_subquery IS NULL */
  {  406,   -4 }, /* (400) predicate ::= expr_or_subquery IS NOT NULL */
  {  406,   -3 }, /* (401) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  407,   -1 }, /* (402) compare_op ::= NK_LT */
  {  407,   -1 }, /* (403) compare_op ::= NK_GT */
  {  407,   -1 }, /* (404) compare_op ::= NK_LE */
  {  407,   -1 }, /* (405) compare_op ::= NK_GE */
  {  407,   -1 }, /* (406) compare_op ::= NK_NE */
  {  407,   -1 }, /* (407) compare_op ::= NK_EQ */
  {  407,   -1 }, /* (408) compare_op ::= LIKE */
  {  407,   -2 }, /* (409) compare_op ::= NOT LIKE */
  {  407,   -1 }, /* (410) compare_op ::= MATCH */
  {  407,   -1 }, /* (411) compare_op ::= NMATCH */
  {  407,   -1 }, /* (412) compare_op ::= CONTAINS */
  {  408,   -1 }, /* (413) in_op ::= IN */
  {  408,   -2 }, /* (414) in_op ::= NOT IN */
  {  409,   -3 }, /* (415) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  410,   -1 }, /* (416) boolean_value_expression ::= boolean_primary */
  {  410,   -2 }, /* (417) boolean_value_expression ::= NOT boolean_primary */
  {  410,   -3 }, /* (418) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  410,   -3 }, /* (419) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  411,   -1 }, /* (420) boolean_primary ::= predicate */
  {  411,   -3 }, /* (421) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  404,   -1 }, /* (422) common_expression ::= expr_or_subquery */
  {  404,   -1 }, /* (423) common_expression ::= boolean_value_expression */
  {  412,    0 }, /* (424) from_clause_opt ::= */
  {  412,   -2 }, /* (425) from_clause_opt ::= FROM table_reference_list */
  {  413,   -1 }, /* (426) table_reference_list ::= table_reference */
  {  413,   -3 }, /* (427) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  414,   -1 }, /* (428) table_reference ::= table_primary */
  {  414,   -1 }, /* (429) table_reference ::= joined_table */
  {  415,   -2 }, /* (430) table_primary ::= table_name alias_opt */
  {  415,   -4 }, /* (431) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  415,   -2 }, /* (432) table_primary ::= subquery alias_opt */
  {  415,   -1 }, /* (433) table_primary ::= parenthesized_joined_table */
  {  417,    0 }, /* (434) alias_opt ::= */
  {  417,   -1 }, /* (435) alias_opt ::= table_alias */
  {  417,   -2 }, /* (436) alias_opt ::= AS table_alias */
  {  418,   -3 }, /* (437) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  418,   -3 }, /* (438) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  416,   -6 }, /* (439) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  419,    0 }, /* (440) join_type ::= */
  {  419,   -1 }, /* (441) join_type ::= INNER */
  {  421,  -12 }, /* (442) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  422,    0 }, /* (443) set_quantifier_opt ::= */
  {  422,   -1 }, /* (444) set_quantifier_opt ::= DISTINCT */
  {  422,   -1 }, /* (445) set_quantifier_opt ::= ALL */
  {  423,   -1 }, /* (446) select_list ::= select_item */
  {  423,   -3 }, /* (447) select_list ::= select_list NK_COMMA select_item */
  {  431,   -1 }, /* (448) select_item ::= NK_STAR */
  {  431,   -1 }, /* (449) select_item ::= common_expression */
  {  431,   -2 }, /* (450) select_item ::= common_expression column_alias */
  {  431,   -3 }, /* (451) select_item ::= common_expression AS column_alias */
  {  431,   -3 }, /* (452) select_item ::= table_name NK_DOT NK_STAR */
  {  385,    0 }, /* (453) where_clause_opt ::= */
  {  385,   -2 }, /* (454) where_clause_opt ::= WHERE search_condition */
  {  424,    0 }, /* (455) partition_by_clause_opt ::= */
  {  424,   -3 }, /* (456) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  432,   -1 }, /* (457) partition_list ::= partition_item */
  {  432,   -3 }, /* (458) partition_list ::= partition_list NK_COMMA partition_item */
  {  433,   -1 }, /* (459) partition_item ::= expr_or_subquery */
  {  433,   -2 }, /* (460) partition_item ::= expr_or_subquery column_alias */
  {  433,   -3 }, /* (461) partition_item ::= expr_or_subquery AS column_alias */
  {  428,    0 }, /* (462) twindow_clause_opt ::= */
  {  428,   -6 }, /* (463) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  428,   -4 }, /* (464) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  428,   -6 }, /* (465) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  428,   -8 }, /* (466) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  370,    0 }, /* (467) sliding_opt ::= */
  {  370,   -4 }, /* (468) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  427,    0 }, /* (469) fill_opt ::= */
  {  427,   -4 }, /* (470) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  427,   -6 }, /* (471) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  434,   -1 }, /* (472) fill_mode ::= NONE */
  {  434,   -1 }, /* (473) fill_mode ::= PREV */
  {  434,   -1 }, /* (474) fill_mode ::= NULL */
  {  434,   -1 }, /* (475) fill_mode ::= LINEAR */
  {  434,   -1 }, /* (476) fill_mode ::= NEXT */
  {  429,    0 }, /* (477) group_by_clause_opt ::= */
  {  429,   -3 }, /* (478) group_by_clause_opt ::= GROUP BY group_by_list */
  {  435,   -1 }, /* (479) group_by_list ::= expr_or_subquery */
  {  435,   -3 }, /* (480) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  430,    0 }, /* (481) having_clause_opt ::= */
  {  430,   -2 }, /* (482) having_clause_opt ::= HAVING search_condition */
  {  425,    0 }, /* (483) range_opt ::= */
  {  425,   -6 }, /* (484) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  426,    0 }, /* (485) every_opt ::= */
  {  426,   -4 }, /* (486) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  436,   -4 }, /* (487) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  437,   -1 }, /* (488) query_simple ::= query_specification */
  {  437,   -1 }, /* (489) query_simple ::= union_query_expression */
  {  441,   -4 }, /* (490) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  441,   -3 }, /* (491) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  442,   -1 }, /* (492) query_simple_or_subquery ::= query_simple */
  {  442,   -1 }, /* (493) query_simple_or_subquery ::= subquery */
  {  375,   -1 }, /* (494) query_or_subquery ::= query_expression */
  {  375,   -1 }, /* (495) query_or_subquery ::= subquery */
  {  438,    0 }, /* (496) order_by_clause_opt ::= */
  {  438,   -3 }, /* (497) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  439,    0 }, /* (498) slimit_clause_opt ::= */
  {  439,   -2 }, /* (499) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  439,   -4 }, /* (500) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  439,   -4 }, /* (501) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  440,    0 }, /* (502) limit_clause_opt ::= */
  {  440,   -2 }, /* (503) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  440,   -4 }, /* (504) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  440,   -4 }, /* (505) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  392,   -3 }, /* (506) subquery ::= NK_LP query_expression NK_RP */
  {  392,   -3 }, /* (507) subquery ::= NK_LP subquery NK_RP */
  {  420,   -1 }, /* (508) search_condition ::= common_expression */
  {  443,   -1 }, /* (509) sort_specification_list ::= sort_specification */
  {  443,   -3 }, /* (510) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  444,   -3 }, /* (511) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  445,    0 }, /* (512) ordering_specification_opt ::= */
  {  445,   -1 }, /* (513) ordering_specification_opt ::= ASC */
  {  445,   -1 }, /* (514) ordering_specification_opt ::= DESC */
  {  446,    0 }, /* (515) null_ordering_opt ::= */
  {  446,   -2 }, /* (516) null_ordering_opt ::= NULLS FIRST */
  {  446,   -2 }, /* (517) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,316,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,317,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,316,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,318,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,319,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,317,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,319,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,318,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy677, &yymsp[-1].minor.yy0, yymsp[0].minor.yy167); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy677, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy677, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy677, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy677); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy167 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy167 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy57, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy677); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy57, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy677); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy57 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy57 = yymsp[0].minor.yy57; }
  yymsp[0].minor.yy57 = yylhsminor.yy57;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy57 = yymsp[-2].minor.yy57 | yymsp[0].minor.yy57; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy57 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy57 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy677 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy677 = yylhsminor.yy677;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy677 = yymsp[-2].minor.yy677; }
  yymsp[-2].minor.yy677 = yylhsminor.yy677;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy677, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy677); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 323: /* db_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* table_name ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* column_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* function_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* table_alias ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* column_alias ::= NK_ID */ yytestcase(yyruleno==328);
      case 329: /* user_name ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* topic_name ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* stream_name ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==332);
      case 370: /* noarg_func ::= NOW */ yytestcase(yyruleno==370);
      case 371: /* noarg_func ::= TODAY */ yytestcase(yyruleno==371);
      case 372: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==372);
      case 373: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==373);
      case 374: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==374);
      case 375: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==375);
      case 376: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==376);
      case 377: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==377);
      case 378: /* noarg_func ::= USER */ yytestcase(yyruleno==378);
      case 379: /* star_func ::= COUNT */ yytestcase(yyruleno==379);
      case 380: /* star_func ::= FIRST */ yytestcase(yyruleno==380);
      case 381: /* star_func ::= LAST */ yytestcase(yyruleno==381);
      case 382: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==382);
{ yylhsminor.yy677 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy677 = yylhsminor.yy677;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy287, &yymsp[-1].minor.yy677, yymsp[0].minor.yy392); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy287, &yymsp[0].minor.yy677); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy677); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy677, yymsp[0].minor.yy392); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy677); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy677, yymsp[0].minor.yy172); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy287 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 264: /* analyze_opt ::= */ yytestcase(yyruleno==264);
      case 271: /* agg_func_opt ::= */ yytestcase(yyruleno==271);
      case 443: /* set_quantifier_opt ::= */ yytestcase(yyruleno==443);
{ yymsp[1].minor.yy287 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy287 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy392 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_KEEP, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_RETENTIONS, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-3].minor.yy392, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-3].minor.yy392, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy392 = createAlterDatabaseOptions(pCxt); yylhsminor.yy392 = setAlterDatabaseOption(pCxt, yylhsminor.yy392, &yymsp[0].minor.yy323); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy392 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy392, &yymsp[0].minor.yy323); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 106: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy323.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy323.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy323.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy323.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy323.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy323.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= KEEP integer_list */
      case 110: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==110);
{ yymsp[-1].minor.yy323.type = DB_OPTION_KEEP; yymsp[-1].minor.yy323.pList = yymsp[0].minor.yy148; }
        break;
      case 111: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy323.type = DB_OPTION_WAL; yymsp[-1].minor.yy323.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy323.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy323.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy148 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 114: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 293: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==293);
{ yylhsminor.yy148 = addNodeToList(pCxt, yymsp[-2].minor.yy148, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 115: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy148 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 116: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy148 = addNodeToList(pCxt, yymsp[-2].minor.yy148, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 117: /* retention_list ::= retention */
      case 139: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==139);
      case 142: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==142);
      case 149: /* column_def_list ::= column_def */ yytestcase(yyruleno==149);
      case 192: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==192);
      case 197: /* col_name_list ::= col_name */ yytestcase(yyruleno==197);
      case 247: /* func_list ::= func */ yytestcase(yyruleno==247);
      case 321: /* literal_list ::= signed_literal */ yytestcase(yyruleno==321);
      case 385: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==385);
      case 391: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==391);
      case 446: /* select_list ::= select_item */ yytestcase(yyruleno==446);
      case 457: /* partition_list ::= partition_item */ yytestcase(yyruleno==457);
      case 509: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==509);
{ yylhsminor.yy148 = createNodeList(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 118: /* retention_list ::= retention_list NK_COMMA retention */
      case 150: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==150);
      case 193: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==193);
      case 198: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==198);
      case 248: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==248);
      case 322: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==322);
      case 386: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==386);
      case 447: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==447);
      case 458: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==458);
      case 510: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==510);
{ yylhsminor.yy148 = addNodeToList(pCxt, yymsp[-2].minor.yy148, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 119: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy392 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 120: /* speed_opt ::= */
      case 273: /* bufsize_opt ::= */ yytestcase(yyruleno==273);
{ yymsp[1].minor.yy172 = 0; }
        break;
      case 121: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 274: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==274);
{ yymsp[-1].minor.yy172 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 122: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 124: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==124);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy287, yymsp[-5].minor.yy392, yymsp[-3].minor.yy148, yymsp[-1].minor.yy148, yymsp[0].minor.yy392); }
        break;
      case 123: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 125: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy148); }
        break;
      case 126: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy287, yymsp[0].minor.yy392); }
        break;
      case 127: /* cmd ::= ALTER TABLE alter_table_clause */
      case 295: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==295);
{ pCxt->pRootNode = yymsp[0].minor.yy392; }
        break;
      case 128: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy392); }
        break;
      case 129: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy392 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 130: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy677, yymsp[0].minor.yy838); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 131: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy677); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 132: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy677, yymsp[0].minor.yy838); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 133: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy677, &yymsp[0].minor.yy677); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 134: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy677, yymsp[0].minor.yy838); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 135: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy677); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 136: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy677, yymsp[0].minor.yy838); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 137: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy677, &yymsp[0].minor.yy677); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 138: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy392 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy392, &yymsp[-2].minor.yy677, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 140: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 143: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==143);
      case 392: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==392);
{ yylhsminor.yy148 = addNodeToList(pCxt, yymsp[-1].minor.yy148, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy148 = yylhsminor.yy148;
        break;
      case 141: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy392 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy287, yymsp[-8].minor.yy392, yymsp[-6].minor.yy392, yymsp[-5].minor.yy148, yymsp[-2].minor.yy148, yymsp[0].minor.yy392); }
  yymsp[-9].minor.yy392 = yylhsminor.yy392;
        break;
      case 144: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy392 = createDropTableClause(pCxt, yymsp[-1].minor.yy287, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 145: /* specific_cols_opt ::= */
      case 176: /* tags_def_opt ::= */ yytestcase(yyruleno==176);
      case 455: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==455);
      case 477: /* group_by_clause_opt ::= */ yytestcase(yyruleno==477);
      case 496: /* order_by_clause_opt ::= */ yytestcase(yyruleno==496);
{ yymsp[1].minor.yy148 = NULL; }
        break;
      case 146: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy148 = yymsp[-1].minor.yy148; }
        break;
      case 147: /* full_table_name ::= table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy677, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 148: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy677, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 151: /* column_def ::= column_name type_name */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy677, yymsp[0].minor.yy838, NULL); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 152: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy677, yymsp[-2].minor.yy838, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 153: /* type_name ::= BOOL */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 154: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 155: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 156: /* type_name ::= INT */
      case 157: /* type_name ::= INTEGER */ yytestcase(yyruleno==157);
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 158: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 159: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 160: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 161: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy838 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 162: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 163: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy838 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 164: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy838 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 165: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy838 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 166: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy838 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 167: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy838 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 168: /* type_name ::= JSON */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 169: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy838 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 171: /* type_name ::= BLOB */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 172: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy838 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 173: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy838 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 174: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy838 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 175: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy838 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 177: /* tags_def_opt ::= tags_def */
      case 384: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==384);
{ yylhsminor.yy148 = yymsp[0].minor.yy148; }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 178: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy148 = yymsp[-1].minor.yy148; }
        break;
      case 179: /* table_options ::= */
{ yymsp[1].minor.yy392 = createDefaultTableOptions(pCxt); }
        break;
      case 180: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 181: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 182: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy148); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 183: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-4].minor.yy392, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy148); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 184: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 185: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-4].minor.yy392, TABLE_OPTION_SMA, yymsp[-1].minor.yy148); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 186: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy392 = createAlterTableOptions(pCxt); yylhsminor.yy392 = setTableOption(pCxt, yylhsminor.yy392, yymsp[0].minor.yy323.type, &yymsp[0].minor.yy323.val); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 187: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy323.type, &yymsp[0].minor.yy323.val); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 188: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy323.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy323.val = yymsp[0].minor.yy0; }
        break;
      case 189: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy323.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy323.val = yymsp[0].minor.yy0; }
        break;
      case 190: /* duration_list ::= duration_literal */
      case 351: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==351);
{ yylhsminor.yy148 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 191: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 352: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==352);
{ yylhsminor.yy148 = addNodeToList(pCxt, yymsp[-2].minor.yy148, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 194: /* rollup_func_name ::= function_name */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[0].minor.yy677, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 195: /* rollup_func_name ::= FIRST */
      case 196: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==196);
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 199: /* col_name ::= column_name */
{ yylhsminor.yy392 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy677); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 200: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 201: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 202: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 203: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, OP_TYPE_LIKE); }
        break;
      case 204: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, OP_TYPE_LIKE); }
        break;
      case 205: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy392, NULL, OP_TYPE_LIKE); }
        break;
      case 206: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 208: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 210: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy392, yymsp[-1].minor.yy392, OP_TYPE_EQUAL); }
        break;
      case 211: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 212: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 213: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 214: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 215: /* cmd ::= SHOW LICENCES */
      case 216: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==216);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 217: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy677); }
        break;
      case 218: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 219: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 220: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 221: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 222: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 223: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 224: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 225: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 226: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 227: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 228: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 229: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 230: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy392); }
        break;
      case 231: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 232: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 233: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy392, yymsp[-1].minor.yy392, OP_TYPE_EQUAL); }
        break;
      case 234: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 235: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 236: /* db_name_cond_opt ::= */
      case 241: /* from_db_opt ::= */ yytestcase(yyruleno==241);
{ yymsp[1].minor.yy392 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 237: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy677); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 238: /* like_pattern_opt ::= */
      case 283: /* subtable_opt ::= */ yytestcase(yyruleno==283);
      case 394: /* case_when_else_opt ::= */ yytestcase(yyruleno==394);
      case 424: /* from_clause_opt ::= */ yytestcase(yyruleno==424);
      case 453: /* where_clause_opt ::= */ yytestcase(yyruleno==453);
      case 462: /* twindow_clause_opt ::= */ yytestcase(yyruleno==462);
      case 467: /* sliding_opt ::= */ yytestcase(yyruleno==467);
      case 469: /* fill_opt ::= */ yytestcase(yyruleno==469);
      case 481: /* having_clause_opt ::= */ yytestcase(yyruleno==481);
      case 483: /* range_opt ::= */ yytestcase(yyruleno==483);
      case 485: /* every_opt ::= */ yytestcase(yyruleno==485);
      case 498: /* slimit_clause_opt ::= */ yytestcase(yyruleno==498);
      case 502: /* limit_clause_opt ::= */ yytestcase(yyruleno==502);
{ yymsp[1].minor.yy392 = NULL; }
        break;
      case 239: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 240: /* table_name_cond ::= table_name */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy677); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 242: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy677); }
        break;
      case 243: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy287, yymsp[-3].minor.yy392, yymsp[-1].minor.yy392, NULL, yymsp[0].minor.yy392); }
        break;
      case 244: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy287, yymsp[0].minor.yy392); }
        break;
      case 245: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy392 = createIndexOption(pCxt, yymsp[-7].minor.yy148, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 246: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy392 = createIndexOption(pCxt, yymsp[-9].minor.yy148, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 249: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[-3].minor.yy677, yymsp[-1].minor.yy148); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 250: /* sma_stream_opt ::= */
      case 277: /* stream_options ::= */ yytestcase(yyruleno==277);
{ yymsp[1].minor.yy392 = createStreamOptions(pCxt); }
        break;
      case 251: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 281: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==281);
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 252: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 253: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy287, &yymsp[-2].minor.yy677, yymsp[0].minor.yy392); }
        break;
      case 254: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy287, &yymsp[-3].minor.yy677, &yymsp[0].minor.yy677, false); }
        break;
      case 255: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy287, &yymsp[-5].minor.yy677, &yymsp[0].minor.yy677, true); }
        break;
      case 256: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy287, &yymsp[-3].minor.yy677, yymsp[0].minor.yy392, false); }
        break;
      case 257: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy287, &yymsp[-5].minor.yy677, yymsp[0].minor.yy392, true); }
        break;
      case 258: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy287, &yymsp[0].minor.yy677); }
        break;
      case 259: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy287, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy677); }
        break;
      case 260: /* cmd ::= DESC full_table_name */
      case 261: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==261);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy392); }
        break;
      case 262: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 263: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy287, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 265: /* analyze_opt ::= ANALYZE */
      case 272: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==272);
      case 444: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==444);
{ yymsp[0].minor.yy287 = true; }
        break;
      case 266: /* explain_options ::= */
{ yymsp[1].minor.yy392 = createDefaultExplainOptions(pCxt); }
        break;
      case 267: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy392 = setExplainVerbose(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 268: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy392 = setExplainRatio(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 269: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy287, yymsp[-8].minor.yy287, &yymsp[-5].minor.yy677, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy838, yymsp[0].minor.yy172); }
        break;
      case 270: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy287, &yymsp[0].minor.yy677); }
        break;
      case 275: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy287, &yymsp[-7].minor.yy677, yymsp[-4].minor.yy392, yymsp[-6].minor.yy392, yymsp[-3].minor.yy148, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 276: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy287, &yymsp[0].minor.yy677); }
        break;
      case 278: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 279: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 280: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy392)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy392)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-3].minor.yy392; }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 282: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy392)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy392 = yymsp[-3].minor.yy392; }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 284: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 468: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==468);
      case 486: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==486);
{ yymsp[-3].minor.yy392 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy392); }
        break;
      case 285: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 286: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 287: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 288: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 289: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 290: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy148); }
        break;
      case 291: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 292: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy148 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 294: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 296: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy392, yymsp[-2].minor.yy148, yymsp[0].minor.yy392); }
        break;
      case 297: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy392, NULL, yymsp[0].minor.yy392); }
        break;
      case 298: /* literal ::= NK_INTEGER */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 299: /* literal ::= NK_FLOAT */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 300: /* literal ::= NK_STRING */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 301: /* literal ::= NK_BOOL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 302: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 303: /* literal ::= duration_literal */
      case 313: /* signed_literal ::= signed */ yytestcase(yyruleno==313);
      case 333: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==333);
      case 334: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==334);
      case 335: /* expression ::= literal */ yytestcase(yyruleno==335);
      case 336: /* expression ::= pseudo_column */ yytestcase(yyruleno==336);
      case 337: /* expression ::= column_reference */ yytestcase(yyruleno==337);
      case 338: /* expression ::= function_expression */ yytestcase(yyruleno==338);
      case 339: /* expression ::= case_when_expression */ yytestcase(yyruleno==339);
      case 367: /* function_expression ::= literal_func */ yytestcase(yyruleno==367);
      case 416: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==416);
      case 420: /* boolean_primary ::= predicate */ yytestcase(yyruleno==420);
      case 422: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==422);
      case 423: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==423);
      case 426: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==426);
      case 428: /* table_reference ::= table_primary */ yytestcase(yyruleno==428);
      case 429: /* table_reference ::= joined_table */ yytestcase(yyruleno==429);
      case 433: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==433);
      case 488: /* query_simple ::= query_specification */ yytestcase(yyruleno==488);
      case 489: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==489);
      case 492: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==492);
      case 494: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==494);
{ yylhsminor.yy392 = yymsp[0].minor.yy392; }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 304: /* literal ::= NULL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 305: /* literal ::= NK_QUESTION */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 306: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 307: /* signed ::= NK_INTEGER */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 308: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 309: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 310: /* signed ::= NK_FLOAT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 311: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 312: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 314: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 315: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 316: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 317: /* signed_literal ::= duration_literal */
      case 319: /* signed_literal ::= literal_func */ yytestcase(yyruleno==319);
      case 387: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==387);
      case 449: /* select_item ::= common_expression */ yytestcase(yyruleno==449);
      case 459: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==459);
      case 493: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==493);
      case 495: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==495);
      case 508: /* search_condition ::= common_expression */ yytestcase(yyruleno==508);
{ yylhsminor.yy392 = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 318: /* signed_literal ::= NULL */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 320: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy392 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 340: /* expression ::= NK_LP expression NK_RP */
      case 421: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==421);
      case 507: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==507);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 341: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy392));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 342: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 343: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 344: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 345: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 346: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 347: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 348: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 349: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 350: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 353: /* column_reference ::= column_name */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy677, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy677)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 354: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy677, createColumnNode(pCxt, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy677)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 355: /* pseudo_column ::= ROWTS */
      case 356: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==356);
      case 358: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==358);
      case 359: /* pseudo_column ::= QEND */ yytestcase(yyruleno==359);
      case 360: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==360);
      case 361: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==361);
      case 362: /* pseudo_column ::= WEND */ yytestcase(yyruleno==362);
      case 363: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==363);
      case 369: /* literal_func ::= NOW */ yytestcase(yyruleno==369);
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 357: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy677)))); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 364: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 365: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==365);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy677, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy677, yymsp[-1].minor.yy148)); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 366: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy838)); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 368: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy677, NULL)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 383: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy148 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 388: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 452: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==452);
{ yylhsminor.yy392 = createColumnNode(pCxt, &yymsp[-2].minor.yy677, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 389: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy148, yymsp[-1].minor.yy392)); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 390: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-2].minor.yy148, yymsp[-1].minor.yy392)); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 393: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy392 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
        break;
      case 395: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy392 = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); }
        break;
      case 396: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 401: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==401);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy758, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 397: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 398: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 399: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), NULL));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 400: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL));
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 402: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy758 = OP_TYPE_LOWER_THAN; }
        break;
      case 403: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy758 = OP_TYPE_GREATER_THAN; }
        break;
      case 404: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy758 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 405: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy758 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 406: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy758 = OP_TYPE_NOT_EQUAL; }
        break;
      case 407: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy758 = OP_TYPE_EQUAL; }
        break;
      case 408: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy758 = OP_TYPE_LIKE; }
        break;
      case 409: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy758 = OP_TYPE_NOT_LIKE; }
        break;
      case 410: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy758 = OP_TYPE_MATCH; }
        break;
      case 411: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy758 = OP_TYPE_NMATCH; }
        break;
      case 412: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy758 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 413: /* in_op ::= IN */
{ yymsp[0].minor.yy758 = OP_TYPE_IN; }
        break;
      case 414: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy758 = OP_TYPE_NOT_IN; }
        break;
      case 415: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy148)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 417: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 418: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 419: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 425: /* from_clause_opt ::= FROM table_reference_list */
      case 454: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==454);
      case 482: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==482);
{ yymsp[-1].minor.yy392 = yymsp[0].minor.yy392; }
        break;
      case 427: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 430: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy677, &yymsp[0].minor.yy677); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 431: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-3].minor.yy677, &yymsp[-1].minor.yy677, &yymsp[0].minor.yy677); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 432: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy392 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy677); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 434: /* alias_opt ::= */
{ yymsp[1].minor.yy677 = nil_token;  }
        break;
      case 435: /* alias_opt ::= table_alias */
{ yylhsminor.yy677 = yymsp[0].minor.yy677; }
  yymsp[0].minor.yy677 = yylhsminor.yy677;
        break;
      case 436: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy677 = yymsp[0].minor.yy677; }
        break;
      case 437: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 438: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==438);
{ yymsp[-2].minor.yy392 = yymsp[-1].minor.yy392; }
        break;
      case 439: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, yymsp[-4].minor.yy114, yymsp[-5].minor.yy392, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 440: /* join_type ::= */
{ yymsp[1].minor.yy114 = JOIN_TYPE_INNER; }
        break;
      case 441: /* join_type ::= INNER */
{ yymsp[0].minor.yy114 = JOIN_TYPE_INNER; }
        break;
      case 442: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy392 = createSelectStmt(pCxt, yymsp[-10].minor.yy287, yymsp[-9].minor.yy148, yymsp[-8].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addWhereClause(pCxt, yymsp[-11].minor.yy392, yymsp[-7].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addPartitionByClause(pCxt, yymsp[-11].minor.yy392, yymsp[-6].minor.yy148);
                                                                                    yymsp[-11].minor.yy392 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy392, yymsp[-2].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addGroupByClause(pCxt, yymsp[-11].minor.yy392, yymsp[-1].minor.yy148);
                                                                                    yymsp[-11].minor.yy392 = addHavingClause(pCxt, yymsp[-11].minor.yy392, yymsp[0].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addRangeClause(pCxt, yymsp[-11].minor.yy392, yymsp[-5].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addEveryClause(pCxt, yymsp[-11].minor.yy392, yymsp[-4].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addFillClause(pCxt, yymsp[-11].minor.yy392, yymsp[-3].minor.yy392);
                                                                                  }
        break;
      case 445: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy287 = false; }
        break;
      case 448: /* select_item ::= NK_STAR */
{ yylhsminor.yy392 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 450: /* select_item ::= common_expression column_alias */
      case 460: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==460);
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy677); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 451: /* select_item ::= common_expression AS column_alias */
      case 461: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==461);
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), &yymsp[0].minor.yy677); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 456: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 478: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==478);
      case 497: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==497);
{ yymsp[-2].minor.yy148 = yymsp[0].minor.yy148; }
        break;
      case 463: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy392 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 464: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy392 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 465: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 466: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 470: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy392 = createFillNode(pCxt, yymsp[-1].minor.yy708, NULL); }
        break;
      case 471: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy392 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy148)); }
        break;
      case 472: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy708 = FILL_MODE_NONE; }
        break;
      case 473: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy708 = FILL_MODE_PREV; }
        break;
      case 474: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy708 = FILL_MODE_NULL; }
        break;
      case 475: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy708 = FILL_MODE_LINEAR; }
        break;
      case 476: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy708 = FILL_MODE_NEXT; }
        break;
      case 479: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy148 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[0].minor.yy148 = yylhsminor.yy148;
        break;
      case 480: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy148 = addNodeToList(pCxt, yymsp[-2].minor.yy148, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[-2].minor.yy148 = yylhsminor.yy148;
        break;
      case 484: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy392 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 487: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy392 = addOrderByClause(pCxt, yymsp[-3].minor.yy392, yymsp[-2].minor.yy148);
                                                                                    yylhsminor.yy392 = addSlimitClause(pCxt, yylhsminor.yy392, yymsp[-1].minor.yy392);
                                                                                    yylhsminor.yy392 = addLimitClause(pCxt, yylhsminor.yy392, yymsp[0].minor.yy392);
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 490: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 491: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 499: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 503: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==503);
{ yymsp[-1].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 500: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 504: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==504);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 501: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 505: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==505);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 506: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 511: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy392 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), yymsp[-1].minor.yy362, yymsp[0].minor.yy781); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 512: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy362 = ORDER_ASC; }
        break;
      case 513: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy362 = ORDER_ASC; }
        break;
      case 514: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy362 = ORDER_DESC; }
        break;
      case 515: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy781 = NULL_ORDER_DEFAULT; }
        break;
      case 516: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy781 = NULL_ORDER_FIRST; }
        break;
      case 517: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy781 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
