/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 360
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy54;
  int32_t yy100;
  bool yy137;
  int64_t yy189;
  SToken yy209;
  ENullOrder yy217;
  SDataType yy304;
  EOperatorType yy380;
  SNodeList* yy424;
  EOrder yy578;
  SAlterOption yy605;
  EJoinType yy612;
  SNode* yy632;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             625
#define YYNRULE              460
#define YYNTOKEN             240
#define YY_MAX_SHIFT         624
#define YY_MIN_SHIFTREDUCE   915
#define YY_MAX_SHIFTREDUCE   1374
#define YY_ERROR_ACTION      1375
#define YY_ACCEPT_ACTION     1376
#define YY_NO_ACTION         1377
#define YY_MIN_REDUCE        1378
#define YY_MAX_REDUCE        1837
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2079)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1498,  322, 1684, 1671, 1554, 1556,  301,  399, 1401,  400,
 /*    10 */  1410,  945,   35,   33, 1668, 1500,   57,   65,  500, 1400,
 /*    20 */   310,   24, 1188, 1213,   28,  234, 1668,  540,  539, 1700,
 /*    30 */   111,   36,   34,   32,   31,   30, 1212,  524,  107, 1504,
 /*    40 */  1664, 1670, 1654,  540,  523,  438,  115, 1186, 1654,  949,
 /*    50 */   950,  543, 1664, 1670,  155, 1509,  357,  504,   14, 1654,
 /*    60 */    35,   33, 1315,  543, 1194, 1437,  504,  592,  310, 1713,
 /*    70 */  1188, 1509,   83, 1685,  526, 1687, 1688,  522,  134,  543,
 /*    80 */  1390,    1, 1753, 1555, 1556,  113,  284, 1749,   36,   34,
 /*    90 */    32,   31,   30,   56,  540, 1186,  500, 1815, 1815, 1815,
 /*   100 */   223, 1760,  499,  621,  498,  361,   14, 1815,  351,  150,
 /*   110 */   152, 1814, 1194, 1812, 1812, 1812,  417, 1257, 1258,  152,
 /*   120 */  1094, 1095, 1509, 1812,  115,  599,  598,  597,  325,    2,
 /*   130 */   596,  595,  594,  117,  589,  588,  587,  586,  585,  584,
 /*   140 */   583,  582,  125,  578,   36,   34,   32,   31,   30,  539,
 /*   150 */    56,  621,   36,   34,   32,   31,   30,  449,  448, 1189,
 /*   160 */  1376, 1187,  363,  113,   97, 1257, 1258,   96,   95,   94,
 /*   170 */    93,   92,   91,   90,   89,   88,  132,  502,  147, 1760,
 /*   180 */  1761,  575, 1765, 1192, 1193, 1512, 1239, 1240, 1242, 1243,
 /*   190 */  1244, 1245, 1246,  519,  541, 1254, 1255, 1256, 1259,  282,
 /*   200 */   123,  122,  572,  571,  570,  398, 1322, 1189,  402, 1187,
 /*   210 */    38,  153, 1212,  407, 1329,  400, 1410,  581,  327, 1481,
 /*   220 */    35,   33,  539,  153,  962, 1684,  961, 1371,  310, 1487,
 /*   230 */  1188, 1192, 1193,  294, 1239, 1240, 1242, 1243, 1244, 1245,
 /*   240 */  1246,  519,  541, 1254, 1255, 1256, 1259,  489, 1188,  452,
 /*   250 */   451,  204, 1700,  963,  450, 1186, 1700,  112,  447, 1815,
 /*   260 */   524,  446,  445,  444,  493, 1654,   14,  523,   35,   33,
 /*   270 */  1440,  150, 1194, 1186, 1399, 1812,  310,   56, 1188,   68,
 /*   280 */   153, 1684,  295,   39,  293,  292,  417,  440,  131,    2,
 /*   290 */  1194,  442, 1713,  476,  494,   85, 1685,  526, 1687, 1688,
 /*   300 */   522,  492,  543, 1186,  540, 1753,  197, 1370, 1700, 1752,
 /*   310 */  1749,  621, 1815,  441, 1654,  107,  524,  495,  490,  466,
 /*   320 */  1194, 1654,  443,  523,  151, 1257, 1258,  511, 1812,  621,
 /*   330 */   452,  451, 1509, 1815, 1815,  450,  504,    8,  112,  447,
 /*   340 */   153, 1265,  446,  445,  444, 1813,  150, 1212, 1713, 1812,
 /*   350 */  1812,   83, 1685,  526, 1687, 1688,  522, 1194,  543,  621,
 /*   360 */  1815, 1753,   67,  283, 1314,  284, 1749, 1189, 1398, 1187,
 /*   370 */    26, 1213,  150, 1257, 1258, 1671, 1812, 1815,  318, 1241,
 /*   380 */    36,   34,   32,   31,   30, 1189, 1668, 1187,  500,  150,
 /*   390 */  1767, 1192, 1193, 1812, 1239, 1240, 1242, 1243, 1244, 1245,
 /*   400 */  1246,  519,  541, 1254, 1255, 1256, 1259,  153, 1654, 1192,
 /*   410 */  1193,  389, 1664, 1670, 1764, 1189,  115, 1187,   36,   34,
 /*   420 */    32,   31,   30,  543, 1485, 1561,  577,  527,   35,   33,
 /*   430 */  1260,  160,  300, 1684, 1211,  313,  310, 1604, 1188, 1192,
 /*   440 */  1193, 1559, 1239, 1240, 1242, 1243, 1244, 1245, 1246,  519,
 /*   450 */   541, 1254, 1255, 1256, 1259,  113,   63,  164,  163,   62,
 /*   460 */  1700,  314,  348, 1186,   32,   31,   30,  153,  524,  132,
 /*   470 */   148, 1760, 1761, 1654, 1765,  523,   35,   33, 1511,   65,
 /*   480 */  1194,  577,  350,  346,  310, 1684, 1188,  540, 1226,   36,
 /*   490 */    34,   32,   31,   30,  962,  135,  961,    9,  362, 1466,
 /*   500 */  1713, 1505, 1397,   85, 1685,  526, 1687, 1688,  522, 1396,
 /*   510 */   543, 1186, 1700, 1753, 1241, 1509,  512,  515, 1749,  621,
 /*   520 */   503,  436, 1561,  963,  320, 1654, 1486,  523, 1194,  315,
 /*   530 */   145,  580,  132, 1257, 1258,  540, 1672, 1561, 1559, 1395,
 /*   540 */   540, 1511, 1654, 1548,  321,    9,  364, 1668,  500, 1654,
 /*   550 */   540,  374, 1713, 1559,  569,   84, 1685,  526, 1687, 1688,
 /*   560 */   522,  375,  543, 1509, 1279, 1753, 1379,  621, 1509,  303,
 /*   570 */  1749,  146, 1313, 1664, 1670, 1189,  115, 1187, 1509, 1654,
 /*   580 */  1394, 1257, 1258,  226,  543, 1214, 1284,   97,  482, 1780,
 /*   590 */    96,   95,   94,   93,   92,   91,   90,   89,   88, 1192,
 /*   600 */  1193, 1014, 1239, 1240, 1242, 1243, 1244, 1245, 1246,  519,
 /*   610 */   541, 1254, 1255, 1256, 1259,  113,  323,  527, 1016,  575,
 /*   620 */  1654,   25,   80, 1189,  132, 1187, 1339, 1605, 1393, 1392,
 /*   630 */   149, 1760, 1761, 1511, 1765,  116,   35,   33,  123,  122,
 /*   640 */   572,  571,  570, 1501,  310, 1684, 1188, 1192, 1193,   74,
 /*   650 */  1239, 1240, 1242, 1243, 1244, 1245, 1246,  519,  541, 1254,
 /*   660 */  1255, 1256, 1259,  486, 1337, 1338, 1340, 1341, 1654, 1654,
 /*   670 */  1502, 1186, 1700,   56, 1389,   36,   34,   32,   31,   30,
 /*   680 */   503,   11,   10, 1388,  198, 1654,  406,  523, 1194,  402,
 /*   690 */   593,  591, 1387,  473, 1052,  566,  565,  564, 1056,  563,
 /*   700 */  1058, 1059,  562, 1061,  559,    2, 1067,  556, 1069, 1070,
 /*   710 */   553,  550, 1713,  225, 1654,   84, 1685,  526, 1687, 1688,
 /*   720 */   522,  285,  543, 1654,  281, 1753, 1210,  621,  540,  303,
 /*   730 */  1749,  146, 1654,  382,  404,  257,  394,  540, 1539,  416,
 /*   740 */  1210, 1257, 1258, 1170, 1171, 1226,  133, 1378, 1506, 1781,
 /*   750 */   356,  263,  355, 1277,  395, 1215, 1509, 1767, 1386,  540,
 /*   760 */    54, 1385, 1291,  261,   53, 1509, 1767,   52,    7,  540,
 /*   770 */  1631,  106,  105,  104,  103,  102,  101,  100,   99,   98,
 /*   780 */   474, 1763, 1595, 1189,  165, 1187,  365, 1509,  573, 1212,
 /*   790 */  1762, 1552,  508,  162,   79,  540,  574, 1509, 1654, 1552,
 /*   800 */  1494, 1654, 1496,  153,   76, 1278,  324, 1192, 1193,   56,
 /*   810 */  1239, 1240, 1242, 1243, 1244, 1245, 1246,  519,  541, 1254,
 /*   820 */  1255, 1256, 1259, 1509,  949,  950,  393, 1283, 1492,  388,
 /*   830 */   387,  386,  385,  384,  381,  380,  379,  378,  377,  373,
 /*   840 */   372,  371,  370,  369,  368,  367,  366,   82,   36,   34,
 /*   850 */    32,   31,   30, 1772, 1310, 1384, 1383, 1382, 1684, 1561,
 /*   860 */   442,  540,   27,  308, 1272, 1273, 1274, 1275, 1276, 1280,
 /*   870 */  1281, 1282,  537, 1381,  188, 1560,  457,  186,  201,   60,
 /*   880 */    59,  360,  441,  210,  159, 1700,   11,   10,  540, 1509,
 /*   890 */   354,  465,  540,  524,  285, 1654, 1654, 1654, 1654,  538,
 /*   900 */   523,  280, 1642,  247,  344,  196,  342,  338,  334,  156,
 /*   910 */   329,  190,  192, 1654,  189,  191, 1509,  460, 1484, 1684,
 /*   920 */  1509,  516,  454, 1427,  121, 1713, 1277,  195,   84, 1685,
 /*   930 */   526, 1687, 1688,  522,  194,  543, 1422,  193, 1753,  153,
 /*   940 */  1420, 1310,  303, 1749, 1828,  453, 1700,  336, 1373, 1374,
 /*   950 */  1674,  464,   51, 1787,  524,   50, 1241,   46,  455, 1654,
 /*   960 */   213,  523,  458,  518,  462,  478, 1416,   37,   37,   37,
 /*   970 */   568, 1391,  236, 1467,  229,  119,  120,  487, 1278,  509,
 /*   980 */  1684,  435,  121,  506,   46, 1197, 1713, 1676,  548,   84,
 /*   990 */  1685,  526, 1687, 1688,  522, 1196,  543,  467, 1336, 1753,
 /*  1000 */  1283,  215,  986,  303, 1749, 1828, 1701, 1700, 1285, 1247,
 /*  1010 */  1143,  575,  617,  238, 1810,  524,  532,  244,  120,  987,
 /*  1020 */  1654,  121,  523, 1045,  220,  256,  108,  120,  326, 1073,
 /*  1030 */   123,  122,  572,  571,  570,   27,  308, 1272, 1273, 1274,
 /*  1040 */  1275, 1276, 1280, 1281, 1282, 1411, 1269, 1713, 1549, 1684,
 /*  1050 */    84, 1685,  526, 1687, 1688,  522, 1783,  543, 1684, 1077,
 /*  1060 */  1753,  501, 1084,  228,  303, 1749, 1828, 1082,  124,  231,
 /*  1070 */   233,    5,    3,  328, 1210, 1771, 1700,  335,  331,  290,
 /*  1080 */  1014,  291, 1154,  253,  524, 1700,  161,  376, 1597, 1654,
 /*  1090 */   383,  523,  391,  524,  396,  390,  392, 1216, 1654, 1200,
 /*  1100 */   523,  397,  405, 1219,  504,  408,  168, 1684,  409, 1199,
 /*  1110 */  1218,  410, 1220,  504,  170,  411, 1713,  413,  414,  270,
 /*  1120 */  1685,  526, 1687, 1688,  522, 1713,  543,  173,  270, 1685,
 /*  1130 */   526, 1687, 1688,  522, 1700,  543,  175, 1217,  415,  418,
 /*  1140 */   178,   64,  521,  437,  181, 1815,  439, 1654, 1499,  523,
 /*  1150 */   185, 1495,  299,   87, 1815,  254,  199,  152,  187,  468,
 /*  1160 */  1636, 1812,  126, 1684,  127, 1497,  150, 1493,  469,  128,
 /*  1170 */  1812,  129, 1684,  202, 1713,  480, 1635,  278, 1685,  526,
 /*  1180 */  1687, 1688,  522,  520,  543,  517, 1725,  475,  477,  479,
 /*  1190 */  1700,  205,  624,  472,  208, 1215, 1794,  488,  524, 1700,
 /*  1200 */   530, 1793,  497, 1654,  211,  523,  252,  524, 1784,  214,
 /*  1210 */   484, 1774, 1654,    6,  523,  485,  302,  221,  143,  219,
 /*  1220 */  1310,  140,  114, 1214,  615,  611,  607,  603,  251,  491,
 /*  1230 */  1713,   40,  513,  136, 1685,  526, 1687, 1688,  522, 1713,
 /*  1240 */   543,  510,   85, 1685,  526, 1687, 1688,  522,  183,  543,
 /*  1250 */   304, 1684, 1753,   81,  222,   18,  245, 1750, 1603, 1811,
 /*  1260 */   138, 1602, 1768,  533,  528,  227,  434,  430,  426,  422,
 /*  1270 */   182,  507, 1831,  529,  312,  230,  505, 1829, 1700, 1734,
 /*  1280 */   240,  534,  242,  255,  535, 1510,  524,   73,   75,  536,
 /*  1290 */   546, 1654, 1553,  523, 1482,   66,  250,  258,  180,  514,
 /*  1300 */   620,   47, 1684,  139,  483,  232,  264,  271,  262,  265,
 /*  1310 */   260, 1648, 1647,   58, 1646,  500,  330,  481, 1713, 1684,
 /*  1320 */   206,  279, 1685,  526, 1687, 1688,  522, 1643,  543, 1700,
 /*  1330 */   332,  333, 1181, 1182,  157,  337, 1641,  524,  339, 1162,
 /*  1340 */   340,  200, 1654,  115,  523,  341, 1700, 1640,  343, 1639,
 /*  1350 */   345, 1638,  347, 1637,  524,  349, 1621,  158,  179, 1654,
 /*  1360 */   171,  523,  176,  504,  412,  352, 1157,  353, 1684, 1713,
 /*  1370 */  1156, 1615,  274, 1685,  526, 1687, 1688,  522, 1614,  543,
 /*  1380 */   358,  359,  113,  169, 1129, 1590, 1713, 1613, 1612,  136,
 /*  1390 */  1685,  526, 1687, 1688,  522, 1700,  543,  223, 1760,  499,
 /*  1400 */    61,  498, 1589,  524, 1815, 1588, 1587, 1586, 1654,  496,
 /*  1410 */   523, 1585, 1584, 1583, 1582, 1581,  150, 1580, 1579, 1578,
 /*  1420 */  1812,  307, 1684, 1577, 1576, 1575, 1574, 1573, 1572,  118,
 /*  1430 */  1571, 1570, 1569, 1830, 1568, 1713, 1567, 1566,  279, 1685,
 /*  1440 */   526, 1687, 1688,  522, 1131,  543, 1565, 1564, 1563, 1700,
 /*  1450 */   166, 1406,  952,  109,  951, 1629, 1623,  521, 1562, 1439,
 /*  1460 */  1407,  144, 1654,  174,  523,  401, 1611, 1610, 1600, 1488,
 /*  1470 */   110, 1684,  172,  403, 1438,  317,  316,  167,  177, 1436,
 /*  1480 */  1684, 1434,  421, 1432, 1430, 1202,  425,  420, 1419, 1713,
 /*  1490 */  1418,  419,  278, 1685,  526, 1687, 1688,  522, 1700,  543,
 /*  1500 */   423, 1726,  980, 1405,  427, 1490,  524, 1700,  431,  424,
 /*  1510 */  1195, 1654,  429,  523,  433,  524,  428, 1087,  432, 1489,
 /*  1520 */  1654,  590,  523, 1088,  309, 1013, 1428, 1194,  296, 1012,
 /*  1530 */   592, 1423, 1011,  311, 1010, 1684,  297, 1421, 1713, 1007,
 /*  1540 */   184,  279, 1685,  526, 1687, 1688,  522, 1713,  543, 1006,
 /*  1550 */   279, 1685,  526, 1687, 1688,  522, 1005,  543,  456,  459,
 /*  1560 */    45, 1684, 1700,  298, 1404,  461,  544, 1403,  463,   86,
 /*  1570 */   524, 1628, 1164, 1622,  130, 1654,  470,  523, 1609, 1608,
 /*  1580 */  1607, 1599,   69,    4,  207,   37,  212,   15, 1700, 1335,
 /*  1590 */  1328,   43,  137,  217,  216,  218,  524,   22,   70,  203,
 /*  1600 */  1674, 1654, 1713,  523,   23,  266, 1685,  526, 1687, 1688,
 /*  1610 */   522, 1307,  543, 1684,   16, 1306,  224,   41,   42,  141,
 /*  1620 */  1364, 1353, 1203,   17, 1198,   10,   19, 1684, 1713,  209,
 /*  1630 */  1359,  273, 1685,  526, 1687, 1688,  522, 1358,  543, 1684,
 /*  1640 */  1700,   49,  471,  305,   48, 1363, 1206, 1362,  524,  306,
 /*  1650 */  1249,   29,  142, 1654, 1700,  523, 1248,  541, 1254, 1255,
 /*  1660 */   154, 1234,  524, 1598,  531,   12, 1700, 1654,   20,  523,
 /*  1670 */   235,  241,   21,  237,  524, 1333,  525,   13,  239, 1654,
 /*  1680 */  1713,  523, 1270,  275, 1685,  526, 1687, 1688,  522, 1673,
 /*  1690 */   543,   71,   72, 1684, 1713,   76,  243,  267, 1685,  526,
 /*  1700 */  1687, 1688,  522,  246,  543, 1716, 1713, 1251,  542,  276,
 /*  1710 */  1685,  526, 1687, 1688,  522, 1684,  543, 1204,   44,  547,
 /*  1720 */  1700,  545, 1074,  319,  549,  551, 1071,  552,  524, 1068,
 /*  1730 */   554,  555,  557, 1654, 1062,  523,  558,  560, 1060,  561,
 /*  1740 */  1066, 1065, 1700, 1064, 1051,   77, 1063,   78, 1083,  248,
 /*  1750 */   524,   55, 1079,  567,  576, 1654,  978,  523, 1002,  579,
 /*  1760 */  1713,  249, 1020,  268, 1685,  526, 1687, 1688,  522,  995,
 /*  1770 */   543, 1000,  999,  998,  997,  996,  994, 1684,  993, 1017,
 /*  1780 */  1015, 1435, 1713,  990,  989,  277, 1685,  526, 1687, 1688,
 /*  1790 */   522, 1684,  543,  988,  602,  985,  984,  983,  600,  601,
 /*  1800 */  1433,  605,  604,  606, 1700, 1431,  608,  609,  610, 1429,
 /*  1810 */   612,  614,  524,  613, 1417, 1402,  616, 1654, 1700,  523,
 /*  1820 */   618, 1190,  619,  623,  259,  622,  524, 1377, 1377, 1377,
 /*  1830 */  1377, 1654, 1684,  523, 1377, 1377, 1377, 1377, 1377, 1377,
 /*  1840 */  1377, 1377, 1377, 1377, 1713, 1377, 1684,  269, 1685,  526,
 /*  1850 */  1687, 1688,  522, 1377,  543, 1377, 1377, 1377, 1713, 1700,
 /*  1860 */  1377, 1696, 1685,  526, 1687, 1688,  522,  524,  543, 1377,
 /*  1870 */  1377, 1377, 1654, 1700,  523, 1377, 1377, 1377, 1377, 1377,
 /*  1880 */  1377,  524, 1377, 1377, 1377, 1377, 1654, 1377,  523, 1377,
 /*  1890 */  1377, 1377, 1377, 1377, 1377, 1377, 1377, 1684, 1377, 1713,
 /*  1900 */  1377, 1377, 1695, 1685,  526, 1687, 1688,  522, 1377,  543,
 /*  1910 */  1377, 1684, 1377, 1713, 1377, 1377, 1694, 1685,  526, 1687,
 /*  1920 */  1688,  522, 1377,  543, 1700, 1377, 1377, 1377, 1377, 1377,
 /*  1930 */  1377, 1377,  524, 1377, 1377, 1377, 1377, 1654, 1700,  523,
 /*  1940 */  1377, 1377, 1377, 1377, 1377, 1377,  524, 1377, 1377, 1377,
 /*  1950 */  1377, 1654, 1377,  523, 1377, 1377, 1377, 1377, 1377, 1377,
 /*  1960 */  1684, 1377, 1377, 1377, 1713, 1377, 1377,  288, 1685,  526,
 /*  1970 */  1687, 1688,  522, 1377,  543, 1377, 1377, 1684, 1713, 1377,
 /*  1980 */  1377,  287, 1685,  526, 1687, 1688,  522, 1700,  543, 1377,
 /*  1990 */  1377, 1377, 1377, 1377, 1377,  524, 1377, 1377, 1377, 1377,
 /*  2000 */  1654, 1684,  523, 1377, 1700, 1377, 1377, 1377, 1377, 1377,
 /*  2010 */  1377, 1377,  524, 1377, 1377, 1377, 1377, 1654, 1377,  523,
 /*  2020 */  1377, 1377, 1377, 1377, 1377, 1377, 1377, 1713, 1700, 1377,
 /*  2030 */   289, 1685,  526, 1687, 1688,  522,  524,  543, 1377, 1377,
 /*  2040 */  1377, 1654, 1377,  523, 1713, 1377, 1377,  286, 1685,  526,
 /*  2050 */  1687, 1688,  522, 1377,  543, 1377, 1377, 1377, 1377, 1377,
 /*  2060 */  1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1713, 1377,
 /*  2070 */  1377,  272, 1685,  526, 1687, 1688,  522, 1377,  543,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   271,  281,  243,  272,  284,  285,  275,  246,  243,  248,
 /*    10 */   249,    4,   12,   13,  283,  272,    4,  254,  250,  243,
 /*    20 */    20,    2,   22,   20,  324,  325,  283,  250,   20,  270,
 /*    30 */   267,   12,   13,   14,   15,   16,   20,  278,  261,  276,
 /*    40 */   309,  310,  283,  250,  285,  268,  278,   47,  283,   42,
 /*    50 */    43,  320,  309,  310,  261,  278,  298,  298,   58,  283,
 /*    60 */    12,   13,   14,  320,   64,    0,  298,   41,   20,  310,
 /*    70 */    22,  278,  313,  314,  315,  316,  317,  318,  242,  320,
 /*    80 */   244,   81,  323,  284,  285,  317,  327,  328,   12,   13,
 /*    90 */    14,   15,   16,   81,  250,   47,  250,  339,  339,  339,
 /*   100 */   332,  333,  334,  103,  336,  261,   58,  339,   82,  351,
 /*   110 */   351,  351,   64,  355,  355,  355,   57,  117,  118,  351,
 /*   120 */   117,  118,  278,  355,  278,   60,   61,   62,   63,   81,
 /*   130 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   140 */    75,   76,   77,   78,   12,   13,   14,   15,   16,   20,
 /*   150 */    81,  103,   12,   13,   14,   15,   16,  256,  257,  159,
 /*   160 */   240,  161,  250,  317,   21,  117,  118,   24,   25,   26,
 /*   170 */    27,   28,   29,   30,   31,   32,  270,  331,  332,  333,
 /*   180 */   334,   93,  336,  183,  184,  279,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  198,  287,
 /*   200 */   112,  113,  114,  115,  116,  247,   14,  159,  250,  161,
 /*   210 */    81,  211,   20,  246,   82,  248,  249,  258,  298,  260,
 /*   220 */    12,   13,   20,  211,   20,  243,   22,  151,   20,    0,
 /*   230 */    22,  183,  184,   35,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,  198,  146,   22,   60,
 /*   250 */    61,   55,  270,   49,   65,   47,  270,   68,   69,  339,
 /*   260 */   278,   72,   73,   74,  278,  283,   58,  285,   12,   13,
 /*   270 */     0,  351,   64,   47,  243,  355,   20,   81,   22,   83,
 /*   280 */   211,  243,   84,   81,   86,   87,   57,   89,  148,   81,
 /*   290 */    64,   93,  310,  298,   20,  313,  314,  315,  316,  317,
 /*   300 */   318,  315,  320,   47,  250,  323,  113,  231,  270,  327,
 /*   310 */   328,  103,  339,  115,  283,  261,  278,  216,  217,  298,
 /*   320 */    64,  283,  268,  285,  351,  117,  118,   41,  355,  103,
 /*   330 */    60,   61,  278,  339,  339,   65,  298,   81,   68,   69,
 /*   340 */   211,   14,   72,   73,   74,  351,  351,   20,  310,  355,
 /*   350 */   355,  313,  314,  315,  316,  317,  318,   64,  320,  103,
 /*   360 */   339,  323,  169,  170,    4,  327,  328,  159,  243,  161,
 /*   370 */     2,   20,  351,  117,  118,  272,  355,  339,  275,  187,
 /*   380 */    12,   13,   14,   15,   16,  159,  283,  161,  250,  351,
 /*   390 */   311,  183,  184,  355,  186,  187,  188,  189,  190,  191,
 /*   400 */   192,  193,  194,  195,  196,  197,  198,  211,  283,  183,
 /*   410 */   184,   75,  309,  310,  335,  159,  278,  161,   12,   13,
 /*   420 */    14,   15,   16,  320,    0,  270,   57,  285,   12,   13,
 /*   430 */    14,   55,  277,  243,   20,  293,   20,  295,   22,  183,
 /*   440 */   184,  286,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   450 */   194,  195,  196,  197,  198,  317,   80,  121,  122,   83,
 /*   460 */   270,  262,  154,   47,   14,   15,   16,  211,  278,  270,
 /*   470 */   332,  333,  334,  283,  336,  285,   12,   13,  279,  254,
 /*   480 */    64,   57,  174,  175,   20,  243,   22,  250,   82,   12,
 /*   490 */    13,   14,   15,   16,   20,  255,   22,   81,  261,  259,
 /*   500 */   310,  276,  243,  313,  314,  315,  316,  317,  318,  243,
 /*   510 */   320,   47,  270,  323,  187,  278,  230,  327,  328,  103,
 /*   520 */   278,   47,  270,   49,  262,  283,    0,  285,   64,  277,
 /*   530 */   269,   64,  270,  117,  118,  250,  272,  270,  286,  243,
 /*   540 */   250,  279,  283,  282,  277,   81,  261,  283,  250,  283,
 /*   550 */   250,  261,  310,  286,   92,  313,  314,  315,  316,  317,
 /*   560 */   318,  261,  320,  278,  142,  323,    0,  103,  278,  327,
 /*   570 */   328,  329,  212,  309,  310,  159,  278,  161,  278,  283,
 /*   580 */   243,  117,  118,  341,  320,   20,  164,   21,  346,  347,
 /*   590 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  183,
 /*   600 */   184,   47,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   610 */   194,  195,  196,  197,  198,  317,  262,  285,   64,   93,
 /*   620 */   283,  199,  252,  159,  270,  161,  183,  295,  243,  243,
 /*   630 */   332,  333,  334,  279,  336,  265,   12,   13,  112,  113,
 /*   640 */   114,  115,  116,  273,   20,  243,   22,  183,  184,  252,
 /*   650 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   660 */   196,  197,  198,  220,  221,  222,  223,  224,  283,  283,
 /*   670 */   273,   47,  270,   81,  243,   12,   13,   14,   15,   16,
 /*   680 */   278,    1,    2,  243,  112,  283,  247,  285,   64,  250,
 /*   690 */   256,  257,  243,  302,   94,   95,   96,   97,   98,   99,
 /*   700 */   100,  101,  102,  103,  104,   81,  106,  107,  108,  109,
 /*   710 */   110,  111,  310,  148,  283,  313,  314,  315,  316,  317,
 /*   720 */   318,   58,  320,  283,   18,  323,   20,  103,  250,  327,
 /*   730 */   328,  329,  283,   27,   14,  263,   30,  250,  266,  261,
 /*   740 */    20,  117,  118,  171,  172,   82,   18,    0,  261,  347,
 /*   750 */   158,   23,  160,   90,   48,   20,  278,  311,  243,  250,
 /*   760 */     3,  243,   82,   35,   36,  278,  311,   39,   37,  250,
 /*   770 */   261,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   780 */   261,  335,  278,  159,   56,  161,   80,  278,  280,   20,
 /*   790 */   335,  283,   41,  289,   81,  250,  280,  278,  283,  283,
 /*   800 */   271,  283,  271,  211,   91,  142,  261,  183,  184,   81,
 /*   810 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   820 */   196,  197,  198,  278,   42,   43,  120,  164,  271,  123,
 /*   830 */   124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
 /*   840 */   134,  135,  136,  137,  138,  139,  140,  119,   12,   13,
 /*   850 */    14,   15,   16,  209,  210,  243,  243,  243,  243,  270,
 /*   860 */    93,  250,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   870 */   207,  208,  261,  243,   85,  286,    4,   88,  271,  151,
 /*   880 */   152,  153,  115,  148,  156,  270,    1,    2,  250,  278,
 /*   890 */   162,   19,  250,  278,   58,  283,  283,  283,  283,  261,
 /*   900 */   285,  173,    0,  261,  176,   33,  178,  179,  180,  181,
 /*   910 */   182,   85,   85,  283,   88,   88,  278,   45,    0,  243,
 /*   920 */   278,   58,   50,    0,   41,  310,   90,   55,  313,  314,
 /*   930 */   315,  316,  317,  318,   85,  320,    0,   88,  323,  211,
 /*   940 */     0,  210,  327,  328,  329,   22,  270,   45,  117,  118,
 /*   950 */    44,   21,   80,  338,  278,   83,  187,   41,   22,  283,
 /*   960 */    41,  285,   22,  271,   34,   82,    0,   41,   41,   41,
 /*   970 */   271,  244,   41,  259,  358,   41,   41,  349,  142,  228,
 /*   980 */   243,  251,   41,  226,   41,   47,  310,   81,   41,  313,
 /*   990 */   314,  315,  316,  317,  318,   47,  320,  306,   82,  323,
 /*  1000 */   164,   82,   47,  327,  328,  329,  270,  270,   82,   82,
 /*  1010 */    82,   93,   46,   82,  338,  278,   82,   82,   41,   64,
 /*  1020 */   283,   41,  285,   82,  343,   82,   41,   41,  251,   82,
 /*  1030 */   112,  113,  114,  115,  116,  199,  200,  201,  202,  203,
 /*  1040 */   204,  205,  206,  207,  208,  249,  183,  310,  282,  243,
 /*  1050 */   313,  314,  315,  316,  317,  318,  312,  320,  243,   82,
 /*  1060 */   323,  337,   82,  352,  327,  328,  329,   82,   82,  352,
 /*  1070 */   352,  213,  340,  308,   20,  338,  270,   45,  250,  307,
 /*  1080 */    47,  256,  157,  300,  278,  270,   40,  250,  250,  283,
 /*  1090 */   290,  285,  142,  278,  250,  288,  288,   20,  283,  161,
 /*  1100 */   285,  245,  245,   20,  298,  304,  254,  243,  285,  161,
 /*  1110 */    20,  297,   20,  298,  254,  299,  310,  297,  278,  313,
 /*  1120 */   314,  315,  316,  317,  318,  310,  320,  254,  313,  314,
 /*  1130 */   315,  316,  317,  318,  270,  320,  254,   20,  291,  250,
 /*  1140 */   254,  254,  278,  245,  254,  339,  270,  283,  270,  285,
 /*  1150 */   270,  270,  245,  250,  339,  304,  252,  351,  270,  167,
 /*  1160 */   283,  355,  270,  243,  270,  270,  351,  270,  303,  270,
 /*  1170 */   355,  270,  243,  252,  310,  291,  283,  313,  314,  315,
 /*  1180 */   316,  317,  318,  319,  320,  321,  322,  250,  297,  278,
 /*  1190 */   270,  252,   19,  285,  252,   20,  348,  219,  278,  270,
 /*  1200 */   218,  348,  150,  283,  294,  285,   33,  278,  312,  294,
 /*  1210 */   214,  345,  283,  225,  285,  283,  283,  308,   45,  344,
 /*  1220 */   210,  342,  278,   20,   51,   52,   53,   54,   55,  283,
 /*  1230 */   310,   40,  229,  313,  314,  315,  316,  317,  318,  310,
 /*  1240 */   320,  227,  313,  314,  315,  316,  317,  318,   33,  320,
 /*  1250 */   232,  243,  323,   80,  330,   81,   83,  328,  294,  354,
 /*  1260 */    45,  294,  311,  145,  283,  353,   51,   52,   53,   54,
 /*  1270 */    55,  354,  359,  283,  283,  353,  356,  357,  270,  326,
 /*  1280 */   278,  292,  252,  266,  291,  278,  278,  252,   81,  116,
 /*  1290 */   274,  283,  283,  285,  260,   80,  252,  250,   83,  354,
 /*  1300 */   245,  301,  243,  305,  296,  353,  264,  264,  241,  264,
 /*  1310 */   253,    0,    0,   40,    0,  250,   72,  144,  310,  243,
 /*  1320 */   147,  313,  314,  315,  316,  317,  318,    0,  320,  270,
 /*  1330 */    47,  177,   47,   47,   47,  177,    0,  278,   47,  166,
 /*  1340 */    47,  168,  283,  278,  285,  177,  270,    0,  177,    0,
 /*  1350 */    47,    0,   22,    0,  278,   47,    0,   81,  143,  283,
 /*  1360 */   145,  285,  147,  298,  149,  164,  161,  163,  243,  310,
 /*  1370 */   159,    0,  313,  314,  315,  316,  317,  318,    0,  320,
 /*  1380 */   155,  154,  317,  168,   44,    0,  310,    0,    0,  313,
 /*  1390 */   314,  315,  316,  317,  318,  270,  320,  332,  333,  334,
 /*  1400 */   141,  336,    0,  278,  339,    0,    0,    0,  283,  350,
 /*  1410 */   285,    0,    0,    0,    0,    0,  351,    0,    0,    0,
 /*  1420 */   355,  296,  243,    0,    0,    0,    0,    0,    0,   40,
 /*  1430 */     0,    0,    0,  357,    0,  310,    0,    0,  313,  314,
 /*  1440 */   315,  316,  317,  318,   22,  320,    0,    0,    0,  270,
 /*  1450 */    40,    0,   14,   37,   14,    0,    0,  278,    0,    0,
 /*  1460 */     0,   41,  283,  150,  285,   44,    0,    0,    0,    0,
 /*  1470 */    37,  243,   37,   44,    0,   12,   13,   38,   37,    0,
 /*  1480 */   243,    0,   37,    0,    0,   22,   37,   45,    0,  310,
 /*  1490 */     0,   47,  313,  314,  315,  316,  317,  318,  270,  320,
 /*  1500 */    47,  322,   59,    0,   47,    0,  278,  270,   47,   45,
 /*  1510 */    47,  283,   37,  285,   37,  278,   45,   22,   45,    0,
 /*  1520 */   283,   41,  285,   47,  296,   47,    0,   64,   22,   47,
 /*  1530 */    41,    0,   47,  296,   47,  243,   22,    0,  310,   47,
 /*  1540 */    88,  313,  314,  315,  316,  317,  318,  310,  320,   47,
 /*  1550 */   313,  314,  315,  316,  317,  318,   47,  320,   48,   47,
 /*  1560 */    90,  243,  270,   22,    0,   22,  103,    0,   22,   20,
 /*  1570 */   278,    0,   47,    0,  165,  283,   22,  285,    0,    0,
 /*  1580 */     0,    0,   81,   41,   37,   41,   82,  215,  270,   82,
 /*  1590 */    82,   41,   81,   41,   81,   44,  278,   81,   81,  145,
 /*  1600 */    44,  283,  310,  285,   41,  313,  314,  315,  316,  317,
 /*  1610 */   318,   82,  320,  243,  215,   82,   44,  209,   41,   44,
 /*  1620 */    82,   82,  159,   41,  161,    2,   41,  243,  310,  143,
 /*  1630 */    47,  313,  314,  315,  316,  317,  318,   47,  320,  243,
 /*  1640 */   270,  148,  148,   47,  148,   47,  183,   47,  278,   47,
 /*  1650 */    82,   81,   44,  283,  270,  285,   82,  194,  195,  196,
 /*  1660 */    44,   22,  278,    0,  146,   81,  270,  283,   81,  285,
 /*  1670 */    82,   37,   81,   81,  278,   82,  185,  215,   81,  283,
 /*  1680 */   310,  285,  183,  313,  314,  315,  316,  317,  318,   44,
 /*  1690 */   320,   81,   81,  243,  310,   91,  143,  313,  314,  315,
 /*  1700 */   316,  317,  318,   44,  320,   81,  310,   82,   81,  313,
 /*  1710 */   314,  315,  316,  317,  318,  243,  320,   22,   81,   47,
 /*  1720 */   270,   92,   82,   47,   81,   47,   82,   81,  278,   82,
 /*  1730 */    47,   81,   47,  283,   82,  285,   81,   47,   82,   81,
 /*  1740 */   105,  105,  270,  105,   22,   81,  105,   81,   47,   41,
 /*  1750 */   278,   81,   22,   93,   58,  283,   59,  285,   47,   79,
 /*  1760 */   310,   41,   64,  313,  314,  315,  316,  317,  318,   22,
 /*  1770 */   320,   47,   47,   47,   47,   47,   47,  243,   47,   64,
 /*  1780 */    47,    0,  310,   47,   47,  313,  314,  315,  316,  317,
 /*  1790 */   318,  243,  320,   47,   37,   47,   47,   47,   47,   45,
 /*  1800 */     0,   45,   47,   37,  270,    0,   47,   45,   37,    0,
 /*  1810 */    47,   37,  278,   45,    0,    0,   47,  283,  270,  285,
 /*  1820 */    22,   22,   21,   20,   22,   21,  278,  360,  360,  360,
 /*  1830 */   360,  283,  243,  285,  360,  360,  360,  360,  360,  360,
 /*  1840 */   360,  360,  360,  360,  310,  360,  243,  313,  314,  315,
 /*  1850 */   316,  317,  318,  360,  320,  360,  360,  360,  310,  270,
 /*  1860 */   360,  313,  314,  315,  316,  317,  318,  278,  320,  360,
 /*  1870 */   360,  360,  283,  270,  285,  360,  360,  360,  360,  360,
 /*  1880 */   360,  278,  360,  360,  360,  360,  283,  360,  285,  360,
 /*  1890 */   360,  360,  360,  360,  360,  360,  360,  243,  360,  310,
 /*  1900 */   360,  360,  313,  314,  315,  316,  317,  318,  360,  320,
 /*  1910 */   360,  243,  360,  310,  360,  360,  313,  314,  315,  316,
 /*  1920 */   317,  318,  360,  320,  270,  360,  360,  360,  360,  360,
 /*  1930 */   360,  360,  278,  360,  360,  360,  360,  283,  270,  285,
 /*  1940 */   360,  360,  360,  360,  360,  360,  278,  360,  360,  360,
 /*  1950 */   360,  283,  360,  285,  360,  360,  360,  360,  360,  360,
 /*  1960 */   243,  360,  360,  360,  310,  360,  360,  313,  314,  315,
 /*  1970 */   316,  317,  318,  360,  320,  360,  360,  243,  310,  360,
 /*  1980 */   360,  313,  314,  315,  316,  317,  318,  270,  320,  360,
 /*  1990 */   360,  360,  360,  360,  360,  278,  360,  360,  360,  360,
 /*  2000 */   283,  243,  285,  360,  270,  360,  360,  360,  360,  360,
 /*  2010 */   360,  360,  278,  360,  360,  360,  360,  283,  360,  285,
 /*  2020 */   360,  360,  360,  360,  360,  360,  360,  310,  270,  360,
 /*  2030 */   313,  314,  315,  316,  317,  318,  278,  320,  360,  360,
 /*  2040 */   360,  283,  360,  285,  310,  360,  360,  313,  314,  315,
 /*  2050 */   316,  317,  318,  360,  320,  360,  360,  360,  360,  360,
 /*  2060 */   360,  360,  360,  360,  360,  360,  360,  360,  310,  360,
 /*  2070 */   360,  313,  314,  315,  316,  317,  318,  360,  320,
};
#define YY_SHIFT_COUNT    (624)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1815)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   728,    0,    0,   48,  208,  208,  208,  208,  256,  256,
 /*    10 */   208,  208,  416,  464,  624,  464,  464,  464,  464,  464,
 /*    20 */   464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
 /*    30 */   464,  464,  464,  464,  464,  464,  464,  464,  129,  129,
 /*    40 */   202,  202,  202, 1463, 1463, 1463, 1463,  592,  196,   69,
 /*    50 */     8,    8,    7,    7,   12,    3,   69,   69,    8,    8,
 /*    60 */     8,    8,    8,    8,    8,    8,   59,    8,    8,   16,
 /*    70 */   274,  351,   16,    8,    8,   16,    8,   16,   16,   16,
 /*    80 */     8,  369,  706,  663,  836,  836,  143,  189,  226,  226,
 /*    90 */   226,  226,  226,  226,  226,  226,  226,  226,  226,  226,
 /*   100 */   226,  226,  226,  226,  226,  226,  226,  198,    3,  720,
 /*   110 */   720,  229,  554,  565,  565,  565,  424,  554,  414,  351,
 /*   120 */    16,   16,  293,  293,  462,  467,  600,  600,  600,  600,
 /*   130 */   600,  600,  600, 1173,  566,  270,   76,  443,  474,  193,
 /*   140 */   101,  192,  327,  204,  782,  767,  735,  644,  731,  644,
 /*   150 */   757,  757,  757,  360,  769,  858, 1054, 1032, 1033,  925,
 /*   160 */  1054, 1054, 1046,  950,  950, 1054, 1077, 1077, 1083,   59,
 /*   170 */   351,   59, 1090, 1092,   59, 1090,   59,  414, 1117,   59,
 /*   180 */    59, 1054,   59, 1077,   16,   16,   16,   16,   16,   16,
 /*   190 */    16,   16,   16,   16,   16, 1054, 1077,  293,  293, 1083,
 /*   200 */   369,  992,  351,  369, 1054, 1090,  369,  414, 1117,  369,
 /*   210 */  1175,  978,  982,  293,  978,  982,  293,  293,   16,  988,
 /*   220 */  1052,  996,  858, 1010,  414, 1203, 1191, 1003, 1014, 1018,
 /*   230 */  1003, 1014, 1003, 1014, 1174,  982,  293,  293,  982,  293,
 /*   240 */  1118,  414, 1117,  369,  462,  369,  414, 1207,  293,  467,
 /*   250 */  1054,  369, 1077, 2079, 2079, 2079, 2079, 2079, 2079, 2079,
 /*   260 */    65, 1215,  747,  872,  526,  918,  132,   19,  368,  140,
 /*   270 */   406,   88,  477,  477,  477,  477,  477,  477,  477,  477,
 /*   280 */   308,  376,  336,  572,  680,  422,  450,  450,  450,  450,
 /*   290 */   902,   26,  789,  826,  827,  849,  923,  936,  940,  930,
 /*   300 */   883,  916,  919,  885,  831,  751,  286,  926,  863,  927,
 /*   310 */   906,  928,  931,  934,  935,  941,  938,  948,  943,  947,
 /*   320 */   977,  980,  985,  986,  713,  955,  966, 1311, 1312, 1273,
 /*   330 */  1314, 1244, 1327, 1283, 1154, 1285, 1286, 1287, 1158, 1336,
 /*   340 */  1291, 1293, 1168, 1347, 1171, 1349, 1303, 1351, 1330, 1353,
 /*   350 */  1308, 1356, 1276, 1201, 1204, 1205, 1211, 1371, 1378, 1225,
 /*   360 */  1227, 1387, 1388, 1340, 1385, 1259, 1402, 1405, 1406, 1407,
 /*   370 */  1411, 1412, 1413, 1414, 1415, 1417, 1418, 1419, 1423, 1424,
 /*   380 */  1425, 1426, 1427, 1428, 1389, 1430, 1431, 1432, 1434, 1436,
 /*   390 */  1437, 1422, 1446, 1447, 1448, 1458, 1459, 1460, 1410, 1416,
 /*   400 */  1420, 1438, 1421, 1440, 1429, 1451, 1439, 1433, 1455, 1456,
 /*   410 */  1466, 1435, 1313, 1467, 1468, 1441, 1469, 1443, 1474, 1479,
 /*   420 */  1444, 1442, 1445, 1481, 1453, 1464, 1449, 1483, 1457, 1471,
 /*   430 */  1475, 1484, 1461, 1473, 1477, 1488, 1490, 1503, 1505, 1470,
 /*   440 */  1452, 1476, 1495, 1519, 1478, 1482, 1485, 1487, 1480, 1489,
 /*   450 */  1492, 1502, 1509, 1526, 1506, 1531, 1514, 1510, 1537, 1541,
 /*   460 */  1512, 1564, 1543, 1567, 1546, 1549, 1571, 1493, 1525, 1573,
 /*   470 */  1409, 1554, 1494, 1454, 1578, 1579, 1580, 1496, 1581, 1501,
 /*   480 */  1547, 1486, 1542, 1544, 1372, 1504, 1550, 1507, 1511, 1513,
 /*   490 */  1516, 1508, 1552, 1551, 1556, 1517, 1563, 1399, 1529, 1533,
 /*   500 */  1572, 1408, 1577, 1575, 1538, 1582, 1462, 1539, 1583, 1590,
 /*   510 */  1596, 1598, 1600, 1602, 1539, 1623, 1499, 1585, 1568, 1570,
 /*   520 */  1574, 1608, 1584, 1587, 1616, 1639, 1491, 1591, 1588, 1593,
 /*   530 */  1592, 1597, 1518, 1610, 1663, 1634, 1553, 1611, 1604, 1645,
 /*   540 */  1659, 1624, 1625, 1627, 1695, 1637, 1629, 1640, 1672, 1676,
 /*   550 */  1643, 1644, 1678, 1646, 1647, 1683, 1650, 1652, 1685, 1655,
 /*   560 */  1656, 1690, 1658, 1635, 1636, 1638, 1641, 1722, 1660, 1664,
 /*   570 */  1666, 1701, 1670, 1708, 1708, 1730, 1697, 1696, 1711, 1698,
 /*   580 */  1680, 1720, 1724, 1725, 1726, 1727, 1728, 1747, 1729, 1731,
 /*   590 */  1715, 1480, 1733, 1489, 1736, 1737, 1746, 1748, 1749, 1750,
 /*   600 */  1781, 1751, 1754, 1757, 1800, 1755, 1756, 1766, 1805, 1759,
 /*   610 */  1762, 1771, 1809, 1763, 1768, 1774, 1814, 1769, 1815, 1798,
 /*   620 */  1801, 1799, 1802, 1804, 1803,
};
#define YY_REDUCE_COUNT (259)
#define YY_REDUCE_MIN   (-300)
#define YY_REDUCE_MAX   (1758)
static const short yy_reduce_ofst[] = {
 /*     0 */   -80, -241,   38,  242,  402,  615,  676,  737,  806,  815,
 /*    10 */   -18,  190,  864,  920,  929, 1008, 1059, 1076, 1125, 1179,
 /*    20 */  1228, 1237, 1292, 1318, 1370, 1384, 1396, 1450, 1472, 1534,
 /*    30 */  1548, 1589, 1603, 1654, 1668, 1717, 1734, 1758, -232, 1065,
 /*    40 */  -154,  138,  298, -269,  103, -257,  264, -242,   -5,   21,
 /*    50 */  -223,   54, -239,  -33, -240, -280,  -27,   -6, -207, -156,
 /*    60 */   237,  285,  290,  300,  478,  487, -237,  509,  519,  155,
 /*    70 */   -14,  142,  199,  611,  638,  252,  642,  262,  267,  354,
 /*    80 */   545,  370,  -88, -300, -300, -300, -164,  240, -235, -224,
 /*    90 */    31,  125,  259,  266,  296,  337,  385,  386,  431,  440,
 /*   100 */   449,  515,  518,  612,  613,  614,  630,  261, -201,  -42,
 /*   110 */   439,  225,  -99,   79,  446,  455,  397,  434,  504,  332,
 /*   120 */   -94,  589,  508,  516,  472,  -41, -271,  529,  531,  557,
 /*   130 */   607,  692,  699,  391,  727,  714,  616,  628,  730,  691,
 /*   140 */   681,  736,  736,  777,  796,  766,  744,  724,  724,  724,
 /*   150 */   711,  717,  718,  732,  736,  765,  828,  772,  825,  783,
 /*   160 */   837,  838,  800,  807,  808,  844,  856,  857,  801,  852,
 /*   170 */   823,  860,  814,  816,  873,  820,  882,  840,  847,  886,
 /*   180 */   887,  889,  890,  898,  876,  878,  880,  881,  888,  892,
 /*   190 */   894,  895,  897,  899,  901,  903,  907,  877,  893,  851,
 /*   200 */   904,  865,  908,  921,  937,  891,  939,  911,  884,  942,
 /*   210 */   896,  848,  910,  932,  853,  915,  933,  946,  736,  866,
 /*   220 */   875,  879,  909,  724,  944,  951,  924,  905,  912,  913,
 /*   230 */   917,  922,  945,  952,  953,  964,  981,  990,  967,  991,
 /*   240 */   989, 1002,  993, 1030, 1017, 1035, 1007, 1016, 1009, 1034,
 /*   250 */  1047, 1044, 1055, 1000,  998, 1042, 1043, 1045, 1057, 1067,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*    10 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*    20 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*    30 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*    40 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*    50 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*    60 */  1375, 1375, 1375, 1375, 1375, 1375, 1444, 1375, 1375, 1375,
 /*    70 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*    80 */  1375, 1442, 1591, 1375, 1755, 1375, 1375, 1375, 1375, 1375,
 /*    90 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   100 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   110 */  1375, 1444, 1375, 1766, 1766, 1766, 1442, 1375, 1375, 1375,
 /*   120 */  1375, 1375, 1375, 1375, 1538, 1375, 1375, 1375, 1375, 1375,
 /*   130 */  1375, 1375, 1375, 1624, 1375, 1375, 1832, 1375, 1375, 1630,
 /*   140 */  1790, 1375, 1375, 1375, 1375, 1491, 1782, 1758, 1772, 1759,
 /*   150 */  1817, 1817, 1817, 1775, 1375, 1786, 1375, 1375, 1375, 1616,
 /*   160 */  1375, 1375, 1596, 1593, 1593, 1375, 1375, 1375, 1375, 1444,
 /*   170 */  1375, 1444, 1375, 1375, 1444, 1375, 1444, 1375, 1375, 1444,
 /*   180 */  1444, 1375, 1444, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   190 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   200 */  1442, 1626, 1375, 1442, 1375, 1375, 1442, 1375, 1375, 1442,
 /*   210 */  1375, 1797, 1795, 1375, 1797, 1795, 1375, 1375, 1375, 1809,
 /*   220 */  1805, 1788, 1786, 1772, 1375, 1375, 1375, 1823, 1819, 1835,
 /*   230 */  1823, 1819, 1823, 1819, 1375, 1795, 1375, 1375, 1795, 1375,
 /*   240 */  1601, 1375, 1375, 1442, 1375, 1442, 1375, 1507, 1375, 1375,
 /*   250 */  1375, 1442, 1375, 1618, 1632, 1541, 1541, 1541, 1445, 1380,
 /*   260 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   270 */  1375, 1503, 1699, 1808, 1807, 1731, 1730, 1729, 1727, 1698,
 /*   280 */  1375, 1375, 1375, 1375, 1375, 1375, 1692, 1693, 1691, 1690,
 /*   290 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   300 */  1375, 1375, 1375, 1756, 1375, 1820, 1824, 1375, 1375, 1375,
 /*   310 */  1675, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   320 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   330 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   340 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   350 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   360 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   370 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   380 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   390 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   400 */  1409, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   410 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   420 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   430 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   440 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1472, 1471,
 /*   450 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   460 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   470 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   480 */  1375, 1375, 1779, 1789, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   490 */  1375, 1375, 1375, 1375, 1675, 1375, 1806, 1375, 1765, 1761,
 /*   500 */  1375, 1375, 1757, 1375, 1375, 1818, 1375, 1375, 1375, 1375,
 /*   510 */  1375, 1375, 1375, 1375, 1375, 1751, 1375, 1724, 1375, 1375,
 /*   520 */  1375, 1375, 1375, 1375, 1375, 1375, 1686, 1375, 1375, 1375,
 /*   530 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1674,
 /*   540 */  1375, 1715, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   550 */  1535, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   560 */  1375, 1375, 1375, 1520, 1518, 1517, 1516, 1375, 1513, 1375,
 /*   570 */  1375, 1375, 1375, 1544, 1543, 1375, 1375, 1375, 1375, 1375,
 /*   580 */  1375, 1464, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   590 */  1375, 1455, 1375, 1454, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   600 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   610 */  1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
 /*   620 */  1375, 1375, 1375, 1375, 1375,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  233,  /*  NK_BITNOT => ID */
  233,  /*     INSERT => ID */
  233,  /*     VALUES => ID */
  233,  /*     IMPORT => ID */
  233,  /*    NK_SEMI => ID */
  233,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DURATION",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "MAX_DELAY",
  /*  113 */ "WATERMARK",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "FIRST",
  /*  118 */ "LAST",
  /*  119 */ "SHOW",
  /*  120 */ "DATABASES",
  /*  121 */ "TABLES",
  /*  122 */ "STABLES",
  /*  123 */ "MNODES",
  /*  124 */ "MODULES",
  /*  125 */ "QNODES",
  /*  126 */ "FUNCTIONS",
  /*  127 */ "INDEXES",
  /*  128 */ "ACCOUNTS",
  /*  129 */ "APPS",
  /*  130 */ "CONNECTIONS",
  /*  131 */ "LICENCE",
  /*  132 */ "GRANTS",
  /*  133 */ "QUERIES",
  /*  134 */ "SCORES",
  /*  135 */ "TOPICS",
  /*  136 */ "VARIABLES",
  /*  137 */ "BNODES",
  /*  138 */ "SNODES",
  /*  139 */ "CLUSTER",
  /*  140 */ "TRANSACTIONS",
  /*  141 */ "DISTRIBUTED",
  /*  142 */ "LIKE",
  /*  143 */ "INDEX",
  /*  144 */ "FULLTEXT",
  /*  145 */ "FUNCTION",
  /*  146 */ "INTERVAL",
  /*  147 */ "TOPIC",
  /*  148 */ "AS",
  /*  149 */ "CONSUMER",
  /*  150 */ "GROUP",
  /*  151 */ "DESC",
  /*  152 */ "DESCRIBE",
  /*  153 */ "RESET",
  /*  154 */ "QUERY",
  /*  155 */ "CACHE",
  /*  156 */ "EXPLAIN",
  /*  157 */ "ANALYZE",
  /*  158 */ "VERBOSE",
  /*  159 */ "NK_BOOL",
  /*  160 */ "RATIO",
  /*  161 */ "NK_FLOAT",
  /*  162 */ "COMPACT",
  /*  163 */ "VNODES",
  /*  164 */ "IN",
  /*  165 */ "OUTPUTTYPE",
  /*  166 */ "AGGREGATE",
  /*  167 */ "BUFSIZE",
  /*  168 */ "STREAM",
  /*  169 */ "INTO",
  /*  170 */ "TRIGGER",
  /*  171 */ "AT_ONCE",
  /*  172 */ "WINDOW_CLOSE",
  /*  173 */ "KILL",
  /*  174 */ "CONNECTION",
  /*  175 */ "TRANSACTION",
  /*  176 */ "BALANCE",
  /*  177 */ "VGROUP",
  /*  178 */ "MERGE",
  /*  179 */ "REDISTRIBUTE",
  /*  180 */ "SPLIT",
  /*  181 */ "SYNCDB",
  /*  182 */ "DELETE",
  /*  183 */ "NULL",
  /*  184 */ "NK_QUESTION",
  /*  185 */ "NK_ARROW",
  /*  186 */ "ROWTS",
  /*  187 */ "TBNAME",
  /*  188 */ "QSTARTTS",
  /*  189 */ "QENDTS",
  /*  190 */ "WSTARTTS",
  /*  191 */ "WENDTS",
  /*  192 */ "WDURATION",
  /*  193 */ "CAST",
  /*  194 */ "NOW",
  /*  195 */ "TODAY",
  /*  196 */ "TIMEZONE",
  /*  197 */ "COUNT",
  /*  198 */ "LAST_ROW",
  /*  199 */ "BETWEEN",
  /*  200 */ "IS",
  /*  201 */ "NK_LT",
  /*  202 */ "NK_GT",
  /*  203 */ "NK_LE",
  /*  204 */ "NK_GE",
  /*  205 */ "NK_NE",
  /*  206 */ "MATCH",
  /*  207 */ "NMATCH",
  /*  208 */ "CONTAINS",
  /*  209 */ "JOIN",
  /*  210 */ "INNER",
  /*  211 */ "SELECT",
  /*  212 */ "DISTINCT",
  /*  213 */ "WHERE",
  /*  214 */ "PARTITION",
  /*  215 */ "BY",
  /*  216 */ "SESSION",
  /*  217 */ "STATE_WINDOW",
  /*  218 */ "SLIDING",
  /*  219 */ "FILL",
  /*  220 */ "VALUE",
  /*  221 */ "NONE",
  /*  222 */ "PREV",
  /*  223 */ "LINEAR",
  /*  224 */ "NEXT",
  /*  225 */ "HAVING",
  /*  226 */ "ORDER",
  /*  227 */ "SLIMIT",
  /*  228 */ "SOFFSET",
  /*  229 */ "LIMIT",
  /*  230 */ "OFFSET",
  /*  231 */ "ASC",
  /*  232 */ "NULLS",
  /*  233 */ "ID",
  /*  234 */ "NK_BITNOT",
  /*  235 */ "INSERT",
  /*  236 */ "VALUES",
  /*  237 */ "IMPORT",
  /*  238 */ "NK_SEMI",
  /*  239 */ "FILE",
  /*  240 */ "cmd",
  /*  241 */ "account_options",
  /*  242 */ "alter_account_options",
  /*  243 */ "literal",
  /*  244 */ "alter_account_option",
  /*  245 */ "user_name",
  /*  246 */ "privileges",
  /*  247 */ "priv_level",
  /*  248 */ "priv_type_list",
  /*  249 */ "priv_type",
  /*  250 */ "db_name",
  /*  251 */ "dnode_endpoint",
  /*  252 */ "not_exists_opt",
  /*  253 */ "db_options",
  /*  254 */ "exists_opt",
  /*  255 */ "alter_db_options",
  /*  256 */ "integer_list",
  /*  257 */ "variable_list",
  /*  258 */ "retention_list",
  /*  259 */ "alter_db_option",
  /*  260 */ "retention",
  /*  261 */ "full_table_name",
  /*  262 */ "column_def_list",
  /*  263 */ "tags_def_opt",
  /*  264 */ "table_options",
  /*  265 */ "multi_create_clause",
  /*  266 */ "tags_def",
  /*  267 */ "multi_drop_clause",
  /*  268 */ "alter_table_clause",
  /*  269 */ "alter_table_options",
  /*  270 */ "column_name",
  /*  271 */ "type_name",
  /*  272 */ "signed_literal",
  /*  273 */ "create_subtable_clause",
  /*  274 */ "specific_tags_opt",
  /*  275 */ "literal_list",
  /*  276 */ "drop_table_clause",
  /*  277 */ "col_name_list",
  /*  278 */ "table_name",
  /*  279 */ "column_def",
  /*  280 */ "duration_list",
  /*  281 */ "rollup_func_list",
  /*  282 */ "alter_table_option",
  /*  283 */ "duration_literal",
  /*  284 */ "rollup_func_name",
  /*  285 */ "function_name",
  /*  286 */ "col_name",
  /*  287 */ "db_name_cond_opt",
  /*  288 */ "like_pattern_opt",
  /*  289 */ "table_name_cond",
  /*  290 */ "from_db_opt",
  /*  291 */ "index_name",
  /*  292 */ "index_options",
  /*  293 */ "func_list",
  /*  294 */ "sliding_opt",
  /*  295 */ "func",
  /*  296 */ "expression_list",
  /*  297 */ "topic_name",
  /*  298 */ "query_expression",
  /*  299 */ "cgroup_name",
  /*  300 */ "analyze_opt",
  /*  301 */ "explain_options",
  /*  302 */ "agg_func_opt",
  /*  303 */ "bufsize_opt",
  /*  304 */ "stream_name",
  /*  305 */ "stream_options",
  /*  306 */ "into_opt",
  /*  307 */ "dnode_list",
  /*  308 */ "where_clause_opt",
  /*  309 */ "signed",
  /*  310 */ "literal_func",
  /*  311 */ "table_alias",
  /*  312 */ "column_alias",
  /*  313 */ "expression",
  /*  314 */ "pseudo_column",
  /*  315 */ "column_reference",
  /*  316 */ "function_expression",
  /*  317 */ "subquery",
  /*  318 */ "star_func",
  /*  319 */ "star_func_para_list",
  /*  320 */ "noarg_func",
  /*  321 */ "other_para_list",
  /*  322 */ "star_func_para",
  /*  323 */ "predicate",
  /*  324 */ "compare_op",
  /*  325 */ "in_op",
  /*  326 */ "in_predicate_value",
  /*  327 */ "boolean_value_expression",
  /*  328 */ "boolean_primary",
  /*  329 */ "common_expression",
  /*  330 */ "from_clause",
  /*  331 */ "table_reference_list",
  /*  332 */ "table_reference",
  /*  333 */ "table_primary",
  /*  334 */ "joined_table",
  /*  335 */ "alias_opt",
  /*  336 */ "parenthesized_joined_table",
  /*  337 */ "join_type",
  /*  338 */ "search_condition",
  /*  339 */ "query_specification",
  /*  340 */ "set_quantifier_opt",
  /*  341 */ "select_list",
  /*  342 */ "partition_by_clause_opt",
  /*  343 */ "twindow_clause_opt",
  /*  344 */ "group_by_clause_opt",
  /*  345 */ "having_clause_opt",
  /*  346 */ "select_sublist",
  /*  347 */ "select_item",
  /*  348 */ "fill_opt",
  /*  349 */ "fill_mode",
  /*  350 */ "group_by_list",
  /*  351 */ "query_expression_body",
  /*  352 */ "order_by_clause_opt",
  /*  353 */ "slimit_clause_opt",
  /*  354 */ "limit_clause_opt",
  /*  355 */ "query_primary",
  /*  356 */ "sort_specification_list",
  /*  357 */ "sort_specification",
  /*  358 */ "ordering_specification_opt",
  /*  359 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_endpoint ::= NK_ID",
 /*  48 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  72 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 166 */ "table_options ::= table_options WATERMARK duration_list",
 /* 167 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 168 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 169 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 170 */ "alter_table_options ::= alter_table_option",
 /* 171 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 172 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 173 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 174 */ "duration_list ::= duration_literal",
 /* 175 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 176 */ "rollup_func_list ::= rollup_func_name",
 /* 177 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 178 */ "rollup_func_name ::= function_name",
 /* 179 */ "rollup_func_name ::= FIRST",
 /* 180 */ "rollup_func_name ::= LAST",
 /* 181 */ "col_name_list ::= col_name",
 /* 182 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 183 */ "col_name ::= column_name",
 /* 184 */ "cmd ::= SHOW DNODES",
 /* 185 */ "cmd ::= SHOW USERS",
 /* 186 */ "cmd ::= SHOW DATABASES",
 /* 187 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 188 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 189 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 190 */ "cmd ::= SHOW MNODES",
 /* 191 */ "cmd ::= SHOW MODULES",
 /* 192 */ "cmd ::= SHOW QNODES",
 /* 193 */ "cmd ::= SHOW FUNCTIONS",
 /* 194 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 195 */ "cmd ::= SHOW STREAMS",
 /* 196 */ "cmd ::= SHOW ACCOUNTS",
 /* 197 */ "cmd ::= SHOW APPS",
 /* 198 */ "cmd ::= SHOW CONNECTIONS",
 /* 199 */ "cmd ::= SHOW LICENCE",
 /* 200 */ "cmd ::= SHOW GRANTS",
 /* 201 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 202 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 203 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 204 */ "cmd ::= SHOW QUERIES",
 /* 205 */ "cmd ::= SHOW SCORES",
 /* 206 */ "cmd ::= SHOW TOPICS",
 /* 207 */ "cmd ::= SHOW VARIABLES",
 /* 208 */ "cmd ::= SHOW BNODES",
 /* 209 */ "cmd ::= SHOW SNODES",
 /* 210 */ "cmd ::= SHOW CLUSTER",
 /* 211 */ "cmd ::= SHOW TRANSACTIONS",
 /* 212 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 213 */ "db_name_cond_opt ::=",
 /* 214 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 215 */ "like_pattern_opt ::=",
 /* 216 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 217 */ "table_name_cond ::= table_name",
 /* 218 */ "from_db_opt ::=",
 /* 219 */ "from_db_opt ::= FROM db_name",
 /* 220 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 221 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 222 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 223 */ "index_options ::=",
 /* 224 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 225 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 226 */ "func_list ::= func",
 /* 227 */ "func_list ::= func_list NK_COMMA func",
 /* 228 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 229 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 230 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 231 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 232 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 233 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 234 */ "cmd ::= DESC full_table_name",
 /* 235 */ "cmd ::= DESCRIBE full_table_name",
 /* 236 */ "cmd ::= RESET QUERY CACHE",
 /* 237 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 238 */ "analyze_opt ::=",
 /* 239 */ "analyze_opt ::= ANALYZE",
 /* 240 */ "explain_options ::=",
 /* 241 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 242 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 243 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 244 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 245 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 246 */ "agg_func_opt ::=",
 /* 247 */ "agg_func_opt ::= AGGREGATE",
 /* 248 */ "bufsize_opt ::=",
 /* 249 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 250 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 251 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 252 */ "into_opt ::=",
 /* 253 */ "into_opt ::= INTO full_table_name",
 /* 254 */ "stream_options ::=",
 /* 255 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 256 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 257 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 258 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 259 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 260 */ "cmd ::= KILL QUERY NK_STRING",
 /* 261 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 262 */ "cmd ::= BALANCE VGROUP",
 /* 263 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 264 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 265 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 266 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 267 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 268 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 269 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 270 */ "cmd ::= query_expression",
 /* 271 */ "literal ::= NK_INTEGER",
 /* 272 */ "literal ::= NK_FLOAT",
 /* 273 */ "literal ::= NK_STRING",
 /* 274 */ "literal ::= NK_BOOL",
 /* 275 */ "literal ::= TIMESTAMP NK_STRING",
 /* 276 */ "literal ::= duration_literal",
 /* 277 */ "literal ::= NULL",
 /* 278 */ "literal ::= NK_QUESTION",
 /* 279 */ "duration_literal ::= NK_VARIABLE",
 /* 280 */ "signed ::= NK_INTEGER",
 /* 281 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 282 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 283 */ "signed ::= NK_FLOAT",
 /* 284 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 285 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 286 */ "signed_literal ::= signed",
 /* 287 */ "signed_literal ::= NK_STRING",
 /* 288 */ "signed_literal ::= NK_BOOL",
 /* 289 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 290 */ "signed_literal ::= duration_literal",
 /* 291 */ "signed_literal ::= NULL",
 /* 292 */ "signed_literal ::= literal_func",
 /* 293 */ "literal_list ::= signed_literal",
 /* 294 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 295 */ "db_name ::= NK_ID",
 /* 296 */ "table_name ::= NK_ID",
 /* 297 */ "column_name ::= NK_ID",
 /* 298 */ "function_name ::= NK_ID",
 /* 299 */ "table_alias ::= NK_ID",
 /* 300 */ "column_alias ::= NK_ID",
 /* 301 */ "user_name ::= NK_ID",
 /* 302 */ "index_name ::= NK_ID",
 /* 303 */ "topic_name ::= NK_ID",
 /* 304 */ "stream_name ::= NK_ID",
 /* 305 */ "cgroup_name ::= NK_ID",
 /* 306 */ "expression ::= literal",
 /* 307 */ "expression ::= pseudo_column",
 /* 308 */ "expression ::= column_reference",
 /* 309 */ "expression ::= function_expression",
 /* 310 */ "expression ::= subquery",
 /* 311 */ "expression ::= NK_LP expression NK_RP",
 /* 312 */ "expression ::= NK_PLUS expression",
 /* 313 */ "expression ::= NK_MINUS expression",
 /* 314 */ "expression ::= expression NK_PLUS expression",
 /* 315 */ "expression ::= expression NK_MINUS expression",
 /* 316 */ "expression ::= expression NK_STAR expression",
 /* 317 */ "expression ::= expression NK_SLASH expression",
 /* 318 */ "expression ::= expression NK_REM expression",
 /* 319 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 320 */ "expression_list ::= expression",
 /* 321 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 322 */ "column_reference ::= column_name",
 /* 323 */ "column_reference ::= table_name NK_DOT column_name",
 /* 324 */ "pseudo_column ::= ROWTS",
 /* 325 */ "pseudo_column ::= TBNAME",
 /* 326 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 327 */ "pseudo_column ::= QSTARTTS",
 /* 328 */ "pseudo_column ::= QENDTS",
 /* 329 */ "pseudo_column ::= WSTARTTS",
 /* 330 */ "pseudo_column ::= WENDTS",
 /* 331 */ "pseudo_column ::= WDURATION",
 /* 332 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 333 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 334 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 335 */ "function_expression ::= literal_func",
 /* 336 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 337 */ "literal_func ::= NOW",
 /* 338 */ "noarg_func ::= NOW",
 /* 339 */ "noarg_func ::= TODAY",
 /* 340 */ "noarg_func ::= TIMEZONE",
 /* 341 */ "star_func ::= COUNT",
 /* 342 */ "star_func ::= FIRST",
 /* 343 */ "star_func ::= LAST",
 /* 344 */ "star_func ::= LAST_ROW",
 /* 345 */ "star_func_para_list ::= NK_STAR",
 /* 346 */ "star_func_para_list ::= other_para_list",
 /* 347 */ "other_para_list ::= star_func_para",
 /* 348 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 349 */ "star_func_para ::= expression",
 /* 350 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 351 */ "predicate ::= expression compare_op expression",
 /* 352 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 353 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 354 */ "predicate ::= expression IS NULL",
 /* 355 */ "predicate ::= expression IS NOT NULL",
 /* 356 */ "predicate ::= expression in_op in_predicate_value",
 /* 357 */ "compare_op ::= NK_LT",
 /* 358 */ "compare_op ::= NK_GT",
 /* 359 */ "compare_op ::= NK_LE",
 /* 360 */ "compare_op ::= NK_GE",
 /* 361 */ "compare_op ::= NK_NE",
 /* 362 */ "compare_op ::= NK_EQ",
 /* 363 */ "compare_op ::= LIKE",
 /* 364 */ "compare_op ::= NOT LIKE",
 /* 365 */ "compare_op ::= MATCH",
 /* 366 */ "compare_op ::= NMATCH",
 /* 367 */ "compare_op ::= CONTAINS",
 /* 368 */ "in_op ::= IN",
 /* 369 */ "in_op ::= NOT IN",
 /* 370 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 371 */ "boolean_value_expression ::= boolean_primary",
 /* 372 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 373 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 374 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 375 */ "boolean_primary ::= predicate",
 /* 376 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 377 */ "common_expression ::= expression",
 /* 378 */ "common_expression ::= boolean_value_expression",
 /* 379 */ "from_clause ::= FROM table_reference_list",
 /* 380 */ "table_reference_list ::= table_reference",
 /* 381 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 382 */ "table_reference ::= table_primary",
 /* 383 */ "table_reference ::= joined_table",
 /* 384 */ "table_primary ::= table_name alias_opt",
 /* 385 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 386 */ "table_primary ::= subquery alias_opt",
 /* 387 */ "table_primary ::= parenthesized_joined_table",
 /* 388 */ "alias_opt ::=",
 /* 389 */ "alias_opt ::= table_alias",
 /* 390 */ "alias_opt ::= AS table_alias",
 /* 391 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 392 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 393 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 394 */ "join_type ::=",
 /* 395 */ "join_type ::= INNER",
 /* 396 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 397 */ "set_quantifier_opt ::=",
 /* 398 */ "set_quantifier_opt ::= DISTINCT",
 /* 399 */ "set_quantifier_opt ::= ALL",
 /* 400 */ "select_list ::= NK_STAR",
 /* 401 */ "select_list ::= select_sublist",
 /* 402 */ "select_sublist ::= select_item",
 /* 403 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 404 */ "select_item ::= common_expression",
 /* 405 */ "select_item ::= common_expression column_alias",
 /* 406 */ "select_item ::= common_expression AS column_alias",
 /* 407 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 408 */ "where_clause_opt ::=",
 /* 409 */ "where_clause_opt ::= WHERE search_condition",
 /* 410 */ "partition_by_clause_opt ::=",
 /* 411 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 412 */ "twindow_clause_opt ::=",
 /* 413 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 414 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 415 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 416 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 417 */ "sliding_opt ::=",
 /* 418 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 419 */ "fill_opt ::=",
 /* 420 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 421 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 422 */ "fill_mode ::= NONE",
 /* 423 */ "fill_mode ::= PREV",
 /* 424 */ "fill_mode ::= NULL",
 /* 425 */ "fill_mode ::= LINEAR",
 /* 426 */ "fill_mode ::= NEXT",
 /* 427 */ "group_by_clause_opt ::=",
 /* 428 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 429 */ "group_by_list ::= expression",
 /* 430 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 431 */ "having_clause_opt ::=",
 /* 432 */ "having_clause_opt ::= HAVING search_condition",
 /* 433 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 434 */ "query_expression_body ::= query_primary",
 /* 435 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 436 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 437 */ "query_primary ::= query_specification",
 /* 438 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 439 */ "order_by_clause_opt ::=",
 /* 440 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 441 */ "slimit_clause_opt ::=",
 /* 442 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 443 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 444 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 445 */ "limit_clause_opt ::=",
 /* 446 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 447 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 448 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 449 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 450 */ "search_condition ::= common_expression",
 /* 451 */ "sort_specification_list ::= sort_specification",
 /* 452 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 453 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 454 */ "ordering_specification_opt ::=",
 /* 455 */ "ordering_specification_opt ::= ASC",
 /* 456 */ "ordering_specification_opt ::= DESC",
 /* 457 */ "null_ordering_opt ::=",
 /* 458 */ "null_ordering_opt ::= NULLS FIRST",
 /* 459 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 240: /* cmd */
    case 243: /* literal */
    case 253: /* db_options */
    case 255: /* alter_db_options */
    case 260: /* retention */
    case 261: /* full_table_name */
    case 264: /* table_options */
    case 268: /* alter_table_clause */
    case 269: /* alter_table_options */
    case 272: /* signed_literal */
    case 273: /* create_subtable_clause */
    case 276: /* drop_table_clause */
    case 279: /* column_def */
    case 283: /* duration_literal */
    case 284: /* rollup_func_name */
    case 286: /* col_name */
    case 287: /* db_name_cond_opt */
    case 288: /* like_pattern_opt */
    case 289: /* table_name_cond */
    case 290: /* from_db_opt */
    case 292: /* index_options */
    case 294: /* sliding_opt */
    case 295: /* func */
    case 298: /* query_expression */
    case 301: /* explain_options */
    case 305: /* stream_options */
    case 306: /* into_opt */
    case 308: /* where_clause_opt */
    case 309: /* signed */
    case 310: /* literal_func */
    case 313: /* expression */
    case 314: /* pseudo_column */
    case 315: /* column_reference */
    case 316: /* function_expression */
    case 317: /* subquery */
    case 322: /* star_func_para */
    case 323: /* predicate */
    case 326: /* in_predicate_value */
    case 327: /* boolean_value_expression */
    case 328: /* boolean_primary */
    case 329: /* common_expression */
    case 330: /* from_clause */
    case 331: /* table_reference_list */
    case 332: /* table_reference */
    case 333: /* table_primary */
    case 334: /* joined_table */
    case 336: /* parenthesized_joined_table */
    case 338: /* search_condition */
    case 339: /* query_specification */
    case 343: /* twindow_clause_opt */
    case 345: /* having_clause_opt */
    case 347: /* select_item */
    case 348: /* fill_opt */
    case 351: /* query_expression_body */
    case 353: /* slimit_clause_opt */
    case 354: /* limit_clause_opt */
    case 355: /* query_primary */
    case 357: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy632)); 
}
      break;
    case 241: /* account_options */
    case 242: /* alter_account_options */
    case 244: /* alter_account_option */
    case 303: /* bufsize_opt */
{
 
}
      break;
    case 245: /* user_name */
    case 247: /* priv_level */
    case 250: /* db_name */
    case 251: /* dnode_endpoint */
    case 270: /* column_name */
    case 278: /* table_name */
    case 285: /* function_name */
    case 291: /* index_name */
    case 297: /* topic_name */
    case 299: /* cgroup_name */
    case 304: /* stream_name */
    case 311: /* table_alias */
    case 312: /* column_alias */
    case 318: /* star_func */
    case 320: /* noarg_func */
    case 335: /* alias_opt */
{
 
}
      break;
    case 246: /* privileges */
    case 248: /* priv_type_list */
    case 249: /* priv_type */
{
 
}
      break;
    case 252: /* not_exists_opt */
    case 254: /* exists_opt */
    case 300: /* analyze_opt */
    case 302: /* agg_func_opt */
    case 340: /* set_quantifier_opt */
{
 
}
      break;
    case 256: /* integer_list */
    case 257: /* variable_list */
    case 258: /* retention_list */
    case 262: /* column_def_list */
    case 263: /* tags_def_opt */
    case 265: /* multi_create_clause */
    case 266: /* tags_def */
    case 267: /* multi_drop_clause */
    case 274: /* specific_tags_opt */
    case 275: /* literal_list */
    case 277: /* col_name_list */
    case 280: /* duration_list */
    case 281: /* rollup_func_list */
    case 293: /* func_list */
    case 296: /* expression_list */
    case 307: /* dnode_list */
    case 319: /* star_func_para_list */
    case 321: /* other_para_list */
    case 341: /* select_list */
    case 342: /* partition_by_clause_opt */
    case 344: /* group_by_clause_opt */
    case 346: /* select_sublist */
    case 350: /* group_by_list */
    case 352: /* order_by_clause_opt */
    case 356: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy424)); 
}
      break;
    case 259: /* alter_db_option */
    case 282: /* alter_table_option */
{
 
}
      break;
    case 271: /* type_name */
{
 
}
      break;
    case 324: /* compare_op */
    case 325: /* in_op */
{
 
}
      break;
    case 337: /* join_type */
{
 
}
      break;
    case 349: /* fill_mode */
{
 
}
      break;
    case 358: /* ordering_specification_opt */
{
 
}
      break;
    case 359: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  240,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  240,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  241,    0 }, /* (2) account_options ::= */
  {  241,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  241,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  241,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  241,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  241,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  241,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  241,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  241,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  241,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  242,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  242,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  244,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  244,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  244,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  244,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  244,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  244,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  244,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  244,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  244,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  244,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  240,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  240,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  240,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  240,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  240,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  240,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  246,   -1 }, /* (30) privileges ::= ALL */
  {  246,   -1 }, /* (31) privileges ::= priv_type_list */
  {  248,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  248,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  249,   -1 }, /* (34) priv_type ::= READ */
  {  249,   -1 }, /* (35) priv_type ::= WRITE */
  {  247,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  247,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  240,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  240,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  240,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  240,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  240,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  240,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  240,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  240,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  251,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  251,   -1 }, /* (47) dnode_endpoint ::= NK_ID */
  {  251,   -1 }, /* (48) dnode_endpoint ::= NK_IPTOKEN */
  {  240,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  240,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  240,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  240,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  240,   -2 }, /* (61) cmd ::= USE db_name */
  {  240,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  252,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  252,    0 }, /* (64) not_exists_opt ::= */
  {  254,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  254,    0 }, /* (66) exists_opt ::= */
  {  253,    0 }, /* (67) db_options ::= */
  {  253,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  253,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  253,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  253,   -3 }, /* (71) db_options ::= db_options DURATION NK_INTEGER */
  {  253,   -3 }, /* (72) db_options ::= db_options DURATION NK_VARIABLE */
  {  253,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  253,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  253,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  253,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  253,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  253,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  253,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  253,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  253,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  253,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  253,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  253,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  253,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  253,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  253,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  255,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  255,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  259,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  259,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  259,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  259,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  259,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  259,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  259,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  259,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  259,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  256,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  256,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  257,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  257,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  258,   -1 }, /* (103) retention_list ::= retention */
  {  258,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  260,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  240,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  240,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  240,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  240,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  240,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  240,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  240,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  268,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  268,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  268,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  268,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  268,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  268,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  268,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  268,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  268,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  268,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  265,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  265,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  273,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  267,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  267,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  276,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  274,    0 }, /* (129) specific_tags_opt ::= */
  {  274,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  261,   -1 }, /* (131) full_table_name ::= table_name */
  {  261,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  262,   -1 }, /* (133) column_def_list ::= column_def */
  {  262,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  279,   -2 }, /* (135) column_def ::= column_name type_name */
  {  279,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  271,   -1 }, /* (137) type_name ::= BOOL */
  {  271,   -1 }, /* (138) type_name ::= TINYINT */
  {  271,   -1 }, /* (139) type_name ::= SMALLINT */
  {  271,   -1 }, /* (140) type_name ::= INT */
  {  271,   -1 }, /* (141) type_name ::= INTEGER */
  {  271,   -1 }, /* (142) type_name ::= BIGINT */
  {  271,   -1 }, /* (143) type_name ::= FLOAT */
  {  271,   -1 }, /* (144) type_name ::= DOUBLE */
  {  271,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  271,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  271,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  271,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  271,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  271,   -1 }, /* (152) type_name ::= JSON */
  {  271,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  271,   -1 }, /* (155) type_name ::= BLOB */
  {  271,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (157) type_name ::= DECIMAL */
  {  271,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  271,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  263,    0 }, /* (160) tags_def_opt ::= */
  {  263,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  266,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  264,    0 }, /* (163) table_options ::= */
  {  264,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  264,   -3 }, /* (165) table_options ::= table_options MAX_DELAY duration_list */
  {  264,   -3 }, /* (166) table_options ::= table_options WATERMARK duration_list */
  {  264,   -5 }, /* (167) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  264,   -3 }, /* (168) table_options ::= table_options TTL NK_INTEGER */
  {  264,   -5 }, /* (169) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  269,   -1 }, /* (170) alter_table_options ::= alter_table_option */
  {  269,   -2 }, /* (171) alter_table_options ::= alter_table_options alter_table_option */
  {  282,   -2 }, /* (172) alter_table_option ::= COMMENT NK_STRING */
  {  282,   -2 }, /* (173) alter_table_option ::= TTL NK_INTEGER */
  {  280,   -1 }, /* (174) duration_list ::= duration_literal */
  {  280,   -3 }, /* (175) duration_list ::= duration_list NK_COMMA duration_literal */
  {  281,   -1 }, /* (176) rollup_func_list ::= rollup_func_name */
  {  281,   -3 }, /* (177) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  284,   -1 }, /* (178) rollup_func_name ::= function_name */
  {  284,   -1 }, /* (179) rollup_func_name ::= FIRST */
  {  284,   -1 }, /* (180) rollup_func_name ::= LAST */
  {  277,   -1 }, /* (181) col_name_list ::= col_name */
  {  277,   -3 }, /* (182) col_name_list ::= col_name_list NK_COMMA col_name */
  {  286,   -1 }, /* (183) col_name ::= column_name */
  {  240,   -2 }, /* (184) cmd ::= SHOW DNODES */
  {  240,   -2 }, /* (185) cmd ::= SHOW USERS */
  {  240,   -2 }, /* (186) cmd ::= SHOW DATABASES */
  {  240,   -4 }, /* (187) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  240,   -4 }, /* (188) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  240,   -3 }, /* (189) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  240,   -2 }, /* (190) cmd ::= SHOW MNODES */
  {  240,   -2 }, /* (191) cmd ::= SHOW MODULES */
  {  240,   -2 }, /* (192) cmd ::= SHOW QNODES */
  {  240,   -2 }, /* (193) cmd ::= SHOW FUNCTIONS */
  {  240,   -5 }, /* (194) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  240,   -2 }, /* (195) cmd ::= SHOW STREAMS */
  {  240,   -2 }, /* (196) cmd ::= SHOW ACCOUNTS */
  {  240,   -2 }, /* (197) cmd ::= SHOW APPS */
  {  240,   -2 }, /* (198) cmd ::= SHOW CONNECTIONS */
  {  240,   -2 }, /* (199) cmd ::= SHOW LICENCE */
  {  240,   -2 }, /* (200) cmd ::= SHOW GRANTS */
  {  240,   -4 }, /* (201) cmd ::= SHOW CREATE DATABASE db_name */
  {  240,   -4 }, /* (202) cmd ::= SHOW CREATE TABLE full_table_name */
  {  240,   -4 }, /* (203) cmd ::= SHOW CREATE STABLE full_table_name */
  {  240,   -2 }, /* (204) cmd ::= SHOW QUERIES */
  {  240,   -2 }, /* (205) cmd ::= SHOW SCORES */
  {  240,   -2 }, /* (206) cmd ::= SHOW TOPICS */
  {  240,   -2 }, /* (207) cmd ::= SHOW VARIABLES */
  {  240,   -2 }, /* (208) cmd ::= SHOW BNODES */
  {  240,   -2 }, /* (209) cmd ::= SHOW SNODES */
  {  240,   -2 }, /* (210) cmd ::= SHOW CLUSTER */
  {  240,   -2 }, /* (211) cmd ::= SHOW TRANSACTIONS */
  {  240,   -4 }, /* (212) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  287,    0 }, /* (213) db_name_cond_opt ::= */
  {  287,   -2 }, /* (214) db_name_cond_opt ::= db_name NK_DOT */
  {  288,    0 }, /* (215) like_pattern_opt ::= */
  {  288,   -2 }, /* (216) like_pattern_opt ::= LIKE NK_STRING */
  {  289,   -1 }, /* (217) table_name_cond ::= table_name */
  {  290,    0 }, /* (218) from_db_opt ::= */
  {  290,   -2 }, /* (219) from_db_opt ::= FROM db_name */
  {  240,   -8 }, /* (220) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  240,  -10 }, /* (221) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  240,   -6 }, /* (222) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  292,    0 }, /* (223) index_options ::= */
  {  292,   -9 }, /* (224) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  292,  -11 }, /* (225) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  293,   -1 }, /* (226) func_list ::= func */
  {  293,   -3 }, /* (227) func_list ::= func_list NK_COMMA func */
  {  295,   -4 }, /* (228) func ::= function_name NK_LP expression_list NK_RP */
  {  240,   -6 }, /* (229) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  240,   -7 }, /* (230) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  240,   -7 }, /* (231) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  240,   -4 }, /* (232) cmd ::= DROP TOPIC exists_opt topic_name */
  {  240,   -7 }, /* (233) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  240,   -2 }, /* (234) cmd ::= DESC full_table_name */
  {  240,   -2 }, /* (235) cmd ::= DESCRIBE full_table_name */
  {  240,   -3 }, /* (236) cmd ::= RESET QUERY CACHE */
  {  240,   -4 }, /* (237) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  300,    0 }, /* (238) analyze_opt ::= */
  {  300,   -1 }, /* (239) analyze_opt ::= ANALYZE */
  {  301,    0 }, /* (240) explain_options ::= */
  {  301,   -3 }, /* (241) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  301,   -3 }, /* (242) explain_options ::= explain_options RATIO NK_FLOAT */
  {  240,   -6 }, /* (243) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  240,  -10 }, /* (244) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  240,   -4 }, /* (245) cmd ::= DROP FUNCTION exists_opt function_name */
  {  302,    0 }, /* (246) agg_func_opt ::= */
  {  302,   -1 }, /* (247) agg_func_opt ::= AGGREGATE */
  {  303,    0 }, /* (248) bufsize_opt ::= */
  {  303,   -2 }, /* (249) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  240,   -8 }, /* (250) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  240,   -4 }, /* (251) cmd ::= DROP STREAM exists_opt stream_name */
  {  306,    0 }, /* (252) into_opt ::= */
  {  306,   -2 }, /* (253) into_opt ::= INTO full_table_name */
  {  305,    0 }, /* (254) stream_options ::= */
  {  305,   -3 }, /* (255) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  305,   -3 }, /* (256) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  305,   -4 }, /* (257) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  305,   -3 }, /* (258) stream_options ::= stream_options WATERMARK duration_literal */
  {  240,   -3 }, /* (259) cmd ::= KILL CONNECTION NK_INTEGER */
  {  240,   -3 }, /* (260) cmd ::= KILL QUERY NK_STRING */
  {  240,   -3 }, /* (261) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  240,   -2 }, /* (262) cmd ::= BALANCE VGROUP */
  {  240,   -4 }, /* (263) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  240,   -4 }, /* (264) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  240,   -3 }, /* (265) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  307,   -2 }, /* (266) dnode_list ::= DNODE NK_INTEGER */
  {  307,   -3 }, /* (267) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  240,   -3 }, /* (268) cmd ::= SYNCDB db_name REPLICA */
  {  240,   -4 }, /* (269) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  240,   -1 }, /* (270) cmd ::= query_expression */
  {  243,   -1 }, /* (271) literal ::= NK_INTEGER */
  {  243,   -1 }, /* (272) literal ::= NK_FLOAT */
  {  243,   -1 }, /* (273) literal ::= NK_STRING */
  {  243,   -1 }, /* (274) literal ::= NK_BOOL */
  {  243,   -2 }, /* (275) literal ::= TIMESTAMP NK_STRING */
  {  243,   -1 }, /* (276) literal ::= duration_literal */
  {  243,   -1 }, /* (277) literal ::= NULL */
  {  243,   -1 }, /* (278) literal ::= NK_QUESTION */
  {  283,   -1 }, /* (279) duration_literal ::= NK_VARIABLE */
  {  309,   -1 }, /* (280) signed ::= NK_INTEGER */
  {  309,   -2 }, /* (281) signed ::= NK_PLUS NK_INTEGER */
  {  309,   -2 }, /* (282) signed ::= NK_MINUS NK_INTEGER */
  {  309,   -1 }, /* (283) signed ::= NK_FLOAT */
  {  309,   -2 }, /* (284) signed ::= NK_PLUS NK_FLOAT */
  {  309,   -2 }, /* (285) signed ::= NK_MINUS NK_FLOAT */
  {  272,   -1 }, /* (286) signed_literal ::= signed */
  {  272,   -1 }, /* (287) signed_literal ::= NK_STRING */
  {  272,   -1 }, /* (288) signed_literal ::= NK_BOOL */
  {  272,   -2 }, /* (289) signed_literal ::= TIMESTAMP NK_STRING */
  {  272,   -1 }, /* (290) signed_literal ::= duration_literal */
  {  272,   -1 }, /* (291) signed_literal ::= NULL */
  {  272,   -1 }, /* (292) signed_literal ::= literal_func */
  {  275,   -1 }, /* (293) literal_list ::= signed_literal */
  {  275,   -3 }, /* (294) literal_list ::= literal_list NK_COMMA signed_literal */
  {  250,   -1 }, /* (295) db_name ::= NK_ID */
  {  278,   -1 }, /* (296) table_name ::= NK_ID */
  {  270,   -1 }, /* (297) column_name ::= NK_ID */
  {  285,   -1 }, /* (298) function_name ::= NK_ID */
  {  311,   -1 }, /* (299) table_alias ::= NK_ID */
  {  312,   -1 }, /* (300) column_alias ::= NK_ID */
  {  245,   -1 }, /* (301) user_name ::= NK_ID */
  {  291,   -1 }, /* (302) index_name ::= NK_ID */
  {  297,   -1 }, /* (303) topic_name ::= NK_ID */
  {  304,   -1 }, /* (304) stream_name ::= NK_ID */
  {  299,   -1 }, /* (305) cgroup_name ::= NK_ID */
  {  313,   -1 }, /* (306) expression ::= literal */
  {  313,   -1 }, /* (307) expression ::= pseudo_column */
  {  313,   -1 }, /* (308) expression ::= column_reference */
  {  313,   -1 }, /* (309) expression ::= function_expression */
  {  313,   -1 }, /* (310) expression ::= subquery */
  {  313,   -3 }, /* (311) expression ::= NK_LP expression NK_RP */
  {  313,   -2 }, /* (312) expression ::= NK_PLUS expression */
  {  313,   -2 }, /* (313) expression ::= NK_MINUS expression */
  {  313,   -3 }, /* (314) expression ::= expression NK_PLUS expression */
  {  313,   -3 }, /* (315) expression ::= expression NK_MINUS expression */
  {  313,   -3 }, /* (316) expression ::= expression NK_STAR expression */
  {  313,   -3 }, /* (317) expression ::= expression NK_SLASH expression */
  {  313,   -3 }, /* (318) expression ::= expression NK_REM expression */
  {  313,   -3 }, /* (319) expression ::= column_reference NK_ARROW NK_STRING */
  {  296,   -1 }, /* (320) expression_list ::= expression */
  {  296,   -3 }, /* (321) expression_list ::= expression_list NK_COMMA expression */
  {  315,   -1 }, /* (322) column_reference ::= column_name */
  {  315,   -3 }, /* (323) column_reference ::= table_name NK_DOT column_name */
  {  314,   -1 }, /* (324) pseudo_column ::= ROWTS */
  {  314,   -1 }, /* (325) pseudo_column ::= TBNAME */
  {  314,   -3 }, /* (326) pseudo_column ::= table_name NK_DOT TBNAME */
  {  314,   -1 }, /* (327) pseudo_column ::= QSTARTTS */
  {  314,   -1 }, /* (328) pseudo_column ::= QENDTS */
  {  314,   -1 }, /* (329) pseudo_column ::= WSTARTTS */
  {  314,   -1 }, /* (330) pseudo_column ::= WENDTS */
  {  314,   -1 }, /* (331) pseudo_column ::= WDURATION */
  {  316,   -4 }, /* (332) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  316,   -4 }, /* (333) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  316,   -6 }, /* (334) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  316,   -1 }, /* (335) function_expression ::= literal_func */
  {  310,   -3 }, /* (336) literal_func ::= noarg_func NK_LP NK_RP */
  {  310,   -1 }, /* (337) literal_func ::= NOW */
  {  320,   -1 }, /* (338) noarg_func ::= NOW */
  {  320,   -1 }, /* (339) noarg_func ::= TODAY */
  {  320,   -1 }, /* (340) noarg_func ::= TIMEZONE */
  {  318,   -1 }, /* (341) star_func ::= COUNT */
  {  318,   -1 }, /* (342) star_func ::= FIRST */
  {  318,   -1 }, /* (343) star_func ::= LAST */
  {  318,   -1 }, /* (344) star_func ::= LAST_ROW */
  {  319,   -1 }, /* (345) star_func_para_list ::= NK_STAR */
  {  319,   -1 }, /* (346) star_func_para_list ::= other_para_list */
  {  321,   -1 }, /* (347) other_para_list ::= star_func_para */
  {  321,   -3 }, /* (348) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  322,   -1 }, /* (349) star_func_para ::= expression */
  {  322,   -3 }, /* (350) star_func_para ::= table_name NK_DOT NK_STAR */
  {  323,   -3 }, /* (351) predicate ::= expression compare_op expression */
  {  323,   -5 }, /* (352) predicate ::= expression BETWEEN expression AND expression */
  {  323,   -6 }, /* (353) predicate ::= expression NOT BETWEEN expression AND expression */
  {  323,   -3 }, /* (354) predicate ::= expression IS NULL */
  {  323,   -4 }, /* (355) predicate ::= expression IS NOT NULL */
  {  323,   -3 }, /* (356) predicate ::= expression in_op in_predicate_value */
  {  324,   -1 }, /* (357) compare_op ::= NK_LT */
  {  324,   -1 }, /* (358) compare_op ::= NK_GT */
  {  324,   -1 }, /* (359) compare_op ::= NK_LE */
  {  324,   -1 }, /* (360) compare_op ::= NK_GE */
  {  324,   -1 }, /* (361) compare_op ::= NK_NE */
  {  324,   -1 }, /* (362) compare_op ::= NK_EQ */
  {  324,   -1 }, /* (363) compare_op ::= LIKE */
  {  324,   -2 }, /* (364) compare_op ::= NOT LIKE */
  {  324,   -1 }, /* (365) compare_op ::= MATCH */
  {  324,   -1 }, /* (366) compare_op ::= NMATCH */
  {  324,   -1 }, /* (367) compare_op ::= CONTAINS */
  {  325,   -1 }, /* (368) in_op ::= IN */
  {  325,   -2 }, /* (369) in_op ::= NOT IN */
  {  326,   -3 }, /* (370) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  327,   -1 }, /* (371) boolean_value_expression ::= boolean_primary */
  {  327,   -2 }, /* (372) boolean_value_expression ::= NOT boolean_primary */
  {  327,   -3 }, /* (373) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  327,   -3 }, /* (374) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  328,   -1 }, /* (375) boolean_primary ::= predicate */
  {  328,   -3 }, /* (376) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  329,   -1 }, /* (377) common_expression ::= expression */
  {  329,   -1 }, /* (378) common_expression ::= boolean_value_expression */
  {  330,   -2 }, /* (379) from_clause ::= FROM table_reference_list */
  {  331,   -1 }, /* (380) table_reference_list ::= table_reference */
  {  331,   -3 }, /* (381) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  332,   -1 }, /* (382) table_reference ::= table_primary */
  {  332,   -1 }, /* (383) table_reference ::= joined_table */
  {  333,   -2 }, /* (384) table_primary ::= table_name alias_opt */
  {  333,   -4 }, /* (385) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  333,   -2 }, /* (386) table_primary ::= subquery alias_opt */
  {  333,   -1 }, /* (387) table_primary ::= parenthesized_joined_table */
  {  335,    0 }, /* (388) alias_opt ::= */
  {  335,   -1 }, /* (389) alias_opt ::= table_alias */
  {  335,   -2 }, /* (390) alias_opt ::= AS table_alias */
  {  336,   -3 }, /* (391) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  336,   -3 }, /* (392) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  334,   -6 }, /* (393) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  337,    0 }, /* (394) join_type ::= */
  {  337,   -1 }, /* (395) join_type ::= INNER */
  {  339,   -9 }, /* (396) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  340,    0 }, /* (397) set_quantifier_opt ::= */
  {  340,   -1 }, /* (398) set_quantifier_opt ::= DISTINCT */
  {  340,   -1 }, /* (399) set_quantifier_opt ::= ALL */
  {  341,   -1 }, /* (400) select_list ::= NK_STAR */
  {  341,   -1 }, /* (401) select_list ::= select_sublist */
  {  346,   -1 }, /* (402) select_sublist ::= select_item */
  {  346,   -3 }, /* (403) select_sublist ::= select_sublist NK_COMMA select_item */
  {  347,   -1 }, /* (404) select_item ::= common_expression */
  {  347,   -2 }, /* (405) select_item ::= common_expression column_alias */
  {  347,   -3 }, /* (406) select_item ::= common_expression AS column_alias */
  {  347,   -3 }, /* (407) select_item ::= table_name NK_DOT NK_STAR */
  {  308,    0 }, /* (408) where_clause_opt ::= */
  {  308,   -2 }, /* (409) where_clause_opt ::= WHERE search_condition */
  {  342,    0 }, /* (410) partition_by_clause_opt ::= */
  {  342,   -3 }, /* (411) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  343,    0 }, /* (412) twindow_clause_opt ::= */
  {  343,   -6 }, /* (413) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  343,   -4 }, /* (414) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  343,   -6 }, /* (415) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  343,   -8 }, /* (416) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  294,    0 }, /* (417) sliding_opt ::= */
  {  294,   -4 }, /* (418) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  348,    0 }, /* (419) fill_opt ::= */
  {  348,   -4 }, /* (420) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  348,   -6 }, /* (421) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  349,   -1 }, /* (422) fill_mode ::= NONE */
  {  349,   -1 }, /* (423) fill_mode ::= PREV */
  {  349,   -1 }, /* (424) fill_mode ::= NULL */
  {  349,   -1 }, /* (425) fill_mode ::= LINEAR */
  {  349,   -1 }, /* (426) fill_mode ::= NEXT */
  {  344,    0 }, /* (427) group_by_clause_opt ::= */
  {  344,   -3 }, /* (428) group_by_clause_opt ::= GROUP BY group_by_list */
  {  350,   -1 }, /* (429) group_by_list ::= expression */
  {  350,   -3 }, /* (430) group_by_list ::= group_by_list NK_COMMA expression */
  {  345,    0 }, /* (431) having_clause_opt ::= */
  {  345,   -2 }, /* (432) having_clause_opt ::= HAVING search_condition */
  {  298,   -4 }, /* (433) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  351,   -1 }, /* (434) query_expression_body ::= query_primary */
  {  351,   -4 }, /* (435) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  351,   -3 }, /* (436) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  355,   -1 }, /* (437) query_primary ::= query_specification */
  {  355,   -6 }, /* (438) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  352,    0 }, /* (439) order_by_clause_opt ::= */
  {  352,   -3 }, /* (440) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  353,    0 }, /* (441) slimit_clause_opt ::= */
  {  353,   -2 }, /* (442) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  353,   -4 }, /* (443) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  353,   -4 }, /* (444) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  354,    0 }, /* (445) limit_clause_opt ::= */
  {  354,   -2 }, /* (446) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  354,   -4 }, /* (447) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  354,   -4 }, /* (448) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  317,   -3 }, /* (449) subquery ::= NK_LP query_expression NK_RP */
  {  338,   -1 }, /* (450) search_condition ::= common_expression */
  {  356,   -1 }, /* (451) sort_specification_list ::= sort_specification */
  {  356,   -3 }, /* (452) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  357,   -3 }, /* (453) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  358,    0 }, /* (454) ordering_specification_opt ::= */
  {  358,   -1 }, /* (455) ordering_specification_opt ::= ASC */
  {  358,   -1 }, /* (456) ordering_specification_opt ::= DESC */
  {  359,    0 }, /* (457) null_ordering_opt ::= */
  {  359,   -2 }, /* (458) null_ordering_opt ::= NULLS FIRST */
  {  359,   -2 }, /* (459) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,242,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,241,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,244,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,242,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,244,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy189 = yymsp[0].minor.yy189; }
  yymsp[0].minor.yy189 = yylhsminor.yy189;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy189 = yymsp[-2].minor.yy189 | yymsp[0].minor.yy189; }
  yymsp[-2].minor.yy189 = yylhsminor.yy189;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy209; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy209, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 295: /* db_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* table_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* column_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* function_name ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* table_alias ::= NK_ID */ yytestcase(yyruleno==299);
      case 300: /* column_alias ::= NK_ID */ yytestcase(yyruleno==300);
      case 301: /* user_name ::= NK_ID */ yytestcase(yyruleno==301);
      case 302: /* index_name ::= NK_ID */ yytestcase(yyruleno==302);
      case 303: /* topic_name ::= NK_ID */ yytestcase(yyruleno==303);
      case 304: /* stream_name ::= NK_ID */ yytestcase(yyruleno==304);
      case 305: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==305);
      case 338: /* noarg_func ::= NOW */ yytestcase(yyruleno==338);
      case 339: /* noarg_func ::= TODAY */ yytestcase(yyruleno==339);
      case 340: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==340);
      case 341: /* star_func ::= COUNT */ yytestcase(yyruleno==341);
      case 342: /* star_func ::= FIRST */ yytestcase(yyruleno==342);
      case 343: /* star_func ::= LAST */ yytestcase(yyruleno==343);
      case 344: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==344);
{ yylhsminor.yy209 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy137, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy137 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 238: /* analyze_opt ::= */ yytestcase(yyruleno==238);
      case 246: /* agg_func_opt ::= */ yytestcase(yyruleno==246);
      case 397: /* set_quantifier_opt ::= */ yytestcase(yyruleno==397);
{ yymsp[1].minor.yy137 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy137 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy632 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 71: /* db_options ::= db_options DURATION NK_INTEGER */
      case 72: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_KEEP, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_RETENTIONS, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy632 = createAlterDatabaseOptions(pCxt); yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yylhsminor.yy632, &yymsp[0].minor.yy605); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy632, &yymsp[0].minor.yy605); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy605.type = DB_OPTION_KEEP; yymsp[-1].minor.yy605.pList = yymsp[0].minor.yy424; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_PAGES; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_STRICT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 267: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==267);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy424 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 176: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==176);
      case 181: /* col_name_list ::= col_name */ yytestcase(yyruleno==181);
      case 226: /* func_list ::= func */ yytestcase(yyruleno==226);
      case 293: /* literal_list ::= signed_literal */ yytestcase(yyruleno==293);
      case 347: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==347);
      case 402: /* select_sublist ::= select_item */ yytestcase(yyruleno==402);
      case 451: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==451);
{ yylhsminor.yy424 = createNodeList(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 177: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==177);
      case 182: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==182);
      case 227: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==227);
      case 294: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==294);
      case 348: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==348);
      case 403: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==403);
      case 452: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==452);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy632 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-5].minor.yy632, yymsp[-3].minor.yy424, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 270: /* cmd ::= query_expression */ yytestcase(yyruleno==270);
{ pCxt->pRootNode = yymsp[0].minor.yy632; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy632 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy632 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy632, &yymsp[-2].minor.yy209, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy424 = yylhsminor.yy424;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy632 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy137, yymsp[-8].minor.yy632, yymsp[-6].minor.yy632, yymsp[-5].minor.yy424, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-9].minor.yy632 = yylhsminor.yy632;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy632 = createDropTableClause(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 410: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==410);
      case 427: /* group_by_clause_opt ::= */ yytestcase(yyruleno==427);
      case 439: /* order_by_clause_opt ::= */ yytestcase(yyruleno==439);
{ yymsp[1].minor.yy424 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304, NULL); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-2].minor.yy304, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 346: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==346);
      case 401: /* select_list ::= select_sublist */ yytestcase(yyruleno==401);
{ yylhsminor.yy424 = yymsp[0].minor.yy424; }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy632 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 165: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 166: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 167: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 168: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 169: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_SMA, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 170: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy632 = createAlterTableOptions(pCxt); yylhsminor.yy632 = setTableOption(pCxt, yylhsminor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 171: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 172: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 173: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 174: /* duration_list ::= duration_literal */
      case 320: /* expression_list ::= expression */ yytestcase(yyruleno==320);
{ yylhsminor.yy424 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 175: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 321: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==321);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 178: /* rollup_func_name ::= function_name */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 179: /* rollup_func_name ::= FIRST */
      case 180: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==180);
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 183: /* col_name ::= column_name */
{ yylhsminor.yy632 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 184: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 185: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 186: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 187: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632, OP_TYPE_LIKE); }
        break;
      case 188: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632, OP_TYPE_LIKE); }
        break;
      case 189: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy632, NULL, OP_TYPE_LIKE); }
        break;
      case 190: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 191: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 192: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 193: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 194: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy632, yymsp[-1].minor.yy632, OP_TYPE_EQUAL); }
        break;
      case 195: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 196: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 197: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 198: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 199: /* cmd ::= SHOW LICENCE */
      case 200: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==200);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 201: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 202: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 203: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 204: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 205: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 206: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 207: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT); }
        break;
      case 208: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 210: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 211: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 212: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy632); }
        break;
      case 213: /* db_name_cond_opt ::= */
      case 218: /* from_db_opt ::= */ yytestcase(yyruleno==218);
{ yymsp[1].minor.yy632 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 214: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 215: /* like_pattern_opt ::= */
      case 223: /* index_options ::= */ yytestcase(yyruleno==223);
      case 252: /* into_opt ::= */ yytestcase(yyruleno==252);
      case 408: /* where_clause_opt ::= */ yytestcase(yyruleno==408);
      case 412: /* twindow_clause_opt ::= */ yytestcase(yyruleno==412);
      case 417: /* sliding_opt ::= */ yytestcase(yyruleno==417);
      case 419: /* fill_opt ::= */ yytestcase(yyruleno==419);
      case 431: /* having_clause_opt ::= */ yytestcase(yyruleno==431);
      case 441: /* slimit_clause_opt ::= */ yytestcase(yyruleno==441);
      case 445: /* limit_clause_opt ::= */ yytestcase(yyruleno==445);
{ yymsp[1].minor.yy632 = NULL; }
        break;
      case 216: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 217: /* table_name_cond ::= table_name */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 219: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
        break;
      case 220: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, NULL, yymsp[0].minor.yy632); }
        break;
      case 221: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424, NULL); }
        break;
      case 222: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 224: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy632 = createIndexOption(pCxt, yymsp[-6].minor.yy424, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL, yymsp[0].minor.yy632); }
        break;
      case 225: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy632 = createIndexOption(pCxt, yymsp[-8].minor.yy424, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[0].minor.yy632); }
        break;
      case 228: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 229: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, yymsp[0].minor.yy632, NULL, NULL); }
        break;
      case 230: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, NULL, &yymsp[0].minor.yy209, NULL); }
        break;
      case 231: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, NULL, NULL, yymsp[0].minor.yy632); }
        break;
      case 232: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 233: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 234: /* cmd ::= DESC full_table_name */
      case 235: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==235);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy632); }
        break;
      case 236: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 237: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy137, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 239: /* analyze_opt ::= ANALYZE */
      case 247: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==247);
      case 398: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==398);
{ yymsp[0].minor.yy137 = true; }
        break;
      case 240: /* explain_options ::= */
{ yymsp[1].minor.yy632 = createDefaultExplainOptions(pCxt); }
        break;
      case 241: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy632 = setExplainVerbose(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 242: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy632 = setExplainRatio(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 243: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy424); }
        break;
      case 244: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-8].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy304, yymsp[0].minor.yy100); }
        break;
      case 245: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 248: /* bufsize_opt ::= */
{ yymsp[1].minor.yy100 = 0; }
        break;
      case 249: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy100 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 250: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy137, &yymsp[-4].minor.yy209, yymsp[-2].minor.yy632, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 251: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 253: /* into_opt ::= INTO full_table_name */
      case 379: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==379);
      case 409: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==409);
      case 432: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==432);
{ yymsp[-1].minor.yy632 = yymsp[0].minor.yy632; }
        break;
      case 254: /* stream_options ::= */
{ yymsp[1].minor.yy632 = createStreamOptions(pCxt); }
        break;
      case 255: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 256: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 257: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy632)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy632)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); yylhsminor.yy632 = yymsp[-3].minor.yy632; }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 258: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 259: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 260: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 261: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 262: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 263: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 264: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy424); }
        break;
      case 265: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 266: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 268: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy209); }
        break;
      case 269: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 271: /* literal ::= NK_INTEGER */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 272: /* literal ::= NK_FLOAT */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 273: /* literal ::= NK_STRING */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 274: /* literal ::= NK_BOOL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 275: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 276: /* literal ::= duration_literal */
      case 286: /* signed_literal ::= signed */ yytestcase(yyruleno==286);
      case 306: /* expression ::= literal */ yytestcase(yyruleno==306);
      case 307: /* expression ::= pseudo_column */ yytestcase(yyruleno==307);
      case 308: /* expression ::= column_reference */ yytestcase(yyruleno==308);
      case 309: /* expression ::= function_expression */ yytestcase(yyruleno==309);
      case 310: /* expression ::= subquery */ yytestcase(yyruleno==310);
      case 335: /* function_expression ::= literal_func */ yytestcase(yyruleno==335);
      case 371: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==371);
      case 375: /* boolean_primary ::= predicate */ yytestcase(yyruleno==375);
      case 377: /* common_expression ::= expression */ yytestcase(yyruleno==377);
      case 378: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==378);
      case 380: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==380);
      case 382: /* table_reference ::= table_primary */ yytestcase(yyruleno==382);
      case 383: /* table_reference ::= joined_table */ yytestcase(yyruleno==383);
      case 387: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==387);
      case 434: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==434);
      case 437: /* query_primary ::= query_specification */ yytestcase(yyruleno==437);
{ yylhsminor.yy632 = yymsp[0].minor.yy632; }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 277: /* literal ::= NULL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 278: /* literal ::= NK_QUESTION */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 279: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 280: /* signed ::= NK_INTEGER */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 281: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 282: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 283: /* signed ::= NK_FLOAT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 284: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 285: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 287: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 288: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 289: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 290: /* signed_literal ::= duration_literal */
      case 292: /* signed_literal ::= literal_func */ yytestcase(yyruleno==292);
      case 349: /* star_func_para ::= expression */ yytestcase(yyruleno==349);
      case 404: /* select_item ::= common_expression */ yytestcase(yyruleno==404);
      case 450: /* search_condition ::= common_expression */ yytestcase(yyruleno==450);
{ yylhsminor.yy632 = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 291: /* signed_literal ::= NULL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 311: /* expression ::= NK_LP expression NK_RP */
      case 376: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==376);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 312: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy632));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 313: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 314: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 315: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 316: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 317: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 318: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 319: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 322: /* column_reference ::= column_name */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy209, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 323: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 324: /* pseudo_column ::= ROWTS */
      case 325: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==325);
      case 327: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==327);
      case 328: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==328);
      case 329: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==329);
      case 330: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==330);
      case 331: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==331);
      case 337: /* literal_func ::= NOW */ yytestcase(yyruleno==337);
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 326: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy209)))); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 332: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 333: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==333);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424)); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 334: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy304)); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 336: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy209, NULL)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 345: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy424 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 350: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 407: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==407);
{ yylhsminor.yy632 = createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 351: /* predicate ::= expression compare_op expression */
      case 356: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==356);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 352: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 353: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 354: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 355: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL));
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 357: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 358: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 359: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 360: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 361: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 362: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 363: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 364: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 365: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 366: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 367: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy380 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 368: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 369: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 370: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 372: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 373: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 374: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 381: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy632, yymsp[0].minor.yy632, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 384: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 385: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 386: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy632 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 388: /* alias_opt ::= */
{ yymsp[1].minor.yy209 = nil_token;  }
        break;
      case 389: /* alias_opt ::= table_alias */
{ yylhsminor.yy209 = yymsp[0].minor.yy209; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 390: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy209 = yymsp[0].minor.yy209; }
        break;
      case 391: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 392: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==392);
{ yymsp[-2].minor.yy632 = yymsp[-1].minor.yy632; }
        break;
      case 393: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, yymsp[-4].minor.yy612, yymsp[-5].minor.yy632, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 394: /* join_type ::= */
{ yymsp[1].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 395: /* join_type ::= INNER */
{ yymsp[0].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 396: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy632 = createSelectStmt(pCxt, yymsp[-7].minor.yy137, yymsp[-6].minor.yy424, yymsp[-5].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addWhereClause(pCxt, yymsp[-8].minor.yy632, yymsp[-4].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addPartitionByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-3].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy632, yymsp[-2].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addGroupByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-1].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addHavingClause(pCxt, yymsp[-8].minor.yy632, yymsp[0].minor.yy632);
                                                                                  }
        break;
      case 399: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy137 = false; }
        break;
      case 400: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy424 = NULL; }
        break;
      case 405: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 406: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 411: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 428: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==428);
      case 440: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==440);
{ yymsp[-2].minor.yy424 = yymsp[0].minor.yy424; }
        break;
      case 413: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy632 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 414: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy632 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 415: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 416: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 418: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy632 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy632); }
        break;
      case 420: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy632 = createFillNode(pCxt, yymsp[-1].minor.yy54, NULL); }
        break;
      case 421: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy632 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
        break;
      case 422: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy54 = FILL_MODE_NONE; }
        break;
      case 423: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy54 = FILL_MODE_PREV; }
        break;
      case 424: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy54 = FILL_MODE_NULL; }
        break;
      case 425: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy54 = FILL_MODE_LINEAR; }
        break;
      case 426: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy54 = FILL_MODE_NEXT; }
        break;
      case 429: /* group_by_list ::= expression */
{ yylhsminor.yy424 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 430: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 433: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy632 = addOrderByClause(pCxt, yymsp[-3].minor.yy632, yymsp[-2].minor.yy424);
                                                                                    yylhsminor.yy632 = addSlimitClause(pCxt, yylhsminor.yy632, yymsp[-1].minor.yy632);
                                                                                    yylhsminor.yy632 = addLimitClause(pCxt, yylhsminor.yy632, yymsp[0].minor.yy632);
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 435: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 436: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 438: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy632 = yymsp[-4].minor.yy632; }
  yy_destructor(yypParser,352,&yymsp[-3].minor);
  yy_destructor(yypParser,353,&yymsp[-2].minor);
  yy_destructor(yypParser,354,&yymsp[-1].minor);
        break;
      case 442: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 446: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==446);
{ yymsp[-1].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 443: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 447: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==447);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 444: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 448: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==448);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 449: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 453: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy632 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[-1].minor.yy578, yymsp[0].minor.yy217); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 454: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy578 = ORDER_ASC; }
        break;
      case 455: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy578 = ORDER_ASC; }
        break;
      case 456: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy578 = ORDER_DESC; }
        break;
      case 457: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy217 = NULL_ORDER_DEFAULT; }
        break;
      case 458: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_FIRST; }
        break;
      case 459: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
