# author : wenzhouwww
from util.log import *
from util.sql import *
from util.cases import *

class TDTestCase:
    def init(self, conn, logSql, replicaVar=1):
        self.replicaVar = int(replicaVar)
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), True)

    def prepare_data(self):

        tdSql.execute(f'''drop database if exists table_lastrow_2_2;''')
        tdSql.execute(f'''create database if not exists table_lastrow_2_2 keep 36500 ;''')
        tdSql.execute(f'''use table_lastrow_2_2;''')
        tdSql.execute(f'''create stable stable_1 (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);''')
        tdSql.execute(f'''create stable stable_2 (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);''')
        tdSql.execute(f'''create stable stable_null_data (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);''')
        tdSql.execute(f'''create stable stable_null_childtable (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);''')
        tdSql.execute(f'''create stable stable_null_data_insert_data (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);''')
        tdSql.execute(f'''create table stable_1_1 using stable_1 tags('stable_1_1', '-1018336694' , '1595508332262302224', '28072' , '-35' , 0 , 'binary1.MWLRCtBHUaCUgFSTdtBk' , 'nchar1.dALWGgKyWCbOuxCUbzKr' , '-5.335609', '48773689935.563004' ,'0') ;''')
        tdSql.execute(f'''create table stable_1_2 using stable_1 tags('stable_1_2', '785397064' , '-6316393479307224208', '-12059' , '-20' , 1 , 'binary1.laHjdQwAnHfxLDvYcBRX' , 'nchar1.xylcIZwLgJewVUUBDjkc' , '353778266298.739014', '-994383623.121693' , '1999-09-09 09:09:09.090') ;''')
        tdSql.execute(f'''create table stable_1_3 using stable_1 tags('stable_1_3', '-2147483647' , '-9223372036854775807' , '-32767' , '-127' , false , 'binary3' , 'nchar3nchar3' , '-3.3' , '-33.33' , '2099-09-09 09:09:09.090') ;''')
        tdSql.execute(f'''create table stable_1_4 using stable_1 tags('stable_1_4', '0' , '0' , '0' , '0' , 0 , '0' , '0' , '0' , '0' ,'0') ;''')
        tdSql.execute(f'''create table stable_1_5 using stable_1 tags('stable_1_5', '2129429608' , '2307167663134055915', '-30801' , '97' , 1 , 'binary1.xxBwoDsTKoIfHezkMCMK' , 'nchar1.IyVWFtMtpqxfvpJpbgQe' , '-0.988745', '804627.676066' ,'-811294702') ;''')
        tdSql.execute(f'''create table stable_1_6 using stable_1 tags('stable_1_6', '-418554527' , '7121649991943388108', '-17673' , '-32' , 1 , 'binary1.nqevHWrcyyicEQwayBtK' , 'nchar1.UzlaWBQIwovvojtniExg' , '63206.472351', '66.580164' ,'-2011047779') ;''')
        tdSql.execute(f'''create table stable_2_1 using stable_2 tags('stable_2_1', '-650310817' , '-6448202879686146556', '-4887' , '-49' , 1 , 'binary2.vxWkNcASTlgvrLxckVzo' , 'nchar2.IkwxYduQGOkmMYozJsGu' , '-5503502270.709900', '-193919.697976' ,'0') ;''')
        tdSql.execute(f'''create table stable_2_2 using stable_2 tags('stable_2_2' , '0' , '0' , '0' , '0' , 0 , '0' , '0' , '0' , '0' ,'0') ;''')
        tdSql.execute(f'''create table stable_2_3 using stable_2 tags('stable_2_3', '844729931' , '3743631577053724543', '-29079' , '-68' , 1 , 'binary2.zemsTeoWSPFIVFIJVgqg' , 'nchar2.zbPxIWIIvmmnSsdjdUgv' , '18949277.377942', '-160343395.575977' ,'2055943475') ;''')
        tdSql.execute(f'''create table stable_2_4 using stable_2 tags('stable_2_4', '630274019' , '4517699459805299748', '-10047' , '-66' , 1 , 'binary2.QAecEuLSbznsyExjWhWQ' , 'nchar2.KiKzPupgeBsBQCFpGMjf' , '93521718623175.000000', '5981.851300' ,'-1323235531') ;''')
        tdSql.execute(f'''create table stable_2_5 using stable_2 tags('stable_2_5', '-1888888729' , '-4964455964757350108', '21832' , '-102' , 1 , 'binary2.IYBWfiyETfYXlLmoHvCL' , 'nchar2.VNSfIvIrgAZQsYfrvGuW' , '-7938.194391', '8946996355046.539062' ,'-1075201653') ;''')
        tdSql.execute(f'''create table stable_2_6 using stable_2 tags('stable_2_6', '221977162' , '-4074099363599643838', '-15384' , '93' , 1 , 'binary2.IixhuAsSrChdQTizyBRi' , 'nchar2.XAECwFPOVvqbfAQnXFll' , '112970.139491', '-86723.729566' ,'124866521') ;''')
        tdSql.execute(f'''create table stable_null_data_1 using stable_null_data tags('stable_null_data_1', '0' , '0' , '0' , '0' , 0 , '0' , '0' , '0' , '0' ,'0') ;''')
        tdSql.execute(f'''create table stable_null_data_insert_data_1 using stable_null_data_insert_data tags('stable_null_data_insert_data_1', '0' , '0' , '0' , '0' , 0 , '0' , '0' , '0' , '0' ,'0') ;''')
        tdSql.execute(f'''create table regular_table_1                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;''')
        tdSql.execute(f'''create table regular_table_2                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;''')
        tdSql.execute(f'''create table regular_table_3                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;''')
        tdSql.execute(f'''create table regular_table_null                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630000000000, -618707591, -8247775922836565826, -5478, 118, 5.414333, 75.304275, 0, 'binary.mjCkHlPgXnuCpAFOIRiI', 'nchar.陕西省长春县涪城赵街S座 993438', 1630000000000) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630000000000, -679041833, 6481912273446973866, 7785, 25, 253.538943, -12801.160677, 0, 'binary.OIaLSSdTkyeghECZRlly', 'nchar.四川省长春县萧山黄街m座 950751', 1630000000000) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1629999999999, 1000633087, 4246783346267002529, 32349, 56, -38524798468.228600, 677.696961, 1, 'binary.tfdGRAJloMWlejFCvXGH', 'nchar.新疆维吾尔自治区彬县浔阳深圳路k座 106151', 1630000000000) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630000000000, 1519095863, 3730763636688762973, 32328, 18, 13261.792805, -23310331001.143700, 1, 'binary.YuznyMmpNmIBujYOnfBj', 'nchar.湖南省银川市蓟州沈阳街f座 828894', 1630000000000) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630000000001, -1721664965, -3230247488973407828, -22534, -78, -4615440117998.759766, 128542619.774818, 1, 'binary.VkIjDmJdfYRXCGOcoaUw', 'nchar.湖北省拉萨县吉区银川街p座 684472', 1630000000001) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630000000001, -457200104, -5211291163024696467, -16773, -94, -6983919702730.200195, -67714706.233835, 1, 'binary.LTmCJTcqnzIfNQYoRTPC', 'nchar.黑龙江省西宁市江北王路P座 603299', 1630000000001) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630000000000, 913998061, -3881184424925998682, 29221, -118, -7492895.381435, -119177303.116243, 0, 'binary.oryFxMGKONJblKZWJxLF', 'nchar.广东省荣市上街钟路A座 708810', 1630000000000) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630015000000, -1004099631, -2329741298995361936, -17228, 92, -7786612568.749220, 63297.402773, 0, 'binary.oIlAieuDxUnJAznSxgDa', 'nchar.陕西省呼和浩特县华龙马鞍山路B座 509550', 1630000000001) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630015000000, 1984250107, -733051146694989614, 25996, 7, 32391348.640906, 30496.996911, 0, 'binary.SjSkhuLmeqJhgvToyskb', 'nchar.广西壮族自治区武汉县梁平兰州街z座 108560', 1630000000001) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630014999999, 1167978495, 168911323243208687, 25054, 105, 9.297430, -74362.658908, 1, 'binary.gjlULgjKtTQMRsgDIVbu', 'nchar.陕西省合山市友好哈尔滨路y座 906640', 1630000000001) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630015000000, 2124176615, 3367944756720448423, 31669, 74, -40.578216, 3714810365386.549805, 1, 'binary.xzMdipXOFEkZkaqAnulR', 'nchar.台湾省洁市门头沟惠州街T座 814575', 1630000000001) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630015000001, -800594954, -6220928593410477008, -6436, -107, -379445813485.830017, 1817959.681926, 1, 'binary.fgQqvhJhqEAyqYcYCzop', 'nchar.江西省六安县蓟州长沙路K座 686835', 1630000000002) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630015000001, -1398934219, -5088222972686572580, -11996, -93, 737.964702, -702597046.276900, 1, 'binary.WqJNWJTeOypOEILqFfFM', 'nchar.福建省哈尔滨市合川李街A座 990061', 1630000000002) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630015000000, -1491848052, -3232978461444804772, 28885, 110, 68028.289282, -0.612906, 0, 'binary.qfQwRgWfrgQLefodbKQE', 'nchar.海南省汕尾市普陀刘街x座 901815', 1630000000001) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630030000000, -554992634, -8694605272129245647, -19744, -34, 371492.822008, 97594901899.304092, 0, 'binary.vATatWJTwyzWNENoWGqm', 'nchar.黑龙江省兴安盟市友好李路X座 412206', 1630000000002) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630030000000, 230798367, 4276367516153106032, 23696, -34, -2149198212.254210, 722029.566814, 0, 'binary.EZDyNTgJgCCPGkPuTwyr', 'nchar.辽宁省石家庄市高港广州路V座 518042', 1630000000002) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630029999999, 2093449032, 3029533084633134124, 17333, 74, 179560.971309, 5.196993, 1, 'binary.JYigiQaVrKTPLzQHXeDp', 'nchar.湖北省南昌县金平合山街g座 418389', 1630000000002) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630030000000, 2099331457, 3609885272656270889, 31314, 60, -8489143.581025, -214298.108651, 1, 'binary.ltSDheslsSNwSxfYxIwt', 'nchar.辽宁省深圳县翔安石家庄街c座 827189', 1630000000002) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630030000001, -1245000234, -1838653281383479618, -13572, -101, -20.386729, 41392371.908604, 1, 'binary.nqjueffbFvZcGQexkMuc', 'nchar.重庆市淮安市上街福州街F座 236907', 1630000000003) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630030000001, -1000510248, -8459051266344969043, -8477, -86, -6923089039562.599609, 7.587889, 1, 'binary.egZiyotIUjvmyEeabqWD', 'nchar.宁夏回族自治区银川县淄川辽阳路F座 365611', 1630000000003) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630030000000, 1641358132, 5291198999362916313, 1219, 43, 13391898193591.400391, -253345.858194, 0, 'binary.zowdfNbqLIBOvTqQmqVq', 'nchar.辽宁省大冶县永川济南街Z座 410021', 1630000000002) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630045000000, 1273633633, -7910396749266717868, -2883, -35, -88018.597889, 331.964131, 0, 'binary.HLOtPGQtEAfRTTNAVbnF', 'nchar.福建省桂珍县翔安周路s座 201916', 1630000000003) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630045000000, -292105648, -9216209950218616247, 17873, -40, 510.442902, 4914.654078, 0, 'binary.FZYRLYLrlaZdIBnbOvWI', 'nchar.安徽省北京县平山郑州路p座 162038', 1630000000003) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630044999999, 1985684265, 7812482934230300604, 10735, 2, 39668.546371, 3772288865301.229980, 1, 'binary.DQDjLSXXpYjXDnGzrDiB', 'nchar.福建省丽丽市大东石家庄路O座 638078', 1630000000003) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630045000000, 273025537, 6201710872284300698, 24247, 122, 34.519692, 3678779922.134800, 1, 'binary.kbpPYOgvAQcOBLFcuuZj', 'nchar.浙江省莹县吉区岳街N座 997620', 1630000000003) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630045000001, -755554172, -5922209280465971373, -16931, -1, -738590.998999, -213684725.699882, 1, 'binary.gGZITsRKKtOkkAZpwqFk', 'nchar.河南省石家庄市西夏施街d座 887826', 1630000000004) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630045000001, -1614464307, -1951583711943603971, -6, -26, 46698502859495.796875, -66331370.539177, 1, 'binary.anFFtpnYqkllelsTzUXp', 'nchar.重庆市长沙县丰都郑街v座 632337', 1630000000004) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630045000000, 1066735810, -1572767557463382095, -24233, -99, -8059716.727903, -44065130.621251, 0, 'binary.EHRUdvBpXXdxSfkPbHPY', 'nchar.贵州省桂兰市高坪广州街K座 807922', 1630000000003) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630060000000, 436440993, 4582366906832569569, 19691, -104, -770862234.875283, 67327.464546, 0, 'binary.rGBrQBwSJziIwOmEMtJD', 'nchar.黑龙江省通辽市高明张路I座 703149', 1630000000004) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630060000000, -875710377, -5188572182276438044, -19951, 75, -2.627015, -71356793.343289, 0, 'binary.xoMabkxpBOQvAWZlTVMz', 'nchar.贵州省汕尾县静安黄街M座 165440', 1630000000004) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630059999999, 1129217878, 8833855448102017424, 3948, 86, 1462546878675.199951, -9256879605.926800, 1, 'binary.pCnFTHmykgTwspRMSMDk', 'nchar.云南省西宁县合川苏街h座 357731', 1630000000004) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630060000000, 2091037114, 6355755798403937517, 32527, 22, 2.418504, 74.778674, 1, 'binary.yoobwWUyBSZuRZmlcWTL', 'nchar.天津市萍市大东姚街w座 255499', 1630000000004) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630060000001, -647490375, -2905281875821917763, -16147, -57, -8479790.621940, 5694596048115.910156, 1, 'binary.gqtxAiHhIoGKdGJgNhat', 'nchar.云南省齐齐哈尔市新城翟路J座 336359', 1630000000005) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630060000001, -1939480852, -8924947224421059592, -29393, -89, 4457679028853.139648, 3390867.192607, 1, 'binary.biEBPzDOrLOGitUZfDIy', 'nchar.新疆维吾尔自治区彬市南溪黄街i座 106358', 1630000000005) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630060000000, 760109584, 2794056460189383180, -17287, -72, -99807343228.163803, 1373392779.173220, 0, 'binary.xABwARkXCmOteoVJInrZ', 'nchar.吉林省芳县安次荆门路K座 396431', 1630000000004) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630075000000, -1866923177, -2210826056783865816, -26481, 25, -60150089285.989502, 7628.542314, 0, 'binary.rTYYBufHDmHMtGoZQOTT', 'nchar.宁夏回族自治区兵市孝南陈路x座 334815', 1630000000005) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630075000000, 2038781133, -328945288212162680, -28897, 95, 5608233.583575, -69.542113, 0, 'binary.JwNUFBltIXQKAdjZpTIn', 'nchar.河南省娟县南长吴路f座 790249', 1630000000005) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630074999999, 1145437501, 7925745151626620680, 4822, 91, -59887158.500668, -47581275646365.203125, 1, 'binary.DrUaLRxoRNzyNzXYUlRE', 'nchar.甘肃省南京市大东大冶街D座 872025', 1630000000005) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630075000000, 1789577030, 3132818518285337526, 26070, 65, 8974955.481672, 25.499355, 1, 'binary.VRegnoPEWKPRFsoYVtYC', 'nchar.贵州省东市东丽上海路s座 272562', 1630000000005) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630075000001, -1373109267, -5826806756838814238, -16841, -28, 51.267264, 48701588356.369003, 1, 'binary.WqMufKnCjgUuLBrWIgRT', 'nchar.安徽省玲市西夏海口街o座 109427', 1630000000006) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630075000001, -813108784, -1617673275161393067, -1248, -69, -972415684.192217, -1.653864, 1, 'binary.kmjtLhPVdLESTsOjNOxB', 'nchar.台湾省潮州市孝南廖街t座 266427', 1630000000006) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630075000000, -1223568312, -8946838664732429923, -4198, -109, 62156997799.337097, 5905968167.585610, 0, 'binary.gPXEGOdtZVrGqPNRAInE', 'nchar.西藏自治区齐齐哈尔市清城郑州街w座 590784', 1630000000005) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630090000000, -884439870, 1248874482756813386, -11000, 61, 80395.998486, -719886040980.203003, 0, 'binary.MUrOdVZgtgPWPXbIcstW', 'nchar.江苏省天津县龙潭贵阳路s座 612000', 1630000000006) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630090000000, 22358632, 696083452197273333, -13257, -41, 56423240.636894, 67488.334223, 0, 'binary.HEsJVMnaOFobHNDaoRtn', 'nchar.贵州省杭州县沈河陆路s座 645540', 1630000000006) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630089999999, 1652733516, 2575789832408445556, 16457, 72, -9677288.455314, -634151591.251647, 1, 'binary.kcMLZfZtpBrgBBeZWbaO', 'nchar.青海省汕尾市长寿周街N座 774464', 1630000000006) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630090000000, 1670284035, 7846771393632678538, 24419, 81, 256.686378, -932250077361.723022, 1, 'binary.dcqObzxzMWdcGMorJEdo', 'nchar.浙江省荣县平山王路W座 892684', 1630000000006) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630090000001, -1239207401, -2017719648880935228, -9628, -15, -77811.715389, -347.862346, 1, 'binary.arpuZMBhyXPuWeNDqoQg', 'nchar.上海市武汉县朝阳佛山街r座 687990', 1630000000007) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630090000001, -429906324, -294441740565391101, -18570, -27, -91849065.920391, -9504277.384224, 1, 'binary.YzliXowrLkmoHdpasClN', 'nchar.广东省静县新城王街H座 307037', 1630000000007) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630090000000, 1647824018, -1290146600224131452, -26320, -17, -97472611955.200394, 623.599606, 0, 'binary.eIXSvTrGfgIWKUgEQIKK', 'nchar.山西省俊县新城许路L座 732295', 1630000000006) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630105000000, 897426731, -6157764764029970873, 13753, 53, -76610.177184, 784852116.102444, 0, 'binary.oThZwmCKADWhpHiBQMEB', 'nchar.安徽省雷县高明六盘水街s座 104130', 1630000000007) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630105000000, 1727787759, 3219114917075431149, -30010, 105, -29098130696901.199219, 2716.301364, 0, 'binary.KpchCpVHGKjREJMxRCYb', 'nchar.河北省辽阳市南长岑街l座 554159', 1630000000007) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630104999999, 964911890, 9104291220948875270, 2620, 93, 6348.912976, -5.436949, 1, 'binary.enOSjjsQzNbvDdFfEKhA', 'nchar.西藏自治区桂芝县山亭刘路N座 825972', 1630000000007) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630105000000, 1265975391, 1097514590897652008, 30907, 127, 6962290728.631910, 4234.969142, 1, 'binary.IDDEVFUXulGKPGUxgwoa', 'nchar.贵州省龙市友好哈尔滨街V座 614938', 1630000000007) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630105000001, -997687142, -3588569170127119022, -31895, -11, 681764.467420, -927.233192, 1, 'binary.qAYrbGModOeljwoNdOSK', 'nchar.内蒙古自治区桂英县清城何街e座 656693', 1630000000008) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630105000001, -1838171592, -2931035207249690385, -27947, -4, -0.864426, -31972996.517570, 1, 'binary.xmGbCIlRspBnDeHNjzGO', 'nchar.香港特别行政区辽阳县朝阳黄路J座 742465', 1630000000008) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630105000000, -463217897, -8041553223283381090, -9791, 67, -69685155628.862000, 251717731390.667999, 0, 'binary.RvKNPCRWhwpJzghpxMnY', 'nchar.山东省宁县大兴王街f座 954429', 1630000000007) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630120000000, -54069770, 3955990383518016848, 8494, 120, 51149.933011, 1349638022797.659912, 0, 'binary.ctqJUvXzcLsBTGXFePLO', 'nchar.辽宁省超市六枝特马鞍山街F座 798879', 1630000000008) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630120000000, -403363944, -2394897603233419155, 16427, 48, 74402.339292, -52.539883, 0, 'binary.kobpHICjpqBLcDIEHpts', 'nchar.海南省琳县高明沈阳路e座 854884', 1630000000008) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630119999999, 806349342, 8818007624619329018, 11587, 27, 24820988.463016, -1.378348, 1, 'binary.SPIvOBZxamwoTLUyeDec', 'nchar.上海市玉梅县六枝特王路F座 154214', 1630000000008) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630120000000, 1843801013, 8068282721613219948, 23265, 89, 20575797079906.000000, 7.906923, 1, 'binary.smCqwmyottgAmLVxlXfX', 'nchar.内蒙古自治区杭州县南湖上海街P座 763569', 1630000000008) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630120000001, -1431341222, -5831324648859520070, -8527, -66, 507444690740.578003, 943376.611667, 1, 'binary.nZHlAmwbcUYtOTsAxArC', 'nchar.广西壮族自治区武汉市海陵施路Z座 727105', 1630000000009) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630120000001, -781555629, -3682028760781093775, -1217, -88, 967.988362, -998747442791.562012, 1, 'binary.CMDWBFfYnlYEdTeiqtsW', 'nchar.云南省敏县白云柳州路Z座 839560', 1630000000009) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630120000000, -1229205179, 1269213658170093198, 15696, -110, 8232823752181.839844, 36569.580002, 0, 'binary.voGRWKSImlHklgUXdYMu', 'nchar.新疆维吾尔自治区红霞市南湖成都路L座 163545', 1630000000008) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630135000000, 801515319, -3418248827901909079, 26288, 51, -534837.671505, 15.631926, 0, 'binary.DnbpUExxknvANXEEsaWR', 'nchar.重庆市旭市清浦冯路W座 960766', 1630000000009) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630135000000, 1651702520, 7472881261358437437, 27039, 39, -901147931976.785034, -21.400440, 0, 'binary.PDCCWnKlBJjPqTBmUhYK', 'nchar.广西壮族自治区秀英县秀英惠州路c座 534464', 1630000000009) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630134999999, 1705176915, 3853689828781845374, 27488, 40, 8339786734.762860, 74741492928.878296, 1, 'binary.jUuMQjVuORGeBYLOtCvN', 'nchar.四川省飞县海陵林路s座 610723', 1630000000009) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630135000000, 1401375995, 4401644438738533904, 10408, 76, -65049698292.958000, 762130648498.933960, 1, 'binary.NgPdruMUwoLdCxyEbNqw', 'nchar.甘肃省长春市南溪张街Q座 680073', 1630000000009) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630135000001, -2067806949, -5140997933871627569, -3032, -3, -771419731758.264038, 30386355.304924, 1, 'binary.XlCFISTlcLIRsxjboWHn', 'nchar.台湾省六盘水县清浦成都街a座 796270', 1630000000010) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630135000001, -1774018458, -2530948670547381542, -23399, -94, -495376178.216937, 151170.247760, 1, 'binary.TnrFRvylqBaNDthXRBAm', 'nchar.山西省帆县清浦昆明街Q座 225961', 1630000000010) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630135000000, -1363931402, 5604209803537258593, -18300, -23, 790034130.791400, 9237371157.649290, 0, 'binary.gyQzvuCzIfMlTIPPFNsH', 'nchar.广西壮族自治区淑珍市徐汇包路e座 156670', 1630000000009) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630150000000, -1894195697, -5734755902035702132, -15870, 111, -2670.233773, -4237.280417, 0, 'binary.UorBnZYRMylozHQezSJY', 'nchar.北京市英市清河张街N座 217253', 1630000000010) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630150000000, 745446575, -9002015868827109100, 7664, 112, -360706186.393129, 47605535552382.398438, 0, 'binary.FZNKeCfgQVTcZyqRNJuK', 'nchar.贵州省桂芳县怀柔天津街b座 347544', 1630000000010) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630149999999, 672434773, 9109650904011996741, 14686, 14, -85079.408071, 86.251927, 1, 'binary.XKWsToLeAsNVsIygACBb', 'nchar.贵州省广州市海港长沙街d座 904810', 1630000000010) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630150000000, 1515726636, 8521257827234172880, 11241, 103, -10.526128, -45196916520756.703125, 1, 'binary.zcHOLLudfLMvmIiXrANq', 'nchar.青海省六安市新城哈尔滨路Z座 312342', 1630000000010) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630150000001, -1923997635, -1295412466812568520, -20900, -107, 86532721.258284, 65558167665.583397, 1, 'binary.zNkNRRNyFRDVubonqLSh', 'nchar.广东省艳市东丽东莞路X座 591920', 1630000000011) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630150000001, -1357505482, -7556497983653555349, -27964, -5, 254673.529731, -273710012885.143005, 1, 'binary.oDZRgFAkFNMiHLGdpWcM', 'nchar.内蒙古自治区太原县秀英吴街F座 707601', 1630000000011) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630150000000, 720531993, -6639843123954951373, 1904, 87, 90228483.253351, 671689.823567, 0, 'binary.pbWPxvdZNrUoUOjzRJiX', 'nchar.湖北省柳市合川台北街k座 351073', 1630000000010) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630165000000, -1222920932, 8032055023952251119, -10742, -10, -567677.518580, -365410143.799096, 0, 'binary.gSPyErqDINWrLLVhCvup', 'nchar.辽宁省慧县牧野沈阳路d座 158793', 1630000000011) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630165000000, 414746648, 5927295586580216537, 31761, -42, 29.776511, -773061167437.739990, 0, 'binary.clWyILBusmbzejzbBoFT', 'nchar.福建省雷县东城曾路t座 587170', 1630000000011) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630164999999, 824419604, 891106057873489263, 23278, 95, 407384.105632, -35575.873087, 1, 'binary.MNQmhqizvbnJgkkIQqJe', 'nchar.广东省郑州市江北王路P座 783592', 1630000000011) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630165000000, 1281221057, 7024877965980246423, 27117, 31, -310144.477215, 7651054.553459, 1, 'binary.glajyvvlfYaEeVkkGCkB', 'nchar.西藏自治区博县黄浦沈阳街J座 833215', 1630000000011) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630165000001, -1830990548, -4649870365451699133, -7796, -55, -7445.199016, 5969245.537249, 1, 'binary.acIrBxurCVUcZrlhKNWy', 'nchar.北京市雪市城北佛山街L座 344309', 1630000000012) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630165000001, -156703760, -5651707522314260232, -20357, -53, -48419.774656, -412073702153.369995, 1, 'binary.RalpwNQKJazBBUIsHJxe', 'nchar.辽宁省阜新市大东郑州街k座 364193', 1630000000012) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630165000000, 862504464, -5500398940730781742, -14444, -90, 83.855205, -42218010095700.703125, 0, 'binary.TDihZaaECjQhZSuXOJkw', 'nchar.台湾省香港县滨城丁路O座 978512', 1630000000011) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630180000000, 667837391, -3891675097346789325, -27238, -120, 1.955652, 9.112019, 0, 'binary.JzwDaPxfqmOCGLPvyrjl', 'nchar.湖北省合肥市朝阳贵阳路w座 542472', 1630000000012) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630180000000, -1060826174, 4656485123040609725, -2306, -49, -31070344.608357, 32855.487468, 0, 'binary.HuQooyRdCtqfxpfenEKD', 'nchar.福建省沈阳县门头沟合山街M座 860092', 1630000000012) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630179999999, 95309922, 7708532961668715531, 4871, 87, -2493.696406, -305230557.440988, 1, 'binary.sDzjVbzXXlrItKczJmNd', 'nchar.四川省彬市高明潜江街t座 525852', 1630000000012) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630180000000, 1834883689, 9087266843320529269, 10482, 90, 7620830515.391810, -42.560665, 1, 'binary.UNyjzeJnXfRpfYwqnoiq', 'nchar.宁夏回族自治区天津县门头沟韩街T座 460087', 1630000000012) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630180000001, -426435327, -3062037029747393786, -9095, -58, 3445.234181, -558141651179.500000, 1, 'binary.PPFhdHAqUnaKoAEmHsdU', 'nchar.湖南省霞市南湖石家庄街t座 857415', 1630000000013) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630180000001, -1181075026, -3180887222641598399, -31207, -111, -1782467190.826900, 5.516558, 1, 'binary.TGHKOSbljBlliohlXOWY', 'nchar.北京市华县南溪兰州路S座 340198', 1630000000013) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630180000000, -1179373775, -2798016462115894947, 13261, 81, -6.728964, -772564358011.891968, 0, 'binary.YugzktgmcxvJhQUFlTJx', 'nchar.重庆市大冶县新城蔡街a座 475876', 1630000000012) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630195000000, -1753829875, 9153441825434214315, 27033, 122, -736.689121, -92.766550, 0, 'binary.pUBZlnzauIFGdWqodaie', 'nchar.新疆维吾尔自治区海燕市高港刘路a座 320202', 1630000000013) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630195000000, 209604377, -5203497748513382294, 11811, 104, 6261702331.471590, 912558484347.494019, 0, 'binary.wZJaPJrGTgLaarzVLUSN', 'nchar.香港特别行政区武汉市海港长沙路y座 885641', 1630000000013) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630194999999, 927761777, 2507975814406403776, 19213, 90, -7617794.842135, -454202300.875154, 1, 'binary.icqbMuuToUNxqWXUeRPk', 'nchar.广东省西宁市丰都李路q座 597739', 1630000000013) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630195000000, 25571599, 9030074847417015485, 31156, 118, -75.396818, 48452341.676426, 1, 'binary.NqBtvtMnkQndvuYapikY', 'nchar.香港特别行政区南宁市长寿甘路u座 453721', 1630000000013) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630195000001, -428129781, -5700535713003042271, -10481, -28, 23726711.628846, -28428638085.690300, 1, 'binary.pCEqFOIEkNkTyynifvvP', 'nchar.西藏自治区张家港市上街阜新街O座 871243', 1630000000014) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630195000001, -848598147, -5339257050356453975, -18995, -126, -97029.616600, -142.756397, 1, 'binary.fnhJdkzuvTlaKyHNNFax', 'nchar.陕西省桂芝市永川马鞍山街k座 606648', 1630000000014) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630195000000, -1235643681, 7084534800526629066, -24801, 79, -145779524595.869995, 94.711588, 0, 'binary.zGptPlBGCsdKPNcWBTWB', 'nchar.湖南省莉市璧山王街S座 444986', 1630000000013) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630210000000, -257925835, 4113510788745659274, -7451, 82, -73680370.344940, 3976133.807981, 0, 'binary.RMHnWOvHGDkBnmnhajqK', 'nchar.甘肃省昆明县锡山东莞路f座 143739', 1630000000014) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630210000000, -441472850, 6731053996474537256, 25225, 88, 40422214874.591599, 23965.803627, 0, 'binary.EHzCItPZeIiFrqnZlZFx', 'nchar.广西壮族自治区丹丹市蓟州李街A座 716733', 1630000000014) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630209999999, 2038647205, 1189537624585781694, 7402, 77, -25786637314.127998, -8273884501116.790039, 1, 'binary.lQDfBPFCwRhZWQDOueFe', 'nchar.四川省南京县大东济南路X座 802062', 1630000000014) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630210000000, 479757528, 6749026723270202494, 13649, 38, -11785225102.777700, 474555902413.706970, 1, 'binary.gZeGdOiDSRQDrrutAJpP', 'nchar.吉林省桂英县门头沟巢湖路W座 373162', 1630000000014) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630210000001, -973859244, -7125967416228878252, -23978, -103, 9.174338, -9074.207791, 1, 'binary.spVrNBOtDUJKWtVfGkIs', 'nchar.云南省重庆县秀英张街w座 814757', 1630000000015) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630210000001, -1099659644, -5069485856549254463, -7663, -21, -77435917488084.906250, 6157980965629.839844, 1, 'binary.neMplXKNDoTZmfaWuQIv', 'nchar.海南省嘉禾县翔安上海街P座 777755', 1630000000015) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630210000000, 1262139840, -4971682912616802373, 32119, 52, -763639.969220, 4466.886880, 0, 'binary.BedkvagFaejmBsJjHkQk', 'nchar.上海市玉英县东丽辽阳街q座 311759', 1630000000014) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630225000000, 722222291, 150763568244594756, -22749, -105, 69152723689.975998, -5072701672145.320312, 0, 'binary.ZIoGBLOEmmhXJZvIxuMC', 'nchar.陕西省博市永川西安街H座 219040', 1630000000015) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630225000000, 591411352, 513820708206298423, -29944, 120, -7450006471858.410156, 28263898844.649300, 0, 'binary.OOYGFQjeyKSgnzgKjpfl', 'nchar.甘肃省南昌县龙潭张街q座 299631', 1630000000015) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630224999999, 1729527872, 858836292464061984, 26768, 61, 8045315.625506, 463874.574633, 1, 'binary.qPTkezKHzqZjenBLvfin', 'nchar.新疆维吾尔自治区汕尾市海陵齐齐哈尔街e座 364606', 1630000000015) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630225000000, 1643785412, 3613608845439721039, 2830, 6, 20141358.132227, -10515528.243744, 1, 'binary.OHifAxUhqgMCYnGFqNtd', 'nchar.福建省惠州县秀英胡路z座 617394', 1630000000015) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630225000001, -1458828697, -6767897245471753991, -5337, -110, 26.347447, -2088415765277.760010, 1, 'binary.nKdzFeMTCkibzMHIBYWp', 'nchar.北京市武汉县海陵沈阳街j座 275130', 1630000000016) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630225000001, -847285817, -4303648033804475519, -29035, -126, 46793.514585, -1507581042167.719971, 1, 'binary.xMmlUvSqOUKadNTjwVbR', 'nchar.湖南省琳市沙湾张路b座 512648', 1630000000016) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630225000000, -978219428, -2955103196936757566, 30178, 32, 1631732545944.110107, -393.171524, 0, 'binary.seXNZyWFCBIKtovhPcPH', 'nchar.江苏省慧县上街宜都路e座 880474', 1630000000015) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630240000000, -1972126026, -7574542606285760315, 28119, 80, -529670.435949, -24383.929895, 0, 'binary.xhubWGtXmHdWMLKNToaW', 'nchar.甘肃省桂英县萧山邱街M座 532318', 1630000000016) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630240000000, -1796898694, -764951623915204003, -15993, 27, 4657602445.591260, 4586648.134693, 0, 'binary.TEhGCTdxkZNmFnzFtObM', 'nchar.甘肃省东县徐汇昆明街P座 260669', 1630000000016) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630239999999, 357526998, 1276204587787008311, 29238, 42, -5156150330.293080, 978546.269907, 1, 'binary.cTaghgmdTbnmdzLMfprn', 'nchar.青海省齐齐哈尔市海港汕尾街S座 223338', 1630000000016) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630240000000, 719321885, 6211071132372294861, 26203, 4, 97973007280575.000000, 4917172790.726020, 1, 'binary.UrLJfXtkYMRsRzBKupLN', 'nchar.安徽省永安市城东六盘水街x座 616834', 1630000000016) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630240000001, -131148573, -7418806044708315561, -24075, -95, -939211006187.709961, -62673687782.380798, 1, 'binary.ioRcxRqlBPWWUslmpXot', 'nchar.河南省瑞市崇文北京路v座 915899', 1630000000017) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630240000001, -926921347, -7119582382885284043, -22204, -33, -843815.847483, -733624.538013, 1, 'binary.CDgPdtLeDlVKfKVxhxpv', 'nchar.浙江省磊县城东阜新路q座 382954', 1630000000017) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630240000000, -256678368, -5278293054518319714, -19250, 63, 76804691.667068, 56757245265557.898438, 0, 'binary.mWDyzgzWsYmwcclLnyKM', 'nchar.新疆维吾尔自治区宁德县平山武路C座 669860', 1630000000016) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630255000000, 105950788, 478455145201382299, 21202, 49, -492280820.857835, -59846.285166, 0, 'binary.bHXHFuvyzSODEypLHuvb', 'nchar.天津市惠州县兴山贵阳路q座 575823', 1630000000017) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630255000000, -1188272652, 3059329495007474279, 15772, 52, 97.388100, -179.239522, 0, 'binary.NcbSJdYAICljVIDdqLDs', 'nchar.河北省凤英市东丽曹路x座 451405', 1630000000017) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630254999999, 1374178023, 3719932182860509152, 15558, 26, -48778273445.594002, -4313900.906134, 1, 'binary.xrqMfwkMMYQAjZjHywqq', 'nchar.江西省广州市南湖汕尾街p座 889246', 1630000000017) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630255000000, 1682040807, 8317842464181056096, 1900, 87, 415547443.281930, 6910478.101601, 1, 'binary.CgZXfDNNfsnrMNDLhaFk', 'nchar.河南省海口县沈河长沙街D座 269675', 1630000000017) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630255000001, -1655416898, -6254408814439814177, -32731, -80, -926982830.629323, -59.656488, 1, 'binary.oerLzcmyCiDByTBvtqJC', 'nchar.贵州省关岭县涪城侯路y座 962245', 1630000000018) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630255000001, -1635083194, -8974109706346763955, -2735, -50, 3293.363373, 18681627453476.000000, 1, 'binary.GSVbHmgpelzbMoHbLPcC', 'nchar.内蒙古自治区晶县清城拉萨路X座 358275', 1630000000018) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630255000000, 1313669852, 6945103232995327793, 30581, 16, 85564937456162.203125, -77542.918719, 0, 'binary.XFHqNNaMVizYnZQgNXPC', 'nchar.新疆维吾尔自治区贵阳市崇文宁德街i座 343604', 1630000000017) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630270000000, 917363192, -2865889321649137964, 23695, 91, 5280836.562854, -3783947630346.270020, 0, 'binary.MNMoJuMUQGuncloQVsno', 'nchar.陕西省福州市吉区苏路s座 468218', 1630000000018) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630270000000, -2122120908, -2872995800597882541, 31983, 71, 6875560.276574, 5.493633, 0, 'binary.EPzGVtLuyIzhTxgbjEWF', 'nchar.山西省哈尔滨县浔阳蒲街L座 163917', 1630000000018) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630269999999, 795882903, 3280694140326918125, 20811, 108, 49.168498, 7651.321312, 1, 'binary.UikJWqrxtOeMoYKjVtNm', 'nchar.广东省桂芳县安次嘉禾街r座 604207', 1630000000018) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630270000000, 2120566264, 4722887562205021135, 28462, 1, 129.403026, 81642332991.346405, 1, 'binary.rFxHYhBonyaZGENLSiup', 'nchar.新疆维吾尔自治区建军市龙潭陈路N座 391792', 1630000000018) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630270000001, -426986357, -7028311428629812651, -4827, -64, -7.591949, -8288.667569, 1, 'binary.MTcHiKSZLMGfDPYnynMD', 'nchar.山东省辛集县东城汕尾路Y座 327226', 1630000000019) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630270000001, -1319979040, -1611680110566277558, -12591, -102, -0.766067, -9.985580, 1, 'binary.aSzFqnlqfbvcqqslssAX', 'nchar.北京市关岭县南长王路s座 855187', 1630000000019) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630270000000, -655731150, 952225036593449539, -12275, 62, 988070261.618785, 110828.718042, 0, 'binary.pwXbqQpeGiCAxVQjBByd', 'nchar.陕西省长沙县江北汕尾路F座 416889', 1630000000018) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630285000000, 1662865387, 6549115606741837921, 31658, -40, 6050748.290946, 850563444268.306030, 0, 'binary.PqxloDzsqJMLqHZQWCjg', 'nchar.上海市兰英市南湖乌鲁木齐路K座 550844', 1630000000019) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630285000000, 1925250353, -2675198429577937161, -954, 26, 42621483170.815201, -2.407178, 0, 'binary.UQoLagBLIXklApVNNHjj', 'nchar.福建省超县淄川大冶街R座 827801', 1630000000019) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630284999999, 1995360198, 5210480004052888682, 18624, 3, 97472570479742.500000, 1260.797791, 1, 'binary.ItgagWrnvwaUBcGaMaeN', 'nchar.广西壮族自治区重庆县平山香港路V座 260105', 1630000000019) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630285000000, 1294452263, 5523637851428821304, 15478, 5, 9507059.611693, 71182.768111, 1, 'binary.zGOYZBGdKbprwpIBOAyf', 'nchar.吉林省静县房山太原街o座 903227', 1630000000019) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630285000001, -1089491236, -4124928499125874309, -26711, -91, 102.262755, -86354.456039, 1, 'binary.wIAlEZNaSWVRvmnECAvO', 'nchar.浙江省梅县孝南广州街r座 602833', 1630000000020) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630285000001, -1857132633, -3826380662652726191, -2637, -78, -5244683893811.500000, 28720333520.104401, 1, 'binary.aCSuXOyNceiyMGbrnKiN', 'nchar.辽宁省海口市城东谌街E座 102059', 1630000000020) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630285000000, 1378099044, 2585214152437420786, 15693, -37, 9876.538042, -735632586.279405, 0, 'binary.SafiqluCtQtykHfilDhK', 'nchar.北京市雪市黄浦王路x座 719370', 1630000000019) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630300000000, 1474375413, 5114018721557230309, 17508, -51, 19062832.997828, -2871763657.353070, 0, 'binary.tQXLaCZMUMopSlkQosvw', 'nchar.甘肃省齐齐哈尔市花溪合山路F座 429081', 1630000000020) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630300000000, -388377907, -3327065272167311555, -118, 78, 891.667968, -939976.640106, 0, 'binary.vDLERQspegLuLpwaUwzM', 'nchar.安徽省潜江市南溪王街H座 114897', 1630000000020) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630299999999, 1778777098, 1247965499115398806, 31082, 36, -34708.444580, -9074056.186352, 1, 'binary.sSRJTkOuBEsIDUBYnvLI', 'nchar.重庆市倩市沈北新拉萨街s座 784670', 1630000000020) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630300000000, 1445490460, 8880599911239061729, 24463, 25, -3.382105, -1781392.553877, 1, 'binary.aoTqpxHvRtaSZcskkkvh', 'nchar.天津市北镇市牧野徐路j座 335208', 1630000000020) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630300000001, -414780851, -3272216576746070612, -22655, -77, 60986281647372.203125, 8206.582673, 1, 'binary.BYPTbfwFwATchckdDRGY', 'nchar.澳门特别行政区瑞市白云沈阳街D座 317572', 1630000000021) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630300000001, -1100845103, -4359114771451299690, -19221, -72, -454991497.458531, 66488519526.609200, 1, 'binary.IAUPjYJLQVMOrfjNhEGW', 'nchar.贵州省柳市丰都合山路I座 879430', 1630000000021) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630300000000, -1344260637, -2327749124997496795, 8396, 9, 53600362.915844, 39096334.438932, 0, 'binary.MCcnFYqPmshweRolVKXy', 'nchar.福建省辽阳市黄浦武汉路Z座 588915', 1630000000020) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630315000000, -355362703, -1297695182610353342, -9770, -89, 952785.346586, -74060980932193.796875, 0, 'binary.oxSCvbpFwbexlztlNbov', 'nchar.江西省阳县徐汇孙街A座 417152', 1630000000021) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630315000000, -1228614638, -3900819433463392818, -17590, -11, 8486255712070.299805, 776309237079.099976, 0, 'binary.lCmzbzWrnzVGWTlKKcLz', 'nchar.江西省健市花溪齐齐哈尔路s座 401365', 1630000000021) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630314999999, 2119897062, 705747859773422308, 11407, 81, -7145565.865688, -262229423.217684, 1, 'binary.eEvZPvUuQslbYxeHtVwF', 'nchar.山西省马鞍山县兴山台北街K座 317962', 1630000000021) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630315000000, 1675027583, 7700778986059081977, 16174, 9, -665864335638.520020, 71582.521862, 1, 'binary.tKmhWfIgqpVzDnSlVNyX', 'nchar.澳门特别行政区银川县高港侯路B座 867370', 1630000000021) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630315000001, -63872001, -6930483055721144761, -55, -27, -647803039.367343, 2303820.355916, 1, 'binary.cMZeLPHbvchDdpONluWD', 'nchar.海南省长沙县浔阳俞路y座 710843', 1630000000022) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630315000001, -550949355, -2196304875670875984, -11885, -39, -6711213741.192790, 743976.503579, 1, 'binary.ZjvtDrDegMEemNdVPYWI', 'nchar.江苏省丽华市东丽林路c座 701423', 1630000000022) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630315000000, -638988531, -238160149511091433, 5704, -64, -8.456931, 122326752.221053, 0, 'binary.bOAzwJsCnDilLpivHhcE', 'nchar.福建省台北县新城佛山街W座 190141', 1630000000021) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630330000000, -626643923, -2019791703137966083, 32109, -84, 3416720.968494, 9357038.426241, 0, 'binary.BaFBcjklAnYcYwGxAqoq', 'nchar.吉林省武汉县朝阳宜都街u座 246031', 1630000000022) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630330000000, 1744535925, -781319618567345160, 25699, 25, 5357.659882, -618.983367, 0, 'binary.VPobijbSHTufuAsIpKoJ', 'nchar.吉林省建华市城北刘路m座 189127', 1630000000022) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630329999999, 880112073, 3294754321072095965, 6900, 77, -89650901.379152, -40.193724, 1, 'binary.slgqehRyEWrrSqbAYVJh', 'nchar.甘肃省佛山县吉区吴路i座 371158', 1630000000022) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630330000000, 185074156, 4989180079312042024, 29358, 109, 553959035.299975, -336.524434, 1, 'binary.gsSAVskcQYNhhgdMqRao', 'nchar.内蒙古自治区海门市新城许路M座 262464', 1630000000022) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630330000001, -1466263570, -2228588793836525866, -21221, -43, -87005519974.974106, -660.194761, 1, 'binary.bxpguIjMdJUkxwsOGQEq', 'nchar.新疆维吾尔自治区杨县徐汇福州街W座 871563', 1630000000023) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630330000001, -1645451433, -4401356942676794117, -28334, -111, 279.991987, 22516.349037, 1, 'binary.dfdHQJlJuaDksxoabJoB', 'nchar.西藏自治区太原县涪城哈尔滨街p座 883295', 1630000000023) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630330000000, 2032301580, 4408736721579229542, -1683, -10, -14742.318595, -7092296.586329, 0, 'binary.GExwHTtWGjhZjTEeFYiG', 'nchar.江苏省大冶市闵行高街t座 870548', 1630000000022) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630345000000, -2137144022, 4079790010886186881, 25710, 117, -4064381240984.290039, 7015370675970.000000, 0, 'binary.CVqxsKDzVLudZenizkMH', 'nchar.澳门特别行政区广州县牧野北京街x座 612318', 1630000000023) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630345000000, 933500773, -9037818060698530179, -29395, 110, -635450613.922866, -7403.402429, 0, 'binary.BAfDibZjCIxGGNhZPzdE', 'nchar.天津市玉梅市六枝特曹街z座 306379', 1630000000023) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630344999999, 1707978124, 7108213046724490283, 23442, 53, -1690092798852.899902, -77.732195, 1, 'binary.CjoXkwnzCpbREZGghsfa', 'nchar.天津市俊市南长成都街Z座 386069', 1630000000023) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630345000000, 638219332, 7562431303377412667, 16354, 108, -1426154.974943, -5203.623256, 1, 'binary.YWcLHHceXXwuYatdWqpB', 'nchar.海南省武汉市闵行佛山路i座 350356', 1630000000023) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630345000001, -694792584, -5451159991441438649, -27358, -63, -421814477.346397, 658.908206, 1, 'binary.RjeNtbCwKmVzuSEznMIP', 'nchar.青海省兴城县双滦嘉禾街J座 854125', 1630000000024) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630345000001, -1486705498, -4529672645278837682, -21086, -87, 0.969525, -88911627001.666107, 1, 'binary.lFWwkNVbMUovcuYFIddp', 'nchar.澳门特别行政区拉萨市和平合山街j座 616189', 1630000000024) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630345000000, 1470276506, -7928540339509515647, -16251, -106, -75636523821237.203125, 1951788289389.639893, 0, 'binary.gAaAcTqtqUaUtILxCARx', 'nchar.广东省嘉禾县清河六盘水街k座 243900', 1630000000023) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630360000000, 1152276268, -8156217200537467815, 19660, 12, 28355311.730820, 6713567748470.700195, 0, 'binary.bmGZNDQVyGtLdMWCUUPh', 'nchar.云南省杰县南长兴城街P座 252275', 1630000000024) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630360000000, -504752588, 1971807127747770396, 27445, 121, -8539663.125419, 54448077.614627, 0, 'binary.cuEEkfEDPsfuHYlKnDOH', 'nchar.西藏自治区坤县金平澳门路Y座 688701', 1630000000024) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630359999999, 855880887, 4257747801443019050, 4002, 59, -651877334084.171021, -40661.869299, 1, 'binary.ZOOiXFRmbNwocDEGjyPI', 'nchar.山西省香港县沈河汕尾街w座 530063', 1630000000024) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630360000000, 24228908, 7366685839096261214, 24706, 108, -2895.104902, -690789994021.112061, 1, 'binary.WoiDFgqNXTSOSSqvghbK', 'nchar.香港特别行政区哈尔滨县萧山重庆路S座 626140', 1630000000024) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630360000001, -1979347419, -8086150063002929949, -31773, -59, -6758.131288, 67.389494, 1, 'binary.BdPhqWnyifozXNBeGuOa', 'nchar.吉林省重庆县东丽齐齐哈尔路T座 928550', 1630000000025) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630360000001, -796374629, -6586675874501163952, -28989, -41, 64993999.806191, -8554109097.403460, 1, 'binary.AjiqARctYieemihXJRgw', 'nchar.广东省嘉禾县房山李街d座 910194', 1630000000025) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630360000000, -2078983709, -5723824485424673203, -23688, -93, 7495606593.360470, 264203417504.108002, 0, 'binary.LvbrLfgWtSAHPeWnNyif', 'nchar.重庆市峰县华龙廉街i座 702040', 1630000000024) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630375000000, -2135854035, 3495311946004641041, -8066, -32, 794122420146.477051, 54762.831473, 0, 'binary.iKNdSNvujYgDbKTFUoWj', 'nchar.湖北省秀珍市东丽佛山街a座 727430', 1630000000025) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630375000000, 195905849, -4893460212808423867, 27472, -20, -60.648891, 9236.500458, 0, 'binary.fxBWbjZbbgBzyftfClnE', 'nchar.云南省春梅市普陀合山街d座 593581', 1630000000025) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630374999999, 1222537098, 2598300007761422980, 13555, 60, -21237649962112.101562, 56425481952996.296875, 1, 'binary.nljxYbIMonhZyPfyRWYU', 'nchar.河北省澳门市大兴贵阳街U座 357038', 1630000000025) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630375000000, 1255129224, 3767117331869115149, 20415, 43, -96039955.962346, -3228760442.535840, 1, 'binary.VjBuTRZJfGBAsllbmlCm', 'nchar.上海市潮州县长寿大冶街V座 568435', 1630000000025) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630375000001, -451008604, -9013008932944649264, -4123, -55, -858251929.793158, 54.556567, 1, 'binary.CGijFVktOvKYBbslrFnW', 'nchar.甘肃省丹市牧野刘街b座 221301', 1630000000026) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630375000001, -994075958, -3836907429942473253, -15968, -12, 4.809100, 97814318457.744095, 1, 'binary.ZkpIzssjZLBfwxySZcqJ', 'nchar.吉林省惠州市兴山辛路i座 132947', 1630000000026) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630375000000, -316707220, -6874259000415830359, -14656, -107, 9783647610530.900391, 6.913912, 0, 'binary.stonHOVphDrwzsFtAuEM', 'nchar.吉林省杭州县秀英任街B座 197635', 1630000000025) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630390000000, 1162924990, -5170396701176744771, 20522, -92, -96439892251.988800, 27285284869935.500000, 0, 'binary.VaAkDRQGuwRsRuHuWTBT', 'nchar.安徽省刚市璧山严路e座 453358', 1630000000026) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630390000000, -1787695146, -7200438941294278654, -1976, -22, -19864559903432.601562, -81662701579034.406250, 0, 'binary.cmeIZxizSzJowehZeTgi', 'nchar.甘肃省萍县吉区雷路Q座 278197', 1630000000026) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630389999999, 1569291471, 7500808657751046307, 17406, 11, 187598077622.457001, 9402508122.216591, 1, 'binary.rGPAUjewRUiNxuGlPQSI', 'nchar.湖北省宁德县永川邓街N座 873981', 1630000000026) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630390000000, 379511627, 959739624838461444, 32645, 40, 27073116046.845501, 9680357.747312, 1, 'binary.EnkonjEPYvAZMcbrIDhm', 'nchar.安徽省宇县南湖拉萨路l座 319850', 1630000000026) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630390000001, -367057952, -5935523220947872265, -31354, -124, 60936491.153154, -7459361.174603, 1, 'binary.ehReUikosMxxEsGOsivE', 'nchar.河北省宁德市六枝特武汉路j座 479101', 1630000000027) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630390000001, -1204076280, -9028857053490170794, -4305, -36, -4299.875188, 8440721199484.889648, 1, 'binary.LDFNunrLqdOUVBNKOEgL', 'nchar.湖北省西安县六枝特淮安街d座 633128', 1630000000027) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630390000000, -1734305566, 9014243322464991494, 2526, -91, 46980567127.508904, 2736.398653, 0, 'binary.kCqLuZWcVXncorOcRLOX', 'nchar.吉林省秀英市永川姜路P座 763227', 1630000000026) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630405000000, 493810102, 750963322474159528, -23750, -17, -22892331.104465, 24868217245883.800781, 0, 'binary.CFELPsklozusjREurYzN', 'nchar.浙江省云市吉区丁路H座 432525', 1630000000027) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630405000000, 1463044753, -1849311824110235905, 30811, -7, -17541415231.352200, 4359875.313503, 0, 'binary.XztqpyyklxsOpFMGQpdQ', 'nchar.内蒙古自治区兴城市和平李路f座 695390', 1630000000027) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630404999999, 1007184435, 7016082283155873873, 18680, 114, 921004.858357, -3749822553130.689941, 1, 'binary.nPsHiYGSrumTPlRhGlGo', 'nchar.内蒙古自治区长沙市海陵六盘水街Z座 569551', 1630000000027) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630405000000, 2001976992, 6444735120490802040, 10757, 75, 3812894583.717430, -70452173102543.796875, 1, 'binary.MPllmpddghzaoIRJmAJs', 'nchar.河南省西安县崇文李街d座 986692', 1630000000027) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630405000001, -1748589793, -7997812859393713894, -9028, -46, -35.226372, -6653121231.857540, 1, 'binary.eVMhMPninMDMThzngiZC', 'nchar.江苏省鹏县长寿深圳街V座 475898', 1630000000028) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630405000001, -952046898, -1003514831999138377, -10475, -121, 583096872.778729, 750.380516, 1, 'binary.NhUrjkWQZoYMHNgZcAur', 'nchar.辽宁省畅县南溪陈街Q座 816736', 1630000000028) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630405000000, 1203696901, 5857368026922559698, 26958, 20, 7943395.425475, 3479394471444.229980, 0, 'binary.EWZLkQdNEMzlxMRcWPIF', 'nchar.河北省凤兰市秀英王街h座 943022', 1630000000027) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630420000000, -1140109939, -7140478781384267748, 23888, -102, -463251528.501850, 58.564400, 0, 'binary.wBOWZRMsrPHnjovxpVtM', 'nchar.福建省桂香市魏都张街s座 891983', 1630000000028) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630420000000, 1596211207, -6399610783775225615, -6948, 18, 5279544962.478530, -3254512966322.680176, 0, 'binary.pkLdHCSKTBJtvlkQZFel', 'nchar.宁夏回族自治区志强市沈北新哈尔滨街V座 984662', 1630000000028) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630419999999, 1987333617, 2406177688984023332, 5515, 81, 93334135.435757, 15200180248105.500000, 1, 'binary.zunblBzpjKjvAprKttjO', 'nchar.陕西省娜市六枝特长春路u座 734021', 1630000000028) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630420000000, 1816593353, 6144436182936056183, 11139, 111, -5111160.608439, 3134629841.427010, 1, 'binary.SvSSddOyqqrLVbTuqmWK', 'nchar.黑龙江省北京市沙湾天津路l座 864505', 1630000000028) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630420000001, -1092293083, -6497162148443342823, -12861, -33, 7333968.460815, -786239055.465100, 1, 'binary.abpCKdOYaAAPNEGSEKTl', 'nchar.重庆市通辽市白云席路d座 390244', 1630000000029) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630420000001, -672330807, -1416095251335444839, -31617, -20, -268.247197, -187856842551.350006, 1, 'binary.ayrYptkczwLwwHSlrotJ', 'nchar.安徽省莹市崇文卓路D座 742319', 1630000000029) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630420000000, 1541531440, -8276464445557829911, -32389, 41, -205002775.660640, 773381214983.128052, 0, 'binary.DfbOMiMBChkQyxVRkVrV', 'nchar.江西省重庆县东城嘉禾路z座 664431', 1630000000028) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630435000000, 511355972, -4607655896423993759, -17667, -115, -72721.674990, -0.210169, 0, 'binary.TzInKrTBzLfzhusnMyJt', 'nchar.西藏自治区大冶县黄浦夏路c座 672141', 1630000000029) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630435000000, -794567134, -2235695034213568259, -18310, -76, 80256151932.389999, -0.448521, 0, 'binary.rSBKSseTjokrDbbUwbdS', 'nchar.新疆维吾尔自治区南宁市璧山王街D座 205832', 1630000000029) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630434999999, 1590979273, 8094673699827428920, 1803, 48, -6923.890078, -97907136406253.203125, 1, 'binary.GnrqLzMLFlinSCSmzsTt', 'nchar.辽宁省荆门县六枝特邯郸街p座 507994', 1630000000029) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630435000000, 1132029984, 2532896687056073497, 20663, 78, 72584604.270350, -52558156996.426201, 1, 'binary.hUBVgUHTpsSwyjcCwqYn', 'nchar.四川省邯郸县南湖张家港路V座 697294', 1630000000029) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630435000001, -214047405, -8929808789293020890, -14561, -75, 57922.963900, 629338050.201999, 1, 'binary.rUFdjCoxExrGdHJRdNrS', 'nchar.香港特别行政区艳市魏都香港街w座 547058', 1630000000030) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630435000001, -1769159233, -2980306744069119372, -24737, -85, 95463.992658, -3290730049210.250000, 1, 'binary.bcUBXvglPoTsHoRWOtZB', 'nchar.青海省建国市蓟州罗街V座 702124', 1630000000030) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630435000000, -787830057, 3539391148256582010, 8967, -84, -3405.578845, 6448387382.497230, 0, 'binary.nXPgVFiqtkagYaeMiBqc', 'nchar.宁夏回族自治区兴安盟县梁平沈阳街J座 590779', 1630000000029) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630450000000, 1186123659, -7951052163704337820, -29743, -14, -83621685835717.906250, 73159143.385460, 0, 'binary.VKjqDeckRehqfqnstQEu', 'nchar.河北省上海市门头沟梧州路n座 288381', 1630000000030) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630450000000, 1878200309, 7041626075528835244, -32078, -31, 37394.924981, -492.884685, 0, 'binary.tSYeYbpjVnhDUVatIqqr', 'nchar.云南省齐齐哈尔市朝阳王街j座 235227', 1630000000030) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630449999999, 1216265979, 1946865098328593924, 13349, 71, -8448.993057, -74684363814152.500000, 1, 'binary.HIQrJxrPESpsHxBeQTJr', 'nchar.香港特别行政区关岭县魏都呼和浩特路i座 304697', 1630000000030) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630450000000, 1436995521, 3840076561934756705, 24645, 53, 3385565140.362020, -18217011452.326302, 1, 'binary.RBEtocJRHaAIuNaYJMhP', 'nchar.辽宁省重庆市江北张路g座 561300', 1630000000030) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630450000001, -704813545, -8641984224483414170, -32490, -72, 305492940.896881, -3375029817498.339844, 1, 'binary.MUkAAGQFoHZIrYzgZIkn', 'nchar.甘肃省佛山市六枝特梧州街p座 155461', 1630000000031) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630450000001, -222045952, -7186471281941680094, -4325, -12, -4.504288, -107.133595, 1, 'binary.rYHScGxtnPQZbrvqmGLs', 'nchar.浙江省斌县西夏宁街i座 817397', 1630000000031) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630450000000, 1430474057, 6099257513015763510, -25953, -124, -4692.193024, 4.787536, 0, 'binary.ECCSIBNtxKQLYBfOfsJg', 'nchar.天津市西宁县璧山曾街N座 665290', 1630000000030) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630465000000, -1933715256, 1674195434522463261, 18595, -62, -2.112704, -1.361571, 0, 'binary.WFmGDlZbQZbxQoPTeYYD', 'nchar.江西省帅市秀英罗路i座 713857', 1630000000031) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630465000000, -1427366603, 348136735706226150, 11786, 45, 998.343140, -9.796246, 0, 'binary.mfnVlbsKfzjjqorEhocA', 'nchar.西藏自治区玉市安次成都街E座 433538', 1630000000031) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630464999999, 1659717258, 7758886491614905150, 8304, 125, 6399945699.318400, 86010265260.434601, 1, 'binary.PFttwdRtnOphOvIvENNh', 'nchar.山东省欣市沙湾孙路R座 922051', 1630000000031) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630465000000, 2080213156, 8048809385397600433, 18758, 65, -544332786.800377, 2865457.223765, 1, 'binary.oElRbKMuPpzhWDlPDXtl', 'nchar.北京市淑华县江北李路F座 469619', 1630000000031) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630465000001, -1260757693, -7052648703184778467, -19691, -58, 263396039624.993988, 4278958.521790, 1, 'binary.CZUckqTDCqkrcZvnYVOg', 'nchar.广东省秀珍市清城谢街t座 351701', 1630000000032) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630465000001, -716674007, -2090666240981221473, -8986, -13, 40900.288977, -311075618204.403015, 1, 'binary.svGVeKCsLqnIefICQikd', 'nchar.宁夏回族自治区哈尔滨市南湖梁路v座 181451', 1630000000032) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630465000000, -1114362408, 5527740642432952035, -26428, 12, -21611.508885, -307.575004, 0, 'binary.UdnFsgeAgiPHPPgFGuCS', 'nchar.天津市成市朝阳沈阳街c座 871777', 1630000000031) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630480000000, 572636870, -1348714871953192727, 11880, -9, 78191326.534929, 5.863674, 0, 'binary.ELYllxOgSmXkAHYWCKeC', 'nchar.河南省六安县和平惠州路b座 192567', 1630000000032) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630480000000, -1554586734, -5797603791431465981, 19152, -58, 376.263188, -9117680341029.800781, 0, 'binary.ItnjMhkccvDshKoJDFBL', 'nchar.广西壮族自治区上海县高明潜江街i座 632153', 1630000000032) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630479999999, 1889928969, 2650453196149359117, 1531, 101, 221512.929316, -89455817137.120804, 1, 'binary.JuOPYpivSOrAxirELGaK', 'nchar.云南省广州县清浦潜江路y座 321604', 1630000000032) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630480000000, 123268180, 7324096614566287829, 18716, 12, 727218062004.973999, 656857194.138679, 1, 'binary.LzrEjFPpRgwZHAABcyJl', 'nchar.宁夏回族自治区兴城县沈河济南路A座 434702', 1630000000032) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630480000001, -739224311, -3272068915371457037, -11723, -49, 952488.600157, -831167.359733, 1, 'binary.KMwlcGqAhCieyQLGVtBU', 'nchar.河北省玉梅县徐汇张街u座 155803', 1630000000033) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630480000001, -1363430935, -5467097084273074766, -2392, -77, -2426746190.920940, -72743043.214903, 1, 'binary.FYLJECmRlLXbWxOIZbkA', 'nchar.新疆维吾尔自治区荆门市沈河丁街Q座 909413', 1630000000033) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630480000000, -1790122655, -8076464905134511680, -30494, 39, -300117474923.549988, 64738074469674.398438, 0, 'binary.sleyeDsmwcqZzCKoASFB', 'nchar.江西省香港市西夏沈阳街A座 666990', 1630000000032) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630495000000, 500469874, -345787852149044362, 31942, 66, 218.280717, 7741245996.308220, 0, 'binary.WbODLLMuYAWsCiVGykXg', 'nchar.甘肃省哈尔滨市萧山邯郸路M座 577140', 1630000000033) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630495000000, 1790655569, -8921791989390937548, -7521, -10, 21190031.941426, 372852.384613, 0, 'binary.pvccoVhryCwBmdnzLuTc', 'nchar.云南省潮州市沈北新吴路C座 166459', 1630000000033) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630494999999, 175625025, 4866859483197899046, 22179, 83, -52019.335200, -315117.422010, 1, 'binary.EPoDgXsUUMvKeLUulmOd', 'nchar.上海市呼和浩特县孝南淮安街D座 688832', 1630000000033) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630495000000, 531699098, 9087043167036546370, 10882, 69, -343189.459391, 211280.823556, 1, 'binary.gZdLTctTatBiWQSJIJOv', 'nchar.黑龙江省鑫县友好石家庄路G座 894253', 1630000000033) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630495000001, -128692601, -3691685846078930525, -2891, -13, -473237.431473, 6.861402, 1, 'binary.PevuHflVwLyOeexwpRis', 'nchar.广西壮族自治区桂花县和平石家庄街b座 197395', 1630000000034) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630495000001, -1382111225, -8179715729898925736, -27170, -65, 94.689652, -9.323222, 1, 'binary.dQukgnOBymmhDJsngvdP', 'nchar.河北省西宁县六枝特谢街w座 636313', 1630000000034) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630495000000, -1067182718, 4525978413594477317, -15988, -12, 9592970.107203, -5857432670.557230, 0, 'binary.KmUaBLARuhpFnBlZhhjz', 'nchar.广西壮族自治区玲县丰都伍街N座 160120', 1630000000033) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630510000000, 834635110, 7524163623717860346, -32317, -74, -15228783.766541, 189210.220590, 0, 'binary.EMKiAeOicxSQHtyaVgJp', 'nchar.广西壮族自治区洋县沙湾太原街b座 616020', 1630000000034) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630510000000, 969850854, 946247056457664769, 21254, -118, -665960476591.563965, -26272792213245.500000, 0, 'binary.AmemAqKVRuTlgnqegQTU', 'nchar.四川省海门县牧野潜江路x座 318206', 1630000000034) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630509999999, 1292293650, 4182146421220552346, 9438, 26, 6515565137650.730469, 4326564.636935, 1, 'binary.sjAdlJbnpCLUoyTzXGLz', 'nchar.山东省杨市南湖刘街Y座 225115', 1630000000034) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630510000000, 122648893, 3568976233348927576, 4722, 101, 3692.808659, 8.426917, 1, 'binary.idKTOjMQWLcoovoLZCRY', 'nchar.天津市关岭市锡山蔡街f座 426508', 1630000000034) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630510000001, -103653848, -6515029160766267522, -13842, -21, 461152.967231, -451711.406503, 1, 'binary.axaNePeGlnNRTVkjQgqj', 'nchar.黑龙江省芳县海陵贺路c座 606589', 1630000000035) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630510000001, -1047587411, -3104445727812638863, -8586, -20, 551018.785658, -69672859.800138, 1, 'binary.rrQrHCANqfAEkPaQtSxY', 'nchar.江西省辛集市平山南京街X座 619416', 1630000000035) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630510000000, 849850958, 4247759734843437140, 25856, 61, 216972633.179206, -688453.180700, 0, 'binary.HFGqhFMKQtiuVGsRfHzo', 'nchar.台湾省柳县清浦长春街g座 249559', 1630000000034) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630525000000, -1263472959, -6789381028960214442, -24794, 114, -380257099.745964, -4055421597.527550, 0, 'binary.vYeuboTOIvXZsvEDJLRp', 'nchar.云南省淮安县浔阳南宁街s座 962460', 1630000000035) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630525000000, -912546236, -763230547896477749, -22937, -100, -61226717.838399, 59403.615805, 0, 'binary.RfopmCaAJeNFUhoHdGfp', 'nchar.北京市嘉禾市海港梧州路Y座 185275', 1630000000035) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630524999999, 1491974080, 3628020701059333562, 19419, 61, 87024838.439295, 563459.869036, 1, 'binary.MGCglbwygRPypvScTmBl', 'nchar.山东省霞市吉区哈尔滨路U座 372048', 1630000000035) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630525000000, 1133422966, 4026166323599059583, 27738, 105, -67481518.148927, -5675366548881.980469, 1, 'binary.LFpWlYqzLoxtHDCeMOWl', 'nchar.黑龙江省北京市沈河王街n座 817738', 1630000000035) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630525000001, -104646696, -5475621281854878817, -8285, -77, -25646075.949196, -671.169300, 1, 'binary.nEdnhlzGKPxpfWnmznnT', 'nchar.辽宁省凤兰市上街李路t座 977250', 1630000000036) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630525000001, -62177409, -7664099839058566322, -13160, -111, 2741718151170.200195, -3.737565, 1, 'binary.kkhcrwzjebqpTkpaFkPz', 'nchar.山东省淑华县六枝特长春街L座 836041', 1630000000036) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630525000000, 1330077191, -57050396993719408, -17322, -114, -17573257017538.599609, 131480451841.740005, 0, 'binary.nBjEjjCxPpyJZZokLLYj', 'nchar.辽宁省拉萨县普陀香港路u座 175740', 1630000000035) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630540000000, 1361888973, -4754878850289093930, -8386, -123, -73755105134.646896, 593521593.672730, 0, 'binary.aaJdLDhVgqXgbzOLtgEC', 'nchar.陕西省玉兰市城东东莞路y座 735950', 1630000000036) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630540000000, -2023047539, 207198366842950509, -16454, -51, -5064990.460660, -1880.742682, 0, 'binary.pgtomoahTdklLDwxLWlX', 'nchar.天津市哈尔滨市普陀赵路a座 285719', 1630000000036) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630539999999, 1161599505, 3137635940724704617, 16998, 16, 341287.343410, 3260540.642346, 1, 'binary.VpvoOstBpXhXgCFmTNbu', 'nchar.江西省坤县沙湾拉萨街f座 882807', 1630000000036) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630540000000, 927677922, 1982533905502059580, 28136, 88, -554.710032, 860334626423.604004, 1, 'binary.xigdKxGBhwDummTjgWpP', 'nchar.甘肃省兴安盟市大兴李街R座 743679', 1630000000036) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630540000001, -1715472820, -1384061899373736161, -15979, -21, -144230.332607, 3166307136.273820, 1, 'binary.keFGWYyGPVWHcgVZNKld', 'nchar.江苏省莉县沈河王街j座 843427', 1630000000037) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630540000001, -1691042073, -7186599605570808771, -14609, -94, -20270760488095.101562, -479065667910.349976, 1, 'binary.qNCwJqmtvmXEEJXuqVcD', 'nchar.安徽省鑫县西峰香港街Q座 197792', 1630000000037) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630540000000, 1494052790, -8128813094838655682, 26938, 0, -5026361458.157280, 48738437612.827003, 0, 'binary.beRVwfLpgmeKWVAywXMR', 'nchar.重庆市西宁县沙市南京路l座 534992', 1630000000036) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630555000000, 611413897, 4152857341280270300, -8759, -18, 2060373600.882190, 661904.107513, 0, 'binary.VNQYBgSikmUjTzZJlnVf', 'nchar.台湾省潮州县永川莫路h座 405659', 1630000000037) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630555000000, -2011948818, 7185570718886510818, -23571, 37, 224031795.273930, 529323.833439, 0, 'binary.gdqheapFdDFaeWrvvlFQ', 'nchar.黑龙江省丹市孝南白路Y座 681449', 1630000000037) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630554999999, 654809776, 1038278314990977803, 21715, 111, 9233.222241, 875.958899, 1, 'binary.zeHdYSkOUqnFvykwmfjx', 'nchar.山西省飞县淄川大冶路o座 582862', 1630000000037) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630555000000, 1280839364, 1109786269551140763, 28107, 83, -7163.528250, -98949521955313.296875, 1, 'binary.GPZyYjBdWvtWXNqtBBAi', 'nchar.吉林省秀云市浔阳石路k座 906496', 1630000000037) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630555000001, -1722544909, -25495015738455645, -17889, -9, 8051193952.303000, -0.243396, 1, 'binary.NUGayWaiLgkIttYyWPen', 'nchar.江苏省帅县合川嘉禾路d座 756609', 1630000000038) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630555000001, -712202888, -3214543942801667949, -11436, -24, -4230794569.824540, 541.605598, 1, 'binary.NPvfKAwLNUBrUsbNQBjL', 'nchar.青海省晨市长寿深圳街y座 565486', 1630000000038) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630555000000, 238745662, 5355356224239767868, -31138, 41, 22.830003, 4601.537342, 0, 'binary.PeqIYBTzojcHPPpbASyS', 'nchar.台湾省邯郸市六枝特海口路s座 355514', 1630000000037) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630570000000, 745693189, 4651138598564121948, -3614, -40, -41.868811, 96833493.796392, 0, 'binary.MRNQDZhMkAPOMwRDPLza', 'nchar.新疆维吾尔自治区坤市南湖蒙路z座 268958', 1630000000038) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630570000000, -2145996442, -3433600130799541776, -10809, -63, 855480.426782, 668870.374284, 0, 'binary.FlljuYVtUMddfJeXCePu', 'nchar.上海市林县永川深圳路h座 254543', 1630000000038) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630569999999, 1261953798, 314028281416970194, 7113, 92, 57276757.143326, 9980201888194.929688, 1, 'binary.CWKxzlTunbzsSgrpGTXp', 'nchar.河北省淑英县南湖武汉路Z座 875483', 1630000000038) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630570000000, 1435842767, 6578024513554467170, 17462, 68, 3980927396.535860, -442434194.149287, 1, 'binary.VGfEsMVqNVUjawdSRhQz', 'nchar.重庆市深圳市西夏刘路N座 212798', 1630000000038) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630570000001, -1529141111, -2552308375560945509, -3088, -52, 65625.681921, -544.669991, 1, 'binary.bfdhAjhpOMjvNqKKrBns', 'nchar.西藏自治区杨县崇文永安街j座 354402', 1630000000039) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630570000001, -541899245, -5991226110563542766, -707, -107, 35892171731.112297, 385.252012, 1, 'binary.TbAKAMxnTbMsqbiNmVzL', 'nchar.香港特别行政区南京市兴山广州街t座 824478', 1630000000039) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630570000000, 101231908, -1793754924693109102, 28121, 5, -27297115.590120, 235254039.488185, 0, 'binary.viiOyqfWQeKCCeqjJSna', 'nchar.台湾省秀华县沙湾辛集路L座 217819', 1630000000038) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630585000000, -979159064, -4405552399360058755, 29025, -61, -213.670605, 43.565732, 0, 'binary.VTPMgOjAfDTIkXvCBRvm', 'nchar.北京市莹县崇文万街c座 320902', 1630000000039) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630585000000, -732603316, 3291957888362983413, -27560, -5, 19536.856481, 81.835797, 0, 'binary.XyZczHSyVrPUQdbZGVqI', 'nchar.河南省香港市蓟州蔡街Y座 824988', 1630000000039) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630584999999, 1148581502, 1746383234690030123, 6204, 56, -838550587.270660, -7435199862.146900, 1, 'binary.jcVlbATHJidNqVsLaIMo', 'nchar.河北省关岭市浔阳任街A座 776594', 1630000000039) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630585000000, 1999818388, 7210586798654528078, 1630, 18, 6208.528721, -335.584522, 1, 'binary.aoQUSVWoTxqKJPqRozVe', 'nchar.河南省平县滨城兰州路a座 637800', 1630000000039) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630585000001, -884290007, -4556726278944994370, -16568, -42, 3252403692312.240234, 6802621362.778860, 1, 'binary.ppFYTcNMeEFxKGYyuqxK', 'nchar.江西省淮安市城东潘路U座 501030', 1630000000040) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630585000001, -1116869032, -271141834781987082, -15740, -33, -9594782340313.500000, -19702686640.119999, 1, 'binary.ptSTibfgYgBqxXBcljXJ', 'nchar.上海市乌鲁木齐县上街吴路k座 975956', 1630000000040) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630585000000, -435132639, -8699906763762846441, -23184, -19, -4717893819233.429688, 8709722.643050, 0, 'binary.RcLPKAxeNyCrFVgZBWDc', 'nchar.贵州省婷婷市永川香港路M座 438076', 1630000000039) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630600000000, 995611137, -3751963808881697081, -16228, -21, -96744.522458, -531.564886, 0, 'binary.uctNWRFZwpiODjjBdURc', 'nchar.江苏省琳县双滦乌鲁木齐街W座 315778', 1630000000040) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630600000000, -701305447, 7350533321420278894, 12461, -14, 637529643632.400024, -37006.524818, 0, 'binary.nBvNWvoxhJhaxlrXNwSq', 'nchar.河南省澳门市海港骆路d座 670505', 1630000000040) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630599999999, 2038087184, 3229395695102168112, 32164, 120, -60786248.451037, -66349595222.869400, 1, 'binary.jnEtTqkFChOMBYyRcHDQ', 'nchar.陕西省桂珍市秀英徐路N座 443126', 1630000000040) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630600000000, 2133331669, 3831296733741228684, 640, 101, -22204789596077.000000, 12726162933.525200, 1, 'binary.uKmymrIXqCovPNkWAJLg', 'nchar.广西壮族自治区瑞县龙潭深圳路g座 407714', 1630000000040) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630600000001, -1455494423, -4099795228613872218, -24485, -97, -42580895412.277603, 438688.561578, 1, 'binary.GqYiJMfzdIKHFsKfxVpu', 'nchar.贵州省建国县海港陆街z座 539355', 1630000000041) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630600000001, -743807783, -2365949684422468696, -5832, -55, 152697699639.433990, -847.354407, 1, 'binary.TEyMfkklGoyQyuhoMfGa', 'nchar.江西省秀华市黄浦刘路o座 900428', 1630000000041) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630600000000, 1164985515, -1528321163891719683, -5017, 59, -4685058576109.339844, 573635.987915, 0, 'binary.YRSxugbLdtCzYDQuPHiO', 'nchar.青海省刚市吉区成都路D座 183949', 1630000000040) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630615000000, 1552612066, 2109390087439052468, -31070, -121, 8636.758774, 54571.528229, 0, 'binary.xlsMBheXDBRIbHzbgzdk', 'nchar.河北省兴城市东城西宁路M座 385581', 1630000000041) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630615000000, 686960603, -6424166539989529553, 24333, 44, 8214.897773, -47431121552021.000000, 0, 'binary.RWvwTVykxTTNOYllQrFG', 'nchar.湖南省鹏县清河徐路D座 553544', 1630000000041) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630614999999, 68548265, 4587156226014614794, 16331, 57, 154895.265334, -2787.111072, 1, 'binary.ixnKFyhNgVkQywiDtpSq', 'nchar.广东省海燕市白云兴城路u座 101958', 1630000000041) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630615000000, 2266587, 2581645298895273135, 22522, 42, 3276944.200912, 911196.685350, 1, 'binary.rAZwQmSTbVawENHakqoC', 'nchar.北京市玉英市西夏台北路Z座 806985', 1630000000041) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630615000001, -982806837, -8813143395330268157, -9811, -65, 4240824286.641320, -949974.279935, 1, 'binary.IhdGdIOduEtBfgveDAUU', 'nchar.广西壮族自治区佳县怀柔西安街o座 181079', 1630000000042) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630615000001, -680593150, -6347717442100280854, -12839, -105, -3011259806.223000, -99641241686.436996, 1, 'binary.BZPuOZNfEoXwZqhyVXdb', 'nchar.内蒙古自治区南宁县丰都支路Y座 726362', 1630000000042) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630615000000, -417426465, -3607718287738436914, 28714, 52, -972051082.524374, -9817388374.836500, 0, 'binary.cWDUQzDHybUekMyDXMXD', 'nchar.四川省帅市黄浦荆门路A座 476400', 1630000000041) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630630000000, 1094499153, -8105793501718430866, 3482, -67, -190.752084, -5267142.925286, 0, 'binary.uxspDdfsvojZAgyJTRsp', 'nchar.贵州省香港县徐汇合山街F座 623037', 1630000000042) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630630000000, -1816628643, -2390834298866111036, -25491, 93, 421896.632317, 21603.217576, 0, 'binary.hrCIGqyoKXyOENntzjcy', 'nchar.湖南省广州市怀柔六安街a座 810265', 1630000000042) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630629999999, 237543427, 5776314153706817860, 8994, 66, 3092.121681, 4306303.541656, 1, 'binary.utVrWGltqteXbNHvQIuO', 'nchar.香港特别行政区建军市长寿刘街N座 294264', 1630000000042) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630630000000, 726605466, 7765148407017524476, 9380, 66, -725.184771, 4.785127, 1, 'binary.eCvUodgIQEPGQAlVRXHW', 'nchar.湖南省石家庄市海港林路K座 736274', 1630000000042) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630630000001, -2034983874, -1663495204537070761, -3507, -95, -26436104.684611, 3096688941.682010, 1, 'binary.buRNGkuUJrPnERgeimCX', 'nchar.湖南省海口市门头沟贵阳街c座 812797', 1630000000043) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630630000001, -1349842048, -6086664054622894661, -26154, -20, 9.257350, 73467.254310, 1, 'binary.VLQrxUICLTloHhOcsChH', 'nchar.福建省超市崇文通辽路p座 610024', 1630000000043) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630630000000, -1077532579, -4438737277090132487, -4021, -89, -1603199944.809290, 972619729.980217, 0, 'binary.bmvtStTuvDxOdnRZezwW', 'nchar.海南省成县闵行康街q座 877974', 1630000000042) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630645000000, 667040085, 5063347356651668746, -6033, 123, 372331463.295536, -1199.428365, 0, 'binary.yILHXSyMobxUzhCNgPvB', 'nchar.陕西省冬梅县高港谢路R座 540642', 1630000000043) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630645000000, 1643497791, -7930526570990406176, 31172, 28, -53.309129, -52475027161.967003, 0, 'binary.lznIQgSqYtbfWrGxFBvU', 'nchar.山西省南昌市翔安李街Z座 864233', 1630000000043) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630644999999, 1757612759, 453614548545492325, 5562, 26, -42197958317985.296875, -395.764533, 1, 'binary.gZRMNooJsuQCqUkKgObf', 'nchar.浙江省呼和浩特县闵行张路Y座 696051', 1630000000043) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630645000000, 716946034, 8100574991162286831, 8901, 92, 390.851634, -9995.448678, 1, 'binary.WChvjMXwNeLmicQzcpDK', 'nchar.湖南省丽华市江北张家港路O座 383877', 1630000000043) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630645000001, -1691922856, -2342118046897302678, -23270, -66, -172559.465035, 3039868.728966, 1, 'binary.RimPMjXlEtpLazOlwnuv', 'nchar.安徽省玉华市合川黄街F座 509787', 1630000000044) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630645000001, -1339923814, -5560716090143693393, -6671, -10, -84330915414.755005, -2113273814915.989990, 1, 'binary.YGgXnRFnSbGpfKSYyKgV', 'nchar.内蒙古自治区荣县永川朱路u座 853226', 1630000000044) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630645000000, 1122107930, -8861294204430315415, -1044, -23, -3031.346285, 18.218107, 0, 'binary.lUwNsZlGQGhpLpDYqvtB', 'nchar.广东省兴安盟市合川拉萨路K座 345819', 1630000000043) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630660000000, 815803254, -3671302785504904803, -3291, -47, 736.989253, -48462175883.852402, 0, 'binary.PcSjPekpFeCmxcWwgQcF', 'nchar.青海省深圳市黄浦淮安路P座 492194', 1630000000044) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630660000000, 484949428, -5416390991488308737, -14887, 67, 2398644.783561, 8171275.544491, 0, 'binary.BizAmDZxfvTsgphmgDgO', 'nchar.新疆维吾尔自治区齐齐哈尔市秀英杜路h座 144209', 1630000000044) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630659999999, 1440457969, 8606030504343208767, 24314, 96, 92496.379572, 0.813941, 1, 'binary.xAmVpiYdockKtVmdHSIc', 'nchar.河南省平市海港龚路P座 644038', 1630000000044) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630660000000, 1069631125, 7783641181026641655, 29140, 58, 69214.199993, 158732124515.929993, 1, 'binary.SBJQcfJBwhXLUJwatImS', 'nchar.广东省强市怀柔哈尔滨街L座 103945', 1630000000044) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630660000001, -899220871, -9196200436704202533, -27771, -90, -73.878944, -8912.628710, 1, 'binary.VQcAzgArqSQQZnbSiMNU', 'nchar.天津市沈阳市东丽西安街g座 810520', 1630000000045) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630660000001, -1450060823, -615484698684325866, -16629, -4, -8.793729, -23575246237039.601562, 1, 'binary.AESWGdfihvaPnTfmDemj', 'nchar.宁夏回族自治区帆县江北石家庄街M座 983792', 1630000000045) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630660000000, 1278398866, 5363278013106925425, 29093, -83, -70828.447306, -526391.541525, 0, 'binary.iFAFqKguHdrdQhGoCpuS', 'nchar.江苏省刚市江北东莞路b座 826956', 1630000000044) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630675000000, -1081748955, 720719842133998595, -22633, 24, -73662437394.636200, -2235207.112560, 0, 'binary.CdInxRzeRZrFBbTOVcoH', 'nchar.台湾省六盘水县兴山石家庄街l座 541218', 1630000000045) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630675000000, -1665303728, -6208374964158196325, -17938, -26, -12.743038, -6410996304252.719727, 0, 'binary.ESErZzoVFrwLvZLjvszF', 'nchar.宁夏回族自治区兵市南长沈阳路A座 196143', 1630000000045) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630674999999, 1830689374, 6847266081436213038, 27195, 56, -98.825225, -11.841657, 1, 'binary.bKBmkbDmVObIaINgcUkt', 'nchar.宁夏回族自治区六安县东丽黎路Z座 360011', 1630000000045) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630675000000, 905604744, 5992591234700515548, 30228, 29, -771431291465.423950, -75930131567683.500000, 1, 'binary.uJqjLxypwZAqCJHRMkKo', 'nchar.吉林省艳县城北贾街Y座 511120', 1630000000045) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630675000001, -1874157012, -4583327710928801759, -27522, -76, 53914287540.938499, -9385422.995425, 1, 'binary.wycnNJGrIpmtWWvFxuJY', 'nchar.宁夏回族自治区云市孝南江路A座 778572', 1630000000046) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630675000001, -1498560711, -9199781197179273356, -25882, -75, 4614968554.698110, -96421428706.153503, 1, 'binary.OOYjhYdCGZQViNShXiSg', 'nchar.吉林省惠州市江北关岭街W座 967516', 1630000000046) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630675000000, -596563585, -8961615493016741888, -10813, 102, 75.123805, 6555481001.569020, 0, 'binary.DVXQBGshLAcqMWMMeiDT', 'nchar.山西省桂兰市涪城佛山路C座 407229', 1630000000045) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630690000000, 81214187, -3182813081122938906, 4960, -50, 518940275802.109985, -7999305661.759080, 0, 'binary.fkEdEbNuIkBTKcrHnEjx', 'nchar.新疆维吾尔自治区佛山市怀柔呼和浩特街P座 745345', 1630000000046) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630690000000, -1132347210, -6643466065281753528, -27772, -3, 8162664758739.139648, -13662048540.698799, 0, 'binary.KmKfzpIUppEqzuPvExem', 'nchar.四川省莹市牧野哈尔滨路j座 521095', 1630000000046) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630689999999, 1019010549, 6975314636031351786, 28464, 43, -465.888140, 8910415.572030, 1, 'binary.rBiBGLvfQWmnGDquOTbn', 'nchar.广东省雷县南溪宋路F座 681268', 1630000000046) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630690000000, 378275737, 876425613508142928, 15367, 120, -49.379488, 7567.687919, 1, 'binary.BTwfiAxrnagWWuCCCSZQ', 'nchar.北京市南昌市南长香港街i座 314362', 1630000000046) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630690000001, -533673302, -4156210237594471836, -17141, -10, -931105.914523, 799382106.862106, 1, 'binary.NqTaorSXMNHGbcIiftLN', 'nchar.香港特别行政区淮安市牧野石家庄街R座 897882', 1630000000047) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630690000001, -1935282932, -2743254909741386818, -6325, -67, 25114142.334721, 78.857657, 1, 'binary.hLaIbMlaSZIaojoxNNAG', 'nchar.湖南省邯郸县新城重庆路W座 451361', 1630000000047) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630690000000, 693093205, 1731593666471158488, 32616, -34, 944511.517342, -3.585256, 0, 'binary.JGrrPFPHkdvblDPQLBzo', 'nchar.安徽省艳市龙潭陈街I座 824093', 1630000000046) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630705000000, 1768911737, 5728476461209604096, -29190, 66, -6177089795.760590, -21430.400483, 0, 'binary.KANmXakVbwmKTQEcoIkv', 'nchar.吉林省帆市静安福州路e座 331035', 1630000000047) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630705000000, -248617365, -4341045528963124184, 31755, -98, 124670342.644870, -654637491670.374023, 0, 'binary.IzfBodxsdDxJktqQeDDU', 'nchar.浙江省秀芳县黄浦郑州路L座 115314', 1630000000047) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630704999999, 27001027, 339256900217870846, 11700, 1, -1455323856048.100098, 447841.805243, 1, 'binary.tMfHAqfBuEMKIckNFKLY', 'nchar.内蒙古自治区亮县清城陈街k座 990698', 1630000000047) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630705000000, 1581778818, 8464425008394999321, 20061, 5, -5247104654.611190, -568125.266376, 1, 'binary.JAXQCWWoDrpJuxVSlCNu', 'nchar.宁夏回族自治区萍市安次六安街H座 295531', 1630000000047) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630705000001, -732869228, -2906753353691356694, -5441, -3, -109283.289234, 9159375.165842, 1, 'binary.VYdDCHOMFAhsntioQInn', 'nchar.澳门特别行政区璐县西夏海门街A座 607065', 1630000000048) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630705000001, -18474510, -5999800564410930013, -6311, -2, -398057879.913052, 8761.567919, 1, 'binary.fIJqDAvfpidoaJSJkpnq', 'nchar.安徽省宁德市浔阳长春街U座 799007', 1630000000048) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630705000000, 850296579, 8875126379280838717, 10524, 108, -2975287.612558, 0.445600, 0, 'binary.eoLmnRFaXvklftfvhFCU', 'nchar.四川省亮县东城南京路E座 405800', 1630000000047) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630720000000, -239418734, -7503726504441061411, -31831, 84, 69021572289.137802, -86475940923.449203, 0, 'binary.ApWGXJYAZWgkReWPsvDb', 'nchar.湖北省磊市璧山武汉路O座 323410', 1630000000048) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630720000000, -943706680, -214023538774872985, -12169, 127, 948155.120585, -65149.125324, 0, 'binary.sujGooIQzKvLdzqRekyb', 'nchar.河南省丽娟县华龙哈尔滨街l座 264772', 1630000000048) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630719999999, 1251825975, 5053354830656579627, 14919, 60, -7531018879634.370117, 310964263643.562988, 1, 'binary.RfrhrTWzkzBvUvupCUaE', 'nchar.海南省阳市平山马鞍山路I座 852814', 1630000000048) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630720000000, 1115544686, 4049894819935008122, 30814, 12, -75.765668, 1187804567.210350, 1, 'binary.hYtJJtMEzEnmlYixUssL', 'nchar.河南省哈尔滨县魏都杭州路z座 972095', 1630000000048) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630720000001, -1724765969, -736233583823352610, -6737, -57, 893.536927, -7421.472515, 1, 'binary.RsUbHbctLoVkgmtdCxjM', 'nchar.黑龙江省马鞍山市山亭孙街b座 213806', 1630000000049) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630720000001, -1986547513, -6324903826238608678, -14843, -46, 309302.506851, -614273917609.833008, 1, 'binary.vnLJpYckYTAcDOpDNuWh', 'nchar.天津市亮市南溪陈路q座 364119', 1630000000049) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630720000000, -1284939264, -9095077298976089415, -19239, -92, 31.280584, 7379.657977, 0, 'binary.knKChKaZsyhUfkgmgzph', 'nchar.贵州省兴安盟市淄川郭路G座 242776', 1630000000048) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630735000000, -762937350, 8729420312334257343, 27701, -108, -6.651477, -29.713736, 0, 'binary.fpjgqsvwAKHintMJaYER', 'nchar.黑龙江省淑华市花溪宁路W座 152088', 1630000000049) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630735000000, 1144380216, 5276665732684544642, -11205, -89, 8215.254115, -99811752553.775497, 0, 'binary.FflDToYYzhVTnyRGzKGA', 'nchar.江西省南京县金平孙街c座 254949', 1630000000049) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630734999999, 1075377727, 9020113518015848371, 11084, 28, 307417.308042, -87.561190, 1, 'binary.kEOyxbKVdHlFqhZZzYwq', 'nchar.青海省佛山市安次深圳街Z座 504751', 1630000000049) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630735000000, 582692563, 4638155561099114479, 23761, 48, -29824236570673.398438, -10200.908461, 1, 'binary.XziirLIHCuFKtpiXVrTy', 'nchar.广东省帅市西峰张街h座 174088', 1630000000049) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630735000001, -1716643044, -8326169264977759340, -4200, -30, -2.318414, -726141333.615880, 1, 'binary.FZBESQUiuERkOgEMEfQR', 'nchar.广西壮族自治区英市海港汪路W座 657875', 1630000000050) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630735000001, -686568708, -4371717027180867061, -6734, -88, -578830467.970145, 9456.996341, 1, 'binary.ybxyxSLSKWvhXIhIuTZo', 'nchar.西藏自治区鹏县华龙邯郸路K座 280464', 1630000000050) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630735000000, -463229385, 8322975415402188951, 7658, 81, 48067565948.430801, 1684.497042, 0, 'binary.VCPIPiYLkNeWVJRVYdAa', 'nchar.江苏省伟县新城杭州路U座 135067', 1630000000049) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630750000000, 229305482, -8755922362006582494, 15607, 16, 433186324.150179, -9760091.526296, 0, 'binary.vzKjmFtaWUQJWUmLYsoF', 'nchar.广西壮族自治区潮州县璧山深圳街u座 513872', 1630000000050) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630750000000, 887769742, 8828265476094538774, 15810, 6, -52009423024.988998, 457109451.488690, 0, 'binary.lFOSpWYYjCkwLqOGSclj', 'nchar.广西壮族自治区伟市大兴李街A座 575739', 1630000000050) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630749999999, 806743984, 7134986215003200921, 17680, 41, 80628998.429324, -398852949.893027, 1, 'binary.KNgNzEsWMMOErSdhZARB', 'nchar.台湾省大冶县西夏辛集路B座 294228', 1630000000050) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630750000000, 1218616066, 4338651506702922568, 20337, 121, 607218.969786, 29540695532115.398438, 1, 'binary.hXxPnZwhSlMFInaNEPGO', 'nchar.上海市桂兰市金平刘路x座 286919', 1630000000050) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630750000001, -592467708, -3107486233936469903, -26640, -37, -77805664.682649, -1730.324950, 1, 'binary.fpSPyrjwsVtXzEHRGCaS', 'nchar.福建省沈阳市东城张路k座 869492', 1630000000051) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630750000001, -547550314, -5200749799296792327, -27549, -59, 2034147.803264, 96891027.798801, 1, 'binary.cyVZnAOokBmkMGIbacqs', 'nchar.江西省宇市蓟州唐路K座 406871', 1630000000051) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630750000000, 756019639, -653863967829096798, -30967, 59, 68379.967777, -1154096688678.510010, 0, 'binary.fHCaNBTuAEHvVNpuNcxn', 'nchar.安徽省宁县永川东莞路X座 798708', 1630000000050) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630765000000, -1406057540, 1446134498171766899, 30680, 68, -9307952080739.890625, -1153314466.810470, 0, 'binary.aDuEaSxjYaNCTgFqMHlC', 'nchar.西藏自治区红县静安黎路I座 596984', 1630000000051) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630765000000, 133613101, -1336954935529805727, 585, 116, 30.398745, -613552078.887368, 0, 'binary.NgMivPQObBgUbKnAwWEj', 'nchar.湖北省金凤县门头沟刘街f座 712446', 1630000000051) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630764999999, 656042024, 1646194287674616827, 26191, 10, 6678822.415847, -95361406615.342804, 1, 'binary.LZeGatPnXBHGNQggCUgW', 'nchar.澳门特别行政区西安市清城汤路p座 810444', 1630000000051) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630765000000, 1983919127, 7730061788745380233, 12586, 75, 10716267.549970, 7.199934, 1, 'binary.rnitdHGQBawBYXtOfvDJ', 'nchar.北京市玉兰市清河海口街u座 800278', 1630000000051) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630765000001, -1382937017, -109262277060062044, -24986, -53, -431535423232.208008, 34209788.409645, 1, 'binary.WSTgldQbIqYUaOeVUhSk', 'nchar.云南省秀英市涪城张路H座 199974', 1630000000052) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630765000001, -1301473352, -6756208355269860322, -17139, -45, -689118.755923, -3373577.841810, 1, 'binary.rcYvJxobOrraprgqcGvR', 'nchar.台湾省洋市花溪宜都路I座 962472', 1630000000052) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630765000000, -691470080, 1659254673769147544, -23790, -47, -429810768489.799988, 93436.707719, 0, 'binary.SxTTHFObymUpnuAfgYSQ', 'nchar.贵州省海门县西夏海门街a座 133401', 1630000000051) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630780000000, 921298258, 8536844726148128680, 3660, 26, -34185874.434563, -26620.589344, 0, 'binary.xevnfxQByaOjIEnqHaqe', 'nchar.重庆市华县山亭赵路b座 801493', 1630000000052) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630780000000, 1233028572, -8019335724423257023, 31663, -58, 14.142909, -50404.483362, 0, 'binary.MgKDUmZIKAlVhLpazpsJ', 'nchar.青海省永安市清浦彭路P座 393906', 1630000000052) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630779999999, 1876585459, 2853158241768185532, 24232, 50, -38916414122.860901, 6486812.485190, 1, 'binary.fafedlhFPmPAyJJGuMuZ', 'nchar.青海省潜江市秀英沈阳路X座 835387', 1630000000052) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630780000000, 1194165890, 7697386066201959752, 12368, 15, -7467278746696.700195, -979006.127435, 1, 'binary.sEHpIDvtRWaxcUbqPHAn', 'nchar.新疆维吾尔自治区大冶县高明项街d座 680148', 1630000000052) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630780000001, -1899593535, -1379716049261187467, -26105, -97, -17.445226, -149.378109, 1, 'binary.sHyQLVjnSTQSXpcWxHjq', 'nchar.安徽省杭州市城东郑州街M座 499265', 1630000000053) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630780000001, -1856641529, -4102589906454836588, -24873, -61, 97710303188.778000, 9646.234878, 1, 'binary.fKSswvhHhMTcaIjfaUUk', 'nchar.安徽省建县牧野杨街U座 584763', 1630000000053) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630780000000, 542554488, -3045723568122762779, 18580, 33, 95242718247053.500000, -50170311.264161, 0, 'binary.PUzrCqSyZiemQmkCCdGz', 'nchar.重庆市玉兰县永川汪路N座 270623', 1630000000052) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630795000000, 1864777486, 9048501077169003317, 32497, 90, -21112693476.624199, 960.488977, 0, 'binary.EEwLsBOCVnXbQbGiHwjl', 'nchar.河北省天津市魏都徐街V座 183214', 1630000000053) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630795000000, -1607594419, 3244019062872113101, -3112, -38, 4371695.605750, -76333.232422, 0, 'binary.FoXqOarMdnRuIkzdWEfn', 'nchar.安徽省石家庄市上街李街j座 287811', 1630000000053) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630794999999, 173077592, 5900121444981917372, 31259, 47, -9.692719, -36537321184.241699, 1, 'binary.hAZkGTgZudTvNdAfGCrG', 'nchar.黑龙江省林县长寿长春街H座 568159', 1630000000053) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630795000000, 1357591704, 8166773293007138161, 11502, 15, 9824768605988.179688, 899.269307, 1, 'binary.ORKiLvVsgwUaMmmVzXYK', 'nchar.浙江省西安县海港关岭路w座 192982', 1630000000053) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630795000001, -1842197906, -1075636322848135854, -11343, -9, 9085057779.572281, -9427483311859.769531, 1, 'binary.urBDWyTekFLJVKfewubE', 'nchar.江西省静县高港辽阳街W座 980270', 1630000000054) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630795000001, -1534128171, -4579657021740144805, -28105, -23, -265482542779.970001, 74780.975545, 1, 'binary.sEpkrqnSpFfYKIgeSBvK', 'nchar.澳门特别行政区西宁市龙潭六安路X座 127241', 1630000000054) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630795000000, -760013920, -8462295357527459170, -31765, 11, -433.960695, 264.431691, 0, 'binary.DroLRaBIftSwkoEbBZUl', 'nchar.山东省丽丽县黄浦谢路f座 644732', 1630000000053) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630810000000, -1675325589, -360996985377003606, -2347, 24, -470.741524, -887230390.331345, 0, 'binary.udlpjXsecEvxMZCZyvrV', 'nchar.江苏省银川市山亭太原路J座 723211', 1630000000054) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630810000000, 1632642973, 7850590523192382300, 13631, 45, -47687.239109, -81863875.566057, 0, 'binary.jmfRTYATfWhgLdSwABgZ', 'nchar.新疆维吾尔自治区长春市龙潭刘路m座 413049', 1630000000054) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630809999999, 1959334832, 4568407287596246175, 27961, 84, -665950847.396483, -29596243749715.199219, 1, 'binary.JOlrzeKxQTwVbozdztiV', 'nchar.山东省广州县高明张街C座 757018', 1630000000054) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630810000000, 1375371462, 4011481089622391741, 11886, 126, 4.397144, 4202513.398747, 1, 'binary.EblbpxwjuFqWmvABRtpz', 'nchar.香港特别行政区坤县南长王路W座 576754', 1630000000054) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630810000001, -1132521267, -4710706752937901089, -27234, -102, -277590425.724995, 292916.997240, 1, 'binary.DaNIAqljzrMdiAdtjNrB', 'nchar.江苏省畅市梁平秦路K座 961783', 1630000000055) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630810000001, -394127423, -4195198128268963203, -5174, -112, -37786616.462910, -750832.942933, 1, 'binary.rDUuOHQMIpSTjzaBeDKl', 'nchar.青海省亮市城东惠州路R座 997920', 1630000000055) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630810000000, 415436252, 7840392447567623067, 18496, -2, -20101885975.533798, 789.450282, 0, 'binary.CIlEgPRwfDUmqTEAjBrU', 'nchar.山西省桂花市高港张家港路B座 439810', 1630000000054) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630825000000, 1382842369, -3387166153829557613, 5113, 67, -14533655399834.400391, -47045088950.955902, 0, 'binary.fdwVbTqALVxEKqxPmklJ', 'nchar.香港特别行政区桂芝县沙市桂路K座 439607', 1630000000055) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630825000000, 122830188, 5944964533814104404, -4275, -2, 503740.982450, -2713577716.766000, 0, 'binary.KnHTmENdKEWNLWdfvFxb', 'nchar.内蒙古自治区婷婷市大兴乔街a座 468770', 1630000000055) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630824999999, 609279903, 9143142539302518131, 18578, 58, 6.776714, 7355.869852, 1, 'binary.PsdCUwiiFfTfBdYWgMIf', 'nchar.广东省巢湖市高坪关岭街z座 165945', 1630000000055) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630825000000, 1229687800, 6229049320529684281, 13288, 61, 1136575.519568, -474.263794, 1, 'binary.UtlqumZjObldYJWTCHVF', 'nchar.上海市玉梅市城东陈街K座 187484', 1630000000055) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630825000001, -902381702, -6581003712798510587, -16241, -42, -136567151.288395, -81351450.825485, 1, 'binary.vZnItDAvBlQXFtrMrdAk', 'nchar.广东省合肥市闵行南昌路a座 421030', 1630000000056) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630825000001, -1633588040, -9147247193490618424, -16771, -115, -2.864546, -4.968001, 1, 'binary.OChQYNfkTrcSaZTJGfhO', 'nchar.云南省淑兰县牧野农街t座 752385', 1630000000056) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630825000000, -997989279, 7637562832426174518, -5, 72, 1838649266.575190, -32247151699394.300781, 0, 'binary.fLcdsxEDyCdsbzARmlzG', 'nchar.吉林省娟市秀英潘街u座 599699', 1630000000055) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630840000000, -1691466505, 3835361758424457104, -21465, 99, 17.423367, -927580467091.141968, 0, 'binary.ExYLmKXMaFjayqkBEWqC', 'nchar.浙江省乌鲁木齐市东丽康路s座 780818', 1630000000056) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630840000000, 990486101, -6476848417158885996, -6947, 34, -91088473.667455, 443265343.199751, 0, 'binary.dyTxrTzimrnLgwtLehEp', 'nchar.海南省帅市金平兴城街F座 303386', 1630000000056) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630839999999, 1355859529, 2260526383089822706, 30660, 63, -672086975563.209961, 9219879.518002, 1, 'binary.EEjtfcofhSPxOuFgMlug', 'nchar.山西省凤英市长寿胡路d座 722345', 1630000000056) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630840000000, 720225284, 8056479222648510406, 7870, 107, 3.205667, -15331943645.198200, 1, 'binary.qBFljuOsopeYwpczltun', 'nchar.海南省杭州市锡山杭州街Y座 563787', 1630000000056) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630840000001, -1666639404, -1502779151523040369, -32737, -27, -720231064.559860, 9483852418979.500000, 1, 'binary.sDGclxLTrGjIYGBWUzox', 'nchar.江苏省颖县华龙奚路M座 347083', 1630000000057) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630840000001, -513166008, -1798257110690905490, -17212, -65, -6875665232.854830, 1.501719, 1, 'binary.JioYSyYNMAmHQGKIwFpt', 'nchar.澳门特别行政区畅县永川淮安街i座 315960', 1630000000057) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630840000000, -784030741, -771760196117941650, 5269, -23, 488442494858.158997, 142.977034, 0, 'binary.RyfovtjrYYDbDQEVcHoA', 'nchar.福建省帅市兴山合山街z座 360892', 1630000000056) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630855000000, -759466985, 3260110813666913849, -21345, -118, 6001735483.766000, 811956391.434487, 0, 'binary.FgtcgDCGdWGhileXYeVC', 'nchar.辽宁省敏市城东潜江街t座 539658', 1630000000057) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630855000000, 1791483134, 1877345879709438108, 7122, 108, 649645.697610, -3.176571, 0, 'binary.VOAUXbpzoEXTfEombqFu', 'nchar.湖北省建国县双滦昆明街k座 555641', 1630000000057) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630854999999, 819862528, 8086075097163190658, 28478, 59, -8892423630966.660156, 927321477.432369, 1, 'binary.gEIBgRUfuMarfhivmcmN', 'nchar.海南省海门市沈河季街o座 938191', 1630000000057) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630855000000, 575972371, 8165684898549408541, 26532, 30, 2158.716179, 6332790959904.230469, 1, 'binary.RzgEyNIsdJwDbkhjuZhn', 'nchar.广西壮族自治区哈尔滨市双滦薛路M座 750545', 1630000000057) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630855000001, -568694685, -6156824576786534987, -5004, -80, -8796651.346065, 4.370643, 1, 'binary.vDKHYEXPpBzKIFbWrBHH', 'nchar.四川省春梅县永川董路R座 716271', 1630000000058) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630855000001, -202484706, -7242157303332761279, -5895, -39, 1369656077.152570, 45024.146483, 1, 'binary.UTIcQraFLhrzeKZQNGad', 'nchar.陕西省大冶市大东陈路V座 230063', 1630000000058) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630855000000, 968718547, -7083502452755942963, 30186, 34, -808.116870, -355374.445932, 0, 'binary.FIxenkYBuIDmoaBpvKJr', 'nchar.内蒙古自治区想市闵行合肥街m座 213729', 1630000000057) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630870000000, 259545745, 6793904417678601057, 29752, -91, 35083182.940608, 4579746.564176, 0, 'binary.wmnksDymOwGQownBXGRS', 'nchar.湖南省上海市淄川陈路f座 699980', 1630000000058) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630870000000, -798452451, -1421146164509922388, -30643, -44, -532.819299, 864903894.997066, 0, 'binary.FofIkZDYExLKhITHZjpy', 'nchar.北京市静县长寿刘路V座 929762', 1630000000058) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630869999999, 810375591, 6862940885997459592, 12888, 67, 1.743840, 42697.428148, 1, 'binary.OrGwClCMpfhfshmaeYAS', 'nchar.安徽省坤市长寿许街s座 864780', 1630000000058) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630870000000, 2141142518, 330171567484187630, 5038, 87, 73252.885684, 88624.734440, 1, 'binary.cdSnMdwrroFKtbPAJSbg', 'nchar.安徽省沈阳市清浦汕尾路C座 749970', 1630000000058) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630870000001, -702799898, -322816941471556942, -1394, -123, 9456805.646888, 2105.641243, 1, 'binary.rTaTBdXbBszZjTTwracU', 'nchar.四川省玉市海港大冶路h座 545972', 1630000000059) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630870000001, -706124307, -5958027025637340951, -30853, -27, -7966.705252, 2.270573, 1, 'binary.eOyuShSfdOAmaSNhUZUv', 'nchar.河南省长沙县萧山毛路H座 196587', 1630000000059) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630870000000, -486193469, 7258930411934958638, 23283, -84, -6.193098, 11.792424, 0, 'binary.KGiDWTZdgHETHLJePGIT', 'nchar.陕西省丽市白云兰州路x座 161175', 1630000000058) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630885000000, -282533404, 7684010141772871588, -23850, 17, -2997190086014.000000, 931579019.615816, 0, 'binary.kZsMznDmRkjSoUQCWmtw', 'nchar.宁夏回族自治区汕尾市清城北京街c座 432095', 1630000000059) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630885000000, 1596401672, -5390915537011895583, -19578, 118, -9665.572275, -7154265.495520, 0, 'binary.JkHelKKoDnnJzPHiEROB', 'nchar.西藏自治区晶市梁平梧州路b座 369190', 1630000000059) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630884999999, 1840788362, 568759292490183791, 18205, 21, 16.931152, 17691.251149, 1, 'binary.EDicJkxTXgqUtLXKDjKy', 'nchar.新疆维吾尔自治区勇县蓟州沈阳路U座 172773', 1630000000059) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630885000000, 365787442, 1666872794496374179, 13837, 37, 193390765070.401001, 546707.447097, 1, 'binary.lmEGkvWshsqnAktNzJbB', 'nchar.重庆市桂花县南湖巢湖街U座 689551', 1630000000059) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630885000001, -745755820, -8898782181578548041, -7682, -15, -443.639102, -255152262.128928, 1, 'binary.MWmdVCjrANIfsdHAAVmb', 'nchar.河北省淑珍县长寿谢街k座 131370', 1630000000060) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630885000001, -2029500216, -7380552851400848492, -3516, -8, 8.915821, -51.793696, 1, 'binary.vQnridOAWDVWkJYYdTtF', 'nchar.云南省六安县海陵宁德街t座 241913', 1630000000060) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630885000000, 1648193924, -5763807398275594930, 27798, -65, -3.657749, 9559111883869.490234, 0, 'binary.VLogQYbaHPpPpmgyuzos', 'nchar.台湾省志强县和平刘路a座 827192', 1630000000059) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630900000000, -997698344, -4360698110328218759, 31934, -79, 8770449833.941080, -71856107060.251297, 0, 'binary.trhWcwdEKeoGUcQdImgV', 'nchar.天津市西安市牧野天津街q座 880750', 1630000000060) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630900000000, -492616894, -7002758781471003065, 28164, -11, 4740658.868259, -5320539.530775, 0, 'binary.TzdNtGFTXZWMADJaayqx', 'nchar.西藏自治区西宁市秀英杨街A座 353774', 1630000000060) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630899999999, 1825013146, 1744104394556381743, 31778, 117, 908811698547.689941, 42.982948, 1, 'binary.FtOgWPVAvygSIYsTWnHX', 'nchar.澳门特别行政区梧州县海港六安路D座 341014', 1630000000060) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630900000000, 2076832076, 3306826763175476238, 29009, 65, 654125.128750, 23.786689, 1, 'binary.yRAQxkeArOAnSkFHvhjQ', 'nchar.青海省南昌县清河澳门街f座 357735', 1630000000060) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630900000001, -364752002, -5092648072975157908, -23087, -39, 9.504646, 93358807.508628, 1, 'binary.sFAvwLkiYcepPputybEK', 'nchar.四川省文县萧山惠州街i座 903240', 1630000000061) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630900000001, -1784446385, -2802855779017240513, -5552, -54, -860449735702.189941, -703215980204.104980, 1, 'binary.RtSNrxogNuhOoRhEPrMJ', 'nchar.青海省静市孝南李路H座 399925', 1630000000061) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630900000000, 1445349008, 992848000519415190, -17518, 28, 4014000610.625470, 592.602654, 0, 'binary.IFSsgUZILZuPRwXTuFEw', 'nchar.海南省沈阳市六枝特长春路n座 155408', 1630000000060) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630915000000, -134082975, 4026898983947505460, 20740, -64, 24146076.871632, -207518516.166626, 0, 'binary.irWEJqxWnIlrKDExOAvg', 'nchar.天津市太原县吉区拉萨路D座 176064', 1630000000061) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630915000000, 1299050318, 3065792171140876784, -12329, -3, 74005.658734, -418157994.246836, 0, 'binary.sqAYHZcIIihZMMauybjG', 'nchar.内蒙古自治区桂花市城北阜新街y座 784832', 1630000000061) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630914999999, 711052785, 2718796412708678637, 32243, 69, 4069895314.170900, 38406.385424, 1, 'binary.UgajoEPkcVXcWkUCGwkP', 'nchar.安徽省桂花县房山傅路O座 240748', 1630000000061) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630915000000, 2140137646, 1082661109056257532, 23250, 103, -44495004919076.296875, -7284.922434, 1, 'binary.ryfAsYaeEOkhesQMRitO', 'nchar.台湾省玉华县徐汇杨街C座 637917', 1630000000061) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630915000001, -1403755208, -3324715225642465377, -15193, -53, -3142.782618, 1794554.528658, 1, 'binary.aOAYKsmWzKDqjOpbOYrJ', 'nchar.河北省倩市清河黄路t座 205485', 1630000000062) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630915000001, -361144599, -8536611280568601202, -8124, -93, -13513340.923311, -20153.231767, 1, 'binary.XgncJmqFHazSpRWcMVeT', 'nchar.澳门特别行政区帅县清城深圳街j座 501390', 1630000000062) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630915000000, 929886382, 6830786048646808920, -26587, -84, 201249126.540132, -33020.844039, 0, 'binary.kUqBGPosKRCkaijDufGt', 'nchar.陕西省澳门市蓟州祁路C座 345922', 1630000000061) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630930000000, 1849726714, -3222927126454669927, 21701, 35, -764955573301.579956, -677588544809.604004, 0, 'binary.mXWIcnTunwqEKbKnJsRO', 'nchar.青海省云县南湖张路t座 577114', 1630000000062) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630930000000, 1948380077, 1829472867218108411, -2841, 62, -585408.996552, -8.398878, 0, 'binary.fZDJrrryXodeitdEZiDN', 'nchar.天津市辽阳市平山深圳街O座 892463', 1630000000062) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630929999999, 215833483, 6741487167704692542, 24982, 99, 7.720103, -4484984.118093, 1, 'binary.PUhvTciOFJERTXpNFDMf', 'nchar.海南省雪梅县萧山夏路s座 884246', 1630000000062) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630930000000, 283066224, 1560470331627072050, 2152, 14, 23735906455.603001, 977.642371, 1, 'binary.LQZzMIDAEVyjgirFHORu', 'nchar.河南省秀梅县房山黄街D座 578931', 1630000000062) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630930000001, -1383444081, -404967010555838935, -20478, -67, -29413948653.431301, 2289249875341.339844, 1, 'binary.gGaUfmagkabfKeDUnCCo', 'nchar.江苏省冬梅县六枝特张路g座 635526', 1630000000063) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630930000001, -821980909, -1357071288288006358, -23706, -57, 6152.175178, -26066560.757762, 1, 'binary.kmxekdKOIgvNnCSEZlwN', 'nchar.上海市宜都县双滦王路P座 262541', 1630000000063) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630930000000, 713911469, -6504806039884313820, -32386, 118, 431693877138.190002, 7127294.830732, 0, 'binary.FArXPzfLVQjsNuWiHLrQ', 'nchar.宁夏回族自治区秀华县长寿钟路t座 443656', 1630000000062) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630945000000, 1000635145, -6949456453535507535, -32142, 99, -7613228535871.339844, 5.367833, 0, 'binary.yafjOZqJhdMZFCxrvkjO', 'nchar.天津市志强县上街陈路g座 745449', 1630000000063) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630945000000, 2094975637, -590793247049504295, 92, 70, -846255.238019, 37.423177, 0, 'binary.IBHCEHNtLvmkpSCmVjQg', 'nchar.台湾省桂芝县华龙合肥路b座 733142', 1630000000063) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630944999999, 792673522, 2133996305758691365, 11545, 90, 8043187112236.719727, -328687222.743009, 1, 'binary.ZJIzomZBnRwLgnTtcylc', 'nchar.安徽省波市清河卢路e座 142743', 1630000000063) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630945000000, 1815853908, 1589355425036470987, 22184, 52, 8.753561, -0.772172, 1, 'binary.eqnhiDmrJHLxSTqywNzp', 'nchar.广东省合山市朝阳佛山街y座 254118', 1630000000063) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630945000001, -1908151355, -8449086371025617726, -31176, -107, -226488394.744318, 522688593.135097, 1, 'binary.mOQahkNsfbxPPiCysDOX', 'nchar.新疆维吾尔自治区潜江县魏都昆明路q座 187031', 1630000000064) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630945000001, -177205853, -5927588760169982955, -1616, -89, -3.764988, 22268450673521.398438, 1, 'binary.dIMAiZxTGtcVSpGTvrOy', 'nchar.重庆市南昌市房山上海街U座 493109', 1630000000064) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630945000000, -271977227, -4833640128107527469, -29661, -35, -25823270909397.800781, -215115.472476, 0, 'binary.FJHanbZZKKPTINTvFuJu', 'nchar.山西省太原县普陀海口路z座 522140', 1630000000063) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630960000000, -1061924199, 80315342405283554, -5983, -53, -35303358.173361, 823245211.259967, 0, 'binary.DHcLdCgRElelyoEjXxxo', 'nchar.云南省辽阳县兴山许街Q座 204291', 1630000000064) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630960000000, -2008448047, -2507465824745412203, 5703, 39, 3073425.192830, -4127246.560225, 0, 'binary.PGGakvXluJKSczwfkbFA', 'nchar.内蒙古自治区深圳市涪城韦路L座 184789', 1630000000064) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630959999999, 1731746435, 8656881002710317018, 24493, 42, -51366300790725.398438, 7057719908.426410, 1, 'binary.GcyDiiYlodcmmVYJcfsy', 'nchar.澳门特别行政区萍县长寿淮安路X座 216888', 1630000000064) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630960000000, 1535163067, 199892343902462919, 8312, 26, -5886360.892067, 99168508385732.296875, 1, 'binary.NajqJanSydLerCaBsTFl', 'nchar.西藏自治区六安县魏都邹路E座 600769', 1630000000064) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630960000001, -1744206201, -5989201622885398375, -9394, -16, -22156768397.647999, -313965437.622286, 1, 'binary.ljgVmLXQbdPjEOYMKEmN', 'nchar.辽宁省玉兰市新城邵街T座 422511', 1630000000065) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630960000001, -416139810, -6604173252994763764, -6397, -53, 826553399123.199951, 28094588.168751, 1, 'binary.hcinwRrwHHsWiQqvAaPk', 'nchar.山西省兰州县永川张家港路l座 400205', 1630000000065) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630960000000, 1411363822, -5559490192650806316, -24296, -124, -84520160618.765900, 48233.620153, 0, 'binary.duMCmTwWDPUzYzHdZrXk', 'nchar.海南省建国市萧山朱街m座 337644', 1630000000064) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630975000000, 63717118, -1781107297269354794, 14103, -107, 4455585.961990, -65419.341974, 0, 'binary.BlHycIqcHPSyynpSsDHt', 'nchar.广西壮族自治区桂芝市西峰史路K座 709908', 1630000000065) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630975000000, -108473967, 5316060064111515170, 7075, -74, 673543603.332905, 8011713.391465, 0, 'binary.ZsNVSCEilaFozvIMOgVn', 'nchar.山西省秀兰县萧山惠州街s座 291738', 1630000000065) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630974999999, 1701097332, 6995506575159608552, 22867, 47, 4495217807.100080, 38.526985, 1, 'binary.VTDyicwtvKBaCCmjUaDu', 'nchar.吉林省天津县长寿宜都路k座 930822', 1630000000065) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630975000000, 257457420, 8835364401886927960, 21297, 21, 0.844779, 716050955.344671, 1, 'binary.TCUqNtJoXousOXFzOaFV', 'nchar.湖北省旭县花溪宋街n座 825626', 1630000000065) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630975000001, -622389272, -4556948567877249858, -30519, -93, 3.569778, -2781.981860, 1, 'binary.SSnWtedSkSpZxzvsXKty', 'nchar.西藏自治区兴安盟县静安哈尔滨街c座 120405', 1630000000066) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630975000001, -84782654, -8863584638236264237, -5954, -44, -220.796336, 81484582682754.296875, 1, 'binary.tQzwvVqEIsBAxnymBEia', 'nchar.甘肃省永安市江北南昌街u座 555029', 1630000000066) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630975000000, -7406744, 4193139347325385474, -9523, 51, 96.656028, -858851298.663605, 0, 'binary.QfqialqEnUJEPhCtbzcy', 'nchar.青海省敏县淄川卢路v座 513752', 1630000000065) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1630990000000, 1127802865, 3673503514622188410, -1852, -113, -34837378.663679, -77832209110.181000, 0, 'binary.rdtbEFZKYFDDJcbwZQUI', 'nchar.上海市潮州县友好辽阳街J座 716345', 1630000000066) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630990000000, 222250382, 7102048992271642834, 30230, 0, -27475250902790.601562, -7.875430, 0, 'binary.okaTayFnJLFHVPbosPMw', 'nchar.湖北省娟县六枝特郑州街o座 923846', 1630000000066) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630989999999, 997138993, 291600547682899796, 8706, 49, 527231819.674759, -76.470030, 1, 'binary.gSCVCKyayTuQHeyozlnD', 'nchar.澳门特别行政区太原县江北六盘水路E座 813817', 1630000000066) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630990000000, 1527492158, 8131177329340856446, 16932, 24, -485902.216583, 47420.341433, 1, 'binary.xIJLktMoyieUcwAitKAf', 'nchar.广西壮族自治区丽娟县永川钱路D座 710055', 1630000000066) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630990000001, -1186362057, -8101517704046664109, -8133, 0, 15457163.632735, 790549863.502675, 1, 'binary.domgcCyjkvkGvnfhJchV', 'nchar.安徽省台北县蓟州张路V座 853541', 1630000000067) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630990000001, -2038096305, -9196878310965066696, -9437, -7, -8043032690399.879883, -3.291758, 1, 'binary.OXzBvNftjfwTqreAuCzo', 'nchar.台湾省西安市西夏贵阳路b座 196727', 1630000000067) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1630990000000, 22826804, -2627900666391071715, -20499, 51, 21.403443, -394389822812.973999, 0, 'binary.abnUGmLKuAKIaCxUeyBU', 'nchar.海南省玉珍县房山罗街t座 776991', 1630000000066) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631005000000, 808597268, 2078929531741697152, -30212, 18, -94851063704.977005, -73674.167661, 0, 'binary.hsfTIdNWdxTPvUwMVrpW', 'nchar.江西省桂荣市清河通辽路U座 806067', 1630000000067) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631005000000, -915524872, -8857255033160626964, 266, 91, 11153.892476, -331797474.177709, 0, 'binary.KRBAAEghraBqMLVZKLxR', 'nchar.河南省成都县浔阳傅路o座 233168', 1630000000067) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631004999999, 2045109124, 8620061599081376707, 21842, 65, -577475988406.473022, -230.252609, 1, 'binary.BdfsaHZLBvLoViCnpcaf', 'nchar.重庆市敏市涪城张街Y座 339115', 1630000000067) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631005000000, 667151973, 2042134679839477524, 30807, 18, 410455086008.659973, -111467516118.406006, 1, 'binary.MRXRSCLnwHZQLMuEpxxc', 'nchar.上海市秀英县南长南京街E座 857787', 1630000000067) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631005000001, -1754458857, -2336346102444691323, -21518, -78, -35328084917.622902, 6799588.766270, 1, 'binary.XKvGUqmEfwrFunqrTSnZ', 'nchar.广东省广州县西夏梁路f座 812202', 1630000000068) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631005000001, -1198184531, -2273612721150875492, -27273, -110, -5590.967174, -36.872012, 1, 'binary.mVuGzysfOhHacpboXfya', 'nchar.澳门特别行政区合肥市怀柔淮安路Q座 830162', 1630000000068) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631005000000, -806268791, 6849292639236533681, -6170, -10, 67.282833, 189646569.949903, 0, 'binary.TDFoHEPsCyCFagPtryZJ', 'nchar.云南省彬县淄川潮州路h座 848046', 1630000000067) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631020000000, -1073614153, 298267925059640970, -26581, 48, -95632.677072, -4.716783, 0, 'binary.VHldMJRfKiPhYVUwVuHn', 'nchar.黑龙江省南宁县清城曾街M座 383184', 1630000000068) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631020000000, 199565482, -5346899860399957284, -803, 119, 641654.245772, 6.968944, 0, 'binary.CdEpJsyAmonutUDWmrxV', 'nchar.山西省龙市新城任路n座 477007', 1630000000068) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631019999999, 117798603, 420439377677612553, 9253, 22, -1137.400660, -4635970947.218740, 1, 'binary.NJEFxITOCrCDbopXNjvy', 'nchar.广西壮族自治区通辽市华龙柳州路J座 634352', 1630000000068) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631020000000, 1124688237, 3000258188050272185, 14502, 16, -74396554878085.203125, -9.906537, 1, 'binary.sIxumMWCehMDSrpZPLqj', 'nchar.上海市峰县双滦荆门街i座 639698', 1630000000068) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631020000001, -1012596446, -5485827047721236689, -13273, -79, -85711452679.407806, -9188.884106, 1, 'binary.vCyjrKXeBvkNVeElgyZi', 'nchar.湖北省明县沙市武汉街E座 620206', 1630000000069) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631020000001, -460195462, -2468912047516302638, -8474, -48, 1519432858382.800049, 17871.504434, 1, 'binary.dixQMmtXAeagNODPIEEv', 'nchar.上海市阳市平山龚街J座 946821', 1630000000069) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631020000000, 1852200026, -6007978387233236224, 8798, -115, 421576343321.414001, 19100383480.317001, 0, 'binary.iRZrrVUoaDQXPuJZnyDI', 'nchar.贵州省南昌县合川成都路a座 820810', 1630000000068) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631035000000, -1253564785, 9123919785095917881, -15701, 31, -186733280.924988, -61.177294, 0, 'binary.NgOZqYryGuLTQMouuNHu', 'nchar.天津市鹏市沙湾兰州街O座 549919', 1630000000069) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631035000000, -1657246812, -4709259982252400503, -17351, -53, 81659768.995530, -7671201354.697040, 0, 'binary.nzcJiagtuSvVewKFNcaK', 'nchar.上海市天津市城北福州路U座 681143', 1630000000069) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631034999999, 1413434601, 2190691240505370364, 11770, 93, 3703815955153.799805, 8268264767.279480, 1, 'binary.oIubCOjKHdxCpeWbqIpp', 'nchar.陕西省秀华市徐汇合肥街s座 902856', 1630000000069) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631035000000, 1217613348, 7975114090727787456, 13738, 43, 355726833911.968994, -438162359629.995972, 1, 'binary.uLWXXVcGhcuWJiRaByBZ', 'nchar.河南省福州市东丽徐路w座 747585', 1630000000069) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631035000001, -2146084891, -23804698624528061, -29407, -115, 3824609640014.350098, -67783404809047.703125, 1, 'binary.RnZVUuAxugAtOZSTEkkn', 'nchar.青海省北京市门头沟陈路Q座 257513', 1630000000070) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631035000001, -1123855083, -2174482244567720750, -12610, -101, -13889290720.493999, -44730168.376831, 1, 'binary.bKiOAOxQmTuUxvfbdpdl', 'nchar.宁夏回族自治区坤市锡山宁德路j座 838367', 1630000000070) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631035000000, -1406844909, 6947966913619883113, -6412, -80, -5.700965, -15608.263924, 0, 'binary.ShuwgacOGYsjNECdcUUt', 'nchar.河北省婷市浔阳南宁路D座 449083', 1630000000069) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631050000000, 1665571243, 5875622308303693056, 26189, -3, 9184334500122.300781, 692.411491, 0, 'binary.mkdoDznGUjHxCWsEReic', 'nchar.天津市明市翔安王街K座 149828', 1630000000070) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631050000000, -866699485, 5150552413312365721, -26931, -72, 304388231344.469971, 1887123.429534, 0, 'binary.gXoNDsUhSIxwTtChSVKC', 'nchar.广东省阜新市牧野何街b座 893235', 1630000000070) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631049999999, 1647088140, 6276524783005291573, 18506, 126, 520220.525305, -11656506505.388300, 1, 'binary.uFvJUrDBxvRNfycpsATy', 'nchar.广西壮族自治区春梅县新城梧州街p座 914349', 1630000000070) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631050000000, 110172144, 3880079542176303291, 7450, 60, -70101821.922084, -766086105.175900, 1, 'binary.sGupuerrJMrewABhIOQF', 'nchar.重庆市永安市孝南东莞街p座 524436', 1630000000070) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631050000001, -2334950, -9174808951498480949, -25376, -56, -706896093828.322021, -7054905528.909860, 1, 'binary.eAsXnsSVfXpwSeWxjIep', 'nchar.新疆维吾尔自治区婷县清城李路R座 863352', 1630000000071) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631050000001, -1709242287, -1024364150913211829, -18517, -95, 612563.744410, 71675616881.702698, 1, 'binary.xwUGLqzyDiIWFYjQChPb', 'nchar.澳门特别行政区建国市东城汕尾街H座 310414', 1630000000071) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631050000000, -1438324283, -2616966529186093777, -15740, 119, -7052.121172, 6.860693, 0, 'binary.gwSKZcnvepcSGvGhQIhU', 'nchar.江苏省娜县安次长春街b座 373327', 1630000000070) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631065000000, 1572844268, 7954082573907623254, 28743, -77, 526200414.754712, -610.377887, 0, 'binary.dhmqewaCwxuZgymXkJYg', 'nchar.甘肃省六盘水市高坪刘街K座 997983', 1630000000071) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631065000000, -1997711328, -8305458100196327173, 15855, 65, -1.591103, 978771.885779, 0, 'binary.ErzqbmUDFqGBseJATzNB', 'nchar.福建省邯郸市龙潭天津路S座 700145', 1630000000071) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631064999999, 118186835, 7105850083426581209, 23043, 123, -294186.598870, 631977325.777490, 1, 'binary.jZYzFZwYbBOMfCYxLkEu', 'nchar.北京市宜都县山亭福州街B座 229199', 1630000000071) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631065000000, 84760302, 4023057210065827734, 20658, 50, -374538737.396905, 2.546280, 1, 'binary.GrfdYDSeONBkUWnVxrIE', 'nchar.重庆市关岭县兴山荆门街i座 354010', 1630000000071) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631065000001, -31117145, -6368825817854208301, -4679, -13, -193.784819, 9941696226439.189453, 1, 'binary.DtkHUqQYbIbRkWfoerGJ', 'nchar.湖南省建国市六枝特广州路d座 104163', 1630000000072) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631065000001, -1214911170, -3868394291968674672, -20441, -79, 567.284011, -99982135106.938004, 1, 'binary.LThAPucPiLueKWedudxF', 'nchar.青海省海门市牧野淮安街D座 825707', 1630000000072) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631065000000, 1697187351, 530203760413095118, -17911, -116, -501.905581, 98.459334, 0, 'binary.mEMXftUdsHdFpIbnKRsd', 'nchar.宁夏回族自治区峰市平山王街M座 201716', 1630000000071) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631080000000, 1610525794, -5290794365132208573, -15731, 123, -335854906.304436, -24139226804197.199219, 0, 'binary.daKMhFVbQQZKGiTKOlls', 'nchar.新疆维吾尔自治区坤市牧野武汉路f座 977660', 1630000000072) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631080000000, 1087333161, 2572492011929726786, 25923, -25, -4763484.301768, -5226373.298693, 0, 'binary.mmMznhJKAQPTjucpnZSc', 'nchar.澳门特别行政区杭州市南湖大冶街g座 395605', 1630000000072) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631079999999, 579193173, 5793829126142110648, 4490, 80, 78951.390551, 19287929360.243801, 1, 'binary.MUCIKFgmyfodWgXzBwpA', 'nchar.台湾省淮安市上街海门街G座 209332', 1630000000072) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631080000000, 1885599296, 5754849838280444727, 16958, 107, -53.481198, -9.937711, 1, 'binary.BrUGLflxCuUJqYeSVVsN', 'nchar.吉林省刚市高明夏路B座 373737', 1630000000072) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631080000001, -718949368, -4253205043582583806, -12561, -68, -134568795933.429993, -71046052762709.500000, 1, 'binary.gOwViQPVHLSImYonXzkV', 'nchar.台湾省红市永川六盘水路m座 707904', 1630000000073) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631080000001, -1419546071, -5628013404742242442, -19653, -61, 4641210572.820400, -516.363302, 1, 'binary.OhALrYMiHXSjCpcdfoPs', 'nchar.甘肃省玉华县高坪长沙路K座 553129', 1630000000073) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631080000000, 1801658141, 3654105358778411870, 18529, -80, 8.652081, -1554626.681517, 0, 'binary.GyuqMCRbacNJHUbGmkXh', 'nchar.台湾省芳市安次薛街o座 207547', 1630000000072) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631095000000, 2136843976, -1210226910088276755, 20600, 23, 539871237741.179993, 49233075000.644600, 0, 'binary.CoZYsjGjLcrAfxoNvULS', 'nchar.山东省嘉禾县平山呼和浩特街F座 641469', 1630000000073) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631095000000, 486220117, 2599712669438010104, -6519, 47, -0.673515, 55.218328, 0, 'binary.hUsJbjOwNFjCpNXnLWPF', 'nchar.广东省六安县秀英上海路E座 148463', 1630000000073) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631094999999, 17707398, 8375178158416972213, 1322, 112, -62111552150188.000000, -3.488348, 1, 'binary.iibUAdMnGmuQRjnCboca', 'nchar.海南省澳门市萧山冯路k座 476673', 1630000000073) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631095000000, 1540458244, 8608337136208602956, 13530, 122, -258.798333, -18390773070513.101562, 1, 'binary.dKifdiuRtzPzgDOgwskf', 'nchar.西藏自治区成市江北丁路k座 811706', 1630000000073) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631095000001, -295978274, -3611928104731611403, -928, -29, -349214171411.169983, 627603759.980824, 1, 'binary.tPAAsLZTOrrgDWhhbvPA', 'nchar.河北省深圳市和平李街k座 107359', 1630000000074) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631095000001, -1110370293, -2926428742790858456, -4685, -42, 594526965.911060, 979845489.815900, 1, 'binary.KCwadhHtPeNvxeOTurpC', 'nchar.四川省桂香市城北张路Z座 135595', 1630000000074) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631095000000, 1016372608, -248268842333445258, -24994, -40, -855742777.413557, 412898933.803171, 0, 'binary.oektpgoczIFkPkMZhePp', 'nchar.四川省楠市锡山王街T座 347259', 1630000000073) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631110000000, 1618012586, -4877738856165917254, -14321, -36, -2.446783, -8386.899686, 0, 'binary.cGuZNtDbGSgYATZIfhUQ', 'nchar.湖南省军县闵行沈街e座 942969', 1630000000074) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631110000000, 336517476, -2851549763879094055, 24260, 42, -284453185.760948, -82312598023267.500000, 0, 'binary.nNUcWFSnghHEXoJZyLSZ', 'nchar.台湾省玉英市海陵广州街D座 932017', 1630000000074) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631109999999, 325913454, 4965185676452141874, 1927, 45, 928.161230, 5002796.693905, 1, 'binary.KPSdukhCAQdFSCjoAXyb', 'nchar.天津市嘉禾市和平王街Y座 800951', 1630000000074) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631110000000, 2115611339, 5603712632691054487, 2040, 92, -88631.744485, -33319292708726.398438, 1, 'binary.nDvmXubKLBkwjQvBrowE', 'nchar.广西壮族自治区合山市大兴邯郸街C座 120130', 1630000000074) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631110000001, -416517208, -3563087064047686173, -32590, -97, 804.877418, -8174392626838.679688, 1, 'binary.yJGXGtGzgxaoyzDFNKzn', 'nchar.新疆维吾尔自治区建平市龙潭曹街X座 409242', 1630000000075) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631110000001, -1502953470, -2238010217654677886, -11068, -38, 69129137.954435, 599892.899153, 1, 'binary.OdnrQcfrzxIUYGMYkhgP', 'nchar.上海市霞县南溪曾路b座 536348', 1630000000075) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631110000000, 451771496, -7517497607249821959, -32099, -92, -213627.556542, -8726497.619554, 0, 'binary.DhxlHgZRZtmSyyhkGtuW', 'nchar.云南省洁县滨城梁路p座 996135', 1630000000074) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631125000000, 32878642, 8801402285444036889, 21539, 48, -596417925905.134033, 373248896.126035, 0, 'binary.RjzhwvLAyYAYYCfkjFJj', 'nchar.重庆市超县梁平温街z座 283315', 1630000000075) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631125000000, 71147814, -5159443215460099961, -15082, 102, 5968659.321019, -26592.753571, 0, 'binary.CljlscxcGjjciERgOxKg', 'nchar.宁夏回族自治区玉梅县吉区海口路d座 230176', 1630000000075) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631124999999, 1015662815, 4795567142964951653, 7167, 1, 325791556.701457, -143633938642.838013, 1, 'binary.JHrHPuhooNwLgDYQlFil', 'nchar.上海市玉华市门头沟长春街L座 619720', 1630000000075) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631125000000, 785489232, 7788643811202703115, 31943, 105, -9652684.346045, -250.125950, 1, 'binary.FkrDvYiLeZOqRVvYQpJr', 'nchar.贵州省璐市永川长沙街K座 573245', 1630000000075) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631125000001, -370350844, -2328721985404462718, -8114, -97, -65.996745, -23054596683.701000, 1, 'binary.YpDtIgmdxGtGOlkpYQbb', 'nchar.吉林省潜江市普陀哈尔滨街G座 354284', 1630000000076) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631125000001, -1104506218, -4613678193581849079, -1965, -116, 67350915247071.203125, -124.355022, 1, 'binary.cGsEpboYJbYsTSnKYKUz', 'nchar.宁夏回族自治区贵阳市永川刘街l座 557372', 1630000000076) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631125000000, -1975758915, -7017697117625132855, -2347, -78, 13301869.493635, 734276825210.396973, 0, 'binary.JMTLLJHKsHvKhVKhxUdD', 'nchar.湖北省淑华县上街郑路d座 249081', 1630000000075) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631140000000, -638220498, 7787936362129921947, 2622, -93, 80359528.879084, -6439.177632, 0, 'binary.KYZqgXaxguXpZiDTipOe', 'nchar.云南省台北县翔安淮安路T座 548657', 1630000000076) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631140000000, 1695929408, 6613622196219250257, -19521, 126, -294182.533903, 872281666.129710, 0, 'binary.bxqGrgGKqftbTFsJVxse', 'nchar.陕西省长春县梁平重庆街f座 969435', 1630000000076) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631139999999, 910799127, 3748990393909505200, 19872, 110, -1.774037, 962.107067, 1, 'binary.SMVCQwJbrLKRzlPTMAle', 'nchar.广东省淮安县南长陈路r座 442094', 1630000000076) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631140000000, 82578099, 1083300683395237822, 14840, 49, -2897441254294.259766, 78241.170285, 1, 'binary.zRnJDsiOdVdrjyezgNqk', 'nchar.新疆维吾尔自治区欣县上街郑州路T座 334404', 1630000000076) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631140000001, -1933040168, -8697939131006546022, -21092, -35, -3404654038.996900, 64905.498178, 1, 'binary.VlVdAdmtswNJQrRzSAPQ', 'nchar.河南省辽阳县长寿兴安盟路C座 114674', 1630000000077) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631140000001, -472785311, -4446555925790326535, -23024, -3, 430107081.785272, -5.140820, 1, 'binary.NUAVJEKQvBvlnJToDnoJ', 'nchar.河北省金凤县双滦石家庄街D座 264667', 1630000000077) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631140000000, -1325721293, 1101829200999493900, 13912, 72, 151194.856760, 931990832.169087, 0, 'binary.siTpYJVsmIUfmSUiacBG', 'nchar.海南省六盘水市房山重庆街R座 786868', 1630000000076) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631155000000, -622133611, 4304164307993590613, -1028, -75, -794.965943, 7129885424.126380, 0, 'binary.PxLiilJCeaWfrPEPswvJ', 'nchar.辽宁省齐齐哈尔县秀英王街V座 753913', 1630000000077) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631155000000, 601975873, -8460674145788246343, 26537, -18, -117.582363, 4.278494, 0, 'binary.DIEUsVGrYCIYpOHOMbYp', 'nchar.青海省玉市高港六安路n座 697115', 1630000000077) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631154999999, 794346686, 2813747690977192290, 19623, 118, -592938779870.880981, -691339105509.250000, 1, 'binary.IkXhYGsGOuGyQXxMcENO', 'nchar.新疆维吾尔自治区兴城市白云海门街z座 410778', 1630000000077) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631155000000, 2077153378, 6007901518953365006, 32590, 25, 8269699092873.599609, -3523058497792.450195, 1, 'binary.zDNlRsoVabJhMNFJfTBy', 'nchar.江西省冬梅县永川王路R座 198556', 1630000000077) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631155000001, -969135765, -1764680015243416710, -27020, -59, -8.491632, -14661.965520, 1, 'binary.jnObVGyDvkIgXvnFpKMn', 'nchar.广东省南宁县涪城沈阳路O座 754414', 1630000000078) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631155000001, -1576113711, -3627767440156041231, -18534, -66, 495.121273, 53596032.859107, 1, 'binary.lOIexILoDTNYoRmKXkCf', 'nchar.西藏自治区瑜县海港史路q座 848639', 1630000000078) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631155000000, -1548677743, -6457865964462190618, 21103, -53, -421862729108.307983, -2360116167608.370117, 0, 'binary.ZmmTgtzFlywNsFIAjzDE', 'nchar.台湾省秀荣市高港高街E座 134599', 1630000000077) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631170000000, 749993747, 3019243752157013695, -17619, 43, -1469831614725.439941, -6462342550.269600, 0, 'binary.PTOhqXMEYVQUAwAPztJg', 'nchar.广东省哈尔滨市花溪深圳街S座 621146', 1630000000078) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631170000000, 256334370, -4650384778595555945, -7069, 22, 596577877.192931, -70129653418.844894, 0, 'binary.zWNroTXoIVAfFKMCHdqU', 'nchar.广西壮族自治区梧州县崇文张路j座 870677', 1630000000078) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631169999999, 366270121, 4191114768474723941, 28897, 88, 36764251.456900, -819995344305.519043, 1, 'binary.KMQKIVvLXKZtzgvGXoZV', 'nchar.上海市深圳市朝阳王路c座 308052', 1630000000078) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631170000000, 904819741, 5165411582118084217, 22379, 49, 5.680573, -23448296491.688702, 1, 'binary.RksynZHDBofeCbnNeueF', 'nchar.西藏自治区秀兰县永川武汉街f座 720233', 1630000000078) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631170000001, -406248475, -3565233828007899422, -28694, -119, 6468114.299821, -9139.276334, 1, 'binary.yDkbSjlEhWxgIdEKjdyw', 'nchar.陕西省明市东丽郭街X座 797325', 1630000000079) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631170000001, -110865946, -7795005438146655234, -26791, -6, 614284367.384455, 50856740.580794, 1, 'binary.tpgIuOiJsKacrUZBOcHs', 'nchar.北京市太原县大兴高路N座 354025', 1630000000079) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631170000000, 1503400003, -80780332688017476, 31847, -84, -1188729980516.979980, 2115639995.697030, 0, 'binary.zMhdERtluQHYrYkarBsp', 'nchar.西藏自治区沈阳市沈河兰路O座 514687', 1630000000078) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631185000000, -703829541, -3015290584870545849, -26195, 25, 65051636.569539, -1355107949.868670, 0, 'binary.pFxWRymlGotRbPxBaKqU', 'nchar.重庆市拉萨县孝南刘路P座 393437', 1630000000079) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631185000000, 322375238, -6241662551377872210, 7578, -41, 9181.469818, 58823.373155, 0, 'binary.yeTYMVojTpBxHFVbiTVH', 'nchar.贵州省天津市吉区潜江街E座 745985', 1630000000079) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631184999999, 901680081, 2918745868131285426, 1954, 123, 799091.717635, 19529.323662, 1, 'binary.HriCdYQCgMqDJrsEPvId', 'nchar.香港特别行政区伟市蓟州崔路h座 182270', 1630000000079) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631185000000, 959830805, 8687660735074694942, 30908, 121, -56072935323.713600, -66360254180.759499, 1, 'binary.hnKLmxkdGfJPtsNffUnx', 'nchar.重庆市云市孝南深圳街D座 180484', 1630000000079) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631185000001, -88966985, -1936037048857392721, -18099, 0, -824204261009.363037, 1697.886509, 1, 'binary.pfXnsxKPgpyOLUjhDIlh', 'nchar.青海省辛集县东丽拉萨街Q座 914524', 1630000000080) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631185000001, -156903452, -7204919546158466118, -26775, -7, 3343624886104.990234, 25.895039, 1, 'binary.DVJPFxpqidEqIbsMkqvk', 'nchar.河南省桂香县普陀合山街y座 473206', 1630000000080) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631185000000, 242951644, -6425706509022302444, -115, -95, -7428172351326.129883, -243792.108001, 0, 'binary.XYfDpoamFuPazIzqqvyQ', 'nchar.江苏省六安县沙湾沈阳路D座 111215', 1630000000079) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631200000000, 917616213, -6105526769675738367, 16833, -4, -912283922.301867, -626.880806, 0, 'binary.UJhwYiRGgenyykMzvCIG', 'nchar.陕西省慧市沈北新台北街V座 622592', 1630000000080) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631200000000, -1010524677, -2564524247724824015, -31994, -48, 478258495629.161011, -2756525.506410, 0, 'binary.JqnispIFJYlFtxhJzBtt', 'nchar.贵州省梅市上街福州路U座 843893', 1630000000080) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631199999999, 1676885574, 5801667850572164138, 9268, 5, 81943569878020.000000, -2651878397664.700195, 1, 'binary.tJnMwFImycFDwadSKvfB', 'nchar.西藏自治区邯郸市东城刘路G座 620688', 1630000000080) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631200000000, 202560740, 8585057740824701967, 2754, 102, 4256312.669784, 2841641554.533030, 1, 'binary.iZuBXyHivNVGIECkZpgp', 'nchar.青海省北镇市永川广州路t座 650954', 1630000000080) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631200000001, -1469589614, -6328986345920555773, -13057, -114, 7124.472347, 1922792124.232900, 1, 'binary.IttYeshrxTWRQzrMpNEl', 'nchar.江苏省呼和浩特市大东钟路V座 373715', 1630000000081) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631200000001, -635536894, -7540406212992578302, -356, -42, 7506079.766892, -846620.925646, 1, 'binary.FBEKhNRXwVaIefMjxKLw', 'nchar.重庆市马鞍山市金平孔路A座 105425', 1630000000081) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631200000000, -1786041154, -5812150165598736743, 31691, -112, -99.932548, -78491263.832105, 0, 'binary.EeccUPRfABMAdtMqrUTP', 'nchar.海南省鑫市西夏兴城街R座 301651', 1630000000080) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631215000000, -1625191731, 6167214474139728168, 11139, 121, -94335581842.567902, 3059478274.613470, 0, 'binary.ZxUIonzZMsBhCCWqYrmZ', 'nchar.天津市拉萨县萧山上海路d座 252099', 1630000000081) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631215000000, -47135681, -6436433940308594642, -21351, 98, -8067393645072.580078, -55.209057, 0, 'binary.wklKlUzIzCbSAlTVhPtf', 'nchar.江西省通辽市西夏曾街D座 770856', 1630000000081) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631214999999, 1572527931, 6199432476029588286, 15047, 53, -329811.437951, -690962.952604, 1, 'binary.VQbrSGdoLASviEaZfVKb', 'nchar.河南省磊市城东曹路Y座 412471', 1630000000081) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631215000000, 1025618009, 8668297953739699167, 6895, 36, 809883.310963, -1830.234393, 1, 'binary.bSASugSRycgShDfZVaRz', 'nchar.天津市亮县江北潜江街S座 540483', 1630000000081) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631215000001, -256464376, -896102382541120115, -19194, -122, 4123590577424.399902, 2656422.305476, 1, 'binary.CyxinbAlvUlbbQCMCmuX', 'nchar.青海省东莞市蓟州叶路g座 257461', 1630000000082) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631215000001, -425746119, -8056851883105951074, -32462, -51, -590076.331164, 324718675328.812988, 1, 'binary.MqmXkQoSJpKeTWWfLSjQ', 'nchar.青海省宁市高坪何街L座 312122', 1630000000082) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631215000000, -1005159716, 5814777795009857976, -20922, -120, -5.121036, 72269204554.118393, 0, 'binary.krPFwdRphWiLhiLWffGj', 'nchar.云南省太原市翔安叶街s座 968090', 1630000000081) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631230000000, 300807334, -1393720031020538944, -10631, 114, -7497311.501447, -7843875.126062, 0, 'binary.gUfZXmtuaUyEMqvzCGVT', 'nchar.甘肃省潮州市海陵张路j座 111530', 1630000000082) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631230000000, -61728336, -6277168556471947655, -14631, 121, 108260.570588, -6225158.445263, 0, 'binary.wjIFBHVvPkzNnyfFqcez', 'nchar.内蒙古自治区小红县锡山张路q座 451673', 1630000000082) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631229999999, 456695922, 6065595906254092225, 13855, 95, -9.750988, 52263.948430, 1, 'binary.HpsqFduULuvFgUNWLaIS', 'nchar.上海市辽阳市友好宜都街J座 260640', 1630000000082) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631230000000, 1314422800, 2343245198878315836, 4530, 110, 5.523721, 52.963146, 1, 'binary.BqILcPWCGdFitnkIUITX', 'nchar.黑龙江省萍市兴山香港街w座 689416', 1630000000082) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631230000001, -1404438854, -6648294746644259055, -29920, -45, -4879.347387, -397204029.641602, 1, 'binary.hWYLNHYZihIwrBwiQKLu', 'nchar.内蒙古自治区大冶县上街谢街p座 354579', 1630000000083) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631230000001, -1560018283, -8582655292633538077, -7916, -9, -813743561.246321, 180605419479.515991, 1, 'binary.rBKhOAPgsFlVbktylkBZ', 'nchar.海南省贵阳县新城张家港路o座 184911', 1630000000083) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631230000000, -1185224620, 3781565114446947943, -32425, -124, -966176.836584, -6194.817285, 0, 'binary.MAHjOJrSnXwRnDjhjhgs', 'nchar.湖北省哈尔滨县璧山嘉禾路W座 107867', 1630000000082) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631245000000, -629005742, 2962477037931783881, 30753, -22, 97626628.877839, -55509075810587.898438, 0, 'binary.bHeXAGMGzghlOuWCGmyS', 'nchar.内蒙古自治区荆门市上街王路f座 313159', 1630000000083) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631245000000, 1289038189, 208643021208222754, 24329, -84, 528626.682214, 4631263449.782700, 0, 'binary.VBcGIQKGeBlgodeKkqIO', 'nchar.天津市梅县孝南许街M座 955579', 1630000000083) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631244999999, 1089857524, 8092714018391461421, 30637, 62, 822.840197, 86578529728.784698, 1, 'binary.ReHWrHhhULYKBWJbDHAl', 'nchar.安徽省合肥县大兴太原街z座 183173', 1630000000083) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631245000000, 1508646219, 5498801626248258629, 6153, 2, -6981.974013, -1.262354, 1, 'binary.rKJJrwLYFsmeLilRmdII', 'nchar.云南省秀英市静安罗路N座 799241', 1630000000083) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631245000001, -1072147772, -6285554104164008129, -13029, -38, 399653108.497808, 9.954981, 1, 'binary.CrzTcvxjDbWSNGHlnGgZ', 'nchar.福建省文市沙市聂路v座 919011', 1630000000084) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631245000001, -1744587122, -4289304118779607521, -3261, -49, 578908.973758, -3283275.161042, 1, 'binary.hnKdQBaXRtRTvdBMxxki', 'nchar.四川省秀荣市江北韩路N座 794727', 1630000000084) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631245000000, -1768419964, 6812389139494481536, -22315, 57, -3991350668.256720, 272847.980876, 0, 'binary.eaKoadYSnHxIAwGvMADW', 'nchar.内蒙古自治区颖市城北呼和浩特路M座 270782', 1630000000083) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631260000000, 62032825, 2419036897017949691, -18301, 34, -34067326787.909401, -4490033.331223, 0, 'binary.vcjOGKOcKjTDVUVgwDDP', 'nchar.福建省太原县上街宁街J座 989695', 1630000000084) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631260000000, -955905466, 8811462063140315136, -25829, 76, 4112554.855015, -353081090.814735, 0, 'binary.sjVkMmweDnQHqIahYBJg', 'nchar.宁夏回族自治区佛山市清浦陈街C座 507576', 1630000000084) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631259999999, 1740302532, 7618062051313344766, 24234, 108, 19.258022, -481986511.838220, 1, 'binary.FHckvgRsNysvnrkBnxPi', 'nchar.河北省丽华市朝阳龚路E座 249405', 1630000000084) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631260000000, 25207874, 8557074180207725958, 5121, 76, -27.837670, 7472.845942, 1, 'binary.yuETGYVvdZgoTrKTDVlM', 'nchar.甘肃省红霞市牧野关岭街C座 146380', 1630000000084) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631260000001, -368156241, -8290129222861749037, -32369, -87, 8778614.707332, -8.396911, 1, 'binary.oTlXrpmNqzuPQFtdJXAL', 'nchar.广东省淑珍市东丽周街e座 132961', 1630000000085) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631260000001, -1391854623, -5255734908673798063, -25898, -63, 6.380914, -981.272293, 1, 'binary.fRTcoeHlACSZuECHxLsF', 'nchar.西藏自治区兴城市东丽惠州街w座 939232', 1630000000085) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631260000000, -1478713358, -7256379885586266224, 7456, -127, 39.210475, -37429036261.203003, 0, 'binary.iLHDKCeEycRrHQjdctpP', 'nchar.贵州省琴市锡山嘉禾街V座 586837', 1630000000084) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631275000000, 1637182628, -7252330432834078022, -13577, -34, -21982.383242, 851033.725636, 0, 'binary.qbwfbTcZcBXRYDFLPsYc', 'nchar.西藏自治区香港县门头沟袁路c座 659900', 1630000000085) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631275000000, -226012380, 714907917095146625, 26998, 45, -378863.223518, 63837840.367547, 0, 'binary.wLhqoOhYDhOLDWgTquSO', 'nchar.广东省淮安县城东惠州街H座 226497', 1630000000085) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631274999999, 1196830217, 7803469523299853932, 4057, 68, -72455041894.121094, 31008329.254161, 1, 'binary.tnTDmSbUwexajzyGQKbU', 'nchar.天津市桂香市海港邱路v座 930985', 1630000000085) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631275000000, 1896164509, 1992693218102163749, 20742, 127, 3279876658623.740234, 97971293613823.203125, 1, 'binary.EwwiwjOJeqmxqOmBSCvF', 'nchar.宁夏回族自治区秀英县高坪银川街T座 599205', 1630000000085) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631275000001, -238216455, -6595002088264755363, -17352, -35, 30291122943460.601562, -523766877.255375, 1, 'binary.JiuAgoqIJOWzLvLnmvBq', 'nchar.四川省六盘水市梁平佛山街Y座 160978', 1630000000086) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631275000001, -1959680714, -5838771977352828969, -30312, -80, -40302216017.319298, 65262645551.558701, 1, 'binary.kKcTvQecUQcVNHCxdbMq', 'nchar.吉林省亮市海陵汕尾街y座 455171', 1630000000086) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631275000000, -1454514443, 2104326254606882084, -3977, 31, -10.683775, 8146970744.319100, 0, 'binary.baHWrZaiEoVOFqPQVViT', 'nchar.上海市明市锡山台北街g座 112480', 1630000000085) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631290000000, 202676239, -997640316674086097, -22675, 17, -597819.667252, -989103790.253560, 0, 'binary.rdoqbRUQFOZbxDrDpEXv', 'nchar.福建省斌市清河刘路r座 438569', 1630000000086) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631290000000, 274493417, -5455741168804436813, -27247, -111, 9288775.263537, -3826.901732, 0, 'binary.eWJNzFpYfQFYqDTlVEuS', 'nchar.广西壮族自治区深圳市海陵邓路e座 598287', 1630000000086) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631289999999, 995318978, 44640273583296417, 14989, 72, 86411387362.516006, -21052069.696864, 1, 'binary.WhVBrissKQCBrAUpwRHT', 'nchar.陕西省桂香市清浦米街p座 269494', 1630000000086) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631290000000, 2136730540, 5315445691851854143, 14450, 103, -6335650603.174980, 501305134.199676, 1, 'binary.zljXuXtZduZhLQoCTEYI', 'nchar.辽宁省凯县西夏太原街R座 148010', 1630000000086) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631290000001, -1917806640, -4720258233332513149, -31214, -45, -8113.185976, -82050.442684, 1, 'binary.dwHmbtStCEgnJspmTqwD', 'nchar.新疆维吾尔自治区桂芝县长寿巢湖路A座 782531', 1630000000087) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631290000001, -981665942, -278699770296496646, -13050, -47, -41130.414162, 453641642.546780, 1, 'binary.BkkbbPyxvTkDiTzQpRiV', 'nchar.浙江省合肥市东城成都路c座 895347', 1630000000087) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631290000000, -834112430, -6635305571569691219, -19258, 73, 919646.148350, 321.289191, 0, 'binary.XzCcSXArLMKFLjFRyHJe', 'nchar.上海市阳县崇文丁路I座 548147', 1630000000086) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631305000000, -568876147, 4115921496929882007, 21876, 118, -766463785.889029, -63.898006, 0, 'binary.WPbsfDfyJKEoZCpyfhuq', 'nchar.青海省贵阳市大兴彭街W座 571855', 1630000000087) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631305000000, -1963919658, -7528759656724736232, -15462, -49, 82.771605, 228.648728, 0, 'binary.gvsIwjOVqnvwPYubIriV', 'nchar.浙江省合肥县蓟州蒋路s座 450606', 1630000000087) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631304999999, 862001048, 8289879675128879554, 10897, 54, -31560046.871248, -2510800476075.919922, 1, 'binary.ZakYSeKJSEQfAnbEPpdl', 'nchar.湖南省秀华市锡山牟街K座 639697', 1630000000087) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631305000000, 1928593809, 5104651015083770612, 32255, 58, 804488379.612065, 9429749762380.500000, 1, 'binary.wgTbKbFYQRosfKvUQSkH', 'nchar.重庆市桂珍市梁平乌鲁木齐街N座 153448', 1630000000087) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631305000001, -1547198379, -350643391542151214, -13828, -103, 64477812.167046, -2903.526723, 1, 'binary.vJieiALrJbMqqRhnMbqe', 'nchar.澳门特别行政区丹丹市丰都南宁街Q座 989300', 1630000000088) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631305000001, -134242385, -3869570405276188197, -32581, -104, 43107832.702441, 44056.657014, 1, 'binary.IkbIEnMQPVXBWOjcanNo', 'nchar.香港特别行政区东莞县丰都朱路U座 249243', 1630000000088) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631305000000, -597984033, -3361517834367129147, 75, -104, -7409.500037, -91.360942, 0, 'binary.TNnOUCoNllHJVskqaqWO', 'nchar.上海市玉梅市和平李街k座 583138', 1630000000087) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631320000000, 904033245, 1599598424557218108, -30005, -24, 4541.289136, -54.239926, 0, 'binary.iEBPEAmKXlpBUXwoALUt', 'nchar.吉林省刚县璧山刘路g座 682546', 1630000000088) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631320000000, -2079364817, -654287221384079565, 15782, -26, 748.766841, -4.965685, 0, 'binary.WEJkxJeFLZZByzCPoRdY', 'nchar.福建省太原县永川兴城街w座 961260', 1630000000088) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631319999999, 526847966, 5775445950760637967, 14304, 60, 81172141354.356293, 870255843.925099, 1, 'binary.MdntNFfvvyCStMNHBKIQ', 'nchar.广西壮族自治区合肥县西夏刘路q座 990741', 1630000000088) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631320000000, 537739308, 5090468389474927294, 22579, 33, 3433128.844123, 3872298849645.379883, 1, 'binary.abGKYFWBPWLVPYEvggCd', 'nchar.陕西省马鞍山市海港韩路B座 339379', 1630000000088) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631320000001, -795092969, -3711201539316715587, -11107, -98, -286579.413055, -3.739221, 1, 'binary.thHeWmYWAcgObBqqwqqB', 'nchar.四川省成县大东张街u座 740678', 1630000000089) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631320000001, -1559644142, -9027525835433685991, -2711, 0, 5557460.651989, -40007573640075.203125, 1, 'binary.NglLAfkhOUvNACXvlutl', 'nchar.西藏自治区丽市兴山萧路O座 326707', 1630000000089) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631320000000, -1107831086, -1823478878718094475, -27832, -90, 99212399503.662796, -74696134214106.500000, 0, 'binary.drlMMrbdDWnwUwkvFszC', 'nchar.青海省利市西夏辛集街A座 820543', 1630000000088) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631335000000, -1747665689, -3268703357637921126, -3204, 118, -7.843951, 5236837072088.639648, 0, 'binary.fKLvQiBIrygGolyqKaVe', 'nchar.福建省淮安县金平海口街k座 430777', 1630000000089) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631335000000, -828294034, 2657326032914454094, 21837, 8, -69702504398061.000000, -4450579.238900, 0, 'binary.esplmUmrLBFMyAKMDAzP', 'nchar.福建省北镇市兴山长沙路D座 908303', 1630000000089) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631334999999, 1804609738, 6857866489996684420, 32112, 37, -2477401204.802390, -3021.525948, 1, 'binary.DCLURcwhhaDhNKDcTLYq', 'nchar.安徽省西宁县江北郑州路R座 729863', 1630000000089) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631335000000, 437917493, 1733585568524751775, 14155, 38, 3358226.279225, -1184.537102, 1, 'binary.KYgSrTTQzSmndNwhbsxY', 'nchar.黑龙江省丽丽县双滦包路i座 494311', 1630000000089) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631335000001, -1727537263, -5460926119155540560, -9690, -95, 9289065.542646, 7.188845, 1, 'binary.yMKTfSNsTiIkXhhIQCtC', 'nchar.新疆维吾尔自治区柳州县东丽高街d座 298894', 1630000000090) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631335000001, -2120093363, -4777070161903130182, -8197, -30, -383000.885433, 9678.947342, 1, 'binary.xYtVuqPnZXiCBdRdskEu', 'nchar.海南省沈阳市大兴邓街P座 552544', 1630000000090) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631335000000, 1750088050, 3697839127781862571, -675, -53, -99724.435061, -28255356.108959, 0, 'binary.ZoJveGLeqQgcoitfoHqY', 'nchar.广东省丽丽市城北呼和浩特路P座 380188', 1630000000089) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631350000000, 1880035325, -4802629856794707608, 22068, 100, 718062376.187030, -506130.634445, 0, 'binary.CfGiHufKQulMxwAItOfy', 'nchar.山西省想市黄浦邯郸路X座 818941', 1630000000090) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631350000000, 165546984, -6984734151301447256, -16166, 96, -1236884449.480500, -639029206.988874, 0, 'binary.AvOGTRfAVrYaxEAHhJKk', 'nchar.四川省坤市清河文街M座 728309', 1630000000090) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631349999999, 1514387404, 2958688219263646841, 21127, 20, -46918158932248.000000, 2353213017.825450, 1, 'binary.bfrSvHvqHlFluwivEgxS', 'nchar.山西省玉市白云马街p座 592361', 1630000000090) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631350000000, 697337569, 7135356390013225753, 32569, 116, -6611897.211005, -1.935866, 1, 'binary.ETaNjgpPPzwvOkzPbLMs', 'nchar.台湾省敏市朝阳余路L座 739835', 1630000000090) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631350000001, -1737290956, -4744278138504720755, -23704, -13, -20682554.975530, -5505407.317856, 1, 'binary.lqhFKjcHzvbkdWVoYtwW', 'nchar.河南省兰英县朝阳天津街A座 102658', 1630000000091) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631350000001, -1792783313, -6546177515445472740, -17996, -82, -2785.518995, 406175.862275, 1, 'binary.ZSgzqADQgOFLGnOSTTgl', 'nchar.云南省丽华县浔阳黄街u座 463279', 1630000000091) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631350000000, 1675171705, 4482392883505129283, 3877, 60, -529410318.578000, 87242703.165205, 0, 'binary.pPrjATzIWSjGnAQlByfg', 'nchar.澳门特别行政区玉珍县南溪刘路J座 234624', 1630000000090) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631365000000, -120996932, 7464290233605180116, -21030, 89, -7265.737889, 38451.519083, 0, 'binary.NdYvAIsMTcBJbRZBuEMZ', 'nchar.四川省成都县六枝特武汉路u座 796761', 1630000000091) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631365000000, 1626331139, -3444691871293469179, 1200, 69, -2719528.747073, 35.186089, 0, 'binary.SfqGXOabBHmYWmwbjAmD', 'nchar.江西省彬县清浦丁街f座 768134', 1630000000091) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631364999999, 1201642931, 3048123187871650645, 5183, 51, 5407076381615.250000, -94.505271, 1, 'binary.pCxeaejTSQlmBlttHhTg', 'nchar.江苏省六盘水市兴山宋街z座 229812', 1630000000091) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631365000000, 606859861, 3791676681420995058, 12977, 20, -11.820203, -60910962808.638702, 1, 'binary.dkXKTqEjhmKoFQauhwjf', 'nchar.甘肃省慧县淄川何街t座 472618', 1630000000091) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631365000001, -639050810, -5288142338710158760, -32726, -35, 1750485995849.620117, -5947212091.364470, 1, 'binary.hQfgaAPxYdJOaIkPUQJT', 'nchar.甘肃省宁德县孝南北京街f座 436022', 1630000000092) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631365000001, -592064320, -9093756286157608735, -19004, -37, -60515553533903.898438, 4852.484564, 1, 'binary.DyLlxTKVpmVQoztjwPWn', 'nchar.辽宁省武汉县徐汇王路u座 155320', 1630000000092) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631365000000, -168837427, 5524670347645121945, -687, 105, -33530.533779, -857595946215.329956, 0, 'binary.dWHryceFSxVdkHDrNfYa', 'nchar.山东省博市六枝特银川路k座 264255', 1630000000091) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631380000000, -144505842, 9031683748543148709, 30839, 37, 75951623525931.296875, -356608030036.447021, 0, 'binary.YAmFEuHOeLIMgXCOGnRf', 'nchar.黑龙江省秀珍市白云广州街Z座 558462', 1630000000092) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631380000000, -202930007, 2539365322373297240, 30035, -11, 3987179954447.959961, 166663.706087, 0, 'binary.aQPbQkWFDKuugEWfofTC', 'nchar.陕西省建国市江北阜新街O座 931583', 1630000000092) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631379999999, 340191939, 190224560698109215, 7127, 125, 41587961603.659103, -37646578.644303, 1, 'binary.ZClsyheJcXtiVXWSTmJC', 'nchar.内蒙古自治区南京市吉区海门街X座 981848', 1630000000092) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631380000000, 1141439964, 5703107595817904511, 17318, 70, 20244282326280.398438, -374.976792, 1, 'binary.ECmfqstJJJGVfXRSlipY', 'nchar.山东省秀珍市长寿嘉禾街H座 668408', 1630000000092) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631380000001, -822942850, -5193915838519507313, -6726, -109, 12.862186, -308.656139, 1, 'binary.fiNIskGvJlLuWiySSzcR', 'nchar.辽宁省太原市合川沈路K座 765732', 1630000000093) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631380000001, -1084726805, -1799418590653312591, -316, -61, -43.289435, -5628.101135, 1, 'binary.nYWtrJedHHgNuftngNzv', 'nchar.福建省小红市沈北新王街j座 802142', 1630000000093) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631380000000, 2145419646, 1580239203992480528, -14574, 100, -94259.299402, 2214154.396490, 0, 'binary.GZbUYTSXnACDqnrhbNFC', 'nchar.青海省淑华市沙湾阜新路Q座 663492', 1630000000092) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631395000000, -752146752, 8221071117818639487, -24048, -125, -4922542596.502000, 69.541336, 0, 'binary.DpfvmRBpvyGTcVOJPyJo', 'nchar.江西省刚县房山安街D座 955283', 1630000000093) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631395000000, -878950287, -8422331468601695661, -13558, 43, 339844.201301, 9.764866, 0, 'binary.RefVNTHmgyVTPXRzLkLd', 'nchar.浙江省马鞍山县海陵王街B座 867693', 1630000000093) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631394999999, 1783522942, 6078410931639616068, 9495, 98, 727091818.991834, 8165776010706.599609, 1, 'binary.dtkNAQMwyepAJbdqweVh', 'nchar.河北省天津市沈河贵阳街N座 113675', 1630000000093) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631395000000, 1165805677, 1114429668955803199, 26742, 75, 965648.432436, 67940.285447, 1, 'binary.STtpcklCmoPcTqcnVEYp', 'nchar.湖北省荆门县静安拉萨街x座 767367', 1630000000093) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631395000001, -1314056119, -4268557454181639559, -17681, -70, 9569.520951, -3.709641, 1, 'binary.eAxSwIhCTWRsxHmnyhOO', 'nchar.四川省建华县沙市沈阳路f座 959538', 1630000000094) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631395000001, -1195931348, -3234878011308908109, -8224, -81, 68272155.434104, 2277301.750441, 1, 'binary.cCbIERRNYVmzqgdEkLyn', 'nchar.宁夏回族自治区长春市山亭海门路i座 441560', 1630000000094) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631395000000, 1044986483, 708621525043415947, 23174, 25, -87522059062286.000000, 91518.977374, 0, 'binary.KWZOCXHGUnswxAQvgLbX', 'nchar.甘肃省上海市大东合肥路v座 576201', 1630000000093) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631410000000, -883689952, -6467532462337897809, -20092, 56, 2802216728037.279785, -9.303156, 0, 'binary.qwPhaldJXqLHFGOeyrHw', 'nchar.甘肃省南宁市孝南彭街T座 566484', 1630000000094) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631410000000, 972297407, -5877490557670044529, -27447, 44, 40.846479, -4231.348093, 0, 'binary.DwlvVHWtVzbpJAeCWIMr', 'nchar.山西省莹县魏都张街A座 689281', 1630000000094) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631409999999, 1032579814, 2390187777440316314, 19171, 78, -63005465989151.203125, 5961100651288.120117, 1, 'binary.VAqPpjxEFxcYSxnzUAwL', 'nchar.贵州省辽阳县静安安街c座 964229', 1630000000094) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631410000000, 241342224, 8497667456001609204, 18172, 104, -906790925488.797974, 36707840437.474998, 1, 'binary.FLLdUdBRMRgvzrMSflyN', 'nchar.甘肃省哈尔滨县翔安拉萨路L座 242629', 1630000000094) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631410000001, -1560976462, -1082805904642279032, -24035, -84, 5518722837.437610, 99553268986.260300, 1, 'binary.yXYqlIPBknzcrQaHQVBK', 'nchar.山西省福州县白云乌鲁木齐街I座 977466', 1630000000095) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631410000001, -1279270656, -127272614642938342, -18488, -105, 820203443079.204956, -39324.928647, 1, 'binary.vcWaeUuquQmpiNmaMFTJ', 'nchar.重庆市红市友好张家港街h座 853577', 1630000000095) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631410000000, -810546809, 4707087124402946180, 14228, -33, 401.288641, -573136.630366, 0, 'binary.oglpZSvAEAkKdUTqMhCy', 'nchar.安徽省大冶县锡山高路Q座 272097', 1630000000094) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631425000000, -1291692620, -3976582859582309880, 99, -107, -643212263540.171997, 91650599.279398, 0, 'binary.QtWoywiZBLMnNCtJddrC', 'nchar.海南省凤英市新城单路Y座 332919', 1630000000095) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631425000000, -1636741671, 6149617241982859450, -29331, -23, 53068143981197.398438, 507.769638, 0, 'binary.rwiKvwHMRitScXUVmJhW', 'nchar.陕西省辛集县清浦李路H座 631016', 1630000000095) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631424999999, 2070489093, 3407988531094502611, 31121, 105, -797.417546, -5114.871991, 1, 'binary.VKDzqKpnljjtWvPxhJtw', 'nchar.台湾省淑英县黄浦齐齐哈尔街c座 143348', 1630000000095) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631425000000, 1536720383, 3880153804085171184, 11796, 82, 45989.231323, 92.649541, 1, 'binary.tbEDrcIJyjZTjRieTqRC', 'nchar.上海市北镇市怀柔阜新路R座 405512', 1630000000095) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631425000001, -955300022, -7851370978801274222, -14072, -90, -91217.776216, -9476202.110944, 1, 'binary.wYLmyHTheIfPsDKWcbvP', 'nchar.河南省丹市金平潮州路n座 514612', 1630000000096) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631425000001, -1019361248, -57576815854175575, -24873, -4, -32984292266917.800781, 58.748899, 1, 'binary.HNDdWAeDLFDTfTKRiPvW', 'nchar.云南省桂芝市长寿王街C座 833966', 1630000000096) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631425000000, 1923224809, -2907800501658168815, -9896, 49, -33656345.811017, -671677543.932121, 0, 'binary.PJVocGHwGGXYBPOAxHSo', 'nchar.内蒙古自治区柳县崇文王街n座 759363', 1630000000095) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631440000000, 1147520901, -7715180528849786436, -17616, -76, 6.545288, -50974540.927085, 0, 'binary.vSYpvPIBkKueVfRtelNq', 'nchar.江西省亮市孝南合肥路t座 737452', 1630000000096) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631440000000, -113454687, -5823484358741527503, 28969, 121, -64687699.492563, -79961693.274913, 0, 'binary.eNlgFeimPdtilNzjMToG', 'nchar.辽宁省通辽县东丽廖路E座 551853', 1630000000096) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631439999999, 1457091374, 8334151643776472564, 2662, 82, 323215.440926, -9805209441096.250000, 1, 'binary.rMLCVjMtmxFxYRYbvQQh', 'nchar.安徽省武汉县城东萧路w座 417063', 1630000000096) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631440000000, 199139943, 2468266181580361696, 6282, 45, 938749.350559, -728777906039.301025, 1, 'binary.QCaxrlOInebbkEcnmLYI', 'nchar.天津市拉萨县魏都李街D座 325624', 1630000000096) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631440000001, -1074274106, -6116630471404653549, -13682, -70, 513137.327759, -588918896.561140, 1, 'binary.TyKIxNLJfeZgAKvWAFfB', 'nchar.海南省济南县闵行西宁路m座 451609', 1630000000097) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631440000001, -565301435, -4026730978460667946, -19020, -77, -8.983572, -43.480820, 1, 'binary.ydTJczfbrhMoGjzUmQfP', 'nchar.香港特别行政区柳州市璧山张家港街l座 596812', 1630000000097) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631440000000, 625692002, -7425751090292284243, 10228, 1, 750.678719, -90.988373, 0, 'binary.xzExJqxxmHYoAUDKciSV', 'nchar.湖北省婷县龙潭兰州街n座 199763', 1630000000096) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631455000000, 2072736931, -3329284412762274677, 12268, -69, 5910.358156, 997044108049.300049, 0, 'binary.aBqZKnHzsSpmRSwSQPYY', 'nchar.山西省郑州市孝南王路e座 167062', 1630000000097) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631455000000, 1463682034, 990280305241763342, -3488, 89, 419973.481918, -55750492618.939903, 0, 'binary.OybEvgqNWyaCiEEvxpeR', 'nchar.青海省荆门县孝南东莞路a座 305732', 1630000000097) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631454999999, 1438955591, 8811422557823062850, 15737, 98, 1754297.282564, 567752594.816600, 1, 'binary.OMjmDDXPGGJaZZRMlpqF', 'nchar.上海市台北市黄浦周街v座 378966', 1630000000097) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631455000000, 1828878609, 7873820745339300844, 23138, 106, 9.263627, 946712871592.369995, 1, 'binary.wDtceAzvXHGjCqbAGulx', 'nchar.浙江省邯郸县长寿张路V座 106929', 1630000000097) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631455000001, -1388085018, -6219226483229634812, -21928, -116, -896801017371.463989, 91302.519671, 1, 'binary.YMYcdmnGDpGZSmUvXpYa', 'nchar.重庆市刚县江北北镇路o座 294056', 1630000000098) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631455000001, -1225032046, -2776099211554722026, -11329, -26, 22948.709678, -47848.985287, 1, 'binary.muQMoYipLCOlIkSyKxUk', 'nchar.山东省郑州市合川张家港街X座 960693', 1630000000098) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631455000000, 1161217978, 1842781937217393115, 17682, -46, 286163234.229566, -2.426507, 0, 'binary.CRKBkwUTzvgcBPDSNWiy', 'nchar.广西壮族自治区浩市安次苏街L座 929528', 1630000000097) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631470000000, -821482750, -6759948063516530731, -16375, 89, -84205.305774, 768242.497026, 0, 'binary.vMJVGyqMTgaGrLmmbZIE', 'nchar.天津市琴市江北孙街m座 262672', 1630000000098) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631470000000, 717271992, 7986931673188494197, -9479, 52, 4711.839591, -5371732.797787, 0, 'binary.kPRwzfEKYpYgWRWaeGzP', 'nchar.重庆市乌鲁木齐市闵行南京路R座 883727', 1630000000098) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631469999999, 1077620215, 2558543784745208971, 25857, 52, -47179130892.244499, -20848774363.230000, 1, 'binary.BQGtKbxrxZCgjfTUjLJe', 'nchar.黑龙江省岩市海陵天津街v座 971806', 1630000000098) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631470000000, 1977913093, 3861242852069723630, 20743, 59, 9464902993.309589, -5024.160475, 1, 'binary.lzQOJDAUyRQtQDjNrWZJ', 'nchar.甘肃省齐齐哈尔市华龙沈阳街I座 777477', 1630000000098) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631470000001, -428527206, -547566441621156192, -12808, -31, -74278620895119.906250, 50537841781.787697, 1, 'binary.FkYBhPfxSWPoKPiVwaNT', 'nchar.吉林省南宁市平山张路Z座 293046', 1630000000099) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631470000001, -1181912125, -427873392135772867, -13447, -55, 3457499617.219500, -7038680.198896, 1, 'binary.ozhZqPebRJOHopCsXWpU', 'nchar.上海市伟市闵行北京街i座 107708', 1630000000099) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631470000000, 744599275, 5384505142686943052, 30013, -71, -4.424027, -5.984967, 0, 'binary.RcgJmYOFSSkGHfTHlqvY', 'nchar.陕西省东县大东窦路E座 174935', 1630000000098) ;''')
        tdSql.execute(f'''insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts) values(1631485000000, -1492370578, 4514526083062070789, 31730, -102, -717.383970, 52910.663266, 0, 'binary.jsHQYTHKPARRqiGzZKOz', 'nchar.澳门特别行政区邯郸县丰都宋街W座 598200', 1630000000099) ;''')
        tdSql.execute(f'''insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631485000000, 963480452, 5458394487863298148, -21434, 125, -1656.168120, 5768934065.605500, 0, 'binary.rCnbtltacJIWEVZWlXVF', 'nchar.湖北省合肥县龙潭马路o座 149144', 1630000000099) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631484999999, 224551324, 4933122153940335639, 2537, 23, -4225000.312926, -7035665314327.099609, 1, 'binary.RgTacOhlKMDWwPcrKsZK', 'nchar.山西省杭州市长寿沈阳街K座 225610', 1630000000099) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631485000000, 336564804, 2661017413987846119, 26066, 127, 2271.487346, 26543272352747.398438, 1, 'binary.FKgzwzTQzUHULzcaEmAd', 'nchar.贵州省成都市清河李路w座 620531', 1630000000099) ;''')
        tdSql.execute(f'''insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631485000001, -1922225927, -8001645480178976724, -25777, -111, -789464.882012, -360094093.372387, 1, 'binary.pxrkoGUZiddEAkYHiVjK', 'nchar.湖北省太原市永川吴路b座 333484', 1630000000100) ;''')
        tdSql.execute(f'''insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631485000001, -1213998634, -4431806460604559923, -22976, -105, -49517009982577.796875, -959039647940.217041, 1, 'binary.VxnbNGXEiRmRkEseJUFg', 'nchar.西藏自治区张家港县浔阳张路z座 876862', 1630000000100) ;''')
        tdSql.execute(f'''insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts) values(1631485000000, -1591388398, 1970187840324683506, 20196, -59, 28171713.207903, 6.598821, 0, 'binary.fDSGiJNSRdOTovcESQFl', 'nchar.山西省梅市沙市王街r座 815669', 1630000000099) ;''')
        tdSql.execute(f'''flush database table_lastrow_2_2;''')

    def basic_query(self):
        # TD-23175
        tdSql.query(f'''select _wstart, LAST_ROW(q_float) from stable_2_1 where  q_ts <= now +1h and  _C0 <= now +1h and    q_bool in (0 , 1)  interval(11s) order by ts''')
        tdSql.checkRows(100)

        # TD-23178
        tdSql.query(f'''select count(*) from (select LAST(q_tinyint) from stable_2 where   q_ts between 1600000000000 and now +1h  interval(12s) sliding(3s)  order by ts)''')
        tdSql.checkData(0, 0, 400)
        tdSql.query(f'''select count(*) from (select LAST(q_tinyint) from stable_2 where q_ts between 1600000000000 and now +1h interval(12s) sliding(3s) order by ts)''')
        tdSql.checkData(0, 0, 400)

        # TD-23173
        tdSql.query(f'''select _wstart,_wend,LAST_ROW(q_nchar) from stable_1 interval(17d) sliding(5d) order by _wstart;''')
        tdSql.checkRows(7)
        tdSql.checkData(0, 2, 'nchar.安徽省玲市西夏海口街o座 109427')
        tdSql.checkData(1, 2, 'nchar.黑龙江省芳县海陵贺路c座 606589')
        tdSql.checkData(2, 2, 'nchar.江苏省冬梅县六枝特张路g座 635526')
        tdSql.checkData(3, 2, 'nchar.甘肃省宁德县孝南北京街f座 436022')
        tdSql.checkData(4, 2, 'nchar.湖北省太原市永川吴路b座 333484')
        tdSql.checkData(5, 2, 'nchar.湖北省太原市永川吴路b座 333484')
        tdSql.checkData(6, 2, 'nchar.湖北省太原市永川吴路b座 333484')

        tdSql.query(f'''select _wstart,_wend,LAST_ROW(q_nchar) from stable_1 where q_ts between 1600000000000 and now +1h interval(17d) sliding(5d) order by _wstart;''')
        tdSql.checkRows(7)
        tdSql.checkData(0, 2, 'nchar.安徽省玲市西夏海口街o座 109427')
        tdSql.checkData(1, 2, 'nchar.黑龙江省芳县海陵贺路c座 606589')
        tdSql.checkData(2, 2, 'nchar.江苏省冬梅县六枝特张路g座 635526')
        tdSql.checkData(3, 2, 'nchar.甘肃省宁德县孝南北京街f座 436022')
        tdSql.checkData(4, 2, 'nchar.湖北省太原市永川吴路b座 333484')
        tdSql.checkData(5, 2, 'nchar.湖北省太原市永川吴路b座 333484')
        tdSql.checkData(6, 2, 'nchar.湖北省太原市永川吴路b座 333484')

        # TD-23222
        tdSql.query(f'''select LAST_ROW(q_tinyint) from stable_2 where  q_ts between 1600000000000 and now +1h  and  _c0 <= now +1h and  (q_nchar like 'nchar%' or q_binary = '0'  or q_nchar = 'nchar_' ) and (q_bool = 0 or q_bool = 1  or q_bool is null) interval(15a,9a);''')
        tdSql.checkRows(100)

    def run(self):
        self.prepare_data()
        self.basic_query()


    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
