/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 466
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int8_t yy27;
  ENullOrder yy89;
  int64_t yy129;
  SToken yy233;
  SAlterOption yy257;
  bool yy397;
  EJoinType yy428;
  EFillMode yy646;
  SNodeList* yy776;
  int32_t yy832;
  SDataType yy852;
  EOperatorType yy856;
  EOrder yy870;
  SNode* yy924;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             737
#define YYNRULE              557
#define YYNTOKEN             326
#define YY_MAX_SHIFT         736
#define YY_MIN_SHIFTREDUCE   1090
#define YY_MAX_SHIFTREDUCE   1646
#define YY_ERROR_ACTION      1647
#define YY_ACCEPT_ACTION     1648
#define YY_NO_ACTION         1649
#define YY_MIN_REDUCE        1650
#define YY_MAX_REDUCE        2206
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3084)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   141, 2182, 1923, 2079,  477, 2177,  478, 1686, 2006,   35,
 /*    10 */   286,  166,   45,   43, 1576,  378, 1758, 1921,  613, 2002,
 /*    20 */   375, 2181, 1425,  160, 1857, 2178, 2180, 1123, 2020, 1857,
 /*    30 */   355,  342, 1806, 1506, 2123, 1423,  354,  589, 1580, 1855,
 /*    40 */  1855, 2177,   38,   37, 1450, 1855,   44,   42,   41,   40,
 /*    50 */    39, 1650, 1998, 2004,  357,  601,  588,  181, 1501, 2038,
 /*    60 */  2120, 2178,  590,  636,   18, 1450, 1125,  604, 1128, 1129,
 /*    70 */   625, 1431, 1988,  349,  642,  130,  129,  128,  127,  126,
 /*    80 */   125,  124,  123,  122,   45,   43,  139,   44,   42,   41,
 /*    90 */    40,   39,  375,  165, 1425, 1662,   14,  483,  338,  625,
 /*   100 */   589,  626, 2019,  479, 2177, 1506, 2055, 1423,  611,  108,
 /*   110 */  2021,  646, 2023, 2024,  641,   54,  636, 1210,  733,  588,
 /*   120 */   181,  178, 2182, 2108, 2178,  590, 2177,  369, 2104,   60,
 /*   130 */  1501, 1450, 1804, 1508, 1509,  350,   18,  348,  347, 1535,
 /*   140 */   518,  183, 2181, 1431,  520, 1923, 2178, 2179,   85, 2134,
 /*   150 */   265, 2116,  600, 1212,  132,  599, 2006,  366, 2177, 1425,
 /*   160 */  1920,  613,  135, 1481, 1491, 1450,  519, 2002,   14, 1507,
 /*   170 */  1510, 1799, 1423,  588,  181,   48, 1851, 1852, 2178,  590,
 /*   180 */   531,  530,  529,  628, 1426, 2080, 1424, 1482,  136,  525,
 /*   190 */   733,   64,  486,  524,  478, 1686, 1536,   49,  523,  528,
 /*   200 */  1998, 2004,  370, 1434,  522, 1508, 1509,   60, 1431, 1429,
 /*   210 */  1430,  636, 1480, 1483, 1484, 1485, 1486, 1487, 1488, 1489,
 /*   220 */  1490,  638,  634, 1499, 1500, 1502, 1503, 1504, 1505,    2,
 /*   230 */  1142,  579, 1141,  495,  380, 1481, 1491, 1850, 1852,  277,
 /*   240 */   278, 1507, 1510,  121,  276,  219,  120,  119,  118,  117,
 /*   250 */   116,  115,  114,  113,  112,  733, 1426,  584, 1424,   38,
 /*   260 */    37, 1143, 1959,   44,   42,   41,   40,   39,   34,  373,
 /*   270 */  1530, 1531, 1532, 1533, 1534, 1538, 1539, 1540, 1541, 1451,
 /*   280 */   184, 1429, 1430,   60, 1480, 1483, 1484, 1485, 1486, 1487,
 /*   290 */  1488, 1489, 1490,  638,  634, 1499, 1500, 1502, 1503, 1504,
 /*   300 */  1505,    2, 1648,   11,   45,   43, 1719,  236, 1348, 1349,
 /*   310 */  1451,  625,  375, 1673, 1425,  585,  580,  574,  612, 1573,
 /*   320 */  2020, 1426,   11, 1424,    9, 1506,  184, 1423, 1250,  668,
 /*   330 */   667,  666, 1254,  665, 1256, 1257,  664, 1259,  661,  626,
 /*   340 */  1265,  658, 1267, 1268,  655,  652, 1429, 1430,  184, 2123,
 /*   350 */  1501, 2038,  601,  131, 1437, 1857,   18, 1988,  184,  643,
 /*   360 */   516,  680,  363, 1431, 1988,  493,  642, 1916,  390,  177,
 /*   370 */  1804, 1855,  531,  530,  529, 2119,   45,   43, 1511, 1449,
 /*   380 */   136,  525, 1844,  139,  375,  524, 1425,   48,   14, 1902,
 /*   390 */   523,  528, 1365, 1366, 2019,  105,  522, 1506, 2055, 1423,
 /*   400 */   189,  108, 2021,  646, 2023, 2024,  641,  626,  636,  140,
 /*   410 */   733,  142,  565,  148, 2079, 2108, 2177, 1796,  220,  369,
 /*   420 */  2104,  186, 1501, 1293, 1294, 1508, 1509, 1643, 1364, 1367,
 /*   430 */    85, 2183,  181,  170,  184, 1431, 2178,  590, 1804,  512,
 /*   440 */   508,  504,  500,  217,  545,  175,  603,  179, 2116, 2117,
 /*   450 */   626,  137, 2121, 1800,  626, 1481, 1491,  543, 1857,  541,
 /*   460 */    46, 1507, 1510, 1651,  418,   38,   37, 1907,  131,   44,
 /*   470 */    42,   41,   40,   39, 1856,  521, 1426, 1453, 1424,  554,
 /*   480 */    86, 1804,  733,  215,  121, 1804, 1887,  120,  119,  118,
 /*   490 */   117,  116,  115,  114,  113,  112,  476, 1508, 1509,  481,
 /*   500 */  1692, 1429, 1430,  175, 1480, 1483, 1484, 1485, 1486, 1487,
 /*   510 */  1488, 1489, 1490,  638,  634, 1499, 1500, 1502, 1503, 1504,
 /*   520 */  1505,    2, 1642,  678,  345, 1906,  485, 1481, 1491,  481,
 /*   530 */  1692,   38,   37, 1507, 1510,   44,   42,   41,   40,   39,
 /*   540 */   626,  367,  153,  152,  675,  674,  673,  150, 1426,  163,
 /*   550 */  1424,  214,  208, 1781,  419, 1431,  213, 1603, 1806,  491,
 /*   560 */    38,   37, 2038, 1572,   44,   42,   41,   40,   39, 1452,
 /*   570 */   583, 1804,  612, 1429, 1430,  206, 1480, 1483, 1484, 1485,
 /*   580 */  1486, 1487, 1488, 1489, 1490,  638,  634, 1499, 1500, 1502,
 /*   590 */  1503, 1504, 1505,    2,   45,   43,   27,  536,   41,   40,
 /*   600 */    39,   11,  375,   60, 1425, 1795,  576, 1601, 1602, 1604,
 /*   610 */  1605, 2182,  546,  626,  582, 1506, 2002, 1423, 1516,  610,
 /*   620 */  1613, 1916,  245,  612, 1450, 2020,  233,  428, 1452,   38,
 /*   630 */    37,  626, 1857,   44,   42,   41,   40,   39,  438,  368,
 /*   640 */  1501,  539, 2123,   99, 1804,  443,  533,  437, 1855, 1998,
 /*   650 */  2004,  232,  630, 1431, 2080,  268, 2038,  234,  527,  526,
 /*   660 */   636,  678, 1804,  626,  643, 1797,   45,   43, 2118, 1988,
 /*   670 */   621,  642, 1916, 1672,  375,  414, 1425,  444,   46, 1706,
 /*   680 */   153,  152,  675,  674,  673,  150, 2007, 1506,   68, 1423,
 /*   690 */   413,   67,  412,   60, 1804,   91, 2020, 2002,  235, 2019,
 /*   700 */   733,  532, 1142, 2055, 1141, 1636,  167, 2021,  646, 2023,
 /*   710 */  2024,  641, 1501,  636,  267, 1508, 1509, 1988, 1592,  565,
 /*   720 */    88,  333,  151, 2177,  549, 1431,  547, 2038,  704,  702,
 /*   730 */  1998, 2004,  671, 1143,  300,  640,  409, 1834, 2183,  181,
 /*   740 */  1988,  636,  642, 2178,  590, 1481, 1491,  566, 2145,   31,
 /*   750 */    14, 1507, 1510,  193,  184,   38,   37,  411,  407,   44,
 /*   760 */    42,   41,   40,   39, 1402, 1403, 1426, 1482, 1424, 1537,
 /*   770 */  2019, 1975,  733,  267, 2055,   53,  420,  322, 2021,  646,
 /*   780 */  2023, 2024,  641,  639,  636,  627, 2073, 1508, 1509, 1782,
 /*   790 */    82, 1429, 1430,   81, 1480, 1483, 1484, 1485, 1486, 1487,
 /*   800 */  1488, 1489, 1490,  638,  634, 1499, 1500, 1502, 1503, 1504,
 /*   810 */  1505,    2,  693,  331, 1774, 1448,  328, 1481, 1491,  397,
 /*   820 */    33,  736,  451, 1507, 1510,  465,   38,   37,  464,  378,
 /*   830 */    44,   42,   41,   40,   39,  293, 1453,  163, 1426, 1716,
 /*   840 */  1424,   32, 1671,  434,  184,  466, 1806, 1670,  436,  692,
 /*   850 */   174, 1542,  495,    8, 1669, 1668,  726,  722,  718,  714,
 /*   860 */   291,   13,   12, 1429, 1430, 1453, 1480, 1483, 1484, 1485,
 /*   870 */  1486, 1487, 1488, 1489, 1490,  638,  634, 1499, 1500, 1502,
 /*   880 */  1503, 1504, 1505,    2,  672, 1793, 1988, 1848,   38,   37,
 /*   890 */   346, 1988,   44,   42,   41,   40,   39,  106, 1988, 1988,
 /*   900 */   284,  163,  424, 1789,  458,  710,  709,  708,  707,  385,
 /*   910 */  1807,  706,  705,  143,  700,  699,  698,  697,  696,  695,
 /*   920 */   694,  155,  690,  689,  688,  384,  383,  685,  684,  683,
 /*   930 */   682,  681,  462,  622, 2181,  456,  455,  454,  453,  450,
 /*   940 */   449,  448,  447,  446,  442,  441,  440,  439,  330,  431,
 /*   950 */   430,  429,  626,  426,  425,  344,  164, 1549,  607, 1450,
 /*   960 */   388,  306,  197,  196,  626,  520,  605,  387,  271, 1902,
 /*   970 */  2020, 1172,  626,  270,  626,  304,   71, 1779,  494,   70,
 /*   980 */   191,  190,  626, 1804, 1780,  457, 1801,  519,  237,   50,
 /*   990 */  1391,    3,  239, 1667, 2020, 1804,  561,  202,  473,  471,
 /*  1000 */   468, 2038,  565, 1804,  565, 1804, 2177, 1173, 2177,  604,
 /*  1010 */   244,  565,   72, 1804, 1988, 2177,  642, 1666,  626, 1699,
 /*  1020 */  1665, 2183,  181, 2183,  181, 2038, 2178,  590, 2178,  590,
 /*  1030 */  2183,  181,  609,  643,   60, 2178,  590, 1988, 1988, 1664,
 /*  1040 */   642,  534,  381,  626, 2019,  162, 1661,  680, 2055, 1804,
 /*  1050 */   163,  108, 2021,  646, 2023, 2024,  641,  281,  636, 1806,
 /*  1060 */  1569, 1988,   80,  178, 1988, 2108, 1660,  593, 2019,  369,
 /*  1070 */  2104,  596, 2055,  107, 1804,  109, 2021,  646, 2023, 2024,
 /*  1080 */   641, 2020,  636, 1988,  552,  678,  626,  601, 1791, 2108,
 /*  1090 */  1988, 2135, 1659,  601, 2105, 1658, 1128, 1129,  676,  626,
 /*  1100 */   623, 1848, 1482, 1787,  153,  152,  675,  674,  673,  150,
 /*  1110 */  1988, 1902, 2038,  624,   79,   78,  417, 1804,  139,  188,
 /*  1120 */   643,  145,  195,  133,  139, 1988, 1657,  642,  565, 2020,
 /*  1130 */  1804,  670, 2177, 1656, 1857, 1655, 1988,  329,  421, 1988,
 /*  1140 */   405,  379,  403,  399,  395,  392,  389, 2183,  181,  560,
 /*  1150 */  1855,  422, 2178,  590, 1654, 2019, 1653, 1433,  677, 2055,
 /*  1160 */  2038, 1848,  108, 2021,  646, 2023, 2024,  641,  643,  636,
 /*  1170 */  1988, 2128, 1569, 1988, 2197,  642, 2108, 1988,  151, 1988,
 /*  1180 */   369, 2104,  180, 2116, 2117,  184,  137, 2121,  182, 2116,
 /*  1190 */  2117, 2142,  137, 2121, 2020,  626,  225,  592, 1988,  223,
 /*  1200 */  1988,   52,  227, 2019,  626,  226,  151, 2055,  564,  287,
 /*  1210 */   108, 2021,  646, 2023, 2024,  641,   62,  636,  382, 1697,
 /*  1220 */   229,  243, 2197,  228, 2108, 2038, 1804,  231,  369, 2104,
 /*  1230 */   230, 1397,  249,  643, 2009, 1804, 1645, 1646, 1988, 2155,
 /*  1240 */   642,  537, 2020,  151,  633,   47,  274,   38,   37,   69,
 /*  1250 */   149,   44,   42,   41,   40,   39,  151,   13,   12, 1400,
 /*  1260 */    62,   89,   47,  240,   47,  650,  149,  637, 2019, 1600,
 /*  1270 */  1663, 1759, 2055, 2038,  104,  108, 2021,  646, 2023, 2024,
 /*  1280 */   641,  643,  636, 2011,  101,  251, 1988, 2197,  642, 2108,
 /*  1290 */   686,  594,  151,  369, 2104,  134,  608,  597, 1362,  279,
 /*  1300 */  2020, 2148,  618,  283,  572,  149, 1693,  687, 1436, 1243,
 /*  1310 */   262,  218, 1191, 1543,  577, 1492, 2019,  299, 1271, 1275,
 /*  1320 */  2055,  256, 2039,  108, 2021,  646, 2023, 2024,  641, 1189,
 /*  1330 */   636, 2038,  386,  372,  371, 2197, 1911, 2108, 1687,  643,
 /*  1340 */  1845,  369, 2104, 1439, 1988, 1282,  642, 2138, 1280,  602,
 /*  1350 */   264,  261, 2171,    1, 1506,  728, 1432,    4,  154,  391,
 /*  1360 */   396,  343,  194, 1384,  294,  423, 1453,  427,  432, 1912,
 /*  1370 */  2020,  460, 1448,  459, 2019,  445, 1904,  452, 2055, 1501,
 /*  1380 */   467,  108, 2021,  646, 2023, 2024,  641,  461,  636, 1527,
 /*  1390 */   469,  470, 1431, 2197,  199, 2108,  472,  474, 1454,  369,
 /*  1400 */  2104, 2038,  475, 2020,  484, 1456,  487,  205, 1451,  643,
 /*  1410 */  2127,  207,  488, 1455, 1988,  489,  642, 1457,  490,  210,
 /*  1420 */   492,  212,  496,   83,   84, 1145,  216,  513,  514,  515,
 /*  1430 */   517,  111, 1794,  551, 2038,  222, 1965,  332, 1964,  632,
 /*  1440 */    87,  555,  643,  578, 2019,  147, 1790, 1988, 2055,  642,
 /*  1450 */   224,  167, 2021,  646, 2023, 2024,  641,  156,  636,  157,
 /*  1460 */  1792, 1788,  238,  553,  158,  159,  559,  295,  562,  241,
 /*  1470 */  2154,  616, 2139,    7, 2153, 2149,  171, 2019, 2130,  587,
 /*  1480 */   569, 2055,  255,  575,  108, 2021,  646, 2023, 2024,  641,
 /*  1490 */  2020,  636,  556, 2146,  570,  257, 2083,  247, 2108,  250,
 /*  1500 */   568,  259,  369, 2104,  567, 1440,  358, 1435,  581,  359,
 /*  1510 */   258,  598, 2200, 2176,  595, 1569,  138,  260, 1452,  606,
 /*  1520 */   263, 2038, 2124,  362,  269,   94, 1458, 1917,  296,  643,
 /*  1530 */  1443, 1445,  614,  615, 1988,  297,  642, 1931, 1930, 1929,
 /*  1540 */   365,  619,  620,  634, 1499, 1500, 1502, 1503, 1504, 1505,
 /*  1550 */   298,   59,   96, 2089,   98, 2020,  100, 1805, 1775,  648,
 /*  1560 */   301,  729,  730, 1849, 2019,  290,   51,  325, 2055,  732,
 /*  1570 */   305,  108, 2021,  646, 2023, 2024,  641, 1982,  636,  310,
 /*  1580 */   334,  335,  324, 2081,   77, 2108, 2038,  314,  303,  369,
 /*  1590 */  2104, 1981,   76, 1980,  643, 1979, 1976,  393,  394, 1988,
 /*  1600 */  1417,  642, 1418, 2020,  187,  398, 1974,  400,  401,  402,
 /*  1610 */  1973,  404, 1972,  406, 1971, 1970,  408,  410, 1387, 1386,
 /*  1620 */  1942, 1941,  415,  416, 1940, 1939, 1339, 1895, 1894, 2019,
 /*  1630 */  2020, 1892,  144, 2055, 2038, 1891,  108, 2021,  646, 2023,
 /*  1640 */  2024,  641,  643,  636, 1890, 1893, 1889, 1988,  629,  642,
 /*  1650 */  2108, 1888, 1886, 1885,  369, 2104, 1884,  192,  433, 1883,
 /*  1660 */   435, 2038, 1897, 1882, 1881, 1880, 1879, 1878, 1877,  643,
 /*  1670 */  1876, 1875, 1874, 1873, 1988,  146,  642, 2019, 1872, 1871,
 /*  1680 */  1870, 2055, 1869, 1868,  109, 2021,  646, 2023, 2024,  641,
 /*  1690 */  1867,  636, 1866, 1865, 1896, 1864, 1863, 1862, 2108, 1341,
 /*  1700 */  1861, 1860, 2107, 2104, 2019, 1859,  463, 1858, 2055, 2020,
 /*  1710 */  1722,  109, 2021,  646, 2023, 2024,  641, 1721,  636,  198,
 /*  1720 */  1218, 1720, 1718, 1682, 1681, 2108,  203,  200,   74,  631,
 /*  1730 */  2104,  176,  201, 2020, 1131, 2008, 1955, 1949,  480, 1938,
 /*  1740 */  2038, 1130,  204,   75, 1937,  482,  211,  209,  643, 1915,
 /*  1750 */  1783, 1165, 1717, 1988, 1715,  642, 1713,  498,  499,  502,
 /*  1760 */   497,  501, 1711,  506, 2038,  505, 1709,  503,  507,  509,
 /*  1770 */   511, 1696,  643, 1695, 1678, 1785, 1287, 1988, 1784,  642,
 /*  1780 */   510,   61, 1286,  644,  221, 1707, 1209, 2055, 1208,  701,
 /*  1790 */   109, 2021,  646, 2023, 2024,  641, 1207,  636, 1206,  703,
 /*  1800 */  1700, 1201, 1203, 1202, 2108, 1200,  351, 2019,  337, 2104,
 /*  1810 */  1698, 2055,  352,  353,  168, 2021,  646, 2023, 2024,  641,
 /*  1820 */  1677,  636,  535, 1676,  538, 1675, 2020,  540,  542,  544,
 /*  1830 */  1407,  110, 1406,  548, 1954, 1409,   26, 1393,   65, 1948,
 /*  1840 */   557,  161, 1936, 1934, 2182,   19,  571,  573,   16,   58,
 /*  1850 */   253, 2020,   30,   28,   20, 1615,  248, 2038,   63,  254,
 /*  1860 */   246, 2009,   17,   21, 1630,  643,  591, 2198,   55,  266,
 /*  1870 */  1988,  558,  642, 1599, 1591, 1629,  169,  252,  356,  242,
 /*  1880 */  1635,  360, 2038,   29, 1634, 1633,  361,  563,    5,   57,
 /*  1890 */   643, 1636,   90,   56,  172, 1988, 1566,  642, 1935, 1933,
 /*  1900 */  2019, 1565, 1932, 1914, 2055,    6,   93,  316, 2021,  646,
 /*  1910 */  2023, 2024,  641, 2020,  636,  617,  272,   92, 1913,   95,
 /*  1920 */    22,  101,  285,  273, 1597, 2019,  275,  280,   66, 2055,
 /*  1930 */    23, 2020,  168, 2021,  646, 2023, 2024,  641,   12,  636,
 /*  1940 */    97, 1441,  173,  185, 2038, 1496, 1473,  649,  282,  364,
 /*  1950 */    10,  586,  643, 2058,  635, 1528, 1494, 1988,   36,  642,
 /*  1960 */  1493,   15, 2038, 1465,  377, 1518,   24,   25,  647, 1272,
 /*  1970 */   640, 1269,  651, 1517,  653, 1988, 1266,  642,  654,  656,
 /*  1980 */   645,  657,  659,  662, 1260, 2199,  660, 2019, 1258,  663,
 /*  1990 */  1249, 2055,  669, 1264,  323, 2021,  646, 2023, 2024,  641,
 /*  2000 */   102,  636,  103, 1263, 2020, 2019,  288, 1281, 1262, 2055,
 /*  2010 */    73, 1277,  322, 2021,  646, 2023, 2024,  641, 1163,  636,
 /*  2020 */  1261, 2074, 1197,  679,  691, 1196, 1195, 1194, 2020, 1193,
 /*  2030 */  1192, 1190, 1188, 1187, 1186, 2038, 1216,  289, 1184, 1183,
 /*  2040 */   374, 1182, 1181,  643, 1180, 1179, 1178, 1213, 1988, 1211,
 /*  2050 */   642, 1175, 1174, 1171, 1170, 1169, 1168, 1714,  711, 2038,
 /*  2060 */   712, 1712,  715,  713,  376,  717, 1710,  643,  721,  719,
 /*  2070 */  1708,  723, 1988,  716,  642, 1694,  720,  725, 2019,  724,
 /*  2080 */   727, 1120, 2055, 1674,  292,  323, 2021,  646, 2023, 2024,
 /*  2090 */   641, 1427,  636,  731, 2020,  302, 1649,  734,  735, 1649,
 /*  2100 */  1649, 1649, 2019, 1649, 1649, 1649, 2055, 1649, 1649,  323,
 /*  2110 */  2021,  646, 2023, 2024,  641, 1649,  636, 2020, 1649, 1649,
 /*  2120 */  1649, 1649, 1649, 1649, 1649, 2038, 1649, 1649, 1649, 1649,
 /*  2130 */  1649, 1649, 1649,  643, 1649, 1649, 1649, 1649, 1988, 1649,
 /*  2140 */   642, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2038, 1649,
 /*  2150 */  1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649, 1649,
 /*  2160 */  1649, 1988, 1649,  642, 1649, 1649, 1649, 1649,  550, 1649,
 /*  2170 */  1649, 1649, 2055, 1649, 1649,  318, 2021,  646, 2023, 2024,
 /*  2180 */   641, 2020,  636, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2190 */  1649, 2019, 1649, 1649, 1649, 2055, 1649, 2020,  307, 2021,
 /*  2200 */   646, 2023, 2024,  641, 1649,  636, 1649, 1649, 1649, 1649,
 /*  2210 */  1649, 1649, 2038, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2220 */   643, 1649, 1649, 1649, 1649, 1988, 1649,  642, 2038, 1649,
 /*  2230 */  1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649, 1649,
 /*  2240 */  1649, 1988, 1649,  642, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2250 */  1649, 1649, 1649, 1649, 1649, 2019, 1649, 1649, 1649, 2055,
 /*  2260 */  1649, 2020,  308, 2021,  646, 2023, 2024,  641, 1649,  636,
 /*  2270 */  1649, 2019, 1649, 1649, 1649, 2055, 1649, 1649,  309, 2021,
 /*  2280 */   646, 2023, 2024,  641, 1649,  636, 1649, 2020, 1649, 1649,
 /*  2290 */  1649, 1649, 2038, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2300 */   643, 1649, 1649, 1649, 1649, 1988, 1649,  642, 1649, 1649,
 /*  2310 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2038, 1649,
 /*  2320 */  1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649, 1649,
 /*  2330 */  1649, 1988, 1649,  642, 1649, 2019, 1649, 1649, 1649, 2055,
 /*  2340 */  1649, 1649,  315, 2021,  646, 2023, 2024,  641, 1649,  636,
 /*  2350 */  1649, 2020, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2360 */  1649, 2019, 1649, 1649, 1649, 2055, 1649, 1649,  319, 2021,
 /*  2370 */   646, 2023, 2024,  641, 1649,  636, 1649, 1649, 2020, 1649,
 /*  2380 */  1649, 1649, 2038, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2390 */   643, 1649, 1649, 1649, 1649, 1988, 1649,  642, 1649, 1649,
 /*  2400 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2038,
 /*  2410 */  1649, 1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649,
 /*  2420 */  1649, 1649, 1988, 1649,  642, 2019, 1649, 1649, 1649, 2055,
 /*  2430 */  1649, 1649,  311, 2021,  646, 2023, 2024,  641, 1649,  636,
 /*  2440 */  2020, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2450 */  1649, 1649, 2019, 1649, 1649, 1649, 2055, 1649, 1649,  320,
 /*  2460 */  2021,  646, 2023, 2024,  641, 1649,  636, 1649, 1649, 1649,
 /*  2470 */  1649, 2038, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  643,
 /*  2480 */  1649, 1649, 1649, 1649, 1988, 1649,  642, 1649, 1649, 1649,
 /*  2490 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2020, 1649,
 /*  2500 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2510 */  1649, 1649, 1649, 1649, 2019, 1649, 1649, 1649, 2055, 1649,
 /*  2520 */  1649,  312, 2021,  646, 2023, 2024,  641, 2020,  636, 2038,
 /*  2530 */  1649, 1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649,
 /*  2540 */  1649, 1649, 1988, 1649,  642, 1649, 1649, 1649, 1649, 1649,
 /*  2550 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2038, 1649,
 /*  2560 */  1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649, 1649,
 /*  2570 */  1649, 1988, 2019,  642, 1649, 1649, 2055, 1649, 1649,  321,
 /*  2580 */  2021,  646, 2023, 2024,  641, 2020,  636, 1649, 1649, 1649,
 /*  2590 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2600 */  1649, 2019, 1649, 1649, 1649, 2055, 1649, 1649,  313, 2021,
 /*  2610 */   646, 2023, 2024,  641, 1649,  636, 2038, 1649, 1649, 1649,
 /*  2620 */  1649, 1649, 1649, 1649,  643, 1649, 1649, 1649, 1649, 1988,
 /*  2630 */  1649,  642, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2640 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2020, 1649,
 /*  2650 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2019,
 /*  2660 */  1649, 1649, 1649, 2055, 1649, 2020,  326, 2021,  646, 2023,
 /*  2670 */  2024,  641, 1649,  636, 1649, 1649, 1649, 1649, 1649, 2038,
 /*  2680 */  1649, 2020, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649,
 /*  2690 */  1649, 1649, 1988, 1649,  642, 1649, 2038, 1649, 1649, 1649,
 /*  2700 */  1649, 1649, 1649, 1649,  643, 1649, 1649, 1649, 1649, 1988,
 /*  2710 */  1649,  642, 2038, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2720 */   643, 1649, 2019, 1649, 1649, 1988, 2055,  642, 1649,  327,
 /*  2730 */  2021,  646, 2023, 2024,  641, 1649,  636, 1649, 1649, 2019,
 /*  2740 */  1649, 1649, 1649, 2055, 1649, 1649, 2032, 2021,  646, 2023,
 /*  2750 */  2024,  641, 2020,  636, 1649, 2019, 1649, 1649, 1649, 2055,
 /*  2760 */  1649, 1649, 2031, 2021,  646, 2023, 2024,  641, 1649,  636,
 /*  2770 */  2020, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2780 */  1649, 1649, 1649, 2038, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2790 */  1649,  643, 1649, 1649, 1649, 1649, 1988, 1649,  642, 1649,
 /*  2800 */  1649, 2038, 1649, 1649, 1649, 1649, 1649, 1649, 1649,  643,
 /*  2810 */  1649, 1649, 1649, 1649, 1988, 1649,  642, 1649, 1649, 1649,
 /*  2820 */  1649, 1649, 1649, 1649, 1649, 1649, 2019, 1649, 2020, 1649,
 /*  2830 */  2055, 1649, 1649, 2030, 2021,  646, 2023, 2024,  641, 1649,
 /*  2840 */   636, 1649, 1649, 1649, 2019, 1649, 1649, 1649, 2055, 1649,
 /*  2850 */  1649,  339, 2021,  646, 2023, 2024,  641, 2020,  636, 2038,
 /*  2860 */  1649, 1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649,
 /*  2870 */  1649, 1649, 1988, 1649,  642, 1649, 1649, 1649, 1649, 1649,
 /*  2880 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2038, 1649,
 /*  2890 */  1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649, 1649,
 /*  2900 */  1649, 1988, 2019,  642, 1649, 1649, 2055, 1649, 1649,  340,
 /*  2910 */  2021,  646, 2023, 2024,  641, 2020,  636, 1649, 1649, 1649,
 /*  2920 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2930 */  1649, 2019, 1649, 1649, 1649, 2055, 1649, 1649,  336, 2021,
 /*  2940 */   646, 2023, 2024,  641, 1649,  636, 2038, 1649, 1649, 1649,
 /*  2950 */  1649, 1649, 1649, 1649,  643, 1649, 1649, 1649, 1649, 1988,
 /*  2960 */  1649,  642, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  2970 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2020, 1649,
 /*  2980 */  1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 2019,
 /*  2990 */  1649, 1649, 1649, 2055, 1649, 2020,  341, 2021,  646, 2023,
 /*  3000 */  2024,  641, 1649,  636, 1649, 1649, 1649, 1649, 1649, 2038,
 /*  3010 */  1649, 1649, 1649, 1649, 1649, 1649, 1649,  643, 1649, 1649,
 /*  3020 */  1649, 1649, 1988, 1649,  642, 1649, 2038, 1649, 1649, 1649,
 /*  3030 */  1649, 1649, 1649, 1649,  643, 1649, 1649, 1649, 1649, 1988,
 /*  3040 */  1649,  642, 1649, 1649, 1649, 1649, 1649, 1649, 1649, 1649,
 /*  3050 */  1649, 1649,  644, 1649, 1649, 1649, 2055, 1649, 1649,  318,
 /*  3060 */  2021,  646, 2023, 2024,  641, 1649,  636, 1649, 1649, 2019,
 /*  3070 */  1649, 1649, 1649, 2055, 1649, 1649,  317, 2021,  646, 2023,
 /*  3080 */  2024,  641, 1649,  636,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   420,  436,  375,  423,  333,  440,  335,  336,  362,  425,
 /*    10 */   426,  344,   12,   13,   14,  352,  349,  390,  391,  373,
 /*    20 */    20,  456,   22,  360,  360,  460,  461,    4,  329,  360,
 /*    30 */   367,  367,  369,   33,  409,   35,  367,  436,   14,  376,
 /*    40 */   376,  440,    8,    9,   20,  376,   12,   13,   14,   15,
 /*    50 */    16,    0,  406,  407,  408,  337,  455,  456,   58,  360,
 /*    60 */   435,  460,  461,  417,   64,   20,   43,  368,   45,   46,
 /*    70 */    20,   71,  373,   37,  375,   24,   25,   26,   27,   28,
 /*    80 */    29,   30,   31,   32,   12,   13,  368,   12,   13,   14,
 /*    90 */    15,   16,   20,  328,   22,  330,   96,   14,   64,   20,
 /*   100 */   436,  337,  403,   20,  440,   33,  407,   35,   20,  410,
 /*   110 */   411,  412,  413,  414,  415,  351,  417,   35,  118,  455,
 /*   120 */   456,  422,  436,  424,  460,  461,  440,  428,  429,   96,
 /*   130 */    58,   20,  368,  133,  134,   99,   64,  101,  102,  105,
 /*   140 */   104,  442,  456,   71,  108,  375,  460,  461,  343,  450,
 /*   150 */   432,  433,  434,   71,  436,  437,  362,  387,  440,   22,
 /*   160 */   390,  391,  357,  163,  164,   20,  130,  373,   96,  169,
 /*   170 */   170,  366,   35,  455,  456,   96,  374,  375,  460,  461,
 /*   180 */    66,   67,   68,  421,  184,  423,  186,  163,   74,   75,
 /*   190 */   118,    4,  333,   79,  335,  336,  162,   96,   84,   85,
 /*   200 */   406,  407,  408,   35,   90,  133,  134,   96,   71,  209,
 /*   210 */   210,  417,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */    20,  168,   22,   63,  371,  163,  164,  374,  375,  127,
 /*   240 */   128,  169,  170,   21,  132,   35,   24,   25,   26,   27,
 /*   250 */    28,   29,   30,   31,   32,  118,  184,   20,  186,    8,
 /*   260 */     9,   51,  356,   12,   13,   14,   15,   16,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  244,   20,
 /*   280 */   247,  209,  210,   96,  212,  213,  214,  215,  216,  217,
 /*   290 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   300 */   228,  229,  326,  231,   12,   13,    0,  401,  163,  164,
 /*   310 */    20,   20,   20,  329,   22,  252,  253,  254,  337,    4,
 /*   320 */   329,  184,  231,  186,  233,   33,  247,   35,  109,  110,
 /*   330 */   111,  112,  113,  114,  115,  116,  117,  118,  119,  337,
 /*   340 */   121,  122,  123,  124,  125,  126,  209,  210,  247,  409,
 /*   350 */    58,  360,  337,  351,  186,  360,   64,  373,  247,  368,
 /*   360 */   358,   63,  367,   71,  373,  384,  375,  386,  392,  359,
 /*   370 */   368,  376,   66,   67,   68,  435,   12,   13,   14,   20,
 /*   380 */    74,   75,  372,  368,   20,   79,   22,   96,   96,  368,
 /*   390 */    84,   85,  133,  134,  403,  341,   90,   33,  407,   35,
 /*   400 */   379,  410,  411,  412,  413,  414,  415,  337,  417,  355,
 /*   410 */   118,  420,  436,  422,  423,  424,  440,  363,   33,  428,
 /*   420 */   429,  351,   58,  133,  134,  133,  134,  176,  169,  170,
 /*   430 */   343,  455,  456,   48,  247,   71,  460,  461,  368,   54,
 /*   440 */    55,   56,   57,   58,   21,  360,  431,  432,  433,  434,
 /*   450 */   337,  436,  437,  366,  337,  163,  164,   34,  360,   36,
 /*   460 */    96,  169,  170,    0,  351,    8,    9,  382,  351,   12,
 /*   470 */    13,   14,   15,   16,  376,  358,  184,   20,  186,  107,
 /*   480 */    95,  368,  118,   98,   21,  368,    0,   24,   25,   26,
 /*   490 */    27,   28,   29,   30,   31,   32,  334,  133,  134,  337,
 /*   500 */   338,  209,  210,  360,  212,  213,  214,  215,  216,  217,
 /*   510 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   520 */   228,  229,  271,  108,  381,  382,  334,  163,  164,  337,
 /*   530 */   338,    8,    9,  169,  170,   12,   13,   14,   15,   16,
 /*   540 */   337,  352,  127,  128,  129,  130,  131,  132,  184,  360,
 /*   550 */   186,  166,  167,    0,  351,   71,  171,  209,  369,  174,
 /*   560 */     8,    9,  360,  248,   12,   13,   14,   15,   16,   20,
 /*   570 */   368,  368,  337,  209,  210,  190,  212,  213,  214,  215,
 /*   580 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   590 */   226,  227,  228,  229,   12,   13,   44,    4,   14,   15,
 /*   600 */    16,  231,   20,   96,   22,  362,  258,  259,  260,  261,
 /*   610 */   262,    3,   19,  337,  412,   33,  373,   35,   14,  384,
 /*   620 */    97,  386,  165,  337,   20,  329,   33,  351,   20,    8,
 /*   630 */     9,  337,  360,   12,   13,   14,   15,   16,  152,  367,
 /*   640 */    58,   48,  409,  341,  368,  351,   53,  161,  376,  406,
 /*   650 */   407,   58,  421,   71,  423,   58,  360,  128,  346,  347,
 /*   660 */   417,  108,  368,  337,  368,  363,   12,   13,  435,  373,
 /*   670 */   384,  375,  386,  329,   20,  392,   22,  351,   96,    0,
 /*   680 */   127,  128,  129,  130,  131,  132,  362,   33,   95,   35,
 /*   690 */   183,   98,  185,   96,  368,   98,  329,  373,  127,  403,
 /*   700 */   118,   22,   20,  407,   22,   97,  410,  411,  412,  413,
 /*   710 */   414,  415,   58,  417,  165,  133,  134,  373,   97,  436,
 /*   720 */   191,  192,   44,  440,  195,   71,  197,  360,  346,  347,
 /*   730 */   406,  407,  107,   51,  353,  368,  179,  356,  455,  456,
 /*   740 */   373,  417,  375,  460,  461,  163,  164,  451,  452,    2,
 /*   750 */    96,  169,  170,   58,  247,    8,    9,  200,  201,   12,
 /*   760 */    13,   14,   15,   16,  193,  194,  184,  163,  186,  162,
 /*   770 */   403,    0,  118,  165,  407,   97,  337,  410,  411,  412,
 /*   780 */   413,  414,  415,  416,  417,  418,  419,  133,  134,    0,
 /*   790 */    95,  209,  210,   98,  212,  213,  214,  215,  216,  217,
 /*   800 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   810 */   228,  229,  348,   18,  350,   20,  377,  163,  164,   48,
 /*   820 */     2,   19,   27,  169,  170,   30,    8,    9,   33,  352,
 /*   830 */    12,   13,   14,   15,   16,   33,   20,  360,  184,    0,
 /*   840 */   186,  234,  329,   48,  247,   50,  369,  329,   53,   71,
 /*   850 */    48,  244,   63,   39,  329,  329,   54,   55,   56,   57,
 /*   860 */    58,    1,    2,  209,  210,   20,  212,  213,  214,  215,
 /*   870 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   880 */   226,  227,  228,  229,  370,  361,  373,  373,    8,    9,
 /*   890 */    95,  373,   12,   13,   14,   15,   16,   95,  373,  373,
 /*   900 */    98,  360,  107,  361,   80,   66,   67,   68,   69,   70,
 /*   910 */   369,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   920 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   930 */    91,   92,  137,  131,    3,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  156,  337,  158,  159,  160,   18,   97,  392,   20,
 /*   960 */   392,   23,  138,  139,  337,  108,  351,  392,  166,  368,
 /*   970 */   329,   35,  337,  171,  337,   37,   38,    0,  351,   41,
 /*   980 */   379,  165,  337,  368,    0,  161,  351,  130,  351,   42,
 /*   990 */   188,   44,  190,  329,  329,  368,  351,   59,   60,   61,
 /*  1000 */    62,  360,  436,  368,  436,  368,  440,   71,  440,  368,
 /*  1010 */   165,  436,  107,  368,  373,  440,  375,  329,  337,    0,
 /*  1020 */   329,  455,  456,  455,  456,  360,  460,  461,  460,  461,
 /*  1030 */   455,  456,  351,  368,   96,  460,  461,  373,  373,  329,
 /*  1040 */   375,   22,  352,  337,  403,  165,  329,   63,  407,  368,
 /*  1050 */   360,  410,  411,  412,  413,  414,  415,  351,  417,  369,
 /*  1060 */   246,  373,  157,  422,  373,  424,  329,   44,  403,  428,
 /*  1070 */   429,   44,  407,  135,  368,  410,  411,  412,  413,  414,
 /*  1080 */   415,  329,  417,  373,  392,  108,  337,  337,  361,  424,
 /*  1090 */   373,  450,  329,  337,  429,  329,   45,   46,  370,  337,
 /*  1100 */   351,  373,  163,  361,  127,  128,  129,  130,  131,  132,
 /*  1110 */   373,  368,  360,  351,  176,  177,  178,  368,  368,  181,
 /*  1120 */   368,   42,  379,   44,  368,  373,  329,  375,  436,  329,
 /*  1130 */   368,  361,  440,  329,  360,  329,  373,  199,   22,  373,
 /*  1140 */   202,  367,  204,  205,  206,  207,  208,  455,  456,  396,
 /*  1150 */   376,   35,  460,  461,  329,  403,  329,   35,  370,  407,
 /*  1160 */   360,  373,  410,  411,  412,  413,  414,  415,  368,  417,
 /*  1170 */   373,  245,  246,  373,  422,  375,  424,  373,   44,  373,
 /*  1180 */   428,  429,  432,  433,  434,  247,  436,  437,  432,  433,
 /*  1190 */   434,  439,  436,  437,  329,  337,  100,  266,  373,  103,
 /*  1200 */   373,  165,  100,  403,  337,  103,   44,  407,  172,  351,
 /*  1210 */   410,  411,  412,  413,  414,  415,   44,  417,  351,    0,
 /*  1220 */   100,   58,  422,  103,  424,  360,  368,  100,  428,  429,
 /*  1230 */   103,   97,   44,  368,   47,  368,  133,  134,  373,  439,
 /*  1240 */   375,   22,  329,   44,   64,   44,   44,    8,    9,   44,
 /*  1250 */    44,   12,   13,   14,   15,   16,   44,    1,    2,   97,
 /*  1260 */    44,   98,   44,  361,   44,   44,   44,  361,  403,   97,
 /*  1270 */   330,  349,  407,  360,   96,  410,  411,  412,  413,  414,
 /*  1280 */   415,  368,  417,   96,  106,   97,  373,  422,  375,  424,
 /*  1290 */    13,  268,   44,  428,  429,   44,   97,  270,   97,   97,
 /*  1300 */   329,  383,   97,   97,  439,   44,    0,   13,  186,   97,
 /*  1310 */   464,  339,   35,   97,  453,   97,  403,   97,   97,   97,
 /*  1320 */   407,  447,  360,  410,  411,  412,  413,  414,  415,   35,
 /*  1330 */   417,  360,  339,   12,   13,  422,  383,  424,  336,  368,
 /*  1340 */   372,  428,  429,   22,  373,   97,  375,  383,   97,  438,
 /*  1350 */   457,  430,  439,  441,   33,   49,   35,  249,   97,  405,
 /*  1360 */    48,  404,   42,  182,  394,  380,   20,  380,  378,  383,
 /*  1370 */   329,  162,   20,  378,  403,  337,  337,  380,  407,   58,
 /*  1380 */   337,  410,  411,  412,  413,  414,  415,  378,  417,  209,
 /*  1390 */    94,  345,   71,  422,  337,  424,  337,  337,   20,  428,
 /*  1400 */   429,  360,  331,  329,  331,   20,  398,  343,   20,  368,
 /*  1410 */   439,  343,  375,   20,  373,  338,  375,   20,  393,  343,
 /*  1420 */   338,  343,  337,  343,  343,   52,  343,  340,  340,  331,
 /*  1430 */   360,  337,  360,  198,  360,  360,  373,  331,  373,  118,
 /*  1440 */    96,  189,  368,  257,  403,  400,  360,  373,  407,  375,
 /*  1450 */   360,  410,  411,  412,  413,  414,  415,  360,  417,  360,
 /*  1460 */   360,  360,  341,  402,  360,  360,  375,  398,  337,  341,
 /*  1470 */   446,  256,  383,  263,  446,  383,  446,  403,  449,  175,
 /*  1480 */   373,  407,  448,  373,  410,  411,  412,  413,  414,  415,
 /*  1490 */   329,  417,  397,  452,  265,  445,  422,  388,  424,  388,
 /*  1500 */   264,  443,  428,  429,  250,  184,  373,  186,  373,  272,
 /*  1510 */   444,  269,  465,  459,  267,  246,  368,  405,   20,  337,
 /*  1520 */   458,  360,  409,  338,  341,  341,   20,  386,  388,  368,
 /*  1530 */   209,  210,  373,  373,  373,  388,  375,  373,  373,  373,
 /*  1540 */   373,  167,  385,  222,  223,  224,  225,  226,  227,  228,
 /*  1550 */   356,   96,  341,  427,  341,  329,   96,  368,  350,  364,
 /*  1560 */   337,   36,  332,  373,  403,  341,  395,  399,  407,  331,
 /*  1570 */   327,  410,  411,  412,  413,  414,  415,    0,  417,  354,
 /*  1580 */   389,  389,  354,  422,   42,  424,  360,  354,  342,  428,
 /*  1590 */   429,    0,  191,    0,  368,    0,    0,   35,  203,  373,
 /*  1600 */    35,  375,   35,  329,   35,  203,    0,   35,   35,  203,
 /*  1610 */     0,  203,    0,   35,    0,    0,   22,   35,  186,  184,
 /*  1620 */     0,    0,  180,  179,    0,    0,   47,    0,    0,  403,
 /*  1630 */   329,    0,   42,  407,  360,    0,  410,  411,  412,  413,
 /*  1640 */   414,  415,  368,  417,    0,    0,    0,  373,  422,  375,
 /*  1650 */   424,    0,    0,    0,  428,  429,    0,  152,   35,    0,
 /*  1660 */   152,  360,    0,    0,    0,    0,    0,    0,    0,  368,
 /*  1670 */     0,    0,    0,    0,  373,   42,  375,  403,    0,    0,
 /*  1680 */     0,  407,    0,    0,  410,  411,  412,  413,  414,  415,
 /*  1690 */     0,  417,    0,    0,    0,    0,    0,    0,  424,   22,
 /*  1700 */     0,    0,  428,  429,  403,    0,  136,    0,  407,  329,
 /*  1710 */     0,  410,  411,  412,  413,  414,  415,    0,  417,   58,
 /*  1720 */    35,    0,    0,    0,    0,  424,   42,   58,   39,  428,
 /*  1730 */   429,   44,   58,  329,   14,   47,    0,    0,   47,    0,
 /*  1740 */   360,   14,   40,   39,    0,   47,  175,   39,  368,    0,
 /*  1750 */     0,   65,    0,  373,    0,  375,    0,   48,   39,   48,
 /*  1760 */    35,   35,    0,   48,  360,   35,    0,   39,   39,   35,
 /*  1770 */    39,    0,  368,    0,    0,    0,   35,  373,    0,  375,
 /*  1780 */    48,  105,   22,  403,  103,    0,   35,  407,   35,   44,
 /*  1790 */   410,  411,  412,  413,  414,  415,   35,  417,   35,   44,
 /*  1800 */     0,   22,   35,   35,  424,   35,   22,  403,  428,  429,
 /*  1810 */     0,  407,   22,   22,  410,  411,  412,  413,  414,  415,
 /*  1820 */     0,  417,   50,    0,   35,    0,  329,   35,   35,   22,
 /*  1830 */    35,   20,   35,  196,    0,   97,   96,   35,   96,    0,
 /*  1840 */    22,  187,    0,    0,    3,   44,  230,  255,  251,   44,
 /*  1850 */    44,  329,   44,   96,  251,   97,   97,  360,    3,   47,
 /*  1860 */    96,   47,  251,   44,   35,  368,  462,  463,  165,   47,
 /*  1870 */   373,  165,  375,   97,   97,   35,   96,   96,  165,  167,
 /*  1880 */    97,   35,  360,   96,   35,   35,   35,  173,  172,   44,
 /*  1890 */   368,   97,   96,  245,   47,  373,   97,  375,    0,    0,
 /*  1900 */   403,   97,    0,    0,  407,  172,   39,  410,  411,  412,
 /*  1910 */   413,  414,  415,  329,  417,  168,   47,   96,    0,   39,
 /*  1920 */    96,  106,   47,   97,   97,  403,   96,   96,   96,  407,
 /*  1930 */    44,  329,  410,  411,  412,  413,  414,  415,    2,  417,
 /*  1940 */    96,   22,   47,   47,  360,   97,   22,   35,  166,  365,
 /*  1950 */   232,  454,  368,   96,   96,  209,   97,  373,   96,  375,
 /*  1960 */    97,   96,  360,   97,   35,  230,   96,   96,  107,   97,
 /*  1970 */   368,   97,   96,  230,   35,  373,   97,  375,   96,   35,
 /*  1980 */   211,   96,   35,   35,   97,  463,   96,  403,   97,   96,
 /*  1990 */    22,  407,  108,  120,  410,  411,  412,  413,  414,  415,
 /*  2000 */    96,  417,   96,  120,  329,  403,   44,   35,  120,  407,
 /*  2010 */    96,   22,  410,  411,  412,  413,  414,  415,   65,  417,
 /*  2020 */   120,  419,   35,   64,   93,   35,   35,   35,  329,   35,
 /*  2030 */    35,   35,   35,   35,   35,  360,   71,   44,   35,   35,
 /*  2040 */   365,   35,   22,  368,   35,   35,   35,   71,  373,   35,
 /*  2050 */   375,   35,   35,   35,   35,   22,   35,    0,   35,  360,
 /*  2060 */    48,    0,   35,   39,  365,   39,    0,  368,   39,   35,
 /*  2070 */     0,   35,  373,   48,  375,    0,   48,   39,  403,   48,
 /*  2080 */    35,   35,  407,    0,   22,  410,  411,  412,  413,  414,
 /*  2090 */   415,   22,  417,   21,  329,   22,  466,   21,   20,  466,
 /*  2100 */   466,  466,  403,  466,  466,  466,  407,  466,  466,  410,
 /*  2110 */   411,  412,  413,  414,  415,  466,  417,  329,  466,  466,
 /*  2120 */   466,  466,  466,  466,  466,  360,  466,  466,  466,  466,
 /*  2130 */   466,  466,  466,  368,  466,  466,  466,  466,  373,  466,
 /*  2140 */   375,  466,  466,  466,  466,  466,  466,  466,  360,  466,
 /*  2150 */   466,  466,  466,  466,  466,  466,  368,  466,  466,  466,
 /*  2160 */   466,  373,  466,  375,  466,  466,  466,  466,  403,  466,
 /*  2170 */   466,  466,  407,  466,  466,  410,  411,  412,  413,  414,
 /*  2180 */   415,  329,  417,  466,  466,  466,  466,  466,  466,  466,
 /*  2190 */   466,  403,  466,  466,  466,  407,  466,  329,  410,  411,
 /*  2200 */   412,  413,  414,  415,  466,  417,  466,  466,  466,  466,
 /*  2210 */   466,  466,  360,  466,  466,  466,  466,  466,  466,  466,
 /*  2220 */   368,  466,  466,  466,  466,  373,  466,  375,  360,  466,
 /*  2230 */   466,  466,  466,  466,  466,  466,  368,  466,  466,  466,
 /*  2240 */   466,  373,  466,  375,  466,  466,  466,  466,  466,  466,
 /*  2250 */   466,  466,  466,  466,  466,  403,  466,  466,  466,  407,
 /*  2260 */   466,  329,  410,  411,  412,  413,  414,  415,  466,  417,
 /*  2270 */   466,  403,  466,  466,  466,  407,  466,  466,  410,  411,
 /*  2280 */   412,  413,  414,  415,  466,  417,  466,  329,  466,  466,
 /*  2290 */   466,  466,  360,  466,  466,  466,  466,  466,  466,  466,
 /*  2300 */   368,  466,  466,  466,  466,  373,  466,  375,  466,  466,
 /*  2310 */   466,  466,  466,  466,  466,  466,  466,  466,  360,  466,
 /*  2320 */   466,  466,  466,  466,  466,  466,  368,  466,  466,  466,
 /*  2330 */   466,  373,  466,  375,  466,  403,  466,  466,  466,  407,
 /*  2340 */   466,  466,  410,  411,  412,  413,  414,  415,  466,  417,
 /*  2350 */   466,  329,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2360 */   466,  403,  466,  466,  466,  407,  466,  466,  410,  411,
 /*  2370 */   412,  413,  414,  415,  466,  417,  466,  466,  329,  466,
 /*  2380 */   466,  466,  360,  466,  466,  466,  466,  466,  466,  466,
 /*  2390 */   368,  466,  466,  466,  466,  373,  466,  375,  466,  466,
 /*  2400 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  360,
 /*  2410 */   466,  466,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  2420 */   466,  466,  373,  466,  375,  403,  466,  466,  466,  407,
 /*  2430 */   466,  466,  410,  411,  412,  413,  414,  415,  466,  417,
 /*  2440 */   329,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2450 */   466,  466,  403,  466,  466,  466,  407,  466,  466,  410,
 /*  2460 */   411,  412,  413,  414,  415,  466,  417,  466,  466,  466,
 /*  2470 */   466,  360,  466,  466,  466,  466,  466,  466,  466,  368,
 /*  2480 */   466,  466,  466,  466,  373,  466,  375,  466,  466,  466,
 /*  2490 */   466,  466,  466,  466,  466,  466,  466,  466,  329,  466,
 /*  2500 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2510 */   466,  466,  466,  466,  403,  466,  466,  466,  407,  466,
 /*  2520 */   466,  410,  411,  412,  413,  414,  415,  329,  417,  360,
 /*  2530 */   466,  466,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  2540 */   466,  466,  373,  466,  375,  466,  466,  466,  466,  466,
 /*  2550 */   466,  466,  466,  466,  466,  466,  466,  466,  360,  466,
 /*  2560 */   466,  466,  466,  466,  466,  466,  368,  466,  466,  466,
 /*  2570 */   466,  373,  403,  375,  466,  466,  407,  466,  466,  410,
 /*  2580 */   411,  412,  413,  414,  415,  329,  417,  466,  466,  466,
 /*  2590 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2600 */   466,  403,  466,  466,  466,  407,  466,  466,  410,  411,
 /*  2610 */   412,  413,  414,  415,  466,  417,  360,  466,  466,  466,
 /*  2620 */   466,  466,  466,  466,  368,  466,  466,  466,  466,  373,
 /*  2630 */   466,  375,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2640 */   466,  466,  466,  466,  466,  466,  466,  466,  329,  466,
 /*  2650 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  403,
 /*  2660 */   466,  466,  466,  407,  466,  329,  410,  411,  412,  413,
 /*  2670 */   414,  415,  466,  417,  466,  466,  466,  466,  466,  360,
 /*  2680 */   466,  329,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  2690 */   466,  466,  373,  466,  375,  466,  360,  466,  466,  466,
 /*  2700 */   466,  466,  466,  466,  368,  466,  466,  466,  466,  373,
 /*  2710 */   466,  375,  360,  466,  466,  466,  466,  466,  466,  466,
 /*  2720 */   368,  466,  403,  466,  466,  373,  407,  375,  466,  410,
 /*  2730 */   411,  412,  413,  414,  415,  466,  417,  466,  466,  403,
 /*  2740 */   466,  466,  466,  407,  466,  466,  410,  411,  412,  413,
 /*  2750 */   414,  415,  329,  417,  466,  403,  466,  466,  466,  407,
 /*  2760 */   466,  466,  410,  411,  412,  413,  414,  415,  466,  417,
 /*  2770 */   329,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2780 */   466,  466,  466,  360,  466,  466,  466,  466,  466,  466,
 /*  2790 */   466,  368,  466,  466,  466,  466,  373,  466,  375,  466,
 /*  2800 */   466,  360,  466,  466,  466,  466,  466,  466,  466,  368,
 /*  2810 */   466,  466,  466,  466,  373,  466,  375,  466,  466,  466,
 /*  2820 */   466,  466,  466,  466,  466,  466,  403,  466,  329,  466,
 /*  2830 */   407,  466,  466,  410,  411,  412,  413,  414,  415,  466,
 /*  2840 */   417,  466,  466,  466,  403,  466,  466,  466,  407,  466,
 /*  2850 */   466,  410,  411,  412,  413,  414,  415,  329,  417,  360,
 /*  2860 */   466,  466,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  2870 */   466,  466,  373,  466,  375,  466,  466,  466,  466,  466,
 /*  2880 */   466,  466,  466,  466,  466,  466,  466,  466,  360,  466,
 /*  2890 */   466,  466,  466,  466,  466,  466,  368,  466,  466,  466,
 /*  2900 */   466,  373,  403,  375,  466,  466,  407,  466,  466,  410,
 /*  2910 */   411,  412,  413,  414,  415,  329,  417,  466,  466,  466,
 /*  2920 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2930 */   466,  403,  466,  466,  466,  407,  466,  466,  410,  411,
 /*  2940 */   412,  413,  414,  415,  466,  417,  360,  466,  466,  466,
 /*  2950 */   466,  466,  466,  466,  368,  466,  466,  466,  466,  373,
 /*  2960 */   466,  375,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2970 */   466,  466,  466,  466,  466,  466,  466,  466,  329,  466,
 /*  2980 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  403,
 /*  2990 */   466,  466,  466,  407,  466,  329,  410,  411,  412,  413,
 /*  3000 */   414,  415,  466,  417,  466,  466,  466,  466,  466,  360,
 /*  3010 */   466,  466,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  3020 */   466,  466,  373,  466,  375,  466,  360,  466,  466,  466,
 /*  3030 */   466,  466,  466,  466,  368,  466,  466,  466,  466,  373,
 /*  3040 */   466,  375,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  3050 */   466,  466,  403,  466,  466,  466,  407,  466,  466,  410,
 /*  3060 */   411,  412,  413,  414,  415,  466,  417,  466,  466,  403,
 /*  3070 */   466,  466,  466,  407,  466,  466,  410,  411,  412,  413,
 /*  3080 */   414,  415,  466,  417,
};
#define YY_SHIFT_COUNT    (736)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2083)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   938,    0,   72,    0,  292,  292,  292,  292,  292,  292,
 /*    10 */   292,  292,  292,  292,  292,  364,  582,  582,  654,  582,
 /*    20 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    30 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    40 */   582,  582,  582,  582,  582,  582,  582,  582,   79,  111,
 /*    50 */   291,  507,  597,   33,  101,   33,  291,  291, 1321, 1321,
 /*    60 */    33, 1321, 1321,  187,   33,   45,  259,   50,   50,  259,
 /*    70 */    23,   23,  145,  290,   83,   83,   50,   50,   50,   50,
 /*    80 */    50,   50,   50,   88,   50,   50,  170,   45,   50,   50,
 /*    90 */   237,   50,   45,   50,   88,   50,   88,   45,   50,   50,
 /*   100 */    45,   50,   45,   45,   45,   50,  298,  795,   34,   34,
 /*   110 */   222,  114,  137,  137,  137,  137,  137,  137,  137,  137,
 /*   120 */   137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
 /*   130 */   137,   36,  608,  145,  290,  789,   82,  549,  549,  549,
 /*   140 */   984,   91,   91,   82,  359,  359,  359,  372,  370,   45,
 /*   150 */   484,   45,  484,  484,  625,  778,  219,  219,  219,  219,
 /*   160 */   219,  219,  219,  219,  802,  463,  306,  457,  251,  348,
 /*   170 */   210,   63,   24,  604,  682,  816, 1051,  857,  845,  926,
 /*   180 */   814,  931,  926,  947,  315,  939, 1108, 1312, 1181, 1320,
 /*   190 */  1346, 1320, 1209, 1352, 1352, 1320, 1209, 1209, 1352, 1296,
 /*   200 */  1352, 1352, 1352, 1378, 1378, 1385,  170, 1388,  170, 1393,
 /*   210 */  1397,  170, 1393,  170,  170,  170, 1352,  170, 1373, 1373,
 /*   220 */  1378,   45,   45,   45,   45,   45,   45,   45,   45,   45,
 /*   230 */    45,   45, 1352, 1378,  484,  484, 1235, 1344, 1385,  298,
 /*   240 */  1252, 1388,  298, 1352, 1346, 1346,  484, 1186, 1215,  484,
 /*   250 */  1186, 1215,  484,  484,   45, 1210, 1304, 1186, 1229, 1236,
 /*   260 */  1254, 1108, 1237, 1242, 1247, 1269,  359, 1498, 1352, 1393,
 /*   270 */   298,  298, 1506, 1215,  484,  484,  484,  484,  484, 1215,
 /*   280 */   484, 1374,  298,  625,  298,  359, 1455, 1460,  484,  778,
 /*   290 */  1352,  298, 1525, 1378, 3084, 3084, 3084, 3084, 3084, 3084,
 /*   300 */  3084, 3084, 3084,  839,  385,   51,  593,  523,  552,  621,
 /*   310 */   553,  747,  818,  880,  977, 1239, 1239, 1239, 1239, 1239,
 /*   320 */  1239, 1239, 1239, 1239,  415,  529,   75,   75,  824,  557,
 /*   330 */   486,  695,  423,  571,  112,  112,  584,  860,  607,  584,
 /*   340 */   584,  584,  678,  771, 1116, 1079,  905, 1096, 1102, 1120,
 /*   350 */  1127,  679, 1019, 1219, 1134, 1162, 1163, 1172, 1188, 1103,
 /*   360 */  1023, 1027, 1036, 1199, 1201, 1202, 1205, 1206, 1212, 1256,
 /*   370 */  1216,  168, 1122, 1180, 1218, 1187, 1220, 1221, 1222, 1248,
 /*   380 */  1251, 1261, 1178, 1277, 1294,  936, 1306, 1577, 1591, 1401,
 /*   390 */  1593, 1595, 1542, 1596, 1562, 1395, 1565, 1567, 1569, 1402,
 /*   400 */  1606, 1572, 1573, 1406, 1610, 1408, 1612, 1578, 1614, 1594,
 /*   410 */  1615, 1582, 1432, 1435, 1620, 1621, 1442, 1444, 1624, 1625,
 /*   420 */  1579, 1627, 1628, 1631, 1590, 1635, 1644, 1645, 1646, 1651,
 /*   430 */  1652, 1653, 1656, 1505, 1623, 1659, 1508, 1662, 1663, 1664,
 /*   440 */  1665, 1666, 1667, 1668, 1670, 1671, 1672, 1673, 1678, 1679,
 /*   450 */  1680, 1682, 1683, 1633, 1690, 1692, 1693, 1694, 1695, 1696,
 /*   460 */  1677, 1697, 1700, 1701, 1570, 1705, 1707, 1710, 1661, 1685,
 /*   470 */  1717, 1669, 1721, 1674, 1722, 1723, 1684, 1689, 1687, 1688,
 /*   480 */  1720, 1691, 1727, 1698, 1724, 1702, 1704, 1736, 1737, 1739,
 /*   490 */  1708, 1571, 1744, 1749, 1750, 1686, 1752, 1754, 1725, 1709,
 /*   500 */  1719, 1756, 1726, 1711, 1728, 1762, 1730, 1715, 1729, 1766,
 /*   510 */  1734, 1732, 1731, 1771, 1773, 1774, 1775, 1676, 1681, 1741,
 /*   520 */  1760, 1778, 1751, 1753, 1761, 1763, 1745, 1755, 1767, 1768,
 /*   530 */  1779, 1770, 1785, 1784, 1800, 1790, 1772, 1810, 1791, 1789,
 /*   540 */  1820, 1792, 1823, 1793, 1825, 1807, 1811, 1795, 1797, 1637,
 /*   550 */  1738, 1740, 1834, 1703, 1742, 1802, 1839, 1654, 1818, 1706,
 /*   560 */  1712, 1842, 1843, 1713, 1714, 1841, 1801, 1597, 1757, 1758,
 /*   570 */  1764, 1716, 1616, 1733, 1592, 1759, 1805, 1776, 1780, 1781,
 /*   580 */  1787, 1777, 1806, 1812, 1814, 1796, 1808, 1603, 1783, 1794,
 /*   590 */  1855, 1819, 1611, 1829, 1840, 1846, 1849, 1850, 1851, 1799,
 /*   600 */  1804, 1822, 1648, 1845, 1847, 1898, 1899, 1902, 1903, 1821,
 /*   610 */  1867, 1688, 1869, 1824, 1826, 1827, 1830, 1831, 1747, 1832,
 /*   620 */  1918, 1880, 1782, 1844, 1815, 1688, 1875, 1886, 1735, 1718,
 /*   630 */  1743, 1936, 1919, 1746, 1857, 1848, 1858, 1859, 1862, 1863,
 /*   640 */  1895, 1865, 1870, 1896, 1866, 1924, 1769, 1871, 1861, 1872,
 /*   650 */  1912, 1929, 1876, 1874, 1939, 1882, 1879, 1944, 1885, 1887,
 /*   660 */  1947, 1890, 1891, 1948, 1893, 1873, 1883, 1888, 1900, 1968,
 /*   670 */  1884, 1904, 1962, 1906, 1972, 1914, 1962, 1962, 1989, 1953,
 /*   680 */  1959, 1987, 1990, 1991, 1992, 1994, 1995, 1996, 1997, 1998,
 /*   690 */  1999, 1965, 1931, 1993, 2003, 2004, 2006, 2020, 2009, 2010,
 /*   700 */  2011, 1976, 1745, 2014, 1755, 2016, 2017, 2018, 2019, 2033,
 /*   710 */  2021, 2057, 2023, 2012, 2024, 2061, 2027, 2025, 2026, 2066,
 /*   720 */  2034, 2028, 2029, 2070, 2036, 2031, 2038, 2075, 2045, 2046,
 /*   730 */  2083, 2062, 2072, 2069, 2073, 2076, 2078,
};
#define YY_REDUCE_COUNT (302)
#define YY_REDUCE_MIN   (-435)
#define YY_REDUCE_MAX   (2666)
static const short yy_reduce_ofst[] = {
 /*     0 */   -24, -301,   -9,  641,  752,  800,  865,  913,  971, 1074,
 /*    10 */  1161, 1226, 1274, 1301, 1380,  367,  296, 1404,  665, 1041,
 /*    20 */  1497, 1522, 1584, 1602, 1675, 1699, 1765, 1788, 1852, 1868,
 /*    30 */  1932, 1958, 2022, 2049, 2111, 2169, 2198, 2256, 2319, 2336,
 /*    40 */  2352, 2423, 2441, 2499, 2528, 2586, 2649, 2666, -282, -336,
 /*    50 */    15,  283,  566,  568,  575,  692,  750,  756, -354, -206,
 /*    60 */  -399,  243,  324, -435, -314, -337, -230,    2,  117, -373,
 /*    70 */  -329, -141,  143, -137,  162,  192, -236,   70,  113,  203,
 /*    80 */   276,  294,  326,  -19,  627,  635, -195, -331,  637,  645,
 /*    90 */   202,  615,   -5,  681,  235,  706,  286,  189,  749,  762,
 /*   100 */   272,  858,  477,  774,  690,  867,   54,  439, -416, -416,
 /*   110 */  -235, -333,  -16,  344,  513,  518,  525,  526,  664,  688,
 /*   120 */   691,  710,  717,  737,  763,  766,  797,  804,  806,  825,
 /*   130 */   827,   10, -375,   85, -198,   87,  312, -375,  -60,  233,
 /*   140 */   302, -238,  231,  382,   21,  601,  743,  -94, -420,  541,
 /*   150 */   514,   98,  728,  788,  381,  464,  524,  542,  727,  742,
 /*   160 */   770,  902,  906,  770,  753,  940,  922,  918,  846,  861,
 /*   170 */   972,  874,  962,  962,  993,  953, 1002,  968,  964,  911,
 /*   180 */   911,  893,  911,  921,  912,  962,  954,  957,  970,  985,
 /*   190 */   986,  987,  990, 1038, 1039,  997,  995, 1009, 1043, 1046,
 /*   200 */  1057, 1059, 1060, 1071, 1073, 1008, 1064, 1037, 1068, 1077,
 /*   210 */  1025, 1076, 1082, 1078, 1080, 1081, 1085, 1083, 1087, 1088,
 /*   220 */  1098, 1070, 1072, 1075, 1086, 1090, 1097, 1099, 1100, 1101,
 /*   230 */  1104, 1105, 1094, 1106, 1063, 1065, 1061, 1045, 1069, 1121,
 /*   240 */  1095, 1091, 1128, 1131, 1089, 1092, 1107, 1024, 1109, 1110,
 /*   250 */  1028, 1111, 1133, 1135,  962, 1029, 1034, 1030, 1050, 1066,
 /*   260 */  1058, 1112, 1047, 1054, 1062,  911, 1148, 1113, 1182, 1185,
 /*   270 */  1183, 1184, 1141, 1140, 1159, 1160, 1164, 1165, 1166, 1147,
 /*   280 */  1167, 1157, 1211, 1194, 1213, 1189, 1126, 1195, 1190, 1208,
 /*   290 */  1223, 1224, 1230, 1238, 1171, 1168, 1191, 1192, 1225, 1228,
 /*   300 */  1233, 1246, 1243,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    10 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    20 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    30 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    40 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    50 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    60 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    70 */  1647, 1647, 1905, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*    80 */  1647, 1647, 1647, 1647, 1647, 1647, 1726, 1647, 1647, 1647,
 /*    90 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   100 */  1647, 1647, 1647, 1647, 1647, 1647, 1724, 1898, 2110, 1647,
 /*   110 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   120 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   130 */  1647, 1647, 2122, 1647, 1647, 1726, 1647, 2122, 2122, 2122,
 /*   140 */  1724, 2082, 2082, 1647, 1647, 1647, 1647, 1958, 1647, 1647,
 /*   150 */  1647, 1647, 1647, 1647, 1833, 1647, 1647, 1647, 1647, 1647,
 /*   160 */  1857, 1647, 1647, 1647, 1950, 1647, 1647, 2147, 2201, 1647,
 /*   170 */  1647, 2150, 1647, 1647, 1647, 1910, 1647, 1786, 2137, 2114,
 /*   180 */  2128, 2185, 2115, 2112, 2131, 1647, 2141, 1647, 1943, 1903,
 /*   190 */  1647, 1903, 1900, 1647, 1647, 1903, 1900, 1900, 1647, 1777,
 /*   200 */  1647, 1647, 1647, 1647, 1647, 1647, 1726, 1647, 1726, 1647,
 /*   210 */  1647, 1726, 1647, 1726, 1726, 1726, 1647, 1726, 1704, 1704,
 /*   220 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   230 */  1647, 1647, 1647, 1647, 1647, 1647, 1968, 1956, 1647, 1724,
 /*   240 */  1952, 1647, 1724, 1647, 1647, 1647, 1647, 2158, 2156, 1647,
 /*   250 */  2158, 2156, 1647, 1647, 1647, 2170, 2166, 2158, 2174, 2172,
 /*   260 */  2143, 2141, 2204, 2191, 2187, 2128, 1647, 1647, 1647, 1647,
 /*   270 */  1724, 1724, 1647, 2156, 1647, 1647, 1647, 1647, 1647, 2156,
 /*   280 */  1647, 1647, 1724, 1647, 1724, 1647, 1647, 1802, 1647, 1647,
 /*   290 */  1647, 1724, 1679, 1647, 1945, 1961, 1928, 1928, 1836, 1836,
 /*   300 */  1836, 1727, 1652, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   310 */  1647, 1647, 1647, 1647, 1647, 2169, 2168, 2037, 1647, 2086,
 /*   320 */  2085, 2084, 2075, 2036, 1798, 1647, 2035, 2034, 1647, 1647,
 /*   330 */  1647, 1647, 1647, 1647, 1919, 1918, 2028, 1647, 1647, 2029,
 /*   340 */  2027, 2026, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   350 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   360 */  2188, 2192, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 2111,
 /*   370 */  1647, 1647, 1647, 1647, 1647, 2010, 1647, 1647, 1647, 1647,
 /*   380 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   390 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   400 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   410 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   420 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   430 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   440 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   450 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   460 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   470 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1684, 2015,
 /*   480 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   490 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   500 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   510 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   520 */  1647, 1647, 1647, 1647, 1647, 1647, 1765, 1764, 1647, 1647,
 /*   530 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   540 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   550 */  2019, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   560 */  1647, 1647, 1647, 1647, 1647, 2184, 2144, 1647, 1647, 1647,
 /*   570 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   580 */  1647, 1647, 1647, 1647, 2010, 1647, 2167, 1647, 1647, 2182,
 /*   590 */  1647, 2186, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 2121,
 /*   600 */  2117, 1647, 1647, 2113, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   610 */  1647, 2018, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   620 */  1647, 1647, 1647, 1647, 1647, 2009, 1647, 2072, 1647, 1647,
 /*   630 */  1647, 2106, 1647, 1647, 2057, 1647, 1647, 1647, 1647, 1647,
 /*   640 */  1647, 1647, 1647, 1647, 2019, 1647, 2022, 1647, 1647, 1647,
 /*   650 */  1647, 1647, 1830, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   660 */  1647, 1647, 1647, 1647, 1647, 1815, 1813, 1812, 1811, 1647,
 /*   670 */  1808, 1647, 1843, 1647, 1647, 1647, 1839, 1838, 1647, 1647,
 /*   680 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   690 */  1647, 1647, 1647, 1745, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   700 */  1647, 1647, 1737, 1647, 1736, 1647, 1647, 1647, 1647, 1647,
 /*   710 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   720 */  1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647, 1647,
 /*   730 */  1647, 1647, 1647, 1647, 1647, 1647, 1647,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  273,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  273,  /*      AFTER => ABORT */
  273,  /*     ATTACH => ABORT */
  273,  /*     BEFORE => ABORT */
  273,  /*      BEGIN => ABORT */
  273,  /*     BITAND => ABORT */
  273,  /*     BITNOT => ABORT */
  273,  /*      BITOR => ABORT */
  273,  /*     BLOCKS => ABORT */
  273,  /*     CHANGE => ABORT */
  273,  /*      COMMA => ABORT */
  273,  /*     CONCAT => ABORT */
  273,  /*   CONFLICT => ABORT */
  273,  /*       COPY => ABORT */
  273,  /*   DEFERRED => ABORT */
  273,  /* DELIMITERS => ABORT */
  273,  /*     DETACH => ABORT */
  273,  /*     DIVIDE => ABORT */
  273,  /*        DOT => ABORT */
  273,  /*       EACH => ABORT */
  273,  /*       FAIL => ABORT */
  273,  /*       FILE => ABORT */
  273,  /*        FOR => ABORT */
  273,  /*       GLOB => ABORT */
  273,  /*         ID => ABORT */
  273,  /*  IMMEDIATE => ABORT */
  273,  /*     IMPORT => ABORT */
  273,  /*  INITIALLY => ABORT */
  273,  /*    INSTEAD => ABORT */
  273,  /*     ISNULL => ABORT */
  273,  /*        KEY => ABORT */
  273,  /*    MODULES => ABORT */
  273,  /*  NK_BITNOT => ABORT */
  273,  /*    NK_SEMI => ABORT */
  273,  /*    NOTNULL => ABORT */
  273,  /*         OF => ABORT */
  273,  /*       PLUS => ABORT */
  273,  /*  PRIVILEGE => ABORT */
  273,  /*      RAISE => ABORT */
  273,  /*    REPLACE => ABORT */
  273,  /*   RESTRICT => ABORT */
  273,  /*        ROW => ABORT */
  273,  /*       SEMI => ABORT */
  273,  /*       STAR => ABORT */
  273,  /*  STATEMENT => ABORT */
  273,  /*     STRICT => ABORT */
  273,  /*     STRING => ABORT */
  273,  /*      TIMES => ABORT */
  273,  /*     UPDATE => ABORT */
  273,  /*     VALUES => ABORT */
  273,  /*   VARIABLE => ABORT */
  273,  /*       VIEW => ABORT */
  273,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "ALIVE",
  /*  162 */ "LIKE",
  /*  163 */ "TBNAME",
  /*  164 */ "QTAGS",
  /*  165 */ "AS",
  /*  166 */ "INDEX",
  /*  167 */ "FUNCTION",
  /*  168 */ "INTERVAL",
  /*  169 */ "COUNT",
  /*  170 */ "LAST_ROW",
  /*  171 */ "TOPIC",
  /*  172 */ "WITH",
  /*  173 */ "META",
  /*  174 */ "CONSUMER",
  /*  175 */ "GROUP",
  /*  176 */ "DESC",
  /*  177 */ "DESCRIBE",
  /*  178 */ "RESET",
  /*  179 */ "QUERY",
  /*  180 */ "CACHE",
  /*  181 */ "EXPLAIN",
  /*  182 */ "ANALYZE",
  /*  183 */ "VERBOSE",
  /*  184 */ "NK_BOOL",
  /*  185 */ "RATIO",
  /*  186 */ "NK_FLOAT",
  /*  187 */ "OUTPUTTYPE",
  /*  188 */ "AGGREGATE",
  /*  189 */ "BUFSIZE",
  /*  190 */ "STREAM",
  /*  191 */ "INTO",
  /*  192 */ "TRIGGER",
  /*  193 */ "AT_ONCE",
  /*  194 */ "WINDOW_CLOSE",
  /*  195 */ "IGNORE",
  /*  196 */ "EXPIRED",
  /*  197 */ "FILL_HISTORY",
  /*  198 */ "SUBTABLE",
  /*  199 */ "KILL",
  /*  200 */ "CONNECTION",
  /*  201 */ "TRANSACTION",
  /*  202 */ "BALANCE",
  /*  203 */ "VGROUP",
  /*  204 */ "MERGE",
  /*  205 */ "REDISTRIBUTE",
  /*  206 */ "SPLIT",
  /*  207 */ "DELETE",
  /*  208 */ "INSERT",
  /*  209 */ "NULL",
  /*  210 */ "NK_QUESTION",
  /*  211 */ "NK_ARROW",
  /*  212 */ "ROWTS",
  /*  213 */ "QSTART",
  /*  214 */ "QEND",
  /*  215 */ "QDURATION",
  /*  216 */ "WSTART",
  /*  217 */ "WEND",
  /*  218 */ "WDURATION",
  /*  219 */ "IROWTS",
  /*  220 */ "ISFILLED",
  /*  221 */ "CAST",
  /*  222 */ "NOW",
  /*  223 */ "TODAY",
  /*  224 */ "TIMEZONE",
  /*  225 */ "CLIENT_VERSION",
  /*  226 */ "SERVER_VERSION",
  /*  227 */ "SERVER_STATUS",
  /*  228 */ "CURRENT_USER",
  /*  229 */ "CASE",
  /*  230 */ "END",
  /*  231 */ "WHEN",
  /*  232 */ "THEN",
  /*  233 */ "ELSE",
  /*  234 */ "BETWEEN",
  /*  235 */ "IS",
  /*  236 */ "NK_LT",
  /*  237 */ "NK_GT",
  /*  238 */ "NK_LE",
  /*  239 */ "NK_GE",
  /*  240 */ "NK_NE",
  /*  241 */ "MATCH",
  /*  242 */ "NMATCH",
  /*  243 */ "CONTAINS",
  /*  244 */ "IN",
  /*  245 */ "JOIN",
  /*  246 */ "INNER",
  /*  247 */ "SELECT",
  /*  248 */ "DISTINCT",
  /*  249 */ "WHERE",
  /*  250 */ "PARTITION",
  /*  251 */ "BY",
  /*  252 */ "SESSION",
  /*  253 */ "STATE_WINDOW",
  /*  254 */ "EVENT_WINDOW",
  /*  255 */ "START",
  /*  256 */ "SLIDING",
  /*  257 */ "FILL",
  /*  258 */ "VALUE",
  /*  259 */ "NONE",
  /*  260 */ "PREV",
  /*  261 */ "LINEAR",
  /*  262 */ "NEXT",
  /*  263 */ "HAVING",
  /*  264 */ "RANGE",
  /*  265 */ "EVERY",
  /*  266 */ "ORDER",
  /*  267 */ "SLIMIT",
  /*  268 */ "SOFFSET",
  /*  269 */ "LIMIT",
  /*  270 */ "OFFSET",
  /*  271 */ "ASC",
  /*  272 */ "NULLS",
  /*  273 */ "ABORT",
  /*  274 */ "AFTER",
  /*  275 */ "ATTACH",
  /*  276 */ "BEFORE",
  /*  277 */ "BEGIN",
  /*  278 */ "BITAND",
  /*  279 */ "BITNOT",
  /*  280 */ "BITOR",
  /*  281 */ "BLOCKS",
  /*  282 */ "CHANGE",
  /*  283 */ "COMMA",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "full_index_name",
  /*  385 */ "index_options",
  /*  386 */ "index_name",
  /*  387 */ "func_list",
  /*  388 */ "sliding_opt",
  /*  389 */ "sma_stream_opt",
  /*  390 */ "func",
  /*  391 */ "sma_func_name",
  /*  392 */ "query_or_subquery",
  /*  393 */ "cgroup_name",
  /*  394 */ "analyze_opt",
  /*  395 */ "explain_options",
  /*  396 */ "agg_func_opt",
  /*  397 */ "bufsize_opt",
  /*  398 */ "stream_name",
  /*  399 */ "stream_options",
  /*  400 */ "col_list_opt",
  /*  401 */ "tag_def_or_ref_opt",
  /*  402 */ "subtable_opt",
  /*  403 */ "expression",
  /*  404 */ "dnode_list",
  /*  405 */ "where_clause_opt",
  /*  406 */ "signed",
  /*  407 */ "literal_func",
  /*  408 */ "literal_list",
  /*  409 */ "table_alias",
  /*  410 */ "expr_or_subquery",
  /*  411 */ "pseudo_column",
  /*  412 */ "column_reference",
  /*  413 */ "function_expression",
  /*  414 */ "case_when_expression",
  /*  415 */ "star_func",
  /*  416 */ "star_func_para_list",
  /*  417 */ "noarg_func",
  /*  418 */ "other_para_list",
  /*  419 */ "star_func_para",
  /*  420 */ "when_then_list",
  /*  421 */ "case_when_else_opt",
  /*  422 */ "common_expression",
  /*  423 */ "when_then_expr",
  /*  424 */ "predicate",
  /*  425 */ "compare_op",
  /*  426 */ "in_op",
  /*  427 */ "in_predicate_value",
  /*  428 */ "boolean_value_expression",
  /*  429 */ "boolean_primary",
  /*  430 */ "from_clause_opt",
  /*  431 */ "table_reference_list",
  /*  432 */ "table_reference",
  /*  433 */ "table_primary",
  /*  434 */ "joined_table",
  /*  435 */ "alias_opt",
  /*  436 */ "subquery",
  /*  437 */ "parenthesized_joined_table",
  /*  438 */ "join_type",
  /*  439 */ "search_condition",
  /*  440 */ "query_specification",
  /*  441 */ "set_quantifier_opt",
  /*  442 */ "select_list",
  /*  443 */ "partition_by_clause_opt",
  /*  444 */ "range_opt",
  /*  445 */ "every_opt",
  /*  446 */ "fill_opt",
  /*  447 */ "twindow_clause_opt",
  /*  448 */ "group_by_clause_opt",
  /*  449 */ "having_clause_opt",
  /*  450 */ "select_item",
  /*  451 */ "partition_list",
  /*  452 */ "partition_item",
  /*  453 */ "fill_mode",
  /*  454 */ "group_by_list",
  /*  455 */ "query_expression",
  /*  456 */ "query_simple",
  /*  457 */ "order_by_clause_opt",
  /*  458 */ "slimit_clause_opt",
  /*  459 */ "limit_clause_opt",
  /*  460 */ "union_query_expression",
  /*  461 */ "query_simple_or_subquery",
  /*  462 */ "sort_specification_list",
  /*  463 */ "sort_specification",
  /*  464 */ "ordering_specification_opt",
  /*  465 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 247 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 248 */ "db_name_cond_opt ::=",
 /* 249 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 250 */ "like_pattern_opt ::=",
 /* 251 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 252 */ "table_name_cond ::= table_name",
 /* 253 */ "from_db_opt ::=",
 /* 254 */ "from_db_opt ::= FROM db_name",
 /* 255 */ "tag_list_opt ::=",
 /* 256 */ "tag_list_opt ::= tag_item",
 /* 257 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 258 */ "tag_item ::= TBNAME",
 /* 259 */ "tag_item ::= QTAGS",
 /* 260 */ "tag_item ::= column_name",
 /* 261 */ "tag_item ::= column_name column_alias",
 /* 262 */ "tag_item ::= column_name AS column_alias",
 /* 263 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 264 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 265 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 266 */ "full_index_name ::= index_name",
 /* 267 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 270 */ "func_list ::= func",
 /* 271 */ "func_list ::= func_list NK_COMMA func",
 /* 272 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 273 */ "sma_func_name ::= function_name",
 /* 274 */ "sma_func_name ::= COUNT",
 /* 275 */ "sma_func_name ::= FIRST",
 /* 276 */ "sma_func_name ::= LAST",
 /* 277 */ "sma_func_name ::= LAST_ROW",
 /* 278 */ "sma_stream_opt ::=",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 281 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 286 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 287 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 288 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 289 */ "cmd ::= DESC full_table_name",
 /* 290 */ "cmd ::= DESCRIBE full_table_name",
 /* 291 */ "cmd ::= RESET QUERY CACHE",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 293 */ "analyze_opt ::=",
 /* 294 */ "analyze_opt ::= ANALYZE",
 /* 295 */ "explain_options ::=",
 /* 296 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 297 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 298 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 299 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 300 */ "agg_func_opt ::=",
 /* 301 */ "agg_func_opt ::= AGGREGATE",
 /* 302 */ "bufsize_opt ::=",
 /* 303 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 304 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 305 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 306 */ "col_list_opt ::=",
 /* 307 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 308 */ "tag_def_or_ref_opt ::=",
 /* 309 */ "tag_def_or_ref_opt ::= tags_def",
 /* 310 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 311 */ "stream_options ::=",
 /* 312 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 313 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 314 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 315 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 316 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 317 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 318 */ "subtable_opt ::=",
 /* 319 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 320 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 321 */ "cmd ::= KILL QUERY NK_STRING",
 /* 322 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 323 */ "cmd ::= BALANCE VGROUP",
 /* 324 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 325 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 326 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 327 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 328 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 329 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 330 */ "cmd ::= query_or_subquery",
 /* 331 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 332 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 333 */ "literal ::= NK_INTEGER",
 /* 334 */ "literal ::= NK_FLOAT",
 /* 335 */ "literal ::= NK_STRING",
 /* 336 */ "literal ::= NK_BOOL",
 /* 337 */ "literal ::= TIMESTAMP NK_STRING",
 /* 338 */ "literal ::= duration_literal",
 /* 339 */ "literal ::= NULL",
 /* 340 */ "literal ::= NK_QUESTION",
 /* 341 */ "duration_literal ::= NK_VARIABLE",
 /* 342 */ "signed ::= NK_INTEGER",
 /* 343 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 344 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 345 */ "signed ::= NK_FLOAT",
 /* 346 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 347 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 348 */ "signed_literal ::= signed",
 /* 349 */ "signed_literal ::= NK_STRING",
 /* 350 */ "signed_literal ::= NK_BOOL",
 /* 351 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 352 */ "signed_literal ::= duration_literal",
 /* 353 */ "signed_literal ::= NULL",
 /* 354 */ "signed_literal ::= literal_func",
 /* 355 */ "signed_literal ::= NK_QUESTION",
 /* 356 */ "literal_list ::= signed_literal",
 /* 357 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 358 */ "db_name ::= NK_ID",
 /* 359 */ "table_name ::= NK_ID",
 /* 360 */ "column_name ::= NK_ID",
 /* 361 */ "function_name ::= NK_ID",
 /* 362 */ "table_alias ::= NK_ID",
 /* 363 */ "column_alias ::= NK_ID",
 /* 364 */ "user_name ::= NK_ID",
 /* 365 */ "topic_name ::= NK_ID",
 /* 366 */ "stream_name ::= NK_ID",
 /* 367 */ "cgroup_name ::= NK_ID",
 /* 368 */ "index_name ::= NK_ID",
 /* 369 */ "expr_or_subquery ::= expression",
 /* 370 */ "expression ::= literal",
 /* 371 */ "expression ::= pseudo_column",
 /* 372 */ "expression ::= column_reference",
 /* 373 */ "expression ::= function_expression",
 /* 374 */ "expression ::= case_when_expression",
 /* 375 */ "expression ::= NK_LP expression NK_RP",
 /* 376 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 377 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 378 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 379 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 380 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 382 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 383 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 384 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 385 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 386 */ "expression_list ::= expr_or_subquery",
 /* 387 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 388 */ "column_reference ::= column_name",
 /* 389 */ "column_reference ::= table_name NK_DOT column_name",
 /* 390 */ "pseudo_column ::= ROWTS",
 /* 391 */ "pseudo_column ::= TBNAME",
 /* 392 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 393 */ "pseudo_column ::= QSTART",
 /* 394 */ "pseudo_column ::= QEND",
 /* 395 */ "pseudo_column ::= QDURATION",
 /* 396 */ "pseudo_column ::= WSTART",
 /* 397 */ "pseudo_column ::= WEND",
 /* 398 */ "pseudo_column ::= WDURATION",
 /* 399 */ "pseudo_column ::= IROWTS",
 /* 400 */ "pseudo_column ::= ISFILLED",
 /* 401 */ "pseudo_column ::= QTAGS",
 /* 402 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 403 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 404 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 405 */ "function_expression ::= literal_func",
 /* 406 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 407 */ "literal_func ::= NOW",
 /* 408 */ "noarg_func ::= NOW",
 /* 409 */ "noarg_func ::= TODAY",
 /* 410 */ "noarg_func ::= TIMEZONE",
 /* 411 */ "noarg_func ::= DATABASE",
 /* 412 */ "noarg_func ::= CLIENT_VERSION",
 /* 413 */ "noarg_func ::= SERVER_VERSION",
 /* 414 */ "noarg_func ::= SERVER_STATUS",
 /* 415 */ "noarg_func ::= CURRENT_USER",
 /* 416 */ "noarg_func ::= USER",
 /* 417 */ "star_func ::= COUNT",
 /* 418 */ "star_func ::= FIRST",
 /* 419 */ "star_func ::= LAST",
 /* 420 */ "star_func ::= LAST_ROW",
 /* 421 */ "star_func_para_list ::= NK_STAR",
 /* 422 */ "star_func_para_list ::= other_para_list",
 /* 423 */ "other_para_list ::= star_func_para",
 /* 424 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 425 */ "star_func_para ::= expr_or_subquery",
 /* 426 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 427 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 428 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 429 */ "when_then_list ::= when_then_expr",
 /* 430 */ "when_then_list ::= when_then_list when_then_expr",
 /* 431 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 432 */ "case_when_else_opt ::=",
 /* 433 */ "case_when_else_opt ::= ELSE common_expression",
 /* 434 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 435 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 436 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 437 */ "predicate ::= expr_or_subquery IS NULL",
 /* 438 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 439 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 440 */ "compare_op ::= NK_LT",
 /* 441 */ "compare_op ::= NK_GT",
 /* 442 */ "compare_op ::= NK_LE",
 /* 443 */ "compare_op ::= NK_GE",
 /* 444 */ "compare_op ::= NK_NE",
 /* 445 */ "compare_op ::= NK_EQ",
 /* 446 */ "compare_op ::= LIKE",
 /* 447 */ "compare_op ::= NOT LIKE",
 /* 448 */ "compare_op ::= MATCH",
 /* 449 */ "compare_op ::= NMATCH",
 /* 450 */ "compare_op ::= CONTAINS",
 /* 451 */ "in_op ::= IN",
 /* 452 */ "in_op ::= NOT IN",
 /* 453 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 454 */ "boolean_value_expression ::= boolean_primary",
 /* 455 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 456 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 457 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 458 */ "boolean_primary ::= predicate",
 /* 459 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 460 */ "common_expression ::= expr_or_subquery",
 /* 461 */ "common_expression ::= boolean_value_expression",
 /* 462 */ "from_clause_opt ::=",
 /* 463 */ "from_clause_opt ::= FROM table_reference_list",
 /* 464 */ "table_reference_list ::= table_reference",
 /* 465 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 466 */ "table_reference ::= table_primary",
 /* 467 */ "table_reference ::= joined_table",
 /* 468 */ "table_primary ::= table_name alias_opt",
 /* 469 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 470 */ "table_primary ::= subquery alias_opt",
 /* 471 */ "table_primary ::= parenthesized_joined_table",
 /* 472 */ "alias_opt ::=",
 /* 473 */ "alias_opt ::= table_alias",
 /* 474 */ "alias_opt ::= AS table_alias",
 /* 475 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 476 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 477 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 478 */ "join_type ::=",
 /* 479 */ "join_type ::= INNER",
 /* 480 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 481 */ "set_quantifier_opt ::=",
 /* 482 */ "set_quantifier_opt ::= DISTINCT",
 /* 483 */ "set_quantifier_opt ::= ALL",
 /* 484 */ "select_list ::= select_item",
 /* 485 */ "select_list ::= select_list NK_COMMA select_item",
 /* 486 */ "select_item ::= NK_STAR",
 /* 487 */ "select_item ::= common_expression",
 /* 488 */ "select_item ::= common_expression column_alias",
 /* 489 */ "select_item ::= common_expression AS column_alias",
 /* 490 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 491 */ "where_clause_opt ::=",
 /* 492 */ "where_clause_opt ::= WHERE search_condition",
 /* 493 */ "partition_by_clause_opt ::=",
 /* 494 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 495 */ "partition_list ::= partition_item",
 /* 496 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 497 */ "partition_item ::= expr_or_subquery",
 /* 498 */ "partition_item ::= expr_or_subquery column_alias",
 /* 499 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 500 */ "twindow_clause_opt ::=",
 /* 501 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 502 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 503 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 504 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 505 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 506 */ "sliding_opt ::=",
 /* 507 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 508 */ "fill_opt ::=",
 /* 509 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 510 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 511 */ "fill_mode ::= NONE",
 /* 512 */ "fill_mode ::= PREV",
 /* 513 */ "fill_mode ::= NULL",
 /* 514 */ "fill_mode ::= LINEAR",
 /* 515 */ "fill_mode ::= NEXT",
 /* 516 */ "group_by_clause_opt ::=",
 /* 517 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 518 */ "group_by_list ::= expr_or_subquery",
 /* 519 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 520 */ "having_clause_opt ::=",
 /* 521 */ "having_clause_opt ::= HAVING search_condition",
 /* 522 */ "range_opt ::=",
 /* 523 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 524 */ "every_opt ::=",
 /* 525 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 526 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 527 */ "query_simple ::= query_specification",
 /* 528 */ "query_simple ::= union_query_expression",
 /* 529 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 530 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 531 */ "query_simple_or_subquery ::= query_simple",
 /* 532 */ "query_simple_or_subquery ::= subquery",
 /* 533 */ "query_or_subquery ::= query_expression",
 /* 534 */ "query_or_subquery ::= subquery",
 /* 535 */ "order_by_clause_opt ::=",
 /* 536 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 537 */ "slimit_clause_opt ::=",
 /* 538 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 539 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 540 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 541 */ "limit_clause_opt ::=",
 /* 542 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 543 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 544 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 545 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 546 */ "subquery ::= NK_LP subquery NK_RP",
 /* 547 */ "search_condition ::= common_expression",
 /* 548 */ "sort_specification_list ::= sort_specification",
 /* 549 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 550 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 551 */ "ordering_specification_opt ::=",
 /* 552 */ "ordering_specification_opt ::= ASC",
 /* 553 */ "ordering_specification_opt ::= DESC",
 /* 554 */ "null_ordering_opt ::=",
 /* 555 */ "null_ordering_opt ::= NULLS FIRST",
 /* 556 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* full_index_name */
    case 385: /* index_options */
    case 388: /* sliding_opt */
    case 389: /* sma_stream_opt */
    case 390: /* func */
    case 392: /* query_or_subquery */
    case 395: /* explain_options */
    case 399: /* stream_options */
    case 402: /* subtable_opt */
    case 403: /* expression */
    case 405: /* where_clause_opt */
    case 406: /* signed */
    case 407: /* literal_func */
    case 410: /* expr_or_subquery */
    case 411: /* pseudo_column */
    case 412: /* column_reference */
    case 413: /* function_expression */
    case 414: /* case_when_expression */
    case 419: /* star_func_para */
    case 421: /* case_when_else_opt */
    case 422: /* common_expression */
    case 423: /* when_then_expr */
    case 424: /* predicate */
    case 427: /* in_predicate_value */
    case 428: /* boolean_value_expression */
    case 429: /* boolean_primary */
    case 430: /* from_clause_opt */
    case 431: /* table_reference_list */
    case 432: /* table_reference */
    case 433: /* table_primary */
    case 434: /* joined_table */
    case 436: /* subquery */
    case 437: /* parenthesized_joined_table */
    case 439: /* search_condition */
    case 440: /* query_specification */
    case 444: /* range_opt */
    case 445: /* every_opt */
    case 446: /* fill_opt */
    case 447: /* twindow_clause_opt */
    case 449: /* having_clause_opt */
    case 450: /* select_item */
    case 452: /* partition_item */
    case 455: /* query_expression */
    case 456: /* query_simple */
    case 458: /* slimit_clause_opt */
    case 459: /* limit_clause_opt */
    case 460: /* union_query_expression */
    case 461: /* query_simple_or_subquery */
    case 463: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy924)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 397: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 386: /* index_name */
    case 391: /* sma_func_name */
    case 393: /* cgroup_name */
    case 398: /* stream_name */
    case 409: /* table_alias */
    case 415: /* star_func */
    case 417: /* noarg_func */
    case 435: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 394: /* analyze_opt */
    case 396: /* agg_func_opt */
    case 441: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 387: /* func_list */
    case 400: /* col_list_opt */
    case 401: /* tag_def_or_ref_opt */
    case 404: /* dnode_list */
    case 408: /* literal_list */
    case 416: /* star_func_para_list */
    case 418: /* other_para_list */
    case 420: /* when_then_list */
    case 442: /* select_list */
    case 443: /* partition_by_clause_opt */
    case 448: /* group_by_clause_opt */
    case 451: /* partition_list */
    case 454: /* group_by_list */
    case 457: /* order_by_clause_opt */
    case 462: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy776)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 425: /* compare_op */
    case 426: /* in_op */
{
 
}
      break;
    case 438: /* join_type */
{
 
}
      break;
    case 453: /* fill_mode */
{
 
}
      break;
    case 464: /* ordering_specification_opt */
{
 
}
      break;
    case 465: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  326,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  326,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  327,    0 }, /* (2) account_options ::= */
  {  327,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  327,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  327,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  327,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  327,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  327,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  327,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  327,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  327,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  328,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  328,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  330,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  330,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  330,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  330,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  330,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  330,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  330,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  330,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  330,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  330,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  326,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  326,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  326,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  326,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  326,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  332,    0 }, /* (29) sysinfo_opt ::= */
  {  332,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  326,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  326,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  333,   -1 }, /* (33) privileges ::= ALL */
  {  333,   -1 }, /* (34) privileges ::= priv_type_list */
  {  333,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  335,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  335,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  336,   -1 }, /* (38) priv_type ::= READ */
  {  336,   -1 }, /* (39) priv_type ::= WRITE */
  {  334,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  334,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  334,   -1 }, /* (42) priv_level ::= topic_name */
  {  326,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  326,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  326,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  326,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  326,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  326,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  326,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  326,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  339,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  339,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  339,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  340,    0 }, /* (54) force_opt ::= */
  {  340,   -1 }, /* (55) force_opt ::= FORCE */
  {  326,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  326,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  326,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  326,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  326,   -2 }, /* (68) cmd ::= USE db_name */
  {  326,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  326,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  326,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  326,   -3 }, /* (72) cmd ::= COMPACT DATABASE db_name */
  {  341,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  341,    0 }, /* (74) not_exists_opt ::= */
  {  343,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  343,    0 }, /* (76) exists_opt ::= */
  {  342,    0 }, /* (77) db_options ::= */
  {  342,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  342,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  342,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  342,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  342,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  342,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  342,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  342,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  342,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  342,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  342,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  342,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  342,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  342,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  342,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  342,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  342,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  342,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  342,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  342,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  342,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  342,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  342,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  342,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  344,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  344,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  349,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  349,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  349,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  349,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  349,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  349,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  349,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  349,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  349,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  349,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  346,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  346,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  347,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  347,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  348,   -1 }, /* (124) retention_list ::= retention */
  {  348,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  350,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  345,    0 }, /* (127) speed_opt ::= */
  {  345,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  326,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  326,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  326,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  326,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  326,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  326,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  326,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  358,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  358,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  358,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  358,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  358,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  358,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  358,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  358,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  358,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  358,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  355,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  355,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  363,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  357,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  357,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  366,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  364,    0 }, /* (152) specific_cols_opt ::= */
  {  364,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (154) full_table_name ::= table_name */
  {  351,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  352,   -1 }, /* (156) column_def_list ::= column_def */
  {  352,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  369,   -2 }, /* (158) column_def ::= column_name type_name */
  {  369,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  361,   -1 }, /* (160) type_name ::= BOOL */
  {  361,   -1 }, /* (161) type_name ::= TINYINT */
  {  361,   -1 }, /* (162) type_name ::= SMALLINT */
  {  361,   -1 }, /* (163) type_name ::= INT */
  {  361,   -1 }, /* (164) type_name ::= INTEGER */
  {  361,   -1 }, /* (165) type_name ::= BIGINT */
  {  361,   -1 }, /* (166) type_name ::= FLOAT */
  {  361,   -1 }, /* (167) type_name ::= DOUBLE */
  {  361,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  361,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  361,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  361,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  361,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  361,   -1 }, /* (175) type_name ::= JSON */
  {  361,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  361,   -1 }, /* (178) type_name ::= BLOB */
  {  361,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (180) type_name ::= DECIMAL */
  {  361,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  361,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  353,    0 }, /* (183) tags_def_opt ::= */
  {  353,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  356,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  354,    0 }, /* (186) table_options ::= */
  {  354,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  354,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  354,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  354,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  354,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  354,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  354,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  359,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  359,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  372,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  372,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  370,   -1 }, /* (198) duration_list ::= duration_literal */
  {  370,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  371,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  371,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  374,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  374,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  374,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  367,   -1 }, /* (205) col_name_list ::= col_name */
  {  367,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  376,   -1 }, /* (207) col_name ::= column_name */
  {  326,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  326,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  326,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  326,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  326,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  326,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  326,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  326,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  326,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  326,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  326,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  326,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  326,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  326,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  326,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  326,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  326,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  326,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  326,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  326,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  326,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  326,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  326,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  326,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  326,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  326,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  326,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  326,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  326,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  326,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  326,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  326,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  326,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  326,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  326,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  326,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  326,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  326,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  326,   -3 }, /* (246) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  326,   -3 }, /* (247) cmd ::= SHOW CLUSTER ALIVE */
  {  377,    0 }, /* (248) db_name_cond_opt ::= */
  {  377,   -2 }, /* (249) db_name_cond_opt ::= db_name NK_DOT */
  {  378,    0 }, /* (250) like_pattern_opt ::= */
  {  378,   -2 }, /* (251) like_pattern_opt ::= LIKE NK_STRING */
  {  379,   -1 }, /* (252) table_name_cond ::= table_name */
  {  380,    0 }, /* (253) from_db_opt ::= */
  {  380,   -2 }, /* (254) from_db_opt ::= FROM db_name */
  {  381,    0 }, /* (255) tag_list_opt ::= */
  {  381,   -1 }, /* (256) tag_list_opt ::= tag_item */
  {  381,   -3 }, /* (257) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  382,   -1 }, /* (258) tag_item ::= TBNAME */
  {  382,   -1 }, /* (259) tag_item ::= QTAGS */
  {  382,   -1 }, /* (260) tag_item ::= column_name */
  {  382,   -2 }, /* (261) tag_item ::= column_name column_alias */
  {  382,   -3 }, /* (262) tag_item ::= column_name AS column_alias */
  {  326,   -8 }, /* (263) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  326,   -9 }, /* (264) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  326,   -4 }, /* (265) cmd ::= DROP INDEX exists_opt full_index_name */
  {  384,   -1 }, /* (266) full_index_name ::= index_name */
  {  384,   -3 }, /* (267) full_index_name ::= db_name NK_DOT index_name */
  {  385,  -10 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  385,  -12 }, /* (269) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,   -1 }, /* (270) func_list ::= func */
  {  387,   -3 }, /* (271) func_list ::= func_list NK_COMMA func */
  {  390,   -4 }, /* (272) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  391,   -1 }, /* (273) sma_func_name ::= function_name */
  {  391,   -1 }, /* (274) sma_func_name ::= COUNT */
  {  391,   -1 }, /* (275) sma_func_name ::= FIRST */
  {  391,   -1 }, /* (276) sma_func_name ::= LAST */
  {  391,   -1 }, /* (277) sma_func_name ::= LAST_ROW */
  {  389,    0 }, /* (278) sma_stream_opt ::= */
  {  389,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  389,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  389,   -3 }, /* (281) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  326,   -6 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  326,   -7 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  326,   -9 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  326,   -7 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  326,   -9 }, /* (286) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  326,   -4 }, /* (287) cmd ::= DROP TOPIC exists_opt topic_name */
  {  326,   -7 }, /* (288) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  326,   -2 }, /* (289) cmd ::= DESC full_table_name */
  {  326,   -2 }, /* (290) cmd ::= DESCRIBE full_table_name */
  {  326,   -3 }, /* (291) cmd ::= RESET QUERY CACHE */
  {  326,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  394,    0 }, /* (293) analyze_opt ::= */
  {  394,   -1 }, /* (294) analyze_opt ::= ANALYZE */
  {  395,    0 }, /* (295) explain_options ::= */
  {  395,   -3 }, /* (296) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  395,   -3 }, /* (297) explain_options ::= explain_options RATIO NK_FLOAT */
  {  326,  -10 }, /* (298) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  326,   -4 }, /* (299) cmd ::= DROP FUNCTION exists_opt function_name */
  {  396,    0 }, /* (300) agg_func_opt ::= */
  {  396,   -1 }, /* (301) agg_func_opt ::= AGGREGATE */
  {  397,    0 }, /* (302) bufsize_opt ::= */
  {  397,   -2 }, /* (303) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  326,  -12 }, /* (304) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  326,   -4 }, /* (305) cmd ::= DROP STREAM exists_opt stream_name */
  {  400,    0 }, /* (306) col_list_opt ::= */
  {  400,   -3 }, /* (307) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  401,    0 }, /* (308) tag_def_or_ref_opt ::= */
  {  401,   -1 }, /* (309) tag_def_or_ref_opt ::= tags_def */
  {  401,   -4 }, /* (310) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  399,    0 }, /* (311) stream_options ::= */
  {  399,   -3 }, /* (312) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  399,   -3 }, /* (313) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  399,   -4 }, /* (314) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  399,   -3 }, /* (315) stream_options ::= stream_options WATERMARK duration_literal */
  {  399,   -4 }, /* (316) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  399,   -3 }, /* (317) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  402,    0 }, /* (318) subtable_opt ::= */
  {  402,   -4 }, /* (319) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  326,   -3 }, /* (320) cmd ::= KILL CONNECTION NK_INTEGER */
  {  326,   -3 }, /* (321) cmd ::= KILL QUERY NK_STRING */
  {  326,   -3 }, /* (322) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  326,   -2 }, /* (323) cmd ::= BALANCE VGROUP */
  {  326,   -4 }, /* (324) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  326,   -4 }, /* (325) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  326,   -3 }, /* (326) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  404,   -2 }, /* (327) dnode_list ::= DNODE NK_INTEGER */
  {  404,   -3 }, /* (328) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  326,   -4 }, /* (329) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  326,   -1 }, /* (330) cmd ::= query_or_subquery */
  {  326,   -7 }, /* (331) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  326,   -4 }, /* (332) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  329,   -1 }, /* (333) literal ::= NK_INTEGER */
  {  329,   -1 }, /* (334) literal ::= NK_FLOAT */
  {  329,   -1 }, /* (335) literal ::= NK_STRING */
  {  329,   -1 }, /* (336) literal ::= NK_BOOL */
  {  329,   -2 }, /* (337) literal ::= TIMESTAMP NK_STRING */
  {  329,   -1 }, /* (338) literal ::= duration_literal */
  {  329,   -1 }, /* (339) literal ::= NULL */
  {  329,   -1 }, /* (340) literal ::= NK_QUESTION */
  {  373,   -1 }, /* (341) duration_literal ::= NK_VARIABLE */
  {  406,   -1 }, /* (342) signed ::= NK_INTEGER */
  {  406,   -2 }, /* (343) signed ::= NK_PLUS NK_INTEGER */
  {  406,   -2 }, /* (344) signed ::= NK_MINUS NK_INTEGER */
  {  406,   -1 }, /* (345) signed ::= NK_FLOAT */
  {  406,   -2 }, /* (346) signed ::= NK_PLUS NK_FLOAT */
  {  406,   -2 }, /* (347) signed ::= NK_MINUS NK_FLOAT */
  {  362,   -1 }, /* (348) signed_literal ::= signed */
  {  362,   -1 }, /* (349) signed_literal ::= NK_STRING */
  {  362,   -1 }, /* (350) signed_literal ::= NK_BOOL */
  {  362,   -2 }, /* (351) signed_literal ::= TIMESTAMP NK_STRING */
  {  362,   -1 }, /* (352) signed_literal ::= duration_literal */
  {  362,   -1 }, /* (353) signed_literal ::= NULL */
  {  362,   -1 }, /* (354) signed_literal ::= literal_func */
  {  362,   -1 }, /* (355) signed_literal ::= NK_QUESTION */
  {  408,   -1 }, /* (356) literal_list ::= signed_literal */
  {  408,   -3 }, /* (357) literal_list ::= literal_list NK_COMMA signed_literal */
  {  337,   -1 }, /* (358) db_name ::= NK_ID */
  {  368,   -1 }, /* (359) table_name ::= NK_ID */
  {  360,   -1 }, /* (360) column_name ::= NK_ID */
  {  375,   -1 }, /* (361) function_name ::= NK_ID */
  {  409,   -1 }, /* (362) table_alias ::= NK_ID */
  {  383,   -1 }, /* (363) column_alias ::= NK_ID */
  {  331,   -1 }, /* (364) user_name ::= NK_ID */
  {  338,   -1 }, /* (365) topic_name ::= NK_ID */
  {  398,   -1 }, /* (366) stream_name ::= NK_ID */
  {  393,   -1 }, /* (367) cgroup_name ::= NK_ID */
  {  386,   -1 }, /* (368) index_name ::= NK_ID */
  {  410,   -1 }, /* (369) expr_or_subquery ::= expression */
  {  403,   -1 }, /* (370) expression ::= literal */
  {  403,   -1 }, /* (371) expression ::= pseudo_column */
  {  403,   -1 }, /* (372) expression ::= column_reference */
  {  403,   -1 }, /* (373) expression ::= function_expression */
  {  403,   -1 }, /* (374) expression ::= case_when_expression */
  {  403,   -3 }, /* (375) expression ::= NK_LP expression NK_RP */
  {  403,   -2 }, /* (376) expression ::= NK_PLUS expr_or_subquery */
  {  403,   -2 }, /* (377) expression ::= NK_MINUS expr_or_subquery */
  {  403,   -3 }, /* (378) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  403,   -3 }, /* (379) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  403,   -3 }, /* (380) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  403,   -3 }, /* (381) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  403,   -3 }, /* (382) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  403,   -3 }, /* (383) expression ::= column_reference NK_ARROW NK_STRING */
  {  403,   -3 }, /* (384) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  403,   -3 }, /* (385) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  365,   -1 }, /* (386) expression_list ::= expr_or_subquery */
  {  365,   -3 }, /* (387) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  412,   -1 }, /* (388) column_reference ::= column_name */
  {  412,   -3 }, /* (389) column_reference ::= table_name NK_DOT column_name */
  {  411,   -1 }, /* (390) pseudo_column ::= ROWTS */
  {  411,   -1 }, /* (391) pseudo_column ::= TBNAME */
  {  411,   -3 }, /* (392) pseudo_column ::= table_name NK_DOT TBNAME */
  {  411,   -1 }, /* (393) pseudo_column ::= QSTART */
  {  411,   -1 }, /* (394) pseudo_column ::= QEND */
  {  411,   -1 }, /* (395) pseudo_column ::= QDURATION */
  {  411,   -1 }, /* (396) pseudo_column ::= WSTART */
  {  411,   -1 }, /* (397) pseudo_column ::= WEND */
  {  411,   -1 }, /* (398) pseudo_column ::= WDURATION */
  {  411,   -1 }, /* (399) pseudo_column ::= IROWTS */
  {  411,   -1 }, /* (400) pseudo_column ::= ISFILLED */
  {  411,   -1 }, /* (401) pseudo_column ::= QTAGS */
  {  413,   -4 }, /* (402) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  413,   -4 }, /* (403) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  413,   -6 }, /* (404) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  413,   -1 }, /* (405) function_expression ::= literal_func */
  {  407,   -3 }, /* (406) literal_func ::= noarg_func NK_LP NK_RP */
  {  407,   -1 }, /* (407) literal_func ::= NOW */
  {  417,   -1 }, /* (408) noarg_func ::= NOW */
  {  417,   -1 }, /* (409) noarg_func ::= TODAY */
  {  417,   -1 }, /* (410) noarg_func ::= TIMEZONE */
  {  417,   -1 }, /* (411) noarg_func ::= DATABASE */
  {  417,   -1 }, /* (412) noarg_func ::= CLIENT_VERSION */
  {  417,   -1 }, /* (413) noarg_func ::= SERVER_VERSION */
  {  417,   -1 }, /* (414) noarg_func ::= SERVER_STATUS */
  {  417,   -1 }, /* (415) noarg_func ::= CURRENT_USER */
  {  417,   -1 }, /* (416) noarg_func ::= USER */
  {  415,   -1 }, /* (417) star_func ::= COUNT */
  {  415,   -1 }, /* (418) star_func ::= FIRST */
  {  415,   -1 }, /* (419) star_func ::= LAST */
  {  415,   -1 }, /* (420) star_func ::= LAST_ROW */
  {  416,   -1 }, /* (421) star_func_para_list ::= NK_STAR */
  {  416,   -1 }, /* (422) star_func_para_list ::= other_para_list */
  {  418,   -1 }, /* (423) other_para_list ::= star_func_para */
  {  418,   -3 }, /* (424) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  419,   -1 }, /* (425) star_func_para ::= expr_or_subquery */
  {  419,   -3 }, /* (426) star_func_para ::= table_name NK_DOT NK_STAR */
  {  414,   -4 }, /* (427) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  414,   -5 }, /* (428) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  420,   -1 }, /* (429) when_then_list ::= when_then_expr */
  {  420,   -2 }, /* (430) when_then_list ::= when_then_list when_then_expr */
  {  423,   -4 }, /* (431) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  421,    0 }, /* (432) case_when_else_opt ::= */
  {  421,   -2 }, /* (433) case_when_else_opt ::= ELSE common_expression */
  {  424,   -3 }, /* (434) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  424,   -5 }, /* (435) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  424,   -6 }, /* (436) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  424,   -3 }, /* (437) predicate ::= expr_or_subquery IS NULL */
  {  424,   -4 }, /* (438) predicate ::= expr_or_subquery IS NOT NULL */
  {  424,   -3 }, /* (439) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  425,   -1 }, /* (440) compare_op ::= NK_LT */
  {  425,   -1 }, /* (441) compare_op ::= NK_GT */
  {  425,   -1 }, /* (442) compare_op ::= NK_LE */
  {  425,   -1 }, /* (443) compare_op ::= NK_GE */
  {  425,   -1 }, /* (444) compare_op ::= NK_NE */
  {  425,   -1 }, /* (445) compare_op ::= NK_EQ */
  {  425,   -1 }, /* (446) compare_op ::= LIKE */
  {  425,   -2 }, /* (447) compare_op ::= NOT LIKE */
  {  425,   -1 }, /* (448) compare_op ::= MATCH */
  {  425,   -1 }, /* (449) compare_op ::= NMATCH */
  {  425,   -1 }, /* (450) compare_op ::= CONTAINS */
  {  426,   -1 }, /* (451) in_op ::= IN */
  {  426,   -2 }, /* (452) in_op ::= NOT IN */
  {  427,   -3 }, /* (453) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  428,   -1 }, /* (454) boolean_value_expression ::= boolean_primary */
  {  428,   -2 }, /* (455) boolean_value_expression ::= NOT boolean_primary */
  {  428,   -3 }, /* (456) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  428,   -3 }, /* (457) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  429,   -1 }, /* (458) boolean_primary ::= predicate */
  {  429,   -3 }, /* (459) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  422,   -1 }, /* (460) common_expression ::= expr_or_subquery */
  {  422,   -1 }, /* (461) common_expression ::= boolean_value_expression */
  {  430,    0 }, /* (462) from_clause_opt ::= */
  {  430,   -2 }, /* (463) from_clause_opt ::= FROM table_reference_list */
  {  431,   -1 }, /* (464) table_reference_list ::= table_reference */
  {  431,   -3 }, /* (465) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  432,   -1 }, /* (466) table_reference ::= table_primary */
  {  432,   -1 }, /* (467) table_reference ::= joined_table */
  {  433,   -2 }, /* (468) table_primary ::= table_name alias_opt */
  {  433,   -4 }, /* (469) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  433,   -2 }, /* (470) table_primary ::= subquery alias_opt */
  {  433,   -1 }, /* (471) table_primary ::= parenthesized_joined_table */
  {  435,    0 }, /* (472) alias_opt ::= */
  {  435,   -1 }, /* (473) alias_opt ::= table_alias */
  {  435,   -2 }, /* (474) alias_opt ::= AS table_alias */
  {  437,   -3 }, /* (475) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  437,   -3 }, /* (476) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  434,   -6 }, /* (477) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  438,    0 }, /* (478) join_type ::= */
  {  438,   -1 }, /* (479) join_type ::= INNER */
  {  440,  -12 }, /* (480) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  441,    0 }, /* (481) set_quantifier_opt ::= */
  {  441,   -1 }, /* (482) set_quantifier_opt ::= DISTINCT */
  {  441,   -1 }, /* (483) set_quantifier_opt ::= ALL */
  {  442,   -1 }, /* (484) select_list ::= select_item */
  {  442,   -3 }, /* (485) select_list ::= select_list NK_COMMA select_item */
  {  450,   -1 }, /* (486) select_item ::= NK_STAR */
  {  450,   -1 }, /* (487) select_item ::= common_expression */
  {  450,   -2 }, /* (488) select_item ::= common_expression column_alias */
  {  450,   -3 }, /* (489) select_item ::= common_expression AS column_alias */
  {  450,   -3 }, /* (490) select_item ::= table_name NK_DOT NK_STAR */
  {  405,    0 }, /* (491) where_clause_opt ::= */
  {  405,   -2 }, /* (492) where_clause_opt ::= WHERE search_condition */
  {  443,    0 }, /* (493) partition_by_clause_opt ::= */
  {  443,   -3 }, /* (494) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  451,   -1 }, /* (495) partition_list ::= partition_item */
  {  451,   -3 }, /* (496) partition_list ::= partition_list NK_COMMA partition_item */
  {  452,   -1 }, /* (497) partition_item ::= expr_or_subquery */
  {  452,   -2 }, /* (498) partition_item ::= expr_or_subquery column_alias */
  {  452,   -3 }, /* (499) partition_item ::= expr_or_subquery AS column_alias */
  {  447,    0 }, /* (500) twindow_clause_opt ::= */
  {  447,   -6 }, /* (501) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  447,   -4 }, /* (502) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  447,   -6 }, /* (503) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  447,   -8 }, /* (504) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  447,   -7 }, /* (505) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  388,    0 }, /* (506) sliding_opt ::= */
  {  388,   -4 }, /* (507) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  446,    0 }, /* (508) fill_opt ::= */
  {  446,   -4 }, /* (509) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  446,   -6 }, /* (510) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  453,   -1 }, /* (511) fill_mode ::= NONE */
  {  453,   -1 }, /* (512) fill_mode ::= PREV */
  {  453,   -1 }, /* (513) fill_mode ::= NULL */
  {  453,   -1 }, /* (514) fill_mode ::= LINEAR */
  {  453,   -1 }, /* (515) fill_mode ::= NEXT */
  {  448,    0 }, /* (516) group_by_clause_opt ::= */
  {  448,   -3 }, /* (517) group_by_clause_opt ::= GROUP BY group_by_list */
  {  454,   -1 }, /* (518) group_by_list ::= expr_or_subquery */
  {  454,   -3 }, /* (519) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  449,    0 }, /* (520) having_clause_opt ::= */
  {  449,   -2 }, /* (521) having_clause_opt ::= HAVING search_condition */
  {  444,    0 }, /* (522) range_opt ::= */
  {  444,   -6 }, /* (523) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  445,    0 }, /* (524) every_opt ::= */
  {  445,   -4 }, /* (525) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  455,   -4 }, /* (526) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  456,   -1 }, /* (527) query_simple ::= query_specification */
  {  456,   -1 }, /* (528) query_simple ::= union_query_expression */
  {  460,   -4 }, /* (529) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  460,   -3 }, /* (530) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  461,   -1 }, /* (531) query_simple_or_subquery ::= query_simple */
  {  461,   -1 }, /* (532) query_simple_or_subquery ::= subquery */
  {  392,   -1 }, /* (533) query_or_subquery ::= query_expression */
  {  392,   -1 }, /* (534) query_or_subquery ::= subquery */
  {  457,    0 }, /* (535) order_by_clause_opt ::= */
  {  457,   -3 }, /* (536) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  458,    0 }, /* (537) slimit_clause_opt ::= */
  {  458,   -2 }, /* (538) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  458,   -4 }, /* (539) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  458,   -4 }, /* (540) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  459,    0 }, /* (541) limit_clause_opt ::= */
  {  459,   -2 }, /* (542) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  459,   -4 }, /* (543) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  459,   -4 }, /* (544) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  436,   -3 }, /* (545) subquery ::= NK_LP query_expression NK_RP */
  {  436,   -3 }, /* (546) subquery ::= NK_LP subquery NK_RP */
  {  439,   -1 }, /* (547) search_condition ::= common_expression */
  {  462,   -1 }, /* (548) sort_specification_list ::= sort_specification */
  {  462,   -3 }, /* (549) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  463,   -3 }, /* (550) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  464,    0 }, /* (551) ordering_specification_opt ::= */
  {  464,   -1 }, /* (552) ordering_specification_opt ::= ASC */
  {  464,   -1 }, /* (553) ordering_specification_opt ::= DESC */
  {  465,    0 }, /* (554) null_ordering_opt ::= */
  {  465,   -2 }, /* (555) null_ordering_opt ::= NULLS FIRST */
  {  465,   -2 }, /* (556) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy233, &yymsp[-1].minor.yy0, yymsp[0].minor.yy27); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy233, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy233, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy233, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy27 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy27 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy129, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy129, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy129 = yymsp[0].minor.yy129; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy129 = yymsp[-2].minor.yy129 | yymsp[0].minor.yy129; }
  yymsp[-2].minor.yy129 = yylhsminor.yy129;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy233 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy233 = yylhsminor.yy233;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy233 = yymsp[-2].minor.yy233; }
  yymsp[-2].minor.yy233 = yylhsminor.yy233;
        break;
      case 42: /* priv_level ::= topic_name */
      case 273: /* sma_func_name ::= function_name */ yytestcase(yyruleno==273);
      case 473: /* alias_opt ::= table_alias */ yytestcase(yyruleno==473);
{ yylhsminor.yy233 = yymsp[0].minor.yy233; }
  yymsp[0].minor.yy233 = yylhsminor.yy233;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy233, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy397); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy397); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 274: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST */ yytestcase(yyruleno==276);
      case 277: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==277);
      case 358: /* db_name ::= NK_ID */ yytestcase(yyruleno==358);
      case 359: /* table_name ::= NK_ID */ yytestcase(yyruleno==359);
      case 360: /* column_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* function_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* table_alias ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* column_alias ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* user_name ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* topic_name ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* stream_name ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 368: /* index_name ::= NK_ID */ yytestcase(yyruleno==368);
      case 408: /* noarg_func ::= NOW */ yytestcase(yyruleno==408);
      case 409: /* noarg_func ::= TODAY */ yytestcase(yyruleno==409);
      case 410: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==413);
      case 414: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==415);
      case 416: /* noarg_func ::= USER */ yytestcase(yyruleno==416);
      case 417: /* star_func ::= COUNT */ yytestcase(yyruleno==417);
      case 418: /* star_func ::= FIRST */ yytestcase(yyruleno==418);
      case 419: /* star_func ::= LAST */ yytestcase(yyruleno==419);
      case 420: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==420);
{ yylhsminor.yy233 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy233 = yylhsminor.yy233;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 293: /* analyze_opt ::= */ yytestcase(yyruleno==293);
      case 300: /* agg_func_opt ::= */ yytestcase(yyruleno==300);
      case 481: /* set_quantifier_opt ::= */ yytestcase(yyruleno==481);
{ yymsp[1].minor.yy397 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 294: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==301);
      case 482: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==482);
{ yymsp[0].minor.yy397 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy397, &yymsp[-1].minor.yy233, yymsp[0].minor.yy924); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy924); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy832); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy397 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy397 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy924 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_KEEP, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_RETENTIONS, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-3].minor.yy924, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-3].minor.yy924, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy924 = createAlterDatabaseOptions(pCxt); yylhsminor.yy924 = setAlterDatabaseOption(pCxt, yylhsminor.yy924, &yymsp[0].minor.yy257); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy924 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy924, &yymsp[0].minor.yy257); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy257.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy257.type = DB_OPTION_KEEP; yymsp[-1].minor.yy257.pList = yymsp[0].minor.yy776; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_PAGES; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_WAL; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy776 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 328: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==328);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy776 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func */ yytestcase(yyruleno==270);
      case 356: /* literal_list ::= signed_literal */ yytestcase(yyruleno==356);
      case 423: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==423);
      case 429: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==429);
      case 484: /* select_list ::= select_item */ yytestcase(yyruleno==484);
      case 495: /* partition_list ::= partition_item */ yytestcase(yyruleno==495);
      case 548: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==548);
{ yylhsminor.yy776 = createNodeList(pCxt, yymsp[0].minor.yy924); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 257: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==257);
      case 271: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==271);
      case 357: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==357);
      case 424: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==424);
      case 485: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==485);
      case 496: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==496);
      case 549: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==549);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, yymsp[0].minor.yy924); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy924 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 127: /* speed_opt ::= */
      case 302: /* bufsize_opt ::= */ yytestcase(yyruleno==302);
{ yymsp[1].minor.yy832 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 303: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==303);
{ yymsp[-1].minor.yy832 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-5].minor.yy924, yymsp[-3].minor.yy776, yymsp[-1].minor.yy776, yymsp[0].minor.yy924); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy776); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy776); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy924); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 330: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==330);
{ pCxt->pRootNode = yymsp[0].minor.yy924; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy924); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy924 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy924 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy924, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy233); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy924 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy924 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy924, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy233); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy924 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy924 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy924, &yymsp[-2].minor.yy233, yymsp[0].minor.yy924); }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 430: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==430);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-1].minor.yy776, yymsp[0].minor.yy924); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy924 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy397, yymsp[-8].minor.yy924, yymsp[-6].minor.yy924, yymsp[-5].minor.yy776, yymsp[-2].minor.yy776, yymsp[0].minor.yy924); }
  yymsp[-9].minor.yy924 = yylhsminor.yy924;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy924 = createDropTableClause(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy924); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 255: /* tag_list_opt ::= */ yytestcase(yyruleno==255);
      case 306: /* col_list_opt ::= */ yytestcase(yyruleno==306);
      case 308: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==308);
      case 493: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==493);
      case 516: /* group_by_clause_opt ::= */ yytestcase(yyruleno==516);
      case 535: /* order_by_clause_opt ::= */ yytestcase(yyruleno==535);
{ yymsp[1].minor.yy776 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 307: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==307);
{ yymsp[-2].minor.yy776 = yymsp[-1].minor.yy776; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy924 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy233, NULL); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy924 = createRealTableNode(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233, NULL); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy924 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852, NULL); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy924 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy233, yymsp[-2].minor.yy852, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy852 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 309: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==309);
      case 422: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==422);
{ yylhsminor.yy776 = yymsp[0].minor.yy776; }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 310: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==310);
{ yymsp[-3].minor.yy776 = yymsp[-1].minor.yy776; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy924 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-4].minor.yy924, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy776); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-4].minor.yy924, TABLE_OPTION_SMA, yymsp[-1].minor.yy776); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy924 = createAlterTableOptions(pCxt); yylhsminor.yy924 = setTableOption(pCxt, yylhsminor.yy924, yymsp[0].minor.yy257.type, &yymsp[0].minor.yy257.val); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy257.type, &yymsp[0].minor.yy257.val); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy257.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy257.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 386: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==386);
{ yylhsminor.yy776 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy924)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 387: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==387);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, releaseRawExprNode(pCxt, yymsp[0].minor.yy924)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy924 = createFunctionNode(pCxt, &yymsp[0].minor.yy233, NULL); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 259: /* tag_item ::= QTAGS */ yytestcase(yyruleno==259);
{ yylhsminor.yy924 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 207: /* col_name ::= column_name */
      case 260: /* tag_item ::= column_name */ yytestcase(yyruleno==260);
{ yylhsminor.yy924 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy924, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy924, yymsp[-1].minor.yy924, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy924); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy924); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy924); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy924); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy924, yymsp[-1].minor.yy924, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy924, yymsp[-3].minor.yy776); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy924,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 247: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 248: /* db_name_cond_opt ::= */
      case 253: /* from_db_opt ::= */ yytestcase(yyruleno==253);
{ yymsp[1].minor.yy924 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 249: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy924 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 250: /* like_pattern_opt ::= */
      case 318: /* subtable_opt ::= */ yytestcase(yyruleno==318);
      case 432: /* case_when_else_opt ::= */ yytestcase(yyruleno==432);
      case 462: /* from_clause_opt ::= */ yytestcase(yyruleno==462);
      case 491: /* where_clause_opt ::= */ yytestcase(yyruleno==491);
      case 500: /* twindow_clause_opt ::= */ yytestcase(yyruleno==500);
      case 506: /* sliding_opt ::= */ yytestcase(yyruleno==506);
      case 508: /* fill_opt ::= */ yytestcase(yyruleno==508);
      case 520: /* having_clause_opt ::= */ yytestcase(yyruleno==520);
      case 522: /* range_opt ::= */ yytestcase(yyruleno==522);
      case 524: /* every_opt ::= */ yytestcase(yyruleno==524);
      case 537: /* slimit_clause_opt ::= */ yytestcase(yyruleno==537);
      case 541: /* limit_clause_opt ::= */ yytestcase(yyruleno==541);
{ yymsp[1].minor.yy924 = NULL; }
        break;
      case 251: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 252: /* table_name_cond ::= table_name */
{ yylhsminor.yy924 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 254: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy924 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 258: /* tag_item ::= TBNAME */
{ yylhsminor.yy924 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 261: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy924 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy233), &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 262: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy924 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy233), &yymsp[0].minor.yy233); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 263: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy397, yymsp[-3].minor.yy924, yymsp[-1].minor.yy924, NULL, yymsp[0].minor.yy924); }
        break;
      case 264: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy397, yymsp[-5].minor.yy924, yymsp[-3].minor.yy924, yymsp[-1].minor.yy776, NULL); }
        break;
      case 265: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy924); }
        break;
      case 266: /* full_index_name ::= index_name */
{ yylhsminor.yy924 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 267: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy924 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy924 = createIndexOption(pCxt, yymsp[-7].minor.yy776, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), NULL, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 269: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy924 = createIndexOption(pCxt, yymsp[-9].minor.yy776, releaseRawExprNode(pCxt, yymsp[-5].minor.yy924), releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 272: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy924 = createFunctionNode(pCxt, &yymsp[-3].minor.yy233, yymsp[-1].minor.yy776); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 278: /* sma_stream_opt ::= */
      case 311: /* stream_options ::= */ yytestcase(yyruleno==311);
{ yymsp[1].minor.yy924 = createStreamOptions(pCxt); }
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 315: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==315);
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 281: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy233, yymsp[0].minor.yy924); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy233, &yymsp[0].minor.yy233, false); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy233, &yymsp[0].minor.yy233, true); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy233, yymsp[0].minor.yy924, false); }
        break;
      case 286: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy233, yymsp[0].minor.yy924, true); }
        break;
      case 287: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 288: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
        break;
      case 289: /* cmd ::= DESC full_table_name */
      case 290: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==290);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy924); }
        break;
      case 291: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy397, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 295: /* explain_options ::= */
{ yymsp[1].minor.yy924 = createDefaultExplainOptions(pCxt); }
        break;
      case 296: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy924 = setExplainVerbose(pCxt, yymsp[-2].minor.yy924, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 297: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy924 = setExplainRatio(pCxt, yymsp[-2].minor.yy924, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 298: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-8].minor.yy397, &yymsp[-5].minor.yy233, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy852, yymsp[0].minor.yy832); }
        break;
      case 299: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 304: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy397, &yymsp[-8].minor.yy233, yymsp[-5].minor.yy924, yymsp[-7].minor.yy924, yymsp[-3].minor.yy776, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, yymsp[-4].minor.yy776); }
        break;
      case 305: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 312: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 313: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 314: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy924)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy924)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-3].minor.yy924; }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 316: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy924)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy924 = yymsp[-3].minor.yy924; }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 317: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 319: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 507: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==507);
      case 525: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==525);
{ yymsp[-3].minor.yy924 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy924); }
        break;
      case 320: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 321: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 322: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 323: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 324: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 325: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy776); }
        break;
      case 326: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 327: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy776 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 329: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 331: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy924, yymsp[-2].minor.yy776, yymsp[0].minor.yy924); }
        break;
      case 332: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy924, NULL, yymsp[0].minor.yy924); }
        break;
      case 333: /* literal ::= NK_INTEGER */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 334: /* literal ::= NK_FLOAT */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 335: /* literal ::= NK_STRING */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 336: /* literal ::= NK_BOOL */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 337: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 338: /* literal ::= duration_literal */
      case 348: /* signed_literal ::= signed */ yytestcase(yyruleno==348);
      case 369: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==369);
      case 370: /* expression ::= literal */ yytestcase(yyruleno==370);
      case 371: /* expression ::= pseudo_column */ yytestcase(yyruleno==371);
      case 372: /* expression ::= column_reference */ yytestcase(yyruleno==372);
      case 373: /* expression ::= function_expression */ yytestcase(yyruleno==373);
      case 374: /* expression ::= case_when_expression */ yytestcase(yyruleno==374);
      case 405: /* function_expression ::= literal_func */ yytestcase(yyruleno==405);
      case 454: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==454);
      case 458: /* boolean_primary ::= predicate */ yytestcase(yyruleno==458);
      case 460: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==460);
      case 461: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==461);
      case 464: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==464);
      case 466: /* table_reference ::= table_primary */ yytestcase(yyruleno==466);
      case 467: /* table_reference ::= joined_table */ yytestcase(yyruleno==467);
      case 471: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==471);
      case 527: /* query_simple ::= query_specification */ yytestcase(yyruleno==527);
      case 528: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==528);
      case 531: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==531);
      case 533: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==533);
{ yylhsminor.yy924 = yymsp[0].minor.yy924; }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 339: /* literal ::= NULL */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 340: /* literal ::= NK_QUESTION */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 341: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 342: /* signed ::= NK_INTEGER */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 343: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 344: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 345: /* signed ::= NK_FLOAT */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 346: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 347: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 349: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 350: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 351: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 352: /* signed_literal ::= duration_literal */
      case 354: /* signed_literal ::= literal_func */ yytestcase(yyruleno==354);
      case 425: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==425);
      case 487: /* select_item ::= common_expression */ yytestcase(yyruleno==487);
      case 497: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==497);
      case 532: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==532);
      case 534: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==534);
      case 547: /* search_condition ::= common_expression */ yytestcase(yyruleno==547);
{ yylhsminor.yy924 = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 353: /* signed_literal ::= NULL */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 355: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy924 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 375: /* expression ::= NK_LP expression NK_RP */
      case 459: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==459);
      case 546: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==546);
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 376: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy924));
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 377: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy924), NULL));
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 378: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 379: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 380: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 381: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 382: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 383: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 384: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 385: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 388: /* column_reference ::= column_name */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy233, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy233)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 389: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233, createColumnNode(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 390: /* pseudo_column ::= ROWTS */
      case 391: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==391);
      case 393: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==393);
      case 394: /* pseudo_column ::= QEND */ yytestcase(yyruleno==394);
      case 395: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= WEND */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==398);
      case 399: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==400);
      case 401: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==401);
      case 407: /* literal_func ::= NOW */ yytestcase(yyruleno==407);
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 392: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy233)))); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 402: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 403: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==403);
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy233, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy233, yymsp[-1].minor.yy776)); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 404: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-1].minor.yy852)); }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 406: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy233, NULL)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 421: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy776 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 426: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 490: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==490);
{ yylhsminor.yy924 = createColumnNode(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 427: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy776, yymsp[-1].minor.yy924)); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 428: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-2].minor.yy776, yymsp[-1].minor.yy924)); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 431: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy924 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)); }
        break;
      case 433: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy924 = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); }
        break;
      case 434: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 439: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==439);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy856, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 435: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy924), releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 436: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy924), releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 437: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), NULL));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 438: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), NULL));
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 440: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy856 = OP_TYPE_LOWER_THAN; }
        break;
      case 441: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy856 = OP_TYPE_GREATER_THAN; }
        break;
      case 442: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy856 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 443: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy856 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 444: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy856 = OP_TYPE_NOT_EQUAL; }
        break;
      case 445: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy856 = OP_TYPE_EQUAL; }
        break;
      case 446: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy856 = OP_TYPE_LIKE; }
        break;
      case 447: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy856 = OP_TYPE_NOT_LIKE; }
        break;
      case 448: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy856 = OP_TYPE_MATCH; }
        break;
      case 449: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy856 = OP_TYPE_NMATCH; }
        break;
      case 450: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy856 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 451: /* in_op ::= IN */
{ yymsp[0].minor.yy856 = OP_TYPE_IN; }
        break;
      case 452: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy856 = OP_TYPE_NOT_IN; }
        break;
      case 453: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy776)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 455: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy924), NULL));
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 456: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 457: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 463: /* from_clause_opt ::= FROM table_reference_list */
      case 492: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==492);
      case 521: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==521);
{ yymsp[-1].minor.yy924 = yymsp[0].minor.yy924; }
        break;
      case 465: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy924 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, NULL); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 468: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy924 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 469: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy924 = createRealTableNode(pCxt, &yymsp[-3].minor.yy233, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 470: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy924 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924), &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 472: /* alias_opt ::= */
{ yymsp[1].minor.yy233 = nil_token;  }
        break;
      case 474: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy233 = yymsp[0].minor.yy233; }
        break;
      case 475: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 476: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==476);
{ yymsp[-2].minor.yy924 = yymsp[-1].minor.yy924; }
        break;
      case 477: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy924 = createJoinTableNode(pCxt, yymsp[-4].minor.yy428, yymsp[-5].minor.yy924, yymsp[-2].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 478: /* join_type ::= */
{ yymsp[1].minor.yy428 = JOIN_TYPE_INNER; }
        break;
      case 479: /* join_type ::= INNER */
{ yymsp[0].minor.yy428 = JOIN_TYPE_INNER; }
        break;
      case 480: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy924 = createSelectStmt(pCxt, yymsp[-10].minor.yy397, yymsp[-9].minor.yy776, yymsp[-8].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addWhereClause(pCxt, yymsp[-11].minor.yy924, yymsp[-7].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addPartitionByClause(pCxt, yymsp[-11].minor.yy924, yymsp[-6].minor.yy776);
                                                                                    yymsp[-11].minor.yy924 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy924, yymsp[-2].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addGroupByClause(pCxt, yymsp[-11].minor.yy924, yymsp[-1].minor.yy776);
                                                                                    yymsp[-11].minor.yy924 = addHavingClause(pCxt, yymsp[-11].minor.yy924, yymsp[0].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addRangeClause(pCxt, yymsp[-11].minor.yy924, yymsp[-5].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addEveryClause(pCxt, yymsp[-11].minor.yy924, yymsp[-4].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addFillClause(pCxt, yymsp[-11].minor.yy924, yymsp[-3].minor.yy924);
                                                                                  }
        break;
      case 483: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy397 = false; }
        break;
      case 486: /* select_item ::= NK_STAR */
{ yylhsminor.yy924 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 488: /* select_item ::= common_expression column_alias */
      case 498: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==498);
{ yylhsminor.yy924 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924), &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 489: /* select_item ::= common_expression AS column_alias */
      case 499: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==499);
{ yylhsminor.yy924 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), &yymsp[0].minor.yy233); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 494: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 517: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==517);
      case 536: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==536);
{ yymsp[-2].minor.yy776 = yymsp[0].minor.yy776; }
        break;
      case 501: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy924 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
        break;
      case 502: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy924 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
        break;
      case 503: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy924 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), NULL, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 504: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy924 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy924), releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 505: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy924 = createEventWindowNode(pCxt, yymsp[-3].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 509: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy924 = createFillNode(pCxt, yymsp[-1].minor.yy646, NULL); }
        break;
      case 510: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy924 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy776)); }
        break;
      case 511: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy646 = FILL_MODE_NONE; }
        break;
      case 512: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy646 = FILL_MODE_PREV; }
        break;
      case 513: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy646 = FILL_MODE_NULL; }
        break;
      case 514: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy646 = FILL_MODE_LINEAR; }
        break;
      case 515: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy646 = FILL_MODE_NEXT; }
        break;
      case 518: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy776 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 519: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 523: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy924 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
        break;
      case 526: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy924 = addOrderByClause(pCxt, yymsp[-3].minor.yy924, yymsp[-2].minor.yy776);
                                                                                    yylhsminor.yy924 = addSlimitClause(pCxt, yylhsminor.yy924, yymsp[-1].minor.yy924);
                                                                                    yylhsminor.yy924 = addLimitClause(pCxt, yylhsminor.yy924, yymsp[0].minor.yy924);
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 529: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy924 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 530: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy924 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 538: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 542: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==542);
{ yymsp[-1].minor.yy924 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 539: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 543: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==543);
{ yymsp[-3].minor.yy924 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 540: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 544: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==544);
{ yymsp[-3].minor.yy924 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 545: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy924); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 550: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy924 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), yymsp[-1].minor.yy870, yymsp[0].minor.yy89); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 551: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy870 = ORDER_ASC; }
        break;
      case 552: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy870 = ORDER_ASC; }
        break;
      case 553: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy870 = ORDER_DESC; }
        break;
      case 554: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy89 = NULL_ORDER_DEFAULT; }
        break;
      case 555: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy89 = NULL_ORDER_FIRST; }
        break;
      case 556: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy89 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
