/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 427
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy95;
  EOperatorType yy198;
  EOrder yy204;
  int8_t yy215;
  ENullOrder yy277;
  bool yy313;
  int64_t yy473;
  SNodeList* yy544;
  SToken yy617;
  EJoinType yy708;
  SDataType yy784;
  EFillMode yy816;
  SNode* yy840;
  int32_t yy844;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             667
#define YYNRULE              491
#define YYNTOKEN             305
#define YY_MAX_SHIFT         666
#define YY_MIN_SHIFTREDUCE   973
#define YY_MAX_SHIFTREDUCE   1463
#define YY_ERROR_ACTION      1464
#define YY_ACCEPT_ACTION     1465
#define YY_NO_ACTION         1466
#define YY_MIN_REDUCE        1467
#define YY_MAX_REDUCE        1957
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2548)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   526,   30,  261,  526,  549,  433,  526,  434, 1502,   11,
 /*    10 */    10,  117,   39,   37,   55, 1653, 1654,  117,  471,  378,
 /*    20 */   339, 1468, 1264, 1006,  476, 1023, 1290, 1022, 1607, 1791,
 /*    30 */  1598, 1607,  127, 1340, 1607, 1262,  441,  552,  434, 1502,
 /*    40 */   469, 1775,  107, 1779, 1290,  106,  105,  104,  103,  102,
 /*    50 */   101,  100,   99,   98, 1775, 1024, 1335, 1809,  150,   64,
 /*    60 */  1935,   14, 1567, 1010, 1011,  553, 1771, 1777, 1270,  450,
 /*    70 */  1761,  125,  577,  165,   39,   37, 1403, 1932,  571, 1771,
 /*    80 */  1777,  328,  339, 1529, 1264,  551,  161, 1877, 1878,    1,
 /*    90 */  1882,  571, 1659,  479,  478, 1340, 1823, 1262, 1376,  327,
 /*   100 */    95, 1792,  580, 1794, 1795,  576,  496,  571, 1657,  344,
 /*   110 */  1869,  663, 1652, 1654,  330, 1865,  160,  513, 1335,  494,
 /*   120 */  1935,  492, 1289,   14,  325, 1342, 1343, 1705,  164,  543,
 /*   130 */  1270, 1161, 1162, 1934,   33,   32, 1895, 1932,   40,   38,
 /*   140 */    36,   35,   34,  148,   63, 1479,  640,  639,  638,  637,
 /*   150 */   349,    2,  636,  635,  128,  630,  629,  628,  627,  626,
 /*   160 */   625,  624,  139,  620,  619,  618,  348,  347,  615,  614,
 /*   170 */  1265,  107, 1263,  663,  106,  105,  104,  103,  102,  101,
 /*   180 */   100,   99,   98, 1809,   36,   35,   34, 1342, 1343,  224,
 /*   190 */   225,  542,  384, 1268, 1269,  613, 1317, 1318, 1320, 1321,
 /*   200 */  1322, 1323, 1324, 1325,  573,  569, 1333, 1334, 1336, 1337,
 /*   210 */  1338, 1339, 1341, 1344, 1467, 1288, 1434,   33,   32,  482,
 /*   220 */   481,   40,   38,   36,   35,   34,  123,  168,  541,  303,
 /*   230 */  1465,  223, 1265,   84, 1263, 1264,  477,  480,  116,  115,
 /*   240 */   114,  113,  112,  111,  110,  109,  108,  305, 1262, 1023,
 /*   250 */   516, 1022,   22,  174, 1600, 1268, 1269, 1490, 1317, 1318,
 /*   260 */  1320, 1321, 1322, 1323, 1324, 1325,  573,  569, 1333, 1334,
 /*   270 */  1336, 1337, 1338, 1339, 1341, 1344,   39,   37, 1489, 1024,
 /*   280 */   538, 1270,  168,  526,  339,   71, 1264, 1488,   70,  354,
 /*   290 */  1244, 1245, 1708, 1791,  170,  211,  512, 1340, 1761, 1262,
 /*   300 */  1119,  602,  601,  600, 1123,  599, 1125, 1126,  598, 1128,
 /*   310 */   595, 1607, 1134,  592, 1136, 1137,  589,  586, 1935, 1761,
 /*   320 */  1335, 1809, 1584, 1270,  663,   14, 1659, 1935, 1761,  553,
 /*   330 */  1935,  166, 1270,  343, 1761, 1932,  577, 1935,   39,   37,
 /*   340 */  1933,  487, 1657,  165, 1932,  552,  339, 1932, 1264,  549,
 /*   350 */   165,   76,  305,    2, 1932,  516,  497,  544,  539, 1340,
 /*   360 */  1823, 1262, 1698,  159,   95, 1792,  580, 1794, 1795,  576,
 /*   370 */   210,  571,   63,  173, 1869,  663, 1646,  127,  330, 1865,
 /*   380 */   160,  552, 1335, 1265,  490, 1263,  419,  605,  484, 1342,
 /*   390 */  1343,   33,   32,  209, 1270,   40,   38,   36,   35,   34,
 /*   400 */  1896,  634,  632,   39,   37, 1345, 1268, 1269, 1487,   91,
 /*   410 */   622,  339, 1791, 1264,   42,    8,  125,   40,   38,   36,
 /*   420 */    35,   34,  124,  611, 1340,   58, 1262, 1596,   57,   49,
 /*   430 */  1599,  162, 1877, 1878, 1265, 1882, 1263,  663,  178,  177,
 /*   440 */  1809,  352,  137,  136,  608,  607,  606, 1335,  575, 1761,
 /*   450 */    43, 1342, 1343, 1761,  316,  577, 1486, 1268, 1269, 1270,
 /*   460 */  1317, 1318, 1320, 1321, 1322, 1323, 1324, 1325,  573,  569,
 /*   470 */  1333, 1334, 1336, 1337, 1338, 1339, 1341, 1344,   63, 1823,
 /*   480 */     9,   74, 1935,  294, 1792,  580, 1794, 1795,  576,  574,
 /*   490 */   571,  568, 1841, 1289,  122,  165, 1265, 1761, 1263, 1932,
 /*   500 */    33,   32,  663, 1602,   40,   38,   36,   35,   34,  317,
 /*   510 */   168,  315,  314, 1485,  473,  351, 1342, 1343,  475, 1268,
 /*   520 */  1269, 1291, 1317, 1318, 1320, 1321, 1322, 1323, 1324, 1325,
 /*   530 */   573,  569, 1333, 1334, 1336, 1337, 1338, 1339, 1341, 1344,
 /*   540 */   474, 1010, 1011,   33,   32, 1460, 1364,   40,   38,   36,
 /*   550 */    35,   34,  168,  168, 1761,  526, 1935, 1592,  377,  146,
 /*   560 */   376, 1265,   63, 1263,   26, 1532,  382,  168, 1610,  165,
 /*   570 */    33,   32,  217, 1932,   40,   38,   36,   35,   34,  218,
 /*   580 */  1484, 1791, 1414, 1607, 1268, 1269, 1594, 1317, 1318, 1320,
 /*   590 */  1321, 1322, 1323, 1324, 1325,  573,  569, 1333, 1334, 1336,
 /*   600 */  1337, 1338, 1339, 1341, 1344,   39,   37,   77,   27, 1809,
 /*   610 */   498, 1884,   63,  339,   78, 1264,  168,  578, 1369, 1483,
 /*   620 */   505, 1761, 1761,  373,  577, 1302, 1340,   28, 1262,  482,
 /*   630 */   481, 1482, 1459,   33,   32, 1881,  123,   40,   38,   36,
 /*   640 */    35,   34,  375,  371,  438, 1590,  477,  480, 1823, 1335,
 /*   650 */  1287, 1935,   96, 1792,  580, 1794, 1795,  576,  253,  571,
 /*   660 */  1761, 1270, 1869,  513,  165, 1481, 1868, 1865, 1932, 1081,
 /*   670 */    33,   32, 1761, 1706,   40,   38,   36,   35,   34,  666,
 /*   680 */    33,   32,    9,  526,   40,   38,   36,   35,   34, 1478,
 /*   690 */  1477,   33,   32,  268,  383,   40,   38,   36,   35,   34,
 /*   700 */   168, 1704, 1083,  300,  663,  432, 1761,  157,  436, 1698,
 /*   710 */   214, 1607,  656,  652,  648,  644,  266, 1582, 1342, 1343,
 /*   720 */   176,   33,   32,  307,  572,   40,   38,   36,   35,   34,
 /*   730 */  1761, 1761,   39,   37,  526,  604,  526,  302, 1476, 1287,
 /*   740 */   339,  549, 1264,  526,  307,  389,  412,  404,   92,  424,
 /*   750 */   168,  231, 1302, 1340,  405, 1262,  440, 1585,   74,  436,
 /*   760 */  1362, 1407, 1607, 1265, 1607, 1263,  397, 1289,  425,  127,
 /*   770 */   399, 1607, 1475, 1703, 1779,  300, 1335, 1889, 1396, 1761,
 /*   780 */  1603, 1362,   44,    4,  523, 1775, 1268, 1269, 1270, 1317,
 /*   790 */  1318, 1320, 1321, 1322, 1323, 1324, 1325,  573,  569, 1333,
 /*   800 */  1334, 1336, 1337, 1338, 1339, 1341, 1344,  390,  125,    2,
 /*   810 */  1771, 1777,  334, 1761, 1363,    7,  220,  450,  611,  386,
 /*   820 */    90,  526,  571,  163, 1877, 1878, 1659, 1882, 1424,  145,
 /*   830 */    87,  663,  448,  312, 1236, 1363,  213,  137,  136,  608,
 /*   840 */   607,  606, 1657, 1480, 1884, 1342, 1343,  423, 1474, 1607,
 /*   850 */   418,  417,  416,  415,  414,  411,  410,  409,  408,  407,
 /*   860 */   403,  402,  401,  400,  394,  393,  392,  391, 1880,  388,
 /*   870 */   387,  535, 1422, 1423, 1425, 1426,   29,  337, 1357, 1358,
 /*   880 */  1359, 1360, 1361, 1365, 1366, 1367, 1368, 1350,   61, 1761,
 /*   890 */  1265,  609, 1263, 1289, 1650, 1935, 1400,   29,  337, 1357,
 /*   900 */  1358, 1359, 1360, 1361, 1365, 1366, 1367, 1368,  166, 1583,
 /*   910 */  1791, 1473, 1932, 1268, 1269, 1472, 1317, 1318, 1320, 1321,
 /*   920 */  1322, 1323, 1324, 1325,  573,  569, 1333, 1334, 1336, 1337,
 /*   930 */  1338, 1339, 1341, 1344,  623,  147, 1579, 1791, 1809,  526,
 /*   940 */   279,  611,  610,  256, 1319, 1650,  578, 1884, 1471, 1470,
 /*   950 */   449, 1761, 1761,  577,  277,   60, 1761,  475,   59, 1292,
 /*   960 */   137,  136,  608,  607,  606, 1809,  554, 1607, 1289,  613,
 /*   970 */  1568, 1879,  135,  578,  181,  429,  427, 1823, 1761,  474,
 /*   980 */   577,   94, 1792,  580, 1794, 1795,  576,  536,  571, 1761,
 /*   990 */  1761, 1869, 1780,  554,  468,  306, 1865,  273,   53,  509,
 /*  1000 */  1637, 1659, 1396, 1775, 1823,  526,   63, 1935,   94, 1792,
 /*  1010 */   580, 1794, 1795,  576,  526,  571, 1604, 1658, 1869,   54,
 /*  1020 */   167, 1748,  306, 1865, 1932, 1736, 1519,  202, 1771, 1777,
 /*  1030 */   200,  336,  335, 1607, 1935, 1462, 1463,  558,  526,  526,
 /*  1040 */   571, 1278, 1607, 1273,   93,  526,  526,  165,  483,  506,
 /*  1050 */   510, 1932, 1340,  561, 1271,  326,  228,  522,  526,  204,
 /*  1060 */   526, 1791,  203,  146,  499,  526, 1607, 1607,  361,  524,
 /*  1070 */  1319,  525, 1609, 1607, 1607, 1335,  262,   41,  222,   68,
 /*  1080 */    67,  381,  342,  526,  172, 1272, 1607, 1270, 1607, 1809,
 /*  1090 */   146,  131,  245, 1607,  346,  206,  233,  578,  205, 1609,
 /*  1100 */   301,  567, 1761,  369,  577,  367,  363,  359,  356,  353,
 /*  1110 */   345, 1607, 1782,  208,  134,  135,  207, 1810,  146, 1514,
 /*  1120 */  1399, 1512,   51, 1791, 1213,  226,  237, 1609, 1823,  556,
 /*  1130 */   566,   51,   95, 1792,  580, 1794, 1795,  576,  519,  571,
 /*  1140 */    41,  485, 1869,  488,  168, 1319,  330, 1865, 1948,   11,
 /*  1150 */    10, 1809,  616,   41,  617, 1784,  350, 1903,  584,  578,
 /*  1160 */   134,  230, 1112, 1503, 1761, 1647,  577,  135,  119, 1421,
 /*  1170 */   134, 1899,  550,  240, 1069, 1791, 1067,  255, 1370,  250,
 /*  1180 */  1276,  258,  260,    3,    5,  355,  313, 1326, 1050, 1279,
 /*  1190 */  1823, 1274,  360, 1229,   95, 1792,  580, 1794, 1795,  576,
 /*  1200 */   272,  571,  269, 1809, 1869, 1140, 1508, 1144,  330, 1865,
 /*  1210 */  1948,  578, 1282, 1284, 1151, 1149, 1761,  138,  577, 1926,
 /*  1220 */   175, 1051, 1275, 1287,  569, 1333, 1334, 1336, 1337, 1338,
 /*  1230 */  1339, 1791,  385, 1354,  406, 1700,  413,  421,  420, 1293,
 /*  1240 */   559, 1791, 1823,  422,  426,  431,   95, 1792,  580, 1794,
 /*  1250 */  1795,  576,  428,  571,  658,  439, 1869,  430,  562, 1809,
 /*  1260 */   330, 1865, 1948, 1295,  442,  443,  184,  578, 1294, 1809,
 /*  1270 */   186, 1888, 1761, 1296,  577,  444,  445,  578,  189,  447,
 /*  1280 */   191,   72, 1761,   73,  577,  451,  470,  554,  195,  472,
 /*  1290 */  1791,  304, 1597,  199,  118, 1593, 1741,  554, 1823,  501,
 /*  1300 */   201,  140,  286, 1792,  580, 1794, 1795,  576, 1823,  571,
 /*  1310 */   141, 1595,  286, 1792,  580, 1794, 1795,  576, 1809,  571,
 /*  1320 */  1591,  142,  143,  212,  270,  500,  578,  215, 1935,  507,
 /*  1330 */   504, 1761,  511,  577,  322,  219,  534,  514, 1935,  132,
 /*  1340 */  1740,  167, 1710,  520,  517, 1932,  133,  324,   81,  521,
 /*  1350 */  1791,  165, 1292,  530,  271, 1932,   83, 1823, 1608,  235,
 /*  1360 */  1791,   96, 1792,  580, 1794, 1795,  576, 1900,  571,  537,
 /*  1370 */   239, 1869,  532, 1910,    6,  565, 1865,  533, 1809,  546,
 /*  1380 */   329, 1909,  540,  531,  529,  244,  578, 1891, 1809,  528,
 /*  1390 */  1396, 1761, 1291,  577,  154,  126,  578,  249,  563,  560,
 /*  1400 */   246, 1761,   48,  577, 1885,  247,  331,  248,   85, 1791,
 /*  1410 */   582, 1651, 1580,  265,  274,  659,  660, 1823, 1931,  662,
 /*  1420 */    52,  149, 1792,  580, 1794, 1795,  576, 1823,  571, 1951,
 /*  1430 */   153,   96, 1792,  580, 1794, 1795,  576, 1809,  571,  557,
 /*  1440 */  1755, 1869,  323,  287,  297,  578, 1866, 1850,  296,  254,
 /*  1450 */  1761,  276,  577,  564, 1754,  278,  257,  259,   65, 1753,
 /*  1460 */  1791, 1752,   66, 1749,  357,  555, 1949,  358, 1256, 1257,
 /*  1470 */   171,  362, 1747,  364,  365,  366, 1823, 1746, 1745,  368,
 /*  1480 */   295, 1792,  580, 1794, 1795,  576,  370,  571, 1809, 1744,
 /*  1490 */   372, 1743,  374,  527, 1232, 1231,  578, 1721, 1720,  379,
 /*  1500 */   380, 1761, 1201,  577, 1719, 1718, 1693,  129, 1692, 1691,
 /*  1510 */  1690,   69, 1791, 1689, 1688, 1687, 1686, 1685,  395,  396,
 /*  1520 */  1684,  398, 1791,  130, 1669, 1668, 1667, 1823, 1683, 1682,
 /*  1530 */  1681,  295, 1792,  580, 1794, 1795,  576, 1680,  571, 1791,
 /*  1540 */  1809, 1679, 1678, 1677, 1676, 1675, 1674, 1673,  578, 1672,
 /*  1550 */  1809, 1671, 1670, 1761, 1666,  577, 1665, 1664,  578, 1663,
 /*  1560 */  1203, 1662, 1661, 1761, 1660,  577, 1534, 1809,  179, 1533,
 /*  1570 */  1531, 1499,  120,  182,  180,  575, 1498,  158,  435, 1823,
 /*  1580 */  1761, 1013,  577,  290, 1792,  580, 1794, 1795,  576, 1823,
 /*  1590 */   571,  190, 1012,  149, 1792,  580, 1794, 1795,  576, 1791,
 /*  1600 */   571,  437, 1734,  183,  121, 1728, 1823, 1717, 1716, 1702,
 /*  1610 */   294, 1792,  580, 1794, 1795,  576, 1791,  571,  188, 1842,
 /*  1620 */  1586,  545, 1043, 1530, 1528,  452,  454, 1809, 1526,  453,
 /*  1630 */   456,  457,  338,  458, 1524,  578,  460,  462, 1950,  461,
 /*  1640 */  1761, 1522,  577,  465, 1809,  464, 1511, 1510, 1495,  340,
 /*  1650 */   466, 1588,  578, 1155, 1154, 1587,   50, 1761,  631,  577,
 /*  1660 */  1080, 1077,  633, 1520,  198, 1076, 1823, 1075, 1515, 1513,
 /*  1670 */   295, 1792,  580, 1794, 1795,  576,  318,  571,  319,  320,
 /*  1680 */   486, 1494, 1493, 1823, 1791,  489,  197,  295, 1792,  580,
 /*  1690 */  1794, 1795,  576,  491,  571, 1492,  493,  495,   97, 1733,
 /*  1700 */   152, 1238, 1791, 1727,  216,  467,  463,  459,  455,  196,
 /*  1710 */    56,  502, 1809,  144, 1715, 1713, 1714, 1712, 1711,  221,
 /*  1720 */   578, 1248,   15, 1709,  227, 1761,   79,  577, 1701,  503,
 /*  1730 */  1809,  321,  508,   80,  232,  518,   41,   87,  578,  229,
 /*  1740 */    47,   75,   16, 1761,  194,  577,  243,  242,   82,   25,
 /*  1750 */    17, 1823, 1436,   23,  234,  280, 1792,  580, 1794, 1795,
 /*  1760 */   576, 1791,  571,  236, 1418,  515,  238, 1782,  151, 1823,
 /*  1770 */  1420,  252,  241,  281, 1792,  580, 1794, 1795,  576,   24,
 /*  1780 */   571, 1413, 1393,   46, 1781,   86,   18,  155, 1392, 1809,
 /*  1790 */  1448, 1453, 1442, 1447,  332, 1452, 1451,  578,  333,   10,
 /*  1800 */    45, 1280, 1761, 1330,  577, 1355,  193,  187,   13,  192,
 /*  1810 */  1791,   19, 1328,  446, 1327,  156, 1826,  169,  570,   31,
 /*  1820 */    12,   20, 1310,   21,  583, 1141,  341, 1138, 1823,  185,
 /*  1830 */   587, 1791,  282, 1792,  580, 1794, 1795,  576, 1809,  571,
 /*  1840 */   585,  588,  581, 1135,  579,  590,  578, 1129,  593,  596,
 /*  1850 */  1118, 1761, 1127,  577,  591,  594,  597, 1133, 1132, 1809,
 /*  1860 */  1131, 1130,   88,   89,  263,  603, 1150,  578, 1146,   62,
 /*  1870 */  1041, 1072, 1761,  612,  577, 1071, 1070, 1823, 1068, 1066,
 /*  1880 */  1065,  289, 1792,  580, 1794, 1795,  576, 1064,  571, 1791,
 /*  1890 */  1087,  621,  264, 1062, 1061, 1060, 1059, 1058, 1823, 1791,
 /*  1900 */  1057, 1056,  291, 1792,  580, 1794, 1795,  576, 1047,  571,
 /*  1910 */  1084, 1082, 1053, 1052, 1049, 1048, 1046, 1809, 1527,  641,
 /*  1920 */  1525,  642,  643,  645,  647,  578, 1523, 1809,  649,  646,
 /*  1930 */  1761,  651,  577, 1521,  650,  578,  653,  655,  654, 1509,
 /*  1940 */  1761,  657,  577, 1491, 1003,  267,  661, 1466, 1466, 1266,
 /*  1950 */   275, 1791,  664, 1466,  665, 1466, 1823, 1466, 1466, 1466,
 /*  1960 */   283, 1792,  580, 1794, 1795,  576, 1823,  571, 1791, 1466,
 /*  1970 */   292, 1792,  580, 1794, 1795,  576, 1466,  571, 1466, 1809,
 /*  1980 */  1466, 1466, 1466, 1466, 1466, 1466, 1466,  578, 1466, 1466,
 /*  1990 */  1466, 1466, 1761, 1466,  577, 1466, 1809, 1466, 1466, 1466,
 /*  2000 */  1466, 1466, 1466, 1466,  578, 1466, 1466, 1466, 1466, 1761,
 /*  2010 */  1466,  577, 1466, 1466, 1466, 1466, 1466, 1791, 1823, 1466,
 /*  2020 */  1466, 1466,  284, 1792,  580, 1794, 1795,  576, 1466,  571,
 /*  2030 */  1466, 1466, 1466, 1466, 1791, 1823, 1466, 1466, 1466,  293,
 /*  2040 */  1792,  580, 1794, 1795,  576, 1809,  571, 1466, 1466, 1466,
 /*  2050 */  1466, 1466, 1466,  578, 1466, 1466, 1466, 1466, 1761, 1466,
 /*  2060 */   577, 1466, 1809, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
 /*  2070 */   578, 1466, 1466, 1466, 1466, 1761, 1466,  577, 1466, 1466,
 /*  2080 */  1466, 1466, 1466, 1791, 1823, 1466, 1466, 1466,  285, 1792,
 /*  2090 */   580, 1794, 1795,  576, 1466,  571, 1466, 1466, 1466, 1466,
 /*  2100 */  1466, 1823, 1466, 1466, 1466,  298, 1792,  580, 1794, 1795,
 /*  2110 */   576, 1809,  571, 1466, 1466, 1466, 1466, 1466, 1466,  578,
 /*  2120 */  1466, 1466, 1466, 1466, 1761, 1466,  577, 1466, 1466, 1466,
 /*  2130 */  1466, 1466, 1466, 1466, 1466, 1466, 1466, 1791, 1466, 1466,
 /*  2140 */  1466, 1466, 1466, 1466, 1466, 1466, 1466, 1791, 1466, 1466,
 /*  2150 */  1823, 1466, 1466, 1466,  299, 1792,  580, 1794, 1795,  576,
 /*  2160 */  1466,  571, 1466, 1466, 1466, 1809, 1466, 1466, 1466, 1466,
 /*  2170 */  1466, 1466, 1466,  578, 1466, 1809, 1466, 1466, 1761, 1466,
 /*  2180 */   577, 1466, 1466,  578, 1466, 1466, 1466, 1466, 1761, 1466,
 /*  2190 */   577, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1791, 1466,
 /*  2200 */  1466, 1466, 1466, 1466, 1823, 1466, 1466, 1466, 1803, 1792,
 /*  2210 */   580, 1794, 1795,  576, 1823,  571, 1791, 1466, 1802, 1792,
 /*  2220 */   580, 1794, 1795,  576, 1466,  571, 1809, 1466, 1466, 1466,
 /*  2230 */  1466, 1466, 1466, 1466,  578, 1466, 1466, 1466, 1466, 1761,
 /*  2240 */  1466,  577, 1466, 1466, 1809, 1466, 1466, 1466, 1466, 1466,
 /*  2250 */  1466, 1466,  578, 1466, 1466, 1466, 1466, 1761, 1466,  577,
 /*  2260 */  1466, 1466, 1466, 1466, 1466, 1823, 1466, 1466, 1466, 1801,
 /*  2270 */  1792,  580, 1794, 1795,  576, 1791,  571, 1466, 1466, 1466,
 /*  2280 */  1466, 1466, 1466, 1823, 1466, 1466, 1466,  310, 1792,  580,
 /*  2290 */  1794, 1795,  576, 1466,  571, 1466, 1791, 1466, 1466, 1466,
 /*  2300 */  1466, 1466, 1466, 1809, 1466, 1466, 1466, 1466, 1466, 1466,
 /*  2310 */  1466,  578, 1466, 1466, 1466, 1466, 1761, 1466,  577, 1466,
 /*  2320 */  1466, 1466, 1466, 1466, 1809, 1466, 1466, 1466, 1466, 1466,
 /*  2330 */  1466, 1466,  578, 1466, 1466, 1466, 1466, 1761, 1466,  577,
 /*  2340 */  1466, 1466, 1823, 1466, 1466, 1466,  309, 1792,  580, 1794,
 /*  2350 */  1795,  576, 1791,  571, 1466, 1466, 1466, 1466, 1466, 1466,
 /*  2360 */  1466, 1466, 1791, 1823, 1466, 1466, 1466,  311, 1792,  580,
 /*  2370 */  1794, 1795,  576, 1466,  571, 1466, 1466, 1466, 1466, 1466,
 /*  2380 */  1809, 1466, 1466, 1466, 1466, 1466, 1466, 1466,  578, 1466,
 /*  2390 */  1809, 1466, 1466, 1761,  549,  577, 1466, 1466,  578, 1466,
 /*  2400 */  1466, 1466, 1466, 1761, 1466,  577, 1466, 1466, 1466, 1466,
 /*  2410 */  1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1823,
 /*  2420 */  1466, 1466,  127,  308, 1792,  580, 1794, 1795,  576, 1823,
 /*  2430 */   571, 1466, 1466,  288, 1792,  580, 1794, 1795,  576, 1466,
 /*  2440 */   571,  549,  554, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
 /*  2450 */  1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
 /*  2460 */  1466,  125, 1466, 1466, 1466, 1466, 1466, 1466, 1466,  127,
 /*  2470 */  1466, 1466, 1466, 1466, 1466, 1466,  251, 1877,  548, 1466,
 /*  2480 */   547, 1466, 1466, 1935, 1466, 1466, 1466, 1466, 1466,  554,
 /*  2490 */  1466, 1466, 1466, 1466, 1466, 1466,  167, 1466, 1466, 1466,
 /*  2500 */  1932, 1466, 1466, 1466, 1466, 1466, 1466, 1466,  125, 1466,
 /*  2510 */  1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
 /*  2520 */  1466, 1466, 1466,  251, 1877,  548, 1466,  547, 1466, 1466,
 /*  2530 */  1935, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466, 1466,
 /*  2540 */  1466, 1466, 1466,  165, 1466, 1466, 1466, 1932,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   316,  390,  391,  316,  316,  312,  316,  314,  315,    1,
 /*    10 */     2,  327,   12,   13,  327,  350,  351,  327,  334,  364,
 /*    20 */    20,    0,   22,    4,  334,   20,   20,   22,  344,  308,
 /*    30 */   338,  344,  344,   33,  344,   35,  312,   20,  314,  315,
 /*    40 */    35,  349,   21,  338,   20,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  349,   50,   56,  336,  321,    4,
 /*    60 */   405,   61,  325,   44,   45,  344,  374,  375,   68,   60,
 /*    70 */   349,  383,  351,  418,   12,   13,   14,  422,  386,  374,
 /*    80 */   375,  376,   20,    0,   22,  397,  398,  399,  400,   89,
 /*    90 */   402,  386,  336,  322,  323,   33,  375,   35,   90,  343,
 /*   100 */   379,  380,  381,  382,  383,  384,   21,  386,  352,  347,
 /*   110 */   389,  111,  350,  351,  393,  394,  395,  351,   56,   34,
 /*   120 */   405,   36,   20,   61,  358,  125,  126,  361,  407,   20,
 /*   130 */    68,  125,  126,  418,    8,    9,  415,  422,   12,   13,
 /*   140 */    14,   15,   16,  307,   89,  309,   63,   64,   65,   66,
 /*   150 */    67,   89,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   160 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   170 */   170,   21,  172,  111,   24,   25,   26,   27,   28,   29,
 /*   180 */    30,   31,   32,  336,   14,   15,   16,  125,  126,  120,
 /*   190 */   121,  344,  316,  193,  194,   60,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,    0,   20,   90,    8,    9,   64,
 /*   220 */    65,   12,   13,   14,   15,   16,   71,  227,  381,  353,
 /*   230 */   305,  120,  170,  318,  172,   22,   81,   82,   24,   25,
 /*   240 */    26,   27,   28,   29,   30,   31,   32,  178,   35,   20,
 /*   250 */   181,   22,   43,   56,  339,  193,  194,  308,  196,  197,
 /*   260 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   270 */   208,  209,  210,  211,  212,  213,   12,   13,  308,   50,
 /*   280 */   155,   68,  227,  316,   20,   88,   22,  308,   91,  364,
 /*   290 */   179,  180,    0,  308,  327,  121,  364,   33,  349,   35,
 /*   300 */   102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
 /*   310 */   112,  344,  114,  115,  116,  117,  118,  119,  405,  349,
 /*   320 */    56,  336,    0,   68,  111,   61,  336,  405,  349,  344,
 /*   330 */   405,  418,   68,  343,  349,  422,  351,  405,   12,   13,
 /*   340 */   418,    4,  352,  418,  422,   20,   20,  422,   22,  316,
 /*   350 */   418,  177,  178,   89,  422,  181,   19,  232,  233,   33,
 /*   360 */   375,   35,  344,  335,  379,  380,  381,  382,  383,  384,
 /*   370 */    33,  386,   89,  355,  389,  111,  348,  344,  393,  394,
 /*   380 */   395,   20,   56,  170,   47,  172,   77,  100,   51,  125,
 /*   390 */   126,    8,    9,   56,   68,   12,   13,   14,   15,   16,
 /*   400 */   415,  322,  323,   12,   13,   14,  193,  194,  308,  318,
 /*   410 */    68,   20,  308,   22,   89,   89,  383,   12,   13,   14,
 /*   420 */    15,   16,  331,  101,   33,   88,   35,  337,   91,   89,
 /*   430 */   339,  398,  399,  400,  170,  402,  172,  111,  129,  130,
 /*   440 */   336,  364,  120,  121,  122,  123,  124,   56,  344,  349,
 /*   450 */    89,  125,  126,  349,   37,  351,  308,  193,  194,   68,
 /*   460 */   196,  197,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,   89,  375,
 /*   480 */    89,  320,  405,  379,  380,  381,  382,  383,  384,  385,
 /*   490 */   386,  387,  388,   20,  333,  418,  170,  349,  172,  422,
 /*   500 */     8,    9,  111,  342,   12,   13,   14,   15,   16,   92,
 /*   510 */   227,   94,   95,  308,   97,  364,  125,  126,  101,  193,
 /*   520 */   194,   20,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   530 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   540 */   123,   44,   45,    8,    9,  162,  152,   12,   13,   14,
 /*   550 */    15,   16,  227,  227,  349,  316,  405,  337,  169,  336,
 /*   560 */   171,  170,   89,  172,    2,    0,  327,  227,  345,  418,
 /*   570 */     8,    9,   56,  422,   12,   13,   14,   15,   16,   56,
 /*   580 */   308,  308,   90,  344,  193,  194,  337,  196,  197,  198,
 /*   590 */   199,  200,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   600 */   209,  210,  211,  212,  213,   12,   13,   91,  214,  336,
 /*   610 */   364,  377,   89,   20,   91,   22,  227,  344,  224,  308,
 /*   620 */   368,  349,  349,  165,  351,   90,   33,    2,   35,   64,
 /*   630 */    65,  308,  249,    8,    9,  401,   71,   12,   13,   14,
 /*   640 */    15,   16,  184,  185,   14,  337,   81,   82,  375,   56,
 /*   650 */    20,  405,  379,  380,  381,  382,  383,  384,  157,  386,
 /*   660 */   349,   68,  389,  351,  418,  308,  393,  394,  422,   35,
 /*   670 */     8,    9,  349,  361,   12,   13,   14,   15,   16,   19,
 /*   680 */     8,    9,   89,  316,   12,   13,   14,   15,   16,  308,
 /*   690 */   308,    8,    9,   33,  327,   12,   13,   14,   15,   16,
 /*   700 */   227,  360,   68,  362,  111,  313,  349,   47,  316,  344,
 /*   710 */   337,  344,   52,   53,   54,   55,   56,    0,  125,  126,
 /*   720 */   355,    8,    9,   61,  337,   12,   13,   14,   15,   16,
 /*   730 */   349,  349,   12,   13,  316,  337,  316,   18,  308,   20,
 /*   740 */    20,  316,   22,  316,   61,  327,   27,  327,   88,   30,
 /*   750 */   227,   91,   90,   33,  327,   35,  313,    0,  320,  316,
 /*   760 */    98,   14,  344,  170,  344,  172,   47,   20,   49,  344,
 /*   770 */    51,  344,  308,  360,  338,  362,   56,  225,  226,  349,
 /*   780 */   342,   98,   42,   43,  124,  349,  193,  194,   68,  196,
 /*   790 */   197,  198,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,   88,  383,   89,
 /*   810 */   374,  375,  376,  349,  152,   39,  156,   60,  101,  100,
 /*   820 */    89,  316,  386,  398,  399,  400,  336,  402,  193,  157,
 /*   830 */    99,  111,  327,  343,  174,  152,  176,  120,  121,  122,
 /*   840 */   123,  124,  352,  309,  377,  125,  126,  128,  308,  344,
 /*   850 */   131,  132,  133,  134,  135,  136,  137,  138,  139,  140,
 /*   860 */   141,  142,  143,  144,  145,  146,  147,  148,  401,  150,
 /*   870 */   151,  236,  237,  238,  239,  240,  214,  215,  216,  217,
 /*   880 */   218,  219,  220,  221,  222,  223,  224,   14,    3,  349,
 /*   890 */   170,  346,  172,   20,  349,  405,    4,  214,  215,  216,
 /*   900 */   217,  218,  219,  220,  221,  222,  223,  224,  418,    0,
 /*   910 */   308,  308,  422,  193,  194,  308,  196,  197,  198,  199,
 /*   920 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   930 */   210,  211,  212,  213,  324,   18,  326,  308,  336,  316,
 /*   940 */    23,  101,  346,  425,  197,  349,  344,  377,  308,  308,
 /*   950 */   327,  349,  349,  351,   37,   38,  349,  101,   41,   20,
 /*   960 */   120,  121,  122,  123,  124,  336,  364,  344,   20,   60,
 /*   970 */   325,  401,   43,  344,   57,   58,   59,  375,  349,  123,
 /*   980 */   351,  379,  380,  381,  382,  383,  384,  416,  386,  349,
 /*   990 */   349,  389,  338,  364,  317,  393,  394,  329,  157,  158,
 /*  1000 */   332,  336,  226,  349,  375,  316,   89,  405,  379,  380,
 /*  1010 */   381,  382,  383,  384,  316,  386,  327,  352,  389,   90,
 /*  1020 */   418,    0,  393,  394,  422,  327,    0,   93,  374,  375,
 /*  1030 */    96,   12,   13,  344,  405,  125,  126,   43,  316,  316,
 /*  1040 */   386,   22,  344,   35,  127,  316,  316,  418,   22,  327,
 /*  1050 */   327,  422,   33,   43,   35,  328,  327,  327,  316,   93,
 /*  1060 */   316,  308,   96,  336,  371,  316,  344,  344,   47,  327,
 /*  1070 */   197,  327,  345,  344,  344,   56,  327,   43,   43,  162,
 /*  1080 */   163,  164,  328,  316,  167,   35,  344,   68,  344,  336,
 /*  1090 */   336,   43,  412,  344,  327,   93,  157,  344,   96,  345,
 /*  1100 */   183,   61,  349,  186,  351,  188,  189,  190,  191,  192,
 /*  1110 */   328,  344,   46,   93,   43,   43,   96,  336,  336,    0,
 /*  1120 */   228,    0,   43,  308,   90,   90,   43,  345,  375,  244,
 /*  1130 */   111,   43,  379,  380,  381,  382,  383,  384,   90,  386,
 /*  1140 */    43,   22,  389,   22,  227,  197,  393,  394,  395,    1,
 /*  1150 */     2,  336,   13,   43,   13,   89,  317,  404,   43,  344,
 /*  1160 */    43,   90,   90,  315,  349,  348,  351,   43,   43,   90,
 /*  1170 */    43,  378,  403,   90,   35,  308,   35,  419,   90,  396,
 /*  1180 */   172,  419,  419,  406,  229,  373,  372,   90,   35,  170,
 /*  1190 */   375,  172,   47,  168,  379,  380,  381,  382,  383,  384,
 /*  1200 */    90,  386,  366,  336,  389,   90,    0,   90,  393,  394,
 /*  1210 */   395,  344,  193,  194,   90,   90,  349,   90,  351,  404,
 /*  1220 */    42,   68,  172,   20,  205,  206,  207,  208,  209,  210,
 /*  1230 */   211,  308,  356,  193,  316,  316,  356,  152,  354,   20,
 /*  1240 */   246,  308,  375,  354,  316,  310,  379,  380,  381,  382,
 /*  1250 */   383,  384,  316,  386,   48,  310,  389,  316,  248,  336,
 /*  1260 */   393,  394,  395,   20,  370,  351,  320,  344,   20,  336,
 /*  1270 */   320,  404,  349,   20,  351,  363,  365,  344,  320,  363,
 /*  1280 */   320,  320,  349,  320,  351,  316,  310,  364,  320,  336,
 /*  1290 */   308,  310,  336,  336,  316,  336,  349,  364,  375,  369,
 /*  1300 */   336,  336,  379,  380,  381,  382,  383,  384,  375,  386,
 /*  1310 */   336,  336,  379,  380,  381,  382,  383,  384,  336,  386,
 /*  1320 */   336,  336,  336,  318,  370,  175,  344,  318,  405,  316,
 /*  1330 */   351,  349,  316,  351,  363,  318,  234,  349,  405,  359,
 /*  1340 */   349,  418,  349,  154,  349,  422,  359,  349,  318,  357,
 /*  1350 */   308,  418,   20,  349,  332,  422,  318,  375,  344,  359,
 /*  1360 */   308,  379,  380,  381,  382,  383,  384,  378,  386,  235,
 /*  1370 */   359,  389,  349,  411,  241,  393,  394,  349,  336,  161,
 /*  1380 */   349,  411,  349,  243,  242,  413,  344,  414,  336,  230,
 /*  1390 */   226,  349,   20,  351,  411,  344,  344,  373,  247,  245,
 /*  1400 */   410,  349,   89,  351,  377,  409,  250,  408,   89,  308,
 /*  1410 */   340,  349,  326,  318,  316,   36,  311,  375,  421,  310,
 /*  1420 */   367,  379,  380,  381,  382,  383,  384,  375,  386,  426,
 /*  1430 */   362,  379,  380,  381,  382,  383,  384,  336,  386,  421,
 /*  1440 */     0,  389,  341,  330,  330,  344,  394,  392,  330,  420,
 /*  1450 */   349,  319,  351,  421,    0,  306,  420,  420,  177,    0,
 /*  1460 */   308,    0,   42,    0,   35,  423,  424,  187,   35,   35,
 /*  1470 */    35,  187,    0,   35,   35,  187,  375,    0,    0,  187,
 /*  1480 */   379,  380,  381,  382,  383,  384,   35,  386,  336,    0,
 /*  1490 */    22,    0,   35,  341,  172,  170,  344,    0,    0,  166,
 /*  1500 */   165,  349,   46,  351,    0,    0,    0,   42,    0,    0,
 /*  1510 */     0,  149,  308,    0,    0,    0,    0,    0,  144,   35,
 /*  1520 */     0,  144,  308,   42,    0,    0,    0,  375,    0,    0,
 /*  1530 */     0,  379,  380,  381,  382,  383,  384,    0,  386,  308,
 /*  1540 */   336,    0,    0,    0,    0,    0,    0,    0,  344,    0,
 /*  1550 */   336,    0,    0,  349,    0,  351,    0,    0,  344,    0,
 /*  1560 */    22,    0,    0,  349,    0,  351,    0,  336,   56,    0,
 /*  1570 */     0,    0,   39,   42,   56,  344,    0,   43,   46,  375,
 /*  1580 */   349,   14,  351,  379,  380,  381,  382,  383,  384,  375,
 /*  1590 */   386,  161,   14,  379,  380,  381,  382,  383,  384,  308,
 /*  1600 */   386,   46,    0,   40,   39,    0,  375,    0,    0,    0,
 /*  1610 */   379,  380,  381,  382,  383,  384,  308,  386,   39,  388,
 /*  1620 */     0,  417,   62,    0,    0,   35,   39,  336,    0,   47,
 /*  1630 */    35,   47,  341,   39,    0,  344,   35,   39,  424,   47,
 /*  1640 */   349,    0,  351,   47,  336,   35,    0,    0,    0,  341,
 /*  1650 */    39,    0,  344,   35,   22,    0,   98,  349,   43,  351,
 /*  1660 */    35,   35,   43,    0,   96,   35,  375,   22,    0,    0,
 /*  1670 */   379,  380,  381,  382,  383,  384,   22,  386,   22,   22,
 /*  1680 */    49,    0,    0,  375,  308,   35,   33,  379,  380,  381,
 /*  1690 */   382,  383,  384,   35,  386,    0,   35,   22,   20,    0,
 /*  1700 */    47,   35,  308,    0,  154,   52,   53,   54,   55,   56,
 /*  1710 */   157,   22,  336,  173,    0,    0,    0,    0,    0,   90,
 /*  1720 */   344,   35,   89,    0,   89,  349,   89,  351,    0,  157,
 /*  1730 */   336,  157,  159,   39,   46,  155,   43,   99,  344,  153,
 /*  1740 */    43,   88,  231,  349,   91,  351,   46,   43,   89,   43,
 /*  1750 */   231,  375,   90,   89,   89,  379,  380,  381,  382,  383,
 /*  1760 */   384,  308,  386,   90,   90,  182,   89,   46,   89,  375,
 /*  1770 */    90,   46,   89,  379,  380,  381,  382,  383,  384,   89,
 /*  1780 */   386,   90,   90,   43,   46,   89,   43,   46,   90,  336,
 /*  1790 */    35,   90,   90,   35,   35,   35,   35,  344,   35,    2,
 /*  1800 */   225,   22,  349,   90,  351,  193,  153,  154,  231,  156,
 /*  1810 */   308,   43,   90,  160,   90,   46,   89,   46,   89,   89,
 /*  1820 */    89,   89,   22,   89,   35,   90,   35,   90,  375,  176,
 /*  1830 */    35,  308,  379,  380,  381,  382,  383,  384,  336,  386,
 /*  1840 */    89,   89,  100,   90,  195,   35,  344,   90,   35,   35,
 /*  1850 */    22,  349,   90,  351,   89,   89,   89,  113,  113,  336,
 /*  1860 */   113,  113,   89,   89,   43,  101,   35,  344,   22,   89,
 /*  1870 */    62,   35,  349,   61,  351,   35,   35,  375,   35,   35,
 /*  1880 */    35,  379,  380,  381,  382,  383,  384,   35,  386,  308,
 /*  1890 */    68,   87,   43,   35,   35,   22,   35,   22,  375,  308,
 /*  1900 */    35,   35,  379,  380,  381,  382,  383,  384,   22,  386,
 /*  1910 */    68,   35,   35,   35,   35,   35,   35,  336,    0,   35,
 /*  1920 */     0,   47,   39,   35,   39,  344,    0,  336,   35,   47,
 /*  1930 */   349,   39,  351,    0,   47,  344,   35,   39,   47,    0,
 /*  1940 */   349,   35,  351,    0,   35,   22,   21,  427,  427,   22,
 /*  1950 */    22,  308,   21,  427,   20,  427,  375,  427,  427,  427,
 /*  1960 */   379,  380,  381,  382,  383,  384,  375,  386,  308,  427,
 /*  1970 */   379,  380,  381,  382,  383,  384,  427,  386,  427,  336,
 /*  1980 */   427,  427,  427,  427,  427,  427,  427,  344,  427,  427,
 /*  1990 */   427,  427,  349,  427,  351,  427,  336,  427,  427,  427,
 /*  2000 */   427,  427,  427,  427,  344,  427,  427,  427,  427,  349,
 /*  2010 */   427,  351,  427,  427,  427,  427,  427,  308,  375,  427,
 /*  2020 */   427,  427,  379,  380,  381,  382,  383,  384,  427,  386,
 /*  2030 */   427,  427,  427,  427,  308,  375,  427,  427,  427,  379,
 /*  2040 */   380,  381,  382,  383,  384,  336,  386,  427,  427,  427,
 /*  2050 */   427,  427,  427,  344,  427,  427,  427,  427,  349,  427,
 /*  2060 */   351,  427,  336,  427,  427,  427,  427,  427,  427,  427,
 /*  2070 */   344,  427,  427,  427,  427,  349,  427,  351,  427,  427,
 /*  2080 */   427,  427,  427,  308,  375,  427,  427,  427,  379,  380,
 /*  2090 */   381,  382,  383,  384,  427,  386,  427,  427,  427,  427,
 /*  2100 */   427,  375,  427,  427,  427,  379,  380,  381,  382,  383,
 /*  2110 */   384,  336,  386,  427,  427,  427,  427,  427,  427,  344,
 /*  2120 */   427,  427,  427,  427,  349,  427,  351,  427,  427,  427,
 /*  2130 */   427,  427,  427,  427,  427,  427,  427,  308,  427,  427,
 /*  2140 */   427,  427,  427,  427,  427,  427,  427,  308,  427,  427,
 /*  2150 */   375,  427,  427,  427,  379,  380,  381,  382,  383,  384,
 /*  2160 */   427,  386,  427,  427,  427,  336,  427,  427,  427,  427,
 /*  2170 */   427,  427,  427,  344,  427,  336,  427,  427,  349,  427,
 /*  2180 */   351,  427,  427,  344,  427,  427,  427,  427,  349,  427,
 /*  2190 */   351,  427,  427,  427,  427,  427,  427,  427,  308,  427,
 /*  2200 */   427,  427,  427,  427,  375,  427,  427,  427,  379,  380,
 /*  2210 */   381,  382,  383,  384,  375,  386,  308,  427,  379,  380,
 /*  2220 */   381,  382,  383,  384,  427,  386,  336,  427,  427,  427,
 /*  2230 */   427,  427,  427,  427,  344,  427,  427,  427,  427,  349,
 /*  2240 */   427,  351,  427,  427,  336,  427,  427,  427,  427,  427,
 /*  2250 */   427,  427,  344,  427,  427,  427,  427,  349,  427,  351,
 /*  2260 */   427,  427,  427,  427,  427,  375,  427,  427,  427,  379,
 /*  2270 */   380,  381,  382,  383,  384,  308,  386,  427,  427,  427,
 /*  2280 */   427,  427,  427,  375,  427,  427,  427,  379,  380,  381,
 /*  2290 */   382,  383,  384,  427,  386,  427,  308,  427,  427,  427,
 /*  2300 */   427,  427,  427,  336,  427,  427,  427,  427,  427,  427,
 /*  2310 */   427,  344,  427,  427,  427,  427,  349,  427,  351,  427,
 /*  2320 */   427,  427,  427,  427,  336,  427,  427,  427,  427,  427,
 /*  2330 */   427,  427,  344,  427,  427,  427,  427,  349,  427,  351,
 /*  2340 */   427,  427,  375,  427,  427,  427,  379,  380,  381,  382,
 /*  2350 */   383,  384,  308,  386,  427,  427,  427,  427,  427,  427,
 /*  2360 */   427,  427,  308,  375,  427,  427,  427,  379,  380,  381,
 /*  2370 */   382,  383,  384,  427,  386,  427,  427,  427,  427,  427,
 /*  2380 */   336,  427,  427,  427,  427,  427,  427,  427,  344,  427,
 /*  2390 */   336,  427,  427,  349,  316,  351,  427,  427,  344,  427,
 /*  2400 */   427,  427,  427,  349,  427,  351,  427,  427,  427,  427,
 /*  2410 */   427,  427,  427,  427,  427,  427,  427,  427,  427,  375,
 /*  2420 */   427,  427,  344,  379,  380,  381,  382,  383,  384,  375,
 /*  2430 */   386,  427,  427,  379,  380,  381,  382,  383,  384,  427,
 /*  2440 */   386,  316,  364,  427,  427,  427,  427,  427,  427,  427,
 /*  2450 */   427,  427,  427,  427,  427,  427,  427,  427,  427,  427,
 /*  2460 */   427,  383,  427,  427,  427,  427,  427,  427,  427,  344,
 /*  2470 */   427,  427,  427,  427,  427,  427,  398,  399,  400,  427,
 /*  2480 */   402,  427,  427,  405,  427,  427,  427,  427,  427,  364,
 /*  2490 */   427,  427,  427,  427,  427,  427,  418,  427,  427,  427,
 /*  2500 */   422,  427,  427,  427,  427,  427,  427,  427,  383,  427,
 /*  2510 */   427,  427,  427,  427,  427,  427,  427,  427,  427,  427,
 /*  2520 */   427,  427,  427,  398,  399,  400,  427,  402,  427,  427,
 /*  2530 */   405,  427,  427,  427,  427,  427,  427,  427,  427,  427,
 /*  2540 */   427,  427,  427,  418,  427,  427,  427,  422,
};
#define YY_SHIFT_COUNT    (666)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1943)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   917,    0,    0,   62,   62,  264,  264,  264,  326,  326,
 /*    10 */   264,  264,  391,  593,  720,  593,  593,  593,  593,  593,
 /*    20 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    30 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    40 */   593,  593,  325,  325,  361,  361,  361, 1019, 1019,  473,
 /*    50 */  1019, 1019,  389,  523,  283,  340,  283,   17,   17,   19,
 /*    60 */    19,   55,    6,  283,  283,   17,   17,   17,   17,   17,
 /*    70 */    17,   17,   17,   17,   17,    9,   17,   17,   17,   24,
 /*    80 */    17,   17,  102,   17,   17,  102,  109,   17,  102,  102,
 /*    90 */   102,   17,  135,  719,  662,  683,  683,  150,  213,  213,
 /*   100 */   213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
 /*   110 */   213,  213,  213,  213,  213,  213,  213,  417,  155,    6,
 /*   120 */   630,  630,  757,  634,  909,  501,  501,  501,  634,  195,
 /*   130 */   195,   24,  292,  292,  102,  102,  255,  255,  287,  342,
 /*   140 */   198,  198,  198,  198,  198,  198,  198,  660,   21,  383,
 /*   150 */   565,  635,    5,  174,  125,  747,  873,  229,  497,  856,
 /*   160 */   939,  552,  776,  552,  740,  885,  885,  885,  892,  948,
 /*   170 */   955, 1145, 1025, 1178, 1203, 1203, 1178, 1085, 1085, 1203,
 /*   180 */  1203, 1203, 1219, 1219, 1243,    9,   24,    9, 1248, 1253,
 /*   190 */     9, 1248,    9,    9,    9, 1203,    9, 1219,  102,  102,
 /*   200 */   102,  102,  102,  102,  102,  102,  102,  102,  102, 1203,
 /*   210 */  1219,  255, 1243,  135, 1150,   24,  135, 1203, 1203, 1248,
 /*   220 */   135, 1102,  255,  255,  255,  255, 1102,  255, 1189,  135,
 /*   230 */   287,  135,  195, 1332,  255, 1134, 1102,  255,  255, 1134,
 /*   240 */  1102,  255,  255,  102, 1133, 1218, 1134, 1140, 1142, 1159,
 /*   250 */   955, 1164,  195, 1372, 1151, 1154, 1156, 1151, 1154, 1151,
 /*   260 */  1154, 1313, 1319,  255,  342, 1203,  135, 1379, 1219, 2548,
 /*   270 */  2548, 2548, 2548, 2548, 2548, 2548,   83, 1653,  214,  337,
 /*   280 */   126,  209,  492,  562,  625,  672,  535,  322,  713,  713,
 /*   290 */   713,  713,  713,  713,  713,  713,  717,  840,  405,  405,
 /*   300 */    69,  458,  197,  309,   85,  111,    8,  394,  170,  170,
 /*   310 */   170,  170,  929, 1021,  934,  966, 1002, 1020, 1026, 1119,
 /*   320 */  1121,  516,  841, 1034, 1035, 1048, 1071, 1072, 1079, 1083,
 /*   330 */  1148,  910,  994, 1010, 1088, 1008, 1050, 1040, 1097, 1066,
 /*   340 */  1110, 1115, 1117, 1124, 1125, 1127,  731, 1139, 1141, 1153,
 /*   350 */  1206, 1440, 1454, 1281, 1459, 1461, 1420, 1463, 1429, 1280,
 /*   360 */  1433, 1434, 1435, 1284, 1472, 1438, 1439, 1288, 1477, 1292,
 /*   370 */  1478, 1451, 1489, 1468, 1491, 1457, 1322, 1325, 1497, 1498,
 /*   380 */  1333, 1335, 1504, 1505, 1456, 1506, 1465, 1508, 1509, 1510,
 /*   390 */  1362, 1513, 1514, 1515, 1516, 1517, 1374, 1484, 1520, 1377,
 /*   400 */  1528, 1529, 1530, 1537, 1541, 1542, 1543, 1544, 1545, 1546,
 /*   410 */  1547, 1549, 1551, 1552, 1481, 1524, 1525, 1526, 1554, 1556,
 /*   420 */  1557, 1538, 1559, 1561, 1562, 1564, 1566, 1512, 1569, 1518,
 /*   430 */  1570, 1571, 1531, 1533, 1534, 1567, 1532, 1578, 1555, 1576,
 /*   440 */  1563, 1565, 1602, 1605, 1607, 1579, 1430, 1608, 1609, 1620,
 /*   450 */  1560, 1623, 1624, 1590, 1582, 1587, 1628, 1595, 1584, 1594,
 /*   460 */  1634, 1601, 1592, 1598, 1641, 1610, 1596, 1611, 1646, 1647,
 /*   470 */  1648, 1651, 1558, 1568, 1618, 1632, 1655, 1625, 1615, 1619,
 /*   480 */  1626, 1630, 1645, 1663, 1654, 1668, 1656, 1631, 1669, 1657,
 /*   490 */  1650, 1681, 1658, 1682, 1661, 1695, 1675, 1678, 1699, 1553,
 /*   500 */  1666, 1703, 1540, 1689, 1572, 1550, 1714, 1715, 1574, 1573,
 /*   510 */  1716, 1717, 1718, 1633, 1629, 1686, 1583, 1723, 1635, 1580,
 /*   520 */  1637, 1728, 1694, 1586, 1659, 1638, 1688, 1693, 1511, 1664,
 /*   530 */  1662, 1665, 1673, 1674, 1677, 1697, 1680, 1679, 1683, 1690,
 /*   540 */  1691, 1704, 1700, 1721, 1696, 1706, 1519, 1692, 1698, 1725,
 /*   550 */  1575, 1740, 1738, 1741, 1701, 1743, 1577, 1702, 1755, 1758,
 /*   560 */  1759, 1760, 1761, 1763, 1702, 1797, 1779, 1612, 1768, 1727,
 /*   570 */  1713, 1729, 1722, 1730, 1724, 1769, 1731, 1732, 1771, 1800,
 /*   580 */  1649, 1734, 1742, 1735, 1789, 1791, 1751, 1737, 1795, 1752,
 /*   590 */  1753, 1810, 1765, 1757, 1813, 1766, 1762, 1814, 1767, 1744,
 /*   600 */  1745, 1747, 1748, 1828, 1764, 1773, 1774, 1831, 1780, 1821,
 /*   610 */  1821, 1846, 1808, 1812, 1836, 1840, 1841, 1843, 1844, 1845,
 /*   620 */  1852, 1822, 1804, 1849, 1858, 1859, 1873, 1861, 1875, 1865,
 /*   630 */  1866, 1842, 1615, 1876, 1619, 1877, 1878, 1879, 1880, 1886,
 /*   640 */  1881, 1918, 1884, 1874, 1883, 1920, 1888, 1882, 1885, 1926,
 /*   650 */  1893, 1887, 1892, 1933, 1901, 1891, 1898, 1939, 1906, 1909,
 /*   660 */  1943, 1923, 1925, 1927, 1928, 1931, 1934,
};
#define YY_REDUCE_COUNT (275)
#define YY_REDUCE_MIN   (-389)
#define YY_REDUCE_MAX   (2125)
static const short yy_reduce_ofst[] = {
 /*     0 */   -75,  602,  629, -279,  -15,  753,  815,  867,  923,  933,
 /*    10 */   273,  982,  104, 1042, 1052, 1101, 1152, 1204, 1214, 1231,
 /*    20 */  1291, 1308, 1376, 1394, 1453, 1502, 1523, 1581, 1591, 1643,
 /*    30 */  1660, 1709, 1726, 1775, 1829, 1839, 1890, 1908, 1967, 1988,
 /*    40 */  2044, 2054, 2078, 2125, -312,   33,  425, -295,  436,  490,
 /*    50 */  -308,  654, -345,  -68,   77,  151,  246, -316, -310, -307,
 /*    60 */  -276, -285, -238,  -87,  -78, -313,  -33,  239,  367,  418,
 /*    70 */   420,  427,  505,  623,  689,  161,  698,  722,  723, -234,
 /*    80 */   729,  730,  727,  742,  744, -244, -153,  749,  754,  -10,
 /*    90 */   782,  767,   91, -124, -389, -389, -389, -164,  -51,  -30,
 /*   100 */   -21,  100,  148,  205,  272,  311,  323,  357,  381,  382,
 /*   110 */   430,  464,  540,  603,  607,  640,  641,   28, -263, -335,
 /*   120 */   392,  443,  438, -229,  -85,  234,  467,  570,   79,   18,
 /*   130 */   365,  312,  341,  413,  223,  665,  545,  596,  668,  610,
 /*   140 */    90,  220,  249,  308,  373,  387,  398,  252,  534,  518,
 /*   150 */   645,  571,  677,  693,  680,  781,  781,  839,  848,  817,
 /*   160 */   793,  769,  769,  769,  783,  758,  762,  763,  777,  781,
 /*   170 */   812,  814,  836,  876,  918,  919,  880,  884,  889,  928,
 /*   180 */   936,  941,  935,  945,  894,  946,  914,  950,  912,  911,
 /*   190 */   958,  916,  960,  961,  963,  969,  968,  976,  953,  956,
 /*   200 */   957,  959,  964,  965,  974,  975,  984,  985,  986,  978,
 /*   210 */   981,  947,  954, 1005,  930,  979, 1009, 1013, 1016,  971,
 /*   220 */  1017,  980,  988,  991,  993,  995,  987,  998,  992, 1030,
 /*   230 */  1022, 1038, 1014,  989, 1004,  962, 1000, 1023, 1028,  970,
 /*   240 */  1011, 1031, 1033,  781,  973,  972,  983,  990,  996,  999,
 /*   250 */  1024,  769, 1051, 1027,  997, 1029, 1003, 1018, 1036, 1032,
 /*   260 */  1037, 1055, 1070, 1062, 1086, 1098, 1095, 1105, 1109, 1053,
 /*   270 */  1068, 1113, 1114, 1118, 1132, 1149,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    10 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    20 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    30 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    40 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    50 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    60 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    70 */  1464, 1464, 1464, 1464, 1464, 1538, 1464, 1464, 1464, 1464,
 /*    80 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*    90 */  1464, 1464, 1536, 1694, 1464, 1871, 1464, 1464, 1464, 1464,
 /*   100 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   110 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   120 */  1464, 1464, 1538, 1464, 1536, 1883, 1883, 1883, 1464, 1464,
 /*   130 */  1464, 1464, 1737, 1737, 1464, 1464, 1464, 1464, 1636, 1464,
 /*   140 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1729, 1464, 1952,
 /*   150 */  1464, 1464, 1464, 1735, 1906, 1464, 1464, 1464, 1464, 1589,
 /*   160 */  1898, 1875, 1889, 1876, 1873, 1937, 1937, 1937, 1892, 1464,
 /*   170 */  1902, 1464, 1722, 1699, 1464, 1464, 1699, 1696, 1696, 1464,
 /*   180 */  1464, 1464, 1464, 1464, 1464, 1538, 1464, 1538, 1464, 1464,
 /*   190 */  1538, 1464, 1538, 1538, 1538, 1464, 1538, 1464, 1464, 1464,
 /*   200 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   210 */  1464, 1464, 1464, 1536, 1731, 1464, 1536, 1464, 1464, 1464,
 /*   220 */  1536, 1911, 1464, 1464, 1464, 1464, 1911, 1464, 1464, 1536,
 /*   230 */  1464, 1536, 1464, 1464, 1464, 1913, 1911, 1464, 1464, 1913,
 /*   240 */  1911, 1464, 1464, 1464, 1925, 1921, 1913, 1929, 1927, 1904,
 /*   250 */  1902, 1889, 1464, 1464, 1943, 1939, 1955, 1943, 1939, 1943,
 /*   260 */  1939, 1464, 1605, 1464, 1464, 1464, 1536, 1496, 1464, 1724,
 /*   270 */  1737, 1639, 1639, 1639, 1539, 1469, 1464, 1464, 1464, 1464,
 /*   280 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1808, 1924,
 /*   290 */  1923, 1847, 1846, 1845, 1843, 1807, 1464, 1601, 1806, 1805,
 /*   300 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1799, 1800,
 /*   310 */  1798, 1797, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   320 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   330 */  1872, 1464, 1940, 1944, 1464, 1464, 1464, 1464, 1464, 1783,
 /*   340 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   350 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   360 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   370 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   380 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   390 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   400 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   410 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   420 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   430 */  1464, 1464, 1464, 1464, 1501, 1464, 1464, 1464, 1464, 1464,
 /*   440 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   450 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   460 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   470 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1573, 1572,
 /*   480 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   490 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   500 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   510 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1741, 1464, 1464,
 /*   520 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1905, 1464, 1464,
 /*   530 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   540 */  1464, 1464, 1464, 1783, 1464, 1922, 1464, 1882, 1878, 1464,
 /*   550 */  1464, 1874, 1782, 1464, 1464, 1938, 1464, 1464, 1464, 1464,
 /*   560 */  1464, 1464, 1464, 1464, 1464, 1867, 1464, 1464, 1840, 1825,
 /*   570 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   580 */  1793, 1464, 1464, 1464, 1464, 1464, 1633, 1464, 1464, 1464,
 /*   590 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1618,
 /*   600 */  1616, 1615, 1614, 1464, 1611, 1464, 1464, 1464, 1464, 1642,
 /*   610 */  1641, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   620 */  1464, 1464, 1464, 1557, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   630 */  1464, 1464, 1549, 1464, 1548, 1464, 1464, 1464, 1464, 1464,
 /*   640 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   650 */  1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
 /*   660 */  1464, 1464, 1464, 1464, 1464, 1464, 1464,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  251,  /*      AFTER => ABORT */
  251,  /*     ATTACH => ABORT */
  251,  /*     BEFORE => ABORT */
  251,  /*      BEGIN => ABORT */
  251,  /*     BITAND => ABORT */
  251,  /*     BITNOT => ABORT */
  251,  /*      BITOR => ABORT */
  251,  /*     BLOCKS => ABORT */
  251,  /*     CHANGE => ABORT */
  251,  /*      COMMA => ABORT */
  251,  /*    COMPACT => ABORT */
  251,  /*     CONCAT => ABORT */
  251,  /*   CONFLICT => ABORT */
  251,  /*       COPY => ABORT */
  251,  /*   DEFERRED => ABORT */
  251,  /* DELIMITERS => ABORT */
  251,  /*     DETACH => ABORT */
  251,  /*     DIVIDE => ABORT */
  251,  /*        DOT => ABORT */
  251,  /*       EACH => ABORT */
  251,  /*        END => ABORT */
  251,  /*       FAIL => ABORT */
  251,  /*       FILE => ABORT */
  251,  /*        FOR => ABORT */
  251,  /*       GLOB => ABORT */
  251,  /*         ID => ABORT */
  251,  /*  IMMEDIATE => ABORT */
  251,  /*     IMPORT => ABORT */
  251,  /*  INITIALLY => ABORT */
  251,  /*    INSTEAD => ABORT */
  251,  /*     ISNULL => ABORT */
  251,  /*        KEY => ABORT */
  251,  /*  NK_BITNOT => ABORT */
  251,  /*    NK_SEMI => ABORT */
  251,  /*    NOTNULL => ABORT */
  251,  /*         OF => ABORT */
  251,  /*       PLUS => ABORT */
  251,  /*  PRIVILEGE => ABORT */
  251,  /*      RAISE => ABORT */
  251,  /*    REPLACE => ABORT */
  251,  /*   RESTRICT => ABORT */
  251,  /*        ROW => ABORT */
  251,  /*       SEMI => ABORT */
  251,  /*       STAR => ABORT */
  251,  /*  STATEMENT => ABORT */
  251,  /*     STRING => ABORT */
  251,  /*      TIMES => ABORT */
  251,  /*     UPDATE => ABORT */
  251,  /*     VALUES => ABORT */
  251,  /*   VARIABLE => ABORT */
  251,  /*       VIEW => ABORT */
  251,  /*     VNODES => ABORT */
  251,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "PRECISION",
  /*   75 */ "REPLICA",
  /*   76 */ "STRICT",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "WAL_LEVEL",
  /*   82 */ "WAL_FSYNC_PERIOD",
  /*   83 */ "WAL_RETENTION_PERIOD",
  /*   84 */ "WAL_RETENTION_SIZE",
  /*   85 */ "WAL_ROLL_PERIOD",
  /*   86 */ "WAL_SEGMENT_SIZE",
  /*   87 */ "NK_COLON",
  /*   88 */ "TABLE",
  /*   89 */ "NK_LP",
  /*   90 */ "NK_RP",
  /*   91 */ "STABLE",
  /*   92 */ "ADD",
  /*   93 */ "COLUMN",
  /*   94 */ "MODIFY",
  /*   95 */ "RENAME",
  /*   96 */ "TAG",
  /*   97 */ "SET",
  /*   98 */ "NK_EQ",
  /*   99 */ "USING",
  /*  100 */ "TAGS",
  /*  101 */ "COMMENT",
  /*  102 */ "BOOL",
  /*  103 */ "TINYINT",
  /*  104 */ "SMALLINT",
  /*  105 */ "INT",
  /*  106 */ "INTEGER",
  /*  107 */ "BIGINT",
  /*  108 */ "FLOAT",
  /*  109 */ "DOUBLE",
  /*  110 */ "BINARY",
  /*  111 */ "TIMESTAMP",
  /*  112 */ "NCHAR",
  /*  113 */ "UNSIGNED",
  /*  114 */ "JSON",
  /*  115 */ "VARCHAR",
  /*  116 */ "MEDIUMBLOB",
  /*  117 */ "BLOB",
  /*  118 */ "VARBINARY",
  /*  119 */ "DECIMAL",
  /*  120 */ "MAX_DELAY",
  /*  121 */ "WATERMARK",
  /*  122 */ "ROLLUP",
  /*  123 */ "TTL",
  /*  124 */ "SMA",
  /*  125 */ "FIRST",
  /*  126 */ "LAST",
  /*  127 */ "SHOW",
  /*  128 */ "DATABASES",
  /*  129 */ "TABLES",
  /*  130 */ "STABLES",
  /*  131 */ "MNODES",
  /*  132 */ "MODULES",
  /*  133 */ "QNODES",
  /*  134 */ "FUNCTIONS",
  /*  135 */ "INDEXES",
  /*  136 */ "ACCOUNTS",
  /*  137 */ "APPS",
  /*  138 */ "CONNECTIONS",
  /*  139 */ "LICENCES",
  /*  140 */ "GRANTS",
  /*  141 */ "QUERIES",
  /*  142 */ "SCORES",
  /*  143 */ "TOPICS",
  /*  144 */ "VARIABLES",
  /*  145 */ "BNODES",
  /*  146 */ "SNODES",
  /*  147 */ "CLUSTER",
  /*  148 */ "TRANSACTIONS",
  /*  149 */ "DISTRIBUTED",
  /*  150 */ "CONSUMERS",
  /*  151 */ "SUBSCRIPTIONS",
  /*  152 */ "LIKE",
  /*  153 */ "INDEX",
  /*  154 */ "FUNCTION",
  /*  155 */ "INTERVAL",
  /*  156 */ "TOPIC",
  /*  157 */ "AS",
  /*  158 */ "WITH",
  /*  159 */ "META",
  /*  160 */ "CONSUMER",
  /*  161 */ "GROUP",
  /*  162 */ "DESC",
  /*  163 */ "DESCRIBE",
  /*  164 */ "RESET",
  /*  165 */ "QUERY",
  /*  166 */ "CACHE",
  /*  167 */ "EXPLAIN",
  /*  168 */ "ANALYZE",
  /*  169 */ "VERBOSE",
  /*  170 */ "NK_BOOL",
  /*  171 */ "RATIO",
  /*  172 */ "NK_FLOAT",
  /*  173 */ "OUTPUTTYPE",
  /*  174 */ "AGGREGATE",
  /*  175 */ "BUFSIZE",
  /*  176 */ "STREAM",
  /*  177 */ "INTO",
  /*  178 */ "TRIGGER",
  /*  179 */ "AT_ONCE",
  /*  180 */ "WINDOW_CLOSE",
  /*  181 */ "IGNORE",
  /*  182 */ "EXPIRED",
  /*  183 */ "KILL",
  /*  184 */ "CONNECTION",
  /*  185 */ "TRANSACTION",
  /*  186 */ "BALANCE",
  /*  187 */ "VGROUP",
  /*  188 */ "MERGE",
  /*  189 */ "REDISTRIBUTE",
  /*  190 */ "SPLIT",
  /*  191 */ "DELETE",
  /*  192 */ "INSERT",
  /*  193 */ "NULL",
  /*  194 */ "NK_QUESTION",
  /*  195 */ "NK_ARROW",
  /*  196 */ "ROWTS",
  /*  197 */ "TBNAME",
  /*  198 */ "QSTART",
  /*  199 */ "QEND",
  /*  200 */ "QDURATION",
  /*  201 */ "WSTART",
  /*  202 */ "WEND",
  /*  203 */ "WDURATION",
  /*  204 */ "CAST",
  /*  205 */ "NOW",
  /*  206 */ "TODAY",
  /*  207 */ "TIMEZONE",
  /*  208 */ "CLIENT_VERSION",
  /*  209 */ "SERVER_VERSION",
  /*  210 */ "SERVER_STATUS",
  /*  211 */ "CURRENT_USER",
  /*  212 */ "COUNT",
  /*  213 */ "LAST_ROW",
  /*  214 */ "BETWEEN",
  /*  215 */ "IS",
  /*  216 */ "NK_LT",
  /*  217 */ "NK_GT",
  /*  218 */ "NK_LE",
  /*  219 */ "NK_GE",
  /*  220 */ "NK_NE",
  /*  221 */ "MATCH",
  /*  222 */ "NMATCH",
  /*  223 */ "CONTAINS",
  /*  224 */ "IN",
  /*  225 */ "JOIN",
  /*  226 */ "INNER",
  /*  227 */ "SELECT",
  /*  228 */ "DISTINCT",
  /*  229 */ "WHERE",
  /*  230 */ "PARTITION",
  /*  231 */ "BY",
  /*  232 */ "SESSION",
  /*  233 */ "STATE_WINDOW",
  /*  234 */ "SLIDING",
  /*  235 */ "FILL",
  /*  236 */ "VALUE",
  /*  237 */ "NONE",
  /*  238 */ "PREV",
  /*  239 */ "LINEAR",
  /*  240 */ "NEXT",
  /*  241 */ "HAVING",
  /*  242 */ "RANGE",
  /*  243 */ "EVERY",
  /*  244 */ "ORDER",
  /*  245 */ "SLIMIT",
  /*  246 */ "SOFFSET",
  /*  247 */ "LIMIT",
  /*  248 */ "OFFSET",
  /*  249 */ "ASC",
  /*  250 */ "NULLS",
  /*  251 */ "ABORT",
  /*  252 */ "AFTER",
  /*  253 */ "ATTACH",
  /*  254 */ "BEFORE",
  /*  255 */ "BEGIN",
  /*  256 */ "BITAND",
  /*  257 */ "BITNOT",
  /*  258 */ "BITOR",
  /*  259 */ "BLOCKS",
  /*  260 */ "CHANGE",
  /*  261 */ "COMMA",
  /*  262 */ "COMPACT",
  /*  263 */ "CONCAT",
  /*  264 */ "CONFLICT",
  /*  265 */ "COPY",
  /*  266 */ "DEFERRED",
  /*  267 */ "DELIMITERS",
  /*  268 */ "DETACH",
  /*  269 */ "DIVIDE",
  /*  270 */ "DOT",
  /*  271 */ "EACH",
  /*  272 */ "END",
  /*  273 */ "FAIL",
  /*  274 */ "FILE",
  /*  275 */ "FOR",
  /*  276 */ "GLOB",
  /*  277 */ "ID",
  /*  278 */ "IMMEDIATE",
  /*  279 */ "IMPORT",
  /*  280 */ "INITIALLY",
  /*  281 */ "INSTEAD",
  /*  282 */ "ISNULL",
  /*  283 */ "KEY",
  /*  284 */ "NK_BITNOT",
  /*  285 */ "NK_SEMI",
  /*  286 */ "NOTNULL",
  /*  287 */ "OF",
  /*  288 */ "PLUS",
  /*  289 */ "PRIVILEGE",
  /*  290 */ "RAISE",
  /*  291 */ "REPLACE",
  /*  292 */ "RESTRICT",
  /*  293 */ "ROW",
  /*  294 */ "SEMI",
  /*  295 */ "STAR",
  /*  296 */ "STATEMENT",
  /*  297 */ "STRING",
  /*  298 */ "TIMES",
  /*  299 */ "UPDATE",
  /*  300 */ "VALUES",
  /*  301 */ "VARIABLE",
  /*  302 */ "VIEW",
  /*  303 */ "VNODES",
  /*  304 */ "WAL",
  /*  305 */ "cmd",
  /*  306 */ "account_options",
  /*  307 */ "alter_account_options",
  /*  308 */ "literal",
  /*  309 */ "alter_account_option",
  /*  310 */ "user_name",
  /*  311 */ "sysinfo_opt",
  /*  312 */ "privileges",
  /*  313 */ "priv_level",
  /*  314 */ "priv_type_list",
  /*  315 */ "priv_type",
  /*  316 */ "db_name",
  /*  317 */ "dnode_endpoint",
  /*  318 */ "not_exists_opt",
  /*  319 */ "db_options",
  /*  320 */ "exists_opt",
  /*  321 */ "alter_db_options",
  /*  322 */ "integer_list",
  /*  323 */ "variable_list",
  /*  324 */ "retention_list",
  /*  325 */ "alter_db_option",
  /*  326 */ "retention",
  /*  327 */ "full_table_name",
  /*  328 */ "column_def_list",
  /*  329 */ "tags_def_opt",
  /*  330 */ "table_options",
  /*  331 */ "multi_create_clause",
  /*  332 */ "tags_def",
  /*  333 */ "multi_drop_clause",
  /*  334 */ "alter_table_clause",
  /*  335 */ "alter_table_options",
  /*  336 */ "column_name",
  /*  337 */ "type_name",
  /*  338 */ "signed_literal",
  /*  339 */ "create_subtable_clause",
  /*  340 */ "specific_cols_opt",
  /*  341 */ "expression_list",
  /*  342 */ "drop_table_clause",
  /*  343 */ "col_name_list",
  /*  344 */ "table_name",
  /*  345 */ "column_def",
  /*  346 */ "duration_list",
  /*  347 */ "rollup_func_list",
  /*  348 */ "alter_table_option",
  /*  349 */ "duration_literal",
  /*  350 */ "rollup_func_name",
  /*  351 */ "function_name",
  /*  352 */ "col_name",
  /*  353 */ "db_name_cond_opt",
  /*  354 */ "like_pattern_opt",
  /*  355 */ "table_name_cond",
  /*  356 */ "from_db_opt",
  /*  357 */ "index_options",
  /*  358 */ "func_list",
  /*  359 */ "sliding_opt",
  /*  360 */ "sma_stream_opt",
  /*  361 */ "func",
  /*  362 */ "stream_options",
  /*  363 */ "topic_name",
  /*  364 */ "query_expression",
  /*  365 */ "cgroup_name",
  /*  366 */ "analyze_opt",
  /*  367 */ "explain_options",
  /*  368 */ "agg_func_opt",
  /*  369 */ "bufsize_opt",
  /*  370 */ "stream_name",
  /*  371 */ "into_opt",
  /*  372 */ "dnode_list",
  /*  373 */ "where_clause_opt",
  /*  374 */ "signed",
  /*  375 */ "literal_func",
  /*  376 */ "literal_list",
  /*  377 */ "table_alias",
  /*  378 */ "column_alias",
  /*  379 */ "expression",
  /*  380 */ "pseudo_column",
  /*  381 */ "column_reference",
  /*  382 */ "function_expression",
  /*  383 */ "subquery",
  /*  384 */ "star_func",
  /*  385 */ "star_func_para_list",
  /*  386 */ "noarg_func",
  /*  387 */ "other_para_list",
  /*  388 */ "star_func_para",
  /*  389 */ "predicate",
  /*  390 */ "compare_op",
  /*  391 */ "in_op",
  /*  392 */ "in_predicate_value",
  /*  393 */ "boolean_value_expression",
  /*  394 */ "boolean_primary",
  /*  395 */ "common_expression",
  /*  396 */ "from_clause_opt",
  /*  397 */ "table_reference_list",
  /*  398 */ "table_reference",
  /*  399 */ "table_primary",
  /*  400 */ "joined_table",
  /*  401 */ "alias_opt",
  /*  402 */ "parenthesized_joined_table",
  /*  403 */ "join_type",
  /*  404 */ "search_condition",
  /*  405 */ "query_specification",
  /*  406 */ "set_quantifier_opt",
  /*  407 */ "select_list",
  /*  408 */ "partition_by_clause_opt",
  /*  409 */ "range_opt",
  /*  410 */ "every_opt",
  /*  411 */ "fill_opt",
  /*  412 */ "twindow_clause_opt",
  /*  413 */ "group_by_clause_opt",
  /*  414 */ "having_clause_opt",
  /*  415 */ "select_item",
  /*  416 */ "fill_mode",
  /*  417 */ "group_by_list",
  /*  418 */ "query_expression_body",
  /*  419 */ "order_by_clause_opt",
  /*  420 */ "slimit_clause_opt",
  /*  421 */ "limit_clause_opt",
  /*  422 */ "query_primary",
  /*  423 */ "sort_specification_list",
  /*  424 */ "sort_specification",
  /*  425 */ "ordering_specification_opt",
  /*  426 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  86 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  87 */ "db_options ::= db_options STRICT NK_STRING",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 100 */ "alter_db_options ::= alter_db_option",
 /* 101 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 102 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 103 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 104 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 105 */ "alter_db_option ::= KEEP integer_list",
 /* 106 */ "alter_db_option ::= KEEP variable_list",
 /* 107 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 108 */ "integer_list ::= NK_INTEGER",
 /* 109 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 110 */ "variable_list ::= NK_VARIABLE",
 /* 111 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 112 */ "retention_list ::= retention",
 /* 113 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 114 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 115 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 116 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 117 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 118 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 119 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 120 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 121 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 122 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 123 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 125 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 127 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 129 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 130 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 131 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 132 */ "multi_create_clause ::= create_subtable_clause",
 /* 133 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 134 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 135 */ "multi_drop_clause ::= drop_table_clause",
 /* 136 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 137 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 138 */ "specific_cols_opt ::=",
 /* 139 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 140 */ "full_table_name ::= table_name",
 /* 141 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 142 */ "column_def_list ::= column_def",
 /* 143 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 144 */ "column_def ::= column_name type_name",
 /* 145 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 146 */ "type_name ::= BOOL",
 /* 147 */ "type_name ::= TINYINT",
 /* 148 */ "type_name ::= SMALLINT",
 /* 149 */ "type_name ::= INT",
 /* 150 */ "type_name ::= INTEGER",
 /* 151 */ "type_name ::= BIGINT",
 /* 152 */ "type_name ::= FLOAT",
 /* 153 */ "type_name ::= DOUBLE",
 /* 154 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 155 */ "type_name ::= TIMESTAMP",
 /* 156 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= TINYINT UNSIGNED",
 /* 158 */ "type_name ::= SMALLINT UNSIGNED",
 /* 159 */ "type_name ::= INT UNSIGNED",
 /* 160 */ "type_name ::= BIGINT UNSIGNED",
 /* 161 */ "type_name ::= JSON",
 /* 162 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= MEDIUMBLOB",
 /* 164 */ "type_name ::= BLOB",
 /* 165 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= DECIMAL",
 /* 167 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 169 */ "tags_def_opt ::=",
 /* 170 */ "tags_def_opt ::= tags_def",
 /* 171 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 172 */ "table_options ::=",
 /* 173 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 174 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 175 */ "table_options ::= table_options WATERMARK duration_list",
 /* 176 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 177 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 178 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 179 */ "alter_table_options ::= alter_table_option",
 /* 180 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 181 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 182 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 183 */ "duration_list ::= duration_literal",
 /* 184 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 185 */ "rollup_func_list ::= rollup_func_name",
 /* 186 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 187 */ "rollup_func_name ::= function_name",
 /* 188 */ "rollup_func_name ::= FIRST",
 /* 189 */ "rollup_func_name ::= LAST",
 /* 190 */ "col_name_list ::= col_name",
 /* 191 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 192 */ "col_name ::= column_name",
 /* 193 */ "cmd ::= SHOW DNODES",
 /* 194 */ "cmd ::= SHOW USERS",
 /* 195 */ "cmd ::= SHOW DATABASES",
 /* 196 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 197 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 198 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 199 */ "cmd ::= SHOW MNODES",
 /* 200 */ "cmd ::= SHOW MODULES",
 /* 201 */ "cmd ::= SHOW QNODES",
 /* 202 */ "cmd ::= SHOW FUNCTIONS",
 /* 203 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 204 */ "cmd ::= SHOW STREAMS",
 /* 205 */ "cmd ::= SHOW ACCOUNTS",
 /* 206 */ "cmd ::= SHOW APPS",
 /* 207 */ "cmd ::= SHOW CONNECTIONS",
 /* 208 */ "cmd ::= SHOW LICENCES",
 /* 209 */ "cmd ::= SHOW GRANTS",
 /* 210 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 211 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 212 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 213 */ "cmd ::= SHOW QUERIES",
 /* 214 */ "cmd ::= SHOW SCORES",
 /* 215 */ "cmd ::= SHOW TOPICS",
 /* 216 */ "cmd ::= SHOW VARIABLES",
 /* 217 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 218 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 219 */ "cmd ::= SHOW BNODES",
 /* 220 */ "cmd ::= SHOW SNODES",
 /* 221 */ "cmd ::= SHOW CLUSTER",
 /* 222 */ "cmd ::= SHOW TRANSACTIONS",
 /* 223 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 224 */ "cmd ::= SHOW CONSUMERS",
 /* 225 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 226 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 227 */ "db_name_cond_opt ::=",
 /* 228 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 229 */ "like_pattern_opt ::=",
 /* 230 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 231 */ "table_name_cond ::= table_name",
 /* 232 */ "from_db_opt ::=",
 /* 233 */ "from_db_opt ::= FROM db_name",
 /* 234 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 235 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 236 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 237 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 238 */ "func_list ::= func",
 /* 239 */ "func_list ::= func_list NK_COMMA func",
 /* 240 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 241 */ "sma_stream_opt ::=",
 /* 242 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 243 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 245 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 246 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 247 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 248 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 249 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 250 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 251 */ "cmd ::= DESC full_table_name",
 /* 252 */ "cmd ::= DESCRIBE full_table_name",
 /* 253 */ "cmd ::= RESET QUERY CACHE",
 /* 254 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 255 */ "analyze_opt ::=",
 /* 256 */ "analyze_opt ::= ANALYZE",
 /* 257 */ "explain_options ::=",
 /* 258 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 259 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 260 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 261 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 262 */ "agg_func_opt ::=",
 /* 263 */ "agg_func_opt ::= AGGREGATE",
 /* 264 */ "bufsize_opt ::=",
 /* 265 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 266 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 267 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 268 */ "into_opt ::=",
 /* 269 */ "into_opt ::= INTO full_table_name",
 /* 270 */ "stream_options ::=",
 /* 271 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 272 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 273 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 274 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 275 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 276 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 277 */ "cmd ::= KILL QUERY NK_STRING",
 /* 278 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 279 */ "cmd ::= BALANCE VGROUP",
 /* 280 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 281 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 282 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 283 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 284 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 285 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 286 */ "cmd ::= query_expression",
 /* 287 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 288 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 289 */ "literal ::= NK_INTEGER",
 /* 290 */ "literal ::= NK_FLOAT",
 /* 291 */ "literal ::= NK_STRING",
 /* 292 */ "literal ::= NK_BOOL",
 /* 293 */ "literal ::= TIMESTAMP NK_STRING",
 /* 294 */ "literal ::= duration_literal",
 /* 295 */ "literal ::= NULL",
 /* 296 */ "literal ::= NK_QUESTION",
 /* 297 */ "duration_literal ::= NK_VARIABLE",
 /* 298 */ "signed ::= NK_INTEGER",
 /* 299 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 300 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 301 */ "signed ::= NK_FLOAT",
 /* 302 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 303 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 304 */ "signed_literal ::= signed",
 /* 305 */ "signed_literal ::= NK_STRING",
 /* 306 */ "signed_literal ::= NK_BOOL",
 /* 307 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 308 */ "signed_literal ::= duration_literal",
 /* 309 */ "signed_literal ::= NULL",
 /* 310 */ "signed_literal ::= literal_func",
 /* 311 */ "signed_literal ::= NK_QUESTION",
 /* 312 */ "literal_list ::= signed_literal",
 /* 313 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 314 */ "db_name ::= NK_ID",
 /* 315 */ "table_name ::= NK_ID",
 /* 316 */ "column_name ::= NK_ID",
 /* 317 */ "function_name ::= NK_ID",
 /* 318 */ "table_alias ::= NK_ID",
 /* 319 */ "column_alias ::= NK_ID",
 /* 320 */ "user_name ::= NK_ID",
 /* 321 */ "topic_name ::= NK_ID",
 /* 322 */ "stream_name ::= NK_ID",
 /* 323 */ "cgroup_name ::= NK_ID",
 /* 324 */ "expression ::= literal",
 /* 325 */ "expression ::= pseudo_column",
 /* 326 */ "expression ::= column_reference",
 /* 327 */ "expression ::= function_expression",
 /* 328 */ "expression ::= subquery",
 /* 329 */ "expression ::= NK_LP expression NK_RP",
 /* 330 */ "expression ::= NK_PLUS expression",
 /* 331 */ "expression ::= NK_MINUS expression",
 /* 332 */ "expression ::= expression NK_PLUS expression",
 /* 333 */ "expression ::= expression NK_MINUS expression",
 /* 334 */ "expression ::= expression NK_STAR expression",
 /* 335 */ "expression ::= expression NK_SLASH expression",
 /* 336 */ "expression ::= expression NK_REM expression",
 /* 337 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 338 */ "expression ::= expression NK_BITAND expression",
 /* 339 */ "expression ::= expression NK_BITOR expression",
 /* 340 */ "expression_list ::= expression",
 /* 341 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 342 */ "column_reference ::= column_name",
 /* 343 */ "column_reference ::= table_name NK_DOT column_name",
 /* 344 */ "pseudo_column ::= ROWTS",
 /* 345 */ "pseudo_column ::= TBNAME",
 /* 346 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 347 */ "pseudo_column ::= QSTART",
 /* 348 */ "pseudo_column ::= QEND",
 /* 349 */ "pseudo_column ::= QDURATION",
 /* 350 */ "pseudo_column ::= WSTART",
 /* 351 */ "pseudo_column ::= WEND",
 /* 352 */ "pseudo_column ::= WDURATION",
 /* 353 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 354 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 355 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 356 */ "function_expression ::= literal_func",
 /* 357 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 358 */ "literal_func ::= NOW",
 /* 359 */ "noarg_func ::= NOW",
 /* 360 */ "noarg_func ::= TODAY",
 /* 361 */ "noarg_func ::= TIMEZONE",
 /* 362 */ "noarg_func ::= DATABASE",
 /* 363 */ "noarg_func ::= CLIENT_VERSION",
 /* 364 */ "noarg_func ::= SERVER_VERSION",
 /* 365 */ "noarg_func ::= SERVER_STATUS",
 /* 366 */ "noarg_func ::= CURRENT_USER",
 /* 367 */ "noarg_func ::= USER",
 /* 368 */ "star_func ::= COUNT",
 /* 369 */ "star_func ::= FIRST",
 /* 370 */ "star_func ::= LAST",
 /* 371 */ "star_func ::= LAST_ROW",
 /* 372 */ "star_func_para_list ::= NK_STAR",
 /* 373 */ "star_func_para_list ::= other_para_list",
 /* 374 */ "other_para_list ::= star_func_para",
 /* 375 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 376 */ "star_func_para ::= expression",
 /* 377 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 378 */ "predicate ::= expression compare_op expression",
 /* 379 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 380 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 381 */ "predicate ::= expression IS NULL",
 /* 382 */ "predicate ::= expression IS NOT NULL",
 /* 383 */ "predicate ::= expression in_op in_predicate_value",
 /* 384 */ "compare_op ::= NK_LT",
 /* 385 */ "compare_op ::= NK_GT",
 /* 386 */ "compare_op ::= NK_LE",
 /* 387 */ "compare_op ::= NK_GE",
 /* 388 */ "compare_op ::= NK_NE",
 /* 389 */ "compare_op ::= NK_EQ",
 /* 390 */ "compare_op ::= LIKE",
 /* 391 */ "compare_op ::= NOT LIKE",
 /* 392 */ "compare_op ::= MATCH",
 /* 393 */ "compare_op ::= NMATCH",
 /* 394 */ "compare_op ::= CONTAINS",
 /* 395 */ "in_op ::= IN",
 /* 396 */ "in_op ::= NOT IN",
 /* 397 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 398 */ "boolean_value_expression ::= boolean_primary",
 /* 399 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 400 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 401 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 402 */ "boolean_primary ::= predicate",
 /* 403 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 404 */ "common_expression ::= expression",
 /* 405 */ "common_expression ::= boolean_value_expression",
 /* 406 */ "from_clause_opt ::=",
 /* 407 */ "from_clause_opt ::= FROM table_reference_list",
 /* 408 */ "table_reference_list ::= table_reference",
 /* 409 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 410 */ "table_reference ::= table_primary",
 /* 411 */ "table_reference ::= joined_table",
 /* 412 */ "table_primary ::= table_name alias_opt",
 /* 413 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 414 */ "table_primary ::= subquery alias_opt",
 /* 415 */ "table_primary ::= parenthesized_joined_table",
 /* 416 */ "alias_opt ::=",
 /* 417 */ "alias_opt ::= table_alias",
 /* 418 */ "alias_opt ::= AS table_alias",
 /* 419 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 420 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 421 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 422 */ "join_type ::=",
 /* 423 */ "join_type ::= INNER",
 /* 424 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 425 */ "set_quantifier_opt ::=",
 /* 426 */ "set_quantifier_opt ::= DISTINCT",
 /* 427 */ "set_quantifier_opt ::= ALL",
 /* 428 */ "select_list ::= select_item",
 /* 429 */ "select_list ::= select_list NK_COMMA select_item",
 /* 430 */ "select_item ::= NK_STAR",
 /* 431 */ "select_item ::= common_expression",
 /* 432 */ "select_item ::= common_expression column_alias",
 /* 433 */ "select_item ::= common_expression AS column_alias",
 /* 434 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 435 */ "where_clause_opt ::=",
 /* 436 */ "where_clause_opt ::= WHERE search_condition",
 /* 437 */ "partition_by_clause_opt ::=",
 /* 438 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 439 */ "twindow_clause_opt ::=",
 /* 440 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 441 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 442 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 443 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 444 */ "sliding_opt ::=",
 /* 445 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 446 */ "fill_opt ::=",
 /* 447 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 448 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 449 */ "fill_mode ::= NONE",
 /* 450 */ "fill_mode ::= PREV",
 /* 451 */ "fill_mode ::= NULL",
 /* 452 */ "fill_mode ::= LINEAR",
 /* 453 */ "fill_mode ::= NEXT",
 /* 454 */ "group_by_clause_opt ::=",
 /* 455 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 456 */ "group_by_list ::= expression",
 /* 457 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 458 */ "having_clause_opt ::=",
 /* 459 */ "having_clause_opt ::= HAVING search_condition",
 /* 460 */ "range_opt ::=",
 /* 461 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 462 */ "every_opt ::=",
 /* 463 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 464 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 465 */ "query_expression_body ::= query_primary",
 /* 466 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 467 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 468 */ "query_primary ::= query_specification",
 /* 469 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 470 */ "order_by_clause_opt ::=",
 /* 471 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 472 */ "slimit_clause_opt ::=",
 /* 473 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 474 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 475 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 476 */ "limit_clause_opt ::=",
 /* 477 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 478 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 479 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 480 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 481 */ "search_condition ::= common_expression",
 /* 482 */ "sort_specification_list ::= sort_specification",
 /* 483 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 484 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 485 */ "ordering_specification_opt ::=",
 /* 486 */ "ordering_specification_opt ::= ASC",
 /* 487 */ "ordering_specification_opt ::= DESC",
 /* 488 */ "null_ordering_opt ::=",
 /* 489 */ "null_ordering_opt ::= NULLS FIRST",
 /* 490 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 305: /* cmd */
    case 308: /* literal */
    case 319: /* db_options */
    case 321: /* alter_db_options */
    case 326: /* retention */
    case 327: /* full_table_name */
    case 330: /* table_options */
    case 334: /* alter_table_clause */
    case 335: /* alter_table_options */
    case 338: /* signed_literal */
    case 339: /* create_subtable_clause */
    case 342: /* drop_table_clause */
    case 345: /* column_def */
    case 349: /* duration_literal */
    case 350: /* rollup_func_name */
    case 352: /* col_name */
    case 353: /* db_name_cond_opt */
    case 354: /* like_pattern_opt */
    case 355: /* table_name_cond */
    case 356: /* from_db_opt */
    case 357: /* index_options */
    case 359: /* sliding_opt */
    case 360: /* sma_stream_opt */
    case 361: /* func */
    case 362: /* stream_options */
    case 364: /* query_expression */
    case 367: /* explain_options */
    case 371: /* into_opt */
    case 373: /* where_clause_opt */
    case 374: /* signed */
    case 375: /* literal_func */
    case 379: /* expression */
    case 380: /* pseudo_column */
    case 381: /* column_reference */
    case 382: /* function_expression */
    case 383: /* subquery */
    case 388: /* star_func_para */
    case 389: /* predicate */
    case 392: /* in_predicate_value */
    case 393: /* boolean_value_expression */
    case 394: /* boolean_primary */
    case 395: /* common_expression */
    case 396: /* from_clause_opt */
    case 397: /* table_reference_list */
    case 398: /* table_reference */
    case 399: /* table_primary */
    case 400: /* joined_table */
    case 402: /* parenthesized_joined_table */
    case 404: /* search_condition */
    case 405: /* query_specification */
    case 409: /* range_opt */
    case 410: /* every_opt */
    case 411: /* fill_opt */
    case 412: /* twindow_clause_opt */
    case 414: /* having_clause_opt */
    case 415: /* select_item */
    case 418: /* query_expression_body */
    case 420: /* slimit_clause_opt */
    case 421: /* limit_clause_opt */
    case 422: /* query_primary */
    case 424: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy840)); 
}
      break;
    case 306: /* account_options */
    case 307: /* alter_account_options */
    case 309: /* alter_account_option */
    case 369: /* bufsize_opt */
{
 
}
      break;
    case 310: /* user_name */
    case 313: /* priv_level */
    case 316: /* db_name */
    case 317: /* dnode_endpoint */
    case 336: /* column_name */
    case 344: /* table_name */
    case 351: /* function_name */
    case 363: /* topic_name */
    case 365: /* cgroup_name */
    case 370: /* stream_name */
    case 377: /* table_alias */
    case 378: /* column_alias */
    case 384: /* star_func */
    case 386: /* noarg_func */
    case 401: /* alias_opt */
{
 
}
      break;
    case 311: /* sysinfo_opt */
{
 
}
      break;
    case 312: /* privileges */
    case 314: /* priv_type_list */
    case 315: /* priv_type */
{
 
}
      break;
    case 318: /* not_exists_opt */
    case 320: /* exists_opt */
    case 366: /* analyze_opt */
    case 368: /* agg_func_opt */
    case 406: /* set_quantifier_opt */
{
 
}
      break;
    case 322: /* integer_list */
    case 323: /* variable_list */
    case 324: /* retention_list */
    case 328: /* column_def_list */
    case 329: /* tags_def_opt */
    case 331: /* multi_create_clause */
    case 332: /* tags_def */
    case 333: /* multi_drop_clause */
    case 340: /* specific_cols_opt */
    case 341: /* expression_list */
    case 343: /* col_name_list */
    case 346: /* duration_list */
    case 347: /* rollup_func_list */
    case 358: /* func_list */
    case 372: /* dnode_list */
    case 376: /* literal_list */
    case 385: /* star_func_para_list */
    case 387: /* other_para_list */
    case 407: /* select_list */
    case 408: /* partition_by_clause_opt */
    case 413: /* group_by_clause_opt */
    case 417: /* group_by_list */
    case 419: /* order_by_clause_opt */
    case 423: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy544)); 
}
      break;
    case 325: /* alter_db_option */
    case 348: /* alter_table_option */
{
 
}
      break;
    case 337: /* type_name */
{
 
}
      break;
    case 390: /* compare_op */
    case 391: /* in_op */
{
 
}
      break;
    case 403: /* join_type */
{
 
}
      break;
    case 416: /* fill_mode */
{
 
}
      break;
    case 425: /* ordering_specification_opt */
{
 
}
      break;
    case 426: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  305,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  305,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  306,    0 }, /* (2) account_options ::= */
  {  306,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  306,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  306,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  306,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  306,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  306,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  306,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  306,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  306,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  307,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  307,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  309,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  309,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  309,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  309,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  309,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  309,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  309,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  309,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  309,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  309,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  305,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  305,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  305,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  305,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  305,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  311,    0 }, /* (29) sysinfo_opt ::= */
  {  311,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  305,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  305,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  312,   -1 }, /* (33) privileges ::= ALL */
  {  312,   -1 }, /* (34) privileges ::= priv_type_list */
  {  314,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  314,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  315,   -1 }, /* (37) priv_type ::= READ */
  {  315,   -1 }, /* (38) priv_type ::= WRITE */
  {  313,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  313,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  305,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  305,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  305,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  305,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  305,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  305,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  305,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  305,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  317,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  317,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  317,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  305,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  305,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  305,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  305,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  305,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  305,   -2 }, /* (64) cmd ::= USE db_name */
  {  305,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  305,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  305,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  318,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  318,    0 }, /* (69) not_exists_opt ::= */
  {  320,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  320,    0 }, /* (71) exists_opt ::= */
  {  319,    0 }, /* (72) db_options ::= */
  {  319,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  319,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  319,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  319,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  319,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  319,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  319,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  319,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  319,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  319,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  319,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  319,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  319,   -3 }, /* (85) db_options ::= db_options PRECISION NK_STRING */
  {  319,   -3 }, /* (86) db_options ::= db_options REPLICA NK_INTEGER */
  {  319,   -3 }, /* (87) db_options ::= db_options STRICT NK_STRING */
  {  319,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  319,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  319,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  319,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  319,   -3 }, /* (92) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  319,   -3 }, /* (93) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  319,   -3 }, /* (94) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  319,   -4 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  319,   -3 }, /* (96) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  319,   -4 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  319,   -3 }, /* (98) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  319,   -3 }, /* (99) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  321,   -1 }, /* (100) alter_db_options ::= alter_db_option */
  {  321,   -2 }, /* (101) alter_db_options ::= alter_db_options alter_db_option */
  {  325,   -2 }, /* (102) alter_db_option ::= CACHEMODEL NK_STRING */
  {  325,   -2 }, /* (103) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  325,   -2 }, /* (104) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  325,   -2 }, /* (105) alter_db_option ::= KEEP integer_list */
  {  325,   -2 }, /* (106) alter_db_option ::= KEEP variable_list */
  {  325,   -2 }, /* (107) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  322,   -1 }, /* (108) integer_list ::= NK_INTEGER */
  {  322,   -3 }, /* (109) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  323,   -1 }, /* (110) variable_list ::= NK_VARIABLE */
  {  323,   -3 }, /* (111) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  324,   -1 }, /* (112) retention_list ::= retention */
  {  324,   -3 }, /* (113) retention_list ::= retention_list NK_COMMA retention */
  {  326,   -3 }, /* (114) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  305,   -9 }, /* (115) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  305,   -3 }, /* (116) cmd ::= CREATE TABLE multi_create_clause */
  {  305,   -9 }, /* (117) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  305,   -3 }, /* (118) cmd ::= DROP TABLE multi_drop_clause */
  {  305,   -4 }, /* (119) cmd ::= DROP STABLE exists_opt full_table_name */
  {  305,   -3 }, /* (120) cmd ::= ALTER TABLE alter_table_clause */
  {  305,   -3 }, /* (121) cmd ::= ALTER STABLE alter_table_clause */
  {  334,   -2 }, /* (122) alter_table_clause ::= full_table_name alter_table_options */
  {  334,   -5 }, /* (123) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  334,   -4 }, /* (124) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  334,   -5 }, /* (125) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  334,   -5 }, /* (126) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  334,   -5 }, /* (127) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  334,   -4 }, /* (128) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  334,   -5 }, /* (129) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  334,   -5 }, /* (130) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  334,   -6 }, /* (131) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  331,   -1 }, /* (132) multi_create_clause ::= create_subtable_clause */
  {  331,   -2 }, /* (133) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  339,  -10 }, /* (134) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  333,   -1 }, /* (135) multi_drop_clause ::= drop_table_clause */
  {  333,   -2 }, /* (136) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  342,   -2 }, /* (137) drop_table_clause ::= exists_opt full_table_name */
  {  340,    0 }, /* (138) specific_cols_opt ::= */
  {  340,   -3 }, /* (139) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  327,   -1 }, /* (140) full_table_name ::= table_name */
  {  327,   -3 }, /* (141) full_table_name ::= db_name NK_DOT table_name */
  {  328,   -1 }, /* (142) column_def_list ::= column_def */
  {  328,   -3 }, /* (143) column_def_list ::= column_def_list NK_COMMA column_def */
  {  345,   -2 }, /* (144) column_def ::= column_name type_name */
  {  345,   -4 }, /* (145) column_def ::= column_name type_name COMMENT NK_STRING */
  {  337,   -1 }, /* (146) type_name ::= BOOL */
  {  337,   -1 }, /* (147) type_name ::= TINYINT */
  {  337,   -1 }, /* (148) type_name ::= SMALLINT */
  {  337,   -1 }, /* (149) type_name ::= INT */
  {  337,   -1 }, /* (150) type_name ::= INTEGER */
  {  337,   -1 }, /* (151) type_name ::= BIGINT */
  {  337,   -1 }, /* (152) type_name ::= FLOAT */
  {  337,   -1 }, /* (153) type_name ::= DOUBLE */
  {  337,   -4 }, /* (154) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  337,   -1 }, /* (155) type_name ::= TIMESTAMP */
  {  337,   -4 }, /* (156) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  337,   -2 }, /* (157) type_name ::= TINYINT UNSIGNED */
  {  337,   -2 }, /* (158) type_name ::= SMALLINT UNSIGNED */
  {  337,   -2 }, /* (159) type_name ::= INT UNSIGNED */
  {  337,   -2 }, /* (160) type_name ::= BIGINT UNSIGNED */
  {  337,   -1 }, /* (161) type_name ::= JSON */
  {  337,   -4 }, /* (162) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  337,   -1 }, /* (163) type_name ::= MEDIUMBLOB */
  {  337,   -1 }, /* (164) type_name ::= BLOB */
  {  337,   -4 }, /* (165) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  337,   -1 }, /* (166) type_name ::= DECIMAL */
  {  337,   -4 }, /* (167) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  337,   -6 }, /* (168) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  329,    0 }, /* (169) tags_def_opt ::= */
  {  329,   -1 }, /* (170) tags_def_opt ::= tags_def */
  {  332,   -4 }, /* (171) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  330,    0 }, /* (172) table_options ::= */
  {  330,   -3 }, /* (173) table_options ::= table_options COMMENT NK_STRING */
  {  330,   -3 }, /* (174) table_options ::= table_options MAX_DELAY duration_list */
  {  330,   -3 }, /* (175) table_options ::= table_options WATERMARK duration_list */
  {  330,   -5 }, /* (176) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  330,   -3 }, /* (177) table_options ::= table_options TTL NK_INTEGER */
  {  330,   -5 }, /* (178) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  335,   -1 }, /* (179) alter_table_options ::= alter_table_option */
  {  335,   -2 }, /* (180) alter_table_options ::= alter_table_options alter_table_option */
  {  348,   -2 }, /* (181) alter_table_option ::= COMMENT NK_STRING */
  {  348,   -2 }, /* (182) alter_table_option ::= TTL NK_INTEGER */
  {  346,   -1 }, /* (183) duration_list ::= duration_literal */
  {  346,   -3 }, /* (184) duration_list ::= duration_list NK_COMMA duration_literal */
  {  347,   -1 }, /* (185) rollup_func_list ::= rollup_func_name */
  {  347,   -3 }, /* (186) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  350,   -1 }, /* (187) rollup_func_name ::= function_name */
  {  350,   -1 }, /* (188) rollup_func_name ::= FIRST */
  {  350,   -1 }, /* (189) rollup_func_name ::= LAST */
  {  343,   -1 }, /* (190) col_name_list ::= col_name */
  {  343,   -3 }, /* (191) col_name_list ::= col_name_list NK_COMMA col_name */
  {  352,   -1 }, /* (192) col_name ::= column_name */
  {  305,   -2 }, /* (193) cmd ::= SHOW DNODES */
  {  305,   -2 }, /* (194) cmd ::= SHOW USERS */
  {  305,   -2 }, /* (195) cmd ::= SHOW DATABASES */
  {  305,   -4 }, /* (196) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  305,   -4 }, /* (197) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  305,   -3 }, /* (198) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  305,   -2 }, /* (199) cmd ::= SHOW MNODES */
  {  305,   -2 }, /* (200) cmd ::= SHOW MODULES */
  {  305,   -2 }, /* (201) cmd ::= SHOW QNODES */
  {  305,   -2 }, /* (202) cmd ::= SHOW FUNCTIONS */
  {  305,   -5 }, /* (203) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  305,   -2 }, /* (204) cmd ::= SHOW STREAMS */
  {  305,   -2 }, /* (205) cmd ::= SHOW ACCOUNTS */
  {  305,   -2 }, /* (206) cmd ::= SHOW APPS */
  {  305,   -2 }, /* (207) cmd ::= SHOW CONNECTIONS */
  {  305,   -2 }, /* (208) cmd ::= SHOW LICENCES */
  {  305,   -2 }, /* (209) cmd ::= SHOW GRANTS */
  {  305,   -4 }, /* (210) cmd ::= SHOW CREATE DATABASE db_name */
  {  305,   -4 }, /* (211) cmd ::= SHOW CREATE TABLE full_table_name */
  {  305,   -4 }, /* (212) cmd ::= SHOW CREATE STABLE full_table_name */
  {  305,   -2 }, /* (213) cmd ::= SHOW QUERIES */
  {  305,   -2 }, /* (214) cmd ::= SHOW SCORES */
  {  305,   -2 }, /* (215) cmd ::= SHOW TOPICS */
  {  305,   -2 }, /* (216) cmd ::= SHOW VARIABLES */
  {  305,   -3 }, /* (217) cmd ::= SHOW LOCAL VARIABLES */
  {  305,   -4 }, /* (218) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  305,   -2 }, /* (219) cmd ::= SHOW BNODES */
  {  305,   -2 }, /* (220) cmd ::= SHOW SNODES */
  {  305,   -2 }, /* (221) cmd ::= SHOW CLUSTER */
  {  305,   -2 }, /* (222) cmd ::= SHOW TRANSACTIONS */
  {  305,   -4 }, /* (223) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  305,   -2 }, /* (224) cmd ::= SHOW CONSUMERS */
  {  305,   -2 }, /* (225) cmd ::= SHOW SUBSCRIPTIONS */
  {  305,   -5 }, /* (226) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  353,    0 }, /* (227) db_name_cond_opt ::= */
  {  353,   -2 }, /* (228) db_name_cond_opt ::= db_name NK_DOT */
  {  354,    0 }, /* (229) like_pattern_opt ::= */
  {  354,   -2 }, /* (230) like_pattern_opt ::= LIKE NK_STRING */
  {  355,   -1 }, /* (231) table_name_cond ::= table_name */
  {  356,    0 }, /* (232) from_db_opt ::= */
  {  356,   -2 }, /* (233) from_db_opt ::= FROM db_name */
  {  305,   -8 }, /* (234) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  305,   -4 }, /* (235) cmd ::= DROP INDEX exists_opt full_table_name */
  {  357,  -10 }, /* (236) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  357,  -12 }, /* (237) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  358,   -1 }, /* (238) func_list ::= func */
  {  358,   -3 }, /* (239) func_list ::= func_list NK_COMMA func */
  {  361,   -4 }, /* (240) func ::= function_name NK_LP expression_list NK_RP */
  {  360,    0 }, /* (241) sma_stream_opt ::= */
  {  360,   -3 }, /* (242) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  360,   -3 }, /* (243) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  305,   -6 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  305,   -7 }, /* (245) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  305,   -9 }, /* (246) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  305,   -7 }, /* (247) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  305,   -9 }, /* (248) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  305,   -4 }, /* (249) cmd ::= DROP TOPIC exists_opt topic_name */
  {  305,   -7 }, /* (250) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  305,   -2 }, /* (251) cmd ::= DESC full_table_name */
  {  305,   -2 }, /* (252) cmd ::= DESCRIBE full_table_name */
  {  305,   -3 }, /* (253) cmd ::= RESET QUERY CACHE */
  {  305,   -4 }, /* (254) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  366,    0 }, /* (255) analyze_opt ::= */
  {  366,   -1 }, /* (256) analyze_opt ::= ANALYZE */
  {  367,    0 }, /* (257) explain_options ::= */
  {  367,   -3 }, /* (258) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  367,   -3 }, /* (259) explain_options ::= explain_options RATIO NK_FLOAT */
  {  305,  -10 }, /* (260) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  305,   -4 }, /* (261) cmd ::= DROP FUNCTION exists_opt function_name */
  {  368,    0 }, /* (262) agg_func_opt ::= */
  {  368,   -1 }, /* (263) agg_func_opt ::= AGGREGATE */
  {  369,    0 }, /* (264) bufsize_opt ::= */
  {  369,   -2 }, /* (265) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  305,   -8 }, /* (266) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  305,   -4 }, /* (267) cmd ::= DROP STREAM exists_opt stream_name */
  {  371,    0 }, /* (268) into_opt ::= */
  {  371,   -2 }, /* (269) into_opt ::= INTO full_table_name */
  {  362,    0 }, /* (270) stream_options ::= */
  {  362,   -3 }, /* (271) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  362,   -3 }, /* (272) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  362,   -4 }, /* (273) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  362,   -3 }, /* (274) stream_options ::= stream_options WATERMARK duration_literal */
  {  362,   -4 }, /* (275) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  305,   -3 }, /* (276) cmd ::= KILL CONNECTION NK_INTEGER */
  {  305,   -3 }, /* (277) cmd ::= KILL QUERY NK_STRING */
  {  305,   -3 }, /* (278) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  305,   -2 }, /* (279) cmd ::= BALANCE VGROUP */
  {  305,   -4 }, /* (280) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  305,   -4 }, /* (281) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  305,   -3 }, /* (282) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  372,   -2 }, /* (283) dnode_list ::= DNODE NK_INTEGER */
  {  372,   -3 }, /* (284) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  305,   -4 }, /* (285) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  305,   -1 }, /* (286) cmd ::= query_expression */
  {  305,   -7 }, /* (287) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  305,   -4 }, /* (288) cmd ::= INSERT INTO full_table_name query_expression */
  {  308,   -1 }, /* (289) literal ::= NK_INTEGER */
  {  308,   -1 }, /* (290) literal ::= NK_FLOAT */
  {  308,   -1 }, /* (291) literal ::= NK_STRING */
  {  308,   -1 }, /* (292) literal ::= NK_BOOL */
  {  308,   -2 }, /* (293) literal ::= TIMESTAMP NK_STRING */
  {  308,   -1 }, /* (294) literal ::= duration_literal */
  {  308,   -1 }, /* (295) literal ::= NULL */
  {  308,   -1 }, /* (296) literal ::= NK_QUESTION */
  {  349,   -1 }, /* (297) duration_literal ::= NK_VARIABLE */
  {  374,   -1 }, /* (298) signed ::= NK_INTEGER */
  {  374,   -2 }, /* (299) signed ::= NK_PLUS NK_INTEGER */
  {  374,   -2 }, /* (300) signed ::= NK_MINUS NK_INTEGER */
  {  374,   -1 }, /* (301) signed ::= NK_FLOAT */
  {  374,   -2 }, /* (302) signed ::= NK_PLUS NK_FLOAT */
  {  374,   -2 }, /* (303) signed ::= NK_MINUS NK_FLOAT */
  {  338,   -1 }, /* (304) signed_literal ::= signed */
  {  338,   -1 }, /* (305) signed_literal ::= NK_STRING */
  {  338,   -1 }, /* (306) signed_literal ::= NK_BOOL */
  {  338,   -2 }, /* (307) signed_literal ::= TIMESTAMP NK_STRING */
  {  338,   -1 }, /* (308) signed_literal ::= duration_literal */
  {  338,   -1 }, /* (309) signed_literal ::= NULL */
  {  338,   -1 }, /* (310) signed_literal ::= literal_func */
  {  338,   -1 }, /* (311) signed_literal ::= NK_QUESTION */
  {  376,   -1 }, /* (312) literal_list ::= signed_literal */
  {  376,   -3 }, /* (313) literal_list ::= literal_list NK_COMMA signed_literal */
  {  316,   -1 }, /* (314) db_name ::= NK_ID */
  {  344,   -1 }, /* (315) table_name ::= NK_ID */
  {  336,   -1 }, /* (316) column_name ::= NK_ID */
  {  351,   -1 }, /* (317) function_name ::= NK_ID */
  {  377,   -1 }, /* (318) table_alias ::= NK_ID */
  {  378,   -1 }, /* (319) column_alias ::= NK_ID */
  {  310,   -1 }, /* (320) user_name ::= NK_ID */
  {  363,   -1 }, /* (321) topic_name ::= NK_ID */
  {  370,   -1 }, /* (322) stream_name ::= NK_ID */
  {  365,   -1 }, /* (323) cgroup_name ::= NK_ID */
  {  379,   -1 }, /* (324) expression ::= literal */
  {  379,   -1 }, /* (325) expression ::= pseudo_column */
  {  379,   -1 }, /* (326) expression ::= column_reference */
  {  379,   -1 }, /* (327) expression ::= function_expression */
  {  379,   -1 }, /* (328) expression ::= subquery */
  {  379,   -3 }, /* (329) expression ::= NK_LP expression NK_RP */
  {  379,   -2 }, /* (330) expression ::= NK_PLUS expression */
  {  379,   -2 }, /* (331) expression ::= NK_MINUS expression */
  {  379,   -3 }, /* (332) expression ::= expression NK_PLUS expression */
  {  379,   -3 }, /* (333) expression ::= expression NK_MINUS expression */
  {  379,   -3 }, /* (334) expression ::= expression NK_STAR expression */
  {  379,   -3 }, /* (335) expression ::= expression NK_SLASH expression */
  {  379,   -3 }, /* (336) expression ::= expression NK_REM expression */
  {  379,   -3 }, /* (337) expression ::= column_reference NK_ARROW NK_STRING */
  {  379,   -3 }, /* (338) expression ::= expression NK_BITAND expression */
  {  379,   -3 }, /* (339) expression ::= expression NK_BITOR expression */
  {  341,   -1 }, /* (340) expression_list ::= expression */
  {  341,   -3 }, /* (341) expression_list ::= expression_list NK_COMMA expression */
  {  381,   -1 }, /* (342) column_reference ::= column_name */
  {  381,   -3 }, /* (343) column_reference ::= table_name NK_DOT column_name */
  {  380,   -1 }, /* (344) pseudo_column ::= ROWTS */
  {  380,   -1 }, /* (345) pseudo_column ::= TBNAME */
  {  380,   -3 }, /* (346) pseudo_column ::= table_name NK_DOT TBNAME */
  {  380,   -1 }, /* (347) pseudo_column ::= QSTART */
  {  380,   -1 }, /* (348) pseudo_column ::= QEND */
  {  380,   -1 }, /* (349) pseudo_column ::= QDURATION */
  {  380,   -1 }, /* (350) pseudo_column ::= WSTART */
  {  380,   -1 }, /* (351) pseudo_column ::= WEND */
  {  380,   -1 }, /* (352) pseudo_column ::= WDURATION */
  {  382,   -4 }, /* (353) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  382,   -4 }, /* (354) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  382,   -6 }, /* (355) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  382,   -1 }, /* (356) function_expression ::= literal_func */
  {  375,   -3 }, /* (357) literal_func ::= noarg_func NK_LP NK_RP */
  {  375,   -1 }, /* (358) literal_func ::= NOW */
  {  386,   -1 }, /* (359) noarg_func ::= NOW */
  {  386,   -1 }, /* (360) noarg_func ::= TODAY */
  {  386,   -1 }, /* (361) noarg_func ::= TIMEZONE */
  {  386,   -1 }, /* (362) noarg_func ::= DATABASE */
  {  386,   -1 }, /* (363) noarg_func ::= CLIENT_VERSION */
  {  386,   -1 }, /* (364) noarg_func ::= SERVER_VERSION */
  {  386,   -1 }, /* (365) noarg_func ::= SERVER_STATUS */
  {  386,   -1 }, /* (366) noarg_func ::= CURRENT_USER */
  {  386,   -1 }, /* (367) noarg_func ::= USER */
  {  384,   -1 }, /* (368) star_func ::= COUNT */
  {  384,   -1 }, /* (369) star_func ::= FIRST */
  {  384,   -1 }, /* (370) star_func ::= LAST */
  {  384,   -1 }, /* (371) star_func ::= LAST_ROW */
  {  385,   -1 }, /* (372) star_func_para_list ::= NK_STAR */
  {  385,   -1 }, /* (373) star_func_para_list ::= other_para_list */
  {  387,   -1 }, /* (374) other_para_list ::= star_func_para */
  {  387,   -3 }, /* (375) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  388,   -1 }, /* (376) star_func_para ::= expression */
  {  388,   -3 }, /* (377) star_func_para ::= table_name NK_DOT NK_STAR */
  {  389,   -3 }, /* (378) predicate ::= expression compare_op expression */
  {  389,   -5 }, /* (379) predicate ::= expression BETWEEN expression AND expression */
  {  389,   -6 }, /* (380) predicate ::= expression NOT BETWEEN expression AND expression */
  {  389,   -3 }, /* (381) predicate ::= expression IS NULL */
  {  389,   -4 }, /* (382) predicate ::= expression IS NOT NULL */
  {  389,   -3 }, /* (383) predicate ::= expression in_op in_predicate_value */
  {  390,   -1 }, /* (384) compare_op ::= NK_LT */
  {  390,   -1 }, /* (385) compare_op ::= NK_GT */
  {  390,   -1 }, /* (386) compare_op ::= NK_LE */
  {  390,   -1 }, /* (387) compare_op ::= NK_GE */
  {  390,   -1 }, /* (388) compare_op ::= NK_NE */
  {  390,   -1 }, /* (389) compare_op ::= NK_EQ */
  {  390,   -1 }, /* (390) compare_op ::= LIKE */
  {  390,   -2 }, /* (391) compare_op ::= NOT LIKE */
  {  390,   -1 }, /* (392) compare_op ::= MATCH */
  {  390,   -1 }, /* (393) compare_op ::= NMATCH */
  {  390,   -1 }, /* (394) compare_op ::= CONTAINS */
  {  391,   -1 }, /* (395) in_op ::= IN */
  {  391,   -2 }, /* (396) in_op ::= NOT IN */
  {  392,   -3 }, /* (397) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  393,   -1 }, /* (398) boolean_value_expression ::= boolean_primary */
  {  393,   -2 }, /* (399) boolean_value_expression ::= NOT boolean_primary */
  {  393,   -3 }, /* (400) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  393,   -3 }, /* (401) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  394,   -1 }, /* (402) boolean_primary ::= predicate */
  {  394,   -3 }, /* (403) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  395,   -1 }, /* (404) common_expression ::= expression */
  {  395,   -1 }, /* (405) common_expression ::= boolean_value_expression */
  {  396,    0 }, /* (406) from_clause_opt ::= */
  {  396,   -2 }, /* (407) from_clause_opt ::= FROM table_reference_list */
  {  397,   -1 }, /* (408) table_reference_list ::= table_reference */
  {  397,   -3 }, /* (409) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  398,   -1 }, /* (410) table_reference ::= table_primary */
  {  398,   -1 }, /* (411) table_reference ::= joined_table */
  {  399,   -2 }, /* (412) table_primary ::= table_name alias_opt */
  {  399,   -4 }, /* (413) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  399,   -2 }, /* (414) table_primary ::= subquery alias_opt */
  {  399,   -1 }, /* (415) table_primary ::= parenthesized_joined_table */
  {  401,    0 }, /* (416) alias_opt ::= */
  {  401,   -1 }, /* (417) alias_opt ::= table_alias */
  {  401,   -2 }, /* (418) alias_opt ::= AS table_alias */
  {  402,   -3 }, /* (419) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  402,   -3 }, /* (420) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  400,   -6 }, /* (421) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  403,    0 }, /* (422) join_type ::= */
  {  403,   -1 }, /* (423) join_type ::= INNER */
  {  405,  -12 }, /* (424) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  406,    0 }, /* (425) set_quantifier_opt ::= */
  {  406,   -1 }, /* (426) set_quantifier_opt ::= DISTINCT */
  {  406,   -1 }, /* (427) set_quantifier_opt ::= ALL */
  {  407,   -1 }, /* (428) select_list ::= select_item */
  {  407,   -3 }, /* (429) select_list ::= select_list NK_COMMA select_item */
  {  415,   -1 }, /* (430) select_item ::= NK_STAR */
  {  415,   -1 }, /* (431) select_item ::= common_expression */
  {  415,   -2 }, /* (432) select_item ::= common_expression column_alias */
  {  415,   -3 }, /* (433) select_item ::= common_expression AS column_alias */
  {  415,   -3 }, /* (434) select_item ::= table_name NK_DOT NK_STAR */
  {  373,    0 }, /* (435) where_clause_opt ::= */
  {  373,   -2 }, /* (436) where_clause_opt ::= WHERE search_condition */
  {  408,    0 }, /* (437) partition_by_clause_opt ::= */
  {  408,   -3 }, /* (438) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  412,    0 }, /* (439) twindow_clause_opt ::= */
  {  412,   -6 }, /* (440) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  412,   -4 }, /* (441) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  412,   -6 }, /* (442) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  412,   -8 }, /* (443) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  359,    0 }, /* (444) sliding_opt ::= */
  {  359,   -4 }, /* (445) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  411,    0 }, /* (446) fill_opt ::= */
  {  411,   -4 }, /* (447) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  411,   -6 }, /* (448) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  416,   -1 }, /* (449) fill_mode ::= NONE */
  {  416,   -1 }, /* (450) fill_mode ::= PREV */
  {  416,   -1 }, /* (451) fill_mode ::= NULL */
  {  416,   -1 }, /* (452) fill_mode ::= LINEAR */
  {  416,   -1 }, /* (453) fill_mode ::= NEXT */
  {  413,    0 }, /* (454) group_by_clause_opt ::= */
  {  413,   -3 }, /* (455) group_by_clause_opt ::= GROUP BY group_by_list */
  {  417,   -1 }, /* (456) group_by_list ::= expression */
  {  417,   -3 }, /* (457) group_by_list ::= group_by_list NK_COMMA expression */
  {  414,    0 }, /* (458) having_clause_opt ::= */
  {  414,   -2 }, /* (459) having_clause_opt ::= HAVING search_condition */
  {  409,    0 }, /* (460) range_opt ::= */
  {  409,   -6 }, /* (461) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  410,    0 }, /* (462) every_opt ::= */
  {  410,   -4 }, /* (463) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  364,   -4 }, /* (464) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  418,   -1 }, /* (465) query_expression_body ::= query_primary */
  {  418,   -4 }, /* (466) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  418,   -3 }, /* (467) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  422,   -1 }, /* (468) query_primary ::= query_specification */
  {  422,   -6 }, /* (469) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  419,    0 }, /* (470) order_by_clause_opt ::= */
  {  419,   -3 }, /* (471) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  420,    0 }, /* (472) slimit_clause_opt ::= */
  {  420,   -2 }, /* (473) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  420,   -4 }, /* (474) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  420,   -4 }, /* (475) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  421,    0 }, /* (476) limit_clause_opt ::= */
  {  421,   -2 }, /* (477) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  421,   -4 }, /* (478) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  421,   -4 }, /* (479) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  383,   -3 }, /* (480) subquery ::= NK_LP query_expression NK_RP */
  {  404,   -1 }, /* (481) search_condition ::= common_expression */
  {  423,   -1 }, /* (482) sort_specification_list ::= sort_specification */
  {  423,   -3 }, /* (483) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  424,   -3 }, /* (484) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  425,    0 }, /* (485) ordering_specification_opt ::= */
  {  425,   -1 }, /* (486) ordering_specification_opt ::= ASC */
  {  425,   -1 }, /* (487) ordering_specification_opt ::= DESC */
  {  426,    0 }, /* (488) null_ordering_opt ::= */
  {  426,   -2 }, /* (489) null_ordering_opt ::= NULLS FIRST */
  {  426,   -2 }, /* (490) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,306,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,307,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,306,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,308,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,309,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,307,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,309,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,308,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy617, &yymsp[-1].minor.yy0, yymsp[0].minor.yy215); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy617, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy617, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy617, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy215 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy215 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy473, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy473, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy473 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy473 = yymsp[0].minor.yy473; }
  yymsp[0].minor.yy473 = yylhsminor.yy473;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy473 = yymsp[-2].minor.yy473 | yymsp[0].minor.yy473; }
  yymsp[-2].minor.yy473 = yylhsminor.yy473;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy473 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy473 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy617 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy617 = yylhsminor.yy617;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy617 = yymsp[-2].minor.yy617; }
  yymsp[-2].minor.yy617 = yylhsminor.yy617;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy617, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 314: /* db_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* table_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* column_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* function_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* table_alias ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* column_alias ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* user_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* topic_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* stream_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 359: /* noarg_func ::= NOW */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= TODAY */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= USER */ yytestcase(yyruleno==367);
      case 368: /* star_func ::= COUNT */ yytestcase(yyruleno==368);
      case 369: /* star_func ::= FIRST */ yytestcase(yyruleno==369);
      case 370: /* star_func ::= LAST */ yytestcase(yyruleno==370);
      case 371: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==371);
{ yylhsminor.yy617 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy617 = yylhsminor.yy617;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy313, &yymsp[-1].minor.yy617, yymsp[0].minor.yy840); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy617, yymsp[0].minor.yy840); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy313 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 255: /* analyze_opt ::= */ yytestcase(yyruleno==255);
      case 262: /* agg_func_opt ::= */ yytestcase(yyruleno==262);
      case 425: /* set_quantifier_opt ::= */ yytestcase(yyruleno==425);
{ yymsp[1].minor.yy313 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy313 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy840 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_KEEP, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 85: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 86: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 87: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_RETENTIONS, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 92: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 93: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 94: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-3].minor.yy840, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-3].minor.yy840, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 98: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 99: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy840 = setDatabaseOption(pCxt, yymsp[-2].minor.yy840, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 100: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy840 = createAlterDatabaseOptions(pCxt); yylhsminor.yy840 = setAlterDatabaseOption(pCxt, yylhsminor.yy840, &yymsp[0].minor.yy95); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 101: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy840 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy840, &yymsp[0].minor.yy95); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 102: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy95.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy95.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy95.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= KEEP integer_list */
      case 106: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==106);
{ yymsp[-1].minor.yy95.type = DB_OPTION_KEEP; yymsp[-1].minor.yy95.pList = yymsp[0].minor.yy544; }
        break;
      case 107: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy95.type = DB_OPTION_WAL; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy544 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 109: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 284: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==284);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 110: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy544 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 111: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 112: /* retention_list ::= retention */
      case 132: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==132);
      case 135: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==135);
      case 142: /* column_def_list ::= column_def */ yytestcase(yyruleno==142);
      case 185: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==185);
      case 190: /* col_name_list ::= col_name */ yytestcase(yyruleno==190);
      case 238: /* func_list ::= func */ yytestcase(yyruleno==238);
      case 312: /* literal_list ::= signed_literal */ yytestcase(yyruleno==312);
      case 374: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==374);
      case 428: /* select_list ::= select_item */ yytestcase(yyruleno==428);
      case 482: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==482);
{ yylhsminor.yy544 = createNodeList(pCxt, yymsp[0].minor.yy840); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 113: /* retention_list ::= retention_list NK_COMMA retention */
      case 143: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==143);
      case 186: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==186);
      case 191: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==191);
      case 239: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==239);
      case 313: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==313);
      case 375: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==375);
      case 429: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==429);
      case 483: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==483);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, yymsp[0].minor.yy840); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 114: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy840 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 115: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 117: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==117);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy313, yymsp[-5].minor.yy840, yymsp[-3].minor.yy544, yymsp[-1].minor.yy544, yymsp[0].minor.yy840); }
        break;
      case 116: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy544); }
        break;
      case 118: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy544); }
        break;
      case 119: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy313, yymsp[0].minor.yy840); }
        break;
      case 120: /* cmd ::= ALTER TABLE alter_table_clause */
      case 286: /* cmd ::= query_expression */ yytestcase(yyruleno==286);
{ pCxt->pRootNode = yymsp[0].minor.yy840; }
        break;
      case 121: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy840); }
        break;
      case 122: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy840 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 123: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 124: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy840 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy840, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy617); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 125: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 126: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy840 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 127: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 128: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy840 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy840, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy617); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 129: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy840 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 130: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy840 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy840, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 131: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy840 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy840, &yymsp[-2].minor.yy617, yymsp[0].minor.yy840); }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 133: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 136: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==136);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-1].minor.yy544, yymsp[0].minor.yy840); }
  yymsp[-1].minor.yy544 = yylhsminor.yy544;
        break;
      case 134: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy840 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy313, yymsp[-8].minor.yy840, yymsp[-6].minor.yy840, yymsp[-5].minor.yy544, yymsp[-2].minor.yy544, yymsp[0].minor.yy840); }
  yymsp[-9].minor.yy840 = yylhsminor.yy840;
        break;
      case 137: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy840 = createDropTableClause(pCxt, yymsp[-1].minor.yy313, yymsp[0].minor.yy840); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 138: /* specific_cols_opt ::= */
      case 169: /* tags_def_opt ::= */ yytestcase(yyruleno==169);
      case 437: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==437);
      case 454: /* group_by_clause_opt ::= */ yytestcase(yyruleno==454);
      case 470: /* order_by_clause_opt ::= */ yytestcase(yyruleno==470);
{ yymsp[1].minor.yy544 = NULL; }
        break;
      case 139: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy544 = yymsp[-1].minor.yy544; }
        break;
      case 140: /* full_table_name ::= table_name */
{ yylhsminor.yy840 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy617, NULL); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 141: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy840 = createRealTableNode(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617, NULL); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 144: /* column_def ::= column_name type_name */
{ yylhsminor.yy840 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy617, yymsp[0].minor.yy784, NULL); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 145: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy840 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy617, yymsp[-2].minor.yy784, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 146: /* type_name ::= BOOL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 147: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 148: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 149: /* type_name ::= INT */
      case 150: /* type_name ::= INTEGER */ yytestcase(yyruleno==150);
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 151: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 152: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 153: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 154: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 155: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 156: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 158: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 159: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 160: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 161: /* type_name ::= JSON */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 162: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 163: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 164: /* type_name ::= BLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 165: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 167: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 168: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 170: /* tags_def_opt ::= tags_def */
      case 373: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==373);
{ yylhsminor.yy544 = yymsp[0].minor.yy544; }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 171: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy544 = yymsp[-1].minor.yy544; }
        break;
      case 172: /* table_options ::= */
{ yymsp[1].minor.yy840 = createDefaultTableOptions(pCxt); }
        break;
      case 173: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 174: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 175: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy544); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 176: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-4].minor.yy840, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy544); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 177: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-2].minor.yy840, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 178: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-4].minor.yy840, TABLE_OPTION_SMA, yymsp[-1].minor.yy544); }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 179: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy840 = createAlterTableOptions(pCxt); yylhsminor.yy840 = setTableOption(pCxt, yylhsminor.yy840, yymsp[0].minor.yy95.type, &yymsp[0].minor.yy95.val); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 180: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy840 = setTableOption(pCxt, yymsp[-1].minor.yy840, yymsp[0].minor.yy95.type, &yymsp[0].minor.yy95.val); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 181: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy95.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 182: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy95.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy95.val = yymsp[0].minor.yy0; }
        break;
      case 183: /* duration_list ::= duration_literal */
      case 340: /* expression_list ::= expression */ yytestcase(yyruleno==340);
{ yylhsminor.yy544 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy840)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 184: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 341: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==341);
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, releaseRawExprNode(pCxt, yymsp[0].minor.yy840)); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 187: /* rollup_func_name ::= function_name */
{ yylhsminor.yy840 = createFunctionNode(pCxt, &yymsp[0].minor.yy617, NULL); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 188: /* rollup_func_name ::= FIRST */
      case 189: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==189);
{ yylhsminor.yy840 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 192: /* col_name ::= column_name */
{ yylhsminor.yy840 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy617); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 193: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 195: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 196: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy840, yymsp[0].minor.yy840, OP_TYPE_LIKE); }
        break;
      case 197: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy840, yymsp[0].minor.yy840, OP_TYPE_LIKE); }
        break;
      case 198: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy840, NULL, OP_TYPE_LIKE); }
        break;
      case 199: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 200: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 201: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 202: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy840, yymsp[-1].minor.yy840, OP_TYPE_EQUAL); }
        break;
      case 204: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 205: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 206: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 207: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW LICENCES */
      case 209: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==209);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 210: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy617); }
        break;
      case 211: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy840); }
        break;
      case 212: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy840); }
        break;
      case 213: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 215: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 216: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 217: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 218: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 219: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 220: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 221: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 222: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy840); }
        break;
      case 224: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy840, yymsp[-1].minor.yy840, OP_TYPE_EQUAL); }
        break;
      case 227: /* db_name_cond_opt ::= */
      case 232: /* from_db_opt ::= */ yytestcase(yyruleno==232);
{ yymsp[1].minor.yy840 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 228: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 229: /* like_pattern_opt ::= */
      case 268: /* into_opt ::= */ yytestcase(yyruleno==268);
      case 406: /* from_clause_opt ::= */ yytestcase(yyruleno==406);
      case 435: /* where_clause_opt ::= */ yytestcase(yyruleno==435);
      case 439: /* twindow_clause_opt ::= */ yytestcase(yyruleno==439);
      case 444: /* sliding_opt ::= */ yytestcase(yyruleno==444);
      case 446: /* fill_opt ::= */ yytestcase(yyruleno==446);
      case 458: /* having_clause_opt ::= */ yytestcase(yyruleno==458);
      case 460: /* range_opt ::= */ yytestcase(yyruleno==460);
      case 462: /* every_opt ::= */ yytestcase(yyruleno==462);
      case 472: /* slimit_clause_opt ::= */ yytestcase(yyruleno==472);
      case 476: /* limit_clause_opt ::= */ yytestcase(yyruleno==476);
{ yymsp[1].minor.yy840 = NULL; }
        break;
      case 230: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 231: /* table_name_cond ::= table_name */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy617); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 233: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy617); }
        break;
      case 234: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy313, yymsp[-3].minor.yy840, yymsp[-1].minor.yy840, NULL, yymsp[0].minor.yy840); }
        break;
      case 235: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy313, yymsp[0].minor.yy840); }
        break;
      case 236: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy840 = createIndexOption(pCxt, yymsp[-7].minor.yy544, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), NULL, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 237: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy840 = createIndexOption(pCxt, yymsp[-9].minor.yy544, releaseRawExprNode(pCxt, yymsp[-5].minor.yy840), releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 240: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy840 = createFunctionNode(pCxt, &yymsp[-3].minor.yy617, yymsp[-1].minor.yy544); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 241: /* sma_stream_opt ::= */
      case 270: /* stream_options ::= */ yytestcase(yyruleno==270);
{ yymsp[1].minor.yy840 = createStreamOptions(pCxt); }
        break;
      case 242: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 274: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==274);
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 243: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy313, &yymsp[-2].minor.yy617, yymsp[0].minor.yy840); }
        break;
      case 245: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy313, &yymsp[-3].minor.yy617, &yymsp[0].minor.yy617, false); }
        break;
      case 246: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy313, &yymsp[-5].minor.yy617, &yymsp[0].minor.yy617, true); }
        break;
      case 247: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy313, &yymsp[-3].minor.yy617, yymsp[0].minor.yy840, false); }
        break;
      case 248: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy313, &yymsp[-5].minor.yy617, yymsp[0].minor.yy840, true); }
        break;
      case 249: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 250: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy313, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617); }
        break;
      case 251: /* cmd ::= DESC full_table_name */
      case 252: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==252);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy840); }
        break;
      case 253: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 254: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy313, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 256: /* analyze_opt ::= ANALYZE */
      case 263: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==263);
      case 426: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==426);
{ yymsp[0].minor.yy313 = true; }
        break;
      case 257: /* explain_options ::= */
{ yymsp[1].minor.yy840 = createDefaultExplainOptions(pCxt); }
        break;
      case 258: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy840 = setExplainVerbose(pCxt, yymsp[-2].minor.yy840, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 259: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy840 = setExplainRatio(pCxt, yymsp[-2].minor.yy840, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 260: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy313, yymsp[-8].minor.yy313, &yymsp[-5].minor.yy617, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy784, yymsp[0].minor.yy844); }
        break;
      case 261: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 264: /* bufsize_opt ::= */
{ yymsp[1].minor.yy844 = 0; }
        break;
      case 265: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy844 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 266: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy313, &yymsp[-4].minor.yy617, yymsp[-2].minor.yy840, yymsp[-3].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 267: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy313, &yymsp[0].minor.yy617); }
        break;
      case 269: /* into_opt ::= INTO full_table_name */
      case 407: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==407);
      case 436: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==436);
      case 459: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==459);
{ yymsp[-1].minor.yy840 = yymsp[0].minor.yy840; }
        break;
      case 271: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 272: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy840)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy840 = yymsp[-2].minor.yy840; }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 273: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy840)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy840)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); yylhsminor.yy840 = yymsp[-3].minor.yy840; }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 275: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy840)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy840 = yymsp[-3].minor.yy840; }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 276: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 277: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 278: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 280: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 281: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy544); }
        break;
      case 282: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 283: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy544 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 285: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 287: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy840, yymsp[-2].minor.yy544, yymsp[0].minor.yy840); }
        break;
      case 288: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy840, NULL, yymsp[0].minor.yy840); }
        break;
      case 289: /* literal ::= NK_INTEGER */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 290: /* literal ::= NK_FLOAT */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 291: /* literal ::= NK_STRING */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 292: /* literal ::= NK_BOOL */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 293: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 294: /* literal ::= duration_literal */
      case 304: /* signed_literal ::= signed */ yytestcase(yyruleno==304);
      case 324: /* expression ::= literal */ yytestcase(yyruleno==324);
      case 325: /* expression ::= pseudo_column */ yytestcase(yyruleno==325);
      case 326: /* expression ::= column_reference */ yytestcase(yyruleno==326);
      case 327: /* expression ::= function_expression */ yytestcase(yyruleno==327);
      case 328: /* expression ::= subquery */ yytestcase(yyruleno==328);
      case 356: /* function_expression ::= literal_func */ yytestcase(yyruleno==356);
      case 398: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==398);
      case 402: /* boolean_primary ::= predicate */ yytestcase(yyruleno==402);
      case 404: /* common_expression ::= expression */ yytestcase(yyruleno==404);
      case 405: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==405);
      case 408: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==408);
      case 410: /* table_reference ::= table_primary */ yytestcase(yyruleno==410);
      case 411: /* table_reference ::= joined_table */ yytestcase(yyruleno==411);
      case 415: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==415);
      case 465: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==465);
      case 468: /* query_primary ::= query_specification */ yytestcase(yyruleno==468);
{ yylhsminor.yy840 = yymsp[0].minor.yy840; }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 295: /* literal ::= NULL */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 296: /* literal ::= NK_QUESTION */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 297: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 298: /* signed ::= NK_INTEGER */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 299: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 300: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 301: /* signed ::= NK_FLOAT */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 302: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 303: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 305: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 306: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 307: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 308: /* signed_literal ::= duration_literal */
      case 310: /* signed_literal ::= literal_func */ yytestcase(yyruleno==310);
      case 376: /* star_func_para ::= expression */ yytestcase(yyruleno==376);
      case 431: /* select_item ::= common_expression */ yytestcase(yyruleno==431);
      case 481: /* search_condition ::= common_expression */ yytestcase(yyruleno==481);
{ yylhsminor.yy840 = releaseRawExprNode(pCxt, yymsp[0].minor.yy840); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 309: /* signed_literal ::= NULL */
{ yylhsminor.yy840 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 311: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy840 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 329: /* expression ::= NK_LP expression NK_RP */
      case 403: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==403);
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 330: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy840));
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 331: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy840), NULL));
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 332: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 333: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 334: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 335: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 336: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 337: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 338: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 339: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 342: /* column_reference ::= column_name */
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy617, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy617)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 343: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617, createColumnNode(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy617)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 344: /* pseudo_column ::= ROWTS */
      case 345: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==345);
      case 347: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==347);
      case 348: /* pseudo_column ::= QEND */ yytestcase(yyruleno==348);
      case 349: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==349);
      case 350: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==350);
      case 351: /* pseudo_column ::= WEND */ yytestcase(yyruleno==351);
      case 352: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==352);
      case 358: /* literal_func ::= NOW */ yytestcase(yyruleno==358);
{ yylhsminor.yy840 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 346: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy617)))); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 353: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 354: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==354);
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy617, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy617, yymsp[-1].minor.yy544)); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 355: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), yymsp[-1].minor.yy784)); }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 357: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy617, NULL)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 372: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy544 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 377: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 434: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==434);
{ yylhsminor.yy840 = createColumnNode(pCxt, &yymsp[-2].minor.yy617, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 378: /* predicate ::= expression compare_op expression */
      case 383: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==383);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy198, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 379: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy840), releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-4].minor.yy840 = yylhsminor.yy840;
        break;
      case 380: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy840), releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 381: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), NULL));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 382: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), NULL));
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 384: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy198 = OP_TYPE_LOWER_THAN; }
        break;
      case 385: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy198 = OP_TYPE_GREATER_THAN; }
        break;
      case 386: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy198 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 387: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy198 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 388: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy198 = OP_TYPE_NOT_EQUAL; }
        break;
      case 389: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy198 = OP_TYPE_EQUAL; }
        break;
      case 390: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy198 = OP_TYPE_LIKE; }
        break;
      case 391: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy198 = OP_TYPE_NOT_LIKE; }
        break;
      case 392: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy198 = OP_TYPE_MATCH; }
        break;
      case 393: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy198 = OP_TYPE_NMATCH; }
        break;
      case 394: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy198 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 395: /* in_op ::= IN */
{ yymsp[0].minor.yy198 = OP_TYPE_IN; }
        break;
      case 396: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy198 = OP_TYPE_NOT_IN; }
        break;
      case 397: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy544)); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 399: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy840), NULL));
                                                                                  }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 400: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 401: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy840);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy840);
                                                                                    yylhsminor.yy840 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), releaseRawExprNode(pCxt, yymsp[0].minor.yy840)));
                                                                                  }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 409: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy840 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy840, yymsp[0].minor.yy840, NULL); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 412: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy840 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 413: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy840 = createRealTableNode(pCxt, &yymsp[-3].minor.yy617, &yymsp[-1].minor.yy617, &yymsp[0].minor.yy617); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 414: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy840 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840), &yymsp[0].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 416: /* alias_opt ::= */
{ yymsp[1].minor.yy617 = nil_token;  }
        break;
      case 417: /* alias_opt ::= table_alias */
{ yylhsminor.yy617 = yymsp[0].minor.yy617; }
  yymsp[0].minor.yy617 = yylhsminor.yy617;
        break;
      case 418: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy617 = yymsp[0].minor.yy617; }
        break;
      case 419: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 420: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==420);
{ yymsp[-2].minor.yy840 = yymsp[-1].minor.yy840; }
        break;
      case 421: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy840 = createJoinTableNode(pCxt, yymsp[-4].minor.yy708, yymsp[-5].minor.yy840, yymsp[-2].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-5].minor.yy840 = yylhsminor.yy840;
        break;
      case 422: /* join_type ::= */
{ yymsp[1].minor.yy708 = JOIN_TYPE_INNER; }
        break;
      case 423: /* join_type ::= INNER */
{ yymsp[0].minor.yy708 = JOIN_TYPE_INNER; }
        break;
      case 424: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy840 = createSelectStmt(pCxt, yymsp[-10].minor.yy313, yymsp[-9].minor.yy544, yymsp[-8].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addWhereClause(pCxt, yymsp[-11].minor.yy840, yymsp[-7].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addPartitionByClause(pCxt, yymsp[-11].minor.yy840, yymsp[-6].minor.yy544);
                                                                                    yymsp[-11].minor.yy840 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy840, yymsp[-2].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addGroupByClause(pCxt, yymsp[-11].minor.yy840, yymsp[-1].minor.yy544);
                                                                                    yymsp[-11].minor.yy840 = addHavingClause(pCxt, yymsp[-11].minor.yy840, yymsp[0].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addRangeClause(pCxt, yymsp[-11].minor.yy840, yymsp[-5].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addEveryClause(pCxt, yymsp[-11].minor.yy840, yymsp[-4].minor.yy840);
                                                                                    yymsp[-11].minor.yy840 = addFillClause(pCxt, yymsp[-11].minor.yy840, yymsp[-3].minor.yy840);
                                                                                  }
        break;
      case 427: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy313 = false; }
        break;
      case 430: /* select_item ::= NK_STAR */
{ yylhsminor.yy840 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy840 = yylhsminor.yy840;
        break;
      case 432: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy840 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840), &yymsp[0].minor.yy617); }
  yymsp[-1].minor.yy840 = yylhsminor.yy840;
        break;
      case 433: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy840 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), &yymsp[0].minor.yy617); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 438: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 455: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==455);
      case 471: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==471);
{ yymsp[-2].minor.yy544 = yymsp[0].minor.yy544; }
        break;
      case 440: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy840 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
        break;
      case 441: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy840 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
        break;
      case 442: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy840 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), NULL, yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 443: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy840 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy840), releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), yymsp[-1].minor.yy840, yymsp[0].minor.yy840); }
        break;
      case 445: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 463: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==463);
{ yymsp[-3].minor.yy840 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy840); }
        break;
      case 447: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy840 = createFillNode(pCxt, yymsp[-1].minor.yy816, NULL); }
        break;
      case 448: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy840 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy544)); }
        break;
      case 449: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy816 = FILL_MODE_NONE; }
        break;
      case 450: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy816 = FILL_MODE_PREV; }
        break;
      case 451: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy816 = FILL_MODE_NULL; }
        break;
      case 452: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy816 = FILL_MODE_LINEAR; }
        break;
      case 453: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy816 = FILL_MODE_NEXT; }
        break;
      case 456: /* group_by_list ::= expression */
{ yylhsminor.yy544 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); }
  yymsp[0].minor.yy544 = yylhsminor.yy544;
        break;
      case 457: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy544 = addNodeToList(pCxt, yymsp[-2].minor.yy544, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy840))); }
  yymsp[-2].minor.yy544 = yylhsminor.yy544;
        break;
      case 461: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy840 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy840), releaseRawExprNode(pCxt, yymsp[-1].minor.yy840)); }
        break;
      case 464: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy840 = addOrderByClause(pCxt, yymsp[-3].minor.yy840, yymsp[-2].minor.yy544);
                                                                                    yylhsminor.yy840 = addSlimitClause(pCxt, yylhsminor.yy840, yymsp[-1].minor.yy840);
                                                                                    yylhsminor.yy840 = addLimitClause(pCxt, yylhsminor.yy840, yymsp[0].minor.yy840);
                                                                                  }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 466: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy840 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-3].minor.yy840 = yylhsminor.yy840;
        break;
      case 467: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy840 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy840, yymsp[0].minor.yy840); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 469: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy840 = addOrderByClause(pCxt, yymsp[-4].minor.yy840, yymsp[-3].minor.yy544);
                                                                                    yymsp[-5].minor.yy840 = addSlimitClause(pCxt, yymsp[-5].minor.yy840, yymsp[-2].minor.yy840);
                                                                                    yymsp[-5].minor.yy840 = addLimitClause(pCxt, yymsp[-5].minor.yy840, yymsp[-1].minor.yy840);
                                                                                  }
        break;
      case 473: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 477: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==477);
{ yymsp[-1].minor.yy840 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 474: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 478: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==478);
{ yymsp[-3].minor.yy840 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 475: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 479: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==479);
{ yymsp[-3].minor.yy840 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 480: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy840 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy840); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 484: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy840 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy840), yymsp[-1].minor.yy204, yymsp[0].minor.yy277); }
  yymsp[-2].minor.yy840 = yylhsminor.yy840;
        break;
      case 485: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy204 = ORDER_ASC; }
        break;
      case 486: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy204 = ORDER_ASC; }
        break;
      case 487: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy204 = ORDER_DESC; }
        break;
      case 488: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy277 = NULL_ORDER_DEFAULT; }
        break;
      case 489: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy277 = NULL_ORDER_FIRST; }
        break;
      case 490: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy277 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
