/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 449
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  bool yy39;
  SToken yy181;
  EJoinType yy202;
  int32_t yy276;
  SNodeList* yy282;
  int8_t yy293;
  ENullOrder yy305;
  SDataType yy380;
  EFillMode yy381;
  SAlterOption yy645;
  EOperatorType yy682;
  SNode* yy778;
  int64_t yy831;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             696
#define YYNRULE              524
#define YYNTOKEN             317
#define YY_MAX_SHIFT         695
#define YY_MIN_SHIFTREDUCE   1029
#define YY_MAX_SHIFTREDUCE   1552
#define YY_ERROR_ACTION      1553
#define YY_ACCEPT_ACTION     1554
#define YY_NO_ACTION         1555
#define YY_MIN_REDUCE        1556
#define YY_MAX_REDUCE        2079
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2819)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1881,   34,  267, 1881,  157, 1062, 1568, 1895,   62,  534,
 /*    10 */  1698, 1877,   44,   42, 1877,  446,  334,  447, 1591, 1807,
 /*    20 */   349, 1877, 1333,   43,   41,   40,   39,   38,  588,  156,
 /*    30 */   167, 1554, 1358, 1413, 1660, 1331, 1913, 1873, 1879,  337,
 /*    40 */  1873, 1879,  343, 1746,  589, 1066, 1067, 1873, 1879, 1863,
 /*    50 */   595,  601,   30,  595,  445, 1579, 1408,  449,   37,   36,
 /*    60 */   595,   17,   43,   41,   40,   39,   38, 1895, 1339,   44,
 /*    70 */    42, 1483, 1893, 1578,  505,  588, 1929,  349,  573, 1333,
 /*    80 */    97, 1894, 1896,  605, 1898, 1899,  600,   77,  595,  515,
 /*    90 */  1413,  364, 1331,  168,    1, 1982, 1913, 1863,   58,  342,
 /*   100 */  1978,  125,   46,  218,  602,  585,   58, 2050,  530, 1863,
 /*   110 */  1702,  601,  173, 1408,  534, 1863,  692,  508,   17, 1577,
 /*   120 */  2008,  502,  572,  171, 1808, 1339,  217, 2051,  574, 1359,
 /*   130 */  1415, 1416,  603, 2055,  132,  585, 1929, 2050,  394, 1576,
 /*   140 */    98,  348, 1896,  605, 1898, 1899,  600,  454,  595,  447,
 /*   150 */  1591,    1, 2056,  171, 1079, 1982, 1078, 2051,  574,  314,
 /*   160 */  1978, 1863, 2050,   64,  132,    7,   63,   58, 1487,  482,
 /*   170 */  2050,  130,  335,  692, 1358, 1334,  310, 1332, 2054,  219,
 /*   180 */   154, 1863, 2051, 2053, 1080,  572,  171, 1415, 1416, 1709,
 /*   190 */  2051,  574,  587,  169, 1990, 1991, 1359, 1995,  463, 1337,
 /*   200 */  1338,  121, 1388, 1389, 1391, 1392, 1393, 1394, 1395, 1396,
 /*   210 */  1397, 1398,  597,  593, 1406, 1407, 1409, 1410, 1411, 1412,
 /*   220 */  1414, 1417,    3,  264, 1990,  584, 1684,  583, 1753, 1754,
 /*   230 */  2050, 1423, 1334,  383, 1332,   79,  312, 1358,  388,  537,
 /*   240 */   174, 1509,  496,  495,  174,  572,  171,  387,  174,  386,
 /*   250 */  2051,  574,  174,  385,  381,  530, 1337, 1338,   58, 1388,
 /*   260 */  1389, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398,  597,
 /*   270 */   593, 1406, 1407, 1409, 1410, 1411, 1412, 1414, 1417,    3,
 /*   280 */    44,   42,  695,  181, 2050,  233,  234, 1358,  349,   77,
 /*   290 */  1333,  560, 1507, 1508, 1510, 1511,  274,  547, 1895, 2056,
 /*   300 */   171, 1413,  547, 1331, 2051,  574, 1228, 1229, 2055,   52,
 /*   310 */   165, 1882, 1703,  174,  120,  685,  681,  677,  673,  272,
 /*   320 */    74,  484, 1877,   73, 1408,  220, 1707, 1913, 1737,   17,
 /*   330 */   354, 1707,  636, 1752, 1754,  602, 1339,   44,   42, 1079,
 /*   340 */  1863, 1078,  601,  312,  588,  349,  537, 1333, 1873, 1879,
 /*   350 */   563,  145,  144,  633,  632,  631,   95, 1390, 1413,  240,
 /*   360 */  1331,  595,    1,  603,  451, 1476,  547, 1929,  636, 1080,
 /*   370 */  1356,  294,  348, 1896,  605, 1898, 1899,  600,  120,  595,
 /*   380 */    47, 1408, 1557,  395,  692,  489,   17,  145,  144,  633,
 /*   390 */   632,  631,  544, 1339,  453, 1707,  396,  449, 1415, 1416,
 /*   400 */  1542, 2050, 1333,  110,  174,  431,  109,  108,  107,  106,
 /*   410 */   105,  104,  103,  102,  101, 1331,  572,  171,   46,    1,
 /*   420 */  1390, 2051,  574,  110,  229,  547,  109,  108,  107,  106,
 /*   430 */   105,  104,  103,  102,  101,  569,  564,  176,  500,  499,
 /*   440 */   498,  692, 1305, 1334,  222, 1332,  126,  494, 1339, 1575,
 /*   450 */   154,  493,  492, 1759, 1707, 1415, 1416,  491,  497, 1710,
 /*   460 */   336,  185,  184,  490, 1146, 1066, 1067, 1337, 1338, 1757,
 /*   470 */  1388, 1389, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398,
 /*   480 */   597,  593, 1406, 1407, 1409, 1410, 1411, 1412, 1414, 1417,
 /*   490 */     3, 1863,   11,   40,   39,   38,  692, 1148, 2002, 1476,
 /*   500 */  1334, 1621, 1332,  232,  568, 1444, 1186,  627,  626,  625,
 /*   510 */  1190,  624, 1192, 1193,  623, 1195,  620,  638, 1201,  617,
 /*   520 */  1203, 1204,  614,  611, 1337, 1338,  174, 1388, 1389, 1391,
 /*   530 */  1392, 1393, 1394, 1395, 1396, 1397, 1398,  597,  593, 1406,
 /*   540 */  1407, 1409, 1410, 1411, 1412, 1414, 1417,    3,   44,   42,
 /*   550 */  1800,  352, 1913, 2055, 1997, 1334,  349, 1332, 1333,  154,
 /*   560 */   567,  179, 1311, 1312,  500,  499,  498,  630, 1709, 1413,
 /*   570 */  1360, 1331,  126,  494,  547,   31,  227,  493,  492, 1337,
 /*   580 */  1338, 1895, 1994,  491,  497, 1449,  392, 1685, 1810,  490,
 /*   590 */    37,   36, 1408, 1357,   43,   41,   40,   39,   38,  566,
 /*   600 */  1895, 1759,  577, 1707, 1339,   44,   42, 1418,  353,  547,
 /*   610 */  1913,   48,    4,  349,   58, 1333,   81, 1757,  602,  547,
 /*   620 */    11,  393,    9, 1863,  355,  601, 1413, 1759, 1331, 1913,
 /*   630 */     8,  403,  154,  128,  319, 2055, 1953,  602, 1707,  547,
 /*   640 */  1574, 1709, 1863, 1757,  601, 1542, 1893,  463, 1707, 1408,
 /*   650 */  1929,  417,  692,  533,  158, 1894, 1896,  605, 1898, 1899,
 /*   660 */   600, 1339,  595, 1480, 2050, 1893, 1415, 1416, 1707, 1929,
 /*   670 */   530,  547,  573,   97, 1894, 1896,  605, 1898, 1899,  600,
 /*   680 */  2054,  595, 1863,  418, 2051, 2052, 2070,    8, 1982,  549,
 /*   690 */   514, 1954,  342, 1978, 1759,  552, 2019,  663,  661, 2050,
 /*   700 */  1707, 2050, 2016,  512, 1683,  510,  551,   11, 1954,  692,
 /*   710 */  1758, 1334,  266, 1332, 2056,  171,  572,  171, 1358, 2051,
 /*   720 */   574, 2051,  574, 1415, 1416,   37,   36,   13,   12,   43,
 /*   730 */    41,   40,   39,   38, 1850, 1337, 1338, 1361, 1388, 1389,
 /*   740 */  1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398,  597,  593,
 /*   750 */  1406, 1407, 1409, 1410, 1411, 1412, 1414, 1417,    3, 1556,
 /*   760 */   174, 1339, 1360, 1800,  638, 1806, 1800,  307, 1334,  651,
 /*   770 */  1332, 1677,   87,  325,  180,  650,  174,  183, 1573,  525,
 /*   780 */  1805,  371,  307,  119,  118,  117,  116,  115,  114,  113,
 /*   790 */   112,  111, 1337, 1338, 1700, 1388, 1389, 1391, 1392, 1393,
 /*   800 */  1394, 1395, 1396, 1397, 1398,  597,  593, 1406, 1407, 1409,
 /*   810 */  1410, 1411, 1412, 1414, 1417,    3,   44,   42,  578,  547,
 /*   820 */  1863, 1456,  634,  362,  349, 1750, 1333, 1997, 1997,  635,
 /*   830 */  1696,  461, 1750,  326, 1572,  324,  323, 1413,  486, 1331,
 /*   840 */   530,  361,  488,   94,  488, 1361,   37,   36, 1707, 1895,
 /*   850 */    43,   41,   40,   39,   38, 1993, 1992,  127,  530,  547,
 /*   860 */  1408, 1692, 2054,  547,  487, 1699,  487, 1571, 1895, 2050,
 /*   870 */   547,  462, 1339,   44,   42, 1704, 1863, 1694, 1913,  243,
 /*   880 */   143,  349,  137, 1333, 2056,  171,  602, 2050, 1707, 2051,
 /*   890 */   574, 1863, 1707,  601, 1413, 1690, 1331, 1913,    8, 1707,
 /*   900 */  1479, 1390, 2056,  171,  266,  602,  580, 2051,  574, 1863,
 /*   910 */  1863,  223,  601,  279, 1893, 1570, 1737, 1408, 1929,  547,
 /*   920 */   692, 1895,  159, 1894, 1896,  605, 1898, 1899,  600, 1339,
 /*   930 */   595,  526,   51, 1893, 1415, 1416, 1567, 1929, 1566,  547,
 /*   940 */  1608,   97, 1894, 1896,  605, 1898, 1899,  600, 1707,  595,
 /*   950 */  1913,  531,   50,  529, 2070,    1, 1982, 1863,  602,  547,
 /*   960 */   342, 1978,  501, 1863,  547,  601,  210,  596, 1707,  208,
 /*   970 */  2044,  237,  547,  629,  575, 2071,  543,  692, 1863, 1334,
 /*   980 */  1863, 1332, 1682,  592,  545, 1661, 1893,  242, 1707,  402,
 /*   990 */  1929, 1415, 1416, 1707,  159, 1894, 1896,  605, 1898, 1899,
 /*  1000 */   600, 1707,  595, 1337, 1338, 1549, 1388, 1389, 1391, 1392,
 /*  1010 */  1393, 1394, 1395, 1396, 1397, 1398,  597,  593, 1406, 1407,
 /*  1020 */  1409, 1410, 1411, 1412, 1414, 1417,    3,   37,   36,  205,
 /*  1030 */   547,   43,   41,   40,   39,   38, 1334,   72, 1332, 1551,
 /*  1040 */  1552,  212,  546,  161,  211, 1565, 2022, 2072,  480,  476,
 /*  1050 */   472,  468,  204, 1564,  214,   13,   12,  213, 1342, 1707,
 /*  1060 */  1337, 1338, 1618, 1388, 1389, 1391, 1392, 1393, 1394, 1395,
 /*  1070 */  1396, 1397, 1398,  597,  593, 1406, 1407, 1409, 1410, 1411,
 /*  1080 */  1412, 1414, 1417,    3,  309, 1569, 1356, 1863,  636,   78,
 /*  1090 */   226,  216,  202,  425,  215, 1863,  436, 1603,   37,   36,
 /*  1100 */  1548,  481,   43,   41,   40,   39,   38,  145,  144,  633,
 /*  1110 */   632,  631,  261,  410, 1519,  437,  576,  412, 1563,  503,
 /*  1120 */  1341, 1434, 1562, 1561,  581,  669,  668,  667,  666,  359,
 /*  1130 */    80,  665,  664,  133,  659,  658,  657,  656,  655,  654,
 /*  1140 */   653,  652,  147,  648,  647,  646,  358,  357,  643,  642,
 /*  1150 */   641,  640,  639,  155,  201,  195, 1560,  200,  285,  322,
 /*  1160 */  1863,  459,   37,   36, 1863, 1863,   43,   41,   40,   39,
 /*  1170 */    38,  398,  283,   66, 1601,   45,   65,  193,  255,  231,
 /*  1180 */   561,  138,  142, 1914, 1559, 1499,  143,  360,   60, 1592,
 /*  1190 */  1747,  247,  189,  442,  440, 1895,  506,   26, 1863,  435,
 /*  1200 */  1345,   60,  430,  429,  428,  427,  424,  423,  422,  421,
 /*  1210 */   420,  416,  415,  414,  413,  407,  406,  405,  404, 2012,
 /*  1220 */   400,  399,  321,  547, 1913,  263, 1863, 1282,   45,   58,
 /*  1230 */  1106,  235,  602,  540,  239,  268, 1597, 1863, 1179,  601,
 /*  1240 */  1506,   37,   36,  250,   32,   43,   41,   40,   39,   38,
 /*  1250 */    37,   36, 1707, 1450,   43,   41,   40,   39,   38,  260,
 /*  1260 */  1893,  586, 1344, 1107, 1929, 1884,  547,   96,   97, 1894,
 /*  1270 */  1896,  605, 1898, 1899,  600,    2,  595, 1895,  356,  129,
 /*  1280 */  1399,  141, 1953, 1982,  687,   37,   36,  342, 1978,   43,
 /*  1290 */    41,   40,   39,   38,  315, 1707,   45,  609,   93,    5,
 /*  1300 */   365,  518,   71,   70,  391,  370, 1913,  178,   90,  142,
 /*  1310 */  1298,  332,  143, 1886,  602,  644,  645,  122,  530, 1863,
 /*  1320 */   320,  601,  142,  275,  308,  182, 1356,  379, 1895,  377,
 /*  1330 */   373,  369,  366,  363,  397,  401, 1442, 1126, 1124,  419,
 /*  1340 */  1802,  426, 1893,  433,  585,  432, 1929, 2050,  278, 1207,
 /*  1350 */   301, 1894, 1896,  605, 1898, 1899,  600, 1913,  595,  434,
 /*  1360 */   585, 1211, 2056,  171, 1218,  589,  186, 2051,  574, 1216,
 /*  1370 */  1863,  439,  601,  132,  146,  174,  438,  441,  443, 1362,
 /*  1380 */   444,  452, 1364,  455,  192,  456, 1363,  194, 1365,  132,
 /*  1390 */  1443,  457,  458, 1893,  460,  197,  199, 1929,  464,   75,
 /*  1400 */    76,   97, 1894, 1896,  605, 1898, 1899,  600,  203,  595,
 /*  1410 */   130,  483,   99,  311,  168, 1841, 1982,  517,  485,  519,
 /*  1420 */   342, 1978, 1697,  207, 1693,  276,  130,  209,  148,  149,
 /*  1430 */  1695, 1691,  170, 1990, 1991,  150, 1995,  151,  221,  153,
 /*  1440 */   520, 2009,  521,  224,  527,  532, 1895,  524,  172, 1990,
 /*  1450 */  1991,  228, 1995,  331,  559,  535, 1840, 1812,  538,  139,
 /*  1460 */    33,  346, 1437, 1438, 1439, 1440, 1441, 1445, 1446, 1447,
 /*  1470 */  1448,  140,  333,  541,  542, 1913,   84,   86,  277, 1708,
 /*  1480 */  1361,  555,  562,  602, 2013, 2028,  245,  557, 1863,  558,
 /*  1490 */   601,  338, 2023,  565, 2027,  249,  571,    6,  553,  259,
 /*  1500 */   556,  162,  554, 2004,  339,  582,  579, 1476,  131, 2073,
 /*  1510 */  1360, 1893,   57, 1895,   88, 1929,  607, 1751, 1963,   97,
 /*  1520 */  1894, 1896,  605, 1898, 1899,  600, 1678,  595,  257,  254,
 /*  1530 */   256,  258, 2070, 1998, 1982, 1895,  280,  688,  342, 1978,
 /*  1540 */   271,  689, 1913,  691,   49, 2049,  306,  262, 2001,  292,
 /*  1550 */   602,  282,  303,  284,  302, 1863,   68,  601, 1857, 1856,
 /*  1560 */  1855, 1854,   69, 1851, 1913,  367,  368, 1325, 1326,  177,
 /*  1570 */   372, 1849,  602,  374,  375,  376, 1848, 1863, 1893,  601,
 /*  1580 */   378, 1847, 1929,  380, 1846, 1845,   97, 1894, 1896,  605,
 /*  1590 */  1898, 1899,  600, 1895,  595, 1823,  382,  384, 1301, 1957,
 /*  1600 */  1893, 1982, 1300, 1822, 1929,  342, 1978,  389,   97, 1894,
 /*  1610 */  1896,  605, 1898, 1899,  600, 1895,  595,  390, 1821,  345,
 /*  1620 */   344, 1955, 1913, 1982, 1820, 1270, 1795,  342, 1978, 1347,
 /*  1630 */   602, 1794, 1792,  134, 1791, 1863,  135,  601, 1790, 1793,
 /*  1640 */  1413, 1789, 1340, 1788, 1913, 1787, 1786, 1785, 1784,  409,
 /*  1650 */   408, 1783,  602,  411, 1782, 1781, 1780, 1863, 1893,  601,
 /*  1660 */  1779, 1778, 1929, 1408, 1777, 1776,   97, 1894, 1896,  605,
 /*  1670 */  1898, 1899,  600, 1775,  595, 1339, 1774, 1773, 1772,  550,
 /*  1680 */  1893, 1982, 1771, 1770, 1929,  342, 1978, 1154,   98, 1894,
 /*  1690 */  1896,  605, 1898, 1899,  600, 1769,  595, 1768, 1767,  136,
 /*  1700 */  1766, 1765, 1764, 1982, 1763, 1762, 1272, 1981, 1978, 1761,
 /*  1710 */  1760, 1623, 1622, 1620,  187,  188, 1588,  190,  123, 1587,
 /*  1720 */  1069, 1068, 1895,  591,  166,  124,  448, 1836,  191, 1830,
 /*  1730 */  1819,  450,  196,  198, 1818, 1804, 1686, 1619, 1617,  466,
 /*  1740 */  1615,  470,  467,  465, 1613, 1611,  474, 1600, 1599,  469,
 /*  1750 */  1584, 1913, 1099,  473,  471,  477,  475, 1688, 1222,  602,
 /*  1760 */  1687,  479, 1609, 1221, 1863,   59,  601,  206,  478,  660,
 /*  1770 */  1604, 1143, 1602,  504, 1145,  662, 1136, 1144, 1142, 1583,
 /*  1780 */  1582, 1141, 1348,  327, 1343,  328, 1138, 1893, 1137, 1581,
 /*  1790 */  1895, 1929,   53, 1135,  507,   98, 1894, 1896,  605, 1898,
 /*  1800 */  1899,  600, 1835,  595,  329,  513, 1351, 1353,  509, 1895,
 /*  1810 */  1982,  511,  100, 1307,  590, 1978, 1829,  522,  152, 1913,
 /*  1820 */   593, 1406, 1407, 1409, 1410, 1411, 1412,  599, 1317,  523,
 /*  1830 */   225, 1817, 1863, 1815,  601, 2055,  330, 1816, 1913, 1814,
 /*  1840 */  1813, 1315, 1811, 1803,   83,  241,  602,  230, 1425,   25,
 /*  1850 */    18, 1863,   19,  601,   10, 1893,  536,   20,  236, 1929,
 /*  1860 */   528,   15,   82,  300, 1894, 1896,  605, 1898, 1899,  600,
 /*  1870 */   598,  595,  548, 1947, 1893,   85, 1895,   56, 1929,   90,
 /*  1880 */    27,  244,   98, 1894, 1896,  605, 1898, 1899,  600, 1521,
 /*  1890 */   595,  539,  246, 1895,  248, 1424, 1503, 1982, 1505, 1498,
 /*  1900 */   252,  160, 1979,   29,  251, 1913,   28,  253, 1884,   89,
 /*  1910 */    61,   22,   21,  599, 1541, 1542, 1536, 1535, 1863,  340,
 /*  1920 */   601, 1540, 1913,  238, 1539,  341,  265,   12,   55,   54,
 /*  1930 */   602, 1473, 1349,   16, 1883, 1863, 1895,  601,  163, 1472,
 /*  1940 */  1932, 1893,  164, 1403,  594, 1929, 1401,   35,   14,  300,
 /*  1950 */  1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1893, 1948,
 /*  1960 */  1400,   23, 1929,  175, 1373, 1913,  158, 1894, 1896,  605,
 /*  1970 */  1898, 1899,  600,  602,  595, 1381, 1435,   24, 1863,  606,
 /*  1980 */   601,  608, 1208,  351,  612, 1913, 1205,  610,  613,  604,
 /*  1990 */   347,  615, 1202,  602,  616,  618, 1196,  619, 1863, 1194,
 /*  2000 */   601, 1893,  621,  622, 1185, 1929, 1217, 1895, 2020,  296,
 /*  2010 */  1894, 1896,  605, 1898, 1899,  600, 1200,  595,  628,  269,
 /*  2020 */  1199, 1893,   91, 1198, 1197, 1929,   92,   67, 1213,  301,
 /*  2030 */  1894, 1896,  605, 1898, 1899,  600, 1913,  595, 1132, 1097,
 /*  2040 */   637,  350, 1131, 1130,  602, 1129, 1128, 1127, 1125, 1863,
 /*  2050 */  1123,  601, 1122,  570, 1121, 1152,  649,  270, 1119, 1118,
 /*  2060 */  1117, 1116, 1115, 1114, 1113, 1112, 1149, 1147, 1109, 1108,
 /*  2070 */  1105, 1104, 1893, 1103, 1102, 1616, 1929,  670,  671, 1614,
 /*  2080 */   301, 1894, 1896,  605, 1898, 1899,  600, 1895,  595,  672,
 /*  2090 */   674,  675,  676, 1612,  678,  679,  680, 1610,  682,  683,
 /*  2100 */   684, 1598,  686, 1059, 1580, 1895,  273,  690, 1555, 1335,
 /*  2110 */   281,  693,  694, 1555, 1555, 1555, 1913, 1555, 1555, 1555,
 /*  2120 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2130 */  1555,  601, 1555, 1555, 1913, 1555, 1555, 1555, 1555, 1555,
 /*  2140 */  1555, 1555,  602, 1555, 1555, 1555, 1555, 1863, 1895,  601,
 /*  2150 */  1555, 1555,  516, 1555, 1555, 1555, 1929, 1555, 1555, 1555,
 /*  2160 */   294, 1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1555,
 /*  2170 */  1893, 1555, 1555, 1555, 1929, 1555, 1555, 1913,  286, 1894,
 /*  2180 */  1896,  605, 1898, 1899,  600,  602,  595, 1555, 1555, 1555,
 /*  2190 */  1863, 1895,  601, 1555, 1555, 1555, 1913, 1555, 1555, 1555,
 /*  2200 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2210 */  1555,  601, 1555, 1893, 1555, 1555, 1555, 1929, 1555, 1555,
 /*  2220 */  1913,  287, 1894, 1896,  605, 1898, 1899,  600,  602,  595,
 /*  2230 */  1555, 1555, 1893, 1863, 1895,  601, 1929, 1555, 1555, 1555,
 /*  2240 */   288, 1894, 1896,  605, 1898, 1899,  600, 1555,  595, 1555,
 /*  2250 */  1555, 1895, 1555, 1555, 1555, 1555, 1893, 1555, 1555, 1555,
 /*  2260 */  1929, 1555, 1555, 1913,  295, 1894, 1896,  605, 1898, 1899,
 /*  2270 */   600,  602,  595, 1555, 1555, 1555, 1863, 1895,  601, 1555,
 /*  2280 */  1913, 1555, 1555, 1555, 1555, 1555, 1555, 1555,  602, 1555,
 /*  2290 */  1555, 1555, 1555, 1863, 1895,  601, 1555, 1555, 1555, 1893,
 /*  2300 */  1555, 1555, 1555, 1929, 1555, 1555, 1913,  297, 1894, 1896,
 /*  2310 */   605, 1898, 1899,  600,  602,  595, 1893, 1555, 1555, 1863,
 /*  2320 */  1929,  601, 1555, 1913,  289, 1894, 1896,  605, 1898, 1899,
 /*  2330 */   600,  602,  595, 1555, 1555, 1555, 1863, 1555,  601, 1555,
 /*  2340 */  1555, 1555, 1893, 1555, 1555, 1555, 1929, 1555, 1555, 1555,
 /*  2350 */   298, 1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1893,
 /*  2360 */  1555, 1555, 1555, 1929, 1555, 1555, 1555,  290, 1894, 1896,
 /*  2370 */   605, 1898, 1899,  600, 1895,  595, 1555, 1555, 1555, 1555,
 /*  2380 */  1555, 1555, 1555, 1555, 1555, 1555, 1913, 1555, 1555, 1555,
 /*  2390 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2400 */  1555,  601, 1555, 1913, 1555, 1555, 1555, 1555, 1555, 1555,
 /*  2410 */  1555,  602, 1555, 1555, 1555, 1555, 1863, 1555,  601, 1555,
 /*  2420 */  1555, 1555, 1893, 1555, 1555, 1555, 1929, 1555, 1555, 1555,
 /*  2430 */   299, 1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1893,
 /*  2440 */  1555, 1555, 1555, 1929, 1555, 1555, 1555,  291, 1894, 1896,
 /*  2450 */   605, 1898, 1899,  600, 1555,  595, 1555, 1555, 1555, 1555,
 /*  2460 */  1555, 1555, 1555, 1895, 1555, 1555, 1913, 1555, 1555, 1555,
 /*  2470 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2480 */  1555,  601, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555,
 /*  2490 */  1555, 1555, 1913, 1555, 1555, 1555, 1555, 1555, 1555, 1555,
 /*  2500 */   602, 1555, 1893, 1555, 1555, 1863, 1929,  601, 1555, 1555,
 /*  2510 */   304, 1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1555,
 /*  2520 */  1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1893, 1555,
 /*  2530 */  1555, 1555, 1929, 1555, 1895, 1555,  305, 1894, 1896,  605,
 /*  2540 */  1898, 1899,  600, 1555,  595, 1555, 1913, 1555, 1555, 1555,
 /*  2550 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2560 */  1555,  601, 1555, 1913, 1555, 1555, 1555, 1555, 1555, 1555,
 /*  2570 */  1555,  602, 1555, 1555, 1555, 1555, 1863, 1895,  601, 1555,
 /*  2580 */  1555, 1555, 1893, 1555, 1555, 1555, 1929, 1555, 1555, 1555,
 /*  2590 */  1907, 1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1893,
 /*  2600 */  1555, 1555, 1555, 1929, 1555, 1555, 1913, 1906, 1894, 1896,
 /*  2610 */   605, 1898, 1899,  600,  602,  595, 1555, 1555, 1555, 1863,
 /*  2620 */  1555,  601, 1555, 1555, 1555, 1555, 1913, 1555, 1555, 1555,
 /*  2630 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2640 */  1895,  601, 1893, 1555, 1555, 1555, 1929, 1555, 1555, 1555,
 /*  2650 */  1905, 1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1555,
 /*  2660 */  1555, 1555, 1893, 1555, 1555, 1555, 1929, 1555, 1555, 1913,
 /*  2670 */   316, 1894, 1896,  605, 1898, 1899,  600,  602,  595, 1555,
 /*  2680 */  1555, 1555, 1863, 1555,  601, 1555, 1913, 1555, 1555, 1555,
 /*  2690 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2700 */  1555,  601, 1555, 1555, 1555, 1893, 1555, 1555, 1555, 1929,
 /*  2710 */  1555, 1555, 1555,  317, 1894, 1896,  605, 1898, 1899,  600,
 /*  2720 */  1895,  595, 1893, 1555, 1555, 1555, 1929, 1555, 1555, 1555,
 /*  2730 */   313, 1894, 1896,  605, 1898, 1899,  600, 1895,  595, 1555,
 /*  2740 */  1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1555, 1913,
 /*  2750 */  1555, 1555, 1555, 1555, 1555, 1555, 1555,  602, 1555, 1555,
 /*  2760 */  1555, 1555, 1863, 1555,  601, 1555, 1913, 1555, 1555, 1555,
 /*  2770 */  1555, 1555, 1555, 1555,  602, 1555, 1555, 1555, 1555, 1863,
 /*  2780 */  1555,  601, 1555, 1555, 1555, 1893, 1555, 1555, 1555, 1929,
 /*  2790 */  1555, 1555, 1555,  318, 1894, 1896,  605, 1898, 1899,  600,
 /*  2800 */  1555,  595, 1893, 1555, 1555, 1555, 1929, 1555, 1555, 1555,
 /*  2810 */   293, 1894, 1896,  605, 1898, 1899,  600, 1555,  595,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   351,  409,  410,  351,  319,    4,  321,  320,    4,  364,
 /*    10 */   351,  362,   12,   13,  362,  324,  371,  326,  327,  374,
 /*    20 */    20,  362,   22,   12,   13,   14,   15,   16,   20,  333,
 /*    30 */   348,  317,   20,   33,  338,   35,  349,  388,  389,  390,
 /*    40 */   388,  389,  390,  361,  357,   44,   45,  388,  389,  362,
 /*    50 */   401,  364,    2,  401,  325,  320,   56,  328,    8,    9,
 /*    60 */   401,   61,   12,   13,   14,   15,   16,  320,   68,   12,
 /*    70 */    13,   14,  385,  320,    4,   20,  389,   20,  394,   22,
 /*    80 */   393,  394,  395,  396,  397,  398,  399,  332,  401,   19,
 /*    90 */    33,  377,   35,  406,   94,  408,  349,  362,   94,  412,
 /*   100 */   413,  346,   94,   33,  357,  328,   94,  423,  394,  362,
 /*   110 */   355,  364,  425,   56,  364,  362,  116,   47,   61,  320,
 /*   120 */   433,   51,  438,  439,  374,   68,   56,  443,  444,   20,
 /*   130 */   130,  131,  385,  394,  357,  328,  389,  423,  328,  320,
 /*   140 */   393,  394,  395,  396,  397,  398,  399,  324,  401,  326,
 /*   150 */   327,   94,  438,  439,   20,  408,   22,  443,  444,  412,
 /*   160 */   413,  362,  423,   93,  357,   39,   96,   94,   14,   35,
 /*   170 */   423,  394,  341,  116,   20,  175,  366,  177,  439,  126,
 /*   180 */   349,  362,  443,  444,   50,  438,  439,  130,  131,  358,
 /*   190 */   443,  444,  415,  416,  417,  418,   20,  420,   60,  199,
 /*   200 */   200,  394,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  416,  417,  418,    0,  420,  363,  364,
 /*   230 */   423,   14,  175,  170,  177,  182,  183,   20,  377,  186,
 /*   240 */   240,  199,  335,  336,  240,  438,  439,  174,  240,  176,
 /*   250 */   443,  444,  240,  190,  191,  394,  199,  200,   94,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   280 */    12,   13,   19,   56,  423,  125,  126,   20,   20,  332,
 /*   290 */    22,  249,  250,  251,  252,  253,   33,  328,  320,  438,
 /*   300 */   439,   33,  328,   35,  443,  444,  130,  131,    3,  340,
 /*   310 */    47,  351,  355,  240,  340,   52,   53,   54,   55,   56,
 /*   320 */    93,  347,  362,   96,   56,  342,  357,  349,  345,   61,
 /*   330 */   360,  357,  106,  363,  364,  357,   68,   12,   13,   20,
 /*   340 */   362,   22,  364,  183,   20,   20,  186,   22,  388,  389,
 /*   350 */   160,  125,  126,  127,  128,  129,   93,  203,   33,   96,
 /*   360 */    35,  401,   94,  385,   14,  239,  328,  389,  106,   50,
 /*   370 */    20,  393,  394,  395,  396,  397,  398,  399,  340,  401,
 /*   380 */    94,   56,    0,   22,  116,  347,   61,  125,  126,  127,
 /*   390 */   128,  129,  129,   68,  325,  357,   35,  328,  130,  131,
 /*   400 */    95,  423,   22,   21,  240,   78,   24,   25,   26,   27,
 /*   410 */    28,   29,   30,   31,   32,   35,  438,  439,   94,   94,
 /*   420 */   203,  443,  444,   21,  161,  328,   24,   25,   26,   27,
 /*   430 */    28,   29,   30,   31,   32,  245,  246,  340,   63,   64,
 /*   440 */    65,  116,  179,  175,  181,  177,   71,   72,   68,  320,
 /*   450 */   349,   76,   77,  349,  357,  130,  131,   82,   83,  358,
 /*   460 */   356,  134,  135,   88,   35,   44,   45,  199,  200,  365,
 /*   470 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   490 */   222,  362,  224,   14,   15,   16,  116,   68,  238,  239,
 /*   500 */   175,    0,  177,  125,   20,  157,  107,  108,  109,  110,
 /*   510 */   111,  112,  113,  114,  115,  116,  117,   60,  119,  120,
 /*   520 */   121,  122,  123,  124,  199,  200,  240,  202,  203,  204,
 /*   530 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   540 */   215,  216,  217,  218,  219,  220,  221,  222,   12,   13,
 /*   550 */   357,  341,  349,    3,  391,  175,   20,  177,   22,  349,
 /*   560 */   357,  368,  184,  185,   63,   64,   65,  105,  358,   33,
 /*   570 */    20,   35,   71,   72,  328,  227,   56,   76,   77,  199,
 /*   580 */   200,  320,  419,   82,   83,  237,  340,    0,    0,   88,
 /*   590 */     8,    9,   56,   20,   12,   13,   14,   15,   16,  396,
 /*   600 */   320,  349,   43,  357,   68,   12,   13,   14,  356,  328,
 /*   610 */   349,   42,   43,   20,   94,   22,   96,  365,  357,  328,
 /*   620 */   224,  340,  226,  362,  341,  364,   33,  349,   35,  349,
 /*   630 */    94,  340,  349,  404,  356,  394,  407,  357,  357,  328,
 /*   640 */   320,  358,  362,  365,  364,   95,  385,   60,  357,   56,
 /*   650 */   389,  340,  116,  377,  393,  394,  395,  396,  397,  398,
 /*   660 */   399,   68,  401,    4,  423,  385,  130,  131,  357,  389,
 /*   670 */   394,  328,  394,  393,  394,  395,  396,  397,  398,  399,
 /*   680 */   439,  401,  362,  340,  443,  444,  406,   94,  408,  405,
 /*   690 */    21,  407,  412,  413,  349,  434,  435,  335,  336,  423,
 /*   700 */   357,  423,  422,   34,    0,   36,  405,  224,  407,  116,
 /*   710 */   365,  175,  162,  177,  438,  439,  438,  439,   20,  443,
 /*   720 */   444,  443,  444,  130,  131,    8,    9,    1,    2,   12,
 /*   730 */    13,   14,   15,   16,    0,  199,  200,   20,  202,  203,
 /*   740 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,  218,  219,  220,  221,  222,    0,
 /*   760 */   240,   68,   20,  357,   60,  373,  357,  375,  175,  337,
 /*   770 */   177,  339,  330,   37,  368,   68,  240,  368,  320,  381,
 /*   780 */   373,   47,  375,   24,   25,   26,   27,   28,   29,   30,
 /*   790 */    31,   32,  199,  200,  352,  202,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,  214,  215,  216,
 /*   810 */   217,  218,  219,  220,  221,  222,   12,   13,  259,  328,
 /*   820 */   362,   95,  359,  377,   20,  362,   22,  391,  391,  359,
 /*   830 */   350,  340,  362,   97,  320,   99,  100,   33,  102,   35,
 /*   840 */   394,  377,  106,  330,  106,   20,    8,    9,  357,  320,
 /*   850 */    12,   13,   14,   15,   16,  419,  419,  344,  394,  328,
 /*   860 */    56,  350,    3,  328,  128,  352,  128,  320,  320,  423,
 /*   870 */   328,  340,   68,   12,   13,  340,  362,  350,  349,  162,
 /*   880 */    43,   20,  340,   22,  438,  439,  357,  423,  357,  443,
 /*   890 */   444,  362,  357,  364,   33,  350,   35,  349,   94,  357,
 /*   900 */   241,  203,  438,  439,  162,  357,   43,  443,  444,  362,
 /*   910 */   362,  350,  364,  342,  385,  320,  345,   56,  389,  328,
 /*   920 */   116,  320,  393,  394,  395,  396,  397,  398,  399,   68,
 /*   930 */   401,  340,   95,  385,  130,  131,  320,  389,  320,  328,
 /*   940 */     0,  393,  394,  395,  396,  397,  398,  399,  357,  401,
 /*   950 */   349,  340,  162,  163,  406,   94,  408,  362,  357,  328,
 /*   960 */   412,  413,   22,  362,  328,  364,   98,  350,  357,  101,
 /*   970 */   422,  340,  328,  350,  445,  446,  340,  116,  362,  175,
 /*   980 */   362,  177,    0,   61,  340,  338,  385,  162,  357,  105,
 /*   990 */   389,  130,  131,  357,  393,  394,  395,  396,  397,  398,
 /*  1000 */   399,  357,  401,  199,  200,  167,  202,  203,  204,  205,
 /*  1010 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1020 */   216,  217,  218,  219,  220,  221,  222,    8,    9,   33,
 /*  1030 */   328,   12,   13,   14,   15,   16,  175,  153,  177,  130,
 /*  1040 */   131,   98,  340,   47,  101,  320,  392,  446,   52,   53,
 /*  1050 */    54,   55,   56,  320,   98,    1,    2,  101,   35,  357,
 /*  1060 */   199,  200,    0,  202,  203,  204,  205,  206,  207,  208,
 /*  1070 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*  1080 */   219,  220,  221,  222,   18,  321,   20,  362,  106,   93,
 /*  1090 */    56,   98,   96,   27,  101,  362,   30,    0,    8,    9,
 /*  1100 */   262,  329,   12,   13,   14,   15,   16,  125,  126,  127,
 /*  1110 */   128,  129,  447,   47,   95,   49,  257,   51,  320,   22,
 /*  1120 */    35,  199,  320,  320,  261,   63,   64,   65,   66,   67,
 /*  1130 */    96,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*  1140 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1150 */    88,   89,   90,   18,  158,  159,  320,  161,   23,   93,
 /*  1160 */   362,  165,    8,    9,  362,  362,   12,   13,   14,   15,
 /*  1170 */    16,  105,   37,   38,    0,   43,   41,  181,  430,   43,
 /*  1180 */   436,   43,   43,  349,  320,   95,   43,  329,   43,  327,
 /*  1190 */   361,   43,   57,   58,   59,  320,   22,   43,  362,  133,
 /*  1200 */   177,   43,  136,  137,  138,  139,  140,  141,  142,  143,
 /*  1210 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  392,
 /*  1220 */   154,  155,  156,  328,  349,  440,  362,   95,   43,   94,
 /*  1230 */    35,   95,  357,   95,   95,  340,    0,  362,   95,  364,
 /*  1240 */    95,    8,    9,   95,    2,   12,   13,   14,   15,   16,
 /*  1250 */     8,    9,  357,   95,   12,   13,   14,   15,   16,  414,
 /*  1260 */   385,  421,  177,   68,  389,   46,  328,  132,  393,  394,
 /*  1270 */   395,  396,  397,  398,  399,  424,  401,  320,  340,  404,
 /*  1280 */    95,  406,  407,  408,   48,    8,    9,  412,  413,   12,
 /*  1290 */    13,   14,   15,   16,   61,  357,   43,   43,   94,  242,
 /*  1300 */   387,  377,  167,  168,  169,   47,  349,  172,  104,   43,
 /*  1310 */   173,  354,   43,   94,  357,   13,   13,   43,  394,  362,
 /*  1320 */   386,  364,   43,  379,  189,   42,   20,  192,  320,  194,
 /*  1330 */   195,  196,  197,  198,  369,  369,  103,   35,   35,  328,
 /*  1340 */   328,  369,  385,  157,  328,  367,  389,  423,   95,   95,
 /*  1350 */   393,  394,  395,  396,  397,  398,  399,  349,  401,  367,
 /*  1360 */   328,   95,  438,  439,   95,  357,  328,  443,  444,   95,
 /*  1370 */   362,  334,  364,  357,   95,  240,   92,  328,  328,   20,
 /*  1380 */   322,  322,   20,  383,  332,  364,   20,  332,   20,  357,
 /*  1390 */   157,  376,  378,  385,  376,  332,  332,  389,  328,  332,
 /*  1400 */   332,  393,  394,  395,  396,  397,  398,  399,  332,  401,
 /*  1410 */   394,  322,  328,  322,  406,  362,  408,  188,  349,  384,
 /*  1420 */   412,  413,  349,  349,  349,  383,  394,  349,  349,  349,
 /*  1430 */   349,  349,  416,  417,  418,  349,  420,  349,  330,  162,
 /*  1440 */   180,  433,  382,  330,  328,  328,  320,  364,  416,  417,
 /*  1450 */   418,  330,  420,  376,  247,  362,  362,  362,  362,  372,
 /*  1460 */   227,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*  1470 */   237,  372,  362,  159,  370,  349,  330,  330,  345,  357,
 /*  1480 */    20,  362,  248,  357,  392,  429,  372,  362,  362,  362,
 /*  1490 */   364,  362,  392,  362,  429,  372,  166,  254,  243,  387,
 /*  1500 */   256,  429,  255,  432,  263,  260,  258,  239,  357,  448,
 /*  1510 */    20,  385,   94,  320,   94,  389,  353,  362,  411,  393,
 /*  1520 */   394,  395,  396,  397,  398,  399,  339,  401,  427,  431,
 /*  1530 */   428,  426,  406,  391,  408,  320,  328,   36,  412,  413,
 /*  1540 */   330,  323,  349,  322,  380,  442,  375,  441,  422,  343,
 /*  1550 */   357,  331,  343,  318,  343,  362,  182,  364,    0,    0,
 /*  1560 */     0,    0,   42,    0,  349,   35,  193,   35,   35,   35,
 /*  1570 */   193,    0,  357,   35,   35,  193,    0,  362,  385,  364,
 /*  1580 */   193,    0,  389,   35,    0,    0,  393,  394,  395,  396,
 /*  1590 */   397,  398,  399,  320,  401,    0,   22,   35,  177,  406,
 /*  1600 */   385,  408,  175,    0,  389,  412,  413,  171,  393,  394,
 /*  1610 */   395,  396,  397,  398,  399,  320,  401,  170,    0,   12,
 /*  1620 */    13,  406,  349,  408,    0,   46,    0,  412,  413,   22,
 /*  1630 */   357,    0,    0,   42,    0,  362,   42,  364,    0,    0,
 /*  1640 */    33,    0,   35,    0,  349,    0,    0,    0,    0,   35,
 /*  1650 */   148,    0,  357,  148,    0,    0,    0,  362,  385,  364,
 /*  1660 */     0,    0,  389,   56,    0,    0,  393,  394,  395,  396,
 /*  1670 */   397,  398,  399,    0,  401,   68,    0,    0,    0,  406,
 /*  1680 */   385,  408,    0,    0,  389,  412,  413,   35,  393,  394,
 /*  1690 */   395,  396,  397,  398,  399,    0,  401,    0,    0,   42,
 /*  1700 */     0,    0,    0,  408,    0,    0,   22,  412,  413,    0,
 /*  1710 */     0,    0,    0,    0,   56,   56,    0,   42,   39,    0,
 /*  1720 */    14,   14,  320,  116,   43,   39,   46,    0,   40,    0,
 /*  1730 */     0,   46,   39,  166,    0,    0,    0,    0,    0,   47,
 /*  1740 */     0,   47,   39,   35,    0,    0,   47,    0,    0,   35,
 /*  1750 */     0,  349,   62,   35,   39,   35,   39,    0,   35,  357,
 /*  1760 */     0,   39,    0,   22,  362,  103,  364,  101,   47,   43,
 /*  1770 */     0,   22,    0,   49,   35,   43,   22,   35,   35,    0,
 /*  1780 */     0,   35,  175,   22,  177,   22,   35,  385,   35,    0,
 /*  1790 */   320,  389,  162,   35,   35,  393,  394,  395,  396,  397,
 /*  1800 */   398,  399,    0,  401,   22,   22,  199,  200,   35,  320,
 /*  1810 */   408,   35,   20,   35,  412,  413,    0,   22,  178,  349,
 /*  1820 */   213,  214,  215,  216,  217,  218,  219,  357,   95,  162,
 /*  1830 */   159,    0,  362,    0,  364,    3,  162,    0,  349,    0,
 /*  1840 */     0,   35,    0,    0,   39,   46,  357,   95,  223,   94,
 /*  1850 */    94,  362,   43,  364,  225,  385,  187,   43,   94,  389,
 /*  1860 */   164,  244,   94,  393,  394,  395,  396,  397,  398,  399,
 /*  1870 */   400,  401,  402,  403,  385,   94,  320,   43,  389,  104,
 /*  1880 */    94,   94,  393,  394,  395,  396,  397,  398,  399,   95,
 /*  1890 */   401,  160,   95,  320,   94,  223,   95,  408,   95,   95,
 /*  1900 */    43,   94,  413,   43,   94,  349,   94,   46,   46,   94,
 /*  1910 */     3,   43,  244,  357,   95,   95,   35,   35,  362,   35,
 /*  1920 */   364,   35,  349,  158,   35,   35,   46,    2,   43,  238,
 /*  1930 */   357,   95,   22,  244,   46,  362,  320,  364,   46,   95,
 /*  1940 */    94,  385,   46,   95,   94,  389,   95,   94,   94,  393,
 /*  1950 */   394,  395,  396,  397,  398,  399,  320,  401,  385,  403,
 /*  1960 */    95,   94,  389,   46,   95,  349,  393,  394,  395,  396,
 /*  1970 */   397,  398,  399,  357,  401,   22,  199,   94,  362,  105,
 /*  1980 */   364,   35,   95,   35,   35,  349,   95,   94,   94,  201,
 /*  1990 */   354,   35,   95,  357,   94,   35,   95,   94,  362,   95,
 /*  2000 */   364,  385,   35,   94,   22,  389,   35,  320,  435,  393,
 /*  2010 */   394,  395,  396,  397,  398,  399,  118,  401,  106,   43,
 /*  2020 */   118,  385,   94,  118,  118,  389,   94,   94,   22,  393,
 /*  2030 */   394,  395,  396,  397,  398,  399,  349,  401,   35,   62,
 /*  2040 */    61,  354,   35,   35,  357,   35,   35,   35,   35,  362,
 /*  2050 */    35,  364,   35,  437,   35,   68,   91,   43,   35,   35,
 /*  2060 */    22,   35,   22,   35,   35,   35,   68,   35,   35,   35,
 /*  2070 */    35,   35,  385,   22,   35,    0,  389,   35,   47,    0,
 /*  2080 */   393,  394,  395,  396,  397,  398,  399,  320,  401,   39,
 /*  2090 */    35,   47,   39,    0,   35,   47,   39,    0,   35,   47,
 /*  2100 */    39,    0,   35,   35,    0,  320,   22,   21,  449,   22,
 /*  2110 */    22,   21,   20,  449,  449,  449,  349,  449,  449,  449,
 /*  2120 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2130 */   449,  364,  449,  449,  349,  449,  449,  449,  449,  449,
 /*  2140 */   449,  449,  357,  449,  449,  449,  449,  362,  320,  364,
 /*  2150 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2160 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2170 */   385,  449,  449,  449,  389,  449,  449,  349,  393,  394,
 /*  2180 */   395,  396,  397,  398,  399,  357,  401,  449,  449,  449,
 /*  2190 */   362,  320,  364,  449,  449,  449,  349,  449,  449,  449,
 /*  2200 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2210 */   449,  364,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2220 */   349,  393,  394,  395,  396,  397,  398,  399,  357,  401,
 /*  2230 */   449,  449,  385,  362,  320,  364,  389,  449,  449,  449,
 /*  2240 */   393,  394,  395,  396,  397,  398,  399,  449,  401,  449,
 /*  2250 */   449,  320,  449,  449,  449,  449,  385,  449,  449,  449,
 /*  2260 */   389,  449,  449,  349,  393,  394,  395,  396,  397,  398,
 /*  2270 */   399,  357,  401,  449,  449,  449,  362,  320,  364,  449,
 /*  2280 */   349,  449,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2290 */   449,  449,  449,  362,  320,  364,  449,  449,  449,  385,
 /*  2300 */   449,  449,  449,  389,  449,  449,  349,  393,  394,  395,
 /*  2310 */   396,  397,  398,  399,  357,  401,  385,  449,  449,  362,
 /*  2320 */   389,  364,  449,  349,  393,  394,  395,  396,  397,  398,
 /*  2330 */   399,  357,  401,  449,  449,  449,  362,  449,  364,  449,
 /*  2340 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2350 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2360 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2370 */   396,  397,  398,  399,  320,  401,  449,  449,  449,  449,
 /*  2380 */   449,  449,  449,  449,  449,  449,  349,  449,  449,  449,
 /*  2390 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2400 */   449,  364,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2410 */   449,  357,  449,  449,  449,  449,  362,  449,  364,  449,
 /*  2420 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2430 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2440 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2450 */   396,  397,  398,  399,  449,  401,  449,  449,  449,  449,
 /*  2460 */   449,  449,  449,  320,  449,  449,  349,  449,  449,  449,
 /*  2470 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2480 */   449,  364,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2490 */   449,  449,  349,  449,  449,  449,  449,  449,  449,  449,
 /*  2500 */   357,  449,  385,  449,  449,  362,  389,  364,  449,  449,
 /*  2510 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2520 */   449,  449,  449,  449,  449,  449,  449,  449,  385,  449,
 /*  2530 */   449,  449,  389,  449,  320,  449,  393,  394,  395,  396,
 /*  2540 */   397,  398,  399,  449,  401,  449,  349,  449,  449,  449,
 /*  2550 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2560 */   449,  364,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2570 */   449,  357,  449,  449,  449,  449,  362,  320,  364,  449,
 /*  2580 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2590 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2600 */   449,  449,  449,  389,  449,  449,  349,  393,  394,  395,
 /*  2610 */   396,  397,  398,  399,  357,  401,  449,  449,  449,  362,
 /*  2620 */   449,  364,  449,  449,  449,  449,  349,  449,  449,  449,
 /*  2630 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2640 */   320,  364,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2650 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2660 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  349,
 /*  2670 */   393,  394,  395,  396,  397,  398,  399,  357,  401,  449,
 /*  2680 */   449,  449,  362,  449,  364,  449,  349,  449,  449,  449,
 /*  2690 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2700 */   449,  364,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2710 */   449,  449,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2720 */   320,  401,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2730 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2740 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  349,
 /*  2750 */   449,  449,  449,  449,  449,  449,  449,  357,  449,  449,
 /*  2760 */   449,  449,  362,  449,  364,  449,  349,  449,  449,  449,
 /*  2770 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2780 */   449,  364,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2790 */   449,  449,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2800 */   449,  401,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2810 */   393,  394,  395,  396,  397,  398,  399,  449,  401,
};
#define YY_SHIFT_COUNT    (695)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2104)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1135,    0,   57,  268,   57,  325,  325,  325,  536,  325,
 /*    10 */   325,  325,  325,  325,  593,  804,  804,  861,  804,  804,
 /*    20 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    30 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    40 */   804,  804,  804,  804,  804,  804,    8,   12,  324,   73,
 /*    50 */   520,  164,  286,  164,  324,  324, 1607, 1607,  164, 1607,
 /*    60 */  1607,    4,  164,   55,   55,    1,    1,  176,   55,   55,
 /*    70 */    55,   55,   55,   55,   55,   55,   55,   55,  138,   55,
 /*    80 */    55,   55,  109,   55,   55,  267,   55,   55,  267,  484,
 /*    90 */    55,  267,  267,  267,   55,  457, 1066, 1233, 1233,  375,
 /*   100 */   402,  380,  380,  380,  380,  380,  380,  380,  380,  380,
 /*   110 */   380,  380,  380,  380,  380,  380,  380,  380,  380,  380,
 /*   120 */   736,  550,  176,  350,  350,  587,  429,  704,  396,  396,
 /*   130 */   742,  742,  742,  429,  573,  573,  573,  462,  109,  588,
 /*   140 */   588,  483,  267,  267,  693,  693,  462,  707,  399,  399,
 /*   150 */   399,  399,  399,  399,  399,  263,  501,  382,  717,  838,
 /*   160 */    42,  134,  190,  154,  217,  319,  421,  738,  825,  260,
 /*   170 */   126,  859,  260,  569,  659,  698, 1057, 1258, 1137, 1283,
 /*   180 */  1283, 1306, 1306, 1283, 1186, 1186, 1284, 1306, 1306, 1306,
 /*   190 */  1359, 1359, 1362,  138,  109,  138, 1366, 1368,  138, 1366,
 /*   200 */   138,  138,  138, 1306,  138, 1359,  267,  267,  267,  267,
 /*   210 */   267,  267,  267,  267,  267,  267,  267, 1306, 1359,  693,
 /*   220 */  1229, 1362,  457, 1260,  109,  457, 1306, 1306, 1366,  457,
 /*   230 */  1207,  693,  693,  693,  693, 1207,  693, 1314,  457,  462,
 /*   240 */   457,  573, 1460, 1460,  693, 1234, 1207,  693,  693, 1234,
 /*   250 */  1207,  693,  693,  267, 1243, 1330, 1234, 1244, 1247, 1255,
 /*   260 */  1057, 1241, 1245, 1248, 1268,  573, 1490, 1418, 1420,  693,
 /*   270 */   707, 1306,  457, 1501, 1359, 2819, 2819, 2819, 2819, 2819,
 /*   280 */  2819, 2819, 1062,  996,  759,   70, 1019, 1154, 1090,   50,
 /*   290 */  1242, 1277,  226,  582,  582,  582,  582,  582,  582,  582,
 /*   300 */   582,  582,  982,  262,   11,   11,   53,  160,   63,  227,
 /*   310 */   327,  669,  378,  479,  726,  348,  479,  479,  479,  837,
 /*   320 */   734,  361,  884,  868,  943,  956,  993,  940, 1097, 1174,
 /*   330 */  1034,  790, 1132, 1136, 1138, 1139, 1143, 1145, 1148,  909,
 /*   340 */   559,  863, 1054, 1158, 1023, 1085,  922, 1185,  305, 1219,
 /*   350 */  1253, 1254, 1266, 1269, 1274, 1279, 1204, 1302, 1303, 1195,
 /*   360 */  1236, 1558, 1559, 1374, 1560, 1561, 1520, 1563, 1530, 1373,
 /*   370 */  1532, 1533, 1534, 1377, 1571, 1538, 1539, 1382, 1576, 1387,
 /*   380 */  1581, 1548, 1584, 1574, 1585, 1562, 1421, 1427, 1595, 1603,
 /*   390 */  1436, 1447, 1618, 1624, 1579, 1626, 1631, 1632, 1591, 1634,
 /*   400 */  1638, 1639, 1594, 1641, 1643, 1645, 1646, 1647, 1648, 1502,
 /*   410 */  1614, 1651, 1505, 1654, 1655, 1656, 1660, 1661, 1664, 1665,
 /*   420 */  1673, 1676, 1677, 1678, 1682, 1683, 1695, 1657, 1697, 1698,
 /*   430 */  1700, 1701, 1702, 1684, 1704, 1705, 1709, 1710, 1652, 1711,
 /*   440 */  1658, 1712, 1659, 1713, 1716, 1675, 1679, 1681, 1706, 1680,
 /*   450 */  1707, 1685, 1719, 1688, 1686, 1727, 1729, 1730, 1693, 1567,
 /*   460 */  1734, 1735, 1736, 1690, 1737, 1738, 1708, 1692, 1703, 1740,
 /*   470 */  1714, 1694, 1715, 1744, 1718, 1699, 1717, 1745, 1720, 1721,
 /*   480 */  1722, 1747, 1748, 1750, 1757, 1662, 1666, 1723, 1741, 1760,
 /*   490 */  1739, 1742, 1749, 1743, 1746, 1726, 1732, 1751, 1753, 1754,
 /*   500 */  1758, 1762, 1761, 1770, 1763, 1724, 1772, 1782, 1759, 1779,
 /*   510 */  1773, 1780, 1776, 1789, 1783, 1792, 1733, 1755, 1802, 1630,
 /*   520 */  1778, 1816, 1640, 1795, 1667, 1671, 1831, 1833, 1674, 1696,
 /*   530 */  1832, 1837, 1839, 1840, 1756, 1752, 1806, 1669, 1842, 1764,
 /*   540 */  1731, 1768, 1843, 1805, 1765, 1781, 1775, 1799, 1809, 1625,
 /*   550 */  1629, 1672, 1814, 1617, 1786, 1794, 1787, 1797, 1801, 1800,
 /*   560 */  1834, 1803, 1807, 1810, 1812, 1804, 1857, 1861, 1862, 1815,
 /*   570 */  1860, 1668, 1819, 1820, 1907, 1868, 1689, 1881, 1882, 1884,
 /*   580 */  1886, 1889, 1890, 1836, 1844, 1880, 1691, 1885, 1888, 1892,
 /*   590 */  1925, 1910, 1777, 1846, 1848, 1850, 1851, 1853, 1865, 1896,
 /*   600 */  1854, 1867, 1917, 1869, 1953, 1788, 1883, 1874, 1887, 1946,
 /*   610 */  1948, 1893, 1891, 1949, 1894, 1897, 1956, 1900, 1901, 1960,
 /*   620 */  1903, 1904, 1967, 1909, 1898, 1902, 1905, 1906, 1982, 1912,
 /*   630 */  1928, 1932, 1971, 1933, 1976, 1976, 2006, 1977, 1979, 2003,
 /*   640 */  2007, 2008, 2010, 2011, 2012, 2013, 2015, 2017, 2019, 1987,
 /*   650 */  1965, 2014, 2023, 2024, 2038, 2026, 2040, 2028, 2029, 2030,
 /*   660 */  1998, 1726, 2032, 1732, 2033, 2034, 2035, 2036, 2051, 2039,
 /*   670 */  2075, 2042, 2031, 2050, 2079, 2055, 2044, 2053, 2093, 2059,
 /*   680 */  2048, 2057, 2097, 2063, 2052, 2061, 2101, 2067, 2068, 2104,
 /*   690 */  2084, 2086, 2087, 2088, 2090, 2092,
};
#define YY_REDUCE_COUNT (281)
#define YY_REDUCE_MIN   (-408)
#define YY_REDUCE_MAX   (2417)
static const short yy_reduce_ofst[] = {
 /*     0 */  -286, -253, -313,  875, 1008,  280,  548, 1126,  -22, 1193,
 /*    10 */  1215, 1273, 1295, 1402, 1470,  261,  529, 1489,  957, 1556,
 /*    20 */  1573, 1616,  601, 1636, 1687, 1767, 1785, 1828, 1847, 1871,
 /*    30 */  1914, 1931, 1957, 1974, 2037, 2054, 2117, 2143, 2197, 2214,
 /*    40 */  2257, 2277, 2320, 2337, 2400, 2417, -193,  278, -223, -139,
 /*    50 */   276,  446,  464,  924, 1016, 1032, -351, -348, -316, -341,
 /*    60 */   -40, -261,  241,  -26,   38, -309, -177,  -30,  -31,   97,
 /*    70 */   246,  281,  291,  311,  343,  491,  531,  535, -245,  542,
 /*    80 */   591,  611, -355,  631,  636, -169,  644,  702,  104,  203,
 /*    90 */   895,  210,  252,  283,  938,  513, -190, -408, -408, -304,
 /*   100 */  -315, -265, -247, -201, -181,  129,  320,  458,  514,  547,
 /*   110 */   595,  616,  618,  725,  733,  798,  802,  803,  836,  864,
 /*   120 */  -318,  163, -135, -271,   69,  -43,  -93,  442,  284,  301,
 /*   130 */   163,  436,  437,  362,  193,  406,  409,  -17, -250,  392,
 /*   140 */   407,  229,  101,  345,  463,  470,  571,  432,  480,  511,
 /*   150 */   527,  545,  561,  617,  623,  398,  647,  764,  654,  665,
 /*   160 */   744,  772,  748,  834,  834,  858,  862,  829,  827,  840,
 /*   170 */   840,  785,  840,  845,  851,  834,  913,  934,  944,  965,
 /*   180 */   966, 1011, 1012,  972,  978,  992, 1037, 1038, 1049, 1050,
 /*   190 */  1058, 1059, 1000, 1052, 1021, 1055, 1015, 1014, 1063, 1018,
 /*   200 */  1064, 1067, 1068, 1070, 1076, 1089, 1069, 1073, 1074, 1075,
 /*   210 */  1078, 1079, 1080, 1081, 1082, 1086, 1088, 1084, 1091, 1053,
 /*   220 */  1035, 1042, 1108, 1060, 1083, 1113, 1116, 1117, 1077, 1121,
 /*   230 */  1087, 1093, 1094, 1095, 1096, 1099, 1110, 1104, 1146, 1133,
 /*   240 */  1147, 1122, 1092, 1100, 1119, 1056, 1114, 1125, 1127, 1065,
 /*   250 */  1123, 1129, 1131,  834, 1071, 1098, 1072, 1102, 1101, 1105,
 /*   260 */  1112, 1061, 1103, 1106,  840, 1151, 1142, 1107, 1163, 1155,
 /*   270 */  1187, 1208, 1210, 1218, 1221, 1164, 1171, 1206, 1209, 1211,
 /*   280 */  1220, 1235,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    10 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    20 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    30 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    40 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    50 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    60 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    70 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1627, 1553,
 /*    80 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*    90 */  1553, 1553, 1553, 1553, 1553, 1625, 1796, 1984, 1553, 1553,
 /*   100 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   110 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   120 */  1553, 1996, 1553, 1553, 1553, 1627, 1553, 1625, 1956, 1956,
 /*   130 */  1996, 1996, 1996, 1553, 1553, 1553, 1553, 1736, 1553, 1837,
 /*   140 */  1837, 1553, 1553, 1553, 1553, 1553, 1736, 1553, 1553, 1553,
 /*   150 */  1553, 1553, 1553, 1553, 1553, 1831, 1553, 1553, 2021, 2074,
 /*   160 */  1553, 1553, 2024, 1553, 1553, 1553, 1553, 1689, 2011, 1988,
 /*   170 */  2002, 2058, 1989, 1986, 2005, 1553, 2015, 1553, 1824, 1801,
 /*   180 */  1801, 1553, 1553, 1801, 1798, 1798, 1680, 1553, 1553, 1553,
 /*   190 */  1553, 1553, 1553, 1627, 1553, 1627, 1553, 1553, 1627, 1553,
 /*   200 */  1627, 1627, 1627, 1553, 1627, 1553, 1553, 1553, 1553, 1553,
 /*   210 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   220 */  1843, 1553, 1625, 1833, 1553, 1625, 1553, 1553, 1553, 1625,
 /*   230 */  2029, 1553, 1553, 1553, 1553, 2029, 1553, 1553, 1625, 1553,
 /*   240 */  1625, 1553, 1553, 1553, 1553, 2031, 2029, 1553, 1553, 2031,
 /*   250 */  2029, 1553, 1553, 1553, 2043, 2039, 2031, 2047, 2045, 2017,
 /*   260 */  2015, 2077, 2064, 2060, 2002, 1553, 1553, 1553, 1705, 1553,
 /*   270 */  1553, 1553, 1625, 1585, 1553, 1826, 1837, 1739, 1739, 1739,
 /*   280 */  1628, 1558, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   290 */  1553, 1553, 1553, 1912, 1553, 2042, 2041, 1960, 1959, 1958,
 /*   300 */  1949, 1911, 1553, 1701, 1910, 1909, 1553, 1553, 1553, 1553,
 /*   310 */  1553, 1553, 1553, 1903, 1553, 1553, 1904, 1902, 1901, 1553,
 /*   320 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   330 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   340 */  2061, 2065, 1985, 1553, 1553, 1553, 1553, 1553, 1894, 1885,
 /*   350 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   360 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   370 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   380 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   390 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   400 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   410 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   420 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   430 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   440 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1590, 1553, 1553,
 /*   450 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   460 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   470 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   480 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   490 */  1553, 1553, 1553, 1553, 1553, 1667, 1666, 1553, 1553, 1553,
 /*   500 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   510 */  1553, 1553, 1553, 1553, 1553, 1553, 1893, 1553, 1553, 1553,
 /*   520 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   530 */  2057, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1841, 1553,
 /*   540 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1946, 1553,
 /*   550 */  1553, 1553, 2018, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   560 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1885, 1553,
 /*   570 */  2040, 1553, 1553, 2055, 1553, 2059, 1553, 1553, 1553, 1553,
 /*   580 */  1553, 1553, 1553, 1995, 1991, 1553, 1553, 1987, 1884, 1553,
 /*   590 */  1980, 1553, 1553, 1931, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   600 */  1553, 1553, 1553, 1893, 1553, 1897, 1553, 1553, 1553, 1553,
 /*   610 */  1553, 1733, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   620 */  1553, 1553, 1553, 1553, 1718, 1716, 1715, 1714, 1553, 1711,
 /*   630 */  1553, 1553, 1553, 1553, 1742, 1741, 1553, 1553, 1553, 1553,
 /*   640 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   650 */  1553, 1647, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   660 */  1553, 1638, 1553, 1637, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   670 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   680 */  1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553, 1553,
 /*   690 */  1553, 1553, 1553, 1553, 1553, 1553,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  264,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  264,  /*      AFTER => ABORT */
  264,  /*     ATTACH => ABORT */
  264,  /*     BEFORE => ABORT */
  264,  /*      BEGIN => ABORT */
  264,  /*     BITAND => ABORT */
  264,  /*     BITNOT => ABORT */
  264,  /*      BITOR => ABORT */
  264,  /*     BLOCKS => ABORT */
  264,  /*     CHANGE => ABORT */
  264,  /*      COMMA => ABORT */
  264,  /*    COMPACT => ABORT */
  264,  /*     CONCAT => ABORT */
  264,  /*   CONFLICT => ABORT */
  264,  /*       COPY => ABORT */
  264,  /*   DEFERRED => ABORT */
  264,  /* DELIMITERS => ABORT */
  264,  /*     DETACH => ABORT */
  264,  /*     DIVIDE => ABORT */
  264,  /*        DOT => ABORT */
  264,  /*       EACH => ABORT */
  264,  /*       FAIL => ABORT */
  264,  /*       FILE => ABORT */
  264,  /*        FOR => ABORT */
  264,  /*       GLOB => ABORT */
  264,  /*         ID => ABORT */
  264,  /*  IMMEDIATE => ABORT */
  264,  /*     IMPORT => ABORT */
  264,  /*  INITIALLY => ABORT */
  264,  /*    INSTEAD => ABORT */
  264,  /*     ISNULL => ABORT */
  264,  /*        KEY => ABORT */
  264,  /*    MODULES => ABORT */
  264,  /*  NK_BITNOT => ABORT */
  264,  /*    NK_SEMI => ABORT */
  264,  /*    NOTNULL => ABORT */
  264,  /*         OF => ABORT */
  264,  /*       PLUS => ABORT */
  264,  /*  PRIVILEGE => ABORT */
  264,  /*      RAISE => ABORT */
  264,  /*    REPLACE => ABORT */
  264,  /*   RESTRICT => ABORT */
  264,  /*        ROW => ABORT */
  264,  /*       SEMI => ABORT */
  264,  /*       STAR => ABORT */
  264,  /*  STATEMENT => ABORT */
  264,  /*     STRING => ABORT */
  264,  /*      TIMES => ABORT */
  264,  /*     UPDATE => ABORT */
  264,  /*     VALUES => ABORT */
  264,  /*   VARIABLE => ABORT */
  264,  /*       VIEW => ABORT */
  264,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "QNODES",
  /*  138 */ "FUNCTIONS",
  /*  139 */ "INDEXES",
  /*  140 */ "ACCOUNTS",
  /*  141 */ "APPS",
  /*  142 */ "CONNECTIONS",
  /*  143 */ "LICENCES",
  /*  144 */ "GRANTS",
  /*  145 */ "QUERIES",
  /*  146 */ "SCORES",
  /*  147 */ "TOPICS",
  /*  148 */ "VARIABLES",
  /*  149 */ "BNODES",
  /*  150 */ "SNODES",
  /*  151 */ "CLUSTER",
  /*  152 */ "TRANSACTIONS",
  /*  153 */ "DISTRIBUTED",
  /*  154 */ "CONSUMERS",
  /*  155 */ "SUBSCRIPTIONS",
  /*  156 */ "VNODES",
  /*  157 */ "LIKE",
  /*  158 */ "INDEX",
  /*  159 */ "FUNCTION",
  /*  160 */ "INTERVAL",
  /*  161 */ "TOPIC",
  /*  162 */ "AS",
  /*  163 */ "WITH",
  /*  164 */ "META",
  /*  165 */ "CONSUMER",
  /*  166 */ "GROUP",
  /*  167 */ "DESC",
  /*  168 */ "DESCRIBE",
  /*  169 */ "RESET",
  /*  170 */ "QUERY",
  /*  171 */ "CACHE",
  /*  172 */ "EXPLAIN",
  /*  173 */ "ANALYZE",
  /*  174 */ "VERBOSE",
  /*  175 */ "NK_BOOL",
  /*  176 */ "RATIO",
  /*  177 */ "NK_FLOAT",
  /*  178 */ "OUTPUTTYPE",
  /*  179 */ "AGGREGATE",
  /*  180 */ "BUFSIZE",
  /*  181 */ "STREAM",
  /*  182 */ "INTO",
  /*  183 */ "TRIGGER",
  /*  184 */ "AT_ONCE",
  /*  185 */ "WINDOW_CLOSE",
  /*  186 */ "IGNORE",
  /*  187 */ "EXPIRED",
  /*  188 */ "SUBTABLE",
  /*  189 */ "KILL",
  /*  190 */ "CONNECTION",
  /*  191 */ "TRANSACTION",
  /*  192 */ "BALANCE",
  /*  193 */ "VGROUP",
  /*  194 */ "MERGE",
  /*  195 */ "REDISTRIBUTE",
  /*  196 */ "SPLIT",
  /*  197 */ "DELETE",
  /*  198 */ "INSERT",
  /*  199 */ "NULL",
  /*  200 */ "NK_QUESTION",
  /*  201 */ "NK_ARROW",
  /*  202 */ "ROWTS",
  /*  203 */ "TBNAME",
  /*  204 */ "QSTART",
  /*  205 */ "QEND",
  /*  206 */ "QDURATION",
  /*  207 */ "WSTART",
  /*  208 */ "WEND",
  /*  209 */ "WDURATION",
  /*  210 */ "IROWTS",
  /*  211 */ "QTAGS",
  /*  212 */ "CAST",
  /*  213 */ "NOW",
  /*  214 */ "TODAY",
  /*  215 */ "TIMEZONE",
  /*  216 */ "CLIENT_VERSION",
  /*  217 */ "SERVER_VERSION",
  /*  218 */ "SERVER_STATUS",
  /*  219 */ "CURRENT_USER",
  /*  220 */ "COUNT",
  /*  221 */ "LAST_ROW",
  /*  222 */ "CASE",
  /*  223 */ "END",
  /*  224 */ "WHEN",
  /*  225 */ "THEN",
  /*  226 */ "ELSE",
  /*  227 */ "BETWEEN",
  /*  228 */ "IS",
  /*  229 */ "NK_LT",
  /*  230 */ "NK_GT",
  /*  231 */ "NK_LE",
  /*  232 */ "NK_GE",
  /*  233 */ "NK_NE",
  /*  234 */ "MATCH",
  /*  235 */ "NMATCH",
  /*  236 */ "CONTAINS",
  /*  237 */ "IN",
  /*  238 */ "JOIN",
  /*  239 */ "INNER",
  /*  240 */ "SELECT",
  /*  241 */ "DISTINCT",
  /*  242 */ "WHERE",
  /*  243 */ "PARTITION",
  /*  244 */ "BY",
  /*  245 */ "SESSION",
  /*  246 */ "STATE_WINDOW",
  /*  247 */ "SLIDING",
  /*  248 */ "FILL",
  /*  249 */ "VALUE",
  /*  250 */ "NONE",
  /*  251 */ "PREV",
  /*  252 */ "LINEAR",
  /*  253 */ "NEXT",
  /*  254 */ "HAVING",
  /*  255 */ "RANGE",
  /*  256 */ "EVERY",
  /*  257 */ "ORDER",
  /*  258 */ "SLIMIT",
  /*  259 */ "SOFFSET",
  /*  260 */ "LIMIT",
  /*  261 */ "OFFSET",
  /*  262 */ "ASC",
  /*  263 */ "NULLS",
  /*  264 */ "ABORT",
  /*  265 */ "AFTER",
  /*  266 */ "ATTACH",
  /*  267 */ "BEFORE",
  /*  268 */ "BEGIN",
  /*  269 */ "BITAND",
  /*  270 */ "BITNOT",
  /*  271 */ "BITOR",
  /*  272 */ "BLOCKS",
  /*  273 */ "CHANGE",
  /*  274 */ "COMMA",
  /*  275 */ "COMPACT",
  /*  276 */ "CONCAT",
  /*  277 */ "CONFLICT",
  /*  278 */ "COPY",
  /*  279 */ "DEFERRED",
  /*  280 */ "DELIMITERS",
  /*  281 */ "DETACH",
  /*  282 */ "DIVIDE",
  /*  283 */ "DOT",
  /*  284 */ "EACH",
  /*  285 */ "FAIL",
  /*  286 */ "FILE",
  /*  287 */ "FOR",
  /*  288 */ "GLOB",
  /*  289 */ "ID",
  /*  290 */ "IMMEDIATE",
  /*  291 */ "IMPORT",
  /*  292 */ "INITIALLY",
  /*  293 */ "INSTEAD",
  /*  294 */ "ISNULL",
  /*  295 */ "KEY",
  /*  296 */ "MODULES",
  /*  297 */ "NK_BITNOT",
  /*  298 */ "NK_SEMI",
  /*  299 */ "NOTNULL",
  /*  300 */ "OF",
  /*  301 */ "PLUS",
  /*  302 */ "PRIVILEGE",
  /*  303 */ "RAISE",
  /*  304 */ "REPLACE",
  /*  305 */ "RESTRICT",
  /*  306 */ "ROW",
  /*  307 */ "SEMI",
  /*  308 */ "STAR",
  /*  309 */ "STATEMENT",
  /*  310 */ "STRING",
  /*  311 */ "TIMES",
  /*  312 */ "UPDATE",
  /*  313 */ "VALUES",
  /*  314 */ "VARIABLE",
  /*  315 */ "VIEW",
  /*  316 */ "WAL",
  /*  317 */ "cmd",
  /*  318 */ "account_options",
  /*  319 */ "alter_account_options",
  /*  320 */ "literal",
  /*  321 */ "alter_account_option",
  /*  322 */ "user_name",
  /*  323 */ "sysinfo_opt",
  /*  324 */ "privileges",
  /*  325 */ "priv_level",
  /*  326 */ "priv_type_list",
  /*  327 */ "priv_type",
  /*  328 */ "db_name",
  /*  329 */ "dnode_endpoint",
  /*  330 */ "not_exists_opt",
  /*  331 */ "db_options",
  /*  332 */ "exists_opt",
  /*  333 */ "alter_db_options",
  /*  334 */ "speed_opt",
  /*  335 */ "integer_list",
  /*  336 */ "variable_list",
  /*  337 */ "retention_list",
  /*  338 */ "alter_db_option",
  /*  339 */ "retention",
  /*  340 */ "full_table_name",
  /*  341 */ "column_def_list",
  /*  342 */ "tags_def_opt",
  /*  343 */ "table_options",
  /*  344 */ "multi_create_clause",
  /*  345 */ "tags_def",
  /*  346 */ "multi_drop_clause",
  /*  347 */ "alter_table_clause",
  /*  348 */ "alter_table_options",
  /*  349 */ "column_name",
  /*  350 */ "type_name",
  /*  351 */ "signed_literal",
  /*  352 */ "create_subtable_clause",
  /*  353 */ "specific_cols_opt",
  /*  354 */ "expression_list",
  /*  355 */ "drop_table_clause",
  /*  356 */ "col_name_list",
  /*  357 */ "table_name",
  /*  358 */ "column_def",
  /*  359 */ "duration_list",
  /*  360 */ "rollup_func_list",
  /*  361 */ "alter_table_option",
  /*  362 */ "duration_literal",
  /*  363 */ "rollup_func_name",
  /*  364 */ "function_name",
  /*  365 */ "col_name",
  /*  366 */ "db_name_cond_opt",
  /*  367 */ "like_pattern_opt",
  /*  368 */ "table_name_cond",
  /*  369 */ "from_db_opt",
  /*  370 */ "index_options",
  /*  371 */ "func_list",
  /*  372 */ "sliding_opt",
  /*  373 */ "sma_stream_opt",
  /*  374 */ "func",
  /*  375 */ "stream_options",
  /*  376 */ "topic_name",
  /*  377 */ "query_or_subquery",
  /*  378 */ "cgroup_name",
  /*  379 */ "analyze_opt",
  /*  380 */ "explain_options",
  /*  381 */ "agg_func_opt",
  /*  382 */ "bufsize_opt",
  /*  383 */ "stream_name",
  /*  384 */ "subtable_opt",
  /*  385 */ "expression",
  /*  386 */ "dnode_list",
  /*  387 */ "where_clause_opt",
  /*  388 */ "signed",
  /*  389 */ "literal_func",
  /*  390 */ "literal_list",
  /*  391 */ "table_alias",
  /*  392 */ "column_alias",
  /*  393 */ "expr_or_subquery",
  /*  394 */ "subquery",
  /*  395 */ "pseudo_column",
  /*  396 */ "column_reference",
  /*  397 */ "function_expression",
  /*  398 */ "case_when_expression",
  /*  399 */ "star_func",
  /*  400 */ "star_func_para_list",
  /*  401 */ "noarg_func",
  /*  402 */ "other_para_list",
  /*  403 */ "star_func_para",
  /*  404 */ "when_then_list",
  /*  405 */ "case_when_else_opt",
  /*  406 */ "common_expression",
  /*  407 */ "when_then_expr",
  /*  408 */ "predicate",
  /*  409 */ "compare_op",
  /*  410 */ "in_op",
  /*  411 */ "in_predicate_value",
  /*  412 */ "boolean_value_expression",
  /*  413 */ "boolean_primary",
  /*  414 */ "from_clause_opt",
  /*  415 */ "table_reference_list",
  /*  416 */ "table_reference",
  /*  417 */ "table_primary",
  /*  418 */ "joined_table",
  /*  419 */ "alias_opt",
  /*  420 */ "parenthesized_joined_table",
  /*  421 */ "join_type",
  /*  422 */ "search_condition",
  /*  423 */ "query_specification",
  /*  424 */ "set_quantifier_opt",
  /*  425 */ "select_list",
  /*  426 */ "partition_by_clause_opt",
  /*  427 */ "range_opt",
  /*  428 */ "every_opt",
  /*  429 */ "fill_opt",
  /*  430 */ "twindow_clause_opt",
  /*  431 */ "group_by_clause_opt",
  /*  432 */ "having_clause_opt",
  /*  433 */ "select_item",
  /*  434 */ "partition_list",
  /*  435 */ "partition_item",
  /*  436 */ "fill_mode",
  /*  437 */ "group_by_list",
  /*  438 */ "query_expression",
  /*  439 */ "query_simple",
  /*  440 */ "order_by_clause_opt",
  /*  441 */ "slimit_clause_opt",
  /*  442 */ "limit_clause_opt",
  /*  443 */ "union_query_expression",
  /*  444 */ "query_simple_or_subquery",
  /*  445 */ "sort_specification_list",
  /*  446 */ "sort_specification",
  /*  447 */ "ordering_specification_opt",
  /*  448 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 107 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 108 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 109 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 110 */ "alter_db_option ::= KEEP integer_list",
 /* 111 */ "alter_db_option ::= KEEP variable_list",
 /* 112 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 113 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 114 */ "alter_db_option ::= STRICT NK_STRING",
 /* 115 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 116 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 117 */ "integer_list ::= NK_INTEGER",
 /* 118 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 119 */ "variable_list ::= NK_VARIABLE",
 /* 120 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 121 */ "retention_list ::= retention",
 /* 122 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 123 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 124 */ "speed_opt ::=",
 /* 125 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 126 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 127 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 128 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 129 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 130 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 131 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 132 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 133 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 134 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 136 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 138 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 140 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 142 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 143 */ "multi_create_clause ::= create_subtable_clause",
 /* 144 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 145 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 146 */ "multi_drop_clause ::= drop_table_clause",
 /* 147 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 148 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 149 */ "specific_cols_opt ::=",
 /* 150 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 151 */ "full_table_name ::= table_name",
 /* 152 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 153 */ "column_def_list ::= column_def",
 /* 154 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 155 */ "column_def ::= column_name type_name",
 /* 156 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 157 */ "type_name ::= BOOL",
 /* 158 */ "type_name ::= TINYINT",
 /* 159 */ "type_name ::= SMALLINT",
 /* 160 */ "type_name ::= INT",
 /* 161 */ "type_name ::= INTEGER",
 /* 162 */ "type_name ::= BIGINT",
 /* 163 */ "type_name ::= FLOAT",
 /* 164 */ "type_name ::= DOUBLE",
 /* 165 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= TIMESTAMP",
 /* 167 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TINYINT UNSIGNED",
 /* 169 */ "type_name ::= SMALLINT UNSIGNED",
 /* 170 */ "type_name ::= INT UNSIGNED",
 /* 171 */ "type_name ::= BIGINT UNSIGNED",
 /* 172 */ "type_name ::= JSON",
 /* 173 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 174 */ "type_name ::= MEDIUMBLOB",
 /* 175 */ "type_name ::= BLOB",
 /* 176 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= DECIMAL",
 /* 178 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 180 */ "tags_def_opt ::=",
 /* 181 */ "tags_def_opt ::= tags_def",
 /* 182 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 183 */ "table_options ::=",
 /* 184 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 185 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 186 */ "table_options ::= table_options WATERMARK duration_list",
 /* 187 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 188 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 189 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 190 */ "alter_table_options ::= alter_table_option",
 /* 191 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 192 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 193 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 194 */ "duration_list ::= duration_literal",
 /* 195 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 196 */ "rollup_func_list ::= rollup_func_name",
 /* 197 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 198 */ "rollup_func_name ::= function_name",
 /* 199 */ "rollup_func_name ::= FIRST",
 /* 200 */ "rollup_func_name ::= LAST",
 /* 201 */ "col_name_list ::= col_name",
 /* 202 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 203 */ "col_name ::= column_name",
 /* 204 */ "cmd ::= SHOW DNODES",
 /* 205 */ "cmd ::= SHOW USERS",
 /* 206 */ "cmd ::= SHOW DATABASES",
 /* 207 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 208 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 209 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 210 */ "cmd ::= SHOW MNODES",
 /* 211 */ "cmd ::= SHOW QNODES",
 /* 212 */ "cmd ::= SHOW FUNCTIONS",
 /* 213 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 214 */ "cmd ::= SHOW STREAMS",
 /* 215 */ "cmd ::= SHOW ACCOUNTS",
 /* 216 */ "cmd ::= SHOW APPS",
 /* 217 */ "cmd ::= SHOW CONNECTIONS",
 /* 218 */ "cmd ::= SHOW LICENCES",
 /* 219 */ "cmd ::= SHOW GRANTS",
 /* 220 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 221 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 222 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 223 */ "cmd ::= SHOW QUERIES",
 /* 224 */ "cmd ::= SHOW SCORES",
 /* 225 */ "cmd ::= SHOW TOPICS",
 /* 226 */ "cmd ::= SHOW VARIABLES",
 /* 227 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 228 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 229 */ "cmd ::= SHOW BNODES",
 /* 230 */ "cmd ::= SHOW SNODES",
 /* 231 */ "cmd ::= SHOW CLUSTER",
 /* 232 */ "cmd ::= SHOW TRANSACTIONS",
 /* 233 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 234 */ "cmd ::= SHOW CONSUMERS",
 /* 235 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 236 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 237 */ "cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt",
 /* 238 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 239 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 240 */ "db_name_cond_opt ::=",
 /* 241 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 242 */ "like_pattern_opt ::=",
 /* 243 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 244 */ "table_name_cond ::= table_name",
 /* 245 */ "from_db_opt ::=",
 /* 246 */ "from_db_opt ::= FROM db_name",
 /* 247 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 248 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 249 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 250 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 251 */ "func_list ::= func",
 /* 252 */ "func_list ::= func_list NK_COMMA func",
 /* 253 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 254 */ "sma_stream_opt ::=",
 /* 255 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 256 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 257 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 258 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 259 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 260 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 261 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 262 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 263 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 264 */ "cmd ::= DESC full_table_name",
 /* 265 */ "cmd ::= DESCRIBE full_table_name",
 /* 266 */ "cmd ::= RESET QUERY CACHE",
 /* 267 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 268 */ "analyze_opt ::=",
 /* 269 */ "analyze_opt ::= ANALYZE",
 /* 270 */ "explain_options ::=",
 /* 271 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 272 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 273 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 274 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 275 */ "agg_func_opt ::=",
 /* 276 */ "agg_func_opt ::= AGGREGATE",
 /* 277 */ "bufsize_opt ::=",
 /* 278 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 279 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 280 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 281 */ "stream_options ::=",
 /* 282 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 283 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 284 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 285 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 286 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 287 */ "subtable_opt ::=",
 /* 288 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 289 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 290 */ "cmd ::= KILL QUERY NK_STRING",
 /* 291 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 292 */ "cmd ::= BALANCE VGROUP",
 /* 293 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 294 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 295 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 296 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 297 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 298 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 299 */ "cmd ::= query_or_subquery",
 /* 300 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 301 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 302 */ "literal ::= NK_INTEGER",
 /* 303 */ "literal ::= NK_FLOAT",
 /* 304 */ "literal ::= NK_STRING",
 /* 305 */ "literal ::= NK_BOOL",
 /* 306 */ "literal ::= TIMESTAMP NK_STRING",
 /* 307 */ "literal ::= duration_literal",
 /* 308 */ "literal ::= NULL",
 /* 309 */ "literal ::= NK_QUESTION",
 /* 310 */ "duration_literal ::= NK_VARIABLE",
 /* 311 */ "signed ::= NK_INTEGER",
 /* 312 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 313 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 314 */ "signed ::= NK_FLOAT",
 /* 315 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 316 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 317 */ "signed_literal ::= signed",
 /* 318 */ "signed_literal ::= NK_STRING",
 /* 319 */ "signed_literal ::= NK_BOOL",
 /* 320 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 321 */ "signed_literal ::= duration_literal",
 /* 322 */ "signed_literal ::= NULL",
 /* 323 */ "signed_literal ::= literal_func",
 /* 324 */ "signed_literal ::= NK_QUESTION",
 /* 325 */ "literal_list ::= signed_literal",
 /* 326 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 327 */ "db_name ::= NK_ID",
 /* 328 */ "table_name ::= NK_ID",
 /* 329 */ "column_name ::= NK_ID",
 /* 330 */ "function_name ::= NK_ID",
 /* 331 */ "table_alias ::= NK_ID",
 /* 332 */ "column_alias ::= NK_ID",
 /* 333 */ "user_name ::= NK_ID",
 /* 334 */ "topic_name ::= NK_ID",
 /* 335 */ "stream_name ::= NK_ID",
 /* 336 */ "cgroup_name ::= NK_ID",
 /* 337 */ "expr_or_subquery ::= expression",
 /* 338 */ "expr_or_subquery ::= subquery",
 /* 339 */ "expression ::= literal",
 /* 340 */ "expression ::= pseudo_column",
 /* 341 */ "expression ::= column_reference",
 /* 342 */ "expression ::= function_expression",
 /* 343 */ "expression ::= case_when_expression",
 /* 344 */ "expression ::= NK_LP expression NK_RP",
 /* 345 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 346 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 347 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 348 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 349 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 350 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 351 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 352 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 353 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 354 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 355 */ "expression_list ::= expr_or_subquery",
 /* 356 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 357 */ "column_reference ::= column_name",
 /* 358 */ "column_reference ::= table_name NK_DOT column_name",
 /* 359 */ "pseudo_column ::= ROWTS",
 /* 360 */ "pseudo_column ::= TBNAME",
 /* 361 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 362 */ "pseudo_column ::= QSTART",
 /* 363 */ "pseudo_column ::= QEND",
 /* 364 */ "pseudo_column ::= QDURATION",
 /* 365 */ "pseudo_column ::= WSTART",
 /* 366 */ "pseudo_column ::= WEND",
 /* 367 */ "pseudo_column ::= WDURATION",
 /* 368 */ "pseudo_column ::= IROWTS",
 /* 369 */ "pseudo_column ::= QTAGS",
 /* 370 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 371 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 372 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 373 */ "function_expression ::= literal_func",
 /* 374 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 375 */ "literal_func ::= NOW",
 /* 376 */ "noarg_func ::= NOW",
 /* 377 */ "noarg_func ::= TODAY",
 /* 378 */ "noarg_func ::= TIMEZONE",
 /* 379 */ "noarg_func ::= DATABASE",
 /* 380 */ "noarg_func ::= CLIENT_VERSION",
 /* 381 */ "noarg_func ::= SERVER_VERSION",
 /* 382 */ "noarg_func ::= SERVER_STATUS",
 /* 383 */ "noarg_func ::= CURRENT_USER",
 /* 384 */ "noarg_func ::= USER",
 /* 385 */ "star_func ::= COUNT",
 /* 386 */ "star_func ::= FIRST",
 /* 387 */ "star_func ::= LAST",
 /* 388 */ "star_func ::= LAST_ROW",
 /* 389 */ "star_func_para_list ::= NK_STAR",
 /* 390 */ "star_func_para_list ::= other_para_list",
 /* 391 */ "other_para_list ::= star_func_para",
 /* 392 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 393 */ "star_func_para ::= expr_or_subquery",
 /* 394 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 395 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 396 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 397 */ "when_then_list ::= when_then_expr",
 /* 398 */ "when_then_list ::= when_then_list when_then_expr",
 /* 399 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 400 */ "case_when_else_opt ::=",
 /* 401 */ "case_when_else_opt ::= ELSE common_expression",
 /* 402 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 403 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 404 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 405 */ "predicate ::= expr_or_subquery IS NULL",
 /* 406 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 407 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 408 */ "compare_op ::= NK_LT",
 /* 409 */ "compare_op ::= NK_GT",
 /* 410 */ "compare_op ::= NK_LE",
 /* 411 */ "compare_op ::= NK_GE",
 /* 412 */ "compare_op ::= NK_NE",
 /* 413 */ "compare_op ::= NK_EQ",
 /* 414 */ "compare_op ::= LIKE",
 /* 415 */ "compare_op ::= NOT LIKE",
 /* 416 */ "compare_op ::= MATCH",
 /* 417 */ "compare_op ::= NMATCH",
 /* 418 */ "compare_op ::= CONTAINS",
 /* 419 */ "in_op ::= IN",
 /* 420 */ "in_op ::= NOT IN",
 /* 421 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 422 */ "boolean_value_expression ::= boolean_primary",
 /* 423 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 424 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 425 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 426 */ "boolean_primary ::= predicate",
 /* 427 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 428 */ "common_expression ::= expr_or_subquery",
 /* 429 */ "common_expression ::= boolean_value_expression",
 /* 430 */ "from_clause_opt ::=",
 /* 431 */ "from_clause_opt ::= FROM table_reference_list",
 /* 432 */ "table_reference_list ::= table_reference",
 /* 433 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 434 */ "table_reference ::= table_primary",
 /* 435 */ "table_reference ::= joined_table",
 /* 436 */ "table_primary ::= table_name alias_opt",
 /* 437 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 438 */ "table_primary ::= subquery alias_opt",
 /* 439 */ "table_primary ::= parenthesized_joined_table",
 /* 440 */ "alias_opt ::=",
 /* 441 */ "alias_opt ::= table_alias",
 /* 442 */ "alias_opt ::= AS table_alias",
 /* 443 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 444 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 445 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 446 */ "join_type ::=",
 /* 447 */ "join_type ::= INNER",
 /* 448 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 449 */ "set_quantifier_opt ::=",
 /* 450 */ "set_quantifier_opt ::= DISTINCT",
 /* 451 */ "set_quantifier_opt ::= ALL",
 /* 452 */ "select_list ::= select_item",
 /* 453 */ "select_list ::= select_list NK_COMMA select_item",
 /* 454 */ "select_item ::= NK_STAR",
 /* 455 */ "select_item ::= common_expression",
 /* 456 */ "select_item ::= common_expression column_alias",
 /* 457 */ "select_item ::= common_expression AS column_alias",
 /* 458 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 459 */ "where_clause_opt ::=",
 /* 460 */ "where_clause_opt ::= WHERE search_condition",
 /* 461 */ "partition_by_clause_opt ::=",
 /* 462 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 463 */ "partition_list ::= partition_item",
 /* 464 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 465 */ "partition_item ::= expr_or_subquery",
 /* 466 */ "partition_item ::= expr_or_subquery column_alias",
 /* 467 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 468 */ "twindow_clause_opt ::=",
 /* 469 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 470 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 471 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 472 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 473 */ "sliding_opt ::=",
 /* 474 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 475 */ "fill_opt ::=",
 /* 476 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 477 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 478 */ "fill_mode ::= NONE",
 /* 479 */ "fill_mode ::= PREV",
 /* 480 */ "fill_mode ::= NULL",
 /* 481 */ "fill_mode ::= LINEAR",
 /* 482 */ "fill_mode ::= NEXT",
 /* 483 */ "group_by_clause_opt ::=",
 /* 484 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 485 */ "group_by_list ::= expr_or_subquery",
 /* 486 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 487 */ "having_clause_opt ::=",
 /* 488 */ "having_clause_opt ::= HAVING search_condition",
 /* 489 */ "range_opt ::=",
 /* 490 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 491 */ "every_opt ::=",
 /* 492 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 493 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 494 */ "query_simple ::= query_specification",
 /* 495 */ "query_simple ::= union_query_expression",
 /* 496 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 497 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 498 */ "query_simple_or_subquery ::= query_simple",
 /* 499 */ "query_simple_or_subquery ::= subquery",
 /* 500 */ "query_or_subquery ::= query_expression",
 /* 501 */ "query_or_subquery ::= subquery",
 /* 502 */ "order_by_clause_opt ::=",
 /* 503 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 504 */ "slimit_clause_opt ::=",
 /* 505 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 506 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 507 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 508 */ "limit_clause_opt ::=",
 /* 509 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 510 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 511 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 512 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 513 */ "subquery ::= NK_LP subquery NK_RP",
 /* 514 */ "search_condition ::= common_expression",
 /* 515 */ "sort_specification_list ::= sort_specification",
 /* 516 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 517 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 518 */ "ordering_specification_opt ::=",
 /* 519 */ "ordering_specification_opt ::= ASC",
 /* 520 */ "ordering_specification_opt ::= DESC",
 /* 521 */ "null_ordering_opt ::=",
 /* 522 */ "null_ordering_opt ::= NULLS FIRST",
 /* 523 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 317: /* cmd */
    case 320: /* literal */
    case 331: /* db_options */
    case 333: /* alter_db_options */
    case 339: /* retention */
    case 340: /* full_table_name */
    case 343: /* table_options */
    case 347: /* alter_table_clause */
    case 348: /* alter_table_options */
    case 351: /* signed_literal */
    case 352: /* create_subtable_clause */
    case 355: /* drop_table_clause */
    case 358: /* column_def */
    case 362: /* duration_literal */
    case 363: /* rollup_func_name */
    case 365: /* col_name */
    case 366: /* db_name_cond_opt */
    case 367: /* like_pattern_opt */
    case 368: /* table_name_cond */
    case 369: /* from_db_opt */
    case 370: /* index_options */
    case 372: /* sliding_opt */
    case 373: /* sma_stream_opt */
    case 374: /* func */
    case 375: /* stream_options */
    case 377: /* query_or_subquery */
    case 380: /* explain_options */
    case 384: /* subtable_opt */
    case 385: /* expression */
    case 387: /* where_clause_opt */
    case 388: /* signed */
    case 389: /* literal_func */
    case 393: /* expr_or_subquery */
    case 394: /* subquery */
    case 395: /* pseudo_column */
    case 396: /* column_reference */
    case 397: /* function_expression */
    case 398: /* case_when_expression */
    case 403: /* star_func_para */
    case 405: /* case_when_else_opt */
    case 406: /* common_expression */
    case 407: /* when_then_expr */
    case 408: /* predicate */
    case 411: /* in_predicate_value */
    case 412: /* boolean_value_expression */
    case 413: /* boolean_primary */
    case 414: /* from_clause_opt */
    case 415: /* table_reference_list */
    case 416: /* table_reference */
    case 417: /* table_primary */
    case 418: /* joined_table */
    case 420: /* parenthesized_joined_table */
    case 422: /* search_condition */
    case 423: /* query_specification */
    case 427: /* range_opt */
    case 428: /* every_opt */
    case 429: /* fill_opt */
    case 430: /* twindow_clause_opt */
    case 432: /* having_clause_opt */
    case 433: /* select_item */
    case 435: /* partition_item */
    case 438: /* query_expression */
    case 439: /* query_simple */
    case 441: /* slimit_clause_opt */
    case 442: /* limit_clause_opt */
    case 443: /* union_query_expression */
    case 444: /* query_simple_or_subquery */
    case 446: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy778)); 
}
      break;
    case 318: /* account_options */
    case 319: /* alter_account_options */
    case 321: /* alter_account_option */
    case 334: /* speed_opt */
    case 382: /* bufsize_opt */
{
 
}
      break;
    case 322: /* user_name */
    case 325: /* priv_level */
    case 328: /* db_name */
    case 329: /* dnode_endpoint */
    case 349: /* column_name */
    case 357: /* table_name */
    case 364: /* function_name */
    case 376: /* topic_name */
    case 378: /* cgroup_name */
    case 383: /* stream_name */
    case 391: /* table_alias */
    case 392: /* column_alias */
    case 399: /* star_func */
    case 401: /* noarg_func */
    case 419: /* alias_opt */
{
 
}
      break;
    case 323: /* sysinfo_opt */
{
 
}
      break;
    case 324: /* privileges */
    case 326: /* priv_type_list */
    case 327: /* priv_type */
{
 
}
      break;
    case 330: /* not_exists_opt */
    case 332: /* exists_opt */
    case 379: /* analyze_opt */
    case 381: /* agg_func_opt */
    case 424: /* set_quantifier_opt */
{
 
}
      break;
    case 335: /* integer_list */
    case 336: /* variable_list */
    case 337: /* retention_list */
    case 341: /* column_def_list */
    case 342: /* tags_def_opt */
    case 344: /* multi_create_clause */
    case 345: /* tags_def */
    case 346: /* multi_drop_clause */
    case 353: /* specific_cols_opt */
    case 354: /* expression_list */
    case 356: /* col_name_list */
    case 359: /* duration_list */
    case 360: /* rollup_func_list */
    case 371: /* func_list */
    case 386: /* dnode_list */
    case 390: /* literal_list */
    case 400: /* star_func_para_list */
    case 402: /* other_para_list */
    case 404: /* when_then_list */
    case 425: /* select_list */
    case 426: /* partition_by_clause_opt */
    case 431: /* group_by_clause_opt */
    case 434: /* partition_list */
    case 437: /* group_by_list */
    case 440: /* order_by_clause_opt */
    case 445: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy282)); 
}
      break;
    case 338: /* alter_db_option */
    case 361: /* alter_table_option */
{
 
}
      break;
    case 350: /* type_name */
{
 
}
      break;
    case 409: /* compare_op */
    case 410: /* in_op */
{
 
}
      break;
    case 421: /* join_type */
{
 
}
      break;
    case 436: /* fill_mode */
{
 
}
      break;
    case 447: /* ordering_specification_opt */
{
 
}
      break;
    case 448: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  317,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  317,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  318,    0 }, /* (2) account_options ::= */
  {  318,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  318,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  318,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  318,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  318,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  318,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  318,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  318,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  318,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  319,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  319,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  321,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  321,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  321,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  321,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  321,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  321,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  321,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  321,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  321,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  321,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  317,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  317,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  317,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  317,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  317,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  323,    0 }, /* (29) sysinfo_opt ::= */
  {  323,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  317,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  317,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  324,   -1 }, /* (33) privileges ::= ALL */
  {  324,   -1 }, /* (34) privileges ::= priv_type_list */
  {  326,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  326,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  327,   -1 }, /* (37) priv_type ::= READ */
  {  327,   -1 }, /* (38) priv_type ::= WRITE */
  {  325,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  325,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  317,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  317,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  317,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  317,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  317,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  317,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  317,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  317,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  329,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  329,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  329,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  317,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  317,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  317,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  317,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  317,   -2 }, /* (64) cmd ::= USE db_name */
  {  317,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  317,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  317,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  330,    0 }, /* (69) not_exists_opt ::= */
  {  332,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  332,    0 }, /* (71) exists_opt ::= */
  {  331,    0 }, /* (72) db_options ::= */
  {  331,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  331,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  331,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  331,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  331,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  331,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  331,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  331,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  331,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  331,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  331,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  331,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  331,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  331,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  331,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  331,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  331,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  331,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  331,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  331,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  331,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  331,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  331,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  331,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  331,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  333,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  333,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  338,   -2 }, /* (106) alter_db_option ::= BUFFER NK_INTEGER */
  {  338,   -2 }, /* (107) alter_db_option ::= CACHEMODEL NK_STRING */
  {  338,   -2 }, /* (108) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  338,   -2 }, /* (109) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -2 }, /* (110) alter_db_option ::= KEEP integer_list */
  {  338,   -2 }, /* (111) alter_db_option ::= KEEP variable_list */
  {  338,   -2 }, /* (112) alter_db_option ::= PAGES NK_INTEGER */
  {  338,   -2 }, /* (113) alter_db_option ::= REPLICA NK_INTEGER */
  {  338,   -2 }, /* (114) alter_db_option ::= STRICT NK_STRING */
  {  338,   -2 }, /* (115) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  338,   -2 }, /* (116) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  335,   -1 }, /* (117) integer_list ::= NK_INTEGER */
  {  335,   -3 }, /* (118) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  336,   -1 }, /* (119) variable_list ::= NK_VARIABLE */
  {  336,   -3 }, /* (120) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  337,   -1 }, /* (121) retention_list ::= retention */
  {  337,   -3 }, /* (122) retention_list ::= retention_list NK_COMMA retention */
  {  339,   -3 }, /* (123) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  334,    0 }, /* (124) speed_opt ::= */
  {  334,   -2 }, /* (125) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  317,   -9 }, /* (126) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  317,   -3 }, /* (127) cmd ::= CREATE TABLE multi_create_clause */
  {  317,   -9 }, /* (128) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  317,   -3 }, /* (129) cmd ::= DROP TABLE multi_drop_clause */
  {  317,   -4 }, /* (130) cmd ::= DROP STABLE exists_opt full_table_name */
  {  317,   -3 }, /* (131) cmd ::= ALTER TABLE alter_table_clause */
  {  317,   -3 }, /* (132) cmd ::= ALTER STABLE alter_table_clause */
  {  347,   -2 }, /* (133) alter_table_clause ::= full_table_name alter_table_options */
  {  347,   -5 }, /* (134) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  347,   -4 }, /* (135) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  347,   -5 }, /* (136) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  347,   -5 }, /* (137) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  347,   -5 }, /* (138) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  347,   -4 }, /* (139) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  347,   -5 }, /* (140) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  347,   -5 }, /* (141) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  347,   -6 }, /* (142) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  344,   -1 }, /* (143) multi_create_clause ::= create_subtable_clause */
  {  344,   -2 }, /* (144) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  352,  -10 }, /* (145) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  346,   -1 }, /* (146) multi_drop_clause ::= drop_table_clause */
  {  346,   -2 }, /* (147) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  355,   -2 }, /* (148) drop_table_clause ::= exists_opt full_table_name */
  {  353,    0 }, /* (149) specific_cols_opt ::= */
  {  353,   -3 }, /* (150) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  340,   -1 }, /* (151) full_table_name ::= table_name */
  {  340,   -3 }, /* (152) full_table_name ::= db_name NK_DOT table_name */
  {  341,   -1 }, /* (153) column_def_list ::= column_def */
  {  341,   -3 }, /* (154) column_def_list ::= column_def_list NK_COMMA column_def */
  {  358,   -2 }, /* (155) column_def ::= column_name type_name */
  {  358,   -4 }, /* (156) column_def ::= column_name type_name COMMENT NK_STRING */
  {  350,   -1 }, /* (157) type_name ::= BOOL */
  {  350,   -1 }, /* (158) type_name ::= TINYINT */
  {  350,   -1 }, /* (159) type_name ::= SMALLINT */
  {  350,   -1 }, /* (160) type_name ::= INT */
  {  350,   -1 }, /* (161) type_name ::= INTEGER */
  {  350,   -1 }, /* (162) type_name ::= BIGINT */
  {  350,   -1 }, /* (163) type_name ::= FLOAT */
  {  350,   -1 }, /* (164) type_name ::= DOUBLE */
  {  350,   -4 }, /* (165) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (166) type_name ::= TIMESTAMP */
  {  350,   -4 }, /* (167) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -2 }, /* (168) type_name ::= TINYINT UNSIGNED */
  {  350,   -2 }, /* (169) type_name ::= SMALLINT UNSIGNED */
  {  350,   -2 }, /* (170) type_name ::= INT UNSIGNED */
  {  350,   -2 }, /* (171) type_name ::= BIGINT UNSIGNED */
  {  350,   -1 }, /* (172) type_name ::= JSON */
  {  350,   -4 }, /* (173) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (174) type_name ::= MEDIUMBLOB */
  {  350,   -1 }, /* (175) type_name ::= BLOB */
  {  350,   -4 }, /* (176) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (177) type_name ::= DECIMAL */
  {  350,   -4 }, /* (178) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  350,   -6 }, /* (179) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  342,    0 }, /* (180) tags_def_opt ::= */
  {  342,   -1 }, /* (181) tags_def_opt ::= tags_def */
  {  345,   -4 }, /* (182) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  343,    0 }, /* (183) table_options ::= */
  {  343,   -3 }, /* (184) table_options ::= table_options COMMENT NK_STRING */
  {  343,   -3 }, /* (185) table_options ::= table_options MAX_DELAY duration_list */
  {  343,   -3 }, /* (186) table_options ::= table_options WATERMARK duration_list */
  {  343,   -5 }, /* (187) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  343,   -3 }, /* (188) table_options ::= table_options TTL NK_INTEGER */
  {  343,   -5 }, /* (189) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  348,   -1 }, /* (190) alter_table_options ::= alter_table_option */
  {  348,   -2 }, /* (191) alter_table_options ::= alter_table_options alter_table_option */
  {  361,   -2 }, /* (192) alter_table_option ::= COMMENT NK_STRING */
  {  361,   -2 }, /* (193) alter_table_option ::= TTL NK_INTEGER */
  {  359,   -1 }, /* (194) duration_list ::= duration_literal */
  {  359,   -3 }, /* (195) duration_list ::= duration_list NK_COMMA duration_literal */
  {  360,   -1 }, /* (196) rollup_func_list ::= rollup_func_name */
  {  360,   -3 }, /* (197) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  363,   -1 }, /* (198) rollup_func_name ::= function_name */
  {  363,   -1 }, /* (199) rollup_func_name ::= FIRST */
  {  363,   -1 }, /* (200) rollup_func_name ::= LAST */
  {  356,   -1 }, /* (201) col_name_list ::= col_name */
  {  356,   -3 }, /* (202) col_name_list ::= col_name_list NK_COMMA col_name */
  {  365,   -1 }, /* (203) col_name ::= column_name */
  {  317,   -2 }, /* (204) cmd ::= SHOW DNODES */
  {  317,   -2 }, /* (205) cmd ::= SHOW USERS */
  {  317,   -2 }, /* (206) cmd ::= SHOW DATABASES */
  {  317,   -4 }, /* (207) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  317,   -4 }, /* (208) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  317,   -3 }, /* (209) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  317,   -2 }, /* (210) cmd ::= SHOW MNODES */
  {  317,   -2 }, /* (211) cmd ::= SHOW QNODES */
  {  317,   -2 }, /* (212) cmd ::= SHOW FUNCTIONS */
  {  317,   -5 }, /* (213) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  317,   -2 }, /* (214) cmd ::= SHOW STREAMS */
  {  317,   -2 }, /* (215) cmd ::= SHOW ACCOUNTS */
  {  317,   -2 }, /* (216) cmd ::= SHOW APPS */
  {  317,   -2 }, /* (217) cmd ::= SHOW CONNECTIONS */
  {  317,   -2 }, /* (218) cmd ::= SHOW LICENCES */
  {  317,   -2 }, /* (219) cmd ::= SHOW GRANTS */
  {  317,   -4 }, /* (220) cmd ::= SHOW CREATE DATABASE db_name */
  {  317,   -4 }, /* (221) cmd ::= SHOW CREATE TABLE full_table_name */
  {  317,   -4 }, /* (222) cmd ::= SHOW CREATE STABLE full_table_name */
  {  317,   -2 }, /* (223) cmd ::= SHOW QUERIES */
  {  317,   -2 }, /* (224) cmd ::= SHOW SCORES */
  {  317,   -2 }, /* (225) cmd ::= SHOW TOPICS */
  {  317,   -2 }, /* (226) cmd ::= SHOW VARIABLES */
  {  317,   -3 }, /* (227) cmd ::= SHOW LOCAL VARIABLES */
  {  317,   -4 }, /* (228) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  317,   -2 }, /* (229) cmd ::= SHOW BNODES */
  {  317,   -2 }, /* (230) cmd ::= SHOW SNODES */
  {  317,   -2 }, /* (231) cmd ::= SHOW CLUSTER */
  {  317,   -2 }, /* (232) cmd ::= SHOW TRANSACTIONS */
  {  317,   -4 }, /* (233) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  317,   -2 }, /* (234) cmd ::= SHOW CONSUMERS */
  {  317,   -2 }, /* (235) cmd ::= SHOW SUBSCRIPTIONS */
  {  317,   -5 }, /* (236) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  317,   -6 }, /* (237) cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
  {  317,   -3 }, /* (238) cmd ::= SHOW VNODES NK_INTEGER */
  {  317,   -3 }, /* (239) cmd ::= SHOW VNODES NK_STRING */
  {  366,    0 }, /* (240) db_name_cond_opt ::= */
  {  366,   -2 }, /* (241) db_name_cond_opt ::= db_name NK_DOT */
  {  367,    0 }, /* (242) like_pattern_opt ::= */
  {  367,   -2 }, /* (243) like_pattern_opt ::= LIKE NK_STRING */
  {  368,   -1 }, /* (244) table_name_cond ::= table_name */
  {  369,    0 }, /* (245) from_db_opt ::= */
  {  369,   -2 }, /* (246) from_db_opt ::= FROM db_name */
  {  317,   -8 }, /* (247) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  317,   -4 }, /* (248) cmd ::= DROP INDEX exists_opt full_table_name */
  {  370,  -10 }, /* (249) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  370,  -12 }, /* (250) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  371,   -1 }, /* (251) func_list ::= func */
  {  371,   -3 }, /* (252) func_list ::= func_list NK_COMMA func */
  {  374,   -4 }, /* (253) func ::= function_name NK_LP expression_list NK_RP */
  {  373,    0 }, /* (254) sma_stream_opt ::= */
  {  373,   -3 }, /* (255) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  373,   -3 }, /* (256) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  317,   -6 }, /* (257) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  317,   -7 }, /* (258) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  317,   -9 }, /* (259) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  317,   -7 }, /* (260) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  317,   -9 }, /* (261) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  317,   -4 }, /* (262) cmd ::= DROP TOPIC exists_opt topic_name */
  {  317,   -7 }, /* (263) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  317,   -2 }, /* (264) cmd ::= DESC full_table_name */
  {  317,   -2 }, /* (265) cmd ::= DESCRIBE full_table_name */
  {  317,   -3 }, /* (266) cmd ::= RESET QUERY CACHE */
  {  317,   -4 }, /* (267) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  379,    0 }, /* (268) analyze_opt ::= */
  {  379,   -1 }, /* (269) analyze_opt ::= ANALYZE */
  {  380,    0 }, /* (270) explain_options ::= */
  {  380,   -3 }, /* (271) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  380,   -3 }, /* (272) explain_options ::= explain_options RATIO NK_FLOAT */
  {  317,  -10 }, /* (273) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  317,   -4 }, /* (274) cmd ::= DROP FUNCTION exists_opt function_name */
  {  381,    0 }, /* (275) agg_func_opt ::= */
  {  381,   -1 }, /* (276) agg_func_opt ::= AGGREGATE */
  {  382,    0 }, /* (277) bufsize_opt ::= */
  {  382,   -2 }, /* (278) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  317,  -11 }, /* (279) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  317,   -4 }, /* (280) cmd ::= DROP STREAM exists_opt stream_name */
  {  375,    0 }, /* (281) stream_options ::= */
  {  375,   -3 }, /* (282) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  375,   -3 }, /* (283) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  375,   -4 }, /* (284) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  375,   -3 }, /* (285) stream_options ::= stream_options WATERMARK duration_literal */
  {  375,   -4 }, /* (286) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  384,    0 }, /* (287) subtable_opt ::= */
  {  384,   -4 }, /* (288) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  317,   -3 }, /* (289) cmd ::= KILL CONNECTION NK_INTEGER */
  {  317,   -3 }, /* (290) cmd ::= KILL QUERY NK_STRING */
  {  317,   -3 }, /* (291) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  317,   -2 }, /* (292) cmd ::= BALANCE VGROUP */
  {  317,   -4 }, /* (293) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  317,   -4 }, /* (294) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  317,   -3 }, /* (295) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  386,   -2 }, /* (296) dnode_list ::= DNODE NK_INTEGER */
  {  386,   -3 }, /* (297) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  317,   -4 }, /* (298) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  317,   -1 }, /* (299) cmd ::= query_or_subquery */
  {  317,   -7 }, /* (300) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  317,   -4 }, /* (301) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  320,   -1 }, /* (302) literal ::= NK_INTEGER */
  {  320,   -1 }, /* (303) literal ::= NK_FLOAT */
  {  320,   -1 }, /* (304) literal ::= NK_STRING */
  {  320,   -1 }, /* (305) literal ::= NK_BOOL */
  {  320,   -2 }, /* (306) literal ::= TIMESTAMP NK_STRING */
  {  320,   -1 }, /* (307) literal ::= duration_literal */
  {  320,   -1 }, /* (308) literal ::= NULL */
  {  320,   -1 }, /* (309) literal ::= NK_QUESTION */
  {  362,   -1 }, /* (310) duration_literal ::= NK_VARIABLE */
  {  388,   -1 }, /* (311) signed ::= NK_INTEGER */
  {  388,   -2 }, /* (312) signed ::= NK_PLUS NK_INTEGER */
  {  388,   -2 }, /* (313) signed ::= NK_MINUS NK_INTEGER */
  {  388,   -1 }, /* (314) signed ::= NK_FLOAT */
  {  388,   -2 }, /* (315) signed ::= NK_PLUS NK_FLOAT */
  {  388,   -2 }, /* (316) signed ::= NK_MINUS NK_FLOAT */
  {  351,   -1 }, /* (317) signed_literal ::= signed */
  {  351,   -1 }, /* (318) signed_literal ::= NK_STRING */
  {  351,   -1 }, /* (319) signed_literal ::= NK_BOOL */
  {  351,   -2 }, /* (320) signed_literal ::= TIMESTAMP NK_STRING */
  {  351,   -1 }, /* (321) signed_literal ::= duration_literal */
  {  351,   -1 }, /* (322) signed_literal ::= NULL */
  {  351,   -1 }, /* (323) signed_literal ::= literal_func */
  {  351,   -1 }, /* (324) signed_literal ::= NK_QUESTION */
  {  390,   -1 }, /* (325) literal_list ::= signed_literal */
  {  390,   -3 }, /* (326) literal_list ::= literal_list NK_COMMA signed_literal */
  {  328,   -1 }, /* (327) db_name ::= NK_ID */
  {  357,   -1 }, /* (328) table_name ::= NK_ID */
  {  349,   -1 }, /* (329) column_name ::= NK_ID */
  {  364,   -1 }, /* (330) function_name ::= NK_ID */
  {  391,   -1 }, /* (331) table_alias ::= NK_ID */
  {  392,   -1 }, /* (332) column_alias ::= NK_ID */
  {  322,   -1 }, /* (333) user_name ::= NK_ID */
  {  376,   -1 }, /* (334) topic_name ::= NK_ID */
  {  383,   -1 }, /* (335) stream_name ::= NK_ID */
  {  378,   -1 }, /* (336) cgroup_name ::= NK_ID */
  {  393,   -1 }, /* (337) expr_or_subquery ::= expression */
  {  393,   -1 }, /* (338) expr_or_subquery ::= subquery */
  {  385,   -1 }, /* (339) expression ::= literal */
  {  385,   -1 }, /* (340) expression ::= pseudo_column */
  {  385,   -1 }, /* (341) expression ::= column_reference */
  {  385,   -1 }, /* (342) expression ::= function_expression */
  {  385,   -1 }, /* (343) expression ::= case_when_expression */
  {  385,   -3 }, /* (344) expression ::= NK_LP expression NK_RP */
  {  385,   -2 }, /* (345) expression ::= NK_PLUS expr_or_subquery */
  {  385,   -2 }, /* (346) expression ::= NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (347) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  385,   -3 }, /* (348) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (349) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  385,   -3 }, /* (350) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  385,   -3 }, /* (351) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  385,   -3 }, /* (352) expression ::= column_reference NK_ARROW NK_STRING */
  {  385,   -3 }, /* (353) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  385,   -3 }, /* (354) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  354,   -1 }, /* (355) expression_list ::= expr_or_subquery */
  {  354,   -3 }, /* (356) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  396,   -1 }, /* (357) column_reference ::= column_name */
  {  396,   -3 }, /* (358) column_reference ::= table_name NK_DOT column_name */
  {  395,   -1 }, /* (359) pseudo_column ::= ROWTS */
  {  395,   -1 }, /* (360) pseudo_column ::= TBNAME */
  {  395,   -3 }, /* (361) pseudo_column ::= table_name NK_DOT TBNAME */
  {  395,   -1 }, /* (362) pseudo_column ::= QSTART */
  {  395,   -1 }, /* (363) pseudo_column ::= QEND */
  {  395,   -1 }, /* (364) pseudo_column ::= QDURATION */
  {  395,   -1 }, /* (365) pseudo_column ::= WSTART */
  {  395,   -1 }, /* (366) pseudo_column ::= WEND */
  {  395,   -1 }, /* (367) pseudo_column ::= WDURATION */
  {  395,   -1 }, /* (368) pseudo_column ::= IROWTS */
  {  395,   -1 }, /* (369) pseudo_column ::= QTAGS */
  {  397,   -4 }, /* (370) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  397,   -4 }, /* (371) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  397,   -6 }, /* (372) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  397,   -1 }, /* (373) function_expression ::= literal_func */
  {  389,   -3 }, /* (374) literal_func ::= noarg_func NK_LP NK_RP */
  {  389,   -1 }, /* (375) literal_func ::= NOW */
  {  401,   -1 }, /* (376) noarg_func ::= NOW */
  {  401,   -1 }, /* (377) noarg_func ::= TODAY */
  {  401,   -1 }, /* (378) noarg_func ::= TIMEZONE */
  {  401,   -1 }, /* (379) noarg_func ::= DATABASE */
  {  401,   -1 }, /* (380) noarg_func ::= CLIENT_VERSION */
  {  401,   -1 }, /* (381) noarg_func ::= SERVER_VERSION */
  {  401,   -1 }, /* (382) noarg_func ::= SERVER_STATUS */
  {  401,   -1 }, /* (383) noarg_func ::= CURRENT_USER */
  {  401,   -1 }, /* (384) noarg_func ::= USER */
  {  399,   -1 }, /* (385) star_func ::= COUNT */
  {  399,   -1 }, /* (386) star_func ::= FIRST */
  {  399,   -1 }, /* (387) star_func ::= LAST */
  {  399,   -1 }, /* (388) star_func ::= LAST_ROW */
  {  400,   -1 }, /* (389) star_func_para_list ::= NK_STAR */
  {  400,   -1 }, /* (390) star_func_para_list ::= other_para_list */
  {  402,   -1 }, /* (391) other_para_list ::= star_func_para */
  {  402,   -3 }, /* (392) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  403,   -1 }, /* (393) star_func_para ::= expr_or_subquery */
  {  403,   -3 }, /* (394) star_func_para ::= table_name NK_DOT NK_STAR */
  {  398,   -4 }, /* (395) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  398,   -5 }, /* (396) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  404,   -1 }, /* (397) when_then_list ::= when_then_expr */
  {  404,   -2 }, /* (398) when_then_list ::= when_then_list when_then_expr */
  {  407,   -4 }, /* (399) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  405,    0 }, /* (400) case_when_else_opt ::= */
  {  405,   -2 }, /* (401) case_when_else_opt ::= ELSE common_expression */
  {  408,   -3 }, /* (402) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  408,   -5 }, /* (403) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -6 }, /* (404) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -3 }, /* (405) predicate ::= expr_or_subquery IS NULL */
  {  408,   -4 }, /* (406) predicate ::= expr_or_subquery IS NOT NULL */
  {  408,   -3 }, /* (407) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  409,   -1 }, /* (408) compare_op ::= NK_LT */
  {  409,   -1 }, /* (409) compare_op ::= NK_GT */
  {  409,   -1 }, /* (410) compare_op ::= NK_LE */
  {  409,   -1 }, /* (411) compare_op ::= NK_GE */
  {  409,   -1 }, /* (412) compare_op ::= NK_NE */
  {  409,   -1 }, /* (413) compare_op ::= NK_EQ */
  {  409,   -1 }, /* (414) compare_op ::= LIKE */
  {  409,   -2 }, /* (415) compare_op ::= NOT LIKE */
  {  409,   -1 }, /* (416) compare_op ::= MATCH */
  {  409,   -1 }, /* (417) compare_op ::= NMATCH */
  {  409,   -1 }, /* (418) compare_op ::= CONTAINS */
  {  410,   -1 }, /* (419) in_op ::= IN */
  {  410,   -2 }, /* (420) in_op ::= NOT IN */
  {  411,   -3 }, /* (421) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  412,   -1 }, /* (422) boolean_value_expression ::= boolean_primary */
  {  412,   -2 }, /* (423) boolean_value_expression ::= NOT boolean_primary */
  {  412,   -3 }, /* (424) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  412,   -3 }, /* (425) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  413,   -1 }, /* (426) boolean_primary ::= predicate */
  {  413,   -3 }, /* (427) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  406,   -1 }, /* (428) common_expression ::= expr_or_subquery */
  {  406,   -1 }, /* (429) common_expression ::= boolean_value_expression */
  {  414,    0 }, /* (430) from_clause_opt ::= */
  {  414,   -2 }, /* (431) from_clause_opt ::= FROM table_reference_list */
  {  415,   -1 }, /* (432) table_reference_list ::= table_reference */
  {  415,   -3 }, /* (433) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  416,   -1 }, /* (434) table_reference ::= table_primary */
  {  416,   -1 }, /* (435) table_reference ::= joined_table */
  {  417,   -2 }, /* (436) table_primary ::= table_name alias_opt */
  {  417,   -4 }, /* (437) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  417,   -2 }, /* (438) table_primary ::= subquery alias_opt */
  {  417,   -1 }, /* (439) table_primary ::= parenthesized_joined_table */
  {  419,    0 }, /* (440) alias_opt ::= */
  {  419,   -1 }, /* (441) alias_opt ::= table_alias */
  {  419,   -2 }, /* (442) alias_opt ::= AS table_alias */
  {  420,   -3 }, /* (443) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  420,   -3 }, /* (444) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  418,   -6 }, /* (445) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  421,    0 }, /* (446) join_type ::= */
  {  421,   -1 }, /* (447) join_type ::= INNER */
  {  423,  -12 }, /* (448) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  424,    0 }, /* (449) set_quantifier_opt ::= */
  {  424,   -1 }, /* (450) set_quantifier_opt ::= DISTINCT */
  {  424,   -1 }, /* (451) set_quantifier_opt ::= ALL */
  {  425,   -1 }, /* (452) select_list ::= select_item */
  {  425,   -3 }, /* (453) select_list ::= select_list NK_COMMA select_item */
  {  433,   -1 }, /* (454) select_item ::= NK_STAR */
  {  433,   -1 }, /* (455) select_item ::= common_expression */
  {  433,   -2 }, /* (456) select_item ::= common_expression column_alias */
  {  433,   -3 }, /* (457) select_item ::= common_expression AS column_alias */
  {  433,   -3 }, /* (458) select_item ::= table_name NK_DOT NK_STAR */
  {  387,    0 }, /* (459) where_clause_opt ::= */
  {  387,   -2 }, /* (460) where_clause_opt ::= WHERE search_condition */
  {  426,    0 }, /* (461) partition_by_clause_opt ::= */
  {  426,   -3 }, /* (462) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  434,   -1 }, /* (463) partition_list ::= partition_item */
  {  434,   -3 }, /* (464) partition_list ::= partition_list NK_COMMA partition_item */
  {  435,   -1 }, /* (465) partition_item ::= expr_or_subquery */
  {  435,   -2 }, /* (466) partition_item ::= expr_or_subquery column_alias */
  {  435,   -3 }, /* (467) partition_item ::= expr_or_subquery AS column_alias */
  {  430,    0 }, /* (468) twindow_clause_opt ::= */
  {  430,   -6 }, /* (469) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  430,   -4 }, /* (470) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  430,   -6 }, /* (471) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  430,   -8 }, /* (472) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  372,    0 }, /* (473) sliding_opt ::= */
  {  372,   -4 }, /* (474) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  429,    0 }, /* (475) fill_opt ::= */
  {  429,   -4 }, /* (476) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  429,   -6 }, /* (477) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  436,   -1 }, /* (478) fill_mode ::= NONE */
  {  436,   -1 }, /* (479) fill_mode ::= PREV */
  {  436,   -1 }, /* (480) fill_mode ::= NULL */
  {  436,   -1 }, /* (481) fill_mode ::= LINEAR */
  {  436,   -1 }, /* (482) fill_mode ::= NEXT */
  {  431,    0 }, /* (483) group_by_clause_opt ::= */
  {  431,   -3 }, /* (484) group_by_clause_opt ::= GROUP BY group_by_list */
  {  437,   -1 }, /* (485) group_by_list ::= expr_or_subquery */
  {  437,   -3 }, /* (486) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  432,    0 }, /* (487) having_clause_opt ::= */
  {  432,   -2 }, /* (488) having_clause_opt ::= HAVING search_condition */
  {  427,    0 }, /* (489) range_opt ::= */
  {  427,   -6 }, /* (490) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  428,    0 }, /* (491) every_opt ::= */
  {  428,   -4 }, /* (492) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  438,   -4 }, /* (493) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  439,   -1 }, /* (494) query_simple ::= query_specification */
  {  439,   -1 }, /* (495) query_simple ::= union_query_expression */
  {  443,   -4 }, /* (496) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  443,   -3 }, /* (497) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  444,   -1 }, /* (498) query_simple_or_subquery ::= query_simple */
  {  444,   -1 }, /* (499) query_simple_or_subquery ::= subquery */
  {  377,   -1 }, /* (500) query_or_subquery ::= query_expression */
  {  377,   -1 }, /* (501) query_or_subquery ::= subquery */
  {  440,    0 }, /* (502) order_by_clause_opt ::= */
  {  440,   -3 }, /* (503) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  441,    0 }, /* (504) slimit_clause_opt ::= */
  {  441,   -2 }, /* (505) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  441,   -4 }, /* (506) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  441,   -4 }, /* (507) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  442,    0 }, /* (508) limit_clause_opt ::= */
  {  442,   -2 }, /* (509) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  442,   -4 }, /* (510) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  442,   -4 }, /* (511) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  394,   -3 }, /* (512) subquery ::= NK_LP query_expression NK_RP */
  {  394,   -3 }, /* (513) subquery ::= NK_LP subquery NK_RP */
  {  422,   -1 }, /* (514) search_condition ::= common_expression */
  {  445,   -1 }, /* (515) sort_specification_list ::= sort_specification */
  {  445,   -3 }, /* (516) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  446,   -3 }, /* (517) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  447,    0 }, /* (518) ordering_specification_opt ::= */
  {  447,   -1 }, /* (519) ordering_specification_opt ::= ASC */
  {  447,   -1 }, /* (520) ordering_specification_opt ::= DESC */
  {  448,    0 }, /* (521) null_ordering_opt ::= */
  {  448,   -2 }, /* (522) null_ordering_opt ::= NULLS FIRST */
  {  448,   -2 }, /* (523) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,318,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,319,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,318,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,319,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,321,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy0, yymsp[0].minor.yy293); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy293 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy293 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy831 = yymsp[0].minor.yy831; }
  yymsp[0].minor.yy831 = yylhsminor.yy831;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy831 = yymsp[-2].minor.yy831 | yymsp[0].minor.yy831; }
  yymsp[-2].minor.yy831 = yylhsminor.yy831;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy181; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy181, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 327: /* db_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* table_name ::= NK_ID */ yytestcase(yyruleno==328);
      case 329: /* column_name ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* function_name ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* table_alias ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* column_alias ::= NK_ID */ yytestcase(yyruleno==332);
      case 333: /* user_name ::= NK_ID */ yytestcase(yyruleno==333);
      case 334: /* topic_name ::= NK_ID */ yytestcase(yyruleno==334);
      case 335: /* stream_name ::= NK_ID */ yytestcase(yyruleno==335);
      case 336: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==336);
      case 376: /* noarg_func ::= NOW */ yytestcase(yyruleno==376);
      case 377: /* noarg_func ::= TODAY */ yytestcase(yyruleno==377);
      case 378: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==378);
      case 379: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==379);
      case 380: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==380);
      case 381: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==381);
      case 382: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==382);
      case 383: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==383);
      case 384: /* noarg_func ::= USER */ yytestcase(yyruleno==384);
      case 385: /* star_func ::= COUNT */ yytestcase(yyruleno==385);
      case 386: /* star_func ::= FIRST */ yytestcase(yyruleno==386);
      case 387: /* star_func ::= LAST */ yytestcase(yyruleno==387);
      case 388: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==388);
{ yylhsminor.yy181 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy39, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy276); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy39 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 268: /* analyze_opt ::= */ yytestcase(yyruleno==268);
      case 275: /* agg_func_opt ::= */ yytestcase(yyruleno==275);
      case 449: /* set_quantifier_opt ::= */ yytestcase(yyruleno==449);
{ yymsp[1].minor.yy39 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy39 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy778 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_KEEP, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_RETENTIONS, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy778 = createAlterDatabaseOptions(pCxt); yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yylhsminor.yy778, &yymsp[0].minor.yy645); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy778, &yymsp[0].minor.yy645); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 106: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= KEEP integer_list */
      case 111: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==111);
{ yymsp[-1].minor.yy645.type = DB_OPTION_KEEP; yymsp[-1].minor.yy645.pList = yymsp[0].minor.yy282; }
        break;
      case 112: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_PAGES; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy645.type = DB_OPTION_STRICT; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_WAL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 118: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 297: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==297);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 119: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy282 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 120: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 121: /* retention_list ::= retention */
      case 143: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==143);
      case 146: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==146);
      case 153: /* column_def_list ::= column_def */ yytestcase(yyruleno==153);
      case 196: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==196);
      case 201: /* col_name_list ::= col_name */ yytestcase(yyruleno==201);
      case 251: /* func_list ::= func */ yytestcase(yyruleno==251);
      case 325: /* literal_list ::= signed_literal */ yytestcase(yyruleno==325);
      case 391: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==391);
      case 397: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==397);
      case 452: /* select_list ::= select_item */ yytestcase(yyruleno==452);
      case 463: /* partition_list ::= partition_item */ yytestcase(yyruleno==463);
      case 515: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==515);
{ yylhsminor.yy282 = createNodeList(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 122: /* retention_list ::= retention_list NK_COMMA retention */
      case 154: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==154);
      case 197: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==197);
      case 202: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==202);
      case 252: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==252);
      case 326: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==326);
      case 392: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==392);
      case 453: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==453);
      case 464: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==464);
      case 516: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==516);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 123: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy778 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 124: /* speed_opt ::= */
      case 277: /* bufsize_opt ::= */ yytestcase(yyruleno==277);
{ yymsp[1].minor.yy276 = 0; }
        break;
      case 125: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 278: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==278);
{ yymsp[-1].minor.yy276 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 126: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 128: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==128);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-5].minor.yy778, yymsp[-3].minor.yy282, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 127: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 129: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 130: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 131: /* cmd ::= ALTER TABLE alter_table_clause */
      case 299: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==299);
{ pCxt->pRootNode = yymsp[0].minor.yy778; }
        break;
      case 132: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy778); }
        break;
      case 133: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy778 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 134: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 135: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 136: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 137: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 138: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 139: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 140: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 141: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 142: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy778 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy778, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 144: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 147: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==147);
      case 398: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==398);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy282 = yylhsminor.yy282;
        break;
      case 145: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy778 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy39, yymsp[-8].minor.yy778, yymsp[-6].minor.yy778, yymsp[-5].minor.yy282, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-9].minor.yy778 = yylhsminor.yy778;
        break;
      case 148: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy778 = createDropTableClause(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 149: /* specific_cols_opt ::= */
      case 180: /* tags_def_opt ::= */ yytestcase(yyruleno==180);
      case 461: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==461);
      case 483: /* group_by_clause_opt ::= */ yytestcase(yyruleno==483);
      case 502: /* order_by_clause_opt ::= */ yytestcase(yyruleno==502);
{ yymsp[1].minor.yy282 = NULL; }
        break;
      case 150: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 151: /* full_table_name ::= table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 152: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 155: /* column_def ::= column_name type_name */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380, NULL); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 156: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-2].minor.yy380, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 157: /* type_name ::= BOOL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 158: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 159: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 160: /* type_name ::= INT */
      case 161: /* type_name ::= INTEGER */ yytestcase(yyruleno==161);
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 162: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 163: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 164: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 165: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 167: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 169: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 170: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 171: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 172: /* type_name ::= JSON */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 173: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 174: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 175: /* type_name ::= BLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 176: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 178: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 179: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* tags_def_opt ::= tags_def */
      case 390: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==390);
{ yylhsminor.yy282 = yymsp[0].minor.yy282; }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 182: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 183: /* table_options ::= */
{ yymsp[1].minor.yy778 = createDefaultTableOptions(pCxt); }
        break;
      case 184: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 185: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 186: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 187: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 188: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 189: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_SMA, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 190: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy778 = createAlterTableOptions(pCxt); yylhsminor.yy778 = setTableOption(pCxt, yylhsminor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 191: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 192: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 193: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 194: /* duration_list ::= duration_literal */
      case 355: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==355);
{ yylhsminor.yy282 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 195: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 356: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==356);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 198: /* rollup_func_name ::= function_name */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 199: /* rollup_func_name ::= FIRST */
      case 200: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==200);
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 203: /* col_name ::= column_name */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 204: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 205: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 206: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 207: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 208: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 209: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy778, NULL, OP_TYPE_LIKE); }
        break;
      case 210: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 211: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 212: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 213: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 214: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 215: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 216: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 217: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW LICENCES */
      case 219: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==219);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 220: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 221: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 222: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 223: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 224: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 225: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 226: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 227: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 228: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 229: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 230: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 231: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 232: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 233: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 234: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 235: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 236: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 237: /* cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLE_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 238: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 239: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 240: /* db_name_cond_opt ::= */
      case 245: /* from_db_opt ::= */ yytestcase(yyruleno==245);
{ yymsp[1].minor.yy778 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 241: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy778 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 242: /* like_pattern_opt ::= */
      case 287: /* subtable_opt ::= */ yytestcase(yyruleno==287);
      case 400: /* case_when_else_opt ::= */ yytestcase(yyruleno==400);
      case 430: /* from_clause_opt ::= */ yytestcase(yyruleno==430);
      case 459: /* where_clause_opt ::= */ yytestcase(yyruleno==459);
      case 468: /* twindow_clause_opt ::= */ yytestcase(yyruleno==468);
      case 473: /* sliding_opt ::= */ yytestcase(yyruleno==473);
      case 475: /* fill_opt ::= */ yytestcase(yyruleno==475);
      case 487: /* having_clause_opt ::= */ yytestcase(yyruleno==487);
      case 489: /* range_opt ::= */ yytestcase(yyruleno==489);
      case 491: /* every_opt ::= */ yytestcase(yyruleno==491);
      case 504: /* slimit_clause_opt ::= */ yytestcase(yyruleno==504);
      case 508: /* limit_clause_opt ::= */ yytestcase(yyruleno==508);
{ yymsp[1].minor.yy778 = NULL; }
        break;
      case 243: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 244: /* table_name_cond ::= table_name */
{ yylhsminor.yy778 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 246: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy778 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 247: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy39, yymsp[-3].minor.yy778, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 248: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 249: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy778 = createIndexOption(pCxt, yymsp[-7].minor.yy282, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 250: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy778 = createIndexOption(pCxt, yymsp[-9].minor.yy282, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 253: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 254: /* sma_stream_opt ::= */
      case 281: /* stream_options ::= */ yytestcase(yyruleno==281);
{ yymsp[1].minor.yy778 = createStreamOptions(pCxt); }
        break;
      case 255: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 285: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==285);
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 256: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 257: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 258: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy181, false); }
        break;
      case 259: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[0].minor.yy181, true); }
        break;
      case 260: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, yymsp[0].minor.yy778, false); }
        break;
      case 261: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, yymsp[0].minor.yy778, true); }
        break;
      case 262: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 263: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 264: /* cmd ::= DESC full_table_name */
      case 265: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==265);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 266: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 267: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy39, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 269: /* analyze_opt ::= ANALYZE */
      case 276: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==276);
      case 450: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==450);
{ yymsp[0].minor.yy39 = true; }
        break;
      case 270: /* explain_options ::= */
{ yymsp[1].minor.yy778 = createDefaultExplainOptions(pCxt); }
        break;
      case 271: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy778 = setExplainVerbose(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 272: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy778 = setExplainRatio(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 273: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-8].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy380, yymsp[0].minor.yy276); }
        break;
      case 274: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 279: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy39, &yymsp[-7].minor.yy181, yymsp[-4].minor.yy778, yymsp[-6].minor.yy778, yymsp[-3].minor.yy282, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 280: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 282: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 283: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 284: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 286: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 288: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 474: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==474);
      case 492: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==492);
{ yymsp[-3].minor.yy778 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy778); }
        break;
      case 289: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 290: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 291: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 292: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 293: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 294: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy282); }
        break;
      case 295: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 296: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 298: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 300: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy778, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 301: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 302: /* literal ::= NK_INTEGER */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 303: /* literal ::= NK_FLOAT */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 304: /* literal ::= NK_STRING */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 305: /* literal ::= NK_BOOL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 306: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 307: /* literal ::= duration_literal */
      case 317: /* signed_literal ::= signed */ yytestcase(yyruleno==317);
      case 337: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==337);
      case 338: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==338);
      case 339: /* expression ::= literal */ yytestcase(yyruleno==339);
      case 340: /* expression ::= pseudo_column */ yytestcase(yyruleno==340);
      case 341: /* expression ::= column_reference */ yytestcase(yyruleno==341);
      case 342: /* expression ::= function_expression */ yytestcase(yyruleno==342);
      case 343: /* expression ::= case_when_expression */ yytestcase(yyruleno==343);
      case 373: /* function_expression ::= literal_func */ yytestcase(yyruleno==373);
      case 422: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==422);
      case 426: /* boolean_primary ::= predicate */ yytestcase(yyruleno==426);
      case 428: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==428);
      case 429: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==429);
      case 432: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==432);
      case 434: /* table_reference ::= table_primary */ yytestcase(yyruleno==434);
      case 435: /* table_reference ::= joined_table */ yytestcase(yyruleno==435);
      case 439: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==439);
      case 494: /* query_simple ::= query_specification */ yytestcase(yyruleno==494);
      case 495: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==495);
      case 498: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==498);
      case 500: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==500);
{ yylhsminor.yy778 = yymsp[0].minor.yy778; }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 308: /* literal ::= NULL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 309: /* literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 310: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 311: /* signed ::= NK_INTEGER */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 312: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 313: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 314: /* signed ::= NK_FLOAT */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 315: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 316: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 318: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 319: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 320: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 321: /* signed_literal ::= duration_literal */
      case 323: /* signed_literal ::= literal_func */ yytestcase(yyruleno==323);
      case 393: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==393);
      case 455: /* select_item ::= common_expression */ yytestcase(yyruleno==455);
      case 465: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==465);
      case 499: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==499);
      case 501: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==501);
      case 514: /* search_condition ::= common_expression */ yytestcase(yyruleno==514);
{ yylhsminor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 322: /* signed_literal ::= NULL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 324: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 344: /* expression ::= NK_LP expression NK_RP */
      case 427: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==427);
      case 513: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==513);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 345: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy778));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 346: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 347: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 348: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 349: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 350: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 351: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 352: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 353: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 354: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 357: /* column_reference ::= column_name */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy181, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 358: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 359: /* pseudo_column ::= ROWTS */
      case 360: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==360);
      case 362: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==362);
      case 363: /* pseudo_column ::= QEND */ yytestcase(yyruleno==363);
      case 364: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==364);
      case 365: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==365);
      case 366: /* pseudo_column ::= WEND */ yytestcase(yyruleno==366);
      case 367: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==367);
      case 368: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==368);
      case 369: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==369);
      case 375: /* literal_func ::= NOW */ yytestcase(yyruleno==375);
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 361: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy181)))); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 370: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 371: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==371);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 372: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy380)); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 374: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy181, NULL)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 389: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy282 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 394: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 458: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==458);
{ yylhsminor.yy778 = createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 395: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 396: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 399: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy778 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
        break;
      case 401: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
        break;
      case 402: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 407: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==407);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy682, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 403: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 404: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 405: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), NULL));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 406: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL));
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 408: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_THAN; }
        break;
      case 409: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_THAN; }
        break;
      case 410: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 411: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 412: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy682 = OP_TYPE_NOT_EQUAL; }
        break;
      case 413: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy682 = OP_TYPE_EQUAL; }
        break;
      case 414: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy682 = OP_TYPE_LIKE; }
        break;
      case 415: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_LIKE; }
        break;
      case 416: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_MATCH; }
        break;
      case 417: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_NMATCH; }
        break;
      case 418: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy682 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 419: /* in_op ::= IN */
{ yymsp[0].minor.yy682 = OP_TYPE_IN; }
        break;
      case 420: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_IN; }
        break;
      case 421: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 423: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 424: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 425: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 431: /* from_clause_opt ::= FROM table_reference_list */
      case 460: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==460);
      case 488: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==488);
{ yymsp[-1].minor.yy778 = yymsp[0].minor.yy778; }
        break;
      case 433: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 436: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 437: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 438: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy778 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 440: /* alias_opt ::= */
{ yymsp[1].minor.yy181 = nil_token;  }
        break;
      case 441: /* alias_opt ::= table_alias */
{ yylhsminor.yy181 = yymsp[0].minor.yy181; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 442: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy181 = yymsp[0].minor.yy181; }
        break;
      case 443: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 444: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==444);
{ yymsp[-2].minor.yy778 = yymsp[-1].minor.yy778; }
        break;
      case 445: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, yymsp[-4].minor.yy202, yymsp[-5].minor.yy778, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 446: /* join_type ::= */
{ yymsp[1].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 447: /* join_type ::= INNER */
{ yymsp[0].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 448: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy778 = createSelectStmt(pCxt, yymsp[-10].minor.yy39, yymsp[-9].minor.yy282, yymsp[-8].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addWhereClause(pCxt, yymsp[-11].minor.yy778, yymsp[-7].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addPartitionByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-6].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy778, yymsp[-2].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addGroupByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-1].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addHavingClause(pCxt, yymsp[-11].minor.yy778, yymsp[0].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addRangeClause(pCxt, yymsp[-11].minor.yy778, yymsp[-5].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addEveryClause(pCxt, yymsp[-11].minor.yy778, yymsp[-4].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addFillClause(pCxt, yymsp[-11].minor.yy778, yymsp[-3].minor.yy778);
                                                                                  }
        break;
      case 451: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy39 = false; }
        break;
      case 454: /* select_item ::= NK_STAR */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 456: /* select_item ::= common_expression column_alias */
      case 466: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==466);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 457: /* select_item ::= common_expression AS column_alias */
      case 467: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==467);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 462: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 484: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==484);
      case 503: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==503);
{ yymsp[-2].minor.yy282 = yymsp[0].minor.yy282; }
        break;
      case 469: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy778 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 470: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy778 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 471: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 472: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 476: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy778 = createFillNode(pCxt, yymsp[-1].minor.yy381, NULL); }
        break;
      case 477: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy778 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
        break;
      case 478: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy381 = FILL_MODE_NONE; }
        break;
      case 479: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy381 = FILL_MODE_PREV; }
        break;
      case 480: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy381 = FILL_MODE_NULL; }
        break;
      case 481: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy381 = FILL_MODE_LINEAR; }
        break;
      case 482: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy381 = FILL_MODE_NEXT; }
        break;
      case 485: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy282 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 486: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 490: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy778 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 493: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy778 = addOrderByClause(pCxt, yymsp[-3].minor.yy778, yymsp[-2].minor.yy282);
                                                                                    yylhsminor.yy778 = addSlimitClause(pCxt, yylhsminor.yy778, yymsp[-1].minor.yy778);
                                                                                    yylhsminor.yy778 = addLimitClause(pCxt, yylhsminor.yy778, yymsp[0].minor.yy778);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 496: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 497: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 505: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 509: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==509);
{ yymsp[-1].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 506: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 510: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==510);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 507: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 511: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==511);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 512: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 517: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy778 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), yymsp[-1].minor.yy14, yymsp[0].minor.yy305); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 518: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 519: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 520: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 521: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy305 = NULL_ORDER_DEFAULT; }
        break;
      case 522: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_FIRST; }
        break;
      case 523: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
