/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 383
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int64_t yy59;
  SNode* yy160;
  SNodeList* yy180;
  SAlterOption yy189;
  SDataType yy190;
  SToken yy231;
  ENullOrder yy283;
  EFillMode yy338;
  int8_t yy425;
  int32_t yy516;
  EOperatorType yy598;
  bool yy611;
  EJoinType yy652;
  EOrder yy742;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             675
#define YYNRULE              494
#define YYNTOKEN             260
#define YY_MAX_SHIFT         674
#define YY_MIN_SHIFTREDUCE   982
#define YY_MAX_SHIFTREDUCE   1475
#define YY_ERROR_ACTION      1476
#define YY_ACCEPT_ACTION     1477
#define YY_NO_ACTION         1478
#define YY_MIN_REDUCE        1479
#define YY_MAX_REDUCE        1972
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2541)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   442, 1950,  443, 1514, 1720,   64, 1610,  329,  450,  557,
 /*    10 */   443, 1514,   39,   37, 1949,  143, 1502, 1789, 1947, 1950,
 /*    20 */   342, 1480, 1275,  522, 1621,   40,   38,   36,   35,   34,
 /*    30 */  1806,  328,  163, 1352, 1717, 1273, 1947,  124, 1301, 1032,
 /*    40 */  1015, 1031,  104, 1785, 1791,  103,  102,  101,  100,   99,
 /*    50 */    98,   97,   96,   95,  447,  579, 1347, 1775, 1824,  347,
 /*    60 */  1298,   14, 1664, 1666,  393,   88,  586, 1501, 1281, 1033,
 /*    70 */  1032, 1775, 1031,  585,   39,   37, 1415,  122,  121,  143,
 /*    80 */  1019, 1020,  342, 1541, 1275,  478, 1611,  562, 1622,    1,
 /*    90 */    63,  559,  158, 1892, 1893, 1352, 1897, 1273, 1838,  534,
 /*   100 */  1033,  305,   91, 1807,  588, 1809, 1810,  584, 1775,  579,
 /*   110 */    55,  671, 1884,   36,   35,   34,  308, 1880, 1347,  459,
 /*   120 */   560,   30,  263,   14,  560, 1354, 1355, 1619, 1950,  104,
 /*   130 */  1281,  211,  103,  102,  101,  100,   99,   98,   97,   96,
 /*   140 */    95,  164,  560, 1170, 1171, 1947,  648,  647,  646,  645,
 /*   150 */   352,    2,  644,  643,  642,  125,  637,  636,  635,  634,
 /*   160 */   633,  632,  631,  630,  136,  626,  351,  350,  623,  622,
 /*   170 */  1276, 1899, 1274,  671,  224,  225,  147,   33,   32, 1950,
 /*   180 */  1579,   40,   38,   36,   35,   34, 1300, 1354, 1355,   43,
 /*   190 */    75,  307, 1948,   42,  524, 1896, 1947, 1279, 1280,  387,
 /*   200 */  1329, 1330, 1332, 1333, 1334, 1335, 1336, 1337,  581,  577,
 /*   210 */  1345, 1346, 1348, 1349, 1350, 1351, 1353, 1356, 1479,   63,
 /*   220 */    33,   32, 1597,  218,   40,   38,   36,   35,   34,   73,
 /*   230 */   165,  165, 1276, 1595, 1274,  307,   11,   10,  524, 1275,
 /*   240 */  1950,  428,  113,  112,  111,  110,  109,  108,  107,  106,
 /*   250 */   105, 1615, 1273,  162, 1436,   63,   63, 1947,   77, 1279,
 /*   260 */  1280,  378, 1329, 1330, 1332, 1333, 1334, 1335, 1336, 1337,
 /*   270 */   581,  577, 1345, 1346, 1348, 1349, 1350, 1351, 1353, 1356,
 /*   280 */    39,   37,  459,  380,  376, 1281,  617, 1824,  342, 1662,
 /*   290 */  1275,  177,  176,  621, 1806,  550,  543, 1434, 1435, 1437,
 /*   300 */  1438, 1352, 1446, 1273, 1128,  610,  609,  608, 1132,  607,
 /*   310 */  1134, 1135,  606, 1137,  603,  345, 1143,  600, 1145, 1146,
 /*   320 */   597,  594, 1824,  143, 1347, 1388,  546,  534,  671,   14,
 /*   330 */   586, 1472, 1621,  549,  165, 1775, 1281,  585,  167, 1301,
 /*   340 */    33,   32,   39,   37,   40,   38,   36,   35,   34,  557,
 /*   350 */   342,  562, 1275, 1302,  521, 1619,  145,    2, 1491, 1300,
 /*   360 */   165,   81, 1838, 1352,   63, 1273,   91, 1807,  588, 1809,
 /*   370 */  1810,  584,  534,  579,  534, 1806, 1884,  124,  173,  671,
 /*   380 */   308, 1880, 1612,  391,   49,  392, 1347, 1276, 1794, 1274,
 /*   390 */  1665, 1666, 1950, 1354, 1355, 1950,  165,  165, 1281, 1789,
 /*   400 */  1619,  223, 1619, 1824, 1500,  162,  552,  547,  162, 1947,
 /*   410 */    71,  586, 1947,   70, 1279, 1280, 1775,  122,  585,    8,
 /*   420 */  1090, 1471, 1426,   33,   32, 1785, 1791,   40,   38,   36,
 /*   430 */    35,   34,  159, 1892, 1893, 1899, 1897,  579, 1276,  618,
 /*   440 */  1274,  671, 1662, 1838,  386, 1775,  385,   93, 1807,  588,
 /*   450 */  1809, 1810,  584, 1092,  579, 1354, 1355, 1884,   22, 1895,
 /*   460 */  1499, 1883, 1880, 1254, 1255, 1279, 1280, 1531, 1329, 1330,
 /*   470 */  1332, 1333, 1334, 1335, 1336, 1337,  581,  577, 1345, 1346,
 /*   480 */  1348, 1349, 1350, 1351, 1353, 1356,  534,   33,   32,  492,
 /*   490 */   255,   40,   38,   36,   35,   34, 1716,  398,  302,  197,
 /*   500 */  1276, 1775, 1274,   33,   32,  165,  566,   40,   38,   36,
 /*   510 */    35,   34,  441,  149, 1619,  445,  488,  487,  476,  472,
 /*   520 */   468,  464,  196, 1806, 1715,  165,  302, 1279, 1280,  355,
 /*   530 */  1329, 1330, 1332, 1333, 1334, 1335, 1336, 1337,  581,  577,
 /*   540 */  1345, 1346, 1348, 1349, 1350, 1351, 1353, 1356,   39,   37,
 /*   550 */  1357, 1824, 1498,  304,   74, 1298,  342,  194, 1275,  561,
 /*   560 */   165, 1710,  421, 1412, 1775,  433,  585,   26,  551, 1352,
 /*   570 */  1950, 1273,  172,   33,   32,  505, 1497,   40,   38,   36,
 /*   580 */    35,   34,  406,  162,  434, 1314,  408, 1947,  503, 1496,
 /*   590 */   501, 1838, 1347, 1775,  156,   92, 1807,  588, 1809, 1810,
 /*   600 */   584, 1793,  579,  522, 1281, 1884, 1596, 1658, 1299,  333,
 /*   610 */  1880,  157, 1789,  534, 1718, 1495, 1806, 1775,  534,  193,
 /*   620 */   186,  534,  191,  399,  413,    9,  455, 1671, 1376,  414,
 /*   630 */  1775, 1911,  458,  575,  314,  395,  142,  534, 1785, 1791,
 /*   640 */   331, 1619, 1710, 1669, 1824,  184, 1619,  671,  114, 1619,
 /*   650 */   579, 1381,  586,  175, 1419,  480, 1775, 1775, 1594,  585,
 /*   660 */  1300, 1354, 1355,  432, 1494, 1619,  427,  426,  425,  424,
 /*   670 */   423,  420,  419,  418,  417,  416,  412,  411,  410,  409,
 /*   680 */   403,  402,  401,  400, 1838,  397,  396,   73,   92, 1807,
 /*   690 */   588, 1809, 1810,  584,   27,  579,  449, 1950, 1884,  445,
 /*   700 */   119, 1671,  333, 1880, 1963, 1775, 1276,  619, 1274, 1614,
 /*   710 */   163, 1899,  567, 1918, 1947,   33,   32, 1670,   61,   40,
 /*   720 */    38,   36,   35,   34,  621, 1493,  134,  133,  616,  615,
 /*   730 */   614,  641,  639, 1279, 1280, 1894, 1329, 1330, 1332, 1333,
 /*   740 */  1334, 1335, 1336, 1337,  581,  577, 1345, 1346, 1348, 1349,
 /*   750 */  1350, 1351, 1353, 1356,   39,   37,  496,  348,  674,  619,
 /*   760 */  1671, 1490,  342, 1281, 1275,  143, 1775,  330,  309, 1366,
 /*   770 */   354,  506,  270, 1489, 1621, 1352, 1669, 1273,  134,  133,
 /*   780 */   616,  615,  614,  613, 1488,  210,  154,  629,    7, 1591,
 /*   790 */  1411,  664,  660,  656,  652,  268, 1793, 1314, 1347,  499,
 /*   800 */   319, 1806, 1775,  493,  534, 1374,   28, 1789,  209, 1487,
 /*   810 */  1281, 1950,   33,   32, 1775,  114,   40,   38,   36,   35,
 /*   820 */    34, 1486,  485,  557,  162, 1775, 1303,   89, 1947, 1824,
 /*   830 */   233,    9, 1619, 1785, 1791,  337, 1300,  561,  534,  628,
 /*   840 */    58, 1331, 1775,   57,  585,  579, 1362, 1019, 1020, 1616,
 /*   850 */  1775,  124, 1300,  671, 1671,  320,  132,  318,  317, 1375,
 /*   860 */   482,  346, 1775,  531,  484, 1608, 1619, 1354, 1355, 1838,
 /*   870 */  1669, 1904, 1408,   92, 1807,  588, 1809, 1810,  584, 1485,
 /*   880 */   579, 1477, 1380, 1884,   44,    4,  483,  333, 1880,  157,
 /*   890 */   569,  122,   33,   32,  534,  220,   40,   38,   36,   35,
 /*   900 */    34,  161, 1544,   54, 1604, 1749,  160, 1892, 1893, 1910,
 /*   910 */  1897, 1606, 1276, 1284, 1274,  484, 1246, 1602,  213,  214,
 /*   920 */  1775,  275, 1619, 1484, 1649,   29,  340, 1369, 1370, 1371,
 /*   930 */  1372, 1373, 1377, 1378, 1379, 1483, 1482,  483,  580, 1279,
 /*   940 */  1280,  357, 1329, 1330, 1332, 1333, 1334, 1335, 1336, 1337,
 /*   950 */   581,  577, 1345, 1346, 1348, 1349, 1350, 1351, 1353, 1356,
 /*   960 */    39,   37,  564,  235, 1775,  619,  491,  490,  342,  202,
 /*   970 */  1275,  489,  200,  507,  120, 1283, 1775, 1775, 1408, 1806,
 /*   980 */   486, 1352, 1950, 1273,  134,  133,  616,  615,  614, 1761,
 /*   990 */   612,  534,  491,  490,  640,  162, 1526,  489,  534, 1947,
 /*  1000 */   120,  534,  515, 1524, 1347,  217,  486, 1824,  204,  519,
 /*  1010 */   206,  203,  532,  205, 1950,  586, 1281, 1331,  494, 1619,
 /*  1020 */  1775,  534,  585,  144,   41,  497, 1619,  162,  281, 1619,
 /*  1030 */   222, 1947,  533, 1331,  514,  208,  366,    2,  207, 1492,
 /*  1040 */    76,  381,  279,   60,   53,  518,   59, 1838,  258, 1619,
 /*  1050 */  1287,   92, 1807,  588, 1809, 1810,  584,  534,  579,  671,
 /*  1060 */   128, 1884,  180,  438,  436,  333, 1880, 1963,  264,  534,
 /*  1070 */   131, 1222,  132, 1354, 1355,   51, 1941,  226,  544,  239,
 /*  1080 */   349,   11,   10,   33,   32, 1619,   51,   40,   38,   36,
 /*  1090 */    35,   34, 1474, 1475,   63,   41, 1796, 1619,  570,   87,
 /*  1100 */    41,  624, 1059,  625, 1580,  477,  508,  527,  247,   84,
 /*  1110 */  1825,  353, 1286, 1515, 1659, 1914,  558,  232, 1276, 1121,
 /*  1120 */  1274,  252, 1433, 1078,  592, 1076,  242,  131,  132,  116,
 /*  1130 */   131, 1520,   90, 1382,  257, 1060,  309,  260,    3, 1798,
 /*  1140 */   262,    5, 1338, 1298,  358, 1279, 1280,  274, 1329, 1330,
 /*  1150 */  1332, 1333, 1334, 1335, 1336, 1337,  581,  577, 1345, 1346,
 /*  1160 */  1348, 1349, 1350, 1351, 1353, 1356,  361,   68,   67,  390,
 /*  1170 */  1090, 1149,  171, 1374, 1153, 1160, 1158,  135,  384,  666,
 /*  1180 */   315,  365,  339,  338,  316,  271, 1238,  174,  394, 1806,
 /*  1190 */   415,  303, 1289, 1712,  374,  429,  372,  368,  364,  168,
 /*  1200 */   359,  356,  422, 1352,  435, 1282,  430,  431,  437,  439,
 /*  1210 */  1304,  440,  448, 1307,  451, 1306,  183, 1824,  452,  185,
 /*  1220 */   453,  557, 1308,  456,  454,  586, 1347, 1375,  188,  190,
 /*  1230 */  1775, 1305,  585,  457,  192,  165,   72,  460, 1281,  195,
 /*  1240 */   479,  115,  306,  481,  272,  212, 1609,  199, 1605,  124,
 /*  1250 */  1380,  201,  509,  137,  138,  510, 1607, 1838,  215, 1603,
 /*  1260 */   139,   92, 1807,  588, 1809, 1810,  584,  140,  579,  516,
 /*  1270 */   562, 1884,  520,  219,  542,  333, 1880, 1963, 1754, 1806,
 /*  1280 */   528,  574,  230,  523,  513,  228, 1903, 1753,  129,  122,
 /*  1290 */   325, 1620, 1722,   29,  340, 1369, 1370, 1371, 1372, 1373,
 /*  1300 */  1377, 1378, 1379,  525,  253, 1892,  556, 1824,  555,  130,
 /*  1310 */   327, 1950,  273,   80,  530,  586, 1303,  529, 1915,  538,
 /*  1320 */  1775,  545,  585,  237,  164, 1925,  540,  541, 1947, 1806,
 /*  1330 */   332,  536,  548,    6,  241,  554,  562,  539,  537, 1408,
 /*  1340 */  1290,  251, 1285,  123, 1302,  571, 1900, 1838,  568, 1924,
 /*  1350 */  1906,  288, 1807,  588, 1809, 1810,  584, 1824,  579,  246,
 /*  1360 */   151,  248,  249,   48,  334,  586,   82, 1293, 1295, 1663,
 /*  1370 */  1775,  250,  585, 1966,  590, 1592,  276, 1950, 1865,  577,
 /*  1380 */  1345, 1346, 1348, 1349, 1350, 1351,  562,  267, 1946,  667,
 /*  1390 */   164,  565,   52,  668, 1947,  670, 1806, 1838,  572,  278,
 /*  1400 */   256,  288, 1807,  588, 1809, 1810,  584,  259,  579,  261,
 /*  1410 */   150, 1769,  280, 1806,  289, 1768,   65,  299, 1767, 1766,
 /*  1420 */  1765,  298,   66,  360, 1824, 1762,  362, 1950,  363, 1266,
 /*  1430 */   557, 1267,  586,  169,  367, 1760,  369, 1775,  370,  585,
 /*  1440 */   162, 1824,  371, 1759, 1947,  373, 1758,  375, 1757,  583,
 /*  1450 */  1756,  377,  379, 1739, 1775,  382,  585,  170,  124,  383,
 /*  1460 */  1241, 1240, 1733, 1732, 1838,  388,  389, 1806,   93, 1807,
 /*  1470 */   588, 1809, 1810,  584, 1731,  579, 1730, 1210, 1884,  562,
 /*  1480 */  1705, 1838,  573, 1880,  126,  296, 1807,  588, 1809, 1810,
 /*  1490 */   584,  582,  579,  576, 1856, 1824, 1704, 1703,  122, 1702,
 /*  1500 */    69, 1701, 1700,  586, 1699, 1698, 1697,  404, 1775, 1696,
 /*  1510 */   585,  407,  405,  253, 1892,  556, 1695,  555, 1694, 1693,
 /*  1520 */  1950, 1806, 1692, 1691, 1690, 1689, 1688, 1687, 1686, 1685,
 /*  1530 */  1684, 1683, 1682,  162,  127, 1838, 1212, 1947, 1681,  146,
 /*  1540 */  1807,  588, 1809, 1810,  584, 1806,  579, 1680, 1679, 1824,
 /*  1550 */  1678, 1677, 1676, 1675, 1674, 1673, 1672,  586, 1546,  178,
 /*  1560 */  1545, 1543, 1775,  179,  585, 1511,  444,  446, 1510, 1747,
 /*  1570 */  1741, 1806, 1729, 1824,  117,  181, 1022,  155,  326,  182,
 /*  1580 */  1021,  586,  118,  563, 1964,  187, 1775,  189,  585, 1838,
 /*  1590 */  1728, 1714, 1598,   93, 1807,  588, 1809, 1810,  584, 1824,
 /*  1600 */   579, 1542, 1052, 1884,  535, 1540,  461,  586, 1881, 1538,
 /*  1610 */   462,  466, 1775, 1838,  585,  463,  465,  297, 1807,  588,
 /*  1620 */  1809, 1810,  584,  467,  579, 1536,  470,  471,  469, 1806,
 /*  1630 */  1534,  473,  474,  475, 1523, 1522, 1507, 1600, 1164, 1838,
 /*  1640 */    50, 1806, 1163,  297, 1807,  588, 1809, 1810,  584, 1089,
 /*  1650 */   579, 1599, 1086,  198,  638,  640, 1085, 1824, 1532, 1527,
 /*  1660 */  1084,  321,  322, 1525,  495,  586,  323,  498, 1506, 1824,
 /*  1670 */  1775, 1505,  585, 1504,  504,   94,  500,  586,  502, 1746,
 /*  1680 */  1248, 1740, 1775,  511,  585, 1727,  141, 1725, 1726, 1724,
 /*  1690 */  1723, 1806,  221,   15,   56, 1721, 1258, 1838,  512,  216,
 /*  1700 */  1713,  292, 1807,  588, 1809, 1810,  584,  227,  579, 1838,
 /*  1710 */   234,   78,  231,  146, 1807,  588, 1809, 1810,  584, 1824,
 /*  1720 */   579,  229,   79,   84,  324,   16,   41,  583,  526,   47,
 /*  1730 */   245,   23, 1775, 1806,  585,  236,  517, 1448,  238,  553,
 /*  1740 */  1430,  244,  240, 1796, 1432, 1806,  148,   25,  254,  243,
 /*  1750 */    46,   24, 1795,   18,  152, 1425,   83, 1806, 1965, 1838,
 /*  1760 */  1460, 1824, 1405,  296, 1807,  588, 1809, 1810,  584,  586,
 /*  1770 */   579, 1459, 1857, 1824, 1775,  335,  585, 1464,  341, 1463,
 /*  1780 */   336,  586, 1404,   17, 1465, 1824, 1775,   10,  585, 1454,
 /*  1790 */   343, 1291, 1367,  586,   19, 1342,  153, 1322, 1775, 1806,
 /*  1800 */   585, 1838,   45, 1841,  578,  282, 1807,  588, 1809, 1810,
 /*  1810 */   584, 1340,  579, 1838,   13,   31,   12,  297, 1807,  588,
 /*  1820 */  1809, 1810,  584, 1339,  579, 1838,   20, 1824,  166,  297,
 /*  1830 */  1807,  588, 1809, 1810,  584,  586,  579,   21,  589, 1150,
 /*  1840 */  1775,  591,  585,  344,  593,  595, 1147,  596,  598, 1144,
 /*  1850 */   599,  601, 1806, 1138,  602,  587, 1136,  604, 1127,  605,
 /*  1860 */  1142,  611, 1806,   85, 1159, 1141, 1140, 1838,   86,   62,
 /*  1870 */  1139,  283, 1807,  588, 1809, 1810,  584,  265,  579, 1155,
 /*  1880 */  1824, 1050,  620, 1081, 1080, 1079, 1077, 1075,  586,  627,
 /*  1890 */  1824, 1096, 1070, 1775, 1073,  585, 1072,  266,  586, 1071,
 /*  1900 */  1069, 1068, 1067, 1775, 1066,  585, 1093, 1091, 1063, 1062,
 /*  1910 */  1061, 1058, 1806, 1057, 1056, 1055, 1539,  649,  650, 1537,
 /*  1920 */  1838,  653,  651,  655,  284, 1807,  588, 1809, 1810,  584,
 /*  1930 */  1838,  579,  654, 1806,  291, 1807,  588, 1809, 1810,  584,
 /*  1940 */  1824,  579, 1535,  657,  658, 1533,  659,  661,  586,  662,
 /*  1950 */   663, 1521,  665, 1775, 1503,  585, 1012,  269,  669,  673,
 /*  1960 */  1277, 1824,  277, 1478,  672, 1478, 1478, 1478, 1478,  586,
 /*  1970 */  1478, 1478, 1478, 1478, 1775, 1478,  585, 1478, 1478, 1478,
 /*  1980 */  1838, 1478, 1478, 1806,  293, 1807,  588, 1809, 1810,  584,
 /*  1990 */  1478,  579, 1478, 1478, 1478, 1478, 1478, 1806, 1478, 1478,
 /*  2000 */  1478, 1838, 1478, 1478, 1478,  285, 1807,  588, 1809, 1810,
 /*  2010 */   584, 1824,  579, 1478, 1478, 1478, 1478, 1478, 1478,  586,
 /*  2020 */  1478, 1478, 1478, 1478, 1775, 1824,  585, 1478, 1478, 1478,
 /*  2030 */  1478, 1478, 1478,  586, 1478, 1478, 1478, 1478, 1775, 1478,
 /*  2040 */   585, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1806,
 /*  2050 */  1478, 1838, 1478, 1478, 1478,  294, 1807,  588, 1809, 1810,
 /*  2060 */   584, 1478,  579, 1806, 1478, 1838, 1478, 1478, 1478,  286,
 /*  2070 */  1807,  588, 1809, 1810,  584, 1478,  579, 1824, 1478, 1478,
 /*  2080 */  1478, 1478, 1478, 1478, 1478,  586, 1478, 1478, 1478, 1478,
 /*  2090 */  1775, 1824,  585, 1478, 1478, 1478, 1478, 1478, 1478,  586,
 /*  2100 */  1478, 1478, 1478, 1478, 1775, 1478,  585, 1478, 1478, 1478,
 /*  2110 */  1478, 1478, 1478, 1478, 1478, 1478, 1806, 1838, 1478, 1478,
 /*  2120 */  1478,  295, 1807,  588, 1809, 1810,  584, 1478,  579, 1478,
 /*  2130 */  1478, 1838, 1478, 1478, 1478,  287, 1807,  588, 1809, 1810,
 /*  2140 */   584, 1478,  579, 1478, 1824, 1478, 1478, 1478, 1478, 1478,
 /*  2150 */  1478, 1478,  586, 1478, 1478, 1478, 1478, 1775, 1478,  585,
 /*  2160 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1806,
 /*  2170 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*  2180 */  1478, 1478, 1478, 1478, 1838, 1478, 1478, 1478,  300, 1807,
 /*  2190 */   588, 1809, 1810,  584, 1478,  579, 1478, 1824, 1478, 1478,
 /*  2200 */  1478, 1478, 1478, 1478, 1478,  586, 1478, 1478, 1478, 1478,
 /*  2210 */  1775, 1478,  585, 1478, 1478, 1478, 1478, 1478, 1478, 1806,
 /*  2220 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*  2230 */  1478, 1478, 1478, 1806, 1478, 1478, 1478, 1838, 1478, 1478,
 /*  2240 */  1478,  301, 1807,  588, 1809, 1810,  584, 1824,  579, 1478,
 /*  2250 */  1478, 1478, 1478, 1478, 1478,  586, 1478, 1478, 1478, 1478,
 /*  2260 */  1775, 1824,  585, 1478, 1478, 1478, 1478, 1478, 1478,  586,
 /*  2270 */  1478, 1478, 1478, 1478, 1775, 1806,  585, 1478, 1478, 1478,
 /*  2280 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1838, 1478, 1806,
 /*  2290 */  1478, 1818, 1807,  588, 1809, 1810,  584, 1478,  579, 1478,
 /*  2300 */  1478, 1838, 1478, 1824, 1478, 1817, 1807,  588, 1809, 1810,
 /*  2310 */   584,  586,  579, 1478, 1478, 1478, 1775, 1824,  585, 1478,
 /*  2320 */  1478, 1478, 1478, 1478, 1478,  586, 1478, 1478, 1478, 1478,
 /*  2330 */  1775, 1478,  585, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*  2340 */  1478, 1806, 1478, 1838, 1478, 1478, 1478, 1816, 1807,  588,
 /*  2350 */  1809, 1810,  584, 1478,  579, 1806, 1478, 1838, 1478, 1478,
 /*  2360 */  1478,  312, 1807,  588, 1809, 1810,  584, 1478,  579, 1824,
 /*  2370 */  1478, 1478, 1478, 1478, 1478, 1478, 1478,  586, 1478, 1478,
 /*  2380 */  1478, 1478, 1775, 1824,  585, 1478, 1478, 1478, 1478, 1478,
 /*  2390 */  1478,  586, 1478, 1478, 1478, 1478, 1775, 1478,  585, 1478,
 /*  2400 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1806, 1838,
 /*  2410 */  1478, 1478, 1478,  311, 1807,  588, 1809, 1810,  584, 1478,
 /*  2420 */   579, 1478, 1478, 1838, 1478, 1478, 1478,  313, 1807,  588,
 /*  2430 */  1809, 1810,  584, 1478,  579, 1478, 1824, 1478, 1478, 1478,
 /*  2440 */  1478, 1478, 1478, 1478,  586, 1478, 1478, 1478, 1478, 1775,
 /*  2450 */  1478,  585, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*  2460 */  1478, 1806, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*  2470 */  1478, 1478, 1478, 1478, 1478, 1478, 1838, 1478, 1478, 1478,
 /*  2480 */   310, 1807,  588, 1809, 1810,  584, 1478,  579, 1478, 1824,
 /*  2490 */  1478, 1478, 1478, 1478, 1478, 1478, 1478,  586, 1478, 1478,
 /*  2500 */  1478, 1478, 1775, 1478,  585, 1478, 1478, 1478, 1478, 1478,
 /*  2510 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*  2520 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1838,
 /*  2530 */  1478, 1478, 1478,  290, 1807,  588, 1809, 1810,  584, 1478,
 /*  2540 */   579,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   267,  361,  269,  270,    0,    4,  293,  283,  267,  271,
 /*    10 */   269,  270,   12,   13,  374,  291,  263,  304,  378,  361,
 /*    20 */    20,    0,   22,  306,  300,   12,   13,   14,   15,   16,
 /*    30 */   263,  314,  374,   33,  317,   35,  378,  299,   20,   20,
 /*    40 */     4,   22,   21,  330,  331,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,   14,  342,   56,  304,  291,  302,
 /*    60 */    20,   61,  305,  306,  271,  273,  299,  263,   68,   50,
 /*    70 */    20,  304,   22,  306,   12,   13,   14,  339,  286,  291,
 /*    80 */    44,   45,   20,    0,   22,   35,  294,  320,  300,   89,
 /*    90 */    89,  353,  354,  355,  356,   33,  358,   35,  331,  271,
 /*   100 */    50,  308,  335,  336,  337,  338,  339,  340,  304,  342,
 /*   110 */   282,  111,  345,   14,   15,   16,  349,  350,   56,   60,
 /*   120 */    20,  346,  347,   61,   20,  125,  126,  299,  361,   21,
 /*   130 */    68,  121,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   140 */    32,  374,   20,  125,  126,  378,   63,   64,   65,   66,
 /*   150 */    67,   89,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   160 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   170 */   170,  333,  172,  111,  120,  121,  276,    8,    9,  361,
 /*   180 */   280,   12,   13,   14,   15,   16,   20,  125,  126,   89,
 /*   190 */   180,  181,  374,   89,  184,  357,  378,  197,  198,  320,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,    0,   89,
 /*   220 */     8,    9,    0,   56,   12,   13,   14,   15,   16,  275,
 /*   230 */   230,  230,  170,    0,  172,  181,    1,    2,  184,   22,
 /*   240 */   361,   79,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   250 */    32,  297,   35,  374,  197,   89,   89,  378,   91,  197,
 /*   260 */   198,  165,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   270 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   280 */    12,   13,   60,  187,  188,   68,  301,  291,   20,  304,
 /*   290 */    22,  129,  130,   60,  263,  299,  239,  240,  241,  242,
 /*   300 */   243,   33,   90,   35,  102,  103,  104,  105,  106,  107,
 /*   310 */   108,  109,  110,  111,  112,  283,  114,  115,  116,  117,
 /*   320 */   118,  119,  291,  291,   56,   90,  155,  271,  111,   61,
 /*   330 */   299,  162,  300,  337,  230,  304,   68,  306,  282,   20,
 /*   340 */     8,    9,   12,   13,   12,   13,   14,   15,   16,  271,
 /*   350 */    20,  320,   22,   20,  320,  299,  262,   89,  264,   20,
 /*   360 */   230,  273,  331,   33,   89,   35,  335,  336,  337,  338,
 /*   370 */   339,  340,  271,  342,  271,  263,  345,  299,   56,  111,
 /*   380 */   349,  350,  294,  282,   89,  282,   56,  170,  293,  172,
 /*   390 */   305,  306,  361,  125,  126,  361,  230,  230,   68,  304,
 /*   400 */   299,  120,  299,  291,  263,  374,  235,  236,  374,  378,
 /*   410 */    88,  299,  378,   91,  197,  198,  304,  339,  306,   89,
 /*   420 */    35,  252,   90,    8,    9,  330,  331,   12,   13,   14,
 /*   430 */    15,   16,  354,  355,  356,  333,  358,  342,  170,  301,
 /*   440 */   172,  111,  304,  331,  169,  304,  171,  335,  336,  337,
 /*   450 */   338,  339,  340,   68,  342,  125,  126,  345,   43,  357,
 /*   460 */   263,  349,  350,  182,  183,  197,  198,    0,  200,  201,
 /*   470 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  271,    8,    9,   22,
 /*   490 */   157,   12,   13,   14,   15,   16,  316,  282,  318,   33,
 /*   500 */   170,  304,  172,    8,    9,  230,   43,   12,   13,   14,
 /*   510 */    15,   16,  268,   47,  299,  271,  277,  278,   52,   53,
 /*   520 */    54,   55,   56,  263,  316,  230,  318,  197,  198,  320,
 /*   530 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   540 */   210,  211,  212,  213,  214,  215,  216,  217,   12,   13,
 /*   550 */    14,  291,  263,   18,   88,   20,   20,   91,   22,  299,
 /*   560 */   230,  299,   27,    4,  304,   30,  306,    2,   20,   33,
 /*   570 */   361,   35,  310,    8,    9,   21,  263,   12,   13,   14,
 /*   580 */    15,   16,   47,  374,   49,   90,   51,  378,   34,  263,
 /*   590 */    36,  331,   56,  304,  290,  335,  336,  337,  338,  339,
 /*   600 */   340,  293,  342,  306,   68,  345,    0,  303,   20,  349,
 /*   610 */   350,  351,  304,  271,  317,  263,  263,  304,  271,  153,
 /*   620 */   154,  271,  156,   88,  282,   89,  160,  291,  152,  282,
 /*   630 */   304,  371,  282,   61,  298,  100,  157,  271,  330,  331,
 /*   640 */   332,  299,  299,  307,  291,  179,  299,  111,  282,  299,
 /*   650 */   342,  175,  299,  310,   14,  289,  304,  304,    0,  306,
 /*   660 */    20,  125,  126,  128,  263,  299,  131,  132,  133,  134,
 /*   670 */   135,  136,  137,  138,  139,  140,  141,  142,  143,  144,
 /*   680 */   145,  146,  147,  148,  331,  150,  151,  275,  335,  336,
 /*   690 */   337,  338,  339,  340,  218,  342,  268,  361,  345,  271,
 /*   700 */   288,  291,  349,  350,  351,  304,  170,  101,  172,  297,
 /*   710 */   374,  333,  249,  360,  378,    8,    9,  307,    3,   12,
 /*   720 */    13,   14,   15,   16,   60,  263,  120,  121,  122,  123,
 /*   730 */   124,  277,  278,  197,  198,  357,  200,  201,  202,  203,
 /*   740 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,   12,   13,    4,  283,   19,  101,
 /*   760 */   291,  263,   20,   68,   22,  291,  304,  298,   61,  197,
 /*   770 */   320,   19,   33,  263,  300,   33,  307,   35,  120,  121,
 /*   780 */   122,  123,  124,  100,  263,   33,   47,  279,   39,  281,
 /*   790 */   231,   52,   53,   54,   55,   56,  293,   90,   56,   47,
 /*   800 */    37,  263,  304,   51,  271,   98,    2,  304,   56,  263,
 /*   810 */    68,  361,    8,    9,  304,  282,   12,   13,   14,   15,
 /*   820 */    16,  263,  289,  271,  374,  304,   20,   88,  378,  291,
 /*   830 */    91,   89,  299,  330,  331,  332,   20,  299,  271,   68,
 /*   840 */    88,  201,  304,   91,  306,  342,   14,   44,   45,  282,
 /*   850 */   304,  299,   20,  111,  291,   92,   43,   94,   95,  152,
 /*   860 */    97,  298,  304,  124,  101,  292,  299,  125,  126,  331,
 /*   870 */   307,  228,  229,  335,  336,  337,  338,  339,  340,  263,
 /*   880 */   342,  260,  175,  345,   42,   43,  123,  349,  350,  351,
 /*   890 */    43,  339,    8,    9,  271,  156,   12,   13,   14,   15,
 /*   900 */    16,  363,    0,   90,  292,  282,  354,  355,  356,  371,
 /*   910 */   358,  292,  170,   35,  172,  101,  177,  292,  179,  292,
 /*   920 */   304,  284,  299,  263,  287,  218,  219,  220,  221,  222,
 /*   930 */   223,  224,  225,  226,  227,  263,  263,  123,  292,  197,
 /*   940 */   198,  320,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   950 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   960 */    12,   13,  247,  157,  304,  101,   64,   65,   20,   93,
 /*   970 */    22,   69,   96,  320,   72,   35,  304,  304,  229,  263,
 /*   980 */    78,   33,  361,   35,  120,  121,  122,  123,  124,    0,
 /*   990 */   292,  271,   64,   65,   43,  374,    0,   69,  271,  378,
 /*  1000 */    72,  271,  282,    0,   56,   56,   78,  291,   93,  282,
 /*  1010 */    93,   96,  282,   96,  361,  299,   68,  201,   22,  299,
 /*  1020 */   304,  271,  306,   18,   43,   22,  299,  374,   23,  299,
 /*  1030 */    43,  378,  282,  201,  324,   93,   47,   89,   96,  264,
 /*  1040 */    91,   90,   37,   38,  157,  158,   41,  331,  381,  299,
 /*  1050 */   172,  335,  336,  337,  338,  339,  340,  271,  342,  111,
 /*  1060 */    43,  345,   57,   58,   59,  349,  350,  351,  282,  271,
 /*  1070 */    43,   90,   43,  125,  126,   43,  360,   90,  372,   43,
 /*  1080 */   282,    1,    2,    8,    9,  299,   43,   12,   13,   14,
 /*  1090 */    15,   16,  125,  126,   89,   43,   46,  299,  251,   89,
 /*  1100 */    43,   13,   35,   13,  280,  272,  327,   90,  368,   99,
 /*  1110 */   291,  272,  172,  270,  303,  334,  359,   90,  170,   90,
 /*  1120 */   172,  352,   90,   35,   43,   35,   90,   43,   43,   43,
 /*  1130 */    43,    0,  127,   90,  375,   68,   61,  375,  362,   89,
 /*  1140 */   375,  232,   90,   20,  329,  197,  198,   90,  200,  201,
 /*  1150 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*  1160 */   212,  213,  214,  215,  216,  217,  271,  162,  163,  164,
 /*  1170 */    35,   90,  167,   98,   90,   90,   90,   90,  173,   48,
 /*  1180 */   328,   47,   12,   13,  277,  322,  168,   42,  311,  263,
 /*  1190 */   271,  186,   22,  271,  189,  309,  191,  192,  193,  194,
 /*  1200 */   195,  196,  311,   33,  271,   35,  152,  309,  271,  271,
 /*  1210 */    20,  265,  265,   20,  326,   20,  275,  291,  306,  275,
 /*  1220 */   319,  271,   20,  319,  321,  299,   56,  152,  275,  275,
 /*  1230 */   304,   20,  306,  312,  275,  230,  275,  271,   68,  275,
 /*  1240 */   265,  271,  265,  291,  326,  273,  291,  291,  291,  299,
 /*  1250 */   175,  291,  178,  291,  291,  325,  291,  331,  273,  291,
 /*  1260 */   291,  335,  336,  337,  338,  339,  340,  291,  342,  271,
 /*  1270 */   320,  345,  271,  273,  237,  349,  350,  351,  304,  263,
 /*  1280 */   154,  111,  273,  304,  306,  299,  360,  304,  315,  339,
 /*  1290 */   319,  299,  304,  218,  219,  220,  221,  222,  223,  224,
 /*  1300 */   225,  226,  227,  304,  354,  355,  356,  291,  358,  315,
 /*  1310 */   304,  361,  287,  273,  312,  299,   20,  313,  334,  304,
 /*  1320 */   304,  238,  306,  315,  374,  367,  304,  304,  378,  263,
 /*  1330 */   304,  233,  304,  244,  315,  161,  320,  246,  245,  229,
 /*  1340 */   170,  329,  172,  299,   20,  250,  333,  331,  248,  367,
 /*  1350 */   370,  335,  336,  337,  338,  339,  340,  291,  342,  369,
 /*  1360 */   367,  366,  365,   89,  253,  299,   89,  197,  198,  304,
 /*  1370 */   304,  364,  306,  382,  295,  281,  271,  361,  348,  209,
 /*  1380 */   210,  211,  212,  213,  214,  215,  320,  273,  377,   36,
 /*  1390 */   374,  377,  323,  266,  378,  265,  263,  331,  377,  274,
 /*  1400 */   376,  335,  336,  337,  338,  339,  340,  376,  342,  376,
 /*  1410 */   318,    0,  261,  263,  285,    0,  180,  285,    0,    0,
 /*  1420 */     0,  285,   42,   76,  291,    0,   35,  361,  190,   35,
 /*  1430 */   271,   35,  299,   35,  190,    0,   35,  304,   35,  306,
 /*  1440 */   374,  291,  190,    0,  378,  190,    0,   35,    0,  299,
 /*  1450 */     0,   22,   35,    0,  304,  175,  306,   89,  299,  174,
 /*  1460 */   172,  170,    0,    0,  331,  166,  165,  263,  335,  336,
 /*  1470 */   337,  338,  339,  340,    0,  342,    0,   46,  345,  320,
 /*  1480 */     0,  331,  349,  350,   42,  335,  336,  337,  338,  339,
 /*  1490 */   340,  341,  342,  343,  344,  291,    0,    0,  339,    0,
 /*  1500 */   149,    0,    0,  299,    0,    0,    0,  144,  304,    0,
 /*  1510 */   306,  144,   35,  354,  355,  356,    0,  358,    0,    0,
 /*  1520 */   361,  263,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1530 */     0,    0,    0,  374,   42,  331,   22,  378,    0,  335,
 /*  1540 */   336,  337,  338,  339,  340,  263,  342,    0,    0,  291,
 /*  1550 */     0,    0,    0,    0,    0,    0,    0,  299,    0,   56,
 /*  1560 */     0,    0,  304,   56,  306,    0,   46,   46,    0,    0,
 /*  1570 */     0,  263,    0,  291,   39,   42,   14,   43,  296,   40,
 /*  1580 */    14,  299,   39,  379,  380,   39,  304,  161,  306,  331,
 /*  1590 */     0,    0,    0,  335,  336,  337,  338,  339,  340,  291,
 /*  1600 */   342,    0,   62,  345,  296,    0,   35,  299,  350,    0,
 /*  1610 */    47,   47,  304,  331,  306,   39,   35,  335,  336,  337,
 /*  1620 */   338,  339,  340,   39,  342,    0,   47,   39,   35,  263,
 /*  1630 */     0,   35,   47,   39,    0,    0,    0,    0,   35,  331,
 /*  1640 */    98,  263,   22,  335,  336,  337,  338,  339,  340,   35,
 /*  1650 */   342,    0,   35,   96,   43,   43,   35,  291,    0,    0,
 /*  1660 */    22,   22,   22,    0,   49,  299,   22,   35,    0,  291,
 /*  1670 */   304,    0,  306,    0,   22,   20,   35,  299,   35,    0,
 /*  1680 */    35,    0,  304,   22,  306,    0,  176,    0,    0,    0,
 /*  1690 */     0,  263,   90,   89,  157,    0,  185,  331,  157,  154,
 /*  1700 */     0,  335,  336,  337,  338,  339,  340,   89,  342,  331,
 /*  1710 */    46,   89,  153,  335,  336,  337,  338,  339,  340,  291,
 /*  1720 */   342,   39,   89,   99,  157,  234,   43,  299,  155,   43,
 /*  1730 */    46,   89,  304,  263,  306,   89,  159,   90,   90,  373,
 /*  1740 */    90,   43,   89,   46,   90,  263,   89,   43,   46,   89,
 /*  1750 */    43,   89,   46,   43,   46,   90,   89,  263,  380,  331,
 /*  1760 */    35,  291,   90,  335,  336,  337,  338,  339,  340,  299,
 /*  1770 */   342,   35,  344,  291,  304,   35,  306,   35,  296,   35,
 /*  1780 */    35,  299,   90,  234,   90,  291,  304,    2,  306,   90,
 /*  1790 */   296,   22,  197,  299,   43,   90,   46,   22,  304,  263,
 /*  1800 */   306,  331,  228,   89,   89,  335,  336,  337,  338,  339,
 /*  1810 */   340,   90,  342,  331,  234,   89,   89,  335,  336,  337,
 /*  1820 */   338,  339,  340,   90,  342,  331,   89,  291,   46,  335,
 /*  1830 */   336,  337,  338,  339,  340,  299,  342,   89,  100,   90,
 /*  1840 */   304,   35,  306,   35,   89,   35,   90,   89,   35,   90,
 /*  1850 */    89,   35,  263,   90,   89,  199,   90,   35,   22,   89,
 /*  1860 */   113,  101,  263,   89,   35,  113,  113,  331,   89,   89,
 /*  1870 */   113,  335,  336,  337,  338,  339,  340,   43,  342,   22,
 /*  1880 */   291,   62,   61,   35,   35,   35,   35,   35,  299,   87,
 /*  1890 */   291,   68,   22,  304,   35,  306,   35,   43,  299,   35,
 /*  1900 */    35,   22,   35,  304,   35,  306,   68,   35,   35,   35,
 /*  1910 */    35,   35,  263,   35,   22,   35,    0,   35,   47,    0,
 /*  1920 */   331,   35,   39,   39,  335,  336,  337,  338,  339,  340,
 /*  1930 */   331,  342,   47,  263,  335,  336,  337,  338,  339,  340,
 /*  1940 */   291,  342,    0,   35,   47,    0,   39,   35,  299,   47,
 /*  1950 */    39,    0,   35,  304,    0,  306,   35,   22,   21,   20,
 /*  1960 */    22,  291,   22,  383,   21,  383,  383,  383,  383,  299,
 /*  1970 */   383,  383,  383,  383,  304,  383,  306,  383,  383,  383,
 /*  1980 */   331,  383,  383,  263,  335,  336,  337,  338,  339,  340,
 /*  1990 */   383,  342,  383,  383,  383,  383,  383,  263,  383,  383,
 /*  2000 */   383,  331,  383,  383,  383,  335,  336,  337,  338,  339,
 /*  2010 */   340,  291,  342,  383,  383,  383,  383,  383,  383,  299,
 /*  2020 */   383,  383,  383,  383,  304,  291,  306,  383,  383,  383,
 /*  2030 */   383,  383,  383,  299,  383,  383,  383,  383,  304,  383,
 /*  2040 */   306,  383,  383,  383,  383,  383,  383,  383,  383,  263,
 /*  2050 */   383,  331,  383,  383,  383,  335,  336,  337,  338,  339,
 /*  2060 */   340,  383,  342,  263,  383,  331,  383,  383,  383,  335,
 /*  2070 */   336,  337,  338,  339,  340,  383,  342,  291,  383,  383,
 /*  2080 */   383,  383,  383,  383,  383,  299,  383,  383,  383,  383,
 /*  2090 */   304,  291,  306,  383,  383,  383,  383,  383,  383,  299,
 /*  2100 */   383,  383,  383,  383,  304,  383,  306,  383,  383,  383,
 /*  2110 */   383,  383,  383,  383,  383,  383,  263,  331,  383,  383,
 /*  2120 */   383,  335,  336,  337,  338,  339,  340,  383,  342,  383,
 /*  2130 */   383,  331,  383,  383,  383,  335,  336,  337,  338,  339,
 /*  2140 */   340,  383,  342,  383,  291,  383,  383,  383,  383,  383,
 /*  2150 */   383,  383,  299,  383,  383,  383,  383,  304,  383,  306,
 /*  2160 */   383,  383,  383,  383,  383,  383,  383,  383,  383,  263,
 /*  2170 */   383,  383,  383,  383,  383,  383,  383,  383,  383,  383,
 /*  2180 */   383,  383,  383,  383,  331,  383,  383,  383,  335,  336,
 /*  2190 */   337,  338,  339,  340,  383,  342,  383,  291,  383,  383,
 /*  2200 */   383,  383,  383,  383,  383,  299,  383,  383,  383,  383,
 /*  2210 */   304,  383,  306,  383,  383,  383,  383,  383,  383,  263,
 /*  2220 */   383,  383,  383,  383,  383,  383,  383,  383,  383,  383,
 /*  2230 */   383,  383,  383,  263,  383,  383,  383,  331,  383,  383,
 /*  2240 */   383,  335,  336,  337,  338,  339,  340,  291,  342,  383,
 /*  2250 */   383,  383,  383,  383,  383,  299,  383,  383,  383,  383,
 /*  2260 */   304,  291,  306,  383,  383,  383,  383,  383,  383,  299,
 /*  2270 */   383,  383,  383,  383,  304,  263,  306,  383,  383,  383,
 /*  2280 */   383,  383,  383,  383,  383,  383,  383,  331,  383,  263,
 /*  2290 */   383,  335,  336,  337,  338,  339,  340,  383,  342,  383,
 /*  2300 */   383,  331,  383,  291,  383,  335,  336,  337,  338,  339,
 /*  2310 */   340,  299,  342,  383,  383,  383,  304,  291,  306,  383,
 /*  2320 */   383,  383,  383,  383,  383,  299,  383,  383,  383,  383,
 /*  2330 */   304,  383,  306,  383,  383,  383,  383,  383,  383,  383,
 /*  2340 */   383,  263,  383,  331,  383,  383,  383,  335,  336,  337,
 /*  2350 */   338,  339,  340,  383,  342,  263,  383,  331,  383,  383,
 /*  2360 */   383,  335,  336,  337,  338,  339,  340,  383,  342,  291,
 /*  2370 */   383,  383,  383,  383,  383,  383,  383,  299,  383,  383,
 /*  2380 */   383,  383,  304,  291,  306,  383,  383,  383,  383,  383,
 /*  2390 */   383,  299,  383,  383,  383,  383,  304,  383,  306,  383,
 /*  2400 */   383,  383,  383,  383,  383,  383,  383,  383,  263,  331,
 /*  2410 */   383,  383,  383,  335,  336,  337,  338,  339,  340,  383,
 /*  2420 */   342,  383,  383,  331,  383,  383,  383,  335,  336,  337,
 /*  2430 */   338,  339,  340,  383,  342,  383,  291,  383,  383,  383,
 /*  2440 */   383,  383,  383,  383,  299,  383,  383,  383,  383,  304,
 /*  2450 */   383,  306,  383,  383,  383,  383,  383,  383,  383,  383,
 /*  2460 */   383,  263,  383,  383,  383,  383,  383,  383,  383,  383,
 /*  2470 */   383,  383,  383,  383,  383,  383,  331,  383,  383,  383,
 /*  2480 */   335,  336,  337,  338,  339,  340,  383,  342,  383,  291,
 /*  2490 */   383,  383,  383,  383,  383,  383,  383,  299,  383,  383,
 /*  2500 */   383,  383,  304,  383,  306,  383,  383,  383,  383,  383,
 /*  2510 */   383,  383,  383,  383,  383,  383,  383,  383,  383,  383,
 /*  2520 */   383,  383,  383,  383,  383,  383,  383,  383,  383,  331,
 /*  2530 */   383,  383,  383,  335,  336,  337,  338,  339,  340,  383,
 /*  2540 */   342,
};
#define YY_SHIFT_COUNT    (674)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1954)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1005,    0,    0,   62,   62,  268,  268,  268,  330,  330,
 /*    10 */   268,  268,  536,  742,  948,  742,  742,  742,  742,  742,
 /*    20 */   742,  742,  742,  742,  742,  742,  742,  742,  742,  742,
 /*    30 */   742,  742,  742,  742,  742,  742,  742,  742,  742,  742,
 /*    40 */   742,  742,  104,  104,  100,  100,  100, 1170, 1170,  166,
 /*    50 */  1170, 1170,  275,  167,  130,  295,  130,  122,  122,   36,
 /*    60 */    36,    1,   18,  130,  130,  122,  122,  122,  122,  122,
 /*    70 */   122,  122,  122,  122,   59,  122,  122,  122,  319,  339,
 /*    80 */   122,  122,  339,  548,  122,  339,  339,  339,  122,  664,
 /*    90 */   535,  707, 1075, 1075,  108,  217,  217,  217,  217,  217,
 /*   100 */   217,  217,  217,  217,  217,  217,  217,  217,  217,  217,
 /*   110 */   217,  217,  217,  217,  763,  928,   18,   40,   40,  222,
 /*   120 */   385,  233,  333,  333,  333,  385,  588,  588,  319,    4,
 /*   130 */     4,  339,  339,  695,  695,  683,  771,  202,  202,  202,
 /*   140 */   202,  202,  202,  202,  739,   21,  169,  902,   57,   50,
 /*   150 */    10,  171,  640,  832,   19,  803,  814,  806,  643,  749,
 /*   160 */   643,  842,  715,  715,  715,  559,  816,  909, 1123, 1134,
 /*   170 */  1135, 1018, 1145, 1123, 1123, 1145, 1054, 1054, 1123, 1123,
 /*   180 */  1123, 1190, 1190, 1193,   59,  319,   59, 1195, 1202,   59,
 /*   190 */  1195,   59, 1211,   59,   59, 1123,   59, 1190,  339,  339,
 /*   200 */   339,  339,  339,  339,  339,  339,  339,  339,  339, 1123,
 /*   210 */  1190,  695, 1193,  664, 1074,  319,  664, 1123, 1123, 1195,
 /*   220 */   664, 1037,  695,  695,  695,  695, 1037,  695, 1126,  588,
 /*   230 */  1211,  664,  683,  664,  588, 1296,  695, 1083, 1037,  695,
 /*   240 */   695, 1083, 1037,  695,  695,  339, 1089, 1174, 1083, 1091,
 /*   250 */  1093, 1098,  909, 1110,  588, 1324, 1095, 1100, 1111, 1095,
 /*   260 */  1100, 1095, 1100, 1274, 1277,  695,  771, 1123,  664, 1353,
 /*   270 */  1190, 2541, 2541, 2541, 2541, 2541, 2541, 2541,   83,  466,
 /*   280 */   218,  752,  212,  415,  332,  565,  804,  479,  495,  606,
 /*   290 */   884,  884,  884,  884,  884,  884,  884,  884,  658,  864,
 /*   300 */    13,   13,   54,   96,  322,  162,  554,  281,  235,  476,
 /*   310 */    99,   99,   99,   99,  813,  989,  951,  876,  915,  917,
 /*   320 */   942,  467,  996, 1003,  949,  887,  981,  987, 1017, 1027,
 /*   330 */  1029, 1032, 1036, 1080,  967,  463,  847, 1043,  878,  940,
 /*   340 */   572, 1052, 1050, 1057, 1081, 1084, 1085, 1086, 1087, 1010,
 /*   350 */  1088, 1090, 1067, 1131, 1411, 1415, 1236, 1418, 1419, 1380,
 /*   360 */  1420, 1347, 1425, 1391, 1238, 1394, 1396, 1398, 1244, 1435,
 /*   370 */  1401, 1403, 1252, 1443, 1255, 1446, 1412, 1448, 1429, 1450,
 /*   380 */  1417, 1453, 1368, 1280, 1285, 1288, 1291, 1462, 1463, 1299,
 /*   390 */  1301, 1474, 1476, 1431, 1480, 1442, 1496, 1497, 1499, 1351,
 /*   400 */  1501, 1502, 1504, 1505, 1506, 1363, 1477, 1509, 1367, 1516,
 /*   410 */  1518, 1519, 1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529,
 /*   420 */  1530, 1531, 1532, 1492, 1538, 1547, 1548, 1550, 1551, 1552,
 /*   430 */  1514, 1553, 1554, 1555, 1556, 1558, 1503, 1560, 1507, 1561,
 /*   440 */  1565, 1533, 1535, 1534, 1562, 1520, 1566, 1521, 1568, 1539,
 /*   450 */  1543, 1569, 1570, 1572, 1546, 1426, 1590, 1591, 1592, 1540,
 /*   460 */  1601, 1605, 1571, 1563, 1576, 1609, 1581, 1564, 1584, 1625,
 /*   470 */  1593, 1579, 1588, 1630, 1596, 1585, 1594, 1634, 1635, 1636,
 /*   480 */  1637, 1542, 1557, 1603, 1620, 1651, 1614, 1611, 1612, 1617,
 /*   490 */  1621, 1638, 1658, 1639, 1659, 1640, 1615, 1663, 1644, 1632,
 /*   500 */  1668, 1641, 1671, 1643, 1673, 1652, 1655, 1679, 1537, 1645,
 /*   510 */  1681, 1510, 1661, 1541, 1545, 1685, 1687, 1567, 1577, 1688,
 /*   520 */  1689, 1690, 1604, 1602, 1511, 1695, 1618, 1573, 1622, 1700,
 /*   530 */  1682, 1559, 1633, 1624, 1664, 1683, 1491, 1642, 1647, 1646,
 /*   540 */  1648, 1650, 1653, 1686, 1654, 1657, 1660, 1662, 1665, 1698,
 /*   550 */  1684, 1697, 1667, 1704, 1549, 1672, 1692, 1702, 1574, 1707,
 /*   560 */  1706, 1708, 1694, 1710, 1580, 1699, 1725, 1736, 1740, 1742,
 /*   570 */  1744, 1745, 1699, 1785, 1769, 1595, 1751, 1714, 1705, 1715,
 /*   580 */  1721, 1726, 1733, 1750, 1727, 1737, 1782, 1775, 1656, 1748,
 /*   590 */  1738, 1749, 1806, 1808, 1755, 1756, 1810, 1758, 1759, 1813,
 /*   600 */  1761, 1763, 1816, 1765, 1766, 1822, 1770, 1747, 1752, 1753,
 /*   610 */  1757, 1836, 1760, 1774, 1779, 1829, 1780, 1834, 1834, 1857,
 /*   620 */  1819, 1821, 1848, 1849, 1850, 1851, 1852, 1823, 1802, 1854,
 /*   630 */  1859, 1861, 1864, 1870, 1865, 1879, 1867, 1869, 1838, 1611,
 /*   640 */  1872, 1612, 1873, 1874, 1875, 1876, 1878, 1892, 1880, 1916,
 /*   650 */  1882, 1871, 1883, 1919, 1886, 1885, 1884, 1942, 1908, 1897,
 /*   660 */  1907, 1945, 1912, 1902, 1911, 1951, 1917, 1921, 1954, 1935,
 /*   670 */  1937, 1938, 1940, 1943, 1939,
};
#define YY_REDUCE_COUNT (277)
#define YY_REDUCE_MIN   (-360)
#define YY_REDUCE_MAX   (2198)
static const short yy_reduce_ofst[] = {
 /*     0 */   621, -233,   31,  538,  260,  353,  716,  926, 1016, 1066,
 /*    10 */   112, 1133, 1150, 1204, 1258, 1282, 1308, 1366, 1378, 1428,
 /*    20 */  1482, 1494, 1470, 1536, 1589, 1599, 1649, 1670, 1720, 1734,
 /*    30 */  1786, 1800, 1853, 1906, 1956, 1970, 2012, 2026, 2078, 2092,
 /*    40 */  2145, 2198,  950, 1159, -262,   78,  552,  308,  503,  336,
 /*    50 */  -287,   95, -121,   34,  209,  450,  653,  366,  533, -267,
 /*    60 */  -259, -360, -243, -342, -182, -172,   56,  101,  103,  215,
 /*    70 */   342,  347,  350,  567,  412,  623,  720,  727, -283, -276,
 /*    80 */   730,  750,  469,   -4,  786,   32,  563,  474,  798, -208,
 /*    90 */  -207, -225, -225, -225,   94, -247, -196,  141,  197,  289,
 /*   100 */   313,  326,  352,  401,  462,  498,  510,  521,  546,  558,
 /*   110 */   616,  660,  672,  673,  304, -100,   85,  244,  428,  -46,
 /*   120 */   239,   88, -162,  102,  378,  454,  262,  343,  297,  180,
 /*   130 */   208, -212,  410,  -15,  138,  637,  508,  573,  612,  619,
 /*   140 */   625,  627,  646,  698,  710,  775,  667,  824,  706,  833,
 /*   150 */   779,  740,  819,  819,  839,  843,  811,  781,  757,  757,
 /*   160 */   757,  769,  759,  762,  765,  776,  819,  815,  895,  852,
 /*   170 */   907,  863,  877,  919,  922,  891,  886,  898,  933,  937,
 /*   180 */   938,  946,  947,  888,  941,  912,  944,  901,  903,  953,
 /*   190 */   904,  954,  921,  959,  961,  966,  964,  975,  952,  955,
 /*   200 */   956,  957,  960,  962,  963,  965,  968,  969,  976,  970,
 /*   210 */   977,  974,  918,  972,  930,  978,  985,  998, 1001,  971,
 /*   220 */  1000,  973,  979,  983,  988,  999,  994, 1006, 1004,  986,
 /*   230 */  1002, 1009, 1025, 1040,  992,  984, 1015,  958, 1008, 1022,
 /*   240 */  1023,  982, 1019, 1026, 1028,  819,  980,  990,  993,  995,
 /*   250 */   997, 1007, 1012,  757, 1044, 1013, 1011, 1024,  991, 1014,
 /*   260 */  1031, 1021, 1033, 1030, 1079, 1065, 1094, 1105, 1114, 1127,
 /*   270 */  1130, 1069, 1092, 1129, 1132, 1136, 1125, 1151,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*    10 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*    20 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*    30 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*    40 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*    50 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*    60 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*    70 */  1476, 1476, 1476, 1476, 1550, 1476, 1476, 1476, 1476, 1476,
 /*    80 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1548,
 /*    90 */  1706, 1476, 1886, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   100 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   110 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1550,
 /*   120 */  1476, 1548, 1898, 1898, 1898, 1476, 1476, 1476, 1476, 1750,
 /*   130 */  1750, 1476, 1476, 1476, 1476, 1648, 1476, 1476, 1476, 1476,
 /*   140 */  1476, 1476, 1476, 1476, 1742, 1476, 1967, 1476, 1476, 1476,
 /*   150 */  1748, 1921, 1476, 1476, 1476, 1476, 1601, 1913, 1890, 1904,
 /*   160 */  1891, 1888, 1952, 1952, 1952, 1907, 1476, 1917, 1476, 1476,
 /*   170 */  1476, 1734, 1711, 1476, 1476, 1711, 1708, 1708, 1476, 1476,
 /*   180 */  1476, 1476, 1476, 1476, 1550, 1476, 1550, 1476, 1476, 1550,
 /*   190 */  1476, 1550, 1476, 1550, 1550, 1476, 1550, 1476, 1476, 1476,
 /*   200 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   210 */  1476, 1476, 1476, 1548, 1744, 1476, 1548, 1476, 1476, 1476,
 /*   220 */  1548, 1926, 1476, 1476, 1476, 1476, 1926, 1476, 1476, 1476,
 /*   230 */  1476, 1548, 1476, 1548, 1476, 1476, 1476, 1928, 1926, 1476,
 /*   240 */  1476, 1928, 1926, 1476, 1476, 1476, 1940, 1936, 1928, 1944,
 /*   250 */  1942, 1919, 1917, 1904, 1476, 1476, 1958, 1954, 1970, 1958,
 /*   260 */  1954, 1958, 1954, 1476, 1617, 1476, 1476, 1476, 1548, 1508,
 /*   270 */  1476, 1736, 1750, 1651, 1651, 1651, 1551, 1481, 1476, 1476,
 /*   280 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   290 */  1823, 1939, 1938, 1862, 1861, 1860, 1858, 1822, 1476, 1613,
 /*   300 */  1821, 1820, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   310 */  1814, 1815, 1813, 1812, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   320 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   330 */  1476, 1476, 1476, 1887, 1476, 1955, 1959, 1476, 1476, 1476,
 /*   340 */  1476, 1476, 1797, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   350 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   360 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   370 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   380 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   390 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   400 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   410 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   420 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   430 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   440 */  1476, 1476, 1476, 1513, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   450 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   460 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   470 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   480 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1585, 1584, 1476,
 /*   490 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   500 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   510 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   520 */  1476, 1476, 1476, 1476, 1476, 1754, 1476, 1476, 1476, 1476,
 /*   530 */  1476, 1476, 1476, 1476, 1476, 1920, 1476, 1476, 1476, 1476,
 /*   540 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   550 */  1476, 1797, 1476, 1937, 1476, 1897, 1893, 1476, 1476, 1889,
 /*   560 */  1796, 1476, 1476, 1953, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   570 */  1476, 1476, 1476, 1882, 1476, 1476, 1855, 1840, 1476, 1476,
 /*   580 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1808, 1476,
 /*   590 */  1476, 1476, 1476, 1476, 1645, 1476, 1476, 1476, 1476, 1476,
 /*   600 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1630, 1628, 1627,
 /*   610 */  1626, 1476, 1623, 1476, 1476, 1476, 1476, 1654, 1653, 1476,
 /*   620 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1571,
 /*   630 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1562,
 /*   640 */  1476, 1561, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   650 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   660 */  1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476, 1476,
 /*   670 */  1476, 1476, 1476, 1476, 1476,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  254,  /*  NK_BITNOT => ID */
  254,  /*     VALUES => ID */
  254,  /*     IMPORT => ID */
  254,  /*    NK_SEMI => ID */
  254,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "FSYNC",
  /*   70 */ "MAXROWS",
  /*   71 */ "MINROWS",
  /*   72 */ "KEEP",
  /*   73 */ "PAGES",
  /*   74 */ "PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "WAL",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_RETENTION_PERIOD",
  /*   84 */ "WAL_RETENTION_SIZE",
  /*   85 */ "WAL_ROLL_PERIOD",
  /*   86 */ "WAL_SEGMENT_SIZE",
  /*   87 */ "NK_COLON",
  /*   88 */ "TABLE",
  /*   89 */ "NK_LP",
  /*   90 */ "NK_RP",
  /*   91 */ "STABLE",
  /*   92 */ "ADD",
  /*   93 */ "COLUMN",
  /*   94 */ "MODIFY",
  /*   95 */ "RENAME",
  /*   96 */ "TAG",
  /*   97 */ "SET",
  /*   98 */ "NK_EQ",
  /*   99 */ "USING",
  /*  100 */ "TAGS",
  /*  101 */ "COMMENT",
  /*  102 */ "BOOL",
  /*  103 */ "TINYINT",
  /*  104 */ "SMALLINT",
  /*  105 */ "INT",
  /*  106 */ "INTEGER",
  /*  107 */ "BIGINT",
  /*  108 */ "FLOAT",
  /*  109 */ "DOUBLE",
  /*  110 */ "BINARY",
  /*  111 */ "TIMESTAMP",
  /*  112 */ "NCHAR",
  /*  113 */ "UNSIGNED",
  /*  114 */ "JSON",
  /*  115 */ "VARCHAR",
  /*  116 */ "MEDIUMBLOB",
  /*  117 */ "BLOB",
  /*  118 */ "VARBINARY",
  /*  119 */ "DECIMAL",
  /*  120 */ "MAX_DELAY",
  /*  121 */ "WATERMARK",
  /*  122 */ "ROLLUP",
  /*  123 */ "TTL",
  /*  124 */ "SMA",
  /*  125 */ "FIRST",
  /*  126 */ "LAST",
  /*  127 */ "SHOW",
  /*  128 */ "DATABASES",
  /*  129 */ "TABLES",
  /*  130 */ "STABLES",
  /*  131 */ "MNODES",
  /*  132 */ "MODULES",
  /*  133 */ "QNODES",
  /*  134 */ "FUNCTIONS",
  /*  135 */ "INDEXES",
  /*  136 */ "ACCOUNTS",
  /*  137 */ "APPS",
  /*  138 */ "CONNECTIONS",
  /*  139 */ "LICENCE",
  /*  140 */ "GRANTS",
  /*  141 */ "QUERIES",
  /*  142 */ "SCORES",
  /*  143 */ "TOPICS",
  /*  144 */ "VARIABLES",
  /*  145 */ "BNODES",
  /*  146 */ "SNODES",
  /*  147 */ "CLUSTER",
  /*  148 */ "TRANSACTIONS",
  /*  149 */ "DISTRIBUTED",
  /*  150 */ "CONSUMERS",
  /*  151 */ "SUBSCRIPTIONS",
  /*  152 */ "LIKE",
  /*  153 */ "INDEX",
  /*  154 */ "FUNCTION",
  /*  155 */ "INTERVAL",
  /*  156 */ "TOPIC",
  /*  157 */ "AS",
  /*  158 */ "WITH",
  /*  159 */ "META",
  /*  160 */ "CONSUMER",
  /*  161 */ "GROUP",
  /*  162 */ "DESC",
  /*  163 */ "DESCRIBE",
  /*  164 */ "RESET",
  /*  165 */ "QUERY",
  /*  166 */ "CACHE",
  /*  167 */ "EXPLAIN",
  /*  168 */ "ANALYZE",
  /*  169 */ "VERBOSE",
  /*  170 */ "NK_BOOL",
  /*  171 */ "RATIO",
  /*  172 */ "NK_FLOAT",
  /*  173 */ "COMPACT",
  /*  174 */ "VNODES",
  /*  175 */ "IN",
  /*  176 */ "OUTPUTTYPE",
  /*  177 */ "AGGREGATE",
  /*  178 */ "BUFSIZE",
  /*  179 */ "STREAM",
  /*  180 */ "INTO",
  /*  181 */ "TRIGGER",
  /*  182 */ "AT_ONCE",
  /*  183 */ "WINDOW_CLOSE",
  /*  184 */ "IGNORE",
  /*  185 */ "EXPIRED",
  /*  186 */ "KILL",
  /*  187 */ "CONNECTION",
  /*  188 */ "TRANSACTION",
  /*  189 */ "BALANCE",
  /*  190 */ "VGROUP",
  /*  191 */ "MERGE",
  /*  192 */ "REDISTRIBUTE",
  /*  193 */ "SPLIT",
  /*  194 */ "SYNCDB",
  /*  195 */ "DELETE",
  /*  196 */ "INSERT",
  /*  197 */ "NULL",
  /*  198 */ "NK_QUESTION",
  /*  199 */ "NK_ARROW",
  /*  200 */ "ROWTS",
  /*  201 */ "TBNAME",
  /*  202 */ "QSTART",
  /*  203 */ "QEND",
  /*  204 */ "QDURATION",
  /*  205 */ "WSTART",
  /*  206 */ "WEND",
  /*  207 */ "WDURATION",
  /*  208 */ "CAST",
  /*  209 */ "NOW",
  /*  210 */ "TODAY",
  /*  211 */ "TIMEZONE",
  /*  212 */ "CLIENT_VERSION",
  /*  213 */ "SERVER_VERSION",
  /*  214 */ "SERVER_STATUS",
  /*  215 */ "CURRENT_USER",
  /*  216 */ "COUNT",
  /*  217 */ "LAST_ROW",
  /*  218 */ "BETWEEN",
  /*  219 */ "IS",
  /*  220 */ "NK_LT",
  /*  221 */ "NK_GT",
  /*  222 */ "NK_LE",
  /*  223 */ "NK_GE",
  /*  224 */ "NK_NE",
  /*  225 */ "MATCH",
  /*  226 */ "NMATCH",
  /*  227 */ "CONTAINS",
  /*  228 */ "JOIN",
  /*  229 */ "INNER",
  /*  230 */ "SELECT",
  /*  231 */ "DISTINCT",
  /*  232 */ "WHERE",
  /*  233 */ "PARTITION",
  /*  234 */ "BY",
  /*  235 */ "SESSION",
  /*  236 */ "STATE_WINDOW",
  /*  237 */ "SLIDING",
  /*  238 */ "FILL",
  /*  239 */ "VALUE",
  /*  240 */ "NONE",
  /*  241 */ "PREV",
  /*  242 */ "LINEAR",
  /*  243 */ "NEXT",
  /*  244 */ "HAVING",
  /*  245 */ "RANGE",
  /*  246 */ "EVERY",
  /*  247 */ "ORDER",
  /*  248 */ "SLIMIT",
  /*  249 */ "SOFFSET",
  /*  250 */ "LIMIT",
  /*  251 */ "OFFSET",
  /*  252 */ "ASC",
  /*  253 */ "NULLS",
  /*  254 */ "ID",
  /*  255 */ "NK_BITNOT",
  /*  256 */ "VALUES",
  /*  257 */ "IMPORT",
  /*  258 */ "NK_SEMI",
  /*  259 */ "FILE",
  /*  260 */ "cmd",
  /*  261 */ "account_options",
  /*  262 */ "alter_account_options",
  /*  263 */ "literal",
  /*  264 */ "alter_account_option",
  /*  265 */ "user_name",
  /*  266 */ "sysinfo_opt",
  /*  267 */ "privileges",
  /*  268 */ "priv_level",
  /*  269 */ "priv_type_list",
  /*  270 */ "priv_type",
  /*  271 */ "db_name",
  /*  272 */ "dnode_endpoint",
  /*  273 */ "not_exists_opt",
  /*  274 */ "db_options",
  /*  275 */ "exists_opt",
  /*  276 */ "alter_db_options",
  /*  277 */ "integer_list",
  /*  278 */ "variable_list",
  /*  279 */ "retention_list",
  /*  280 */ "alter_db_option",
  /*  281 */ "retention",
  /*  282 */ "full_table_name",
  /*  283 */ "column_def_list",
  /*  284 */ "tags_def_opt",
  /*  285 */ "table_options",
  /*  286 */ "multi_create_clause",
  /*  287 */ "tags_def",
  /*  288 */ "multi_drop_clause",
  /*  289 */ "alter_table_clause",
  /*  290 */ "alter_table_options",
  /*  291 */ "column_name",
  /*  292 */ "type_name",
  /*  293 */ "signed_literal",
  /*  294 */ "create_subtable_clause",
  /*  295 */ "specific_cols_opt",
  /*  296 */ "expression_list",
  /*  297 */ "drop_table_clause",
  /*  298 */ "col_name_list",
  /*  299 */ "table_name",
  /*  300 */ "column_def",
  /*  301 */ "duration_list",
  /*  302 */ "rollup_func_list",
  /*  303 */ "alter_table_option",
  /*  304 */ "duration_literal",
  /*  305 */ "rollup_func_name",
  /*  306 */ "function_name",
  /*  307 */ "col_name",
  /*  308 */ "db_name_cond_opt",
  /*  309 */ "like_pattern_opt",
  /*  310 */ "table_name_cond",
  /*  311 */ "from_db_opt",
  /*  312 */ "index_name",
  /*  313 */ "index_options",
  /*  314 */ "func_list",
  /*  315 */ "sliding_opt",
  /*  316 */ "sma_stream_opt",
  /*  317 */ "func",
  /*  318 */ "stream_options",
  /*  319 */ "topic_name",
  /*  320 */ "query_expression",
  /*  321 */ "cgroup_name",
  /*  322 */ "analyze_opt",
  /*  323 */ "explain_options",
  /*  324 */ "agg_func_opt",
  /*  325 */ "bufsize_opt",
  /*  326 */ "stream_name",
  /*  327 */ "into_opt",
  /*  328 */ "dnode_list",
  /*  329 */ "where_clause_opt",
  /*  330 */ "signed",
  /*  331 */ "literal_func",
  /*  332 */ "literal_list",
  /*  333 */ "table_alias",
  /*  334 */ "column_alias",
  /*  335 */ "expression",
  /*  336 */ "pseudo_column",
  /*  337 */ "column_reference",
  /*  338 */ "function_expression",
  /*  339 */ "subquery",
  /*  340 */ "star_func",
  /*  341 */ "star_func_para_list",
  /*  342 */ "noarg_func",
  /*  343 */ "other_para_list",
  /*  344 */ "star_func_para",
  /*  345 */ "predicate",
  /*  346 */ "compare_op",
  /*  347 */ "in_op",
  /*  348 */ "in_predicate_value",
  /*  349 */ "boolean_value_expression",
  /*  350 */ "boolean_primary",
  /*  351 */ "common_expression",
  /*  352 */ "from_clause_opt",
  /*  353 */ "table_reference_list",
  /*  354 */ "table_reference",
  /*  355 */ "table_primary",
  /*  356 */ "joined_table",
  /*  357 */ "alias_opt",
  /*  358 */ "parenthesized_joined_table",
  /*  359 */ "join_type",
  /*  360 */ "search_condition",
  /*  361 */ "query_specification",
  /*  362 */ "set_quantifier_opt",
  /*  363 */ "select_list",
  /*  364 */ "partition_by_clause_opt",
  /*  365 */ "range_opt",
  /*  366 */ "every_opt",
  /*  367 */ "fill_opt",
  /*  368 */ "twindow_clause_opt",
  /*  369 */ "group_by_clause_opt",
  /*  370 */ "having_clause_opt",
  /*  371 */ "select_item",
  /*  372 */ "fill_mode",
  /*  373 */ "group_by_list",
  /*  374 */ "query_expression_body",
  /*  375 */ "order_by_clause_opt",
  /*  376 */ "slimit_clause_opt",
  /*  377 */ "limit_clause_opt",
  /*  378 */ "query_primary",
  /*  379 */ "sort_specification_list",
  /*  380 */ "sort_specification",
  /*  381 */ "ordering_specification_opt",
  /*  382 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  80 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  82 */ "db_options ::= db_options KEEP integer_list",
 /*  83 */ "db_options ::= db_options KEEP variable_list",
 /*  84 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  85 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  90 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  91 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  92 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  93 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 100 */ "alter_db_options ::= alter_db_option",
 /* 101 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 102 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 103 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 104 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /* 105 */ "alter_db_option ::= KEEP integer_list",
 /* 106 */ "alter_db_option ::= KEEP variable_list",
 /* 107 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 108 */ "integer_list ::= NK_INTEGER",
 /* 109 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 110 */ "variable_list ::= NK_VARIABLE",
 /* 111 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 112 */ "retention_list ::= retention",
 /* 113 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 114 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 115 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 116 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 117 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 118 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 119 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 120 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 121 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 122 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 123 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 125 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 127 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 129 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 130 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 131 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 132 */ "multi_create_clause ::= create_subtable_clause",
 /* 133 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 134 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 135 */ "multi_drop_clause ::= drop_table_clause",
 /* 136 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 137 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 138 */ "specific_cols_opt ::=",
 /* 139 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 140 */ "full_table_name ::= table_name",
 /* 141 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 142 */ "column_def_list ::= column_def",
 /* 143 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 144 */ "column_def ::= column_name type_name",
 /* 145 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 146 */ "type_name ::= BOOL",
 /* 147 */ "type_name ::= TINYINT",
 /* 148 */ "type_name ::= SMALLINT",
 /* 149 */ "type_name ::= INT",
 /* 150 */ "type_name ::= INTEGER",
 /* 151 */ "type_name ::= BIGINT",
 /* 152 */ "type_name ::= FLOAT",
 /* 153 */ "type_name ::= DOUBLE",
 /* 154 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 155 */ "type_name ::= TIMESTAMP",
 /* 156 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= TINYINT UNSIGNED",
 /* 158 */ "type_name ::= SMALLINT UNSIGNED",
 /* 159 */ "type_name ::= INT UNSIGNED",
 /* 160 */ "type_name ::= BIGINT UNSIGNED",
 /* 161 */ "type_name ::= JSON",
 /* 162 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= MEDIUMBLOB",
 /* 164 */ "type_name ::= BLOB",
 /* 165 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= DECIMAL",
 /* 167 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 169 */ "tags_def_opt ::=",
 /* 170 */ "tags_def_opt ::= tags_def",
 /* 171 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 172 */ "table_options ::=",
 /* 173 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 174 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 175 */ "table_options ::= table_options WATERMARK duration_list",
 /* 176 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 177 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 178 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 179 */ "alter_table_options ::= alter_table_option",
 /* 180 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 181 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 182 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 183 */ "duration_list ::= duration_literal",
 /* 184 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 185 */ "rollup_func_list ::= rollup_func_name",
 /* 186 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 187 */ "rollup_func_name ::= function_name",
 /* 188 */ "rollup_func_name ::= FIRST",
 /* 189 */ "rollup_func_name ::= LAST",
 /* 190 */ "col_name_list ::= col_name",
 /* 191 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 192 */ "col_name ::= column_name",
 /* 193 */ "cmd ::= SHOW DNODES",
 /* 194 */ "cmd ::= SHOW USERS",
 /* 195 */ "cmd ::= SHOW DATABASES",
 /* 196 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 197 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 198 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 199 */ "cmd ::= SHOW MNODES",
 /* 200 */ "cmd ::= SHOW MODULES",
 /* 201 */ "cmd ::= SHOW QNODES",
 /* 202 */ "cmd ::= SHOW FUNCTIONS",
 /* 203 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 204 */ "cmd ::= SHOW STREAMS",
 /* 205 */ "cmd ::= SHOW ACCOUNTS",
 /* 206 */ "cmd ::= SHOW APPS",
 /* 207 */ "cmd ::= SHOW CONNECTIONS",
 /* 208 */ "cmd ::= SHOW LICENCE",
 /* 209 */ "cmd ::= SHOW GRANTS",
 /* 210 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 211 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 212 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 213 */ "cmd ::= SHOW QUERIES",
 /* 214 */ "cmd ::= SHOW SCORES",
 /* 215 */ "cmd ::= SHOW TOPICS",
 /* 216 */ "cmd ::= SHOW VARIABLES",
 /* 217 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 218 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 219 */ "cmd ::= SHOW BNODES",
 /* 220 */ "cmd ::= SHOW SNODES",
 /* 221 */ "cmd ::= SHOW CLUSTER",
 /* 222 */ "cmd ::= SHOW TRANSACTIONS",
 /* 223 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 224 */ "cmd ::= SHOW CONSUMERS",
 /* 225 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 226 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 227 */ "db_name_cond_opt ::=",
 /* 228 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 229 */ "like_pattern_opt ::=",
 /* 230 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 231 */ "table_name_cond ::= table_name",
 /* 232 */ "from_db_opt ::=",
 /* 233 */ "from_db_opt ::= FROM db_name",
 /* 234 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 235 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 236 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 237 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 238 */ "func_list ::= func",
 /* 239 */ "func_list ::= func_list NK_COMMA func",
 /* 240 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 241 */ "sma_stream_opt ::=",
 /* 242 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 243 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 245 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 246 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 247 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 248 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 249 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 250 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 251 */ "cmd ::= DESC full_table_name",
 /* 252 */ "cmd ::= DESCRIBE full_table_name",
 /* 253 */ "cmd ::= RESET QUERY CACHE",
 /* 254 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 255 */ "analyze_opt ::=",
 /* 256 */ "analyze_opt ::= ANALYZE",
 /* 257 */ "explain_options ::=",
 /* 258 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 259 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 260 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 261 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 262 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 263 */ "agg_func_opt ::=",
 /* 264 */ "agg_func_opt ::= AGGREGATE",
 /* 265 */ "bufsize_opt ::=",
 /* 266 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 267 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 268 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 269 */ "into_opt ::=",
 /* 270 */ "into_opt ::= INTO full_table_name",
 /* 271 */ "stream_options ::=",
 /* 272 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 273 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 274 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 275 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 276 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 277 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 278 */ "cmd ::= KILL QUERY NK_STRING",
 /* 279 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 280 */ "cmd ::= BALANCE VGROUP",
 /* 281 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 282 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 283 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 284 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 285 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 286 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 287 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 288 */ "cmd ::= query_expression",
 /* 289 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 290 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 291 */ "literal ::= NK_INTEGER",
 /* 292 */ "literal ::= NK_FLOAT",
 /* 293 */ "literal ::= NK_STRING",
 /* 294 */ "literal ::= NK_BOOL",
 /* 295 */ "literal ::= TIMESTAMP NK_STRING",
 /* 296 */ "literal ::= duration_literal",
 /* 297 */ "literal ::= NULL",
 /* 298 */ "literal ::= NK_QUESTION",
 /* 299 */ "duration_literal ::= NK_VARIABLE",
 /* 300 */ "signed ::= NK_INTEGER",
 /* 301 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 302 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 303 */ "signed ::= NK_FLOAT",
 /* 304 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 305 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 306 */ "signed_literal ::= signed",
 /* 307 */ "signed_literal ::= NK_STRING",
 /* 308 */ "signed_literal ::= NK_BOOL",
 /* 309 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 310 */ "signed_literal ::= duration_literal",
 /* 311 */ "signed_literal ::= NULL",
 /* 312 */ "signed_literal ::= literal_func",
 /* 313 */ "signed_literal ::= NK_QUESTION",
 /* 314 */ "literal_list ::= signed_literal",
 /* 315 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 316 */ "db_name ::= NK_ID",
 /* 317 */ "table_name ::= NK_ID",
 /* 318 */ "column_name ::= NK_ID",
 /* 319 */ "function_name ::= NK_ID",
 /* 320 */ "table_alias ::= NK_ID",
 /* 321 */ "column_alias ::= NK_ID",
 /* 322 */ "user_name ::= NK_ID",
 /* 323 */ "index_name ::= NK_ID",
 /* 324 */ "topic_name ::= NK_ID",
 /* 325 */ "stream_name ::= NK_ID",
 /* 326 */ "cgroup_name ::= NK_ID",
 /* 327 */ "expression ::= literal",
 /* 328 */ "expression ::= pseudo_column",
 /* 329 */ "expression ::= column_reference",
 /* 330 */ "expression ::= function_expression",
 /* 331 */ "expression ::= subquery",
 /* 332 */ "expression ::= NK_LP expression NK_RP",
 /* 333 */ "expression ::= NK_PLUS expression",
 /* 334 */ "expression ::= NK_MINUS expression",
 /* 335 */ "expression ::= expression NK_PLUS expression",
 /* 336 */ "expression ::= expression NK_MINUS expression",
 /* 337 */ "expression ::= expression NK_STAR expression",
 /* 338 */ "expression ::= expression NK_SLASH expression",
 /* 339 */ "expression ::= expression NK_REM expression",
 /* 340 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 341 */ "expression ::= expression NK_BITAND expression",
 /* 342 */ "expression ::= expression NK_BITOR expression",
 /* 343 */ "expression_list ::= expression",
 /* 344 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 345 */ "column_reference ::= column_name",
 /* 346 */ "column_reference ::= table_name NK_DOT column_name",
 /* 347 */ "pseudo_column ::= ROWTS",
 /* 348 */ "pseudo_column ::= TBNAME",
 /* 349 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 350 */ "pseudo_column ::= QSTART",
 /* 351 */ "pseudo_column ::= QEND",
 /* 352 */ "pseudo_column ::= QDURATION",
 /* 353 */ "pseudo_column ::= WSTART",
 /* 354 */ "pseudo_column ::= WEND",
 /* 355 */ "pseudo_column ::= WDURATION",
 /* 356 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 357 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 358 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 359 */ "function_expression ::= literal_func",
 /* 360 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 361 */ "literal_func ::= NOW",
 /* 362 */ "noarg_func ::= NOW",
 /* 363 */ "noarg_func ::= TODAY",
 /* 364 */ "noarg_func ::= TIMEZONE",
 /* 365 */ "noarg_func ::= DATABASE",
 /* 366 */ "noarg_func ::= CLIENT_VERSION",
 /* 367 */ "noarg_func ::= SERVER_VERSION",
 /* 368 */ "noarg_func ::= SERVER_STATUS",
 /* 369 */ "noarg_func ::= CURRENT_USER",
 /* 370 */ "noarg_func ::= USER",
 /* 371 */ "star_func ::= COUNT",
 /* 372 */ "star_func ::= FIRST",
 /* 373 */ "star_func ::= LAST",
 /* 374 */ "star_func ::= LAST_ROW",
 /* 375 */ "star_func_para_list ::= NK_STAR",
 /* 376 */ "star_func_para_list ::= other_para_list",
 /* 377 */ "other_para_list ::= star_func_para",
 /* 378 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 379 */ "star_func_para ::= expression",
 /* 380 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 381 */ "predicate ::= expression compare_op expression",
 /* 382 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 383 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 384 */ "predicate ::= expression IS NULL",
 /* 385 */ "predicate ::= expression IS NOT NULL",
 /* 386 */ "predicate ::= expression in_op in_predicate_value",
 /* 387 */ "compare_op ::= NK_LT",
 /* 388 */ "compare_op ::= NK_GT",
 /* 389 */ "compare_op ::= NK_LE",
 /* 390 */ "compare_op ::= NK_GE",
 /* 391 */ "compare_op ::= NK_NE",
 /* 392 */ "compare_op ::= NK_EQ",
 /* 393 */ "compare_op ::= LIKE",
 /* 394 */ "compare_op ::= NOT LIKE",
 /* 395 */ "compare_op ::= MATCH",
 /* 396 */ "compare_op ::= NMATCH",
 /* 397 */ "compare_op ::= CONTAINS",
 /* 398 */ "in_op ::= IN",
 /* 399 */ "in_op ::= NOT IN",
 /* 400 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 401 */ "boolean_value_expression ::= boolean_primary",
 /* 402 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 403 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 404 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 405 */ "boolean_primary ::= predicate",
 /* 406 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 407 */ "common_expression ::= expression",
 /* 408 */ "common_expression ::= boolean_value_expression",
 /* 409 */ "from_clause_opt ::=",
 /* 410 */ "from_clause_opt ::= FROM table_reference_list",
 /* 411 */ "table_reference_list ::= table_reference",
 /* 412 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 413 */ "table_reference ::= table_primary",
 /* 414 */ "table_reference ::= joined_table",
 /* 415 */ "table_primary ::= table_name alias_opt",
 /* 416 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 417 */ "table_primary ::= subquery alias_opt",
 /* 418 */ "table_primary ::= parenthesized_joined_table",
 /* 419 */ "alias_opt ::=",
 /* 420 */ "alias_opt ::= table_alias",
 /* 421 */ "alias_opt ::= AS table_alias",
 /* 422 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 423 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 424 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 425 */ "join_type ::=",
 /* 426 */ "join_type ::= INNER",
 /* 427 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 428 */ "set_quantifier_opt ::=",
 /* 429 */ "set_quantifier_opt ::= DISTINCT",
 /* 430 */ "set_quantifier_opt ::= ALL",
 /* 431 */ "select_list ::= select_item",
 /* 432 */ "select_list ::= select_list NK_COMMA select_item",
 /* 433 */ "select_item ::= NK_STAR",
 /* 434 */ "select_item ::= common_expression",
 /* 435 */ "select_item ::= common_expression column_alias",
 /* 436 */ "select_item ::= common_expression AS column_alias",
 /* 437 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 438 */ "where_clause_opt ::=",
 /* 439 */ "where_clause_opt ::= WHERE search_condition",
 /* 440 */ "partition_by_clause_opt ::=",
 /* 441 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 442 */ "twindow_clause_opt ::=",
 /* 443 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 444 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 445 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 446 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 447 */ "sliding_opt ::=",
 /* 448 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 449 */ "fill_opt ::=",
 /* 450 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 451 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 452 */ "fill_mode ::= NONE",
 /* 453 */ "fill_mode ::= PREV",
 /* 454 */ "fill_mode ::= NULL",
 /* 455 */ "fill_mode ::= LINEAR",
 /* 456 */ "fill_mode ::= NEXT",
 /* 457 */ "group_by_clause_opt ::=",
 /* 458 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 459 */ "group_by_list ::= expression",
 /* 460 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 461 */ "having_clause_opt ::=",
 /* 462 */ "having_clause_opt ::= HAVING search_condition",
 /* 463 */ "range_opt ::=",
 /* 464 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 465 */ "every_opt ::=",
 /* 466 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 467 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 468 */ "query_expression_body ::= query_primary",
 /* 469 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 470 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 471 */ "query_primary ::= query_specification",
 /* 472 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 473 */ "order_by_clause_opt ::=",
 /* 474 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 475 */ "slimit_clause_opt ::=",
 /* 476 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 477 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 478 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 479 */ "limit_clause_opt ::=",
 /* 480 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 481 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 482 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 483 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 484 */ "search_condition ::= common_expression",
 /* 485 */ "sort_specification_list ::= sort_specification",
 /* 486 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 487 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 488 */ "ordering_specification_opt ::=",
 /* 489 */ "ordering_specification_opt ::= ASC",
 /* 490 */ "ordering_specification_opt ::= DESC",
 /* 491 */ "null_ordering_opt ::=",
 /* 492 */ "null_ordering_opt ::= NULLS FIRST",
 /* 493 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 260: /* cmd */
    case 263: /* literal */
    case 274: /* db_options */
    case 276: /* alter_db_options */
    case 281: /* retention */
    case 282: /* full_table_name */
    case 285: /* table_options */
    case 289: /* alter_table_clause */
    case 290: /* alter_table_options */
    case 293: /* signed_literal */
    case 294: /* create_subtable_clause */
    case 297: /* drop_table_clause */
    case 300: /* column_def */
    case 304: /* duration_literal */
    case 305: /* rollup_func_name */
    case 307: /* col_name */
    case 308: /* db_name_cond_opt */
    case 309: /* like_pattern_opt */
    case 310: /* table_name_cond */
    case 311: /* from_db_opt */
    case 313: /* index_options */
    case 315: /* sliding_opt */
    case 316: /* sma_stream_opt */
    case 317: /* func */
    case 318: /* stream_options */
    case 320: /* query_expression */
    case 323: /* explain_options */
    case 327: /* into_opt */
    case 329: /* where_clause_opt */
    case 330: /* signed */
    case 331: /* literal_func */
    case 335: /* expression */
    case 336: /* pseudo_column */
    case 337: /* column_reference */
    case 338: /* function_expression */
    case 339: /* subquery */
    case 344: /* star_func_para */
    case 345: /* predicate */
    case 348: /* in_predicate_value */
    case 349: /* boolean_value_expression */
    case 350: /* boolean_primary */
    case 351: /* common_expression */
    case 352: /* from_clause_opt */
    case 353: /* table_reference_list */
    case 354: /* table_reference */
    case 355: /* table_primary */
    case 356: /* joined_table */
    case 358: /* parenthesized_joined_table */
    case 360: /* search_condition */
    case 361: /* query_specification */
    case 365: /* range_opt */
    case 366: /* every_opt */
    case 367: /* fill_opt */
    case 368: /* twindow_clause_opt */
    case 370: /* having_clause_opt */
    case 371: /* select_item */
    case 374: /* query_expression_body */
    case 376: /* slimit_clause_opt */
    case 377: /* limit_clause_opt */
    case 378: /* query_primary */
    case 380: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy160)); 
}
      break;
    case 261: /* account_options */
    case 262: /* alter_account_options */
    case 264: /* alter_account_option */
    case 325: /* bufsize_opt */
{
 
}
      break;
    case 265: /* user_name */
    case 268: /* priv_level */
    case 271: /* db_name */
    case 272: /* dnode_endpoint */
    case 291: /* column_name */
    case 299: /* table_name */
    case 306: /* function_name */
    case 312: /* index_name */
    case 319: /* topic_name */
    case 321: /* cgroup_name */
    case 326: /* stream_name */
    case 333: /* table_alias */
    case 334: /* column_alias */
    case 340: /* star_func */
    case 342: /* noarg_func */
    case 357: /* alias_opt */
{
 
}
      break;
    case 266: /* sysinfo_opt */
{
 
}
      break;
    case 267: /* privileges */
    case 269: /* priv_type_list */
    case 270: /* priv_type */
{
 
}
      break;
    case 273: /* not_exists_opt */
    case 275: /* exists_opt */
    case 322: /* analyze_opt */
    case 324: /* agg_func_opt */
    case 362: /* set_quantifier_opt */
{
 
}
      break;
    case 277: /* integer_list */
    case 278: /* variable_list */
    case 279: /* retention_list */
    case 283: /* column_def_list */
    case 284: /* tags_def_opt */
    case 286: /* multi_create_clause */
    case 287: /* tags_def */
    case 288: /* multi_drop_clause */
    case 295: /* specific_cols_opt */
    case 296: /* expression_list */
    case 298: /* col_name_list */
    case 301: /* duration_list */
    case 302: /* rollup_func_list */
    case 314: /* func_list */
    case 328: /* dnode_list */
    case 332: /* literal_list */
    case 341: /* star_func_para_list */
    case 343: /* other_para_list */
    case 363: /* select_list */
    case 364: /* partition_by_clause_opt */
    case 369: /* group_by_clause_opt */
    case 373: /* group_by_list */
    case 375: /* order_by_clause_opt */
    case 379: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy180)); 
}
      break;
    case 280: /* alter_db_option */
    case 303: /* alter_table_option */
{
 
}
      break;
    case 292: /* type_name */
{
 
}
      break;
    case 346: /* compare_op */
    case 347: /* in_op */
{
 
}
      break;
    case 359: /* join_type */
{
 
}
      break;
    case 372: /* fill_mode */
{
 
}
      break;
    case 381: /* ordering_specification_opt */
{
 
}
      break;
    case 382: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  260,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  260,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  261,    0 }, /* (2) account_options ::= */
  {  261,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  261,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  261,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  261,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  261,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  261,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  261,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  261,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  261,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  262,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  262,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  264,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  264,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  264,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  264,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  264,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  264,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  264,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  264,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  264,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  264,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  260,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  260,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  260,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  260,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  260,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  266,    0 }, /* (29) sysinfo_opt ::= */
  {  266,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  260,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  260,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  267,   -1 }, /* (33) privileges ::= ALL */
  {  267,   -1 }, /* (34) privileges ::= priv_type_list */
  {  269,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  269,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  270,   -1 }, /* (37) priv_type ::= READ */
  {  270,   -1 }, /* (38) priv_type ::= WRITE */
  {  268,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  268,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  260,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  260,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  260,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  260,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  260,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  260,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  260,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  260,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  272,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  272,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  272,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  260,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  260,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  260,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  260,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  260,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  260,   -2 }, /* (64) cmd ::= USE db_name */
  {  260,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  260,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  260,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  273,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  273,    0 }, /* (69) not_exists_opt ::= */
  {  275,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  275,    0 }, /* (71) exists_opt ::= */
  {  274,    0 }, /* (72) db_options ::= */
  {  274,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  274,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  274,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  274,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  274,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  274,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  274,   -3 }, /* (79) db_options ::= db_options FSYNC NK_INTEGER */
  {  274,   -3 }, /* (80) db_options ::= db_options MAXROWS NK_INTEGER */
  {  274,   -3 }, /* (81) db_options ::= db_options MINROWS NK_INTEGER */
  {  274,   -3 }, /* (82) db_options ::= db_options KEEP integer_list */
  {  274,   -3 }, /* (83) db_options ::= db_options KEEP variable_list */
  {  274,   -3 }, /* (84) db_options ::= db_options PAGES NK_INTEGER */
  {  274,   -3 }, /* (85) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  274,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  274,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  274,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  274,   -3 }, /* (89) db_options ::= db_options WAL NK_INTEGER */
  {  274,   -3 }, /* (90) db_options ::= db_options VGROUPS NK_INTEGER */
  {  274,   -3 }, /* (91) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  274,   -3 }, /* (92) db_options ::= db_options RETENTIONS retention_list */
  {  274,   -3 }, /* (93) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  274,   -3 }, /* (94) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  274,   -4 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  274,   -3 }, /* (96) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  274,   -4 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  274,   -3 }, /* (98) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  274,   -3 }, /* (99) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  276,   -1 }, /* (100) alter_db_options ::= alter_db_option */
  {  276,   -2 }, /* (101) alter_db_options ::= alter_db_options alter_db_option */
  {  280,   -2 }, /* (102) alter_db_option ::= CACHEMODEL NK_STRING */
  {  280,   -2 }, /* (103) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  280,   -2 }, /* (104) alter_db_option ::= FSYNC NK_INTEGER */
  {  280,   -2 }, /* (105) alter_db_option ::= KEEP integer_list */
  {  280,   -2 }, /* (106) alter_db_option ::= KEEP variable_list */
  {  280,   -2 }, /* (107) alter_db_option ::= WAL NK_INTEGER */
  {  277,   -1 }, /* (108) integer_list ::= NK_INTEGER */
  {  277,   -3 }, /* (109) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  278,   -1 }, /* (110) variable_list ::= NK_VARIABLE */
  {  278,   -3 }, /* (111) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  279,   -1 }, /* (112) retention_list ::= retention */
  {  279,   -3 }, /* (113) retention_list ::= retention_list NK_COMMA retention */
  {  281,   -3 }, /* (114) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  260,   -9 }, /* (115) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  260,   -3 }, /* (116) cmd ::= CREATE TABLE multi_create_clause */
  {  260,   -9 }, /* (117) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  260,   -3 }, /* (118) cmd ::= DROP TABLE multi_drop_clause */
  {  260,   -4 }, /* (119) cmd ::= DROP STABLE exists_opt full_table_name */
  {  260,   -3 }, /* (120) cmd ::= ALTER TABLE alter_table_clause */
  {  260,   -3 }, /* (121) cmd ::= ALTER STABLE alter_table_clause */
  {  289,   -2 }, /* (122) alter_table_clause ::= full_table_name alter_table_options */
  {  289,   -5 }, /* (123) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  289,   -4 }, /* (124) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  289,   -5 }, /* (125) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  289,   -5 }, /* (126) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  289,   -5 }, /* (127) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  289,   -4 }, /* (128) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  289,   -5 }, /* (129) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  289,   -5 }, /* (130) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  289,   -6 }, /* (131) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  286,   -1 }, /* (132) multi_create_clause ::= create_subtable_clause */
  {  286,   -2 }, /* (133) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  294,  -10 }, /* (134) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  288,   -1 }, /* (135) multi_drop_clause ::= drop_table_clause */
  {  288,   -2 }, /* (136) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  297,   -2 }, /* (137) drop_table_clause ::= exists_opt full_table_name */
  {  295,    0 }, /* (138) specific_cols_opt ::= */
  {  295,   -3 }, /* (139) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  282,   -1 }, /* (140) full_table_name ::= table_name */
  {  282,   -3 }, /* (141) full_table_name ::= db_name NK_DOT table_name */
  {  283,   -1 }, /* (142) column_def_list ::= column_def */
  {  283,   -3 }, /* (143) column_def_list ::= column_def_list NK_COMMA column_def */
  {  300,   -2 }, /* (144) column_def ::= column_name type_name */
  {  300,   -4 }, /* (145) column_def ::= column_name type_name COMMENT NK_STRING */
  {  292,   -1 }, /* (146) type_name ::= BOOL */
  {  292,   -1 }, /* (147) type_name ::= TINYINT */
  {  292,   -1 }, /* (148) type_name ::= SMALLINT */
  {  292,   -1 }, /* (149) type_name ::= INT */
  {  292,   -1 }, /* (150) type_name ::= INTEGER */
  {  292,   -1 }, /* (151) type_name ::= BIGINT */
  {  292,   -1 }, /* (152) type_name ::= FLOAT */
  {  292,   -1 }, /* (153) type_name ::= DOUBLE */
  {  292,   -4 }, /* (154) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  292,   -1 }, /* (155) type_name ::= TIMESTAMP */
  {  292,   -4 }, /* (156) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  292,   -2 }, /* (157) type_name ::= TINYINT UNSIGNED */
  {  292,   -2 }, /* (158) type_name ::= SMALLINT UNSIGNED */
  {  292,   -2 }, /* (159) type_name ::= INT UNSIGNED */
  {  292,   -2 }, /* (160) type_name ::= BIGINT UNSIGNED */
  {  292,   -1 }, /* (161) type_name ::= JSON */
  {  292,   -4 }, /* (162) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  292,   -1 }, /* (163) type_name ::= MEDIUMBLOB */
  {  292,   -1 }, /* (164) type_name ::= BLOB */
  {  292,   -4 }, /* (165) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  292,   -1 }, /* (166) type_name ::= DECIMAL */
  {  292,   -4 }, /* (167) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  292,   -6 }, /* (168) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  284,    0 }, /* (169) tags_def_opt ::= */
  {  284,   -1 }, /* (170) tags_def_opt ::= tags_def */
  {  287,   -4 }, /* (171) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  285,    0 }, /* (172) table_options ::= */
  {  285,   -3 }, /* (173) table_options ::= table_options COMMENT NK_STRING */
  {  285,   -3 }, /* (174) table_options ::= table_options MAX_DELAY duration_list */
  {  285,   -3 }, /* (175) table_options ::= table_options WATERMARK duration_list */
  {  285,   -5 }, /* (176) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  285,   -3 }, /* (177) table_options ::= table_options TTL NK_INTEGER */
  {  285,   -5 }, /* (178) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  290,   -1 }, /* (179) alter_table_options ::= alter_table_option */
  {  290,   -2 }, /* (180) alter_table_options ::= alter_table_options alter_table_option */
  {  303,   -2 }, /* (181) alter_table_option ::= COMMENT NK_STRING */
  {  303,   -2 }, /* (182) alter_table_option ::= TTL NK_INTEGER */
  {  301,   -1 }, /* (183) duration_list ::= duration_literal */
  {  301,   -3 }, /* (184) duration_list ::= duration_list NK_COMMA duration_literal */
  {  302,   -1 }, /* (185) rollup_func_list ::= rollup_func_name */
  {  302,   -3 }, /* (186) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  305,   -1 }, /* (187) rollup_func_name ::= function_name */
  {  305,   -1 }, /* (188) rollup_func_name ::= FIRST */
  {  305,   -1 }, /* (189) rollup_func_name ::= LAST */
  {  298,   -1 }, /* (190) col_name_list ::= col_name */
  {  298,   -3 }, /* (191) col_name_list ::= col_name_list NK_COMMA col_name */
  {  307,   -1 }, /* (192) col_name ::= column_name */
  {  260,   -2 }, /* (193) cmd ::= SHOW DNODES */
  {  260,   -2 }, /* (194) cmd ::= SHOW USERS */
  {  260,   -2 }, /* (195) cmd ::= SHOW DATABASES */
  {  260,   -4 }, /* (196) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  260,   -4 }, /* (197) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  260,   -3 }, /* (198) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  260,   -2 }, /* (199) cmd ::= SHOW MNODES */
  {  260,   -2 }, /* (200) cmd ::= SHOW MODULES */
  {  260,   -2 }, /* (201) cmd ::= SHOW QNODES */
  {  260,   -2 }, /* (202) cmd ::= SHOW FUNCTIONS */
  {  260,   -5 }, /* (203) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  260,   -2 }, /* (204) cmd ::= SHOW STREAMS */
  {  260,   -2 }, /* (205) cmd ::= SHOW ACCOUNTS */
  {  260,   -2 }, /* (206) cmd ::= SHOW APPS */
  {  260,   -2 }, /* (207) cmd ::= SHOW CONNECTIONS */
  {  260,   -2 }, /* (208) cmd ::= SHOW LICENCE */
  {  260,   -2 }, /* (209) cmd ::= SHOW GRANTS */
  {  260,   -4 }, /* (210) cmd ::= SHOW CREATE DATABASE db_name */
  {  260,   -4 }, /* (211) cmd ::= SHOW CREATE TABLE full_table_name */
  {  260,   -4 }, /* (212) cmd ::= SHOW CREATE STABLE full_table_name */
  {  260,   -2 }, /* (213) cmd ::= SHOW QUERIES */
  {  260,   -2 }, /* (214) cmd ::= SHOW SCORES */
  {  260,   -2 }, /* (215) cmd ::= SHOW TOPICS */
  {  260,   -2 }, /* (216) cmd ::= SHOW VARIABLES */
  {  260,   -3 }, /* (217) cmd ::= SHOW LOCAL VARIABLES */
  {  260,   -4 }, /* (218) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  260,   -2 }, /* (219) cmd ::= SHOW BNODES */
  {  260,   -2 }, /* (220) cmd ::= SHOW SNODES */
  {  260,   -2 }, /* (221) cmd ::= SHOW CLUSTER */
  {  260,   -2 }, /* (222) cmd ::= SHOW TRANSACTIONS */
  {  260,   -4 }, /* (223) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  260,   -2 }, /* (224) cmd ::= SHOW CONSUMERS */
  {  260,   -2 }, /* (225) cmd ::= SHOW SUBSCRIPTIONS */
  {  260,   -5 }, /* (226) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  308,    0 }, /* (227) db_name_cond_opt ::= */
  {  308,   -2 }, /* (228) db_name_cond_opt ::= db_name NK_DOT */
  {  309,    0 }, /* (229) like_pattern_opt ::= */
  {  309,   -2 }, /* (230) like_pattern_opt ::= LIKE NK_STRING */
  {  310,   -1 }, /* (231) table_name_cond ::= table_name */
  {  311,    0 }, /* (232) from_db_opt ::= */
  {  311,   -2 }, /* (233) from_db_opt ::= FROM db_name */
  {  260,   -8 }, /* (234) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  260,   -4 }, /* (235) cmd ::= DROP INDEX exists_opt index_name */
  {  313,  -10 }, /* (236) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  313,  -12 }, /* (237) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  314,   -1 }, /* (238) func_list ::= func */
  {  314,   -3 }, /* (239) func_list ::= func_list NK_COMMA func */
  {  317,   -4 }, /* (240) func ::= function_name NK_LP expression_list NK_RP */
  {  316,    0 }, /* (241) sma_stream_opt ::= */
  {  316,   -3 }, /* (242) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  316,   -3 }, /* (243) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  260,   -6 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  260,   -7 }, /* (245) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  260,   -9 }, /* (246) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  260,   -7 }, /* (247) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  260,   -9 }, /* (248) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  260,   -4 }, /* (249) cmd ::= DROP TOPIC exists_opt topic_name */
  {  260,   -7 }, /* (250) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  260,   -2 }, /* (251) cmd ::= DESC full_table_name */
  {  260,   -2 }, /* (252) cmd ::= DESCRIBE full_table_name */
  {  260,   -3 }, /* (253) cmd ::= RESET QUERY CACHE */
  {  260,   -4 }, /* (254) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  322,    0 }, /* (255) analyze_opt ::= */
  {  322,   -1 }, /* (256) analyze_opt ::= ANALYZE */
  {  323,    0 }, /* (257) explain_options ::= */
  {  323,   -3 }, /* (258) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  323,   -3 }, /* (259) explain_options ::= explain_options RATIO NK_FLOAT */
  {  260,   -6 }, /* (260) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  260,  -10 }, /* (261) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  260,   -4 }, /* (262) cmd ::= DROP FUNCTION exists_opt function_name */
  {  324,    0 }, /* (263) agg_func_opt ::= */
  {  324,   -1 }, /* (264) agg_func_opt ::= AGGREGATE */
  {  325,    0 }, /* (265) bufsize_opt ::= */
  {  325,   -2 }, /* (266) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  260,   -8 }, /* (267) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  260,   -4 }, /* (268) cmd ::= DROP STREAM exists_opt stream_name */
  {  327,    0 }, /* (269) into_opt ::= */
  {  327,   -2 }, /* (270) into_opt ::= INTO full_table_name */
  {  318,    0 }, /* (271) stream_options ::= */
  {  318,   -3 }, /* (272) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  318,   -3 }, /* (273) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  318,   -4 }, /* (274) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  318,   -3 }, /* (275) stream_options ::= stream_options WATERMARK duration_literal */
  {  318,   -3 }, /* (276) stream_options ::= stream_options IGNORE EXPIRED */
  {  260,   -3 }, /* (277) cmd ::= KILL CONNECTION NK_INTEGER */
  {  260,   -3 }, /* (278) cmd ::= KILL QUERY NK_STRING */
  {  260,   -3 }, /* (279) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  260,   -2 }, /* (280) cmd ::= BALANCE VGROUP */
  {  260,   -4 }, /* (281) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  260,   -4 }, /* (282) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  260,   -3 }, /* (283) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  328,   -2 }, /* (284) dnode_list ::= DNODE NK_INTEGER */
  {  328,   -3 }, /* (285) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  260,   -3 }, /* (286) cmd ::= SYNCDB db_name REPLICA */
  {  260,   -4 }, /* (287) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  260,   -1 }, /* (288) cmd ::= query_expression */
  {  260,   -7 }, /* (289) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  260,   -4 }, /* (290) cmd ::= INSERT INTO full_table_name query_expression */
  {  263,   -1 }, /* (291) literal ::= NK_INTEGER */
  {  263,   -1 }, /* (292) literal ::= NK_FLOAT */
  {  263,   -1 }, /* (293) literal ::= NK_STRING */
  {  263,   -1 }, /* (294) literal ::= NK_BOOL */
  {  263,   -2 }, /* (295) literal ::= TIMESTAMP NK_STRING */
  {  263,   -1 }, /* (296) literal ::= duration_literal */
  {  263,   -1 }, /* (297) literal ::= NULL */
  {  263,   -1 }, /* (298) literal ::= NK_QUESTION */
  {  304,   -1 }, /* (299) duration_literal ::= NK_VARIABLE */
  {  330,   -1 }, /* (300) signed ::= NK_INTEGER */
  {  330,   -2 }, /* (301) signed ::= NK_PLUS NK_INTEGER */
  {  330,   -2 }, /* (302) signed ::= NK_MINUS NK_INTEGER */
  {  330,   -1 }, /* (303) signed ::= NK_FLOAT */
  {  330,   -2 }, /* (304) signed ::= NK_PLUS NK_FLOAT */
  {  330,   -2 }, /* (305) signed ::= NK_MINUS NK_FLOAT */
  {  293,   -1 }, /* (306) signed_literal ::= signed */
  {  293,   -1 }, /* (307) signed_literal ::= NK_STRING */
  {  293,   -1 }, /* (308) signed_literal ::= NK_BOOL */
  {  293,   -2 }, /* (309) signed_literal ::= TIMESTAMP NK_STRING */
  {  293,   -1 }, /* (310) signed_literal ::= duration_literal */
  {  293,   -1 }, /* (311) signed_literal ::= NULL */
  {  293,   -1 }, /* (312) signed_literal ::= literal_func */
  {  293,   -1 }, /* (313) signed_literal ::= NK_QUESTION */
  {  332,   -1 }, /* (314) literal_list ::= signed_literal */
  {  332,   -3 }, /* (315) literal_list ::= literal_list NK_COMMA signed_literal */
  {  271,   -1 }, /* (316) db_name ::= NK_ID */
  {  299,   -1 }, /* (317) table_name ::= NK_ID */
  {  291,   -1 }, /* (318) column_name ::= NK_ID */
  {  306,   -1 }, /* (319) function_name ::= NK_ID */
  {  333,   -1 }, /* (320) table_alias ::= NK_ID */
  {  334,   -1 }, /* (321) column_alias ::= NK_ID */
  {  265,   -1 }, /* (322) user_name ::= NK_ID */
  {  312,   -1 }, /* (323) index_name ::= NK_ID */
  {  319,   -1 }, /* (324) topic_name ::= NK_ID */
  {  326,   -1 }, /* (325) stream_name ::= NK_ID */
  {  321,   -1 }, /* (326) cgroup_name ::= NK_ID */
  {  335,   -1 }, /* (327) expression ::= literal */
  {  335,   -1 }, /* (328) expression ::= pseudo_column */
  {  335,   -1 }, /* (329) expression ::= column_reference */
  {  335,   -1 }, /* (330) expression ::= function_expression */
  {  335,   -1 }, /* (331) expression ::= subquery */
  {  335,   -3 }, /* (332) expression ::= NK_LP expression NK_RP */
  {  335,   -2 }, /* (333) expression ::= NK_PLUS expression */
  {  335,   -2 }, /* (334) expression ::= NK_MINUS expression */
  {  335,   -3 }, /* (335) expression ::= expression NK_PLUS expression */
  {  335,   -3 }, /* (336) expression ::= expression NK_MINUS expression */
  {  335,   -3 }, /* (337) expression ::= expression NK_STAR expression */
  {  335,   -3 }, /* (338) expression ::= expression NK_SLASH expression */
  {  335,   -3 }, /* (339) expression ::= expression NK_REM expression */
  {  335,   -3 }, /* (340) expression ::= column_reference NK_ARROW NK_STRING */
  {  335,   -3 }, /* (341) expression ::= expression NK_BITAND expression */
  {  335,   -3 }, /* (342) expression ::= expression NK_BITOR expression */
  {  296,   -1 }, /* (343) expression_list ::= expression */
  {  296,   -3 }, /* (344) expression_list ::= expression_list NK_COMMA expression */
  {  337,   -1 }, /* (345) column_reference ::= column_name */
  {  337,   -3 }, /* (346) column_reference ::= table_name NK_DOT column_name */
  {  336,   -1 }, /* (347) pseudo_column ::= ROWTS */
  {  336,   -1 }, /* (348) pseudo_column ::= TBNAME */
  {  336,   -3 }, /* (349) pseudo_column ::= table_name NK_DOT TBNAME */
  {  336,   -1 }, /* (350) pseudo_column ::= QSTART */
  {  336,   -1 }, /* (351) pseudo_column ::= QEND */
  {  336,   -1 }, /* (352) pseudo_column ::= QDURATION */
  {  336,   -1 }, /* (353) pseudo_column ::= WSTART */
  {  336,   -1 }, /* (354) pseudo_column ::= WEND */
  {  336,   -1 }, /* (355) pseudo_column ::= WDURATION */
  {  338,   -4 }, /* (356) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  338,   -4 }, /* (357) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  338,   -6 }, /* (358) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  338,   -1 }, /* (359) function_expression ::= literal_func */
  {  331,   -3 }, /* (360) literal_func ::= noarg_func NK_LP NK_RP */
  {  331,   -1 }, /* (361) literal_func ::= NOW */
  {  342,   -1 }, /* (362) noarg_func ::= NOW */
  {  342,   -1 }, /* (363) noarg_func ::= TODAY */
  {  342,   -1 }, /* (364) noarg_func ::= TIMEZONE */
  {  342,   -1 }, /* (365) noarg_func ::= DATABASE */
  {  342,   -1 }, /* (366) noarg_func ::= CLIENT_VERSION */
  {  342,   -1 }, /* (367) noarg_func ::= SERVER_VERSION */
  {  342,   -1 }, /* (368) noarg_func ::= SERVER_STATUS */
  {  342,   -1 }, /* (369) noarg_func ::= CURRENT_USER */
  {  342,   -1 }, /* (370) noarg_func ::= USER */
  {  340,   -1 }, /* (371) star_func ::= COUNT */
  {  340,   -1 }, /* (372) star_func ::= FIRST */
  {  340,   -1 }, /* (373) star_func ::= LAST */
  {  340,   -1 }, /* (374) star_func ::= LAST_ROW */
  {  341,   -1 }, /* (375) star_func_para_list ::= NK_STAR */
  {  341,   -1 }, /* (376) star_func_para_list ::= other_para_list */
  {  343,   -1 }, /* (377) other_para_list ::= star_func_para */
  {  343,   -3 }, /* (378) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  344,   -1 }, /* (379) star_func_para ::= expression */
  {  344,   -3 }, /* (380) star_func_para ::= table_name NK_DOT NK_STAR */
  {  345,   -3 }, /* (381) predicate ::= expression compare_op expression */
  {  345,   -5 }, /* (382) predicate ::= expression BETWEEN expression AND expression */
  {  345,   -6 }, /* (383) predicate ::= expression NOT BETWEEN expression AND expression */
  {  345,   -3 }, /* (384) predicate ::= expression IS NULL */
  {  345,   -4 }, /* (385) predicate ::= expression IS NOT NULL */
  {  345,   -3 }, /* (386) predicate ::= expression in_op in_predicate_value */
  {  346,   -1 }, /* (387) compare_op ::= NK_LT */
  {  346,   -1 }, /* (388) compare_op ::= NK_GT */
  {  346,   -1 }, /* (389) compare_op ::= NK_LE */
  {  346,   -1 }, /* (390) compare_op ::= NK_GE */
  {  346,   -1 }, /* (391) compare_op ::= NK_NE */
  {  346,   -1 }, /* (392) compare_op ::= NK_EQ */
  {  346,   -1 }, /* (393) compare_op ::= LIKE */
  {  346,   -2 }, /* (394) compare_op ::= NOT LIKE */
  {  346,   -1 }, /* (395) compare_op ::= MATCH */
  {  346,   -1 }, /* (396) compare_op ::= NMATCH */
  {  346,   -1 }, /* (397) compare_op ::= CONTAINS */
  {  347,   -1 }, /* (398) in_op ::= IN */
  {  347,   -2 }, /* (399) in_op ::= NOT IN */
  {  348,   -3 }, /* (400) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  349,   -1 }, /* (401) boolean_value_expression ::= boolean_primary */
  {  349,   -2 }, /* (402) boolean_value_expression ::= NOT boolean_primary */
  {  349,   -3 }, /* (403) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  349,   -3 }, /* (404) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  350,   -1 }, /* (405) boolean_primary ::= predicate */
  {  350,   -3 }, /* (406) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  351,   -1 }, /* (407) common_expression ::= expression */
  {  351,   -1 }, /* (408) common_expression ::= boolean_value_expression */
  {  352,    0 }, /* (409) from_clause_opt ::= */
  {  352,   -2 }, /* (410) from_clause_opt ::= FROM table_reference_list */
  {  353,   -1 }, /* (411) table_reference_list ::= table_reference */
  {  353,   -3 }, /* (412) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  354,   -1 }, /* (413) table_reference ::= table_primary */
  {  354,   -1 }, /* (414) table_reference ::= joined_table */
  {  355,   -2 }, /* (415) table_primary ::= table_name alias_opt */
  {  355,   -4 }, /* (416) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  355,   -2 }, /* (417) table_primary ::= subquery alias_opt */
  {  355,   -1 }, /* (418) table_primary ::= parenthesized_joined_table */
  {  357,    0 }, /* (419) alias_opt ::= */
  {  357,   -1 }, /* (420) alias_opt ::= table_alias */
  {  357,   -2 }, /* (421) alias_opt ::= AS table_alias */
  {  358,   -3 }, /* (422) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  358,   -3 }, /* (423) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  356,   -6 }, /* (424) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  359,    0 }, /* (425) join_type ::= */
  {  359,   -1 }, /* (426) join_type ::= INNER */
  {  361,  -12 }, /* (427) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  362,    0 }, /* (428) set_quantifier_opt ::= */
  {  362,   -1 }, /* (429) set_quantifier_opt ::= DISTINCT */
  {  362,   -1 }, /* (430) set_quantifier_opt ::= ALL */
  {  363,   -1 }, /* (431) select_list ::= select_item */
  {  363,   -3 }, /* (432) select_list ::= select_list NK_COMMA select_item */
  {  371,   -1 }, /* (433) select_item ::= NK_STAR */
  {  371,   -1 }, /* (434) select_item ::= common_expression */
  {  371,   -2 }, /* (435) select_item ::= common_expression column_alias */
  {  371,   -3 }, /* (436) select_item ::= common_expression AS column_alias */
  {  371,   -3 }, /* (437) select_item ::= table_name NK_DOT NK_STAR */
  {  329,    0 }, /* (438) where_clause_opt ::= */
  {  329,   -2 }, /* (439) where_clause_opt ::= WHERE search_condition */
  {  364,    0 }, /* (440) partition_by_clause_opt ::= */
  {  364,   -3 }, /* (441) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  368,    0 }, /* (442) twindow_clause_opt ::= */
  {  368,   -6 }, /* (443) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  368,   -4 }, /* (444) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  368,   -6 }, /* (445) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  368,   -8 }, /* (446) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  315,    0 }, /* (447) sliding_opt ::= */
  {  315,   -4 }, /* (448) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  367,    0 }, /* (449) fill_opt ::= */
  {  367,   -4 }, /* (450) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  367,   -6 }, /* (451) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  372,   -1 }, /* (452) fill_mode ::= NONE */
  {  372,   -1 }, /* (453) fill_mode ::= PREV */
  {  372,   -1 }, /* (454) fill_mode ::= NULL */
  {  372,   -1 }, /* (455) fill_mode ::= LINEAR */
  {  372,   -1 }, /* (456) fill_mode ::= NEXT */
  {  369,    0 }, /* (457) group_by_clause_opt ::= */
  {  369,   -3 }, /* (458) group_by_clause_opt ::= GROUP BY group_by_list */
  {  373,   -1 }, /* (459) group_by_list ::= expression */
  {  373,   -3 }, /* (460) group_by_list ::= group_by_list NK_COMMA expression */
  {  370,    0 }, /* (461) having_clause_opt ::= */
  {  370,   -2 }, /* (462) having_clause_opt ::= HAVING search_condition */
  {  365,    0 }, /* (463) range_opt ::= */
  {  365,   -6 }, /* (464) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  366,    0 }, /* (465) every_opt ::= */
  {  366,   -4 }, /* (466) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  320,   -4 }, /* (467) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  374,   -1 }, /* (468) query_expression_body ::= query_primary */
  {  374,   -4 }, /* (469) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  374,   -3 }, /* (470) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  378,   -1 }, /* (471) query_primary ::= query_specification */
  {  378,   -6 }, /* (472) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  375,    0 }, /* (473) order_by_clause_opt ::= */
  {  375,   -3 }, /* (474) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  376,    0 }, /* (475) slimit_clause_opt ::= */
  {  376,   -2 }, /* (476) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  376,   -4 }, /* (477) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  376,   -4 }, /* (478) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  377,    0 }, /* (479) limit_clause_opt ::= */
  {  377,   -2 }, /* (480) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  377,   -4 }, /* (481) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  377,   -4 }, /* (482) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  339,   -3 }, /* (483) subquery ::= NK_LP query_expression NK_RP */
  {  360,   -1 }, /* (484) search_condition ::= common_expression */
  {  379,   -1 }, /* (485) sort_specification_list ::= sort_specification */
  {  379,   -3 }, /* (486) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  380,   -3 }, /* (487) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  381,    0 }, /* (488) ordering_specification_opt ::= */
  {  381,   -1 }, /* (489) ordering_specification_opt ::= ASC */
  {  381,   -1 }, /* (490) ordering_specification_opt ::= DESC */
  {  382,    0 }, /* (491) null_ordering_opt ::= */
  {  382,   -2 }, /* (492) null_ordering_opt ::= NULLS FIRST */
  {  382,   -2 }, /* (493) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,261,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,262,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,261,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,263,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,264,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,262,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,264,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,263,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy231, &yymsp[-1].minor.yy0, yymsp[0].minor.yy425); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy231, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy231, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy231, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy231); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy425 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy425 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy59, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy231); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy59, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy231); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy59 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy59 = yymsp[0].minor.yy59; }
  yymsp[0].minor.yy59 = yylhsminor.yy59;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy59 = yymsp[-2].minor.yy59 | yymsp[0].minor.yy59; }
  yymsp[-2].minor.yy59 = yylhsminor.yy59;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy59 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy59 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy231 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy231 = yylhsminor.yy231;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy231 = yymsp[-2].minor.yy231; }
  yymsp[-2].minor.yy231 = yylhsminor.yy231;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy231, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy231); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 316: /* db_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* table_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* column_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* function_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* table_alias ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* column_alias ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* user_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* index_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* topic_name ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* stream_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 362: /* noarg_func ::= NOW */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= TODAY */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==367);
      case 368: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==368);
      case 369: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==369);
      case 370: /* noarg_func ::= USER */ yytestcase(yyruleno==370);
      case 371: /* star_func ::= COUNT */ yytestcase(yyruleno==371);
      case 372: /* star_func ::= FIRST */ yytestcase(yyruleno==372);
      case 373: /* star_func ::= LAST */ yytestcase(yyruleno==373);
      case 374: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==374);
{ yylhsminor.yy231 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy231 = yylhsminor.yy231;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy611, &yymsp[-1].minor.yy231, yymsp[0].minor.yy160); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy611, &yymsp[0].minor.yy231); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy231); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy231, yymsp[0].minor.yy160); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy231); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy231); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy611 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 255: /* analyze_opt ::= */ yytestcase(yyruleno==255);
      case 263: /* agg_func_opt ::= */ yytestcase(yyruleno==263);
      case 428: /* set_quantifier_opt ::= */ yytestcase(yyruleno==428);
{ yymsp[1].minor.yy611 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy611 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy160 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 79: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 80: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 81: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 82: /* db_options ::= db_options KEEP integer_list */
      case 83: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==83);
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_KEEP, yymsp[0].minor.yy180); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 84: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 85: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 89: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 90: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 91: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 92: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_RETENTIONS, yymsp[0].minor.yy180); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 93: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 94: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-3].minor.yy160, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-3].minor.yy160, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 98: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 99: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy160 = setDatabaseOption(pCxt, yymsp[-2].minor.yy160, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 100: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy160 = createAlterDatabaseOptions(pCxt); yylhsminor.yy160 = setAlterDatabaseOption(pCxt, yylhsminor.yy160, &yymsp[0].minor.yy189); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 101: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy160 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy160, &yymsp[0].minor.yy189); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 102: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy189.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= KEEP integer_list */
      case 106: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==106);
{ yymsp[-1].minor.yy189.type = DB_OPTION_KEEP; yymsp[-1].minor.yy189.pList = yymsp[0].minor.yy180; }
        break;
      case 107: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_WAL; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy180 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 109: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 285: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==285);
{ yylhsminor.yy180 = addNodeToList(pCxt, yymsp[-2].minor.yy180, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy180 = yylhsminor.yy180;
        break;
      case 110: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy180 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 111: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy180 = addNodeToList(pCxt, yymsp[-2].minor.yy180, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy180 = yylhsminor.yy180;
        break;
      case 112: /* retention_list ::= retention */
      case 132: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==132);
      case 135: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==135);
      case 142: /* column_def_list ::= column_def */ yytestcase(yyruleno==142);
      case 185: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==185);
      case 190: /* col_name_list ::= col_name */ yytestcase(yyruleno==190);
      case 238: /* func_list ::= func */ yytestcase(yyruleno==238);
      case 314: /* literal_list ::= signed_literal */ yytestcase(yyruleno==314);
      case 377: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==377);
      case 431: /* select_list ::= select_item */ yytestcase(yyruleno==431);
      case 485: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==485);
{ yylhsminor.yy180 = createNodeList(pCxt, yymsp[0].minor.yy160); }
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 113: /* retention_list ::= retention_list NK_COMMA retention */
      case 143: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==143);
      case 186: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==186);
      case 191: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==191);
      case 239: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==239);
      case 315: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==315);
      case 378: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==378);
      case 432: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==432);
      case 486: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==486);
{ yylhsminor.yy180 = addNodeToList(pCxt, yymsp[-2].minor.yy180, yymsp[0].minor.yy160); }
  yymsp[-2].minor.yy180 = yylhsminor.yy180;
        break;
      case 114: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy160 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 115: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 117: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==117);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy611, yymsp[-5].minor.yy160, yymsp[-3].minor.yy180, yymsp[-1].minor.yy180, yymsp[0].minor.yy160); }
        break;
      case 116: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy180); }
        break;
      case 118: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy180); }
        break;
      case 119: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy611, yymsp[0].minor.yy160); }
        break;
      case 120: /* cmd ::= ALTER TABLE alter_table_clause */
      case 288: /* cmd ::= query_expression */ yytestcase(yyruleno==288);
{ pCxt->pRootNode = yymsp[0].minor.yy160; }
        break;
      case 121: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy160); }
        break;
      case 122: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy160 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy160, yymsp[0].minor.yy160); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 123: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy160 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy160, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy231, yymsp[0].minor.yy190); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 124: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy160 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy160, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy231); }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 125: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy160 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy160, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy231, yymsp[0].minor.yy190); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 126: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy160 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy160, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy231, &yymsp[0].minor.yy231); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 127: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy160 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy160, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy231, yymsp[0].minor.yy190); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 128: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy160 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy160, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy231); }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 129: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy160 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy160, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy231, yymsp[0].minor.yy190); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 130: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy160 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy160, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy231, &yymsp[0].minor.yy231); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 131: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy160 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy160, &yymsp[-2].minor.yy231, yymsp[0].minor.yy160); }
  yymsp[-5].minor.yy160 = yylhsminor.yy160;
        break;
      case 133: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 136: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==136);
{ yylhsminor.yy180 = addNodeToList(pCxt, yymsp[-1].minor.yy180, yymsp[0].minor.yy160); }
  yymsp[-1].minor.yy180 = yylhsminor.yy180;
        break;
      case 134: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy160 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy611, yymsp[-8].minor.yy160, yymsp[-6].minor.yy160, yymsp[-5].minor.yy180, yymsp[-2].minor.yy180, yymsp[0].minor.yy160); }
  yymsp[-9].minor.yy160 = yylhsminor.yy160;
        break;
      case 137: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy160 = createDropTableClause(pCxt, yymsp[-1].minor.yy611, yymsp[0].minor.yy160); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 138: /* specific_cols_opt ::= */
      case 169: /* tags_def_opt ::= */ yytestcase(yyruleno==169);
      case 440: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==440);
      case 457: /* group_by_clause_opt ::= */ yytestcase(yyruleno==457);
      case 473: /* order_by_clause_opt ::= */ yytestcase(yyruleno==473);
{ yymsp[1].minor.yy180 = NULL; }
        break;
      case 139: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy180 = yymsp[-1].minor.yy180; }
        break;
      case 140: /* full_table_name ::= table_name */
{ yylhsminor.yy160 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy231, NULL); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 141: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy160 = createRealTableNode(pCxt, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy231, NULL); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 144: /* column_def ::= column_name type_name */
{ yylhsminor.yy160 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy231, yymsp[0].minor.yy190, NULL); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 145: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy160 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy231, yymsp[-2].minor.yy190, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 146: /* type_name ::= BOOL */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 147: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 148: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 149: /* type_name ::= INT */
      case 150: /* type_name ::= INTEGER */ yytestcase(yyruleno==150);
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 151: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 152: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 153: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 154: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy190 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 155: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 156: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy190 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy190 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 158: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy190 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 159: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy190 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 160: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy190 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 161: /* type_name ::= JSON */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 162: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy190 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 163: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 164: /* type_name ::= BLOB */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 165: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy190 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy190 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 167: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy190 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 168: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy190 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 170: /* tags_def_opt ::= tags_def */
      case 376: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==376);
{ yylhsminor.yy180 = yymsp[0].minor.yy180; }
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 171: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy180 = yymsp[-1].minor.yy180; }
        break;
      case 172: /* table_options ::= */
{ yymsp[1].minor.yy160 = createDefaultTableOptions(pCxt); }
        break;
      case 173: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy160 = setTableOption(pCxt, yymsp[-2].minor.yy160, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 174: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy160 = setTableOption(pCxt, yymsp[-2].minor.yy160, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy180); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 175: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy160 = setTableOption(pCxt, yymsp[-2].minor.yy160, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy180); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 176: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy160 = setTableOption(pCxt, yymsp[-4].minor.yy160, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy180); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 177: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy160 = setTableOption(pCxt, yymsp[-2].minor.yy160, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 178: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy160 = setTableOption(pCxt, yymsp[-4].minor.yy160, TABLE_OPTION_SMA, yymsp[-1].minor.yy180); }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 179: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy160 = createAlterTableOptions(pCxt); yylhsminor.yy160 = setTableOption(pCxt, yylhsminor.yy160, yymsp[0].minor.yy189.type, &yymsp[0].minor.yy189.val); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 180: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy160 = setTableOption(pCxt, yymsp[-1].minor.yy160, yymsp[0].minor.yy189.type, &yymsp[0].minor.yy189.val); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 181: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy189.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 182: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy189.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 183: /* duration_list ::= duration_literal */
      case 343: /* expression_list ::= expression */ yytestcase(yyruleno==343);
{ yylhsminor.yy180 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy160)); }
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 184: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 344: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==344);
{ yylhsminor.yy180 = addNodeToList(pCxt, yymsp[-2].minor.yy180, releaseRawExprNode(pCxt, yymsp[0].minor.yy160)); }
  yymsp[-2].minor.yy180 = yylhsminor.yy180;
        break;
      case 187: /* rollup_func_name ::= function_name */
{ yylhsminor.yy160 = createFunctionNode(pCxt, &yymsp[0].minor.yy231, NULL); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 188: /* rollup_func_name ::= FIRST */
      case 189: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==189);
{ yylhsminor.yy160 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 192: /* col_name ::= column_name */
{ yylhsminor.yy160 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy231); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 193: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 195: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 196: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy160, yymsp[0].minor.yy160, OP_TYPE_LIKE); }
        break;
      case 197: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy160, yymsp[0].minor.yy160, OP_TYPE_LIKE); }
        break;
      case 198: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy160, NULL, OP_TYPE_LIKE); }
        break;
      case 199: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 200: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 201: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 202: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy160, yymsp[-1].minor.yy160, OP_TYPE_EQUAL); }
        break;
      case 204: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 205: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 206: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 207: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW LICENCE */
      case 209: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==209);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 210: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy231); }
        break;
      case 211: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy160); }
        break;
      case 212: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy160); }
        break;
      case 213: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 215: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 216: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 217: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 218: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 219: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 220: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 221: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 222: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy160); }
        break;
      case 224: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy160, yymsp[-1].minor.yy160, OP_TYPE_EQUAL); }
        break;
      case 227: /* db_name_cond_opt ::= */
      case 232: /* from_db_opt ::= */ yytestcase(yyruleno==232);
{ yymsp[1].minor.yy160 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 228: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy231); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 229: /* like_pattern_opt ::= */
      case 269: /* into_opt ::= */ yytestcase(yyruleno==269);
      case 409: /* from_clause_opt ::= */ yytestcase(yyruleno==409);
      case 438: /* where_clause_opt ::= */ yytestcase(yyruleno==438);
      case 442: /* twindow_clause_opt ::= */ yytestcase(yyruleno==442);
      case 447: /* sliding_opt ::= */ yytestcase(yyruleno==447);
      case 449: /* fill_opt ::= */ yytestcase(yyruleno==449);
      case 461: /* having_clause_opt ::= */ yytestcase(yyruleno==461);
      case 463: /* range_opt ::= */ yytestcase(yyruleno==463);
      case 465: /* every_opt ::= */ yytestcase(yyruleno==465);
      case 475: /* slimit_clause_opt ::= */ yytestcase(yyruleno==475);
      case 479: /* limit_clause_opt ::= */ yytestcase(yyruleno==479);
{ yymsp[1].minor.yy160 = NULL; }
        break;
      case 230: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 231: /* table_name_cond ::= table_name */
{ yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy231); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 233: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy231); }
        break;
      case 234: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy611, &yymsp[-3].minor.yy231, &yymsp[-1].minor.yy231, NULL, yymsp[0].minor.yy160); }
        break;
      case 235: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy611, &yymsp[0].minor.yy231); }
        break;
      case 236: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy160 = createIndexOption(pCxt, yymsp[-7].minor.yy180, releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), NULL, yymsp[-1].minor.yy160, yymsp[0].minor.yy160); }
        break;
      case 237: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy160 = createIndexOption(pCxt, yymsp[-9].minor.yy180, releaseRawExprNode(pCxt, yymsp[-5].minor.yy160), releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), yymsp[-1].minor.yy160, yymsp[0].minor.yy160); }
        break;
      case 240: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy160 = createFunctionNode(pCxt, &yymsp[-3].minor.yy231, yymsp[-1].minor.yy180); }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 241: /* sma_stream_opt ::= */
      case 271: /* stream_options ::= */ yytestcase(yyruleno==271);
{ yymsp[1].minor.yy160 = createStreamOptions(pCxt); }
        break;
      case 242: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 275: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==275);
{ ((SStreamOptions*)yymsp[-2].minor.yy160)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy160); yylhsminor.yy160 = yymsp[-2].minor.yy160; }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 243: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy160)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy160); yylhsminor.yy160 = yymsp[-2].minor.yy160; }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy611, &yymsp[-2].minor.yy231, yymsp[0].minor.yy160); }
        break;
      case 245: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy611, &yymsp[-3].minor.yy231, &yymsp[0].minor.yy231, false); }
        break;
      case 246: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy611, &yymsp[-5].minor.yy231, &yymsp[0].minor.yy231, true); }
        break;
      case 247: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy611, &yymsp[-3].minor.yy231, yymsp[0].minor.yy160, false); }
        break;
      case 248: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy611, &yymsp[-5].minor.yy231, yymsp[0].minor.yy160, true); }
        break;
      case 249: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy611, &yymsp[0].minor.yy231); }
        break;
      case 250: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy611, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy231); }
        break;
      case 251: /* cmd ::= DESC full_table_name */
      case 252: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==252);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy160); }
        break;
      case 253: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 254: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy611, yymsp[-1].minor.yy160, yymsp[0].minor.yy160); }
        break;
      case 256: /* analyze_opt ::= ANALYZE */
      case 264: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==264);
      case 429: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==429);
{ yymsp[0].minor.yy611 = true; }
        break;
      case 257: /* explain_options ::= */
{ yymsp[1].minor.yy160 = createDefaultExplainOptions(pCxt); }
        break;
      case 258: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy160 = setExplainVerbose(pCxt, yymsp[-2].minor.yy160, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 259: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy160 = setExplainRatio(pCxt, yymsp[-2].minor.yy160, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 260: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,277,&yymsp[-1].minor);
        break;
      case 261: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy611, yymsp[-8].minor.yy611, &yymsp[-5].minor.yy231, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy190, yymsp[0].minor.yy516); }
        break;
      case 262: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy611, &yymsp[0].minor.yy231); }
        break;
      case 265: /* bufsize_opt ::= */
{ yymsp[1].minor.yy516 = 0; }
        break;
      case 266: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy516 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 267: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy611, &yymsp[-4].minor.yy231, yymsp[-2].minor.yy160, yymsp[-3].minor.yy160, yymsp[0].minor.yy160); }
        break;
      case 268: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy611, &yymsp[0].minor.yy231); }
        break;
      case 270: /* into_opt ::= INTO full_table_name */
      case 410: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==410);
      case 439: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==439);
      case 462: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==462);
{ yymsp[-1].minor.yy160 = yymsp[0].minor.yy160; }
        break;
      case 272: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy160)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy160 = yymsp[-2].minor.yy160; }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 273: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy160)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy160 = yymsp[-2].minor.yy160; }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 274: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy160)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy160)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy160); yylhsminor.yy160 = yymsp[-3].minor.yy160; }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 276: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy160)->ignoreExpired = true; yylhsminor.yy160 = yymsp[-2].minor.yy160; }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 277: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 278: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 280: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 281: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 282: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy180); }
        break;
      case 283: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 284: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy180 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 286: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy231); }
        break;
      case 287: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy160, yymsp[0].minor.yy160); }
        break;
      case 289: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy160, yymsp[-2].minor.yy180, yymsp[0].minor.yy160); }
        break;
      case 290: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy160, NULL, yymsp[0].minor.yy160); }
        break;
      case 291: /* literal ::= NK_INTEGER */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 292: /* literal ::= NK_FLOAT */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 293: /* literal ::= NK_STRING */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 294: /* literal ::= NK_BOOL */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 295: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 296: /* literal ::= duration_literal */
      case 306: /* signed_literal ::= signed */ yytestcase(yyruleno==306);
      case 327: /* expression ::= literal */ yytestcase(yyruleno==327);
      case 328: /* expression ::= pseudo_column */ yytestcase(yyruleno==328);
      case 329: /* expression ::= column_reference */ yytestcase(yyruleno==329);
      case 330: /* expression ::= function_expression */ yytestcase(yyruleno==330);
      case 331: /* expression ::= subquery */ yytestcase(yyruleno==331);
      case 359: /* function_expression ::= literal_func */ yytestcase(yyruleno==359);
      case 401: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==401);
      case 405: /* boolean_primary ::= predicate */ yytestcase(yyruleno==405);
      case 407: /* common_expression ::= expression */ yytestcase(yyruleno==407);
      case 408: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==408);
      case 411: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==411);
      case 413: /* table_reference ::= table_primary */ yytestcase(yyruleno==413);
      case 414: /* table_reference ::= joined_table */ yytestcase(yyruleno==414);
      case 418: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==418);
      case 468: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==468);
      case 471: /* query_primary ::= query_specification */ yytestcase(yyruleno==471);
{ yylhsminor.yy160 = yymsp[0].minor.yy160; }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 297: /* literal ::= NULL */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 298: /* literal ::= NK_QUESTION */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 299: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 300: /* signed ::= NK_INTEGER */
{ yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 301: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 302: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 303: /* signed ::= NK_FLOAT */
{ yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 304: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 305: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 307: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 308: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 309: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 310: /* signed_literal ::= duration_literal */
      case 312: /* signed_literal ::= literal_func */ yytestcase(yyruleno==312);
      case 379: /* star_func_para ::= expression */ yytestcase(yyruleno==379);
      case 434: /* select_item ::= common_expression */ yytestcase(yyruleno==434);
      case 484: /* search_condition ::= common_expression */ yytestcase(yyruleno==484);
{ yylhsminor.yy160 = releaseRawExprNode(pCxt, yymsp[0].minor.yy160); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 311: /* signed_literal ::= NULL */
{ yylhsminor.yy160 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 313: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy160 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 332: /* expression ::= NK_LP expression NK_RP */
      case 406: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==406);
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy160)); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 333: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy160));
                                                                                  }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 334: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy160), NULL));
                                                                                  }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 335: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160))); 
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 336: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160))); 
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 337: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160))); 
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 338: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160))); 
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 339: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 340: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 341: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 342: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 345: /* column_reference ::= column_name */
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy231, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy231)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 346: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy231, createColumnNode(pCxt, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy231)); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 347: /* pseudo_column ::= ROWTS */
      case 348: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==348);
      case 350: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==350);
      case 351: /* pseudo_column ::= QEND */ yytestcase(yyruleno==351);
      case 352: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==352);
      case 353: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==353);
      case 354: /* pseudo_column ::= WEND */ yytestcase(yyruleno==354);
      case 355: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==355);
      case 361: /* literal_func ::= NOW */ yytestcase(yyruleno==361);
{ yylhsminor.yy160 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 349: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy231)))); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 356: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 357: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==357);
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy231, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy231, yymsp[-1].minor.yy180)); }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 358: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), yymsp[-1].minor.yy190)); }
  yymsp[-5].minor.yy160 = yylhsminor.yy160;
        break;
      case 360: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy231, NULL)); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 375: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy180 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 380: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 437: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==437);
{ yylhsminor.yy160 = createColumnNode(pCxt, &yymsp[-2].minor.yy231, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 381: /* predicate ::= expression compare_op expression */
      case 386: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==386);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy598, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 382: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy160), releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-4].minor.yy160 = yylhsminor.yy160;
        break;
      case 383: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy160), releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-5].minor.yy160 = yylhsminor.yy160;
        break;
      case 384: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), NULL));
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 385: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), NULL));
                                                                                  }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 387: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy598 = OP_TYPE_LOWER_THAN; }
        break;
      case 388: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy598 = OP_TYPE_GREATER_THAN; }
        break;
      case 389: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy598 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 390: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy598 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 391: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy598 = OP_TYPE_NOT_EQUAL; }
        break;
      case 392: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy598 = OP_TYPE_EQUAL; }
        break;
      case 393: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy598 = OP_TYPE_LIKE; }
        break;
      case 394: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy598 = OP_TYPE_NOT_LIKE; }
        break;
      case 395: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy598 = OP_TYPE_MATCH; }
        break;
      case 396: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy598 = OP_TYPE_NMATCH; }
        break;
      case 397: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy598 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 398: /* in_op ::= IN */
{ yymsp[0].minor.yy598 = OP_TYPE_IN; }
        break;
      case 399: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy598 = OP_TYPE_NOT_IN; }
        break;
      case 400: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy180)); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 402: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy160), NULL));
                                                                                  }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 403: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 404: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy160);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy160);
                                                                                    yylhsminor.yy160 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), releaseRawExprNode(pCxt, yymsp[0].minor.yy160)));
                                                                                  }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 412: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy160 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy160, yymsp[0].minor.yy160, NULL); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 415: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy160 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy231, &yymsp[0].minor.yy231); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 416: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy160 = createRealTableNode(pCxt, &yymsp[-3].minor.yy231, &yymsp[-1].minor.yy231, &yymsp[0].minor.yy231); }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 417: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy160 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy160), &yymsp[0].minor.yy231); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 419: /* alias_opt ::= */
{ yymsp[1].minor.yy231 = nil_token;  }
        break;
      case 420: /* alias_opt ::= table_alias */
{ yylhsminor.yy231 = yymsp[0].minor.yy231; }
  yymsp[0].minor.yy231 = yylhsminor.yy231;
        break;
      case 421: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy231 = yymsp[0].minor.yy231; }
        break;
      case 422: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 423: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==423);
{ yymsp[-2].minor.yy160 = yymsp[-1].minor.yy160; }
        break;
      case 424: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy160 = createJoinTableNode(pCxt, yymsp[-4].minor.yy652, yymsp[-5].minor.yy160, yymsp[-2].minor.yy160, yymsp[0].minor.yy160); }
  yymsp[-5].minor.yy160 = yylhsminor.yy160;
        break;
      case 425: /* join_type ::= */
{ yymsp[1].minor.yy652 = JOIN_TYPE_INNER; }
        break;
      case 426: /* join_type ::= INNER */
{ yymsp[0].minor.yy652 = JOIN_TYPE_INNER; }
        break;
      case 427: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy160 = createSelectStmt(pCxt, yymsp[-10].minor.yy611, yymsp[-9].minor.yy180, yymsp[-8].minor.yy160);
                                                                                    yymsp[-11].minor.yy160 = addWhereClause(pCxt, yymsp[-11].minor.yy160, yymsp[-7].minor.yy160);
                                                                                    yymsp[-11].minor.yy160 = addPartitionByClause(pCxt, yymsp[-11].minor.yy160, yymsp[-6].minor.yy180);
                                                                                    yymsp[-11].minor.yy160 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy160, yymsp[-2].minor.yy160);
                                                                                    yymsp[-11].minor.yy160 = addGroupByClause(pCxt, yymsp[-11].minor.yy160, yymsp[-1].minor.yy180);
                                                                                    yymsp[-11].minor.yy160 = addHavingClause(pCxt, yymsp[-11].minor.yy160, yymsp[0].minor.yy160);
                                                                                    yymsp[-11].minor.yy160 = addRangeClause(pCxt, yymsp[-11].minor.yy160, yymsp[-5].minor.yy160);
                                                                                    yymsp[-11].minor.yy160 = addEveryClause(pCxt, yymsp[-11].minor.yy160, yymsp[-4].minor.yy160);
                                                                                    yymsp[-11].minor.yy160 = addFillClause(pCxt, yymsp[-11].minor.yy160, yymsp[-3].minor.yy160);
                                                                                  }
        break;
      case 430: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy611 = false; }
        break;
      case 433: /* select_item ::= NK_STAR */
{ yylhsminor.yy160 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy160 = yylhsminor.yy160;
        break;
      case 435: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy160 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy160), &yymsp[0].minor.yy231); }
  yymsp[-1].minor.yy160 = yylhsminor.yy160;
        break;
      case 436: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy160 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), &yymsp[0].minor.yy231); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 441: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 458: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==458);
      case 474: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==474);
{ yymsp[-2].minor.yy180 = yymsp[0].minor.yy180; }
        break;
      case 443: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy160 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), releaseRawExprNode(pCxt, yymsp[-1].minor.yy160)); }
        break;
      case 444: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy160 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy160)); }
        break;
      case 445: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy160 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), NULL, yymsp[-1].minor.yy160, yymsp[0].minor.yy160); }
        break;
      case 446: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy160 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy160), releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), yymsp[-1].minor.yy160, yymsp[0].minor.yy160); }
        break;
      case 448: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 466: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==466);
{ yymsp[-3].minor.yy160 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy160); }
        break;
      case 450: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy160 = createFillNode(pCxt, yymsp[-1].minor.yy338, NULL); }
        break;
      case 451: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy160 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy180)); }
        break;
      case 452: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy338 = FILL_MODE_NONE; }
        break;
      case 453: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy338 = FILL_MODE_PREV; }
        break;
      case 454: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy338 = FILL_MODE_NULL; }
        break;
      case 455: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy338 = FILL_MODE_LINEAR; }
        break;
      case 456: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy338 = FILL_MODE_NEXT; }
        break;
      case 459: /* group_by_list ::= expression */
{ yylhsminor.yy180 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy160))); }
  yymsp[0].minor.yy180 = yylhsminor.yy180;
        break;
      case 460: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy180 = addNodeToList(pCxt, yymsp[-2].minor.yy180, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy160))); }
  yymsp[-2].minor.yy180 = yylhsminor.yy180;
        break;
      case 464: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy160 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy160), releaseRawExprNode(pCxt, yymsp[-1].minor.yy160)); }
        break;
      case 467: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy160 = addOrderByClause(pCxt, yymsp[-3].minor.yy160, yymsp[-2].minor.yy180);
                                                                                    yylhsminor.yy160 = addSlimitClause(pCxt, yylhsminor.yy160, yymsp[-1].minor.yy160);
                                                                                    yylhsminor.yy160 = addLimitClause(pCxt, yylhsminor.yy160, yymsp[0].minor.yy160);
                                                                                  }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 469: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy160 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy160, yymsp[0].minor.yy160); }
  yymsp[-3].minor.yy160 = yylhsminor.yy160;
        break;
      case 470: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy160 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy160, yymsp[0].minor.yy160); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 472: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy160 = addOrderByClause(pCxt, yymsp[-4].minor.yy160, yymsp[-3].minor.yy180);
                                                                                    yymsp[-5].minor.yy160 = addSlimitClause(pCxt, yymsp[-5].minor.yy160, yymsp[-2].minor.yy160);
                                                                                    yymsp[-5].minor.yy160 = addLimitClause(pCxt, yymsp[-5].minor.yy160, yymsp[-1].minor.yy160);
                                                                                  }
        break;
      case 476: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 480: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==480);
{ yymsp[-1].minor.yy160 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 477: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 481: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==481);
{ yymsp[-3].minor.yy160 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 478: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 482: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==482);
{ yymsp[-3].minor.yy160 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 483: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy160 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy160); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 487: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy160 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy160), yymsp[-1].minor.yy742, yymsp[0].minor.yy283); }
  yymsp[-2].minor.yy160 = yylhsminor.yy160;
        break;
      case 488: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy742 = ORDER_ASC; }
        break;
      case 489: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy742 = ORDER_ASC; }
        break;
      case 490: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy742 = ORDER_DESC; }
        break;
      case 491: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy283 = NULL_ORDER_DEFAULT; }
        break;
      case 492: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy283 = NULL_ORDER_FIRST; }
        break;
      case 493: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy283 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
