/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 360
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy54;
  int32_t yy100;
  bool yy137;
  int64_t yy189;
  SToken yy209;
  ENullOrder yy217;
  SDataType yy304;
  EOperatorType yy380;
  SNodeList* yy424;
  EOrder yy578;
  SAlterOption yy605;
  EJoinType yy612;
  SNode* yy632;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             619
#define YYNRULE              454
#define YYNTOKEN             240
#define YY_MAX_SHIFT         618
#define YY_MIN_SHIFTREDUCE   906
#define YY_MAX_SHIFTREDUCE   1359
#define YY_ERROR_ACTION      1360
#define YY_ACCEPT_ACTION     1361
#define YY_NO_ACTION         1362
#define YY_MIN_REDUCE        1363
#define YY_MAX_REDUCE        1816
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2152)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    28,  231, 1663, 1650,  611,  610,  297, 1650,  358, 1485,
 /*    10 */   314, 1483,   35,   33,  352,   36,   34,   32,   31,   30,
 /*    20 */   306,   24, 1173, 1647,  533,  442,  441, 1647,   79, 1647,
 /*    30 */  1679,   36,   34,   32,   31,   30,  152,  493,  517, 1643,
 /*    40 */  1649,  115,  278, 1643, 1649, 1643, 1649, 1171,  516, 1486,
 /*    50 */   536,  533, 1633, 1494,  536, 1794,  536,  497,   14, 1746,
 /*    60 */    35,   33, 1300,  356, 1179, 1663,  114,  147,  306, 1692,
 /*    70 */  1173, 1791,   82, 1664,  519, 1666, 1667,  515,  532,  536,
 /*    80 */  1494,    1, 1732, 1743, 1794, 1314,  280, 1728,   36,   34,
 /*    90 */    32,   31,   30, 1679,  410, 1171, 1793, 1651, 1794,  520,
 /*   100 */  1791,  517,  309,  615,  112, 1583,   14, 1746,   35,   33,
 /*   110 */   149,  516, 1179, 1172, 1791, 1633,  306, 1647, 1173,  145,
 /*   120 */  1739, 1740,  532, 1744,   36,   34,   32,   31,   30,    2,
 /*   130 */    63, 1742, 1692, 1643, 1649,   84, 1664,  519, 1666, 1667,
 /*   140 */   515, 1364,  536, 1171,  536, 1732,  953, 1794,  952, 1731,
 /*   150 */  1728,  615, 1490,   72,   14,  392, 1174,  393, 1395,  148,
 /*   160 */  1179, 1172,   96, 1791,  532,   95,   94,   93,   92,   91,
 /*   170 */    90,   89,   88,   87, 1487,  954,   56,    2,  132,  201,
 /*   180 */  1375, 1177, 1178,   39, 1224, 1225, 1227, 1228, 1229, 1230,
 /*   190 */  1231,  512,  534, 1239, 1240, 1241, 1242, 1243, 1244,  615,
 /*   200 */   400,  952,  393, 1395, 1174,   55, 1197,   66,  133, 1172,
 /*   210 */    96,  150, 1451,   95,   94,   93,   92,   91,   90,   89,
 /*   220 */    88,   87,   65,  279, 1356,   38,  429,  194,  567, 1177,
 /*   230 */  1178, 1363, 1224, 1225, 1227, 1228, 1229, 1230, 1231,  512,
 /*   240 */   534, 1239, 1240, 1241, 1242, 1243, 1244,  566,  487,  565,
 /*   250 */   564,  563, 1174,   55,   63,  105,  104,  103,  102,  101,
 /*   260 */   100,   99,   98,   97,  936,   35,   33,  110,   36,   34,
 /*   270 */    32,   31,   30,  306, 1746, 1173, 1489, 1177, 1178, 1198,
 /*   280 */  1224, 1225, 1227, 1228, 1229, 1230, 1231,  512,  534, 1239,
 /*   290 */  1240, 1241, 1242, 1243, 1244,   55,  445,  444, 1741, 1538,
 /*   300 */  1171,  443,  940,  941,  111,  440,  296, 1355,  439,  438,
 /*   310 */   437, 1536,  569,   35,   33, 1245, 1679, 1179,   26,  310,
 /*   320 */  1386,  306,  391, 1173,  486,  395,  290,  130,   36,   34,
 /*   330 */    32,   31,   30, 1196,    8,  150, 1496, 1043,  559,  558,
 /*   340 */   557, 1047,  556, 1049, 1050,  555, 1052,  552, 1171, 1058,
 /*   350 */   549, 1060, 1061,  546,  543,  150,  615,  450,  482,  618,
 /*   360 */   485,   35,   33,  585,  583, 1179, 1172,  142,  397,  306,
 /*   370 */  1633, 1173,  458,  248, 1195,  291, 1324,  289,  288, 1532,
 /*   380 */   433,  318,    9,  150,  435,  107,  193,  399, 1574, 1576,
 /*   390 */   395,  607,  603,  599,  595,  247, 1171, 1472,  453,  157,
 /*   400 */   533,  129, 1361,  447,  615, 1425,  434,  572,  192, 1174,
 /*   410 */  1794, 1385,  357, 1179, 1172,  479, 1322, 1323, 1325, 1326,
 /*   420 */    80, 1571, 1792,  242,   61,  150, 1791,   60,  159, 1494,
 /*   430 */     9,  488,  483,   51, 1177, 1178,   50, 1224, 1225, 1227,
 /*   440 */  1228, 1229, 1230, 1231,  512,  534, 1239, 1240, 1241, 1242,
 /*   450 */  1243, 1244,  615,   55,  410,  316,  529, 1174,   54,  319,
 /*   460 */   322, 1633, 1172,  130,  150,  445,  444,  130, 1538,  562,
 /*   470 */   443,  382, 1496,  111,  440,  311, 1496,  439,  438,  437,
 /*   480 */  1536,  474, 1177, 1178,  203, 1224, 1225, 1227, 1228, 1229,
 /*   490 */  1230, 1231,  512,  534, 1239, 1240, 1241, 1242, 1243, 1244,
 /*   500 */  1384, 1794, 1147, 1199,  197, 1174, 1575, 1576,   36,   34,
 /*   510 */    32,   31,   30,  147, 1307,  161,  160, 1791,   35,   33,
 /*   520 */  1197, 1663, 1155, 1156,  195, 1470,  306,  351, 1173,  350,
 /*   530 */  1177, 1178,  493, 1224, 1225, 1227, 1228, 1229, 1230, 1231,
 /*   540 */   512,  534, 1239, 1240, 1241, 1242, 1243, 1244,  253, 1679,
 /*   550 */  1633, 1524,  533, 1171, 1383, 1621,  533,  517, 1382, 1250,
 /*   560 */   277,  114, 1195, 1005,  367, 1197, 1479,  516,  106,  375,
 /*   570 */  1179, 1633,  387,  466,  533,  431,  497, 1422, 1211,  469,
 /*   580 */  1007, 1494,  569,  150, 1381, 1494,  368,    2, 1692,  343,
 /*   590 */   388,   82, 1664,  519, 1666, 1667,  515, 1481,  536,  112,
 /*   600 */   331, 1732, 1477, 1494, 1633,  280, 1728,  198, 1633,  615,
 /*   610 */   345,  341,  533,  495,  144, 1739, 1740, 1794, 1744, 1172,
 /*   620 */  1794,  940,  941, 1538,  106, 1376,   11,   10,  222,  147,
 /*   630 */   317,  436,  147, 1791, 1633, 1536, 1791,  591,  590,  589,
 /*   640 */   321, 1494,  588,  587,  586,  116,  581,  580,  579,  578,
 /*   650 */   577,  576,  575,  574,  123,  570,   32,   31,   30, 1380,
 /*   660 */   386, 1299, 1174,  381,  380,  379,  378,  377,  374,  373,
 /*   670 */   372,  371,  370,  366,  365,  364,  363,  362,  361,  360,
 /*   680 */   359,  499, 1663,  520, 1379, 1226, 1197, 1177, 1178, 1584,
 /*   690 */  1224, 1225, 1227, 1228, 1229, 1230, 1231,  512,  534, 1239,
 /*   700 */  1240, 1241, 1242, 1243, 1244, 1264,  131, 1276, 1378, 1633,
 /*   710 */  1679,  259,  573,  533, 1466,    7,  511,  533,  496, 1471,
 /*   720 */  1200,  533,  459,  257,   53,  409, 1269,   52,  516, 1491,
 /*   730 */  1226,  533, 1633, 1610, 1633,  533,   36,   34,   32,   31,
 /*   740 */    30, 1377, 1494,  244,  162, 1374, 1494,  467, 1663, 1692,
 /*   750 */  1494,  501,   83, 1664,  519, 1666, 1667,  515, 1633,  536,
 /*   760 */  1494, 1373, 1732, 1794, 1494,   25,  299, 1728,  143,   55,
 /*   770 */    36,   34,   32,   31,   30,  147, 1679, 1469,  533, 1791,
 /*   780 */   223,  533,  281,  130,  517,  475, 1759,  435,  533, 1372,
 /*   790 */   530, 1633, 1497,  531,  516, 1633,  185, 1371, 1633,  183,
 /*   800 */   320,  476, 1370, 1369, 1663,   81, 1211, 1494, 1368,  434,
 /*   810 */  1494, 1633,  567,  504, 1262, 1692,  281, 1494,  274, 1664,
 /*   820 */   519, 1666, 1667,  515,  509,  536, 1751, 1295,  493,  561,
 /*   830 */   457,  566, 1679,  565,  564,  563,   59,   58,  355, 1633,
 /*   840 */   514,  156, 1452,  455, 1538,  207,  349, 1633, 1262,  584,
 /*   850 */   516, 1226, 1633, 1633, 1633, 1367, 1537,  114, 1633,  276,
 /*   860 */  1173,  226,  339, 1263,  337,  333,  329,  153,  324, 1298,
 /*   870 */   567, 1692, 1412, 1182,  273, 1664,  519, 1666, 1667,  515,
 /*   880 */   513,  536,  510, 1704, 1268, 1171, 1366, 1407, 1295,  566,
 /*   890 */   346,  565,  564,  563,  446,  112,  120, 1263,  187,  150,
 /*   900 */   189,  186, 1179,  188,  191, 1633, 1663,  190,   46,  448,
 /*   910 */   146, 1739, 1740, 1405, 1744,   11,   10, 1653, 1268, 1358,
 /*   920 */  1359,  480, 1181,   27,  304, 1257, 1258, 1259, 1260, 1261,
 /*   930 */  1265, 1266, 1267,  210, 1679,  451, 1633,  471,  502, 1185,
 /*   940 */    78,  615,  496,   37,   37,  460,   37, 1254,  233, 1321,
 /*   950 */    74, 1172,  516,  217, 1655, 1680, 1633,   27,  304, 1257,
 /*   960 */  1258, 1259, 1260, 1261, 1265, 1266, 1267,  118, 1663, 1396,
 /*   970 */   119, 1533,  120, 1692,  212,   46,   83, 1664,  519, 1666,
 /*   980 */  1667,  515,  977,  536, 1270, 1232, 1732, 1128, 1184,  235,
 /*   990 */   299, 1728,  143,  541, 1174,  428, 1679, 1762,  494,  978,
 /*  1000 */  1663,  225,  505,  119,  517,  228,  120,  230,  525,    3,
 /*  1010 */  1760,  241,    5, 1036,  516,  121,  252,  119, 1633, 1177,
 /*  1020 */  1178,  323, 1195,  326,  330,  286,  287, 1005, 1679,  249,
 /*  1030 */  1139,  369, 1573,  376, 1064, 1692,  517,  158,   83, 1664,
 /*  1040 */   519, 1666, 1667,  515, 1068,  536,  516, 1074, 1732,  384,
 /*  1050 */  1633,  389,  299, 1728, 1807,  383, 1072, 1201,  122,  385,
 /*  1060 */  1663,  390, 1204, 1766,  401,  398,  165, 1692,  402,  167,
 /*  1070 */    83, 1664,  519, 1666, 1667,  515, 1203,  536, 1205,  404,
 /*  1080 */  1732,  403,  170,  406,  299, 1728, 1807,  172, 1679,  407,
 /*  1090 */  1202,  175, 1663,  408,   62, 1789,  517,  411,  178,  430,
 /*  1100 */   432, 1484,  182,   86, 1480,  184,  516,  295,  124, 1179,
 /*  1110 */  1633,  125, 1482, 1478, 1615,  126,  127, 1614,  196,  461,
 /*  1120 */  1679,  199,  250,  202,  465,  462, 1200, 1692,  517,  468,
 /*  1130 */    83, 1664,  519, 1666, 1667,  515,  472,  536,  516,  205,
 /*  1140 */  1732,  481, 1633, 1663,  299, 1728, 1807,  497,  470,  478,
 /*  1150 */   473,  523, 1773, 1772,  298, 1750,  490,  208, 1763, 1692,
 /*  1160 */   211,    6,  264, 1664,  519, 1666, 1667,  515, 1753,  536,
 /*  1170 */   484, 1679,  216, 1663,  477,  113, 1295,  218, 1199,  517,
 /*  1180 */    40,  300, 1747,  506,  503,   18,  527, 1582, 1794,  516,
 /*  1190 */   137,  521,  522, 1633,  219, 1581,  526,  308,  497,  237,
 /*  1200 */   149, 1679,  528,  224, 1791,  251, 1663, 1495, 1713,  517,
 /*  1210 */  1692, 1810, 1790,  264, 1664,  519, 1666, 1667,  515,  516,
 /*  1220 */   536,  239,   71, 1633,   73,  539,  246,  254,  500,  614,
 /*  1230 */   136,  227, 1467,  229, 1679,  507, 1663,  265,   47, 1794,
 /*  1240 */  1692,  256,  517,   84, 1664,  519, 1666, 1667,  515,  258,
 /*  1250 */   536,  147,  516, 1732,  275, 1791, 1633,  508, 1728,  266,
 /*  1260 */  1627, 1626,   57, 1625, 1679,  325, 1622,  327,  328,  332,
 /*  1270 */  1166, 1167,  517, 1692,  154, 1620,  134, 1664,  519, 1666,
 /*  1280 */  1667,  515,  516,  536,  334,  335, 1633, 1663,  336, 1619,
 /*  1290 */   338, 1618,  340, 1617,  342, 1616, 1663,  344, 1600,  155,
 /*  1300 */  1142,  347, 1141, 1692,  348, 1594,   84, 1664,  519, 1666,
 /*  1310 */  1667,  515, 1593,  536,  353, 1679, 1732,  354, 1592,  498,
 /*  1320 */  1808, 1729, 1591,  517, 1679, 1111, 1566, 1565, 1564, 1563,
 /*  1330 */  1562, 1561,  517,  516, 1560, 1559, 1558, 1633, 1557, 1556,
 /*  1340 */  1555, 1554,  516, 1553, 1552, 1551, 1633, 1550, 1549,  117,
 /*  1350 */  1663, 1548, 1547, 1546, 1692, 1545, 1544,  269, 1664,  519,
 /*  1360 */  1666, 1667,  515, 1692,  536, 1543,  134, 1664,  519, 1666,
 /*  1370 */  1667,  515, 1113,  536, 1542, 1541, 1540, 1539, 1679, 1424,
 /*  1380 */  1392,  943,  163,  108,  942, 1391,  517, 1608, 1602, 1590,
 /*  1390 */  1663,  171, 1589,  394,  489,  140,  516,  164,  109,  169,
 /*  1400 */  1633,  396, 1579,  303,   45,  174, 1663, 1473, 1423, 1421,
 /*  1410 */  1809, 1419, 1417,  412,  413,  414,  417, 1692, 1679,  971,
 /*  1420 */   274, 1664,  519, 1666, 1667,  515,  514,  536,  416,  420,
 /*  1430 */   418,  421,  422, 1415, 1679,  426,  516,  424, 1404,  425,
 /*  1440 */  1633, 1403,  517, 1390, 1475, 1077,  181, 1078, 1474, 1413,
 /*  1450 */  1004,  582,  516, 1003, 1663,  584, 1633, 1692,  292,  305,
 /*  1460 */   273, 1664,  519, 1666, 1667,  515, 1408,  536, 1002, 1705,
 /*  1470 */   449, 1001,  998, 1692,  997,  996,  274, 1664,  519, 1666,
 /*  1480 */  1667,  515, 1679,  536,  293, 1406, 1663,  294, 1389,  452,
 /*  1490 */   517,  180, 1388,  454,  456,   85, 1607, 1149, 1601,  463,
 /*  1500 */   516, 1588, 1587,  141, 1633, 1586, 1578,  307,   49,  427,
 /*  1510 */   423,  419,  415,  179, 1679,   67, 1663,  204,  464,    4,
 /*  1520 */    37, 1692,  517,  206,  274, 1664,  519, 1666, 1667,  515,
 /*  1530 */    15,  536,  516,  128,  209,   43, 1633, 1320,   64,  200,
 /*  1540 */   135,  177,  213,  215, 1679,   22,   48, 1653,  214, 1313,
 /*  1550 */    68,   23,  517, 1692,   42, 1292,  260, 1664,  519, 1666,
 /*  1560 */  1667,  515,  516,  536,  221, 1291, 1633, 1663,  138, 1349,
 /*  1570 */    17, 1338, 1344, 1343,  301, 1348,   10, 1347,  302,   19,
 /*  1580 */  1255,  139, 1234, 1692,  151,   29,  268, 1664,  519, 1666,
 /*  1590 */  1667,  515,   12,  536, 1233, 1679,   20, 1219,  176,   16,
 /*  1600 */   168,  518,  173,  517,  405,   41,   13, 1663, 1577,  238,
 /*  1610 */    74,  524, 1652,  516,  232,   21,  234, 1633, 1318, 1189,
 /*  1620 */   236,  240,  166,   69,   70,  243, 1695,  540, 1236,  535,
 /*  1630 */    44, 1071, 1065,  538, 1692, 1679,  315,  270, 1664,  519,
 /*  1640 */  1666, 1667,  515,  517,  536,  542,  544, 1663, 1062, 1059,
 /*  1650 */   545,  547,  548,  516,  550, 1053,  553, 1633,  551, 1057,
 /*  1660 */  1051, 1056, 1663,  554, 1055, 1054,   75, 1042,   76,  560,
 /*  1670 */  1073,   77, 1070,  568, 1692, 1679,  969,  261, 1664,  519,
 /*  1680 */  1666, 1667,  515,  517,  536,  993, 1011,  245,  991,  571,
 /*  1690 */  1679,  986, 1008,  516,  990,  989,  988, 1633,  517,  987,
 /*  1700 */   985,  984, 1006,  981,  980,  979,  976,  975,  516,  974,
 /*  1710 */  1420,  592, 1633, 1663, 1692,  593,  594,  271, 1664,  519,
 /*  1720 */  1666, 1667,  515, 1418,  536, 1663,  597,  596,  598, 1692,
 /*  1730 */  1416,  600,  262, 1664,  519, 1666, 1667,  515,  601,  536,
 /*  1740 */   602, 1679,  604,  605,  606, 1402,  608,  609, 1401,  517,
 /*  1750 */  1414, 1387,  613, 1679,  612, 1175,  255,  616,  617,  516,
 /*  1760 */  1362,  517, 1362, 1633, 1362, 1663, 1362, 1362, 1362, 1362,
 /*  1770 */  1362,  516, 1362, 1362, 1362, 1633, 1663, 1362, 1362, 1362,
 /*  1780 */  1692, 1362, 1362,  272, 1664,  519, 1666, 1667,  515, 1362,
 /*  1790 */   536, 1362, 1692, 1679, 1362,  263, 1664,  519, 1666, 1667,
 /*  1800 */   515,  517,  536, 1362, 1679, 1362, 1362, 1362, 1362, 1362,
 /*  1810 */  1362,  516,  517, 1362, 1362, 1633, 1362, 1362, 1362, 1362,
 /*  1820 */  1362, 1362,  516, 1362, 1362, 1362, 1633, 1663, 1362, 1362,
 /*  1830 */  1362, 1362, 1692, 1362, 1362, 1675, 1664,  519, 1666, 1667,
 /*  1840 */   515, 1362,  536, 1692, 1362, 1362, 1674, 1664,  519, 1666,
 /*  1850 */  1667,  515, 1362,  536, 1362, 1679, 1362, 1663, 1362, 1362,
 /*  1860 */  1362, 1362, 1362,  517, 1362, 1362, 1362, 1362, 1362, 1362,
 /*  1870 */  1362, 1362, 1362,  516, 1362, 1362, 1362, 1633, 1362, 1362,
 /*  1880 */  1362, 1362, 1362, 1362, 1362, 1679, 1362, 1663, 1362, 1362,
 /*  1890 */  1362, 1362, 1362,  517, 1692, 1362, 1362, 1673, 1664,  519,
 /*  1900 */  1666, 1667,  515,  516,  536, 1362, 1362, 1633, 1362, 1362,
 /*  1910 */  1362, 1362, 1362, 1362, 1362, 1679, 1362, 1362, 1362, 1663,
 /*  1920 */  1362, 1362, 1362,  517, 1692, 1362, 1362,  284, 1664,  519,
 /*  1930 */  1666, 1667,  515,  516,  536, 1362, 1362, 1633, 1362, 1362,
 /*  1940 */  1362, 1362, 1362,  313,  312, 1362, 1362, 1679, 1362, 1362,
 /*  1950 */  1362, 1362, 1663, 1187, 1692,  517, 1362,  283, 1664,  519,
 /*  1960 */  1666, 1667,  515, 1362,  536,  516, 1362, 1362, 1362, 1633,
 /*  1970 */  1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1180, 1362,
 /*  1980 */  1679, 1362, 1362, 1362, 1362, 1663, 1692, 1362,  517,  285,
 /*  1990 */  1664,  519, 1666, 1667,  515, 1179,  536, 1362,  516, 1362,
 /*  2000 */  1362, 1362, 1633, 1362, 1362, 1362, 1362, 1362, 1362, 1362,
 /*  2010 */  1362, 1362, 1362, 1679, 1362, 1362,  493, 1362, 1362, 1692,
 /*  2020 */  1362,  517,  282, 1664,  519, 1666, 1667,  515, 1362,  536,
 /*  2030 */  1362,  516, 1362, 1362,  537, 1633, 1362, 1362, 1362, 1362,
 /*  2040 */  1362, 1362, 1362, 1362, 1183,  114,  493, 1362, 1362, 1362,
 /*  2050 */  1362, 1362, 1692, 1362, 1362,  267, 1664,  519, 1666, 1667,
 /*  2060 */   515, 1362,  536, 1362,  497, 1362, 1362, 1362, 1362, 1362,
 /*  2070 */  1362, 1362, 1362, 1362, 1362,  114, 1362, 1362, 1362, 1362,
 /*  2080 */  1362, 1362, 1362,  112, 1362, 1362, 1362, 1188, 1362, 1362,
 /*  2090 */  1362, 1362, 1362, 1362,  497, 1362, 1362, 1362,  220, 1739,
 /*  2100 */   492, 1362,  491, 1362, 1362, 1794, 1362, 1362, 1362, 1362,
 /*  2110 */  1362, 1362, 1191,  112, 1362, 1362, 1362,  149, 1362, 1362,
 /*  2120 */  1362, 1791, 1362,  534, 1239, 1240, 1362, 1362,  220, 1739,
 /*  2130 */   492, 1362,  491, 1362, 1362, 1794, 1362, 1362, 1362, 1362,
 /*  2140 */  1362, 1362, 1362, 1362, 1362, 1362, 1362,  147, 1362, 1362,
 /*  2150 */  1362, 1791,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   324,  325,  243,  273,  251,  252,  276,  273,  250,  273,
 /*    10 */   276,  272,   12,   13,  298,   12,   13,   14,   15,   16,
 /*    20 */    20,    2,   22,  293,  250,  257,  258,  293,  253,  293,
 /*    30 */   271,   12,   13,   14,   15,   16,  262,  250,  279,  309,
 /*    40 */   310,  266,  284,  309,  310,  309,  310,   47,  289,  274,
 /*    50 */   320,  250,  293,  279,  320,  339,  320,  298,   58,  311,
 /*    60 */    12,   13,   14,  262,   64,  243,  279,  351,   20,  310,
 /*    70 */    22,  355,  313,  314,  315,  316,  317,  318,   20,  320,
 /*    80 */   279,   81,  323,  335,  339,   82,  327,  328,   12,   13,
 /*    90 */    14,   15,   16,  271,   57,   47,  351,  273,  339,  289,
 /*   100 */   355,  279,  292,  103,  317,  295,   58,  311,   12,   13,
 /*   110 */   351,  289,   64,  113,  355,  293,   20,  293,   22,  332,
 /*   120 */   333,  334,   20,  336,   12,   13,   14,   15,   16,   81,
 /*   130 */   255,  335,  310,  309,  310,  313,  314,  315,  316,  317,
 /*   140 */   318,    0,  320,   47,  320,  323,   20,  339,   22,  327,
 /*   150 */   328,  103,  277,  253,   58,  246,  156,  248,  249,  351,
 /*   160 */    64,  113,   21,  355,   20,   24,   25,   26,   27,   28,
 /*   170 */    29,   30,   31,   32,  274,   49,    4,   81,  242,   55,
 /*   180 */   244,  181,  182,   81,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  198,  103,
 /*   200 */   246,   22,  248,  249,  156,   81,   20,   83,  256,  113,
 /*   210 */    21,  211,  260,   24,   25,   26,   27,   28,   29,   30,
 /*   220 */    31,   32,  165,  166,  148,   81,   47,  170,   93,  181,
 /*   230 */   182,    0,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,  198,  112,   20,  114,
 /*   250 */   115,  116,  156,   81,  255,   24,   25,   26,   27,   28,
 /*   260 */    29,   30,   31,   32,    4,   12,   13,  268,   12,   13,
 /*   270 */    14,   15,   16,   20,  311,   22,  277,  181,  182,   20,
 /*   280 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   290 */   194,  195,  196,  197,  198,   81,   60,   61,  335,  271,
 /*   300 */    47,   65,   42,   43,   68,   69,  278,  231,   72,   73,
 /*   310 */    74,  283,   57,   12,   13,   14,  271,   64,    2,  263,
 /*   320 */   243,   20,  247,   22,  279,  250,   35,  271,   12,   13,
 /*   330 */    14,   15,   16,   20,   81,  211,  280,   94,   95,   96,
 /*   340 */    97,   98,   99,  100,  101,  102,  103,  104,   47,  106,
 /*   350 */   107,  108,  109,  110,  111,  211,  103,    4,  143,   19,
 /*   360 */   315,   12,   13,  257,  258,   64,  113,  270,   14,   20,
 /*   370 */   293,   22,   19,   33,   20,   84,  181,   86,   87,  282,
 /*   380 */    89,  281,   81,  211,   93,   45,   33,  247,  288,  289,
 /*   390 */   250,   51,   52,   53,   54,   55,   47,    0,   45,   55,
 /*   400 */   250,  145,  240,   50,  103,    0,  115,   64,   55,  156,
 /*   410 */   339,  243,  262,   64,  113,  220,  221,  222,  223,  224,
 /*   420 */    80,  279,  351,   83,   80,  211,  355,   83,  286,  279,
 /*   430 */    81,  216,  217,   80,  181,  182,   83,  184,  185,  186,
 /*   440 */   187,  188,  189,  190,  191,  192,  193,  194,  195,  196,
 /*   450 */   197,  198,  103,   81,   57,  263,  116,  156,    3,  263,
 /*   460 */   298,  293,  113,  271,  211,   60,   61,  271,  271,   92,
 /*   470 */    65,   75,  280,   68,   69,  278,  280,   72,   73,   74,
 /*   480 */   283,  141,  181,  182,  144,  184,  185,  186,  187,  188,
 /*   490 */   189,  190,  191,  192,  193,  194,  195,  196,  197,  198,
 /*   500 */   243,  339,  162,   20,  164,  156,  288,  289,   12,   13,
 /*   510 */    14,   15,   16,  351,   14,  119,  120,  355,   12,   13,
 /*   520 */    20,  243,  167,  168,  169,    0,   20,  155,   22,  157,
 /*   530 */   181,  182,  250,  184,  185,  186,  187,  188,  189,  190,
 /*   540 */   191,  192,  193,  194,  195,  196,  197,  198,  264,  271,
 /*   550 */   293,  267,  250,   47,  243,    0,  250,  279,  243,   14,
 /*   560 */    18,  279,   20,   47,  262,   20,  272,  289,  262,   27,
 /*   570 */    64,  293,   30,  302,  250,  269,  298,    0,   82,  298,
 /*   580 */    64,  279,   57,  211,  243,  279,  262,   81,  310,  151,
 /*   590 */    48,  313,  314,  315,  316,  317,  318,  272,  320,  317,
 /*   600 */    45,  323,  272,  279,  293,  327,  328,  272,  293,  103,
 /*   610 */   172,  173,  250,  331,  332,  333,  334,  339,  336,  113,
 /*   620 */   339,   42,   43,  271,  262,  244,    1,    2,  145,  351,
 /*   630 */   278,  269,  351,  355,  293,  283,  355,   60,   61,   62,
 /*   640 */    63,  279,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   650 */    73,   74,   75,   76,   77,   78,   14,   15,   16,  243,
 /*   660 */   118,    4,  156,  121,  122,  123,  124,  125,  126,  127,
 /*   670 */   128,  129,  130,  131,  132,  133,  134,  135,  136,  137,
 /*   680 */   138,  226,  243,  289,  243,  185,   20,  181,  182,  295,
 /*   690 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   700 */   194,  195,  196,  197,  198,  139,   18,   82,  243,  293,
 /*   710 */   271,   23,  259,  250,  261,   37,  272,  250,  279,    0,
 /*   720 */    20,  250,  298,   35,   36,  262,  160,   39,  289,  262,
 /*   730 */   185,  250,  293,  262,  293,  250,   12,   13,   14,   15,
 /*   740 */    16,  243,  279,  262,   56,  243,  279,  262,  243,  310,
 /*   750 */   279,   41,  313,  314,  315,  316,  317,  318,  293,  320,
 /*   760 */   279,  243,  323,  339,  279,  199,  327,  328,  329,   81,
 /*   770 */    12,   13,   14,   15,   16,  351,  271,    0,  250,  355,
 /*   780 */   341,  250,   58,  271,  279,  346,  347,   93,  250,  243,
 /*   790 */   262,  293,  280,  262,  289,  293,   85,  243,  293,   88,
 /*   800 */   262,  296,  243,  243,  243,  117,   82,  279,  243,  115,
 /*   810 */   279,  293,   93,   41,   90,  310,   58,  279,  313,  314,
 /*   820 */   315,  316,  317,  318,   58,  320,  209,  210,  250,  272,
 /*   830 */    21,  112,  271,  114,  115,  116,  148,  149,  150,  293,
 /*   840 */   279,  153,  260,   34,  271,  145,  158,  293,   90,   41,
 /*   850 */   289,  185,  293,  293,  293,  243,  283,  279,  293,  171,
 /*   860 */    22,  358,  174,  139,  176,  177,  178,  179,  180,  212,
 /*   870 */    93,  310,    0,   47,  313,  314,  315,  316,  317,  318,
 /*   880 */   319,  320,  321,  322,  160,   47,  243,    0,  210,  112,
 /*   890 */    82,  114,  115,  116,   22,  317,   41,  139,   85,  211,
 /*   900 */    85,   88,   64,   88,   85,  293,  243,   88,   41,   22,
 /*   910 */   332,  333,  334,    0,  336,    1,    2,   44,  160,  196,
 /*   920 */   197,  349,   47,  199,  200,  201,  202,  203,  204,  205,
 /*   930 */   206,  207,  208,   41,  271,   22,  293,   82,  228,  113,
 /*   940 */    81,  103,  279,   41,   41,  306,   41,  181,   41,   82,
 /*   950 */    91,  113,  289,  343,   81,  271,  293,  199,  200,  201,
 /*   960 */   202,  203,  204,  205,  206,  207,  208,   41,  243,  249,
 /*   970 */    41,  282,   41,  310,   82,   41,  313,  314,  315,  316,
 /*   980 */   317,  318,   47,  320,   82,   82,  323,   82,  113,   82,
 /*   990 */   327,  328,  329,   41,  156,  251,  271,  312,  337,   64,
 /*  1000 */   243,  352,  230,   41,  279,  352,   41,  352,   82,  340,
 /*  1010 */   347,   82,  213,   82,  289,   41,   82,   41,  293,  181,
 /*  1020 */   182,  308,   20,  250,   45,  307,  257,   47,  271,  300,
 /*  1030 */   154,  250,  250,  287,   82,  310,  279,   40,  313,  314,
 /*  1040 */   315,  316,  317,  318,   82,  320,  289,   82,  323,  139,
 /*  1050 */   293,  250,  327,  328,  329,  285,   82,   20,   82,  285,
 /*  1060 */   243,  245,   20,  338,  304,  245,  255,  310,  289,  255,
 /*  1070 */   313,  314,  315,  316,  317,  318,   20,  320,   20,  299,
 /*  1080 */   323,  297,  255,  297,  327,  328,  329,  255,  271,  279,
 /*  1090 */    20,  255,  243,  290,  255,  338,  279,  250,  255,  245,
 /*  1100 */   271,  271,  271,  250,  271,  271,  289,  245,  271,   64,
 /*  1110 */   293,  271,  271,  271,  293,  271,  271,  293,  253,  163,
 /*  1120 */   271,  253,  304,  253,  289,  303,   20,  310,  279,  250,
 /*  1130 */   313,  314,  315,  316,  317,  318,  279,  320,  289,  253,
 /*  1140 */   323,  219,  293,  243,  327,  328,  329,  298,  297,  293,
 /*  1150 */   290,  218,  348,  348,  293,  338,  147,  294,  312,  310,
 /*  1160 */   294,  225,  313,  314,  315,  316,  317,  318,  345,  320,
 /*  1170 */   293,  271,  344,  243,  214,  279,  210,  308,   20,  279,
 /*  1180 */    40,  232,  311,  229,  227,   81,  291,  294,  339,  289,
 /*  1190 */   342,  293,  293,  293,  330,  294,  142,  293,  298,  279,
 /*  1200 */   351,  271,  290,  353,  355,  267,  243,  279,  326,  279,
 /*  1210 */   310,  359,  354,  313,  314,  315,  316,  317,  318,  289,
 /*  1220 */   320,  253,  253,  293,   81,  275,  253,  250,  354,  245,
 /*  1230 */   305,  353,  261,  353,  271,  354,  243,  265,  301,  339,
 /*  1240 */   310,  254,  279,  313,  314,  315,  316,  317,  318,  241,
 /*  1250 */   320,  351,  289,  323,  265,  355,  293,  327,  328,  265,
 /*  1260 */     0,    0,   40,    0,  271,   72,    0,   47,  175,  175,
 /*  1270 */    47,   47,  279,  310,   47,    0,  313,  314,  315,  316,
 /*  1280 */   317,  318,  289,  320,   47,   47,  293,  243,  175,    0,
 /*  1290 */   175,    0,   47,    0,   47,    0,  243,   47,    0,   81,
 /*  1300 */   113,  160,  156,  310,  159,    0,  313,  314,  315,  316,
 /*  1310 */   317,  318,    0,  320,  152,  271,  323,  151,    0,  356,
 /*  1320 */   357,  328,    0,  279,  271,   44,    0,    0,    0,    0,
 /*  1330 */     0,    0,  279,  289,    0,    0,    0,  293,    0,    0,
 /*  1340 */     0,    0,  289,    0,    0,    0,  293,    0,    0,   40,
 /*  1350 */   243,    0,    0,    0,  310,    0,    0,  313,  314,  315,
 /*  1360 */   316,  317,  318,  310,  320,    0,  313,  314,  315,  316,
 /*  1370 */   317,  318,   22,  320,    0,    0,    0,    0,  271,    0,
 /*  1380 */     0,   14,   40,   37,   14,    0,  279,    0,    0,    0,
 /*  1390 */   243,  147,    0,   44,  350,   41,  289,   38,   37,   37,
 /*  1400 */   293,   44,    0,  296,   90,   37,  243,    0,    0,    0,
 /*  1410 */   357,    0,    0,   47,   45,   37,   45,  310,  271,   59,
 /*  1420 */   313,  314,  315,  316,  317,  318,  279,  320,   47,   47,
 /*  1430 */    37,   45,   37,    0,  271,   37,  289,   47,    0,   45,
 /*  1440 */   293,    0,  279,    0,    0,   22,   88,   47,    0,    0,
 /*  1450 */    47,   41,  289,   47,  243,   41,  293,  310,   22,  296,
 /*  1460 */   313,  314,  315,  316,  317,  318,    0,  320,   47,  322,
 /*  1470 */    48,   47,   47,  310,   47,   47,  313,  314,  315,  316,
 /*  1480 */   317,  318,  271,  320,   22,    0,  243,   22,    0,   47,
 /*  1490 */   279,   33,    0,   22,   22,   20,    0,   47,    0,   22,
 /*  1500 */   289,    0,    0,   45,  293,    0,    0,  296,  145,   51,
 /*  1510 */    52,   53,   54,   55,  271,   81,  243,   37,  145,   41,
 /*  1520 */    41,  310,  279,  140,  313,  314,  315,  316,  317,  318,
 /*  1530 */   215,  320,  289,  161,   82,   41,  293,   82,   80,  142,
 /*  1540 */    81,   83,   81,   44,  271,   81,  145,   44,   41,   82,
 /*  1550 */    81,   41,  279,  310,   41,   82,  313,  314,  315,  316,
 /*  1560 */   317,  318,  289,  320,   44,   82,  293,  243,   44,   82,
 /*  1570 */    41,   82,   47,   47,   47,   47,    2,   47,   47,   41,
 /*  1580 */   181,   44,   82,  310,   44,   81,  313,  314,  315,  316,
 /*  1590 */   317,  318,   81,  320,   82,  271,   81,   22,  140,  215,
 /*  1600 */   142,  183,  144,  279,  146,  209,  215,  243,    0,   37,
 /*  1610 */    91,  143,   44,  289,   82,   81,   81,  293,   82,   22,
 /*  1620 */    81,  140,  164,   81,   81,   44,   81,   47,   82,   81,
 /*  1630 */    81,  113,   82,   92,  310,  271,   47,  313,  314,  315,
 /*  1640 */   316,  317,  318,  279,  320,   81,   47,  243,   82,   82,
 /*  1650 */    81,   47,   81,  289,   47,   82,   47,  293,   81,  105,
 /*  1660 */    82,  105,  243,   81,  105,  105,   81,   22,   81,   93,
 /*  1670 */    47,   81,   22,   58,  310,  271,   59,  313,  314,  315,
 /*  1680 */   316,  317,  318,  279,  320,   47,   64,   41,   47,   79,
 /*  1690 */   271,   22,   64,  289,   47,   47,   47,  293,  279,   47,
 /*  1700 */    47,   47,   47,   47,   47,   47,   47,   47,  289,   47,
 /*  1710 */     0,   47,  293,  243,  310,   45,   37,  313,  314,  315,
 /*  1720 */   316,  317,  318,    0,  320,  243,   45,   47,   37,  310,
 /*  1730 */     0,   47,  313,  314,  315,  316,  317,  318,   45,  320,
 /*  1740 */    37,  271,   47,   45,   37,    0,   47,   46,    0,  279,
 /*  1750 */     0,    0,   21,  271,   22,   22,   22,   21,   20,  289,
 /*  1760 */   360,  279,  360,  293,  360,  243,  360,  360,  360,  360,
 /*  1770 */   360,  289,  360,  360,  360,  293,  243,  360,  360,  360,
 /*  1780 */   310,  360,  360,  313,  314,  315,  316,  317,  318,  360,
 /*  1790 */   320,  360,  310,  271,  360,  313,  314,  315,  316,  317,
 /*  1800 */   318,  279,  320,  360,  271,  360,  360,  360,  360,  360,
 /*  1810 */   360,  289,  279,  360,  360,  293,  360,  360,  360,  360,
 /*  1820 */   360,  360,  289,  360,  360,  360,  293,  243,  360,  360,
 /*  1830 */   360,  360,  310,  360,  360,  313,  314,  315,  316,  317,
 /*  1840 */   318,  360,  320,  310,  360,  360,  313,  314,  315,  316,
 /*  1850 */   317,  318,  360,  320,  360,  271,  360,  243,  360,  360,
 /*  1860 */   360,  360,  360,  279,  360,  360,  360,  360,  360,  360,
 /*  1870 */   360,  360,  360,  289,  360,  360,  360,  293,  360,  360,
 /*  1880 */   360,  360,  360,  360,  360,  271,  360,  243,  360,  360,
 /*  1890 */   360,  360,  360,  279,  310,  360,  360,  313,  314,  315,
 /*  1900 */   316,  317,  318,  289,  320,  360,  360,  293,  360,  360,
 /*  1910 */   360,  360,  360,  360,  360,  271,  360,  360,  360,  243,
 /*  1920 */   360,  360,  360,  279,  310,  360,  360,  313,  314,  315,
 /*  1930 */   316,  317,  318,  289,  320,  360,  360,  293,  360,  360,
 /*  1940 */   360,  360,  360,   12,   13,  360,  360,  271,  360,  360,
 /*  1950 */   360,  360,  243,   22,  310,  279,  360,  313,  314,  315,
 /*  1960 */   316,  317,  318,  360,  320,  289,  360,  360,  360,  293,
 /*  1970 */   360,  360,  360,  360,  360,  360,  360,  360,   47,  360,
 /*  1980 */   271,  360,  360,  360,  360,  243,  310,  360,  279,  313,
 /*  1990 */   314,  315,  316,  317,  318,   64,  320,  360,  289,  360,
 /*  2000 */   360,  360,  293,  360,  360,  360,  360,  360,  360,  360,
 /*  2010 */   360,  360,  360,  271,  360,  360,  250,  360,  360,  310,
 /*  2020 */   360,  279,  313,  314,  315,  316,  317,  318,  360,  320,
 /*  2030 */   360,  289,  360,  360,  103,  293,  360,  360,  360,  360,
 /*  2040 */   360,  360,  360,  360,  113,  279,  250,  360,  360,  360,
 /*  2050 */   360,  360,  310,  360,  360,  313,  314,  315,  316,  317,
 /*  2060 */   318,  360,  320,  360,  298,  360,  360,  360,  360,  360,
 /*  2070 */   360,  360,  360,  360,  360,  279,  360,  360,  360,  360,
 /*  2080 */   360,  360,  360,  317,  360,  360,  360,  156,  360,  360,
 /*  2090 */   360,  360,  360,  360,  298,  360,  360,  360,  332,  333,
 /*  2100 */   334,  360,  336,  360,  360,  339,  360,  360,  360,  360,
 /*  2110 */   360,  360,  181,  317,  360,  360,  360,  351,  360,  360,
 /*  2120 */   360,  355,  360,  192,  193,  194,  360,  360,  332,  333,
 /*  2130 */   334,  360,  336,  360,  360,  339,  360,  360,  360,  360,
 /*  2140 */   360,  360,  360,  360,  360,  360,  360,  351,  360,  360,
 /*  2150 */   360,  355,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2160 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2170 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2180 */   360,  360,  360,  360,
};
#define YY_SHIFT_COUNT    (618)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1931)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   688,    0,    0,   48,   96,   96,   96,   96,  253,  253,
 /*    10 */    96,   96,  301,  349,  506,  349,  349,  349,  349,  349,
 /*    20 */   349,  349,  349,  349,  349,  349,  349,  349,  349,  349,
 /*    30 */   349,  349,  349,  349,  349,  349,  349,  349,  144,  144,
 /*    40 */   102,  102,  102, 1931, 1931, 1931, 1931,  372,  124,  214,
 /*    50 */    58,   58,  260,  260,  172,  214,  214,   58,   58,   58,
 /*    60 */    58,   58,   58,   58,   37,   58,   58,  186,  228,  259,
 /*    70 */   186,   58,   58,  186,   58,  186,  186,  259,  186,   58,
 /*    80 */   255,  542,  724,  758,  758,  189,  236,  838,  838,  838,
 /*    90 */   838,  838,  838,  838,  838,  838,  838,  838,  838,  838,
 /*   100 */   838,  838,  838,  838,  838,  838,  291,  126,  354,  354,
 /*   110 */   397,  516,  483,  483,  483,  525,  516,  313,  259,  186,
 /*   120 */   186,  259,  377,  343,  243,  243,  243,  243,  243,  243,
 /*   130 */   243,  340,  141,  405,   76,  195,   57,  215,  500,  545,
 /*   140 */   579,  179,  694,  700,  617,  678,  617,  455,  455,  455,
 /*   150 */   657,  666,  799, 1002,  979,  980,  876, 1002, 1002,  997,
 /*   160 */   910,  910, 1002, 1037, 1037, 1042,   37,  259,   37, 1056,
 /*   170 */  1058,   37, 1056,   37,  313, 1070,   37,   37, 1002,   37,
 /*   180 */  1037,  186,  186,  186,  186,  186,  186,  186,  186,  186,
 /*   190 */   186,  186, 1002, 1037, 1045, 1045, 1042,  255,  956,  259,
 /*   200 */   255, 1002, 1056,  255,  313, 1070,  255, 1106,  922,  933,
 /*   210 */  1045,  922,  933, 1045, 1045,  186,  936, 1009,  960,  799,
 /*   220 */   966,  313, 1158, 1140,  954,  957,  949,  954,  957,  954,
 /*   230 */   957, 1104,  933, 1045, 1045,  933, 1045, 1054,  313, 1070,
 /*   240 */   255,  377,  255,  313, 1143,  343, 1002,  255, 1037, 2152,
 /*   250 */  2152, 2152, 2152, 2152, 2152, 2152,  577, 1458,  231,  353,
 /*   260 */     3,   19,  316,  256,  496,  719,  777,  112,  112,  112,
 /*   270 */   112,  112,  112,  112,  112,  135,  438,  344,  396,  355,
 /*   280 */   625,  566,  642,  642,  642,  642,  555,  808,  711,  813,
 /*   290 */   815,  819,  872,  887,  913,  809,  855,  867,  892,  914,
 /*   300 */   723,  710,  772,  902,  766,  903,  873,  905,  907,  926,
 /*   310 */   929,  931,  826,  875,  934,  952,  962,  965,  974,  976,
 /*   320 */   859,  935, 1260, 1261, 1222, 1263, 1193, 1266, 1220, 1093,
 /*   330 */  1223, 1224, 1227, 1094, 1275, 1237, 1238, 1113, 1289, 1115,
 /*   340 */  1291, 1245, 1293, 1247, 1295, 1250, 1298, 1218, 1141, 1145,
 /*   350 */  1187, 1146, 1305, 1312, 1162, 1166, 1318, 1322, 1281, 1326,
 /*   360 */  1327, 1328, 1329, 1330, 1331, 1334, 1335, 1336, 1338, 1339,
 /*   370 */  1340, 1341, 1343, 1344, 1345, 1347, 1348, 1309, 1351, 1352,
 /*   380 */  1353, 1355, 1356, 1365, 1350, 1374, 1375, 1376, 1377, 1379,
 /*   390 */  1380, 1342, 1346, 1354, 1367, 1349, 1370, 1357, 1385, 1359,
 /*   400 */  1361, 1387, 1388, 1389, 1362, 1244, 1392, 1402, 1368, 1407,
 /*   410 */  1360, 1408, 1409, 1366, 1369, 1378, 1411, 1381, 1371, 1393,
 /*   420 */  1412, 1382, 1386, 1395, 1433, 1390, 1394, 1398, 1438, 1441,
 /*   430 */  1443, 1444, 1314, 1358, 1400, 1423, 1448, 1403, 1406, 1421,
 /*   440 */  1424, 1410, 1414, 1425, 1427, 1428, 1449, 1436, 1466, 1462,
 /*   450 */  1422, 1485, 1465, 1442, 1488, 1471, 1492, 1472, 1475, 1496,
 /*   460 */  1363, 1450, 1498, 1372, 1477, 1373, 1397, 1501, 1502, 1505,
 /*   470 */  1401, 1506, 1434, 1480, 1383, 1478, 1479, 1315, 1452, 1494,
 /*   480 */  1455, 1459, 1461, 1464, 1467, 1507, 1499, 1503, 1469, 1510,
 /*   490 */  1384, 1473, 1483, 1520, 1396, 1513, 1524, 1487, 1529, 1391,
 /*   500 */  1489, 1525, 1526, 1527, 1528, 1530, 1531, 1489, 1574, 1399,
 /*   510 */  1538, 1500, 1504, 1512, 1537, 1511, 1515, 1540, 1575, 1418,
 /*   520 */  1534, 1532, 1536, 1535, 1539, 1468, 1542, 1608, 1572, 1481,
 /*   530 */  1543, 1519, 1568, 1581, 1545, 1546, 1548, 1597, 1549, 1541,
 /*   540 */  1550, 1580, 1589, 1564, 1566, 1599, 1569, 1567, 1604, 1571,
 /*   550 */  1573, 1607, 1577, 1578, 1609, 1582, 1554, 1556, 1559, 1560,
 /*   560 */  1645, 1576, 1585, 1587, 1623, 1590, 1518, 1650, 1617, 1615,
 /*   570 */  1638, 1622, 1610, 1646, 1641, 1647, 1648, 1649, 1652, 1669,
 /*   580 */  1653, 1654, 1628, 1410, 1655, 1414, 1656, 1657, 1658, 1659,
 /*   590 */  1660, 1662, 1710, 1664, 1670, 1679, 1723, 1680, 1681, 1691,
 /*   600 */  1730, 1684, 1693, 1703, 1750, 1695, 1698, 1707, 1745, 1699,
 /*   610 */  1701, 1748, 1751, 1732, 1731, 1733, 1734, 1736, 1738,
};
#define YY_REDUCE_COUNT (255)
#define YY_REDUCE_MIN   (-324)
#define YY_REDUCE_MAX   (1796)
static const short yy_reduce_ofst[] = {
 /*     0 */   162, -241,  278,  439,  663,  725,  757,  817,  849,  900,
 /*    10 */  -178,  930,  561,  963,  993,  505, 1044, 1053, 1107, 1147,
 /*    20 */  1163, 1211, 1243, 1273, 1324, 1364, 1404, 1419, 1470, 1482,
 /*    30 */  1522, 1533, 1584, 1614, 1644, 1676, 1709, 1742, 1766, 1796,
 /*    40 */   282, -213,  578, -270, -266, -264, -176, -284,  281,  424,
 /*    50 */   306,  362,  -91,  -46, -255, -192,   71, -226, -199,  150,
 /*    60 */   302,  324,  463,  467,   -1,  471,  485,   28,   45, -190,
 /*    70 */    56,  528,  531,  197,  481,  192,  352,  100,  196,  538,
 /*    80 */  -225, -242, -324, -324, -324,  -64,  -48,   77,  168,  257,
 /*    90 */   311,  315,  341,  416,  441,  465,  498,  502,  518,  546,
 /*   100 */   554,  559,  560,  565,  612,  643,   97, -247,   75,  140,
 /*   110 */  -125, -232, -252, -204,  -37, -100,  106,  142,  394,  512,
 /*   120 */   573,  218,  284,  453, -261,  294,  325,  330,  335,  444,
 /*   130 */   557,  271,  381,  582,  503,  572,  639,  610,  684,  684,
 /*   140 */   720,  744,  689,  685,  661,  661,  661,  649,  653,  655,
 /*   150 */   669,  684,  713,  773,  718,  769,  729,  781,  782,  746,
 /*   160 */   770,  774,  801,  816,  820,  760,  811,  779,  814,  784,
 /*   170 */   780,  827,  786,  832,  810,  803,  836,  839,  847,  843,
 /*   180 */   854,  829,  830,  831,  833,  834,  837,  840,  841,  842,
 /*   190 */   844,  845,  853,  862,  821,  824,  818,  865,  822,  835,
 /*   200 */   868,  879,  851,  870,  857,  860,  886,  846,  804,  863,
 /*   210 */   856,  805,  866,  861,  877,  684,  823,  828,  848,  869,
 /*   220 */   661,  896,  871,  864,  858,  850,  852,  874,  878,  881,
 /*   230 */   880,  882,  893,  898,  899,  901,  904,  895,  920,  912,
 /*   240 */   968,  938,  969,  928,  950,  971,  977,  973,  984,  937,
 /*   250 */   925,  972,  989,  994,  987, 1008,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    10 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    20 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    30 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    40 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    50 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    60 */  1360, 1360, 1360, 1360, 1429, 1360, 1360, 1360, 1360, 1360,
 /*    70 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    80 */  1427, 1567, 1360, 1734, 1360, 1360, 1360, 1360, 1360, 1360,
 /*    90 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   100 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   110 */  1429, 1360, 1745, 1745, 1745, 1427, 1360, 1360, 1360, 1360,
 /*   120 */  1360, 1360, 1523, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   130 */  1360, 1603, 1360, 1360, 1811, 1360, 1609, 1769, 1360, 1360,
 /*   140 */  1360, 1360, 1476, 1761, 1737, 1751, 1738, 1796, 1796, 1796,
 /*   150 */  1754, 1360, 1765, 1360, 1360, 1360, 1595, 1360, 1360, 1572,
 /*   160 */  1569, 1569, 1360, 1360, 1360, 1360, 1429, 1360, 1429, 1360,
 /*   170 */  1360, 1429, 1360, 1429, 1360, 1360, 1429, 1429, 1360, 1429,
 /*   180 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   190 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1427, 1605, 1360,
 /*   200 */  1427, 1360, 1360, 1427, 1360, 1360, 1427, 1360, 1776, 1774,
 /*   210 */  1360, 1776, 1774, 1360, 1360, 1360, 1788, 1784, 1767, 1765,
 /*   220 */  1751, 1360, 1360, 1360, 1802, 1798, 1814, 1802, 1798, 1802,
 /*   230 */  1798, 1360, 1774, 1360, 1360, 1774, 1360, 1580, 1360, 1360,
 /*   240 */  1427, 1360, 1427, 1360, 1492, 1360, 1360, 1427, 1360, 1597,
 /*   250 */  1611, 1526, 1526, 1526, 1430, 1365, 1360, 1360, 1360, 1360,
 /*   260 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1678, 1787, 1786,
 /*   270 */  1710, 1709, 1708, 1706, 1677, 1488, 1360, 1360, 1360, 1360,
 /*   280 */  1360, 1360, 1671, 1672, 1670, 1669, 1360, 1360, 1360, 1360,
 /*   290 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1735,
 /*   300 */  1360, 1799, 1803, 1360, 1360, 1360, 1654, 1360, 1360, 1360,
 /*   310 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   320 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   330 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   340 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   350 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   360 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   370 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   380 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   390 */  1360, 1360, 1360, 1394, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   400 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   410 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   420 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   430 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   440 */  1360, 1457, 1456, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   450 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   460 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   470 */  1360, 1360, 1360, 1360, 1360, 1758, 1768, 1360, 1360, 1360,
 /*   480 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1654, 1360, 1785,
 /*   490 */  1360, 1744, 1740, 1360, 1360, 1736, 1360, 1360, 1797, 1360,
 /*   500 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1730, 1360,
 /*   510 */  1703, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1665,
 /*   520 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   530 */  1360, 1360, 1653, 1360, 1694, 1360, 1360, 1360, 1360, 1360,
 /*   540 */  1360, 1360, 1360, 1520, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   550 */  1360, 1360, 1360, 1360, 1360, 1360, 1505, 1503, 1502, 1501,
 /*   560 */  1360, 1498, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   570 */  1360, 1360, 1360, 1449, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   580 */  1360, 1360, 1360, 1440, 1360, 1439, 1360, 1360, 1360, 1360,
 /*   590 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   600 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
 /*   610 */  1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  233,  /*  NK_BITNOT => ID */
  233,  /*     INSERT => ID */
  233,  /*     VALUES => ID */
  233,  /*     IMPORT => ID */
  233,  /*    NK_SEMI => ID */
  233,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "FILE_FACTOR",
  /*  113 */ "NK_FLOAT",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "SHOW",
  /*  118 */ "DATABASES",
  /*  119 */ "TABLES",
  /*  120 */ "STABLES",
  /*  121 */ "MNODES",
  /*  122 */ "MODULES",
  /*  123 */ "QNODES",
  /*  124 */ "FUNCTIONS",
  /*  125 */ "INDEXES",
  /*  126 */ "ACCOUNTS",
  /*  127 */ "APPS",
  /*  128 */ "CONNECTIONS",
  /*  129 */ "LICENCE",
  /*  130 */ "GRANTS",
  /*  131 */ "QUERIES",
  /*  132 */ "SCORES",
  /*  133 */ "TOPICS",
  /*  134 */ "VARIABLES",
  /*  135 */ "BNODES",
  /*  136 */ "SNODES",
  /*  137 */ "CLUSTER",
  /*  138 */ "TRANSACTIONS",
  /*  139 */ "LIKE",
  /*  140 */ "INDEX",
  /*  141 */ "FULLTEXT",
  /*  142 */ "FUNCTION",
  /*  143 */ "INTERVAL",
  /*  144 */ "TOPIC",
  /*  145 */ "AS",
  /*  146 */ "CONSUMER",
  /*  147 */ "GROUP",
  /*  148 */ "DESC",
  /*  149 */ "DESCRIBE",
  /*  150 */ "RESET",
  /*  151 */ "QUERY",
  /*  152 */ "CACHE",
  /*  153 */ "EXPLAIN",
  /*  154 */ "ANALYZE",
  /*  155 */ "VERBOSE",
  /*  156 */ "NK_BOOL",
  /*  157 */ "RATIO",
  /*  158 */ "COMPACT",
  /*  159 */ "VNODES",
  /*  160 */ "IN",
  /*  161 */ "OUTPUTTYPE",
  /*  162 */ "AGGREGATE",
  /*  163 */ "BUFSIZE",
  /*  164 */ "STREAM",
  /*  165 */ "INTO",
  /*  166 */ "TRIGGER",
  /*  167 */ "AT_ONCE",
  /*  168 */ "WINDOW_CLOSE",
  /*  169 */ "MAX_DELAY",
  /*  170 */ "WATERMARK",
  /*  171 */ "KILL",
  /*  172 */ "CONNECTION",
  /*  173 */ "TRANSACTION",
  /*  174 */ "BALANCE",
  /*  175 */ "VGROUP",
  /*  176 */ "MERGE",
  /*  177 */ "REDISTRIBUTE",
  /*  178 */ "SPLIT",
  /*  179 */ "SYNCDB",
  /*  180 */ "DELETE",
  /*  181 */ "NULL",
  /*  182 */ "NK_QUESTION",
  /*  183 */ "NK_ARROW",
  /*  184 */ "ROWTS",
  /*  185 */ "TBNAME",
  /*  186 */ "QSTARTTS",
  /*  187 */ "QENDTS",
  /*  188 */ "WSTARTTS",
  /*  189 */ "WENDTS",
  /*  190 */ "WDURATION",
  /*  191 */ "CAST",
  /*  192 */ "NOW",
  /*  193 */ "TODAY",
  /*  194 */ "TIMEZONE",
  /*  195 */ "COUNT",
  /*  196 */ "FIRST",
  /*  197 */ "LAST",
  /*  198 */ "LAST_ROW",
  /*  199 */ "BETWEEN",
  /*  200 */ "IS",
  /*  201 */ "NK_LT",
  /*  202 */ "NK_GT",
  /*  203 */ "NK_LE",
  /*  204 */ "NK_GE",
  /*  205 */ "NK_NE",
  /*  206 */ "MATCH",
  /*  207 */ "NMATCH",
  /*  208 */ "CONTAINS",
  /*  209 */ "JOIN",
  /*  210 */ "INNER",
  /*  211 */ "SELECT",
  /*  212 */ "DISTINCT",
  /*  213 */ "WHERE",
  /*  214 */ "PARTITION",
  /*  215 */ "BY",
  /*  216 */ "SESSION",
  /*  217 */ "STATE_WINDOW",
  /*  218 */ "SLIDING",
  /*  219 */ "FILL",
  /*  220 */ "VALUE",
  /*  221 */ "NONE",
  /*  222 */ "PREV",
  /*  223 */ "LINEAR",
  /*  224 */ "NEXT",
  /*  225 */ "HAVING",
  /*  226 */ "ORDER",
  /*  227 */ "SLIMIT",
  /*  228 */ "SOFFSET",
  /*  229 */ "LIMIT",
  /*  230 */ "OFFSET",
  /*  231 */ "ASC",
  /*  232 */ "NULLS",
  /*  233 */ "ID",
  /*  234 */ "NK_BITNOT",
  /*  235 */ "INSERT",
  /*  236 */ "VALUES",
  /*  237 */ "IMPORT",
  /*  238 */ "NK_SEMI",
  /*  239 */ "FILE",
  /*  240 */ "cmd",
  /*  241 */ "account_options",
  /*  242 */ "alter_account_options",
  /*  243 */ "literal",
  /*  244 */ "alter_account_option",
  /*  245 */ "user_name",
  /*  246 */ "privileges",
  /*  247 */ "priv_level",
  /*  248 */ "priv_type_list",
  /*  249 */ "priv_type",
  /*  250 */ "db_name",
  /*  251 */ "dnode_endpoint",
  /*  252 */ "dnode_host_name",
  /*  253 */ "not_exists_opt",
  /*  254 */ "db_options",
  /*  255 */ "exists_opt",
  /*  256 */ "alter_db_options",
  /*  257 */ "integer_list",
  /*  258 */ "variable_list",
  /*  259 */ "retention_list",
  /*  260 */ "alter_db_option",
  /*  261 */ "retention",
  /*  262 */ "full_table_name",
  /*  263 */ "column_def_list",
  /*  264 */ "tags_def_opt",
  /*  265 */ "table_options",
  /*  266 */ "multi_create_clause",
  /*  267 */ "tags_def",
  /*  268 */ "multi_drop_clause",
  /*  269 */ "alter_table_clause",
  /*  270 */ "alter_table_options",
  /*  271 */ "column_name",
  /*  272 */ "type_name",
  /*  273 */ "signed_literal",
  /*  274 */ "create_subtable_clause",
  /*  275 */ "specific_tags_opt",
  /*  276 */ "literal_list",
  /*  277 */ "drop_table_clause",
  /*  278 */ "col_name_list",
  /*  279 */ "table_name",
  /*  280 */ "column_def",
  /*  281 */ "func_name_list",
  /*  282 */ "alter_table_option",
  /*  283 */ "col_name",
  /*  284 */ "db_name_cond_opt",
  /*  285 */ "like_pattern_opt",
  /*  286 */ "table_name_cond",
  /*  287 */ "from_db_opt",
  /*  288 */ "func_name",
  /*  289 */ "function_name",
  /*  290 */ "index_name",
  /*  291 */ "index_options",
  /*  292 */ "func_list",
  /*  293 */ "duration_literal",
  /*  294 */ "sliding_opt",
  /*  295 */ "func",
  /*  296 */ "expression_list",
  /*  297 */ "topic_name",
  /*  298 */ "query_expression",
  /*  299 */ "cgroup_name",
  /*  300 */ "analyze_opt",
  /*  301 */ "explain_options",
  /*  302 */ "agg_func_opt",
  /*  303 */ "bufsize_opt",
  /*  304 */ "stream_name",
  /*  305 */ "stream_options",
  /*  306 */ "into_opt",
  /*  307 */ "dnode_list",
  /*  308 */ "where_clause_opt",
  /*  309 */ "signed",
  /*  310 */ "literal_func",
  /*  311 */ "table_alias",
  /*  312 */ "column_alias",
  /*  313 */ "expression",
  /*  314 */ "pseudo_column",
  /*  315 */ "column_reference",
  /*  316 */ "function_expression",
  /*  317 */ "subquery",
  /*  318 */ "star_func",
  /*  319 */ "star_func_para_list",
  /*  320 */ "noarg_func",
  /*  321 */ "other_para_list",
  /*  322 */ "star_func_para",
  /*  323 */ "predicate",
  /*  324 */ "compare_op",
  /*  325 */ "in_op",
  /*  326 */ "in_predicate_value",
  /*  327 */ "boolean_value_expression",
  /*  328 */ "boolean_primary",
  /*  329 */ "common_expression",
  /*  330 */ "from_clause",
  /*  331 */ "table_reference_list",
  /*  332 */ "table_reference",
  /*  333 */ "table_primary",
  /*  334 */ "joined_table",
  /*  335 */ "alias_opt",
  /*  336 */ "parenthesized_joined_table",
  /*  337 */ "join_type",
  /*  338 */ "search_condition",
  /*  339 */ "query_specification",
  /*  340 */ "set_quantifier_opt",
  /*  341 */ "select_list",
  /*  342 */ "partition_by_clause_opt",
  /*  343 */ "twindow_clause_opt",
  /*  344 */ "group_by_clause_opt",
  /*  345 */ "having_clause_opt",
  /*  346 */ "select_sublist",
  /*  347 */ "select_item",
  /*  348 */ "fill_opt",
  /*  349 */ "fill_mode",
  /*  350 */ "group_by_list",
  /*  351 */ "query_expression_body",
  /*  352 */ "order_by_clause_opt",
  /*  353 */ "slimit_clause_opt",
  /*  354 */ "limit_clause_opt",
  /*  355 */ "query_primary",
  /*  356 */ "sort_specification_list",
  /*  357 */ "sort_specification",
  /*  358 */ "ordering_specification_opt",
  /*  359 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 166 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 167 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 168 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 169 */ "alter_table_options ::= alter_table_option",
 /* 170 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 171 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 172 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 173 */ "col_name_list ::= col_name",
 /* 174 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 175 */ "col_name ::= column_name",
 /* 176 */ "cmd ::= SHOW DNODES",
 /* 177 */ "cmd ::= SHOW USERS",
 /* 178 */ "cmd ::= SHOW DATABASES",
 /* 179 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 182 */ "cmd ::= SHOW MNODES",
 /* 183 */ "cmd ::= SHOW MODULES",
 /* 184 */ "cmd ::= SHOW QNODES",
 /* 185 */ "cmd ::= SHOW FUNCTIONS",
 /* 186 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 187 */ "cmd ::= SHOW STREAMS",
 /* 188 */ "cmd ::= SHOW ACCOUNTS",
 /* 189 */ "cmd ::= SHOW APPS",
 /* 190 */ "cmd ::= SHOW CONNECTIONS",
 /* 191 */ "cmd ::= SHOW LICENCE",
 /* 192 */ "cmd ::= SHOW GRANTS",
 /* 193 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 194 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 195 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 196 */ "cmd ::= SHOW QUERIES",
 /* 197 */ "cmd ::= SHOW SCORES",
 /* 198 */ "cmd ::= SHOW TOPICS",
 /* 199 */ "cmd ::= SHOW VARIABLES",
 /* 200 */ "cmd ::= SHOW BNODES",
 /* 201 */ "cmd ::= SHOW SNODES",
 /* 202 */ "cmd ::= SHOW CLUSTER",
 /* 203 */ "cmd ::= SHOW TRANSACTIONS",
 /* 204 */ "db_name_cond_opt ::=",
 /* 205 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 206 */ "like_pattern_opt ::=",
 /* 207 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 208 */ "table_name_cond ::= table_name",
 /* 209 */ "from_db_opt ::=",
 /* 210 */ "from_db_opt ::= FROM db_name",
 /* 211 */ "func_name_list ::= func_name",
 /* 212 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 213 */ "func_name ::= function_name",
 /* 214 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 215 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 216 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 217 */ "index_options ::=",
 /* 218 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 220 */ "func_list ::= func",
 /* 221 */ "func_list ::= func_list NK_COMMA func",
 /* 222 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 223 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 225 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 226 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 227 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 228 */ "cmd ::= DESC full_table_name",
 /* 229 */ "cmd ::= DESCRIBE full_table_name",
 /* 230 */ "cmd ::= RESET QUERY CACHE",
 /* 231 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 232 */ "analyze_opt ::=",
 /* 233 */ "analyze_opt ::= ANALYZE",
 /* 234 */ "explain_options ::=",
 /* 235 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 236 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 237 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 238 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 239 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 240 */ "agg_func_opt ::=",
 /* 241 */ "agg_func_opt ::= AGGREGATE",
 /* 242 */ "bufsize_opt ::=",
 /* 243 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 244 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 245 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 246 */ "into_opt ::=",
 /* 247 */ "into_opt ::= INTO full_table_name",
 /* 248 */ "stream_options ::=",
 /* 249 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 250 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 251 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 252 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 253 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 254 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 255 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 256 */ "cmd ::= BALANCE VGROUP",
 /* 257 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 258 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 259 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 260 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 261 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 262 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 263 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 264 */ "cmd ::= query_expression",
 /* 265 */ "literal ::= NK_INTEGER",
 /* 266 */ "literal ::= NK_FLOAT",
 /* 267 */ "literal ::= NK_STRING",
 /* 268 */ "literal ::= NK_BOOL",
 /* 269 */ "literal ::= TIMESTAMP NK_STRING",
 /* 270 */ "literal ::= duration_literal",
 /* 271 */ "literal ::= NULL",
 /* 272 */ "literal ::= NK_QUESTION",
 /* 273 */ "duration_literal ::= NK_VARIABLE",
 /* 274 */ "signed ::= NK_INTEGER",
 /* 275 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 276 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 277 */ "signed ::= NK_FLOAT",
 /* 278 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 279 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 280 */ "signed_literal ::= signed",
 /* 281 */ "signed_literal ::= NK_STRING",
 /* 282 */ "signed_literal ::= NK_BOOL",
 /* 283 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 284 */ "signed_literal ::= duration_literal",
 /* 285 */ "signed_literal ::= NULL",
 /* 286 */ "signed_literal ::= literal_func",
 /* 287 */ "literal_list ::= signed_literal",
 /* 288 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 289 */ "db_name ::= NK_ID",
 /* 290 */ "table_name ::= NK_ID",
 /* 291 */ "column_name ::= NK_ID",
 /* 292 */ "function_name ::= NK_ID",
 /* 293 */ "table_alias ::= NK_ID",
 /* 294 */ "column_alias ::= NK_ID",
 /* 295 */ "user_name ::= NK_ID",
 /* 296 */ "index_name ::= NK_ID",
 /* 297 */ "topic_name ::= NK_ID",
 /* 298 */ "stream_name ::= NK_ID",
 /* 299 */ "cgroup_name ::= NK_ID",
 /* 300 */ "expression ::= literal",
 /* 301 */ "expression ::= pseudo_column",
 /* 302 */ "expression ::= column_reference",
 /* 303 */ "expression ::= function_expression",
 /* 304 */ "expression ::= subquery",
 /* 305 */ "expression ::= NK_LP expression NK_RP",
 /* 306 */ "expression ::= NK_PLUS expression",
 /* 307 */ "expression ::= NK_MINUS expression",
 /* 308 */ "expression ::= expression NK_PLUS expression",
 /* 309 */ "expression ::= expression NK_MINUS expression",
 /* 310 */ "expression ::= expression NK_STAR expression",
 /* 311 */ "expression ::= expression NK_SLASH expression",
 /* 312 */ "expression ::= expression NK_REM expression",
 /* 313 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 314 */ "expression_list ::= expression",
 /* 315 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 316 */ "column_reference ::= column_name",
 /* 317 */ "column_reference ::= table_name NK_DOT column_name",
 /* 318 */ "pseudo_column ::= ROWTS",
 /* 319 */ "pseudo_column ::= TBNAME",
 /* 320 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 321 */ "pseudo_column ::= QSTARTTS",
 /* 322 */ "pseudo_column ::= QENDTS",
 /* 323 */ "pseudo_column ::= WSTARTTS",
 /* 324 */ "pseudo_column ::= WENDTS",
 /* 325 */ "pseudo_column ::= WDURATION",
 /* 326 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 327 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 328 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 329 */ "function_expression ::= literal_func",
 /* 330 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 331 */ "literal_func ::= NOW",
 /* 332 */ "noarg_func ::= NOW",
 /* 333 */ "noarg_func ::= TODAY",
 /* 334 */ "noarg_func ::= TIMEZONE",
 /* 335 */ "star_func ::= COUNT",
 /* 336 */ "star_func ::= FIRST",
 /* 337 */ "star_func ::= LAST",
 /* 338 */ "star_func ::= LAST_ROW",
 /* 339 */ "star_func_para_list ::= NK_STAR",
 /* 340 */ "star_func_para_list ::= other_para_list",
 /* 341 */ "other_para_list ::= star_func_para",
 /* 342 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 343 */ "star_func_para ::= expression",
 /* 344 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 345 */ "predicate ::= expression compare_op expression",
 /* 346 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 347 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 348 */ "predicate ::= expression IS NULL",
 /* 349 */ "predicate ::= expression IS NOT NULL",
 /* 350 */ "predicate ::= expression in_op in_predicate_value",
 /* 351 */ "compare_op ::= NK_LT",
 /* 352 */ "compare_op ::= NK_GT",
 /* 353 */ "compare_op ::= NK_LE",
 /* 354 */ "compare_op ::= NK_GE",
 /* 355 */ "compare_op ::= NK_NE",
 /* 356 */ "compare_op ::= NK_EQ",
 /* 357 */ "compare_op ::= LIKE",
 /* 358 */ "compare_op ::= NOT LIKE",
 /* 359 */ "compare_op ::= MATCH",
 /* 360 */ "compare_op ::= NMATCH",
 /* 361 */ "compare_op ::= CONTAINS",
 /* 362 */ "in_op ::= IN",
 /* 363 */ "in_op ::= NOT IN",
 /* 364 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 365 */ "boolean_value_expression ::= boolean_primary",
 /* 366 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 367 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 368 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 369 */ "boolean_primary ::= predicate",
 /* 370 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 371 */ "common_expression ::= expression",
 /* 372 */ "common_expression ::= boolean_value_expression",
 /* 373 */ "from_clause ::= FROM table_reference_list",
 /* 374 */ "table_reference_list ::= table_reference",
 /* 375 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 376 */ "table_reference ::= table_primary",
 /* 377 */ "table_reference ::= joined_table",
 /* 378 */ "table_primary ::= table_name alias_opt",
 /* 379 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 380 */ "table_primary ::= subquery alias_opt",
 /* 381 */ "table_primary ::= parenthesized_joined_table",
 /* 382 */ "alias_opt ::=",
 /* 383 */ "alias_opt ::= table_alias",
 /* 384 */ "alias_opt ::= AS table_alias",
 /* 385 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 386 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 387 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 388 */ "join_type ::=",
 /* 389 */ "join_type ::= INNER",
 /* 390 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 391 */ "set_quantifier_opt ::=",
 /* 392 */ "set_quantifier_opt ::= DISTINCT",
 /* 393 */ "set_quantifier_opt ::= ALL",
 /* 394 */ "select_list ::= NK_STAR",
 /* 395 */ "select_list ::= select_sublist",
 /* 396 */ "select_sublist ::= select_item",
 /* 397 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 398 */ "select_item ::= common_expression",
 /* 399 */ "select_item ::= common_expression column_alias",
 /* 400 */ "select_item ::= common_expression AS column_alias",
 /* 401 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 402 */ "where_clause_opt ::=",
 /* 403 */ "where_clause_opt ::= WHERE search_condition",
 /* 404 */ "partition_by_clause_opt ::=",
 /* 405 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 406 */ "twindow_clause_opt ::=",
 /* 407 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 408 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 409 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 410 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 411 */ "sliding_opt ::=",
 /* 412 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 413 */ "fill_opt ::=",
 /* 414 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 415 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 416 */ "fill_mode ::= NONE",
 /* 417 */ "fill_mode ::= PREV",
 /* 418 */ "fill_mode ::= NULL",
 /* 419 */ "fill_mode ::= LINEAR",
 /* 420 */ "fill_mode ::= NEXT",
 /* 421 */ "group_by_clause_opt ::=",
 /* 422 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 423 */ "group_by_list ::= expression",
 /* 424 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 425 */ "having_clause_opt ::=",
 /* 426 */ "having_clause_opt ::= HAVING search_condition",
 /* 427 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 428 */ "query_expression_body ::= query_primary",
 /* 429 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 430 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 431 */ "query_primary ::= query_specification",
 /* 432 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 433 */ "order_by_clause_opt ::=",
 /* 434 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 435 */ "slimit_clause_opt ::=",
 /* 436 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 437 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 438 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 439 */ "limit_clause_opt ::=",
 /* 440 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 441 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 442 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 443 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 444 */ "search_condition ::= common_expression",
 /* 445 */ "sort_specification_list ::= sort_specification",
 /* 446 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 447 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 448 */ "ordering_specification_opt ::=",
 /* 449 */ "ordering_specification_opt ::= ASC",
 /* 450 */ "ordering_specification_opt ::= DESC",
 /* 451 */ "null_ordering_opt ::=",
 /* 452 */ "null_ordering_opt ::= NULLS FIRST",
 /* 453 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 240: /* cmd */
    case 243: /* literal */
    case 254: /* db_options */
    case 256: /* alter_db_options */
    case 261: /* retention */
    case 262: /* full_table_name */
    case 265: /* table_options */
    case 269: /* alter_table_clause */
    case 270: /* alter_table_options */
    case 273: /* signed_literal */
    case 274: /* create_subtable_clause */
    case 277: /* drop_table_clause */
    case 280: /* column_def */
    case 283: /* col_name */
    case 284: /* db_name_cond_opt */
    case 285: /* like_pattern_opt */
    case 286: /* table_name_cond */
    case 287: /* from_db_opt */
    case 288: /* func_name */
    case 291: /* index_options */
    case 293: /* duration_literal */
    case 294: /* sliding_opt */
    case 295: /* func */
    case 298: /* query_expression */
    case 301: /* explain_options */
    case 305: /* stream_options */
    case 306: /* into_opt */
    case 308: /* where_clause_opt */
    case 309: /* signed */
    case 310: /* literal_func */
    case 313: /* expression */
    case 314: /* pseudo_column */
    case 315: /* column_reference */
    case 316: /* function_expression */
    case 317: /* subquery */
    case 322: /* star_func_para */
    case 323: /* predicate */
    case 326: /* in_predicate_value */
    case 327: /* boolean_value_expression */
    case 328: /* boolean_primary */
    case 329: /* common_expression */
    case 330: /* from_clause */
    case 331: /* table_reference_list */
    case 332: /* table_reference */
    case 333: /* table_primary */
    case 334: /* joined_table */
    case 336: /* parenthesized_joined_table */
    case 338: /* search_condition */
    case 339: /* query_specification */
    case 343: /* twindow_clause_opt */
    case 345: /* having_clause_opt */
    case 347: /* select_item */
    case 348: /* fill_opt */
    case 351: /* query_expression_body */
    case 353: /* slimit_clause_opt */
    case 354: /* limit_clause_opt */
    case 355: /* query_primary */
    case 357: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy632)); 
}
      break;
    case 241: /* account_options */
    case 242: /* alter_account_options */
    case 244: /* alter_account_option */
    case 303: /* bufsize_opt */
{
 
}
      break;
    case 245: /* user_name */
    case 247: /* priv_level */
    case 250: /* db_name */
    case 251: /* dnode_endpoint */
    case 252: /* dnode_host_name */
    case 271: /* column_name */
    case 279: /* table_name */
    case 289: /* function_name */
    case 290: /* index_name */
    case 297: /* topic_name */
    case 299: /* cgroup_name */
    case 304: /* stream_name */
    case 311: /* table_alias */
    case 312: /* column_alias */
    case 318: /* star_func */
    case 320: /* noarg_func */
    case 335: /* alias_opt */
{
 
}
      break;
    case 246: /* privileges */
    case 248: /* priv_type_list */
    case 249: /* priv_type */
{
 
}
      break;
    case 253: /* not_exists_opt */
    case 255: /* exists_opt */
    case 300: /* analyze_opt */
    case 302: /* agg_func_opt */
    case 340: /* set_quantifier_opt */
{
 
}
      break;
    case 257: /* integer_list */
    case 258: /* variable_list */
    case 259: /* retention_list */
    case 263: /* column_def_list */
    case 264: /* tags_def_opt */
    case 266: /* multi_create_clause */
    case 267: /* tags_def */
    case 268: /* multi_drop_clause */
    case 275: /* specific_tags_opt */
    case 276: /* literal_list */
    case 278: /* col_name_list */
    case 281: /* func_name_list */
    case 292: /* func_list */
    case 296: /* expression_list */
    case 307: /* dnode_list */
    case 319: /* star_func_para_list */
    case 321: /* other_para_list */
    case 341: /* select_list */
    case 342: /* partition_by_clause_opt */
    case 344: /* group_by_clause_opt */
    case 346: /* select_sublist */
    case 350: /* group_by_list */
    case 352: /* order_by_clause_opt */
    case 356: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy424)); 
}
      break;
    case 260: /* alter_db_option */
    case 282: /* alter_table_option */
{
 
}
      break;
    case 272: /* type_name */
{
 
}
      break;
    case 324: /* compare_op */
    case 325: /* in_op */
{
 
}
      break;
    case 337: /* join_type */
{
 
}
      break;
    case 349: /* fill_mode */
{
 
}
      break;
    case 358: /* ordering_specification_opt */
{
 
}
      break;
    case 359: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  240,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  240,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  241,    0 }, /* (2) account_options ::= */
  {  241,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  241,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  241,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  241,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  241,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  241,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  241,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  241,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  241,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  242,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  242,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  244,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  244,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  244,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  244,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  244,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  244,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  244,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  244,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  244,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  244,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  240,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  240,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  240,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  240,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  240,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  240,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  246,   -1 }, /* (30) privileges ::= ALL */
  {  246,   -1 }, /* (31) privileges ::= priv_type_list */
  {  248,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  248,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  249,   -1 }, /* (34) priv_type ::= READ */
  {  249,   -1 }, /* (35) priv_type ::= WRITE */
  {  247,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  247,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  240,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  240,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  240,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  240,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  240,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  240,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  240,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  240,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  251,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  252,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  252,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  240,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  240,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  240,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  240,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  240,   -2 }, /* (61) cmd ::= USE db_name */
  {  240,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  253,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  253,    0 }, /* (64) not_exists_opt ::= */
  {  255,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  255,    0 }, /* (66) exists_opt ::= */
  {  254,    0 }, /* (67) db_options ::= */
  {  254,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  254,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  254,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  254,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  254,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  254,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  254,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  254,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  254,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  254,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  254,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  254,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  254,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  254,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  254,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  254,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  254,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  254,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  254,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  254,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  256,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  256,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  260,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  260,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  260,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  260,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  260,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  260,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  260,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  260,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  260,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  257,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  257,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  258,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  258,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  259,   -1 }, /* (103) retention_list ::= retention */
  {  259,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  261,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  240,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  240,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  240,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  240,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  240,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  240,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  240,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  269,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  269,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  269,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  269,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  269,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  269,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  269,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  269,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  269,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  269,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  266,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  266,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  274,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  268,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  268,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  277,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  275,    0 }, /* (129) specific_tags_opt ::= */
  {  275,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  262,   -1 }, /* (131) full_table_name ::= table_name */
  {  262,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  263,   -1 }, /* (133) column_def_list ::= column_def */
  {  263,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  280,   -2 }, /* (135) column_def ::= column_name type_name */
  {  280,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  272,   -1 }, /* (137) type_name ::= BOOL */
  {  272,   -1 }, /* (138) type_name ::= TINYINT */
  {  272,   -1 }, /* (139) type_name ::= SMALLINT */
  {  272,   -1 }, /* (140) type_name ::= INT */
  {  272,   -1 }, /* (141) type_name ::= INTEGER */
  {  272,   -1 }, /* (142) type_name ::= BIGINT */
  {  272,   -1 }, /* (143) type_name ::= FLOAT */
  {  272,   -1 }, /* (144) type_name ::= DOUBLE */
  {  272,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  272,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  272,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  272,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  272,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  272,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  272,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  272,   -1 }, /* (152) type_name ::= JSON */
  {  272,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  272,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  272,   -1 }, /* (155) type_name ::= BLOB */
  {  272,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  272,   -1 }, /* (157) type_name ::= DECIMAL */
  {  272,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  272,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  264,    0 }, /* (160) tags_def_opt ::= */
  {  264,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  267,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  265,    0 }, /* (163) table_options ::= */
  {  265,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  265,   -3 }, /* (165) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  265,   -5 }, /* (166) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  265,   -3 }, /* (167) table_options ::= table_options TTL NK_INTEGER */
  {  265,   -5 }, /* (168) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  270,   -1 }, /* (169) alter_table_options ::= alter_table_option */
  {  270,   -2 }, /* (170) alter_table_options ::= alter_table_options alter_table_option */
  {  282,   -2 }, /* (171) alter_table_option ::= COMMENT NK_STRING */
  {  282,   -2 }, /* (172) alter_table_option ::= TTL NK_INTEGER */
  {  278,   -1 }, /* (173) col_name_list ::= col_name */
  {  278,   -3 }, /* (174) col_name_list ::= col_name_list NK_COMMA col_name */
  {  283,   -1 }, /* (175) col_name ::= column_name */
  {  240,   -2 }, /* (176) cmd ::= SHOW DNODES */
  {  240,   -2 }, /* (177) cmd ::= SHOW USERS */
  {  240,   -2 }, /* (178) cmd ::= SHOW DATABASES */
  {  240,   -4 }, /* (179) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  240,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  240,   -3 }, /* (181) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  240,   -2 }, /* (182) cmd ::= SHOW MNODES */
  {  240,   -2 }, /* (183) cmd ::= SHOW MODULES */
  {  240,   -2 }, /* (184) cmd ::= SHOW QNODES */
  {  240,   -2 }, /* (185) cmd ::= SHOW FUNCTIONS */
  {  240,   -5 }, /* (186) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  240,   -2 }, /* (187) cmd ::= SHOW STREAMS */
  {  240,   -2 }, /* (188) cmd ::= SHOW ACCOUNTS */
  {  240,   -2 }, /* (189) cmd ::= SHOW APPS */
  {  240,   -2 }, /* (190) cmd ::= SHOW CONNECTIONS */
  {  240,   -2 }, /* (191) cmd ::= SHOW LICENCE */
  {  240,   -2 }, /* (192) cmd ::= SHOW GRANTS */
  {  240,   -4 }, /* (193) cmd ::= SHOW CREATE DATABASE db_name */
  {  240,   -4 }, /* (194) cmd ::= SHOW CREATE TABLE full_table_name */
  {  240,   -4 }, /* (195) cmd ::= SHOW CREATE STABLE full_table_name */
  {  240,   -2 }, /* (196) cmd ::= SHOW QUERIES */
  {  240,   -2 }, /* (197) cmd ::= SHOW SCORES */
  {  240,   -2 }, /* (198) cmd ::= SHOW TOPICS */
  {  240,   -2 }, /* (199) cmd ::= SHOW VARIABLES */
  {  240,   -2 }, /* (200) cmd ::= SHOW BNODES */
  {  240,   -2 }, /* (201) cmd ::= SHOW SNODES */
  {  240,   -2 }, /* (202) cmd ::= SHOW CLUSTER */
  {  240,   -2 }, /* (203) cmd ::= SHOW TRANSACTIONS */
  {  284,    0 }, /* (204) db_name_cond_opt ::= */
  {  284,   -2 }, /* (205) db_name_cond_opt ::= db_name NK_DOT */
  {  285,    0 }, /* (206) like_pattern_opt ::= */
  {  285,   -2 }, /* (207) like_pattern_opt ::= LIKE NK_STRING */
  {  286,   -1 }, /* (208) table_name_cond ::= table_name */
  {  287,    0 }, /* (209) from_db_opt ::= */
  {  287,   -2 }, /* (210) from_db_opt ::= FROM db_name */
  {  281,   -1 }, /* (211) func_name_list ::= func_name */
  {  281,   -3 }, /* (212) func_name_list ::= func_name_list NK_COMMA func_name */
  {  288,   -1 }, /* (213) func_name ::= function_name */
  {  240,   -8 }, /* (214) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  240,  -10 }, /* (215) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  240,   -6 }, /* (216) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  291,    0 }, /* (217) index_options ::= */
  {  291,   -9 }, /* (218) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  291,  -11 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  292,   -1 }, /* (220) func_list ::= func */
  {  292,   -3 }, /* (221) func_list ::= func_list NK_COMMA func */
  {  295,   -4 }, /* (222) func ::= function_name NK_LP expression_list NK_RP */
  {  240,   -6 }, /* (223) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  240,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  240,   -7 }, /* (225) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  240,   -4 }, /* (226) cmd ::= DROP TOPIC exists_opt topic_name */
  {  240,   -7 }, /* (227) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  240,   -2 }, /* (228) cmd ::= DESC full_table_name */
  {  240,   -2 }, /* (229) cmd ::= DESCRIBE full_table_name */
  {  240,   -3 }, /* (230) cmd ::= RESET QUERY CACHE */
  {  240,   -4 }, /* (231) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  300,    0 }, /* (232) analyze_opt ::= */
  {  300,   -1 }, /* (233) analyze_opt ::= ANALYZE */
  {  301,    0 }, /* (234) explain_options ::= */
  {  301,   -3 }, /* (235) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  301,   -3 }, /* (236) explain_options ::= explain_options RATIO NK_FLOAT */
  {  240,   -6 }, /* (237) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  240,  -10 }, /* (238) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  240,   -4 }, /* (239) cmd ::= DROP FUNCTION exists_opt function_name */
  {  302,    0 }, /* (240) agg_func_opt ::= */
  {  302,   -1 }, /* (241) agg_func_opt ::= AGGREGATE */
  {  303,    0 }, /* (242) bufsize_opt ::= */
  {  303,   -2 }, /* (243) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  240,   -8 }, /* (244) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  240,   -4 }, /* (245) cmd ::= DROP STREAM exists_opt stream_name */
  {  306,    0 }, /* (246) into_opt ::= */
  {  306,   -2 }, /* (247) into_opt ::= INTO full_table_name */
  {  305,    0 }, /* (248) stream_options ::= */
  {  305,   -3 }, /* (249) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  305,   -3 }, /* (250) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  305,   -4 }, /* (251) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  305,   -3 }, /* (252) stream_options ::= stream_options WATERMARK duration_literal */
  {  240,   -3 }, /* (253) cmd ::= KILL CONNECTION NK_INTEGER */
  {  240,   -3 }, /* (254) cmd ::= KILL QUERY NK_INTEGER */
  {  240,   -3 }, /* (255) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  240,   -2 }, /* (256) cmd ::= BALANCE VGROUP */
  {  240,   -4 }, /* (257) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  240,   -4 }, /* (258) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  240,   -3 }, /* (259) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  307,   -2 }, /* (260) dnode_list ::= DNODE NK_INTEGER */
  {  307,   -3 }, /* (261) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  240,   -3 }, /* (262) cmd ::= SYNCDB db_name REPLICA */
  {  240,   -4 }, /* (263) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  240,   -1 }, /* (264) cmd ::= query_expression */
  {  243,   -1 }, /* (265) literal ::= NK_INTEGER */
  {  243,   -1 }, /* (266) literal ::= NK_FLOAT */
  {  243,   -1 }, /* (267) literal ::= NK_STRING */
  {  243,   -1 }, /* (268) literal ::= NK_BOOL */
  {  243,   -2 }, /* (269) literal ::= TIMESTAMP NK_STRING */
  {  243,   -1 }, /* (270) literal ::= duration_literal */
  {  243,   -1 }, /* (271) literal ::= NULL */
  {  243,   -1 }, /* (272) literal ::= NK_QUESTION */
  {  293,   -1 }, /* (273) duration_literal ::= NK_VARIABLE */
  {  309,   -1 }, /* (274) signed ::= NK_INTEGER */
  {  309,   -2 }, /* (275) signed ::= NK_PLUS NK_INTEGER */
  {  309,   -2 }, /* (276) signed ::= NK_MINUS NK_INTEGER */
  {  309,   -1 }, /* (277) signed ::= NK_FLOAT */
  {  309,   -2 }, /* (278) signed ::= NK_PLUS NK_FLOAT */
  {  309,   -2 }, /* (279) signed ::= NK_MINUS NK_FLOAT */
  {  273,   -1 }, /* (280) signed_literal ::= signed */
  {  273,   -1 }, /* (281) signed_literal ::= NK_STRING */
  {  273,   -1 }, /* (282) signed_literal ::= NK_BOOL */
  {  273,   -2 }, /* (283) signed_literal ::= TIMESTAMP NK_STRING */
  {  273,   -1 }, /* (284) signed_literal ::= duration_literal */
  {  273,   -1 }, /* (285) signed_literal ::= NULL */
  {  273,   -1 }, /* (286) signed_literal ::= literal_func */
  {  276,   -1 }, /* (287) literal_list ::= signed_literal */
  {  276,   -3 }, /* (288) literal_list ::= literal_list NK_COMMA signed_literal */
  {  250,   -1 }, /* (289) db_name ::= NK_ID */
  {  279,   -1 }, /* (290) table_name ::= NK_ID */
  {  271,   -1 }, /* (291) column_name ::= NK_ID */
  {  289,   -1 }, /* (292) function_name ::= NK_ID */
  {  311,   -1 }, /* (293) table_alias ::= NK_ID */
  {  312,   -1 }, /* (294) column_alias ::= NK_ID */
  {  245,   -1 }, /* (295) user_name ::= NK_ID */
  {  290,   -1 }, /* (296) index_name ::= NK_ID */
  {  297,   -1 }, /* (297) topic_name ::= NK_ID */
  {  304,   -1 }, /* (298) stream_name ::= NK_ID */
  {  299,   -1 }, /* (299) cgroup_name ::= NK_ID */
  {  313,   -1 }, /* (300) expression ::= literal */
  {  313,   -1 }, /* (301) expression ::= pseudo_column */
  {  313,   -1 }, /* (302) expression ::= column_reference */
  {  313,   -1 }, /* (303) expression ::= function_expression */
  {  313,   -1 }, /* (304) expression ::= subquery */
  {  313,   -3 }, /* (305) expression ::= NK_LP expression NK_RP */
  {  313,   -2 }, /* (306) expression ::= NK_PLUS expression */
  {  313,   -2 }, /* (307) expression ::= NK_MINUS expression */
  {  313,   -3 }, /* (308) expression ::= expression NK_PLUS expression */
  {  313,   -3 }, /* (309) expression ::= expression NK_MINUS expression */
  {  313,   -3 }, /* (310) expression ::= expression NK_STAR expression */
  {  313,   -3 }, /* (311) expression ::= expression NK_SLASH expression */
  {  313,   -3 }, /* (312) expression ::= expression NK_REM expression */
  {  313,   -3 }, /* (313) expression ::= column_reference NK_ARROW NK_STRING */
  {  296,   -1 }, /* (314) expression_list ::= expression */
  {  296,   -3 }, /* (315) expression_list ::= expression_list NK_COMMA expression */
  {  315,   -1 }, /* (316) column_reference ::= column_name */
  {  315,   -3 }, /* (317) column_reference ::= table_name NK_DOT column_name */
  {  314,   -1 }, /* (318) pseudo_column ::= ROWTS */
  {  314,   -1 }, /* (319) pseudo_column ::= TBNAME */
  {  314,   -3 }, /* (320) pseudo_column ::= table_name NK_DOT TBNAME */
  {  314,   -1 }, /* (321) pseudo_column ::= QSTARTTS */
  {  314,   -1 }, /* (322) pseudo_column ::= QENDTS */
  {  314,   -1 }, /* (323) pseudo_column ::= WSTARTTS */
  {  314,   -1 }, /* (324) pseudo_column ::= WENDTS */
  {  314,   -1 }, /* (325) pseudo_column ::= WDURATION */
  {  316,   -4 }, /* (326) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  316,   -4 }, /* (327) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  316,   -6 }, /* (328) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  316,   -1 }, /* (329) function_expression ::= literal_func */
  {  310,   -3 }, /* (330) literal_func ::= noarg_func NK_LP NK_RP */
  {  310,   -1 }, /* (331) literal_func ::= NOW */
  {  320,   -1 }, /* (332) noarg_func ::= NOW */
  {  320,   -1 }, /* (333) noarg_func ::= TODAY */
  {  320,   -1 }, /* (334) noarg_func ::= TIMEZONE */
  {  318,   -1 }, /* (335) star_func ::= COUNT */
  {  318,   -1 }, /* (336) star_func ::= FIRST */
  {  318,   -1 }, /* (337) star_func ::= LAST */
  {  318,   -1 }, /* (338) star_func ::= LAST_ROW */
  {  319,   -1 }, /* (339) star_func_para_list ::= NK_STAR */
  {  319,   -1 }, /* (340) star_func_para_list ::= other_para_list */
  {  321,   -1 }, /* (341) other_para_list ::= star_func_para */
  {  321,   -3 }, /* (342) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  322,   -1 }, /* (343) star_func_para ::= expression */
  {  322,   -3 }, /* (344) star_func_para ::= table_name NK_DOT NK_STAR */
  {  323,   -3 }, /* (345) predicate ::= expression compare_op expression */
  {  323,   -5 }, /* (346) predicate ::= expression BETWEEN expression AND expression */
  {  323,   -6 }, /* (347) predicate ::= expression NOT BETWEEN expression AND expression */
  {  323,   -3 }, /* (348) predicate ::= expression IS NULL */
  {  323,   -4 }, /* (349) predicate ::= expression IS NOT NULL */
  {  323,   -3 }, /* (350) predicate ::= expression in_op in_predicate_value */
  {  324,   -1 }, /* (351) compare_op ::= NK_LT */
  {  324,   -1 }, /* (352) compare_op ::= NK_GT */
  {  324,   -1 }, /* (353) compare_op ::= NK_LE */
  {  324,   -1 }, /* (354) compare_op ::= NK_GE */
  {  324,   -1 }, /* (355) compare_op ::= NK_NE */
  {  324,   -1 }, /* (356) compare_op ::= NK_EQ */
  {  324,   -1 }, /* (357) compare_op ::= LIKE */
  {  324,   -2 }, /* (358) compare_op ::= NOT LIKE */
  {  324,   -1 }, /* (359) compare_op ::= MATCH */
  {  324,   -1 }, /* (360) compare_op ::= NMATCH */
  {  324,   -1 }, /* (361) compare_op ::= CONTAINS */
  {  325,   -1 }, /* (362) in_op ::= IN */
  {  325,   -2 }, /* (363) in_op ::= NOT IN */
  {  326,   -3 }, /* (364) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  327,   -1 }, /* (365) boolean_value_expression ::= boolean_primary */
  {  327,   -2 }, /* (366) boolean_value_expression ::= NOT boolean_primary */
  {  327,   -3 }, /* (367) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  327,   -3 }, /* (368) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  328,   -1 }, /* (369) boolean_primary ::= predicate */
  {  328,   -3 }, /* (370) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  329,   -1 }, /* (371) common_expression ::= expression */
  {  329,   -1 }, /* (372) common_expression ::= boolean_value_expression */
  {  330,   -2 }, /* (373) from_clause ::= FROM table_reference_list */
  {  331,   -1 }, /* (374) table_reference_list ::= table_reference */
  {  331,   -3 }, /* (375) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  332,   -1 }, /* (376) table_reference ::= table_primary */
  {  332,   -1 }, /* (377) table_reference ::= joined_table */
  {  333,   -2 }, /* (378) table_primary ::= table_name alias_opt */
  {  333,   -4 }, /* (379) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  333,   -2 }, /* (380) table_primary ::= subquery alias_opt */
  {  333,   -1 }, /* (381) table_primary ::= parenthesized_joined_table */
  {  335,    0 }, /* (382) alias_opt ::= */
  {  335,   -1 }, /* (383) alias_opt ::= table_alias */
  {  335,   -2 }, /* (384) alias_opt ::= AS table_alias */
  {  336,   -3 }, /* (385) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  336,   -3 }, /* (386) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  334,   -6 }, /* (387) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  337,    0 }, /* (388) join_type ::= */
  {  337,   -1 }, /* (389) join_type ::= INNER */
  {  339,   -9 }, /* (390) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  340,    0 }, /* (391) set_quantifier_opt ::= */
  {  340,   -1 }, /* (392) set_quantifier_opt ::= DISTINCT */
  {  340,   -1 }, /* (393) set_quantifier_opt ::= ALL */
  {  341,   -1 }, /* (394) select_list ::= NK_STAR */
  {  341,   -1 }, /* (395) select_list ::= select_sublist */
  {  346,   -1 }, /* (396) select_sublist ::= select_item */
  {  346,   -3 }, /* (397) select_sublist ::= select_sublist NK_COMMA select_item */
  {  347,   -1 }, /* (398) select_item ::= common_expression */
  {  347,   -2 }, /* (399) select_item ::= common_expression column_alias */
  {  347,   -3 }, /* (400) select_item ::= common_expression AS column_alias */
  {  347,   -3 }, /* (401) select_item ::= table_name NK_DOT NK_STAR */
  {  308,    0 }, /* (402) where_clause_opt ::= */
  {  308,   -2 }, /* (403) where_clause_opt ::= WHERE search_condition */
  {  342,    0 }, /* (404) partition_by_clause_opt ::= */
  {  342,   -3 }, /* (405) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  343,    0 }, /* (406) twindow_clause_opt ::= */
  {  343,   -6 }, /* (407) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  343,   -4 }, /* (408) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  343,   -6 }, /* (409) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  343,   -8 }, /* (410) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  294,    0 }, /* (411) sliding_opt ::= */
  {  294,   -4 }, /* (412) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  348,    0 }, /* (413) fill_opt ::= */
  {  348,   -4 }, /* (414) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  348,   -6 }, /* (415) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  349,   -1 }, /* (416) fill_mode ::= NONE */
  {  349,   -1 }, /* (417) fill_mode ::= PREV */
  {  349,   -1 }, /* (418) fill_mode ::= NULL */
  {  349,   -1 }, /* (419) fill_mode ::= LINEAR */
  {  349,   -1 }, /* (420) fill_mode ::= NEXT */
  {  344,    0 }, /* (421) group_by_clause_opt ::= */
  {  344,   -3 }, /* (422) group_by_clause_opt ::= GROUP BY group_by_list */
  {  350,   -1 }, /* (423) group_by_list ::= expression */
  {  350,   -3 }, /* (424) group_by_list ::= group_by_list NK_COMMA expression */
  {  345,    0 }, /* (425) having_clause_opt ::= */
  {  345,   -2 }, /* (426) having_clause_opt ::= HAVING search_condition */
  {  298,   -4 }, /* (427) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  351,   -1 }, /* (428) query_expression_body ::= query_primary */
  {  351,   -4 }, /* (429) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  351,   -3 }, /* (430) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  355,   -1 }, /* (431) query_primary ::= query_specification */
  {  355,   -6 }, /* (432) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  352,    0 }, /* (433) order_by_clause_opt ::= */
  {  352,   -3 }, /* (434) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  353,    0 }, /* (435) slimit_clause_opt ::= */
  {  353,   -2 }, /* (436) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  353,   -4 }, /* (437) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  353,   -4 }, /* (438) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  354,    0 }, /* (439) limit_clause_opt ::= */
  {  354,   -2 }, /* (440) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  354,   -4 }, /* (441) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  354,   -4 }, /* (442) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  317,   -3 }, /* (443) subquery ::= NK_LP query_expression NK_RP */
  {  338,   -1 }, /* (444) search_condition ::= common_expression */
  {  356,   -1 }, /* (445) sort_specification_list ::= sort_specification */
  {  356,   -3 }, /* (446) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  357,   -3 }, /* (447) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  358,    0 }, /* (448) ordering_specification_opt ::= */
  {  358,   -1 }, /* (449) ordering_specification_opt ::= ASC */
  {  358,   -1 }, /* (450) ordering_specification_opt ::= DESC */
  {  359,    0 }, /* (451) null_ordering_opt ::= */
  {  359,   -2 }, /* (452) null_ordering_opt ::= NULLS FIRST */
  {  359,   -2 }, /* (453) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,242,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,241,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,244,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,242,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,244,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy189 = yymsp[0].minor.yy189; }
  yymsp[0].minor.yy189 = yylhsminor.yy189;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy189 = yymsp[-2].minor.yy189 | yymsp[0].minor.yy189; }
  yymsp[-2].minor.yy189 = yylhsminor.yy189;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy209; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy209, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 289: /* db_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* table_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* column_name ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* function_name ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* table_alias ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* column_alias ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* user_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* index_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* topic_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* stream_name ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==299);
      case 332: /* noarg_func ::= NOW */ yytestcase(yyruleno==332);
      case 333: /* noarg_func ::= TODAY */ yytestcase(yyruleno==333);
      case 334: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==334);
      case 335: /* star_func ::= COUNT */ yytestcase(yyruleno==335);
      case 336: /* star_func ::= FIRST */ yytestcase(yyruleno==336);
      case 337: /* star_func ::= LAST */ yytestcase(yyruleno==337);
      case 338: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==338);
{ yylhsminor.yy209 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy137, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy137 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 232: /* analyze_opt ::= */ yytestcase(yyruleno==232);
      case 240: /* agg_func_opt ::= */ yytestcase(yyruleno==240);
      case 391: /* set_quantifier_opt ::= */ yytestcase(yyruleno==391);
{ yymsp[1].minor.yy137 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy137 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy632 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_KEEP, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_RETENTIONS, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy632 = createAlterDatabaseOptions(pCxt); yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yylhsminor.yy632, &yymsp[0].minor.yy605); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy632, &yymsp[0].minor.yy605); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy605.type = DB_OPTION_KEEP; yymsp[-1].minor.yy605.pList = yymsp[0].minor.yy424; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_PAGES; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_STRICT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 261: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==261);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy424 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 173: /* col_name_list ::= col_name */ yytestcase(yyruleno==173);
      case 211: /* func_name_list ::= func_name */ yytestcase(yyruleno==211);
      case 220: /* func_list ::= func */ yytestcase(yyruleno==220);
      case 287: /* literal_list ::= signed_literal */ yytestcase(yyruleno==287);
      case 341: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==341);
      case 396: /* select_sublist ::= select_item */ yytestcase(yyruleno==396);
      case 445: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==445);
{ yylhsminor.yy424 = createNodeList(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 174: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==221);
      case 288: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==288);
      case 342: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==342);
      case 397: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==397);
      case 446: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==446);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy632 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-5].minor.yy632, yymsp[-3].minor.yy424, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 264: /* cmd ::= query_expression */ yytestcase(yyruleno==264);
{ pCxt->pRootNode = yymsp[0].minor.yy632; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy632 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy632 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy632, &yymsp[-2].minor.yy209, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy424 = yylhsminor.yy424;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy632 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy137, yymsp[-8].minor.yy632, yymsp[-6].minor.yy632, yymsp[-5].minor.yy424, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-9].minor.yy632 = yylhsminor.yy632;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy632 = createDropTableClause(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 404: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==404);
      case 421: /* group_by_clause_opt ::= */ yytestcase(yyruleno==421);
      case 433: /* order_by_clause_opt ::= */ yytestcase(yyruleno==433);
{ yymsp[1].minor.yy424 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304, NULL); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-2].minor.yy304, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 340: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==340);
      case 395: /* select_list ::= select_sublist */ yytestcase(yyruleno==395);
{ yylhsminor.yy424 = yymsp[0].minor.yy424; }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy632 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 165: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 166: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 167: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 168: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_SMA, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 169: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy632 = createAlterTableOptions(pCxt); yylhsminor.yy632 = setTableOption(pCxt, yylhsminor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 170: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 171: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 172: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 175: /* col_name ::= column_name */
{ yylhsminor.yy632 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 176: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy632, NULL); }
        break;
      case 182: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 187: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 189: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW LICENCE */
      case 192: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==192);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 194: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 195: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 196: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 204: /* db_name_cond_opt ::= */
      case 209: /* from_db_opt ::= */ yytestcase(yyruleno==209);
{ yymsp[1].minor.yy632 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 205: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 206: /* like_pattern_opt ::= */
      case 217: /* index_options ::= */ yytestcase(yyruleno==217);
      case 246: /* into_opt ::= */ yytestcase(yyruleno==246);
      case 402: /* where_clause_opt ::= */ yytestcase(yyruleno==402);
      case 406: /* twindow_clause_opt ::= */ yytestcase(yyruleno==406);
      case 411: /* sliding_opt ::= */ yytestcase(yyruleno==411);
      case 413: /* fill_opt ::= */ yytestcase(yyruleno==413);
      case 425: /* having_clause_opt ::= */ yytestcase(yyruleno==425);
      case 435: /* slimit_clause_opt ::= */ yytestcase(yyruleno==435);
      case 439: /* limit_clause_opt ::= */ yytestcase(yyruleno==439);
{ yymsp[1].minor.yy632 = NULL; }
        break;
      case 207: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 208: /* table_name_cond ::= table_name */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 210: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
        break;
      case 213: /* func_name ::= function_name */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 214: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, NULL, yymsp[0].minor.yy632); }
        break;
      case 215: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424, NULL); }
        break;
      case 216: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 218: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy632 = createIndexOption(pCxt, yymsp[-6].minor.yy424, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL, yymsp[0].minor.yy632); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy632 = createIndexOption(pCxt, yymsp[-8].minor.yy424, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[0].minor.yy632); }
        break;
      case 222: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 223: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, yymsp[0].minor.yy632, NULL, NULL); }
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, NULL, &yymsp[0].minor.yy209, NULL); }
        break;
      case 225: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, NULL, NULL, yymsp[0].minor.yy632); }
        break;
      case 226: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 227: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 228: /* cmd ::= DESC full_table_name */
      case 229: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy632); }
        break;
      case 230: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 231: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy137, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 233: /* analyze_opt ::= ANALYZE */
      case 241: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==241);
      case 392: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==392);
{ yymsp[0].minor.yy137 = true; }
        break;
      case 234: /* explain_options ::= */
{ yymsp[1].minor.yy632 = createDefaultExplainOptions(pCxt); }
        break;
      case 235: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy632 = setExplainVerbose(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 236: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy632 = setExplainRatio(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 237: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy424); }
        break;
      case 238: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-8].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy304, yymsp[0].minor.yy100); }
        break;
      case 239: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 242: /* bufsize_opt ::= */
{ yymsp[1].minor.yy100 = 0; }
        break;
      case 243: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy100 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 244: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy137, &yymsp[-4].minor.yy209, yymsp[-2].minor.yy632, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 245: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 247: /* into_opt ::= INTO full_table_name */
      case 373: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==373);
      case 403: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==403);
      case 426: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==426);
{ yymsp[-1].minor.yy632 = yymsp[0].minor.yy632; }
        break;
      case 248: /* stream_options ::= */
{ yymsp[1].minor.yy632 = createStreamOptions(pCxt); }
        break;
      case 249: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 250: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 251: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy632)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy632)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); yylhsminor.yy632 = yymsp[-3].minor.yy632; }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 252: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 253: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 254: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 255: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 256: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 257: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 258: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy424); }
        break;
      case 259: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 260: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 262: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy209); }
        break;
      case 263: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 265: /* literal ::= NK_INTEGER */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 266: /* literal ::= NK_FLOAT */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 267: /* literal ::= NK_STRING */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 268: /* literal ::= NK_BOOL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 269: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 270: /* literal ::= duration_literal */
      case 280: /* signed_literal ::= signed */ yytestcase(yyruleno==280);
      case 300: /* expression ::= literal */ yytestcase(yyruleno==300);
      case 301: /* expression ::= pseudo_column */ yytestcase(yyruleno==301);
      case 302: /* expression ::= column_reference */ yytestcase(yyruleno==302);
      case 303: /* expression ::= function_expression */ yytestcase(yyruleno==303);
      case 304: /* expression ::= subquery */ yytestcase(yyruleno==304);
      case 329: /* function_expression ::= literal_func */ yytestcase(yyruleno==329);
      case 365: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==365);
      case 369: /* boolean_primary ::= predicate */ yytestcase(yyruleno==369);
      case 371: /* common_expression ::= expression */ yytestcase(yyruleno==371);
      case 372: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==372);
      case 374: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==374);
      case 376: /* table_reference ::= table_primary */ yytestcase(yyruleno==376);
      case 377: /* table_reference ::= joined_table */ yytestcase(yyruleno==377);
      case 381: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==381);
      case 428: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==428);
      case 431: /* query_primary ::= query_specification */ yytestcase(yyruleno==431);
{ yylhsminor.yy632 = yymsp[0].minor.yy632; }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 271: /* literal ::= NULL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 272: /* literal ::= NK_QUESTION */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 273: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 274: /* signed ::= NK_INTEGER */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 275: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 276: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 277: /* signed ::= NK_FLOAT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 278: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 279: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 281: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 282: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 283: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 284: /* signed_literal ::= duration_literal */
      case 286: /* signed_literal ::= literal_func */ yytestcase(yyruleno==286);
      case 343: /* star_func_para ::= expression */ yytestcase(yyruleno==343);
      case 398: /* select_item ::= common_expression */ yytestcase(yyruleno==398);
      case 444: /* search_condition ::= common_expression */ yytestcase(yyruleno==444);
{ yylhsminor.yy632 = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 285: /* signed_literal ::= NULL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 305: /* expression ::= NK_LP expression NK_RP */
      case 370: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==370);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 306: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy632));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 307: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 308: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 309: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 310: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 311: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 312: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 313: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 314: /* expression_list ::= expression */
{ yylhsminor.yy424 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 315: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 316: /* column_reference ::= column_name */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy209, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 317: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 318: /* pseudo_column ::= ROWTS */
      case 319: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==319);
      case 321: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==321);
      case 322: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==322);
      case 323: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==323);
      case 324: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==324);
      case 325: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==325);
      case 331: /* literal_func ::= NOW */ yytestcase(yyruleno==331);
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 320: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy209)))); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 326: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 327: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==327);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424)); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 328: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy304)); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 330: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy209, NULL)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 339: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy424 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 344: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 401: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==401);
{ yylhsminor.yy632 = createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 345: /* predicate ::= expression compare_op expression */
      case 350: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==350);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 346: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 347: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 348: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 349: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL));
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 351: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 352: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 353: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 354: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 355: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 356: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 357: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 358: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 359: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 360: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 361: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy380 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 362: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 363: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 364: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 366: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 367: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 368: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 375: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy632, yymsp[0].minor.yy632, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 378: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 379: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 380: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy632 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 382: /* alias_opt ::= */
{ yymsp[1].minor.yy209 = nil_token;  }
        break;
      case 383: /* alias_opt ::= table_alias */
{ yylhsminor.yy209 = yymsp[0].minor.yy209; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 384: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy209 = yymsp[0].minor.yy209; }
        break;
      case 385: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 386: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==386);
{ yymsp[-2].minor.yy632 = yymsp[-1].minor.yy632; }
        break;
      case 387: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, yymsp[-4].minor.yy612, yymsp[-5].minor.yy632, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 388: /* join_type ::= */
{ yymsp[1].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 389: /* join_type ::= INNER */
{ yymsp[0].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 390: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy632 = createSelectStmt(pCxt, yymsp[-7].minor.yy137, yymsp[-6].minor.yy424, yymsp[-5].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addWhereClause(pCxt, yymsp[-8].minor.yy632, yymsp[-4].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addPartitionByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-3].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy632, yymsp[-2].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addGroupByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-1].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addHavingClause(pCxt, yymsp[-8].minor.yy632, yymsp[0].minor.yy632);
                                                                                  }
        break;
      case 393: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy137 = false; }
        break;
      case 394: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy424 = NULL; }
        break;
      case 399: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 400: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 405: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 422: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==422);
      case 434: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==434);
{ yymsp[-2].minor.yy424 = yymsp[0].minor.yy424; }
        break;
      case 407: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy632 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 408: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy632 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 409: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 410: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 412: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy632 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy632); }
        break;
      case 414: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy632 = createFillNode(pCxt, yymsp[-1].minor.yy54, NULL); }
        break;
      case 415: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy632 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
        break;
      case 416: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy54 = FILL_MODE_NONE; }
        break;
      case 417: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy54 = FILL_MODE_PREV; }
        break;
      case 418: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy54 = FILL_MODE_NULL; }
        break;
      case 419: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy54 = FILL_MODE_LINEAR; }
        break;
      case 420: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy54 = FILL_MODE_NEXT; }
        break;
      case 423: /* group_by_list ::= expression */
{ yylhsminor.yy424 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 424: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 427: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy632 = addOrderByClause(pCxt, yymsp[-3].minor.yy632, yymsp[-2].minor.yy424);
                                                                                    yylhsminor.yy632 = addSlimitClause(pCxt, yylhsminor.yy632, yymsp[-1].minor.yy632);
                                                                                    yylhsminor.yy632 = addLimitClause(pCxt, yylhsminor.yy632, yymsp[0].minor.yy632);
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 429: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 430: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 432: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy632 = yymsp[-4].minor.yy632; }
  yy_destructor(yypParser,352,&yymsp[-3].minor);
  yy_destructor(yypParser,353,&yymsp[-2].minor);
  yy_destructor(yypParser,354,&yymsp[-1].minor);
        break;
      case 436: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 440: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==440);
{ yymsp[-1].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 437: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 441: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==441);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 438: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 442: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==442);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 443: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 447: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy632 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[-1].minor.yy578, yymsp[0].minor.yy217); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 448: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy578 = ORDER_ASC; }
        break;
      case 449: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy578 = ORDER_ASC; }
        break;
      case 450: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy578 = ORDER_DESC; }
        break;
      case 451: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy217 = NULL_ORDER_DEFAULT; }
        break;
      case 452: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_FIRST; }
        break;
      case 453: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
