/*
 * Copyright (c) 2019 TAOS Data, Inc. <jhtao@taosdata.com>
 *
 * This program is free software: you can use, redistribute, and/or modify
 * it under the terms of the GNU Affero General Public License, version 3
 * or later ("AGPL"), as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "syncRequestVoteReply.h"

void onRequestVoteReply(SRaft *pRaft, const SyncRequestVoteReply *pMsg) {
  // TLA+ Spec
  // HandleRequestVoteResponse(i, j, m) ==
  //    \* This tallies votes even when the current state is not Candidate, but
  //    \* they won't be looked at, so it doesn't matter.
  //    /\ m.mterm = currentTerm[i]
  //    /\ votesResponded' = [votesResponded EXCEPT ![i] =
  //                              votesResponded[i] \cup {j}]
  //    /\ \/ /\ m.mvoteGranted
  //          /\ votesGranted' = [votesGranted EXCEPT ![i] =
  //                                  votesGranted[i] \cup {j}]
  //          /\ voterLog' = [voterLog EXCEPT ![i] =
  //                              voterLog[i] @@ (j :> m.mlog)]
  //       \/ /\ ~m.mvoteGranted
  //          /\ UNCHANGED <<votesGranted, voterLog>>
  //    /\ Discard(m)
  //    /\ UNCHANGED <<serverVars, votedFor, leaderVars, logVars>>
}
