/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 370
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  ENullOrder yy77;
  SAlterOption yy85;
  int32_t yy100;
  SToken yy109;
  EOrder yy178;
  int64_t yy209;
  int8_t yy323;
  SNodeList* yy404;
  bool yy437;
  EOperatorType yy440;
  SNode* yy452;
  SDataType yy504;
  EJoinType yy532;
  EFillMode yy614;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             653
#define YYNRULE              477
#define YYNTOKEN             246
#define YY_MAX_SHIFT         652
#define YY_MIN_SHIFTREDUCE   947
#define YY_MAX_SHIFTREDUCE   1423
#define YY_ERROR_ACTION      1424
#define YY_ACCEPT_ACTION     1425
#define YY_NO_ACTION         1426
#define YY_MIN_REDUCE        1427
#define YY_MAX_REDUCE        1903
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2208)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   422, 1661,  423, 1462,  430, 1730,  423, 1462,  317, 1881,
 /*    10 */   141, 1425,   39,   37, 1518,  373, 1727,   69, 1552, 1550,
 /*    20 */   326, 1428, 1230, 1880,  379, 1730, 1367, 1878,  334, 1727,
 /*    30 */   115,  140, 1254, 1439, 1743, 1228, 1727,  338,  566, 1556,
 /*    40 */  1606, 1608,  101, 1723, 1729,  100,   99,   98,   97,   96,
 /*    50 */    95,   94,   93,   92,  570, 1881, 1723, 1729,   61,   14,
 /*    60 */  1309,  296, 1761, 1723, 1729, 1236, 1254,  570, 1761,  156,
 /*    70 */   550,  566,  343, 1878,  570, 1713,  519,  549,   39,   37,
 /*    80 */  1360,  427,    1,  504, 1255, 1230,  326, 1252, 1230,   33,
 /*    90 */    32,  439,  530,   40,   38,   36,   35,   34, 1228, 1743,
 /*   100 */    43, 1228,  151, 1774,  649,  520,   87, 1744,  552, 1746,
 /*   110 */  1747,  548, 1881,  570,  518, 1600, 1814,   69, 1301, 1302,
 /*   120 */   298, 1810,   60, 1881, 1255,   14,  156, 1761, 1236, 1881,
 /*   130 */  1878, 1236, 1881,  567,  567,  547,   60,  156,  526, 1557,
 /*   140 */  1713, 1878,  549,  157,  111,  161,  158, 1878,    2,  101,
 /*   150 */  1878,  460,  100,   99,   98,   97,   96,   95,   94,   93,
 /*   160 */    92, 1561, 1561, 1231, 1394, 1229,  119,  649, 1774,  604,
 /*   170 */   649,  287, 1744,  552, 1746, 1747,  548,  546,  570,  543,
 /*   180 */  1786, 1323, 1129, 1130, 1301, 1302, 1450, 1234, 1235,  534,
 /*   190 */  1283, 1284, 1286, 1287, 1288, 1289, 1290,  545,  568, 1298,
 /*   200 */  1299, 1300, 1303, 1285, 1328,  166,  117,  295, 1829, 1252,
 /*   210 */    40,   38,   36,   35,   34,  159,  405, 1427, 1236,  417,
 /*   220 */   528,  153, 1822, 1823,  567, 1827, 1231, 1713, 1229, 1231,
 /*   230 */    67, 1229, 1826,   66, 1384,  377,  390, 1285,  418,   27,
 /*   240 */   392,  110,  109,  108,  107,  106,  105,  104,  103,  102,
 /*   250 */  1234, 1235, 1561, 1234, 1235,  159, 1283, 1284, 1286, 1287,
 /*   260 */  1288, 1289, 1290,  545,  568, 1298, 1299, 1300, 1303,  159,
 /*   270 */   383,  512, 1382, 1383, 1385, 1386,   33,   32,   39,   37,
 /*   280 */    40,   38,   36,   35,   34, 1254,  326,  608, 1230, 1533,
 /*   290 */  1087,  593,  592,  591, 1091,  590, 1093, 1094,  589, 1096,
 /*   300 */   586, 1228, 1102,  583, 1104, 1105,  580,  577,   11,   10,
 /*   310 */   416,   22,  566,  411,  410,  409,  408,  407,  404,  403,
 /*   320 */   402,  401,  400,  396,  395,  394,  393,  387,  386,  385,
 /*   330 */   384, 1236,  381,  380,   39,   37, 1743, 1253,  310,   30,
 /*   340 */   240,  997,  326,  996, 1230,   33,   32,  209,    8,   40,
 /*   350 */    38,   36,   35,   34,  474,  473,  458, 1228, 1731,  472,
 /*   360 */   980, 1256,  116,  469, 1761,  567,  468,  467,  466, 1727,
 /*   370 */   649,  998,  550,   60,   42,   73,  111, 1713,  596,  549,
 /*   380 */   535,   14,  497,  465, 1301, 1302,  311, 1236,  309,  308,
 /*   390 */  1335,  462,  412, 1561,  530,  464, 1723, 1729,  515,  479,
 /*   400 */   984,  985, 1881, 1449,    2, 1774, 1440,  570,   87, 1744,
 /*   410 */   552, 1746, 1747,  548,  489,  570, 1879,  463, 1814,  567,
 /*   420 */  1878,  567,  298, 1810,   84,  553,  649, 1492,  201, 1231,
 /*   430 */   378, 1229,  382,  329, 1881,  607, 1658,  120,  170,  169,
 /*   440 */  1301, 1302,  482, 1448, 1713, 1553,  476, 1561,  156, 1561,
 /*   450 */   490,  200, 1878, 1234, 1235, 1546, 1283, 1284, 1286, 1287,
 /*   460 */  1288, 1289, 1290,  545,  568, 1298, 1299, 1300, 1303,  330,
 /*   470 */   521,  516,   39,   37, 1304,  421,   55,  138,  425,   54,
 /*   480 */   326,  159, 1230,  567, 1713, 1231, 1563, 1229,  474,  473,
 /*   490 */  1881,  231, 1420,  472,  397, 1228,  116,  469,  526, 1519,
 /*   500 */   468,  467,  466,  526,  156,   58,  159,  159, 1878, 1234,
 /*   510 */  1235, 1561, 1283, 1284, 1286, 1287, 1288, 1289, 1290,  545,
 /*   520 */   568, 1298, 1299, 1300, 1303, 1236,  119,   39,   37, 1607,
 /*   530 */  1608,  119,  567,  364, 1257,  326, 1447, 1230,  984,  985,
 /*   540 */    33,   32,    9,  398,   40,   38,   36,   35,   34,  202,
 /*   550 */  1228,   33,   32,  366,  362,   40,   38,   36,   35,   34,
 /*   560 */  1561,  567,  429, 1743,  649,  425,  117,  336,  997, 1446,
 /*   570 */   996,  117,  438, 1657, 1419,  138,  305, 1713, 1301, 1302,
 /*   580 */  1236,  154, 1822, 1823, 1563, 1827,  155, 1822, 1823, 1561,
 /*   590 */  1827, 1761,  602,   39,   37,  235,  567,    9,  998,  550,
 /*   600 */  1445,  326, 1444, 1230, 1713,  464,  549, 1558,   71,  304,
 /*   610 */  1713,  129,  128,  599,  598,  597, 1228,  567,  506,  649,
 /*   620 */   471,  470, 1479, 1231, 1561, 1229, 1374,  463, 1690,   36,
 /*   630 */    35,   34, 1774, 1301, 1302,  288, 1744,  552, 1746, 1747,
 /*   640 */   548, 1713,  570, 1713,  475, 1561, 1236, 1234, 1235, 1049,
 /*   650 */  1283, 1284, 1286, 1287, 1288, 1289, 1290,  545,  568, 1298,
 /*   660 */  1299, 1300, 1303,    2,  212,  567,  567,   33,   32, 1254,
 /*   670 */   567,   40,   38,   36,   35,   34,  498,  502, 1231, 1051,
 /*   680 */  1229,  564,   33,   32, 1651,  649,   40,   38,   36,   35,
 /*   690 */    34,  620,  618, 1561, 1561,  168, 1834, 1355, 1561, 1301,
 /*   700 */  1302, 1538, 1234, 1235, 1548, 1283, 1284, 1286, 1287, 1288,
 /*   710 */  1289, 1290,  545,  568, 1298, 1299, 1300, 1303,  299,   60,
 /*   720 */   567,   33,   32,  652,  339,   40,   38,   36,   35,   34,
 /*   730 */  1544,  565,  138,  299,  532,  205, 1613,  262,  567, 1539,
 /*   740 */   488, 1563, 1268,  331, 1231, 1443, 1229, 1613, 1561,  256,
 /*   750 */  1321,  149, 1611,  486,  337,  484,  642,  638,  634,  630,
 /*   760 */   260,  244, 1743, 1611, 1537, 1321, 1561, 1442, 1234, 1235,
 /*   770 */  1441, 1283, 1284, 1286, 1287, 1288, 1289, 1290,  545,  568,
 /*   780 */  1298, 1299, 1300, 1303,  138,   85, 1713,  139,  254,  553,
 /*   790 */  1761, 1438,  273, 1564, 1359,  602, 1268,  439,  550,  372,
 /*   800 */  1659,  371,  567, 1713, 1322,  549,  271,   57, 1713, 1829,
 /*   810 */    56, 1713,  544,  340,  129,  128,  599,  598,  597, 1322,
 /*   820 */  1437,  563,  604, 1212, 1213, 1656,  171, 1327,  305, 1613,
 /*   830 */  1561, 1774, 1713, 1825,   88, 1744,  552, 1746, 1747,  548,
 /*   840 */  1285,  570, 1327, 1489, 1814, 1612, 1436, 1435,  319, 1810,
 /*   850 */  1894,   60,  159,  211,   78, 1701,    7,  595, 1434, 1849,
 /*   860 */  1433, 1713,   29,  324, 1316, 1317, 1318, 1319, 1320, 1324,
 /*   870 */  1325, 1326,  245,  246, 1204, 1554,  204,   29,  324, 1316,
 /*   880 */  1317, 1318, 1319, 1320, 1324, 1325, 1326, 1713, 1713,   86,
 /*   890 */    33,   32,  513, 1432,   40,   38,   36,   35,   34, 1713,
 /*   900 */  1743, 1713,  352, 1431,  626,  625,  624,  341, 1829,  623,
 /*   910 */   622,  621,  121,  616,  615,  614,  613,  612,  611,  610,
 /*   920 */   609,  131,  605,  619,   64,   63,  376, 1430, 1761,  165,
 /*   930 */   208,  542, 1824,  304, 1713,  370,  529,  333,  332,  600,
 /*   940 */   537, 1713, 1604,  549, 1713,  601,  294, 1244, 1604,  360,
 /*   950 */  1239,  358,  354,  350,  162,  345,  267,  457,   72, 1591,
 /*   960 */  1237, 1743,  193,  367,  195,  191,  223,  194, 1713, 1774,
 /*   970 */  1536, 1474,   88, 1744,  552, 1746, 1747,  548,  197,  570,
 /*   980 */   199,  196, 1814,  198,  159, 1472,  319, 1810,  152, 1761,
 /*   990 */  1236,   52,  501,  477,   11,   10, 1238,  529,  491,   50,
 /*  1000 */   232, 1762, 1713,   83,  549,   26, 1358,  480,  505, 1842,
 /*  1010 */  1733,   33,   32,   80,   28,   40,   38,   36,   35,   34,
 /*  1020 */    33,   32, 1743,  342,   40,   38,   36,   35,   34,  571,
 /*  1030 */  1774, 1355,  137,   88, 1744,  552, 1746, 1747,  548, 1381,
 /*  1040 */   570, 1422, 1423, 1814, 1463, 1601, 1735,  319, 1810,  152,
 /*  1050 */  1761, 1845,  216,   41,  527,  234,  237,  239,  550, 1313,
 /*  1060 */    41,    5,   41, 1713,  602,  549,  242,  344,    3, 1252,
 /*  1070 */  1843,  123,  347,  351,  126,  127,   50, 1743,  306, 1049,
 /*  1080 */  1242,  575,  126,  129,  128,  599,  598,  597, 1245, 1468,
 /*  1090 */  1240, 1774,  218, 1329,   88, 1744,  552, 1746, 1747,  548,
 /*  1100 */  1291,  570, 1180,  127, 1814, 1761,  247,  112,  319, 1810,
 /*  1110 */  1894,  559, 1248,  550,  253, 1080,  266,  307, 1713, 1872,
 /*  1120 */   549, 1108, 1112,  568, 1298, 1299, 1241, 1196,  126,  263,
 /*  1130 */  1743, 1021,  399,  538, 1653,  167,  406,  644, 1258, 1743,
 /*  1140 */   414,  413,  415, 1119,  419, 1261, 1774, 1117,  431,   88,
 /*  1150 */  1744,  552, 1746, 1747,  548,  420,  570, 1743, 1761, 1814,
 /*  1160 */   428, 1022,  174,  319, 1810, 1894,  550, 1761,  130, 1260,
 /*  1170 */   433, 1713,  176,  549, 1833,  550,  432, 1262,  434,  179,
 /*  1180 */  1713,  181,  549, 1259,  437, 1761,  459,  183,  530,  436,
 /*  1190 */    68,  440,  186,  550,  461,   91, 1551,  530, 1713, 1774,
 /*  1200 */   549,  190,  280, 1744,  552, 1746, 1747,  548, 1774,  570,
 /*  1210 */  1547,  280, 1744,  552, 1746, 1747,  548,  192,  570,  132,
 /*  1220 */   133, 1549, 1743, 1545,  134,  135, 1774,  297, 1881,   89,
 /*  1230 */  1744,  552, 1746, 1747,  548, 1695,  570, 1881, 1743, 1814,
 /*  1240 */   264,  203,  158, 1813, 1810,  492, 1878, 1743,  493,  496,
 /*  1250 */  1761,  156, 1257,  206,  499, 1878,  503,  316,  550,  210,
 /*  1260 */   514, 1846,  509, 1713,  556,  549, 1761, 1856,  214,  511,
 /*  1270 */   217,  318,    6,  517,  550, 1761,  523,  510, 1836, 1713,
 /*  1280 */   224,  549,  508,  550,  507, 1855, 1355,  118, 1713,  226,
 /*  1290 */   549, 1774,  222,  227,   89, 1744,  552, 1746, 1747,  548,
 /*  1300 */  1743,  570,  146,  225, 1814, 1256, 1830, 1774,  541, 1810,
 /*  1310 */   142, 1744,  552, 1746, 1747,  548, 1774,  570,   44,   89,
 /*  1320 */  1744,  552, 1746, 1747,  548,  539,  570, 1877, 1761, 1814,
 /*  1330 */   188,  536,  320,   18, 1811,  124,  550,  233,  236,  228,
 /*  1340 */  1795, 1713,  125,  549,  144,  554,  555, 1897,  533,  456,
 /*  1350 */   452,  448,  444,  187, 1743,  531, 1895, 1694, 1663,  557,
 /*  1360 */   540,  328,  560, 1743,  561,  249,  251,  238,  562, 1774,
 /*  1370 */   265,   77,  283, 1744,  552, 1746, 1747,  548,   70,  570,
 /*  1380 */  1562,  185, 1761,   79,  573,  268, 1534,  645,  259, 1605,
 /*  1390 */   550, 1761,  646,  648,   51, 1713,  145,  549,  289,  550,
 /*  1400 */   272,  291,  290,  270, 1713, 1707,  549, 1706,   62, 1705,
 /*  1410 */   346,  522,  348, 1743, 1702,  349, 1223, 1224,  323,  163,
 /*  1420 */   353, 1700,  355, 1774, 1743,  356,  142, 1744,  552, 1746,
 /*  1430 */  1747,  548, 1774,  570,  357,  288, 1744,  552, 1746, 1747,
 /*  1440 */   548, 1761,  570,  184,  177, 1699,  182,  359, 1698,  547,
 /*  1450 */   435,  361, 1761, 1697, 1713,  363,  549, 1696,  365, 1680,
 /*  1460 */   550,  164,  368,  369, 1199, 1713, 1198,  549, 1674,  175,
 /*  1470 */  1673,  374, 1896,  375, 1672, 1671, 1743, 1168, 1646,  325,
 /*  1480 */  1645, 1644, 1774,   65, 1643,  287, 1744,  552, 1746, 1747,
 /*  1490 */   548, 1642,  570, 1774, 1787, 1641,  288, 1744,  552, 1746,
 /*  1500 */  1747,  548, 1640,  570, 1761, 1639,  388,  389, 1638,  391,
 /*  1510 */  1637, 1636,  550, 1635, 1634, 1633, 1632, 1713, 1631,  549,
 /*  1520 */  1630, 1629, 1628, 1627, 1626, 1625, 1624,  122, 1623, 1743,
 /*  1530 */  1622,  327, 1621, 1620, 1619, 1618, 1617, 1616, 1743, 1170,
 /*  1540 */  1615, 1614, 1491, 1459,  150, 1774,  172, 1743,  288, 1744,
 /*  1550 */   552, 1746, 1747,  548, 1458,  570, 1688, 1761,  113,  987,
 /*  1560 */   986, 1682, 1670, 1669,  180,  550, 1761, 1655, 1540,  173,
 /*  1570 */  1713, 1490,  549,  424,  550, 1761, 1488,  426,  114, 1713,
 /*  1580 */  1486,  549, 1484,  550, 1482,  441,  178,  443, 1713, 1471,
 /*  1590 */   549,  442,  445, 1470,  447,  449, 1455, 1542, 1774, 1743,
 /*  1600 */   446,  274, 1744,  552, 1746, 1747,  548, 1774,  570,  451,
 /*  1610 */   275, 1744,  552, 1746, 1747,  548, 1774,  570,  453,  276,
 /*  1620 */  1744,  552, 1746, 1747,  548, 1015,  570, 1761,  450,   49,
 /*  1630 */   455, 1122,  454, 1123, 1541,  550, 1048, 1047, 1046, 1045,
 /*  1640 */  1713, 1743,  549,  617, 1480, 1042, 1041, 1040,  189,  619,
 /*  1650 */   312, 1475,  313, 1473,  478,  314,  481, 1454,  483, 1453,
 /*  1660 */   485, 1743, 1452,  487, 1687,   90, 1206, 1681, 1774, 1761,
 /*  1670 */   494,  282, 1744,  552, 1746, 1747,  548,  550,  570, 1668,
 /*  1680 */  1666,  136, 1713, 1743,  549, 1667, 1665, 1664,   15, 1761,
 /*  1690 */     4, 1408,   41,   47,   10,   23,  213,  550, 1396,  207,
 /*  1700 */   143,   53, 1713,  215,  549, 1380,  219,  221,   24,  220,
 /*  1710 */  1774, 1761, 1373,  284, 1744,  552, 1746, 1747,  548,  550,
 /*  1720 */   570,  500,  495,  315, 1713,   74,  549, 1733,   16, 1352,
 /*  1730 */  1774,   25,   46,  277, 1744,  552, 1746, 1747,  548, 1743,
 /*  1740 */   570, 1351,  230,  147,   17, 1407, 1413,  321, 1743, 1412,
 /*  1750 */  1411, 1402, 1774,  322,   19,  285, 1744,  552, 1746, 1747,
 /*  1760 */   548, 1314,  570,  148, 1276, 1293,   31, 1761,  160, 1662,
 /*  1770 */  1654,  250, 1732, 1292,  241,  550, 1761,   45, 1378,  551,
 /*  1780 */  1713,   12,  549,  558,  550,   13,   20,   21,  243, 1713,
 /*  1790 */   248,  549,   80,  255, 1246,   75,  572,  574, 1743, 1295,
 /*  1800 */   252,   76, 1777,  569, 1101,   48,  335, 1743, 1774,  578,
 /*  1810 */  1109,  278, 1744,  552, 1746, 1747,  548, 1774,  570,  576,
 /*  1820 */   286, 1744,  552, 1746, 1747,  548, 1761,  570, 1106, 1103,
 /*  1830 */   579,  581,  582,  584,  550, 1761,  587, 1097,  585, 1713,
 /*  1840 */  1095,  549,  588,  550, 1100, 1099, 1086, 1098, 1713,  594,
 /*  1850 */   549, 1118,  257, 1114, 1013,   81,  603, 1743,   82,   59,
 /*  1860 */  1037,  606,  258, 1035, 1055, 1034, 1743, 1774, 1033, 1032,
 /*  1870 */   279, 1744,  552, 1746, 1747,  548, 1774,  570, 1031,  292,
 /*  1880 */  1744,  552, 1746, 1747,  548, 1761,  570, 1030, 1029, 1028,
 /*  1890 */  1050, 1052, 1025,  550, 1761, 1024, 1023, 1020, 1713, 1019,
 /*  1900 */   549, 1018,  550, 1487,  627,  628,  629, 1713, 1485,  549,
 /*  1910 */   631,  633, 1483,  635, 1481,  632,  637,  636, 1743,  639,
 /*  1920 */   640,  641, 1469,  643,  977, 1451, 1774, 1743,  261,  293,
 /*  1930 */  1744,  552, 1746, 1747,  548, 1774,  570,  647, 1755, 1744,
 /*  1940 */   552, 1746, 1747,  548,  650,  570, 1761, 1426, 1232,  269,
 /*  1950 */   651, 1426, 1426, 1426,  550, 1761, 1426, 1426, 1426, 1713,
 /*  1960 */  1426,  549, 1426,  550, 1426, 1426, 1426, 1426, 1713, 1426,
 /*  1970 */   549, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426,
 /*  1980 */  1743, 1426, 1426, 1426, 1426, 1426, 1426, 1774, 1426, 1743,
 /*  1990 */  1754, 1744,  552, 1746, 1747,  548, 1774,  570, 1743, 1753,
 /*  2000 */  1744,  552, 1746, 1747,  548, 1426,  570, 1743, 1761, 1426,
 /*  2010 */   526, 1426, 1426, 1426, 1426, 1426,  550, 1761, 1426, 1426,
 /*  2020 */  1426, 1713, 1426,  549, 1426,  550, 1761, 1426, 1426, 1426,
 /*  2030 */  1713, 1426,  549, 1426,  550, 1761, 1426, 1426,  119, 1713,
 /*  2040 */  1426,  549, 1426,  550, 1426, 1426, 1426, 1426, 1713, 1774,
 /*  2050 */   549, 1426,  302, 1744,  552, 1746, 1747,  548, 1774,  570,
 /*  2060 */   530,  301, 1744,  552, 1746, 1747,  548, 1774,  570, 1426,
 /*  2070 */   303, 1744,  552, 1746, 1747,  548, 1774,  570,  117,  300,
 /*  2080 */  1744,  552, 1746, 1747,  548, 1743,  570, 1426, 1426, 1426,
 /*  2090 */  1426, 1426, 1426,  229, 1822,  525, 1426,  524, 1426,  526,
 /*  2100 */  1881, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426,
 /*  2110 */  1426, 1426, 1426, 1761,  158, 1426, 1426, 1426, 1878, 1426,
 /*  2120 */  1426,  550, 1426, 1426, 1426, 1426, 1713,  119,  549, 1426,
 /*  2130 */  1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426,
 /*  2140 */  1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426,  530,
 /*  2150 */  1426, 1426, 1426, 1426, 1774, 1426, 1426,  281, 1744,  552,
 /*  2160 */  1746, 1747,  548, 1426,  570, 1426, 1426,  117, 1426, 1426,
 /*  2170 */  1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426,
 /*  2180 */  1426, 1426,  229, 1822,  525, 1426,  524, 1426, 1426, 1881,
 /*  2190 */  1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426,
 /*  2200 */  1426, 1426, 1426,  156, 1426, 1426, 1426, 1878,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   253,    0,  255,  256,  253,  279,  255,  256,  282,  347,
 /*    10 */   262,  246,   12,   13,  266,  307,  290,  261,  279,  278,
 /*    20 */    20,    0,   22,  361,  257,  279,   14,  365,  282,  290,
 /*    30 */   274,  248,   20,  250,  249,   35,  290,  288,   20,  283,
 /*    40 */   291,  292,   21,  317,  318,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  328,  347,  317,  318,    4,   59,
 /*    60 */    14,  294,  277,  317,  318,   65,   20,  328,  277,  361,
 /*    70 */   285,   20,  307,  365,  328,  290,  285,  292,   12,   13,
 /*    80 */    14,   14,   82,  307,   20,   22,   20,   20,   22,    8,
 /*    90 */     9,   58,  307,   12,   13,   14,   15,   16,   35,  249,
 /*   100 */    82,   35,  276,  318,  104,   20,  321,  322,  323,  324,
 /*   110 */   325,  326,  347,  328,  323,  289,  331,  261,  118,  119,
 /*   120 */   335,  336,   82,  347,   20,   59,  361,  277,   65,  347,
 /*   130 */   365,   65,  347,  257,  257,  285,   82,  361,  257,  283,
 /*   140 */   290,  365,  292,  361,  268,  268,  361,  365,   82,   21,
 /*   150 */   365,  275,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   160 */    32,  285,  285,  163,   83,  165,  285,  104,  318,   58,
 /*   170 */   104,  321,  322,  323,  324,  325,  326,  327,  328,  329,
 /*   180 */   330,  145,  118,  119,  118,  119,  249,  187,  188,   43,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  191,  168,   56,  325,   18,  319,   20,
 /*   210 */    12,   13,   14,   15,   16,  215,   27,    0,   65,   30,
 /*   220 */   339,  340,  341,  342,  257,  344,  163,  290,  165,  163,
 /*   230 */    81,  165,  343,   84,  187,  268,   47,  191,   49,  203,
 /*   240 */    51,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   250 */   187,  188,  285,  187,  188,  215,  190,  191,  192,  193,
 /*   260 */   194,  195,  196,  197,  198,  199,  200,  201,  202,  215,
 /*   270 */    81,  224,  225,  226,  227,  228,    8,    9,   12,   13,
 /*   280 */    12,   13,   14,   15,   16,   20,   20,  265,   22,  267,
 /*   290 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   300 */   105,   35,  107,  108,  109,  110,  111,  112,    1,    2,
 /*   310 */   121,   43,   20,  124,  125,  126,  127,  128,  129,  130,
 /*   320 */   131,  132,  133,  134,  135,  136,  137,  138,  139,  140,
 /*   330 */   141,   65,  143,  144,   12,   13,  249,   20,   37,  332,
 /*   340 */   333,   20,   20,   22,   22,    8,    9,   56,   82,   12,
 /*   350 */    13,   14,   15,   16,   61,   62,   35,   35,  279,   66,
 /*   360 */     4,   20,   69,   70,  277,  257,   73,   74,   75,  290,
 /*   370 */   104,   50,  285,   82,   82,   84,  268,  290,   93,  292,
 /*   380 */   234,   59,  311,  275,  118,  119,   85,   65,   87,   88,
 /*   390 */    83,   90,   76,  285,  307,   94,  317,  318,  148,    4,
 /*   400 */    44,   45,  347,  249,   82,  318,  250,  328,  321,  322,
 /*   410 */   323,  324,  325,  326,   19,  328,  361,  116,  331,  257,
 /*   420 */   365,  257,  335,  336,  259,  292,  104,    0,   33,  163,
 /*   430 */   268,  165,  268,  300,  347,   65,  303,  272,  122,  123,
 /*   440 */   118,  119,   47,  249,  290,  280,   51,  285,  361,  285,
 /*   450 */   307,   56,  365,  187,  188,  278,  190,  191,  192,  193,
 /*   460 */   194,  195,  196,  197,  198,  199,  200,  201,  202,  269,
 /*   470 */   220,  221,   12,   13,   14,  254,   81,  277,  257,   84,
 /*   480 */    20,  215,   22,  257,  290,  163,  286,  165,   61,   62,
 /*   490 */   347,  150,  155,   66,  268,   35,   69,   70,  257,  266,
 /*   500 */    73,   74,   75,  257,  361,    3,  215,  215,  365,  187,
 /*   510 */   188,  285,  190,  191,  192,  193,  194,  195,  196,  197,
 /*   520 */   198,  199,  200,  201,  202,   65,  285,   12,   13,  291,
 /*   530 */   292,  285,  257,  158,   20,   20,  249,   22,   44,   45,
 /*   540 */     8,    9,   82,  268,   12,   13,   14,   15,   16,  114,
 /*   550 */    35,    8,    9,  178,  179,   12,   13,   14,   15,   16,
 /*   560 */   285,  257,  254,  249,  104,  257,  325,  269,   20,  249,
 /*   570 */    22,  325,  268,  302,  237,  277,  305,  290,  118,  119,
 /*   580 */    65,  340,  341,  342,  286,  344,  340,  341,  342,  285,
 /*   590 */   344,  277,   94,   12,   13,  368,  257,   82,   50,  285,
 /*   600 */   249,   20,  249,   22,  290,   94,  292,  268,  173,  174,
 /*   610 */   290,  113,  114,  115,  116,  117,   35,  257,  304,  104,
 /*   620 */   263,  264,    0,  163,  285,  165,   83,  116,  268,   14,
 /*   630 */    15,   16,  318,  118,  119,  321,  322,  323,  324,  325,
 /*   640 */   326,  290,  328,  290,   22,  285,   65,  187,  188,   35,
 /*   650 */   190,  191,  192,  193,  194,  195,  196,  197,  198,  199,
 /*   660 */   200,  201,  202,   82,  150,  257,  257,    8,    9,   20,
 /*   670 */   257,   12,   13,   14,   15,   16,  268,  268,  163,   65,
 /*   680 */   165,  268,    8,    9,  285,  104,   12,   13,   14,   15,
 /*   690 */    16,  263,  264,  285,  285,  296,  213,  214,  285,  118,
 /*   700 */   119,    0,  187,  188,  278,  190,  191,  192,  193,  194,
 /*   710 */   195,  196,  197,  198,  199,  200,  201,  202,   59,   82,
 /*   720 */   257,    8,    9,   19,  269,   12,   13,   14,   15,   16,
 /*   730 */   278,  268,  277,   59,  232,  278,  277,   33,  257,    0,
 /*   740 */    21,  286,   83,  284,  163,  249,  165,  277,  285,  268,
 /*   750 */    91,   47,  293,   34,  284,   36,   52,   53,   54,   55,
 /*   760 */    56,  113,  249,  293,    0,   91,  285,  249,  187,  188,
 /*   770 */   249,  190,  191,  192,  193,  194,  195,  196,  197,  198,
 /*   780 */   199,  200,  201,  202,  277,   81,  290,   18,   84,  292,
 /*   790 */   277,  249,   23,  286,    4,   94,   83,   58,  285,  162,
 /*   800 */   303,  164,  257,  290,  145,  292,   37,   38,  290,  319,
 /*   810 */    41,  290,  278,  268,  113,  114,  115,  116,  117,  145,
 /*   820 */   249,  117,   58,  175,  176,  302,   57,  168,  305,  277,
 /*   830 */   285,  318,  290,  343,  321,  322,  323,  324,  325,  326,
 /*   840 */   191,  328,  168,    0,  331,  293,  249,  249,  335,  336,
 /*   850 */   337,   82,  215,  149,  259,    0,   39,  278,  249,  346,
 /*   860 */   249,  290,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   870 */   211,  212,  113,  114,  170,  280,  172,  203,  204,  205,
 /*   880 */   206,  207,  208,  209,  210,  211,  212,  290,  290,  120,
 /*   890 */     8,    9,  359,  249,   12,   13,   14,   15,   16,  290,
 /*   900 */   249,  290,   47,  249,   61,   62,   63,   64,  319,   66,
 /*   910 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   920 */    77,   78,   79,   43,  155,  156,  157,  249,  277,  160,
 /*   930 */    56,   59,  343,  174,  290,  166,  285,   12,   13,  287,
 /*   940 */    43,  290,  290,  292,  290,  287,  177,   22,  290,  180,
 /*   950 */    35,  182,  183,  184,  185,  186,  270,  258,   84,  273,
 /*   960 */    35,  249,   86,   83,   86,   89,  354,   89,  290,  318,
 /*   970 */     0,    0,  321,  322,  323,  324,  325,  326,   86,  328,
 /*   980 */    86,   89,  331,   89,  215,    0,  335,  336,  337,  277,
 /*   990 */    65,  150,  151,   22,    1,    2,   35,  285,  314,   43,
 /*  1000 */   349,  277,  290,   82,  292,    2,  216,   22,  357,  358,
 /*  1010 */    46,    8,    9,   92,    2,   12,   13,   14,   15,   16,
 /*  1020 */     8,    9,  249,  258,   12,   13,   14,   15,   16,  104,
 /*  1030 */   318,  214,  150,  321,  322,  323,  324,  325,  326,   83,
 /*  1040 */   328,  118,  119,  331,  256,  289,   82,  335,  336,  337,
 /*  1050 */   277,  320,   43,   43,  345,  362,  362,  362,  285,  187,
 /*  1060 */    43,  217,   43,  290,   94,  292,   43,  316,  348,   20,
 /*  1070 */   358,   43,  257,   47,   43,   43,   43,  249,  315,   35,
 /*  1080 */   165,   43,   43,  113,  114,  115,  116,  117,  163,    0,
 /*  1090 */   165,  318,   83,   83,  321,  322,  323,  324,  325,  326,
 /*  1100 */    83,  328,   83,   43,  331,  277,   83,   43,  335,  336,
 /*  1110 */   337,   83,  187,  285,   83,   83,   83,  263,  290,  346,
 /*  1120 */   292,   83,   83,  198,  199,  200,  165,  161,   43,  309,
 /*  1130 */   249,   35,  257,  236,  257,   42,  297,   48,   20,  249,
 /*  1140 */   145,  295,  295,   83,  257,   20,  318,   83,  313,  321,
 /*  1150 */   322,  323,  324,  325,  326,  251,  328,  249,  277,  331,
 /*  1160 */   251,   65,  261,  335,  336,  337,  285,  277,   83,   20,
 /*  1170 */   306,  290,  261,  292,  346,  285,  292,   20,  308,  261,
 /*  1180 */   290,  261,  292,   20,  298,  277,  251,  261,  307,  306,
 /*  1190 */   261,  257,  261,  285,  277,  257,  277,  307,  290,  318,
 /*  1200 */   292,  277,  321,  322,  323,  324,  325,  326,  318,  328,
 /*  1210 */   277,  321,  322,  323,  324,  325,  326,  277,  328,  277,
 /*  1220 */   277,  277,  249,  277,  277,  277,  318,  251,  347,  321,
 /*  1230 */   322,  323,  324,  325,  326,  290,  328,  347,  249,  331,
 /*  1240 */   313,  259,  361,  335,  336,  171,  365,  249,  312,  292,
 /*  1250 */   277,  361,   20,  259,  257,  365,  257,  306,  285,  259,
 /*  1260 */   223,  320,  290,  290,  222,  292,  277,  353,  301,  290,
 /*  1270 */   301,  290,  229,  290,  285,  277,  154,  231,  356,  290,
 /*  1280 */   352,  292,  230,  285,  218,  353,  214,  285,  290,  350,
 /*  1290 */   292,  318,  355,  316,  321,  322,  323,  324,  325,  326,
 /*  1300 */   249,  328,  353,  351,  331,   20,  319,  318,  335,  336,
 /*  1310 */   321,  322,  323,  324,  325,  326,  318,  328,   42,  321,
 /*  1320 */   322,  323,  324,  325,  326,  235,  328,  364,  277,  331,
 /*  1330 */    33,  233,  238,   82,  336,  301,  285,  363,  363,  338,
 /*  1340 */   334,  290,  301,  292,   47,  290,  290,  369,  364,   52,
 /*  1350 */    53,   54,   55,   56,  249,  366,  367,  290,  290,  290,
 /*  1360 */   364,  290,  147,  249,  299,  285,  259,  363,  298,  318,
 /*  1370 */   273,  259,  321,  322,  323,  324,  325,  326,   81,  328,
 /*  1380 */   285,   84,  277,   82,  281,  257,  267,   36,  259,  290,
 /*  1390 */   285,  277,  252,  251,  310,  290,  305,  292,  271,  285,
 /*  1400 */   247,  271,  271,  260,  290,    0,  292,    0,   42,    0,
 /*  1410 */    73,  360,   35,  249,    0,  181,   35,   35,  304,   35,
 /*  1420 */   181,    0,   35,  318,  249,   35,  321,  322,  323,  324,
 /*  1430 */   325,  326,  318,  328,  181,  321,  322,  323,  324,  325,
 /*  1440 */   326,  277,  328,  146,  147,    0,  149,  181,    0,  285,
 /*  1450 */   153,   35,  277,    0,  290,   22,  292,    0,   35,    0,
 /*  1460 */   285,   82,  168,  167,  165,  290,  163,  292,    0,  172,
 /*  1470 */     0,  159,  367,  158,    0,    0,  249,   46,    0,  304,
 /*  1480 */     0,    0,  318,  142,    0,  321,  322,  323,  324,  325,
 /*  1490 */   326,    0,  328,  318,  330,    0,  321,  322,  323,  324,
 /*  1500 */   325,  326,    0,  328,  277,    0,  137,   35,    0,  137,
 /*  1510 */     0,    0,  285,    0,    0,    0,    0,  290,    0,  292,
 /*  1520 */     0,    0,    0,    0,    0,    0,    0,   42,    0,  249,
 /*  1530 */     0,  304,    0,    0,    0,    0,    0,    0,  249,   22,
 /*  1540 */     0,    0,    0,    0,   43,  318,   42,  249,  321,  322,
 /*  1550 */   323,  324,  325,  326,    0,  328,    0,  277,   39,   14,
 /*  1560 */    14,    0,    0,    0,  154,  285,  277,    0,    0,   40,
 /*  1570 */   290,    0,  292,   46,  285,  277,    0,   46,   39,  290,
 /*  1580 */     0,  292,    0,  285,    0,   35,   39,   39,  290,    0,
 /*  1590 */   292,   47,   35,    0,   39,   35,    0,    0,  318,  249,
 /*  1600 */    47,  321,  322,  323,  324,  325,  326,  318,  328,   39,
 /*  1610 */   321,  322,  323,  324,  325,  326,  318,  328,   35,  321,
 /*  1620 */   322,  323,  324,  325,  326,   60,  328,  277,   47,   91,
 /*  1630 */    39,   22,   47,   35,    0,  285,   35,   35,   35,   35,
 /*  1640 */   290,  249,  292,   43,    0,   35,   35,   35,   89,   43,
 /*  1650 */    22,    0,   22,    0,   49,   22,   35,    0,   35,    0,
 /*  1660 */    35,  249,    0,   22,    0,   20,   35,    0,  318,  277,
 /*  1670 */    22,  321,  322,  323,  324,  325,  326,  285,  328,    0,
 /*  1680 */     0,  169,  290,  249,  292,    0,    0,    0,  219,  277,
 /*  1690 */    43,   35,   43,   43,    2,   82,   82,  285,   83,  147,
 /*  1700 */    82,  150,  290,   83,  292,   83,   82,   46,   82,   43,
 /*  1710 */   318,  277,   83,  321,  322,  323,  324,  325,  326,  285,
 /*  1720 */   328,  152,  150,  150,  290,   82,  292,   46,  219,   83,
 /*  1730 */   318,   43,   43,  321,  322,  323,  324,  325,  326,  249,
 /*  1740 */   328,   83,   46,   46,   43,   35,   83,   35,  249,   35,
 /*  1750 */    35,   83,  318,   35,   43,  321,  322,  323,  324,  325,
 /*  1760 */   326,  187,  328,   46,   22,   83,   82,  277,   46,    0,
 /*  1770 */     0,   39,   46,   83,   83,  285,  277,  213,   83,  189,
 /*  1780 */   290,   82,  292,  148,  285,  219,   82,   82,   82,  290,
 /*  1790 */    82,  292,   92,   46,   22,   82,   93,   35,  249,   83,
 /*  1800 */   146,   82,   82,   82,  106,   82,   35,  249,  318,   35,
 /*  1810 */    83,  321,  322,  323,  324,  325,  326,  318,  328,   82,
 /*  1820 */   321,  322,  323,  324,  325,  326,  277,  328,   83,   83,
 /*  1830 */    82,   35,   82,   35,  285,  277,   35,   83,   82,  290,
 /*  1840 */    83,  292,   82,  285,  106,  106,   22,  106,  290,   94,
 /*  1850 */   292,   35,   43,   22,   60,   82,   59,  249,   82,   82,
 /*  1860 */    35,   80,   43,   35,   65,   35,  249,  318,   35,   35,
 /*  1870 */   321,  322,  323,  324,  325,  326,  318,  328,   35,  321,
 /*  1880 */   322,  323,  324,  325,  326,  277,  328,   22,   35,   35,
 /*  1890 */    35,   65,   35,  285,  277,   35,   35,   35,  290,   35,
 /*  1900 */   292,   35,  285,    0,   35,   47,   39,  290,    0,  292,
 /*  1910 */    35,   39,    0,   35,    0,   47,   39,   47,  249,   35,
 /*  1920 */    47,   39,    0,   35,   35,    0,  318,  249,   22,  321,
 /*  1930 */   322,  323,  324,  325,  326,  318,  328,   21,  321,  322,
 /*  1940 */   323,  324,  325,  326,   21,  328,  277,  370,   22,   22,
 /*  1950 */    20,  370,  370,  370,  285,  277,  370,  370,  370,  290,
 /*  1960 */   370,  292,  370,  285,  370,  370,  370,  370,  290,  370,
 /*  1970 */   292,  370,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  1980 */   249,  370,  370,  370,  370,  370,  370,  318,  370,  249,
 /*  1990 */   321,  322,  323,  324,  325,  326,  318,  328,  249,  321,
 /*  2000 */   322,  323,  324,  325,  326,  370,  328,  249,  277,  370,
 /*  2010 */   257,  370,  370,  370,  370,  370,  285,  277,  370,  370,
 /*  2020 */   370,  290,  370,  292,  370,  285,  277,  370,  370,  370,
 /*  2030 */   290,  370,  292,  370,  285,  277,  370,  370,  285,  290,
 /*  2040 */   370,  292,  370,  285,  370,  370,  370,  370,  290,  318,
 /*  2050 */   292,  370,  321,  322,  323,  324,  325,  326,  318,  328,
 /*  2060 */   307,  321,  322,  323,  324,  325,  326,  318,  328,  370,
 /*  2070 */   321,  322,  323,  324,  325,  326,  318,  328,  325,  321,
 /*  2080 */   322,  323,  324,  325,  326,  249,  328,  370,  370,  370,
 /*  2090 */   370,  370,  370,  340,  341,  342,  370,  344,  370,  257,
 /*  2100 */   347,  370,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  2110 */   370,  370,  370,  277,  361,  370,  370,  370,  365,  370,
 /*  2120 */   370,  285,  370,  370,  370,  370,  290,  285,  292,  370,
 /*  2130 */   370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  2140 */   370,  370,  370,  370,  370,  370,  370,  370,  370,  307,
 /*  2150 */   370,  370,  370,  370,  318,  370,  370,  321,  322,  323,
 /*  2160 */   324,  325,  326,  370,  328,  370,  370,  325,  370,  370,
 /*  2170 */   370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  2180 */   370,  370,  340,  341,  342,  370,  344,  370,  370,  347,
 /*  2190 */   370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
 /*  2200 */   370,  370,  370,  361,  370,  370,  370,  365,
};
#define YY_SHIFT_COUNT    (652)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1930)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   769,    0,    0,   66,  322,  322,  322,  322,  266,  266,
 /*    10 */   322,  322,  460,  515,  581,  515,  515,  515,  515,  515,
 /*    20 */   515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
 /*    30 */   515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
 /*    40 */   515,  515,  292,  292,   18,   18,   18,  925,  925,  925,
 /*    50 */   925,  637,  291,   40,   51,   51,  356,  356,   54,   64,
 /*    60 */    40,   40,   51,   51,   51,   51,   51,   51,   51,   51,
 /*    70 */    33,   51,   51,   51,   85,  104,  265,   51,   51,  265,
 /*    80 */    51,  265,  265,  265,   51,  111,  189,  659,  674,  674,
 /*    90 */   128,  293,   63,   63,   63,   63,   63,   63,   63,   63,
 /*   100 */    63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
 /*   110 */    63,  301,   64,   67,   67,  739,  614,  341,  341,  341,
 /*   120 */   764,  614,  317,  104,    1,    1,  265,  265,  153,  153,
 /*   130 */   285,  370,  195,  195,  195,  195,  195,  195,  195,  704,
 /*   140 */    21,  427,  337,   47,  321,  435,  250,   12,   46,  548,
 /*   150 */   494,  511,  514,  483,  817,  483,  502,  502,  502,  790,
 /*   160 */   649,  844, 1049, 1026, 1044,  966, 1049, 1049, 1093,  995,
 /*   170 */   995, 1049, 1118, 1118, 1125,   33,  104,   33, 1149, 1157,
 /*   180 */    33, 1149,   33, 1163,   33,   33, 1049,   33, 1118,  265,
 /*   190 */   265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
 /*   200 */  1049, 1118,  153, 1125,  111, 1074,  104,  111, 1049, 1049,
 /*   210 */  1149,  111, 1232,  153, 1037, 1042,  153, 1037, 1042,  153,
 /*   220 */   153,  265, 1043, 1122, 1037, 1046, 1052, 1066,  844, 1072,
 /*   230 */   317, 1285, 1276, 1090, 1098, 1094, 1090, 1098, 1090, 1098,
 /*   240 */  1251, 1042,  153,  153,  153,  153,  153, 1042,  153, 1215,
 /*   250 */   317, 1163,  111,  285,  111,  317, 1301,  153,  370, 1049,
 /*   260 */   111, 1351, 1118, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
 /*   270 */   843, 1297,  217,  395,   81,  268,  543, 1003, 1012,  882,
 /*   280 */   713,  532,  532,  532,  532,  532,  532,  532,  532,  701,
 /*   290 */   970,  498,  198,  198,  375,  149,  316,  719,  307,   36,
 /*   300 */   615,  615,  615,  615,  648,  759,  855,  880,  876,  878,
 /*   310 */   892,  894,  622,  971,  985,  874,  841,  956, 1009,  993,
 /*   320 */   923,  146,  897, 1010,  872, 1017,  964, 1019, 1023, 1028,
 /*   330 */  1031, 1032,  915,  961, 1033, 1038, 1039, 1060, 1064, 1085,
 /*   340 */   921, 1096, 1089, 1405, 1407, 1366, 1409, 1337, 1414, 1377,
 /*   350 */  1234, 1381, 1382, 1384, 1239, 1421, 1387, 1390, 1253, 1445,
 /*   360 */  1266, 1448, 1416, 1453, 1433, 1457, 1423, 1459, 1379, 1294,
 /*   370 */  1296, 1299, 1303, 1468, 1470, 1312, 1315, 1474, 1475, 1431,
 /*   380 */  1478, 1480, 1481, 1341, 1484, 1491, 1495, 1502, 1505, 1369,
 /*   390 */  1472, 1508, 1372, 1510, 1511, 1513, 1514, 1515, 1516, 1518,
 /*   400 */  1520, 1521, 1522, 1523, 1524, 1525, 1526, 1485, 1528, 1530,
 /*   410 */  1532, 1533, 1534, 1535, 1517, 1536, 1537, 1540, 1541, 1542,
 /*   420 */  1543, 1504, 1519, 1501, 1545, 1527, 1546, 1531, 1554, 1529,
 /*   430 */  1539, 1556, 1561, 1562, 1547, 1410, 1563, 1567, 1568, 1565,
 /*   440 */  1571, 1576, 1550, 1544, 1548, 1580, 1557, 1553, 1555, 1582,
 /*   450 */  1560, 1581, 1570, 1584, 1583, 1585, 1591, 1589, 1593, 1596,
 /*   460 */  1597, 1538, 1559, 1598, 1609, 1634, 1601, 1602, 1603, 1604,
 /*   470 */  1600, 1606, 1610, 1611, 1612, 1644, 1628, 1651, 1630, 1605,
 /*   480 */  1653, 1633, 1621, 1657, 1623, 1659, 1625, 1662, 1641, 1645,
 /*   490 */  1664, 1551, 1631, 1667, 1512, 1648, 1572, 1552, 1679, 1680,
 /*   500 */  1573, 1569, 1685, 1686, 1687, 1647, 1649, 1469, 1613, 1615,
 /*   510 */  1614, 1620, 1650, 1622, 1618, 1624, 1626, 1629, 1666, 1661,
 /*   520 */  1681, 1643, 1688, 1509, 1646, 1658, 1696, 1564, 1689, 1697,
 /*   530 */  1663, 1701, 1566, 1668, 1656, 1710, 1712, 1714, 1715, 1718,
 /*   540 */  1668, 1692, 1574, 1711, 1682, 1684, 1690, 1717, 1699, 1704,
 /*   550 */  1722, 1742, 1590, 1705, 1691, 1695, 1706, 1769, 1708, 1635,
 /*   560 */  1713, 1770, 1732, 1654, 1719, 1700, 1726, 1747, 1720, 1716,
 /*   570 */  1721, 1772, 1723, 1703, 1727, 1762, 1771, 1737, 1745, 1774,
 /*   580 */  1748, 1746, 1796, 1750, 1754, 1798, 1756, 1757, 1801, 1760,
 /*   590 */  1698, 1738, 1739, 1741, 1824, 1755, 1773, 1776, 1816, 1777,
 /*   600 */  1809, 1809, 1831, 1794, 1797, 1825, 1799, 1781, 1819, 1828,
 /*   610 */  1830, 1833, 1834, 1843, 1865, 1853, 1854, 1826, 1600, 1855,
 /*   620 */  1606, 1857, 1860, 1861, 1862, 1864, 1866, 1903, 1869, 1858,
 /*   630 */  1867, 1908, 1875, 1868, 1872, 1912, 1878, 1870, 1877, 1914,
 /*   640 */  1884, 1873, 1882, 1922, 1888, 1889, 1925, 1906, 1916, 1926,
 /*   650 */  1927, 1923, 1930,
};
#define YY_REDUCE_COUNT (269)
#define YY_REDUCE_MIN   (-338)
#define YY_REDUCE_MAX   (1842)
static const short yy_reduce_ofst[] = {
 /*     0 */  -235, -215,   87,  651,  712,  513,  773,  828,  881,  890,
 /*    10 */   908,  973, -150,  989,  998,  314, 1051, 1105, 1114, 1164,
 /*    20 */  1175, 1227, 1280, 1289, 1298, 1350, 1392, 1412, 1434, 1490,
 /*    30 */  1499, 1549, 1558, 1608, 1617, 1669, 1678, 1731, 1740, 1749,
 /*    40 */  1758, 1836, 1753, 1842, -119,  241,  246, -274, -254, -261,
 /*    50 */    79, -292, -224,  143, -124,  108, -253, -249, -338, -251,
 /*    60 */  -218,   55, -123,  -33,  162,  164,  226,  275,  304,  339,
 /*    70 */  -244,  360,  408,  409, -209,  133,  200,  413,  463,  459,
 /*    80 */   481,  298,  470,  455,  545,  165, -233,    7,    7,    7,
 /*    90 */  -217, -252,  -63,  154,  194,  287,  320,  351,  353,  496,
 /*   100 */   518,  521,  542,  571,  597,  598,  609,  611,  644,  654,
 /*   110 */   678, -174,  238,  221,  308, -144,  357, -111,  490,  589,
 /*   120 */   595,  428,  399,  497,  271,  523,  507,  552,  652,  658,
 /*   130 */   686,   22, -259,  177,  426,  452,  457,  534,  579,   71,
 /*   140 */   156,  233,  227,  533,  699,  684,  612,  724,  724,  765,
 /*   150 */   788,  756,  731,  709,  709,  709,  693,  694,  695,  720,
 /*   160 */   724,  751,  815,  763,  854,  820,  875,  877,  839,  846,
 /*   170 */   847,  887,  904,  909,  835,  901,  884,  911,  864,  870,
 /*   180 */   918,  883,  920,  886,  926,  929,  934,  931,  935,  917,
 /*   190 */   919,  924,  933,  940,  942,  943,  944,  946,  947,  948,
 /*   200 */   938,  976,  945,  927,  982,  936,  957,  994,  997,  999,
 /*   210 */   951, 1000,  941,  972,  914,  967,  979,  932,  969,  981,
 /*   220 */   983,  724,  922,  937,  949,  928,  952,  939,  977,  709,
 /*   230 */  1002,  987, 1001,  963,  974,  978,  984,  975,  996, 1004,
 /*   240 */  1006, 1034, 1055, 1056, 1067, 1068, 1069, 1041, 1071, 1065,
 /*   250 */  1080, 1070, 1107, 1097, 1112, 1095, 1103, 1099, 1119, 1128,
 /*   260 */  1129, 1140, 1142, 1084, 1091, 1127, 1130, 1131, 1143, 1153,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    10 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    20 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    30 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    40 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    50 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    60 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    70 */  1496, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*    80 */  1424, 1424, 1424, 1424, 1424, 1494, 1647, 1424, 1816, 1424,
 /*    90 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   100 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   110 */  1424, 1424, 1424, 1424, 1424, 1496, 1424, 1828, 1828, 1828,
 /*   120 */  1494, 1424, 1424, 1424, 1691, 1691, 1424, 1424, 1424, 1424,
 /*   130 */  1590, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1683,
 /*   140 */  1424, 1424, 1898, 1424, 1424, 1689, 1852, 1424, 1424, 1424,
 /*   150 */  1424, 1543, 1844, 1820, 1834, 1821, 1883, 1883, 1883, 1837,
 /*   160 */  1424, 1848, 1424, 1424, 1424, 1675, 1424, 1424, 1652, 1649,
 /*   170 */  1649, 1424, 1424, 1424, 1424, 1496, 1424, 1496, 1424, 1424,
 /*   180 */  1496, 1424, 1496, 1424, 1496, 1496, 1424, 1496, 1424, 1424,
 /*   190 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   200 */  1424, 1424, 1424, 1424, 1494, 1685, 1424, 1494, 1424, 1424,
 /*   210 */  1424, 1494, 1424, 1424, 1859, 1857, 1424, 1859, 1857, 1424,
 /*   220 */  1424, 1424, 1871, 1867, 1859, 1875, 1873, 1850, 1848, 1834,
 /*   230 */  1424, 1424, 1818, 1889, 1885, 1901, 1889, 1885, 1889, 1885,
 /*   240 */  1424, 1857, 1424, 1424, 1424, 1424, 1424, 1857, 1424, 1424,
 /*   250 */  1424, 1424, 1494, 1424, 1494, 1424, 1559, 1424, 1424, 1424,
 /*   260 */  1494, 1456, 1424, 1677, 1691, 1593, 1593, 1593, 1497, 1429,
 /*   270 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   280 */  1424, 1760, 1870, 1869, 1792, 1791, 1790, 1788, 1759, 1424,
 /*   290 */  1424, 1555, 1758, 1757, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   300 */  1751, 1752, 1750, 1749, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   310 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1817,
 /*   320 */  1424, 1886, 1890, 1424, 1424, 1424, 1734, 1424, 1424, 1424,
 /*   330 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   340 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   350 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   360 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   370 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   380 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   390 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   400 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   410 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   420 */  1424, 1424, 1424, 1461, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   430 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   440 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   450 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   460 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   470 */  1524, 1523, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   480 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   490 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   500 */  1424, 1424, 1424, 1424, 1424, 1841, 1851, 1424, 1424, 1424,
 /*   510 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   520 */  1734, 1424, 1868, 1424, 1827, 1823, 1424, 1424, 1819, 1424,
 /*   530 */  1424, 1884, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   540 */  1424, 1812, 1424, 1785, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   550 */  1424, 1424, 1745, 1424, 1424, 1424, 1424, 1695, 1424, 1424,
 /*   560 */  1424, 1424, 1424, 1424, 1424, 1424, 1733, 1424, 1776, 1424,
 /*   570 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1587, 1424, 1424,
 /*   580 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   590 */  1572, 1570, 1569, 1568, 1424, 1565, 1424, 1424, 1424, 1424,
 /*   600 */  1596, 1595, 1424, 1424, 1424, 1424, 1424, 1424, 1516, 1424,
 /*   610 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1507, 1424,
 /*   620 */  1506, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   630 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   640 */  1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424, 1424,
 /*   650 */  1424, 1424, 1424,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  239,  /*  NK_BITNOT => ID */
  239,  /*     INSERT => ID */
  239,  /*     VALUES => ID */
  239,  /*     IMPORT => ID */
  239,  /*    NK_SEMI => ID */
  239,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "IF",
  /*   59 */ "NOT",
  /*   60 */ "EXISTS",
  /*   61 */ "BUFFER",
  /*   62 */ "CACHELAST",
  /*   63 */ "COMP",
  /*   64 */ "DURATION",
  /*   65 */ "NK_VARIABLE",
  /*   66 */ "FSYNC",
  /*   67 */ "MAXROWS",
  /*   68 */ "MINROWS",
  /*   69 */ "KEEP",
  /*   70 */ "PAGES",
  /*   71 */ "PAGESIZE",
  /*   72 */ "PRECISION",
  /*   73 */ "REPLICA",
  /*   74 */ "STRICT",
  /*   75 */ "WAL",
  /*   76 */ "VGROUPS",
  /*   77 */ "SINGLE_STABLE",
  /*   78 */ "RETENTIONS",
  /*   79 */ "SCHEMALESS",
  /*   80 */ "NK_COLON",
  /*   81 */ "TABLE",
  /*   82 */ "NK_LP",
  /*   83 */ "NK_RP",
  /*   84 */ "STABLE",
  /*   85 */ "ADD",
  /*   86 */ "COLUMN",
  /*   87 */ "MODIFY",
  /*   88 */ "RENAME",
  /*   89 */ "TAG",
  /*   90 */ "SET",
  /*   91 */ "NK_EQ",
  /*   92 */ "USING",
  /*   93 */ "TAGS",
  /*   94 */ "COMMENT",
  /*   95 */ "BOOL",
  /*   96 */ "TINYINT",
  /*   97 */ "SMALLINT",
  /*   98 */ "INT",
  /*   99 */ "INTEGER",
  /*  100 */ "BIGINT",
  /*  101 */ "FLOAT",
  /*  102 */ "DOUBLE",
  /*  103 */ "BINARY",
  /*  104 */ "TIMESTAMP",
  /*  105 */ "NCHAR",
  /*  106 */ "UNSIGNED",
  /*  107 */ "JSON",
  /*  108 */ "VARCHAR",
  /*  109 */ "MEDIUMBLOB",
  /*  110 */ "BLOB",
  /*  111 */ "VARBINARY",
  /*  112 */ "DECIMAL",
  /*  113 */ "MAX_DELAY",
  /*  114 */ "WATERMARK",
  /*  115 */ "ROLLUP",
  /*  116 */ "TTL",
  /*  117 */ "SMA",
  /*  118 */ "FIRST",
  /*  119 */ "LAST",
  /*  120 */ "SHOW",
  /*  121 */ "DATABASES",
  /*  122 */ "TABLES",
  /*  123 */ "STABLES",
  /*  124 */ "MNODES",
  /*  125 */ "MODULES",
  /*  126 */ "QNODES",
  /*  127 */ "FUNCTIONS",
  /*  128 */ "INDEXES",
  /*  129 */ "ACCOUNTS",
  /*  130 */ "APPS",
  /*  131 */ "CONNECTIONS",
  /*  132 */ "LICENCE",
  /*  133 */ "GRANTS",
  /*  134 */ "QUERIES",
  /*  135 */ "SCORES",
  /*  136 */ "TOPICS",
  /*  137 */ "VARIABLES",
  /*  138 */ "BNODES",
  /*  139 */ "SNODES",
  /*  140 */ "CLUSTER",
  /*  141 */ "TRANSACTIONS",
  /*  142 */ "DISTRIBUTED",
  /*  143 */ "CONSUMERS",
  /*  144 */ "SUBSCRIPTIONS",
  /*  145 */ "LIKE",
  /*  146 */ "INDEX",
  /*  147 */ "FUNCTION",
  /*  148 */ "INTERVAL",
  /*  149 */ "TOPIC",
  /*  150 */ "AS",
  /*  151 */ "WITH",
  /*  152 */ "META",
  /*  153 */ "CONSUMER",
  /*  154 */ "GROUP",
  /*  155 */ "DESC",
  /*  156 */ "DESCRIBE",
  /*  157 */ "RESET",
  /*  158 */ "QUERY",
  /*  159 */ "CACHE",
  /*  160 */ "EXPLAIN",
  /*  161 */ "ANALYZE",
  /*  162 */ "VERBOSE",
  /*  163 */ "NK_BOOL",
  /*  164 */ "RATIO",
  /*  165 */ "NK_FLOAT",
  /*  166 */ "COMPACT",
  /*  167 */ "VNODES",
  /*  168 */ "IN",
  /*  169 */ "OUTPUTTYPE",
  /*  170 */ "AGGREGATE",
  /*  171 */ "BUFSIZE",
  /*  172 */ "STREAM",
  /*  173 */ "INTO",
  /*  174 */ "TRIGGER",
  /*  175 */ "AT_ONCE",
  /*  176 */ "WINDOW_CLOSE",
  /*  177 */ "KILL",
  /*  178 */ "CONNECTION",
  /*  179 */ "TRANSACTION",
  /*  180 */ "BALANCE",
  /*  181 */ "VGROUP",
  /*  182 */ "MERGE",
  /*  183 */ "REDISTRIBUTE",
  /*  184 */ "SPLIT",
  /*  185 */ "SYNCDB",
  /*  186 */ "DELETE",
  /*  187 */ "NULL",
  /*  188 */ "NK_QUESTION",
  /*  189 */ "NK_ARROW",
  /*  190 */ "ROWTS",
  /*  191 */ "TBNAME",
  /*  192 */ "QSTARTTS",
  /*  193 */ "QENDTS",
  /*  194 */ "WSTARTTS",
  /*  195 */ "WENDTS",
  /*  196 */ "WDURATION",
  /*  197 */ "CAST",
  /*  198 */ "NOW",
  /*  199 */ "TODAY",
  /*  200 */ "TIMEZONE",
  /*  201 */ "COUNT",
  /*  202 */ "LAST_ROW",
  /*  203 */ "BETWEEN",
  /*  204 */ "IS",
  /*  205 */ "NK_LT",
  /*  206 */ "NK_GT",
  /*  207 */ "NK_LE",
  /*  208 */ "NK_GE",
  /*  209 */ "NK_NE",
  /*  210 */ "MATCH",
  /*  211 */ "NMATCH",
  /*  212 */ "CONTAINS",
  /*  213 */ "JOIN",
  /*  214 */ "INNER",
  /*  215 */ "SELECT",
  /*  216 */ "DISTINCT",
  /*  217 */ "WHERE",
  /*  218 */ "PARTITION",
  /*  219 */ "BY",
  /*  220 */ "SESSION",
  /*  221 */ "STATE_WINDOW",
  /*  222 */ "SLIDING",
  /*  223 */ "FILL",
  /*  224 */ "VALUE",
  /*  225 */ "NONE",
  /*  226 */ "PREV",
  /*  227 */ "LINEAR",
  /*  228 */ "NEXT",
  /*  229 */ "HAVING",
  /*  230 */ "RANGE",
  /*  231 */ "EVERY",
  /*  232 */ "ORDER",
  /*  233 */ "SLIMIT",
  /*  234 */ "SOFFSET",
  /*  235 */ "LIMIT",
  /*  236 */ "OFFSET",
  /*  237 */ "ASC",
  /*  238 */ "NULLS",
  /*  239 */ "ID",
  /*  240 */ "NK_BITNOT",
  /*  241 */ "INSERT",
  /*  242 */ "VALUES",
  /*  243 */ "IMPORT",
  /*  244 */ "NK_SEMI",
  /*  245 */ "FILE",
  /*  246 */ "cmd",
  /*  247 */ "account_options",
  /*  248 */ "alter_account_options",
  /*  249 */ "literal",
  /*  250 */ "alter_account_option",
  /*  251 */ "user_name",
  /*  252 */ "sysinfo_opt",
  /*  253 */ "privileges",
  /*  254 */ "priv_level",
  /*  255 */ "priv_type_list",
  /*  256 */ "priv_type",
  /*  257 */ "db_name",
  /*  258 */ "dnode_endpoint",
  /*  259 */ "not_exists_opt",
  /*  260 */ "db_options",
  /*  261 */ "exists_opt",
  /*  262 */ "alter_db_options",
  /*  263 */ "integer_list",
  /*  264 */ "variable_list",
  /*  265 */ "retention_list",
  /*  266 */ "alter_db_option",
  /*  267 */ "retention",
  /*  268 */ "full_table_name",
  /*  269 */ "column_def_list",
  /*  270 */ "tags_def_opt",
  /*  271 */ "table_options",
  /*  272 */ "multi_create_clause",
  /*  273 */ "tags_def",
  /*  274 */ "multi_drop_clause",
  /*  275 */ "alter_table_clause",
  /*  276 */ "alter_table_options",
  /*  277 */ "column_name",
  /*  278 */ "type_name",
  /*  279 */ "signed_literal",
  /*  280 */ "create_subtable_clause",
  /*  281 */ "specific_tags_opt",
  /*  282 */ "literal_list",
  /*  283 */ "drop_table_clause",
  /*  284 */ "col_name_list",
  /*  285 */ "table_name",
  /*  286 */ "column_def",
  /*  287 */ "duration_list",
  /*  288 */ "rollup_func_list",
  /*  289 */ "alter_table_option",
  /*  290 */ "duration_literal",
  /*  291 */ "rollup_func_name",
  /*  292 */ "function_name",
  /*  293 */ "col_name",
  /*  294 */ "db_name_cond_opt",
  /*  295 */ "like_pattern_opt",
  /*  296 */ "table_name_cond",
  /*  297 */ "from_db_opt",
  /*  298 */ "index_name",
  /*  299 */ "index_options",
  /*  300 */ "func_list",
  /*  301 */ "sliding_opt",
  /*  302 */ "sma_stream_opt",
  /*  303 */ "func",
  /*  304 */ "expression_list",
  /*  305 */ "stream_options",
  /*  306 */ "topic_name",
  /*  307 */ "query_expression",
  /*  308 */ "cgroup_name",
  /*  309 */ "analyze_opt",
  /*  310 */ "explain_options",
  /*  311 */ "agg_func_opt",
  /*  312 */ "bufsize_opt",
  /*  313 */ "stream_name",
  /*  314 */ "into_opt",
  /*  315 */ "dnode_list",
  /*  316 */ "where_clause_opt",
  /*  317 */ "signed",
  /*  318 */ "literal_func",
  /*  319 */ "table_alias",
  /*  320 */ "column_alias",
  /*  321 */ "expression",
  /*  322 */ "pseudo_column",
  /*  323 */ "column_reference",
  /*  324 */ "function_expression",
  /*  325 */ "subquery",
  /*  326 */ "star_func",
  /*  327 */ "star_func_para_list",
  /*  328 */ "noarg_func",
  /*  329 */ "other_para_list",
  /*  330 */ "star_func_para",
  /*  331 */ "predicate",
  /*  332 */ "compare_op",
  /*  333 */ "in_op",
  /*  334 */ "in_predicate_value",
  /*  335 */ "boolean_value_expression",
  /*  336 */ "boolean_primary",
  /*  337 */ "common_expression",
  /*  338 */ "from_clause_opt",
  /*  339 */ "table_reference_list",
  /*  340 */ "table_reference",
  /*  341 */ "table_primary",
  /*  342 */ "joined_table",
  /*  343 */ "alias_opt",
  /*  344 */ "parenthesized_joined_table",
  /*  345 */ "join_type",
  /*  346 */ "search_condition",
  /*  347 */ "query_specification",
  /*  348 */ "set_quantifier_opt",
  /*  349 */ "select_list",
  /*  350 */ "partition_by_clause_opt",
  /*  351 */ "range_opt",
  /*  352 */ "every_opt",
  /*  353 */ "fill_opt",
  /*  354 */ "twindow_clause_opt",
  /*  355 */ "group_by_clause_opt",
  /*  356 */ "having_clause_opt",
  /*  357 */ "select_sublist",
  /*  358 */ "select_item",
  /*  359 */ "fill_mode",
  /*  360 */ "group_by_list",
  /*  361 */ "query_expression_body",
  /*  362 */ "order_by_clause_opt",
  /*  363 */ "slimit_clause_opt",
  /*  364 */ "limit_clause_opt",
  /*  365 */ "query_primary",
  /*  366 */ "sort_specification_list",
  /*  367 */ "sort_specification",
  /*  368 */ "ordering_specification_opt",
  /*  369 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  67 */ "not_exists_opt ::=",
 /*  68 */ "exists_opt ::= IF EXISTS",
 /*  69 */ "exists_opt ::=",
 /*  70 */ "db_options ::=",
 /*  71 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  72 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  73 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  74 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  75 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  76 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  77 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  78 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  79 */ "db_options ::= db_options KEEP integer_list",
 /*  80 */ "db_options ::= db_options KEEP variable_list",
 /*  81 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  82 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  83 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  84 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  85 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  86 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  87 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  88 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  89 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  90 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  91 */ "alter_db_options ::= alter_db_option",
 /*  92 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  93 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  94 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  95 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  96 */ "alter_db_option ::= KEEP integer_list",
 /*  97 */ "alter_db_option ::= KEEP variable_list",
 /*  98 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  99 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 100 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 101 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 102 */ "integer_list ::= NK_INTEGER",
 /* 103 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 104 */ "variable_list ::= NK_VARIABLE",
 /* 105 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 106 */ "retention_list ::= retention",
 /* 107 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 108 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 109 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 110 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 111 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 112 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 113 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 114 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 115 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 116 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 117 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 118 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 119 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 120 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 121 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 122 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 123 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 125 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 126 */ "multi_create_clause ::= create_subtable_clause",
 /* 127 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 128 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 129 */ "multi_drop_clause ::= drop_table_clause",
 /* 130 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 131 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 132 */ "specific_tags_opt ::=",
 /* 133 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 134 */ "full_table_name ::= table_name",
 /* 135 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 136 */ "column_def_list ::= column_def",
 /* 137 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 138 */ "column_def ::= column_name type_name",
 /* 139 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 140 */ "type_name ::= BOOL",
 /* 141 */ "type_name ::= TINYINT",
 /* 142 */ "type_name ::= SMALLINT",
 /* 143 */ "type_name ::= INT",
 /* 144 */ "type_name ::= INTEGER",
 /* 145 */ "type_name ::= BIGINT",
 /* 146 */ "type_name ::= FLOAT",
 /* 147 */ "type_name ::= DOUBLE",
 /* 148 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 149 */ "type_name ::= TIMESTAMP",
 /* 150 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 151 */ "type_name ::= TINYINT UNSIGNED",
 /* 152 */ "type_name ::= SMALLINT UNSIGNED",
 /* 153 */ "type_name ::= INT UNSIGNED",
 /* 154 */ "type_name ::= BIGINT UNSIGNED",
 /* 155 */ "type_name ::= JSON",
 /* 156 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= MEDIUMBLOB",
 /* 158 */ "type_name ::= BLOB",
 /* 159 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= DECIMAL",
 /* 161 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 163 */ "tags_def_opt ::=",
 /* 164 */ "tags_def_opt ::= tags_def",
 /* 165 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 166 */ "table_options ::=",
 /* 167 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 168 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 169 */ "table_options ::= table_options WATERMARK duration_list",
 /* 170 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 171 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 172 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 173 */ "alter_table_options ::= alter_table_option",
 /* 174 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 175 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 176 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 177 */ "duration_list ::= duration_literal",
 /* 178 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 179 */ "rollup_func_list ::= rollup_func_name",
 /* 180 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 181 */ "rollup_func_name ::= function_name",
 /* 182 */ "rollup_func_name ::= FIRST",
 /* 183 */ "rollup_func_name ::= LAST",
 /* 184 */ "col_name_list ::= col_name",
 /* 185 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 186 */ "col_name ::= column_name",
 /* 187 */ "cmd ::= SHOW DNODES",
 /* 188 */ "cmd ::= SHOW USERS",
 /* 189 */ "cmd ::= SHOW DATABASES",
 /* 190 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 193 */ "cmd ::= SHOW MNODES",
 /* 194 */ "cmd ::= SHOW MODULES",
 /* 195 */ "cmd ::= SHOW QNODES",
 /* 196 */ "cmd ::= SHOW FUNCTIONS",
 /* 197 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 198 */ "cmd ::= SHOW STREAMS",
 /* 199 */ "cmd ::= SHOW ACCOUNTS",
 /* 200 */ "cmd ::= SHOW APPS",
 /* 201 */ "cmd ::= SHOW CONNECTIONS",
 /* 202 */ "cmd ::= SHOW LICENCE",
 /* 203 */ "cmd ::= SHOW GRANTS",
 /* 204 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 205 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 206 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 207 */ "cmd ::= SHOW QUERIES",
 /* 208 */ "cmd ::= SHOW SCORES",
 /* 209 */ "cmd ::= SHOW TOPICS",
 /* 210 */ "cmd ::= SHOW VARIABLES",
 /* 211 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 212 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 213 */ "cmd ::= SHOW BNODES",
 /* 214 */ "cmd ::= SHOW SNODES",
 /* 215 */ "cmd ::= SHOW CLUSTER",
 /* 216 */ "cmd ::= SHOW TRANSACTIONS",
 /* 217 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 218 */ "cmd ::= SHOW CONSUMERS",
 /* 219 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 220 */ "db_name_cond_opt ::=",
 /* 221 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 222 */ "like_pattern_opt ::=",
 /* 223 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 224 */ "table_name_cond ::= table_name",
 /* 225 */ "from_db_opt ::=",
 /* 226 */ "from_db_opt ::= FROM db_name",
 /* 227 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 228 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 229 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 230 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 231 */ "func_list ::= func",
 /* 232 */ "func_list ::= func_list NK_COMMA func",
 /* 233 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 234 */ "sma_stream_opt ::=",
 /* 235 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 236 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 237 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 238 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 239 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 242 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 243 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 244 */ "cmd ::= DESC full_table_name",
 /* 245 */ "cmd ::= DESCRIBE full_table_name",
 /* 246 */ "cmd ::= RESET QUERY CACHE",
 /* 247 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 248 */ "analyze_opt ::=",
 /* 249 */ "analyze_opt ::= ANALYZE",
 /* 250 */ "explain_options ::=",
 /* 251 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 252 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 253 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 254 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 255 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 256 */ "agg_func_opt ::=",
 /* 257 */ "agg_func_opt ::= AGGREGATE",
 /* 258 */ "bufsize_opt ::=",
 /* 259 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 260 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 261 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 262 */ "into_opt ::=",
 /* 263 */ "into_opt ::= INTO full_table_name",
 /* 264 */ "stream_options ::=",
 /* 265 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 266 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 267 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 268 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 269 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 270 */ "cmd ::= KILL QUERY NK_STRING",
 /* 271 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 272 */ "cmd ::= BALANCE VGROUP",
 /* 273 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 274 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 275 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 276 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 277 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 278 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 279 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 280 */ "cmd ::= query_expression",
 /* 281 */ "literal ::= NK_INTEGER",
 /* 282 */ "literal ::= NK_FLOAT",
 /* 283 */ "literal ::= NK_STRING",
 /* 284 */ "literal ::= NK_BOOL",
 /* 285 */ "literal ::= TIMESTAMP NK_STRING",
 /* 286 */ "literal ::= duration_literal",
 /* 287 */ "literal ::= NULL",
 /* 288 */ "literal ::= NK_QUESTION",
 /* 289 */ "duration_literal ::= NK_VARIABLE",
 /* 290 */ "signed ::= NK_INTEGER",
 /* 291 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 292 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 293 */ "signed ::= NK_FLOAT",
 /* 294 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 295 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 296 */ "signed_literal ::= signed",
 /* 297 */ "signed_literal ::= NK_STRING",
 /* 298 */ "signed_literal ::= NK_BOOL",
 /* 299 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 300 */ "signed_literal ::= duration_literal",
 /* 301 */ "signed_literal ::= NULL",
 /* 302 */ "signed_literal ::= literal_func",
 /* 303 */ "literal_list ::= signed_literal",
 /* 304 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 305 */ "db_name ::= NK_ID",
 /* 306 */ "table_name ::= NK_ID",
 /* 307 */ "column_name ::= NK_ID",
 /* 308 */ "function_name ::= NK_ID",
 /* 309 */ "table_alias ::= NK_ID",
 /* 310 */ "column_alias ::= NK_ID",
 /* 311 */ "user_name ::= NK_ID",
 /* 312 */ "index_name ::= NK_ID",
 /* 313 */ "topic_name ::= NK_ID",
 /* 314 */ "stream_name ::= NK_ID",
 /* 315 */ "cgroup_name ::= NK_ID",
 /* 316 */ "expression ::= literal",
 /* 317 */ "expression ::= pseudo_column",
 /* 318 */ "expression ::= column_reference",
 /* 319 */ "expression ::= function_expression",
 /* 320 */ "expression ::= subquery",
 /* 321 */ "expression ::= NK_LP expression NK_RP",
 /* 322 */ "expression ::= NK_PLUS expression",
 /* 323 */ "expression ::= NK_MINUS expression",
 /* 324 */ "expression ::= expression NK_PLUS expression",
 /* 325 */ "expression ::= expression NK_MINUS expression",
 /* 326 */ "expression ::= expression NK_STAR expression",
 /* 327 */ "expression ::= expression NK_SLASH expression",
 /* 328 */ "expression ::= expression NK_REM expression",
 /* 329 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 330 */ "expression ::= expression NK_BITAND expression",
 /* 331 */ "expression ::= expression NK_BITOR expression",
 /* 332 */ "expression_list ::= expression",
 /* 333 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 334 */ "column_reference ::= column_name",
 /* 335 */ "column_reference ::= table_name NK_DOT column_name",
 /* 336 */ "pseudo_column ::= ROWTS",
 /* 337 */ "pseudo_column ::= TBNAME",
 /* 338 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 339 */ "pseudo_column ::= QSTARTTS",
 /* 340 */ "pseudo_column ::= QENDTS",
 /* 341 */ "pseudo_column ::= WSTARTTS",
 /* 342 */ "pseudo_column ::= WENDTS",
 /* 343 */ "pseudo_column ::= WDURATION",
 /* 344 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 345 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 346 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 347 */ "function_expression ::= literal_func",
 /* 348 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 349 */ "literal_func ::= NOW",
 /* 350 */ "noarg_func ::= NOW",
 /* 351 */ "noarg_func ::= TODAY",
 /* 352 */ "noarg_func ::= TIMEZONE",
 /* 353 */ "star_func ::= COUNT",
 /* 354 */ "star_func ::= FIRST",
 /* 355 */ "star_func ::= LAST",
 /* 356 */ "star_func ::= LAST_ROW",
 /* 357 */ "star_func_para_list ::= NK_STAR",
 /* 358 */ "star_func_para_list ::= other_para_list",
 /* 359 */ "other_para_list ::= star_func_para",
 /* 360 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 361 */ "star_func_para ::= expression",
 /* 362 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 363 */ "predicate ::= expression compare_op expression",
 /* 364 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 365 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 366 */ "predicate ::= expression IS NULL",
 /* 367 */ "predicate ::= expression IS NOT NULL",
 /* 368 */ "predicate ::= expression in_op in_predicate_value",
 /* 369 */ "compare_op ::= NK_LT",
 /* 370 */ "compare_op ::= NK_GT",
 /* 371 */ "compare_op ::= NK_LE",
 /* 372 */ "compare_op ::= NK_GE",
 /* 373 */ "compare_op ::= NK_NE",
 /* 374 */ "compare_op ::= NK_EQ",
 /* 375 */ "compare_op ::= LIKE",
 /* 376 */ "compare_op ::= NOT LIKE",
 /* 377 */ "compare_op ::= MATCH",
 /* 378 */ "compare_op ::= NMATCH",
 /* 379 */ "compare_op ::= CONTAINS",
 /* 380 */ "in_op ::= IN",
 /* 381 */ "in_op ::= NOT IN",
 /* 382 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 383 */ "boolean_value_expression ::= boolean_primary",
 /* 384 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 385 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 386 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 387 */ "boolean_primary ::= predicate",
 /* 388 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 389 */ "common_expression ::= expression",
 /* 390 */ "common_expression ::= boolean_value_expression",
 /* 391 */ "from_clause_opt ::=",
 /* 392 */ "from_clause_opt ::= FROM table_reference_list",
 /* 393 */ "table_reference_list ::= table_reference",
 /* 394 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 395 */ "table_reference ::= table_primary",
 /* 396 */ "table_reference ::= joined_table",
 /* 397 */ "table_primary ::= table_name alias_opt",
 /* 398 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 399 */ "table_primary ::= subquery alias_opt",
 /* 400 */ "table_primary ::= parenthesized_joined_table",
 /* 401 */ "alias_opt ::=",
 /* 402 */ "alias_opt ::= table_alias",
 /* 403 */ "alias_opt ::= AS table_alias",
 /* 404 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 405 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 406 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 407 */ "join_type ::=",
 /* 408 */ "join_type ::= INNER",
 /* 409 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 410 */ "set_quantifier_opt ::=",
 /* 411 */ "set_quantifier_opt ::= DISTINCT",
 /* 412 */ "set_quantifier_opt ::= ALL",
 /* 413 */ "select_list ::= NK_STAR",
 /* 414 */ "select_list ::= select_sublist",
 /* 415 */ "select_sublist ::= select_item",
 /* 416 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 417 */ "select_item ::= common_expression",
 /* 418 */ "select_item ::= common_expression column_alias",
 /* 419 */ "select_item ::= common_expression AS column_alias",
 /* 420 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 421 */ "where_clause_opt ::=",
 /* 422 */ "where_clause_opt ::= WHERE search_condition",
 /* 423 */ "partition_by_clause_opt ::=",
 /* 424 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 425 */ "twindow_clause_opt ::=",
 /* 426 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 427 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 428 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 429 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 430 */ "sliding_opt ::=",
 /* 431 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 432 */ "fill_opt ::=",
 /* 433 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 434 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 435 */ "fill_mode ::= NONE",
 /* 436 */ "fill_mode ::= PREV",
 /* 437 */ "fill_mode ::= NULL",
 /* 438 */ "fill_mode ::= LINEAR",
 /* 439 */ "fill_mode ::= NEXT",
 /* 440 */ "group_by_clause_opt ::=",
 /* 441 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 442 */ "group_by_list ::= expression",
 /* 443 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 444 */ "having_clause_opt ::=",
 /* 445 */ "having_clause_opt ::= HAVING search_condition",
 /* 446 */ "range_opt ::=",
 /* 447 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 448 */ "every_opt ::=",
 /* 449 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 450 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 451 */ "query_expression_body ::= query_primary",
 /* 452 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 453 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 454 */ "query_primary ::= query_specification",
 /* 455 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 456 */ "order_by_clause_opt ::=",
 /* 457 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 458 */ "slimit_clause_opt ::=",
 /* 459 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 460 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 461 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 462 */ "limit_clause_opt ::=",
 /* 463 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 464 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 465 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 466 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 467 */ "search_condition ::= common_expression",
 /* 468 */ "sort_specification_list ::= sort_specification",
 /* 469 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 470 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 471 */ "ordering_specification_opt ::=",
 /* 472 */ "ordering_specification_opt ::= ASC",
 /* 473 */ "ordering_specification_opt ::= DESC",
 /* 474 */ "null_ordering_opt ::=",
 /* 475 */ "null_ordering_opt ::= NULLS FIRST",
 /* 476 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 246: /* cmd */
    case 249: /* literal */
    case 260: /* db_options */
    case 262: /* alter_db_options */
    case 267: /* retention */
    case 268: /* full_table_name */
    case 271: /* table_options */
    case 275: /* alter_table_clause */
    case 276: /* alter_table_options */
    case 279: /* signed_literal */
    case 280: /* create_subtable_clause */
    case 283: /* drop_table_clause */
    case 286: /* column_def */
    case 290: /* duration_literal */
    case 291: /* rollup_func_name */
    case 293: /* col_name */
    case 294: /* db_name_cond_opt */
    case 295: /* like_pattern_opt */
    case 296: /* table_name_cond */
    case 297: /* from_db_opt */
    case 299: /* index_options */
    case 301: /* sliding_opt */
    case 302: /* sma_stream_opt */
    case 303: /* func */
    case 305: /* stream_options */
    case 307: /* query_expression */
    case 310: /* explain_options */
    case 314: /* into_opt */
    case 316: /* where_clause_opt */
    case 317: /* signed */
    case 318: /* literal_func */
    case 321: /* expression */
    case 322: /* pseudo_column */
    case 323: /* column_reference */
    case 324: /* function_expression */
    case 325: /* subquery */
    case 330: /* star_func_para */
    case 331: /* predicate */
    case 334: /* in_predicate_value */
    case 335: /* boolean_value_expression */
    case 336: /* boolean_primary */
    case 337: /* common_expression */
    case 338: /* from_clause_opt */
    case 339: /* table_reference_list */
    case 340: /* table_reference */
    case 341: /* table_primary */
    case 342: /* joined_table */
    case 344: /* parenthesized_joined_table */
    case 346: /* search_condition */
    case 347: /* query_specification */
    case 351: /* range_opt */
    case 352: /* every_opt */
    case 353: /* fill_opt */
    case 354: /* twindow_clause_opt */
    case 356: /* having_clause_opt */
    case 358: /* select_item */
    case 361: /* query_expression_body */
    case 363: /* slimit_clause_opt */
    case 364: /* limit_clause_opt */
    case 365: /* query_primary */
    case 367: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy452)); 
}
      break;
    case 247: /* account_options */
    case 248: /* alter_account_options */
    case 250: /* alter_account_option */
    case 312: /* bufsize_opt */
{
 
}
      break;
    case 251: /* user_name */
    case 254: /* priv_level */
    case 257: /* db_name */
    case 258: /* dnode_endpoint */
    case 277: /* column_name */
    case 285: /* table_name */
    case 292: /* function_name */
    case 298: /* index_name */
    case 306: /* topic_name */
    case 308: /* cgroup_name */
    case 313: /* stream_name */
    case 319: /* table_alias */
    case 320: /* column_alias */
    case 326: /* star_func */
    case 328: /* noarg_func */
    case 343: /* alias_opt */
{
 
}
      break;
    case 252: /* sysinfo_opt */
{
 
}
      break;
    case 253: /* privileges */
    case 255: /* priv_type_list */
    case 256: /* priv_type */
{
 
}
      break;
    case 259: /* not_exists_opt */
    case 261: /* exists_opt */
    case 309: /* analyze_opt */
    case 311: /* agg_func_opt */
    case 348: /* set_quantifier_opt */
{
 
}
      break;
    case 263: /* integer_list */
    case 264: /* variable_list */
    case 265: /* retention_list */
    case 269: /* column_def_list */
    case 270: /* tags_def_opt */
    case 272: /* multi_create_clause */
    case 273: /* tags_def */
    case 274: /* multi_drop_clause */
    case 281: /* specific_tags_opt */
    case 282: /* literal_list */
    case 284: /* col_name_list */
    case 287: /* duration_list */
    case 288: /* rollup_func_list */
    case 300: /* func_list */
    case 304: /* expression_list */
    case 315: /* dnode_list */
    case 327: /* star_func_para_list */
    case 329: /* other_para_list */
    case 349: /* select_list */
    case 350: /* partition_by_clause_opt */
    case 355: /* group_by_clause_opt */
    case 357: /* select_sublist */
    case 360: /* group_by_list */
    case 362: /* order_by_clause_opt */
    case 366: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy404)); 
}
      break;
    case 266: /* alter_db_option */
    case 289: /* alter_table_option */
{
 
}
      break;
    case 278: /* type_name */
{
 
}
      break;
    case 332: /* compare_op */
    case 333: /* in_op */
{
 
}
      break;
    case 345: /* join_type */
{
 
}
      break;
    case 359: /* fill_mode */
{
 
}
      break;
    case 368: /* ordering_specification_opt */
{
 
}
      break;
    case 369: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  246,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  246,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  247,    0 }, /* (2) account_options ::= */
  {  247,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  247,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  247,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  247,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  247,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  247,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  247,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  247,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  247,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  248,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  248,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  250,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  250,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  250,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  250,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  250,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  250,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  250,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  250,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  250,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  250,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  246,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  246,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  246,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  246,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  246,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  252,    0 }, /* (29) sysinfo_opt ::= */
  {  252,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  246,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  246,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  253,   -1 }, /* (33) privileges ::= ALL */
  {  253,   -1 }, /* (34) privileges ::= priv_type_list */
  {  255,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  255,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  256,   -1 }, /* (37) priv_type ::= READ */
  {  256,   -1 }, /* (38) priv_type ::= WRITE */
  {  254,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  254,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  246,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  246,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  246,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  246,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  246,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  246,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  246,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  246,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  258,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  258,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  258,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  246,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  246,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  246,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  246,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  246,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  246,   -2 }, /* (64) cmd ::= USE db_name */
  {  246,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  259,   -3 }, /* (66) not_exists_opt ::= IF NOT EXISTS */
  {  259,    0 }, /* (67) not_exists_opt ::= */
  {  261,   -2 }, /* (68) exists_opt ::= IF EXISTS */
  {  261,    0 }, /* (69) exists_opt ::= */
  {  260,    0 }, /* (70) db_options ::= */
  {  260,   -3 }, /* (71) db_options ::= db_options BUFFER NK_INTEGER */
  {  260,   -3 }, /* (72) db_options ::= db_options CACHELAST NK_INTEGER */
  {  260,   -3 }, /* (73) db_options ::= db_options COMP NK_INTEGER */
  {  260,   -3 }, /* (74) db_options ::= db_options DURATION NK_INTEGER */
  {  260,   -3 }, /* (75) db_options ::= db_options DURATION NK_VARIABLE */
  {  260,   -3 }, /* (76) db_options ::= db_options FSYNC NK_INTEGER */
  {  260,   -3 }, /* (77) db_options ::= db_options MAXROWS NK_INTEGER */
  {  260,   -3 }, /* (78) db_options ::= db_options MINROWS NK_INTEGER */
  {  260,   -3 }, /* (79) db_options ::= db_options KEEP integer_list */
  {  260,   -3 }, /* (80) db_options ::= db_options KEEP variable_list */
  {  260,   -3 }, /* (81) db_options ::= db_options PAGES NK_INTEGER */
  {  260,   -3 }, /* (82) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  260,   -3 }, /* (83) db_options ::= db_options PRECISION NK_STRING */
  {  260,   -3 }, /* (84) db_options ::= db_options REPLICA NK_INTEGER */
  {  260,   -3 }, /* (85) db_options ::= db_options STRICT NK_INTEGER */
  {  260,   -3 }, /* (86) db_options ::= db_options WAL NK_INTEGER */
  {  260,   -3 }, /* (87) db_options ::= db_options VGROUPS NK_INTEGER */
  {  260,   -3 }, /* (88) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  260,   -3 }, /* (89) db_options ::= db_options RETENTIONS retention_list */
  {  260,   -3 }, /* (90) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  262,   -1 }, /* (91) alter_db_options ::= alter_db_option */
  {  262,   -2 }, /* (92) alter_db_options ::= alter_db_options alter_db_option */
  {  266,   -2 }, /* (93) alter_db_option ::= BUFFER NK_INTEGER */
  {  266,   -2 }, /* (94) alter_db_option ::= CACHELAST NK_INTEGER */
  {  266,   -2 }, /* (95) alter_db_option ::= FSYNC NK_INTEGER */
  {  266,   -2 }, /* (96) alter_db_option ::= KEEP integer_list */
  {  266,   -2 }, /* (97) alter_db_option ::= KEEP variable_list */
  {  266,   -2 }, /* (98) alter_db_option ::= PAGES NK_INTEGER */
  {  266,   -2 }, /* (99) alter_db_option ::= REPLICA NK_INTEGER */
  {  266,   -2 }, /* (100) alter_db_option ::= STRICT NK_INTEGER */
  {  266,   -2 }, /* (101) alter_db_option ::= WAL NK_INTEGER */
  {  263,   -1 }, /* (102) integer_list ::= NK_INTEGER */
  {  263,   -3 }, /* (103) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  264,   -1 }, /* (104) variable_list ::= NK_VARIABLE */
  {  264,   -3 }, /* (105) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  265,   -1 }, /* (106) retention_list ::= retention */
  {  265,   -3 }, /* (107) retention_list ::= retention_list NK_COMMA retention */
  {  267,   -3 }, /* (108) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  246,   -9 }, /* (109) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  246,   -3 }, /* (110) cmd ::= CREATE TABLE multi_create_clause */
  {  246,   -9 }, /* (111) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  246,   -3 }, /* (112) cmd ::= DROP TABLE multi_drop_clause */
  {  246,   -4 }, /* (113) cmd ::= DROP STABLE exists_opt full_table_name */
  {  246,   -3 }, /* (114) cmd ::= ALTER TABLE alter_table_clause */
  {  246,   -3 }, /* (115) cmd ::= ALTER STABLE alter_table_clause */
  {  275,   -2 }, /* (116) alter_table_clause ::= full_table_name alter_table_options */
  {  275,   -5 }, /* (117) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  275,   -4 }, /* (118) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  275,   -5 }, /* (119) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  275,   -5 }, /* (120) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  275,   -5 }, /* (121) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  275,   -4 }, /* (122) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  275,   -5 }, /* (123) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  275,   -5 }, /* (124) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  275,   -6 }, /* (125) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  272,   -1 }, /* (126) multi_create_clause ::= create_subtable_clause */
  {  272,   -2 }, /* (127) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  280,  -10 }, /* (128) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  274,   -1 }, /* (129) multi_drop_clause ::= drop_table_clause */
  {  274,   -2 }, /* (130) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  283,   -2 }, /* (131) drop_table_clause ::= exists_opt full_table_name */
  {  281,    0 }, /* (132) specific_tags_opt ::= */
  {  281,   -3 }, /* (133) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  268,   -1 }, /* (134) full_table_name ::= table_name */
  {  268,   -3 }, /* (135) full_table_name ::= db_name NK_DOT table_name */
  {  269,   -1 }, /* (136) column_def_list ::= column_def */
  {  269,   -3 }, /* (137) column_def_list ::= column_def_list NK_COMMA column_def */
  {  286,   -2 }, /* (138) column_def ::= column_name type_name */
  {  286,   -4 }, /* (139) column_def ::= column_name type_name COMMENT NK_STRING */
  {  278,   -1 }, /* (140) type_name ::= BOOL */
  {  278,   -1 }, /* (141) type_name ::= TINYINT */
  {  278,   -1 }, /* (142) type_name ::= SMALLINT */
  {  278,   -1 }, /* (143) type_name ::= INT */
  {  278,   -1 }, /* (144) type_name ::= INTEGER */
  {  278,   -1 }, /* (145) type_name ::= BIGINT */
  {  278,   -1 }, /* (146) type_name ::= FLOAT */
  {  278,   -1 }, /* (147) type_name ::= DOUBLE */
  {  278,   -4 }, /* (148) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  278,   -1 }, /* (149) type_name ::= TIMESTAMP */
  {  278,   -4 }, /* (150) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  278,   -2 }, /* (151) type_name ::= TINYINT UNSIGNED */
  {  278,   -2 }, /* (152) type_name ::= SMALLINT UNSIGNED */
  {  278,   -2 }, /* (153) type_name ::= INT UNSIGNED */
  {  278,   -2 }, /* (154) type_name ::= BIGINT UNSIGNED */
  {  278,   -1 }, /* (155) type_name ::= JSON */
  {  278,   -4 }, /* (156) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  278,   -1 }, /* (157) type_name ::= MEDIUMBLOB */
  {  278,   -1 }, /* (158) type_name ::= BLOB */
  {  278,   -4 }, /* (159) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  278,   -1 }, /* (160) type_name ::= DECIMAL */
  {  278,   -4 }, /* (161) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  278,   -6 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  270,    0 }, /* (163) tags_def_opt ::= */
  {  270,   -1 }, /* (164) tags_def_opt ::= tags_def */
  {  273,   -4 }, /* (165) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  271,    0 }, /* (166) table_options ::= */
  {  271,   -3 }, /* (167) table_options ::= table_options COMMENT NK_STRING */
  {  271,   -3 }, /* (168) table_options ::= table_options MAX_DELAY duration_list */
  {  271,   -3 }, /* (169) table_options ::= table_options WATERMARK duration_list */
  {  271,   -5 }, /* (170) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  271,   -3 }, /* (171) table_options ::= table_options TTL NK_INTEGER */
  {  271,   -5 }, /* (172) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  276,   -1 }, /* (173) alter_table_options ::= alter_table_option */
  {  276,   -2 }, /* (174) alter_table_options ::= alter_table_options alter_table_option */
  {  289,   -2 }, /* (175) alter_table_option ::= COMMENT NK_STRING */
  {  289,   -2 }, /* (176) alter_table_option ::= TTL NK_INTEGER */
  {  287,   -1 }, /* (177) duration_list ::= duration_literal */
  {  287,   -3 }, /* (178) duration_list ::= duration_list NK_COMMA duration_literal */
  {  288,   -1 }, /* (179) rollup_func_list ::= rollup_func_name */
  {  288,   -3 }, /* (180) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  291,   -1 }, /* (181) rollup_func_name ::= function_name */
  {  291,   -1 }, /* (182) rollup_func_name ::= FIRST */
  {  291,   -1 }, /* (183) rollup_func_name ::= LAST */
  {  284,   -1 }, /* (184) col_name_list ::= col_name */
  {  284,   -3 }, /* (185) col_name_list ::= col_name_list NK_COMMA col_name */
  {  293,   -1 }, /* (186) col_name ::= column_name */
  {  246,   -2 }, /* (187) cmd ::= SHOW DNODES */
  {  246,   -2 }, /* (188) cmd ::= SHOW USERS */
  {  246,   -2 }, /* (189) cmd ::= SHOW DATABASES */
  {  246,   -4 }, /* (190) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  246,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  246,   -3 }, /* (192) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  246,   -2 }, /* (193) cmd ::= SHOW MNODES */
  {  246,   -2 }, /* (194) cmd ::= SHOW MODULES */
  {  246,   -2 }, /* (195) cmd ::= SHOW QNODES */
  {  246,   -2 }, /* (196) cmd ::= SHOW FUNCTIONS */
  {  246,   -5 }, /* (197) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  246,   -2 }, /* (198) cmd ::= SHOW STREAMS */
  {  246,   -2 }, /* (199) cmd ::= SHOW ACCOUNTS */
  {  246,   -2 }, /* (200) cmd ::= SHOW APPS */
  {  246,   -2 }, /* (201) cmd ::= SHOW CONNECTIONS */
  {  246,   -2 }, /* (202) cmd ::= SHOW LICENCE */
  {  246,   -2 }, /* (203) cmd ::= SHOW GRANTS */
  {  246,   -4 }, /* (204) cmd ::= SHOW CREATE DATABASE db_name */
  {  246,   -4 }, /* (205) cmd ::= SHOW CREATE TABLE full_table_name */
  {  246,   -4 }, /* (206) cmd ::= SHOW CREATE STABLE full_table_name */
  {  246,   -2 }, /* (207) cmd ::= SHOW QUERIES */
  {  246,   -2 }, /* (208) cmd ::= SHOW SCORES */
  {  246,   -2 }, /* (209) cmd ::= SHOW TOPICS */
  {  246,   -2 }, /* (210) cmd ::= SHOW VARIABLES */
  {  246,   -3 }, /* (211) cmd ::= SHOW LOCAL VARIABLES */
  {  246,   -4 }, /* (212) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  246,   -2 }, /* (213) cmd ::= SHOW BNODES */
  {  246,   -2 }, /* (214) cmd ::= SHOW SNODES */
  {  246,   -2 }, /* (215) cmd ::= SHOW CLUSTER */
  {  246,   -2 }, /* (216) cmd ::= SHOW TRANSACTIONS */
  {  246,   -4 }, /* (217) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  246,   -2 }, /* (218) cmd ::= SHOW CONSUMERS */
  {  246,   -2 }, /* (219) cmd ::= SHOW SUBSCRIPTIONS */
  {  294,    0 }, /* (220) db_name_cond_opt ::= */
  {  294,   -2 }, /* (221) db_name_cond_opt ::= db_name NK_DOT */
  {  295,    0 }, /* (222) like_pattern_opt ::= */
  {  295,   -2 }, /* (223) like_pattern_opt ::= LIKE NK_STRING */
  {  296,   -1 }, /* (224) table_name_cond ::= table_name */
  {  297,    0 }, /* (225) from_db_opt ::= */
  {  297,   -2 }, /* (226) from_db_opt ::= FROM db_name */
  {  246,   -8 }, /* (227) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  246,   -4 }, /* (228) cmd ::= DROP INDEX exists_opt index_name */
  {  299,  -10 }, /* (229) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  299,  -12 }, /* (230) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  300,   -1 }, /* (231) func_list ::= func */
  {  300,   -3 }, /* (232) func_list ::= func_list NK_COMMA func */
  {  303,   -4 }, /* (233) func ::= function_name NK_LP expression_list NK_RP */
  {  302,    0 }, /* (234) sma_stream_opt ::= */
  {  302,   -3 }, /* (235) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  302,   -3 }, /* (236) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  246,   -6 }, /* (237) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  246,   -7 }, /* (238) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  246,   -9 }, /* (239) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  246,   -7 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  246,   -9 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  246,   -4 }, /* (242) cmd ::= DROP TOPIC exists_opt topic_name */
  {  246,   -7 }, /* (243) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  246,   -2 }, /* (244) cmd ::= DESC full_table_name */
  {  246,   -2 }, /* (245) cmd ::= DESCRIBE full_table_name */
  {  246,   -3 }, /* (246) cmd ::= RESET QUERY CACHE */
  {  246,   -4 }, /* (247) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  309,    0 }, /* (248) analyze_opt ::= */
  {  309,   -1 }, /* (249) analyze_opt ::= ANALYZE */
  {  310,    0 }, /* (250) explain_options ::= */
  {  310,   -3 }, /* (251) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  310,   -3 }, /* (252) explain_options ::= explain_options RATIO NK_FLOAT */
  {  246,   -6 }, /* (253) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  246,  -10 }, /* (254) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  246,   -4 }, /* (255) cmd ::= DROP FUNCTION exists_opt function_name */
  {  311,    0 }, /* (256) agg_func_opt ::= */
  {  311,   -1 }, /* (257) agg_func_opt ::= AGGREGATE */
  {  312,    0 }, /* (258) bufsize_opt ::= */
  {  312,   -2 }, /* (259) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  246,   -8 }, /* (260) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  246,   -4 }, /* (261) cmd ::= DROP STREAM exists_opt stream_name */
  {  314,    0 }, /* (262) into_opt ::= */
  {  314,   -2 }, /* (263) into_opt ::= INTO full_table_name */
  {  305,    0 }, /* (264) stream_options ::= */
  {  305,   -3 }, /* (265) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  305,   -3 }, /* (266) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  305,   -4 }, /* (267) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  305,   -3 }, /* (268) stream_options ::= stream_options WATERMARK duration_literal */
  {  246,   -3 }, /* (269) cmd ::= KILL CONNECTION NK_INTEGER */
  {  246,   -3 }, /* (270) cmd ::= KILL QUERY NK_STRING */
  {  246,   -3 }, /* (271) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  246,   -2 }, /* (272) cmd ::= BALANCE VGROUP */
  {  246,   -4 }, /* (273) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  246,   -4 }, /* (274) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  246,   -3 }, /* (275) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  315,   -2 }, /* (276) dnode_list ::= DNODE NK_INTEGER */
  {  315,   -3 }, /* (277) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  246,   -3 }, /* (278) cmd ::= SYNCDB db_name REPLICA */
  {  246,   -4 }, /* (279) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  246,   -1 }, /* (280) cmd ::= query_expression */
  {  249,   -1 }, /* (281) literal ::= NK_INTEGER */
  {  249,   -1 }, /* (282) literal ::= NK_FLOAT */
  {  249,   -1 }, /* (283) literal ::= NK_STRING */
  {  249,   -1 }, /* (284) literal ::= NK_BOOL */
  {  249,   -2 }, /* (285) literal ::= TIMESTAMP NK_STRING */
  {  249,   -1 }, /* (286) literal ::= duration_literal */
  {  249,   -1 }, /* (287) literal ::= NULL */
  {  249,   -1 }, /* (288) literal ::= NK_QUESTION */
  {  290,   -1 }, /* (289) duration_literal ::= NK_VARIABLE */
  {  317,   -1 }, /* (290) signed ::= NK_INTEGER */
  {  317,   -2 }, /* (291) signed ::= NK_PLUS NK_INTEGER */
  {  317,   -2 }, /* (292) signed ::= NK_MINUS NK_INTEGER */
  {  317,   -1 }, /* (293) signed ::= NK_FLOAT */
  {  317,   -2 }, /* (294) signed ::= NK_PLUS NK_FLOAT */
  {  317,   -2 }, /* (295) signed ::= NK_MINUS NK_FLOAT */
  {  279,   -1 }, /* (296) signed_literal ::= signed */
  {  279,   -1 }, /* (297) signed_literal ::= NK_STRING */
  {  279,   -1 }, /* (298) signed_literal ::= NK_BOOL */
  {  279,   -2 }, /* (299) signed_literal ::= TIMESTAMP NK_STRING */
  {  279,   -1 }, /* (300) signed_literal ::= duration_literal */
  {  279,   -1 }, /* (301) signed_literal ::= NULL */
  {  279,   -1 }, /* (302) signed_literal ::= literal_func */
  {  282,   -1 }, /* (303) literal_list ::= signed_literal */
  {  282,   -3 }, /* (304) literal_list ::= literal_list NK_COMMA signed_literal */
  {  257,   -1 }, /* (305) db_name ::= NK_ID */
  {  285,   -1 }, /* (306) table_name ::= NK_ID */
  {  277,   -1 }, /* (307) column_name ::= NK_ID */
  {  292,   -1 }, /* (308) function_name ::= NK_ID */
  {  319,   -1 }, /* (309) table_alias ::= NK_ID */
  {  320,   -1 }, /* (310) column_alias ::= NK_ID */
  {  251,   -1 }, /* (311) user_name ::= NK_ID */
  {  298,   -1 }, /* (312) index_name ::= NK_ID */
  {  306,   -1 }, /* (313) topic_name ::= NK_ID */
  {  313,   -1 }, /* (314) stream_name ::= NK_ID */
  {  308,   -1 }, /* (315) cgroup_name ::= NK_ID */
  {  321,   -1 }, /* (316) expression ::= literal */
  {  321,   -1 }, /* (317) expression ::= pseudo_column */
  {  321,   -1 }, /* (318) expression ::= column_reference */
  {  321,   -1 }, /* (319) expression ::= function_expression */
  {  321,   -1 }, /* (320) expression ::= subquery */
  {  321,   -3 }, /* (321) expression ::= NK_LP expression NK_RP */
  {  321,   -2 }, /* (322) expression ::= NK_PLUS expression */
  {  321,   -2 }, /* (323) expression ::= NK_MINUS expression */
  {  321,   -3 }, /* (324) expression ::= expression NK_PLUS expression */
  {  321,   -3 }, /* (325) expression ::= expression NK_MINUS expression */
  {  321,   -3 }, /* (326) expression ::= expression NK_STAR expression */
  {  321,   -3 }, /* (327) expression ::= expression NK_SLASH expression */
  {  321,   -3 }, /* (328) expression ::= expression NK_REM expression */
  {  321,   -3 }, /* (329) expression ::= column_reference NK_ARROW NK_STRING */
  {  321,   -3 }, /* (330) expression ::= expression NK_BITAND expression */
  {  321,   -3 }, /* (331) expression ::= expression NK_BITOR expression */
  {  304,   -1 }, /* (332) expression_list ::= expression */
  {  304,   -3 }, /* (333) expression_list ::= expression_list NK_COMMA expression */
  {  323,   -1 }, /* (334) column_reference ::= column_name */
  {  323,   -3 }, /* (335) column_reference ::= table_name NK_DOT column_name */
  {  322,   -1 }, /* (336) pseudo_column ::= ROWTS */
  {  322,   -1 }, /* (337) pseudo_column ::= TBNAME */
  {  322,   -3 }, /* (338) pseudo_column ::= table_name NK_DOT TBNAME */
  {  322,   -1 }, /* (339) pseudo_column ::= QSTARTTS */
  {  322,   -1 }, /* (340) pseudo_column ::= QENDTS */
  {  322,   -1 }, /* (341) pseudo_column ::= WSTARTTS */
  {  322,   -1 }, /* (342) pseudo_column ::= WENDTS */
  {  322,   -1 }, /* (343) pseudo_column ::= WDURATION */
  {  324,   -4 }, /* (344) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  324,   -4 }, /* (345) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  324,   -6 }, /* (346) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  324,   -1 }, /* (347) function_expression ::= literal_func */
  {  318,   -3 }, /* (348) literal_func ::= noarg_func NK_LP NK_RP */
  {  318,   -1 }, /* (349) literal_func ::= NOW */
  {  328,   -1 }, /* (350) noarg_func ::= NOW */
  {  328,   -1 }, /* (351) noarg_func ::= TODAY */
  {  328,   -1 }, /* (352) noarg_func ::= TIMEZONE */
  {  326,   -1 }, /* (353) star_func ::= COUNT */
  {  326,   -1 }, /* (354) star_func ::= FIRST */
  {  326,   -1 }, /* (355) star_func ::= LAST */
  {  326,   -1 }, /* (356) star_func ::= LAST_ROW */
  {  327,   -1 }, /* (357) star_func_para_list ::= NK_STAR */
  {  327,   -1 }, /* (358) star_func_para_list ::= other_para_list */
  {  329,   -1 }, /* (359) other_para_list ::= star_func_para */
  {  329,   -3 }, /* (360) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  330,   -1 }, /* (361) star_func_para ::= expression */
  {  330,   -3 }, /* (362) star_func_para ::= table_name NK_DOT NK_STAR */
  {  331,   -3 }, /* (363) predicate ::= expression compare_op expression */
  {  331,   -5 }, /* (364) predicate ::= expression BETWEEN expression AND expression */
  {  331,   -6 }, /* (365) predicate ::= expression NOT BETWEEN expression AND expression */
  {  331,   -3 }, /* (366) predicate ::= expression IS NULL */
  {  331,   -4 }, /* (367) predicate ::= expression IS NOT NULL */
  {  331,   -3 }, /* (368) predicate ::= expression in_op in_predicate_value */
  {  332,   -1 }, /* (369) compare_op ::= NK_LT */
  {  332,   -1 }, /* (370) compare_op ::= NK_GT */
  {  332,   -1 }, /* (371) compare_op ::= NK_LE */
  {  332,   -1 }, /* (372) compare_op ::= NK_GE */
  {  332,   -1 }, /* (373) compare_op ::= NK_NE */
  {  332,   -1 }, /* (374) compare_op ::= NK_EQ */
  {  332,   -1 }, /* (375) compare_op ::= LIKE */
  {  332,   -2 }, /* (376) compare_op ::= NOT LIKE */
  {  332,   -1 }, /* (377) compare_op ::= MATCH */
  {  332,   -1 }, /* (378) compare_op ::= NMATCH */
  {  332,   -1 }, /* (379) compare_op ::= CONTAINS */
  {  333,   -1 }, /* (380) in_op ::= IN */
  {  333,   -2 }, /* (381) in_op ::= NOT IN */
  {  334,   -3 }, /* (382) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  335,   -1 }, /* (383) boolean_value_expression ::= boolean_primary */
  {  335,   -2 }, /* (384) boolean_value_expression ::= NOT boolean_primary */
  {  335,   -3 }, /* (385) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  335,   -3 }, /* (386) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  336,   -1 }, /* (387) boolean_primary ::= predicate */
  {  336,   -3 }, /* (388) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  337,   -1 }, /* (389) common_expression ::= expression */
  {  337,   -1 }, /* (390) common_expression ::= boolean_value_expression */
  {  338,    0 }, /* (391) from_clause_opt ::= */
  {  338,   -2 }, /* (392) from_clause_opt ::= FROM table_reference_list */
  {  339,   -1 }, /* (393) table_reference_list ::= table_reference */
  {  339,   -3 }, /* (394) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  340,   -1 }, /* (395) table_reference ::= table_primary */
  {  340,   -1 }, /* (396) table_reference ::= joined_table */
  {  341,   -2 }, /* (397) table_primary ::= table_name alias_opt */
  {  341,   -4 }, /* (398) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  341,   -2 }, /* (399) table_primary ::= subquery alias_opt */
  {  341,   -1 }, /* (400) table_primary ::= parenthesized_joined_table */
  {  343,    0 }, /* (401) alias_opt ::= */
  {  343,   -1 }, /* (402) alias_opt ::= table_alias */
  {  343,   -2 }, /* (403) alias_opt ::= AS table_alias */
  {  344,   -3 }, /* (404) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  344,   -3 }, /* (405) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  342,   -6 }, /* (406) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  345,    0 }, /* (407) join_type ::= */
  {  345,   -1 }, /* (408) join_type ::= INNER */
  {  347,  -12 }, /* (409) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  348,    0 }, /* (410) set_quantifier_opt ::= */
  {  348,   -1 }, /* (411) set_quantifier_opt ::= DISTINCT */
  {  348,   -1 }, /* (412) set_quantifier_opt ::= ALL */
  {  349,   -1 }, /* (413) select_list ::= NK_STAR */
  {  349,   -1 }, /* (414) select_list ::= select_sublist */
  {  357,   -1 }, /* (415) select_sublist ::= select_item */
  {  357,   -3 }, /* (416) select_sublist ::= select_sublist NK_COMMA select_item */
  {  358,   -1 }, /* (417) select_item ::= common_expression */
  {  358,   -2 }, /* (418) select_item ::= common_expression column_alias */
  {  358,   -3 }, /* (419) select_item ::= common_expression AS column_alias */
  {  358,   -3 }, /* (420) select_item ::= table_name NK_DOT NK_STAR */
  {  316,    0 }, /* (421) where_clause_opt ::= */
  {  316,   -2 }, /* (422) where_clause_opt ::= WHERE search_condition */
  {  350,    0 }, /* (423) partition_by_clause_opt ::= */
  {  350,   -3 }, /* (424) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  354,    0 }, /* (425) twindow_clause_opt ::= */
  {  354,   -6 }, /* (426) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  354,   -4 }, /* (427) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  354,   -6 }, /* (428) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  354,   -8 }, /* (429) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  301,    0 }, /* (430) sliding_opt ::= */
  {  301,   -4 }, /* (431) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  353,    0 }, /* (432) fill_opt ::= */
  {  353,   -4 }, /* (433) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  353,   -6 }, /* (434) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  359,   -1 }, /* (435) fill_mode ::= NONE */
  {  359,   -1 }, /* (436) fill_mode ::= PREV */
  {  359,   -1 }, /* (437) fill_mode ::= NULL */
  {  359,   -1 }, /* (438) fill_mode ::= LINEAR */
  {  359,   -1 }, /* (439) fill_mode ::= NEXT */
  {  355,    0 }, /* (440) group_by_clause_opt ::= */
  {  355,   -3 }, /* (441) group_by_clause_opt ::= GROUP BY group_by_list */
  {  360,   -1 }, /* (442) group_by_list ::= expression */
  {  360,   -3 }, /* (443) group_by_list ::= group_by_list NK_COMMA expression */
  {  356,    0 }, /* (444) having_clause_opt ::= */
  {  356,   -2 }, /* (445) having_clause_opt ::= HAVING search_condition */
  {  351,    0 }, /* (446) range_opt ::= */
  {  351,   -6 }, /* (447) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  352,    0 }, /* (448) every_opt ::= */
  {  352,   -4 }, /* (449) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  307,   -4 }, /* (450) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  361,   -1 }, /* (451) query_expression_body ::= query_primary */
  {  361,   -4 }, /* (452) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  361,   -3 }, /* (453) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  365,   -1 }, /* (454) query_primary ::= query_specification */
  {  365,   -6 }, /* (455) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  362,    0 }, /* (456) order_by_clause_opt ::= */
  {  362,   -3 }, /* (457) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  363,    0 }, /* (458) slimit_clause_opt ::= */
  {  363,   -2 }, /* (459) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  363,   -4 }, /* (460) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  363,   -4 }, /* (461) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  364,    0 }, /* (462) limit_clause_opt ::= */
  {  364,   -2 }, /* (463) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  364,   -4 }, /* (464) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  364,   -4 }, /* (465) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  325,   -3 }, /* (466) subquery ::= NK_LP query_expression NK_RP */
  {  346,   -1 }, /* (467) search_condition ::= common_expression */
  {  366,   -1 }, /* (468) sort_specification_list ::= sort_specification */
  {  366,   -3 }, /* (469) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  367,   -3 }, /* (470) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  368,    0 }, /* (471) ordering_specification_opt ::= */
  {  368,   -1 }, /* (472) ordering_specification_opt ::= ASC */
  {  368,   -1 }, /* (473) ordering_specification_opt ::= DESC */
  {  369,    0 }, /* (474) null_ordering_opt ::= */
  {  369,   -2 }, /* (475) null_ordering_opt ::= NULLS FIRST */
  {  369,   -2 }, /* (476) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,247,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,248,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,247,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,249,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,250,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,248,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,250,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,249,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy109, &yymsp[-1].minor.yy0, yymsp[0].minor.yy323); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy109, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy109, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy109, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy109); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy323 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy323 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy209, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy109); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy209, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy109); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy209 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy209 = yymsp[0].minor.yy209; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy209 = yymsp[-2].minor.yy209 | yymsp[0].minor.yy209; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy209 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy209 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy109 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy109 = yylhsminor.yy109;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy109 = yymsp[-2].minor.yy109; }
  yymsp[-2].minor.yy109 = yylhsminor.yy109;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy109, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy109); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 305: /* db_name ::= NK_ID */ yytestcase(yyruleno==305);
      case 306: /* table_name ::= NK_ID */ yytestcase(yyruleno==306);
      case 307: /* column_name ::= NK_ID */ yytestcase(yyruleno==307);
      case 308: /* function_name ::= NK_ID */ yytestcase(yyruleno==308);
      case 309: /* table_alias ::= NK_ID */ yytestcase(yyruleno==309);
      case 310: /* column_alias ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* user_name ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* index_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* topic_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* stream_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 350: /* noarg_func ::= NOW */ yytestcase(yyruleno==350);
      case 351: /* noarg_func ::= TODAY */ yytestcase(yyruleno==351);
      case 352: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==352);
      case 353: /* star_func ::= COUNT */ yytestcase(yyruleno==353);
      case 354: /* star_func ::= FIRST */ yytestcase(yyruleno==354);
      case 355: /* star_func ::= LAST */ yytestcase(yyruleno==355);
      case 356: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==356);
{ yylhsminor.yy109 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy109 = yylhsminor.yy109;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy437, &yymsp[-1].minor.yy109, yymsp[0].minor.yy452); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy109); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy109); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy109, yymsp[0].minor.yy452); }
        break;
      case 66: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy437 = true; }
        break;
      case 67: /* not_exists_opt ::= */
      case 69: /* exists_opt ::= */ yytestcase(yyruleno==69);
      case 248: /* analyze_opt ::= */ yytestcase(yyruleno==248);
      case 256: /* agg_func_opt ::= */ yytestcase(yyruleno==256);
      case 410: /* set_quantifier_opt ::= */ yytestcase(yyruleno==410);
{ yymsp[1].minor.yy437 = false; }
        break;
      case 68: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy437 = true; }
        break;
      case 70: /* db_options ::= */
{ yymsp[1].minor.yy452 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 71: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 72: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 73: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 74: /* db_options ::= db_options DURATION NK_INTEGER */
      case 75: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==75);
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 76: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 77: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 78: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 79: /* db_options ::= db_options KEEP integer_list */
      case 80: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==80);
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_KEEP, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 81: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 82: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 83: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 84: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 85: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 86: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 87: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 88: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 89: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_RETENTIONS, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 90: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 91: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy452 = createAlterDatabaseOptions(pCxt); yylhsminor.yy452 = setAlterDatabaseOption(pCxt, yylhsminor.yy452, &yymsp[0].minor.yy85); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 92: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy452 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy452, &yymsp[0].minor.yy85); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 93: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy85.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 94: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy85.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy85.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= KEEP integer_list */
      case 97: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==97);
{ yymsp[-1].minor.yy85.type = DB_OPTION_KEEP; yymsp[-1].minor.yy85.pList = yymsp[0].minor.yy404; }
        break;
      case 98: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy85.type = DB_OPTION_PAGES; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy85.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy85.type = DB_OPTION_STRICT; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 101: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy85.type = DB_OPTION_WAL; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 103: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 277: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==277);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 104: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy404 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 105: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 106: /* retention_list ::= retention */
      case 126: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==126);
      case 129: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==129);
      case 136: /* column_def_list ::= column_def */ yytestcase(yyruleno==136);
      case 179: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==179);
      case 184: /* col_name_list ::= col_name */ yytestcase(yyruleno==184);
      case 231: /* func_list ::= func */ yytestcase(yyruleno==231);
      case 303: /* literal_list ::= signed_literal */ yytestcase(yyruleno==303);
      case 359: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==359);
      case 415: /* select_sublist ::= select_item */ yytestcase(yyruleno==415);
      case 468: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==468);
{ yylhsminor.yy404 = createNodeList(pCxt, yymsp[0].minor.yy452); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 107: /* retention_list ::= retention_list NK_COMMA retention */
      case 137: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==185);
      case 232: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==232);
      case 304: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==304);
      case 360: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==360);
      case 416: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==416);
      case 469: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==469);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, yymsp[0].minor.yy452); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 108: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy452 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 109: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 111: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==111);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy437, yymsp[-5].minor.yy452, yymsp[-3].minor.yy404, yymsp[-1].minor.yy404, yymsp[0].minor.yy452); }
        break;
      case 110: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 112: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy404); }
        break;
      case 113: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy437, yymsp[0].minor.yy452); }
        break;
      case 114: /* cmd ::= ALTER TABLE alter_table_clause */
      case 115: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==115);
      case 280: /* cmd ::= query_expression */ yytestcase(yyruleno==280);
{ pCxt->pRootNode = yymsp[0].minor.yy452; }
        break;
      case 116: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy452 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 117: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy109, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 118: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy452 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy452, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy109); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 119: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy109, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 120: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy452 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy109, &yymsp[0].minor.yy109); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 121: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy109, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 122: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy452 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy452, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy109); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 123: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy109, yymsp[0].minor.yy504); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 124: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy452 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy109, &yymsp[0].minor.yy109); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 125: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy452 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy452, &yymsp[-2].minor.yy109, yymsp[0].minor.yy452); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 127: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 130: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==130);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-1].minor.yy404, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy404 = yylhsminor.yy404;
        break;
      case 128: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy452 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy437, yymsp[-8].minor.yy452, yymsp[-6].minor.yy452, yymsp[-5].minor.yy404, yymsp[-2].minor.yy404, yymsp[0].minor.yy452); }
  yymsp[-9].minor.yy452 = yylhsminor.yy452;
        break;
      case 131: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy452 = createDropTableClause(pCxt, yymsp[-1].minor.yy437, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 132: /* specific_tags_opt ::= */
      case 163: /* tags_def_opt ::= */ yytestcase(yyruleno==163);
      case 423: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==423);
      case 440: /* group_by_clause_opt ::= */ yytestcase(yyruleno==440);
      case 456: /* order_by_clause_opt ::= */ yytestcase(yyruleno==456);
{ yymsp[1].minor.yy404 = NULL; }
        break;
      case 133: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 134: /* full_table_name ::= table_name */
{ yylhsminor.yy452 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy109, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 135: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy452 = createRealTableNode(pCxt, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy109, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 138: /* column_def ::= column_name type_name */
{ yylhsminor.yy452 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy109, yymsp[0].minor.yy504, NULL); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 139: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy452 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy109, yymsp[-2].minor.yy504, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 140: /* type_name ::= BOOL */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 141: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 142: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 143: /* type_name ::= INT */
      case 144: /* type_name ::= INTEGER */ yytestcase(yyruleno==144);
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 145: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 146: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 147: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 148: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 149: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 150: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 151: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 152: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 153: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 154: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy504 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 155: /* type_name ::= JSON */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 156: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 158: /* type_name ::= BLOB */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 159: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy504 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy504 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy504 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 164: /* tags_def_opt ::= tags_def */
      case 358: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==358);
      case 414: /* select_list ::= select_sublist */ yytestcase(yyruleno==414);
{ yylhsminor.yy404 = yymsp[0].minor.yy404; }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 165: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy404 = yymsp[-1].minor.yy404; }
        break;
      case 166: /* table_options ::= */
{ yymsp[1].minor.yy452 = createDefaultTableOptions(pCxt); }
        break;
      case 167: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 168: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 169: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy404); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 170: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-4].minor.yy452, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 171: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 172: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-4].minor.yy452, TABLE_OPTION_SMA, yymsp[-1].minor.yy404); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 173: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy452 = createAlterTableOptions(pCxt); yylhsminor.yy452 = setTableOption(pCxt, yylhsminor.yy452, yymsp[0].minor.yy85.type, &yymsp[0].minor.yy85.val); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 174: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy85.type, &yymsp[0].minor.yy85.val); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 175: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy85.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 176: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy85.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy85.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* duration_list ::= duration_literal */
      case 332: /* expression_list ::= expression */ yytestcase(yyruleno==332);
{ yylhsminor.yy404 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 178: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 333: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==333);
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 181: /* rollup_func_name ::= function_name */
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[0].minor.yy109, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 182: /* rollup_func_name ::= FIRST */
      case 183: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==183);
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 186: /* col_name ::= column_name */
{ yylhsminor.yy452 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy109); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 187: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 188: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 189: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 190: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, OP_TYPE_LIKE); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy452, NULL, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 195: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 196: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 197: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy452, yymsp[-1].minor.yy452, OP_TYPE_EQUAL); }
        break;
      case 198: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 199: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 200: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 201: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 202: /* cmd ::= SHOW LICENCE */
      case 203: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==203);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 204: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy109); }
        break;
      case 205: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy452); }
        break;
      case 206: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy452); }
        break;
      case 207: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 208: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 209: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 210: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 211: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 213: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 216: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy452); }
        break;
      case 218: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 219: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 220: /* db_name_cond_opt ::= */
      case 225: /* from_db_opt ::= */ yytestcase(yyruleno==225);
{ yymsp[1].minor.yy452 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 221: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy109); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 222: /* like_pattern_opt ::= */
      case 262: /* into_opt ::= */ yytestcase(yyruleno==262);
      case 391: /* from_clause_opt ::= */ yytestcase(yyruleno==391);
      case 421: /* where_clause_opt ::= */ yytestcase(yyruleno==421);
      case 425: /* twindow_clause_opt ::= */ yytestcase(yyruleno==425);
      case 430: /* sliding_opt ::= */ yytestcase(yyruleno==430);
      case 432: /* fill_opt ::= */ yytestcase(yyruleno==432);
      case 444: /* having_clause_opt ::= */ yytestcase(yyruleno==444);
      case 446: /* range_opt ::= */ yytestcase(yyruleno==446);
      case 448: /* every_opt ::= */ yytestcase(yyruleno==448);
      case 458: /* slimit_clause_opt ::= */ yytestcase(yyruleno==458);
      case 462: /* limit_clause_opt ::= */ yytestcase(yyruleno==462);
{ yymsp[1].minor.yy452 = NULL; }
        break;
      case 223: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 224: /* table_name_cond ::= table_name */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy109); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 226: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy109); }
        break;
      case 227: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy437, &yymsp[-3].minor.yy109, &yymsp[-1].minor.yy109, NULL, yymsp[0].minor.yy452); }
        break;
      case 228: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy109); }
        break;
      case 229: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy452 = createIndexOption(pCxt, yymsp[-7].minor.yy404, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 230: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy452 = createIndexOption(pCxt, yymsp[-9].minor.yy404, releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 233: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[-3].minor.yy109, yymsp[-1].minor.yy404); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 234: /* sma_stream_opt ::= */
      case 264: /* stream_options ::= */ yytestcase(yyruleno==264);
{ yymsp[1].minor.yy452 = createStreamOptions(pCxt); }
        break;
      case 235: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 268: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==268);
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 236: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 237: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy437, &yymsp[-2].minor.yy109, yymsp[0].minor.yy452); }
        break;
      case 238: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy437, &yymsp[-3].minor.yy109, &yymsp[0].minor.yy109, false); }
        break;
      case 239: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy437, &yymsp[-5].minor.yy109, &yymsp[0].minor.yy109, true); }
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy437, &yymsp[-3].minor.yy109, yymsp[0].minor.yy452, false); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy437, &yymsp[-5].minor.yy109, yymsp[0].minor.yy452, true); }
        break;
      case 242: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy109); }
        break;
      case 243: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy437, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy109); }
        break;
      case 244: /* cmd ::= DESC full_table_name */
      case 245: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==245);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy452); }
        break;
      case 246: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 247: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy437, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 249: /* analyze_opt ::= ANALYZE */
      case 257: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==257);
      case 411: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==411);
{ yymsp[0].minor.yy437 = true; }
        break;
      case 250: /* explain_options ::= */
{ yymsp[1].minor.yy452 = createDefaultExplainOptions(pCxt); }
        break;
      case 251: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy452 = setExplainVerbose(pCxt, yymsp[-2].minor.yy452, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 252: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy452 = setExplainRatio(pCxt, yymsp[-2].minor.yy452, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 253: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy404); }
        break;
      case 254: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy437, yymsp[-8].minor.yy437, &yymsp[-5].minor.yy109, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy504, yymsp[0].minor.yy100); }
        break;
      case 255: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy109); }
        break;
      case 258: /* bufsize_opt ::= */
{ yymsp[1].minor.yy100 = 0; }
        break;
      case 259: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy100 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 260: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy437, &yymsp[-4].minor.yy109, yymsp[-2].minor.yy452, yymsp[-3].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 261: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy437, &yymsp[0].minor.yy109); }
        break;
      case 263: /* into_opt ::= INTO full_table_name */
      case 392: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==392);
      case 422: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==422);
      case 445: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==445);
{ yymsp[-1].minor.yy452 = yymsp[0].minor.yy452; }
        break;
      case 265: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 266: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 267: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy452)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy452)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); yylhsminor.yy452 = yymsp[-3].minor.yy452; }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 269: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 270: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 271: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 272: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 273: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 274: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy404); }
        break;
      case 275: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 276: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy404 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 278: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy109); }
        break;
      case 279: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 281: /* literal ::= NK_INTEGER */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 282: /* literal ::= NK_FLOAT */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 283: /* literal ::= NK_STRING */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 284: /* literal ::= NK_BOOL */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 285: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 286: /* literal ::= duration_literal */
      case 296: /* signed_literal ::= signed */ yytestcase(yyruleno==296);
      case 316: /* expression ::= literal */ yytestcase(yyruleno==316);
      case 317: /* expression ::= pseudo_column */ yytestcase(yyruleno==317);
      case 318: /* expression ::= column_reference */ yytestcase(yyruleno==318);
      case 319: /* expression ::= function_expression */ yytestcase(yyruleno==319);
      case 320: /* expression ::= subquery */ yytestcase(yyruleno==320);
      case 347: /* function_expression ::= literal_func */ yytestcase(yyruleno==347);
      case 383: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==383);
      case 387: /* boolean_primary ::= predicate */ yytestcase(yyruleno==387);
      case 389: /* common_expression ::= expression */ yytestcase(yyruleno==389);
      case 390: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==390);
      case 393: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==393);
      case 395: /* table_reference ::= table_primary */ yytestcase(yyruleno==395);
      case 396: /* table_reference ::= joined_table */ yytestcase(yyruleno==396);
      case 400: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==400);
      case 451: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==451);
      case 454: /* query_primary ::= query_specification */ yytestcase(yyruleno==454);
{ yylhsminor.yy452 = yymsp[0].minor.yy452; }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 287: /* literal ::= NULL */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 288: /* literal ::= NK_QUESTION */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 289: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 290: /* signed ::= NK_INTEGER */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 291: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 292: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 293: /* signed ::= NK_FLOAT */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 294: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 295: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 297: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 298: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 299: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 300: /* signed_literal ::= duration_literal */
      case 302: /* signed_literal ::= literal_func */ yytestcase(yyruleno==302);
      case 361: /* star_func_para ::= expression */ yytestcase(yyruleno==361);
      case 417: /* select_item ::= common_expression */ yytestcase(yyruleno==417);
      case 467: /* search_condition ::= common_expression */ yytestcase(yyruleno==467);
{ yylhsminor.yy452 = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 301: /* signed_literal ::= NULL */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 321: /* expression ::= NK_LP expression NK_RP */
      case 388: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==388);
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 322: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy452));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 323: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy452), NULL));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 324: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 325: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 326: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 327: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 328: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 329: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 330: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 331: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 334: /* column_reference ::= column_name */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy109, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy109)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 335: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy109, createColumnNode(pCxt, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy109)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 336: /* pseudo_column ::= ROWTS */
      case 337: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==337);
      case 339: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==339);
      case 340: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==340);
      case 341: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==341);
      case 342: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==342);
      case 343: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==343);
      case 349: /* literal_func ::= NOW */ yytestcase(yyruleno==349);
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 338: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy109)))); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 344: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 345: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==345);
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy109, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy109, yymsp[-1].minor.yy404)); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 346: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy504)); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 348: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy109, NULL)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 357: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy404 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 362: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 420: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==420);
{ yylhsminor.yy452 = createColumnNode(pCxt, &yymsp[-2].minor.yy109, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 363: /* predicate ::= expression compare_op expression */
      case 368: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==368);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy440, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 364: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy452), releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 365: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 366: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), NULL));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 367: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL));
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 369: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy440 = OP_TYPE_LOWER_THAN; }
        break;
      case 370: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy440 = OP_TYPE_GREATER_THAN; }
        break;
      case 371: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy440 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 372: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy440 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 373: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy440 = OP_TYPE_NOT_EQUAL; }
        break;
      case 374: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy440 = OP_TYPE_EQUAL; }
        break;
      case 375: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy440 = OP_TYPE_LIKE; }
        break;
      case 376: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy440 = OP_TYPE_NOT_LIKE; }
        break;
      case 377: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy440 = OP_TYPE_MATCH; }
        break;
      case 378: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy440 = OP_TYPE_NMATCH; }
        break;
      case 379: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy440 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 380: /* in_op ::= IN */
{ yymsp[0].minor.yy440 = OP_TYPE_IN; }
        break;
      case 381: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy440 = OP_TYPE_NOT_IN; }
        break;
      case 382: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 384: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy452), NULL));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 385: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 386: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 394: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy452 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 397: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy452 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy109, &yymsp[0].minor.yy109); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 398: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy452 = createRealTableNode(pCxt, &yymsp[-3].minor.yy109, &yymsp[-1].minor.yy109, &yymsp[0].minor.yy109); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 399: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy452 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452), &yymsp[0].minor.yy109); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 401: /* alias_opt ::= */
{ yymsp[1].minor.yy109 = nil_token;  }
        break;
      case 402: /* alias_opt ::= table_alias */
{ yylhsminor.yy109 = yymsp[0].minor.yy109; }
  yymsp[0].minor.yy109 = yylhsminor.yy109;
        break;
      case 403: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy109 = yymsp[0].minor.yy109; }
        break;
      case 404: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 405: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==405);
{ yymsp[-2].minor.yy452 = yymsp[-1].minor.yy452; }
        break;
      case 406: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy452 = createJoinTableNode(pCxt, yymsp[-4].minor.yy532, yymsp[-5].minor.yy452, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 407: /* join_type ::= */
{ yymsp[1].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 408: /* join_type ::= INNER */
{ yymsp[0].minor.yy532 = JOIN_TYPE_INNER; }
        break;
      case 409: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy452 = createSelectStmt(pCxt, yymsp[-10].minor.yy437, yymsp[-9].minor.yy404, yymsp[-8].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addWhereClause(pCxt, yymsp[-11].minor.yy452, yymsp[-7].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addPartitionByClause(pCxt, yymsp[-11].minor.yy452, yymsp[-6].minor.yy404);
                                                                                    yymsp[-11].minor.yy452 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy452, yymsp[-2].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addGroupByClause(pCxt, yymsp[-11].minor.yy452, yymsp[-1].minor.yy404);
                                                                                    yymsp[-11].minor.yy452 = addHavingClause(pCxt, yymsp[-11].minor.yy452, yymsp[0].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addRangeClause(pCxt, yymsp[-11].minor.yy452, yymsp[-5].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addEveryClause(pCxt, yymsp[-11].minor.yy452, yymsp[-4].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addFillClause(pCxt, yymsp[-11].minor.yy452, yymsp[-3].minor.yy452);
                                                                                  }
        break;
      case 412: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy437 = false; }
        break;
      case 413: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy404 = NULL; }
        break;
      case 418: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy452 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452), &yymsp[0].minor.yy109); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 419: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy452 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), &yymsp[0].minor.yy109); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 424: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 441: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==441);
      case 457: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==457);
{ yymsp[-2].minor.yy404 = yymsp[0].minor.yy404; }
        break;
      case 426: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy452 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 427: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy452 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 428: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy452 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 429: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy452 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 431: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 449: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==449);
{ yymsp[-3].minor.yy452 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy452); }
        break;
      case 433: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy452 = createFillNode(pCxt, yymsp[-1].minor.yy614, NULL); }
        break;
      case 434: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy452 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy404)); }
        break;
      case 435: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy614 = FILL_MODE_NONE; }
        break;
      case 436: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy614 = FILL_MODE_PREV; }
        break;
      case 437: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy614 = FILL_MODE_NULL; }
        break;
      case 438: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy614 = FILL_MODE_LINEAR; }
        break;
      case 439: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy614 = FILL_MODE_NEXT; }
        break;
      case 442: /* group_by_list ::= expression */
{ yylhsminor.yy404 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); }
  yymsp[0].minor.yy404 = yylhsminor.yy404;
        break;
      case 443: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy404 = addNodeToList(pCxt, yymsp[-2].minor.yy404, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); }
  yymsp[-2].minor.yy404 = yylhsminor.yy404;
        break;
      case 447: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy452 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 450: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy452 = addOrderByClause(pCxt, yymsp[-3].minor.yy452, yymsp[-2].minor.yy404);
                                                                                    yylhsminor.yy452 = addSlimitClause(pCxt, yylhsminor.yy452, yymsp[-1].minor.yy452);
                                                                                    yylhsminor.yy452 = addLimitClause(pCxt, yylhsminor.yy452, yymsp[0].minor.yy452);
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 452: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy452 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 453: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy452 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 455: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy452 = yymsp[-4].minor.yy452; }
  yy_destructor(yypParser,362,&yymsp[-3].minor);
  yy_destructor(yypParser,363,&yymsp[-2].minor);
  yy_destructor(yypParser,364,&yymsp[-1].minor);
        break;
      case 459: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 463: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==463);
{ yymsp[-1].minor.yy452 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 460: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 464: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==464);
{ yymsp[-3].minor.yy452 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 461: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 465: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==465);
{ yymsp[-3].minor.yy452 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 466: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy452); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 470: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy452 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), yymsp[-1].minor.yy178, yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 471: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy178 = ORDER_ASC; }
        break;
      case 472: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy178 = ORDER_ASC; }
        break;
      case 473: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy178 = ORDER_DESC; }
        break;
      case 474: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy77 = NULL_ORDER_DEFAULT; }
        break;
      case 475: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy77 = NULL_ORDER_FIRST; }
        break;
      case 476: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy77 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
