/*
 * Copyright (c) 2019 TAOS Data, Inc. <jhtao@taosdata.com>
 *
 * This program is free software: you can use, redistribute, and/or modify
 * it under the terms of the GNU Affero General Public License, version 3
 * or later ("AGPL"), as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "planTestUtil.h"
#include "planner.h"

using namespace std;

class PlanPartitionByTest : public PlannerTestBase {};

TEST_F(PlanPartitionByTest, basic) {
  useDb("root", "test");

  run("select * from t1 partition by c1");
}

TEST_F(PlanPartitionByTest, withAggFunc) {
  useDb("root", "test");

  run("select count(*) from t1 partition by c1");
}

TEST_F(PlanPartitionByTest, withInterval) {
  useDb("root", "test");

  // normal/child table
  run("select count(*) from t1 partition by c1 interval(10s)");
  // super table
  run("select count(*) from st1 partition by tag1, tag2 interval(10s)");
}

TEST_F(PlanPartitionByTest, withGroupBy) {
  useDb("root", "test");

  run("select count(*) from t1 partition by c1 group by c2");
}
