/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBConnection;
import java.sql.Connection;

public class SqlSyntaxValidator {
    private static final String[] updateSQL = new String[]{"insert", "update", "delete", "create", "alter", "drop", "show", "describe", "use", "import"};
    private static final String[] querySQL = new String[]{"select"};
    private TSDBConnection tsdbConnection;

    public SqlSyntaxValidator(Connection connection) {
        this.tsdbConnection = (TSDBConnection)connection;
    }

    public static boolean isValidForExecuteUpdate(String sql) {
        for (String prefix : updateSQL) {
            if (!sql.trim().toLowerCase().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUseSql(String sql) {
        return sql.trim().toLowerCase().startsWith("use") || sql.trim().toLowerCase().matches("create\\s*database.*") || sql.toLowerCase().toLowerCase().matches("drop\\s*database.*");
    }

    public static boolean isShowSql(String sql) {
        return sql.trim().toLowerCase().startsWith("show");
    }

    public static boolean isDescribeSql(String sql) {
        return sql.trim().toLowerCase().startsWith("describe");
    }

    public static boolean isInsertSql(String sql) {
        return sql.trim().toLowerCase().startsWith("insert") || sql.trim().toLowerCase().startsWith("import");
    }

    public static boolean isSelectSql(String sql) {
        return sql.trim().toLowerCase().startsWith("select");
    }

    public static boolean isShowDatabaseSql(String sql) {
        return sql.trim().toLowerCase().matches("show\\s*databases");
    }
}

