/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractTaosDriver;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.rs.util.HttpClientPoolUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class RestfulDriver
extends AbstractTaosDriver {
    private static final String URL_PREFIX = "jdbc:TAOS-RS://";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException(TSDBConstants.WrapErrMsg("url is not set!"));
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = this.parseURL(url, info);
        String host = props.getProperty("host");
        String port = props.getProperty("port", "6041");
        String database = props.containsKey("dbname") ? props.getProperty("dbname") : null;
        String loginUrl = "http://" + props.getProperty("host") + ":" + props.getProperty("port") + "/rest/login/" + props.getProperty("user") + "/" + props.getProperty("password") + "";
        String result = HttpClientPoolUtil.execute(loginUrl);
        JSONObject jsonResult = JSON.parseObject(result);
        String status = jsonResult.getString("status");
        if (!status.equals("succ")) {
            throw new SQLException(jsonResult.getString("desc"));
        }
        return new RestfulConnection(host, port, props, database, url);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException(TSDBConstants.WrapErrMsg("url is null"));
        }
        return url != null && url.length() > 0 && url.trim().length() > 0 && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new RestfulDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(TSDBConstants.WrapErrMsg("can not register Restful JDBC driver"), e);
        }
    }
}

