/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.TSDBResultSetRowData;
import com.taosdata.jdbc.TaosGlobalConfig;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public class TSDBJNIConnector {
    private static volatile Boolean isInitialized = false;
    private long taos = 0L;
    private long taosResultSetPointer = 0L;
    private boolean isResultsetClosed = true;
    private int affectedRows = -1;

    public boolean isClosed() {
        return this.taos == 0L;
    }

    public boolean isResultsetClosed() {
        return this.isResultsetClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String configDir, String locale, String charset, String timezone) throws SQLWarning {
        Boolean bl = isInitialized;
        synchronized (bl) {
            if (!isInitialized.booleanValue()) {
                TSDBJNIConnector.initImp(configDir);
                if (TSDBJNIConnector.setOptions(0, locale) < 0) {
                    throw new SQLWarning(TSDBConstants.WrapErrMsg("Failed to set locale: " + locale + ". System default will be used."));
                }
                if (TSDBJNIConnector.setOptions(1, charset) < 0) {
                    throw new SQLWarning(TSDBConstants.WrapErrMsg("Failed to set charset: " + charset + ". System default will be used."));
                }
                if (TSDBJNIConnector.setOptions(2, timezone) < 0) {
                    throw new SQLWarning(TSDBConstants.WrapErrMsg("Failed to set timezone: " + timezone + ". System default will be used."));
                }
                isInitialized = true;
                TaosGlobalConfig.setCharset(TSDBJNIConnector.getTsCharset());
            }
        }
    }

    public static native void initImp(String var0);

    public static native int setOptions(int var0, String var1);

    public static native String getTsCharset();

    public boolean connect(String host, int port, String dbName, String user, String password) throws SQLException {
        if (this.taos != 0L) {
            this.closeConnectionImp(this.taos);
            this.taos = 0L;
        }
        this.taos = this.connectImp(host, port, dbName, user, password);
        if (this.taos == 0L) {
            throw new SQLException(TSDBConstants.WrapErrMsg(this.getErrMsg(0L)), "", this.getErrCode(0L));
        }
        return true;
    }

    private native long connectImp(String var1, int var2, String var3, String var4, String var5);

    public long executeQuery(String sql) throws SQLException {
        if (!this.isResultsetClosed) {
            this.freeResultSet(this.taosResultSetPointer);
        }
        Long pSql = 0L;
        try {
            pSql = this.executeQueryImp(sql.getBytes(TaosGlobalConfig.getCharset()), this.taos);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.freeResultSetImp(this.taos, pSql);
            throw new SQLException(TSDBConstants.WrapErrMsg("Unsupported encoding"));
        }
        int code = this.getErrCode(pSql);
        if (code != 0) {
            this.affectedRows = -1;
            String msg = this.getErrMsg(pSql);
            this.freeResultSetImp(this.taos, pSql);
            throw new SQLException(TSDBConstants.WrapErrMsg(msg), "", code);
        }
        this.taosResultSetPointer = this.getResultSetImp(this.taos, pSql);
        this.isResultsetClosed = this.taosResultSetPointer == 0L;
        return pSql;
    }

    private native long executeQueryImp(byte[] var1, long var2);

    public int getErrCode(long pSql) {
        return this.getErrCodeImp(this.taos, pSql);
    }

    private native int getErrCodeImp(long var1, long var3);

    public String getErrMsg(long pSql) {
        return this.getErrMsgImp(pSql);
    }

    private native String getErrMsgImp(long var1);

    public long getResultSet() {
        return this.taosResultSetPointer;
    }

    private native long getResultSetImp(long var1, long var3);

    public boolean isUpdateQuery(long pSql) {
        return this.isUpdateQueryImp(this.taos, pSql) == 1L;
    }

    private native long isUpdateQueryImp(long var1, long var3);

    public int freeResultSet(long result) {
        int res = 0;
        if (result != this.taosResultSetPointer && this.taosResultSetPointer != 0L) {
            throw new RuntimeException("Invalid result set pointer");
        }
        if (this.taosResultSetPointer != 0L) {
            res = this.freeResultSetImp(this.taos, result);
            this.taosResultSetPointer = 0L;
        }
        this.isResultsetClosed = true;
        return res;
    }

    public int freeResultSet() {
        int resCode = 0;
        if (!this.isResultsetClosed) {
            resCode = this.freeResultSetImp(this.taos, this.taosResultSetPointer);
            this.taosResultSetPointer = 0L;
            this.isResultsetClosed = true;
        }
        return resCode;
    }

    private native int freeResultSetImp(long var1, long var3);

    public int getAffectedRows(long pSql) {
        int affectedRows = this.affectedRows;
        if (affectedRows < 0) {
            affectedRows = this.getAffectedRowsImp(this.taos, pSql);
        }
        return affectedRows;
    }

    private native int getAffectedRowsImp(long var1, long var3);

    public int getSchemaMetaData(long resultSet, List<ColumnMetaData> columnMetaData) {
        return this.getSchemaMetaDataImp(this.taos, resultSet, columnMetaData);
    }

    private native int getSchemaMetaDataImp(long var1, long var3, List<ColumnMetaData> var5);

    public int fetchRow(long resultSet, TSDBResultSetRowData rowData) {
        return this.fetchRowImp(this.taos, resultSet, rowData);
    }

    private native int fetchRowImp(long var1, long var3, TSDBResultSetRowData var5);

    public int fetchBlock(long resultSet, TSDBResultSetBlockData blockData) {
        return this.fetchBlockImp(this.taos, resultSet, blockData);
    }

    private native int fetchBlockImp(long var1, long var3, TSDBResultSetBlockData var5);

    public void closeConnection() throws SQLException {
        int code = this.closeConnectionImp(this.taos);
        if (code < 0) {
            throw new SQLException(TSDBConstants.FixErrMsg(code), "", this.getErrCode(0L));
        }
        if (code != 0) {
            throw new SQLException("Undefined error code returned by TDengine when closing a connection");
        }
        this.taos = 0L;
    }

    private native int closeConnectionImp(long var1);

    long subscribe(String topic, String sql, boolean restart, int period) {
        return this.subscribeImp(this.taos, restart, topic, sql, period);
    }

    private native long subscribeImp(long var1, boolean var3, String var4, String var5, int var6);

    long consume(long subscription) {
        return this.consumeImp(subscription);
    }

    private native long consumeImp(long var1);

    void unsubscribe(long subscription, boolean isKeep) {
        this.unsubscribeImp(subscription, isKeep);
    }

    private native void unsubscribeImp(long var1, boolean var3);

    public boolean validateCreateTableSql(String sql) {
        long connection = this.taos;
        int res = this.validateCreateTableSqlImp(connection, sql.getBytes());
        return res == 0;
    }

    private native int validateCreateTableSqlImp(long var1, byte[] var3);

    static {
        System.loadLibrary("taos");
        System.out.println("java.library.path:" + System.getProperty("java.library.path"));
    }
}

