/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 432
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy2;
  int32_t yy100;
  SNodeList* yy280;
  bool yy281;
  SDataType yy304;
  EJoinType yy468;
  int64_t yy477;
  int8_t yy503;
  SAlterOption yy605;
  SToken yy641;
  ENullOrder yy649;
  EOperatorType yy668;
  EFillMode yy774;
  SNode* yy776;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             668
#define YYNRULE              499
#define YYNTOKEN             309
#define YY_MAX_SHIFT         667
#define YY_MIN_SHIFTREDUCE   980
#define YY_MAX_SHIFTREDUCE   1478
#define YY_ERROR_ACTION      1479
#define YY_ACCEPT_ACTION     1480
#define YY_NO_ACTION         1481
#define YY_MIN_REDUCE        1482
#define YY_MAX_REDUCE        1980
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2196)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   428, 1730,  429, 1517, 1811,  436, 1799,  429, 1517,  510,
 /*    10 */    28,  252,   37,   35, 1957, 1616,  318, 1795, 1013, 1727,
 /*    20 */   332,  146, 1276, 1494, 1811,   38,   36,   34,   33,   32,
 /*    30 */   549,  319, 1829, 1352,  337, 1274, 1952, 1672, 1674,  144,
 /*    40 */   574, 1791, 1797,  321,   71, 1781,  377,  573, 1629,  551,
 /*    50 */   162, 1957, 1829,  567, 1953,  552, 1347,  120, 1017, 1018,
 /*    60 */   574,   12, 1673, 1674,   81, 1781, 1622,  573, 1282, 1544,
 /*    70 */  1843, 1302, 1829, 1952,   91, 1812,  577, 1814,  575,  572,
 /*    80 */   539,  567,  148,  295, 1889, 1620, 1586, 1956,  298, 1885,
 /*    90 */  1843, 1953, 1955,    1,   93, 1812,  577, 1814, 1815,  572,
 /*   100 */  1952,  567,  510,   40, 1889, 1419,  414, 1904, 1888, 1885,
 /*   110 */   549, 1301, 1728,  551,  162,  664,  538,  104, 1953,  552,
 /*   120 */   103,  102,  101,  100,   99,   98,   97,   96,   95, 1354,
 /*   130 */  1355, 1901,  641,  640,  639,  638,  342, 1303,  637,  636,
 /*   140 */   126,  631,  630,  629,  628,  627,  626,  625,  624,  137,
 /*   150 */   620,  619,  618,  341,  340,  615,  614,  613,  612,  611,
 /*   160 */    24,  173,  172,  156,  192, 1482,   31,   30,  475,  474,
 /*   170 */    38,   36,   34,   33,   32, 1277, 1666, 1275,  150,  427,
 /*   180 */  1173, 1174,  431,  462,  458,  454,  450,  191,   52,  113,
 /*   190 */   112,  111,  110,  109,  108,  107,  106,  105, 1280, 1281,
 /*   200 */    52, 1329, 1330, 1332, 1333, 1334, 1335, 1336, 1337,  569,
 /*   210 */   565, 1345, 1346, 1348, 1349, 1350, 1351, 1353, 1356,   37,
 /*   220 */    35, 1415,   41,   72,  635,  633,  189,  332,  523, 1276,
 /*   230 */    31,   30,  163, 1505,   38,   36,   34,   33,   32,   46,
 /*   240 */  1352,  445, 1274,  218, 1811, 1131,  599,  598,  597, 1135,
 /*   250 */   596, 1137, 1138,  595, 1140,  592, 1627, 1146,  589, 1148,
 /*   260 */  1149,  586,  583, 1347,    6,   20, 1679,  523,   12,  370,
 /*   270 */   523,  369, 1829,  320, 1781, 1282,   37,   35,  165,  248,
 /*   280 */   550,  114, 1677, 1302,  332, 1781, 1276,  573,  466,  188,
 /*   290 */   182,   71,  187, 1331,   56, 1627,  441, 1352, 1627, 1274,
 /*   300 */     1,   31,   30, 1256, 1257,   38,   36,   34,   33,   32,
 /*   310 */  1843, 1605,  180, 1623,   92, 1812,  577, 1814, 1815,  572,
 /*   320 */  1347,  567,  664, 1301, 1889,   12,  608,  163,  323, 1885,
 /*   330 */   157,   88, 1282,  329,  328,  610, 1354, 1355, 1483,  163,
 /*   340 */  1618,  206,  161, 1290,  122,  135,  134,  605,  604,  603,
 /*   350 */  1915, 1795, 1619, 1304, 1352,  549, 1283,    1,  602,  104,
 /*   360 */  1811,  163,  103,  102,  101,  100,   99,   98,   97,   96,
 /*   370 */    95,  445,  144,  478,  477, 1791, 1797, 1347,  335,  664,
 /*   380 */   121, 1630, 1277,   52, 1275, 1376,  144,  567, 1829, 1282,
 /*   390 */   213,  473,  476, 1354, 1355, 1629,  574,  472,   73,  297,
 /*   400 */   540, 1781,  513,  573, 1300, 1280, 1281, 1436, 1329, 1330,
 /*   410 */  1332, 1333, 1334, 1335, 1336, 1337,  569,  565, 1345, 1346,
 /*   420 */  1348, 1349, 1350, 1351, 1353, 1356, 1843,   52,   40,   75,
 /*   430 */    92, 1812,  577, 1814, 1815,  572,  562,  567, 1523, 1277,
 /*   440 */  1889, 1275, 1679, 1679,  323, 1885, 1971,   25, 1504,  304,
 /*   450 */   532, 1434, 1435, 1437, 1438, 1923, 1408, 1381, 1677, 1678,
 /*   460 */  1475, 1503, 1280, 1281,  169, 1329, 1330, 1332, 1333, 1334,
 /*   470 */  1335, 1336, 1337,  569,  565, 1345, 1346, 1348, 1349, 1350,
 /*   480 */  1351, 1353, 1356,   37,   35,  294,  659, 1299, 1957, 1781,
 /*   490 */   371,  332, 1301, 1276,  407,  228, 1291,  419, 1286, 1412,
 /*   500 */    68,  535, 1781,   67, 1352, 1502, 1274, 1362,  506,  435,
 /*   510 */  1952, 1282,  431, 1301,  392, 1799,  420, 1811,  394, 1294,
 /*   520 */  1296, 1480,  163,  551,  162,  378, 1795, 1347, 1953,  552,
 /*   530 */  1952,  565, 1345, 1346, 1348, 1349, 1350, 1351,  379, 1282,
 /*   540 */  1604, 1957, 1301, 1958,  162, 1829, 1781, 1474, 1953,  552,
 /*   550 */  1791, 1797,  327,  571, 1030, 1030, 1029, 1029, 1781,  385,
 /*   560 */   573, 1612,  567, 1952,    7,   52,  163,  163,   31,   30,
 /*   570 */   464,  381,   38,   36,   34,   33,   32, 1956,  541,  536,
 /*   580 */   347, 1953, 1954, 1843, 1031, 1031,  664,  285, 1812,  577,
 /*   590 */  1814, 1815,  572,  570,  567,  564, 1861,  622,  506,  418,
 /*   600 */  1354, 1355,  413,  412,  411,  410,  409,  406,  405,  404,
 /*   610 */   403,  402,  398,  397,  396,  395,  389,  388,  387,  386,
 /*   620 */  1952,  383,  382,  306,   31,   30, 1614,  546,   38,   36,
 /*   630 */    34,   33,   32, 1958,  162,  546,   31,   30, 1953,  552,
 /*   640 */    38,   36,   34,   33,   32,  608, 1277, 1904, 1275,   34,
 /*   650 */    33,   32,   31,   30, 1446,  125,   38,   36,   34,   33,
 /*   660 */    32,    9,    8,  125,  135,  134,  605,  604,  603, 1280,
 /*   670 */  1281, 1900, 1329, 1330, 1332, 1333, 1334, 1335, 1336, 1337,
 /*   680 */   569,  565, 1345, 1346, 1348, 1349, 1350, 1351, 1353, 1356,
 /*   690 */    37,   35, 1357,  123, 1093, 1331,  433, 1768,  332, 1501,
 /*   700 */  1276,  116, 1299,  163,  163,  133,  483,  548,  158, 1897,
 /*   710 */  1898, 1352, 1902, 1274,  219,  220,  246, 1897,  545,   26,
 /*   720 */   544,  493, 1426, 1952, 1331,   31,   30, 1095, 1411,   38,
 /*   730 */    36,   34,   33,   32, 1347,  205,  551,  162, 1314, 1811,
 /*   740 */  1781, 1953,  552, 1679,  354,  366, 1282,   37,   35,  486,
 /*   750 */   336,  523, 1800,  480, 1388,  332,   45, 1276,  204, 1677,
 /*   760 */  1603,  523,  114, 1795,  368,  364, 1956, 1829, 1352,  471,
 /*   770 */  1274,    7,  375,  297,  523,  574,  513,  509,  143, 1627,
 /*   780 */  1781, 1500,  573,  555,  338,  376,  345, 1791, 1797, 1627,
 /*   790 */   546, 1347,  144,  664,   58,  506, 1602,   57, 1610,  567,
 /*   800 */  1499, 1629, 1627, 1282,  506, 1843, 1498, 1354, 1355,   92,
 /*   810 */  1812,  577, 1814, 1815,  572, 1957,  567, 1952,  125, 1889,
 /*   820 */   610,  209, 1781,  323, 1885, 1971, 1952, 1904,    7, 1495,
 /*   830 */  1958,  162, 1303, 1497, 1946, 1953,  552, 1720, 1720, 1958,
 /*   840 */   162, 1781, 1017, 1018, 1953,  552,  492, 1781,  168,  171,
 /*   850 */   664, 1899,  568, 1277,  606, 1275,  123, 1670,  601,  490,
 /*   860 */   344,  488,   31,   30, 1354, 1355,   38,   36,   34,   33,
 /*   870 */    32,  159, 1897, 1898, 1781, 1902, 1280, 1281,  506, 1329,
 /*   880 */  1330, 1332, 1333, 1334, 1335, 1336, 1337,  569,  565, 1345,
 /*   890 */  1346, 1348, 1349, 1350, 1351, 1353, 1356,  546,   31,   30,
 /*   900 */  1952,  608,   38,   36,   34,   33,   32,   44,  505, 1726,
 /*   910 */  1277,  292, 1275, 1958,  162,  299,  501, 1496, 1953,  552,
 /*   920 */   135,  134,  605,  604,  603,  125,  309,  249,  607, 1811,
 /*   930 */  1493, 1670, 1492, 1280, 1281, 1491, 1329, 1330, 1332, 1333,
 /*   940 */  1334, 1335, 1336, 1337,  569,  565, 1345, 1346, 1348, 1349,
 /*   950 */  1350, 1351, 1353, 1356,   37,   35, 1374, 1829, 1781, 1725,
 /*   960 */  1285,  292,  332,  123, 1276,  574, 1490,  623,  494, 1599,
 /*   970 */  1781, 1781,  573, 1781,  248, 1352, 1781, 1274,  160, 1897,
 /*   980 */  1898,  264, 1902,  470, 1657,  310,  506,  308,  307, 1811,
 /*   990 */   468,  556, 1489,  563,  470, 1843, 1488, 1284, 1347,   92,
 /*  1000 */  1812,  577, 1814, 1815,  572,  469,  567, 1781, 1952, 1889,
 /*  1010 */  1282, 1375,  554,  323, 1885, 1971,  469, 1829, 1909, 1408,
 /*  1020 */   197, 1958,  162,  195, 1908,  574, 1953,  552, 1547,  145,
 /*  1030 */  1781,  558,  573, 1781,  270,    1, 1534, 1781,   31,   30,
 /*  1040 */  1276, 1587,   38,   36,   34,   33,   32,  463,  268,   60,
 /*  1050 */    42,    3,   59, 1274, 1830, 1843,  523,  664,  479,  147,
 /*  1060 */  1812,  577, 1814, 1815,  572, 1529,  567,  384,  176,  424,
 /*  1070 */   422, 1354, 1355,   27,  330, 1369, 1370, 1371, 1372, 1373,
 /*  1080 */  1377, 1378, 1379, 1380, 1627, 1527, 1282,  481, 1487, 1057,
 /*  1090 */   523,  299,  478,  477, 1486, 1811,  240,  523,  523,  121,
 /*  1100 */   199,  399, 1288,  198,   52,  553, 1972,  484,  400,  443,
 /*  1110 */   473,  476,  201,    9,    8,  200,  472, 1277, 1627, 1275,
 /*  1120 */   533, 1485, 1058, 1829, 1314, 1627, 1627,  343,  316, 1781,
 /*  1130 */  1366,  574, 1374,  664,  212, 1781, 1781,   39,  573, 1287,
 /*  1140 */  1280, 1281,   90, 1329, 1330, 1332, 1333, 1334, 1335, 1336,
 /*  1150 */  1337,  569,  565, 1345, 1346, 1348, 1349, 1350, 1351, 1353,
 /*  1160 */  1356, 1843, 1781, 1477, 1478,  286, 1812,  577, 1814, 1815,
 /*  1170 */   572,  203,  567,   74,  202,  217,  129, 1802,   65,   64,
 /*  1180 */   374,  523,  132,  167, 1667,  523,  523, 1375, 1227, 1919,
 /*  1190 */   523,  133,  444, 1277, 1811, 1275, 1624,  495, 1518,  293,
 /*  1200 */   523,  502,  362,  547,  360,  356,  352,  349,  346, 1627,
 /*  1210 */   616,  507,  523, 1627, 1627,  245, 1280, 1281, 1627,   87,
 /*  1220 */   523,    4, 1829,  223, 1804,   54,  221,  516, 1627,   84,
 /*  1230 */   550,  519, 1077,  225,  523, 1781,  232,  573,  251,    2,
 /*  1240 */  1627,  559, 1124,  163,   54,  521,  353, 1811, 1627,   27,
 /*  1250 */   330, 1369, 1370, 1371, 1372, 1373, 1377, 1378, 1379, 1380,
 /*  1260 */  1843, 1811, 1627,  348,   92, 1812,  577, 1814, 1815,  572,
 /*  1270 */   523,  567,   39,  523, 1889, 1829, 1433,   39,  323, 1885,
 /*  1280 */   157,  522,  305,  574,  253,  617, 1243,  235, 1781, 1829,
 /*  1290 */   573,  581,  260,  132,  380, 1382,  170,  574, 1627,  133,
 /*  1300 */  1916, 1627, 1781, 1299,  573,  401, 1722, 1075,  117,  132,
 /*  1310 */   416, 1811,  408, 1843,  415,  417,  421,  277, 1812,  577,
 /*  1320 */  1814,  575,  572, 1338,  567,  423,  425, 1843,  263, 1305,
 /*  1330 */   426,   93, 1812,  577, 1814, 1815,  572, 1811,  567, 1829,
 /*  1340 */   434, 1889, 1152, 1952, 1156,  561, 1885,  574, 1307,  437,
 /*  1350 */  1163, 1811, 1781,  179,  573,  438,  551,  162,  439, 1161,
 /*  1360 */   136, 1953,  552, 1306,  181, 1829, 1308,  440,  184,  442,
 /*  1370 */   524,  186,   69,  574,   70,  446,  190, 1843, 1781, 1829,
 /*  1380 */   573,   93, 1812,  577, 1814, 1815,  572,  574,  567,  465,
 /*  1390 */   523, 1889, 1781,  467,  573,  296, 1886, 1617,  194, 1613,
 /*  1400 */   196,  339,  138, 1843, 1811,  261,  139,  286, 1812,  577,
 /*  1410 */  1814, 1815,  572, 1615,  567,  115, 1611, 1843, 1627,  140,
 /*  1420 */   141,  281, 1812,  577, 1814, 1815,  572,  207,  567,  496,
 /*  1430 */  1811,  210, 1829,  214,  497, 1761,  503,  508,  500,  315,
 /*  1440 */   574,  531,  511, 1760, 1732, 1781,  514,  573,  517,  130,
 /*  1450 */   131,  317,   78, 1304, 1811,  262,   80,  518, 1829,  542,
 /*  1460 */   527,  534, 1628, 1930,  230, 1920,  571,  234,  529,    5,
 /*  1470 */  1843, 1781,  543,  573,  147, 1812,  577, 1814, 1815,  572,
 /*  1480 */   530,  567, 1829, 1929, 1911,  151,  528,  331,  322,  537,
 /*  1490 */   574,  526,  525,  239, 1408, 1781, 1843,  573,  244,  243,
 /*  1500 */   285, 1812,  577, 1814, 1815,  572,  124,  567, 1303, 1862,
 /*  1510 */   241,  242, 1811,  324,   51, 1870,  560, 1905,  557,   82,
 /*  1520 */  1843, 1973,  579,  667,  286, 1812,  577, 1814, 1815,  572,
 /*  1530 */   250,  567, 1671, 1974, 1600, 1951,  265,  259,  660,  256,
 /*  1540 */  1829,  661,  663,   43,  278,  333,  291,  288,  574,  287,
 /*  1550 */   267,  154,  269, 1781, 1775,  573,  657,  653,  649,  645,
 /*  1560 */   257, 1774,   62, 1773, 1811, 1772,   63, 1769,  350,  351,
 /*  1570 */  1268, 1269,  166,  355, 1811, 1767,  357,  358, 1843,  359,
 /*  1580 */  1766,  361,  286, 1812,  577, 1814, 1815,  572, 1765,  567,
 /*  1590 */   363, 1764, 1829,  365, 1763,  367,   89, 1246, 1245,  226,
 /*  1600 */   574, 1743, 1829, 1742,  373, 1781,  372,  573, 1741, 1740,
 /*  1610 */   574, 1715, 1215, 1714, 1713, 1781,  127,  573, 1712, 1711,
 /*  1620 */  1710,   66, 1709, 1708, 1707, 1706, 1811, 1705,  390, 1704,
 /*  1630 */  1843,  391,  520,  393,  271, 1812,  577, 1814, 1815,  572,
 /*  1640 */  1843,  567, 1703, 1702,  272, 1812,  577, 1814, 1815,  572,
 /*  1650 */  1811,  567, 1701, 1700, 1829, 1699, 1698, 1697, 1696, 1695,
 /*  1660 */  1694, 1693,  574, 1692, 1691,  215, 1690, 1781,  128,  573,
 /*  1670 */  1689, 1688, 1687, 1686, 1811, 1685, 1684, 1683, 1829, 1682,
 /*  1680 */  1681, 1680, 1549, 1250, 1217,  208,  574,  174, 1548,  175,
 /*  1690 */  1811, 1781, 1843,  573, 1546, 1514,  273, 1812,  577, 1814,
 /*  1700 */  1815,  572, 1829,  567, 1020, 1019,  118,  177, 1513,  178,
 /*  1710 */   574,  155, 1756,  119, 1750, 1781, 1843,  573, 1829, 1739,
 /*  1720 */   280, 1812,  577, 1814, 1815,  572,  574,  567,  183,  430,
 /*  1730 */  1811, 1781,  432,  573,  185, 1738, 1724, 1606, 1545, 1543,
 /*  1740 */  1843,  447,  449,  448,  282, 1812,  577, 1814, 1815,  572,
 /*  1750 */  1541,  567,  451, 1539,  452, 1050, 1843,  453, 1829,  455,
 /*  1760 */   274, 1812,  577, 1814, 1815,  572,  574,  567,  456,  457,
 /*  1770 */  1537, 1781,  460,  573, 1526,  459, 1525, 1510, 1608, 1167,
 /*  1780 */   461, 1166, 1607, 1811, 1092,  193,   53, 1091,  632,  634,
 /*  1790 */  1088, 1087, 1535, 1086,  311, 1811, 1843, 1530, 1528,  485,
 /*  1800 */   283, 1812,  577, 1814, 1815,  572,  482,  567,  312, 1811,
 /*  1810 */   313, 1829, 1509, 1508,  487,  489, 1507,  491, 1755,  574,
 /*  1820 */    94, 1749, 1252, 1829, 1781,  142,  573,  498, 1737, 1735,
 /*  1830 */  1957,  574, 1736, 1734, 1733,   13, 1781, 1829,  573, 1260,
 /*  1840 */    47,  216, 1731, 1723,  222,  574,  211,   76,   77, 1843,
 /*  1850 */  1781,   79,  573,  275, 1812,  577, 1814, 1815,  572,  499,
 /*  1860 */   567, 1843,  314,  504, 1811,  284, 1812,  577, 1814, 1815,
 /*  1870 */   572,  515,  567,  224,   14, 1843,   84,  227,   39,  276,
 /*  1880 */  1812,  577, 1814, 1815,  572,  512,  567,   21,   50,  237,
 /*  1890 */   238,   23, 1829, 1448,  229, 1802,  231, 1430,  247,   49,
 /*  1900 */   574,  233,   55, 1801, 1432, 1781,  152,  573,  149,   16,
 /*  1910 */   236, 1463, 1811,   22, 1462,  325, 1425,   83, 1467, 1405,
 /*  1920 */  1404, 1466,  326,    8, 1468, 1292, 1367,   17, 1811, 1846,
 /*  1930 */  1843,   48, 1342,  566,  289, 1812,  577, 1814, 1815,  572,
 /*  1940 */  1829,  567,  153,  164, 1340,   15,   11,   29,  574, 1339,
 /*  1950 */  1322,   10, 1811, 1781,   18,  573, 1829,   19,  580, 1153,
 /*  1960 */   576,  334,  582,  578,  574, 1150,  584,  585,  587, 1781,
 /*  1970 */   588,  573, 1147,  590,  593, 1141, 1139, 1130, 1843, 1145,
 /*  1980 */  1829,  591,  290, 1812,  577, 1814, 1815,  572,  574,  567,
 /*  1990 */  1144,  594, 1143, 1781, 1843,  573,  600,   85, 1823, 1812,
 /*  2000 */   577, 1814, 1815,  572, 1811,  567, 1142,   86, 1162,   61,
 /*  2010 */   254, 1158, 1048,  609, 1811, 1083, 1082, 1081, 1843, 1080,
 /*  2020 */  1079, 1078, 1822, 1812,  577, 1814, 1815,  572, 1811,  567,
 /*  2030 */  1076, 1074, 1829, 1073, 1072,  621, 1099,  255, 1070, 1069,
 /*  2040 */   574, 1068, 1829, 1067, 1066, 1781, 1065,  573, 1064, 1063,
 /*  2050 */   574, 1096, 1094, 1060, 1054, 1781, 1829,  573, 1059, 1056,
 /*  2060 */  1055, 1053, 1542,  642,  574, 1540,  644,  643,  646, 1781,
 /*  2070 */  1843,  573, 1538,  648, 1821, 1812,  577, 1814, 1815,  572,
 /*  2080 */  1843,  567,  647,  650,  302, 1812,  577, 1814, 1815,  572,
 /*  2090 */   651,  567,  652, 1536, 1843,  654, 1811,  655,  301, 1812,
 /*  2100 */   577, 1814, 1815,  572, 1524,  567,  656, 1506, 1811,  658,
 /*  2110 */  1010,  258,  662, 1481, 1278,  666,  266,  665, 1811, 1481,
 /*  2120 */  1481, 1481, 1481, 1481, 1829, 1481, 1481, 1481, 1481, 1481,
 /*  2130 */  1481, 1481,  574, 1481, 1481, 1481, 1829, 1781, 1481,  573,
 /*  2140 */  1481, 1481, 1481, 1481,  574, 1481, 1829, 1481, 1481, 1781,
 /*  2150 */  1481,  573, 1481, 1481,  574, 1481, 1481, 1481, 1481, 1781,
 /*  2160 */  1481,  573, 1843, 1481, 1481, 1481,  303, 1812,  577, 1814,
 /*  2170 */  1815,  572, 1481,  567, 1843, 1481, 1481, 1481,  300, 1812,
 /*  2180 */   577, 1814, 1815,  572, 1843,  567, 1481, 1481,  279, 1812,
 /*  2190 */   577, 1814, 1815,  572, 1481,  567,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   316,    0,  318,  319,  312,  316,  342,  318,  319,  355,
 /*    10 */   393,  394,   12,   13,  386,  341,  362,  353,    4,  365,
 /*    20 */    20,  311,   22,  313,  312,   12,   13,   14,   15,   16,
 /*    30 */    20,  332,  340,   33,  351,   35,  408,  354,  355,  340,
 /*    40 */   348,  377,  378,  379,  324,  353,  320,  355,  349,  421,
 /*    50 */   422,  386,  340,  389,  426,  427,   56,  337,   44,   45,
 /*    60 */   348,   61,  354,  355,  322,  353,  346,  355,   68,    0,
 /*    70 */   378,   20,  340,  408,  382,  383,  384,  385,  386,  387,
 /*    80 */   348,  389,  325,  357,  392,  343,  329,  422,  396,  397,
 /*    90 */   378,  426,  427,   93,  382,  383,  384,  385,  386,  387,
 /*   100 */   408,  389,  355,   93,  392,   14,   78,  380,  396,  397,
 /*   110 */    20,   20,  365,  421,  422,  115,  384,   21,  426,  427,
 /*   120 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  129,
 /*   130 */   130,  404,   63,   64,   65,   66,   67,   20,   69,   70,
 /*   140 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   150 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   160 */     2,  133,  134,  339,   33,    0,    8,    9,  326,  327,
 /*   170 */    12,   13,   14,   15,   16,  175,  352,  177,   47,  317,
 /*   180 */   129,  130,  320,   52,   53,   54,   55,   56,   93,   24,
 /*   190 */    25,   26,   27,   28,   29,   30,   31,   32,  198,  199,
 /*   200 */    93,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,   12,
 /*   220 */    13,   14,   93,   92,  326,  327,   95,   20,  320,   22,
 /*   230 */     8,    9,  232,  312,   12,   13,   14,   15,   16,  331,
 /*   240 */    33,   60,   35,  124,  312,  106,  107,  108,  109,  110,
 /*   250 */   111,  112,  113,  114,  115,  116,  348,  118,  119,  120,
 /*   260 */   121,  122,  123,   56,   39,   43,  340,  320,   61,  174,
 /*   270 */   320,  176,  340,  347,  353,   68,   12,   13,  331,  162,
 /*   280 */   348,  331,  356,   20,   20,  353,   22,  355,  338,  158,
 /*   290 */   159,  324,  161,  202,    4,  348,  165,   33,  348,   35,
 /*   300 */    93,    8,    9,  184,  185,   12,   13,   14,   15,   16,
 /*   310 */   378,    0,  181,  346,  382,  383,  384,  385,  386,  387,
 /*   320 */    56,  389,  115,   20,  392,   61,  105,  232,  396,  397,
 /*   330 */   398,  322,   68,   12,   13,   60,  129,  130,    0,  232,
 /*   340 */   342,  125,  410,   22,  335,  124,  125,  126,  127,  128,
 /*   350 */   418,  353,  343,   20,   33,   20,   35,   93,  104,   21,
 /*   360 */   312,  232,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   370 */    32,   60,  340,   64,   65,  377,  378,   56,  332,  115,
 /*   380 */    71,  349,  175,   93,  177,  157,  340,  389,  340,   68,
 /*   390 */    56,   82,   83,  129,  130,  349,  348,   88,  182,  183,
 /*   400 */    20,  353,  186,  355,   20,  198,  199,  198,  201,  202,
 /*   410 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   420 */   213,  214,  215,  216,  217,  218,  378,   93,   93,   95,
 /*   430 */   382,  383,  384,  385,  386,  387,  115,  389,    0,  175,
 /*   440 */   392,  177,  340,  340,  396,  397,  398,  219,  312,  347,
 /*   450 */   241,  242,  243,  244,  245,  407,  231,  229,  356,  356,
 /*   460 */   167,  312,  198,  199,   56,  201,  202,  203,  204,  205,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   480 */   216,  217,  218,   12,   13,   18,   48,   20,  386,  353,
 /*   490 */   368,   20,   20,   22,   27,  162,  175,   30,  177,    4,
 /*   500 */    92,  160,  353,   95,   33,  312,   35,   14,  386,  317,
 /*   510 */   408,   68,  320,   20,   47,  342,   49,  312,   51,  198,
 /*   520 */   199,  309,  232,  421,  422,   22,  353,   56,  426,  427,
 /*   530 */   408,  210,  211,  212,  213,  214,  215,  216,   35,   68,
 /*   540 */     0,  386,   20,  421,  422,  340,  353,  254,  426,  427,
 /*   550 */   377,  378,  379,  348,   20,   20,   22,   22,  353,   92,
 /*   560 */   355,  341,  389,  408,   93,   93,  232,  232,    8,    9,
 /*   570 */    35,  104,   12,   13,   14,   15,   16,  422,  237,  238,
 /*   580 */   368,  426,  427,  378,   50,   50,  115,  382,  383,  384,
 /*   590 */   385,  386,  387,  388,  389,  390,  391,   68,  386,  132,
 /*   600 */   129,  130,  135,  136,  137,  138,  139,  140,  141,  142,
 /*   610 */   143,  144,  145,  146,  147,  148,  149,  150,  151,  152,
 /*   620 */   408,  154,  155,  156,    8,    9,  341,  320,   12,   13,
 /*   630 */    14,   15,   16,  421,  422,  320,    8,    9,  426,  427,
 /*   640 */    12,   13,   14,   15,   16,  105,  175,  380,  177,   14,
 /*   650 */    15,   16,    8,    9,   94,  348,   12,   13,   14,   15,
 /*   660 */    16,    1,    2,  348,  124,  125,  126,  127,  128,  198,
 /*   670 */   199,  404,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   680 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   690 */    12,   13,   14,  386,   35,  202,   14,    0,   20,  312,
 /*   700 */    22,  386,   20,  232,  232,   43,    4,  400,  401,  402,
 /*   710 */   403,   33,  405,   35,  124,  125,  401,  402,  403,    2,
 /*   720 */   405,   19,   94,  408,  202,    8,    9,   68,  233,   12,
 /*   730 */    13,   14,   15,   16,   56,   33,  421,  422,   94,  312,
 /*   740 */   353,  426,  427,  340,   47,  170,   68,   12,   13,   47,
 /*   750 */   347,  320,  342,   51,   94,   20,   94,   22,   56,  356,
 /*   760 */     0,  320,  331,  353,  189,  190,    3,  340,   33,  338,
 /*   770 */    35,   93,  331,  183,  320,  348,  186,  368,  162,  348,
 /*   780 */   353,  312,  355,   43,  332,  331,  368,  377,  378,  348,
 /*   790 */   320,   56,  340,  115,   92,  386,    0,   95,  341,  389,
 /*   800 */   312,  349,  348,   68,  386,  378,  312,  129,  130,  382,
 /*   810 */   383,  384,  385,  386,  387,    3,  389,  408,  348,  392,
 /*   820 */    60,  341,  353,  396,  397,  398,  408,  380,   93,  313,
 /*   830 */   421,  422,   20,  312,  407,  426,  427,  348,  348,  421,
 /*   840 */   422,  353,   44,   45,  426,  427,   21,  353,  359,  359,
 /*   850 */   115,  404,  341,  175,  350,  177,  386,  353,  341,   34,
 /*   860 */   368,   36,    8,    9,  129,  130,   12,   13,   14,   15,
 /*   870 */    16,  401,  402,  403,  353,  405,  198,  199,  386,  201,
 /*   880 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   890 */   212,  213,  214,  215,  216,  217,  218,  320,    8,    9,
 /*   900 */   408,  105,   12,   13,   14,   15,   16,  162,  163,  364,
 /*   910 */   175,  366,  177,  421,  422,   61,  372,  312,  426,  427,
 /*   920 */   124,  125,  126,  127,  128,  348,   37,  430,  350,  312,
 /*   930 */   312,  353,  312,  198,  199,  312,  201,  202,  203,  204,
 /*   940 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   950 */   215,  216,  217,  218,   12,   13,  102,  340,  353,  364,
 /*   960 */    35,  366,   20,  386,   22,  348,  312,  328,  368,  330,
 /*   970 */   353,  353,  355,  353,  162,   33,  353,   35,  401,  402,
 /*   980 */   403,  333,  405,  105,  336,   96,  386,   98,   99,  312,
 /*   990 */   101,  251,  312,   61,  105,  378,  312,   35,   56,  382,
 /*  1000 */   383,  384,  385,  386,  387,  127,  389,  353,  408,  392,
 /*  1010 */    68,  157,  249,  396,  397,  398,  127,  340,  230,  231,
 /*  1020 */    97,  421,  422,  100,  407,  348,  426,  427,    0,   18,
 /*  1030 */   353,   43,  355,  353,   23,   93,    0,  353,    8,    9,
 /*  1040 */    22,  329,   12,   13,   14,   15,   16,  321,   37,   38,
 /*  1050 */    42,   43,   41,   35,  340,  378,  320,  115,   22,  382,
 /*  1060 */   383,  384,  385,  386,  387,    0,  389,  331,   57,   58,
 /*  1070 */    59,  129,  130,  219,  220,  221,  222,  223,  224,  225,
 /*  1080 */   226,  227,  228,  229,  348,    0,   68,   22,  312,   35,
 /*  1090 */   320,   61,   64,   65,  312,  312,  415,  320,  320,   71,
 /*  1100 */    97,  331,  177,  100,   93,  428,  429,   22,  331,  331,
 /*  1110 */    82,   83,   97,    1,    2,  100,   88,  175,  348,  177,
 /*  1120 */   419,  312,   68,  340,   94,  348,  348,  321,  345,  353,
 /*  1130 */   198,  348,  102,  115,   56,  353,  353,   43,  355,  177,
 /*  1140 */   198,  199,  131,  201,  202,  203,  204,  205,  206,  207,
 /*  1150 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*  1160 */   218,  378,  353,  129,  130,  382,  383,  384,  385,  386,
 /*  1170 */   387,   97,  389,   95,  100,   43,   43,   46,  167,  168,
 /*  1180 */   169,  320,   43,  172,  352,  320,  320,  157,   94,  381,
 /*  1190 */   320,   43,  331,  175,  312,  177,  331,  331,  319,  188,
 /*  1200 */   320,  331,  191,  406,  193,  194,  195,  196,  197,  348,
 /*  1210 */    13,  331,  320,  348,  348,  399,  198,  199,  348,   93,
 /*  1220 */   320,  234,  340,  331,   93,   43,   94,   94,  348,  103,
 /*  1230 */   348,  331,   35,   94,  320,  353,   43,  355,  423,  409,
 /*  1240 */   348,  253,   94,  232,   43,  331,   47,  312,  348,  219,
 /*  1250 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*  1260 */   378,  312,  348,  376,  382,  383,  384,  385,  386,  387,
 /*  1270 */   320,  389,   43,  320,  392,  340,   94,   43,  396,  397,
 /*  1280 */   398,  331,  375,  348,  331,   13,  173,   94,  353,  340,
 /*  1290 */   355,   43,  370,   43,  360,   94,   42,  348,  348,   43,
 /*  1300 */   418,  348,  353,   20,  355,  320,  320,   35,   43,   43,
 /*  1310 */   157,  312,  360,  378,  358,  358,  320,  382,  383,  384,
 /*  1320 */   385,  386,  387,   94,  389,  320,  320,  378,   94,   20,
 /*  1330 */   314,  382,  383,  384,  385,  386,  387,  312,  389,  340,
 /*  1340 */   314,  392,   94,  408,   94,  396,  397,  348,   20,  374,
 /*  1350 */    94,  312,  353,  324,  355,  355,  421,  422,  367,   94,
 /*  1360 */    94,  426,  427,   20,  324,  340,   20,  369,  324,  367,
 /*  1370 */   345,  324,  324,  348,  324,  320,  324,  378,  353,  340,
 /*  1380 */   355,  382,  383,  384,  385,  386,  387,  348,  389,  314,
 /*  1390 */   320,  392,  353,  340,  355,  314,  397,  340,  340,  340,
 /*  1400 */   340,  331,  340,  378,  312,  374,  340,  382,  383,  384,
 /*  1410 */   385,  386,  387,  340,  389,  320,  340,  378,  348,  340,
 /*  1420 */   340,  382,  383,  384,  385,  386,  387,  322,  389,  180,
 /*  1430 */   312,  322,  340,  322,  373,  353,  320,  320,  355,  367,
 /*  1440 */   348,  239,  353,  353,  353,  353,  353,  355,  159,  363,
 /*  1450 */   363,  353,  322,   20,  312,  336,  322,  361,  340,  420,
 /*  1460 */   353,  240,  348,  414,  363,  381,  348,  363,  353,  246,
 /*  1470 */   378,  353,  166,  355,  382,  383,  384,  385,  386,  387,
 /*  1480 */   353,  389,  340,  414,  417,  414,  248,  345,  353,  353,
 /*  1490 */   348,  247,  235,  416,  231,  353,  378,  355,  376,  411,
 /*  1500 */   382,  383,  384,  385,  386,  387,  348,  389,   20,  391,
 /*  1510 */   413,  412,  312,  255,   93,  395,  252,  380,  250,   93,
 /*  1520 */   378,  429,  344,   19,  382,  383,  384,  385,  386,  387,
 /*  1530 */   424,  389,  353,  431,  330,  425,  320,   33,   36,  322,
 /*  1540 */   340,  315,  314,  371,  334,  345,  366,  334,  348,  334,
 /*  1550 */   323,   47,  310,  353,    0,  355,   52,   53,   54,   55,
 /*  1560 */    56,    0,  182,    0,  312,    0,   42,    0,   35,  192,
 /*  1570 */    35,   35,   35,  192,  312,    0,   35,   35,  378,  192,
 /*  1580 */     0,  192,  382,  383,  384,  385,  386,  387,    0,  389,
 /*  1590 */    35,    0,  340,   22,    0,   35,   92,  177,  175,   95,
 /*  1600 */   348,    0,  340,    0,  170,  353,  171,  355,    0,    0,
 /*  1610 */   348,    0,   46,    0,    0,  353,   42,  355,    0,    0,
 /*  1620 */     0,  153,    0,    0,    0,    0,  312,    0,  148,    0,
 /*  1630 */   378,   35,  128,  148,  382,  383,  384,  385,  386,  387,
 /*  1640 */   378,  389,    0,    0,  382,  383,  384,  385,  386,  387,
 /*  1650 */   312,  389,    0,    0,  340,    0,    0,    0,    0,    0,
 /*  1660 */     0,    0,  348,    0,    0,  161,    0,  353,   42,  355,
 /*  1670 */     0,    0,    0,    0,  312,    0,    0,    0,  340,    0,
 /*  1680 */     0,    0,    0,  179,   22,  181,  348,   56,    0,   56,
 /*  1690 */   312,  353,  378,  355,    0,    0,  382,  383,  384,  385,
 /*  1700 */   386,  387,  340,  389,   14,   14,   39,   42,    0,   40,
 /*  1710 */   348,   43,    0,   39,    0,  353,  378,  355,  340,    0,
 /*  1720 */   382,  383,  384,  385,  386,  387,  348,  389,   39,   46,
 /*  1730 */   312,  353,   46,  355,  166,    0,    0,    0,    0,    0,
 /*  1740 */   378,   35,   39,   47,  382,  383,  384,  385,  386,  387,
 /*  1750 */     0,  389,   35,    0,   47,   62,  378,   39,  340,   35,
 /*  1760 */   382,  383,  384,  385,  386,  387,  348,  389,   47,   39,
 /*  1770 */     0,  353,   47,  355,    0,   35,    0,    0,    0,   35,
 /*  1780 */    39,   22,    0,  312,   35,  100,  102,   35,   43,   43,
 /*  1790 */    35,   35,    0,   22,   22,  312,  378,    0,    0,   35,
 /*  1800 */   382,  383,  384,  385,  386,  387,   49,  389,   22,  312,
 /*  1810 */    22,  340,    0,    0,   35,   35,    0,   22,    0,  348,
 /*  1820 */    20,    0,   35,  340,  353,  178,  355,   22,    0,    0,
 /*  1830 */     3,  348,    0,    0,    0,   93,  353,  340,  355,   35,
 /*  1840 */   162,   94,    0,    0,   93,  348,  159,   93,   39,  378,
 /*  1850 */   353,   93,  355,  382,  383,  384,  385,  386,  387,  162,
 /*  1860 */   389,  378,  162,  164,  312,  382,  383,  384,  385,  386,
 /*  1870 */   387,  160,  389,  158,  236,  378,  103,   46,   43,  382,
 /*  1880 */   383,  384,  385,  386,  387,  187,  389,   93,   43,   43,
 /*  1890 */    46,   43,  340,   94,   93,   46,   94,   94,   46,   43,
 /*  1900 */   348,   93,    3,   46,   94,  353,   46,  355,   93,   43,
 /*  1910 */    93,   35,  312,   93,   35,   35,   94,   93,   35,   94,
 /*  1920 */    94,   35,   35,    2,   94,   22,  198,   43,  312,   93,
 /*  1930 */   378,  230,   94,   93,  382,  383,  384,  385,  386,  387,
 /*  1940 */   340,  389,   46,   46,   94,  236,  236,   93,  348,   94,
 /*  1950 */    22,   93,  312,  353,   93,  355,  340,   93,   35,   94,
 /*  1960 */   200,   35,   93,  104,  348,   94,   35,   93,   35,  353,
 /*  1970 */    93,  355,   94,   35,   35,   94,   94,   22,  378,  117,
 /*  1980 */   340,   93,  382,  383,  384,  385,  386,  387,  348,  389,
 /*  1990 */   117,   93,  117,  353,  378,  355,  105,   93,  382,  383,
 /*  2000 */   384,  385,  386,  387,  312,  389,  117,   93,   35,   93,
 /*  2010 */    43,   22,   62,   61,  312,   35,   35,   35,  378,   35,
 /*  2020 */    35,   35,  382,  383,  384,  385,  386,  387,  312,  389,
 /*  2030 */    35,   35,  340,   35,   35,   91,   68,   43,   35,   35,
 /*  2040 */   348,   22,  340,   35,   22,  353,   35,  355,   35,   35,
 /*  2050 */   348,   68,   35,   35,   22,  353,  340,  355,   35,   35,
 /*  2060 */    35,   35,    0,   35,  348,    0,   39,   47,   35,  353,
 /*  2070 */   378,  355,    0,   39,  382,  383,  384,  385,  386,  387,
 /*  2080 */   378,  389,   47,   35,  382,  383,  384,  385,  386,  387,
 /*  2090 */    47,  389,   39,    0,  378,   35,  312,   47,  382,  383,
 /*  2100 */   384,  385,  386,  387,    0,  389,   39,    0,  312,   35,
 /*  2110 */    35,   22,   21,  432,   22,   20,   22,   21,  312,  432,
 /*  2120 */   432,  432,  432,  432,  340,  432,  432,  432,  432,  432,
 /*  2130 */   432,  432,  348,  432,  432,  432,  340,  353,  432,  355,
 /*  2140 */   432,  432,  432,  432,  348,  432,  340,  432,  432,  353,
 /*  2150 */   432,  355,  432,  432,  348,  432,  432,  432,  432,  353,
 /*  2160 */   432,  355,  378,  432,  432,  432,  382,  383,  384,  385,
 /*  2170 */   386,  387,  432,  389,  378,  432,  432,  432,  382,  383,
 /*  2180 */   384,  385,  386,  387,  378,  389,  432,  432,  382,  383,
 /*  2190 */   384,  385,  386,  387,  432,  389,  432,  432,  432,  432,
 /*  2200 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2210 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2220 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2230 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2240 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2250 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2260 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2270 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2280 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2290 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2300 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2310 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2320 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2330 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2340 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2350 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2360 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2370 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2380 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2390 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2400 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2410 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*  2420 */   432,  432,  432,  432,  432,  432,  432,
};
#define YY_SHIFT_COUNT    (667)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2107)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1011,    0,  207,  207,  264,  264,  264,  471,  264,  264,
 /*    10 */   678,  735,  942,  735,  735,  735,  735,  735,  735,  735,
 /*    20 */   735,  735,  735,  735,  735,  735,  735,  735,  735,  735,
 /*    30 */   735,  735,  735,  735,  735,  735,  735,  735,  735,  735,
 /*    40 */   335,  472,   10,   95,  334,  107,  129,  107,   10,   10,
 /*    50 */   321,  321,  107,  321,  321,  290,  107,   90,   90,   14,
 /*    60 */    14,   51,   90,   90,   90,   90,   90,   90,   90,   90,
 /*    70 */    90,   90,  181,   90,   90,   90,  263,   90,   90,  303,
 /*    80 */    90,   90,  303,  380,   90,  303,  303,  303,   90,  275,
 /*    90 */   467, 1030,  854,  854,   96, 1018, 1018, 1018, 1018, 1018,
 /*   100 */  1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
 /*   110 */  1018, 1018, 1018, 1018,  889,  309,  812,   51,  682,  682,
 /*   120 */   311,  659,  760,  117,  117,  117,  659,  384,  384,  263,
 /*   130 */     1,    1,  303,  303,  443,  443,  254,  529,  139,  139,
 /*   140 */   139,  139,  139,  139,  139, 1504,  338,  293, 1028,  209,
 /*   150 */   535,  341,   91,  493,  534,  798,  878,  333,  788,  225,
 /*   160 */   788, 1008,  763,  495,  522,  987, 1199, 1113, 1254, 1283,
 /*   170 */  1283, 1254, 1153, 1153, 1283, 1283, 1283, 1309, 1309, 1328,
 /*   180 */   181,  263,  181, 1343, 1346,  181, 1343,  181,  181,  181,
 /*   190 */  1283,  181, 1309,  303,  303,  303,  303,  303,  303,  303,
 /*   200 */   303,  303,  303,  303, 1283, 1309,  443, 1328,  275, 1249,
 /*   210 */   263,  275, 1283, 1283, 1343,  275, 1202,  443,  443,  443,
 /*   220 */   443, 1202,  443, 1289,  275,  254,  275,  384, 1433,  443,
 /*   230 */  1221, 1202,  443,  443, 1221, 1202,  443,  443,  303, 1223,
 /*   240 */  1306, 1221, 1238, 1244, 1257,  987, 1263,  384, 1488, 1258,
 /*   250 */  1264, 1268, 1421, 1426,  443,  529, 1283,  275, 1502, 1309,
 /*   260 */  2196, 2196, 2196, 2196, 2196, 2196, 2196,   69,  131,  165,
 /*   270 */   702,  560,  222,  628,  158,  717,  616,  644,  540,  890,
 /*   280 */   890,  890,  890,  890,  890,  890,  890,  796,  221,   13,
 /*   290 */    13,  216,  590,  575,  408,   28,  825,  119,  660,  228,
 /*   300 */   635,  635,  635,  635,  662,  697,  503,  923, 1003, 1015,
 /*   310 */  1074, 1036, 1065, 1085, 1078,  745, 1094, 1132, 1133, 1139,
 /*   320 */  1148, 1182, 1193, 1112, 1034,  740,  988, 1201,  925,  962,
 /*   330 */   932, 1229, 1131, 1234, 1248, 1250, 1256, 1265, 1266, 1126,
 /*   340 */  1197, 1272, 1054,  438, 1554, 1561, 1380, 1563, 1565, 1524,
 /*   350 */  1567, 1533, 1377, 1535, 1536, 1537, 1381, 1575, 1541, 1542,
 /*   360 */  1387, 1580, 1389, 1588, 1555, 1591, 1571, 1594, 1560, 1420,
 /*   370 */  1423, 1601, 1603, 1435, 1434, 1608, 1609, 1566, 1611, 1613,
 /*   380 */  1614, 1574, 1618, 1619, 1620, 1468, 1622, 1623, 1624, 1625,
 /*   390 */  1627, 1480, 1596, 1629, 1485, 1642, 1643, 1652, 1653, 1655,
 /*   400 */  1656, 1657, 1658, 1659, 1660, 1661, 1663, 1664, 1666, 1626,
 /*   410 */  1670, 1671, 1672, 1673, 1675, 1676, 1662, 1677, 1679, 1680,
 /*   420 */  1681, 1682, 1631, 1688, 1633, 1694, 1695, 1665, 1667, 1668,
 /*   430 */  1690, 1683, 1691, 1686, 1708, 1669, 1674, 1712, 1714, 1719,
 /*   440 */  1689, 1568, 1735, 1736, 1737, 1693, 1738, 1739, 1706, 1696,
 /*   450 */  1703, 1750, 1717, 1707, 1718, 1753, 1724, 1721, 1730, 1770,
 /*   460 */  1740, 1725, 1741, 1774, 1776, 1777, 1778, 1684, 1685, 1744,
 /*   470 */  1759, 1782, 1749, 1752, 1745, 1746, 1755, 1756, 1771, 1792,
 /*   480 */  1772, 1797, 1786, 1757, 1798, 1788, 1764, 1812, 1779, 1813,
 /*   490 */  1780, 1816, 1795, 1800, 1818, 1678, 1787, 1821, 1647, 1805,
 /*   500 */  1697, 1687, 1828, 1829, 1700, 1699, 1827, 1832, 1833, 1834,
 /*   510 */  1742, 1747, 1804, 1698, 1842, 1751, 1711, 1754, 1843, 1809,
 /*   520 */  1715, 1758, 1773, 1831, 1835, 1638, 1794, 1799, 1801, 1802,
 /*   530 */  1803, 1808, 1845, 1810, 1815, 1817, 1820, 1822, 1846, 1844,
 /*   540 */  1849, 1824, 1848, 1709, 1825, 1826, 1852, 1701, 1856, 1857,
 /*   550 */  1860, 1830, 1899, 1866, 1710, 1876, 1879, 1880, 1883, 1886,
 /*   560 */  1887, 1921, 1903, 1728, 1884, 1836, 1838, 1840, 1850, 1854,
 /*   570 */  1855, 1896, 1858, 1861, 1897, 1827, 1928, 1760, 1864, 1859,
 /*   580 */  1865, 1923, 1926, 1869, 1871, 1931, 1874, 1878, 1933, 1877,
 /*   590 */  1881, 1938, 1888, 1882, 1939, 1898, 1862, 1873, 1875, 1889,
 /*   600 */  1955, 1891, 1904, 1914, 1973, 1916, 1967, 1967, 1989, 1950,
 /*   610 */  1952, 1980, 1981, 1982, 1984, 1985, 1986, 1995, 1996, 1998,
 /*   620 */  1999, 1968, 1944, 1994, 2003, 2004, 2019, 2008, 2022, 2011,
 /*   630 */  2013, 2014, 1983, 1745, 2017, 1746, 2018, 2023, 2024, 2025,
 /*   640 */  2032, 2026, 2062, 2028, 2020, 2027, 2065, 2033, 2035, 2034,
 /*   650 */  2072, 2048, 2043, 2053, 2093, 2060, 2050, 2067, 2104, 2074,
 /*   660 */  2075, 2107, 2089, 2091, 2092, 2094, 2096, 2095,
};
#define YY_REDUCE_COUNT (266)
#define YY_REDUCE_MIN   (-383)
#define YY_REDUCE_MAX   (1806)
static const short yy_reduce_ofst[] = {
 /*     0 */   212, -308,  -68,  882,   48,  427,  617,  935, -288,  949,
 /*    10 */   205,  677,  999,  783, 1025, 1039, 1092, 1118, 1142, 1200,
 /*    20 */  1252, 1262, 1314, 1338, 1362, 1378, 1418, 1471, 1483, 1497,
 /*    30 */  1552, 1600, 1616, 1640, 1692, 1702, 1716, 1784, 1796, 1806,
 /*    40 */   315,  102,  307,  122,  409,  418,  492,  600,  470,  577,
 /*    50 */  -336,  173, -372,   -2,  410, -335,  155,  -50,  431, -316,
 /*    60 */  -311, -317,  -92,  -53,  441,  454,  736,  770,  777,  778,
 /*    70 */   861,  865, -280,  866,  870,  880, -346,  892,  900, -301,
 /*    80 */   914,  950,  -74, -268,  953,   46,  403,  452, 1070,    9,
 /*    90 */  -274, -383, -383, -383, -290,  -79,  136,  149,  193,  387,
 /*   100 */   469,  488,  494,  521,  605,  618,  620,  623,  654,  680,
 /*   110 */   684,  776,  782,  809, -176, -243, -273, -292, -138,  192,
 /*   120 */   -33, -158, -258, -273,  267,  447, -102,  489,  490, -253,
 /*   130 */   545,  595,   32,  103,  504,  578,  648,  639, -326,  220,
 /*   140 */   285,  457,  480,  511,  517,  544,  516,  497,  712,  701,
 /*   150 */   726,  681,  714,  714,  806,  879,  832,  808,  797,  797,
 /*   160 */   797,  816,  815,  830,  714,  887,  907,  922,  934,  985,
 /*   170 */   986,  952,  956,  957,  996, 1005, 1006, 1016, 1026,  975,
 /*   180 */  1029, 1000, 1040,  991,  998, 1044, 1002, 1047, 1048, 1050,
 /*   190 */  1055, 1052, 1075, 1053, 1057, 1058, 1059, 1060, 1062, 1066,
 /*   200 */  1073, 1076, 1079, 1080, 1095, 1081, 1082, 1031, 1105, 1061,
 /*   210 */  1083, 1109, 1116, 1117, 1072, 1111, 1086, 1089, 1090, 1091,
 /*   220 */  1093, 1087, 1098, 1096, 1130, 1119, 1134, 1114, 1084, 1107,
 /*   230 */  1049, 1101, 1115, 1127, 1069, 1104, 1135, 1136,  714, 1067,
 /*   240 */  1077, 1071, 1097, 1099, 1088, 1122,  797, 1158, 1137, 1102,
 /*   250 */  1110, 1106, 1120, 1178, 1179, 1204, 1216, 1217, 1226, 1228,
 /*   260 */  1172, 1180, 1210, 1213, 1215, 1227, 1242,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    10 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    20 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    30 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    40 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    50 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    60 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    70 */  1479, 1479, 1553, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*    80 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1551,
 /*    90 */  1716, 1479, 1891, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   100 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   110 */  1479, 1479, 1479, 1479, 1479, 1479, 1903, 1479, 1479, 1479,
 /*   120 */  1553, 1479, 1551, 1903, 1903, 1903, 1479, 1479, 1479, 1479,
 /*   130 */  1757, 1757, 1479, 1479, 1479, 1479, 1656, 1479, 1479, 1479,
 /*   140 */  1479, 1479, 1479, 1479, 1479, 1751, 1479, 1975, 1479, 1479,
 /*   150 */  1479, 1926, 1479, 1479, 1479, 1479, 1609, 1918, 1895, 1909,
 /*   160 */  1896, 1893, 1960, 1912, 1479, 1922, 1479, 1744, 1721, 1479,
 /*   170 */  1479, 1721, 1718, 1718, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   180 */  1553, 1479, 1553, 1479, 1479, 1553, 1479, 1553, 1553, 1553,
 /*   190 */  1479, 1553, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   200 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1551, 1753,
 /*   210 */  1479, 1551, 1479, 1479, 1479, 1551, 1931, 1479, 1479, 1479,
 /*   220 */  1479, 1931, 1479, 1479, 1551, 1479, 1551, 1479, 1479, 1479,
 /*   230 */  1933, 1931, 1479, 1479, 1933, 1931, 1479, 1479, 1479, 1945,
 /*   240 */  1941, 1933, 1949, 1947, 1924, 1922, 1909, 1479, 1479, 1978,
 /*   250 */  1966, 1962, 1479, 1625, 1479, 1479, 1479, 1551, 1511, 1479,
 /*   260 */  1746, 1757, 1659, 1659, 1659, 1554, 1484, 1479, 1479, 1479,
 /*   270 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1828,
 /*   280 */  1944, 1943, 1867, 1866, 1865, 1863, 1827, 1479, 1621, 1826,
 /*   290 */  1825, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   300 */  1819, 1820, 1818, 1817, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   310 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   320 */  1479, 1479, 1479, 1892, 1479, 1963, 1967, 1479, 1479, 1479,
 /*   330 */  1479, 1479, 1803, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   340 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   350 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   360 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   370 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   380 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   390 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   400 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   410 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   420 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1516,
 /*   430 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   440 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   450 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   460 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   470 */  1479, 1479, 1479, 1479, 1592, 1591, 1479, 1479, 1479, 1479,
 /*   480 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   490 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   500 */  1479, 1479, 1479, 1479, 1479, 1479, 1959, 1479, 1479, 1479,
 /*   510 */  1479, 1479, 1479, 1479, 1761, 1479, 1479, 1479, 1479, 1479,
 /*   520 */  1479, 1479, 1479, 1479, 1925, 1479, 1479, 1479, 1479, 1479,
 /*   530 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   540 */  1803, 1479, 1942, 1479, 1902, 1898, 1479, 1479, 1894, 1802,
 /*   550 */  1479, 1479, 1479, 1961, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   560 */  1479, 1887, 1479, 1479, 1860, 1845, 1479, 1479, 1479, 1479,
 /*   570 */  1479, 1479, 1479, 1479, 1479, 1815, 1479, 1813, 1479, 1479,
 /*   580 */  1479, 1479, 1479, 1653, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   590 */  1479, 1479, 1479, 1479, 1479, 1479, 1638, 1636, 1635, 1634,
 /*   600 */  1479, 1631, 1479, 1479, 1479, 1479, 1662, 1661, 1479, 1479,
 /*   610 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   620 */  1479, 1479, 1479, 1573, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   630 */  1479, 1479, 1479, 1564, 1479, 1563, 1479, 1479, 1479, 1479,
 /*   640 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   650 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
 /*   660 */  1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  256,  /*      AFTER => ABORT */
  256,  /*     ATTACH => ABORT */
  256,  /*     BEFORE => ABORT */
  256,  /*      BEGIN => ABORT */
  256,  /*     BITAND => ABORT */
  256,  /*     BITNOT => ABORT */
  256,  /*      BITOR => ABORT */
  256,  /*     BLOCKS => ABORT */
  256,  /*     CHANGE => ABORT */
  256,  /*      COMMA => ABORT */
  256,  /*    COMPACT => ABORT */
  256,  /*     CONCAT => ABORT */
  256,  /*   CONFLICT => ABORT */
  256,  /*       COPY => ABORT */
  256,  /*   DEFERRED => ABORT */
  256,  /* DELIMITERS => ABORT */
  256,  /*     DETACH => ABORT */
  256,  /*     DIVIDE => ABORT */
  256,  /*        DOT => ABORT */
  256,  /*       EACH => ABORT */
  256,  /*        END => ABORT */
  256,  /*       FAIL => ABORT */
  256,  /*       FILE => ABORT */
  256,  /*        FOR => ABORT */
  256,  /*       GLOB => ABORT */
  256,  /*         ID => ABORT */
  256,  /*  IMMEDIATE => ABORT */
  256,  /*     IMPORT => ABORT */
  256,  /*  INITIALLY => ABORT */
  256,  /*    INSTEAD => ABORT */
  256,  /*     ISNULL => ABORT */
  256,  /*        KEY => ABORT */
  256,  /*  NK_BITNOT => ABORT */
  256,  /*    NK_SEMI => ABORT */
  256,  /*    NOTNULL => ABORT */
  256,  /*         OF => ABORT */
  256,  /*       PLUS => ABORT */
  256,  /*  PRIVILEGE => ABORT */
  256,  /*      RAISE => ABORT */
  256,  /*    REPLACE => ABORT */
  256,  /*   RESTRICT => ABORT */
  256,  /*        ROW => ABORT */
  256,  /*       SEMI => ABORT */
  256,  /*       STAR => ABORT */
  256,  /*  STATEMENT => ABORT */
  256,  /*     STRING => ABORT */
  256,  /*      TIMES => ABORT */
  256,  /*     UPDATE => ABORT */
  256,  /*     VALUES => ABORT */
  256,  /*   VARIABLE => ABORT */
  256,  /*       VIEW => ABORT */
  256,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "TABLE",
  /*   93 */ "NK_LP",
  /*   94 */ "NK_RP",
  /*   95 */ "STABLE",
  /*   96 */ "ADD",
  /*   97 */ "COLUMN",
  /*   98 */ "MODIFY",
  /*   99 */ "RENAME",
  /*  100 */ "TAG",
  /*  101 */ "SET",
  /*  102 */ "NK_EQ",
  /*  103 */ "USING",
  /*  104 */ "TAGS",
  /*  105 */ "COMMENT",
  /*  106 */ "BOOL",
  /*  107 */ "TINYINT",
  /*  108 */ "SMALLINT",
  /*  109 */ "INT",
  /*  110 */ "INTEGER",
  /*  111 */ "BIGINT",
  /*  112 */ "FLOAT",
  /*  113 */ "DOUBLE",
  /*  114 */ "BINARY",
  /*  115 */ "TIMESTAMP",
  /*  116 */ "NCHAR",
  /*  117 */ "UNSIGNED",
  /*  118 */ "JSON",
  /*  119 */ "VARCHAR",
  /*  120 */ "MEDIUMBLOB",
  /*  121 */ "BLOB",
  /*  122 */ "VARBINARY",
  /*  123 */ "DECIMAL",
  /*  124 */ "MAX_DELAY",
  /*  125 */ "WATERMARK",
  /*  126 */ "ROLLUP",
  /*  127 */ "TTL",
  /*  128 */ "SMA",
  /*  129 */ "FIRST",
  /*  130 */ "LAST",
  /*  131 */ "SHOW",
  /*  132 */ "DATABASES",
  /*  133 */ "TABLES",
  /*  134 */ "STABLES",
  /*  135 */ "MNODES",
  /*  136 */ "MODULES",
  /*  137 */ "QNODES",
  /*  138 */ "FUNCTIONS",
  /*  139 */ "INDEXES",
  /*  140 */ "ACCOUNTS",
  /*  141 */ "APPS",
  /*  142 */ "CONNECTIONS",
  /*  143 */ "LICENCES",
  /*  144 */ "GRANTS",
  /*  145 */ "QUERIES",
  /*  146 */ "SCORES",
  /*  147 */ "TOPICS",
  /*  148 */ "VARIABLES",
  /*  149 */ "BNODES",
  /*  150 */ "SNODES",
  /*  151 */ "CLUSTER",
  /*  152 */ "TRANSACTIONS",
  /*  153 */ "DISTRIBUTED",
  /*  154 */ "CONSUMERS",
  /*  155 */ "SUBSCRIPTIONS",
  /*  156 */ "VNODES",
  /*  157 */ "LIKE",
  /*  158 */ "INDEX",
  /*  159 */ "FUNCTION",
  /*  160 */ "INTERVAL",
  /*  161 */ "TOPIC",
  /*  162 */ "AS",
  /*  163 */ "WITH",
  /*  164 */ "META",
  /*  165 */ "CONSUMER",
  /*  166 */ "GROUP",
  /*  167 */ "DESC",
  /*  168 */ "DESCRIBE",
  /*  169 */ "RESET",
  /*  170 */ "QUERY",
  /*  171 */ "CACHE",
  /*  172 */ "EXPLAIN",
  /*  173 */ "ANALYZE",
  /*  174 */ "VERBOSE",
  /*  175 */ "NK_BOOL",
  /*  176 */ "RATIO",
  /*  177 */ "NK_FLOAT",
  /*  178 */ "OUTPUTTYPE",
  /*  179 */ "AGGREGATE",
  /*  180 */ "BUFSIZE",
  /*  181 */ "STREAM",
  /*  182 */ "INTO",
  /*  183 */ "TRIGGER",
  /*  184 */ "AT_ONCE",
  /*  185 */ "WINDOW_CLOSE",
  /*  186 */ "IGNORE",
  /*  187 */ "EXPIRED",
  /*  188 */ "KILL",
  /*  189 */ "CONNECTION",
  /*  190 */ "TRANSACTION",
  /*  191 */ "BALANCE",
  /*  192 */ "VGROUP",
  /*  193 */ "MERGE",
  /*  194 */ "REDISTRIBUTE",
  /*  195 */ "SPLIT",
  /*  196 */ "DELETE",
  /*  197 */ "INSERT",
  /*  198 */ "NULL",
  /*  199 */ "NK_QUESTION",
  /*  200 */ "NK_ARROW",
  /*  201 */ "ROWTS",
  /*  202 */ "TBNAME",
  /*  203 */ "QSTART",
  /*  204 */ "QEND",
  /*  205 */ "QDURATION",
  /*  206 */ "WSTART",
  /*  207 */ "WEND",
  /*  208 */ "WDURATION",
  /*  209 */ "CAST",
  /*  210 */ "NOW",
  /*  211 */ "TODAY",
  /*  212 */ "TIMEZONE",
  /*  213 */ "CLIENT_VERSION",
  /*  214 */ "SERVER_VERSION",
  /*  215 */ "SERVER_STATUS",
  /*  216 */ "CURRENT_USER",
  /*  217 */ "COUNT",
  /*  218 */ "LAST_ROW",
  /*  219 */ "BETWEEN",
  /*  220 */ "IS",
  /*  221 */ "NK_LT",
  /*  222 */ "NK_GT",
  /*  223 */ "NK_LE",
  /*  224 */ "NK_GE",
  /*  225 */ "NK_NE",
  /*  226 */ "MATCH",
  /*  227 */ "NMATCH",
  /*  228 */ "CONTAINS",
  /*  229 */ "IN",
  /*  230 */ "JOIN",
  /*  231 */ "INNER",
  /*  232 */ "SELECT",
  /*  233 */ "DISTINCT",
  /*  234 */ "WHERE",
  /*  235 */ "PARTITION",
  /*  236 */ "BY",
  /*  237 */ "SESSION",
  /*  238 */ "STATE_WINDOW",
  /*  239 */ "SLIDING",
  /*  240 */ "FILL",
  /*  241 */ "VALUE",
  /*  242 */ "NONE",
  /*  243 */ "PREV",
  /*  244 */ "LINEAR",
  /*  245 */ "NEXT",
  /*  246 */ "HAVING",
  /*  247 */ "RANGE",
  /*  248 */ "EVERY",
  /*  249 */ "ORDER",
  /*  250 */ "SLIMIT",
  /*  251 */ "SOFFSET",
  /*  252 */ "LIMIT",
  /*  253 */ "OFFSET",
  /*  254 */ "ASC",
  /*  255 */ "NULLS",
  /*  256 */ "ABORT",
  /*  257 */ "AFTER",
  /*  258 */ "ATTACH",
  /*  259 */ "BEFORE",
  /*  260 */ "BEGIN",
  /*  261 */ "BITAND",
  /*  262 */ "BITNOT",
  /*  263 */ "BITOR",
  /*  264 */ "BLOCKS",
  /*  265 */ "CHANGE",
  /*  266 */ "COMMA",
  /*  267 */ "COMPACT",
  /*  268 */ "CONCAT",
  /*  269 */ "CONFLICT",
  /*  270 */ "COPY",
  /*  271 */ "DEFERRED",
  /*  272 */ "DELIMITERS",
  /*  273 */ "DETACH",
  /*  274 */ "DIVIDE",
  /*  275 */ "DOT",
  /*  276 */ "EACH",
  /*  277 */ "END",
  /*  278 */ "FAIL",
  /*  279 */ "FILE",
  /*  280 */ "FOR",
  /*  281 */ "GLOB",
  /*  282 */ "ID",
  /*  283 */ "IMMEDIATE",
  /*  284 */ "IMPORT",
  /*  285 */ "INITIALLY",
  /*  286 */ "INSTEAD",
  /*  287 */ "ISNULL",
  /*  288 */ "KEY",
  /*  289 */ "NK_BITNOT",
  /*  290 */ "NK_SEMI",
  /*  291 */ "NOTNULL",
  /*  292 */ "OF",
  /*  293 */ "PLUS",
  /*  294 */ "PRIVILEGE",
  /*  295 */ "RAISE",
  /*  296 */ "REPLACE",
  /*  297 */ "RESTRICT",
  /*  298 */ "ROW",
  /*  299 */ "SEMI",
  /*  300 */ "STAR",
  /*  301 */ "STATEMENT",
  /*  302 */ "STRING",
  /*  303 */ "TIMES",
  /*  304 */ "UPDATE",
  /*  305 */ "VALUES",
  /*  306 */ "VARIABLE",
  /*  307 */ "VIEW",
  /*  308 */ "WAL",
  /*  309 */ "cmd",
  /*  310 */ "account_options",
  /*  311 */ "alter_account_options",
  /*  312 */ "literal",
  /*  313 */ "alter_account_option",
  /*  314 */ "user_name",
  /*  315 */ "sysinfo_opt",
  /*  316 */ "privileges",
  /*  317 */ "priv_level",
  /*  318 */ "priv_type_list",
  /*  319 */ "priv_type",
  /*  320 */ "db_name",
  /*  321 */ "dnode_endpoint",
  /*  322 */ "not_exists_opt",
  /*  323 */ "db_options",
  /*  324 */ "exists_opt",
  /*  325 */ "alter_db_options",
  /*  326 */ "integer_list",
  /*  327 */ "variable_list",
  /*  328 */ "retention_list",
  /*  329 */ "alter_db_option",
  /*  330 */ "retention",
  /*  331 */ "full_table_name",
  /*  332 */ "column_def_list",
  /*  333 */ "tags_def_opt",
  /*  334 */ "table_options",
  /*  335 */ "multi_create_clause",
  /*  336 */ "tags_def",
  /*  337 */ "multi_drop_clause",
  /*  338 */ "alter_table_clause",
  /*  339 */ "alter_table_options",
  /*  340 */ "column_name",
  /*  341 */ "type_name",
  /*  342 */ "signed_literal",
  /*  343 */ "create_subtable_clause",
  /*  344 */ "specific_cols_opt",
  /*  345 */ "expression_list",
  /*  346 */ "drop_table_clause",
  /*  347 */ "col_name_list",
  /*  348 */ "table_name",
  /*  349 */ "column_def",
  /*  350 */ "duration_list",
  /*  351 */ "rollup_func_list",
  /*  352 */ "alter_table_option",
  /*  353 */ "duration_literal",
  /*  354 */ "rollup_func_name",
  /*  355 */ "function_name",
  /*  356 */ "col_name",
  /*  357 */ "db_name_cond_opt",
  /*  358 */ "like_pattern_opt",
  /*  359 */ "table_name_cond",
  /*  360 */ "from_db_opt",
  /*  361 */ "index_options",
  /*  362 */ "func_list",
  /*  363 */ "sliding_opt",
  /*  364 */ "sma_stream_opt",
  /*  365 */ "func",
  /*  366 */ "stream_options",
  /*  367 */ "topic_name",
  /*  368 */ "query_or_subquery",
  /*  369 */ "cgroup_name",
  /*  370 */ "analyze_opt",
  /*  371 */ "explain_options",
  /*  372 */ "agg_func_opt",
  /*  373 */ "bufsize_opt",
  /*  374 */ "stream_name",
  /*  375 */ "dnode_list",
  /*  376 */ "where_clause_opt",
  /*  377 */ "signed",
  /*  378 */ "literal_func",
  /*  379 */ "literal_list",
  /*  380 */ "table_alias",
  /*  381 */ "column_alias",
  /*  382 */ "expression",
  /*  383 */ "pseudo_column",
  /*  384 */ "column_reference",
  /*  385 */ "function_expression",
  /*  386 */ "subquery",
  /*  387 */ "star_func",
  /*  388 */ "star_func_para_list",
  /*  389 */ "noarg_func",
  /*  390 */ "other_para_list",
  /*  391 */ "star_func_para",
  /*  392 */ "predicate",
  /*  393 */ "compare_op",
  /*  394 */ "in_op",
  /*  395 */ "in_predicate_value",
  /*  396 */ "boolean_value_expression",
  /*  397 */ "boolean_primary",
  /*  398 */ "common_expression",
  /*  399 */ "from_clause_opt",
  /*  400 */ "table_reference_list",
  /*  401 */ "table_reference",
  /*  402 */ "table_primary",
  /*  403 */ "joined_table",
  /*  404 */ "alias_opt",
  /*  405 */ "parenthesized_joined_table",
  /*  406 */ "join_type",
  /*  407 */ "search_condition",
  /*  408 */ "query_specification",
  /*  409 */ "set_quantifier_opt",
  /*  410 */ "select_list",
  /*  411 */ "partition_by_clause_opt",
  /*  412 */ "range_opt",
  /*  413 */ "every_opt",
  /*  414 */ "fill_opt",
  /*  415 */ "twindow_clause_opt",
  /*  416 */ "group_by_clause_opt",
  /*  417 */ "having_clause_opt",
  /*  418 */ "select_item",
  /*  419 */ "fill_mode",
  /*  420 */ "group_by_list",
  /*  421 */ "query_expression",
  /*  422 */ "query_simple",
  /*  423 */ "order_by_clause_opt",
  /*  424 */ "slimit_clause_opt",
  /*  425 */ "limit_clause_opt",
  /*  426 */ "union_query_expression",
  /*  427 */ "query_simple_or_subquery",
  /*  428 */ "sort_specification_list",
  /*  429 */ "sort_specification",
  /*  430 */ "ordering_specification_opt",
  /*  431 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 107 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 108 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "alter_db_option ::= KEEP integer_list",
 /* 110 */ "alter_db_option ::= KEEP variable_list",
 /* 111 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 112 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 113 */ "integer_list ::= NK_INTEGER",
 /* 114 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 115 */ "variable_list ::= NK_VARIABLE",
 /* 116 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 117 */ "retention_list ::= retention",
 /* 118 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 119 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 120 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 121 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 122 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 123 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 124 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 125 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 126 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 127 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 128 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 129 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 130 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 131 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 132 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 134 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 136 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 137 */ "multi_create_clause ::= create_subtable_clause",
 /* 138 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 139 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 140 */ "multi_drop_clause ::= drop_table_clause",
 /* 141 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 142 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 143 */ "specific_cols_opt ::=",
 /* 144 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 145 */ "full_table_name ::= table_name",
 /* 146 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 147 */ "column_def_list ::= column_def",
 /* 148 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 149 */ "column_def ::= column_name type_name",
 /* 150 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 151 */ "type_name ::= BOOL",
 /* 152 */ "type_name ::= TINYINT",
 /* 153 */ "type_name ::= SMALLINT",
 /* 154 */ "type_name ::= INT",
 /* 155 */ "type_name ::= INTEGER",
 /* 156 */ "type_name ::= BIGINT",
 /* 157 */ "type_name ::= FLOAT",
 /* 158 */ "type_name ::= DOUBLE",
 /* 159 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= TIMESTAMP",
 /* 161 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= TINYINT UNSIGNED",
 /* 163 */ "type_name ::= SMALLINT UNSIGNED",
 /* 164 */ "type_name ::= INT UNSIGNED",
 /* 165 */ "type_name ::= BIGINT UNSIGNED",
 /* 166 */ "type_name ::= JSON",
 /* 167 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= MEDIUMBLOB",
 /* 169 */ "type_name ::= BLOB",
 /* 170 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= DECIMAL",
 /* 172 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 173 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 174 */ "tags_def_opt ::=",
 /* 175 */ "tags_def_opt ::= tags_def",
 /* 176 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 177 */ "table_options ::=",
 /* 178 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 179 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 180 */ "table_options ::= table_options WATERMARK duration_list",
 /* 181 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 182 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 183 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 184 */ "alter_table_options ::= alter_table_option",
 /* 185 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 186 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 187 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 188 */ "duration_list ::= duration_literal",
 /* 189 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 190 */ "rollup_func_list ::= rollup_func_name",
 /* 191 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 192 */ "rollup_func_name ::= function_name",
 /* 193 */ "rollup_func_name ::= FIRST",
 /* 194 */ "rollup_func_name ::= LAST",
 /* 195 */ "col_name_list ::= col_name",
 /* 196 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 197 */ "col_name ::= column_name",
 /* 198 */ "cmd ::= SHOW DNODES",
 /* 199 */ "cmd ::= SHOW USERS",
 /* 200 */ "cmd ::= SHOW DATABASES",
 /* 201 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 202 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 203 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 204 */ "cmd ::= SHOW MNODES",
 /* 205 */ "cmd ::= SHOW MODULES",
 /* 206 */ "cmd ::= SHOW QNODES",
 /* 207 */ "cmd ::= SHOW FUNCTIONS",
 /* 208 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 209 */ "cmd ::= SHOW STREAMS",
 /* 210 */ "cmd ::= SHOW ACCOUNTS",
 /* 211 */ "cmd ::= SHOW APPS",
 /* 212 */ "cmd ::= SHOW CONNECTIONS",
 /* 213 */ "cmd ::= SHOW LICENCES",
 /* 214 */ "cmd ::= SHOW GRANTS",
 /* 215 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 216 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 217 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 218 */ "cmd ::= SHOW QUERIES",
 /* 219 */ "cmd ::= SHOW SCORES",
 /* 220 */ "cmd ::= SHOW TOPICS",
 /* 221 */ "cmd ::= SHOW VARIABLES",
 /* 222 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 223 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 224 */ "cmd ::= SHOW BNODES",
 /* 225 */ "cmd ::= SHOW SNODES",
 /* 226 */ "cmd ::= SHOW CLUSTER",
 /* 227 */ "cmd ::= SHOW TRANSACTIONS",
 /* 228 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 229 */ "cmd ::= SHOW CONSUMERS",
 /* 230 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 231 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 232 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 233 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 234 */ "db_name_cond_opt ::=",
 /* 235 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 236 */ "like_pattern_opt ::=",
 /* 237 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 238 */ "table_name_cond ::= table_name",
 /* 239 */ "from_db_opt ::=",
 /* 240 */ "from_db_opt ::= FROM db_name",
 /* 241 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 242 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 243 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 244 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 245 */ "func_list ::= func",
 /* 246 */ "func_list ::= func_list NK_COMMA func",
 /* 247 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 248 */ "sma_stream_opt ::=",
 /* 249 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 250 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 251 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 252 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 253 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 254 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 255 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 256 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 257 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 258 */ "cmd ::= DESC full_table_name",
 /* 259 */ "cmd ::= DESCRIBE full_table_name",
 /* 260 */ "cmd ::= RESET QUERY CACHE",
 /* 261 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 262 */ "analyze_opt ::=",
 /* 263 */ "analyze_opt ::= ANALYZE",
 /* 264 */ "explain_options ::=",
 /* 265 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 266 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 267 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 268 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 269 */ "agg_func_opt ::=",
 /* 270 */ "agg_func_opt ::= AGGREGATE",
 /* 271 */ "bufsize_opt ::=",
 /* 272 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 273 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_or_subquery",
 /* 274 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 275 */ "stream_options ::=",
 /* 276 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 277 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 278 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 279 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 280 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 281 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 282 */ "cmd ::= KILL QUERY NK_STRING",
 /* 283 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 284 */ "cmd ::= BALANCE VGROUP",
 /* 285 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 286 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 287 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 288 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 289 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 290 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 291 */ "cmd ::= query_or_subquery",
 /* 292 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 293 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 294 */ "literal ::= NK_INTEGER",
 /* 295 */ "literal ::= NK_FLOAT",
 /* 296 */ "literal ::= NK_STRING",
 /* 297 */ "literal ::= NK_BOOL",
 /* 298 */ "literal ::= TIMESTAMP NK_STRING",
 /* 299 */ "literal ::= duration_literal",
 /* 300 */ "literal ::= NULL",
 /* 301 */ "literal ::= NK_QUESTION",
 /* 302 */ "duration_literal ::= NK_VARIABLE",
 /* 303 */ "signed ::= NK_INTEGER",
 /* 304 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 305 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 306 */ "signed ::= NK_FLOAT",
 /* 307 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 308 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 309 */ "signed_literal ::= signed",
 /* 310 */ "signed_literal ::= NK_STRING",
 /* 311 */ "signed_literal ::= NK_BOOL",
 /* 312 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 313 */ "signed_literal ::= duration_literal",
 /* 314 */ "signed_literal ::= NULL",
 /* 315 */ "signed_literal ::= literal_func",
 /* 316 */ "signed_literal ::= NK_QUESTION",
 /* 317 */ "literal_list ::= signed_literal",
 /* 318 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 319 */ "db_name ::= NK_ID",
 /* 320 */ "table_name ::= NK_ID",
 /* 321 */ "column_name ::= NK_ID",
 /* 322 */ "function_name ::= NK_ID",
 /* 323 */ "table_alias ::= NK_ID",
 /* 324 */ "column_alias ::= NK_ID",
 /* 325 */ "user_name ::= NK_ID",
 /* 326 */ "topic_name ::= NK_ID",
 /* 327 */ "stream_name ::= NK_ID",
 /* 328 */ "cgroup_name ::= NK_ID",
 /* 329 */ "expression ::= literal",
 /* 330 */ "expression ::= pseudo_column",
 /* 331 */ "expression ::= column_reference",
 /* 332 */ "expression ::= function_expression",
 /* 333 */ "expression ::= subquery",
 /* 334 */ "expression ::= NK_LP expression NK_RP",
 /* 335 */ "expression ::= NK_PLUS expression",
 /* 336 */ "expression ::= NK_MINUS expression",
 /* 337 */ "expression ::= expression NK_PLUS expression",
 /* 338 */ "expression ::= expression NK_MINUS expression",
 /* 339 */ "expression ::= expression NK_STAR expression",
 /* 340 */ "expression ::= expression NK_SLASH expression",
 /* 341 */ "expression ::= expression NK_REM expression",
 /* 342 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 343 */ "expression ::= expression NK_BITAND expression",
 /* 344 */ "expression ::= expression NK_BITOR expression",
 /* 345 */ "expression_list ::= expression",
 /* 346 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 347 */ "column_reference ::= column_name",
 /* 348 */ "column_reference ::= table_name NK_DOT column_name",
 /* 349 */ "pseudo_column ::= ROWTS",
 /* 350 */ "pseudo_column ::= TBNAME",
 /* 351 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 352 */ "pseudo_column ::= QSTART",
 /* 353 */ "pseudo_column ::= QEND",
 /* 354 */ "pseudo_column ::= QDURATION",
 /* 355 */ "pseudo_column ::= WSTART",
 /* 356 */ "pseudo_column ::= WEND",
 /* 357 */ "pseudo_column ::= WDURATION",
 /* 358 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 359 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 360 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 361 */ "function_expression ::= literal_func",
 /* 362 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 363 */ "literal_func ::= NOW",
 /* 364 */ "noarg_func ::= NOW",
 /* 365 */ "noarg_func ::= TODAY",
 /* 366 */ "noarg_func ::= TIMEZONE",
 /* 367 */ "noarg_func ::= DATABASE",
 /* 368 */ "noarg_func ::= CLIENT_VERSION",
 /* 369 */ "noarg_func ::= SERVER_VERSION",
 /* 370 */ "noarg_func ::= SERVER_STATUS",
 /* 371 */ "noarg_func ::= CURRENT_USER",
 /* 372 */ "noarg_func ::= USER",
 /* 373 */ "star_func ::= COUNT",
 /* 374 */ "star_func ::= FIRST",
 /* 375 */ "star_func ::= LAST",
 /* 376 */ "star_func ::= LAST_ROW",
 /* 377 */ "star_func_para_list ::= NK_STAR",
 /* 378 */ "star_func_para_list ::= other_para_list",
 /* 379 */ "other_para_list ::= star_func_para",
 /* 380 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 381 */ "star_func_para ::= expression",
 /* 382 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 383 */ "predicate ::= expression compare_op expression",
 /* 384 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 385 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 386 */ "predicate ::= expression IS NULL",
 /* 387 */ "predicate ::= expression IS NOT NULL",
 /* 388 */ "predicate ::= expression in_op in_predicate_value",
 /* 389 */ "compare_op ::= NK_LT",
 /* 390 */ "compare_op ::= NK_GT",
 /* 391 */ "compare_op ::= NK_LE",
 /* 392 */ "compare_op ::= NK_GE",
 /* 393 */ "compare_op ::= NK_NE",
 /* 394 */ "compare_op ::= NK_EQ",
 /* 395 */ "compare_op ::= LIKE",
 /* 396 */ "compare_op ::= NOT LIKE",
 /* 397 */ "compare_op ::= MATCH",
 /* 398 */ "compare_op ::= NMATCH",
 /* 399 */ "compare_op ::= CONTAINS",
 /* 400 */ "in_op ::= IN",
 /* 401 */ "in_op ::= NOT IN",
 /* 402 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 403 */ "boolean_value_expression ::= boolean_primary",
 /* 404 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 405 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 406 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 407 */ "boolean_primary ::= predicate",
 /* 408 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 409 */ "common_expression ::= expression",
 /* 410 */ "common_expression ::= boolean_value_expression",
 /* 411 */ "from_clause_opt ::=",
 /* 412 */ "from_clause_opt ::= FROM table_reference_list",
 /* 413 */ "table_reference_list ::= table_reference",
 /* 414 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 415 */ "table_reference ::= table_primary",
 /* 416 */ "table_reference ::= joined_table",
 /* 417 */ "table_primary ::= table_name alias_opt",
 /* 418 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 419 */ "table_primary ::= subquery alias_opt",
 /* 420 */ "table_primary ::= parenthesized_joined_table",
 /* 421 */ "alias_opt ::=",
 /* 422 */ "alias_opt ::= table_alias",
 /* 423 */ "alias_opt ::= AS table_alias",
 /* 424 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 425 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 426 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 427 */ "join_type ::=",
 /* 428 */ "join_type ::= INNER",
 /* 429 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 430 */ "set_quantifier_opt ::=",
 /* 431 */ "set_quantifier_opt ::= DISTINCT",
 /* 432 */ "set_quantifier_opt ::= ALL",
 /* 433 */ "select_list ::= select_item",
 /* 434 */ "select_list ::= select_list NK_COMMA select_item",
 /* 435 */ "select_item ::= NK_STAR",
 /* 436 */ "select_item ::= common_expression",
 /* 437 */ "select_item ::= common_expression column_alias",
 /* 438 */ "select_item ::= common_expression AS column_alias",
 /* 439 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 440 */ "where_clause_opt ::=",
 /* 441 */ "where_clause_opt ::= WHERE search_condition",
 /* 442 */ "partition_by_clause_opt ::=",
 /* 443 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 444 */ "twindow_clause_opt ::=",
 /* 445 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 446 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 447 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 448 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 449 */ "sliding_opt ::=",
 /* 450 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 451 */ "fill_opt ::=",
 /* 452 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 453 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 454 */ "fill_mode ::= NONE",
 /* 455 */ "fill_mode ::= PREV",
 /* 456 */ "fill_mode ::= NULL",
 /* 457 */ "fill_mode ::= LINEAR",
 /* 458 */ "fill_mode ::= NEXT",
 /* 459 */ "group_by_clause_opt ::=",
 /* 460 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 461 */ "group_by_list ::= expression",
 /* 462 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 463 */ "having_clause_opt ::=",
 /* 464 */ "having_clause_opt ::= HAVING search_condition",
 /* 465 */ "range_opt ::=",
 /* 466 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 467 */ "every_opt ::=",
 /* 468 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 469 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 470 */ "query_simple ::= query_specification",
 /* 471 */ "query_simple ::= union_query_expression",
 /* 472 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 473 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 474 */ "query_simple_or_subquery ::= query_simple",
 /* 475 */ "query_simple_or_subquery ::= subquery",
 /* 476 */ "query_or_subquery ::= query_expression",
 /* 477 */ "query_or_subquery ::= subquery",
 /* 478 */ "order_by_clause_opt ::=",
 /* 479 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 480 */ "slimit_clause_opt ::=",
 /* 481 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 482 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 483 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 484 */ "limit_clause_opt ::=",
 /* 485 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 486 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 487 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 488 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 489 */ "search_condition ::= common_expression",
 /* 490 */ "sort_specification_list ::= sort_specification",
 /* 491 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 492 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 493 */ "ordering_specification_opt ::=",
 /* 494 */ "ordering_specification_opt ::= ASC",
 /* 495 */ "ordering_specification_opt ::= DESC",
 /* 496 */ "null_ordering_opt ::=",
 /* 497 */ "null_ordering_opt ::= NULLS FIRST",
 /* 498 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 309: /* cmd */
    case 312: /* literal */
    case 323: /* db_options */
    case 325: /* alter_db_options */
    case 330: /* retention */
    case 331: /* full_table_name */
    case 334: /* table_options */
    case 338: /* alter_table_clause */
    case 339: /* alter_table_options */
    case 342: /* signed_literal */
    case 343: /* create_subtable_clause */
    case 346: /* drop_table_clause */
    case 349: /* column_def */
    case 353: /* duration_literal */
    case 354: /* rollup_func_name */
    case 356: /* col_name */
    case 357: /* db_name_cond_opt */
    case 358: /* like_pattern_opt */
    case 359: /* table_name_cond */
    case 360: /* from_db_opt */
    case 361: /* index_options */
    case 363: /* sliding_opt */
    case 364: /* sma_stream_opt */
    case 365: /* func */
    case 366: /* stream_options */
    case 368: /* query_or_subquery */
    case 371: /* explain_options */
    case 376: /* where_clause_opt */
    case 377: /* signed */
    case 378: /* literal_func */
    case 382: /* expression */
    case 383: /* pseudo_column */
    case 384: /* column_reference */
    case 385: /* function_expression */
    case 386: /* subquery */
    case 391: /* star_func_para */
    case 392: /* predicate */
    case 395: /* in_predicate_value */
    case 396: /* boolean_value_expression */
    case 397: /* boolean_primary */
    case 398: /* common_expression */
    case 399: /* from_clause_opt */
    case 400: /* table_reference_list */
    case 401: /* table_reference */
    case 402: /* table_primary */
    case 403: /* joined_table */
    case 405: /* parenthesized_joined_table */
    case 407: /* search_condition */
    case 408: /* query_specification */
    case 412: /* range_opt */
    case 413: /* every_opt */
    case 414: /* fill_opt */
    case 415: /* twindow_clause_opt */
    case 417: /* having_clause_opt */
    case 418: /* select_item */
    case 421: /* query_expression */
    case 422: /* query_simple */
    case 424: /* slimit_clause_opt */
    case 425: /* limit_clause_opt */
    case 426: /* union_query_expression */
    case 427: /* query_simple_or_subquery */
    case 429: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy776)); 
}
      break;
    case 310: /* account_options */
    case 311: /* alter_account_options */
    case 313: /* alter_account_option */
    case 373: /* bufsize_opt */
{
 
}
      break;
    case 314: /* user_name */
    case 317: /* priv_level */
    case 320: /* db_name */
    case 321: /* dnode_endpoint */
    case 340: /* column_name */
    case 348: /* table_name */
    case 355: /* function_name */
    case 367: /* topic_name */
    case 369: /* cgroup_name */
    case 374: /* stream_name */
    case 380: /* table_alias */
    case 381: /* column_alias */
    case 387: /* star_func */
    case 389: /* noarg_func */
    case 404: /* alias_opt */
{
 
}
      break;
    case 315: /* sysinfo_opt */
{
 
}
      break;
    case 316: /* privileges */
    case 318: /* priv_type_list */
    case 319: /* priv_type */
{
 
}
      break;
    case 322: /* not_exists_opt */
    case 324: /* exists_opt */
    case 370: /* analyze_opt */
    case 372: /* agg_func_opt */
    case 409: /* set_quantifier_opt */
{
 
}
      break;
    case 326: /* integer_list */
    case 327: /* variable_list */
    case 328: /* retention_list */
    case 332: /* column_def_list */
    case 333: /* tags_def_opt */
    case 335: /* multi_create_clause */
    case 336: /* tags_def */
    case 337: /* multi_drop_clause */
    case 344: /* specific_cols_opt */
    case 345: /* expression_list */
    case 347: /* col_name_list */
    case 350: /* duration_list */
    case 351: /* rollup_func_list */
    case 362: /* func_list */
    case 375: /* dnode_list */
    case 379: /* literal_list */
    case 388: /* star_func_para_list */
    case 390: /* other_para_list */
    case 410: /* select_list */
    case 411: /* partition_by_clause_opt */
    case 416: /* group_by_clause_opt */
    case 420: /* group_by_list */
    case 423: /* order_by_clause_opt */
    case 428: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy280)); 
}
      break;
    case 329: /* alter_db_option */
    case 352: /* alter_table_option */
{
 
}
      break;
    case 341: /* type_name */
{
 
}
      break;
    case 393: /* compare_op */
    case 394: /* in_op */
{
 
}
      break;
    case 406: /* join_type */
{
 
}
      break;
    case 419: /* fill_mode */
{
 
}
      break;
    case 430: /* ordering_specification_opt */
{
 
}
      break;
    case 431: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  309,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  309,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  310,    0 }, /* (2) account_options ::= */
  {  310,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  310,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  310,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  310,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  310,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  310,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  310,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  310,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  310,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  311,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  311,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  313,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  313,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  313,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  313,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  313,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  313,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  313,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  313,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  313,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  313,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  309,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  309,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  309,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  309,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  309,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  315,    0 }, /* (29) sysinfo_opt ::= */
  {  315,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  309,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  309,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  316,   -1 }, /* (33) privileges ::= ALL */
  {  316,   -1 }, /* (34) privileges ::= priv_type_list */
  {  318,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  318,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  319,   -1 }, /* (37) priv_type ::= READ */
  {  319,   -1 }, /* (38) priv_type ::= WRITE */
  {  317,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  317,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  309,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  309,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  309,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  309,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  309,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  309,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  309,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  309,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  321,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  321,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  321,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  309,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  309,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  309,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  309,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  309,   -2 }, /* (64) cmd ::= USE db_name */
  {  309,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  309,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  309,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  322,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  322,    0 }, /* (69) not_exists_opt ::= */
  {  324,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  324,    0 }, /* (71) exists_opt ::= */
  {  323,    0 }, /* (72) db_options ::= */
  {  323,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  323,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  323,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  323,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  323,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  323,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  323,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  323,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  323,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  323,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  323,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  323,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  323,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  323,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  323,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  323,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  323,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  323,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  323,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  323,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  323,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  323,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  323,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  323,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  323,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  323,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  323,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  323,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  323,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  323,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  323,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  325,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  325,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  329,   -2 }, /* (106) alter_db_option ::= CACHEMODEL NK_STRING */
  {  329,   -2 }, /* (107) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  329,   -2 }, /* (108) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  329,   -2 }, /* (109) alter_db_option ::= KEEP integer_list */
  {  329,   -2 }, /* (110) alter_db_option ::= KEEP variable_list */
  {  329,   -2 }, /* (111) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  329,   -2 }, /* (112) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  326,   -1 }, /* (113) integer_list ::= NK_INTEGER */
  {  326,   -3 }, /* (114) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  327,   -1 }, /* (115) variable_list ::= NK_VARIABLE */
  {  327,   -3 }, /* (116) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  328,   -1 }, /* (117) retention_list ::= retention */
  {  328,   -3 }, /* (118) retention_list ::= retention_list NK_COMMA retention */
  {  330,   -3 }, /* (119) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  309,   -9 }, /* (120) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  309,   -3 }, /* (121) cmd ::= CREATE TABLE multi_create_clause */
  {  309,   -9 }, /* (122) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  309,   -3 }, /* (123) cmd ::= DROP TABLE multi_drop_clause */
  {  309,   -4 }, /* (124) cmd ::= DROP STABLE exists_opt full_table_name */
  {  309,   -3 }, /* (125) cmd ::= ALTER TABLE alter_table_clause */
  {  309,   -3 }, /* (126) cmd ::= ALTER STABLE alter_table_clause */
  {  338,   -2 }, /* (127) alter_table_clause ::= full_table_name alter_table_options */
  {  338,   -5 }, /* (128) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  338,   -4 }, /* (129) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  338,   -5 }, /* (130) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  338,   -5 }, /* (131) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  338,   -5 }, /* (132) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  338,   -4 }, /* (133) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  338,   -5 }, /* (134) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  338,   -5 }, /* (135) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  338,   -6 }, /* (136) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  335,   -1 }, /* (137) multi_create_clause ::= create_subtable_clause */
  {  335,   -2 }, /* (138) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  343,  -10 }, /* (139) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  337,   -1 }, /* (140) multi_drop_clause ::= drop_table_clause */
  {  337,   -2 }, /* (141) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  346,   -2 }, /* (142) drop_table_clause ::= exists_opt full_table_name */
  {  344,    0 }, /* (143) specific_cols_opt ::= */
  {  344,   -3 }, /* (144) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  331,   -1 }, /* (145) full_table_name ::= table_name */
  {  331,   -3 }, /* (146) full_table_name ::= db_name NK_DOT table_name */
  {  332,   -1 }, /* (147) column_def_list ::= column_def */
  {  332,   -3 }, /* (148) column_def_list ::= column_def_list NK_COMMA column_def */
  {  349,   -2 }, /* (149) column_def ::= column_name type_name */
  {  349,   -4 }, /* (150) column_def ::= column_name type_name COMMENT NK_STRING */
  {  341,   -1 }, /* (151) type_name ::= BOOL */
  {  341,   -1 }, /* (152) type_name ::= TINYINT */
  {  341,   -1 }, /* (153) type_name ::= SMALLINT */
  {  341,   -1 }, /* (154) type_name ::= INT */
  {  341,   -1 }, /* (155) type_name ::= INTEGER */
  {  341,   -1 }, /* (156) type_name ::= BIGINT */
  {  341,   -1 }, /* (157) type_name ::= FLOAT */
  {  341,   -1 }, /* (158) type_name ::= DOUBLE */
  {  341,   -4 }, /* (159) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  341,   -1 }, /* (160) type_name ::= TIMESTAMP */
  {  341,   -4 }, /* (161) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  341,   -2 }, /* (162) type_name ::= TINYINT UNSIGNED */
  {  341,   -2 }, /* (163) type_name ::= SMALLINT UNSIGNED */
  {  341,   -2 }, /* (164) type_name ::= INT UNSIGNED */
  {  341,   -2 }, /* (165) type_name ::= BIGINT UNSIGNED */
  {  341,   -1 }, /* (166) type_name ::= JSON */
  {  341,   -4 }, /* (167) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  341,   -1 }, /* (168) type_name ::= MEDIUMBLOB */
  {  341,   -1 }, /* (169) type_name ::= BLOB */
  {  341,   -4 }, /* (170) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  341,   -1 }, /* (171) type_name ::= DECIMAL */
  {  341,   -4 }, /* (172) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  341,   -6 }, /* (173) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  333,    0 }, /* (174) tags_def_opt ::= */
  {  333,   -1 }, /* (175) tags_def_opt ::= tags_def */
  {  336,   -4 }, /* (176) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  334,    0 }, /* (177) table_options ::= */
  {  334,   -3 }, /* (178) table_options ::= table_options COMMENT NK_STRING */
  {  334,   -3 }, /* (179) table_options ::= table_options MAX_DELAY duration_list */
  {  334,   -3 }, /* (180) table_options ::= table_options WATERMARK duration_list */
  {  334,   -5 }, /* (181) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  334,   -3 }, /* (182) table_options ::= table_options TTL NK_INTEGER */
  {  334,   -5 }, /* (183) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  339,   -1 }, /* (184) alter_table_options ::= alter_table_option */
  {  339,   -2 }, /* (185) alter_table_options ::= alter_table_options alter_table_option */
  {  352,   -2 }, /* (186) alter_table_option ::= COMMENT NK_STRING */
  {  352,   -2 }, /* (187) alter_table_option ::= TTL NK_INTEGER */
  {  350,   -1 }, /* (188) duration_list ::= duration_literal */
  {  350,   -3 }, /* (189) duration_list ::= duration_list NK_COMMA duration_literal */
  {  351,   -1 }, /* (190) rollup_func_list ::= rollup_func_name */
  {  351,   -3 }, /* (191) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  354,   -1 }, /* (192) rollup_func_name ::= function_name */
  {  354,   -1 }, /* (193) rollup_func_name ::= FIRST */
  {  354,   -1 }, /* (194) rollup_func_name ::= LAST */
  {  347,   -1 }, /* (195) col_name_list ::= col_name */
  {  347,   -3 }, /* (196) col_name_list ::= col_name_list NK_COMMA col_name */
  {  356,   -1 }, /* (197) col_name ::= column_name */
  {  309,   -2 }, /* (198) cmd ::= SHOW DNODES */
  {  309,   -2 }, /* (199) cmd ::= SHOW USERS */
  {  309,   -2 }, /* (200) cmd ::= SHOW DATABASES */
  {  309,   -4 }, /* (201) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  309,   -4 }, /* (202) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  309,   -3 }, /* (203) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  309,   -2 }, /* (204) cmd ::= SHOW MNODES */
  {  309,   -2 }, /* (205) cmd ::= SHOW MODULES */
  {  309,   -2 }, /* (206) cmd ::= SHOW QNODES */
  {  309,   -2 }, /* (207) cmd ::= SHOW FUNCTIONS */
  {  309,   -5 }, /* (208) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  309,   -2 }, /* (209) cmd ::= SHOW STREAMS */
  {  309,   -2 }, /* (210) cmd ::= SHOW ACCOUNTS */
  {  309,   -2 }, /* (211) cmd ::= SHOW APPS */
  {  309,   -2 }, /* (212) cmd ::= SHOW CONNECTIONS */
  {  309,   -2 }, /* (213) cmd ::= SHOW LICENCES */
  {  309,   -2 }, /* (214) cmd ::= SHOW GRANTS */
  {  309,   -4 }, /* (215) cmd ::= SHOW CREATE DATABASE db_name */
  {  309,   -4 }, /* (216) cmd ::= SHOW CREATE TABLE full_table_name */
  {  309,   -4 }, /* (217) cmd ::= SHOW CREATE STABLE full_table_name */
  {  309,   -2 }, /* (218) cmd ::= SHOW QUERIES */
  {  309,   -2 }, /* (219) cmd ::= SHOW SCORES */
  {  309,   -2 }, /* (220) cmd ::= SHOW TOPICS */
  {  309,   -2 }, /* (221) cmd ::= SHOW VARIABLES */
  {  309,   -3 }, /* (222) cmd ::= SHOW LOCAL VARIABLES */
  {  309,   -4 }, /* (223) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  309,   -2 }, /* (224) cmd ::= SHOW BNODES */
  {  309,   -2 }, /* (225) cmd ::= SHOW SNODES */
  {  309,   -2 }, /* (226) cmd ::= SHOW CLUSTER */
  {  309,   -2 }, /* (227) cmd ::= SHOW TRANSACTIONS */
  {  309,   -4 }, /* (228) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  309,   -2 }, /* (229) cmd ::= SHOW CONSUMERS */
  {  309,   -2 }, /* (230) cmd ::= SHOW SUBSCRIPTIONS */
  {  309,   -5 }, /* (231) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  309,   -3 }, /* (232) cmd ::= SHOW VNODES NK_INTEGER */
  {  309,   -3 }, /* (233) cmd ::= SHOW VNODES NK_STRING */
  {  357,    0 }, /* (234) db_name_cond_opt ::= */
  {  357,   -2 }, /* (235) db_name_cond_opt ::= db_name NK_DOT */
  {  358,    0 }, /* (236) like_pattern_opt ::= */
  {  358,   -2 }, /* (237) like_pattern_opt ::= LIKE NK_STRING */
  {  359,   -1 }, /* (238) table_name_cond ::= table_name */
  {  360,    0 }, /* (239) from_db_opt ::= */
  {  360,   -2 }, /* (240) from_db_opt ::= FROM db_name */
  {  309,   -8 }, /* (241) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  309,   -4 }, /* (242) cmd ::= DROP INDEX exists_opt full_table_name */
  {  361,  -10 }, /* (243) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  361,  -12 }, /* (244) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  362,   -1 }, /* (245) func_list ::= func */
  {  362,   -3 }, /* (246) func_list ::= func_list NK_COMMA func */
  {  365,   -4 }, /* (247) func ::= function_name NK_LP expression_list NK_RP */
  {  364,    0 }, /* (248) sma_stream_opt ::= */
  {  364,   -3 }, /* (249) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  364,   -3 }, /* (250) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  309,   -6 }, /* (251) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  309,   -7 }, /* (252) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  309,   -9 }, /* (253) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  309,   -7 }, /* (254) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  309,   -9 }, /* (255) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  309,   -4 }, /* (256) cmd ::= DROP TOPIC exists_opt topic_name */
  {  309,   -7 }, /* (257) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  309,   -2 }, /* (258) cmd ::= DESC full_table_name */
  {  309,   -2 }, /* (259) cmd ::= DESCRIBE full_table_name */
  {  309,   -3 }, /* (260) cmd ::= RESET QUERY CACHE */
  {  309,   -4 }, /* (261) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  370,    0 }, /* (262) analyze_opt ::= */
  {  370,   -1 }, /* (263) analyze_opt ::= ANALYZE */
  {  371,    0 }, /* (264) explain_options ::= */
  {  371,   -3 }, /* (265) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  371,   -3 }, /* (266) explain_options ::= explain_options RATIO NK_FLOAT */
  {  309,  -10 }, /* (267) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  309,   -4 }, /* (268) cmd ::= DROP FUNCTION exists_opt function_name */
  {  372,    0 }, /* (269) agg_func_opt ::= */
  {  372,   -1 }, /* (270) agg_func_opt ::= AGGREGATE */
  {  373,    0 }, /* (271) bufsize_opt ::= */
  {  373,   -2 }, /* (272) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  309,   -9 }, /* (273) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_or_subquery */
  {  309,   -4 }, /* (274) cmd ::= DROP STREAM exists_opt stream_name */
  {  366,    0 }, /* (275) stream_options ::= */
  {  366,   -3 }, /* (276) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  366,   -3 }, /* (277) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  366,   -4 }, /* (278) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  366,   -3 }, /* (279) stream_options ::= stream_options WATERMARK duration_literal */
  {  366,   -4 }, /* (280) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  309,   -3 }, /* (281) cmd ::= KILL CONNECTION NK_INTEGER */
  {  309,   -3 }, /* (282) cmd ::= KILL QUERY NK_STRING */
  {  309,   -3 }, /* (283) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  309,   -2 }, /* (284) cmd ::= BALANCE VGROUP */
  {  309,   -4 }, /* (285) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  309,   -4 }, /* (286) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  309,   -3 }, /* (287) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  375,   -2 }, /* (288) dnode_list ::= DNODE NK_INTEGER */
  {  375,   -3 }, /* (289) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  309,   -4 }, /* (290) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  309,   -1 }, /* (291) cmd ::= query_or_subquery */
  {  309,   -7 }, /* (292) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  309,   -4 }, /* (293) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  312,   -1 }, /* (294) literal ::= NK_INTEGER */
  {  312,   -1 }, /* (295) literal ::= NK_FLOAT */
  {  312,   -1 }, /* (296) literal ::= NK_STRING */
  {  312,   -1 }, /* (297) literal ::= NK_BOOL */
  {  312,   -2 }, /* (298) literal ::= TIMESTAMP NK_STRING */
  {  312,   -1 }, /* (299) literal ::= duration_literal */
  {  312,   -1 }, /* (300) literal ::= NULL */
  {  312,   -1 }, /* (301) literal ::= NK_QUESTION */
  {  353,   -1 }, /* (302) duration_literal ::= NK_VARIABLE */
  {  377,   -1 }, /* (303) signed ::= NK_INTEGER */
  {  377,   -2 }, /* (304) signed ::= NK_PLUS NK_INTEGER */
  {  377,   -2 }, /* (305) signed ::= NK_MINUS NK_INTEGER */
  {  377,   -1 }, /* (306) signed ::= NK_FLOAT */
  {  377,   -2 }, /* (307) signed ::= NK_PLUS NK_FLOAT */
  {  377,   -2 }, /* (308) signed ::= NK_MINUS NK_FLOAT */
  {  342,   -1 }, /* (309) signed_literal ::= signed */
  {  342,   -1 }, /* (310) signed_literal ::= NK_STRING */
  {  342,   -1 }, /* (311) signed_literal ::= NK_BOOL */
  {  342,   -2 }, /* (312) signed_literal ::= TIMESTAMP NK_STRING */
  {  342,   -1 }, /* (313) signed_literal ::= duration_literal */
  {  342,   -1 }, /* (314) signed_literal ::= NULL */
  {  342,   -1 }, /* (315) signed_literal ::= literal_func */
  {  342,   -1 }, /* (316) signed_literal ::= NK_QUESTION */
  {  379,   -1 }, /* (317) literal_list ::= signed_literal */
  {  379,   -3 }, /* (318) literal_list ::= literal_list NK_COMMA signed_literal */
  {  320,   -1 }, /* (319) db_name ::= NK_ID */
  {  348,   -1 }, /* (320) table_name ::= NK_ID */
  {  340,   -1 }, /* (321) column_name ::= NK_ID */
  {  355,   -1 }, /* (322) function_name ::= NK_ID */
  {  380,   -1 }, /* (323) table_alias ::= NK_ID */
  {  381,   -1 }, /* (324) column_alias ::= NK_ID */
  {  314,   -1 }, /* (325) user_name ::= NK_ID */
  {  367,   -1 }, /* (326) topic_name ::= NK_ID */
  {  374,   -1 }, /* (327) stream_name ::= NK_ID */
  {  369,   -1 }, /* (328) cgroup_name ::= NK_ID */
  {  382,   -1 }, /* (329) expression ::= literal */
  {  382,   -1 }, /* (330) expression ::= pseudo_column */
  {  382,   -1 }, /* (331) expression ::= column_reference */
  {  382,   -1 }, /* (332) expression ::= function_expression */
  {  382,   -1 }, /* (333) expression ::= subquery */
  {  382,   -3 }, /* (334) expression ::= NK_LP expression NK_RP */
  {  382,   -2 }, /* (335) expression ::= NK_PLUS expression */
  {  382,   -2 }, /* (336) expression ::= NK_MINUS expression */
  {  382,   -3 }, /* (337) expression ::= expression NK_PLUS expression */
  {  382,   -3 }, /* (338) expression ::= expression NK_MINUS expression */
  {  382,   -3 }, /* (339) expression ::= expression NK_STAR expression */
  {  382,   -3 }, /* (340) expression ::= expression NK_SLASH expression */
  {  382,   -3 }, /* (341) expression ::= expression NK_REM expression */
  {  382,   -3 }, /* (342) expression ::= column_reference NK_ARROW NK_STRING */
  {  382,   -3 }, /* (343) expression ::= expression NK_BITAND expression */
  {  382,   -3 }, /* (344) expression ::= expression NK_BITOR expression */
  {  345,   -1 }, /* (345) expression_list ::= expression */
  {  345,   -3 }, /* (346) expression_list ::= expression_list NK_COMMA expression */
  {  384,   -1 }, /* (347) column_reference ::= column_name */
  {  384,   -3 }, /* (348) column_reference ::= table_name NK_DOT column_name */
  {  383,   -1 }, /* (349) pseudo_column ::= ROWTS */
  {  383,   -1 }, /* (350) pseudo_column ::= TBNAME */
  {  383,   -3 }, /* (351) pseudo_column ::= table_name NK_DOT TBNAME */
  {  383,   -1 }, /* (352) pseudo_column ::= QSTART */
  {  383,   -1 }, /* (353) pseudo_column ::= QEND */
  {  383,   -1 }, /* (354) pseudo_column ::= QDURATION */
  {  383,   -1 }, /* (355) pseudo_column ::= WSTART */
  {  383,   -1 }, /* (356) pseudo_column ::= WEND */
  {  383,   -1 }, /* (357) pseudo_column ::= WDURATION */
  {  385,   -4 }, /* (358) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  385,   -4 }, /* (359) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  385,   -6 }, /* (360) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  385,   -1 }, /* (361) function_expression ::= literal_func */
  {  378,   -3 }, /* (362) literal_func ::= noarg_func NK_LP NK_RP */
  {  378,   -1 }, /* (363) literal_func ::= NOW */
  {  389,   -1 }, /* (364) noarg_func ::= NOW */
  {  389,   -1 }, /* (365) noarg_func ::= TODAY */
  {  389,   -1 }, /* (366) noarg_func ::= TIMEZONE */
  {  389,   -1 }, /* (367) noarg_func ::= DATABASE */
  {  389,   -1 }, /* (368) noarg_func ::= CLIENT_VERSION */
  {  389,   -1 }, /* (369) noarg_func ::= SERVER_VERSION */
  {  389,   -1 }, /* (370) noarg_func ::= SERVER_STATUS */
  {  389,   -1 }, /* (371) noarg_func ::= CURRENT_USER */
  {  389,   -1 }, /* (372) noarg_func ::= USER */
  {  387,   -1 }, /* (373) star_func ::= COUNT */
  {  387,   -1 }, /* (374) star_func ::= FIRST */
  {  387,   -1 }, /* (375) star_func ::= LAST */
  {  387,   -1 }, /* (376) star_func ::= LAST_ROW */
  {  388,   -1 }, /* (377) star_func_para_list ::= NK_STAR */
  {  388,   -1 }, /* (378) star_func_para_list ::= other_para_list */
  {  390,   -1 }, /* (379) other_para_list ::= star_func_para */
  {  390,   -3 }, /* (380) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  391,   -1 }, /* (381) star_func_para ::= expression */
  {  391,   -3 }, /* (382) star_func_para ::= table_name NK_DOT NK_STAR */
  {  392,   -3 }, /* (383) predicate ::= expression compare_op expression */
  {  392,   -5 }, /* (384) predicate ::= expression BETWEEN expression AND expression */
  {  392,   -6 }, /* (385) predicate ::= expression NOT BETWEEN expression AND expression */
  {  392,   -3 }, /* (386) predicate ::= expression IS NULL */
  {  392,   -4 }, /* (387) predicate ::= expression IS NOT NULL */
  {  392,   -3 }, /* (388) predicate ::= expression in_op in_predicate_value */
  {  393,   -1 }, /* (389) compare_op ::= NK_LT */
  {  393,   -1 }, /* (390) compare_op ::= NK_GT */
  {  393,   -1 }, /* (391) compare_op ::= NK_LE */
  {  393,   -1 }, /* (392) compare_op ::= NK_GE */
  {  393,   -1 }, /* (393) compare_op ::= NK_NE */
  {  393,   -1 }, /* (394) compare_op ::= NK_EQ */
  {  393,   -1 }, /* (395) compare_op ::= LIKE */
  {  393,   -2 }, /* (396) compare_op ::= NOT LIKE */
  {  393,   -1 }, /* (397) compare_op ::= MATCH */
  {  393,   -1 }, /* (398) compare_op ::= NMATCH */
  {  393,   -1 }, /* (399) compare_op ::= CONTAINS */
  {  394,   -1 }, /* (400) in_op ::= IN */
  {  394,   -2 }, /* (401) in_op ::= NOT IN */
  {  395,   -3 }, /* (402) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  396,   -1 }, /* (403) boolean_value_expression ::= boolean_primary */
  {  396,   -2 }, /* (404) boolean_value_expression ::= NOT boolean_primary */
  {  396,   -3 }, /* (405) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  396,   -3 }, /* (406) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  397,   -1 }, /* (407) boolean_primary ::= predicate */
  {  397,   -3 }, /* (408) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  398,   -1 }, /* (409) common_expression ::= expression */
  {  398,   -1 }, /* (410) common_expression ::= boolean_value_expression */
  {  399,    0 }, /* (411) from_clause_opt ::= */
  {  399,   -2 }, /* (412) from_clause_opt ::= FROM table_reference_list */
  {  400,   -1 }, /* (413) table_reference_list ::= table_reference */
  {  400,   -3 }, /* (414) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  401,   -1 }, /* (415) table_reference ::= table_primary */
  {  401,   -1 }, /* (416) table_reference ::= joined_table */
  {  402,   -2 }, /* (417) table_primary ::= table_name alias_opt */
  {  402,   -4 }, /* (418) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  402,   -2 }, /* (419) table_primary ::= subquery alias_opt */
  {  402,   -1 }, /* (420) table_primary ::= parenthesized_joined_table */
  {  404,    0 }, /* (421) alias_opt ::= */
  {  404,   -1 }, /* (422) alias_opt ::= table_alias */
  {  404,   -2 }, /* (423) alias_opt ::= AS table_alias */
  {  405,   -3 }, /* (424) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  405,   -3 }, /* (425) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  403,   -6 }, /* (426) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  406,    0 }, /* (427) join_type ::= */
  {  406,   -1 }, /* (428) join_type ::= INNER */
  {  408,  -12 }, /* (429) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  409,    0 }, /* (430) set_quantifier_opt ::= */
  {  409,   -1 }, /* (431) set_quantifier_opt ::= DISTINCT */
  {  409,   -1 }, /* (432) set_quantifier_opt ::= ALL */
  {  410,   -1 }, /* (433) select_list ::= select_item */
  {  410,   -3 }, /* (434) select_list ::= select_list NK_COMMA select_item */
  {  418,   -1 }, /* (435) select_item ::= NK_STAR */
  {  418,   -1 }, /* (436) select_item ::= common_expression */
  {  418,   -2 }, /* (437) select_item ::= common_expression column_alias */
  {  418,   -3 }, /* (438) select_item ::= common_expression AS column_alias */
  {  418,   -3 }, /* (439) select_item ::= table_name NK_DOT NK_STAR */
  {  376,    0 }, /* (440) where_clause_opt ::= */
  {  376,   -2 }, /* (441) where_clause_opt ::= WHERE search_condition */
  {  411,    0 }, /* (442) partition_by_clause_opt ::= */
  {  411,   -3 }, /* (443) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  415,    0 }, /* (444) twindow_clause_opt ::= */
  {  415,   -6 }, /* (445) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  415,   -4 }, /* (446) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  415,   -6 }, /* (447) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  415,   -8 }, /* (448) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  363,    0 }, /* (449) sliding_opt ::= */
  {  363,   -4 }, /* (450) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  414,    0 }, /* (451) fill_opt ::= */
  {  414,   -4 }, /* (452) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  414,   -6 }, /* (453) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  419,   -1 }, /* (454) fill_mode ::= NONE */
  {  419,   -1 }, /* (455) fill_mode ::= PREV */
  {  419,   -1 }, /* (456) fill_mode ::= NULL */
  {  419,   -1 }, /* (457) fill_mode ::= LINEAR */
  {  419,   -1 }, /* (458) fill_mode ::= NEXT */
  {  416,    0 }, /* (459) group_by_clause_opt ::= */
  {  416,   -3 }, /* (460) group_by_clause_opt ::= GROUP BY group_by_list */
  {  420,   -1 }, /* (461) group_by_list ::= expression */
  {  420,   -3 }, /* (462) group_by_list ::= group_by_list NK_COMMA expression */
  {  417,    0 }, /* (463) having_clause_opt ::= */
  {  417,   -2 }, /* (464) having_clause_opt ::= HAVING search_condition */
  {  412,    0 }, /* (465) range_opt ::= */
  {  412,   -6 }, /* (466) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  413,    0 }, /* (467) every_opt ::= */
  {  413,   -4 }, /* (468) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  421,   -4 }, /* (469) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  422,   -1 }, /* (470) query_simple ::= query_specification */
  {  422,   -1 }, /* (471) query_simple ::= union_query_expression */
  {  426,   -4 }, /* (472) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  426,   -3 }, /* (473) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  427,   -1 }, /* (474) query_simple_or_subquery ::= query_simple */
  {  427,   -1 }, /* (475) query_simple_or_subquery ::= subquery */
  {  368,   -1 }, /* (476) query_or_subquery ::= query_expression */
  {  368,   -1 }, /* (477) query_or_subquery ::= subquery */
  {  423,    0 }, /* (478) order_by_clause_opt ::= */
  {  423,   -3 }, /* (479) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  424,    0 }, /* (480) slimit_clause_opt ::= */
  {  424,   -2 }, /* (481) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  424,   -4 }, /* (482) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  424,   -4 }, /* (483) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  425,    0 }, /* (484) limit_clause_opt ::= */
  {  425,   -2 }, /* (485) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  425,   -4 }, /* (486) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  425,   -4 }, /* (487) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  386,   -3 }, /* (488) subquery ::= NK_LP query_expression NK_RP */
  {  407,   -1 }, /* (489) search_condition ::= common_expression */
  {  428,   -1 }, /* (490) sort_specification_list ::= sort_specification */
  {  428,   -3 }, /* (491) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  429,   -3 }, /* (492) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  430,    0 }, /* (493) ordering_specification_opt ::= */
  {  430,   -1 }, /* (494) ordering_specification_opt ::= ASC */
  {  430,   -1 }, /* (495) ordering_specification_opt ::= DESC */
  {  431,    0 }, /* (496) null_ordering_opt ::= */
  {  431,   -2 }, /* (497) null_ordering_opt ::= NULLS FIRST */
  {  431,   -2 }, /* (498) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,310,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,311,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,310,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,312,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,313,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,311,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,313,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,312,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy641, &yymsp[-1].minor.yy0, yymsp[0].minor.yy503); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy641, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy641, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy641, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy641); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy503 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy503 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy477, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy641); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy477, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy641); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy477 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy477 = yymsp[0].minor.yy477; }
  yymsp[0].minor.yy477 = yylhsminor.yy477;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy477 = yymsp[-2].minor.yy477 | yymsp[0].minor.yy477; }
  yymsp[-2].minor.yy477 = yylhsminor.yy477;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy477 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy477 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy641 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy641 = yylhsminor.yy641;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy641 = yymsp[-2].minor.yy641; }
  yymsp[-2].minor.yy641 = yylhsminor.yy641;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy641, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy641); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 319: /* db_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* table_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* column_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* function_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* table_alias ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* column_alias ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* user_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* topic_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* stream_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==328);
      case 364: /* noarg_func ::= NOW */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= TODAY */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==367);
      case 368: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==368);
      case 369: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==369);
      case 370: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==370);
      case 371: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==371);
      case 372: /* noarg_func ::= USER */ yytestcase(yyruleno==372);
      case 373: /* star_func ::= COUNT */ yytestcase(yyruleno==373);
      case 374: /* star_func ::= FIRST */ yytestcase(yyruleno==374);
      case 375: /* star_func ::= LAST */ yytestcase(yyruleno==375);
      case 376: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==376);
{ yylhsminor.yy641 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy641 = yylhsminor.yy641;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy281, &yymsp[-1].minor.yy641, yymsp[0].minor.yy776); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy281, &yymsp[0].minor.yy641); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy641); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy641, yymsp[0].minor.yy776); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy641); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy641); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy281 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 262: /* analyze_opt ::= */ yytestcase(yyruleno==262);
      case 269: /* agg_func_opt ::= */ yytestcase(yyruleno==269);
      case 430: /* set_quantifier_opt ::= */ yytestcase(yyruleno==430);
{ yymsp[1].minor.yy281 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy281 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy776 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_KEEP, yymsp[0].minor.yy280); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_RETENTIONS, yymsp[0].minor.yy280); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-3].minor.yy776, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-3].minor.yy776, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy776 = setDatabaseOption(pCxt, yymsp[-2].minor.yy776, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy776 = createAlterDatabaseOptions(pCxt); yylhsminor.yy776 = setAlterDatabaseOption(pCxt, yylhsminor.yy776, &yymsp[0].minor.yy605); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy776 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy776, &yymsp[0].minor.yy605); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 106: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= KEEP integer_list */
      case 110: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==110);
{ yymsp[-1].minor.yy605.type = DB_OPTION_KEEP; yymsp[-1].minor.yy605.pList = yymsp[0].minor.yy280; }
        break;
      case 111: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy280 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy280 = yylhsminor.yy280;
        break;
      case 114: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 289: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==289);
{ yylhsminor.yy280 = addNodeToList(pCxt, yymsp[-2].minor.yy280, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy280 = yylhsminor.yy280;
        break;
      case 115: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy280 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy280 = yylhsminor.yy280;
        break;
      case 116: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy280 = addNodeToList(pCxt, yymsp[-2].minor.yy280, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy280 = yylhsminor.yy280;
        break;
      case 117: /* retention_list ::= retention */
      case 137: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==137);
      case 140: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==140);
      case 147: /* column_def_list ::= column_def */ yytestcase(yyruleno==147);
      case 190: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==190);
      case 195: /* col_name_list ::= col_name */ yytestcase(yyruleno==195);
      case 245: /* func_list ::= func */ yytestcase(yyruleno==245);
      case 317: /* literal_list ::= signed_literal */ yytestcase(yyruleno==317);
      case 379: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==379);
      case 433: /* select_list ::= select_item */ yytestcase(yyruleno==433);
      case 490: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==490);
{ yylhsminor.yy280 = createNodeList(pCxt, yymsp[0].minor.yy776); }
  yymsp[0].minor.yy280 = yylhsminor.yy280;
        break;
      case 118: /* retention_list ::= retention_list NK_COMMA retention */
      case 148: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==148);
      case 191: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==191);
      case 196: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==196);
      case 246: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==246);
      case 318: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==318);
      case 380: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==380);
      case 434: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==434);
      case 491: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==491);
{ yylhsminor.yy280 = addNodeToList(pCxt, yymsp[-2].minor.yy280, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy280 = yylhsminor.yy280;
        break;
      case 119: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy776 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 120: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 122: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==122);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy281, yymsp[-5].minor.yy776, yymsp[-3].minor.yy280, yymsp[-1].minor.yy280, yymsp[0].minor.yy776); }
        break;
      case 121: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy280); }
        break;
      case 123: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy280); }
        break;
      case 124: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy281, yymsp[0].minor.yy776); }
        break;
      case 125: /* cmd ::= ALTER TABLE alter_table_clause */
      case 291: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==291);
{ pCxt->pRootNode = yymsp[0].minor.yy776; }
        break;
      case 126: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy776); }
        break;
      case 127: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy776 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy776, yymsp[0].minor.yy776); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 128: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy776 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy776, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy641, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 129: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy776 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy776, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy641); }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 130: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy776 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy776, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy641, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 131: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy776 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy776, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy641, &yymsp[0].minor.yy641); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 132: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy776 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy776, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy641, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 133: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy776 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy776, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy641); }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 134: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy776 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy776, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy641, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 135: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy776 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy776, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy641, &yymsp[0].minor.yy641); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 136: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy776 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy776, &yymsp[-2].minor.yy641, yymsp[0].minor.yy776); }
  yymsp[-5].minor.yy776 = yylhsminor.yy776;
        break;
      case 138: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 141: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==141);
{ yylhsminor.yy280 = addNodeToList(pCxt, yymsp[-1].minor.yy280, yymsp[0].minor.yy776); }
  yymsp[-1].minor.yy280 = yylhsminor.yy280;
        break;
      case 139: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy776 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy281, yymsp[-8].minor.yy776, yymsp[-6].minor.yy776, yymsp[-5].minor.yy280, yymsp[-2].minor.yy280, yymsp[0].minor.yy776); }
  yymsp[-9].minor.yy776 = yylhsminor.yy776;
        break;
      case 142: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy776 = createDropTableClause(pCxt, yymsp[-1].minor.yy281, yymsp[0].minor.yy776); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 143: /* specific_cols_opt ::= */
      case 174: /* tags_def_opt ::= */ yytestcase(yyruleno==174);
      case 442: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==442);
      case 459: /* group_by_clause_opt ::= */ yytestcase(yyruleno==459);
      case 478: /* order_by_clause_opt ::= */ yytestcase(yyruleno==478);
{ yymsp[1].minor.yy280 = NULL; }
        break;
      case 144: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy280 = yymsp[-1].minor.yy280; }
        break;
      case 145: /* full_table_name ::= table_name */
{ yylhsminor.yy776 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy641, NULL); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 146: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy776 = createRealTableNode(pCxt, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy641, NULL); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 149: /* column_def ::= column_name type_name */
{ yylhsminor.yy776 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy641, yymsp[0].minor.yy304, NULL); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 150: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy776 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy641, yymsp[-2].minor.yy304, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 151: /* type_name ::= BOOL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 152: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 153: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 154: /* type_name ::= INT */
      case 155: /* type_name ::= INTEGER */ yytestcase(yyruleno==155);
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 156: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 157: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 158: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 159: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 161: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 162: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 163: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 164: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 165: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 166: /* type_name ::= JSON */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 167: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 169: /* type_name ::= BLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 170: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 172: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 173: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 175: /* tags_def_opt ::= tags_def */
      case 378: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==378);
{ yylhsminor.yy280 = yymsp[0].minor.yy280; }
  yymsp[0].minor.yy280 = yylhsminor.yy280;
        break;
      case 176: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy280 = yymsp[-1].minor.yy280; }
        break;
      case 177: /* table_options ::= */
{ yymsp[1].minor.yy776 = createDefaultTableOptions(pCxt); }
        break;
      case 178: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy776 = setTableOption(pCxt, yymsp[-2].minor.yy776, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 179: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy776 = setTableOption(pCxt, yymsp[-2].minor.yy776, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy280); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 180: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy776 = setTableOption(pCxt, yymsp[-2].minor.yy776, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy280); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 181: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy776 = setTableOption(pCxt, yymsp[-4].minor.yy776, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy280); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 182: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy776 = setTableOption(pCxt, yymsp[-2].minor.yy776, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 183: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy776 = setTableOption(pCxt, yymsp[-4].minor.yy776, TABLE_OPTION_SMA, yymsp[-1].minor.yy280); }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 184: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy776 = createAlterTableOptions(pCxt); yylhsminor.yy776 = setTableOption(pCxt, yylhsminor.yy776, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 185: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy776 = setTableOption(pCxt, yymsp[-1].minor.yy776, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 186: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 187: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 188: /* duration_list ::= duration_literal */
      case 345: /* expression_list ::= expression */ yytestcase(yyruleno==345);
{ yylhsminor.yy280 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy776)); }
  yymsp[0].minor.yy280 = yylhsminor.yy280;
        break;
      case 189: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 346: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==346);
{ yylhsminor.yy280 = addNodeToList(pCxt, yymsp[-2].minor.yy280, releaseRawExprNode(pCxt, yymsp[0].minor.yy776)); }
  yymsp[-2].minor.yy280 = yylhsminor.yy280;
        break;
      case 192: /* rollup_func_name ::= function_name */
{ yylhsminor.yy776 = createFunctionNode(pCxt, &yymsp[0].minor.yy641, NULL); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 193: /* rollup_func_name ::= FIRST */
      case 194: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==194);
{ yylhsminor.yy776 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 197: /* col_name ::= column_name */
{ yylhsminor.yy776 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy641); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 198: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 199: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 200: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 201: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy776, yymsp[0].minor.yy776, OP_TYPE_LIKE); }
        break;
      case 202: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy776, yymsp[0].minor.yy776, OP_TYPE_LIKE); }
        break;
      case 203: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy776, NULL, OP_TYPE_LIKE); }
        break;
      case 204: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 205: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 206: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy776, yymsp[-1].minor.yy776, OP_TYPE_EQUAL); }
        break;
      case 209: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 210: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 211: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 212: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 213: /* cmd ::= SHOW LICENCES */
      case 214: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==214);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy641); }
        break;
      case 216: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy776); }
        break;
      case 217: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy776); }
        break;
      case 218: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 219: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 220: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 221: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 222: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 223: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 224: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 226: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 227: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 228: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy776); }
        break;
      case 229: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 230: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy776, yymsp[-1].minor.yy776, OP_TYPE_EQUAL); }
        break;
      case 232: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 233: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 234: /* db_name_cond_opt ::= */
      case 239: /* from_db_opt ::= */ yytestcase(yyruleno==239);
{ yymsp[1].minor.yy776 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 235: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy641); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 236: /* like_pattern_opt ::= */
      case 411: /* from_clause_opt ::= */ yytestcase(yyruleno==411);
      case 440: /* where_clause_opt ::= */ yytestcase(yyruleno==440);
      case 444: /* twindow_clause_opt ::= */ yytestcase(yyruleno==444);
      case 449: /* sliding_opt ::= */ yytestcase(yyruleno==449);
      case 451: /* fill_opt ::= */ yytestcase(yyruleno==451);
      case 463: /* having_clause_opt ::= */ yytestcase(yyruleno==463);
      case 465: /* range_opt ::= */ yytestcase(yyruleno==465);
      case 467: /* every_opt ::= */ yytestcase(yyruleno==467);
      case 480: /* slimit_clause_opt ::= */ yytestcase(yyruleno==480);
      case 484: /* limit_clause_opt ::= */ yytestcase(yyruleno==484);
{ yymsp[1].minor.yy776 = NULL; }
        break;
      case 237: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 238: /* table_name_cond ::= table_name */
{ yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy641); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 240: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy641); }
        break;
      case 241: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy281, yymsp[-3].minor.yy776, yymsp[-1].minor.yy776, NULL, yymsp[0].minor.yy776); }
        break;
      case 242: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy281, yymsp[0].minor.yy776); }
        break;
      case 243: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy776 = createIndexOption(pCxt, yymsp[-7].minor.yy280, releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), NULL, yymsp[-1].minor.yy776, yymsp[0].minor.yy776); }
        break;
      case 244: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy776 = createIndexOption(pCxt, yymsp[-9].minor.yy280, releaseRawExprNode(pCxt, yymsp[-5].minor.yy776), releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), yymsp[-1].minor.yy776, yymsp[0].minor.yy776); }
        break;
      case 247: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy776 = createFunctionNode(pCxt, &yymsp[-3].minor.yy641, yymsp[-1].minor.yy280); }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 248: /* sma_stream_opt ::= */
      case 275: /* stream_options ::= */ yytestcase(yyruleno==275);
{ yymsp[1].minor.yy776 = createStreamOptions(pCxt); }
        break;
      case 249: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 279: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==279);
{ ((SStreamOptions*)yymsp[-2].minor.yy776)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy776); yylhsminor.yy776 = yymsp[-2].minor.yy776; }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 250: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy776)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy776); yylhsminor.yy776 = yymsp[-2].minor.yy776; }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 251: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy281, &yymsp[-2].minor.yy641, yymsp[0].minor.yy776); }
        break;
      case 252: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy281, &yymsp[-3].minor.yy641, &yymsp[0].minor.yy641, false); }
        break;
      case 253: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy281, &yymsp[-5].minor.yy641, &yymsp[0].minor.yy641, true); }
        break;
      case 254: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy281, &yymsp[-3].minor.yy641, yymsp[0].minor.yy776, false); }
        break;
      case 255: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy281, &yymsp[-5].minor.yy641, yymsp[0].minor.yy776, true); }
        break;
      case 256: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy281, &yymsp[0].minor.yy641); }
        break;
      case 257: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy281, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy641); }
        break;
      case 258: /* cmd ::= DESC full_table_name */
      case 259: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==259);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy776); }
        break;
      case 260: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 261: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy281, yymsp[-1].minor.yy776, yymsp[0].minor.yy776); }
        break;
      case 263: /* analyze_opt ::= ANALYZE */
      case 270: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==270);
      case 431: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==431);
{ yymsp[0].minor.yy281 = true; }
        break;
      case 264: /* explain_options ::= */
{ yymsp[1].minor.yy776 = createDefaultExplainOptions(pCxt); }
        break;
      case 265: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy776 = setExplainVerbose(pCxt, yymsp[-2].minor.yy776, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 266: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy776 = setExplainRatio(pCxt, yymsp[-2].minor.yy776, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 267: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy281, yymsp[-8].minor.yy281, &yymsp[-5].minor.yy641, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy304, yymsp[0].minor.yy100); }
        break;
      case 268: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy281, &yymsp[0].minor.yy641); }
        break;
      case 271: /* bufsize_opt ::= */
{ yymsp[1].minor.yy100 = 0; }
        break;
      case 272: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy100 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 273: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-6].minor.yy281, &yymsp[-5].minor.yy641, yymsp[-2].minor.yy776, yymsp[-4].minor.yy776, yymsp[0].minor.yy776); }
        break;
      case 274: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy281, &yymsp[0].minor.yy641); }
        break;
      case 276: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy776)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy776 = yymsp[-2].minor.yy776; }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 277: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy776)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy776 = yymsp[-2].minor.yy776; }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 278: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy776)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy776)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy776); yylhsminor.yy776 = yymsp[-3].minor.yy776; }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 280: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy776)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy776 = yymsp[-3].minor.yy776; }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 281: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 282: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 283: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 284: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 285: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 286: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy280); }
        break;
      case 287: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 288: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy280 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 290: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy776, yymsp[0].minor.yy776); }
        break;
      case 292: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy776, yymsp[-2].minor.yy280, yymsp[0].minor.yy776); }
        break;
      case 293: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy776, NULL, yymsp[0].minor.yy776); }
        break;
      case 294: /* literal ::= NK_INTEGER */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 295: /* literal ::= NK_FLOAT */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 296: /* literal ::= NK_STRING */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 297: /* literal ::= NK_BOOL */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 298: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 299: /* literal ::= duration_literal */
      case 309: /* signed_literal ::= signed */ yytestcase(yyruleno==309);
      case 329: /* expression ::= literal */ yytestcase(yyruleno==329);
      case 330: /* expression ::= pseudo_column */ yytestcase(yyruleno==330);
      case 331: /* expression ::= column_reference */ yytestcase(yyruleno==331);
      case 332: /* expression ::= function_expression */ yytestcase(yyruleno==332);
      case 333: /* expression ::= subquery */ yytestcase(yyruleno==333);
      case 361: /* function_expression ::= literal_func */ yytestcase(yyruleno==361);
      case 403: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==403);
      case 407: /* boolean_primary ::= predicate */ yytestcase(yyruleno==407);
      case 409: /* common_expression ::= expression */ yytestcase(yyruleno==409);
      case 410: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==410);
      case 413: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==413);
      case 415: /* table_reference ::= table_primary */ yytestcase(yyruleno==415);
      case 416: /* table_reference ::= joined_table */ yytestcase(yyruleno==416);
      case 420: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==420);
      case 470: /* query_simple ::= query_specification */ yytestcase(yyruleno==470);
      case 471: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==471);
      case 474: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==474);
      case 476: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==476);
{ yylhsminor.yy776 = yymsp[0].minor.yy776; }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 300: /* literal ::= NULL */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 301: /* literal ::= NK_QUESTION */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 302: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 303: /* signed ::= NK_INTEGER */
{ yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 304: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 305: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 306: /* signed ::= NK_FLOAT */
{ yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 307: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 308: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 310: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 311: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 312: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 313: /* signed_literal ::= duration_literal */
      case 315: /* signed_literal ::= literal_func */ yytestcase(yyruleno==315);
      case 381: /* star_func_para ::= expression */ yytestcase(yyruleno==381);
      case 436: /* select_item ::= common_expression */ yytestcase(yyruleno==436);
      case 475: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==475);
      case 477: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==477);
      case 489: /* search_condition ::= common_expression */ yytestcase(yyruleno==489);
{ yylhsminor.yy776 = releaseRawExprNode(pCxt, yymsp[0].minor.yy776); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 314: /* signed_literal ::= NULL */
{ yylhsminor.yy776 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 316: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy776 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 334: /* expression ::= NK_LP expression NK_RP */
      case 408: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==408);
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy776)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 335: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy776));
                                                                                  }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 336: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy776), NULL));
                                                                                  }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 337: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776))); 
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 338: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776))); 
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 339: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776))); 
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 340: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776))); 
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 341: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 342: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 343: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 344: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 347: /* column_reference ::= column_name */
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy641, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy641)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 348: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy641, createColumnNode(pCxt, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy641)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 349: /* pseudo_column ::= ROWTS */
      case 350: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==350);
      case 352: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==352);
      case 353: /* pseudo_column ::= QEND */ yytestcase(yyruleno==353);
      case 354: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==354);
      case 355: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==355);
      case 356: /* pseudo_column ::= WEND */ yytestcase(yyruleno==356);
      case 357: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==357);
      case 363: /* literal_func ::= NOW */ yytestcase(yyruleno==363);
{ yylhsminor.yy776 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 351: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy641)))); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 358: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 359: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==359);
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy641, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy641, yymsp[-1].minor.yy280)); }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 360: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), yymsp[-1].minor.yy304)); }
  yymsp[-5].minor.yy776 = yylhsminor.yy776;
        break;
      case 362: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy641, NULL)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 377: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy280 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy280 = yylhsminor.yy280;
        break;
      case 382: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 439: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==439);
{ yylhsminor.yy776 = createColumnNode(pCxt, &yymsp[-2].minor.yy641, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 383: /* predicate ::= expression compare_op expression */
      case 388: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==388);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy668, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 384: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy776), releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-4].minor.yy776 = yylhsminor.yy776;
        break;
      case 385: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy776), releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-5].minor.yy776 = yylhsminor.yy776;
        break;
      case 386: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), NULL));
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 387: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), NULL));
                                                                                  }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 389: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy668 = OP_TYPE_LOWER_THAN; }
        break;
      case 390: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy668 = OP_TYPE_GREATER_THAN; }
        break;
      case 391: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy668 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 392: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy668 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 393: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy668 = OP_TYPE_NOT_EQUAL; }
        break;
      case 394: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy668 = OP_TYPE_EQUAL; }
        break;
      case 395: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy668 = OP_TYPE_LIKE; }
        break;
      case 396: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy668 = OP_TYPE_NOT_LIKE; }
        break;
      case 397: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy668 = OP_TYPE_MATCH; }
        break;
      case 398: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy668 = OP_TYPE_NMATCH; }
        break;
      case 399: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy668 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 400: /* in_op ::= IN */
{ yymsp[0].minor.yy668 = OP_TYPE_IN; }
        break;
      case 401: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy668 = OP_TYPE_NOT_IN; }
        break;
      case 402: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy280)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 404: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy776), NULL));
                                                                                  }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 405: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 406: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy776);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy776);
                                                                                    yylhsminor.yy776 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), releaseRawExprNode(pCxt, yymsp[0].minor.yy776)));
                                                                                  }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 412: /* from_clause_opt ::= FROM table_reference_list */
      case 441: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==441);
      case 464: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==464);
{ yymsp[-1].minor.yy776 = yymsp[0].minor.yy776; }
        break;
      case 414: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy776 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy776, yymsp[0].minor.yy776, NULL); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 417: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy776 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy641, &yymsp[0].minor.yy641); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 418: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy776 = createRealTableNode(pCxt, &yymsp[-3].minor.yy641, &yymsp[-1].minor.yy641, &yymsp[0].minor.yy641); }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 419: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy776 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy776), &yymsp[0].minor.yy641); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 421: /* alias_opt ::= */
{ yymsp[1].minor.yy641 = nil_token;  }
        break;
      case 422: /* alias_opt ::= table_alias */
{ yylhsminor.yy641 = yymsp[0].minor.yy641; }
  yymsp[0].minor.yy641 = yylhsminor.yy641;
        break;
      case 423: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy641 = yymsp[0].minor.yy641; }
        break;
      case 424: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 425: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==425);
{ yymsp[-2].minor.yy776 = yymsp[-1].minor.yy776; }
        break;
      case 426: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy776 = createJoinTableNode(pCxt, yymsp[-4].minor.yy468, yymsp[-5].minor.yy776, yymsp[-2].minor.yy776, yymsp[0].minor.yy776); }
  yymsp[-5].minor.yy776 = yylhsminor.yy776;
        break;
      case 427: /* join_type ::= */
{ yymsp[1].minor.yy468 = JOIN_TYPE_INNER; }
        break;
      case 428: /* join_type ::= INNER */
{ yymsp[0].minor.yy468 = JOIN_TYPE_INNER; }
        break;
      case 429: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy776 = createSelectStmt(pCxt, yymsp[-10].minor.yy281, yymsp[-9].minor.yy280, yymsp[-8].minor.yy776);
                                                                                    yymsp[-11].minor.yy776 = addWhereClause(pCxt, yymsp[-11].minor.yy776, yymsp[-7].minor.yy776);
                                                                                    yymsp[-11].minor.yy776 = addPartitionByClause(pCxt, yymsp[-11].minor.yy776, yymsp[-6].minor.yy280);
                                                                                    yymsp[-11].minor.yy776 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy776, yymsp[-2].minor.yy776);
                                                                                    yymsp[-11].minor.yy776 = addGroupByClause(pCxt, yymsp[-11].minor.yy776, yymsp[-1].minor.yy280);
                                                                                    yymsp[-11].minor.yy776 = addHavingClause(pCxt, yymsp[-11].minor.yy776, yymsp[0].minor.yy776);
                                                                                    yymsp[-11].minor.yy776 = addRangeClause(pCxt, yymsp[-11].minor.yy776, yymsp[-5].minor.yy776);
                                                                                    yymsp[-11].minor.yy776 = addEveryClause(pCxt, yymsp[-11].minor.yy776, yymsp[-4].minor.yy776);
                                                                                    yymsp[-11].minor.yy776 = addFillClause(pCxt, yymsp[-11].minor.yy776, yymsp[-3].minor.yy776);
                                                                                  }
        break;
      case 432: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy281 = false; }
        break;
      case 435: /* select_item ::= NK_STAR */
{ yylhsminor.yy776 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 437: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy776 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy776), &yymsp[0].minor.yy641); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 438: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy776 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), &yymsp[0].minor.yy641); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 443: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 460: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==460);
      case 479: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==479);
{ yymsp[-2].minor.yy280 = yymsp[0].minor.yy280; }
        break;
      case 445: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy776 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), releaseRawExprNode(pCxt, yymsp[-1].minor.yy776)); }
        break;
      case 446: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy776 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy776)); }
        break;
      case 447: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy776 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), NULL, yymsp[-1].minor.yy776, yymsp[0].minor.yy776); }
        break;
      case 448: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy776 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy776), releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), yymsp[-1].minor.yy776, yymsp[0].minor.yy776); }
        break;
      case 450: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 468: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==468);
{ yymsp[-3].minor.yy776 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy776); }
        break;
      case 452: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy776 = createFillNode(pCxt, yymsp[-1].minor.yy774, NULL); }
        break;
      case 453: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy776 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy280)); }
        break;
      case 454: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy774 = FILL_MODE_NONE; }
        break;
      case 455: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy774 = FILL_MODE_PREV; }
        break;
      case 456: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy774 = FILL_MODE_NULL; }
        break;
      case 457: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy774 = FILL_MODE_LINEAR; }
        break;
      case 458: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy774 = FILL_MODE_NEXT; }
        break;
      case 461: /* group_by_list ::= expression */
{ yylhsminor.yy280 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy776))); }
  yymsp[0].minor.yy280 = yylhsminor.yy280;
        break;
      case 462: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy280 = addNodeToList(pCxt, yymsp[-2].minor.yy280, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy776))); }
  yymsp[-2].minor.yy280 = yylhsminor.yy280;
        break;
      case 466: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy776 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy776), releaseRawExprNode(pCxt, yymsp[-1].minor.yy776)); }
        break;
      case 469: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy776 = addOrderByClause(pCxt, yymsp[-3].minor.yy776, yymsp[-2].minor.yy280);
                                                                                    yylhsminor.yy776 = addSlimitClause(pCxt, yylhsminor.yy776, yymsp[-1].minor.yy776);
                                                                                    yylhsminor.yy776 = addLimitClause(pCxt, yylhsminor.yy776, yymsp[0].minor.yy776);
                                                                                  }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 472: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy776 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy776, yymsp[0].minor.yy776); }
  yymsp[-3].minor.yy776 = yylhsminor.yy776;
        break;
      case 473: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy776 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy776, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 481: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 485: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==485);
{ yymsp[-1].minor.yy776 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 482: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 486: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==486);
{ yymsp[-3].minor.yy776 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 483: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 487: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==487);
{ yymsp[-3].minor.yy776 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 488: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy776 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy776); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 492: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy776 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy776), yymsp[-1].minor.yy2, yymsp[0].minor.yy649); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 493: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy2 = ORDER_ASC; }
        break;
      case 494: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy2 = ORDER_ASC; }
        break;
      case 495: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy2 = ORDER_DESC; }
        break;
      case 496: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy649 = NULL_ORDER_DEFAULT; }
        break;
      case 497: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy649 = NULL_ORDER_FIRST; }
        break;
      case 498: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy649 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
