/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 347
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EJoinType yy84;
  SDataType yy156;
  ENullOrder yy181;
  EOrder yy272;
  EFillMode yy284;
  EOperatorType yy304;
  SAlterOption yy475;
  SToken yy555;
  SNodeList* yy568;
  int32_t yy610;
  bool yy617;
  SNode* yy662;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             575
#define YYNRULE              444
#define YYNTOKEN             231
#define YY_MAX_SHIFT         574
#define YY_MIN_SHIFTREDUCE   857
#define YY_MAX_SHIFTREDUCE   1300
#define YY_ERROR_ACTION      1301
#define YY_ACCEPT_ACTION     1302
#define YY_NO_ACTION         1303
#define YY_MIN_REDUCE        1304
#define YY_MAX_REDUCE        1747
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2021)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   273,  124,  485, 1316, 1596,  485,  485,  322,  128, 1581,
 /*    10 */   472,   78,   33,   31,   78,  326, 1520, 1581,  386, 1467,
 /*    20 */   282,  393, 1117,  447, 1577, 1585, 1583, 1426, 1612,  484,
 /*    30 */  1426, 1426, 1577, 1584, 1583,  469,  488,  485, 1115,   34,
 /*    40 */    32,   30,   29,   28,  488,  468,  327, 1726,  105, 1567,
 /*    50 */    12,   33,   31, 1242,  484,  451,  484, 1123,   59,  282,
 /*    60 */   137, 1117, 1426,  125, 1723, 1726, 1624, 1383, 1726,   73,
 /*    70 */  1597,  471, 1599, 1600,  467,    1,  488, 1115, 1725, 1664,
 /*    80 */    22, 1724, 1723,  253, 1660, 1723,  103,  328,  485,   12,
 /*    90 */    34,   32,   30,   29,   28, 1726, 1123,  336,  571, 1353,
 /*   100 */   449,  133, 1671, 1672,  365, 1676,   26,  205,  137,   36,
 /*   110 */  1116,   36, 1723, 1426,    1, 1305,  454,  251,  985,  511,
 /*   120 */   510,  509,  989,  508,  991,  992,  507,  994,  504,  947,
 /*   130 */  1000,  501, 1002, 1003,  498,  495,   89,  571, 1141,   88,
 /*   140 */    87,   86,   85,   84,   83,   82,   81,   80,  949, 1116,
 /*   150 */  1118,  547,  546,  545,  544,  297,  441,  543,  542,  541,
 /*   160 */   108,  536,  535,  534,  533,  532,  531,  530,  529,  115,
 /*   170 */   525, 1121, 1122, 1139, 1167, 1168, 1169, 1170, 1171, 1172,
 /*   180 */  1173,  464,  486, 1181, 1182, 1183, 1184, 1185, 1186, 1118,
 /*   190 */    30,   29,   28,  402,  416,  396,   69, 1475,  321,  401,
 /*   200 */   320,  138,  102,  272,  397,  395,   65,  398, 1473,   54,
 /*   210 */  1121, 1122,  394, 1167, 1168, 1169, 1170, 1171, 1172, 1173,
 /*   220 */   464,  486, 1181, 1182, 1183, 1184, 1185, 1186,   33,   31,
 /*   230 */  1422,  447,   63, 1596, 1726,  138,  282,  250, 1117, 1139,
 /*   240 */    34,   32,   30,   29,   28,  447,  344,  137,   54,  356,
 /*   250 */   138, 1723, 1079, 1419, 1115,  138,  105, 1612,  357,  472,
 /*   260 */  1081,  100,  285,  455,  466, 1519,   12,   33,   31, 1421,
 /*   270 */   105,  485,  485, 1123,  468,  282,  451, 1117, 1567,   89,
 /*   280 */   337,  364,   88,   87,   86,   85,   84,   83,   82,   81,
 /*   290 */    80,    1, 1142, 1115,  103, 1624, 1426, 1426,  248, 1597,
 /*   300 */   471, 1599, 1600,  467,  465,  488,  462, 1636,  103,  198,
 /*   310 */  1671,  446, 1123,  445,  571, 1356, 1726, 1140,   56,  270,
 /*   320 */  1080, 1612,  175,  134, 1671, 1672, 1116, 1676,  469,  137,
 /*   330 */     7, 1304,  355, 1723,  138,  350,  349,  348,  347,  346,
 /*   340 */  1404,  343,  342,  341,  340,  339,  335,  334,  333,  332,
 /*   350 */   331,  330,  329,  571,  138,   98,   97,   96,   95,   94,
 /*   360 */    93,   92,   91,   90,  440, 1116, 1118,  402, 1507,  396,
 /*   370 */  1143, 1297,  524,  401, 1475,  146,  102,  514,  397,  395,
 /*   380 */   287,  398, 1266,  567,  566, 1473,  394, 1121, 1122,  365,
 /*   390 */  1167, 1168, 1169, 1170, 1171, 1172, 1173,  464,  486, 1181,
 /*   400 */  1182, 1183, 1184, 1185, 1186, 1118,   34,   32,   30,   29,
 /*   410 */    28,  293,  286,   34,   32,   30,   29,   28, 1510, 1512,
 /*   420 */   122,  434, 1264, 1265, 1267, 1268, 1121, 1122, 1428, 1167,
 /*   430 */  1168, 1169, 1170, 1171, 1172, 1173,  464,  486, 1181, 1182,
 /*   440 */  1183, 1184, 1185, 1186,   33,   31, 1187, 1475,  391,  390,
 /*   450 */  1296,  254,  282,  294, 1117,  485,  138, 1596, 1473,   48,
 /*   460 */   161,   70,  290,  131, 1423,  527,  894,  485,  893,  382,
 /*   470 */  1115,  378,  374,  370,  160,  106, 1548, 1154,  485, 1581,
 /*   480 */  1426, 1612, 1418,   33,   31, 1204,  895,  482,  450, 1123,
 /*   490 */   200,  282, 1426, 1117, 1577, 1584, 1583,  122,  468, 1417,
 /*   500 */   351,   55, 1567, 1426,  158, 1429,  488,    7,  485, 1115,
 /*   510 */  1415,   34,   32,   30,   29,   28,  101,  483,  437, 1624,
 /*   520 */   389, 1206,   74, 1597,  471, 1599, 1600,  467, 1123,  488,
 /*   530 */   571, 1402, 1664, 1426,  121, 1205,  275, 1660,  132,  424,
 /*   540 */   485, 1211, 1116,  392, 1567,  292,    7,  148,  147,  219,
 /*   550 */   201,  295, 1411,  122,  485, 1210,  430, 1691, 1144,  122,
 /*   560 */    24, 1428,  157,  296,  152, 1426,  154, 1428, 1302,  571,
 /*   570 */    34,   32,   30,   29,   28, 1256,   23, 1475, 1327, 1426,
 /*   580 */   524, 1116, 1118, 1413,  425,  151,  442,  438, 1474,  893,
 /*   590 */    25,  280, 1199, 1200, 1201, 1202, 1203, 1207, 1208, 1209,
 /*   600 */  1409,    9,    8, 1121, 1122,  384, 1167, 1168, 1169, 1170,
 /*   610 */  1171, 1172, 1173,  464,  486, 1181, 1182, 1183, 1184, 1185,
 /*   620 */  1186, 1118,  298, 1567, 1726,   34,   32,   30,   29,   28,
 /*   630 */    34,   32,   30,   29,   28,    6, 1326,  137, 1325,  447,
 /*   640 */  1324, 1723, 1121, 1122,  144, 1167, 1168, 1169, 1170, 1171,
 /*   650 */  1172, 1173,  464,  486, 1181, 1182, 1183, 1184, 1185, 1186,
 /*   660 */    33,   31, 1726,  254,  105,  400,  399, 1678,  282, 1596,
 /*   670 */  1117,   52, 1678,  453,   51,  137, 1218, 1323,  186, 1723,
 /*   680 */  1678, 1567, 1322, 1567,  178, 1567, 1115, 1321, 1320,  521,
 /*   690 */   520, 1675, 1241, 1612, 1154, 1319, 1674, 1204, 1318,  539,
 /*   700 */   450,  463,  103,  316, 1673, 1123, 1315, 1314, 1313, 1312,
 /*   710 */   468,  528, 1311, 1398, 1567, 1310, 1309,  135, 1671, 1672,
 /*   720 */  1308, 1676, 1567,    1,  540,  538, 1307, 1567,  457,  264,
 /*   730 */  1403, 1624, 1567, 1567,   74, 1597,  471, 1599, 1600,  467,
 /*   740 */  1567,  488,  228, 1567, 1664, 1456,  571, 1205,  275, 1660,
 /*   750 */   132, 1567, 1567, 1567, 1567,  101, 1401, 1567, 1116,  389,
 /*   760 */  1567, 1567, 1511, 1512, 1249, 1567,  313, 1210,  513, 1692,
 /*   770 */  1141, 1567,  265,  461,  263,  262, 1556,  388, 1683, 1237,
 /*   780 */  1192,  919,  392,  423,  166,  315, 1141,  164,  414, 1317,
 /*   790 */   168,  107, 1237,  167,  170,  519,  172,  169, 1118,  171,
 /*   800 */   920,  412,   25,  280, 1199, 1200, 1201, 1202, 1203, 1207,
 /*   810 */  1208, 1209,  305, 1103, 1104, 1384, 1596,  107,  522, 1121,
 /*   820 */  1122,  519, 1167, 1168, 1169, 1170, 1171, 1172, 1173,  464,
 /*   830 */   486, 1181, 1182, 1183, 1184, 1185, 1186,  518,  517,  516,
 /*   840 */  1612,  515,  113,  202,  522, 1468,  426,  469, 1596, 1343,
 /*   850 */    43,  252,   42,    9,    8,  189, 1263,  468,   35,  191,
 /*   860 */   435, 1567, 1212,  518,  517,  516,   35,  515, 1299, 1300,
 /*   870 */  1174,  403, 1612,  417,  195,  383, 1694,  458, 1624,  469,
 /*   880 */  1596,   74, 1597,  471, 1599, 1600,  467, 1338,  488,  468,
 /*   890 */  1240, 1664,  448, 1567, 1196,  275, 1660, 1738,   35,  208,
 /*   900 */  1589,  110, 1074,  210, 1612,  477, 1698, 1613, 1139,  405,
 /*   910 */  1624,  469, 1587,   74, 1597,  471, 1599, 1600,  467, 1336,
 /*   920 */   488,  468,  111, 1664, 1126, 1567,  216,  275, 1660, 1738,
 /*   930 */   204,  113, 1596,    2,  123,  978, 1125,  300, 1721,  234,
 /*   940 */    42,  408, 1624,  407,  973,   74, 1597,  471, 1599, 1600,
 /*   950 */   467,  232,  488,  304,  259, 1664, 1612,  261,  415,  275,
 /*   960 */  1660, 1738,  493,  469,  149,  947, 1006,  111, 1087,  224,
 /*   970 */  1682, 1010,  174,  468,  112,  410,  338, 1567, 1017, 1117,
 /*   980 */   404, 1596, 1509,  451,  113,  111,  173,  145, 1016,  114,
 /*   990 */   353,  345,  352,  354, 1624, 1115, 1129,  241, 1597,  471,
 /*  1000 */  1599, 1600,  467,  358,  488, 1612, 1148,  150, 1128,  359,
 /*  1010 */   360, 1147,  469,   46, 1123,  361,   45,  153,  362, 1146,
 /*  1020 */   363,  156,  468, 1726,   53,  366, 1567, 1145,   72,  159,
 /*  1030 */   387,  385, 1416, 1596, 1123,  163,  137,   79,  269, 1412,
 /*  1040 */  1723, 1552,  165, 1624,  225,  176,  126, 1597,  471, 1599,
 /*  1050 */  1600,  467,  179,  488,  116,  571,  117, 1612, 1414,   50,
 /*  1060 */    49,  325, 1410,  143,  469, 1596,  118, 1116,  319,  119,
 /*  1070 */   427,  418,  226,  181,  468,  184,  422,  419, 1567,  428,
 /*  1080 */   260, 1144,  311,  436,  307,  303,  140, 1705, 1695, 1612,
 /*  1090 */   452, 1739,  475, 1704,  187, 1624,  469,  433,   75, 1597,
 /*  1100 */   471, 1599, 1600,  467,  190,  488,  468, 1118, 1664,  274,
 /*  1110 */  1567,  439, 1663, 1660,  444, 1596,    5,  138, 1237,  432,
 /*  1120 */   104,  130, 1143, 1685,  194,    4,   37, 1624, 1121, 1122,
 /*  1130 */    75, 1597,  471, 1599, 1600,  467, 1679,  488,  196, 1612,
 /*  1140 */  1664,  456,   16,  276,  460, 1660,  469,  574,  459,  197,
 /*  1150 */  1722, 1518,  203, 1741, 1645, 1596,  468,  473,  474,  284,
 /*  1160 */  1567,  223, 1517,  478,   99,  214,  479,  480,  212,   62,
 /*  1170 */   563, 1427,  559,  555,  551,  222,   64, 1624,  227, 1612,
 /*  1180 */    75, 1597,  471, 1599, 1600,  467,  469,  488, 1399,  229,
 /*  1190 */  1664,  221,  491,  271,  570, 1661,  468,   44,  129,  235,
 /*  1200 */  1567,  231,   71,  431,  233,  217,  236, 1561, 1596, 1560,
 /*  1210 */   299, 1557,  301,  302, 1111, 1112,  141, 1624,  306, 1555,
 /*  1220 */   249, 1597,  471, 1599, 1600,  467,  308,  488,  309,  310,
 /*  1230 */  1554,  312, 1612, 1553,  314,  481, 1538,  142,  317,  469,
 /*  1240 */   318, 1090, 1089, 1532, 1531,  323,  324, 1530, 1529,  468,
 /*  1250 */  1057, 1502, 1501, 1567, 1500, 1499, 1498, 1596,  109, 1485,
 /*  1260 */  1484, 1483, 1482, 1481,  429, 1497, 1496,  182, 1596, 1495,
 /*  1270 */  1624, 1494, 1493,  244, 1597,  471, 1599, 1600,  467, 1492,
 /*  1280 */   488, 1612, 1491, 1490, 1095, 1489,  177, 1488,  469, 1487,
 /*  1290 */  1486, 1480, 1612, 1479, 1478, 1059, 1477, 1476,  468,  469,
 /*  1300 */  1355, 1546, 1567, 1540, 1524, 1515, 1405,  155,  912,  468,
 /*  1310 */  1354,  443, 1352, 1567,  367, 1596,  279,  368,  369, 1624,
 /*  1320 */  1350,  373,  126, 1597,  471, 1599, 1600,  467,  372,  488,
 /*  1330 */  1624, 1596,  162,  249, 1597,  471, 1599, 1600,  467, 1612,
 /*  1340 */   488, 1348,  377, 1346,  376,  371,  466, 1596, 1335,  375,
 /*  1350 */  1334,  379,  380, 1331, 1407, 1612,  468, 1025,  381, 1022,
 /*  1360 */  1567,   77,  469, 1406,  946,  945,  944, 1740,  943,  942,
 /*  1370 */   537, 1612,  468,  939,  539, 1344, 1567, 1624,  469,  281,
 /*  1380 */   248, 1597,  471, 1599, 1600,  467,  266,  488,  468, 1637,
 /*  1390 */   938, 1339, 1567, 1624,  267,  283,  249, 1597,  471, 1599,
 /*  1400 */  1600,  467, 1337,  488,  406, 1596,  268,  409, 1330, 1624,
 /*  1410 */   411, 1329,  249, 1597,  471, 1599, 1600,  467, 1596,  488,
 /*  1420 */   413,   76, 1545, 1097,   47, 1539,  420, 1523,  421, 1612,
 /*  1430 */  1522, 1514,  180,   57,    3,  120,  469, 1596,  183,   35,
 /*  1440 */    13,  127, 1612,  192,  185,   40,  468,  188, 1587,  469,
 /*  1450 */  1567,   14, 1262,   20,  193, 1255,   58,  199,   21,  468,
 /*  1460 */  1162, 1612, 1285, 1567,   39, 1234, 1233, 1624,  469,   38,
 /*  1470 */   237, 1597,  471, 1599, 1600,  467, 1290,  488,  468,   15,
 /*  1480 */  1624,  136, 1567,  243, 1597,  471, 1599, 1600,  467, 1284,
 /*  1490 */   488,   11, 1596,  277, 1289, 1288,  278,    8,   17, 1624,
 /*  1500 */  1197,  139,  245, 1597,  471, 1599, 1600,  467, 1596,  488,
 /*  1510 */  1176,   27,  470, 1175,   10,   18, 1612,   19,  476,  206,
 /*  1520 */   207, 1260,  209,  469,  211,   60, 1513,  213,  215,   61,
 /*  1530 */  1133,   65, 1612,  468, 1627, 1586, 1178, 1567,  487,  469,
 /*  1540 */   218,   41,  492, 1007,  291,  494,  497,  490, 1596,  468,
 /*  1550 */  1004,  496, 1001, 1567, 1624,  499,  500,  238, 1597,  471,
 /*  1560 */  1599, 1600,  467,  995,  488,  502, 1596,  503,  505,  993,
 /*  1570 */  1624,  506, 1612,  246, 1597,  471, 1599, 1600,  467,  469,
 /*  1580 */   488, 1596,  999,  998,  984,  997,  996,  512, 1019,  468,
 /*  1590 */  1612,   66, 1015, 1567,   67,   68, 1012,  469, 1018,  910,
 /*  1600 */   953,  523,  935,  933,  526, 1612,  220,  468,  932,  931,
 /*  1610 */  1624, 1567,  469,  239, 1597,  471, 1599, 1600,  467,  930,
 /*  1620 */   488,  929,  468,  928,  927,  926, 1567,  948, 1624,  950,
 /*  1630 */  1596,  247, 1597,  471, 1599, 1600,  467,  923,  488,  922,
 /*  1640 */   921, 1351,  918, 1624,  917,  916,  240, 1597,  471, 1599,
 /*  1650 */  1600,  467,  915,  488, 1612,  548,  549, 1349,  550,  552,
 /*  1660 */   553,  469,  554, 1347,  556,  557,  558, 1345,  560,  561,
 /*  1670 */   562,  468, 1333,  564,  565, 1567, 1332, 1596, 1328,  573,
 /*  1680 */   568,  569, 1303, 1119,  230,  572, 1303, 1303, 1303, 1303,
 /*  1690 */  1303, 1303, 1624, 1303, 1303, 1608, 1597,  471, 1599, 1600,
 /*  1700 */   467, 1612,  488, 1303, 1303, 1303, 1303, 1596,  469, 1303,
 /*  1710 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303,  468, 1303,
 /*  1720 */  1303, 1303, 1567, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1730 */  1303, 1612, 1303, 1303, 1303, 1303, 1303, 1596,  469, 1624,
 /*  1740 */  1303, 1303, 1607, 1597,  471, 1599, 1600,  467,  468,  488,
 /*  1750 */  1303, 1303, 1567, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1760 */  1303, 1612, 1303, 1303, 1303, 1303, 1303, 1596,  469, 1624,
 /*  1770 */  1303, 1303, 1606, 1597,  471, 1599, 1600,  467,  468,  488,
 /*  1780 */  1303, 1303, 1567, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1790 */  1303, 1612, 1303, 1303, 1303, 1303, 1303, 1596,  469, 1624,
 /*  1800 */  1303, 1303,  257, 1597,  471, 1599, 1600,  467,  468,  488,
 /*  1810 */  1303, 1303, 1567, 1303, 1303, 1303, 1596, 1303, 1303, 1303,
 /*  1820 */  1303, 1612, 1303, 1303, 1303, 1303, 1303, 1303,  469, 1624,
 /*  1830 */  1303, 1303,  256, 1597,  471, 1599, 1600,  467,  468,  488,
 /*  1840 */  1612, 1303, 1567, 1303, 1303, 1303, 1596,  469,  289,  288,
 /*  1850 */  1303, 1303, 1303, 1303, 1303, 1303, 1303,  468, 1131, 1624,
 /*  1860 */  1303, 1567,  258, 1597,  471, 1599, 1600,  467, 1303,  488,
 /*  1870 */  1612, 1303, 1303, 1303, 1124, 1303, 1303,  469, 1624, 1303,
 /*  1880 */  1303,  255, 1597,  471, 1599, 1600,  467,  468,  488, 1303,
 /*  1890 */  1303, 1567, 1303, 1123, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1900 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1624, 1303,
 /*  1910 */  1303,  242, 1597,  471, 1599, 1600,  467, 1303,  488, 1303,
 /*  1920 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1930 */  1303, 1303, 1303, 1303,  489, 1303, 1303, 1303, 1303, 1303,
 /*  1940 */  1303, 1303, 1303, 1303, 1303, 1303, 1127, 1303, 1303, 1303,
 /*  1950 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1960 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1970 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  1980 */  1303, 1303, 1303, 1303, 1303, 1303, 1132, 1303, 1303, 1303,
 /*  1990 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303,
 /*  2000 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1135, 1303, 1303,
 /*  2010 */  1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303,  486, 1181,
 /*  2020 */  1182,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   262,  233,  240,  235,  234,  240,  240,  285,  257,  279,
 /*    10 */   275,  249,   12,   13,  249,  249,  281,  279,  256,  268,
 /*    20 */    20,  256,   22,  240,  294,  295,  296,  265,  258,   20,
 /*    30 */   265,  265,  294,  295,  296,  265,  306,  240,   38,   12,
 /*    40 */    13,   14,   15,   16,  306,  275,  249,  325,  265,  279,
 /*    50 */    50,   12,   13,   14,   20,  285,   20,   57,    4,   20,
 /*    60 */   338,   22,  265,  243,  342,  325,  296,  247,  325,  299,
 /*    70 */   300,  301,  302,  303,  304,   75,  306,   38,  338,  309,
 /*    80 */     2,  338,  342,  313,  314,  342,  303,  240,  240,   50,
 /*    90 */    12,   13,   14,   15,   16,  325,   57,  249,   98,    0,
 /*   100 */   317,  318,  319,  320,   49,  322,  310,  311,  338,   75,
 /*   110 */   110,   75,  342,  265,   75,    0,   72,  270,   89,   90,
 /*   120 */    91,   92,   93,   94,   95,   96,   97,   98,   99,   38,
 /*   130 */   101,  102,  103,  104,  105,  106,   21,   98,   20,   24,
 /*   140 */    25,   26,   27,   28,   29,   30,   31,   32,   57,  110,
 /*   150 */   150,   52,   53,   54,   55,   56,   20,   58,   59,   60,
 /*   160 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   170 */    71,  171,  172,   20,  174,  175,  176,  177,  178,  179,
 /*   180 */   180,  181,  182,  183,  184,  185,  186,  187,  188,  150,
 /*   190 */    14,   15,   16,   52,  285,   54,   75,  258,  149,   58,
 /*   200 */   151,  201,   61,  264,   63,   64,   85,   66,  269,  242,
 /*   210 */   171,  172,   71,  174,  175,  176,  177,  178,  179,  180,
 /*   220 */   181,  182,  183,  184,  185,  186,  187,  188,   12,   13,
 /*   230 */   263,  240,  239,  234,  325,  201,   20,   18,   22,   20,
 /*   240 */    12,   13,   14,   15,   16,  240,   27,  338,  242,   30,
 /*   250 */   201,  342,   74,  260,   38,  201,  265,  258,   39,  275,
 /*   260 */    82,  255,  278,  219,  265,  281,   50,   12,   13,  263,
 /*   270 */   265,  240,  240,   57,  275,   20,  285,   22,  279,   21,
 /*   280 */   249,  249,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   290 */    32,   75,   20,   38,  303,  296,  265,  265,  299,  300,
 /*   300 */   301,  302,  303,  304,  305,  306,  307,  308,  303,  318,
 /*   310 */   319,  320,   57,  322,   98,    0,  325,   20,  159,  160,
 /*   320 */   142,  258,  163,  318,  319,  320,  110,  322,  265,  338,
 /*   330 */    75,    0,  113,  342,  201,  116,  117,  118,  119,  120,
 /*   340 */     0,  122,  123,  124,  125,  126,  127,  128,  129,  130,
 /*   350 */   131,  132,  133,   98,  201,   24,   25,   26,   27,   28,
 /*   360 */    29,   30,   31,   32,  301,  110,  150,   52,  265,   54,
 /*   370 */    20,  143,   49,   58,  258,  272,   61,   86,   63,   64,
 /*   380 */   264,   66,  171,  237,  238,  269,   71,  171,  172,   49,
 /*   390 */   174,  175,  176,  177,  178,  179,  180,  181,  182,  183,
 /*   400 */   184,  185,  186,  187,  188,  150,   12,   13,   14,   15,
 /*   410 */    16,  267,  250,   12,   13,   14,   15,   16,  274,  275,
 /*   420 */   258,  210,  211,  212,  213,  214,  171,  172,  266,  174,
 /*   430 */   175,  176,  177,  178,  179,  180,  181,  182,  183,  184,
 /*   440 */   185,  186,  187,  188,   12,   13,   14,  258,  244,  245,
 /*   450 */   222,   50,   20,  264,   22,  240,  201,  234,  269,    3,
 /*   460 */    33,  239,  262,   36,  249,   57,   20,  240,   22,   42,
 /*   470 */    38,   44,   45,   46,   47,  253,  249,   76,  240,  279,
 /*   480 */   265,  258,  260,   12,   13,   84,   40,  249,  265,   57,
 /*   490 */   140,   20,  265,   22,  294,  295,  296,  258,  275,  234,
 /*   500 */    67,   74,  279,  265,   77,  266,  306,   75,  240,   38,
 /*   510 */   259,   12,   13,   14,   15,   16,   61,  249,  138,  296,
 /*   520 */    65,  134,  299,  300,  301,  302,  303,  304,   57,  306,
 /*   530 */    98,    0,  309,  265,  140,  134,  313,  314,  315,  240,
 /*   540 */   240,  154,  110,   88,  279,  250,   75,  114,  115,  249,
 /*   550 */   327,  250,  259,  258,  240,  154,  333,  334,   20,  258,
 /*   560 */     2,  266,  135,  249,  137,  265,  139,  266,  231,   98,
 /*   570 */    12,   13,   14,   15,   16,   76,  189,  258,  234,  265,
 /*   580 */    49,  110,  150,  259,  285,  158,  206,  207,  269,   22,
 /*   590 */   189,  190,  191,  192,  193,  194,  195,  196,  197,  198,
 /*   600 */   259,    1,    2,  171,  172,   38,  174,  175,  176,  177,
 /*   610 */   178,  179,  180,  181,  182,  183,  184,  185,  186,  187,
 /*   620 */   188,  150,  285,  279,  325,   12,   13,   14,   15,   16,
 /*   630 */    12,   13,   14,   15,   16,   43,  234,  338,  234,  240,
 /*   640 */   234,  342,  171,  172,   47,  174,  175,  176,  177,  178,
 /*   650 */   179,  180,  181,  182,  183,  184,  185,  186,  187,  188,
 /*   660 */    12,   13,  325,   50,  265,  244,  245,  297,   20,  234,
 /*   670 */    22,   74,  297,  217,   77,  338,   76,  234,  140,  342,
 /*   680 */   297,  279,  234,  279,  259,  279,   38,  234,  234,  244,
 /*   690 */   245,  321,    4,  258,   76,  234,  321,   84,  234,   72,
 /*   700 */   265,  259,  303,   76,  321,   57,  234,  234,  234,  234,
 /*   710 */   275,  246,  234,  248,  279,  234,  234,  318,  319,  320,
 /*   720 */   234,  322,  279,   75,  244,  245,  234,  279,   72,   35,
 /*   730 */     0,  296,  279,  279,  299,  300,  301,  302,  303,  304,
 /*   740 */   279,  306,  251,  279,  309,  254,   98,  134,  313,  314,
 /*   750 */   315,  279,  279,  279,  279,   61,    0,  279,  110,   65,
 /*   760 */   279,  279,  274,  275,   14,  279,  146,  154,  259,  334,
 /*   770 */    20,  279,   78,   50,   80,   81,    0,   83,  199,  200,
 /*   780 */    14,   38,   88,  288,   79,  165,   20,   82,   21,  235,
 /*   790 */    79,   61,  200,   82,   79,   65,   79,   82,  150,   82,
 /*   800 */    57,   34,  189,  190,  191,  192,  193,  194,  195,  196,
 /*   810 */   197,  198,   36,  161,  162,  247,  234,   61,   88,  171,
 /*   820 */   172,   65,  174,  175,  176,  177,  178,  179,  180,  181,
 /*   830 */   182,  183,  184,  185,  186,  187,  188,  107,  108,  109,
 /*   840 */   258,  111,   72,  345,   88,  268,   76,  265,  234,    0,
 /*   850 */   140,  141,   72,    1,    2,   72,   76,  275,   72,   76,
 /*   860 */   336,  279,   76,  107,  108,  109,   72,  111,  186,  187,
 /*   870 */    76,   22,  258,  292,  330,  237,  298,  221,  296,  265,
 /*   880 */   234,  299,  300,  301,  302,  303,  304,    0,  306,  275,
 /*   890 */   202,  309,  323,  279,  171,  313,  314,  315,   72,   72,
 /*   900 */    75,   72,   76,   76,  258,   76,  324,  258,   20,   22,
 /*   910 */   296,  265,   87,  299,  300,  301,  302,  303,  304,    0,
 /*   920 */   306,  275,   72,  309,   38,  279,   76,  313,  314,  315,
 /*   930 */   339,   72,  234,  326,   18,   76,   38,  240,  324,   23,
 /*   940 */    72,   22,  296,    4,   76,  299,  300,  301,  302,  303,
 /*   950 */   304,   35,  306,   36,  293,  309,  258,  244,   19,  313,
 /*   960 */   314,  315,   72,  265,   48,   38,   76,   72,  148,  286,
 /*   970 */   324,   76,   33,  275,   72,   36,  240,  279,   76,   22,
 /*   980 */    41,  234,  240,  285,   72,   72,   47,  121,   76,   76,
 /*   990 */   134,  273,  271,  271,  296,   38,  110,  299,  300,  301,
 /*  1000 */   302,  303,  304,  240,  306,  258,   20,  242,  110,  290,
 /*  1010 */   275,   20,  265,   74,   57,  283,   77,  242,  265,   20,
 /*  1020 */   276,  242,  275,  325,  242,  240,  279,   20,  112,  242,
 /*  1030 */   258,  236,  258,  234,   57,  258,  338,  240,  236,  258,
 /*  1040 */   342,  279,  258,  296,  290,  239,  299,  300,  301,  302,
 /*  1050 */   303,  304,  239,  306,  258,   98,  258,  258,  258,  143,
 /*  1060 */   144,  145,  258,  147,  265,  234,  258,  110,  152,  258,
 /*  1070 */   265,  157,  283,  239,  275,  239,  275,  289,  279,  276,
 /*  1080 */   164,   20,  166,  209,  168,  169,  170,  335,  298,  258,
 /*  1090 */   343,  344,  208,  335,  280,  296,  265,  279,  299,  300,
 /*  1100 */   301,  302,  303,  304,  280,  306,  275,  150,  309,  279,
 /*  1110 */   279,  279,  313,  314,  215,  234,  216,  201,  200,  204,
 /*  1120 */   265,  329,   20,  332,  331,  203,  121,  296,  171,  172,
 /*  1130 */   299,  300,  301,  302,  303,  304,  297,  306,  328,  258,
 /*  1140 */   309,  218,   75,  223,  313,  314,  265,   19,  220,  316,
 /*  1150 */   341,  280,  340,  346,  312,  234,  275,  279,  279,  279,
 /*  1160 */   279,   33,  280,  137,   36,  239,  277,  276,  265,  239,
 /*  1170 */    42,  265,   44,   45,   46,   47,   75,  296,  254,  258,
 /*  1180 */   299,  300,  301,  302,  303,  304,  265,  306,  248,  240,
 /*  1190 */   309,  239,  261,  284,  236,  314,  275,  287,  291,  252,
 /*  1200 */   279,  241,   74,  282,  232,   77,  252,    0,  234,    0,
 /*  1210 */    64,    0,   38,  167,   38,   38,   38,  296,  167,    0,
 /*  1220 */   299,  300,  301,  302,  303,  304,   38,  306,   38,  167,
 /*  1230 */     0,   38,  258,    0,   38,  107,    0,   75,  154,  265,
 /*  1240 */   153,  110,  150,    0,    0,   53,  146,    0,    0,  275,
 /*  1250 */    87,    0,    0,  279,    0,    0,    0,  234,  121,    0,
 /*  1260 */     0,    0,    0,    0,  136,    0,    0,  139,  234,    0,
 /*  1270 */   296,    0,    0,  299,  300,  301,  302,  303,  304,    0,
 /*  1280 */   306,  258,    0,    0,  156,    0,  158,    0,  265,    0,
 /*  1290 */     0,    0,  258,    0,    0,   22,    0,    0,  275,  265,
 /*  1300 */     0,    0,  279,    0,    0,    0,    0,   43,   51,  275,
 /*  1310 */     0,  337,    0,  279,   38,  234,  282,   36,   43,  296,
 /*  1320 */     0,   43,  299,  300,  301,  302,  303,  304,   36,  306,
 /*  1330 */   296,  234,   82,  299,  300,  301,  302,  303,  304,  258,
 /*  1340 */   306,    0,   43,    0,   36,   38,  265,  234,    0,   38,
 /*  1350 */     0,   38,   36,    0,    0,  258,  275,   38,   43,   22,
 /*  1360 */   279,   84,  265,    0,   38,   38,   38,  344,   38,   38,
 /*  1370 */    72,  258,  275,   38,   72,    0,  279,  296,  265,  282,
 /*  1380 */   299,  300,  301,  302,  303,  304,   22,  306,  275,  308,
 /*  1390 */    38,    0,  279,  296,   22,  282,  299,  300,  301,  302,
 /*  1400 */   303,  304,    0,  306,   39,  234,   22,   38,    0,  296,
 /*  1410 */    22,    0,  299,  300,  301,  302,  303,  304,  234,  306,
 /*  1420 */    22,   20,    0,   38,  140,    0,   22,    0,  140,  258,
 /*  1430 */     0,    0,  137,   75,   72,  155,  265,  234,   43,   72,
 /*  1440 */   205,   75,  258,   75,  135,   72,  275,   76,   87,  265,
 /*  1450 */   279,  205,   76,   75,   72,   76,   75,   87,   72,  275,
 /*  1460 */    22,  258,   38,  279,   72,   76,   76,  296,  265,  199,
 /*  1470 */   299,  300,  301,  302,  303,  304,   76,  306,  275,   72,
 /*  1480 */   296,   87,  279,  299,  300,  301,  302,  303,  304,   38,
 /*  1490 */   306,  205,  234,   38,   38,   38,   38,    2,   72,  296,
 /*  1500 */   171,   87,  299,  300,  301,  302,  303,  304,  234,  306,
 /*  1510 */    76,   75,  173,   76,   75,   75,  258,   75,  138,   87,
 /*  1520 */    76,   76,   75,  265,   75,   75,    0,   43,  135,   75,
 /*  1530 */    22,   85,  258,  275,   75,   87,   76,  279,   75,  265,
 /*  1540 */    87,   75,   38,   76,   38,   75,   75,   86,  234,  275,
 /*  1550 */    76,   38,   76,  279,  296,   38,   75,  299,  300,  301,
 /*  1560 */   302,  303,  304,   76,  306,   38,  234,   75,   38,   76,
 /*  1570 */   296,   75,  258,  299,  300,  301,  302,  303,  304,  265,
 /*  1580 */   306,  234,  100,  100,   22,  100,  100,   88,   38,  275,
 /*  1590 */   258,   75,   38,  279,   75,   75,   22,  265,  110,   51,
 /*  1600 */    57,   50,   38,   38,   73,  258,   72,  275,   38,   38,
 /*  1610 */   296,  279,  265,  299,  300,  301,  302,  303,  304,   38,
 /*  1620 */   306,   38,  275,   38,   38,   22,  279,   38,  296,   57,
 /*  1630 */   234,  299,  300,  301,  302,  303,  304,   38,  306,   38,
 /*  1640 */    38,    0,   38,  296,   38,   38,  299,  300,  301,  302,
 /*  1650 */   303,  304,   38,  306,  258,   38,   36,    0,   43,   38,
 /*  1660 */    36,  265,   43,    0,   38,   36,   43,    0,   38,   36,
 /*  1670 */    43,  275,    0,   38,   37,  279,    0,  234,    0,   20,
 /*  1680 */    22,   21,  347,   22,   22,   21,  347,  347,  347,  347,
 /*  1690 */   347,  347,  296,  347,  347,  299,  300,  301,  302,  303,
 /*  1700 */   304,  258,  306,  347,  347,  347,  347,  234,  265,  347,
 /*  1710 */   347,  347,  347,  347,  347,  347,  347,  347,  275,  347,
 /*  1720 */   347,  347,  279,  347,  347,  347,  347,  347,  347,  347,
 /*  1730 */   347,  258,  347,  347,  347,  347,  347,  234,  265,  296,
 /*  1740 */   347,  347,  299,  300,  301,  302,  303,  304,  275,  306,
 /*  1750 */   347,  347,  279,  347,  347,  347,  347,  347,  347,  347,
 /*  1760 */   347,  258,  347,  347,  347,  347,  347,  234,  265,  296,
 /*  1770 */   347,  347,  299,  300,  301,  302,  303,  304,  275,  306,
 /*  1780 */   347,  347,  279,  347,  347,  347,  347,  347,  347,  347,
 /*  1790 */   347,  258,  347,  347,  347,  347,  347,  234,  265,  296,
 /*  1800 */   347,  347,  299,  300,  301,  302,  303,  304,  275,  306,
 /*  1810 */   347,  347,  279,  347,  347,  347,  234,  347,  347,  347,
 /*  1820 */   347,  258,  347,  347,  347,  347,  347,  347,  265,  296,
 /*  1830 */   347,  347,  299,  300,  301,  302,  303,  304,  275,  306,
 /*  1840 */   258,  347,  279,  347,  347,  347,  234,  265,   12,   13,
 /*  1850 */   347,  347,  347,  347,  347,  347,  347,  275,   22,  296,
 /*  1860 */   347,  279,  299,  300,  301,  302,  303,  304,  347,  306,
 /*  1870 */   258,  347,  347,  347,   38,  347,  347,  265,  296,  347,
 /*  1880 */   347,  299,  300,  301,  302,  303,  304,  275,  306,  347,
 /*  1890 */   347,  279,  347,   57,  347,  347,  347,  347,  347,  347,
 /*  1900 */   347,  347,  347,  347,  347,  347,  347,  347,  296,  347,
 /*  1910 */   347,  299,  300,  301,  302,  303,  304,  347,  306,  347,
 /*  1920 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  1930 */   347,  347,  347,  347,   98,  347,  347,  347,  347,  347,
 /*  1940 */   347,  347,  347,  347,  347,  347,  110,  347,  347,  347,
 /*  1950 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  1960 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  1970 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  1980 */   347,  347,  347,  347,  347,  347,  150,  347,  347,  347,
 /*  1990 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2000 */   347,  347,  347,  347,  347,  347,  347,  171,  347,  347,
 /*  2010 */   347,  347,  347,  347,  347,  347,  347,  347,  182,  183,
 /*  2020 */   184,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2030 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2040 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2050 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2060 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2070 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
};
#define YY_SHIFT_COUNT    (574)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1836)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   916,    0,   39,  216,  216,  216,  216,  255,  216,  216,
 /*    10 */   432,  471,  648,  471,  471,  471,  471,  471,  471,  471,
 /*    20 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*    30 */   471,  471,  471,  471,  471,  471,   34,   36,   36,   36,
 /*    40 */  1836, 1836, 1836,  153,   49,    9,    9,  133,   54,    9,
 /*    50 */     9,    9,    9,    9,    9,   55,    9,  118,  136,  133,
 /*    60 */   272,  118,    9,    9,  118,    9,  118,  272,  118,  118,
 /*    70 */     9,  323,  219,  401,  613,  613,  258,  957,  694,  141,
 /*    80 */   957,  957,  957,  957,  957,  957,  957,  957,  957,  957,
 /*    90 */   957,  957,  957,  957,  957,  957,  957,  957,  957,  446,
 /*   100 */   340,   91,   91,  350,  350,  350,  531,   91,   91,  297,
 /*   110 */   272,  118,  272,  118,  291,  408,   29,   29,   29,   29,
 /*   120 */    29,   29,   29, 1128,  115,  315,  228,  211,  455,  159,
 /*   130 */   380,  567,  538,  579,  592,  579,  750,  456,  688,  766,
 /*   140 */   888,  917,  927,  820,  888,  888,  866,  856,  856,  888,
 /*   150 */   986,   55,  272,  991,   55,  297,  999,   55,   55,  888,
 /*   160 */    55, 1007,  118,  118,  118,  118,  118,  118,  118,  118,
 /*   170 */   118,  118,  118,  888, 1007,  977,  986,  323,  914,  272,
 /*   180 */   323,  991,  323,  297,  999,  323, 1061,  874,  884,  977,
 /*   190 */   874,  884,  977,  977,  900,  899,  915,  922,  918,  297,
 /*   200 */  1102, 1005,  920,  928,  923, 1067,  118,  884,  977,  977,
 /*   210 */   884,  977, 1026,  297,  999,  323,  291,  323,  297, 1101,
 /*   220 */   408,  888,  323, 1007, 2021, 2021, 2021, 2021, 2021, 2021,
 /*   230 */  2021,   99,  427,  331,  939,  730,  756,  499,   78,  558,
 /*   240 */   394,  618,   27,   27,   27,   27,   27,   27,   27,   27,
 /*   250 */   597,  433,  178,  600,  387,  176,  176,  176,  176,  776,
 /*   260 */   620,  627,  705,  711,  715,  717,  849,  887,  919,  767,
 /*   270 */   652,  710,  770,  780,  783,  852,  682,   44,  656,  786,
 /*   280 */   723,  794,  825,  826,  827,  829,  850,  859,  886,  898,
 /*   290 */   868,  890,  895,  902,  912,  913,  121,  743, 1207, 1209,
 /*   300 */  1146, 1211, 1174, 1046, 1176, 1177, 1178, 1051, 1219, 1188,
 /*   310 */  1190, 1062, 1230, 1193, 1233, 1196, 1236, 1162, 1084, 1087,
 /*   320 */  1131, 1092, 1243, 1244, 1192, 1100, 1247, 1248, 1163, 1251,
 /*   330 */  1252, 1254, 1255, 1256, 1265, 1266, 1269, 1271, 1272, 1279,
 /*   340 */  1282, 1283, 1285, 1287, 1289, 1290, 1137, 1259, 1260, 1261,
 /*   350 */  1262, 1263, 1291, 1273, 1293, 1294, 1296, 1297, 1300, 1301,
 /*   360 */  1303, 1304, 1305, 1264, 1306, 1257, 1310, 1312, 1276, 1281,
 /*   370 */  1275, 1320, 1307, 1292, 1278, 1341, 1311, 1308, 1299, 1343,
 /*   380 */  1313, 1316, 1315, 1348, 1350, 1353, 1354, 1277, 1250, 1319,
 /*   390 */  1298, 1302, 1337, 1363, 1326, 1327, 1328, 1330, 1331, 1298,
 /*   400 */  1302, 1335, 1352, 1375, 1364, 1391, 1372, 1365, 1402, 1384,
 /*   410 */  1369, 1408, 1388, 1411, 1398, 1401, 1422, 1284, 1385, 1425,
 /*   420 */  1280, 1404, 1288, 1295, 1427, 1430, 1431, 1358, 1395, 1309,
 /*   430 */  1362, 1367, 1235, 1371, 1373, 1376, 1366, 1368, 1378, 1379,
 /*   440 */  1382, 1361, 1381, 1386, 1246, 1389, 1390, 1370, 1270, 1392,
 /*   450 */  1394, 1400, 1407, 1286, 1424, 1451, 1455, 1456, 1457, 1458,
 /*   460 */  1495, 1329, 1426, 1434, 1436, 1437, 1414, 1439, 1440, 1432,
 /*   470 */  1438, 1339, 1442, 1444, 1445, 1447, 1449, 1380, 1450, 1526,
 /*   480 */  1484, 1393, 1454, 1446, 1448, 1453, 1459, 1460, 1463, 1508,
 /*   490 */  1466, 1461, 1467, 1504, 1506, 1470, 1474, 1513, 1471, 1476,
 /*   500 */  1517, 1481, 1487, 1527, 1492, 1493, 1530, 1496, 1482, 1483,
 /*   510 */  1485, 1486, 1562, 1499, 1516, 1550, 1488, 1519, 1520, 1554,
 /*   520 */  1298, 1302, 1574, 1548, 1551, 1564, 1543, 1531, 1534, 1565,
 /*   530 */  1570, 1571, 1581, 1583, 1585, 1586, 1603, 1572, 1298, 1589,
 /*   540 */  1302, 1599, 1601, 1602, 1604, 1606, 1607, 1614, 1641, 1617,
 /*   550 */  1620, 1615, 1657, 1621, 1624, 1619, 1663, 1626, 1629, 1623,
 /*   560 */  1667, 1630, 1633, 1627, 1672, 1635, 1637, 1676, 1678, 1658,
 /*   570 */  1660, 1661, 1662, 1664, 1659,
};
#define YY_REDUCE_COUNT (230)
#define YY_REDUCE_MIN   (-278)
#define YY_REDUCE_MAX   (1612)
static const short yy_reduce_ofst[] = {
 /*     0 */   337, -230,  223,  435,  582,  614,  646,  698,  799,  831,
 /*    10 */    -1,  747,  881,  921,  974, 1023, 1034, 1081, 1097, 1113,
 /*    20 */  1171, 1184, 1203, 1258, 1274, 1314, 1332, 1347, 1396, 1443,
 /*    30 */  1473, 1503, 1533, 1563, 1582, 1612,   -9, -217,    5,  399,
 /*    40 */  -262,  200, -270,  299, -278, -238, -235,  -91, -260, -234,
 /*    50 */  -203, -152,   31,   32,  215,    6,  227,  -61,   63, -257,
 /*    60 */   -16,  162,  238,  268,  116,  300,  295,  144,  189,  301,
 /*    70 */   314,  222, -153, -204, -204, -204, -232,  265, -249, -180,
 /*    80 */   344,  402,  404,  406,  443,  448,  453,  454,  461,  464,
 /*    90 */   472,  473,  474,  475,  478,  481,  482,  486,  492,  146,
 /*   100 */   -33,  204,  421,  370,  375,  383,   -7,  445,  480,  103,
 /*   110 */  -265,  239,  488,  319,  491,  465,  251,  293,  324,  341,
 /*   120 */   425,  442,  509,  495,  554,  568,  498,  524,  577,  581,
 /*   130 */   544,  638,  578,  569,  569,  569,  649,  591,  607,  649,
 /*   140 */   697,  661,  713,  683,  736,  742,  718,  721,  722,  763,
 /*   150 */   719,  765,  735,  732,  775,  753,  744,  779,  782,  785,
 /*   160 */   787,  795,  772,  774,  777,  781,  784,  796,  798,  800,
 /*   170 */   804,  808,  811,  797,  802,  762,  754,  806,  788,  801,
 /*   180 */   813,  789,  834,  805,  803,  836,  790,  752,  814,  818,
 /*   190 */   758,  824,  830,  832,  791,  793,  792,  810,  569,  855,
 /*   200 */   839,  833,  807,  809,  812,  842,  649,  871,  878,  879,
 /*   210 */   882,  880,  889,  903,  891,  926,  924,  930,  906,  931,
 /*   220 */   940,  949,  952,  958,  910,  907,  909,  947,  954,  960,
 /*   230 */   972,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*    10 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*    20 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*    30 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*    40 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*    50 */  1301, 1301, 1301, 1301, 1301, 1360, 1301, 1301, 1301, 1301,
 /*    60 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*    70 */  1301, 1358, 1503, 1301, 1666, 1301, 1301, 1301, 1301, 1301,
 /*    80 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*    90 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   100 */  1360, 1301, 1301, 1677, 1677, 1677, 1358, 1301, 1301, 1301,
 /*   110 */  1301, 1301, 1301, 1301, 1455, 1301, 1301, 1301, 1301, 1301,
 /*   120 */  1301, 1301, 1301, 1541, 1301, 1301, 1742, 1301, 1408, 1547,
 /*   130 */  1701, 1301, 1693, 1669, 1683, 1670, 1301, 1727, 1686, 1301,
 /*   140 */  1301, 1301, 1301, 1533, 1301, 1301, 1508, 1505, 1505, 1301,
 /*   150 */  1301, 1360, 1301, 1301, 1360, 1301, 1301, 1360, 1360, 1301,
 /*   160 */  1360, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   170 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1358, 1543, 1301,
 /*   180 */  1358, 1301, 1358, 1301, 1301, 1358, 1301, 1708, 1706, 1301,
 /*   190 */  1708, 1706, 1301, 1301, 1720, 1716, 1699, 1697, 1683, 1301,
 /*   200 */  1301, 1301, 1745, 1733, 1729, 1301, 1301, 1706, 1301, 1301,
 /*   210 */  1706, 1301, 1516, 1301, 1301, 1358, 1301, 1358, 1301, 1424,
 /*   220 */  1301, 1301, 1358, 1301, 1535, 1549, 1525, 1458, 1458, 1361,
 /*   230 */  1306, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   240 */  1301, 1301, 1611, 1719, 1718, 1642, 1641, 1640, 1638, 1610,
 /*   250 */  1301, 1301, 1301, 1301, 1301, 1604, 1605, 1603, 1602, 1301,
 /*   260 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   270 */  1301, 1301, 1301, 1301, 1301, 1667, 1301, 1730, 1734, 1301,
 /*   280 */  1301, 1301, 1588, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   290 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   300 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   310 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   320 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   330 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   340 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   350 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   360 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   370 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   380 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   390 */  1471, 1470, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1388,
 /*   400 */  1387, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   410 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   420 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   430 */  1690, 1700, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   440 */  1301, 1588, 1301, 1717, 1301, 1676, 1672, 1301, 1301, 1668,
 /*   450 */  1301, 1301, 1728, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   460 */  1662, 1301, 1635, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   470 */  1301, 1598, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   480 */  1301, 1301, 1301, 1301, 1587, 1301, 1626, 1301, 1301, 1301,
 /*   490 */  1301, 1301, 1301, 1301, 1301, 1452, 1301, 1301, 1301, 1301,
 /*   500 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1437, 1435,
 /*   510 */  1434, 1433, 1301, 1430, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   520 */  1461, 1460, 1301, 1301, 1301, 1301, 1301, 1301, 1381, 1301,
 /*   530 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1372, 1301,
 /*   540 */  1371, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   550 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   560 */  1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   570 */  1301, 1301, 1301, 1301, 1301,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*         ON => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BLOCKS => nothing */
    0,  /*      CACHE => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*     QUORUM => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*        TTL => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* STREAM_MODE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /*     STRICT => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*        SMA => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*      DELAY => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*       FROM => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*     SCHEMA => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  224,  /*  NK_BITNOT => ID */
  224,  /*     INSERT => ID */
  224,  /*     VALUES => ID */
  224,  /*     IMPORT => ID */
  224,  /*    NK_SEMI => ID */
  224,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "STRICT",
  /*   72 */ "NK_COMMA",
  /*   73 */ "NK_COLON",
  /*   74 */ "TABLE",
  /*   75 */ "NK_LP",
  /*   76 */ "NK_RP",
  /*   77 */ "STABLE",
  /*   78 */ "ADD",
  /*   79 */ "COLUMN",
  /*   80 */ "MODIFY",
  /*   81 */ "RENAME",
  /*   82 */ "TAG",
  /*   83 */ "SET",
  /*   84 */ "NK_EQ",
  /*   85 */ "USING",
  /*   86 */ "TAGS",
  /*   87 */ "NK_DOT",
  /*   88 */ "COMMENT",
  /*   89 */ "BOOL",
  /*   90 */ "TINYINT",
  /*   91 */ "SMALLINT",
  /*   92 */ "INT",
  /*   93 */ "INTEGER",
  /*   94 */ "BIGINT",
  /*   95 */ "FLOAT",
  /*   96 */ "DOUBLE",
  /*   97 */ "BINARY",
  /*   98 */ "TIMESTAMP",
  /*   99 */ "NCHAR",
  /*  100 */ "UNSIGNED",
  /*  101 */ "JSON",
  /*  102 */ "VARCHAR",
  /*  103 */ "MEDIUMBLOB",
  /*  104 */ "BLOB",
  /*  105 */ "VARBINARY",
  /*  106 */ "DECIMAL",
  /*  107 */ "SMA",
  /*  108 */ "ROLLUP",
  /*  109 */ "FILE_FACTOR",
  /*  110 */ "NK_FLOAT",
  /*  111 */ "DELAY",
  /*  112 */ "SHOW",
  /*  113 */ "DATABASES",
  /*  114 */ "TABLES",
  /*  115 */ "STABLES",
  /*  116 */ "MNODES",
  /*  117 */ "MODULES",
  /*  118 */ "QNODES",
  /*  119 */ "FUNCTIONS",
  /*  120 */ "INDEXES",
  /*  121 */ "FROM",
  /*  122 */ "ACCOUNTS",
  /*  123 */ "APPS",
  /*  124 */ "CONNECTIONS",
  /*  125 */ "LICENCE",
  /*  126 */ "GRANTS",
  /*  127 */ "QUERIES",
  /*  128 */ "SCORES",
  /*  129 */ "TOPICS",
  /*  130 */ "VARIABLES",
  /*  131 */ "BNODES",
  /*  132 */ "SNODES",
  /*  133 */ "CLUSTER",
  /*  134 */ "LIKE",
  /*  135 */ "INDEX",
  /*  136 */ "FULLTEXT",
  /*  137 */ "FUNCTION",
  /*  138 */ "INTERVAL",
  /*  139 */ "TOPIC",
  /*  140 */ "AS",
  /*  141 */ "WITH",
  /*  142 */ "SCHEMA",
  /*  143 */ "DESC",
  /*  144 */ "DESCRIBE",
  /*  145 */ "RESET",
  /*  146 */ "QUERY",
  /*  147 */ "EXPLAIN",
  /*  148 */ "ANALYZE",
  /*  149 */ "VERBOSE",
  /*  150 */ "NK_BOOL",
  /*  151 */ "RATIO",
  /*  152 */ "COMPACT",
  /*  153 */ "VNODES",
  /*  154 */ "IN",
  /*  155 */ "OUTPUTTYPE",
  /*  156 */ "AGGREGATE",
  /*  157 */ "BUFSIZE",
  /*  158 */ "STREAM",
  /*  159 */ "INTO",
  /*  160 */ "TRIGGER",
  /*  161 */ "AT_ONCE",
  /*  162 */ "WINDOW_CLOSE",
  /*  163 */ "WATERMARK",
  /*  164 */ "KILL",
  /*  165 */ "CONNECTION",
  /*  166 */ "MERGE",
  /*  167 */ "VGROUP",
  /*  168 */ "REDISTRIBUTE",
  /*  169 */ "SPLIT",
  /*  170 */ "SYNCDB",
  /*  171 */ "NULL",
  /*  172 */ "NK_QUESTION",
  /*  173 */ "NK_ARROW",
  /*  174 */ "ROWTS",
  /*  175 */ "TBNAME",
  /*  176 */ "QSTARTTS",
  /*  177 */ "QENDTS",
  /*  178 */ "WSTARTTS",
  /*  179 */ "WENDTS",
  /*  180 */ "WDURATION",
  /*  181 */ "CAST",
  /*  182 */ "NOW",
  /*  183 */ "TODAY",
  /*  184 */ "TIMEZONE",
  /*  185 */ "COUNT",
  /*  186 */ "FIRST",
  /*  187 */ "LAST",
  /*  188 */ "LAST_ROW",
  /*  189 */ "BETWEEN",
  /*  190 */ "IS",
  /*  191 */ "NK_LT",
  /*  192 */ "NK_GT",
  /*  193 */ "NK_LE",
  /*  194 */ "NK_GE",
  /*  195 */ "NK_NE",
  /*  196 */ "MATCH",
  /*  197 */ "NMATCH",
  /*  198 */ "CONTAINS",
  /*  199 */ "JOIN",
  /*  200 */ "INNER",
  /*  201 */ "SELECT",
  /*  202 */ "DISTINCT",
  /*  203 */ "WHERE",
  /*  204 */ "PARTITION",
  /*  205 */ "BY",
  /*  206 */ "SESSION",
  /*  207 */ "STATE_WINDOW",
  /*  208 */ "SLIDING",
  /*  209 */ "FILL",
  /*  210 */ "VALUE",
  /*  211 */ "NONE",
  /*  212 */ "PREV",
  /*  213 */ "LINEAR",
  /*  214 */ "NEXT",
  /*  215 */ "GROUP",
  /*  216 */ "HAVING",
  /*  217 */ "ORDER",
  /*  218 */ "SLIMIT",
  /*  219 */ "SOFFSET",
  /*  220 */ "LIMIT",
  /*  221 */ "OFFSET",
  /*  222 */ "ASC",
  /*  223 */ "NULLS",
  /*  224 */ "ID",
  /*  225 */ "NK_BITNOT",
  /*  226 */ "INSERT",
  /*  227 */ "VALUES",
  /*  228 */ "IMPORT",
  /*  229 */ "NK_SEMI",
  /*  230 */ "FILE",
  /*  231 */ "cmd",
  /*  232 */ "account_options",
  /*  233 */ "alter_account_options",
  /*  234 */ "literal",
  /*  235 */ "alter_account_option",
  /*  236 */ "user_name",
  /*  237 */ "dnode_endpoint",
  /*  238 */ "dnode_host_name",
  /*  239 */ "not_exists_opt",
  /*  240 */ "db_name",
  /*  241 */ "db_options",
  /*  242 */ "exists_opt",
  /*  243 */ "alter_db_options",
  /*  244 */ "integer_list",
  /*  245 */ "variable_list",
  /*  246 */ "retention_list",
  /*  247 */ "alter_db_option",
  /*  248 */ "retention",
  /*  249 */ "full_table_name",
  /*  250 */ "column_def_list",
  /*  251 */ "tags_def_opt",
  /*  252 */ "table_options",
  /*  253 */ "multi_create_clause",
  /*  254 */ "tags_def",
  /*  255 */ "multi_drop_clause",
  /*  256 */ "alter_table_clause",
  /*  257 */ "alter_table_options",
  /*  258 */ "column_name",
  /*  259 */ "type_name",
  /*  260 */ "create_subtable_clause",
  /*  261 */ "specific_tags_opt",
  /*  262 */ "literal_list",
  /*  263 */ "drop_table_clause",
  /*  264 */ "col_name_list",
  /*  265 */ "table_name",
  /*  266 */ "column_def",
  /*  267 */ "func_name_list",
  /*  268 */ "alter_table_option",
  /*  269 */ "col_name",
  /*  270 */ "db_name_cond_opt",
  /*  271 */ "like_pattern_opt",
  /*  272 */ "table_name_cond",
  /*  273 */ "from_db_opt",
  /*  274 */ "func_name",
  /*  275 */ "function_name",
  /*  276 */ "index_name",
  /*  277 */ "index_options",
  /*  278 */ "func_list",
  /*  279 */ "duration_literal",
  /*  280 */ "sliding_opt",
  /*  281 */ "func",
  /*  282 */ "expression_list",
  /*  283 */ "topic_name",
  /*  284 */ "topic_options",
  /*  285 */ "query_expression",
  /*  286 */ "analyze_opt",
  /*  287 */ "explain_options",
  /*  288 */ "agg_func_opt",
  /*  289 */ "bufsize_opt",
  /*  290 */ "stream_name",
  /*  291 */ "stream_options",
  /*  292 */ "into_opt",
  /*  293 */ "dnode_list",
  /*  294 */ "signed",
  /*  295 */ "signed_literal",
  /*  296 */ "literal_func",
  /*  297 */ "table_alias",
  /*  298 */ "column_alias",
  /*  299 */ "expression",
  /*  300 */ "pseudo_column",
  /*  301 */ "column_reference",
  /*  302 */ "function_expression",
  /*  303 */ "subquery",
  /*  304 */ "star_func",
  /*  305 */ "star_func_para_list",
  /*  306 */ "noarg_func",
  /*  307 */ "other_para_list",
  /*  308 */ "star_func_para",
  /*  309 */ "predicate",
  /*  310 */ "compare_op",
  /*  311 */ "in_op",
  /*  312 */ "in_predicate_value",
  /*  313 */ "boolean_value_expression",
  /*  314 */ "boolean_primary",
  /*  315 */ "common_expression",
  /*  316 */ "from_clause",
  /*  317 */ "table_reference_list",
  /*  318 */ "table_reference",
  /*  319 */ "table_primary",
  /*  320 */ "joined_table",
  /*  321 */ "alias_opt",
  /*  322 */ "parenthesized_joined_table",
  /*  323 */ "join_type",
  /*  324 */ "search_condition",
  /*  325 */ "query_specification",
  /*  326 */ "set_quantifier_opt",
  /*  327 */ "select_list",
  /*  328 */ "where_clause_opt",
  /*  329 */ "partition_by_clause_opt",
  /*  330 */ "twindow_clause_opt",
  /*  331 */ "group_by_clause_opt",
  /*  332 */ "having_clause_opt",
  /*  333 */ "select_sublist",
  /*  334 */ "select_item",
  /*  335 */ "fill_opt",
  /*  336 */ "fill_mode",
  /*  337 */ "group_by_list",
  /*  338 */ "query_expression_body",
  /*  339 */ "order_by_clause_opt",
  /*  340 */ "slimit_clause_opt",
  /*  341 */ "limit_clause_opt",
  /*  342 */ "query_primary",
  /*  343 */ "sort_specification_list",
  /*  344 */ "sort_specification",
  /*  345 */ "ordering_specification_opt",
  /*  346 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  79 */ "alter_db_options ::= alter_db_option",
 /*  80 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  81 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  82 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  83 */ "alter_db_option ::= KEEP integer_list",
 /*  84 */ "alter_db_option ::= KEEP variable_list",
 /*  85 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  86 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  87 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  88 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  89 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  90 */ "integer_list ::= NK_INTEGER",
 /*  91 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  92 */ "variable_list ::= NK_VARIABLE",
 /*  93 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  94 */ "retention_list ::= retention",
 /*  95 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  96 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  97 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  98 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  99 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 100 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 101 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 102 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 103 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 104 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 105 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 107 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 109 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 111 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 112 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 113 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 114 */ "multi_create_clause ::= create_subtable_clause",
 /* 115 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 116 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 117 */ "multi_drop_clause ::= drop_table_clause",
 /* 118 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 119 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 120 */ "specific_tags_opt ::=",
 /* 121 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 122 */ "full_table_name ::= table_name",
 /* 123 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 124 */ "column_def_list ::= column_def",
 /* 125 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 126 */ "column_def ::= column_name type_name",
 /* 127 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 128 */ "type_name ::= BOOL",
 /* 129 */ "type_name ::= TINYINT",
 /* 130 */ "type_name ::= SMALLINT",
 /* 131 */ "type_name ::= INT",
 /* 132 */ "type_name ::= INTEGER",
 /* 133 */ "type_name ::= BIGINT",
 /* 134 */ "type_name ::= FLOAT",
 /* 135 */ "type_name ::= DOUBLE",
 /* 136 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TIMESTAMP",
 /* 138 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 139 */ "type_name ::= TINYINT UNSIGNED",
 /* 140 */ "type_name ::= SMALLINT UNSIGNED",
 /* 141 */ "type_name ::= INT UNSIGNED",
 /* 142 */ "type_name ::= BIGINT UNSIGNED",
 /* 143 */ "type_name ::= JSON",
 /* 144 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 145 */ "type_name ::= MEDIUMBLOB",
 /* 146 */ "type_name ::= BLOB",
 /* 147 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL",
 /* 149 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 150 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 151 */ "tags_def_opt ::=",
 /* 152 */ "tags_def_opt ::= tags_def",
 /* 153 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 154 */ "table_options ::=",
 /* 155 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 156 */ "table_options ::= table_options KEEP integer_list",
 /* 157 */ "table_options ::= table_options KEEP variable_list",
 /* 158 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 159 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 160 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 161 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 162 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 163 */ "alter_table_options ::= alter_table_option",
 /* 164 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 165 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 166 */ "alter_table_option ::= KEEP integer_list",
 /* 167 */ "alter_table_option ::= KEEP variable_list",
 /* 168 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 169 */ "col_name_list ::= col_name",
 /* 170 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 171 */ "col_name ::= column_name",
 /* 172 */ "cmd ::= SHOW DNODES",
 /* 173 */ "cmd ::= SHOW USERS",
 /* 174 */ "cmd ::= SHOW DATABASES",
 /* 175 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 176 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 177 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 178 */ "cmd ::= SHOW MNODES",
 /* 179 */ "cmd ::= SHOW MODULES",
 /* 180 */ "cmd ::= SHOW QNODES",
 /* 181 */ "cmd ::= SHOW FUNCTIONS",
 /* 182 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 183 */ "cmd ::= SHOW STREAMS",
 /* 184 */ "cmd ::= SHOW ACCOUNTS",
 /* 185 */ "cmd ::= SHOW APPS",
 /* 186 */ "cmd ::= SHOW CONNECTIONS",
 /* 187 */ "cmd ::= SHOW LICENCE",
 /* 188 */ "cmd ::= SHOW GRANTS",
 /* 189 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 190 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 191 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 192 */ "cmd ::= SHOW QUERIES",
 /* 193 */ "cmd ::= SHOW SCORES",
 /* 194 */ "cmd ::= SHOW TOPICS",
 /* 195 */ "cmd ::= SHOW VARIABLES",
 /* 196 */ "cmd ::= SHOW BNODES",
 /* 197 */ "cmd ::= SHOW SNODES",
 /* 198 */ "cmd ::= SHOW CLUSTER",
 /* 199 */ "db_name_cond_opt ::=",
 /* 200 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 201 */ "like_pattern_opt ::=",
 /* 202 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 203 */ "table_name_cond ::= table_name",
 /* 204 */ "from_db_opt ::=",
 /* 205 */ "from_db_opt ::= FROM db_name",
 /* 206 */ "func_name_list ::= func_name",
 /* 207 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 208 */ "func_name ::= function_name",
 /* 209 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 210 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 211 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 212 */ "index_options ::=",
 /* 213 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 214 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 215 */ "func_list ::= func",
 /* 216 */ "func_list ::= func_list NK_COMMA func",
 /* 217 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 218 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression",
 /* 219 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name",
 /* 220 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 221 */ "topic_options ::=",
 /* 222 */ "topic_options ::= topic_options WITH TABLE",
 /* 223 */ "topic_options ::= topic_options WITH SCHEMA",
 /* 224 */ "topic_options ::= topic_options WITH TAG",
 /* 225 */ "cmd ::= DESC full_table_name",
 /* 226 */ "cmd ::= DESCRIBE full_table_name",
 /* 227 */ "cmd ::= RESET QUERY CACHE",
 /* 228 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 229 */ "analyze_opt ::=",
 /* 230 */ "analyze_opt ::= ANALYZE",
 /* 231 */ "explain_options ::=",
 /* 232 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 233 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 234 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 235 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 236 */ "cmd ::= DROP FUNCTION function_name",
 /* 237 */ "agg_func_opt ::=",
 /* 238 */ "agg_func_opt ::= AGGREGATE",
 /* 239 */ "bufsize_opt ::=",
 /* 240 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 241 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 242 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 243 */ "into_opt ::=",
 /* 244 */ "into_opt ::= INTO full_table_name",
 /* 245 */ "stream_options ::=",
 /* 246 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 247 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 248 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 249 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 250 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 251 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 252 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 253 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 254 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 255 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 256 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 257 */ "cmd ::= query_expression",
 /* 258 */ "literal ::= NK_INTEGER",
 /* 259 */ "literal ::= NK_FLOAT",
 /* 260 */ "literal ::= NK_STRING",
 /* 261 */ "literal ::= NK_BOOL",
 /* 262 */ "literal ::= TIMESTAMP NK_STRING",
 /* 263 */ "literal ::= duration_literal",
 /* 264 */ "literal ::= NULL",
 /* 265 */ "literal ::= NK_QUESTION",
 /* 266 */ "duration_literal ::= NK_VARIABLE",
 /* 267 */ "signed ::= NK_INTEGER",
 /* 268 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 269 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 270 */ "signed ::= NK_FLOAT",
 /* 271 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 272 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 273 */ "signed_literal ::= signed",
 /* 274 */ "signed_literal ::= NK_STRING",
 /* 275 */ "signed_literal ::= NK_BOOL",
 /* 276 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 277 */ "signed_literal ::= duration_literal",
 /* 278 */ "signed_literal ::= NULL",
 /* 279 */ "signed_literal ::= literal_func",
 /* 280 */ "literal_list ::= signed_literal",
 /* 281 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 282 */ "db_name ::= NK_ID",
 /* 283 */ "table_name ::= NK_ID",
 /* 284 */ "column_name ::= NK_ID",
 /* 285 */ "function_name ::= NK_ID",
 /* 286 */ "table_alias ::= NK_ID",
 /* 287 */ "column_alias ::= NK_ID",
 /* 288 */ "user_name ::= NK_ID",
 /* 289 */ "index_name ::= NK_ID",
 /* 290 */ "topic_name ::= NK_ID",
 /* 291 */ "stream_name ::= NK_ID",
 /* 292 */ "expression ::= literal",
 /* 293 */ "expression ::= pseudo_column",
 /* 294 */ "expression ::= column_reference",
 /* 295 */ "expression ::= function_expression",
 /* 296 */ "expression ::= subquery",
 /* 297 */ "expression ::= NK_LP expression NK_RP",
 /* 298 */ "expression ::= NK_PLUS expression",
 /* 299 */ "expression ::= NK_MINUS expression",
 /* 300 */ "expression ::= expression NK_PLUS expression",
 /* 301 */ "expression ::= expression NK_MINUS expression",
 /* 302 */ "expression ::= expression NK_STAR expression",
 /* 303 */ "expression ::= expression NK_SLASH expression",
 /* 304 */ "expression ::= expression NK_REM expression",
 /* 305 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 306 */ "expression_list ::= expression",
 /* 307 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 308 */ "column_reference ::= column_name",
 /* 309 */ "column_reference ::= table_name NK_DOT column_name",
 /* 310 */ "pseudo_column ::= ROWTS",
 /* 311 */ "pseudo_column ::= TBNAME",
 /* 312 */ "pseudo_column ::= QSTARTTS",
 /* 313 */ "pseudo_column ::= QENDTS",
 /* 314 */ "pseudo_column ::= WSTARTTS",
 /* 315 */ "pseudo_column ::= WENDTS",
 /* 316 */ "pseudo_column ::= WDURATION",
 /* 317 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 318 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 319 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 320 */ "function_expression ::= literal_func",
 /* 321 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 322 */ "literal_func ::= NOW",
 /* 323 */ "noarg_func ::= NOW",
 /* 324 */ "noarg_func ::= TODAY",
 /* 325 */ "noarg_func ::= TIMEZONE",
 /* 326 */ "star_func ::= COUNT",
 /* 327 */ "star_func ::= FIRST",
 /* 328 */ "star_func ::= LAST",
 /* 329 */ "star_func ::= LAST_ROW",
 /* 330 */ "star_func_para_list ::= NK_STAR",
 /* 331 */ "star_func_para_list ::= other_para_list",
 /* 332 */ "other_para_list ::= star_func_para",
 /* 333 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 334 */ "star_func_para ::= expression",
 /* 335 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 336 */ "predicate ::= expression compare_op expression",
 /* 337 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 338 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 339 */ "predicate ::= expression IS NULL",
 /* 340 */ "predicate ::= expression IS NOT NULL",
 /* 341 */ "predicate ::= expression in_op in_predicate_value",
 /* 342 */ "compare_op ::= NK_LT",
 /* 343 */ "compare_op ::= NK_GT",
 /* 344 */ "compare_op ::= NK_LE",
 /* 345 */ "compare_op ::= NK_GE",
 /* 346 */ "compare_op ::= NK_NE",
 /* 347 */ "compare_op ::= NK_EQ",
 /* 348 */ "compare_op ::= LIKE",
 /* 349 */ "compare_op ::= NOT LIKE",
 /* 350 */ "compare_op ::= MATCH",
 /* 351 */ "compare_op ::= NMATCH",
 /* 352 */ "compare_op ::= CONTAINS",
 /* 353 */ "in_op ::= IN",
 /* 354 */ "in_op ::= NOT IN",
 /* 355 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 356 */ "boolean_value_expression ::= boolean_primary",
 /* 357 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 358 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 359 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 360 */ "boolean_primary ::= predicate",
 /* 361 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 362 */ "common_expression ::= expression",
 /* 363 */ "common_expression ::= boolean_value_expression",
 /* 364 */ "from_clause ::= FROM table_reference_list",
 /* 365 */ "table_reference_list ::= table_reference",
 /* 366 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 367 */ "table_reference ::= table_primary",
 /* 368 */ "table_reference ::= joined_table",
 /* 369 */ "table_primary ::= table_name alias_opt",
 /* 370 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 371 */ "table_primary ::= subquery alias_opt",
 /* 372 */ "table_primary ::= parenthesized_joined_table",
 /* 373 */ "alias_opt ::=",
 /* 374 */ "alias_opt ::= table_alias",
 /* 375 */ "alias_opt ::= AS table_alias",
 /* 376 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 377 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 378 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 379 */ "join_type ::=",
 /* 380 */ "join_type ::= INNER",
 /* 381 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 382 */ "set_quantifier_opt ::=",
 /* 383 */ "set_quantifier_opt ::= DISTINCT",
 /* 384 */ "set_quantifier_opt ::= ALL",
 /* 385 */ "select_list ::= NK_STAR",
 /* 386 */ "select_list ::= select_sublist",
 /* 387 */ "select_sublist ::= select_item",
 /* 388 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 389 */ "select_item ::= common_expression",
 /* 390 */ "select_item ::= common_expression column_alias",
 /* 391 */ "select_item ::= common_expression AS column_alias",
 /* 392 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 393 */ "where_clause_opt ::=",
 /* 394 */ "where_clause_opt ::= WHERE search_condition",
 /* 395 */ "partition_by_clause_opt ::=",
 /* 396 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 397 */ "twindow_clause_opt ::=",
 /* 398 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 399 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 400 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 401 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 402 */ "sliding_opt ::=",
 /* 403 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 404 */ "fill_opt ::=",
 /* 405 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 406 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 407 */ "fill_mode ::= NONE",
 /* 408 */ "fill_mode ::= PREV",
 /* 409 */ "fill_mode ::= NULL",
 /* 410 */ "fill_mode ::= LINEAR",
 /* 411 */ "fill_mode ::= NEXT",
 /* 412 */ "group_by_clause_opt ::=",
 /* 413 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 414 */ "group_by_list ::= expression",
 /* 415 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 416 */ "having_clause_opt ::=",
 /* 417 */ "having_clause_opt ::= HAVING search_condition",
 /* 418 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 419 */ "query_expression_body ::= query_primary",
 /* 420 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 421 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 422 */ "query_primary ::= query_specification",
 /* 423 */ "order_by_clause_opt ::=",
 /* 424 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 425 */ "slimit_clause_opt ::=",
 /* 426 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 427 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 428 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 429 */ "limit_clause_opt ::=",
 /* 430 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 431 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 432 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 433 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 434 */ "search_condition ::= common_expression",
 /* 435 */ "sort_specification_list ::= sort_specification",
 /* 436 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 437 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 438 */ "ordering_specification_opt ::=",
 /* 439 */ "ordering_specification_opt ::= ASC",
 /* 440 */ "ordering_specification_opt ::= DESC",
 /* 441 */ "null_ordering_opt ::=",
 /* 442 */ "null_ordering_opt ::= NULLS FIRST",
 /* 443 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 231: /* cmd */
    case 234: /* literal */
    case 241: /* db_options */
    case 243: /* alter_db_options */
    case 248: /* retention */
    case 249: /* full_table_name */
    case 252: /* table_options */
    case 256: /* alter_table_clause */
    case 257: /* alter_table_options */
    case 260: /* create_subtable_clause */
    case 263: /* drop_table_clause */
    case 266: /* column_def */
    case 269: /* col_name */
    case 270: /* db_name_cond_opt */
    case 271: /* like_pattern_opt */
    case 272: /* table_name_cond */
    case 273: /* from_db_opt */
    case 274: /* func_name */
    case 277: /* index_options */
    case 279: /* duration_literal */
    case 280: /* sliding_opt */
    case 281: /* func */
    case 284: /* topic_options */
    case 285: /* query_expression */
    case 287: /* explain_options */
    case 291: /* stream_options */
    case 292: /* into_opt */
    case 294: /* signed */
    case 295: /* signed_literal */
    case 296: /* literal_func */
    case 299: /* expression */
    case 300: /* pseudo_column */
    case 301: /* column_reference */
    case 302: /* function_expression */
    case 303: /* subquery */
    case 308: /* star_func_para */
    case 309: /* predicate */
    case 312: /* in_predicate_value */
    case 313: /* boolean_value_expression */
    case 314: /* boolean_primary */
    case 315: /* common_expression */
    case 316: /* from_clause */
    case 317: /* table_reference_list */
    case 318: /* table_reference */
    case 319: /* table_primary */
    case 320: /* joined_table */
    case 322: /* parenthesized_joined_table */
    case 324: /* search_condition */
    case 325: /* query_specification */
    case 328: /* where_clause_opt */
    case 330: /* twindow_clause_opt */
    case 332: /* having_clause_opt */
    case 334: /* select_item */
    case 335: /* fill_opt */
    case 338: /* query_expression_body */
    case 340: /* slimit_clause_opt */
    case 341: /* limit_clause_opt */
    case 342: /* query_primary */
    case 344: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy662)); 
}
      break;
    case 232: /* account_options */
    case 233: /* alter_account_options */
    case 235: /* alter_account_option */
    case 289: /* bufsize_opt */
{
 
}
      break;
    case 236: /* user_name */
    case 237: /* dnode_endpoint */
    case 238: /* dnode_host_name */
    case 240: /* db_name */
    case 258: /* column_name */
    case 265: /* table_name */
    case 275: /* function_name */
    case 276: /* index_name */
    case 283: /* topic_name */
    case 290: /* stream_name */
    case 297: /* table_alias */
    case 298: /* column_alias */
    case 304: /* star_func */
    case 306: /* noarg_func */
    case 321: /* alias_opt */
{
 
}
      break;
    case 239: /* not_exists_opt */
    case 242: /* exists_opt */
    case 286: /* analyze_opt */
    case 288: /* agg_func_opt */
    case 326: /* set_quantifier_opt */
{
 
}
      break;
    case 244: /* integer_list */
    case 245: /* variable_list */
    case 246: /* retention_list */
    case 250: /* column_def_list */
    case 251: /* tags_def_opt */
    case 253: /* multi_create_clause */
    case 254: /* tags_def */
    case 255: /* multi_drop_clause */
    case 261: /* specific_tags_opt */
    case 262: /* literal_list */
    case 264: /* col_name_list */
    case 267: /* func_name_list */
    case 278: /* func_list */
    case 282: /* expression_list */
    case 293: /* dnode_list */
    case 305: /* star_func_para_list */
    case 307: /* other_para_list */
    case 327: /* select_list */
    case 329: /* partition_by_clause_opt */
    case 331: /* group_by_clause_opt */
    case 333: /* select_sublist */
    case 337: /* group_by_list */
    case 339: /* order_by_clause_opt */
    case 343: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy568)); 
}
      break;
    case 247: /* alter_db_option */
    case 268: /* alter_table_option */
{
 
}
      break;
    case 259: /* type_name */
{
 
}
      break;
    case 310: /* compare_op */
    case 311: /* in_op */
{
 
}
      break;
    case 323: /* join_type */
{
 
}
      break;
    case 336: /* fill_mode */
{
 
}
      break;
    case 345: /* ordering_specification_opt */
{
 
}
      break;
    case 346: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  231,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  231,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  232,    0 }, /* (2) account_options ::= */
  {  232,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  232,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  232,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  232,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  232,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  232,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  232,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  232,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  232,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  233,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  233,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  235,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  235,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  235,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  235,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  235,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  235,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  235,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  235,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  235,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  235,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  231,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  231,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  231,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  231,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  231,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  231,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  231,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  231,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  231,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  231,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  231,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  231,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  237,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  238,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  238,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  231,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  231,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  231,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  231,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  231,   -2 }, /* (51) cmd ::= USE db_name */
  {  231,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  239,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  239,    0 }, /* (54) not_exists_opt ::= */
  {  242,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  242,    0 }, /* (56) exists_opt ::= */
  {  241,    0 }, /* (57) db_options ::= */
  {  241,   -3 }, /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
  {  241,   -3 }, /* (59) db_options ::= db_options CACHE NK_INTEGER */
  {  241,   -3 }, /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
  {  241,   -3 }, /* (61) db_options ::= db_options COMP NK_INTEGER */
  {  241,   -3 }, /* (62) db_options ::= db_options DAYS NK_INTEGER */
  {  241,   -3 }, /* (63) db_options ::= db_options DAYS NK_VARIABLE */
  {  241,   -3 }, /* (64) db_options ::= db_options FSYNC NK_INTEGER */
  {  241,   -3 }, /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
  {  241,   -3 }, /* (66) db_options ::= db_options MINROWS NK_INTEGER */
  {  241,   -3 }, /* (67) db_options ::= db_options KEEP integer_list */
  {  241,   -3 }, /* (68) db_options ::= db_options KEEP variable_list */
  {  241,   -3 }, /* (69) db_options ::= db_options PRECISION NK_STRING */
  {  241,   -3 }, /* (70) db_options ::= db_options QUORUM NK_INTEGER */
  {  241,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  241,   -3 }, /* (72) db_options ::= db_options TTL NK_INTEGER */
  {  241,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  241,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  241,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  241,   -3 }, /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  241,   -3 }, /* (77) db_options ::= db_options RETENTIONS retention_list */
  {  241,   -3 }, /* (78) db_options ::= db_options STRICT NK_INTEGER */
  {  243,   -1 }, /* (79) alter_db_options ::= alter_db_option */
  {  243,   -2 }, /* (80) alter_db_options ::= alter_db_options alter_db_option */
  {  247,   -2 }, /* (81) alter_db_option ::= BLOCKS NK_INTEGER */
  {  247,   -2 }, /* (82) alter_db_option ::= FSYNC NK_INTEGER */
  {  247,   -2 }, /* (83) alter_db_option ::= KEEP integer_list */
  {  247,   -2 }, /* (84) alter_db_option ::= KEEP variable_list */
  {  247,   -2 }, /* (85) alter_db_option ::= WAL NK_INTEGER */
  {  247,   -2 }, /* (86) alter_db_option ::= QUORUM NK_INTEGER */
  {  247,   -2 }, /* (87) alter_db_option ::= CACHELAST NK_INTEGER */
  {  247,   -2 }, /* (88) alter_db_option ::= REPLICA NK_INTEGER */
  {  247,   -2 }, /* (89) alter_db_option ::= STRICT NK_INTEGER */
  {  244,   -1 }, /* (90) integer_list ::= NK_INTEGER */
  {  244,   -3 }, /* (91) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  245,   -1 }, /* (92) variable_list ::= NK_VARIABLE */
  {  245,   -3 }, /* (93) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  246,   -1 }, /* (94) retention_list ::= retention */
  {  246,   -3 }, /* (95) retention_list ::= retention_list NK_COMMA retention */
  {  248,   -3 }, /* (96) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  231,   -9 }, /* (97) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  231,   -3 }, /* (98) cmd ::= CREATE TABLE multi_create_clause */
  {  231,   -9 }, /* (99) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  231,   -3 }, /* (100) cmd ::= DROP TABLE multi_drop_clause */
  {  231,   -4 }, /* (101) cmd ::= DROP STABLE exists_opt full_table_name */
  {  231,   -3 }, /* (102) cmd ::= ALTER TABLE alter_table_clause */
  {  231,   -3 }, /* (103) cmd ::= ALTER STABLE alter_table_clause */
  {  256,   -2 }, /* (104) alter_table_clause ::= full_table_name alter_table_options */
  {  256,   -5 }, /* (105) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  256,   -4 }, /* (106) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  256,   -5 }, /* (107) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  256,   -5 }, /* (108) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  256,   -5 }, /* (109) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  256,   -4 }, /* (110) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  256,   -5 }, /* (111) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  256,   -5 }, /* (112) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  256,   -6 }, /* (113) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  253,   -1 }, /* (114) multi_create_clause ::= create_subtable_clause */
  {  253,   -2 }, /* (115) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  260,   -9 }, /* (116) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  255,   -1 }, /* (117) multi_drop_clause ::= drop_table_clause */
  {  255,   -2 }, /* (118) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  263,   -2 }, /* (119) drop_table_clause ::= exists_opt full_table_name */
  {  261,    0 }, /* (120) specific_tags_opt ::= */
  {  261,   -3 }, /* (121) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  249,   -1 }, /* (122) full_table_name ::= table_name */
  {  249,   -3 }, /* (123) full_table_name ::= db_name NK_DOT table_name */
  {  250,   -1 }, /* (124) column_def_list ::= column_def */
  {  250,   -3 }, /* (125) column_def_list ::= column_def_list NK_COMMA column_def */
  {  266,   -2 }, /* (126) column_def ::= column_name type_name */
  {  266,   -4 }, /* (127) column_def ::= column_name type_name COMMENT NK_STRING */
  {  259,   -1 }, /* (128) type_name ::= BOOL */
  {  259,   -1 }, /* (129) type_name ::= TINYINT */
  {  259,   -1 }, /* (130) type_name ::= SMALLINT */
  {  259,   -1 }, /* (131) type_name ::= INT */
  {  259,   -1 }, /* (132) type_name ::= INTEGER */
  {  259,   -1 }, /* (133) type_name ::= BIGINT */
  {  259,   -1 }, /* (134) type_name ::= FLOAT */
  {  259,   -1 }, /* (135) type_name ::= DOUBLE */
  {  259,   -4 }, /* (136) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (137) type_name ::= TIMESTAMP */
  {  259,   -4 }, /* (138) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  259,   -2 }, /* (139) type_name ::= TINYINT UNSIGNED */
  {  259,   -2 }, /* (140) type_name ::= SMALLINT UNSIGNED */
  {  259,   -2 }, /* (141) type_name ::= INT UNSIGNED */
  {  259,   -2 }, /* (142) type_name ::= BIGINT UNSIGNED */
  {  259,   -1 }, /* (143) type_name ::= JSON */
  {  259,   -4 }, /* (144) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (145) type_name ::= MEDIUMBLOB */
  {  259,   -1 }, /* (146) type_name ::= BLOB */
  {  259,   -4 }, /* (147) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (148) type_name ::= DECIMAL */
  {  259,   -4 }, /* (149) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  259,   -6 }, /* (150) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  251,    0 }, /* (151) tags_def_opt ::= */
  {  251,   -1 }, /* (152) tags_def_opt ::= tags_def */
  {  254,   -4 }, /* (153) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  252,    0 }, /* (154) table_options ::= */
  {  252,   -3 }, /* (155) table_options ::= table_options COMMENT NK_STRING */
  {  252,   -3 }, /* (156) table_options ::= table_options KEEP integer_list */
  {  252,   -3 }, /* (157) table_options ::= table_options KEEP variable_list */
  {  252,   -3 }, /* (158) table_options ::= table_options TTL NK_INTEGER */
  {  252,   -5 }, /* (159) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  252,   -5 }, /* (160) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  252,   -3 }, /* (161) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  252,   -3 }, /* (162) table_options ::= table_options DELAY NK_INTEGER */
  {  257,   -1 }, /* (163) alter_table_options ::= alter_table_option */
  {  257,   -2 }, /* (164) alter_table_options ::= alter_table_options alter_table_option */
  {  268,   -2 }, /* (165) alter_table_option ::= COMMENT NK_STRING */
  {  268,   -2 }, /* (166) alter_table_option ::= KEEP integer_list */
  {  268,   -2 }, /* (167) alter_table_option ::= KEEP variable_list */
  {  268,   -2 }, /* (168) alter_table_option ::= TTL NK_INTEGER */
  {  264,   -1 }, /* (169) col_name_list ::= col_name */
  {  264,   -3 }, /* (170) col_name_list ::= col_name_list NK_COMMA col_name */
  {  269,   -1 }, /* (171) col_name ::= column_name */
  {  231,   -2 }, /* (172) cmd ::= SHOW DNODES */
  {  231,   -2 }, /* (173) cmd ::= SHOW USERS */
  {  231,   -2 }, /* (174) cmd ::= SHOW DATABASES */
  {  231,   -4 }, /* (175) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  231,   -4 }, /* (176) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  231,   -3 }, /* (177) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  231,   -2 }, /* (178) cmd ::= SHOW MNODES */
  {  231,   -2 }, /* (179) cmd ::= SHOW MODULES */
  {  231,   -2 }, /* (180) cmd ::= SHOW QNODES */
  {  231,   -2 }, /* (181) cmd ::= SHOW FUNCTIONS */
  {  231,   -5 }, /* (182) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  231,   -2 }, /* (183) cmd ::= SHOW STREAMS */
  {  231,   -2 }, /* (184) cmd ::= SHOW ACCOUNTS */
  {  231,   -2 }, /* (185) cmd ::= SHOW APPS */
  {  231,   -2 }, /* (186) cmd ::= SHOW CONNECTIONS */
  {  231,   -2 }, /* (187) cmd ::= SHOW LICENCE */
  {  231,   -2 }, /* (188) cmd ::= SHOW GRANTS */
  {  231,   -4 }, /* (189) cmd ::= SHOW CREATE DATABASE db_name */
  {  231,   -4 }, /* (190) cmd ::= SHOW CREATE TABLE full_table_name */
  {  231,   -4 }, /* (191) cmd ::= SHOW CREATE STABLE full_table_name */
  {  231,   -2 }, /* (192) cmd ::= SHOW QUERIES */
  {  231,   -2 }, /* (193) cmd ::= SHOW SCORES */
  {  231,   -2 }, /* (194) cmd ::= SHOW TOPICS */
  {  231,   -2 }, /* (195) cmd ::= SHOW VARIABLES */
  {  231,   -2 }, /* (196) cmd ::= SHOW BNODES */
  {  231,   -2 }, /* (197) cmd ::= SHOW SNODES */
  {  231,   -2 }, /* (198) cmd ::= SHOW CLUSTER */
  {  270,    0 }, /* (199) db_name_cond_opt ::= */
  {  270,   -2 }, /* (200) db_name_cond_opt ::= db_name NK_DOT */
  {  271,    0 }, /* (201) like_pattern_opt ::= */
  {  271,   -2 }, /* (202) like_pattern_opt ::= LIKE NK_STRING */
  {  272,   -1 }, /* (203) table_name_cond ::= table_name */
  {  273,    0 }, /* (204) from_db_opt ::= */
  {  273,   -2 }, /* (205) from_db_opt ::= FROM db_name */
  {  267,   -1 }, /* (206) func_name_list ::= func_name */
  {  267,   -3 }, /* (207) func_name_list ::= func_name_list NK_COMMA func_name */
  {  274,   -1 }, /* (208) func_name ::= function_name */
  {  231,   -8 }, /* (209) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  231,  -10 }, /* (210) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  231,   -6 }, /* (211) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  277,    0 }, /* (212) index_options ::= */
  {  277,   -9 }, /* (213) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  277,  -11 }, /* (214) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  278,   -1 }, /* (215) func_list ::= func */
  {  278,   -3 }, /* (216) func_list ::= func_list NK_COMMA func */
  {  281,   -4 }, /* (217) func ::= function_name NK_LP expression_list NK_RP */
  {  231,   -7 }, /* (218) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
  {  231,   -7 }, /* (219) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
  {  231,   -4 }, /* (220) cmd ::= DROP TOPIC exists_opt topic_name */
  {  284,    0 }, /* (221) topic_options ::= */
  {  284,   -3 }, /* (222) topic_options ::= topic_options WITH TABLE */
  {  284,   -3 }, /* (223) topic_options ::= topic_options WITH SCHEMA */
  {  284,   -3 }, /* (224) topic_options ::= topic_options WITH TAG */
  {  231,   -2 }, /* (225) cmd ::= DESC full_table_name */
  {  231,   -2 }, /* (226) cmd ::= DESCRIBE full_table_name */
  {  231,   -3 }, /* (227) cmd ::= RESET QUERY CACHE */
  {  231,   -4 }, /* (228) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  286,    0 }, /* (229) analyze_opt ::= */
  {  286,   -1 }, /* (230) analyze_opt ::= ANALYZE */
  {  287,    0 }, /* (231) explain_options ::= */
  {  287,   -3 }, /* (232) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  287,   -3 }, /* (233) explain_options ::= explain_options RATIO NK_FLOAT */
  {  231,   -6 }, /* (234) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  231,  -10 }, /* (235) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  231,   -3 }, /* (236) cmd ::= DROP FUNCTION function_name */
  {  288,    0 }, /* (237) agg_func_opt ::= */
  {  288,   -1 }, /* (238) agg_func_opt ::= AGGREGATE */
  {  289,    0 }, /* (239) bufsize_opt ::= */
  {  289,   -2 }, /* (240) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  231,   -8 }, /* (241) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  231,   -4 }, /* (242) cmd ::= DROP STREAM exists_opt stream_name */
  {  292,    0 }, /* (243) into_opt ::= */
  {  292,   -2 }, /* (244) into_opt ::= INTO full_table_name */
  {  291,    0 }, /* (245) stream_options ::= */
  {  291,   -3 }, /* (246) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  291,   -3 }, /* (247) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  291,   -3 }, /* (248) stream_options ::= stream_options WATERMARK duration_literal */
  {  231,   -3 }, /* (249) cmd ::= KILL CONNECTION NK_INTEGER */
  {  231,   -3 }, /* (250) cmd ::= KILL QUERY NK_INTEGER */
  {  231,   -4 }, /* (251) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  231,   -4 }, /* (252) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  231,   -3 }, /* (253) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  293,   -2 }, /* (254) dnode_list ::= DNODE NK_INTEGER */
  {  293,   -3 }, /* (255) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  231,   -3 }, /* (256) cmd ::= SYNCDB db_name REPLICA */
  {  231,   -1 }, /* (257) cmd ::= query_expression */
  {  234,   -1 }, /* (258) literal ::= NK_INTEGER */
  {  234,   -1 }, /* (259) literal ::= NK_FLOAT */
  {  234,   -1 }, /* (260) literal ::= NK_STRING */
  {  234,   -1 }, /* (261) literal ::= NK_BOOL */
  {  234,   -2 }, /* (262) literal ::= TIMESTAMP NK_STRING */
  {  234,   -1 }, /* (263) literal ::= duration_literal */
  {  234,   -1 }, /* (264) literal ::= NULL */
  {  234,   -1 }, /* (265) literal ::= NK_QUESTION */
  {  279,   -1 }, /* (266) duration_literal ::= NK_VARIABLE */
  {  294,   -1 }, /* (267) signed ::= NK_INTEGER */
  {  294,   -2 }, /* (268) signed ::= NK_PLUS NK_INTEGER */
  {  294,   -2 }, /* (269) signed ::= NK_MINUS NK_INTEGER */
  {  294,   -1 }, /* (270) signed ::= NK_FLOAT */
  {  294,   -2 }, /* (271) signed ::= NK_PLUS NK_FLOAT */
  {  294,   -2 }, /* (272) signed ::= NK_MINUS NK_FLOAT */
  {  295,   -1 }, /* (273) signed_literal ::= signed */
  {  295,   -1 }, /* (274) signed_literal ::= NK_STRING */
  {  295,   -1 }, /* (275) signed_literal ::= NK_BOOL */
  {  295,   -2 }, /* (276) signed_literal ::= TIMESTAMP NK_STRING */
  {  295,   -1 }, /* (277) signed_literal ::= duration_literal */
  {  295,   -1 }, /* (278) signed_literal ::= NULL */
  {  295,   -1 }, /* (279) signed_literal ::= literal_func */
  {  262,   -1 }, /* (280) literal_list ::= signed_literal */
  {  262,   -3 }, /* (281) literal_list ::= literal_list NK_COMMA signed_literal */
  {  240,   -1 }, /* (282) db_name ::= NK_ID */
  {  265,   -1 }, /* (283) table_name ::= NK_ID */
  {  258,   -1 }, /* (284) column_name ::= NK_ID */
  {  275,   -1 }, /* (285) function_name ::= NK_ID */
  {  297,   -1 }, /* (286) table_alias ::= NK_ID */
  {  298,   -1 }, /* (287) column_alias ::= NK_ID */
  {  236,   -1 }, /* (288) user_name ::= NK_ID */
  {  276,   -1 }, /* (289) index_name ::= NK_ID */
  {  283,   -1 }, /* (290) topic_name ::= NK_ID */
  {  290,   -1 }, /* (291) stream_name ::= NK_ID */
  {  299,   -1 }, /* (292) expression ::= literal */
  {  299,   -1 }, /* (293) expression ::= pseudo_column */
  {  299,   -1 }, /* (294) expression ::= column_reference */
  {  299,   -1 }, /* (295) expression ::= function_expression */
  {  299,   -1 }, /* (296) expression ::= subquery */
  {  299,   -3 }, /* (297) expression ::= NK_LP expression NK_RP */
  {  299,   -2 }, /* (298) expression ::= NK_PLUS expression */
  {  299,   -2 }, /* (299) expression ::= NK_MINUS expression */
  {  299,   -3 }, /* (300) expression ::= expression NK_PLUS expression */
  {  299,   -3 }, /* (301) expression ::= expression NK_MINUS expression */
  {  299,   -3 }, /* (302) expression ::= expression NK_STAR expression */
  {  299,   -3 }, /* (303) expression ::= expression NK_SLASH expression */
  {  299,   -3 }, /* (304) expression ::= expression NK_REM expression */
  {  299,   -3 }, /* (305) expression ::= column_reference NK_ARROW NK_STRING */
  {  282,   -1 }, /* (306) expression_list ::= expression */
  {  282,   -3 }, /* (307) expression_list ::= expression_list NK_COMMA expression */
  {  301,   -1 }, /* (308) column_reference ::= column_name */
  {  301,   -3 }, /* (309) column_reference ::= table_name NK_DOT column_name */
  {  300,   -1 }, /* (310) pseudo_column ::= ROWTS */
  {  300,   -1 }, /* (311) pseudo_column ::= TBNAME */
  {  300,   -1 }, /* (312) pseudo_column ::= QSTARTTS */
  {  300,   -1 }, /* (313) pseudo_column ::= QENDTS */
  {  300,   -1 }, /* (314) pseudo_column ::= WSTARTTS */
  {  300,   -1 }, /* (315) pseudo_column ::= WENDTS */
  {  300,   -1 }, /* (316) pseudo_column ::= WDURATION */
  {  302,   -4 }, /* (317) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  302,   -4 }, /* (318) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  302,   -6 }, /* (319) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  302,   -1 }, /* (320) function_expression ::= literal_func */
  {  296,   -3 }, /* (321) literal_func ::= noarg_func NK_LP NK_RP */
  {  296,   -1 }, /* (322) literal_func ::= NOW */
  {  306,   -1 }, /* (323) noarg_func ::= NOW */
  {  306,   -1 }, /* (324) noarg_func ::= TODAY */
  {  306,   -1 }, /* (325) noarg_func ::= TIMEZONE */
  {  304,   -1 }, /* (326) star_func ::= COUNT */
  {  304,   -1 }, /* (327) star_func ::= FIRST */
  {  304,   -1 }, /* (328) star_func ::= LAST */
  {  304,   -1 }, /* (329) star_func ::= LAST_ROW */
  {  305,   -1 }, /* (330) star_func_para_list ::= NK_STAR */
  {  305,   -1 }, /* (331) star_func_para_list ::= other_para_list */
  {  307,   -1 }, /* (332) other_para_list ::= star_func_para */
  {  307,   -3 }, /* (333) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  308,   -1 }, /* (334) star_func_para ::= expression */
  {  308,   -3 }, /* (335) star_func_para ::= table_name NK_DOT NK_STAR */
  {  309,   -3 }, /* (336) predicate ::= expression compare_op expression */
  {  309,   -5 }, /* (337) predicate ::= expression BETWEEN expression AND expression */
  {  309,   -6 }, /* (338) predicate ::= expression NOT BETWEEN expression AND expression */
  {  309,   -3 }, /* (339) predicate ::= expression IS NULL */
  {  309,   -4 }, /* (340) predicate ::= expression IS NOT NULL */
  {  309,   -3 }, /* (341) predicate ::= expression in_op in_predicate_value */
  {  310,   -1 }, /* (342) compare_op ::= NK_LT */
  {  310,   -1 }, /* (343) compare_op ::= NK_GT */
  {  310,   -1 }, /* (344) compare_op ::= NK_LE */
  {  310,   -1 }, /* (345) compare_op ::= NK_GE */
  {  310,   -1 }, /* (346) compare_op ::= NK_NE */
  {  310,   -1 }, /* (347) compare_op ::= NK_EQ */
  {  310,   -1 }, /* (348) compare_op ::= LIKE */
  {  310,   -2 }, /* (349) compare_op ::= NOT LIKE */
  {  310,   -1 }, /* (350) compare_op ::= MATCH */
  {  310,   -1 }, /* (351) compare_op ::= NMATCH */
  {  310,   -1 }, /* (352) compare_op ::= CONTAINS */
  {  311,   -1 }, /* (353) in_op ::= IN */
  {  311,   -2 }, /* (354) in_op ::= NOT IN */
  {  312,   -3 }, /* (355) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  313,   -1 }, /* (356) boolean_value_expression ::= boolean_primary */
  {  313,   -2 }, /* (357) boolean_value_expression ::= NOT boolean_primary */
  {  313,   -3 }, /* (358) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  313,   -3 }, /* (359) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  314,   -1 }, /* (360) boolean_primary ::= predicate */
  {  314,   -3 }, /* (361) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  315,   -1 }, /* (362) common_expression ::= expression */
  {  315,   -1 }, /* (363) common_expression ::= boolean_value_expression */
  {  316,   -2 }, /* (364) from_clause ::= FROM table_reference_list */
  {  317,   -1 }, /* (365) table_reference_list ::= table_reference */
  {  317,   -3 }, /* (366) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  318,   -1 }, /* (367) table_reference ::= table_primary */
  {  318,   -1 }, /* (368) table_reference ::= joined_table */
  {  319,   -2 }, /* (369) table_primary ::= table_name alias_opt */
  {  319,   -4 }, /* (370) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  319,   -2 }, /* (371) table_primary ::= subquery alias_opt */
  {  319,   -1 }, /* (372) table_primary ::= parenthesized_joined_table */
  {  321,    0 }, /* (373) alias_opt ::= */
  {  321,   -1 }, /* (374) alias_opt ::= table_alias */
  {  321,   -2 }, /* (375) alias_opt ::= AS table_alias */
  {  322,   -3 }, /* (376) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  322,   -3 }, /* (377) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  320,   -6 }, /* (378) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  323,    0 }, /* (379) join_type ::= */
  {  323,   -1 }, /* (380) join_type ::= INNER */
  {  325,   -9 }, /* (381) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  326,    0 }, /* (382) set_quantifier_opt ::= */
  {  326,   -1 }, /* (383) set_quantifier_opt ::= DISTINCT */
  {  326,   -1 }, /* (384) set_quantifier_opt ::= ALL */
  {  327,   -1 }, /* (385) select_list ::= NK_STAR */
  {  327,   -1 }, /* (386) select_list ::= select_sublist */
  {  333,   -1 }, /* (387) select_sublist ::= select_item */
  {  333,   -3 }, /* (388) select_sublist ::= select_sublist NK_COMMA select_item */
  {  334,   -1 }, /* (389) select_item ::= common_expression */
  {  334,   -2 }, /* (390) select_item ::= common_expression column_alias */
  {  334,   -3 }, /* (391) select_item ::= common_expression AS column_alias */
  {  334,   -3 }, /* (392) select_item ::= table_name NK_DOT NK_STAR */
  {  328,    0 }, /* (393) where_clause_opt ::= */
  {  328,   -2 }, /* (394) where_clause_opt ::= WHERE search_condition */
  {  329,    0 }, /* (395) partition_by_clause_opt ::= */
  {  329,   -3 }, /* (396) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  330,    0 }, /* (397) twindow_clause_opt ::= */
  {  330,   -6 }, /* (398) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  330,   -4 }, /* (399) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  330,   -6 }, /* (400) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  330,   -8 }, /* (401) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  280,    0 }, /* (402) sliding_opt ::= */
  {  280,   -4 }, /* (403) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  335,    0 }, /* (404) fill_opt ::= */
  {  335,   -4 }, /* (405) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  335,   -6 }, /* (406) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  336,   -1 }, /* (407) fill_mode ::= NONE */
  {  336,   -1 }, /* (408) fill_mode ::= PREV */
  {  336,   -1 }, /* (409) fill_mode ::= NULL */
  {  336,   -1 }, /* (410) fill_mode ::= LINEAR */
  {  336,   -1 }, /* (411) fill_mode ::= NEXT */
  {  331,    0 }, /* (412) group_by_clause_opt ::= */
  {  331,   -3 }, /* (413) group_by_clause_opt ::= GROUP BY group_by_list */
  {  337,   -1 }, /* (414) group_by_list ::= expression */
  {  337,   -3 }, /* (415) group_by_list ::= group_by_list NK_COMMA expression */
  {  332,    0 }, /* (416) having_clause_opt ::= */
  {  332,   -2 }, /* (417) having_clause_opt ::= HAVING search_condition */
  {  285,   -4 }, /* (418) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  338,   -1 }, /* (419) query_expression_body ::= query_primary */
  {  338,   -4 }, /* (420) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  338,   -3 }, /* (421) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  342,   -1 }, /* (422) query_primary ::= query_specification */
  {  339,    0 }, /* (423) order_by_clause_opt ::= */
  {  339,   -3 }, /* (424) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  340,    0 }, /* (425) slimit_clause_opt ::= */
  {  340,   -2 }, /* (426) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  340,   -4 }, /* (427) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  340,   -4 }, /* (428) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  341,    0 }, /* (429) limit_clause_opt ::= */
  {  341,   -2 }, /* (430) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  341,   -4 }, /* (431) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  341,   -4 }, /* (432) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  303,   -3 }, /* (433) subquery ::= NK_LP query_expression NK_RP */
  {  324,   -1 }, /* (434) search_condition ::= common_expression */
  {  343,   -1 }, /* (435) sort_specification_list ::= sort_specification */
  {  343,   -3 }, /* (436) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  344,   -3 }, /* (437) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  345,    0 }, /* (438) ordering_specification_opt ::= */
  {  345,   -1 }, /* (439) ordering_specification_opt ::= ASC */
  {  345,   -1 }, /* (440) ordering_specification_opt ::= DESC */
  {  346,    0 }, /* (441) null_ordering_opt ::= */
  {  346,   -2 }, /* (442) null_ordering_opt ::= NULLS FIRST */
  {  346,   -2 }, /* (443) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,232,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,233,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,232,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,234,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,235,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,233,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,235,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,234,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy555, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy555, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy555, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 282: /* db_name ::= NK_ID */ yytestcase(yyruleno==282);
      case 283: /* table_name ::= NK_ID */ yytestcase(yyruleno==283);
      case 284: /* column_name ::= NK_ID */ yytestcase(yyruleno==284);
      case 285: /* function_name ::= NK_ID */ yytestcase(yyruleno==285);
      case 286: /* table_alias ::= NK_ID */ yytestcase(yyruleno==286);
      case 287: /* column_alias ::= NK_ID */ yytestcase(yyruleno==287);
      case 288: /* user_name ::= NK_ID */ yytestcase(yyruleno==288);
      case 289: /* index_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* topic_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* stream_name ::= NK_ID */ yytestcase(yyruleno==291);
      case 323: /* noarg_func ::= NOW */ yytestcase(yyruleno==323);
      case 324: /* noarg_func ::= TODAY */ yytestcase(yyruleno==324);
      case 325: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==325);
      case 326: /* star_func ::= COUNT */ yytestcase(yyruleno==326);
      case 327: /* star_func ::= FIRST */ yytestcase(yyruleno==327);
      case 328: /* star_func ::= LAST */ yytestcase(yyruleno==328);
      case 329: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==329);
{ yylhsminor.yy555 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy555 = yylhsminor.yy555;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy617, &yymsp[-1].minor.yy555, yymsp[0].minor.yy662); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy555); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy555, yymsp[0].minor.yy662); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy617 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 229: /* analyze_opt ::= */ yytestcase(yyruleno==229);
      case 237: /* agg_func_opt ::= */ yytestcase(yyruleno==237);
      case 382: /* set_quantifier_opt ::= */ yytestcase(yyruleno==382);
{ yymsp[1].minor.yy617 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy617 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy662 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pKeep = yymsp[0].minor.yy568; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pRetentions = yymsp[0].minor.yy568; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 78: /* db_options ::= db_options STRICT NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy662)->pStrict = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 79: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy662 = createDatabaseOptions(pCxt); yylhsminor.yy662 = setDatabaseAlterOption(pCxt, yylhsminor.yy662, &yymsp[0].minor.yy475); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 80: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy662 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy662, &yymsp[0].minor.yy475); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 81: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 83: /* alter_db_option ::= KEEP integer_list */
      case 84: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==84);
{ yymsp[-1].minor.yy475.type = DB_OPTION_KEEP; yymsp[-1].minor.yy475.pList = yymsp[0].minor.yy568; }
        break;
      case 85: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_WAL; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 89: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_STRICT; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 90: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy568 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 91: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 255: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==255);
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 92: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy568 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 93: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 94: /* retention_list ::= retention */
      case 114: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==114);
      case 117: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==117);
      case 124: /* column_def_list ::= column_def */ yytestcase(yyruleno==124);
      case 169: /* col_name_list ::= col_name */ yytestcase(yyruleno==169);
      case 206: /* func_name_list ::= func_name */ yytestcase(yyruleno==206);
      case 215: /* func_list ::= func */ yytestcase(yyruleno==215);
      case 280: /* literal_list ::= signed_literal */ yytestcase(yyruleno==280);
      case 332: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==332);
      case 387: /* select_sublist ::= select_item */ yytestcase(yyruleno==387);
      case 435: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==435);
{ yylhsminor.yy568 = createNodeList(pCxt, yymsp[0].minor.yy662); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 95: /* retention_list ::= retention_list NK_COMMA retention */
      case 125: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==125);
      case 170: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==170);
      case 207: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==207);
      case 216: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==216);
      case 281: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==281);
      case 333: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==333);
      case 388: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==388);
      case 436: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==436);
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, yymsp[0].minor.yy662); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 96: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy662 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 97: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 99: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==99);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-5].minor.yy662, yymsp[-3].minor.yy568, yymsp[-1].minor.yy568, yymsp[0].minor.yy662); }
        break;
      case 98: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy568); }
        break;
      case 100: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy568); }
        break;
      case 101: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy662); }
        break;
      case 102: /* cmd ::= ALTER TABLE alter_table_clause */
      case 103: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==103);
      case 257: /* cmd ::= query_expression */ yytestcase(yyruleno==257);
{ pCxt->pRootNode = yymsp[0].minor.yy662; }
        break;
      case 104: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy662 = createAlterTableOption(pCxt, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 105: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 106: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy662 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy662, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy555); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 107: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 108: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy662 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 109: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 110: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy662 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy662, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy555); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 111: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 112: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy662 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 113: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy662 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy662, &yymsp[-2].minor.yy555, yymsp[0].minor.yy662); }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 115: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 118: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==118);
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-1].minor.yy568, yymsp[0].minor.yy662); }
  yymsp[-1].minor.yy568 = yylhsminor.yy568;
        break;
      case 116: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy662 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy617, yymsp[-7].minor.yy662, yymsp[-5].minor.yy662, yymsp[-4].minor.yy568, yymsp[-1].minor.yy568); }
  yymsp[-8].minor.yy662 = yylhsminor.yy662;
        break;
      case 119: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy662 = createDropTableClause(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy662); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 120: /* specific_tags_opt ::= */
      case 151: /* tags_def_opt ::= */ yytestcase(yyruleno==151);
      case 395: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==395);
      case 412: /* group_by_clause_opt ::= */ yytestcase(yyruleno==412);
      case 423: /* order_by_clause_opt ::= */ yytestcase(yyruleno==423);
{ yymsp[1].minor.yy568 = NULL; }
        break;
      case 121: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy568 = yymsp[-1].minor.yy568; }
        break;
      case 122: /* full_table_name ::= table_name */
{ yylhsminor.yy662 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy555, NULL); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 123: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy662 = createRealTableNode(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555, NULL); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 126: /* column_def ::= column_name type_name */
{ yylhsminor.yy662 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156, NULL); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 127: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy662 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy555, yymsp[-2].minor.yy156, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 128: /* type_name ::= BOOL */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 129: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 130: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 131: /* type_name ::= INT */
      case 132: /* type_name ::= INTEGER */ yytestcase(yyruleno==132);
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 133: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 134: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 135: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 136: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 138: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 139: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 140: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 141: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 142: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 143: /* type_name ::= JSON */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 144: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 145: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 146: /* type_name ::= BLOB */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 147: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 149: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy156 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 152: /* tags_def_opt ::= tags_def */
      case 331: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==331);
      case 386: /* select_list ::= select_sublist */ yytestcase(yyruleno==386);
{ yylhsminor.yy568 = yymsp[0].minor.yy568; }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 153: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy568 = yymsp[-1].minor.yy568; }
        break;
      case 154: /* table_options ::= */
{ yymsp[1].minor.yy662 = createTableOptions(pCxt); }
        break;
      case 155: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy662)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 156: /* table_options ::= table_options KEEP integer_list */
      case 157: /* table_options ::= table_options KEEP variable_list */ yytestcase(yyruleno==157);
{ ((STableOptions*)yymsp[-2].minor.yy662)->pKeep = yymsp[0].minor.yy568; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 158: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy662)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 159: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy662)->pSma = yymsp[-1].minor.yy568; yylhsminor.yy662 = yymsp[-4].minor.yy662; }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 160: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy662)->pFuncs = yymsp[-1].minor.yy568; yylhsminor.yy662 = yymsp[-4].minor.yy662; }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 161: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy662)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 162: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy662)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 163: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy662 = createTableOptions(pCxt); yylhsminor.yy662 = setTableAlterOption(pCxt, yylhsminor.yy662, &yymsp[0].minor.yy475); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 164: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy662 = setTableAlterOption(pCxt, yymsp[-1].minor.yy662, &yymsp[0].minor.yy475); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 165: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy475.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 166: /* alter_table_option ::= KEEP integer_list */
      case 167: /* alter_table_option ::= KEEP variable_list */ yytestcase(yyruleno==167);
{ yymsp[-1].minor.yy475.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy475.pList = yymsp[0].minor.yy568; }
        break;
      case 168: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy475.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy475.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 171: /* col_name ::= column_name */
{ yylhsminor.yy662 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy555); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 172: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 173: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 176: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 177: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy662, NULL); }
        break;
      case 178: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 181: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 183: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 185: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW LICENCE */
      case 188: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==188);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 190: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy662); }
        break;
      case 191: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy662); }
        break;
      case 192: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 195: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 196: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 199: /* db_name_cond_opt ::= */
      case 204: /* from_db_opt ::= */ yytestcase(yyruleno==204);
{ yymsp[1].minor.yy662 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 200: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 201: /* like_pattern_opt ::= */
      case 212: /* index_options ::= */ yytestcase(yyruleno==212);
      case 243: /* into_opt ::= */ yytestcase(yyruleno==243);
      case 393: /* where_clause_opt ::= */ yytestcase(yyruleno==393);
      case 397: /* twindow_clause_opt ::= */ yytestcase(yyruleno==397);
      case 402: /* sliding_opt ::= */ yytestcase(yyruleno==402);
      case 404: /* fill_opt ::= */ yytestcase(yyruleno==404);
      case 416: /* having_clause_opt ::= */ yytestcase(yyruleno==416);
      case 425: /* slimit_clause_opt ::= */ yytestcase(yyruleno==425);
      case 429: /* limit_clause_opt ::= */ yytestcase(yyruleno==429);
{ yymsp[1].minor.yy662 = NULL; }
        break;
      case 202: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 203: /* table_name_cond ::= table_name */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy555); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 205: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy555); }
        break;
      case 208: /* func_name ::= function_name */
{ yylhsminor.yy662 = createFunctionNode(pCxt, &yymsp[0].minor.yy555, NULL); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 209: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy555, &yymsp[-1].minor.yy555, NULL, yymsp[0].minor.yy662); }
        break;
      case 210: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy617, &yymsp[-5].minor.yy555, &yymsp[-3].minor.yy555, yymsp[-1].minor.yy568, NULL); }
        break;
      case 211: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555); }
        break;
      case 213: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy662 = createIndexOption(pCxt, yymsp[-6].minor.yy568, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), NULL, yymsp[0].minor.yy662); }
        break;
      case 214: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy662 = createIndexOption(pCxt, yymsp[-8].minor.yy568, releaseRawExprNode(pCxt, yymsp[-4].minor.yy662), releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), yymsp[0].minor.yy662); }
        break;
      case 217: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy662 = createFunctionNode(pCxt, &yymsp[-3].minor.yy555, yymsp[-1].minor.yy568); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 218: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy555, yymsp[0].minor.yy662, NULL, yymsp[-2].minor.yy662); }
        break;
      case 219: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy555, NULL, &yymsp[0].minor.yy555, yymsp[-2].minor.yy662); }
        break;
      case 220: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy555); }
        break;
      case 221: /* topic_options ::= */
{ yymsp[1].minor.yy662 = createTopicOptions(pCxt); }
        break;
      case 222: /* topic_options ::= topic_options WITH TABLE */
{ ((STopicOptions*)yymsp[-2].minor.yy662)->withTable = true; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 223: /* topic_options ::= topic_options WITH SCHEMA */
{ ((STopicOptions*)yymsp[-2].minor.yy662)->withSchema = true; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 224: /* topic_options ::= topic_options WITH TAG */
{ ((STopicOptions*)yymsp[-2].minor.yy662)->withTag = true; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 225: /* cmd ::= DESC full_table_name */
      case 226: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==226);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy662); }
        break;
      case 227: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 228: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy617, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 230: /* analyze_opt ::= ANALYZE */
      case 238: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==238);
      case 383: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==383);
{ yymsp[0].minor.yy617 = true; }
        break;
      case 231: /* explain_options ::= */
{ yymsp[1].minor.yy662 = createDefaultExplainOptions(pCxt); }
        break;
      case 232: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy662 = setExplainVerbose(pCxt, yymsp[-2].minor.yy662, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 233: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy662 = setExplainRatio(pCxt, yymsp[-2].minor.yy662, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 234: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy568); }
        break;
      case 235: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-8].minor.yy617, &yymsp[-5].minor.yy555, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy156, yymsp[0].minor.yy610); }
        break;
      case 236: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 239: /* bufsize_opt ::= */
{ yymsp[1].minor.yy610 = 0; }
        break;
      case 240: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy610 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 241: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy617, &yymsp[-4].minor.yy555, yymsp[-2].minor.yy662, yymsp[-3].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 242: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy555); }
        break;
      case 244: /* into_opt ::= INTO full_table_name */
      case 364: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==364);
      case 394: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==394);
      case 417: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==417);
{ yymsp[-1].minor.yy662 = yymsp[0].minor.yy662; }
        break;
      case 245: /* stream_options ::= */
{ yymsp[1].minor.yy662 = createStreamOptions(pCxt); }
        break;
      case 246: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy662)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 247: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy662)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 248: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy662)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy662); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 249: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 250: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 251: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 252: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy568); }
        break;
      case 253: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 254: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy568 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 256: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy555); }
        break;
      case 258: /* literal ::= NK_INTEGER */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 259: /* literal ::= NK_FLOAT */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 260: /* literal ::= NK_STRING */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 261: /* literal ::= NK_BOOL */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 262: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 263: /* literal ::= duration_literal */
      case 273: /* signed_literal ::= signed */ yytestcase(yyruleno==273);
      case 292: /* expression ::= literal */ yytestcase(yyruleno==292);
      case 293: /* expression ::= pseudo_column */ yytestcase(yyruleno==293);
      case 294: /* expression ::= column_reference */ yytestcase(yyruleno==294);
      case 295: /* expression ::= function_expression */ yytestcase(yyruleno==295);
      case 296: /* expression ::= subquery */ yytestcase(yyruleno==296);
      case 320: /* function_expression ::= literal_func */ yytestcase(yyruleno==320);
      case 356: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==356);
      case 360: /* boolean_primary ::= predicate */ yytestcase(yyruleno==360);
      case 362: /* common_expression ::= expression */ yytestcase(yyruleno==362);
      case 363: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==363);
      case 365: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==365);
      case 367: /* table_reference ::= table_primary */ yytestcase(yyruleno==367);
      case 368: /* table_reference ::= joined_table */ yytestcase(yyruleno==368);
      case 372: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==372);
      case 419: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==419);
      case 422: /* query_primary ::= query_specification */ yytestcase(yyruleno==422);
{ yylhsminor.yy662 = yymsp[0].minor.yy662; }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 264: /* literal ::= NULL */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 265: /* literal ::= NK_QUESTION */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 266: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 267: /* signed ::= NK_INTEGER */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 268: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 269: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 270: /* signed ::= NK_FLOAT */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 271: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 272: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 274: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 275: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 276: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 277: /* signed_literal ::= duration_literal */
      case 279: /* signed_literal ::= literal_func */ yytestcase(yyruleno==279);
      case 334: /* star_func_para ::= expression */ yytestcase(yyruleno==334);
      case 389: /* select_item ::= common_expression */ yytestcase(yyruleno==389);
      case 434: /* search_condition ::= common_expression */ yytestcase(yyruleno==434);
{ yylhsminor.yy662 = releaseRawExprNode(pCxt, yymsp[0].minor.yy662); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 278: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 297: /* expression ::= NK_LP expression NK_RP */
      case 361: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==361);
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 298: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy662));
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 299: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy662), NULL));
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 300: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 301: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 302: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 303: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 304: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 305: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 306: /* expression_list ::= expression */
{ yylhsminor.yy568 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy662)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 307: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, releaseRawExprNode(pCxt, yymsp[0].minor.yy662)); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 308: /* column_reference ::= column_name */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy555, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy555)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 309: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555, createColumnNode(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 310: /* pseudo_column ::= ROWTS */
      case 311: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==311);
      case 312: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==312);
      case 313: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==313);
      case 314: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==314);
      case 315: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==315);
      case 316: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==316);
      case 322: /* literal_func ::= NOW */ yytestcase(yyruleno==322);
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 317: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 318: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==318);
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy555, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy555, yymsp[-1].minor.yy568)); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 319: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), yymsp[-1].minor.yy156)); }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 321: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy555, NULL)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 330: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy568 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 335: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 392: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==392);
{ yylhsminor.yy662 = createColumnNode(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 336: /* predicate ::= expression compare_op expression */
      case 341: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==341);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy304, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 337: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy662), releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 338: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy662), releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 339: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), NULL));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 340: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), NULL));
                                                                                  }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 342: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy304 = OP_TYPE_LOWER_THAN; }
        break;
      case 343: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy304 = OP_TYPE_GREATER_THAN; }
        break;
      case 344: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy304 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 345: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy304 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 346: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy304 = OP_TYPE_NOT_EQUAL; }
        break;
      case 347: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy304 = OP_TYPE_EQUAL; }
        break;
      case 348: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy304 = OP_TYPE_LIKE; }
        break;
      case 349: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy304 = OP_TYPE_NOT_LIKE; }
        break;
      case 350: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy304 = OP_TYPE_MATCH; }
        break;
      case 351: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy304 = OP_TYPE_NMATCH; }
        break;
      case 352: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy304 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 353: /* in_op ::= IN */
{ yymsp[0].minor.yy304 = OP_TYPE_IN; }
        break;
      case 354: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy304 = OP_TYPE_NOT_IN; }
        break;
      case 355: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy568)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 357: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy662), NULL));
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 358: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 359: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 366: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy662 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy662, yymsp[0].minor.yy662, NULL); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 369: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy662 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 370: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy662 = createRealTableNode(pCxt, &yymsp[-3].minor.yy555, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 371: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy662 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662), &yymsp[0].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 373: /* alias_opt ::= */
{ yymsp[1].minor.yy555 = nil_token;  }
        break;
      case 374: /* alias_opt ::= table_alias */
{ yylhsminor.yy555 = yymsp[0].minor.yy555; }
  yymsp[0].minor.yy555 = yylhsminor.yy555;
        break;
      case 375: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy555 = yymsp[0].minor.yy555; }
        break;
      case 376: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 377: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==377);
{ yymsp[-2].minor.yy662 = yymsp[-1].minor.yy662; }
        break;
      case 378: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy662 = createJoinTableNode(pCxt, yymsp[-4].minor.yy84, yymsp[-5].minor.yy662, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 379: /* join_type ::= */
{ yymsp[1].minor.yy84 = JOIN_TYPE_INNER; }
        break;
      case 380: /* join_type ::= INNER */
{ yymsp[0].minor.yy84 = JOIN_TYPE_INNER; }
        break;
      case 381: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy662 = createSelectStmt(pCxt, yymsp[-7].minor.yy617, yymsp[-6].minor.yy568, yymsp[-5].minor.yy662);
                                                                                    yymsp[-8].minor.yy662 = addWhereClause(pCxt, yymsp[-8].minor.yy662, yymsp[-4].minor.yy662);
                                                                                    yymsp[-8].minor.yy662 = addPartitionByClause(pCxt, yymsp[-8].minor.yy662, yymsp[-3].minor.yy568);
                                                                                    yymsp[-8].minor.yy662 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy662, yymsp[-2].minor.yy662);
                                                                                    yymsp[-8].minor.yy662 = addGroupByClause(pCxt, yymsp[-8].minor.yy662, yymsp[-1].minor.yy568);
                                                                                    yymsp[-8].minor.yy662 = addHavingClause(pCxt, yymsp[-8].minor.yy662, yymsp[0].minor.yy662);
                                                                                  }
        break;
      case 384: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy617 = false; }
        break;
      case 385: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy568 = NULL; }
        break;
      case 390: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy662 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662), &yymsp[0].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 391: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy662 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), &yymsp[0].minor.yy555); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 396: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 413: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==413);
      case 424: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==424);
{ yymsp[-2].minor.yy568 = yymsp[0].minor.yy568; }
        break;
      case 398: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy662 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), releaseRawExprNode(pCxt, yymsp[-1].minor.yy662)); }
        break;
      case 399: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy662 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662)); }
        break;
      case 400: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy662 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), NULL, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 401: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy662 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy662), releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 403: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy662 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy662); }
        break;
      case 405: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy662 = createFillNode(pCxt, yymsp[-1].minor.yy284, NULL); }
        break;
      case 406: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy662 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy568)); }
        break;
      case 407: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy284 = FILL_MODE_NONE; }
        break;
      case 408: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy284 = FILL_MODE_PREV; }
        break;
      case 409: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy284 = FILL_MODE_NULL; }
        break;
      case 410: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy284 = FILL_MODE_LINEAR; }
        break;
      case 411: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy284 = FILL_MODE_NEXT; }
        break;
      case 414: /* group_by_list ::= expression */
{ yylhsminor.yy568 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 415: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 418: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy662 = addOrderByClause(pCxt, yymsp[-3].minor.yy662, yymsp[-2].minor.yy568);
                                                                                    yylhsminor.yy662 = addSlimitClause(pCxt, yylhsminor.yy662, yymsp[-1].minor.yy662);
                                                                                    yylhsminor.yy662 = addLimitClause(pCxt, yylhsminor.yy662, yymsp[0].minor.yy662);
                                                                                  }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 420: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy662 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 421: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy662 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 426: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 430: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==430);
{ yymsp[-1].minor.yy662 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 427: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 431: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==431);
{ yymsp[-3].minor.yy662 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 428: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 432: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==432);
{ yymsp[-3].minor.yy662 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 433: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy662); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 437: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy662 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), yymsp[-1].minor.yy272, yymsp[0].minor.yy181); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 438: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy272 = ORDER_ASC; }
        break;
      case 439: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy272 = ORDER_ASC; }
        break;
      case 440: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy272 = ORDER_DESC; }
        break;
      case 441: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy181 = NULL_ORDER_DEFAULT; }
        break;
      case 442: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy181 = NULL_ORDER_FIRST; }
        break;
      case 443: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy181 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
