# Contributing

We appreciate contributions from all developers. Feel free to follow us, fork the repository, report bugs, and even submit your code on GitHub. However, we would like developers to follow the guidelines in this document to ensure effective cooperation.

## Reporting a bug

- Any users can report bugs to us through the **[GitHub issue tracker](https://github.com/taosdata/TDengine/issues)**. We would appreciate if you could provide **a detailed description** of the problem you encountered, including steps to reproduce it.

- Attaching log files caused by the bug is really appreciated.

## Guidelines for committing code

- You must agree to the **Contributor License Agreement(CLA) before submitting your code patch**. Follow the **[TAOSData CLA](https://cla-assistant.io/taosdata/TDengine)** link to read through and sign the agreement. If you do not accept the agreement, your contributions cannot be accepted.

- Please solve an issue or add a feature registered in the **[GitHub issue tracker](https://github.com/taosdata/TDengine/issues)**.
- If no corresponding issue or feature is found in the issue tracker, please **create one**.
- When submitting your code to our repository, please create a pull request with the **issue number** included.

## Guidelines for communicating

1. Please be **nice and polite** in the description.
2. **Active voice is better than passive voice in general**. Sentences in the active voice will highlight who is performing the action rather than the recipient of the action highlighted by the passive voice.
3. Documentation writing advice

- Spell the product name "TDengine" correctly. "TD" is written in capital letters, and there is no space between "TD" and "engine" (**Correct spelling: TDengine**).
- Please **capitalize the first letter** of every sentence.
- Leave **only one space** after periods or other punctuation marks.
- Use **American spelling**.
- When possible, **use second person** rather than first person (e.g.“You are recommended to use a reverse proxy such as Nginx.” rather than “We recommend to use a reverse proxy such as Nginx.”).

5. Use **simple sentences**, rather than complex sentences.

## Gifts for the contributors

Developers, as long as you contribute to TDengine, whether it's code contributions to fix bugs or feature requests, or documentation changes, **you are eligible for a very special Contributor Souvenir Gift!**

**You can choose one of the following gifts:**

<p align="left">
  <img
    src="docs/assets/contributing-cup.jpg"
    alt=""
    width="200"
  />
  <img
    src="docs/assets/contributing-notebook.jpg"
    alt=""
    width="200"
  />
  <img
    src="docs/assets/contributing-shirt.jpg"
    alt=""
    width="200"
    />

The TDengine community is committed to making TDengine accepted and used by more developers.

Just fill out the **Contributor Submission Form** to choose your desired gift.

- [Contributor Submission Form](https://page.ma.scrmtech.com/form/index?pf_uid=27715_2095&id=12100)

## Contact us

If you have any problems or questions that need help from us, please feel free to add our WeChat account: TDengineECO.
