/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 379
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy58;
  bool yy151;
  int8_t yy285;
  SNodeList* yy356;
  SToken yy361;
  SAlterOption yy409;
  int64_t yy457;
  EFillMode yy494;
  EJoinType yy504;
  EOperatorType yy526;
  SDataType yy600;
  ENullOrder yy613;
  SNode* yy616;
  int32_t yy734;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             666
#define YYNRULE              491
#define YYNTOKEN             257
#define YY_MAX_SHIFT         665
#define YY_MIN_SHIFTREDUCE   972
#define YY_MAX_SHIFTREDUCE   1462
#define YY_ERROR_ACTION      1463
#define YY_ACCEPT_ACTION     1464
#define YY_NO_ACTION         1465
#define YY_MIN_REDUCE        1466
#define YY_MAX_REDUCE        1956
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2458)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   525,   30,  261,  525,  548,  433,  525,  434, 1501,   11,
 /*    10 */    10,  117,   39,   37,   55, 1652, 1653,  117,  471,  378,
 /*    20 */   339, 1467, 1263, 1005,  476, 1022,  551, 1021, 1606, 1790,
 /*    30 */  1597, 1606,  127, 1339, 1606, 1261,  441,   74,  434, 1501,
 /*    40 */   469, 1774,  107, 1778, 1289,  106,  105,  104,  103,  102,
 /*    50 */   101,  100,   99,   98, 1774, 1023, 1334, 1808,  150, 1602,
 /*    60 */  1934,   14, 1566, 1009, 1010,  552, 1770, 1776, 1269,  450,
 /*    70 */  1760,  125,  576,  165,   39,   37, 1402, 1931,  570, 1770,
 /*    80 */  1776,  328,  339, 1528, 1263,  550,  161, 1876, 1877,    1,
 /*    90 */  1881,  570, 1658,   63, 1288, 1339, 1822, 1261, 1375,  327,
 /*   100 */    95, 1791,  579, 1793, 1794,  575,  496,  570, 1656,  344,
 /*   110 */  1868,  662, 1651, 1653,  330, 1864,  160,  513, 1334,  494,
 /*   120 */   146,  492,  551,   14,  325, 1341, 1342, 1704,  164, 1609,
 /*   130 */  1269,   40,   38,   36,   35,   34, 1894,   33,   32,  479,
 /*   140 */   478,   40,   38,   36,   35,   34,  639,  638,  637,  636,
 /*   150 */   349,    2,  635,  634,  128,  629,  628,  627,  626,  625,
 /*   160 */   624,  623,  139,  619,  618,  617,  348,  347,  614,  613,
 /*   170 */  1264,  107, 1262,  662,  106,  105,  104,  103,  102,  101,
 /*   180 */   100,   99,   98,  174, 1808,   49, 1080, 1341, 1342,  224,
 /*   190 */   225,   42,  541, 1267, 1268,  218, 1316, 1317, 1319, 1320,
 /*   200 */  1321, 1322, 1323, 1324,  572,  568, 1332, 1333, 1335, 1336,
 /*   210 */  1337, 1338, 1340, 1343, 1466,   71,   33,   32,   70, 1082,
 /*   220 */    40,   38,   36,   35,   34, 1289,  525,  168,   63,  540,
 /*   230 */    78,  168, 1264,  373, 1262, 1263,   84,  170,  116,  115,
 /*   240 */   114,  113,  112,  111,  110,  109,  108,  305, 1261, 1583,
 /*   250 */   515,  548,  375,  371, 1606, 1267, 1268, 1599, 1316, 1317,
 /*   260 */  1319, 1320, 1321, 1322, 1323, 1324,  572,  568, 1332, 1333,
 /*   270 */  1335, 1336, 1337, 1338, 1340, 1343,   39,   37,  542,  127,
 /*   280 */    64, 1269,  551, 1290,  339, 1363, 1263, 1288,   33,   32,
 /*   290 */   384, 1459,   40,   38,   36,   35,   34, 1339, 1433, 1261,
 /*   300 */  1118,  601,  600,  599, 1122,  598, 1124, 1125,  597, 1127,
 /*   310 */   594,  487, 1133,  591, 1135, 1136,  588,  585,  125, 1022,
 /*   320 */  1334, 1021,  610,  168,  662,   14,  497,  303, 1287,  168,
 /*   330 */  1160, 1161, 1269,  162, 1876, 1877,  211, 1881,   39,   37,
 /*   340 */   210,  137,  136,  607,  606,  605,  339,   27, 1263, 1023,
 /*   350 */   610,   43,  432,    2,  490,  436,   63, 1368,  484, 1339,
 /*   360 */  1658, 1261, 1707,  209, 1934,   63,  168,  312, 1531,  137,
 /*   370 */   136,  607,  606,  605,  612,  662, 1656, 1933, 1458,   61,
 /*   380 */  1778, 1931, 1334, 1264,  148, 1262, 1478,   74,  159, 1341,
 /*   390 */  1342, 1774,   76,  305, 1269,   58,  515, 1934,   57, 1269,
 /*   400 */   122, 1645, 1489,   39,   37, 1344, 1267, 1268, 1934, 1601,
 /*   410 */   166,  339, 1790, 1263, 1931,    8, 1770, 1776,  334,  604,
 /*   420 */   253, 1932,  223,  537, 1339, 1931, 1261,  326,  570, 1934,
 /*   430 */   633,  631,  482,  481, 1264,  146, 1262,  662,  440,  123,
 /*   440 */  1808,  436,  166, 1760, 1608, 1291, 1931, 1334,  574,  477,
 /*   450 */   480, 1341, 1342, 1760, 1488,  576, 1487, 1267, 1268, 1269,
 /*   460 */  1316, 1317, 1319, 1320, 1321, 1322, 1323, 1324,  572,  568,
 /*   470 */  1332, 1333, 1335, 1336, 1337, 1338, 1340, 1343,  621, 1822,
 /*   480 */     9, 1243, 1244,  294, 1791,  579, 1793, 1794,  575,  573,
 /*   490 */   570,  567, 1840,  548,  168, 1760, 1264, 1760, 1262, 1658,
 /*   500 */   543,  538,  662,  168, 1584,   33,   32, 1582,  438,   40,
 /*   510 */    38,   36,   35,   34, 1286, 1657, 1341, 1342, 1595, 1267,
 /*   520 */  1268,  127, 1316, 1317, 1319, 1320, 1321, 1322, 1323, 1324,
 /*   530 */   572,  568, 1332, 1333, 1335, 1336, 1337, 1338, 1340, 1343,
 /*   540 */    22,   33,   32, 1591,   26,   40,   38,   36,   35,   34,
 /*   550 */    33,   32,  475,  168,   40,   38,   36,   35,   34,   28,
 /*   560 */   125, 1264, 1406, 1262,  450,   33,   32,  612, 1288,   40,
 /*   570 */    38,   36,   35,   34,  474,  163, 1876, 1877, 1703, 1881,
 /*   580 */   300, 1790,  233, 1593, 1267, 1268,  316, 1316, 1317, 1319,
 /*   590 */  1320, 1321, 1322, 1323, 1324,  572,  568, 1332, 1333, 1335,
 /*   600 */  1336, 1337, 1338, 1340, 1343,   39,   37, 1581,  505, 1808,
 /*   610 */   342,  419, 1507,  339,  525, 1263, 1589,  552,  146,  525,
 /*   620 */   555, 1464, 1760, 1413,  576,  382, 1339, 1608, 1261,   63,
 /*   630 */   383,   33,   32,  214, 1883,   40,   38,   36,   35,   34,
 /*   640 */  1423,  317, 1606,  315,  314, 1349,  473, 1606, 1822, 1334,
 /*   650 */   475, 1288,   95, 1791,  579, 1793, 1794,  575, 1880,  570,
 /*   660 */   657, 1269, 1868,  178,  177, 1486,  330, 1864,  160,  571,
 /*   670 */    33,   32,  474,  345,   40,   38,   36,   35,   34,  665,
 /*   680 */   354,  146,    9,  534, 1421, 1422, 1424, 1425, 1895,  603,
 /*   690 */  1608,   33,   32,  268,  525,   40,   38,   36,   35,   34,
 /*   700 */    36,   35,   34, 1479,  662,  389, 1760,  157,  610,  377,
 /*   710 */  1658,  376,  655,  651,  647,  643,  266,  343, 1341, 1342,
 /*   720 */   256, 1934, 1606,  307,  535, 1779, 1656,  137,  136,  607,
 /*   730 */   606,  605,   39,   37,  165, 1883, 1774,  302, 1931, 1286,
 /*   740 */   339, 1485, 1263,  525,  307, 1318,  412,  608,   92,  424,
 /*   750 */  1649,  231, 1301, 1339,  404, 1261,    7,  482,  481, 1879,
 /*   760 */  1361, 1770, 1776, 1264,  123, 1262,  397,  168,  425,  512,
 /*   770 */   399, 1606,  352,  570,  477,  480, 1334, 1484, 1399,  351,
 /*   780 */   145, 1361, 1760, 1483,  522, 1288, 1267, 1268, 1269, 1316,
 /*   790 */  1317, 1319, 1320, 1321, 1322, 1323, 1324,  572,  568, 1332,
 /*   800 */  1333, 1335, 1336, 1337, 1338, 1340, 1343,  390,   91,    2,
 /*   810 */  1934,  525, 1567, 1934, 1362,  513,  220, 1883, 1760,  386,
 /*   820 */  1934,  124,  405,  165, 1760, 1705,  165, 1931, 1318, 1598,
 /*   830 */  1931,  662, 1482,  165, 1235, 1362,  213, 1931, 1702, 1606,
 /*   840 */   300, 1878,  622,  499, 1578, 1341, 1342,  423, 1481,  468,
 /*   850 */   418,  417,  416,  415,  414,  411,  410,  409,  408,  407,
 /*   860 */   403,  402,  401,  400,  394,  393,  392,  391, 1480,  388,
 /*   870 */   387, 1477,  609, 1760, 1476, 1649,   29,  337, 1356, 1357,
 /*   880 */  1358, 1359, 1360, 1364, 1365, 1366, 1367, 1009, 1010, 1760,
 /*   890 */  1264,  273, 1262, 1475, 1636,   44,    4,   29,  337, 1356,
 /*   900 */  1357, 1358, 1359, 1360, 1364, 1365, 1366, 1367, 1474, 1760,
 /*   910 */  1790, 1473, 1760, 1267, 1268, 1760, 1316, 1317, 1319, 1320,
 /*   920 */  1321, 1322, 1323, 1324,  572,  568, 1332, 1333, 1335, 1336,
 /*   930 */  1337, 1338, 1340, 1343, 1760,  147, 1697, 1790, 1808, 1697,
 /*   940 */   279, 1888, 1395, 1395,  217,  135,  577,  173, 1472, 1760,
 /*   950 */   176, 1760, 1760,  576,  277,   60, 1471, 1470,   59, 1469,
 /*   960 */    53,  509, 1318,   33,   32, 1808,  553,   40,   38,   36,
 /*   970 */    35,   34, 1747,  577,  181,  429,  427, 1822, 1760,   77,
 /*   980 */   576,   94, 1791,  579, 1793, 1794,  575,  202,  570, 1760,
 /*   990 */   200, 1868,   54,  553,  245,  306, 1864, 1760, 1760, 1518,
 /*  1000 */  1760,  498, 1398,  557, 1822,  525,   63, 1934,   94, 1791,
 /*  1010 */   579, 1793, 1794,  575,  204,  570,  448,  203, 1868,  361,
 /*  1020 */   167,  483,  306, 1864, 1931,  206, 1272,  208,  205,  525,
 /*  1030 */   207,  336,  335, 1606, 1934,  525, 1513,  525,  525, 1271,
 /*  1040 */   449, 1277, 1934,  560,   93, 1301, 1603,  165, 1735,  506,
 /*  1050 */  1790, 1931, 1339,  350, 1270,  165, 1809, 1606,  485, 1931,
 /*  1060 */   525,  525,  525, 1606,  566, 1606, 1606,   41, 1049,  222,
 /*  1070 */  1898,  510,  228,  521,  525, 1334, 1511, 1502, 1808,   68,
 /*  1080 */    67,  381,  131,  525,  172,  523,  577, 1269, 1606, 1606,
 /*  1090 */  1606, 1760,  134,  576,  524,  135,   51, 1646,  488,  525,
 /*  1100 */   301, 1050, 1606,  369,  525,  367,  363,  359,  356,  353,
 /*  1110 */   262, 1606, 1790,  237, 1212,  346,  226, 1822,   11,   10,
 /*  1120 */    51,   95, 1791,  579, 1793, 1794,  575, 1606,  570,  518,
 /*  1130 */   565, 1868, 1606, 1461, 1462,  330, 1864, 1947, 1781,  230,
 /*  1140 */  1808,  549, 1111, 1420,  168,    5, 1902,   41,  577,   90,
 /*  1150 */   615,  616,  250, 1760,   41,  576,  583,  134,  255,   87,
 /*  1160 */   240,  313,  135, 1275, 1790,    3,  258, 1369,  119,  260,
 /*  1170 */   134,  355, 1068, 1066, 1228,  360, 1274,  269,  175, 1822,
 /*  1180 */   385, 1783, 1286,   95, 1791,  579, 1793, 1794,  575, 1278,
 /*  1190 */   570, 1273, 1808, 1868, 1325,  406, 1353,  330, 1864, 1947,
 /*  1200 */   577,  272,  421, 1139, 1143, 1760,  558,  576, 1925, 1150,
 /*  1210 */  1699,  413, 1281, 1283,  420, 1148, 1790,  138,  422,  426,
 /*  1220 */   428,  430, 1292,  431,  568, 1332, 1333, 1335, 1336, 1337,
 /*  1230 */  1338, 1822,  439, 1294,  184,   95, 1791,  579, 1793, 1794,
 /*  1240 */   575,  442,  570, 1790, 1808, 1868,  443,  186,  561,  330,
 /*  1250 */  1864, 1947,  577, 1293,  444, 1295,  189, 1760,  445,  576,
 /*  1260 */  1887,  447,  191,  451,   72,   73,  195,  470,  472, 1596,
 /*  1270 */   199, 1808,  553, 1592,  201,  140,  141, 1594,  304,  577,
 /*  1280 */   118,  270,  500, 1822, 1760, 1590,  576,  286, 1791,  579,
 /*  1290 */  1793, 1794,  575,  212,  570, 1790,  507,  142,  143,  553,
 /*  1300 */   501,  504, 1740,  533,  215,  511,  519,  132,  219,  271,
 /*  1310 */  1822, 1790,  514, 1934,  286, 1791,  579, 1793, 1794,  575,
 /*  1320 */   536,  570,  322, 1808,  133,   81,  167,  520, 1739,   83,
 /*  1330 */  1931,  577, 1709,  516, 1291,    6, 1760, 1607,  576, 1808,
 /*  1340 */  1934,  324, 1890,  529, 1899,  545,  531,  577,  532,  530,
 /*  1350 */   528,  527, 1760,  165,  576,  235, 1395, 1931,  329,  239,
 /*  1360 */   126, 1290, 1822,  539,   48, 1909,   96, 1791,  579, 1793,
 /*  1370 */  1794,  575,  331,  570,  559,   85, 1868,  246, 1822,  562,
 /*  1380 */  1867, 1864,   96, 1791,  579, 1793, 1794,  575,  249,  570,
 /*  1390 */  1884, 1790, 1868, 1908,  244, 1930,  564, 1864, 1950, 1650,
 /*  1400 */   658, 1790,  581,  274, 1579,  659,  154,  247,  661, 1849,
 /*  1410 */   265,  153,   52,  278,  248,  287,  297, 1754,  276, 1808,
 /*  1420 */  1753,  296,   65, 1752, 1751,   66, 1748,  577,  254, 1808,
 /*  1430 */   357,  556, 1760,  358,  576, 1255, 1256,  577,  257,  171,
 /*  1440 */   563,  362, 1760,  259,  576, 1746,  364,  365,  366, 1745,
 /*  1450 */  1790,  368, 1744,  370, 1743,  372, 1742,  374, 1822, 1231,
 /*  1460 */  1230, 1720,  149, 1791,  579, 1793, 1794,  575, 1822,  570,
 /*  1470 */  1719,  379,   96, 1791,  579, 1793, 1794,  575, 1808,  570,
 /*  1480 */   380, 1718, 1868,  323, 1717, 1200,  577, 1865, 1692,  129,
 /*  1490 */  1691, 1760, 1690,  576, 1689,   69, 1688, 1687, 1686, 1790,
 /*  1500 */   395,  396, 1683,  398, 1682, 1681,  554, 1948, 1685, 1684,
 /*  1510 */  1680, 1790, 1679, 1678, 1677, 1676, 1675, 1822, 1674, 1673,
 /*  1520 */  1672,  295, 1791,  579, 1793, 1794,  575, 1808,  570, 1671,
 /*  1530 */  1670, 1669,  526,  130, 1668,  577, 1667, 1666, 1665, 1808,
 /*  1540 */  1760, 1664,  576, 1663, 1202, 1662, 1661,  577, 1660, 1659,
 /*  1550 */  1533,  179, 1760, 1532,  576,  180, 1530, 1498, 1012,  182,
 /*  1560 */  1790, 1011,  120, 1497,  158,  183, 1822,  121, 1733, 1727,
 /*  1570 */   295, 1791,  579, 1793, 1794,  575, 1790,  570, 1822,  435,
 /*  1580 */  1716,  437,  290, 1791,  579, 1793, 1794,  575, 1808,  570,
 /*  1590 */   188, 1715,  190, 1701, 1585, 1529,  577, 1527,  454,  452,
 /*  1600 */  1525, 1760, 1042,  576, 1808,  453,  456,  457, 1523,  458,
 /*  1610 */   460,  462,  574,  461, 1521,  466,  464, 1760, 1510,  576,
 /*  1620 */   544,  465, 1509, 1494, 1587,   50, 1153, 1822,  198, 1790,
 /*  1630 */   630,  149, 1791,  579, 1793, 1794,  575, 1154,  570, 1586,
 /*  1640 */  1079, 1790,  632, 1822, 1076, 1075, 1519,  294, 1791,  579,
 /*  1650 */  1793, 1794,  575, 1074,  570, 1514, 1841, 1808,  318,  319,
 /*  1660 */   486, 1512,  338,  320,  489,  577,  197, 1493, 1492, 1808,
 /*  1670 */  1760, 1491,  576,  491,  340,  493, 1949,  577,  495,   97,
 /*  1680 */   152, 1732, 1760,   56,  576,  467,  463,  459,  455,  196,
 /*  1690 */  1790,  502, 1237, 1726, 1714, 1712, 1822,  144,  508,  503,
 /*  1700 */   295, 1791,  579, 1793, 1794,  575,  216,  570, 1822, 1713,
 /*  1710 */  1711,  321,  295, 1791,  579, 1793, 1794,  575, 1808,  570,
 /*  1720 */  1710,   75, 1708,   15,  194,  221,  577, 1700,  517,   80,
 /*  1730 */   232, 1760,  227,  576,   79,  229,   82, 1247,   16, 1790,
 /*  1740 */    41,   23,  234,   87, 1435,   47,  242,  243,  236, 1447,
 /*  1750 */  1417,  238, 1781, 1419,  151,  241,   25, 1822,  252,   24,
 /*  1760 */  1790,  280, 1791,  579, 1793, 1794,  575, 1808,  570, 1412,
 /*  1770 */  1392,   86,   46, 1391, 1780,  577,  155, 1452,   18, 1441,
 /*  1780 */  1760, 1446,  576,  332, 1451, 1450,  193,  187, 1808,  192,
 /*  1790 */    45,  333,   10,  446, 1279,   19,  577, 1825,   17, 1354,
 /*  1800 */   569, 1760, 1309,  576,  156, 1329, 1822, 1327,   31,  185,
 /*  1810 */   281, 1791,  579, 1793, 1794,  575, 1326,  570,  580,   13,
 /*  1820 */    12, 1790,   20,  169, 1140,   21,  582, 1822,  341, 1137,
 /*  1830 */   584,  282, 1791,  579, 1793, 1794,  575, 1790,  570,  586,
 /*  1840 */   587,  589,  590,  578, 1134, 1128,  592, 1126,  593, 1808,
 /*  1850 */   595,  596, 1117,  548,   88, 1132, 1131,  577, 1130,   89,
 /*  1860 */  1129,  602, 1760, 1149,  576, 1808,  263,   62, 1145, 1040,
 /*  1870 */   611, 1071, 1070,  577, 1069, 1067, 1065, 1064, 1760, 1063,
 /*  1880 */   576,  127, 1086,  620, 1061, 1060,  264, 1059, 1822, 1058,
 /*  1890 */  1790, 1057,  289, 1791,  579, 1793, 1794,  575, 1056,  570,
 /*  1900 */   548,  553, 1790, 1055, 1822, 1081, 1083, 1052,  291, 1791,
 /*  1910 */   579, 1793, 1794,  575, 1051,  570, 1048, 1047, 1808, 1046,
 /*  1920 */   125, 1045, 1526,  640,  641, 1524,  577,  644,  127,  642,
 /*  1930 */  1808, 1760,  645,  576,  646,  251, 1876,  547,  577,  546,
 /*  1940 */  1522,  648, 1934, 1760,  650,  576,  649, 1520,  553,  652,
 /*  1950 */   653, 1790,  654, 1508,  656,  167, 1002, 1822, 1490, 1931,
 /*  1960 */   267,  283, 1791,  579, 1793, 1794,  575,  125,  570, 1822,
 /*  1970 */   660,  664, 1265,  292, 1791,  579, 1793, 1794,  575, 1808,
 /*  1980 */   570,  275,  251, 1876,  547,  663,  546,  577, 1465, 1934,
 /*  1990 */  1465, 1465, 1760, 1465,  576, 1465, 1465, 1465, 1465, 1465,
 /*  2000 */  1790, 1465,  165, 1465, 1465, 1465, 1931, 1465, 1465, 1465,
 /*  2010 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1822, 1465,
 /*  2020 */  1465, 1790,  284, 1791,  579, 1793, 1794,  575, 1808,  570,
 /*  2030 */  1465, 1465, 1465, 1465, 1465, 1465,  577, 1465, 1465, 1465,
 /*  2040 */  1465, 1760, 1465,  576, 1465, 1465, 1465, 1465, 1465, 1808,
 /*  2050 */  1465, 1465, 1465, 1465, 1465, 1465, 1465,  577, 1465, 1465,
 /*  2060 */  1465, 1465, 1760, 1465,  576, 1465, 1465, 1822, 1465, 1465,
 /*  2070 */  1790,  293, 1791,  579, 1793, 1794,  575, 1465,  570, 1465,
 /*  2080 */  1465, 1465, 1790, 1465, 1465, 1465, 1465, 1465, 1822, 1465,
 /*  2090 */  1465, 1465,  285, 1791,  579, 1793, 1794,  575, 1808,  570,
 /*  2100 */  1465, 1465, 1465, 1465, 1465, 1465,  577, 1465, 1465, 1465,
 /*  2110 */  1808, 1760, 1465,  576, 1465, 1465, 1465, 1465,  577, 1465,
 /*  2120 */  1465, 1465, 1465, 1760, 1465,  576, 1465, 1465, 1465, 1465,
 /*  2130 */  1465, 1465, 1465, 1465, 1790, 1465, 1465, 1822, 1465, 1465,
 /*  2140 */  1465,  298, 1791,  579, 1793, 1794,  575, 1465,  570, 1822,
 /*  2150 */  1465, 1790, 1465,  299, 1791,  579, 1793, 1794,  575, 1465,
 /*  2160 */   570, 1465, 1808, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*  2170 */   577, 1465, 1465, 1465, 1465, 1760, 1465,  576, 1465, 1808,
 /*  2180 */  1465, 1465, 1465, 1465, 1465, 1465, 1465,  577, 1465, 1465,
 /*  2190 */  1465, 1465, 1760, 1465,  576, 1465, 1465, 1465, 1465, 1465,
 /*  2200 */  1465, 1822, 1465, 1465, 1790, 1802, 1791,  579, 1793, 1794,
 /*  2210 */   575, 1465,  570, 1465, 1465, 1465, 1465, 1465, 1822, 1465,
 /*  2220 */  1465, 1465, 1801, 1791,  579, 1793, 1794,  575, 1465,  570,
 /*  2230 */  1465, 1465, 1808, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*  2240 */   577, 1465, 1465, 1465, 1465, 1760, 1465,  576, 1465, 1465,
 /*  2250 */  1465, 1465, 1465, 1790, 1465, 1465, 1465, 1465, 1465, 1465,
 /*  2260 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*  2270 */  1465, 1822, 1465, 1465, 1465, 1800, 1791,  579, 1793, 1794,
 /*  2280 */   575, 1808,  570, 1465, 1465, 1465, 1465, 1465, 1465,  577,
 /*  2290 */  1465, 1465, 1465, 1465, 1760, 1465,  576, 1465, 1465, 1465,
 /*  2300 */  1465, 1465, 1790, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*  2310 */  1465, 1465, 1465, 1465, 1465, 1465, 1465, 1465, 1790, 1465,
 /*  2320 */  1822, 1465, 1465, 1465,  310, 1791,  579, 1793, 1794,  575,
 /*  2330 */  1808,  570, 1465, 1465, 1465, 1465, 1465, 1465,  577, 1465,
 /*  2340 */  1465, 1465, 1465, 1760, 1465,  576, 1808, 1465, 1465, 1465,
 /*  2350 */  1465, 1465, 1465, 1465,  577, 1465, 1465, 1465, 1465, 1760,
 /*  2360 */  1465,  576, 1465, 1465, 1465, 1465, 1465, 1790, 1465, 1822,
 /*  2370 */  1465, 1465, 1465,  309, 1791,  579, 1793, 1794,  575, 1790,
 /*  2380 */   570, 1465, 1465, 1465, 1465, 1822, 1465, 1465, 1465,  311,
 /*  2390 */  1791,  579, 1793, 1794,  575, 1808,  570, 1465, 1465, 1465,
 /*  2400 */  1465, 1465, 1465,  577, 1465, 1465, 1465, 1808, 1760, 1465,
 /*  2410 */   576, 1465, 1465, 1465, 1465,  577, 1465, 1465, 1465, 1465,
 /*  2420 */  1760, 1465,  576, 1465, 1465, 1465, 1465, 1465, 1465, 1465,
 /*  2430 */  1465, 1465, 1465, 1465, 1822, 1465, 1465, 1465,  308, 1791,
 /*  2440 */   579, 1793, 1794,  575, 1465,  570, 1822, 1465, 1465, 1465,
 /*  2450 */   288, 1791,  579, 1793, 1794,  575, 1465,  570,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   268,  342,  343,  268,  268,  264,  268,  266,  267,    1,
 /*    10 */     2,  279,   12,   13,  279,  302,  303,  279,  286,  316,
 /*    20 */    20,    0,   22,    4,  286,   20,   20,   22,  296,  260,
 /*    30 */   290,  296,  296,   33,  296,   35,  264,  272,  266,  267,
 /*    40 */    35,  301,   21,  290,   20,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  301,   50,   56,  288,  273,  294,
 /*    60 */   357,   61,  277,   44,   45,  296,  326,  327,   68,   60,
 /*    70 */   301,  335,  303,  370,   12,   13,   14,  374,  338,  326,
 /*    80 */   327,  328,   20,    0,   22,  349,  350,  351,  352,   89,
 /*    90 */   354,  338,  288,   89,   20,   33,  327,   35,   90,  295,
 /*   100 */   331,  332,  333,  334,  335,  336,   21,  338,  304,  299,
 /*   110 */   341,  111,  302,  303,  345,  346,  347,  303,   56,   34,
 /*   120 */   288,   36,   20,   61,  310,  125,  126,  313,  359,  297,
 /*   130 */    68,   12,   13,   14,   15,   16,  367,    8,    9,  274,
 /*   140 */   275,   12,   13,   14,   15,   16,   63,   64,   65,   66,
 /*   150 */    67,   89,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   160 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   170 */   170,   21,  172,  111,   24,   25,   26,   27,   28,   29,
 /*   180 */    30,   31,   32,   56,  288,   89,   35,  125,  126,  120,
 /*   190 */   121,   89,  296,  193,  194,   56,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,    0,   88,    8,    9,   91,   68,
 /*   220 */    12,   13,   14,   15,   16,   20,  268,  227,   89,  333,
 /*   230 */    91,  227,  170,  165,  172,   22,  270,  279,   24,   25,
 /*   240 */    26,   27,   28,   29,   30,   31,   32,  178,   35,    0,
 /*   250 */   181,  268,  184,  185,  296,  193,  194,  291,  196,  197,
 /*   260 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   270 */   208,  209,  210,  211,  212,  213,   12,   13,   20,  296,
 /*   280 */     4,   68,   20,   20,   20,  152,   22,   20,    8,    9,
 /*   290 */   268,  162,   12,   13,   14,   15,   16,   33,   90,   35,
 /*   300 */   102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
 /*   310 */   112,    4,  114,  115,  116,  117,  118,  119,  335,   20,
 /*   320 */    56,   22,  101,  227,  111,   61,   19,  305,   20,  227,
 /*   330 */   125,  126,   68,  350,  351,  352,  121,  354,   12,   13,
 /*   340 */    33,  120,  121,  122,  123,  124,   20,  214,   22,   50,
 /*   350 */   101,   89,  265,   89,   47,  268,   89,  224,   51,   33,
 /*   360 */   288,   35,    0,   56,  357,   89,  227,  295,    0,  120,
 /*   370 */   121,  122,  123,  124,   60,  111,  304,  370,  249,    3,
 /*   380 */   290,  374,   56,  170,  259,  172,  261,  272,  287,  125,
 /*   390 */   126,  301,  177,  178,   68,   88,  181,  357,   91,   68,
 /*   400 */   285,  300,  260,   12,   13,   14,  193,  194,  357,  294,
 /*   410 */   370,   20,  260,   22,  374,   89,  326,  327,  328,  100,
 /*   420 */   157,  370,  120,  155,   33,  374,   35,  280,  338,  357,
 /*   430 */   274,  275,   64,   65,  170,  288,  172,  111,  265,   71,
 /*   440 */   288,  268,  370,  301,  297,   20,  374,   56,  296,   81,
 /*   450 */    82,  125,  126,  301,  260,  303,  260,  193,  194,   68,
 /*   460 */   196,  197,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,   68,  327,
 /*   480 */    89,  179,  180,  331,  332,  333,  334,  335,  336,  337,
 /*   490 */   338,  339,  340,  268,  227,  301,  170,  301,  172,  288,
 /*   500 */   232,  233,  111,  227,    0,    8,    9,    0,   14,   12,
 /*   510 */    13,   14,   15,   16,   20,  304,  125,  126,  289,  193,
 /*   520 */   194,  296,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   530 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   540 */    43,    8,    9,  289,    2,   12,   13,   14,   15,   16,
 /*   550 */     8,    9,  101,  227,   12,   13,   14,   15,   16,    2,
 /*   560 */   335,  170,   14,  172,   60,    8,    9,   60,   20,   12,
 /*   570 */    13,   14,   15,   16,  123,  350,  351,  352,  312,  354,
 /*   580 */   314,  260,  157,  289,  193,  194,   37,  196,  197,  198,
 /*   590 */   199,  200,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   600 */   209,  210,  211,  212,  213,   12,   13,    0,  320,  288,
 /*   610 */   280,   77,    0,   20,  268,   22,  289,  296,  288,  268,
 /*   620 */   244,  257,  301,   90,  303,  279,   33,  297,   35,   89,
 /*   630 */   279,    8,    9,  289,  329,   12,   13,   14,   15,   16,
 /*   640 */   193,   92,  296,   94,   95,   14,   97,  296,  327,   56,
 /*   650 */   101,   20,  331,  332,  333,  334,  335,  336,  353,  338,
 /*   660 */    48,   68,  341,  129,  130,  260,  345,  346,  347,  289,
 /*   670 */     8,    9,  123,  280,   12,   13,   14,   15,   16,   19,
 /*   680 */   316,  288,   89,  236,  237,  238,  239,  240,  367,  289,
 /*   690 */   297,    8,    9,   33,  268,   12,   13,   14,   15,   16,
 /*   700 */    14,   15,   16,  261,  111,  279,  301,   47,  101,  169,
 /*   710 */   288,  171,   52,   53,   54,   55,   56,  295,  125,  126,
 /*   720 */   377,  357,  296,   61,  368,  290,  304,  120,  121,  122,
 /*   730 */   123,  124,   12,   13,  370,  329,  301,   18,  374,   20,
 /*   740 */    20,  260,   22,  268,   61,  197,   27,  298,   88,   30,
 /*   750 */   301,   91,   90,   33,  279,   35,   39,   64,   65,  353,
 /*   760 */    98,  326,  327,  170,   71,  172,   47,  227,   49,  316,
 /*   770 */    51,  296,  316,  338,   81,   82,   56,  260,    4,  316,
 /*   780 */   157,   98,  301,  260,  124,   20,  193,  194,   68,  196,
 /*   790 */   197,  198,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,   88,  270,   89,
 /*   810 */   357,  268,  277,  357,  152,  303,  156,  329,  301,  100,
 /*   820 */   357,  283,  279,  370,  301,  313,  370,  374,  197,  291,
 /*   830 */   374,  111,  260,  370,  174,  152,  176,  374,  312,  296,
 /*   840 */   314,  353,  276,  323,  278,  125,  126,  128,  260,  269,
 /*   850 */   131,  132,  133,  134,  135,  136,  137,  138,  139,  140,
 /*   860 */   141,  142,  143,  144,  145,  146,  147,  148,  260,  150,
 /*   870 */   151,  260,  298,  301,  260,  301,  214,  215,  216,  217,
 /*   880 */   218,  219,  220,  221,  222,  223,  224,   44,   45,  301,
 /*   890 */   170,  281,  172,  260,  284,   42,   43,  214,  215,  216,
 /*   900 */   217,  218,  219,  220,  221,  222,  223,  224,  260,  301,
 /*   910 */   260,  260,  301,  193,  194,  301,  196,  197,  198,  199,
 /*   920 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   930 */   210,  211,  212,  213,  301,   18,  296,  260,  288,  296,
 /*   940 */    23,  225,  226,  226,   56,   43,  296,  307,  260,  301,
 /*   950 */   307,  301,  301,  303,   37,   38,  260,  260,   41,  260,
 /*   960 */   157,  158,  197,    8,    9,  288,  316,   12,   13,   14,
 /*   970 */    15,   16,    0,  296,   57,   58,   59,  327,  301,   91,
 /*   980 */   303,  331,  332,  333,  334,  335,  336,   93,  338,  301,
 /*   990 */    96,  341,   90,  316,  364,  345,  346,  301,  301,    0,
 /*  1000 */   301,  316,  228,   43,  327,  268,   89,  357,  331,  332,
 /*  1010 */   333,  334,  335,  336,   93,  338,  279,   96,  341,   47,
 /*  1020 */   370,   22,  345,  346,  374,   93,   35,   93,   96,  268,
 /*  1030 */    96,   12,   13,  296,  357,  268,    0,  268,  268,   35,
 /*  1040 */   279,   22,  357,   43,  127,   90,  279,  370,  279,  279,
 /*  1050 */   260,  374,   33,  269,   35,  370,  288,  296,   22,  374,
 /*  1060 */   268,  268,  268,  296,   61,  296,  296,   43,   35,   43,
 /*  1070 */   330,  279,  279,  279,  268,   56,    0,  267,  288,  162,
 /*  1080 */   163,  164,   43,  268,  167,  279,  296,   68,  296,  296,
 /*  1090 */   296,  301,   43,  303,  279,   43,   43,  300,   22,  268,
 /*  1100 */   183,   68,  296,  186,  268,  188,  189,  190,  191,  192,
 /*  1110 */   279,  296,  260,   43,   90,  279,   90,  327,    1,    2,
 /*  1120 */    43,  331,  332,  333,  334,  335,  336,  296,  338,   90,
 /*  1130 */   111,  341,  296,  125,  126,  345,  346,  347,   46,   90,
 /*  1140 */   288,  355,   90,   90,  227,  229,  356,   43,  296,   89,
 /*  1150 */    13,   13,  348,  301,   43,  303,   43,   43,  371,   99,
 /*  1160 */    90,  324,   43,  172,  260,  358,  371,   90,   43,  371,
 /*  1170 */    43,  325,   35,   35,  168,   47,  172,  318,   42,  327,
 /*  1180 */   308,   89,   20,  331,  332,  333,  334,  335,  336,  170,
 /*  1190 */   338,  172,  288,  341,   90,  268,  193,  345,  346,  347,
 /*  1200 */   296,   90,  152,   90,   90,  301,  246,  303,  356,   90,
 /*  1210 */   268,  308,  193,  194,  306,   90,  260,   90,  306,  268,
 /*  1220 */   268,  268,   20,  262,  205,  206,  207,  208,  209,  210,
 /*  1230 */   211,  327,  262,   20,  272,  331,  332,  333,  334,  335,
 /*  1240 */   336,  322,  338,  260,  288,  341,  303,  272,  248,  345,
 /*  1250 */   346,  347,  296,   20,  315,   20,  272,  301,  317,  303,
 /*  1260 */   356,  315,  272,  268,  272,  272,  272,  262,  288,  288,
 /*  1270 */   288,  288,  316,  288,  288,  288,  288,  288,  262,  296,
 /*  1280 */   268,  322,  175,  327,  301,  288,  303,  331,  332,  333,
 /*  1290 */   334,  335,  336,  270,  338,  260,  268,  288,  288,  316,
 /*  1300 */   321,  303,  301,  234,  270,  268,  154,  311,  270,  284,
 /*  1310 */   327,  260,  301,  357,  331,  332,  333,  334,  335,  336,
 /*  1320 */   235,  338,  315,  288,  311,  270,  370,  309,  301,  270,
 /*  1330 */   374,  296,  301,  301,   20,  241,  301,  296,  303,  288,
 /*  1340 */   357,  301,  366,  301,  330,  161,  301,  296,  301,  243,
 /*  1350 */   242,  230,  301,  370,  303,  311,  226,  374,  301,  311,
 /*  1360 */   296,   20,  327,  301,   89,  363,  331,  332,  333,  334,
 /*  1370 */   335,  336,  250,  338,  245,   89,  341,  362,  327,  247,
 /*  1380 */   345,  346,  331,  332,  333,  334,  335,  336,  325,  338,
 /*  1390 */   329,  260,  341,  363,  365,  373,  345,  346,  378,  301,
 /*  1400 */    36,  260,  292,  268,  278,  263,  363,  361,  262,  344,
 /*  1410 */   270,  314,  319,  258,  360,  282,  282,    0,  271,  288,
 /*  1420 */     0,  282,  177,    0,    0,   42,    0,  296,  372,  288,
 /*  1430 */    35,  373,  301,  187,  303,   35,   35,  296,  372,   35,
 /*  1440 */   373,  187,  301,  372,  303,    0,   35,   35,  187,    0,
 /*  1450 */   260,  187,    0,   35,    0,   22,    0,   35,  327,  172,
 /*  1460 */   170,    0,  331,  332,  333,  334,  335,  336,  327,  338,
 /*  1470 */     0,  166,  331,  332,  333,  334,  335,  336,  288,  338,
 /*  1480 */   165,    0,  341,  293,    0,   46,  296,  346,    0,   42,
 /*  1490 */     0,  301,    0,  303,    0,  149,    0,    0,    0,  260,
 /*  1500 */   144,   35,    0,  144,    0,    0,  375,  376,    0,    0,
 /*  1510 */     0,  260,    0,    0,    0,    0,    0,  327,    0,    0,
 /*  1520 */     0,  331,  332,  333,  334,  335,  336,  288,  338,    0,
 /*  1530 */     0,    0,  293,   42,    0,  296,    0,    0,    0,  288,
 /*  1540 */   301,    0,  303,    0,   22,    0,    0,  296,    0,    0,
 /*  1550 */     0,   56,  301,    0,  303,   56,    0,    0,   14,   42,
 /*  1560 */   260,   14,   39,    0,   43,   40,  327,   39,    0,    0,
 /*  1570 */   331,  332,  333,  334,  335,  336,  260,  338,  327,   46,
 /*  1580 */     0,   46,  331,  332,  333,  334,  335,  336,  288,  338,
 /*  1590 */    39,    0,  161,    0,    0,    0,  296,    0,   39,   35,
 /*  1600 */     0,  301,   62,  303,  288,   47,   35,   47,    0,   39,
 /*  1610 */    35,   39,  296,   47,    0,   39,   35,  301,    0,  303,
 /*  1620 */   369,   47,    0,    0,    0,   98,   22,  327,   96,  260,
 /*  1630 */    43,  331,  332,  333,  334,  335,  336,   35,  338,    0,
 /*  1640 */    35,  260,   43,  327,   35,   35,    0,  331,  332,  333,
 /*  1650 */   334,  335,  336,   22,  338,    0,  340,  288,   22,   22,
 /*  1660 */    49,    0,  293,   22,   35,  296,   33,    0,    0,  288,
 /*  1670 */   301,    0,  303,   35,  293,   35,  376,  296,   22,   20,
 /*  1680 */    47,    0,  301,  157,  303,   52,   53,   54,   55,   56,
 /*  1690 */   260,   22,   35,    0,    0,    0,  327,  173,  159,  157,
 /*  1700 */   331,  332,  333,  334,  335,  336,  154,  338,  327,    0,
 /*  1710 */     0,  157,  331,  332,  333,  334,  335,  336,  288,  338,
 /*  1720 */     0,   88,    0,   89,   91,   90,  296,    0,  155,   39,
 /*  1730 */    46,  301,   89,  303,   89,  153,   89,  182,  231,  260,
 /*  1740 */    43,   89,   89,   99,   90,   43,   43,   46,   90,   35,
 /*  1750 */    90,   89,   46,   90,   89,   89,   43,  327,   46,   89,
 /*  1760 */   260,  331,  332,  333,  334,  335,  336,  288,  338,   90,
 /*  1770 */    90,   89,   43,   90,   46,  296,   46,   90,   43,   90,
 /*  1780 */   301,   35,  303,   35,   35,   35,  153,  154,  288,  156,
 /*  1790 */   225,   35,    2,  160,   22,   43,  296,   89,  231,  193,
 /*  1800 */    89,  301,   22,  303,   46,   90,  327,   90,   89,  176,
 /*  1810 */   331,  332,  333,  334,  335,  336,   90,  338,  100,  231,
 /*  1820 */    89,  260,   89,   46,   90,   89,   35,  327,   35,   90,
 /*  1830 */    89,  331,  332,  333,  334,  335,  336,  260,  338,   35,
 /*  1840 */    89,   35,   89,  195,   90,   90,   35,   90,   89,  288,
 /*  1850 */    35,   89,   22,  268,   89,  113,  113,  296,  113,   89,
 /*  1860 */   113,  101,  301,   35,  303,  288,   43,   89,   22,   62,
 /*  1870 */    61,   35,   35,  296,   35,   35,   35,   35,  301,   35,
 /*  1880 */   303,  296,   68,   87,   35,   35,   43,   22,  327,   35,
 /*  1890 */   260,   22,  331,  332,  333,  334,  335,  336,   35,  338,
 /*  1900 */   268,  316,  260,   35,  327,   35,   68,   35,  331,  332,
 /*  1910 */   333,  334,  335,  336,   35,  338,   35,   35,  288,   22,
 /*  1920 */   335,   35,    0,   35,   47,    0,  296,   35,  296,   39,
 /*  1930 */   288,  301,   47,  303,   39,  350,  351,  352,  296,  354,
 /*  1940 */     0,   35,  357,  301,   39,  303,   47,    0,  316,   35,
 /*  1950 */    47,  260,   39,    0,   35,  370,   35,  327,    0,  374,
 /*  1960 */    22,  331,  332,  333,  334,  335,  336,  335,  338,  327,
 /*  1970 */    21,   20,   22,  331,  332,  333,  334,  335,  336,  288,
 /*  1980 */   338,   22,  350,  351,  352,   21,  354,  296,  379,  357,
 /*  1990 */   379,  379,  301,  379,  303,  379,  379,  379,  379,  379,
 /*  2000 */   260,  379,  370,  379,  379,  379,  374,  379,  379,  379,
 /*  2010 */   379,  379,  379,  379,  379,  379,  379,  379,  327,  379,
 /*  2020 */   379,  260,  331,  332,  333,  334,  335,  336,  288,  338,
 /*  2030 */   379,  379,  379,  379,  379,  379,  296,  379,  379,  379,
 /*  2040 */   379,  301,  379,  303,  379,  379,  379,  379,  379,  288,
 /*  2050 */   379,  379,  379,  379,  379,  379,  379,  296,  379,  379,
 /*  2060 */   379,  379,  301,  379,  303,  379,  379,  327,  379,  379,
 /*  2070 */   260,  331,  332,  333,  334,  335,  336,  379,  338,  379,
 /*  2080 */   379,  379,  260,  379,  379,  379,  379,  379,  327,  379,
 /*  2090 */   379,  379,  331,  332,  333,  334,  335,  336,  288,  338,
 /*  2100 */   379,  379,  379,  379,  379,  379,  296,  379,  379,  379,
 /*  2110 */   288,  301,  379,  303,  379,  379,  379,  379,  296,  379,
 /*  2120 */   379,  379,  379,  301,  379,  303,  379,  379,  379,  379,
 /*  2130 */   379,  379,  379,  379,  260,  379,  379,  327,  379,  379,
 /*  2140 */   379,  331,  332,  333,  334,  335,  336,  379,  338,  327,
 /*  2150 */   379,  260,  379,  331,  332,  333,  334,  335,  336,  379,
 /*  2160 */   338,  379,  288,  379,  379,  379,  379,  379,  379,  379,
 /*  2170 */   296,  379,  379,  379,  379,  301,  379,  303,  379,  288,
 /*  2180 */   379,  379,  379,  379,  379,  379,  379,  296,  379,  379,
 /*  2190 */   379,  379,  301,  379,  303,  379,  379,  379,  379,  379,
 /*  2200 */   379,  327,  379,  379,  260,  331,  332,  333,  334,  335,
 /*  2210 */   336,  379,  338,  379,  379,  379,  379,  379,  327,  379,
 /*  2220 */   379,  379,  331,  332,  333,  334,  335,  336,  379,  338,
 /*  2230 */   379,  379,  288,  379,  379,  379,  379,  379,  379,  379,
 /*  2240 */   296,  379,  379,  379,  379,  301,  379,  303,  379,  379,
 /*  2250 */   379,  379,  379,  260,  379,  379,  379,  379,  379,  379,
 /*  2260 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2270 */   379,  327,  379,  379,  379,  331,  332,  333,  334,  335,
 /*  2280 */   336,  288,  338,  379,  379,  379,  379,  379,  379,  296,
 /*  2290 */   379,  379,  379,  379,  301,  379,  303,  379,  379,  379,
 /*  2300 */   379,  379,  260,  379,  379,  379,  379,  379,  379,  379,
 /*  2310 */   379,  379,  379,  379,  379,  379,  379,  379,  260,  379,
 /*  2320 */   327,  379,  379,  379,  331,  332,  333,  334,  335,  336,
 /*  2330 */   288,  338,  379,  379,  379,  379,  379,  379,  296,  379,
 /*  2340 */   379,  379,  379,  301,  379,  303,  288,  379,  379,  379,
 /*  2350 */   379,  379,  379,  379,  296,  379,  379,  379,  379,  301,
 /*  2360 */   379,  303,  379,  379,  379,  379,  379,  260,  379,  327,
 /*  2370 */   379,  379,  379,  331,  332,  333,  334,  335,  336,  260,
 /*  2380 */   338,  379,  379,  379,  379,  327,  379,  379,  379,  331,
 /*  2390 */   332,  333,  334,  335,  336,  288,  338,  379,  379,  379,
 /*  2400 */   379,  379,  379,  296,  379,  379,  379,  288,  301,  379,
 /*  2410 */   303,  379,  379,  379,  379,  296,  379,  379,  379,  379,
 /*  2420 */   301,  379,  303,  379,  379,  379,  379,  379,  379,  379,
 /*  2430 */   379,  379,  379,  379,  327,  379,  379,  379,  331,  332,
 /*  2440 */   333,  334,  335,  336,  379,  338,  327,  379,  379,  379,
 /*  2450 */   331,  332,  333,  334,  335,  336,  379,  338,
};
#define YY_SHIFT_COUNT    (665)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1964)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   917,    0,    0,   62,   62,  264,  264,  264,  326,  326,
 /*    10 */   264,  264,  391,  593,  720,  593,  593,  593,  593,  593,
 /*    20 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    30 */   593,  593,  593,  593,  593,  593,  593,  593,  593,  593,
 /*    40 */   593,  593,  102,  102,  262,  262,  262, 1019, 1019,  267,
 /*    50 */  1019, 1019,  540,  139,    4,   96,    4,    6,    6,   19,
 /*    60 */    19,  276,  205,    4,    4,    6,    6,    6,    6,    6,
 /*    70 */     6,    6,    6,    6,    6,    9,    6,    6,    6,   24,
 /*    80 */     6,    6,   74,    6,    6,   74,  258,    6,   74,   74,
 /*    90 */    74,    6,  314,  719,  662,  683,  683,  150,  213,  213,
 /*   100 */   213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
 /*   110 */   213,  213,  213,  213,  213,  213,  213,  549,  693,  205,
 /*   120 */   494,  494,  504,  151,  507,  263,  263,  263,  151,  308,
 /*   130 */   308,   24,  362,  362,   74,   74,  331,  331,  319,  410,
 /*   140 */   198,  198,  198,  198,  198,  198,  198,  660,   21,  129,
 /*   150 */   368,  447,    5,  215,  268,  548,  631,  299,  843,  451,
 /*   160 */   425,  716,  717,  716,  853,  376,  376,  376,  774,  765,
 /*   170 */   916, 1128, 1006, 1136, 1162, 1162, 1136, 1050, 1050, 1162,
 /*   180 */  1162, 1162, 1202, 1202, 1213,    9,   24,    9, 1233, 1235,
 /*   190 */     9, 1233,    9,    9,    9, 1162,    9, 1202,   74,   74,
 /*   200 */    74,   74,   74,   74,   74,   74,   74,   74,   74, 1162,
 /*   210 */  1202,  331, 1213,  314, 1107,   24,  314, 1162, 1162, 1233,
 /*   220 */   314, 1069,  331,  331,  331,  331, 1069,  331, 1152,  314,
 /*   230 */   319,  314,  308, 1314,  331, 1085, 1069,  331,  331, 1085,
 /*   240 */  1069,  331,  331,   74, 1094, 1184, 1085, 1106, 1108, 1121,
 /*   250 */   916, 1130,  308, 1341, 1132, 1129, 1122, 1132, 1129, 1132,
 /*   260 */  1129, 1275, 1286,  331,  410, 1162,  314, 1364, 1202, 2458,
 /*   270 */  2458, 2458, 2458, 2458, 2458, 2458,   83, 1633,  214,  307,
 /*   280 */   208,  497,  533,  542,  557,  623,  955,  249,  280,  280,
 /*   290 */   280,  280,  280,  280,  280,  280,  607,  221,  119,  119,
 /*   300 */    69,   68,  127,  534,   85,  302,    8,  133,  686,  686,
 /*   310 */   686,  686,  902,  972,  894,  921,  932,  934,  999, 1036,
 /*   320 */  1076,  888,  803, 1024, 1026, 1039, 1049, 1052, 1053, 1070,
 /*   330 */  1117, 1008,  960, 1000, 1077,  991, 1004, 1003, 1104, 1092,
 /*   340 */  1111, 1113, 1114, 1119, 1125, 1127, 1060, 1137, 1138, 1033,
 /*   350 */   612, 1417, 1420, 1245, 1423, 1424, 1383, 1426, 1395, 1246,
 /*   360 */  1400, 1401, 1404, 1254, 1445, 1411, 1412, 1261, 1449, 1264,
 /*   370 */  1452, 1418, 1454, 1433, 1456, 1422, 1287, 1290, 1461, 1470,
 /*   380 */  1305, 1315, 1481, 1484, 1439, 1488, 1447, 1490, 1492, 1494,
 /*   390 */  1346, 1496, 1497, 1498, 1508, 1509, 1356, 1466, 1502, 1359,
 /*   400 */  1504, 1505, 1510, 1512, 1513, 1514, 1515, 1516, 1518, 1519,
 /*   410 */  1520, 1529, 1530, 1531, 1491, 1534, 1536, 1537, 1538, 1541,
 /*   420 */  1543, 1522, 1545, 1546, 1548, 1549, 1550, 1495, 1553, 1499,
 /*   430 */  1556, 1557, 1517, 1523, 1521, 1544, 1533, 1547, 1535, 1563,
 /*   440 */  1525, 1528, 1568, 1569, 1580, 1551, 1431, 1591, 1593, 1594,
 /*   450 */  1540, 1595, 1597, 1564, 1558, 1559, 1600, 1571, 1560, 1570,
 /*   460 */  1608, 1575, 1566, 1572, 1614, 1581, 1574, 1576, 1618, 1622,
 /*   470 */  1623, 1624, 1527, 1532, 1602, 1604, 1639, 1605, 1587, 1599,
 /*   480 */  1609, 1610, 1631, 1646, 1636, 1655, 1637, 1611, 1661, 1641,
 /*   490 */  1629, 1667, 1638, 1668, 1640, 1671, 1656, 1659, 1681, 1526,
 /*   500 */  1657, 1693, 1524, 1669, 1542, 1552, 1694, 1695, 1554, 1539,
 /*   510 */  1709, 1710, 1720, 1634, 1635, 1555, 1722, 1643, 1573, 1645,
 /*   520 */  1727, 1690, 1582, 1647, 1644, 1684, 1697, 1507, 1652, 1654,
 /*   530 */  1653, 1658, 1660, 1662, 1702, 1663, 1665, 1666, 1670, 1679,
 /*   540 */  1703, 1701, 1706, 1682, 1713, 1567, 1680, 1683, 1712, 1565,
 /*   550 */  1729, 1728, 1730, 1687, 1735, 1588, 1689, 1714, 1746, 1748,
 /*   560 */  1749, 1750, 1756, 1689, 1790, 1772, 1606, 1752, 1708, 1715,
 /*   570 */  1711, 1717, 1719, 1726, 1758, 1731, 1733, 1777, 1780, 1648,
 /*   580 */  1736, 1718, 1734, 1791, 1793, 1741, 1739, 1804, 1751, 1754,
 /*   590 */  1806, 1753, 1755, 1811, 1759, 1757, 1815, 1762, 1742, 1743,
 /*   600 */  1745, 1747, 1830, 1760, 1765, 1770, 1828, 1778, 1823, 1823,
 /*   610 */  1846, 1807, 1809, 1836, 1837, 1839, 1840, 1841, 1842, 1844,
 /*   620 */  1814, 1796, 1843, 1849, 1850, 1865, 1854, 1869, 1863, 1868,
 /*   630 */  1838, 1587, 1870, 1599, 1872, 1879, 1881, 1882, 1897, 1886,
 /*   640 */  1922, 1888, 1877, 1890, 1925, 1892, 1885, 1895, 1940, 1906,
 /*   650 */  1899, 1905, 1947, 1914, 1903, 1913, 1953, 1919, 1921, 1958,
 /*   660 */  1938, 1949, 1950, 1959, 1964, 1951,
};
#define YY_REDUCE_COUNT (275)
#define YY_REDUCE_MIN   (-341)
#define YY_REDUCE_MAX   (2119)
static const short yy_reduce_ofst[] = {
 /*     0 */   364,  650,  677, -231,  321,  790,  852,  904,  956,  983,
 /*    10 */  1035, 1051,  152, 1131, 1141, 1190, 1239, 1251, 1300, 1316,
 /*    20 */  1369, 1381, 1430, 1479, 1500, 1561, 1577, 1630, 1642, 1691,
 /*    30 */  1740, 1761, 1810, 1822, 1874, 1891, 1944, 1993, 2042, 2058,
 /*    40 */  2107, 2119, 1585, 1632, -264,  -17,  225, -247,   90,   72,
 /*    50 */  -260,  435, -297,  453,  456,  463,  685, -268, -262, -259,
 /*    60 */  -228,    7, -190,   40,   51, -265,  -42,  346,  351,  426,
 /*    70 */   475,  543,  737,  761,  767,  115,  769,  770,  792, -186,
 /*    80 */   793,  794,  147,  806,  815, -196, -104,  831,  330,  422,
 /*    90 */   393,  836,  538,   22, -341, -341, -341,  125,  142,  194,
 /*   100 */   196,  405,  481,  517,  523,  572,  588,  608,  611,  614,
 /*   110 */   633,  648,  651,  688,  696,  697,  699,  101, -215, -287,
 /*   120 */    87,  173, -235, -135,  -34,  305,  406,  488,  156,  640,
 /*   130 */   643,  512,  266,  526, -168,  211,  449,  574,  610,  566,
 /*   140 */   229,  254,  294,  327,  344,  380,  400,  288,  442,  343,
 /*   150 */   535,  356,  580,  520,  630,  768,  768,  784,  810,  797,
 /*   160 */   740,  786,  786,  786,  804,  787,  795,  798,  807,  768,
 /*   170 */   846,  837,  859,  872,  927,  942,  903,  908,  912,  951,
 /*   180 */   952,  953,  961,  970,  919,  962,  943,  975,  939,  941,
 /*   190 */   984,  946,  990,  992,  993,  995,  994, 1005,  980,  981,
 /*   200 */   982,  985,  986,  987,  988,  989,  997, 1009, 1010, 1012,
 /*   210 */  1016, 1001,  959, 1023,  979,  998, 1034, 1028, 1037, 1007,
 /*   220 */  1038,  996, 1011, 1027, 1031, 1032, 1013, 1040, 1018, 1055,
 /*   230 */  1025, 1059, 1041, 1014, 1042, 1002, 1044, 1045, 1047, 1030,
 /*   240 */  1048, 1057, 1062,  768,  976, 1029, 1043, 1015, 1046, 1054,
 /*   250 */  1063,  786, 1064, 1061, 1022, 1056, 1020, 1058, 1066, 1067,
 /*   260 */  1071, 1065, 1110, 1098, 1126, 1135, 1140, 1142, 1146, 1093,
 /*   270 */  1097, 1133, 1134, 1139, 1147, 1155,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    10 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    20 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    30 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    40 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    50 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    60 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    70 */  1463, 1463, 1463, 1463, 1463, 1537, 1463, 1463, 1463, 1463,
 /*    80 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*    90 */  1463, 1463, 1535, 1693, 1463, 1870, 1463, 1463, 1463, 1463,
 /*   100 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   110 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   120 */  1463, 1463, 1537, 1463, 1535, 1882, 1882, 1882, 1463, 1463,
 /*   130 */  1463, 1463, 1736, 1736, 1463, 1463, 1463, 1463, 1635, 1463,
 /*   140 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1728, 1463, 1951,
 /*   150 */  1463, 1463, 1463, 1734, 1905, 1463, 1463, 1463, 1463, 1588,
 /*   160 */  1897, 1874, 1888, 1875, 1872, 1936, 1936, 1936, 1891, 1463,
 /*   170 */  1901, 1463, 1721, 1698, 1463, 1463, 1698, 1695, 1695, 1463,
 /*   180 */  1463, 1463, 1463, 1463, 1463, 1537, 1463, 1537, 1463, 1463,
 /*   190 */  1537, 1463, 1537, 1537, 1537, 1463, 1537, 1463, 1463, 1463,
 /*   200 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   210 */  1463, 1463, 1463, 1535, 1730, 1463, 1535, 1463, 1463, 1463,
 /*   220 */  1535, 1910, 1463, 1463, 1463, 1463, 1910, 1463, 1463, 1535,
 /*   230 */  1463, 1535, 1463, 1463, 1463, 1912, 1910, 1463, 1463, 1912,
 /*   240 */  1910, 1463, 1463, 1463, 1924, 1920, 1912, 1928, 1926, 1903,
 /*   250 */  1901, 1888, 1463, 1463, 1942, 1938, 1954, 1942, 1938, 1942,
 /*   260 */  1938, 1463, 1604, 1463, 1463, 1463, 1535, 1495, 1463, 1723,
 /*   270 */  1736, 1638, 1638, 1638, 1538, 1468, 1463, 1463, 1463, 1463,
 /*   280 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1807, 1923,
 /*   290 */  1922, 1846, 1845, 1844, 1842, 1806, 1463, 1600, 1805, 1804,
 /*   300 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1798, 1799,
 /*   310 */  1797, 1796, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   320 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   330 */  1871, 1463, 1939, 1943, 1463, 1463, 1463, 1463, 1463, 1782,
 /*   340 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   350 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   360 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   370 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   380 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   390 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   400 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   410 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   420 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   430 */  1463, 1463, 1463, 1463, 1500, 1463, 1463, 1463, 1463, 1463,
 /*   440 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   450 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   460 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   470 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1572, 1571,
 /*   480 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   490 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   500 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   510 */  1463, 1463, 1463, 1463, 1463, 1463, 1740, 1463, 1463, 1463,
 /*   520 */  1463, 1463, 1463, 1463, 1463, 1463, 1904, 1463, 1463, 1463,
 /*   530 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   540 */  1463, 1463, 1782, 1463, 1921, 1463, 1881, 1877, 1463, 1463,
 /*   550 */  1873, 1781, 1463, 1463, 1937, 1463, 1463, 1463, 1463, 1463,
 /*   560 */  1463, 1463, 1463, 1463, 1866, 1463, 1463, 1839, 1824, 1463,
 /*   570 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1792,
 /*   580 */  1463, 1463, 1463, 1463, 1463, 1632, 1463, 1463, 1463, 1463,
 /*   590 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1617, 1615,
 /*   600 */  1614, 1613, 1463, 1610, 1463, 1463, 1463, 1463, 1641, 1640,
 /*   610 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   620 */  1463, 1463, 1556, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   630 */  1463, 1548, 1463, 1547, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   640 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   650 */  1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
 /*   660 */  1463, 1463, 1463, 1463, 1463, 1463,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  251,  /*  NK_BITNOT => ID */
  251,  /*     VALUES => ID */
  251,  /*     IMPORT => ID */
  251,  /*    NK_SEMI => ID */
  251,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "PRECISION",
  /*   75 */ "REPLICA",
  /*   76 */ "STRICT",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "WAL_LEVEL",
  /*   82 */ "WAL_FSYNC_PERIOD",
  /*   83 */ "WAL_RETENTION_PERIOD",
  /*   84 */ "WAL_RETENTION_SIZE",
  /*   85 */ "WAL_ROLL_PERIOD",
  /*   86 */ "WAL_SEGMENT_SIZE",
  /*   87 */ "NK_COLON",
  /*   88 */ "TABLE",
  /*   89 */ "NK_LP",
  /*   90 */ "NK_RP",
  /*   91 */ "STABLE",
  /*   92 */ "ADD",
  /*   93 */ "COLUMN",
  /*   94 */ "MODIFY",
  /*   95 */ "RENAME",
  /*   96 */ "TAG",
  /*   97 */ "SET",
  /*   98 */ "NK_EQ",
  /*   99 */ "USING",
  /*  100 */ "TAGS",
  /*  101 */ "COMMENT",
  /*  102 */ "BOOL",
  /*  103 */ "TINYINT",
  /*  104 */ "SMALLINT",
  /*  105 */ "INT",
  /*  106 */ "INTEGER",
  /*  107 */ "BIGINT",
  /*  108 */ "FLOAT",
  /*  109 */ "DOUBLE",
  /*  110 */ "BINARY",
  /*  111 */ "TIMESTAMP",
  /*  112 */ "NCHAR",
  /*  113 */ "UNSIGNED",
  /*  114 */ "JSON",
  /*  115 */ "VARCHAR",
  /*  116 */ "MEDIUMBLOB",
  /*  117 */ "BLOB",
  /*  118 */ "VARBINARY",
  /*  119 */ "DECIMAL",
  /*  120 */ "MAX_DELAY",
  /*  121 */ "WATERMARK",
  /*  122 */ "ROLLUP",
  /*  123 */ "TTL",
  /*  124 */ "SMA",
  /*  125 */ "FIRST",
  /*  126 */ "LAST",
  /*  127 */ "SHOW",
  /*  128 */ "DATABASES",
  /*  129 */ "TABLES",
  /*  130 */ "STABLES",
  /*  131 */ "MNODES",
  /*  132 */ "MODULES",
  /*  133 */ "QNODES",
  /*  134 */ "FUNCTIONS",
  /*  135 */ "INDEXES",
  /*  136 */ "ACCOUNTS",
  /*  137 */ "APPS",
  /*  138 */ "CONNECTIONS",
  /*  139 */ "LICENCE",
  /*  140 */ "GRANTS",
  /*  141 */ "QUERIES",
  /*  142 */ "SCORES",
  /*  143 */ "TOPICS",
  /*  144 */ "VARIABLES",
  /*  145 */ "BNODES",
  /*  146 */ "SNODES",
  /*  147 */ "CLUSTER",
  /*  148 */ "TRANSACTIONS",
  /*  149 */ "DISTRIBUTED",
  /*  150 */ "CONSUMERS",
  /*  151 */ "SUBSCRIPTIONS",
  /*  152 */ "LIKE",
  /*  153 */ "INDEX",
  /*  154 */ "FUNCTION",
  /*  155 */ "INTERVAL",
  /*  156 */ "TOPIC",
  /*  157 */ "AS",
  /*  158 */ "WITH",
  /*  159 */ "META",
  /*  160 */ "CONSUMER",
  /*  161 */ "GROUP",
  /*  162 */ "DESC",
  /*  163 */ "DESCRIBE",
  /*  164 */ "RESET",
  /*  165 */ "QUERY",
  /*  166 */ "CACHE",
  /*  167 */ "EXPLAIN",
  /*  168 */ "ANALYZE",
  /*  169 */ "VERBOSE",
  /*  170 */ "NK_BOOL",
  /*  171 */ "RATIO",
  /*  172 */ "NK_FLOAT",
  /*  173 */ "OUTPUTTYPE",
  /*  174 */ "AGGREGATE",
  /*  175 */ "BUFSIZE",
  /*  176 */ "STREAM",
  /*  177 */ "INTO",
  /*  178 */ "TRIGGER",
  /*  179 */ "AT_ONCE",
  /*  180 */ "WINDOW_CLOSE",
  /*  181 */ "IGNORE",
  /*  182 */ "EXPIRED",
  /*  183 */ "KILL",
  /*  184 */ "CONNECTION",
  /*  185 */ "TRANSACTION",
  /*  186 */ "BALANCE",
  /*  187 */ "VGROUP",
  /*  188 */ "MERGE",
  /*  189 */ "REDISTRIBUTE",
  /*  190 */ "SPLIT",
  /*  191 */ "DELETE",
  /*  192 */ "INSERT",
  /*  193 */ "NULL",
  /*  194 */ "NK_QUESTION",
  /*  195 */ "NK_ARROW",
  /*  196 */ "ROWTS",
  /*  197 */ "TBNAME",
  /*  198 */ "QSTART",
  /*  199 */ "QEND",
  /*  200 */ "QDURATION",
  /*  201 */ "WSTART",
  /*  202 */ "WEND",
  /*  203 */ "WDURATION",
  /*  204 */ "CAST",
  /*  205 */ "NOW",
  /*  206 */ "TODAY",
  /*  207 */ "TIMEZONE",
  /*  208 */ "CLIENT_VERSION",
  /*  209 */ "SERVER_VERSION",
  /*  210 */ "SERVER_STATUS",
  /*  211 */ "CURRENT_USER",
  /*  212 */ "COUNT",
  /*  213 */ "LAST_ROW",
  /*  214 */ "BETWEEN",
  /*  215 */ "IS",
  /*  216 */ "NK_LT",
  /*  217 */ "NK_GT",
  /*  218 */ "NK_LE",
  /*  219 */ "NK_GE",
  /*  220 */ "NK_NE",
  /*  221 */ "MATCH",
  /*  222 */ "NMATCH",
  /*  223 */ "CONTAINS",
  /*  224 */ "IN",
  /*  225 */ "JOIN",
  /*  226 */ "INNER",
  /*  227 */ "SELECT",
  /*  228 */ "DISTINCT",
  /*  229 */ "WHERE",
  /*  230 */ "PARTITION",
  /*  231 */ "BY",
  /*  232 */ "SESSION",
  /*  233 */ "STATE_WINDOW",
  /*  234 */ "SLIDING",
  /*  235 */ "FILL",
  /*  236 */ "VALUE",
  /*  237 */ "NONE",
  /*  238 */ "PREV",
  /*  239 */ "LINEAR",
  /*  240 */ "NEXT",
  /*  241 */ "HAVING",
  /*  242 */ "RANGE",
  /*  243 */ "EVERY",
  /*  244 */ "ORDER",
  /*  245 */ "SLIMIT",
  /*  246 */ "SOFFSET",
  /*  247 */ "LIMIT",
  /*  248 */ "OFFSET",
  /*  249 */ "ASC",
  /*  250 */ "NULLS",
  /*  251 */ "ID",
  /*  252 */ "NK_BITNOT",
  /*  253 */ "VALUES",
  /*  254 */ "IMPORT",
  /*  255 */ "NK_SEMI",
  /*  256 */ "FILE",
  /*  257 */ "cmd",
  /*  258 */ "account_options",
  /*  259 */ "alter_account_options",
  /*  260 */ "literal",
  /*  261 */ "alter_account_option",
  /*  262 */ "user_name",
  /*  263 */ "sysinfo_opt",
  /*  264 */ "privileges",
  /*  265 */ "priv_level",
  /*  266 */ "priv_type_list",
  /*  267 */ "priv_type",
  /*  268 */ "db_name",
  /*  269 */ "dnode_endpoint",
  /*  270 */ "not_exists_opt",
  /*  271 */ "db_options",
  /*  272 */ "exists_opt",
  /*  273 */ "alter_db_options",
  /*  274 */ "integer_list",
  /*  275 */ "variable_list",
  /*  276 */ "retention_list",
  /*  277 */ "alter_db_option",
  /*  278 */ "retention",
  /*  279 */ "full_table_name",
  /*  280 */ "column_def_list",
  /*  281 */ "tags_def_opt",
  /*  282 */ "table_options",
  /*  283 */ "multi_create_clause",
  /*  284 */ "tags_def",
  /*  285 */ "multi_drop_clause",
  /*  286 */ "alter_table_clause",
  /*  287 */ "alter_table_options",
  /*  288 */ "column_name",
  /*  289 */ "type_name",
  /*  290 */ "signed_literal",
  /*  291 */ "create_subtable_clause",
  /*  292 */ "specific_cols_opt",
  /*  293 */ "expression_list",
  /*  294 */ "drop_table_clause",
  /*  295 */ "col_name_list",
  /*  296 */ "table_name",
  /*  297 */ "column_def",
  /*  298 */ "duration_list",
  /*  299 */ "rollup_func_list",
  /*  300 */ "alter_table_option",
  /*  301 */ "duration_literal",
  /*  302 */ "rollup_func_name",
  /*  303 */ "function_name",
  /*  304 */ "col_name",
  /*  305 */ "db_name_cond_opt",
  /*  306 */ "like_pattern_opt",
  /*  307 */ "table_name_cond",
  /*  308 */ "from_db_opt",
  /*  309 */ "index_options",
  /*  310 */ "func_list",
  /*  311 */ "sliding_opt",
  /*  312 */ "sma_stream_opt",
  /*  313 */ "func",
  /*  314 */ "stream_options",
  /*  315 */ "topic_name",
  /*  316 */ "query_expression",
  /*  317 */ "cgroup_name",
  /*  318 */ "analyze_opt",
  /*  319 */ "explain_options",
  /*  320 */ "agg_func_opt",
  /*  321 */ "bufsize_opt",
  /*  322 */ "stream_name",
  /*  323 */ "into_opt",
  /*  324 */ "dnode_list",
  /*  325 */ "where_clause_opt",
  /*  326 */ "signed",
  /*  327 */ "literal_func",
  /*  328 */ "literal_list",
  /*  329 */ "table_alias",
  /*  330 */ "column_alias",
  /*  331 */ "expression",
  /*  332 */ "pseudo_column",
  /*  333 */ "column_reference",
  /*  334 */ "function_expression",
  /*  335 */ "subquery",
  /*  336 */ "star_func",
  /*  337 */ "star_func_para_list",
  /*  338 */ "noarg_func",
  /*  339 */ "other_para_list",
  /*  340 */ "star_func_para",
  /*  341 */ "predicate",
  /*  342 */ "compare_op",
  /*  343 */ "in_op",
  /*  344 */ "in_predicate_value",
  /*  345 */ "boolean_value_expression",
  /*  346 */ "boolean_primary",
  /*  347 */ "common_expression",
  /*  348 */ "from_clause_opt",
  /*  349 */ "table_reference_list",
  /*  350 */ "table_reference",
  /*  351 */ "table_primary",
  /*  352 */ "joined_table",
  /*  353 */ "alias_opt",
  /*  354 */ "parenthesized_joined_table",
  /*  355 */ "join_type",
  /*  356 */ "search_condition",
  /*  357 */ "query_specification",
  /*  358 */ "set_quantifier_opt",
  /*  359 */ "select_list",
  /*  360 */ "partition_by_clause_opt",
  /*  361 */ "range_opt",
  /*  362 */ "every_opt",
  /*  363 */ "fill_opt",
  /*  364 */ "twindow_clause_opt",
  /*  365 */ "group_by_clause_opt",
  /*  366 */ "having_clause_opt",
  /*  367 */ "select_item",
  /*  368 */ "fill_mode",
  /*  369 */ "group_by_list",
  /*  370 */ "query_expression_body",
  /*  371 */ "order_by_clause_opt",
  /*  372 */ "slimit_clause_opt",
  /*  373 */ "limit_clause_opt",
  /*  374 */ "query_primary",
  /*  375 */ "sort_specification_list",
  /*  376 */ "sort_specification",
  /*  377 */ "ordering_specification_opt",
  /*  378 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  86 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  87 */ "db_options ::= db_options STRICT NK_STRING",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 100 */ "alter_db_options ::= alter_db_option",
 /* 101 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 102 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 103 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 104 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 105 */ "alter_db_option ::= KEEP integer_list",
 /* 106 */ "alter_db_option ::= KEEP variable_list",
 /* 107 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 108 */ "integer_list ::= NK_INTEGER",
 /* 109 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 110 */ "variable_list ::= NK_VARIABLE",
 /* 111 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 112 */ "retention_list ::= retention",
 /* 113 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 114 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 115 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 116 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 117 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 118 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 119 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 120 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 121 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 122 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 123 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 125 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 126 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 127 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 129 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 130 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 131 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 132 */ "multi_create_clause ::= create_subtable_clause",
 /* 133 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 134 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 135 */ "multi_drop_clause ::= drop_table_clause",
 /* 136 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 137 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 138 */ "specific_cols_opt ::=",
 /* 139 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 140 */ "full_table_name ::= table_name",
 /* 141 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 142 */ "column_def_list ::= column_def",
 /* 143 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 144 */ "column_def ::= column_name type_name",
 /* 145 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 146 */ "type_name ::= BOOL",
 /* 147 */ "type_name ::= TINYINT",
 /* 148 */ "type_name ::= SMALLINT",
 /* 149 */ "type_name ::= INT",
 /* 150 */ "type_name ::= INTEGER",
 /* 151 */ "type_name ::= BIGINT",
 /* 152 */ "type_name ::= FLOAT",
 /* 153 */ "type_name ::= DOUBLE",
 /* 154 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 155 */ "type_name ::= TIMESTAMP",
 /* 156 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= TINYINT UNSIGNED",
 /* 158 */ "type_name ::= SMALLINT UNSIGNED",
 /* 159 */ "type_name ::= INT UNSIGNED",
 /* 160 */ "type_name ::= BIGINT UNSIGNED",
 /* 161 */ "type_name ::= JSON",
 /* 162 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= MEDIUMBLOB",
 /* 164 */ "type_name ::= BLOB",
 /* 165 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= DECIMAL",
 /* 167 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 169 */ "tags_def_opt ::=",
 /* 170 */ "tags_def_opt ::= tags_def",
 /* 171 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 172 */ "table_options ::=",
 /* 173 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 174 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 175 */ "table_options ::= table_options WATERMARK duration_list",
 /* 176 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 177 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 178 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 179 */ "alter_table_options ::= alter_table_option",
 /* 180 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 181 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 182 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 183 */ "duration_list ::= duration_literal",
 /* 184 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 185 */ "rollup_func_list ::= rollup_func_name",
 /* 186 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 187 */ "rollup_func_name ::= function_name",
 /* 188 */ "rollup_func_name ::= FIRST",
 /* 189 */ "rollup_func_name ::= LAST",
 /* 190 */ "col_name_list ::= col_name",
 /* 191 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 192 */ "col_name ::= column_name",
 /* 193 */ "cmd ::= SHOW DNODES",
 /* 194 */ "cmd ::= SHOW USERS",
 /* 195 */ "cmd ::= SHOW DATABASES",
 /* 196 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 197 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 198 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 199 */ "cmd ::= SHOW MNODES",
 /* 200 */ "cmd ::= SHOW MODULES",
 /* 201 */ "cmd ::= SHOW QNODES",
 /* 202 */ "cmd ::= SHOW FUNCTIONS",
 /* 203 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 204 */ "cmd ::= SHOW STREAMS",
 /* 205 */ "cmd ::= SHOW ACCOUNTS",
 /* 206 */ "cmd ::= SHOW APPS",
 /* 207 */ "cmd ::= SHOW CONNECTIONS",
 /* 208 */ "cmd ::= SHOW LICENCE",
 /* 209 */ "cmd ::= SHOW GRANTS",
 /* 210 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 211 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 212 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 213 */ "cmd ::= SHOW QUERIES",
 /* 214 */ "cmd ::= SHOW SCORES",
 /* 215 */ "cmd ::= SHOW TOPICS",
 /* 216 */ "cmd ::= SHOW VARIABLES",
 /* 217 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 218 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 219 */ "cmd ::= SHOW BNODES",
 /* 220 */ "cmd ::= SHOW SNODES",
 /* 221 */ "cmd ::= SHOW CLUSTER",
 /* 222 */ "cmd ::= SHOW TRANSACTIONS",
 /* 223 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 224 */ "cmd ::= SHOW CONSUMERS",
 /* 225 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 226 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 227 */ "db_name_cond_opt ::=",
 /* 228 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 229 */ "like_pattern_opt ::=",
 /* 230 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 231 */ "table_name_cond ::= table_name",
 /* 232 */ "from_db_opt ::=",
 /* 233 */ "from_db_opt ::= FROM db_name",
 /* 234 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 235 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 236 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 237 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 238 */ "func_list ::= func",
 /* 239 */ "func_list ::= func_list NK_COMMA func",
 /* 240 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 241 */ "sma_stream_opt ::=",
 /* 242 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 243 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 245 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 246 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 247 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 248 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 249 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 250 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 251 */ "cmd ::= DESC full_table_name",
 /* 252 */ "cmd ::= DESCRIBE full_table_name",
 /* 253 */ "cmd ::= RESET QUERY CACHE",
 /* 254 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 255 */ "analyze_opt ::=",
 /* 256 */ "analyze_opt ::= ANALYZE",
 /* 257 */ "explain_options ::=",
 /* 258 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 259 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 260 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 261 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 262 */ "agg_func_opt ::=",
 /* 263 */ "agg_func_opt ::= AGGREGATE",
 /* 264 */ "bufsize_opt ::=",
 /* 265 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 266 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 267 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 268 */ "into_opt ::=",
 /* 269 */ "into_opt ::= INTO full_table_name",
 /* 270 */ "stream_options ::=",
 /* 271 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 272 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 273 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 274 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 275 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 276 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 277 */ "cmd ::= KILL QUERY NK_STRING",
 /* 278 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 279 */ "cmd ::= BALANCE VGROUP",
 /* 280 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 281 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 282 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 283 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 284 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 285 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 286 */ "cmd ::= query_expression",
 /* 287 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 288 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 289 */ "literal ::= NK_INTEGER",
 /* 290 */ "literal ::= NK_FLOAT",
 /* 291 */ "literal ::= NK_STRING",
 /* 292 */ "literal ::= NK_BOOL",
 /* 293 */ "literal ::= TIMESTAMP NK_STRING",
 /* 294 */ "literal ::= duration_literal",
 /* 295 */ "literal ::= NULL",
 /* 296 */ "literal ::= NK_QUESTION",
 /* 297 */ "duration_literal ::= NK_VARIABLE",
 /* 298 */ "signed ::= NK_INTEGER",
 /* 299 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 300 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 301 */ "signed ::= NK_FLOAT",
 /* 302 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 303 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 304 */ "signed_literal ::= signed",
 /* 305 */ "signed_literal ::= NK_STRING",
 /* 306 */ "signed_literal ::= NK_BOOL",
 /* 307 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 308 */ "signed_literal ::= duration_literal",
 /* 309 */ "signed_literal ::= NULL",
 /* 310 */ "signed_literal ::= literal_func",
 /* 311 */ "signed_literal ::= NK_QUESTION",
 /* 312 */ "literal_list ::= signed_literal",
 /* 313 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 314 */ "db_name ::= NK_ID",
 /* 315 */ "table_name ::= NK_ID",
 /* 316 */ "column_name ::= NK_ID",
 /* 317 */ "function_name ::= NK_ID",
 /* 318 */ "table_alias ::= NK_ID",
 /* 319 */ "column_alias ::= NK_ID",
 /* 320 */ "user_name ::= NK_ID",
 /* 321 */ "topic_name ::= NK_ID",
 /* 322 */ "stream_name ::= NK_ID",
 /* 323 */ "cgroup_name ::= NK_ID",
 /* 324 */ "expression ::= literal",
 /* 325 */ "expression ::= pseudo_column",
 /* 326 */ "expression ::= column_reference",
 /* 327 */ "expression ::= function_expression",
 /* 328 */ "expression ::= subquery",
 /* 329 */ "expression ::= NK_LP expression NK_RP",
 /* 330 */ "expression ::= NK_PLUS expression",
 /* 331 */ "expression ::= NK_MINUS expression",
 /* 332 */ "expression ::= expression NK_PLUS expression",
 /* 333 */ "expression ::= expression NK_MINUS expression",
 /* 334 */ "expression ::= expression NK_STAR expression",
 /* 335 */ "expression ::= expression NK_SLASH expression",
 /* 336 */ "expression ::= expression NK_REM expression",
 /* 337 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 338 */ "expression ::= expression NK_BITAND expression",
 /* 339 */ "expression ::= expression NK_BITOR expression",
 /* 340 */ "expression_list ::= expression",
 /* 341 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 342 */ "column_reference ::= column_name",
 /* 343 */ "column_reference ::= table_name NK_DOT column_name",
 /* 344 */ "pseudo_column ::= ROWTS",
 /* 345 */ "pseudo_column ::= TBNAME",
 /* 346 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 347 */ "pseudo_column ::= QSTART",
 /* 348 */ "pseudo_column ::= QEND",
 /* 349 */ "pseudo_column ::= QDURATION",
 /* 350 */ "pseudo_column ::= WSTART",
 /* 351 */ "pseudo_column ::= WEND",
 /* 352 */ "pseudo_column ::= WDURATION",
 /* 353 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 354 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 355 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 356 */ "function_expression ::= literal_func",
 /* 357 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 358 */ "literal_func ::= NOW",
 /* 359 */ "noarg_func ::= NOW",
 /* 360 */ "noarg_func ::= TODAY",
 /* 361 */ "noarg_func ::= TIMEZONE",
 /* 362 */ "noarg_func ::= DATABASE",
 /* 363 */ "noarg_func ::= CLIENT_VERSION",
 /* 364 */ "noarg_func ::= SERVER_VERSION",
 /* 365 */ "noarg_func ::= SERVER_STATUS",
 /* 366 */ "noarg_func ::= CURRENT_USER",
 /* 367 */ "noarg_func ::= USER",
 /* 368 */ "star_func ::= COUNT",
 /* 369 */ "star_func ::= FIRST",
 /* 370 */ "star_func ::= LAST",
 /* 371 */ "star_func ::= LAST_ROW",
 /* 372 */ "star_func_para_list ::= NK_STAR",
 /* 373 */ "star_func_para_list ::= other_para_list",
 /* 374 */ "other_para_list ::= star_func_para",
 /* 375 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 376 */ "star_func_para ::= expression",
 /* 377 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 378 */ "predicate ::= expression compare_op expression",
 /* 379 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 380 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 381 */ "predicate ::= expression IS NULL",
 /* 382 */ "predicate ::= expression IS NOT NULL",
 /* 383 */ "predicate ::= expression in_op in_predicate_value",
 /* 384 */ "compare_op ::= NK_LT",
 /* 385 */ "compare_op ::= NK_GT",
 /* 386 */ "compare_op ::= NK_LE",
 /* 387 */ "compare_op ::= NK_GE",
 /* 388 */ "compare_op ::= NK_NE",
 /* 389 */ "compare_op ::= NK_EQ",
 /* 390 */ "compare_op ::= LIKE",
 /* 391 */ "compare_op ::= NOT LIKE",
 /* 392 */ "compare_op ::= MATCH",
 /* 393 */ "compare_op ::= NMATCH",
 /* 394 */ "compare_op ::= CONTAINS",
 /* 395 */ "in_op ::= IN",
 /* 396 */ "in_op ::= NOT IN",
 /* 397 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 398 */ "boolean_value_expression ::= boolean_primary",
 /* 399 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 400 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 401 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 402 */ "boolean_primary ::= predicate",
 /* 403 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 404 */ "common_expression ::= expression",
 /* 405 */ "common_expression ::= boolean_value_expression",
 /* 406 */ "from_clause_opt ::=",
 /* 407 */ "from_clause_opt ::= FROM table_reference_list",
 /* 408 */ "table_reference_list ::= table_reference",
 /* 409 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 410 */ "table_reference ::= table_primary",
 /* 411 */ "table_reference ::= joined_table",
 /* 412 */ "table_primary ::= table_name alias_opt",
 /* 413 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 414 */ "table_primary ::= subquery alias_opt",
 /* 415 */ "table_primary ::= parenthesized_joined_table",
 /* 416 */ "alias_opt ::=",
 /* 417 */ "alias_opt ::= table_alias",
 /* 418 */ "alias_opt ::= AS table_alias",
 /* 419 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 420 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 421 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 422 */ "join_type ::=",
 /* 423 */ "join_type ::= INNER",
 /* 424 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 425 */ "set_quantifier_opt ::=",
 /* 426 */ "set_quantifier_opt ::= DISTINCT",
 /* 427 */ "set_quantifier_opt ::= ALL",
 /* 428 */ "select_list ::= select_item",
 /* 429 */ "select_list ::= select_list NK_COMMA select_item",
 /* 430 */ "select_item ::= NK_STAR",
 /* 431 */ "select_item ::= common_expression",
 /* 432 */ "select_item ::= common_expression column_alias",
 /* 433 */ "select_item ::= common_expression AS column_alias",
 /* 434 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 435 */ "where_clause_opt ::=",
 /* 436 */ "where_clause_opt ::= WHERE search_condition",
 /* 437 */ "partition_by_clause_opt ::=",
 /* 438 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 439 */ "twindow_clause_opt ::=",
 /* 440 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 441 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 442 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 443 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 444 */ "sliding_opt ::=",
 /* 445 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 446 */ "fill_opt ::=",
 /* 447 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 448 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 449 */ "fill_mode ::= NONE",
 /* 450 */ "fill_mode ::= PREV",
 /* 451 */ "fill_mode ::= NULL",
 /* 452 */ "fill_mode ::= LINEAR",
 /* 453 */ "fill_mode ::= NEXT",
 /* 454 */ "group_by_clause_opt ::=",
 /* 455 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 456 */ "group_by_list ::= expression",
 /* 457 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 458 */ "having_clause_opt ::=",
 /* 459 */ "having_clause_opt ::= HAVING search_condition",
 /* 460 */ "range_opt ::=",
 /* 461 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 462 */ "every_opt ::=",
 /* 463 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 464 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 465 */ "query_expression_body ::= query_primary",
 /* 466 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 467 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 468 */ "query_primary ::= query_specification",
 /* 469 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 470 */ "order_by_clause_opt ::=",
 /* 471 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 472 */ "slimit_clause_opt ::=",
 /* 473 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 474 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 475 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 476 */ "limit_clause_opt ::=",
 /* 477 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 478 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 479 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 480 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 481 */ "search_condition ::= common_expression",
 /* 482 */ "sort_specification_list ::= sort_specification",
 /* 483 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 484 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 485 */ "ordering_specification_opt ::=",
 /* 486 */ "ordering_specification_opt ::= ASC",
 /* 487 */ "ordering_specification_opt ::= DESC",
 /* 488 */ "null_ordering_opt ::=",
 /* 489 */ "null_ordering_opt ::= NULLS FIRST",
 /* 490 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 257: /* cmd */
    case 260: /* literal */
    case 271: /* db_options */
    case 273: /* alter_db_options */
    case 278: /* retention */
    case 279: /* full_table_name */
    case 282: /* table_options */
    case 286: /* alter_table_clause */
    case 287: /* alter_table_options */
    case 290: /* signed_literal */
    case 291: /* create_subtable_clause */
    case 294: /* drop_table_clause */
    case 297: /* column_def */
    case 301: /* duration_literal */
    case 302: /* rollup_func_name */
    case 304: /* col_name */
    case 305: /* db_name_cond_opt */
    case 306: /* like_pattern_opt */
    case 307: /* table_name_cond */
    case 308: /* from_db_opt */
    case 309: /* index_options */
    case 311: /* sliding_opt */
    case 312: /* sma_stream_opt */
    case 313: /* func */
    case 314: /* stream_options */
    case 316: /* query_expression */
    case 319: /* explain_options */
    case 323: /* into_opt */
    case 325: /* where_clause_opt */
    case 326: /* signed */
    case 327: /* literal_func */
    case 331: /* expression */
    case 332: /* pseudo_column */
    case 333: /* column_reference */
    case 334: /* function_expression */
    case 335: /* subquery */
    case 340: /* star_func_para */
    case 341: /* predicate */
    case 344: /* in_predicate_value */
    case 345: /* boolean_value_expression */
    case 346: /* boolean_primary */
    case 347: /* common_expression */
    case 348: /* from_clause_opt */
    case 349: /* table_reference_list */
    case 350: /* table_reference */
    case 351: /* table_primary */
    case 352: /* joined_table */
    case 354: /* parenthesized_joined_table */
    case 356: /* search_condition */
    case 357: /* query_specification */
    case 361: /* range_opt */
    case 362: /* every_opt */
    case 363: /* fill_opt */
    case 364: /* twindow_clause_opt */
    case 366: /* having_clause_opt */
    case 367: /* select_item */
    case 370: /* query_expression_body */
    case 372: /* slimit_clause_opt */
    case 373: /* limit_clause_opt */
    case 374: /* query_primary */
    case 376: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy616)); 
}
      break;
    case 258: /* account_options */
    case 259: /* alter_account_options */
    case 261: /* alter_account_option */
    case 321: /* bufsize_opt */
{
 
}
      break;
    case 262: /* user_name */
    case 265: /* priv_level */
    case 268: /* db_name */
    case 269: /* dnode_endpoint */
    case 288: /* column_name */
    case 296: /* table_name */
    case 303: /* function_name */
    case 315: /* topic_name */
    case 317: /* cgroup_name */
    case 322: /* stream_name */
    case 329: /* table_alias */
    case 330: /* column_alias */
    case 336: /* star_func */
    case 338: /* noarg_func */
    case 353: /* alias_opt */
{
 
}
      break;
    case 263: /* sysinfo_opt */
{
 
}
      break;
    case 264: /* privileges */
    case 266: /* priv_type_list */
    case 267: /* priv_type */
{
 
}
      break;
    case 270: /* not_exists_opt */
    case 272: /* exists_opt */
    case 318: /* analyze_opt */
    case 320: /* agg_func_opt */
    case 358: /* set_quantifier_opt */
{
 
}
      break;
    case 274: /* integer_list */
    case 275: /* variable_list */
    case 276: /* retention_list */
    case 280: /* column_def_list */
    case 281: /* tags_def_opt */
    case 283: /* multi_create_clause */
    case 284: /* tags_def */
    case 285: /* multi_drop_clause */
    case 292: /* specific_cols_opt */
    case 293: /* expression_list */
    case 295: /* col_name_list */
    case 298: /* duration_list */
    case 299: /* rollup_func_list */
    case 310: /* func_list */
    case 324: /* dnode_list */
    case 328: /* literal_list */
    case 337: /* star_func_para_list */
    case 339: /* other_para_list */
    case 359: /* select_list */
    case 360: /* partition_by_clause_opt */
    case 365: /* group_by_clause_opt */
    case 369: /* group_by_list */
    case 371: /* order_by_clause_opt */
    case 375: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy356)); 
}
      break;
    case 277: /* alter_db_option */
    case 300: /* alter_table_option */
{
 
}
      break;
    case 289: /* type_name */
{
 
}
      break;
    case 342: /* compare_op */
    case 343: /* in_op */
{
 
}
      break;
    case 355: /* join_type */
{
 
}
      break;
    case 368: /* fill_mode */
{
 
}
      break;
    case 377: /* ordering_specification_opt */
{
 
}
      break;
    case 378: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  257,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  257,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  258,    0 }, /* (2) account_options ::= */
  {  258,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  258,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  258,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  258,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  258,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  258,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  258,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  258,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  258,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  259,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  259,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  261,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  261,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  261,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  261,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  261,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  261,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  261,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  261,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  261,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  261,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  257,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  257,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  257,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  257,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  257,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  263,    0 }, /* (29) sysinfo_opt ::= */
  {  263,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  257,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  257,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  264,   -1 }, /* (33) privileges ::= ALL */
  {  264,   -1 }, /* (34) privileges ::= priv_type_list */
  {  266,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  266,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  267,   -1 }, /* (37) priv_type ::= READ */
  {  267,   -1 }, /* (38) priv_type ::= WRITE */
  {  265,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  265,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  257,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  257,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  257,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  257,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  257,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  257,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  257,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  257,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  269,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  269,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  269,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  257,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  257,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  257,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  257,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  257,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  257,   -2 }, /* (64) cmd ::= USE db_name */
  {  257,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  257,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  257,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  270,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  270,    0 }, /* (69) not_exists_opt ::= */
  {  272,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  272,    0 }, /* (71) exists_opt ::= */
  {  271,    0 }, /* (72) db_options ::= */
  {  271,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  271,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  271,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  271,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  271,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  271,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  271,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  271,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  271,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  271,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  271,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  271,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  271,   -3 }, /* (85) db_options ::= db_options PRECISION NK_STRING */
  {  271,   -3 }, /* (86) db_options ::= db_options REPLICA NK_INTEGER */
  {  271,   -3 }, /* (87) db_options ::= db_options STRICT NK_STRING */
  {  271,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  271,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  271,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  271,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  271,   -3 }, /* (92) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  271,   -3 }, /* (93) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  271,   -3 }, /* (94) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  271,   -4 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  271,   -3 }, /* (96) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  271,   -4 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  271,   -3 }, /* (98) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  271,   -3 }, /* (99) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  273,   -1 }, /* (100) alter_db_options ::= alter_db_option */
  {  273,   -2 }, /* (101) alter_db_options ::= alter_db_options alter_db_option */
  {  277,   -2 }, /* (102) alter_db_option ::= CACHEMODEL NK_STRING */
  {  277,   -2 }, /* (103) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  277,   -2 }, /* (104) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  277,   -2 }, /* (105) alter_db_option ::= KEEP integer_list */
  {  277,   -2 }, /* (106) alter_db_option ::= KEEP variable_list */
  {  277,   -2 }, /* (107) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  274,   -1 }, /* (108) integer_list ::= NK_INTEGER */
  {  274,   -3 }, /* (109) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  275,   -1 }, /* (110) variable_list ::= NK_VARIABLE */
  {  275,   -3 }, /* (111) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  276,   -1 }, /* (112) retention_list ::= retention */
  {  276,   -3 }, /* (113) retention_list ::= retention_list NK_COMMA retention */
  {  278,   -3 }, /* (114) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  257,   -9 }, /* (115) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  257,   -3 }, /* (116) cmd ::= CREATE TABLE multi_create_clause */
  {  257,   -9 }, /* (117) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  257,   -3 }, /* (118) cmd ::= DROP TABLE multi_drop_clause */
  {  257,   -4 }, /* (119) cmd ::= DROP STABLE exists_opt full_table_name */
  {  257,   -3 }, /* (120) cmd ::= ALTER TABLE alter_table_clause */
  {  257,   -3 }, /* (121) cmd ::= ALTER STABLE alter_table_clause */
  {  286,   -2 }, /* (122) alter_table_clause ::= full_table_name alter_table_options */
  {  286,   -5 }, /* (123) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  286,   -4 }, /* (124) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  286,   -5 }, /* (125) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  286,   -5 }, /* (126) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  286,   -5 }, /* (127) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  286,   -4 }, /* (128) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  286,   -5 }, /* (129) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  286,   -5 }, /* (130) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  286,   -6 }, /* (131) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  283,   -1 }, /* (132) multi_create_clause ::= create_subtable_clause */
  {  283,   -2 }, /* (133) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  291,  -10 }, /* (134) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  285,   -1 }, /* (135) multi_drop_clause ::= drop_table_clause */
  {  285,   -2 }, /* (136) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  294,   -2 }, /* (137) drop_table_clause ::= exists_opt full_table_name */
  {  292,    0 }, /* (138) specific_cols_opt ::= */
  {  292,   -3 }, /* (139) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  279,   -1 }, /* (140) full_table_name ::= table_name */
  {  279,   -3 }, /* (141) full_table_name ::= db_name NK_DOT table_name */
  {  280,   -1 }, /* (142) column_def_list ::= column_def */
  {  280,   -3 }, /* (143) column_def_list ::= column_def_list NK_COMMA column_def */
  {  297,   -2 }, /* (144) column_def ::= column_name type_name */
  {  297,   -4 }, /* (145) column_def ::= column_name type_name COMMENT NK_STRING */
  {  289,   -1 }, /* (146) type_name ::= BOOL */
  {  289,   -1 }, /* (147) type_name ::= TINYINT */
  {  289,   -1 }, /* (148) type_name ::= SMALLINT */
  {  289,   -1 }, /* (149) type_name ::= INT */
  {  289,   -1 }, /* (150) type_name ::= INTEGER */
  {  289,   -1 }, /* (151) type_name ::= BIGINT */
  {  289,   -1 }, /* (152) type_name ::= FLOAT */
  {  289,   -1 }, /* (153) type_name ::= DOUBLE */
  {  289,   -4 }, /* (154) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  289,   -1 }, /* (155) type_name ::= TIMESTAMP */
  {  289,   -4 }, /* (156) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  289,   -2 }, /* (157) type_name ::= TINYINT UNSIGNED */
  {  289,   -2 }, /* (158) type_name ::= SMALLINT UNSIGNED */
  {  289,   -2 }, /* (159) type_name ::= INT UNSIGNED */
  {  289,   -2 }, /* (160) type_name ::= BIGINT UNSIGNED */
  {  289,   -1 }, /* (161) type_name ::= JSON */
  {  289,   -4 }, /* (162) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  289,   -1 }, /* (163) type_name ::= MEDIUMBLOB */
  {  289,   -1 }, /* (164) type_name ::= BLOB */
  {  289,   -4 }, /* (165) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  289,   -1 }, /* (166) type_name ::= DECIMAL */
  {  289,   -4 }, /* (167) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  289,   -6 }, /* (168) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  281,    0 }, /* (169) tags_def_opt ::= */
  {  281,   -1 }, /* (170) tags_def_opt ::= tags_def */
  {  284,   -4 }, /* (171) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  282,    0 }, /* (172) table_options ::= */
  {  282,   -3 }, /* (173) table_options ::= table_options COMMENT NK_STRING */
  {  282,   -3 }, /* (174) table_options ::= table_options MAX_DELAY duration_list */
  {  282,   -3 }, /* (175) table_options ::= table_options WATERMARK duration_list */
  {  282,   -5 }, /* (176) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  282,   -3 }, /* (177) table_options ::= table_options TTL NK_INTEGER */
  {  282,   -5 }, /* (178) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  287,   -1 }, /* (179) alter_table_options ::= alter_table_option */
  {  287,   -2 }, /* (180) alter_table_options ::= alter_table_options alter_table_option */
  {  300,   -2 }, /* (181) alter_table_option ::= COMMENT NK_STRING */
  {  300,   -2 }, /* (182) alter_table_option ::= TTL NK_INTEGER */
  {  298,   -1 }, /* (183) duration_list ::= duration_literal */
  {  298,   -3 }, /* (184) duration_list ::= duration_list NK_COMMA duration_literal */
  {  299,   -1 }, /* (185) rollup_func_list ::= rollup_func_name */
  {  299,   -3 }, /* (186) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  302,   -1 }, /* (187) rollup_func_name ::= function_name */
  {  302,   -1 }, /* (188) rollup_func_name ::= FIRST */
  {  302,   -1 }, /* (189) rollup_func_name ::= LAST */
  {  295,   -1 }, /* (190) col_name_list ::= col_name */
  {  295,   -3 }, /* (191) col_name_list ::= col_name_list NK_COMMA col_name */
  {  304,   -1 }, /* (192) col_name ::= column_name */
  {  257,   -2 }, /* (193) cmd ::= SHOW DNODES */
  {  257,   -2 }, /* (194) cmd ::= SHOW USERS */
  {  257,   -2 }, /* (195) cmd ::= SHOW DATABASES */
  {  257,   -4 }, /* (196) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  257,   -4 }, /* (197) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  257,   -3 }, /* (198) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  257,   -2 }, /* (199) cmd ::= SHOW MNODES */
  {  257,   -2 }, /* (200) cmd ::= SHOW MODULES */
  {  257,   -2 }, /* (201) cmd ::= SHOW QNODES */
  {  257,   -2 }, /* (202) cmd ::= SHOW FUNCTIONS */
  {  257,   -5 }, /* (203) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  257,   -2 }, /* (204) cmd ::= SHOW STREAMS */
  {  257,   -2 }, /* (205) cmd ::= SHOW ACCOUNTS */
  {  257,   -2 }, /* (206) cmd ::= SHOW APPS */
  {  257,   -2 }, /* (207) cmd ::= SHOW CONNECTIONS */
  {  257,   -2 }, /* (208) cmd ::= SHOW LICENCE */
  {  257,   -2 }, /* (209) cmd ::= SHOW GRANTS */
  {  257,   -4 }, /* (210) cmd ::= SHOW CREATE DATABASE db_name */
  {  257,   -4 }, /* (211) cmd ::= SHOW CREATE TABLE full_table_name */
  {  257,   -4 }, /* (212) cmd ::= SHOW CREATE STABLE full_table_name */
  {  257,   -2 }, /* (213) cmd ::= SHOW QUERIES */
  {  257,   -2 }, /* (214) cmd ::= SHOW SCORES */
  {  257,   -2 }, /* (215) cmd ::= SHOW TOPICS */
  {  257,   -2 }, /* (216) cmd ::= SHOW VARIABLES */
  {  257,   -3 }, /* (217) cmd ::= SHOW LOCAL VARIABLES */
  {  257,   -4 }, /* (218) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  257,   -2 }, /* (219) cmd ::= SHOW BNODES */
  {  257,   -2 }, /* (220) cmd ::= SHOW SNODES */
  {  257,   -2 }, /* (221) cmd ::= SHOW CLUSTER */
  {  257,   -2 }, /* (222) cmd ::= SHOW TRANSACTIONS */
  {  257,   -4 }, /* (223) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  257,   -2 }, /* (224) cmd ::= SHOW CONSUMERS */
  {  257,   -2 }, /* (225) cmd ::= SHOW SUBSCRIPTIONS */
  {  257,   -5 }, /* (226) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  305,    0 }, /* (227) db_name_cond_opt ::= */
  {  305,   -2 }, /* (228) db_name_cond_opt ::= db_name NK_DOT */
  {  306,    0 }, /* (229) like_pattern_opt ::= */
  {  306,   -2 }, /* (230) like_pattern_opt ::= LIKE NK_STRING */
  {  307,   -1 }, /* (231) table_name_cond ::= table_name */
  {  308,    0 }, /* (232) from_db_opt ::= */
  {  308,   -2 }, /* (233) from_db_opt ::= FROM db_name */
  {  257,   -8 }, /* (234) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  257,   -4 }, /* (235) cmd ::= DROP INDEX exists_opt full_table_name */
  {  309,  -10 }, /* (236) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  309,  -12 }, /* (237) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  310,   -1 }, /* (238) func_list ::= func */
  {  310,   -3 }, /* (239) func_list ::= func_list NK_COMMA func */
  {  313,   -4 }, /* (240) func ::= function_name NK_LP expression_list NK_RP */
  {  312,    0 }, /* (241) sma_stream_opt ::= */
  {  312,   -3 }, /* (242) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  312,   -3 }, /* (243) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  257,   -6 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  257,   -7 }, /* (245) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  257,   -9 }, /* (246) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  257,   -7 }, /* (247) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  257,   -9 }, /* (248) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  257,   -4 }, /* (249) cmd ::= DROP TOPIC exists_opt topic_name */
  {  257,   -7 }, /* (250) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  257,   -2 }, /* (251) cmd ::= DESC full_table_name */
  {  257,   -2 }, /* (252) cmd ::= DESCRIBE full_table_name */
  {  257,   -3 }, /* (253) cmd ::= RESET QUERY CACHE */
  {  257,   -4 }, /* (254) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  318,    0 }, /* (255) analyze_opt ::= */
  {  318,   -1 }, /* (256) analyze_opt ::= ANALYZE */
  {  319,    0 }, /* (257) explain_options ::= */
  {  319,   -3 }, /* (258) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  319,   -3 }, /* (259) explain_options ::= explain_options RATIO NK_FLOAT */
  {  257,  -10 }, /* (260) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  257,   -4 }, /* (261) cmd ::= DROP FUNCTION exists_opt function_name */
  {  320,    0 }, /* (262) agg_func_opt ::= */
  {  320,   -1 }, /* (263) agg_func_opt ::= AGGREGATE */
  {  321,    0 }, /* (264) bufsize_opt ::= */
  {  321,   -2 }, /* (265) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  257,   -8 }, /* (266) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  257,   -4 }, /* (267) cmd ::= DROP STREAM exists_opt stream_name */
  {  323,    0 }, /* (268) into_opt ::= */
  {  323,   -2 }, /* (269) into_opt ::= INTO full_table_name */
  {  314,    0 }, /* (270) stream_options ::= */
  {  314,   -3 }, /* (271) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  314,   -3 }, /* (272) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  314,   -4 }, /* (273) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  314,   -3 }, /* (274) stream_options ::= stream_options WATERMARK duration_literal */
  {  314,   -3 }, /* (275) stream_options ::= stream_options IGNORE EXPIRED */
  {  257,   -3 }, /* (276) cmd ::= KILL CONNECTION NK_INTEGER */
  {  257,   -3 }, /* (277) cmd ::= KILL QUERY NK_STRING */
  {  257,   -3 }, /* (278) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  257,   -2 }, /* (279) cmd ::= BALANCE VGROUP */
  {  257,   -4 }, /* (280) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  257,   -4 }, /* (281) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  257,   -3 }, /* (282) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  324,   -2 }, /* (283) dnode_list ::= DNODE NK_INTEGER */
  {  324,   -3 }, /* (284) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  257,   -4 }, /* (285) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  257,   -1 }, /* (286) cmd ::= query_expression */
  {  257,   -7 }, /* (287) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  257,   -4 }, /* (288) cmd ::= INSERT INTO full_table_name query_expression */
  {  260,   -1 }, /* (289) literal ::= NK_INTEGER */
  {  260,   -1 }, /* (290) literal ::= NK_FLOAT */
  {  260,   -1 }, /* (291) literal ::= NK_STRING */
  {  260,   -1 }, /* (292) literal ::= NK_BOOL */
  {  260,   -2 }, /* (293) literal ::= TIMESTAMP NK_STRING */
  {  260,   -1 }, /* (294) literal ::= duration_literal */
  {  260,   -1 }, /* (295) literal ::= NULL */
  {  260,   -1 }, /* (296) literal ::= NK_QUESTION */
  {  301,   -1 }, /* (297) duration_literal ::= NK_VARIABLE */
  {  326,   -1 }, /* (298) signed ::= NK_INTEGER */
  {  326,   -2 }, /* (299) signed ::= NK_PLUS NK_INTEGER */
  {  326,   -2 }, /* (300) signed ::= NK_MINUS NK_INTEGER */
  {  326,   -1 }, /* (301) signed ::= NK_FLOAT */
  {  326,   -2 }, /* (302) signed ::= NK_PLUS NK_FLOAT */
  {  326,   -2 }, /* (303) signed ::= NK_MINUS NK_FLOAT */
  {  290,   -1 }, /* (304) signed_literal ::= signed */
  {  290,   -1 }, /* (305) signed_literal ::= NK_STRING */
  {  290,   -1 }, /* (306) signed_literal ::= NK_BOOL */
  {  290,   -2 }, /* (307) signed_literal ::= TIMESTAMP NK_STRING */
  {  290,   -1 }, /* (308) signed_literal ::= duration_literal */
  {  290,   -1 }, /* (309) signed_literal ::= NULL */
  {  290,   -1 }, /* (310) signed_literal ::= literal_func */
  {  290,   -1 }, /* (311) signed_literal ::= NK_QUESTION */
  {  328,   -1 }, /* (312) literal_list ::= signed_literal */
  {  328,   -3 }, /* (313) literal_list ::= literal_list NK_COMMA signed_literal */
  {  268,   -1 }, /* (314) db_name ::= NK_ID */
  {  296,   -1 }, /* (315) table_name ::= NK_ID */
  {  288,   -1 }, /* (316) column_name ::= NK_ID */
  {  303,   -1 }, /* (317) function_name ::= NK_ID */
  {  329,   -1 }, /* (318) table_alias ::= NK_ID */
  {  330,   -1 }, /* (319) column_alias ::= NK_ID */
  {  262,   -1 }, /* (320) user_name ::= NK_ID */
  {  315,   -1 }, /* (321) topic_name ::= NK_ID */
  {  322,   -1 }, /* (322) stream_name ::= NK_ID */
  {  317,   -1 }, /* (323) cgroup_name ::= NK_ID */
  {  331,   -1 }, /* (324) expression ::= literal */
  {  331,   -1 }, /* (325) expression ::= pseudo_column */
  {  331,   -1 }, /* (326) expression ::= column_reference */
  {  331,   -1 }, /* (327) expression ::= function_expression */
  {  331,   -1 }, /* (328) expression ::= subquery */
  {  331,   -3 }, /* (329) expression ::= NK_LP expression NK_RP */
  {  331,   -2 }, /* (330) expression ::= NK_PLUS expression */
  {  331,   -2 }, /* (331) expression ::= NK_MINUS expression */
  {  331,   -3 }, /* (332) expression ::= expression NK_PLUS expression */
  {  331,   -3 }, /* (333) expression ::= expression NK_MINUS expression */
  {  331,   -3 }, /* (334) expression ::= expression NK_STAR expression */
  {  331,   -3 }, /* (335) expression ::= expression NK_SLASH expression */
  {  331,   -3 }, /* (336) expression ::= expression NK_REM expression */
  {  331,   -3 }, /* (337) expression ::= column_reference NK_ARROW NK_STRING */
  {  331,   -3 }, /* (338) expression ::= expression NK_BITAND expression */
  {  331,   -3 }, /* (339) expression ::= expression NK_BITOR expression */
  {  293,   -1 }, /* (340) expression_list ::= expression */
  {  293,   -3 }, /* (341) expression_list ::= expression_list NK_COMMA expression */
  {  333,   -1 }, /* (342) column_reference ::= column_name */
  {  333,   -3 }, /* (343) column_reference ::= table_name NK_DOT column_name */
  {  332,   -1 }, /* (344) pseudo_column ::= ROWTS */
  {  332,   -1 }, /* (345) pseudo_column ::= TBNAME */
  {  332,   -3 }, /* (346) pseudo_column ::= table_name NK_DOT TBNAME */
  {  332,   -1 }, /* (347) pseudo_column ::= QSTART */
  {  332,   -1 }, /* (348) pseudo_column ::= QEND */
  {  332,   -1 }, /* (349) pseudo_column ::= QDURATION */
  {  332,   -1 }, /* (350) pseudo_column ::= WSTART */
  {  332,   -1 }, /* (351) pseudo_column ::= WEND */
  {  332,   -1 }, /* (352) pseudo_column ::= WDURATION */
  {  334,   -4 }, /* (353) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  334,   -4 }, /* (354) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  334,   -6 }, /* (355) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  334,   -1 }, /* (356) function_expression ::= literal_func */
  {  327,   -3 }, /* (357) literal_func ::= noarg_func NK_LP NK_RP */
  {  327,   -1 }, /* (358) literal_func ::= NOW */
  {  338,   -1 }, /* (359) noarg_func ::= NOW */
  {  338,   -1 }, /* (360) noarg_func ::= TODAY */
  {  338,   -1 }, /* (361) noarg_func ::= TIMEZONE */
  {  338,   -1 }, /* (362) noarg_func ::= DATABASE */
  {  338,   -1 }, /* (363) noarg_func ::= CLIENT_VERSION */
  {  338,   -1 }, /* (364) noarg_func ::= SERVER_VERSION */
  {  338,   -1 }, /* (365) noarg_func ::= SERVER_STATUS */
  {  338,   -1 }, /* (366) noarg_func ::= CURRENT_USER */
  {  338,   -1 }, /* (367) noarg_func ::= USER */
  {  336,   -1 }, /* (368) star_func ::= COUNT */
  {  336,   -1 }, /* (369) star_func ::= FIRST */
  {  336,   -1 }, /* (370) star_func ::= LAST */
  {  336,   -1 }, /* (371) star_func ::= LAST_ROW */
  {  337,   -1 }, /* (372) star_func_para_list ::= NK_STAR */
  {  337,   -1 }, /* (373) star_func_para_list ::= other_para_list */
  {  339,   -1 }, /* (374) other_para_list ::= star_func_para */
  {  339,   -3 }, /* (375) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  340,   -1 }, /* (376) star_func_para ::= expression */
  {  340,   -3 }, /* (377) star_func_para ::= table_name NK_DOT NK_STAR */
  {  341,   -3 }, /* (378) predicate ::= expression compare_op expression */
  {  341,   -5 }, /* (379) predicate ::= expression BETWEEN expression AND expression */
  {  341,   -6 }, /* (380) predicate ::= expression NOT BETWEEN expression AND expression */
  {  341,   -3 }, /* (381) predicate ::= expression IS NULL */
  {  341,   -4 }, /* (382) predicate ::= expression IS NOT NULL */
  {  341,   -3 }, /* (383) predicate ::= expression in_op in_predicate_value */
  {  342,   -1 }, /* (384) compare_op ::= NK_LT */
  {  342,   -1 }, /* (385) compare_op ::= NK_GT */
  {  342,   -1 }, /* (386) compare_op ::= NK_LE */
  {  342,   -1 }, /* (387) compare_op ::= NK_GE */
  {  342,   -1 }, /* (388) compare_op ::= NK_NE */
  {  342,   -1 }, /* (389) compare_op ::= NK_EQ */
  {  342,   -1 }, /* (390) compare_op ::= LIKE */
  {  342,   -2 }, /* (391) compare_op ::= NOT LIKE */
  {  342,   -1 }, /* (392) compare_op ::= MATCH */
  {  342,   -1 }, /* (393) compare_op ::= NMATCH */
  {  342,   -1 }, /* (394) compare_op ::= CONTAINS */
  {  343,   -1 }, /* (395) in_op ::= IN */
  {  343,   -2 }, /* (396) in_op ::= NOT IN */
  {  344,   -3 }, /* (397) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  345,   -1 }, /* (398) boolean_value_expression ::= boolean_primary */
  {  345,   -2 }, /* (399) boolean_value_expression ::= NOT boolean_primary */
  {  345,   -3 }, /* (400) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  345,   -3 }, /* (401) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  346,   -1 }, /* (402) boolean_primary ::= predicate */
  {  346,   -3 }, /* (403) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  347,   -1 }, /* (404) common_expression ::= expression */
  {  347,   -1 }, /* (405) common_expression ::= boolean_value_expression */
  {  348,    0 }, /* (406) from_clause_opt ::= */
  {  348,   -2 }, /* (407) from_clause_opt ::= FROM table_reference_list */
  {  349,   -1 }, /* (408) table_reference_list ::= table_reference */
  {  349,   -3 }, /* (409) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  350,   -1 }, /* (410) table_reference ::= table_primary */
  {  350,   -1 }, /* (411) table_reference ::= joined_table */
  {  351,   -2 }, /* (412) table_primary ::= table_name alias_opt */
  {  351,   -4 }, /* (413) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  351,   -2 }, /* (414) table_primary ::= subquery alias_opt */
  {  351,   -1 }, /* (415) table_primary ::= parenthesized_joined_table */
  {  353,    0 }, /* (416) alias_opt ::= */
  {  353,   -1 }, /* (417) alias_opt ::= table_alias */
  {  353,   -2 }, /* (418) alias_opt ::= AS table_alias */
  {  354,   -3 }, /* (419) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  354,   -3 }, /* (420) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  352,   -6 }, /* (421) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  355,    0 }, /* (422) join_type ::= */
  {  355,   -1 }, /* (423) join_type ::= INNER */
  {  357,  -12 }, /* (424) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  358,    0 }, /* (425) set_quantifier_opt ::= */
  {  358,   -1 }, /* (426) set_quantifier_opt ::= DISTINCT */
  {  358,   -1 }, /* (427) set_quantifier_opt ::= ALL */
  {  359,   -1 }, /* (428) select_list ::= select_item */
  {  359,   -3 }, /* (429) select_list ::= select_list NK_COMMA select_item */
  {  367,   -1 }, /* (430) select_item ::= NK_STAR */
  {  367,   -1 }, /* (431) select_item ::= common_expression */
  {  367,   -2 }, /* (432) select_item ::= common_expression column_alias */
  {  367,   -3 }, /* (433) select_item ::= common_expression AS column_alias */
  {  367,   -3 }, /* (434) select_item ::= table_name NK_DOT NK_STAR */
  {  325,    0 }, /* (435) where_clause_opt ::= */
  {  325,   -2 }, /* (436) where_clause_opt ::= WHERE search_condition */
  {  360,    0 }, /* (437) partition_by_clause_opt ::= */
  {  360,   -3 }, /* (438) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  364,    0 }, /* (439) twindow_clause_opt ::= */
  {  364,   -6 }, /* (440) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  364,   -4 }, /* (441) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  364,   -6 }, /* (442) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  364,   -8 }, /* (443) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  311,    0 }, /* (444) sliding_opt ::= */
  {  311,   -4 }, /* (445) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  363,    0 }, /* (446) fill_opt ::= */
  {  363,   -4 }, /* (447) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  363,   -6 }, /* (448) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  368,   -1 }, /* (449) fill_mode ::= NONE */
  {  368,   -1 }, /* (450) fill_mode ::= PREV */
  {  368,   -1 }, /* (451) fill_mode ::= NULL */
  {  368,   -1 }, /* (452) fill_mode ::= LINEAR */
  {  368,   -1 }, /* (453) fill_mode ::= NEXT */
  {  365,    0 }, /* (454) group_by_clause_opt ::= */
  {  365,   -3 }, /* (455) group_by_clause_opt ::= GROUP BY group_by_list */
  {  369,   -1 }, /* (456) group_by_list ::= expression */
  {  369,   -3 }, /* (457) group_by_list ::= group_by_list NK_COMMA expression */
  {  366,    0 }, /* (458) having_clause_opt ::= */
  {  366,   -2 }, /* (459) having_clause_opt ::= HAVING search_condition */
  {  361,    0 }, /* (460) range_opt ::= */
  {  361,   -6 }, /* (461) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  362,    0 }, /* (462) every_opt ::= */
  {  362,   -4 }, /* (463) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  316,   -4 }, /* (464) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  370,   -1 }, /* (465) query_expression_body ::= query_primary */
  {  370,   -4 }, /* (466) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  370,   -3 }, /* (467) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  374,   -1 }, /* (468) query_primary ::= query_specification */
  {  374,   -6 }, /* (469) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  371,    0 }, /* (470) order_by_clause_opt ::= */
  {  371,   -3 }, /* (471) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  372,    0 }, /* (472) slimit_clause_opt ::= */
  {  372,   -2 }, /* (473) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  372,   -4 }, /* (474) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  372,   -4 }, /* (475) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  373,    0 }, /* (476) limit_clause_opt ::= */
  {  373,   -2 }, /* (477) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  373,   -4 }, /* (478) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  373,   -4 }, /* (479) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  335,   -3 }, /* (480) subquery ::= NK_LP query_expression NK_RP */
  {  356,   -1 }, /* (481) search_condition ::= common_expression */
  {  375,   -1 }, /* (482) sort_specification_list ::= sort_specification */
  {  375,   -3 }, /* (483) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  376,   -3 }, /* (484) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  377,    0 }, /* (485) ordering_specification_opt ::= */
  {  377,   -1 }, /* (486) ordering_specification_opt ::= ASC */
  {  377,   -1 }, /* (487) ordering_specification_opt ::= DESC */
  {  378,    0 }, /* (488) null_ordering_opt ::= */
  {  378,   -2 }, /* (489) null_ordering_opt ::= NULLS FIRST */
  {  378,   -2 }, /* (490) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,258,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,259,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,258,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,260,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,261,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,259,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,261,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,260,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy0, yymsp[0].minor.yy285); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy285 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy285 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy457, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy457, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy457 = yymsp[0].minor.yy457; }
  yymsp[0].minor.yy457 = yylhsminor.yy457;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy457 = yymsp[-2].minor.yy457 | yymsp[0].minor.yy457; }
  yymsp[-2].minor.yy457 = yylhsminor.yy457;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy361 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy361 = yylhsminor.yy361;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy361 = yymsp[-2].minor.yy361; }
  yymsp[-2].minor.yy361 = yylhsminor.yy361;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy361, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 314: /* db_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* table_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* column_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* function_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* table_alias ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* column_alias ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* user_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* topic_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* stream_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 359: /* noarg_func ::= NOW */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= TODAY */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= USER */ yytestcase(yyruleno==367);
      case 368: /* star_func ::= COUNT */ yytestcase(yyruleno==368);
      case 369: /* star_func ::= FIRST */ yytestcase(yyruleno==369);
      case 370: /* star_func ::= LAST */ yytestcase(yyruleno==370);
      case 371: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==371);
{ yylhsminor.yy361 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy361 = yylhsminor.yy361;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy151, &yymsp[-1].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy151 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 255: /* analyze_opt ::= */ yytestcase(yyruleno==255);
      case 262: /* agg_func_opt ::= */ yytestcase(yyruleno==262);
      case 425: /* set_quantifier_opt ::= */ yytestcase(yyruleno==425);
{ yymsp[1].minor.yy151 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy151 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy616 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_KEEP, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 85: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 86: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 87: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_RETENTIONS, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 92: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 93: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 94: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-3].minor.yy616, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-3].minor.yy616, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 98: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 99: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 100: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy616 = createAlterDatabaseOptions(pCxt); yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yylhsminor.yy616, &yymsp[0].minor.yy409); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 101: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy616, &yymsp[0].minor.yy409); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 102: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy409.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* alter_db_option ::= KEEP integer_list */
      case 106: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==106);
{ yymsp[-1].minor.yy409.type = DB_OPTION_KEEP; yymsp[-1].minor.yy409.pList = yymsp[0].minor.yy356; }
        break;
      case 107: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_WAL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy356 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 109: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 284: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==284);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 110: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy356 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 111: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 112: /* retention_list ::= retention */
      case 132: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==132);
      case 135: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==135);
      case 142: /* column_def_list ::= column_def */ yytestcase(yyruleno==142);
      case 185: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==185);
      case 190: /* col_name_list ::= col_name */ yytestcase(yyruleno==190);
      case 238: /* func_list ::= func */ yytestcase(yyruleno==238);
      case 312: /* literal_list ::= signed_literal */ yytestcase(yyruleno==312);
      case 374: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==374);
      case 428: /* select_list ::= select_item */ yytestcase(yyruleno==428);
      case 482: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==482);
{ yylhsminor.yy356 = createNodeList(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 113: /* retention_list ::= retention_list NK_COMMA retention */
      case 143: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==143);
      case 186: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==186);
      case 191: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==191);
      case 239: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==239);
      case 313: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==313);
      case 375: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==375);
      case 429: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==429);
      case 483: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==483);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 114: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy616 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 115: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 117: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==117);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy151, yymsp[-5].minor.yy616, yymsp[-3].minor.yy356, yymsp[-1].minor.yy356, yymsp[0].minor.yy616); }
        break;
      case 116: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy356); }
        break;
      case 118: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy356); }
        break;
      case 119: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy616); }
        break;
      case 120: /* cmd ::= ALTER TABLE alter_table_clause */
      case 286: /* cmd ::= query_expression */ yytestcase(yyruleno==286);
{ pCxt->pRootNode = yymsp[0].minor.yy616; }
        break;
      case 121: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy616); }
        break;
      case 122: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy616 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 123: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 124: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 125: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 126: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 127: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 128: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 129: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 130: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 131: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy616 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy616, &yymsp[-2].minor.yy361, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 133: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 136: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==136);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-1].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy356 = yylhsminor.yy356;
        break;
      case 134: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy616 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy151, yymsp[-8].minor.yy616, yymsp[-6].minor.yy616, yymsp[-5].minor.yy356, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-9].minor.yy616 = yylhsminor.yy616;
        break;
      case 137: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy616 = createDropTableClause(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 138: /* specific_cols_opt ::= */
      case 169: /* tags_def_opt ::= */ yytestcase(yyruleno==169);
      case 437: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==437);
      case 454: /* group_by_clause_opt ::= */ yytestcase(yyruleno==454);
      case 470: /* order_by_clause_opt ::= */ yytestcase(yyruleno==470);
{ yymsp[1].minor.yy356 = NULL; }
        break;
      case 139: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy356 = yymsp[-1].minor.yy356; }
        break;
      case 140: /* full_table_name ::= table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy361, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 141: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 144: /* column_def ::= column_name type_name */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600, NULL); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 145: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 146: /* type_name ::= BOOL */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 147: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 148: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 149: /* type_name ::= INT */
      case 150: /* type_name ::= INTEGER */ yytestcase(yyruleno==150);
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 151: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 152: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 153: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 154: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 155: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 156: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 158: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 159: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 160: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 161: /* type_name ::= JSON */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 162: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 163: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 164: /* type_name ::= BLOB */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 165: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 167: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 168: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 170: /* tags_def_opt ::= tags_def */
      case 373: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==373);
{ yylhsminor.yy356 = yymsp[0].minor.yy356; }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 171: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy356 = yymsp[-1].minor.yy356; }
        break;
      case 172: /* table_options ::= */
{ yymsp[1].minor.yy616 = createDefaultTableOptions(pCxt); }
        break;
      case 173: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 174: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 175: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 176: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy356); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 177: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 178: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_SMA, yymsp[-1].minor.yy356); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 179: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy616 = createAlterTableOptions(pCxt); yylhsminor.yy616 = setTableOption(pCxt, yylhsminor.yy616, yymsp[0].minor.yy409.type, &yymsp[0].minor.yy409.val); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 180: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy409.type, &yymsp[0].minor.yy409.val); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 181: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy409.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 182: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy409.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 183: /* duration_list ::= duration_literal */
      case 340: /* expression_list ::= expression */ yytestcase(yyruleno==340);
{ yylhsminor.yy356 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 184: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 341: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==341);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 187: /* rollup_func_name ::= function_name */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy361, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 188: /* rollup_func_name ::= FIRST */
      case 189: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==189);
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 192: /* col_name ::= column_name */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy361); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 193: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 195: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 196: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 197: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 198: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy616, NULL, OP_TYPE_LIKE); }
        break;
      case 199: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 200: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 201: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 202: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy616, yymsp[-1].minor.yy616, OP_TYPE_EQUAL); }
        break;
      case 204: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 205: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 206: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 207: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW LICENCE */
      case 209: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==209);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 210: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 211: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 212: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 213: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 215: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 216: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 217: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 218: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 219: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 220: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 221: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 222: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 224: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy616, yymsp[-1].minor.yy616, OP_TYPE_EQUAL); }
        break;
      case 227: /* db_name_cond_opt ::= */
      case 232: /* from_db_opt ::= */ yytestcase(yyruleno==232);
{ yymsp[1].minor.yy616 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 228: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 229: /* like_pattern_opt ::= */
      case 268: /* into_opt ::= */ yytestcase(yyruleno==268);
      case 406: /* from_clause_opt ::= */ yytestcase(yyruleno==406);
      case 435: /* where_clause_opt ::= */ yytestcase(yyruleno==435);
      case 439: /* twindow_clause_opt ::= */ yytestcase(yyruleno==439);
      case 444: /* sliding_opt ::= */ yytestcase(yyruleno==444);
      case 446: /* fill_opt ::= */ yytestcase(yyruleno==446);
      case 458: /* having_clause_opt ::= */ yytestcase(yyruleno==458);
      case 460: /* range_opt ::= */ yytestcase(yyruleno==460);
      case 462: /* every_opt ::= */ yytestcase(yyruleno==462);
      case 472: /* slimit_clause_opt ::= */ yytestcase(yyruleno==472);
      case 476: /* limit_clause_opt ::= */ yytestcase(yyruleno==476);
{ yymsp[1].minor.yy616 = NULL; }
        break;
      case 230: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 231: /* table_name_cond ::= table_name */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy361); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 233: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy361); }
        break;
      case 234: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy151, yymsp[-3].minor.yy616, yymsp[-1].minor.yy616, NULL, yymsp[0].minor.yy616); }
        break;
      case 235: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy616); }
        break;
      case 236: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy616 = createIndexOption(pCxt, yymsp[-7].minor.yy356, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 237: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy616 = createIndexOption(pCxt, yymsp[-9].minor.yy356, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 240: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-1].minor.yy356); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 241: /* sma_stream_opt ::= */
      case 270: /* stream_options ::= */ yytestcase(yyruleno==270);
{ yymsp[1].minor.yy616 = createStreamOptions(pCxt); }
        break;
      case 242: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 274: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==274);
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 243: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 245: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, &yymsp[0].minor.yy361, false); }
        break;
      case 246: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy151, &yymsp[-5].minor.yy361, &yymsp[0].minor.yy361, true); }
        break;
      case 247: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, yymsp[0].minor.yy616, false); }
        break;
      case 248: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy151, &yymsp[-5].minor.yy361, yymsp[0].minor.yy616, true); }
        break;
      case 249: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 250: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 251: /* cmd ::= DESC full_table_name */
      case 252: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==252);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 253: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 254: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy151, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 256: /* analyze_opt ::= ANALYZE */
      case 263: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==263);
      case 426: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==426);
{ yymsp[0].minor.yy151 = true; }
        break;
      case 257: /* explain_options ::= */
{ yymsp[1].minor.yy616 = createDefaultExplainOptions(pCxt); }
        break;
      case 258: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy616 = setExplainVerbose(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 259: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy616 = setExplainRatio(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 260: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy151, yymsp[-8].minor.yy151, &yymsp[-5].minor.yy361, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy600, yymsp[0].minor.yy734); }
        break;
      case 261: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 264: /* bufsize_opt ::= */
{ yymsp[1].minor.yy734 = 0; }
        break;
      case 265: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy734 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 266: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy151, &yymsp[-4].minor.yy361, yymsp[-2].minor.yy616, yymsp[-3].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 267: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 269: /* into_opt ::= INTO full_table_name */
      case 407: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==407);
      case 436: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==436);
      case 459: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==459);
{ yymsp[-1].minor.yy616 = yymsp[0].minor.yy616; }
        break;
      case 271: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 272: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 273: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy616)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-3].minor.yy616; }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 275: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->ignoreExpired = true; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 276: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 277: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 278: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 279: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 280: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 281: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy356); }
        break;
      case 282: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 283: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy356 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 285: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 287: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy616, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
        break;
      case 288: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy616, NULL, yymsp[0].minor.yy616); }
        break;
      case 289: /* literal ::= NK_INTEGER */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 290: /* literal ::= NK_FLOAT */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 291: /* literal ::= NK_STRING */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 292: /* literal ::= NK_BOOL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 293: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 294: /* literal ::= duration_literal */
      case 304: /* signed_literal ::= signed */ yytestcase(yyruleno==304);
      case 324: /* expression ::= literal */ yytestcase(yyruleno==324);
      case 325: /* expression ::= pseudo_column */ yytestcase(yyruleno==325);
      case 326: /* expression ::= column_reference */ yytestcase(yyruleno==326);
      case 327: /* expression ::= function_expression */ yytestcase(yyruleno==327);
      case 328: /* expression ::= subquery */ yytestcase(yyruleno==328);
      case 356: /* function_expression ::= literal_func */ yytestcase(yyruleno==356);
      case 398: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==398);
      case 402: /* boolean_primary ::= predicate */ yytestcase(yyruleno==402);
      case 404: /* common_expression ::= expression */ yytestcase(yyruleno==404);
      case 405: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==405);
      case 408: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==408);
      case 410: /* table_reference ::= table_primary */ yytestcase(yyruleno==410);
      case 411: /* table_reference ::= joined_table */ yytestcase(yyruleno==411);
      case 415: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==415);
      case 465: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==465);
      case 468: /* query_primary ::= query_specification */ yytestcase(yyruleno==468);
{ yylhsminor.yy616 = yymsp[0].minor.yy616; }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 295: /* literal ::= NULL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 296: /* literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 297: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 298: /* signed ::= NK_INTEGER */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 299: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 300: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 301: /* signed ::= NK_FLOAT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 302: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 303: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 305: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 306: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 307: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 308: /* signed_literal ::= duration_literal */
      case 310: /* signed_literal ::= literal_func */ yytestcase(yyruleno==310);
      case 376: /* star_func_para ::= expression */ yytestcase(yyruleno==376);
      case 431: /* select_item ::= common_expression */ yytestcase(yyruleno==431);
      case 481: /* search_condition ::= common_expression */ yytestcase(yyruleno==481);
{ yylhsminor.yy616 = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 309: /* signed_literal ::= NULL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 311: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 329: /* expression ::= NK_LP expression NK_RP */
      case 403: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==403);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 330: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy616));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 331: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 332: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 333: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 334: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 335: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 336: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 337: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 338: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 339: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 342: /* column_reference ::= column_name */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy361, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy361)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 343: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361, createColumnNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 344: /* pseudo_column ::= ROWTS */
      case 345: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==345);
      case 347: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==347);
      case 348: /* pseudo_column ::= QEND */ yytestcase(yyruleno==348);
      case 349: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==349);
      case 350: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==350);
      case 351: /* pseudo_column ::= WEND */ yytestcase(yyruleno==351);
      case 352: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==352);
      case 358: /* literal_func ::= NOW */ yytestcase(yyruleno==358);
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 346: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy361)))); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 353: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 354: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==354);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-1].minor.yy356)); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 355: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy600)); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 357: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy361, NULL)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 372: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy356 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 377: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 434: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==434);
{ yylhsminor.yy616 = createColumnNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 378: /* predicate ::= expression compare_op expression */
      case 383: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==383);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy526, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 379: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 380: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 381: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), NULL));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 382: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL));
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 384: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy526 = OP_TYPE_LOWER_THAN; }
        break;
      case 385: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy526 = OP_TYPE_GREATER_THAN; }
        break;
      case 386: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy526 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 387: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy526 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 388: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy526 = OP_TYPE_NOT_EQUAL; }
        break;
      case 389: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy526 = OP_TYPE_EQUAL; }
        break;
      case 390: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy526 = OP_TYPE_LIKE; }
        break;
      case 391: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy526 = OP_TYPE_NOT_LIKE; }
        break;
      case 392: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy526 = OP_TYPE_MATCH; }
        break;
      case 393: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy526 = OP_TYPE_NMATCH; }
        break;
      case 394: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy526 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 395: /* in_op ::= IN */
{ yymsp[0].minor.yy526 = OP_TYPE_IN; }
        break;
      case 396: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy526 = OP_TYPE_NOT_IN; }
        break;
      case 397: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy356)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 399: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 400: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 401: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 409: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 412: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 413: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 414: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy616 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 416: /* alias_opt ::= */
{ yymsp[1].minor.yy361 = nil_token;  }
        break;
      case 417: /* alias_opt ::= table_alias */
{ yylhsminor.yy361 = yymsp[0].minor.yy361; }
  yymsp[0].minor.yy361 = yylhsminor.yy361;
        break;
      case 418: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy361 = yymsp[0].minor.yy361; }
        break;
      case 419: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 420: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==420);
{ yymsp[-2].minor.yy616 = yymsp[-1].minor.yy616; }
        break;
      case 421: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, yymsp[-4].minor.yy504, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 422: /* join_type ::= */
{ yymsp[1].minor.yy504 = JOIN_TYPE_INNER; }
        break;
      case 423: /* join_type ::= INNER */
{ yymsp[0].minor.yy504 = JOIN_TYPE_INNER; }
        break;
      case 424: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy616 = createSelectStmt(pCxt, yymsp[-10].minor.yy151, yymsp[-9].minor.yy356, yymsp[-8].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addWhereClause(pCxt, yymsp[-11].minor.yy616, yymsp[-7].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addPartitionByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-6].minor.yy356);
                                                                                    yymsp[-11].minor.yy616 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy616, yymsp[-2].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addGroupByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-1].minor.yy356);
                                                                                    yymsp[-11].minor.yy616 = addHavingClause(pCxt, yymsp[-11].minor.yy616, yymsp[0].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addRangeClause(pCxt, yymsp[-11].minor.yy616, yymsp[-5].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addEveryClause(pCxt, yymsp[-11].minor.yy616, yymsp[-4].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addFillClause(pCxt, yymsp[-11].minor.yy616, yymsp[-3].minor.yy616);
                                                                                  }
        break;
      case 427: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy151 = false; }
        break;
      case 430: /* select_item ::= NK_STAR */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 432: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 433: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 438: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 455: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==455);
      case 471: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==471);
{ yymsp[-2].minor.yy356 = yymsp[0].minor.yy356; }
        break;
      case 440: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy616 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 441: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy616 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 442: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 443: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 445: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 463: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==463);
{ yymsp[-3].minor.yy616 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy616); }
        break;
      case 447: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy616 = createFillNode(pCxt, yymsp[-1].minor.yy494, NULL); }
        break;
      case 448: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy616 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy356)); }
        break;
      case 449: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy494 = FILL_MODE_NONE; }
        break;
      case 450: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy494 = FILL_MODE_PREV; }
        break;
      case 451: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy494 = FILL_MODE_NULL; }
        break;
      case 452: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy494 = FILL_MODE_LINEAR; }
        break;
      case 453: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy494 = FILL_MODE_NEXT; }
        break;
      case 456: /* group_by_list ::= expression */
{ yylhsminor.yy356 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 457: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 461: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy616 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 464: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy616 = addOrderByClause(pCxt, yymsp[-3].minor.yy616, yymsp[-2].minor.yy356);
                                                                                    yylhsminor.yy616 = addSlimitClause(pCxt, yylhsminor.yy616, yymsp[-1].minor.yy616);
                                                                                    yylhsminor.yy616 = addLimitClause(pCxt, yylhsminor.yy616, yymsp[0].minor.yy616);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 466: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 467: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 469: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy616 = addOrderByClause(pCxt, yymsp[-4].minor.yy616, yymsp[-3].minor.yy356);
                                                                                    yymsp[-5].minor.yy616 = addSlimitClause(pCxt, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616);
                                                                                    yymsp[-5].minor.yy616 = addLimitClause(pCxt, yymsp[-5].minor.yy616, yymsp[-1].minor.yy616);
                                                                                  }
        break;
      case 473: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 477: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==477);
{ yymsp[-1].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 474: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 478: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==478);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 475: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 479: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==479);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 480: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 484: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy616 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), yymsp[-1].minor.yy58, yymsp[0].minor.yy613); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 485: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy58 = ORDER_ASC; }
        break;
      case 486: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy58 = ORDER_ASC; }
        break;
      case 487: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy58 = ORDER_DESC; }
        break;
      case 488: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy613 = NULL_ORDER_DEFAULT; }
        break;
      case 489: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy613 = NULL_ORDER_FIRST; }
        break;
      case 490: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy613 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
