/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 467
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy22;
  ENullOrder yy23;
  SNode* yy44;
  int64_t yy91;
  SAlterOption yy153;
  bool yy163;
  int8_t yy169;
  SDataType yy260;
  SToken yy455;
  EOrder yy490;
  SNodeList* yy684;
  EOperatorType yy704;
  EJoinType yy724;
  int32_t yy832;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             737
#define YYNRULE              559
#define YYNTOKEN             326
#define YY_MAX_SHIFT         736
#define YY_MIN_SHIFTREDUCE   1092
#define YY_MAX_SHIFTREDUCE   1650
#define YY_ERROR_ACTION      1651
#define YY_ACCEPT_ACTION     1652
#define YY_NO_ACTION         1653
#define YY_MIN_REDUCE        1654
#define YY_MAX_REDUCE        2212
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2799)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   165,  378, 1666,  601,  477,  626,  478, 1690,  141,  160,
 /*    10 */    64, 2085,   45,   43, 1580, 1797,  355,   31, 1810,  131,
 /*    20 */   375, 1799, 1429,   38,   37, 1859,  516,   44,   42,   41,
 /*    30 */    40,   39, 2008, 1510,  139, 1427, 1808, 2026, 1144,  625,
 /*    40 */  1143, 2012,   38,   37,  607, 1454,   44,   42,   41,   40,
 /*    50 */    39,  626, 2008,  219, 2129,   38,   37,  175, 1505,   44,
 /*    60 */    42,   41,   40,   39,   18,  186, 2004, 2010, 2044, 1145,
 /*    70 */   380, 1435, 1652, 1854, 1856,  601,  640,  636,  345, 1910,
 /*    80 */  2126, 1994, 1808,  642,   45,   43, 2004, 2010,  357,  565,
 /*    90 */   625,  268,  375, 2183, 1429, 1927,   14,  636,  338,  180,
 /*   100 */  2122, 2123,   60,  137, 2127, 1510,  139, 1427, 2189,  181,
 /*   110 */  1925,  613, 2025, 2184,  590,   48, 2061,  495,  733,  322,
 /*   120 */  2027,  646, 2029, 2030,  641,  639,  636,  627, 2079,   60,
 /*   130 */  1505,   91, 2187, 1512, 1513, 1454,   18,  476,  388, 1539,
 /*   140 */   481, 1696,  387, 1435, 1617, 1252,  668,  667,  666, 1256,
 /*   150 */   665, 1258, 1259,  664, 1261,  661,  175, 1267,  658, 1269,
 /*   160 */  1270,  655,  652, 1485, 1495, 1927,   48, 1454,   14, 1511,
 /*   170 */  1514,  265, 2122,  600,   85,  132,  599,  366, 1911, 2183,
 /*   180 */  1924,  613,  680,  565, 1430, 2044, 1428, 2183,  135,  486,
 /*   190 */   733,  478, 1690,  583,  588,  181, 1540, 1803,   60, 2184,
 /*   200 */   590, 1212, 2189,  181,   49, 1512, 1513, 2184,  590, 1433,
 /*   210 */  1434,   60, 1484, 1487, 1488, 1489, 1490, 1491, 1492, 1493,
 /*   220 */  1494,  638,  634, 1503, 1504, 1506, 1507, 1508, 1509,    2,
 /*   230 */    44,   42,   41,   40,   39, 1485, 1495, 1214,  582,  554,
 /*   240 */   121, 1511, 1514,  120,  119,  118,  117,  116,  115,  114,
 /*   250 */   113,  112, 1144,  184, 1143,  234, 1430,  625, 1428,   38,
 /*   260 */    37, 1455,  420,   44,   42,   41,   40,   39,   34,  373,
 /*   270 */  1534, 1535, 1536, 1537, 1538, 1542, 1543, 1544, 1545,  612,
 /*   280 */   184, 1433, 1434, 1145, 1484, 1487, 1488, 1489, 1490, 1491,
 /*   290 */  1492, 1493, 1494,  638,  634, 1503, 1504, 1506, 1507, 1508,
 /*   300 */  1509,    2,  328,   11,   45,   43,  736,  601,  220, 1786,
 /*   310 */  1350, 1351,  375,  235, 1429,  407, 1607,  184,   88,  333,
 /*   320 */   293,  611,  549,  170,  547, 1510,  493, 1427, 1920,  512,
 /*   330 */   508,  504,  500,  217,  612,  174,  409,  405,  139, 1785,
 /*   340 */   483,  726,  722,  718,  714,  291,  479,  414,  584,  184,
 /*   350 */  1505,  413, 1125,   38,   37,  184,   18,   44,   42,   41,
 /*   360 */    40,   39,  184, 1435, 1987,  576, 1605, 1606, 1608, 1609,
 /*   370 */    86, 1891,  495,  215, 1295, 1296,   45,   43, 1515, 1405,
 /*   380 */  1406,  610,  106, 1920,  375,  284, 1429,  672,   14,   27,
 /*   390 */  1852, 1127,  565, 1130, 1131,  592, 2183, 1510, 2129, 1427,
 /*   400 */   626,  626,  603,  179, 2122, 2123, 2026,  137, 2127,  565,
 /*   410 */   733, 2189,  181, 2183,  131,   54, 2184,  590,  622, 2188,
 /*   420 */  1861,  521, 1505, 2183, 2125, 1512, 1513, 1647, 2189,  181,
 /*   430 */  1677, 1808, 1808, 2184,  590, 1435, 1860, 2044, 1783, 2187,
 /*   440 */   579,  214,  208, 2184, 2186,  643,  213,  678, 1584,  491,
 /*   450 */  1994, 1174,  642,  271, 1454, 1485, 1495, 1861,  270, 2188,
 /*   460 */    46, 1511, 1514, 2183,  354,  206,  153,  152,  675,  674,
 /*   470 */   673,  150,  626, 1859, 1994, 1394, 1430,  239, 1428, 2187,
 /*   480 */  1453, 2025,  733, 2184, 2185, 2061,  418, 1175,  167, 2027,
 /*   490 */   646, 2029, 2030,  641,  151,  636,  485, 1512, 1513,  481,
 /*   500 */  1696, 1433, 1434, 1808, 1484, 1487, 1488, 1489, 1490, 1491,
 /*   510 */  1492, 1493, 1494,  638,  634, 1503, 1504, 1506, 1507, 1508,
 /*   520 */  1509,    2, 1646,  438,  585,  580,  574, 1485, 1495,  566,
 /*   530 */  2151, 1655,  437, 1511, 1514,   35,  286,   38,   37,   11,
 /*   540 */   626,   44,   42,   41,   40,   39,  678,   53, 1430, 1457,
 /*   550 */  1428,  177,  121, 1723,  419,  120,  119,  118,  117,  116,
 /*   560 */   115,  114,  113,  112, 1848,  153,  152,  675,  674,  673,
 /*   570 */   150, 1808, 2026, 1433, 1434, 1456, 1484, 1487, 1488, 1489,
 /*   580 */  1490, 1491, 1492, 1493, 1494,  638,  634, 1503, 1504, 1506,
 /*   590 */  1507, 1508, 1509,    2,   45,   43,  193, 1486,  626,   85,
 /*   600 */  1988, 1435,  375, 2044, 1429,  692,  589, 1861,  166,  671,
 /*   610 */  2183,  643,  428, 1762,  363, 1510, 1994, 1427,  642,  531,
 /*   620 */   530,  529, 1804, 1859, 2188,  588,  181,  136,  525, 1808,
 /*   630 */  2184,  590,  524,   82, 2129, 2012,   81,  523,  528, 2013,
 /*   640 */  1505, 1456, 1676,  522, 2026,  565, 2008, 2025,  626, 2183,
 /*   650 */  2008, 2061, 1906, 1435,  109, 2027,  646, 2029, 2030,  641,
 /*   660 */  2124,  636,  443,  189, 2189,  181,   45,   43, 2114, 2184,
 /*   670 */   590,   99, 2113, 2110,  375, 2044, 1429, 1654,   46, 1808,
 /*   680 */  2004, 2010,  370,  643, 2004, 2010, 1994, 1510, 1994, 1427,
 /*   690 */   642,  636,  612, 1801,  245,  636,   41,   40,   39,  105,
 /*   700 */   733,  130,  129,  128,  127,  126,  125,  124,  123,  122,
 /*   710 */    52, 1541, 1505,  140, 1784, 1512, 1513,  564, 1640, 2025,
 /*   720 */   267, 1800,  104, 2061,  626, 1435,  168, 2027,  646, 2029,
 /*   730 */  2030,  641,  101,  636,  545,  531,  530,  529,  444,  621,
 /*   740 */  1793, 1920,  626,  136,  525, 1485, 1495,  543,  524,  541,
 /*   750 */    14, 1511, 1514,  523,  528, 1808,  494,   38,   37,  522,
 /*   760 */  1861,   44,   42,   41,   40,   39, 1430,  343, 1428,   13,
 /*   770 */    12, 1906,  733, 1808, 1861, 1675, 1859,  680,  591, 2204,
 /*   780 */   163,  368,  191,   32, 1455, 1674,  267, 1512, 1513, 1811,
 /*   790 */  1859, 1433, 1434, 1546, 1484, 1487, 1488, 1489, 1490, 1491,
 /*   800 */  1492, 1493, 1494,  638,  634, 1503, 1504, 1506, 1507, 1508,
 /*   810 */  1509,    2, 1795,  331, 1673, 1452, 1672, 1485, 1495, 1994,
 /*   820 */    33,  626,  451, 1511, 1514,  465,   38,   37,  464, 1994,
 /*   830 */    44,   42,   41,   40,   39, 1805, 1577,  589, 1430, 1720,
 /*   840 */  1428, 2183,  367,  434, 1791,  466, 1596, 1520,  436,   11,
 /*   850 */   163,    9, 1808, 1454, 1964, 1671,  588,  181, 1994, 1810,
 /*   860 */  1994, 2184,  590, 1433, 1434, 1553, 1484, 1487, 1488, 1489,
 /*   870 */  1490, 1491, 1492, 1493, 1494,  638,  634, 1503, 1504, 1506,
 /*   880 */  1507, 1508, 1509,    2,  277,  278,  670,   38,   37,  276,
 /*   890 */   346,   44,   42,   41,   40,   39,  240, 1367, 1368, 1994,
 /*   900 */   236,  349,  424,  527,  526,  710,  709,  708,  707,  385,
 /*   910 */   560,  706,  705,  143,  700,  699,  698,  697,  696,  695,
 /*   920 */   694,  155,  690,  689,  688,  384,  383,  685,  684,  683,
 /*   930 */   682,  681,  462, 1366, 1369,  456,  455,  454,  453,  450,
 /*   940 */   449,  448,  447,  446,  442,  441,  440,  439,  330,  431,
 /*   950 */   430,  429, 1457,  426,  425,  344,  164,  676,  552,  626,
 /*   960 */  1852,  306, 1670,  350, 1429,  348,  347, 1861,  518,  628,
 /*   970 */  2026, 2086,  520,  237,  379,  304,   71, 1427,  593,   70,
 /*   980 */  1669,   38,   37, 1859,    8,   44,   42,   41,   40,   39,
 /*   990 */  1808, 1855, 1856, 1667,  519, 1668, 1486,  202,  473,  471,
 /*  1000 */   468, 2044,  677,  565, 2026, 1852, 1994, 2183,  637,  604,
 /*  1010 */   601,  704,  702, 1435, 1994,  626,  642,  300, 1665, 1664,
 /*  1020 */  1838, 1663, 2189,  181, 1994, 1662, 1906, 2184,  590,  561,
 /*  1030 */  1661, 1660, 1763, 1659,   60, 2044,  458,  195, 1658, 1994,
 /*  1040 */  1454,  139,   60,  643,  162, 2025, 1808,  626, 1994, 2061,
 /*  1050 */   642, 1457,  108, 2027,  646, 2029, 2030,  641, 1657,  636,
 /*  1060 */   733,  605, 1994, 1994,  178, 1994, 2114,  596,  378, 1994,
 /*  1070 */   369, 2110,   72,  107, 1994, 1994,  163, 1994, 1808, 2025,
 /*  1080 */  1576, 2026, 1994, 2061,  183, 1810,  108, 2027,  646, 2029,
 /*  1090 */  2030,  641, 2140,  636,  197,  196,  142,  190,  148, 2085,
 /*  1100 */  2114,  630, 1994, 2086,  369, 2110,  182, 2122, 2123, 2154,
 /*  1110 */   137, 2127, 2044,  262,   79,   78,  417,  457,  151,  188,
 /*  1120 */   604,  693,   80, 1778,  626, 1994, 1430,  642, 1428,  412,
 /*  1130 */  2026,  411, 1130, 1131,   51,  520,    3,  329,  609, 1980,
 /*  1140 */   403, 1438,  401,  397,  393,  390,  410,  577,  626, 2134,
 /*  1150 */  1573, 1433, 1434, 2026,  410, 1808, 2025,  519,  626,  626,
 /*  1160 */  2061, 2044,  281,  108, 2027,  646, 2029, 2030,  641,  643,
 /*  1170 */   636, 1400,  623,  624, 1994,  178,  642, 2114,  381, 1808,
 /*  1180 */   626,  369, 2110, 1486, 2044,  184,  163,  395,  421, 1808,
 /*  1190 */  1808, 1573,  643,  184,  287, 1810,  244, 1994,  145,  642,
 /*  1200 */   133,  422,  594, 2141,  225, 2025,  218,  223,  151, 2061,
 /*  1210 */  2015, 1808,  108, 2027,  646, 2029, 2030,  641,  227,  636,
 /*  1220 */   229,  226,  231,  228, 2203,  230, 2114,   62, 2025,  633,
 /*  1230 */   369, 2110, 2061, 1710, 1703,  108, 2027,  646, 2029, 2030,
 /*  1240 */   641, 2148,  636, 2026,  626, 1701,  243, 2203, 1437, 2114,
 /*  1250 */   372,  371,  256,  369, 2110,  532,  534, 2045,  382, 2017,
 /*  1260 */  1443, 1403,  249,  151, 2161, 1697, 2026,  537, 1649, 1650,
 /*  1270 */    47, 1510,  386, 1436, 2044, 1808,   13,   12, 1915,  678,
 /*  1280 */  1604, 1849,  643,  274, 1691,   69,   89, 1994, 2144,  642,
 /*  1290 */   602,  686, 1441,  597,  149,  264, 1505, 2044,  153,  152,
 /*  1300 */   675,  674,  673,  150,   47,  643,  151,  261,    1, 1435,
 /*  1310 */  1994,   62,  642, 1193,  728,  251,  608,    4, 2025,  389,
 /*  1320 */   394,  342, 2061, 1364,  687,  108, 2027,  646, 2029, 2030,
 /*  1330 */   641,   47,  636, 1387, 2026,  294,  279, 2203,  618, 2114,
 /*  1340 */   423, 2025,  650,  369, 2110, 2061, 1191,  283,  108, 2027,
 /*  1350 */   646, 2029, 2030,  641,  572,  636,  632,  299,  194, 1245,
 /*  1360 */  2203,  536, 2114, 1457, 1547, 2044,  369, 2110, 1916,  427,
 /*  1370 */   460,  432, 1452,  643, 1531,  445,  546, 2177, 1994,  149,
 /*  1380 */   642, 1908,  452,  151, 1496,  459,  461,  467,  134,  149,
 /*  1390 */   233,  469,  470,  199, 2026, 1273,  472,  474, 1458, 1440,
 /*  1400 */   475,  484, 1460,  487,  205,  539, 1455,  488, 1459, 2025,
 /*  1410 */   533,  489, 1461, 2061,  207,  232,  108, 2027,  646, 2029,
 /*  1420 */  2030,  641, 1444,  636, 1439, 2044,  490,  210, 2203,  492,
 /*  1430 */  2114,  212, 1277,  643,  369, 2110, 1284,   83, 1994,   84,
 /*  1440 */   642, 1282,  154,  216,  496, 2133, 1147, 1447, 1449,  513,
 /*  1450 */   514, 1970,   68,  517,  515,   67,  111, 1798,  222, 1794,
 /*  1460 */   634, 1503, 1504, 1506, 1507, 1508, 1509, 2026,  224, 2025,
 /*  1470 */   553,  156,  157, 2061, 1796, 1792,  108, 2027,  646, 2029,
 /*  1480 */  2030,  641,  551,  636,  158,  159,  332,   87, 2089, 1969,
 /*  1490 */  2114, 2026,  555,  238,  369, 2110,  147,  562, 2044,  241,
 /*  1500 */   295,  556,  559,  569, 2145,  578,  643,  616, 2136, 2155,
 /*  1510 */  2160, 1994,    7,  642,  575,  358,  247,  250,  581, 2159,
 /*  1520 */   570,  587, 2044,  171,  255,  257,  258,  568,  359,  567,
 /*  1530 */   643,  595, 2206,  259, 1573, 1994,  263,  642,  260,  598,
 /*  1540 */  2182,  138, 2025, 1456, 2130,  362, 2061,  606, 1462,  108,
 /*  1550 */  2027,  646, 2029, 2030,  641,  269,  636,   94, 2026,  614,
 /*  1560 */  1921, 2087,  615, 2114,  296, 1935, 2025,  369, 2110, 1934,
 /*  1570 */  2061, 1933,  297,  108, 2027,  646, 2029, 2030,  641,  365,
 /*  1580 */   636, 2026,  619,   96,  620,  629,  298, 2114,   98, 2044,
 /*  1590 */  1809,  369, 2110,   59,  100, 2095,  648,  643, 1853,  290,
 /*  1600 */   729,  730, 1994, 1779,  642,  301,   50,  732,  310,  325,
 /*  1610 */   334,  324, 2044,  335, 1986,  314,  303,  305, 1985, 1984,
 /*  1620 */   643,   76, 1981,  391,  392, 1994, 1420,  642, 1421,  187,
 /*  1630 */   396, 1979,  398, 2025,  399,  400, 1978, 2061,  402, 1977,
 /*  1640 */   109, 2027,  646, 2029, 2030,  641,  404,  636, 2026, 1976,
 /*  1650 */   406, 1975,  408,   77, 2114, 1390,  644, 1389,  631, 2110,
 /*  1660 */  2061, 1947, 1946,  109, 2027,  646, 2029, 2030,  641, 1945,
 /*  1670 */   636, 2026,  415,  416, 1944, 1943, 1341, 2114, 1899, 2044,
 /*  1680 */  1898,  337, 2110, 1896,  144, 1895, 1894,  643, 1897, 1893,
 /*  1690 */  1892, 1890, 1994, 1889,  642, 1888,  192, 2026,  433, 1887,
 /*  1700 */   435, 1901, 2044, 1886, 1885, 1884, 1883, 1882, 1881, 1880,
 /*  1710 */   643, 1879, 1878, 1877, 1876, 1994, 1875,  642, 1874, 1873,
 /*  1720 */  1872,  146, 1871, 2025, 1870, 1869, 1900, 2061, 2044, 1868,
 /*  1730 */   109, 2027,  646, 2029, 2030,  641,  643,  636, 1867, 1343,
 /*  1740 */  1866, 1994, 1865,  642, 2114, 1864, 2025, 1863,  463, 2111,
 /*  1750 */  2061, 1862, 1726,  167, 2027,  646, 2029, 2030,  641, 1725,
 /*  1760 */   636, 1724, 1220, 2026, 1722, 1686, 1685,  176,  198, 1133,
 /*  1770 */   203,   74, 2025,  200, 1132,  204, 2061, 1960, 2014,  316,
 /*  1780 */  2027,  646, 2029, 2030,  641, 1954,  636,   75,  201, 1942,
 /*  1790 */  2026,  480,  209,  482, 2044, 2152,  211, 1941, 1919, 1787,
 /*  1800 */  1721, 1167,  643,  497,  498, 1717,  499, 1994, 1719,  642,
 /*  1810 */   501,  502,  503, 1715,  505,  507, 1713,  506,  509,  510,
 /*  1820 */  2026, 2044, 1700,  586, 1699,  511,  364, 1682, 1789,  643,
 /*  1830 */  1289, 1288, 1788, 1711, 1994,  701,  642, 1211, 2025,   61,
 /*  1840 */   221, 1210, 2061, 1704,  535,  168, 2027,  646, 2029, 2030,
 /*  1850 */   641, 2044,  636, 1209, 1208,  703, 1205, 1203, 1204,  640,
 /*  1860 */  1202,  351,  352, 1702, 1994, 2025,  642,  353, 1681, 2061,
 /*  1870 */   110,  538,  323, 2027,  646, 2029, 2030,  641, 1680,  636,
 /*  1880 */  1679, 2026,  540,  542,  544, 1412, 1410, 1959, 1409,   26,
 /*  1890 */   548, 1396,   65, 1953,  557, 2025, 1940, 2026, 2205, 2061,
 /*  1900 */  1938, 2188,  322, 2027,  646, 2029, 2030,  641,   55,  636,
 /*  1910 */    19, 2080, 2044,   28,  558, 2026,   16,  374,   58,  253,
 /*  1920 */   643,  573,  246,  356,  242, 1994,  161,  642, 2044,  254,
 /*  1930 */   571, 1619, 2015,  376,  248,  563,  643,   63, 1603, 1595,
 /*  1940 */   169, 1994,    5,  642,    6,  252, 2044,   30,   20,   21,
 /*  1950 */    29,   90, 1634,   17,  643, 1639, 2025, 1640, 1633, 1994,
 /*  1960 */  2061,  642,  360,  323, 2027,  646, 2029, 2030,  641,  266,
 /*  1970 */   636, 1638, 2025, 1637, 2026,  361, 2061,   57, 1570,  323,
 /*  1980 */  2027,  646, 2029, 2030,  641, 1569,  636, 1939,  172, 1937,
 /*  1990 */   550, 1936, 1918, 2026, 2061,   56,   93,  318, 2027,  646,
 /*  2000 */  2029, 2030,  641,   92,  636, 2044,  272,   22, 1917,  273,
 /*  2010 */  1601,  275,  280,  643,  617,   66,   95,   97, 1994,  285,
 /*  2020 */   642,   12,   23,  282, 2044, 1445,  101, 2064,  635, 1532,
 /*  2030 */   173, 1522,  643,  185, 1500,   36,   10, 1994,   15,  642,
 /*  2040 */  1521, 1498, 1497, 1469,   24, 1477,   25,  649, 1274, 2025,
 /*  2050 */   647,  377,  651, 2061, 1251, 1271,  307, 2027,  646, 2029,
 /*  2060 */  2030,  641, 2026,  636,  653,  654,  656, 1268, 2025,  657,
 /*  2070 */   645, 1262, 2061,  659,  662,  308, 2027,  646, 2029, 2030,
 /*  2080 */   641,  660,  636, 2026, 1266, 1260,  663, 1265, 1264,  669,
 /*  2090 */   102, 1263,  288, 2044,  103, 1283,   73, 1279, 1165,  679,
 /*  2100 */  1199,  643, 1198, 1197, 1196, 1195, 1994, 1194,  642, 1192,
 /*  2110 */   691, 2026, 1190, 1189, 2044, 1188, 1218,  289, 1186, 1183,
 /*  2120 */  1185, 1184,  643, 1182, 1181, 1180, 1215, 1994, 1213,  642,
 /*  2130 */  1177, 1176, 2026, 1173, 1172, 1171, 1170, 2025, 1718,  711,
 /*  2140 */   712, 2061, 2044, 1716,  309, 2027,  646, 2029, 2030,  641,
 /*  2150 */   643,  636,  715,  713,  716, 1994, 1714,  642, 2025,  717,
 /*  2160 */   719,  721, 2061, 2044,  720,  315, 2027,  646, 2029, 2030,
 /*  2170 */   641,  643,  636, 1712,  723,  724, 1994, 1698,  642,  725,
 /*  2180 */   727, 2026, 1122, 1678,  292,  731, 2025, 1431,  302,  734,
 /*  2190 */  2061,  735, 1653,  319, 2027,  646, 2029, 2030,  641, 2026,
 /*  2200 */   636, 1653, 1653, 1653, 1653, 1653, 1653, 2025, 1653, 1653,
 /*  2210 */  1653, 2061, 2044, 1653,  311, 2027,  646, 2029, 2030,  641,
 /*  2220 */   643,  636, 1653, 1653, 1653, 1994, 1653,  642, 1653, 1653,
 /*  2230 */  2044, 1653, 1653, 1653, 1653, 1653, 1653, 1653,  643, 1653,
 /*  2240 */  1653, 1653, 1653, 1994, 1653,  642, 1653, 1653, 1653, 1653,
 /*  2250 */  1653, 1653, 1653, 1653, 1653, 1653, 2025, 1653, 2026, 1653,
 /*  2260 */  2061, 1653, 1653,  320, 2027,  646, 2029, 2030,  641, 1653,
 /*  2270 */   636, 1653, 1653, 1653, 2025, 1653, 2026, 1653, 2061, 1653,
 /*  2280 */  1653,  312, 2027,  646, 2029, 2030,  641, 1653,  636, 2044,
 /*  2290 */  1653, 1653, 1653, 1653, 1653, 1653, 1653,  643, 1653, 1653,
 /*  2300 */  1653, 1653, 1994, 1653,  642, 1653, 1653, 2044, 1653, 1653,
 /*  2310 */  1653, 1653, 1653, 1653, 1653,  643, 1653, 1653, 1653, 1653,
 /*  2320 */  1994, 1653,  642, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
 /*  2330 */  1653, 1653, 1653, 2025, 1653, 2026, 1653, 2061, 1653, 1653,
 /*  2340 */   321, 2027,  646, 2029, 2030,  641, 1653,  636, 1653, 1653,
 /*  2350 */  1653, 2025, 1653, 1653, 2026, 2061, 1653, 1653,  313, 2027,
 /*  2360 */   646, 2029, 2030,  641, 1653,  636, 2044, 1653, 1653, 1653,
 /*  2370 */  1653, 1653, 1653, 1653,  643, 1653, 1653, 1653, 1653, 1994,
 /*  2380 */  1653,  642, 1653, 1653, 1653, 2044, 1653, 1653, 1653, 1653,
 /*  2390 */  1653, 1653, 1653,  643, 1653, 1653, 1653, 1653, 1994, 1653,
 /*  2400 */   642, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
 /*  2410 */  2025, 1653, 1653, 2026, 2061, 1653, 1653,  326, 2027,  646,
 /*  2420 */  2029, 2030,  641, 1653,  636, 1653, 1653, 1653, 1653, 2025,
 /*  2430 */  1653, 2026, 1653, 2061, 1653, 1653,  327, 2027,  646, 2029,
 /*  2440 */  2030,  641, 1653,  636, 2044, 1653, 1653, 1653, 1653, 1653,
 /*  2450 */  1653, 1653,  643, 1653, 1653, 1653, 1653, 1994, 1653,  642,
 /*  2460 */  1653, 1653, 2044, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
 /*  2470 */   643, 1653, 1653, 1653, 1653, 1994, 1653,  642, 1653, 1653,
 /*  2480 */  2026, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 2025, 1653,
 /*  2490 */  1653, 1653, 2061, 1653, 1653, 2038, 2027,  646, 2029, 2030,
 /*  2500 */   641, 2026,  636, 1653, 1653, 1653, 2025, 1653, 1653, 1653,
 /*  2510 */  2061, 2044, 1653, 2037, 2027,  646, 2029, 2030,  641,  643,
 /*  2520 */   636, 1653, 1653, 1653, 1994, 1653,  642, 1653, 1653, 2026,
 /*  2530 */  1653, 1653, 2044, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
 /*  2540 */   643, 1653, 1653, 1653, 1653, 1994, 1653,  642, 1653, 1653,
 /*  2550 */  2026, 1653, 1653, 1653, 1653, 2025, 1653, 1653, 1653, 2061,
 /*  2560 */  2044, 1653, 2036, 2027,  646, 2029, 2030,  641,  643,  636,
 /*  2570 */  1653, 1653, 1653, 1994, 1653,  642, 2025, 1653, 1653, 1653,
 /*  2580 */  2061, 2044, 1653,  339, 2027,  646, 2029, 2030,  641,  643,
 /*  2590 */   636, 1653, 1653, 1653, 1994, 1653,  642, 1653, 1653, 1653,
 /*  2600 */  1653, 1653, 1653, 1653, 2025, 1653, 1653, 1653, 2061, 1653,
 /*  2610 */  1653,  340, 2027,  646, 2029, 2030,  641, 1653,  636, 2026,
 /*  2620 */  1653, 1653, 1653, 1653, 1653, 2025, 1653, 1653, 1653, 2061,
 /*  2630 */  1653, 1653,  336, 2027,  646, 2029, 2030,  641, 1653,  636,
 /*  2640 */  1653, 1653, 1653, 1653, 1653, 2026, 1653, 1653, 1653, 1653,
 /*  2650 */  2044, 1653, 1653, 1653, 1653, 1653, 1653, 1653,  643, 1653,
 /*  2660 */  1653, 1653, 1653, 1994, 1653,  642, 1653, 1653, 1653, 1653,
 /*  2670 */  1653, 1653, 1653, 1653, 1653, 1653, 2044, 1653, 1653, 1653,
 /*  2680 */  1653, 1653, 1653, 1653,  643, 1653, 1653, 1653, 1653, 1994,
 /*  2690 */  1653,  642, 1653, 1653, 2025, 1653, 1653, 1653, 2061, 1653,
 /*  2700 */  1653,  341, 2027,  646, 2029, 2030,  641, 1653,  636, 2026,
 /*  2710 */  1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
 /*  2720 */   644, 1653, 1653, 1653, 2061, 1653, 1653,  318, 2027,  646,
 /*  2730 */  2029, 2030,  641, 1653,  636, 1653, 1653, 1653, 1653, 1653,
 /*  2740 */  2044, 1653, 1653, 1653, 1653, 1653, 1653, 1653,  643, 1653,
 /*  2750 */  1653, 1653, 1653, 1994, 1653,  642, 1653, 1653, 1653, 1653,
 /*  2760 */  1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
 /*  2770 */  1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653, 1653,
 /*  2780 */  1653, 1653, 1653, 1653, 2025, 1653, 1653, 1653, 2061, 1653,
 /*  2790 */  1653,  317, 2027,  646, 2029, 2030,  641, 1653,  636,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   328,  352,  330,  337,  333,  337,  335,  336,  421,  360,
 /*    10 */     4,  424,   12,   13,   14,  361,  367,    2,  369,  351,
 /*    20 */    20,  362,   22,    8,    9,  376,  358,   12,   13,   14,
 /*    30 */    15,   16,  373,   33,  368,   35,  368,  329,   20,   20,
 /*    40 */    22,  362,    8,    9,  392,   20,   12,   13,   14,   15,
 /*    50 */    16,  337,  373,   35,  410,    8,    9,  360,   58,   12,
 /*    60 */    13,   14,   15,   16,   64,  351,  407,  408,  360,   51,
 /*    70 */   371,   71,  326,  374,  375,  337,  368,  418,  381,  382,
 /*    80 */   436,  373,  368,  375,   12,   13,  407,  408,  409,  437,
 /*    90 */    20,   58,   20,  441,   22,  375,   96,  418,   64,  433,
 /*   100 */   434,  435,   96,  437,  438,   33,  368,   35,  456,  457,
 /*   110 */   390,  391,  404,  461,  462,   96,  408,   63,  118,  411,
 /*   120 */   412,  413,  414,  415,  416,  417,  418,  419,  420,   96,
 /*   130 */    58,   98,    3,  133,  134,   20,   64,  334,  392,  105,
 /*   140 */   337,  338,  396,   71,   97,  109,  110,  111,  112,  113,
 /*   150 */   114,  115,  116,  117,  118,  119,  360,  121,  122,  123,
 /*   160 */   124,  125,  126,  163,  164,  375,   96,   20,   96,  169,
 /*   170 */   170,  433,  434,  435,  343,  437,  438,  387,  382,  441,
 /*   180 */   390,  391,   63,  437,  184,  360,  186,  441,  357,  333,
 /*   190 */   118,  335,  336,  368,  456,  457,  162,  366,   96,  461,
 /*   200 */   462,   35,  456,  457,   96,  133,  134,  461,  462,  209,
 /*   210 */   210,   96,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */    12,   13,   14,   15,   16,  163,  164,   71,  413,  107,
 /*   240 */    21,  169,  170,   24,   25,   26,   27,   28,   29,   30,
 /*   250 */    31,   32,   20,  247,   22,  128,  184,   20,  186,    8,
 /*   260 */     9,   20,  337,   12,   13,   14,   15,   16,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  244,  337,
 /*   280 */   247,  209,  210,   51,  212,  213,  214,  215,  216,  217,
 /*   290 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   300 */   228,  229,  377,  231,   12,   13,   19,  337,   33,    0,
 /*   310 */   163,  164,   20,  127,   22,  179,  209,  247,  191,  192,
 /*   320 */    33,   20,  195,   48,  197,   33,  384,   35,  386,   54,
 /*   330 */    55,   56,   57,   58,  337,   48,  200,  201,  368,    0,
 /*   340 */    14,   54,   55,   56,   57,   58,   20,  392,   20,  247,
 /*   350 */    58,  396,    4,    8,    9,  247,   64,   12,   13,   14,
 /*   360 */    15,   16,  247,   71,  392,  258,  259,  260,  261,  262,
 /*   370 */    95,    0,   63,   98,  133,  134,   12,   13,   14,  193,
 /*   380 */   194,  384,   95,  386,   20,   98,   22,  370,   96,   44,
 /*   390 */   373,   43,  437,   45,   46,  266,  441,   33,  410,   35,
 /*   400 */   337,  337,  432,  433,  434,  435,  329,  437,  438,  437,
 /*   410 */   118,  456,  457,  441,  351,  351,  461,  462,  131,  437,
 /*   420 */   360,  358,   58,  441,  436,  133,  134,  176,  456,  457,
 /*   430 */   329,  368,  368,  461,  462,   71,  376,  360,    0,  457,
 /*   440 */   168,  166,  167,  461,  462,  368,  171,  108,   14,  174,
 /*   450 */   373,   35,  375,  166,   20,  163,  164,  360,  171,  437,
 /*   460 */    96,  169,  170,  441,  367,  190,  127,  128,  129,  130,
 /*   470 */   131,  132,  337,  376,  373,  188,  184,  190,  186,  457,
 /*   480 */    20,  404,  118,  461,  462,  408,  351,   71,  411,  412,
 /*   490 */   413,  414,  415,  416,   44,  418,  334,  133,  134,  337,
 /*   500 */   338,  209,  210,  368,  212,  213,  214,  215,  216,  217,
 /*   510 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   520 */   228,  229,  271,  152,  252,  253,  254,  163,  164,  452,
 /*   530 */   453,    0,  161,  169,  170,  426,  427,    8,    9,  231,
 /*   540 */   337,   12,   13,   14,   15,   16,  108,   97,  184,   20,
 /*   550 */   186,  359,   21,    0,  351,   24,   25,   26,   27,   28,
 /*   560 */    29,   30,   31,   32,  372,  127,  128,  129,  130,  131,
 /*   570 */   132,  368,  329,  209,  210,   20,  212,  213,  214,  215,
 /*   580 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   590 */   226,  227,  228,  229,   12,   13,   58,  163,  337,  343,
 /*   600 */   392,   71,   20,  360,   22,   71,  437,  360,  344,  107,
 /*   610 */   441,  368,  351,  349,  367,   33,  373,   35,  375,   66,
 /*   620 */    67,   68,  366,  376,    3,  456,  457,   74,   75,  368,
 /*   630 */   461,  462,   79,   95,  410,  362,   98,   84,   85,  362,
 /*   640 */    58,   20,  329,   90,  329,  437,  373,  404,  337,  441,
 /*   650 */   373,  408,  368,   71,  411,  412,  413,  414,  415,  416,
 /*   660 */   436,  418,  351,  379,  456,  457,   12,   13,  425,  461,
 /*   670 */   462,  341,  429,  430,   20,  360,   22,    0,   96,  368,
 /*   680 */   407,  408,  409,  368,  407,  408,  373,   33,  373,   35,
 /*   690 */   375,  418,  337,  363,  165,  418,   14,   15,   16,  341,
 /*   700 */   118,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   710 */   165,  162,   58,  355,    0,  133,  134,  172,   97,  404,
 /*   720 */   165,  363,   96,  408,  337,   71,  411,  412,  413,  414,
 /*   730 */   415,  416,  106,  418,   21,   66,   67,   68,  351,  384,
 /*   740 */   361,  386,  337,   74,   75,  163,  164,   34,   79,   36,
 /*   750 */    96,  169,  170,   84,   85,  368,  351,    8,    9,   90,
 /*   760 */   360,   12,   13,   14,   15,   16,  184,  367,  186,    1,
 /*   770 */     2,  368,  118,  368,  360,  329,  376,   63,  463,  464,
 /*   780 */   360,  367,  379,  234,   20,  329,  165,  133,  134,  369,
 /*   790 */   376,  209,  210,  244,  212,  213,  214,  215,  216,  217,
 /*   800 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   810 */   228,  229,  361,   18,  329,   20,  329,  163,  164,  373,
 /*   820 */     2,  337,   27,  169,  170,   30,    8,    9,   33,  373,
 /*   830 */    12,   13,   14,   15,   16,  351,    4,  437,  184,    0,
 /*   840 */   186,  441,  352,   48,  361,   50,   97,   14,   53,  231,
 /*   850 */   360,  233,  368,   20,  356,  329,  456,  457,  373,  369,
 /*   860 */   373,  461,  462,  209,  210,   97,  212,  213,  214,  215,
 /*   870 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   880 */   226,  227,  228,  229,  127,  128,  361,    8,    9,  132,
 /*   890 */    95,   12,   13,   14,   15,   16,  361,  133,  134,  373,
 /*   900 */   402,   37,  107,  346,  347,   66,   67,   68,   69,   70,
 /*   910 */   397,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   920 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   930 */    91,   92,  137,  169,  170,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  156,   20,  158,  159,  160,   18,  370,  392,  337,
 /*   960 */   373,   23,  329,   99,   22,  101,  102,  360,  104,  422,
 /*   970 */   329,  424,  108,  351,  367,   37,   38,   35,   44,   41,
 /*   980 */   329,    8,    9,  376,   39,   12,   13,   14,   15,   16,
 /*   990 */   368,  374,  375,  330,  130,  329,  163,   59,   60,   61,
 /*  1000 */    62,  360,  370,  437,  329,  373,  373,  441,  361,  368,
 /*  1010 */   337,  346,  347,   71,  373,  337,  375,  353,  329,  329,
 /*  1020 */   356,  329,  456,  457,  373,  329,  368,  461,  462,  351,
 /*  1030 */   329,  329,  349,  329,   96,  360,   80,  379,  329,  373,
 /*  1040 */    20,  368,   96,  368,  165,  404,  368,  337,  373,  408,
 /*  1050 */   375,   20,  411,  412,  413,  414,  415,  416,  329,  418,
 /*  1060 */   118,  351,  373,  373,  423,  373,  425,   44,  352,  373,
 /*  1070 */   429,  430,  107,  135,  373,  373,  360,  373,  368,  404,
 /*  1080 */   248,  329,  373,  408,  443,  369,  411,  412,  413,  414,
 /*  1090 */   415,  416,  451,  418,  138,  139,  421,  165,  423,  424,
 /*  1100 */   425,  422,  373,  424,  429,  430,  433,  434,  435,  383,
 /*  1110 */   437,  438,  360,  465,  176,  177,  178,  161,   44,  181,
 /*  1120 */   368,  348,  157,  350,  337,  373,  184,  375,  186,  183,
 /*  1130 */   329,  185,   45,   46,   42,  108,   44,  199,  351,    0,
 /*  1140 */   202,   35,  204,  205,  206,  207,  208,  454,  337,  245,
 /*  1150 */   246,  209,  210,  329,  208,  368,  404,  130,  337,  337,
 /*  1160 */   408,  360,  351,  411,  412,  413,  414,  415,  416,  368,
 /*  1170 */   418,   97,  351,  351,  373,  423,  375,  425,  352,  368,
 /*  1180 */   337,  429,  430,  163,  360,  247,  360,   48,   22,  368,
 /*  1190 */   368,  246,  368,  247,  351,  369,  165,  373,   42,  375,
 /*  1200 */    44,   35,  268,  451,  100,  404,  339,  103,   44,  408,
 /*  1210 */    47,  368,  411,  412,  413,  414,  415,  416,  100,  418,
 /*  1220 */   100,  103,  100,  103,  423,  103,  425,   44,  404,   64,
 /*  1230 */   429,  430,  408,    0,    0,  411,  412,  413,  414,  415,
 /*  1240 */   416,  440,  418,  329,  337,    0,   58,  423,   35,  425,
 /*  1250 */    12,   13,  448,  429,  430,   22,   22,  360,  351,   96,
 /*  1260 */    22,   97,   44,   44,  440,    0,  329,   22,  133,  134,
 /*  1270 */    44,   33,  339,   35,  360,  368,    1,    2,  383,  108,
 /*  1280 */    97,  372,  368,   44,  336,   44,   98,  373,  383,  375,
 /*  1290 */   439,   13,  186,  270,   44,  458,   58,  360,  127,  128,
 /*  1300 */   129,  130,  131,  132,   44,  368,   44,  431,  442,   71,
 /*  1310 */   373,   44,  375,   35,   49,   97,   97,  249,  404,  406,
 /*  1320 */    48,  405,  408,   97,   13,  411,  412,  413,  414,  415,
 /*  1330 */   416,   44,  418,  182,  329,  394,   97,  423,   97,  425,
 /*  1340 */   380,  404,   44,  429,  430,  408,   35,   97,  411,  412,
 /*  1350 */   413,  414,  415,  416,  440,  418,  118,   97,   42,   97,
 /*  1360 */   423,    4,  425,   20,   97,  360,  429,  430,  383,  380,
 /*  1370 */   162,  378,   20,  368,  209,  337,   19,  440,  373,   44,
 /*  1380 */   375,  337,  380,   44,   97,  378,  378,  337,   44,   44,
 /*  1390 */    33,   94,  345,  337,  329,   97,  337,  337,   20,  186,
 /*  1400 */   331,  331,   20,  399,  343,   48,   20,  375,   20,  404,
 /*  1410 */    53,  338,   20,  408,  343,   58,  411,  412,  413,  414,
 /*  1420 */   415,  416,  184,  418,  186,  360,  393,  343,  423,  338,
 /*  1430 */   425,  343,   97,  368,  429,  430,   97,  343,  373,  343,
 /*  1440 */   375,   97,   97,  343,  337,  440,   52,  209,  210,  340,
 /*  1450 */   340,  373,   95,  360,  331,   98,  337,  360,  360,  360,
 /*  1460 */   222,  223,  224,  225,  226,  227,  228,  329,  360,  404,
 /*  1470 */   403,  360,  360,  408,  360,  360,  411,  412,  413,  414,
 /*  1480 */   415,  416,  198,  418,  360,  360,  331,   96,  423,  373,
 /*  1490 */   425,  329,  189,  341,  429,  430,  401,  337,  360,  341,
 /*  1500 */   399,  398,  375,  373,  383,  257,  368,  256,  450,  383,
 /*  1510 */   447,  373,  263,  375,  373,  373,  388,  388,  373,  447,
 /*  1520 */   265,  175,  360,  447,  449,  446,  445,  264,  272,  250,
 /*  1530 */   368,  267,  466,  444,  246,  373,  459,  375,  406,  269,
 /*  1540 */   460,  368,  404,   20,  410,  338,  408,  337,   20,  411,
 /*  1550 */   412,  413,  414,  415,  416,  341,  418,  341,  329,  373,
 /*  1560 */   386,  423,  373,  425,  388,  373,  404,  429,  430,  373,
 /*  1570 */   408,  373,  388,  411,  412,  413,  414,  415,  416,  373,
 /*  1580 */   418,  329,  167,  341,  385,  423,  356,  425,  341,  360,
 /*  1590 */   368,  429,  430,   96,   96,  428,  364,  368,  373,  341,
 /*  1600 */    36,  332,  373,  350,  375,  337,  395,  331,  354,  400,
 /*  1610 */   389,  354,  360,  389,    0,  354,  342,  327,    0,    0,
 /*  1620 */   368,   42,    0,   35,  203,  373,   35,  375,   35,   35,
 /*  1630 */   203,    0,   35,  404,   35,  203,    0,  408,  203,    0,
 /*  1640 */   411,  412,  413,  414,  415,  416,   35,  418,  329,    0,
 /*  1650 */    22,    0,   35,  191,  425,  186,  404,  184,  429,  430,
 /*  1660 */   408,    0,    0,  411,  412,  413,  414,  415,  416,    0,
 /*  1670 */   418,  329,  180,  179,    0,    0,   47,  425,    0,  360,
 /*  1680 */     0,  429,  430,    0,   42,    0,    0,  368,    0,    0,
 /*  1690 */     0,    0,  373,    0,  375,    0,  152,  329,   35,    0,
 /*  1700 */   152,    0,  360,    0,    0,    0,    0,    0,    0,    0,
 /*  1710 */   368,    0,    0,    0,    0,  373,    0,  375,    0,    0,
 /*  1720 */     0,   42,    0,  404,    0,    0,    0,  408,  360,    0,
 /*  1730 */   411,  412,  413,  414,  415,  416,  368,  418,    0,   22,
 /*  1740 */     0,  373,    0,  375,  425,    0,  404,    0,  136,  430,
 /*  1750 */   408,    0,    0,  411,  412,  413,  414,  415,  416,    0,
 /*  1760 */   418,    0,   35,  329,    0,    0,    0,   44,   58,   14,
 /*  1770 */    42,   39,  404,   58,   14,   40,  408,    0,   47,  411,
 /*  1780 */   412,  413,  414,  415,  416,    0,  418,   39,   58,    0,
 /*  1790 */   329,   47,   39,   47,  360,  453,  175,    0,    0,    0,
 /*  1800 */     0,   65,  368,   35,   48,    0,   39,  373,    0,  375,
 /*  1810 */    35,   48,   39,    0,   35,   39,    0,   48,   35,   48,
 /*  1820 */   329,  360,    0,  455,    0,   39,  365,    0,    0,  368,
 /*  1830 */    35,   22,    0,    0,  373,   44,  375,   35,  404,  105,
 /*  1840 */   103,   35,  408,    0,   50,  411,  412,  413,  414,  415,
 /*  1850 */   416,  360,  418,   35,   35,   44,   35,   22,   35,  368,
 /*  1860 */    35,   22,   22,    0,  373,  404,  375,   22,    0,  408,
 /*  1870 */    20,   35,  411,  412,  413,  414,  415,  416,    0,  418,
 /*  1880 */     0,  329,   35,   35,   22,   97,   35,    0,   35,   96,
 /*  1890 */   196,   35,   96,    0,   22,  404,    0,  329,  464,  408,
 /*  1900 */     0,    3,  411,  412,  413,  414,  415,  416,  165,  418,
 /*  1910 */    44,  420,  360,   96,  165,  329,  251,  365,   44,   44,
 /*  1920 */   368,  255,   96,  165,  167,  373,  187,  375,  360,   47,
 /*  1930 */   230,   97,   47,  365,   97,  173,  368,    3,   97,   97,
 /*  1940 */    96,  373,  172,  375,  172,   96,  360,   44,  251,   44,
 /*  1950 */    96,   96,   35,  251,  368,   97,  404,   97,   35,  373,
 /*  1960 */   408,  375,   35,  411,  412,  413,  414,  415,  416,   47,
 /*  1970 */   418,   35,  404,   35,  329,   35,  408,   44,   97,  411,
 /*  1980 */   412,  413,  414,  415,  416,   97,  418,    0,   47,    0,
 /*  1990 */   404,    0,    0,  329,  408,  245,   39,  411,  412,  413,
 /*  2000 */   414,  415,  416,   96,  418,  360,   47,   96,    0,   97,
 /*  2010 */    97,   96,   96,  368,  168,   96,   39,   96,  373,   47,
 /*  2020 */   375,    2,   44,  166,  360,   22,  106,   96,   96,  209,
 /*  2030 */    47,  230,  368,   47,   97,   96,  232,  373,   96,  375,
 /*  2040 */   230,   97,   97,   97,   96,   22,   96,   35,   97,  404,
 /*  2050 */   107,   35,   96,  408,   22,   97,  411,  412,  413,  414,
 /*  2060 */   415,  416,  329,  418,   35,   96,   35,   97,  404,   96,
 /*  2070 */   211,   97,  408,   35,   35,  411,  412,  413,  414,  415,
 /*  2080 */   416,   96,  418,  329,  120,   97,   96,  120,  120,  108,
 /*  2090 */    96,  120,   44,  360,   96,   35,   96,   22,   65,   64,
 /*  2100 */    35,  368,   35,   35,   35,   35,  373,   35,  375,   35,
 /*  2110 */    93,  329,   35,   35,  360,   35,   71,   44,   35,   22,
 /*  2120 */    35,   35,  368,   35,   35,   35,   71,  373,   35,  375,
 /*  2130 */    35,   35,  329,   35,   35,   22,   35,  404,    0,   35,
 /*  2140 */    48,  408,  360,    0,  411,  412,  413,  414,  415,  416,
 /*  2150 */   368,  418,   35,   39,   48,  373,    0,  375,  404,   39,
 /*  2160 */    35,   39,  408,  360,   48,  411,  412,  413,  414,  415,
 /*  2170 */   416,  368,  418,    0,   35,   48,  373,    0,  375,   39,
 /*  2180 */    35,  329,   35,    0,   22,   21,  404,   22,   22,   21,
 /*  2190 */   408,   20,  467,  411,  412,  413,  414,  415,  416,  329,
 /*  2200 */   418,  467,  467,  467,  467,  467,  467,  404,  467,  467,
 /*  2210 */   467,  408,  360,  467,  411,  412,  413,  414,  415,  416,
 /*  2220 */   368,  418,  467,  467,  467,  373,  467,  375,  467,  467,
 /*  2230 */   360,  467,  467,  467,  467,  467,  467,  467,  368,  467,
 /*  2240 */   467,  467,  467,  373,  467,  375,  467,  467,  467,  467,
 /*  2250 */   467,  467,  467,  467,  467,  467,  404,  467,  329,  467,
 /*  2260 */   408,  467,  467,  411,  412,  413,  414,  415,  416,  467,
 /*  2270 */   418,  467,  467,  467,  404,  467,  329,  467,  408,  467,
 /*  2280 */   467,  411,  412,  413,  414,  415,  416,  467,  418,  360,
 /*  2290 */   467,  467,  467,  467,  467,  467,  467,  368,  467,  467,
 /*  2300 */   467,  467,  373,  467,  375,  467,  467,  360,  467,  467,
 /*  2310 */   467,  467,  467,  467,  467,  368,  467,  467,  467,  467,
 /*  2320 */   373,  467,  375,  467,  467,  467,  467,  467,  467,  467,
 /*  2330 */   467,  467,  467,  404,  467,  329,  467,  408,  467,  467,
 /*  2340 */   411,  412,  413,  414,  415,  416,  467,  418,  467,  467,
 /*  2350 */   467,  404,  467,  467,  329,  408,  467,  467,  411,  412,
 /*  2360 */   413,  414,  415,  416,  467,  418,  360,  467,  467,  467,
 /*  2370 */   467,  467,  467,  467,  368,  467,  467,  467,  467,  373,
 /*  2380 */   467,  375,  467,  467,  467,  360,  467,  467,  467,  467,
 /*  2390 */   467,  467,  467,  368,  467,  467,  467,  467,  373,  467,
 /*  2400 */   375,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2410 */   404,  467,  467,  329,  408,  467,  467,  411,  412,  413,
 /*  2420 */   414,  415,  416,  467,  418,  467,  467,  467,  467,  404,
 /*  2430 */   467,  329,  467,  408,  467,  467,  411,  412,  413,  414,
 /*  2440 */   415,  416,  467,  418,  360,  467,  467,  467,  467,  467,
 /*  2450 */   467,  467,  368,  467,  467,  467,  467,  373,  467,  375,
 /*  2460 */   467,  467,  360,  467,  467,  467,  467,  467,  467,  467,
 /*  2470 */   368,  467,  467,  467,  467,  373,  467,  375,  467,  467,
 /*  2480 */   329,  467,  467,  467,  467,  467,  467,  467,  404,  467,
 /*  2490 */   467,  467,  408,  467,  467,  411,  412,  413,  414,  415,
 /*  2500 */   416,  329,  418,  467,  467,  467,  404,  467,  467,  467,
 /*  2510 */   408,  360,  467,  411,  412,  413,  414,  415,  416,  368,
 /*  2520 */   418,  467,  467,  467,  373,  467,  375,  467,  467,  329,
 /*  2530 */   467,  467,  360,  467,  467,  467,  467,  467,  467,  467,
 /*  2540 */   368,  467,  467,  467,  467,  373,  467,  375,  467,  467,
 /*  2550 */   329,  467,  467,  467,  467,  404,  467,  467,  467,  408,
 /*  2560 */   360,  467,  411,  412,  413,  414,  415,  416,  368,  418,
 /*  2570 */   467,  467,  467,  373,  467,  375,  404,  467,  467,  467,
 /*  2580 */   408,  360,  467,  411,  412,  413,  414,  415,  416,  368,
 /*  2590 */   418,  467,  467,  467,  373,  467,  375,  467,  467,  467,
 /*  2600 */   467,  467,  467,  467,  404,  467,  467,  467,  408,  467,
 /*  2610 */   467,  411,  412,  413,  414,  415,  416,  467,  418,  329,
 /*  2620 */   467,  467,  467,  467,  467,  404,  467,  467,  467,  408,
 /*  2630 */   467,  467,  411,  412,  413,  414,  415,  416,  467,  418,
 /*  2640 */   467,  467,  467,  467,  467,  329,  467,  467,  467,  467,
 /*  2650 */   360,  467,  467,  467,  467,  467,  467,  467,  368,  467,
 /*  2660 */   467,  467,  467,  373,  467,  375,  467,  467,  467,  467,
 /*  2670 */   467,  467,  467,  467,  467,  467,  360,  467,  467,  467,
 /*  2680 */   467,  467,  467,  467,  368,  467,  467,  467,  467,  373,
 /*  2690 */   467,  375,  467,  467,  404,  467,  467,  467,  408,  467,
 /*  2700 */   467,  411,  412,  413,  414,  415,  416,  467,  418,  329,
 /*  2710 */   467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2720 */   404,  467,  467,  467,  408,  467,  467,  411,  412,  413,
 /*  2730 */   414,  415,  416,  467,  418,  467,  467,  467,  467,  467,
 /*  2740 */   360,  467,  467,  467,  467,  467,  467,  467,  368,  467,
 /*  2750 */   467,  467,  467,  373,  467,  375,  467,  467,  467,  467,
 /*  2760 */   467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2770 */   467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*  2780 */   467,  467,  467,  467,  404,  467,  467,  467,  408,  467,
 /*  2790 */   467,  411,  412,  413,  414,  415,  416,  467,  418,
};
#define YY_SHIFT_COUNT    (736)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2183)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   938,    0,   72,    0,  292,  292,  292,  292,  292,  292,
 /*    10 */   292,  292,  292,  292,  292,  364,  582,  582,  654,  582,
 /*    20 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    30 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    40 */   582,  582,  582,  582,  582,  582,  582,  582,   70,  115,
 /*    50 */   946,   19,   33,  102,  108,  102,   19,   19, 1238, 1238,
 /*    60 */   102, 1238, 1238,    6,  102,   25,  764,  237,  237,  764,
 /*    70 */   348,  348,  147,  241,  326,  326,  237,  237,  237,  237,
 /*    80 */   237,  237,  237,  301,  237,  237,   54,   25,  237,  237,
 /*    90 */   328,  237,   25,  237,  301,  237,  301,   25,  237,  237,
 /*   100 */    25,  237,   25,   25,   25,  237,  119,  795,   34,   34,
 /*   110 */   219,  669,  942,  942,  942,  942,  942,  942,  942,  942,
 /*   120 */   942,  942,  942,  942,  942,  942,  942,  942,  942,  942,
 /*   130 */   942,  864,  621,  147,  241,  309,  166,  555,  555,  555,
 /*   140 */   714,  618,  618,  166,  460,  460,  460,  132,  308,   25,
 /*   150 */   530,   25,  530,  530,  502,  534,   36,   36,   36,   36,
 /*   160 */    36,   36,   36,   36,  287,  531,  553,  529,  251,  107,
 /*   170 */    18,  272,  434,  833,  232,  932, 1087, 1027, 1031,  904,
 /*   180 */   945,  129,  904, 1092,  832, 1020, 1068, 1272, 1151, 1316,
 /*   190 */  1343, 1316, 1208, 1352, 1352, 1316, 1208, 1208, 1352, 1297,
 /*   200 */  1352, 1352, 1352, 1378, 1378, 1382,   54, 1386,   54, 1388,
 /*   210 */  1392,   54, 1388,   54,   54,   54, 1352,   54, 1394, 1394,
 /*   220 */  1378,   25,   25,   25,   25,   25,   25,   25,   25,   25,
 /*   230 */    25,   25, 1352, 1378,  530,  530, 1284, 1391, 1382,  119,
 /*   240 */  1303, 1386,  119, 1352, 1343, 1343,  530, 1248, 1251,  530,
 /*   250 */  1248, 1251,  530,  530,   25, 1249, 1346, 1248, 1255, 1263,
 /*   260 */  1279, 1068, 1256, 1270, 1264, 1288,  460, 1523, 1352, 1388,
 /*   270 */   119,  119, 1528, 1251,  530,  530,  530,  530,  530, 1251,
 /*   280 */   530, 1415,  119,  502,  119,  460, 1497, 1498,  530,  534,
 /*   290 */  1352,  119, 1564, 1378, 2799, 2799, 2799, 2799, 2799, 2799,
 /*   300 */  2799, 2799, 2799,  839,  275,  677, 1357,   47,  345,  749,
 /*   310 */   339,   15,  818,  879,  438,  973,  973,  973,  973,  973,
 /*   320 */   973,  973,  973,  973, 1171,  127,  218,  218,  956,  136,
 /*   330 */   371,  538,  713,  186,  757,  757,  682,  768,  549,  682,
 /*   340 */   682,  682, 1139,  450, 1166, 1156,  965, 1104, 1118, 1120,
 /*   350 */  1122, 1233, 1234, 1245, 1074, 1164, 1188, 1183, 1218, 1135,
 /*   360 */   934, 1023,  545, 1219, 1226, 1239, 1241, 1250, 1262, 1275,
 /*   370 */  1267, 1106, 1213, 1165, 1287, 1163, 1260, 1298, 1335, 1339,
 /*   380 */  1344, 1345,  626, 1278, 1311,  416, 1265, 1614, 1618, 1619,
 /*   390 */  1579, 1622, 1588, 1421, 1591, 1593, 1594, 1427, 1631, 1597,
 /*   400 */  1599, 1432, 1636, 1435, 1639, 1611, 1649, 1628, 1651, 1617,
 /*   410 */  1462, 1469, 1473, 1661, 1662, 1669, 1492, 1494, 1674, 1675,
 /*   420 */  1629, 1678, 1680, 1683, 1642, 1685, 1686, 1688, 1689, 1690,
 /*   430 */  1691, 1693, 1695, 1544, 1663, 1699, 1548, 1701, 1703, 1704,
 /*   440 */  1705, 1706, 1707, 1708, 1709, 1711, 1712, 1713, 1714, 1716,
 /*   450 */  1718, 1719, 1720, 1679, 1722, 1724, 1725, 1726, 1729, 1738,
 /*   460 */  1717, 1740, 1742, 1745, 1612, 1747, 1751, 1752, 1710, 1727,
 /*   470 */  1759, 1715, 1761, 1730, 1764, 1765, 1728, 1732, 1723, 1731,
 /*   480 */  1755, 1744, 1760, 1746, 1766, 1735, 1748, 1777, 1785, 1789,
 /*   490 */  1753, 1621, 1797, 1798, 1799, 1736, 1800, 1808, 1768, 1756,
 /*   500 */  1767, 1805, 1775, 1763, 1773, 1813, 1779, 1769, 1776, 1816,
 /*   510 */  1783, 1771, 1786, 1822, 1824, 1827, 1828, 1734, 1737, 1795,
 /*   520 */  1809, 1832, 1802, 1806, 1818, 1819, 1791, 1811, 1821, 1823,
 /*   530 */  1835, 1825, 1833, 1839, 1843, 1840, 1794, 1863, 1845, 1836,
 /*   540 */  1868, 1847, 1878, 1848, 1880, 1862, 1850, 1851, 1853, 1694,
 /*   550 */  1788, 1793, 1887, 1743, 1796, 1856, 1893, 1739, 1872, 1749,
 /*   560 */  1757, 1896, 1900, 1758, 1762, 1898, 1866, 1665, 1817, 1834,
 /*   570 */  1826, 1770, 1700, 1772, 1666, 1837, 1874, 1841, 1844, 1849,
 /*   580 */  1854, 1842, 1875, 1882, 1885, 1855, 1903, 1697, 1858, 1860,
 /*   590 */  1934, 1905, 1702, 1917, 1923, 1927, 1936, 1938, 1940, 1881,
 /*   600 */  1888, 1922, 1750, 1933, 1941, 1987, 1989, 1991, 1992, 1907,
 /*   610 */  1957, 1731, 1959, 1911, 1912, 1913, 1915, 1916, 1846, 1919,
 /*   620 */  2008, 1977, 1857, 1921, 1920, 1731, 1972, 1978, 1801, 1804,
 /*   630 */  1810, 2019, 2003, 1820, 1931, 1937, 1932, 1944, 1939, 1945,
 /*   640 */  1983, 1942, 1948, 1986, 1946, 2023, 1859, 1950, 1943, 1951,
 /*   650 */  2012, 2016, 1956, 1958, 2029, 1969, 1970, 2031, 1973, 1974,
 /*   660 */  2038, 1985, 1988, 2039, 1990, 1964, 1967, 1968, 1971, 2032,
 /*   670 */  1981, 1994, 2048, 1998, 2060, 2000, 2048, 2048, 2075, 2033,
 /*   680 */  2035, 2065, 2067, 2068, 2069, 2070, 2072, 2074, 2077, 2078,
 /*   690 */  2080, 2045, 2017, 2073, 2083, 2085, 2086, 2097, 2088, 2089,
 /*   700 */  2090, 2055, 1791, 2093, 1811, 2095, 2096, 2098, 2099, 2113,
 /*   710 */  2101, 2138, 2104, 2092, 2114, 2143, 2117, 2106, 2120, 2156,
 /*   720 */  2125, 2116, 2122, 2173, 2139, 2127, 2140, 2177, 2145, 2147,
 /*   730 */  2183, 2162, 2164, 2165, 2166, 2168, 2171,
};
#define YY_REDUCE_COUNT (302)
#define YY_REDUCE_MIN   (-413)
#define YY_REDUCE_MAX   (2380)
static const short yy_reduce_ofst[] = {
 /*     0 */  -254,  641,  675,  752,  801,  824,  914,  937, 1005, 1065,
 /*    10 */  1138, 1162,  243, 1229, 1252, -292,   77,  315, 1319, 1342,
 /*    20 */  1368, 1434, 1461, 1491, 1552, 1568, 1586, 1645, 1664, 1733,
 /*    30 */  1754, 1782, 1803, 1852, 1870, 1929, 1947, 2006, 2025, 2084,
 /*    40 */  2102, 2151, 2172, 2200, 2221, 2290, 2316, 2380, -262,  400,
 /*    50 */   -45,  -30, -348,  -28,  208,  566, -334,  673, -321,  273,
 /*    60 */   169, -341,  277,  -18,   22, -351, -210, -332,   63, -280,
 /*    70 */  -329, -144, -303, -301, -197,  162, -286,   64,  135,  203,
 /*    80 */   261,  311,  387,  -58,  405,  484, -169,   97,  622,  678,
 /*    90 */  -175,  710,  247,  787,   -3,  811,  355,  490,  821,  822,
 /*   100 */   414,  843,  716,  607,  826,  907,  358,  -75,  109,  109,
 /*   110 */  -328,  264,  101,  313,  446,  456,  485,  487,  526,  633,
 /*   120 */   651,  666,  689,  690,  692,  696,  701,  702,  704,  709,
 /*   130 */   729,  192, -356, -204,  617,  256,  557, -356,  -12,  224,
 /*   140 */   330,  547,  679,  665,  284,  403,  658,  498, -413,  420,
 /*   150 */    17,   60,  587,  632,  664,  773, -346,  379,  451,  483,
 /*   160 */   525,  535,  647,  525,  513,  663,  683,  726,  648,  693,
 /*   170 */   867,  804,  897,  897,  933,  895,  948,  909,  905,  851,
 /*   180 */   851,  837,  851,  876,  866,  897,  913,  916,  941,  960,
 /*   190 */   985,  989,  993, 1038, 1044, 1002, 1007, 1008, 1050, 1047,
 /*   200 */  1056, 1059, 1060, 1069, 1070, 1004, 1061, 1032, 1071, 1073,
 /*   210 */  1033, 1084, 1091, 1088, 1094, 1096, 1107, 1100, 1109, 1110,
 /*   220 */  1123, 1093, 1097, 1098, 1099, 1108, 1111, 1112, 1114, 1115,
 /*   230 */  1124, 1125, 1119, 1155, 1078, 1116, 1067, 1095, 1101, 1152,
 /*   240 */  1103, 1127, 1158, 1160, 1121, 1126, 1130, 1063, 1128, 1141,
 /*   250 */  1072, 1129, 1142, 1145,  897, 1058, 1075, 1076, 1079, 1081,
 /*   260 */  1089, 1132, 1066, 1080, 1077,  851, 1173, 1134, 1210, 1207,
 /*   270 */  1214, 1216, 1174, 1176, 1186, 1189, 1192, 1196, 1198, 1184,
 /*   280 */  1206, 1199, 1242, 1230, 1247, 1222, 1167, 1232, 1225, 1253,
 /*   290 */  1268, 1258, 1269, 1276, 1211, 1209, 1221, 1224, 1254, 1257,
 /*   300 */  1261, 1274, 1290,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    10 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    20 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    30 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    40 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    50 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    60 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    70 */  1651, 1651, 1909, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*    80 */  1651, 1651, 1651, 1651, 1651, 1651, 1730, 1651, 1651, 1651,
 /*    90 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   100 */  1651, 1651, 1651, 1651, 1651, 1651, 1728, 1902, 2116, 1651,
 /*   110 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   120 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   130 */  1651, 1651, 2128, 1651, 1651, 1730, 1651, 2128, 2128, 2128,
 /*   140 */  1728, 2088, 2088, 1651, 1651, 1651, 1651, 1963, 1651, 1651,
 /*   150 */  1651, 1651, 1651, 1651, 1837, 1651, 1651, 1651, 1651, 1651,
 /*   160 */  1861, 1651, 1651, 1651, 1955, 1651, 1651, 2153, 2207, 1651,
 /*   170 */  1651, 2156, 1651, 1651, 1651, 1914, 1651, 1790, 2143, 2120,
 /*   180 */  2134, 2191, 2121, 2118, 2137, 1651, 2147, 1651, 1948, 1907,
 /*   190 */  1651, 1907, 1904, 1651, 1651, 1907, 1904, 1904, 1651, 1781,
 /*   200 */  1651, 1651, 1651, 1651, 1651, 1651, 1730, 1651, 1730, 1651,
 /*   210 */  1651, 1730, 1651, 1730, 1730, 1730, 1651, 1730, 1708, 1708,
 /*   220 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   230 */  1651, 1651, 1651, 1651, 1651, 1651, 1973, 1961, 1651, 1728,
 /*   240 */  1957, 1651, 1728, 1651, 1651, 1651, 1651, 2164, 2162, 1651,
 /*   250 */  2164, 2162, 1651, 1651, 1651, 2176, 2172, 2164, 2180, 2178,
 /*   260 */  2149, 2147, 2210, 2197, 2193, 2134, 1651, 1651, 1651, 1651,
 /*   270 */  1728, 1728, 1651, 2162, 1651, 1651, 1651, 1651, 1651, 2162,
 /*   280 */  1651, 1651, 1728, 1651, 1728, 1651, 1651, 1806, 1651, 1651,
 /*   290 */  1651, 1728, 1683, 1651, 1950, 1966, 1932, 1932, 1840, 1840,
 /*   300 */  1840, 1731, 1656, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   310 */  1651, 1651, 1651, 1651, 1651, 2175, 2174, 2043, 1651, 2092,
 /*   320 */  2091, 2090, 2081, 2042, 1802, 1651, 2041, 2040, 1651, 1651,
 /*   330 */  1651, 1651, 1651, 1651, 1923, 1922, 2034, 1651, 1651, 2035,
 /*   340 */  2033, 2032, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   350 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   360 */  2194, 2198, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 2117,
 /*   370 */  1651, 1651, 1651, 1651, 1651, 2016, 1651, 1651, 1651, 1651,
 /*   380 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   390 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   400 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   410 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   420 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   430 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   440 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   450 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   460 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   470 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1688, 2021,
 /*   480 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   490 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   500 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   510 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   520 */  1651, 1651, 1651, 1651, 1651, 1651, 1769, 1768, 1651, 1651,
 /*   530 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   540 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   550 */  2025, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   560 */  1651, 1651, 1651, 1651, 1651, 2190, 2150, 1651, 1651, 1651,
 /*   570 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   580 */  1651, 1651, 1651, 1651, 2016, 1651, 2173, 1651, 1651, 2188,
 /*   590 */  1651, 2192, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 2127,
 /*   600 */  2123, 1651, 1651, 2119, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   610 */  1651, 2024, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   620 */  1651, 1651, 1651, 1651, 1651, 2015, 1651, 2078, 1651, 1651,
 /*   630 */  1651, 2112, 1651, 1651, 2063, 1651, 1651, 1651, 1651, 1651,
 /*   640 */  1651, 1651, 1651, 1651, 2025, 1651, 2028, 1651, 1651, 1651,
 /*   650 */  1651, 1651, 1834, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   660 */  1651, 1651, 1651, 1651, 1651, 1819, 1817, 1816, 1815, 1651,
 /*   670 */  1812, 1651, 1847, 1651, 1651, 1651, 1843, 1842, 1651, 1651,
 /*   680 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   690 */  1651, 1651, 1651, 1749, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   700 */  1651, 1651, 1741, 1651, 1740, 1651, 1651, 1651, 1651, 1651,
 /*   710 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   720 */  1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651,
 /*   730 */  1651, 1651, 1651, 1651, 1651, 1651, 1651,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  273,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  273,  /*      AFTER => ABORT */
  273,  /*     ATTACH => ABORT */
  273,  /*     BEFORE => ABORT */
  273,  /*      BEGIN => ABORT */
  273,  /*     BITAND => ABORT */
  273,  /*     BITNOT => ABORT */
  273,  /*      BITOR => ABORT */
  273,  /*     BLOCKS => ABORT */
  273,  /*     CHANGE => ABORT */
  273,  /*      COMMA => ABORT */
  273,  /*     CONCAT => ABORT */
  273,  /*   CONFLICT => ABORT */
  273,  /*       COPY => ABORT */
  273,  /*   DEFERRED => ABORT */
  273,  /* DELIMITERS => ABORT */
  273,  /*     DETACH => ABORT */
  273,  /*     DIVIDE => ABORT */
  273,  /*        DOT => ABORT */
  273,  /*       EACH => ABORT */
  273,  /*       FAIL => ABORT */
  273,  /*       FILE => ABORT */
  273,  /*        FOR => ABORT */
  273,  /*       GLOB => ABORT */
  273,  /*         ID => ABORT */
  273,  /*  IMMEDIATE => ABORT */
  273,  /*     IMPORT => ABORT */
  273,  /*  INITIALLY => ABORT */
  273,  /*    INSTEAD => ABORT */
  273,  /*     ISNULL => ABORT */
  273,  /*        KEY => ABORT */
  273,  /*    MODULES => ABORT */
  273,  /*  NK_BITNOT => ABORT */
  273,  /*    NK_SEMI => ABORT */
  273,  /*    NOTNULL => ABORT */
  273,  /*         OF => ABORT */
  273,  /*       PLUS => ABORT */
  273,  /*  PRIVILEGE => ABORT */
  273,  /*      RAISE => ABORT */
  273,  /*    REPLACE => ABORT */
  273,  /*   RESTRICT => ABORT */
  273,  /*        ROW => ABORT */
  273,  /*       SEMI => ABORT */
  273,  /*       STAR => ABORT */
  273,  /*  STATEMENT => ABORT */
  273,  /*     STRICT => ABORT */
  273,  /*     STRING => ABORT */
  273,  /*      TIMES => ABORT */
  273,  /*     UPDATE => ABORT */
  273,  /*     VALUES => ABORT */
  273,  /*   VARIABLE => ABORT */
  273,  /*       VIEW => ABORT */
  273,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "ALIVE",
  /*  162 */ "LIKE",
  /*  163 */ "TBNAME",
  /*  164 */ "QTAGS",
  /*  165 */ "AS",
  /*  166 */ "INDEX",
  /*  167 */ "FUNCTION",
  /*  168 */ "INTERVAL",
  /*  169 */ "COUNT",
  /*  170 */ "LAST_ROW",
  /*  171 */ "TOPIC",
  /*  172 */ "WITH",
  /*  173 */ "META",
  /*  174 */ "CONSUMER",
  /*  175 */ "GROUP",
  /*  176 */ "DESC",
  /*  177 */ "DESCRIBE",
  /*  178 */ "RESET",
  /*  179 */ "QUERY",
  /*  180 */ "CACHE",
  /*  181 */ "EXPLAIN",
  /*  182 */ "ANALYZE",
  /*  183 */ "VERBOSE",
  /*  184 */ "NK_BOOL",
  /*  185 */ "RATIO",
  /*  186 */ "NK_FLOAT",
  /*  187 */ "OUTPUTTYPE",
  /*  188 */ "AGGREGATE",
  /*  189 */ "BUFSIZE",
  /*  190 */ "STREAM",
  /*  191 */ "INTO",
  /*  192 */ "TRIGGER",
  /*  193 */ "AT_ONCE",
  /*  194 */ "WINDOW_CLOSE",
  /*  195 */ "IGNORE",
  /*  196 */ "EXPIRED",
  /*  197 */ "FILL_HISTORY",
  /*  198 */ "SUBTABLE",
  /*  199 */ "KILL",
  /*  200 */ "CONNECTION",
  /*  201 */ "TRANSACTION",
  /*  202 */ "BALANCE",
  /*  203 */ "VGROUP",
  /*  204 */ "MERGE",
  /*  205 */ "REDISTRIBUTE",
  /*  206 */ "SPLIT",
  /*  207 */ "DELETE",
  /*  208 */ "INSERT",
  /*  209 */ "NULL",
  /*  210 */ "NK_QUESTION",
  /*  211 */ "NK_ARROW",
  /*  212 */ "ROWTS",
  /*  213 */ "QSTART",
  /*  214 */ "QEND",
  /*  215 */ "QDURATION",
  /*  216 */ "WSTART",
  /*  217 */ "WEND",
  /*  218 */ "WDURATION",
  /*  219 */ "IROWTS",
  /*  220 */ "ISFILLED",
  /*  221 */ "CAST",
  /*  222 */ "NOW",
  /*  223 */ "TODAY",
  /*  224 */ "TIMEZONE",
  /*  225 */ "CLIENT_VERSION",
  /*  226 */ "SERVER_VERSION",
  /*  227 */ "SERVER_STATUS",
  /*  228 */ "CURRENT_USER",
  /*  229 */ "CASE",
  /*  230 */ "END",
  /*  231 */ "WHEN",
  /*  232 */ "THEN",
  /*  233 */ "ELSE",
  /*  234 */ "BETWEEN",
  /*  235 */ "IS",
  /*  236 */ "NK_LT",
  /*  237 */ "NK_GT",
  /*  238 */ "NK_LE",
  /*  239 */ "NK_GE",
  /*  240 */ "NK_NE",
  /*  241 */ "MATCH",
  /*  242 */ "NMATCH",
  /*  243 */ "CONTAINS",
  /*  244 */ "IN",
  /*  245 */ "JOIN",
  /*  246 */ "INNER",
  /*  247 */ "SELECT",
  /*  248 */ "DISTINCT",
  /*  249 */ "WHERE",
  /*  250 */ "PARTITION",
  /*  251 */ "BY",
  /*  252 */ "SESSION",
  /*  253 */ "STATE_WINDOW",
  /*  254 */ "EVENT_WINDOW",
  /*  255 */ "START",
  /*  256 */ "SLIDING",
  /*  257 */ "FILL",
  /*  258 */ "VALUE",
  /*  259 */ "NONE",
  /*  260 */ "PREV",
  /*  261 */ "LINEAR",
  /*  262 */ "NEXT",
  /*  263 */ "HAVING",
  /*  264 */ "RANGE",
  /*  265 */ "EVERY",
  /*  266 */ "ORDER",
  /*  267 */ "SLIMIT",
  /*  268 */ "SOFFSET",
  /*  269 */ "LIMIT",
  /*  270 */ "OFFSET",
  /*  271 */ "ASC",
  /*  272 */ "NULLS",
  /*  273 */ "ABORT",
  /*  274 */ "AFTER",
  /*  275 */ "ATTACH",
  /*  276 */ "BEFORE",
  /*  277 */ "BEGIN",
  /*  278 */ "BITAND",
  /*  279 */ "BITNOT",
  /*  280 */ "BITOR",
  /*  281 */ "BLOCKS",
  /*  282 */ "CHANGE",
  /*  283 */ "COMMA",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "full_index_name",
  /*  385 */ "index_options",
  /*  386 */ "index_name",
  /*  387 */ "func_list",
  /*  388 */ "sliding_opt",
  /*  389 */ "sma_stream_opt",
  /*  390 */ "func",
  /*  391 */ "sma_func_name",
  /*  392 */ "query_or_subquery",
  /*  393 */ "cgroup_name",
  /*  394 */ "analyze_opt",
  /*  395 */ "explain_options",
  /*  396 */ "insert_query",
  /*  397 */ "agg_func_opt",
  /*  398 */ "bufsize_opt",
  /*  399 */ "stream_name",
  /*  400 */ "stream_options",
  /*  401 */ "col_list_opt",
  /*  402 */ "tag_def_or_ref_opt",
  /*  403 */ "subtable_opt",
  /*  404 */ "expression",
  /*  405 */ "dnode_list",
  /*  406 */ "where_clause_opt",
  /*  407 */ "signed",
  /*  408 */ "literal_func",
  /*  409 */ "literal_list",
  /*  410 */ "table_alias",
  /*  411 */ "expr_or_subquery",
  /*  412 */ "pseudo_column",
  /*  413 */ "column_reference",
  /*  414 */ "function_expression",
  /*  415 */ "case_when_expression",
  /*  416 */ "star_func",
  /*  417 */ "star_func_para_list",
  /*  418 */ "noarg_func",
  /*  419 */ "other_para_list",
  /*  420 */ "star_func_para",
  /*  421 */ "when_then_list",
  /*  422 */ "case_when_else_opt",
  /*  423 */ "common_expression",
  /*  424 */ "when_then_expr",
  /*  425 */ "predicate",
  /*  426 */ "compare_op",
  /*  427 */ "in_op",
  /*  428 */ "in_predicate_value",
  /*  429 */ "boolean_value_expression",
  /*  430 */ "boolean_primary",
  /*  431 */ "from_clause_opt",
  /*  432 */ "table_reference_list",
  /*  433 */ "table_reference",
  /*  434 */ "table_primary",
  /*  435 */ "joined_table",
  /*  436 */ "alias_opt",
  /*  437 */ "subquery",
  /*  438 */ "parenthesized_joined_table",
  /*  439 */ "join_type",
  /*  440 */ "search_condition",
  /*  441 */ "query_specification",
  /*  442 */ "set_quantifier_opt",
  /*  443 */ "select_list",
  /*  444 */ "partition_by_clause_opt",
  /*  445 */ "range_opt",
  /*  446 */ "every_opt",
  /*  447 */ "fill_opt",
  /*  448 */ "twindow_clause_opt",
  /*  449 */ "group_by_clause_opt",
  /*  450 */ "having_clause_opt",
  /*  451 */ "select_item",
  /*  452 */ "partition_list",
  /*  453 */ "partition_item",
  /*  454 */ "fill_mode",
  /*  455 */ "group_by_list",
  /*  456 */ "query_expression",
  /*  457 */ "query_simple",
  /*  458 */ "order_by_clause_opt",
  /*  459 */ "slimit_clause_opt",
  /*  460 */ "limit_clause_opt",
  /*  461 */ "union_query_expression",
  /*  462 */ "query_simple_or_subquery",
  /*  463 */ "sort_specification_list",
  /*  464 */ "sort_specification",
  /*  465 */ "ordering_specification_opt",
  /*  466 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 247 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 248 */ "db_name_cond_opt ::=",
 /* 249 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 250 */ "like_pattern_opt ::=",
 /* 251 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 252 */ "table_name_cond ::= table_name",
 /* 253 */ "from_db_opt ::=",
 /* 254 */ "from_db_opt ::= FROM db_name",
 /* 255 */ "tag_list_opt ::=",
 /* 256 */ "tag_list_opt ::= tag_item",
 /* 257 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 258 */ "tag_item ::= TBNAME",
 /* 259 */ "tag_item ::= QTAGS",
 /* 260 */ "tag_item ::= column_name",
 /* 261 */ "tag_item ::= column_name column_alias",
 /* 262 */ "tag_item ::= column_name AS column_alias",
 /* 263 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 264 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 265 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 266 */ "full_index_name ::= index_name",
 /* 267 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 270 */ "func_list ::= func",
 /* 271 */ "func_list ::= func_list NK_COMMA func",
 /* 272 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 273 */ "sma_func_name ::= function_name",
 /* 274 */ "sma_func_name ::= COUNT",
 /* 275 */ "sma_func_name ::= FIRST",
 /* 276 */ "sma_func_name ::= LAST",
 /* 277 */ "sma_func_name ::= LAST_ROW",
 /* 278 */ "sma_stream_opt ::=",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 281 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 286 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 287 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 288 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 289 */ "cmd ::= DESC full_table_name",
 /* 290 */ "cmd ::= DESCRIBE full_table_name",
 /* 291 */ "cmd ::= RESET QUERY CACHE",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 293 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 294 */ "analyze_opt ::=",
 /* 295 */ "analyze_opt ::= ANALYZE",
 /* 296 */ "explain_options ::=",
 /* 297 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 298 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 299 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 300 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 301 */ "agg_func_opt ::=",
 /* 302 */ "agg_func_opt ::= AGGREGATE",
 /* 303 */ "bufsize_opt ::=",
 /* 304 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 305 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 306 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 307 */ "col_list_opt ::=",
 /* 308 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 309 */ "tag_def_or_ref_opt ::=",
 /* 310 */ "tag_def_or_ref_opt ::= tags_def",
 /* 311 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 312 */ "stream_options ::=",
 /* 313 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 314 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 315 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 316 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 317 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 318 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 319 */ "subtable_opt ::=",
 /* 320 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 321 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 322 */ "cmd ::= KILL QUERY NK_STRING",
 /* 323 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 324 */ "cmd ::= BALANCE VGROUP",
 /* 325 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 326 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 327 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 328 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 329 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 330 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 331 */ "cmd ::= query_or_subquery",
 /* 332 */ "cmd ::= insert_query",
 /* 333 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 334 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 335 */ "literal ::= NK_INTEGER",
 /* 336 */ "literal ::= NK_FLOAT",
 /* 337 */ "literal ::= NK_STRING",
 /* 338 */ "literal ::= NK_BOOL",
 /* 339 */ "literal ::= TIMESTAMP NK_STRING",
 /* 340 */ "literal ::= duration_literal",
 /* 341 */ "literal ::= NULL",
 /* 342 */ "literal ::= NK_QUESTION",
 /* 343 */ "duration_literal ::= NK_VARIABLE",
 /* 344 */ "signed ::= NK_INTEGER",
 /* 345 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 346 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 347 */ "signed ::= NK_FLOAT",
 /* 348 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 349 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 350 */ "signed_literal ::= signed",
 /* 351 */ "signed_literal ::= NK_STRING",
 /* 352 */ "signed_literal ::= NK_BOOL",
 /* 353 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 354 */ "signed_literal ::= duration_literal",
 /* 355 */ "signed_literal ::= NULL",
 /* 356 */ "signed_literal ::= literal_func",
 /* 357 */ "signed_literal ::= NK_QUESTION",
 /* 358 */ "literal_list ::= signed_literal",
 /* 359 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 360 */ "db_name ::= NK_ID",
 /* 361 */ "table_name ::= NK_ID",
 /* 362 */ "column_name ::= NK_ID",
 /* 363 */ "function_name ::= NK_ID",
 /* 364 */ "table_alias ::= NK_ID",
 /* 365 */ "column_alias ::= NK_ID",
 /* 366 */ "user_name ::= NK_ID",
 /* 367 */ "topic_name ::= NK_ID",
 /* 368 */ "stream_name ::= NK_ID",
 /* 369 */ "cgroup_name ::= NK_ID",
 /* 370 */ "index_name ::= NK_ID",
 /* 371 */ "expr_or_subquery ::= expression",
 /* 372 */ "expression ::= literal",
 /* 373 */ "expression ::= pseudo_column",
 /* 374 */ "expression ::= column_reference",
 /* 375 */ "expression ::= function_expression",
 /* 376 */ "expression ::= case_when_expression",
 /* 377 */ "expression ::= NK_LP expression NK_RP",
 /* 378 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 379 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 380 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 382 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 383 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 384 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 385 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 386 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 387 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 388 */ "expression_list ::= expr_or_subquery",
 /* 389 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 390 */ "column_reference ::= column_name",
 /* 391 */ "column_reference ::= table_name NK_DOT column_name",
 /* 392 */ "pseudo_column ::= ROWTS",
 /* 393 */ "pseudo_column ::= TBNAME",
 /* 394 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 395 */ "pseudo_column ::= QSTART",
 /* 396 */ "pseudo_column ::= QEND",
 /* 397 */ "pseudo_column ::= QDURATION",
 /* 398 */ "pseudo_column ::= WSTART",
 /* 399 */ "pseudo_column ::= WEND",
 /* 400 */ "pseudo_column ::= WDURATION",
 /* 401 */ "pseudo_column ::= IROWTS",
 /* 402 */ "pseudo_column ::= ISFILLED",
 /* 403 */ "pseudo_column ::= QTAGS",
 /* 404 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 405 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 406 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 407 */ "function_expression ::= literal_func",
 /* 408 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 409 */ "literal_func ::= NOW",
 /* 410 */ "noarg_func ::= NOW",
 /* 411 */ "noarg_func ::= TODAY",
 /* 412 */ "noarg_func ::= TIMEZONE",
 /* 413 */ "noarg_func ::= DATABASE",
 /* 414 */ "noarg_func ::= CLIENT_VERSION",
 /* 415 */ "noarg_func ::= SERVER_VERSION",
 /* 416 */ "noarg_func ::= SERVER_STATUS",
 /* 417 */ "noarg_func ::= CURRENT_USER",
 /* 418 */ "noarg_func ::= USER",
 /* 419 */ "star_func ::= COUNT",
 /* 420 */ "star_func ::= FIRST",
 /* 421 */ "star_func ::= LAST",
 /* 422 */ "star_func ::= LAST_ROW",
 /* 423 */ "star_func_para_list ::= NK_STAR",
 /* 424 */ "star_func_para_list ::= other_para_list",
 /* 425 */ "other_para_list ::= star_func_para",
 /* 426 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 427 */ "star_func_para ::= expr_or_subquery",
 /* 428 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 429 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 430 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 431 */ "when_then_list ::= when_then_expr",
 /* 432 */ "when_then_list ::= when_then_list when_then_expr",
 /* 433 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 434 */ "case_when_else_opt ::=",
 /* 435 */ "case_when_else_opt ::= ELSE common_expression",
 /* 436 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 437 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 438 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 439 */ "predicate ::= expr_or_subquery IS NULL",
 /* 440 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 441 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 442 */ "compare_op ::= NK_LT",
 /* 443 */ "compare_op ::= NK_GT",
 /* 444 */ "compare_op ::= NK_LE",
 /* 445 */ "compare_op ::= NK_GE",
 /* 446 */ "compare_op ::= NK_NE",
 /* 447 */ "compare_op ::= NK_EQ",
 /* 448 */ "compare_op ::= LIKE",
 /* 449 */ "compare_op ::= NOT LIKE",
 /* 450 */ "compare_op ::= MATCH",
 /* 451 */ "compare_op ::= NMATCH",
 /* 452 */ "compare_op ::= CONTAINS",
 /* 453 */ "in_op ::= IN",
 /* 454 */ "in_op ::= NOT IN",
 /* 455 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 456 */ "boolean_value_expression ::= boolean_primary",
 /* 457 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 458 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 459 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 460 */ "boolean_primary ::= predicate",
 /* 461 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 462 */ "common_expression ::= expr_or_subquery",
 /* 463 */ "common_expression ::= boolean_value_expression",
 /* 464 */ "from_clause_opt ::=",
 /* 465 */ "from_clause_opt ::= FROM table_reference_list",
 /* 466 */ "table_reference_list ::= table_reference",
 /* 467 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 468 */ "table_reference ::= table_primary",
 /* 469 */ "table_reference ::= joined_table",
 /* 470 */ "table_primary ::= table_name alias_opt",
 /* 471 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 472 */ "table_primary ::= subquery alias_opt",
 /* 473 */ "table_primary ::= parenthesized_joined_table",
 /* 474 */ "alias_opt ::=",
 /* 475 */ "alias_opt ::= table_alias",
 /* 476 */ "alias_opt ::= AS table_alias",
 /* 477 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 478 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 479 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 480 */ "join_type ::=",
 /* 481 */ "join_type ::= INNER",
 /* 482 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 483 */ "set_quantifier_opt ::=",
 /* 484 */ "set_quantifier_opt ::= DISTINCT",
 /* 485 */ "set_quantifier_opt ::= ALL",
 /* 486 */ "select_list ::= select_item",
 /* 487 */ "select_list ::= select_list NK_COMMA select_item",
 /* 488 */ "select_item ::= NK_STAR",
 /* 489 */ "select_item ::= common_expression",
 /* 490 */ "select_item ::= common_expression column_alias",
 /* 491 */ "select_item ::= common_expression AS column_alias",
 /* 492 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 493 */ "where_clause_opt ::=",
 /* 494 */ "where_clause_opt ::= WHERE search_condition",
 /* 495 */ "partition_by_clause_opt ::=",
 /* 496 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 497 */ "partition_list ::= partition_item",
 /* 498 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 499 */ "partition_item ::= expr_or_subquery",
 /* 500 */ "partition_item ::= expr_or_subquery column_alias",
 /* 501 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 502 */ "twindow_clause_opt ::=",
 /* 503 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 504 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 505 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 506 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 507 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 508 */ "sliding_opt ::=",
 /* 509 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 510 */ "fill_opt ::=",
 /* 511 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 512 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 513 */ "fill_mode ::= NONE",
 /* 514 */ "fill_mode ::= PREV",
 /* 515 */ "fill_mode ::= NULL",
 /* 516 */ "fill_mode ::= LINEAR",
 /* 517 */ "fill_mode ::= NEXT",
 /* 518 */ "group_by_clause_opt ::=",
 /* 519 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 520 */ "group_by_list ::= expr_or_subquery",
 /* 521 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 522 */ "having_clause_opt ::=",
 /* 523 */ "having_clause_opt ::= HAVING search_condition",
 /* 524 */ "range_opt ::=",
 /* 525 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 526 */ "every_opt ::=",
 /* 527 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 528 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 529 */ "query_simple ::= query_specification",
 /* 530 */ "query_simple ::= union_query_expression",
 /* 531 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 532 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 533 */ "query_simple_or_subquery ::= query_simple",
 /* 534 */ "query_simple_or_subquery ::= subquery",
 /* 535 */ "query_or_subquery ::= query_expression",
 /* 536 */ "query_or_subquery ::= subquery",
 /* 537 */ "order_by_clause_opt ::=",
 /* 538 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 539 */ "slimit_clause_opt ::=",
 /* 540 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 541 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 542 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 543 */ "limit_clause_opt ::=",
 /* 544 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 545 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 546 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 547 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 548 */ "subquery ::= NK_LP subquery NK_RP",
 /* 549 */ "search_condition ::= common_expression",
 /* 550 */ "sort_specification_list ::= sort_specification",
 /* 551 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 552 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 553 */ "ordering_specification_opt ::=",
 /* 554 */ "ordering_specification_opt ::= ASC",
 /* 555 */ "ordering_specification_opt ::= DESC",
 /* 556 */ "null_ordering_opt ::=",
 /* 557 */ "null_ordering_opt ::= NULLS FIRST",
 /* 558 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* full_index_name */
    case 385: /* index_options */
    case 388: /* sliding_opt */
    case 389: /* sma_stream_opt */
    case 390: /* func */
    case 392: /* query_or_subquery */
    case 395: /* explain_options */
    case 396: /* insert_query */
    case 400: /* stream_options */
    case 403: /* subtable_opt */
    case 404: /* expression */
    case 406: /* where_clause_opt */
    case 407: /* signed */
    case 408: /* literal_func */
    case 411: /* expr_or_subquery */
    case 412: /* pseudo_column */
    case 413: /* column_reference */
    case 414: /* function_expression */
    case 415: /* case_when_expression */
    case 420: /* star_func_para */
    case 422: /* case_when_else_opt */
    case 423: /* common_expression */
    case 424: /* when_then_expr */
    case 425: /* predicate */
    case 428: /* in_predicate_value */
    case 429: /* boolean_value_expression */
    case 430: /* boolean_primary */
    case 431: /* from_clause_opt */
    case 432: /* table_reference_list */
    case 433: /* table_reference */
    case 434: /* table_primary */
    case 435: /* joined_table */
    case 437: /* subquery */
    case 438: /* parenthesized_joined_table */
    case 440: /* search_condition */
    case 441: /* query_specification */
    case 445: /* range_opt */
    case 446: /* every_opt */
    case 447: /* fill_opt */
    case 448: /* twindow_clause_opt */
    case 450: /* having_clause_opt */
    case 451: /* select_item */
    case 453: /* partition_item */
    case 456: /* query_expression */
    case 457: /* query_simple */
    case 459: /* slimit_clause_opt */
    case 460: /* limit_clause_opt */
    case 461: /* union_query_expression */
    case 462: /* query_simple_or_subquery */
    case 464: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy44)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 398: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 386: /* index_name */
    case 391: /* sma_func_name */
    case 393: /* cgroup_name */
    case 399: /* stream_name */
    case 410: /* table_alias */
    case 416: /* star_func */
    case 418: /* noarg_func */
    case 436: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 394: /* analyze_opt */
    case 397: /* agg_func_opt */
    case 442: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 387: /* func_list */
    case 401: /* col_list_opt */
    case 402: /* tag_def_or_ref_opt */
    case 405: /* dnode_list */
    case 409: /* literal_list */
    case 417: /* star_func_para_list */
    case 419: /* other_para_list */
    case 421: /* when_then_list */
    case 443: /* select_list */
    case 444: /* partition_by_clause_opt */
    case 449: /* group_by_clause_opt */
    case 452: /* partition_list */
    case 455: /* group_by_list */
    case 458: /* order_by_clause_opt */
    case 463: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy684)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 426: /* compare_op */
    case 427: /* in_op */
{
 
}
      break;
    case 439: /* join_type */
{
 
}
      break;
    case 454: /* fill_mode */
{
 
}
      break;
    case 465: /* ordering_specification_opt */
{
 
}
      break;
    case 466: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  326,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  326,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  327,    0 }, /* (2) account_options ::= */
  {  327,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  327,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  327,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  327,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  327,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  327,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  327,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  327,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  327,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  328,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  328,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  330,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  330,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  330,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  330,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  330,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  330,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  330,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  330,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  330,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  330,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  326,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  326,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  326,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  326,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  326,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  332,    0 }, /* (29) sysinfo_opt ::= */
  {  332,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  326,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  326,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  333,   -1 }, /* (33) privileges ::= ALL */
  {  333,   -1 }, /* (34) privileges ::= priv_type_list */
  {  333,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  335,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  335,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  336,   -1 }, /* (38) priv_type ::= READ */
  {  336,   -1 }, /* (39) priv_type ::= WRITE */
  {  334,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  334,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  334,   -1 }, /* (42) priv_level ::= topic_name */
  {  326,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  326,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  326,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  326,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  326,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  326,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  326,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  326,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  339,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  339,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  339,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  340,    0 }, /* (54) force_opt ::= */
  {  340,   -1 }, /* (55) force_opt ::= FORCE */
  {  326,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  326,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  326,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  326,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  326,   -2 }, /* (68) cmd ::= USE db_name */
  {  326,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  326,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  326,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  326,   -3 }, /* (72) cmd ::= COMPACT DATABASE db_name */
  {  341,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  341,    0 }, /* (74) not_exists_opt ::= */
  {  343,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  343,    0 }, /* (76) exists_opt ::= */
  {  342,    0 }, /* (77) db_options ::= */
  {  342,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  342,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  342,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  342,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  342,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  342,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  342,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  342,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  342,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  342,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  342,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  342,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  342,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  342,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  342,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  342,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  342,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  342,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  342,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  342,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  342,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  342,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  342,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  342,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  344,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  344,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  349,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  349,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  349,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  349,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  349,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  349,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  349,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  349,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  349,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  349,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  346,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  346,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  347,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  347,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  348,   -1 }, /* (124) retention_list ::= retention */
  {  348,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  350,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  345,    0 }, /* (127) speed_opt ::= */
  {  345,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  326,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  326,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  326,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  326,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  326,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  326,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  326,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  358,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  358,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  358,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  358,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  358,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  358,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  358,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  358,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  358,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  358,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  355,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  355,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  363,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  357,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  357,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  366,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  364,    0 }, /* (152) specific_cols_opt ::= */
  {  364,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (154) full_table_name ::= table_name */
  {  351,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  352,   -1 }, /* (156) column_def_list ::= column_def */
  {  352,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  369,   -2 }, /* (158) column_def ::= column_name type_name */
  {  369,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  361,   -1 }, /* (160) type_name ::= BOOL */
  {  361,   -1 }, /* (161) type_name ::= TINYINT */
  {  361,   -1 }, /* (162) type_name ::= SMALLINT */
  {  361,   -1 }, /* (163) type_name ::= INT */
  {  361,   -1 }, /* (164) type_name ::= INTEGER */
  {  361,   -1 }, /* (165) type_name ::= BIGINT */
  {  361,   -1 }, /* (166) type_name ::= FLOAT */
  {  361,   -1 }, /* (167) type_name ::= DOUBLE */
  {  361,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  361,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  361,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  361,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  361,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  361,   -1 }, /* (175) type_name ::= JSON */
  {  361,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  361,   -1 }, /* (178) type_name ::= BLOB */
  {  361,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (180) type_name ::= DECIMAL */
  {  361,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  361,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  353,    0 }, /* (183) tags_def_opt ::= */
  {  353,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  356,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  354,    0 }, /* (186) table_options ::= */
  {  354,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  354,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  354,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  354,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  354,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  354,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  354,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  359,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  359,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  372,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  372,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  370,   -1 }, /* (198) duration_list ::= duration_literal */
  {  370,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  371,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  371,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  374,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  374,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  374,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  367,   -1 }, /* (205) col_name_list ::= col_name */
  {  367,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  376,   -1 }, /* (207) col_name ::= column_name */
  {  326,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  326,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  326,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  326,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  326,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  326,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  326,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  326,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  326,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  326,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  326,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  326,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  326,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  326,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  326,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  326,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  326,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  326,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  326,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  326,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  326,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  326,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  326,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  326,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  326,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  326,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  326,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  326,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  326,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  326,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  326,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  326,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  326,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  326,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  326,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  326,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  326,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  326,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  326,   -3 }, /* (246) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  326,   -3 }, /* (247) cmd ::= SHOW CLUSTER ALIVE */
  {  377,    0 }, /* (248) db_name_cond_opt ::= */
  {  377,   -2 }, /* (249) db_name_cond_opt ::= db_name NK_DOT */
  {  378,    0 }, /* (250) like_pattern_opt ::= */
  {  378,   -2 }, /* (251) like_pattern_opt ::= LIKE NK_STRING */
  {  379,   -1 }, /* (252) table_name_cond ::= table_name */
  {  380,    0 }, /* (253) from_db_opt ::= */
  {  380,   -2 }, /* (254) from_db_opt ::= FROM db_name */
  {  381,    0 }, /* (255) tag_list_opt ::= */
  {  381,   -1 }, /* (256) tag_list_opt ::= tag_item */
  {  381,   -3 }, /* (257) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  382,   -1 }, /* (258) tag_item ::= TBNAME */
  {  382,   -1 }, /* (259) tag_item ::= QTAGS */
  {  382,   -1 }, /* (260) tag_item ::= column_name */
  {  382,   -2 }, /* (261) tag_item ::= column_name column_alias */
  {  382,   -3 }, /* (262) tag_item ::= column_name AS column_alias */
  {  326,   -8 }, /* (263) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  326,   -9 }, /* (264) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  326,   -4 }, /* (265) cmd ::= DROP INDEX exists_opt full_index_name */
  {  384,   -1 }, /* (266) full_index_name ::= index_name */
  {  384,   -3 }, /* (267) full_index_name ::= db_name NK_DOT index_name */
  {  385,  -10 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  385,  -12 }, /* (269) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,   -1 }, /* (270) func_list ::= func */
  {  387,   -3 }, /* (271) func_list ::= func_list NK_COMMA func */
  {  390,   -4 }, /* (272) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  391,   -1 }, /* (273) sma_func_name ::= function_name */
  {  391,   -1 }, /* (274) sma_func_name ::= COUNT */
  {  391,   -1 }, /* (275) sma_func_name ::= FIRST */
  {  391,   -1 }, /* (276) sma_func_name ::= LAST */
  {  391,   -1 }, /* (277) sma_func_name ::= LAST_ROW */
  {  389,    0 }, /* (278) sma_stream_opt ::= */
  {  389,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  389,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  389,   -3 }, /* (281) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  326,   -6 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  326,   -7 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  326,   -9 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  326,   -7 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  326,   -9 }, /* (286) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  326,   -4 }, /* (287) cmd ::= DROP TOPIC exists_opt topic_name */
  {  326,   -7 }, /* (288) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  326,   -2 }, /* (289) cmd ::= DESC full_table_name */
  {  326,   -2 }, /* (290) cmd ::= DESCRIBE full_table_name */
  {  326,   -3 }, /* (291) cmd ::= RESET QUERY CACHE */
  {  326,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  326,   -4 }, /* (293) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  394,    0 }, /* (294) analyze_opt ::= */
  {  394,   -1 }, /* (295) analyze_opt ::= ANALYZE */
  {  395,    0 }, /* (296) explain_options ::= */
  {  395,   -3 }, /* (297) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  395,   -3 }, /* (298) explain_options ::= explain_options RATIO NK_FLOAT */
  {  326,  -10 }, /* (299) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  326,   -4 }, /* (300) cmd ::= DROP FUNCTION exists_opt function_name */
  {  397,    0 }, /* (301) agg_func_opt ::= */
  {  397,   -1 }, /* (302) agg_func_opt ::= AGGREGATE */
  {  398,    0 }, /* (303) bufsize_opt ::= */
  {  398,   -2 }, /* (304) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  326,  -12 }, /* (305) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  326,   -4 }, /* (306) cmd ::= DROP STREAM exists_opt stream_name */
  {  401,    0 }, /* (307) col_list_opt ::= */
  {  401,   -3 }, /* (308) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  402,    0 }, /* (309) tag_def_or_ref_opt ::= */
  {  402,   -1 }, /* (310) tag_def_or_ref_opt ::= tags_def */
  {  402,   -4 }, /* (311) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  400,    0 }, /* (312) stream_options ::= */
  {  400,   -3 }, /* (313) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  400,   -3 }, /* (314) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  400,   -4 }, /* (315) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  400,   -3 }, /* (316) stream_options ::= stream_options WATERMARK duration_literal */
  {  400,   -4 }, /* (317) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  400,   -3 }, /* (318) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  403,    0 }, /* (319) subtable_opt ::= */
  {  403,   -4 }, /* (320) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  326,   -3 }, /* (321) cmd ::= KILL CONNECTION NK_INTEGER */
  {  326,   -3 }, /* (322) cmd ::= KILL QUERY NK_STRING */
  {  326,   -3 }, /* (323) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  326,   -2 }, /* (324) cmd ::= BALANCE VGROUP */
  {  326,   -4 }, /* (325) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  326,   -4 }, /* (326) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  326,   -3 }, /* (327) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  405,   -2 }, /* (328) dnode_list ::= DNODE NK_INTEGER */
  {  405,   -3 }, /* (329) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  326,   -4 }, /* (330) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  326,   -1 }, /* (331) cmd ::= query_or_subquery */
  {  326,   -1 }, /* (332) cmd ::= insert_query */
  {  396,   -7 }, /* (333) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  396,   -4 }, /* (334) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  329,   -1 }, /* (335) literal ::= NK_INTEGER */
  {  329,   -1 }, /* (336) literal ::= NK_FLOAT */
  {  329,   -1 }, /* (337) literal ::= NK_STRING */
  {  329,   -1 }, /* (338) literal ::= NK_BOOL */
  {  329,   -2 }, /* (339) literal ::= TIMESTAMP NK_STRING */
  {  329,   -1 }, /* (340) literal ::= duration_literal */
  {  329,   -1 }, /* (341) literal ::= NULL */
  {  329,   -1 }, /* (342) literal ::= NK_QUESTION */
  {  373,   -1 }, /* (343) duration_literal ::= NK_VARIABLE */
  {  407,   -1 }, /* (344) signed ::= NK_INTEGER */
  {  407,   -2 }, /* (345) signed ::= NK_PLUS NK_INTEGER */
  {  407,   -2 }, /* (346) signed ::= NK_MINUS NK_INTEGER */
  {  407,   -1 }, /* (347) signed ::= NK_FLOAT */
  {  407,   -2 }, /* (348) signed ::= NK_PLUS NK_FLOAT */
  {  407,   -2 }, /* (349) signed ::= NK_MINUS NK_FLOAT */
  {  362,   -1 }, /* (350) signed_literal ::= signed */
  {  362,   -1 }, /* (351) signed_literal ::= NK_STRING */
  {  362,   -1 }, /* (352) signed_literal ::= NK_BOOL */
  {  362,   -2 }, /* (353) signed_literal ::= TIMESTAMP NK_STRING */
  {  362,   -1 }, /* (354) signed_literal ::= duration_literal */
  {  362,   -1 }, /* (355) signed_literal ::= NULL */
  {  362,   -1 }, /* (356) signed_literal ::= literal_func */
  {  362,   -1 }, /* (357) signed_literal ::= NK_QUESTION */
  {  409,   -1 }, /* (358) literal_list ::= signed_literal */
  {  409,   -3 }, /* (359) literal_list ::= literal_list NK_COMMA signed_literal */
  {  337,   -1 }, /* (360) db_name ::= NK_ID */
  {  368,   -1 }, /* (361) table_name ::= NK_ID */
  {  360,   -1 }, /* (362) column_name ::= NK_ID */
  {  375,   -1 }, /* (363) function_name ::= NK_ID */
  {  410,   -1 }, /* (364) table_alias ::= NK_ID */
  {  383,   -1 }, /* (365) column_alias ::= NK_ID */
  {  331,   -1 }, /* (366) user_name ::= NK_ID */
  {  338,   -1 }, /* (367) topic_name ::= NK_ID */
  {  399,   -1 }, /* (368) stream_name ::= NK_ID */
  {  393,   -1 }, /* (369) cgroup_name ::= NK_ID */
  {  386,   -1 }, /* (370) index_name ::= NK_ID */
  {  411,   -1 }, /* (371) expr_or_subquery ::= expression */
  {  404,   -1 }, /* (372) expression ::= literal */
  {  404,   -1 }, /* (373) expression ::= pseudo_column */
  {  404,   -1 }, /* (374) expression ::= column_reference */
  {  404,   -1 }, /* (375) expression ::= function_expression */
  {  404,   -1 }, /* (376) expression ::= case_when_expression */
  {  404,   -3 }, /* (377) expression ::= NK_LP expression NK_RP */
  {  404,   -2 }, /* (378) expression ::= NK_PLUS expr_or_subquery */
  {  404,   -2 }, /* (379) expression ::= NK_MINUS expr_or_subquery */
  {  404,   -3 }, /* (380) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  404,   -3 }, /* (381) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  404,   -3 }, /* (382) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  404,   -3 }, /* (383) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  404,   -3 }, /* (384) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  404,   -3 }, /* (385) expression ::= column_reference NK_ARROW NK_STRING */
  {  404,   -3 }, /* (386) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  404,   -3 }, /* (387) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  365,   -1 }, /* (388) expression_list ::= expr_or_subquery */
  {  365,   -3 }, /* (389) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  413,   -1 }, /* (390) column_reference ::= column_name */
  {  413,   -3 }, /* (391) column_reference ::= table_name NK_DOT column_name */
  {  412,   -1 }, /* (392) pseudo_column ::= ROWTS */
  {  412,   -1 }, /* (393) pseudo_column ::= TBNAME */
  {  412,   -3 }, /* (394) pseudo_column ::= table_name NK_DOT TBNAME */
  {  412,   -1 }, /* (395) pseudo_column ::= QSTART */
  {  412,   -1 }, /* (396) pseudo_column ::= QEND */
  {  412,   -1 }, /* (397) pseudo_column ::= QDURATION */
  {  412,   -1 }, /* (398) pseudo_column ::= WSTART */
  {  412,   -1 }, /* (399) pseudo_column ::= WEND */
  {  412,   -1 }, /* (400) pseudo_column ::= WDURATION */
  {  412,   -1 }, /* (401) pseudo_column ::= IROWTS */
  {  412,   -1 }, /* (402) pseudo_column ::= ISFILLED */
  {  412,   -1 }, /* (403) pseudo_column ::= QTAGS */
  {  414,   -4 }, /* (404) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  414,   -4 }, /* (405) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  414,   -6 }, /* (406) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  414,   -1 }, /* (407) function_expression ::= literal_func */
  {  408,   -3 }, /* (408) literal_func ::= noarg_func NK_LP NK_RP */
  {  408,   -1 }, /* (409) literal_func ::= NOW */
  {  418,   -1 }, /* (410) noarg_func ::= NOW */
  {  418,   -1 }, /* (411) noarg_func ::= TODAY */
  {  418,   -1 }, /* (412) noarg_func ::= TIMEZONE */
  {  418,   -1 }, /* (413) noarg_func ::= DATABASE */
  {  418,   -1 }, /* (414) noarg_func ::= CLIENT_VERSION */
  {  418,   -1 }, /* (415) noarg_func ::= SERVER_VERSION */
  {  418,   -1 }, /* (416) noarg_func ::= SERVER_STATUS */
  {  418,   -1 }, /* (417) noarg_func ::= CURRENT_USER */
  {  418,   -1 }, /* (418) noarg_func ::= USER */
  {  416,   -1 }, /* (419) star_func ::= COUNT */
  {  416,   -1 }, /* (420) star_func ::= FIRST */
  {  416,   -1 }, /* (421) star_func ::= LAST */
  {  416,   -1 }, /* (422) star_func ::= LAST_ROW */
  {  417,   -1 }, /* (423) star_func_para_list ::= NK_STAR */
  {  417,   -1 }, /* (424) star_func_para_list ::= other_para_list */
  {  419,   -1 }, /* (425) other_para_list ::= star_func_para */
  {  419,   -3 }, /* (426) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  420,   -1 }, /* (427) star_func_para ::= expr_or_subquery */
  {  420,   -3 }, /* (428) star_func_para ::= table_name NK_DOT NK_STAR */
  {  415,   -4 }, /* (429) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  415,   -5 }, /* (430) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  421,   -1 }, /* (431) when_then_list ::= when_then_expr */
  {  421,   -2 }, /* (432) when_then_list ::= when_then_list when_then_expr */
  {  424,   -4 }, /* (433) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  422,    0 }, /* (434) case_when_else_opt ::= */
  {  422,   -2 }, /* (435) case_when_else_opt ::= ELSE common_expression */
  {  425,   -3 }, /* (436) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  425,   -5 }, /* (437) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  425,   -6 }, /* (438) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  425,   -3 }, /* (439) predicate ::= expr_or_subquery IS NULL */
  {  425,   -4 }, /* (440) predicate ::= expr_or_subquery IS NOT NULL */
  {  425,   -3 }, /* (441) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  426,   -1 }, /* (442) compare_op ::= NK_LT */
  {  426,   -1 }, /* (443) compare_op ::= NK_GT */
  {  426,   -1 }, /* (444) compare_op ::= NK_LE */
  {  426,   -1 }, /* (445) compare_op ::= NK_GE */
  {  426,   -1 }, /* (446) compare_op ::= NK_NE */
  {  426,   -1 }, /* (447) compare_op ::= NK_EQ */
  {  426,   -1 }, /* (448) compare_op ::= LIKE */
  {  426,   -2 }, /* (449) compare_op ::= NOT LIKE */
  {  426,   -1 }, /* (450) compare_op ::= MATCH */
  {  426,   -1 }, /* (451) compare_op ::= NMATCH */
  {  426,   -1 }, /* (452) compare_op ::= CONTAINS */
  {  427,   -1 }, /* (453) in_op ::= IN */
  {  427,   -2 }, /* (454) in_op ::= NOT IN */
  {  428,   -3 }, /* (455) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  429,   -1 }, /* (456) boolean_value_expression ::= boolean_primary */
  {  429,   -2 }, /* (457) boolean_value_expression ::= NOT boolean_primary */
  {  429,   -3 }, /* (458) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  429,   -3 }, /* (459) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  430,   -1 }, /* (460) boolean_primary ::= predicate */
  {  430,   -3 }, /* (461) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  423,   -1 }, /* (462) common_expression ::= expr_or_subquery */
  {  423,   -1 }, /* (463) common_expression ::= boolean_value_expression */
  {  431,    0 }, /* (464) from_clause_opt ::= */
  {  431,   -2 }, /* (465) from_clause_opt ::= FROM table_reference_list */
  {  432,   -1 }, /* (466) table_reference_list ::= table_reference */
  {  432,   -3 }, /* (467) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  433,   -1 }, /* (468) table_reference ::= table_primary */
  {  433,   -1 }, /* (469) table_reference ::= joined_table */
  {  434,   -2 }, /* (470) table_primary ::= table_name alias_opt */
  {  434,   -4 }, /* (471) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  434,   -2 }, /* (472) table_primary ::= subquery alias_opt */
  {  434,   -1 }, /* (473) table_primary ::= parenthesized_joined_table */
  {  436,    0 }, /* (474) alias_opt ::= */
  {  436,   -1 }, /* (475) alias_opt ::= table_alias */
  {  436,   -2 }, /* (476) alias_opt ::= AS table_alias */
  {  438,   -3 }, /* (477) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  438,   -3 }, /* (478) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  435,   -6 }, /* (479) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  439,    0 }, /* (480) join_type ::= */
  {  439,   -1 }, /* (481) join_type ::= INNER */
  {  441,  -12 }, /* (482) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  442,    0 }, /* (483) set_quantifier_opt ::= */
  {  442,   -1 }, /* (484) set_quantifier_opt ::= DISTINCT */
  {  442,   -1 }, /* (485) set_quantifier_opt ::= ALL */
  {  443,   -1 }, /* (486) select_list ::= select_item */
  {  443,   -3 }, /* (487) select_list ::= select_list NK_COMMA select_item */
  {  451,   -1 }, /* (488) select_item ::= NK_STAR */
  {  451,   -1 }, /* (489) select_item ::= common_expression */
  {  451,   -2 }, /* (490) select_item ::= common_expression column_alias */
  {  451,   -3 }, /* (491) select_item ::= common_expression AS column_alias */
  {  451,   -3 }, /* (492) select_item ::= table_name NK_DOT NK_STAR */
  {  406,    0 }, /* (493) where_clause_opt ::= */
  {  406,   -2 }, /* (494) where_clause_opt ::= WHERE search_condition */
  {  444,    0 }, /* (495) partition_by_clause_opt ::= */
  {  444,   -3 }, /* (496) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  452,   -1 }, /* (497) partition_list ::= partition_item */
  {  452,   -3 }, /* (498) partition_list ::= partition_list NK_COMMA partition_item */
  {  453,   -1 }, /* (499) partition_item ::= expr_or_subquery */
  {  453,   -2 }, /* (500) partition_item ::= expr_or_subquery column_alias */
  {  453,   -3 }, /* (501) partition_item ::= expr_or_subquery AS column_alias */
  {  448,    0 }, /* (502) twindow_clause_opt ::= */
  {  448,   -6 }, /* (503) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  448,   -4 }, /* (504) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  448,   -6 }, /* (505) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  448,   -8 }, /* (506) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  448,   -7 }, /* (507) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  388,    0 }, /* (508) sliding_opt ::= */
  {  388,   -4 }, /* (509) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  447,    0 }, /* (510) fill_opt ::= */
  {  447,   -4 }, /* (511) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  447,   -6 }, /* (512) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  454,   -1 }, /* (513) fill_mode ::= NONE */
  {  454,   -1 }, /* (514) fill_mode ::= PREV */
  {  454,   -1 }, /* (515) fill_mode ::= NULL */
  {  454,   -1 }, /* (516) fill_mode ::= LINEAR */
  {  454,   -1 }, /* (517) fill_mode ::= NEXT */
  {  449,    0 }, /* (518) group_by_clause_opt ::= */
  {  449,   -3 }, /* (519) group_by_clause_opt ::= GROUP BY group_by_list */
  {  455,   -1 }, /* (520) group_by_list ::= expr_or_subquery */
  {  455,   -3 }, /* (521) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  450,    0 }, /* (522) having_clause_opt ::= */
  {  450,   -2 }, /* (523) having_clause_opt ::= HAVING search_condition */
  {  445,    0 }, /* (524) range_opt ::= */
  {  445,   -6 }, /* (525) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  446,    0 }, /* (526) every_opt ::= */
  {  446,   -4 }, /* (527) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  456,   -4 }, /* (528) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  457,   -1 }, /* (529) query_simple ::= query_specification */
  {  457,   -1 }, /* (530) query_simple ::= union_query_expression */
  {  461,   -4 }, /* (531) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  461,   -3 }, /* (532) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  462,   -1 }, /* (533) query_simple_or_subquery ::= query_simple */
  {  462,   -1 }, /* (534) query_simple_or_subquery ::= subquery */
  {  392,   -1 }, /* (535) query_or_subquery ::= query_expression */
  {  392,   -1 }, /* (536) query_or_subquery ::= subquery */
  {  458,    0 }, /* (537) order_by_clause_opt ::= */
  {  458,   -3 }, /* (538) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  459,    0 }, /* (539) slimit_clause_opt ::= */
  {  459,   -2 }, /* (540) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  459,   -4 }, /* (541) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  459,   -4 }, /* (542) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  460,    0 }, /* (543) limit_clause_opt ::= */
  {  460,   -2 }, /* (544) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  460,   -4 }, /* (545) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  460,   -4 }, /* (546) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  437,   -3 }, /* (547) subquery ::= NK_LP query_expression NK_RP */
  {  437,   -3 }, /* (548) subquery ::= NK_LP subquery NK_RP */
  {  440,   -1 }, /* (549) search_condition ::= common_expression */
  {  463,   -1 }, /* (550) sort_specification_list ::= sort_specification */
  {  463,   -3 }, /* (551) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  464,   -3 }, /* (552) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  465,    0 }, /* (553) ordering_specification_opt ::= */
  {  465,   -1 }, /* (554) ordering_specification_opt ::= ASC */
  {  465,   -1 }, /* (555) ordering_specification_opt ::= DESC */
  {  466,    0 }, /* (556) null_ordering_opt ::= */
  {  466,   -2 }, /* (557) null_ordering_opt ::= NULLS FIRST */
  {  466,   -2 }, /* (558) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy455, &yymsp[-1].minor.yy0, yymsp[0].minor.yy169); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy455, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy455, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy455, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy169 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy169 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy91, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy91, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy91 = yymsp[0].minor.yy91; }
  yymsp[0].minor.yy91 = yylhsminor.yy91;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy91 = yymsp[-2].minor.yy91 | yymsp[0].minor.yy91; }
  yymsp[-2].minor.yy91 = yylhsminor.yy91;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy91 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy455 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy455 = yylhsminor.yy455;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy455 = yymsp[-2].minor.yy455; }
  yymsp[-2].minor.yy455 = yylhsminor.yy455;
        break;
      case 42: /* priv_level ::= topic_name */
      case 273: /* sma_func_name ::= function_name */ yytestcase(yyruleno==273);
      case 475: /* alias_opt ::= table_alias */ yytestcase(yyruleno==475);
{ yylhsminor.yy455 = yymsp[0].minor.yy455; }
  yymsp[0].minor.yy455 = yylhsminor.yy455;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy455, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy163); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy163); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 274: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST */ yytestcase(yyruleno==276);
      case 277: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==277);
      case 360: /* db_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* table_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* column_name ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* function_name ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* table_alias ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* column_alias ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* user_name ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* topic_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 368: /* stream_name ::= NK_ID */ yytestcase(yyruleno==368);
      case 369: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==369);
      case 370: /* index_name ::= NK_ID */ yytestcase(yyruleno==370);
      case 410: /* noarg_func ::= NOW */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= TODAY */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==413);
      case 414: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==415);
      case 416: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==416);
      case 417: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==417);
      case 418: /* noarg_func ::= USER */ yytestcase(yyruleno==418);
      case 419: /* star_func ::= COUNT */ yytestcase(yyruleno==419);
      case 420: /* star_func ::= FIRST */ yytestcase(yyruleno==420);
      case 421: /* star_func ::= LAST */ yytestcase(yyruleno==421);
      case 422: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==422);
{ yylhsminor.yy455 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy455 = yylhsminor.yy455;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 294: /* analyze_opt ::= */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= */ yytestcase(yyruleno==301);
      case 483: /* set_quantifier_opt ::= */ yytestcase(yyruleno==483);
{ yymsp[1].minor.yy163 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 295: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==295);
      case 302: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==302);
      case 484: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==484);
{ yymsp[0].minor.yy163 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy163, &yymsp[-1].minor.yy455, yymsp[0].minor.yy44); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy44); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy832); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy163 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy163 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy44 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_KEEP, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_RETENTIONS, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-3].minor.yy44, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-3].minor.yy44, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy44 = setDatabaseOption(pCxt, yymsp[-2].minor.yy44, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy44 = createAlterDatabaseOptions(pCxt); yylhsminor.yy44 = setAlterDatabaseOption(pCxt, yylhsminor.yy44, &yymsp[0].minor.yy153); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy44 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy44, &yymsp[0].minor.yy153); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy153.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy153.type = DB_OPTION_KEEP; yymsp[-1].minor.yy153.pList = yymsp[0].minor.yy684; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_PAGES; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_WAL; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy153.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy684 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 329: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==329);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy684 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func */ yytestcase(yyruleno==270);
      case 358: /* literal_list ::= signed_literal */ yytestcase(yyruleno==358);
      case 425: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==425);
      case 431: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==431);
      case 486: /* select_list ::= select_item */ yytestcase(yyruleno==486);
      case 497: /* partition_list ::= partition_item */ yytestcase(yyruleno==497);
      case 550: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==550);
{ yylhsminor.yy684 = createNodeList(pCxt, yymsp[0].minor.yy44); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 257: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==257);
      case 271: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==271);
      case 359: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==359);
      case 426: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==426);
      case 487: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==487);
      case 498: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==498);
      case 551: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==551);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, yymsp[0].minor.yy44); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy44 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 127: /* speed_opt ::= */
      case 303: /* bufsize_opt ::= */ yytestcase(yyruleno==303);
{ yymsp[1].minor.yy832 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 304: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==304);
{ yymsp[-1].minor.yy832 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy163, yymsp[-5].minor.yy44, yymsp[-3].minor.yy684, yymsp[-1].minor.yy684, yymsp[0].minor.yy44); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy684); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy684); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy163, yymsp[0].minor.yy44); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 331: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==331);
      case 332: /* cmd ::= insert_query */ yytestcase(yyruleno==332);
{ pCxt->pRootNode = yymsp[0].minor.yy44; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy44); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy44 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy44 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy44, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy455); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy44 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy44 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy44, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy455); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy44 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy44 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy44, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy44 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy44, &yymsp[-2].minor.yy455, yymsp[0].minor.yy44); }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 432: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==432);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-1].minor.yy684, yymsp[0].minor.yy44); }
  yymsp[-1].minor.yy684 = yylhsminor.yy684;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy44 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy163, yymsp[-8].minor.yy44, yymsp[-6].minor.yy44, yymsp[-5].minor.yy684, yymsp[-2].minor.yy684, yymsp[0].minor.yy44); }
  yymsp[-9].minor.yy44 = yylhsminor.yy44;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy44 = createDropTableClause(pCxt, yymsp[-1].minor.yy163, yymsp[0].minor.yy44); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 255: /* tag_list_opt ::= */ yytestcase(yyruleno==255);
      case 307: /* col_list_opt ::= */ yytestcase(yyruleno==307);
      case 309: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==309);
      case 495: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==495);
      case 518: /* group_by_clause_opt ::= */ yytestcase(yyruleno==518);
      case 537: /* order_by_clause_opt ::= */ yytestcase(yyruleno==537);
{ yymsp[1].minor.yy684 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 308: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==308);
{ yymsp[-2].minor.yy684 = yymsp[-1].minor.yy684; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy44 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy455, NULL); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy44 = createRealTableNode(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455, NULL); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy44 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy455, yymsp[0].minor.yy260, NULL); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy44 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy455, yymsp[-2].minor.yy260, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy260 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy260 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy260 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy260 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 310: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==310);
      case 424: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==424);
{ yylhsminor.yy684 = yymsp[0].minor.yy684; }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 311: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==311);
{ yymsp[-3].minor.yy684 = yymsp[-1].minor.yy684; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy44 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-4].minor.yy44, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy684); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-4].minor.yy44, TABLE_OPTION_SMA, yymsp[-1].minor.yy684); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-2].minor.yy44, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy684); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy44 = createAlterTableOptions(pCxt); yylhsminor.yy44 = setTableOption(pCxt, yylhsminor.yy44, yymsp[0].minor.yy153.type, &yymsp[0].minor.yy153.val); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy44 = setTableOption(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy153.type, &yymsp[0].minor.yy153.val); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy153.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy153.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy153.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 388: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==388);
{ yylhsminor.yy684 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy44)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 389: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==389);
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, releaseRawExprNode(pCxt, yymsp[0].minor.yy44)); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy44 = createFunctionNode(pCxt, &yymsp[0].minor.yy455, NULL); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 259: /* tag_item ::= QTAGS */ yytestcase(yyruleno==259);
{ yylhsminor.yy44 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 207: /* col_name ::= column_name */
      case 260: /* tag_item ::= column_name */ yytestcase(yyruleno==260);
{ yylhsminor.yy44 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy455); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy44, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy44, yymsp[-1].minor.yy44, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy44); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy44); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy44); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy44); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy44, yymsp[-1].minor.yy44, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy44, yymsp[-3].minor.yy684); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy44,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 247: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 248: /* db_name_cond_opt ::= */
      case 253: /* from_db_opt ::= */ yytestcase(yyruleno==253);
{ yymsp[1].minor.yy44 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 249: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy44 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 250: /* like_pattern_opt ::= */
      case 319: /* subtable_opt ::= */ yytestcase(yyruleno==319);
      case 434: /* case_when_else_opt ::= */ yytestcase(yyruleno==434);
      case 464: /* from_clause_opt ::= */ yytestcase(yyruleno==464);
      case 493: /* where_clause_opt ::= */ yytestcase(yyruleno==493);
      case 502: /* twindow_clause_opt ::= */ yytestcase(yyruleno==502);
      case 508: /* sliding_opt ::= */ yytestcase(yyruleno==508);
      case 510: /* fill_opt ::= */ yytestcase(yyruleno==510);
      case 522: /* having_clause_opt ::= */ yytestcase(yyruleno==522);
      case 524: /* range_opt ::= */ yytestcase(yyruleno==524);
      case 526: /* every_opt ::= */ yytestcase(yyruleno==526);
      case 539: /* slimit_clause_opt ::= */ yytestcase(yyruleno==539);
      case 543: /* limit_clause_opt ::= */ yytestcase(yyruleno==543);
{ yymsp[1].minor.yy44 = NULL; }
        break;
      case 251: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 252: /* table_name_cond ::= table_name */
{ yylhsminor.yy44 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy455); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 254: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy44 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy455); }
        break;
      case 258: /* tag_item ::= TBNAME */
{ yylhsminor.yy44 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 261: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy44 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy455), &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 262: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy44 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy455), &yymsp[0].minor.yy455); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 263: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy163, yymsp[-3].minor.yy44, yymsp[-1].minor.yy44, NULL, yymsp[0].minor.yy44); }
        break;
      case 264: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy163, yymsp[-5].minor.yy44, yymsp[-3].minor.yy44, yymsp[-1].minor.yy684, NULL); }
        break;
      case 265: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy163, yymsp[0].minor.yy44); }
        break;
      case 266: /* full_index_name ::= index_name */
{ yylhsminor.yy44 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy455); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 267: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy44 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy44 = createIndexOption(pCxt, yymsp[-7].minor.yy684, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), NULL, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 269: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy44 = createIndexOption(pCxt, yymsp[-9].minor.yy684, releaseRawExprNode(pCxt, yymsp[-5].minor.yy44), releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 272: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy44 = createFunctionNode(pCxt, &yymsp[-3].minor.yy455, yymsp[-1].minor.yy684); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 278: /* sma_stream_opt ::= */
      case 312: /* stream_options ::= */ yytestcase(yyruleno==312);
{ yymsp[1].minor.yy44 = createStreamOptions(pCxt); }
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 316: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==316);
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 281: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy163, &yymsp[-2].minor.yy455, yymsp[0].minor.yy44); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy163, &yymsp[-3].minor.yy455, &yymsp[0].minor.yy455, false); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy163, &yymsp[-5].minor.yy455, &yymsp[0].minor.yy455, true); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy163, &yymsp[-3].minor.yy455, yymsp[0].minor.yy44, false); }
        break;
      case 286: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy163, &yymsp[-5].minor.yy455, yymsp[0].minor.yy44, true); }
        break;
      case 287: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 288: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy163, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455); }
        break;
      case 289: /* cmd ::= DESC full_table_name */
      case 290: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==290);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy44); }
        break;
      case 291: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 293: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==293);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy163, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 296: /* explain_options ::= */
{ yymsp[1].minor.yy44 = createDefaultExplainOptions(pCxt); }
        break;
      case 297: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy44 = setExplainVerbose(pCxt, yymsp[-2].minor.yy44, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 298: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy44 = setExplainRatio(pCxt, yymsp[-2].minor.yy44, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 299: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy163, yymsp[-8].minor.yy163, &yymsp[-5].minor.yy455, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy260, yymsp[0].minor.yy832); }
        break;
      case 300: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 305: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy163, &yymsp[-8].minor.yy455, yymsp[-5].minor.yy44, yymsp[-7].minor.yy44, yymsp[-3].minor.yy684, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, yymsp[-4].minor.yy684); }
        break;
      case 306: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy163, &yymsp[0].minor.yy455); }
        break;
      case 313: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 314: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 315: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy44)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy44)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); yylhsminor.yy44 = yymsp[-3].minor.yy44; }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 317: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy44)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy44 = yymsp[-3].minor.yy44; }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 318: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy44)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy44 = yymsp[-2].minor.yy44; }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 320: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 509: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==509);
      case 527: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==527);
{ yymsp[-3].minor.yy44 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy44); }
        break;
      case 321: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 322: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 323: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 324: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 325: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 326: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy684); }
        break;
      case 327: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 328: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy684 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 330: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 333: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy44 = createInsertStmt(pCxt, yymsp[-4].minor.yy44, yymsp[-2].minor.yy684, yymsp[0].minor.yy44); }
        break;
      case 334: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy44 = createInsertStmt(pCxt, yymsp[-1].minor.yy44, NULL, yymsp[0].minor.yy44); }
        break;
      case 335: /* literal ::= NK_INTEGER */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 336: /* literal ::= NK_FLOAT */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 337: /* literal ::= NK_STRING */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 338: /* literal ::= NK_BOOL */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 339: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 340: /* literal ::= duration_literal */
      case 350: /* signed_literal ::= signed */ yytestcase(yyruleno==350);
      case 371: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==371);
      case 372: /* expression ::= literal */ yytestcase(yyruleno==372);
      case 373: /* expression ::= pseudo_column */ yytestcase(yyruleno==373);
      case 374: /* expression ::= column_reference */ yytestcase(yyruleno==374);
      case 375: /* expression ::= function_expression */ yytestcase(yyruleno==375);
      case 376: /* expression ::= case_when_expression */ yytestcase(yyruleno==376);
      case 407: /* function_expression ::= literal_func */ yytestcase(yyruleno==407);
      case 456: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==456);
      case 460: /* boolean_primary ::= predicate */ yytestcase(yyruleno==460);
      case 462: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==462);
      case 463: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==463);
      case 466: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==466);
      case 468: /* table_reference ::= table_primary */ yytestcase(yyruleno==468);
      case 469: /* table_reference ::= joined_table */ yytestcase(yyruleno==469);
      case 473: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==473);
      case 529: /* query_simple ::= query_specification */ yytestcase(yyruleno==529);
      case 530: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==530);
      case 533: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==533);
      case 535: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==535);
{ yylhsminor.yy44 = yymsp[0].minor.yy44; }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 341: /* literal ::= NULL */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 342: /* literal ::= NK_QUESTION */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 343: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 344: /* signed ::= NK_INTEGER */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 345: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 346: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 347: /* signed ::= NK_FLOAT */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 348: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 349: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 351: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 352: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 353: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 354: /* signed_literal ::= duration_literal */
      case 356: /* signed_literal ::= literal_func */ yytestcase(yyruleno==356);
      case 427: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==427);
      case 489: /* select_item ::= common_expression */ yytestcase(yyruleno==489);
      case 499: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==499);
      case 534: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==534);
      case 536: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==536);
      case 549: /* search_condition ::= common_expression */ yytestcase(yyruleno==549);
{ yylhsminor.yy44 = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 355: /* signed_literal ::= NULL */
{ yylhsminor.yy44 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 357: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy44 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 377: /* expression ::= NK_LP expression NK_RP */
      case 461: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==461);
      case 548: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==548);
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 378: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy44));
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 379: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy44), NULL));
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 380: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 381: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 382: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 383: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 384: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 385: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 386: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 387: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 390: /* column_reference ::= column_name */
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy455, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy455)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 391: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455, createColumnNode(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy455)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 392: /* pseudo_column ::= ROWTS */
      case 393: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==393);
      case 395: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= QEND */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==398);
      case 399: /* pseudo_column ::= WEND */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==400);
      case 401: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==401);
      case 402: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==402);
      case 403: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==403);
      case 409: /* literal_func ::= NOW */ yytestcase(yyruleno==409);
{ yylhsminor.yy44 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 394: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy455)))); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 404: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 405: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==405);
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy455, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy455, yymsp[-1].minor.yy684)); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 406: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-1].minor.yy260)); }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 408: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy455, NULL)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 423: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy684 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 428: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 492: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==492);
{ yylhsminor.yy44 = createColumnNode(pCxt, &yymsp[-2].minor.yy455, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 429: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy684, yymsp[-1].minor.yy44)); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 430: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-2].minor.yy684, yymsp[-1].minor.yy44)); }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 433: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy44 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)); }
        break;
      case 435: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy44 = releaseRawExprNode(pCxt, yymsp[0].minor.yy44); }
        break;
      case 436: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 441: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==441);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy704, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 437: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy44), releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-4].minor.yy44 = yylhsminor.yy44;
        break;
      case 438: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy44), releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 439: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), NULL));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 440: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), NULL));
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 442: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy704 = OP_TYPE_LOWER_THAN; }
        break;
      case 443: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy704 = OP_TYPE_GREATER_THAN; }
        break;
      case 444: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy704 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 445: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy704 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 446: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy704 = OP_TYPE_NOT_EQUAL; }
        break;
      case 447: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy704 = OP_TYPE_EQUAL; }
        break;
      case 448: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy704 = OP_TYPE_LIKE; }
        break;
      case 449: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy704 = OP_TYPE_NOT_LIKE; }
        break;
      case 450: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy704 = OP_TYPE_MATCH; }
        break;
      case 451: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy704 = OP_TYPE_NMATCH; }
        break;
      case 452: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy704 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 453: /* in_op ::= IN */
{ yymsp[0].minor.yy704 = OP_TYPE_IN; }
        break;
      case 454: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy704 = OP_TYPE_NOT_IN; }
        break;
      case 455: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy684)); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 457: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy44), NULL));
                                                                                  }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 458: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 459: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy44);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy44);
                                                                                    yylhsminor.yy44 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), releaseRawExprNode(pCxt, yymsp[0].minor.yy44)));
                                                                                  }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 465: /* from_clause_opt ::= FROM table_reference_list */
      case 494: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==494);
      case 523: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==523);
{ yymsp[-1].minor.yy44 = yymsp[0].minor.yy44; }
        break;
      case 467: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy44 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy44, yymsp[0].minor.yy44, NULL); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 470: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy44 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 471: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy44 = createRealTableNode(pCxt, &yymsp[-3].minor.yy455, &yymsp[-1].minor.yy455, &yymsp[0].minor.yy455); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 472: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy44 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44), &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 474: /* alias_opt ::= */
{ yymsp[1].minor.yy455 = nil_token;  }
        break;
      case 476: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy455 = yymsp[0].minor.yy455; }
        break;
      case 477: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 478: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==478);
{ yymsp[-2].minor.yy44 = yymsp[-1].minor.yy44; }
        break;
      case 479: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy44 = createJoinTableNode(pCxt, yymsp[-4].minor.yy724, yymsp[-5].minor.yy44, yymsp[-2].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-5].minor.yy44 = yylhsminor.yy44;
        break;
      case 480: /* join_type ::= */
{ yymsp[1].minor.yy724 = JOIN_TYPE_INNER; }
        break;
      case 481: /* join_type ::= INNER */
{ yymsp[0].minor.yy724 = JOIN_TYPE_INNER; }
        break;
      case 482: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy44 = createSelectStmt(pCxt, yymsp[-10].minor.yy163, yymsp[-9].minor.yy684, yymsp[-8].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addWhereClause(pCxt, yymsp[-11].minor.yy44, yymsp[-7].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addPartitionByClause(pCxt, yymsp[-11].minor.yy44, yymsp[-6].minor.yy684);
                                                                                    yymsp[-11].minor.yy44 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy44, yymsp[-2].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addGroupByClause(pCxt, yymsp[-11].minor.yy44, yymsp[-1].minor.yy684);
                                                                                    yymsp[-11].minor.yy44 = addHavingClause(pCxt, yymsp[-11].minor.yy44, yymsp[0].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addRangeClause(pCxt, yymsp[-11].minor.yy44, yymsp[-5].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addEveryClause(pCxt, yymsp[-11].minor.yy44, yymsp[-4].minor.yy44);
                                                                                    yymsp[-11].minor.yy44 = addFillClause(pCxt, yymsp[-11].minor.yy44, yymsp[-3].minor.yy44);
                                                                                  }
        break;
      case 485: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy163 = false; }
        break;
      case 488: /* select_item ::= NK_STAR */
{ yylhsminor.yy44 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy44 = yylhsminor.yy44;
        break;
      case 490: /* select_item ::= common_expression column_alias */
      case 500: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==500);
{ yylhsminor.yy44 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44), &yymsp[0].minor.yy455); }
  yymsp[-1].minor.yy44 = yylhsminor.yy44;
        break;
      case 491: /* select_item ::= common_expression AS column_alias */
      case 501: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==501);
{ yylhsminor.yy44 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), &yymsp[0].minor.yy455); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 496: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 519: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==519);
      case 538: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==538);
{ yymsp[-2].minor.yy684 = yymsp[0].minor.yy684; }
        break;
      case 503: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy44 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
        break;
      case 504: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy44 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
        break;
      case 505: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy44 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), NULL, yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 506: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy44 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy44), releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), yymsp[-1].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 507: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy44 = createEventWindowNode(pCxt, yymsp[-3].minor.yy44, yymsp[0].minor.yy44); }
        break;
      case 511: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy44 = createFillNode(pCxt, yymsp[-1].minor.yy22, NULL); }
        break;
      case 512: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy44 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy684)); }
        break;
      case 513: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy22 = FILL_MODE_NONE; }
        break;
      case 514: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy22 = FILL_MODE_PREV; }
        break;
      case 515: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy22 = FILL_MODE_NULL; }
        break;
      case 516: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy22 = FILL_MODE_LINEAR; }
        break;
      case 517: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy22 = FILL_MODE_NEXT; }
        break;
      case 520: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy684 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); }
  yymsp[0].minor.yy684 = yylhsminor.yy684;
        break;
      case 521: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy684 = addNodeToList(pCxt, yymsp[-2].minor.yy684, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy44))); }
  yymsp[-2].minor.yy684 = yylhsminor.yy684;
        break;
      case 525: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy44 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy44), releaseRawExprNode(pCxt, yymsp[-1].minor.yy44)); }
        break;
      case 528: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy44 = addOrderByClause(pCxt, yymsp[-3].minor.yy44, yymsp[-2].minor.yy684);
                                                                                    yylhsminor.yy44 = addSlimitClause(pCxt, yylhsminor.yy44, yymsp[-1].minor.yy44);
                                                                                    yylhsminor.yy44 = addLimitClause(pCxt, yylhsminor.yy44, yymsp[0].minor.yy44);
                                                                                  }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 531: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy44 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-3].minor.yy44 = yylhsminor.yy44;
        break;
      case 532: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy44 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy44, yymsp[0].minor.yy44); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 540: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 544: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==544);
{ yymsp[-1].minor.yy44 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 541: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 545: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==545);
{ yymsp[-3].minor.yy44 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 542: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 546: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==546);
{ yymsp[-3].minor.yy44 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 547: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy44 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy44); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 552: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy44 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy44), yymsp[-1].minor.yy490, yymsp[0].minor.yy23); }
  yymsp[-2].minor.yy44 = yylhsminor.yy44;
        break;
      case 553: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy490 = ORDER_ASC; }
        break;
      case 554: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy490 = ORDER_ASC; }
        break;
      case 555: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy490 = ORDER_DESC; }
        break;
      case 556: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy23 = NULL_ORDER_DEFAULT; }
        break;
      case 557: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy23 = NULL_ORDER_FIRST; }
        break;
      case 558: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy23 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
