---
title: 配置参数
description: "TDengine 客户端和服务配置列表"
---

## 为服务端指定配置文件

TDengine 系统后台服务由 taosd 提供，可以在配置文件 taos.cfg 里修改配置参数，以满足不同场景的需求。配置文件的缺省位置在/etc/taos 目录，可以通过 taosd 命令行执行参数 -c 指定配置文件目录。比如，指定配置文件位于`/home/user` 这个目录：

```
taosd -c /home/user
```

另外可以使用 `-C` 显示当前服务器配置参数：

```
taosd -C
```

## 为客户端指定配置文件

TDengine 系统的前台交互客户端应用程序为 taos，以及应用驱动，它可以与 taosd 共享同一个配置文件 taos.cfg，也可以使用单独指定配置文件。运行 taos 时，使用参数-c 指定配置文件目录，如 taos -c /home/cfg，表示使用/home/cfg/目录下的 taos.cfg 配置文件中的参数，缺省目录是/etc/taos。更多 taos 的使用方法请见帮助信息 `taos --help`。

```bash
taos -C
```

```bash
taos --dump-config
```

# 配置参数详细列表

:::note
本节内容覆盖产品的配置参数，适用于服务端的参数按其对产品行为的影响进行分类，这其中有部分参数也同时适用于客户端；但有少量参数仅适用于客户端，这部分参数进行了单独归类。

:::

:::note
配置文件参数修改后，需要重启*taosd*服务，或客户端应用才能生效。

:::

## 连接相关

### firstEp

| 属性     | 说明                                                           |
| -------- | -------------------------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                                           |
| 含义     | taosd 或者 taos 启动时，主动连接的集群中首个 dnode 的 endpoint |
| 缺省值   | localhost:6030                                                 |

### secondEp

| 属性     | 说明                                                                                  |
| -------- | ------------------------------------------------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                                                                  |
| 含义     | taosd 或者 taos 启动时，如果 firstEp 连接不上，尝试连接集群中第二个 dnode 的 endpoint |
| 缺省值   | 无                                                                                    |

### fqdn

| 属性     | 说明                                                              |
| -------- | ----------------------------------------------------------------- |
| 适用范围 | 仅服务端适用                                                      |
| 含义     | 数据节点的 FQDN。如果习惯 IP 地址访问，可设置为该节点的 IP 地址。 |
| 缺省值   | 缺省为操作系统配置的第一个 hostname。                             |
| 补充说明 | 这个参数值的长度需要控制在 96 个字符以内。                        |

### serverPort

| 属性     | 说明                                                                                                                    |
| -------- | ----------------------------------------------------------------------------------------------------------------------- |
| 适用范围 | 仅服务端适用                                                                                                            |
| 含义     | taosd 启动后，对外服务的端口号                                                                                          |
| 缺省值   | 6030                                                                                                                    |

:::note
确保集群中所有主机在端口 6030 上的 TCP 协议能够互通。（详细的端口情况请参见下表）
:::
| 协议 | 默认端口 | 用途说明 | 修改方法 |
| :--- | :-------- | :---------------------------------- | :--------------------------------------------------------------------------------------------------------------------------------- |
| TCP | 6030 | 客户端与服务端之间通讯，多节点集群的节点间通讯。 | 由配置文件设置 serverPort 决定。 |
| TCP | 6041 | 客户端与服务端之间的 RESTful 通讯。 | 随 serverPort 端口变化。注意 taosAdapter 配置或有不同，请参考相应[文档](/reference/taosadapter/)。 |
| TCP | 6043 | TaosKeeper 监控服务端口。 | 随 TaosKeeper 启动参数设置变化。 |
| TCP | 6044 | 支持 StatsD 的数据接入端口。 | 随 taosAdapter 启动参数设置变化|
| UDP | 6045 | 支持 collectd 数据接入端口。 | 随 taosAdapter 启动参数设置变化 |
| TCP | 6060 | 企业版内 Monitor 服务的网络端口。 | |

### maxShellConns

| 属性     | 说明                    |
| -------- | ----------------------- |
| 适用范围 | 仅服务端适用            |
| 含义     | 一个 dnode 容许的连接数 |
| 取值范围 | 10-50000000             |
| 缺省值   | 5000                    |

## 监控相关

### monitor

| 属性     | 说明                                                                                                                                                                                               |
| -------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 适用范围 | 仅服务端适用                                                                                                                                                                                       |
| 含义     | 服务器内部的系统监控开关。监控主要负责收集物理节点的负载状况，包括 CPU、内存、硬盘、网络带宽的监控记录，监控信息将通过 HTTP 协议发送给由 `monitorFqdn` 和 `monitorProt` 指定的 TaosKeeper 监控服务 |
| 取值范围 | 0：关闭监控服务， 1：激活监控服务。                                                                                                                                                                |
| 缺省值   | 1                                                                                                                                                                                                  |

### monitorFqdn

| 属性     | 说明                       |
| -------- | -------------------------- |
| 适用范围 | 仅服务端适用               |
| 含义     | TaosKeeper 监控服务的 FQDN |
| 缺省值   | 无                         |

### monitorPort

| 属性     | 说明                        |
| -------- | --------------------------- |
| 适用范围 | 仅服务端适用                |
| 含义     | TaosKeeper 监控服务的端口号 |
| 缺省值   | 6043                        |

### monitorInterval

| 属性     | 说明                                         |
| -------- | -------------------------------------------- |
| 适用范围 | 仅服务端适用                                 |
| 含义     | 监控数据库记录系统参数（CPU/内存）的时间间隔 |
| 单位     | 秒                                           |
| 取值范围 | 1-200000                                     |
| 缺省值   | 30                                           |

### telemetryReporting

| 属性     | 说明                                     |
| -------- | ---------------------------------------- |
| 适用范围 | 仅服务端适用                             |
| 含义     | 是否允许 TDengine 采集和上报基本使用信息 |
| 取值范围 | 0：不允许 1：允许                        |
| 缺省值   | 1                                        |

## 查询相关

### queryPolicy

| 属性     | 说明                          |
| -------- | ----------------------------- |
| 适用范围 | 仅客户端适用                  |
| 含义     | 查询语句的执行策略            |
| 单位     | 无                            |
| 缺省值   | 1                             |
| 补充说明 | 1: 只使用 vnode，不使用 qnode |

2: 没有扫描算子的子任务在 qnode 执行，带扫描算子的子任务在 vnode 执行

3: vnode 只运行扫描算子，其余算子均在 qnode 执行 |

### querySmaOptimize

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 仅客户端适用         |
| 含义     | sma index 的优化策略 |
| 单位     | 无                   |
| 缺省值   | 0                    |
| 补充说明 |

0: 表示不使用 sma index，永远从原始数据进行查询

1: 表示使用 sma index，对符合的语句，直接从预计算的结果进行查询 |


### maxNumOfDistinctRes

| 属性     | 说明                             |
| -------- | -------------------------------- | --- |
| 适用范围 | 仅服务端适用                     |
| 含义     | 允许返回的 distinct 结果最大行数 |
| 取值范围 | 默认值为 10 万，最大值 1 亿      |
| 缺省值   | 10 万                            |

## 区域相关

### timezone

| 属性     | 说明                           |
| -------- | ------------------------------ |
| 适用范围 | 服务端和客户端均适用           |
| 含义     | 时区                           |
| 缺省值   | 从系统中动态获取当前的时区设置 |

:::info
为应对多时区的数据写入和查询问题，TDengine 采用 Unix 时间戳(Unix Timestamp)来记录和存储时间戳。Unix 时间戳的特点决定了任一时刻不论在任何时区，产生的时间戳均一致。需要注意的是，Unix 时间戳是在客户端完成转换和记录。为了确保客户端其他形式的时间转换为正确的 Unix 时间戳，需要设置正确的时区。

在 Linux 系统中，客户端会自动读取系统设置的时区信息。用户也可以采用多种方式在配置文件设置时区。例如：

```
timezone UTC-8
timezone GMT-8
timezone Asia/Shanghai
```

均是合法的设置东八区时区的格式。但需注意，Windows 下并不支持 `timezone Asia/Shanghai` 这样的写法，而必须写成 `timezone UTC-8`。

时区的设置对于查询和写入 SQL 语句中非 Unix 时间戳的内容（时间戳字符串、关键词 now 的解析）产生影响。例如：

```sql
SELECT count(*) FROM table_name WHERE TS<'2019-04-11 12:01:08';
```

在东八区，SQL 语句等效于

```sql
SELECT count(*) FROM table_name WHERE TS<1554955268000;
```

在 UTC 时区，SQL 语句等效于

```sql
SELECT count(*) FROM table_name WHERE TS<1554984068000;
```

为了避免使用字符串时间格式带来的不确定性，也可以直接使用 Unix 时间戳。此外，还可以在 SQL 语句中使用带有时区的时间戳字符串，例如：RFC3339 格式的时间戳字符串，2013-04-12T15:52:01.123+08:00 或者 ISO-8601 格式时间戳字符串 2013-04-12T15:52:01.123+0800。上述两个字符串转化为 Unix 时间戳不受系统所在时区的影响。

:::

### locale

| 属性     | 说明                                                                    |
| -------- | ----------------------------------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                                                    |
| 含义     | 系统区位信息及编码格式                                                  |
| 缺省值   | 系统中动态获取，如果自动获取失败，需要用户在配置文件设置或通过 API 设置 |

:::info
TDengine 为存储中文、日文、韩文等非 ASCII 编码的宽字符，提供一种专门的字段类型 nchar。写入 nchar 字段的数据将统一采用 UCS4-LE 格式进行编码并发送到服务器。需要注意的是，编码正确性是客户端来保证。因此，如果用户想要正常使用 nchar 字段来存储诸如中文、日文、韩文等非 ASCII 字符，需要正确设置客户端的编码格式。

客户端的输入的字符均采用操作系统当前默认的编码格式，在 Linux 系统上多为 UTF-8，部分中文系统编码则可能是 GB18030 或 GBK 等。在 docker 环境中默认的编码是 POSIX。在中文版 Windows 系统中，编码则是 CP936。客户端需要确保正确设置自己所使用的字符集，即客户端运行的操作系统当前编码字符集，才能保证 nchar 中的数据正确转换为 UCS4-LE 编码格式。

在 Linux 中 locale 的命名规则为: <语言>\_<地区>.<字符集编码> 如：zh_CN.UTF-8，zh 代表中文，CN 代表大陆地区，UTF-8 表示字符集。字符集编码为客户端正确解析本地字符串提供编码转换的说明。Linux 系统与 Mac OSX 系统可以通过设置 locale 来确定系统的字符编码，由于 Windows 使用的 locale 中不是 POSIX 标准的 locale 格式，因此在 Windows 下需要采用另一个配置参数 charset 来指定字符编码。在 Linux 系统中也可以使用 charset 来指定字符编码。

:::

### charset

| 属性     | 说明                                                                    |
| -------- | ----------------------------------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                                                    |
| 含义     | 字符集编码                                                              |
| 缺省值   | 系统中动态获取，如果自动获取失败，需要用户在配置文件设置或通过 API 设置 |

:::info
如果配置文件中不设置 charset，在 Linux 系统中，taos 在启动时候，自动读取系统当前的 locale 信息，并从 locale 信息中解析提取 charset 编码格式。如果自动读取 locale 信息失败，则尝试读取 charset 配置，如果读取 charset 配置也失败，则中断启动过程。

在 Linux 系统中，locale 信息包含了字符编码信息，因此正确设置了 Linux 系统 locale 以后可以不用再单独设置 charset。例如：

```
locale zh_CN.UTF-8
```

在 Windows 系统中，无法从 locale 获取系统当前编码。如果无法从配置文件中读取字符串编码信息，taos 默认设置为字符编码为 CP936。其等效在配置文件中添加如下配置：

```
charset CP936
```

如果需要调整字符编码，请查阅当前操作系统使用的编码，并在配置文件中正确设置。

在 Linux 系统中，如果用户同时设置了 locale 和字符集编码 charset，并且 locale 和 charset 的不一致，后设置的值将覆盖前面设置的值。

```
locale zh_CN.UTF-8
charset GBK
```

则 charset 的有效值是 GBK。

```
charset GBK
locale zh_CN.UTF-8
```

charset 的有效值是 UTF-8。

:::

## 存储相关

### dataDir

| 属性     | 说明                                       |
| -------- | ------------------------------------------ |
| 适用范围 | 仅服务端适用                               |
| 含义     | 数据文件目录，所有的数据文件都将写入该目录 |
| 缺省值   | /var/lib/taos                              |

### minimalTmpDirGB

| 属性     | 说明                                             |
| -------- | ------------------------------------------------ |
| 适用范围 | 服务端和客户端均适用                             |
| 含义     | 当日志文件夹的磁盘大小小于该值时，停止写临时文件 |
| 单位     | GB                                               |
| 缺省值   | 1.0                                              |

### minimalDataDirGB

| 属性     | 说明                                             |
| -------- | ------------------------------------------------ |
| 适用范围 | 仅服务端适用                                     |
| 含义     | 当日志文件夹的磁盘大小小于该值时，停止写时序数据 |
| 单位     | GB                                               |
| 缺省值   | 2.0                                              |

## 集群相关

### supportVnodes

| 属性     | 说明                        |
| -------- | --------------------------- |
| 适用范围 | 仅服务端适用                |
| 含义     | dnode 支持的最大 vnode 数目 |
| 取值范围 | 0-4096                      |
| 缺省值   | 256                         |

## 时间相关

### statusInterval

| 属性     | 说明                        |
| -------- | --------------------------- |
| 适用范围 | 仅服务端适用                |
| 含义     | dnode 向 mnode 报告状态间隔 |
| 单位     | 秒                          |
| 取值范围 | 1-10                        |
| 缺省值   | 1                           |

### shellActivityTimer

| 属性     | 说明                              |
| -------- | --------------------------------- |
| 适用范围 | 服务端和客户端均适用              |
| 含义     | shell 客户端向 mnode 发送心跳间隔 |
| 单位     | 秒                                |
| 取值范围 | 1-120                             |
| 缺省值   | 3                                 |

## 性能调优

### numOfCommitThreads

| 属性     | 说明                   |
| -------- | ---------------------- |
| 适用范围 | 仅服务端适用           |
| 含义     | 设置写入线程的最大数量 |
| 缺省值   |                        |

## 压缩相关

### compressMsgSize

| 属性     | 说明                                                                                                                                           |
| -------- | ---------------------------------------------------------------------------------------------------------------------------------------------- |
| 适用范围 | 仅服务端适用                                                                                                                                   |
| 含义     | 客户端与服务器之间进行消息通讯过程中，对通讯的消息进行压缩的阈值。如果要压缩消息，建议设置为 64330 字节，即大于 64330 字节的消息体才进行压缩。 |
| 单位     | bytes                                                                                                                                          |
| 取值范围 | `0 `表示对所有的消息均进行压缩 >0: 超过该值的消息才进行压缩 -1: 不压缩                                                                         |
| 缺省值   | -1                                                                                                                                             |

### compressColData

| 属性     | 说明                                                                                    |
| -------- | --------------------------------------------------------------------------------------- |
| 适用范围 | 仅服务端适用                                                                            |
| 含义     | 客户端与服务器之间进行消息通讯过程中，对服务器端查询结果进行列压缩的阈值。              |
| 单位     | bytes                                                                                   |
| 取值范围 | 0: 对所有查询结果均进行压缩 >0: 查询结果中任意列大小超过该值的消息才进行压缩 -1: 不压缩 |
| 缺省值   | -1                                                                                      |

## 日志相关

### logDir

| 属性     | 说明                                               |
| -------- | -------------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                               |
| 含义     | 日志文件目录，客户端和服务器的运行日志将写入该目录 |
| 缺省值   | /var/log/taos                                      |

### minimalLogDirGB

| 属性     | 说明                                         |
| -------- | -------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                         |
| 含义     | 当日志文件夹的磁盘大小小于该值时，停止写日志 |
| 单位     | GB                                           |
| 缺省值   | 1.0                                          |

### numOfLogLines

| 属性     | 说明                         |
| -------- | ---------------------------- |
| 适用范围 | 服务端和客户端均适用         |
| 含义     | 单个日志文件允许的最大行数。 |
| 缺省值   | 10,000,000                   |

### asyncLog

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 服务端和客户端均适用 |
| 含义     | 日志写入模式         |
| 取值范围 | 0：同步、1：异步     |
| 缺省值   | 1                    |

### logKeepDays

| 属性     | 说明                                                                                |
| -------- | ----------------------------------------------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                                                                |
| 含义     | 日志文件的最长保存时间                                                              |
| 单位     | 天                                                                                  |
| 缺省值   | 0                                                                                   |
| 补充说明 | 大于 0 时，日志文件会被重命名为 taosdlog.xxx，其中 xxx 为日志文件最后修改的时间戳。 |

### debugFlag

| 属性     | 说明                                                                                              |
| -------- | ------------------------------------------------------------------------------------------------- |
| 适用范围 | 服务端和客户端均适用                                                                              |
| 含义     | 运行日志开关                                                                                      |
| 取值范围 | 131（输出错误和警告日志），135（输出错误、警告和调试日志），143（输出错误、警告、调试和跟踪日志） |
| 缺省值   | 131 或 135（不同模块有不同的默认值）                                                              |

### tmrDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 服务端和客户端均适用 |
| 含义     | 定时器模块的日志开关 |
| 取值范围 | 同上                 |
| 缺省值   |                      |

### uDebugFlag

| 属性     | 说明                   |
| -------- | ---------------------- |
| 适用范围 | 服务端和客户端均适用   |
| 含义     | 共用功能模块的日志开关 |
| 取值范围 | 同上                   |
| 缺省值   |                        |

### rpcDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 服务端和客户端均适用 |
| 含义     | rpc 模块的日志开关   |
| 取值范围 | 同上                 |
| 缺省值   |                      |

### jniDebugFlag

| 属性     | 说明               |
| -------- | ------------------ |
| 适用范围 | 仅客户端适用       |
| 含义     | jni 模块的日志开关 |
| 取值范围 | 同上               |
| 缺省值   |                    |

### qDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 服务端和客户端均适用 |
| 含义     | query 模块的日志开关 |
| 取值范围 | 同上                 |
| 缺省值   |                      |

### cDebugFlag

| 属性     | 说明                  |
| -------- | --------------------- |
| 适用范围 | 仅客户端适用          |
| 含义     | client 模块的日志开关 |
| 取值范围 | 同上                  |
| 缺省值   |                       |

### dDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 仅服务端适用         |
| 含义     | dnode 模块的日志开关 |
| 取值范围 | 同上                 |
| 缺省值   | 135                  |

### vDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 仅服务端适用         |
| 含义     | vnode 模块的日志开关 |
| 取值范围 | 同上                 |
| 缺省值   |                      |

### mDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 仅服务端适用         |
| 含义     | mnode 模块的日志开关 |
| 取值范围 | 同上                 |
| 缺省值   | 135                  |

### wDebugFlag

| 属性     | 说明               |
| -------- | ------------------ |
| 适用范围 | 仅服务端适用       |
| 含义     | wal 模块的日志开关 |
| 取值范围 | 同上               |
| 缺省值   | 135                |

### sDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 服务端和客户端均适用 |
| 含义     | sync 模块的日志开关  |
| 取值范围 | 同上                 |
| 缺省值   | 135                  |

### tsdbDebugFlag

| 属性     | 说明                |
| -------- | ------------------- |
| 适用范围 | 仅服务端适用        |
| 含义     | tsdb 模块的日志开关 |
| 取值范围 | 同上                |
| 缺省值   |                     |

### tqDebugFlag

| 属性     | 说明              |
| -------- | ----------------- |
| 适用范围 | 仅服务端适用      |
| 含义     | tq 模块的日志开关 |
| 取值范围 | 同上              |
| 缺省值   |                   |

### fsDebugFlag

| 属性     | 说明              |
| -------- | ----------------- |
| 适用范围 | 仅服务端适用      |
| 含义     | fs 模块的日志开关 |
| 取值范围 | 同上              |
| 缺省值   |                   |

### udfDebugFlag

| 属性     | 说明               |
| -------- | ------------------ |
| 适用范围 | 仅服务端适用       |
| 含义     | UDF 模块的日志开关 |
| 取值范围 | 同上               |
| 缺省值   |                    |

### smaDebugFlag

| 属性     | 说明               |
| -------- | ------------------ |
| 适用范围 | 仅服务端适用       |
| 含义     | sma 模块的日志开关 |
| 取值范围 | 同上               |
| 缺省值   |                    |

### idxDebugFlag

| 属性     | 说明                 |
| -------- | -------------------- |
| 适用范围 | 仅服务端适用         |
| 含义     | index 模块的日志开关 |
| 取值范围 | 同上                 |
| 缺省值   |                      |

### tdbDebugFlag

| 属性     | 说明               |
| -------- | ------------------ |
| 适用范围 | 仅服务端适用       |
| 含义     | tdb 模块的日志开关 |
| 取值范围 | 同上               |
| 缺省值   |                    |

## Schemaless 相关

### smlChildTableName

| 属性     | 说明                      |
| -------- | ------------------------- |
| 适用范围 | 仅客户端适用              |
| 含义     | schemaless 自定义的子表名 |
| 类型     | 字符串                    |
| 缺省值   | 无                        |

### smlTagName

| 属性     | 说明                                 |
| -------- | ------------------------------------ |
| 适用范围 | 仅客户端适用                         |
| 含义     | schemaless tag 为空时默认的 tag 名字 |
| 类型     | 字符串                               |
| 缺省值   | _tag_null                                 |

### smlDataFormat

| 属性     | 说明                          |
| -------- | ----------------------------- |
| 适用范围 | 仅客户端适用                  |
| 含义     | schemaless 列数据是否顺序一致 |
| 值域     | 0：不一致；1: 一致            |
| 缺省值   | 1                             |

## 其他

### enableCoreFile

| 属性     | 说明                                                                                                                                       |
| -------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
| 适用范围 | 服务端和客户端均适用                                                                                                                       |
| 含义     | 是否开启服务 crash 时生成 core 文件                                                                                                        |
| 取值范围 | 0：否，1：是                                                                                                                               |
| 缺省值   | 1                                                                                                                                          |
| 补充说明 | 不同的启动方式，生成 core 文件的目录如下：1、systemctl start taosd 启动：生成的 core 在根目录下 <br/> 2、手动启动，就在 taosd 执行目录下。 |

### udf

| 属性     | 说明               |
| -------- | ------------------ |
| 适用范围 | 仅服务端适用       |
| 含义     | 是否启动 udf 服务  |
| 取值范围 | 0: 不启动；1：启动 |
| 缺省值   | 1                  |
