###################################################################
#           Copyright (c) 2021 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
from util.log import *
from util.cases import *
from util.sql import *


class TDTestCase:
    def caseDescription(self):
        '''
        case1<Ganlin Zhao>: [TD-11216]<feature>: Time window related keywords
        '''
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def getBuildPath(self):
        selfPath = os.path.dirname(os.path.realpath(__file__))

        if ("community" in selfPath):
            projPath = selfPath[:selfPath.find("community")]
        else:
            projPath = selfPath[:selfPath.find("tests")]

        for root, dirs, files in os.walk(projPath):
            if ("taosd" in files):
                rootRealPath = os.path.dirname(os.path.realpath(root))
                if ("packaging" not in rootRealPath):
                    buildPath = root[:len(root) - len("/build/bin")]
                    break
        return buildPath

    def checkTimestampEqual(self, elm, expect_elm):
        caller = inspect.getframeinfo(inspect.stack()[1][0])
        if len(elm) == len(expect_elm):
            delta = abs(int(elm[-1]) - int(expect_elm[-1]))
            if delta == 1: #ignore 1 second diff
                new_elm = expect_elm[0:-1] + elm[-1]
            else:
                new_elm = expect_elm;
            if elm == new_elm:
                tdLog.info("sql:%s, elm:%s == expect_elm:%s" % (tdSql.sql, elm, new_elm))
            else:
                args = (caller.filename, caller.lineno, tdSql.sql, elm, new_elm)
                tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)
        else:
            args = (caller.filename, caller.lineno, tdSql.sql, elm, expect_elm)
            tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)


    def run(self):
        print("running {}".format(__file__))

        #Prepare data
        #db precision "ms"
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        #for interval query
        tdSql.execute("create stable stb_i (ts timestamp, c0 int) tags (t0 int);")
        tdSql.execute("create table ctb1_i using stb_i tags (1);")
        tdSql.execute("create table ctb2_i using stb_i tags (2);")
        tdSql.execute("create table tb_i (ts timestamp, c0 int);")

        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:05', 5)")

        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:00', 0)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:01', 1)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:02', 2)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:03', 3)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:04', 4)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:05', 5)")

        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:05', 5)")

        #for state_window query
        tdSql.execute("create table tb_w (ts timestamp, c0 int);")

        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:01', 0)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:02', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:03', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:04', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:05', 2)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:06', 5)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:07', 5)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:08', 0)")

        #for session query
        tdSql.execute("create table tb_s (ts timestamp, c0 int);")

        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:00', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:02', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:04', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:07', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:10', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:14', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:18', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:23', 1)")

        #db precision "us"
        tdSql.execute("drop database if exists db_u")
        tdSql.execute("create database if not exists db_u precision 'us'")
        tdSql.execute('use db_u')

        #for interval query
        tdSql.execute("create stable stb_i (ts timestamp, c0 int) tags (t0 int);")
        tdSql.execute("create table ctb1_i using stb_i tags (1);")
        tdSql.execute("create table ctb2_i using stb_i tags (2);")
        tdSql.execute("create table tb_i (ts timestamp, c0 int);")

        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:05', 5)")

        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:00', 0)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:01', 1)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:02', 2)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:03', 3)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:04', 4)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:05', 5)")

        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:05', 5)")

        #for state_window query
        tdSql.execute("create table tb_w (ts timestamp, c0 int);")

        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:01', 0)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:02', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:03', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:04', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:05', 2)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:06', 5)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:07', 5)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:08', 0)")

        #for session query
        tdSql.execute("create table tb_s (ts timestamp, c0 int);")

        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:00', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:02', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:04', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:07', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:10', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:14', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:18', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:23', 1)")

        #db precision "ns"
        tdSql.execute("drop database if exists db_n")
        tdSql.execute("create database if not exists db_n precision 'ns'")
        tdSql.execute('use db_n')

        #for interval query
        tdSql.execute("create stable stb_i (ts timestamp, c0 int) tags (t0 int);")
        tdSql.execute("create table ctb1_i using stb_i tags (1);")
        tdSql.execute("create table ctb2_i using stb_i tags (2);")
        tdSql.execute("create table tb_i (ts timestamp, c0 int);")

        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into ctb1_i values ('2022-02-02 02:00:05', 5)")

        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:00', 0)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:01', 1)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:02', 2)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:03', 3)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:04', 4)")
        tdSql.execute("insert into ctb2_i values ('2022-02-02 03:00:05', 5)")

        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into tb_i values ('2022-02-02 02:00:05', 5)")

        #for state_window query
        tdSql.execute("create table tb_w (ts timestamp, c0 int);")

        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:01', 0)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:02', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:03', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:04', 1)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:05', 2)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:06', 5)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:07', 5)")
        tdSql.execute("insert into tb_w values ('2022-02-02 02:00:08', 0)")

        #for session query
        tdSql.execute("create table tb_s (ts timestamp, c0 int);")

        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:00', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:02', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:04', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:07', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:10', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:14', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:18', 1)")
        tdSql.execute("insert into tb_s values ('2022-02-02 02:00:23', 1)")

        #execute query
        print("============== STEP 1: select _wsatrt,_wstop,_wduration in interval query  ================== ")

        # db precision "ms"
        tdSql.execute('use db_m')

        ## _wstart
        tdSql.query("select _wstart from tb_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from ctb1_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from stb_i interval (1a);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05")

        tdSql.query("select _wstart from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)

        tdSql.query("select _wstart from tb_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        tdSql.query("select _wstart from ctb1_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        tdSql.query("select _wstart from stb_i interval (2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")

        tdSql.query("select _wstart from tb_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select _wstart from ctb1_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select _wstart from stb_i interval (1m);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")

        tdSql.query("select _wstart,avg(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart,avg(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart,avg(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)

        tdSql.query("select avg(c0),_wstart from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 2)

        tdSql.query("select avg(c0),_wstart,sum(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart,sum(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart,sum(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 2)

        ##_wstop
        tdSql.query("select _wstop from tb_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstop from ctb1_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstop from stb_i interval (1a);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05")

        tdSql.query("select _wstop from tb_i interval (10a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.009000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.009000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.009000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.009000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.009000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.009000")
        tdSql.query("select _wstop from ctb1_i interval (10a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.009000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.009000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.009000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.009000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.009000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.009000")
        tdSql.query("select _wstop from stb_i interval (10a);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.009000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.009000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.009000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.009000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.009000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.009000")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.009000")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.009000")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.009000")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.009000")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.009000")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.009000")

        tdSql.query("select _wstop from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wstop from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wstop from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999000")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999000")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999000")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")

        tdSql.query("select _wstop from tb_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wstop from ctb1_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wstop from stb_i interval (2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")

        tdSql.query("select _wstop from tb_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:59.999000")
        tdSql.query("select _wstop from ctb1_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:59.999000")
        tdSql.query("select _wstop from stb_i interval (1m);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:59.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:59.999000")

        tdSql.query("select _wstop,avg(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wstop,avg(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wstop,avg(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999000")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999000")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999000")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")

        tdSql.query("select avg(c0),_wstop from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select avg(c0),_wstop from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select avg(c0),_wstop from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999000")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999000")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999000")
        res = tdSql.getData(11, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")

        tdSql.query("select avg(c0),_wstop,sum(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select avg(c0),_wstop,sum(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select avg(c0),_wstop,sum(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999000")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999000")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999000")
        res = tdSql.getData(11, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")

        ##_wduration
        tdSql.query("select _wduration from tb_i interval (1a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.query("select _wduration from ctb1_i interval (1a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.query("select _wduration from stb_i interval (1a);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.checkData(6, 1, 0)
        tdSql.checkData(7, 1, 0)
        tdSql.checkData(8, 1, 0)
        tdSql.checkData(9, 1, 0)
        tdSql.checkData(10, 1, 0)
        tdSql.checkData(11, 1, 0)

        tdSql.query("select _wduration from tb_i interval (10a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 9)
        tdSql.checkData(1, 1, 9)
        tdSql.checkData(2, 1, 9)
        tdSql.checkData(3, 1, 9)
        tdSql.checkData(4, 1, 9)
        tdSql.checkData(5, 1, 9)
        tdSql.query("select _wduration from ctb1_i interval (10a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 9)
        tdSql.checkData(1, 1, 9)
        tdSql.checkData(2, 1, 9)
        tdSql.checkData(3, 1, 9)
        tdSql.checkData(4, 1, 9)
        tdSql.checkData(5, 1, 9)
        tdSql.query("select _wduration from stb_i interval (10a);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 9)
        tdSql.checkData(1, 1, 9)
        tdSql.checkData(2, 1, 9)
        tdSql.checkData(3, 1, 9)
        tdSql.checkData(4, 1, 9)
        tdSql.checkData(5, 1, 9)
        tdSql.checkData(6, 1, 9)
        tdSql.checkData(7, 1, 9)
        tdSql.checkData(8, 1, 9)
        tdSql.checkData(9, 1, 9)
        tdSql.checkData(10, 1, 9)
        tdSql.checkData(11, 1, 9)

        tdSql.query("select _wduration from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.query("select _wduration from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.query("select _wduration from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.checkData(6, 1, 999)
        tdSql.checkData(7, 1, 999)
        tdSql.checkData(8, 1, 999)
        tdSql.checkData(9, 1, 999)
        tdSql.checkData(10, 1, 999)
        tdSql.checkData(11, 1, 999)

        tdSql.query("select _wduration from tb_i interval (2s);")
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999)
        tdSql.checkData(1, 1, 1999)
        tdSql.checkData(2, 1, 1999)
        tdSql.query("select _wduration from ctb1_i interval (2s);")
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999)
        tdSql.checkData(1, 1, 1999)
        tdSql.checkData(2, 1, 1999)
        tdSql.query("select _wduration from stb_i interval (2s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 1999)
        tdSql.checkData(1, 1, 1999)
        tdSql.checkData(2, 1, 1999)
        tdSql.checkData(3, 1, 1999)
        tdSql.checkData(4, 1, 1999)
        tdSql.checkData(5, 1, 1999)

        tdSql.query("select _wduration from tb_i interval (1m);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 59999)
        tdSql.query("select _wduration from ctb1_i interval (1m);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 59999)
        tdSql.query("select _wduration from stb_i interval (1m);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 1, 59999)
        tdSql.checkData(1, 1, 59999)

        tdSql.query("select _wduration,avg(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.query("select _wduration,avg(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.query("select _wduration,avg(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.checkData(6, 1, 999)
        tdSql.checkData(7, 1, 999)
        tdSql.checkData(8, 1, 999)
        tdSql.checkData(9, 1, 999)
        tdSql.checkData(10, 1, 999)
        tdSql.checkData(11, 1, 999)

        tdSql.query("select avg(c0),_wduration from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999)
        tdSql.checkData(1, 2, 999)
        tdSql.checkData(2, 2, 999)
        tdSql.checkData(3, 2, 999)
        tdSql.checkData(4, 2, 999)
        tdSql.checkData(5, 2, 999)
        tdSql.query("select avg(c0),_wduration from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999)
        tdSql.checkData(1, 2, 999)
        tdSql.checkData(2, 2, 999)
        tdSql.checkData(3, 2, 999)
        tdSql.checkData(4, 2, 999)
        tdSql.checkData(5, 2, 999)
        tdSql.query("select avg(c0),_wduration from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 2, 999)
        tdSql.checkData(1, 2, 999)
        tdSql.checkData(2, 2, 999)
        tdSql.checkData(3, 2, 999)
        tdSql.checkData(4, 2, 999)
        tdSql.checkData(5, 2, 999)
        tdSql.checkData(6, 2, 999)
        tdSql.checkData(7, 2, 999)
        tdSql.checkData(8, 2, 999)
        tdSql.checkData(9, 2, 999)
        tdSql.checkData(10, 2, 999)
        tdSql.checkData(11, 2, 999)

        tdSql.query("select avg(c0),_wduration,sum(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999)
        tdSql.checkData(1, 2, 999)
        tdSql.checkData(2, 2, 999)
        tdSql.checkData(3, 2, 999)
        tdSql.checkData(4, 2, 999)
        tdSql.checkData(5, 2, 999)
        tdSql.query("select avg(c0),_wduration,sum(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999)
        tdSql.checkData(1, 2, 999)
        tdSql.checkData(2, 2, 999)
        tdSql.checkData(3, 2, 999)
        tdSql.checkData(4, 2, 999)
        tdSql.checkData(5, 2, 999)
        tdSql.query("select avg(c0),_wduration,sum(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 2, 999)
        tdSql.checkData(1, 2, 999)
        tdSql.checkData(2, 2, 999)
        tdSql.checkData(3, 2, 999)
        tdSql.checkData(4, 2, 999)
        tdSql.checkData(5, 2, 999)
        tdSql.checkData(6, 2, 999)
        tdSql.checkData(7, 2, 999)
        tdSql.checkData(8, 2, 999)
        tdSql.checkData(9, 2, 999)
        tdSql.checkData(10, 2, 999)
        tdSql.checkData(11, 2, 999)

        #_wstart,_wstop,_wduration together
        tdSql.query("select _wstart,_wstop,_wduration from tb_i interval (2s);")
        tdSql.checkCols(4)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.checkData(0, 3, 1999)
        tdSql.checkData(1, 3, 1999)
        tdSql.checkData(2, 3, 1999)
        tdSql.query("select _wstart,_wstop,_wduration from ctb1_i interval (2s);")
        tdSql.checkCols(4)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.checkData(0, 3, 1999)
        tdSql.checkData(1, 3, 1999)
        tdSql.checkData(2, 3, 1999)
        tdSql.query("select _wstart,_wstop,_wduration from stb_i interval (2s);")
        tdSql.checkCols(4)
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")
        tdSql.checkData(0, 3, 1999)
        tdSql.checkData(1, 3, 1999)
        tdSql.checkData(2, 3, 1999)
        tdSql.checkData(3, 3, 1999)
        tdSql.checkData(4, 3, 1999)
        tdSql.checkData(5, 3, 1999)

        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from tb_i interval (2s);")
        tdSql.checkCols(5)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.checkData(0, 3, 1999)
        tdSql.checkData(1, 3, 1999)
        tdSql.checkData(2, 3, 1999)
        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from ctb1_i interval (2s);")
        tdSql.checkCols(5)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.checkData(0, 3, 1999)
        tdSql.checkData(1, 3, 1999)
        tdSql.checkData(2, 3, 1999)
        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from stb_i interval (2s);")
        tdSql.checkCols(5)
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")
        tdSql.checkData(0, 3, 1999)
        tdSql.checkData(1, 3, 1999)
        tdSql.checkData(2, 3, 1999)
        tdSql.checkData(3, 3, 1999)
        tdSql.checkData(4, 3, 1999)
        tdSql.checkData(5, 3, 1999)

        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from tb_i interval (2s);")
        tdSql.checkCols(7)
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999)
        tdSql.checkData(1, 1, 1999)
        tdSql.checkData(2, 1, 1999)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from ctb1_i interval (2s);")
        tdSql.checkCols(7)
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999)
        tdSql.checkData(1, 1, 1999)
        tdSql.checkData(2, 1, 1999)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from stb_i interval (2s);")
        tdSql.checkCols(7)
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 1999)
        tdSql.checkData(1, 1, 1999)
        tdSql.checkData(2, 1, 1999)
        tdSql.checkData(3, 1, 1999)
        tdSql.checkData(4, 1, 1999)
        tdSql.checkData(5, 1, 1999)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 3)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 3)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 3)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(0, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(3, 5)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(4, 5)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(5, 5)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")

        # db precision "us"
        tdSql.execute('use db_u')

        ## _wstart
        tdSql.query("select _wstart from tb_i interval (1u);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from ctb1_i interval (1u);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from stb_i interval (1u);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05")

        tdSql.query("select _wstart from tb_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from ctb1_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from stb_i interval (1a);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05")

        tdSql.query("select _wstart from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)

        tdSql.query("select _wstart from tb_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        tdSql.query("select _wstart from ctb1_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        tdSql.query("select _wstart from stb_i interval (2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")

        tdSql.query("select _wstart from tb_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select _wstart from ctb1_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select _wstart from stb_i interval (1m);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")

        tdSql.query("select _wstart,avg(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart,avg(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstart,avg(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)

        tdSql.query("select avg(c0),_wstart from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 2)

        tdSql.query("select avg(c0),_wstart,sum(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart,sum(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select avg(c0),_wstart,sum(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 2)

        ##_wstop
        tdSql.query("select _wstop from tb_i interval (1u);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstop from ctb1_i interval (1u);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        tdSql.query("select _wstop from stb_i interval (1u);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05")

        tdSql.query("select _wstop from tb_i interval (10u);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.000009")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.000009")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.000009")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.000009")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.000009")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.000009")
        tdSql.query("select _wstop from ctb1_i interval (10u);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.000009")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.000009")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.000009")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.000009")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.000009")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.000009")
        tdSql.query("select _wstop from stb_i interval (10u);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.000009")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.000009")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.000009")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.000009")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.000009")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.000009")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.000009")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.000009")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.000009")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.000009")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.000009")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.000009")

        tdSql.query("select _wstop from tb_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.000999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.000999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.000999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.000999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.000999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.000999")
        tdSql.query("select _wstop from ctb1_i interval (1a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.000999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.000999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.000999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.000999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.000999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.000999")
        tdSql.query("select _wstop from stb_i interval (1a);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.000999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.000999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.000999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.000999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.000999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.000999")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.000999")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.000999")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.000999")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.000999")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.000999")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.000999")

        tdSql.query("select _wstop from tb_i interval (10a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.009999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.009999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.009999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.009999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.009999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.009999")
        tdSql.query("select _wstop from ctb1_i interval (10a);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.009999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.009999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.009999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.009999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.009999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.009999")
        tdSql.query("select _wstop from stb_i interval (10a);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.009999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.009999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.009999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.009999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.009999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.009999")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.009999")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.009999")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.009999")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.009999")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.009999")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.009999")

        tdSql.query("select _wstop from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wstop from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wstop from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999999")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999999")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999999")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")

        tdSql.query("select _wstop from tb_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wstop from ctb1_i interval (2s);")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wstop from stb_i interval (2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")

        tdSql.query("select _wstop from tb_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:59.999999")
        tdSql.query("select _wstop from ctb1_i interval (1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:59.999999")
        tdSql.query("select _wstop from stb_i interval (1m);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:59.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:59.999999")

        tdSql.query("select _wstop,avg(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wstop,avg(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wstop,avg(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999999")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(8, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999999")
        res = tdSql.getData(9, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(10, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999999")
        res = tdSql.getData(11, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")

        tdSql.query("select avg(c0),_wstop from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select avg(c0),_wstop from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select avg(c0),_wstop from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999999")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999999")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999999")
        res = tdSql.getData(11, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")

        tdSql.query("select avg(c0),_wstop,sum(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select avg(c0),_wstop,sum(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select avg(c0),_wstop,sum(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00.999999")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(8, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02.999999")
        res = tdSql.getData(9, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(10, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04.999999")
        res = tdSql.getData(11, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")

        ##_wduration
        tdSql.query("select _wduration from tb_i interval (1u);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.query("select _wduration from ctb1_i interval (1u);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.query("select _wduration from stb_i interval (1u);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.checkData(6, 1, 0)
        tdSql.checkData(7, 1, 0)
        tdSql.checkData(8, 1, 0)
        tdSql.checkData(9, 1, 0)
        tdSql.checkData(10, 1, 0)
        tdSql.checkData(11, 1, 0)

        tdSql.query("select _wduration from tb_i interval (10u);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 9)
        tdSql.checkData(1, 1, 9)
        tdSql.checkData(2, 1, 9)
        tdSql.checkData(3, 1, 9)
        tdSql.checkData(4, 1, 9)
        tdSql.checkData(5, 1, 9)
        tdSql.query("select _wduration from ctb1_i interval (10u);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 9)
        tdSql.checkData(1, 1, 9)
        tdSql.checkData(2, 1, 9)
        tdSql.checkData(3, 1, 9)
        tdSql.checkData(4, 1, 9)
        tdSql.checkData(5, 1, 9)
        tdSql.query("select _wduration from stb_i interval (10u);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 9)
        tdSql.checkData(1, 1, 9)
        tdSql.checkData(2, 1, 9)
        tdSql.checkData(3, 1, 9)
        tdSql.checkData(4, 1, 9)
        tdSql.checkData(5, 1, 9)
        tdSql.checkData(6, 1, 9)
        tdSql.checkData(7, 1, 9)
        tdSql.checkData(8, 1, 9)
        tdSql.checkData(9, 1, 9)
        tdSql.checkData(10, 1, 9)
        tdSql.checkData(11, 1, 9)

        tdSql.query("select _wduration from tb_i interval (1a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.query("select _wduration from ctb1_i interval (1a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.query("select _wduration from stb_i interval (1a);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 999)
        tdSql.checkData(1, 1, 999)
        tdSql.checkData(2, 1, 999)
        tdSql.checkData(3, 1, 999)
        tdSql.checkData(4, 1, 999)
        tdSql.checkData(5, 1, 999)
        tdSql.checkData(6, 1, 999)
        tdSql.checkData(7, 1, 999)
        tdSql.checkData(8, 1, 999)
        tdSql.checkData(9, 1, 999)
        tdSql.checkData(10, 1, 999)
        tdSql.checkData(11, 1, 999)

        tdSql.query("select _wduration from tb_i interval (10a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 9999)
        tdSql.checkData(1, 1, 9999)
        tdSql.checkData(2, 1, 9999)
        tdSql.checkData(3, 1, 9999)
        tdSql.checkData(4, 1, 9999)
        tdSql.checkData(5, 1, 9999)
        tdSql.query("select _wduration from ctb1_i interval (10a);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 9999)
        tdSql.checkData(1, 1, 9999)
        tdSql.checkData(2, 1, 9999)
        tdSql.checkData(3, 1, 9999)
        tdSql.checkData(4, 1, 9999)
        tdSql.checkData(5, 1, 9999)
        tdSql.query("select _wduration from stb_i interval (10a);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 9999)
        tdSql.checkData(1, 1, 9999)
        tdSql.checkData(2, 1, 9999)
        tdSql.checkData(3, 1, 9999)
        tdSql.checkData(4, 1, 9999)
        tdSql.checkData(5, 1, 9999)
        tdSql.checkData(6, 1, 9999)
        tdSql.checkData(7, 1, 9999)
        tdSql.checkData(8, 1, 9999)
        tdSql.checkData(9, 1, 9999)
        tdSql.checkData(10, 1, 9999)
        tdSql.checkData(11, 1, 9999)

        tdSql.query("select _wduration from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999999)
        tdSql.checkData(1, 1, 999999)
        tdSql.checkData(2, 1, 999999)
        tdSql.checkData(3, 1, 999999)
        tdSql.checkData(4, 1, 999999)
        tdSql.checkData(5, 1, 999999)
        tdSql.query("select _wduration from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999999)
        tdSql.checkData(1, 1, 999999)
        tdSql.checkData(2, 1, 999999)
        tdSql.checkData(3, 1, 999999)
        tdSql.checkData(4, 1, 999999)
        tdSql.checkData(5, 1, 999999)
        tdSql.query("select _wduration from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 999999)
        tdSql.checkData(1, 1, 999999)
        tdSql.checkData(2, 1, 999999)
        tdSql.checkData(3, 1, 999999)
        tdSql.checkData(4, 1, 999999)
        tdSql.checkData(5, 1, 999999)
        tdSql.checkData(6, 1, 999999)
        tdSql.checkData(7, 1, 999999)
        tdSql.checkData(8, 1, 999999)
        tdSql.checkData(9, 1, 999999)
        tdSql.checkData(10, 1, 999999)
        tdSql.checkData(11, 1, 999999)

        tdSql.query("select _wduration from tb_i interval (2s);")
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999999)
        tdSql.checkData(1, 1, 1999999)
        tdSql.checkData(2, 1, 1999999)
        tdSql.query("select _wduration from ctb1_i interval (2s);")
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999999)
        tdSql.checkData(1, 1, 1999999)
        tdSql.checkData(2, 1, 1999999)
        tdSql.query("select _wduration from stb_i interval (2s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 1999999)
        tdSql.checkData(1, 1, 1999999)
        tdSql.checkData(2, 1, 1999999)
        tdSql.checkData(3, 1, 1999999)
        tdSql.checkData(4, 1, 1999999)
        tdSql.checkData(5, 1, 1999999)

        tdSql.query("select _wduration from tb_i interval (1m);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 59999999)
        tdSql.query("select _wduration from ctb1_i interval (1m);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 59999999)
        tdSql.query("select _wduration from stb_i interval (1m);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 1, 59999999)
        tdSql.checkData(1, 1, 59999999)

        tdSql.query("select _wduration,avg(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999999)
        tdSql.checkData(1, 1, 999999)
        tdSql.checkData(2, 1, 999999)
        tdSql.checkData(3, 1, 999999)
        tdSql.checkData(4, 1, 999999)
        tdSql.checkData(5, 1, 999999)
        tdSql.query("select _wduration,avg(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 999999)
        tdSql.checkData(1, 1, 999999)
        tdSql.checkData(2, 1, 999999)
        tdSql.checkData(3, 1, 999999)
        tdSql.checkData(4, 1, 999999)
        tdSql.checkData(5, 1, 999999)
        tdSql.query("select _wduration,avg(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 1, 999999)
        tdSql.checkData(1, 1, 999999)
        tdSql.checkData(2, 1, 999999)
        tdSql.checkData(3, 1, 999999)
        tdSql.checkData(4, 1, 999999)
        tdSql.checkData(5, 1, 999999)
        tdSql.checkData(6, 1, 999999)
        tdSql.checkData(7, 1, 999999)
        tdSql.checkData(8, 1, 999999)
        tdSql.checkData(9, 1, 999999)
        tdSql.checkData(10, 1, 999999)
        tdSql.checkData(11, 1, 999999)

        tdSql.query("select avg(c0),_wduration from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999999)
        tdSql.checkData(1, 2, 999999)
        tdSql.checkData(2, 2, 999999)
        tdSql.checkData(3, 2, 999999)
        tdSql.checkData(4, 2, 999999)
        tdSql.checkData(5, 2, 999999)
        tdSql.query("select avg(c0),_wduration from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999999)
        tdSql.checkData(1, 2, 999999)
        tdSql.checkData(2, 2, 999999)
        tdSql.checkData(3, 2, 999999)
        tdSql.checkData(4, 2, 999999)
        tdSql.checkData(5, 2, 999999)
        tdSql.query("select avg(c0),_wduration from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 2, 999999)
        tdSql.checkData(1, 2, 999999)
        tdSql.checkData(2, 2, 999999)
        tdSql.checkData(3, 2, 999999)
        tdSql.checkData(4, 2, 999999)
        tdSql.checkData(5, 2, 999999)
        tdSql.checkData(6, 2, 999999)
        tdSql.checkData(7, 2, 999999)
        tdSql.checkData(8, 2, 999999)
        tdSql.checkData(9, 2, 999999)
        tdSql.checkData(10, 2, 999999)
        tdSql.checkData(11, 2, 999999)

        tdSql.query("select avg(c0),_wduration,sum(c0) from tb_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999999)
        tdSql.checkData(1, 2, 999999)
        tdSql.checkData(2, 2, 999999)
        tdSql.checkData(3, 2, 999999)
        tdSql.checkData(4, 2, 999999)
        tdSql.checkData(5, 2, 999999)
        tdSql.query("select avg(c0),_wduration,sum(c0) from ctb1_i interval (1s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 2, 999999)
        tdSql.checkData(1, 2, 999999)
        tdSql.checkData(2, 2, 999999)
        tdSql.checkData(3, 2, 999999)
        tdSql.checkData(4, 2, 999999)
        tdSql.checkData(5, 2, 999999)
        tdSql.query("select avg(c0),_wduration,sum(c0) from stb_i interval (1s);")
        tdSql.checkRows(12)
        tdSql.checkData(0, 2, 999999)
        tdSql.checkData(1, 2, 999999)
        tdSql.checkData(2, 2, 999999)
        tdSql.checkData(3, 2, 999999)
        tdSql.checkData(4, 2, 999999)
        tdSql.checkData(5, 2, 999999)
        tdSql.checkData(6, 2, 999999)
        tdSql.checkData(7, 2, 999999)
        tdSql.checkData(8, 2, 999999)
        tdSql.checkData(9, 2, 999999)
        tdSql.checkData(10, 2, 999999)
        tdSql.checkData(11, 2, 999999)

        #_wstart,_wstop,_wduration together
        tdSql.query("select _wstart,_wstop,_wduration from tb_i interval (2s);")
        tdSql.checkCols(4)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.checkData(0, 3, 1999999)
        tdSql.checkData(1, 3, 1999999)
        tdSql.checkData(2, 3, 1999999)
        tdSql.query("select _wstart,_wstop,_wduration from ctb1_i interval (2s);")
        tdSql.checkCols(4)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.checkData(0, 3, 1999999)
        tdSql.checkData(1, 3, 1999999)
        tdSql.checkData(2, 3, 1999999)
        tdSql.query("select _wstart,_wstop,_wduration from stb_i interval (2s);")
        tdSql.checkCols(4)
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")
        tdSql.checkData(0, 3, 1999999)
        tdSql.checkData(1, 3, 1999999)
        tdSql.checkData(2, 3, 1999999)
        tdSql.checkData(3, 3, 1999999)
        tdSql.checkData(4, 3, 1999999)
        tdSql.checkData(5, 3, 1999999)

        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from tb_i interval (2s);")
        tdSql.checkCols(5)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.checkData(0, 3, 1999999)
        tdSql.checkData(1, 3, 1999999)
        tdSql.checkData(2, 3, 1999999)
        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from ctb1_i interval (2s);")
        tdSql.checkCols(5)
        tdSql.checkRows(3)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.checkData(0, 3, 1999999)
        tdSql.checkData(1, 3, 1999999)
        tdSql.checkData(2, 3, 1999999)
        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from stb_i interval (2s);")
        tdSql.checkCols(5)
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")
        tdSql.checkData(0, 3, 1999999)
        tdSql.checkData(1, 3, 1999999)
        tdSql.checkData(2, 3, 1999999)
        tdSql.checkData(3, 3, 1999999)
        tdSql.checkData(4, 3, 1999999)
        tdSql.checkData(5, 3, 1999999)

        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from tb_i interval (2s);")
        tdSql.checkCols(7)
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999999)
        tdSql.checkData(1, 1, 1999999)
        tdSql.checkData(2, 1, 1999999)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from ctb1_i interval (2s);")
        tdSql.checkCols(7)
        tdSql.checkRows(3)
        tdSql.checkData(0, 1, 1999999)
        tdSql.checkData(1, 1, 1999999)
        tdSql.checkData(2, 1, 1999999)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(0, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from stb_i interval (2s);")
        tdSql.checkCols(7)
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 1999999)
        tdSql.checkData(1, 1, 1999999)
        tdSql.checkData(2, 1, 1999999)
        tdSql.checkData(3, 1, 1999999)
        tdSql.checkData(4, 1, 1999999)
        tdSql.checkData(5, 1, 1999999)
        res = tdSql.getData(0, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 3)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 3)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 3)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 3)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")
        res = tdSql.getData(0, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999999")
        res = tdSql.getData(1, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999999")
        res = tdSql.getData(2, 5)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999999")
        res = tdSql.getData(3, 5)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999999")
        res = tdSql.getData(4, 5)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999999")
        res = tdSql.getData(5, 5)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999999")


        print("============== STEP 2: select _wsatrt,_wstop,_wduration in state_window query  ================== ")

        # db precision "ms"
        tdSql.execute('use db_m')

        ## _wstart
        tdSql.query("select _wstart from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select _wstart,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select sum(c0),_wstart,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        ##_wstop
        tdSql.query("select _wstop from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select _wstop,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select sum(c0),_wstop,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        ##_wduration
        tdSql.query("select _wduration from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 0, 1000)
        tdSql.checkData(1, 0, 2000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000)
        tdSql.checkData(4, 0, 0)

        tdSql.query("select _wduration,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 0, 1000)
        tdSql.checkData(1, 0, 2000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000)
        tdSql.checkData(4, 0, 0)

        tdSql.query("select sum(c0),_wduration,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 1, 1000)
        tdSql.checkData(1, 1, 2000)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 1000)
        tdSql.checkData(4, 1, 0)

        #_wstart,_wstop,_wduration together
        tdSql.query("select _wstart,_wstop,_wduration from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        tdSql.checkData(0, 2, 1000)
        tdSql.checkData(1, 2, 2000)
        tdSql.checkData(2, 2, 0)
        tdSql.checkData(3, 2, 1000)
        tdSql.checkData(4, 2, 0)

        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        tdSql.checkData(0, 2, 1000)
        tdSql.checkData(1, 2, 2000)
        tdSql.checkData(2, 2, 0)
        tdSql.checkData(3, 2, 1000)
        tdSql.checkData(4, 2, 0)

        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 0, 1000)
        tdSql.checkData(1, 0, 2000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000)
        tdSql.checkData(4, 0, 0)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        res = tdSql.getData(0, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        # db precision "us"
        tdSql.execute('use db_u')

        ## _wstart
        tdSql.query("select _wstart from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select _wstart,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select sum(c0),_wstart,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        ##_wstop
        tdSql.query("select _wstop from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select _wstop,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query("select sum(c0),_wstop,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        ##_wduration
        tdSql.query("select _wduration from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 0, 1000000)
        tdSql.checkData(1, 0, 2000000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000000)
        tdSql.checkData(4, 0, 0)

        tdSql.query("select _wduration,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 0, 1000000)
        tdSql.checkData(1, 0, 2000000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000000)
        tdSql.checkData(4, 0, 0)

        tdSql.query("select sum(c0),_wduration,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 1, 1000000)
        tdSql.checkData(1, 1, 2000000)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 1000000)
        tdSql.checkData(4, 1, 0)

        #_wstart,_wstop,_wduration together
        tdSql.query("select _wstart,_wstop,_wduration from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        tdSql.checkData(0, 0, 1000000)
        tdSql.checkData(1, 0, 2000000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000000)
        tdSql.checkData(4, 0, 0)

        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        tdSql.checkData(0, 0, 1000000)
        tdSql.checkData(1, 0, 2000000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000000)
        tdSql.checkData(4, 0, 0)

        tdSql.query("select _wduration,avg(c0),_wstart,sum(c0),_wstop,stddev(c0) from tb_w state_window(c0);")
        tdSql.checkRows(5)
        tdSql.checkData(0, 0, 1000000)
        tdSql.checkData(1, 0, 2000000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000000)
        tdSql.checkData(4, 0, 0)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")
        res = tdSql.getData(0, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 4)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        print("============== STEP 3: select _wsatrt,_wstop,_wduration in session query  ================== ")

        # db precision "ms"
        tdSql.execute('use db_m')

        ## _wstart
        tdSql.query("select _wstart from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 3s);")
        tdSql.checkRows(4)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 5s);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _wstart from tb_s session(ts, 1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _wstart,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select sum(c0),_wstart,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        ##_wstop
        tdSql.query("select _wstop from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 3s);")
        tdSql.checkRows(4)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 5s);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select sum(c0),_wstop,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        ##_wduration
        tdSql.query("select _wduration from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.checkData(6, 1, 0)
        tdSql.checkData(7, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 2s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 4000)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 3s);")
        tdSql.checkRows(4)
        tdSql.checkData(0, 1, 10000)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 1, 18000)
        tdSql.checkData(1, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 5s);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 23000)

        tdSql.query("select _wduration from tb_s session(ts, 1m);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 23000)

        tdSql.query("select _wduration,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 1, 18000)
        tdSql.checkData(1, 1, 0)

        tdSql.query("select sum(c0),_wduration,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 2, 18000)
        tdSql.checkData(1, 2, 0)

        #_wstart,_wstop,_wduration together
        tdSql.query("select _wstart,_wstop,_wduration from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        tdSql.checkData(0, 3, 0)
        tdSql.checkData(1, 3, 0)
        tdSql.checkData(2, 3, 0)
        tdSql.checkData(3, 3, 0)
        tdSql.checkData(4, 3, 0)
        tdSql.checkData(5, 3, 0)
        tdSql.checkData(6, 3, 0)
        tdSql.checkData(7, 3, 0)

        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        tdSql.checkData(0, 3, 0)
        tdSql.checkData(1, 3, 0)
        tdSql.checkData(2, 3, 0)
        tdSql.checkData(3, 3, 0)
        tdSql.checkData(4, 3, 0)
        tdSql.checkData(5, 3, 0)
        tdSql.checkData(6, 3, 0)
        tdSql.checkData(7, 3, 0)


        # db precision "us"
        tdSql.execute('use db_u')

        ## _wstart
        tdSql.query("select _wstart from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 3s);")
        tdSql.checkRows(4)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstart from tb_s session(ts, 5s);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _wstart from tb_s session(ts, 1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _wstart,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select sum(c0),_wstart,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        ##_wstop
        tdSql.query("select _wstop from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 2s);")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 3s);")
        tdSql.checkRows(4)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 5s);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop from tb_s session(ts, 1m);")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select _wstop,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        tdSql.query("select sum(c0),_wstop,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        ##_wduration
        tdSql.query("select _wduration from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        tdSql.checkData(0, 1, 0)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)
        tdSql.checkData(6, 1, 0)
        tdSql.checkData(7, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 2s);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 1, 4000000)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)
        tdSql.checkData(4, 1, 0)
        tdSql.checkData(5, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 3s);")
        tdSql.checkRows(4)
        tdSql.checkData(0, 1, 10000000)
        tdSql.checkData(1, 1, 0)
        tdSql.checkData(2, 1, 0)
        tdSql.checkData(3, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 1, 18000000)
        tdSql.checkData(1, 1, 0)

        tdSql.query("select _wduration from tb_s session(ts, 5s);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 23000000)

        tdSql.query("select _wduration from tb_s session(ts, 1m);")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 23000000)

        tdSql.query("select _wduration,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 1, 18000000)
        tdSql.checkData(1, 1, 0)

        tdSql.query("select sum(c0),_wduration,avg(c0) from tb_s session(ts, 4s);")
        tdSql.checkRows(2)
        tdSql.checkData(0, 2, 18000000)
        tdSql.checkData(1, 2, 0)

        #_wstart,_wstop,_wduration together
        tdSql.query("select _wstart,_wstop,_wduration from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        tdSql.checkData(0, 3, 0)
        tdSql.checkData(1, 3, 0)
        tdSql.checkData(2, 3, 0)
        tdSql.checkData(3, 3, 0)
        tdSql.checkData(4, 3, 0)
        tdSql.checkData(5, 3, 0)
        tdSql.checkData(6, 3, 0)
        tdSql.checkData(7, 3, 0)

        tdSql.query("select _wstart,_wstop,_wduration,avg(c0) from tb_s session(ts, 1s);")
        tdSql.checkRows(8)
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        res = tdSql.getData(0, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(5, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(6, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(7, 2)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")
        tdSql.checkData(0, 3, 0)
        tdSql.checkData(1, 3, 0)
        tdSql.checkData(2, 3, 0)
        tdSql.checkData(3, 3, 0)
        tdSql.checkData(4, 3, 0)
        tdSql.checkData(5, 3, 0)
        tdSql.checkData(6, 3, 0)
        tdSql.checkData(7, 3, 0)

        print("============== STEP 4: select _wsatrt,_wstop,_wduration in nested outer query  ================== ")
        tdSql.execute('use db_m')
        ##_wstart
        tdSql.query('select _wstart from (select _wstart from tb_i interval (2s))')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        tdSql.query('select _wstart from (select _wstart from ctb1_i interval (2s))')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        tdSql.query('select _wstart from (select _wstart from stb_i interval (2s))')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:00")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:02")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:04")

        tdSql.query('select _wstart from (select _wstart from tb_w state_window(c0))')
        tdSql.checkRows(5)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:06")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query('select _wstart from (select _wstart from tb_s session(ts, 2s))')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        ##_wstop
        tdSql.query('select _wstop from (select _wstop from tb_i interval (2s))')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query('select _wstop from (select _wstop from ctb1_i interval (2s))')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        tdSql.query('select _wstop from (select _wstop from stb_i interval (2s))')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01.999000")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.999000")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05.999000")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:01.999000")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:03.999000")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 03:00:05.999000")

        tdSql.query('select _wstop from (select _wstop from tb_w state_window(c0))')
        tdSql.checkRows(5)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:01")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:05")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:08")

        tdSql.query('select _wstop from (select _wstop from tb_s session(ts, 2s))')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:04")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:10")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:14")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:18")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:23")

        ##_wduration
        tdSql.query('select _wduration from (select _wduration from tb_i interval (2s))')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1999)
        tdSql.checkData(1, 0, 1999)
        tdSql.checkData(2, 0, 1999)
        tdSql.query('select _wduration from (select _wduration from ctb1_i interval (2s))')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1999)
        tdSql.checkData(1, 0, 1999)
        tdSql.checkData(2, 0, 1999)
        tdSql.query('select _wduration from (select _wduration from stb_i interval (2s))')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1999)
        tdSql.checkData(1, 0, 1999)
        tdSql.checkData(2, 0, 1999)
        tdSql.checkData(3, 0, 1999)
        tdSql.checkData(4, 0, 1999)
        tdSql.checkData(5, 0, 1999)

        tdSql.query('select _wduration from (select _wduration from tb_w state_window(c0))')
        tdSql.checkRows(5)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1000)
        tdSql.checkData(1, 0, 2000)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 1000)
        tdSql.checkData(4, 0, 0)

        tdSql.query('select _wduration from (select _wduration from tb_s session(ts, 2s))')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(2, 0, 0)
        tdSql.checkData(3, 0, 0)
        tdSql.checkData(4, 0, 0)
        tdSql.checkData(5, 0, 0)

        print("============== STEP 5: select _wstart/_wstop/_wduration other cases  ================== ")

        #distinct
        tdSql.query("select distinct _wstart from tb_i interval (1s)")
        tdSql.query("select distinct _wstart from ctb1_i interval (1s)")
        tdSql.query("select distinct _wstart from stb_i interval (1s)")

        tdSql.query("select distinct _wstop from tb_i interval (1s)")
        tdSql.query("select distinct _wstop from ctb1_i interval (1s)")
        tdSql.query("select distinct _wstop from stb_i interval (1s)")

        tdSql.query("select distinct _wduration from tb_i interval (1s)")
        tdSql.query("select distinct _wduration from ctb1_i interval (1s)")
        tdSql.query("select distinct _wduration from stb_i interval (1s)")

        #_ws,col
        tdSql.query("select _wstart,ts from tb_i interval (1s)")
        tdSql.query("select _wstart,ts from ctb1_i interval (1s)")
        tdSql.query("select _wstart,ts from stb_i interval (1s)")
        #tdSql.query("select _wstart,c0 from tb_i interval (1s)")
        #tdSql.query("select _wstart,c0 from ctb1_i interval (1s)")
        #tdSql.query("select _wstart,c0 from stb_i interval (1s)")
        tdSql.query("select _wstart,_wstart from tb_i interval (1s)")
        tdSql.query("select _wstart,_wstart from ctb1_i interval (1s)")
        tdSql.query("select _wstart,_wstart from stb_i interval (1s)")
        tdSql.query("select _wstart,t0 from ctb1_i interval (1s)")
        tdSql.query("select _wstart,t0 from stb_i interval (1s)")

        tdSql.query("select _wstop,ts from tb_i interval (1s)")
        tdSql.query("select _wstop,ts from ctb1_i interval (1s)")
        tdSql.query("select _wstop,ts from stb_i interval (1s)")
        #tdSql.query("select _wstop,c0 from tb_i interval (1s)")
        #tdSql.query("select _wstop,c0 from ctb1_i interval (1s)")
        #tdSql.query("select _wstop,c0 from stb_i interval (1s)")
        tdSql.query("select _wstop,_wstop from tb_i interval (1s)")
        tdSql.query("select _wstop,_wstop from ctb1_i interval (1s)")
        tdSql.query("select _wstop,_wstop from stb_i interval (1s)")
        tdSql.query("select _wstop,t0 from ctb1_i interval (1s)")
        tdSql.query("select _wstop,t0 from stb_i interval (1s)")

        tdSql.query("select _wduration,ts from tb_i interval (1s)")
        tdSql.query("select _wduration,ts from ctb1_i interval (1s)")
        tdSql.query("select _wduration,ts from stb_i interval (1s)")
        #tdSql.query("select _wduration,c0 from tb_i interval (1s)")
        #tdSql.query("select _wduration,c0 from ctb1_i interval (1s)")
        #tdSql.query("select _wduration,c0 from stb_i interval (1s)")
        tdSql.query("select _wduration,_wduration from tb_i interval (1s)")
        tdSql.query("select _wduration,_wduration from ctb1_i interval (1s)")
        tdSql.query("select _wduration,_wduration from stb_i interval (1s)")
        tdSql.query("select _wduration,t0 from ctb1_i interval (1s)")
        tdSql.query("select _wduration,t0 from stb_i interval (1s)")

        #_ws,constant
        tdSql.query("select _wstart,1 from tb_i interval (1s)")
        tdSql.query("select _wstart,1 from ctb1_i interval (1s)")
        tdSql.query("select _wstart,1 from stb_i interval (1s)")
        tdSql.query("select _wstart,true from tb_i interval (1s)")
        tdSql.query("select _wstart,true from ctb1_i interval (1s)")
        tdSql.query("select _wstart,true from stb_i interval (1s)")
        tdSql.query("select _wstart,'abc' from tb_i interval (1s)")
        tdSql.query("select _wstart,'abc' from ctb1_i interval (1s)")
        tdSql.query("select _wstart,'abc' from stb_i interval (1s)")

        tdSql.query("select _wstop,1 from tb_i interval (1s)")
        tdSql.query("select _wstop,1 from ctb1_i interval (1s)")
        tdSql.query("select _wstop,1 from stb_i interval (1s)")
        tdSql.query("select _wstop,true from tb_i interval (1s)")
        tdSql.query("select _wstop,true from ctb1_i interval (1s)")
        tdSql.query("select _wstop,true from stb_i interval (1s)")
        tdSql.query("select _wstop,'abc' from tb_i interval (1s)")
        tdSql.query("select _wstop,'abc' from ctb1_i interval (1s)")
        tdSql.query("select _wstop,'abc' from stb_i interval (1s)")

        tdSql.query("select _wduration,1 from tb_i interval (1s)")
        tdSql.query("select _wduration,1 from ctb1_i interval (1s)")
        tdSql.query("select _wduration,1 from stb_i interval (1s)")
        tdSql.query("select _wduration,true from tb_i interval (1s)")
        tdSql.query("select _wduration,true from ctb1_i interval (1s)")
        tdSql.query("select _wduration,true from stb_i interval (1s)")
        tdSql.query("select _wduration,'abc' from tb_i interval (1s)")
        tdSql.query("select _wduration,'abc' from ctb1_i interval (1s)")
        tdSql.query("select _wduration,'abc' from stb_i interval (1s)")

        #interval sliding
        tdSql.query("select _wstart from tb_i interval (1s) sliding (1s)")
        tdSql.query("select _wstart from ctb1_i interval (1s) sliding (1s)")
        tdSql.query("select _wstart from stb_i interval (1s) sliding (1s)")

        tdSql.query("select _wstop from tb_i interval (1s) sliding (1s)")
        tdSql.query("select _wstop from ctb1_i interval (1s) sliding (1s)")
        tdSql.query("select _wstop from stb_i interval (1s) sliding (1s)")

        tdSql.query("select _wduration from tb_i interval (1s) sliding (1s)")
        tdSql.query("select _wduration from ctb1_i interval (1s) sliding (1s)")
        tdSql.query("select _wduration from stb_i interval (1s) sliding (1s)")

        #group by
        tdSql.query("select _wstart from stb_i interval (1s) group by tbname")

        tdSql.query("select _wstop from stb_i interval (1s) group by tbname")

        tdSql.query("select _wduration from stb_i interval (1s) group by tbname")

        #order by
        tdSql.query("select _wstart from tb_i interval (1s) order by ts")
        tdSql.query("select _wstart from ctb1_i interval (1s) order by ts")
        tdSql.query("select _wstart from stb_i interval (1s) order by ts")
        tdSql.query("select _wstart from tb_i interval (1s) order by ts desc")
        tdSql.query("select _wstart from ctb1_i interval (1s) order by ts desc")
        tdSql.query("select _wstart from stb_i interval (1s) order by ts desc")

        tdSql.query("select _wstop from tb_i interval (1s) order by ts")
        tdSql.query("select _wstop from ctb1_i interval (1s) order by ts")
        tdSql.query("select _wstop from stb_i interval (1s) order by ts")
        tdSql.query("select _wstop from tb_i interval (1s) order by ts desc")
        tdSql.query("select _wstop from ctb1_i interval (1s) order by ts desc")
        tdSql.query("select _wstop from stb_i interval (1s) order by ts desc")


        tdSql.query("select _wduration from tb_i interval (1s) order by ts")
        tdSql.query("select _wduration from ctb1_i interval (1s) order by ts")
        tdSql.query("select _wduration from stb_i interval (1s) order by ts")
        tdSql.query("select _wduration from tb_i interval (1s) order by ts desc")
        tdSql.query("select _wduration from ctb1_i interval (1s) order by ts desc")
        tdSql.query("select _wduration from stb_i interval (1s) order by ts desc")

        #limit
        tdSql.query("select _wstart from tb_i interval (1s) limit 3")
        tdSql.query("select _wstart from ctb1_i interval (1s) limit 3")
        tdSql.query("select _wstart from stb_i interval (1s) limit 3")

        tdSql.query("select _wstop from tb_i interval (1s) limit 3")
        tdSql.query("select _wstop from ctb1_i interval (1s) limit 3")
        tdSql.query("select _wstop from stb_i interval (1s) limit 3")


        tdSql.query("select _wduration from tb_i interval (1s) limit 3")
        tdSql.query("select _wduration from ctb1_i interval (1s) limit 3")
        tdSql.query("select _wduration from stb_i interval (1s) limit 3")

        ############# not supported ###############
        tdSql.error("select _wstart from tb_i")
        tdSql.error("select _wstart from ctb1_i")
        tdSql.error("select _wstart from stb_i")
        tdSql.error("select _wstart + 1 from tb_i interval (1s)")
        tdSql.error("select _wstart + 1 from ctb1_i interval (1s)")
        tdSql.error("select _wstart + 1 from stb_i interval (1s)")
        tdSql.error("select _wstart + 1.0 from tb_i interval (1s)")
        tdSql.error("select _wstart + 1.0 from ctb1_i interval (1s)")
        tdSql.error("select _wstart + 1.0 from stb_i interval (1s)")
        tdSql.error("select _wstart + true from tb_i interval (1s)")
        tdSql.error("select _wstart + true from ctb1_i interval (1s)")
        tdSql.error("select _wstart + true from stb_i interval (1s)")
        tdSql.error("select _wstart + 'abc' from tb_i interval (1s)")
        tdSql.error("select _wstart + 'abc' from ctb1_i interval (1s)")
        tdSql.error("select _wstart + 'abc' from stb_i interval (1s)")
        tdSql.error("select _wstart + 1s from tb_i interval (1s)")
        tdSql.error("select _wstart + 1s from ctb1_i interval (1s)")
        tdSql.error("select _wstart + 1s from stb_i interval (1s)")
        tdSql.error("select _wstart + ts from tb_i interval (1s)")
        tdSql.error("select _wstart + ts from ctb1_i interval (1s)")
        tdSql.error("select _wstart + ts from stb_i interval (1s)")
        tdSql.error("select _wstart + c0 from tb_i interval (1s)")
        tdSql.error("select _wstart + c0 from ctb1_i interval (1s)")
        tdSql.error("select _wstart + c0 from stb_i interval (1s)")
        tdSql.error("select _wstart + _wstop from tb_i interval (1s)")
        tdSql.error("select _wstart + _wstop from ctb1_i interval (1s)")
        tdSql.error("select _wstart + _wstop from stb_i interval (1s)")
        tdSql.error("select _wstart + _wduration from tb_i interval (1s)")
        tdSql.error("select _wstart + _wduration from ctb1_i interval (1s)")
        tdSql.error("select _wstart + _wduration from stb_i interval (1s)")

        tdSql.error("select _wstop from tb_i")
        tdSql.error("select _wstop from ctb1_i")
        tdSql.error("select _wstop from stb_i")
        tdSql.error("select _wstop + 1 from tb_i interval (1s)")
        tdSql.error("select _wstop + 1 from ctb1_i interval (1s)")
        tdSql.error("select _wstop + 1 from stb_i interval (1s)")
        tdSql.error("select _wstop + 1.0 from tb_i interval (1s)")
        tdSql.error("select _wstop + 1.0 from ctb1_i interval (1s)")
        tdSql.error("select _wstop + 1.0 from stb_i interval (1s)")
        tdSql.error("select _wstop + true from tb_i interval (1s)")
        tdSql.error("select _wstop + true from ctb1_i interval (1s)")
        tdSql.error("select _wstop + true from stb_i interval (1s)")
        tdSql.error("select _wstop + 'abc' from tb_i interval (1s)")
        tdSql.error("select _wstop + 'abc' from ctb1_i interval (1s)")
        tdSql.error("select _wstop + 'abc' from stb_i interval (1s)")
        tdSql.error("select _wstop + 1s from tb_i interval (1s)")
        tdSql.error("select _wstop + 1s from ctb1_i interval (1s)")
        tdSql.error("select _wstop + 1s from stb_i interval (1s)")
        tdSql.error("select _wstop + ts from tb_i interval (1s)")
        tdSql.error("select _wstop + ts from ctb1_i interval (1s)")
        tdSql.error("select _wstop + ts from stb_i interval (1s)")
        tdSql.error("select _wstop + c0 from tb_i interval (1s)")
        tdSql.error("select _wstop + c0 from ctb1_i interval (1s)")
        tdSql.error("select _wstop + c0 from stb_i interval (1s)")
        tdSql.error("select _wstop + _wstart from tb_i interval (1s)")
        tdSql.error("select _wstop + _wstart from ctb1_i interval (1s)")
        tdSql.error("select _wstop + _wstart from stb_i interval (1s)")
        tdSql.error("select _wstop + _wduration from tb_i interval (1s)")
        tdSql.error("select _wstop + _wduration from ctb1_i interval (1s)")
        tdSql.error("select _wstop + _wduration from stb_i interval (1s)")

        tdSql.error("select _wduration from tb_i")
        tdSql.error("select _wduration from ctb1_i")
        tdSql.error("select _wduration from stb_i")
        tdSql.error("select _wduration + 1 from tb_i interval (1s)")
        tdSql.error("select _wduration + 1 from ctb1_i interval (1s)")
        tdSql.error("select _wduration + 1 from stb_i interval (1s)")
        tdSql.error("select _wduration + 1.0 from tb_i interval (1s)")
        tdSql.error("select _wduration + 1.0 from ctb1_i interval (1s)")
        tdSql.error("select _wduration + 1.0 from stb_i interval (1s)")
        tdSql.error("select _wduration + true from tb_i interval (1s)")
        tdSql.error("select _wduration + true from ctb1_i interval (1s)")
        tdSql.error("select _wduration + true from stb_i interval (1s)")
        tdSql.error("select _wduration + 'abc' from tb_i interval (1s)")
        tdSql.error("select _wduration + 'abc' from ctb1_i interval (1s)")
        tdSql.error("select _wduration + 'abc' from stb_i interval (1s)")
        tdSql.error("select _wduration + 1s from tb_i interval (1s)")
        tdSql.error("select _wduration + 1s from ctb1_i interval (1s)")
        tdSql.error("select _wduration + 1s from stb_i interval (1s)")
        tdSql.error("select _wduration + ts from tb_i interval (1s)")
        tdSql.error("select _wduration + ts from ctb1_i interval (1s)")
        tdSql.error("select _wduration + ts from stb_i interval (1s)")
        tdSql.error("select _wduration + c0 from tb_i interval (1s)")
        tdSql.error("select _wduration + c0 from ctb1_i interval (1s)")
        tdSql.error("select _wduration + c0 from stb_i interval (1s)")
        tdSql.error("select _wduration + _wstart from tb_i interval (1s)")
        tdSql.error("select _wduration + _wstart from ctb1_i interval (1s)")
        tdSql.error("select _wduration + _wstart from stb_i interval (1s)")
        tdSql.error("select _wduration + _wduration from tb_i interval (1s)")
        tdSql.error("select _wduration + _wduration from ctb1_i interval (1s)")
        tdSql.error("select _wduration + _wduration from stb_i interval (1s)")


        tdSql.execute('drop database db_m')
        tdSql.execute('drop database db_u')
        tdSql.execute('drop database db_n')

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
