/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.rs.RestfulDatabaseMetaData;
import com.taosdata.jdbc.rs.RestfulStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class RestfulConnection
implements Connection {
    private static final String CONNECTION_IS_CLOSED = "connection is closed.";
    private static final String AUTO_COMMIT_IS_TRUE = "auto commit is true";
    private final String host;
    private final int port;
    private final Properties props;
    private volatile String database;
    private final String url;
    private boolean isClosed;
    private DatabaseMetaData metadata;
    private Map<String, Class<?>> typeMap;
    private Properties clientInfoProps = new Properties();

    public RestfulConnection(String host, String port, Properties props, String database, String url) {
        this.host = host;
        this.port = Integer.parseInt(port);
        this.props = props;
        this.database = database;
        this.url = url;
        this.metadata = new RestfulDatabaseMetaData(url, props.getProperty("user"), this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return new RestfulStatement(this, this.database);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return true;
    }

    @Override
    public void commit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (this.getAutoCommit()) {
            throw new SQLException(AUTO_COMMIT_IS_TRUE);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (this.getAutoCommit()) {
            throw new SQLException(AUTO_COMMIT_IS_TRUE);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        Class<RestfulConnection> clazz = RestfulConnection.class;
        synchronized (RestfulConnection.class) {
            this.database = catalog;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return this.database;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
            }
            default: {
                throw new SQLException("invalid variables");
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("invalid variables");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("invalid variables");
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        Class<RestfulConnection> clazz = RestfulConnection.class;
        synchronized (RestfulConnection.class) {
            if (this.typeMap == null) {
                this.typeMap = new HashMap();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.typeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        Class<RestfulConnection> clazz = RestfulConnection.class;
        synchronized (RestfulConnection.class) {
            this.typeMap = map;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (this.getAutoCommit()) {
            throw new SQLException("invalid variables");
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (this.getAutoCommit()) {
            throw new SQLException("invalid variables");
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        if (this.getAutoCommit()) {
            throw new SQLException("invalid variables");
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("invalid variables");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.isClosed) {
            throw new SQLClientInfoException();
        }
        this.clientInfoProps.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.isClosed) {
            throw new SQLClientInfoException();
        }
        Enumeration<Object> enumer = properties.keys();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            this.clientInfoProps.put(name, properties.getProperty(name));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.isClosed) {
            throw new SQLClientInfoException();
        }
        return this.clientInfoProps.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.isClosed) {
            throw new SQLClientInfoException();
        }
        return this.clientInfoProps;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        Class<RestfulConnection> clazz = RestfulConnection.class;
        synchronized (RestfulConnection.class) {
            this.database = schema;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return this.database;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor can not be null");
        }
        executor.execute(() -> {
            try {
                this.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(CONNECTION_IS_CLOSED);
        }
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Unable to unwrap to " + iface.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUrl() {
        return this.url;
    }
}

