/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 379
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy58;
  bool yy151;
  int8_t yy285;
  SNodeList* yy356;
  SToken yy361;
  SAlterOption yy409;
  int64_t yy457;
  EFillMode yy494;
  EJoinType yy504;
  EOperatorType yy526;
  SDataType yy600;
  ENullOrder yy613;
  SNode* yy616;
  int32_t yy734;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             669
#define YYNRULE              488
#define YYNTOKEN             256
#define YY_MAX_SHIFT         668
#define YY_MIN_SHIFTREDUCE   970
#define YY_MAX_SHIFTREDUCE   1457
#define YY_ERROR_ACTION      1458
#define YY_ACCEPT_ACTION     1459
#define YY_NO_ACTION         1460
#define YY_MIN_REDUCE        1461
#define YY_MAX_REDUCE        1948
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2481)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   532,   73, 1459,  440,  555,  441, 1496,  329,  520,   73,
 /*    10 */  1647,  114,   39,   37,  119,  143,  328,  314,  478, 1693,
 /*    20 */   342, 1462, 1257, 1590, 1597,  147, 1645,  555, 1595, 1555,
 /*    30 */  1800, 1591,  124, 1334,  448, 1255,  441, 1496,  548,  558,
 /*    40 */   347,  391,  104, 1640, 1642,  103,  102,  101,  100,   99,
 /*    50 */    98,   97,   96,   95,  439,  124, 1329,  443, 1782,   33,
 /*    60 */    32,   14,  355,   40,   38,   36,   35,   34, 1263,   39,
 /*    70 */    37, 1397,  122, 1283, 1282,  564,  547,  342,  305, 1257,
 /*    80 */  1926,  426,  145, 1926, 1473,    1, 1800,  159, 1868, 1869,
 /*    90 */  1334, 1873, 1255,  163,  584,  122, 1925, 1923,  558, 1751,
 /*   100 */  1923,  583,   64, 1926,   42,   63, 1020,  665, 1019,  557,
 /*   110 */   158, 1868, 1869, 1329, 1873,  560,  162,   81,   14, 1003,
 /*   120 */  1923, 1336, 1337,   30,  263, 1263, 1814,  177,  176,  223,
 /*   130 */    91, 1783,  586, 1785, 1786,  582, 1021,  577, 1588,   63,
 /*   140 */  1860, 1484,    2,  104,  308, 1856,  103,  102,  101,  100,
 /*   150 */    99,   98,   97,   96,   95, 1526, 1926,  489,  488, 1007,
 /*   160 */  1008,  143,  487,   43,  665,  120, 1258,  197, 1256,  164,
 /*   170 */  1598,  484, 1358, 1923, 1152, 1153,  385,  447, 1336, 1337,
 /*   180 */   443,  149, 1751,   63, 1641, 1642,  474,  470,  466,  462,
 /*   190 */   196, 1236, 1237, 1261, 1262, 1363, 1311, 1312, 1314, 1315,
 /*   200 */  1316, 1317, 1318, 1319,  579,  575, 1327, 1328, 1330, 1331,
 /*   210 */  1332, 1333, 1335, 1338, 1020, 1647, 1019, 1926,   74,  489,
 /*   220 */   488,  194,  330, 1258,  487, 1256,  165,  120,  558,  476,
 /*   230 */   162, 1645,   63,  484, 1923,   33,   32,  519,   27,   40,
 /*   240 */    38,   36,   35,   34, 1021,  165,  165, 1692,  555,  302,
 /*   250 */  1261, 1262,  376, 1311, 1312, 1314, 1315, 1316, 1317, 1318,
 /*   260 */  1319,  579,  575, 1327, 1328, 1330, 1331, 1332, 1333, 1335,
 /*   270 */  1338,   39,   37, 1461,  378,  374,  124,  565, 1926,  342,
 /*   280 */   165, 1257, 1782,  193,  186, 1686,  191, 1875,  309,   49,
 /*   290 */   453,  162, 1334,  503, 1255, 1923,  172,  113,  112,  111,
 /*   300 */   110,  109,  108,  107,  106,  105,  501, 1483,  499,  184,
 /*   310 */  1800, 1872,  384, 1296,  383, 1329,  122, 1573,  559,  532,
 /*   320 */    14, 1356, 1482, 1751,  165,  583,  457, 1263,   39,   37,
 /*   330 */   114,  160, 1868, 1869,  532, 1873,  342,  483, 1257, 1523,
 /*   340 */   319,   11,   10, 1418,    2,   55,  445, 1595, 1751, 1334,
 /*   350 */  1814, 1255, 1280, 1394,   92, 1783,  586, 1785, 1786,  582,
 /*   360 */  1737,  577, 1595, 1751, 1860, 1401,  665,  532,  333, 1856,
 /*   370 */   157, 1282, 1329,  165, 1283, 1357, 1647,  457,  167, 1571,
 /*   380 */  1336, 1337,  161,  346, 1263,  541, 1416, 1417, 1419, 1420,
 /*   390 */  1886,  320, 1645,  318,  317, 1595,  480, 1282, 1362, 1481,
 /*   400 */   482,    8,  642,  641,  640,  639,  350,  364,  638,  637,
 /*   410 */   636,  125,  631,  630,  629,  628,  627,  626,  625,  624,
 /*   420 */   136,  620,  481,  665, 1284, 1258, 1370, 1256,   33,   32,
 /*   430 */   165,  549,   40,   38,   36,   35,   34, 1336, 1337,  619,
 /*   440 */  1751,   29,  340, 1351, 1352, 1353, 1354, 1355, 1359, 1360,
 /*   450 */  1361, 1480, 1261, 1262, 1479, 1311, 1312, 1314, 1315, 1316,
 /*   460 */  1317, 1318, 1319,  579,  575, 1327, 1328, 1330, 1331, 1332,
 /*   470 */  1333, 1335, 1338,   33,   32,  218,  619,   40,   38,   36,
 /*   480 */    35,   34, 1258,  482, 1256,   40,   38,   36,   35,   34,
 /*   490 */  1257, 1686, 1751,   33,   32, 1751, 1769,   40,   38,   36,
 /*   500 */    35,   34,  175, 1255,   63,  481,   77, 1765,   22, 1261,
 /*   510 */  1262, 1285, 1311, 1312, 1314, 1315, 1316, 1317, 1318, 1319,
 /*   520 */   579,  575, 1327, 1328, 1330, 1331, 1332, 1333, 1335, 1338,
 /*   530 */    39,   37, 1339, 1761, 1767,  331, 1263,  156,  342,  345,
 /*   540 */  1257, 1782,  165, 1586,  532,  577,  309,  143, 1313,   88,
 /*   550 */  1634, 1334, 1769, 1255, 1765,  389, 1597,  255,  224,  225,
 /*   560 */    33,   32,  121, 1765,   40,   38,   36,   35,   34, 1800,
 /*   570 */  1587,  173, 1595, 1072, 1329,  665, 1393,  559, 1454, 1356,
 /*   580 */  1761, 1767, 1751,  494,  583,  520, 1263,   39,   37, 1761,
 /*   590 */  1767,  337,  577,  532, 1926,  342, 1694, 1257,  504,   71,
 /*   600 */   544,  577,   70,    9,  390, 1478, 1074,  163, 1334, 1814,
 /*   610 */  1255, 1923,  210,   92, 1783,  586, 1785, 1786,  582,  307,
 /*   620 */   577, 1595,  522, 1860, 1477,  665,  497,  333, 1856,  157,
 /*   630 */   491, 1329, 1281, 1357, 1258,  209, 1256,  353, 1428, 1336,
 /*   640 */  1337,   26, 1476, 1263,  235,  165, 1751,   33,   32, 1887,
 /*   650 */   211,   40,   38,   36,   35,   34, 1362, 1691, 1344,  302,
 /*   660 */     9, 1261, 1262,   58, 1282, 1751,   57,    7, 1453,   33,
 /*   670 */    32,  348, 1926,   40,   38,   36,   35,   34, 1926,  143,
 /*   680 */   550,  545,  665, 1751, 1258, 1924, 1256,  615, 1597, 1923,
 /*   690 */  1638,  162,   36,   35,   34, 1923, 1336, 1337, 1502,   29,
 /*   700 */   340, 1351, 1352, 1353, 1354, 1355, 1359, 1360, 1361,   75,
 /*   710 */   307, 1261, 1262,  522, 1311, 1312, 1314, 1315, 1316, 1317,
 /*   720 */  1318, 1319,  579,  575, 1327, 1328, 1330, 1331, 1332, 1333,
 /*   730 */  1335, 1338,   33,   32,  486,  485,   40,   38,   36,   35,
 /*   740 */    34, 1258, 1875, 1256,  635,  633,  660, 1408, 1110,  608,
 /*   750 */   607,  606, 1114,  605, 1116, 1117,  604, 1119,  601,   61,
 /*   760 */  1125,  598, 1127, 1128,  595,  592, 1871,  352, 1261, 1262,
 /*   770 */  1475, 1311, 1312, 1314, 1315, 1316, 1317, 1318, 1319,  579,
 /*   780 */   575, 1327, 1328, 1330, 1331, 1332, 1333, 1335, 1338,   39,
 /*   790 */    37,  304, 1282, 1280,  617,  668,  505,  342, 1472, 1257,
 /*   800 */   419,  616, 1471,  431, 1638, 1470, 1782,  532, 1926,  270,
 /*   810 */  1334, 1751, 1255,  134,  133,  614,  613,  612,  349, 1696,
 /*   820 */   404,  162,  432,  154,  406, 1923, 1469,  532,  658,  654,
 /*   830 */   650,  646,  268, 1329, 1800, 1595, 1647, 1926,  396, 1751,
 /*   840 */   532, 1313,  584, 1751,  611, 1263, 1751, 1751,  532,  583,
 /*   850 */   162,  411, 1646, 1390, 1923, 1595, 1584,  397, 1047,  412,
 /*   860 */    89,  532,    2,  233,  623, 1263, 1567, 1751, 1595,  393,
 /*   870 */   275, 1875,  456, 1625, 1814,  132, 1595,  142,   93, 1783,
 /*   880 */   586, 1785, 1786,  582,  665,  577, 1007, 1008, 1860, 1595,
 /*   890 */  1468, 1048, 1859, 1856, 1572, 1870,  529,  430, 1336, 1337,
 /*   900 */   425,  424,  423,  422,  421,  418,  417,  416,  415,  414,
 /*   910 */   410,  409,  408,  407,  401,  400,  399,  398,   54,  395,
 /*   920 */   394, 1467, 1466,   28, 1880, 1390,  622,  144,  220,   33,
 /*   930 */    32, 1751,  281,   40,   38,   36,   35,   34, 1570,   44,
 /*   940 */     4,   53,  516, 1258,  532, 1256,  279,   60, 1580, 1228,
 /*   950 */    59,  213,   33,   32, 1465, 1592,   40,   38,   36,   35,
 /*   960 */    34, 1464, 1751, 1751, 1582, 1782,  180,  436,  434, 1313,
 /*   970 */  1261, 1262, 1595, 1311, 1312, 1314, 1315, 1316, 1317, 1318,
 /*   980 */  1319,  579,  575, 1327, 1328, 1330, 1331, 1332, 1333, 1335,
 /*   990 */  1338,  617,  532, 1800,   63, 1751,  532, 1513,  532,  562,
 /*  1000 */   634,  584, 1751, 1725, 1266,   41, 1751,  513,  583,  517,
 /*  1010 */   134,  133,  614,  613,  612,  202,  222,  532,  200,  490,
 /*  1020 */  1595, 1265,  560,  128, 1595,  532, 1595, 1508,  530, 1578,
 /*  1030 */  1296,  573,   90, 1814,  217,  617,  531,   91, 1783,  586,
 /*  1040 */  1785, 1786,  582,  379,  577, 1595, 1782, 1860, 1204,  492,
 /*  1050 */   214,  308, 1856, 1595,  134,  133,  614,  613,  612,  226,
 /*  1060 */   339,  338,  532, 1926,  131,   76,  525,   68,   67,  388,
 /*  1070 */  1271, 1506,  171,  264, 1800, 1770,  162,  555,  382,  567,
 /*  1080 */  1923, 1334,  584, 1264,  132,  204, 1765, 1751,  203,  583,
 /*  1090 */  1595,  303,  206,  495,  372,  205,  370,  366,  362,  168,
 /*  1100 */   357,  354, 1772,  208, 1329,  124,  207,  232,   51,  239,
 /*  1110 */    11,   10, 1761, 1767, 1814,   51, 1263,  578,   92, 1783,
 /*  1120 */   586, 1785, 1786,  582,  577,  577,  560, 1103, 1860, 1782,
 /*  1130 */  1456, 1457,  333, 1856, 1939,  165,   41, 1269,   41,  590,
 /*  1140 */   131, 1774,  132, 1894,  116,  122,  131,  610,  512,   87,
 /*  1150 */  1474, 1415,  242, 1556, 1268,  572,  258, 1800, 1364,   84,
 /*  1160 */   253, 1868,  554, 1348,  553,  584,  542, 1926,  475,  506,
 /*  1170 */  1751,  247,  583, 1801,  351, 1635, 1497, 1890,  252, 1320,
 /*  1180 */   164,  274, 1131, 1135, 1923, 1142,  560, 1140,  556,  135,
 /*  1190 */   356,  257, 1782,  260,    3,  262,    5, 1814, 1280,  359,
 /*  1200 */   363,  288, 1783,  586, 1785, 1786,  582,  315,  577, 1072,
 /*  1210 */   316, 1220,  174,  271, 1272,  392, 1267,  413, 1688,  420,
 /*  1220 */  1800,  428,  427,  429, 1286,  433,  435, 1926,  584, 1289,
 /*  1230 */   437,  183,  438, 1751, 1782,  583,  449,  446,  450, 1288,
 /*  1240 */   164, 1275, 1277,  185, 1923,  451, 1290, 1287,  452,  454,
 /*  1250 */   188,  455,  190,  575, 1327, 1328, 1330, 1331, 1332, 1333,
 /*  1260 */  1814,  192, 1800,   72,   92, 1783,  586, 1785, 1786,  582,
 /*  1270 */   584,  577,  458,  195, 1860, 1751,  477,  583,  333, 1856,
 /*  1280 */  1939,  479, 1585,  568,  115,  199, 1581,  201,  137, 1917,
 /*  1290 */   306,  138,  212, 1583, 1579,  139,  272, 1782,  140,  507,
 /*  1300 */   215,  514, 1814,  508,  518,  526,   92, 1783,  586, 1785,
 /*  1310 */  1786,  582, 1730,  577,  219,  511, 1860,  540,  521,  527,
 /*  1320 */   333, 1856, 1939,  230, 1729, 1800, 1698,  129,  523,  273,
 /*  1330 */   327, 1879,   80,  584,  325,  228,  130, 1596, 1751, 1285,
 /*  1340 */   583,  528,  543,  536,    6,  552, 1901, 1782, 1900,  538,
 /*  1350 */  1891,  539,  332,  546,  560,  237,  537, 1882,  246,  535,
 /*  1360 */   534,  241, 1390,  123, 1782, 1814, 1284,  569,  566,  288,
 /*  1370 */  1783,  586, 1785, 1786,  582, 1800,  577,  334,   48,   82,
 /*  1380 */   251,  588, 1639,  584, 1568,  151, 1876,  276, 1751,  661,
 /*  1390 */   583,  267, 1800,  664,  248, 1926,  249,  662,   52,  250,
 /*  1400 */   581,  150,  280, 1841,  289, 1751,  278,  583,  162, 1745,
 /*  1410 */   299,  298, 1923, 1744,   65, 1814, 1743, 1742,   66,   93,
 /*  1420 */  1783,  586, 1785, 1786,  582, 1782,  577, 1741,  358, 1860,
 /*  1430 */  1738, 1922, 1814,  571, 1856,  563,  296, 1783,  586, 1785,
 /*  1440 */  1786,  582,  580,  577,  574, 1832, 1782,  256, 1942,  259,
 /*  1450 */   360,  570,  261, 1800, 1248,  361, 1249,  169,  365, 1736,
 /*  1460 */   367,  584,  369,  368, 1735,  371, 1751, 1734,  583,  373,
 /*  1470 */  1733,  375, 1732, 1715, 1800,  377,  170,  380,  381, 1223,
 /*  1480 */  1222, 1709,  584, 1708,  386,  387, 1707, 1751, 1192,  583,
 /*  1490 */  1706, 1681,  126, 1814, 1680, 1679, 1678,  146, 1783,  586,
 /*  1500 */  1785, 1786,  582,   69,  577, 1677, 1676, 1675, 1674, 1673,
 /*  1510 */   402,  403, 1672,  405, 1814, 1782, 1671, 1670,   93, 1783,
 /*  1520 */   586, 1785, 1786,  582, 1669,  577, 1668, 1782, 1860, 1667,
 /*  1530 */  1666, 1665, 1664, 1857, 1663, 1662, 1661, 1782,  178,  127,
 /*  1540 */  1657,  561, 1940, 1800, 1660, 1659, 1658, 1656,  326, 1655,
 /*  1550 */  1654,  584,  181,  117,  179, 1800, 1751, 1653,  583, 1652,
 /*  1560 */   533, 1651, 1650,  584, 1194, 1800, 1649, 1648, 1751, 1528,
 /*  1570 */   583, 1527, 1525,  584, 1493, 1492,  155, 1010, 1751, 1009,
 /*  1580 */   583,  182,  118, 1814, 1723,  442, 1717,  297, 1783,  586,
 /*  1590 */  1785, 1786,  582, 1782,  577, 1814, 1705,  444,  189,  297,
 /*  1600 */  1783,  586, 1785, 1786,  582, 1814,  577, 1782, 1704,  292,
 /*  1610 */  1783,  586, 1785, 1786,  582,  187,  577, 1690, 1574, 1524,
 /*  1620 */  1040, 1800, 1522,  459,  460, 1520,  461,  463,  464,  584,
 /*  1630 */   465, 1518,  467, 1516, 1751, 1800,  583,  468,  469,  473,
 /*  1640 */   471, 1505,  472,  581, 1504, 1489, 1576,  551, 1751,   50,
 /*  1650 */   583, 1146,  198, 1575, 1145, 1071,  632,  634, 1068, 1067,
 /*  1660 */  1066, 1814, 1514, 1509,  321,  146, 1783,  586, 1785, 1786,
 /*  1670 */   582,  322,  577, 1507,  323, 1814,  493, 1488,  496,  296,
 /*  1680 */  1783,  586, 1785, 1786,  582, 1782,  577, 1487, 1833,  498,
 /*  1690 */   500, 1486,  502, 1722,   94, 1230, 1716, 1782,  509,  141,
 /*  1700 */  1703,   56, 1701, 1702,  216, 1700,  510, 1699, 1697,  324,
 /*  1710 */  1941,   15, 1689, 1800,  221,  227,   84,  229,  341,  515,
 /*  1720 */    78,  584,   79,   41,  524, 1800, 1751,  231,  583,  234,
 /*  1730 */   343,   16,   23,  584, 1430,  236,  245,  238, 1751,   45,
 /*  1740 */   583, 1772, 1412,  240,   47, 1414,  148, 1782,   17, 1240,
 /*  1750 */   243,   24,  244, 1814, 1407, 1387,   83,  297, 1783,  586,
 /*  1760 */  1785, 1786,  582,   25,  577, 1814,   46, 1386,  254,  297,
 /*  1770 */  1783,  586, 1785, 1786,  582, 1800,  577, 1771,  152,   18,
 /*  1780 */  1447, 1442, 1441,  584,  335, 1436, 1446, 1445, 1751,  336,
 /*  1790 */   583,   10, 1273,   19, 1349, 1817,  576, 1782, 1304, 1324,
 /*  1800 */    13, 1322,   31,  153, 1321,  166,   12,  585,  589,   20,
 /*  1810 */    21, 1782,  587, 1132,  344, 1814, 1129,  593,  591,  282,
 /*  1820 */  1783,  586, 1785, 1786,  582, 1800,  577,  594,  596, 1126,
 /*  1830 */   597,  599,  602,  584,  609, 1124, 1109, 1123, 1751, 1800,
 /*  1840 */   583, 1120, 1118,  600, 1122, 1141,  603,  584, 1121,   85,
 /*  1850 */    86,   62, 1751, 1782,  583, 1137,  265, 1038, 1063,  618,
 /*  1860 */  1078,  621,  266, 1782, 1061, 1814, 1060, 1059, 1058,  283,
 /*  1870 */  1783,  586, 1785, 1786,  582, 1057,  577, 1056, 1055, 1814,
 /*  1880 */  1054, 1800, 1073,  284, 1783,  586, 1785, 1786,  582,  584,
 /*  1890 */   577, 1800, 1075, 1051, 1751, 1050,  583, 1049, 1046,  584,
 /*  1900 */  1045, 1044, 1043, 1521, 1751,  643,  583,  645,  644, 1519,
 /*  1910 */   647,  648,  649, 1517, 1515,  651,  652,  653,  655,  656,
 /*  1920 */   657, 1814, 1503,  659, 1000,  291, 1783,  586, 1785, 1786,
 /*  1930 */   582, 1814,  577, 1485,  269,  293, 1783,  586, 1785, 1786,
 /*  1940 */   582, 1782,  577, 1259,  663,  667,  277,  666, 1460, 1460,
 /*  1950 */  1460, 1460, 1460, 1460, 1460, 1460, 1460, 1782, 1460, 1460,
 /*  1960 */  1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1800,
 /*  1970 */  1460, 1460, 1460, 1460, 1460, 1460, 1460,  584, 1460, 1460,
 /*  1980 */  1460, 1460, 1751, 1460,  583, 1800, 1460, 1460, 1460, 1460,
 /*  1990 */  1460, 1460, 1460,  584, 1460, 1460, 1460, 1460, 1751, 1460,
 /*  2000 */   583, 1460, 1460, 1460, 1460, 1460, 1460, 1782, 1460, 1814,
 /*  2010 */  1460, 1460, 1460,  285, 1783,  586, 1785, 1786,  582, 1782,
 /*  2020 */   577, 1460, 1460, 1460, 1460, 1814, 1460, 1460, 1460,  294,
 /*  2030 */  1783,  586, 1785, 1786,  582, 1800,  577, 1460, 1460, 1460,
 /*  2040 */  1460, 1460, 1460,  584, 1460, 1460, 1460, 1800, 1751, 1460,
 /*  2050 */   583, 1460, 1460, 1460, 1460,  584, 1460, 1460, 1460, 1460,
 /*  2060 */  1751, 1460,  583, 1460, 1460, 1460, 1460, 1460, 1460, 1460,
 /*  2070 */  1460, 1782, 1460, 1460, 1460, 1814, 1460, 1460, 1460,  286,
 /*  2080 */  1783,  586, 1785, 1786,  582, 1782,  577, 1814,  555, 1460,
 /*  2090 */  1460,  295, 1783,  586, 1785, 1786,  582, 1460,  577, 1800,
 /*  2100 */  1460, 1460, 1460, 1460, 1460, 1460, 1460,  584, 1460, 1460,
 /*  2110 */  1460, 1460, 1751, 1800,  583, 1460,  124, 1460, 1460, 1460,
 /*  2120 */  1460,  584, 1460, 1460, 1460, 1460, 1751, 1460,  583, 1460,
 /*  2130 */  1460, 1460, 1460, 1460, 1460, 1460, 1460,  560, 1460, 1814,
 /*  2140 */  1460, 1782, 1460,  287, 1783,  586, 1785, 1786,  582, 1460,
 /*  2150 */   577, 1782, 1460, 1814, 1460, 1460,  122,  300, 1783,  586,
 /*  2160 */  1785, 1786,  582, 1460,  577, 1460, 1460, 1460, 1460, 1800,
 /*  2170 */  1460,  253, 1868,  554, 1460,  553, 1460,  584, 1926, 1800,
 /*  2180 */  1460, 1460, 1751, 1460,  583, 1460, 1460,  584, 1460, 1460,
 /*  2190 */  1460,  162, 1751, 1460,  583, 1923, 1460, 1460, 1460, 1460,
 /*  2200 */  1460, 1782, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1814,
 /*  2210 */  1460, 1460, 1460,  301, 1783,  586, 1785, 1786,  582, 1814,
 /*  2220 */   577, 1460, 1460, 1794, 1783,  586, 1785, 1786,  582, 1800,
 /*  2230 */   577, 1460, 1460, 1460, 1460, 1460, 1460,  584, 1460, 1460,
 /*  2240 */  1460, 1460, 1751, 1460,  583, 1460, 1460, 1460, 1460, 1460,
 /*  2250 */  1460, 1460, 1460, 1782, 1460, 1460, 1460, 1460, 1460, 1460,
 /*  2260 */  1460, 1460, 1460, 1460, 1460, 1460, 1460, 1782, 1460, 1814,
 /*  2270 */  1460, 1460, 1460, 1793, 1783,  586, 1785, 1786,  582, 1782,
 /*  2280 */   577, 1800, 1460, 1460, 1460, 1460, 1460, 1460, 1460,  584,
 /*  2290 */  1460, 1460, 1460, 1460, 1751, 1800,  583, 1460, 1460, 1460,
 /*  2300 */  1460, 1460, 1460,  584, 1460, 1460, 1460, 1800, 1751, 1460,
 /*  2310 */   583, 1460, 1460, 1460, 1460,  584, 1460, 1460, 1460, 1460,
 /*  2320 */  1751, 1814,  583, 1460, 1460, 1792, 1783,  586, 1785, 1786,
 /*  2330 */   582, 1782,  577, 1460, 1460, 1814, 1460, 1460, 1460,  312,
 /*  2340 */  1783,  586, 1785, 1786,  582, 1782,  577, 1814, 1460, 1460,
 /*  2350 */  1460,  311, 1783,  586, 1785, 1786,  582, 1460,  577, 1800,
 /*  2360 */  1460, 1460, 1460, 1460, 1460, 1460, 1460,  584, 1460, 1460,
 /*  2370 */  1460, 1460, 1751, 1800,  583, 1460, 1460, 1460, 1460, 1460,
 /*  2380 */  1460,  584, 1460, 1460, 1460, 1460, 1751, 1460,  583, 1460,
 /*  2390 */  1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1814,
 /*  2400 */  1460, 1782, 1460,  313, 1783,  586, 1785, 1786,  582, 1460,
 /*  2410 */   577, 1460, 1460, 1814, 1460, 1460, 1460,  310, 1783,  586,
 /*  2420 */  1785, 1786,  582, 1460,  577, 1460, 1460, 1460, 1460, 1800,
 /*  2430 */  1460, 1460, 1460, 1460, 1460, 1460, 1460,  584, 1460, 1460,
 /*  2440 */  1460, 1460, 1751, 1460,  583, 1460, 1460, 1460, 1460, 1460,
 /*  2450 */  1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460,
 /*  2460 */  1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1814,
 /*  2470 */  1460, 1460, 1460,  290, 1783,  586, 1785, 1786,  582, 1460,
 /*  2480 */   577,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   267,  271,  256,  263,  267,  265,  266,  279,  302,  271,
 /*    10 */   287,  278,   12,   13,  284,  287,  310,  294,  285,  313,
 /*    20 */    20,    0,   22,  293,  296,  272,  303,  267,  295,  276,
 /*    30 */   287,  293,  295,   33,  263,   35,  265,  266,  295,   20,
 /*    40 */   298,  267,   21,  301,  302,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  264,  295,   56,  267,  259,    8,
 /*    60 */     9,   61,  316,   12,   13,   14,   15,   16,   68,   12,
 /*    70 */    13,   14,  335,   20,   20,   43,  333,   20,  304,   22,
 /*    80 */   357,   79,  258,  357,  260,   85,  287,  350,  351,  352,
 /*    90 */    33,  354,   35,  370,  295,  335,  370,  374,   20,  300,
 /*   100 */   374,  302,    4,  357,   85,   85,   20,  107,   22,  349,
 /*   110 */   350,  351,  352,   56,  354,  316,  370,  269,   61,    4,
 /*   120 */   374,  121,  122,  342,  343,   68,  327,  125,  126,  116,
 /*   130 */   331,  332,  333,  334,  335,  336,   50,  338,  290,   85,
 /*   140 */   341,  259,   85,   21,  345,  346,   24,   25,   26,   27,
 /*   150 */    28,   29,   30,   31,   32,    0,  357,   64,   65,   44,
 /*   160 */    45,  287,   69,   85,  107,   72,  166,   33,  168,  370,
 /*   170 */   296,   78,  148,  374,  121,  122,  316,  264,  121,  122,
 /*   180 */   267,   47,  300,   85,  301,  302,   52,   53,   54,   55,
 /*   190 */    56,  178,  179,  193,  194,  171,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,   20,  287,   22,  357,   84,   64,
 /*   220 */    65,   87,  294,  166,   69,  168,  226,   72,   20,   35,
 /*   230 */   370,  303,   85,   78,  374,    8,    9,  316,  214,   12,
 /*   240 */    13,   14,   15,   16,   50,  226,  226,  312,  267,  314,
 /*   250 */   193,  194,  161,  196,  197,  198,  199,  200,  201,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,   12,   13,    0,  183,  184,  295,  245,  357,   20,
 /*   280 */   226,   22,  259,  149,  150,  295,  152,  329,   61,   85,
 /*   290 */   156,  370,   33,   21,   35,  374,  306,   24,   25,   26,
 /*   300 */    27,   28,   29,   30,   31,   32,   34,  259,   36,  175,
 /*   310 */   287,  353,  165,   86,  167,   56,  335,    0,  295,  267,
 /*   320 */    61,   94,  259,  300,  226,  302,   60,   68,   12,   13,
 /*   330 */   278,  350,  351,  352,  267,  354,   20,  285,   22,    0,
 /*   340 */    37,    1,    2,  193,   85,  278,   14,  295,  300,   33,
 /*   350 */   327,   35,   20,    4,  331,  332,  333,  334,  335,  336,
 /*   360 */     0,  338,  295,  300,  341,   14,  107,  267,  345,  346,
 /*   370 */   347,   20,   56,  226,   20,  148,  287,   60,  278,    0,
 /*   380 */   121,  122,  359,  294,   68,  235,  236,  237,  238,  239,
 /*   390 */   367,   88,  303,   90,   91,  295,   93,   20,  171,  259,
 /*   400 */    97,   85,   63,   64,   65,   66,   67,   47,   69,   70,
 /*   410 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   420 */    81,   82,  119,  107,   20,  166,   86,  168,    8,    9,
 /*   430 */   226,   20,   12,   13,   14,   15,   16,  121,  122,   60,
 /*   440 */   300,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   450 */   223,  259,  193,  194,  259,  196,  197,  198,  199,  200,
 /*   460 */   201,  202,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   470 */   211,  212,  213,    8,    9,   56,   60,   12,   13,   14,
 /*   480 */    15,   16,  166,   97,  168,   12,   13,   14,   15,   16,
 /*   490 */    22,  295,  300,    8,    9,  300,  289,   12,   13,   14,
 /*   500 */    15,   16,  306,   35,   85,  119,   87,  300,   43,  193,
 /*   510 */   194,   20,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   520 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   530 */    12,   13,   14,  326,  327,  328,   68,  286,   20,  279,
 /*   540 */    22,  259,  226,  289,  267,  338,   61,  287,  197,  269,
 /*   550 */   299,   33,  289,   35,  300,  278,  296,  153,  116,  117,
 /*   560 */     8,    9,  282,  300,   12,   13,   14,   15,   16,  287,
 /*   570 */   290,   56,  295,   35,   56,  107,  227,  295,  158,   94,
 /*   580 */   326,  327,  300,    4,  302,  302,   68,   12,   13,  326,
 /*   590 */   327,  328,  338,  267,  357,   20,  313,   22,   19,   84,
 /*   600 */   151,  338,   87,   85,  278,  259,   68,  370,   33,  327,
 /*   610 */    35,  374,   33,  331,  332,  333,  334,  335,  336,  177,
 /*   620 */   338,  295,  180,  341,  259,  107,   47,  345,  346,  347,
 /*   630 */    51,   56,   20,  148,  166,   56,  168,  316,   86,  121,
 /*   640 */   122,    2,  259,   68,  153,  226,  300,    8,    9,  367,
 /*   650 */   117,   12,   13,   14,   15,   16,  171,  312,   14,  314,
 /*   660 */    85,  193,  194,   84,   20,  300,   87,   39,  248,    8,
 /*   670 */     9,  279,  357,   12,   13,   14,   15,   16,  357,  287,
 /*   680 */   231,  232,  107,  300,  166,  370,  168,  297,  296,  374,
 /*   690 */   300,  370,   14,   15,   16,  374,  121,  122,    0,  214,
 /*   700 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  176,
 /*   710 */   177,  193,  194,  180,  196,  197,  198,  199,  200,  201,
 /*   720 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   730 */   212,  213,    8,    9,  273,  274,   12,   13,   14,   15,
 /*   740 */    16,  166,  329,  168,  273,  274,   48,   86,   98,   99,
 /*   750 */   100,  101,  102,  103,  104,  105,  106,  107,  108,    3,
 /*   760 */   110,  111,  112,  113,  114,  115,  353,  316,  193,  194,
 /*   770 */   259,  196,  197,  198,  199,  200,  201,  202,  203,  204,
 /*   780 */   205,  206,  207,  208,  209,  210,  211,  212,  213,   12,
 /*   790 */    13,   18,   20,   20,   97,   19,  316,   20,  259,   22,
 /*   800 */    27,  297,  259,   30,  300,  259,  259,  267,  357,   33,
 /*   810 */    33,  300,   35,  116,  117,  118,  119,  120,  278,    0,
 /*   820 */    47,  370,   49,   47,   51,  374,  259,  267,   52,   53,
 /*   830 */    54,   55,   56,   56,  287,  295,  287,  357,  278,  300,
 /*   840 */   267,  197,  295,  300,   96,   68,  300,  300,  267,  302,
 /*   850 */   370,  278,  303,  225,  374,  295,  288,   84,   35,  278,
 /*   860 */    84,  267,   85,   87,  275,   68,  277,  300,  295,   96,
 /*   870 */   280,  329,  278,  283,  327,   43,  295,  153,  331,  332,
 /*   880 */   333,  334,  335,  336,  107,  338,   44,   45,  341,  295,
 /*   890 */   259,   68,  345,  346,    0,  353,  120,  124,  121,  122,
 /*   900 */   127,  128,  129,  130,  131,  132,  133,  134,  135,  136,
 /*   910 */   137,  138,  139,  140,  141,  142,  143,  144,   86,  146,
 /*   920 */   147,  259,  259,    2,  224,  225,   68,   18,  152,    8,
 /*   930 */     9,  300,   23,   12,   13,   14,   15,   16,    0,   42,
 /*   940 */    43,  153,  154,  166,  267,  168,   37,   38,  288,  173,
 /*   950 */    41,  175,    8,    9,  259,  278,   12,   13,   14,   15,
 /*   960 */    16,  259,  300,  300,  288,  259,   57,   58,   59,  197,
 /*   970 */   193,  194,  295,  196,  197,  198,  199,  200,  201,  202,
 /*   980 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   990 */   213,   97,  267,  287,   85,  300,  267,    0,  267,  243,
 /*  1000 */    43,  295,  300,  278,   35,   43,  300,  278,  302,  278,
 /*  1010 */   116,  117,  118,  119,  120,   89,   43,  267,   92,   22,
 /*  1020 */   295,   35,  316,   43,  295,  267,  295,    0,  278,  288,
 /*  1030 */    86,   61,  123,  327,   56,   97,  278,  331,  332,  333,
 /*  1040 */   334,  335,  336,   86,  338,  295,  259,  341,   86,   22,
 /*  1050 */   288,  345,  346,  295,  116,  117,  118,  119,  120,   86,
 /*  1060 */    12,   13,  267,  357,   43,   87,   86,  158,  159,  160,
 /*  1070 */    22,    0,  163,  278,  287,  289,  370,  267,  169,   43,
 /*  1080 */   374,   33,  295,   35,   43,   89,  300,  300,   92,  302,
 /*  1090 */   295,  182,   89,   22,  185,   92,  187,  188,  189,  190,
 /*  1100 */   191,  192,   46,   89,   56,  295,   92,   86,   43,   43,
 /*  1110 */     1,    2,  326,  327,  327,   43,   68,  288,  331,  332,
 /*  1120 */   333,  334,  335,  336,  338,  338,  316,   86,  341,  259,
 /*  1130 */   121,  122,  345,  346,  347,  226,   43,  168,   43,   43,
 /*  1140 */    43,   85,   43,  356,   43,  335,   43,  288,  320,   85,
 /*  1150 */   260,   86,   86,  276,  168,  107,  377,  287,   86,   95,
 /*  1160 */   350,  351,  352,  193,  354,  295,  368,  357,  268,  323,
 /*  1170 */   300,  364,  302,  287,  268,  299,  266,  330,  348,   86,
 /*  1180 */   370,   86,   86,   86,  374,   86,  316,   86,  355,   86,
 /*  1190 */   325,  371,  259,  371,  358,  371,  228,  327,   20,  267,
 /*  1200 */    47,  331,  332,  333,  334,  335,  336,  324,  338,   35,
 /*  1210 */   273,  164,   42,  318,  166,  307,  168,  267,  267,  307,
 /*  1220 */   287,  148,  305,  305,   20,  267,  267,  357,  295,   20,
 /*  1230 */   267,  271,  261,  300,  259,  302,  322,  261,  302,   20,
 /*  1240 */   370,  193,  194,  271,  374,  315,   20,   20,  317,  315,
 /*  1250 */   271,  308,  271,  205,  206,  207,  208,  209,  210,  211,
 /*  1260 */   327,  271,  287,  271,  331,  332,  333,  334,  335,  336,
 /*  1270 */   295,  338,  267,  271,  341,  300,  261,  302,  345,  346,
 /*  1280 */   347,  287,  287,  247,  267,  287,  287,  287,  287,  356,
 /*  1290 */   261,  287,  269,  287,  287,  287,  322,  259,  287,  174,
 /*  1300 */   269,  267,  327,  321,  267,  150,  331,  332,  333,  334,
 /*  1310 */   335,  336,  300,  338,  269,  302,  341,  233,  300,  309,
 /*  1320 */   345,  346,  347,  269,  300,  287,  300,  311,  300,  283,
 /*  1330 */   300,  356,  269,  295,  315,  295,  311,  295,  300,   20,
 /*  1340 */   302,  308,  234,  300,  240,  157,  363,  259,  363,  300,
 /*  1350 */   330,  300,  300,  300,  316,  311,  242,  366,  365,  241,
 /*  1360 */   229,  311,  225,  295,  259,  327,   20,  246,  244,  331,
 /*  1370 */   332,  333,  334,  335,  336,  287,  338,  249,   85,   85,
 /*  1380 */   325,  291,  300,  295,  277,  363,  329,  267,  300,   36,
 /*  1390 */   302,  269,  287,  261,  362,  357,  361,  262,  319,  360,
 /*  1400 */   295,  314,  257,  344,  281,  300,  270,  302,  370,    0,
 /*  1410 */   281,  281,  374,    0,  176,  327,    0,    0,   42,  331,
 /*  1420 */   332,  333,  334,  335,  336,  259,  338,    0,   76,  341,
 /*  1430 */     0,  373,  327,  345,  346,  373,  331,  332,  333,  334,
 /*  1440 */   335,  336,  337,  338,  339,  340,  259,  372,  378,  372,
 /*  1450 */    35,  373,  372,  287,   35,  186,   35,   35,  186,    0,
 /*  1460 */    35,  295,  186,   35,    0,  186,  300,    0,  302,   35,
 /*  1470 */     0,   22,    0,    0,  287,   35,   85,  171,  170,  168,
 /*  1480 */   166,    0,  295,    0,  162,  161,    0,  300,   46,  302,
 /*  1490 */     0,    0,   42,  327,    0,    0,    0,  331,  332,  333,
 /*  1500 */   334,  335,  336,  145,  338,    0,    0,    0,    0,    0,
 /*  1510 */   140,   35,    0,  140,  327,  259,    0,    0,  331,  332,
 /*  1520 */   333,  334,  335,  336,    0,  338,    0,  259,  341,    0,
 /*  1530 */     0,    0,    0,  346,    0,    0,    0,  259,   56,   42,
 /*  1540 */     0,  375,  376,  287,    0,    0,    0,    0,  292,    0,
 /*  1550 */     0,  295,   42,   39,   56,  287,  300,    0,  302,    0,
 /*  1560 */   292,    0,    0,  295,   22,  287,    0,    0,  300,    0,
 /*  1570 */   302,    0,    0,  295,    0,    0,   43,   14,  300,   14,
 /*  1580 */   302,   40,   39,  327,    0,   46,    0,  331,  332,  333,
 /*  1590 */   334,  335,  336,  259,  338,  327,    0,   46,  157,  331,
 /*  1600 */   332,  333,  334,  335,  336,  327,  338,  259,    0,  331,
 /*  1610 */   332,  333,  334,  335,  336,   39,  338,    0,    0,    0,
 /*  1620 */    62,  287,    0,   35,   47,    0,   39,   35,   47,  295,
 /*  1630 */    39,    0,   35,    0,  300,  287,  302,   47,   39,   39,
 /*  1640 */    35,    0,   47,  295,    0,    0,    0,  369,  300,   94,
 /*  1650 */   302,   35,   92,    0,   22,   35,   43,   43,   35,   35,
 /*  1660 */    22,  327,    0,    0,   22,  331,  332,  333,  334,  335,
 /*  1670 */   336,   22,  338,    0,   22,  327,   49,    0,   35,  331,
 /*  1680 */   332,  333,  334,  335,  336,  259,  338,    0,  340,   35,
 /*  1690 */    35,    0,   22,    0,   20,   35,    0,  259,   22,  172,
 /*  1700 */     0,  153,    0,    0,  150,    0,  153,    0,    0,  153,
 /*  1710 */   376,   85,    0,  287,   86,   85,   95,   39,  292,  155,
 /*  1720 */    85,  295,   85,   43,  151,  287,  300,  149,  302,   46,
 /*  1730 */   292,  230,   85,  295,   86,   85,   46,   86,  300,  224,
 /*  1740 */   302,   46,   86,   85,   43,   86,   85,  259,  230,  181,
 /*  1750 */    85,   85,   43,  327,   86,   86,   85,  331,  332,  333,
 /*  1760 */   334,  335,  336,   43,  338,  327,   43,   86,   46,  331,
 /*  1770 */   332,  333,  334,  335,  336,  287,  338,   46,   46,   43,
 /*  1780 */    86,   35,   35,  295,   35,   86,   35,   35,  300,   35,
 /*  1790 */   302,    2,   22,   43,  193,   85,   85,  259,   22,   86,
 /*  1800 */   230,   86,   85,   46,   86,   46,   85,  195,   35,   85,
 /*  1810 */    85,  259,   96,   86,   35,  327,   86,   35,   85,  331,
 /*  1820 */   332,  333,  334,  335,  336,  287,  338,   85,   35,   86,
 /*  1830 */    85,   35,   35,  295,   97,  109,   22,  109,  300,  287,
 /*  1840 */   302,   86,   86,   85,  109,   35,   85,  295,  109,   85,
 /*  1850 */    85,   85,  300,  259,  302,   22,   43,   62,   35,   61,
 /*  1860 */    68,   83,   43,  259,   35,  327,   35,   35,   22,  331,
 /*  1870 */   332,  333,  334,  335,  336,   35,  338,   22,   35,  327,
 /*  1880 */    35,  287,   35,  331,  332,  333,  334,  335,  336,  295,
 /*  1890 */   338,  287,   68,   35,  300,   35,  302,   35,   35,  295,
 /*  1900 */    35,   22,   35,    0,  300,   35,  302,   39,   47,    0,
 /*  1910 */    35,   47,   39,    0,    0,   35,   47,   39,   35,   47,
 /*  1920 */    39,  327,    0,   35,   35,  331,  332,  333,  334,  335,
 /*  1930 */   336,  327,  338,    0,   22,  331,  332,  333,  334,  335,
 /*  1940 */   336,  259,  338,   22,   21,   20,   22,   21,  379,  379,
 /*  1950 */   379,  379,  379,  379,  379,  379,  379,  259,  379,  379,
 /*  1960 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  287,
 /*  1970 */   379,  379,  379,  379,  379,  379,  379,  295,  379,  379,
 /*  1980 */   379,  379,  300,  379,  302,  287,  379,  379,  379,  379,
 /*  1990 */   379,  379,  379,  295,  379,  379,  379,  379,  300,  379,
 /*  2000 */   302,  379,  379,  379,  379,  379,  379,  259,  379,  327,
 /*  2010 */   379,  379,  379,  331,  332,  333,  334,  335,  336,  259,
 /*  2020 */   338,  379,  379,  379,  379,  327,  379,  379,  379,  331,
 /*  2030 */   332,  333,  334,  335,  336,  287,  338,  379,  379,  379,
 /*  2040 */   379,  379,  379,  295,  379,  379,  379,  287,  300,  379,
 /*  2050 */   302,  379,  379,  379,  379,  295,  379,  379,  379,  379,
 /*  2060 */   300,  379,  302,  379,  379,  379,  379,  379,  379,  379,
 /*  2070 */   379,  259,  379,  379,  379,  327,  379,  379,  379,  331,
 /*  2080 */   332,  333,  334,  335,  336,  259,  338,  327,  267,  379,
 /*  2090 */   379,  331,  332,  333,  334,  335,  336,  379,  338,  287,
 /*  2100 */   379,  379,  379,  379,  379,  379,  379,  295,  379,  379,
 /*  2110 */   379,  379,  300,  287,  302,  379,  295,  379,  379,  379,
 /*  2120 */   379,  295,  379,  379,  379,  379,  300,  379,  302,  379,
 /*  2130 */   379,  379,  379,  379,  379,  379,  379,  316,  379,  327,
 /*  2140 */   379,  259,  379,  331,  332,  333,  334,  335,  336,  379,
 /*  2150 */   338,  259,  379,  327,  379,  379,  335,  331,  332,  333,
 /*  2160 */   334,  335,  336,  379,  338,  379,  379,  379,  379,  287,
 /*  2170 */   379,  350,  351,  352,  379,  354,  379,  295,  357,  287,
 /*  2180 */   379,  379,  300,  379,  302,  379,  379,  295,  379,  379,
 /*  2190 */   379,  370,  300,  379,  302,  374,  379,  379,  379,  379,
 /*  2200 */   379,  259,  379,  379,  379,  379,  379,  379,  379,  327,
 /*  2210 */   379,  379,  379,  331,  332,  333,  334,  335,  336,  327,
 /*  2220 */   338,  379,  379,  331,  332,  333,  334,  335,  336,  287,
 /*  2230 */   338,  379,  379,  379,  379,  379,  379,  295,  379,  379,
 /*  2240 */   379,  379,  300,  379,  302,  379,  379,  379,  379,  379,
 /*  2250 */   379,  379,  379,  259,  379,  379,  379,  379,  379,  379,
 /*  2260 */   379,  379,  379,  379,  379,  379,  379,  259,  379,  327,
 /*  2270 */   379,  379,  379,  331,  332,  333,  334,  335,  336,  259,
 /*  2280 */   338,  287,  379,  379,  379,  379,  379,  379,  379,  295,
 /*  2290 */   379,  379,  379,  379,  300,  287,  302,  379,  379,  379,
 /*  2300 */   379,  379,  379,  295,  379,  379,  379,  287,  300,  379,
 /*  2310 */   302,  379,  379,  379,  379,  295,  379,  379,  379,  379,
 /*  2320 */   300,  327,  302,  379,  379,  331,  332,  333,  334,  335,
 /*  2330 */   336,  259,  338,  379,  379,  327,  379,  379,  379,  331,
 /*  2340 */   332,  333,  334,  335,  336,  259,  338,  327,  379,  379,
 /*  2350 */   379,  331,  332,  333,  334,  335,  336,  379,  338,  287,
 /*  2360 */   379,  379,  379,  379,  379,  379,  379,  295,  379,  379,
 /*  2370 */   379,  379,  300,  287,  302,  379,  379,  379,  379,  379,
 /*  2380 */   379,  295,  379,  379,  379,  379,  300,  379,  302,  379,
 /*  2390 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  327,
 /*  2400 */   379,  259,  379,  331,  332,  333,  334,  335,  336,  379,
 /*  2410 */   338,  379,  379,  327,  379,  379,  379,  331,  332,  333,
 /*  2420 */   334,  335,  336,  379,  338,  379,  379,  379,  379,  287,
 /*  2430 */   379,  379,  379,  379,  379,  379,  379,  295,  379,  379,
 /*  2440 */   379,  379,  300,  379,  302,  379,  379,  379,  379,  379,
 /*  2450 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  379,
 /*  2460 */   379,  379,  379,  379,  379,  379,  379,  379,  379,  327,
 /*  2470 */   379,  379,  379,  331,  332,  333,  334,  335,  336,  379,
 /*  2480 */   338,
};
#define YY_SHIFT_COUNT    (668)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1933)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   909,    0,    0,   57,   57,  259,  259,  259,  316,  316,
 /*    10 */   259,  259,  518,  575,  777,  575,  575,  575,  575,  575,
 /*    20 */   575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
 /*    30 */   575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
 /*    40 */   575,  575,   19,   19,   78,   78,   78, 1048, 1048,   54,
 /*    50 */  1048, 1048,  147,  419,   20,  204,   20,  208,  208,  115,
 /*    60 */   115,   98,   53,   20,   20,  208,  208,  208,  208,  208,
 /*    70 */   208,  208,  208,  208,  266,  208,  208,  208,  354,  377,
 /*    80 */   208,  208,  377,  411,  208,  377,  377,  377,  208,  416,
 /*    90 */   773,  227,  485,  485,  122,  468,  468,  468,  468,  468,
 /*   100 */   468,  468,  468,  468,  468,  468,  468,  468,  468,  468,
 /*   110 */   468,  468,  468,  468,  303,   93,   53,  332,  332,  317,
 /*   120 */   538,  379,  404,  404,  404,  538,  612,  612,  354,  819,
 /*   130 */   819,  377,  377,  797,  797,  748,  858,  650,  650,  650,
 /*   140 */   650,  650,  650,  650,  776,   21,  420,  155,  150,  194,
 /*   150 */   533,  449,  351,  644,   86,  842,  386,  491,  700,  628,
 /*   160 */   700,  897,  756,  756,  756,  349,  772,  968, 1178, 1153,
 /*   170 */  1174, 1047, 1170, 1178, 1178, 1170, 1073, 1073, 1178, 1178,
 /*   180 */  1178, 1204, 1204, 1209,  266,  354,  266, 1219, 1226,  266,
 /*   190 */  1219,  266, 1227,  266,  266, 1178,  266, 1204,  377,  377,
 /*   200 */   377,  377,  377,  377,  377,  377,  377,  377,  377, 1178,
 /*   210 */  1204,  797, 1209,  416, 1125,  354,  416, 1178, 1178, 1219,
 /*   220 */   416, 1084,  797,  797,  797,  797, 1084,  797, 1155,  612,
 /*   230 */  1227,  416,  748,  416,  612, 1319,  797, 1108, 1084,  797,
 /*   240 */   797, 1108, 1084,  797,  797,  377, 1104, 1188, 1108, 1114,
 /*   250 */  1118, 1131,  968, 1137,  612, 1346, 1121, 1124, 1128, 1121,
 /*   260 */  1124, 1121, 1124, 1293, 1294,  797,  858, 1178,  416, 1353,
 /*   270 */  1204, 2481, 2481, 2481, 2481, 2481, 2481, 2481,  339,  134,
 /*   280 */   273,  579,  552,  465,  661,  639,  921,  724,  944,  894,
 /*   290 */    51,   51,   51,   51,   51,   51,   51,   51,  938,  697,
 /*   300 */   473,  473,  442,   91,  515,    2,  272,   13,  340,   24,
 /*   310 */   678,  678,  678,  678,  832,  360,  957,  926,  996, 1003,
 /*   320 */  1014,  997, 1027, 1071,  978,  788,  962,  973,  980, 1021,
 /*   330 */  1041, 1065, 1066, 1109, 1009,   32, 1036, 1072,  969,  986,
 /*   340 */   970, 1093, 1056, 1095, 1096, 1097, 1099, 1101, 1103, 1064,
 /*   350 */   823,  698, 1409, 1413, 1238, 1416, 1417, 1376, 1427, 1352,
 /*   360 */  1430, 1415, 1269, 1419, 1421, 1422, 1272, 1459, 1425, 1428,
 /*   370 */  1276, 1464, 1279, 1467, 1434, 1470, 1449, 1472, 1440, 1473,
 /*   380 */  1391, 1306, 1308, 1311, 1314, 1481, 1483, 1322, 1324, 1486,
 /*   390 */  1490, 1442, 1491, 1450, 1494, 1495, 1496, 1358, 1505, 1506,
 /*   400 */  1507, 1508, 1509, 1370, 1476, 1512, 1373, 1516, 1517, 1524,
 /*   410 */  1526, 1529, 1530, 1531, 1532, 1534, 1535, 1536, 1544, 1545,
 /*   420 */  1546, 1497, 1540, 1547, 1549, 1550, 1557, 1559, 1542, 1561,
 /*   430 */  1562, 1566, 1567, 1569, 1482, 1571, 1498, 1572, 1574, 1510,
 /*   440 */  1514, 1533, 1563, 1539, 1565, 1551, 1575, 1541, 1543, 1584,
 /*   450 */  1586, 1596, 1576, 1441, 1608, 1617, 1618, 1558, 1619, 1622,
 /*   460 */  1588, 1577, 1587, 1625, 1592, 1581, 1591, 1631, 1597, 1590,
 /*   470 */  1599, 1633, 1605, 1595, 1600, 1641, 1644, 1645, 1646, 1555,
 /*   480 */  1560, 1616, 1632, 1653, 1620, 1613, 1614, 1623, 1624, 1638,
 /*   490 */  1662, 1642, 1663, 1649, 1627, 1673, 1652, 1643, 1677, 1654,
 /*   500 */  1687, 1655, 1691, 1670, 1674, 1693, 1548, 1660, 1696, 1527,
 /*   510 */  1676, 1553, 1554, 1700, 1702, 1556, 1564, 1703, 1705, 1707,
 /*   520 */  1626, 1628, 1568, 1708, 1630, 1573, 1635, 1712, 1678, 1578,
 /*   530 */  1637, 1621, 1683, 1680, 1501, 1647, 1648, 1650, 1651, 1656,
 /*   540 */  1658, 1701, 1659, 1661, 1665, 1666, 1668, 1709, 1690, 1695,
 /*   550 */  1671, 1720, 1518, 1669, 1681, 1722, 1515, 1723, 1731, 1732,
 /*   560 */  1694, 1736, 1570, 1699, 1746, 1747, 1749, 1751, 1752, 1754,
 /*   570 */  1699, 1789, 1770, 1601, 1750, 1710, 1713, 1711, 1715, 1717,
 /*   580 */  1718, 1757, 1721, 1724, 1759, 1776, 1612, 1725, 1716, 1727,
 /*   590 */  1773, 1779, 1733, 1730, 1782, 1742, 1743, 1793, 1745, 1755,
 /*   600 */  1796, 1758, 1756, 1797, 1761, 1726, 1728, 1735, 1739, 1814,
 /*   610 */  1737, 1764, 1765, 1810, 1766, 1813, 1813, 1833, 1795, 1798,
 /*   620 */  1823, 1792, 1778, 1819, 1829, 1831, 1832, 1846, 1840, 1855,
 /*   630 */  1843, 1845, 1824, 1613, 1847, 1614, 1858, 1860, 1862, 1863,
 /*   640 */  1865, 1879, 1867, 1903, 1870, 1861, 1868, 1909, 1875, 1864,
 /*   650 */  1873, 1913, 1880, 1869, 1878, 1914, 1883, 1872, 1881, 1922,
 /*   660 */  1888, 1889, 1933, 1912, 1923, 1921, 1924, 1926, 1925,
};
#define YY_REDUCE_COUNT (277)
#define YY_REDUCE_MIN   (-294)
#define YY_REDUCE_MAX   (2142)
static const short yy_reduce_ofst[] = {
 /*     0 */  -254, -201,  706,   23,  282,  787,  933,  975,  870, 1038,
 /*    10 */   547, 1088, 1105, 1166, 1187, 1256, 1268, 1278, 1334, 1348,
 /*    20 */  1426, 1438, 1488, 1538, 1552, 1594, 1604, 1682, 1698, 1748,
 /*    30 */  1760, 1812, 1826, 1882, 1892, 1942, 1994, 2008, 2020, 2072,
 /*    40 */  2086, 2142,  810, 1821, -240, -263,  -19,  207,  263, -277,
 /*    50 */   254,  786, -140,  -79,  321,  451,  480, -267,   52, -260,
 /*    60 */  -229, -274, -258,  237,  315,   67,  100,  277,  326,  560,
 /*    70 */   573,  581,  594,  677, -270,  725,  729,  731, -294, -272,
 /*    80 */   750,  758,  -72, -257,  795,  260,   89,  392,  540,  280,
 /*    90 */  -226, -219, -219, -219, -176, -118,   48,   63,  140,  192,
 /*   100 */   195,  346,  365,  383,  511,  539,  543,  546,  567,  631,
 /*   110 */   662,  663,  695,  702,  251, -247, -117, -210,  -87, -262,
 /*   120 */   461, -152,  -42,  413,  542,  471,  -10,  196,  283,  -65,
 /*   130 */   345, -126,  549,  390,  504,  590,  589,  568,  660,  676,
 /*   140 */   741,  762,  829,  859,  828,  890,  779,  877,  798,  900,
 /*   150 */   846,  807,  886,  886,  906,  910,  876,  847,  833,  833,
 /*   160 */   833,  830,  820,  822,  824,  836,  886,  865,  932,  883,
 /*   170 */   937,  895,  908,  950,  951,  912,  917,  918,  958,  959,
 /*   180 */   963,  971,  976,  914,  960,  936,  972,  930,  931,  979,
 /*   190 */   934,  981,  943,  990,  992, 1005, 1002, 1015,  994,  995,
 /*   200 */   998,  999, 1000, 1001, 1004, 1006, 1007, 1008, 1011, 1017,
 /*   210 */  1029, 1012,  974, 1023,  982, 1013, 1031, 1034, 1037, 1019,
 /*   220 */  1045, 1016, 1018, 1024, 1026, 1028, 1025, 1030, 1010, 1040,
 /*   230 */  1033, 1054, 1046, 1063, 1042, 1020, 1043,  983, 1044, 1049,
 /*   240 */  1051,  985, 1050, 1052, 1053,  886,  991,  993, 1022, 1032,
 /*   250 */  1035, 1039, 1055,  833, 1068, 1057, 1058, 1075, 1070, 1062,
 /*   260 */  1077, 1078, 1080, 1059, 1090, 1082, 1107, 1120, 1122, 1135,
 /*   270 */  1132, 1079, 1087, 1123, 1129, 1130, 1136, 1145,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*    10 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*    20 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*    30 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*    40 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*    50 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*    60 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*    70 */  1458, 1458, 1458, 1458, 1532, 1458, 1458, 1458, 1458, 1458,
 /*    80 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1530,
 /*    90 */  1682, 1458, 1862, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   100 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   110 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1532,
 /*   120 */  1458, 1530, 1874, 1874, 1874, 1458, 1458, 1458, 1458, 1726,
 /*   130 */  1726, 1458, 1458, 1458, 1458, 1624, 1458, 1458, 1458, 1458,
 /*   140 */  1458, 1458, 1458, 1458, 1718, 1458, 1943, 1458, 1458, 1458,
 /*   150 */  1724, 1897, 1458, 1458, 1458, 1458, 1577, 1889, 1866, 1880,
 /*   160 */  1867, 1864, 1928, 1928, 1928, 1883, 1458, 1893, 1458, 1458,
 /*   170 */  1458, 1710, 1687, 1458, 1458, 1687, 1684, 1684, 1458, 1458,
 /*   180 */  1458, 1458, 1458, 1458, 1532, 1458, 1532, 1458, 1458, 1532,
 /*   190 */  1458, 1532, 1458, 1532, 1532, 1458, 1532, 1458, 1458, 1458,
 /*   200 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   210 */  1458, 1458, 1458, 1530, 1720, 1458, 1530, 1458, 1458, 1458,
 /*   220 */  1530, 1902, 1458, 1458, 1458, 1458, 1902, 1458, 1458, 1458,
 /*   230 */  1458, 1530, 1458, 1530, 1458, 1458, 1458, 1904, 1902, 1458,
 /*   240 */  1458, 1904, 1902, 1458, 1458, 1458, 1916, 1912, 1904, 1920,
 /*   250 */  1918, 1895, 1893, 1880, 1458, 1458, 1934, 1930, 1946, 1934,
 /*   260 */  1930, 1934, 1930, 1458, 1593, 1458, 1458, 1458, 1530, 1490,
 /*   270 */  1458, 1712, 1726, 1627, 1627, 1627, 1533, 1463, 1458, 1458,
 /*   280 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   290 */  1799, 1915, 1914, 1838, 1837, 1836, 1834, 1798, 1458, 1589,
 /*   300 */  1797, 1796, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   310 */  1790, 1791, 1789, 1788, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   320 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   330 */  1458, 1458, 1458, 1863, 1458, 1931, 1935, 1458, 1458, 1458,
 /*   340 */  1458, 1458, 1773, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   350 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   360 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   370 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   380 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   390 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   400 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   410 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   420 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   430 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   440 */  1458, 1495, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   450 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   460 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   470 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   480 */  1458, 1458, 1458, 1458, 1458, 1561, 1560, 1458, 1458, 1458,
 /*   490 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   500 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   510 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   520 */  1458, 1458, 1458, 1730, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   530 */  1458, 1458, 1458, 1896, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   540 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1773,
 /*   550 */  1458, 1913, 1458, 1873, 1869, 1458, 1458, 1865, 1772, 1458,
 /*   560 */  1458, 1929, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   570 */  1458, 1858, 1458, 1458, 1831, 1816, 1458, 1458, 1458, 1458,
 /*   580 */  1458, 1458, 1458, 1458, 1458, 1458, 1784, 1458, 1458, 1458,
 /*   590 */  1458, 1458, 1621, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   600 */  1458, 1458, 1458, 1458, 1458, 1606, 1604, 1603, 1602, 1458,
 /*   610 */  1599, 1458, 1458, 1458, 1458, 1630, 1629, 1458, 1458, 1458,
 /*   620 */  1458, 1458, 1458, 1553, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   630 */  1458, 1458, 1458, 1544, 1458, 1543, 1458, 1458, 1458, 1458,
 /*   640 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   650 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
 /*   660 */  1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458, 1458,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  250,  /*  NK_BITNOT => ID */
  250,  /*     VALUES => ID */
  250,  /*     IMPORT => ID */
  250,  /*    NK_SEMI => ID */
  250,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "FSYNC",
  /*   70 */ "MAXROWS",
  /*   71 */ "MINROWS",
  /*   72 */ "KEEP",
  /*   73 */ "PAGES",
  /*   74 */ "PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "WAL",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "NK_COLON",
  /*   84 */ "TABLE",
  /*   85 */ "NK_LP",
  /*   86 */ "NK_RP",
  /*   87 */ "STABLE",
  /*   88 */ "ADD",
  /*   89 */ "COLUMN",
  /*   90 */ "MODIFY",
  /*   91 */ "RENAME",
  /*   92 */ "TAG",
  /*   93 */ "SET",
  /*   94 */ "NK_EQ",
  /*   95 */ "USING",
  /*   96 */ "TAGS",
  /*   97 */ "COMMENT",
  /*   98 */ "BOOL",
  /*   99 */ "TINYINT",
  /*  100 */ "SMALLINT",
  /*  101 */ "INT",
  /*  102 */ "INTEGER",
  /*  103 */ "BIGINT",
  /*  104 */ "FLOAT",
  /*  105 */ "DOUBLE",
  /*  106 */ "BINARY",
  /*  107 */ "TIMESTAMP",
  /*  108 */ "NCHAR",
  /*  109 */ "UNSIGNED",
  /*  110 */ "JSON",
  /*  111 */ "VARCHAR",
  /*  112 */ "MEDIUMBLOB",
  /*  113 */ "BLOB",
  /*  114 */ "VARBINARY",
  /*  115 */ "DECIMAL",
  /*  116 */ "MAX_DELAY",
  /*  117 */ "WATERMARK",
  /*  118 */ "ROLLUP",
  /*  119 */ "TTL",
  /*  120 */ "SMA",
  /*  121 */ "FIRST",
  /*  122 */ "LAST",
  /*  123 */ "SHOW",
  /*  124 */ "DATABASES",
  /*  125 */ "TABLES",
  /*  126 */ "STABLES",
  /*  127 */ "MNODES",
  /*  128 */ "MODULES",
  /*  129 */ "QNODES",
  /*  130 */ "FUNCTIONS",
  /*  131 */ "INDEXES",
  /*  132 */ "ACCOUNTS",
  /*  133 */ "APPS",
  /*  134 */ "CONNECTIONS",
  /*  135 */ "LICENCE",
  /*  136 */ "GRANTS",
  /*  137 */ "QUERIES",
  /*  138 */ "SCORES",
  /*  139 */ "TOPICS",
  /*  140 */ "VARIABLES",
  /*  141 */ "BNODES",
  /*  142 */ "SNODES",
  /*  143 */ "CLUSTER",
  /*  144 */ "TRANSACTIONS",
  /*  145 */ "DISTRIBUTED",
  /*  146 */ "CONSUMERS",
  /*  147 */ "SUBSCRIPTIONS",
  /*  148 */ "LIKE",
  /*  149 */ "INDEX",
  /*  150 */ "FUNCTION",
  /*  151 */ "INTERVAL",
  /*  152 */ "TOPIC",
  /*  153 */ "AS",
  /*  154 */ "WITH",
  /*  155 */ "META",
  /*  156 */ "CONSUMER",
  /*  157 */ "GROUP",
  /*  158 */ "DESC",
  /*  159 */ "DESCRIBE",
  /*  160 */ "RESET",
  /*  161 */ "QUERY",
  /*  162 */ "CACHE",
  /*  163 */ "EXPLAIN",
  /*  164 */ "ANALYZE",
  /*  165 */ "VERBOSE",
  /*  166 */ "NK_BOOL",
  /*  167 */ "RATIO",
  /*  168 */ "NK_FLOAT",
  /*  169 */ "COMPACT",
  /*  170 */ "VNODES",
  /*  171 */ "IN",
  /*  172 */ "OUTPUTTYPE",
  /*  173 */ "AGGREGATE",
  /*  174 */ "BUFSIZE",
  /*  175 */ "STREAM",
  /*  176 */ "INTO",
  /*  177 */ "TRIGGER",
  /*  178 */ "AT_ONCE",
  /*  179 */ "WINDOW_CLOSE",
  /*  180 */ "IGNORE",
  /*  181 */ "EXPIRED",
  /*  182 */ "KILL",
  /*  183 */ "CONNECTION",
  /*  184 */ "TRANSACTION",
  /*  185 */ "BALANCE",
  /*  186 */ "VGROUP",
  /*  187 */ "MERGE",
  /*  188 */ "REDISTRIBUTE",
  /*  189 */ "SPLIT",
  /*  190 */ "SYNCDB",
  /*  191 */ "DELETE",
  /*  192 */ "INSERT",
  /*  193 */ "NULL",
  /*  194 */ "NK_QUESTION",
  /*  195 */ "NK_ARROW",
  /*  196 */ "ROWTS",
  /*  197 */ "TBNAME",
  /*  198 */ "QSTART",
  /*  199 */ "QEND",
  /*  200 */ "QDURATION",
  /*  201 */ "WSTART",
  /*  202 */ "WEND",
  /*  203 */ "WDURATION",
  /*  204 */ "CAST",
  /*  205 */ "NOW",
  /*  206 */ "TODAY",
  /*  207 */ "TIMEZONE",
  /*  208 */ "CLIENT_VERSION",
  /*  209 */ "SERVER_VERSION",
  /*  210 */ "SERVER_STATUS",
  /*  211 */ "CURRENT_USER",
  /*  212 */ "COUNT",
  /*  213 */ "LAST_ROW",
  /*  214 */ "BETWEEN",
  /*  215 */ "IS",
  /*  216 */ "NK_LT",
  /*  217 */ "NK_GT",
  /*  218 */ "NK_LE",
  /*  219 */ "NK_GE",
  /*  220 */ "NK_NE",
  /*  221 */ "MATCH",
  /*  222 */ "NMATCH",
  /*  223 */ "CONTAINS",
  /*  224 */ "JOIN",
  /*  225 */ "INNER",
  /*  226 */ "SELECT",
  /*  227 */ "DISTINCT",
  /*  228 */ "WHERE",
  /*  229 */ "PARTITION",
  /*  230 */ "BY",
  /*  231 */ "SESSION",
  /*  232 */ "STATE_WINDOW",
  /*  233 */ "SLIDING",
  /*  234 */ "FILL",
  /*  235 */ "VALUE",
  /*  236 */ "NONE",
  /*  237 */ "PREV",
  /*  238 */ "LINEAR",
  /*  239 */ "NEXT",
  /*  240 */ "HAVING",
  /*  241 */ "RANGE",
  /*  242 */ "EVERY",
  /*  243 */ "ORDER",
  /*  244 */ "SLIMIT",
  /*  245 */ "SOFFSET",
  /*  246 */ "LIMIT",
  /*  247 */ "OFFSET",
  /*  248 */ "ASC",
  /*  249 */ "NULLS",
  /*  250 */ "ID",
  /*  251 */ "NK_BITNOT",
  /*  252 */ "VALUES",
  /*  253 */ "IMPORT",
  /*  254 */ "NK_SEMI",
  /*  255 */ "FILE",
  /*  256 */ "cmd",
  /*  257 */ "account_options",
  /*  258 */ "alter_account_options",
  /*  259 */ "literal",
  /*  260 */ "alter_account_option",
  /*  261 */ "user_name",
  /*  262 */ "sysinfo_opt",
  /*  263 */ "privileges",
  /*  264 */ "priv_level",
  /*  265 */ "priv_type_list",
  /*  266 */ "priv_type",
  /*  267 */ "db_name",
  /*  268 */ "dnode_endpoint",
  /*  269 */ "not_exists_opt",
  /*  270 */ "db_options",
  /*  271 */ "exists_opt",
  /*  272 */ "alter_db_options",
  /*  273 */ "integer_list",
  /*  274 */ "variable_list",
  /*  275 */ "retention_list",
  /*  276 */ "alter_db_option",
  /*  277 */ "retention",
  /*  278 */ "full_table_name",
  /*  279 */ "column_def_list",
  /*  280 */ "tags_def_opt",
  /*  281 */ "table_options",
  /*  282 */ "multi_create_clause",
  /*  283 */ "tags_def",
  /*  284 */ "multi_drop_clause",
  /*  285 */ "alter_table_clause",
  /*  286 */ "alter_table_options",
  /*  287 */ "column_name",
  /*  288 */ "type_name",
  /*  289 */ "signed_literal",
  /*  290 */ "create_subtable_clause",
  /*  291 */ "specific_cols_opt",
  /*  292 */ "expression_list",
  /*  293 */ "drop_table_clause",
  /*  294 */ "col_name_list",
  /*  295 */ "table_name",
  /*  296 */ "column_def",
  /*  297 */ "duration_list",
  /*  298 */ "rollup_func_list",
  /*  299 */ "alter_table_option",
  /*  300 */ "duration_literal",
  /*  301 */ "rollup_func_name",
  /*  302 */ "function_name",
  /*  303 */ "col_name",
  /*  304 */ "db_name_cond_opt",
  /*  305 */ "like_pattern_opt",
  /*  306 */ "table_name_cond",
  /*  307 */ "from_db_opt",
  /*  308 */ "index_name",
  /*  309 */ "index_options",
  /*  310 */ "func_list",
  /*  311 */ "sliding_opt",
  /*  312 */ "sma_stream_opt",
  /*  313 */ "func",
  /*  314 */ "stream_options",
  /*  315 */ "topic_name",
  /*  316 */ "query_expression",
  /*  317 */ "cgroup_name",
  /*  318 */ "analyze_opt",
  /*  319 */ "explain_options",
  /*  320 */ "agg_func_opt",
  /*  321 */ "bufsize_opt",
  /*  322 */ "stream_name",
  /*  323 */ "into_opt",
  /*  324 */ "dnode_list",
  /*  325 */ "where_clause_opt",
  /*  326 */ "signed",
  /*  327 */ "literal_func",
  /*  328 */ "literal_list",
  /*  329 */ "table_alias",
  /*  330 */ "column_alias",
  /*  331 */ "expression",
  /*  332 */ "pseudo_column",
  /*  333 */ "column_reference",
  /*  334 */ "function_expression",
  /*  335 */ "subquery",
  /*  336 */ "star_func",
  /*  337 */ "star_func_para_list",
  /*  338 */ "noarg_func",
  /*  339 */ "other_para_list",
  /*  340 */ "star_func_para",
  /*  341 */ "predicate",
  /*  342 */ "compare_op",
  /*  343 */ "in_op",
  /*  344 */ "in_predicate_value",
  /*  345 */ "boolean_value_expression",
  /*  346 */ "boolean_primary",
  /*  347 */ "common_expression",
  /*  348 */ "from_clause_opt",
  /*  349 */ "table_reference_list",
  /*  350 */ "table_reference",
  /*  351 */ "table_primary",
  /*  352 */ "joined_table",
  /*  353 */ "alias_opt",
  /*  354 */ "parenthesized_joined_table",
  /*  355 */ "join_type",
  /*  356 */ "search_condition",
  /*  357 */ "query_specification",
  /*  358 */ "set_quantifier_opt",
  /*  359 */ "select_list",
  /*  360 */ "partition_by_clause_opt",
  /*  361 */ "range_opt",
  /*  362 */ "every_opt",
  /*  363 */ "fill_opt",
  /*  364 */ "twindow_clause_opt",
  /*  365 */ "group_by_clause_opt",
  /*  366 */ "having_clause_opt",
  /*  367 */ "select_item",
  /*  368 */ "fill_mode",
  /*  369 */ "group_by_list",
  /*  370 */ "query_expression_body",
  /*  371 */ "order_by_clause_opt",
  /*  372 */ "slimit_clause_opt",
  /*  373 */ "limit_clause_opt",
  /*  374 */ "query_primary",
  /*  375 */ "sort_specification_list",
  /*  376 */ "sort_specification",
  /*  377 */ "ordering_specification_opt",
  /*  378 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  80 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  82 */ "db_options ::= db_options KEEP integer_list",
 /*  83 */ "db_options ::= db_options KEEP variable_list",
 /*  84 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  85 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  90 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  91 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  92 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  93 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  94 */ "alter_db_options ::= alter_db_option",
 /*  95 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  96 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /*  97 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /*  98 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  99 */ "alter_db_option ::= KEEP integer_list",
 /* 100 */ "alter_db_option ::= KEEP variable_list",
 /* 101 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 102 */ "integer_list ::= NK_INTEGER",
 /* 103 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 104 */ "variable_list ::= NK_VARIABLE",
 /* 105 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 106 */ "retention_list ::= retention",
 /* 107 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 108 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 109 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 110 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 111 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 112 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 113 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 114 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 115 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 116 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 117 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 118 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 119 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 120 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 121 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 122 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 123 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 125 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 126 */ "multi_create_clause ::= create_subtable_clause",
 /* 127 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 128 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 129 */ "multi_drop_clause ::= drop_table_clause",
 /* 130 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 131 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 132 */ "specific_cols_opt ::=",
 /* 133 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 134 */ "full_table_name ::= table_name",
 /* 135 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 136 */ "column_def_list ::= column_def",
 /* 137 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 138 */ "column_def ::= column_name type_name",
 /* 139 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 140 */ "type_name ::= BOOL",
 /* 141 */ "type_name ::= TINYINT",
 /* 142 */ "type_name ::= SMALLINT",
 /* 143 */ "type_name ::= INT",
 /* 144 */ "type_name ::= INTEGER",
 /* 145 */ "type_name ::= BIGINT",
 /* 146 */ "type_name ::= FLOAT",
 /* 147 */ "type_name ::= DOUBLE",
 /* 148 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 149 */ "type_name ::= TIMESTAMP",
 /* 150 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 151 */ "type_name ::= TINYINT UNSIGNED",
 /* 152 */ "type_name ::= SMALLINT UNSIGNED",
 /* 153 */ "type_name ::= INT UNSIGNED",
 /* 154 */ "type_name ::= BIGINT UNSIGNED",
 /* 155 */ "type_name ::= JSON",
 /* 156 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= MEDIUMBLOB",
 /* 158 */ "type_name ::= BLOB",
 /* 159 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= DECIMAL",
 /* 161 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 163 */ "tags_def_opt ::=",
 /* 164 */ "tags_def_opt ::= tags_def",
 /* 165 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 166 */ "table_options ::=",
 /* 167 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 168 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 169 */ "table_options ::= table_options WATERMARK duration_list",
 /* 170 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 171 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 172 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 173 */ "alter_table_options ::= alter_table_option",
 /* 174 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 175 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 176 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 177 */ "duration_list ::= duration_literal",
 /* 178 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 179 */ "rollup_func_list ::= rollup_func_name",
 /* 180 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 181 */ "rollup_func_name ::= function_name",
 /* 182 */ "rollup_func_name ::= FIRST",
 /* 183 */ "rollup_func_name ::= LAST",
 /* 184 */ "col_name_list ::= col_name",
 /* 185 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 186 */ "col_name ::= column_name",
 /* 187 */ "cmd ::= SHOW DNODES",
 /* 188 */ "cmd ::= SHOW USERS",
 /* 189 */ "cmd ::= SHOW DATABASES",
 /* 190 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 193 */ "cmd ::= SHOW MNODES",
 /* 194 */ "cmd ::= SHOW MODULES",
 /* 195 */ "cmd ::= SHOW QNODES",
 /* 196 */ "cmd ::= SHOW FUNCTIONS",
 /* 197 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 198 */ "cmd ::= SHOW STREAMS",
 /* 199 */ "cmd ::= SHOW ACCOUNTS",
 /* 200 */ "cmd ::= SHOW APPS",
 /* 201 */ "cmd ::= SHOW CONNECTIONS",
 /* 202 */ "cmd ::= SHOW LICENCE",
 /* 203 */ "cmd ::= SHOW GRANTS",
 /* 204 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 205 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 206 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 207 */ "cmd ::= SHOW QUERIES",
 /* 208 */ "cmd ::= SHOW SCORES",
 /* 209 */ "cmd ::= SHOW TOPICS",
 /* 210 */ "cmd ::= SHOW VARIABLES",
 /* 211 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 212 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 213 */ "cmd ::= SHOW BNODES",
 /* 214 */ "cmd ::= SHOW SNODES",
 /* 215 */ "cmd ::= SHOW CLUSTER",
 /* 216 */ "cmd ::= SHOW TRANSACTIONS",
 /* 217 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 218 */ "cmd ::= SHOW CONSUMERS",
 /* 219 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 220 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 221 */ "db_name_cond_opt ::=",
 /* 222 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 223 */ "like_pattern_opt ::=",
 /* 224 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 225 */ "table_name_cond ::= table_name",
 /* 226 */ "from_db_opt ::=",
 /* 227 */ "from_db_opt ::= FROM db_name",
 /* 228 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 229 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 230 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 231 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 232 */ "func_list ::= func",
 /* 233 */ "func_list ::= func_list NK_COMMA func",
 /* 234 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 235 */ "sma_stream_opt ::=",
 /* 236 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 237 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 238 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 239 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 242 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 243 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 244 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 245 */ "cmd ::= DESC full_table_name",
 /* 246 */ "cmd ::= DESCRIBE full_table_name",
 /* 247 */ "cmd ::= RESET QUERY CACHE",
 /* 248 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 249 */ "analyze_opt ::=",
 /* 250 */ "analyze_opt ::= ANALYZE",
 /* 251 */ "explain_options ::=",
 /* 252 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 253 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 254 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 255 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 256 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 257 */ "agg_func_opt ::=",
 /* 258 */ "agg_func_opt ::= AGGREGATE",
 /* 259 */ "bufsize_opt ::=",
 /* 260 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 261 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 262 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 263 */ "into_opt ::=",
 /* 264 */ "into_opt ::= INTO full_table_name",
 /* 265 */ "stream_options ::=",
 /* 266 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 267 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 268 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 269 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 270 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 271 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 272 */ "cmd ::= KILL QUERY NK_STRING",
 /* 273 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 274 */ "cmd ::= BALANCE VGROUP",
 /* 275 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 276 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 277 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 278 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 279 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 280 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 281 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 282 */ "cmd ::= query_expression",
 /* 283 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 284 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 285 */ "literal ::= NK_INTEGER",
 /* 286 */ "literal ::= NK_FLOAT",
 /* 287 */ "literal ::= NK_STRING",
 /* 288 */ "literal ::= NK_BOOL",
 /* 289 */ "literal ::= TIMESTAMP NK_STRING",
 /* 290 */ "literal ::= duration_literal",
 /* 291 */ "literal ::= NULL",
 /* 292 */ "literal ::= NK_QUESTION",
 /* 293 */ "duration_literal ::= NK_VARIABLE",
 /* 294 */ "signed ::= NK_INTEGER",
 /* 295 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 296 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 297 */ "signed ::= NK_FLOAT",
 /* 298 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 299 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 300 */ "signed_literal ::= signed",
 /* 301 */ "signed_literal ::= NK_STRING",
 /* 302 */ "signed_literal ::= NK_BOOL",
 /* 303 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 304 */ "signed_literal ::= duration_literal",
 /* 305 */ "signed_literal ::= NULL",
 /* 306 */ "signed_literal ::= literal_func",
 /* 307 */ "signed_literal ::= NK_QUESTION",
 /* 308 */ "literal_list ::= signed_literal",
 /* 309 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 310 */ "db_name ::= NK_ID",
 /* 311 */ "table_name ::= NK_ID",
 /* 312 */ "column_name ::= NK_ID",
 /* 313 */ "function_name ::= NK_ID",
 /* 314 */ "table_alias ::= NK_ID",
 /* 315 */ "column_alias ::= NK_ID",
 /* 316 */ "user_name ::= NK_ID",
 /* 317 */ "index_name ::= NK_ID",
 /* 318 */ "topic_name ::= NK_ID",
 /* 319 */ "stream_name ::= NK_ID",
 /* 320 */ "cgroup_name ::= NK_ID",
 /* 321 */ "expression ::= literal",
 /* 322 */ "expression ::= pseudo_column",
 /* 323 */ "expression ::= column_reference",
 /* 324 */ "expression ::= function_expression",
 /* 325 */ "expression ::= subquery",
 /* 326 */ "expression ::= NK_LP expression NK_RP",
 /* 327 */ "expression ::= NK_PLUS expression",
 /* 328 */ "expression ::= NK_MINUS expression",
 /* 329 */ "expression ::= expression NK_PLUS expression",
 /* 330 */ "expression ::= expression NK_MINUS expression",
 /* 331 */ "expression ::= expression NK_STAR expression",
 /* 332 */ "expression ::= expression NK_SLASH expression",
 /* 333 */ "expression ::= expression NK_REM expression",
 /* 334 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 335 */ "expression ::= expression NK_BITAND expression",
 /* 336 */ "expression ::= expression NK_BITOR expression",
 /* 337 */ "expression_list ::= expression",
 /* 338 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 339 */ "column_reference ::= column_name",
 /* 340 */ "column_reference ::= table_name NK_DOT column_name",
 /* 341 */ "pseudo_column ::= ROWTS",
 /* 342 */ "pseudo_column ::= TBNAME",
 /* 343 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 344 */ "pseudo_column ::= QSTART",
 /* 345 */ "pseudo_column ::= QEND",
 /* 346 */ "pseudo_column ::= QDURATION",
 /* 347 */ "pseudo_column ::= WSTART",
 /* 348 */ "pseudo_column ::= WEND",
 /* 349 */ "pseudo_column ::= WDURATION",
 /* 350 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 351 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 352 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 353 */ "function_expression ::= literal_func",
 /* 354 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 355 */ "literal_func ::= NOW",
 /* 356 */ "noarg_func ::= NOW",
 /* 357 */ "noarg_func ::= TODAY",
 /* 358 */ "noarg_func ::= TIMEZONE",
 /* 359 */ "noarg_func ::= DATABASE",
 /* 360 */ "noarg_func ::= CLIENT_VERSION",
 /* 361 */ "noarg_func ::= SERVER_VERSION",
 /* 362 */ "noarg_func ::= SERVER_STATUS",
 /* 363 */ "noarg_func ::= CURRENT_USER",
 /* 364 */ "noarg_func ::= USER",
 /* 365 */ "star_func ::= COUNT",
 /* 366 */ "star_func ::= FIRST",
 /* 367 */ "star_func ::= LAST",
 /* 368 */ "star_func ::= LAST_ROW",
 /* 369 */ "star_func_para_list ::= NK_STAR",
 /* 370 */ "star_func_para_list ::= other_para_list",
 /* 371 */ "other_para_list ::= star_func_para",
 /* 372 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 373 */ "star_func_para ::= expression",
 /* 374 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 375 */ "predicate ::= expression compare_op expression",
 /* 376 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 377 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 378 */ "predicate ::= expression IS NULL",
 /* 379 */ "predicate ::= expression IS NOT NULL",
 /* 380 */ "predicate ::= expression in_op in_predicate_value",
 /* 381 */ "compare_op ::= NK_LT",
 /* 382 */ "compare_op ::= NK_GT",
 /* 383 */ "compare_op ::= NK_LE",
 /* 384 */ "compare_op ::= NK_GE",
 /* 385 */ "compare_op ::= NK_NE",
 /* 386 */ "compare_op ::= NK_EQ",
 /* 387 */ "compare_op ::= LIKE",
 /* 388 */ "compare_op ::= NOT LIKE",
 /* 389 */ "compare_op ::= MATCH",
 /* 390 */ "compare_op ::= NMATCH",
 /* 391 */ "compare_op ::= CONTAINS",
 /* 392 */ "in_op ::= IN",
 /* 393 */ "in_op ::= NOT IN",
 /* 394 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 395 */ "boolean_value_expression ::= boolean_primary",
 /* 396 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 397 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 398 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 399 */ "boolean_primary ::= predicate",
 /* 400 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 401 */ "common_expression ::= expression",
 /* 402 */ "common_expression ::= boolean_value_expression",
 /* 403 */ "from_clause_opt ::=",
 /* 404 */ "from_clause_opt ::= FROM table_reference_list",
 /* 405 */ "table_reference_list ::= table_reference",
 /* 406 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 407 */ "table_reference ::= table_primary",
 /* 408 */ "table_reference ::= joined_table",
 /* 409 */ "table_primary ::= table_name alias_opt",
 /* 410 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 411 */ "table_primary ::= subquery alias_opt",
 /* 412 */ "table_primary ::= parenthesized_joined_table",
 /* 413 */ "alias_opt ::=",
 /* 414 */ "alias_opt ::= table_alias",
 /* 415 */ "alias_opt ::= AS table_alias",
 /* 416 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 417 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 418 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 419 */ "join_type ::=",
 /* 420 */ "join_type ::= INNER",
 /* 421 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 422 */ "set_quantifier_opt ::=",
 /* 423 */ "set_quantifier_opt ::= DISTINCT",
 /* 424 */ "set_quantifier_opt ::= ALL",
 /* 425 */ "select_list ::= select_item",
 /* 426 */ "select_list ::= select_list NK_COMMA select_item",
 /* 427 */ "select_item ::= NK_STAR",
 /* 428 */ "select_item ::= common_expression",
 /* 429 */ "select_item ::= common_expression column_alias",
 /* 430 */ "select_item ::= common_expression AS column_alias",
 /* 431 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 432 */ "where_clause_opt ::=",
 /* 433 */ "where_clause_opt ::= WHERE search_condition",
 /* 434 */ "partition_by_clause_opt ::=",
 /* 435 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 436 */ "twindow_clause_opt ::=",
 /* 437 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 438 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 439 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 440 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 441 */ "sliding_opt ::=",
 /* 442 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 443 */ "fill_opt ::=",
 /* 444 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 445 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 446 */ "fill_mode ::= NONE",
 /* 447 */ "fill_mode ::= PREV",
 /* 448 */ "fill_mode ::= NULL",
 /* 449 */ "fill_mode ::= LINEAR",
 /* 450 */ "fill_mode ::= NEXT",
 /* 451 */ "group_by_clause_opt ::=",
 /* 452 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 453 */ "group_by_list ::= expression",
 /* 454 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 455 */ "having_clause_opt ::=",
 /* 456 */ "having_clause_opt ::= HAVING search_condition",
 /* 457 */ "range_opt ::=",
 /* 458 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 459 */ "every_opt ::=",
 /* 460 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 461 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 462 */ "query_expression_body ::= query_primary",
 /* 463 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 464 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 465 */ "query_primary ::= query_specification",
 /* 466 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 467 */ "order_by_clause_opt ::=",
 /* 468 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 469 */ "slimit_clause_opt ::=",
 /* 470 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 471 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 472 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 473 */ "limit_clause_opt ::=",
 /* 474 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 475 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 476 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 477 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 478 */ "search_condition ::= common_expression",
 /* 479 */ "sort_specification_list ::= sort_specification",
 /* 480 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 481 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 482 */ "ordering_specification_opt ::=",
 /* 483 */ "ordering_specification_opt ::= ASC",
 /* 484 */ "ordering_specification_opt ::= DESC",
 /* 485 */ "null_ordering_opt ::=",
 /* 486 */ "null_ordering_opt ::= NULLS FIRST",
 /* 487 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 256: /* cmd */
    case 259: /* literal */
    case 270: /* db_options */
    case 272: /* alter_db_options */
    case 277: /* retention */
    case 278: /* full_table_name */
    case 281: /* table_options */
    case 285: /* alter_table_clause */
    case 286: /* alter_table_options */
    case 289: /* signed_literal */
    case 290: /* create_subtable_clause */
    case 293: /* drop_table_clause */
    case 296: /* column_def */
    case 300: /* duration_literal */
    case 301: /* rollup_func_name */
    case 303: /* col_name */
    case 304: /* db_name_cond_opt */
    case 305: /* like_pattern_opt */
    case 306: /* table_name_cond */
    case 307: /* from_db_opt */
    case 309: /* index_options */
    case 311: /* sliding_opt */
    case 312: /* sma_stream_opt */
    case 313: /* func */
    case 314: /* stream_options */
    case 316: /* query_expression */
    case 319: /* explain_options */
    case 323: /* into_opt */
    case 325: /* where_clause_opt */
    case 326: /* signed */
    case 327: /* literal_func */
    case 331: /* expression */
    case 332: /* pseudo_column */
    case 333: /* column_reference */
    case 334: /* function_expression */
    case 335: /* subquery */
    case 340: /* star_func_para */
    case 341: /* predicate */
    case 344: /* in_predicate_value */
    case 345: /* boolean_value_expression */
    case 346: /* boolean_primary */
    case 347: /* common_expression */
    case 348: /* from_clause_opt */
    case 349: /* table_reference_list */
    case 350: /* table_reference */
    case 351: /* table_primary */
    case 352: /* joined_table */
    case 354: /* parenthesized_joined_table */
    case 356: /* search_condition */
    case 357: /* query_specification */
    case 361: /* range_opt */
    case 362: /* every_opt */
    case 363: /* fill_opt */
    case 364: /* twindow_clause_opt */
    case 366: /* having_clause_opt */
    case 367: /* select_item */
    case 370: /* query_expression_body */
    case 372: /* slimit_clause_opt */
    case 373: /* limit_clause_opt */
    case 374: /* query_primary */
    case 376: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy616)); 
}
      break;
    case 257: /* account_options */
    case 258: /* alter_account_options */
    case 260: /* alter_account_option */
    case 321: /* bufsize_opt */
{
 
}
      break;
    case 261: /* user_name */
    case 264: /* priv_level */
    case 267: /* db_name */
    case 268: /* dnode_endpoint */
    case 287: /* column_name */
    case 295: /* table_name */
    case 302: /* function_name */
    case 308: /* index_name */
    case 315: /* topic_name */
    case 317: /* cgroup_name */
    case 322: /* stream_name */
    case 329: /* table_alias */
    case 330: /* column_alias */
    case 336: /* star_func */
    case 338: /* noarg_func */
    case 353: /* alias_opt */
{
 
}
      break;
    case 262: /* sysinfo_opt */
{
 
}
      break;
    case 263: /* privileges */
    case 265: /* priv_type_list */
    case 266: /* priv_type */
{
 
}
      break;
    case 269: /* not_exists_opt */
    case 271: /* exists_opt */
    case 318: /* analyze_opt */
    case 320: /* agg_func_opt */
    case 358: /* set_quantifier_opt */
{
 
}
      break;
    case 273: /* integer_list */
    case 274: /* variable_list */
    case 275: /* retention_list */
    case 279: /* column_def_list */
    case 280: /* tags_def_opt */
    case 282: /* multi_create_clause */
    case 283: /* tags_def */
    case 284: /* multi_drop_clause */
    case 291: /* specific_cols_opt */
    case 292: /* expression_list */
    case 294: /* col_name_list */
    case 297: /* duration_list */
    case 298: /* rollup_func_list */
    case 310: /* func_list */
    case 324: /* dnode_list */
    case 328: /* literal_list */
    case 337: /* star_func_para_list */
    case 339: /* other_para_list */
    case 359: /* select_list */
    case 360: /* partition_by_clause_opt */
    case 365: /* group_by_clause_opt */
    case 369: /* group_by_list */
    case 371: /* order_by_clause_opt */
    case 375: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy356)); 
}
      break;
    case 276: /* alter_db_option */
    case 299: /* alter_table_option */
{
 
}
      break;
    case 288: /* type_name */
{
 
}
      break;
    case 342: /* compare_op */
    case 343: /* in_op */
{
 
}
      break;
    case 355: /* join_type */
{
 
}
      break;
    case 368: /* fill_mode */
{
 
}
      break;
    case 377: /* ordering_specification_opt */
{
 
}
      break;
    case 378: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  256,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  256,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  257,    0 }, /* (2) account_options ::= */
  {  257,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  257,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  257,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  257,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  257,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  257,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  257,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  257,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  257,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  258,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  258,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  260,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  260,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  260,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  260,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  260,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  260,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  260,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  260,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  260,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  260,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  256,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  256,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  256,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  256,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  256,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  262,    0 }, /* (29) sysinfo_opt ::= */
  {  262,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  256,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  256,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  263,   -1 }, /* (33) privileges ::= ALL */
  {  263,   -1 }, /* (34) privileges ::= priv_type_list */
  {  265,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  265,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  266,   -1 }, /* (37) priv_type ::= READ */
  {  266,   -1 }, /* (38) priv_type ::= WRITE */
  {  264,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  264,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  256,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  256,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  256,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  256,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  256,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  256,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  256,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  256,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  268,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  268,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  268,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  256,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  256,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  256,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  256,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  256,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  256,   -2 }, /* (64) cmd ::= USE db_name */
  {  256,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  256,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  256,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  269,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  269,    0 }, /* (69) not_exists_opt ::= */
  {  271,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  271,    0 }, /* (71) exists_opt ::= */
  {  270,    0 }, /* (72) db_options ::= */
  {  270,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  270,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  270,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  270,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  270,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  270,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  270,   -3 }, /* (79) db_options ::= db_options FSYNC NK_INTEGER */
  {  270,   -3 }, /* (80) db_options ::= db_options MAXROWS NK_INTEGER */
  {  270,   -3 }, /* (81) db_options ::= db_options MINROWS NK_INTEGER */
  {  270,   -3 }, /* (82) db_options ::= db_options KEEP integer_list */
  {  270,   -3 }, /* (83) db_options ::= db_options KEEP variable_list */
  {  270,   -3 }, /* (84) db_options ::= db_options PAGES NK_INTEGER */
  {  270,   -3 }, /* (85) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  270,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  270,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  270,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  270,   -3 }, /* (89) db_options ::= db_options WAL NK_INTEGER */
  {  270,   -3 }, /* (90) db_options ::= db_options VGROUPS NK_INTEGER */
  {  270,   -3 }, /* (91) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  270,   -3 }, /* (92) db_options ::= db_options RETENTIONS retention_list */
  {  270,   -3 }, /* (93) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  272,   -1 }, /* (94) alter_db_options ::= alter_db_option */
  {  272,   -2 }, /* (95) alter_db_options ::= alter_db_options alter_db_option */
  {  276,   -2 }, /* (96) alter_db_option ::= CACHEMODEL NK_STRING */
  {  276,   -2 }, /* (97) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  276,   -2 }, /* (98) alter_db_option ::= FSYNC NK_INTEGER */
  {  276,   -2 }, /* (99) alter_db_option ::= KEEP integer_list */
  {  276,   -2 }, /* (100) alter_db_option ::= KEEP variable_list */
  {  276,   -2 }, /* (101) alter_db_option ::= WAL NK_INTEGER */
  {  273,   -1 }, /* (102) integer_list ::= NK_INTEGER */
  {  273,   -3 }, /* (103) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  274,   -1 }, /* (104) variable_list ::= NK_VARIABLE */
  {  274,   -3 }, /* (105) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  275,   -1 }, /* (106) retention_list ::= retention */
  {  275,   -3 }, /* (107) retention_list ::= retention_list NK_COMMA retention */
  {  277,   -3 }, /* (108) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  256,   -9 }, /* (109) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  256,   -3 }, /* (110) cmd ::= CREATE TABLE multi_create_clause */
  {  256,   -9 }, /* (111) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  256,   -3 }, /* (112) cmd ::= DROP TABLE multi_drop_clause */
  {  256,   -4 }, /* (113) cmd ::= DROP STABLE exists_opt full_table_name */
  {  256,   -3 }, /* (114) cmd ::= ALTER TABLE alter_table_clause */
  {  256,   -3 }, /* (115) cmd ::= ALTER STABLE alter_table_clause */
  {  285,   -2 }, /* (116) alter_table_clause ::= full_table_name alter_table_options */
  {  285,   -5 }, /* (117) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  285,   -4 }, /* (118) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  285,   -5 }, /* (119) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  285,   -5 }, /* (120) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  285,   -5 }, /* (121) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  285,   -4 }, /* (122) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  285,   -5 }, /* (123) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  285,   -5 }, /* (124) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  285,   -6 }, /* (125) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  282,   -1 }, /* (126) multi_create_clause ::= create_subtable_clause */
  {  282,   -2 }, /* (127) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  290,  -10 }, /* (128) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  284,   -1 }, /* (129) multi_drop_clause ::= drop_table_clause */
  {  284,   -2 }, /* (130) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  293,   -2 }, /* (131) drop_table_clause ::= exists_opt full_table_name */
  {  291,    0 }, /* (132) specific_cols_opt ::= */
  {  291,   -3 }, /* (133) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  278,   -1 }, /* (134) full_table_name ::= table_name */
  {  278,   -3 }, /* (135) full_table_name ::= db_name NK_DOT table_name */
  {  279,   -1 }, /* (136) column_def_list ::= column_def */
  {  279,   -3 }, /* (137) column_def_list ::= column_def_list NK_COMMA column_def */
  {  296,   -2 }, /* (138) column_def ::= column_name type_name */
  {  296,   -4 }, /* (139) column_def ::= column_name type_name COMMENT NK_STRING */
  {  288,   -1 }, /* (140) type_name ::= BOOL */
  {  288,   -1 }, /* (141) type_name ::= TINYINT */
  {  288,   -1 }, /* (142) type_name ::= SMALLINT */
  {  288,   -1 }, /* (143) type_name ::= INT */
  {  288,   -1 }, /* (144) type_name ::= INTEGER */
  {  288,   -1 }, /* (145) type_name ::= BIGINT */
  {  288,   -1 }, /* (146) type_name ::= FLOAT */
  {  288,   -1 }, /* (147) type_name ::= DOUBLE */
  {  288,   -4 }, /* (148) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  288,   -1 }, /* (149) type_name ::= TIMESTAMP */
  {  288,   -4 }, /* (150) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  288,   -2 }, /* (151) type_name ::= TINYINT UNSIGNED */
  {  288,   -2 }, /* (152) type_name ::= SMALLINT UNSIGNED */
  {  288,   -2 }, /* (153) type_name ::= INT UNSIGNED */
  {  288,   -2 }, /* (154) type_name ::= BIGINT UNSIGNED */
  {  288,   -1 }, /* (155) type_name ::= JSON */
  {  288,   -4 }, /* (156) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  288,   -1 }, /* (157) type_name ::= MEDIUMBLOB */
  {  288,   -1 }, /* (158) type_name ::= BLOB */
  {  288,   -4 }, /* (159) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  288,   -1 }, /* (160) type_name ::= DECIMAL */
  {  288,   -4 }, /* (161) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  288,   -6 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  280,    0 }, /* (163) tags_def_opt ::= */
  {  280,   -1 }, /* (164) tags_def_opt ::= tags_def */
  {  283,   -4 }, /* (165) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  281,    0 }, /* (166) table_options ::= */
  {  281,   -3 }, /* (167) table_options ::= table_options COMMENT NK_STRING */
  {  281,   -3 }, /* (168) table_options ::= table_options MAX_DELAY duration_list */
  {  281,   -3 }, /* (169) table_options ::= table_options WATERMARK duration_list */
  {  281,   -5 }, /* (170) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  281,   -3 }, /* (171) table_options ::= table_options TTL NK_INTEGER */
  {  281,   -5 }, /* (172) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  286,   -1 }, /* (173) alter_table_options ::= alter_table_option */
  {  286,   -2 }, /* (174) alter_table_options ::= alter_table_options alter_table_option */
  {  299,   -2 }, /* (175) alter_table_option ::= COMMENT NK_STRING */
  {  299,   -2 }, /* (176) alter_table_option ::= TTL NK_INTEGER */
  {  297,   -1 }, /* (177) duration_list ::= duration_literal */
  {  297,   -3 }, /* (178) duration_list ::= duration_list NK_COMMA duration_literal */
  {  298,   -1 }, /* (179) rollup_func_list ::= rollup_func_name */
  {  298,   -3 }, /* (180) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  301,   -1 }, /* (181) rollup_func_name ::= function_name */
  {  301,   -1 }, /* (182) rollup_func_name ::= FIRST */
  {  301,   -1 }, /* (183) rollup_func_name ::= LAST */
  {  294,   -1 }, /* (184) col_name_list ::= col_name */
  {  294,   -3 }, /* (185) col_name_list ::= col_name_list NK_COMMA col_name */
  {  303,   -1 }, /* (186) col_name ::= column_name */
  {  256,   -2 }, /* (187) cmd ::= SHOW DNODES */
  {  256,   -2 }, /* (188) cmd ::= SHOW USERS */
  {  256,   -2 }, /* (189) cmd ::= SHOW DATABASES */
  {  256,   -4 }, /* (190) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  256,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  256,   -3 }, /* (192) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  256,   -2 }, /* (193) cmd ::= SHOW MNODES */
  {  256,   -2 }, /* (194) cmd ::= SHOW MODULES */
  {  256,   -2 }, /* (195) cmd ::= SHOW QNODES */
  {  256,   -2 }, /* (196) cmd ::= SHOW FUNCTIONS */
  {  256,   -5 }, /* (197) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  256,   -2 }, /* (198) cmd ::= SHOW STREAMS */
  {  256,   -2 }, /* (199) cmd ::= SHOW ACCOUNTS */
  {  256,   -2 }, /* (200) cmd ::= SHOW APPS */
  {  256,   -2 }, /* (201) cmd ::= SHOW CONNECTIONS */
  {  256,   -2 }, /* (202) cmd ::= SHOW LICENCE */
  {  256,   -2 }, /* (203) cmd ::= SHOW GRANTS */
  {  256,   -4 }, /* (204) cmd ::= SHOW CREATE DATABASE db_name */
  {  256,   -4 }, /* (205) cmd ::= SHOW CREATE TABLE full_table_name */
  {  256,   -4 }, /* (206) cmd ::= SHOW CREATE STABLE full_table_name */
  {  256,   -2 }, /* (207) cmd ::= SHOW QUERIES */
  {  256,   -2 }, /* (208) cmd ::= SHOW SCORES */
  {  256,   -2 }, /* (209) cmd ::= SHOW TOPICS */
  {  256,   -2 }, /* (210) cmd ::= SHOW VARIABLES */
  {  256,   -3 }, /* (211) cmd ::= SHOW LOCAL VARIABLES */
  {  256,   -4 }, /* (212) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  256,   -2 }, /* (213) cmd ::= SHOW BNODES */
  {  256,   -2 }, /* (214) cmd ::= SHOW SNODES */
  {  256,   -2 }, /* (215) cmd ::= SHOW CLUSTER */
  {  256,   -2 }, /* (216) cmd ::= SHOW TRANSACTIONS */
  {  256,   -4 }, /* (217) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  256,   -2 }, /* (218) cmd ::= SHOW CONSUMERS */
  {  256,   -2 }, /* (219) cmd ::= SHOW SUBSCRIPTIONS */
  {  256,   -5 }, /* (220) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  304,    0 }, /* (221) db_name_cond_opt ::= */
  {  304,   -2 }, /* (222) db_name_cond_opt ::= db_name NK_DOT */
  {  305,    0 }, /* (223) like_pattern_opt ::= */
  {  305,   -2 }, /* (224) like_pattern_opt ::= LIKE NK_STRING */
  {  306,   -1 }, /* (225) table_name_cond ::= table_name */
  {  307,    0 }, /* (226) from_db_opt ::= */
  {  307,   -2 }, /* (227) from_db_opt ::= FROM db_name */
  {  256,   -8 }, /* (228) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  256,   -4 }, /* (229) cmd ::= DROP INDEX exists_opt index_name */
  {  309,  -10 }, /* (230) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  309,  -12 }, /* (231) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  310,   -1 }, /* (232) func_list ::= func */
  {  310,   -3 }, /* (233) func_list ::= func_list NK_COMMA func */
  {  313,   -4 }, /* (234) func ::= function_name NK_LP expression_list NK_RP */
  {  312,    0 }, /* (235) sma_stream_opt ::= */
  {  312,   -3 }, /* (236) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  312,   -3 }, /* (237) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  256,   -6 }, /* (238) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  256,   -7 }, /* (239) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  256,   -9 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  256,   -7 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  256,   -9 }, /* (242) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  256,   -4 }, /* (243) cmd ::= DROP TOPIC exists_opt topic_name */
  {  256,   -7 }, /* (244) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  256,   -2 }, /* (245) cmd ::= DESC full_table_name */
  {  256,   -2 }, /* (246) cmd ::= DESCRIBE full_table_name */
  {  256,   -3 }, /* (247) cmd ::= RESET QUERY CACHE */
  {  256,   -4 }, /* (248) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  318,    0 }, /* (249) analyze_opt ::= */
  {  318,   -1 }, /* (250) analyze_opt ::= ANALYZE */
  {  319,    0 }, /* (251) explain_options ::= */
  {  319,   -3 }, /* (252) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  319,   -3 }, /* (253) explain_options ::= explain_options RATIO NK_FLOAT */
  {  256,   -6 }, /* (254) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  256,  -10 }, /* (255) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  256,   -4 }, /* (256) cmd ::= DROP FUNCTION exists_opt function_name */
  {  320,    0 }, /* (257) agg_func_opt ::= */
  {  320,   -1 }, /* (258) agg_func_opt ::= AGGREGATE */
  {  321,    0 }, /* (259) bufsize_opt ::= */
  {  321,   -2 }, /* (260) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  256,   -8 }, /* (261) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  256,   -4 }, /* (262) cmd ::= DROP STREAM exists_opt stream_name */
  {  323,    0 }, /* (263) into_opt ::= */
  {  323,   -2 }, /* (264) into_opt ::= INTO full_table_name */
  {  314,    0 }, /* (265) stream_options ::= */
  {  314,   -3 }, /* (266) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  314,   -3 }, /* (267) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  314,   -4 }, /* (268) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  314,   -3 }, /* (269) stream_options ::= stream_options WATERMARK duration_literal */
  {  314,   -3 }, /* (270) stream_options ::= stream_options IGNORE EXPIRED */
  {  256,   -3 }, /* (271) cmd ::= KILL CONNECTION NK_INTEGER */
  {  256,   -3 }, /* (272) cmd ::= KILL QUERY NK_STRING */
  {  256,   -3 }, /* (273) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  256,   -2 }, /* (274) cmd ::= BALANCE VGROUP */
  {  256,   -4 }, /* (275) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  256,   -4 }, /* (276) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  256,   -3 }, /* (277) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  324,   -2 }, /* (278) dnode_list ::= DNODE NK_INTEGER */
  {  324,   -3 }, /* (279) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  256,   -3 }, /* (280) cmd ::= SYNCDB db_name REPLICA */
  {  256,   -4 }, /* (281) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  256,   -1 }, /* (282) cmd ::= query_expression */
  {  256,   -7 }, /* (283) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  256,   -4 }, /* (284) cmd ::= INSERT INTO full_table_name query_expression */
  {  259,   -1 }, /* (285) literal ::= NK_INTEGER */
  {  259,   -1 }, /* (286) literal ::= NK_FLOAT */
  {  259,   -1 }, /* (287) literal ::= NK_STRING */
  {  259,   -1 }, /* (288) literal ::= NK_BOOL */
  {  259,   -2 }, /* (289) literal ::= TIMESTAMP NK_STRING */
  {  259,   -1 }, /* (290) literal ::= duration_literal */
  {  259,   -1 }, /* (291) literal ::= NULL */
  {  259,   -1 }, /* (292) literal ::= NK_QUESTION */
  {  300,   -1 }, /* (293) duration_literal ::= NK_VARIABLE */
  {  326,   -1 }, /* (294) signed ::= NK_INTEGER */
  {  326,   -2 }, /* (295) signed ::= NK_PLUS NK_INTEGER */
  {  326,   -2 }, /* (296) signed ::= NK_MINUS NK_INTEGER */
  {  326,   -1 }, /* (297) signed ::= NK_FLOAT */
  {  326,   -2 }, /* (298) signed ::= NK_PLUS NK_FLOAT */
  {  326,   -2 }, /* (299) signed ::= NK_MINUS NK_FLOAT */
  {  289,   -1 }, /* (300) signed_literal ::= signed */
  {  289,   -1 }, /* (301) signed_literal ::= NK_STRING */
  {  289,   -1 }, /* (302) signed_literal ::= NK_BOOL */
  {  289,   -2 }, /* (303) signed_literal ::= TIMESTAMP NK_STRING */
  {  289,   -1 }, /* (304) signed_literal ::= duration_literal */
  {  289,   -1 }, /* (305) signed_literal ::= NULL */
  {  289,   -1 }, /* (306) signed_literal ::= literal_func */
  {  289,   -1 }, /* (307) signed_literal ::= NK_QUESTION */
  {  328,   -1 }, /* (308) literal_list ::= signed_literal */
  {  328,   -3 }, /* (309) literal_list ::= literal_list NK_COMMA signed_literal */
  {  267,   -1 }, /* (310) db_name ::= NK_ID */
  {  295,   -1 }, /* (311) table_name ::= NK_ID */
  {  287,   -1 }, /* (312) column_name ::= NK_ID */
  {  302,   -1 }, /* (313) function_name ::= NK_ID */
  {  329,   -1 }, /* (314) table_alias ::= NK_ID */
  {  330,   -1 }, /* (315) column_alias ::= NK_ID */
  {  261,   -1 }, /* (316) user_name ::= NK_ID */
  {  308,   -1 }, /* (317) index_name ::= NK_ID */
  {  315,   -1 }, /* (318) topic_name ::= NK_ID */
  {  322,   -1 }, /* (319) stream_name ::= NK_ID */
  {  317,   -1 }, /* (320) cgroup_name ::= NK_ID */
  {  331,   -1 }, /* (321) expression ::= literal */
  {  331,   -1 }, /* (322) expression ::= pseudo_column */
  {  331,   -1 }, /* (323) expression ::= column_reference */
  {  331,   -1 }, /* (324) expression ::= function_expression */
  {  331,   -1 }, /* (325) expression ::= subquery */
  {  331,   -3 }, /* (326) expression ::= NK_LP expression NK_RP */
  {  331,   -2 }, /* (327) expression ::= NK_PLUS expression */
  {  331,   -2 }, /* (328) expression ::= NK_MINUS expression */
  {  331,   -3 }, /* (329) expression ::= expression NK_PLUS expression */
  {  331,   -3 }, /* (330) expression ::= expression NK_MINUS expression */
  {  331,   -3 }, /* (331) expression ::= expression NK_STAR expression */
  {  331,   -3 }, /* (332) expression ::= expression NK_SLASH expression */
  {  331,   -3 }, /* (333) expression ::= expression NK_REM expression */
  {  331,   -3 }, /* (334) expression ::= column_reference NK_ARROW NK_STRING */
  {  331,   -3 }, /* (335) expression ::= expression NK_BITAND expression */
  {  331,   -3 }, /* (336) expression ::= expression NK_BITOR expression */
  {  292,   -1 }, /* (337) expression_list ::= expression */
  {  292,   -3 }, /* (338) expression_list ::= expression_list NK_COMMA expression */
  {  333,   -1 }, /* (339) column_reference ::= column_name */
  {  333,   -3 }, /* (340) column_reference ::= table_name NK_DOT column_name */
  {  332,   -1 }, /* (341) pseudo_column ::= ROWTS */
  {  332,   -1 }, /* (342) pseudo_column ::= TBNAME */
  {  332,   -3 }, /* (343) pseudo_column ::= table_name NK_DOT TBNAME */
  {  332,   -1 }, /* (344) pseudo_column ::= QSTART */
  {  332,   -1 }, /* (345) pseudo_column ::= QEND */
  {  332,   -1 }, /* (346) pseudo_column ::= QDURATION */
  {  332,   -1 }, /* (347) pseudo_column ::= WSTART */
  {  332,   -1 }, /* (348) pseudo_column ::= WEND */
  {  332,   -1 }, /* (349) pseudo_column ::= WDURATION */
  {  334,   -4 }, /* (350) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  334,   -4 }, /* (351) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  334,   -6 }, /* (352) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  334,   -1 }, /* (353) function_expression ::= literal_func */
  {  327,   -3 }, /* (354) literal_func ::= noarg_func NK_LP NK_RP */
  {  327,   -1 }, /* (355) literal_func ::= NOW */
  {  338,   -1 }, /* (356) noarg_func ::= NOW */
  {  338,   -1 }, /* (357) noarg_func ::= TODAY */
  {  338,   -1 }, /* (358) noarg_func ::= TIMEZONE */
  {  338,   -1 }, /* (359) noarg_func ::= DATABASE */
  {  338,   -1 }, /* (360) noarg_func ::= CLIENT_VERSION */
  {  338,   -1 }, /* (361) noarg_func ::= SERVER_VERSION */
  {  338,   -1 }, /* (362) noarg_func ::= SERVER_STATUS */
  {  338,   -1 }, /* (363) noarg_func ::= CURRENT_USER */
  {  338,   -1 }, /* (364) noarg_func ::= USER */
  {  336,   -1 }, /* (365) star_func ::= COUNT */
  {  336,   -1 }, /* (366) star_func ::= FIRST */
  {  336,   -1 }, /* (367) star_func ::= LAST */
  {  336,   -1 }, /* (368) star_func ::= LAST_ROW */
  {  337,   -1 }, /* (369) star_func_para_list ::= NK_STAR */
  {  337,   -1 }, /* (370) star_func_para_list ::= other_para_list */
  {  339,   -1 }, /* (371) other_para_list ::= star_func_para */
  {  339,   -3 }, /* (372) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  340,   -1 }, /* (373) star_func_para ::= expression */
  {  340,   -3 }, /* (374) star_func_para ::= table_name NK_DOT NK_STAR */
  {  341,   -3 }, /* (375) predicate ::= expression compare_op expression */
  {  341,   -5 }, /* (376) predicate ::= expression BETWEEN expression AND expression */
  {  341,   -6 }, /* (377) predicate ::= expression NOT BETWEEN expression AND expression */
  {  341,   -3 }, /* (378) predicate ::= expression IS NULL */
  {  341,   -4 }, /* (379) predicate ::= expression IS NOT NULL */
  {  341,   -3 }, /* (380) predicate ::= expression in_op in_predicate_value */
  {  342,   -1 }, /* (381) compare_op ::= NK_LT */
  {  342,   -1 }, /* (382) compare_op ::= NK_GT */
  {  342,   -1 }, /* (383) compare_op ::= NK_LE */
  {  342,   -1 }, /* (384) compare_op ::= NK_GE */
  {  342,   -1 }, /* (385) compare_op ::= NK_NE */
  {  342,   -1 }, /* (386) compare_op ::= NK_EQ */
  {  342,   -1 }, /* (387) compare_op ::= LIKE */
  {  342,   -2 }, /* (388) compare_op ::= NOT LIKE */
  {  342,   -1 }, /* (389) compare_op ::= MATCH */
  {  342,   -1 }, /* (390) compare_op ::= NMATCH */
  {  342,   -1 }, /* (391) compare_op ::= CONTAINS */
  {  343,   -1 }, /* (392) in_op ::= IN */
  {  343,   -2 }, /* (393) in_op ::= NOT IN */
  {  344,   -3 }, /* (394) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  345,   -1 }, /* (395) boolean_value_expression ::= boolean_primary */
  {  345,   -2 }, /* (396) boolean_value_expression ::= NOT boolean_primary */
  {  345,   -3 }, /* (397) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  345,   -3 }, /* (398) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  346,   -1 }, /* (399) boolean_primary ::= predicate */
  {  346,   -3 }, /* (400) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  347,   -1 }, /* (401) common_expression ::= expression */
  {  347,   -1 }, /* (402) common_expression ::= boolean_value_expression */
  {  348,    0 }, /* (403) from_clause_opt ::= */
  {  348,   -2 }, /* (404) from_clause_opt ::= FROM table_reference_list */
  {  349,   -1 }, /* (405) table_reference_list ::= table_reference */
  {  349,   -3 }, /* (406) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  350,   -1 }, /* (407) table_reference ::= table_primary */
  {  350,   -1 }, /* (408) table_reference ::= joined_table */
  {  351,   -2 }, /* (409) table_primary ::= table_name alias_opt */
  {  351,   -4 }, /* (410) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  351,   -2 }, /* (411) table_primary ::= subquery alias_opt */
  {  351,   -1 }, /* (412) table_primary ::= parenthesized_joined_table */
  {  353,    0 }, /* (413) alias_opt ::= */
  {  353,   -1 }, /* (414) alias_opt ::= table_alias */
  {  353,   -2 }, /* (415) alias_opt ::= AS table_alias */
  {  354,   -3 }, /* (416) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  354,   -3 }, /* (417) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  352,   -6 }, /* (418) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  355,    0 }, /* (419) join_type ::= */
  {  355,   -1 }, /* (420) join_type ::= INNER */
  {  357,  -12 }, /* (421) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  358,    0 }, /* (422) set_quantifier_opt ::= */
  {  358,   -1 }, /* (423) set_quantifier_opt ::= DISTINCT */
  {  358,   -1 }, /* (424) set_quantifier_opt ::= ALL */
  {  359,   -1 }, /* (425) select_list ::= select_item */
  {  359,   -3 }, /* (426) select_list ::= select_list NK_COMMA select_item */
  {  367,   -1 }, /* (427) select_item ::= NK_STAR */
  {  367,   -1 }, /* (428) select_item ::= common_expression */
  {  367,   -2 }, /* (429) select_item ::= common_expression column_alias */
  {  367,   -3 }, /* (430) select_item ::= common_expression AS column_alias */
  {  367,   -3 }, /* (431) select_item ::= table_name NK_DOT NK_STAR */
  {  325,    0 }, /* (432) where_clause_opt ::= */
  {  325,   -2 }, /* (433) where_clause_opt ::= WHERE search_condition */
  {  360,    0 }, /* (434) partition_by_clause_opt ::= */
  {  360,   -3 }, /* (435) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  364,    0 }, /* (436) twindow_clause_opt ::= */
  {  364,   -6 }, /* (437) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  364,   -4 }, /* (438) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  364,   -6 }, /* (439) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  364,   -8 }, /* (440) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  311,    0 }, /* (441) sliding_opt ::= */
  {  311,   -4 }, /* (442) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  363,    0 }, /* (443) fill_opt ::= */
  {  363,   -4 }, /* (444) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  363,   -6 }, /* (445) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  368,   -1 }, /* (446) fill_mode ::= NONE */
  {  368,   -1 }, /* (447) fill_mode ::= PREV */
  {  368,   -1 }, /* (448) fill_mode ::= NULL */
  {  368,   -1 }, /* (449) fill_mode ::= LINEAR */
  {  368,   -1 }, /* (450) fill_mode ::= NEXT */
  {  365,    0 }, /* (451) group_by_clause_opt ::= */
  {  365,   -3 }, /* (452) group_by_clause_opt ::= GROUP BY group_by_list */
  {  369,   -1 }, /* (453) group_by_list ::= expression */
  {  369,   -3 }, /* (454) group_by_list ::= group_by_list NK_COMMA expression */
  {  366,    0 }, /* (455) having_clause_opt ::= */
  {  366,   -2 }, /* (456) having_clause_opt ::= HAVING search_condition */
  {  361,    0 }, /* (457) range_opt ::= */
  {  361,   -6 }, /* (458) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  362,    0 }, /* (459) every_opt ::= */
  {  362,   -4 }, /* (460) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  316,   -4 }, /* (461) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  370,   -1 }, /* (462) query_expression_body ::= query_primary */
  {  370,   -4 }, /* (463) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  370,   -3 }, /* (464) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  374,   -1 }, /* (465) query_primary ::= query_specification */
  {  374,   -6 }, /* (466) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  371,    0 }, /* (467) order_by_clause_opt ::= */
  {  371,   -3 }, /* (468) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  372,    0 }, /* (469) slimit_clause_opt ::= */
  {  372,   -2 }, /* (470) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  372,   -4 }, /* (471) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  372,   -4 }, /* (472) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  373,    0 }, /* (473) limit_clause_opt ::= */
  {  373,   -2 }, /* (474) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  373,   -4 }, /* (475) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  373,   -4 }, /* (476) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  335,   -3 }, /* (477) subquery ::= NK_LP query_expression NK_RP */
  {  356,   -1 }, /* (478) search_condition ::= common_expression */
  {  375,   -1 }, /* (479) sort_specification_list ::= sort_specification */
  {  375,   -3 }, /* (480) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  376,   -3 }, /* (481) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  377,    0 }, /* (482) ordering_specification_opt ::= */
  {  377,   -1 }, /* (483) ordering_specification_opt ::= ASC */
  {  377,   -1 }, /* (484) ordering_specification_opt ::= DESC */
  {  378,    0 }, /* (485) null_ordering_opt ::= */
  {  378,   -2 }, /* (486) null_ordering_opt ::= NULLS FIRST */
  {  378,   -2 }, /* (487) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,257,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,258,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,257,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,259,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,260,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,258,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,260,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,259,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy0, yymsp[0].minor.yy285); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy361, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy285 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy285 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy457, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy457, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy457 = yymsp[0].minor.yy457; }
  yymsp[0].minor.yy457 = yylhsminor.yy457;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy457 = yymsp[-2].minor.yy457 | yymsp[0].minor.yy457; }
  yymsp[-2].minor.yy457 = yylhsminor.yy457;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy457 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy361 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy361 = yylhsminor.yy361;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy361 = yymsp[-2].minor.yy361; }
  yymsp[-2].minor.yy361 = yylhsminor.yy361;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy361, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 310: /* db_name ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* table_name ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* column_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* function_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* table_alias ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* column_alias ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* user_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* index_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* topic_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* stream_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 356: /* noarg_func ::= NOW */ yytestcase(yyruleno==356);
      case 357: /* noarg_func ::= TODAY */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==358);
      case 359: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= USER */ yytestcase(yyruleno==364);
      case 365: /* star_func ::= COUNT */ yytestcase(yyruleno==365);
      case 366: /* star_func ::= FIRST */ yytestcase(yyruleno==366);
      case 367: /* star_func ::= LAST */ yytestcase(yyruleno==367);
      case 368: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==368);
{ yylhsminor.yy361 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy361 = yylhsminor.yy361;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy151, &yymsp[-1].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy151 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 249: /* analyze_opt ::= */ yytestcase(yyruleno==249);
      case 257: /* agg_func_opt ::= */ yytestcase(yyruleno==257);
      case 422: /* set_quantifier_opt ::= */ yytestcase(yyruleno==422);
{ yymsp[1].minor.yy151 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy151 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy616 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 79: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 80: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 81: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 82: /* db_options ::= db_options KEEP integer_list */
      case 83: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==83);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_KEEP, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 84: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 85: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 89: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 90: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 91: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 92: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_RETENTIONS, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 93: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 94: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy616 = createAlterDatabaseOptions(pCxt); yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yylhsminor.yy616, &yymsp[0].minor.yy409); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 95: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy616, &yymsp[0].minor.yy409); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 96: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy409.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= KEEP integer_list */
      case 100: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==100);
{ yymsp[-1].minor.yy409.type = DB_OPTION_KEEP; yymsp[-1].minor.yy409.pList = yymsp[0].minor.yy356; }
        break;
      case 101: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy409.type = DB_OPTION_WAL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy356 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 103: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 279: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==279);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 104: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy356 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 105: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 106: /* retention_list ::= retention */
      case 126: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==126);
      case 129: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==129);
      case 136: /* column_def_list ::= column_def */ yytestcase(yyruleno==136);
      case 179: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==179);
      case 184: /* col_name_list ::= col_name */ yytestcase(yyruleno==184);
      case 232: /* func_list ::= func */ yytestcase(yyruleno==232);
      case 308: /* literal_list ::= signed_literal */ yytestcase(yyruleno==308);
      case 371: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==371);
      case 425: /* select_list ::= select_item */ yytestcase(yyruleno==425);
      case 479: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==479);
{ yylhsminor.yy356 = createNodeList(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 107: /* retention_list ::= retention_list NK_COMMA retention */
      case 137: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==185);
      case 233: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==233);
      case 309: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==309);
      case 372: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==372);
      case 426: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==426);
      case 480: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==480);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 108: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy616 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 109: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 111: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==111);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy151, yymsp[-5].minor.yy616, yymsp[-3].minor.yy356, yymsp[-1].minor.yy356, yymsp[0].minor.yy616); }
        break;
      case 110: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy356); }
        break;
      case 112: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy356); }
        break;
      case 113: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy616); }
        break;
      case 114: /* cmd ::= ALTER TABLE alter_table_clause */
      case 282: /* cmd ::= query_expression */ yytestcase(yyruleno==282);
{ pCxt->pRootNode = yymsp[0].minor.yy616; }
        break;
      case 115: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy616); }
        break;
      case 116: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy616 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 117: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 118: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 119: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 120: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 121: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 122: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 123: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 124: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 125: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy616 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy616, &yymsp[-2].minor.yy361, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 127: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 130: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==130);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-1].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy356 = yylhsminor.yy356;
        break;
      case 128: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy616 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy151, yymsp[-8].minor.yy616, yymsp[-6].minor.yy616, yymsp[-5].minor.yy356, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
  yymsp[-9].minor.yy616 = yylhsminor.yy616;
        break;
      case 131: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy616 = createDropTableClause(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 132: /* specific_cols_opt ::= */
      case 163: /* tags_def_opt ::= */ yytestcase(yyruleno==163);
      case 434: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==434);
      case 451: /* group_by_clause_opt ::= */ yytestcase(yyruleno==451);
      case 467: /* order_by_clause_opt ::= */ yytestcase(yyruleno==467);
{ yymsp[1].minor.yy356 = NULL; }
        break;
      case 133: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy356 = yymsp[-1].minor.yy356; }
        break;
      case 134: /* full_table_name ::= table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy361, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 135: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 138: /* column_def ::= column_name type_name */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy361, yymsp[0].minor.yy600, NULL); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 139: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 140: /* type_name ::= BOOL */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 141: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 142: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 143: /* type_name ::= INT */
      case 144: /* type_name ::= INTEGER */ yytestcase(yyruleno==144);
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 145: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 146: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 147: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 148: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 149: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 150: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 151: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 152: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 153: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 154: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy600 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 155: /* type_name ::= JSON */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 156: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 158: /* type_name ::= BLOB */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 159: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy600 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 164: /* tags_def_opt ::= tags_def */
      case 370: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==370);
{ yylhsminor.yy356 = yymsp[0].minor.yy356; }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 165: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy356 = yymsp[-1].minor.yy356; }
        break;
      case 166: /* table_options ::= */
{ yymsp[1].minor.yy616 = createDefaultTableOptions(pCxt); }
        break;
      case 167: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 168: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 169: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy356); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 170: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy356); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 171: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 172: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_SMA, yymsp[-1].minor.yy356); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 173: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy616 = createAlterTableOptions(pCxt); yylhsminor.yy616 = setTableOption(pCxt, yylhsminor.yy616, yymsp[0].minor.yy409.type, &yymsp[0].minor.yy409.val); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 174: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy409.type, &yymsp[0].minor.yy409.val); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 175: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy409.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 176: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy409.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy409.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* duration_list ::= duration_literal */
      case 337: /* expression_list ::= expression */ yytestcase(yyruleno==337);
{ yylhsminor.yy356 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 178: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 338: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==338);
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 181: /* rollup_func_name ::= function_name */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy361, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 182: /* rollup_func_name ::= FIRST */
      case 183: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==183);
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 186: /* col_name ::= column_name */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy361); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 187: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 188: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 189: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 190: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy616, NULL, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 195: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 196: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 197: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy616, yymsp[-1].minor.yy616, OP_TYPE_EQUAL); }
        break;
      case 198: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 199: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 200: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 201: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 202: /* cmd ::= SHOW LICENCE */
      case 203: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==203);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 204: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy361); }
        break;
      case 205: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 206: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 207: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 208: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 209: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 210: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 211: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 213: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 216: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 218: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 219: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 220: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy616, yymsp[-1].minor.yy616, OP_TYPE_EQUAL); }
        break;
      case 221: /* db_name_cond_opt ::= */
      case 226: /* from_db_opt ::= */ yytestcase(yyruleno==226);
{ yymsp[1].minor.yy616 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 222: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 223: /* like_pattern_opt ::= */
      case 263: /* into_opt ::= */ yytestcase(yyruleno==263);
      case 403: /* from_clause_opt ::= */ yytestcase(yyruleno==403);
      case 432: /* where_clause_opt ::= */ yytestcase(yyruleno==432);
      case 436: /* twindow_clause_opt ::= */ yytestcase(yyruleno==436);
      case 441: /* sliding_opt ::= */ yytestcase(yyruleno==441);
      case 443: /* fill_opt ::= */ yytestcase(yyruleno==443);
      case 455: /* having_clause_opt ::= */ yytestcase(yyruleno==455);
      case 457: /* range_opt ::= */ yytestcase(yyruleno==457);
      case 459: /* every_opt ::= */ yytestcase(yyruleno==459);
      case 469: /* slimit_clause_opt ::= */ yytestcase(yyruleno==469);
      case 473: /* limit_clause_opt ::= */ yytestcase(yyruleno==473);
{ yymsp[1].minor.yy616 = NULL; }
        break;
      case 224: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 225: /* table_name_cond ::= table_name */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy361); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 227: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy361); }
        break;
      case 228: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy361, NULL, yymsp[0].minor.yy616); }
        break;
      case 229: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 230: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy616 = createIndexOption(pCxt, yymsp[-7].minor.yy356, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 231: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy616 = createIndexOption(pCxt, yymsp[-9].minor.yy356, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 234: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-1].minor.yy356); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 235: /* sma_stream_opt ::= */
      case 265: /* stream_options ::= */ yytestcase(yyruleno==265);
{ yymsp[1].minor.yy616 = createStreamOptions(pCxt); }
        break;
      case 236: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 269: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==269);
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 237: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 238: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy361, yymsp[0].minor.yy616); }
        break;
      case 239: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, &yymsp[0].minor.yy361, false); }
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy151, &yymsp[-5].minor.yy361, &yymsp[0].minor.yy361, true); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy361, yymsp[0].minor.yy616, false); }
        break;
      case 242: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy151, &yymsp[-5].minor.yy361, yymsp[0].minor.yy616, true); }
        break;
      case 243: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 244: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361); }
        break;
      case 245: /* cmd ::= DESC full_table_name */
      case 246: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==246);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 247: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 248: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy151, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 250: /* analyze_opt ::= ANALYZE */
      case 258: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==258);
      case 423: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==423);
{ yymsp[0].minor.yy151 = true; }
        break;
      case 251: /* explain_options ::= */
{ yymsp[1].minor.yy616 = createDefaultExplainOptions(pCxt); }
        break;
      case 252: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy616 = setExplainVerbose(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 253: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy616 = setExplainRatio(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 254: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,273,&yymsp[-1].minor);
        break;
      case 255: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy151, yymsp[-8].minor.yy151, &yymsp[-5].minor.yy361, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy600, yymsp[0].minor.yy734); }
        break;
      case 256: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 259: /* bufsize_opt ::= */
{ yymsp[1].minor.yy734 = 0; }
        break;
      case 260: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy734 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 261: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy151, &yymsp[-4].minor.yy361, yymsp[-2].minor.yy616, yymsp[-3].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 262: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy361); }
        break;
      case 264: /* into_opt ::= INTO full_table_name */
      case 404: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==404);
      case 433: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==433);
      case 456: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==456);
{ yymsp[-1].minor.yy616 = yymsp[0].minor.yy616; }
        break;
      case 266: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 267: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 268: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy616)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-3].minor.yy616; }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 270: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->ignoreExpired = true; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 271: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 272: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 273: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 274: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 275: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 276: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy356); }
        break;
      case 277: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 278: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy356 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 280: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy361); }
        break;
      case 281: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 283: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy616, yymsp[-2].minor.yy356, yymsp[0].minor.yy616); }
        break;
      case 284: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy616, NULL, yymsp[0].minor.yy616); }
        break;
      case 285: /* literal ::= NK_INTEGER */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 286: /* literal ::= NK_FLOAT */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 287: /* literal ::= NK_STRING */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 288: /* literal ::= NK_BOOL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 289: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 290: /* literal ::= duration_literal */
      case 300: /* signed_literal ::= signed */ yytestcase(yyruleno==300);
      case 321: /* expression ::= literal */ yytestcase(yyruleno==321);
      case 322: /* expression ::= pseudo_column */ yytestcase(yyruleno==322);
      case 323: /* expression ::= column_reference */ yytestcase(yyruleno==323);
      case 324: /* expression ::= function_expression */ yytestcase(yyruleno==324);
      case 325: /* expression ::= subquery */ yytestcase(yyruleno==325);
      case 353: /* function_expression ::= literal_func */ yytestcase(yyruleno==353);
      case 395: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==395);
      case 399: /* boolean_primary ::= predicate */ yytestcase(yyruleno==399);
      case 401: /* common_expression ::= expression */ yytestcase(yyruleno==401);
      case 402: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==402);
      case 405: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==405);
      case 407: /* table_reference ::= table_primary */ yytestcase(yyruleno==407);
      case 408: /* table_reference ::= joined_table */ yytestcase(yyruleno==408);
      case 412: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==412);
      case 462: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==462);
      case 465: /* query_primary ::= query_specification */ yytestcase(yyruleno==465);
{ yylhsminor.yy616 = yymsp[0].minor.yy616; }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 291: /* literal ::= NULL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 292: /* literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 293: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 294: /* signed ::= NK_INTEGER */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 295: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 296: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 297: /* signed ::= NK_FLOAT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 298: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 299: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 301: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 302: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 303: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 304: /* signed_literal ::= duration_literal */
      case 306: /* signed_literal ::= literal_func */ yytestcase(yyruleno==306);
      case 373: /* star_func_para ::= expression */ yytestcase(yyruleno==373);
      case 428: /* select_item ::= common_expression */ yytestcase(yyruleno==428);
      case 478: /* search_condition ::= common_expression */ yytestcase(yyruleno==478);
{ yylhsminor.yy616 = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 305: /* signed_literal ::= NULL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 307: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 326: /* expression ::= NK_LP expression NK_RP */
      case 400: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==400);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 327: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy616));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 328: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 329: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 330: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 331: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 332: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 333: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 334: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 335: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 336: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 339: /* column_reference ::= column_name */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy361, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy361)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 340: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361, createColumnNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy361)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 341: /* pseudo_column ::= ROWTS */
      case 342: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==342);
      case 344: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==344);
      case 345: /* pseudo_column ::= QEND */ yytestcase(yyruleno==345);
      case 346: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==346);
      case 347: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==347);
      case 348: /* pseudo_column ::= WEND */ yytestcase(yyruleno==348);
      case 349: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==349);
      case 355: /* literal_func ::= NOW */ yytestcase(yyruleno==355);
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 343: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy361)))); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 350: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 351: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==351);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy361, yymsp[-1].minor.yy356)); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 352: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy600)); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 354: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy361, NULL)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 369: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy356 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 374: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 431: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==431);
{ yylhsminor.yy616 = createColumnNode(pCxt, &yymsp[-2].minor.yy361, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 375: /* predicate ::= expression compare_op expression */
      case 380: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==380);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy526, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 376: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 377: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 378: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), NULL));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 379: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL));
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 381: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy526 = OP_TYPE_LOWER_THAN; }
        break;
      case 382: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy526 = OP_TYPE_GREATER_THAN; }
        break;
      case 383: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy526 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 384: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy526 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 385: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy526 = OP_TYPE_NOT_EQUAL; }
        break;
      case 386: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy526 = OP_TYPE_EQUAL; }
        break;
      case 387: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy526 = OP_TYPE_LIKE; }
        break;
      case 388: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy526 = OP_TYPE_NOT_LIKE; }
        break;
      case 389: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy526 = OP_TYPE_MATCH; }
        break;
      case 390: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy526 = OP_TYPE_NMATCH; }
        break;
      case 391: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy526 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 392: /* in_op ::= IN */
{ yymsp[0].minor.yy526 = OP_TYPE_IN; }
        break;
      case 393: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy526 = OP_TYPE_NOT_IN; }
        break;
      case 394: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy356)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 396: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 397: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 398: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 406: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 409: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 410: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-3].minor.yy361, &yymsp[-1].minor.yy361, &yymsp[0].minor.yy361); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 411: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy616 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 413: /* alias_opt ::= */
{ yymsp[1].minor.yy361 = nil_token;  }
        break;
      case 414: /* alias_opt ::= table_alias */
{ yylhsminor.yy361 = yymsp[0].minor.yy361; }
  yymsp[0].minor.yy361 = yylhsminor.yy361;
        break;
      case 415: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy361 = yymsp[0].minor.yy361; }
        break;
      case 416: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 417: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==417);
{ yymsp[-2].minor.yy616 = yymsp[-1].minor.yy616; }
        break;
      case 418: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, yymsp[-4].minor.yy504, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 419: /* join_type ::= */
{ yymsp[1].minor.yy504 = JOIN_TYPE_INNER; }
        break;
      case 420: /* join_type ::= INNER */
{ yymsp[0].minor.yy504 = JOIN_TYPE_INNER; }
        break;
      case 421: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy616 = createSelectStmt(pCxt, yymsp[-10].minor.yy151, yymsp[-9].minor.yy356, yymsp[-8].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addWhereClause(pCxt, yymsp[-11].minor.yy616, yymsp[-7].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addPartitionByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-6].minor.yy356);
                                                                                    yymsp[-11].minor.yy616 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy616, yymsp[-2].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addGroupByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-1].minor.yy356);
                                                                                    yymsp[-11].minor.yy616 = addHavingClause(pCxt, yymsp[-11].minor.yy616, yymsp[0].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addRangeClause(pCxt, yymsp[-11].minor.yy616, yymsp[-5].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addEveryClause(pCxt, yymsp[-11].minor.yy616, yymsp[-4].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addFillClause(pCxt, yymsp[-11].minor.yy616, yymsp[-3].minor.yy616);
                                                                                  }
        break;
      case 424: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy151 = false; }
        break;
      case 427: /* select_item ::= NK_STAR */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 429: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 430: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), &yymsp[0].minor.yy361); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 435: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 452: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==452);
      case 468: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==468);
{ yymsp[-2].minor.yy356 = yymsp[0].minor.yy356; }
        break;
      case 437: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy616 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 438: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy616 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 439: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 440: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 442: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 460: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==460);
{ yymsp[-3].minor.yy616 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy616); }
        break;
      case 444: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy616 = createFillNode(pCxt, yymsp[-1].minor.yy494, NULL); }
        break;
      case 445: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy616 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy356)); }
        break;
      case 446: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy494 = FILL_MODE_NONE; }
        break;
      case 447: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy494 = FILL_MODE_PREV; }
        break;
      case 448: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy494 = FILL_MODE_NULL; }
        break;
      case 449: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy494 = FILL_MODE_LINEAR; }
        break;
      case 450: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy494 = FILL_MODE_NEXT; }
        break;
      case 453: /* group_by_list ::= expression */
{ yylhsminor.yy356 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[0].minor.yy356 = yylhsminor.yy356;
        break;
      case 454: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy356 = addNodeToList(pCxt, yymsp[-2].minor.yy356, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[-2].minor.yy356 = yylhsminor.yy356;
        break;
      case 458: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy616 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 461: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy616 = addOrderByClause(pCxt, yymsp[-3].minor.yy616, yymsp[-2].minor.yy356);
                                                                                    yylhsminor.yy616 = addSlimitClause(pCxt, yylhsminor.yy616, yymsp[-1].minor.yy616);
                                                                                    yylhsminor.yy616 = addLimitClause(pCxt, yylhsminor.yy616, yymsp[0].minor.yy616);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 463: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 464: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 466: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy616 = addOrderByClause(pCxt, yymsp[-4].minor.yy616, yymsp[-3].minor.yy356);
                                                                                    yymsp[-5].minor.yy616 = addSlimitClause(pCxt, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616);
                                                                                    yymsp[-5].minor.yy616 = addLimitClause(pCxt, yymsp[-5].minor.yy616, yymsp[-1].minor.yy616);
                                                                                  }
        break;
      case 470: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 474: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==474);
{ yymsp[-1].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 471: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 475: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==475);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 472: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 476: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==476);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 477: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 481: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy616 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), yymsp[-1].minor.yy58, yymsp[0].minor.yy613); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 482: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy58 = ORDER_ASC; }
        break;
      case 483: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy58 = ORDER_ASC; }
        break;
      case 484: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy58 = ORDER_DESC; }
        break;
      case 485: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy613 = NULL_ORDER_DEFAULT; }
        break;
      case 486: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy613 = NULL_ORDER_FIRST; }
        break;
      case 487: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy613 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
