/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 485
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy48;
  EOperatorType yy70;
  int8_t yy73;
  int32_t yy120;
  SNodeList* yy174;
  EFillMode yy204;
  SNode* yy242;
  STokenPair yy257;
  int64_t yy349;
  EJoinType yy482;
  SAlterOption yy535;
  SToken yy669;
  ENullOrder yy687;
  bool yy777;
  SDataType yy794;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             792
#define YYNRULE              595
#define YYNRULE_WITH_ACTION  595
#define YYNTOKEN             337
#define YY_MAX_SHIFT         791
#define YY_MIN_SHIFTREDUCE   1169
#define YY_MAX_SHIFTREDUCE   1763
#define YY_ERROR_ACTION      1764
#define YY_ACCEPT_ACTION     1765
#define YY_NO_ACTION         1766
#define YY_MIN_REDUCE        1767
#define YY_MAX_REDUCE        2361
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2716)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2173,  169, 2337,   38,  303, 2332,  170,  445, 1779, 1885,
 /*    10 */   660,  444,   48,   46, 1691, 1933,  181, 2337, 2151, 1790,
 /*    20 */   399, 2336, 1540,   41,   40, 2333, 2335,   47,   45,   44,
 /*    30 */    43,   42, 2159, 1621, 1567, 1538,  366, 2046, 2191,   41,
 /*    40 */    40,  451, 2155,   47,   45,   44,   43,   42,  402,  663,
 /*    50 */  2141, 1568,  698, 1566,  620,  526,  164, 2332,  527, 1803,
 /*    60 */  2173,  218, 1616,  380, 1946,  529,  167, 1810,   19, 2141,
 /*    70 */   699, 1995, 2338,  188, 1947, 1546,  184, 2333,  646, 2157,
 /*    80 */   396, 2106, 2337,  358, 2172, 2332,  345, 2208, 1984,  692,
 /*    90 */   110, 2174,  702, 2176, 2177,  697,  620,  692, 2191, 2332,
 /*   100 */   788, 2336,  185,   15, 2261, 2333, 2334,  220,  395, 2257,
 /*   110 */  2141,  529,  698, 1810, 2338,  188,   48,   46, 1753, 2333,
 /*   120 */   646,  190,  682, 1944,  399, 1789, 1540, 1650,  251, 2287,
 /*   130 */    47,   45,   44,   43,   42,  668, 1567, 1621,  205, 1538,
 /*   140 */  1623, 1624,  133, 2063, 2172,  682, 1944, 2208, 1304,  566,
 /*   150 */   110, 2174,  702, 2176, 2177,  697, 2124,  692, 2061,  669,
 /*   160 */   145, 1565,  152, 2232, 2261,  193, 1616,  668,  395, 2257,
 /*   170 */  1596, 1606,   19, 1395, 1396, 2141, 1622, 1625,   84, 1546,
 /*   180 */  1920,   83,  657,  142, 1651, 1768,  284,  541, 1306, 2056,
 /*   190 */  1541,  123, 1539,  681,  122,  121,  120,  119,  118,  117,
 /*   200 */   116,  115,  114,  262,  788,  668,  123,   15, 2173,  122,
 /*   210 */   121,  120,  119,  118,  117,  116,  115,  114,  699,  666,
 /*   220 */  1812, 2056, 1544, 1545, 1767, 1595, 1598, 1599, 1600, 1601,
 /*   230 */  1602, 1603, 1604, 1605,  694,  690, 1614, 1615, 1617, 1618,
 /*   240 */  1619, 1620,    2,  681, 1623, 1624, 2191,  737,  132,  131,
 /*   250 */   130,  129,  128,  127,  126,  125,  124,  677, 2141, 2056,
 /*   260 */   698,   37,  397, 1645, 1646, 1647, 1648, 1649, 1653, 1654,
 /*   270 */  1655, 1656,  543, 2173, 1596, 1606,   51,  682, 1944,   66,
 /*   280 */  1622, 1625,    9,  660,  659,  186, 2269, 2270,  284,  140,
 /*   290 */  2274, 1227, 2172, 1226, 1541, 2208, 1539,  133,  110, 2174,
 /*   300 */   702, 2176, 2177,  697,  571,  692,  138,  531,  682, 1944,
 /*   310 */  2352, 2191, 2261,  528,   41,   40,  395, 2257,   47,   45,
 /*   320 */    44,   43,   42, 2141, 1228,  698, 1544, 1545,   57, 1595,
 /*   330 */  1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605,  694,  690,
 /*   340 */  1614, 1615, 1617, 1618, 1619, 1620,    2,   12,   48,   46,
 /*   350 */  1227, 2173, 1226,  408,  407, 2336,  399, 2172, 1540, 2276,
 /*   360 */  2208,  696, 1922,  110, 2174,  702, 2176, 2177,  697, 1621,
 /*   370 */   692, 1538,  428, 1997,  181,  185, 1547, 2261,   62,  639,
 /*   380 */   379,  395, 2257, 1228, 2063, 2273,   41,   40, 1995, 2191,
 /*   390 */    47,   45,   44,   43,   42, 2047,  392, 1360, 1616, 2060,
 /*   400 */   669, 2141, 2288,  698,   19,  534,  150, 2191,  527, 1803,
 /*   410 */  1730, 1546, 1351,  727,  726,  725, 1355,  724, 1357, 1358,
 /*   420 */   723,  720,   30, 1366,  717, 1368, 1369,  714,  711,  708,
 /*   430 */   667, 1695,  191, 1565,  107, 2172,  788, 1565, 2208,   15,
 /*   440 */   101,  339, 2174,  702, 2176, 2177,  697,  695,  692,  683,
 /*   450 */  2226,  143,   48,   46, 1626,   87,  635,   34,  234, 1936,
 /*   460 */   399,  638, 1540,   41,   40, 1937,  681,   47,   45,   44,
 /*   470 */    43,   42,  368, 1621,  174, 1538, 1623, 1624,  640,  682,
 /*   480 */  1944, 1939,  560,  556,  552,  548, 2042,  233,  285,  393,
 /*   490 */   735,  157,  156,  732,  731,  730,  154,  167, 2173,  449,
 /*   500 */  1202, 1684, 1616, 1565, 1719, 1946, 1596, 1606,  699,   12,
 /*   510 */  2295,   10, 1622, 1625, 2042, 1546,   41,   40,  682, 1944,
 /*   520 */    47,   45,   44,   43,   42, 1564, 1541,   88, 1539,   62,
 /*   530 */   231,   93,  201, 1550,  191,  489, 2191, 1568,  450, 1204,
 /*   540 */   788, 1207, 1208,   49, 1788,  641,  636,  629, 2141,   51,
 /*   550 */   698,  632,  631, 1717, 1718, 1720, 1721, 1722, 1544, 1545,
 /*   560 */   203, 1595, 1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605,
 /*   570 */   694,  690, 1614, 1615, 1617, 1618, 1619, 1620,    2,   62,
 /*   580 */  1623, 1624, 2172, 1450, 1451, 2208,   62, 1597,  110, 2174,
 /*   590 */   702, 2176, 2177,  697, 2141,  692,  209,  208,  230,  224,
 /*   600 */  2352,  523, 2261,  229,  737,  539,  395, 2257, 2173,  521,
 /*   610 */  1596, 1606,  517,  513,  682, 1944, 1622, 1625,  699,  488,
 /*   620 */  2308,  682, 1944,  222,  607, 2151,   52,   62,  294,  295,
 /*   630 */  1541,  648, 1539,  293,  459,  584,  583,  582,  684, 1935,
 /*   640 */  2233,  474,  574,  139,  578, 2127, 2191, 1787,  577, 2155,
 /*   650 */   657,  142, 1549,  576,  581,  374,  373, 2027, 2141,  575,
 /*   660 */   698, 2134, 1544, 1545, 1566, 1595, 1598, 1599, 1600, 1601,
 /*   670 */  1602, 1603, 1604, 1605,  694,  690, 1614, 1615, 1617, 1618,
 /*   680 */  1619, 1620,    2,   48,   46,  191, 2157,  682, 1944,  202,
 /*   690 */  1760,  399, 2172, 1540,  421, 2208,  692, 2141,  110, 2174,
 /*   700 */   702, 2176, 2177,  697, 1621,  692, 1538,  475,  620, 2173,
 /*   710 */  2352, 2332, 2261,  443,  402,  442,  395, 2257, 1921,  699,
 /*   720 */   404,  589,  167, 1990, 1992, 2276, 2338,  188,  682, 1944,
 /*   730 */  1946, 2333,  646, 1616, 1631,  191,  599, 1991, 1992, 2173,
 /*   740 */  1565,  433,  191,  682, 1944,  441, 1546, 2191,  542,  699,
 /*   750 */   247, 2272,  598,  282, 2269,  656,   12,  134,  655, 2141,
 /*   760 */  2332,  698,  405, 1941, 2276,  596,  592,  594,  435,  431,
 /*   770 */   167,  788, 1546,  586,   49,  644,  188, 2191, 1946,  246,
 /*   780 */  2333,  646,  191,  191, 1467, 1468,  747,   48,   46, 2141,
 /*   790 */  2271,  698, 1759, 2172, 1315,  399, 2208, 1540,  250,  111,
 /*   800 */  2174,  702, 2176, 2177,  697, 1652,  692, 1314, 1621, 1552,
 /*   810 */  1538, 1623, 1624, 2261,  657,  142,  469, 2260, 2257,   70,
 /*   820 */  1466, 1469,   69, 2172, 1919,  468, 2208,  728, 1997,  171,
 /*   830 */  2174,  702, 2176, 2177,  697,  389,  692, 1616, 1786, 2173,
 /*   840 */  1210, 1596, 1606, 1995,  682, 1944, 1564, 1622, 1625,  699,
 /*   850 */  1546,  735,  157,  156,  732,  731,  730,  154,  452, 1997,
 /*   860 */   686, 1541, 2233, 1539,  252,  155,  394, 1511, 1512,  621,
 /*   870 */  2298,  453,  498,   36, 1995,  788, 1929, 2191,   15,   41,
 /*   880 */    40, 1931,   35,   47,   45,   44,   43,   42, 2141, 2141,
 /*   890 */  1597,  698, 1657, 1544, 1545, 1927, 1595, 1598, 1599, 1600,
 /*   900 */  1601, 1602, 1603, 1604, 1605,  694,  690, 1614, 1615, 1617,
 /*   910 */  1618, 1619, 1620,    2, 1785, 1623, 1624,  187, 2269, 2270,
 /*   920 */  1765,  140, 2274, 2172, 1784,   56, 2208, 1783, 1782,  171,
 /*   930 */  2174,  702, 2176, 2177,  697,  349,  692, 1563,   44,   43,
 /*   940 */    42, 1997,  259, 2173,  482, 1596, 1606,  496,  403, 1781,
 /*   950 */   495, 1622, 1625,  699, 1997,  627, 1995,  735,  157,  156,
 /*   960 */   732,  731,  730,  154, 2141, 1541,  465, 1539,  497, 1996,
 /*   970 */  2299,  682, 1944,  467, 2141, 1540, 1319, 2141, 2141,   41,
 /*   980 */    40, 2191, 1778,   47,   45,   44,   43,   42, 1538, 1318,
 /*   990 */  1568,  616,  414, 2141, 1777,  698,  413, 1544, 1545, 2141,
 /*  1000 */  1595, 1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605,  694,
 /*  1010 */   690, 1614, 1615, 1617, 1618, 1619, 1620,    2, 1843,  367,
 /*  1020 */  1565,  682, 1944,  657,  142,  580,  579, 2172, 1546, 1948,
 /*  1030 */  2208,  455, 2141,  110, 2174,  702, 2176, 2177,  697,  620,
 /*  1040 */   692,  661, 2332, 1776, 2141, 2352,  570, 2261, 1230, 1231,
 /*  1050 */   569,  395, 2257,  788,  500,  562,  561, 2338,  188,  564,
 /*  1060 */   563,  493, 2333,  646,  487,  486,  485,  484,  481,  480,
 /*  1070 */   479,  478,  477,  473,  472,  471,  470,  348,  462,  461,
 /*  1080 */   460,  652,  457,  456,  365,  759,  757, 1775,  765,  764,
 /*  1090 */   763,  762,  411, 2141,  761,  760,  146,  755,  754,  753,
 /*  1100 */   752,  751,  750,  749,  159,  745,  744,  743,  410,  409,
 /*  1110 */   740,  739,  738,  177,  176,  168,  682, 1944, 2135, 1774,
 /*  1120 */   323, 1773, 1772,  408,  407,  256,  189, 2269, 2270, 2173,
 /*  1130 */   140, 2274,  371, 1554,  321,   73,  665, 2141,   72,  699,
 /*  1140 */   693, 2326,  261, 1541, 1621, 1539, 1547,   41,   40,  346,
 /*  1150 */  1688,   47,   45,   44,   43,   42, 2042, 1771,  682, 1944,
 /*  1160 */   216,  508,  506,  503,   54,  620,    3, 2191, 2332, 2141,
 /*  1170 */  1597, 2141, 2141, 1616,  649, 1544, 1545, 2173,  298, 2141,
 /*  1180 */  1770,  698,  260, 2338,  188, 2151, 1546,  699, 2333,  646,
 /*  1190 */    41,   40,   14,   13,   47,   45,   44,   43,   42, 2160,
 /*  1200 */    62,  372,  207,  370,  369,   74,  568, 2141,   87, 2155,
 /*  1210 */   689,  688,  605, 2172,  144, 2191, 2208, 2232, 1886,  110,
 /*  1220 */  2174,  702, 2176, 2177,  697,   91,  692, 2141,  570,  698,
 /*  1230 */  2141, 2352,  569, 2261, 1940, 2173,  572,  395, 2257,  109,
 /*  1240 */   148,  729,  135, 1707, 1988,  699, 2157, 2280,  733,  734,
 /*  1250 */   317, 1988, 1988, 1974,  748,   82,  692, 1906, 1302,  620,
 /*  1260 */   239, 2172, 2332,  237, 2208, 2281, 1684,  333, 2174,  702,
 /*  1270 */  2176, 2177,  697, 2191,  692, 1207, 1208, 2338,  188,   81,
 /*  1280 */    80,  448, 2333,  646,  200, 2141, 2173,  698,  241, 1780,
 /*  1290 */   573,  240,  619,  682, 1944, 1664,  699,  440,  438,  243,
 /*  1300 */  2301, 1555,  242, 1550,  245, 1762, 1763,  244,  347, 1830,
 /*  1310 */   642,  429, 1300,  679,  427,  423,  419,  416,  441, 2172,
 /*  1320 */   653,  602, 2208,  601, 2191,  110, 2174,  702, 2176, 2177,
 /*  1330 */   697,  585,  692, 1558, 1560, 1821, 2141, 2352,  698, 2261,
 /*  1340 */  1819,  155,  645,  395, 2257, 2332,  690, 1614, 1615, 1617,
 /*  1350 */  1618, 1619, 1620, 2173,  166,  249,  191,  587,  155,  248,
 /*  1360 */   644,  188,  590,  699, 1642, 2333,  646,  279,   50,   50,
 /*  1370 */  2172,  266,  155, 2208,   50,  291,  110, 2174,  702, 2176,
 /*  1380 */  2177,  697,  633,  692,  682, 1944, 2173,  137, 2236,  106,
 /*  1390 */  2261, 2191,  682, 1944,  395, 2257,  699,  682, 1944,  103,
 /*  1400 */    71, 1506, 2162, 2141,  680,  698, 1687,  153,  155,   14,
 /*  1410 */    13,  650,  304, 2173,   64,  273,   55,  406, 1509,   90,
 /*  1420 */  1548, 1813,  353,  699, 2191,  378,   50,  600, 1716, 1715,
 /*  1430 */   741,  268,  664,   50, 1464,  296, 2141, 2172,  698, 2192,
 /*  1440 */  2208, 1884,  706,  110, 2174,  702, 2176, 2177,  697, 2173,
 /*  1450 */   692, 2191, 1280, 1883,  153, 2234,  155, 2261, 2164,  699,
 /*  1460 */   674,  395, 2257, 2141,  136,  698,  412,  300, 1345,  153,
 /*  1470 */  2172,  783, 1261, 2208, 1658, 2173,  110, 2174,  702, 2176,
 /*  1480 */  2177,  697, 2051,  692, 1804,  699, 1607, 2191,  685,  742,
 /*  1490 */  2261, 1809, 1985,  316,  395, 2257, 2291, 2172,  658, 2141,
 /*  1500 */  2208,  698, 1373,  111, 2174,  702, 2176, 2177,  697,  281,
 /*  1510 */   692, 1278, 1262, 2191, 1377,  278, 1384, 2261,    1,    5,
 /*  1520 */   415,  687, 2257,  420, 1382, 2141,  362,  698, 1571,  158,
 /*  1530 */   437,  436,  196,  700,  439,  198, 2208,  195, 1487,  111,
 /*  1540 */  2174,  702, 2176, 2177,  697,  311,  692,  206,  454, 1568,
 /*  1550 */  2052,  458,  491, 2261, 2173,  463, 1563,  357, 2257, 2172,
 /*  1560 */   476, 2044, 2208,  483,  699,  172, 2174,  702, 2176, 2177,
 /*  1570 */   697,  490,  692,  492,  501,  502,  499, 1551,  210,  504,
 /*  1580 */  2173,  211,  505,  213,  507,  509, 1569,  524,    4,  525,
 /*  1590 */   699,  532, 2191,  533, 1566,  221,  536,  535, 1570,  223,
 /*  1600 */  1572,  537,  565,  538, 2141, 1997,  698,  540,  544,  226,
 /*  1610 */   228,   85,  364,   86, 2115,  232,  647, 2353, 2191,  112,
 /*  1620 */  1995, 2112,  352,  382,  567,  604, 1934,  606, 2111,   89,
 /*  1630 */  2141,  610,  698,  609,  312,  151,  611,  253, 2172,  236,
 /*  1640 */  1930, 2208, 2173,  238,  111, 2174,  702, 2176, 2177,  697,
 /*  1650 */   160,  692,  699,  161, 1932,  255, 1928,  162, 2261, 2173,
 /*  1660 */   163,  614,  257, 2258, 2172, 1494,  617, 2208, 2292,  699,
 /*  1670 */   340, 2174,  702, 2176, 2177,  697,  672,  692, 2173,  615,
 /*  1680 */  2191,  624,  634,  645, 2302,  383, 2332,    8,  699,  630,
 /*  1690 */  2307, 2306, 2141,  264,  698,  267, 2283, 2191,  384,  643,
 /*  1700 */   637,  644,  188,  385,  625,  623, 2333,  646,  622, 2141,
 /*  1710 */  1684,  698,  654,  277,  651,  141, 2191, 2355, 1567,  175,
 /*  1720 */  2331,  390, 2277,  662,  388,  286, 2172,  274, 2141, 2208,
 /*  1730 */   698,   96,  340, 2174,  702, 2176, 2177,  697,  272,  692,
 /*  1740 */  1573,  313, 2057, 2172,  280,  276, 2208,  670,  275,  172,
 /*  1750 */  2174,  702, 2176, 2177,  697,  675,  692,  671, 2071,  314,
 /*  1760 */   676, 2070, 2172,   98, 2173, 2208, 2069,  391,  340, 2174,
 /*  1770 */   702, 2176, 2177,  697,  696,  692,  315, 1945,  100,   61,
 /*  1780 */  2242, 2173,  102,  704, 1989,  318,  784, 1907,  307,  322,
 /*  1790 */   785,  699,  787,   53,  354,  327,  355,  342, 2133,  320,
 /*  1800 */  2173, 2354, 2191,  341, 2132,  331, 2131,   78, 2128,  417,
 /*  1810 */   699,  418, 1531, 1532, 2141,  194,  698,  422, 2126, 2191,
 /*  1820 */   424,  425,  426, 2125,  398,  363, 2123,  430, 2122,  432,
 /*  1830 */  2121, 2141,  434,  698, 2102, 1522,  197, 2101, 2191,  199,
 /*  1840 */  1490,   79, 1489,  400, 2083, 2082, 2081,  446, 2172,  447,
 /*  1850 */  2141, 2208,  698, 2080,  339, 2174,  702, 2176, 2177,  697,
 /*  1860 */  2079,  692, 1441, 2227, 2035, 2172,  147,  608, 2208, 2034,
 /*  1870 */  2032,  340, 2174,  702, 2176, 2177,  697, 2031,  692, 2030,
 /*  1880 */  2033, 2029, 2028, 2026, 2172,  791, 2025, 2208, 2024,  204,
 /*  1890 */   340, 2174,  702, 2176, 2177,  697,  464,  692, 2173,  310,
 /*  1900 */  2023,  466, 2037, 2022, 2021, 2020, 2019, 2018,  699, 2017,
 /*  1910 */  2016, 2015, 2014, 2013, 2012,  180,  149, 2007, 2006, 2005,
 /*  1920 */  2036, 2004, 2003,  781,  777,  773,  769, 2011,  308, 2010,
 /*  1930 */  2009, 2173, 2008, 2002, 2001, 2000, 2191, 1443,  494, 1999,
 /*  1940 */  1998,  699,  350,  351, 1849, 1316, 1320,  212, 2141, 1848,
 /*  1950 */   698,  214, 1847,  215, 1845, 1842, 1841,  511, 1834, 1823,
 /*  1960 */  1312,  510, 1799, 1798, 2173,  227,  514,  512,  108, 2191,
 /*  1970 */  2100,  301, 2090, 2078,  699,  516,  518,  522, 2077, 1209,
 /*  1980 */  2055, 2141,  603,  698, 1923, 2208,  520,  515,  335, 2174,
 /*  1990 */   702, 2176, 2177,  697,  519,  692, 1844,  182, 2161,  217,
 /*  2000 */  2173, 1840, 2191,   77,  678,  547,   76,  183,  530,  219,
 /*  2010 */   699,  545, 1254,  225, 2141, 2172,  698,  546, 2208, 1838,
 /*  2020 */   549,  324, 2174,  702, 2176, 2177,  697,  551,  692, 1836,
 /*  2030 */   550,  554,  553, 2173,  555, 1833,  558,  557, 2191,  288,
 /*  2040 */  1818, 1816,  559,  699,  287, 1817, 1815, 1795, 2172, 1925,
 /*  2050 */  2141, 2208,  698, 1389,  325, 2174,  702, 2176, 2177,  697,
 /*  2060 */    63,  692, 2173, 1924,  254, 1388, 1303, 1301, 1299, 1298,
 /*  2070 */   756, 2191,  699, 1297, 1296, 1831, 1290, 1295,  375, 1292,
 /*  2080 */   758,  235, 1822, 2141, 2172,  698, 1291, 2208,  376, 1820,
 /*  2090 */   326, 2174,  702, 2176, 2177,  697, 1289,  692,  377,  588,
 /*  2100 */  2191,  597,  591, 1794,  593, 1793,  595, 1792,  113, 1516,
 /*  2110 */  1520,   29, 2141, 1518,  698, 1515, 2099, 2172,   58,   67,
 /*  2120 */  2208, 1496, 2173,  332, 2174,  702, 2176, 2177,  697, 2089,
 /*  2130 */   692, 1498,  699,  612, 2076, 2074, 2337,   20,   17,    6,
 /*  2140 */    31, 2173,    7,   21,   22,  271, 2172, 1500,  270, 2208,
 /*  2150 */    33,  699,  336, 2174,  702, 2176, 2177,  697,  613,  692,
 /*  2160 */  2191, 1732,  381,  258,  265,  263,  626,  628,  165, 2162,
 /*  2170 */   618,   65, 2141,  173,  698,   24, 1714, 1706, 1747, 2191,
 /*  2180 */   269, 1746,  386, 1751,   32, 1750,   92,  283,  387, 2173,
 /*  2190 */  2075, 2141,  178,  698, 1752,   60, 1753, 2073, 2072,  699,
 /*  2200 */  1681, 1680, 2054,   95,  289,   94, 2172, 2053, 2173, 2208,
 /*  2210 */    97,   25,  328, 2174,  702, 2176, 2177,  697,  699,  692,
 /*  2220 */    26,  290, 1712,  292,  297, 2172,   68, 2191, 2208,   99,
 /*  2230 */   673,  337, 2174,  702, 2176, 2177,  697,  299,  692, 2141,
 /*  2240 */    23,  698, 1846,  103,   11, 1633, 2191,   13,  302, 1556,
 /*  2250 */    59,  179, 1643, 1611, 1588,   18, 2173, 1632, 2141, 1609,
 /*  2260 */   698, 2211,  691,   39,  192, 1608,  699, 1580,   16,   27,
 /*  2270 */    28,  705,  401, 2172,  701,  707, 2208, 2173,  709,  329,
 /*  2280 */  2174,  702, 2176, 2177,  697, 1374,  692,  699,  703, 1371,
 /*  2290 */   710,  712, 2172, 1370, 2191, 2208,  713,  715,  338, 2174,
 /*  2300 */   702, 2176, 2177,  697,  718,  692, 2141, 1367,  698,  716,
 /*  2310 */   721,  719,  584,  583,  582, 2191, 1361, 1359,  722,  574,
 /*  2320 */   139,  578,  104,  305, 1365,  577,  105, 2141, 1383,  698,
 /*  2330 */   576,  581,  374,  373, 1364, 1363,  575,   75, 1379, 1362,
 /*  2340 */  2172, 1252,  736, 2208, 1284, 2173,  330, 2174,  702, 2176,
 /*  2350 */  2177,  697, 1283,  692, 1282,  699, 1281, 1279, 1277, 1276,
 /*  2360 */  1275, 2172, 1310, 2173, 2208,  746, 1270,  343, 2174,  702,
 /*  2370 */  2176, 2177,  697,  699,  692,  306, 1273, 1272, 1271, 1307,
 /*  2380 */  1269, 1268, 1267, 2191, 1305, 1264, 1263, 1260, 1259, 1258,
 /*  2390 */  1257, 1839,  766, 2173, 1837, 2141,  770,  698,  768,  772,
 /*  2400 */  1835, 2191,  776,  699,  774,  767, 1832,  771,  778,  780,
 /*  2410 */  1814,  775,  782, 2141,  779,  698, 1199, 1791,  309,  786,
 /*  2420 */  1766, 1542,  790,  319, 2173,  789, 1766, 1766, 1766, 2172,
 /*  2430 */  1766, 2191, 2208, 1766,  699,  344, 2174,  702, 2176, 2177,
 /*  2440 */   697, 2173,  692, 2141, 1766,  698, 1766, 2172, 1766, 1766,
 /*  2450 */  2208,  699, 1766, 2185, 2174,  702, 2176, 2177,  697, 1766,
 /*  2460 */   692, 1766, 2191, 1766, 1766, 1766, 1766, 1766, 1766, 1766,
 /*  2470 */  1766, 1766, 1766, 1766, 2141, 1766,  698, 2172, 1766, 2191,
 /*  2480 */  2208, 1766, 1766, 2184, 2174,  702, 2176, 2177,  697, 1766,
 /*  2490 */   692, 2141, 2173,  698, 1766, 1766, 1766, 1766, 1766, 1766,
 /*  2500 */  1766, 1766,  699, 1766, 1766, 1766, 1766, 1766, 2172, 1766,
 /*  2510 */  1766, 2208, 1766, 2173, 2183, 2174,  702, 2176, 2177,  697,
 /*  2520 */  1766,  692, 1766,  699, 1766, 2172, 1766, 1766, 2208, 1766,
 /*  2530 */  2191,  359, 2174,  702, 2176, 2177,  697, 1766,  692, 1766,
 /*  2540 */  2173, 1766, 2141, 1766,  698, 1766, 1766, 1766, 1766, 1766,
 /*  2550 */   699, 2191, 1766, 1766, 1766, 1766, 1766, 1766, 1766, 1766,
 /*  2560 */  1766, 1766, 1766, 2141, 1766,  698, 1766, 1766, 1766, 1766,
 /*  2570 */  1766, 1766, 1766, 1766, 1766, 1766, 2172, 1766, 2191, 2208,
 /*  2580 */  1766, 1766,  360, 2174,  702, 2176, 2177,  697, 1766,  692,
 /*  2590 */  2141, 1766,  698, 1766, 1766, 1766, 1766, 2172, 1766, 1766,
 /*  2600 */  2208, 2173, 1766,  356, 2174,  702, 2176, 2177,  697, 1766,
 /*  2610 */   692,  699, 1766, 1766, 1766, 1766, 1766, 1766, 2173, 1766,
 /*  2620 */  1766, 1766, 1766, 1766, 2172, 1766, 1766, 2208,  699, 1766,
 /*  2630 */   361, 2174,  702, 2176, 2177,  697, 1766,  692, 1766, 2191,
 /*  2640 */  1766, 1766, 1766, 1766, 1766, 1766, 1766, 1766, 1766, 1766,
 /*  2650 */  1766, 2141, 1766,  698, 1766, 1766, 2191, 1766, 1766, 1766,
 /*  2660 */  1766, 1766, 1766, 1766, 1766, 1766, 1766, 1766, 2141, 1766,
 /*  2670 */   698, 1766, 1766, 1766, 1766, 1766, 1766, 1766, 1766, 1766,
 /*  2680 */  1766, 1766, 1766, 1766, 1766,  700, 1766, 1766, 2208, 1766,
 /*  2690 */  1766,  335, 2174,  702, 2176, 2177,  697, 1766,  692, 1766,
 /*  2700 */  1766, 1766, 2172, 1766, 1766, 2208, 1766, 1766,  334, 2174,
 /*  2710 */   702, 2176, 2177,  697, 1766,  692,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   340,  359,  456,  445,  446,  459,  339,  409,  341,  367,
 /*    10 */   350,  413,   12,   13,   14,  379,  378,    3,  366,  340,
 /*    20 */    20,  475,   22,    8,    9,  479,  480,   12,   13,   14,
 /*    30 */    15,   16,  380,   33,   20,   35,  398,  399,  378,    8,
 /*    40 */     9,  349,  390,   12,   13,   14,   15,   16,  370,  409,
 /*    50 */   390,   20,  392,   20,  456,  344,  378,  459,  347,  348,
 /*    60 */   340,  345,   62,  385,  386,  349,  378,  351,   68,  390,
 /*    70 */   350,  393,  474,  475,  386,   75,  377,  479,  480,  427,
 /*    80 */   428,  374,  456,   68,  424,  459,  394,  427,  389,  437,
 /*    90 */   430,  431,  432,  433,  434,  435,  456,  437,  378,  459,
 /*   100 */   100,  475,  442,  103,  444,  479,  480,  345,  448,  449,
 /*   110 */   390,  349,  392,  351,  474,  475,   12,   13,  104,  479,
 /*   120 */   480,  461,  349,  350,   20,  340,   22,  112,  421,  469,
 /*   130 */    12,   13,   14,   15,   16,  349,   20,   33,   62,   35,
 /*   140 */   140,  141,  369,  392,  424,  349,  350,  427,   35,  376,
 /*   150 */   430,  431,  432,  433,  434,  435,    0,  437,  407,  408,
 /*   160 */   440,   20,  442,  443,  444,  369,   62,  349,  448,  449,
 /*   170 */   170,  171,   68,  140,  141,  390,  176,  177,  102,   75,
 /*   180 */     0,  105,  349,  350,  169,    0,  172,  401,   75,  403,
 /*   190 */   190,   21,  192,   20,   24,   25,   26,   27,   28,   29,
 /*   200 */    30,   31,   32,  172,  100,  349,   21,  103,  340,   24,
 /*   210 */    25,   26,   27,   28,   29,   30,   31,   32,  350,  401,
 /*   220 */   352,  403,  222,  223,    0,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   240 */   240,  241,  242,   20,  140,  141,  378,   67,   24,   25,
 /*   250 */    26,   27,   28,   29,   30,   31,   32,  401,  390,  403,
 /*   260 */   392,  246,  247,  248,  249,  250,  251,  252,  253,  254,
 /*   270 */   255,  256,   67,  340,  170,  171,  103,  349,  350,    4,
 /*   280 */   176,  177,   39,  350,  451,  452,  453,  454,  172,  456,
 /*   290 */   457,   20,  424,   22,  190,  427,  192,  369,  430,  431,
 /*   300 */   432,  433,  434,  435,  376,  437,   35,   14,  349,  350,
 /*   310 */   442,  378,  444,   20,    8,    9,  448,  449,   12,   13,
 /*   320 */    14,   15,   16,  390,   53,  392,  222,  223,  369,  225,
 /*   330 */   226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
 /*   340 */   236,  237,  238,  239,  240,  241,  242,  243,   12,   13,
 /*   350 */    20,  340,   22,   12,   13,    3,   20,  424,   22,  429,
 /*   360 */   427,  350,    0,  430,  431,  432,  433,  434,  435,   33,
 /*   370 */   437,   35,  216,  378,  378,  442,   35,  444,  103,  350,
 /*   380 */   385,  448,  449,   53,  392,  455,    8,    9,  393,  378,
 /*   390 */    12,   13,   14,   15,   16,  399,  404,  100,   62,  407,
 /*   400 */   408,  390,  469,  392,   68,  344,   44,  378,  347,  348,
 /*   410 */   104,   75,  115,  116,  117,  118,  119,  120,  121,  122,
 /*   420 */   123,  124,   44,  126,  127,  128,  129,  130,  131,  132,
 /*   430 */    20,   14,  259,   20,  356,  424,  100,   20,  427,  103,
 /*   440 */   356,  430,  431,  432,  433,  434,  435,  436,  437,  438,
 /*   450 */   439,  373,   12,   13,   14,  358,  175,    2,   33,  381,
 /*   460 */    20,  432,   22,    8,    9,  381,   20,   12,   13,   14,
 /*   470 */    15,   16,  375,   33,   49,   35,  140,  141,   20,  349,
 /*   480 */   350,  384,   57,   58,   59,   60,  350,   62,   62,  370,
 /*   490 */   133,  134,  135,  136,  137,  138,  139,  378,  340,  369,
 /*   500 */     4,  258,   62,   20,  222,  386,  170,  171,  350,  243,
 /*   510 */   352,  245,  176,  177,  350,   75,    8,    9,  349,  350,
 /*   520 */    12,   13,   14,   15,   16,   20,  190,  102,  192,  103,
 /*   530 */   105,  105,  396,  192,  259,   84,  378,   20,  369,   43,
 /*   540 */   100,   45,   46,  103,  340,  264,  265,  266,  390,  103,
 /*   550 */   392,  269,  270,  271,  272,  273,  274,  275,  222,  223,
 /*   560 */   396,  225,  226,  227,  228,  229,  230,  231,  232,  233,
 /*   570 */   234,  235,  236,  237,  238,  239,  240,  241,  242,  103,
 /*   580 */   140,  141,  424,  170,  171,  427,  103,  170,  430,  431,
 /*   590 */   432,  433,  434,  435,  390,  437,  145,  146,  173,  174,
 /*   600 */   442,   49,  444,  178,   67,  180,  448,  449,  340,   57,
 /*   610 */   170,  171,   60,   61,  349,  350,  176,  177,  350,  168,
 /*   620 */   352,  349,  350,  198,  114,  366,  103,  103,  134,  135,
 /*   630 */   190,  279,  192,  139,  369,   70,   71,   72,  441,  380,
 /*   640 */   443,  369,   77,   78,   79,    0,  378,  340,   83,  390,
 /*   650 */   349,  350,   35,   88,   89,   90,   91,    0,  390,   94,
 /*   660 */   392,  409,  222,  223,   20,  225,  226,  227,  228,  229,
 /*   670 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   680 */   240,  241,  242,   12,   13,  259,  427,  349,  350,  172,
 /*   690 */   182,   20,  424,   22,   49,  427,  437,  390,  430,  431,
 /*   700 */   432,  433,  434,  435,   33,  437,   35,  369,  456,  340,
 /*   710 */   442,  459,  444,  189,  370,  191,  448,  449,    0,  350,
 /*   720 */   388,    4,  378,  391,  392,  429,  474,  475,  349,  350,
 /*   730 */   386,  479,  480,   62,   14,  259,   19,  391,  392,  340,
 /*   740 */    20,  185,  259,  349,  350,  221,   75,  378,  369,  350,
 /*   750 */    33,  455,   21,  452,  453,  454,  243,  456,  457,  390,
 /*   760 */   459,  392,  370,  369,  429,   34,   49,   36,  212,  213,
 /*   770 */   378,  100,   75,   56,  103,  474,  475,  378,  386,   62,
 /*   780 */   479,  480,  259,  259,  140,  141,   75,   12,   13,  390,
 /*   790 */   455,  392,  284,  424,   22,   20,  427,   22,  134,  430,
 /*   800 */   431,  432,  433,  434,  435,  169,  437,   35,   33,  192,
 /*   810 */    35,  140,  141,  444,  349,  350,  159,  448,  449,  102,
 /*   820 */   176,  177,  105,  424,    0,  168,  427,  114,  378,  430,
 /*   830 */   431,  432,  433,  434,  435,  385,  437,   62,  340,  340,
 /*   840 */    14,  170,  171,  393,  349,  350,   20,  176,  177,  350,
 /*   850 */    75,  133,  134,  135,  136,  137,  138,  139,   22,  378,
 /*   860 */   441,  190,  443,  192,  369,   44,  385,  203,  204,  470,
 /*   870 */   471,   35,  100,    2,  393,  100,  379,  378,  103,    8,
 /*   880 */     9,  379,  246,   12,   13,   14,   15,   16,  390,  390,
 /*   890 */   170,  392,  256,  222,  223,  379,  225,  226,  227,  228,
 /*   900 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*   910 */   239,  240,  241,  242,  340,  140,  141,  452,  453,  454,
 /*   920 */   337,  456,  457,  424,  340,  104,  427,  340,  340,  430,
 /*   930 */   431,  432,  433,  434,  435,   18,  437,   20,   14,   15,
 /*   940 */    16,  378,  414,  340,   27,  170,  171,   30,  385,  340,
 /*   950 */    33,  176,  177,  350,  378,  352,  393,  133,  134,  135,
 /*   960 */   136,  137,  138,  139,  390,  190,   49,  192,   51,  393,
 /*   970 */   471,  349,  350,   56,  390,   22,   22,  390,  390,    8,
 /*   980 */     9,  378,  340,   12,   13,   14,   15,   16,   35,   35,
 /*   990 */    20,  369,  409,  390,  340,  392,  413,  222,  223,  390,
 /*  1000 */   225,  226,  227,  228,  229,  230,  231,  232,  233,  234,
 /*  1010 */   235,  236,  237,  238,  239,  240,  241,  242,    0,  102,
 /*  1020 */    20,  349,  350,  349,  350,  363,  364,  424,   75,  379,
 /*  1030 */   427,  114,  390,  430,  431,  432,  433,  434,  435,  456,
 /*  1040 */   437,  369,  459,  340,  390,  442,  133,  444,   54,   55,
 /*  1050 */   137,  448,  449,  100,  100,  354,  355,  474,  475,  354,
 /*  1060 */   355,  144,  479,  480,  147,  148,  149,  150,  151,  152,
 /*  1070 */   153,  154,  155,  156,  157,  158,  159,  160,  161,  162,
 /*  1080 */   163,   44,  165,  166,  167,  363,  364,  340,   70,   71,
 /*  1090 */    72,   73,   74,  390,   76,   77,   78,   79,   80,   81,
 /*  1100 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  1110 */    92,   93,   94,   95,   96,   18,  349,  350,  409,  340,
 /*  1120 */    23,  340,  340,   12,   13,  379,  452,  453,  454,  340,
 /*  1130 */   456,  457,   37,   22,   37,   38,  369,  390,   41,  350,
 /*  1140 */   379,  352,  172,  190,   33,  192,   35,    8,    9,   52,
 /*  1150 */     4,   12,   13,   14,   15,   16,  350,  340,  349,  350,
 /*  1160 */    63,   64,   65,   66,   42,  456,   44,  378,  459,  390,
 /*  1170 */   170,  390,  390,   62,   44,  222,  223,  340,  369,  390,
 /*  1180 */   340,  392,   62,  474,  475,  366,   75,  350,  479,  480,
 /*  1190 */     8,    9,    1,    2,   12,   13,   14,   15,   16,  380,
 /*  1200 */   103,  106,  396,  108,  109,  114,  111,  390,  358,  390,
 /*  1210 */    68,  100,  409,  424,  440,  378,  427,  443,  367,  430,
 /*  1220 */   431,  432,  433,  434,  435,  105,  437,  390,  133,  392,
 /*  1230 */   390,  442,  137,  444,  384,  340,   13,  448,  449,  142,
 /*  1240 */    42,  387,   44,  104,  390,  350,  427,  352,  387,  387,
 /*  1250 */   371,  390,  390,  374,  365,  164,  437,  368,   35,  456,
 /*  1260 */   107,  424,  459,  110,  427,  257,  258,  430,  431,  432,
 /*  1270 */   433,  434,  435,  378,  437,   45,   46,  474,  475,  182,
 /*  1280 */   183,  184,  479,  480,  187,  390,  340,  392,  107,  341,
 /*  1290 */    13,  110,   48,  349,  350,  104,  350,  200,  201,  107,
 /*  1300 */   400,  190,  110,  192,  107,  140,  141,  110,  211,    0,
 /*  1310 */   473,  214,   35,  369,  217,  218,  219,  220,  221,  424,
 /*  1320 */   283,  206,  427,  208,  378,  430,  431,  432,  433,  434,
 /*  1330 */   435,   22,  437,  222,  223,    0,  390,  442,  392,  444,
 /*  1340 */     0,   44,  456,  448,  449,  459,  235,  236,  237,  238,
 /*  1350 */   239,  240,  241,  340,  172,  135,  259,   22,   44,  139,
 /*  1360 */   474,  475,   22,  350,  222,  479,  480,  483,   44,   44,
 /*  1370 */   424,   44,   44,  427,   44,   44,  430,  431,  432,  433,
 /*  1380 */   434,  435,  472,  437,  349,  350,  340,  353,  442,  103,
 /*  1390 */   444,  378,  349,  350,  448,  449,  350,  349,  350,  113,
 /*  1400 */    44,  104,   47,  390,  369,  392,  260,   44,   44,    1,
 /*  1410 */     2,  281,  369,  340,   44,  466,  172,  369,  104,  199,
 /*  1420 */    35,    0,  202,  350,  378,  205,   44,  207,  104,  104,
 /*  1430 */    13,  104,  104,   44,  104,  104,  390,  424,  392,  378,
 /*  1440 */   427,  366,   44,  430,  431,  432,  433,  434,  435,  340,
 /*  1450 */   437,  378,   35,  366,   44,  442,   44,  444,  103,  350,
 /*  1460 */   104,  448,  449,  390,   44,  392,  353,  104,  104,   44,
 /*  1470 */   424,   50,   35,  427,  104,  340,  430,  431,  432,  433,
 /*  1480 */   434,  435,  400,  437,  348,  350,  104,  378,  442,   13,
 /*  1490 */   444,  350,  389,  104,  448,  449,  400,  424,  458,  390,
 /*  1500 */   427,  392,  104,  430,  431,  432,  433,  434,  435,  476,
 /*  1510 */   437,   35,   75,  378,  104,  450,  104,  444,  460,  261,
 /*  1520 */   426,  448,  449,   49,  104,  390,  425,  392,   20,  104,
 /*  1530 */   418,  205,  358,  424,  418,  358,  427,  423,  188,  430,
 /*  1540 */   431,  432,  433,  434,  435,  411,  437,   42,  397,   20,
 /*  1550 */   400,  397,  169,  444,  340,  395,   20,  448,  449,  424,
 /*  1560 */   349,  349,  427,  397,  350,  430,  431,  432,  433,  434,
 /*  1570 */   435,  395,  437,  395,  101,  362,   99,  192,  361,   98,
 /*  1580 */   340,  349,  360,  349,  349,  349,   20,  342,   48,  346,
 /*  1590 */   350,  342,  378,  346,   20,  358,  392,  418,   20,  358,
 /*  1600 */    20,  351,  342,  410,  390,  378,  392,  351,  349,  358,
 /*  1610 */   358,  358,  385,  358,  390,  358,  481,  482,  378,  349,
 /*  1620 */   393,  390,  342,  383,  378,  209,  378,  422,  390,  103,
 /*  1630 */   390,  196,  392,  195,  418,  420,  417,  356,  424,  378,
 /*  1640 */   378,  427,  340,  378,  430,  431,  432,  433,  434,  435,
 /*  1650 */   378,  437,  350,  378,  378,  416,  378,  378,  444,  340,
 /*  1660 */   378,  392,  356,  449,  424,  194,  349,  427,  400,  350,
 /*  1670 */   430,  431,  432,  433,  434,  435,  267,  437,  340,  415,
 /*  1680 */   378,  390,  268,  456,  400,  383,  459,  276,  350,  390,
 /*  1690 */   465,  465,  390,  405,  392,  405,  468,  378,  390,  181,
 /*  1700 */   390,  474,  475,  285,  278,  277,  479,  480,  262,  390,
 /*  1710 */   258,  392,  282,  426,  280,  350,  378,  484,   20,  465,
 /*  1720 */   478,  383,  429,  349,  351,  356,  424,  464,  390,  427,
 /*  1730 */   392,  356,  430,  431,  432,  433,  434,  435,  467,  437,
 /*  1740 */    20,  405,  403,  424,  477,  462,  427,  390,  463,  430,
 /*  1750 */   431,  432,  433,  434,  435,  174,  437,  390,  390,  405,
 /*  1760 */   402,  390,  424,  356,  340,  427,  390,  390,  430,  431,
 /*  1770 */   432,  433,  434,  435,  350,  437,  374,  350,  356,  103,
 /*  1780 */   447,  340,  103,  382,  390,  349,   36,  368,  356,  338,
 /*  1790 */   343,  350,  342,  412,  406,  372,  406,  419,    0,  357,
 /*  1800 */   340,  482,  378,  372,    0,  372,    0,   42,    0,   35,
 /*  1810 */   350,  215,   35,   35,  390,   35,  392,  215,    0,  378,
 /*  1820 */    35,   35,  215,    0,  383,  215,    0,   35,    0,   22,
 /*  1830 */     0,  390,   35,  392,    0,  210,  198,    0,  378,  198,
 /*  1840 */   192,  199,  190,  383,    0,    0,    0,  186,  424,  185,
 /*  1850 */   390,  427,  392,    0,  430,  431,  432,  433,  434,  435,
 /*  1860 */     0,  437,   47,  439,    0,  424,   42,    1,  427,    0,
 /*  1870 */     0,  430,  431,  432,  433,  434,  435,    0,  437,    0,
 /*  1880 */     0,    0,    0,    0,  424,   19,    0,  427,    0,  159,
 /*  1890 */   430,  431,  432,  433,  434,  435,   35,  437,  340,   33,
 /*  1900 */     0,  159,    0,    0,    0,    0,    0,    0,  350,    0,
 /*  1910 */     0,    0,    0,    0,    0,   49,   42,    0,    0,    0,
 /*  1920 */     0,    0,    0,   57,   58,   59,   60,    0,   62,    0,
 /*  1930 */     0,  340,    0,    0,    0,    0,  378,   22,  143,    0,
 /*  1940 */     0,  350,   48,   48,    0,   22,   22,   62,  390,    0,
 /*  1950 */   392,   62,    0,   62,    0,    0,    0,   49,    0,    0,
 /*  1960 */    35,   35,    0,    0,  340,  181,   35,   39,  102,  378,
 /*  1970 */     0,  105,    0,    0,  350,   39,   35,   35,    0,   14,
 /*  1980 */     0,  390,  424,  392,    0,  427,   39,   49,  430,  431,
 /*  1990 */   432,  433,  434,  435,   49,  437,    0,   44,   47,   42,
 /*  2000 */   340,    0,  378,   39,  138,   39,   39,   47,   47,   40,
 /*  2010 */   350,   35,   69,   39,  390,  424,  392,   49,  427,    0,
 /*  2020 */    35,  430,  431,  432,  433,  434,  435,   39,  437,    0,
 /*  2030 */    49,   49,   35,  340,   39,    0,   49,   35,  378,  173,
 /*  2040 */     0,    0,   39,  350,  178,    0,    0,    0,  424,    0,
 /*  2050 */   390,  427,  392,   35,  430,  431,  432,  433,  434,  435,
 /*  2060 */   112,  437,  340,    0,  198,   22,   35,   35,   35,   35,
 /*  2070 */    44,  378,  350,   35,   35,    0,   22,   35,   22,   35,
 /*  2080 */    44,  110,    0,  390,  424,  392,   35,  427,   22,    0,
 /*  2090 */   430,  431,  432,  433,  434,  435,   35,  437,   22,   51,
 /*  2100 */   378,   22,   35,    0,   35,    0,   35,    0,   20,   35,
 /*  2110 */   104,  103,  390,   35,  392,   35,    0,  424,  172,  103,
 /*  2120 */   427,   35,  340,  430,  431,  432,  433,  434,  435,    0,
 /*  2130 */   437,   22,  350,   22,    0,    0,    3,   44,  263,   48,
 /*  2140 */   103,  340,   48,   44,   44,   47,  424,  197,   44,  427,
 /*  2150 */    44,  350,  430,  431,  432,  433,  434,  435,  172,  437,
 /*  2160 */   378,  104,  172,  174,  104,  103,  101,   99,  193,   47,
 /*  2170 */   179,    3,  390,  103,  392,   44,  104,  104,   35,  378,
 /*  2180 */   103,   35,   35,   35,  103,   35,  103,   47,   35,  340,
 /*  2190 */     0,  390,   47,  392,  104,   44,  104,    0,    0,  350,
 /*  2200 */   104,  104,    0,   39,   47,  103,  424,    0,  340,  427,
 /*  2210 */    39,  103,  430,  431,  432,  433,  434,  435,  350,  437,
 /*  2220 */    44,  104,  104,  103,  103,  424,  103,  378,  427,  103,
 /*  2230 */   175,  430,  431,  432,  433,  434,  435,  173,  437,  390,
 /*  2240 */   263,  392,    0,  113,  244,  101,  378,    2,   47,   22,
 /*  2250 */   257,   47,  222,  104,   22,  263,  340,  101,  390,  104,
 /*  2260 */   392,  103,  103,  103,   47,  104,  350,  104,  103,  103,
 /*  2270 */   103,   35,   35,  424,  224,  103,  427,  340,   35,  430,
 /*  2280 */   431,  432,  433,  434,  435,  104,  437,  350,  114,  104,
 /*  2290 */   103,   35,  424,  104,  378,  427,  103,   35,  430,  431,
 /*  2300 */   432,  433,  434,  435,   35,  437,  390,  104,  392,  103,
 /*  2310 */    35,  103,   70,   71,   72,  378,  104,  104,  103,   77,
 /*  2320 */    78,   79,  103,   44,  125,   83,  103,  390,   35,  392,
 /*  2330 */    88,   89,   90,   91,  125,  125,   94,  103,   22,  125,
 /*  2340 */   424,   69,   68,  427,   35,  340,  430,  431,  432,  433,
 /*  2350 */   434,  435,   35,  437,   35,  350,   35,   35,   35,   35,
 /*  2360 */    35,  424,   75,  340,  427,   97,   22,  430,  431,  432,
 /*  2370 */   433,  434,  435,  350,  437,   44,   35,   35,   35,   75,
 /*  2380 */    35,   35,   35,  378,   35,   35,   35,   35,   35,   22,
 /*  2390 */    35,    0,   35,  340,    0,  390,   35,  392,   39,   39,
 /*  2400 */     0,  378,   39,  350,   35,   49,    0,   49,   35,   39,
 /*  2410 */     0,   49,   35,  390,   49,  392,   35,    0,   22,   21,
 /*  2420 */   485,   22,   20,   22,  340,   21,  485,  485,  485,  424,
 /*  2430 */   485,  378,  427,  485,  350,  430,  431,  432,  433,  434,
 /*  2440 */   435,  340,  437,  390,  485,  392,  485,  424,  485,  485,
 /*  2450 */   427,  350,  485,  430,  431,  432,  433,  434,  435,  485,
 /*  2460 */   437,  485,  378,  485,  485,  485,  485,  485,  485,  485,
 /*  2470 */   485,  485,  485,  485,  390,  485,  392,  424,  485,  378,
 /*  2480 */   427,  485,  485,  430,  431,  432,  433,  434,  435,  485,
 /*  2490 */   437,  390,  340,  392,  485,  485,  485,  485,  485,  485,
 /*  2500 */   485,  485,  350,  485,  485,  485,  485,  485,  424,  485,
 /*  2510 */   485,  427,  485,  340,  430,  431,  432,  433,  434,  435,
 /*  2520 */   485,  437,  485,  350,  485,  424,  485,  485,  427,  485,
 /*  2530 */   378,  430,  431,  432,  433,  434,  435,  485,  437,  485,
 /*  2540 */   340,  485,  390,  485,  392,  485,  485,  485,  485,  485,
 /*  2550 */   350,  378,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2560 */   485,  485,  485,  390,  485,  392,  485,  485,  485,  485,
 /*  2570 */   485,  485,  485,  485,  485,  485,  424,  485,  378,  427,
 /*  2580 */   485,  485,  430,  431,  432,  433,  434,  435,  485,  437,
 /*  2590 */   390,  485,  392,  485,  485,  485,  485,  424,  485,  485,
 /*  2600 */   427,  340,  485,  430,  431,  432,  433,  434,  435,  485,
 /*  2610 */   437,  350,  485,  485,  485,  485,  485,  485,  340,  485,
 /*  2620 */   485,  485,  485,  485,  424,  485,  485,  427,  350,  485,
 /*  2630 */   430,  431,  432,  433,  434,  435,  485,  437,  485,  378,
 /*  2640 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2650 */   485,  390,  485,  392,  485,  485,  378,  485,  485,  485,
 /*  2660 */   485,  485,  485,  485,  485,  485,  485,  485,  390,  485,
 /*  2670 */   392,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2680 */   485,  485,  485,  485,  485,  424,  485,  485,  427,  485,
 /*  2690 */   485,  430,  431,  432,  433,  434,  435,  485,  437,  485,
 /*  2700 */   485,  485,  424,  485,  485,  427,  485,  485,  430,  431,
 /*  2710 */   432,  433,  434,  435,  485,  437,  485,  485,  485,  485,
 /*  2720 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2730 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2740 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2750 */   485,  485,  485,  485,  485,  485,  485,  485,  485,  485,
 /*  2760 */   485,  485,  485,  337,  337,  337,  337,  337,  337,  337,
 /*  2770 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2780 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2790 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2800 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2810 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2820 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2830 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2840 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2850 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2860 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2870 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2880 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2890 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2900 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2910 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2920 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2930 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2940 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2950 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2960 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2970 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2980 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  2990 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3000 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3010 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3020 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3030 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3040 */   337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
 /*  3050 */   337,  337,  337,
};
#define YY_SHIFT_COUNT    (791)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2417)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1097,    0,  104,    0,  336,  336,  336,  336,  336,  336,
 /*    10 */   336,  336,  336,  336,  336,  336,  440,  671,  671,  775,
 /*    20 */   671,  671,  671,  671,  671,  671,  671,  671,  671,  671,
 /*    30 */   671,  671,  671,  671,  671,  671,  671,  671,  671,  671,
 /*    40 */   671,  671,  671,  671,  671,  671,  671,  671,  671,  671,
 /*    50 */   671,  173,  483,  524,  446,  426,  476,  523,  476,  446,
 /*    60 */   446, 1111,  476, 1111, 1111,  275,  476,  141,  644,  223,
 /*    70 */   223,  644,  496,  496,  413,   33,  293,  293,  223,  223,
 /*    80 */   223,  223,  223,  223,  223,  410,  223,  223,  205,  141,
 /*    90 */   223,  223,  458,  223,  141,  223,  410,  223,  410,  141,
 /*   100 */   223,  223,  141,  223,  141,  141,  141,  223,  537,  917,
 /*   110 */    15,   15,  565,  170,  953,  953,  953,  953,  953,  953,
 /*   120 */   953,  953,  953,  953,  953,  953,  953,  953,  953,  953,
 /*   130 */   953,  953,  953, 1095,   14,  413,   33,  994,  994,  113,
 /*   140 */   116,  116,  116,  180,  266,  266,  113,  505,  505,  505,
 /*   150 */   205,  510,  513,  141,  697,  141,  697,  697,  713,  711,
 /*   160 */   297,  297,  297,  297,  297,  297,  297,  297, 1866, 2242,
 /*   170 */   185,   31,  508,  282,  271,  281,  341,  341,  417,  720,
 /*   180 */   330,  517, 1230,  826,  913,  970, 1008,  243,  352, 1008,
 /*   190 */  1122, 1146, 1000, 1258, 1474, 1508, 1326,  205, 1508,  205,
 /*   200 */  1350, 1505, 1529, 1505, 1383, 1536, 1536, 1505, 1383, 1383,
 /*   210 */  1473, 1477, 1536, 1481, 1536, 1536, 1536, 1566, 1540, 1566,
 /*   220 */  1540, 1508,  205, 1574,  205, 1578, 1580,  205, 1578,  205,
 /*   230 */   205,  205, 1536,  205, 1566,  141,  141,  141,  141,  141,
 /*   240 */   141,  141,  141,  141,  141,  141, 1536, 1566,  697,  697,
 /*   250 */   697, 1416, 1526, 1508,  537, 1435, 1438, 1574,  537, 1471,
 /*   260 */  1536, 1529, 1529,  697, 1414, 1409,  697, 1414, 1409,  697,
 /*   270 */   697,  141, 1411, 1518, 1414, 1426, 1428, 1446, 1258, 1418,
 /*   280 */  1430, 1434, 1452,  505, 1698, 1536, 1578,  537,  537, 1720,
 /*   290 */  1409,  697,  697,  697,  697,  697, 1409,  697, 1581,  537,
 /*   300 */   713,  537,  505, 1676, 1679,  697,  711, 1536,  537, 1750,
 /*   310 */  1566, 2716, 2716, 2716, 2716, 2716, 2716, 2716, 2716, 2716,
 /*   320 */  1018,  425,  224,  717,  306,  378, 1139,  718,  455,  871,
 /*   330 */  1182,  824,  971,  971,  971,  971,  971,  971,  971,  971,
 /*   340 */   971,  357, 1220,  118,  118,  451,  552,  556,  657,   76,
 /*   350 */   772,  954,  731,  664,  494,  494,  924, 1191,  636,  924,
 /*   360 */   924,  924,  645,  156,  821,  836, 1198, 1091,  362, 1153,
 /*   370 */  1181, 1192, 1197, 1223, 1277, 1309, 1335, 1340, 1115, 1297,
 /*   380 */  1314, 1120, 1324, 1325, 1327, 1165, 1130, 1037, 1244, 1328,
 /*   390 */  1330, 1331, 1356, 1363, 1364, 1408, 1370, 1142, 1382, 1355,
 /*   400 */  1389, 1398, 1410, 1412, 1420, 1425, 1286,  617, 1385, 1417,
 /*   410 */  1476, 1437, 1421, 1798, 1804, 1806, 1765, 1808, 1774, 1596,
 /*   420 */  1777, 1778, 1780, 1602, 1818, 1785, 1786, 1607, 1823, 1610,
 /*   430 */  1826, 1792, 1828, 1807, 1830, 1797, 1625, 1834, 1638, 1837,
 /*   440 */  1641, 1642, 1648, 1652, 1844, 1845, 1846, 1661, 1664, 1853,
 /*   450 */  1860, 1815, 1864, 1869, 1870, 1824, 1877, 1879, 1880, 1881,
 /*   460 */  1882, 1883, 1886, 1888, 1730, 1861, 1900, 1742, 1902, 1903,
 /*   470 */  1904, 1905, 1906, 1907, 1909, 1910, 1911, 1912, 1913, 1914,
 /*   480 */  1927, 1929, 1930, 1932, 1874, 1917, 1918, 1919, 1920, 1921,
 /*   490 */  1922, 1915, 1933, 1934, 1935, 1795, 1939, 1940, 1923, 1894,
 /*   500 */  1924, 1895, 1944, 1885, 1925, 1949, 1889, 1952, 1891, 1954,
 /*   510 */  1955, 1926, 1908, 1928, 1956, 1931, 1938, 1936, 1958, 1941,
 /*   520 */  1945, 1947, 1959, 1942, 1962, 1957, 1967, 1953, 1951, 1960,
 /*   530 */  1965, 1961, 1963, 1969, 1964, 1970, 1972, 1973, 1974, 1784,
 /*   540 */  1978, 1980, 1984, 1943, 1996, 2001, 1976, 1968, 1966, 2019,
 /*   550 */  1985, 1981, 1988, 2029, 1997, 1982, 1995, 2035, 2002, 1987,
 /*   560 */  2003, 2040, 2041, 2045, 2046, 2047, 2049, 1948, 1971, 2018,
 /*   570 */  2043, 2063, 2031, 2032, 2033, 2034, 2038, 2039, 2042, 2026,
 /*   580 */  2036, 2044, 2051, 2054, 2061, 2075, 2056, 2082, 2066, 2048,
 /*   590 */  2089, 2076, 2067, 2103, 2069, 2105, 2071, 2107, 2079, 2088,
 /*   600 */  2074, 2078, 2080, 2006, 2008, 2116, 1946, 2016, 1950, 2086,
 /*   610 */  2109, 2129, 1975, 2111, 1986, 1989, 2134, 2135, 1990, 1991,
 /*   620 */  2133, 2093, 1875, 2037, 2057, 2062, 2091, 2065, 2094, 2068,
 /*   630 */  2060, 2099, 2100, 2072, 2070, 2077, 2081, 2073, 2104, 2098,
 /*   640 */  2122, 2083, 2106, 1977, 2090, 2092, 2168, 2131, 1992, 2143,
 /*   650 */  2146, 2147, 2148, 2150, 2153, 2096, 2097, 2140, 1993, 2151,
 /*   660 */  2145, 2190, 2197, 2198, 2202, 2102, 2164, 1951, 2157, 2108,
 /*   670 */  2117, 2118, 2120, 2121, 2055, 2123, 2207, 2171, 2064, 2126,
 /*   680 */  2130, 1951, 2201, 2176, 2144, 2000, 2156, 2245, 2227, 2030,
 /*   690 */  2158, 2149, 2159, 2155, 2160, 2161, 2204, 2165, 2166, 2217,
 /*   700 */  2163, 2232, 2050, 2167, 2174, 2181, 2236, 2237, 2172, 2185,
 /*   710 */  2243, 2187, 2189, 2256, 2193, 2203, 2262, 2206, 2212, 2269,
 /*   720 */  2208, 2213, 2275, 2215, 2199, 2209, 2210, 2214, 2219, 2279,
 /*   730 */  2223, 2293, 2234, 2279, 2279, 2316, 2272, 2274, 2309, 2317,
 /*   740 */  2319, 2321, 2322, 2323, 2324, 2325, 2287, 2268, 2331, 2341,
 /*   750 */  2342, 2343, 2344, 2345, 2346, 2347, 2304, 2026, 2349, 2036,
 /*   760 */  2350, 2351, 2352, 2353, 2367, 2355, 2391, 2357, 2356, 2359,
 /*   770 */  2394, 2361, 2358, 2360, 2400, 2369, 2362, 2363, 2406, 2373,
 /*   780 */  2365, 2370, 2410, 2377, 2381, 2417, 2396, 2398, 2399, 2401,
 /*   790 */  2404, 2402,
};
#define YY_REDUCE_COUNT (319)
#define YY_REDUCE_MIN   (-454)
#define YY_REDUCE_MAX   (2278)
static const short yy_reduce_ofst[] = {
 /*     0 */   583, -340, -280,  -67, -132,  158,  268,  603,  789,  895,
 /*    10 */   946, 1013, 1046,  369, 1073, 1109,   11,  399, 1135, 1214,
 /*    20 */   499, 1240, 1302,  837, 1319, 1338, 1424, 1441, 1460, 1558,
 /*    30 */  1591, 1624, 1660, 1693, 1722, 1782, 1801, 1849, 1868, 1916,
 /*    40 */  1937, 2005, 2023, 2053, 2084, 2101, 2152, 2173, 2200, 2261,
 /*    50 */  2278,  301, 1227, -402, -167, -360,  252,  709,  803,  465,
 /*    60 */   674, -348,  886,  259,  819, -454, -374, -322,   -8, -227,
 /*    70 */   -72, -249, -289,   61, -362,  332, -284, -238, -204,  -41,
 /*    80 */   130,  169,  265,  272,  338, -214,  379,  394,   97,   -5,
 /*    90 */   495,  622,   29,  672,  450,  767, -182,  809, -144,  119,
 /*   100 */   944, 1035,  481, 1043,  344,  563,  392, 1048,   78, -308,
 /*   110 */  -442, -442, -358, -333, -321, -215,  204,  307,  498,  574,
 /*   120 */   584,  587,  588,  609,  642,  654,  703,  747,  779,  781,
 /*   130 */   782,  817,  840, -301,  -70,   -4,  346,  701,  705,  662,
 /*   140 */   -70,  296,  335,   84,  197,  419,  722,  136,  164,  806,
 /*   150 */   850, -293,  774, -312,  854,  576,  861,  862,  879,  889,
 /*   160 */  -364,  497,  502,  516,  650,  746,  761,  650,  528,  851,
 /*   170 */   948,  900,  884,  910, 1034,  949, 1075, 1087, 1061, 1061,
 /*   180 */  1113, 1082, 1136, 1141, 1103, 1096, 1040, 1040, 1033, 1040,
 /*   190 */  1065, 1058, 1061, 1094, 1101, 1112, 1114, 1174, 1116, 1177,
 /*   200 */  1134, 1151, 1150, 1154, 1160, 1211, 1212, 1166, 1176, 1178,
 /*   210 */  1213, 1217, 1232, 1222, 1234, 1235, 1236, 1245, 1243, 1249,
 /*   220 */  1247, 1179, 1237, 1204, 1241, 1250, 1193, 1251, 1256, 1252,
 /*   230 */  1253, 1255, 1259, 1257, 1260, 1246, 1248, 1261, 1262, 1265,
 /*   240 */  1272, 1275, 1276, 1278, 1279, 1282, 1270, 1280, 1224, 1231,
 /*   250 */  1238, 1205, 1215, 1216, 1281, 1219, 1239, 1269, 1306, 1264,
 /*   260 */  1317, 1268, 1284, 1291, 1225, 1288, 1299, 1226, 1290, 1308,
 /*   270 */  1310, 1061, 1228, 1271, 1254, 1263, 1285, 1283, 1287, 1233,
 /*   280 */  1242, 1267, 1040, 1365, 1293, 1374, 1373, 1369, 1375, 1339,
 /*   290 */  1336, 1357, 1367, 1368, 1371, 1376, 1354, 1377, 1358, 1407,
 /*   300 */  1402, 1422, 1427, 1333, 1401, 1394, 1419, 1436, 1432, 1447,
 /*   310 */  1450, 1381, 1378, 1388, 1390, 1423, 1431, 1433, 1442, 1451,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*    10 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*    20 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*    30 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*    40 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*    50 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*    60 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*    70 */  1764, 1764, 1764, 1764, 2045, 1764, 1764, 1764, 1764, 1764,
 /*    80 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1853, 1764,
 /*    90 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   100 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1851, 2038,
 /*   110 */  2263, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   120 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   130 */  1764, 1764, 1764, 1764, 2275, 1764, 1764, 1827, 1827, 1764,
 /*   140 */  2275, 2275, 2275, 1851, 2235, 2235, 1764, 1764, 1764, 1764,
 /*   150 */  1853, 2105, 1764, 1764, 1764, 1764, 1764, 1764, 1973, 1764,
 /*   160 */  1764, 1764, 1764, 1764, 1997, 1764, 1764, 1764, 2097, 1764,
 /*   170 */  1764, 2300, 2356, 1764, 1764, 2303, 1764, 1764, 1764, 1764,
 /*   180 */  1764, 2050, 1764, 1764, 1926, 2290, 2267, 2281, 2340, 2268,
 /*   190 */  2265, 2284, 1764, 2294, 1764, 1764, 2119, 1853, 1764, 1853,
 /*   200 */  2084, 2043, 1764, 2043, 2040, 1764, 1764, 2043, 2040, 2040,
 /*   210 */  1915, 1911, 1764, 1909, 1764, 1764, 1764, 1764, 1811, 1764,
 /*   220 */  1811, 1764, 1853, 1764, 1853, 1764, 1764, 1853, 1764, 1853,
 /*   230 */  1853, 1853, 1764, 1853, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   240 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   250 */  1764, 2117, 2103, 1764, 1851, 2095, 2093, 1764, 1851, 2091,
 /*   260 */  1764, 1764, 1764, 1764, 2311, 2309, 1764, 2311, 2309, 1764,
 /*   270 */  1764, 1764, 2325, 2321, 2311, 2329, 2327, 2296, 2294, 2359,
 /*   280 */  2346, 2342, 2281, 1764, 1764, 1764, 1764, 1851, 1851, 1764,
 /*   290 */  2309, 1764, 1764, 1764, 1764, 1764, 2309, 1764, 1764, 1851,
 /*   300 */  1764, 1851, 1764, 1764, 1942, 1764, 1764, 1764, 1851, 1796,
 /*   310 */  1764, 2086, 2108, 2068, 2068, 1976, 1976, 1976, 1854, 1769,
 /*   320 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   330 */  1764, 1764, 2324, 2323, 2190, 1764, 2239, 2238, 2237, 2228,
 /*   340 */  2189, 1938, 1764, 2188, 2187, 1764, 1764, 1764, 1764, 1764,
 /*   350 */  1764, 1764, 1764, 1764, 2059, 2058, 2181, 1764, 1764, 2182,
 /*   360 */  2180, 2179, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   370 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   380 */  1764, 1764, 1764, 1764, 1764, 1764, 2343, 2347, 1764, 1764,
 /*   390 */  1764, 1764, 1764, 1764, 1764, 2264, 1764, 1764, 1764, 2163,
 /*   400 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   410 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   420 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   430 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   440 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   450 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   460 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   470 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   480 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   490 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   500 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   510 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   520 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1801, 2168, 1764,
 /*   530 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   540 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   550 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   560 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   570 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1892,
 /*   580 */  1891, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   590 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   600 */  1764, 1764, 1764, 2172, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   610 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   620 */  2339, 2297, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   630 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   640 */  2163, 1764, 2322, 1764, 1764, 2337, 1764, 2341, 1764, 1764,
 /*   650 */  1764, 1764, 1764, 1764, 1764, 2274, 2270, 1764, 1764, 2266,
 /*   660 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 2171, 1764, 1764,
 /*   670 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   680 */  1764, 2162, 1764, 2225, 1764, 1764, 1764, 2259, 1764, 1764,
 /*   690 */  2210, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   700 */  2172, 1764, 2175, 1764, 1764, 1764, 1764, 1764, 1970, 1764,
 /*   710 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   720 */  1764, 1764, 1764, 1764, 1954, 1952, 1951, 1950, 1764, 1983,
 /*   730 */  1764, 1764, 1764, 1979, 1978, 1764, 1764, 1764, 1764, 1764,
 /*   740 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1872, 1764,
 /*   750 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1864, 1764, 1863,
 /*   760 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   770 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   780 */  1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764, 1764,
 /*   790 */  1764, 1764,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*     UNSAFE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  286,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*   GEOMETRY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*      PAUSE => nothing */
    0,  /*     RESUME => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*  UNTREATED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  286,  /*      AFTER => ABORT */
  286,  /*     ATTACH => ABORT */
  286,  /*     BEFORE => ABORT */
  286,  /*      BEGIN => ABORT */
  286,  /*     BITAND => ABORT */
  286,  /*     BITNOT => ABORT */
  286,  /*      BITOR => ABORT */
  286,  /*     BLOCKS => ABORT */
  286,  /*     CHANGE => ABORT */
  286,  /*      COMMA => ABORT */
  286,  /*     CONCAT => ABORT */
  286,  /*   CONFLICT => ABORT */
  286,  /*       COPY => ABORT */
  286,  /*   DEFERRED => ABORT */
  286,  /* DELIMITERS => ABORT */
  286,  /*     DETACH => ABORT */
  286,  /*     DIVIDE => ABORT */
  286,  /*        DOT => ABORT */
  286,  /*       EACH => ABORT */
  286,  /*       FAIL => ABORT */
  286,  /*       FILE => ABORT */
  286,  /*        FOR => ABORT */
  286,  /*       GLOB => ABORT */
  286,  /*         ID => ABORT */
  286,  /*  IMMEDIATE => ABORT */
  286,  /*     IMPORT => ABORT */
  286,  /*  INITIALLY => ABORT */
  286,  /*    INSTEAD => ABORT */
  286,  /*     ISNULL => ABORT */
  286,  /*        KEY => ABORT */
  286,  /*    MODULES => ABORT */
  286,  /*  NK_BITNOT => ABORT */
  286,  /*    NK_SEMI => ABORT */
  286,  /*    NOTNULL => ABORT */
  286,  /*         OF => ABORT */
  286,  /*       PLUS => ABORT */
  286,  /*  PRIVILEGE => ABORT */
  286,  /*      RAISE => ABORT */
  286,  /*   RESTRICT => ABORT */
  286,  /*        ROW => ABORT */
  286,  /*       SEMI => ABORT */
  286,  /*       STAR => ABORT */
  286,  /*  STATEMENT => ABORT */
  286,  /*     STRICT => ABORT */
  286,  /*     STRING => ABORT */
  286,  /*      TIMES => ABORT */
  286,  /*     VALUES => ABORT */
  286,  /*   VARIABLE => ABORT */
  286,  /*       VIEW => ABORT */
  286,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "UNSAFE",
  /*   56 */ "LOCAL",
  /*   57 */ "QNODE",
  /*   58 */ "BNODE",
  /*   59 */ "SNODE",
  /*   60 */ "MNODE",
  /*   61 */ "VNODE",
  /*   62 */ "DATABASE",
  /*   63 */ "USE",
  /*   64 */ "FLUSH",
  /*   65 */ "TRIM",
  /*   66 */ "COMPACT",
  /*   67 */ "IF",
  /*   68 */ "NOT",
  /*   69 */ "EXISTS",
  /*   70 */ "BUFFER",
  /*   71 */ "CACHEMODEL",
  /*   72 */ "CACHESIZE",
  /*   73 */ "COMP",
  /*   74 */ "DURATION",
  /*   75 */ "NK_VARIABLE",
  /*   76 */ "MAXROWS",
  /*   77 */ "MINROWS",
  /*   78 */ "KEEP",
  /*   79 */ "PAGES",
  /*   80 */ "PAGESIZE",
  /*   81 */ "TSDB_PAGESIZE",
  /*   82 */ "PRECISION",
  /*   83 */ "REPLICA",
  /*   84 */ "VGROUPS",
  /*   85 */ "SINGLE_STABLE",
  /*   86 */ "RETENTIONS",
  /*   87 */ "SCHEMALESS",
  /*   88 */ "WAL_LEVEL",
  /*   89 */ "WAL_FSYNC_PERIOD",
  /*   90 */ "WAL_RETENTION_PERIOD",
  /*   91 */ "WAL_RETENTION_SIZE",
  /*   92 */ "WAL_ROLL_PERIOD",
  /*   93 */ "WAL_SEGMENT_SIZE",
  /*   94 */ "STT_TRIGGER",
  /*   95 */ "TABLE_PREFIX",
  /*   96 */ "TABLE_SUFFIX",
  /*   97 */ "NK_COLON",
  /*   98 */ "MAX_SPEED",
  /*   99 */ "START",
  /*  100 */ "TIMESTAMP",
  /*  101 */ "END",
  /*  102 */ "TABLE",
  /*  103 */ "NK_LP",
  /*  104 */ "NK_RP",
  /*  105 */ "STABLE",
  /*  106 */ "ADD",
  /*  107 */ "COLUMN",
  /*  108 */ "MODIFY",
  /*  109 */ "RENAME",
  /*  110 */ "TAG",
  /*  111 */ "SET",
  /*  112 */ "NK_EQ",
  /*  113 */ "USING",
  /*  114 */ "TAGS",
  /*  115 */ "BOOL",
  /*  116 */ "TINYINT",
  /*  117 */ "SMALLINT",
  /*  118 */ "INT",
  /*  119 */ "INTEGER",
  /*  120 */ "BIGINT",
  /*  121 */ "FLOAT",
  /*  122 */ "DOUBLE",
  /*  123 */ "BINARY",
  /*  124 */ "NCHAR",
  /*  125 */ "UNSIGNED",
  /*  126 */ "JSON",
  /*  127 */ "VARCHAR",
  /*  128 */ "MEDIUMBLOB",
  /*  129 */ "BLOB",
  /*  130 */ "VARBINARY",
  /*  131 */ "GEOMETRY",
  /*  132 */ "DECIMAL",
  /*  133 */ "COMMENT",
  /*  134 */ "MAX_DELAY",
  /*  135 */ "WATERMARK",
  /*  136 */ "ROLLUP",
  /*  137 */ "TTL",
  /*  138 */ "SMA",
  /*  139 */ "DELETE_MARK",
  /*  140 */ "FIRST",
  /*  141 */ "LAST",
  /*  142 */ "SHOW",
  /*  143 */ "PRIVILEGES",
  /*  144 */ "DATABASES",
  /*  145 */ "TABLES",
  /*  146 */ "STABLES",
  /*  147 */ "MNODES",
  /*  148 */ "QNODES",
  /*  149 */ "FUNCTIONS",
  /*  150 */ "INDEXES",
  /*  151 */ "ACCOUNTS",
  /*  152 */ "APPS",
  /*  153 */ "CONNECTIONS",
  /*  154 */ "LICENCES",
  /*  155 */ "GRANTS",
  /*  156 */ "QUERIES",
  /*  157 */ "SCORES",
  /*  158 */ "TOPICS",
  /*  159 */ "VARIABLES",
  /*  160 */ "CLUSTER",
  /*  161 */ "BNODES",
  /*  162 */ "SNODES",
  /*  163 */ "TRANSACTIONS",
  /*  164 */ "DISTRIBUTED",
  /*  165 */ "CONSUMERS",
  /*  166 */ "SUBSCRIPTIONS",
  /*  167 */ "VNODES",
  /*  168 */ "ALIVE",
  /*  169 */ "LIKE",
  /*  170 */ "TBNAME",
  /*  171 */ "QTAGS",
  /*  172 */ "AS",
  /*  173 */ "INDEX",
  /*  174 */ "FUNCTION",
  /*  175 */ "INTERVAL",
  /*  176 */ "COUNT",
  /*  177 */ "LAST_ROW",
  /*  178 */ "TOPIC",
  /*  179 */ "META",
  /*  180 */ "CONSUMER",
  /*  181 */ "GROUP",
  /*  182 */ "DESC",
  /*  183 */ "DESCRIBE",
  /*  184 */ "RESET",
  /*  185 */ "QUERY",
  /*  186 */ "CACHE",
  /*  187 */ "EXPLAIN",
  /*  188 */ "ANALYZE",
  /*  189 */ "VERBOSE",
  /*  190 */ "NK_BOOL",
  /*  191 */ "RATIO",
  /*  192 */ "NK_FLOAT",
  /*  193 */ "OUTPUTTYPE",
  /*  194 */ "AGGREGATE",
  /*  195 */ "BUFSIZE",
  /*  196 */ "LANGUAGE",
  /*  197 */ "REPLACE",
  /*  198 */ "STREAM",
  /*  199 */ "INTO",
  /*  200 */ "PAUSE",
  /*  201 */ "RESUME",
  /*  202 */ "TRIGGER",
  /*  203 */ "AT_ONCE",
  /*  204 */ "WINDOW_CLOSE",
  /*  205 */ "IGNORE",
  /*  206 */ "EXPIRED",
  /*  207 */ "FILL_HISTORY",
  /*  208 */ "UPDATE",
  /*  209 */ "SUBTABLE",
  /*  210 */ "UNTREATED",
  /*  211 */ "KILL",
  /*  212 */ "CONNECTION",
  /*  213 */ "TRANSACTION",
  /*  214 */ "BALANCE",
  /*  215 */ "VGROUP",
  /*  216 */ "LEADER",
  /*  217 */ "MERGE",
  /*  218 */ "REDISTRIBUTE",
  /*  219 */ "SPLIT",
  /*  220 */ "DELETE",
  /*  221 */ "INSERT",
  /*  222 */ "NULL",
  /*  223 */ "NK_QUESTION",
  /*  224 */ "NK_ARROW",
  /*  225 */ "ROWTS",
  /*  226 */ "QSTART",
  /*  227 */ "QEND",
  /*  228 */ "QDURATION",
  /*  229 */ "WSTART",
  /*  230 */ "WEND",
  /*  231 */ "WDURATION",
  /*  232 */ "IROWTS",
  /*  233 */ "ISFILLED",
  /*  234 */ "CAST",
  /*  235 */ "NOW",
  /*  236 */ "TODAY",
  /*  237 */ "TIMEZONE",
  /*  238 */ "CLIENT_VERSION",
  /*  239 */ "SERVER_VERSION",
  /*  240 */ "SERVER_STATUS",
  /*  241 */ "CURRENT_USER",
  /*  242 */ "CASE",
  /*  243 */ "WHEN",
  /*  244 */ "THEN",
  /*  245 */ "ELSE",
  /*  246 */ "BETWEEN",
  /*  247 */ "IS",
  /*  248 */ "NK_LT",
  /*  249 */ "NK_GT",
  /*  250 */ "NK_LE",
  /*  251 */ "NK_GE",
  /*  252 */ "NK_NE",
  /*  253 */ "MATCH",
  /*  254 */ "NMATCH",
  /*  255 */ "CONTAINS",
  /*  256 */ "IN",
  /*  257 */ "JOIN",
  /*  258 */ "INNER",
  /*  259 */ "SELECT",
  /*  260 */ "DISTINCT",
  /*  261 */ "WHERE",
  /*  262 */ "PARTITION",
  /*  263 */ "BY",
  /*  264 */ "SESSION",
  /*  265 */ "STATE_WINDOW",
  /*  266 */ "EVENT_WINDOW",
  /*  267 */ "SLIDING",
  /*  268 */ "FILL",
  /*  269 */ "VALUE",
  /*  270 */ "VALUE_F",
  /*  271 */ "NONE",
  /*  272 */ "PREV",
  /*  273 */ "NULL_F",
  /*  274 */ "LINEAR",
  /*  275 */ "NEXT",
  /*  276 */ "HAVING",
  /*  277 */ "RANGE",
  /*  278 */ "EVERY",
  /*  279 */ "ORDER",
  /*  280 */ "SLIMIT",
  /*  281 */ "SOFFSET",
  /*  282 */ "LIMIT",
  /*  283 */ "OFFSET",
  /*  284 */ "ASC",
  /*  285 */ "NULLS",
  /*  286 */ "ABORT",
  /*  287 */ "AFTER",
  /*  288 */ "ATTACH",
  /*  289 */ "BEFORE",
  /*  290 */ "BEGIN",
  /*  291 */ "BITAND",
  /*  292 */ "BITNOT",
  /*  293 */ "BITOR",
  /*  294 */ "BLOCKS",
  /*  295 */ "CHANGE",
  /*  296 */ "COMMA",
  /*  297 */ "CONCAT",
  /*  298 */ "CONFLICT",
  /*  299 */ "COPY",
  /*  300 */ "DEFERRED",
  /*  301 */ "DELIMITERS",
  /*  302 */ "DETACH",
  /*  303 */ "DIVIDE",
  /*  304 */ "DOT",
  /*  305 */ "EACH",
  /*  306 */ "FAIL",
  /*  307 */ "FILE",
  /*  308 */ "FOR",
  /*  309 */ "GLOB",
  /*  310 */ "ID",
  /*  311 */ "IMMEDIATE",
  /*  312 */ "IMPORT",
  /*  313 */ "INITIALLY",
  /*  314 */ "INSTEAD",
  /*  315 */ "ISNULL",
  /*  316 */ "KEY",
  /*  317 */ "MODULES",
  /*  318 */ "NK_BITNOT",
  /*  319 */ "NK_SEMI",
  /*  320 */ "NOTNULL",
  /*  321 */ "OF",
  /*  322 */ "PLUS",
  /*  323 */ "PRIVILEGE",
  /*  324 */ "RAISE",
  /*  325 */ "RESTRICT",
  /*  326 */ "ROW",
  /*  327 */ "SEMI",
  /*  328 */ "STAR",
  /*  329 */ "STATEMENT",
  /*  330 */ "STRICT",
  /*  331 */ "STRING",
  /*  332 */ "TIMES",
  /*  333 */ "VALUES",
  /*  334 */ "VARIABLE",
  /*  335 */ "VIEW",
  /*  336 */ "WAL",
  /*  337 */ "cmd",
  /*  338 */ "account_options",
  /*  339 */ "alter_account_options",
  /*  340 */ "literal",
  /*  341 */ "alter_account_option",
  /*  342 */ "user_name",
  /*  343 */ "sysinfo_opt",
  /*  344 */ "privileges",
  /*  345 */ "priv_level",
  /*  346 */ "with_opt",
  /*  347 */ "priv_type_list",
  /*  348 */ "priv_type",
  /*  349 */ "db_name",
  /*  350 */ "table_name",
  /*  351 */ "topic_name",
  /*  352 */ "search_condition",
  /*  353 */ "dnode_endpoint",
  /*  354 */ "force_opt",
  /*  355 */ "unsafe_opt",
  /*  356 */ "not_exists_opt",
  /*  357 */ "db_options",
  /*  358 */ "exists_opt",
  /*  359 */ "alter_db_options",
  /*  360 */ "speed_opt",
  /*  361 */ "start_opt",
  /*  362 */ "end_opt",
  /*  363 */ "integer_list",
  /*  364 */ "variable_list",
  /*  365 */ "retention_list",
  /*  366 */ "signed",
  /*  367 */ "alter_db_option",
  /*  368 */ "retention",
  /*  369 */ "full_table_name",
  /*  370 */ "column_def_list",
  /*  371 */ "tags_def_opt",
  /*  372 */ "table_options",
  /*  373 */ "multi_create_clause",
  /*  374 */ "tags_def",
  /*  375 */ "multi_drop_clause",
  /*  376 */ "alter_table_clause",
  /*  377 */ "alter_table_options",
  /*  378 */ "column_name",
  /*  379 */ "type_name",
  /*  380 */ "signed_literal",
  /*  381 */ "create_subtable_clause",
  /*  382 */ "specific_cols_opt",
  /*  383 */ "expression_list",
  /*  384 */ "drop_table_clause",
  /*  385 */ "col_name_list",
  /*  386 */ "column_def",
  /*  387 */ "duration_list",
  /*  388 */ "rollup_func_list",
  /*  389 */ "alter_table_option",
  /*  390 */ "duration_literal",
  /*  391 */ "rollup_func_name",
  /*  392 */ "function_name",
  /*  393 */ "col_name",
  /*  394 */ "db_name_cond_opt",
  /*  395 */ "like_pattern_opt",
  /*  396 */ "table_name_cond",
  /*  397 */ "from_db_opt",
  /*  398 */ "tag_list_opt",
  /*  399 */ "tag_item",
  /*  400 */ "column_alias",
  /*  401 */ "full_index_name",
  /*  402 */ "index_options",
  /*  403 */ "index_name",
  /*  404 */ "func_list",
  /*  405 */ "sliding_opt",
  /*  406 */ "sma_stream_opt",
  /*  407 */ "func",
  /*  408 */ "sma_func_name",
  /*  409 */ "query_or_subquery",
  /*  410 */ "cgroup_name",
  /*  411 */ "analyze_opt",
  /*  412 */ "explain_options",
  /*  413 */ "insert_query",
  /*  414 */ "or_replace_opt",
  /*  415 */ "agg_func_opt",
  /*  416 */ "bufsize_opt",
  /*  417 */ "language_opt",
  /*  418 */ "stream_name",
  /*  419 */ "stream_options",
  /*  420 */ "col_list_opt",
  /*  421 */ "tag_def_or_ref_opt",
  /*  422 */ "subtable_opt",
  /*  423 */ "ignore_opt",
  /*  424 */ "expression",
  /*  425 */ "dnode_list",
  /*  426 */ "where_clause_opt",
  /*  427 */ "literal_func",
  /*  428 */ "literal_list",
  /*  429 */ "table_alias",
  /*  430 */ "expr_or_subquery",
  /*  431 */ "pseudo_column",
  /*  432 */ "column_reference",
  /*  433 */ "function_expression",
  /*  434 */ "case_when_expression",
  /*  435 */ "star_func",
  /*  436 */ "star_func_para_list",
  /*  437 */ "noarg_func",
  /*  438 */ "other_para_list",
  /*  439 */ "star_func_para",
  /*  440 */ "when_then_list",
  /*  441 */ "case_when_else_opt",
  /*  442 */ "common_expression",
  /*  443 */ "when_then_expr",
  /*  444 */ "predicate",
  /*  445 */ "compare_op",
  /*  446 */ "in_op",
  /*  447 */ "in_predicate_value",
  /*  448 */ "boolean_value_expression",
  /*  449 */ "boolean_primary",
  /*  450 */ "from_clause_opt",
  /*  451 */ "table_reference_list",
  /*  452 */ "table_reference",
  /*  453 */ "table_primary",
  /*  454 */ "joined_table",
  /*  455 */ "alias_opt",
  /*  456 */ "subquery",
  /*  457 */ "parenthesized_joined_table",
  /*  458 */ "join_type",
  /*  459 */ "query_specification",
  /*  460 */ "set_quantifier_opt",
  /*  461 */ "select_list",
  /*  462 */ "partition_by_clause_opt",
  /*  463 */ "range_opt",
  /*  464 */ "every_opt",
  /*  465 */ "fill_opt",
  /*  466 */ "twindow_clause_opt",
  /*  467 */ "group_by_clause_opt",
  /*  468 */ "having_clause_opt",
  /*  469 */ "select_item",
  /*  470 */ "partition_list",
  /*  471 */ "partition_item",
  /*  472 */ "fill_mode",
  /*  473 */ "group_by_list",
  /*  474 */ "query_expression",
  /*  475 */ "query_simple",
  /*  476 */ "order_by_clause_opt",
  /*  477 */ "slimit_clause_opt",
  /*  478 */ "limit_clause_opt",
  /*  479 */ "union_query_expression",
  /*  480 */ "query_simple_or_subquery",
  /*  481 */ "sort_specification_list",
  /*  482 */ "sort_specification",
  /*  483 */ "ordering_specification_opt",
  /*  484 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= DROP DNODE NK_INTEGER unsafe_opt",
 /*  51 */ "cmd ::= DROP DNODE dnode_endpoint unsafe_opt",
 /*  52 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  53 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  54 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  55 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  56 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  57 */ "dnode_endpoint ::= NK_STRING",
 /*  58 */ "dnode_endpoint ::= NK_ID",
 /*  59 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  60 */ "force_opt ::=",
 /*  61 */ "force_opt ::= FORCE",
 /*  62 */ "unsafe_opt ::= UNSAFE",
 /*  63 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  64 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  65 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  74 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  75 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  76 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  77 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  78 */ "cmd ::= USE db_name",
 /*  79 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  80 */ "cmd ::= FLUSH DATABASE db_name",
 /*  81 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  82 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  83 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  84 */ "not_exists_opt ::=",
 /*  85 */ "exists_opt ::= IF EXISTS",
 /*  86 */ "exists_opt ::=",
 /*  87 */ "db_options ::=",
 /*  88 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  89 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  90 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  92 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  93 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  94 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  95 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  96 */ "db_options ::= db_options KEEP integer_list",
 /*  97 */ "db_options ::= db_options KEEP variable_list",
 /*  98 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  99 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options PRECISION NK_STRING",
 /* 102 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 103 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 104 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 105 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 106 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 113 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 114 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 115 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 116 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 117 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 118 */ "alter_db_options ::= alter_db_option",
 /* 119 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 120 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 121 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 122 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 124 */ "alter_db_option ::= KEEP integer_list",
 /* 125 */ "alter_db_option ::= KEEP variable_list",
 /* 126 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 127 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 129 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 130 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 132 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 133 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 134 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 135 */ "integer_list ::= NK_INTEGER",
 /* 136 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 137 */ "variable_list ::= NK_VARIABLE",
 /* 138 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 139 */ "retention_list ::= retention",
 /* 140 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 141 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 142 */ "speed_opt ::=",
 /* 143 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 144 */ "start_opt ::=",
 /* 145 */ "start_opt ::= START WITH NK_INTEGER",
 /* 146 */ "start_opt ::= START WITH NK_STRING",
 /* 147 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 148 */ "end_opt ::=",
 /* 149 */ "end_opt ::= END WITH NK_INTEGER",
 /* 150 */ "end_opt ::= END WITH NK_STRING",
 /* 151 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 152 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 153 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 154 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 155 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 156 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 157 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 158 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 159 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 160 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 161 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 162 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 163 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 164 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 165 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 166 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 167 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 168 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 169 */ "multi_create_clause ::= create_subtable_clause",
 /* 170 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 171 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 172 */ "multi_drop_clause ::= drop_table_clause",
 /* 173 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 174 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 175 */ "specific_cols_opt ::=",
 /* 176 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 177 */ "full_table_name ::= table_name",
 /* 178 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 179 */ "column_def_list ::= column_def",
 /* 180 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 181 */ "column_def ::= column_name type_name",
 /* 182 */ "type_name ::= BOOL",
 /* 183 */ "type_name ::= TINYINT",
 /* 184 */ "type_name ::= SMALLINT",
 /* 185 */ "type_name ::= INT",
 /* 186 */ "type_name ::= INTEGER",
 /* 187 */ "type_name ::= BIGINT",
 /* 188 */ "type_name ::= FLOAT",
 /* 189 */ "type_name ::= DOUBLE",
 /* 190 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 191 */ "type_name ::= TIMESTAMP",
 /* 192 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= TINYINT UNSIGNED",
 /* 194 */ "type_name ::= SMALLINT UNSIGNED",
 /* 195 */ "type_name ::= INT UNSIGNED",
 /* 196 */ "type_name ::= BIGINT UNSIGNED",
 /* 197 */ "type_name ::= JSON",
 /* 198 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 199 */ "type_name ::= MEDIUMBLOB",
 /* 200 */ "type_name ::= BLOB",
 /* 201 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 202 */ "type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP",
 /* 203 */ "type_name ::= DECIMAL",
 /* 204 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 205 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 206 */ "tags_def_opt ::=",
 /* 207 */ "tags_def_opt ::= tags_def",
 /* 208 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 209 */ "table_options ::=",
 /* 210 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 211 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 212 */ "table_options ::= table_options WATERMARK duration_list",
 /* 213 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 214 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 215 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 216 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 217 */ "alter_table_options ::= alter_table_option",
 /* 218 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 219 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 220 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 221 */ "duration_list ::= duration_literal",
 /* 222 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 223 */ "rollup_func_list ::= rollup_func_name",
 /* 224 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 225 */ "rollup_func_name ::= function_name",
 /* 226 */ "rollup_func_name ::= FIRST",
 /* 227 */ "rollup_func_name ::= LAST",
 /* 228 */ "col_name_list ::= col_name",
 /* 229 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 230 */ "col_name ::= column_name",
 /* 231 */ "cmd ::= SHOW DNODES",
 /* 232 */ "cmd ::= SHOW USERS",
 /* 233 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 234 */ "cmd ::= SHOW DATABASES",
 /* 235 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 236 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 237 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 238 */ "cmd ::= SHOW MNODES",
 /* 239 */ "cmd ::= SHOW QNODES",
 /* 240 */ "cmd ::= SHOW FUNCTIONS",
 /* 241 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW STREAMS",
 /* 243 */ "cmd ::= SHOW ACCOUNTS",
 /* 244 */ "cmd ::= SHOW APPS",
 /* 245 */ "cmd ::= SHOW CONNECTIONS",
 /* 246 */ "cmd ::= SHOW LICENCES",
 /* 247 */ "cmd ::= SHOW GRANTS",
 /* 248 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 249 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 250 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 251 */ "cmd ::= SHOW QUERIES",
 /* 252 */ "cmd ::= SHOW SCORES",
 /* 253 */ "cmd ::= SHOW TOPICS",
 /* 254 */ "cmd ::= SHOW VARIABLES",
 /* 255 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 256 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 257 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 258 */ "cmd ::= SHOW BNODES",
 /* 259 */ "cmd ::= SHOW SNODES",
 /* 260 */ "cmd ::= SHOW CLUSTER",
 /* 261 */ "cmd ::= SHOW TRANSACTIONS",
 /* 262 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 263 */ "cmd ::= SHOW CONSUMERS",
 /* 264 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 265 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 266 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 267 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 268 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 269 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 270 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 271 */ "db_name_cond_opt ::=",
 /* 272 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 273 */ "like_pattern_opt ::=",
 /* 274 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 275 */ "table_name_cond ::= table_name",
 /* 276 */ "from_db_opt ::=",
 /* 277 */ "from_db_opt ::= FROM db_name",
 /* 278 */ "tag_list_opt ::=",
 /* 279 */ "tag_list_opt ::= tag_item",
 /* 280 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 281 */ "tag_item ::= TBNAME",
 /* 282 */ "tag_item ::= QTAGS",
 /* 283 */ "tag_item ::= column_name",
 /* 284 */ "tag_item ::= column_name column_alias",
 /* 285 */ "tag_item ::= column_name AS column_alias",
 /* 286 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 287 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 288 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 289 */ "full_index_name ::= index_name",
 /* 290 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 291 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 292 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 293 */ "func_list ::= func",
 /* 294 */ "func_list ::= func_list NK_COMMA func",
 /* 295 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 296 */ "sma_func_name ::= function_name",
 /* 297 */ "sma_func_name ::= COUNT",
 /* 298 */ "sma_func_name ::= FIRST",
 /* 299 */ "sma_func_name ::= LAST",
 /* 300 */ "sma_func_name ::= LAST_ROW",
 /* 301 */ "sma_stream_opt ::=",
 /* 302 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 303 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 304 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 305 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 306 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 307 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 308 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 309 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 310 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 311 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 312 */ "cmd ::= DESC full_table_name",
 /* 313 */ "cmd ::= DESCRIBE full_table_name",
 /* 314 */ "cmd ::= RESET QUERY CACHE",
 /* 315 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 316 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 317 */ "analyze_opt ::=",
 /* 318 */ "analyze_opt ::= ANALYZE",
 /* 319 */ "explain_options ::=",
 /* 320 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 321 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 322 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 323 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 324 */ "agg_func_opt ::=",
 /* 325 */ "agg_func_opt ::= AGGREGATE",
 /* 326 */ "bufsize_opt ::=",
 /* 327 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 328 */ "language_opt ::=",
 /* 329 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 330 */ "or_replace_opt ::=",
 /* 331 */ "or_replace_opt ::= OR REPLACE",
 /* 332 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 333 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 334 */ "cmd ::= PAUSE STREAM exists_opt stream_name",
 /* 335 */ "cmd ::= RESUME STREAM exists_opt ignore_opt stream_name",
 /* 336 */ "col_list_opt ::=",
 /* 337 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 338 */ "tag_def_or_ref_opt ::=",
 /* 339 */ "tag_def_or_ref_opt ::= tags_def",
 /* 340 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 341 */ "stream_options ::=",
 /* 342 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 343 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 344 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 345 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 346 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 347 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 348 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 349 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 350 */ "subtable_opt ::=",
 /* 351 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 352 */ "ignore_opt ::=",
 /* 353 */ "ignore_opt ::= IGNORE UNTREATED",
 /* 354 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 355 */ "cmd ::= KILL QUERY NK_STRING",
 /* 356 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 357 */ "cmd ::= BALANCE VGROUP",
 /* 358 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 359 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 360 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 361 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 362 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 363 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 364 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 365 */ "cmd ::= query_or_subquery",
 /* 366 */ "cmd ::= insert_query",
 /* 367 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 368 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 369 */ "literal ::= NK_INTEGER",
 /* 370 */ "literal ::= NK_FLOAT",
 /* 371 */ "literal ::= NK_STRING",
 /* 372 */ "literal ::= NK_BOOL",
 /* 373 */ "literal ::= TIMESTAMP NK_STRING",
 /* 374 */ "literal ::= duration_literal",
 /* 375 */ "literal ::= NULL",
 /* 376 */ "literal ::= NK_QUESTION",
 /* 377 */ "duration_literal ::= NK_VARIABLE",
 /* 378 */ "signed ::= NK_INTEGER",
 /* 379 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 380 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 381 */ "signed ::= NK_FLOAT",
 /* 382 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 383 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 384 */ "signed_literal ::= signed",
 /* 385 */ "signed_literal ::= NK_STRING",
 /* 386 */ "signed_literal ::= NK_BOOL",
 /* 387 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 388 */ "signed_literal ::= duration_literal",
 /* 389 */ "signed_literal ::= NULL",
 /* 390 */ "signed_literal ::= literal_func",
 /* 391 */ "signed_literal ::= NK_QUESTION",
 /* 392 */ "literal_list ::= signed_literal",
 /* 393 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 394 */ "db_name ::= NK_ID",
 /* 395 */ "table_name ::= NK_ID",
 /* 396 */ "column_name ::= NK_ID",
 /* 397 */ "function_name ::= NK_ID",
 /* 398 */ "table_alias ::= NK_ID",
 /* 399 */ "column_alias ::= NK_ID",
 /* 400 */ "user_name ::= NK_ID",
 /* 401 */ "topic_name ::= NK_ID",
 /* 402 */ "stream_name ::= NK_ID",
 /* 403 */ "cgroup_name ::= NK_ID",
 /* 404 */ "index_name ::= NK_ID",
 /* 405 */ "expr_or_subquery ::= expression",
 /* 406 */ "expression ::= literal",
 /* 407 */ "expression ::= pseudo_column",
 /* 408 */ "expression ::= column_reference",
 /* 409 */ "expression ::= function_expression",
 /* 410 */ "expression ::= case_when_expression",
 /* 411 */ "expression ::= NK_LP expression NK_RP",
 /* 412 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 413 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 414 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 415 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 416 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 417 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 418 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 419 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 420 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 421 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 422 */ "expression_list ::= expr_or_subquery",
 /* 423 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 424 */ "column_reference ::= column_name",
 /* 425 */ "column_reference ::= table_name NK_DOT column_name",
 /* 426 */ "pseudo_column ::= ROWTS",
 /* 427 */ "pseudo_column ::= TBNAME",
 /* 428 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 429 */ "pseudo_column ::= QSTART",
 /* 430 */ "pseudo_column ::= QEND",
 /* 431 */ "pseudo_column ::= QDURATION",
 /* 432 */ "pseudo_column ::= WSTART",
 /* 433 */ "pseudo_column ::= WEND",
 /* 434 */ "pseudo_column ::= WDURATION",
 /* 435 */ "pseudo_column ::= IROWTS",
 /* 436 */ "pseudo_column ::= ISFILLED",
 /* 437 */ "pseudo_column ::= QTAGS",
 /* 438 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 439 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 440 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 441 */ "function_expression ::= literal_func",
 /* 442 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 443 */ "literal_func ::= NOW",
 /* 444 */ "noarg_func ::= NOW",
 /* 445 */ "noarg_func ::= TODAY",
 /* 446 */ "noarg_func ::= TIMEZONE",
 /* 447 */ "noarg_func ::= DATABASE",
 /* 448 */ "noarg_func ::= CLIENT_VERSION",
 /* 449 */ "noarg_func ::= SERVER_VERSION",
 /* 450 */ "noarg_func ::= SERVER_STATUS",
 /* 451 */ "noarg_func ::= CURRENT_USER",
 /* 452 */ "noarg_func ::= USER",
 /* 453 */ "star_func ::= COUNT",
 /* 454 */ "star_func ::= FIRST",
 /* 455 */ "star_func ::= LAST",
 /* 456 */ "star_func ::= LAST_ROW",
 /* 457 */ "star_func_para_list ::= NK_STAR",
 /* 458 */ "star_func_para_list ::= other_para_list",
 /* 459 */ "other_para_list ::= star_func_para",
 /* 460 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 461 */ "star_func_para ::= expr_or_subquery",
 /* 462 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 463 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 464 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 465 */ "when_then_list ::= when_then_expr",
 /* 466 */ "when_then_list ::= when_then_list when_then_expr",
 /* 467 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 468 */ "case_when_else_opt ::=",
 /* 469 */ "case_when_else_opt ::= ELSE common_expression",
 /* 470 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 471 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 472 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 473 */ "predicate ::= expr_or_subquery IS NULL",
 /* 474 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 475 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 476 */ "compare_op ::= NK_LT",
 /* 477 */ "compare_op ::= NK_GT",
 /* 478 */ "compare_op ::= NK_LE",
 /* 479 */ "compare_op ::= NK_GE",
 /* 480 */ "compare_op ::= NK_NE",
 /* 481 */ "compare_op ::= NK_EQ",
 /* 482 */ "compare_op ::= LIKE",
 /* 483 */ "compare_op ::= NOT LIKE",
 /* 484 */ "compare_op ::= MATCH",
 /* 485 */ "compare_op ::= NMATCH",
 /* 486 */ "compare_op ::= CONTAINS",
 /* 487 */ "in_op ::= IN",
 /* 488 */ "in_op ::= NOT IN",
 /* 489 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 490 */ "boolean_value_expression ::= boolean_primary",
 /* 491 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 492 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 493 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 494 */ "boolean_primary ::= predicate",
 /* 495 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 496 */ "common_expression ::= expr_or_subquery",
 /* 497 */ "common_expression ::= boolean_value_expression",
 /* 498 */ "from_clause_opt ::=",
 /* 499 */ "from_clause_opt ::= FROM table_reference_list",
 /* 500 */ "table_reference_list ::= table_reference",
 /* 501 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 502 */ "table_reference ::= table_primary",
 /* 503 */ "table_reference ::= joined_table",
 /* 504 */ "table_primary ::= table_name alias_opt",
 /* 505 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 506 */ "table_primary ::= subquery alias_opt",
 /* 507 */ "table_primary ::= parenthesized_joined_table",
 /* 508 */ "alias_opt ::=",
 /* 509 */ "alias_opt ::= table_alias",
 /* 510 */ "alias_opt ::= AS table_alias",
 /* 511 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 512 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 513 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 514 */ "join_type ::=",
 /* 515 */ "join_type ::= INNER",
 /* 516 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 517 */ "set_quantifier_opt ::=",
 /* 518 */ "set_quantifier_opt ::= DISTINCT",
 /* 519 */ "set_quantifier_opt ::= ALL",
 /* 520 */ "select_list ::= select_item",
 /* 521 */ "select_list ::= select_list NK_COMMA select_item",
 /* 522 */ "select_item ::= NK_STAR",
 /* 523 */ "select_item ::= common_expression",
 /* 524 */ "select_item ::= common_expression column_alias",
 /* 525 */ "select_item ::= common_expression AS column_alias",
 /* 526 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 527 */ "where_clause_opt ::=",
 /* 528 */ "where_clause_opt ::= WHERE search_condition",
 /* 529 */ "partition_by_clause_opt ::=",
 /* 530 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 531 */ "partition_list ::= partition_item",
 /* 532 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 533 */ "partition_item ::= expr_or_subquery",
 /* 534 */ "partition_item ::= expr_or_subquery column_alias",
 /* 535 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 536 */ "twindow_clause_opt ::=",
 /* 537 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 538 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 539 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 540 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 541 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 542 */ "sliding_opt ::=",
 /* 543 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 544 */ "fill_opt ::=",
 /* 545 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 546 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 547 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 548 */ "fill_mode ::= NONE",
 /* 549 */ "fill_mode ::= PREV",
 /* 550 */ "fill_mode ::= NULL",
 /* 551 */ "fill_mode ::= NULL_F",
 /* 552 */ "fill_mode ::= LINEAR",
 /* 553 */ "fill_mode ::= NEXT",
 /* 554 */ "group_by_clause_opt ::=",
 /* 555 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 556 */ "group_by_list ::= expr_or_subquery",
 /* 557 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 558 */ "having_clause_opt ::=",
 /* 559 */ "having_clause_opt ::= HAVING search_condition",
 /* 560 */ "range_opt ::=",
 /* 561 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 562 */ "every_opt ::=",
 /* 563 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 564 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 565 */ "query_simple ::= query_specification",
 /* 566 */ "query_simple ::= union_query_expression",
 /* 567 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 568 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 569 */ "query_simple_or_subquery ::= query_simple",
 /* 570 */ "query_simple_or_subquery ::= subquery",
 /* 571 */ "query_or_subquery ::= query_expression",
 /* 572 */ "query_or_subquery ::= subquery",
 /* 573 */ "order_by_clause_opt ::=",
 /* 574 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 575 */ "slimit_clause_opt ::=",
 /* 576 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 577 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 578 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 579 */ "limit_clause_opt ::=",
 /* 580 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 581 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 582 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 583 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 584 */ "subquery ::= NK_LP subquery NK_RP",
 /* 585 */ "search_condition ::= common_expression",
 /* 586 */ "sort_specification_list ::= sort_specification",
 /* 587 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 588 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 589 */ "ordering_specification_opt ::=",
 /* 590 */ "ordering_specification_opt ::= ASC",
 /* 591 */ "ordering_specification_opt ::= DESC",
 /* 592 */ "null_ordering_opt ::=",
 /* 593 */ "null_ordering_opt ::= NULLS FIRST",
 /* 594 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 337: /* cmd */
    case 340: /* literal */
    case 346: /* with_opt */
    case 352: /* search_condition */
    case 357: /* db_options */
    case 359: /* alter_db_options */
    case 361: /* start_opt */
    case 362: /* end_opt */
    case 366: /* signed */
    case 368: /* retention */
    case 369: /* full_table_name */
    case 372: /* table_options */
    case 376: /* alter_table_clause */
    case 377: /* alter_table_options */
    case 380: /* signed_literal */
    case 381: /* create_subtable_clause */
    case 384: /* drop_table_clause */
    case 386: /* column_def */
    case 390: /* duration_literal */
    case 391: /* rollup_func_name */
    case 393: /* col_name */
    case 394: /* db_name_cond_opt */
    case 395: /* like_pattern_opt */
    case 396: /* table_name_cond */
    case 397: /* from_db_opt */
    case 399: /* tag_item */
    case 401: /* full_index_name */
    case 402: /* index_options */
    case 405: /* sliding_opt */
    case 406: /* sma_stream_opt */
    case 407: /* func */
    case 409: /* query_or_subquery */
    case 412: /* explain_options */
    case 413: /* insert_query */
    case 419: /* stream_options */
    case 422: /* subtable_opt */
    case 424: /* expression */
    case 426: /* where_clause_opt */
    case 427: /* literal_func */
    case 430: /* expr_or_subquery */
    case 431: /* pseudo_column */
    case 432: /* column_reference */
    case 433: /* function_expression */
    case 434: /* case_when_expression */
    case 439: /* star_func_para */
    case 441: /* case_when_else_opt */
    case 442: /* common_expression */
    case 443: /* when_then_expr */
    case 444: /* predicate */
    case 447: /* in_predicate_value */
    case 448: /* boolean_value_expression */
    case 449: /* boolean_primary */
    case 450: /* from_clause_opt */
    case 451: /* table_reference_list */
    case 452: /* table_reference */
    case 453: /* table_primary */
    case 454: /* joined_table */
    case 456: /* subquery */
    case 457: /* parenthesized_joined_table */
    case 459: /* query_specification */
    case 463: /* range_opt */
    case 464: /* every_opt */
    case 465: /* fill_opt */
    case 466: /* twindow_clause_opt */
    case 468: /* having_clause_opt */
    case 469: /* select_item */
    case 471: /* partition_item */
    case 474: /* query_expression */
    case 475: /* query_simple */
    case 477: /* slimit_clause_opt */
    case 478: /* limit_clause_opt */
    case 479: /* union_query_expression */
    case 480: /* query_simple_or_subquery */
    case 482: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy242)); 
}
      break;
    case 338: /* account_options */
    case 339: /* alter_account_options */
    case 341: /* alter_account_option */
    case 360: /* speed_opt */
    case 416: /* bufsize_opt */
{
 
}
      break;
    case 342: /* user_name */
    case 349: /* db_name */
    case 350: /* table_name */
    case 351: /* topic_name */
    case 353: /* dnode_endpoint */
    case 378: /* column_name */
    case 392: /* function_name */
    case 400: /* column_alias */
    case 403: /* index_name */
    case 408: /* sma_func_name */
    case 410: /* cgroup_name */
    case 417: /* language_opt */
    case 418: /* stream_name */
    case 429: /* table_alias */
    case 435: /* star_func */
    case 437: /* noarg_func */
    case 455: /* alias_opt */
{
 
}
      break;
    case 343: /* sysinfo_opt */
{
 
}
      break;
    case 344: /* privileges */
    case 347: /* priv_type_list */
    case 348: /* priv_type */
{
 
}
      break;
    case 345: /* priv_level */
{
 
}
      break;
    case 354: /* force_opt */
    case 355: /* unsafe_opt */
    case 356: /* not_exists_opt */
    case 358: /* exists_opt */
    case 411: /* analyze_opt */
    case 414: /* or_replace_opt */
    case 415: /* agg_func_opt */
    case 423: /* ignore_opt */
    case 460: /* set_quantifier_opt */
{
 
}
      break;
    case 363: /* integer_list */
    case 364: /* variable_list */
    case 365: /* retention_list */
    case 370: /* column_def_list */
    case 371: /* tags_def_opt */
    case 373: /* multi_create_clause */
    case 374: /* tags_def */
    case 375: /* multi_drop_clause */
    case 382: /* specific_cols_opt */
    case 383: /* expression_list */
    case 385: /* col_name_list */
    case 387: /* duration_list */
    case 388: /* rollup_func_list */
    case 398: /* tag_list_opt */
    case 404: /* func_list */
    case 420: /* col_list_opt */
    case 421: /* tag_def_or_ref_opt */
    case 425: /* dnode_list */
    case 428: /* literal_list */
    case 436: /* star_func_para_list */
    case 438: /* other_para_list */
    case 440: /* when_then_list */
    case 461: /* select_list */
    case 462: /* partition_by_clause_opt */
    case 467: /* group_by_clause_opt */
    case 470: /* partition_list */
    case 473: /* group_by_list */
    case 476: /* order_by_clause_opt */
    case 481: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy174)); 
}
      break;
    case 367: /* alter_db_option */
    case 389: /* alter_table_option */
{
 
}
      break;
    case 379: /* type_name */
{
 
}
      break;
    case 445: /* compare_op */
    case 446: /* in_op */
{
 
}
      break;
    case 458: /* join_type */
{
 
}
      break;
    case 472: /* fill_mode */
{
 
}
      break;
    case 483: /* ordering_specification_opt */
{
 
}
      break;
    case 484: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   337,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   337,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   338,  /* (2) account_options ::= */
   338,  /* (3) account_options ::= account_options PPS literal */
   338,  /* (4) account_options ::= account_options TSERIES literal */
   338,  /* (5) account_options ::= account_options STORAGE literal */
   338,  /* (6) account_options ::= account_options STREAMS literal */
   338,  /* (7) account_options ::= account_options QTIME literal */
   338,  /* (8) account_options ::= account_options DBS literal */
   338,  /* (9) account_options ::= account_options USERS literal */
   338,  /* (10) account_options ::= account_options CONNS literal */
   338,  /* (11) account_options ::= account_options STATE literal */
   339,  /* (12) alter_account_options ::= alter_account_option */
   339,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   341,  /* (14) alter_account_option ::= PASS literal */
   341,  /* (15) alter_account_option ::= PPS literal */
   341,  /* (16) alter_account_option ::= TSERIES literal */
   341,  /* (17) alter_account_option ::= STORAGE literal */
   341,  /* (18) alter_account_option ::= STREAMS literal */
   341,  /* (19) alter_account_option ::= QTIME literal */
   341,  /* (20) alter_account_option ::= DBS literal */
   341,  /* (21) alter_account_option ::= USERS literal */
   341,  /* (22) alter_account_option ::= CONNS literal */
   341,  /* (23) alter_account_option ::= STATE literal */
   337,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   337,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   337,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   337,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   337,  /* (28) cmd ::= DROP USER user_name */
   343,  /* (29) sysinfo_opt ::= */
   343,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   337,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   337,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   344,  /* (33) privileges ::= ALL */
   344,  /* (34) privileges ::= priv_type_list */
   344,  /* (35) privileges ::= SUBSCRIBE */
   347,  /* (36) priv_type_list ::= priv_type */
   347,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   348,  /* (38) priv_type ::= READ */
   348,  /* (39) priv_type ::= WRITE */
   345,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   345,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   345,  /* (42) priv_level ::= db_name NK_DOT table_name */
   345,  /* (43) priv_level ::= topic_name */
   346,  /* (44) with_opt ::= */
   346,  /* (45) with_opt ::= WITH search_condition */
   337,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   337,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   337,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   337,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   337,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   337,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   337,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   337,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   337,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   337,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   337,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   353,  /* (57) dnode_endpoint ::= NK_STRING */
   353,  /* (58) dnode_endpoint ::= NK_ID */
   353,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
   354,  /* (60) force_opt ::= */
   354,  /* (61) force_opt ::= FORCE */
   355,  /* (62) unsafe_opt ::= UNSAFE */
   337,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   337,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   337,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   337,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   337,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   337,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   337,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   337,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   337,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   337,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   337,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   337,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   337,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   337,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   337,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   337,  /* (78) cmd ::= USE db_name */
   337,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   337,  /* (80) cmd ::= FLUSH DATABASE db_name */
   337,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   337,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   356,  /* (83) not_exists_opt ::= IF NOT EXISTS */
   356,  /* (84) not_exists_opt ::= */
   358,  /* (85) exists_opt ::= IF EXISTS */
   358,  /* (86) exists_opt ::= */
   357,  /* (87) db_options ::= */
   357,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   357,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   357,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   357,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   357,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   357,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   357,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   357,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   357,  /* (96) db_options ::= db_options KEEP integer_list */
   357,  /* (97) db_options ::= db_options KEEP variable_list */
   357,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   357,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   357,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   357,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   357,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   357,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   357,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   357,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   357,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   357,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   357,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   357,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   357,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   357,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   357,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   357,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   357,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   357,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   357,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   357,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   359,  /* (118) alter_db_options ::= alter_db_option */
   359,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   367,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   367,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   367,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   367,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   367,  /* (124) alter_db_option ::= KEEP integer_list */
   367,  /* (125) alter_db_option ::= KEEP variable_list */
   367,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   367,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   367,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   367,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   367,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   367,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   367,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   367,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   367,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   363,  /* (135) integer_list ::= NK_INTEGER */
   363,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   364,  /* (137) variable_list ::= NK_VARIABLE */
   364,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   365,  /* (139) retention_list ::= retention */
   365,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   368,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   360,  /* (142) speed_opt ::= */
   360,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
   361,  /* (144) start_opt ::= */
   361,  /* (145) start_opt ::= START WITH NK_INTEGER */
   361,  /* (146) start_opt ::= START WITH NK_STRING */
   361,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
   362,  /* (148) end_opt ::= */
   362,  /* (149) end_opt ::= END WITH NK_INTEGER */
   362,  /* (150) end_opt ::= END WITH NK_STRING */
   362,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   337,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   337,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   337,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   337,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   337,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   337,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   337,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   376,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   376,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   376,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   376,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   376,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   376,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   376,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   376,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   376,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   376,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   373,  /* (169) multi_create_clause ::= create_subtable_clause */
   373,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
   381,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   375,  /* (172) multi_drop_clause ::= drop_table_clause */
   375,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   384,  /* (174) drop_table_clause ::= exists_opt full_table_name */
   382,  /* (175) specific_cols_opt ::= */
   382,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   369,  /* (177) full_table_name ::= table_name */
   369,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   370,  /* (179) column_def_list ::= column_def */
   370,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   386,  /* (181) column_def ::= column_name type_name */
   379,  /* (182) type_name ::= BOOL */
   379,  /* (183) type_name ::= TINYINT */
   379,  /* (184) type_name ::= SMALLINT */
   379,  /* (185) type_name ::= INT */
   379,  /* (186) type_name ::= INTEGER */
   379,  /* (187) type_name ::= BIGINT */
   379,  /* (188) type_name ::= FLOAT */
   379,  /* (189) type_name ::= DOUBLE */
   379,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   379,  /* (191) type_name ::= TIMESTAMP */
   379,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   379,  /* (193) type_name ::= TINYINT UNSIGNED */
   379,  /* (194) type_name ::= SMALLINT UNSIGNED */
   379,  /* (195) type_name ::= INT UNSIGNED */
   379,  /* (196) type_name ::= BIGINT UNSIGNED */
   379,  /* (197) type_name ::= JSON */
   379,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   379,  /* (199) type_name ::= MEDIUMBLOB */
   379,  /* (200) type_name ::= BLOB */
   379,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   379,  /* (202) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   379,  /* (203) type_name ::= DECIMAL */
   379,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   379,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   371,  /* (206) tags_def_opt ::= */
   371,  /* (207) tags_def_opt ::= tags_def */
   374,  /* (208) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   372,  /* (209) table_options ::= */
   372,  /* (210) table_options ::= table_options COMMENT NK_STRING */
   372,  /* (211) table_options ::= table_options MAX_DELAY duration_list */
   372,  /* (212) table_options ::= table_options WATERMARK duration_list */
   372,  /* (213) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   372,  /* (214) table_options ::= table_options TTL NK_INTEGER */
   372,  /* (215) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   372,  /* (216) table_options ::= table_options DELETE_MARK duration_list */
   377,  /* (217) alter_table_options ::= alter_table_option */
   377,  /* (218) alter_table_options ::= alter_table_options alter_table_option */
   389,  /* (219) alter_table_option ::= COMMENT NK_STRING */
   389,  /* (220) alter_table_option ::= TTL NK_INTEGER */
   387,  /* (221) duration_list ::= duration_literal */
   387,  /* (222) duration_list ::= duration_list NK_COMMA duration_literal */
   388,  /* (223) rollup_func_list ::= rollup_func_name */
   388,  /* (224) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   391,  /* (225) rollup_func_name ::= function_name */
   391,  /* (226) rollup_func_name ::= FIRST */
   391,  /* (227) rollup_func_name ::= LAST */
   385,  /* (228) col_name_list ::= col_name */
   385,  /* (229) col_name_list ::= col_name_list NK_COMMA col_name */
   393,  /* (230) col_name ::= column_name */
   337,  /* (231) cmd ::= SHOW DNODES */
   337,  /* (232) cmd ::= SHOW USERS */
   337,  /* (233) cmd ::= SHOW USER PRIVILEGES */
   337,  /* (234) cmd ::= SHOW DATABASES */
   337,  /* (235) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   337,  /* (236) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   337,  /* (237) cmd ::= SHOW db_name_cond_opt VGROUPS */
   337,  /* (238) cmd ::= SHOW MNODES */
   337,  /* (239) cmd ::= SHOW QNODES */
   337,  /* (240) cmd ::= SHOW FUNCTIONS */
   337,  /* (241) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   337,  /* (242) cmd ::= SHOW STREAMS */
   337,  /* (243) cmd ::= SHOW ACCOUNTS */
   337,  /* (244) cmd ::= SHOW APPS */
   337,  /* (245) cmd ::= SHOW CONNECTIONS */
   337,  /* (246) cmd ::= SHOW LICENCES */
   337,  /* (247) cmd ::= SHOW GRANTS */
   337,  /* (248) cmd ::= SHOW CREATE DATABASE db_name */
   337,  /* (249) cmd ::= SHOW CREATE TABLE full_table_name */
   337,  /* (250) cmd ::= SHOW CREATE STABLE full_table_name */
   337,  /* (251) cmd ::= SHOW QUERIES */
   337,  /* (252) cmd ::= SHOW SCORES */
   337,  /* (253) cmd ::= SHOW TOPICS */
   337,  /* (254) cmd ::= SHOW VARIABLES */
   337,  /* (255) cmd ::= SHOW CLUSTER VARIABLES */
   337,  /* (256) cmd ::= SHOW LOCAL VARIABLES */
   337,  /* (257) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   337,  /* (258) cmd ::= SHOW BNODES */
   337,  /* (259) cmd ::= SHOW SNODES */
   337,  /* (260) cmd ::= SHOW CLUSTER */
   337,  /* (261) cmd ::= SHOW TRANSACTIONS */
   337,  /* (262) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   337,  /* (263) cmd ::= SHOW CONSUMERS */
   337,  /* (264) cmd ::= SHOW SUBSCRIPTIONS */
   337,  /* (265) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   337,  /* (266) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   337,  /* (267) cmd ::= SHOW VNODES NK_INTEGER */
   337,  /* (268) cmd ::= SHOW VNODES NK_STRING */
   337,  /* (269) cmd ::= SHOW db_name_cond_opt ALIVE */
   337,  /* (270) cmd ::= SHOW CLUSTER ALIVE */
   394,  /* (271) db_name_cond_opt ::= */
   394,  /* (272) db_name_cond_opt ::= db_name NK_DOT */
   395,  /* (273) like_pattern_opt ::= */
   395,  /* (274) like_pattern_opt ::= LIKE NK_STRING */
   396,  /* (275) table_name_cond ::= table_name */
   397,  /* (276) from_db_opt ::= */
   397,  /* (277) from_db_opt ::= FROM db_name */
   398,  /* (278) tag_list_opt ::= */
   398,  /* (279) tag_list_opt ::= tag_item */
   398,  /* (280) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   399,  /* (281) tag_item ::= TBNAME */
   399,  /* (282) tag_item ::= QTAGS */
   399,  /* (283) tag_item ::= column_name */
   399,  /* (284) tag_item ::= column_name column_alias */
   399,  /* (285) tag_item ::= column_name AS column_alias */
   337,  /* (286) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   337,  /* (287) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   337,  /* (288) cmd ::= DROP INDEX exists_opt full_index_name */
   401,  /* (289) full_index_name ::= index_name */
   401,  /* (290) full_index_name ::= db_name NK_DOT index_name */
   402,  /* (291) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   402,  /* (292) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   404,  /* (293) func_list ::= func */
   404,  /* (294) func_list ::= func_list NK_COMMA func */
   407,  /* (295) func ::= sma_func_name NK_LP expression_list NK_RP */
   408,  /* (296) sma_func_name ::= function_name */
   408,  /* (297) sma_func_name ::= COUNT */
   408,  /* (298) sma_func_name ::= FIRST */
   408,  /* (299) sma_func_name ::= LAST */
   408,  /* (300) sma_func_name ::= LAST_ROW */
   406,  /* (301) sma_stream_opt ::= */
   406,  /* (302) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   406,  /* (303) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   406,  /* (304) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   337,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   337,  /* (306) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   337,  /* (307) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   337,  /* (308) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   337,  /* (309) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   337,  /* (310) cmd ::= DROP TOPIC exists_opt topic_name */
   337,  /* (311) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   337,  /* (312) cmd ::= DESC full_table_name */
   337,  /* (313) cmd ::= DESCRIBE full_table_name */
   337,  /* (314) cmd ::= RESET QUERY CACHE */
   337,  /* (315) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   337,  /* (316) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   411,  /* (317) analyze_opt ::= */
   411,  /* (318) analyze_opt ::= ANALYZE */
   412,  /* (319) explain_options ::= */
   412,  /* (320) explain_options ::= explain_options VERBOSE NK_BOOL */
   412,  /* (321) explain_options ::= explain_options RATIO NK_FLOAT */
   337,  /* (322) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   337,  /* (323) cmd ::= DROP FUNCTION exists_opt function_name */
   415,  /* (324) agg_func_opt ::= */
   415,  /* (325) agg_func_opt ::= AGGREGATE */
   416,  /* (326) bufsize_opt ::= */
   416,  /* (327) bufsize_opt ::= BUFSIZE NK_INTEGER */
   417,  /* (328) language_opt ::= */
   417,  /* (329) language_opt ::= LANGUAGE NK_STRING */
   414,  /* (330) or_replace_opt ::= */
   414,  /* (331) or_replace_opt ::= OR REPLACE */
   337,  /* (332) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   337,  /* (333) cmd ::= DROP STREAM exists_opt stream_name */
   337,  /* (334) cmd ::= PAUSE STREAM exists_opt stream_name */
   337,  /* (335) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
   420,  /* (336) col_list_opt ::= */
   420,  /* (337) col_list_opt ::= NK_LP col_name_list NK_RP */
   421,  /* (338) tag_def_or_ref_opt ::= */
   421,  /* (339) tag_def_or_ref_opt ::= tags_def */
   421,  /* (340) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   419,  /* (341) stream_options ::= */
   419,  /* (342) stream_options ::= stream_options TRIGGER AT_ONCE */
   419,  /* (343) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   419,  /* (344) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   419,  /* (345) stream_options ::= stream_options WATERMARK duration_literal */
   419,  /* (346) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   419,  /* (347) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   419,  /* (348) stream_options ::= stream_options DELETE_MARK duration_literal */
   419,  /* (349) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   422,  /* (350) subtable_opt ::= */
   422,  /* (351) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   423,  /* (352) ignore_opt ::= */
   423,  /* (353) ignore_opt ::= IGNORE UNTREATED */
   337,  /* (354) cmd ::= KILL CONNECTION NK_INTEGER */
   337,  /* (355) cmd ::= KILL QUERY NK_STRING */
   337,  /* (356) cmd ::= KILL TRANSACTION NK_INTEGER */
   337,  /* (357) cmd ::= BALANCE VGROUP */
   337,  /* (358) cmd ::= BALANCE VGROUP LEADER */
   337,  /* (359) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   337,  /* (360) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   337,  /* (361) cmd ::= SPLIT VGROUP NK_INTEGER */
   425,  /* (362) dnode_list ::= DNODE NK_INTEGER */
   425,  /* (363) dnode_list ::= dnode_list DNODE NK_INTEGER */
   337,  /* (364) cmd ::= DELETE FROM full_table_name where_clause_opt */
   337,  /* (365) cmd ::= query_or_subquery */
   337,  /* (366) cmd ::= insert_query */
   413,  /* (367) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   413,  /* (368) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   340,  /* (369) literal ::= NK_INTEGER */
   340,  /* (370) literal ::= NK_FLOAT */
   340,  /* (371) literal ::= NK_STRING */
   340,  /* (372) literal ::= NK_BOOL */
   340,  /* (373) literal ::= TIMESTAMP NK_STRING */
   340,  /* (374) literal ::= duration_literal */
   340,  /* (375) literal ::= NULL */
   340,  /* (376) literal ::= NK_QUESTION */
   390,  /* (377) duration_literal ::= NK_VARIABLE */
   366,  /* (378) signed ::= NK_INTEGER */
   366,  /* (379) signed ::= NK_PLUS NK_INTEGER */
   366,  /* (380) signed ::= NK_MINUS NK_INTEGER */
   366,  /* (381) signed ::= NK_FLOAT */
   366,  /* (382) signed ::= NK_PLUS NK_FLOAT */
   366,  /* (383) signed ::= NK_MINUS NK_FLOAT */
   380,  /* (384) signed_literal ::= signed */
   380,  /* (385) signed_literal ::= NK_STRING */
   380,  /* (386) signed_literal ::= NK_BOOL */
   380,  /* (387) signed_literal ::= TIMESTAMP NK_STRING */
   380,  /* (388) signed_literal ::= duration_literal */
   380,  /* (389) signed_literal ::= NULL */
   380,  /* (390) signed_literal ::= literal_func */
   380,  /* (391) signed_literal ::= NK_QUESTION */
   428,  /* (392) literal_list ::= signed_literal */
   428,  /* (393) literal_list ::= literal_list NK_COMMA signed_literal */
   349,  /* (394) db_name ::= NK_ID */
   350,  /* (395) table_name ::= NK_ID */
   378,  /* (396) column_name ::= NK_ID */
   392,  /* (397) function_name ::= NK_ID */
   429,  /* (398) table_alias ::= NK_ID */
   400,  /* (399) column_alias ::= NK_ID */
   342,  /* (400) user_name ::= NK_ID */
   351,  /* (401) topic_name ::= NK_ID */
   418,  /* (402) stream_name ::= NK_ID */
   410,  /* (403) cgroup_name ::= NK_ID */
   403,  /* (404) index_name ::= NK_ID */
   430,  /* (405) expr_or_subquery ::= expression */
   424,  /* (406) expression ::= literal */
   424,  /* (407) expression ::= pseudo_column */
   424,  /* (408) expression ::= column_reference */
   424,  /* (409) expression ::= function_expression */
   424,  /* (410) expression ::= case_when_expression */
   424,  /* (411) expression ::= NK_LP expression NK_RP */
   424,  /* (412) expression ::= NK_PLUS expr_or_subquery */
   424,  /* (413) expression ::= NK_MINUS expr_or_subquery */
   424,  /* (414) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   424,  /* (415) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   424,  /* (416) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   424,  /* (417) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   424,  /* (418) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   424,  /* (419) expression ::= column_reference NK_ARROW NK_STRING */
   424,  /* (420) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   424,  /* (421) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   383,  /* (422) expression_list ::= expr_or_subquery */
   383,  /* (423) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   432,  /* (424) column_reference ::= column_name */
   432,  /* (425) column_reference ::= table_name NK_DOT column_name */
   431,  /* (426) pseudo_column ::= ROWTS */
   431,  /* (427) pseudo_column ::= TBNAME */
   431,  /* (428) pseudo_column ::= table_name NK_DOT TBNAME */
   431,  /* (429) pseudo_column ::= QSTART */
   431,  /* (430) pseudo_column ::= QEND */
   431,  /* (431) pseudo_column ::= QDURATION */
   431,  /* (432) pseudo_column ::= WSTART */
   431,  /* (433) pseudo_column ::= WEND */
   431,  /* (434) pseudo_column ::= WDURATION */
   431,  /* (435) pseudo_column ::= IROWTS */
   431,  /* (436) pseudo_column ::= ISFILLED */
   431,  /* (437) pseudo_column ::= QTAGS */
   433,  /* (438) function_expression ::= function_name NK_LP expression_list NK_RP */
   433,  /* (439) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   433,  /* (440) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   433,  /* (441) function_expression ::= literal_func */
   427,  /* (442) literal_func ::= noarg_func NK_LP NK_RP */
   427,  /* (443) literal_func ::= NOW */
   437,  /* (444) noarg_func ::= NOW */
   437,  /* (445) noarg_func ::= TODAY */
   437,  /* (446) noarg_func ::= TIMEZONE */
   437,  /* (447) noarg_func ::= DATABASE */
   437,  /* (448) noarg_func ::= CLIENT_VERSION */
   437,  /* (449) noarg_func ::= SERVER_VERSION */
   437,  /* (450) noarg_func ::= SERVER_STATUS */
   437,  /* (451) noarg_func ::= CURRENT_USER */
   437,  /* (452) noarg_func ::= USER */
   435,  /* (453) star_func ::= COUNT */
   435,  /* (454) star_func ::= FIRST */
   435,  /* (455) star_func ::= LAST */
   435,  /* (456) star_func ::= LAST_ROW */
   436,  /* (457) star_func_para_list ::= NK_STAR */
   436,  /* (458) star_func_para_list ::= other_para_list */
   438,  /* (459) other_para_list ::= star_func_para */
   438,  /* (460) other_para_list ::= other_para_list NK_COMMA star_func_para */
   439,  /* (461) star_func_para ::= expr_or_subquery */
   439,  /* (462) star_func_para ::= table_name NK_DOT NK_STAR */
   434,  /* (463) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   434,  /* (464) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   440,  /* (465) when_then_list ::= when_then_expr */
   440,  /* (466) when_then_list ::= when_then_list when_then_expr */
   443,  /* (467) when_then_expr ::= WHEN common_expression THEN common_expression */
   441,  /* (468) case_when_else_opt ::= */
   441,  /* (469) case_when_else_opt ::= ELSE common_expression */
   444,  /* (470) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   444,  /* (471) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   444,  /* (472) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   444,  /* (473) predicate ::= expr_or_subquery IS NULL */
   444,  /* (474) predicate ::= expr_or_subquery IS NOT NULL */
   444,  /* (475) predicate ::= expr_or_subquery in_op in_predicate_value */
   445,  /* (476) compare_op ::= NK_LT */
   445,  /* (477) compare_op ::= NK_GT */
   445,  /* (478) compare_op ::= NK_LE */
   445,  /* (479) compare_op ::= NK_GE */
   445,  /* (480) compare_op ::= NK_NE */
   445,  /* (481) compare_op ::= NK_EQ */
   445,  /* (482) compare_op ::= LIKE */
   445,  /* (483) compare_op ::= NOT LIKE */
   445,  /* (484) compare_op ::= MATCH */
   445,  /* (485) compare_op ::= NMATCH */
   445,  /* (486) compare_op ::= CONTAINS */
   446,  /* (487) in_op ::= IN */
   446,  /* (488) in_op ::= NOT IN */
   447,  /* (489) in_predicate_value ::= NK_LP literal_list NK_RP */
   448,  /* (490) boolean_value_expression ::= boolean_primary */
   448,  /* (491) boolean_value_expression ::= NOT boolean_primary */
   448,  /* (492) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   448,  /* (493) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   449,  /* (494) boolean_primary ::= predicate */
   449,  /* (495) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   442,  /* (496) common_expression ::= expr_or_subquery */
   442,  /* (497) common_expression ::= boolean_value_expression */
   450,  /* (498) from_clause_opt ::= */
   450,  /* (499) from_clause_opt ::= FROM table_reference_list */
   451,  /* (500) table_reference_list ::= table_reference */
   451,  /* (501) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   452,  /* (502) table_reference ::= table_primary */
   452,  /* (503) table_reference ::= joined_table */
   453,  /* (504) table_primary ::= table_name alias_opt */
   453,  /* (505) table_primary ::= db_name NK_DOT table_name alias_opt */
   453,  /* (506) table_primary ::= subquery alias_opt */
   453,  /* (507) table_primary ::= parenthesized_joined_table */
   455,  /* (508) alias_opt ::= */
   455,  /* (509) alias_opt ::= table_alias */
   455,  /* (510) alias_opt ::= AS table_alias */
   457,  /* (511) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   457,  /* (512) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   454,  /* (513) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   458,  /* (514) join_type ::= */
   458,  /* (515) join_type ::= INNER */
   459,  /* (516) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   460,  /* (517) set_quantifier_opt ::= */
   460,  /* (518) set_quantifier_opt ::= DISTINCT */
   460,  /* (519) set_quantifier_opt ::= ALL */
   461,  /* (520) select_list ::= select_item */
   461,  /* (521) select_list ::= select_list NK_COMMA select_item */
   469,  /* (522) select_item ::= NK_STAR */
   469,  /* (523) select_item ::= common_expression */
   469,  /* (524) select_item ::= common_expression column_alias */
   469,  /* (525) select_item ::= common_expression AS column_alias */
   469,  /* (526) select_item ::= table_name NK_DOT NK_STAR */
   426,  /* (527) where_clause_opt ::= */
   426,  /* (528) where_clause_opt ::= WHERE search_condition */
   462,  /* (529) partition_by_clause_opt ::= */
   462,  /* (530) partition_by_clause_opt ::= PARTITION BY partition_list */
   470,  /* (531) partition_list ::= partition_item */
   470,  /* (532) partition_list ::= partition_list NK_COMMA partition_item */
   471,  /* (533) partition_item ::= expr_or_subquery */
   471,  /* (534) partition_item ::= expr_or_subquery column_alias */
   471,  /* (535) partition_item ::= expr_or_subquery AS column_alias */
   466,  /* (536) twindow_clause_opt ::= */
   466,  /* (537) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   466,  /* (538) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   466,  /* (539) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   466,  /* (540) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   466,  /* (541) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   405,  /* (542) sliding_opt ::= */
   405,  /* (543) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   465,  /* (544) fill_opt ::= */
   465,  /* (545) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   465,  /* (546) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   465,  /* (547) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   472,  /* (548) fill_mode ::= NONE */
   472,  /* (549) fill_mode ::= PREV */
   472,  /* (550) fill_mode ::= NULL */
   472,  /* (551) fill_mode ::= NULL_F */
   472,  /* (552) fill_mode ::= LINEAR */
   472,  /* (553) fill_mode ::= NEXT */
   467,  /* (554) group_by_clause_opt ::= */
   467,  /* (555) group_by_clause_opt ::= GROUP BY group_by_list */
   473,  /* (556) group_by_list ::= expr_or_subquery */
   473,  /* (557) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   468,  /* (558) having_clause_opt ::= */
   468,  /* (559) having_clause_opt ::= HAVING search_condition */
   463,  /* (560) range_opt ::= */
   463,  /* (561) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   464,  /* (562) every_opt ::= */
   464,  /* (563) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   474,  /* (564) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   475,  /* (565) query_simple ::= query_specification */
   475,  /* (566) query_simple ::= union_query_expression */
   479,  /* (567) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   479,  /* (568) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   480,  /* (569) query_simple_or_subquery ::= query_simple */
   480,  /* (570) query_simple_or_subquery ::= subquery */
   409,  /* (571) query_or_subquery ::= query_expression */
   409,  /* (572) query_or_subquery ::= subquery */
   476,  /* (573) order_by_clause_opt ::= */
   476,  /* (574) order_by_clause_opt ::= ORDER BY sort_specification_list */
   477,  /* (575) slimit_clause_opt ::= */
   477,  /* (576) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   477,  /* (577) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   477,  /* (578) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   478,  /* (579) limit_clause_opt ::= */
   478,  /* (580) limit_clause_opt ::= LIMIT NK_INTEGER */
   478,  /* (581) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   478,  /* (582) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   456,  /* (583) subquery ::= NK_LP query_expression NK_RP */
   456,  /* (584) subquery ::= NK_LP subquery NK_RP */
   352,  /* (585) search_condition ::= common_expression */
   481,  /* (586) sort_specification_list ::= sort_specification */
   481,  /* (587) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   482,  /* (588) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   483,  /* (589) ordering_specification_opt ::= */
   483,  /* (590) ordering_specification_opt ::= ASC */
   483,  /* (591) ordering_specification_opt ::= DESC */
   484,  /* (592) null_ordering_opt ::= */
   484,  /* (593) null_ordering_opt ::= NULLS FIRST */
   484,  /* (594) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   -4,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   -4,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (57) dnode_endpoint ::= NK_STRING */
   -1,  /* (58) dnode_endpoint ::= NK_ID */
   -1,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (60) force_opt ::= */
   -1,  /* (61) force_opt ::= FORCE */
   -1,  /* (62) unsafe_opt ::= UNSAFE */
   -3,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (78) cmd ::= USE db_name */
   -4,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (80) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (83) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (84) not_exists_opt ::= */
   -2,  /* (85) exists_opt ::= IF EXISTS */
    0,  /* (86) exists_opt ::= */
    0,  /* (87) db_options ::= */
   -3,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options KEEP integer_list */
   -3,  /* (97) db_options ::= db_options KEEP variable_list */
   -3,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (118) alter_db_options ::= alter_db_option */
   -2,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (124) alter_db_option ::= KEEP integer_list */
   -2,  /* (125) alter_db_option ::= KEEP variable_list */
   -2,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (135) integer_list ::= NK_INTEGER */
   -3,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (137) variable_list ::= NK_VARIABLE */
   -3,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (139) retention_list ::= retention */
   -3,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (142) speed_opt ::= */
   -2,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (144) start_opt ::= */
   -3,  /* (145) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (146) start_opt ::= START WITH NK_STRING */
   -4,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (148) end_opt ::= */
   -3,  /* (149) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (150) end_opt ::= END WITH NK_STRING */
   -4,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (169) multi_create_clause ::= create_subtable_clause */
   -2,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (172) multi_drop_clause ::= drop_table_clause */
   -3,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (174) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (175) specific_cols_opt ::= */
   -3,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (177) full_table_name ::= table_name */
   -3,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (179) column_def_list ::= column_def */
   -3,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (181) column_def ::= column_name type_name */
   -1,  /* (182) type_name ::= BOOL */
   -1,  /* (183) type_name ::= TINYINT */
   -1,  /* (184) type_name ::= SMALLINT */
   -1,  /* (185) type_name ::= INT */
   -1,  /* (186) type_name ::= INTEGER */
   -1,  /* (187) type_name ::= BIGINT */
   -1,  /* (188) type_name ::= FLOAT */
   -1,  /* (189) type_name ::= DOUBLE */
   -4,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (191) type_name ::= TIMESTAMP */
   -4,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (193) type_name ::= TINYINT UNSIGNED */
   -2,  /* (194) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (195) type_name ::= INT UNSIGNED */
   -2,  /* (196) type_name ::= BIGINT UNSIGNED */
   -1,  /* (197) type_name ::= JSON */
   -4,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (199) type_name ::= MEDIUMBLOB */
   -1,  /* (200) type_name ::= BLOB */
   -4,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -4,  /* (202) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   -1,  /* (203) type_name ::= DECIMAL */
   -4,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (206) tags_def_opt ::= */
   -1,  /* (207) tags_def_opt ::= tags_def */
   -4,  /* (208) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (209) table_options ::= */
   -3,  /* (210) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (211) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (212) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (213) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (214) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (215) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (216) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (217) alter_table_options ::= alter_table_option */
   -2,  /* (218) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (219) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (220) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (221) duration_list ::= duration_literal */
   -3,  /* (222) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (223) rollup_func_list ::= rollup_func_name */
   -3,  /* (224) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (225) rollup_func_name ::= function_name */
   -1,  /* (226) rollup_func_name ::= FIRST */
   -1,  /* (227) rollup_func_name ::= LAST */
   -1,  /* (228) col_name_list ::= col_name */
   -3,  /* (229) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (230) col_name ::= column_name */
   -2,  /* (231) cmd ::= SHOW DNODES */
   -2,  /* (232) cmd ::= SHOW USERS */
   -3,  /* (233) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (234) cmd ::= SHOW DATABASES */
   -4,  /* (235) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (236) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (237) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (238) cmd ::= SHOW MNODES */
   -2,  /* (239) cmd ::= SHOW QNODES */
   -2,  /* (240) cmd ::= SHOW FUNCTIONS */
   -5,  /* (241) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (242) cmd ::= SHOW STREAMS */
   -2,  /* (243) cmd ::= SHOW ACCOUNTS */
   -2,  /* (244) cmd ::= SHOW APPS */
   -2,  /* (245) cmd ::= SHOW CONNECTIONS */
   -2,  /* (246) cmd ::= SHOW LICENCES */
   -2,  /* (247) cmd ::= SHOW GRANTS */
   -4,  /* (248) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (249) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (250) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (251) cmd ::= SHOW QUERIES */
   -2,  /* (252) cmd ::= SHOW SCORES */
   -2,  /* (253) cmd ::= SHOW TOPICS */
   -2,  /* (254) cmd ::= SHOW VARIABLES */
   -3,  /* (255) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (256) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (257) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (258) cmd ::= SHOW BNODES */
   -2,  /* (259) cmd ::= SHOW SNODES */
   -2,  /* (260) cmd ::= SHOW CLUSTER */
   -2,  /* (261) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (262) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (263) cmd ::= SHOW CONSUMERS */
   -2,  /* (264) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (265) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (266) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (267) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (268) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (269) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (270) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (271) db_name_cond_opt ::= */
   -2,  /* (272) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (273) like_pattern_opt ::= */
   -2,  /* (274) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (275) table_name_cond ::= table_name */
    0,  /* (276) from_db_opt ::= */
   -2,  /* (277) from_db_opt ::= FROM db_name */
    0,  /* (278) tag_list_opt ::= */
   -1,  /* (279) tag_list_opt ::= tag_item */
   -3,  /* (280) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (281) tag_item ::= TBNAME */
   -1,  /* (282) tag_item ::= QTAGS */
   -1,  /* (283) tag_item ::= column_name */
   -2,  /* (284) tag_item ::= column_name column_alias */
   -3,  /* (285) tag_item ::= column_name AS column_alias */
   -8,  /* (286) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (287) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (288) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (289) full_index_name ::= index_name */
   -3,  /* (290) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (291) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (292) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (293) func_list ::= func */
   -3,  /* (294) func_list ::= func_list NK_COMMA func */
   -4,  /* (295) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (296) sma_func_name ::= function_name */
   -1,  /* (297) sma_func_name ::= COUNT */
   -1,  /* (298) sma_func_name ::= FIRST */
   -1,  /* (299) sma_func_name ::= LAST */
   -1,  /* (300) sma_func_name ::= LAST_ROW */
    0,  /* (301) sma_stream_opt ::= */
   -3,  /* (302) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (303) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (304) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (306) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (307) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (308) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (309) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (310) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (311) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (312) cmd ::= DESC full_table_name */
   -2,  /* (313) cmd ::= DESCRIBE full_table_name */
   -3,  /* (314) cmd ::= RESET QUERY CACHE */
   -4,  /* (315) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (316) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (317) analyze_opt ::= */
   -1,  /* (318) analyze_opt ::= ANALYZE */
    0,  /* (319) explain_options ::= */
   -3,  /* (320) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (321) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (322) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (323) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (324) agg_func_opt ::= */
   -1,  /* (325) agg_func_opt ::= AGGREGATE */
    0,  /* (326) bufsize_opt ::= */
   -2,  /* (327) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (328) language_opt ::= */
   -2,  /* (329) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (330) or_replace_opt ::= */
   -2,  /* (331) or_replace_opt ::= OR REPLACE */
  -12,  /* (332) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (333) cmd ::= DROP STREAM exists_opt stream_name */
   -4,  /* (334) cmd ::= PAUSE STREAM exists_opt stream_name */
   -5,  /* (335) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
    0,  /* (336) col_list_opt ::= */
   -3,  /* (337) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (338) tag_def_or_ref_opt ::= */
   -1,  /* (339) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (340) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (341) stream_options ::= */
   -3,  /* (342) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (343) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (344) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (345) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (346) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (347) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (348) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (349) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (350) subtable_opt ::= */
   -4,  /* (351) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
    0,  /* (352) ignore_opt ::= */
   -2,  /* (353) ignore_opt ::= IGNORE UNTREATED */
   -3,  /* (354) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (355) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (356) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (357) cmd ::= BALANCE VGROUP */
   -3,  /* (358) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (359) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (360) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (361) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (362) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (363) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (364) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (365) cmd ::= query_or_subquery */
   -1,  /* (366) cmd ::= insert_query */
   -7,  /* (367) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (368) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (369) literal ::= NK_INTEGER */
   -1,  /* (370) literal ::= NK_FLOAT */
   -1,  /* (371) literal ::= NK_STRING */
   -1,  /* (372) literal ::= NK_BOOL */
   -2,  /* (373) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (374) literal ::= duration_literal */
   -1,  /* (375) literal ::= NULL */
   -1,  /* (376) literal ::= NK_QUESTION */
   -1,  /* (377) duration_literal ::= NK_VARIABLE */
   -1,  /* (378) signed ::= NK_INTEGER */
   -2,  /* (379) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (380) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (381) signed ::= NK_FLOAT */
   -2,  /* (382) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (383) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (384) signed_literal ::= signed */
   -1,  /* (385) signed_literal ::= NK_STRING */
   -1,  /* (386) signed_literal ::= NK_BOOL */
   -2,  /* (387) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (388) signed_literal ::= duration_literal */
   -1,  /* (389) signed_literal ::= NULL */
   -1,  /* (390) signed_literal ::= literal_func */
   -1,  /* (391) signed_literal ::= NK_QUESTION */
   -1,  /* (392) literal_list ::= signed_literal */
   -3,  /* (393) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (394) db_name ::= NK_ID */
   -1,  /* (395) table_name ::= NK_ID */
   -1,  /* (396) column_name ::= NK_ID */
   -1,  /* (397) function_name ::= NK_ID */
   -1,  /* (398) table_alias ::= NK_ID */
   -1,  /* (399) column_alias ::= NK_ID */
   -1,  /* (400) user_name ::= NK_ID */
   -1,  /* (401) topic_name ::= NK_ID */
   -1,  /* (402) stream_name ::= NK_ID */
   -1,  /* (403) cgroup_name ::= NK_ID */
   -1,  /* (404) index_name ::= NK_ID */
   -1,  /* (405) expr_or_subquery ::= expression */
   -1,  /* (406) expression ::= literal */
   -1,  /* (407) expression ::= pseudo_column */
   -1,  /* (408) expression ::= column_reference */
   -1,  /* (409) expression ::= function_expression */
   -1,  /* (410) expression ::= case_when_expression */
   -3,  /* (411) expression ::= NK_LP expression NK_RP */
   -2,  /* (412) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (413) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (414) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (415) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (416) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (417) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (418) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (419) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (420) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (421) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (422) expression_list ::= expr_or_subquery */
   -3,  /* (423) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (424) column_reference ::= column_name */
   -3,  /* (425) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (426) pseudo_column ::= ROWTS */
   -1,  /* (427) pseudo_column ::= TBNAME */
   -3,  /* (428) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (429) pseudo_column ::= QSTART */
   -1,  /* (430) pseudo_column ::= QEND */
   -1,  /* (431) pseudo_column ::= QDURATION */
   -1,  /* (432) pseudo_column ::= WSTART */
   -1,  /* (433) pseudo_column ::= WEND */
   -1,  /* (434) pseudo_column ::= WDURATION */
   -1,  /* (435) pseudo_column ::= IROWTS */
   -1,  /* (436) pseudo_column ::= ISFILLED */
   -1,  /* (437) pseudo_column ::= QTAGS */
   -4,  /* (438) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (439) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (440) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (441) function_expression ::= literal_func */
   -3,  /* (442) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (443) literal_func ::= NOW */
   -1,  /* (444) noarg_func ::= NOW */
   -1,  /* (445) noarg_func ::= TODAY */
   -1,  /* (446) noarg_func ::= TIMEZONE */
   -1,  /* (447) noarg_func ::= DATABASE */
   -1,  /* (448) noarg_func ::= CLIENT_VERSION */
   -1,  /* (449) noarg_func ::= SERVER_VERSION */
   -1,  /* (450) noarg_func ::= SERVER_STATUS */
   -1,  /* (451) noarg_func ::= CURRENT_USER */
   -1,  /* (452) noarg_func ::= USER */
   -1,  /* (453) star_func ::= COUNT */
   -1,  /* (454) star_func ::= FIRST */
   -1,  /* (455) star_func ::= LAST */
   -1,  /* (456) star_func ::= LAST_ROW */
   -1,  /* (457) star_func_para_list ::= NK_STAR */
   -1,  /* (458) star_func_para_list ::= other_para_list */
   -1,  /* (459) other_para_list ::= star_func_para */
   -3,  /* (460) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (461) star_func_para ::= expr_or_subquery */
   -3,  /* (462) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (463) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (464) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (465) when_then_list ::= when_then_expr */
   -2,  /* (466) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (467) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (468) case_when_else_opt ::= */
   -2,  /* (469) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (470) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (471) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (472) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (473) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (474) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (475) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (476) compare_op ::= NK_LT */
   -1,  /* (477) compare_op ::= NK_GT */
   -1,  /* (478) compare_op ::= NK_LE */
   -1,  /* (479) compare_op ::= NK_GE */
   -1,  /* (480) compare_op ::= NK_NE */
   -1,  /* (481) compare_op ::= NK_EQ */
   -1,  /* (482) compare_op ::= LIKE */
   -2,  /* (483) compare_op ::= NOT LIKE */
   -1,  /* (484) compare_op ::= MATCH */
   -1,  /* (485) compare_op ::= NMATCH */
   -1,  /* (486) compare_op ::= CONTAINS */
   -1,  /* (487) in_op ::= IN */
   -2,  /* (488) in_op ::= NOT IN */
   -3,  /* (489) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (490) boolean_value_expression ::= boolean_primary */
   -2,  /* (491) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (492) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (493) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (494) boolean_primary ::= predicate */
   -3,  /* (495) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (496) common_expression ::= expr_or_subquery */
   -1,  /* (497) common_expression ::= boolean_value_expression */
    0,  /* (498) from_clause_opt ::= */
   -2,  /* (499) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (500) table_reference_list ::= table_reference */
   -3,  /* (501) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (502) table_reference ::= table_primary */
   -1,  /* (503) table_reference ::= joined_table */
   -2,  /* (504) table_primary ::= table_name alias_opt */
   -4,  /* (505) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (506) table_primary ::= subquery alias_opt */
   -1,  /* (507) table_primary ::= parenthesized_joined_table */
    0,  /* (508) alias_opt ::= */
   -1,  /* (509) alias_opt ::= table_alias */
   -2,  /* (510) alias_opt ::= AS table_alias */
   -3,  /* (511) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (512) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (513) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (514) join_type ::= */
   -1,  /* (515) join_type ::= INNER */
  -12,  /* (516) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (517) set_quantifier_opt ::= */
   -1,  /* (518) set_quantifier_opt ::= DISTINCT */
   -1,  /* (519) set_quantifier_opt ::= ALL */
   -1,  /* (520) select_list ::= select_item */
   -3,  /* (521) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (522) select_item ::= NK_STAR */
   -1,  /* (523) select_item ::= common_expression */
   -2,  /* (524) select_item ::= common_expression column_alias */
   -3,  /* (525) select_item ::= common_expression AS column_alias */
   -3,  /* (526) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (527) where_clause_opt ::= */
   -2,  /* (528) where_clause_opt ::= WHERE search_condition */
    0,  /* (529) partition_by_clause_opt ::= */
   -3,  /* (530) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (531) partition_list ::= partition_item */
   -3,  /* (532) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (533) partition_item ::= expr_or_subquery */
   -2,  /* (534) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (535) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (536) twindow_clause_opt ::= */
   -6,  /* (537) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (538) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (539) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (540) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (541) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (542) sliding_opt ::= */
   -4,  /* (543) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (544) fill_opt ::= */
   -4,  /* (545) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (546) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (547) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (548) fill_mode ::= NONE */
   -1,  /* (549) fill_mode ::= PREV */
   -1,  /* (550) fill_mode ::= NULL */
   -1,  /* (551) fill_mode ::= NULL_F */
   -1,  /* (552) fill_mode ::= LINEAR */
   -1,  /* (553) fill_mode ::= NEXT */
    0,  /* (554) group_by_clause_opt ::= */
   -3,  /* (555) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (556) group_by_list ::= expr_or_subquery */
   -3,  /* (557) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (558) having_clause_opt ::= */
   -2,  /* (559) having_clause_opt ::= HAVING search_condition */
    0,  /* (560) range_opt ::= */
   -6,  /* (561) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (562) every_opt ::= */
   -4,  /* (563) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (564) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (565) query_simple ::= query_specification */
   -1,  /* (566) query_simple ::= union_query_expression */
   -4,  /* (567) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (568) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (569) query_simple_or_subquery ::= query_simple */
   -1,  /* (570) query_simple_or_subquery ::= subquery */
   -1,  /* (571) query_or_subquery ::= query_expression */
   -1,  /* (572) query_or_subquery ::= subquery */
    0,  /* (573) order_by_clause_opt ::= */
   -3,  /* (574) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (575) slimit_clause_opt ::= */
   -2,  /* (576) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (577) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (578) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (579) limit_clause_opt ::= */
   -2,  /* (580) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (581) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (582) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (583) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (584) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (585) search_condition ::= common_expression */
   -1,  /* (586) sort_specification_list ::= sort_specification */
   -3,  /* (587) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (588) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (589) ordering_specification_opt ::= */
   -1,  /* (590) ordering_specification_opt ::= ASC */
   -1,  /* (591) ordering_specification_opt ::= DESC */
    0,  /* (592) null_ordering_opt ::= */
   -2,  /* (593) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (594) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,338,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,339,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,338,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,340,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,341,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,339,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,341,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,340,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy669, &yymsp[-1].minor.yy0, yymsp[0].minor.yy73); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy669, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy669, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy669, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy73 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy73 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy349, &yymsp[-3].minor.yy257, &yymsp[0].minor.yy669, yymsp[-2].minor.yy242); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy349, &yymsp[-3].minor.yy257, &yymsp[0].minor.yy669, yymsp[-2].minor.yy242); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy349 = yymsp[0].minor.yy349; }
  yymsp[0].minor.yy349 = yylhsminor.yy349;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy349 = yymsp[-2].minor.yy349 | yymsp[0].minor.yy349; }
  yymsp[-2].minor.yy349 = yylhsminor.yy349;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy349 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy257.first = yymsp[-2].minor.yy0; yylhsminor.yy257.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy257 = yylhsminor.yy257;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy257.first = yymsp[-2].minor.yy669; yylhsminor.yy257.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy257 = yylhsminor.yy257;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy257.first = yymsp[-2].minor.yy669; yylhsminor.yy257.second = yymsp[0].minor.yy669; }
  yymsp[-2].minor.yy257 = yylhsminor.yy257;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy257.first = yymsp[0].minor.yy669; yylhsminor.yy257.second = nil_token; }
  yymsp[0].minor.yy257 = yylhsminor.yy257;
        break;
      case 44: /* with_opt ::= */
      case 144: /* start_opt ::= */ yytestcase(yyruleno==144);
      case 148: /* end_opt ::= */ yytestcase(yyruleno==148);
      case 273: /* like_pattern_opt ::= */ yytestcase(yyruleno==273);
      case 350: /* subtable_opt ::= */ yytestcase(yyruleno==350);
      case 468: /* case_when_else_opt ::= */ yytestcase(yyruleno==468);
      case 498: /* from_clause_opt ::= */ yytestcase(yyruleno==498);
      case 527: /* where_clause_opt ::= */ yytestcase(yyruleno==527);
      case 536: /* twindow_clause_opt ::= */ yytestcase(yyruleno==536);
      case 542: /* sliding_opt ::= */ yytestcase(yyruleno==542);
      case 544: /* fill_opt ::= */ yytestcase(yyruleno==544);
      case 558: /* having_clause_opt ::= */ yytestcase(yyruleno==558);
      case 560: /* range_opt ::= */ yytestcase(yyruleno==560);
      case 562: /* every_opt ::= */ yytestcase(yyruleno==562);
      case 575: /* slimit_clause_opt ::= */ yytestcase(yyruleno==575);
      case 579: /* limit_clause_opt ::= */ yytestcase(yyruleno==579);
{ yymsp[1].minor.yy242 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 499: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==499);
      case 528: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==528);
      case 559: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==559);
{ yymsp[-1].minor.yy242 = yymsp[0].minor.yy242; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy669, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy777, false); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy777, false); }
        break;
      case 50: /* cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, false, yymsp[0].minor.yy777); }
        break;
      case 51: /* cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy669, false, yymsp[0].minor.yy777); }
        break;
      case 52: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= RESTORE DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* dnode_endpoint ::= NK_STRING */
      case 58: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==58);
      case 59: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==59);
      case 297: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==297);
      case 298: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==298);
      case 299: /* sma_func_name ::= LAST */ yytestcase(yyruleno==299);
      case 300: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==300);
      case 394: /* db_name ::= NK_ID */ yytestcase(yyruleno==394);
      case 395: /* table_name ::= NK_ID */ yytestcase(yyruleno==395);
      case 396: /* column_name ::= NK_ID */ yytestcase(yyruleno==396);
      case 397: /* function_name ::= NK_ID */ yytestcase(yyruleno==397);
      case 398: /* table_alias ::= NK_ID */ yytestcase(yyruleno==398);
      case 399: /* column_alias ::= NK_ID */ yytestcase(yyruleno==399);
      case 400: /* user_name ::= NK_ID */ yytestcase(yyruleno==400);
      case 401: /* topic_name ::= NK_ID */ yytestcase(yyruleno==401);
      case 402: /* stream_name ::= NK_ID */ yytestcase(yyruleno==402);
      case 403: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==403);
      case 404: /* index_name ::= NK_ID */ yytestcase(yyruleno==404);
      case 444: /* noarg_func ::= NOW */ yytestcase(yyruleno==444);
      case 445: /* noarg_func ::= TODAY */ yytestcase(yyruleno==445);
      case 446: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==446);
      case 447: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==447);
      case 448: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==448);
      case 449: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==449);
      case 450: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==450);
      case 451: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==451);
      case 452: /* noarg_func ::= USER */ yytestcase(yyruleno==452);
      case 453: /* star_func ::= COUNT */ yytestcase(yyruleno==453);
      case 454: /* star_func ::= FIRST */ yytestcase(yyruleno==454);
      case 455: /* star_func ::= LAST */ yytestcase(yyruleno==455);
      case 456: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==456);
{ yylhsminor.yy669 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy669 = yylhsminor.yy669;
        break;
      case 60: /* force_opt ::= */
      case 84: /* not_exists_opt ::= */ yytestcase(yyruleno==84);
      case 86: /* exists_opt ::= */ yytestcase(yyruleno==86);
      case 317: /* analyze_opt ::= */ yytestcase(yyruleno==317);
      case 324: /* agg_func_opt ::= */ yytestcase(yyruleno==324);
      case 330: /* or_replace_opt ::= */ yytestcase(yyruleno==330);
      case 352: /* ignore_opt ::= */ yytestcase(yyruleno==352);
      case 517: /* set_quantifier_opt ::= */ yytestcase(yyruleno==517);
{ yymsp[1].minor.yy777 = false; }
        break;
      case 61: /* force_opt ::= FORCE */
      case 62: /* unsafe_opt ::= UNSAFE */ yytestcase(yyruleno==62);
      case 318: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==318);
      case 325: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==325);
      case 518: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==518);
{ yymsp[0].minor.yy777 = true; }
        break;
      case 63: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 64: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 70: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 71: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 72: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 73: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 74: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 75: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 76: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy777, &yymsp[-1].minor.yy669, yymsp[0].minor.yy242); }
        break;
      case 77: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 78: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 79: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy242); }
        break;
      case 80: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 81: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy120); }
        break;
      case 82: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy669, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 83: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy777 = true; }
        break;
      case 85: /* exists_opt ::= IF EXISTS */
      case 331: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==331);
      case 353: /* ignore_opt ::= IGNORE UNTREATED */ yytestcase(yyruleno==353);
{ yymsp[-1].minor.yy777 = true; }
        break;
      case 87: /* db_options ::= */
{ yymsp[1].minor.yy242 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 88: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 89: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 90: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 91: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 92: /* db_options ::= db_options DURATION NK_INTEGER */
      case 93: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==93);
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 94: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 95: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 96: /* db_options ::= db_options KEEP integer_list */
      case 97: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==97);
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_KEEP, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 98: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 99: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 100: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 101: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 102: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 103: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 104: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 105: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_RETENTIONS, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 106: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 107: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 108: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 110: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-3].minor.yy242, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 111: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 112: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-3].minor.yy242, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 113: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 114: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 115: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 116: /* db_options ::= db_options TABLE_PREFIX signed */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 117: /* db_options ::= db_options TABLE_SUFFIX signed */
{ yylhsminor.yy242 = setDatabaseOption(pCxt, yymsp[-2].minor.yy242, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 118: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy242 = createAlterDatabaseOptions(pCxt); yylhsminor.yy242 = setAlterDatabaseOption(pCxt, yylhsminor.yy242, &yymsp[0].minor.yy535); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 119: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy242 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy242, &yymsp[0].minor.yy535); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 120: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy535.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= KEEP integer_list */
      case 125: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==125);
{ yymsp[-1].minor.yy535.type = DB_OPTION_KEEP; yymsp[-1].minor.yy535.pList = yymsp[0].minor.yy174; }
        break;
      case 126: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_PAGES; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 128: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_WAL; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 129: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 130: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 132: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy535.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy535.val = t;
                                                                                  }
        break;
      case 133: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy535.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 134: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy535.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy535.val = t;
                                                                                  }
        break;
      case 135: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy174 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 136: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 363: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==363);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 137: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy174 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 138: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 139: /* retention_list ::= retention */
      case 169: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==169);
      case 172: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==172);
      case 179: /* column_def_list ::= column_def */ yytestcase(yyruleno==179);
      case 223: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==223);
      case 228: /* col_name_list ::= col_name */ yytestcase(yyruleno==228);
      case 279: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==279);
      case 293: /* func_list ::= func */ yytestcase(yyruleno==293);
      case 392: /* literal_list ::= signed_literal */ yytestcase(yyruleno==392);
      case 459: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==459);
      case 465: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==465);
      case 520: /* select_list ::= select_item */ yytestcase(yyruleno==520);
      case 531: /* partition_list ::= partition_item */ yytestcase(yyruleno==531);
      case 586: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==586);
{ yylhsminor.yy174 = createNodeList(pCxt, yymsp[0].minor.yy242); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 140: /* retention_list ::= retention_list NK_COMMA retention */
      case 173: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==173);
      case 180: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==180);
      case 224: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==224);
      case 229: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==229);
      case 280: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==280);
      case 294: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==294);
      case 393: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==393);
      case 460: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==460);
      case 521: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==521);
      case 532: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==532);
      case 587: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==587);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 141: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy242 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 142: /* speed_opt ::= */
      case 326: /* bufsize_opt ::= */ yytestcase(yyruleno==326);
{ yymsp[1].minor.yy120 = 0; }
        break;
      case 143: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 327: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==327);
{ yymsp[-1].minor.yy120 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 145: /* start_opt ::= START WITH NK_INTEGER */
      case 149: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==149);
{ yymsp[-2].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 146: /* start_opt ::= START WITH NK_STRING */
      case 150: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==150);
{ yymsp[-2].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 147: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 151: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==151);
{ yymsp[-3].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 152: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 154: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==154);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy777, yymsp[-5].minor.yy242, yymsp[-3].minor.yy174, yymsp[-1].minor.yy174, yymsp[0].minor.yy242); }
        break;
      case 153: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy174); }
        break;
      case 155: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy174); }
        break;
      case 156: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy242); }
        break;
      case 157: /* cmd ::= ALTER TABLE alter_table_clause */
      case 365: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==365);
      case 366: /* cmd ::= insert_query */ yytestcase(yyruleno==366);
{ pCxt->pRootNode = yymsp[0].minor.yy242; }
        break;
      case 158: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy242); }
        break;
      case 159: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy242 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 160: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 161: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy242 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy242, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy669); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 162: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 163: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy242 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 164: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 165: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy242 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy242, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy669); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 166: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy242 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 167: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy242 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy242, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 168: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy242 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy242, &yymsp[-2].minor.yy669, yymsp[0].minor.yy242); }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 170: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 466: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==466);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-1].minor.yy174, yymsp[0].minor.yy242); }
  yymsp[-1].minor.yy174 = yylhsminor.yy174;
        break;
      case 171: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy242 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy777, yymsp[-8].minor.yy242, yymsp[-6].minor.yy242, yymsp[-5].minor.yy174, yymsp[-2].minor.yy174, yymsp[0].minor.yy242); }
  yymsp[-9].minor.yy242 = yylhsminor.yy242;
        break;
      case 174: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy242 = createDropTableClause(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy242); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 175: /* specific_cols_opt ::= */
      case 206: /* tags_def_opt ::= */ yytestcase(yyruleno==206);
      case 278: /* tag_list_opt ::= */ yytestcase(yyruleno==278);
      case 336: /* col_list_opt ::= */ yytestcase(yyruleno==336);
      case 338: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==338);
      case 529: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==529);
      case 554: /* group_by_clause_opt ::= */ yytestcase(yyruleno==554);
      case 573: /* order_by_clause_opt ::= */ yytestcase(yyruleno==573);
{ yymsp[1].minor.yy174 = NULL; }
        break;
      case 176: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 337: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==337);
{ yymsp[-2].minor.yy174 = yymsp[-1].minor.yy174; }
        break;
      case 177: /* full_table_name ::= table_name */
{ yylhsminor.yy242 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy669, NULL); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 178: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy242 = createRealTableNode(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 181: /* column_def ::= column_name type_name */
{ yylhsminor.yy242 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy669, yymsp[0].minor.yy794, NULL); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 182: /* type_name ::= BOOL */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 183: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 184: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 185: /* type_name ::= INT */
      case 186: /* type_name ::= INTEGER */ yytestcase(yyruleno==186);
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 187: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 188: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 189: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 190: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 191: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 192: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 193: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 194: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 195: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 196: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy794 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 197: /* type_name ::= JSON */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 198: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 199: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 200: /* type_name ::= BLOB */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 201: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 202: /* type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createVarLenDataType(TSDB_DATA_TYPE_GEOMETRY, &yymsp[-1].minor.yy0); }
        break;
      case 203: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy794 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 204: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy794 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 205: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy794 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 207: /* tags_def_opt ::= tags_def */
      case 339: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==339);
      case 458: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==458);
{ yylhsminor.yy174 = yymsp[0].minor.yy174; }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 208: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 340: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==340);
{ yymsp[-3].minor.yy174 = yymsp[-1].minor.yy174; }
        break;
      case 209: /* table_options ::= */
{ yymsp[1].minor.yy242 = createDefaultTableOptions(pCxt); }
        break;
      case 210: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 211: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 212: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 213: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-4].minor.yy242, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy174); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 214: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 215: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-4].minor.yy242, TABLE_OPTION_SMA, yymsp[-1].minor.yy174); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 216: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-2].minor.yy242, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy174); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 217: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy242 = createAlterTableOptions(pCxt); yylhsminor.yy242 = setTableOption(pCxt, yylhsminor.yy242, yymsp[0].minor.yy535.type, &yymsp[0].minor.yy535.val); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 218: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy242 = setTableOption(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy535.type, &yymsp[0].minor.yy535.val); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 219: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy535.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 220: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy535.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy535.val = yymsp[0].minor.yy0; }
        break;
      case 221: /* duration_list ::= duration_literal */
      case 422: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==422);
{ yylhsminor.yy174 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 222: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 423: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==423);
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 225: /* rollup_func_name ::= function_name */
{ yylhsminor.yy242 = createFunctionNode(pCxt, &yymsp[0].minor.yy669, NULL); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 226: /* rollup_func_name ::= FIRST */
      case 227: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==227);
      case 282: /* tag_item ::= QTAGS */ yytestcase(yyruleno==282);
{ yylhsminor.yy242 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 230: /* col_name ::= column_name */
      case 283: /* tag_item ::= column_name */ yytestcase(yyruleno==283);
{ yylhsminor.yy242 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy669); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 231: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 233: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 235: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, OP_TYPE_LIKE); }
        break;
      case 236: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, OP_TYPE_LIKE); }
        break;
      case 237: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy242, NULL, OP_TYPE_LIKE); }
        break;
      case 238: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 239: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 240: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy242, yymsp[-1].minor.yy242, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 243: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 244: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 245: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 246: /* cmd ::= SHOW LICENCES */
      case 247: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==247);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 248: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 249: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy242); }
        break;
      case 250: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy242); }
        break;
      case 251: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 252: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 253: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 254: /* cmd ::= SHOW VARIABLES */
      case 255: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==255);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 256: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 257: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy242); }
        break;
      case 258: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 259: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 260: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 261: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 262: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy242); }
        break;
      case 263: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 264: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 265: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy242, yymsp[-1].minor.yy242, OP_TYPE_EQUAL); }
        break;
      case 266: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy242, yymsp[-3].minor.yy174); }
        break;
      case 267: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 268: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 269: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy242,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 270: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 271: /* db_name_cond_opt ::= */
      case 276: /* from_db_opt ::= */ yytestcase(yyruleno==276);
{ yymsp[1].minor.yy242 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 272: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy242 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 274: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 275: /* table_name_cond ::= table_name */
{ yylhsminor.yy242 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy669); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 277: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy242 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy669); }
        break;
      case 281: /* tag_item ::= TBNAME */
{ yylhsminor.yy242 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 284: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy242 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy669), &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 285: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy242 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy669), &yymsp[0].minor.yy669); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 286: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy777, yymsp[-3].minor.yy242, yymsp[-1].minor.yy242, NULL, yymsp[0].minor.yy242); }
        break;
      case 287: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy777, yymsp[-5].minor.yy242, yymsp[-3].minor.yy242, yymsp[-1].minor.yy174, NULL); }
        break;
      case 288: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy242); }
        break;
      case 289: /* full_index_name ::= index_name */
{ yylhsminor.yy242 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy669); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 290: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy242 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 291: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy242 = createIndexOption(pCxt, yymsp[-7].minor.yy174, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), NULL, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 292: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy242 = createIndexOption(pCxt, yymsp[-9].minor.yy174, releaseRawExprNode(pCxt, yymsp[-5].minor.yy242), releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 295: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy242 = createFunctionNode(pCxt, &yymsp[-3].minor.yy669, yymsp[-1].minor.yy174); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 296: /* sma_func_name ::= function_name */
      case 509: /* alias_opt ::= table_alias */ yytestcase(yyruleno==509);
{ yylhsminor.yy669 = yymsp[0].minor.yy669; }
  yymsp[0].minor.yy669 = yylhsminor.yy669;
        break;
      case 301: /* sma_stream_opt ::= */
      case 341: /* stream_options ::= */ yytestcase(yyruleno==341);
{ yymsp[1].minor.yy242 = createStreamOptions(pCxt); }
        break;
      case 302: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy242)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); yylhsminor.yy242 = yymsp[-2].minor.yy242; }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 303: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy242)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); yylhsminor.yy242 = yymsp[-2].minor.yy242; }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 304: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy242)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); yylhsminor.yy242 = yymsp[-2].minor.yy242; }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 305: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy777, &yymsp[-2].minor.yy669, yymsp[0].minor.yy242); }
        break;
      case 306: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy777, &yymsp[-3].minor.yy669, &yymsp[0].minor.yy669, false); }
        break;
      case 307: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy777, &yymsp[-5].minor.yy669, &yymsp[0].minor.yy669, true); }
        break;
      case 308: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy777, &yymsp[-3].minor.yy669, yymsp[0].minor.yy242, false); }
        break;
      case 309: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy777, &yymsp[-5].minor.yy669, yymsp[0].minor.yy242, true); }
        break;
      case 310: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 311: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy777, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669); }
        break;
      case 312: /* cmd ::= DESC full_table_name */
      case 313: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==313);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy242); }
        break;
      case 314: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 315: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 316: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==316);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy777, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 319: /* explain_options ::= */
{ yymsp[1].minor.yy242 = createDefaultExplainOptions(pCxt); }
        break;
      case 320: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy242 = setExplainVerbose(pCxt, yymsp[-2].minor.yy242, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 321: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy242 = setExplainRatio(pCxt, yymsp[-2].minor.yy242, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 322: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy777, yymsp[-9].minor.yy777, &yymsp[-6].minor.yy669, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy794, yymsp[-1].minor.yy120, &yymsp[0].minor.yy669, yymsp[-10].minor.yy777); }
        break;
      case 323: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 328: /* language_opt ::= */
{ yymsp[1].minor.yy669 = nil_token; }
        break;
      case 329: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy669 = yymsp[0].minor.yy0; }
        break;
      case 332: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy777, &yymsp[-8].minor.yy669, yymsp[-5].minor.yy242, yymsp[-7].minor.yy242, yymsp[-3].minor.yy174, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, yymsp[-4].minor.yy174); }
        break;
      case 333: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 334: /* cmd ::= PAUSE STREAM exists_opt stream_name */
{ pCxt->pRootNode = createPauseStreamStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 335: /* cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
{ pCxt->pRootNode = createResumeStreamStmt(pCxt, yymsp[-2].minor.yy777, yymsp[-1].minor.yy777, &yymsp[0].minor.yy669); }
        break;
      case 342: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 343: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==343);
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 344: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-3].minor.yy242, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 345: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 346: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-3].minor.yy242, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 347: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 348: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-2].minor.yy242, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 349: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy242 = setStreamOptions(pCxt, yymsp[-3].minor.yy242, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 351: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 543: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==543);
      case 563: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==563);
{ yymsp[-3].minor.yy242 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy242); }
        break;
      case 354: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 355: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 356: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 357: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 358: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 359: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 360: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy174); }
        break;
      case 361: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 362: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy174 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 364: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 367: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy242 = createInsertStmt(pCxt, yymsp[-4].minor.yy242, yymsp[-2].minor.yy174, yymsp[0].minor.yy242); }
        break;
      case 368: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy242 = createInsertStmt(pCxt, yymsp[-1].minor.yy242, NULL, yymsp[0].minor.yy242); }
        break;
      case 369: /* literal ::= NK_INTEGER */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 370: /* literal ::= NK_FLOAT */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 371: /* literal ::= NK_STRING */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 372: /* literal ::= NK_BOOL */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 373: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 374: /* literal ::= duration_literal */
      case 384: /* signed_literal ::= signed */ yytestcase(yyruleno==384);
      case 405: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==405);
      case 406: /* expression ::= literal */ yytestcase(yyruleno==406);
      case 407: /* expression ::= pseudo_column */ yytestcase(yyruleno==407);
      case 408: /* expression ::= column_reference */ yytestcase(yyruleno==408);
      case 409: /* expression ::= function_expression */ yytestcase(yyruleno==409);
      case 410: /* expression ::= case_when_expression */ yytestcase(yyruleno==410);
      case 441: /* function_expression ::= literal_func */ yytestcase(yyruleno==441);
      case 490: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==490);
      case 494: /* boolean_primary ::= predicate */ yytestcase(yyruleno==494);
      case 496: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==496);
      case 497: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==497);
      case 500: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==500);
      case 502: /* table_reference ::= table_primary */ yytestcase(yyruleno==502);
      case 503: /* table_reference ::= joined_table */ yytestcase(yyruleno==503);
      case 507: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==507);
      case 565: /* query_simple ::= query_specification */ yytestcase(yyruleno==565);
      case 566: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==566);
      case 569: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==569);
      case 571: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==571);
{ yylhsminor.yy242 = yymsp[0].minor.yy242; }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 375: /* literal ::= NULL */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 376: /* literal ::= NK_QUESTION */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 377: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 378: /* signed ::= NK_INTEGER */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 379: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 380: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 381: /* signed ::= NK_FLOAT */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 382: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 383: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 385: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 386: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 387: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 388: /* signed_literal ::= duration_literal */
      case 390: /* signed_literal ::= literal_func */ yytestcase(yyruleno==390);
      case 461: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==461);
      case 523: /* select_item ::= common_expression */ yytestcase(yyruleno==523);
      case 533: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==533);
      case 570: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==570);
      case 572: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==572);
      case 585: /* search_condition ::= common_expression */ yytestcase(yyruleno==585);
{ yylhsminor.yy242 = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 389: /* signed_literal ::= NULL */
{ yylhsminor.yy242 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 391: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy242 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 411: /* expression ::= NK_LP expression NK_RP */
      case 495: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==495);
      case 584: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==584);
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 412: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy242));
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 413: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy242), NULL));
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 414: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 415: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 416: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 417: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 418: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 419: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 420: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 421: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 424: /* column_reference ::= column_name */
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy669, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy669)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 425: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669, createColumnNode(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy669)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 426: /* pseudo_column ::= ROWTS */
      case 427: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==427);
      case 429: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==429);
      case 430: /* pseudo_column ::= QEND */ yytestcase(yyruleno==430);
      case 431: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==431);
      case 432: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==432);
      case 433: /* pseudo_column ::= WEND */ yytestcase(yyruleno==433);
      case 434: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==434);
      case 435: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==435);
      case 436: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==436);
      case 437: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==437);
      case 443: /* literal_func ::= NOW */ yytestcase(yyruleno==443);
{ yylhsminor.yy242 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 428: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy669)))); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 438: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 439: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==439);
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy669, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy669, yymsp[-1].minor.yy174)); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 440: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-1].minor.yy794)); }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 442: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy669, NULL)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 457: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy174 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 462: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 526: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==526);
{ yylhsminor.yy242 = createColumnNode(pCxt, &yymsp[-2].minor.yy669, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 463: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy174, yymsp[-1].minor.yy242)); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 464: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-2].minor.yy174, yymsp[-1].minor.yy242)); }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 467: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy242 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)); }
        break;
      case 469: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy242 = releaseRawExprNode(pCxt, yymsp[0].minor.yy242); }
        break;
      case 470: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 475: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==475);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy70, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 471: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy242), releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-4].minor.yy242 = yylhsminor.yy242;
        break;
      case 472: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy242), releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 473: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), NULL));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 474: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), NULL));
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 476: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy70 = OP_TYPE_LOWER_THAN; }
        break;
      case 477: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy70 = OP_TYPE_GREATER_THAN; }
        break;
      case 478: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy70 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 479: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy70 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 480: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy70 = OP_TYPE_NOT_EQUAL; }
        break;
      case 481: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy70 = OP_TYPE_EQUAL; }
        break;
      case 482: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy70 = OP_TYPE_LIKE; }
        break;
      case 483: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy70 = OP_TYPE_NOT_LIKE; }
        break;
      case 484: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy70 = OP_TYPE_MATCH; }
        break;
      case 485: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy70 = OP_TYPE_NMATCH; }
        break;
      case 486: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy70 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 487: /* in_op ::= IN */
{ yymsp[0].minor.yy70 = OP_TYPE_IN; }
        break;
      case 488: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy70 = OP_TYPE_NOT_IN; }
        break;
      case 489: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy174)); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 491: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy242), NULL));
                                                                                  }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 492: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 493: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy242);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy242);
                                                                                    yylhsminor.yy242 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), releaseRawExprNode(pCxt, yymsp[0].minor.yy242)));
                                                                                  }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 501: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy242 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, NULL); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 504: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy242 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 505: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy242 = createRealTableNode(pCxt, &yymsp[-3].minor.yy669, &yymsp[-1].minor.yy669, &yymsp[0].minor.yy669); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 506: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy242 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242), &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 508: /* alias_opt ::= */
{ yymsp[1].minor.yy669 = nil_token;  }
        break;
      case 510: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy669 = yymsp[0].minor.yy669; }
        break;
      case 511: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 512: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==512);
{ yymsp[-2].minor.yy242 = yymsp[-1].minor.yy242; }
        break;
      case 513: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy242 = createJoinTableNode(pCxt, yymsp[-4].minor.yy482, yymsp[-5].minor.yy242, yymsp[-2].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-5].minor.yy242 = yylhsminor.yy242;
        break;
      case 514: /* join_type ::= */
{ yymsp[1].minor.yy482 = JOIN_TYPE_INNER; }
        break;
      case 515: /* join_type ::= INNER */
{ yymsp[0].minor.yy482 = JOIN_TYPE_INNER; }
        break;
      case 516: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy242 = createSelectStmt(pCxt, yymsp[-10].minor.yy777, yymsp[-9].minor.yy174, yymsp[-8].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addWhereClause(pCxt, yymsp[-11].minor.yy242, yymsp[-7].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addPartitionByClause(pCxt, yymsp[-11].minor.yy242, yymsp[-6].minor.yy174);
                                                                                    yymsp[-11].minor.yy242 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy242, yymsp[-2].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addGroupByClause(pCxt, yymsp[-11].minor.yy242, yymsp[-1].minor.yy174);
                                                                                    yymsp[-11].minor.yy242 = addHavingClause(pCxt, yymsp[-11].minor.yy242, yymsp[0].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addRangeClause(pCxt, yymsp[-11].minor.yy242, yymsp[-5].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addEveryClause(pCxt, yymsp[-11].minor.yy242, yymsp[-4].minor.yy242);
                                                                                    yymsp[-11].minor.yy242 = addFillClause(pCxt, yymsp[-11].minor.yy242, yymsp[-3].minor.yy242);
                                                                                  }
        break;
      case 519: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy777 = false; }
        break;
      case 522: /* select_item ::= NK_STAR */
{ yylhsminor.yy242 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy242 = yylhsminor.yy242;
        break;
      case 524: /* select_item ::= common_expression column_alias */
      case 534: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==534);
{ yylhsminor.yy242 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242), &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy242 = yylhsminor.yy242;
        break;
      case 525: /* select_item ::= common_expression AS column_alias */
      case 535: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==535);
{ yylhsminor.yy242 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), &yymsp[0].minor.yy669); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 530: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 555: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==555);
      case 574: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==574);
{ yymsp[-2].minor.yy174 = yymsp[0].minor.yy174; }
        break;
      case 537: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy242 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
        break;
      case 538: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy242 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
        break;
      case 539: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy242 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), NULL, yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 540: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy242 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy242), releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), yymsp[-1].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 541: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy242 = createEventWindowNode(pCxt, yymsp[-3].minor.yy242, yymsp[0].minor.yy242); }
        break;
      case 545: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy242 = createFillNode(pCxt, yymsp[-1].minor.yy204, NULL); }
        break;
      case 546: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy242 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy174)); }
        break;
      case 547: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy242 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy174)); }
        break;
      case 548: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy204 = FILL_MODE_NONE; }
        break;
      case 549: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy204 = FILL_MODE_PREV; }
        break;
      case 550: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy204 = FILL_MODE_NULL; }
        break;
      case 551: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy204 = FILL_MODE_NULL_F; }
        break;
      case 552: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy204 = FILL_MODE_LINEAR; }
        break;
      case 553: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy204 = FILL_MODE_NEXT; }
        break;
      case 556: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy174 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); }
  yymsp[0].minor.yy174 = yylhsminor.yy174;
        break;
      case 557: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy174 = addNodeToList(pCxt, yymsp[-2].minor.yy174, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy242))); }
  yymsp[-2].minor.yy174 = yylhsminor.yy174;
        break;
      case 561: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy242 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy242), releaseRawExprNode(pCxt, yymsp[-1].minor.yy242)); }
        break;
      case 564: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy242 = addOrderByClause(pCxt, yymsp[-3].minor.yy242, yymsp[-2].minor.yy174);
                                                                                    yylhsminor.yy242 = addSlimitClause(pCxt, yylhsminor.yy242, yymsp[-1].minor.yy242);
                                                                                    yylhsminor.yy242 = addLimitClause(pCxt, yylhsminor.yy242, yymsp[0].minor.yy242);
                                                                                  }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 567: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy242 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-3].minor.yy242 = yylhsminor.yy242;
        break;
      case 568: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy242 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy242, yymsp[0].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 576: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 580: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==580);
{ yymsp[-1].minor.yy242 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 577: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 581: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==581);
{ yymsp[-3].minor.yy242 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 578: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 582: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==582);
{ yymsp[-3].minor.yy242 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 583: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy242 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy242); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 588: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy242 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy242), yymsp[-1].minor.yy48, yymsp[0].minor.yy687); }
  yymsp[-2].minor.yy242 = yylhsminor.yy242;
        break;
      case 589: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy48 = ORDER_ASC; }
        break;
      case 590: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy48 = ORDER_ASC; }
        break;
      case 591: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy48 = ORDER_DESC; }
        break;
      case 592: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy687 = NULL_ORDER_DEFAULT; }
        break;
      case 593: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy687 = NULL_ORDER_FIRST; }
        break;
      case 594: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy687 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
