###################################################################
#           Copyright (c) 2021 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
from util.log import *
from util.cases import *
from util.sql import *


class TDTestCase:
    def caseDescription(self):
        '''
        case1<Ganlin Zhao>: [TD-11220]<feature>: time related functions
        '''
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def getBuildPath(self):
        selfPath = os.path.dirname(os.path.realpath(__file__))

        if ("community" in selfPath):
            projPath = selfPath[:selfPath.find("community")]
        else:
            projPath = selfPath[:selfPath.find("tests")]

        for root, dirs, files in os.walk(projPath):
            if ("taosd" in files):
                rootRealPath = os.path.dirname(os.path.realpath(root))
                if ("packaging" not in rootRealPath):
                    buildPath = root[:len(root) - len("/build/bin")]
                    break
        return buildPath

    def getUnixTimestamp(self, time_str, precision = None, db_precision = "m", tz = False, delta = datetime.timedelta(hours = 8)):

        if precision == "m":
            if tz == True:
                pattern = "%Y-%m-%d %H:%M:%S.%f%z"
            else:
                pattern = "%Y-%m-%d %H:%M:%S.%f"
            if (time_str.find('T') != -1):
                pattern = pattern.replace(' ', 'T')
            dt_obj = datetime.datetime.strptime(time_str, pattern)
            if db_precision == "m":
                return int(dt_obj.timestamp() * 1000)
            elif db_precision == "u":
                #return int(dt_obj.timestamp() * 1000 * 1000)
                return int(int(dt_obj.timestamp() * 1000) * 1000)
            elif db_precision == "n":
                #return int(dt_obj.timestamp() * 1000 * 1000000)
                return int(int(dt_obj.timestamp() * 1000) * 1000000)
        elif precision == "u":
            if tz == True:
                pattern = "%Y-%m-%d %H:%M:%S.%f%z"
            else:
                pattern = "%Y-%m-%d %H:%M:%S.%f"
            if (time_str.find('T') != -1):
                pattern = pattern.replace(' ', 'T')
            dt_obj = datetime.datetime.strptime(time_str, pattern)
            if db_precision == "m":
                return int(int(dt_obj.timestamp() * 1000000) / 1000)
            elif db_precision == "u":
                return int(dt_obj.timestamp() * 1000000)
            elif db_precision == "n":
                return int(int(dt_obj.timestamp() * 1000000) * 1000)
        elif precision == "n":
            if tz == True:
                digits = time_str[-8:-5]
                time_str_new = time_str[:-8] + time_str[-5:]
                pattern = "%Y-%m-%d %H:%M:%S.%f%z"
            else:
                digits = time_str[-3:]
                time_str_new = time_str[:-3]
                pattern =  "%Y-%m-%d %H:%M:%S.%f"
            if (time_str.find('T') != -1):
                pattern = pattern.replace(' ', 'T')
            dt_obj = datetime.datetime.strptime(time_str_new, pattern)
            res = int(dt_obj.timestamp() * 1000000000) + int(digits)
            if db_precision == "m":
                return int(res / 1000000)
            elif db_precision == "u":
                return int(res / 1000)
            elif db_precision == "n":
                return int(res)
        else:
            if tz == True:
                pattern = "%Y-%m-%d %H:%M:%S%z"
            else:
                pattern = "%Y-%m-%d %H:%M:%S"
            if (time_str.find('T') != -1):
                pattern = pattern.replace(' ', 'T')
            dt_obj = datetime.datetime.strptime(time_str, pattern)
            if db_precision == "m":
                return int(dt_obj.timestamp() * 1000 )
            elif db_precision == "u":
                return int(dt_obj.timestamp() * 1000000)
            elif db_precision == "n":
                return int(dt_obj.timestamp() * 1000000000)

    def checkTimestampEqual(self, elm, expect_elm):
        caller = inspect.getframeinfo(inspect.stack()[1][0])
        if len(elm) == len(expect_elm):
            delta = abs(int(elm[-1]) - int(expect_elm[-1]))
            if delta == 1: #ignore 1 second diff
                new_elm = expect_elm[0:-1] + elm[-1]
            else:
                new_elm = expect_elm;
            if elm == new_elm:
                tdLog.info("sql:%s, elm:%s == expect_elm:%s" % (tdSql.sql, elm, new_elm))
            else:
                args = (caller.filename, caller.lineno, tdSql.sql, elm, new_elm)
                tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)
        else:
            args = (caller.filename, caller.lineno, tdSql.sql, elm, expect_elm)
            tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)


    def run(self):
        print("running {}".format(__file__))

        #Prepare data
        #db precision "ms"
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(60), tag_nchar nchar(60));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        #db precision "us"
        tdSql.execute("drop database if exists db_u")
        tdSql.execute("create database if not exists db_u precision 'us'")
        tdSql.execute('use db_u')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(60), tag_nchar nchar(60));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        #db precision "ns"
        tdSql.execute("drop database if exists db_n")
        tdSql.execute("create database if not exists db_n precision 'ns'")
        tdSql.execute('use db_n')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(60), tag_nchar nchar(60));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        #execute query
        print("============== STEP 1: select to_unixtimestamp() with milliesecond db precision ================== ")

        tdSql.execute('use db_m')

        #ISO8601/RFC3339 format string as input
        ts = "2020-02-02 02:00:00"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        ts = "2020-02-02T02:00:00"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))

        ts = "2020-02-02 02:00:00+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        ts = "2020-02-02T02:00:00+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))

        ts = "2020-02-02 02:00:00-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        ts = "2020-02-02T02:00:00-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, tz = True))

        ts = "2020-02-02 02:00:00.123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m"))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m"))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m"))
        ts = "2020-02-02T02:00:00.123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m"))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m"))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m"))

        ts = "2020-02-02 02:00:00.123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        ts = "2020-02-02T02:00:00.123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))

        ts = "2020-02-02 02:00:00.123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        ts = "2020-02-02T02:00:00.123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", tz = True))

        ts = "2020-02-02 02:00:00.000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u"))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u"))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u"))
        ts = "2020-02-02T02:00:00.000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u"))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u"))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u"))

        ts = "2020-02-02 02:00:00.000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        ts = "2020-02-02T02:00:00.000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))

        ts = "2020-02-02 02:00:00.000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        ts = "2020-02-02T02:00:00.000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", tz = True))

        ts = "2020-02-02 02:00:00.000000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n"))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n"))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n"))
        ts = "2020-02-02T02:00:00.000000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n"))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n"))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n"))

        ts = "2020-02-02 02:00:00.000000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        ts = "2020-02-02T02:00:00.000000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))

        ts = "2020-02-02 02:00:00.000000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        ts = "2020-02-02T02:00:00.000000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", tz = True))

        #binary/nchar column as input
        tdSql.execute("insert into ctb values ('2022-02-02T02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00', '2022-02-02T02:00:00');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00+0000', '2022-02-02 02:00:00+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.003', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00+0000', '2022-02-02T02:00:00+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.004', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00-0800', '2022-02-02 02:00:00-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.005', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00-0800', '2022-02-02T02:00:00-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.006', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123', '2022-02-02 02:00:00.123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.007', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123', '2022-02-02T02:00:00.123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.008', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123+0000', '2022-02-02 02:00:00.123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.009', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123+0000', '2022-02-02T02:00:00.123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.010', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123-0800', '2022-02-02 02:00:00.123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.011', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123-0800', '2022-02-02T02:00:00.123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.012', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123', '2022-02-02 02:00:00.000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.013', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123', '2022-02-02T02:00:00.000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.014', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123+0000', '2022-02-02 02:00:00.000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.015', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123+0000', '2022-02-02T02:00:00.000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.016', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123-0800', '2022-02-02 02:00:00.000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.017', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123-0800', '2022-02-02T02:00:00.000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.018', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123', '2022-02-02 02:00:00.000000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.019', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123', '2022-02-02T02:00:00.000000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.020', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123+0000', '2022-02-02 02:00:00.000000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.021', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123+0000', '2022-02-02T02:00:00.000000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.022', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123-0800', '2022-02-02 02:00:00.000000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.023', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123-0800', '2022-02-02T02:00:00.000000123-0800');")

        tdSql.execute("insert into tb values ('2022-02-02T02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00', '2022-02-02T02:00:00');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00+0000', '2022-02-02 02:00:00+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.003', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00+0000', '2022-02-02T02:00:00+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.004', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00-0800', '2022-02-02 02:00:00-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.005', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00-0800', '2022-02-02T02:00:00-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.006', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123', '2022-02-02 02:00:00.123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.007', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123', '2022-02-02T02:00:00.123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.008', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123+0000', '2022-02-02 02:00:00.123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.009', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123+0000', '2022-02-02T02:00:00.123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.010', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123-0800', '2022-02-02 02:00:00.123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.011', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123-0800', '2022-02-02T02:00:00.123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.012', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123', '2022-02-02 02:00:00.000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.013', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123', '2022-02-02T02:00:00.000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.014', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123+0000', '2022-02-02 02:00:00.000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.015', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123+0000', '2022-02-02T02:00:00.000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.016', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123-0800', '2022-02-02 02:00:00.000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.017', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123-0800', '2022-02-02T02:00:00.000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.018', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123', '2022-02-02 02:00:00.000000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.019', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123', '2022-02-02T02:00:00.000000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.020', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123+0000', '2022-02-02 02:00:00.000000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.021', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123+0000', '2022-02-02T02:00:00.000000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.022', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123-0800', '2022-02-02 02:00:00.000000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.023', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123-0800', '2022-02-02T02:00:00.000000123-0800');")

        #binary column
        tdSql.query("select count(col_binary) from tb")
        numRows = tdSql.getData(0, 0)
        tdSql.query("select col_binary from tb")
        col_binary = []
        for i in range(numRows):
            col_binary.append(tdSql.getData(i, 0))

        tdSql.query("select to_unixtimestamp(col_binary) from tb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0]))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1]))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m"))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m"))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u"))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u"))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n"))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n"))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", tz = True))

        tdSql.query("select to_unixtimestamp(col_binary) from ctb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0]))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1]))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m"))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m"))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u"))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u"))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n"))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n"))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", tz = True))

        tdSql.query("select to_unixtimestamp(col_binary) from stb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0]))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1]))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m"))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m"))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u"))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u"))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n"))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n"))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", tz = True))

        #nchar column
        tdSql.query("select count(col_nchar) from tb")
        numRows = tdSql.getData(0, 0)
        tdSql.query("select col_nchar from tb")
        col_nchar = []
        for i in range(numRows):
            col_nchar.append(tdSql.getData(i, 0))

        tdSql.query("select to_unixtimestamp(col_nchar) from tb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_nchar[0]))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_nchar[1]))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_nchar[2], tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_nchar[3], tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_nchar[4], tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_nchar[5], tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_nchar[6], "m"))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_nchar[7], "m"))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_nchar[8], "m", tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_nchar[9], "m", tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_nchar[10], "m", tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_nchar[11], "m", tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_nchar[12], "u"))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_nchar[13], "u"))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_nchar[14], "u", tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_nchar[15], "u", tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_nchar[16], "u", tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_nchar[17], "u", tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_nchar[18], "n"))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_nchar[19], "n"))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_nchar[20], "n", tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_nchar[21], "n", tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_nchar[22], "n", tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_nchar[23], "n", tz = True))

        tdSql.query("select to_unixtimestamp(col_nchar) from ctb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_nchar[0]))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_nchar[1]))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_nchar[2], tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_nchar[3], tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_nchar[4], tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_nchar[5], tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_nchar[6], "m"))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_nchar[7], "m"))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_nchar[8], "m", tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_nchar[9], "m", tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_nchar[10], "m", tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_nchar[11], "m", tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_nchar[12], "u"))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_nchar[13], "u"))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_nchar[14], "u", tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_nchar[15], "u", tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_nchar[16], "u", tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_nchar[17], "u", tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_nchar[18], "n"))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_nchar[19], "n"))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_nchar[20], "n", tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_nchar[21], "n", tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_nchar[22], "n", tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_nchar[23], "n", tz = True))

        tdSql.query("select to_unixtimestamp(col_nchar) from stb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_nchar[0]))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_nchar[1]))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_nchar[2], tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_nchar[3], tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_nchar[4], tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_nchar[5], tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_nchar[6], "m"))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_nchar[7], "m"))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_nchar[8], "m", tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_nchar[9], "m", tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_nchar[10], "m", tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_nchar[11], "m", tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_nchar[12], "u"))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_nchar[13], "u"))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_nchar[14], "u", tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_nchar[15], "u", tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_nchar[16], "u", tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_nchar[17], "u", tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_nchar[18], "n"))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_nchar[19], "n"))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_nchar[20], "n", tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_nchar[21], "n", tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_nchar[22], "n", tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_nchar[23], "n", tz = True))

        print("============== STEP 2: select to_unixtimestamp() with microsecond db precision ================== ")

        tdSql.execute('use db_u')

        db_prec = "u"
        #ISO8601/RFC3339 format string as input
        ts = "2020-02-02 02:00:00"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        ts = "2020-02-02T02:00:00"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))

        ts = "2020-02-02 02:00:00+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        ts = "2020-02-02T02:00:00.123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))

        ts = "2020-02-02 02:00:00.123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        ts = "2020-02-02T02:00:00.000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))

        ts = "2020-02-02 02:00:00.000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec ))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        ts = "2020-02-02T02:00:00.000000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))

        ts = "2020-02-02 02:00:00.000000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))

        #binary/nchar column as input
        tdSql.execute("insert into ctb values ('2022-02-02T02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00', '2022-02-02T02:00:00');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00+0000', '2022-02-02 02:00:00+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.003', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00+0000', '2022-02-02T02:00:00+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.004', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00-0800', '2022-02-02 02:00:00-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.005', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00-0800', '2022-02-02T02:00:00-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.006', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123', '2022-02-02 02:00:00.123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.007', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123', '2022-02-02T02:00:00.123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.008', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123+0000', '2022-02-02 02:00:00.123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.009', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123+0000', '2022-02-02T02:00:00.123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.010', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123-0800', '2022-02-02 02:00:00.123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.011', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123-0800', '2022-02-02T02:00:00.123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.012', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123', '2022-02-02 02:00:00.000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.013', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123', '2022-02-02T02:00:00.000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.014', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123+0000', '2022-02-02 02:00:00.000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.015', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123+0000', '2022-02-02T02:00:00.000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.016', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123-0800', '2022-02-02 02:00:00.000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.017', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123-0800', '2022-02-02T02:00:00.000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.018', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123', '2022-02-02 02:00:00.000000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.019', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123', '2022-02-02T02:00:00.000000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.020', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123+0000', '2022-02-02 02:00:00.000000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.021', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123+0000', '2022-02-02T02:00:00.000000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.022', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123-0800', '2022-02-02 02:00:00.000000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.023', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123-0800', '2022-02-02T02:00:00.000000123-0800');")

        tdSql.execute("insert into tb values ('2022-02-02T02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00', '2022-02-02T02:00:00');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00+0000', '2022-02-02 02:00:00+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.003', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00+0000', '2022-02-02T02:00:00+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.004', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00-0800', '2022-02-02 02:00:00-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.005', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00-0800', '2022-02-02T02:00:00-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.006', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123', '2022-02-02 02:00:00.123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.007', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123', '2022-02-02T02:00:00.123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.008', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123+0000', '2022-02-02 02:00:00.123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.009', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123+0000', '2022-02-02T02:00:00.123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.010', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123-0800', '2022-02-02 02:00:00.123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.011', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123-0800', '2022-02-02T02:00:00.123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.012', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123', '2022-02-02 02:00:00.000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.013', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123', '2022-02-02T02:00:00.000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.014', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123+0000', '2022-02-02 02:00:00.000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.015', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123+0000', '2022-02-02T02:00:00.000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.016', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123-0800', '2022-02-02 02:00:00.000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.017', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123-0800', '2022-02-02T02:00:00.000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.018', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123', '2022-02-02 02:00:00.000000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.019', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123', '2022-02-02T02:00:00.000000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.020', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123+0000', '2022-02-02 02:00:00.000000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.021', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123+0000', '2022-02-02T02:00:00.000000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.022', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123-0800', '2022-02-02 02:00:00.000000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.023', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123-0800', '2022-02-02T02:00:00.000000123-0800');")

        #binary column
        tdSql.query("select count(col_binary) from tb")
        numRows = tdSql.getData(0, 0)
        tdSql.query("select col_binary from tb")
        col_binary = []
        for i in range(numRows):
            col_binary.append(tdSql.getData(i, 0))

        tdSql.query("select to_unixtimestamp(col_binary) from tb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_binary) from ctb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_binary) from stb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        #nchar column
        tdSql.query("select count(col_nchar) from tb")
        numRows = tdSql.getData(0, 0)
        tdSql.query("select col_nchar from tb")
        col_nchar = []
        for i in range(numRows):
            col_nchar.append(tdSql.getData(i, 0))

        tdSql.query("select to_unixtimestamp(col_nchar) from tb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_nchar) from ctb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_nchar) from stb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        print("============== STEP 3: select to_unixtimestamp() with nanosecond db precision ================== ")

        tdSql.execute('use db_n')

        db_prec = "n"
        #ISO8601/RFC3339 format string as input
        ts = "2020-02-02 02:00:00"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        ts = "2020-02-02T02:00:00"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec))

        ts = "2020-02-02 02:00:00+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        ts = "2020-02-02T02:00:00.123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec))

        ts = "2020-02-02 02:00:00.123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "m", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        ts = "2020-02-02T02:00:00.000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec))

        ts = "2020-02-02 02:00:00.000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "u", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec ))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        ts = "2020-02-02T02:00:00.000000123"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec))

        ts = "2020-02-02 02:00:00.000000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000000123+0000"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))

        ts = "2020-02-02 02:00:00.000000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        ts = "2020-02-02T02:00:00.000000123-0800"
        tdSql.query("select to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))
        tdSql.query("select to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts, "n", db_precision = db_prec, tz = True))

        #binary/nchar column as input
        tdSql.execute("insert into ctb values ('2022-02-02T02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00', '2022-02-02T02:00:00');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00+0000', '2022-02-02 02:00:00+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.003', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00+0000', '2022-02-02T02:00:00+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.004', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00-0800', '2022-02-02 02:00:00-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.005', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00-0800', '2022-02-02T02:00:00-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.006', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123', '2022-02-02 02:00:00.123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.007', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123', '2022-02-02T02:00:00.123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.008', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123+0000', '2022-02-02 02:00:00.123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.009', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123+0000', '2022-02-02T02:00:00.123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.010', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123-0800', '2022-02-02 02:00:00.123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.011', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123-0800', '2022-02-02T02:00:00.123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.012', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123', '2022-02-02 02:00:00.000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.013', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123', '2022-02-02T02:00:00.000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.014', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123+0000', '2022-02-02 02:00:00.000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.015', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123+0000', '2022-02-02T02:00:00.000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.016', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123-0800', '2022-02-02 02:00:00.000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.017', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123-0800', '2022-02-02T02:00:00.000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.018', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123', '2022-02-02 02:00:00.000000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.019', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123', '2022-02-02T02:00:00.000000123');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.020', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123+0000', '2022-02-02 02:00:00.000000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.021', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123+0000', '2022-02-02T02:00:00.000000123+0000');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.022', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123-0800', '2022-02-02 02:00:00.000000123-0800');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.023', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123-0800', '2022-02-02T02:00:00.000000123-0800');")

        tdSql.execute("insert into tb values ('2022-02-02T02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00', '2022-02-02T02:00:00');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00+0000', '2022-02-02 02:00:00+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.003', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00+0000', '2022-02-02T02:00:00+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.004', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00-0800', '2022-02-02 02:00:00-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.005', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00-0800', '2022-02-02T02:00:00-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.006', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123', '2022-02-02 02:00:00.123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.007', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123', '2022-02-02T02:00:00.123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.008', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123+0000', '2022-02-02 02:00:00.123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.009', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123+0000', '2022-02-02T02:00:00.123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.010', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.123-0800', '2022-02-02 02:00:00.123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.011', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.123-0800', '2022-02-02T02:00:00.123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.012', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123', '2022-02-02 02:00:00.000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.013', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123', '2022-02-02T02:00:00.000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.014', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123+0000', '2022-02-02 02:00:00.000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.015', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123+0000', '2022-02-02T02:00:00.000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.016', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000123-0800', '2022-02-02 02:00:00.000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.017', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000123-0800', '2022-02-02T02:00:00.000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.018', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123', '2022-02-02 02:00:00.000000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.019', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123', '2022-02-02T02:00:00.000000123');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.020', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123+0000', '2022-02-02 02:00:00.000000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.021', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123+0000', '2022-02-02T02:00:00.000000123+0000');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.022', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00.000000123-0800', '2022-02-02 02:00:00.000000123-0800');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.023', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02T02:00:00.000000123-0800', '2022-02-02T02:00:00.000000123-0800');")

        #binary column
        tdSql.query("select count(col_binary) from tb")
        numRows = tdSql.getData(0, 0)
        tdSql.query("select col_binary from tb")
        col_binary = []
        for i in range(numRows):
            col_binary.append(tdSql.getData(i, 0))

        tdSql.query("select to_unixtimestamp(col_binary) from tb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_binary) from ctb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_binary) from stb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        #nchar column
        tdSql.query("select count(col_nchar) from tb")
        numRows = tdSql.getData(0, 0)
        tdSql.query("select col_nchar from tb")
        col_nchar = []
        for i in range(numRows):
            col_nchar.append(tdSql.getData(i, 0))

        tdSql.query("select to_unixtimestamp(col_nchar) from tb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_nchar) from ctb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        tdSql.query("select to_unixtimestamp(col_nchar) from stb")
        tdSql.checkRows(numRows)
        tdSql.checkData(0, 0, self.getUnixTimestamp(col_binary[0], db_precision = db_prec))
        tdSql.checkData(1, 0, self.getUnixTimestamp(col_binary[1], db_precision = db_prec))
        tdSql.checkData(2, 0, self.getUnixTimestamp(col_binary[2], db_precision = db_prec, tz = True))
        tdSql.checkData(3, 0, self.getUnixTimestamp(col_binary[3], db_precision = db_prec, tz = True))
        tdSql.checkData(4, 0, self.getUnixTimestamp(col_binary[4], db_precision = db_prec, tz = True))
        tdSql.checkData(5, 0, self.getUnixTimestamp(col_binary[5], db_precision = db_prec, tz = True))
        tdSql.checkData(6, 0, self.getUnixTimestamp(col_binary[6], "m", db_precision = db_prec))
        tdSql.checkData(7, 0, self.getUnixTimestamp(col_binary[7], "m", db_precision = db_prec))
        tdSql.checkData(8, 0, self.getUnixTimestamp(col_binary[8], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(9, 0, self.getUnixTimestamp(col_binary[9], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(10, 0, self.getUnixTimestamp(col_binary[10], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(11, 0, self.getUnixTimestamp(col_binary[11], "m", db_precision = db_prec, tz = True))
        tdSql.checkData(12, 0, self.getUnixTimestamp(col_binary[12], "u", db_precision = db_prec))
        tdSql.checkData(13, 0, self.getUnixTimestamp(col_binary[13], "u", db_precision = db_prec))
        tdSql.checkData(14, 0, self.getUnixTimestamp(col_binary[14], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(15, 0, self.getUnixTimestamp(col_binary[15], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(16, 0, self.getUnixTimestamp(col_binary[16], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(17, 0, self.getUnixTimestamp(col_binary[17], "u", db_precision = db_prec, tz = True))
        tdSql.checkData(18, 0, self.getUnixTimestamp(col_binary[18], "n", db_precision = db_prec))
        tdSql.checkData(19, 0, self.getUnixTimestamp(col_binary[19], "n", db_precision = db_prec))
        tdSql.checkData(20, 0, self.getUnixTimestamp(col_binary[20], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(21, 0, self.getUnixTimestamp(col_binary[21], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(22, 0, self.getUnixTimestamp(col_binary[22], "n", db_precision = db_prec, tz = True))
        tdSql.checkData(23, 0, self.getUnixTimestamp(col_binary[23], "n", db_precision = db_prec, tz = True))

        print("============== STEP 4: select to_unixtimestamp() other use cases ================== ")
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(60), tag_nchar nchar(60));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(60), col_nchar nchar(60));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        ts = "2020-02-02 02:00:00"
        #to_unixtimestamp(), col
        tdSql.query("select to_unixtimestamp('%s'),col_bigint from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)
        tdSql.query("select to_unixtimestamp('%s'),col_bigint from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)
        tdSql.query("select to_unixtimestamp('%s'),col_bigint from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)

        tdSql.query("select to_unixtimestamp('%s'),col_bool from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, True)
        tdSql.query("select to_unixtimestamp('%s'),col_bool from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, True)
        tdSql.query("select to_unixtimestamp('%s'),col_bool from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, True)

        tdSql.query("select to_unixtimestamp('%s'),col_float from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select to_unixtimestamp('%s'),col_float from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select to_unixtimestamp('%s'),col_float from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select to_unixtimestamp('%s'),col_binary from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "2022-02-02 02:00:00")
        tdSql.query("select to_unixtimestamp('%s'),col_binary from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "2022-02-02 02:00:00")
        tdSql.query("select to_unixtimestamp('%s'),col_binary from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "2022-02-02 02:00:00")

        tdSql.query("select ts, col_smallint, col_float, to_unixtimestamp('%s'), col_binary, col_timestamp from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 4, "2022-02-02 02:00:00")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, to_unixtimestamp('%s'), col_binary, col_timestamp from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 4, "2022-02-02 02:00:00")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, to_unixtimestamp('%s'), col_binary, col_timestamp from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 4, "2022-02-02 02:00:00")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #to_unixtimestamp(), tag
        tdSql.query("select to_unixtimestamp('%s'),tag_bigint from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)
        tdSql.query("select to_unixtimestamp('%s'),tag_bigint from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)

        tdSql.query("select to_unixtimestamp('%s'),tag_bool from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, True)
        tdSql.query("select to_unixtimestamp('%s'),tag_bool from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, True)

        tdSql.query("select to_unixtimestamp('%s'),tag_float from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select to_unixtimestamp('%s'),tag_float from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select to_unixtimestamp('%s'),tag_binary from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "2022-02-02 02:00:00")
        tdSql.query("select to_unixtimestamp('%s'),tag_binary from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "2022-02-02 02:00:00")

        tdSql.query("select tag_smallint, tag_float, to_unixtimestamp('%s'), tag_binary, tag_timestamp from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(0, 2, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 3, "2022-02-02 02:00:00")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select tag_smallint, tag_float, to_unixtimestamp('%s'), tag_binary, tag_timestamp from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(0, 2, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 3, "2022-02-02 02:00:00")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #to_unixtimestamp(),tbname
        tdSql.query("select to_unixtimestamp('%s'),tbname from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "tb")
        tdSql.query("select to_unixtimestamp('%s'),tbname from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "ctb")
        tdSql.query("select to_unixtimestamp('%s'),tbname from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, "ctb")

        #to_unixtimestamp(),_c0/_C0
        tdSql.query("select to_unixtimestamp('%s'),_c0 from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select to_unixtimestamp('%s'),_c0 from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select to_unixtimestamp('%s'),_c0 from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _C0,to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.query("select _C0,to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.query("select _C0,to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))

        #to_unixtimestamp(),func()
        #can only be used with scalar functions together
        tdSql.query("select to_unixtimestamp('%s'),ceil(col_bigint) from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)
        tdSql.query("select to_unixtimestamp('%s'),ceil(col_bigint) from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)
        tdSql.query("select to_unixtimestamp('%s'),ceil(col_bigint) from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1)

        tdSql.query("select to_unixtimestamp('%s'),round(col_float) from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select to_unixtimestamp('%s'),round(col_float) from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select to_unixtimestamp('%s'),round(col_float) from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select to_unixtimestamp('%s'),floor(1.5) from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select to_unixtimestamp('%s'),floor(1.5) from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select to_unixtimestamp('%s'),floor(1.5) from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select abs(-1),to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.query("select abs(-1),to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.query("select abs(-1),to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))

        tdSql.query("select pow(2,2),to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.query("select pow(2,2),to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.query("select pow(2,2),to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))

        #to_unixtimestamp(),to_unixtimestamp('%s')
        tdSql.query("select to_unixtimestamp('%s'),to_unixtimestamp('%s'),to_unixtimestamp('%s') from tb" %(ts, ts, ts))
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 2, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s'),to_unixtimestamp('%s'),to_unixtimestamp('%s') from ctb" %(ts, ts, ts))
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 2, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s'),to_unixtimestamp('%s'),to_unixtimestamp('%s') from stb" %(ts, ts, ts))
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 1, self.getUnixTimestamp(ts))
        tdSql.checkData(0, 2, self.getUnixTimestamp(ts))

        #to_unixtimestamp(),constant
        tdSql.query("select 123,123.0,true,'123',to_unixtimestamp('%s') from tb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, self.getUnixTimestamp(ts))
        tdSql.query("select 123,123.0,true,'123',to_unixtimestamp('%s') from ctb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, self.getUnixTimestamp(ts))
        tdSql.query("select 123,123.0,true,'123',to_unixtimestamp('%s') from stb" %ts)
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, self.getUnixTimestamp(ts))

        #insert some more data
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, '2022-02-02 02:00:00', '2022-02-02 02:00:00');")

        #order by
        tdSql.query("select to_unixtimestamp('%s') from tb order by ts" %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from ctb order by ts" %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from stb order by ts" %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        tdSql.query("select to_unixtimestamp('%s') from tb order by ts desc" %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from ctb order by ts desc" %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from stb order by ts desc" %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        #limit/offset
        tdSql.query("select to_unixtimestamp('%s') from tb limit 2" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from ctb limit 2" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from stb limit 2" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))

        tdSql.query("select to_unixtimestamp('%s') from tb limit 2 offset 1" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from ctb limit 2 offset 1" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from stb limit 2 offset 1" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))

        tdSql.query("select to_unixtimestamp('%s') from tb limit 1,2" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from ctb limit 1,2" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.query("select to_unixtimestamp('%s') from stb limit 1,2" %ts)
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))

        #join
        tdSql.execute("create stable stb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb1 using stb1 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("create stable stb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb2 using stb2 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.query('select to_unixtimestamp(\'%s\') from tb1, tb2 where tb1.col_timestamp = tb2.col_timestamp' %ts);
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        tdSql.query('select to_unixtimestamp(\'%s\') from ctb1, ctb2 where ctb1.col_timestamp = ctb2.col_timestamp' %ts);
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        tdSql.query('select to_unixtimestamp(\'%s\') from stb1, stb2 where stb1.col_timestamp = stb2.col_timestamp and stb1.tag_int = stb2.tag_int' %ts);
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        #union all
        tdSql.query('select to_unixtimestamp(\'%s\') from tb1 union all select to_unixtimestamp(\'%s\') from tb2' %(ts, ts))
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(3, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(4, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(5, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from ctb1 union all select to_unixtimestamp(\'%s\') from ctb2' %(ts, ts))
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(3, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(4, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(5, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from stb1 union all select to_unixtimestamp(\'%s\') from stb2' %(ts, ts))
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(3, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(4, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(5, 0, self.getUnixTimestamp(ts))

        #nested query
        tdSql.query('select to_unixtimestamp(\'%s\') from (select * from tb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from (select * from ctb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from (select * from stb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        tdSql.query('select to_unixtimestamp(\'%s\') from (select col_int as val from tb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from (select col_int as val from ctb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from (select col_int as val from stb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        tdSql.query('select * from (select to_unixtimestamp(\'%s\') from tb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select * from (select to_unixtimestamp(\'%s\') from ctb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select * from (select to_unixtimestamp(\'%s\') from stb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        tdSql.query('select _c0 from (select to_unixtimestamp(\'%s\') from tb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select _c0 from (select to_unixtimestamp(\'%s\') from ctb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select _c0 from (select to_unixtimestamp(\'%s\') from stb)' %ts)
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        tdSql.query('select to_unixtimestamp(\'%s\') from (select to_unixtimestamp(\'%s\') from tb)' %(ts, ts))
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from (select to_unixtimestamp(\'%s\') from ctb)' %(ts, ts))
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))
        tdSql.query('select to_unixtimestamp(\'%s\') from (select to_unixtimestamp(\'%s\') from stb)' %(ts, ts))
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(1, 0, self.getUnixTimestamp(ts))
        tdSql.checkData(2, 0, self.getUnixTimestamp(ts))

        ##ERROR CASES
        #param
        tdSql.error("select to_unixtimestamp(1.5) from tb")
        tdSql.error("select to_unixtimestamp(1.5) from ctb")
        tdSql.error("select to_unixtimestamp(1.5) from stb")
        tdSql.error("select to_unixtimestamp(true) from tb")
        tdSql.error("select to_unixtimestamp(true) from ctb")
        tdSql.error("select to_unixtimestamp(true) from stb")
        tdSql.error("select to_unixtimestamp(1.5) from tb")
        tdSql.error("select to_unixtimestamp(1.5) from ctb")
        tdSql.error("select to_unixtimestamp(1.5) from stb")
        tdSql.error("select to_unixtimestamp(*) from tb")
        tdSql.error("select to_unixtimestamp(*) from ctb")
        tdSql.error("select to_unixtimestamp(*) from stb")
        #tdSql.error("select to_unixtimestamp(tbname) from tb")
        #tdSql.error("select to_unixtimestamp(tbname) from ctb")
        #tdSql.error("select to_unixtimestamp(tbname) from stb")
        tdSql.error("select to_unixtimestamp(ts) from tb")
        tdSql.error("select to_unixtimestamp(ts) from ctb")
        tdSql.error("select to_unixtimestamp(ts) from stb")
        tdSql.error("select to_unixtimestamp(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(col_tinyint) from tb")
        tdSql.error("select to_unixtimestamp(col_tinyint) from ctb")
        tdSql.error("select to_unixtimestamp(col_tinyint) from stb")
        tdSql.error("select to_unixtimestamp(col_smallint) from tb")
        tdSql.error("select to_unixtimestamp(col_smallint) from ctb")
        tdSql.error("select to_unixtimestamp(col_smallint) from stb")
        tdSql.error("select to_unixtimestamp(col_int) from tb")
        tdSql.error("select to_unixtimestamp(col_int) from ctb")
        tdSql.error("select to_unixtimestamp(col_int) from stb")
        tdSql.error("select to_unixtimestamp(col_bigint) from tb")
        tdSql.error("select to_unixtimestamp(col_bigint) from ctb")
        tdSql.error("select to_unixtimestamp(col_bigint) from stb")
        tdSql.error("select to_unixtimestamp(col_float) from tb")
        tdSql.error("select to_unixtimestamp(col_float) from ctb")
        tdSql.error("select to_unixtimestamp(col_float) from stb")
        tdSql.error("select to_unixtimestamp(col_double) from tb")
        tdSql.error("select to_unixtimestamp(col_double) from ctb")
        tdSql.error("select to_unixtimestamp(col_double) from stb")
        tdSql.error("select to_unixtimestamp(col_bool) from tb")
        tdSql.error("select to_unixtimestamp(col_bool) from ctb")
        tdSql.error("select to_unixtimestamp(col_bool) from stb")
        tdSql.error("select to_unixtimestamp(tag_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(tag_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(tag_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(tag_tinyint) from tb")
        tdSql.error("select to_unixtimestamp(tag_tinyint) from ctb")
        tdSql.error("select to_unixtimestamp(tag_tinyint) from stb")
        tdSql.error("select to_unixtimestamp(tag_smallint) from tb")
        tdSql.error("select to_unixtimestamp(tag_smallint) from ctb")
        tdSql.error("select to_unixtimestamp(tag_smallint) from stb")
        tdSql.error("select to_unixtimestamp(tag_int) from tb")
        tdSql.error("select to_unixtimestamp(tag_int) from ctb")
        tdSql.error("select to_unixtimestamp(tag_int) from stb")
        tdSql.error("select to_unixtimestamp(tag_bigint) from tb")
        tdSql.error("select to_unixtimestamp(tag_bigint) from ctb")
        tdSql.error("select to_unixtimestamp(tag_bigint) from stb")
        tdSql.error("select to_unixtimestamp(tag_double) from tb")
        tdSql.error("select to_unixtimestamp(tag_double) from ctb")
        tdSql.error("select to_unixtimestamp(tag_double) from stb")
        tdSql.error("select to_unixtimestamp(tag_float) from tb")
        tdSql.error("select to_unixtimestamp(tag_float) from ctb")
        tdSql.error("select to_unixtimestamp(tag_float) from stb")
        tdSql.error("select to_unixtimestamp(tag_bool) from tb")
        tdSql.error("select to_unixtimestamp(tag_bool) from ctb")
        tdSql.error("select to_unixtimestamp(tag_bool) from stb")
        tdSql.error("select to_unixtimestamp(tag_binary) from tb")
        tdSql.error("select to_unixtimestamp(tag_binary) from ctb")
        tdSql.error("select to_unixtimestamp(tag_binary) from stb")
        tdSql.error("select to_unixtimestamp(tag_nchar) from tb")
        tdSql.error("select to_unixtimestamp(tag_nchar) from ctb")
        tdSql.error("select to_unixtimestamp(tag_nchar) from stb")
        tdSql.error("select to_unixtimestamp(1,'abc',col_bigint) from tb")
        tdSql.error("select to_unixtimestamp(1,'abc',col_bigint) from ctb")
        tdSql.error("select to_unixtimestamp(1,'abc',col_bigint) from stb")

        #distinct
        tdSql.error("select distinct to_unixtimestamp(col_binary) from tb")
        tdSql.error("select distinct to_unixtimestamp(col_binary) from ctb")
        tdSql.error("select distinct to_unixtimestamp(col_binary) from stb")


        #arithmetic
        tdSql.error("select to_unixtimestamp(col_binary) + count(*) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + count(*) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + count(*) from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + avg(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + avg(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + avg(col_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + sum(col_int) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + sum(col_int) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + sum(col_int) from stb")

        tdSql.error("select to_unixtimestamp(col_binary) + max(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + max(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + max(col_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + first(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + first(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + first(col_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + top(col_timestamp, 1) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + top(col_timestamp, 1) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + top(col_timestamp, 1) from stb")

        tdSql.error("select to_unixtimestamp(col_binary) + ceil(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + ceil(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + ceil(col_timestamp) from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + floor(col_int) from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + floor(col_int) from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + floor(col_int) from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + round(1.5) from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + round(1.5) from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + round(1.5) from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + diff(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + diff(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + diff(col_timestamp) from stb")

        #tdSql.error("select to_unixtimestamp(col_binary) + 1 from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + 1 from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + 1 from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + 1.5 from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + 1.5 from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + 1.5 from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + true from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + true from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + true from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 'abc' from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 'abc' from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 'abc' from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + abc from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + abc from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + abc from stb")

        tdSql.error("select to_unixtimestamp(col_binary) + col_binary from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_binary from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_binary from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_timestamp from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_timestamp from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_timestamp from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_tinyint from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_tinyint from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_tinyint from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_smallint from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_smallint from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_smallint from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_int from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_int from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_int from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_bigint from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_bigint from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_bigint from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_bool from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_bool from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_bool from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_float from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_float from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_float from stb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_double from tb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_double from ctb")
        #tdSql.error("select to_unixtimestamp(col_binary) + col_double from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_binary from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_binary from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_binary from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_nchar from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_nchar from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + col_nchar from stb")

        tdSql.error("select to_unixtimestamp(col_binary) + tag_timestamp from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_timestamp from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_timestamp from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_tinyint from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_tinyint from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_tinyint from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_smallint from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_smallint from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_smallint from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_int from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_int from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_int from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_bigint from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_bigint from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_bigint from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_bool from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_bool from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_bool from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_float from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_float from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_float from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_double from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_double from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_double from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_binary from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_binary from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_binary from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_nchar from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_nchar from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + tag_nchar from stb")

        tdSql.error("select to_unixtimestamp(col_binary) + 1b from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1b from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1b from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1u from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1u from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1u from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1a from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1a from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1a from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1s from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1s from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1s from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1m from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1m from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1m from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1h from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1h from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1h from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1d from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1d from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1d from stb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1w from tb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1w from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) + 1w from stb")

        tdSql.error("select to_unixtimestamp(col_binary) - 5b from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5b from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5b from stb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5u from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5u from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5u from stb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5a from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5a from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5a from stb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5s from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5s from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5s from stb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5m from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5m from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5m from stb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5h from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5h from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5h from stb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5d from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5d from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5d from stb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5w from tb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5w from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) - 5w from stb")

        tdSql.error("select to_unixtimestamp(col_binary) * 1d from tb")
        tdSql.error("select to_unixtimestamp(col_binary) * 1d from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) * 1d from stb")
        tdSql.error("select to_unixtimestamp(col_binary) / 5m from tb")
        tdSql.error("select to_unixtimestamp(col_binary) / 5m from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) / 5m from stb")
        tdSql.error("select to_unixtimestamp(col_binary) % 10h from tb")
        tdSql.error("select to_unixtimestamp(col_binary) % 10h from ctb")
        tdSql.error("select to_unixtimestamp(col_binary) % 10h from stb")

        #to_unixtimestamp(col_binary), func()
        tdSql.error("select to_unixtimestamp(col_binary),count(*) from tb")
        tdSql.error("select to_unixtimestamp(col_binary),count(*) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary),count(*) from stb")
        tdSql.error("select to_unixtimestamp(col_binary),avg(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary),avg(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary),avg(col_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(col_binary),sum(col_int) from tb")
        tdSql.error("select to_unixtimestamp(col_binary),sum(col_int) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary),sum(col_int) from stb")

        tdSql.error("select to_unixtimestamp(col_binary),max(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary),max(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary),max(col_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(col_binary),first(col_timestamp) from tb")
        tdSql.error("select to_unixtimestamp(col_binary),first(col_timestamp) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary),first(col_timestamp) from stb")
        tdSql.error("select to_unixtimestamp(col_binary),top(col_timestamp, 1) from tb")
        tdSql.error("select to_unixtimestamp(col_binary),top(col_timestamp, 1) from ctb")
        tdSql.error("select to_unixtimestamp(col_binary),top(col_timestamp, 1) from stb")

        #session
        tdSql.error("select to_unixtimestamp(col_binary) from tb session(col_binary, 1d)")
        tdSql.error("select to_unixtimestamp(col_binary) from ctb session(col_binary, 1h)")
        tdSql.error("select to_unixtimestamp(col_binary) from stb session(col_binary, 1m)")

        #state_window
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_timestamp);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_tinyint);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_smallint);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_int);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_bigint);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_bool);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_float);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_double);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_binary);')
        tdSql.error('select to_unixtimestamp(col_binary) from tb state_window(col_nchar);')

        #interval/sliding
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1y)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1n)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1w)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1d)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1h)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1s)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1y) sliding(1y)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1n) sliding(1n)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1w) sliding(1w)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1d) sliding(1d)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1h) sliding(1h)')
        tdSql.error('select to_unixtimestamp(col_binary) from tb interval(1s) sliding(1s)')

        #group by
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_binary;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_tinyint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_smallint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_int;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_bigint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_bool;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_float;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_double;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_binary;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by col_nchar;')

        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_tinyint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_smallint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_int;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_bigint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_bool;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_float;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_double;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_binary;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_nchar;')

        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tbname;')

        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_tinyint,col_tinyint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_smallint,col_smallint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_int,col_int;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_bigint,col_bigint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_bool,col_bool;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_float,col_float;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_double,col_double;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_binary,col_binary;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb group by tag_nchar,col_nchar;')

        #order by
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_tinyint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_tinyint desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_smallint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_smallint desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_int;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_int desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_bigint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_bigint desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_bool;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_bool desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_float;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_float desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_double;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_double desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_double;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by col_double desc;')

        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_tinyint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_tinyint desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_smallint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_smallint desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_int;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_int desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bigint;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bigint desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bool;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bool desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_float;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_float desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double desc;')

        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tbname;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tbname desc;')

        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_timestamp,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_timestamp,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_tinyint,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_tinyint,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_smallint,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_smallint,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_int,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_int,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bigint,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bigint,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bool,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_bool,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_float,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_float,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double,col_timestamp desc;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double,col_timestamp;')
        tdSql.error('select to_unixtimestamp(col_binary) from stb order by tag_double,col_timestamp desc;')

        tdSql.execute('drop database db_m')
        tdSql.execute('drop database db_u')
        tdSql.execute('drop database db_n')

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
