/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "os.h"
#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 336
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int32_t yy4;
  bool yy89;
  EFillMode yy102;
  SDataType yy112;
  SAlterOption yy221;
  ENullOrder yy361;
  EJoinType yy372;
  SNodeList* yy376;
  EOperatorType yy380;
  EOrder yy386;
  SNode* yy392;
  SToken yy449;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             572
#define YYNRULE              437
#define YYNTOKEN             222
#define YY_MAX_SHIFT         571
#define YY_MIN_SHIFTREDUCE   850
#define YY_MAX_SHIFTREDUCE   1286
#define YY_ERROR_ACTION      1287
#define YY_ACCEPT_ACTION     1288
#define YY_NO_ACTION         1289
#define YY_MIN_REDUCE        1290
#define YY_MAX_REDUCE        1726
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1960)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   270, 1593,  287,  472, 1577,  485,  282,  325,  469, 1505,
 /*    10 */  1288, 1401,   33,   31,   78, 1577,  124, 1563, 1302, 1563,
 /*    20 */   279,  383, 1106,   34,   32,   30,   29,   28, 1593, 1563,
 /*    30 */  1412, 1559, 1565, 1559, 1565,  469,  125,  250, 1104, 1593,
 /*    40 */  1369, 1705,  438, 1559, 1566,  468,  469, 1389,  445, 1549,
 /*    50 */    12,   33,   31, 1228, 1704,   54,  468, 1112, 1702,  279,
 /*    60 */  1549, 1106,  484,  295,  319,  449, 1577,  243, 1578,  471,
 /*    70 */  1580, 1581,  467,  105,  462,    1, 1408, 1104,   73, 1578,
 /*    80 */   471, 1580, 1581,  467,  525,  462, 1384,  290, 1643,   12,
 /*    90 */  1593,  484,  251, 1639, 1496, 1498, 1112,  448,  568,   26,
 /*   100 */   205,  362, 1705, 1705, 1705,  441,  421,  468,  107,  103,
 /*   110 */  1105, 1549,  516,  485,    1,  137,  137,  137, 1129, 1702,
 /*   120 */  1702, 1702,  323,  447,  133, 1650, 1651,  445, 1655,   74,
 /*   130 */  1578,  471, 1580, 1581,  467,  519,  462,  568, 1412, 1643,
 /*   140 */    54,  144,  485,  272, 1639,  132,   36,  940, 1107, 1105,
 /*   150 */   422,  324,  105,  100,  515,  514,  513,  201,  512, 1127,
 /*   160 */   439, 1407, 1130,  428, 1670,  435,  942, 1412,   52, 1110,
 /*   170 */  1111,   51, 1155, 1156, 1157, 1158, 1159, 1160, 1161,  464,
 /*   180 */  1166, 1167, 1168, 1169, 1170, 1171, 1172, 1107,  103, 1705,
 /*   190 */  1461,   34,   32,   30,   29,   28,  269,    9,    8,  138,
 /*   200 */    69, 1459,  137,  134, 1650, 1651, 1702, 1655, 1110, 1111,
 /*   210 */    65, 1155, 1156, 1157, 1158, 1159, 1160, 1161,  464, 1166,
 /*   220 */  1167, 1168, 1169, 1170, 1171, 1172,   33,   31,  138,  252,
 /*   230 */   227,  440,  436, 1442,  279,  249, 1106, 1127, 1577,  399,
 /*   240 */    63,  393,  521, 1461,  341,  398,   70,  353,  102,  284,
 /*   250 */   394,  392, 1104,  395, 1459, 1142,  354,  318,  391,  317,
 /*   260 */   106, 1405, 1593, 1190,   12,   33,   31, 1404, 1227,  469,
 /*   270 */   138, 1112, 1204,  279,   22, 1106, 1657,   56,  268,  468,
 /*   280 */  1252,  175,   24, 1549,   34,   32,   30,   29,   28,    1,
 /*   290 */  1657, 1104,   34,   32,   30,   29,   28,   30,   29,   28,
 /*   300 */  1654,   74, 1578,  471, 1580, 1581,  467,  128,  462,  138,
 /*   310 */  1112, 1643,  568, 1191, 1653,  272, 1639, 1717, 1453,  432,
 /*   320 */  1250, 1251, 1253, 1254, 1105,  413, 1677, 1390,    7, 1290,
 /*   330 */   352, 1196, 1128,  347,  346,  345,  344,  343,  138,  340,
 /*   340 */   339,  338,  337,  336,  332,  331,  330,  329,  328,  327,
 /*   350 */   326,  568,   59,   98,   97,   96,   95,   94,   93,   92,
 /*   360 */    91,   90, 1107, 1105, 1705, 1705,   25,  277, 1185, 1186,
 /*   370 */  1187, 1188, 1189, 1193, 1194, 1195,  362,  137, 1703, 1403,
 /*   380 */  1131, 1702, 1702, 1110, 1111,    6, 1155, 1156, 1157, 1158,
 /*   390 */  1159, 1160, 1161,  464, 1166, 1167, 1168, 1169, 1170, 1171,
 /*   400 */  1172, 1107,  524,  484,  452,   34,   32,   30,   29,   28,
 /*   410 */    89,  564,  563,   88,   87,   86,   85,   84,   83,   82,
 /*   420 */    81,   80, 1110, 1111, 1549, 1155, 1156, 1157, 1158, 1159,
 /*   430 */  1160, 1161,  464, 1166, 1167, 1168, 1169, 1170, 1171, 1172,
 /*   440 */    33,   31, 1173,  252, 1291,  536, 1313,  283,  279,  313,
 /*   450 */  1106,  289,  138,  485,  472,  122,  262,  101,   36,  122,
 /*   460 */  1506,  386,  333, 1414, 1226,   89, 1104, 1414,   88,   87,
 /*   470 */    86,   85,   84,   83,   82,   81,   80, 1190, 1412,   33,
 /*   480 */    31,   48,  101, 1387,  389, 1112,  386,  279, 1312, 1106,
 /*   490 */  1577, 1549,   34,   32,   30,   29,   28,  485,  485,  263,
 /*   500 */   200,  261,  260,    7,  385, 1104,   78,  334,  511,  389,
 /*   510 */   388,  387,  292,  390, 1593,   34,   32,   30,   29,   28,
 /*   520 */   122,  469, 1412, 1412, 1112,  485,  568, 1191, 1414, 1311,
 /*   530 */  1461,  468, 1493, 1549,  361, 1549,  291,  485, 1105,  146,
 /*   540 */  1223, 1459,    7, 1192,  107, 1196, 1409,  138,  516,  453,
 /*   550 */  1412,  397,  396,   74, 1578,  471, 1580, 1581,  467, 1461,
 /*   560 */   462, 1197, 1412, 1643, 1342,  568, 1132,  272, 1639, 1717,
 /*   570 */  1460,  519,  348, 1397, 1549, 1657, 1107, 1105, 1700, 1242,
 /*   580 */    25,  277, 1185, 1186, 1187, 1188, 1189, 1193, 1194, 1195,
 /*   590 */   515,  514,  513, 1577,  512, 1538,   23, 1110, 1111, 1652,
 /*   600 */  1155, 1156, 1157, 1158, 1159, 1160, 1161,  464, 1166, 1167,
 /*   610 */  1168, 1169, 1170, 1171, 1172, 1107,  399, 1593,  393,  148,
 /*   620 */   147, 1283,  398, 1310,  448,  102,  166,  394,  392,  164,
 /*   630 */   395,  302,  518,  517,  468,  391, 1110, 1111, 1549, 1155,
 /*   640 */  1156, 1157, 1158, 1159, 1160, 1161,  464, 1166, 1167, 1168,
 /*   650 */  1169, 1170, 1171, 1172,   33,   31,   74, 1578,  471, 1580,
 /*   660 */  1581,  467,  279,  462, 1106, 1577, 1643, 1388, 1549,  485,
 /*   670 */   272, 1639,  132,   34,   32,   30,   29,   28, 1530,  485,
 /*   680 */  1104, 1309,  122,  485,  445,  887,  186,  886,  482, 1593,
 /*   690 */  1415, 1671,  293,  451, 1412, 1399,  469,  537,  535, 1112,
 /*   700 */  1282, 1235,  485,  886, 1412,  888,  468, 1129, 1412,  105,
 /*   710 */  1549,  483,  485, 1308, 1307,  310,  521,    1, 1339,  381,
 /*   720 */  1306,  219, 1305, 1304, 1301, 1395, 1549, 1412,   74, 1578,
 /*   730 */   471, 1580, 1581,  467,  312,  462,  168, 1412, 1643,  167,
 /*   740 */   568,  455,  272, 1639, 1717,  103,   34,   32,   30,   29,
 /*   750 */    28, 1300, 1105, 1661, 1299, 1298,  178, 1297, 1549, 1549,
 /*   760 */   135, 1650, 1651, 1296, 1655, 1549,  459, 1549, 1549, 1549,
 /*   770 */   544,  543,  542,  541,  294,  463,  540,  539,  538,  108,
 /*   780 */   533,  532,  531,  530,  529,  528,  527,  526,  115,  522,
 /*   790 */  1107, 1178, 1497, 1498, 1662, 1223, 1549, 1129,  510, 1549,
 /*   800 */  1549,  121, 1549, 1295, 1092, 1093, 1294, 1293, 1549,  113,
 /*   810 */  1142, 1110, 1111,  424, 1155, 1156, 1157, 1158, 1159, 1160,
 /*   820 */  1161,  464, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1570,
 /*   830 */   978,  508,  507,  506,  982,  505,  984,  985,  504,  987,
 /*   840 */   501, 1568,  993,  498,  995,  996,  495,  492, 1549,  123,
 /*   850 */  1577, 1549, 1549,  170,  233, 1329,  169,  172, 1324,  411,
 /*   860 */   171, 1322, 1115, 1577,   47,  189,  231,  420, 1249,  191,
 /*   870 */     9,    8,  409, 1114, 1593, 1285, 1286,  400,   35,  149,
 /*   880 */   402,  469, 1198,  405, 1303, 1182,   35, 1593,  456,   35,
 /*   890 */  1162,  468,  208, 1067,  469, 1549,  210,  110, 1370,  111,
 /*   900 */   449,  477,  113,  216,  468,   47,  971,  202, 1549,  966,
 /*   910 */   433, 1454,  414,  240, 1578,  471, 1580, 1581,  467,  490,
 /*   920 */   462,  111,  195,  999,  380, 1003,   75, 1578,  471, 1580,
 /*   930 */  1581,  467,  446,  462, 1118, 1673, 1643, 1594,  112, 1705,
 /*   940 */  1642, 1639, 1010,   72, 1577, 1117,  204,  912,    2,  301,
 /*   950 */   161,  113,  137,  131,  111, 1009, 1702, 1127,  114,  379,
 /*   960 */   297,  375,  371,  367,  160,  257,  913,  259, 1593,  940,
 /*   970 */   224,  335,   50,   49,  322,  469,  143, 1495, 1076,  342,
 /*   980 */   145,  316,  350,  349,  351,  468,  355, 1136,  356, 1549,
 /*   990 */   150,   55,  357,  258,  158,  308, 1577,  304,  300,  140,
 /*  1000 */  1135,  358,  153,  359, 1134,  360,  156,   75, 1578,  471,
 /*  1010 */  1580, 1581,  467,   53,  462,  363,  159, 1643, 1133,  571,
 /*  1020 */  1593,  458, 1639,  382,  384, 1402,   79,  466,  163,  267,
 /*  1030 */   138, 1398, 1112,  223,  165,  116,   99,  468,  117, 1400,
 /*  1040 */  1396, 1549,  560,  118,  556,  552,  548,  222,  119,  176,
 /*  1050 */   225, 1577,  157,  415,  152,  423,  154, 1534,  179,  247,
 /*  1060 */  1578,  471, 1580, 1581,  467,  465,  462,  460, 1615,  419,
 /*  1070 */   181,  425,  426,  151,   71, 1593,  416,  217, 1132,  434,
 /*  1080 */   184,  187,  469, 1684,  475, 1674,  431, 1683,    5,  190,
 /*  1090 */   442,  271,  468,  437,  430,    4, 1549, 1223,  104, 1131,
 /*  1100 */  1577,  273,   37, 1720,  457,  454,  197,  481, 1658, 1664,
 /*  1110 */    16,  473, 1624,  474,  126, 1578,  471, 1580, 1581,  467,
 /*  1120 */   194,  462,  130, 1504, 1593,  196,  478, 1503,  226,  212,
 /*  1130 */   281,  469,  479,  214,  480,   62,  427, 1701,  203,  182,
 /*  1140 */  1413,  468,   64,  488,  221, 1549, 1385,  228,  567,  129,
 /*  1150 */   230,  234, 1577,   43, 1084,  235,  177,  232,  450, 1718,
 /*  1160 */   445, 1543, 1542,   75, 1578,  471, 1580, 1581,  467,  296,
 /*  1170 */   462, 1539,  298, 1643,  299, 1100, 1593, 1101, 1640,  141,
 /*  1180 */   303, 1537, 1577,  469,  305,  105,  306,  307, 1536,  309,
 /*  1190 */  1535, 1520,  311,  468,  142,  314,  315, 1549, 1079, 1078,
 /*  1200 */   429, 1514, 1513,  320,  449,  321, 1593, 1512, 1511, 1050,
 /*  1210 */  1488, 1487, 1486,  469,  109,  248, 1578,  471, 1580, 1581,
 /*  1220 */   467,  103,  462,  468, 1485, 1484, 1483, 1549, 1482, 1481,
 /*  1230 */  1480, 1479, 1478, 1577, 1477, 1476,  198, 1650,  444, 1475,
 /*  1240 */   443, 1474, 1473, 1705, 1472,  126, 1578,  471, 1580, 1581,
 /*  1250 */   467, 1471,  462, 1470, 1469, 1468,  137, 1593, 1467, 1466,
 /*  1260 */  1702, 1465, 1052, 1577,  469, 1464, 1463, 1462, 1341, 1528,
 /*  1270 */  1522, 1510, 1501, 1391,  468,  162,  155, 1340, 1549, 1338,
 /*  1280 */  1336,  276,  365,  364,  369,  368,  366, 1593,  905, 1334,
 /*  1290 */  1719, 1577,  370,  374,  466,  372,  248, 1578,  471, 1580,
 /*  1300 */  1581,  467, 1332,  462,  468,  378, 1321, 1320, 1549, 1317,
 /*  1310 */   373, 1393, 1015, 1392, 1018, 1593,  376,  377, 1330,  264,
 /*  1320 */    77,  939,  469,  938,  534,  937,  247, 1578,  471, 1580,
 /*  1330 */  1581,  467,  468,  462,  936, 1616, 1549,  935,  932,  278,
 /*  1340 */  1577,  931,  286,  285, 1325, 1323,  265,  403,  266, 1106,
 /*  1350 */   406, 1316, 1120,  408,  248, 1578,  471, 1580, 1581,  467,
 /*  1360 */   536,  462, 1315,  410, 1593, 1104,   76, 1527, 1113, 1521,
 /*  1370 */  1086,  469,  120, 1509,  417,  180, 1508, 1500, 1577,   57,
 /*  1380 */   183,  468,    3,   13, 1112, 1549,   35, 1112,  280, 1577,
 /*  1390 */    14,  188,   41, 1248,  127,   38,   46,  192,  185,   11,
 /*  1400 */   418, 1241, 1593,  248, 1578,  471, 1580, 1581,  467,  469,
 /*  1410 */   462, 1220,  193, 1593,   20, 1568,  199,   58, 1271,  468,
 /*  1420 */   469,   21,   40, 1549, 1219,  568,   39,   15,  486, 1276,
 /*  1430 */   468, 1270,  274, 1275, 1549, 1274,  275, 1105,    8, 1577,
 /*  1440 */  1116,  236, 1578,  471, 1580, 1581,  467,  136,  462,  461,
 /*  1450 */    17, 1165,  242, 1578,  471, 1580, 1581,  467, 1164,  462,
 /*  1460 */  1183,   27,   10, 1593, 1163,   18,  139, 1150,  206,  470,
 /*  1470 */   469,   19,  476, 1499,  209, 1107,  207, 1246, 1121,  211,
 /*  1480 */   468,   60,  213,   61, 1549,  215,   42,   65, 1122, 1577,
 /*  1490 */  1567, 1000,  489,  288,  218,  487, 1110, 1111,  491, 1124,
 /*  1500 */  1577,  997,  244, 1578,  471, 1580, 1581,  467,  493,  462,
 /*  1510 */   494,  977,  496, 1593,  994,  497,  499,  988,  500,  502,
 /*  1520 */   469,  992,  986,  503, 1593,  509,  991,  990,  989, 1012,
 /*  1530 */   468,  469,   66,   67, 1549,   68, 1008, 1005,  903, 1011,
 /*  1540 */   520,  468,  928,  946,  523, 1549,  926,  220, 1577,  925,
 /*  1550 */   924,  923,  237, 1578,  471, 1580, 1581,  467,  922,  462,
 /*  1560 */   921, 1577,  404,  245, 1578,  471, 1580, 1581,  467,  920,
 /*  1570 */   462,  919, 1593,  943,  941,  916,  915,  412,  914,  469,
 /*  1580 */   911,  910,  909,  908, 1337, 1593,  545,  546, 1335,  468,
 /*  1590 */   547,  174,  469, 1549,  407,  549,  550,  551, 1333,  401,
 /*  1600 */   553,  554,  468, 1331,  555,  173, 1549,  557,  558,  559,
 /*  1610 */  1319,  238, 1578,  471, 1580, 1581,  467,  561,  462,  562,
 /*  1620 */  1318, 1314,  565,  566,  246, 1578,  471, 1580, 1581,  467,
 /*  1630 */  1577,  462,   45, 1108,  229,   44,  569,  570, 1289, 1577,
 /*  1640 */  1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1650 */  1289, 1289, 1289, 1289, 1593, 1289, 1289, 1289, 1289, 1289,
 /*  1660 */  1289,  469, 1289, 1593, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1670 */   469,  468, 1289, 1289, 1289, 1549, 1289, 1289, 1289, 1289,
 /*  1680 */   468, 1289, 1289, 1289, 1549, 1289, 1289, 1289, 1289, 1577,
 /*  1690 */  1289, 1289, 1289,  239, 1578,  471, 1580, 1581,  467, 1289,
 /*  1700 */   462, 1289, 1589, 1578,  471, 1580, 1581,  467, 1289,  462,
 /*  1710 */  1289, 1289, 1289, 1593, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1720 */   469, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1730 */   468, 1289, 1289, 1289, 1549, 1289, 1289, 1289, 1289, 1577,
 /*  1740 */  1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1750 */  1577, 1289, 1588, 1578,  471, 1580, 1581,  467, 1289,  462,
 /*  1760 */  1289, 1289, 1289, 1593, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1770 */   469, 1289, 1289, 1289, 1593, 1289, 1289, 1289, 1289, 1289,
 /*  1780 */   468,  469, 1289, 1289, 1549, 1289, 1289, 1289, 1289, 1289,
 /*  1790 */  1289,  468, 1289, 1289, 1289, 1549, 1289, 1289, 1577, 1289,
 /*  1800 */  1289, 1289, 1587, 1578,  471, 1580, 1581,  467, 1289,  462,
 /*  1810 */  1289, 1577, 1289,  255, 1578,  471, 1580, 1581,  467, 1289,
 /*  1820 */   462, 1289, 1593, 1289, 1289, 1289, 1289, 1289, 1289,  469,
 /*  1830 */  1289, 1289, 1289, 1289, 1289, 1593, 1289, 1289, 1289,  468,
 /*  1840 */  1289, 1289,  469, 1549, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1850 */  1289, 1289,  468, 1289, 1289, 1289, 1549, 1289, 1289, 1289,
 /*  1860 */  1289,  254, 1578,  471, 1580, 1581,  467, 1289,  462, 1289,
 /*  1870 */  1289, 1289, 1289, 1289,  256, 1578,  471, 1580, 1581,  467,
 /*  1880 */  1577,  462, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1577,
 /*  1890 */  1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1900 */  1289, 1289, 1289, 1289, 1593, 1289, 1289, 1289, 1289, 1289,
 /*  1910 */  1289,  469, 1289, 1593, 1289, 1289, 1289, 1289, 1289, 1289,
 /*  1920 */   469,  468, 1289, 1289, 1289, 1549, 1289, 1289, 1289, 1289,
 /*  1930 */   468, 1289, 1289, 1289, 1549, 1289, 1289, 1289, 1289, 1289,
 /*  1940 */  1289, 1289, 1289,  253, 1578,  471, 1580, 1581,  467, 1289,
 /*  1950 */   462, 1289,  241, 1578,  471, 1580, 1581,  467, 1289,  462,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   253,  249,  253,  266,  225,  231,  269,  231,  256,  272,
 /*    10 */   222,  250,   12,   13,  240,  225,  224,  270,  226,  270,
 /*    20 */    20,  247,   22,   12,   13,   14,   15,   16,  249,  270,
 /*    30 */   256,  284,  285,  284,  285,  256,  234,  261,   38,  249,
 /*    40 */   238,  314,  290,  284,  285,  266,  256,    0,  231,  270,
 /*    50 */    50,   12,   13,   14,  327,  233,  266,   57,  331,   20,
 /*    60 */   270,   22,   20,  275,  275,  275,  225,  288,  289,  290,
 /*    70 */   291,  292,  293,  256,  295,   75,  254,   38,  288,  289,
 /*    80 */   290,  291,  292,  293,  237,  295,  239,  258,  298,   50,
 /*    90 */   249,   20,  302,  303,  265,  266,   57,  256,   98,  299,
 /*   100 */   300,   49,  314,  314,  314,  326,  231,  266,   61,  292,
 /*   110 */   110,  270,   65,  231,   75,  327,  327,  327,   20,  331,
 /*   120 */   331,  331,  240,  306,  307,  308,  309,  231,  311,  288,
 /*   130 */   289,  290,  291,  292,  293,   88,  295,   98,  256,  298,
 /*   140 */   233,   47,  231,  302,  303,  304,   75,   38,  148,  110,
 /*   150 */   275,  240,  256,  246,  107,  108,  109,  316,  111,   20,
 /*   160 */    20,  254,   20,  322,  323,  138,   57,  256,   74,  169,
 /*   170 */   170,   77,  172,  173,  174,  175,  176,  177,  178,  179,
 /*   180 */   180,  181,  182,  183,  184,  185,  186,  148,  292,  314,
 /*   190 */   249,   12,   13,   14,   15,   16,  255,    1,    2,  199,
 /*   200 */    75,  260,  327,  307,  308,  309,  331,  311,  169,  170,
 /*   210 */    85,  172,  173,  174,  175,  176,  177,  178,  179,  180,
 /*   220 */   181,  182,  183,  184,  185,  186,   12,   13,  199,   50,
 /*   230 */   242,  204,  205,  245,   20,   18,   22,   20,  225,   52,
 /*   240 */   230,   54,   49,  249,   27,   58,  230,   30,   61,  255,
 /*   250 */    63,   64,   38,   66,  260,   76,   39,  147,   71,  149,
 /*   260 */   244,  251,  249,   84,   50,   12,   13,  251,    4,  256,
 /*   270 */   199,   57,   76,   20,    2,   22,  286,  157,  158,  266,
 /*   280 */   169,  161,    2,  270,   12,   13,   14,   15,   16,   75,
 /*   290 */   286,   38,   12,   13,   14,   15,   16,   14,   15,   16,
 /*   300 */   310,  288,  289,  290,  291,  292,  293,  248,  295,  199,
 /*   310 */    57,  298,   98,  134,  310,  302,  303,  304,  259,  208,
 /*   320 */   209,  210,  211,  212,  110,  275,  313,    0,   75,    0,
 /*   330 */   113,  152,   20,  116,  117,  118,  119,  120,  199,  122,
 /*   340 */   123,  124,  125,  126,  127,  128,  129,  130,  131,  132,
 /*   350 */   133,   98,    4,   24,   25,   26,   27,   28,   29,   30,
 /*   360 */    31,   32,  148,  110,  314,  314,  187,  188,  189,  190,
 /*   370 */   191,  192,  193,  194,  195,  196,   49,  327,  327,  225,
 /*   380 */    20,  331,  331,  169,  170,   43,  172,  173,  174,  175,
 /*   390 */   176,  177,  178,  179,  180,  181,  182,  183,  184,  185,
 /*   400 */   186,  148,   57,   20,   72,   12,   13,   14,   15,   16,
 /*   410 */    21,  228,  229,   24,   25,   26,   27,   28,   29,   30,
 /*   420 */    31,   32,  169,  170,  270,  172,  173,  174,  175,  176,
 /*   430 */   177,  178,  179,  180,  181,  182,  183,  184,  185,  186,
 /*   440 */    12,   13,   14,   50,    0,   72,  225,  241,   20,   76,
 /*   450 */    22,  241,  199,  231,  266,  249,   35,   61,   75,  249,
 /*   460 */   272,   65,  240,  257,  200,   21,   38,  257,   24,   25,
 /*   470 */    26,   27,   28,   29,   30,   31,   32,   84,  256,   12,
 /*   480 */    13,    3,   61,    0,   88,   57,   65,   20,  225,   22,
 /*   490 */   225,  270,   12,   13,   14,   15,   16,  231,  231,   78,
 /*   500 */   140,   80,   81,   75,   83,   38,  240,  240,   86,   88,
 /*   510 */   235,  236,  241,  247,  249,   12,   13,   14,   15,   16,
 /*   520 */   249,  256,  256,  256,   57,  231,   98,  134,  257,  225,
 /*   530 */   249,  266,  256,  270,  240,  270,  255,  231,  110,  263,
 /*   540 */   198,  260,   75,  134,   61,  152,  240,  199,   65,  217,
 /*   550 */   256,  235,  236,  288,  289,  290,  291,  292,  293,  249,
 /*   560 */   295,  152,  256,  298,    0,   98,   20,  302,  303,  304,
 /*   570 */   260,   88,   67,  250,  270,  286,  148,  110,  313,   76,
 /*   580 */   187,  188,  189,  190,  191,  192,  193,  194,  195,  196,
 /*   590 */   107,  108,  109,  225,  111,    0,  187,  169,  170,  310,
 /*   600 */   172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
 /*   610 */   182,  183,  184,  185,  186,  148,   52,  249,   54,  114,
 /*   620 */   115,  141,   58,  225,  256,   61,   79,   63,   64,   82,
 /*   630 */    66,   36,  235,  236,  266,   71,  169,  170,  270,  172,
 /*   640 */   173,  174,  175,  176,  177,  178,  179,  180,  181,  182,
 /*   650 */   183,  184,  185,  186,   12,   13,  288,  289,  290,  291,
 /*   660 */   292,  293,   20,  295,   22,  225,  298,    0,  270,  231,
 /*   670 */   302,  303,  304,   12,   13,   14,   15,   16,  240,  231,
 /*   680 */    38,  225,  249,  231,  231,   20,  140,   22,  240,  249,
 /*   690 */   257,  323,  240,  215,  256,  250,  256,  235,  236,   57,
 /*   700 */   220,   14,  231,   22,  256,   40,  266,   20,  256,  256,
 /*   710 */   270,  240,  231,  225,  225,  144,   49,   75,    0,   38,
 /*   720 */   225,  240,  225,  225,  225,  250,  270,  256,  288,  289,
 /*   730 */   290,  291,  292,  293,  163,  295,   79,  256,  298,   82,
 /*   740 */    98,   72,  302,  303,  304,  292,   12,   13,   14,   15,
 /*   750 */    16,  225,  110,  313,  225,  225,  250,  225,  270,  270,
 /*   760 */   307,  308,  309,  225,  311,  270,   50,  270,  270,  270,
 /*   770 */    52,   53,   54,   55,   56,  250,   58,   59,   60,   61,
 /*   780 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   790 */   148,   14,  265,  266,  197,  198,  270,   20,  250,  270,
 /*   800 */   270,  140,  270,  225,  159,  160,  225,  225,  270,   72,
 /*   810 */    76,  169,  170,   76,  172,  173,  174,  175,  176,  177,
 /*   820 */   178,  179,  180,  181,  182,  183,  184,  185,  186,   75,
 /*   830 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   840 */    99,   87,  101,  102,  103,  104,  105,  106,  270,   18,
 /*   850 */   225,  270,  270,   79,   23,    0,   82,   79,    0,   21,
 /*   860 */    82,    0,   38,  225,   72,   72,   35,  278,   76,   76,
 /*   870 */     1,    2,   34,   38,  249,  184,  185,   22,   72,   48,
 /*   880 */    22,  256,   76,   22,  226,  169,   72,  249,  219,   72,
 /*   890 */    76,  266,   72,   76,  256,  270,   76,   72,  238,   72,
 /*   900 */   275,   76,   72,   76,  266,   72,   76,  334,  270,   76,
 /*   910 */   325,  259,  282,  288,  289,  290,  291,  292,  293,   72,
 /*   920 */   295,   72,  319,   76,  228,   76,  288,  289,  290,  291,
 /*   930 */   292,  293,  312,  295,  110,  287,  298,  249,   72,  314,
 /*   940 */   302,  303,   76,  112,  225,  110,  328,   38,  315,   36,
 /*   950 */    33,   72,  327,   36,   72,   76,  331,   20,   76,   42,
 /*   960 */   231,   44,   45,   46,   47,  283,   57,  235,  249,   38,
 /*   970 */   276,  231,  141,  142,  143,  256,  145,  231,  146,  264,
 /*   980 */   121,  150,  134,  262,  262,  266,  231,   20,  280,  270,
 /*   990 */   233,   74,  266,  162,   77,  164,  225,  166,  167,  168,
 /*  1000 */    20,  274,  233,  256,   20,  267,  233,  288,  289,  290,
 /*  1010 */   291,  292,  293,  233,  295,  231,  233,  298,   20,   19,
 /*  1020 */   249,  302,  303,  227,  249,  249,  231,  256,  249,  227,
 /*  1030 */   199,  249,   57,   33,  249,  249,   36,  266,  249,  249,
 /*  1040 */   249,  270,   42,  249,   44,   45,   46,   47,  249,  230,
 /*  1050 */   280,  225,  135,  155,  137,  274,  139,  270,  230,  288,
 /*  1060 */   289,  290,  291,  292,  293,  294,  295,  296,  297,  266,
 /*  1070 */   230,  256,  267,  156,   74,  249,  279,   77,   20,  207,
 /*  1080 */   230,  271,  256,  324,  206,  287,  270,  324,  214,  271,
 /*  1090 */   213,  270,  266,  270,  202,  201,  270,  198,  256,   20,
 /*  1100 */   225,  221,  121,  335,  218,  216,  305,  107,  286,  321,
 /*  1110 */    75,  270,  301,  270,  288,  289,  290,  291,  292,  293,
 /*  1120 */   320,  295,  318,  271,  249,  317,  137,  271,  245,  256,
 /*  1130 */   270,  256,  268,  230,  267,  230,  136,  330,  329,  139,
 /*  1140 */   256,  266,   75,  252,  230,  270,  239,  231,  227,  281,
 /*  1150 */   232,  243,  225,  277,  154,  243,  156,  223,  332,  333,
 /*  1160 */   231,    0,    0,  288,  289,  290,  291,  292,  293,   64,
 /*  1170 */   295,    0,   38,  298,  165,   38,  249,   38,  303,   38,
 /*  1180 */   165,    0,  225,  256,   38,  256,   38,  165,    0,   38,
 /*  1190 */     0,    0,   38,  266,   75,  152,  151,  270,  110,  148,
 /*  1200 */   273,    0,    0,   53,  275,  144,  249,    0,    0,   87,
 /*  1210 */     0,    0,    0,  256,  121,  288,  289,  290,  291,  292,
 /*  1220 */   293,  292,  295,  266,    0,    0,    0,  270,    0,    0,
 /*  1230 */     0,    0,    0,  225,    0,    0,  307,  308,  309,    0,
 /*  1240 */   311,    0,    0,  314,    0,  288,  289,  290,  291,  292,
 /*  1250 */   293,    0,  295,    0,    0,    0,  327,  249,    0,    0,
 /*  1260 */   331,    0,   22,  225,  256,    0,    0,    0,    0,    0,
 /*  1270 */     0,    0,    0,    0,  266,   82,   43,    0,  270,    0,
 /*  1280 */     0,  273,   36,   38,   36,   38,   43,  249,   51,    0,
 /*  1290 */   333,  225,   43,   43,  256,   38,  288,  289,  290,  291,
 /*  1300 */   292,  293,    0,  295,  266,   43,    0,    0,  270,    0,
 /*  1310 */    36,    0,   22,    0,   38,  249,   38,   36,    0,   22,
 /*  1320 */    84,   38,  256,   38,   72,   38,  288,  289,  290,  291,
 /*  1330 */   292,  293,  266,  295,   38,  297,  270,   38,   38,  273,
 /*  1340 */   225,   38,   12,   13,    0,    0,   22,   39,   22,   22,
 /*  1350 */    38,    0,   22,   22,  288,  289,  290,  291,  292,  293,
 /*  1360 */    72,  295,    0,   22,  249,   38,   20,    0,   38,    0,
 /*  1370 */    38,  256,  153,    0,   22,  137,    0,    0,  225,   75,
 /*  1380 */    43,  266,   72,  203,   57,  270,   72,   57,  273,  225,
 /*  1390 */   203,   76,   72,   76,   75,  197,  140,   75,  135,  203,
 /*  1400 */   140,   76,  249,  288,  289,  290,  291,  292,  293,  256,
 /*  1410 */   295,   76,   72,  249,   75,   87,   87,   75,   38,  266,
 /*  1420 */   256,   72,  140,  270,   76,   98,   72,   72,   98,   76,
 /*  1430 */   266,   38,   38,   38,  270,   38,   38,  110,    2,  225,
 /*  1440 */   110,  288,  289,  290,  291,  292,  293,   87,  295,   75,
 /*  1450 */    72,   76,  288,  289,  290,  291,  292,  293,   76,  295,
 /*  1460 */   169,   75,   75,  249,   76,   75,   87,   22,   87,  171,
 /*  1470 */   256,   75,  138,    0,   75,  148,   76,   76,  148,   75,
 /*  1480 */   266,   75,   43,   75,  270,  135,   75,   85,   22,  225,
 /*  1490 */    87,   76,   38,   38,   87,   86,  169,  170,   75,  169,
 /*  1500 */   225,   76,  288,  289,  290,  291,  292,  293,   38,  295,
 /*  1510 */    75,   22,   38,  249,   76,   75,   38,   76,   75,   38,
 /*  1520 */   256,  100,   76,   75,  249,   88,  100,  100,  100,   38,
 /*  1530 */   266,  256,   75,   75,  270,   75,   38,   22,   51,  110,
 /*  1540 */    50,  266,   38,   57,   73,  270,   38,   72,  225,   38,
 /*  1550 */    38,   38,  288,  289,  290,  291,  292,  293,   38,  295,
 /*  1560 */    38,  225,    4,  288,  289,  290,  291,  292,  293,   38,
 /*  1570 */   295,   22,  249,   57,   38,   38,   38,   19,   38,  256,
 /*  1580 */    38,   38,   38,   38,    0,  249,   38,   36,    0,  266,
 /*  1590 */    43,   33,  256,  270,   36,   38,   36,   43,    0,   41,
 /*  1600 */    38,   36,  266,    0,   43,   47,  270,   38,   36,   43,
 /*  1610 */     0,  288,  289,  290,  291,  292,  293,   38,  295,   37,
 /*  1620 */     0,    0,   22,   21,  288,  289,  290,  291,  292,  293,
 /*  1630 */   225,  295,   74,   22,   22,   77,   21,   20,  336,  225,
 /*  1640 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  1650 */   336,  336,  336,  336,  249,  336,  336,  336,  336,  336,
 /*  1660 */   336,  256,  336,  249,  336,  336,  336,  336,  336,  336,
 /*  1670 */   256,  266,  336,  336,  336,  270,  336,  336,  336,  336,
 /*  1680 */   266,  336,  336,  336,  270,  336,  336,  336,  336,  225,
 /*  1690 */   336,  336,  336,  288,  289,  290,  291,  292,  293,  336,
 /*  1700 */   295,  336,  288,  289,  290,  291,  292,  293,  336,  295,
 /*  1710 */   336,  336,  336,  249,  336,  336,  336,  336,  336,  336,
 /*  1720 */   256,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  1730 */   266,  336,  336,  336,  270,  336,  336,  336,  336,  225,
 /*  1740 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  1750 */   225,  336,  288,  289,  290,  291,  292,  293,  336,  295,
 /*  1760 */   336,  336,  336,  249,  336,  336,  336,  336,  336,  336,
 /*  1770 */   256,  336,  336,  336,  249,  336,  336,  336,  336,  336,
 /*  1780 */   266,  256,  336,  336,  270,  336,  336,  336,  336,  336,
 /*  1790 */   336,  266,  336,  336,  336,  270,  336,  336,  225,  336,
 /*  1800 */   336,  336,  288,  289,  290,  291,  292,  293,  336,  295,
 /*  1810 */   336,  225,  336,  288,  289,  290,  291,  292,  293,  336,
 /*  1820 */   295,  336,  249,  336,  336,  336,  336,  336,  336,  256,
 /*  1830 */   336,  336,  336,  336,  336,  249,  336,  336,  336,  266,
 /*  1840 */   336,  336,  256,  270,  336,  336,  336,  336,  336,  336,
 /*  1850 */   336,  336,  266,  336,  336,  336,  270,  336,  336,  336,
 /*  1860 */   336,  288,  289,  290,  291,  292,  293,  336,  295,  336,
 /*  1870 */   336,  336,  336,  336,  288,  289,  290,  291,  292,  293,
 /*  1880 */   225,  295,  336,  336,  336,  336,  336,  336,  336,  225,
 /*  1890 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  1900 */   336,  336,  336,  336,  249,  336,  336,  336,  336,  336,
 /*  1910 */   336,  256,  336,  249,  336,  336,  336,  336,  336,  336,
 /*  1920 */   256,  266,  336,  336,  336,  270,  336,  336,  336,  336,
 /*  1930 */   266,  336,  336,  336,  270,  336,  336,  336,  336,  336,
 /*  1940 */   336,  336,  336,  288,  289,  290,  291,  292,  293,  336,
 /*  1950 */   295,  336,  288,  289,  290,  291,  292,  293,  336,  295,
};
#define YY_SHIFT_COUNT    (571)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1621)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   831,    0,   39,  214,  214,  214,  214,  253,  214,  214,
 /*    10 */   428,  467,  642,  467,  467,  467,  467,  467,  467,  467,
 /*    20 */   467,  467,  467,  467,  467,  467,  467,  467,  467,  467,
 /*    30 */   467,  467,  467,  467,  467,  467,   71,  383,  383,  383,
 /*    40 */   139, 1330, 1330,  110,   42,   42,   29, 1330,  348,   42,
 /*    50 */    42,   42,   42,   42,   42,   52,   42,   98,  140,   29,
 /*    60 */   142,   98,   42,   42,   98,   42,   98,  142,   98,   98,
 /*    70 */    42,  193,  217,  179,  393,  393,  389, 1327,  421,  187,
 /*    80 */  1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327,
 /*    90 */  1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327, 1327,  665,
 /*   100 */   327,  109,  109,  360,  360,  360,  667,  109,  109,  312,
 /*   110 */   142,   98,  142,   98,  422,  345,  741,  741,  741,  741,
 /*   120 */   741,  741,  741, 1000,  444,  564,  480,  111,  396,  120,
 /*   130 */    27,  681,  546,  597,  342,  597,  687,  478,  264,  777,
 /*   140 */   937,  913,  931,  832,  937,  937,  859,  848,  848,  937,
 /*   150 */   967,   52,  142,  980,   52,  312,  984,   52,   52,  937,
 /*   160 */    52,  998,   98,   98,   98,   98,   98,   98,   98,   98,
 /*   170 */    98,   98,   98,  937,  998,  975,  967,  193,  898,  142,
 /*   180 */   193,  980,  193,  312,  984,  193, 1058,  872,  878,  975,
 /*   190 */   872,  878,  975,  975,  874,  877,  892,  894,  899,  312,
 /*   200 */  1079,  981,  880,  886,  889, 1035,   98,  878,  975,  975,
 /*   210 */   878,  975,  989,  312,  984,  193,  422,  193,  312, 1067,
 /*   220 */   345,  937,  193,  998, 1960, 1960, 1960, 1960, 1960, 1960,
 /*   230 */   718,  917,  329, 1558,   47,  483,  503,  272,  280,  661,
 /*   240 */   734,   11,   11,   11,   11,   11,   11,   11,   11,   94,
 /*   250 */   505,  196,  409,  283,  283,  283,  283,  595,  571,  373,
 /*   260 */   547,  657,  774,  778,  855,  858,  861,  838,  645,  737,
 /*   270 */   792,  793,  869,  691,  332,  669,  806,  716,  814,  754,
 /*   280 */   817,  820,  825,  827,  830,  824,  835,  833,  847,  849,
 /*   290 */   866,  879,  882,  125,  909, 1161, 1162, 1105, 1171, 1134,
 /*   300 */  1009, 1137, 1139, 1141, 1015, 1181, 1146, 1148, 1022, 1188,
 /*   310 */  1151, 1190, 1154, 1191, 1119, 1043, 1045, 1088, 1051, 1201,
 /*   320 */  1202, 1150, 1061, 1207, 1208, 1122, 1210, 1211, 1212, 1224,
 /*   330 */  1225, 1226, 1228, 1229, 1230, 1231, 1232, 1234, 1235, 1239,
 /*   340 */  1241, 1242, 1244, 1093, 1251, 1253, 1254, 1255, 1258, 1259,
 /*   350 */  1240, 1261, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272,
 /*   360 */  1233, 1273, 1237, 1277, 1279, 1245, 1246, 1243, 1280, 1247,
 /*   370 */  1248, 1249, 1289, 1257, 1274, 1250, 1302, 1278, 1281, 1262,
 /*   380 */  1306, 1307, 1309, 1311, 1236, 1193, 1276, 1252, 1288, 1290,
 /*   390 */  1313, 1283, 1285, 1287, 1296, 1299, 1252, 1288, 1300, 1303,
 /*   400 */  1318, 1297, 1344, 1324, 1308, 1345, 1326, 1312, 1351, 1331,
 /*   410 */  1362, 1341, 1346, 1367, 1256, 1332, 1369, 1219, 1352, 1260,
 /*   420 */  1238, 1373, 1376, 1282, 1377, 1304, 1337, 1263, 1310, 1314,
 /*   430 */  1180, 1315, 1320, 1317, 1319, 1322, 1339, 1325, 1340, 1328,
 /*   440 */  1342, 1349, 1187, 1335, 1348, 1329, 1198, 1354, 1360, 1353,
 /*   450 */  1355, 1196, 1380, 1393, 1394, 1395, 1397, 1398, 1436, 1291,
 /*   460 */  1378, 1375, 1374, 1382, 1386, 1388, 1379, 1387, 1390, 1381,
 /*   470 */  1445, 1298, 1396, 1400, 1401, 1399, 1404, 1334, 1406, 1473,
 /*   480 */  1439, 1350, 1408, 1402, 1403, 1407, 1466, 1411, 1409, 1415,
 /*   490 */  1454, 1455, 1423, 1425, 1470, 1435, 1438, 1474, 1440, 1441,
 /*   500 */  1478, 1443, 1446, 1481, 1448, 1421, 1426, 1427, 1428, 1489,
 /*   510 */  1437, 1457, 1491, 1429, 1458, 1460, 1498, 1252, 1288, 1515,
 /*   520 */  1487, 1490, 1504, 1486, 1471, 1475, 1508, 1511, 1512, 1513,
 /*   530 */  1520, 1522, 1531, 1549, 1516, 1252, 1536, 1288, 1537, 1538,
 /*   540 */  1540, 1542, 1543, 1544, 1545, 1584, 1548, 1551, 1547, 1588,
 /*   550 */  1557, 1560, 1554, 1598, 1562, 1565, 1561, 1603, 1569, 1572,
 /*   560 */  1566, 1610, 1579, 1582, 1620, 1621, 1600, 1602, 1611, 1612,
 /*   570 */  1615, 1617,
};
#define YY_REDUCE_COUNT (229)
#define YY_REDUCE_MIN   (-273)
#define YY_REDUCE_MAX   (1664)
static const short yy_reduce_ofst[] = {
 /*     0 */  -212, -210, -159,  368,   13,  265,  440,  625,  638,  719,
 /*    10 */   771,  826,  875,  927, -221,  957, 1008, 1038, 1066, 1115,
 /*    20 */  1153, 1164, 1214, 1264, 1275, 1323, 1336, 1405, 1414, 1464,
 /*    30 */  1514, 1525, 1573, 1586, 1655, 1664,  929, -183, -104,  453,
 /*    40 */  -125, -253, -251, -211, -226,  266,   50, -241, -273, -118,
 /*    50 */   -89,  222,  267,  294,  306,  -93,  438,  -59, -248,   51,
 /*    60 */  -263,  206,  448,  471,   -6,  481,  210, -171,  281,  271,
 /*    70 */   452,   16, -224, -200, -200, -200, -208,  154,   59, -198,
 /*    80 */   221,  263,  304,  398,  456,  488,  489,  495,  497,  498,
 /*    90 */   499,  526,  529,  530,  532,  538,  578,  581,  582,  183,
 /*   100 */  -178,  275,  316,  -10,    4,  289,   10,  397,  462,  276,
 /*   110 */   188,  433,  527,  310,  -12, -153, -239,  323,  445,  475,
 /*   120 */   506,  525,  548,  589,  658,  660,  573,  585,  652,  630,
 /*   130 */   603,  696,  648,  620,  620,  620,  688,  618,  633,  688,
 /*   140 */   729,  682,  732,  694,  740,  746,  715,  721,  722,  755,
 /*   150 */   708,  757,  726,  727,  769,  747,  738,  773,  780,  784,
 /*   160 */   783,  796,  775,  776,  779,  782,  785,  786,  789,  790,
 /*   170 */   791,  794,  799,  795,  802,  787,  770,  819,  797,  803,
 /*   180 */   828,  781,  840,  815,  805,  850,  798,  759,  810,  816,
 /*   190 */   763,  818,  821,  823,  788,  800,  804,  808,  620,  842,
 /*   200 */   822,  801,  768,  807,  809,  811,  688,  852,  841,  843,
 /*   210 */   856,  860,  864,  873,  867,  903,  883,  905,  884,  891,
 /*   220 */   907,  916,  914,  921,  876,  868,  908,  912,  918,  934,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*    10 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*    20 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*    30 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*    40 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*    50 */  1287, 1287, 1287, 1287, 1287, 1346, 1287, 1287, 1287, 1287,
 /*    60 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*    70 */  1287, 1344, 1489, 1287, 1645, 1287, 1287, 1287, 1287, 1287,
 /*    80 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*    90 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   100 */  1346, 1287, 1287, 1656, 1656, 1656, 1344, 1287, 1287, 1287,
 /*   110 */  1287, 1287, 1287, 1287, 1441, 1287, 1287, 1287, 1287, 1287,
 /*   120 */  1287, 1287, 1287, 1523, 1287, 1287, 1721, 1287, 1394, 1529,
 /*   130 */  1680, 1287, 1672, 1648, 1662, 1649, 1287, 1706, 1665, 1287,
 /*   140 */  1287, 1287, 1287, 1515, 1287, 1287, 1494, 1491, 1491, 1287,
 /*   150 */  1287, 1346, 1287, 1287, 1346, 1287, 1287, 1346, 1346, 1287,
 /*   160 */  1346, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   170 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1344, 1525, 1287,
 /*   180 */  1344, 1287, 1344, 1287, 1287, 1344, 1287, 1687, 1685, 1287,
 /*   190 */  1687, 1685, 1287, 1287, 1699, 1695, 1678, 1676, 1662, 1287,
 /*   200 */  1287, 1287, 1724, 1712, 1708, 1287, 1287, 1685, 1287, 1287,
 /*   210 */  1685, 1287, 1502, 1287, 1287, 1344, 1287, 1344, 1287, 1410,
 /*   220 */  1287, 1287, 1344, 1287, 1517, 1531, 1444, 1444, 1347, 1292,
 /*   230 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   240 */  1287, 1592, 1698, 1697, 1621, 1620, 1619, 1617, 1591, 1287,
 /*   250 */  1287, 1287, 1287, 1585, 1586, 1584, 1583, 1287, 1287, 1287,
 /*   260 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   270 */  1287, 1287, 1646, 1287, 1709, 1713, 1287, 1287, 1287, 1569,
 /*   280 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   290 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   300 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   310 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   320 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   330 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   340 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   350 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   360 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   370 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   380 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1457, 1456, 1287,
 /*   390 */  1287, 1287, 1287, 1287, 1287, 1287, 1374, 1373, 1287, 1287,
 /*   400 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   410 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   420 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1669, 1679,
 /*   430 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1569,
 /*   440 */  1287, 1696, 1287, 1655, 1651, 1287, 1287, 1647, 1287, 1287,
 /*   450 */  1707, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1641, 1287,
 /*   460 */  1614, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   470 */  1287, 1579, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   480 */  1287, 1287, 1287, 1287, 1568, 1287, 1287, 1287, 1287, 1287,
 /*   490 */  1287, 1287, 1438, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   500 */  1287, 1287, 1287, 1287, 1287, 1423, 1421, 1420, 1419, 1287,
 /*   510 */  1416, 1287, 1287, 1287, 1287, 1287, 1287, 1447, 1446, 1287,
 /*   520 */  1287, 1287, 1287, 1287, 1287, 1367, 1287, 1287, 1287, 1287,
 /*   530 */  1287, 1287, 1287, 1287, 1287, 1358, 1287, 1357, 1287, 1287,
 /*   540 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   550 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   560 */  1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287,
 /*   570 */  1287, 1287,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "STRICT",
  /*   72 */ "NK_COMMA",
  /*   73 */ "NK_COLON",
  /*   74 */ "TABLE",
  /*   75 */ "NK_LP",
  /*   76 */ "NK_RP",
  /*   77 */ "STABLE",
  /*   78 */ "ADD",
  /*   79 */ "COLUMN",
  /*   80 */ "MODIFY",
  /*   81 */ "RENAME",
  /*   82 */ "TAG",
  /*   83 */ "SET",
  /*   84 */ "NK_EQ",
  /*   85 */ "USING",
  /*   86 */ "TAGS",
  /*   87 */ "NK_DOT",
  /*   88 */ "COMMENT",
  /*   89 */ "BOOL",
  /*   90 */ "TINYINT",
  /*   91 */ "SMALLINT",
  /*   92 */ "INT",
  /*   93 */ "INTEGER",
  /*   94 */ "BIGINT",
  /*   95 */ "FLOAT",
  /*   96 */ "DOUBLE",
  /*   97 */ "BINARY",
  /*   98 */ "TIMESTAMP",
  /*   99 */ "NCHAR",
  /*  100 */ "UNSIGNED",
  /*  101 */ "JSON",
  /*  102 */ "VARCHAR",
  /*  103 */ "MEDIUMBLOB",
  /*  104 */ "BLOB",
  /*  105 */ "VARBINARY",
  /*  106 */ "DECIMAL",
  /*  107 */ "SMA",
  /*  108 */ "ROLLUP",
  /*  109 */ "FILE_FACTOR",
  /*  110 */ "NK_FLOAT",
  /*  111 */ "DELAY",
  /*  112 */ "SHOW",
  /*  113 */ "DATABASES",
  /*  114 */ "TABLES",
  /*  115 */ "STABLES",
  /*  116 */ "MNODES",
  /*  117 */ "MODULES",
  /*  118 */ "QNODES",
  /*  119 */ "FUNCTIONS",
  /*  120 */ "INDEXES",
  /*  121 */ "FROM",
  /*  122 */ "ACCOUNTS",
  /*  123 */ "APPS",
  /*  124 */ "CONNECTIONS",
  /*  125 */ "LICENCE",
  /*  126 */ "GRANTS",
  /*  127 */ "QUERIES",
  /*  128 */ "SCORES",
  /*  129 */ "TOPICS",
  /*  130 */ "VARIABLES",
  /*  131 */ "BNODES",
  /*  132 */ "SNODES",
  /*  133 */ "CLUSTER",
  /*  134 */ "LIKE",
  /*  135 */ "INDEX",
  /*  136 */ "FULLTEXT",
  /*  137 */ "FUNCTION",
  /*  138 */ "INTERVAL",
  /*  139 */ "TOPIC",
  /*  140 */ "AS",
  /*  141 */ "DESC",
  /*  142 */ "DESCRIBE",
  /*  143 */ "RESET",
  /*  144 */ "QUERY",
  /*  145 */ "EXPLAIN",
  /*  146 */ "ANALYZE",
  /*  147 */ "VERBOSE",
  /*  148 */ "NK_BOOL",
  /*  149 */ "RATIO",
  /*  150 */ "COMPACT",
  /*  151 */ "VNODES",
  /*  152 */ "IN",
  /*  153 */ "OUTPUTTYPE",
  /*  154 */ "AGGREGATE",
  /*  155 */ "BUFSIZE",
  /*  156 */ "STREAM",
  /*  157 */ "INTO",
  /*  158 */ "TRIGGER",
  /*  159 */ "AT_ONCE",
  /*  160 */ "WINDOW_CLOSE",
  /*  161 */ "WATERMARK",
  /*  162 */ "KILL",
  /*  163 */ "CONNECTION",
  /*  164 */ "MERGE",
  /*  165 */ "VGROUP",
  /*  166 */ "REDISTRIBUTE",
  /*  167 */ "SPLIT",
  /*  168 */ "SYNCDB",
  /*  169 */ "NULL",
  /*  170 */ "NK_QUESTION",
  /*  171 */ "NK_ARROW",
  /*  172 */ "ROWTS",
  /*  173 */ "TBNAME",
  /*  174 */ "QSTARTTS",
  /*  175 */ "QENDTS",
  /*  176 */ "WSTARTTS",
  /*  177 */ "WENDTS",
  /*  178 */ "WDURATION",
  /*  179 */ "CAST",
  /*  180 */ "NOW",
  /*  181 */ "TODAY",
  /*  182 */ "TIMEZONE",
  /*  183 */ "COUNT",
  /*  184 */ "FIRST",
  /*  185 */ "LAST",
  /*  186 */ "LAST_ROW",
  /*  187 */ "BETWEEN",
  /*  188 */ "IS",
  /*  189 */ "NK_LT",
  /*  190 */ "NK_GT",
  /*  191 */ "NK_LE",
  /*  192 */ "NK_GE",
  /*  193 */ "NK_NE",
  /*  194 */ "MATCH",
  /*  195 */ "NMATCH",
  /*  196 */ "CONTAINS",
  /*  197 */ "JOIN",
  /*  198 */ "INNER",
  /*  199 */ "SELECT",
  /*  200 */ "DISTINCT",
  /*  201 */ "WHERE",
  /*  202 */ "PARTITION",
  /*  203 */ "BY",
  /*  204 */ "SESSION",
  /*  205 */ "STATE_WINDOW",
  /*  206 */ "SLIDING",
  /*  207 */ "FILL",
  /*  208 */ "VALUE",
  /*  209 */ "NONE",
  /*  210 */ "PREV",
  /*  211 */ "LINEAR",
  /*  212 */ "NEXT",
  /*  213 */ "GROUP",
  /*  214 */ "HAVING",
  /*  215 */ "ORDER",
  /*  216 */ "SLIMIT",
  /*  217 */ "SOFFSET",
  /*  218 */ "LIMIT",
  /*  219 */ "OFFSET",
  /*  220 */ "ASC",
  /*  221 */ "NULLS",
  /*  222 */ "cmd",
  /*  223 */ "account_options",
  /*  224 */ "alter_account_options",
  /*  225 */ "literal",
  /*  226 */ "alter_account_option",
  /*  227 */ "user_name",
  /*  228 */ "dnode_endpoint",
  /*  229 */ "dnode_host_name",
  /*  230 */ "not_exists_opt",
  /*  231 */ "db_name",
  /*  232 */ "db_options",
  /*  233 */ "exists_opt",
  /*  234 */ "alter_db_options",
  /*  235 */ "integer_list",
  /*  236 */ "variable_list",
  /*  237 */ "retention_list",
  /*  238 */ "alter_db_option",
  /*  239 */ "retention",
  /*  240 */ "full_table_name",
  /*  241 */ "column_def_list",
  /*  242 */ "tags_def_opt",
  /*  243 */ "table_options",
  /*  244 */ "multi_create_clause",
  /*  245 */ "tags_def",
  /*  246 */ "multi_drop_clause",
  /*  247 */ "alter_table_clause",
  /*  248 */ "alter_table_options",
  /*  249 */ "column_name",
  /*  250 */ "type_name",
  /*  251 */ "create_subtable_clause",
  /*  252 */ "specific_tags_opt",
  /*  253 */ "literal_list",
  /*  254 */ "drop_table_clause",
  /*  255 */ "col_name_list",
  /*  256 */ "table_name",
  /*  257 */ "column_def",
  /*  258 */ "func_name_list",
  /*  259 */ "alter_table_option",
  /*  260 */ "col_name",
  /*  261 */ "db_name_cond_opt",
  /*  262 */ "like_pattern_opt",
  /*  263 */ "table_name_cond",
  /*  264 */ "from_db_opt",
  /*  265 */ "func_name",
  /*  266 */ "function_name",
  /*  267 */ "index_name",
  /*  268 */ "index_options",
  /*  269 */ "func_list",
  /*  270 */ "duration_literal",
  /*  271 */ "sliding_opt",
  /*  272 */ "func",
  /*  273 */ "expression_list",
  /*  274 */ "topic_name",
  /*  275 */ "query_expression",
  /*  276 */ "analyze_opt",
  /*  277 */ "explain_options",
  /*  278 */ "agg_func_opt",
  /*  279 */ "bufsize_opt",
  /*  280 */ "stream_name",
  /*  281 */ "stream_options",
  /*  282 */ "into_opt",
  /*  283 */ "dnode_list",
  /*  284 */ "signed",
  /*  285 */ "signed_literal",
  /*  286 */ "table_alias",
  /*  287 */ "column_alias",
  /*  288 */ "expression",
  /*  289 */ "pseudo_column",
  /*  290 */ "column_reference",
  /*  291 */ "function_expression",
  /*  292 */ "subquery",
  /*  293 */ "star_func",
  /*  294 */ "star_func_para_list",
  /*  295 */ "noarg_func",
  /*  296 */ "other_para_list",
  /*  297 */ "star_func_para",
  /*  298 */ "predicate",
  /*  299 */ "compare_op",
  /*  300 */ "in_op",
  /*  301 */ "in_predicate_value",
  /*  302 */ "boolean_value_expression",
  /*  303 */ "boolean_primary",
  /*  304 */ "common_expression",
  /*  305 */ "from_clause",
  /*  306 */ "table_reference_list",
  /*  307 */ "table_reference",
  /*  308 */ "table_primary",
  /*  309 */ "joined_table",
  /*  310 */ "alias_opt",
  /*  311 */ "parenthesized_joined_table",
  /*  312 */ "join_type",
  /*  313 */ "search_condition",
  /*  314 */ "query_specification",
  /*  315 */ "set_quantifier_opt",
  /*  316 */ "select_list",
  /*  317 */ "where_clause_opt",
  /*  318 */ "partition_by_clause_opt",
  /*  319 */ "twindow_clause_opt",
  /*  320 */ "group_by_clause_opt",
  /*  321 */ "having_clause_opt",
  /*  322 */ "select_sublist",
  /*  323 */ "select_item",
  /*  324 */ "fill_opt",
  /*  325 */ "fill_mode",
  /*  326 */ "group_by_list",
  /*  327 */ "query_expression_body",
  /*  328 */ "order_by_clause_opt",
  /*  329 */ "slimit_clause_opt",
  /*  330 */ "limit_clause_opt",
  /*  331 */ "query_primary",
  /*  332 */ "sort_specification_list",
  /*  333 */ "sort_specification",
  /*  334 */ "ordering_specification_opt",
  /*  335 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  79 */ "alter_db_options ::= alter_db_option",
 /*  80 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  81 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  82 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  83 */ "alter_db_option ::= KEEP integer_list",
 /*  84 */ "alter_db_option ::= KEEP variable_list",
 /*  85 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  86 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  87 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  88 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  89 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  90 */ "integer_list ::= NK_INTEGER",
 /*  91 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  92 */ "variable_list ::= NK_VARIABLE",
 /*  93 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  94 */ "retention_list ::= retention",
 /*  95 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  96 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  97 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  98 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  99 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 100 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 101 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 102 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 103 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 104 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 105 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 107 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 109 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 111 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 112 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 113 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 114 */ "multi_create_clause ::= create_subtable_clause",
 /* 115 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 116 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 117 */ "multi_drop_clause ::= drop_table_clause",
 /* 118 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 119 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 120 */ "specific_tags_opt ::=",
 /* 121 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 122 */ "full_table_name ::= table_name",
 /* 123 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 124 */ "column_def_list ::= column_def",
 /* 125 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 126 */ "column_def ::= column_name type_name",
 /* 127 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 128 */ "type_name ::= BOOL",
 /* 129 */ "type_name ::= TINYINT",
 /* 130 */ "type_name ::= SMALLINT",
 /* 131 */ "type_name ::= INT",
 /* 132 */ "type_name ::= INTEGER",
 /* 133 */ "type_name ::= BIGINT",
 /* 134 */ "type_name ::= FLOAT",
 /* 135 */ "type_name ::= DOUBLE",
 /* 136 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TIMESTAMP",
 /* 138 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 139 */ "type_name ::= TINYINT UNSIGNED",
 /* 140 */ "type_name ::= SMALLINT UNSIGNED",
 /* 141 */ "type_name ::= INT UNSIGNED",
 /* 142 */ "type_name ::= BIGINT UNSIGNED",
 /* 143 */ "type_name ::= JSON",
 /* 144 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 145 */ "type_name ::= MEDIUMBLOB",
 /* 146 */ "type_name ::= BLOB",
 /* 147 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL",
 /* 149 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 150 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 151 */ "tags_def_opt ::=",
 /* 152 */ "tags_def_opt ::= tags_def",
 /* 153 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 154 */ "table_options ::=",
 /* 155 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 156 */ "table_options ::= table_options KEEP integer_list",
 /* 157 */ "table_options ::= table_options KEEP variable_list",
 /* 158 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 159 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 160 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 161 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 162 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 163 */ "alter_table_options ::= alter_table_option",
 /* 164 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 165 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 166 */ "alter_table_option ::= KEEP integer_list",
 /* 167 */ "alter_table_option ::= KEEP variable_list",
 /* 168 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 169 */ "col_name_list ::= col_name",
 /* 170 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 171 */ "col_name ::= column_name",
 /* 172 */ "cmd ::= SHOW DNODES",
 /* 173 */ "cmd ::= SHOW USERS",
 /* 174 */ "cmd ::= SHOW DATABASES",
 /* 175 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 176 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 177 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 178 */ "cmd ::= SHOW MNODES",
 /* 179 */ "cmd ::= SHOW MODULES",
 /* 180 */ "cmd ::= SHOW QNODES",
 /* 181 */ "cmd ::= SHOW FUNCTIONS",
 /* 182 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 183 */ "cmd ::= SHOW STREAMS",
 /* 184 */ "cmd ::= SHOW ACCOUNTS",
 /* 185 */ "cmd ::= SHOW APPS",
 /* 186 */ "cmd ::= SHOW CONNECTIONS",
 /* 187 */ "cmd ::= SHOW LICENCE",
 /* 188 */ "cmd ::= SHOW GRANTS",
 /* 189 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 190 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 191 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 192 */ "cmd ::= SHOW QUERIES",
 /* 193 */ "cmd ::= SHOW SCORES",
 /* 194 */ "cmd ::= SHOW TOPICS",
 /* 195 */ "cmd ::= SHOW VARIABLES",
 /* 196 */ "cmd ::= SHOW BNODES",
 /* 197 */ "cmd ::= SHOW SNODES",
 /* 198 */ "cmd ::= SHOW CLUSTER",
 /* 199 */ "db_name_cond_opt ::=",
 /* 200 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 201 */ "like_pattern_opt ::=",
 /* 202 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 203 */ "table_name_cond ::= table_name",
 /* 204 */ "from_db_opt ::=",
 /* 205 */ "from_db_opt ::= FROM db_name",
 /* 206 */ "func_name_list ::= func_name",
 /* 207 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 208 */ "func_name ::= function_name",
 /* 209 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 210 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 211 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 212 */ "index_options ::=",
 /* 213 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 214 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 215 */ "func_list ::= func",
 /* 216 */ "func_list ::= func_list NK_COMMA func",
 /* 217 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 218 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 219 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 220 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 221 */ "cmd ::= DESC full_table_name",
 /* 222 */ "cmd ::= DESCRIBE full_table_name",
 /* 223 */ "cmd ::= RESET QUERY CACHE",
 /* 224 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 225 */ "analyze_opt ::=",
 /* 226 */ "analyze_opt ::= ANALYZE",
 /* 227 */ "explain_options ::=",
 /* 228 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 229 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 230 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 231 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 232 */ "cmd ::= DROP FUNCTION function_name",
 /* 233 */ "agg_func_opt ::=",
 /* 234 */ "agg_func_opt ::= AGGREGATE",
 /* 235 */ "bufsize_opt ::=",
 /* 236 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 237 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 238 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 239 */ "into_opt ::=",
 /* 240 */ "into_opt ::= INTO full_table_name",
 /* 241 */ "stream_options ::=",
 /* 242 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 243 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 244 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 245 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 246 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 247 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 248 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 249 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 250 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 251 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 252 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 253 */ "cmd ::= query_expression",
 /* 254 */ "literal ::= NK_INTEGER",
 /* 255 */ "literal ::= NK_FLOAT",
 /* 256 */ "literal ::= NK_STRING",
 /* 257 */ "literal ::= NK_BOOL",
 /* 258 */ "literal ::= TIMESTAMP NK_STRING",
 /* 259 */ "literal ::= duration_literal",
 /* 260 */ "literal ::= NULL",
 /* 261 */ "literal ::= NK_QUESTION",
 /* 262 */ "duration_literal ::= NK_VARIABLE",
 /* 263 */ "signed ::= NK_INTEGER",
 /* 264 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 265 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 266 */ "signed ::= NK_FLOAT",
 /* 267 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 268 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 269 */ "signed_literal ::= signed",
 /* 270 */ "signed_literal ::= NK_STRING",
 /* 271 */ "signed_literal ::= NK_BOOL",
 /* 272 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 273 */ "signed_literal ::= duration_literal",
 /* 274 */ "signed_literal ::= NULL",
 /* 275 */ "literal_list ::= signed_literal",
 /* 276 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 277 */ "db_name ::= NK_ID",
 /* 278 */ "table_name ::= NK_ID",
 /* 279 */ "column_name ::= NK_ID",
 /* 280 */ "function_name ::= NK_ID",
 /* 281 */ "table_alias ::= NK_ID",
 /* 282 */ "column_alias ::= NK_ID",
 /* 283 */ "user_name ::= NK_ID",
 /* 284 */ "index_name ::= NK_ID",
 /* 285 */ "topic_name ::= NK_ID",
 /* 286 */ "stream_name ::= NK_ID",
 /* 287 */ "expression ::= literal",
 /* 288 */ "expression ::= pseudo_column",
 /* 289 */ "expression ::= column_reference",
 /* 290 */ "expression ::= function_expression",
 /* 291 */ "expression ::= subquery",
 /* 292 */ "expression ::= NK_LP expression NK_RP",
 /* 293 */ "expression ::= NK_PLUS expression",
 /* 294 */ "expression ::= NK_MINUS expression",
 /* 295 */ "expression ::= expression NK_PLUS expression",
 /* 296 */ "expression ::= expression NK_MINUS expression",
 /* 297 */ "expression ::= expression NK_STAR expression",
 /* 298 */ "expression ::= expression NK_SLASH expression",
 /* 299 */ "expression ::= expression NK_REM expression",
 /* 300 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 301 */ "expression_list ::= expression",
 /* 302 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 303 */ "column_reference ::= column_name",
 /* 304 */ "column_reference ::= table_name NK_DOT column_name",
 /* 305 */ "pseudo_column ::= ROWTS",
 /* 306 */ "pseudo_column ::= TBNAME",
 /* 307 */ "pseudo_column ::= QSTARTTS",
 /* 308 */ "pseudo_column ::= QENDTS",
 /* 309 */ "pseudo_column ::= WSTARTTS",
 /* 310 */ "pseudo_column ::= WENDTS",
 /* 311 */ "pseudo_column ::= WDURATION",
 /* 312 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 313 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 314 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 315 */ "function_expression ::= noarg_func NK_LP NK_RP",
 /* 316 */ "noarg_func ::= NOW",
 /* 317 */ "noarg_func ::= TODAY",
 /* 318 */ "noarg_func ::= TIMEZONE",
 /* 319 */ "star_func ::= COUNT",
 /* 320 */ "star_func ::= FIRST",
 /* 321 */ "star_func ::= LAST",
 /* 322 */ "star_func ::= LAST_ROW",
 /* 323 */ "star_func_para_list ::= NK_STAR",
 /* 324 */ "star_func_para_list ::= other_para_list",
 /* 325 */ "other_para_list ::= star_func_para",
 /* 326 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 327 */ "star_func_para ::= expression",
 /* 328 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 329 */ "predicate ::= expression compare_op expression",
 /* 330 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 331 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 332 */ "predicate ::= expression IS NULL",
 /* 333 */ "predicate ::= expression IS NOT NULL",
 /* 334 */ "predicate ::= expression in_op in_predicate_value",
 /* 335 */ "compare_op ::= NK_LT",
 /* 336 */ "compare_op ::= NK_GT",
 /* 337 */ "compare_op ::= NK_LE",
 /* 338 */ "compare_op ::= NK_GE",
 /* 339 */ "compare_op ::= NK_NE",
 /* 340 */ "compare_op ::= NK_EQ",
 /* 341 */ "compare_op ::= LIKE",
 /* 342 */ "compare_op ::= NOT LIKE",
 /* 343 */ "compare_op ::= MATCH",
 /* 344 */ "compare_op ::= NMATCH",
 /* 345 */ "compare_op ::= CONTAINS",
 /* 346 */ "in_op ::= IN",
 /* 347 */ "in_op ::= NOT IN",
 /* 348 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 349 */ "boolean_value_expression ::= boolean_primary",
 /* 350 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 351 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 352 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 353 */ "boolean_primary ::= predicate",
 /* 354 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 355 */ "common_expression ::= expression",
 /* 356 */ "common_expression ::= boolean_value_expression",
 /* 357 */ "from_clause ::= FROM table_reference_list",
 /* 358 */ "table_reference_list ::= table_reference",
 /* 359 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 360 */ "table_reference ::= table_primary",
 /* 361 */ "table_reference ::= joined_table",
 /* 362 */ "table_primary ::= table_name alias_opt",
 /* 363 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 364 */ "table_primary ::= subquery alias_opt",
 /* 365 */ "table_primary ::= parenthesized_joined_table",
 /* 366 */ "alias_opt ::=",
 /* 367 */ "alias_opt ::= table_alias",
 /* 368 */ "alias_opt ::= AS table_alias",
 /* 369 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 370 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 371 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 372 */ "join_type ::=",
 /* 373 */ "join_type ::= INNER",
 /* 374 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 375 */ "set_quantifier_opt ::=",
 /* 376 */ "set_quantifier_opt ::= DISTINCT",
 /* 377 */ "set_quantifier_opt ::= ALL",
 /* 378 */ "select_list ::= NK_STAR",
 /* 379 */ "select_list ::= select_sublist",
 /* 380 */ "select_sublist ::= select_item",
 /* 381 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 382 */ "select_item ::= common_expression",
 /* 383 */ "select_item ::= common_expression column_alias",
 /* 384 */ "select_item ::= common_expression AS column_alias",
 /* 385 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 386 */ "where_clause_opt ::=",
 /* 387 */ "where_clause_opt ::= WHERE search_condition",
 /* 388 */ "partition_by_clause_opt ::=",
 /* 389 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 390 */ "twindow_clause_opt ::=",
 /* 391 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 392 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 393 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 394 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 395 */ "sliding_opt ::=",
 /* 396 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 397 */ "fill_opt ::=",
 /* 398 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 399 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 400 */ "fill_mode ::= NONE",
 /* 401 */ "fill_mode ::= PREV",
 /* 402 */ "fill_mode ::= NULL",
 /* 403 */ "fill_mode ::= LINEAR",
 /* 404 */ "fill_mode ::= NEXT",
 /* 405 */ "group_by_clause_opt ::=",
 /* 406 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 407 */ "group_by_list ::= expression",
 /* 408 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 409 */ "having_clause_opt ::=",
 /* 410 */ "having_clause_opt ::= HAVING search_condition",
 /* 411 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 412 */ "query_expression_body ::= query_primary",
 /* 413 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 414 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 415 */ "query_primary ::= query_specification",
 /* 416 */ "order_by_clause_opt ::=",
 /* 417 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 418 */ "slimit_clause_opt ::=",
 /* 419 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 420 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 421 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 422 */ "limit_clause_opt ::=",
 /* 423 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 424 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 425 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 426 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 427 */ "search_condition ::= common_expression",
 /* 428 */ "sort_specification_list ::= sort_specification",
 /* 429 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 430 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 431 */ "ordering_specification_opt ::=",
 /* 432 */ "ordering_specification_opt ::= ASC",
 /* 433 */ "ordering_specification_opt ::= DESC",
 /* 434 */ "null_ordering_opt ::=",
 /* 435 */ "null_ordering_opt ::= NULLS FIRST",
 /* 436 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 222: /* cmd */
    case 225: /* literal */
    case 232: /* db_options */
    case 234: /* alter_db_options */
    case 239: /* retention */
    case 240: /* full_table_name */
    case 243: /* table_options */
    case 247: /* alter_table_clause */
    case 248: /* alter_table_options */
    case 251: /* create_subtable_clause */
    case 254: /* drop_table_clause */
    case 257: /* column_def */
    case 260: /* col_name */
    case 261: /* db_name_cond_opt */
    case 262: /* like_pattern_opt */
    case 263: /* table_name_cond */
    case 264: /* from_db_opt */
    case 265: /* func_name */
    case 268: /* index_options */
    case 270: /* duration_literal */
    case 271: /* sliding_opt */
    case 272: /* func */
    case 275: /* query_expression */
    case 277: /* explain_options */
    case 281: /* stream_options */
    case 282: /* into_opt */
    case 284: /* signed */
    case 285: /* signed_literal */
    case 288: /* expression */
    case 289: /* pseudo_column */
    case 290: /* column_reference */
    case 291: /* function_expression */
    case 292: /* subquery */
    case 297: /* star_func_para */
    case 298: /* predicate */
    case 301: /* in_predicate_value */
    case 302: /* boolean_value_expression */
    case 303: /* boolean_primary */
    case 304: /* common_expression */
    case 305: /* from_clause */
    case 306: /* table_reference_list */
    case 307: /* table_reference */
    case 308: /* table_primary */
    case 309: /* joined_table */
    case 311: /* parenthesized_joined_table */
    case 313: /* search_condition */
    case 314: /* query_specification */
    case 317: /* where_clause_opt */
    case 319: /* twindow_clause_opt */
    case 321: /* having_clause_opt */
    case 323: /* select_item */
    case 324: /* fill_opt */
    case 327: /* query_expression_body */
    case 329: /* slimit_clause_opt */
    case 330: /* limit_clause_opt */
    case 331: /* query_primary */
    case 333: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy392)); 
}
      break;
    case 223: /* account_options */
    case 224: /* alter_account_options */
    case 226: /* alter_account_option */
    case 279: /* bufsize_opt */
{
 
}
      break;
    case 227: /* user_name */
    case 228: /* dnode_endpoint */
    case 229: /* dnode_host_name */
    case 231: /* db_name */
    case 249: /* column_name */
    case 256: /* table_name */
    case 266: /* function_name */
    case 267: /* index_name */
    case 274: /* topic_name */
    case 280: /* stream_name */
    case 286: /* table_alias */
    case 287: /* column_alias */
    case 293: /* star_func */
    case 295: /* noarg_func */
    case 310: /* alias_opt */
{
 
}
      break;
    case 230: /* not_exists_opt */
    case 233: /* exists_opt */
    case 276: /* analyze_opt */
    case 278: /* agg_func_opt */
    case 315: /* set_quantifier_opt */
{
 
}
      break;
    case 235: /* integer_list */
    case 236: /* variable_list */
    case 237: /* retention_list */
    case 241: /* column_def_list */
    case 242: /* tags_def_opt */
    case 244: /* multi_create_clause */
    case 245: /* tags_def */
    case 246: /* multi_drop_clause */
    case 252: /* specific_tags_opt */
    case 253: /* literal_list */
    case 255: /* col_name_list */
    case 258: /* func_name_list */
    case 269: /* func_list */
    case 273: /* expression_list */
    case 283: /* dnode_list */
    case 294: /* star_func_para_list */
    case 296: /* other_para_list */
    case 316: /* select_list */
    case 318: /* partition_by_clause_opt */
    case 320: /* group_by_clause_opt */
    case 322: /* select_sublist */
    case 326: /* group_by_list */
    case 328: /* order_by_clause_opt */
    case 332: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy376)); 
}
      break;
    case 238: /* alter_db_option */
    case 259: /* alter_table_option */
{
 
}
      break;
    case 250: /* type_name */
{
 
}
      break;
    case 299: /* compare_op */
    case 300: /* in_op */
{
 
}
      break;
    case 312: /* join_type */
{
 
}
      break;
    case 325: /* fill_mode */
{
 
}
      break;
    case 334: /* ordering_specification_opt */
{
 
}
      break;
    case 335: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  222,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  222,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  223,    0 }, /* (2) account_options ::= */
  {  223,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  223,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  223,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  223,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  223,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  223,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  223,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  223,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  223,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  224,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  224,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  226,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  226,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  226,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  226,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  226,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  226,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  226,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  226,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  226,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  226,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  222,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  222,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  222,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  222,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  222,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  222,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  222,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  222,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  222,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  222,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  222,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  222,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  228,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  229,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  229,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  222,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  222,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  222,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  222,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  222,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  222,   -2 }, /* (51) cmd ::= USE db_name */
  {  222,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  230,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  230,    0 }, /* (54) not_exists_opt ::= */
  {  233,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  233,    0 }, /* (56) exists_opt ::= */
  {  232,    0 }, /* (57) db_options ::= */
  {  232,   -3 }, /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
  {  232,   -3 }, /* (59) db_options ::= db_options CACHE NK_INTEGER */
  {  232,   -3 }, /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
  {  232,   -3 }, /* (61) db_options ::= db_options COMP NK_INTEGER */
  {  232,   -3 }, /* (62) db_options ::= db_options DAYS NK_INTEGER */
  {  232,   -3 }, /* (63) db_options ::= db_options DAYS NK_VARIABLE */
  {  232,   -3 }, /* (64) db_options ::= db_options FSYNC NK_INTEGER */
  {  232,   -3 }, /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
  {  232,   -3 }, /* (66) db_options ::= db_options MINROWS NK_INTEGER */
  {  232,   -3 }, /* (67) db_options ::= db_options KEEP integer_list */
  {  232,   -3 }, /* (68) db_options ::= db_options KEEP variable_list */
  {  232,   -3 }, /* (69) db_options ::= db_options PRECISION NK_STRING */
  {  232,   -3 }, /* (70) db_options ::= db_options QUORUM NK_INTEGER */
  {  232,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  232,   -3 }, /* (72) db_options ::= db_options TTL NK_INTEGER */
  {  232,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  232,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  232,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  232,   -3 }, /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  232,   -3 }, /* (77) db_options ::= db_options RETENTIONS retention_list */
  {  232,   -3 }, /* (78) db_options ::= db_options STRICT NK_INTEGER */
  {  234,   -1 }, /* (79) alter_db_options ::= alter_db_option */
  {  234,   -2 }, /* (80) alter_db_options ::= alter_db_options alter_db_option */
  {  238,   -2 }, /* (81) alter_db_option ::= BLOCKS NK_INTEGER */
  {  238,   -2 }, /* (82) alter_db_option ::= FSYNC NK_INTEGER */
  {  238,   -2 }, /* (83) alter_db_option ::= KEEP integer_list */
  {  238,   -2 }, /* (84) alter_db_option ::= KEEP variable_list */
  {  238,   -2 }, /* (85) alter_db_option ::= WAL NK_INTEGER */
  {  238,   -2 }, /* (86) alter_db_option ::= QUORUM NK_INTEGER */
  {  238,   -2 }, /* (87) alter_db_option ::= CACHELAST NK_INTEGER */
  {  238,   -2 }, /* (88) alter_db_option ::= REPLICA NK_INTEGER */
  {  238,   -2 }, /* (89) alter_db_option ::= STRICT NK_INTEGER */
  {  235,   -1 }, /* (90) integer_list ::= NK_INTEGER */
  {  235,   -3 }, /* (91) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  236,   -1 }, /* (92) variable_list ::= NK_VARIABLE */
  {  236,   -3 }, /* (93) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  237,   -1 }, /* (94) retention_list ::= retention */
  {  237,   -3 }, /* (95) retention_list ::= retention_list NK_COMMA retention */
  {  239,   -3 }, /* (96) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  222,   -9 }, /* (97) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  222,   -3 }, /* (98) cmd ::= CREATE TABLE multi_create_clause */
  {  222,   -9 }, /* (99) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  222,   -3 }, /* (100) cmd ::= DROP TABLE multi_drop_clause */
  {  222,   -4 }, /* (101) cmd ::= DROP STABLE exists_opt full_table_name */
  {  222,   -3 }, /* (102) cmd ::= ALTER TABLE alter_table_clause */
  {  222,   -3 }, /* (103) cmd ::= ALTER STABLE alter_table_clause */
  {  247,   -2 }, /* (104) alter_table_clause ::= full_table_name alter_table_options */
  {  247,   -5 }, /* (105) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  247,   -4 }, /* (106) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  247,   -5 }, /* (107) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  247,   -5 }, /* (108) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  247,   -5 }, /* (109) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  247,   -4 }, /* (110) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  247,   -5 }, /* (111) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  247,   -5 }, /* (112) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  247,   -6 }, /* (113) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  244,   -1 }, /* (114) multi_create_clause ::= create_subtable_clause */
  {  244,   -2 }, /* (115) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  251,   -9 }, /* (116) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  246,   -1 }, /* (117) multi_drop_clause ::= drop_table_clause */
  {  246,   -2 }, /* (118) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  254,   -2 }, /* (119) drop_table_clause ::= exists_opt full_table_name */
  {  252,    0 }, /* (120) specific_tags_opt ::= */
  {  252,   -3 }, /* (121) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  240,   -1 }, /* (122) full_table_name ::= table_name */
  {  240,   -3 }, /* (123) full_table_name ::= db_name NK_DOT table_name */
  {  241,   -1 }, /* (124) column_def_list ::= column_def */
  {  241,   -3 }, /* (125) column_def_list ::= column_def_list NK_COMMA column_def */
  {  257,   -2 }, /* (126) column_def ::= column_name type_name */
  {  257,   -4 }, /* (127) column_def ::= column_name type_name COMMENT NK_STRING */
  {  250,   -1 }, /* (128) type_name ::= BOOL */
  {  250,   -1 }, /* (129) type_name ::= TINYINT */
  {  250,   -1 }, /* (130) type_name ::= SMALLINT */
  {  250,   -1 }, /* (131) type_name ::= INT */
  {  250,   -1 }, /* (132) type_name ::= INTEGER */
  {  250,   -1 }, /* (133) type_name ::= BIGINT */
  {  250,   -1 }, /* (134) type_name ::= FLOAT */
  {  250,   -1 }, /* (135) type_name ::= DOUBLE */
  {  250,   -4 }, /* (136) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  250,   -1 }, /* (137) type_name ::= TIMESTAMP */
  {  250,   -4 }, /* (138) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  250,   -2 }, /* (139) type_name ::= TINYINT UNSIGNED */
  {  250,   -2 }, /* (140) type_name ::= SMALLINT UNSIGNED */
  {  250,   -2 }, /* (141) type_name ::= INT UNSIGNED */
  {  250,   -2 }, /* (142) type_name ::= BIGINT UNSIGNED */
  {  250,   -1 }, /* (143) type_name ::= JSON */
  {  250,   -4 }, /* (144) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  250,   -1 }, /* (145) type_name ::= MEDIUMBLOB */
  {  250,   -1 }, /* (146) type_name ::= BLOB */
  {  250,   -4 }, /* (147) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  250,   -1 }, /* (148) type_name ::= DECIMAL */
  {  250,   -4 }, /* (149) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  250,   -6 }, /* (150) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  242,    0 }, /* (151) tags_def_opt ::= */
  {  242,   -1 }, /* (152) tags_def_opt ::= tags_def */
  {  245,   -4 }, /* (153) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  243,    0 }, /* (154) table_options ::= */
  {  243,   -3 }, /* (155) table_options ::= table_options COMMENT NK_STRING */
  {  243,   -3 }, /* (156) table_options ::= table_options KEEP integer_list */
  {  243,   -3 }, /* (157) table_options ::= table_options KEEP variable_list */
  {  243,   -3 }, /* (158) table_options ::= table_options TTL NK_INTEGER */
  {  243,   -5 }, /* (159) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  243,   -5 }, /* (160) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  243,   -3 }, /* (161) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  243,   -3 }, /* (162) table_options ::= table_options DELAY NK_INTEGER */
  {  248,   -1 }, /* (163) alter_table_options ::= alter_table_option */
  {  248,   -2 }, /* (164) alter_table_options ::= alter_table_options alter_table_option */
  {  259,   -2 }, /* (165) alter_table_option ::= COMMENT NK_STRING */
  {  259,   -2 }, /* (166) alter_table_option ::= KEEP integer_list */
  {  259,   -2 }, /* (167) alter_table_option ::= KEEP variable_list */
  {  259,   -2 }, /* (168) alter_table_option ::= TTL NK_INTEGER */
  {  255,   -1 }, /* (169) col_name_list ::= col_name */
  {  255,   -3 }, /* (170) col_name_list ::= col_name_list NK_COMMA col_name */
  {  260,   -1 }, /* (171) col_name ::= column_name */
  {  222,   -2 }, /* (172) cmd ::= SHOW DNODES */
  {  222,   -2 }, /* (173) cmd ::= SHOW USERS */
  {  222,   -2 }, /* (174) cmd ::= SHOW DATABASES */
  {  222,   -4 }, /* (175) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  222,   -4 }, /* (176) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  222,   -3 }, /* (177) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  222,   -2 }, /* (178) cmd ::= SHOW MNODES */
  {  222,   -2 }, /* (179) cmd ::= SHOW MODULES */
  {  222,   -2 }, /* (180) cmd ::= SHOW QNODES */
  {  222,   -2 }, /* (181) cmd ::= SHOW FUNCTIONS */
  {  222,   -5 }, /* (182) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  222,   -2 }, /* (183) cmd ::= SHOW STREAMS */
  {  222,   -2 }, /* (184) cmd ::= SHOW ACCOUNTS */
  {  222,   -2 }, /* (185) cmd ::= SHOW APPS */
  {  222,   -2 }, /* (186) cmd ::= SHOW CONNECTIONS */
  {  222,   -2 }, /* (187) cmd ::= SHOW LICENCE */
  {  222,   -2 }, /* (188) cmd ::= SHOW GRANTS */
  {  222,   -4 }, /* (189) cmd ::= SHOW CREATE DATABASE db_name */
  {  222,   -4 }, /* (190) cmd ::= SHOW CREATE TABLE full_table_name */
  {  222,   -4 }, /* (191) cmd ::= SHOW CREATE STABLE full_table_name */
  {  222,   -2 }, /* (192) cmd ::= SHOW QUERIES */
  {  222,   -2 }, /* (193) cmd ::= SHOW SCORES */
  {  222,   -2 }, /* (194) cmd ::= SHOW TOPICS */
  {  222,   -2 }, /* (195) cmd ::= SHOW VARIABLES */
  {  222,   -2 }, /* (196) cmd ::= SHOW BNODES */
  {  222,   -2 }, /* (197) cmd ::= SHOW SNODES */
  {  222,   -2 }, /* (198) cmd ::= SHOW CLUSTER */
  {  261,    0 }, /* (199) db_name_cond_opt ::= */
  {  261,   -2 }, /* (200) db_name_cond_opt ::= db_name NK_DOT */
  {  262,    0 }, /* (201) like_pattern_opt ::= */
  {  262,   -2 }, /* (202) like_pattern_opt ::= LIKE NK_STRING */
  {  263,   -1 }, /* (203) table_name_cond ::= table_name */
  {  264,    0 }, /* (204) from_db_opt ::= */
  {  264,   -2 }, /* (205) from_db_opt ::= FROM db_name */
  {  258,   -1 }, /* (206) func_name_list ::= func_name */
  {  258,   -3 }, /* (207) func_name_list ::= func_name_list NK_COMMA func_name */
  {  265,   -1 }, /* (208) func_name ::= function_name */
  {  222,   -8 }, /* (209) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  222,  -10 }, /* (210) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  222,   -6 }, /* (211) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  268,    0 }, /* (212) index_options ::= */
  {  268,   -9 }, /* (213) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  268,  -11 }, /* (214) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  269,   -1 }, /* (215) func_list ::= func */
  {  269,   -3 }, /* (216) func_list ::= func_list NK_COMMA func */
  {  272,   -4 }, /* (217) func ::= function_name NK_LP expression_list NK_RP */
  {  222,   -6 }, /* (218) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  222,   -6 }, /* (219) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  222,   -4 }, /* (220) cmd ::= DROP TOPIC exists_opt topic_name */
  {  222,   -2 }, /* (221) cmd ::= DESC full_table_name */
  {  222,   -2 }, /* (222) cmd ::= DESCRIBE full_table_name */
  {  222,   -3 }, /* (223) cmd ::= RESET QUERY CACHE */
  {  222,   -4 }, /* (224) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  276,    0 }, /* (225) analyze_opt ::= */
  {  276,   -1 }, /* (226) analyze_opt ::= ANALYZE */
  {  277,    0 }, /* (227) explain_options ::= */
  {  277,   -3 }, /* (228) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  277,   -3 }, /* (229) explain_options ::= explain_options RATIO NK_FLOAT */
  {  222,   -6 }, /* (230) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  222,  -10 }, /* (231) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  222,   -3 }, /* (232) cmd ::= DROP FUNCTION function_name */
  {  278,    0 }, /* (233) agg_func_opt ::= */
  {  278,   -1 }, /* (234) agg_func_opt ::= AGGREGATE */
  {  279,    0 }, /* (235) bufsize_opt ::= */
  {  279,   -2 }, /* (236) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  222,   -8 }, /* (237) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  222,   -4 }, /* (238) cmd ::= DROP STREAM exists_opt stream_name */
  {  282,    0 }, /* (239) into_opt ::= */
  {  282,   -2 }, /* (240) into_opt ::= INTO full_table_name */
  {  281,    0 }, /* (241) stream_options ::= */
  {  281,   -3 }, /* (242) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  281,   -3 }, /* (243) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  281,   -3 }, /* (244) stream_options ::= stream_options WATERMARK duration_literal */
  {  222,   -3 }, /* (245) cmd ::= KILL CONNECTION NK_INTEGER */
  {  222,   -3 }, /* (246) cmd ::= KILL QUERY NK_INTEGER */
  {  222,   -4 }, /* (247) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  222,   -4 }, /* (248) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  222,   -3 }, /* (249) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  283,   -2 }, /* (250) dnode_list ::= DNODE NK_INTEGER */
  {  283,   -3 }, /* (251) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  222,   -3 }, /* (252) cmd ::= SYNCDB db_name REPLICA */
  {  222,   -1 }, /* (253) cmd ::= query_expression */
  {  225,   -1 }, /* (254) literal ::= NK_INTEGER */
  {  225,   -1 }, /* (255) literal ::= NK_FLOAT */
  {  225,   -1 }, /* (256) literal ::= NK_STRING */
  {  225,   -1 }, /* (257) literal ::= NK_BOOL */
  {  225,   -2 }, /* (258) literal ::= TIMESTAMP NK_STRING */
  {  225,   -1 }, /* (259) literal ::= duration_literal */
  {  225,   -1 }, /* (260) literal ::= NULL */
  {  225,   -1 }, /* (261) literal ::= NK_QUESTION */
  {  270,   -1 }, /* (262) duration_literal ::= NK_VARIABLE */
  {  284,   -1 }, /* (263) signed ::= NK_INTEGER */
  {  284,   -2 }, /* (264) signed ::= NK_PLUS NK_INTEGER */
  {  284,   -2 }, /* (265) signed ::= NK_MINUS NK_INTEGER */
  {  284,   -1 }, /* (266) signed ::= NK_FLOAT */
  {  284,   -2 }, /* (267) signed ::= NK_PLUS NK_FLOAT */
  {  284,   -2 }, /* (268) signed ::= NK_MINUS NK_FLOAT */
  {  285,   -1 }, /* (269) signed_literal ::= signed */
  {  285,   -1 }, /* (270) signed_literal ::= NK_STRING */
  {  285,   -1 }, /* (271) signed_literal ::= NK_BOOL */
  {  285,   -2 }, /* (272) signed_literal ::= TIMESTAMP NK_STRING */
  {  285,   -1 }, /* (273) signed_literal ::= duration_literal */
  {  285,   -1 }, /* (274) signed_literal ::= NULL */
  {  253,   -1 }, /* (275) literal_list ::= signed_literal */
  {  253,   -3 }, /* (276) literal_list ::= literal_list NK_COMMA signed_literal */
  {  231,   -1 }, /* (277) db_name ::= NK_ID */
  {  256,   -1 }, /* (278) table_name ::= NK_ID */
  {  249,   -1 }, /* (279) column_name ::= NK_ID */
  {  266,   -1 }, /* (280) function_name ::= NK_ID */
  {  286,   -1 }, /* (281) table_alias ::= NK_ID */
  {  287,   -1 }, /* (282) column_alias ::= NK_ID */
  {  227,   -1 }, /* (283) user_name ::= NK_ID */
  {  267,   -1 }, /* (284) index_name ::= NK_ID */
  {  274,   -1 }, /* (285) topic_name ::= NK_ID */
  {  280,   -1 }, /* (286) stream_name ::= NK_ID */
  {  288,   -1 }, /* (287) expression ::= literal */
  {  288,   -1 }, /* (288) expression ::= pseudo_column */
  {  288,   -1 }, /* (289) expression ::= column_reference */
  {  288,   -1 }, /* (290) expression ::= function_expression */
  {  288,   -1 }, /* (291) expression ::= subquery */
  {  288,   -3 }, /* (292) expression ::= NK_LP expression NK_RP */
  {  288,   -2 }, /* (293) expression ::= NK_PLUS expression */
  {  288,   -2 }, /* (294) expression ::= NK_MINUS expression */
  {  288,   -3 }, /* (295) expression ::= expression NK_PLUS expression */
  {  288,   -3 }, /* (296) expression ::= expression NK_MINUS expression */
  {  288,   -3 }, /* (297) expression ::= expression NK_STAR expression */
  {  288,   -3 }, /* (298) expression ::= expression NK_SLASH expression */
  {  288,   -3 }, /* (299) expression ::= expression NK_REM expression */
  {  288,   -3 }, /* (300) expression ::= column_reference NK_ARROW NK_STRING */
  {  273,   -1 }, /* (301) expression_list ::= expression */
  {  273,   -3 }, /* (302) expression_list ::= expression_list NK_COMMA expression */
  {  290,   -1 }, /* (303) column_reference ::= column_name */
  {  290,   -3 }, /* (304) column_reference ::= table_name NK_DOT column_name */
  {  289,   -1 }, /* (305) pseudo_column ::= ROWTS */
  {  289,   -1 }, /* (306) pseudo_column ::= TBNAME */
  {  289,   -1 }, /* (307) pseudo_column ::= QSTARTTS */
  {  289,   -1 }, /* (308) pseudo_column ::= QENDTS */
  {  289,   -1 }, /* (309) pseudo_column ::= WSTARTTS */
  {  289,   -1 }, /* (310) pseudo_column ::= WENDTS */
  {  289,   -1 }, /* (311) pseudo_column ::= WDURATION */
  {  291,   -4 }, /* (312) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  291,   -4 }, /* (313) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  291,   -6 }, /* (314) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  291,   -3 }, /* (315) function_expression ::= noarg_func NK_LP NK_RP */
  {  295,   -1 }, /* (316) noarg_func ::= NOW */
  {  295,   -1 }, /* (317) noarg_func ::= TODAY */
  {  295,   -1 }, /* (318) noarg_func ::= TIMEZONE */
  {  293,   -1 }, /* (319) star_func ::= COUNT */
  {  293,   -1 }, /* (320) star_func ::= FIRST */
  {  293,   -1 }, /* (321) star_func ::= LAST */
  {  293,   -1 }, /* (322) star_func ::= LAST_ROW */
  {  294,   -1 }, /* (323) star_func_para_list ::= NK_STAR */
  {  294,   -1 }, /* (324) star_func_para_list ::= other_para_list */
  {  296,   -1 }, /* (325) other_para_list ::= star_func_para */
  {  296,   -3 }, /* (326) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  297,   -1 }, /* (327) star_func_para ::= expression */
  {  297,   -3 }, /* (328) star_func_para ::= table_name NK_DOT NK_STAR */
  {  298,   -3 }, /* (329) predicate ::= expression compare_op expression */
  {  298,   -5 }, /* (330) predicate ::= expression BETWEEN expression AND expression */
  {  298,   -6 }, /* (331) predicate ::= expression NOT BETWEEN expression AND expression */
  {  298,   -3 }, /* (332) predicate ::= expression IS NULL */
  {  298,   -4 }, /* (333) predicate ::= expression IS NOT NULL */
  {  298,   -3 }, /* (334) predicate ::= expression in_op in_predicate_value */
  {  299,   -1 }, /* (335) compare_op ::= NK_LT */
  {  299,   -1 }, /* (336) compare_op ::= NK_GT */
  {  299,   -1 }, /* (337) compare_op ::= NK_LE */
  {  299,   -1 }, /* (338) compare_op ::= NK_GE */
  {  299,   -1 }, /* (339) compare_op ::= NK_NE */
  {  299,   -1 }, /* (340) compare_op ::= NK_EQ */
  {  299,   -1 }, /* (341) compare_op ::= LIKE */
  {  299,   -2 }, /* (342) compare_op ::= NOT LIKE */
  {  299,   -1 }, /* (343) compare_op ::= MATCH */
  {  299,   -1 }, /* (344) compare_op ::= NMATCH */
  {  299,   -1 }, /* (345) compare_op ::= CONTAINS */
  {  300,   -1 }, /* (346) in_op ::= IN */
  {  300,   -2 }, /* (347) in_op ::= NOT IN */
  {  301,   -3 }, /* (348) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  302,   -1 }, /* (349) boolean_value_expression ::= boolean_primary */
  {  302,   -2 }, /* (350) boolean_value_expression ::= NOT boolean_primary */
  {  302,   -3 }, /* (351) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  302,   -3 }, /* (352) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  303,   -1 }, /* (353) boolean_primary ::= predicate */
  {  303,   -3 }, /* (354) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  304,   -1 }, /* (355) common_expression ::= expression */
  {  304,   -1 }, /* (356) common_expression ::= boolean_value_expression */
  {  305,   -2 }, /* (357) from_clause ::= FROM table_reference_list */
  {  306,   -1 }, /* (358) table_reference_list ::= table_reference */
  {  306,   -3 }, /* (359) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  307,   -1 }, /* (360) table_reference ::= table_primary */
  {  307,   -1 }, /* (361) table_reference ::= joined_table */
  {  308,   -2 }, /* (362) table_primary ::= table_name alias_opt */
  {  308,   -4 }, /* (363) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  308,   -2 }, /* (364) table_primary ::= subquery alias_opt */
  {  308,   -1 }, /* (365) table_primary ::= parenthesized_joined_table */
  {  310,    0 }, /* (366) alias_opt ::= */
  {  310,   -1 }, /* (367) alias_opt ::= table_alias */
  {  310,   -2 }, /* (368) alias_opt ::= AS table_alias */
  {  311,   -3 }, /* (369) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  311,   -3 }, /* (370) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  309,   -6 }, /* (371) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  312,    0 }, /* (372) join_type ::= */
  {  312,   -1 }, /* (373) join_type ::= INNER */
  {  314,   -9 }, /* (374) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  315,    0 }, /* (375) set_quantifier_opt ::= */
  {  315,   -1 }, /* (376) set_quantifier_opt ::= DISTINCT */
  {  315,   -1 }, /* (377) set_quantifier_opt ::= ALL */
  {  316,   -1 }, /* (378) select_list ::= NK_STAR */
  {  316,   -1 }, /* (379) select_list ::= select_sublist */
  {  322,   -1 }, /* (380) select_sublist ::= select_item */
  {  322,   -3 }, /* (381) select_sublist ::= select_sublist NK_COMMA select_item */
  {  323,   -1 }, /* (382) select_item ::= common_expression */
  {  323,   -2 }, /* (383) select_item ::= common_expression column_alias */
  {  323,   -3 }, /* (384) select_item ::= common_expression AS column_alias */
  {  323,   -3 }, /* (385) select_item ::= table_name NK_DOT NK_STAR */
  {  317,    0 }, /* (386) where_clause_opt ::= */
  {  317,   -2 }, /* (387) where_clause_opt ::= WHERE search_condition */
  {  318,    0 }, /* (388) partition_by_clause_opt ::= */
  {  318,   -3 }, /* (389) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  319,    0 }, /* (390) twindow_clause_opt ::= */
  {  319,   -6 }, /* (391) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  319,   -4 }, /* (392) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  319,   -6 }, /* (393) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  319,   -8 }, /* (394) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  271,    0 }, /* (395) sliding_opt ::= */
  {  271,   -4 }, /* (396) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  324,    0 }, /* (397) fill_opt ::= */
  {  324,   -4 }, /* (398) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  324,   -6 }, /* (399) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  325,   -1 }, /* (400) fill_mode ::= NONE */
  {  325,   -1 }, /* (401) fill_mode ::= PREV */
  {  325,   -1 }, /* (402) fill_mode ::= NULL */
  {  325,   -1 }, /* (403) fill_mode ::= LINEAR */
  {  325,   -1 }, /* (404) fill_mode ::= NEXT */
  {  320,    0 }, /* (405) group_by_clause_opt ::= */
  {  320,   -3 }, /* (406) group_by_clause_opt ::= GROUP BY group_by_list */
  {  326,   -1 }, /* (407) group_by_list ::= expression */
  {  326,   -3 }, /* (408) group_by_list ::= group_by_list NK_COMMA expression */
  {  321,    0 }, /* (409) having_clause_opt ::= */
  {  321,   -2 }, /* (410) having_clause_opt ::= HAVING search_condition */
  {  275,   -4 }, /* (411) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  327,   -1 }, /* (412) query_expression_body ::= query_primary */
  {  327,   -4 }, /* (413) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  327,   -3 }, /* (414) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  331,   -1 }, /* (415) query_primary ::= query_specification */
  {  328,    0 }, /* (416) order_by_clause_opt ::= */
  {  328,   -3 }, /* (417) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  329,    0 }, /* (418) slimit_clause_opt ::= */
  {  329,   -2 }, /* (419) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  329,   -4 }, /* (420) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  329,   -4 }, /* (421) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  330,    0 }, /* (422) limit_clause_opt ::= */
  {  330,   -2 }, /* (423) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  330,   -4 }, /* (424) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  330,   -4 }, /* (425) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  292,   -3 }, /* (426) subquery ::= NK_LP query_expression NK_RP */
  {  313,   -1 }, /* (427) search_condition ::= common_expression */
  {  332,   -1 }, /* (428) sort_specification_list ::= sort_specification */
  {  332,   -3 }, /* (429) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  333,   -3 }, /* (430) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  334,    0 }, /* (431) ordering_specification_opt ::= */
  {  334,   -1 }, /* (432) ordering_specification_opt ::= ASC */
  {  334,   -1 }, /* (433) ordering_specification_opt ::= DESC */
  {  335,    0 }, /* (434) null_ordering_opt ::= */
  {  335,   -2 }, /* (435) null_ordering_opt ::= NULLS FIRST */
  {  335,   -2 }, /* (436) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,223,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,224,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,223,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,225,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,226,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,224,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,226,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,225,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy449, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy449, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy449); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy449, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy449); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 277: /* db_name ::= NK_ID */ yytestcase(yyruleno==277);
      case 278: /* table_name ::= NK_ID */ yytestcase(yyruleno==278);
      case 279: /* column_name ::= NK_ID */ yytestcase(yyruleno==279);
      case 280: /* function_name ::= NK_ID */ yytestcase(yyruleno==280);
      case 281: /* table_alias ::= NK_ID */ yytestcase(yyruleno==281);
      case 282: /* column_alias ::= NK_ID */ yytestcase(yyruleno==282);
      case 283: /* user_name ::= NK_ID */ yytestcase(yyruleno==283);
      case 284: /* index_name ::= NK_ID */ yytestcase(yyruleno==284);
      case 285: /* topic_name ::= NK_ID */ yytestcase(yyruleno==285);
      case 286: /* stream_name ::= NK_ID */ yytestcase(yyruleno==286);
      case 316: /* noarg_func ::= NOW */ yytestcase(yyruleno==316);
      case 317: /* noarg_func ::= TODAY */ yytestcase(yyruleno==317);
      case 318: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==318);
      case 319: /* star_func ::= COUNT */ yytestcase(yyruleno==319);
      case 320: /* star_func ::= FIRST */ yytestcase(yyruleno==320);
      case 321: /* star_func ::= LAST */ yytestcase(yyruleno==321);
      case 322: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==322);
{ yylhsminor.yy449 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy449 = yylhsminor.yy449;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy89, &yymsp[-1].minor.yy449, yymsp[0].minor.yy392); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy449); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy449); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy449, yymsp[0].minor.yy392); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy89 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 225: /* analyze_opt ::= */ yytestcase(yyruleno==225);
      case 233: /* agg_func_opt ::= */ yytestcase(yyruleno==233);
      case 375: /* set_quantifier_opt ::= */ yytestcase(yyruleno==375);
{ yymsp[1].minor.yy89 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy89 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy392 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pKeep = yymsp[0].minor.yy376; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pRetentions = yymsp[0].minor.yy376; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 78: /* db_options ::= db_options STRICT NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy392)->pStrict = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 79: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy392 = createDatabaseOptions(pCxt); yylhsminor.yy392 = setDatabaseAlterOption(pCxt, yylhsminor.yy392, &yymsp[0].minor.yy221); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 80: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy392 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy392, &yymsp[0].minor.yy221); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 81: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 83: /* alter_db_option ::= KEEP integer_list */
      case 84: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==84);
{ yymsp[-1].minor.yy221.type = DB_OPTION_KEEP; yymsp[-1].minor.yy221.pList = yymsp[0].minor.yy376; }
        break;
      case 85: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_WAL; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 89: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_STRICT; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 90: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 91: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 251: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==251);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 92: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy376 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 93: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 94: /* retention_list ::= retention */
      case 114: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==114);
      case 117: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==117);
      case 124: /* column_def_list ::= column_def */ yytestcase(yyruleno==124);
      case 169: /* col_name_list ::= col_name */ yytestcase(yyruleno==169);
      case 206: /* func_name_list ::= func_name */ yytestcase(yyruleno==206);
      case 215: /* func_list ::= func */ yytestcase(yyruleno==215);
      case 275: /* literal_list ::= signed_literal */ yytestcase(yyruleno==275);
      case 325: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==325);
      case 380: /* select_sublist ::= select_item */ yytestcase(yyruleno==380);
      case 428: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==428);
{ yylhsminor.yy376 = createNodeList(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 95: /* retention_list ::= retention_list NK_COMMA retention */
      case 125: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==125);
      case 170: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==170);
      case 207: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==207);
      case 216: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==216);
      case 276: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==276);
      case 326: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==326);
      case 381: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==381);
      case 429: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==429);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 96: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy392 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 97: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 99: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==99);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-5].minor.yy392, yymsp[-3].minor.yy376, yymsp[-1].minor.yy376, yymsp[0].minor.yy392); }
        break;
      case 98: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 100: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 101: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy392); }
        break;
      case 102: /* cmd ::= ALTER TABLE alter_table_clause */
      case 103: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==103);
      case 253: /* cmd ::= query_expression */ yytestcase(yyruleno==253);
{ pCxt->pRootNode = yymsp[0].minor.yy392; }
        break;
      case 104: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy392 = createAlterTableOption(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 105: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy449, yymsp[0].minor.yy112); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 106: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy449); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 107: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy449, yymsp[0].minor.yy112); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 108: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy449, &yymsp[0].minor.yy449); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 109: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy449, yymsp[0].minor.yy112); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 110: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy449); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 111: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy449, yymsp[0].minor.yy112); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 112: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy449, &yymsp[0].minor.yy449); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 113: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy392 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy392, &yymsp[-2].minor.yy449, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 115: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 118: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==118);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-1].minor.yy376, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy376 = yylhsminor.yy376;
        break;
      case 116: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy392 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy89, yymsp[-7].minor.yy392, yymsp[-5].minor.yy392, yymsp[-4].minor.yy376, yymsp[-1].minor.yy376); }
  yymsp[-8].minor.yy392 = yylhsminor.yy392;
        break;
      case 119: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy392 = createDropTableClause(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 120: /* specific_tags_opt ::= */
      case 151: /* tags_def_opt ::= */ yytestcase(yyruleno==151);
      case 388: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==388);
      case 405: /* group_by_clause_opt ::= */ yytestcase(yyruleno==405);
      case 416: /* order_by_clause_opt ::= */ yytestcase(yyruleno==416);
{ yymsp[1].minor.yy376 = NULL; }
        break;
      case 121: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 122: /* full_table_name ::= table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy449, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 123: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy449, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 126: /* column_def ::= column_name type_name */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy449, yymsp[0].minor.yy112, NULL); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 127: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy449, yymsp[-2].minor.yy112, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 128: /* type_name ::= BOOL */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 129: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 130: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 131: /* type_name ::= INT */
      case 132: /* type_name ::= INTEGER */ yytestcase(yyruleno==132);
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 133: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 134: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 135: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 136: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy112 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 138: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy112 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 139: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy112 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 140: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy112 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 141: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy112 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 142: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy112 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 143: /* type_name ::= JSON */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 144: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy112 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 145: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 146: /* type_name ::= BLOB */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 147: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy112 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy112 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 149: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy112 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy112 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 152: /* tags_def_opt ::= tags_def */
      case 324: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==324);
      case 379: /* select_list ::= select_sublist */ yytestcase(yyruleno==379);
{ yylhsminor.yy376 = yymsp[0].minor.yy376; }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 153: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 154: /* table_options ::= */
{ yymsp[1].minor.yy392 = createTableOptions(pCxt); }
        break;
      case 155: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy392)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 156: /* table_options ::= table_options KEEP integer_list */
      case 157: /* table_options ::= table_options KEEP variable_list */ yytestcase(yyruleno==157);
{ ((STableOptions*)yymsp[-2].minor.yy392)->pKeep = yymsp[0].minor.yy376; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 158: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy392)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 159: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy392)->pSma = yymsp[-1].minor.yy376; yylhsminor.yy392 = yymsp[-4].minor.yy392; }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 160: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy392)->pFuncs = yymsp[-1].minor.yy376; yylhsminor.yy392 = yymsp[-4].minor.yy392; }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 161: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy392)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 162: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy392)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 163: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy392 = createTableOptions(pCxt); yylhsminor.yy392 = setTableAlterOption(pCxt, yylhsminor.yy392, &yymsp[0].minor.yy221); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 164: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy392 = setTableAlterOption(pCxt, yymsp[-1].minor.yy392, &yymsp[0].minor.yy221); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 165: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy221.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 166: /* alter_table_option ::= KEEP integer_list */
      case 167: /* alter_table_option ::= KEEP variable_list */ yytestcase(yyruleno==167);
{ yymsp[-1].minor.yy221.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy221.pList = yymsp[0].minor.yy376; }
        break;
      case 168: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy221.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy221.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 171: /* col_name ::= column_name */
{ yylhsminor.yy392 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy449); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 172: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 173: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 176: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 177: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy392, NULL); }
        break;
      case 178: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 181: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 183: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 185: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW LICENCE */
      case 188: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==188);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy449); }
        break;
      case 190: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 191: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 192: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 195: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 196: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 199: /* db_name_cond_opt ::= */
      case 204: /* from_db_opt ::= */ yytestcase(yyruleno==204);
{ yymsp[1].minor.yy392 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 200: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy449); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 201: /* like_pattern_opt ::= */
      case 212: /* index_options ::= */ yytestcase(yyruleno==212);
      case 239: /* into_opt ::= */ yytestcase(yyruleno==239);
      case 386: /* where_clause_opt ::= */ yytestcase(yyruleno==386);
      case 390: /* twindow_clause_opt ::= */ yytestcase(yyruleno==390);
      case 395: /* sliding_opt ::= */ yytestcase(yyruleno==395);
      case 397: /* fill_opt ::= */ yytestcase(yyruleno==397);
      case 409: /* having_clause_opt ::= */ yytestcase(yyruleno==409);
      case 418: /* slimit_clause_opt ::= */ yytestcase(yyruleno==418);
      case 422: /* limit_clause_opt ::= */ yytestcase(yyruleno==422);
{ yymsp[1].minor.yy392 = NULL; }
        break;
      case 202: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 203: /* table_name_cond ::= table_name */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy449); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 205: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy449); }
        break;
      case 208: /* func_name ::= function_name */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[0].minor.yy449, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 209: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy449, &yymsp[-1].minor.yy449, NULL, yymsp[0].minor.yy392); }
        break;
      case 210: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy449, &yymsp[-3].minor.yy449, yymsp[-1].minor.yy376, NULL); }
        break;
      case 211: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy449); }
        break;
      case 213: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy392 = createIndexOption(pCxt, yymsp[-6].minor.yy376, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), NULL, yymsp[0].minor.yy392); }
        break;
      case 214: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy392 = createIndexOption(pCxt, yymsp[-8].minor.yy376, releaseRawExprNode(pCxt, yymsp[-4].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), yymsp[0].minor.yy392); }
        break;
      case 217: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[-3].minor.yy449, yymsp[-1].minor.yy376); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 218: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy449, yymsp[0].minor.yy392, NULL); }
        break;
      case 219: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy449, NULL, &yymsp[0].minor.yy449); }
        break;
      case 220: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy449); }
        break;
      case 221: /* cmd ::= DESC full_table_name */
      case 222: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==222);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy392); }
        break;
      case 223: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 224: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy89, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 226: /* analyze_opt ::= ANALYZE */
      case 234: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==234);
      case 376: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==376);
{ yymsp[0].minor.yy89 = true; }
        break;
      case 227: /* explain_options ::= */
{ yymsp[1].minor.yy392 = createDefaultExplainOptions(pCxt); }
        break;
      case 228: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy392 = setExplainVerbose(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 229: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy392 = setExplainRatio(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 230: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy376); }
        break;
      case 231: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-8].minor.yy89, &yymsp[-5].minor.yy449, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy112, yymsp[0].minor.yy4); }
        break;
      case 232: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy449); }
        break;
      case 235: /* bufsize_opt ::= */
{ yymsp[1].minor.yy4 = 0; }
        break;
      case 236: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy4 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 237: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy89, &yymsp[-4].minor.yy449, yymsp[-2].minor.yy392, yymsp[-3].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 238: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy449); }
        break;
      case 240: /* into_opt ::= INTO full_table_name */
      case 357: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==357);
      case 387: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==387);
      case 410: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==410);
{ yymsp[-1].minor.yy392 = yymsp[0].minor.yy392; }
        break;
      case 241: /* stream_options ::= */
{ yymsp[1].minor.yy392 = createStreamOptions(pCxt); }
        break;
      case 242: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 243: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 244: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 245: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 246: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 247: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 248: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy376); }
        break;
      case 249: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 250: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 252: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy449); }
        break;
      case 254: /* literal ::= NK_INTEGER */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 255: /* literal ::= NK_FLOAT */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 256: /* literal ::= NK_STRING */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 257: /* literal ::= NK_BOOL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 258: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 259: /* literal ::= duration_literal */
      case 269: /* signed_literal ::= signed */ yytestcase(yyruleno==269);
      case 287: /* expression ::= literal */ yytestcase(yyruleno==287);
      case 288: /* expression ::= pseudo_column */ yytestcase(yyruleno==288);
      case 289: /* expression ::= column_reference */ yytestcase(yyruleno==289);
      case 290: /* expression ::= function_expression */ yytestcase(yyruleno==290);
      case 291: /* expression ::= subquery */ yytestcase(yyruleno==291);
      case 349: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==349);
      case 353: /* boolean_primary ::= predicate */ yytestcase(yyruleno==353);
      case 355: /* common_expression ::= expression */ yytestcase(yyruleno==355);
      case 356: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==356);
      case 358: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==358);
      case 360: /* table_reference ::= table_primary */ yytestcase(yyruleno==360);
      case 361: /* table_reference ::= joined_table */ yytestcase(yyruleno==361);
      case 365: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==365);
      case 412: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==412);
      case 415: /* query_primary ::= query_specification */ yytestcase(yyruleno==415);
{ yylhsminor.yy392 = yymsp[0].minor.yy392; }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 260: /* literal ::= NULL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 261: /* literal ::= NK_QUESTION */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 262: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 263: /* signed ::= NK_INTEGER */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 264: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 265: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 266: /* signed ::= NK_FLOAT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 267: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 268: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 270: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 271: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 272: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 273: /* signed_literal ::= duration_literal */
      case 327: /* star_func_para ::= expression */ yytestcase(yyruleno==327);
      case 382: /* select_item ::= common_expression */ yytestcase(yyruleno==382);
      case 427: /* search_condition ::= common_expression */ yytestcase(yyruleno==427);
{ yylhsminor.yy392 = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 274: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 292: /* expression ::= NK_LP expression NK_RP */
      case 354: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==354);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 293: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy392));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 294: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 295: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 296: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 297: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 298: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 299: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 300: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 301: /* expression_list ::= expression */
{ yylhsminor.yy376 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 302: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 303: /* column_reference ::= column_name */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy449, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy449)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 304: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy449, createColumnNode(pCxt, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy449)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 305: /* pseudo_column ::= ROWTS */
      case 306: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==306);
      case 307: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==307);
      case 308: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==308);
      case 309: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==309);
      case 310: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==310);
      case 311: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==311);
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 312: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 313: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==313);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy449, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy449, yymsp[-1].minor.yy376)); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 314: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy112)); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 315: /* function_expression ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy0, createFunctionNodeNoArg(pCxt, &yymsp[-2].minor.yy449)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 323: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy376 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 328: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 385: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==385);
{ yylhsminor.yy392 = createColumnNode(pCxt, &yymsp[-2].minor.yy449, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 329: /* predicate ::= expression compare_op expression */
      case 334: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==334);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 330: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 331: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 332: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), NULL));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 333: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL));
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 335: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 336: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 337: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 338: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 339: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 340: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 341: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 342: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 343: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 344: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 345: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy380 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 346: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 347: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 348: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 350: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 351: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 352: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 359: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 362: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy449, &yymsp[0].minor.yy449); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 363: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-3].minor.yy449, &yymsp[-1].minor.yy449, &yymsp[0].minor.yy449); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 364: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy392 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy449); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 366: /* alias_opt ::= */
{ yymsp[1].minor.yy449 = nil_token;  }
        break;
      case 367: /* alias_opt ::= table_alias */
{ yylhsminor.yy449 = yymsp[0].minor.yy449; }
  yymsp[0].minor.yy449 = yylhsminor.yy449;
        break;
      case 368: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy449 = yymsp[0].minor.yy449; }
        break;
      case 369: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 370: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==370);
{ yymsp[-2].minor.yy392 = yymsp[-1].minor.yy392; }
        break;
      case 371: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, yymsp[-4].minor.yy372, yymsp[-5].minor.yy392, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 372: /* join_type ::= */
{ yymsp[1].minor.yy372 = JOIN_TYPE_INNER; }
        break;
      case 373: /* join_type ::= INNER */
{ yymsp[0].minor.yy372 = JOIN_TYPE_INNER; }
        break;
      case 374: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy392 = createSelectStmt(pCxt, yymsp[-7].minor.yy89, yymsp[-6].minor.yy376, yymsp[-5].minor.yy392);
                                                                                    yymsp[-8].minor.yy392 = addWhereClause(pCxt, yymsp[-8].minor.yy392, yymsp[-4].minor.yy392);
                                                                                    yymsp[-8].minor.yy392 = addPartitionByClause(pCxt, yymsp[-8].minor.yy392, yymsp[-3].minor.yy376);
                                                                                    yymsp[-8].minor.yy392 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy392, yymsp[-2].minor.yy392);
                                                                                    yymsp[-8].minor.yy392 = addGroupByClause(pCxt, yymsp[-8].minor.yy392, yymsp[-1].minor.yy376);
                                                                                    yymsp[-8].minor.yy392 = addHavingClause(pCxt, yymsp[-8].minor.yy392, yymsp[0].minor.yy392);
                                                                                  }
        break;
      case 377: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy89 = false; }
        break;
      case 378: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy376 = NULL; }
        break;
      case 383: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy449); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 384: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), &yymsp[0].minor.yy449); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 389: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 406: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==406);
      case 417: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==417);
{ yymsp[-2].minor.yy376 = yymsp[0].minor.yy376; }
        break;
      case 391: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy392 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 392: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy392 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 393: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 394: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 396: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy392 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy392); }
        break;
      case 398: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy392 = createFillNode(pCxt, yymsp[-1].minor.yy102, NULL); }
        break;
      case 399: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy392 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
        break;
      case 400: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy102 = FILL_MODE_NONE; }
        break;
      case 401: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy102 = FILL_MODE_PREV; }
        break;
      case 402: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy102 = FILL_MODE_NULL; }
        break;
      case 403: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy102 = FILL_MODE_LINEAR; }
        break;
      case 404: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy102 = FILL_MODE_NEXT; }
        break;
      case 407: /* group_by_list ::= expression */
{ yylhsminor.yy376 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 408: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 411: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy392 = addOrderByClause(pCxt, yymsp[-3].minor.yy392, yymsp[-2].minor.yy376);
                                                                                    yylhsminor.yy392 = addSlimitClause(pCxt, yylhsminor.yy392, yymsp[-1].minor.yy392);
                                                                                    yylhsminor.yy392 = addLimitClause(pCxt, yylhsminor.yy392, yymsp[0].minor.yy392);
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 413: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 414: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 419: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 423: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==423);
{ yymsp[-1].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 420: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 424: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==424);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 421: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 425: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==425);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 426: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 430: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy392 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), yymsp[-1].minor.yy386, yymsp[0].minor.yy361); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 431: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy386 = ORDER_ASC; }
        break;
      case 432: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy386 = ORDER_ASC; }
        break;
      case 433: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy386 = ORDER_DESC; }
        break;
      case 434: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy361 = NULL_ORDER_DEFAULT; }
        break;
      case 435: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy361 = NULL_ORDER_FIRST; }
        break;
      case 436: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy361 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
