/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 490
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy25;
  SDataType yy84;
  SToken yy169;
  EFillMode yy214;
  int8_t yy243;
  int32_t yy480;
  EOrder yy498;
  EOperatorType yy520;
  STokenPair yy637;
  SNodeList* yy824;
  EJoinType yy932;
  int64_t yy949;
  SNode* yy952;
  bool yy957;
  ENullOrder yy977;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             801
#define YYNRULE              605
#define YYNRULE_WITH_ACTION  605
#define YYNTOKEN             339
#define YY_MAX_SHIFT         800
#define YY_MIN_SHIFTREDUCE   1183
#define YY_MAX_SHIFTREDUCE   1787
#define YY_ERROR_ACTION      1788
#define YY_ACCEPT_ACTION     1789
#define YY_NO_ACTION         1790
#define YY_MIN_REDUCE        1791
#define YY_MAX_REDUCE        2395
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2957)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   736, 2202, 2180, 2091,  738,  689, 1968, 2013, 1216,   38,
 /*    10 */   304,  669,   48,   46, 1714,  392, 2188, 1946, 2088,  676,
 /*    20 */   399,  255, 1559,   41,   40,  135, 2184,   47,   45,   44,
 /*    30 */    43,   42,  573, 1640, 2022, 1557,  689, 1968,   41,   40,
 /*    40 */  2220, 2163,   47,   45,   44,   43,   42, 1218, 2021, 1221,
 /*    50 */  1222, 2170, 1241,  705, 1240, 1584,  135, 2180, 2180,  666,
 /*    60 */   144,  149, 1635,  578, 2186,  396,  533,  140,   19,  534,
 /*    70 */  1827, 1959, 2189,  451,  699, 1565,  541,  666,  144,  534,
 /*    80 */  1827, 2184, 2184,  359, 2022, 1242,  688, 2201,  629, 2237,
 /*    90 */   380, 2366,  112, 2203,  709, 2205, 2206,  704, 2020,  699,
 /*   100 */   797,  689, 1968,   15,  185, 2135, 2290, 2091, 2372,  188,
 /*   110 */   395, 2286, 2153, 2367,  655,  181,   48,   46,  346, 2186,
 /*   120 */  2186,  193, 2089,  676,  399,  190, 1559, 1669, 1375,  699,
 /*   130 */   699, 1584,  221, 2320,  367, 2074,  536, 1640, 1834, 1557,
 /*   140 */  1642, 1643,  456, 2070, 1366,  734,  733,  732, 1370,  731,
 /*   150 */  1372, 1373,  730,  727,  250, 1381,  724, 1383, 1384,  721,
 /*   160 */   718,  715,  668,  186, 2298, 2299, 1635,  142, 2303,   51,
 /*   170 */  1615, 1625,   19,  169,  223, 1803, 1641, 1644,  536, 1565,
 /*   180 */  1834,  282, 2298,  665, 1670,  136,  664, 1585, 2366,  202,
 /*   190 */   688, 1560,  125, 1558,   62,  124,  123,  122,  121,  120,
 /*   200 */   119,  118,  117,  116,  797,  653,  188,   15, 2202,  530,
 /*   210 */  2367,  655,   52, 1784,   62,  666,  144,  528,  706,  674,
 /*   220 */   524,  520,  249, 1563, 1564, 1792, 1614, 1617, 1618, 1619,
 /*   230 */  1620, 1621, 1622, 1623, 1624,  701,  697, 1633, 1634, 1636,
 /*   240 */  1637, 1638, 1639,    2, 1642, 1643,  125, 2220,  550,  124,
 /*   250 */   123,  122,  121,  120,  119,  118,  117,  116, 2170, 1791,
 /*   260 */   705,   66,   37,  397, 1664, 1665, 1666, 1667, 1668, 1672,
 /*   270 */  1673, 1674, 1675,  404, 1615, 1625, 2015, 2017,  689, 1968,
 /*   280 */  1641, 1644,  649,  134,  133,  132,  131,  130,  129,  128,
 /*   290 */   127,  126, 1530, 1531, 2201, 1560, 2237, 1558,   56,  112,
 /*   300 */  2203,  709, 2205, 2206,  704,  644,  699, 1410, 1411,  147,
 /*   310 */  1586,  155, 2261, 2290,  746, 2202, 1783,  395, 2286,  187,
 /*   320 */  2298, 2299, 1584,  142, 2303,  669,  286, 1563, 1564,  428,
 /*   330 */  1614, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624,  701,
 /*   340 */   697, 1633, 1634, 1636, 1637, 1638, 1639,    2,   12,   48,
 /*   350 */    46,  286, 2371,  402, 2220, 2366,  168,  399,  372, 1559,
 /*   360 */    62, 1970,  163,  184, 1909, 2170, 1814,  705,  381,  286,
 /*   370 */  1640,  286, 1557, 2370,  675, 2009, 2020, 2367, 2369,   41,
 /*   380 */    40,  496,  614,   47,   45,   44,   43,   42,  462, 2070,
 /*   390 */  1565, 1587,  666,  144, 2202,   12,  650,  645,  638, 1635,
 /*   400 */   688, 2201,  737, 2237,  703,   19,  112, 2203,  709, 2205,
 /*   410 */  2206,  704, 1565,  699,  689, 1968, 2170, 1813,  185,  756,
 /*   420 */  2290,  689, 1968,  596,  395, 2286,  548,  373, 2084,  371,
 /*   430 */   370, 2305,  575, 2220,  449,  205,  577,  797,  606,  109,
 /*   440 */    15,  450,  212,  211, 2170, 2022,  705, 2321, 1870,  689,
 /*   450 */  1968,  389,  246,   48,   46, 1645,  145, 2302,  576, 2020,
 /*   460 */  2202,  399,  284, 1559, 1960,  495,  648, 2170,  599,  464,
 /*   470 */   706, 1318, 1468, 1469, 1640,  593, 1557, 1642, 1643, 1812,
 /*   480 */  2201,  245, 2237,   51, 1811,  340, 2203,  709, 2205, 2206,
 /*   490 */   704,  702,  699,  690, 2255, 2220,  189, 2298, 2299, 2220,
 /*   500 */   142, 2303,  181, 1635,   12,  433,   10, 1615, 1625,  538,
 /*   510 */  2170, 1320,  705, 1641, 1644,  535, 1565,  286,  591,  590,
 /*   520 */   589,   70, 2075, 2371,   69,  581,  141,  585, 1560, 2170,
 /*   530 */  1558,  584,  435,  431, 2170,  675,  583,  588,  375,  374,
 /*   540 */  1586,  797,  582,  262,   49, 1810, 2201, 2202, 2237,  647,
 /*   550 */  2053,  170, 2203,  709, 2205, 2206,  704,  706,  699, 1836,
 /*   560 */  1563, 1564,   90, 1614, 1617, 1618, 1619, 1620, 1621, 1622,
 /*   570 */  1623, 1624,  701,  697, 1633, 1634, 1636, 1637, 1638, 1639,
 /*   580 */     2, 1642, 1643,  591,  590,  589, 2220,  673, 1964, 2084,
 /*   590 */   581,  141,  585,  630, 2331, 2170,  584, 2170,  691,  705,
 /*   600 */  2262,  583,  588,  375,  374,  654,  700,  582, 2366,  689,
 /*   610 */  1968, 1615, 1625, 2022,  408,  407,  628, 1641, 1644,  365,
 /*   620 */  2016, 2017, 2022, 1789, 1777,  653,  188, 2020,  394,  479,
 /*   630 */  2367,  655, 1560, 2201, 1558, 2237, 2020, 1566,  112, 2203,
 /*   640 */   709, 2205, 2206,  704, 2370,  699,  689, 1968,  295,  296,
 /*   650 */  2386,  675, 2290,  294,   41,   40,  395, 2286,   47,   45,
 /*   660 */    44,   43,   42,  258, 1563, 1564,  480, 1614, 1617, 1618,
 /*   670 */  1619, 1620, 1621, 1622, 1623, 1624,  701,  697, 1633, 1634,
 /*   680 */  1636, 1637, 1638, 1639,    2,   48,   46,  689, 1968, 2202,
 /*   690 */    30,  654,  284,  399, 2366, 1559,  414, 1585, 1944,  706,
 /*   700 */   693,  413, 2262,  684, 1742, 2084, 1640,  549, 1557,  474,
 /*   710 */  2202,  653,  188,  103,  489, 2070, 2367,  655,  473,   90,
 /*   720 */   706, 1945,   62, 2022,  689, 1968,   41,   40, 2220,  403,
 /*   730 */    47,   45,   44,   43,   42, 1635,  369, 2020, 1961, 2170,
 /*   740 */    60,  705, 1809,  629, 1965, 1963, 2366,  626, 1565, 2220,
 /*   750 */  1754,  207,  641,  640, 1740, 1741, 1743, 1744, 1745,  605,
 /*   760 */  2170,  210,  705, 2372,  188,  746,  689, 1968, 2367,  655,
 /*   770 */   393,  577,  603,  797,  601, 2201,   49, 2237, 1970,  166,
 /*   780 */   171, 2203,  709, 2205, 2206,  704,  251,  699, 1808,   48,
 /*   790 */    46,   86, 2170,  576,   85, 1569, 2201,  399, 2237, 1559,
 /*   800 */  1910,  113, 2203,  709, 2205, 2206,  704, 1804,  699,  443,
 /*   810 */  1640,  442, 1557, 1642, 1643, 2290, 2305, 1485, 1486, 2289,
 /*   820 */  2286,  445, 1753,   41,   40, 2305,  444,   47,   45,   44,
 /*   830 */    43,   42, 2334,  656, 2387, 2202,  744, 1943, 2170, 1635,
 /*   840 */  1224,  441, 2301, 1615, 1625,  706, 1583,  689, 1968, 1641,
 /*   850 */  1644, 2300, 1565, 1484, 1487,  160,  159,  741,  740,  739,
 /*   860 */   157,  402,  689, 1968, 1560,  279, 1558,  672,  629, 1970,
 /*   870 */   166, 2366,  689, 1968, 2220,  689, 1968,  797,  146,  286,
 /*   880 */    15, 2261,  259,  742, 1718, 2170, 2013,  705, 2372,  188,
 /*   890 */  1584,  642,  299, 2367,  655,  686, 1563, 1564, 2063, 1614,
 /*   900 */  1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624,  701,  697,
 /*   910 */  1633, 1634, 1636, 1637, 1638, 1639,    2, 1642, 1643, 1730,
 /*   920 */   139, 2201,  657, 2237,  587,  586,  113, 2203,  709, 2205,
 /*   930 */  2206,  704,  743,  699,  405, 2013,  744,  454,   14,   13,
 /*   940 */  2290, 2371, 1970,  166, 2366, 2287, 1807, 1615, 1625,  689,
 /*   950 */  1968, 1329,  744, 1641, 1644,  160,  159,  741,  740,  739,
 /*   960 */   157, 1711, 2370,  237, 1328, 2191, 2367, 2368, 1560,  687,
 /*   970 */  1558,  160,  159,  741,  740,  739,  157,  689, 1968,  173,
 /*   980 */    47,   45,   44,   43,   42, 1650, 1806,  567,  563,  559,
 /*   990 */   555, 1584,  236, 1241,  273, 1240, 2170,  305, 1244, 1245,
 /*  1000 */  1563, 1564, 1867, 1614, 1617, 1618, 1619, 1620, 1621, 1622,
 /*  1010 */  1623, 1624,  701,  697, 1633, 1634, 1636, 1637, 1638, 1639,
 /*  1020 */     2, 2193,  350,  167, 1582,  382, 1242, 1805,  325,  505,
 /*  1030 */   318,  487,   91, 1999,  503,  234, 2170,  502,   34, 1587,
 /*  1040 */  1616, 1683,  322,   73,   41,   40,   72,    9,   47,   45,
 /*  1050 */    44,   43,   42,  470,   54,  504,    3,  347,   41,   40,
 /*  1060 */   472, 1908,   47,   45,   44,   43,   42, 2164,  219,  515,
 /*  1070 */   513,  510,  774,  773,  772,  771,  411, 2170,  770,  769,
 /*  1080 */   148,  764,  763,  762,  761,  760,  759,  758,  162,  754,
 /*  1090 */   753,  752,  410,  409,  749,  748,  747,  176,  175,   44,
 /*  1100 */    43,   42,  757,  233,  227, 1930,  368, 1587,   62,   36,
 /*  1110 */   232,  546,  689, 1968,  629,   41,   40, 2366,  458,   47,
 /*  1120 */    45,   44,   43,   42, 1671, 1802,  569,  568,   83,  225,
 /*  1130 */   137, 1559,  406, 1333, 2372,  188, 1584, 1801,  658, 2367,
 /*  1140 */   655, 1616,  571,  570, 1557, 1800, 1332,  111,  500, 1799,
 /*  1150 */   661,  494,  493,  492,  491,  486,  485,  484,  483,  482,
 /*  1160 */   478,  477,  476,  475,  349,  467,  466,  465,  612,  460,
 /*  1170 */   459,  366,   41,   40,  579, 2170,   47,   45,   44,   43,
 /*  1180 */    42,  248, 2202,   74, 1565,  247, 1568, 2170,   81,   80,
 /*  1190 */   448,  203,  706,  200, 2328, 2170, 1316, 1798, 1797, 2170,
 /*  1200 */  1796, 1795,   35,  768,  766,  242,  440,  438,  240,  797,
 /*  1210 */  1794,  507, 1676, 1221, 1222,  629,  670,  348, 2366, 1710,
 /*  1220 */   429, 2220,  165,  427,  423,  419,  416,  441, 1957,  166,
 /*  1230 */  1953,  166, 2170,   84,  705, 2372,  188, 1955,  166,  158,
 /*  1240 */  2367,  655,  580, 2202, 1951,  166,   93, 2170, 2170,  354,
 /*  1250 */  2170, 2170,  379,  706,  607, 2341, 1971,  166, 2156,  261,
 /*  1260 */  2170, 2310, 1703,  629, 1314,  286, 2366, 1703, 2201, 2221,
 /*  1270 */  2237,  260,  696,  112, 2203,  709, 2205, 2206,  704,  609,
 /*  1280 */   699,  608, 2220, 2372,  188, 2386, 1616, 2290, 2367,  655,
 /*  1290 */  1854,  395, 2286, 2170, 1845,  705, 1843,  158,  151,   55,
 /*  1300 */  1560,  150, 1558,  244,  158,  153,  243,  421,  152,   50,
 /*  1310 */    50, 2202,  592,  266,   94,  158,  594, 1567,  597, 1786,
 /*  1320 */  1787,  706,   50,  636, 1907,  292, 1275,   71,  156, 2201,
 /*  1330 */   158, 2237, 1563, 1564,  112, 2203,  709, 2205, 2206,  704,
 /*  1340 */   412,  699, 2079, 1828, 1571, 1837, 2386, 1833, 2290, 2010,
 /*  1350 */  2220,   64,  395, 2286,   14,   13, 2324, 1525,   50,   50,
 /*  1360 */   667, 2170,  281,  705, 1528,  713, 1276,  750,  156, 1739,
 /*  1370 */  1738,  108,  158,  268, 2202,  671,  138,  659,  156,  751,
 /*  1380 */   278,  105, 1482,    5,  706,  297, 2359,  681,  301, 1294,
 /*  1390 */  1359,  662,  415,    1,  363,  792,  420, 2201, 1590, 2237,
 /*  1400 */  2202, 1292,  112, 2203,  709, 2205, 2206,  704,  437,  699,
 /*  1410 */   706, 1677, 2309, 2220, 2386,  195, 2290,  436, 1626,  317,
 /*  1420 */   395, 2286,  196,  439, 2170, 1388,  705, 1661, 1392, 1506,
 /*  1430 */   198,  312, 1399,  455, 1583, 2202, 1397,  209,  161, 2220,
 /*  1440 */   457, 1587, 2080,  461,  463,  706,  498, 1582,  468,  488,
 /*  1450 */  2170,  481,  705, 2072,  490,  506,  497,  499,  508,  509,
 /*  1460 */  2201,  214, 2237,  511,  213,  112, 2203,  709, 2205, 2206,
 /*  1470 */   704, 1588,  699,  216, 2220, 1570,  512, 2386,  514, 2290,
 /*  1480 */   516,  531,    4,  395, 2286, 2170, 2201,  705, 2237,  532,
 /*  1490 */   539,  112, 2203,  709, 2205, 2206,  704,  540,  699,  542,
 /*  1500 */   224,  408,  407, 2386, 2202, 2290, 1585,  543,  226,  395,
 /*  1510 */  2286, 1573, 1589,  544,  706, 1591,  229,  545,  547,  231,
 /*  1520 */   551, 2201, 1640, 2237, 1566,  572,  112, 2203,  709, 2205,
 /*  1530 */  2206,  704, 2202,  699,   88,   89,  235,  114, 2265,  574,
 /*  1540 */  2290,  353,  706, 2220,  395, 2286, 2144, 1958,  239, 2141,
 /*  1550 */   611, 1635, 1954,  241, 2170, 2140,  705,  613, 1956, 1952,
 /*  1560 */    92,  313,  154,  252, 1565,  617,  618, 2202,  616, 1513,
 /*  1570 */   254, 2220,  256,  624,  621, 2325,  633,  706,  643,  679,
 /*  1580 */   639,  385, 2170,  623,  705, 2335,  646, 2340, 2339,  695,
 /*  1590 */  2201,    8, 2237,  652,  264,  112, 2203,  709, 2205, 2206,
 /*  1600 */   704,  622,  699, 2312,  272,  174, 2220, 2263,  267, 2290,
 /*  1610 */   634,  274,  632,  395, 2286,  275,  631, 2170, 2201,  705,
 /*  1620 */  2237,  277,  276,  112, 2203,  709, 2205, 2206,  704, 1703,
 /*  1630 */   699,  386, 2389,  663,  280,  692, 2365, 2290, 1586,  143,
 /*  1640 */   660,  395, 2286, 1708, 2306, 1706,  178,  287, 1592,  191,
 /*  1650 */    98, 2085,  314, 2201, 2202, 2237,  285,  315,  113, 2203,
 /*  1660 */   709, 2205, 2206,  704,  706,  699,  677,  678, 2099,  100,
 /*  1670 */   682, 2098, 2290,   61,  683,  316,  694, 2286,  102, 1969,
 /*  1680 */  1574, 2271, 1569,  104, 2202,  711, 1931, 2097,  319,  391,
 /*  1690 */  2014,  793,  796, 2220,  706,  794,  308,  328,  321,  342,
 /*  1700 */   332,   53,  323,  343, 2170, 2162,  705, 2161,  355, 2160,
 /*  1710 */   356,   78, 1577, 1579, 2157,  417,  418, 1550, 1551,  194,
 /*  1720 */   422, 2155,  424, 2220,  425,  697, 1633, 1634, 1636, 1637,
 /*  1730 */  1638, 1639,  426, 2154, 2170,  364,  705, 2152,  430, 2151,
 /*  1740 */   707,  432, 2237,  434, 1541,  113, 2203,  709, 2205, 2206,
 /*  1750 */   704, 2150,  699, 2131,  197, 2202, 2130,  199, 1509, 2290,
 /*  1760 */    79, 2112, 1508,  358, 2286,  706, 2111, 2110,  446,  447,
 /*  1770 */  2201, 2109, 2237, 2108, 1459,  170, 2203,  709, 2205, 2206,
 /*  1780 */   704, 2062,  699,  452,  453, 2059, 2058,  201,   82, 2057,
 /*  1790 */  2056, 2061,  204, 2060, 2220, 2055, 2054, 2052,  383, 2051,
 /*  1800 */  2050,  206, 2049,  469,  471, 2170, 2065,  705, 2048, 2047,
 /*  1810 */  2046, 2045, 2044, 2202, 2043, 2042, 2041, 2040, 2332, 2039,
 /*  1820 */  2038, 2037, 2036,  706, 2035, 2034,  208, 2202, 2033,   87,
 /*  1830 */  2032, 2031, 2030, 2064, 2029, 2028, 2027,  706, 2026, 2025,
 /*  1840 */  1461, 2201,  501, 2237, 2202, 2024,  341, 2203,  709, 2205,
 /*  1850 */  2206,  704, 2220,  699,  706, 2023,  384,  230, 2106, 1330,
 /*  1860 */  1873,  351, 1334, 2170, 1326,  705, 2220,  215, 1872,  217,
 /*  1870 */  1871,  352, 1869, 1866, 1865, 1858,  517, 2170, 1847,  705,
 /*  1880 */  1823, 1223,  521, 2220,  525,  519, 1822,  523,  218,  527,
 /*  1890 */  2129,  529,  518,  522, 2170,  220,  705, 2119,  182, 2201,
 /*  1900 */   526, 2237,   76,   77,  341, 2203,  709, 2205, 2206,  704,
 /*  1910 */  2107,  699, 2190, 2201, 2202, 2237,  183,  222,  334, 2203,
 /*  1920 */   709, 2205, 2206,  704,  706,  699,  537,  228, 2083, 1947,
 /*  1930 */  2201, 1268, 2237, 2202, 1868,  171, 2203,  709, 2205, 2206,
 /*  1940 */   704, 1864,  699,  703,  552,  553,  554, 1862,  556, 2202,
 /*  1950 */   557,  558, 1860, 2220,  560,  561,  562,  390, 1857,  706,
 /*  1960 */   564, 1842,  566,  651, 2170,  565,  705, 1840, 1841, 1839,
 /*  1970 */  1819, 1949, 2220,   63, 1404, 1403,  238, 1948, 1317, 1315,
 /*  1980 */  1313, 1312,  765, 2170, 1311,  705, 1310, 1304, 2220, 2388,
 /*  1990 */  1309, 1306,  398, 1855,  767, 1305,  376, 1303, 1846, 2170,
 /*  2000 */  2201,  705, 2237,  377, 1844,  341, 2203,  709, 2205, 2206,
 /*  2010 */   704,  378,  699,  598,  595, 1818, 1817,  600,  602, 2201,
 /*  2020 */  2202, 2237, 1816,  604,  340, 2203,  709, 2205, 2206,  704,
 /*  2030 */   706,  699,  615, 2256,  115, 2201, 1539, 2237, 1535,   29,
 /*  2040 */   341, 2203,  709, 2205, 2206,  704, 1537,  699, 1534, 2128,
 /*  2050 */   800,   67, 1515,   57, 1517, 2202, 2118, 1519,  619, 2220,
 /*  2060 */  2105,  620, 2104,  400,  311,  706,  257, 1494, 2371,  625,
 /*  2070 */  2170, 1493,  705,   20,    6,   31,  164,  635,  627, 1756,
 /*  2080 */   180,   21,  263,    7,  637, 2202,   22,  172,  790,  786,
 /*  2090 */   782,  778,   17,  309, 2220,  706,  265,  270, 1737,  269,
 /*  2100 */    32,  271, 2191, 1729, 1776, 2170, 2201,  705, 2237,   95,
 /*  2110 */    33,  341, 2203,  709, 2205, 2206,  704,   23,  699,   65,
 /*  2120 */    24, 1771, 2202, 1777, 2220, 1770,  387, 1775, 1774,  388,
 /*  2130 */   283, 1700,  706,  110, 1699, 2170,  302,  705, 2103,   59,
 /*  2140 */  2082,  610,   58, 2237,  177,  290,  336, 2203,  709, 2205,
 /*  2150 */  2206,  704,   18,  699,   96,   25,   97, 2081,   99,  300,
 /*  2160 */   293, 2220,  291, 1735,  298,  680,   68,  101,  303,  685,
 /*  2170 */    26, 2201, 2170, 2237,  705, 1652,  326, 2203,  709, 2205,
 /*  2180 */  2206,  704,  105,  699, 2202,   11, 1651,   13, 1575, 1662,
 /*  2190 */  2240,  179, 1630, 1628,  706,  192,  710, 1607,  712, 2202,
 /*  2200 */  1627, 1380,  698,   39,  289,   16,   27,   28, 2201,  706,
 /*  2210 */  2237,  288, 1599,  324, 2203,  709, 2205, 2206,  704, 1389,
 /*  2220 */   699,  401, 1386, 2220,  716,  714,  719,  708,  717,  722,
 /*  2230 */   253, 1385,  720,  723, 2170, 1382,  705, 1376, 2220,  725,
 /*  2240 */  1374,  728,  726, 1365,  729,  306, 1379, 1398,  106, 2170,
 /*  2250 */  2202,  705,  107,   75, 1378, 1394, 1266,  735, 1377, 1298,
 /*  2260 */   706,  745, 1297, 1296, 2202, 1295, 1293, 1291,  755, 1290,
 /*  2270 */  2201, 1289, 2237, 1324,  706,  327, 2203,  709, 2205, 2206,
 /*  2280 */   704,  307,  699, 1287, 1286, 2201, 1285, 2237, 1284, 2220,
 /*  2290 */   333, 2203,  709, 2205, 2206,  704, 1863,  699, 1283, 1282,
 /*  2300 */  2170, 1321,  705, 2220, 1281, 1319, 1278, 1277, 1274, 1273,
 /*  2310 */  1272, 1271,  775, 1861, 2170, 2202,  705,  776,  777,  779,
 /*  2320 */   781, 1859,  783, 1856,  785,  706,  787,  780,  789,  784,
 /*  2330 */  1838,  788,  791, 1213, 1815,  795, 2201,  310, 2237, 1561,
 /*  2340 */   320,  337, 2203,  709, 2205, 2206,  704,  798,  699,  799,
 /*  2350 */  2201, 1790, 2237, 1790, 2220,  329, 2203,  709, 2205, 2206,
 /*  2360 */   704, 1790,  699, 1790, 1790, 2170, 1790,  705, 1790, 1790,
 /*  2370 */  1790, 1790, 1790, 1790, 1790, 2202, 1790, 1790, 1790, 1790,
 /*  2380 */  1790, 1790, 1790, 1790, 1790,  706, 1790, 1790, 1790, 1790,
 /*  2390 */  2202, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2400 */   706, 2201, 1790, 2237, 1790, 1790,  338, 2203,  709, 2205,
 /*  2410 */  2206,  704, 1790,  699, 2220, 1790, 1790, 1790, 1790, 1790,
 /*  2420 */  1790, 1790, 1790, 1790, 1790, 2170, 1790,  705, 1790, 2220,
 /*  2430 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2440 */  2170, 1790,  705, 1790, 1790, 1790, 1790, 1790, 2202, 1790,
 /*  2450 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,  706, 1790,
 /*  2460 */  1790, 2201, 1790, 2237, 1790, 2202,  330, 2203,  709, 2205,
 /*  2470 */  2206,  704, 1790,  699, 1790,  706, 2201, 1790, 2237, 2202,
 /*  2480 */  1790,  339, 2203,  709, 2205, 2206,  704, 2220,  699,  706,
 /*  2490 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 2170, 1790,
 /*  2500 */   705, 1790, 1790, 1790, 2220, 1790, 1790, 1790, 1790, 1790,
 /*  2510 */  1790, 1790, 1790, 1790, 1790, 2170, 2202,  705, 2220, 1790,
 /*  2520 */  1790, 1790, 1790, 1790, 1790, 1790,  706, 1790, 1790, 2170,
 /*  2530 */  1790,  705, 1790, 1790, 2201, 1790, 2237, 2202, 1790,  331,
 /*  2540 */  2203,  709, 2205, 2206,  704, 1790,  699,  706, 1790, 1790,
 /*  2550 */  1790, 2201, 1790, 2237, 1790, 2220,  344, 2203,  709, 2205,
 /*  2560 */  2206,  704, 1790,  699, 1790, 2201, 2170, 2237,  705, 1790,
 /*  2570 */   345, 2203,  709, 2205, 2206,  704, 2220,  699, 1790, 1790,
 /*  2580 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 2170, 1790,  705,
 /*  2590 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2600 */  1790, 1790, 2201, 2202, 2237, 1790, 1790, 2214, 2203,  709,
 /*  2610 */  2205, 2206,  704,  706,  699, 1790, 1790, 2202, 1790, 1790,
 /*  2620 */  1790, 1790, 1790, 2201, 1790, 2237, 1790,  706, 2213, 2203,
 /*  2630 */   709, 2205, 2206,  704, 2202,  699, 1790, 1790, 1790, 1790,
 /*  2640 */  1790, 1790, 2220, 1790,  706, 1790, 1790, 1790, 1790, 1790,
 /*  2650 */  1790, 1790, 1790, 2170, 1790,  705, 2220, 1790, 1790, 1790,
 /*  2660 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 2170, 1790,  705,
 /*  2670 */  1790, 1790, 1790, 2220, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2680 */  1790, 1790, 1790, 1790, 2170, 1790,  705, 1790, 1790, 2201,
 /*  2690 */  1790, 2237, 1790, 1790, 2212, 2203,  709, 2205, 2206,  704,
 /*  2700 */  1790,  699, 1790, 2201, 1790, 2237, 1790, 1790,  360, 2203,
 /*  2710 */   709, 2205, 2206,  704, 1790,  699, 1790, 1790, 1790, 1790,
 /*  2720 */  2201, 1790, 2237, 1790, 1790,  361, 2203,  709, 2205, 2206,
 /*  2730 */   704, 1790,  699, 2202, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2740 */  1790, 1790, 1790,  706, 1790, 1790, 1790, 1790, 1790, 2202,
 /*  2750 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,  706,
 /*  2760 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 2202, 1790,
 /*  2770 */  1790, 1790, 2220, 1790, 1790, 1790, 1790, 1790,  706, 1790,
 /*  2780 */  1790, 1790, 1790, 2170, 1790,  705, 1790, 1790, 2220, 1790,
 /*  2790 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 2170,
 /*  2800 */  1790,  705, 1790, 1790, 1790, 1790, 1790, 2220, 1790, 1790,
 /*  2810 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 2170, 2201,
 /*  2820 */   705, 2237, 1790, 1790,  357, 2203,  709, 2205, 2206,  704,
 /*  2830 */  1790,  699, 1790, 1790, 1790, 2201, 1790, 2237, 1790, 1790,
 /*  2840 */   362, 2203,  709, 2205, 2206,  704, 1790,  699, 1790, 1790,
 /*  2850 */  1790, 1790, 1790, 1790,  707, 1790, 2237, 1790, 2202,  336,
 /*  2860 */  2203,  709, 2205, 2206,  704, 1790,  699, 1790,  706, 1790,
 /*  2870 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2880 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2890 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 2220, 1790, 1790,
 /*  2900 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 2170, 1790,
 /*  2910 */   705, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2920 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2930 */  1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790, 1790,
 /*  2940 */  1790, 1790, 1790, 1790, 2201, 1790, 2237, 1790, 1790,  335,
 /*  2950 */  2203,  709, 2205, 2206,  704, 1790,  699,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   388,  342,  368,  394,  389,  351,  352,  392,    4,  448,
 /*    10 */   449,  352,   12,   13,   14,  406,  382,    0,  409,  410,
 /*    20 */    20,  388,   22,    8,    9,  371,  392,   12,   13,   14,
 /*    30 */    15,   16,  378,   33,  381,   35,  351,  352,    8,    9,
 /*    40 */   381,  412,   12,   13,   14,   15,   16,   43,  395,   45,
 /*    50 */    46,  392,   20,  394,   22,   20,  371,  368,  368,  351,
 /*    60 */   352,   44,   62,  378,  430,  431,  346,   35,   68,  349,
 /*    70 */   350,  382,  382,  351,  440,   75,  346,  351,  352,  349,
 /*    80 */   350,  392,  392,   68,  381,   53,   20,  428,  459,  430,
 /*    90 */   387,  462,  433,  434,  435,  436,  437,  438,  395,  440,
 /*   100 */   100,  351,  352,  103,  445,  376,  447,  394,  479,  480,
 /*   110 */   451,  452,    0,  484,  485,  381,   12,   13,  396,  430,
 /*   120 */   430,  371,  409,  410,   20,  466,   22,  112,  100,  440,
 /*   130 */   440,   20,  347,  474,  400,  401,  351,   33,  353,   35,
 /*   140 */   140,  141,  351,  352,  116,  117,  118,  119,  120,  121,
 /*   150 */   122,  123,  124,  125,  425,  127,  128,  129,  130,  131,
 /*   160 */   132,  133,  454,  455,  456,  457,   62,  459,  460,  103,
 /*   170 */   170,  171,   68,  341,  347,  343,  176,  177,  351,   75,
 /*   180 */   353,  455,  456,  457,  169,  459,  460,   20,  462,  398,
 /*   190 */    20,  191,   21,  193,  103,   24,   25,   26,   27,   28,
 /*   200 */    29,   30,   31,   32,  100,  479,  480,  103,  342,   49,
 /*   210 */   484,  485,  103,  183,  103,  351,  352,   57,  352,   20,
 /*   220 */    60,   61,  134,  223,  224,    0,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   240 */   240,  241,  242,  243,  140,  141,   21,  381,   67,   24,
 /*   250 */    25,   26,   27,   28,   29,   30,   31,   32,  392,    0,
 /*   260 */   394,    4,  247,  248,  249,  250,  251,  252,  253,  254,
 /*   270 */   255,  256,  257,  390,  170,  171,  393,  394,  351,  352,
 /*   280 */   176,  177,   20,   24,   25,   26,   27,   28,   29,   30,
 /*   290 */    31,   32,  204,  205,  428,  191,  430,  193,  371,  433,
 /*   300 */   434,  435,  436,  437,  438,  175,  440,  140,  141,  443,
 /*   310 */    20,  445,  446,  447,   67,  342,  286,  451,  452,  455,
 /*   320 */   456,  457,   20,  459,  460,  352,  260,  223,  224,  217,
 /*   330 */   226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
 /*   340 */   236,  237,  238,  239,  240,  241,  242,  243,  244,   12,
 /*   350 */    13,  260,  459,  372,  381,  462,  361,   20,   37,   22,
 /*   360 */   103,  380,  381,  379,  369,  392,  342,  394,  387,  260,
 /*   370 */    33,  260,   35,  480,  351,  391,  395,  484,  485,    8,
 /*   380 */     9,   84,  114,   12,   13,   14,   15,   16,  351,  352,
 /*   390 */    75,   20,  351,  352,  342,  244,  266,  267,  268,   62,
 /*   400 */    20,  428,  114,  430,  352,   68,  433,  434,  435,  436,
 /*   410 */   437,  438,   75,  440,  351,  352,  392,  342,  445,   75,
 /*   420 */   447,  351,  352,    4,  451,  452,  403,  106,  405,  108,
 /*   430 */   109,  432,  111,  381,  371,  398,  115,  100,   19,  358,
 /*   440 */   103,  371,  145,  146,  392,  381,  394,  474,    0,  351,
 /*   450 */   352,  387,   33,   12,   13,   14,  375,  458,  137,  395,
 /*   460 */   342,   20,  172,   22,  383,  168,  352,  392,   49,  371,
 /*   470 */   352,   35,  170,  171,   33,   56,   35,  140,  141,  342,
 /*   480 */   428,   62,  430,  103,  342,  433,  434,  435,  436,  437,
 /*   490 */   438,  439,  440,  441,  442,  381,  455,  456,  457,  381,
 /*   500 */   459,  460,  381,   62,  244,  186,  246,  170,  171,   14,
 /*   510 */   392,   75,  394,  176,  177,   20,   75,  260,   70,   71,
 /*   520 */    72,  102,  401,    3,  105,   77,   78,   79,  191,  392,
 /*   530 */   193,   83,  213,  214,  392,  351,   88,   89,   90,   91,
 /*   540 */    20,  100,   94,  172,  103,  342,  428,  342,  430,  435,
 /*   550 */     0,  433,  434,  435,  436,  437,  438,  352,  440,  354,
 /*   560 */   223,  224,  360,  226,  227,  228,  229,  230,  231,  232,
 /*   570 */   233,  234,  235,  236,  237,  238,  239,  240,  241,  242,
 /*   580 */   243,  140,  141,   70,   71,   72,  381,  403,  386,  405,
 /*   590 */    77,   78,   79,  475,  476,  392,   83,  392,  444,  394,
 /*   600 */   446,   88,   89,   90,   91,  459,  388,   94,  462,  351,
 /*   610 */   352,  170,  171,  381,   12,   13,   48,  176,  177,  387,
 /*   620 */   393,  394,  381,  339,  104,  479,  480,  395,  387,  371,
 /*   630 */   484,  485,  191,  428,  193,  430,  395,   35,  433,  434,
 /*   640 */   435,  436,  437,  438,    3,  440,  351,  352,  134,  135,
 /*   650 */   445,  351,  447,  139,    8,    9,  451,  452,   12,   13,
 /*   660 */    14,   15,   16,  418,  223,  224,  371,  226,  227,  228,
 /*   670 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*   680 */   239,  240,  241,  242,  243,   12,   13,  351,  352,  342,
 /*   690 */    44,  459,  172,   20,  462,   22,  412,   20,    0,  352,
 /*   700 */   444,  417,  446,  403,  223,  405,   33,  371,   35,  159,
 /*   710 */   342,  479,  480,  358,  351,  352,  484,  485,  168,  360,
 /*   720 */   352,    0,  103,  381,  351,  352,    8,    9,  381,  387,
 /*   730 */    12,   13,   14,   15,   16,   62,  377,  395,  383,  392,
 /*   740 */   172,  394,  342,  459,  371,  386,  462,  179,   75,  381,
 /*   750 */   104,   62,  271,  272,  273,  274,  275,  276,  277,   21,
 /*   760 */   392,  398,  394,  479,  480,   67,  351,  352,  484,  485,
 /*   770 */   372,  115,   34,  100,   36,  428,  103,  430,  380,  381,
 /*   780 */   433,  434,  435,  436,  437,  438,  371,  440,  342,   12,
 /*   790 */    13,  102,  392,  137,  105,  193,  428,   20,  430,   22,
 /*   800 */   369,  433,  434,  435,  436,  437,  438,  343,  440,  190,
 /*   810 */    33,  192,   35,  140,  141,  447,  432,  140,  141,  451,
 /*   820 */   452,  412,  104,    8,    9,  432,  417,   12,   13,   14,
 /*   830 */    15,   16,  402,  486,  487,  342,  115,    0,  392,   62,
 /*   840 */    14,  222,  458,  170,  171,  352,   20,  351,  352,  176,
 /*   850 */   177,  458,   75,  176,  177,  134,  135,  136,  137,  138,
 /*   860 */   139,  372,  351,  352,  191,  488,  193,  371,  459,  380,
 /*   870 */   381,  462,  351,  352,  381,  351,  352,  100,  443,  260,
 /*   880 */   103,  446,  371,  389,   14,  392,  392,  394,  479,  480,
 /*   890 */    20,  477,  371,  484,  485,  371,  223,  224,    0,  226,
 /*   900 */   227,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*   910 */   237,  238,  239,  240,  241,  242,  243,  140,  141,  104,
 /*   920 */   355,  428,  281,  430,  365,  366,  433,  434,  435,  436,
 /*   930 */   437,  438,  389,  440,  372,  392,  115,   39,    1,    2,
 /*   940 */   447,  459,  380,  381,  462,  452,  342,  170,  171,  351,
 /*   950 */   352,   22,  115,  176,  177,  134,  135,  136,  137,  138,
 /*   960 */   139,    4,  480,   33,   35,   47,  484,  485,  191,  371,
 /*   970 */   193,  134,  135,  136,  137,  138,  139,  351,  352,   49,
 /*   980 */    12,   13,   14,   15,   16,   14,  342,   57,   58,   59,
 /*   990 */    60,   20,   62,   20,  471,   22,  392,  371,   54,   55,
 /*  1000 */   223,  224,    0,  226,  227,  228,  229,  230,  231,  232,
 /*  1010 */   233,  234,  235,  236,  237,  238,  239,  240,  241,  242,
 /*  1020 */   243,  103,   18,   18,   20,  411,   53,  342,   23,  100,
 /*  1030 */   373,   27,  102,  376,   30,  105,  392,   33,    2,   20,
 /*  1040 */   170,  104,   37,   38,    8,    9,   41,   39,   12,   13,
 /*  1050 */    14,   15,   16,   49,   42,   51,   44,   52,    8,    9,
 /*  1060 */    56,  368,   12,   13,   14,   15,   16,  412,   63,   64,
 /*  1070 */    65,   66,   70,   71,   72,   73,   74,  392,   76,   77,
 /*  1080 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1090 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   14,
 /*  1100 */    15,   16,  367,  173,  174,  370,  102,   20,  103,    2,
 /*  1110 */   180,  181,  351,  352,  459,    8,    9,  462,  114,   12,
 /*  1120 */    13,   14,   15,   16,  169,  342,  356,  357,   42,  199,
 /*  1130 */    44,   22,  371,   22,  479,  480,   20,  342,   44,  484,
 /*  1140 */   485,  170,  356,  357,   35,  342,   35,  142,  144,  342,
 /*  1150 */    44,  147,  148,  149,  150,  151,  152,  153,  154,  155,
 /*  1160 */   156,  157,  158,  159,  160,  161,  162,  163,  412,  165,
 /*  1170 */   166,  167,    8,    9,   13,  392,   12,   13,   14,   15,
 /*  1180 */    16,  135,  342,  114,   75,  139,   35,  392,  183,  184,
 /*  1190 */   185,  172,  352,  188,  354,  392,   35,  342,  342,  392,
 /*  1200 */   342,  342,  247,  365,  366,  107,  201,  202,  110,  100,
 /*  1210 */   342,  100,  257,   45,   46,  459,  412,  212,  462,  262,
 /*  1220 */   215,  381,  172,  218,  219,  220,  221,  222,  380,  381,
 /*  1230 */   380,  381,  392,  164,  394,  479,  480,  380,  381,   44,
 /*  1240 */   484,  485,   13,  342,  380,  381,  200,  392,  392,  203,
 /*  1250 */   392,  392,  206,  352,  208,  354,  380,  381,    0,  172,
 /*  1260 */   392,  258,  259,  459,   35,  260,  462,  259,  428,  381,
 /*  1270 */   430,   62,   68,  433,  434,  435,  436,  437,  438,  207,
 /*  1280 */   440,  209,  381,  479,  480,  445,  170,  447,  484,  485,
 /*  1290 */     0,  451,  452,  392,    0,  394,    0,   44,  107,  104,
 /*  1300 */   191,  110,  193,  107,   44,  107,  110,   49,  110,   44,
 /*  1310 */    44,  342,   22,   44,  105,   44,   22,   35,   22,  140,
 /*  1320 */   141,  352,   44,  354,  368,   44,   35,   44,   44,  428,
 /*  1330 */    44,  430,  223,  224,  433,  434,  435,  436,  437,  438,
 /*  1340 */   355,  440,  402,  350,  193,    0,  445,  352,  447,  391,
 /*  1350 */   381,   44,  451,  452,    1,    2,  402,  104,   44,   44,
 /*  1360 */   461,  392,  481,  394,  104,   44,   75,   13,   44,  104,
 /*  1370 */   104,  103,   44,  104,  342,  104,   44,  283,   44,   13,
 /*  1380 */   453,  113,  104,  263,  352,  104,  354,  104,  104,   35,
 /*  1390 */   104,  285,  413,  465,  429,   50,   49,  428,   20,  430,
 /*  1400 */   342,   35,  433,  434,  435,  436,  437,  438,  422,  440,
 /*  1410 */   352,  104,  354,  381,  445,  427,  447,  206,  104,  104,
 /*  1420 */   451,  452,  360,  422,  392,  104,  394,  223,  104,  189,
 /*  1430 */   360,  415,  104,  352,   20,  342,  104,   42,  104,  381,
 /*  1440 */   399,   20,  402,  352,  399,  352,  169,   20,  397,  352,
 /*  1450 */   392,  351,  394,  351,  399,   99,  397,  397,  101,  364,
 /*  1460 */   428,  351,  430,   98,  363,  433,  434,  435,  436,  437,
 /*  1470 */   438,   20,  440,  351,  381,  193,  362,  445,  351,  447,
 /*  1480 */   351,  344,   48,  451,  452,  392,  428,  394,  430,  348,
 /*  1490 */   344,  433,  434,  435,  436,  437,  438,  348,  440,  422,
 /*  1500 */   360,   12,   13,  445,  342,  447,   20,  394,  360,  451,
 /*  1510 */   452,   22,   20,  353,  352,   20,  360,  414,  353,  360,
 /*  1520 */   351,  428,   33,  430,   35,  344,  433,  434,  435,  436,
 /*  1530 */   437,  438,  342,  440,  360,  360,  360,  351,  445,  381,
 /*  1540 */   447,  344,  352,  381,  451,  452,  392,  381,  381,  392,
 /*  1550 */   210,   62,  381,  381,  392,  392,  394,  426,  381,  381,
 /*  1560 */   103,  422,  424,  358,   75,  197,  421,  342,  196,  195,
 /*  1570 */   420,  381,  358,  351,  394,  402,  392,  352,  270,  269,
 /*  1580 */   392,  392,  392,  413,  394,  402,  392,  470,  470,  100,
 /*  1590 */   428,  278,  430,  182,  407,  433,  434,  435,  436,  437,
 /*  1600 */   438,  419,  440,  473,  472,  470,  381,  445,  407,  447,
 /*  1610 */   280,  469,  279,  451,  452,  468,  264,  392,  428,  394,
 /*  1620 */   430,  413,  467,  433,  434,  435,  436,  437,  438,  259,
 /*  1630 */   440,  287,  489,  284,  482,  445,  483,  447,   20,  352,
 /*  1640 */   282,  451,  452,  114,  432,  261,  353,  358,   20,  464,
 /*  1650 */   358,  405,  407,  428,  342,  430,  463,  407,  433,  434,
 /*  1660 */   435,  436,  437,  438,  352,  440,  392,  392,  392,  358,
 /*  1670 */   174,  392,  447,  103,  404,  376,  451,  452,  358,  352,
 /*  1680 */   191,  450,  193,  103,  342,  384,  370,  392,  351,  392,
 /*  1690 */   392,   36,  344,  381,  352,  345,  358,  374,  359,  374,
 /*  1700 */   374,  416,  340,  423,  392,    0,  394,    0,  408,    0,
 /*  1710 */   408,   42,  223,  224,    0,   35,  216,   35,   35,   35,
 /*  1720 */   216,    0,   35,  381,   35,  236,  237,  238,  239,  240,
 /*  1730 */   241,  242,  216,    0,  392,  216,  394,    0,   35,    0,
 /*  1740 */   428,   22,  430,   35,  211,  433,  434,  435,  436,  437,
 /*  1750 */   438,    0,  440,    0,  199,  342,    0,  199,  193,  447,
 /*  1760 */   200,    0,  191,  451,  452,  352,    0,    0,  187,  186,
 /*  1770 */   428,    0,  430,    0,   47,  433,  434,  435,  436,  437,
 /*  1780 */   438,    0,  440,   35,   49,    0,    0,   47,   42,    0,
 /*  1790 */     0,    0,   47,    0,  381,    0,    0,    0,  385,    0,
 /*  1800 */     0,  159,    0,   35,  159,  392,    0,  394,    0,    0,
 /*  1810 */     0,    0,    0,  342,    0,    0,    0,    0,  476,    0,
 /*  1820 */     0,    0,    0,  352,    0,    0,   47,  342,    0,   42,
 /*  1830 */     0,    0,    0,    0,    0,    0,    0,  352,    0,    0,
 /*  1840 */    22,  428,  143,  430,  342,    0,  433,  434,  435,  436,
 /*  1850 */   437,  438,  381,  440,  352,    0,  385,  182,    0,   22,
 /*  1860 */     0,   48,   22,  392,   35,  394,  381,   62,    0,   62,
 /*  1870 */     0,   48,    0,    0,    0,    0,   35,  392,    0,  394,
 /*  1880 */     0,   14,   35,  381,   35,   39,    0,   39,   62,   39,
 /*  1890 */     0,   35,   49,   49,  392,   42,  394,    0,   44,  428,
 /*  1900 */    49,  430,   39,   39,  433,  434,  435,  436,  437,  438,
 /*  1910 */     0,  440,   47,  428,  342,  430,   47,   40,  433,  434,
 /*  1920 */   435,  436,  437,  438,  352,  440,   47,   39,    0,    0,
 /*  1930 */   428,   69,  430,  342,    0,  433,  434,  435,  436,  437,
 /*  1940 */   438,    0,  440,  352,   35,   49,   39,    0,   35,  342,
 /*  1950 */    49,   39,    0,  381,   35,   49,   39,  385,    0,  352,
 /*  1960 */    35,    0,   39,  478,  392,   49,  394,    0,    0,    0,
 /*  1970 */     0,    0,  381,  112,   35,   22,  110,    0,   35,   35,
 /*  1980 */    35,   35,   44,  392,   35,  394,   35,   22,  381,  487,
 /*  1990 */    35,   35,  385,    0,   44,   35,   22,   35,    0,  392,
 /*  2000 */   428,  394,  430,   22,    0,  433,  434,  435,  436,  437,
 /*  2010 */   438,   22,  440,   35,   51,    0,    0,   35,   35,  428,
 /*  2020 */   342,  430,    0,   22,  433,  434,  435,  436,  437,  438,
 /*  2030 */   352,  440,    1,  442,   20,  428,  104,  430,   35,  103,
 /*  2040 */   433,  434,  435,  436,  437,  438,   35,  440,   35,    0,
 /*  2050 */    19,  103,   35,  172,   22,  342,    0,  198,   22,  381,
 /*  2060 */     0,  172,    0,  385,   33,  352,  174,  172,    3,  178,
 /*  2070 */   392,  172,  394,   44,   48,  103,  194,  101,  178,  104,
 /*  2080 */    49,   44,  103,   48,   99,  342,   44,  103,   57,   58,
 /*  2090 */    59,   60,  265,   62,  381,  352,  104,   44,  104,  103,
 /*  2100 */   103,   47,   47,  104,  104,  392,  428,  394,  430,  103,
 /*  2110 */    44,  433,  434,  435,  436,  437,  438,  265,  440,    3,
 /*  2120 */    44,   35,  342,  104,  381,   35,   35,   35,   35,   35,
 /*  2130 */    47,  104,  352,  102,  104,  392,  105,  394,    0,   44,
 /*  2140 */     0,  428,  258,  430,   47,   47,  433,  434,  435,  436,
 /*  2150 */   437,  438,  265,  440,  103,  103,   39,    0,   39,  173,
 /*  2160 */   103,  381,  104,  104,  103,  175,  103,  103,   47,  138,
 /*  2170 */    44,  428,  392,  430,  394,  101,  433,  434,  435,  436,
 /*  2180 */   437,  438,  113,  440,  342,  245,  101,    2,   22,  223,
 /*  2190 */   103,   47,  104,  104,  352,   47,  114,   22,   35,  342,
 /*  2200 */   104,  126,  103,  103,  173,  103,  103,  103,  428,  352,
 /*  2210 */   430,  180,  104,  433,  434,  435,  436,  437,  438,  104,
 /*  2220 */   440,   35,  104,  381,   35,  103,   35,  225,  103,   35,
 /*  2230 */   199,  104,  103,  103,  392,  104,  394,  104,  381,   35,
 /*  2240 */   104,   35,  103,   22,  103,   44,  126,   35,  103,  392,
 /*  2250 */   342,  394,  103,  103,  126,   22,   69,  115,  126,   35,
 /*  2260 */   352,   68,   35,   35,  342,   35,   35,   35,   97,   35,
 /*  2270 */   428,   35,  430,   75,  352,  433,  434,  435,  436,  437,
 /*  2280 */   438,   44,  440,   35,   35,  428,   35,  430,   22,  381,
 /*  2290 */   433,  434,  435,  436,  437,  438,    0,  440,   35,   35,
 /*  2300 */   392,   75,  394,  381,   35,   35,   35,   35,   35,   35,
 /*  2310 */    22,   35,   35,    0,  392,  342,  394,   49,   39,   35,
 /*  2320 */    39,    0,   35,    0,   39,  352,   35,   49,   39,   49,
 /*  2330 */     0,   49,   35,   35,    0,   21,  428,   22,  430,   22,
 /*  2340 */    22,  433,  434,  435,  436,  437,  438,   21,  440,   20,
 /*  2350 */   428,  490,  430,  490,  381,  433,  434,  435,  436,  437,
 /*  2360 */   438,  490,  440,  490,  490,  392,  490,  394,  490,  490,
 /*  2370 */   490,  490,  490,  490,  490,  342,  490,  490,  490,  490,
 /*  2380 */   490,  490,  490,  490,  490,  352,  490,  490,  490,  490,
 /*  2390 */   342,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2400 */   352,  428,  490,  430,  490,  490,  433,  434,  435,  436,
 /*  2410 */   437,  438,  490,  440,  381,  490,  490,  490,  490,  490,
 /*  2420 */   490,  490,  490,  490,  490,  392,  490,  394,  490,  381,
 /*  2430 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2440 */   392,  490,  394,  490,  490,  490,  490,  490,  342,  490,
 /*  2450 */   490,  490,  490,  490,  490,  490,  490,  490,  352,  490,
 /*  2460 */   490,  428,  490,  430,  490,  342,  433,  434,  435,  436,
 /*  2470 */   437,  438,  490,  440,  490,  352,  428,  490,  430,  342,
 /*  2480 */   490,  433,  434,  435,  436,  437,  438,  381,  440,  352,
 /*  2490 */   490,  490,  490,  490,  490,  490,  490,  490,  392,  490,
 /*  2500 */   394,  490,  490,  490,  381,  490,  490,  490,  490,  490,
 /*  2510 */   490,  490,  490,  490,  490,  392,  342,  394,  381,  490,
 /*  2520 */   490,  490,  490,  490,  490,  490,  352,  490,  490,  392,
 /*  2530 */   490,  394,  490,  490,  428,  490,  430,  342,  490,  433,
 /*  2540 */   434,  435,  436,  437,  438,  490,  440,  352,  490,  490,
 /*  2550 */   490,  428,  490,  430,  490,  381,  433,  434,  435,  436,
 /*  2560 */   437,  438,  490,  440,  490,  428,  392,  430,  394,  490,
 /*  2570 */   433,  434,  435,  436,  437,  438,  381,  440,  490,  490,
 /*  2580 */   490,  490,  490,  490,  490,  490,  490,  392,  490,  394,
 /*  2590 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2600 */   490,  490,  428,  342,  430,  490,  490,  433,  434,  435,
 /*  2610 */   436,  437,  438,  352,  440,  490,  490,  342,  490,  490,
 /*  2620 */   490,  490,  490,  428,  490,  430,  490,  352,  433,  434,
 /*  2630 */   435,  436,  437,  438,  342,  440,  490,  490,  490,  490,
 /*  2640 */   490,  490,  381,  490,  352,  490,  490,  490,  490,  490,
 /*  2650 */   490,  490,  490,  392,  490,  394,  381,  490,  490,  490,
 /*  2660 */   490,  490,  490,  490,  490,  490,  490,  392,  490,  394,
 /*  2670 */   490,  490,  490,  381,  490,  490,  490,  490,  490,  490,
 /*  2680 */   490,  490,  490,  490,  392,  490,  394,  490,  490,  428,
 /*  2690 */   490,  430,  490,  490,  433,  434,  435,  436,  437,  438,
 /*  2700 */   490,  440,  490,  428,  490,  430,  490,  490,  433,  434,
 /*  2710 */   435,  436,  437,  438,  490,  440,  490,  490,  490,  490,
 /*  2720 */   428,  490,  430,  490,  490,  433,  434,  435,  436,  437,
 /*  2730 */   438,  490,  440,  342,  490,  490,  490,  490,  490,  490,
 /*  2740 */   490,  490,  490,  352,  490,  490,  490,  490,  490,  342,
 /*  2750 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  352,
 /*  2760 */   490,  490,  490,  490,  490,  490,  490,  490,  342,  490,
 /*  2770 */   490,  490,  381,  490,  490,  490,  490,  490,  352,  490,
 /*  2780 */   490,  490,  490,  392,  490,  394,  490,  490,  381,  490,
 /*  2790 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  392,
 /*  2800 */   490,  394,  490,  490,  490,  490,  490,  381,  490,  490,
 /*  2810 */   490,  490,  490,  490,  490,  490,  490,  490,  392,  428,
 /*  2820 */   394,  430,  490,  490,  433,  434,  435,  436,  437,  438,
 /*  2830 */   490,  440,  490,  490,  490,  428,  490,  430,  490,  490,
 /*  2840 */   433,  434,  435,  436,  437,  438,  490,  440,  490,  490,
 /*  2850 */   490,  490,  490,  490,  428,  490,  430,  490,  342,  433,
 /*  2860 */   434,  435,  436,  437,  438,  490,  440,  490,  352,  490,
 /*  2870 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2880 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2890 */   490,  490,  490,  490,  490,  490,  490,  381,  490,  490,
 /*  2900 */   490,  490,  490,  490,  490,  490,  490,  490,  392,  490,
 /*  2910 */   394,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2920 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2930 */   490,  490,  490,  490,  490,  490,  490,  490,  490,  490,
 /*  2940 */   490,  490,  490,  490,  428,  490,  430,  490,  490,  433,
 /*  2950 */   434,  435,  436,  437,  438,  490,  440,  339,  339,  339,
 /*  2960 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  2970 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  2980 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  2990 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3000 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3010 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3020 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3030 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3040 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3050 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3060 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3070 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3080 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3090 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3100 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3110 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3120 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3130 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3140 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3150 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3160 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3170 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3180 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3190 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3200 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3210 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3220 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3230 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3240 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3250 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3260 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3270 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3280 */   339,  339,  339,  339,  339,  339,  339,  339,  339,  339,
 /*  3290 */   339,  339,  339,  339,  339,  339,
};
#define YY_SHIFT_COUNT    (800)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2334)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1005,    0,  104,    0,  337,  337,  337,  337,  337,  337,
 /*    10 */   337,  337,  337,  337,  337,  337,  441,  673,  673,  777,
 /*    20 */   673,  673,  673,  673,  673,  673,  673,  673,  673,  673,
 /*    30 */   673,  673,  673,  673,  673,  673,  673,  673,  673,  673,
 /*    40 */   673,  673,  673,  673,  673,  673,  673,  673,  673,  673,
 /*    50 */   673,   66,  111,  619,  380,   91,  109,   91,  380,  380,
 /*    60 */    91, 1489,   91, 1489, 1489,  257,   91,   35,  677,  170,
 /*    70 */   170,  677,    4,    4,  302,  167,  495,  495,  170,  170,
 /*    80 */   170,  170,  170,  170,  170,  170,  170,  170,  199,  170,
 /*    90 */   170,  181,   35,  170,  170,  262,   35,  170,  199,  170,
 /*   100 */   199,   35,  170,  170,   35,  170,   35,   35,   35,  170,
 /*   110 */   247, 1004,   15,   15,  513,  171, 1109, 1109, 1109, 1109,
 /*   120 */  1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109, 1109,
 /*   130 */  1109, 1109, 1109, 1109, 1109,  321,  520,  302,  167,  944,
 /*   140 */   944,  436,  290,  290,  290,  698,  260,  260,  436,  181,
 /*   150 */    35,   35,   35,   35,  268,  151,   35,  315,   35,  315,
 /*   160 */   315,  288,  344,   28,   28,   28,   28, 2031,  448,  225,
 /*   170 */   371,   30,  481,   32,  130,  602,  602,  870,  568,  971,
 /*   180 */   973, 1019, 1168,  826,  656, 1087, 1003, 1008,  641, 1003,
 /*   190 */  1012,  957, 1116, 1120, 1347, 1378, 1211,  181, 1378,  181,
 /*   200 */  1240, 1414, 1395, 1421, 1414, 1395, 1277, 1427, 1414, 1427,
 /*   210 */  1395, 1277, 1277, 1357, 1356, 1427, 1365, 1427, 1427, 1427,
 /*   220 */  1451, 1434, 1451, 1434, 1378,  181, 1486,  181, 1492, 1495,
 /*   230 */   181, 1492,  181,  181,  181, 1427,  181, 1451,   35,   35,
 /*   240 */    35,   35,   35,   35,   35, 1427, 1451,  315,  315,  315,
 /*   250 */  1340, 1457, 1378,  247, 1368, 1372, 1486,  247, 1374, 1120,
 /*   260 */  1427, 1421, 1421,  315, 1308, 1310,  315, 1308, 1310,  315,
 /*   270 */   315,   35, 1313, 1411, 1308, 1330, 1333, 1352, 1120, 1344,
 /*   280 */  1349, 1358, 1370, 1414, 1618, 1529, 1384, 1492,  247,  247,
 /*   290 */  1628, 1310,  315,  315,  315,  315,  315, 1310,  315, 1496,
 /*   300 */   247,  288,  247, 1414, 1570, 1580,  315,  344, 1427,  247,
 /*   310 */  1655, 1451, 2957, 2957, 2957, 2957, 2957, 2957, 2957, 2957,
 /*   320 */  2957, 1002,  930,  259,  646,  419,  718,  815,  721, 1036,
 /*   330 */  1107, 1050,  837, 1164, 1164, 1164, 1164, 1164, 1164, 1164,
 /*   340 */  1164, 1164,  821, 1046,  968,  968,  297,  160,  319,  550,
 /*   350 */   689,  929, 1111,  738,   88,  514,  514, 1085,  937,  955,
 /*   360 */  1085, 1085, 1085, 1258,  112, 1195,  898, 1086, 1069,   17,
 /*   370 */  1098, 1191, 1196, 1198, 1161, 1229, 1290, 1294, 1296, 1072,
 /*   380 */  1253, 1260, 1209, 1265, 1266, 1269, 1179, 1094, 1106, 1271,
 /*   390 */  1278, 1281, 1283, 1284, 1286, 1353, 1307, 1204, 1314,  918,
 /*   400 */  1315, 1321, 1324, 1328, 1332, 1334, 1268, 1151, 1282, 1354,
 /*   410 */  1366, 1291, 1345, 1705, 1707, 1709, 1669, 1714, 1680, 1500,
 /*   420 */  1682, 1683, 1684, 1504, 1721, 1687, 1689, 1516, 1733, 1519,
 /*   430 */  1737, 1703, 1739, 1719, 1751, 1708, 1533, 1753, 1555, 1756,
 /*   440 */  1558, 1560, 1565, 1571, 1761, 1766, 1767, 1581, 1583, 1771,
 /*   450 */  1773, 1727, 1781, 1748, 1735, 1785, 1740, 1786, 1746, 1789,
 /*   460 */  1790, 1791, 1745, 1793, 1795, 1796, 1797, 1799, 1800, 1642,
 /*   470 */  1768, 1802, 1645, 1806, 1808, 1809, 1810, 1811, 1812, 1814,
 /*   480 */  1815, 1816, 1817, 1819, 1820, 1821, 1822, 1824, 1825, 1779,
 /*   490 */  1828, 1787, 1830, 1831, 1832, 1833, 1834, 1835, 1818, 1836,
 /*   500 */  1838, 1839, 1699, 1845, 1855, 1837, 1813, 1840, 1823, 1860,
 /*   510 */  1805, 1829, 1868, 1807, 1870, 1826, 1872, 1873, 1841, 1843,
 /*   520 */  1846, 1874, 1847, 1844, 1848, 1875, 1849, 1851, 1850, 1878,
 /*   530 */  1856, 1880, 1853, 1863, 1854, 1865, 1869, 1867, 1879, 1886,
 /*   540 */  1877, 1864, 1890, 1897, 1910, 1888, 1675, 1858, 1928, 1929,
 /*   550 */  1862, 1934, 1941, 1909, 1896, 1907, 1947, 1913, 1901, 1912,
 /*   560 */  1952, 1919, 1906, 1917, 1958, 1925, 1916, 1923, 1961, 1967,
 /*   570 */  1968, 1969, 1970, 1971, 1861, 1866, 1939, 1953, 1977, 1943,
 /*   580 */  1944, 1945, 1946, 1949, 1951, 1955, 1938, 1950, 1956, 1960,
 /*   590 */  1965, 1962, 1993, 1974, 1998, 1981, 1963, 2004, 1989, 1978,
 /*   600 */  2015, 1982, 2016, 1983, 2022, 2001, 2014, 2003, 2011, 2013,
 /*   610 */  1932, 1936, 2049, 1881, 1948, 1859, 2017, 2032, 2056, 1882,
 /*   620 */  2036, 1889, 1892, 2060, 2062, 1895, 1891, 1899, 1900, 2065,
 /*   630 */  2029, 1827, 1972, 1975, 1979, 2026, 1976, 2035, 1985, 1992,
 /*   640 */  2037, 2042, 1994, 1984, 1996, 1997, 1999, 2053, 2054, 2055,
 /*   650 */  2006, 2066, 1852, 2000, 2019, 2116, 2076, 1887, 2086, 2090,
 /*   660 */  2091, 2092, 2093, 2094, 2027, 2030, 2083, 1884, 2095, 2097,
 /*   670 */  2138, 2140, 2051, 2117, 1865, 2098, 2052, 2058, 2059, 2057,
 /*   680 */  2061, 1990, 2063, 2157, 2119, 1986, 2064, 2069, 1865, 2121,
 /*   690 */  2126, 2074, 1940, 2085, 2185, 2166, 1966, 2087, 2088, 2099,
 /*   700 */  2089, 2100, 2096, 2144, 2102, 2103, 2148, 2108, 2175, 2002,
 /*   710 */  2104, 2082, 2115, 2163, 2186, 2122, 2118, 2189, 2125, 2127,
 /*   720 */  2191, 2129, 2131, 2194, 2130, 2133, 2204, 2139, 2136, 2206,
 /*   730 */  2141, 2075, 2120, 2128, 2132, 2221, 2142, 2145, 2201, 2149,
 /*   740 */  2212, 2150, 2201, 2201, 2233, 2187, 2193, 2224, 2227, 2228,
 /*   750 */  2230, 2231, 2232, 2234, 2236, 2198, 2171, 2237, 2248, 2249,
 /*   760 */  2251, 2266, 2263, 2264, 2269, 2226, 1938, 2270, 1950, 2271,
 /*   770 */  2272, 2273, 2274, 2288, 2276, 2296, 2277, 2268, 2279, 2313,
 /*   780 */  2284, 2278, 2281, 2321, 2287, 2280, 2285, 2323, 2291, 2282,
 /*   790 */  2289, 2330, 2297, 2298, 2334, 2315, 2314, 2317, 2318, 2326,
 /*   800 */  2329,
};
#define YY_REDUCE_COUNT (320)
#define YY_REDUCE_MIN   (-439)
#define YY_REDUCE_MAX   (2516)
static const short yy_reduce_ofst[] = {
 /*     0 */   284, -341, -134,  -27,  205,  840,  901,  969, 1032, 1058,
 /*    10 */  1093, 1162, 1190,  368, 1225, 1312,   52,  118,  347,  493,
 /*    20 */  1342, 1413, 1471, 1485, 1502, 1572, 1591, 1607, 1678, 1713,
 /*    30 */  1743, 1780, 1842, 1857, 1908, 1922, 1973, 2033, 2048, 2106,
 /*    40 */  2123, 2137, 2174, 2195, 2261, 2275, 2292, 2391, 2407, 2426,
 /*    50 */  2516, -274,  232,  409, -292, -371,  655,  756, -136,   41,
 /*    60 */   804, -366,  146, -311, -310, -107,  482,  -19, -391, -346,
 /*    70 */  -315, -287, -280, -270, -266, -117, -215, -173, -250,  -73,
 /*    80 */    63,   70, -209,   37,   98,  258,  295,  363,   23,  336,
 /*    90 */   373,  359, -297,  415,  511,  114,   64,  496,  184,  521,
 /*   100 */   300,  398,  524,  598,  241,  626,  489,  342,  562,  761,
 /*   110 */    81, -278, -439, -439,   -5, -168,   24,   75,  137,  142,
 /*   120 */   203,  400,  446,  604,  644,  685,  783,  795,  803,  807,
 /*   130 */   855,  856,  858,  859,  868,  -16,   -1,  121,  227,  770,
 /*   140 */   786,  559,   -1,  384,  393,  355,  154,  256,  838,  202,
 /*   150 */   848,  850,  857,  864, -271,  435,  876, -385, -347,  494,
 /*   160 */   543,  657,  735, -388, -367,  218, -388,  245,  431,  464,
 /*   170 */   430,  377,  414,  565,  523,  693,  956,  888,  614,  888,
 /*   180 */   985,  940,  993,  995,  958,  954,  899,  899,  881,  899,
 /*   190 */   927,  928,  888,  979,  965,  986,  988, 1062, 1001, 1070,
 /*   200 */  1016, 1081, 1041, 1040, 1091, 1045, 1051, 1100, 1097, 1102,
 /*   210 */  1055, 1059, 1060, 1095, 1101, 1110, 1114, 1122, 1127, 1129,
 /*   220 */  1137, 1141, 1146, 1149, 1077, 1140, 1113, 1148, 1160, 1103,
 /*   230 */  1156, 1165, 1159, 1174, 1175, 1169, 1176, 1181, 1158, 1166,
 /*   240 */  1167, 1171, 1172, 1177, 1178, 1186, 1197, 1154, 1157, 1163,
 /*   250 */  1131, 1138, 1139, 1205, 1145, 1150, 1180, 1214, 1182, 1170,
 /*   260 */  1222, 1173, 1183, 1184, 1117, 1187, 1188, 1118, 1201, 1189,
 /*   270 */  1194,  888, 1130, 1132, 1135, 1142, 1147, 1155, 1208, 1143,
 /*   280 */  1153, 1152,  899, 1287, 1212, 1185, 1193, 1293, 1289, 1292,
 /*   290 */  1246, 1245, 1274, 1275, 1276, 1279, 1295, 1250, 1297, 1270,
 /*   300 */  1311, 1299, 1320, 1327, 1231, 1301, 1298, 1316, 1337, 1338,
 /*   310 */  1350, 1348, 1285, 1280, 1300, 1302, 1323, 1325, 1326, 1339,
 /*   320 */  1362,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    10 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    20 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    30 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    40 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    50 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    60 */  2100, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    70 */  1788, 1788, 1788, 1788, 2073, 1788, 1788, 1788, 1788, 1788,
 /*    80 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*    90 */  1788, 1877, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   100 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   110 */  1875, 2066, 2292, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   120 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   130 */  1788, 1788, 1788, 1788, 1788, 1788, 2304, 1788, 1788, 1851,
 /*   140 */  1851, 1788, 2304, 2304, 2304, 1875, 2264, 2264, 1788, 1877,
 /*   150 */  1788, 1788, 1788, 1788, 2134, 1788, 1788, 1788, 1788, 1788,
 /*   160 */  1788, 1998, 1788, 2022, 1788, 1788, 1788, 2126, 1788, 1788,
 /*   170 */  2333, 2390, 1788, 1788, 2336, 1788, 1788, 1788, 1788, 1788,
 /*   180 */  1788, 2078, 1788, 1788, 1950, 2323, 2296, 2310, 2374, 2297,
 /*   190 */  2294, 2317, 1788, 2327, 1788, 1788, 2148, 1877, 1788, 1877,
 /*   200 */  2113, 1788, 2071, 1788, 1788, 2071, 2068, 1788, 1788, 1788,
 /*   210 */  2071, 2068, 2068, 1939, 1935, 1788, 1933, 1788, 1788, 1788,
 /*   220 */  1788, 1835, 1788, 1835, 1788, 1877, 1788, 1877, 1788, 1788,
 /*   230 */  1877, 1788, 1877, 1877, 1877, 1788, 1877, 1788, 1788, 1788,
 /*   240 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   250 */  2146, 2132, 1788, 1875, 2124, 2122, 1788, 1875, 2120, 2327,
 /*   260 */  1788, 1788, 1788, 1788, 2344, 2342, 1788, 2344, 2342, 1788,
 /*   270 */  1788, 1788, 2358, 2354, 2344, 2363, 2360, 2329, 2327, 2393,
 /*   280 */  2380, 2376, 2310, 1788, 1788, 2315, 2313, 1788, 1875, 1875,
 /*   290 */  1788, 2342, 1788, 1788, 1788, 1788, 1788, 2342, 1788, 1788,
 /*   300 */  1875, 1788, 1875, 1788, 1788, 1966, 1788, 1788, 1788, 1875,
 /*   310 */  1820, 1788, 2115, 2137, 2096, 2096, 2001, 2001, 2001, 1878,
 /*   320 */  1793, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   330 */  1788, 1788, 1788, 2357, 2356, 2219, 1788, 2268, 2267, 2266,
 /*   340 */  2257, 2218, 1962, 1788, 2217, 2216, 1788, 1788, 1788, 1788,
 /*   350 */  1788, 1788, 1788, 1788, 1788, 2087, 2086, 2210, 1788, 1788,
 /*   360 */  2211, 2209, 2208, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   370 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   380 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 2377, 2381, 1788,
 /*   390 */  1788, 1788, 1788, 1788, 1788, 2293, 1788, 1788, 1788, 2192,
 /*   400 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   410 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   420 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   430 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   440 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   450 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   460 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   470 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   480 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   490 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   500 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   510 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   520 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   530 */  1788, 1788, 1788, 1788, 1825, 2197, 1788, 1788, 1788, 1788,
 /*   540 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   550 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   560 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   570 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   580 */  1788, 1788, 1788, 1788, 1788, 1788, 1916, 1915, 1788, 1788,
 /*   590 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   600 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   610 */  2201, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   620 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 2373,
 /*   630 */  2330, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   640 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 2192,
 /*   650 */  1788, 2355, 1788, 1788, 2371, 1788, 2375, 1788, 1788, 1788,
 /*   660 */  1788, 1788, 1788, 1788, 2303, 2299, 1788, 1788, 2295, 1788,
 /*   670 */  1788, 1788, 1788, 1788, 2200, 1788, 1788, 1788, 1788, 1788,
 /*   680 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 2191, 1788,
 /*   690 */  2254, 1788, 1788, 1788, 2288, 1788, 1788, 2239, 1788, 1788,
 /*   700 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 2201, 1788, 2204,
 /*   710 */  1788, 1788, 1788, 1788, 1788, 1995, 1788, 1788, 1788, 1788,
 /*   720 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   730 */  1788, 1979, 1977, 1976, 1975, 1788, 1972, 1788, 2008, 1788,
 /*   740 */  1788, 1788, 2004, 2003, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   750 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1896, 1788, 1788,
 /*   760 */  1788, 1788, 1788, 1788, 1788, 1788, 1888, 1788, 1887, 1788,
 /*   770 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   780 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   790 */  1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788, 1788,
 /*   800 */  1788,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*     UNSAFE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  288,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*   GEOMETRY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       META => nothing */
    0,  /*       ONLY => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*      PAUSE => nothing */
    0,  /*     RESUME => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*  UNTREATED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*    NK_HINT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  288,  /*      AFTER => ABORT */
  288,  /*     ATTACH => ABORT */
  288,  /*     BEFORE => ABORT */
  288,  /*      BEGIN => ABORT */
  288,  /*     BITAND => ABORT */
  288,  /*     BITNOT => ABORT */
  288,  /*      BITOR => ABORT */
  288,  /*     BLOCKS => ABORT */
  288,  /*     CHANGE => ABORT */
  288,  /*      COMMA => ABORT */
  288,  /*     CONCAT => ABORT */
  288,  /*   CONFLICT => ABORT */
  288,  /*       COPY => ABORT */
  288,  /*   DEFERRED => ABORT */
  288,  /* DELIMITERS => ABORT */
  288,  /*     DETACH => ABORT */
  288,  /*     DIVIDE => ABORT */
  288,  /*        DOT => ABORT */
  288,  /*       EACH => ABORT */
  288,  /*       FAIL => ABORT */
  288,  /*       FILE => ABORT */
  288,  /*        FOR => ABORT */
  288,  /*       GLOB => ABORT */
  288,  /*         ID => ABORT */
  288,  /*  IMMEDIATE => ABORT */
  288,  /*     IMPORT => ABORT */
  288,  /*  INITIALLY => ABORT */
  288,  /*    INSTEAD => ABORT */
  288,  /*     ISNULL => ABORT */
  288,  /*        KEY => ABORT */
  288,  /*    MODULES => ABORT */
  288,  /*  NK_BITNOT => ABORT */
  288,  /*    NK_SEMI => ABORT */
  288,  /*    NOTNULL => ABORT */
  288,  /*         OF => ABORT */
  288,  /*       PLUS => ABORT */
  288,  /*  PRIVILEGE => ABORT */
  288,  /*      RAISE => ABORT */
  288,  /*   RESTRICT => ABORT */
  288,  /*        ROW => ABORT */
  288,  /*       SEMI => ABORT */
  288,  /*       STAR => ABORT */
  288,  /*  STATEMENT => ABORT */
  288,  /*     STRICT => ABORT */
  288,  /*     STRING => ABORT */
  288,  /*      TIMES => ABORT */
  288,  /*     VALUES => ABORT */
  288,  /*   VARIABLE => ABORT */
  288,  /*       VIEW => ABORT */
  288,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "UNSAFE",
  /*   56 */ "LOCAL",
  /*   57 */ "QNODE",
  /*   58 */ "BNODE",
  /*   59 */ "SNODE",
  /*   60 */ "MNODE",
  /*   61 */ "VNODE",
  /*   62 */ "DATABASE",
  /*   63 */ "USE",
  /*   64 */ "FLUSH",
  /*   65 */ "TRIM",
  /*   66 */ "COMPACT",
  /*   67 */ "IF",
  /*   68 */ "NOT",
  /*   69 */ "EXISTS",
  /*   70 */ "BUFFER",
  /*   71 */ "CACHEMODEL",
  /*   72 */ "CACHESIZE",
  /*   73 */ "COMP",
  /*   74 */ "DURATION",
  /*   75 */ "NK_VARIABLE",
  /*   76 */ "MAXROWS",
  /*   77 */ "MINROWS",
  /*   78 */ "KEEP",
  /*   79 */ "PAGES",
  /*   80 */ "PAGESIZE",
  /*   81 */ "TSDB_PAGESIZE",
  /*   82 */ "PRECISION",
  /*   83 */ "REPLICA",
  /*   84 */ "VGROUPS",
  /*   85 */ "SINGLE_STABLE",
  /*   86 */ "RETENTIONS",
  /*   87 */ "SCHEMALESS",
  /*   88 */ "WAL_LEVEL",
  /*   89 */ "WAL_FSYNC_PERIOD",
  /*   90 */ "WAL_RETENTION_PERIOD",
  /*   91 */ "WAL_RETENTION_SIZE",
  /*   92 */ "WAL_ROLL_PERIOD",
  /*   93 */ "WAL_SEGMENT_SIZE",
  /*   94 */ "STT_TRIGGER",
  /*   95 */ "TABLE_PREFIX",
  /*   96 */ "TABLE_SUFFIX",
  /*   97 */ "NK_COLON",
  /*   98 */ "MAX_SPEED",
  /*   99 */ "START",
  /*  100 */ "TIMESTAMP",
  /*  101 */ "END",
  /*  102 */ "TABLE",
  /*  103 */ "NK_LP",
  /*  104 */ "NK_RP",
  /*  105 */ "STABLE",
  /*  106 */ "ADD",
  /*  107 */ "COLUMN",
  /*  108 */ "MODIFY",
  /*  109 */ "RENAME",
  /*  110 */ "TAG",
  /*  111 */ "SET",
  /*  112 */ "NK_EQ",
  /*  113 */ "USING",
  /*  114 */ "TAGS",
  /*  115 */ "COMMENT",
  /*  116 */ "BOOL",
  /*  117 */ "TINYINT",
  /*  118 */ "SMALLINT",
  /*  119 */ "INT",
  /*  120 */ "INTEGER",
  /*  121 */ "BIGINT",
  /*  122 */ "FLOAT",
  /*  123 */ "DOUBLE",
  /*  124 */ "BINARY",
  /*  125 */ "NCHAR",
  /*  126 */ "UNSIGNED",
  /*  127 */ "JSON",
  /*  128 */ "VARCHAR",
  /*  129 */ "MEDIUMBLOB",
  /*  130 */ "BLOB",
  /*  131 */ "VARBINARY",
  /*  132 */ "GEOMETRY",
  /*  133 */ "DECIMAL",
  /*  134 */ "MAX_DELAY",
  /*  135 */ "WATERMARK",
  /*  136 */ "ROLLUP",
  /*  137 */ "TTL",
  /*  138 */ "SMA",
  /*  139 */ "DELETE_MARK",
  /*  140 */ "FIRST",
  /*  141 */ "LAST",
  /*  142 */ "SHOW",
  /*  143 */ "PRIVILEGES",
  /*  144 */ "DATABASES",
  /*  145 */ "TABLES",
  /*  146 */ "STABLES",
  /*  147 */ "MNODES",
  /*  148 */ "QNODES",
  /*  149 */ "FUNCTIONS",
  /*  150 */ "INDEXES",
  /*  151 */ "ACCOUNTS",
  /*  152 */ "APPS",
  /*  153 */ "CONNECTIONS",
  /*  154 */ "LICENCES",
  /*  155 */ "GRANTS",
  /*  156 */ "QUERIES",
  /*  157 */ "SCORES",
  /*  158 */ "TOPICS",
  /*  159 */ "VARIABLES",
  /*  160 */ "CLUSTER",
  /*  161 */ "BNODES",
  /*  162 */ "SNODES",
  /*  163 */ "TRANSACTIONS",
  /*  164 */ "DISTRIBUTED",
  /*  165 */ "CONSUMERS",
  /*  166 */ "SUBSCRIPTIONS",
  /*  167 */ "VNODES",
  /*  168 */ "ALIVE",
  /*  169 */ "LIKE",
  /*  170 */ "TBNAME",
  /*  171 */ "QTAGS",
  /*  172 */ "AS",
  /*  173 */ "INDEX",
  /*  174 */ "FUNCTION",
  /*  175 */ "INTERVAL",
  /*  176 */ "COUNT",
  /*  177 */ "LAST_ROW",
  /*  178 */ "META",
  /*  179 */ "ONLY",
  /*  180 */ "TOPIC",
  /*  181 */ "CONSUMER",
  /*  182 */ "GROUP",
  /*  183 */ "DESC",
  /*  184 */ "DESCRIBE",
  /*  185 */ "RESET",
  /*  186 */ "QUERY",
  /*  187 */ "CACHE",
  /*  188 */ "EXPLAIN",
  /*  189 */ "ANALYZE",
  /*  190 */ "VERBOSE",
  /*  191 */ "NK_BOOL",
  /*  192 */ "RATIO",
  /*  193 */ "NK_FLOAT",
  /*  194 */ "OUTPUTTYPE",
  /*  195 */ "AGGREGATE",
  /*  196 */ "BUFSIZE",
  /*  197 */ "LANGUAGE",
  /*  198 */ "REPLACE",
  /*  199 */ "STREAM",
  /*  200 */ "INTO",
  /*  201 */ "PAUSE",
  /*  202 */ "RESUME",
  /*  203 */ "TRIGGER",
  /*  204 */ "AT_ONCE",
  /*  205 */ "WINDOW_CLOSE",
  /*  206 */ "IGNORE",
  /*  207 */ "EXPIRED",
  /*  208 */ "FILL_HISTORY",
  /*  209 */ "UPDATE",
  /*  210 */ "SUBTABLE",
  /*  211 */ "UNTREATED",
  /*  212 */ "KILL",
  /*  213 */ "CONNECTION",
  /*  214 */ "TRANSACTION",
  /*  215 */ "BALANCE",
  /*  216 */ "VGROUP",
  /*  217 */ "LEADER",
  /*  218 */ "MERGE",
  /*  219 */ "REDISTRIBUTE",
  /*  220 */ "SPLIT",
  /*  221 */ "DELETE",
  /*  222 */ "INSERT",
  /*  223 */ "NULL",
  /*  224 */ "NK_QUESTION",
  /*  225 */ "NK_ARROW",
  /*  226 */ "ROWTS",
  /*  227 */ "QSTART",
  /*  228 */ "QEND",
  /*  229 */ "QDURATION",
  /*  230 */ "WSTART",
  /*  231 */ "WEND",
  /*  232 */ "WDURATION",
  /*  233 */ "IROWTS",
  /*  234 */ "ISFILLED",
  /*  235 */ "CAST",
  /*  236 */ "NOW",
  /*  237 */ "TODAY",
  /*  238 */ "TIMEZONE",
  /*  239 */ "CLIENT_VERSION",
  /*  240 */ "SERVER_VERSION",
  /*  241 */ "SERVER_STATUS",
  /*  242 */ "CURRENT_USER",
  /*  243 */ "CASE",
  /*  244 */ "WHEN",
  /*  245 */ "THEN",
  /*  246 */ "ELSE",
  /*  247 */ "BETWEEN",
  /*  248 */ "IS",
  /*  249 */ "NK_LT",
  /*  250 */ "NK_GT",
  /*  251 */ "NK_LE",
  /*  252 */ "NK_GE",
  /*  253 */ "NK_NE",
  /*  254 */ "MATCH",
  /*  255 */ "NMATCH",
  /*  256 */ "CONTAINS",
  /*  257 */ "IN",
  /*  258 */ "JOIN",
  /*  259 */ "INNER",
  /*  260 */ "SELECT",
  /*  261 */ "NK_HINT",
  /*  262 */ "DISTINCT",
  /*  263 */ "WHERE",
  /*  264 */ "PARTITION",
  /*  265 */ "BY",
  /*  266 */ "SESSION",
  /*  267 */ "STATE_WINDOW",
  /*  268 */ "EVENT_WINDOW",
  /*  269 */ "SLIDING",
  /*  270 */ "FILL",
  /*  271 */ "VALUE",
  /*  272 */ "VALUE_F",
  /*  273 */ "NONE",
  /*  274 */ "PREV",
  /*  275 */ "NULL_F",
  /*  276 */ "LINEAR",
  /*  277 */ "NEXT",
  /*  278 */ "HAVING",
  /*  279 */ "RANGE",
  /*  280 */ "EVERY",
  /*  281 */ "ORDER",
  /*  282 */ "SLIMIT",
  /*  283 */ "SOFFSET",
  /*  284 */ "LIMIT",
  /*  285 */ "OFFSET",
  /*  286 */ "ASC",
  /*  287 */ "NULLS",
  /*  288 */ "ABORT",
  /*  289 */ "AFTER",
  /*  290 */ "ATTACH",
  /*  291 */ "BEFORE",
  /*  292 */ "BEGIN",
  /*  293 */ "BITAND",
  /*  294 */ "BITNOT",
  /*  295 */ "BITOR",
  /*  296 */ "BLOCKS",
  /*  297 */ "CHANGE",
  /*  298 */ "COMMA",
  /*  299 */ "CONCAT",
  /*  300 */ "CONFLICT",
  /*  301 */ "COPY",
  /*  302 */ "DEFERRED",
  /*  303 */ "DELIMITERS",
  /*  304 */ "DETACH",
  /*  305 */ "DIVIDE",
  /*  306 */ "DOT",
  /*  307 */ "EACH",
  /*  308 */ "FAIL",
  /*  309 */ "FILE",
  /*  310 */ "FOR",
  /*  311 */ "GLOB",
  /*  312 */ "ID",
  /*  313 */ "IMMEDIATE",
  /*  314 */ "IMPORT",
  /*  315 */ "INITIALLY",
  /*  316 */ "INSTEAD",
  /*  317 */ "ISNULL",
  /*  318 */ "KEY",
  /*  319 */ "MODULES",
  /*  320 */ "NK_BITNOT",
  /*  321 */ "NK_SEMI",
  /*  322 */ "NOTNULL",
  /*  323 */ "OF",
  /*  324 */ "PLUS",
  /*  325 */ "PRIVILEGE",
  /*  326 */ "RAISE",
  /*  327 */ "RESTRICT",
  /*  328 */ "ROW",
  /*  329 */ "SEMI",
  /*  330 */ "STAR",
  /*  331 */ "STATEMENT",
  /*  332 */ "STRICT",
  /*  333 */ "STRING",
  /*  334 */ "TIMES",
  /*  335 */ "VALUES",
  /*  336 */ "VARIABLE",
  /*  337 */ "VIEW",
  /*  338 */ "WAL",
  /*  339 */ "cmd",
  /*  340 */ "account_options",
  /*  341 */ "alter_account_options",
  /*  342 */ "literal",
  /*  343 */ "alter_account_option",
  /*  344 */ "user_name",
  /*  345 */ "sysinfo_opt",
  /*  346 */ "privileges",
  /*  347 */ "priv_level",
  /*  348 */ "with_opt",
  /*  349 */ "priv_type_list",
  /*  350 */ "priv_type",
  /*  351 */ "db_name",
  /*  352 */ "table_name",
  /*  353 */ "topic_name",
  /*  354 */ "search_condition",
  /*  355 */ "dnode_endpoint",
  /*  356 */ "force_opt",
  /*  357 */ "unsafe_opt",
  /*  358 */ "not_exists_opt",
  /*  359 */ "db_options",
  /*  360 */ "exists_opt",
  /*  361 */ "alter_db_options",
  /*  362 */ "speed_opt",
  /*  363 */ "start_opt",
  /*  364 */ "end_opt",
  /*  365 */ "integer_list",
  /*  366 */ "variable_list",
  /*  367 */ "retention_list",
  /*  368 */ "signed",
  /*  369 */ "alter_db_option",
  /*  370 */ "retention",
  /*  371 */ "full_table_name",
  /*  372 */ "column_def_list",
  /*  373 */ "tags_def_opt",
  /*  374 */ "table_options",
  /*  375 */ "multi_create_clause",
  /*  376 */ "tags_def",
  /*  377 */ "multi_drop_clause",
  /*  378 */ "alter_table_clause",
  /*  379 */ "alter_table_options",
  /*  380 */ "column_def",
  /*  381 */ "column_name",
  /*  382 */ "signed_literal",
  /*  383 */ "create_subtable_clause",
  /*  384 */ "specific_cols_opt",
  /*  385 */ "expression_list",
  /*  386 */ "drop_table_clause",
  /*  387 */ "col_name_list",
  /*  388 */ "type_name",
  /*  389 */ "duration_list",
  /*  390 */ "rollup_func_list",
  /*  391 */ "alter_table_option",
  /*  392 */ "duration_literal",
  /*  393 */ "rollup_func_name",
  /*  394 */ "function_name",
  /*  395 */ "col_name",
  /*  396 */ "db_name_cond_opt",
  /*  397 */ "like_pattern_opt",
  /*  398 */ "table_name_cond",
  /*  399 */ "from_db_opt",
  /*  400 */ "tag_list_opt",
  /*  401 */ "tag_item",
  /*  402 */ "column_alias",
  /*  403 */ "full_index_name",
  /*  404 */ "index_options",
  /*  405 */ "index_name",
  /*  406 */ "func_list",
  /*  407 */ "sliding_opt",
  /*  408 */ "sma_stream_opt",
  /*  409 */ "func",
  /*  410 */ "sma_func_name",
  /*  411 */ "with_meta",
  /*  412 */ "query_or_subquery",
  /*  413 */ "where_clause_opt",
  /*  414 */ "cgroup_name",
  /*  415 */ "analyze_opt",
  /*  416 */ "explain_options",
  /*  417 */ "insert_query",
  /*  418 */ "or_replace_opt",
  /*  419 */ "agg_func_opt",
  /*  420 */ "bufsize_opt",
  /*  421 */ "language_opt",
  /*  422 */ "stream_name",
  /*  423 */ "stream_options",
  /*  424 */ "col_list_opt",
  /*  425 */ "tag_def_or_ref_opt",
  /*  426 */ "subtable_opt",
  /*  427 */ "ignore_opt",
  /*  428 */ "expression",
  /*  429 */ "dnode_list",
  /*  430 */ "literal_func",
  /*  431 */ "literal_list",
  /*  432 */ "table_alias",
  /*  433 */ "expr_or_subquery",
  /*  434 */ "pseudo_column",
  /*  435 */ "column_reference",
  /*  436 */ "function_expression",
  /*  437 */ "case_when_expression",
  /*  438 */ "star_func",
  /*  439 */ "star_func_para_list",
  /*  440 */ "noarg_func",
  /*  441 */ "other_para_list",
  /*  442 */ "star_func_para",
  /*  443 */ "when_then_list",
  /*  444 */ "case_when_else_opt",
  /*  445 */ "common_expression",
  /*  446 */ "when_then_expr",
  /*  447 */ "predicate",
  /*  448 */ "compare_op",
  /*  449 */ "in_op",
  /*  450 */ "in_predicate_value",
  /*  451 */ "boolean_value_expression",
  /*  452 */ "boolean_primary",
  /*  453 */ "from_clause_opt",
  /*  454 */ "table_reference_list",
  /*  455 */ "table_reference",
  /*  456 */ "table_primary",
  /*  457 */ "joined_table",
  /*  458 */ "alias_opt",
  /*  459 */ "subquery",
  /*  460 */ "parenthesized_joined_table",
  /*  461 */ "join_type",
  /*  462 */ "query_specification",
  /*  463 */ "hint_list",
  /*  464 */ "tag_mode_opt",
  /*  465 */ "set_quantifier_opt",
  /*  466 */ "select_list",
  /*  467 */ "partition_by_clause_opt",
  /*  468 */ "range_opt",
  /*  469 */ "every_opt",
  /*  470 */ "fill_opt",
  /*  471 */ "twindow_clause_opt",
  /*  472 */ "group_by_clause_opt",
  /*  473 */ "having_clause_opt",
  /*  474 */ "select_item",
  /*  475 */ "partition_list",
  /*  476 */ "partition_item",
  /*  477 */ "fill_mode",
  /*  478 */ "group_by_list",
  /*  479 */ "query_expression",
  /*  480 */ "query_simple",
  /*  481 */ "order_by_clause_opt",
  /*  482 */ "slimit_clause_opt",
  /*  483 */ "limit_clause_opt",
  /*  484 */ "union_query_expression",
  /*  485 */ "query_simple_or_subquery",
  /*  486 */ "sort_specification_list",
  /*  487 */ "sort_specification",
  /*  488 */ "ordering_specification_opt",
  /*  489 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= DROP DNODE NK_INTEGER unsafe_opt",
 /*  51 */ "cmd ::= DROP DNODE dnode_endpoint unsafe_opt",
 /*  52 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  53 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  54 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  55 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  56 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  57 */ "dnode_endpoint ::= NK_STRING",
 /*  58 */ "dnode_endpoint ::= NK_ID",
 /*  59 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  60 */ "force_opt ::=",
 /*  61 */ "force_opt ::= FORCE",
 /*  62 */ "unsafe_opt ::= UNSAFE",
 /*  63 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  64 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  65 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  74 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  75 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  76 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  77 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  78 */ "cmd ::= USE db_name",
 /*  79 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  80 */ "cmd ::= FLUSH DATABASE db_name",
 /*  81 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  82 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  83 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  84 */ "not_exists_opt ::=",
 /*  85 */ "exists_opt ::= IF EXISTS",
 /*  86 */ "exists_opt ::=",
 /*  87 */ "db_options ::=",
 /*  88 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  89 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  90 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  92 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  93 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  94 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  95 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  96 */ "db_options ::= db_options KEEP integer_list",
 /*  97 */ "db_options ::= db_options KEEP variable_list",
 /*  98 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  99 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options PRECISION NK_STRING",
 /* 102 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 103 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 104 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 105 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 106 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 113 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 114 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 115 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 116 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 117 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 118 */ "alter_db_options ::= alter_db_option",
 /* 119 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 120 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 121 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 122 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 124 */ "alter_db_option ::= KEEP integer_list",
 /* 125 */ "alter_db_option ::= KEEP variable_list",
 /* 126 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 127 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 129 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 130 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 132 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 133 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 134 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 135 */ "integer_list ::= NK_INTEGER",
 /* 136 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 137 */ "variable_list ::= NK_VARIABLE",
 /* 138 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 139 */ "retention_list ::= retention",
 /* 140 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 141 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 142 */ "speed_opt ::=",
 /* 143 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 144 */ "start_opt ::=",
 /* 145 */ "start_opt ::= START WITH NK_INTEGER",
 /* 146 */ "start_opt ::= START WITH NK_STRING",
 /* 147 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 148 */ "end_opt ::=",
 /* 149 */ "end_opt ::= END WITH NK_INTEGER",
 /* 150 */ "end_opt ::= END WITH NK_STRING",
 /* 151 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 152 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 153 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 154 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 155 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 156 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 157 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 158 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 159 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 160 */ "alter_table_clause ::= full_table_name ADD COLUMN column_def",
 /* 161 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 162 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_def",
 /* 163 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 164 */ "alter_table_clause ::= full_table_name ADD TAG column_def",
 /* 165 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 166 */ "alter_table_clause ::= full_table_name MODIFY TAG column_def",
 /* 167 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 168 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 169 */ "multi_create_clause ::= create_subtable_clause",
 /* 170 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 171 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 172 */ "multi_drop_clause ::= drop_table_clause",
 /* 173 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 174 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 175 */ "specific_cols_opt ::=",
 /* 176 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 177 */ "full_table_name ::= table_name",
 /* 178 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 179 */ "column_def_list ::= column_def",
 /* 180 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 181 */ "column_def ::= column_name type_name",
 /* 182 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 183 */ "type_name ::= BOOL",
 /* 184 */ "type_name ::= TINYINT",
 /* 185 */ "type_name ::= SMALLINT",
 /* 186 */ "type_name ::= INT",
 /* 187 */ "type_name ::= INTEGER",
 /* 188 */ "type_name ::= BIGINT",
 /* 189 */ "type_name ::= FLOAT",
 /* 190 */ "type_name ::= DOUBLE",
 /* 191 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 192 */ "type_name ::= TIMESTAMP",
 /* 193 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 194 */ "type_name ::= TINYINT UNSIGNED",
 /* 195 */ "type_name ::= SMALLINT UNSIGNED",
 /* 196 */ "type_name ::= INT UNSIGNED",
 /* 197 */ "type_name ::= BIGINT UNSIGNED",
 /* 198 */ "type_name ::= JSON",
 /* 199 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 200 */ "type_name ::= MEDIUMBLOB",
 /* 201 */ "type_name ::= BLOB",
 /* 202 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 203 */ "type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP",
 /* 204 */ "type_name ::= DECIMAL",
 /* 205 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 206 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 207 */ "tags_def_opt ::=",
 /* 208 */ "tags_def_opt ::= tags_def",
 /* 209 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 210 */ "table_options ::=",
 /* 211 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 212 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 213 */ "table_options ::= table_options WATERMARK duration_list",
 /* 214 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 215 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 216 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 217 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 218 */ "alter_table_options ::= alter_table_option",
 /* 219 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 220 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 221 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 222 */ "duration_list ::= duration_literal",
 /* 223 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 224 */ "rollup_func_list ::= rollup_func_name",
 /* 225 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 226 */ "rollup_func_name ::= function_name",
 /* 227 */ "rollup_func_name ::= FIRST",
 /* 228 */ "rollup_func_name ::= LAST",
 /* 229 */ "col_name_list ::= col_name",
 /* 230 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 231 */ "col_name ::= column_name",
 /* 232 */ "cmd ::= SHOW DNODES",
 /* 233 */ "cmd ::= SHOW USERS",
 /* 234 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 235 */ "cmd ::= SHOW DATABASES",
 /* 236 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 237 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 238 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 239 */ "cmd ::= SHOW MNODES",
 /* 240 */ "cmd ::= SHOW QNODES",
 /* 241 */ "cmd ::= SHOW FUNCTIONS",
 /* 242 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name",
 /* 244 */ "cmd ::= SHOW STREAMS",
 /* 245 */ "cmd ::= SHOW ACCOUNTS",
 /* 246 */ "cmd ::= SHOW APPS",
 /* 247 */ "cmd ::= SHOW CONNECTIONS",
 /* 248 */ "cmd ::= SHOW LICENCES",
 /* 249 */ "cmd ::= SHOW GRANTS",
 /* 250 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 251 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 252 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 253 */ "cmd ::= SHOW QUERIES",
 /* 254 */ "cmd ::= SHOW SCORES",
 /* 255 */ "cmd ::= SHOW TOPICS",
 /* 256 */ "cmd ::= SHOW VARIABLES",
 /* 257 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 258 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 259 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 260 */ "cmd ::= SHOW BNODES",
 /* 261 */ "cmd ::= SHOW SNODES",
 /* 262 */ "cmd ::= SHOW CLUSTER",
 /* 263 */ "cmd ::= SHOW TRANSACTIONS",
 /* 264 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 265 */ "cmd ::= SHOW CONSUMERS",
 /* 266 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 267 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 268 */ "cmd ::= SHOW TAGS FROM db_name NK_DOT table_name",
 /* 269 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 270 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name",
 /* 271 */ "cmd ::= SHOW VNODES ON DNODE NK_INTEGER",
 /* 272 */ "cmd ::= SHOW VNODES",
 /* 273 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 274 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 275 */ "db_name_cond_opt ::=",
 /* 276 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 277 */ "like_pattern_opt ::=",
 /* 278 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 279 */ "table_name_cond ::= table_name",
 /* 280 */ "from_db_opt ::=",
 /* 281 */ "from_db_opt ::= FROM db_name",
 /* 282 */ "tag_list_opt ::=",
 /* 283 */ "tag_list_opt ::= tag_item",
 /* 284 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 285 */ "tag_item ::= TBNAME",
 /* 286 */ "tag_item ::= QTAGS",
 /* 287 */ "tag_item ::= column_name",
 /* 288 */ "tag_item ::= column_name column_alias",
 /* 289 */ "tag_item ::= column_name AS column_alias",
 /* 290 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 291 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 292 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 293 */ "full_index_name ::= index_name",
 /* 294 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 295 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 296 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 297 */ "func_list ::= func",
 /* 298 */ "func_list ::= func_list NK_COMMA func",
 /* 299 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 300 */ "sma_func_name ::= function_name",
 /* 301 */ "sma_func_name ::= COUNT",
 /* 302 */ "sma_func_name ::= FIRST",
 /* 303 */ "sma_func_name ::= LAST",
 /* 304 */ "sma_func_name ::= LAST_ROW",
 /* 305 */ "sma_stream_opt ::=",
 /* 306 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 307 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 308 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 309 */ "with_meta ::= AS",
 /* 310 */ "with_meta ::= WITH META AS",
 /* 311 */ "with_meta ::= ONLY META AS",
 /* 312 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 313 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name",
 /* 314 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt",
 /* 315 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 316 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 317 */ "cmd ::= DESC full_table_name",
 /* 318 */ "cmd ::= DESCRIBE full_table_name",
 /* 319 */ "cmd ::= RESET QUERY CACHE",
 /* 320 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 321 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 322 */ "analyze_opt ::=",
 /* 323 */ "analyze_opt ::= ANALYZE",
 /* 324 */ "explain_options ::=",
 /* 325 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 326 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 327 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 328 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 329 */ "agg_func_opt ::=",
 /* 330 */ "agg_func_opt ::= AGGREGATE",
 /* 331 */ "bufsize_opt ::=",
 /* 332 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 333 */ "language_opt ::=",
 /* 334 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 335 */ "or_replace_opt ::=",
 /* 336 */ "or_replace_opt ::= OR REPLACE",
 /* 337 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 338 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 339 */ "cmd ::= PAUSE STREAM exists_opt stream_name",
 /* 340 */ "cmd ::= RESUME STREAM exists_opt ignore_opt stream_name",
 /* 341 */ "col_list_opt ::=",
 /* 342 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 343 */ "tag_def_or_ref_opt ::=",
 /* 344 */ "tag_def_or_ref_opt ::= tags_def",
 /* 345 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 346 */ "stream_options ::=",
 /* 347 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 348 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 349 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 350 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 351 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 352 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 353 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 354 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 355 */ "subtable_opt ::=",
 /* 356 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 357 */ "ignore_opt ::=",
 /* 358 */ "ignore_opt ::= IGNORE UNTREATED",
 /* 359 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 360 */ "cmd ::= KILL QUERY NK_STRING",
 /* 361 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 362 */ "cmd ::= BALANCE VGROUP",
 /* 363 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 364 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 365 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 366 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 367 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 368 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 369 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 370 */ "cmd ::= query_or_subquery",
 /* 371 */ "cmd ::= insert_query",
 /* 372 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 373 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 374 */ "literal ::= NK_INTEGER",
 /* 375 */ "literal ::= NK_FLOAT",
 /* 376 */ "literal ::= NK_STRING",
 /* 377 */ "literal ::= NK_BOOL",
 /* 378 */ "literal ::= TIMESTAMP NK_STRING",
 /* 379 */ "literal ::= duration_literal",
 /* 380 */ "literal ::= NULL",
 /* 381 */ "literal ::= NK_QUESTION",
 /* 382 */ "duration_literal ::= NK_VARIABLE",
 /* 383 */ "signed ::= NK_INTEGER",
 /* 384 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 385 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 386 */ "signed ::= NK_FLOAT",
 /* 387 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 388 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 389 */ "signed_literal ::= signed",
 /* 390 */ "signed_literal ::= NK_STRING",
 /* 391 */ "signed_literal ::= NK_BOOL",
 /* 392 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 393 */ "signed_literal ::= duration_literal",
 /* 394 */ "signed_literal ::= NULL",
 /* 395 */ "signed_literal ::= literal_func",
 /* 396 */ "signed_literal ::= NK_QUESTION",
 /* 397 */ "literal_list ::= signed_literal",
 /* 398 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 399 */ "db_name ::= NK_ID",
 /* 400 */ "table_name ::= NK_ID",
 /* 401 */ "column_name ::= NK_ID",
 /* 402 */ "function_name ::= NK_ID",
 /* 403 */ "table_alias ::= NK_ID",
 /* 404 */ "column_alias ::= NK_ID",
 /* 405 */ "user_name ::= NK_ID",
 /* 406 */ "topic_name ::= NK_ID",
 /* 407 */ "stream_name ::= NK_ID",
 /* 408 */ "cgroup_name ::= NK_ID",
 /* 409 */ "index_name ::= NK_ID",
 /* 410 */ "expr_or_subquery ::= expression",
 /* 411 */ "expression ::= literal",
 /* 412 */ "expression ::= pseudo_column",
 /* 413 */ "expression ::= column_reference",
 /* 414 */ "expression ::= function_expression",
 /* 415 */ "expression ::= case_when_expression",
 /* 416 */ "expression ::= NK_LP expression NK_RP",
 /* 417 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 418 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 419 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 420 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 421 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 422 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 423 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 424 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 425 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 426 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 427 */ "expression_list ::= expr_or_subquery",
 /* 428 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 429 */ "column_reference ::= column_name",
 /* 430 */ "column_reference ::= table_name NK_DOT column_name",
 /* 431 */ "pseudo_column ::= ROWTS",
 /* 432 */ "pseudo_column ::= TBNAME",
 /* 433 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 434 */ "pseudo_column ::= QSTART",
 /* 435 */ "pseudo_column ::= QEND",
 /* 436 */ "pseudo_column ::= QDURATION",
 /* 437 */ "pseudo_column ::= WSTART",
 /* 438 */ "pseudo_column ::= WEND",
 /* 439 */ "pseudo_column ::= WDURATION",
 /* 440 */ "pseudo_column ::= IROWTS",
 /* 441 */ "pseudo_column ::= ISFILLED",
 /* 442 */ "pseudo_column ::= QTAGS",
 /* 443 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 444 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 445 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 446 */ "function_expression ::= literal_func",
 /* 447 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 448 */ "literal_func ::= NOW",
 /* 449 */ "noarg_func ::= NOW",
 /* 450 */ "noarg_func ::= TODAY",
 /* 451 */ "noarg_func ::= TIMEZONE",
 /* 452 */ "noarg_func ::= DATABASE",
 /* 453 */ "noarg_func ::= CLIENT_VERSION",
 /* 454 */ "noarg_func ::= SERVER_VERSION",
 /* 455 */ "noarg_func ::= SERVER_STATUS",
 /* 456 */ "noarg_func ::= CURRENT_USER",
 /* 457 */ "noarg_func ::= USER",
 /* 458 */ "star_func ::= COUNT",
 /* 459 */ "star_func ::= FIRST",
 /* 460 */ "star_func ::= LAST",
 /* 461 */ "star_func ::= LAST_ROW",
 /* 462 */ "star_func_para_list ::= NK_STAR",
 /* 463 */ "star_func_para_list ::= other_para_list",
 /* 464 */ "other_para_list ::= star_func_para",
 /* 465 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 466 */ "star_func_para ::= expr_or_subquery",
 /* 467 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 468 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 469 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 470 */ "when_then_list ::= when_then_expr",
 /* 471 */ "when_then_list ::= when_then_list when_then_expr",
 /* 472 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 473 */ "case_when_else_opt ::=",
 /* 474 */ "case_when_else_opt ::= ELSE common_expression",
 /* 475 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 476 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 477 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 478 */ "predicate ::= expr_or_subquery IS NULL",
 /* 479 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 480 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 481 */ "compare_op ::= NK_LT",
 /* 482 */ "compare_op ::= NK_GT",
 /* 483 */ "compare_op ::= NK_LE",
 /* 484 */ "compare_op ::= NK_GE",
 /* 485 */ "compare_op ::= NK_NE",
 /* 486 */ "compare_op ::= NK_EQ",
 /* 487 */ "compare_op ::= LIKE",
 /* 488 */ "compare_op ::= NOT LIKE",
 /* 489 */ "compare_op ::= MATCH",
 /* 490 */ "compare_op ::= NMATCH",
 /* 491 */ "compare_op ::= CONTAINS",
 /* 492 */ "in_op ::= IN",
 /* 493 */ "in_op ::= NOT IN",
 /* 494 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 495 */ "boolean_value_expression ::= boolean_primary",
 /* 496 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 497 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 498 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 499 */ "boolean_primary ::= predicate",
 /* 500 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 501 */ "common_expression ::= expr_or_subquery",
 /* 502 */ "common_expression ::= boolean_value_expression",
 /* 503 */ "from_clause_opt ::=",
 /* 504 */ "from_clause_opt ::= FROM table_reference_list",
 /* 505 */ "table_reference_list ::= table_reference",
 /* 506 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 507 */ "table_reference ::= table_primary",
 /* 508 */ "table_reference ::= joined_table",
 /* 509 */ "table_primary ::= table_name alias_opt",
 /* 510 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 511 */ "table_primary ::= subquery alias_opt",
 /* 512 */ "table_primary ::= parenthesized_joined_table",
 /* 513 */ "alias_opt ::=",
 /* 514 */ "alias_opt ::= table_alias",
 /* 515 */ "alias_opt ::= AS table_alias",
 /* 516 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 517 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 518 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 519 */ "join_type ::=",
 /* 520 */ "join_type ::= INNER",
 /* 521 */ "query_specification ::= SELECT hint_list tag_mode_opt set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 522 */ "hint_list ::=",
 /* 523 */ "hint_list ::= NK_HINT",
 /* 524 */ "tag_mode_opt ::=",
 /* 525 */ "tag_mode_opt ::= TAGS",
 /* 526 */ "set_quantifier_opt ::=",
 /* 527 */ "set_quantifier_opt ::= DISTINCT",
 /* 528 */ "set_quantifier_opt ::= ALL",
 /* 529 */ "select_list ::= select_item",
 /* 530 */ "select_list ::= select_list NK_COMMA select_item",
 /* 531 */ "select_item ::= NK_STAR",
 /* 532 */ "select_item ::= common_expression",
 /* 533 */ "select_item ::= common_expression column_alias",
 /* 534 */ "select_item ::= common_expression AS column_alias",
 /* 535 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 536 */ "where_clause_opt ::=",
 /* 537 */ "where_clause_opt ::= WHERE search_condition",
 /* 538 */ "partition_by_clause_opt ::=",
 /* 539 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 540 */ "partition_list ::= partition_item",
 /* 541 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 542 */ "partition_item ::= expr_or_subquery",
 /* 543 */ "partition_item ::= expr_or_subquery column_alias",
 /* 544 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 545 */ "twindow_clause_opt ::=",
 /* 546 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 547 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 548 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 549 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 550 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 551 */ "sliding_opt ::=",
 /* 552 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 553 */ "fill_opt ::=",
 /* 554 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 555 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 556 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 557 */ "fill_mode ::= NONE",
 /* 558 */ "fill_mode ::= PREV",
 /* 559 */ "fill_mode ::= NULL",
 /* 560 */ "fill_mode ::= NULL_F",
 /* 561 */ "fill_mode ::= LINEAR",
 /* 562 */ "fill_mode ::= NEXT",
 /* 563 */ "group_by_clause_opt ::=",
 /* 564 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 565 */ "group_by_list ::= expr_or_subquery",
 /* 566 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 567 */ "having_clause_opt ::=",
 /* 568 */ "having_clause_opt ::= HAVING search_condition",
 /* 569 */ "range_opt ::=",
 /* 570 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 571 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_RP",
 /* 572 */ "every_opt ::=",
 /* 573 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 574 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 575 */ "query_simple ::= query_specification",
 /* 576 */ "query_simple ::= union_query_expression",
 /* 577 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 578 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 579 */ "query_simple_or_subquery ::= query_simple",
 /* 580 */ "query_simple_or_subquery ::= subquery",
 /* 581 */ "query_or_subquery ::= query_expression",
 /* 582 */ "query_or_subquery ::= subquery",
 /* 583 */ "order_by_clause_opt ::=",
 /* 584 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 585 */ "slimit_clause_opt ::=",
 /* 586 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 587 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 588 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 589 */ "limit_clause_opt ::=",
 /* 590 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 591 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 592 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 593 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 594 */ "subquery ::= NK_LP subquery NK_RP",
 /* 595 */ "search_condition ::= common_expression",
 /* 596 */ "sort_specification_list ::= sort_specification",
 /* 597 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 598 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 599 */ "ordering_specification_opt ::=",
 /* 600 */ "ordering_specification_opt ::= ASC",
 /* 601 */ "ordering_specification_opt ::= DESC",
 /* 602 */ "null_ordering_opt ::=",
 /* 603 */ "null_ordering_opt ::= NULLS FIRST",
 /* 604 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 339: /* cmd */
    case 342: /* literal */
    case 348: /* with_opt */
    case 354: /* search_condition */
    case 359: /* db_options */
    case 361: /* alter_db_options */
    case 363: /* start_opt */
    case 364: /* end_opt */
    case 368: /* signed */
    case 370: /* retention */
    case 371: /* full_table_name */
    case 374: /* table_options */
    case 378: /* alter_table_clause */
    case 379: /* alter_table_options */
    case 380: /* column_def */
    case 382: /* signed_literal */
    case 383: /* create_subtable_clause */
    case 386: /* drop_table_clause */
    case 392: /* duration_literal */
    case 393: /* rollup_func_name */
    case 395: /* col_name */
    case 396: /* db_name_cond_opt */
    case 397: /* like_pattern_opt */
    case 398: /* table_name_cond */
    case 399: /* from_db_opt */
    case 401: /* tag_item */
    case 403: /* full_index_name */
    case 404: /* index_options */
    case 407: /* sliding_opt */
    case 408: /* sma_stream_opt */
    case 409: /* func */
    case 412: /* query_or_subquery */
    case 413: /* where_clause_opt */
    case 416: /* explain_options */
    case 417: /* insert_query */
    case 423: /* stream_options */
    case 426: /* subtable_opt */
    case 428: /* expression */
    case 430: /* literal_func */
    case 433: /* expr_or_subquery */
    case 434: /* pseudo_column */
    case 435: /* column_reference */
    case 436: /* function_expression */
    case 437: /* case_when_expression */
    case 442: /* star_func_para */
    case 444: /* case_when_else_opt */
    case 445: /* common_expression */
    case 446: /* when_then_expr */
    case 447: /* predicate */
    case 450: /* in_predicate_value */
    case 451: /* boolean_value_expression */
    case 452: /* boolean_primary */
    case 453: /* from_clause_opt */
    case 454: /* table_reference_list */
    case 455: /* table_reference */
    case 456: /* table_primary */
    case 457: /* joined_table */
    case 459: /* subquery */
    case 460: /* parenthesized_joined_table */
    case 462: /* query_specification */
    case 468: /* range_opt */
    case 469: /* every_opt */
    case 470: /* fill_opt */
    case 471: /* twindow_clause_opt */
    case 473: /* having_clause_opt */
    case 474: /* select_item */
    case 476: /* partition_item */
    case 479: /* query_expression */
    case 480: /* query_simple */
    case 482: /* slimit_clause_opt */
    case 483: /* limit_clause_opt */
    case 484: /* union_query_expression */
    case 485: /* query_simple_or_subquery */
    case 487: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy952)); 
}
      break;
    case 340: /* account_options */
    case 341: /* alter_account_options */
    case 343: /* alter_account_option */
    case 362: /* speed_opt */
    case 411: /* with_meta */
    case 420: /* bufsize_opt */
{
 
}
      break;
    case 344: /* user_name */
    case 351: /* db_name */
    case 352: /* table_name */
    case 353: /* topic_name */
    case 355: /* dnode_endpoint */
    case 381: /* column_name */
    case 394: /* function_name */
    case 402: /* column_alias */
    case 405: /* index_name */
    case 410: /* sma_func_name */
    case 414: /* cgroup_name */
    case 421: /* language_opt */
    case 422: /* stream_name */
    case 432: /* table_alias */
    case 438: /* star_func */
    case 440: /* noarg_func */
    case 458: /* alias_opt */
{
 
}
      break;
    case 345: /* sysinfo_opt */
{
 
}
      break;
    case 346: /* privileges */
    case 349: /* priv_type_list */
    case 350: /* priv_type */
{
 
}
      break;
    case 347: /* priv_level */
{
 
}
      break;
    case 356: /* force_opt */
    case 357: /* unsafe_opt */
    case 358: /* not_exists_opt */
    case 360: /* exists_opt */
    case 415: /* analyze_opt */
    case 418: /* or_replace_opt */
    case 419: /* agg_func_opt */
    case 427: /* ignore_opt */
    case 464: /* tag_mode_opt */
    case 465: /* set_quantifier_opt */
{
 
}
      break;
    case 365: /* integer_list */
    case 366: /* variable_list */
    case 367: /* retention_list */
    case 372: /* column_def_list */
    case 373: /* tags_def_opt */
    case 375: /* multi_create_clause */
    case 376: /* tags_def */
    case 377: /* multi_drop_clause */
    case 384: /* specific_cols_opt */
    case 385: /* expression_list */
    case 387: /* col_name_list */
    case 389: /* duration_list */
    case 390: /* rollup_func_list */
    case 400: /* tag_list_opt */
    case 406: /* func_list */
    case 424: /* col_list_opt */
    case 425: /* tag_def_or_ref_opt */
    case 429: /* dnode_list */
    case 431: /* literal_list */
    case 439: /* star_func_para_list */
    case 441: /* other_para_list */
    case 443: /* when_then_list */
    case 463: /* hint_list */
    case 466: /* select_list */
    case 467: /* partition_by_clause_opt */
    case 472: /* group_by_clause_opt */
    case 475: /* partition_list */
    case 478: /* group_by_list */
    case 481: /* order_by_clause_opt */
    case 486: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy824)); 
}
      break;
    case 369: /* alter_db_option */
    case 391: /* alter_table_option */
{
 
}
      break;
    case 388: /* type_name */
{
 
}
      break;
    case 448: /* compare_op */
    case 449: /* in_op */
{
 
}
      break;
    case 461: /* join_type */
{
 
}
      break;
    case 477: /* fill_mode */
{
 
}
      break;
    case 488: /* ordering_specification_opt */
{
 
}
      break;
    case 489: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   339,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   339,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   340,  /* (2) account_options ::= */
   340,  /* (3) account_options ::= account_options PPS literal */
   340,  /* (4) account_options ::= account_options TSERIES literal */
   340,  /* (5) account_options ::= account_options STORAGE literal */
   340,  /* (6) account_options ::= account_options STREAMS literal */
   340,  /* (7) account_options ::= account_options QTIME literal */
   340,  /* (8) account_options ::= account_options DBS literal */
   340,  /* (9) account_options ::= account_options USERS literal */
   340,  /* (10) account_options ::= account_options CONNS literal */
   340,  /* (11) account_options ::= account_options STATE literal */
   341,  /* (12) alter_account_options ::= alter_account_option */
   341,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   343,  /* (14) alter_account_option ::= PASS literal */
   343,  /* (15) alter_account_option ::= PPS literal */
   343,  /* (16) alter_account_option ::= TSERIES literal */
   343,  /* (17) alter_account_option ::= STORAGE literal */
   343,  /* (18) alter_account_option ::= STREAMS literal */
   343,  /* (19) alter_account_option ::= QTIME literal */
   343,  /* (20) alter_account_option ::= DBS literal */
   343,  /* (21) alter_account_option ::= USERS literal */
   343,  /* (22) alter_account_option ::= CONNS literal */
   343,  /* (23) alter_account_option ::= STATE literal */
   339,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   339,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   339,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   339,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   339,  /* (28) cmd ::= DROP USER user_name */
   345,  /* (29) sysinfo_opt ::= */
   345,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   339,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   339,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   346,  /* (33) privileges ::= ALL */
   346,  /* (34) privileges ::= priv_type_list */
   346,  /* (35) privileges ::= SUBSCRIBE */
   349,  /* (36) priv_type_list ::= priv_type */
   349,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   350,  /* (38) priv_type ::= READ */
   350,  /* (39) priv_type ::= WRITE */
   347,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   347,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   347,  /* (42) priv_level ::= db_name NK_DOT table_name */
   347,  /* (43) priv_level ::= topic_name */
   348,  /* (44) with_opt ::= */
   348,  /* (45) with_opt ::= WITH search_condition */
   339,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   339,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   339,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   339,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   339,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   339,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   339,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   339,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   339,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   339,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   339,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   355,  /* (57) dnode_endpoint ::= NK_STRING */
   355,  /* (58) dnode_endpoint ::= NK_ID */
   355,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
   356,  /* (60) force_opt ::= */
   356,  /* (61) force_opt ::= FORCE */
   357,  /* (62) unsafe_opt ::= UNSAFE */
   339,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   339,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   339,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   339,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   339,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   339,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   339,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   339,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   339,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   339,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   339,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   339,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   339,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   339,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   339,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   339,  /* (78) cmd ::= USE db_name */
   339,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   339,  /* (80) cmd ::= FLUSH DATABASE db_name */
   339,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   339,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   358,  /* (83) not_exists_opt ::= IF NOT EXISTS */
   358,  /* (84) not_exists_opt ::= */
   360,  /* (85) exists_opt ::= IF EXISTS */
   360,  /* (86) exists_opt ::= */
   359,  /* (87) db_options ::= */
   359,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   359,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   359,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   359,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   359,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   359,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   359,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   359,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   359,  /* (96) db_options ::= db_options KEEP integer_list */
   359,  /* (97) db_options ::= db_options KEEP variable_list */
   359,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   359,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   359,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   359,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   359,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   359,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   359,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   359,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   359,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   359,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   359,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   359,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   359,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   359,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   359,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   359,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   359,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   359,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   359,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   359,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   361,  /* (118) alter_db_options ::= alter_db_option */
   361,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   369,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   369,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   369,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   369,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   369,  /* (124) alter_db_option ::= KEEP integer_list */
   369,  /* (125) alter_db_option ::= KEEP variable_list */
   369,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   369,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   369,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   369,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   369,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   369,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   369,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   369,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   369,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   365,  /* (135) integer_list ::= NK_INTEGER */
   365,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   366,  /* (137) variable_list ::= NK_VARIABLE */
   366,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   367,  /* (139) retention_list ::= retention */
   367,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   370,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   362,  /* (142) speed_opt ::= */
   362,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
   363,  /* (144) start_opt ::= */
   363,  /* (145) start_opt ::= START WITH NK_INTEGER */
   363,  /* (146) start_opt ::= START WITH NK_STRING */
   363,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
   364,  /* (148) end_opt ::= */
   364,  /* (149) end_opt ::= END WITH NK_INTEGER */
   364,  /* (150) end_opt ::= END WITH NK_STRING */
   364,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   339,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   339,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   339,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   339,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   339,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   339,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   339,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   378,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   378,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_def */
   378,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   378,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_def */
   378,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   378,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_def */
   378,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   378,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_def */
   378,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   378,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   375,  /* (169) multi_create_clause ::= create_subtable_clause */
   375,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
   383,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   377,  /* (172) multi_drop_clause ::= drop_table_clause */
   377,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   386,  /* (174) drop_table_clause ::= exists_opt full_table_name */
   384,  /* (175) specific_cols_opt ::= */
   384,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   371,  /* (177) full_table_name ::= table_name */
   371,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   372,  /* (179) column_def_list ::= column_def */
   372,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   380,  /* (181) column_def ::= column_name type_name */
   380,  /* (182) column_def ::= column_name type_name COMMENT NK_STRING */
   388,  /* (183) type_name ::= BOOL */
   388,  /* (184) type_name ::= TINYINT */
   388,  /* (185) type_name ::= SMALLINT */
   388,  /* (186) type_name ::= INT */
   388,  /* (187) type_name ::= INTEGER */
   388,  /* (188) type_name ::= BIGINT */
   388,  /* (189) type_name ::= FLOAT */
   388,  /* (190) type_name ::= DOUBLE */
   388,  /* (191) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   388,  /* (192) type_name ::= TIMESTAMP */
   388,  /* (193) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   388,  /* (194) type_name ::= TINYINT UNSIGNED */
   388,  /* (195) type_name ::= SMALLINT UNSIGNED */
   388,  /* (196) type_name ::= INT UNSIGNED */
   388,  /* (197) type_name ::= BIGINT UNSIGNED */
   388,  /* (198) type_name ::= JSON */
   388,  /* (199) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   388,  /* (200) type_name ::= MEDIUMBLOB */
   388,  /* (201) type_name ::= BLOB */
   388,  /* (202) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   388,  /* (203) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   388,  /* (204) type_name ::= DECIMAL */
   388,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   388,  /* (206) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   373,  /* (207) tags_def_opt ::= */
   373,  /* (208) tags_def_opt ::= tags_def */
   376,  /* (209) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   374,  /* (210) table_options ::= */
   374,  /* (211) table_options ::= table_options COMMENT NK_STRING */
   374,  /* (212) table_options ::= table_options MAX_DELAY duration_list */
   374,  /* (213) table_options ::= table_options WATERMARK duration_list */
   374,  /* (214) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   374,  /* (215) table_options ::= table_options TTL NK_INTEGER */
   374,  /* (216) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   374,  /* (217) table_options ::= table_options DELETE_MARK duration_list */
   379,  /* (218) alter_table_options ::= alter_table_option */
   379,  /* (219) alter_table_options ::= alter_table_options alter_table_option */
   391,  /* (220) alter_table_option ::= COMMENT NK_STRING */
   391,  /* (221) alter_table_option ::= TTL NK_INTEGER */
   389,  /* (222) duration_list ::= duration_literal */
   389,  /* (223) duration_list ::= duration_list NK_COMMA duration_literal */
   390,  /* (224) rollup_func_list ::= rollup_func_name */
   390,  /* (225) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   393,  /* (226) rollup_func_name ::= function_name */
   393,  /* (227) rollup_func_name ::= FIRST */
   393,  /* (228) rollup_func_name ::= LAST */
   387,  /* (229) col_name_list ::= col_name */
   387,  /* (230) col_name_list ::= col_name_list NK_COMMA col_name */
   395,  /* (231) col_name ::= column_name */
   339,  /* (232) cmd ::= SHOW DNODES */
   339,  /* (233) cmd ::= SHOW USERS */
   339,  /* (234) cmd ::= SHOW USER PRIVILEGES */
   339,  /* (235) cmd ::= SHOW DATABASES */
   339,  /* (236) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   339,  /* (237) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   339,  /* (238) cmd ::= SHOW db_name_cond_opt VGROUPS */
   339,  /* (239) cmd ::= SHOW MNODES */
   339,  /* (240) cmd ::= SHOW QNODES */
   339,  /* (241) cmd ::= SHOW FUNCTIONS */
   339,  /* (242) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   339,  /* (243) cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name */
   339,  /* (244) cmd ::= SHOW STREAMS */
   339,  /* (245) cmd ::= SHOW ACCOUNTS */
   339,  /* (246) cmd ::= SHOW APPS */
   339,  /* (247) cmd ::= SHOW CONNECTIONS */
   339,  /* (248) cmd ::= SHOW LICENCES */
   339,  /* (249) cmd ::= SHOW GRANTS */
   339,  /* (250) cmd ::= SHOW CREATE DATABASE db_name */
   339,  /* (251) cmd ::= SHOW CREATE TABLE full_table_name */
   339,  /* (252) cmd ::= SHOW CREATE STABLE full_table_name */
   339,  /* (253) cmd ::= SHOW QUERIES */
   339,  /* (254) cmd ::= SHOW SCORES */
   339,  /* (255) cmd ::= SHOW TOPICS */
   339,  /* (256) cmd ::= SHOW VARIABLES */
   339,  /* (257) cmd ::= SHOW CLUSTER VARIABLES */
   339,  /* (258) cmd ::= SHOW LOCAL VARIABLES */
   339,  /* (259) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   339,  /* (260) cmd ::= SHOW BNODES */
   339,  /* (261) cmd ::= SHOW SNODES */
   339,  /* (262) cmd ::= SHOW CLUSTER */
   339,  /* (263) cmd ::= SHOW TRANSACTIONS */
   339,  /* (264) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   339,  /* (265) cmd ::= SHOW CONSUMERS */
   339,  /* (266) cmd ::= SHOW SUBSCRIPTIONS */
   339,  /* (267) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   339,  /* (268) cmd ::= SHOW TAGS FROM db_name NK_DOT table_name */
   339,  /* (269) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   339,  /* (270) cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name */
   339,  /* (271) cmd ::= SHOW VNODES ON DNODE NK_INTEGER */
   339,  /* (272) cmd ::= SHOW VNODES */
   339,  /* (273) cmd ::= SHOW db_name_cond_opt ALIVE */
   339,  /* (274) cmd ::= SHOW CLUSTER ALIVE */
   396,  /* (275) db_name_cond_opt ::= */
   396,  /* (276) db_name_cond_opt ::= db_name NK_DOT */
   397,  /* (277) like_pattern_opt ::= */
   397,  /* (278) like_pattern_opt ::= LIKE NK_STRING */
   398,  /* (279) table_name_cond ::= table_name */
   399,  /* (280) from_db_opt ::= */
   399,  /* (281) from_db_opt ::= FROM db_name */
   400,  /* (282) tag_list_opt ::= */
   400,  /* (283) tag_list_opt ::= tag_item */
   400,  /* (284) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   401,  /* (285) tag_item ::= TBNAME */
   401,  /* (286) tag_item ::= QTAGS */
   401,  /* (287) tag_item ::= column_name */
   401,  /* (288) tag_item ::= column_name column_alias */
   401,  /* (289) tag_item ::= column_name AS column_alias */
   339,  /* (290) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   339,  /* (291) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   339,  /* (292) cmd ::= DROP INDEX exists_opt full_index_name */
   403,  /* (293) full_index_name ::= index_name */
   403,  /* (294) full_index_name ::= db_name NK_DOT index_name */
   404,  /* (295) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   404,  /* (296) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   406,  /* (297) func_list ::= func */
   406,  /* (298) func_list ::= func_list NK_COMMA func */
   409,  /* (299) func ::= sma_func_name NK_LP expression_list NK_RP */
   410,  /* (300) sma_func_name ::= function_name */
   410,  /* (301) sma_func_name ::= COUNT */
   410,  /* (302) sma_func_name ::= FIRST */
   410,  /* (303) sma_func_name ::= LAST */
   410,  /* (304) sma_func_name ::= LAST_ROW */
   408,  /* (305) sma_stream_opt ::= */
   408,  /* (306) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   408,  /* (307) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   408,  /* (308) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   411,  /* (309) with_meta ::= AS */
   411,  /* (310) with_meta ::= WITH META AS */
   411,  /* (311) with_meta ::= ONLY META AS */
   339,  /* (312) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   339,  /* (313) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name */
   339,  /* (314) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt */
   339,  /* (315) cmd ::= DROP TOPIC exists_opt topic_name */
   339,  /* (316) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   339,  /* (317) cmd ::= DESC full_table_name */
   339,  /* (318) cmd ::= DESCRIBE full_table_name */
   339,  /* (319) cmd ::= RESET QUERY CACHE */
   339,  /* (320) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   339,  /* (321) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   415,  /* (322) analyze_opt ::= */
   415,  /* (323) analyze_opt ::= ANALYZE */
   416,  /* (324) explain_options ::= */
   416,  /* (325) explain_options ::= explain_options VERBOSE NK_BOOL */
   416,  /* (326) explain_options ::= explain_options RATIO NK_FLOAT */
   339,  /* (327) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   339,  /* (328) cmd ::= DROP FUNCTION exists_opt function_name */
   419,  /* (329) agg_func_opt ::= */
   419,  /* (330) agg_func_opt ::= AGGREGATE */
   420,  /* (331) bufsize_opt ::= */
   420,  /* (332) bufsize_opt ::= BUFSIZE NK_INTEGER */
   421,  /* (333) language_opt ::= */
   421,  /* (334) language_opt ::= LANGUAGE NK_STRING */
   418,  /* (335) or_replace_opt ::= */
   418,  /* (336) or_replace_opt ::= OR REPLACE */
   339,  /* (337) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   339,  /* (338) cmd ::= DROP STREAM exists_opt stream_name */
   339,  /* (339) cmd ::= PAUSE STREAM exists_opt stream_name */
   339,  /* (340) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
   424,  /* (341) col_list_opt ::= */
   424,  /* (342) col_list_opt ::= NK_LP col_name_list NK_RP */
   425,  /* (343) tag_def_or_ref_opt ::= */
   425,  /* (344) tag_def_or_ref_opt ::= tags_def */
   425,  /* (345) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   423,  /* (346) stream_options ::= */
   423,  /* (347) stream_options ::= stream_options TRIGGER AT_ONCE */
   423,  /* (348) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   423,  /* (349) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   423,  /* (350) stream_options ::= stream_options WATERMARK duration_literal */
   423,  /* (351) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   423,  /* (352) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   423,  /* (353) stream_options ::= stream_options DELETE_MARK duration_literal */
   423,  /* (354) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   426,  /* (355) subtable_opt ::= */
   426,  /* (356) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   427,  /* (357) ignore_opt ::= */
   427,  /* (358) ignore_opt ::= IGNORE UNTREATED */
   339,  /* (359) cmd ::= KILL CONNECTION NK_INTEGER */
   339,  /* (360) cmd ::= KILL QUERY NK_STRING */
   339,  /* (361) cmd ::= KILL TRANSACTION NK_INTEGER */
   339,  /* (362) cmd ::= BALANCE VGROUP */
   339,  /* (363) cmd ::= BALANCE VGROUP LEADER */
   339,  /* (364) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   339,  /* (365) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   339,  /* (366) cmd ::= SPLIT VGROUP NK_INTEGER */
   429,  /* (367) dnode_list ::= DNODE NK_INTEGER */
   429,  /* (368) dnode_list ::= dnode_list DNODE NK_INTEGER */
   339,  /* (369) cmd ::= DELETE FROM full_table_name where_clause_opt */
   339,  /* (370) cmd ::= query_or_subquery */
   339,  /* (371) cmd ::= insert_query */
   417,  /* (372) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   417,  /* (373) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   342,  /* (374) literal ::= NK_INTEGER */
   342,  /* (375) literal ::= NK_FLOAT */
   342,  /* (376) literal ::= NK_STRING */
   342,  /* (377) literal ::= NK_BOOL */
   342,  /* (378) literal ::= TIMESTAMP NK_STRING */
   342,  /* (379) literal ::= duration_literal */
   342,  /* (380) literal ::= NULL */
   342,  /* (381) literal ::= NK_QUESTION */
   392,  /* (382) duration_literal ::= NK_VARIABLE */
   368,  /* (383) signed ::= NK_INTEGER */
   368,  /* (384) signed ::= NK_PLUS NK_INTEGER */
   368,  /* (385) signed ::= NK_MINUS NK_INTEGER */
   368,  /* (386) signed ::= NK_FLOAT */
   368,  /* (387) signed ::= NK_PLUS NK_FLOAT */
   368,  /* (388) signed ::= NK_MINUS NK_FLOAT */
   382,  /* (389) signed_literal ::= signed */
   382,  /* (390) signed_literal ::= NK_STRING */
   382,  /* (391) signed_literal ::= NK_BOOL */
   382,  /* (392) signed_literal ::= TIMESTAMP NK_STRING */
   382,  /* (393) signed_literal ::= duration_literal */
   382,  /* (394) signed_literal ::= NULL */
   382,  /* (395) signed_literal ::= literal_func */
   382,  /* (396) signed_literal ::= NK_QUESTION */
   431,  /* (397) literal_list ::= signed_literal */
   431,  /* (398) literal_list ::= literal_list NK_COMMA signed_literal */
   351,  /* (399) db_name ::= NK_ID */
   352,  /* (400) table_name ::= NK_ID */
   381,  /* (401) column_name ::= NK_ID */
   394,  /* (402) function_name ::= NK_ID */
   432,  /* (403) table_alias ::= NK_ID */
   402,  /* (404) column_alias ::= NK_ID */
   344,  /* (405) user_name ::= NK_ID */
   353,  /* (406) topic_name ::= NK_ID */
   422,  /* (407) stream_name ::= NK_ID */
   414,  /* (408) cgroup_name ::= NK_ID */
   405,  /* (409) index_name ::= NK_ID */
   433,  /* (410) expr_or_subquery ::= expression */
   428,  /* (411) expression ::= literal */
   428,  /* (412) expression ::= pseudo_column */
   428,  /* (413) expression ::= column_reference */
   428,  /* (414) expression ::= function_expression */
   428,  /* (415) expression ::= case_when_expression */
   428,  /* (416) expression ::= NK_LP expression NK_RP */
   428,  /* (417) expression ::= NK_PLUS expr_or_subquery */
   428,  /* (418) expression ::= NK_MINUS expr_or_subquery */
   428,  /* (419) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   428,  /* (420) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   428,  /* (421) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   428,  /* (422) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   428,  /* (423) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   428,  /* (424) expression ::= column_reference NK_ARROW NK_STRING */
   428,  /* (425) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   428,  /* (426) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   385,  /* (427) expression_list ::= expr_or_subquery */
   385,  /* (428) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   435,  /* (429) column_reference ::= column_name */
   435,  /* (430) column_reference ::= table_name NK_DOT column_name */
   434,  /* (431) pseudo_column ::= ROWTS */
   434,  /* (432) pseudo_column ::= TBNAME */
   434,  /* (433) pseudo_column ::= table_name NK_DOT TBNAME */
   434,  /* (434) pseudo_column ::= QSTART */
   434,  /* (435) pseudo_column ::= QEND */
   434,  /* (436) pseudo_column ::= QDURATION */
   434,  /* (437) pseudo_column ::= WSTART */
   434,  /* (438) pseudo_column ::= WEND */
   434,  /* (439) pseudo_column ::= WDURATION */
   434,  /* (440) pseudo_column ::= IROWTS */
   434,  /* (441) pseudo_column ::= ISFILLED */
   434,  /* (442) pseudo_column ::= QTAGS */
   436,  /* (443) function_expression ::= function_name NK_LP expression_list NK_RP */
   436,  /* (444) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   436,  /* (445) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   436,  /* (446) function_expression ::= literal_func */
   430,  /* (447) literal_func ::= noarg_func NK_LP NK_RP */
   430,  /* (448) literal_func ::= NOW */
   440,  /* (449) noarg_func ::= NOW */
   440,  /* (450) noarg_func ::= TODAY */
   440,  /* (451) noarg_func ::= TIMEZONE */
   440,  /* (452) noarg_func ::= DATABASE */
   440,  /* (453) noarg_func ::= CLIENT_VERSION */
   440,  /* (454) noarg_func ::= SERVER_VERSION */
   440,  /* (455) noarg_func ::= SERVER_STATUS */
   440,  /* (456) noarg_func ::= CURRENT_USER */
   440,  /* (457) noarg_func ::= USER */
   438,  /* (458) star_func ::= COUNT */
   438,  /* (459) star_func ::= FIRST */
   438,  /* (460) star_func ::= LAST */
   438,  /* (461) star_func ::= LAST_ROW */
   439,  /* (462) star_func_para_list ::= NK_STAR */
   439,  /* (463) star_func_para_list ::= other_para_list */
   441,  /* (464) other_para_list ::= star_func_para */
   441,  /* (465) other_para_list ::= other_para_list NK_COMMA star_func_para */
   442,  /* (466) star_func_para ::= expr_or_subquery */
   442,  /* (467) star_func_para ::= table_name NK_DOT NK_STAR */
   437,  /* (468) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   437,  /* (469) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   443,  /* (470) when_then_list ::= when_then_expr */
   443,  /* (471) when_then_list ::= when_then_list when_then_expr */
   446,  /* (472) when_then_expr ::= WHEN common_expression THEN common_expression */
   444,  /* (473) case_when_else_opt ::= */
   444,  /* (474) case_when_else_opt ::= ELSE common_expression */
   447,  /* (475) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   447,  /* (476) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   447,  /* (477) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   447,  /* (478) predicate ::= expr_or_subquery IS NULL */
   447,  /* (479) predicate ::= expr_or_subquery IS NOT NULL */
   447,  /* (480) predicate ::= expr_or_subquery in_op in_predicate_value */
   448,  /* (481) compare_op ::= NK_LT */
   448,  /* (482) compare_op ::= NK_GT */
   448,  /* (483) compare_op ::= NK_LE */
   448,  /* (484) compare_op ::= NK_GE */
   448,  /* (485) compare_op ::= NK_NE */
   448,  /* (486) compare_op ::= NK_EQ */
   448,  /* (487) compare_op ::= LIKE */
   448,  /* (488) compare_op ::= NOT LIKE */
   448,  /* (489) compare_op ::= MATCH */
   448,  /* (490) compare_op ::= NMATCH */
   448,  /* (491) compare_op ::= CONTAINS */
   449,  /* (492) in_op ::= IN */
   449,  /* (493) in_op ::= NOT IN */
   450,  /* (494) in_predicate_value ::= NK_LP literal_list NK_RP */
   451,  /* (495) boolean_value_expression ::= boolean_primary */
   451,  /* (496) boolean_value_expression ::= NOT boolean_primary */
   451,  /* (497) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   451,  /* (498) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   452,  /* (499) boolean_primary ::= predicate */
   452,  /* (500) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   445,  /* (501) common_expression ::= expr_or_subquery */
   445,  /* (502) common_expression ::= boolean_value_expression */
   453,  /* (503) from_clause_opt ::= */
   453,  /* (504) from_clause_opt ::= FROM table_reference_list */
   454,  /* (505) table_reference_list ::= table_reference */
   454,  /* (506) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   455,  /* (507) table_reference ::= table_primary */
   455,  /* (508) table_reference ::= joined_table */
   456,  /* (509) table_primary ::= table_name alias_opt */
   456,  /* (510) table_primary ::= db_name NK_DOT table_name alias_opt */
   456,  /* (511) table_primary ::= subquery alias_opt */
   456,  /* (512) table_primary ::= parenthesized_joined_table */
   458,  /* (513) alias_opt ::= */
   458,  /* (514) alias_opt ::= table_alias */
   458,  /* (515) alias_opt ::= AS table_alias */
   460,  /* (516) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   460,  /* (517) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   457,  /* (518) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   461,  /* (519) join_type ::= */
   461,  /* (520) join_type ::= INNER */
   462,  /* (521) query_specification ::= SELECT hint_list tag_mode_opt set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   463,  /* (522) hint_list ::= */
   463,  /* (523) hint_list ::= NK_HINT */
   464,  /* (524) tag_mode_opt ::= */
   464,  /* (525) tag_mode_opt ::= TAGS */
   465,  /* (526) set_quantifier_opt ::= */
   465,  /* (527) set_quantifier_opt ::= DISTINCT */
   465,  /* (528) set_quantifier_opt ::= ALL */
   466,  /* (529) select_list ::= select_item */
   466,  /* (530) select_list ::= select_list NK_COMMA select_item */
   474,  /* (531) select_item ::= NK_STAR */
   474,  /* (532) select_item ::= common_expression */
   474,  /* (533) select_item ::= common_expression column_alias */
   474,  /* (534) select_item ::= common_expression AS column_alias */
   474,  /* (535) select_item ::= table_name NK_DOT NK_STAR */
   413,  /* (536) where_clause_opt ::= */
   413,  /* (537) where_clause_opt ::= WHERE search_condition */
   467,  /* (538) partition_by_clause_opt ::= */
   467,  /* (539) partition_by_clause_opt ::= PARTITION BY partition_list */
   475,  /* (540) partition_list ::= partition_item */
   475,  /* (541) partition_list ::= partition_list NK_COMMA partition_item */
   476,  /* (542) partition_item ::= expr_or_subquery */
   476,  /* (543) partition_item ::= expr_or_subquery column_alias */
   476,  /* (544) partition_item ::= expr_or_subquery AS column_alias */
   471,  /* (545) twindow_clause_opt ::= */
   471,  /* (546) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   471,  /* (547) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   471,  /* (548) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   471,  /* (549) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   471,  /* (550) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   407,  /* (551) sliding_opt ::= */
   407,  /* (552) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   470,  /* (553) fill_opt ::= */
   470,  /* (554) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   470,  /* (555) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   470,  /* (556) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   477,  /* (557) fill_mode ::= NONE */
   477,  /* (558) fill_mode ::= PREV */
   477,  /* (559) fill_mode ::= NULL */
   477,  /* (560) fill_mode ::= NULL_F */
   477,  /* (561) fill_mode ::= LINEAR */
   477,  /* (562) fill_mode ::= NEXT */
   472,  /* (563) group_by_clause_opt ::= */
   472,  /* (564) group_by_clause_opt ::= GROUP BY group_by_list */
   478,  /* (565) group_by_list ::= expr_or_subquery */
   478,  /* (566) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   473,  /* (567) having_clause_opt ::= */
   473,  /* (568) having_clause_opt ::= HAVING search_condition */
   468,  /* (569) range_opt ::= */
   468,  /* (570) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   468,  /* (571) range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
   469,  /* (572) every_opt ::= */
   469,  /* (573) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   479,  /* (574) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   480,  /* (575) query_simple ::= query_specification */
   480,  /* (576) query_simple ::= union_query_expression */
   484,  /* (577) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   484,  /* (578) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   485,  /* (579) query_simple_or_subquery ::= query_simple */
   485,  /* (580) query_simple_or_subquery ::= subquery */
   412,  /* (581) query_or_subquery ::= query_expression */
   412,  /* (582) query_or_subquery ::= subquery */
   481,  /* (583) order_by_clause_opt ::= */
   481,  /* (584) order_by_clause_opt ::= ORDER BY sort_specification_list */
   482,  /* (585) slimit_clause_opt ::= */
   482,  /* (586) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   482,  /* (587) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   482,  /* (588) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   483,  /* (589) limit_clause_opt ::= */
   483,  /* (590) limit_clause_opt ::= LIMIT NK_INTEGER */
   483,  /* (591) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   483,  /* (592) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   459,  /* (593) subquery ::= NK_LP query_expression NK_RP */
   459,  /* (594) subquery ::= NK_LP subquery NK_RP */
   354,  /* (595) search_condition ::= common_expression */
   486,  /* (596) sort_specification_list ::= sort_specification */
   486,  /* (597) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   487,  /* (598) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   488,  /* (599) ordering_specification_opt ::= */
   488,  /* (600) ordering_specification_opt ::= ASC */
   488,  /* (601) ordering_specification_opt ::= DESC */
   489,  /* (602) null_ordering_opt ::= */
   489,  /* (603) null_ordering_opt ::= NULLS FIRST */
   489,  /* (604) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   -4,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   -4,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (57) dnode_endpoint ::= NK_STRING */
   -1,  /* (58) dnode_endpoint ::= NK_ID */
   -1,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (60) force_opt ::= */
   -1,  /* (61) force_opt ::= FORCE */
   -1,  /* (62) unsafe_opt ::= UNSAFE */
   -3,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (78) cmd ::= USE db_name */
   -4,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (80) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (83) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (84) not_exists_opt ::= */
   -2,  /* (85) exists_opt ::= IF EXISTS */
    0,  /* (86) exists_opt ::= */
    0,  /* (87) db_options ::= */
   -3,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options KEEP integer_list */
   -3,  /* (97) db_options ::= db_options KEEP variable_list */
   -3,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (118) alter_db_options ::= alter_db_option */
   -2,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (124) alter_db_option ::= KEEP integer_list */
   -2,  /* (125) alter_db_option ::= KEEP variable_list */
   -2,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (135) integer_list ::= NK_INTEGER */
   -3,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (137) variable_list ::= NK_VARIABLE */
   -3,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (139) retention_list ::= retention */
   -3,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (142) speed_opt ::= */
   -2,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (144) start_opt ::= */
   -3,  /* (145) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (146) start_opt ::= START WITH NK_STRING */
   -4,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (148) end_opt ::= */
   -3,  /* (149) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (150) end_opt ::= END WITH NK_STRING */
   -4,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   -4,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_def */
   -4,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -4,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_def */
   -5,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -4,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_def */
   -4,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   -4,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_def */
   -5,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (169) multi_create_clause ::= create_subtable_clause */
   -2,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (172) multi_drop_clause ::= drop_table_clause */
   -3,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (174) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (175) specific_cols_opt ::= */
   -3,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (177) full_table_name ::= table_name */
   -3,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (179) column_def_list ::= column_def */
   -3,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (181) column_def ::= column_name type_name */
   -4,  /* (182) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (183) type_name ::= BOOL */
   -1,  /* (184) type_name ::= TINYINT */
   -1,  /* (185) type_name ::= SMALLINT */
   -1,  /* (186) type_name ::= INT */
   -1,  /* (187) type_name ::= INTEGER */
   -1,  /* (188) type_name ::= BIGINT */
   -1,  /* (189) type_name ::= FLOAT */
   -1,  /* (190) type_name ::= DOUBLE */
   -4,  /* (191) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (192) type_name ::= TIMESTAMP */
   -4,  /* (193) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (194) type_name ::= TINYINT UNSIGNED */
   -2,  /* (195) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (196) type_name ::= INT UNSIGNED */
   -2,  /* (197) type_name ::= BIGINT UNSIGNED */
   -1,  /* (198) type_name ::= JSON */
   -4,  /* (199) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (200) type_name ::= MEDIUMBLOB */
   -1,  /* (201) type_name ::= BLOB */
   -4,  /* (202) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -4,  /* (203) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   -1,  /* (204) type_name ::= DECIMAL */
   -4,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (206) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (207) tags_def_opt ::= */
   -1,  /* (208) tags_def_opt ::= tags_def */
   -4,  /* (209) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (210) table_options ::= */
   -3,  /* (211) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (212) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (213) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (214) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (215) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (216) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (217) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (218) alter_table_options ::= alter_table_option */
   -2,  /* (219) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (220) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (221) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (222) duration_list ::= duration_literal */
   -3,  /* (223) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (224) rollup_func_list ::= rollup_func_name */
   -3,  /* (225) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (226) rollup_func_name ::= function_name */
   -1,  /* (227) rollup_func_name ::= FIRST */
   -1,  /* (228) rollup_func_name ::= LAST */
   -1,  /* (229) col_name_list ::= col_name */
   -3,  /* (230) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (231) col_name ::= column_name */
   -2,  /* (232) cmd ::= SHOW DNODES */
   -2,  /* (233) cmd ::= SHOW USERS */
   -3,  /* (234) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (235) cmd ::= SHOW DATABASES */
   -4,  /* (236) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (237) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (238) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (239) cmd ::= SHOW MNODES */
   -2,  /* (240) cmd ::= SHOW QNODES */
   -2,  /* (241) cmd ::= SHOW FUNCTIONS */
   -5,  /* (242) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -6,  /* (243) cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name */
   -2,  /* (244) cmd ::= SHOW STREAMS */
   -2,  /* (245) cmd ::= SHOW ACCOUNTS */
   -2,  /* (246) cmd ::= SHOW APPS */
   -2,  /* (247) cmd ::= SHOW CONNECTIONS */
   -2,  /* (248) cmd ::= SHOW LICENCES */
   -2,  /* (249) cmd ::= SHOW GRANTS */
   -4,  /* (250) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (251) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (252) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (253) cmd ::= SHOW QUERIES */
   -2,  /* (254) cmd ::= SHOW SCORES */
   -2,  /* (255) cmd ::= SHOW TOPICS */
   -2,  /* (256) cmd ::= SHOW VARIABLES */
   -3,  /* (257) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (258) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (259) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (260) cmd ::= SHOW BNODES */
   -2,  /* (261) cmd ::= SHOW SNODES */
   -2,  /* (262) cmd ::= SHOW CLUSTER */
   -2,  /* (263) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (264) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (265) cmd ::= SHOW CONSUMERS */
   -2,  /* (266) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (267) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -6,  /* (268) cmd ::= SHOW TAGS FROM db_name NK_DOT table_name */
   -7,  /* (269) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -8,  /* (270) cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name */
   -5,  /* (271) cmd ::= SHOW VNODES ON DNODE NK_INTEGER */
   -2,  /* (272) cmd ::= SHOW VNODES */
   -3,  /* (273) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (274) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (275) db_name_cond_opt ::= */
   -2,  /* (276) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (277) like_pattern_opt ::= */
   -2,  /* (278) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (279) table_name_cond ::= table_name */
    0,  /* (280) from_db_opt ::= */
   -2,  /* (281) from_db_opt ::= FROM db_name */
    0,  /* (282) tag_list_opt ::= */
   -1,  /* (283) tag_list_opt ::= tag_item */
   -3,  /* (284) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (285) tag_item ::= TBNAME */
   -1,  /* (286) tag_item ::= QTAGS */
   -1,  /* (287) tag_item ::= column_name */
   -2,  /* (288) tag_item ::= column_name column_alias */
   -3,  /* (289) tag_item ::= column_name AS column_alias */
   -8,  /* (290) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (291) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (292) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (293) full_index_name ::= index_name */
   -3,  /* (294) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (295) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (296) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (297) func_list ::= func */
   -3,  /* (298) func_list ::= func_list NK_COMMA func */
   -4,  /* (299) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (300) sma_func_name ::= function_name */
   -1,  /* (301) sma_func_name ::= COUNT */
   -1,  /* (302) sma_func_name ::= FIRST */
   -1,  /* (303) sma_func_name ::= LAST */
   -1,  /* (304) sma_func_name ::= LAST_ROW */
    0,  /* (305) sma_stream_opt ::= */
   -3,  /* (306) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (307) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (308) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -1,  /* (309) with_meta ::= AS */
   -3,  /* (310) with_meta ::= WITH META AS */
   -3,  /* (311) with_meta ::= ONLY META AS */
   -6,  /* (312) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (313) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name */
   -8,  /* (314) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt */
   -4,  /* (315) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (316) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (317) cmd ::= DESC full_table_name */
   -2,  /* (318) cmd ::= DESCRIBE full_table_name */
   -3,  /* (319) cmd ::= RESET QUERY CACHE */
   -4,  /* (320) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (321) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (322) analyze_opt ::= */
   -1,  /* (323) analyze_opt ::= ANALYZE */
    0,  /* (324) explain_options ::= */
   -3,  /* (325) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (326) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (327) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (328) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (329) agg_func_opt ::= */
   -1,  /* (330) agg_func_opt ::= AGGREGATE */
    0,  /* (331) bufsize_opt ::= */
   -2,  /* (332) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (333) language_opt ::= */
   -2,  /* (334) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (335) or_replace_opt ::= */
   -2,  /* (336) or_replace_opt ::= OR REPLACE */
  -12,  /* (337) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (338) cmd ::= DROP STREAM exists_opt stream_name */
   -4,  /* (339) cmd ::= PAUSE STREAM exists_opt stream_name */
   -5,  /* (340) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
    0,  /* (341) col_list_opt ::= */
   -3,  /* (342) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (343) tag_def_or_ref_opt ::= */
   -1,  /* (344) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (345) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (346) stream_options ::= */
   -3,  /* (347) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (348) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (349) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (350) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (351) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (352) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (353) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (354) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (355) subtable_opt ::= */
   -4,  /* (356) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
    0,  /* (357) ignore_opt ::= */
   -2,  /* (358) ignore_opt ::= IGNORE UNTREATED */
   -3,  /* (359) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (360) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (361) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (362) cmd ::= BALANCE VGROUP */
   -3,  /* (363) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (364) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (365) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (366) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (367) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (368) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (369) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (370) cmd ::= query_or_subquery */
   -1,  /* (371) cmd ::= insert_query */
   -7,  /* (372) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (373) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (374) literal ::= NK_INTEGER */
   -1,  /* (375) literal ::= NK_FLOAT */
   -1,  /* (376) literal ::= NK_STRING */
   -1,  /* (377) literal ::= NK_BOOL */
   -2,  /* (378) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (379) literal ::= duration_literal */
   -1,  /* (380) literal ::= NULL */
   -1,  /* (381) literal ::= NK_QUESTION */
   -1,  /* (382) duration_literal ::= NK_VARIABLE */
   -1,  /* (383) signed ::= NK_INTEGER */
   -2,  /* (384) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (385) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (386) signed ::= NK_FLOAT */
   -2,  /* (387) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (388) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (389) signed_literal ::= signed */
   -1,  /* (390) signed_literal ::= NK_STRING */
   -1,  /* (391) signed_literal ::= NK_BOOL */
   -2,  /* (392) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (393) signed_literal ::= duration_literal */
   -1,  /* (394) signed_literal ::= NULL */
   -1,  /* (395) signed_literal ::= literal_func */
   -1,  /* (396) signed_literal ::= NK_QUESTION */
   -1,  /* (397) literal_list ::= signed_literal */
   -3,  /* (398) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (399) db_name ::= NK_ID */
   -1,  /* (400) table_name ::= NK_ID */
   -1,  /* (401) column_name ::= NK_ID */
   -1,  /* (402) function_name ::= NK_ID */
   -1,  /* (403) table_alias ::= NK_ID */
   -1,  /* (404) column_alias ::= NK_ID */
   -1,  /* (405) user_name ::= NK_ID */
   -1,  /* (406) topic_name ::= NK_ID */
   -1,  /* (407) stream_name ::= NK_ID */
   -1,  /* (408) cgroup_name ::= NK_ID */
   -1,  /* (409) index_name ::= NK_ID */
   -1,  /* (410) expr_or_subquery ::= expression */
   -1,  /* (411) expression ::= literal */
   -1,  /* (412) expression ::= pseudo_column */
   -1,  /* (413) expression ::= column_reference */
   -1,  /* (414) expression ::= function_expression */
   -1,  /* (415) expression ::= case_when_expression */
   -3,  /* (416) expression ::= NK_LP expression NK_RP */
   -2,  /* (417) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (418) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (419) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (420) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (421) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (422) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (423) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (424) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (425) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (426) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (427) expression_list ::= expr_or_subquery */
   -3,  /* (428) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (429) column_reference ::= column_name */
   -3,  /* (430) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (431) pseudo_column ::= ROWTS */
   -1,  /* (432) pseudo_column ::= TBNAME */
   -3,  /* (433) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (434) pseudo_column ::= QSTART */
   -1,  /* (435) pseudo_column ::= QEND */
   -1,  /* (436) pseudo_column ::= QDURATION */
   -1,  /* (437) pseudo_column ::= WSTART */
   -1,  /* (438) pseudo_column ::= WEND */
   -1,  /* (439) pseudo_column ::= WDURATION */
   -1,  /* (440) pseudo_column ::= IROWTS */
   -1,  /* (441) pseudo_column ::= ISFILLED */
   -1,  /* (442) pseudo_column ::= QTAGS */
   -4,  /* (443) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (444) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (445) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (446) function_expression ::= literal_func */
   -3,  /* (447) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (448) literal_func ::= NOW */
   -1,  /* (449) noarg_func ::= NOW */
   -1,  /* (450) noarg_func ::= TODAY */
   -1,  /* (451) noarg_func ::= TIMEZONE */
   -1,  /* (452) noarg_func ::= DATABASE */
   -1,  /* (453) noarg_func ::= CLIENT_VERSION */
   -1,  /* (454) noarg_func ::= SERVER_VERSION */
   -1,  /* (455) noarg_func ::= SERVER_STATUS */
   -1,  /* (456) noarg_func ::= CURRENT_USER */
   -1,  /* (457) noarg_func ::= USER */
   -1,  /* (458) star_func ::= COUNT */
   -1,  /* (459) star_func ::= FIRST */
   -1,  /* (460) star_func ::= LAST */
   -1,  /* (461) star_func ::= LAST_ROW */
   -1,  /* (462) star_func_para_list ::= NK_STAR */
   -1,  /* (463) star_func_para_list ::= other_para_list */
   -1,  /* (464) other_para_list ::= star_func_para */
   -3,  /* (465) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (466) star_func_para ::= expr_or_subquery */
   -3,  /* (467) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (468) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (469) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (470) when_then_list ::= when_then_expr */
   -2,  /* (471) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (472) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (473) case_when_else_opt ::= */
   -2,  /* (474) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (475) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (476) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (477) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (478) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (479) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (480) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (481) compare_op ::= NK_LT */
   -1,  /* (482) compare_op ::= NK_GT */
   -1,  /* (483) compare_op ::= NK_LE */
   -1,  /* (484) compare_op ::= NK_GE */
   -1,  /* (485) compare_op ::= NK_NE */
   -1,  /* (486) compare_op ::= NK_EQ */
   -1,  /* (487) compare_op ::= LIKE */
   -2,  /* (488) compare_op ::= NOT LIKE */
   -1,  /* (489) compare_op ::= MATCH */
   -1,  /* (490) compare_op ::= NMATCH */
   -1,  /* (491) compare_op ::= CONTAINS */
   -1,  /* (492) in_op ::= IN */
   -2,  /* (493) in_op ::= NOT IN */
   -3,  /* (494) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (495) boolean_value_expression ::= boolean_primary */
   -2,  /* (496) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (497) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (498) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (499) boolean_primary ::= predicate */
   -3,  /* (500) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (501) common_expression ::= expr_or_subquery */
   -1,  /* (502) common_expression ::= boolean_value_expression */
    0,  /* (503) from_clause_opt ::= */
   -2,  /* (504) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (505) table_reference_list ::= table_reference */
   -3,  /* (506) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (507) table_reference ::= table_primary */
   -1,  /* (508) table_reference ::= joined_table */
   -2,  /* (509) table_primary ::= table_name alias_opt */
   -4,  /* (510) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (511) table_primary ::= subquery alias_opt */
   -1,  /* (512) table_primary ::= parenthesized_joined_table */
    0,  /* (513) alias_opt ::= */
   -1,  /* (514) alias_opt ::= table_alias */
   -2,  /* (515) alias_opt ::= AS table_alias */
   -3,  /* (516) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (517) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (518) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (519) join_type ::= */
   -1,  /* (520) join_type ::= INNER */
  -14,  /* (521) query_specification ::= SELECT hint_list tag_mode_opt set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (522) hint_list ::= */
   -1,  /* (523) hint_list ::= NK_HINT */
    0,  /* (524) tag_mode_opt ::= */
   -1,  /* (525) tag_mode_opt ::= TAGS */
    0,  /* (526) set_quantifier_opt ::= */
   -1,  /* (527) set_quantifier_opt ::= DISTINCT */
   -1,  /* (528) set_quantifier_opt ::= ALL */
   -1,  /* (529) select_list ::= select_item */
   -3,  /* (530) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (531) select_item ::= NK_STAR */
   -1,  /* (532) select_item ::= common_expression */
   -2,  /* (533) select_item ::= common_expression column_alias */
   -3,  /* (534) select_item ::= common_expression AS column_alias */
   -3,  /* (535) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (536) where_clause_opt ::= */
   -2,  /* (537) where_clause_opt ::= WHERE search_condition */
    0,  /* (538) partition_by_clause_opt ::= */
   -3,  /* (539) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (540) partition_list ::= partition_item */
   -3,  /* (541) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (542) partition_item ::= expr_or_subquery */
   -2,  /* (543) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (544) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (545) twindow_clause_opt ::= */
   -6,  /* (546) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (547) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (548) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (549) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (550) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (551) sliding_opt ::= */
   -4,  /* (552) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (553) fill_opt ::= */
   -4,  /* (554) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (555) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (556) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (557) fill_mode ::= NONE */
   -1,  /* (558) fill_mode ::= PREV */
   -1,  /* (559) fill_mode ::= NULL */
   -1,  /* (560) fill_mode ::= NULL_F */
   -1,  /* (561) fill_mode ::= LINEAR */
   -1,  /* (562) fill_mode ::= NEXT */
    0,  /* (563) group_by_clause_opt ::= */
   -3,  /* (564) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (565) group_by_list ::= expr_or_subquery */
   -3,  /* (566) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (567) having_clause_opt ::= */
   -2,  /* (568) having_clause_opt ::= HAVING search_condition */
    0,  /* (569) range_opt ::= */
   -6,  /* (570) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   -4,  /* (571) range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
    0,  /* (572) every_opt ::= */
   -4,  /* (573) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (574) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (575) query_simple ::= query_specification */
   -1,  /* (576) query_simple ::= union_query_expression */
   -4,  /* (577) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (578) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (579) query_simple_or_subquery ::= query_simple */
   -1,  /* (580) query_simple_or_subquery ::= subquery */
   -1,  /* (581) query_or_subquery ::= query_expression */
   -1,  /* (582) query_or_subquery ::= subquery */
    0,  /* (583) order_by_clause_opt ::= */
   -3,  /* (584) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (585) slimit_clause_opt ::= */
   -2,  /* (586) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (587) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (588) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (589) limit_clause_opt ::= */
   -2,  /* (590) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (591) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (592) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (593) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (594) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (595) search_condition ::= common_expression */
   -1,  /* (596) sort_specification_list ::= sort_specification */
   -3,  /* (597) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (598) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (599) ordering_specification_opt ::= */
   -1,  /* (600) ordering_specification_opt ::= ASC */
   -1,  /* (601) ordering_specification_opt ::= DESC */
    0,  /* (602) null_ordering_opt ::= */
   -2,  /* (603) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (604) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,340,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,341,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,340,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,342,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,343,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,341,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,343,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,342,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy169, &yymsp[-1].minor.yy0, yymsp[0].minor.yy243); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy169, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy169, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy169, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy169); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy243 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy243 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy949, &yymsp[-3].minor.yy637, &yymsp[0].minor.yy169, yymsp[-2].minor.yy952); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy949, &yymsp[-3].minor.yy637, &yymsp[0].minor.yy169, yymsp[-2].minor.yy952); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy949 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy949 = yymsp[0].minor.yy949; }
  yymsp[0].minor.yy949 = yylhsminor.yy949;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy949 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy949 = yymsp[-2].minor.yy949 | yymsp[0].minor.yy949; }
  yymsp[-2].minor.yy949 = yylhsminor.yy949;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy949 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy949 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy637.first = yymsp[-2].minor.yy0; yylhsminor.yy637.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy637 = yylhsminor.yy637;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy637.first = yymsp[-2].minor.yy169; yylhsminor.yy637.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy637 = yylhsminor.yy637;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy637.first = yymsp[-2].minor.yy169; yylhsminor.yy637.second = yymsp[0].minor.yy169; }
  yymsp[-2].minor.yy637 = yylhsminor.yy637;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy637.first = yymsp[0].minor.yy169; yylhsminor.yy637.second = nil_token; }
  yymsp[0].minor.yy637 = yylhsminor.yy637;
        break;
      case 44: /* with_opt ::= */
      case 144: /* start_opt ::= */ yytestcase(yyruleno==144);
      case 148: /* end_opt ::= */ yytestcase(yyruleno==148);
      case 277: /* like_pattern_opt ::= */ yytestcase(yyruleno==277);
      case 355: /* subtable_opt ::= */ yytestcase(yyruleno==355);
      case 473: /* case_when_else_opt ::= */ yytestcase(yyruleno==473);
      case 503: /* from_clause_opt ::= */ yytestcase(yyruleno==503);
      case 536: /* where_clause_opt ::= */ yytestcase(yyruleno==536);
      case 545: /* twindow_clause_opt ::= */ yytestcase(yyruleno==545);
      case 551: /* sliding_opt ::= */ yytestcase(yyruleno==551);
      case 553: /* fill_opt ::= */ yytestcase(yyruleno==553);
      case 567: /* having_clause_opt ::= */ yytestcase(yyruleno==567);
      case 569: /* range_opt ::= */ yytestcase(yyruleno==569);
      case 572: /* every_opt ::= */ yytestcase(yyruleno==572);
      case 585: /* slimit_clause_opt ::= */ yytestcase(yyruleno==585);
      case 589: /* limit_clause_opt ::= */ yytestcase(yyruleno==589);
{ yymsp[1].minor.yy952 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 504: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==504);
      case 537: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==537);
      case 568: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==568);
{ yymsp[-1].minor.yy952 = yymsp[0].minor.yy952; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy169, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy957, false); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy169, yymsp[0].minor.yy957, false); }
        break;
      case 50: /* cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, false, yymsp[0].minor.yy957); }
        break;
      case 51: /* cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy169, false, yymsp[0].minor.yy957); }
        break;
      case 52: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= RESTORE DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* dnode_endpoint ::= NK_STRING */
      case 58: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==58);
      case 59: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==59);
      case 301: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==301);
      case 302: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==302);
      case 303: /* sma_func_name ::= LAST */ yytestcase(yyruleno==303);
      case 304: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==304);
      case 399: /* db_name ::= NK_ID */ yytestcase(yyruleno==399);
      case 400: /* table_name ::= NK_ID */ yytestcase(yyruleno==400);
      case 401: /* column_name ::= NK_ID */ yytestcase(yyruleno==401);
      case 402: /* function_name ::= NK_ID */ yytestcase(yyruleno==402);
      case 403: /* table_alias ::= NK_ID */ yytestcase(yyruleno==403);
      case 404: /* column_alias ::= NK_ID */ yytestcase(yyruleno==404);
      case 405: /* user_name ::= NK_ID */ yytestcase(yyruleno==405);
      case 406: /* topic_name ::= NK_ID */ yytestcase(yyruleno==406);
      case 407: /* stream_name ::= NK_ID */ yytestcase(yyruleno==407);
      case 408: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==408);
      case 409: /* index_name ::= NK_ID */ yytestcase(yyruleno==409);
      case 449: /* noarg_func ::= NOW */ yytestcase(yyruleno==449);
      case 450: /* noarg_func ::= TODAY */ yytestcase(yyruleno==450);
      case 451: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==451);
      case 452: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==452);
      case 453: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==453);
      case 454: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==454);
      case 455: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==455);
      case 456: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==456);
      case 457: /* noarg_func ::= USER */ yytestcase(yyruleno==457);
      case 458: /* star_func ::= COUNT */ yytestcase(yyruleno==458);
      case 459: /* star_func ::= FIRST */ yytestcase(yyruleno==459);
      case 460: /* star_func ::= LAST */ yytestcase(yyruleno==460);
      case 461: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==461);
{ yylhsminor.yy169 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy169 = yylhsminor.yy169;
        break;
      case 60: /* force_opt ::= */
      case 84: /* not_exists_opt ::= */ yytestcase(yyruleno==84);
      case 86: /* exists_opt ::= */ yytestcase(yyruleno==86);
      case 322: /* analyze_opt ::= */ yytestcase(yyruleno==322);
      case 329: /* agg_func_opt ::= */ yytestcase(yyruleno==329);
      case 335: /* or_replace_opt ::= */ yytestcase(yyruleno==335);
      case 357: /* ignore_opt ::= */ yytestcase(yyruleno==357);
      case 524: /* tag_mode_opt ::= */ yytestcase(yyruleno==524);
      case 526: /* set_quantifier_opt ::= */ yytestcase(yyruleno==526);
{ yymsp[1].minor.yy957 = false; }
        break;
      case 61: /* force_opt ::= FORCE */
      case 62: /* unsafe_opt ::= UNSAFE */ yytestcase(yyruleno==62);
      case 323: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==323);
      case 330: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==330);
      case 525: /* tag_mode_opt ::= TAGS */ yytestcase(yyruleno==525);
      case 527: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==527);
{ yymsp[0].minor.yy957 = true; }
        break;
      case 63: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 64: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 70: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 71: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 72: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 73: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 74: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 75: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 76: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy957, &yymsp[-1].minor.yy169, yymsp[0].minor.yy952); }
        break;
      case 77: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy957, &yymsp[0].minor.yy169); }
        break;
      case 78: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy169); }
        break;
      case 79: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy169, yymsp[0].minor.yy952); }
        break;
      case 80: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy169); }
        break;
      case 81: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy169, yymsp[0].minor.yy480); }
        break;
      case 82: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy169, yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 83: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy957 = true; }
        break;
      case 85: /* exists_opt ::= IF EXISTS */
      case 336: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==336);
      case 358: /* ignore_opt ::= IGNORE UNTREATED */ yytestcase(yyruleno==358);
{ yymsp[-1].minor.yy957 = true; }
        break;
      case 87: /* db_options ::= */
{ yymsp[1].minor.yy952 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 88: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 89: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 90: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 91: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 92: /* db_options ::= db_options DURATION NK_INTEGER */
      case 93: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==93);
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 94: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 95: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 96: /* db_options ::= db_options KEEP integer_list */
      case 97: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==97);
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_KEEP, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 98: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 99: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 100: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 101: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 102: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 103: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 104: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 105: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_RETENTIONS, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 106: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 107: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 108: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 110: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-3].minor.yy952, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 111: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 112: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-3].minor.yy952, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 113: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 114: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 115: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 116: /* db_options ::= db_options TABLE_PREFIX signed */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy952); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 117: /* db_options ::= db_options TABLE_SUFFIX signed */
{ yylhsminor.yy952 = setDatabaseOption(pCxt, yymsp[-2].minor.yy952, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy952); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 118: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy952 = createAlterDatabaseOptions(pCxt); yylhsminor.yy952 = setAlterDatabaseOption(pCxt, yylhsminor.yy952, &yymsp[0].minor.yy25); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 119: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy952 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy952, &yymsp[0].minor.yy25); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 120: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy25.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= KEEP integer_list */
      case 125: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==125);
{ yymsp[-1].minor.yy25.type = DB_OPTION_KEEP; yymsp[-1].minor.yy25.pList = yymsp[0].minor.yy824; }
        break;
      case 126: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_PAGES; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 128: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_WAL; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 129: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 130: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 132: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy25.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy25.val = t;
                                                                                  }
        break;
      case 133: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 134: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy25.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy25.val = t;
                                                                                  }
        break;
      case 135: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy824 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 136: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 368: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==368);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 137: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy824 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 138: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 139: /* retention_list ::= retention */
      case 169: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==169);
      case 172: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==172);
      case 179: /* column_def_list ::= column_def */ yytestcase(yyruleno==179);
      case 224: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==224);
      case 229: /* col_name_list ::= col_name */ yytestcase(yyruleno==229);
      case 283: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==283);
      case 297: /* func_list ::= func */ yytestcase(yyruleno==297);
      case 397: /* literal_list ::= signed_literal */ yytestcase(yyruleno==397);
      case 464: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==464);
      case 470: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==470);
      case 529: /* select_list ::= select_item */ yytestcase(yyruleno==529);
      case 540: /* partition_list ::= partition_item */ yytestcase(yyruleno==540);
      case 596: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==596);
{ yylhsminor.yy824 = createNodeList(pCxt, yymsp[0].minor.yy952); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 140: /* retention_list ::= retention_list NK_COMMA retention */
      case 173: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==173);
      case 180: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==180);
      case 225: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==225);
      case 230: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==230);
      case 284: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==284);
      case 298: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==298);
      case 398: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==398);
      case 465: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==465);
      case 530: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==530);
      case 541: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==541);
      case 597: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==597);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, yymsp[0].minor.yy952); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 141: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy952 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 142: /* speed_opt ::= */
      case 331: /* bufsize_opt ::= */ yytestcase(yyruleno==331);
{ yymsp[1].minor.yy480 = 0; }
        break;
      case 143: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 332: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==332);
{ yymsp[-1].minor.yy480 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 145: /* start_opt ::= START WITH NK_INTEGER */
      case 149: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==149);
{ yymsp[-2].minor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 146: /* start_opt ::= START WITH NK_STRING */
      case 150: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==150);
{ yymsp[-2].minor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 147: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 151: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==151);
{ yymsp[-3].minor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 152: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 154: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==154);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy957, yymsp[-5].minor.yy952, yymsp[-3].minor.yy824, yymsp[-1].minor.yy824, yymsp[0].minor.yy952); }
        break;
      case 153: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy824); }
        break;
      case 155: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy824); }
        break;
      case 156: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy957, yymsp[0].minor.yy952); }
        break;
      case 157: /* cmd ::= ALTER TABLE alter_table_clause */
      case 370: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==370);
      case 371: /* cmd ::= insert_query */ yytestcase(yyruleno==371);
{ pCxt->pRootNode = yymsp[0].minor.yy952; }
        break;
      case 158: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy952); }
        break;
      case 159: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy952 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 160: /* alter_table_clause ::= full_table_name ADD COLUMN column_def */
{ yylhsminor.yy952 = createAlterTableAddModifyCol(pCxt, yymsp[-3].minor.yy952, TSDB_ALTER_TABLE_ADD_COLUMN, yymsp[0].minor.yy952); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 161: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy952 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy952, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy169); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 162: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_def */
{ yylhsminor.yy952 = createAlterTableAddModifyCol(pCxt, yymsp[-3].minor.yy952, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, yymsp[0].minor.yy952); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 163: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy952 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy952, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy169, &yymsp[0].minor.yy169); }
  yymsp[-4].minor.yy952 = yylhsminor.yy952;
        break;
      case 164: /* alter_table_clause ::= full_table_name ADD TAG column_def */
{ yylhsminor.yy952 = createAlterTableAddModifyCol(pCxt, yymsp[-3].minor.yy952, TSDB_ALTER_TABLE_ADD_TAG, yymsp[0].minor.yy952); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 165: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy952 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy952, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy169); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 166: /* alter_table_clause ::= full_table_name MODIFY TAG column_def */
{ yylhsminor.yy952 = createAlterTableAddModifyCol(pCxt, yymsp[-3].minor.yy952, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, yymsp[0].minor.yy952); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 167: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy952 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy952, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy169, &yymsp[0].minor.yy169); }
  yymsp[-4].minor.yy952 = yylhsminor.yy952;
        break;
      case 168: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy952 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy952, &yymsp[-2].minor.yy169, yymsp[0].minor.yy952); }
  yymsp[-5].minor.yy952 = yylhsminor.yy952;
        break;
      case 170: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 471: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==471);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-1].minor.yy824, yymsp[0].minor.yy952); }
  yymsp[-1].minor.yy824 = yylhsminor.yy824;
        break;
      case 171: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy952 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy957, yymsp[-8].minor.yy952, yymsp[-6].minor.yy952, yymsp[-5].minor.yy824, yymsp[-2].minor.yy824, yymsp[0].minor.yy952); }
  yymsp[-9].minor.yy952 = yylhsminor.yy952;
        break;
      case 174: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy952 = createDropTableClause(pCxt, yymsp[-1].minor.yy957, yymsp[0].minor.yy952); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 175: /* specific_cols_opt ::= */
      case 207: /* tags_def_opt ::= */ yytestcase(yyruleno==207);
      case 282: /* tag_list_opt ::= */ yytestcase(yyruleno==282);
      case 341: /* col_list_opt ::= */ yytestcase(yyruleno==341);
      case 343: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==343);
      case 538: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==538);
      case 563: /* group_by_clause_opt ::= */ yytestcase(yyruleno==563);
      case 583: /* order_by_clause_opt ::= */ yytestcase(yyruleno==583);
{ yymsp[1].minor.yy824 = NULL; }
        break;
      case 176: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 342: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==342);
{ yymsp[-2].minor.yy824 = yymsp[-1].minor.yy824; }
        break;
      case 177: /* full_table_name ::= table_name */
{ yylhsminor.yy952 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy169, NULL); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 178: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy952 = createRealTableNode(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy169, NULL); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 181: /* column_def ::= column_name type_name */
{ yylhsminor.yy952 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy169, yymsp[0].minor.yy84, NULL); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 182: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy952 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy169, yymsp[-2].minor.yy84, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 183: /* type_name ::= BOOL */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 184: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 185: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 186: /* type_name ::= INT */
      case 187: /* type_name ::= INTEGER */ yytestcase(yyruleno==187);
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 188: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 189: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 190: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 191: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 192: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 193: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 194: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 195: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 196: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 197: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 198: /* type_name ::= JSON */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 199: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 200: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 201: /* type_name ::= BLOB */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 202: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 203: /* type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_GEOMETRY, &yymsp[-1].minor.yy0); }
        break;
      case 204: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 205: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 206: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy84 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 208: /* tags_def_opt ::= tags_def */
      case 344: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==344);
      case 463: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==463);
{ yylhsminor.yy824 = yymsp[0].minor.yy824; }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 209: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 345: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==345);
{ yymsp[-3].minor.yy824 = yymsp[-1].minor.yy824; }
        break;
      case 210: /* table_options ::= */
{ yymsp[1].minor.yy952 = createDefaultTableOptions(pCxt); }
        break;
      case 211: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-2].minor.yy952, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 212: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-2].minor.yy952, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 213: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-2].minor.yy952, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 214: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-4].minor.yy952, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy824); }
  yymsp[-4].minor.yy952 = yylhsminor.yy952;
        break;
      case 215: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-2].minor.yy952, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 216: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-4].minor.yy952, TABLE_OPTION_SMA, yymsp[-1].minor.yy824); }
  yymsp[-4].minor.yy952 = yylhsminor.yy952;
        break;
      case 217: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-2].minor.yy952, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 218: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy952 = createAlterTableOptions(pCxt); yylhsminor.yy952 = setTableOption(pCxt, yylhsminor.yy952, yymsp[0].minor.yy25.type, &yymsp[0].minor.yy25.val); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 219: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy952 = setTableOption(pCxt, yymsp[-1].minor.yy952, yymsp[0].minor.yy25.type, &yymsp[0].minor.yy25.val); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 220: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy25.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 221: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy25.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 222: /* duration_list ::= duration_literal */
      case 427: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==427);
{ yylhsminor.yy824 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy952)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 223: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 428: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==428);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, releaseRawExprNode(pCxt, yymsp[0].minor.yy952)); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 226: /* rollup_func_name ::= function_name */
{ yylhsminor.yy952 = createFunctionNode(pCxt, &yymsp[0].minor.yy169, NULL); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 227: /* rollup_func_name ::= FIRST */
      case 228: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==228);
      case 286: /* tag_item ::= QTAGS */ yytestcase(yyruleno==286);
{ yylhsminor.yy952 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 231: /* col_name ::= column_name */
      case 287: /* tag_item ::= column_name */ yytestcase(yyruleno==287);
{ yylhsminor.yy952 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy169); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 232: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 233: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 234: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 235: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 236: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy952, yymsp[0].minor.yy952, OP_TYPE_LIKE); }
        break;
      case 237: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy952, yymsp[0].minor.yy952, OP_TYPE_LIKE); }
        break;
      case 238: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy952, NULL, OP_TYPE_LIKE); }
        break;
      case 239: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 240: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 241: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy952, yymsp[-1].minor.yy952, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, createIdentifierValueNode(pCxt, &yymsp[-2].minor.yy169), createIdentifierValueNode(pCxt, &yymsp[0].minor.yy169), OP_TYPE_EQUAL); }
        break;
      case 244: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 245: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 246: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 247: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 248: /* cmd ::= SHOW LICENCES */
      case 249: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==249);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 250: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy169); }
        break;
      case 251: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy952); }
        break;
      case 252: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy952); }
        break;
      case 253: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 254: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 255: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 256: /* cmd ::= SHOW VARIABLES */
      case 257: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==257);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 258: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 259: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy952); }
        break;
      case 260: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 261: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 262: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 263: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 264: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy952); }
        break;
      case 265: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 266: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 267: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy952, yymsp[-1].minor.yy952, OP_TYPE_EQUAL); }
        break;
      case 268: /* cmd ::= SHOW TAGS FROM db_name NK_DOT table_name */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, createIdentifierValueNode(pCxt, &yymsp[-2].minor.yy169), createIdentifierValueNode(pCxt, &yymsp[0].minor.yy169), OP_TYPE_EQUAL); }
        break;
      case 269: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy952, yymsp[0].minor.yy952, yymsp[-3].minor.yy824); }
        break;
      case 270: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, createIdentifierValueNode(pCxt, &yymsp[0].minor.yy169), createIdentifierValueNode(pCxt, &yymsp[-2].minor.yy169), yymsp[-4].minor.yy824); }
        break;
      case 271: /* cmd ::= SHOW VNODES ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 272: /* cmd ::= SHOW VNODES */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, NULL); }
        break;
      case 273: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy952,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 274: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 275: /* db_name_cond_opt ::= */
      case 280: /* from_db_opt ::= */ yytestcase(yyruleno==280);
{ yymsp[1].minor.yy952 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 276: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy952 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy169); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 278: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 279: /* table_name_cond ::= table_name */
{ yylhsminor.yy952 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy169); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 281: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy952 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy169); }
        break;
      case 285: /* tag_item ::= TBNAME */
{ yylhsminor.yy952 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 288: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy952 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy169), &yymsp[0].minor.yy169); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 289: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy952 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy169), &yymsp[0].minor.yy169); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 290: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy957, yymsp[-3].minor.yy952, yymsp[-1].minor.yy952, NULL, yymsp[0].minor.yy952); }
        break;
      case 291: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy957, yymsp[-5].minor.yy952, yymsp[-3].minor.yy952, yymsp[-1].minor.yy824, NULL); }
        break;
      case 292: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy957, yymsp[0].minor.yy952); }
        break;
      case 293: /* full_index_name ::= index_name */
{ yylhsminor.yy952 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy169); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 294: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy952 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy169); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 295: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy952 = createIndexOption(pCxt, yymsp[-7].minor.yy824, releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), NULL, yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 296: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy952 = createIndexOption(pCxt, yymsp[-9].minor.yy824, releaseRawExprNode(pCxt, yymsp[-5].minor.yy952), releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 299: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy952 = createFunctionNode(pCxt, &yymsp[-3].minor.yy169, yymsp[-1].minor.yy824); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 300: /* sma_func_name ::= function_name */
      case 514: /* alias_opt ::= table_alias */ yytestcase(yyruleno==514);
{ yylhsminor.yy169 = yymsp[0].minor.yy169; }
  yymsp[0].minor.yy169 = yylhsminor.yy169;
        break;
      case 305: /* sma_stream_opt ::= */
      case 346: /* stream_options ::= */ yytestcase(yyruleno==346);
{ yymsp[1].minor.yy952 = createStreamOptions(pCxt); }
        break;
      case 306: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy952)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy952); yylhsminor.yy952 = yymsp[-2].minor.yy952; }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 307: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy952)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy952); yylhsminor.yy952 = yymsp[-2].minor.yy952; }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 308: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy952)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy952); yylhsminor.yy952 = yymsp[-2].minor.yy952; }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 309: /* with_meta ::= AS */
{ yymsp[0].minor.yy480 = 0; }
        break;
      case 310: /* with_meta ::= WITH META AS */
{ yymsp[-2].minor.yy480 = 1; }
        break;
      case 311: /* with_meta ::= ONLY META AS */
{ yymsp[-2].minor.yy480 = 2; }
        break;
      case 312: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy957, &yymsp[-2].minor.yy169, yymsp[0].minor.yy952); }
        break;
      case 313: /* cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy957, &yymsp[-3].minor.yy169, &yymsp[0].minor.yy169, yymsp[-2].minor.yy480); }
        break;
      case 314: /* cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-5].minor.yy957, &yymsp[-4].minor.yy169, yymsp[-1].minor.yy952, yymsp[-3].minor.yy480, yymsp[0].minor.yy952); }
        break;
      case 315: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy957, &yymsp[0].minor.yy169); }
        break;
      case 316: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy957, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy169); }
        break;
      case 317: /* cmd ::= DESC full_table_name */
      case 318: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==318);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy952); }
        break;
      case 319: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 320: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 321: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==321);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy957, yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 324: /* explain_options ::= */
{ yymsp[1].minor.yy952 = createDefaultExplainOptions(pCxt); }
        break;
      case 325: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy952 = setExplainVerbose(pCxt, yymsp[-2].minor.yy952, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 326: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy952 = setExplainRatio(pCxt, yymsp[-2].minor.yy952, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 327: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy957, yymsp[-9].minor.yy957, &yymsp[-6].minor.yy169, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy84, yymsp[-1].minor.yy480, &yymsp[0].minor.yy169, yymsp[-10].minor.yy957); }
        break;
      case 328: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy957, &yymsp[0].minor.yy169); }
        break;
      case 333: /* language_opt ::= */
{ yymsp[1].minor.yy169 = nil_token; }
        break;
      case 334: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy169 = yymsp[0].minor.yy0; }
        break;
      case 337: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy957, &yymsp[-8].minor.yy169, yymsp[-5].minor.yy952, yymsp[-7].minor.yy952, yymsp[-3].minor.yy824, yymsp[-2].minor.yy952, yymsp[0].minor.yy952, yymsp[-4].minor.yy824); }
        break;
      case 338: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy957, &yymsp[0].minor.yy169); }
        break;
      case 339: /* cmd ::= PAUSE STREAM exists_opt stream_name */
{ pCxt->pRootNode = createPauseStreamStmt(pCxt, yymsp[-1].minor.yy957, &yymsp[0].minor.yy169); }
        break;
      case 340: /* cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
{ pCxt->pRootNode = createResumeStreamStmt(pCxt, yymsp[-2].minor.yy957, yymsp[-1].minor.yy957, &yymsp[0].minor.yy169); }
        break;
      case 347: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 348: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==348);
{ yylhsminor.yy952 = setStreamOptions(pCxt, yymsp[-2].minor.yy952, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 349: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy952 = setStreamOptions(pCxt, yymsp[-3].minor.yy952, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy952)); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 350: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy952 = setStreamOptions(pCxt, yymsp[-2].minor.yy952, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy952)); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 351: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy952 = setStreamOptions(pCxt, yymsp[-3].minor.yy952, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 352: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy952 = setStreamOptions(pCxt, yymsp[-2].minor.yy952, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 353: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy952 = setStreamOptions(pCxt, yymsp[-2].minor.yy952, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy952)); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 354: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy952 = setStreamOptions(pCxt, yymsp[-3].minor.yy952, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 356: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 552: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==552);
      case 573: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==573);
{ yymsp[-3].minor.yy952 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy952); }
        break;
      case 359: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 360: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 361: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 362: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 363: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 364: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 365: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy824); }
        break;
      case 366: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 367: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy824 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 369: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 372: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy952 = createInsertStmt(pCxt, yymsp[-4].minor.yy952, yymsp[-2].minor.yy824, yymsp[0].minor.yy952); }
        break;
      case 373: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy952 = createInsertStmt(pCxt, yymsp[-1].minor.yy952, NULL, yymsp[0].minor.yy952); }
        break;
      case 374: /* literal ::= NK_INTEGER */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 375: /* literal ::= NK_FLOAT */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 376: /* literal ::= NK_STRING */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 377: /* literal ::= NK_BOOL */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 378: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 379: /* literal ::= duration_literal */
      case 389: /* signed_literal ::= signed */ yytestcase(yyruleno==389);
      case 410: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==410);
      case 411: /* expression ::= literal */ yytestcase(yyruleno==411);
      case 412: /* expression ::= pseudo_column */ yytestcase(yyruleno==412);
      case 413: /* expression ::= column_reference */ yytestcase(yyruleno==413);
      case 414: /* expression ::= function_expression */ yytestcase(yyruleno==414);
      case 415: /* expression ::= case_when_expression */ yytestcase(yyruleno==415);
      case 446: /* function_expression ::= literal_func */ yytestcase(yyruleno==446);
      case 495: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==495);
      case 499: /* boolean_primary ::= predicate */ yytestcase(yyruleno==499);
      case 501: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==501);
      case 502: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==502);
      case 505: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==505);
      case 507: /* table_reference ::= table_primary */ yytestcase(yyruleno==507);
      case 508: /* table_reference ::= joined_table */ yytestcase(yyruleno==508);
      case 512: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==512);
      case 575: /* query_simple ::= query_specification */ yytestcase(yyruleno==575);
      case 576: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==576);
      case 579: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==579);
      case 581: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==581);
{ yylhsminor.yy952 = yymsp[0].minor.yy952; }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 380: /* literal ::= NULL */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 381: /* literal ::= NK_QUESTION */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 382: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 383: /* signed ::= NK_INTEGER */
{ yylhsminor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 384: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 385: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 386: /* signed ::= NK_FLOAT */
{ yylhsminor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 387: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 388: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 390: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 391: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 392: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 393: /* signed_literal ::= duration_literal */
      case 395: /* signed_literal ::= literal_func */ yytestcase(yyruleno==395);
      case 466: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==466);
      case 532: /* select_item ::= common_expression */ yytestcase(yyruleno==532);
      case 542: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==542);
      case 580: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==580);
      case 582: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==582);
      case 595: /* search_condition ::= common_expression */ yytestcase(yyruleno==595);
{ yylhsminor.yy952 = releaseRawExprNode(pCxt, yymsp[0].minor.yy952); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 394: /* signed_literal ::= NULL */
{ yylhsminor.yy952 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 396: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy952 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 416: /* expression ::= NK_LP expression NK_RP */
      case 500: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==500);
      case 594: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==594);
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy952)); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 417: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy952));
                                                                                  }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 418: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy952), NULL));
                                                                                  }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 419: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952))); 
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 420: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952))); 
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 421: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952))); 
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 422: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952))); 
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 423: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 424: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 425: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 426: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 429: /* column_reference ::= column_name */
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy169, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy169)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 430: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy169, createColumnNode(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy169)); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 431: /* pseudo_column ::= ROWTS */
      case 432: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==432);
      case 434: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==434);
      case 435: /* pseudo_column ::= QEND */ yytestcase(yyruleno==435);
      case 436: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==436);
      case 437: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==437);
      case 438: /* pseudo_column ::= WEND */ yytestcase(yyruleno==438);
      case 439: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==439);
      case 440: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==440);
      case 441: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==441);
      case 442: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==442);
      case 448: /* literal_func ::= NOW */ yytestcase(yyruleno==448);
{ yylhsminor.yy952 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 433: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy169)))); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 443: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 444: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==444);
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy169, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy169, yymsp[-1].minor.yy824)); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 445: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), yymsp[-1].minor.yy84)); }
  yymsp[-5].minor.yy952 = yylhsminor.yy952;
        break;
      case 447: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy169, NULL)); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 462: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy824 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 467: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 535: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==535);
{ yylhsminor.yy952 = createColumnNode(pCxt, &yymsp[-2].minor.yy169, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 468: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy824, yymsp[-1].minor.yy952)); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 469: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), yymsp[-2].minor.yy824, yymsp[-1].minor.yy952)); }
  yymsp[-4].minor.yy952 = yylhsminor.yy952;
        break;
      case 472: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy952 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)); }
        break;
      case 474: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy952 = releaseRawExprNode(pCxt, yymsp[0].minor.yy952); }
        break;
      case 475: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 480: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==480);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy520, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 476: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy952), releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-4].minor.yy952 = yylhsminor.yy952;
        break;
      case 477: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy952), releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-5].minor.yy952 = yylhsminor.yy952;
        break;
      case 478: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), NULL));
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 479: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), NULL));
                                                                                  }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 481: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy520 = OP_TYPE_LOWER_THAN; }
        break;
      case 482: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy520 = OP_TYPE_GREATER_THAN; }
        break;
      case 483: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy520 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 484: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy520 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 485: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy520 = OP_TYPE_NOT_EQUAL; }
        break;
      case 486: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy520 = OP_TYPE_EQUAL; }
        break;
      case 487: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy520 = OP_TYPE_LIKE; }
        break;
      case 488: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy520 = OP_TYPE_NOT_LIKE; }
        break;
      case 489: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy520 = OP_TYPE_MATCH; }
        break;
      case 490: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy520 = OP_TYPE_NMATCH; }
        break;
      case 491: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy520 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 492: /* in_op ::= IN */
{ yymsp[0].minor.yy520 = OP_TYPE_IN; }
        break;
      case 493: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy520 = OP_TYPE_NOT_IN; }
        break;
      case 494: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy824)); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 496: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy952), NULL));
                                                                                  }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 497: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 498: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy952);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy952);
                                                                                    yylhsminor.yy952 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), releaseRawExprNode(pCxt, yymsp[0].minor.yy952)));
                                                                                  }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 506: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy952 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy952, yymsp[0].minor.yy952, NULL); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 509: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy952 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy169, &yymsp[0].minor.yy169); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 510: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy952 = createRealTableNode(pCxt, &yymsp[-3].minor.yy169, &yymsp[-1].minor.yy169, &yymsp[0].minor.yy169); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 511: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy952 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy952), &yymsp[0].minor.yy169); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 513: /* alias_opt ::= */
{ yymsp[1].minor.yy169 = nil_token;  }
        break;
      case 515: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy169 = yymsp[0].minor.yy169; }
        break;
      case 516: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 517: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==517);
{ yymsp[-2].minor.yy952 = yymsp[-1].minor.yy952; }
        break;
      case 518: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy952 = createJoinTableNode(pCxt, yymsp[-4].minor.yy932, yymsp[-5].minor.yy952, yymsp[-2].minor.yy952, yymsp[0].minor.yy952); }
  yymsp[-5].minor.yy952 = yylhsminor.yy952;
        break;
      case 519: /* join_type ::= */
{ yymsp[1].minor.yy932 = JOIN_TYPE_INNER; }
        break;
      case 520: /* join_type ::= INNER */
{ yymsp[0].minor.yy932 = JOIN_TYPE_INNER; }
        break;
      case 521: /* query_specification ::= SELECT hint_list tag_mode_opt set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{
                                                                                    yymsp[-13].minor.yy952 = createSelectStmt(pCxt, yymsp[-10].minor.yy957, yymsp[-9].minor.yy824, yymsp[-8].minor.yy952, yymsp[-12].minor.yy824);
                                                                                    yymsp[-13].minor.yy952 = setSelectStmtTagMode(pCxt, yymsp[-13].minor.yy952, yymsp[-11].minor.yy957);
                                                                                    yymsp[-13].minor.yy952 = addWhereClause(pCxt, yymsp[-13].minor.yy952, yymsp[-7].minor.yy952);
                                                                                    yymsp[-13].minor.yy952 = addPartitionByClause(pCxt, yymsp[-13].minor.yy952, yymsp[-6].minor.yy824);
                                                                                    yymsp[-13].minor.yy952 = addWindowClauseClause(pCxt, yymsp[-13].minor.yy952, yymsp[-2].minor.yy952);
                                                                                    yymsp[-13].minor.yy952 = addGroupByClause(pCxt, yymsp[-13].minor.yy952, yymsp[-1].minor.yy824);
                                                                                    yymsp[-13].minor.yy952 = addHavingClause(pCxt, yymsp[-13].minor.yy952, yymsp[0].minor.yy952);
                                                                                    yymsp[-13].minor.yy952 = addRangeClause(pCxt, yymsp[-13].minor.yy952, yymsp[-5].minor.yy952);
                                                                                    yymsp[-13].minor.yy952 = addEveryClause(pCxt, yymsp[-13].minor.yy952, yymsp[-4].minor.yy952);
                                                                                    yymsp[-13].minor.yy952 = addFillClause(pCxt, yymsp[-13].minor.yy952, yymsp[-3].minor.yy952);
                                                                                  }
        break;
      case 522: /* hint_list ::= */
{ yymsp[1].minor.yy824 = createHintNodeList(pCxt, NULL); }
        break;
      case 523: /* hint_list ::= NK_HINT */
{ yylhsminor.yy824 = createHintNodeList(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 528: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy957 = false; }
        break;
      case 531: /* select_item ::= NK_STAR */
{ yylhsminor.yy952 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy952 = yylhsminor.yy952;
        break;
      case 533: /* select_item ::= common_expression column_alias */
      case 543: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==543);
{ yylhsminor.yy952 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy952), &yymsp[0].minor.yy169); }
  yymsp[-1].minor.yy952 = yylhsminor.yy952;
        break;
      case 534: /* select_item ::= common_expression AS column_alias */
      case 544: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==544);
{ yylhsminor.yy952 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), &yymsp[0].minor.yy169); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 539: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 564: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==564);
      case 584: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==584);
{ yymsp[-2].minor.yy824 = yymsp[0].minor.yy824; }
        break;
      case 546: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy952 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), releaseRawExprNode(pCxt, yymsp[-1].minor.yy952)); }
        break;
      case 547: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy952 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy952)); }
        break;
      case 548: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy952 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), NULL, yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 549: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy952 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy952), releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), yymsp[-1].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 550: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy952 = createEventWindowNode(pCxt, yymsp[-3].minor.yy952, yymsp[0].minor.yy952); }
        break;
      case 554: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy952 = createFillNode(pCxt, yymsp[-1].minor.yy214, NULL); }
        break;
      case 555: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy952 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy824)); }
        break;
      case 556: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy952 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy824)); }
        break;
      case 557: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy214 = FILL_MODE_NONE; }
        break;
      case 558: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy214 = FILL_MODE_PREV; }
        break;
      case 559: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy214 = FILL_MODE_NULL; }
        break;
      case 560: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy214 = FILL_MODE_NULL_F; }
        break;
      case 561: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy214 = FILL_MODE_LINEAR; }
        break;
      case 562: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy214 = FILL_MODE_NEXT; }
        break;
      case 565: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy824 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy952))); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 566: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy952))); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 570: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy952 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy952), releaseRawExprNode(pCxt, yymsp[-1].minor.yy952)); }
        break;
      case 571: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy952 = createInterpTimePoint(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy952)); }
        break;
      case 574: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy952 = addOrderByClause(pCxt, yymsp[-3].minor.yy952, yymsp[-2].minor.yy824);
                                                                                    yylhsminor.yy952 = addSlimitClause(pCxt, yylhsminor.yy952, yymsp[-1].minor.yy952);
                                                                                    yylhsminor.yy952 = addLimitClause(pCxt, yylhsminor.yy952, yymsp[0].minor.yy952);
                                                                                  }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 577: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy952 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy952, yymsp[0].minor.yy952); }
  yymsp[-3].minor.yy952 = yylhsminor.yy952;
        break;
      case 578: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy952 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy952, yymsp[0].minor.yy952); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 586: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 590: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==590);
{ yymsp[-1].minor.yy952 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 587: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 591: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==591);
{ yymsp[-3].minor.yy952 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 588: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 592: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==592);
{ yymsp[-3].minor.yy952 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 593: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy952 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy952); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 598: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy952 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy952), yymsp[-1].minor.yy498, yymsp[0].minor.yy977); }
  yymsp[-2].minor.yy952 = yylhsminor.yy952;
        break;
      case 599: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy498 = ORDER_ASC; }
        break;
      case 600: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy498 = ORDER_ASC; }
        break;
      case 601: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy498 = ORDER_DESC; }
        break;
      case 602: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy977 = NULL_ORDER_DEFAULT; }
        break;
      case 603: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy977 = NULL_ORDER_FIRST; }
        break;
      case 604: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy977 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
