/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 334
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy29;
  EJoinType yy164;
  ENullOrder yy209;
  SDataType yy388;
  EOperatorType yy416;
  SNode* yy456;
  SToken yy537;
  EOrder yy626;
  SNodeList* yy632;
  EFillMode yy646;
  bool yy649;
  int32_t yy652;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             568
#define YYNRULE              433
#define YYNTOKEN             220
#define YY_MAX_SHIFT         567
#define YY_MIN_SHIFTREDUCE   843
#define YY_MAX_SHIFTREDUCE   1275
#define YY_ERROR_ACTION      1276
#define YY_ACCEPT_ACTION     1277
#define YY_NO_ACTION         1278
#define YY_MIN_REDUCE        1279
#define YY_MAX_REDUCE        1711
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1863)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1390, 1690, 1388, 1563,  268,   26,  203,  323,  482, 1277,
 /*    10 */   469, 1549,   33,   31, 1689, 1563, 1492,   77, 1688, 1302,
 /*    20 */   277, 1549, 1096,  285,  380, 1545, 1552, 1579,   34,   32,
 /*    30 */    30,   29,   28, 1399,  466, 1545, 1551,  248, 1094, 1579,
 /*    40 */  1549,  481,   53,  417,  465, 1535,  466,  441, 1535, 1301,
 /*    50 */    12,   33,   31, 1218, 1545, 1551,  465, 1102,  481,  277,
 /*    60 */  1535, 1096,  293, 1395, 1535,  445,  125, 1564,  468, 1566,
 /*    70 */  1567,  464,  104,  459,    1,  482,  359, 1094,   72, 1564,
 /*    80 */   468, 1566, 1567,  464,  321,  459, 1377,  418, 1629,   12,
 /*    90 */   482, 1232,  249, 1625, 1535,   36, 1102,  564,   62,   77,
 /*   100 */  1399, 1690,   33,   31, 1690,  123,  387, 1291,  102, 1095,
 /*   110 */   277, 1704, 1096,    1,  136, 1399, 1375,  136, 1688, 1392,
 /*   120 */    22, 1688,  443,  132, 1636, 1637, 1690, 1641, 1094, 1280,
 /*   130 */    34,   32,   30,   29,   28,  359,  564, 1331, 1448,  136,
 /*   140 */    12, 1117,  481, 1688,  267, 1579, 1097, 1102, 1095, 1446,
 /*   150 */    87,  127,  466,   86,   85,   84,   83,   82,   81,   80,
 /*   160 */    79,   78, 1440,  469,    1,  518,  280, 1100, 1101, 1491,
 /*   170 */  1145, 1146, 1147, 1148, 1149, 1150, 1151,  461, 1156, 1157,
 /*   180 */  1158, 1159, 1160, 1161, 1162, 1097,  434,  564,  431,  395,
 /*   190 */   316,  389,  315,  560,  559,  394,   36,  137,  101, 1095,
 /*   200 */   390,  388,  137,  391,   55,  266, 1100, 1101,  174, 1145,
 /*   210 */  1146, 1147, 1148, 1149, 1150, 1151,  461, 1156, 1157, 1158,
 /*   220 */  1159, 1160, 1161, 1162,  482,  482,  482,  441,  482,  931,
 /*   230 */    33,   31,  452,  322,  330,  331, 1097,  358,  277,  880,
 /*   240 */  1096,  879,  137,   34,   32,   30,   29,   28,  933, 1399,
 /*   250 */  1399, 1399,  104, 1399,  436,  432, 1094, 1100, 1101,  881,
 /*   260 */  1145, 1146, 1147, 1148, 1149, 1150, 1151,  461, 1156, 1157,
 /*   270 */  1158, 1159, 1160, 1161, 1162, 1102,   33,   31, 1163,  385,
 /*   280 */   384,  250,  345,  143,  277, 1300, 1096, 1328,  102,  521,
 /*   290 */    87, 1371,    7,   86,   85,   84,   83,   82,   81,   80,
 /*   300 */    79,   78, 1094,  133, 1636, 1637, 1132, 1641,  281,   51,
 /*   310 */  1119,  395,   50,  389, 1180,  564,  121,  394,  137,  137,
 /*   320 */   101, 1102,  390,  388, 1401,  391, 1242, 1095,  147,  146,
 /*   330 */  1535,  317,  260,   34,   32,   30,   29,   28,    7,  540,
 /*   340 */   539,  538,  537,  292,  879,  536,  535,  534,  107,  529,
 /*   350 */   528,  527,  526,  525,  524,  523,  522,  114,  100,   53,
 /*   360 */   378,  564,  383, 1181, 1097,  428, 1240, 1241, 1243, 1244,
 /*   370 */  1690,  124,   99, 1095,  261, 1357,  259,  258,  453,  382,
 /*   380 */  1394, 1186,  435,  136,  386, 1100, 1101, 1688, 1145, 1146,
 /*   390 */  1147, 1148, 1149, 1150, 1151,  461, 1156, 1157, 1158, 1159,
 /*   400 */  1160, 1161, 1162,  441,   33,   31,  393,  392,  441,  532,
 /*   410 */  1097, 1120,  277,  311, 1096,  137,   25,  275, 1175, 1176,
 /*   420 */  1177, 1178, 1179, 1183, 1184, 1185,  515,  514,  104,  456,
 /*   430 */  1094, 1100, 1101,  104, 1145, 1146, 1147, 1148, 1149, 1150,
 /*   440 */  1151,  461, 1156, 1157, 1158, 1159, 1160, 1161, 1162, 1102,
 /*   450 */    33,   31,  445,  482,  409,  287,   69, 1096,  277,  120,
 /*   460 */  1096, 1448, 1396,  121,  102, 1121,    7,  282,  905,  102,
 /*   470 */   105, 1401, 1446, 1094,    9,    8, 1094, 1391, 1399,  134,
 /*   480 */  1636, 1637,  449, 1641,  196, 1636,  440,  906,  439,  564,
 /*   490 */  1376, 1690, 1102, 1690, 1299, 1102,   34,   32,   30,   29,
 /*   500 */    28, 1095, 1318, 1118,  136, 1298,  136,  518, 1688, 1297,
 /*   510 */  1688, 1296,    1,  969,  505,  504,  503,  973,  502,  975,
 /*   520 */   976,  501,  978,  498,  396,  984,  495,  986,  987,  492,
 /*   530 */   489,  247,  564, 1117,  288,  564,  482,  508, 1097, 1535,
 /*   540 */   338, 1482, 1484,  350, 1095, 1516, 1172, 1095, 1194, 1295,
 /*   550 */  1535,  106,  351,  100, 1535,  513, 1535,  383, 1313, 1100,
 /*   560 */  1101, 1399, 1145, 1146, 1147, 1148, 1149, 1150, 1151,  461,
 /*   570 */  1156, 1157, 1158, 1159, 1160, 1161, 1162,  516, 1479,  386,
 /*   580 */   398, 1097,  482,  198, 1097,  145,   34,   32,   30,   29,
 /*   590 */    28,  479,  225, 1448, 1535, 1429,  512,  511,  510,  289,
 /*   600 */   509,  520, 1100, 1101, 1446, 1100, 1101, 1399, 1145, 1146,
 /*   610 */  1147, 1148, 1149, 1150, 1151,  461, 1156, 1157, 1158, 1159,
 /*   620 */  1160, 1161, 1162, 1563,  250,  349,  450, 1294,  344,  343,
 /*   630 */   342,  341,  340, 1384,  337,  336,  335,  334,  333,  329,
 /*   640 */   328,  327,  326,  325,  324,  448,  482, 1579,   34,   32,
 /*   650 */    30,   29,   28,  482,  444,  480,  567, 1180, 1182,  290,
 /*   660 */   482, 1386,  217, 1293,  465,  533,  531,  121, 1535,  291,
 /*   670 */   221, 1399, 1535,   98, 1563, 1401, 1187, 1290, 1399,  556,
 /*   680 */  1289,  552,  548,  544,  220, 1399,   73, 1564,  468, 1566,
 /*   690 */  1567,  464, 1122,  459, 1648, 1213, 1629,    6, 1579, 1643,
 /*   700 */   270, 1625,  131, 1288, 1287,  444, 1181, 1448, 1535, 1286,
 /*   710 */    70,   23, 1285,  215,  199,  465,   24, 1382, 1483, 1535,
 /*   720 */   424, 1656, 1535, 1640, 1186, 1535,   34,   32,   30,   29,
 /*   730 */    28,   30,   29,   28, 1448, 1284, 1217,   73, 1564,  468,
 /*   740 */  1566, 1567,  464,  478,  459, 1447, 1643, 1629, 1535, 1535,
 /*   750 */  1225,  270, 1625,  131, 1535, 1563, 1119, 1535,  400,   25,
 /*   760 */   275, 1175, 1176, 1177, 1178, 1179, 1183, 1184, 1185, 1283,
 /*   770 */  1639,  423, 1657,  408,  180, 1272, 1524, 1311, 1643, 1579,
 /*   780 */  1535,   34,   32,   30,   29,   28,  466,  173, 1168, 1074,
 /*   790 */   403,  176, 1282,  177, 1119,  397,  465,  121,  308,  401,
 /*   800 */  1535,  172, 1638,  165,  167, 1402,  163,  166, 1082, 1083,
 /*   810 */   184, 1563,  300,  169, 1535,  460,  168,  310,   73, 1564,
 /*   820 */   468, 1566, 1567,  464,  507,  459,  171,   45, 1629,  170,
 /*   830 */    44,  416,  270, 1625, 1702, 1579, 1374, 1535,  407, 1292,
 /*   840 */   122, 1563,  466, 1663, 1132,  231,    9,    8, 1358,  112,
 /*   850 */  1213,  405,  465,  420, 1271,  447, 1535,  229,   47,  187,
 /*   860 */  1274, 1275, 1239,  189,   35, 1579,  200, 1441, 1188,   35,
 /*   870 */   148, 1563,  466, 1152,   73, 1564,  468, 1566, 1567,  464,
 /*   880 */  1556,  459,  465,  429, 1629, 1105, 1535,  410,  270, 1625,
 /*   890 */  1702,  377, 1554, 1104,   35, 1579,  193,  106, 1057, 1686,
 /*   900 */    68,  513,  466,  442,   73, 1564,  468, 1566, 1567,  464,
 /*   910 */    64,  459,  465,  206, 1629, 1659, 1535,  208,  270, 1625,
 /*   920 */  1702,  445, 1580,  516,  109,  202, 1563,  110,  474, 1647,
 /*   930 */  1216,  214,    2,   71,  238, 1564,  468, 1566, 1567,  464,
 /*   940 */  1117,  459,  512,  511,  510,  112,  509,   47,  487,  962,
 /*   950 */  1579,  957,  990,  295,  299,  255, 1108,  466, 1066,  222,
 /*   960 */  1690,   49,   48,  320, 1107,  142,  931,  465,  144,  332,
 /*   970 */   314, 1535,  257,  136,  110, 1481, 1563, 1688,  994,  111,
 /*   980 */   339,  112,  256, 1001,  306, 1000,  302,  298,  139,   74,
 /*   990 */  1564,  468, 1566, 1567,  464,  347,  459,  346,  110, 1629,
 /*  1000 */  1579,  348,  113, 1628, 1625, 1126,  353,  466,  352,  354,
 /*  1010 */  1125,  149,  152,  356,  355, 1124,  357,  465,  360,  137,
 /*  1020 */   160, 1535,  155,  130, 1563,   52,  158, 1123,  379,  376,
 /*  1030 */   381,  372,  368,  364,  159, 1563,   97, 1389,  265,   74,
 /*  1040 */  1564,  468, 1566, 1567,  464, 1102,  459,  162, 1579, 1629,
 /*  1050 */  1520, 1385,  164,  455, 1625,  463,  115,  116, 1387, 1579,
 /*  1060 */    54,  175, 1383,  157,  223,  465,  466,  117,  118, 1535,
 /*  1070 */   411,  419,  415,  412,  179, 1122,  465,  182,  421, 1670,
 /*  1080 */  1535,  422, 1660,  430,  472, 1669,  427,  245, 1564,  468,
 /*  1090 */  1566, 1567,  464,  462,  459,  457, 1601,  185,  125, 1564,
 /*  1100 */   468, 1566, 1567,  464,  188,  459, 1563,  269,  284,  283,
 /*  1110 */     5,  433,  438,  103,  426,    4, 1644, 1121, 1110, 1213,
 /*  1120 */   156, 1650,  151,   37,  153,  271,  451,  454,   16, 1490,
 /*  1130 */  1579, 1489,  195,  470, 1103,  129, 1563,  466,  471, 1610,
 /*  1140 */   194,  150,  446, 1703, 1563,  192,  475,  465,  476,  279,
 /*  1150 */   210, 1535,  477, 1102,  212,   63, 1400,   61,  224, 1687,
 /*  1160 */  1579,  201, 1372, 1705,  226,  219,  563,  466, 1579,   74,
 /*  1170 */  1564,  468, 1566, 1567,  464,  466,  459,  465,  128, 1629,
 /*  1180 */   485, 1535,   43,  232, 1626,  465,  233,  228,  230, 1535,
 /*  1190 */  1529, 1563,  425,  483, 1528,  294, 1525,  296,  297,  241,
 /*  1200 */  1564,  468, 1566, 1567,  464, 1106,  459,  246, 1564,  468,
 /*  1210 */  1566, 1567,  464, 1090,  459, 1579, 1091,  140, 1523,  303,
 /*  1220 */   301,  304,  466,  305, 1522,  307, 1521,  309, 1506,  141,
 /*  1230 */   312,  313,  465, 1069, 1068, 1500, 1535,  437, 1040,  274,
 /*  1240 */  1499, 1563, 1111,  319,  318, 1498, 1497, 1474, 1473, 1472,
 /*  1250 */  1471, 1470, 1469, 1468,  246, 1564,  468, 1566, 1567,  464,
 /*  1260 */  1467,  459, 1466, 1114, 1465, 1579, 1464, 1463, 1462, 1461,
 /*  1270 */  1460, 1459,  463,  108, 1458, 1457, 1456, 1455, 1454, 1563,
 /*  1280 */  1453, 1042,  465, 1452, 1451, 1450, 1535, 1449, 1330, 1514,
 /*  1290 */  1563, 1508, 1496, 1487, 1378,  898, 1329,  154, 1327,  361,
 /*  1300 */   363,  362, 1325, 1579,  245, 1564,  468, 1566, 1567,  464,
 /*  1310 */   466,  459, 1323, 1602, 1579,  367,  371,  365,  366,  369,
 /*  1320 */   465,  466,  370, 1321, 1535, 1310, 1309,  276,  373, 1306,
 /*  1330 */  1380,  465, 1006,  374,  530, 1535,  161, 1009,  278, 1279,
 /*  1340 */  1379,   76,  246, 1564,  468, 1566, 1567,  464, 1563,  459,
 /*  1350 */  1319,  375,  930,  246, 1564,  468, 1566, 1567,  464,  929,
 /*  1360 */   459, 1563,  928,   96,   95,   94,   93,   92,   91,   90,
 /*  1370 */    89,   88, 1579,  927,  532,  924,  923,  262, 1314,  466,
 /*  1380 */   263,  399, 1312,  264,  402, 1579, 1305,  404, 1304,  465,
 /*  1390 */   406,   75,  466, 1535, 1513, 1076, 1507,  413, 1495, 1563,
 /*  1400 */  1494, 1486,  465,  181,    3,   56, 1535,  119, 1563,   13,
 /*  1410 */   126,  234, 1564,  468, 1566, 1567,  464,  190,  459,   35,
 /*  1420 */    41,   14,  186, 1579,  240, 1564,  468, 1566, 1567,  464,
 /*  1430 */   466,  459, 1579,   46, 1238,  191,  178,   20,  414,  466,
 /*  1440 */   465, 1231,   40,   57, 1535,   21, 1563, 1210, 1554,  465,
 /*  1450 */   183, 1209,   39, 1535, 1265,   15,  197,   58, 1260,  135,
 /*  1460 */  1259, 1563,  242, 1564,  468, 1566, 1567,  464,  272,  459,
 /*  1470 */  1579,  235, 1564,  468, 1566, 1567,  464,  466,  459, 1264,
 /*  1480 */  1263,  273,    8, 1173,   17, 1579, 1155,  465,  458,  138,
 /*  1490 */  1154, 1535,  466,   27,  204, 1140, 1153,   10,   18,   19,
 /*  1500 */    38,  467,  465,  205, 1236, 1485, 1535,   11,  207,  243,
 /*  1510 */  1564,  468, 1566, 1567,  464,  211,  459,   64,  209,  473,
 /*  1520 */    59,   60,  213, 1553,  236, 1564,  468, 1566, 1567,  464,
 /*  1530 */  1563,  459, 1112,   42,  216,  484,  991,  486, 1563,  286,
 /*  1540 */   488,  490,  988,  491,  493,  985,  979,  496,  494,  497,
 /*  1550 */   499,  977,  968,  500, 1579,  983,  982,  981,   65,  980,
 /*  1560 */  1003,  466, 1579, 1002,  506,   66,   67,  999, 1563,  466,
 /*  1570 */   996,  465,  896,  517,  937, 1535,  519,  919,  218,  465,
 /*  1580 */   918,  917,  916, 1535,  915,  914,  912,  913,  932,  934,
 /*  1590 */   909,  908, 1579,  244, 1564,  468, 1566, 1567,  464,  466,
 /*  1600 */   459,  237, 1564,  468, 1566, 1567,  464, 1326,  459,  465,
 /*  1610 */   907,  904,  903, 1535,  902,  901, 1563,  541,  542, 1324,
 /*  1620 */  1322,  543,  545,  546,  547,  550,  549, 1320,  551,  553,
 /*  1630 */   554, 1575, 1564,  468, 1566, 1567,  464, 1308,  459,  555,
 /*  1640 */  1579,  557,  558, 1307, 1303,  561,  562,  466, 1098,  566,
 /*  1650 */   227,  565, 1278, 1278, 1563, 1278, 1278,  465, 1278, 1278,
 /*  1660 */  1278, 1535, 1278, 1563, 1278, 1278, 1278, 1278, 1278, 1278,
 /*  1670 */  1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 1579, 1574,
 /*  1680 */  1564,  468, 1566, 1567,  464,  466,  459, 1579, 1278, 1278,
 /*  1690 */  1278, 1278, 1278, 1278,  466,  465, 1278, 1278, 1278, 1535,
 /*  1700 */  1278, 1563, 1278, 1278,  465, 1278, 1278, 1278, 1535, 1278,
 /*  1710 */  1278, 1278, 1278, 1278, 1278, 1278, 1563, 1573, 1564,  468,
 /*  1720 */  1566, 1567,  464, 1278,  459, 1579,  253, 1564,  468, 1566,
 /*  1730 */  1567,  464,  466,  459, 1278, 1278, 1278, 1278, 1278, 1278,
 /*  1740 */  1579, 1278,  465, 1278, 1278, 1278, 1535,  466, 1278, 1278,
 /*  1750 */  1278, 1278, 1278, 1278, 1563, 1278, 1278,  465, 1278, 1278,
 /*  1760 */  1278, 1535, 1278, 1278,  252, 1564,  468, 1566, 1567,  464,
 /*  1770 */  1278,  459, 1278, 1278, 1278, 1278, 1278, 1278, 1579,  254,
 /*  1780 */  1564,  468, 1566, 1567,  464,  466,  459, 1278, 1278, 1278,
 /*  1790 */  1278, 1278, 1563, 1278, 1278,  465, 1278, 1278, 1278, 1535,
 /*  1800 */  1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278,
 /*  1810 */  1278, 1278, 1278, 1278, 1278, 1278, 1579,  251, 1564,  468,
 /*  1820 */  1566, 1567,  464,  466,  459, 1278, 1278, 1278, 1278, 1278,
 /*  1830 */  1278, 1278, 1278,  465, 1278, 1278, 1278, 1535, 1278, 1278,
 /*  1840 */  1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278, 1278,
 /*  1850 */  1278, 1278, 1278, 1278, 1278,  239, 1564,  468, 1566, 1567,
 /*  1860 */   464, 1278,  459,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   223,  312,  248,  223,  251,  297,  298,  229,  229,  220,
 /*    10 */   264,  268,   12,   13,  325,  223,  270,  238,  329,  223,
 /*    20 */    20,  268,   22,  251,  245,  282,  283,  247,   12,   13,
 /*    30 */    14,   15,   16,  254,  254,  282,  283,  259,   38,  247,
 /*    40 */   268,   20,  231,  229,  264,  268,  254,  229,  268,  223,
 /*    50 */    50,   12,   13,   14,  282,  283,  264,   57,   20,   20,
 /*    60 */   268,   22,  273,  252,  268,  273,  286,  287,  288,  289,
 /*    70 */   290,  291,  254,  293,   74,  229,   49,   38,  286,  287,
 /*    80 */   288,  289,  290,  291,  238,  293,    0,  273,  296,   50,
 /*    90 */   229,   75,  300,  301,  268,   74,   57,   97,  228,  238,
 /*   100 */   254,  312,   12,   13,  312,  222,  245,  224,  290,  109,
 /*   110 */    20,  331,   22,   74,  325,  254,    0,  325,  329,  249,
 /*   120 */     2,  329,  304,  305,  306,  307,  312,  309,   38,    0,
 /*   130 */    12,   13,   14,   15,   16,   49,   97,    0,  247,  325,
 /*   140 */    50,   20,   20,  329,  253,  247,  146,   57,  109,  258,
 /*   150 */    21,  246,  254,   24,   25,   26,   27,   28,   29,   30,
 /*   160 */    31,   32,  257,  264,   74,   49,  267,  167,  168,  270,
 /*   170 */   170,  171,  172,  173,  174,  175,  176,  177,  178,  179,
 /*   180 */   180,  181,  182,  183,  184,  146,  288,   97,  136,   52,
 /*   190 */   145,   54,  147,  226,  227,   58,   74,  197,   61,  109,
 /*   200 */    63,   64,  197,   66,  155,  156,  167,  168,  159,  170,
 /*   210 */   171,  172,  173,  174,  175,  176,  177,  178,  179,  180,
 /*   220 */   181,  182,  183,  184,  229,  229,  229,  229,  229,   38,
 /*   230 */    12,   13,   71,  238,  238,  238,  146,  238,   20,   20,
 /*   240 */    22,   22,  197,   12,   13,   14,   15,   16,   57,  254,
 /*   250 */   254,  254,  254,  254,  202,  203,   38,  167,  168,   40,
 /*   260 */   170,  171,  172,  173,  174,  175,  176,  177,  178,  179,
 /*   270 */   180,  181,  182,  183,  184,   57,   12,   13,   14,  233,
 /*   280 */   234,   50,   67,   47,   20,  223,   22,    0,  290,  235,
 /*   290 */    21,  237,   74,   24,   25,   26,   27,   28,   29,   30,
 /*   300 */    31,   32,   38,  305,  306,  307,   75,  309,  239,   73,
 /*   310 */    20,   52,   76,   54,   83,   97,  247,   58,  197,  197,
 /*   320 */    61,   57,   63,   64,  255,   66,  167,  109,  113,  114,
 /*   330 */   268,  273,   35,   12,   13,   14,   15,   16,   74,   52,
 /*   340 */    53,   54,   55,   56,   22,   58,   59,   60,   61,   62,
 /*   350 */    63,   64,   65,   66,   67,   68,   69,   70,   61,  231,
 /*   360 */    38,   97,   65,  132,  146,  206,  207,  208,  209,  210,
 /*   370 */   312,  232,  244,  109,   77,  236,   79,   80,  217,   82,
 /*   380 */   252,  150,   20,  325,   87,  167,  168,  329,  170,  171,
 /*   390 */   172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
 /*   400 */   182,  183,  184,  229,   12,   13,  233,  234,  229,   71,
 /*   410 */   146,   20,   20,   75,   22,  197,  185,  186,  187,  188,
 /*   420 */   189,  190,  191,  192,  193,  194,  233,  234,  254,   50,
 /*   430 */    38,  167,  168,  254,  170,  171,  172,  173,  174,  175,
 /*   440 */   176,  177,  178,  179,  180,  181,  182,  183,  184,   57,
 /*   450 */    12,   13,  273,  229,  273,  239,  228,   22,   20,  138,
 /*   460 */    22,  247,  238,  247,  290,   20,   74,  253,   38,  290,
 /*   470 */   242,  255,  258,   38,    1,    2,   38,  249,  254,  305,
 /*   480 */   306,  307,   71,  309,  305,  306,  307,   57,  309,   97,
 /*   490 */     0,  312,   57,  312,  223,   57,   12,   13,   14,   15,
 /*   500 */    16,  109,    0,   20,  325,  223,  325,   49,  329,  223,
 /*   510 */   329,  223,   74,   88,   89,   90,   91,   92,   93,   94,
 /*   520 */    95,   96,   97,   98,   22,  100,  101,  102,  103,  104,
 /*   530 */   105,   18,   97,   20,  256,   97,  229,   85,  146,  268,
 /*   540 */    27,  263,  264,   30,  109,  238,  167,  109,   75,  223,
 /*   550 */   268,   61,   39,   61,  268,   65,  268,   65,    0,  167,
 /*   560 */   168,  254,  170,  171,  172,  173,  174,  175,  176,  177,
 /*   570 */   178,  179,  180,  181,  182,  183,  184,   87,  254,   87,
 /*   580 */    22,  146,  229,  138,  146,  261,   12,   13,   14,   15,
 /*   590 */    16,  238,  240,  247,  268,  243,  106,  107,  108,  253,
 /*   600 */   110,   57,  167,  168,  258,  167,  168,  254,  170,  171,
 /*   610 */   172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
 /*   620 */   182,  183,  184,  223,   50,  112,  215,  223,  115,  116,
 /*   630 */   117,  118,  119,  248,  121,  122,  123,  124,  125,  126,
 /*   640 */   127,  128,  129,  130,  131,    3,  229,  247,   12,   13,
 /*   650 */    14,   15,   16,  229,  254,  238,   19,   83,  132,  239,
 /*   660 */   229,  248,  238,  223,  264,  233,  234,  247,  268,  238,
 /*   670 */    33,  254,  268,   36,  223,  255,  150,  223,  254,   42,
 /*   680 */   223,   44,   45,   46,   47,  254,  286,  287,  288,  289,
 /*   690 */   290,  291,   20,  293,  195,  196,  296,   43,  247,  284,
 /*   700 */   300,  301,  302,  223,  223,  254,  132,  247,  268,  223,
 /*   710 */    73,  185,  223,   76,  314,  264,    2,  248,  258,  268,
 /*   720 */   320,  321,  268,  308,  150,  268,   12,   13,   14,   15,
 /*   730 */    16,   14,   15,   16,  247,  223,    4,  286,  287,  288,
 /*   740 */   289,  290,  291,  106,  293,  258,  284,  296,  268,  268,
 /*   750 */    14,  300,  301,  302,  268,  223,   20,  268,    4,  185,
 /*   760 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  223,
 /*   770 */   308,  134,  321,   19,  137,  139,    0,    0,  284,  247,
 /*   780 */   268,   12,   13,   14,   15,   16,  254,   33,   14,  152,
 /*   790 */    36,  154,  223,  248,   20,   41,  264,  247,  142,   22,
 /*   800 */   268,   47,  308,   78,   78,  255,   81,   81,  157,  158,
 /*   810 */   138,  223,   36,   78,  268,  248,   81,  161,  286,  287,
 /*   820 */   288,  289,  290,  291,  248,  293,   78,   73,  296,   81,
 /*   830 */    76,  276,  300,  301,  302,  247,    0,  268,   21,  224,
 /*   840 */    18,  223,  254,  311,   75,   23,    1,    2,  236,   71,
 /*   850 */   196,   34,  264,   75,  218,  213,  268,   35,   71,   71,
 /*   860 */   182,  183,   75,   75,   71,  247,  332,  257,   75,   71,
 /*   870 */    48,  223,  254,   75,  286,  287,  288,  289,  290,  291,
 /*   880 */    74,  293,  264,  323,  296,   38,  268,  280,  300,  301,
 /*   890 */   302,  226,   86,   38,   71,  247,  317,   61,   75,  311,
 /*   900 */    74,   65,  254,  310,  286,  287,  288,  289,  290,  291,
 /*   910 */    84,  293,  264,   71,  296,  285,  268,   75,  300,  301,
 /*   920 */   302,  273,  247,   87,   71,  326,  223,   71,   75,  311,
 /*   930 */   198,   75,  313,  111,  286,  287,  288,  289,  290,  291,
 /*   940 */    20,  293,  106,  107,  108,   71,  110,   71,   71,   75,
 /*   950 */   247,   75,   75,  229,   36,  281,  109,  254,  144,  274,
 /*   960 */   312,  139,  140,  141,  109,  143,   38,  264,  120,  229,
 /*   970 */   148,  268,  233,  325,   71,  229,  223,  329,   75,   71,
 /*   980 */   262,   71,  160,   75,  162,   75,  164,  165,  166,  286,
 /*   990 */   287,  288,  289,  290,  291,  132,  293,  260,   71,  296,
 /*  1000 */   247,  260,   75,  300,  301,   20,  278,  254,  229,  264,
 /*  1010 */    20,  231,  231,  254,  272,   20,  265,  264,  229,  197,
 /*  1020 */    33,  268,  231,   36,  223,  231,  231,   20,  225,   42,
 /*  1030 */   247,   44,   45,   46,   47,  223,  229,  247,  225,  286,
 /*  1040 */   287,  288,  289,  290,  291,   57,  293,  247,  247,  296,
 /*  1050 */   268,  247,  247,  300,  301,  254,  247,  247,  247,  247,
 /*  1060 */    73,  228,  247,   76,  278,  264,  254,  247,  247,  268,
 /*  1070 */   153,  272,  264,  277,  228,   20,  264,  228,  254,  322,
 /*  1080 */   268,  265,  285,  205,  204,  322,  268,  286,  287,  288,
 /*  1090 */   289,  290,  291,  292,  293,  294,  295,  269,  286,  287,
 /*  1100 */   288,  289,  290,  291,  269,  293,  223,  268,   12,   13,
 /*  1110 */   212,  268,  211,  254,  200,  199,  284,   20,   22,  196,
 /*  1120 */   133,  319,  135,  120,  137,  219,  214,  216,   74,  269,
 /*  1130 */   247,  269,  303,  268,   38,  316,  223,  254,  268,  299,
 /*  1140 */   315,  154,  330,  331,  223,  318,  135,  264,  266,  268,
 /*  1150 */   254,  268,  265,   57,  228,   74,  254,  228,  243,  328,
 /*  1160 */   247,  327,  237,  333,  229,  228,  225,  254,  247,  286,
 /*  1170 */   287,  288,  289,  290,  291,  254,  293,  264,  279,  296,
 /*  1180 */   250,  268,  275,  241,  301,  264,  241,  230,  221,  268,
 /*  1190 */     0,  223,  271,   97,    0,   64,    0,   38,  163,  286,
 /*  1200 */   287,  288,  289,  290,  291,  109,  293,  286,  287,  288,
 /*  1210 */   289,  290,  291,   38,  293,  247,   38,   38,    0,   38,
 /*  1220 */   163,   38,  254,  163,    0,   38,    0,   38,    0,   74,
 /*  1230 */   150,  149,  264,  109,  146,    0,  268,  324,   86,  271,
 /*  1240 */     0,  223,  146,  142,   53,    0,    0,    0,    0,    0,
 /*  1250 */     0,    0,    0,    0,  286,  287,  288,  289,  290,  291,
 /*  1260 */     0,  293,    0,  167,    0,  247,    0,    0,    0,    0,
 /*  1270 */     0,    0,  254,  120,    0,    0,    0,    0,    0,  223,
 /*  1280 */     0,   22,  264,    0,    0,    0,  268,    0,    0,    0,
 /*  1290 */   223,    0,    0,    0,    0,   51,    0,   43,    0,   38,
 /*  1300 */    43,   36,    0,  247,  286,  287,  288,  289,  290,  291,
 /*  1310 */   254,  293,    0,  295,  247,   43,   43,   38,   36,   38,
 /*  1320 */   264,  254,   36,    0,  268,    0,    0,  271,   38,    0,
 /*  1330 */     0,  264,   22,   36,   71,  268,   81,   38,  271,    0,
 /*  1340 */     0,   83,  286,  287,  288,  289,  290,  291,  223,  293,
 /*  1350 */     0,   43,   38,  286,  287,  288,  289,  290,  291,   38,
 /*  1360 */   293,  223,   38,   24,   25,   26,   27,   28,   29,   30,
 /*  1370 */    31,   32,  247,   38,   71,   38,   38,   22,    0,  254,
 /*  1380 */    22,   39,    0,   22,   38,  247,    0,   22,    0,  264,
 /*  1390 */    22,   20,  254,  268,    0,   38,    0,   22,    0,  223,
 /*  1400 */     0,    0,  264,   43,   71,   74,  268,  151,  223,  201,
 /*  1410 */    74,  286,  287,  288,  289,  290,  291,   74,  293,   71,
 /*  1420 */    71,  201,   75,  247,  286,  287,  288,  289,  290,  291,
 /*  1430 */   254,  293,  247,  138,   75,   71,  135,   74,  138,  254,
 /*  1440 */   264,   75,  138,   74,  268,   71,  223,   75,   86,  264,
 /*  1450 */   133,   75,   71,  268,   75,   71,   86,    4,   38,   86,
 /*  1460 */    38,  223,  286,  287,  288,  289,  290,  291,   38,  293,
 /*  1470 */   247,  286,  287,  288,  289,  290,  291,  254,  293,   38,
 /*  1480 */    38,   38,    2,  167,   71,  247,   75,  264,   74,   86,
 /*  1490 */    75,  268,  254,   74,   86,   22,   75,   74,   74,   74,
 /*  1500 */   195,  169,  264,   75,   75,    0,  268,  201,   74,  286,
 /*  1510 */   287,  288,  289,  290,  291,   43,  293,   84,   74,  136,
 /*  1520 */    74,   74,  133,   86,  286,  287,  288,  289,  290,  291,
 /*  1530 */   223,  293,   22,   74,   86,   85,   75,   38,  223,   38,
 /*  1540 */    74,   38,   75,   74,   38,   75,   75,   38,   74,   74,
 /*  1550 */    38,   75,   22,   74,  247,   99,   99,   99,   74,   99,
 /*  1560 */    38,  254,  247,  109,   87,   74,   74,   38,  223,  254,
 /*  1570 */    22,  264,   51,   50,   57,  268,   72,   38,   71,  264,
 /*  1580 */    38,   38,   38,  268,   38,   38,   22,   38,   38,   57,
 /*  1590 */    38,   38,  247,  286,  287,  288,  289,  290,  291,  254,
 /*  1600 */   293,  286,  287,  288,  289,  290,  291,    0,  293,  264,
 /*  1610 */    38,   38,   38,  268,   38,   38,  223,   38,   36,    0,
 /*  1620 */     0,   43,   38,   36,   43,   36,   38,    0,   43,   38,
 /*  1630 */    36,  286,  287,  288,  289,  290,  291,    0,  293,   43,
 /*  1640 */   247,   38,   37,    0,    0,   22,   21,  254,   22,   20,
 /*  1650 */    22,   21,  334,  334,  223,  334,  334,  264,  334,  334,
 /*  1660 */   334,  268,  334,  223,  334,  334,  334,  334,  334,  334,
 /*  1670 */   334,  334,  334,  334,  334,  334,  334,  334,  247,  286,
 /*  1680 */   287,  288,  289,  290,  291,  254,  293,  247,  334,  334,
 /*  1690 */   334,  334,  334,  334,  254,  264,  334,  334,  334,  268,
 /*  1700 */   334,  223,  334,  334,  264,  334,  334,  334,  268,  334,
 /*  1710 */   334,  334,  334,  334,  334,  334,  223,  286,  287,  288,
 /*  1720 */   289,  290,  291,  334,  293,  247,  286,  287,  288,  289,
 /*  1730 */   290,  291,  254,  293,  334,  334,  334,  334,  334,  334,
 /*  1740 */   247,  334,  264,  334,  334,  334,  268,  254,  334,  334,
 /*  1750 */   334,  334,  334,  334,  223,  334,  334,  264,  334,  334,
 /*  1760 */   334,  268,  334,  334,  286,  287,  288,  289,  290,  291,
 /*  1770 */   334,  293,  334,  334,  334,  334,  334,  334,  247,  286,
 /*  1780 */   287,  288,  289,  290,  291,  254,  293,  334,  334,  334,
 /*  1790 */   334,  334,  223,  334,  334,  264,  334,  334,  334,  268,
 /*  1800 */   334,  334,  334,  334,  334,  334,  334,  334,  334,  334,
 /*  1810 */   334,  334,  334,  334,  334,  334,  247,  286,  287,  288,
 /*  1820 */   289,  290,  291,  254,  293,  334,  334,  334,  334,  334,
 /*  1830 */   334,  334,  334,  264,  334,  334,  334,  268,  334,  334,
 /*  1840 */   334,  334,  334,  334,  334,  334,  334,  334,  334,  334,
 /*  1850 */   334,  334,  334,  334,  334,  286,  287,  288,  289,  290,
 /*  1860 */   291,  334,  293,  334,  334,  334,  334,  334,  334,  334,
 /*  1870 */   334,  334,
};
#define YY_SHIFT_COUNT    (567)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1644)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   822,    0,   39,   90,   90,   90,   90,  218,   90,   90,
 /*    10 */   264,  392,  438,  392,  392,  392,  392,  392,  392,  392,
 /*    20 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
 /*    30 */   392,  392,  392,  392,  392,  392,  122,   21,   21,   21,
 /*    40 */   121, 1096, 1096,   45,   38,   38,    5, 1096,   38,   38,
 /*    50 */    38,   38,   38,   38,   27,   38,  290,  362,    5,  391,
 /*    60 */   290,   38,   38,  290,   38,  290,  391,  290,  290,   38,
 /*    70 */   458,  513,  231,  574,  574,  269,  435,  297,  435,  435,
 /*    80 */   435,  435,  435,  435,  435,  435,  435,  435,  435,  435,
 /*    90 */   435,  435,  435,  435,  435,  435,  435,  259,  219,   86,
 /*   100 */   191,  191,  445,  445,  445,  116,  191,  191,  483,  391,
 /*   110 */   290,  290,  290,  452,  544,  425,  425,  425,  425,  425,
 /*   120 */   425,  425,  637,  129,  137,  636,  159,  492,   49,   52,
 /*   130 */   322,  672,  499,  654,  499,  736,  642,  732,  774,  920,
 /*   140 */   918,  928,  814,  920,  920,  848,  863,  863,  920,  985,
 /*   150 */    27,  391,  990,   27,  483,  995,   27,   27,  920,   27,
 /*   160 */  1007,  290,  290,  290,  290,  290,  290,  290,  290,  290,
 /*   170 */   290,  290,  920, 1007,  988,  985,  458,  917,  391,  990,
 /*   180 */   458,  483,  995,  458, 1055,  878,  880,  988,  878,  880,
 /*   190 */   988,  988,  898,  901,  914,  916,  923,  483, 1097, 1003,
 /*   200 */   906,  911,  912, 1054,  290,  880,  988,  988,  880,  988,
 /*   210 */  1011,  483,  995,  458,  452,  458,  483, 1081,  544,  920,
 /*   220 */   458, 1007, 1863, 1863, 1863, 1863, 1863, 1863,  287,  987,
 /*   230 */  1339,  754,  490,  836,   16,  118,  714,  321,  769,  484,
 /*   240 */   484,  484,  484,  484,  484,  484,  484,  236,  215,  473,
 /*   250 */   526,  717,  717,  717,  717,  776,  656,  338,  725,  726,
 /*   260 */   735,  748,  502,  558,  777,  817,  651,  778,  787,  788,
 /*   270 */   845,  678,  411,  161,  793,  379,  798,  806,  823,  842,
 /*   280 */   853,  856,  874,  847,  855,  876,  877,  903,  908,  910,
 /*   290 */   927,  826,  430, 1190, 1194, 1131, 1196, 1159, 1035, 1175,
 /*   300 */  1178, 1179, 1057, 1218, 1181, 1183, 1060, 1224, 1187, 1226,
 /*   310 */  1189, 1228, 1155, 1080, 1082, 1124, 1088, 1235, 1240, 1191,
 /*   320 */  1101, 1245, 1246, 1152, 1247, 1248, 1249, 1250, 1251, 1252,
 /*   330 */  1253, 1260, 1262, 1264, 1266, 1267, 1268, 1269, 1270, 1271,
 /*   340 */  1153, 1274, 1275, 1276, 1277, 1278, 1280, 1259, 1283, 1284,
 /*   350 */  1285, 1287, 1288, 1289, 1291, 1292, 1293, 1254, 1294, 1244,
 /*   360 */  1296, 1298, 1261, 1265, 1257, 1302, 1279, 1282, 1272, 1312,
 /*   370 */  1281, 1286, 1273, 1323, 1290, 1297, 1308, 1325, 1326, 1329,
 /*   380 */  1330, 1258, 1255, 1299, 1263, 1303, 1310, 1340, 1314, 1321,
 /*   390 */  1324, 1335, 1263, 1303, 1337, 1338, 1350, 1355, 1378, 1358,
 /*   400 */  1342, 1382, 1361, 1346, 1386, 1365, 1388, 1368, 1371, 1394,
 /*   410 */  1295, 1357, 1396, 1256, 1375, 1300, 1301, 1398, 1400, 1304,
 /*   420 */  1401, 1331, 1360, 1317, 1333, 1348, 1208, 1347, 1349, 1359,
 /*   430 */  1336, 1343, 1363, 1366, 1364, 1362, 1369, 1374, 1220, 1372,
 /*   440 */  1376, 1370, 1305, 1381, 1373, 1379, 1384, 1306, 1453, 1420,
 /*   450 */  1422, 1430, 1441, 1442, 1443, 1480, 1316, 1413, 1411, 1414,
 /*   460 */  1415, 1419, 1421, 1403, 1423, 1424, 1408, 1473, 1332, 1425,
 /*   470 */  1428, 1429, 1434, 1444, 1383, 1446, 1505, 1472, 1389, 1447,
 /*   480 */  1433, 1437, 1448, 1510, 1459, 1450, 1461, 1499, 1501, 1466,
 /*   490 */  1467, 1503, 1469, 1470, 1506, 1474, 1471, 1509, 1475, 1476,
 /*   500 */  1512, 1479, 1456, 1457, 1458, 1460, 1530, 1477, 1484, 1522,
 /*   510 */  1454, 1491, 1492, 1529, 1263, 1303, 1548, 1521, 1523, 1517,
 /*   520 */  1504, 1507, 1539, 1542, 1543, 1544, 1546, 1547, 1549, 1564,
 /*   530 */  1532, 1263, 1550, 1303, 1552, 1553, 1572, 1573, 1574, 1576,
 /*   540 */  1577, 1607, 1579, 1582, 1578, 1619, 1584, 1587, 1581, 1620,
 /*   550 */  1588, 1589, 1585, 1627, 1591, 1594, 1596, 1637, 1603, 1605,
 /*   560 */  1643, 1644, 1623, 1625, 1626, 1628, 1630, 1629,
};
#define YY_REDUCE_COUNT (227)
#define YY_REDUCE_MIN   (-311)
#define YY_REDUCE_MAX   (1569)
static const short yy_reduce_ofst[] = {
 /*     0 */  -211, -208,  400,  451,  532,  588,  618,  648,  703,  753,
 /*    10 */   801,  812,  883,  921,  913, -220,  968, 1018, 1056, 1067,
 /*    20 */  1125, 1138, 1176, 1185, 1223, 1238, 1307, 1315, 1345, 1393,
 /*    30 */  1431, 1440, 1478, 1493, 1531, 1569,  179, -182,   -2,  174,
 /*    40 */  -186, -247, -228,   58, -221, -139,  181, -257, -154,   -5,
 /*    50 */    -4,   -3,   -1,  224,  128,  307, -109, -102, -311, -101,
 /*    60 */    69,  353,  417,  214,  424,  216,  278,  346,  420,  431,
 /*    70 */   228, -222, -292, -292, -292, -117, -223,  -95, -204, -174,
 /*    80 */    62,  271,  282,  286,  288,  326,  404,  440,  454,  457,
 /*    90 */   480,  481,  486,  489,  512,  546,  569,  139,  -33, -189,
 /*   100 */    46,  173,  415,  462,  494, -130,  193,  432,  324, -254,
 /*   110 */   550,  460,  487,  352,   54, -246,  385,  413,  469,  545,
 /*   120 */   567,  576,  555,  615,  612,  534,  560,  610,  607,  579,
 /*   130 */   665,  630,  593,  593,  593,  675,  599,  619,  675,  724,
 /*   140 */   674,  739,  685,  740,  746,  718,  737,  741,  779,  728,
 /*   150 */   780,  745,  742,  781,  759,  751,  791,  794,  789,  795,
 /*   160 */   803,  783,  790,  800,  804,  805,  809,  810,  811,  815,
 /*   170 */   820,  821,  807,  813,  782,  786,  833,  796,  808,  799,
 /*   180 */   846,  824,  816,  849,  797,  757,  828,  818,  763,  835,
 /*   190 */   839,  843,  802,  827,  819,  825,  593,  859,  832,  829,
 /*   200 */   830,  831,  834,  840,  675,  860,  865,  870,  862,  881,
 /*   210 */   882,  896,  887,  926,  915,  929,  902,  930,  925,  935,
 /*   220 */   937,  941,  907,  899,  942,  945,  957,  967,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    10 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    20 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    30 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    40 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    50 */  1276, 1276, 1276, 1276, 1335, 1276, 1276, 1276, 1276, 1276,
 /*    60 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    70 */  1333, 1475, 1276, 1631, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    80 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*    90 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1335,
 /*   100 */  1276, 1276, 1642, 1642, 1642, 1333, 1276, 1276, 1276, 1276,
 /*   110 */  1276, 1276, 1276, 1428, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   120 */  1276, 1276, 1509, 1276, 1276, 1706, 1276, 1381, 1515, 1666,
 /*   130 */  1276, 1658, 1634, 1648, 1635, 1276, 1691, 1651, 1276, 1276,
 /*   140 */  1276, 1276, 1501, 1276, 1276, 1480, 1477, 1477, 1276, 1276,
 /*   150 */  1335, 1276, 1276, 1335, 1276, 1276, 1335, 1335, 1276, 1335,
 /*   160 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   170 */  1276, 1276, 1276, 1276, 1276, 1276, 1333, 1511, 1276, 1276,
 /*   180 */  1333, 1276, 1276, 1333, 1276, 1673, 1671, 1276, 1673, 1671,
 /*   190 */  1276, 1276, 1685, 1681, 1664, 1662, 1648, 1276, 1276, 1276,
 /*   200 */  1709, 1697, 1693, 1276, 1276, 1671, 1276, 1276, 1671, 1276,
 /*   210 */  1488, 1276, 1276, 1333, 1276, 1333, 1276, 1397, 1276, 1276,
 /*   220 */  1333, 1276, 1503, 1517, 1431, 1431, 1336, 1281, 1276, 1276,
 /*   230 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1578,
 /*   240 */  1684, 1683, 1607, 1606, 1605, 1603, 1577, 1276, 1276, 1276,
 /*   250 */  1276, 1571, 1572, 1570, 1569, 1276, 1276, 1276, 1276, 1276,
 /*   260 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   270 */  1632, 1276, 1694, 1698, 1276, 1276, 1276, 1555, 1276, 1276,
 /*   280 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   290 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   300 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   310 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   320 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   330 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   340 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   350 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   360 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   370 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   380 */  1276, 1276, 1276, 1276, 1444, 1443, 1276, 1276, 1276, 1276,
 /*   390 */  1276, 1276, 1362, 1361, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   400 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   410 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   420 */  1276, 1276, 1276, 1276, 1655, 1665, 1276, 1276, 1276, 1276,
 /*   430 */  1276, 1276, 1276, 1276, 1276, 1555, 1276, 1682, 1276, 1641,
 /*   440 */  1637, 1276, 1276, 1633, 1276, 1276, 1692, 1276, 1276, 1276,
 /*   450 */  1276, 1276, 1276, 1276, 1276, 1627, 1276, 1600, 1276, 1276,
 /*   460 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1565, 1276,
 /*   470 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   480 */  1276, 1554, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1425,
 /*   490 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   500 */  1276, 1276, 1410, 1408, 1407, 1406, 1276, 1403, 1276, 1276,
 /*   510 */  1276, 1276, 1276, 1276, 1434, 1433, 1276, 1276, 1276, 1276,
 /*   520 */  1276, 1356, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   530 */  1276, 1347, 1276, 1346, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   540 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   550 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*   560 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "NK_COMMA",
  /*   72 */ "NK_COLON",
  /*   73 */ "TABLE",
  /*   74 */ "NK_LP",
  /*   75 */ "NK_RP",
  /*   76 */ "STABLE",
  /*   77 */ "ADD",
  /*   78 */ "COLUMN",
  /*   79 */ "MODIFY",
  /*   80 */ "RENAME",
  /*   81 */ "TAG",
  /*   82 */ "SET",
  /*   83 */ "NK_EQ",
  /*   84 */ "USING",
  /*   85 */ "TAGS",
  /*   86 */ "NK_DOT",
  /*   87 */ "COMMENT",
  /*   88 */ "BOOL",
  /*   89 */ "TINYINT",
  /*   90 */ "SMALLINT",
  /*   91 */ "INT",
  /*   92 */ "INTEGER",
  /*   93 */ "BIGINT",
  /*   94 */ "FLOAT",
  /*   95 */ "DOUBLE",
  /*   96 */ "BINARY",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "NCHAR",
  /*   99 */ "UNSIGNED",
  /*  100 */ "JSON",
  /*  101 */ "VARCHAR",
  /*  102 */ "MEDIUMBLOB",
  /*  103 */ "BLOB",
  /*  104 */ "VARBINARY",
  /*  105 */ "DECIMAL",
  /*  106 */ "SMA",
  /*  107 */ "ROLLUP",
  /*  108 */ "FILE_FACTOR",
  /*  109 */ "NK_FLOAT",
  /*  110 */ "DELAY",
  /*  111 */ "SHOW",
  /*  112 */ "DATABASES",
  /*  113 */ "TABLES",
  /*  114 */ "STABLES",
  /*  115 */ "MNODES",
  /*  116 */ "MODULES",
  /*  117 */ "QNODES",
  /*  118 */ "FUNCTIONS",
  /*  119 */ "INDEXES",
  /*  120 */ "FROM",
  /*  121 */ "ACCOUNTS",
  /*  122 */ "APPS",
  /*  123 */ "CONNECTIONS",
  /*  124 */ "LICENCE",
  /*  125 */ "GRANTS",
  /*  126 */ "QUERIES",
  /*  127 */ "SCORES",
  /*  128 */ "TOPICS",
  /*  129 */ "VARIABLES",
  /*  130 */ "BNODES",
  /*  131 */ "SNODES",
  /*  132 */ "LIKE",
  /*  133 */ "INDEX",
  /*  134 */ "FULLTEXT",
  /*  135 */ "FUNCTION",
  /*  136 */ "INTERVAL",
  /*  137 */ "TOPIC",
  /*  138 */ "AS",
  /*  139 */ "DESC",
  /*  140 */ "DESCRIBE",
  /*  141 */ "RESET",
  /*  142 */ "QUERY",
  /*  143 */ "EXPLAIN",
  /*  144 */ "ANALYZE",
  /*  145 */ "VERBOSE",
  /*  146 */ "NK_BOOL",
  /*  147 */ "RATIO",
  /*  148 */ "COMPACT",
  /*  149 */ "VNODES",
  /*  150 */ "IN",
  /*  151 */ "OUTPUTTYPE",
  /*  152 */ "AGGREGATE",
  /*  153 */ "BUFSIZE",
  /*  154 */ "STREAM",
  /*  155 */ "INTO",
  /*  156 */ "TRIGGER",
  /*  157 */ "AT_ONCE",
  /*  158 */ "WINDOW_CLOSE",
  /*  159 */ "WATERMARK",
  /*  160 */ "KILL",
  /*  161 */ "CONNECTION",
  /*  162 */ "MERGE",
  /*  163 */ "VGROUP",
  /*  164 */ "REDISTRIBUTE",
  /*  165 */ "SPLIT",
  /*  166 */ "SYNCDB",
  /*  167 */ "NULL",
  /*  168 */ "NK_QUESTION",
  /*  169 */ "NK_ARROW",
  /*  170 */ "ROWTS",
  /*  171 */ "TBNAME",
  /*  172 */ "QSTARTTS",
  /*  173 */ "QENDTS",
  /*  174 */ "WSTARTTS",
  /*  175 */ "WENDTS",
  /*  176 */ "WDURATION",
  /*  177 */ "CAST",
  /*  178 */ "NOW",
  /*  179 */ "TODAY",
  /*  180 */ "TIMEZONE",
  /*  181 */ "COUNT",
  /*  182 */ "FIRST",
  /*  183 */ "LAST",
  /*  184 */ "LAST_ROW",
  /*  185 */ "BETWEEN",
  /*  186 */ "IS",
  /*  187 */ "NK_LT",
  /*  188 */ "NK_GT",
  /*  189 */ "NK_LE",
  /*  190 */ "NK_GE",
  /*  191 */ "NK_NE",
  /*  192 */ "MATCH",
  /*  193 */ "NMATCH",
  /*  194 */ "CONTAINS",
  /*  195 */ "JOIN",
  /*  196 */ "INNER",
  /*  197 */ "SELECT",
  /*  198 */ "DISTINCT",
  /*  199 */ "WHERE",
  /*  200 */ "PARTITION",
  /*  201 */ "BY",
  /*  202 */ "SESSION",
  /*  203 */ "STATE_WINDOW",
  /*  204 */ "SLIDING",
  /*  205 */ "FILL",
  /*  206 */ "VALUE",
  /*  207 */ "NONE",
  /*  208 */ "PREV",
  /*  209 */ "LINEAR",
  /*  210 */ "NEXT",
  /*  211 */ "GROUP",
  /*  212 */ "HAVING",
  /*  213 */ "ORDER",
  /*  214 */ "SLIMIT",
  /*  215 */ "SOFFSET",
  /*  216 */ "LIMIT",
  /*  217 */ "OFFSET",
  /*  218 */ "ASC",
  /*  219 */ "NULLS",
  /*  220 */ "cmd",
  /*  221 */ "account_options",
  /*  222 */ "alter_account_options",
  /*  223 */ "literal",
  /*  224 */ "alter_account_option",
  /*  225 */ "user_name",
  /*  226 */ "dnode_endpoint",
  /*  227 */ "dnode_host_name",
  /*  228 */ "not_exists_opt",
  /*  229 */ "db_name",
  /*  230 */ "db_options",
  /*  231 */ "exists_opt",
  /*  232 */ "alter_db_options",
  /*  233 */ "integer_list",
  /*  234 */ "variable_list",
  /*  235 */ "retention_list",
  /*  236 */ "alter_db_option",
  /*  237 */ "retention",
  /*  238 */ "full_table_name",
  /*  239 */ "column_def_list",
  /*  240 */ "tags_def_opt",
  /*  241 */ "table_options",
  /*  242 */ "multi_create_clause",
  /*  243 */ "tags_def",
  /*  244 */ "multi_drop_clause",
  /*  245 */ "alter_table_clause",
  /*  246 */ "alter_table_options",
  /*  247 */ "column_name",
  /*  248 */ "type_name",
  /*  249 */ "create_subtable_clause",
  /*  250 */ "specific_tags_opt",
  /*  251 */ "literal_list",
  /*  252 */ "drop_table_clause",
  /*  253 */ "col_name_list",
  /*  254 */ "table_name",
  /*  255 */ "column_def",
  /*  256 */ "func_name_list",
  /*  257 */ "alter_table_option",
  /*  258 */ "col_name",
  /*  259 */ "db_name_cond_opt",
  /*  260 */ "like_pattern_opt",
  /*  261 */ "table_name_cond",
  /*  262 */ "from_db_opt",
  /*  263 */ "func_name",
  /*  264 */ "function_name",
  /*  265 */ "index_name",
  /*  266 */ "index_options",
  /*  267 */ "func_list",
  /*  268 */ "duration_literal",
  /*  269 */ "sliding_opt",
  /*  270 */ "func",
  /*  271 */ "expression_list",
  /*  272 */ "topic_name",
  /*  273 */ "query_expression",
  /*  274 */ "analyze_opt",
  /*  275 */ "explain_options",
  /*  276 */ "agg_func_opt",
  /*  277 */ "bufsize_opt",
  /*  278 */ "stream_name",
  /*  279 */ "stream_options",
  /*  280 */ "into_opt",
  /*  281 */ "dnode_list",
  /*  282 */ "signed",
  /*  283 */ "signed_literal",
  /*  284 */ "table_alias",
  /*  285 */ "column_alias",
  /*  286 */ "expression",
  /*  287 */ "pseudo_column",
  /*  288 */ "column_reference",
  /*  289 */ "function_expression",
  /*  290 */ "subquery",
  /*  291 */ "star_func",
  /*  292 */ "star_func_para_list",
  /*  293 */ "noarg_func",
  /*  294 */ "other_para_list",
  /*  295 */ "star_func_para",
  /*  296 */ "predicate",
  /*  297 */ "compare_op",
  /*  298 */ "in_op",
  /*  299 */ "in_predicate_value",
  /*  300 */ "boolean_value_expression",
  /*  301 */ "boolean_primary",
  /*  302 */ "common_expression",
  /*  303 */ "from_clause",
  /*  304 */ "table_reference_list",
  /*  305 */ "table_reference",
  /*  306 */ "table_primary",
  /*  307 */ "joined_table",
  /*  308 */ "alias_opt",
  /*  309 */ "parenthesized_joined_table",
  /*  310 */ "join_type",
  /*  311 */ "search_condition",
  /*  312 */ "query_specification",
  /*  313 */ "set_quantifier_opt",
  /*  314 */ "select_list",
  /*  315 */ "where_clause_opt",
  /*  316 */ "partition_by_clause_opt",
  /*  317 */ "twindow_clause_opt",
  /*  318 */ "group_by_clause_opt",
  /*  319 */ "having_clause_opt",
  /*  320 */ "select_sublist",
  /*  321 */ "select_item",
  /*  322 */ "fill_opt",
  /*  323 */ "fill_mode",
  /*  324 */ "group_by_list",
  /*  325 */ "query_expression_body",
  /*  326 */ "order_by_clause_opt",
  /*  327 */ "slimit_clause_opt",
  /*  328 */ "limit_clause_opt",
  /*  329 */ "query_primary",
  /*  330 */ "sort_specification_list",
  /*  331 */ "sort_specification",
  /*  332 */ "ordering_specification_opt",
  /*  333 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "alter_db_options ::= alter_db_option",
 /*  79 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  80 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  81 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  82 */ "alter_db_option ::= KEEP integer_list",
 /*  83 */ "alter_db_option ::= KEEP variable_list",
 /*  84 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  85 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  86 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  87 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  88 */ "integer_list ::= NK_INTEGER",
 /*  89 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  90 */ "variable_list ::= NK_VARIABLE",
 /*  91 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  92 */ "retention_list ::= retention",
 /*  93 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  94 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  95 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  96 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  97 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  98 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  99 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 100 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 101 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 102 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 103 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 105 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 107 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 109 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 111 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 112 */ "multi_create_clause ::= create_subtable_clause",
 /* 113 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 114 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 115 */ "multi_drop_clause ::= drop_table_clause",
 /* 116 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 117 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 118 */ "specific_tags_opt ::=",
 /* 119 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 120 */ "full_table_name ::= table_name",
 /* 121 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 122 */ "column_def_list ::= column_def",
 /* 123 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 124 */ "column_def ::= column_name type_name",
 /* 125 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 126 */ "type_name ::= BOOL",
 /* 127 */ "type_name ::= TINYINT",
 /* 128 */ "type_name ::= SMALLINT",
 /* 129 */ "type_name ::= INT",
 /* 130 */ "type_name ::= INTEGER",
 /* 131 */ "type_name ::= BIGINT",
 /* 132 */ "type_name ::= FLOAT",
 /* 133 */ "type_name ::= DOUBLE",
 /* 134 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 135 */ "type_name ::= TIMESTAMP",
 /* 136 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TINYINT UNSIGNED",
 /* 138 */ "type_name ::= SMALLINT UNSIGNED",
 /* 139 */ "type_name ::= INT UNSIGNED",
 /* 140 */ "type_name ::= BIGINT UNSIGNED",
 /* 141 */ "type_name ::= JSON",
 /* 142 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 143 */ "type_name ::= MEDIUMBLOB",
 /* 144 */ "type_name ::= BLOB",
 /* 145 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= DECIMAL",
 /* 147 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 149 */ "tags_def_opt ::=",
 /* 150 */ "tags_def_opt ::= tags_def",
 /* 151 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 152 */ "table_options ::=",
 /* 153 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 154 */ "table_options ::= table_options KEEP integer_list",
 /* 155 */ "table_options ::= table_options KEEP variable_list",
 /* 156 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 157 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 158 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 159 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 160 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 161 */ "alter_table_options ::= alter_table_option",
 /* 162 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 163 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 164 */ "alter_table_option ::= KEEP integer_list",
 /* 165 */ "alter_table_option ::= KEEP variable_list",
 /* 166 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 167 */ "col_name_list ::= col_name",
 /* 168 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 169 */ "col_name ::= column_name",
 /* 170 */ "cmd ::= SHOW DNODES",
 /* 171 */ "cmd ::= SHOW USERS",
 /* 172 */ "cmd ::= SHOW DATABASES",
 /* 173 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 174 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 175 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 176 */ "cmd ::= SHOW MNODES",
 /* 177 */ "cmd ::= SHOW MODULES",
 /* 178 */ "cmd ::= SHOW QNODES",
 /* 179 */ "cmd ::= SHOW FUNCTIONS",
 /* 180 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 181 */ "cmd ::= SHOW STREAMS",
 /* 182 */ "cmd ::= SHOW ACCOUNTS",
 /* 183 */ "cmd ::= SHOW APPS",
 /* 184 */ "cmd ::= SHOW CONNECTIONS",
 /* 185 */ "cmd ::= SHOW LICENCE",
 /* 186 */ "cmd ::= SHOW GRANTS",
 /* 187 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 188 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 189 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 190 */ "cmd ::= SHOW QUERIES",
 /* 191 */ "cmd ::= SHOW SCORES",
 /* 192 */ "cmd ::= SHOW TOPICS",
 /* 193 */ "cmd ::= SHOW VARIABLES",
 /* 194 */ "cmd ::= SHOW BNODES",
 /* 195 */ "cmd ::= SHOW SNODES",
 /* 196 */ "db_name_cond_opt ::=",
 /* 197 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 198 */ "like_pattern_opt ::=",
 /* 199 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 200 */ "table_name_cond ::= table_name",
 /* 201 */ "from_db_opt ::=",
 /* 202 */ "from_db_opt ::= FROM db_name",
 /* 203 */ "func_name_list ::= func_name",
 /* 204 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 205 */ "func_name ::= function_name",
 /* 206 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 207 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 208 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 209 */ "index_options ::=",
 /* 210 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 211 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 212 */ "func_list ::= func",
 /* 213 */ "func_list ::= func_list NK_COMMA func",
 /* 214 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 215 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 216 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 217 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 218 */ "cmd ::= DESC full_table_name",
 /* 219 */ "cmd ::= DESCRIBE full_table_name",
 /* 220 */ "cmd ::= RESET QUERY CACHE",
 /* 221 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 222 */ "analyze_opt ::=",
 /* 223 */ "analyze_opt ::= ANALYZE",
 /* 224 */ "explain_options ::=",
 /* 225 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 226 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 227 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 228 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 229 */ "cmd ::= DROP FUNCTION function_name",
 /* 230 */ "agg_func_opt ::=",
 /* 231 */ "agg_func_opt ::= AGGREGATE",
 /* 232 */ "bufsize_opt ::=",
 /* 233 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 234 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 235 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 236 */ "into_opt ::=",
 /* 237 */ "into_opt ::= INTO full_table_name",
 /* 238 */ "stream_options ::=",
 /* 239 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 240 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 241 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 242 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 243 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 244 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 245 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 246 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 247 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 248 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 249 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 250 */ "cmd ::= query_expression",
 /* 251 */ "literal ::= NK_INTEGER",
 /* 252 */ "literal ::= NK_FLOAT",
 /* 253 */ "literal ::= NK_STRING",
 /* 254 */ "literal ::= NK_BOOL",
 /* 255 */ "literal ::= TIMESTAMP NK_STRING",
 /* 256 */ "literal ::= duration_literal",
 /* 257 */ "literal ::= NULL",
 /* 258 */ "literal ::= NK_QUESTION",
 /* 259 */ "duration_literal ::= NK_VARIABLE",
 /* 260 */ "signed ::= NK_INTEGER",
 /* 261 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 262 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 263 */ "signed ::= NK_FLOAT",
 /* 264 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 265 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 266 */ "signed_literal ::= signed",
 /* 267 */ "signed_literal ::= NK_STRING",
 /* 268 */ "signed_literal ::= NK_BOOL",
 /* 269 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 270 */ "signed_literal ::= duration_literal",
 /* 271 */ "signed_literal ::= NULL",
 /* 272 */ "literal_list ::= signed_literal",
 /* 273 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 274 */ "db_name ::= NK_ID",
 /* 275 */ "table_name ::= NK_ID",
 /* 276 */ "column_name ::= NK_ID",
 /* 277 */ "function_name ::= NK_ID",
 /* 278 */ "table_alias ::= NK_ID",
 /* 279 */ "column_alias ::= NK_ID",
 /* 280 */ "user_name ::= NK_ID",
 /* 281 */ "index_name ::= NK_ID",
 /* 282 */ "topic_name ::= NK_ID",
 /* 283 */ "stream_name ::= NK_ID",
 /* 284 */ "expression ::= literal",
 /* 285 */ "expression ::= pseudo_column",
 /* 286 */ "expression ::= column_reference",
 /* 287 */ "expression ::= function_expression",
 /* 288 */ "expression ::= subquery",
 /* 289 */ "expression ::= NK_LP expression NK_RP",
 /* 290 */ "expression ::= NK_PLUS expression",
 /* 291 */ "expression ::= NK_MINUS expression",
 /* 292 */ "expression ::= expression NK_PLUS expression",
 /* 293 */ "expression ::= expression NK_MINUS expression",
 /* 294 */ "expression ::= expression NK_STAR expression",
 /* 295 */ "expression ::= expression NK_SLASH expression",
 /* 296 */ "expression ::= expression NK_REM expression",
 /* 297 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 298 */ "expression_list ::= expression",
 /* 299 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 300 */ "column_reference ::= column_name",
 /* 301 */ "column_reference ::= table_name NK_DOT column_name",
 /* 302 */ "pseudo_column ::= ROWTS",
 /* 303 */ "pseudo_column ::= TBNAME",
 /* 304 */ "pseudo_column ::= QSTARTTS",
 /* 305 */ "pseudo_column ::= QENDTS",
 /* 306 */ "pseudo_column ::= WSTARTTS",
 /* 307 */ "pseudo_column ::= WENDTS",
 /* 308 */ "pseudo_column ::= WDURATION",
 /* 309 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 310 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 311 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 312 */ "function_expression ::= noarg_func NK_LP NK_RP",
 /* 313 */ "noarg_func ::= NOW",
 /* 314 */ "noarg_func ::= TODAY",
 /* 315 */ "noarg_func ::= TIMEZONE",
 /* 316 */ "star_func ::= COUNT",
 /* 317 */ "star_func ::= FIRST",
 /* 318 */ "star_func ::= LAST",
 /* 319 */ "star_func ::= LAST_ROW",
 /* 320 */ "star_func_para_list ::= NK_STAR",
 /* 321 */ "star_func_para_list ::= other_para_list",
 /* 322 */ "other_para_list ::= star_func_para",
 /* 323 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 324 */ "star_func_para ::= expression",
 /* 325 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 326 */ "predicate ::= expression compare_op expression",
 /* 327 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 328 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 329 */ "predicate ::= expression IS NULL",
 /* 330 */ "predicate ::= expression IS NOT NULL",
 /* 331 */ "predicate ::= expression in_op in_predicate_value",
 /* 332 */ "compare_op ::= NK_LT",
 /* 333 */ "compare_op ::= NK_GT",
 /* 334 */ "compare_op ::= NK_LE",
 /* 335 */ "compare_op ::= NK_GE",
 /* 336 */ "compare_op ::= NK_NE",
 /* 337 */ "compare_op ::= NK_EQ",
 /* 338 */ "compare_op ::= LIKE",
 /* 339 */ "compare_op ::= NOT LIKE",
 /* 340 */ "compare_op ::= MATCH",
 /* 341 */ "compare_op ::= NMATCH",
 /* 342 */ "compare_op ::= CONTAINS",
 /* 343 */ "in_op ::= IN",
 /* 344 */ "in_op ::= NOT IN",
 /* 345 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 346 */ "boolean_value_expression ::= boolean_primary",
 /* 347 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 348 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 349 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 350 */ "boolean_primary ::= predicate",
 /* 351 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 352 */ "common_expression ::= expression",
 /* 353 */ "common_expression ::= boolean_value_expression",
 /* 354 */ "from_clause ::= FROM table_reference_list",
 /* 355 */ "table_reference_list ::= table_reference",
 /* 356 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 357 */ "table_reference ::= table_primary",
 /* 358 */ "table_reference ::= joined_table",
 /* 359 */ "table_primary ::= table_name alias_opt",
 /* 360 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 361 */ "table_primary ::= subquery alias_opt",
 /* 362 */ "table_primary ::= parenthesized_joined_table",
 /* 363 */ "alias_opt ::=",
 /* 364 */ "alias_opt ::= table_alias",
 /* 365 */ "alias_opt ::= AS table_alias",
 /* 366 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 367 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 368 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 369 */ "join_type ::=",
 /* 370 */ "join_type ::= INNER",
 /* 371 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 372 */ "set_quantifier_opt ::=",
 /* 373 */ "set_quantifier_opt ::= DISTINCT",
 /* 374 */ "set_quantifier_opt ::= ALL",
 /* 375 */ "select_list ::= NK_STAR",
 /* 376 */ "select_list ::= select_sublist",
 /* 377 */ "select_sublist ::= select_item",
 /* 378 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 379 */ "select_item ::= common_expression",
 /* 380 */ "select_item ::= common_expression column_alias",
 /* 381 */ "select_item ::= common_expression AS column_alias",
 /* 382 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 383 */ "where_clause_opt ::=",
 /* 384 */ "where_clause_opt ::= WHERE search_condition",
 /* 385 */ "partition_by_clause_opt ::=",
 /* 386 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 387 */ "twindow_clause_opt ::=",
 /* 388 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 389 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 390 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 391 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 392 */ "sliding_opt ::=",
 /* 393 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 394 */ "fill_opt ::=",
 /* 395 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 396 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 397 */ "fill_mode ::= NONE",
 /* 398 */ "fill_mode ::= PREV",
 /* 399 */ "fill_mode ::= NULL",
 /* 400 */ "fill_mode ::= LINEAR",
 /* 401 */ "fill_mode ::= NEXT",
 /* 402 */ "group_by_clause_opt ::=",
 /* 403 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 404 */ "group_by_list ::= expression",
 /* 405 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 406 */ "having_clause_opt ::=",
 /* 407 */ "having_clause_opt ::= HAVING search_condition",
 /* 408 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 409 */ "query_expression_body ::= query_primary",
 /* 410 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 411 */ "query_primary ::= query_specification",
 /* 412 */ "order_by_clause_opt ::=",
 /* 413 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 414 */ "slimit_clause_opt ::=",
 /* 415 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 416 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 417 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 418 */ "limit_clause_opt ::=",
 /* 419 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 420 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 421 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 422 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 423 */ "search_condition ::= common_expression",
 /* 424 */ "sort_specification_list ::= sort_specification",
 /* 425 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 426 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 427 */ "ordering_specification_opt ::=",
 /* 428 */ "ordering_specification_opt ::= ASC",
 /* 429 */ "ordering_specification_opt ::= DESC",
 /* 430 */ "null_ordering_opt ::=",
 /* 431 */ "null_ordering_opt ::= NULLS FIRST",
 /* 432 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 220: /* cmd */
    case 223: /* literal */
    case 230: /* db_options */
    case 232: /* alter_db_options */
    case 237: /* retention */
    case 238: /* full_table_name */
    case 241: /* table_options */
    case 245: /* alter_table_clause */
    case 246: /* alter_table_options */
    case 249: /* create_subtable_clause */
    case 252: /* drop_table_clause */
    case 255: /* column_def */
    case 258: /* col_name */
    case 259: /* db_name_cond_opt */
    case 260: /* like_pattern_opt */
    case 261: /* table_name_cond */
    case 262: /* from_db_opt */
    case 263: /* func_name */
    case 266: /* index_options */
    case 268: /* duration_literal */
    case 269: /* sliding_opt */
    case 270: /* func */
    case 273: /* query_expression */
    case 275: /* explain_options */
    case 279: /* stream_options */
    case 280: /* into_opt */
    case 282: /* signed */
    case 283: /* signed_literal */
    case 286: /* expression */
    case 287: /* pseudo_column */
    case 288: /* column_reference */
    case 289: /* function_expression */
    case 290: /* subquery */
    case 295: /* star_func_para */
    case 296: /* predicate */
    case 299: /* in_predicate_value */
    case 300: /* boolean_value_expression */
    case 301: /* boolean_primary */
    case 302: /* common_expression */
    case 303: /* from_clause */
    case 304: /* table_reference_list */
    case 305: /* table_reference */
    case 306: /* table_primary */
    case 307: /* joined_table */
    case 309: /* parenthesized_joined_table */
    case 311: /* search_condition */
    case 312: /* query_specification */
    case 315: /* where_clause_opt */
    case 317: /* twindow_clause_opt */
    case 319: /* having_clause_opt */
    case 321: /* select_item */
    case 322: /* fill_opt */
    case 325: /* query_expression_body */
    case 327: /* slimit_clause_opt */
    case 328: /* limit_clause_opt */
    case 329: /* query_primary */
    case 331: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy456)); 
}
      break;
    case 221: /* account_options */
    case 222: /* alter_account_options */
    case 224: /* alter_account_option */
    case 277: /* bufsize_opt */
{
 
}
      break;
    case 225: /* user_name */
    case 226: /* dnode_endpoint */
    case 227: /* dnode_host_name */
    case 229: /* db_name */
    case 247: /* column_name */
    case 254: /* table_name */
    case 264: /* function_name */
    case 265: /* index_name */
    case 272: /* topic_name */
    case 278: /* stream_name */
    case 284: /* table_alias */
    case 285: /* column_alias */
    case 291: /* star_func */
    case 293: /* noarg_func */
    case 308: /* alias_opt */
{
 
}
      break;
    case 228: /* not_exists_opt */
    case 231: /* exists_opt */
    case 274: /* analyze_opt */
    case 276: /* agg_func_opt */
    case 313: /* set_quantifier_opt */
{
 
}
      break;
    case 233: /* integer_list */
    case 234: /* variable_list */
    case 235: /* retention_list */
    case 239: /* column_def_list */
    case 240: /* tags_def_opt */
    case 242: /* multi_create_clause */
    case 243: /* tags_def */
    case 244: /* multi_drop_clause */
    case 250: /* specific_tags_opt */
    case 251: /* literal_list */
    case 253: /* col_name_list */
    case 256: /* func_name_list */
    case 267: /* func_list */
    case 271: /* expression_list */
    case 281: /* dnode_list */
    case 292: /* star_func_para_list */
    case 294: /* other_para_list */
    case 314: /* select_list */
    case 316: /* partition_by_clause_opt */
    case 318: /* group_by_clause_opt */
    case 320: /* select_sublist */
    case 324: /* group_by_list */
    case 326: /* order_by_clause_opt */
    case 330: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy632)); 
}
      break;
    case 236: /* alter_db_option */
    case 257: /* alter_table_option */
{
 
}
      break;
    case 248: /* type_name */
{
 
}
      break;
    case 297: /* compare_op */
    case 298: /* in_op */
{
 
}
      break;
    case 310: /* join_type */
{
 
}
      break;
    case 323: /* fill_mode */
{
 
}
      break;
    case 332: /* ordering_specification_opt */
{
 
}
      break;
    case 333: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  220,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  220,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  221,    0 }, /* (2) account_options ::= */
  {  221,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  221,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  221,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  221,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  221,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  221,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  221,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  221,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  221,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  222,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  222,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  224,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  224,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  224,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  224,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  224,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  224,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  224,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  224,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  224,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  224,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  220,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  220,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  220,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  220,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  220,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  220,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  220,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  220,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  220,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  220,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  220,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  220,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  226,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  227,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  227,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  220,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  220,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  220,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  220,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  220,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  220,   -2 }, /* (51) cmd ::= USE db_name */
  {  220,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  228,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  228,    0 }, /* (54) not_exists_opt ::= */
  {  231,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  231,    0 }, /* (56) exists_opt ::= */
  {  230,    0 }, /* (57) db_options ::= */
  {  230,   -3 }, /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
  {  230,   -3 }, /* (59) db_options ::= db_options CACHE NK_INTEGER */
  {  230,   -3 }, /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
  {  230,   -3 }, /* (61) db_options ::= db_options COMP NK_INTEGER */
  {  230,   -3 }, /* (62) db_options ::= db_options DAYS NK_INTEGER */
  {  230,   -3 }, /* (63) db_options ::= db_options DAYS NK_VARIABLE */
  {  230,   -3 }, /* (64) db_options ::= db_options FSYNC NK_INTEGER */
  {  230,   -3 }, /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
  {  230,   -3 }, /* (66) db_options ::= db_options MINROWS NK_INTEGER */
  {  230,   -3 }, /* (67) db_options ::= db_options KEEP integer_list */
  {  230,   -3 }, /* (68) db_options ::= db_options KEEP variable_list */
  {  230,   -3 }, /* (69) db_options ::= db_options PRECISION NK_STRING */
  {  230,   -3 }, /* (70) db_options ::= db_options QUORUM NK_INTEGER */
  {  230,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  230,   -3 }, /* (72) db_options ::= db_options TTL NK_INTEGER */
  {  230,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  230,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  230,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  230,   -3 }, /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  230,   -3 }, /* (77) db_options ::= db_options RETENTIONS retention_list */
  {  232,   -1 }, /* (78) alter_db_options ::= alter_db_option */
  {  232,   -2 }, /* (79) alter_db_options ::= alter_db_options alter_db_option */
  {  236,   -2 }, /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
  {  236,   -2 }, /* (81) alter_db_option ::= FSYNC NK_INTEGER */
  {  236,   -2 }, /* (82) alter_db_option ::= KEEP integer_list */
  {  236,   -2 }, /* (83) alter_db_option ::= KEEP variable_list */
  {  236,   -2 }, /* (84) alter_db_option ::= WAL NK_INTEGER */
  {  236,   -2 }, /* (85) alter_db_option ::= QUORUM NK_INTEGER */
  {  236,   -2 }, /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
  {  236,   -2 }, /* (87) alter_db_option ::= REPLICA NK_INTEGER */
  {  233,   -1 }, /* (88) integer_list ::= NK_INTEGER */
  {  233,   -3 }, /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  234,   -1 }, /* (90) variable_list ::= NK_VARIABLE */
  {  234,   -3 }, /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  235,   -1 }, /* (92) retention_list ::= retention */
  {  235,   -3 }, /* (93) retention_list ::= retention_list NK_COMMA retention */
  {  237,   -3 }, /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  220,   -9 }, /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  220,   -3 }, /* (96) cmd ::= CREATE TABLE multi_create_clause */
  {  220,   -9 }, /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  220,   -3 }, /* (98) cmd ::= DROP TABLE multi_drop_clause */
  {  220,   -4 }, /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
  {  220,   -3 }, /* (100) cmd ::= ALTER TABLE alter_table_clause */
  {  220,   -3 }, /* (101) cmd ::= ALTER STABLE alter_table_clause */
  {  245,   -2 }, /* (102) alter_table_clause ::= full_table_name alter_table_options */
  {  245,   -5 }, /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  245,   -4 }, /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  245,   -5 }, /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  245,   -5 }, /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  245,   -5 }, /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  245,   -4 }, /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  245,   -5 }, /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  245,   -5 }, /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  245,   -6 }, /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  242,   -1 }, /* (112) multi_create_clause ::= create_subtable_clause */
  {  242,   -2 }, /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  249,   -9 }, /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  244,   -1 }, /* (115) multi_drop_clause ::= drop_table_clause */
  {  244,   -2 }, /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  252,   -2 }, /* (117) drop_table_clause ::= exists_opt full_table_name */
  {  250,    0 }, /* (118) specific_tags_opt ::= */
  {  250,   -3 }, /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  238,   -1 }, /* (120) full_table_name ::= table_name */
  {  238,   -3 }, /* (121) full_table_name ::= db_name NK_DOT table_name */
  {  239,   -1 }, /* (122) column_def_list ::= column_def */
  {  239,   -3 }, /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
  {  255,   -2 }, /* (124) column_def ::= column_name type_name */
  {  255,   -4 }, /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
  {  248,   -1 }, /* (126) type_name ::= BOOL */
  {  248,   -1 }, /* (127) type_name ::= TINYINT */
  {  248,   -1 }, /* (128) type_name ::= SMALLINT */
  {  248,   -1 }, /* (129) type_name ::= INT */
  {  248,   -1 }, /* (130) type_name ::= INTEGER */
  {  248,   -1 }, /* (131) type_name ::= BIGINT */
  {  248,   -1 }, /* (132) type_name ::= FLOAT */
  {  248,   -1 }, /* (133) type_name ::= DOUBLE */
  {  248,   -4 }, /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  248,   -1 }, /* (135) type_name ::= TIMESTAMP */
  {  248,   -4 }, /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  248,   -2 }, /* (137) type_name ::= TINYINT UNSIGNED */
  {  248,   -2 }, /* (138) type_name ::= SMALLINT UNSIGNED */
  {  248,   -2 }, /* (139) type_name ::= INT UNSIGNED */
  {  248,   -2 }, /* (140) type_name ::= BIGINT UNSIGNED */
  {  248,   -1 }, /* (141) type_name ::= JSON */
  {  248,   -4 }, /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  248,   -1 }, /* (143) type_name ::= MEDIUMBLOB */
  {  248,   -1 }, /* (144) type_name ::= BLOB */
  {  248,   -4 }, /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  248,   -1 }, /* (146) type_name ::= DECIMAL */
  {  248,   -4 }, /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  248,   -6 }, /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  240,    0 }, /* (149) tags_def_opt ::= */
  {  240,   -1 }, /* (150) tags_def_opt ::= tags_def */
  {  243,   -4 }, /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  241,    0 }, /* (152) table_options ::= */
  {  241,   -3 }, /* (153) table_options ::= table_options COMMENT NK_STRING */
  {  241,   -3 }, /* (154) table_options ::= table_options KEEP integer_list */
  {  241,   -3 }, /* (155) table_options ::= table_options KEEP variable_list */
  {  241,   -3 }, /* (156) table_options ::= table_options TTL NK_INTEGER */
  {  241,   -5 }, /* (157) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  241,   -5 }, /* (158) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  241,   -3 }, /* (159) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  241,   -3 }, /* (160) table_options ::= table_options DELAY NK_INTEGER */
  {  246,   -1 }, /* (161) alter_table_options ::= alter_table_option */
  {  246,   -2 }, /* (162) alter_table_options ::= alter_table_options alter_table_option */
  {  257,   -2 }, /* (163) alter_table_option ::= COMMENT NK_STRING */
  {  257,   -2 }, /* (164) alter_table_option ::= KEEP integer_list */
  {  257,   -2 }, /* (165) alter_table_option ::= KEEP variable_list */
  {  257,   -2 }, /* (166) alter_table_option ::= TTL NK_INTEGER */
  {  253,   -1 }, /* (167) col_name_list ::= col_name */
  {  253,   -3 }, /* (168) col_name_list ::= col_name_list NK_COMMA col_name */
  {  258,   -1 }, /* (169) col_name ::= column_name */
  {  220,   -2 }, /* (170) cmd ::= SHOW DNODES */
  {  220,   -2 }, /* (171) cmd ::= SHOW USERS */
  {  220,   -2 }, /* (172) cmd ::= SHOW DATABASES */
  {  220,   -4 }, /* (173) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  220,   -4 }, /* (174) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  220,   -3 }, /* (175) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  220,   -2 }, /* (176) cmd ::= SHOW MNODES */
  {  220,   -2 }, /* (177) cmd ::= SHOW MODULES */
  {  220,   -2 }, /* (178) cmd ::= SHOW QNODES */
  {  220,   -2 }, /* (179) cmd ::= SHOW FUNCTIONS */
  {  220,   -5 }, /* (180) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  220,   -2 }, /* (181) cmd ::= SHOW STREAMS */
  {  220,   -2 }, /* (182) cmd ::= SHOW ACCOUNTS */
  {  220,   -2 }, /* (183) cmd ::= SHOW APPS */
  {  220,   -2 }, /* (184) cmd ::= SHOW CONNECTIONS */
  {  220,   -2 }, /* (185) cmd ::= SHOW LICENCE */
  {  220,   -2 }, /* (186) cmd ::= SHOW GRANTS */
  {  220,   -4 }, /* (187) cmd ::= SHOW CREATE DATABASE db_name */
  {  220,   -4 }, /* (188) cmd ::= SHOW CREATE TABLE full_table_name */
  {  220,   -4 }, /* (189) cmd ::= SHOW CREATE STABLE full_table_name */
  {  220,   -2 }, /* (190) cmd ::= SHOW QUERIES */
  {  220,   -2 }, /* (191) cmd ::= SHOW SCORES */
  {  220,   -2 }, /* (192) cmd ::= SHOW TOPICS */
  {  220,   -2 }, /* (193) cmd ::= SHOW VARIABLES */
  {  220,   -2 }, /* (194) cmd ::= SHOW BNODES */
  {  220,   -2 }, /* (195) cmd ::= SHOW SNODES */
  {  259,    0 }, /* (196) db_name_cond_opt ::= */
  {  259,   -2 }, /* (197) db_name_cond_opt ::= db_name NK_DOT */
  {  260,    0 }, /* (198) like_pattern_opt ::= */
  {  260,   -2 }, /* (199) like_pattern_opt ::= LIKE NK_STRING */
  {  261,   -1 }, /* (200) table_name_cond ::= table_name */
  {  262,    0 }, /* (201) from_db_opt ::= */
  {  262,   -2 }, /* (202) from_db_opt ::= FROM db_name */
  {  256,   -1 }, /* (203) func_name_list ::= func_name */
  {  256,   -3 }, /* (204) func_name_list ::= func_name_list NK_COMMA col_name */
  {  263,   -1 }, /* (205) func_name ::= function_name */
  {  220,   -8 }, /* (206) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  220,  -10 }, /* (207) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  220,   -6 }, /* (208) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  266,    0 }, /* (209) index_options ::= */
  {  266,   -9 }, /* (210) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  266,  -11 }, /* (211) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  267,   -1 }, /* (212) func_list ::= func */
  {  267,   -3 }, /* (213) func_list ::= func_list NK_COMMA func */
  {  270,   -4 }, /* (214) func ::= function_name NK_LP expression_list NK_RP */
  {  220,   -6 }, /* (215) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  220,   -6 }, /* (216) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  220,   -4 }, /* (217) cmd ::= DROP TOPIC exists_opt topic_name */
  {  220,   -2 }, /* (218) cmd ::= DESC full_table_name */
  {  220,   -2 }, /* (219) cmd ::= DESCRIBE full_table_name */
  {  220,   -3 }, /* (220) cmd ::= RESET QUERY CACHE */
  {  220,   -4 }, /* (221) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  274,    0 }, /* (222) analyze_opt ::= */
  {  274,   -1 }, /* (223) analyze_opt ::= ANALYZE */
  {  275,    0 }, /* (224) explain_options ::= */
  {  275,   -3 }, /* (225) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  275,   -3 }, /* (226) explain_options ::= explain_options RATIO NK_FLOAT */
  {  220,   -6 }, /* (227) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  220,   -9 }, /* (228) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  220,   -3 }, /* (229) cmd ::= DROP FUNCTION function_name */
  {  276,    0 }, /* (230) agg_func_opt ::= */
  {  276,   -1 }, /* (231) agg_func_opt ::= AGGREGATE */
  {  277,    0 }, /* (232) bufsize_opt ::= */
  {  277,   -2 }, /* (233) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  220,   -8 }, /* (234) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  220,   -4 }, /* (235) cmd ::= DROP STREAM exists_opt stream_name */
  {  280,    0 }, /* (236) into_opt ::= */
  {  280,   -2 }, /* (237) into_opt ::= INTO full_table_name */
  {  279,    0 }, /* (238) stream_options ::= */
  {  279,   -3 }, /* (239) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  279,   -3 }, /* (240) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  279,   -3 }, /* (241) stream_options ::= stream_options WATERMARK duration_literal */
  {  220,   -3 }, /* (242) cmd ::= KILL CONNECTION NK_INTEGER */
  {  220,   -3 }, /* (243) cmd ::= KILL QUERY NK_INTEGER */
  {  220,   -4 }, /* (244) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  220,   -4 }, /* (245) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  220,   -3 }, /* (246) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  281,   -2 }, /* (247) dnode_list ::= DNODE NK_INTEGER */
  {  281,   -3 }, /* (248) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  220,   -3 }, /* (249) cmd ::= SYNCDB db_name REPLICA */
  {  220,   -1 }, /* (250) cmd ::= query_expression */
  {  223,   -1 }, /* (251) literal ::= NK_INTEGER */
  {  223,   -1 }, /* (252) literal ::= NK_FLOAT */
  {  223,   -1 }, /* (253) literal ::= NK_STRING */
  {  223,   -1 }, /* (254) literal ::= NK_BOOL */
  {  223,   -2 }, /* (255) literal ::= TIMESTAMP NK_STRING */
  {  223,   -1 }, /* (256) literal ::= duration_literal */
  {  223,   -1 }, /* (257) literal ::= NULL */
  {  223,   -1 }, /* (258) literal ::= NK_QUESTION */
  {  268,   -1 }, /* (259) duration_literal ::= NK_VARIABLE */
  {  282,   -1 }, /* (260) signed ::= NK_INTEGER */
  {  282,   -2 }, /* (261) signed ::= NK_PLUS NK_INTEGER */
  {  282,   -2 }, /* (262) signed ::= NK_MINUS NK_INTEGER */
  {  282,   -1 }, /* (263) signed ::= NK_FLOAT */
  {  282,   -2 }, /* (264) signed ::= NK_PLUS NK_FLOAT */
  {  282,   -2 }, /* (265) signed ::= NK_MINUS NK_FLOAT */
  {  283,   -1 }, /* (266) signed_literal ::= signed */
  {  283,   -1 }, /* (267) signed_literal ::= NK_STRING */
  {  283,   -1 }, /* (268) signed_literal ::= NK_BOOL */
  {  283,   -2 }, /* (269) signed_literal ::= TIMESTAMP NK_STRING */
  {  283,   -1 }, /* (270) signed_literal ::= duration_literal */
  {  283,   -1 }, /* (271) signed_literal ::= NULL */
  {  251,   -1 }, /* (272) literal_list ::= signed_literal */
  {  251,   -3 }, /* (273) literal_list ::= literal_list NK_COMMA signed_literal */
  {  229,   -1 }, /* (274) db_name ::= NK_ID */
  {  254,   -1 }, /* (275) table_name ::= NK_ID */
  {  247,   -1 }, /* (276) column_name ::= NK_ID */
  {  264,   -1 }, /* (277) function_name ::= NK_ID */
  {  284,   -1 }, /* (278) table_alias ::= NK_ID */
  {  285,   -1 }, /* (279) column_alias ::= NK_ID */
  {  225,   -1 }, /* (280) user_name ::= NK_ID */
  {  265,   -1 }, /* (281) index_name ::= NK_ID */
  {  272,   -1 }, /* (282) topic_name ::= NK_ID */
  {  278,   -1 }, /* (283) stream_name ::= NK_ID */
  {  286,   -1 }, /* (284) expression ::= literal */
  {  286,   -1 }, /* (285) expression ::= pseudo_column */
  {  286,   -1 }, /* (286) expression ::= column_reference */
  {  286,   -1 }, /* (287) expression ::= function_expression */
  {  286,   -1 }, /* (288) expression ::= subquery */
  {  286,   -3 }, /* (289) expression ::= NK_LP expression NK_RP */
  {  286,   -2 }, /* (290) expression ::= NK_PLUS expression */
  {  286,   -2 }, /* (291) expression ::= NK_MINUS expression */
  {  286,   -3 }, /* (292) expression ::= expression NK_PLUS expression */
  {  286,   -3 }, /* (293) expression ::= expression NK_MINUS expression */
  {  286,   -3 }, /* (294) expression ::= expression NK_STAR expression */
  {  286,   -3 }, /* (295) expression ::= expression NK_SLASH expression */
  {  286,   -3 }, /* (296) expression ::= expression NK_REM expression */
  {  286,   -3 }, /* (297) expression ::= column_reference NK_ARROW NK_STRING */
  {  271,   -1 }, /* (298) expression_list ::= expression */
  {  271,   -3 }, /* (299) expression_list ::= expression_list NK_COMMA expression */
  {  288,   -1 }, /* (300) column_reference ::= column_name */
  {  288,   -3 }, /* (301) column_reference ::= table_name NK_DOT column_name */
  {  287,   -1 }, /* (302) pseudo_column ::= ROWTS */
  {  287,   -1 }, /* (303) pseudo_column ::= TBNAME */
  {  287,   -1 }, /* (304) pseudo_column ::= QSTARTTS */
  {  287,   -1 }, /* (305) pseudo_column ::= QENDTS */
  {  287,   -1 }, /* (306) pseudo_column ::= WSTARTTS */
  {  287,   -1 }, /* (307) pseudo_column ::= WENDTS */
  {  287,   -1 }, /* (308) pseudo_column ::= WDURATION */
  {  289,   -4 }, /* (309) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  289,   -4 }, /* (310) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  289,   -6 }, /* (311) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  289,   -3 }, /* (312) function_expression ::= noarg_func NK_LP NK_RP */
  {  293,   -1 }, /* (313) noarg_func ::= NOW */
  {  293,   -1 }, /* (314) noarg_func ::= TODAY */
  {  293,   -1 }, /* (315) noarg_func ::= TIMEZONE */
  {  291,   -1 }, /* (316) star_func ::= COUNT */
  {  291,   -1 }, /* (317) star_func ::= FIRST */
  {  291,   -1 }, /* (318) star_func ::= LAST */
  {  291,   -1 }, /* (319) star_func ::= LAST_ROW */
  {  292,   -1 }, /* (320) star_func_para_list ::= NK_STAR */
  {  292,   -1 }, /* (321) star_func_para_list ::= other_para_list */
  {  294,   -1 }, /* (322) other_para_list ::= star_func_para */
  {  294,   -3 }, /* (323) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  295,   -1 }, /* (324) star_func_para ::= expression */
  {  295,   -3 }, /* (325) star_func_para ::= table_name NK_DOT NK_STAR */
  {  296,   -3 }, /* (326) predicate ::= expression compare_op expression */
  {  296,   -5 }, /* (327) predicate ::= expression BETWEEN expression AND expression */
  {  296,   -6 }, /* (328) predicate ::= expression NOT BETWEEN expression AND expression */
  {  296,   -3 }, /* (329) predicate ::= expression IS NULL */
  {  296,   -4 }, /* (330) predicate ::= expression IS NOT NULL */
  {  296,   -3 }, /* (331) predicate ::= expression in_op in_predicate_value */
  {  297,   -1 }, /* (332) compare_op ::= NK_LT */
  {  297,   -1 }, /* (333) compare_op ::= NK_GT */
  {  297,   -1 }, /* (334) compare_op ::= NK_LE */
  {  297,   -1 }, /* (335) compare_op ::= NK_GE */
  {  297,   -1 }, /* (336) compare_op ::= NK_NE */
  {  297,   -1 }, /* (337) compare_op ::= NK_EQ */
  {  297,   -1 }, /* (338) compare_op ::= LIKE */
  {  297,   -2 }, /* (339) compare_op ::= NOT LIKE */
  {  297,   -1 }, /* (340) compare_op ::= MATCH */
  {  297,   -1 }, /* (341) compare_op ::= NMATCH */
  {  297,   -1 }, /* (342) compare_op ::= CONTAINS */
  {  298,   -1 }, /* (343) in_op ::= IN */
  {  298,   -2 }, /* (344) in_op ::= NOT IN */
  {  299,   -3 }, /* (345) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  300,   -1 }, /* (346) boolean_value_expression ::= boolean_primary */
  {  300,   -2 }, /* (347) boolean_value_expression ::= NOT boolean_primary */
  {  300,   -3 }, /* (348) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  300,   -3 }, /* (349) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  301,   -1 }, /* (350) boolean_primary ::= predicate */
  {  301,   -3 }, /* (351) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  302,   -1 }, /* (352) common_expression ::= expression */
  {  302,   -1 }, /* (353) common_expression ::= boolean_value_expression */
  {  303,   -2 }, /* (354) from_clause ::= FROM table_reference_list */
  {  304,   -1 }, /* (355) table_reference_list ::= table_reference */
  {  304,   -3 }, /* (356) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  305,   -1 }, /* (357) table_reference ::= table_primary */
  {  305,   -1 }, /* (358) table_reference ::= joined_table */
  {  306,   -2 }, /* (359) table_primary ::= table_name alias_opt */
  {  306,   -4 }, /* (360) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  306,   -2 }, /* (361) table_primary ::= subquery alias_opt */
  {  306,   -1 }, /* (362) table_primary ::= parenthesized_joined_table */
  {  308,    0 }, /* (363) alias_opt ::= */
  {  308,   -1 }, /* (364) alias_opt ::= table_alias */
  {  308,   -2 }, /* (365) alias_opt ::= AS table_alias */
  {  309,   -3 }, /* (366) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  309,   -3 }, /* (367) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  307,   -6 }, /* (368) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  310,    0 }, /* (369) join_type ::= */
  {  310,   -1 }, /* (370) join_type ::= INNER */
  {  312,   -9 }, /* (371) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  313,    0 }, /* (372) set_quantifier_opt ::= */
  {  313,   -1 }, /* (373) set_quantifier_opt ::= DISTINCT */
  {  313,   -1 }, /* (374) set_quantifier_opt ::= ALL */
  {  314,   -1 }, /* (375) select_list ::= NK_STAR */
  {  314,   -1 }, /* (376) select_list ::= select_sublist */
  {  320,   -1 }, /* (377) select_sublist ::= select_item */
  {  320,   -3 }, /* (378) select_sublist ::= select_sublist NK_COMMA select_item */
  {  321,   -1 }, /* (379) select_item ::= common_expression */
  {  321,   -2 }, /* (380) select_item ::= common_expression column_alias */
  {  321,   -3 }, /* (381) select_item ::= common_expression AS column_alias */
  {  321,   -3 }, /* (382) select_item ::= table_name NK_DOT NK_STAR */
  {  315,    0 }, /* (383) where_clause_opt ::= */
  {  315,   -2 }, /* (384) where_clause_opt ::= WHERE search_condition */
  {  316,    0 }, /* (385) partition_by_clause_opt ::= */
  {  316,   -3 }, /* (386) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  317,    0 }, /* (387) twindow_clause_opt ::= */
  {  317,   -6 }, /* (388) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  317,   -4 }, /* (389) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  317,   -6 }, /* (390) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  317,   -8 }, /* (391) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  269,    0 }, /* (392) sliding_opt ::= */
  {  269,   -4 }, /* (393) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  322,    0 }, /* (394) fill_opt ::= */
  {  322,   -4 }, /* (395) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  322,   -6 }, /* (396) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  323,   -1 }, /* (397) fill_mode ::= NONE */
  {  323,   -1 }, /* (398) fill_mode ::= PREV */
  {  323,   -1 }, /* (399) fill_mode ::= NULL */
  {  323,   -1 }, /* (400) fill_mode ::= LINEAR */
  {  323,   -1 }, /* (401) fill_mode ::= NEXT */
  {  318,    0 }, /* (402) group_by_clause_opt ::= */
  {  318,   -3 }, /* (403) group_by_clause_opt ::= GROUP BY group_by_list */
  {  324,   -1 }, /* (404) group_by_list ::= expression */
  {  324,   -3 }, /* (405) group_by_list ::= group_by_list NK_COMMA expression */
  {  319,    0 }, /* (406) having_clause_opt ::= */
  {  319,   -2 }, /* (407) having_clause_opt ::= HAVING search_condition */
  {  273,   -4 }, /* (408) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  325,   -1 }, /* (409) query_expression_body ::= query_primary */
  {  325,   -4 }, /* (410) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  329,   -1 }, /* (411) query_primary ::= query_specification */
  {  326,    0 }, /* (412) order_by_clause_opt ::= */
  {  326,   -3 }, /* (413) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  327,    0 }, /* (414) slimit_clause_opt ::= */
  {  327,   -2 }, /* (415) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  327,   -4 }, /* (416) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  327,   -4 }, /* (417) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  328,    0 }, /* (418) limit_clause_opt ::= */
  {  328,   -2 }, /* (419) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  328,   -4 }, /* (420) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  328,   -4 }, /* (421) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  290,   -3 }, /* (422) subquery ::= NK_LP query_expression NK_RP */
  {  311,   -1 }, /* (423) search_condition ::= common_expression */
  {  330,   -1 }, /* (424) sort_specification_list ::= sort_specification */
  {  330,   -3 }, /* (425) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  331,   -3 }, /* (426) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  332,    0 }, /* (427) ordering_specification_opt ::= */
  {  332,   -1 }, /* (428) ordering_specification_opt ::= ASC */
  {  332,   -1 }, /* (429) ordering_specification_opt ::= DESC */
  {  333,    0 }, /* (430) null_ordering_opt ::= */
  {  333,   -2 }, /* (431) null_ordering_opt ::= NULLS FIRST */
  {  333,   -2 }, /* (432) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,221,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,222,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,221,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,223,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,224,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,222,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,224,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,223,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy537, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy537, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy537); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy537, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy537); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 274: /* db_name ::= NK_ID */ yytestcase(yyruleno==274);
      case 275: /* table_name ::= NK_ID */ yytestcase(yyruleno==275);
      case 276: /* column_name ::= NK_ID */ yytestcase(yyruleno==276);
      case 277: /* function_name ::= NK_ID */ yytestcase(yyruleno==277);
      case 278: /* table_alias ::= NK_ID */ yytestcase(yyruleno==278);
      case 279: /* column_alias ::= NK_ID */ yytestcase(yyruleno==279);
      case 280: /* user_name ::= NK_ID */ yytestcase(yyruleno==280);
      case 281: /* index_name ::= NK_ID */ yytestcase(yyruleno==281);
      case 282: /* topic_name ::= NK_ID */ yytestcase(yyruleno==282);
      case 283: /* stream_name ::= NK_ID */ yytestcase(yyruleno==283);
      case 313: /* noarg_func ::= NOW */ yytestcase(yyruleno==313);
      case 314: /* noarg_func ::= TODAY */ yytestcase(yyruleno==314);
      case 315: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==315);
      case 316: /* star_func ::= COUNT */ yytestcase(yyruleno==316);
      case 317: /* star_func ::= FIRST */ yytestcase(yyruleno==317);
      case 318: /* star_func ::= LAST */ yytestcase(yyruleno==318);
      case 319: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==319);
{ yylhsminor.yy537 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy537 = yylhsminor.yy537;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy649, &yymsp[-1].minor.yy537, yymsp[0].minor.yy456); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy649, &yymsp[0].minor.yy537); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy537); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy537, yymsp[0].minor.yy456); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy649 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 222: /* analyze_opt ::= */ yytestcase(yyruleno==222);
      case 230: /* agg_func_opt ::= */ yytestcase(yyruleno==230);
      case 372: /* set_quantifier_opt ::= */ yytestcase(yyruleno==372);
{ yymsp[1].minor.yy649 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy649 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy456 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pKeep = yymsp[0].minor.yy632; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pRetentions = yymsp[0].minor.yy632; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 78: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy456 = createDatabaseOptions(pCxt); yylhsminor.yy456 = setDatabaseAlterOption(pCxt, yylhsminor.yy456, &yymsp[0].minor.yy29); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 79: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy456 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy456, &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 80: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 81: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= KEEP integer_list */
      case 83: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==83);
{ yymsp[-1].minor.yy29.type = DB_OPTION_KEEP; yymsp[-1].minor.yy29.pList = yymsp[0].minor.yy632; }
        break;
      case 84: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_WAL; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 85: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy29.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy632 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 89: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 248: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==248);
{ yylhsminor.yy632 = addNodeToList(pCxt, yymsp[-2].minor.yy632, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 90: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy632 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 91: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy632 = addNodeToList(pCxt, yymsp[-2].minor.yy632, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 92: /* retention_list ::= retention */
      case 112: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==112);
      case 115: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==115);
      case 122: /* column_def_list ::= column_def */ yytestcase(yyruleno==122);
      case 167: /* col_name_list ::= col_name */ yytestcase(yyruleno==167);
      case 203: /* func_name_list ::= func_name */ yytestcase(yyruleno==203);
      case 212: /* func_list ::= func */ yytestcase(yyruleno==212);
      case 272: /* literal_list ::= signed_literal */ yytestcase(yyruleno==272);
      case 322: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==322);
      case 377: /* select_sublist ::= select_item */ yytestcase(yyruleno==377);
      case 424: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==424);
{ yylhsminor.yy632 = createNodeList(pCxt, yymsp[0].minor.yy456); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 93: /* retention_list ::= retention_list NK_COMMA retention */
      case 123: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==123);
      case 168: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==168);
      case 204: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==204);
      case 213: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==213);
      case 273: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==273);
      case 323: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==323);
      case 378: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==378);
      case 425: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==425);
{ yylhsminor.yy632 = addNodeToList(pCxt, yymsp[-2].minor.yy632, yymsp[0].minor.yy456); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 94: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy456 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 95: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 97: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==97);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy649, yymsp[-5].minor.yy456, yymsp[-3].minor.yy632, yymsp[-1].minor.yy632, yymsp[0].minor.yy456); }
        break;
      case 96: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy632); }
        break;
      case 98: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy632); }
        break;
      case 99: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy649, yymsp[0].minor.yy456); }
        break;
      case 100: /* cmd ::= ALTER TABLE alter_table_clause */
      case 101: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==101);
      case 250: /* cmd ::= query_expression */ yytestcase(yyruleno==250);
{ pCxt->pRootNode = yymsp[0].minor.yy456; }
        break;
      case 102: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy456 = createAlterTableOption(pCxt, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 103: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy537, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 104: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy456 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy456, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy537); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 105: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy537, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 106: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy456 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy537, &yymsp[0].minor.yy537); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 107: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy537, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 108: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy456 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy456, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy537); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 109: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy537, yymsp[0].minor.yy388); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 110: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy456 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy537, &yymsp[0].minor.yy537); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 111: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy456 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy456, &yymsp[-2].minor.yy537, yymsp[0].minor.yy456); }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 113: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 116: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==116);
{ yylhsminor.yy632 = addNodeToList(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy456); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 114: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy456 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy649, yymsp[-7].minor.yy456, yymsp[-5].minor.yy456, yymsp[-4].minor.yy632, yymsp[-1].minor.yy632); }
  yymsp[-8].minor.yy456 = yylhsminor.yy456;
        break;
      case 117: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy456 = createDropTableClause(pCxt, yymsp[-1].minor.yy649, yymsp[0].minor.yy456); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 118: /* specific_tags_opt ::= */
      case 149: /* tags_def_opt ::= */ yytestcase(yyruleno==149);
      case 385: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==385);
      case 402: /* group_by_clause_opt ::= */ yytestcase(yyruleno==402);
      case 412: /* order_by_clause_opt ::= */ yytestcase(yyruleno==412);
{ yymsp[1].minor.yy632 = NULL; }
        break;
      case 119: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy632 = yymsp[-1].minor.yy632; }
        break;
      case 120: /* full_table_name ::= table_name */
{ yylhsminor.yy456 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy537, NULL); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 121: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy456 = createRealTableNode(pCxt, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy537, NULL); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 124: /* column_def ::= column_name type_name */
{ yylhsminor.yy456 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy537, yymsp[0].minor.yy388, NULL); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 125: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy456 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy537, yymsp[-2].minor.yy388, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 126: /* type_name ::= BOOL */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 127: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 128: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 129: /* type_name ::= INT */
      case 130: /* type_name ::= INTEGER */ yytestcase(yyruleno==130);
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 131: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 132: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 133: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 134: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 135: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 136: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 139: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 140: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 141: /* type_name ::= JSON */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 142: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 143: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 144: /* type_name ::= BLOB */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 145: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 147: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 148: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* tags_def_opt ::= tags_def */
      case 321: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==321);
      case 376: /* select_list ::= select_sublist */ yytestcase(yyruleno==376);
{ yylhsminor.yy632 = yymsp[0].minor.yy632; }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 151: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy632 = yymsp[-1].minor.yy632; }
        break;
      case 152: /* table_options ::= */
{ yymsp[1].minor.yy456 = createTableOptions(pCxt); }
        break;
      case 153: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 154: /* table_options ::= table_options KEEP integer_list */
      case 155: /* table_options ::= table_options KEEP variable_list */ yytestcase(yyruleno==155);
{ ((STableOptions*)yymsp[-2].minor.yy456)->pKeep = yymsp[0].minor.yy632; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 156: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 157: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy456)->pSma = yymsp[-1].minor.yy632; yylhsminor.yy456 = yymsp[-4].minor.yy456; }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 158: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy456)->pFuncs = yymsp[-1].minor.yy632; yylhsminor.yy456 = yymsp[-4].minor.yy456; }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 159: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 160: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 161: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy456 = createTableOptions(pCxt); yylhsminor.yy456 = setTableAlterOption(pCxt, yylhsminor.yy456, &yymsp[0].minor.yy29); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 162: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy456 = setTableAlterOption(pCxt, yymsp[-1].minor.yy456, &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 163: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy29.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 164: /* alter_table_option ::= KEEP integer_list */
      case 165: /* alter_table_option ::= KEEP variable_list */ yytestcase(yyruleno==165);
{ yymsp[-1].minor.yy29.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy29.pList = yymsp[0].minor.yy632; }
        break;
      case 166: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy29.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy29.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 169: /* col_name ::= column_name */
{ yylhsminor.yy456 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy537); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 170: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 171: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 172: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 173: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 174: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 175: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy456, NULL); }
        break;
      case 176: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 181: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 183: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW LICENCE */
      case 186: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==186);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy537); }
        break;
      case 188: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy456); }
        break;
      case 189: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy456); }
        break;
      case 190: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 195: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 196: /* db_name_cond_opt ::= */
      case 201: /* from_db_opt ::= */ yytestcase(yyruleno==201);
{ yymsp[1].minor.yy456 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 197: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy537); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 198: /* like_pattern_opt ::= */
      case 209: /* index_options ::= */ yytestcase(yyruleno==209);
      case 236: /* into_opt ::= */ yytestcase(yyruleno==236);
      case 383: /* where_clause_opt ::= */ yytestcase(yyruleno==383);
      case 387: /* twindow_clause_opt ::= */ yytestcase(yyruleno==387);
      case 392: /* sliding_opt ::= */ yytestcase(yyruleno==392);
      case 394: /* fill_opt ::= */ yytestcase(yyruleno==394);
      case 406: /* having_clause_opt ::= */ yytestcase(yyruleno==406);
      case 414: /* slimit_clause_opt ::= */ yytestcase(yyruleno==414);
      case 418: /* limit_clause_opt ::= */ yytestcase(yyruleno==418);
{ yymsp[1].minor.yy456 = NULL; }
        break;
      case 199: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 200: /* table_name_cond ::= table_name */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy537); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 202: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy537); }
        break;
      case 205: /* func_name ::= function_name */
{ yylhsminor.yy456 = createFunctionNode(pCxt, &yymsp[0].minor.yy537, NULL); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 206: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy649, &yymsp[-3].minor.yy537, &yymsp[-1].minor.yy537, NULL, yymsp[0].minor.yy456); }
        break;
      case 207: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy649, &yymsp[-5].minor.yy537, &yymsp[-3].minor.yy537, yymsp[-1].minor.yy632, NULL); }
        break;
      case 208: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy649, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy537); }
        break;
      case 210: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy456 = createIndexOption(pCxt, yymsp[-6].minor.yy632, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), NULL, yymsp[0].minor.yy456); }
        break;
      case 211: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy456 = createIndexOption(pCxt, yymsp[-8].minor.yy632, releaseRawExprNode(pCxt, yymsp[-4].minor.yy456), releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), yymsp[0].minor.yy456); }
        break;
      case 214: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy456 = createFunctionNode(pCxt, &yymsp[-3].minor.yy537, yymsp[-1].minor.yy632); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 215: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy649, &yymsp[-2].minor.yy537, yymsp[0].minor.yy456, NULL); }
        break;
      case 216: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy649, &yymsp[-2].minor.yy537, NULL, &yymsp[0].minor.yy537); }
        break;
      case 217: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy649, &yymsp[0].minor.yy537); }
        break;
      case 218: /* cmd ::= DESC full_table_name */
      case 219: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==219);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy456); }
        break;
      case 220: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 221: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy649, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 223: /* analyze_opt ::= ANALYZE */
      case 231: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==231);
      case 373: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==373);
{ yymsp[0].minor.yy649 = true; }
        break;
      case 224: /* explain_options ::= */
{ yymsp[1].minor.yy456 = createDefaultExplainOptions(pCxt); }
        break;
      case 225: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy456 = setExplainVerbose(pCxt, yymsp[-2].minor.yy456, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 226: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy456 = setExplainRatio(pCxt, yymsp[-2].minor.yy456, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 227: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy632); }
        break;
      case 228: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy649, &yymsp[-5].minor.yy537, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy388, yymsp[0].minor.yy652); }
        break;
      case 229: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy537); }
        break;
      case 232: /* bufsize_opt ::= */
{ yymsp[1].minor.yy652 = 0; }
        break;
      case 233: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy652 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 234: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy649, &yymsp[-4].minor.yy537, yymsp[-2].minor.yy456, yymsp[-3].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 235: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy649, &yymsp[0].minor.yy537); }
        break;
      case 237: /* into_opt ::= INTO full_table_name */
      case 354: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==354);
      case 384: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==384);
      case 407: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==407);
{ yymsp[-1].minor.yy456 = yymsp[0].minor.yy456; }
        break;
      case 238: /* stream_options ::= */
{ yymsp[1].minor.yy456 = createStreamOptions(pCxt); }
        break;
      case 239: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy456)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 240: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy456)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 241: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy456)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy456); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 242: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 243: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 244: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 245: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy632); }
        break;
      case 246: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 247: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy632 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 249: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy537); }
        break;
      case 251: /* literal ::= NK_INTEGER */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 252: /* literal ::= NK_FLOAT */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 253: /* literal ::= NK_STRING */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 254: /* literal ::= NK_BOOL */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 255: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 256: /* literal ::= duration_literal */
      case 266: /* signed_literal ::= signed */ yytestcase(yyruleno==266);
      case 284: /* expression ::= literal */ yytestcase(yyruleno==284);
      case 285: /* expression ::= pseudo_column */ yytestcase(yyruleno==285);
      case 286: /* expression ::= column_reference */ yytestcase(yyruleno==286);
      case 287: /* expression ::= function_expression */ yytestcase(yyruleno==287);
      case 288: /* expression ::= subquery */ yytestcase(yyruleno==288);
      case 346: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==346);
      case 350: /* boolean_primary ::= predicate */ yytestcase(yyruleno==350);
      case 352: /* common_expression ::= expression */ yytestcase(yyruleno==352);
      case 353: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==353);
      case 355: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==355);
      case 357: /* table_reference ::= table_primary */ yytestcase(yyruleno==357);
      case 358: /* table_reference ::= joined_table */ yytestcase(yyruleno==358);
      case 362: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==362);
      case 409: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==409);
      case 411: /* query_primary ::= query_specification */ yytestcase(yyruleno==411);
{ yylhsminor.yy456 = yymsp[0].minor.yy456; }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 257: /* literal ::= NULL */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 258: /* literal ::= NK_QUESTION */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 259: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 260: /* signed ::= NK_INTEGER */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 261: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 262: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 263: /* signed ::= NK_FLOAT */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 264: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 265: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 267: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 268: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 269: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 270: /* signed_literal ::= duration_literal */
      case 324: /* star_func_para ::= expression */ yytestcase(yyruleno==324);
      case 379: /* select_item ::= common_expression */ yytestcase(yyruleno==379);
      case 423: /* search_condition ::= common_expression */ yytestcase(yyruleno==423);
{ yylhsminor.yy456 = releaseRawExprNode(pCxt, yymsp[0].minor.yy456); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 271: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 289: /* expression ::= NK_LP expression NK_RP */
      case 351: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==351);
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 290: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy456));
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 291: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy456), NULL));
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 292: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 293: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 294: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 295: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 296: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 297: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 298: /* expression_list ::= expression */
{ yylhsminor.yy632 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy456)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 299: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy632 = addNodeToList(pCxt, yymsp[-2].minor.yy632, releaseRawExprNode(pCxt, yymsp[0].minor.yy456)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 300: /* column_reference ::= column_name */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy537, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy537)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 301: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy537, createColumnNode(pCxt, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy537)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 302: /* pseudo_column ::= ROWTS */
      case 303: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==303);
      case 304: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==304);
      case 305: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==305);
      case 306: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==306);
      case 307: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==307);
      case 308: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==308);
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 309: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 310: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==310);
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy537, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy537, yymsp[-1].minor.yy632)); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 311: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), yymsp[-1].minor.yy388)); }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 312: /* function_expression ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy0, createFunctionNodeNoArg(pCxt, &yymsp[-2].minor.yy537)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 320: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy632 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 325: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 382: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==382);
{ yylhsminor.yy456 = createColumnNode(pCxt, &yymsp[-2].minor.yy537, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 326: /* predicate ::= expression compare_op expression */
      case 331: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==331);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy416, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 327: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy456), releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 328: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy456), releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 329: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), NULL));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 330: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), NULL));
                                                                                  }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 332: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy416 = OP_TYPE_LOWER_THAN; }
        break;
      case 333: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy416 = OP_TYPE_GREATER_THAN; }
        break;
      case 334: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy416 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 335: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy416 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 336: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy416 = OP_TYPE_NOT_EQUAL; }
        break;
      case 337: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy416 = OP_TYPE_EQUAL; }
        break;
      case 338: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy416 = OP_TYPE_LIKE; }
        break;
      case 339: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy416 = OP_TYPE_NOT_LIKE; }
        break;
      case 340: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy416 = OP_TYPE_MATCH; }
        break;
      case 341: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy416 = OP_TYPE_NMATCH; }
        break;
      case 342: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy416 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 343: /* in_op ::= IN */
{ yymsp[0].minor.yy416 = OP_TYPE_IN; }
        break;
      case 344: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy416 = OP_TYPE_NOT_IN; }
        break;
      case 345: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy632)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 347: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy456), NULL));
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 348: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 349: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 356: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy456 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy456, yymsp[0].minor.yy456, NULL); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 359: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy456 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy537, &yymsp[0].minor.yy537); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 360: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy456 = createRealTableNode(pCxt, &yymsp[-3].minor.yy537, &yymsp[-1].minor.yy537, &yymsp[0].minor.yy537); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 361: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy456 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456), &yymsp[0].minor.yy537); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 363: /* alias_opt ::= */
{ yymsp[1].minor.yy537 = nil_token;  }
        break;
      case 364: /* alias_opt ::= table_alias */
{ yylhsminor.yy537 = yymsp[0].minor.yy537; }
  yymsp[0].minor.yy537 = yylhsminor.yy537;
        break;
      case 365: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy537 = yymsp[0].minor.yy537; }
        break;
      case 366: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 367: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==367);
{ yymsp[-2].minor.yy456 = yymsp[-1].minor.yy456; }
        break;
      case 368: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy456 = createJoinTableNode(pCxt, yymsp[-4].minor.yy164, yymsp[-5].minor.yy456, yymsp[-2].minor.yy456, yymsp[0].minor.yy456); }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 369: /* join_type ::= */
{ yymsp[1].minor.yy164 = JOIN_TYPE_INNER; }
        break;
      case 370: /* join_type ::= INNER */
{ yymsp[0].minor.yy164 = JOIN_TYPE_INNER; }
        break;
      case 371: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy456 = createSelectStmt(pCxt, yymsp[-7].minor.yy649, yymsp[-6].minor.yy632, yymsp[-5].minor.yy456);
                                                                                    yymsp[-8].minor.yy456 = addWhereClause(pCxt, yymsp[-8].minor.yy456, yymsp[-4].minor.yy456);
                                                                                    yymsp[-8].minor.yy456 = addPartitionByClause(pCxt, yymsp[-8].minor.yy456, yymsp[-3].minor.yy632);
                                                                                    yymsp[-8].minor.yy456 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy456, yymsp[-2].minor.yy456);
                                                                                    yymsp[-8].minor.yy456 = addGroupByClause(pCxt, yymsp[-8].minor.yy456, yymsp[-1].minor.yy632);
                                                                                    yymsp[-8].minor.yy456 = addHavingClause(pCxt, yymsp[-8].minor.yy456, yymsp[0].minor.yy456);
                                                                                  }
        break;
      case 374: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy649 = false; }
        break;
      case 375: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy632 = NULL; }
        break;
      case 380: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy456 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456), &yymsp[0].minor.yy537); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 381: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy456 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), &yymsp[0].minor.yy537); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 386: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 403: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==403);
      case 413: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==413);
{ yymsp[-2].minor.yy632 = yymsp[0].minor.yy632; }
        break;
      case 388: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy456 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), releaseRawExprNode(pCxt, yymsp[-1].minor.yy456)); }
        break;
      case 389: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy456 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456)); }
        break;
      case 390: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy456 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), NULL, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 391: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy456 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy456), releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 393: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy456 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy456); }
        break;
      case 395: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy456 = createFillNode(pCxt, yymsp[-1].minor.yy646, NULL); }
        break;
      case 396: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy456 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 397: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy646 = FILL_MODE_NONE; }
        break;
      case 398: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy646 = FILL_MODE_PREV; }
        break;
      case 399: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy646 = FILL_MODE_NULL; }
        break;
      case 400: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy646 = FILL_MODE_LINEAR; }
        break;
      case 401: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy646 = FILL_MODE_NEXT; }
        break;
      case 404: /* group_by_list ::= expression */
{ yylhsminor.yy632 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 405: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy632 = addNodeToList(pCxt, yymsp[-2].minor.yy632, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 408: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy456 = addOrderByClause(pCxt, yymsp[-3].minor.yy456, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy456 = addSlimitClause(pCxt, yylhsminor.yy456, yymsp[-1].minor.yy456);
                                                                                    yylhsminor.yy456 = addLimitClause(pCxt, yylhsminor.yy456, yymsp[0].minor.yy456);
                                                                                  }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 410: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy456 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy456, yymsp[0].minor.yy456); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 415: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 419: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==419);
{ yymsp[-1].minor.yy456 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 416: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 420: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==420);
{ yymsp[-3].minor.yy456 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 417: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 421: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==421);
{ yymsp[-3].minor.yy456 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 422: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy456); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 426: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy456 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), yymsp[-1].minor.yy626, yymsp[0].minor.yy209); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 427: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy626 = ORDER_ASC; }
        break;
      case 428: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy626 = ORDER_ASC; }
        break;
      case 429: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy626 = ORDER_DESC; }
        break;
      case 430: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy209 = NULL_ORDER_DEFAULT; }
        break;
      case 431: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy209 = NULL_ORDER_FIRST; }
        break;
      case 432: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy209 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
