---
title: Get Started
description: This article describes how to install TDengine and test its performance.
---

import github from './github.svg'
import discord from './discord.svg'
import twitter from './twitter.svg'
import youtube from './youtube.svg'
import linkedin from './linkedin.svg'

You can install and run TDengine on Linux/Windows/macOS machines as well as Docker containers. You can also deploy TDengine as a managed service with TDengine Cloud.

The full package of TDengine includes the TDengine Server (`taosd`), TDengine Client (`taosc`), taosAdapter for connecting with third-party systems and providing a RESTful interface, a command-line interface, and some tools. In addition to connectors for multiple languages, TDengine also provides a [RESTful interface](/reference/rest-api) through [taosAdapter](/reference/taosadapter).

```mdx-code-block
import DocCardList from '@theme/DocCardList';
import {useCurrentSidebarCategory} from '@docusaurus/theme-common';

<DocCardList items={useCurrentSidebarCategory().items}/>
```

### Join TDengine Community

<table width="100%">
<tr align="center">
<td width="20%" style="border:0"><a href="https://github.com/taosdata/TDengine" target="_blank"><img src={github} alt="Star GitHub" width="50" /><p>Star GitHub</p></a></td>
<td width="20%" style="border:0"><a href="https://discord.com/invite/VZdSuUg4pS" target="_blank"><img src={discord} alt="Join Discord" width="50" /><p>Join Discord</p></a></td>
<td width="20%" style="border:0"><a href="https://twitter.com/TDengineDB" target="_blank"><img src={twitter} alt="Follow Twitter" width="50" /><p>Follow Twitter</p></a></td>
<td width="20%" style="border:0"><a href="https://www.youtube.com/@tdengine" target="_blank"><img src={youtube} alt="Subscribe YouTube" width="50" /><p>Subscribe YouTube</p></a></td>
<td width="20%" style="border:0"><a href="https://www.linkedin.com/company/tdengine" target="_blank"><img src={linkedin} alt="Follow LinkedIn" width="50" /><p>Follow LinkedIn</p></a></td>
</tr>
</table>
