/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 454
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  ENullOrder yy153;
  SNode* yy164;
  bool yy193;
  SAlterOption yy213;
  EOrder yy238;
  int32_t yy512;
  int64_t yy577;
  SToken yy593;
  EFillMode yy638;
  SNodeList* yy648;
  EOperatorType yy656;
  int8_t yy687;
  SDataType yy720;
  EJoinType yy868;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             705
#define YYNRULE              536
#define YYNTOKEN             319
#define YY_MAX_SHIFT         704
#define YY_MIN_SHIFTREDUCE   1046
#define YY_MAX_SHIFTREDUCE   1581
#define YY_ERROR_ACTION      1582
#define YY_ACCEPT_ACTION     1583
#define YY_NO_ACTION         1584
#define YY_MIN_REDUCE        1585
#define YY_MAX_REDUCE        2120
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3135)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   454, 1936,  455, 1620, 1832,  168,  363,  594,  556, 1783,
 /*    10 */  1785,  556,   44,   42,  462,  182,  455, 1620, 1790, 1922,
 /*    20 */   358,  121, 1362, 1585,   52,  326,  329, 1836,  492,  453,
 /*    30 */  1918, 1954,  457, 1442, 1788, 1360, 1819,  134, 1738,  611,
 /*    40 */   158, 1738,   95, 1727, 1904, 1691,  610,  120,  119,  118,
 /*    50 */   117,  116,  115,  114,  113,  112,  129, 1437,  513, 1914,
 /*    60 */  1920,  346,   17, 1079, 1730,  582,   62,  344,  597, 1368,
 /*    70 */   612,  604, 1388,  523, 1970,  156,  122,   99,  357, 1937,
 /*    80 */   614, 1939, 1940,  609, 1740,  604, 1096,  225, 1095,   40,
 /*    90 */    39,   38, 2023,  439, 2091,    1,  321, 2019,  271, 2031,
 /*   100 */   593,  516,  592, 1083, 1084, 2091,  510, 2091,  397,  581,
 /*   110 */   174,  224,   34,  274, 2092,  583, 1097,  701, 1608,  403,
 /*   120 */   581,  174,  581,  174,  538, 2092,  583, 2092,  583,   37,
 /*   130 */    36, 1444, 1445,   43,   41,   40,   39,   38,   58,  234,
 /*   140 */    47, 1390,  556,   46,   44,   42, 1512,  597,   64,  190,
 /*   150 */   189,   63,  358, 2091, 1362,  179,   58,   58,  317, 1418,
 /*   160 */  1427, 1904,  508,  507,  506, 1442, 1165, 1360, 2097,  174,
 /*   170 */   128,  502, 1738, 2092,  583,  501,  500,   58, 1363,   82,
 /*   180 */  1361,  499,  505, 1247, 1248,  420, 1790,  498, 1387, 1437,
 /*   190 */   597,   37,   36,  345,   17,   43,   41,   40,   39,   38,
 /*   200 */  1167, 1368, 1788, 1366, 1367, 1586, 1417, 1420, 1421, 1422,
 /*   210 */  1423, 1424, 1425, 1426,  606,  602, 1435, 1436, 1438, 1439,
 /*   220 */  1440, 1441, 1443, 1446,    3,   78,  111,    1,  541,  110,
 /*   230 */   109,  108,  107,  106,  105,  104,  103,  102,  396,  127,
 /*   240 */   395,  316,  177, 1385,  538, 1784, 1785, 1387, 1733,  701,
 /*   250 */   433,  111,   65,  444,  110,  109,  108,  107,  106,  105,
 /*   260 */   104,  103,  102, 1444, 1445,   46, 2096, 1790,  542,  582,
 /*   270 */   417,  471,  445, 2091,  362,  419,   44,   42,  343, 1548,
 /*   280 */  1607, 1847,  250, 1788,  358,  177, 1362,  177, 2097,  174,
 /*   290 */   177, 1418, 1427, 2092,  583, 2091, 1388, 1442, 2091, 1360,
 /*   300 */    73,   37,   36,  177,  177,   43,   41,   40,   39,   38,
 /*   310 */  1363, 2095, 1361,  581,  174, 2092, 2094,  330, 2092,  583,
 /*   320 */   572, 1437,   58, 1904,  177, 1387,   17, 1299, 1300,  407,
 /*   330 */    13,   12,  159, 1368, 1597, 1366, 1367,  233, 1417, 1420,
 /*   340 */  1421, 1422, 1423, 1424, 1425, 1426,  606,  602, 1435, 1436,
 /*   350 */  1438, 1439, 1440, 1441, 1443, 1446,    3,  443,  577,    1,
 /*   360 */   438,  437,  436,  435,  432,  431,  430,  429,  428,  424,
 /*   370 */   423,  422,  421,  331,  414,  413,  412,   81,  409,  408,
 /*   380 */   328,  701,   37,   36, 1371,  371,   43,   41,   40,   39,
 /*   390 */    38,  212, 1096,  170, 1095, 1444, 1445,  461, 2096,  392,
 /*   400 */   457,  538,  361,  578,  573,  163, 1777,  211,   44,   42,
 /*   410 */   156,  488,  484,  480,  476,  209,  358,   26, 1362, 1740,
 /*   420 */   394,  390, 1097, 1418, 1427, 1485,   30, 2091,  647, 1442,
 /*   430 */  2091, 1360,   37,   36,  226, 1583,   43,   41,   40,   39,
 /*   440 */    38,   78, 1363, 2095, 1361, 2097,  174, 2092, 2093,  364,
 /*   450 */  2092,  583,   79, 1437, 1954,  207, 1386,  156,   17, 1538,
 /*   460 */   504,  503,  576, 1578, 1734, 1368, 1740, 1366, 1367,  177,
 /*   470 */  1417, 1420, 1421, 1422, 1423, 1424, 1425, 1426,  606,  602,
 /*   480 */  1435, 1436, 1438, 1439, 1440, 1441, 1443, 1446,    3,  522,
 /*   490 */    11,    1,   80,  319, 1083, 1084,  546, 2096,  544,  373,
 /*   500 */  1606,  594,  520,  575,  518, 2038,  370,  569, 1536, 1537,
 /*   510 */  1539, 1540, 1516,  701, 1389,  538,  645,  526, 1387,  239,
 /*   520 */   206,  200,  538,  205,  459, 1605,  467, 1444, 1445, 1374,
 /*   530 */  1385,  134, 2035,  538, 1716,  147,  146,  642,  641,  640,
 /*   540 */    44,   42,  198, 1904, 2091,  556, 1604,  168,  358, 1715,
 /*   550 */  1362, 2091,  558,  639, 1995, 1418, 1427, 1577,  401, 2097,
 /*   560 */   174, 1442, 2091, 1360, 2092,  583, 2097,  174, 1904, 1837,
 /*   570 */   132, 2092,  583, 1452, 1363, 1738, 1361, 2097,  174, 1387,
 /*   580 */  1339, 1340, 2092,  583, 1713, 1437, 1389, 1729, 1603, 1904,
 /*   590 */  1571,  596,  172, 2031, 2032,  471, 2036, 1368, 1918, 1366,
 /*   600 */  1367, 1602, 1417, 1420, 1421, 1422, 1423, 1424, 1425, 1426,
 /*   610 */   606,  602, 1435, 1436, 1438, 1439, 1440, 1441, 1443, 1446,
 /*   620 */     3,  186, 1601,    8,   11, 1850,    9, 1914, 1920,   37,
 /*   630 */    36, 1904,   11,   43,   41,   40,   39,   38, 1473,  604,
 /*   640 */    32, 1600,   88, 1891, 1904,  701,   37,   36,  672,  670,
 /*   650 */    43,   41,   40,   39,   38,  273,  645, 1419,   75, 1444,
 /*   660 */  1445,   74,   37,   36, 1731, 1904,   43,   41,   40,   39,
 /*   670 */    38, 2038,   44,   42, 1447,  147,  146,  642,  641,  640,
 /*   680 */   358, 1923, 1362,  322, 1904, 1936,  556, 1418, 1427, 1790,
 /*   690 */   380,  645, 1918, 1442,  556, 1360,   37,   36, 2034,  402,
 /*   700 */    43,   41,   40,   39,   38, 1789, 1363,  411, 1361,   31,
 /*   710 */   147,  146,  642,  641,  640, 1954, 1738, 1437, 1419, 1478,
 /*   720 */  1368, 1914, 1920,  598, 1738, 1471,  659,  273, 1904, 1368,
 /*   730 */   610, 1366, 1367,  604, 1417, 1420, 1421, 1422, 1423, 1424,
 /*   740 */  1425, 1426,  606,  602, 1435, 1436, 1438, 1439, 1440, 1441,
 /*   750 */  1443, 1446,    3, 1509, 1934,    8, 1599,  145, 1970, 1596,
 /*   760 */  1832,   98, 1935, 1937,  614, 1939, 1940,  609, 1714,  604,
 /*   770 */   177,  184,  227,  334,  171, 1768, 2023,  701, 1595, 1472,
 /*   780 */   351, 2019,   37,   36, 1528, 1594,   43,   41,   40,   39,
 /*   790 */    38, 1444, 1445,  176,   43,   41,   40,   39,   38, 1904,
 /*   800 */   556, 2049, 1904,  556,   44,   42, 1832,  560, 2038, 1995,
 /*   810 */    51,  556,  358,  425, 1362,  155,  121,  188,  556, 1418,
 /*   820 */  1427, 1904, 1390,  497,  426, 1442, 2095, 1360, 1904,  647,
 /*   830 */  1738,  469,  556, 1738,  335, 2033,  333,  332, 1363,  494,
 /*   840 */  1361, 1738, 1390,  496, 1846,  470,  312, 1387, 1738, 1437,
 /*   850 */    33,  355, 1466, 1467, 1468, 1469, 1470, 1474, 1475, 1476,
 /*   860 */  1477, 1368, 1738, 1366, 1367,  495, 1417, 1420, 1421, 1422,
 /*   870 */  1423, 1424, 1425, 1426,  606,  602, 1435, 1436, 1438, 1439,
 /*   880 */  1440, 1441, 1443, 1446,    3,  240,  241,    8, 1205,  636,
 /*   890 */   635,  634, 1209,  633, 1211, 1212,  632, 1214,  629, 1593,
 /*   900 */  1220,  626, 1222, 1223,  623,  620,  542,  156,  556,  701,
 /*   910 */  1592, 2043, 1505,  556, 1922, 1845, 1741,  312,  404, 1848,
 /*   920 */     7, 1735, 1591, 1444, 1445, 1918,  139,  660,  556, 1708,
 /*   930 */  1590,  405, 1589, 1588,  556,   45,   44,   42, 1738,   48,
 /*   940 */     4,  534, 1904, 1738,  358,  319, 1362,  539,  546,  556,
 /*   950 */   544, 1418, 1427, 1904, 1914, 1920,  352, 1442, 1738, 1360,
 /*   960 */  1652,  556,  244,  183, 1738, 1904,  604,  496,  643,  238,
 /*   970 */  1363, 1781, 1361, 1904,  552, 1904, 1904,  130,  533, 1738,
 /*   980 */  1994, 1437,  644,  249,  286, 1781, 1419, 1768, 1310,  495,
 /*   990 */   586, 1738, 1508, 1368, 1723, 1366, 1367, 1936, 1417, 1420,
 /*  1000 */  1421, 1422, 1423, 1424, 1425, 1426,  606,  602, 1435, 1436,
 /*  1010 */  1438, 1439, 1440, 1441, 1443, 1446,    3,  556,  140,    1,
 /*  1020 */   137,  123,  242,  556,  508,  507,  506, 1954,  594,  589,
 /*  1030 */   554,  217,  128,  502,  215,  598,  555,  501,  500,  556,
 /*  1040 */  1904,  701,  610,  499,  505,  219, 1639, 1738,  218,  498,
 /*  1050 */   144,  221,  275, 1738,  220, 1444, 1445,  223,  134,  556,
 /*  1060 */   222,  145,   50,   60,  254,   60, 1934,  537,  509, 1738,
 /*  1070 */  1970,  549,  365,   98, 1935, 1937,  614, 1939, 1940,  609,
 /*  1080 */  1370,  604,  585, 1418, 1427, 1649,  171, 1632, 2023, 1738,
 /*  1090 */  1630,  601,  351, 2019, 1580, 1581, 2096,  132,   94,   13,
 /*  1100 */    12,   45, 1363,  246, 1361, 1725, 1721,  230,   91,  511,
 /*  1110 */   605,  638,  514, 2050, 1198, 2063, 1535,  257, 1479,  173,
 /*  1120 */  2031, 2032, 1505, 2036, 1692,  268, 1598, 1366, 1367, 1925,
 /*  1130 */  1417, 1420, 1421, 1422, 1423, 1424, 1425, 1426,  606,  602,
 /*  1140 */  1435, 1436, 1438, 1439, 1440, 1441, 1443, 1446,    3,  678,
 /*  1150 */   677,  676,  675,  368, 1428,  674,  673,  135,  668,  667,
 /*  1160 */   666,  665,  664,  663,  662,  661,  149,  657,  656,  655,
 /*  1170 */   367,  366,  652,  651,  650,  649,  648,  157, 1927,  570,
 /*  1180 */    45,  618,  292,  144, 1936,  145,  124,  144, 1362, 1571,
 /*  1190 */   653,  654, 1125, 1626,  210,  262,  290,   67,  594, 1955,
 /*  1200 */    66, 1360,  369, 1841, 1621, 1778, 2053,  595,  587,  270,
 /*  1210 */   267,    5, 1145, 1143, 1954,    2,  379,  194,  450,  448,
 /*  1220 */  1326,  327,  611,  374,  282, 1373, 1126, 1904,  134,  610,
 /*  1230 */   187,  406, 1463,  285, 1226, 1368, 1230, 1390, 1237, 1235,
 /*  1240 */   148,  696, 1842,  415,  410, 1385,  441,  427, 1834,  590,
 /*  1250 */   434,  447,  440, 1934,   58,  442,  446, 1970,  191,  449,
 /*  1260 */    98, 1935, 1937,  614, 1939, 1940,  609,  132,  604,  451,
 /*  1270 */  1391,  131,  452,  143, 1994, 2023, 1393,  460,  463,  351,
 /*  1280 */  2019, 1392,  464,  701,  197,  199,  465, 1394,  468,  175,
 /*  1290 */  2031, 2032,   97, 2036,  466, 1936,  202,  204,  472,   76,
 /*  1300 */    77,  208, 1099,  489,  490,  491,  493, 1728,  214, 1724,
 /*  1310 */  1881,  216,  100,  318,  525,  527,  283,  228,  528,  529,
 /*  1320 */   340,  150,  151,  231,  535, 1954, 1726,  540, 1722,   72,
 /*  1330 */    71,  400,  152,  611,  181,  153,  550,  235, 1904,   85,
 /*  1340 */   610,  568,  543,  284, 1363,   87, 1361,  571, 2045,  580,
 /*  1350 */  1936,    6,  315, 1880,  532,  388, 1852,  386,  382,  378,
 /*  1360 */   375,  372,  565,  141, 1934,  547,  342, 2054, 1970, 1366,
 /*  1370 */  1367,   98, 1935, 1937,  614, 1939, 1940,  609,  551,  604,
 /*  1380 */  1954,  564,  566,  142, 2111, 1739, 2023,  252,  611, 2064,
 /*  1390 */   351, 2019,  567, 1904,  562,  610,  347,  256,  574,  348,
 /*  1400 */  2057,  177,  563,  591, 2114, 1505, 1936,  588,  266,  133,
 /*  1410 */  1389,   57, 2004, 2069,   89,  616, 1782, 1709,  697, 1934,
 /*  1420 */   700,  287,  278, 1970,  698,  264,   98, 1935, 1937,  614,
 /*  1430 */  1939, 1940,  609, 2068,  604, 2039, 1954,  311,   49, 2111,
 /*  1440 */   299, 2023,  164,  263,  611,  351, 2019,  261,  310, 1904,
 /*  1450 */   289,  610,  309,  291,  265, 2085, 1898, 1897,   69, 1896,
 /*  1460 */  2090, 1936, 1895,   70, 1892,  376,  377, 1354, 1355,  180,
 /*  1470 */   269,  381, 1890,  383,  384, 1934,  385, 1889,  387, 1970,
 /*  1480 */  1936, 1888,   98, 1935, 1937,  614, 1939, 1940,  609,  389,
 /*  1490 */   604, 1954, 1887,  391, 1886, 2111,  393, 2023, 1329,  611,
 /*  1500 */  1328,  351, 2019, 1863, 1904, 1862,  610,  398,  399, 1861,
 /*  1510 */  1954, 2042, 1860, 1290, 1827, 1826, 1824,  136,  611, 1823,
 /*  1520 */  1822, 1825, 1821, 1904, 1820,  610, 1818, 1817, 1816,  185,
 /*  1530 */   612,  416, 1815,  418, 1970, 1814, 1813,  301,  357, 1937,
 /*  1540 */   614, 1939, 1940,  609, 1812,  604, 1811, 1810, 1809, 1934,
 /*  1550 */  1808, 1807, 1806, 1970, 1805, 1804,   98, 1935, 1937,  614,
 /*  1560 */  1939, 1940,  609, 1803,  604, 1802, 1801, 2091, 1173, 1998,
 /*  1570 */  1800, 2023,  138, 1799, 1798,  351, 2019, 1936, 1797, 1796,
 /*  1580 */   354,  353,  581,  174, 1795, 1794, 1292, 2092,  583, 1086,
 /*  1590 */  1376, 1793, 1792, 1791, 1654,  192, 1653,  193, 1936, 1651,
 /*  1600 */  1617, 1442,  169, 1369,  195, 1616,  125, 1954,  126, 1085,
 /*  1610 */  1876, 1870, 1859,  203, 1858,  611,  196,  456,  458,  201,
 /*  1620 */  1904, 1844,  610, 1717, 1118, 1437, 1650, 1648, 1954,  474,
 /*  1630 */  1646, 1644,  473,  477,  478,  482,  611, 1368, 1642,  481,
 /*  1640 */   475, 1904,  479,  610,  485,  483, 1934,  487, 1629,  486,
 /*  1650 */  1970, 1628, 1613,   98, 1935, 1937,  614, 1939, 1940,  609,
 /*  1660 */  1719,  604,   59, 1241, 1240, 1718, 1996, 1934, 2023, 1164,
 /*  1670 */  1163, 1970,  351, 2019,   98, 1935, 1937,  614, 1939, 1940,
 /*  1680 */   609, 1162,  604, 1936, 1161,  600,  669,  559,  213, 2023,
 /*  1690 */  1160, 1155, 1157,  351, 2019, 1640,  671, 1156, 1154,  336,
 /*  1700 */  1633,  337, 1631,  512,  338,  515, 1612, 1611,  517,  519,
 /*  1710 */  1610,  521,  101, 1954, 1346,   25, 1875,   53, 1335, 1869,
 /*  1720 */   154,  611, 1857,  530, 1855, 1856, 1904,   18,  610,  237,
 /*  1730 */  1851, 1344, 2096, 1854, 1853,  545,  243, 1843,  531, 1343,
 /*  1740 */    83,   86,   84,  248,  232,   91, 1377,   15, 1372,  646,
 /*  1750 */   536,  339, 1934,   27,   19,   20, 1970, 1550,   56,   99,
 /*  1760 */  1935, 1937,  614, 1939, 1940,  609, 1454,  604, 1936,  245,
 /*  1770 */    10, 1380, 1382,  251, 2023,  259,  253,  548, 2022, 2019,
 /*  1780 */  1532,  255, 1453,  602, 1435, 1436, 1438, 1439, 1440, 1441,
 /*  1790 */  1534,  260, 1925,  162,  258,   29,   61,   22, 1954,   21,
 /*  1800 */    28, 1565, 1564,  349, 1527, 1570,  611, 1569,   90, 1568,
 /*  1810 */  1571, 1904,  350,  610, 1502,  272, 1501, 1924,   55,  165,
 /*  1820 */    12, 1378, 1464, 1973, 1936,  166,  178, 1432, 1410,  613,
 /*  1830 */   603,  617, 1430,   35, 1171, 1429,   14, 1934,   23,  360,
 /*  1840 */  1402, 1970,  621,   24,   99, 1935, 1937,  614, 1939, 1940,
 /*  1850 */   609, 1227,  604, 1936, 1954,  615,   54,  619,  622, 2023,
 /*  1860 */  1224,   16,  608,  599, 2019,  624, 1221, 1904,  627,  610,
 /*  1870 */  1219,  625,  630, 1204, 1215, 1218,  628, 1217, 1213,  631,
 /*  1880 */  1216,   92, 1936, 1954,   93, 1236,   68,  276, 1232, 1116,
 /*  1890 */   637,  611, 1151, 1934, 1150, 1149, 1904, 1970,  610, 1148,
 /*  1900 */   307, 1935, 1937,  614, 1939, 1940,  609,  607,  604,  557,
 /*  1910 */  1988, 1936, 1954, 1147, 1146, 1144, 1142, 1141, 1140,  658,
 /*  1920 */   611, 1138, 1934, 1137, 1136, 1904, 1970,  610,  277,  160,
 /*  1930 */  1935, 1937,  614, 1939, 1940,  609, 1135,  604, 1134, 1133,
 /*  1940 */  1132, 1954, 1131, 1168, 1166, 1128, 1127, 1124, 1123,  611,
 /*  1950 */  1122, 1934, 1121, 1647, 1904, 1970,  610,  679,  161, 1935,
 /*  1960 */  1937,  614, 1939, 1940,  609,  680,  604, 1645,  681,  683,
 /*  1970 */   561, 2060,  684, 1643,  685,  687,  689,  688, 1936, 1641,
 /*  1980 */  1934,  691,  693,  692, 1970, 1627,  695,   99, 1935, 1937,
 /*  1990 */   614, 1939, 1940,  609, 1936,  604, 1076, 1609,  280,  699,
 /*  2000 */  1584,  702, 2023, 1364,  288, 1584,  703, 2020, 1954, 1584,
 /*  2010 */   584, 2112, 1584,  341, 1584, 1584,  611, 1584, 1584, 1584,
 /*  2020 */  1584, 1904, 1584,  610, 1954, 1584, 1584, 1584, 1584, 1584,
 /*  2030 */  1584, 1584,  608, 1584, 1584, 1584, 1584, 1904, 1584,  610,
 /*  2040 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1934, 1584, 1936,
 /*  2050 */  1584, 1970, 1584, 1584,  308, 1935, 1937,  614, 1939, 1940,
 /*  2060 */   609, 1584,  604, 1934, 1584, 1584, 1584, 1970, 1584, 1936,
 /*  2070 */   307, 1935, 1937,  614, 1939, 1940,  609, 1584,  604, 1954,
 /*  2080 */  1989, 1584, 1584, 1584, 1584, 1584, 1584,  611, 1584, 1584,
 /*  2090 */  1584, 1584, 1904, 1584,  610, 1584, 1584, 1584, 1584, 1954,
 /*  2100 */  1584, 1584, 1584, 1584, 1584, 1584, 1584,  611, 1584, 1584,
 /*  2110 */  1584, 1584, 1904, 1584,  610, 1584, 1584, 1584, 1934, 1584,
 /*  2120 */  1584, 1584, 1970, 1584, 1584,  160, 1935, 1937,  614, 1939,
 /*  2130 */  1940,  609, 1584,  604, 1936, 1584, 1584, 1584, 1934, 1584,
 /*  2140 */  1584, 1584, 1970, 1584, 1584,  303, 1935, 1937,  614, 1939,
 /*  2150 */  1940,  609, 1584,  604, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2160 */  1584, 1584, 1584, 1584, 1954, 1584, 1584, 2061, 1584, 1584,
 /*  2170 */  1584, 1584,  611, 1584, 1584, 1584, 1584, 1904, 1584,  610,
 /*  2180 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584,  579,
 /*  2190 */  1584, 1584, 1936, 1584, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2200 */  1584, 1584, 1584, 1934, 1584, 1584, 1936, 1970, 1584, 1584,
 /*  2210 */   161, 1935, 1937,  614, 1939, 1940,  609, 1584,  604, 1584,
 /*  2220 */  1584, 1584, 1954, 1584, 1584, 1584, 1584,  356, 1584, 1584,
 /*  2230 */   611, 1584, 1584, 1584, 1584, 1904, 1954,  610, 1584, 1584,
 /*  2240 */  1584,  359, 1584, 1584,  611, 1584, 1584, 1584, 1584, 1904,
 /*  2250 */  1584,  610, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2260 */  1584, 1934, 1584, 2113, 1936, 1970, 1584, 1584,  308, 1935,
 /*  2270 */  1937,  614, 1939, 1940,  609, 1934,  604, 1584, 1936, 1970,
 /*  2280 */  1584, 1584,  308, 1935, 1937,  614, 1939, 1940,  609, 1584,
 /*  2290 */   604, 1584, 1584, 1584, 1954, 1584, 1584, 1584, 1584, 1584,
 /*  2300 */  1584, 1584,  611, 1584, 1584, 1584, 1584, 1904, 1954,  610,
 /*  2310 */  1584, 1584, 1584, 1584, 1584, 1584,  611, 1584, 1584, 1584,
 /*  2320 */  1584, 1904, 1584,  610, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2330 */  1584, 1936, 1584,  524, 1584, 1584, 1584, 1970, 1584, 1584,
 /*  2340 */   301, 1935, 1937,  614, 1939, 1940,  609, 1934,  604, 1584,
 /*  2350 */  1584, 1970, 1584, 1584,  293, 1935, 1937,  614, 1939, 1940,
 /*  2360 */   609, 1954,  604, 1584, 1584, 1584, 1584, 1584, 1584,  611,
 /*  2370 */  1584, 1584, 1584, 1584, 1904, 1584,  610, 1584, 1584, 1584,
 /*  2380 */  1584, 1584, 1584, 1584, 1584, 1584, 1936, 1584, 1584, 1584,
 /*  2390 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2400 */  1934, 1584, 1936, 1584, 1970, 1584, 1584,  294, 1935, 1937,
 /*  2410 */   614, 1939, 1940,  609, 1584,  604, 1954, 1584, 1584, 1584,
 /*  2420 */  1584, 1584, 1584, 1584,  611, 1584, 1584, 1584, 1584, 1904,
 /*  2430 */  1584,  610, 1954, 1584, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2440 */   611, 1584, 1584, 1584, 1584, 1904, 1584,  610, 1584, 1584,
 /*  2450 */  1584, 1584, 1584, 1584, 1584, 1934, 1584, 1936, 1584, 1970,
 /*  2460 */  1584, 1584,  295, 1935, 1937,  614, 1939, 1940,  609, 1584,
 /*  2470 */   604, 1934, 1584, 1936, 1584, 1970, 1584, 1584,  302, 1935,
 /*  2480 */  1937,  614, 1939, 1940,  609, 1584,  604, 1954, 1584, 1584,
 /*  2490 */  1584, 1584, 1584, 1584, 1584,  611, 1584, 1584, 1584, 1584,
 /*  2500 */  1904, 1584,  610, 1954, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2510 */  1584,  611, 1584, 1584, 1584, 1584, 1904, 1584,  610, 1584,
 /*  2520 */  1584, 1584, 1584, 1584, 1584, 1584, 1934, 1584, 1584, 1936,
 /*  2530 */  1970, 1584, 1584,  304, 1935, 1937,  614, 1939, 1940,  609,
 /*  2540 */  1584,  604, 1934, 1584, 1584, 1936, 1970, 1584, 1584,  296,
 /*  2550 */  1935, 1937,  614, 1939, 1940,  609, 1584,  604, 1584, 1954,
 /*  2560 */  1584, 1584, 1584, 1584, 1584, 1584, 1584,  611, 1584, 1584,
 /*  2570 */  1584, 1584, 1904, 1584,  610, 1954, 1584, 1584, 1584, 1584,
 /*  2580 */  1584, 1584, 1584,  611, 1584, 1584, 1584, 1584, 1904, 1584,
 /*  2590 */   610, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1934, 1584,
 /*  2600 */  1584, 1936, 1970, 1584, 1584,  305, 1935, 1937,  614, 1939,
 /*  2610 */  1940,  609, 1584,  604, 1934, 1584, 1584, 1936, 1970, 1584,
 /*  2620 */  1584,  297, 1935, 1937,  614, 1939, 1940,  609, 1584,  604,
 /*  2630 */  1584, 1954, 1584, 1584, 1584, 1584, 1584, 1584, 1584,  611,
 /*  2640 */  1584, 1584, 1584, 1584, 1904, 1584,  610, 1954, 1584, 1584,
 /*  2650 */  1584, 1584, 1584, 1584, 1584,  611, 1584, 1584, 1584, 1584,
 /*  2660 */  1904, 1584,  610, 1584, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2670 */  1934, 1584, 1584, 1584, 1970, 1584, 1584,  306, 1935, 1937,
 /*  2680 */   614, 1939, 1940,  609, 1936,  604, 1934, 1584, 1584, 1584,
 /*  2690 */  1970, 1584, 1584,  298, 1935, 1937,  614, 1939, 1940,  609,
 /*  2700 */  1584,  604, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1936,
 /*  2710 */  1584, 1584, 1584, 1584, 1954, 1584, 1584, 1584, 1584, 1584,
 /*  2720 */  1584, 1584,  611, 1584, 1584, 1584, 1584, 1904, 1584,  610,
 /*  2730 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1954,
 /*  2740 */  1584, 1584, 1584, 1584, 1584, 1584, 1584,  611, 1584, 1584,
 /*  2750 */  1584, 1584, 1904, 1934,  610, 1584, 1584, 1970, 1584, 1584,
 /*  2760 */   313, 1935, 1937,  614, 1939, 1940,  609,  704,  604, 1584,
 /*  2770 */  1936, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1934, 1584,
 /*  2780 */  1584,  281, 1970, 1584, 1584,  314, 1935, 1937,  614, 1939,
 /*  2790 */  1940,  609, 1584,  604, 1584,  167, 1584, 1584, 1584, 1584,
 /*  2800 */  1954,  694,  690,  686,  682,  279, 1584, 1584,  611, 1584,
 /*  2810 */  1584, 1584, 1584, 1904, 1584,  610, 1584, 1584, 1584, 1584,
 /*  2820 */  1584, 1584, 1584, 1936, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  2830 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1934,
 /*  2840 */  1584, 1936,   96, 1970, 1584,  247, 1948, 1935, 1937,  614,
 /*  2850 */  1939, 1940,  609, 1954,  604, 1584, 1584, 1584, 1584, 1584,
 /*  2860 */  1584,  611, 1584, 1584, 1584, 1584, 1904, 1584,  610, 1584,
 /*  2870 */  1584, 1954, 1584, 1584, 1584, 1584, 1584, 1584,  553,  611,
 /*  2880 */  1584, 1584, 1584, 1584, 1904, 1584,  610, 1584, 1584, 1584,
 /*  2890 */  1584, 1584, 1934, 1584, 1584, 1584, 1970, 1936, 1584, 1947,
 /*  2900 */  1935, 1937,  614, 1939, 1940,  609, 1584,  604, 1584, 1584,
 /*  2910 */  1934, 1936, 1584,  236, 1970, 1584, 1584, 1946, 1935, 1937,
 /*  2920 */   614, 1939, 1940,  609, 1584,  604, 1584, 1954, 1584, 1584,
 /*  2930 */  1333, 1584,  229, 1584, 1584,  611, 1584, 1584, 1584, 1584,
 /*  2940 */  1904, 1954,  610, 1584, 1584, 1584, 1584, 1584, 1584,  611,
 /*  2950 */  1584, 1584, 1584, 1584, 1904, 1584,  610, 1584, 1584, 1584,
 /*  2960 */  1584, 1584, 1584, 1584, 1584, 1584, 1934, 1936, 1584, 1584,
 /*  2970 */  1970, 1584, 1584,  323, 1935, 1937,  614, 1939, 1940,  609,
 /*  2980 */  1934,  604, 1584, 1936, 1970, 1584, 1584,  324, 1935, 1937,
 /*  2990 */   614, 1939, 1940,  609, 1584,  604, 1584, 1954, 1584, 1584,
 /*  3000 */  1584, 1584, 1584, 1584, 1584,  611, 1584, 1584, 1584, 1584,
 /*  3010 */  1904, 1584,  610, 1954, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  3020 */  1584,  611, 1584, 1584, 1584, 1584, 1904, 1584,  610, 1584,
 /*  3030 */  1584, 1584, 1584, 1584, 1584, 1584, 1934, 1584, 1584, 1584,
 /*  3040 */  1970, 1584, 1584,  320, 1935, 1937,  614, 1939, 1940,  609,
 /*  3050 */  1936,  604, 1934, 1584, 1584, 1584, 1970, 1584, 1584,  325,
 /*  3060 */  1935, 1937,  614, 1939, 1940,  609, 1584,  604, 1584, 1584,
 /*  3070 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  3080 */  1954, 1584, 1584, 1584, 1584, 1584, 1584, 1584,  611, 1584,
 /*  3090 */  1584, 1584, 1584, 1904, 1584,  610, 1584, 1584, 1584, 1584,
 /*  3100 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584,
 /*  3110 */  1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1584, 1934,
 /*  3120 */  1584, 1584, 1584, 1970, 1584, 1584,  300, 1935, 1937,  614,
 /*  3130 */  1939, 1940,  609, 1584,  604,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   326,  322,  328,  329,  360,  352,  363,  330,  330,  366,
 /*    10 */   367,  330,   12,   13,  326,  371,  328,  329,  352,  354,
 /*    20 */    20,  343,   22,    0,  343,  359,  373,  374,  350,  327,
 /*    30 */   365,  352,  330,   33,  368,   35,    0,  360,  360,  360,
 /*    40 */   336,  360,  333,  353,  365,  341,  367,   24,   25,   26,
 /*    50 */    27,   28,   29,   30,   31,   32,  347,   57,    4,  394,
 /*    60 */   395,  396,   62,    4,  355,  399,    4,  344,   20,   69,
 /*    70 */   391,  406,   20,   19,  395,  352,  399,  398,  399,  400,
 /*    80 */   401,  402,  403,  404,  361,  406,   20,   33,   22,   14,
 /*    90 */    15,   16,  413,   79,  428,   95,  417,  418,  421,  422,
 /*   100 */   423,   47,  425,   44,   45,  428,   52,  428,  383,  443,
 /*   110 */   444,   57,  414,  415,  448,  449,   50,  117,  322,  330,
 /*   120 */   443,  444,  443,  444,  399,  448,  449,  448,  449,    8,
 /*   130 */     9,  131,  132,   12,   13,   14,   15,   16,   95,   57,
 /*   140 */    95,   20,  330,   95,   12,   13,   14,   20,   94,  135,
 /*   150 */   136,   97,   20,  428,   22,  343,   95,   95,  369,  159,
 /*   160 */   160,  365,   64,   65,   66,   33,   35,   35,  443,  444,
 /*   170 */    72,   73,  360,  448,  449,   77,   78,   95,  178,   97,
 /*   180 */   180,   83,   84,  131,  132,  149,  352,   89,   20,   57,
 /*   190 */    20,    8,    9,  359,   62,   12,   13,   14,   15,   16,
 /*   200 */    69,   69,  368,  203,  204,    0,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  335,   21,   95,  383,   24,
 /*   230 */    25,   26,   27,   28,   29,   30,   31,   32,  177,  349,
 /*   240 */   179,   18,  242,   20,  399,  366,  367,   20,  358,  117,
 /*   250 */    27,   21,  106,   30,   24,   25,   26,   27,   28,   29,
 /*   260 */    30,   31,   32,  131,  132,   95,  399,  352,  367,  399,
 /*   270 */    47,   61,   49,  428,  359,   52,   12,   13,  377,   96,
 /*   280 */   322,  380,  161,  368,   20,  242,   22,  242,  443,  444,
 /*   290 */   242,  159,  160,  448,  449,  428,   20,   33,  428,   35,
 /*   300 */   154,    8,    9,  242,  242,   12,   13,   14,   15,   16,
 /*   310 */   178,  444,  180,  443,  444,  448,  449,   94,  448,  449,
 /*   320 */   164,   57,   95,  365,  242,   20,   62,  159,  160,  106,
 /*   330 */     1,    2,  321,   69,  323,  203,  204,   57,  206,  207,
 /*   340 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   350 */   218,  219,  220,  221,  222,  223,  224,  134,   20,   95,
 /*   360 */   137,  138,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   370 */   147,  148,  149,  150,  151,  152,  153,   97,  155,  156,
 /*   380 */   157,  117,    8,    9,   35,  383,   12,   13,   14,   15,
 /*   390 */    16,   33,   20,  351,   22,  131,  132,  327,  399,  173,
 /*   400 */   330,  399,  344,  247,  248,   47,  364,   35,   12,   13,
 /*   410 */   352,   53,   54,   55,   56,   57,   20,   43,   22,  361,
 /*   420 */   194,  195,   50,  159,  160,   96,    2,  428,   61,   33,
 /*   430 */   428,   35,    8,    9,  127,  319,   12,   13,   14,   15,
 /*   440 */    16,  335,  178,  444,  180,  443,  444,  448,  449,  344,
 /*   450 */   448,  449,   94,   57,  352,   97,   20,  352,   62,  203,
 /*   460 */   338,  339,  360,  170,  358,   69,  361,  203,  204,  242,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   480 */   216,  217,  218,  219,  220,  221,  222,  223,  224,   21,
 /*   490 */   226,   95,  185,  186,   44,   45,  189,    3,  191,  383,
 /*   500 */   322,  330,   34,  401,   36,  397,  383,  251,  252,  253,
 /*   510 */   254,  255,   14,  117,   20,  399,  107,  383,   20,  126,
 /*   520 */   162,  163,  399,  165,   14,  322,  168,  131,  132,  180,
 /*   530 */    20,  360,  424,  399,    0,  126,  127,  128,  129,  130,
 /*   540 */    12,   13,  184,  365,  428,  330,  322,  352,   20,    0,
 /*   550 */    22,  428,  410,  106,  412,  159,  160,  264,  343,  443,
 /*   560 */   444,   33,  428,   35,  448,  449,  443,  444,  365,  374,
 /*   570 */   399,  448,  449,   14,  178,  360,  180,  443,  444,   20,
 /*   580 */   187,  188,  448,  449,    0,   57,   20,  354,  322,  365,
 /*   590 */    96,  420,  421,  422,  423,   61,  425,   69,  365,  203,
 /*   600 */   204,  322,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   610 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   620 */   224,   57,  322,   95,  226,    0,  228,  394,  395,    8,
 /*   630 */     9,  365,  226,   12,   13,   14,   15,   16,  158,  406,
 /*   640 */     2,  322,  333,    0,  365,  117,    8,    9,  338,  339,
 /*   650 */    12,   13,   14,   15,   16,  161,  107,  159,   94,  131,
 /*   660 */   132,   97,    8,    9,  355,  365,   12,   13,   14,   15,
 /*   670 */    16,  397,   12,   13,   14,  126,  127,  128,  129,  130,
 /*   680 */    20,  354,   22,   62,  365,  322,  330,  159,  160,  352,
 /*   690 */    47,  107,  365,   33,  330,   35,    8,    9,  424,  343,
 /*   700 */    12,   13,   14,   15,   16,  368,  178,  343,  180,  229,
 /*   710 */   126,  127,  128,  129,  130,  352,  360,   57,  159,  239,
 /*   720 */    69,  394,  395,  360,  360,  104,   69,  161,  365,   69,
 /*   730 */   367,  203,  204,  406,  206,  207,  208,  209,  210,  211,
 /*   740 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   750 */   222,  223,  224,    4,  391,   95,  322,   43,  395,  322,
 /*   760 */   360,  398,  399,  400,  401,  402,  403,  404,    0,  406,
 /*   770 */   242,  371,  345,   37,  411,  348,  413,  117,  322,  158,
 /*   780 */   417,  418,    8,    9,   96,  322,   12,   13,   14,   15,
 /*   790 */    16,  131,  132,  430,   12,   13,   14,   15,   16,  365,
 /*   800 */   330,  438,  365,  330,   12,   13,  360,  410,  397,  412,
 /*   810 */    96,  330,   20,  343,   22,  161,  343,  371,  330,  159,
 /*   820 */   160,  365,   20,  350,  343,   33,    3,   35,  365,   61,
 /*   830 */   360,  343,  330,  360,   98,  424,  100,  101,  178,  103,
 /*   840 */   180,  360,   20,  107,  379,  343,  381,   20,  360,   57,
 /*   850 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*   860 */   239,   69,  360,  203,  204,  129,  206,  207,  208,  209,
 /*   870 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   880 */   220,  221,  222,  223,  224,  126,  127,   95,  108,  109,
 /*   890 */   110,  111,  112,  113,  114,  115,  116,  117,  118,  322,
 /*   900 */   120,  121,  122,  123,  124,  125,  367,  352,  330,  117,
 /*   910 */   322,  240,  241,  330,  354,  379,  361,  381,   22,  380,
 /*   920 */    39,  343,  322,  131,  132,  365,  343,  340,  330,  342,
 /*   930 */   322,   35,  322,  322,  330,   43,   12,   13,  360,   42,
 /*   940 */    43,  343,  365,  360,   20,  186,   22,  343,  189,  330,
 /*   950 */   191,  159,  160,  365,  394,  395,  396,   33,  360,   35,
 /*   960 */     0,  330,  343,  161,  360,  365,  406,  107,  362,   43,
 /*   970 */   178,  365,  180,  365,  343,  365,  365,  409,  387,  360,
 /*   980 */   412,   57,  362,  161,  345,  365,  159,  348,   96,  129,
 /*   990 */    43,  360,  243,   69,  353,  203,  204,  322,  206,  207,
 /*  1000 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*  1010 */   218,  219,  220,  221,  222,  223,  224,  330,   43,   95,
 /*  1020 */    42,   43,   96,  330,   64,   65,   66,  352,  330,   43,
 /*  1030 */   343,   99,   72,   73,  102,  360,  343,   77,   78,  330,
 /*  1040 */   365,  117,  367,   83,   84,   99,    0,  360,  102,   89,
 /*  1050 */    43,   99,  343,  360,  102,  131,  132,   99,  360,  330,
 /*  1060 */   102,   43,  161,   43,   43,   43,  391,  166,   22,  360,
 /*  1070 */   395,   96,  343,  398,  399,  400,  401,  402,  403,  404,
 /*  1080 */    35,  406,  259,  159,  160,    0,  411,    0,  413,  360,
 /*  1090 */     0,   62,  417,  418,  131,  132,    3,  399,   95,    1,
 /*  1100 */     2,   43,  178,   96,  180,  353,  353,  353,  105,   22,
 /*  1110 */   353,  353,   22,  438,   96,  375,   96,   96,   96,  421,
 /*  1120 */   422,  423,  241,  425,  341,  452,  323,  203,  204,   46,
 /*  1130 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1140 */   216,  217,  218,  219,  220,  221,  222,  223,  224,   64,
 /*  1150 */    65,   66,   67,   68,   96,   70,   71,   72,   73,   74,
 /*  1160 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*  1170 */    85,   86,   87,   88,   89,   90,   91,   18,   95,  441,
 /*  1180 */    43,   43,   23,   43,  322,   43,   43,   43,   22,   96,
 /*  1190 */    13,   13,   35,    0,  331,  435,   37,   38,  330,  352,
 /*  1200 */    41,   35,  331,  375,  329,  364,  375,  426,  261,  445,
 /*  1210 */   419,  244,   35,   35,  352,  429,   47,   58,   59,   60,
 /*  1220 */   176,  392,  360,  393,  385,  180,   69,  365,  360,  367,
 /*  1230 */    42,  372,  203,   96,   96,   69,   96,   20,   96,   96,
 /*  1240 */    96,   48,  375,  370,  372,   20,  158,  330,  330,  263,
 /*  1250 */   372,  337,  370,  391,   95,  370,   93,  395,  330,  330,
 /*  1260 */   398,  399,  400,  401,  402,  403,  404,  399,  406,  330,
 /*  1270 */    20,  409,  324,  411,  412,  413,   20,  324,  389,  417,
 /*  1280 */   418,   20,  367,  117,  335,  335,  382,   20,  382,  421,
 /*  1290 */   422,  423,  133,  425,  384,  322,  335,  335,  330,  335,
 /*  1300 */   335,  335,   51,  332,  332,  324,  352,  352,  352,  352,
 /*  1310 */   365,  352,  330,  324,  192,  390,  389,  333,  183,  388,
 /*  1320 */   382,  352,  352,  333,  330,  352,  352,  330,  352,  170,
 /*  1330 */   171,  172,  352,  360,  175,  352,  163,  333,  365,  333,
 /*  1340 */   367,  249,  365,  348,  178,  333,  180,  250,  437,  169,
 /*  1350 */   322,  256,  193,  365,  367,  196,  365,  198,  199,  200,
 /*  1360 */   201,  202,  258,  378,  391,  365,  365,  375,  395,  203,
 /*  1370 */   204,  398,  399,  400,  401,  402,  403,  404,  376,  406,
 /*  1380 */   352,  365,  365,  378,  411,  360,  413,  378,  360,  375,
 /*  1390 */   417,  418,  365,  365,  245,  367,  365,  378,  365,  265,
 /*  1400 */   427,  242,  257,  262,  453,  241,  322,  260,  393,  360,
 /*  1410 */    20,   95,  416,  434,   95,  356,  365,  342,   36,  391,
 /*  1420 */   324,  330,  333,  395,  325,  432,  398,  399,  400,  401,
 /*  1430 */   402,  403,  404,  434,  406,  397,  352,  381,  386,  411,
 /*  1440 */   346,  413,  434,  433,  360,  417,  418,  436,  346,  365,
 /*  1450 */   334,  367,  346,  320,  431,  427,    0,    0,  185,    0,
 /*  1460 */   447,  322,    0,   42,    0,   35,  197,   35,   35,   35,
 /*  1470 */   446,  197,    0,   35,   35,  391,  197,    0,  197,  395,
 /*  1480 */   322,    0,  398,  399,  400,  401,  402,  403,  404,   35,
 /*  1490 */   406,  352,    0,   22,    0,  411,   35,  413,  180,  360,
 /*  1500 */   178,  417,  418,    0,  365,    0,  367,  174,  173,    0,
 /*  1510 */   352,  427,    0,   46,    0,    0,    0,   42,  360,    0,
 /*  1520 */     0,    0,    0,  365,    0,  367,    0,    0,    0,  149,
 /*  1530 */   391,   35,    0,  149,  395,    0,    0,  398,  399,  400,
 /*  1540 */   401,  402,  403,  404,    0,  406,    0,    0,    0,  391,
 /*  1550 */     0,    0,    0,  395,    0,    0,  398,  399,  400,  401,
 /*  1560 */   402,  403,  404,    0,  406,    0,    0,  428,   35,  411,
 /*  1570 */     0,  413,   42,    0,    0,  417,  418,  322,    0,    0,
 /*  1580 */    12,   13,  443,  444,    0,    0,   22,  448,  449,   14,
 /*  1590 */    22,    0,    0,    0,    0,   57,    0,   57,  322,    0,
 /*  1600 */     0,   33,   43,   35,   42,    0,   39,  352,   39,   14,
 /*  1610 */     0,    0,    0,  169,    0,  360,   40,   46,   46,   39,
 /*  1620 */   365,    0,  367,    0,   63,   57,    0,    0,  352,   47,
 /*  1630 */     0,    0,   35,   35,   47,   47,  360,   69,    0,   35,
 /*  1640 */    39,  365,   39,  367,   35,   39,  391,   39,    0,   47,
 /*  1650 */   395,    0,    0,  398,  399,  400,  401,  402,  403,  404,
 /*  1660 */     0,  406,  104,   35,   22,    0,  411,  391,  413,   35,
 /*  1670 */    35,  395,  417,  418,  398,  399,  400,  401,  402,  403,
 /*  1680 */   404,   22,  406,  322,   35,  117,   43,  411,  102,  413,
 /*  1690 */    35,   22,   35,  417,  418,    0,   43,   35,   35,   22,
 /*  1700 */     0,   22,    0,   49,   22,   35,    0,    0,   35,   35,
 /*  1710 */     0,   22,   20,  352,   96,   95,    0,  161,   35,    0,
 /*  1720 */   181,  360,    0,   22,    0,    0,  365,   95,  367,   96,
 /*  1730 */     0,   35,    3,    0,    0,  190,   95,    0,  161,   35,
 /*  1740 */    95,   95,   39,   46,  163,  105,  178,  246,  180,   62,
 /*  1750 */   167,  161,  391,   95,   43,   43,  395,   96,   43,  398,
 /*  1760 */   399,  400,  401,  402,  403,  404,  225,  406,  322,  162,
 /*  1770 */   227,  203,  204,   95,  413,   43,   96,  164,  417,  418,
 /*  1780 */    96,   95,  225,  215,  216,  217,  218,  219,  220,  221,
 /*  1790 */    96,   46,   46,   95,   95,   43,    3,   43,  352,  246,
 /*  1800 */    95,   35,   35,   35,   96,   96,  360,   35,   95,   35,
 /*  1810 */    96,  365,   35,  367,   96,   46,   96,   46,   43,   46,
 /*  1820 */     2,   22,  203,   95,  322,   46,   46,   96,   22,  205,
 /*  1830 */    95,   35,   96,   95,   69,   96,   95,  391,   95,   35,
 /*  1840 */    96,  395,   35,   95,  398,  399,  400,  401,  402,  403,
 /*  1850 */   404,   96,  406,  322,  352,  106,  240,   95,   95,  413,
 /*  1860 */    96,  246,  360,  417,  418,   35,   96,  365,   35,  367,
 /*  1870 */   119,   95,   35,   22,   96,  119,   95,  119,   96,   95,
 /*  1880 */   119,   95,  322,  352,   95,   35,   95,   43,   22,   63,
 /*  1890 */   107,  360,   35,  391,   35,   35,  365,  395,  367,   35,
 /*  1900 */   398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
 /*  1910 */   408,  322,  352,   35,   35,   35,   35,   35,   35,   92,
 /*  1920 */   360,   35,  391,   35,   22,  365,  395,  367,   43,  398,
 /*  1930 */   399,  400,  401,  402,  403,  404,   35,  406,   22,   35,
 /*  1940 */    35,  352,   35,   69,   35,   35,   35,   35,   35,  360,
 /*  1950 */    22,  391,   35,    0,  365,  395,  367,   35,  398,  399,
 /*  1960 */   400,  401,  402,  403,  404,   47,  406,    0,   39,   35,
 /*  1970 */   439,  440,   47,    0,   39,   35,   39,   47,  322,    0,
 /*  1980 */   391,   35,   39,   47,  395,    0,   35,  398,  399,  400,
 /*  1990 */   401,  402,  403,  404,  322,  406,   35,    0,   22,   21,
 /*  2000 */   454,   21,  413,   22,   22,  454,   20,  418,  352,  454,
 /*  2010 */   450,  451,  454,  357,  454,  454,  360,  454,  454,  454,
 /*  2020 */   454,  365,  454,  367,  352,  454,  454,  454,  454,  454,
 /*  2030 */   454,  454,  360,  454,  454,  454,  454,  365,  454,  367,
 /*  2040 */   454,  454,  454,  454,  454,  454,  454,  391,  454,  322,
 /*  2050 */   454,  395,  454,  454,  398,  399,  400,  401,  402,  403,
 /*  2060 */   404,  454,  406,  391,  454,  454,  454,  395,  454,  322,
 /*  2070 */   398,  399,  400,  401,  402,  403,  404,  454,  406,  352,
 /*  2080 */   408,  454,  454,  454,  454,  454,  454,  360,  454,  454,
 /*  2090 */   454,  454,  365,  454,  367,  454,  454,  454,  454,  352,
 /*  2100 */   454,  454,  454,  454,  454,  454,  454,  360,  454,  454,
 /*  2110 */   454,  454,  365,  454,  367,  454,  454,  454,  391,  454,
 /*  2120 */   454,  454,  395,  454,  454,  398,  399,  400,  401,  402,
 /*  2130 */   403,  404,  454,  406,  322,  454,  454,  454,  391,  454,
 /*  2140 */   454,  454,  395,  454,  454,  398,  399,  400,  401,  402,
 /*  2150 */   403,  404,  454,  406,  454,  454,  454,  454,  454,  454,
 /*  2160 */   454,  454,  454,  454,  352,  454,  454,  440,  454,  454,
 /*  2170 */   454,  454,  360,  454,  454,  454,  454,  365,  454,  367,
 /*  2180 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  442,
 /*  2190 */   454,  454,  322,  454,  454,  454,  454,  454,  454,  454,
 /*  2200 */   454,  454,  454,  391,  454,  454,  322,  395,  454,  454,
 /*  2210 */   398,  399,  400,  401,  402,  403,  404,  454,  406,  454,
 /*  2220 */   454,  454,  352,  454,  454,  454,  454,  357,  454,  454,
 /*  2230 */   360,  454,  454,  454,  454,  365,  352,  367,  454,  454,
 /*  2240 */   454,  357,  454,  454,  360,  454,  454,  454,  454,  365,
 /*  2250 */   454,  367,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2260 */   454,  391,  454,  451,  322,  395,  454,  454,  398,  399,
 /*  2270 */   400,  401,  402,  403,  404,  391,  406,  454,  322,  395,
 /*  2280 */   454,  454,  398,  399,  400,  401,  402,  403,  404,  454,
 /*  2290 */   406,  454,  454,  454,  352,  454,  454,  454,  454,  454,
 /*  2300 */   454,  454,  360,  454,  454,  454,  454,  365,  352,  367,
 /*  2310 */   454,  454,  454,  454,  454,  454,  360,  454,  454,  454,
 /*  2320 */   454,  365,  454,  367,  454,  454,  454,  454,  454,  454,
 /*  2330 */   454,  322,  454,  391,  454,  454,  454,  395,  454,  454,
 /*  2340 */   398,  399,  400,  401,  402,  403,  404,  391,  406,  454,
 /*  2350 */   454,  395,  454,  454,  398,  399,  400,  401,  402,  403,
 /*  2360 */   404,  352,  406,  454,  454,  454,  454,  454,  454,  360,
 /*  2370 */   454,  454,  454,  454,  365,  454,  367,  454,  454,  454,
 /*  2380 */   454,  454,  454,  454,  454,  454,  322,  454,  454,  454,
 /*  2390 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2400 */   391,  454,  322,  454,  395,  454,  454,  398,  399,  400,
 /*  2410 */   401,  402,  403,  404,  454,  406,  352,  454,  454,  454,
 /*  2420 */   454,  454,  454,  454,  360,  454,  454,  454,  454,  365,
 /*  2430 */   454,  367,  352,  454,  454,  454,  454,  454,  454,  454,
 /*  2440 */   360,  454,  454,  454,  454,  365,  454,  367,  454,  454,
 /*  2450 */   454,  454,  454,  454,  454,  391,  454,  322,  454,  395,
 /*  2460 */   454,  454,  398,  399,  400,  401,  402,  403,  404,  454,
 /*  2470 */   406,  391,  454,  322,  454,  395,  454,  454,  398,  399,
 /*  2480 */   400,  401,  402,  403,  404,  454,  406,  352,  454,  454,
 /*  2490 */   454,  454,  454,  454,  454,  360,  454,  454,  454,  454,
 /*  2500 */   365,  454,  367,  352,  454,  454,  454,  454,  454,  454,
 /*  2510 */   454,  360,  454,  454,  454,  454,  365,  454,  367,  454,
 /*  2520 */   454,  454,  454,  454,  454,  454,  391,  454,  454,  322,
 /*  2530 */   395,  454,  454,  398,  399,  400,  401,  402,  403,  404,
 /*  2540 */   454,  406,  391,  454,  454,  322,  395,  454,  454,  398,
 /*  2550 */   399,  400,  401,  402,  403,  404,  454,  406,  454,  352,
 /*  2560 */   454,  454,  454,  454,  454,  454,  454,  360,  454,  454,
 /*  2570 */   454,  454,  365,  454,  367,  352,  454,  454,  454,  454,
 /*  2580 */   454,  454,  454,  360,  454,  454,  454,  454,  365,  454,
 /*  2590 */   367,  454,  454,  454,  454,  454,  454,  454,  391,  454,
 /*  2600 */   454,  322,  395,  454,  454,  398,  399,  400,  401,  402,
 /*  2610 */   403,  404,  454,  406,  391,  454,  454,  322,  395,  454,
 /*  2620 */   454,  398,  399,  400,  401,  402,  403,  404,  454,  406,
 /*  2630 */   454,  352,  454,  454,  454,  454,  454,  454,  454,  360,
 /*  2640 */   454,  454,  454,  454,  365,  454,  367,  352,  454,  454,
 /*  2650 */   454,  454,  454,  454,  454,  360,  454,  454,  454,  454,
 /*  2660 */   365,  454,  367,  454,  454,  454,  454,  454,  454,  454,
 /*  2670 */   391,  454,  454,  454,  395,  454,  454,  398,  399,  400,
 /*  2680 */   401,  402,  403,  404,  322,  406,  391,  454,  454,  454,
 /*  2690 */   395,  454,  454,  398,  399,  400,  401,  402,  403,  404,
 /*  2700 */   454,  406,  454,  454,  454,  454,  454,  454,  454,  322,
 /*  2710 */   454,  454,  454,  454,  352,  454,  454,  454,  454,  454,
 /*  2720 */   454,  454,  360,  454,  454,  454,  454,  365,  454,  367,
 /*  2730 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  352,
 /*  2740 */   454,  454,  454,  454,  454,  454,  454,  360,  454,  454,
 /*  2750 */   454,  454,  365,  391,  367,  454,  454,  395,  454,  454,
 /*  2760 */   398,  399,  400,  401,  402,  403,  404,   19,  406,  454,
 /*  2770 */   322,  454,  454,  454,  454,  454,  454,  454,  391,  454,
 /*  2780 */   454,   33,  395,  454,  454,  398,  399,  400,  401,  402,
 /*  2790 */   403,  404,  454,  406,  454,   47,  454,  454,  454,  454,
 /*  2800 */   352,   53,   54,   55,   56,   57,  454,  454,  360,  454,
 /*  2810 */   454,  454,  454,  365,  454,  367,  454,  454,  454,  454,
 /*  2820 */   454,  454,  454,  322,  454,  454,  454,  454,  454,  454,
 /*  2830 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  391,
 /*  2840 */   454,  322,   94,  395,  454,   97,  398,  399,  400,  401,
 /*  2850 */   402,  403,  404,  352,  406,  454,  454,  454,  454,  454,
 /*  2860 */   454,  360,  454,  454,  454,  454,  365,  454,  367,  454,
 /*  2870 */   454,  352,  454,  454,  454,  454,  454,  454,  130,  360,
 /*  2880 */   454,  454,  454,  454,  365,  454,  367,  454,  454,  454,
 /*  2890 */   454,  454,  391,  454,  454,  454,  395,  322,  454,  398,
 /*  2900 */   399,  400,  401,  402,  403,  404,  454,  406,  454,  454,
 /*  2910 */   391,  322,  454,  165,  395,  454,  454,  398,  399,  400,
 /*  2920 */   401,  402,  403,  404,  454,  406,  454,  352,  454,  454,
 /*  2930 */   182,  454,  184,  454,  454,  360,  454,  454,  454,  454,
 /*  2940 */   365,  352,  367,  454,  454,  454,  454,  454,  454,  360,
 /*  2950 */   454,  454,  454,  454,  365,  454,  367,  454,  454,  454,
 /*  2960 */   454,  454,  454,  454,  454,  454,  391,  322,  454,  454,
 /*  2970 */   395,  454,  454,  398,  399,  400,  401,  402,  403,  404,
 /*  2980 */   391,  406,  454,  322,  395,  454,  454,  398,  399,  400,
 /*  2990 */   401,  402,  403,  404,  454,  406,  454,  352,  454,  454,
 /*  3000 */   454,  454,  454,  454,  454,  360,  454,  454,  454,  454,
 /*  3010 */   365,  454,  367,  352,  454,  454,  454,  454,  454,  454,
 /*  3020 */   454,  360,  454,  454,  454,  454,  365,  454,  367,  454,
 /*  3030 */   454,  454,  454,  454,  454,  454,  391,  454,  454,  454,
 /*  3040 */   395,  454,  454,  398,  399,  400,  401,  402,  403,  404,
 /*  3050 */   322,  406,  391,  454,  454,  454,  395,  454,  454,  398,
 /*  3060 */   399,  400,  401,  402,  403,  404,  454,  406,  454,  454,
 /*  3070 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  3080 */   352,  454,  454,  454,  454,  454,  454,  454,  360,  454,
 /*  3090 */   454,  454,  454,  365,  454,  367,  454,  454,  454,  454,
 /*  3100 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  3110 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  391,
 /*  3120 */   454,  454,  454,  395,  454,  454,  398,  399,  400,  401,
 /*  3130 */   402,  403,  404,  454,  406,
};
#define YY_SHIFT_COUNT    (704)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2748)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1159,    0,  132,  264,  132,  396,  396,  396,  528,  396,
 /*    10 */   396,  396,  396,  396,  660,  792,  792,  924,  792,  792,
 /*    20 */   792,  792,  792,  792,  792,  792,  792,  792,  792,  792,
 /*    30 */   792,  792,  792,  792,  792,  792,  792,  792,  792,  792,
 /*    40 */   792,  792,  792,  792,  792,  792,   48,  227,  170,   61,
 /*    50 */    82,   43,   45,   43,  170,  170, 1568, 1568,   43, 1568,
 /*    60 */  1568,   62,   43,  127,  127,  168,   59,   59,   52,  127,
 /*    70 */   127,  127,  127,  127,  127,  127,  127,  127,  127,  210,
 /*    80 */   127,  127,  127,  276,  127,  127,  305,  127,  127,  305,
 /*    90 */   338,  127,  305,  305,  305,  127,  367,  223,  621,  621,
 /*   100 */    98,  230, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166,
 /*   110 */  1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166, 1166,
 /*   120 */  1166,  736,  494,  168,   52,  510,  510,  534,  131,  768,
 /*   130 */   398,  398,  566,  566,  566,  131,  436,  436,  436,  447,
 /*   140 */   276,  625,  625,  406,  305,  305,  651,  651,  447,  657,
 /*   150 */   780,  780,  780,  780,  780,  780,  780, 2748,  960,  205,
 /*   160 */   121,  293,  256,  372,  156,  498,  559,   66,  802,  450,
 /*   170 */   860,  822,  671,  881,  823,  671,  897,  749,  827,  967,
 /*   180 */  1169, 1044, 1188, 1217, 1188, 1088, 1225, 1225, 1188, 1088,
 /*   190 */  1088, 1163, 1225, 1225, 1225, 1250, 1250, 1256,  210,  276,
 /*   200 */   210, 1261, 1267,  210, 1261,  210,  210,  210, 1225,  210,
 /*   210 */  1251, 1251, 1250,  305,  305,  305,  305,  305,  305,  305,
 /*   220 */   305,  305,  305,  305, 1225, 1250,  651, 1122, 1256,  367,
 /*   230 */  1135,  276,  367, 1225, 1225, 1261,  367, 1092,  651,  651,
 /*   240 */   651,  651, 1092,  651, 1173,  367,  447,  367,  436, 1217,
 /*   250 */  1217,  651, 1097, 1092,  651,  651, 1097, 1092,  651,  651,
 /*   260 */   305, 1095, 1180, 1097, 1104, 1145, 1149,  967, 1134, 1141,
 /*   270 */  1147, 1164,  436, 1390, 1316, 1319,  651,  657, 1225,  367,
 /*   280 */  1382, 1250, 3135, 3135, 3135, 3135, 3135, 3135, 3135, 1085,
 /*   290 */   358,   23,   54,  183,  374,  688,  424,  638,  654,  549,
 /*   300 */   774,  774,  774,  774,  774,  774,  774,  774,  774,  584,
 /*   310 */   409,  307,  759,  782,  782,  226,  564,   14,  468,  393,
 /*   320 */    75,  329,  480,   75,   75,   75,  714,  643,  896,  978,
 /*   330 */   146,   36,  932,  946,  952,  958, 1046, 1087, 1090,  280,
 /*   340 */   901,  892,  926,  975, 1007, 1018, 1020, 1021,  963,  947,
 /*   350 */   986, 1098, 1022,  349, 1045, 1029, 1058, 1093, 1083, 1137,
 /*   360 */  1138, 1140, 1142, 1143, 1144, 1003, 1177, 1178, 1157, 1193,
 /*   370 */  1456, 1457, 1273, 1459, 1462, 1421, 1464, 1430, 1269, 1432,
 /*   380 */  1433, 1434, 1274, 1472, 1438, 1439, 1279, 1477, 1281, 1481,
 /*   390 */  1454, 1492, 1471, 1494, 1461, 1318, 1322, 1503, 1505, 1333,
 /*   400 */  1335, 1509, 1512, 1467, 1514, 1515, 1516, 1475, 1519, 1520,
 /*   410 */  1521, 1522, 1524, 1526, 1527, 1528, 1380, 1496, 1532, 1384,
 /*   420 */  1535, 1536, 1544, 1546, 1547, 1548, 1550, 1551, 1552, 1554,
 /*   430 */  1555, 1563, 1565, 1566, 1570, 1530, 1573, 1574, 1578, 1579,
 /*   440 */  1584, 1564, 1585, 1591, 1592, 1593, 1533, 1594, 1538, 1596,
 /*   450 */  1540, 1599, 1600, 1562, 1567, 1559, 1575, 1571, 1595, 1572,
 /*   460 */  1605, 1576, 1569, 1610, 1611, 1612, 1580, 1444, 1614, 1621,
 /*   470 */  1623, 1561, 1626, 1627, 1597, 1582, 1601, 1630, 1598, 1587,
 /*   480 */  1603, 1631, 1604, 1588, 1606, 1638, 1609, 1602, 1608, 1648,
 /*   490 */  1651, 1652, 1660, 1558, 1586, 1628, 1642, 1665, 1634, 1635,
 /*   500 */  1659, 1649, 1655, 1643, 1653, 1657, 1662, 1669, 1663, 1695,
 /*   510 */  1677, 1700, 1679, 1654, 1702, 1682, 1670, 1706, 1673, 1707,
 /*   520 */  1674, 1710, 1689, 1692, 1618, 1620, 1716, 1556, 1683, 1719,
 /*   530 */  1539, 1701, 1577, 1581, 1722, 1724, 1590, 1583, 1729, 1725,
 /*   540 */  1733, 1734, 1632, 1633, 1696, 1704, 1545, 1730, 1641, 1613,
 /*   550 */  1645, 1737, 1703, 1607, 1646, 1640, 1697, 1711, 1541, 1543,
 /*   560 */  1557, 1712, 1501, 1658, 1661, 1678, 1680, 1684, 1686, 1715,
 /*   570 */  1694, 1698, 1699, 1705, 1708, 1732, 1745, 1746, 1713, 1752,
 /*   580 */  1553, 1709, 1714, 1793, 1754, 1615, 1766, 1767, 1768, 1772,
 /*   590 */  1774, 1777, 1718, 1720, 1769, 1616, 1775, 1771, 1773, 1818,
 /*   600 */  1799, 1619, 1728, 1731, 1735, 1736, 1738, 1739, 1779, 1741,
 /*   610 */  1743, 1780, 1744, 1806, 1624, 1748, 1749, 1755, 1796, 1804,
 /*   620 */  1762, 1764, 1807, 1763, 1770, 1830, 1776, 1778, 1833, 1781,
 /*   630 */  1782, 1837, 1784, 1751, 1756, 1758, 1761, 1851, 1783, 1786,
 /*   640 */  1789, 1850, 1791, 1844, 1844, 1866, 1826, 1687, 1857, 1859,
 /*   650 */  1860, 1864, 1878, 1879, 1880, 1881, 1882, 1883, 1765, 1827,
 /*   660 */  1885, 1886, 1888, 1902, 1901, 1916, 1904, 1905, 1907, 1874,
 /*   670 */  1643, 1909, 1653, 1910, 1911, 1912, 1913, 1928, 1917, 1953,
 /*   680 */  1922, 1918, 1929, 1967, 1934, 1925, 1935, 1973, 1940, 1930,
 /*   690 */  1937, 1979, 1946, 1936, 1943, 1985, 1951, 1961, 1997, 1976,
 /*   700 */  1978, 1981, 1982, 1980, 1986,
};
#define YY_REDUCE_COUNT (288)
#define YY_REDUCE_MIN   (-357)
#define YY_REDUCE_MAX   (2728)
static const short yy_reduce_ofst[] = {
 /*     0 */   116, -321,  363,  862,  675,  973, 1028, 1084, 1139, 1158,
 /*    10 */  1255, 1276, 1361, 1446, 1502, 1531, 1560, 1589, 1656, 1672,
 /*    20 */  1727, 1747, 1812, 1870, 1884, 1942, 1956, 2009, 2064, 2080,
 /*    30 */  2135, 2151, 2207, 2223, 2279, 2295, 2362, 2387, 2448, 2501,
 /*    40 */  2519, 2575, 2589, 2645, 2661, 2728, -323, -334,  171, -275,
 /*    50 */  -155,    2,  123,  134,  698,  868, -335,  560, -130,  233,
 /*    60 */   327, -133,   -1, -322,  473, -347, -326, -312, -357, -319,
 /*    70 */  -188,  215,  356,  364,  470,  481,  488,  502,  578, -110,
 /*    80 */   583,  598,  604,  -99,  619,  631, -277,  687,  693, -166,
 /*    90 */   102,  709,   58,  -85,  105,  729, -291, -211, -302, -302,
 /*   100 */  -296,   11, -204,  -42,  178,  203,  224,  266,  279,  300,
 /*   110 */   319,  434,  437,  456,  463,  577,  588,  600,  608,  610,
 /*   120 */   611,   42,  108,  195, -121, -298,   70,  106,  122,  309,
 /*   130 */   142,  397,  108,  274,  411,  310, -356,  400,  446,  427,
 /*   140 */   539,  465,  536,  568,  555,  337,  606,  620,  639,  587,
 /*   150 */  -310,  641,  752,  753,  754,  757,  758,  591,  783,  803,
 /*   160 */   740,  673,  738,  863,  760,  847,  847,  871,  828,  875,
 /*   170 */   841,  831,  781,  781,  764,  781,  791,  786,  847,  830,
 /*   180 */   829,  839,  859,  867,  872,  873,  917,  918,  878,  882,
 /*   190 */   885,  914,  928,  929,  939,  948,  953,  889,  949,  915,
 /*   200 */   950,  904,  910,  961,  906,  962,  964,  965,  968,  966,
 /*   210 */   971,  972,  981,  954,  955,  956,  957,  959,  969,  970,
 /*   220 */   974,  976,  980,  983,  982,  989,  945,  925,  927,  984,
 /*   230 */   931,  987,  990,  994,  997,  938, 1004,  985,  977,  988,
 /*   240 */   991, 1000, 1005, 1001, 1002, 1006,  995, 1012, 1025,  992,
 /*   250 */  1014, 1016,  979, 1009, 1017, 1027,  999, 1019, 1031, 1033,
 /*   260 */   847,  911, 1011, 1008, 1010,  993, 1023, 1015,  951, 1013,
 /*   270 */  1024,  781, 1049, 1038,  996, 1059, 1051, 1075, 1091, 1089,
 /*   280 */  1099, 1096, 1052, 1056, 1094, 1102, 1106, 1116, 1133,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*    10 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*    20 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*    30 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*    40 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*    50 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*    60 */  1582, 1582, 1582, 1582, 1582, 1835, 1582, 1582, 1582, 1582,
 /*    70 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1658,
 /*    80 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*    90 */  1582, 1582, 1582, 1582, 1582, 1582, 1656, 1828, 2025, 1582,
 /*   100 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   110 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   120 */  1582, 1582, 2037, 1582, 1582, 1582, 1582, 1658, 1582, 1656,
 /*   130 */  1997, 1997, 2037, 2037, 2037, 1582, 1582, 1582, 1582, 1767,
 /*   140 */  1582, 1877, 1877, 1582, 1582, 1582, 1582, 1582, 1767, 1582,
 /*   150 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1871, 1582, 1582,
 /*   160 */  2062, 2115, 1582, 1582, 2065, 1582, 1582, 1582, 1840, 1582,
 /*   170 */  1720, 2052, 2029, 2043, 2099, 2030, 2027, 2046, 1582, 2056,
 /*   180 */  1582, 1864, 1833, 1582, 1833, 1830, 1582, 1582, 1833, 1830,
 /*   190 */  1830, 1711, 1582, 1582, 1582, 1582, 1582, 1582, 1658, 1582,
 /*   200 */  1658, 1582, 1582, 1658, 1582, 1658, 1658, 1658, 1582, 1658,
 /*   210 */  1637, 1637, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   220 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1884, 1582, 1656,
 /*   230 */  1873, 1582, 1656, 1582, 1582, 1582, 1656, 2070, 1582, 1582,
 /*   240 */  1582, 1582, 2070, 1582, 1582, 1656, 1582, 1656, 1582, 1582,
 /*   250 */  1582, 1582, 2072, 2070, 1582, 1582, 2072, 2070, 1582, 1582,
 /*   260 */  1582, 2084, 2080, 2072, 2088, 2086, 2058, 2056, 2118, 2105,
 /*   270 */  2101, 2043, 1582, 1582, 1582, 1736, 1582, 1582, 1582, 1656,
 /*   280 */  1614, 1582, 1866, 1877, 1770, 1770, 1770, 1659, 1587, 1582,
 /*   290 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   300 */  1953, 1582, 2083, 2082, 2001, 2000, 1999, 1990, 1952, 1582,
 /*   310 */  1732, 1582, 1582, 1951, 1950, 1582, 1582, 1582, 1582, 1582,
 /*   320 */  1944, 1582, 1582, 1945, 1943, 1942, 1582, 1582, 1582, 1582,
 /*   330 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   340 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 2102,
 /*   350 */  2106, 2026, 1582, 1582, 1582, 1582, 1582, 1935, 1926, 1582,
 /*   360 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   370 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   380 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   390 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   400 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   410 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   420 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   430 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   440 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   450 */  1582, 1582, 1582, 1582, 1582, 1619, 1582, 1582, 1582, 1582,
 /*   460 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   470 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   480 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   490 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   500 */  1582, 1582, 1582, 1698, 1697, 1582, 1582, 1582, 1582, 1582,
 /*   510 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   520 */  1582, 1582, 1582, 1582, 1934, 1582, 1582, 1582, 1582, 1582,
 /*   530 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 2098, 1582,
 /*   540 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1881, 1582, 1582,
 /*   550 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1987, 1582, 1582,
 /*   560 */  1582, 2059, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   570 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1926, 1582, 2081,
 /*   580 */  1582, 1582, 2096, 1582, 2100, 1582, 1582, 1582, 1582, 1582,
 /*   590 */  1582, 1582, 2036, 2032, 1582, 1582, 2028, 1925, 1582, 2021,
 /*   600 */  1582, 1582, 1972, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   610 */  1582, 1582, 1934, 1582, 1938, 1582, 1582, 1582, 1582, 1582,
 /*   620 */  1764, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   630 */  1582, 1582, 1582, 1749, 1747, 1746, 1745, 1582, 1742, 1582,
 /*   640 */  1582, 1582, 1582, 1773, 1772, 1582, 1582, 1582, 1582, 1582,
 /*   650 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   660 */  1678, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   670 */  1669, 1582, 1668, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   680 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   690 */  1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
 /*   700 */  1582, 1582, 1582, 1582, 1582,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  266,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  266,  /*      AFTER => ABORT */
  266,  /*     ATTACH => ABORT */
  266,  /*     BEFORE => ABORT */
  266,  /*      BEGIN => ABORT */
  266,  /*     BITAND => ABORT */
  266,  /*     BITNOT => ABORT */
  266,  /*      BITOR => ABORT */
  266,  /*     BLOCKS => ABORT */
  266,  /*     CHANGE => ABORT */
  266,  /*      COMMA => ABORT */
  266,  /*    COMPACT => ABORT */
  266,  /*     CONCAT => ABORT */
  266,  /*   CONFLICT => ABORT */
  266,  /*       COPY => ABORT */
  266,  /*   DEFERRED => ABORT */
  266,  /* DELIMITERS => ABORT */
  266,  /*     DETACH => ABORT */
  266,  /*     DIVIDE => ABORT */
  266,  /*        DOT => ABORT */
  266,  /*       EACH => ABORT */
  266,  /*       FAIL => ABORT */
  266,  /*       FILE => ABORT */
  266,  /*        FOR => ABORT */
  266,  /*       GLOB => ABORT */
  266,  /*         ID => ABORT */
  266,  /*  IMMEDIATE => ABORT */
  266,  /*     IMPORT => ABORT */
  266,  /*  INITIALLY => ABORT */
  266,  /*    INSTEAD => ABORT */
  266,  /*     ISNULL => ABORT */
  266,  /*        KEY => ABORT */
  266,  /*    MODULES => ABORT */
  266,  /*  NK_BITNOT => ABORT */
  266,  /*    NK_SEMI => ABORT */
  266,  /*    NOTNULL => ABORT */
  266,  /*         OF => ABORT */
  266,  /*       PLUS => ABORT */
  266,  /*  PRIVILEGE => ABORT */
  266,  /*      RAISE => ABORT */
  266,  /*    REPLACE => ABORT */
  266,  /*   RESTRICT => ABORT */
  266,  /*        ROW => ABORT */
  266,  /*       SEMI => ABORT */
  266,  /*       STAR => ABORT */
  266,  /*  STATEMENT => ABORT */
  266,  /*     STRING => ABORT */
  266,  /*      TIMES => ABORT */
  266,  /*     UPDATE => ABORT */
  266,  /*     VALUES => ABORT */
  266,  /*   VARIABLE => ABORT */
  266,  /*       VIEW => ABORT */
  266,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "FORCE",
  /*   52 */ "LOCAL",
  /*   53 */ "QNODE",
  /*   54 */ "BNODE",
  /*   55 */ "SNODE",
  /*   56 */ "MNODE",
  /*   57 */ "DATABASE",
  /*   58 */ "USE",
  /*   59 */ "FLUSH",
  /*   60 */ "TRIM",
  /*   61 */ "IF",
  /*   62 */ "NOT",
  /*   63 */ "EXISTS",
  /*   64 */ "BUFFER",
  /*   65 */ "CACHEMODEL",
  /*   66 */ "CACHESIZE",
  /*   67 */ "COMP",
  /*   68 */ "DURATION",
  /*   69 */ "NK_VARIABLE",
  /*   70 */ "MAXROWS",
  /*   71 */ "MINROWS",
  /*   72 */ "KEEP",
  /*   73 */ "PAGES",
  /*   74 */ "PAGESIZE",
  /*   75 */ "TSDB_PAGESIZE",
  /*   76 */ "PRECISION",
  /*   77 */ "REPLICA",
  /*   78 */ "STRICT",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "FIRST",
  /*  132 */ "LAST",
  /*  133 */ "SHOW",
  /*  134 */ "DATABASES",
  /*  135 */ "TABLES",
  /*  136 */ "STABLES",
  /*  137 */ "MNODES",
  /*  138 */ "QNODES",
  /*  139 */ "FUNCTIONS",
  /*  140 */ "INDEXES",
  /*  141 */ "ACCOUNTS",
  /*  142 */ "APPS",
  /*  143 */ "CONNECTIONS",
  /*  144 */ "LICENCES",
  /*  145 */ "GRANTS",
  /*  146 */ "QUERIES",
  /*  147 */ "SCORES",
  /*  148 */ "TOPICS",
  /*  149 */ "VARIABLES",
  /*  150 */ "CLUSTER",
  /*  151 */ "BNODES",
  /*  152 */ "SNODES",
  /*  153 */ "TRANSACTIONS",
  /*  154 */ "DISTRIBUTED",
  /*  155 */ "CONSUMERS",
  /*  156 */ "SUBSCRIPTIONS",
  /*  157 */ "VNODES",
  /*  158 */ "LIKE",
  /*  159 */ "TBNAME",
  /*  160 */ "QTAGS",
  /*  161 */ "AS",
  /*  162 */ "INDEX",
  /*  163 */ "FUNCTION",
  /*  164 */ "INTERVAL",
  /*  165 */ "TOPIC",
  /*  166 */ "WITH",
  /*  167 */ "META",
  /*  168 */ "CONSUMER",
  /*  169 */ "GROUP",
  /*  170 */ "DESC",
  /*  171 */ "DESCRIBE",
  /*  172 */ "RESET",
  /*  173 */ "QUERY",
  /*  174 */ "CACHE",
  /*  175 */ "EXPLAIN",
  /*  176 */ "ANALYZE",
  /*  177 */ "VERBOSE",
  /*  178 */ "NK_BOOL",
  /*  179 */ "RATIO",
  /*  180 */ "NK_FLOAT",
  /*  181 */ "OUTPUTTYPE",
  /*  182 */ "AGGREGATE",
  /*  183 */ "BUFSIZE",
  /*  184 */ "STREAM",
  /*  185 */ "INTO",
  /*  186 */ "TRIGGER",
  /*  187 */ "AT_ONCE",
  /*  188 */ "WINDOW_CLOSE",
  /*  189 */ "IGNORE",
  /*  190 */ "EXPIRED",
  /*  191 */ "FILL_HISTORY",
  /*  192 */ "SUBTABLE",
  /*  193 */ "KILL",
  /*  194 */ "CONNECTION",
  /*  195 */ "TRANSACTION",
  /*  196 */ "BALANCE",
  /*  197 */ "VGROUP",
  /*  198 */ "MERGE",
  /*  199 */ "REDISTRIBUTE",
  /*  200 */ "SPLIT",
  /*  201 */ "DELETE",
  /*  202 */ "INSERT",
  /*  203 */ "NULL",
  /*  204 */ "NK_QUESTION",
  /*  205 */ "NK_ARROW",
  /*  206 */ "ROWTS",
  /*  207 */ "QSTART",
  /*  208 */ "QEND",
  /*  209 */ "QDURATION",
  /*  210 */ "WSTART",
  /*  211 */ "WEND",
  /*  212 */ "WDURATION",
  /*  213 */ "IROWTS",
  /*  214 */ "CAST",
  /*  215 */ "NOW",
  /*  216 */ "TODAY",
  /*  217 */ "TIMEZONE",
  /*  218 */ "CLIENT_VERSION",
  /*  219 */ "SERVER_VERSION",
  /*  220 */ "SERVER_STATUS",
  /*  221 */ "CURRENT_USER",
  /*  222 */ "COUNT",
  /*  223 */ "LAST_ROW",
  /*  224 */ "CASE",
  /*  225 */ "END",
  /*  226 */ "WHEN",
  /*  227 */ "THEN",
  /*  228 */ "ELSE",
  /*  229 */ "BETWEEN",
  /*  230 */ "IS",
  /*  231 */ "NK_LT",
  /*  232 */ "NK_GT",
  /*  233 */ "NK_LE",
  /*  234 */ "NK_GE",
  /*  235 */ "NK_NE",
  /*  236 */ "MATCH",
  /*  237 */ "NMATCH",
  /*  238 */ "CONTAINS",
  /*  239 */ "IN",
  /*  240 */ "JOIN",
  /*  241 */ "INNER",
  /*  242 */ "SELECT",
  /*  243 */ "DISTINCT",
  /*  244 */ "WHERE",
  /*  245 */ "PARTITION",
  /*  246 */ "BY",
  /*  247 */ "SESSION",
  /*  248 */ "STATE_WINDOW",
  /*  249 */ "SLIDING",
  /*  250 */ "FILL",
  /*  251 */ "VALUE",
  /*  252 */ "NONE",
  /*  253 */ "PREV",
  /*  254 */ "LINEAR",
  /*  255 */ "NEXT",
  /*  256 */ "HAVING",
  /*  257 */ "RANGE",
  /*  258 */ "EVERY",
  /*  259 */ "ORDER",
  /*  260 */ "SLIMIT",
  /*  261 */ "SOFFSET",
  /*  262 */ "LIMIT",
  /*  263 */ "OFFSET",
  /*  264 */ "ASC",
  /*  265 */ "NULLS",
  /*  266 */ "ABORT",
  /*  267 */ "AFTER",
  /*  268 */ "ATTACH",
  /*  269 */ "BEFORE",
  /*  270 */ "BEGIN",
  /*  271 */ "BITAND",
  /*  272 */ "BITNOT",
  /*  273 */ "BITOR",
  /*  274 */ "BLOCKS",
  /*  275 */ "CHANGE",
  /*  276 */ "COMMA",
  /*  277 */ "COMPACT",
  /*  278 */ "CONCAT",
  /*  279 */ "CONFLICT",
  /*  280 */ "COPY",
  /*  281 */ "DEFERRED",
  /*  282 */ "DELIMITERS",
  /*  283 */ "DETACH",
  /*  284 */ "DIVIDE",
  /*  285 */ "DOT",
  /*  286 */ "EACH",
  /*  287 */ "FAIL",
  /*  288 */ "FILE",
  /*  289 */ "FOR",
  /*  290 */ "GLOB",
  /*  291 */ "ID",
  /*  292 */ "IMMEDIATE",
  /*  293 */ "IMPORT",
  /*  294 */ "INITIALLY",
  /*  295 */ "INSTEAD",
  /*  296 */ "ISNULL",
  /*  297 */ "KEY",
  /*  298 */ "MODULES",
  /*  299 */ "NK_BITNOT",
  /*  300 */ "NK_SEMI",
  /*  301 */ "NOTNULL",
  /*  302 */ "OF",
  /*  303 */ "PLUS",
  /*  304 */ "PRIVILEGE",
  /*  305 */ "RAISE",
  /*  306 */ "REPLACE",
  /*  307 */ "RESTRICT",
  /*  308 */ "ROW",
  /*  309 */ "SEMI",
  /*  310 */ "STAR",
  /*  311 */ "STATEMENT",
  /*  312 */ "STRING",
  /*  313 */ "TIMES",
  /*  314 */ "UPDATE",
  /*  315 */ "VALUES",
  /*  316 */ "VARIABLE",
  /*  317 */ "VIEW",
  /*  318 */ "WAL",
  /*  319 */ "cmd",
  /*  320 */ "account_options",
  /*  321 */ "alter_account_options",
  /*  322 */ "literal",
  /*  323 */ "alter_account_option",
  /*  324 */ "user_name",
  /*  325 */ "sysinfo_opt",
  /*  326 */ "privileges",
  /*  327 */ "priv_level",
  /*  328 */ "priv_type_list",
  /*  329 */ "priv_type",
  /*  330 */ "db_name",
  /*  331 */ "dnode_endpoint",
  /*  332 */ "force_opt",
  /*  333 */ "not_exists_opt",
  /*  334 */ "db_options",
  /*  335 */ "exists_opt",
  /*  336 */ "alter_db_options",
  /*  337 */ "speed_opt",
  /*  338 */ "integer_list",
  /*  339 */ "variable_list",
  /*  340 */ "retention_list",
  /*  341 */ "alter_db_option",
  /*  342 */ "retention",
  /*  343 */ "full_table_name",
  /*  344 */ "column_def_list",
  /*  345 */ "tags_def_opt",
  /*  346 */ "table_options",
  /*  347 */ "multi_create_clause",
  /*  348 */ "tags_def",
  /*  349 */ "multi_drop_clause",
  /*  350 */ "alter_table_clause",
  /*  351 */ "alter_table_options",
  /*  352 */ "column_name",
  /*  353 */ "type_name",
  /*  354 */ "signed_literal",
  /*  355 */ "create_subtable_clause",
  /*  356 */ "specific_cols_opt",
  /*  357 */ "expression_list",
  /*  358 */ "drop_table_clause",
  /*  359 */ "col_name_list",
  /*  360 */ "table_name",
  /*  361 */ "column_def",
  /*  362 */ "duration_list",
  /*  363 */ "rollup_func_list",
  /*  364 */ "alter_table_option",
  /*  365 */ "duration_literal",
  /*  366 */ "rollup_func_name",
  /*  367 */ "function_name",
  /*  368 */ "col_name",
  /*  369 */ "db_name_cond_opt",
  /*  370 */ "like_pattern_opt",
  /*  371 */ "table_name_cond",
  /*  372 */ "from_db_opt",
  /*  373 */ "tag_list_opt",
  /*  374 */ "tag_item",
  /*  375 */ "column_alias",
  /*  376 */ "index_options",
  /*  377 */ "func_list",
  /*  378 */ "sliding_opt",
  /*  379 */ "sma_stream_opt",
  /*  380 */ "func",
  /*  381 */ "stream_options",
  /*  382 */ "topic_name",
  /*  383 */ "query_or_subquery",
  /*  384 */ "cgroup_name",
  /*  385 */ "analyze_opt",
  /*  386 */ "explain_options",
  /*  387 */ "agg_func_opt",
  /*  388 */ "bufsize_opt",
  /*  389 */ "stream_name",
  /*  390 */ "subtable_opt",
  /*  391 */ "expression",
  /*  392 */ "dnode_list",
  /*  393 */ "where_clause_opt",
  /*  394 */ "signed",
  /*  395 */ "literal_func",
  /*  396 */ "literal_list",
  /*  397 */ "table_alias",
  /*  398 */ "expr_or_subquery",
  /*  399 */ "subquery",
  /*  400 */ "pseudo_column",
  /*  401 */ "column_reference",
  /*  402 */ "function_expression",
  /*  403 */ "case_when_expression",
  /*  404 */ "star_func",
  /*  405 */ "star_func_para_list",
  /*  406 */ "noarg_func",
  /*  407 */ "other_para_list",
  /*  408 */ "star_func_para",
  /*  409 */ "when_then_list",
  /*  410 */ "case_when_else_opt",
  /*  411 */ "common_expression",
  /*  412 */ "when_then_expr",
  /*  413 */ "predicate",
  /*  414 */ "compare_op",
  /*  415 */ "in_op",
  /*  416 */ "in_predicate_value",
  /*  417 */ "boolean_value_expression",
  /*  418 */ "boolean_primary",
  /*  419 */ "from_clause_opt",
  /*  420 */ "table_reference_list",
  /*  421 */ "table_reference",
  /*  422 */ "table_primary",
  /*  423 */ "joined_table",
  /*  424 */ "alias_opt",
  /*  425 */ "parenthesized_joined_table",
  /*  426 */ "join_type",
  /*  427 */ "search_condition",
  /*  428 */ "query_specification",
  /*  429 */ "set_quantifier_opt",
  /*  430 */ "select_list",
  /*  431 */ "partition_by_clause_opt",
  /*  432 */ "range_opt",
  /*  433 */ "every_opt",
  /*  434 */ "fill_opt",
  /*  435 */ "twindow_clause_opt",
  /*  436 */ "group_by_clause_opt",
  /*  437 */ "having_clause_opt",
  /*  438 */ "select_item",
  /*  439 */ "partition_list",
  /*  440 */ "partition_item",
  /*  441 */ "fill_mode",
  /*  442 */ "group_by_list",
  /*  443 */ "query_expression",
  /*  444 */ "query_simple",
  /*  445 */ "order_by_clause_opt",
  /*  446 */ "slimit_clause_opt",
  /*  447 */ "limit_clause_opt",
  /*  448 */ "union_query_expression",
  /*  449 */ "query_simple_or_subquery",
  /*  450 */ "sort_specification_list",
  /*  451 */ "sort_specification",
  /*  452 */ "ordering_specification_opt",
  /*  453 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "force_opt ::=",
 /*  53 */ "force_opt ::= FORCE",
 /*  54 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  55 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  56 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  65 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  66 */ "cmd ::= USE db_name",
 /*  67 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  68 */ "cmd ::= FLUSH DATABASE db_name",
 /*  69 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  70 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  71 */ "not_exists_opt ::=",
 /*  72 */ "exists_opt ::= IF EXISTS",
 /*  73 */ "exists_opt ::=",
 /*  74 */ "db_options ::=",
 /*  75 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  76 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  77 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  78 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  79 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  80 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  81 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  82 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  83 */ "db_options ::= db_options KEEP integer_list",
 /*  84 */ "db_options ::= db_options KEEP variable_list",
 /*  85 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  86 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  87 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  88 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  89 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  90 */ "db_options ::= db_options STRICT NK_STRING",
 /*  91 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  92 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  93 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  94 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 103 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 104 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 106 */ "alter_db_options ::= alter_db_option",
 /* 107 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 108 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 109 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 110 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 111 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 112 */ "alter_db_option ::= KEEP integer_list",
 /* 113 */ "alter_db_option ::= KEEP variable_list",
 /* 114 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 115 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 116 */ "alter_db_option ::= STRICT NK_STRING",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "alter_table_options ::= alter_table_option",
 /* 193 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 194 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 195 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 196 */ "duration_list ::= duration_literal",
 /* 197 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 198 */ "rollup_func_list ::= rollup_func_name",
 /* 199 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 200 */ "rollup_func_name ::= function_name",
 /* 201 */ "rollup_func_name ::= FIRST",
 /* 202 */ "rollup_func_name ::= LAST",
 /* 203 */ "col_name_list ::= col_name",
 /* 204 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 205 */ "col_name ::= column_name",
 /* 206 */ "cmd ::= SHOW DNODES",
 /* 207 */ "cmd ::= SHOW USERS",
 /* 208 */ "cmd ::= SHOW DATABASES",
 /* 209 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 210 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 212 */ "cmd ::= SHOW MNODES",
 /* 213 */ "cmd ::= SHOW QNODES",
 /* 214 */ "cmd ::= SHOW FUNCTIONS",
 /* 215 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 216 */ "cmd ::= SHOW STREAMS",
 /* 217 */ "cmd ::= SHOW ACCOUNTS",
 /* 218 */ "cmd ::= SHOW APPS",
 /* 219 */ "cmd ::= SHOW CONNECTIONS",
 /* 220 */ "cmd ::= SHOW LICENCES",
 /* 221 */ "cmd ::= SHOW GRANTS",
 /* 222 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 223 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 224 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 225 */ "cmd ::= SHOW QUERIES",
 /* 226 */ "cmd ::= SHOW SCORES",
 /* 227 */ "cmd ::= SHOW TOPICS",
 /* 228 */ "cmd ::= SHOW VARIABLES",
 /* 229 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 230 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 231 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 232 */ "cmd ::= SHOW BNODES",
 /* 233 */ "cmd ::= SHOW SNODES",
 /* 234 */ "cmd ::= SHOW CLUSTER",
 /* 235 */ "cmd ::= SHOW TRANSACTIONS",
 /* 236 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 237 */ "cmd ::= SHOW CONSUMERS",
 /* 238 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 239 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 240 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 241 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 242 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 243 */ "db_name_cond_opt ::=",
 /* 244 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 245 */ "like_pattern_opt ::=",
 /* 246 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 247 */ "table_name_cond ::= table_name",
 /* 248 */ "from_db_opt ::=",
 /* 249 */ "from_db_opt ::= FROM db_name",
 /* 250 */ "tag_list_opt ::=",
 /* 251 */ "tag_list_opt ::= tag_item",
 /* 252 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 253 */ "tag_item ::= TBNAME",
 /* 254 */ "tag_item ::= QTAGS",
 /* 255 */ "tag_item ::= column_name",
 /* 256 */ "tag_item ::= column_name column_alias",
 /* 257 */ "tag_item ::= column_name AS column_alias",
 /* 258 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 259 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 260 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 261 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 262 */ "func_list ::= func",
 /* 263 */ "func_list ::= func_list NK_COMMA func",
 /* 264 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 265 */ "sma_stream_opt ::=",
 /* 266 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 267 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 268 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 269 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 270 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 271 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 272 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 273 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 274 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 275 */ "cmd ::= DESC full_table_name",
 /* 276 */ "cmd ::= DESCRIBE full_table_name",
 /* 277 */ "cmd ::= RESET QUERY CACHE",
 /* 278 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 279 */ "analyze_opt ::=",
 /* 280 */ "analyze_opt ::= ANALYZE",
 /* 281 */ "explain_options ::=",
 /* 282 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 283 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 284 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 285 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 286 */ "agg_func_opt ::=",
 /* 287 */ "agg_func_opt ::= AGGREGATE",
 /* 288 */ "bufsize_opt ::=",
 /* 289 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 290 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 291 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 292 */ "stream_options ::=",
 /* 293 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 294 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 295 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 296 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 297 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 298 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 299 */ "subtable_opt ::=",
 /* 300 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 301 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 302 */ "cmd ::= KILL QUERY NK_STRING",
 /* 303 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 304 */ "cmd ::= BALANCE VGROUP",
 /* 305 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 306 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 307 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 308 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 309 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 310 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 311 */ "cmd ::= query_or_subquery",
 /* 312 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 313 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 314 */ "literal ::= NK_INTEGER",
 /* 315 */ "literal ::= NK_FLOAT",
 /* 316 */ "literal ::= NK_STRING",
 /* 317 */ "literal ::= NK_BOOL",
 /* 318 */ "literal ::= TIMESTAMP NK_STRING",
 /* 319 */ "literal ::= duration_literal",
 /* 320 */ "literal ::= NULL",
 /* 321 */ "literal ::= NK_QUESTION",
 /* 322 */ "duration_literal ::= NK_VARIABLE",
 /* 323 */ "signed ::= NK_INTEGER",
 /* 324 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 325 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 326 */ "signed ::= NK_FLOAT",
 /* 327 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 328 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 329 */ "signed_literal ::= signed",
 /* 330 */ "signed_literal ::= NK_STRING",
 /* 331 */ "signed_literal ::= NK_BOOL",
 /* 332 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 333 */ "signed_literal ::= duration_literal",
 /* 334 */ "signed_literal ::= NULL",
 /* 335 */ "signed_literal ::= literal_func",
 /* 336 */ "signed_literal ::= NK_QUESTION",
 /* 337 */ "literal_list ::= signed_literal",
 /* 338 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 339 */ "db_name ::= NK_ID",
 /* 340 */ "table_name ::= NK_ID",
 /* 341 */ "column_name ::= NK_ID",
 /* 342 */ "function_name ::= NK_ID",
 /* 343 */ "table_alias ::= NK_ID",
 /* 344 */ "column_alias ::= NK_ID",
 /* 345 */ "user_name ::= NK_ID",
 /* 346 */ "topic_name ::= NK_ID",
 /* 347 */ "stream_name ::= NK_ID",
 /* 348 */ "cgroup_name ::= NK_ID",
 /* 349 */ "expr_or_subquery ::= expression",
 /* 350 */ "expr_or_subquery ::= subquery",
 /* 351 */ "expression ::= literal",
 /* 352 */ "expression ::= pseudo_column",
 /* 353 */ "expression ::= column_reference",
 /* 354 */ "expression ::= function_expression",
 /* 355 */ "expression ::= case_when_expression",
 /* 356 */ "expression ::= NK_LP expression NK_RP",
 /* 357 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 358 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 359 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 360 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 361 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 362 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 363 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 364 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 365 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 367 */ "expression_list ::= expr_or_subquery",
 /* 368 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 369 */ "column_reference ::= column_name",
 /* 370 */ "column_reference ::= table_name NK_DOT column_name",
 /* 371 */ "pseudo_column ::= ROWTS",
 /* 372 */ "pseudo_column ::= TBNAME",
 /* 373 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 374 */ "pseudo_column ::= QSTART",
 /* 375 */ "pseudo_column ::= QEND",
 /* 376 */ "pseudo_column ::= QDURATION",
 /* 377 */ "pseudo_column ::= WSTART",
 /* 378 */ "pseudo_column ::= WEND",
 /* 379 */ "pseudo_column ::= WDURATION",
 /* 380 */ "pseudo_column ::= IROWTS",
 /* 381 */ "pseudo_column ::= QTAGS",
 /* 382 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 383 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 384 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 385 */ "function_expression ::= literal_func",
 /* 386 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 387 */ "literal_func ::= NOW",
 /* 388 */ "noarg_func ::= NOW",
 /* 389 */ "noarg_func ::= TODAY",
 /* 390 */ "noarg_func ::= TIMEZONE",
 /* 391 */ "noarg_func ::= DATABASE",
 /* 392 */ "noarg_func ::= CLIENT_VERSION",
 /* 393 */ "noarg_func ::= SERVER_VERSION",
 /* 394 */ "noarg_func ::= SERVER_STATUS",
 /* 395 */ "noarg_func ::= CURRENT_USER",
 /* 396 */ "noarg_func ::= USER",
 /* 397 */ "star_func ::= COUNT",
 /* 398 */ "star_func ::= FIRST",
 /* 399 */ "star_func ::= LAST",
 /* 400 */ "star_func ::= LAST_ROW",
 /* 401 */ "star_func_para_list ::= NK_STAR",
 /* 402 */ "star_func_para_list ::= other_para_list",
 /* 403 */ "other_para_list ::= star_func_para",
 /* 404 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 405 */ "star_func_para ::= expr_or_subquery",
 /* 406 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 407 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 408 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 409 */ "when_then_list ::= when_then_expr",
 /* 410 */ "when_then_list ::= when_then_list when_then_expr",
 /* 411 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 412 */ "case_when_else_opt ::=",
 /* 413 */ "case_when_else_opt ::= ELSE common_expression",
 /* 414 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 415 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 416 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 417 */ "predicate ::= expr_or_subquery IS NULL",
 /* 418 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 419 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 420 */ "compare_op ::= NK_LT",
 /* 421 */ "compare_op ::= NK_GT",
 /* 422 */ "compare_op ::= NK_LE",
 /* 423 */ "compare_op ::= NK_GE",
 /* 424 */ "compare_op ::= NK_NE",
 /* 425 */ "compare_op ::= NK_EQ",
 /* 426 */ "compare_op ::= LIKE",
 /* 427 */ "compare_op ::= NOT LIKE",
 /* 428 */ "compare_op ::= MATCH",
 /* 429 */ "compare_op ::= NMATCH",
 /* 430 */ "compare_op ::= CONTAINS",
 /* 431 */ "in_op ::= IN",
 /* 432 */ "in_op ::= NOT IN",
 /* 433 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 434 */ "boolean_value_expression ::= boolean_primary",
 /* 435 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 436 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 437 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 438 */ "boolean_primary ::= predicate",
 /* 439 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 440 */ "common_expression ::= expr_or_subquery",
 /* 441 */ "common_expression ::= boolean_value_expression",
 /* 442 */ "from_clause_opt ::=",
 /* 443 */ "from_clause_opt ::= FROM table_reference_list",
 /* 444 */ "table_reference_list ::= table_reference",
 /* 445 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 446 */ "table_reference ::= table_primary",
 /* 447 */ "table_reference ::= joined_table",
 /* 448 */ "table_primary ::= table_name alias_opt",
 /* 449 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 450 */ "table_primary ::= subquery alias_opt",
 /* 451 */ "table_primary ::= parenthesized_joined_table",
 /* 452 */ "alias_opt ::=",
 /* 453 */ "alias_opt ::= table_alias",
 /* 454 */ "alias_opt ::= AS table_alias",
 /* 455 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 456 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 457 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 458 */ "join_type ::=",
 /* 459 */ "join_type ::= INNER",
 /* 460 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 461 */ "set_quantifier_opt ::=",
 /* 462 */ "set_quantifier_opt ::= DISTINCT",
 /* 463 */ "set_quantifier_opt ::= ALL",
 /* 464 */ "select_list ::= select_item",
 /* 465 */ "select_list ::= select_list NK_COMMA select_item",
 /* 466 */ "select_item ::= NK_STAR",
 /* 467 */ "select_item ::= common_expression",
 /* 468 */ "select_item ::= common_expression column_alias",
 /* 469 */ "select_item ::= common_expression AS column_alias",
 /* 470 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 471 */ "where_clause_opt ::=",
 /* 472 */ "where_clause_opt ::= WHERE search_condition",
 /* 473 */ "partition_by_clause_opt ::=",
 /* 474 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 475 */ "partition_list ::= partition_item",
 /* 476 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 477 */ "partition_item ::= expr_or_subquery",
 /* 478 */ "partition_item ::= expr_or_subquery column_alias",
 /* 479 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 480 */ "twindow_clause_opt ::=",
 /* 481 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 482 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 483 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 484 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 485 */ "sliding_opt ::=",
 /* 486 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 487 */ "fill_opt ::=",
 /* 488 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 489 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 490 */ "fill_mode ::= NONE",
 /* 491 */ "fill_mode ::= PREV",
 /* 492 */ "fill_mode ::= NULL",
 /* 493 */ "fill_mode ::= LINEAR",
 /* 494 */ "fill_mode ::= NEXT",
 /* 495 */ "group_by_clause_opt ::=",
 /* 496 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 497 */ "group_by_list ::= expr_or_subquery",
 /* 498 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 499 */ "having_clause_opt ::=",
 /* 500 */ "having_clause_opt ::= HAVING search_condition",
 /* 501 */ "range_opt ::=",
 /* 502 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 503 */ "every_opt ::=",
 /* 504 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 505 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 506 */ "query_simple ::= query_specification",
 /* 507 */ "query_simple ::= union_query_expression",
 /* 508 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 509 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 510 */ "query_simple_or_subquery ::= query_simple",
 /* 511 */ "query_simple_or_subquery ::= subquery",
 /* 512 */ "query_or_subquery ::= query_expression",
 /* 513 */ "query_or_subquery ::= subquery",
 /* 514 */ "order_by_clause_opt ::=",
 /* 515 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 516 */ "slimit_clause_opt ::=",
 /* 517 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 518 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 519 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 520 */ "limit_clause_opt ::=",
 /* 521 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 522 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 523 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 524 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 525 */ "subquery ::= NK_LP subquery NK_RP",
 /* 526 */ "search_condition ::= common_expression",
 /* 527 */ "sort_specification_list ::= sort_specification",
 /* 528 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 529 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 530 */ "ordering_specification_opt ::=",
 /* 531 */ "ordering_specification_opt ::= ASC",
 /* 532 */ "ordering_specification_opt ::= DESC",
 /* 533 */ "null_ordering_opt ::=",
 /* 534 */ "null_ordering_opt ::= NULLS FIRST",
 /* 535 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 319: /* cmd */
    case 322: /* literal */
    case 334: /* db_options */
    case 336: /* alter_db_options */
    case 342: /* retention */
    case 343: /* full_table_name */
    case 346: /* table_options */
    case 350: /* alter_table_clause */
    case 351: /* alter_table_options */
    case 354: /* signed_literal */
    case 355: /* create_subtable_clause */
    case 358: /* drop_table_clause */
    case 361: /* column_def */
    case 365: /* duration_literal */
    case 366: /* rollup_func_name */
    case 368: /* col_name */
    case 369: /* db_name_cond_opt */
    case 370: /* like_pattern_opt */
    case 371: /* table_name_cond */
    case 372: /* from_db_opt */
    case 374: /* tag_item */
    case 376: /* index_options */
    case 378: /* sliding_opt */
    case 379: /* sma_stream_opt */
    case 380: /* func */
    case 381: /* stream_options */
    case 383: /* query_or_subquery */
    case 386: /* explain_options */
    case 390: /* subtable_opt */
    case 391: /* expression */
    case 393: /* where_clause_opt */
    case 394: /* signed */
    case 395: /* literal_func */
    case 398: /* expr_or_subquery */
    case 399: /* subquery */
    case 400: /* pseudo_column */
    case 401: /* column_reference */
    case 402: /* function_expression */
    case 403: /* case_when_expression */
    case 408: /* star_func_para */
    case 410: /* case_when_else_opt */
    case 411: /* common_expression */
    case 412: /* when_then_expr */
    case 413: /* predicate */
    case 416: /* in_predicate_value */
    case 417: /* boolean_value_expression */
    case 418: /* boolean_primary */
    case 419: /* from_clause_opt */
    case 420: /* table_reference_list */
    case 421: /* table_reference */
    case 422: /* table_primary */
    case 423: /* joined_table */
    case 425: /* parenthesized_joined_table */
    case 427: /* search_condition */
    case 428: /* query_specification */
    case 432: /* range_opt */
    case 433: /* every_opt */
    case 434: /* fill_opt */
    case 435: /* twindow_clause_opt */
    case 437: /* having_clause_opt */
    case 438: /* select_item */
    case 440: /* partition_item */
    case 443: /* query_expression */
    case 444: /* query_simple */
    case 446: /* slimit_clause_opt */
    case 447: /* limit_clause_opt */
    case 448: /* union_query_expression */
    case 449: /* query_simple_or_subquery */
    case 451: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy164)); 
}
      break;
    case 320: /* account_options */
    case 321: /* alter_account_options */
    case 323: /* alter_account_option */
    case 337: /* speed_opt */
    case 388: /* bufsize_opt */
{
 
}
      break;
    case 324: /* user_name */
    case 327: /* priv_level */
    case 330: /* db_name */
    case 331: /* dnode_endpoint */
    case 352: /* column_name */
    case 360: /* table_name */
    case 367: /* function_name */
    case 375: /* column_alias */
    case 382: /* topic_name */
    case 384: /* cgroup_name */
    case 389: /* stream_name */
    case 397: /* table_alias */
    case 404: /* star_func */
    case 406: /* noarg_func */
    case 424: /* alias_opt */
{
 
}
      break;
    case 325: /* sysinfo_opt */
{
 
}
      break;
    case 326: /* privileges */
    case 328: /* priv_type_list */
    case 329: /* priv_type */
{
 
}
      break;
    case 332: /* force_opt */
    case 333: /* not_exists_opt */
    case 335: /* exists_opt */
    case 385: /* analyze_opt */
    case 387: /* agg_func_opt */
    case 429: /* set_quantifier_opt */
{
 
}
      break;
    case 338: /* integer_list */
    case 339: /* variable_list */
    case 340: /* retention_list */
    case 344: /* column_def_list */
    case 345: /* tags_def_opt */
    case 347: /* multi_create_clause */
    case 348: /* tags_def */
    case 349: /* multi_drop_clause */
    case 356: /* specific_cols_opt */
    case 357: /* expression_list */
    case 359: /* col_name_list */
    case 362: /* duration_list */
    case 363: /* rollup_func_list */
    case 373: /* tag_list_opt */
    case 377: /* func_list */
    case 392: /* dnode_list */
    case 396: /* literal_list */
    case 405: /* star_func_para_list */
    case 407: /* other_para_list */
    case 409: /* when_then_list */
    case 430: /* select_list */
    case 431: /* partition_by_clause_opt */
    case 436: /* group_by_clause_opt */
    case 439: /* partition_list */
    case 442: /* group_by_list */
    case 445: /* order_by_clause_opt */
    case 450: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy648)); 
}
      break;
    case 341: /* alter_db_option */
    case 364: /* alter_table_option */
{
 
}
      break;
    case 353: /* type_name */
{
 
}
      break;
    case 414: /* compare_op */
    case 415: /* in_op */
{
 
}
      break;
    case 426: /* join_type */
{
 
}
      break;
    case 441: /* fill_mode */
{
 
}
      break;
    case 452: /* ordering_specification_opt */
{
 
}
      break;
    case 453: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  319,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  319,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  320,    0 }, /* (2) account_options ::= */
  {  320,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  320,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  320,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  320,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  320,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  320,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  320,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  320,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  320,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  321,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  321,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  323,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  323,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  323,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  323,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  323,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  323,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  323,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  323,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  323,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  323,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  319,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  319,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  319,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  319,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  319,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  325,    0 }, /* (29) sysinfo_opt ::= */
  {  325,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  319,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  319,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  326,   -1 }, /* (33) privileges ::= ALL */
  {  326,   -1 }, /* (34) privileges ::= priv_type_list */
  {  328,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  328,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  329,   -1 }, /* (37) priv_type ::= READ */
  {  329,   -1 }, /* (38) priv_type ::= WRITE */
  {  327,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  327,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  319,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  319,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  319,   -4 }, /* (43) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  319,   -4 }, /* (44) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  319,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  319,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  319,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  319,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  331,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  331,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  331,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  332,    0 }, /* (52) force_opt ::= */
  {  332,   -1 }, /* (53) force_opt ::= FORCE */
  {  319,   -3 }, /* (54) cmd ::= ALTER LOCAL NK_STRING */
  {  319,   -4 }, /* (55) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  319,   -5 }, /* (56) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (57) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (58) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (59) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (60) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (61) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (62) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (63) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (64) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  319,   -4 }, /* (65) cmd ::= DROP DATABASE exists_opt db_name */
  {  319,   -2 }, /* (66) cmd ::= USE db_name */
  {  319,   -4 }, /* (67) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  319,   -3 }, /* (68) cmd ::= FLUSH DATABASE db_name */
  {  319,   -4 }, /* (69) cmd ::= TRIM DATABASE db_name speed_opt */
  {  333,   -3 }, /* (70) not_exists_opt ::= IF NOT EXISTS */
  {  333,    0 }, /* (71) not_exists_opt ::= */
  {  335,   -2 }, /* (72) exists_opt ::= IF EXISTS */
  {  335,    0 }, /* (73) exists_opt ::= */
  {  334,    0 }, /* (74) db_options ::= */
  {  334,   -3 }, /* (75) db_options ::= db_options BUFFER NK_INTEGER */
  {  334,   -3 }, /* (76) db_options ::= db_options CACHEMODEL NK_STRING */
  {  334,   -3 }, /* (77) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  334,   -3 }, /* (78) db_options ::= db_options COMP NK_INTEGER */
  {  334,   -3 }, /* (79) db_options ::= db_options DURATION NK_INTEGER */
  {  334,   -3 }, /* (80) db_options ::= db_options DURATION NK_VARIABLE */
  {  334,   -3 }, /* (81) db_options ::= db_options MAXROWS NK_INTEGER */
  {  334,   -3 }, /* (82) db_options ::= db_options MINROWS NK_INTEGER */
  {  334,   -3 }, /* (83) db_options ::= db_options KEEP integer_list */
  {  334,   -3 }, /* (84) db_options ::= db_options KEEP variable_list */
  {  334,   -3 }, /* (85) db_options ::= db_options PAGES NK_INTEGER */
  {  334,   -3 }, /* (86) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  334,   -3 }, /* (87) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  334,   -3 }, /* (88) db_options ::= db_options PRECISION NK_STRING */
  {  334,   -3 }, /* (89) db_options ::= db_options REPLICA NK_INTEGER */
  {  334,   -3 }, /* (90) db_options ::= db_options STRICT NK_STRING */
  {  334,   -3 }, /* (91) db_options ::= db_options VGROUPS NK_INTEGER */
  {  334,   -3 }, /* (92) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  334,   -3 }, /* (93) db_options ::= db_options RETENTIONS retention_list */
  {  334,   -3 }, /* (94) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  334,   -3 }, /* (95) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  334,   -3 }, /* (96) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  334,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  334,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  334,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  334,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  334,   -3 }, /* (101) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  334,   -3 }, /* (102) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  334,   -3 }, /* (103) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  334,   -3 }, /* (104) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  334,   -3 }, /* (105) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  336,   -1 }, /* (106) alter_db_options ::= alter_db_option */
  {  336,   -2 }, /* (107) alter_db_options ::= alter_db_options alter_db_option */
  {  341,   -2 }, /* (108) alter_db_option ::= BUFFER NK_INTEGER */
  {  341,   -2 }, /* (109) alter_db_option ::= CACHEMODEL NK_STRING */
  {  341,   -2 }, /* (110) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  341,   -2 }, /* (111) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  341,   -2 }, /* (112) alter_db_option ::= KEEP integer_list */
  {  341,   -2 }, /* (113) alter_db_option ::= KEEP variable_list */
  {  341,   -2 }, /* (114) alter_db_option ::= PAGES NK_INTEGER */
  {  341,   -2 }, /* (115) alter_db_option ::= REPLICA NK_INTEGER */
  {  341,   -2 }, /* (116) alter_db_option ::= STRICT NK_STRING */
  {  341,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  341,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  338,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  338,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  339,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  339,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  340,   -1 }, /* (123) retention_list ::= retention */
  {  340,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  342,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  337,    0 }, /* (126) speed_opt ::= */
  {  337,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  319,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  319,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  319,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  319,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  319,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  319,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  319,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  350,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  350,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  350,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  350,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  350,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  350,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  350,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  350,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  350,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  350,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  347,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  347,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  355,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  349,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  349,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  358,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  356,    0 }, /* (151) specific_cols_opt ::= */
  {  356,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  343,   -1 }, /* (153) full_table_name ::= table_name */
  {  343,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  344,   -1 }, /* (155) column_def_list ::= column_def */
  {  344,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  361,   -2 }, /* (157) column_def ::= column_name type_name */
  {  361,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  353,   -1 }, /* (159) type_name ::= BOOL */
  {  353,   -1 }, /* (160) type_name ::= TINYINT */
  {  353,   -1 }, /* (161) type_name ::= SMALLINT */
  {  353,   -1 }, /* (162) type_name ::= INT */
  {  353,   -1 }, /* (163) type_name ::= INTEGER */
  {  353,   -1 }, /* (164) type_name ::= BIGINT */
  {  353,   -1 }, /* (165) type_name ::= FLOAT */
  {  353,   -1 }, /* (166) type_name ::= DOUBLE */
  {  353,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  353,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  353,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  353,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  353,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  353,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  353,   -1 }, /* (174) type_name ::= JSON */
  {  353,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  353,   -1 }, /* (177) type_name ::= BLOB */
  {  353,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (179) type_name ::= DECIMAL */
  {  353,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  353,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  345,    0 }, /* (182) tags_def_opt ::= */
  {  345,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  348,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  346,    0 }, /* (185) table_options ::= */
  {  346,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  346,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  346,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  346,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  346,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  346,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (192) alter_table_options ::= alter_table_option */
  {  351,   -2 }, /* (193) alter_table_options ::= alter_table_options alter_table_option */
  {  364,   -2 }, /* (194) alter_table_option ::= COMMENT NK_STRING */
  {  364,   -2 }, /* (195) alter_table_option ::= TTL NK_INTEGER */
  {  362,   -1 }, /* (196) duration_list ::= duration_literal */
  {  362,   -3 }, /* (197) duration_list ::= duration_list NK_COMMA duration_literal */
  {  363,   -1 }, /* (198) rollup_func_list ::= rollup_func_name */
  {  363,   -3 }, /* (199) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  366,   -1 }, /* (200) rollup_func_name ::= function_name */
  {  366,   -1 }, /* (201) rollup_func_name ::= FIRST */
  {  366,   -1 }, /* (202) rollup_func_name ::= LAST */
  {  359,   -1 }, /* (203) col_name_list ::= col_name */
  {  359,   -3 }, /* (204) col_name_list ::= col_name_list NK_COMMA col_name */
  {  368,   -1 }, /* (205) col_name ::= column_name */
  {  319,   -2 }, /* (206) cmd ::= SHOW DNODES */
  {  319,   -2 }, /* (207) cmd ::= SHOW USERS */
  {  319,   -2 }, /* (208) cmd ::= SHOW DATABASES */
  {  319,   -4 }, /* (209) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  319,   -4 }, /* (210) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  319,   -3 }, /* (211) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  319,   -2 }, /* (212) cmd ::= SHOW MNODES */
  {  319,   -2 }, /* (213) cmd ::= SHOW QNODES */
  {  319,   -2 }, /* (214) cmd ::= SHOW FUNCTIONS */
  {  319,   -5 }, /* (215) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  319,   -2 }, /* (216) cmd ::= SHOW STREAMS */
  {  319,   -2 }, /* (217) cmd ::= SHOW ACCOUNTS */
  {  319,   -2 }, /* (218) cmd ::= SHOW APPS */
  {  319,   -2 }, /* (219) cmd ::= SHOW CONNECTIONS */
  {  319,   -2 }, /* (220) cmd ::= SHOW LICENCES */
  {  319,   -2 }, /* (221) cmd ::= SHOW GRANTS */
  {  319,   -4 }, /* (222) cmd ::= SHOW CREATE DATABASE db_name */
  {  319,   -4 }, /* (223) cmd ::= SHOW CREATE TABLE full_table_name */
  {  319,   -4 }, /* (224) cmd ::= SHOW CREATE STABLE full_table_name */
  {  319,   -2 }, /* (225) cmd ::= SHOW QUERIES */
  {  319,   -2 }, /* (226) cmd ::= SHOW SCORES */
  {  319,   -2 }, /* (227) cmd ::= SHOW TOPICS */
  {  319,   -2 }, /* (228) cmd ::= SHOW VARIABLES */
  {  319,   -3 }, /* (229) cmd ::= SHOW CLUSTER VARIABLES */
  {  319,   -3 }, /* (230) cmd ::= SHOW LOCAL VARIABLES */
  {  319,   -5 }, /* (231) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  319,   -2 }, /* (232) cmd ::= SHOW BNODES */
  {  319,   -2 }, /* (233) cmd ::= SHOW SNODES */
  {  319,   -2 }, /* (234) cmd ::= SHOW CLUSTER */
  {  319,   -2 }, /* (235) cmd ::= SHOW TRANSACTIONS */
  {  319,   -4 }, /* (236) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  319,   -2 }, /* (237) cmd ::= SHOW CONSUMERS */
  {  319,   -2 }, /* (238) cmd ::= SHOW SUBSCRIPTIONS */
  {  319,   -5 }, /* (239) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  319,   -7 }, /* (240) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  319,   -3 }, /* (241) cmd ::= SHOW VNODES NK_INTEGER */
  {  319,   -3 }, /* (242) cmd ::= SHOW VNODES NK_STRING */
  {  369,    0 }, /* (243) db_name_cond_opt ::= */
  {  369,   -2 }, /* (244) db_name_cond_opt ::= db_name NK_DOT */
  {  370,    0 }, /* (245) like_pattern_opt ::= */
  {  370,   -2 }, /* (246) like_pattern_opt ::= LIKE NK_STRING */
  {  371,   -1 }, /* (247) table_name_cond ::= table_name */
  {  372,    0 }, /* (248) from_db_opt ::= */
  {  372,   -2 }, /* (249) from_db_opt ::= FROM db_name */
  {  373,    0 }, /* (250) tag_list_opt ::= */
  {  373,   -1 }, /* (251) tag_list_opt ::= tag_item */
  {  373,   -3 }, /* (252) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  374,   -1 }, /* (253) tag_item ::= TBNAME */
  {  374,   -1 }, /* (254) tag_item ::= QTAGS */
  {  374,   -1 }, /* (255) tag_item ::= column_name */
  {  374,   -2 }, /* (256) tag_item ::= column_name column_alias */
  {  374,   -3 }, /* (257) tag_item ::= column_name AS column_alias */
  {  319,   -8 }, /* (258) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  319,   -4 }, /* (259) cmd ::= DROP INDEX exists_opt full_table_name */
  {  376,  -10 }, /* (260) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  376,  -12 }, /* (261) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  377,   -1 }, /* (262) func_list ::= func */
  {  377,   -3 }, /* (263) func_list ::= func_list NK_COMMA func */
  {  380,   -4 }, /* (264) func ::= function_name NK_LP expression_list NK_RP */
  {  379,    0 }, /* (265) sma_stream_opt ::= */
  {  379,   -3 }, /* (266) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  379,   -3 }, /* (267) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  319,   -6 }, /* (268) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  319,   -7 }, /* (269) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  319,   -9 }, /* (270) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  319,   -7 }, /* (271) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  319,   -9 }, /* (272) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  319,   -4 }, /* (273) cmd ::= DROP TOPIC exists_opt topic_name */
  {  319,   -7 }, /* (274) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  319,   -2 }, /* (275) cmd ::= DESC full_table_name */
  {  319,   -2 }, /* (276) cmd ::= DESCRIBE full_table_name */
  {  319,   -3 }, /* (277) cmd ::= RESET QUERY CACHE */
  {  319,   -4 }, /* (278) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  385,    0 }, /* (279) analyze_opt ::= */
  {  385,   -1 }, /* (280) analyze_opt ::= ANALYZE */
  {  386,    0 }, /* (281) explain_options ::= */
  {  386,   -3 }, /* (282) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  386,   -3 }, /* (283) explain_options ::= explain_options RATIO NK_FLOAT */
  {  319,  -10 }, /* (284) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  319,   -4 }, /* (285) cmd ::= DROP FUNCTION exists_opt function_name */
  {  387,    0 }, /* (286) agg_func_opt ::= */
  {  387,   -1 }, /* (287) agg_func_opt ::= AGGREGATE */
  {  388,    0 }, /* (288) bufsize_opt ::= */
  {  388,   -2 }, /* (289) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  319,  -11 }, /* (290) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  319,   -4 }, /* (291) cmd ::= DROP STREAM exists_opt stream_name */
  {  381,    0 }, /* (292) stream_options ::= */
  {  381,   -3 }, /* (293) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  381,   -3 }, /* (294) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  381,   -4 }, /* (295) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  381,   -3 }, /* (296) stream_options ::= stream_options WATERMARK duration_literal */
  {  381,   -4 }, /* (297) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  381,   -3 }, /* (298) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  390,    0 }, /* (299) subtable_opt ::= */
  {  390,   -4 }, /* (300) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  319,   -3 }, /* (301) cmd ::= KILL CONNECTION NK_INTEGER */
  {  319,   -3 }, /* (302) cmd ::= KILL QUERY NK_STRING */
  {  319,   -3 }, /* (303) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  319,   -2 }, /* (304) cmd ::= BALANCE VGROUP */
  {  319,   -4 }, /* (305) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  319,   -4 }, /* (306) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  319,   -3 }, /* (307) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  392,   -2 }, /* (308) dnode_list ::= DNODE NK_INTEGER */
  {  392,   -3 }, /* (309) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  319,   -4 }, /* (310) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  319,   -1 }, /* (311) cmd ::= query_or_subquery */
  {  319,   -7 }, /* (312) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  319,   -4 }, /* (313) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  322,   -1 }, /* (314) literal ::= NK_INTEGER */
  {  322,   -1 }, /* (315) literal ::= NK_FLOAT */
  {  322,   -1 }, /* (316) literal ::= NK_STRING */
  {  322,   -1 }, /* (317) literal ::= NK_BOOL */
  {  322,   -2 }, /* (318) literal ::= TIMESTAMP NK_STRING */
  {  322,   -1 }, /* (319) literal ::= duration_literal */
  {  322,   -1 }, /* (320) literal ::= NULL */
  {  322,   -1 }, /* (321) literal ::= NK_QUESTION */
  {  365,   -1 }, /* (322) duration_literal ::= NK_VARIABLE */
  {  394,   -1 }, /* (323) signed ::= NK_INTEGER */
  {  394,   -2 }, /* (324) signed ::= NK_PLUS NK_INTEGER */
  {  394,   -2 }, /* (325) signed ::= NK_MINUS NK_INTEGER */
  {  394,   -1 }, /* (326) signed ::= NK_FLOAT */
  {  394,   -2 }, /* (327) signed ::= NK_PLUS NK_FLOAT */
  {  394,   -2 }, /* (328) signed ::= NK_MINUS NK_FLOAT */
  {  354,   -1 }, /* (329) signed_literal ::= signed */
  {  354,   -1 }, /* (330) signed_literal ::= NK_STRING */
  {  354,   -1 }, /* (331) signed_literal ::= NK_BOOL */
  {  354,   -2 }, /* (332) signed_literal ::= TIMESTAMP NK_STRING */
  {  354,   -1 }, /* (333) signed_literal ::= duration_literal */
  {  354,   -1 }, /* (334) signed_literal ::= NULL */
  {  354,   -1 }, /* (335) signed_literal ::= literal_func */
  {  354,   -1 }, /* (336) signed_literal ::= NK_QUESTION */
  {  396,   -1 }, /* (337) literal_list ::= signed_literal */
  {  396,   -3 }, /* (338) literal_list ::= literal_list NK_COMMA signed_literal */
  {  330,   -1 }, /* (339) db_name ::= NK_ID */
  {  360,   -1 }, /* (340) table_name ::= NK_ID */
  {  352,   -1 }, /* (341) column_name ::= NK_ID */
  {  367,   -1 }, /* (342) function_name ::= NK_ID */
  {  397,   -1 }, /* (343) table_alias ::= NK_ID */
  {  375,   -1 }, /* (344) column_alias ::= NK_ID */
  {  324,   -1 }, /* (345) user_name ::= NK_ID */
  {  382,   -1 }, /* (346) topic_name ::= NK_ID */
  {  389,   -1 }, /* (347) stream_name ::= NK_ID */
  {  384,   -1 }, /* (348) cgroup_name ::= NK_ID */
  {  398,   -1 }, /* (349) expr_or_subquery ::= expression */
  {  398,   -1 }, /* (350) expr_or_subquery ::= subquery */
  {  391,   -1 }, /* (351) expression ::= literal */
  {  391,   -1 }, /* (352) expression ::= pseudo_column */
  {  391,   -1 }, /* (353) expression ::= column_reference */
  {  391,   -1 }, /* (354) expression ::= function_expression */
  {  391,   -1 }, /* (355) expression ::= case_when_expression */
  {  391,   -3 }, /* (356) expression ::= NK_LP expression NK_RP */
  {  391,   -2 }, /* (357) expression ::= NK_PLUS expr_or_subquery */
  {  391,   -2 }, /* (358) expression ::= NK_MINUS expr_or_subquery */
  {  391,   -3 }, /* (359) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  391,   -3 }, /* (360) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  391,   -3 }, /* (361) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  391,   -3 }, /* (362) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  391,   -3 }, /* (363) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  391,   -3 }, /* (364) expression ::= column_reference NK_ARROW NK_STRING */
  {  391,   -3 }, /* (365) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  391,   -3 }, /* (366) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  357,   -1 }, /* (367) expression_list ::= expr_or_subquery */
  {  357,   -3 }, /* (368) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  401,   -1 }, /* (369) column_reference ::= column_name */
  {  401,   -3 }, /* (370) column_reference ::= table_name NK_DOT column_name */
  {  400,   -1 }, /* (371) pseudo_column ::= ROWTS */
  {  400,   -1 }, /* (372) pseudo_column ::= TBNAME */
  {  400,   -3 }, /* (373) pseudo_column ::= table_name NK_DOT TBNAME */
  {  400,   -1 }, /* (374) pseudo_column ::= QSTART */
  {  400,   -1 }, /* (375) pseudo_column ::= QEND */
  {  400,   -1 }, /* (376) pseudo_column ::= QDURATION */
  {  400,   -1 }, /* (377) pseudo_column ::= WSTART */
  {  400,   -1 }, /* (378) pseudo_column ::= WEND */
  {  400,   -1 }, /* (379) pseudo_column ::= WDURATION */
  {  400,   -1 }, /* (380) pseudo_column ::= IROWTS */
  {  400,   -1 }, /* (381) pseudo_column ::= QTAGS */
  {  402,   -4 }, /* (382) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  402,   -4 }, /* (383) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  402,   -6 }, /* (384) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  402,   -1 }, /* (385) function_expression ::= literal_func */
  {  395,   -3 }, /* (386) literal_func ::= noarg_func NK_LP NK_RP */
  {  395,   -1 }, /* (387) literal_func ::= NOW */
  {  406,   -1 }, /* (388) noarg_func ::= NOW */
  {  406,   -1 }, /* (389) noarg_func ::= TODAY */
  {  406,   -1 }, /* (390) noarg_func ::= TIMEZONE */
  {  406,   -1 }, /* (391) noarg_func ::= DATABASE */
  {  406,   -1 }, /* (392) noarg_func ::= CLIENT_VERSION */
  {  406,   -1 }, /* (393) noarg_func ::= SERVER_VERSION */
  {  406,   -1 }, /* (394) noarg_func ::= SERVER_STATUS */
  {  406,   -1 }, /* (395) noarg_func ::= CURRENT_USER */
  {  406,   -1 }, /* (396) noarg_func ::= USER */
  {  404,   -1 }, /* (397) star_func ::= COUNT */
  {  404,   -1 }, /* (398) star_func ::= FIRST */
  {  404,   -1 }, /* (399) star_func ::= LAST */
  {  404,   -1 }, /* (400) star_func ::= LAST_ROW */
  {  405,   -1 }, /* (401) star_func_para_list ::= NK_STAR */
  {  405,   -1 }, /* (402) star_func_para_list ::= other_para_list */
  {  407,   -1 }, /* (403) other_para_list ::= star_func_para */
  {  407,   -3 }, /* (404) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  408,   -1 }, /* (405) star_func_para ::= expr_or_subquery */
  {  408,   -3 }, /* (406) star_func_para ::= table_name NK_DOT NK_STAR */
  {  403,   -4 }, /* (407) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  403,   -5 }, /* (408) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  409,   -1 }, /* (409) when_then_list ::= when_then_expr */
  {  409,   -2 }, /* (410) when_then_list ::= when_then_list when_then_expr */
  {  412,   -4 }, /* (411) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  410,    0 }, /* (412) case_when_else_opt ::= */
  {  410,   -2 }, /* (413) case_when_else_opt ::= ELSE common_expression */
  {  413,   -3 }, /* (414) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  413,   -5 }, /* (415) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  413,   -6 }, /* (416) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  413,   -3 }, /* (417) predicate ::= expr_or_subquery IS NULL */
  {  413,   -4 }, /* (418) predicate ::= expr_or_subquery IS NOT NULL */
  {  413,   -3 }, /* (419) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  414,   -1 }, /* (420) compare_op ::= NK_LT */
  {  414,   -1 }, /* (421) compare_op ::= NK_GT */
  {  414,   -1 }, /* (422) compare_op ::= NK_LE */
  {  414,   -1 }, /* (423) compare_op ::= NK_GE */
  {  414,   -1 }, /* (424) compare_op ::= NK_NE */
  {  414,   -1 }, /* (425) compare_op ::= NK_EQ */
  {  414,   -1 }, /* (426) compare_op ::= LIKE */
  {  414,   -2 }, /* (427) compare_op ::= NOT LIKE */
  {  414,   -1 }, /* (428) compare_op ::= MATCH */
  {  414,   -1 }, /* (429) compare_op ::= NMATCH */
  {  414,   -1 }, /* (430) compare_op ::= CONTAINS */
  {  415,   -1 }, /* (431) in_op ::= IN */
  {  415,   -2 }, /* (432) in_op ::= NOT IN */
  {  416,   -3 }, /* (433) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  417,   -1 }, /* (434) boolean_value_expression ::= boolean_primary */
  {  417,   -2 }, /* (435) boolean_value_expression ::= NOT boolean_primary */
  {  417,   -3 }, /* (436) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  417,   -3 }, /* (437) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  418,   -1 }, /* (438) boolean_primary ::= predicate */
  {  418,   -3 }, /* (439) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  411,   -1 }, /* (440) common_expression ::= expr_or_subquery */
  {  411,   -1 }, /* (441) common_expression ::= boolean_value_expression */
  {  419,    0 }, /* (442) from_clause_opt ::= */
  {  419,   -2 }, /* (443) from_clause_opt ::= FROM table_reference_list */
  {  420,   -1 }, /* (444) table_reference_list ::= table_reference */
  {  420,   -3 }, /* (445) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  421,   -1 }, /* (446) table_reference ::= table_primary */
  {  421,   -1 }, /* (447) table_reference ::= joined_table */
  {  422,   -2 }, /* (448) table_primary ::= table_name alias_opt */
  {  422,   -4 }, /* (449) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  422,   -2 }, /* (450) table_primary ::= subquery alias_opt */
  {  422,   -1 }, /* (451) table_primary ::= parenthesized_joined_table */
  {  424,    0 }, /* (452) alias_opt ::= */
  {  424,   -1 }, /* (453) alias_opt ::= table_alias */
  {  424,   -2 }, /* (454) alias_opt ::= AS table_alias */
  {  425,   -3 }, /* (455) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  425,   -3 }, /* (456) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  423,   -6 }, /* (457) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  426,    0 }, /* (458) join_type ::= */
  {  426,   -1 }, /* (459) join_type ::= INNER */
  {  428,  -12 }, /* (460) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  429,    0 }, /* (461) set_quantifier_opt ::= */
  {  429,   -1 }, /* (462) set_quantifier_opt ::= DISTINCT */
  {  429,   -1 }, /* (463) set_quantifier_opt ::= ALL */
  {  430,   -1 }, /* (464) select_list ::= select_item */
  {  430,   -3 }, /* (465) select_list ::= select_list NK_COMMA select_item */
  {  438,   -1 }, /* (466) select_item ::= NK_STAR */
  {  438,   -1 }, /* (467) select_item ::= common_expression */
  {  438,   -2 }, /* (468) select_item ::= common_expression column_alias */
  {  438,   -3 }, /* (469) select_item ::= common_expression AS column_alias */
  {  438,   -3 }, /* (470) select_item ::= table_name NK_DOT NK_STAR */
  {  393,    0 }, /* (471) where_clause_opt ::= */
  {  393,   -2 }, /* (472) where_clause_opt ::= WHERE search_condition */
  {  431,    0 }, /* (473) partition_by_clause_opt ::= */
  {  431,   -3 }, /* (474) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  439,   -1 }, /* (475) partition_list ::= partition_item */
  {  439,   -3 }, /* (476) partition_list ::= partition_list NK_COMMA partition_item */
  {  440,   -1 }, /* (477) partition_item ::= expr_or_subquery */
  {  440,   -2 }, /* (478) partition_item ::= expr_or_subquery column_alias */
  {  440,   -3 }, /* (479) partition_item ::= expr_or_subquery AS column_alias */
  {  435,    0 }, /* (480) twindow_clause_opt ::= */
  {  435,   -6 }, /* (481) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  435,   -4 }, /* (482) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  435,   -6 }, /* (483) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  435,   -8 }, /* (484) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  378,    0 }, /* (485) sliding_opt ::= */
  {  378,   -4 }, /* (486) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  434,    0 }, /* (487) fill_opt ::= */
  {  434,   -4 }, /* (488) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  434,   -6 }, /* (489) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  441,   -1 }, /* (490) fill_mode ::= NONE */
  {  441,   -1 }, /* (491) fill_mode ::= PREV */
  {  441,   -1 }, /* (492) fill_mode ::= NULL */
  {  441,   -1 }, /* (493) fill_mode ::= LINEAR */
  {  441,   -1 }, /* (494) fill_mode ::= NEXT */
  {  436,    0 }, /* (495) group_by_clause_opt ::= */
  {  436,   -3 }, /* (496) group_by_clause_opt ::= GROUP BY group_by_list */
  {  442,   -1 }, /* (497) group_by_list ::= expr_or_subquery */
  {  442,   -3 }, /* (498) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  437,    0 }, /* (499) having_clause_opt ::= */
  {  437,   -2 }, /* (500) having_clause_opt ::= HAVING search_condition */
  {  432,    0 }, /* (501) range_opt ::= */
  {  432,   -6 }, /* (502) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  433,    0 }, /* (503) every_opt ::= */
  {  433,   -4 }, /* (504) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  443,   -4 }, /* (505) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  444,   -1 }, /* (506) query_simple ::= query_specification */
  {  444,   -1 }, /* (507) query_simple ::= union_query_expression */
  {  448,   -4 }, /* (508) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  448,   -3 }, /* (509) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  449,   -1 }, /* (510) query_simple_or_subquery ::= query_simple */
  {  449,   -1 }, /* (511) query_simple_or_subquery ::= subquery */
  {  383,   -1 }, /* (512) query_or_subquery ::= query_expression */
  {  383,   -1 }, /* (513) query_or_subquery ::= subquery */
  {  445,    0 }, /* (514) order_by_clause_opt ::= */
  {  445,   -3 }, /* (515) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  446,    0 }, /* (516) slimit_clause_opt ::= */
  {  446,   -2 }, /* (517) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  446,   -4 }, /* (518) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  446,   -4 }, /* (519) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  447,    0 }, /* (520) limit_clause_opt ::= */
  {  447,   -2 }, /* (521) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  447,   -4 }, /* (522) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  447,   -4 }, /* (523) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  399,   -3 }, /* (524) subquery ::= NK_LP query_expression NK_RP */
  {  399,   -3 }, /* (525) subquery ::= NK_LP subquery NK_RP */
  {  427,   -1 }, /* (526) search_condition ::= common_expression */
  {  450,   -1 }, /* (527) sort_specification_list ::= sort_specification */
  {  450,   -3 }, /* (528) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  451,   -3 }, /* (529) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  452,    0 }, /* (530) ordering_specification_opt ::= */
  {  452,   -1 }, /* (531) ordering_specification_opt ::= ASC */
  {  452,   -1 }, /* (532) ordering_specification_opt ::= DESC */
  {  453,    0 }, /* (533) null_ordering_opt ::= */
  {  453,   -2 }, /* (534) null_ordering_opt ::= NULLS FIRST */
  {  453,   -2 }, /* (535) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,321,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,320,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,322,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,323,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,323,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,322,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy593, &yymsp[-1].minor.yy0, yymsp[0].minor.yy687); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy593, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy593, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy593, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy687 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy687 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy577, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy577, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy577 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy577 = yymsp[0].minor.yy577; }
  yymsp[0].minor.yy577 = yylhsminor.yy577;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy577 = yymsp[-2].minor.yy577 | yymsp[0].minor.yy577; }
  yymsp[-2].minor.yy577 = yylhsminor.yy577;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy577 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy577 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy593 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy593 = yylhsminor.yy593;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy593 = yymsp[-2].minor.yy593; }
  yymsp[-2].minor.yy593 = yylhsminor.yy593;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy593, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy193); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy193); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 339: /* db_name ::= NK_ID */ yytestcase(yyruleno==339);
      case 340: /* table_name ::= NK_ID */ yytestcase(yyruleno==340);
      case 341: /* column_name ::= NK_ID */ yytestcase(yyruleno==341);
      case 342: /* function_name ::= NK_ID */ yytestcase(yyruleno==342);
      case 343: /* table_alias ::= NK_ID */ yytestcase(yyruleno==343);
      case 344: /* column_alias ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* user_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* topic_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* stream_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 388: /* noarg_func ::= NOW */ yytestcase(yyruleno==388);
      case 389: /* noarg_func ::= TODAY */ yytestcase(yyruleno==389);
      case 390: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==390);
      case 391: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==391);
      case 392: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= USER */ yytestcase(yyruleno==396);
      case 397: /* star_func ::= COUNT */ yytestcase(yyruleno==397);
      case 398: /* star_func ::= FIRST */ yytestcase(yyruleno==398);
      case 399: /* star_func ::= LAST */ yytestcase(yyruleno==399);
      case 400: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==400);
{ yylhsminor.yy593 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy593 = yylhsminor.yy593;
        break;
      case 52: /* force_opt ::= */
      case 71: /* not_exists_opt ::= */ yytestcase(yyruleno==71);
      case 73: /* exists_opt ::= */ yytestcase(yyruleno==73);
      case 279: /* analyze_opt ::= */ yytestcase(yyruleno==279);
      case 286: /* agg_func_opt ::= */ yytestcase(yyruleno==286);
      case 461: /* set_quantifier_opt ::= */ yytestcase(yyruleno==461);
{ yymsp[1].minor.yy193 = false; }
        break;
      case 53: /* force_opt ::= FORCE */
      case 280: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==280);
      case 287: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==287);
      case 462: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==462);
{ yymsp[0].minor.yy193 = true; }
        break;
      case 54: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy193, &yymsp[-1].minor.yy593, yymsp[0].minor.yy164); }
        break;
      case 65: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 66: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 67: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy164); }
        break;
      case 68: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 69: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy512); }
        break;
      case 70: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy193 = true; }
        break;
      case 72: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy193 = true; }
        break;
      case 74: /* db_options ::= */
{ yymsp[1].minor.yy164 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 75: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 76: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 77: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 78: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 79: /* db_options ::= db_options DURATION NK_INTEGER */
      case 80: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==80);
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 81: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 82: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 83: /* db_options ::= db_options KEEP integer_list */
      case 84: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==84);
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_KEEP, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 85: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 86: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 87: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 88: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 89: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 90: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 91: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 92: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 93: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_RETENTIONS, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 94: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 95: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 96: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-3].minor.yy164, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-3].minor.yy164, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 101: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 102: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 103: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 104: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 105: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 106: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy164 = createAlterDatabaseOptions(pCxt); yylhsminor.yy164 = setAlterDatabaseOption(pCxt, yylhsminor.yy164, &yymsp[0].minor.yy213); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 107: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy164 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy164, &yymsp[0].minor.yy213); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 108: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy213.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= KEEP integer_list */
      case 113: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==113);
{ yymsp[-1].minor.yy213.type = DB_OPTION_KEEP; yymsp[-1].minor.yy213.pList = yymsp[0].minor.yy648; }
        break;
      case 114: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_PAGES; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy213.type = DB_OPTION_STRICT; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_WAL; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy648 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 309: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==309);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy648 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 198: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==198);
      case 203: /* col_name_list ::= col_name */ yytestcase(yyruleno==203);
      case 251: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==251);
      case 262: /* func_list ::= func */ yytestcase(yyruleno==262);
      case 337: /* literal_list ::= signed_literal */ yytestcase(yyruleno==337);
      case 403: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==403);
      case 409: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==409);
      case 464: /* select_list ::= select_item */ yytestcase(yyruleno==464);
      case 475: /* partition_list ::= partition_item */ yytestcase(yyruleno==475);
      case 527: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==527);
{ yylhsminor.yy648 = createNodeList(pCxt, yymsp[0].minor.yy164); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 199: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==204);
      case 252: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==252);
      case 263: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==263);
      case 338: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==338);
      case 404: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==404);
      case 465: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==465);
      case 476: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==476);
      case 528: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==528);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, yymsp[0].minor.yy164); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy164 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 126: /* speed_opt ::= */
      case 288: /* bufsize_opt ::= */ yytestcase(yyruleno==288);
{ yymsp[1].minor.yy512 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 289: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==289);
{ yymsp[-1].minor.yy512 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy193, yymsp[-5].minor.yy164, yymsp[-3].minor.yy648, yymsp[-1].minor.yy648, yymsp[0].minor.yy164); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy648); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy648); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy193, yymsp[0].minor.yy164); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 311: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==311);
{ pCxt->pRootNode = yymsp[0].minor.yy164; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy164); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy164 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy164 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy164, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy593); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy164 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy164 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy164, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy593); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy164 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy164 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy164, &yymsp[-2].minor.yy593, yymsp[0].minor.yy164); }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 410: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==410);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-1].minor.yy648, yymsp[0].minor.yy164); }
  yymsp[-1].minor.yy648 = yylhsminor.yy648;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy164 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy193, yymsp[-8].minor.yy164, yymsp[-6].minor.yy164, yymsp[-5].minor.yy648, yymsp[-2].minor.yy648, yymsp[0].minor.yy164); }
  yymsp[-9].minor.yy164 = yylhsminor.yy164;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy164 = createDropTableClause(pCxt, yymsp[-1].minor.yy193, yymsp[0].minor.yy164); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 250: /* tag_list_opt ::= */ yytestcase(yyruleno==250);
      case 473: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==473);
      case 495: /* group_by_clause_opt ::= */ yytestcase(yyruleno==495);
      case 514: /* order_by_clause_opt ::= */ yytestcase(yyruleno==514);
{ yymsp[1].minor.yy648 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy648 = yymsp[-1].minor.yy648; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy164 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy593, NULL); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy164 = createRealTableNode(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593, NULL); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy164 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720, NULL); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy164 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy593, yymsp[-2].minor.yy720, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy720 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 402: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==402);
{ yylhsminor.yy648 = yymsp[0].minor.yy648; }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy648 = yymsp[-1].minor.yy648; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy164 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-4].minor.yy164, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy648); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-4].minor.yy164, TABLE_OPTION_SMA, yymsp[-1].minor.yy648); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 192: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy164 = createAlterTableOptions(pCxt); yylhsminor.yy164 = setTableOption(pCxt, yylhsminor.yy164, yymsp[0].minor.yy213.type, &yymsp[0].minor.yy213.val); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 193: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy213.type, &yymsp[0].minor.yy213.val); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 194: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy213.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 195: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy213.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* duration_list ::= duration_literal */
      case 367: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==367);
{ yylhsminor.yy648 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 197: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 368: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==368);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 200: /* rollup_func_name ::= function_name */
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[0].minor.yy593, NULL); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 201: /* rollup_func_name ::= FIRST */
      case 202: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==202);
      case 254: /* tag_item ::= QTAGS */ yytestcase(yyruleno==254);
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 205: /* col_name ::= column_name */
      case 255: /* tag_item ::= column_name */ yytestcase(yyruleno==255);
{ yylhsminor.yy164 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy593); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 206: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 208: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 209: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, OP_TYPE_LIKE); }
        break;
      case 210: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, OP_TYPE_LIKE); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy164, NULL, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 213: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 215: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy164, yymsp[-1].minor.yy164, OP_TYPE_EQUAL); }
        break;
      case 216: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 217: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 218: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 219: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 220: /* cmd ::= SHOW LICENCES */
      case 221: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==221);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 222: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 223: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy164); }
        break;
      case 224: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy164); }
        break;
      case 225: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 226: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 227: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 228: /* cmd ::= SHOW VARIABLES */
      case 229: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 230: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 231: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy164); }
        break;
      case 232: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 233: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 234: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 235: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 236: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy164); }
        break;
      case 237: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 238: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy164, yymsp[-1].minor.yy164, OP_TYPE_EQUAL); }
        break;
      case 240: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164, yymsp[-3].minor.yy648); }
        break;
      case 241: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 242: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 243: /* db_name_cond_opt ::= */
      case 248: /* from_db_opt ::= */ yytestcase(yyruleno==248);
{ yymsp[1].minor.yy164 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 244: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy164 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 245: /* like_pattern_opt ::= */
      case 299: /* subtable_opt ::= */ yytestcase(yyruleno==299);
      case 412: /* case_when_else_opt ::= */ yytestcase(yyruleno==412);
      case 442: /* from_clause_opt ::= */ yytestcase(yyruleno==442);
      case 471: /* where_clause_opt ::= */ yytestcase(yyruleno==471);
      case 480: /* twindow_clause_opt ::= */ yytestcase(yyruleno==480);
      case 485: /* sliding_opt ::= */ yytestcase(yyruleno==485);
      case 487: /* fill_opt ::= */ yytestcase(yyruleno==487);
      case 499: /* having_clause_opt ::= */ yytestcase(yyruleno==499);
      case 501: /* range_opt ::= */ yytestcase(yyruleno==501);
      case 503: /* every_opt ::= */ yytestcase(yyruleno==503);
      case 516: /* slimit_clause_opt ::= */ yytestcase(yyruleno==516);
      case 520: /* limit_clause_opt ::= */ yytestcase(yyruleno==520);
{ yymsp[1].minor.yy164 = NULL; }
        break;
      case 246: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 247: /* table_name_cond ::= table_name */
{ yylhsminor.yy164 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy593); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 249: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy164 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 253: /* tag_item ::= TBNAME */
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 256: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy593), &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 257: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy593), &yymsp[0].minor.yy593); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 258: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy193, yymsp[-3].minor.yy164, yymsp[-1].minor.yy164, NULL, yymsp[0].minor.yy164); }
        break;
      case 259: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy193, yymsp[0].minor.yy164); }
        break;
      case 260: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy164 = createIndexOption(pCxt, yymsp[-7].minor.yy648, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 261: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy164 = createIndexOption(pCxt, yymsp[-9].minor.yy648, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 264: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[-3].minor.yy593, yymsp[-1].minor.yy648); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 265: /* sma_stream_opt ::= */
      case 292: /* stream_options ::= */ yytestcase(yyruleno==292);
{ yymsp[1].minor.yy164 = createStreamOptions(pCxt); }
        break;
      case 266: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 296: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==296);
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 267: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 268: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy193, &yymsp[-2].minor.yy593, yymsp[0].minor.yy164); }
        break;
      case 269: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy193, &yymsp[-3].minor.yy593, &yymsp[0].minor.yy593, false); }
        break;
      case 270: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy193, &yymsp[-5].minor.yy593, &yymsp[0].minor.yy593, true); }
        break;
      case 271: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy193, &yymsp[-3].minor.yy593, yymsp[0].minor.yy164, false); }
        break;
      case 272: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy193, &yymsp[-5].minor.yy593, yymsp[0].minor.yy164, true); }
        break;
      case 273: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 274: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy193, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593); }
        break;
      case 275: /* cmd ::= DESC full_table_name */
      case 276: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==276);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy164); }
        break;
      case 277: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 278: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy193, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 281: /* explain_options ::= */
{ yymsp[1].minor.yy164 = createDefaultExplainOptions(pCxt); }
        break;
      case 282: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy164 = setExplainVerbose(pCxt, yymsp[-2].minor.yy164, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 283: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy164 = setExplainRatio(pCxt, yymsp[-2].minor.yy164, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 284: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy193, yymsp[-8].minor.yy193, &yymsp[-5].minor.yy593, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy720, yymsp[0].minor.yy512); }
        break;
      case 285: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 290: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy193, &yymsp[-7].minor.yy593, yymsp[-4].minor.yy164, yymsp[-6].minor.yy164, yymsp[-3].minor.yy648, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 291: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 293: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 294: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 295: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy164)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy164)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-3].minor.yy164; }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 297: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy164)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy164 = yymsp[-3].minor.yy164; }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 298: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 300: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 486: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==486);
      case 504: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==504);
{ yymsp[-3].minor.yy164 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy164); }
        break;
      case 301: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 302: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 303: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 304: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 305: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 306: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy648); }
        break;
      case 307: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 308: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy648 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 310: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 312: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy164, yymsp[-2].minor.yy648, yymsp[0].minor.yy164); }
        break;
      case 313: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy164, NULL, yymsp[0].minor.yy164); }
        break;
      case 314: /* literal ::= NK_INTEGER */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 315: /* literal ::= NK_FLOAT */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 316: /* literal ::= NK_STRING */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 317: /* literal ::= NK_BOOL */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 318: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 319: /* literal ::= duration_literal */
      case 329: /* signed_literal ::= signed */ yytestcase(yyruleno==329);
      case 349: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==349);
      case 350: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==350);
      case 351: /* expression ::= literal */ yytestcase(yyruleno==351);
      case 352: /* expression ::= pseudo_column */ yytestcase(yyruleno==352);
      case 353: /* expression ::= column_reference */ yytestcase(yyruleno==353);
      case 354: /* expression ::= function_expression */ yytestcase(yyruleno==354);
      case 355: /* expression ::= case_when_expression */ yytestcase(yyruleno==355);
      case 385: /* function_expression ::= literal_func */ yytestcase(yyruleno==385);
      case 434: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==434);
      case 438: /* boolean_primary ::= predicate */ yytestcase(yyruleno==438);
      case 440: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==440);
      case 441: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==441);
      case 444: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==444);
      case 446: /* table_reference ::= table_primary */ yytestcase(yyruleno==446);
      case 447: /* table_reference ::= joined_table */ yytestcase(yyruleno==447);
      case 451: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==451);
      case 506: /* query_simple ::= query_specification */ yytestcase(yyruleno==506);
      case 507: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==507);
      case 510: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==510);
      case 512: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==512);
{ yylhsminor.yy164 = yymsp[0].minor.yy164; }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 320: /* literal ::= NULL */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 321: /* literal ::= NK_QUESTION */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 322: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 323: /* signed ::= NK_INTEGER */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 324: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 325: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 326: /* signed ::= NK_FLOAT */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 327: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 328: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 330: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 331: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 332: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 333: /* signed_literal ::= duration_literal */
      case 335: /* signed_literal ::= literal_func */ yytestcase(yyruleno==335);
      case 405: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==405);
      case 467: /* select_item ::= common_expression */ yytestcase(yyruleno==467);
      case 477: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==477);
      case 511: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==511);
      case 513: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==513);
      case 526: /* search_condition ::= common_expression */ yytestcase(yyruleno==526);
{ yylhsminor.yy164 = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 334: /* signed_literal ::= NULL */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 336: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy164 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 356: /* expression ::= NK_LP expression NK_RP */
      case 439: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==439);
      case 525: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==525);
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 357: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy164));
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 358: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy164), NULL));
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 359: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 360: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 361: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 362: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 363: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 364: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 365: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 366: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 369: /* column_reference ::= column_name */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy593, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy593)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 370: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593, createColumnNode(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 371: /* pseudo_column ::= ROWTS */
      case 372: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==372);
      case 374: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==374);
      case 375: /* pseudo_column ::= QEND */ yytestcase(yyruleno==375);
      case 376: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==376);
      case 377: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==377);
      case 378: /* pseudo_column ::= WEND */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==381);
      case 387: /* literal_func ::= NOW */ yytestcase(yyruleno==387);
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 373: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy593)))); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 382: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 383: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==383);
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy593, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy593, yymsp[-1].minor.yy648)); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 384: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy720)); }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 386: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy593, NULL)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 401: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy648 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 406: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 470: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==470);
{ yylhsminor.yy164 = createColumnNode(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 407: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy648, yymsp[-1].minor.yy164)); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 408: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-2].minor.yy648, yymsp[-1].minor.yy164)); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 411: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy164 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
        break;
      case 413: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy164 = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); }
        break;
      case 414: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 419: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==419);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy656, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 415: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy164), releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 416: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 417: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), NULL));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 418: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL));
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 420: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy656 = OP_TYPE_LOWER_THAN; }
        break;
      case 421: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy656 = OP_TYPE_GREATER_THAN; }
        break;
      case 422: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy656 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 423: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy656 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 424: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy656 = OP_TYPE_NOT_EQUAL; }
        break;
      case 425: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy656 = OP_TYPE_EQUAL; }
        break;
      case 426: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy656 = OP_TYPE_LIKE; }
        break;
      case 427: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy656 = OP_TYPE_NOT_LIKE; }
        break;
      case 428: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy656 = OP_TYPE_MATCH; }
        break;
      case 429: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy656 = OP_TYPE_NMATCH; }
        break;
      case 430: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy656 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 431: /* in_op ::= IN */
{ yymsp[0].minor.yy656 = OP_TYPE_IN; }
        break;
      case 432: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy656 = OP_TYPE_NOT_IN; }
        break;
      case 433: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy648)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 435: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy164), NULL));
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 436: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 437: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 443: /* from_clause_opt ::= FROM table_reference_list */
      case 472: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==472);
      case 500: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==500);
{ yymsp[-1].minor.yy164 = yymsp[0].minor.yy164; }
        break;
      case 445: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy164 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, NULL); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 448: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy164 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 449: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy164 = createRealTableNode(pCxt, &yymsp[-3].minor.yy593, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 450: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy164 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164), &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 452: /* alias_opt ::= */
{ yymsp[1].minor.yy593 = nil_token;  }
        break;
      case 453: /* alias_opt ::= table_alias */
{ yylhsminor.yy593 = yymsp[0].minor.yy593; }
  yymsp[0].minor.yy593 = yylhsminor.yy593;
        break;
      case 454: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy593 = yymsp[0].minor.yy593; }
        break;
      case 455: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 456: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==456);
{ yymsp[-2].minor.yy164 = yymsp[-1].minor.yy164; }
        break;
      case 457: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy164 = createJoinTableNode(pCxt, yymsp[-4].minor.yy868, yymsp[-5].minor.yy164, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 458: /* join_type ::= */
{ yymsp[1].minor.yy868 = JOIN_TYPE_INNER; }
        break;
      case 459: /* join_type ::= INNER */
{ yymsp[0].minor.yy868 = JOIN_TYPE_INNER; }
        break;
      case 460: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy164 = createSelectStmt(pCxt, yymsp[-10].minor.yy193, yymsp[-9].minor.yy648, yymsp[-8].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addWhereClause(pCxt, yymsp[-11].minor.yy164, yymsp[-7].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addPartitionByClause(pCxt, yymsp[-11].minor.yy164, yymsp[-6].minor.yy648);
                                                                                    yymsp[-11].minor.yy164 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy164, yymsp[-2].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addGroupByClause(pCxt, yymsp[-11].minor.yy164, yymsp[-1].minor.yy648);
                                                                                    yymsp[-11].minor.yy164 = addHavingClause(pCxt, yymsp[-11].minor.yy164, yymsp[0].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addRangeClause(pCxt, yymsp[-11].minor.yy164, yymsp[-5].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addEveryClause(pCxt, yymsp[-11].minor.yy164, yymsp[-4].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addFillClause(pCxt, yymsp[-11].minor.yy164, yymsp[-3].minor.yy164);
                                                                                  }
        break;
      case 463: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy193 = false; }
        break;
      case 466: /* select_item ::= NK_STAR */
{ yylhsminor.yy164 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 468: /* select_item ::= common_expression column_alias */
      case 478: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==478);
{ yylhsminor.yy164 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164), &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 469: /* select_item ::= common_expression AS column_alias */
      case 479: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==479);
{ yylhsminor.yy164 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), &yymsp[0].minor.yy593); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 474: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 496: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==496);
      case 515: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==515);
{ yymsp[-2].minor.yy648 = yymsp[0].minor.yy648; }
        break;
      case 481: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy164 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
        break;
      case 482: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy164 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
        break;
      case 483: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy164 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 484: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy164 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 488: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy164 = createFillNode(pCxt, yymsp[-1].minor.yy638, NULL); }
        break;
      case 489: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy164 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy648)); }
        break;
      case 490: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy638 = FILL_MODE_NONE; }
        break;
      case 491: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy638 = FILL_MODE_PREV; }
        break;
      case 492: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy638 = FILL_MODE_NULL; }
        break;
      case 493: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy638 = FILL_MODE_LINEAR; }
        break;
      case 494: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy638 = FILL_MODE_NEXT; }
        break;
      case 497: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy648 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 498: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 502: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy164 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
        break;
      case 505: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy164 = addOrderByClause(pCxt, yymsp[-3].minor.yy164, yymsp[-2].minor.yy648);
                                                                                    yylhsminor.yy164 = addSlimitClause(pCxt, yylhsminor.yy164, yymsp[-1].minor.yy164);
                                                                                    yylhsminor.yy164 = addLimitClause(pCxt, yylhsminor.yy164, yymsp[0].minor.yy164);
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 508: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy164 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 509: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy164 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 517: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 521: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==521);
{ yymsp[-1].minor.yy164 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 518: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 522: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==522);
{ yymsp[-3].minor.yy164 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 519: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 523: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==523);
{ yymsp[-3].minor.yy164 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 524: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy164); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 529: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy164 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), yymsp[-1].minor.yy238, yymsp[0].minor.yy153); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 530: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy238 = ORDER_ASC; }
        break;
      case 531: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy238 = ORDER_ASC; }
        break;
      case 532: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy238 = ORDER_DESC; }
        break;
      case 533: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy153 = NULL_ORDER_DEFAULT; }
        break;
      case 534: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy153 = NULL_ORDER_FIRST; }
        break;
      case 535: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy153 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
