/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 456
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy50;
  int64_t yy93;
  SNode* yy104;
  bool yy185;
  int32_t yy196;
  EJoinType yy228;
  EFillMode yy246;
  SAlterOption yy557;
  SNodeList* yy616;
  SDataType yy640;
  EOperatorType yy668;
  int8_t yy695;
  SToken yy737;
  ENullOrder yy793;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             707
#define YYNRULE              538
#define YYNTOKEN             321
#define YY_MAX_SHIFT         706
#define YY_MIN_SHIFTREDUCE   1049
#define YY_MAX_SHIFTREDUCE   1586
#define YY_ERROR_ACTION      1587
#define YY_ACCEPT_ACTION     1588
#define YY_NO_ACTION         1589
#define YY_MIN_REDUCE        1590
#define YY_MAX_REDUCE        2127
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2544)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   396, 2103,  349, 1858,  455, 2098,  456, 1626,   33,  274,
 /*    10 */   156,  578,   43,   41, 1517,  464,  168,  456, 1626, 1747,
 /*    20 */   357, 2102, 1368,   36,   35, 2099, 2101,   42,   40,   39,
 /*    30 */    38,   37,  595, 1447,  158, 1366, 1943,  329, 1844, 1698,
 /*    40 */   524,  540,   36,   35,  579, 2098,   42,   40,   39,   38,
 /*    50 */    37, 1394,  540,  522,  348,  520, 2098, 1855, 1442,   25,
 /*    60 */  2104,  174,  370,   16,  156, 2099,  561, 1961, 1791, 1792,
 /*    70 */  1374, 2104,  174, 1748, 2103,  575, 2099,  561, 2098,  572,
 /*    80 */  1912,  595,  612,   43,   41,   42,   40,   39,   38,   37,
 /*    90 */   159,  357, 1602, 1368, 2102, 1797,   12,  322, 2099, 2100,
 /*   100 */    11,   10,  350,  540, 1447, 1942, 1366, 2098,   62, 1977,
 /*   110 */   131, 1795,  100, 1944,  616, 1946, 1947,  611,  703,  606,
 /*   120 */   258,  603, 2104,  174,  171,  212, 2030, 2099,  561, 1442,
 /*   130 */   351, 2026, 1449, 1450,   16,   39,   38,   37,  473, 1476,
 /*   140 */   163, 1374, 2045,  402,  176, 1930,  490,  486,  482,  478,
 /*   150 */   209,  362, 2056,   80, 1790, 1792, 1926,   46,   58, 1797,
 /*   160 */    85, 1423, 1432, 1252, 1253, 1797,  326,   12, 2042,  255,
 /*   170 */  2038,  571,  361,  124,  570, 1795, 1741, 2098, 1393,  226,
 /*   180 */  1369, 1795, 1367,  317, 1922, 1928,  340,   81,  555,  703,
 /*   190 */   207, 1840,  559,  174, 1477,  606, 1490, 2099,  561, 1613,
 /*   200 */    58,  461,  182, 1449, 1450, 1372, 1373,  457, 1422, 1425,
 /*   210 */  1426, 1427, 1428, 1429, 1430, 1431,  608,  604, 1440, 1441,
 /*   220 */  1443, 1444, 1445, 1446, 1448, 1451,    2,  510,  509,  508,
 /*   230 */   560,  595, 1423, 1432, 2098,  128,  504, 1395,   82,  319,
 /*   240 */   503,  502,  585, 1912,  583, 1588,  501,  507, 1514,  559,
 /*   250 */   174, 1369,  500, 1367, 2099,  561,  206,  200, 1612,  205,
 /*   260 */   438,  550,  469, 1468, 1543,   32,  355, 1471, 1472, 1473,
 /*   270 */  1474, 1475, 1479, 1480, 1481, 1482, 1372, 1373,  198, 1422,
 /*   280 */  1425, 1426, 1427, 1428, 1429, 1430, 1431,  608,  604, 1440,
 /*   290 */  1441, 1443, 1444, 1445, 1446, 1448, 1451,    2,  170,    9,
 /*   300 */    43,   41, 1912,  506,  505,  177,  177,   46,  357,  372,
 /*   310 */  1368, 1784,  547, 1541, 1542, 1544, 1545,  190,  189, 1305,
 /*   320 */  1306, 1447, 1943, 1366, 1210,  638,  637,  636, 1214,  635,
 /*   330 */  1216, 1217,  634, 1219,  631, 1393, 1225,  628, 1227, 1228,
 /*   340 */   625,  622,  391,   97,  556,  551, 1442, 1101,  177, 1100,
 /*   350 */   540,   16,  454, 1961, 2098,  459, 1632,  132, 1374,  674,
 /*   360 */   672,  613,  211,  393,  389, 1737, 1912,  567,  612, 2104,
 /*   370 */   174,   43,   41, 1452, 2099,  561,   29, 1961, 1102,  357,
 /*   380 */   257, 1368,   36,   35,   12,  554,   42,   40,   39,   38,
 /*   390 */    37, 1942, 1447,  463, 1366, 1977,  459, 1632,  160, 1944,
 /*   400 */   616, 1946, 1947,  611,  596,  606,  703, 1943,   36,   35,
 /*   410 */  2045,   58,   42,   40,   39,   38,   37, 1442,  123,  264,
 /*   420 */  1449, 1450,  647,   50,  553,  494,   36,   35,  539, 1374,
 /*   430 */    42,   40,   39,   38,   37, 1745, 2041, 1170, 1961,  541,
 /*   440 */  2067,  147,  146,  644,  643,  642,  613,   91,  579, 1423,
 /*   450 */  1432, 1912,   58,  612,  560,   44, 2050, 1510, 2098,   36,
 /*   460 */    35, 1856, 1394,   42,   40,   39,   38,   37, 1369, 1738,
 /*   470 */  1367, 1396, 1172,  559,  174, 1611, 1942,  703, 2099,  561,
 /*   480 */  1977, 1345, 1346,  161, 1944,  616, 1946, 1947,  611, 1513,
 /*   490 */   606, 1449, 1450, 1372, 1373,   47, 1422, 1425, 1426, 1427,
 /*   500 */  1428, 1429, 1430, 1431,  608,  604, 1440, 1441, 1443, 1444,
 /*   510 */  1445, 1446, 1448, 1451,    2, 1553, 1082, 1610, 1609, 1912,
 /*   520 */  1423, 1432, 1591,  113, 1087, 1088,  112,  111,  110,  109,
 /*   530 */   108,  107,  106,  105,  104,  562, 2119,  265,  266, 1369,
 /*   540 */     9, 1367,    7,  113, 1722, 1608,  112,  111,  110,  109,
 /*   550 */   108,  107,  106,  105,  104, 1084, 1393, 1087, 1088,  177,
 /*   560 */   649, 1912, 1912,  155, 1372, 1373, 1478, 1422, 1425, 1426,
 /*   570 */  1427, 1428, 1429, 1430, 1431,  608,  604, 1440, 1441, 1443,
 /*   580 */  1444, 1445, 1446, 1448, 1451,    2,   43,   41,  568, 1912,
 /*   590 */   706,  515, 1392, 1101,  357, 1100, 1368, 1840,  319,  596,
 /*   600 */   177,  585,  596,  583,  281, 1521,  525, 1447,  184, 1366,
 /*   610 */  1943, 1393,   58,   52,  235,  641,  123,  596, 1607,  167,
 /*   620 */   225,    9,  572,  499, 1102,  696,  692,  688,  684,  279,
 /*   630 */  1745,  179, 1442, 1745,  360,  518,   80,   30,  168, 1374,
 /*   640 */   512, 1961,  156,  177, 1374,  224,  661, 1483, 1745,  613,
 /*   650 */   127, 1747,  647,  131, 1912, 1659,  612,   43,   41, 1740,
 /*   660 */  1845, 1723, 1912,  596, 1606,  357,   98, 1368, 1721,  272,
 /*   670 */    44,  147,  146,  644,  643,  642, 1734,  400, 1447, 1942,
 /*   680 */  1366, 1605,   64, 1977, 1730,   63,  100, 1944,  616, 1946,
 /*   690 */  1947,  611,  703,  606, 1745,  395,  134,  394,  143, 2001,
 /*   700 */  2030,  363,  592, 1442,  351, 2026, 1449, 1450, 1912,  156,
 /*   710 */   535,  574,  172, 2038, 2039, 1374,  129, 2043, 1747, 1732,
 /*   720 */   510,  509,  508,  473,  186, 1912, 1457,  572,  128,  504,
 /*   730 */   649, 1604, 1393,  503,  502, 1423, 1432, 1601,  260,  501,
 /*   740 */   507,   12, 1590,   36,   35,  500, 1396,   42,   40,   39,
 /*   750 */    38,   37, 1424, 1396, 1369, 1339, 1367,  229,  131,  227,
 /*   760 */   177,   77, 1775,  703,   76, 1736,  122,  121,  120,  119,
 /*   770 */   118,  117,  116,  115,  114, 1912, 1926, 1449, 1450, 1372,
 /*   780 */  1373, 1912, 1422, 1425, 1426, 1427, 1428, 1429, 1430, 1431,
 /*   790 */   608,  604, 1440, 1441, 1443, 1444, 1445, 1446, 1448, 1451,
 /*   800 */     2,  316,  498, 1391, 1922, 1928, 1423, 1432, 1600, 1840,
 /*   810 */   432, 2045,  598,  445, 2002,  606,  444,  173, 2038, 2039,
 /*   820 */   188,  129, 2043, 1797,  497, 1369, 1656, 1367, 1599, 1899,
 /*   830 */  1598,  416, 1533,  446,   31,  133,  418, 2040, 2001, 1796,
 /*   840 */    36,   35, 1597, 1596,   42,   40,   39,   38,   37, 1728,
 /*   850 */  1372, 1373, 1912, 1422, 1425, 1426, 1427, 1428, 1429, 1430,
 /*   860 */  1431,  608,  604, 1440, 1441, 1443, 1444, 1445, 1446, 1448,
 /*   870 */  1451,    2, 1912, 1424, 1912,   36,   35,  379,  330,   42,
 /*   880 */    40,   39,   38,   37, 1393,  645, 1912, 1912, 1788,  183,
 /*   890 */   406,  680,  679,  678,  677,  367,  234,  676,  675,  135,
 /*   900 */   670,  669,  668,  667,  666,  665,  664,  663,  149,  659,
 /*   910 */   658,  657,  366,  365,  654,  653,  652,  651,  650,  442,
 /*   920 */  1595, 1943,  437,  436,  435,  434,  431,  430,  429,  428,
 /*   930 */   427,  423,  422,  421,  420,  331,  413,  412,  411, 2102,
 /*   940 */   408,  407,  328,  157,  600,  596, 2002,  596,  292,   36,
 /*   950 */    35,  564, 1961,   42,   40,   39,   38,   37,  596,  401,
 /*   960 */   575,  410,  290,   66, 1912, 1912,   65,  612, 1854,  369,
 /*   970 */   312, 2103,  424,  145, 1943, 1594, 1745, 1853, 1745,  312,
 /*   980 */  1593,  596,   11,   10,  194,  451,  449, 1720, 1395, 1745,
 /*   990 */  1942,  572,  596,  646, 1977,  425, 1788,  100, 1944,  616,
 /*  1000 */  1946, 1947,  611,    6,  606, 1961,  139, 1827,  230,  171,
 /*  1010 */   540, 2030, 1745,  613, 2098,  351, 2026, 1699, 1912, 1912,
 /*  1020 */   612,   58,  131, 1745, 1912, 1424,   51,  596,  286, 2104,
 /*  1030 */   174, 1775,  596,  217, 2099,  561,  215, 2057, 1931, 1583,
 /*  1040 */   607,  471,  596, 1942,  233,  219,  472, 1977,  218, 1926,
 /*  1050 */   100, 1944,  616, 1946, 1947,  611,  364,  606, 1745,   99,
 /*  1060 */   596, 1943, 2118, 1745, 2030, 1576,  354,  353,  351, 2026,
 /*  1070 */   662,  640, 1715, 1745, 1742, 1377, 1382, 1922, 1928, 2064,
 /*  1080 */   596,  175, 2038, 2039,   83,  129, 2043, 1447,  606, 1375,
 /*  1090 */  1603, 1745, 1961,  403,  536,  647,   67,   74,   73,  399,
 /*  1100 */   613,   48,  181,    3, 1943, 1912,  404,  612,  137, 2070,
 /*  1110 */   125, 1745, 1442,  548,  147,  146,  644,  643,  642, 1376,
 /*  1120 */   315, 1930,  596,  387, 1374,  385,  381,  377,  374,  371,
 /*  1130 */  1942,  257, 1926, 1582, 1977, 1961,  576,  100, 1944,  616,
 /*  1140 */  1946, 1947,  611,  613,  606,   75, 1646,   96, 1912, 2118,
 /*  1150 */   612, 2030,  252, 1745, 1639,  351, 2026,   93,  419,  210,
 /*  1160 */  1922, 1928,  352,  528,  221,  596, 2092,  220,  511,  177,
 /*  1170 */   565,  606,  602, 1942,  596, 1943,  513, 1977,   60,  269,
 /*  1180 */   100, 1944,  616, 1946, 1947,  611,  596,  606,  591,  596,
 /*  1190 */  1637, 1933, 2118,  246, 2030, 1962, 1745,  563,  351, 2026,
 /*  1200 */   593,  596,  368,  594,  540, 1745, 1961, 1510, 2098, 2049,
 /*  1210 */  1585, 1586,  516,  223,  613,  275,  222, 1745, 1943, 1912,
 /*  1220 */  1745,  612, 1380, 2104,  174,  239,   45,  262, 2099,  561,
 /*  1230 */   140, 1540, 1745,  144, 1383,  145, 1378,   60, 1849, 1627,
 /*  1240 */  1935, 1785,  573, 2060, 1942,  254, 1130,  251, 1977, 1961,
 /*  1250 */    45,  100, 1944,  616, 1946, 1947,  611,  613,  606, 1386,
 /*  1260 */  1388, 1943, 1912, 2005,  612, 2030, 1379,   45,  620,  351,
 /*  1270 */  2026,  604, 1440, 1441, 1443, 1444, 1445, 1446,  241, 1316,
 /*  1280 */   267, 1131,    4,  588, 1633, 1943,  271, 1942, 1203,  655,
 /*  1290 */  1484, 1977, 1961,  144,  100, 1944,  616, 1946, 1947,  611,
 /*  1300 */   613,  606,    1, 1433,  145, 1912, 2003,  612, 2030,  373,
 /*  1310 */   378, 1150,  351, 2026,  656,  327, 1961,  126,  144, 1368,
 /*  1320 */   285, 1231,  282, 1332,  613,  187,  405, 1396, 1850, 1912,
 /*  1330 */  1942,  612, 1366,  698, 1977,  334, 1148,  100, 1944,  616,
 /*  1340 */  1946, 1947,  611, 1943,  606,  409, 1235,  440,  414,  599,
 /*  1350 */  1391, 2030,  426, 1842, 1942,  351, 2026, 1242, 1977,  433,
 /*  1360 */   447,  101, 1944,  616, 1946, 1947,  611, 1374,  606,  439,
 /*  1370 */  1240,  148,  441,  448, 1961, 2030,  191,  450,  452, 2029,
 /*  1380 */  2026, 1397,  613,  453,  462, 1399, 1943, 1912,  465,  612,
 /*  1390 */   197,  199,  466, 1398,  467, 1400,  468,  335,  202,  333,
 /*  1400 */   332,  470,  496,  204,  474,   78,  498,   79,  208, 1104,
 /*  1410 */   491,  492, 1942,  493, 1943,  703, 1977, 1961,  495,  101,
 /*  1420 */  1944,  616, 1946, 1947,  611,  613,  606,  102,  497, 1735,
 /*  1430 */  1912,  318,  612, 2030,  214, 1731,  216,  601, 2026,  527,
 /*  1440 */   150,  151,  529, 1733, 1729, 1961,  152,  153,  228,  530,
 /*  1450 */  1889,  231,  537,  610,  549,  614,  582,    5, 1912, 1977,
 /*  1460 */   612, 2061,  101, 1944,  616, 1946, 1947,  611,  283,  606,
 /*  1470 */   534, 2071,  544, 1943, 2076,  546, 2030, 1369,  237, 1367,
 /*  1480 */   321, 2026,  240, 1942,  531, 2075,  341, 1977,  558,  552,
 /*  1490 */   307, 1944,  616, 1946, 1947,  611,  609,  606,  597, 1995,
 /*  1500 */   545,  543, 1372, 1373, 1961,  542,  250,  569,  342,  566,
 /*  1510 */  2121,  245,  613, 1510,  130, 1395, 2046, 1912,  345,  612,
 /*  1520 */   577,  141,  142,  580,  581, 1888, 1860,  586,  259,  347,
 /*  1530 */    88, 1943,  589,  248,  164, 2052,  249,  247, 1746,  590,
 /*  1540 */    90,   57, 1942, 2011,   92, 1789, 1977,  284, 1716,  101,
 /*  1550 */  1944,  616, 1946, 1947,  611, 2097,  606,  253,  287, 1943,
 /*  1560 */   618,  278, 1961, 2030,  699,  700,   49,  301, 2027,  310,
 /*  1570 */   613,  309,  702,  289,  291, 1912, 1906,  612, 1905,  311,
 /*  1580 */    71, 1904, 1903,   72, 1900, 1943,  375,  376, 1360, 1361,
 /*  1590 */  1961,  180, 1898,  380,  382,  383,  384, 1897,  613,  386,
 /*  1600 */  1942, 1896,  388, 1912, 1977,  612, 1895,  160, 1944,  616,
 /*  1610 */  1946, 1947,  611, 1894,  606,  390, 1961, 1335,  392, 1334,
 /*  1620 */  1871, 1870,  397, 1869,  613,  398, 1868, 1296, 1942, 1912,
 /*  1630 */  1835,  612, 1977, 1834, 1832,  300, 1944,  616, 1946, 1947,
 /*  1640 */   611,  136,  606, 1831, 1830, 1833, 1829, 1828, 1826, 2068,
 /*  1650 */  1825, 1824,  185,  415, 1942, 1943, 1823,  417, 1977, 1822,
 /*  1660 */  1821,  161, 1944,  616, 1946, 1947,  611, 1820,  606, 1819,
 /*  1670 */  1818, 1817, 1816, 1815, 1943, 1298, 1802,  138, 1807,  557,
 /*  1680 */  1814, 1813, 1812, 1811, 1810, 1809, 1961, 1808, 1806, 1805,
 /*  1690 */  1804,  346,  443, 1799,  613, 1803, 1801, 1800, 1798, 1912,
 /*  1700 */  1178,  612, 1661, 1660, 1658, 1961, 1622,  192,  195, 1932,
 /*  1710 */   193,  458,  169,  610, 2120, 1090,   69, 1621, 1912, 1089,
 /*  1720 */   612,  460, 1884, 1878, 1942, 1867,  196, 1866, 1977,  203,
 /*  1730 */    70,  308, 1944,  616, 1946, 1947,  611, 1943,  606,  201,
 /*  1740 */  1852, 1724, 1657, 1942, 1655,  475,  477, 1977, 1653,  479,
 /*  1750 */   307, 1944,  616, 1946, 1947,  611,  476,  606, 1943, 1996,
 /*  1760 */   480, 1651, 1649, 1123,  483,  481,  484,  485, 1961,  487,
 /*  1770 */   489, 1636,  488,  356, 1635, 1618,  613, 1726, 1246, 1245,
 /*  1780 */  1943, 1912, 1725,  612,   59, 1169, 1168, 1167, 1166, 1961,
 /*  1790 */  1165,  671, 1160,  673,  358, 1162, 1647,  613, 1161, 1159,
 /*  1800 */   336, 1943, 1912, 1640,  612,  337, 1942, 1638,  514,  338,
 /*  1810 */  1977, 1961,  213,  308, 1944,  616, 1946, 1947,  611,  613,
 /*  1820 */   606,  517, 1617, 1943, 1912,  519,  612, 1942, 1616,  521,
 /*  1830 */  1615, 1977, 1961,  523,  308, 1944,  616, 1946, 1947,  611,
 /*  1840 */   613,  606, 1352,  103, 1943, 1912, 1883,  612,   24,  526,
 /*  1850 */  1341, 1877, 1865, 1977, 1961,  532,  303, 1944,  616, 1946,
 /*  1860 */  1947,  611,  613,  606, 1863,   17, 2103, 1912,   26,  612,
 /*  1870 */  1942,   56,   14, 1555, 1977, 1961,   53,  293, 1944,  616,
 /*  1880 */  1946, 1947,  611,  613,  606,  232,  238, 1943, 1912,  236,
 /*  1890 */   612,  162, 1942,  533,  154,  339, 1977, 1539, 1532,  294,
 /*  1900 */  1944,  616, 1946, 1947,  611,  538,  606,  244,  242,   27,
 /*  1910 */   243,   28, 1933, 1942,   84, 1943,   61, 1977, 1961,   19,
 /*  1920 */   295, 1944,  616, 1946, 1947,  611,  613,  606, 1575, 1576,
 /*  1930 */  1570, 1912, 1569,  612,  343, 1574, 1573,  344, 1507, 1506,
 /*  1940 */   256, 1943,   18,  165, 1864, 1862, 1961,   55, 1861,   20,
 /*  1950 */  1350,  261, 1537,  263,  613, 1349, 1942,   54,  584, 1912,
 /*  1960 */  1977,  612, 1859,  299, 1944,  616, 1946, 1947,  611,   15,
 /*  1970 */   606,  587, 1961,  268,   86, 1851,   87,   89,  270,   93,
 /*  1980 */   613,  273,   21, 1459, 1942, 1912,   10,  612, 1977, 1384,
 /*  1990 */  1469,  304, 1944,  616, 1946, 1947,  611,    8,  606, 1943,
 /*  2000 */  1458, 1437, 1980,  605,  166, 1435,   34,  178, 1434, 1407,
 /*  2010 */  1942,  615,   13,   22, 1977, 1415, 1943,  296, 1944,  616,
 /*  2020 */  1946, 1947,  611, 1232,  606,   23,  617,  619,  621,  359,
 /*  2030 */  1961,  623, 1229, 1226,  626,  624,  627,  629,  613, 1220,
 /*  2040 */  1218,  632,  630, 1912, 1224,  612,  633, 1961, 1223, 1209,
 /*  2050 */  1222, 1221,   94, 1241,   95,  613,  276,  639, 1237, 1943,
 /*  2060 */  1912,   68,  612, 1156, 1121, 1155,  648, 1154, 1942, 1153,
 /*  2070 */  1152, 1176, 1977, 1151, 1149,  305, 1944,  616, 1946, 1947,
 /*  2080 */   611, 1147,  606, 1943, 1146, 1942, 1145,  277,  660, 1977,
 /*  2090 */  1961, 1143,  297, 1944,  616, 1946, 1947,  611,  613,  606,
 /*  2100 */  1142, 1141, 1140, 1912, 1139,  612, 1138, 1137, 1127, 1136,
 /*  2110 */  1173, 1171, 1133, 1132, 1961, 1129, 1128, 1654, 1126,  681,
 /*  2120 */  1652, 1650,  613,  682,  683,  685, 1943, 1912, 1942,  612,
 /*  2130 */   687,  691, 1977,  689, 1648,  306, 1944,  616, 1946, 1947,
 /*  2140 */   611,  693,  606, 1943,  686,  690,  695,  694, 1634,  697,
 /*  2150 */  1079, 1614, 1942,  280,  701,  705, 1977, 1961,  704,  298,
 /*  2160 */  1944,  616, 1946, 1947,  611,  613,  606, 1370,  288, 1943,
 /*  2170 */  1912, 1589,  612, 1589, 1961, 1589, 1589, 1589, 1589, 1589,
 /*  2180 */  1589, 1589,  613, 1589, 1589, 1589, 1943, 1912, 1589,  612,
 /*  2190 */  1589, 1589, 1589, 1589, 1589, 1942, 1589, 1589, 1589, 1977,
 /*  2200 */  1961, 1589,  313, 1944,  616, 1946, 1947,  611,  613,  606,
 /*  2210 */  1589, 1589, 1942, 1912, 1589,  612, 1977, 1961, 1589,  314,
 /*  2220 */  1944,  616, 1946, 1947,  611,  613,  606, 1589, 1589, 1943,
 /*  2230 */  1912, 1589,  612, 1589, 1589, 1589, 1589, 1589, 1942, 1589,
 /*  2240 */  1589, 1589, 1977, 1589, 1589, 1955, 1944,  616, 1946, 1947,
 /*  2250 */   611, 1943,  606, 1589, 1589, 1942, 1589, 1589, 1589, 1977,
 /*  2260 */  1961, 1589, 1954, 1944,  616, 1946, 1947,  611,  613,  606,
 /*  2270 */  1589, 1589, 1589, 1912, 1589,  612, 1589, 1589, 1589, 1589,
 /*  2280 */  1589, 1589, 1961, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*  2290 */   613, 1589, 1589, 1589, 1589, 1912, 1589,  612, 1942, 1589,
 /*  2300 */  1589, 1589, 1977, 1589, 1589, 1953, 1944,  616, 1946, 1947,
 /*  2310 */   611, 1589,  606, 1943, 1589, 1589, 1589, 1589, 1589, 1589,
 /*  2320 */  1942, 1589, 1589, 1589, 1977, 1589, 1589,  323, 1944,  616,
 /*  2330 */  1946, 1947,  611, 1589,  606, 1943, 1589, 1589, 1589, 1589,
 /*  2340 */  1589, 1589, 1589, 1589, 1961, 1589, 1589, 1589, 1589, 1589,
 /*  2350 */  1589, 1589,  613, 1589, 1589, 1589, 1589, 1912, 1589,  612,
 /*  2360 */  1589, 1589, 1589, 1589, 1589, 1589, 1961, 1589, 1589, 1589,
 /*  2370 */  1589, 1589, 1589, 1589,  613, 1589, 1589, 1589, 1589, 1912,
 /*  2380 */  1589,  612, 1942, 1589, 1589, 1589, 1977, 1589, 1589,  324,
 /*  2390 */  1944,  616, 1946, 1947,  611, 1589,  606, 1943, 1589, 1589,
 /*  2400 */  1589, 1589, 1589, 1589, 1942, 1589, 1589, 1589, 1977, 1589,
 /*  2410 */  1589,  320, 1944,  616, 1946, 1947,  611, 1943,  606, 1589,
 /*  2420 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1961, 1589,
 /*  2430 */  1589, 1589, 1589, 1589, 1589, 1589,  613, 1589, 1589, 1589,
 /*  2440 */  1589, 1912, 1589,  612, 1589, 1589, 1589, 1589, 1961, 1589,
 /*  2450 */  1589, 1589, 1589, 1589, 1589, 1589,  613, 1589, 1589, 1589,
 /*  2460 */  1943, 1912, 1589,  612, 1589, 1589, 1942, 1589, 1589, 1589,
 /*  2470 */  1977, 1589, 1589,  325, 1944,  616, 1946, 1947,  611, 1589,
 /*  2480 */   606, 1589, 1589, 1589, 1589, 1589,  614, 1589, 1589, 1589,
 /*  2490 */  1977, 1961, 1589,  303, 1944,  616, 1946, 1947,  611,  613,
 /*  2500 */   606, 1589, 1589, 1589, 1912, 1589,  612, 1589, 1589, 1589,
 /*  2510 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589,
 /*  2520 */  1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1589, 1942,
 /*  2530 */  1589, 1589, 1589, 1977, 1589, 1589,  302, 1944,  616, 1946,
 /*  2540 */  1947,  611, 1589,  606,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   385,  426,  347,    0,  328,  430,  330,  331,  415,  416,
 /*    10 */   355,  385,   12,   13,   14,  328,  355,  330,  331,  364,
 /*    20 */    20,  446,   22,    8,    9,  450,  451,   12,   13,   14,
 /*    30 */    15,   16,   20,   33,  339,   35,  324,  376,  377,  344,
 /*    40 */    21,  426,    8,    9,  370,  430,   12,   13,   14,   15,
 /*    50 */    16,   20,  426,   34,  380,   36,  430,  383,   58,   44,
 /*    60 */   445,  446,  385,   63,  355,  450,  451,  355,  369,  370,
 /*    70 */    70,  445,  446,  364,  426,  363,  450,  451,  430,  332,
 /*    80 */   368,   20,  370,   12,   13,   12,   13,   14,   15,   16,
 /*    90 */   323,   20,  325,   22,  446,  355,   96,   63,  450,  451,
 /*   100 */     1,    2,  362,  426,   33,  393,   35,  430,    4,  397,
 /*   110 */   363,  371,  400,  401,  402,  403,  404,  405,  118,  407,
 /*   120 */    58,   63,  445,  446,  412,   33,  414,  450,  451,   58,
 /*   130 */   418,  419,  132,  133,   63,   14,   15,   16,   62,  105,
 /*   140 */    48,   70,  399,  332,  432,  357,   54,   55,   56,   57,
 /*   150 */    58,  366,  440,  338,  369,  370,  368,   96,   96,  355,
 /*   160 */    98,  161,  162,  132,  133,  355,  362,   96,  425,  422,
 /*   170 */   423,  424,  362,  426,  427,  371,  361,  430,   20,  128,
 /*   180 */   180,  371,  182,  372,  396,  397,  398,   95,   20,  118,
 /*   190 */    98,  363,  445,  446,  160,  407,   97,  450,  451,  324,
 /*   200 */    96,   14,  374,  132,  133,  205,  206,   20,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,   65,   66,   67,
 /*   230 */   426,   20,  161,  162,  430,   73,   74,   20,  187,  188,
 /*   240 */    78,   79,  191,  368,  193,  321,   84,   85,    4,  445,
 /*   250 */   446,  180,   90,  182,  450,  451,  164,  165,  324,  167,
 /*   260 */    80,  166,  170,  205,  205,  231,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  205,  206,  186,  208,
 /*   280 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  354,  228,
 /*   300 */    12,   13,  368,  341,  342,  244,  244,   96,   20,  385,
 /*   310 */    22,  367,  253,  254,  255,  256,  257,  137,  138,  161,
 /*   320 */   162,   33,  324,   35,  109,  110,  111,  112,  113,  114,
 /*   330 */   115,  116,  117,  118,  119,   20,  121,  122,  123,  124,
 /*   340 */   125,  126,  175,  336,  249,  250,   58,   20,  244,   22,
 /*   350 */   426,   63,  329,  355,  430,  332,  333,  350,   70,  341,
 /*   360 */   342,  363,   35,  196,  197,  358,  368,   44,  370,  445,
 /*   370 */   446,   12,   13,   14,  450,  451,    2,  355,   51,   20,
 /*   380 */   163,   22,    8,    9,   96,  363,   12,   13,   14,   15,
 /*   390 */    16,  393,   33,  329,   35,  397,  332,  333,  400,  401,
 /*   400 */   402,  403,  404,  405,  332,  407,  118,  324,    8,    9,
 /*   410 */   399,   96,   12,   13,   14,   15,   16,   58,  346,  127,
 /*   420 */   132,  133,  108,  163,  402,  353,    8,    9,  168,   70,
 /*   430 */    12,   13,   14,   15,   16,  363,  425,   35,  355,  441,
 /*   440 */   442,  127,  128,  129,  130,  131,  363,  336,  370,  161,
 /*   450 */   162,  368,   96,  370,  426,   96,  242,  243,  430,    8,
 /*   460 */     9,  383,   20,   12,   13,   14,   15,   16,  180,  358,
 /*   470 */   182,   20,   70,  445,  446,  324,  393,  118,  450,  451,
 /*   480 */   397,  189,  190,  400,  401,  402,  403,  404,  405,  245,
 /*   490 */   407,  132,  133,  205,  206,   96,  208,  209,  210,  211,
 /*   500 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   510 */   222,  223,  224,  225,  226,   97,    4,  324,  324,  368,
 /*   520 */   161,  162,    0,   21,   45,   46,   24,   25,   26,   27,
 /*   530 */    28,   29,   30,   31,   32,  452,  453,  127,  128,  180,
 /*   540 */   228,  182,  230,   21,    0,  324,   24,   25,   26,   27,
 /*   550 */    28,   29,   30,   31,   32,   43,   20,   45,   46,  244,
 /*   560 */    62,  368,  368,  163,  205,  206,  160,  208,  209,  210,
 /*   570 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   580 */   221,  222,  223,  224,  225,  226,   12,   13,  265,  368,
 /*   590 */    19,    4,   20,   20,   20,   22,   22,  363,  188,  332,
 /*   600 */   244,  191,  332,  193,   33,   14,   19,   33,  374,   35,
 /*   610 */   324,   20,   96,  346,  163,  107,  346,  332,  324,   48,
 /*   620 */    33,  228,  332,  353,   51,   54,   55,   56,   57,   58,
 /*   630 */   363,  346,   58,  363,  347,   48,  338,  231,  355,   70,
 /*   640 */    53,  355,  355,  244,   70,   58,   70,  241,  363,  363,
 /*   650 */   352,  364,  108,  363,  368,    0,  370,   12,   13,  361,
 /*   660 */   377,    0,  368,  332,  324,   20,   95,   22,    0,   98,
 /*   670 */    96,  127,  128,  129,  130,  131,  356,  346,   33,  393,
 /*   680 */    35,  324,   95,  397,  356,   98,  400,  401,  402,  403,
 /*   690 */   404,  405,  118,  407,  363,  179,  410,  181,  412,  413,
 /*   700 */   414,  347,  131,   58,  418,  419,  132,  133,  368,  355,
 /*   710 */   389,  421,  422,  423,  424,   70,  426,  427,  364,  356,
 /*   720 */    65,   66,   67,   62,   58,  368,   14,  332,   73,   74,
 /*   730 */    62,  324,   20,   78,   79,  161,  162,  324,  167,   84,
 /*   740 */    85,   96,    0,    8,    9,   90,   20,   12,   13,   14,
 /*   750 */    15,   16,  161,   20,  180,  184,  182,  186,  363,  348,
 /*   760 */   244,   95,  351,  118,   98,  357,   24,   25,   26,   27,
 /*   770 */    28,   29,   30,   31,   32,  368,  368,  132,  133,  205,
 /*   780 */   206,  368,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   790 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   800 */   226,   18,  108,   20,  396,  397,  161,  162,  324,  363,
 /*   810 */    27,  399,  411,   30,  413,  407,   33,  422,  423,  424,
 /*   820 */   374,  426,  427,  355,  130,  180,    0,  182,  324,    0,
 /*   830 */   324,   48,   97,   50,    2,  410,   53,  425,  413,  371,
 /*   840 */     8,    9,  324,  324,   12,   13,   14,   15,   16,  356,
 /*   850 */   205,  206,  368,  208,  209,  210,  211,  212,  213,  214,
 /*   860 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  224,
 /*   870 */   225,  226,  368,  161,  368,    8,    9,   48,   95,   12,
 /*   880 */    13,   14,   15,   16,   20,  365,  368,  368,  368,  163,
 /*   890 */   107,   65,   66,   67,   68,   69,  163,   71,   72,   73,
 /*   900 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   910 */    84,   85,   86,   87,   88,   89,   90,   91,   92,  136,
 /*   920 */   324,  324,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   930 */   147,  148,  149,  150,  151,  152,  153,  154,  155,    3,
 /*   940 */   157,  158,  159,   18,  411,  332,  413,  332,   23,    8,
 /*   950 */     9,   44,  355,   12,   13,   14,   15,   16,  332,  346,
 /*   960 */   363,  346,   37,   38,  368,  368,   41,  370,  382,  385,
 /*   970 */   384,    3,  346,   44,  324,  324,  363,  382,  363,  384,
 /*   980 */   324,  332,    1,    2,   59,   60,   61,    0,   20,  363,
 /*   990 */   393,  332,  332,  365,  397,  346,  368,  400,  401,  402,
 /*  1000 */   403,  404,  405,   39,  407,  355,  346,    0,  356,  412,
 /*  1010 */   426,  414,  363,  363,  430,  418,  419,  344,  368,  368,
 /*  1020 */   370,   96,  363,  363,  368,  161,   97,  332,  348,  445,
 /*  1030 */   446,  351,  332,  100,  450,  451,  103,  440,  357,  172,
 /*  1040 */   356,  346,  332,  393,   58,  100,  346,  397,  103,  368,
 /*  1050 */   400,  401,  402,  403,  404,  405,  346,  407,  363,  134,
 /*  1060 */   332,  324,  412,  363,  414,   97,   12,   13,  418,  419,
 /*  1070 */   343,  356,  345,  363,  346,   35,   22,  396,  397,  429,
 /*  1080 */   332,  422,  423,  424,   98,  426,  427,   33,  407,   35,
 /*  1090 */   325,  363,  355,   22,  346,  108,  107,  172,  173,  174,
 /*  1100 */   363,   42,  177,   44,  324,  368,   35,  370,   42,  378,
 /*  1110 */    44,  363,   58,  443,  127,  128,  129,  130,  131,   35,
 /*  1120 */   195,  357,  332,  198,   70,  200,  201,  202,  203,  204,
 /*  1130 */   393,  163,  368,  266,  397,  355,  346,  400,  401,  402,
 /*  1140 */   403,  404,  405,  363,  407,  156,    0,   96,  368,  412,
 /*  1150 */   370,  414,  454,  363,    0,  418,  419,  106,  151,  334,
 /*  1160 */   396,  397,  398,  385,  100,  332,  429,  103,   22,  244,
 /*  1170 */   263,  407,  118,  393,  332,  324,   22,  397,   44,  346,
 /*  1180 */   400,  401,  402,  403,  404,  405,  332,  407,  346,  332,
 /*  1190 */     0,   47,  412,  437,  414,  355,  363,  261,  418,  419,
 /*  1200 */   346,  332,  334,  346,  426,  363,  355,  243,  430,  429,
 /*  1210 */   132,  133,   22,  100,  363,  346,  103,  363,  324,  368,
 /*  1220 */   363,  370,  182,  445,  446,   44,   44,   44,  450,  451,
 /*  1230 */    44,   97,  363,   44,  180,   44,  182,   44,  378,  331,
 /*  1240 */    96,  367,  428,  378,  393,  447,   35,  420,  397,  355,
 /*  1250 */    44,  400,  401,  402,  403,  404,  405,  363,  407,  205,
 /*  1260 */   206,  324,  368,  412,  370,  414,  182,   44,   44,  418,
 /*  1270 */   419,  217,  218,  219,  220,  221,  222,  223,   97,   97,
 /*  1280 */    97,   70,  246,   97,    0,  324,   97,  393,   97,   13,
 /*  1290 */    97,  397,  355,   44,  400,  401,  402,  403,  404,  405,
 /*  1300 */   363,  407,  431,   97,   44,  368,  412,  370,  414,  395,
 /*  1310 */    48,   35,  418,  419,   13,  394,  355,   44,   44,   22,
 /*  1320 */    97,   97,  387,  178,  363,   42,  375,   20,  378,  368,
 /*  1330 */   393,  370,   35,   49,  397,   37,   35,  400,  401,  402,
 /*  1340 */   403,  404,  405,  324,  407,  375,   97,  160,  373,  412,
 /*  1350 */    20,  414,  332,  332,  393,  418,  419,   97,  397,  375,
 /*  1360 */    94,  400,  401,  402,  403,  404,  405,   70,  407,  373,
 /*  1370 */    97,   97,  373,  340,  355,  414,  332,  332,  332,  418,
 /*  1380 */   419,   20,  363,  326,  326,   20,  324,  368,  391,  370,
 /*  1390 */   338,  338,  370,   20,  333,   20,  386,   99,  338,  101,
 /*  1400 */   102,  333,  104,  338,  332,  338,  108,  338,  338,   52,
 /*  1410 */   335,  335,  393,  326,  324,  118,  397,  355,  355,  400,
 /*  1420 */   401,  402,  403,  404,  405,  363,  407,  332,  130,  355,
 /*  1430 */   368,  326,  370,  414,  355,  355,  355,  418,  419,  194,
 /*  1440 */   355,  355,  392,  355,  355,  355,  355,  355,  336,  185,
 /*  1450 */   368,  336,  332,  363,  252,  393,  251,  258,  368,  397,
 /*  1460 */   370,  378,  400,  401,  402,  403,  404,  405,  391,  407,
 /*  1470 */   370,  378,  368,  324,  436,  368,  414,  180,  381,  182,
 /*  1480 */   418,  419,  381,  393,  390,  436,  368,  397,  171,  368,
 /*  1490 */   400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
 /*  1500 */   260,  259,  205,  206,  355,  247,  395,  264,  267,  262,
 /*  1510 */   455,  438,  363,  243,  363,   20,  399,  368,  333,  370,
 /*  1520 */   332,  381,  381,  368,  368,  368,  368,  368,  336,  368,
 /*  1530 */   336,  324,  165,  434,  436,  439,  433,  435,  363,  379,
 /*  1540 */   336,   96,  393,  417,   96,  368,  397,  351,  345,  400,
 /*  1550 */   401,  402,  403,  404,  405,  449,  407,  448,  332,  324,
 /*  1560 */   359,  336,  355,  414,   36,  327,  388,  349,  419,  349,
 /*  1570 */   363,  349,  326,  337,  322,  368,    0,  370,    0,  384,
 /*  1580 */   187,    0,    0,   42,    0,  324,   35,  199,   35,   35,
 /*  1590 */   355,   35,    0,  199,   35,   35,  199,    0,  363,  199,
 /*  1600 */   393,    0,   35,  368,  397,  370,    0,  400,  401,  402,
 /*  1610 */   403,  404,  405,    0,  407,   22,  355,  182,   35,  180,
 /*  1620 */     0,    0,  176,    0,  363,  175,    0,   47,  393,  368,
 /*  1630 */     0,  370,  397,    0,    0,  400,  401,  402,  403,  404,
 /*  1640 */   405,   42,  407,    0,    0,    0,    0,    0,    0,  442,
 /*  1650 */     0,    0,  151,   35,  393,  324,    0,  151,  397,    0,
 /*  1660 */     0,  400,  401,  402,  403,  404,  405,    0,  407,    0,
 /*  1670 */     0,    0,    0,    0,  324,   22,    0,   42,    0,  444,
 /*  1680 */     0,    0,    0,    0,    0,    0,  355,    0,    0,    0,
 /*  1690 */     0,  360,  135,    0,  363,    0,    0,    0,    0,  368,
 /*  1700 */    35,  370,    0,    0,    0,  355,    0,   58,   42,   47,
 /*  1710 */    58,   47,   44,  363,  453,   14,   39,    0,  368,   14,
 /*  1720 */   370,   47,    0,    0,  393,    0,   40,    0,  397,  171,
 /*  1730 */    39,  400,  401,  402,  403,  404,  405,  324,  407,   39,
 /*  1740 */     0,    0,    0,  393,    0,   35,   39,  397,    0,   35,
 /*  1750 */   400,  401,  402,  403,  404,  405,   48,  407,  324,  409,
 /*  1760 */    48,    0,    0,   64,   35,   39,   48,   39,  355,   35,
 /*  1770 */    39,    0,   48,  360,    0,    0,  363,    0,   35,   22,
 /*  1780 */   324,  368,    0,  370,  105,   35,   35,   22,   35,  355,
 /*  1790 */    35,   44,   22,   44,  360,   35,    0,  363,   35,   35,
 /*  1800 */    22,  324,  368,    0,  370,   22,  393,    0,   50,   22,
 /*  1810 */   397,  355,  103,  400,  401,  402,  403,  404,  405,  363,
 /*  1820 */   407,   35,    0,  324,  368,   35,  370,  393,    0,   35,
 /*  1830 */     0,  397,  355,   22,  400,  401,  402,  403,  404,  405,
 /*  1840 */   363,  407,   97,   20,  324,  368,    0,  370,   96,  393,
 /*  1850 */    35,    0,    0,  397,  355,   22,  400,  401,  402,  403,
 /*  1860 */   404,  405,  363,  407,    0,   44,    3,  368,   96,  370,
 /*  1870 */   393,   44,  248,   97,  397,  355,  163,  400,  401,  402,
 /*  1880 */   403,  404,  405,  363,  407,  165,   97,  324,  368,   96,
 /*  1890 */   370,   96,  393,  163,  183,  163,  397,   97,   97,  400,
 /*  1900 */   401,  402,  403,  404,  405,  169,  407,   47,   96,   96,
 /*  1910 */    44,   44,   47,  393,   96,  324,    3,  397,  355,   44,
 /*  1920 */   400,  401,  402,  403,  404,  405,  363,  407,   97,   97,
 /*  1930 */    35,  368,   35,  370,   35,   35,   35,   35,   97,   97,
 /*  1940 */    47,  324,  248,   47,    0,    0,  355,   44,    0,   96,
 /*  1950 */    35,   97,   97,   96,  363,   35,  393,  242,  192,  368,
 /*  1960 */   397,  370,    0,  400,  401,  402,  403,  404,  405,  248,
 /*  1970 */   407,  166,  355,   96,   96,    0,   39,   96,  164,  106,
 /*  1980 */   363,   47,   44,  227,  393,  368,    2,  370,  397,   22,
 /*  1990 */   205,  400,  401,  402,  403,  404,  405,  229,  407,  324,
 /*  2000 */   227,   97,   96,   96,   47,   97,   96,   47,   97,   97,
 /*  2010 */   393,  207,   96,   96,  397,   22,  324,  400,  401,  402,
 /*  2020 */   403,  404,  405,   97,  407,   96,  107,   35,   96,   35,
 /*  2030 */   355,   35,   97,   97,   35,   96,   96,   35,  363,   97,
 /*  2040 */    97,   35,   96,  368,  120,  370,   96,  355,  120,   22,
 /*  2050 */   120,  120,   96,   35,   96,  363,   44,  108,   22,  324,
 /*  2060 */   368,   96,  370,   35,   64,   35,   63,   35,  393,   35,
 /*  2070 */    35,   70,  397,   35,   35,  400,  401,  402,  403,  404,
 /*  2080 */   405,   35,  407,  324,   35,  393,   35,   44,   93,  397,
 /*  2090 */   355,   35,  400,  401,  402,  403,  404,  405,  363,  407,
 /*  2100 */    35,   22,   35,  368,   22,  370,   35,   35,   22,   35,
 /*  2110 */    70,   35,   35,   35,  355,   35,   35,    0,   35,   35,
 /*  2120 */     0,    0,  363,   48,   39,   35,  324,  368,  393,  370,
 /*  2130 */    39,   39,  397,   35,    0,  400,  401,  402,  403,  404,
 /*  2140 */   405,   35,  407,  324,   48,   48,   39,   48,    0,   35,
 /*  2150 */    35,    0,  393,   22,   21,   20,  397,  355,   21,  400,
 /*  2160 */   401,  402,  403,  404,  405,  363,  407,   22,   22,  324,
 /*  2170 */   368,  456,  370,  456,  355,  456,  456,  456,  456,  456,
 /*  2180 */   456,  456,  363,  456,  456,  456,  324,  368,  456,  370,
 /*  2190 */   456,  456,  456,  456,  456,  393,  456,  456,  456,  397,
 /*  2200 */   355,  456,  400,  401,  402,  403,  404,  405,  363,  407,
 /*  2210 */   456,  456,  393,  368,  456,  370,  397,  355,  456,  400,
 /*  2220 */   401,  402,  403,  404,  405,  363,  407,  456,  456,  324,
 /*  2230 */   368,  456,  370,  456,  456,  456,  456,  456,  393,  456,
 /*  2240 */   456,  456,  397,  456,  456,  400,  401,  402,  403,  404,
 /*  2250 */   405,  324,  407,  456,  456,  393,  456,  456,  456,  397,
 /*  2260 */   355,  456,  400,  401,  402,  403,  404,  405,  363,  407,
 /*  2270 */   456,  456,  456,  368,  456,  370,  456,  456,  456,  456,
 /*  2280 */   456,  456,  355,  456,  456,  456,  456,  456,  456,  456,
 /*  2290 */   363,  456,  456,  456,  456,  368,  456,  370,  393,  456,
 /*  2300 */   456,  456,  397,  456,  456,  400,  401,  402,  403,  404,
 /*  2310 */   405,  456,  407,  324,  456,  456,  456,  456,  456,  456,
 /*  2320 */   393,  456,  456,  456,  397,  456,  456,  400,  401,  402,
 /*  2330 */   403,  404,  405,  456,  407,  324,  456,  456,  456,  456,
 /*  2340 */   456,  456,  456,  456,  355,  456,  456,  456,  456,  456,
 /*  2350 */   456,  456,  363,  456,  456,  456,  456,  368,  456,  370,
 /*  2360 */   456,  456,  456,  456,  456,  456,  355,  456,  456,  456,
 /*  2370 */   456,  456,  456,  456,  363,  456,  456,  456,  456,  368,
 /*  2380 */   456,  370,  393,  456,  456,  456,  397,  456,  456,  400,
 /*  2390 */   401,  402,  403,  404,  405,  456,  407,  324,  456,  456,
 /*  2400 */   456,  456,  456,  456,  393,  456,  456,  456,  397,  456,
 /*  2410 */   456,  400,  401,  402,  403,  404,  405,  324,  407,  456,
 /*  2420 */   456,  456,  456,  456,  456,  456,  456,  456,  355,  456,
 /*  2430 */   456,  456,  456,  456,  456,  456,  363,  456,  456,  456,
 /*  2440 */   456,  368,  456,  370,  456,  456,  456,  456,  355,  456,
 /*  2450 */   456,  456,  456,  456,  456,  456,  363,  456,  456,  456,
 /*  2460 */   324,  368,  456,  370,  456,  456,  393,  456,  456,  456,
 /*  2470 */   397,  456,  456,  400,  401,  402,  403,  404,  405,  456,
 /*  2480 */   407,  456,  456,  456,  456,  456,  393,  456,  456,  456,
 /*  2490 */   397,  355,  456,  400,  401,  402,  403,  404,  405,  363,
 /*  2500 */   407,  456,  456,  456,  368,  456,  370,  456,  456,  456,
 /*  2510 */   456,  456,  456,  456,  456,  456,  456,  456,  456,  456,
 /*  2520 */   456,  456,  456,  456,  456,  456,  456,  456,  456,  393,
 /*  2530 */   456,  456,  456,  397,  456,  456,  400,  401,  402,  403,
 /*  2540 */   404,  405,  456,  407,
};
#define YY_SHIFT_COUNT    (706)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2151)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   925,    0,   71,    0,  288,  288,  288,  288,  288,  288,
 /*    10 */   288,  288,  288,  359,  574,  574,  645,  574,  574,  574,
 /*    20 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    30 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    40 */   574,  574,  574,  574,  574,  574,   61,  315,  211,  516,
 /*    50 */    62,  356,  399,  356,  211,  211, 1054, 1054,  356, 1054,
 /*    60 */  1054,  104,  356,   12,   12,  512,  512,  158,   31,  187,
 /*    70 */   187,   12,   12,   12,   12,   12,   12,   12,   12,   12,
 /*    80 */    12,   76,   12,   12,  168,   12,  442,   12,   12,  536,
 /*    90 */    12,   12,  536,   12,  536,  536,  536,   12,  498,  783,
 /*   100 */    34,   34,  162,  502, 1297, 1297, 1297, 1297, 1297, 1297,
 /*   110 */  1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297, 1297,
 /*   120 */  1297, 1297, 1297, 1298,  968,  158,   31,  661,  402,  217,
 /*   130 */   217,  217,  668,  312,  312,  402,  572,  572,  572,  508,
 /*   140 */   442,    3,    3,  393,  536,  536,  569,  569,  508,  576,
 /*   150 */   215,  215,  215,  215,  215,  215,  215,  571,  655,  522,
 /*   160 */   451,  867,   59,  327,   95,  591,  712,  573,  726,  479,
 /*   170 */   694,  733,  214,  964,  936,  214, 1059,  244,  864, 1036,
 /*   180 */  1262, 1145, 1283, 1307, 1283, 1187, 1330, 1330, 1283, 1187,
 /*   190 */  1187, 1266, 1330, 1330, 1330, 1361, 1361, 1365,   76,  442,
 /*   200 */    76, 1373, 1375,   76, 1373,   76,   76,   76, 1330,   76,
 /*   210 */  1357, 1357, 1361,  536,  536,  536,  536,  536,  536,  536,
 /*   220 */   536,  536,  536,  536, 1330, 1361,  569, 1245, 1365,  498,
 /*   230 */  1264,  442,  498, 1330, 1307, 1307,  569, 1202, 1205,  569,
 /*   240 */  1202, 1205,  569,  569,  536, 1199, 1317, 1202, 1240, 1242,
 /*   250 */  1258, 1036, 1241, 1243, 1247, 1270,  572, 1495, 1330, 1373,
 /*   260 */   498, 1205,  569,  569,  569,  569,  569, 1205,  569, 1367,
 /*   270 */   498,  508,  498,  572, 1445, 1448,  569,  576, 1330,  498,
 /*   280 */  1528, 1361, 2544, 2544, 2544, 2544, 2544, 2544, 2544,  826,
 /*   290 */    92,  742,  587,  418,   15,  735,  374,  832,  400,  941,
 /*   300 */   941,  544,  941,  941,  941,  941,  941,  941,  941,  987,
 /*   310 */   314,   51,  410,   73,   73,  167,  666,  180,   19,  292,
 /*   320 */   121,   99,  406,  121,  121,  121,  929,  829, 1071, 1066,
 /*   330 */   989, 1007,  933,  945, 1064, 1113, 1146, 1154, 1190,  986,
 /*   340 */  1134, 1181, 1078,  907,  323,  260, 1182, 1183, 1186, 1189,
 /*   350 */  1191,  981, 1193, 1040, 1084,   58, 1206, 1144, 1223, 1224,
 /*   360 */  1249, 1260, 1273, 1274, 1051, 1276, 1301, 1211, 1284, 1576,
 /*   370 */  1578, 1393, 1581, 1582, 1541, 1584, 1551, 1388, 1553, 1554,
 /*   380 */  1556, 1394, 1592, 1559, 1560, 1397, 1597, 1400, 1601, 1567,
 /*   390 */  1606, 1593, 1613, 1583, 1435, 1439, 1620, 1621, 1446, 1450,
 /*   400 */  1623, 1626, 1580, 1630, 1633, 1634, 1599, 1643, 1644, 1645,
 /*   410 */  1646, 1647, 1648, 1650, 1651, 1501, 1618, 1656, 1506, 1659,
 /*   420 */  1660, 1667, 1669, 1670, 1671, 1672, 1673, 1680, 1681, 1682,
 /*   430 */  1683, 1684, 1685, 1687, 1635, 1678, 1688, 1689, 1690, 1695,
 /*   440 */  1653, 1676, 1696, 1697, 1557, 1693, 1698, 1665, 1702, 1649,
 /*   450 */  1703, 1652, 1704, 1706, 1666, 1677, 1668, 1662, 1701, 1664,
 /*   460 */  1705, 1674, 1717, 1686, 1691, 1722, 1723, 1725, 1700, 1558,
 /*   470 */  1727, 1740, 1741, 1699, 1742, 1744, 1710, 1708, 1707, 1748,
 /*   480 */  1714, 1712, 1726, 1761, 1729, 1718, 1728, 1762, 1734, 1724,
 /*   490 */  1731, 1771, 1774, 1775, 1777, 1679, 1709, 1743, 1757, 1782,
 /*   500 */  1750, 1751, 1765, 1753, 1755, 1747, 1749, 1760, 1763, 1770,
 /*   510 */  1764, 1796, 1778, 1803, 1783, 1758, 1807, 1787, 1786, 1822,
 /*   520 */  1790, 1828, 1794, 1830, 1811, 1823, 1745, 1752, 1846, 1713,
 /*   530 */  1815, 1851, 1711, 1833, 1730, 1720, 1852, 1864, 1732, 1736,
 /*   540 */  1863, 1821, 1624, 1772, 1776, 1793, 1789, 1827, 1800, 1795,
 /*   550 */  1812, 1813, 1801, 1866, 1860, 1865, 1818, 1867, 1694, 1831,
 /*   560 */  1832, 1913, 1875, 1721, 1895, 1897, 1899, 1900, 1901, 1902,
 /*   570 */  1841, 1842, 1893, 1715, 1903, 1896, 1944, 1945, 1948, 1853,
 /*   580 */  1854, 1855, 1857, 1915, 1920, 1766, 1962, 1877, 1805, 1878,
 /*   590 */  1975, 1937, 1814, 1881, 1873, 1662, 1934, 1938, 1756, 1768,
 /*   600 */  1773, 1984, 1967, 1785, 1906, 1904, 1907, 1908, 1910, 1911,
 /*   610 */  1957, 1916, 1917, 1960, 1912, 1993, 1804, 1929, 1919, 1926,
 /*   620 */  1992, 1994, 1932, 1935, 1996, 1939, 1936, 1999, 1940, 1942,
 /*   630 */  2002, 1946, 1943, 2006, 1950, 1924, 1928, 1930, 1931, 2027,
 /*   640 */  1949, 1956, 1958, 2018, 1965, 2012, 2012, 2036, 2000, 2003,
 /*   650 */  2028, 2030, 2032, 2034, 2035, 2038, 2039, 2046, 2049, 2051,
 /*   660 */  2001, 1995, 2043, 2056, 2065, 2079, 2067, 2082, 2071, 2072,
 /*   670 */  2074, 2040, 1747, 2076, 1749, 2077, 2078, 2080, 2081, 2086,
 /*   680 */  2083, 2117, 2084, 2075, 2085, 2120, 2090, 2096, 2091, 2121,
 /*   690 */  2098, 2097, 2092, 2134, 2106, 2099, 2107, 2148, 2114, 2115,
 /*   700 */  2151, 2131, 2133, 2145, 2146, 2137, 2135,
};
#define YY_REDUCE_COUNT (288)
#define YY_REDUCE_MIN   (-425)
#define YY_REDUCE_MAX   (2136)
static const short yy_reduce_ofst[] = {
 /*     0 */   -76, -288,  286,  597,  650,  737,  780,  851,  894,  937,
 /*    10 */   961, 1019, 1062, 1090,   -2,   83, 1149, 1207, 1235, 1261,
 /*    20 */  1331, 1350, 1413, 1434, 1456, 1477, 1499, 1520, 1563, 1591,
 /*    30 */  1617, 1675, 1692, 1735, 1759, 1802, 1819, 1845, 1862, 1905,
 /*    40 */  1927, 1989, 2011, 2073, 2093, 2136, -253, -196,  290, -385,
 /*    50 */  -374, -323,  584,  778,  395,  659, -212,  764,   28,  408,
 /*    60 */   681, -425, -352,   72,  270, -324, -313, -339, -215,   23,
 /*    70 */    64,  267,  285,  331,  613,  615,  626,  649,  695,  700,
 /*    80 */   728,  298,  660,  748,   22,  790, -326,  833,  842, -345,
 /*    90 */   854,  857, -260,  869,  287, -190,  354,  710,    7, -189,
 /*   100 */  -407, -407, -305, -233, -125,  -66,  151,  193,  194,  221,
 /*   110 */   294,  340,  357,  407,  413,  484,  504,  506,  518,  519,
 /*   120 */   596,  651,  656,  -56, -257,  283, -301, -185,  -38, -257,
 /*   130 */    11,  412,  111,  401,  533,   18, -172,  234,  446,  411,
 /*   140 */    78,  586,  595,  425, -291,  468,  520,  628,  680,  727,
 /*   150 */   320,  328,  363,  493,  652,  684,  715,  321,  673,  765,
 /*   160 */   731,  698,  670,  825,  756,  840,  840,  868,  860,  908,
 /*   170 */   874,  865,  814,  814,  798,  814,  827,  871,  840,  914,
 /*   180 */   921,  935,  951,  950,  970,  975, 1020, 1021,  984,  996,
 /*   190 */   999, 1033, 1044, 1045, 1046, 1057, 1058,  997, 1052, 1022,
 /*   200 */  1053, 1061, 1010, 1060, 1068, 1065, 1067, 1069, 1072, 1070,
 /*   210 */  1075, 1076, 1087, 1063, 1074, 1079, 1080, 1081, 1085, 1086,
 /*   220 */  1088, 1089, 1091, 1092, 1095, 1105, 1082, 1050, 1077, 1112,
 /*   230 */  1094, 1100, 1115, 1120, 1083, 1093, 1104, 1038, 1097, 1107,
 /*   240 */  1049, 1101, 1118, 1121,  840, 1096, 1073, 1098, 1102, 1099,
 /*   250 */  1103, 1111, 1055, 1106, 1109,  814, 1151, 1117, 1188, 1185,
 /*   260 */  1192, 1140, 1155, 1156, 1157, 1158, 1159, 1141, 1161, 1160,
 /*   270 */  1194, 1196, 1204, 1175, 1126, 1201, 1177, 1203, 1226, 1225,
 /*   280 */  1238, 1246, 1178, 1195, 1218, 1220, 1222, 1236, 1252,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    10 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    20 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    30 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    40 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    50 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    60 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1843, 1587, 1587,
 /*    70 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    80 */  1587, 1665, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*    90 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1663, 1836,
 /*   100 */  2032, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   110 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   120 */  1587, 1587, 1587, 1587, 2044, 1587, 1587, 1665, 1587, 2044,
 /*   130 */  2044, 2044, 1663, 2004, 2004, 1587, 1587, 1587, 1587, 1774,
 /*   140 */  1587, 1885, 1885, 1587, 1587, 1587, 1587, 1587, 1774, 1587,
 /*   150 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1879, 1587, 1587,
 /*   160 */  2069, 2122, 1587, 1587, 2072, 1587, 1587, 1587, 1848, 1587,
 /*   170 */  1727, 2059, 2036, 2050, 2106, 2037, 2034, 2053, 1587, 2063,
 /*   180 */  1587, 1872, 1841, 1587, 1841, 1838, 1587, 1587, 1841, 1838,
 /*   190 */  1838, 1718, 1587, 1587, 1587, 1587, 1587, 1587, 1665, 1587,
 /*   200 */  1665, 1587, 1587, 1665, 1587, 1665, 1665, 1665, 1587, 1665,
 /*   210 */  1644, 1644, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   220 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1892, 1587, 1663,
 /*   230 */  1881, 1587, 1663, 1587, 1587, 1587, 1587, 2079, 2077, 1587,
 /*   240 */  2079, 2077, 1587, 1587, 1587, 2091, 2087, 2079, 2095, 2093,
 /*   250 */  2065, 2063, 2125, 2112, 2108, 2050, 1587, 1587, 1587, 1587,
 /*   260 */  1663, 2077, 1587, 1587, 1587, 1587, 1587, 2077, 1587, 1587,
 /*   270 */  1663, 1587, 1663, 1587, 1587, 1743, 1587, 1587, 1587, 1663,
 /*   280 */  1619, 1587, 1874, 1885, 1777, 1777, 1777, 1666, 1592, 1587,
 /*   290 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 2090,
 /*   300 */  2089, 1587, 1960, 1587, 2008, 2007, 2006, 1997, 1959, 1587,
 /*   310 */  1739, 1587, 1587, 1958, 1957, 1587, 1587, 1587, 1587, 1587,
 /*   320 */  1951, 1587, 1587, 1952, 1950, 1949, 1587, 1587, 1587, 1587,
 /*   330 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   340 */  1587, 1587, 1587, 2109, 2113, 1587, 1587, 1587, 1587, 1587,
 /*   350 */  1587, 2033, 1587, 1587, 1587, 1587, 1587, 1934, 1587, 1587,
 /*   360 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   370 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   380 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   390 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   400 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   410 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   420 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   430 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   440 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   450 */  1587, 1587, 1587, 1587, 1587, 1587, 1624, 1939, 1587, 1587,
 /*   460 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   470 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   480 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   490 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   500 */  1587, 1587, 1587, 1587, 1587, 1705, 1704, 1587, 1587, 1587,
 /*   510 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   520 */  1587, 1587, 1587, 1587, 1587, 1587, 1942, 1587, 1587, 1587,
 /*   530 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   540 */  2105, 2066, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   550 */  1587, 1587, 1587, 1587, 1587, 1934, 1587, 2088, 1587, 1587,
 /*   560 */  2103, 1587, 2107, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   570 */  2043, 2039, 1587, 1587, 2035, 1587, 1587, 1587, 1587, 1587,
 /*   580 */  1587, 1587, 1587, 1587, 1587, 1587, 1889, 1587, 1587, 1587,
 /*   590 */  1587, 1587, 1587, 1587, 1587, 1933, 1587, 1994, 1587, 1587,
 /*   600 */  1587, 2028, 1587, 1587, 1979, 1587, 1587, 1587, 1587, 1587,
 /*   610 */  1587, 1587, 1587, 1587, 1942, 1587, 1945, 1587, 1587, 1587,
 /*   620 */  1587, 1587, 1771, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   630 */  1587, 1587, 1587, 1587, 1587, 1756, 1754, 1753, 1752, 1587,
 /*   640 */  1749, 1587, 1587, 1587, 1587, 1780, 1779, 1587, 1587, 1587,
 /*   650 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   660 */  1587, 1587, 1685, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   670 */  1587, 1587, 1676, 1587, 1675, 1587, 1587, 1587, 1587, 1587,
 /*   680 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   690 */  1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587, 1587,
 /*   700 */  1587, 1587, 1587, 1587, 1587, 1587, 1587,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  268,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  268,  /*      AFTER => ABORT */
  268,  /*     ATTACH => ABORT */
  268,  /*     BEFORE => ABORT */
  268,  /*      BEGIN => ABORT */
  268,  /*     BITAND => ABORT */
  268,  /*     BITNOT => ABORT */
  268,  /*      BITOR => ABORT */
  268,  /*     BLOCKS => ABORT */
  268,  /*     CHANGE => ABORT */
  268,  /*      COMMA => ABORT */
  268,  /*    COMPACT => ABORT */
  268,  /*     CONCAT => ABORT */
  268,  /*   CONFLICT => ABORT */
  268,  /*       COPY => ABORT */
  268,  /*   DEFERRED => ABORT */
  268,  /* DELIMITERS => ABORT */
  268,  /*     DETACH => ABORT */
  268,  /*     DIVIDE => ABORT */
  268,  /*        DOT => ABORT */
  268,  /*       EACH => ABORT */
  268,  /*       FAIL => ABORT */
  268,  /*       FILE => ABORT */
  268,  /*        FOR => ABORT */
  268,  /*       GLOB => ABORT */
  268,  /*         ID => ABORT */
  268,  /*  IMMEDIATE => ABORT */
  268,  /*     IMPORT => ABORT */
  268,  /*  INITIALLY => ABORT */
  268,  /*    INSTEAD => ABORT */
  268,  /*     ISNULL => ABORT */
  268,  /*        KEY => ABORT */
  268,  /*    MODULES => ABORT */
  268,  /*  NK_BITNOT => ABORT */
  268,  /*    NK_SEMI => ABORT */
  268,  /*    NOTNULL => ABORT */
  268,  /*         OF => ABORT */
  268,  /*       PLUS => ABORT */
  268,  /*  PRIVILEGE => ABORT */
  268,  /*      RAISE => ABORT */
  268,  /*    REPLACE => ABORT */
  268,  /*   RESTRICT => ABORT */
  268,  /*        ROW => ABORT */
  268,  /*       SEMI => ABORT */
  268,  /*       STAR => ABORT */
  268,  /*  STATEMENT => ABORT */
  268,  /*     STRING => ABORT */
  268,  /*      TIMES => ABORT */
  268,  /*     UPDATE => ABORT */
  268,  /*     VALUES => ABORT */
  268,  /*   VARIABLE => ABORT */
  268,  /*       VIEW => ABORT */
  268,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "STRICT",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "TOPIC",
  /*  168 */ "WITH",
  /*  169 */ "META",
  /*  170 */ "CONSUMER",
  /*  171 */ "GROUP",
  /*  172 */ "DESC",
  /*  173 */ "DESCRIBE",
  /*  174 */ "RESET",
  /*  175 */ "QUERY",
  /*  176 */ "CACHE",
  /*  177 */ "EXPLAIN",
  /*  178 */ "ANALYZE",
  /*  179 */ "VERBOSE",
  /*  180 */ "NK_BOOL",
  /*  181 */ "RATIO",
  /*  182 */ "NK_FLOAT",
  /*  183 */ "OUTPUTTYPE",
  /*  184 */ "AGGREGATE",
  /*  185 */ "BUFSIZE",
  /*  186 */ "STREAM",
  /*  187 */ "INTO",
  /*  188 */ "TRIGGER",
  /*  189 */ "AT_ONCE",
  /*  190 */ "WINDOW_CLOSE",
  /*  191 */ "IGNORE",
  /*  192 */ "EXPIRED",
  /*  193 */ "FILL_HISTORY",
  /*  194 */ "SUBTABLE",
  /*  195 */ "KILL",
  /*  196 */ "CONNECTION",
  /*  197 */ "TRANSACTION",
  /*  198 */ "BALANCE",
  /*  199 */ "VGROUP",
  /*  200 */ "MERGE",
  /*  201 */ "REDISTRIBUTE",
  /*  202 */ "SPLIT",
  /*  203 */ "DELETE",
  /*  204 */ "INSERT",
  /*  205 */ "NULL",
  /*  206 */ "NK_QUESTION",
  /*  207 */ "NK_ARROW",
  /*  208 */ "ROWTS",
  /*  209 */ "QSTART",
  /*  210 */ "QEND",
  /*  211 */ "QDURATION",
  /*  212 */ "WSTART",
  /*  213 */ "WEND",
  /*  214 */ "WDURATION",
  /*  215 */ "IROWTS",
  /*  216 */ "CAST",
  /*  217 */ "NOW",
  /*  218 */ "TODAY",
  /*  219 */ "TIMEZONE",
  /*  220 */ "CLIENT_VERSION",
  /*  221 */ "SERVER_VERSION",
  /*  222 */ "SERVER_STATUS",
  /*  223 */ "CURRENT_USER",
  /*  224 */ "COUNT",
  /*  225 */ "LAST_ROW",
  /*  226 */ "CASE",
  /*  227 */ "END",
  /*  228 */ "WHEN",
  /*  229 */ "THEN",
  /*  230 */ "ELSE",
  /*  231 */ "BETWEEN",
  /*  232 */ "IS",
  /*  233 */ "NK_LT",
  /*  234 */ "NK_GT",
  /*  235 */ "NK_LE",
  /*  236 */ "NK_GE",
  /*  237 */ "NK_NE",
  /*  238 */ "MATCH",
  /*  239 */ "NMATCH",
  /*  240 */ "CONTAINS",
  /*  241 */ "IN",
  /*  242 */ "JOIN",
  /*  243 */ "INNER",
  /*  244 */ "SELECT",
  /*  245 */ "DISTINCT",
  /*  246 */ "WHERE",
  /*  247 */ "PARTITION",
  /*  248 */ "BY",
  /*  249 */ "SESSION",
  /*  250 */ "STATE_WINDOW",
  /*  251 */ "SLIDING",
  /*  252 */ "FILL",
  /*  253 */ "VALUE",
  /*  254 */ "NONE",
  /*  255 */ "PREV",
  /*  256 */ "LINEAR",
  /*  257 */ "NEXT",
  /*  258 */ "HAVING",
  /*  259 */ "RANGE",
  /*  260 */ "EVERY",
  /*  261 */ "ORDER",
  /*  262 */ "SLIMIT",
  /*  263 */ "SOFFSET",
  /*  264 */ "LIMIT",
  /*  265 */ "OFFSET",
  /*  266 */ "ASC",
  /*  267 */ "NULLS",
  /*  268 */ "ABORT",
  /*  269 */ "AFTER",
  /*  270 */ "ATTACH",
  /*  271 */ "BEFORE",
  /*  272 */ "BEGIN",
  /*  273 */ "BITAND",
  /*  274 */ "BITNOT",
  /*  275 */ "BITOR",
  /*  276 */ "BLOCKS",
  /*  277 */ "CHANGE",
  /*  278 */ "COMMA",
  /*  279 */ "COMPACT",
  /*  280 */ "CONCAT",
  /*  281 */ "CONFLICT",
  /*  282 */ "COPY",
  /*  283 */ "DEFERRED",
  /*  284 */ "DELIMITERS",
  /*  285 */ "DETACH",
  /*  286 */ "DIVIDE",
  /*  287 */ "DOT",
  /*  288 */ "EACH",
  /*  289 */ "FAIL",
  /*  290 */ "FILE",
  /*  291 */ "FOR",
  /*  292 */ "GLOB",
  /*  293 */ "ID",
  /*  294 */ "IMMEDIATE",
  /*  295 */ "IMPORT",
  /*  296 */ "INITIALLY",
  /*  297 */ "INSTEAD",
  /*  298 */ "ISNULL",
  /*  299 */ "KEY",
  /*  300 */ "MODULES",
  /*  301 */ "NK_BITNOT",
  /*  302 */ "NK_SEMI",
  /*  303 */ "NOTNULL",
  /*  304 */ "OF",
  /*  305 */ "PLUS",
  /*  306 */ "PRIVILEGE",
  /*  307 */ "RAISE",
  /*  308 */ "REPLACE",
  /*  309 */ "RESTRICT",
  /*  310 */ "ROW",
  /*  311 */ "SEMI",
  /*  312 */ "STAR",
  /*  313 */ "STATEMENT",
  /*  314 */ "STRING",
  /*  315 */ "TIMES",
  /*  316 */ "UPDATE",
  /*  317 */ "VALUES",
  /*  318 */ "VARIABLE",
  /*  319 */ "VIEW",
  /*  320 */ "WAL",
  /*  321 */ "cmd",
  /*  322 */ "account_options",
  /*  323 */ "alter_account_options",
  /*  324 */ "literal",
  /*  325 */ "alter_account_option",
  /*  326 */ "user_name",
  /*  327 */ "sysinfo_opt",
  /*  328 */ "privileges",
  /*  329 */ "priv_level",
  /*  330 */ "priv_type_list",
  /*  331 */ "priv_type",
  /*  332 */ "db_name",
  /*  333 */ "topic_name",
  /*  334 */ "dnode_endpoint",
  /*  335 */ "force_opt",
  /*  336 */ "not_exists_opt",
  /*  337 */ "db_options",
  /*  338 */ "exists_opt",
  /*  339 */ "alter_db_options",
  /*  340 */ "speed_opt",
  /*  341 */ "integer_list",
  /*  342 */ "variable_list",
  /*  343 */ "retention_list",
  /*  344 */ "alter_db_option",
  /*  345 */ "retention",
  /*  346 */ "full_table_name",
  /*  347 */ "column_def_list",
  /*  348 */ "tags_def_opt",
  /*  349 */ "table_options",
  /*  350 */ "multi_create_clause",
  /*  351 */ "tags_def",
  /*  352 */ "multi_drop_clause",
  /*  353 */ "alter_table_clause",
  /*  354 */ "alter_table_options",
  /*  355 */ "column_name",
  /*  356 */ "type_name",
  /*  357 */ "signed_literal",
  /*  358 */ "create_subtable_clause",
  /*  359 */ "specific_cols_opt",
  /*  360 */ "expression_list",
  /*  361 */ "drop_table_clause",
  /*  362 */ "col_name_list",
  /*  363 */ "table_name",
  /*  364 */ "column_def",
  /*  365 */ "duration_list",
  /*  366 */ "rollup_func_list",
  /*  367 */ "alter_table_option",
  /*  368 */ "duration_literal",
  /*  369 */ "rollup_func_name",
  /*  370 */ "function_name",
  /*  371 */ "col_name",
  /*  372 */ "db_name_cond_opt",
  /*  373 */ "like_pattern_opt",
  /*  374 */ "table_name_cond",
  /*  375 */ "from_db_opt",
  /*  376 */ "tag_list_opt",
  /*  377 */ "tag_item",
  /*  378 */ "column_alias",
  /*  379 */ "index_options",
  /*  380 */ "func_list",
  /*  381 */ "sliding_opt",
  /*  382 */ "sma_stream_opt",
  /*  383 */ "func",
  /*  384 */ "stream_options",
  /*  385 */ "query_or_subquery",
  /*  386 */ "cgroup_name",
  /*  387 */ "analyze_opt",
  /*  388 */ "explain_options",
  /*  389 */ "agg_func_opt",
  /*  390 */ "bufsize_opt",
  /*  391 */ "stream_name",
  /*  392 */ "subtable_opt",
  /*  393 */ "expression",
  /*  394 */ "dnode_list",
  /*  395 */ "where_clause_opt",
  /*  396 */ "signed",
  /*  397 */ "literal_func",
  /*  398 */ "literal_list",
  /*  399 */ "table_alias",
  /*  400 */ "expr_or_subquery",
  /*  401 */ "pseudo_column",
  /*  402 */ "column_reference",
  /*  403 */ "function_expression",
  /*  404 */ "case_when_expression",
  /*  405 */ "star_func",
  /*  406 */ "star_func_para_list",
  /*  407 */ "noarg_func",
  /*  408 */ "other_para_list",
  /*  409 */ "star_func_para",
  /*  410 */ "when_then_list",
  /*  411 */ "case_when_else_opt",
  /*  412 */ "common_expression",
  /*  413 */ "when_then_expr",
  /*  414 */ "predicate",
  /*  415 */ "compare_op",
  /*  416 */ "in_op",
  /*  417 */ "in_predicate_value",
  /*  418 */ "boolean_value_expression",
  /*  419 */ "boolean_primary",
  /*  420 */ "from_clause_opt",
  /*  421 */ "table_reference_list",
  /*  422 */ "table_reference",
  /*  423 */ "table_primary",
  /*  424 */ "joined_table",
  /*  425 */ "alias_opt",
  /*  426 */ "subquery",
  /*  427 */ "parenthesized_joined_table",
  /*  428 */ "join_type",
  /*  429 */ "search_condition",
  /*  430 */ "query_specification",
  /*  431 */ "set_quantifier_opt",
  /*  432 */ "select_list",
  /*  433 */ "partition_by_clause_opt",
  /*  434 */ "range_opt",
  /*  435 */ "every_opt",
  /*  436 */ "fill_opt",
  /*  437 */ "twindow_clause_opt",
  /*  438 */ "group_by_clause_opt",
  /*  439 */ "having_clause_opt",
  /*  440 */ "select_item",
  /*  441 */ "partition_list",
  /*  442 */ "partition_item",
  /*  443 */ "fill_mode",
  /*  444 */ "group_by_list",
  /*  445 */ "query_expression",
  /*  446 */ "query_simple",
  /*  447 */ "order_by_clause_opt",
  /*  448 */ "slimit_clause_opt",
  /*  449 */ "limit_clause_opt",
  /*  450 */ "union_query_expression",
  /*  451 */ "query_simple_or_subquery",
  /*  452 */ "sort_specification_list",
  /*  453 */ "sort_specification",
  /*  454 */ "ordering_specification_opt",
  /*  455 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options STRICT NK_STRING",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= STRICT NK_STRING",
 /* 119 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 120 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 121 */ "integer_list ::= NK_INTEGER",
 /* 122 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 123 */ "variable_list ::= NK_VARIABLE",
 /* 124 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 125 */ "retention_list ::= retention",
 /* 126 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 127 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 128 */ "speed_opt ::=",
 /* 129 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 130 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 131 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 132 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 133 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 134 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 135 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 136 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 137 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 138 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 140 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 142 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 144 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 145 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 146 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 147 */ "multi_create_clause ::= create_subtable_clause",
 /* 148 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 149 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 150 */ "multi_drop_clause ::= drop_table_clause",
 /* 151 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 152 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 153 */ "specific_cols_opt ::=",
 /* 154 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 155 */ "full_table_name ::= table_name",
 /* 156 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 157 */ "column_def_list ::= column_def",
 /* 158 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 159 */ "column_def ::= column_name type_name",
 /* 160 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 161 */ "type_name ::= BOOL",
 /* 162 */ "type_name ::= TINYINT",
 /* 163 */ "type_name ::= SMALLINT",
 /* 164 */ "type_name ::= INT",
 /* 165 */ "type_name ::= INTEGER",
 /* 166 */ "type_name ::= BIGINT",
 /* 167 */ "type_name ::= FLOAT",
 /* 168 */ "type_name ::= DOUBLE",
 /* 169 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TIMESTAMP",
 /* 171 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 172 */ "type_name ::= TINYINT UNSIGNED",
 /* 173 */ "type_name ::= SMALLINT UNSIGNED",
 /* 174 */ "type_name ::= INT UNSIGNED",
 /* 175 */ "type_name ::= BIGINT UNSIGNED",
 /* 176 */ "type_name ::= JSON",
 /* 177 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 178 */ "type_name ::= MEDIUMBLOB",
 /* 179 */ "type_name ::= BLOB",
 /* 180 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 183 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 184 */ "tags_def_opt ::=",
 /* 185 */ "tags_def_opt ::= tags_def",
 /* 186 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 187 */ "table_options ::=",
 /* 188 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 189 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 190 */ "table_options ::= table_options WATERMARK duration_list",
 /* 191 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 192 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 193 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "db_name_cond_opt ::=",
 /* 247 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 248 */ "like_pattern_opt ::=",
 /* 249 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 250 */ "table_name_cond ::= table_name",
 /* 251 */ "from_db_opt ::=",
 /* 252 */ "from_db_opt ::= FROM db_name",
 /* 253 */ "tag_list_opt ::=",
 /* 254 */ "tag_list_opt ::= tag_item",
 /* 255 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 256 */ "tag_item ::= TBNAME",
 /* 257 */ "tag_item ::= QTAGS",
 /* 258 */ "tag_item ::= column_name",
 /* 259 */ "tag_item ::= column_name column_alias",
 /* 260 */ "tag_item ::= column_name AS column_alias",
 /* 261 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 262 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "func_list ::= func",
 /* 266 */ "func_list ::= func_list NK_COMMA func",
 /* 267 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 268 */ "sma_stream_opt ::=",
 /* 269 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 270 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 271 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 272 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 276 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 277 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 278 */ "cmd ::= DESC full_table_name",
 /* 279 */ "cmd ::= DESCRIBE full_table_name",
 /* 280 */ "cmd ::= RESET QUERY CACHE",
 /* 281 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 282 */ "analyze_opt ::=",
 /* 283 */ "analyze_opt ::= ANALYZE",
 /* 284 */ "explain_options ::=",
 /* 285 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 286 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 287 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 288 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 289 */ "agg_func_opt ::=",
 /* 290 */ "agg_func_opt ::= AGGREGATE",
 /* 291 */ "bufsize_opt ::=",
 /* 292 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 293 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 294 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 295 */ "stream_options ::=",
 /* 296 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 297 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 298 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 299 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 300 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 301 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 302 */ "subtable_opt ::=",
 /* 303 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 304 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 305 */ "cmd ::= KILL QUERY NK_STRING",
 /* 306 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 307 */ "cmd ::= BALANCE VGROUP",
 /* 308 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 309 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 310 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 311 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 312 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 313 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 314 */ "cmd ::= query_or_subquery",
 /* 315 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 316 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 317 */ "literal ::= NK_INTEGER",
 /* 318 */ "literal ::= NK_FLOAT",
 /* 319 */ "literal ::= NK_STRING",
 /* 320 */ "literal ::= NK_BOOL",
 /* 321 */ "literal ::= TIMESTAMP NK_STRING",
 /* 322 */ "literal ::= duration_literal",
 /* 323 */ "literal ::= NULL",
 /* 324 */ "literal ::= NK_QUESTION",
 /* 325 */ "duration_literal ::= NK_VARIABLE",
 /* 326 */ "signed ::= NK_INTEGER",
 /* 327 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 328 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 329 */ "signed ::= NK_FLOAT",
 /* 330 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 331 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 332 */ "signed_literal ::= signed",
 /* 333 */ "signed_literal ::= NK_STRING",
 /* 334 */ "signed_literal ::= NK_BOOL",
 /* 335 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 336 */ "signed_literal ::= duration_literal",
 /* 337 */ "signed_literal ::= NULL",
 /* 338 */ "signed_literal ::= literal_func",
 /* 339 */ "signed_literal ::= NK_QUESTION",
 /* 340 */ "literal_list ::= signed_literal",
 /* 341 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 342 */ "db_name ::= NK_ID",
 /* 343 */ "table_name ::= NK_ID",
 /* 344 */ "column_name ::= NK_ID",
 /* 345 */ "function_name ::= NK_ID",
 /* 346 */ "table_alias ::= NK_ID",
 /* 347 */ "column_alias ::= NK_ID",
 /* 348 */ "user_name ::= NK_ID",
 /* 349 */ "topic_name ::= NK_ID",
 /* 350 */ "stream_name ::= NK_ID",
 /* 351 */ "cgroup_name ::= NK_ID",
 /* 352 */ "expr_or_subquery ::= expression",
 /* 353 */ "expression ::= literal",
 /* 354 */ "expression ::= pseudo_column",
 /* 355 */ "expression ::= column_reference",
 /* 356 */ "expression ::= function_expression",
 /* 357 */ "expression ::= case_when_expression",
 /* 358 */ "expression ::= NK_LP expression NK_RP",
 /* 359 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 360 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 361 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 362 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 363 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 366 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 367 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 369 */ "expression_list ::= expr_or_subquery",
 /* 370 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 371 */ "column_reference ::= column_name",
 /* 372 */ "column_reference ::= table_name NK_DOT column_name",
 /* 373 */ "pseudo_column ::= ROWTS",
 /* 374 */ "pseudo_column ::= TBNAME",
 /* 375 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 376 */ "pseudo_column ::= QSTART",
 /* 377 */ "pseudo_column ::= QEND",
 /* 378 */ "pseudo_column ::= QDURATION",
 /* 379 */ "pseudo_column ::= WSTART",
 /* 380 */ "pseudo_column ::= WEND",
 /* 381 */ "pseudo_column ::= WDURATION",
 /* 382 */ "pseudo_column ::= IROWTS",
 /* 383 */ "pseudo_column ::= QTAGS",
 /* 384 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 385 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 386 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 387 */ "function_expression ::= literal_func",
 /* 388 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 389 */ "literal_func ::= NOW",
 /* 390 */ "noarg_func ::= NOW",
 /* 391 */ "noarg_func ::= TODAY",
 /* 392 */ "noarg_func ::= TIMEZONE",
 /* 393 */ "noarg_func ::= DATABASE",
 /* 394 */ "noarg_func ::= CLIENT_VERSION",
 /* 395 */ "noarg_func ::= SERVER_VERSION",
 /* 396 */ "noarg_func ::= SERVER_STATUS",
 /* 397 */ "noarg_func ::= CURRENT_USER",
 /* 398 */ "noarg_func ::= USER",
 /* 399 */ "star_func ::= COUNT",
 /* 400 */ "star_func ::= FIRST",
 /* 401 */ "star_func ::= LAST",
 /* 402 */ "star_func ::= LAST_ROW",
 /* 403 */ "star_func_para_list ::= NK_STAR",
 /* 404 */ "star_func_para_list ::= other_para_list",
 /* 405 */ "other_para_list ::= star_func_para",
 /* 406 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 407 */ "star_func_para ::= expr_or_subquery",
 /* 408 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 409 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 410 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 411 */ "when_then_list ::= when_then_expr",
 /* 412 */ "when_then_list ::= when_then_list when_then_expr",
 /* 413 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 414 */ "case_when_else_opt ::=",
 /* 415 */ "case_when_else_opt ::= ELSE common_expression",
 /* 416 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 417 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 418 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 419 */ "predicate ::= expr_or_subquery IS NULL",
 /* 420 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 421 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 422 */ "compare_op ::= NK_LT",
 /* 423 */ "compare_op ::= NK_GT",
 /* 424 */ "compare_op ::= NK_LE",
 /* 425 */ "compare_op ::= NK_GE",
 /* 426 */ "compare_op ::= NK_NE",
 /* 427 */ "compare_op ::= NK_EQ",
 /* 428 */ "compare_op ::= LIKE",
 /* 429 */ "compare_op ::= NOT LIKE",
 /* 430 */ "compare_op ::= MATCH",
 /* 431 */ "compare_op ::= NMATCH",
 /* 432 */ "compare_op ::= CONTAINS",
 /* 433 */ "in_op ::= IN",
 /* 434 */ "in_op ::= NOT IN",
 /* 435 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 436 */ "boolean_value_expression ::= boolean_primary",
 /* 437 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 438 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 439 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 440 */ "boolean_primary ::= predicate",
 /* 441 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 442 */ "common_expression ::= expr_or_subquery",
 /* 443 */ "common_expression ::= boolean_value_expression",
 /* 444 */ "from_clause_opt ::=",
 /* 445 */ "from_clause_opt ::= FROM table_reference_list",
 /* 446 */ "table_reference_list ::= table_reference",
 /* 447 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 448 */ "table_reference ::= table_primary",
 /* 449 */ "table_reference ::= joined_table",
 /* 450 */ "table_primary ::= table_name alias_opt",
 /* 451 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 452 */ "table_primary ::= subquery alias_opt",
 /* 453 */ "table_primary ::= parenthesized_joined_table",
 /* 454 */ "alias_opt ::=",
 /* 455 */ "alias_opt ::= table_alias",
 /* 456 */ "alias_opt ::= AS table_alias",
 /* 457 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 458 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 459 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 460 */ "join_type ::=",
 /* 461 */ "join_type ::= INNER",
 /* 462 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 463 */ "set_quantifier_opt ::=",
 /* 464 */ "set_quantifier_opt ::= DISTINCT",
 /* 465 */ "set_quantifier_opt ::= ALL",
 /* 466 */ "select_list ::= select_item",
 /* 467 */ "select_list ::= select_list NK_COMMA select_item",
 /* 468 */ "select_item ::= NK_STAR",
 /* 469 */ "select_item ::= common_expression",
 /* 470 */ "select_item ::= common_expression column_alias",
 /* 471 */ "select_item ::= common_expression AS column_alias",
 /* 472 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 473 */ "where_clause_opt ::=",
 /* 474 */ "where_clause_opt ::= WHERE search_condition",
 /* 475 */ "partition_by_clause_opt ::=",
 /* 476 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 477 */ "partition_list ::= partition_item",
 /* 478 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 479 */ "partition_item ::= expr_or_subquery",
 /* 480 */ "partition_item ::= expr_or_subquery column_alias",
 /* 481 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 482 */ "twindow_clause_opt ::=",
 /* 483 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 484 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 485 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 486 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 487 */ "sliding_opt ::=",
 /* 488 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 489 */ "fill_opt ::=",
 /* 490 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 491 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 492 */ "fill_mode ::= NONE",
 /* 493 */ "fill_mode ::= PREV",
 /* 494 */ "fill_mode ::= NULL",
 /* 495 */ "fill_mode ::= LINEAR",
 /* 496 */ "fill_mode ::= NEXT",
 /* 497 */ "group_by_clause_opt ::=",
 /* 498 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 499 */ "group_by_list ::= expr_or_subquery",
 /* 500 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 501 */ "having_clause_opt ::=",
 /* 502 */ "having_clause_opt ::= HAVING search_condition",
 /* 503 */ "range_opt ::=",
 /* 504 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 505 */ "every_opt ::=",
 /* 506 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 507 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 508 */ "query_simple ::= query_specification",
 /* 509 */ "query_simple ::= union_query_expression",
 /* 510 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 511 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 512 */ "query_simple_or_subquery ::= query_simple",
 /* 513 */ "query_simple_or_subquery ::= subquery",
 /* 514 */ "query_or_subquery ::= query_expression",
 /* 515 */ "query_or_subquery ::= subquery",
 /* 516 */ "order_by_clause_opt ::=",
 /* 517 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 518 */ "slimit_clause_opt ::=",
 /* 519 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 520 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 521 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 522 */ "limit_clause_opt ::=",
 /* 523 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 524 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 525 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 526 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 527 */ "subquery ::= NK_LP subquery NK_RP",
 /* 528 */ "search_condition ::= common_expression",
 /* 529 */ "sort_specification_list ::= sort_specification",
 /* 530 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 531 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 532 */ "ordering_specification_opt ::=",
 /* 533 */ "ordering_specification_opt ::= ASC",
 /* 534 */ "ordering_specification_opt ::= DESC",
 /* 535 */ "null_ordering_opt ::=",
 /* 536 */ "null_ordering_opt ::= NULLS FIRST",
 /* 537 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 321: /* cmd */
    case 324: /* literal */
    case 337: /* db_options */
    case 339: /* alter_db_options */
    case 345: /* retention */
    case 346: /* full_table_name */
    case 349: /* table_options */
    case 353: /* alter_table_clause */
    case 354: /* alter_table_options */
    case 357: /* signed_literal */
    case 358: /* create_subtable_clause */
    case 361: /* drop_table_clause */
    case 364: /* column_def */
    case 368: /* duration_literal */
    case 369: /* rollup_func_name */
    case 371: /* col_name */
    case 372: /* db_name_cond_opt */
    case 373: /* like_pattern_opt */
    case 374: /* table_name_cond */
    case 375: /* from_db_opt */
    case 377: /* tag_item */
    case 379: /* index_options */
    case 381: /* sliding_opt */
    case 382: /* sma_stream_opt */
    case 383: /* func */
    case 384: /* stream_options */
    case 385: /* query_or_subquery */
    case 388: /* explain_options */
    case 392: /* subtable_opt */
    case 393: /* expression */
    case 395: /* where_clause_opt */
    case 396: /* signed */
    case 397: /* literal_func */
    case 400: /* expr_or_subquery */
    case 401: /* pseudo_column */
    case 402: /* column_reference */
    case 403: /* function_expression */
    case 404: /* case_when_expression */
    case 409: /* star_func_para */
    case 411: /* case_when_else_opt */
    case 412: /* common_expression */
    case 413: /* when_then_expr */
    case 414: /* predicate */
    case 417: /* in_predicate_value */
    case 418: /* boolean_value_expression */
    case 419: /* boolean_primary */
    case 420: /* from_clause_opt */
    case 421: /* table_reference_list */
    case 422: /* table_reference */
    case 423: /* table_primary */
    case 424: /* joined_table */
    case 426: /* subquery */
    case 427: /* parenthesized_joined_table */
    case 429: /* search_condition */
    case 430: /* query_specification */
    case 434: /* range_opt */
    case 435: /* every_opt */
    case 436: /* fill_opt */
    case 437: /* twindow_clause_opt */
    case 439: /* having_clause_opt */
    case 440: /* select_item */
    case 442: /* partition_item */
    case 445: /* query_expression */
    case 446: /* query_simple */
    case 448: /* slimit_clause_opt */
    case 449: /* limit_clause_opt */
    case 450: /* union_query_expression */
    case 451: /* query_simple_or_subquery */
    case 453: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy104)); 
}
      break;
    case 322: /* account_options */
    case 323: /* alter_account_options */
    case 325: /* alter_account_option */
    case 340: /* speed_opt */
    case 390: /* bufsize_opt */
{
 
}
      break;
    case 326: /* user_name */
    case 329: /* priv_level */
    case 332: /* db_name */
    case 333: /* topic_name */
    case 334: /* dnode_endpoint */
    case 355: /* column_name */
    case 363: /* table_name */
    case 370: /* function_name */
    case 378: /* column_alias */
    case 386: /* cgroup_name */
    case 391: /* stream_name */
    case 399: /* table_alias */
    case 405: /* star_func */
    case 407: /* noarg_func */
    case 425: /* alias_opt */
{
 
}
      break;
    case 327: /* sysinfo_opt */
{
 
}
      break;
    case 328: /* privileges */
    case 330: /* priv_type_list */
    case 331: /* priv_type */
{
 
}
      break;
    case 335: /* force_opt */
    case 336: /* not_exists_opt */
    case 338: /* exists_opt */
    case 387: /* analyze_opt */
    case 389: /* agg_func_opt */
    case 431: /* set_quantifier_opt */
{
 
}
      break;
    case 341: /* integer_list */
    case 342: /* variable_list */
    case 343: /* retention_list */
    case 347: /* column_def_list */
    case 348: /* tags_def_opt */
    case 350: /* multi_create_clause */
    case 351: /* tags_def */
    case 352: /* multi_drop_clause */
    case 359: /* specific_cols_opt */
    case 360: /* expression_list */
    case 362: /* col_name_list */
    case 365: /* duration_list */
    case 366: /* rollup_func_list */
    case 376: /* tag_list_opt */
    case 380: /* func_list */
    case 394: /* dnode_list */
    case 398: /* literal_list */
    case 406: /* star_func_para_list */
    case 408: /* other_para_list */
    case 410: /* when_then_list */
    case 432: /* select_list */
    case 433: /* partition_by_clause_opt */
    case 438: /* group_by_clause_opt */
    case 441: /* partition_list */
    case 444: /* group_by_list */
    case 447: /* order_by_clause_opt */
    case 452: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy616)); 
}
      break;
    case 344: /* alter_db_option */
    case 367: /* alter_table_option */
{
 
}
      break;
    case 356: /* type_name */
{
 
}
      break;
    case 415: /* compare_op */
    case 416: /* in_op */
{
 
}
      break;
    case 428: /* join_type */
{
 
}
      break;
    case 443: /* fill_mode */
{
 
}
      break;
    case 454: /* ordering_specification_opt */
{
 
}
      break;
    case 455: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  321,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  321,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  322,    0 }, /* (2) account_options ::= */
  {  322,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  322,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  322,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  322,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  322,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  322,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  322,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  322,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  322,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  323,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  323,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  325,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  325,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  325,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  325,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  325,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  325,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  325,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  325,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  325,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  325,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  321,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  321,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  321,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  321,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  321,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  327,    0 }, /* (29) sysinfo_opt ::= */
  {  327,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  321,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  321,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  328,   -1 }, /* (33) privileges ::= ALL */
  {  328,   -1 }, /* (34) privileges ::= priv_type_list */
  {  328,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  330,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  330,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  331,   -1 }, /* (38) priv_type ::= READ */
  {  331,   -1 }, /* (39) priv_type ::= WRITE */
  {  329,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  329,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  329,   -1 }, /* (42) priv_level ::= topic_name */
  {  321,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  321,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  321,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  321,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  321,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  321,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  321,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  321,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  334,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  334,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  334,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  335,    0 }, /* (54) force_opt ::= */
  {  335,   -1 }, /* (55) force_opt ::= FORCE */
  {  321,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  321,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  321,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  321,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  321,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  321,   -2 }, /* (68) cmd ::= USE db_name */
  {  321,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  321,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  321,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  336,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  336,    0 }, /* (73) not_exists_opt ::= */
  {  338,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  338,    0 }, /* (75) exists_opt ::= */
  {  337,    0 }, /* (76) db_options ::= */
  {  337,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  337,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  337,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  337,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  337,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  337,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  337,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  337,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  337,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  337,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  337,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  337,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  337,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  337,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  337,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  337,   -3 }, /* (92) db_options ::= db_options STRICT NK_STRING */
  {  337,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  337,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  337,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  337,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  337,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  337,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  337,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  337,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  337,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  337,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  337,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  337,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  337,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  337,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  337,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  339,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  339,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  344,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  344,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  344,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  344,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  344,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  344,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  344,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  344,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  344,   -2 }, /* (118) alter_db_option ::= STRICT NK_STRING */
  {  344,   -2 }, /* (119) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  344,   -2 }, /* (120) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  341,   -1 }, /* (121) integer_list ::= NK_INTEGER */
  {  341,   -3 }, /* (122) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  342,   -1 }, /* (123) variable_list ::= NK_VARIABLE */
  {  342,   -3 }, /* (124) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  343,   -1 }, /* (125) retention_list ::= retention */
  {  343,   -3 }, /* (126) retention_list ::= retention_list NK_COMMA retention */
  {  345,   -3 }, /* (127) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  340,    0 }, /* (128) speed_opt ::= */
  {  340,   -2 }, /* (129) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  321,   -9 }, /* (130) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  321,   -3 }, /* (131) cmd ::= CREATE TABLE multi_create_clause */
  {  321,   -9 }, /* (132) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  321,   -3 }, /* (133) cmd ::= DROP TABLE multi_drop_clause */
  {  321,   -4 }, /* (134) cmd ::= DROP STABLE exists_opt full_table_name */
  {  321,   -3 }, /* (135) cmd ::= ALTER TABLE alter_table_clause */
  {  321,   -3 }, /* (136) cmd ::= ALTER STABLE alter_table_clause */
  {  353,   -2 }, /* (137) alter_table_clause ::= full_table_name alter_table_options */
  {  353,   -5 }, /* (138) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  353,   -4 }, /* (139) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  353,   -5 }, /* (140) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  353,   -5 }, /* (141) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  353,   -5 }, /* (142) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  353,   -4 }, /* (143) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  353,   -5 }, /* (144) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  353,   -5 }, /* (145) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  353,   -6 }, /* (146) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  350,   -1 }, /* (147) multi_create_clause ::= create_subtable_clause */
  {  350,   -2 }, /* (148) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  358,  -10 }, /* (149) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  352,   -1 }, /* (150) multi_drop_clause ::= drop_table_clause */
  {  352,   -2 }, /* (151) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  361,   -2 }, /* (152) drop_table_clause ::= exists_opt full_table_name */
  {  359,    0 }, /* (153) specific_cols_opt ::= */
  {  359,   -3 }, /* (154) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  346,   -1 }, /* (155) full_table_name ::= table_name */
  {  346,   -3 }, /* (156) full_table_name ::= db_name NK_DOT table_name */
  {  347,   -1 }, /* (157) column_def_list ::= column_def */
  {  347,   -3 }, /* (158) column_def_list ::= column_def_list NK_COMMA column_def */
  {  364,   -2 }, /* (159) column_def ::= column_name type_name */
  {  364,   -4 }, /* (160) column_def ::= column_name type_name COMMENT NK_STRING */
  {  356,   -1 }, /* (161) type_name ::= BOOL */
  {  356,   -1 }, /* (162) type_name ::= TINYINT */
  {  356,   -1 }, /* (163) type_name ::= SMALLINT */
  {  356,   -1 }, /* (164) type_name ::= INT */
  {  356,   -1 }, /* (165) type_name ::= INTEGER */
  {  356,   -1 }, /* (166) type_name ::= BIGINT */
  {  356,   -1 }, /* (167) type_name ::= FLOAT */
  {  356,   -1 }, /* (168) type_name ::= DOUBLE */
  {  356,   -4 }, /* (169) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  356,   -1 }, /* (170) type_name ::= TIMESTAMP */
  {  356,   -4 }, /* (171) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  356,   -2 }, /* (172) type_name ::= TINYINT UNSIGNED */
  {  356,   -2 }, /* (173) type_name ::= SMALLINT UNSIGNED */
  {  356,   -2 }, /* (174) type_name ::= INT UNSIGNED */
  {  356,   -2 }, /* (175) type_name ::= BIGINT UNSIGNED */
  {  356,   -1 }, /* (176) type_name ::= JSON */
  {  356,   -4 }, /* (177) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  356,   -1 }, /* (178) type_name ::= MEDIUMBLOB */
  {  356,   -1 }, /* (179) type_name ::= BLOB */
  {  356,   -4 }, /* (180) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  356,   -1 }, /* (181) type_name ::= DECIMAL */
  {  356,   -4 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  356,   -6 }, /* (183) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  348,    0 }, /* (184) tags_def_opt ::= */
  {  348,   -1 }, /* (185) tags_def_opt ::= tags_def */
  {  351,   -4 }, /* (186) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  349,    0 }, /* (187) table_options ::= */
  {  349,   -3 }, /* (188) table_options ::= table_options COMMENT NK_STRING */
  {  349,   -3 }, /* (189) table_options ::= table_options MAX_DELAY duration_list */
  {  349,   -3 }, /* (190) table_options ::= table_options WATERMARK duration_list */
  {  349,   -5 }, /* (191) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  349,   -3 }, /* (192) table_options ::= table_options TTL NK_INTEGER */
  {  349,   -5 }, /* (193) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  354,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  354,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  367,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  367,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  365,   -1 }, /* (198) duration_list ::= duration_literal */
  {  365,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  366,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  366,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  369,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  369,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  369,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  362,   -1 }, /* (205) col_name_list ::= col_name */
  {  362,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  371,   -1 }, /* (207) col_name ::= column_name */
  {  321,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  321,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  321,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  321,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  321,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  321,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  321,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  321,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  321,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  321,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  321,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  321,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  321,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  321,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  321,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  321,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  321,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  321,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  321,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  321,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  321,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  321,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  321,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  321,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  321,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  321,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  321,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  321,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  321,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  321,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  321,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  321,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  321,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  321,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  321,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  321,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  321,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  321,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  372,    0 }, /* (246) db_name_cond_opt ::= */
  {  372,   -2 }, /* (247) db_name_cond_opt ::= db_name NK_DOT */
  {  373,    0 }, /* (248) like_pattern_opt ::= */
  {  373,   -2 }, /* (249) like_pattern_opt ::= LIKE NK_STRING */
  {  374,   -1 }, /* (250) table_name_cond ::= table_name */
  {  375,    0 }, /* (251) from_db_opt ::= */
  {  375,   -2 }, /* (252) from_db_opt ::= FROM db_name */
  {  376,    0 }, /* (253) tag_list_opt ::= */
  {  376,   -1 }, /* (254) tag_list_opt ::= tag_item */
  {  376,   -3 }, /* (255) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  377,   -1 }, /* (256) tag_item ::= TBNAME */
  {  377,   -1 }, /* (257) tag_item ::= QTAGS */
  {  377,   -1 }, /* (258) tag_item ::= column_name */
  {  377,   -2 }, /* (259) tag_item ::= column_name column_alias */
  {  377,   -3 }, /* (260) tag_item ::= column_name AS column_alias */
  {  321,   -8 }, /* (261) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  321,   -4 }, /* (262) cmd ::= DROP INDEX exists_opt full_table_name */
  {  379,  -10 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  379,  -12 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  380,   -1 }, /* (265) func_list ::= func */
  {  380,   -3 }, /* (266) func_list ::= func_list NK_COMMA func */
  {  383,   -4 }, /* (267) func ::= function_name NK_LP expression_list NK_RP */
  {  382,    0 }, /* (268) sma_stream_opt ::= */
  {  382,   -3 }, /* (269) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  382,   -3 }, /* (270) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  321,   -6 }, /* (271) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  321,   -7 }, /* (272) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  321,   -9 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  321,   -7 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  321,   -9 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  321,   -4 }, /* (276) cmd ::= DROP TOPIC exists_opt topic_name */
  {  321,   -7 }, /* (277) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  321,   -2 }, /* (278) cmd ::= DESC full_table_name */
  {  321,   -2 }, /* (279) cmd ::= DESCRIBE full_table_name */
  {  321,   -3 }, /* (280) cmd ::= RESET QUERY CACHE */
  {  321,   -4 }, /* (281) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  387,    0 }, /* (282) analyze_opt ::= */
  {  387,   -1 }, /* (283) analyze_opt ::= ANALYZE */
  {  388,    0 }, /* (284) explain_options ::= */
  {  388,   -3 }, /* (285) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  388,   -3 }, /* (286) explain_options ::= explain_options RATIO NK_FLOAT */
  {  321,  -10 }, /* (287) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  321,   -4 }, /* (288) cmd ::= DROP FUNCTION exists_opt function_name */
  {  389,    0 }, /* (289) agg_func_opt ::= */
  {  389,   -1 }, /* (290) agg_func_opt ::= AGGREGATE */
  {  390,    0 }, /* (291) bufsize_opt ::= */
  {  390,   -2 }, /* (292) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  321,  -11 }, /* (293) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  321,   -4 }, /* (294) cmd ::= DROP STREAM exists_opt stream_name */
  {  384,    0 }, /* (295) stream_options ::= */
  {  384,   -3 }, /* (296) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  384,   -3 }, /* (297) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  384,   -4 }, /* (298) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  384,   -3 }, /* (299) stream_options ::= stream_options WATERMARK duration_literal */
  {  384,   -4 }, /* (300) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  384,   -3 }, /* (301) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  392,    0 }, /* (302) subtable_opt ::= */
  {  392,   -4 }, /* (303) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  321,   -3 }, /* (304) cmd ::= KILL CONNECTION NK_INTEGER */
  {  321,   -3 }, /* (305) cmd ::= KILL QUERY NK_STRING */
  {  321,   -3 }, /* (306) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  321,   -2 }, /* (307) cmd ::= BALANCE VGROUP */
  {  321,   -4 }, /* (308) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  321,   -4 }, /* (309) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  321,   -3 }, /* (310) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  394,   -2 }, /* (311) dnode_list ::= DNODE NK_INTEGER */
  {  394,   -3 }, /* (312) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  321,   -4 }, /* (313) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  321,   -1 }, /* (314) cmd ::= query_or_subquery */
  {  321,   -7 }, /* (315) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  321,   -4 }, /* (316) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  324,   -1 }, /* (317) literal ::= NK_INTEGER */
  {  324,   -1 }, /* (318) literal ::= NK_FLOAT */
  {  324,   -1 }, /* (319) literal ::= NK_STRING */
  {  324,   -1 }, /* (320) literal ::= NK_BOOL */
  {  324,   -2 }, /* (321) literal ::= TIMESTAMP NK_STRING */
  {  324,   -1 }, /* (322) literal ::= duration_literal */
  {  324,   -1 }, /* (323) literal ::= NULL */
  {  324,   -1 }, /* (324) literal ::= NK_QUESTION */
  {  368,   -1 }, /* (325) duration_literal ::= NK_VARIABLE */
  {  396,   -1 }, /* (326) signed ::= NK_INTEGER */
  {  396,   -2 }, /* (327) signed ::= NK_PLUS NK_INTEGER */
  {  396,   -2 }, /* (328) signed ::= NK_MINUS NK_INTEGER */
  {  396,   -1 }, /* (329) signed ::= NK_FLOAT */
  {  396,   -2 }, /* (330) signed ::= NK_PLUS NK_FLOAT */
  {  396,   -2 }, /* (331) signed ::= NK_MINUS NK_FLOAT */
  {  357,   -1 }, /* (332) signed_literal ::= signed */
  {  357,   -1 }, /* (333) signed_literal ::= NK_STRING */
  {  357,   -1 }, /* (334) signed_literal ::= NK_BOOL */
  {  357,   -2 }, /* (335) signed_literal ::= TIMESTAMP NK_STRING */
  {  357,   -1 }, /* (336) signed_literal ::= duration_literal */
  {  357,   -1 }, /* (337) signed_literal ::= NULL */
  {  357,   -1 }, /* (338) signed_literal ::= literal_func */
  {  357,   -1 }, /* (339) signed_literal ::= NK_QUESTION */
  {  398,   -1 }, /* (340) literal_list ::= signed_literal */
  {  398,   -3 }, /* (341) literal_list ::= literal_list NK_COMMA signed_literal */
  {  332,   -1 }, /* (342) db_name ::= NK_ID */
  {  363,   -1 }, /* (343) table_name ::= NK_ID */
  {  355,   -1 }, /* (344) column_name ::= NK_ID */
  {  370,   -1 }, /* (345) function_name ::= NK_ID */
  {  399,   -1 }, /* (346) table_alias ::= NK_ID */
  {  378,   -1 }, /* (347) column_alias ::= NK_ID */
  {  326,   -1 }, /* (348) user_name ::= NK_ID */
  {  333,   -1 }, /* (349) topic_name ::= NK_ID */
  {  391,   -1 }, /* (350) stream_name ::= NK_ID */
  {  386,   -1 }, /* (351) cgroup_name ::= NK_ID */
  {  400,   -1 }, /* (352) expr_or_subquery ::= expression */
  {  393,   -1 }, /* (353) expression ::= literal */
  {  393,   -1 }, /* (354) expression ::= pseudo_column */
  {  393,   -1 }, /* (355) expression ::= column_reference */
  {  393,   -1 }, /* (356) expression ::= function_expression */
  {  393,   -1 }, /* (357) expression ::= case_when_expression */
  {  393,   -3 }, /* (358) expression ::= NK_LP expression NK_RP */
  {  393,   -2 }, /* (359) expression ::= NK_PLUS expr_or_subquery */
  {  393,   -2 }, /* (360) expression ::= NK_MINUS expr_or_subquery */
  {  393,   -3 }, /* (361) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  393,   -3 }, /* (362) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  393,   -3 }, /* (363) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  393,   -3 }, /* (364) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  393,   -3 }, /* (365) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  393,   -3 }, /* (366) expression ::= column_reference NK_ARROW NK_STRING */
  {  393,   -3 }, /* (367) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  393,   -3 }, /* (368) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  360,   -1 }, /* (369) expression_list ::= expr_or_subquery */
  {  360,   -3 }, /* (370) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  402,   -1 }, /* (371) column_reference ::= column_name */
  {  402,   -3 }, /* (372) column_reference ::= table_name NK_DOT column_name */
  {  401,   -1 }, /* (373) pseudo_column ::= ROWTS */
  {  401,   -1 }, /* (374) pseudo_column ::= TBNAME */
  {  401,   -3 }, /* (375) pseudo_column ::= table_name NK_DOT TBNAME */
  {  401,   -1 }, /* (376) pseudo_column ::= QSTART */
  {  401,   -1 }, /* (377) pseudo_column ::= QEND */
  {  401,   -1 }, /* (378) pseudo_column ::= QDURATION */
  {  401,   -1 }, /* (379) pseudo_column ::= WSTART */
  {  401,   -1 }, /* (380) pseudo_column ::= WEND */
  {  401,   -1 }, /* (381) pseudo_column ::= WDURATION */
  {  401,   -1 }, /* (382) pseudo_column ::= IROWTS */
  {  401,   -1 }, /* (383) pseudo_column ::= QTAGS */
  {  403,   -4 }, /* (384) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  403,   -4 }, /* (385) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  403,   -6 }, /* (386) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  403,   -1 }, /* (387) function_expression ::= literal_func */
  {  397,   -3 }, /* (388) literal_func ::= noarg_func NK_LP NK_RP */
  {  397,   -1 }, /* (389) literal_func ::= NOW */
  {  407,   -1 }, /* (390) noarg_func ::= NOW */
  {  407,   -1 }, /* (391) noarg_func ::= TODAY */
  {  407,   -1 }, /* (392) noarg_func ::= TIMEZONE */
  {  407,   -1 }, /* (393) noarg_func ::= DATABASE */
  {  407,   -1 }, /* (394) noarg_func ::= CLIENT_VERSION */
  {  407,   -1 }, /* (395) noarg_func ::= SERVER_VERSION */
  {  407,   -1 }, /* (396) noarg_func ::= SERVER_STATUS */
  {  407,   -1 }, /* (397) noarg_func ::= CURRENT_USER */
  {  407,   -1 }, /* (398) noarg_func ::= USER */
  {  405,   -1 }, /* (399) star_func ::= COUNT */
  {  405,   -1 }, /* (400) star_func ::= FIRST */
  {  405,   -1 }, /* (401) star_func ::= LAST */
  {  405,   -1 }, /* (402) star_func ::= LAST_ROW */
  {  406,   -1 }, /* (403) star_func_para_list ::= NK_STAR */
  {  406,   -1 }, /* (404) star_func_para_list ::= other_para_list */
  {  408,   -1 }, /* (405) other_para_list ::= star_func_para */
  {  408,   -3 }, /* (406) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  409,   -1 }, /* (407) star_func_para ::= expr_or_subquery */
  {  409,   -3 }, /* (408) star_func_para ::= table_name NK_DOT NK_STAR */
  {  404,   -4 }, /* (409) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  404,   -5 }, /* (410) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  410,   -1 }, /* (411) when_then_list ::= when_then_expr */
  {  410,   -2 }, /* (412) when_then_list ::= when_then_list when_then_expr */
  {  413,   -4 }, /* (413) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  411,    0 }, /* (414) case_when_else_opt ::= */
  {  411,   -2 }, /* (415) case_when_else_opt ::= ELSE common_expression */
  {  414,   -3 }, /* (416) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  414,   -5 }, /* (417) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  414,   -6 }, /* (418) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  414,   -3 }, /* (419) predicate ::= expr_or_subquery IS NULL */
  {  414,   -4 }, /* (420) predicate ::= expr_or_subquery IS NOT NULL */
  {  414,   -3 }, /* (421) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  415,   -1 }, /* (422) compare_op ::= NK_LT */
  {  415,   -1 }, /* (423) compare_op ::= NK_GT */
  {  415,   -1 }, /* (424) compare_op ::= NK_LE */
  {  415,   -1 }, /* (425) compare_op ::= NK_GE */
  {  415,   -1 }, /* (426) compare_op ::= NK_NE */
  {  415,   -1 }, /* (427) compare_op ::= NK_EQ */
  {  415,   -1 }, /* (428) compare_op ::= LIKE */
  {  415,   -2 }, /* (429) compare_op ::= NOT LIKE */
  {  415,   -1 }, /* (430) compare_op ::= MATCH */
  {  415,   -1 }, /* (431) compare_op ::= NMATCH */
  {  415,   -1 }, /* (432) compare_op ::= CONTAINS */
  {  416,   -1 }, /* (433) in_op ::= IN */
  {  416,   -2 }, /* (434) in_op ::= NOT IN */
  {  417,   -3 }, /* (435) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  418,   -1 }, /* (436) boolean_value_expression ::= boolean_primary */
  {  418,   -2 }, /* (437) boolean_value_expression ::= NOT boolean_primary */
  {  418,   -3 }, /* (438) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  418,   -3 }, /* (439) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  419,   -1 }, /* (440) boolean_primary ::= predicate */
  {  419,   -3 }, /* (441) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  412,   -1 }, /* (442) common_expression ::= expr_or_subquery */
  {  412,   -1 }, /* (443) common_expression ::= boolean_value_expression */
  {  420,    0 }, /* (444) from_clause_opt ::= */
  {  420,   -2 }, /* (445) from_clause_opt ::= FROM table_reference_list */
  {  421,   -1 }, /* (446) table_reference_list ::= table_reference */
  {  421,   -3 }, /* (447) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  422,   -1 }, /* (448) table_reference ::= table_primary */
  {  422,   -1 }, /* (449) table_reference ::= joined_table */
  {  423,   -2 }, /* (450) table_primary ::= table_name alias_opt */
  {  423,   -4 }, /* (451) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  423,   -2 }, /* (452) table_primary ::= subquery alias_opt */
  {  423,   -1 }, /* (453) table_primary ::= parenthesized_joined_table */
  {  425,    0 }, /* (454) alias_opt ::= */
  {  425,   -1 }, /* (455) alias_opt ::= table_alias */
  {  425,   -2 }, /* (456) alias_opt ::= AS table_alias */
  {  427,   -3 }, /* (457) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  427,   -3 }, /* (458) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  424,   -6 }, /* (459) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  428,    0 }, /* (460) join_type ::= */
  {  428,   -1 }, /* (461) join_type ::= INNER */
  {  430,  -12 }, /* (462) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  431,    0 }, /* (463) set_quantifier_opt ::= */
  {  431,   -1 }, /* (464) set_quantifier_opt ::= DISTINCT */
  {  431,   -1 }, /* (465) set_quantifier_opt ::= ALL */
  {  432,   -1 }, /* (466) select_list ::= select_item */
  {  432,   -3 }, /* (467) select_list ::= select_list NK_COMMA select_item */
  {  440,   -1 }, /* (468) select_item ::= NK_STAR */
  {  440,   -1 }, /* (469) select_item ::= common_expression */
  {  440,   -2 }, /* (470) select_item ::= common_expression column_alias */
  {  440,   -3 }, /* (471) select_item ::= common_expression AS column_alias */
  {  440,   -3 }, /* (472) select_item ::= table_name NK_DOT NK_STAR */
  {  395,    0 }, /* (473) where_clause_opt ::= */
  {  395,   -2 }, /* (474) where_clause_opt ::= WHERE search_condition */
  {  433,    0 }, /* (475) partition_by_clause_opt ::= */
  {  433,   -3 }, /* (476) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  441,   -1 }, /* (477) partition_list ::= partition_item */
  {  441,   -3 }, /* (478) partition_list ::= partition_list NK_COMMA partition_item */
  {  442,   -1 }, /* (479) partition_item ::= expr_or_subquery */
  {  442,   -2 }, /* (480) partition_item ::= expr_or_subquery column_alias */
  {  442,   -3 }, /* (481) partition_item ::= expr_or_subquery AS column_alias */
  {  437,    0 }, /* (482) twindow_clause_opt ::= */
  {  437,   -6 }, /* (483) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  437,   -4 }, /* (484) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  437,   -6 }, /* (485) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  437,   -8 }, /* (486) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  381,    0 }, /* (487) sliding_opt ::= */
  {  381,   -4 }, /* (488) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  436,    0 }, /* (489) fill_opt ::= */
  {  436,   -4 }, /* (490) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  436,   -6 }, /* (491) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  443,   -1 }, /* (492) fill_mode ::= NONE */
  {  443,   -1 }, /* (493) fill_mode ::= PREV */
  {  443,   -1 }, /* (494) fill_mode ::= NULL */
  {  443,   -1 }, /* (495) fill_mode ::= LINEAR */
  {  443,   -1 }, /* (496) fill_mode ::= NEXT */
  {  438,    0 }, /* (497) group_by_clause_opt ::= */
  {  438,   -3 }, /* (498) group_by_clause_opt ::= GROUP BY group_by_list */
  {  444,   -1 }, /* (499) group_by_list ::= expr_or_subquery */
  {  444,   -3 }, /* (500) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  439,    0 }, /* (501) having_clause_opt ::= */
  {  439,   -2 }, /* (502) having_clause_opt ::= HAVING search_condition */
  {  434,    0 }, /* (503) range_opt ::= */
  {  434,   -6 }, /* (504) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  435,    0 }, /* (505) every_opt ::= */
  {  435,   -4 }, /* (506) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  445,   -4 }, /* (507) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  446,   -1 }, /* (508) query_simple ::= query_specification */
  {  446,   -1 }, /* (509) query_simple ::= union_query_expression */
  {  450,   -4 }, /* (510) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  450,   -3 }, /* (511) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  451,   -1 }, /* (512) query_simple_or_subquery ::= query_simple */
  {  451,   -1 }, /* (513) query_simple_or_subquery ::= subquery */
  {  385,   -1 }, /* (514) query_or_subquery ::= query_expression */
  {  385,   -1 }, /* (515) query_or_subquery ::= subquery */
  {  447,    0 }, /* (516) order_by_clause_opt ::= */
  {  447,   -3 }, /* (517) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  448,    0 }, /* (518) slimit_clause_opt ::= */
  {  448,   -2 }, /* (519) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  448,   -4 }, /* (520) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  448,   -4 }, /* (521) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  449,    0 }, /* (522) limit_clause_opt ::= */
  {  449,   -2 }, /* (523) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  449,   -4 }, /* (524) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  449,   -4 }, /* (525) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  426,   -3 }, /* (526) subquery ::= NK_LP query_expression NK_RP */
  {  426,   -3 }, /* (527) subquery ::= NK_LP subquery NK_RP */
  {  429,   -1 }, /* (528) search_condition ::= common_expression */
  {  452,   -1 }, /* (529) sort_specification_list ::= sort_specification */
  {  452,   -3 }, /* (530) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  453,   -3 }, /* (531) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  454,    0 }, /* (532) ordering_specification_opt ::= */
  {  454,   -1 }, /* (533) ordering_specification_opt ::= ASC */
  {  454,   -1 }, /* (534) ordering_specification_opt ::= DESC */
  {  455,    0 }, /* (535) null_ordering_opt ::= */
  {  455,   -2 }, /* (536) null_ordering_opt ::= NULLS FIRST */
  {  455,   -2 }, /* (537) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,322,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,323,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,322,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,324,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,325,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,323,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,324,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy737, &yymsp[-1].minor.yy0, yymsp[0].minor.yy695); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy737, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy737, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy737, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy737); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy695 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy695 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy93, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy737); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy93, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy737); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy93 = yymsp[0].minor.yy93; }
  yymsp[0].minor.yy93 = yylhsminor.yy93;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy93 = yymsp[-2].minor.yy93 | yymsp[0].minor.yy93; }
  yymsp[-2].minor.yy93 = yylhsminor.yy93;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy93 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy737 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy737 = yylhsminor.yy737;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy737 = yymsp[-2].minor.yy737; }
  yymsp[-2].minor.yy737 = yylhsminor.yy737;
        break;
      case 42: /* priv_level ::= topic_name */
      case 455: /* alias_opt ::= table_alias */ yytestcase(yyruleno==455);
{ yylhsminor.yy737 = yymsp[0].minor.yy737; }
  yymsp[0].minor.yy737 = yylhsminor.yy737;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy737, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy185); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy737, yymsp[0].minor.yy185); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 342: /* db_name ::= NK_ID */ yytestcase(yyruleno==342);
      case 343: /* table_name ::= NK_ID */ yytestcase(yyruleno==343);
      case 344: /* column_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* function_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* table_alias ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* column_alias ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* user_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* topic_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* stream_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 390: /* noarg_func ::= NOW */ yytestcase(yyruleno==390);
      case 391: /* noarg_func ::= TODAY */ yytestcase(yyruleno==391);
      case 392: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= USER */ yytestcase(yyruleno==398);
      case 399: /* star_func ::= COUNT */ yytestcase(yyruleno==399);
      case 400: /* star_func ::= FIRST */ yytestcase(yyruleno==400);
      case 401: /* star_func ::= LAST */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==402);
{ yylhsminor.yy737 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy737 = yylhsminor.yy737;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 282: /* analyze_opt ::= */ yytestcase(yyruleno==282);
      case 289: /* agg_func_opt ::= */ yytestcase(yyruleno==289);
      case 463: /* set_quantifier_opt ::= */ yytestcase(yyruleno==463);
{ yymsp[1].minor.yy185 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 283: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==283);
      case 290: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==290);
      case 464: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==464);
{ yymsp[0].minor.yy185 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy185, &yymsp[-1].minor.yy737, yymsp[0].minor.yy104); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy737); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy737); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy737, yymsp[0].minor.yy104); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy737); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy737, yymsp[0].minor.yy196); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy185 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy185 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy104 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_KEEP, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 92: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_RETENTIONS, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-3].minor.yy104, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-3].minor.yy104, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy104 = setDatabaseOption(pCxt, yymsp[-2].minor.yy104, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy104 = createAlterDatabaseOptions(pCxt); yylhsminor.yy104 = setAlterDatabaseOption(pCxt, yylhsminor.yy104, &yymsp[0].minor.yy557); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy104 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy104, &yymsp[0].minor.yy557); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy557.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy557.type = DB_OPTION_KEEP; yymsp[-1].minor.yy557.pList = yymsp[0].minor.yy616; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_PAGES; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy557.type = DB_OPTION_STRICT; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_WAL; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy616 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 122: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 312: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==312);
{ yylhsminor.yy616 = addNodeToList(pCxt, yymsp[-2].minor.yy616, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 123: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy616 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 124: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy616 = addNodeToList(pCxt, yymsp[-2].minor.yy616, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 125: /* retention_list ::= retention */
      case 147: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==147);
      case 150: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==150);
      case 157: /* column_def_list ::= column_def */ yytestcase(yyruleno==157);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func */ yytestcase(yyruleno==265);
      case 340: /* literal_list ::= signed_literal */ yytestcase(yyruleno==340);
      case 405: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==405);
      case 411: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==411);
      case 466: /* select_list ::= select_item */ yytestcase(yyruleno==466);
      case 477: /* partition_list ::= partition_item */ yytestcase(yyruleno==477);
      case 529: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==529);
{ yylhsminor.yy616 = createNodeList(pCxt, yymsp[0].minor.yy104); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 126: /* retention_list ::= retention_list NK_COMMA retention */
      case 158: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==158);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 255: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==255);
      case 266: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==266);
      case 341: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==341);
      case 406: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==406);
      case 467: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==467);
      case 478: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==478);
      case 530: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==530);
{ yylhsminor.yy616 = addNodeToList(pCxt, yymsp[-2].minor.yy616, yymsp[0].minor.yy104); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 127: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy104 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 128: /* speed_opt ::= */
      case 291: /* bufsize_opt ::= */ yytestcase(yyruleno==291);
{ yymsp[1].minor.yy196 = 0; }
        break;
      case 129: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 292: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==292);
{ yymsp[-1].minor.yy196 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 130: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 132: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==132);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy185, yymsp[-5].minor.yy104, yymsp[-3].minor.yy616, yymsp[-1].minor.yy616, yymsp[0].minor.yy104); }
        break;
      case 131: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 133: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 134: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy185, yymsp[0].minor.yy104); }
        break;
      case 135: /* cmd ::= ALTER TABLE alter_table_clause */
      case 314: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==314);
{ pCxt->pRootNode = yymsp[0].minor.yy104; }
        break;
      case 136: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy104); }
        break;
      case 137: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy104 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 138: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy737, yymsp[0].minor.yy640); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 139: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy104 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy104, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy737); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 140: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy737, yymsp[0].minor.yy640); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 141: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy104 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy737, &yymsp[0].minor.yy737); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 142: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy737, yymsp[0].minor.yy640); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 143: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy104 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy104, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy737); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 144: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy104 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy737, yymsp[0].minor.yy640); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 145: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy104 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy104, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy737, &yymsp[0].minor.yy737); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 146: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy104 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy104, &yymsp[-2].minor.yy737, yymsp[0].minor.yy104); }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 148: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 151: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==151);
      case 412: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==412);
{ yylhsminor.yy616 = addNodeToList(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 149: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy104 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy185, yymsp[-8].minor.yy104, yymsp[-6].minor.yy104, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616, yymsp[0].minor.yy104); }
  yymsp[-9].minor.yy104 = yylhsminor.yy104;
        break;
      case 152: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy104 = createDropTableClause(pCxt, yymsp[-1].minor.yy185, yymsp[0].minor.yy104); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 153: /* specific_cols_opt ::= */
      case 184: /* tags_def_opt ::= */ yytestcase(yyruleno==184);
      case 253: /* tag_list_opt ::= */ yytestcase(yyruleno==253);
      case 475: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==475);
      case 497: /* group_by_clause_opt ::= */ yytestcase(yyruleno==497);
      case 516: /* order_by_clause_opt ::= */ yytestcase(yyruleno==516);
{ yymsp[1].minor.yy616 = NULL; }
        break;
      case 154: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy616 = yymsp[-1].minor.yy616; }
        break;
      case 155: /* full_table_name ::= table_name */
{ yylhsminor.yy104 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy737, NULL); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 156: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy104 = createRealTableNode(pCxt, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy737, NULL); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 159: /* column_def ::= column_name type_name */
{ yylhsminor.yy104 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy737, yymsp[0].minor.yy640, NULL); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 160: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy104 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy737, yymsp[-2].minor.yy640, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 161: /* type_name ::= BOOL */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 162: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 163: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 164: /* type_name ::= INT */
      case 165: /* type_name ::= INTEGER */ yytestcase(yyruleno==165);
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 166: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 167: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 168: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 169: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy640 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 171: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy640 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 172: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy640 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 173: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy640 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 174: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy640 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 175: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy640 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 176: /* type_name ::= JSON */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 177: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy640 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 178: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 179: /* type_name ::= BLOB */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 180: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy640 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 181: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy640 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy640 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy640 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 185: /* tags_def_opt ::= tags_def */
      case 404: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==404);
{ yylhsminor.yy616 = yymsp[0].minor.yy616; }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 186: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy616 = yymsp[-1].minor.yy616; }
        break;
      case 187: /* table_options ::= */
{ yymsp[1].minor.yy104 = createDefaultTableOptions(pCxt); }
        break;
      case 188: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 189: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 190: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 191: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-4].minor.yy104, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy616); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 192: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-2].minor.yy104, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 193: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-4].minor.yy104, TABLE_OPTION_SMA, yymsp[-1].minor.yy616); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy104 = createAlterTableOptions(pCxt); yylhsminor.yy104 = setTableOption(pCxt, yylhsminor.yy104, yymsp[0].minor.yy557.type, &yymsp[0].minor.yy557.val); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy104 = setTableOption(pCxt, yymsp[-1].minor.yy104, yymsp[0].minor.yy557.type, &yymsp[0].minor.yy557.val); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy557.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy557.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 369: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==369);
{ yylhsminor.yy616 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 370: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==370);
{ yylhsminor.yy616 = addNodeToList(pCxt, yymsp[-2].minor.yy616, releaseRawExprNode(pCxt, yymsp[0].minor.yy104)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy104 = createFunctionNode(pCxt, &yymsp[0].minor.yy737, NULL); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 257: /* tag_item ::= QTAGS */ yytestcase(yyruleno==257);
{ yylhsminor.yy104 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 207: /* col_name ::= column_name */
      case 258: /* tag_item ::= column_name */ yytestcase(yyruleno==258);
{ yylhsminor.yy104 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy737); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy104, yymsp[0].minor.yy104, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy104, yymsp[0].minor.yy104, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy104, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy104, yymsp[-1].minor.yy104, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy737); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy104); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy104); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy104); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy104); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy104, yymsp[-1].minor.yy104, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy104, yymsp[0].minor.yy104, yymsp[-3].minor.yy616); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* db_name_cond_opt ::= */
      case 251: /* from_db_opt ::= */ yytestcase(yyruleno==251);
{ yymsp[1].minor.yy104 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 247: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy104 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy737); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 248: /* like_pattern_opt ::= */
      case 302: /* subtable_opt ::= */ yytestcase(yyruleno==302);
      case 414: /* case_when_else_opt ::= */ yytestcase(yyruleno==414);
      case 444: /* from_clause_opt ::= */ yytestcase(yyruleno==444);
      case 473: /* where_clause_opt ::= */ yytestcase(yyruleno==473);
      case 482: /* twindow_clause_opt ::= */ yytestcase(yyruleno==482);
      case 487: /* sliding_opt ::= */ yytestcase(yyruleno==487);
      case 489: /* fill_opt ::= */ yytestcase(yyruleno==489);
      case 501: /* having_clause_opt ::= */ yytestcase(yyruleno==501);
      case 503: /* range_opt ::= */ yytestcase(yyruleno==503);
      case 505: /* every_opt ::= */ yytestcase(yyruleno==505);
      case 518: /* slimit_clause_opt ::= */ yytestcase(yyruleno==518);
      case 522: /* limit_clause_opt ::= */ yytestcase(yyruleno==522);
{ yymsp[1].minor.yy104 = NULL; }
        break;
      case 249: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 250: /* table_name_cond ::= table_name */
{ yylhsminor.yy104 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy737); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 252: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy104 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy737); }
        break;
      case 256: /* tag_item ::= TBNAME */
{ yylhsminor.yy104 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 259: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy104 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy737), &yymsp[0].minor.yy737); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 260: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy104 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy737), &yymsp[0].minor.yy737); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 261: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy185, yymsp[-3].minor.yy104, yymsp[-1].minor.yy104, NULL, yymsp[0].minor.yy104); }
        break;
      case 262: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy185, yymsp[0].minor.yy104); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy104 = createIndexOption(pCxt, yymsp[-7].minor.yy616, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), NULL, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy104 = createIndexOption(pCxt, yymsp[-9].minor.yy616, releaseRawExprNode(pCxt, yymsp[-5].minor.yy104), releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 267: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy104 = createFunctionNode(pCxt, &yymsp[-3].minor.yy737, yymsp[-1].minor.yy616); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 268: /* sma_stream_opt ::= */
      case 295: /* stream_options ::= */ yytestcase(yyruleno==295);
{ yymsp[1].minor.yy104 = createStreamOptions(pCxt); }
        break;
      case 269: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 299: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==299);
{ ((SStreamOptions*)yymsp[-2].minor.yy104)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy104); yylhsminor.yy104 = yymsp[-2].minor.yy104; }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 270: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy104)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy104); yylhsminor.yy104 = yymsp[-2].minor.yy104; }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 271: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy737, yymsp[0].minor.yy104); }
        break;
      case 272: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy185, &yymsp[-3].minor.yy737, &yymsp[0].minor.yy737, false); }
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy185, &yymsp[-5].minor.yy737, &yymsp[0].minor.yy737, true); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy185, &yymsp[-3].minor.yy737, yymsp[0].minor.yy104, false); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy185, &yymsp[-5].minor.yy737, yymsp[0].minor.yy104, true); }
        break;
      case 276: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy737); }
        break;
      case 277: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy185, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy737); }
        break;
      case 278: /* cmd ::= DESC full_table_name */
      case 279: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==279);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy104); }
        break;
      case 280: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 281: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy185, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 284: /* explain_options ::= */
{ yymsp[1].minor.yy104 = createDefaultExplainOptions(pCxt); }
        break;
      case 285: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy104 = setExplainVerbose(pCxt, yymsp[-2].minor.yy104, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 286: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy104 = setExplainRatio(pCxt, yymsp[-2].minor.yy104, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 287: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy185, yymsp[-8].minor.yy185, &yymsp[-5].minor.yy737, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy640, yymsp[0].minor.yy196); }
        break;
      case 288: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy737); }
        break;
      case 293: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy185, &yymsp[-7].minor.yy737, yymsp[-4].minor.yy104, yymsp[-6].minor.yy104, yymsp[-3].minor.yy616, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 294: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy185, &yymsp[0].minor.yy737); }
        break;
      case 296: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy104)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy104 = yymsp[-2].minor.yy104; }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 297: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy104)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy104 = yymsp[-2].minor.yy104; }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 298: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy104)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy104)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy104); yylhsminor.yy104 = yymsp[-3].minor.yy104; }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 300: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy104)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy104 = yymsp[-3].minor.yy104; }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 301: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy104)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy104 = yymsp[-2].minor.yy104; }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 303: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 488: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==488);
      case 506: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==506);
{ yymsp[-3].minor.yy104 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy104); }
        break;
      case 304: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 305: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 306: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 308: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 309: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy616); }
        break;
      case 310: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 311: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy616 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 313: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 315: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy104, yymsp[-2].minor.yy616, yymsp[0].minor.yy104); }
        break;
      case 316: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy104, NULL, yymsp[0].minor.yy104); }
        break;
      case 317: /* literal ::= NK_INTEGER */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 318: /* literal ::= NK_FLOAT */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 319: /* literal ::= NK_STRING */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 320: /* literal ::= NK_BOOL */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 321: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 322: /* literal ::= duration_literal */
      case 332: /* signed_literal ::= signed */ yytestcase(yyruleno==332);
      case 352: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==352);
      case 353: /* expression ::= literal */ yytestcase(yyruleno==353);
      case 354: /* expression ::= pseudo_column */ yytestcase(yyruleno==354);
      case 355: /* expression ::= column_reference */ yytestcase(yyruleno==355);
      case 356: /* expression ::= function_expression */ yytestcase(yyruleno==356);
      case 357: /* expression ::= case_when_expression */ yytestcase(yyruleno==357);
      case 387: /* function_expression ::= literal_func */ yytestcase(yyruleno==387);
      case 436: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==436);
      case 440: /* boolean_primary ::= predicate */ yytestcase(yyruleno==440);
      case 442: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==442);
      case 443: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==443);
      case 446: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==446);
      case 448: /* table_reference ::= table_primary */ yytestcase(yyruleno==448);
      case 449: /* table_reference ::= joined_table */ yytestcase(yyruleno==449);
      case 453: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==453);
      case 508: /* query_simple ::= query_specification */ yytestcase(yyruleno==508);
      case 509: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==509);
      case 512: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==512);
      case 514: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==514);
{ yylhsminor.yy104 = yymsp[0].minor.yy104; }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 323: /* literal ::= NULL */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 324: /* literal ::= NK_QUESTION */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 325: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 326: /* signed ::= NK_INTEGER */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 327: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 328: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 329: /* signed ::= NK_FLOAT */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 330: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 331: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 333: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 334: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 335: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 336: /* signed_literal ::= duration_literal */
      case 338: /* signed_literal ::= literal_func */ yytestcase(yyruleno==338);
      case 407: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==407);
      case 469: /* select_item ::= common_expression */ yytestcase(yyruleno==469);
      case 479: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==479);
      case 513: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==513);
      case 515: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==515);
      case 528: /* search_condition ::= common_expression */ yytestcase(yyruleno==528);
{ yylhsminor.yy104 = releaseRawExprNode(pCxt, yymsp[0].minor.yy104); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 337: /* signed_literal ::= NULL */
{ yylhsminor.yy104 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 339: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy104 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 358: /* expression ::= NK_LP expression NK_RP */
      case 441: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==441);
      case 527: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==527);
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 359: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy104));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 360: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), NULL));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 361: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 362: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 363: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 364: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 365: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 366: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 367: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 368: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 371: /* column_reference ::= column_name */
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy737, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy737)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 372: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy737, createColumnNode(pCxt, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy737)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 373: /* pseudo_column ::= ROWTS */
      case 374: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==374);
      case 376: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==376);
      case 377: /* pseudo_column ::= QEND */ yytestcase(yyruleno==377);
      case 378: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= WEND */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==383);
      case 389: /* literal_func ::= NOW */ yytestcase(yyruleno==389);
{ yylhsminor.yy104 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 375: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy737)))); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 384: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 385: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==385);
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy737, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy737, yymsp[-1].minor.yy616)); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 386: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), yymsp[-1].minor.yy640)); }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 388: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy737, NULL)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 403: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy616 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 408: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 472: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==472);
{ yylhsminor.yy104 = createColumnNode(pCxt, &yymsp[-2].minor.yy737, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 409: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy616, yymsp[-1].minor.yy104)); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 410: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), yymsp[-2].minor.yy616, yymsp[-1].minor.yy104)); }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 413: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy104 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)); }
        break;
      case 415: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy104 = releaseRawExprNode(pCxt, yymsp[0].minor.yy104); }
        break;
      case 416: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 421: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==421);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy668, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 417: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy104), releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-4].minor.yy104 = yylhsminor.yy104;
        break;
      case 418: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy104), releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 419: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), NULL));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 420: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), NULL));
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 422: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy668 = OP_TYPE_LOWER_THAN; }
        break;
      case 423: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy668 = OP_TYPE_GREATER_THAN; }
        break;
      case 424: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy668 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 425: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy668 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 426: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy668 = OP_TYPE_NOT_EQUAL; }
        break;
      case 427: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy668 = OP_TYPE_EQUAL; }
        break;
      case 428: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy668 = OP_TYPE_LIKE; }
        break;
      case 429: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy668 = OP_TYPE_NOT_LIKE; }
        break;
      case 430: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy668 = OP_TYPE_MATCH; }
        break;
      case 431: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy668 = OP_TYPE_NMATCH; }
        break;
      case 432: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy668 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 433: /* in_op ::= IN */
{ yymsp[0].minor.yy668 = OP_TYPE_IN; }
        break;
      case 434: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy668 = OP_TYPE_NOT_IN; }
        break;
      case 435: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy616)); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 437: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy104), NULL));
                                                                                  }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 438: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 439: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy104);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy104);
                                                                                    yylhsminor.yy104 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), releaseRawExprNode(pCxt, yymsp[0].minor.yy104)));
                                                                                  }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 445: /* from_clause_opt ::= FROM table_reference_list */
      case 474: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==474);
      case 502: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==502);
{ yymsp[-1].minor.yy104 = yymsp[0].minor.yy104; }
        break;
      case 447: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy104 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy104, yymsp[0].minor.yy104, NULL); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 450: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy104 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy737, &yymsp[0].minor.yy737); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 451: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy104 = createRealTableNode(pCxt, &yymsp[-3].minor.yy737, &yymsp[-1].minor.yy737, &yymsp[0].minor.yy737); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 452: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy104 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104), &yymsp[0].minor.yy737); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 454: /* alias_opt ::= */
{ yymsp[1].minor.yy737 = nil_token;  }
        break;
      case 456: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy737 = yymsp[0].minor.yy737; }
        break;
      case 457: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 458: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==458);
{ yymsp[-2].minor.yy104 = yymsp[-1].minor.yy104; }
        break;
      case 459: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy104 = createJoinTableNode(pCxt, yymsp[-4].minor.yy228, yymsp[-5].minor.yy104, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-5].minor.yy104 = yylhsminor.yy104;
        break;
      case 460: /* join_type ::= */
{ yymsp[1].minor.yy228 = JOIN_TYPE_INNER; }
        break;
      case 461: /* join_type ::= INNER */
{ yymsp[0].minor.yy228 = JOIN_TYPE_INNER; }
        break;
      case 462: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy104 = createSelectStmt(pCxt, yymsp[-10].minor.yy185, yymsp[-9].minor.yy616, yymsp[-8].minor.yy104);
                                                                                    yymsp[-11].minor.yy104 = addWhereClause(pCxt, yymsp[-11].minor.yy104, yymsp[-7].minor.yy104);
                                                                                    yymsp[-11].minor.yy104 = addPartitionByClause(pCxt, yymsp[-11].minor.yy104, yymsp[-6].minor.yy616);
                                                                                    yymsp[-11].minor.yy104 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy104, yymsp[-2].minor.yy104);
                                                                                    yymsp[-11].minor.yy104 = addGroupByClause(pCxt, yymsp[-11].minor.yy104, yymsp[-1].minor.yy616);
                                                                                    yymsp[-11].minor.yy104 = addHavingClause(pCxt, yymsp[-11].minor.yy104, yymsp[0].minor.yy104);
                                                                                    yymsp[-11].minor.yy104 = addRangeClause(pCxt, yymsp[-11].minor.yy104, yymsp[-5].minor.yy104);
                                                                                    yymsp[-11].minor.yy104 = addEveryClause(pCxt, yymsp[-11].minor.yy104, yymsp[-4].minor.yy104);
                                                                                    yymsp[-11].minor.yy104 = addFillClause(pCxt, yymsp[-11].minor.yy104, yymsp[-3].minor.yy104);
                                                                                  }
        break;
      case 465: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy185 = false; }
        break;
      case 468: /* select_item ::= NK_STAR */
{ yylhsminor.yy104 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy104 = yylhsminor.yy104;
        break;
      case 470: /* select_item ::= common_expression column_alias */
      case 480: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==480);
{ yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104), &yymsp[0].minor.yy737); }
  yymsp[-1].minor.yy104 = yylhsminor.yy104;
        break;
      case 471: /* select_item ::= common_expression AS column_alias */
      case 481: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==481);
{ yylhsminor.yy104 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), &yymsp[0].minor.yy737); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 476: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 498: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==498);
      case 517: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==517);
{ yymsp[-2].minor.yy616 = yymsp[0].minor.yy616; }
        break;
      case 483: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy104 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
        break;
      case 484: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy104 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
        break;
      case 485: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy104 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), NULL, yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 486: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy104 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy104), releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), yymsp[-1].minor.yy104, yymsp[0].minor.yy104); }
        break;
      case 490: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy104 = createFillNode(pCxt, yymsp[-1].minor.yy246, NULL); }
        break;
      case 491: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy104 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 492: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy246 = FILL_MODE_NONE; }
        break;
      case 493: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy246 = FILL_MODE_PREV; }
        break;
      case 494: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy246 = FILL_MODE_NULL; }
        break;
      case 495: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy246 = FILL_MODE_LINEAR; }
        break;
      case 496: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy246 = FILL_MODE_NEXT; }
        break;
      case 499: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy616 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 500: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy616 = addNodeToList(pCxt, yymsp[-2].minor.yy616, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy104))); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 504: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy104 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy104), releaseRawExprNode(pCxt, yymsp[-1].minor.yy104)); }
        break;
      case 507: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy104 = addOrderByClause(pCxt, yymsp[-3].minor.yy104, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy104 = addSlimitClause(pCxt, yylhsminor.yy104, yymsp[-1].minor.yy104);
                                                                                    yylhsminor.yy104 = addLimitClause(pCxt, yylhsminor.yy104, yymsp[0].minor.yy104);
                                                                                  }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 510: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy104 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-3].minor.yy104 = yylhsminor.yy104;
        break;
      case 511: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy104 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy104, yymsp[0].minor.yy104); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 519: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 523: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==523);
{ yymsp[-1].minor.yy104 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 520: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 524: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==524);
{ yymsp[-3].minor.yy104 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 521: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 525: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==525);
{ yymsp[-3].minor.yy104 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 526: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy104 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy104); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 531: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy104 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy104), yymsp[-1].minor.yy50, yymsp[0].minor.yy793); }
  yymsp[-2].minor.yy104 = yylhsminor.yy104;
        break;
      case 532: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy50 = ORDER_ASC; }
        break;
      case 533: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy50 = ORDER_ASC; }
        break;
      case 534: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy50 = ORDER_DESC; }
        break;
      case 535: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy793 = NULL_ORDER_DEFAULT; }
        break;
      case 536: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy793 = NULL_ORDER_FIRST; }
        break;
      case 537: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy793 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
