/*
 * Copyright (c) 2019 TAOS Data, Inc. <jhtao@taosdata.com>
 *
 * This program is free software: you can use, redistribute, and/or modify
 * it under the terms of the GNU Affero General Public License, version 3
 * or later ("AGPL"), as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtest/gtest.h>
#include <taoserror.h>
#include <iostream>
#include "tglobal.h"
#pragma GCC diagnostic ignored "-Wwrite-strings"

#pragma GCC diagnostic ignored "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-variable"
#pragma GCC diagnostic ignored "-Wsign-compare"

#include "taos.h"

namespace {
}  // namespace

int main(int argc, char** argv) {
  testing::InitGoogleTest(&argc, argv);
  return RUN_ALL_TESTS();
}

TEST(testCase, driverInit_Test) {
  TAOS* pConn = taos_connect("ubuntu", "root", "taosdata", NULL, 0);
  assert(pConn != NULL);

//  TAOS_RES* pRes = taos_query(pConn, "create user abc pass 'abc'");
//  if (taos_errno(pRes) != TSDB_CODE_SUCCESS) {
//    printf("failed to create user, reason:%s\n", taos_errstr(pRes));
//  }
//
//  taos_free_result(pRes);

  TAOS_RES* pRes = taos_query(pConn, "show users");
  TAOS_ROW pRow = taos_fetch_row(pRes);
  assert(pRow != NULL);

  taos_close(pConn);
}