/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 315
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SToken yy29;
  bool yy47;
  EFillMode yy144;
  EJoinType yy162;
  SNode* yy182;
  EOrder yy218;
  SNodeList* yy334;
  EOperatorType yy380;
  ENullOrder yy487;
  SAlterOption yy515;
  int32_t yy550;
  SDataType yy574;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             548
#define YYNRULE              411
#define YYNRULE_WITH_ACTION  411
#define YYNTOKEN             209
#define YY_MAX_SHIFT         547
#define YY_MIN_SHIFTREDUCE   808
#define YY_MAX_SHIFTREDUCE   1218
#define YY_ERROR_ACTION      1219
#define YY_ACCEPT_ACTION     1220
#define YY_NO_ACTION         1221
#define YY_MIN_REDUCE        1222
#define YY_MAX_REDUCE        1632
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1539)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   450,  257, 1483,  269,   25,  194, 1432,  117,  122, 1234,
 /*    10 */   312, 1331,   30,   28, 1479, 1486,  306, 1499, 1483, 1382,
 /*    20 */   266,  462, 1053,   21, 1075,   32,   31,   29,   27,   26,
 /*    30 */  1479, 1485,   23,   32,   31,   29,   27,   26, 1051,  274,
 /*    40 */   238, 1516,   32,   31,   29,   27,   26, 1611,  446, 1073,
 /*    50 */    11,   30,   28, 1161,  348,  406, 1483, 1058,  449,  266,
 /*    60 */   131, 1053, 1470, 1320, 1609,   30,   28,  434, 1479, 1485,
 /*    70 */   430,    9,    8,  266,    1, 1053,  463, 1051,   68, 1500,
 /*    80 */  1501, 1505, 1550,  540,  539,   72,  240, 1546, 1175,   11,
 /*    90 */  1499, 1051,  369,  424,  450,  100, 1058,  544, 1611,  407,
 /*   100 */  1433, 1342, 1261,   11,   32,   31,   29,   27,   26, 1052,
 /*   110 */  1058,  131,  348,    1, 1516, 1609,   32,   31,   29,   27,
 /*   120 */    26,  433,  118, 1389,  384,  277, 1300,    1,   98,  256,
 /*   130 */  1611,  449, 1423, 1425, 1387, 1470,  544,  432,  127, 1557,
 /*   140 */  1558,  270, 1562,  131,  498, 1137, 1054, 1609, 1052,  115,
 /*   150 */   544,   69, 1500, 1501, 1505, 1550,  845, 1344,  844,  259,
 /*   160 */  1546,  126, 1052, 1057, 1077, 1078, 1104, 1105, 1106, 1107,
 /*   170 */  1108, 1109, 1110, 1111, 1112,  164,  846,  381,  380,  372,
 /*   180 */  1578,  462, 1564, 1220,   84, 1054,  132,   83,   82,   81,
 /*   190 */    80,   79,   78,   77,   76,   75,   29,   27,   26, 1054,
 /*   200 */  1561,  374, 1057, 1077, 1078, 1104, 1105, 1106, 1107, 1108,
 /*   210 */  1109, 1110, 1111, 1112, 1319,  132, 1057, 1077, 1078, 1104,
 /*   220 */  1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1318,   30,
 /*   230 */    28,  547,  305, 1564,  304,   12,  282,  266,  383, 1053,
 /*   240 */   377,  896,  132, 1215,  382,  213,  462,   97,   95,  378,
 /*   250 */   376, 1560,  379,  115,  536, 1051,  532,  528,  524,  212,
 /*   260 */   898, 1345,   32,   31,   29,   27,   26, 1611,   30,   28,
 /*   270 */   448, 1499,  463,  132, 1058,  209,  266,  498, 1053,  494,
 /*   280 */   131,  310,   30,   28, 1609,   66,   52, 1076,  206, 1074,
 /*   290 */   266,    7, 1053, 1333, 1051, 1516,   65, 1342, 1516,   96,
 /*   300 */    12,  496,  433, 1245,  334,  446,  463, 1337, 1051,  489,
 /*   310 */   101, 1214,  449, 1058,  544,  311, 1470, 1334,  459,  438,
 /*   320 */   493,  492,  491, 1185,  490, 1092, 1052, 1058,  513,  511,
 /*   330 */     7, 1342,   69, 1500, 1501, 1505, 1550,  423, 1470,  395,
 /*   340 */   259, 1546,  126, 1274,    7, 1222,  412,  132, 1470,  171,
 /*   350 */   141,  140,  393,  544,  190,  417, 1183, 1184, 1186, 1187,
 /*   360 */   413, 1577,  500, 1054, 1037, 1052,  168,  544, 1244,   93,
 /*   370 */    92,   91,   90,   89,   88,   87,   86,   85, 1327, 1052,
 /*   380 */  1057, 1077, 1078, 1104, 1105, 1106, 1107, 1108, 1109, 1110,
 /*   390 */  1111, 1112, 1079,  430, 1389,  383,   52,  377, 1611, 1329,
 /*   400 */   271,  382, 1054,  132,   97, 1387,  378,  376, 1243,  379,
 /*   410 */  1242, 1610,  405, 1470, 1241, 1609, 1054, 1338,  100, 1057,
 /*   420 */  1077, 1078, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111,
 /*   430 */  1112, 1077, 1078, 1057, 1077, 1078, 1104, 1105, 1106, 1107,
 /*   440 */  1108, 1109, 1110, 1111, 1112,  430,   30,   28,  237,  420,
 /*   450 */  1073,   98,  439, 1470,  266, 1470, 1053,  327,   59, 1470,
 /*   460 */   339,  128, 1557, 1558, 1420, 1562, 1080, 1160,  397,  340,
 /*   470 */   100,  139, 1051,   32,   31,   29,   27,   26,  437, 1335,
 /*   480 */   934,  486,  485,  484,  938,  483,  940,  941,  482,  943,
 /*   490 */   479, 1058,  949,  476,  951,  952,  473,  470, 1223, 1611,
 /*   500 */  1569, 1156, 1564,   98,  425,  421,    9,    8,    1,  463,
 /*   510 */   189,  241,  131,  129, 1557, 1558, 1609, 1562,  319,   84,
 /*   520 */  1559, 1240,   83,   82,   81,   80,   79,   78,   77,   76,
 /*   530 */    75,  544,  216, 1325, 1342, 1372, 1092,   32,   31,   29,
 /*   540 */    27,   26,  338, 1052, 1124,  333,  332,  331,  330,  329,
 /*   550 */  1239,  326,  325,  324,  323,  322,  318,  317,  316,  315,
 /*   560 */   314,  313, 1271,  137,  116,  463, 1470, 1238,  501,  222,
 /*   570 */  1314, 1389, 1389,    6,  320,   32,   31,   29,   27,   26,
 /*   580 */  1054,  220, 1424, 1388,  175, 1168,  169,  447, 1237,   50,
 /*   590 */  1342, 1075,   49, 1125,  142, 1470,  488, 1057, 1077, 1078,
 /*   600 */  1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1235,
 /*   610 */  1236, 1129, 1470,  241,  520,  519,  518,  517,  281, 1233,
 /*   620 */   516,  515,  514,  102,  509,  508,  507,  506,  505,  504,
 /*   630 */   503,  502,  108, 1470, 1232, 1499,   24,  264, 1119, 1120,
 /*   640 */  1121, 1122, 1123, 1127, 1128,  463, 1124,  463, 1231,  463,
 /*   650 */  1159,  844,  276,  463,   72, 1470,  347,   67, 1339, 1516,
 /*   660 */   115,  375,  460,  114, 1470,  279,  446,  367, 1344, 1256,
 /*   670 */  1342,  870, 1342,  115, 1342,  463,  449,  436, 1342, 1470,
 /*   680 */  1470, 1344, 1230, 1229,  461,   48,   47,  309, 1499,  136,
 /*   690 */   871,  386,  463, 1470,  303, 1125,  119, 1500, 1501, 1505,
 /*   700 */  1342,  208,  246,  297,  295, 1389,  291,  287,  133, 1301,
 /*   710 */   512,  278, 1516, 1129,  300, 1156, 1387, 1342,  299,  446,
 /*   720 */   157, 1053,  463,  155, 1499, 1228, 1227, 1470, 1470,  449,
 /*   730 */   445,  280,  132, 1470,  435, 1624, 1126, 1051,   24,  264,
 /*   740 */  1119, 1120, 1121, 1122, 1123, 1127, 1128, 1342, 1516,   69,
 /*   750 */  1500, 1501, 1505, 1550, 1130,  446, 1058,  259, 1546, 1623,
 /*   760 */  1499, 1459, 1226,  152, 1225,  449,  125,  191, 1584, 1470,
 /*   770 */  1470, 1470,  365,  343,  361,  357,  353,  151,  159,   22,
 /*   780 */   161,  158,  418,  160, 1516,   69, 1500, 1501, 1505, 1550,
 /*   790 */  1254,  446,  441,  259, 1546, 1623,  544,  289, 1217, 1218,
 /*   800 */  1383,  449,  250,   53, 1607, 1470,  149, 1470, 1052, 1470,
 /*   810 */  1499,  163,  389,  106,  162,   44,  178,  409,  404, 1182,
 /*   820 */   180,   69, 1500, 1501, 1505, 1550, 1490,  184,  164,  259,
 /*   830 */  1546, 1623,  372,  366, 1516,   33, 1580, 1499, 1488, 1131,
 /*   840 */  1568,  446,  431, 1116,  251, 1054,  249,  248, 1061,  371,
 /*   850 */  1517,  449, 1499,   33,  374, 1470,  193, 1088, 1073, 1060,
 /*   860 */   434, 1516, 1057,  148,    2,  121,   33,  145,  446,  284,
 /*   870 */  1020,  228, 1500, 1501, 1505,  288, 1516,  197,  449, 1499,
 /*   880 */   245,  199, 1470,  446,  143,   94,  273,  272,  104,  455,
 /*   890 */   896, 1611,  205,  449,  247, 1029, 1066, 1470,   70, 1500,
 /*   900 */  1501, 1505, 1550, 1516,  131,  321, 1549, 1546, 1609,  214,
 /*   910 */   446, 1422, 1059,   70, 1500, 1501, 1505, 1550,   64, 1064,
 /*   920 */   449,  444, 1546,  430, 1470,  106,  328,  442,   61,  927,
 /*   930 */  1063, 1058,   44,  468,  104,  138,  922,  955,  959,  336,
 /*   940 */    70, 1500, 1501, 1505, 1550,  335,  105,  337,  100, 1547,
 /*   950 */   965, 1084,  341,  106,  104, 1499,  342,  964,  107, 1083,
 /*   960 */   144,  345,  344, 1082,  346,  349,  147,  434,   51,  150,
 /*   970 */  1081,  464,  368,  370, 1332,  154,  373, 1328,   74, 1516,
 /*   980 */   399,   98, 1499, 1062,  400,  401,  446,  255,  408,  156,
 /*   990 */  1499,  187, 1557,  429,  170,  428,  449,  173, 1611,  109,
 /*  1000 */  1470,  110, 1330,  265, 1326,  111, 1516,  112, 1080,  411,
 /*  1010 */   419,  131, 1591,  446, 1516, 1609,  229, 1500, 1501, 1505,
 /*  1020 */  1067,  446,  398,  449,  410,  453, 1058, 1470, 1581,  416,
 /*  1030 */   414,  449,  176,  179, 1499, 1470,    5, 1070, 1590,  415,
 /*  1040 */   258,  422,  427,  233, 1500, 1501, 1505,    4,   99, 1079,
 /*  1050 */  1571,  232, 1500, 1501, 1505,  185,  183, 1156, 1516,  124,
 /*  1060 */  1565,   34,  443,  260,   17,  446, 1431, 1532, 1499,  186,
 /*  1070 */   440, 1430,  456,  457,   60,  449, 1499,  451,  458, 1470,
 /*  1080 */   452, 1499,  268,  426,  201,  203, 1343,  466,   58,  221,
 /*  1090 */  1626, 1315, 1516,  211,  192,  119, 1500, 1501, 1505,  446,
 /*  1100 */  1516, 1608,  215,  495,  217, 1516,  543,  446,  223,  449,
 /*  1110 */    40, 1464,  446, 1470,  224,  219,  263,  449, 1463,  283,
 /*  1120 */  1460, 1470,  449, 1499,  267,  285, 1470, 1047, 1499,  233,
 /*  1130 */  1500, 1501, 1505,  388, 1625,  286, 1499,  233, 1500, 1501,
 /*  1140 */  1505, 1048,  225, 1500, 1501, 1505,  290, 1516,  396, 1458,
 /*  1150 */   134,  294, 1516,  292,  446,  293, 1457,  296, 1456,  446,
 /*  1160 */  1516,  298,  166, 1447,  449,  391,  135,  446, 1470,  449,
 /*  1170 */   385,  301,  302, 1470, 1317, 1441,  165,  449, 1032, 1031,
 /*  1180 */  1499, 1470, 1440,  307,  231, 1500, 1501, 1505,  308,  234,
 /*  1190 */  1500, 1501, 1505, 1439, 1438, 1499, 1003,  226, 1500, 1501,
 /*  1200 */  1505, 1415,   42, 1414, 1516,   41, 1499, 1413, 1412, 1411,
 /*  1210 */  1410,  446, 1409, 1408, 1407, 1406, 1405, 1404, 1403, 1516,
 /*  1220 */  1402,  449, 1401, 1400,  103, 1470,  446, 1399, 1398, 1397,
 /*  1230 */  1516, 1499, 1396, 1395, 1394,  209,  449,  446, 1393,  494,
 /*  1240 */  1470,  235, 1500, 1501, 1505, 1392, 1005,  449, 1391, 1390,
 /*  1250 */  1273, 1470, 1455, 1449, 1437, 1516,  227, 1500, 1501, 1505,
 /*  1260 */  1428,  496,  446, 1321,  146, 1499, 1272,  236, 1500, 1501,
 /*  1270 */  1505, 1270,  449,  350,  352,  351, 1470,  863, 1499, 1268,
 /*  1280 */   493,  492,  491,  356,  490,  354, 1266,  355, 1264, 1516,
 /*  1290 */  1253,  359, 1513, 1500, 1501, 1505,  446,  358, 1252,  360,
 /*  1300 */   362,  363, 1516, 1249,  364, 1323,  449,  972,   73,  446,
 /*  1310 */  1470,  153, 1499,  512,  970, 1322,  895,  510,  894,  449,
 /*  1320 */  1499,  893,  892, 1470, 1262, 1499, 1512, 1500, 1501, 1505,
 /*  1330 */   252,  889,  888, 1257,  253,  387, 1516, 1255,  254,  243,
 /*  1340 */  1500, 1501, 1505,  446, 1516,  390, 1248,  392, 1247, 1516,
 /*  1350 */   394,  446,   71,  449, 1454,  167,  446, 1470, 1039, 1448,
 /*  1360 */   402,  449,  113, 1436, 1435, 1470,  449, 1499, 1427,   54,
 /*  1370 */  1470,  123, 1499, 1511, 1500, 1501, 1505,  172,   14,   43,
 /*  1380 */     3,  244, 1500, 1501, 1505,   33,  242, 1500, 1501, 1505,
 /*  1390 */    38, 1516,  177, 1181,   15,  403, 1516,  120,  446, 1488,
 /*  1400 */   174,  181,   37,  446,   19,   56, 1174,  182,  449,   55,
 /*  1410 */    20, 1203, 1470,  449,   36, 1153, 1152, 1470,   16, 1208,
 /*  1420 */  1202,   35,  261, 1207, 1206,  262,    8,   13,  239, 1500,
 /*  1430 */  1501, 1505, 1090,  230, 1500, 1501, 1505,  188,  130, 1117,
 /*  1440 */  1089,  195,  196,   18, 1426, 1179,  198,  454,   10,  200,
 /*  1450 */    45,  202,   57, 1068,  204,   61,  956,   39,  467,  275,
 /*  1460 */  1487,  471,  469,  207,  465,  953,  472,  474,  950,  475,
 /*  1470 */   477,  944,  478,  480,  942,  933,  481,   62,  967,  948,
 /*  1480 */    46,   63,  961,  963,  487,  861,  497,  902,  947,  499,
 /*  1490 */   946,  877,  884,  945,  883,  882,  210,  881,  899,  880,
 /*  1500 */   879,  878,  897,  874,  873,  872,  869, 1269,  868,  966,
 /*  1510 */   867,  866,  521,  522,  523, 1267,  525,  526,  527, 1265,
 /*  1520 */   529,  530,  531, 1263,  533,  534,  535, 1251,  537,  538,
 /*  1530 */  1250, 1246,  541,  542, 1221, 1055,  218,  545,  546,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   253,  240,  257,  256,  278,  279,  259,  211,  235,  213,
 /*    10 */   218,  237,   12,   13,  269,  270,  262,  212,  257,  246,
 /*    20 */    20,   20,   22,    2,   20,   12,   13,   14,   15,   16,
 /*    30 */   269,  270,    2,   12,   13,   14,   15,   16,   38,  240,
 /*    40 */   248,  236,   12,   13,   14,   15,   16,  293,  243,   20,
 /*    50 */    50,   12,   13,   14,   49,  218,  257,   57,  253,   20,
 /*    60 */   306,   22,  257,    0,  310,   12,   13,  262,  269,  270,
 /*    70 */   218,    1,    2,   20,   74,   22,  218,   38,  273,  274,
 /*    80 */   275,  276,  277,  215,  216,  227,  281,  282,   75,   50,
 /*    90 */   212,   38,  234,   20,  253,  243,   57,   97,  293,  262,
 /*   100 */   259,  243,    0,   50,   12,   13,   14,   15,   16,  109,
 /*   110 */    57,  306,   49,   74,  236,  310,   12,   13,   14,   15,
 /*   120 */    16,  243,  221,  236,   22,  245,  225,   74,  276,  242,
 /*   130 */   293,  253,  252,  253,  247,  257,   97,  285,  286,  287,
 /*   140 */   288,  228,  290,  306,   49,   75,  146,  310,  109,  236,
 /*   150 */    97,  273,  274,  275,  276,  277,   20,  244,   22,  281,
 /*   160 */   282,  283,  109,  163,  164,  165,  166,  167,  168,  169,
 /*   170 */   170,  171,  172,  173,  174,   61,   40,  222,  223,   65,
 /*   180 */   302,   20,  271,  209,   21,  146,  186,   24,   25,   26,
 /*   190 */    27,   28,   29,   30,   31,   32,   14,   15,   16,  146,
 /*   200 */   289,   87,  163,  164,  165,  166,  167,  168,  169,  170,
 /*   210 */   171,  172,  173,  174,    0,  186,  163,  164,  165,  166,
 /*   220 */   167,  168,  169,  170,  171,  172,  173,  174,    0,   12,
 /*   230 */    13,   19,  145,  271,  147,   74,  262,   20,   52,   22,
 /*   240 */    54,   38,  186,  139,   58,   33,   20,   61,   36,   63,
 /*   250 */    64,  289,   66,  236,   42,   38,   44,   45,   46,   47,
 /*   260 */    57,  244,   12,   13,   14,   15,   16,  293,   12,   13,
 /*   270 */    14,  212,  218,  186,   57,   61,   20,   49,   22,   65,
 /*   280 */   306,  227,   12,   13,  310,   73,  220,   20,   76,   20,
 /*   290 */    20,   74,   22,  212,   38,  236,  217,  243,  236,  233,
 /*   300 */    74,   87,  243,  212,   67,  243,  218,  241,   38,   85,
 /*   310 */   231,  207,  253,   57,   97,  227,  257,  238,  106,   71,
 /*   320 */   106,  107,  108,  163,  110,   75,  109,   57,  222,  223,
 /*   330 */    74,  243,  273,  274,  275,  276,  277,  275,  257,   21,
 /*   340 */   281,  282,  283,    0,   74,    0,  134,  186,  257,  137,
 /*   350 */   113,  114,   34,   97,  295,  195,  196,  197,  198,  199,
 /*   360 */   301,  302,   57,  146,  152,  109,  154,   97,  212,   24,
 /*   370 */    25,   26,   27,   28,   29,   30,   31,   32,  237,  109,
 /*   380 */   163,  164,  165,  166,  167,  168,  169,  170,  171,  172,
 /*   390 */   173,  174,   20,  218,  236,   52,  220,   54,  293,  237,
 /*   400 */   242,   58,  146,  186,   61,  247,   63,   64,  212,   66,
 /*   410 */   212,  306,  265,  257,  212,  310,  146,  241,  243,  163,
 /*   420 */   164,  165,  166,  167,  168,  169,  170,  171,  172,  173,
 /*   430 */   174,  164,  165,  163,  164,  165,  166,  167,  168,  169,
 /*   440 */   170,  171,  172,  173,  174,  218,   12,   13,   18,  136,
 /*   450 */    20,  276,  204,  257,   20,  257,   22,   27,  217,  257,
 /*   460 */    30,  286,  287,  288,  243,  290,   20,    4,  262,   39,
 /*   470 */   243,  250,   38,   12,   13,   14,   15,   16,    3,  238,
 /*   480 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   490 */    98,   57,  100,  101,  102,  103,  104,  105,    0,  293,
 /*   500 */   184,  185,  271,  276,  191,  192,    1,    2,   74,  218,
 /*   510 */   138,   50,  306,  286,  287,  288,  310,  290,  227,   21,
 /*   520 */   289,  212,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   530 */    32,   97,  229,  237,  243,  232,   75,   12,   13,   14,
 /*   540 */    15,   16,  112,  109,   83,  115,  116,  117,  118,  119,
 /*   550 */   212,  121,  122,  123,  124,  125,  126,  127,  128,  129,
 /*   560 */   130,  131,    0,   47,   18,  218,  257,  212,  224,   23,
 /*   570 */   226,  236,  236,   43,  227,   12,   13,   14,   15,   16,
 /*   580 */   146,   35,  247,  247,  138,   14,  237,  237,  212,   73,
 /*   590 */   243,   20,   76,  132,   48,  257,  237,  163,  164,  165,
 /*   600 */   166,  167,  168,  169,  170,  171,  172,  173,  174,  213,
 /*   610 */   212,  150,  257,   50,   52,   53,   54,   55,   56,  212,
 /*   620 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   630 */    68,   69,   70,  257,  212,  212,  175,  176,  177,  178,
 /*   640 */   179,  180,  181,  182,  183,  218,   83,  218,  212,  218,
 /*   650 */   187,   22,  228,  218,  227,  257,  227,  111,  227,  236,
 /*   660 */   236,  234,  227,  138,  257,  228,  243,   38,  244,    0,
 /*   670 */   243,   38,  243,  236,  243,  218,  253,  202,  243,  257,
 /*   680 */   257,  244,  212,  212,  227,  139,  140,  141,  212,  143,
 /*   690 */    57,   22,  218,  257,  148,  132,  273,  274,  275,  276,
 /*   700 */   243,  227,  156,  142,  158,  236,  160,  161,  162,  225,
 /*   710 */    71,  242,  236,  150,   75,  185,  247,  243,  157,  243,
 /*   720 */    78,   22,  218,   81,  212,  212,  212,  257,  257,  253,
 /*   730 */    50,  227,  186,  257,  311,  312,  132,   38,  175,  176,
 /*   740 */   177,  178,  179,  180,  181,  182,  183,  243,  236,  273,
 /*   750 */   274,  275,  276,  277,  150,  243,   57,  281,  282,  283,
 /*   760 */   212,    0,  212,   33,  212,  253,   36,  313,  292,  257,
 /*   770 */   257,  257,   42,  253,   44,   45,   46,   47,   78,  175,
 /*   780 */    78,   81,  304,   81,  236,  273,  274,  275,  276,  277,
 /*   790 */     0,  243,   71,  281,  282,  283,   97,   36,  164,  165,
 /*   800 */   246,  253,   35,   73,  292,  257,   76,  257,  109,  257,
 /*   810 */   212,   78,   22,   71,   81,   71,   71,   75,  253,   75,
 /*   820 */    75,  273,  274,  275,  276,  277,   74,  298,   61,  281,
 /*   830 */   282,  283,   65,  215,  236,   71,  272,  212,   86,   75,
 /*   840 */   292,  243,  291,  163,   77,  146,   79,   80,   38,   82,
 /*   850 */   236,  253,  212,   71,   87,  257,  307,   75,   20,   38,
 /*   860 */   262,  236,  163,  133,  294,  135,   71,  137,  243,  218,
 /*   870 */    75,  273,  274,  275,  276,   36,  236,   71,  253,  212,
 /*   880 */   268,   75,  257,  243,  154,   71,   12,   13,   71,   75,
 /*   890 */    38,  293,   75,  253,  222,  144,   22,  257,  273,  274,
 /*   900 */   275,  276,  277,  236,  306,  218,  281,  282,  310,  263,
 /*   910 */   243,  218,   38,  273,  274,  275,  276,  277,   74,  109,
 /*   920 */   253,  281,  282,  218,  257,   71,  251,  206,   84,   75,
 /*   930 */   109,   57,   71,   71,   71,  120,   75,   75,   75,  132,
 /*   940 */   273,  274,  275,  276,  277,  249,   71,  249,  243,  282,
 /*   950 */    75,   20,  218,   71,   71,  212,  267,   75,   75,   20,
 /*   960 */   220,  243,  261,   20,  254,  218,  220,  262,  220,  220,
 /*   970 */    20,   97,  214,  236,  236,  236,  222,  236,  218,  236,
 /*   980 */   267,  276,  212,  109,  153,  266,  243,  214,  261,  236,
 /*   990 */   212,  286,  287,  288,  217,  290,  253,  217,  293,  236,
 /*  1000 */   257,  236,  236,  260,  236,  236,  236,  236,   20,  254,
 /*  1010 */   194,  306,  303,  243,  236,  310,  273,  274,  275,  276,
 /*  1020 */   146,  243,  243,  253,  243,  193,   57,  257,  272,  257,
 /*  1030 */   260,  253,  258,  258,  212,  257,  201,  163,  303,  189,
 /*  1040 */   257,  257,  200,  273,  274,  275,  276,  188,  243,   20,
 /*  1050 */   300,  273,  274,  275,  276,  296,  299,  185,  236,  297,
 /*  1060 */   271,  120,  205,  208,   74,  243,  258,  280,  212,  284,
 /*  1070 */   203,  258,  135,  255,   74,  253,  212,  257,  254,  257,
 /*  1080 */   257,  212,  257,  305,  243,  217,  243,  239,  217,  210,
 /*  1090 */   314,  226,  236,  217,  308,  273,  274,  275,  276,  243,
 /*  1100 */   236,  309,  232,  222,  218,  236,  214,  243,  230,  253,
 /*  1110 */   264,    0,  243,  257,  230,  219,  260,  253,    0,   64,
 /*  1120 */     0,  257,  253,  212,  260,   38,  257,   38,  212,  273,
 /*  1130 */   274,  275,  276,    4,  312,  159,  212,  273,  274,  275,
 /*  1140 */   276,   38,  273,  274,  275,  276,  159,  236,   19,    0,
 /*  1150 */    38,  159,  236,   38,  243,   38,    0,   38,    0,  243,
 /*  1160 */   236,   38,   33,    0,  253,   36,   74,  243,  257,  253,
 /*  1170 */    41,  150,  149,  257,    0,    0,   47,  253,  109,  146,
 /*  1180 */   212,  257,    0,   53,  273,  274,  275,  276,  142,  273,
 /*  1190 */   274,  275,  276,    0,    0,  212,   86,  273,  274,  275,
 /*  1200 */   276,    0,   73,    0,  236,   76,  212,    0,    0,    0,
 /*  1210 */     0,  243,    0,    0,    0,    0,    0,    0,    0,  236,
 /*  1220 */     0,  253,    0,    0,  120,  257,  243,    0,    0,    0,
 /*  1230 */   236,  212,    0,    0,    0,   61,  253,  243,    0,   65,
 /*  1240 */   257,  273,  274,  275,  276,    0,   22,  253,    0,    0,
 /*  1250 */     0,  257,    0,    0,    0,  236,  273,  274,  275,  276,
 /*  1260 */     0,   87,  243,    0,   43,  212,    0,  273,  274,  275,
 /*  1270 */   276,    0,  253,   38,   43,   36,  257,   51,  212,    0,
 /*  1280 */   106,  107,  108,   43,  110,   38,    0,   36,    0,  236,
 /*  1290 */     0,   36,  273,  274,  275,  276,  243,   38,    0,   43,
 /*  1300 */    38,   36,  236,    0,   43,    0,  253,   38,   83,  243,
 /*  1310 */   257,   81,  212,   71,   22,    0,   38,   71,   38,  253,
 /*  1320 */   212,   38,   38,  257,    0,  212,  273,  274,  275,  276,
 /*  1330 */    22,   38,   38,    0,   22,   39,  236,    0,   22,  273,
 /*  1340 */   274,  275,  276,  243,  236,   38,    0,   22,    0,  236,
 /*  1350 */    22,  243,   20,  253,    0,  155,  243,  257,   38,    0,
 /*  1360 */    22,  253,  151,    0,    0,  257,  253,  212,    0,   74,
 /*  1370 */   257,  135,  212,  273,  274,  275,  276,   43,  190,  138,
 /*  1380 */    71,  273,  274,  275,  276,   71,  273,  274,  275,  276,
 /*  1390 */    71,  236,   75,   75,  190,  138,  236,   74,  243,   86,
 /*  1400 */   133,   74,  138,  243,   74,    4,   75,   71,  253,   74,
 /*  1410 */    71,   38,  257,  253,   71,   75,   75,  257,   71,   75,
 /*  1420 */    38,  184,   38,   38,   38,   38,    2,   74,  273,  274,
 /*  1430 */   275,  276,   75,  273,  274,  275,  276,   86,   86,  163,
 /*  1440 */    75,   86,   75,   74,    0,   75,   74,  136,  190,   74,
 /*  1450 */    74,   43,   74,   22,  133,   84,   75,   74,   38,   38,
 /*  1460 */    86,   38,   74,   86,   85,   75,   74,   38,   75,   74,
 /*  1470 */    38,   75,   74,   38,   75,   22,   74,   74,   38,   99,
 /*  1480 */    74,   74,   22,   38,   87,   51,   50,   57,   99,   72,
 /*  1490 */    99,   22,   38,   99,   38,   38,   71,   38,   57,   38,
 /*  1500 */    38,   38,   38,   38,   38,   38,   38,    0,   38,  109,
 /*  1510 */    38,   38,   38,   36,   43,    0,   38,   36,   43,    0,
 /*  1520 */    38,   36,   43,    0,   38,   36,   43,    0,   38,   37,
 /*  1530 */     0,    0,   22,   21,  315,   22,   22,   21,   20,  315,
 /*  1540 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1550 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1560 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1570 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1580 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1590 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1600 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1610 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1620 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1630 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1640 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1650 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1660 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1670 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1680 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1690 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1700 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1710 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1720 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1730 */   315,  315,  315,  315,  315,  315,  315,  315,  315,  315,
 /*  1740 */   315,  315,  315,  315,  315,  315,  315,  315,
};
#define YY_SHIFT_COUNT    (547)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1531)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   546,    0,   39,   53,   53,   53,   53,  217,   53,   53,
 /*    10 */   270,  434,  161,  256,  270,  270,  270,  270,  270,  270,
 /*    20 */   270,  270,  270,  270,  270,  270,  270,  270,  270,  270,
 /*    30 */   270,  270,  270,  270,  226,  226,  226,   29,  874,  874,
 /*    40 */    87,    1,    1,   56,  874,  267,  267,    1,    1,    1,
 /*    50 */     1,    1,    1,    5,    4,   73,   56,    4,    1,    1,
 /*    60 */     4,    1,    4,    4,    4,    1,   95,  430,  461,  563,
 /*    70 */   563,  163,  767,  699,  186,  699,  699,  699,  699,  699,
 /*    80 */   699,  699,  699,  699,  699,  699,  699,  699,  699,  699,
 /*    90 */   699,  699,  699,  699,  267,  136,   63,  203,  372,  372,
 /*   100 */   372,  228,  203,  269,    4,    4,    4,  224,  305,  392,
 /*   110 */   392,  392,  392,  392,  392,  392,  212,  498,  343,  104,
 /*   120 */   160,  267,  114,  267,  313,  629,  446,  316,  530,  316,
 /*   130 */   571,  475,  463,  838,  839,  852,  751,  838,  838,  815,
 /*   140 */   807,  807,  838,  931,  939,    5,  269,  943,    5,    5,
 /*   150 */   838,    5,  950,    4,    4,    4,    4,    4,    4,    4,
 /*   160 */     4,    4,    4,    4,  852,  838,  950,  269,  931,  831,
 /*   170 */   939,   95,  269,  943,   95,  988,  816,  832,  969,  816,
 /*   180 */   832,  969,  969,  835,  842,  850,  859,  872,  269, 1029,
 /*   190 */   941,  855,  857,  867,  990,    4,  832,  969,  969,  832,
 /*   200 */   969,  937,  269,  943,   95,  224,   95,  269, 1000,  852,
 /*   210 */   305,  838,   95,  950, 1539, 1539, 1539, 1539, 1539,  562,
 /*   220 */   730,  345, 1129,  214, 1174,   13,   21,   30,  250,  525,
 /*   230 */    92,   92,   92,   92,   92,   92,   92,  516,  237,  182,
 /*   240 */    70,  604,  182,  182,  182,  761,  561,  639,  642,  700,
 /*   250 */   702,  733,  102,  669,  790,  318,  742,  744,  745,  505,
 /*   260 */   634,  248,  721,  764,  680,  782,  752,  795,  806,  814,
 /*   270 */   817,  854,  810,  821,  861,  862,  863,  875,  882,  883,
 /*   280 */   844,  633, 1111, 1118, 1055, 1120, 1087,  976, 1089, 1103,
 /*   290 */  1112,  987, 1149, 1115, 1117,  992, 1156, 1119, 1158, 1123,
 /*   300 */  1163, 1092, 1021, 1023, 1069, 1033, 1175, 1182, 1130, 1046,
 /*   310 */  1193, 1194, 1110, 1201, 1203, 1207, 1208, 1209, 1210, 1212,
 /*   320 */  1213, 1214, 1215, 1216, 1217, 1218, 1220, 1222, 1223, 1104,
 /*   330 */  1227, 1228, 1229, 1232, 1233, 1234, 1224, 1238, 1245, 1248,
 /*   340 */  1249, 1250, 1252, 1253, 1254, 1260, 1221, 1263, 1226, 1266,
 /*   350 */  1271, 1235, 1239, 1231, 1279, 1247, 1251, 1240, 1286, 1259,
 /*   360 */  1255, 1256, 1288, 1262, 1265, 1261, 1290, 1298, 1303, 1305,
 /*   370 */  1225, 1230, 1269, 1242, 1292, 1315, 1278, 1280, 1283, 1284,
 /*   380 */  1246, 1242, 1293, 1294, 1324, 1308, 1333, 1312, 1296, 1337,
 /*   390 */  1316, 1307, 1346, 1325, 1348, 1328, 1332, 1354, 1241, 1200,
 /*   400 */  1320, 1359, 1211, 1338, 1257, 1236, 1363, 1364, 1264, 1368,
 /*   410 */  1295, 1334, 1267, 1309, 1314, 1188, 1317, 1319, 1318, 1323,
 /*   420 */  1327, 1330, 1331, 1336, 1313, 1335, 1339, 1204, 1340, 1341,
 /*   430 */  1351, 1237, 1343, 1352, 1344, 1347, 1258, 1401, 1373, 1382,
 /*   440 */  1384, 1385, 1386, 1387, 1424, 1276, 1355, 1357, 1365, 1353,
 /*   450 */  1369, 1367, 1370, 1372, 1375, 1311, 1376, 1444, 1408, 1321,
 /*   460 */  1378, 1371, 1374, 1377, 1431, 1383, 1379, 1381, 1420, 1421,
 /*   470 */  1388, 1390, 1423, 1392, 1393, 1429, 1395, 1396, 1432, 1398,
 /*   480 */  1399, 1435, 1402, 1380, 1389, 1391, 1394, 1453, 1397, 1403,
 /*   490 */  1440, 1400, 1406, 1407, 1445, 1242, 1460, 1434, 1436, 1430,
 /*   500 */  1417, 1425, 1454, 1456, 1457, 1459, 1461, 1462, 1463, 1469,
 /*   510 */  1441, 1246, 1464, 1242, 1465, 1466, 1467, 1468, 1470, 1472,
 /*   520 */  1473, 1507, 1474, 1477, 1471, 1515, 1478, 1481, 1475, 1519,
 /*   530 */  1482, 1485, 1479, 1523, 1486, 1489, 1483, 1527, 1490, 1492,
 /*   540 */  1530, 1531, 1510, 1512, 1513, 1514, 1516, 1518,
};
#define YY_REDUCE_COUNT (218)
#define YY_REDUCE_MIN   (-274)
#define YY_REDUCE_MAX   (1160)
static const short yy_reduce_ofst[] = {
 /*     0 */   -26, -195,   59, -122,  476,  512,  548,  598,  625,  640,
 /*    10 */   423,  667,  705,  743,  770,  778,  822,  856,  864,  869,
 /*    20 */   911,  916,  924,  968,  983,  994, 1019, 1053, 1066, 1100,
 /*    30 */  1108, 1113, 1155, 1160, -148,  175,  227, -163, -239, -201,
 /*    40 */  -246, -142,  427,  206, -255, -253, -120,   54,   88,  291,
 /*    50 */   347,  429,  431,   66, -113,   62,  105,  -87,  435,  457,
 /*    60 */   158,  474,  424,  469,  437,  504,   79, -208, -274, -274,
 /*    70 */  -274, -204, -227,   81,  -99,   91,  156,  196,  198,  202,
 /*    80 */   309,  338,  355,  376,  398,  407,  422,  436,  470,  471,
 /*    90 */   513,  514,  550,  552, -159, -132,  176,  -45,  -89,  -38,
 /*   100 */   231,  241,  106,  221,   17,  335,  336,  303,  344, -226,
 /*   110 */   141,  162,  296,  349,  350,  359,  147,  396,  484,  454,
 /*   120 */   478,  520,  554,  565,  529,  618,  564,  551,  551,  551,
 /*   130 */   614,  549,  570,  651,  612,  672,  646,  687,  693,  675,
 /*   140 */   696,  698,  734,  689,  701,  740,  718,  710,  746,  748,
 /*   150 */   747,  749,  758,  737,  738,  739,  741,  753,  763,  765,
 /*   160 */   766,  768,  769,  771,  754,  760,  773,  779,  713,  719,
 /*   170 */   727,  777,  781,  755,  780,  756,  709,  774,  772,  735,
 /*   180 */   775,  783,  784,  750,  757,  762,  759,  551,  805,  789,
 /*   190 */   785,  776,  792,  786,  787,  614,  808,  820,  823,  813,
 /*   200 */   825,  818,  841,  824,  868,  870,  871,  843,  848,  881,
 /*   210 */   865,  886,  876,  892,  846,  878,  884,  896,  879,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    10 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    20 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    30 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    40 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    50 */  1219, 1219, 1219, 1278, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    60 */  1219, 1219, 1219, 1219, 1219, 1219, 1276, 1416, 1219, 1552,
 /*    70 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    80 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*    90 */  1219, 1219, 1219, 1219, 1219, 1219, 1278, 1219, 1563, 1563,
 /*   100 */  1563, 1276, 1219, 1219, 1219, 1219, 1219, 1371, 1219, 1219,
 /*   110 */  1219, 1219, 1219, 1219, 1219, 1219, 1450, 1219, 1219, 1627,
 /*   120 */  1219, 1219, 1324, 1219, 1587, 1219, 1579, 1555, 1569, 1556,
 /*   130 */  1219, 1612, 1572, 1219, 1219, 1219, 1442, 1219, 1219, 1421,
 /*   140 */  1418, 1418, 1219, 1219, 1219, 1278, 1219, 1219, 1278, 1278,
 /*   150 */  1219, 1278, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   160 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1452,
 /*   170 */  1219, 1276, 1219, 1219, 1276, 1219, 1594, 1592, 1219, 1594,
 /*   180 */  1592, 1219, 1219, 1606, 1602, 1585, 1583, 1569, 1219, 1219,
 /*   190 */  1219, 1630, 1618, 1614, 1219, 1219, 1592, 1219, 1219, 1592,
 /*   200 */  1219, 1429, 1219, 1219, 1276, 1219, 1276, 1219, 1340, 1219,
 /*   210 */  1219, 1219, 1276, 1219, 1444, 1374, 1374, 1279, 1224, 1219,
 /*   220 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1514,
 /*   230 */  1515, 1605, 1604, 1514, 1529, 1528, 1527, 1219, 1219, 1509,
 /*   240 */  1219, 1219, 1510, 1508, 1507, 1219, 1219, 1219, 1219, 1219,
 /*   250 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1553,
 /*   260 */  1219, 1615, 1619, 1219, 1219, 1219, 1489, 1219, 1219, 1219,
 /*   270 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   280 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   290 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   300 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   310 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   320 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   330 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   340 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   350 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   360 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   370 */  1219, 1219, 1219, 1385, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   380 */  1305, 1304, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   390 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   400 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   410 */  1219, 1219, 1219, 1576, 1586, 1219, 1219, 1219, 1219, 1219,
 /*   420 */  1219, 1219, 1219, 1219, 1489, 1219, 1603, 1219, 1562, 1558,
 /*   430 */  1219, 1219, 1554, 1219, 1219, 1613, 1219, 1219, 1219, 1219,
 /*   440 */  1219, 1219, 1219, 1219, 1548, 1219, 1219, 1219, 1219, 1219,
 /*   450 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   460 */  1219, 1219, 1488, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   470 */  1368, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   480 */  1219, 1219, 1219, 1353, 1351, 1350, 1349, 1219, 1346, 1219,
 /*   490 */  1219, 1219, 1219, 1219, 1219, 1376, 1219, 1219, 1219, 1219,
 /*   500 */  1219, 1299, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   510 */  1219, 1290, 1219, 1289, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   520 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   530 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
 /*   540 */  1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "NK_COMMA",
  /*   72 */ "NK_COLON",
  /*   73 */ "TABLE",
  /*   74 */ "NK_LP",
  /*   75 */ "NK_RP",
  /*   76 */ "STABLE",
  /*   77 */ "ADD",
  /*   78 */ "COLUMN",
  /*   79 */ "MODIFY",
  /*   80 */ "RENAME",
  /*   81 */ "TAG",
  /*   82 */ "SET",
  /*   83 */ "NK_EQ",
  /*   84 */ "USING",
  /*   85 */ "TAGS",
  /*   86 */ "NK_DOT",
  /*   87 */ "COMMENT",
  /*   88 */ "BOOL",
  /*   89 */ "TINYINT",
  /*   90 */ "SMALLINT",
  /*   91 */ "INT",
  /*   92 */ "INTEGER",
  /*   93 */ "BIGINT",
  /*   94 */ "FLOAT",
  /*   95 */ "DOUBLE",
  /*   96 */ "BINARY",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "NCHAR",
  /*   99 */ "UNSIGNED",
  /*  100 */ "JSON",
  /*  101 */ "VARCHAR",
  /*  102 */ "MEDIUMBLOB",
  /*  103 */ "BLOB",
  /*  104 */ "VARBINARY",
  /*  105 */ "DECIMAL",
  /*  106 */ "SMA",
  /*  107 */ "ROLLUP",
  /*  108 */ "FILE_FACTOR",
  /*  109 */ "NK_FLOAT",
  /*  110 */ "DELAY",
  /*  111 */ "SHOW",
  /*  112 */ "DATABASES",
  /*  113 */ "TABLES",
  /*  114 */ "STABLES",
  /*  115 */ "MNODES",
  /*  116 */ "MODULES",
  /*  117 */ "QNODES",
  /*  118 */ "FUNCTIONS",
  /*  119 */ "INDEXES",
  /*  120 */ "FROM",
  /*  121 */ "ACCOUNTS",
  /*  122 */ "APPS",
  /*  123 */ "CONNECTIONS",
  /*  124 */ "LICENCE",
  /*  125 */ "GRANTS",
  /*  126 */ "QUERIES",
  /*  127 */ "SCORES",
  /*  128 */ "TOPICS",
  /*  129 */ "VARIABLES",
  /*  130 */ "BNODES",
  /*  131 */ "SNODES",
  /*  132 */ "LIKE",
  /*  133 */ "INDEX",
  /*  134 */ "FULLTEXT",
  /*  135 */ "FUNCTION",
  /*  136 */ "INTERVAL",
  /*  137 */ "TOPIC",
  /*  138 */ "AS",
  /*  139 */ "DESC",
  /*  140 */ "DESCRIBE",
  /*  141 */ "RESET",
  /*  142 */ "QUERY",
  /*  143 */ "EXPLAIN",
  /*  144 */ "ANALYZE",
  /*  145 */ "VERBOSE",
  /*  146 */ "NK_BOOL",
  /*  147 */ "RATIO",
  /*  148 */ "COMPACT",
  /*  149 */ "VNODES",
  /*  150 */ "IN",
  /*  151 */ "OUTPUTTYPE",
  /*  152 */ "AGGREGATE",
  /*  153 */ "BUFSIZE",
  /*  154 */ "STREAM",
  /*  155 */ "INTO",
  /*  156 */ "KILL",
  /*  157 */ "CONNECTION",
  /*  158 */ "MERGE",
  /*  159 */ "VGROUP",
  /*  160 */ "REDISTRIBUTE",
  /*  161 */ "SPLIT",
  /*  162 */ "SYNCDB",
  /*  163 */ "NULL",
  /*  164 */ "FIRST",
  /*  165 */ "LAST",
  /*  166 */ "NOW",
  /*  167 */ "TODAY",
  /*  168 */ "ROWTS",
  /*  169 */ "TBNAME",
  /*  170 */ "QSTARTTS",
  /*  171 */ "QENDTS",
  /*  172 */ "WSTARTTS",
  /*  173 */ "WENDTS",
  /*  174 */ "WDURATION",
  /*  175 */ "BETWEEN",
  /*  176 */ "IS",
  /*  177 */ "NK_LT",
  /*  178 */ "NK_GT",
  /*  179 */ "NK_LE",
  /*  180 */ "NK_GE",
  /*  181 */ "NK_NE",
  /*  182 */ "MATCH",
  /*  183 */ "NMATCH",
  /*  184 */ "JOIN",
  /*  185 */ "INNER",
  /*  186 */ "SELECT",
  /*  187 */ "DISTINCT",
  /*  188 */ "WHERE",
  /*  189 */ "PARTITION",
  /*  190 */ "BY",
  /*  191 */ "SESSION",
  /*  192 */ "STATE_WINDOW",
  /*  193 */ "SLIDING",
  /*  194 */ "FILL",
  /*  195 */ "VALUE",
  /*  196 */ "NONE",
  /*  197 */ "PREV",
  /*  198 */ "LINEAR",
  /*  199 */ "NEXT",
  /*  200 */ "GROUP",
  /*  201 */ "HAVING",
  /*  202 */ "ORDER",
  /*  203 */ "SLIMIT",
  /*  204 */ "SOFFSET",
  /*  205 */ "LIMIT",
  /*  206 */ "OFFSET",
  /*  207 */ "ASC",
  /*  208 */ "NULLS",
  /*  209 */ "cmd",
  /*  210 */ "account_options",
  /*  211 */ "alter_account_options",
  /*  212 */ "literal",
  /*  213 */ "alter_account_option",
  /*  214 */ "user_name",
  /*  215 */ "dnode_endpoint",
  /*  216 */ "dnode_host_name",
  /*  217 */ "not_exists_opt",
  /*  218 */ "db_name",
  /*  219 */ "db_options",
  /*  220 */ "exists_opt",
  /*  221 */ "alter_db_options",
  /*  222 */ "integer_list",
  /*  223 */ "variable_list",
  /*  224 */ "retention_list",
  /*  225 */ "alter_db_option",
  /*  226 */ "retention",
  /*  227 */ "full_table_name",
  /*  228 */ "column_def_list",
  /*  229 */ "tags_def_opt",
  /*  230 */ "table_options",
  /*  231 */ "multi_create_clause",
  /*  232 */ "tags_def",
  /*  233 */ "multi_drop_clause",
  /*  234 */ "alter_table_clause",
  /*  235 */ "alter_table_options",
  /*  236 */ "column_name",
  /*  237 */ "type_name",
  /*  238 */ "create_subtable_clause",
  /*  239 */ "specific_tags_opt",
  /*  240 */ "literal_list",
  /*  241 */ "drop_table_clause",
  /*  242 */ "col_name_list",
  /*  243 */ "table_name",
  /*  244 */ "column_def",
  /*  245 */ "func_name_list",
  /*  246 */ "alter_table_option",
  /*  247 */ "col_name",
  /*  248 */ "db_name_cond_opt",
  /*  249 */ "like_pattern_opt",
  /*  250 */ "table_name_cond",
  /*  251 */ "from_db_opt",
  /*  252 */ "func_name",
  /*  253 */ "function_name",
  /*  254 */ "index_name",
  /*  255 */ "index_options",
  /*  256 */ "func_list",
  /*  257 */ "duration_literal",
  /*  258 */ "sliding_opt",
  /*  259 */ "func",
  /*  260 */ "expression_list",
  /*  261 */ "topic_name",
  /*  262 */ "query_expression",
  /*  263 */ "analyze_opt",
  /*  264 */ "explain_options",
  /*  265 */ "agg_func_opt",
  /*  266 */ "bufsize_opt",
  /*  267 */ "stream_name",
  /*  268 */ "dnode_list",
  /*  269 */ "signed",
  /*  270 */ "signed_literal",
  /*  271 */ "table_alias",
  /*  272 */ "column_alias",
  /*  273 */ "expression",
  /*  274 */ "pseudo_column",
  /*  275 */ "column_reference",
  /*  276 */ "subquery",
  /*  277 */ "predicate",
  /*  278 */ "compare_op",
  /*  279 */ "in_op",
  /*  280 */ "in_predicate_value",
  /*  281 */ "boolean_value_expression",
  /*  282 */ "boolean_primary",
  /*  283 */ "common_expression",
  /*  284 */ "from_clause",
  /*  285 */ "table_reference_list",
  /*  286 */ "table_reference",
  /*  287 */ "table_primary",
  /*  288 */ "joined_table",
  /*  289 */ "alias_opt",
  /*  290 */ "parenthesized_joined_table",
  /*  291 */ "join_type",
  /*  292 */ "search_condition",
  /*  293 */ "query_specification",
  /*  294 */ "set_quantifier_opt",
  /*  295 */ "select_list",
  /*  296 */ "where_clause_opt",
  /*  297 */ "partition_by_clause_opt",
  /*  298 */ "twindow_clause_opt",
  /*  299 */ "group_by_clause_opt",
  /*  300 */ "having_clause_opt",
  /*  301 */ "select_sublist",
  /*  302 */ "select_item",
  /*  303 */ "fill_opt",
  /*  304 */ "fill_mode",
  /*  305 */ "group_by_list",
  /*  306 */ "query_expression_body",
  /*  307 */ "order_by_clause_opt",
  /*  308 */ "slimit_clause_opt",
  /*  309 */ "limit_clause_opt",
  /*  310 */ "query_primary",
  /*  311 */ "sort_specification_list",
  /*  312 */ "sort_specification",
  /*  313 */ "ordering_specification_opt",
  /*  314 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "alter_db_options ::= alter_db_option",
 /*  79 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  80 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  81 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  82 */ "alter_db_option ::= KEEP integer_list",
 /*  83 */ "alter_db_option ::= KEEP variable_list",
 /*  84 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  85 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  86 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  87 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  88 */ "integer_list ::= NK_INTEGER",
 /*  89 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  90 */ "variable_list ::= NK_VARIABLE",
 /*  91 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  92 */ "retention_list ::= retention",
 /*  93 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  94 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  95 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  96 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  97 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  98 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  99 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 100 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 101 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 102 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 103 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 105 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 107 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 109 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 111 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 112 */ "multi_create_clause ::= create_subtable_clause",
 /* 113 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 114 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 115 */ "multi_drop_clause ::= drop_table_clause",
 /* 116 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 117 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 118 */ "specific_tags_opt ::=",
 /* 119 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 120 */ "full_table_name ::= table_name",
 /* 121 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 122 */ "column_def_list ::= column_def",
 /* 123 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 124 */ "column_def ::= column_name type_name",
 /* 125 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 126 */ "type_name ::= BOOL",
 /* 127 */ "type_name ::= TINYINT",
 /* 128 */ "type_name ::= SMALLINT",
 /* 129 */ "type_name ::= INT",
 /* 130 */ "type_name ::= INTEGER",
 /* 131 */ "type_name ::= BIGINT",
 /* 132 */ "type_name ::= FLOAT",
 /* 133 */ "type_name ::= DOUBLE",
 /* 134 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 135 */ "type_name ::= TIMESTAMP",
 /* 136 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TINYINT UNSIGNED",
 /* 138 */ "type_name ::= SMALLINT UNSIGNED",
 /* 139 */ "type_name ::= INT UNSIGNED",
 /* 140 */ "type_name ::= BIGINT UNSIGNED",
 /* 141 */ "type_name ::= JSON",
 /* 142 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 143 */ "type_name ::= MEDIUMBLOB",
 /* 144 */ "type_name ::= BLOB",
 /* 145 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= DECIMAL",
 /* 147 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 149 */ "tags_def_opt ::=",
 /* 150 */ "tags_def_opt ::= tags_def",
 /* 151 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 152 */ "table_options ::=",
 /* 153 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 154 */ "table_options ::= table_options KEEP integer_list",
 /* 155 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 156 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 157 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 158 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 159 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 160 */ "alter_table_options ::= alter_table_option",
 /* 161 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 162 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 163 */ "alter_table_option ::= KEEP integer_list",
 /* 164 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 165 */ "col_name_list ::= col_name",
 /* 166 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 167 */ "col_name ::= column_name",
 /* 168 */ "cmd ::= SHOW DNODES",
 /* 169 */ "cmd ::= SHOW USERS",
 /* 170 */ "cmd ::= SHOW DATABASES",
 /* 171 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 172 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 173 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 174 */ "cmd ::= SHOW MNODES",
 /* 175 */ "cmd ::= SHOW MODULES",
 /* 176 */ "cmd ::= SHOW QNODES",
 /* 177 */ "cmd ::= SHOW FUNCTIONS",
 /* 178 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 179 */ "cmd ::= SHOW STREAMS",
 /* 180 */ "cmd ::= SHOW ACCOUNTS",
 /* 181 */ "cmd ::= SHOW APPS",
 /* 182 */ "cmd ::= SHOW CONNECTIONS",
 /* 183 */ "cmd ::= SHOW LICENCE",
 /* 184 */ "cmd ::= SHOW GRANTS",
 /* 185 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 186 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 187 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 188 */ "cmd ::= SHOW QUERIES",
 /* 189 */ "cmd ::= SHOW SCORES",
 /* 190 */ "cmd ::= SHOW TOPICS",
 /* 191 */ "cmd ::= SHOW VARIABLES",
 /* 192 */ "cmd ::= SHOW BNODES",
 /* 193 */ "cmd ::= SHOW SNODES",
 /* 194 */ "db_name_cond_opt ::=",
 /* 195 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 196 */ "like_pattern_opt ::=",
 /* 197 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 198 */ "table_name_cond ::= table_name",
 /* 199 */ "from_db_opt ::=",
 /* 200 */ "from_db_opt ::= FROM db_name",
 /* 201 */ "func_name_list ::= func_name",
 /* 202 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 203 */ "func_name ::= function_name",
 /* 204 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 205 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 206 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 207 */ "index_options ::=",
 /* 208 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 209 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 210 */ "func_list ::= func",
 /* 211 */ "func_list ::= func_list NK_COMMA func",
 /* 212 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 213 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 214 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 215 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 216 */ "cmd ::= DESC full_table_name",
 /* 217 */ "cmd ::= DESCRIBE full_table_name",
 /* 218 */ "cmd ::= RESET QUERY CACHE",
 /* 219 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 220 */ "analyze_opt ::=",
 /* 221 */ "analyze_opt ::= ANALYZE",
 /* 222 */ "explain_options ::=",
 /* 223 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 224 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 225 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 226 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 227 */ "cmd ::= DROP FUNCTION function_name",
 /* 228 */ "agg_func_opt ::=",
 /* 229 */ "agg_func_opt ::= AGGREGATE",
 /* 230 */ "bufsize_opt ::=",
 /* 231 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 232 */ "cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression",
 /* 233 */ "cmd ::= DROP STREAM stream_name",
 /* 234 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 235 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 236 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 237 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 238 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 239 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 240 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 241 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 242 */ "cmd ::= query_expression",
 /* 243 */ "literal ::= NK_INTEGER",
 /* 244 */ "literal ::= NK_FLOAT",
 /* 245 */ "literal ::= NK_STRING",
 /* 246 */ "literal ::= NK_BOOL",
 /* 247 */ "literal ::= TIMESTAMP NK_STRING",
 /* 248 */ "literal ::= duration_literal",
 /* 249 */ "literal ::= NULL",
 /* 250 */ "duration_literal ::= NK_VARIABLE",
 /* 251 */ "signed ::= NK_INTEGER",
 /* 252 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 253 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 254 */ "signed ::= NK_FLOAT",
 /* 255 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 256 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 257 */ "signed_literal ::= signed",
 /* 258 */ "signed_literal ::= NK_STRING",
 /* 259 */ "signed_literal ::= NK_BOOL",
 /* 260 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 261 */ "signed_literal ::= duration_literal",
 /* 262 */ "signed_literal ::= NULL",
 /* 263 */ "literal_list ::= signed_literal",
 /* 264 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 265 */ "db_name ::= NK_ID",
 /* 266 */ "table_name ::= NK_ID",
 /* 267 */ "column_name ::= NK_ID",
 /* 268 */ "function_name ::= NK_ID",
 /* 269 */ "function_name ::= FIRST",
 /* 270 */ "function_name ::= LAST",
 /* 271 */ "table_alias ::= NK_ID",
 /* 272 */ "column_alias ::= NK_ID",
 /* 273 */ "user_name ::= NK_ID",
 /* 274 */ "index_name ::= NK_ID",
 /* 275 */ "topic_name ::= NK_ID",
 /* 276 */ "stream_name ::= NK_ID",
 /* 277 */ "expression ::= literal",
 /* 278 */ "expression ::= pseudo_column",
 /* 279 */ "expression ::= column_reference",
 /* 280 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 281 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 282 */ "expression ::= function_name NK_LP expression AS type_name NK_RP",
 /* 283 */ "expression ::= subquery",
 /* 284 */ "expression ::= NK_LP expression NK_RP",
 /* 285 */ "expression ::= NK_PLUS expression",
 /* 286 */ "expression ::= NK_MINUS expression",
 /* 287 */ "expression ::= expression NK_PLUS expression",
 /* 288 */ "expression ::= expression NK_MINUS expression",
 /* 289 */ "expression ::= expression NK_STAR expression",
 /* 290 */ "expression ::= expression NK_SLASH expression",
 /* 291 */ "expression ::= expression NK_REM expression",
 /* 292 */ "expression_list ::= expression",
 /* 293 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 294 */ "column_reference ::= column_name",
 /* 295 */ "column_reference ::= table_name NK_DOT column_name",
 /* 296 */ "pseudo_column ::= NOW",
 /* 297 */ "pseudo_column ::= TODAY",
 /* 298 */ "pseudo_column ::= ROWTS",
 /* 299 */ "pseudo_column ::= TBNAME",
 /* 300 */ "pseudo_column ::= QSTARTTS",
 /* 301 */ "pseudo_column ::= QENDTS",
 /* 302 */ "pseudo_column ::= WSTARTTS",
 /* 303 */ "pseudo_column ::= WENDTS",
 /* 304 */ "pseudo_column ::= WDURATION",
 /* 305 */ "predicate ::= expression compare_op expression",
 /* 306 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 307 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 308 */ "predicate ::= expression IS NULL",
 /* 309 */ "predicate ::= expression IS NOT NULL",
 /* 310 */ "predicate ::= expression in_op in_predicate_value",
 /* 311 */ "compare_op ::= NK_LT",
 /* 312 */ "compare_op ::= NK_GT",
 /* 313 */ "compare_op ::= NK_LE",
 /* 314 */ "compare_op ::= NK_GE",
 /* 315 */ "compare_op ::= NK_NE",
 /* 316 */ "compare_op ::= NK_EQ",
 /* 317 */ "compare_op ::= LIKE",
 /* 318 */ "compare_op ::= NOT LIKE",
 /* 319 */ "compare_op ::= MATCH",
 /* 320 */ "compare_op ::= NMATCH",
 /* 321 */ "in_op ::= IN",
 /* 322 */ "in_op ::= NOT IN",
 /* 323 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 324 */ "boolean_value_expression ::= boolean_primary",
 /* 325 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 326 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 327 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 328 */ "boolean_primary ::= predicate",
 /* 329 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 330 */ "common_expression ::= expression",
 /* 331 */ "common_expression ::= boolean_value_expression",
 /* 332 */ "from_clause ::= FROM table_reference_list",
 /* 333 */ "table_reference_list ::= table_reference",
 /* 334 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 335 */ "table_reference ::= table_primary",
 /* 336 */ "table_reference ::= joined_table",
 /* 337 */ "table_primary ::= table_name alias_opt",
 /* 338 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 339 */ "table_primary ::= subquery alias_opt",
 /* 340 */ "table_primary ::= parenthesized_joined_table",
 /* 341 */ "alias_opt ::=",
 /* 342 */ "alias_opt ::= table_alias",
 /* 343 */ "alias_opt ::= AS table_alias",
 /* 344 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 345 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 346 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 347 */ "join_type ::=",
 /* 348 */ "join_type ::= INNER",
 /* 349 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 350 */ "set_quantifier_opt ::=",
 /* 351 */ "set_quantifier_opt ::= DISTINCT",
 /* 352 */ "set_quantifier_opt ::= ALL",
 /* 353 */ "select_list ::= NK_STAR",
 /* 354 */ "select_list ::= select_sublist",
 /* 355 */ "select_sublist ::= select_item",
 /* 356 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 357 */ "select_item ::= common_expression",
 /* 358 */ "select_item ::= common_expression column_alias",
 /* 359 */ "select_item ::= common_expression AS column_alias",
 /* 360 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 361 */ "where_clause_opt ::=",
 /* 362 */ "where_clause_opt ::= WHERE search_condition",
 /* 363 */ "partition_by_clause_opt ::=",
 /* 364 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 365 */ "twindow_clause_opt ::=",
 /* 366 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 367 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 368 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 369 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 370 */ "sliding_opt ::=",
 /* 371 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 372 */ "fill_opt ::=",
 /* 373 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 374 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 375 */ "fill_mode ::= NONE",
 /* 376 */ "fill_mode ::= PREV",
 /* 377 */ "fill_mode ::= NULL",
 /* 378 */ "fill_mode ::= LINEAR",
 /* 379 */ "fill_mode ::= NEXT",
 /* 380 */ "group_by_clause_opt ::=",
 /* 381 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 382 */ "group_by_list ::= expression",
 /* 383 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 384 */ "having_clause_opt ::=",
 /* 385 */ "having_clause_opt ::= HAVING search_condition",
 /* 386 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 387 */ "query_expression_body ::= query_primary",
 /* 388 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 389 */ "query_primary ::= query_specification",
 /* 390 */ "order_by_clause_opt ::=",
 /* 391 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 392 */ "slimit_clause_opt ::=",
 /* 393 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 394 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 395 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 396 */ "limit_clause_opt ::=",
 /* 397 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 398 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 399 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 400 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 401 */ "search_condition ::= common_expression",
 /* 402 */ "sort_specification_list ::= sort_specification",
 /* 403 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 404 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 405 */ "ordering_specification_opt ::=",
 /* 406 */ "ordering_specification_opt ::= ASC",
 /* 407 */ "ordering_specification_opt ::= DESC",
 /* 408 */ "null_ordering_opt ::=",
 /* 409 */ "null_ordering_opt ::= NULLS FIRST",
 /* 410 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 209: /* cmd */
    case 212: /* literal */
    case 219: /* db_options */
    case 221: /* alter_db_options */
    case 226: /* retention */
    case 227: /* full_table_name */
    case 230: /* table_options */
    case 234: /* alter_table_clause */
    case 235: /* alter_table_options */
    case 238: /* create_subtable_clause */
    case 241: /* drop_table_clause */
    case 244: /* column_def */
    case 247: /* col_name */
    case 248: /* db_name_cond_opt */
    case 249: /* like_pattern_opt */
    case 250: /* table_name_cond */
    case 251: /* from_db_opt */
    case 252: /* func_name */
    case 255: /* index_options */
    case 257: /* duration_literal */
    case 258: /* sliding_opt */
    case 259: /* func */
    case 262: /* query_expression */
    case 264: /* explain_options */
    case 269: /* signed */
    case 270: /* signed_literal */
    case 273: /* expression */
    case 274: /* pseudo_column */
    case 275: /* column_reference */
    case 276: /* subquery */
    case 277: /* predicate */
    case 280: /* in_predicate_value */
    case 281: /* boolean_value_expression */
    case 282: /* boolean_primary */
    case 283: /* common_expression */
    case 284: /* from_clause */
    case 285: /* table_reference_list */
    case 286: /* table_reference */
    case 287: /* table_primary */
    case 288: /* joined_table */
    case 290: /* parenthesized_joined_table */
    case 292: /* search_condition */
    case 293: /* query_specification */
    case 296: /* where_clause_opt */
    case 298: /* twindow_clause_opt */
    case 300: /* having_clause_opt */
    case 302: /* select_item */
    case 303: /* fill_opt */
    case 306: /* query_expression_body */
    case 308: /* slimit_clause_opt */
    case 309: /* limit_clause_opt */
    case 310: /* query_primary */
    case 312: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy182)); 
}
      break;
    case 210: /* account_options */
    case 211: /* alter_account_options */
    case 213: /* alter_account_option */
    case 266: /* bufsize_opt */
{
 
}
      break;
    case 214: /* user_name */
    case 215: /* dnode_endpoint */
    case 216: /* dnode_host_name */
    case 218: /* db_name */
    case 236: /* column_name */
    case 243: /* table_name */
    case 253: /* function_name */
    case 254: /* index_name */
    case 261: /* topic_name */
    case 267: /* stream_name */
    case 271: /* table_alias */
    case 272: /* column_alias */
    case 289: /* alias_opt */
{
 
}
      break;
    case 217: /* not_exists_opt */
    case 220: /* exists_opt */
    case 263: /* analyze_opt */
    case 265: /* agg_func_opt */
    case 294: /* set_quantifier_opt */
{
 
}
      break;
    case 222: /* integer_list */
    case 223: /* variable_list */
    case 224: /* retention_list */
    case 228: /* column_def_list */
    case 229: /* tags_def_opt */
    case 231: /* multi_create_clause */
    case 232: /* tags_def */
    case 233: /* multi_drop_clause */
    case 239: /* specific_tags_opt */
    case 240: /* literal_list */
    case 242: /* col_name_list */
    case 245: /* func_name_list */
    case 256: /* func_list */
    case 260: /* expression_list */
    case 268: /* dnode_list */
    case 295: /* select_list */
    case 297: /* partition_by_clause_opt */
    case 299: /* group_by_clause_opt */
    case 301: /* select_sublist */
    case 305: /* group_by_list */
    case 307: /* order_by_clause_opt */
    case 311: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy334)); 
}
      break;
    case 225: /* alter_db_option */
    case 246: /* alter_table_option */
{
 
}
      break;
    case 237: /* type_name */
{
 
}
      break;
    case 278: /* compare_op */
    case 279: /* in_op */
{
 
}
      break;
    case 291: /* join_type */
{
 
}
      break;
    case 304: /* fill_mode */
{
 
}
      break;
    case 313: /* ordering_specification_opt */
{
 
}
      break;
    case 314: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   209,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   209,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   210,  /* (2) account_options ::= */
   210,  /* (3) account_options ::= account_options PPS literal */
   210,  /* (4) account_options ::= account_options TSERIES literal */
   210,  /* (5) account_options ::= account_options STORAGE literal */
   210,  /* (6) account_options ::= account_options STREAMS literal */
   210,  /* (7) account_options ::= account_options QTIME literal */
   210,  /* (8) account_options ::= account_options DBS literal */
   210,  /* (9) account_options ::= account_options USERS literal */
   210,  /* (10) account_options ::= account_options CONNS literal */
   210,  /* (11) account_options ::= account_options STATE literal */
   211,  /* (12) alter_account_options ::= alter_account_option */
   211,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   213,  /* (14) alter_account_option ::= PASS literal */
   213,  /* (15) alter_account_option ::= PPS literal */
   213,  /* (16) alter_account_option ::= TSERIES literal */
   213,  /* (17) alter_account_option ::= STORAGE literal */
   213,  /* (18) alter_account_option ::= STREAMS literal */
   213,  /* (19) alter_account_option ::= QTIME literal */
   213,  /* (20) alter_account_option ::= DBS literal */
   213,  /* (21) alter_account_option ::= USERS literal */
   213,  /* (22) alter_account_option ::= CONNS literal */
   213,  /* (23) alter_account_option ::= STATE literal */
   209,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
   209,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   209,  /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
   209,  /* (27) cmd ::= DROP USER user_name */
   209,  /* (28) cmd ::= CREATE DNODE dnode_endpoint */
   209,  /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
   209,  /* (30) cmd ::= DROP DNODE NK_INTEGER */
   209,  /* (31) cmd ::= DROP DNODE dnode_endpoint */
   209,  /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   209,  /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   209,  /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
   209,  /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   215,  /* (36) dnode_endpoint ::= NK_STRING */
   216,  /* (37) dnode_host_name ::= NK_ID */
   216,  /* (38) dnode_host_name ::= NK_IPTOKEN */
   209,  /* (39) cmd ::= ALTER LOCAL NK_STRING */
   209,  /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   209,  /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   209,  /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   209,  /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   209,  /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   209,  /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   209,  /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   209,  /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   209,  /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   209,  /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   209,  /* (50) cmd ::= DROP DATABASE exists_opt db_name */
   209,  /* (51) cmd ::= USE db_name */
   209,  /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
   217,  /* (53) not_exists_opt ::= IF NOT EXISTS */
   217,  /* (54) not_exists_opt ::= */
   220,  /* (55) exists_opt ::= IF EXISTS */
   220,  /* (56) exists_opt ::= */
   219,  /* (57) db_options ::= */
   219,  /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
   219,  /* (59) db_options ::= db_options CACHE NK_INTEGER */
   219,  /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
   219,  /* (61) db_options ::= db_options COMP NK_INTEGER */
   219,  /* (62) db_options ::= db_options DAYS NK_INTEGER */
   219,  /* (63) db_options ::= db_options DAYS NK_VARIABLE */
   219,  /* (64) db_options ::= db_options FSYNC NK_INTEGER */
   219,  /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
   219,  /* (66) db_options ::= db_options MINROWS NK_INTEGER */
   219,  /* (67) db_options ::= db_options KEEP integer_list */
   219,  /* (68) db_options ::= db_options KEEP variable_list */
   219,  /* (69) db_options ::= db_options PRECISION NK_STRING */
   219,  /* (70) db_options ::= db_options QUORUM NK_INTEGER */
   219,  /* (71) db_options ::= db_options REPLICA NK_INTEGER */
   219,  /* (72) db_options ::= db_options TTL NK_INTEGER */
   219,  /* (73) db_options ::= db_options WAL NK_INTEGER */
   219,  /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
   219,  /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   219,  /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
   219,  /* (77) db_options ::= db_options RETENTIONS retention_list */
   221,  /* (78) alter_db_options ::= alter_db_option */
   221,  /* (79) alter_db_options ::= alter_db_options alter_db_option */
   225,  /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
   225,  /* (81) alter_db_option ::= FSYNC NK_INTEGER */
   225,  /* (82) alter_db_option ::= KEEP integer_list */
   225,  /* (83) alter_db_option ::= KEEP variable_list */
   225,  /* (84) alter_db_option ::= WAL NK_INTEGER */
   225,  /* (85) alter_db_option ::= QUORUM NK_INTEGER */
   225,  /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
   225,  /* (87) alter_db_option ::= REPLICA NK_INTEGER */
   222,  /* (88) integer_list ::= NK_INTEGER */
   222,  /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   223,  /* (90) variable_list ::= NK_VARIABLE */
   223,  /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   224,  /* (92) retention_list ::= retention */
   224,  /* (93) retention_list ::= retention_list NK_COMMA retention */
   226,  /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   209,  /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   209,  /* (96) cmd ::= CREATE TABLE multi_create_clause */
   209,  /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   209,  /* (98) cmd ::= DROP TABLE multi_drop_clause */
   209,  /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
   209,  /* (100) cmd ::= ALTER TABLE alter_table_clause */
   209,  /* (101) cmd ::= ALTER STABLE alter_table_clause */
   234,  /* (102) alter_table_clause ::= full_table_name alter_table_options */
   234,  /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   234,  /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   234,  /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   234,  /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   234,  /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   234,  /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
   234,  /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   234,  /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   234,  /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
   231,  /* (112) multi_create_clause ::= create_subtable_clause */
   231,  /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
   238,  /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
   233,  /* (115) multi_drop_clause ::= drop_table_clause */
   233,  /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   241,  /* (117) drop_table_clause ::= exists_opt full_table_name */
   239,  /* (118) specific_tags_opt ::= */
   239,  /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
   227,  /* (120) full_table_name ::= table_name */
   227,  /* (121) full_table_name ::= db_name NK_DOT table_name */
   228,  /* (122) column_def_list ::= column_def */
   228,  /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
   244,  /* (124) column_def ::= column_name type_name */
   244,  /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
   237,  /* (126) type_name ::= BOOL */
   237,  /* (127) type_name ::= TINYINT */
   237,  /* (128) type_name ::= SMALLINT */
   237,  /* (129) type_name ::= INT */
   237,  /* (130) type_name ::= INTEGER */
   237,  /* (131) type_name ::= BIGINT */
   237,  /* (132) type_name ::= FLOAT */
   237,  /* (133) type_name ::= DOUBLE */
   237,  /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   237,  /* (135) type_name ::= TIMESTAMP */
   237,  /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   237,  /* (137) type_name ::= TINYINT UNSIGNED */
   237,  /* (138) type_name ::= SMALLINT UNSIGNED */
   237,  /* (139) type_name ::= INT UNSIGNED */
   237,  /* (140) type_name ::= BIGINT UNSIGNED */
   237,  /* (141) type_name ::= JSON */
   237,  /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   237,  /* (143) type_name ::= MEDIUMBLOB */
   237,  /* (144) type_name ::= BLOB */
   237,  /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   237,  /* (146) type_name ::= DECIMAL */
   237,  /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   237,  /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   229,  /* (149) tags_def_opt ::= */
   229,  /* (150) tags_def_opt ::= tags_def */
   232,  /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   230,  /* (152) table_options ::= */
   230,  /* (153) table_options ::= table_options COMMENT NK_STRING */
   230,  /* (154) table_options ::= table_options KEEP integer_list */
   230,  /* (155) table_options ::= table_options TTL NK_INTEGER */
   230,  /* (156) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   230,  /* (157) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
   230,  /* (158) table_options ::= table_options FILE_FACTOR NK_FLOAT */
   230,  /* (159) table_options ::= table_options DELAY NK_INTEGER */
   235,  /* (160) alter_table_options ::= alter_table_option */
   235,  /* (161) alter_table_options ::= alter_table_options alter_table_option */
   246,  /* (162) alter_table_option ::= COMMENT NK_STRING */
   246,  /* (163) alter_table_option ::= KEEP integer_list */
   246,  /* (164) alter_table_option ::= TTL NK_INTEGER */
   242,  /* (165) col_name_list ::= col_name */
   242,  /* (166) col_name_list ::= col_name_list NK_COMMA col_name */
   247,  /* (167) col_name ::= column_name */
   209,  /* (168) cmd ::= SHOW DNODES */
   209,  /* (169) cmd ::= SHOW USERS */
   209,  /* (170) cmd ::= SHOW DATABASES */
   209,  /* (171) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   209,  /* (172) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   209,  /* (173) cmd ::= SHOW db_name_cond_opt VGROUPS */
   209,  /* (174) cmd ::= SHOW MNODES */
   209,  /* (175) cmd ::= SHOW MODULES */
   209,  /* (176) cmd ::= SHOW QNODES */
   209,  /* (177) cmd ::= SHOW FUNCTIONS */
   209,  /* (178) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   209,  /* (179) cmd ::= SHOW STREAMS */
   209,  /* (180) cmd ::= SHOW ACCOUNTS */
   209,  /* (181) cmd ::= SHOW APPS */
   209,  /* (182) cmd ::= SHOW CONNECTIONS */
   209,  /* (183) cmd ::= SHOW LICENCE */
   209,  /* (184) cmd ::= SHOW GRANTS */
   209,  /* (185) cmd ::= SHOW CREATE DATABASE db_name */
   209,  /* (186) cmd ::= SHOW CREATE TABLE full_table_name */
   209,  /* (187) cmd ::= SHOW CREATE STABLE full_table_name */
   209,  /* (188) cmd ::= SHOW QUERIES */
   209,  /* (189) cmd ::= SHOW SCORES */
   209,  /* (190) cmd ::= SHOW TOPICS */
   209,  /* (191) cmd ::= SHOW VARIABLES */
   209,  /* (192) cmd ::= SHOW BNODES */
   209,  /* (193) cmd ::= SHOW SNODES */
   248,  /* (194) db_name_cond_opt ::= */
   248,  /* (195) db_name_cond_opt ::= db_name NK_DOT */
   249,  /* (196) like_pattern_opt ::= */
   249,  /* (197) like_pattern_opt ::= LIKE NK_STRING */
   250,  /* (198) table_name_cond ::= table_name */
   251,  /* (199) from_db_opt ::= */
   251,  /* (200) from_db_opt ::= FROM db_name */
   245,  /* (201) func_name_list ::= func_name */
   245,  /* (202) func_name_list ::= func_name_list NK_COMMA col_name */
   252,  /* (203) func_name ::= function_name */
   209,  /* (204) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
   209,  /* (205) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
   209,  /* (206) cmd ::= DROP INDEX exists_opt index_name ON table_name */
   255,  /* (207) index_options ::= */
   255,  /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
   255,  /* (209) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
   256,  /* (210) func_list ::= func */
   256,  /* (211) func_list ::= func_list NK_COMMA func */
   259,  /* (212) func ::= function_name NK_LP expression_list NK_RP */
   209,  /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
   209,  /* (214) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
   209,  /* (215) cmd ::= DROP TOPIC exists_opt topic_name */
   209,  /* (216) cmd ::= DESC full_table_name */
   209,  /* (217) cmd ::= DESCRIBE full_table_name */
   209,  /* (218) cmd ::= RESET QUERY CACHE */
   209,  /* (219) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
   263,  /* (220) analyze_opt ::= */
   263,  /* (221) analyze_opt ::= ANALYZE */
   264,  /* (222) explain_options ::= */
   264,  /* (223) explain_options ::= explain_options VERBOSE NK_BOOL */
   264,  /* (224) explain_options ::= explain_options RATIO NK_FLOAT */
   209,  /* (225) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
   209,  /* (226) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   209,  /* (227) cmd ::= DROP FUNCTION function_name */
   265,  /* (228) agg_func_opt ::= */
   265,  /* (229) agg_func_opt ::= AGGREGATE */
   266,  /* (230) bufsize_opt ::= */
   266,  /* (231) bufsize_opt ::= BUFSIZE NK_INTEGER */
   209,  /* (232) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
   209,  /* (233) cmd ::= DROP STREAM stream_name */
   209,  /* (234) cmd ::= KILL CONNECTION NK_INTEGER */
   209,  /* (235) cmd ::= KILL QUERY NK_INTEGER */
   209,  /* (236) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   209,  /* (237) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   209,  /* (238) cmd ::= SPLIT VGROUP NK_INTEGER */
   268,  /* (239) dnode_list ::= DNODE NK_INTEGER */
   268,  /* (240) dnode_list ::= dnode_list DNODE NK_INTEGER */
   209,  /* (241) cmd ::= SYNCDB db_name REPLICA */
   209,  /* (242) cmd ::= query_expression */
   212,  /* (243) literal ::= NK_INTEGER */
   212,  /* (244) literal ::= NK_FLOAT */
   212,  /* (245) literal ::= NK_STRING */
   212,  /* (246) literal ::= NK_BOOL */
   212,  /* (247) literal ::= TIMESTAMP NK_STRING */
   212,  /* (248) literal ::= duration_literal */
   212,  /* (249) literal ::= NULL */
   257,  /* (250) duration_literal ::= NK_VARIABLE */
   269,  /* (251) signed ::= NK_INTEGER */
   269,  /* (252) signed ::= NK_PLUS NK_INTEGER */
   269,  /* (253) signed ::= NK_MINUS NK_INTEGER */
   269,  /* (254) signed ::= NK_FLOAT */
   269,  /* (255) signed ::= NK_PLUS NK_FLOAT */
   269,  /* (256) signed ::= NK_MINUS NK_FLOAT */
   270,  /* (257) signed_literal ::= signed */
   270,  /* (258) signed_literal ::= NK_STRING */
   270,  /* (259) signed_literal ::= NK_BOOL */
   270,  /* (260) signed_literal ::= TIMESTAMP NK_STRING */
   270,  /* (261) signed_literal ::= duration_literal */
   270,  /* (262) signed_literal ::= NULL */
   240,  /* (263) literal_list ::= signed_literal */
   240,  /* (264) literal_list ::= literal_list NK_COMMA signed_literal */
   218,  /* (265) db_name ::= NK_ID */
   243,  /* (266) table_name ::= NK_ID */
   236,  /* (267) column_name ::= NK_ID */
   253,  /* (268) function_name ::= NK_ID */
   253,  /* (269) function_name ::= FIRST */
   253,  /* (270) function_name ::= LAST */
   271,  /* (271) table_alias ::= NK_ID */
   272,  /* (272) column_alias ::= NK_ID */
   214,  /* (273) user_name ::= NK_ID */
   254,  /* (274) index_name ::= NK_ID */
   261,  /* (275) topic_name ::= NK_ID */
   267,  /* (276) stream_name ::= NK_ID */
   273,  /* (277) expression ::= literal */
   273,  /* (278) expression ::= pseudo_column */
   273,  /* (279) expression ::= column_reference */
   273,  /* (280) expression ::= function_name NK_LP expression_list NK_RP */
   273,  /* (281) expression ::= function_name NK_LP NK_STAR NK_RP */
   273,  /* (282) expression ::= function_name NK_LP expression AS type_name NK_RP */
   273,  /* (283) expression ::= subquery */
   273,  /* (284) expression ::= NK_LP expression NK_RP */
   273,  /* (285) expression ::= NK_PLUS expression */
   273,  /* (286) expression ::= NK_MINUS expression */
   273,  /* (287) expression ::= expression NK_PLUS expression */
   273,  /* (288) expression ::= expression NK_MINUS expression */
   273,  /* (289) expression ::= expression NK_STAR expression */
   273,  /* (290) expression ::= expression NK_SLASH expression */
   273,  /* (291) expression ::= expression NK_REM expression */
   260,  /* (292) expression_list ::= expression */
   260,  /* (293) expression_list ::= expression_list NK_COMMA expression */
   275,  /* (294) column_reference ::= column_name */
   275,  /* (295) column_reference ::= table_name NK_DOT column_name */
   274,  /* (296) pseudo_column ::= NOW */
   274,  /* (297) pseudo_column ::= TODAY */
   274,  /* (298) pseudo_column ::= ROWTS */
   274,  /* (299) pseudo_column ::= TBNAME */
   274,  /* (300) pseudo_column ::= QSTARTTS */
   274,  /* (301) pseudo_column ::= QENDTS */
   274,  /* (302) pseudo_column ::= WSTARTTS */
   274,  /* (303) pseudo_column ::= WENDTS */
   274,  /* (304) pseudo_column ::= WDURATION */
   277,  /* (305) predicate ::= expression compare_op expression */
   277,  /* (306) predicate ::= expression BETWEEN expression AND expression */
   277,  /* (307) predicate ::= expression NOT BETWEEN expression AND expression */
   277,  /* (308) predicate ::= expression IS NULL */
   277,  /* (309) predicate ::= expression IS NOT NULL */
   277,  /* (310) predicate ::= expression in_op in_predicate_value */
   278,  /* (311) compare_op ::= NK_LT */
   278,  /* (312) compare_op ::= NK_GT */
   278,  /* (313) compare_op ::= NK_LE */
   278,  /* (314) compare_op ::= NK_GE */
   278,  /* (315) compare_op ::= NK_NE */
   278,  /* (316) compare_op ::= NK_EQ */
   278,  /* (317) compare_op ::= LIKE */
   278,  /* (318) compare_op ::= NOT LIKE */
   278,  /* (319) compare_op ::= MATCH */
   278,  /* (320) compare_op ::= NMATCH */
   279,  /* (321) in_op ::= IN */
   279,  /* (322) in_op ::= NOT IN */
   280,  /* (323) in_predicate_value ::= NK_LP expression_list NK_RP */
   281,  /* (324) boolean_value_expression ::= boolean_primary */
   281,  /* (325) boolean_value_expression ::= NOT boolean_primary */
   281,  /* (326) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   281,  /* (327) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   282,  /* (328) boolean_primary ::= predicate */
   282,  /* (329) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   283,  /* (330) common_expression ::= expression */
   283,  /* (331) common_expression ::= boolean_value_expression */
   284,  /* (332) from_clause ::= FROM table_reference_list */
   285,  /* (333) table_reference_list ::= table_reference */
   285,  /* (334) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   286,  /* (335) table_reference ::= table_primary */
   286,  /* (336) table_reference ::= joined_table */
   287,  /* (337) table_primary ::= table_name alias_opt */
   287,  /* (338) table_primary ::= db_name NK_DOT table_name alias_opt */
   287,  /* (339) table_primary ::= subquery alias_opt */
   287,  /* (340) table_primary ::= parenthesized_joined_table */
   289,  /* (341) alias_opt ::= */
   289,  /* (342) alias_opt ::= table_alias */
   289,  /* (343) alias_opt ::= AS table_alias */
   290,  /* (344) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   290,  /* (345) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   288,  /* (346) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   291,  /* (347) join_type ::= */
   291,  /* (348) join_type ::= INNER */
   293,  /* (349) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   294,  /* (350) set_quantifier_opt ::= */
   294,  /* (351) set_quantifier_opt ::= DISTINCT */
   294,  /* (352) set_quantifier_opt ::= ALL */
   295,  /* (353) select_list ::= NK_STAR */
   295,  /* (354) select_list ::= select_sublist */
   301,  /* (355) select_sublist ::= select_item */
   301,  /* (356) select_sublist ::= select_sublist NK_COMMA select_item */
   302,  /* (357) select_item ::= common_expression */
   302,  /* (358) select_item ::= common_expression column_alias */
   302,  /* (359) select_item ::= common_expression AS column_alias */
   302,  /* (360) select_item ::= table_name NK_DOT NK_STAR */
   296,  /* (361) where_clause_opt ::= */
   296,  /* (362) where_clause_opt ::= WHERE search_condition */
   297,  /* (363) partition_by_clause_opt ::= */
   297,  /* (364) partition_by_clause_opt ::= PARTITION BY expression_list */
   298,  /* (365) twindow_clause_opt ::= */
   298,  /* (366) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   298,  /* (367) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
   298,  /* (368) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   298,  /* (369) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   258,  /* (370) sliding_opt ::= */
   258,  /* (371) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   303,  /* (372) fill_opt ::= */
   303,  /* (373) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   303,  /* (374) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   304,  /* (375) fill_mode ::= NONE */
   304,  /* (376) fill_mode ::= PREV */
   304,  /* (377) fill_mode ::= NULL */
   304,  /* (378) fill_mode ::= LINEAR */
   304,  /* (379) fill_mode ::= NEXT */
   299,  /* (380) group_by_clause_opt ::= */
   299,  /* (381) group_by_clause_opt ::= GROUP BY group_by_list */
   305,  /* (382) group_by_list ::= expression */
   305,  /* (383) group_by_list ::= group_by_list NK_COMMA expression */
   300,  /* (384) having_clause_opt ::= */
   300,  /* (385) having_clause_opt ::= HAVING search_condition */
   262,  /* (386) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
   306,  /* (387) query_expression_body ::= query_primary */
   306,  /* (388) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
   310,  /* (389) query_primary ::= query_specification */
   307,  /* (390) order_by_clause_opt ::= */
   307,  /* (391) order_by_clause_opt ::= ORDER BY sort_specification_list */
   308,  /* (392) slimit_clause_opt ::= */
   308,  /* (393) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   308,  /* (394) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   308,  /* (395) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   309,  /* (396) limit_clause_opt ::= */
   309,  /* (397) limit_clause_opt ::= LIMIT NK_INTEGER */
   309,  /* (398) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   309,  /* (399) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   276,  /* (400) subquery ::= NK_LP query_expression NK_RP */
   292,  /* (401) search_condition ::= common_expression */
   311,  /* (402) sort_specification_list ::= sort_specification */
   311,  /* (403) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   312,  /* (404) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
   313,  /* (405) ordering_specification_opt ::= */
   313,  /* (406) ordering_specification_opt ::= ASC */
   313,  /* (407) ordering_specification_opt ::= DESC */
   314,  /* (408) null_ordering_opt ::= */
   314,  /* (409) null_ordering_opt ::= NULLS FIRST */
   314,  /* (410) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -5,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
   -3,  /* (27) cmd ::= DROP USER user_name */
   -3,  /* (28) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
   -3,  /* (30) cmd ::= DROP DNODE NK_INTEGER */
   -3,  /* (31) cmd ::= DROP DNODE dnode_endpoint */
   -4,  /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (36) dnode_endpoint ::= NK_STRING */
   -1,  /* (37) dnode_host_name ::= NK_ID */
   -1,  /* (38) dnode_host_name ::= NK_IPTOKEN */
   -3,  /* (39) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (50) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (51) cmd ::= USE db_name */
   -4,  /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (53) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (54) not_exists_opt ::= */
   -2,  /* (55) exists_opt ::= IF EXISTS */
    0,  /* (56) exists_opt ::= */
    0,  /* (57) db_options ::= */
   -3,  /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
   -3,  /* (59) db_options ::= db_options CACHE NK_INTEGER */
   -3,  /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
   -3,  /* (61) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (62) db_options ::= db_options DAYS NK_INTEGER */
   -3,  /* (63) db_options ::= db_options DAYS NK_VARIABLE */
   -3,  /* (64) db_options ::= db_options FSYNC NK_INTEGER */
   -3,  /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (66) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (67) db_options ::= db_options KEEP integer_list */
   -3,  /* (68) db_options ::= db_options KEEP variable_list */
   -3,  /* (69) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (70) db_options ::= db_options QUORUM NK_INTEGER */
   -3,  /* (71) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (72) db_options ::= db_options TTL NK_INTEGER */
   -3,  /* (73) db_options ::= db_options WAL NK_INTEGER */
   -3,  /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
   -3,  /* (77) db_options ::= db_options RETENTIONS retention_list */
   -1,  /* (78) alter_db_options ::= alter_db_option */
   -2,  /* (79) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
   -2,  /* (81) alter_db_option ::= FSYNC NK_INTEGER */
   -2,  /* (82) alter_db_option ::= KEEP integer_list */
   -2,  /* (83) alter_db_option ::= KEEP variable_list */
   -2,  /* (84) alter_db_option ::= WAL NK_INTEGER */
   -2,  /* (85) alter_db_option ::= QUORUM NK_INTEGER */
   -2,  /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
   -2,  /* (87) alter_db_option ::= REPLICA NK_INTEGER */
   -1,  /* (88) integer_list ::= NK_INTEGER */
   -3,  /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (90) variable_list ::= NK_VARIABLE */
   -3,  /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (92) retention_list ::= retention */
   -3,  /* (93) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   -9,  /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (96) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (98) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (100) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (101) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (102) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
   -1,  /* (112) multi_create_clause ::= create_subtable_clause */
   -2,  /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
   -9,  /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
   -1,  /* (115) multi_drop_clause ::= drop_table_clause */
   -2,  /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   -2,  /* (117) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (118) specific_tags_opt ::= */
   -3,  /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (120) full_table_name ::= table_name */
   -3,  /* (121) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (122) column_def_list ::= column_def */
   -3,  /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (124) column_def ::= column_name type_name */
   -4,  /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (126) type_name ::= BOOL */
   -1,  /* (127) type_name ::= TINYINT */
   -1,  /* (128) type_name ::= SMALLINT */
   -1,  /* (129) type_name ::= INT */
   -1,  /* (130) type_name ::= INTEGER */
   -1,  /* (131) type_name ::= BIGINT */
   -1,  /* (132) type_name ::= FLOAT */
   -1,  /* (133) type_name ::= DOUBLE */
   -4,  /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (135) type_name ::= TIMESTAMP */
   -4,  /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (137) type_name ::= TINYINT UNSIGNED */
   -2,  /* (138) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (139) type_name ::= INT UNSIGNED */
   -2,  /* (140) type_name ::= BIGINT UNSIGNED */
   -1,  /* (141) type_name ::= JSON */
   -4,  /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (143) type_name ::= MEDIUMBLOB */
   -1,  /* (144) type_name ::= BLOB */
   -4,  /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (146) type_name ::= DECIMAL */
   -4,  /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (149) tags_def_opt ::= */
   -1,  /* (150) tags_def_opt ::= tags_def */
   -4,  /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (152) table_options ::= */
   -3,  /* (153) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (154) table_options ::= table_options KEEP integer_list */
   -3,  /* (155) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (156) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -5,  /* (157) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
   -3,  /* (158) table_options ::= table_options FILE_FACTOR NK_FLOAT */
   -3,  /* (159) table_options ::= table_options DELAY NK_INTEGER */
   -1,  /* (160) alter_table_options ::= alter_table_option */
   -2,  /* (161) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (162) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (163) alter_table_option ::= KEEP integer_list */
   -2,  /* (164) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (165) col_name_list ::= col_name */
   -3,  /* (166) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (167) col_name ::= column_name */
   -2,  /* (168) cmd ::= SHOW DNODES */
   -2,  /* (169) cmd ::= SHOW USERS */
   -2,  /* (170) cmd ::= SHOW DATABASES */
   -4,  /* (171) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (172) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (173) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (174) cmd ::= SHOW MNODES */
   -2,  /* (175) cmd ::= SHOW MODULES */
   -2,  /* (176) cmd ::= SHOW QNODES */
   -2,  /* (177) cmd ::= SHOW FUNCTIONS */
   -5,  /* (178) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (179) cmd ::= SHOW STREAMS */
   -2,  /* (180) cmd ::= SHOW ACCOUNTS */
   -2,  /* (181) cmd ::= SHOW APPS */
   -2,  /* (182) cmd ::= SHOW CONNECTIONS */
   -2,  /* (183) cmd ::= SHOW LICENCE */
   -2,  /* (184) cmd ::= SHOW GRANTS */
   -4,  /* (185) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (186) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (187) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (188) cmd ::= SHOW QUERIES */
   -2,  /* (189) cmd ::= SHOW SCORES */
   -2,  /* (190) cmd ::= SHOW TOPICS */
   -2,  /* (191) cmd ::= SHOW VARIABLES */
   -2,  /* (192) cmd ::= SHOW BNODES */
   -2,  /* (193) cmd ::= SHOW SNODES */
    0,  /* (194) db_name_cond_opt ::= */
   -2,  /* (195) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (196) like_pattern_opt ::= */
   -2,  /* (197) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (198) table_name_cond ::= table_name */
    0,  /* (199) from_db_opt ::= */
   -2,  /* (200) from_db_opt ::= FROM db_name */
   -1,  /* (201) func_name_list ::= func_name */
   -3,  /* (202) func_name_list ::= func_name_list NK_COMMA col_name */
   -1,  /* (203) func_name ::= function_name */
   -8,  /* (204) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  -10,  /* (205) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
   -6,  /* (206) cmd ::= DROP INDEX exists_opt index_name ON table_name */
    0,  /* (207) index_options ::= */
   -9,  /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  -11,  /* (209) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
   -1,  /* (210) func_list ::= func */
   -3,  /* (211) func_list ::= func_list NK_COMMA func */
   -4,  /* (212) func ::= function_name NK_LP expression_list NK_RP */
   -6,  /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
   -6,  /* (214) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
   -4,  /* (215) cmd ::= DROP TOPIC exists_opt topic_name */
   -2,  /* (216) cmd ::= DESC full_table_name */
   -2,  /* (217) cmd ::= DESCRIBE full_table_name */
   -3,  /* (218) cmd ::= RESET QUERY CACHE */
   -4,  /* (219) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
    0,  /* (220) analyze_opt ::= */
   -1,  /* (221) analyze_opt ::= ANALYZE */
    0,  /* (222) explain_options ::= */
   -3,  /* (223) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (224) explain_options ::= explain_options RATIO NK_FLOAT */
   -6,  /* (225) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
   -9,  /* (226) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   -3,  /* (227) cmd ::= DROP FUNCTION function_name */
    0,  /* (228) agg_func_opt ::= */
   -1,  /* (229) agg_func_opt ::= AGGREGATE */
    0,  /* (230) bufsize_opt ::= */
   -2,  /* (231) bufsize_opt ::= BUFSIZE NK_INTEGER */
   -7,  /* (232) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
   -3,  /* (233) cmd ::= DROP STREAM stream_name */
   -3,  /* (234) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (235) cmd ::= KILL QUERY NK_INTEGER */
   -4,  /* (236) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (237) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (238) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (239) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (240) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -3,  /* (241) cmd ::= SYNCDB db_name REPLICA */
   -1,  /* (242) cmd ::= query_expression */
   -1,  /* (243) literal ::= NK_INTEGER */
   -1,  /* (244) literal ::= NK_FLOAT */
   -1,  /* (245) literal ::= NK_STRING */
   -1,  /* (246) literal ::= NK_BOOL */
   -2,  /* (247) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (248) literal ::= duration_literal */
   -1,  /* (249) literal ::= NULL */
   -1,  /* (250) duration_literal ::= NK_VARIABLE */
   -1,  /* (251) signed ::= NK_INTEGER */
   -2,  /* (252) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (253) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (254) signed ::= NK_FLOAT */
   -2,  /* (255) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (256) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (257) signed_literal ::= signed */
   -1,  /* (258) signed_literal ::= NK_STRING */
   -1,  /* (259) signed_literal ::= NK_BOOL */
   -2,  /* (260) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (261) signed_literal ::= duration_literal */
   -1,  /* (262) signed_literal ::= NULL */
   -1,  /* (263) literal_list ::= signed_literal */
   -3,  /* (264) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (265) db_name ::= NK_ID */
   -1,  /* (266) table_name ::= NK_ID */
   -1,  /* (267) column_name ::= NK_ID */
   -1,  /* (268) function_name ::= NK_ID */
   -1,  /* (269) function_name ::= FIRST */
   -1,  /* (270) function_name ::= LAST */
   -1,  /* (271) table_alias ::= NK_ID */
   -1,  /* (272) column_alias ::= NK_ID */
   -1,  /* (273) user_name ::= NK_ID */
   -1,  /* (274) index_name ::= NK_ID */
   -1,  /* (275) topic_name ::= NK_ID */
   -1,  /* (276) stream_name ::= NK_ID */
   -1,  /* (277) expression ::= literal */
   -1,  /* (278) expression ::= pseudo_column */
   -1,  /* (279) expression ::= column_reference */
   -4,  /* (280) expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (281) expression ::= function_name NK_LP NK_STAR NK_RP */
   -6,  /* (282) expression ::= function_name NK_LP expression AS type_name NK_RP */
   -1,  /* (283) expression ::= subquery */
   -3,  /* (284) expression ::= NK_LP expression NK_RP */
   -2,  /* (285) expression ::= NK_PLUS expression */
   -2,  /* (286) expression ::= NK_MINUS expression */
   -3,  /* (287) expression ::= expression NK_PLUS expression */
   -3,  /* (288) expression ::= expression NK_MINUS expression */
   -3,  /* (289) expression ::= expression NK_STAR expression */
   -3,  /* (290) expression ::= expression NK_SLASH expression */
   -3,  /* (291) expression ::= expression NK_REM expression */
   -1,  /* (292) expression_list ::= expression */
   -3,  /* (293) expression_list ::= expression_list NK_COMMA expression */
   -1,  /* (294) column_reference ::= column_name */
   -3,  /* (295) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (296) pseudo_column ::= NOW */
   -1,  /* (297) pseudo_column ::= TODAY */
   -1,  /* (298) pseudo_column ::= ROWTS */
   -1,  /* (299) pseudo_column ::= TBNAME */
   -1,  /* (300) pseudo_column ::= QSTARTTS */
   -1,  /* (301) pseudo_column ::= QENDTS */
   -1,  /* (302) pseudo_column ::= WSTARTTS */
   -1,  /* (303) pseudo_column ::= WENDTS */
   -1,  /* (304) pseudo_column ::= WDURATION */
   -3,  /* (305) predicate ::= expression compare_op expression */
   -5,  /* (306) predicate ::= expression BETWEEN expression AND expression */
   -6,  /* (307) predicate ::= expression NOT BETWEEN expression AND expression */
   -3,  /* (308) predicate ::= expression IS NULL */
   -4,  /* (309) predicate ::= expression IS NOT NULL */
   -3,  /* (310) predicate ::= expression in_op in_predicate_value */
   -1,  /* (311) compare_op ::= NK_LT */
   -1,  /* (312) compare_op ::= NK_GT */
   -1,  /* (313) compare_op ::= NK_LE */
   -1,  /* (314) compare_op ::= NK_GE */
   -1,  /* (315) compare_op ::= NK_NE */
   -1,  /* (316) compare_op ::= NK_EQ */
   -1,  /* (317) compare_op ::= LIKE */
   -2,  /* (318) compare_op ::= NOT LIKE */
   -1,  /* (319) compare_op ::= MATCH */
   -1,  /* (320) compare_op ::= NMATCH */
   -1,  /* (321) in_op ::= IN */
   -2,  /* (322) in_op ::= NOT IN */
   -3,  /* (323) in_predicate_value ::= NK_LP expression_list NK_RP */
   -1,  /* (324) boolean_value_expression ::= boolean_primary */
   -2,  /* (325) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (326) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (327) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (328) boolean_primary ::= predicate */
   -3,  /* (329) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (330) common_expression ::= expression */
   -1,  /* (331) common_expression ::= boolean_value_expression */
   -2,  /* (332) from_clause ::= FROM table_reference_list */
   -1,  /* (333) table_reference_list ::= table_reference */
   -3,  /* (334) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (335) table_reference ::= table_primary */
   -1,  /* (336) table_reference ::= joined_table */
   -2,  /* (337) table_primary ::= table_name alias_opt */
   -4,  /* (338) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (339) table_primary ::= subquery alias_opt */
   -1,  /* (340) table_primary ::= parenthesized_joined_table */
    0,  /* (341) alias_opt ::= */
   -1,  /* (342) alias_opt ::= table_alias */
   -2,  /* (343) alias_opt ::= AS table_alias */
   -3,  /* (344) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (345) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (346) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (347) join_type ::= */
   -1,  /* (348) join_type ::= INNER */
   -9,  /* (349) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (350) set_quantifier_opt ::= */
   -1,  /* (351) set_quantifier_opt ::= DISTINCT */
   -1,  /* (352) set_quantifier_opt ::= ALL */
   -1,  /* (353) select_list ::= NK_STAR */
   -1,  /* (354) select_list ::= select_sublist */
   -1,  /* (355) select_sublist ::= select_item */
   -3,  /* (356) select_sublist ::= select_sublist NK_COMMA select_item */
   -1,  /* (357) select_item ::= common_expression */
   -2,  /* (358) select_item ::= common_expression column_alias */
   -3,  /* (359) select_item ::= common_expression AS column_alias */
   -3,  /* (360) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (361) where_clause_opt ::= */
   -2,  /* (362) where_clause_opt ::= WHERE search_condition */
    0,  /* (363) partition_by_clause_opt ::= */
   -3,  /* (364) partition_by_clause_opt ::= PARTITION BY expression_list */
    0,  /* (365) twindow_clause_opt ::= */
   -6,  /* (366) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (367) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
   -6,  /* (368) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (369) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
    0,  /* (370) sliding_opt ::= */
   -4,  /* (371) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (372) fill_opt ::= */
   -4,  /* (373) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (374) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -1,  /* (375) fill_mode ::= NONE */
   -1,  /* (376) fill_mode ::= PREV */
   -1,  /* (377) fill_mode ::= NULL */
   -1,  /* (378) fill_mode ::= LINEAR */
   -1,  /* (379) fill_mode ::= NEXT */
    0,  /* (380) group_by_clause_opt ::= */
   -3,  /* (381) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (382) group_by_list ::= expression */
   -3,  /* (383) group_by_list ::= group_by_list NK_COMMA expression */
    0,  /* (384) having_clause_opt ::= */
   -2,  /* (385) having_clause_opt ::= HAVING search_condition */
   -4,  /* (386) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (387) query_expression_body ::= query_primary */
   -4,  /* (388) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
   -1,  /* (389) query_primary ::= query_specification */
    0,  /* (390) order_by_clause_opt ::= */
   -3,  /* (391) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (392) slimit_clause_opt ::= */
   -2,  /* (393) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (394) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (395) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (396) limit_clause_opt ::= */
   -2,  /* (397) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (398) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (399) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (400) subquery ::= NK_LP query_expression NK_RP */
   -1,  /* (401) search_condition ::= common_expression */
   -1,  /* (402) sort_specification_list ::= sort_specification */
   -3,  /* (403) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (404) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
    0,  /* (405) ordering_specification_opt ::= */
   -1,  /* (406) ordering_specification_opt ::= ASC */
   -1,  /* (407) ordering_specification_opt ::= DESC */
    0,  /* (408) null_ordering_opt ::= */
   -2,  /* (409) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (410) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,210,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,211,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,210,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,212,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,213,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,211,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,213,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,212,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy29, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy29, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy29, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 265: /* db_name ::= NK_ID */ yytestcase(yyruleno==265);
      case 266: /* table_name ::= NK_ID */ yytestcase(yyruleno==266);
      case 267: /* column_name ::= NK_ID */ yytestcase(yyruleno==267);
      case 268: /* function_name ::= NK_ID */ yytestcase(yyruleno==268);
      case 269: /* function_name ::= FIRST */ yytestcase(yyruleno==269);
      case 270: /* function_name ::= LAST */ yytestcase(yyruleno==270);
      case 271: /* table_alias ::= NK_ID */ yytestcase(yyruleno==271);
      case 272: /* column_alias ::= NK_ID */ yytestcase(yyruleno==272);
      case 273: /* user_name ::= NK_ID */ yytestcase(yyruleno==273);
      case 274: /* index_name ::= NK_ID */ yytestcase(yyruleno==274);
      case 275: /* topic_name ::= NK_ID */ yytestcase(yyruleno==275);
      case 276: /* stream_name ::= NK_ID */ yytestcase(yyruleno==276);
{ yylhsminor.yy29 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy29 = yylhsminor.yy29;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy47, &yymsp[-1].minor.yy29, yymsp[0].minor.yy182); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy47, &yymsp[0].minor.yy29); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy29, yymsp[0].minor.yy182); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy47 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 220: /* analyze_opt ::= */ yytestcase(yyruleno==220);
      case 228: /* agg_func_opt ::= */ yytestcase(yyruleno==228);
      case 350: /* set_quantifier_opt ::= */ yytestcase(yyruleno==350);
{ yymsp[1].minor.yy47 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy47 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy182 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pKeep = yymsp[0].minor.yy334; yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy182)->pRetentions = yymsp[0].minor.yy334; yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 78: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy182 = createDatabaseOptions(pCxt); yylhsminor.yy182 = setDatabaseAlterOption(pCxt, yylhsminor.yy182, &yymsp[0].minor.yy515); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 79: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy182 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy182, &yymsp[0].minor.yy515); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 80: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 81: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= KEEP integer_list */
      case 83: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==83);
{ yymsp[-1].minor.yy515.type = DB_OPTION_KEEP; yymsp[-1].minor.yy515.pList = yymsp[0].minor.yy334; }
        break;
      case 84: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_WAL; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 85: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy515.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy334 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 89: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 240: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==240);
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 90: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy334 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 91: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 92: /* retention_list ::= retention */
      case 112: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==112);
      case 115: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==115);
      case 122: /* column_def_list ::= column_def */ yytestcase(yyruleno==122);
      case 165: /* col_name_list ::= col_name */ yytestcase(yyruleno==165);
      case 201: /* func_name_list ::= func_name */ yytestcase(yyruleno==201);
      case 210: /* func_list ::= func */ yytestcase(yyruleno==210);
      case 263: /* literal_list ::= signed_literal */ yytestcase(yyruleno==263);
      case 355: /* select_sublist ::= select_item */ yytestcase(yyruleno==355);
      case 402: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==402);
{ yylhsminor.yy334 = createNodeList(pCxt, yymsp[0].minor.yy182); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 93: /* retention_list ::= retention_list NK_COMMA retention */
      case 123: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==123);
      case 166: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==166);
      case 202: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==202);
      case 211: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==211);
      case 264: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==264);
      case 356: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==356);
      case 403: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==403);
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, yymsp[0].minor.yy182); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 94: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy182 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 95: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 97: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==97);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy47, yymsp[-5].minor.yy182, yymsp[-3].minor.yy334, yymsp[-1].minor.yy334, yymsp[0].minor.yy182); }
        break;
      case 96: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy334); }
        break;
      case 98: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy334); }
        break;
      case 99: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy47, yymsp[0].minor.yy182); }
        break;
      case 100: /* cmd ::= ALTER TABLE alter_table_clause */
      case 101: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==101);
      case 242: /* cmd ::= query_expression */ yytestcase(yyruleno==242);
{ pCxt->pRootNode = yymsp[0].minor.yy182; }
        break;
      case 102: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy182 = createAlterTableOption(pCxt, yymsp[-1].minor.yy182, yymsp[0].minor.yy182); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 103: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy182 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy182, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy29, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 104: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy182 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy182, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy29); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 105: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy182 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy182, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy29, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 106: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy182 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy182, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 107: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy182 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy182, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy29, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 108: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy182 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy182, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy29); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 109: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy182 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy182, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy29, yymsp[0].minor.yy574); }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 110: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy182 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy182, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 111: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy182 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy182, &yymsp[-2].minor.yy29, yymsp[0].minor.yy182); }
  yymsp[-5].minor.yy182 = yylhsminor.yy182;
        break;
      case 113: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 116: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==116);
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-1].minor.yy334, yymsp[0].minor.yy182); }
  yymsp[-1].minor.yy334 = yylhsminor.yy334;
        break;
      case 114: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy182 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy47, yymsp[-7].minor.yy182, yymsp[-5].minor.yy182, yymsp[-4].minor.yy334, yymsp[-1].minor.yy334); }
  yymsp[-8].minor.yy182 = yylhsminor.yy182;
        break;
      case 117: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy182 = createDropTableClause(pCxt, yymsp[-1].minor.yy47, yymsp[0].minor.yy182); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 118: /* specific_tags_opt ::= */
      case 149: /* tags_def_opt ::= */ yytestcase(yyruleno==149);
      case 363: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==363);
      case 380: /* group_by_clause_opt ::= */ yytestcase(yyruleno==380);
      case 390: /* order_by_clause_opt ::= */ yytestcase(yyruleno==390);
{ yymsp[1].minor.yy334 = NULL; }
        break;
      case 119: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy334 = yymsp[-1].minor.yy334; }
        break;
      case 120: /* full_table_name ::= table_name */
{ yylhsminor.yy182 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy29, NULL); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 121: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy182 = createRealTableNode(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29, NULL); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 124: /* column_def ::= column_name type_name */
{ yylhsminor.yy182 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy29, yymsp[0].minor.yy574, NULL); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 125: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy182 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy29, yymsp[-2].minor.yy574, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 126: /* type_name ::= BOOL */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 127: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 128: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 129: /* type_name ::= INT */
      case 130: /* type_name ::= INTEGER */ yytestcase(yyruleno==130);
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 131: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 132: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 133: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 134: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 135: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 136: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 139: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 140: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy574 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 141: /* type_name ::= JSON */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 142: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 143: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 144: /* type_name ::= BLOB */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 145: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy574 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 147: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy574 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 148: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy574 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* tags_def_opt ::= tags_def */
      case 354: /* select_list ::= select_sublist */ yytestcase(yyruleno==354);
{ yylhsminor.yy334 = yymsp[0].minor.yy334; }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 151: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy334 = yymsp[-1].minor.yy334; }
        break;
      case 152: /* table_options ::= */
{ yymsp[1].minor.yy182 = createTableOptions(pCxt); }
        break;
      case 153: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy182)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 154: /* table_options ::= table_options KEEP integer_list */
{ ((STableOptions*)yymsp[-2].minor.yy182)->pKeep = yymsp[0].minor.yy334; yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 155: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy182)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 156: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy182)->pSma = yymsp[-1].minor.yy334; yylhsminor.yy182 = yymsp[-4].minor.yy182; }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 157: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy182)->pFuncs = yymsp[-1].minor.yy334; yylhsminor.yy182 = yymsp[-4].minor.yy182; }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 158: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy182)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 159: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy182)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy182 = yymsp[-2].minor.yy182; }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 160: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy182 = createTableOptions(pCxt); yylhsminor.yy182 = setTableAlterOption(pCxt, yylhsminor.yy182, &yymsp[0].minor.yy515); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 161: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy182 = setTableAlterOption(pCxt, yymsp[-1].minor.yy182, &yymsp[0].minor.yy515); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 162: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy515.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 163: /* alter_table_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy515.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy515.pList = yymsp[0].minor.yy334; }
        break;
      case 164: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy515.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy515.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 167: /* col_name ::= column_name */
{ yylhsminor.yy182 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy29); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 168: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 170: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 171: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy182, yymsp[0].minor.yy182); }
        break;
      case 172: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy182, yymsp[0].minor.yy182); }
        break;
      case 173: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy182, NULL); }
        break;
      case 174: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy182, yymsp[0].minor.yy182); }
        break;
      case 179: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 181: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW LICENCE */
      case 184: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==184);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 186: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy182); }
        break;
      case 187: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy182); }
        break;
      case 188: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 194: /* db_name_cond_opt ::= */
      case 199: /* from_db_opt ::= */ yytestcase(yyruleno==199);
{ yymsp[1].minor.yy182 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 195: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy29); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 196: /* like_pattern_opt ::= */
      case 207: /* index_options ::= */ yytestcase(yyruleno==207);
      case 361: /* where_clause_opt ::= */ yytestcase(yyruleno==361);
      case 365: /* twindow_clause_opt ::= */ yytestcase(yyruleno==365);
      case 370: /* sliding_opt ::= */ yytestcase(yyruleno==370);
      case 372: /* fill_opt ::= */ yytestcase(yyruleno==372);
      case 384: /* having_clause_opt ::= */ yytestcase(yyruleno==384);
      case 392: /* slimit_clause_opt ::= */ yytestcase(yyruleno==392);
      case 396: /* limit_clause_opt ::= */ yytestcase(yyruleno==396);
{ yymsp[1].minor.yy182 = NULL; }
        break;
      case 197: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 198: /* table_name_cond ::= table_name */
{ yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy29); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 200: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy29); }
        break;
      case 203: /* func_name ::= function_name */
{ yylhsminor.yy182 = createFunctionNode(pCxt, &yymsp[0].minor.yy29, NULL); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 204: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy47, &yymsp[-3].minor.yy29, &yymsp[-1].minor.yy29, NULL, yymsp[0].minor.yy182); }
        break;
      case 205: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy47, &yymsp[-5].minor.yy29, &yymsp[-3].minor.yy29, yymsp[-1].minor.yy334, NULL); }
        break;
      case 206: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy47, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29); }
        break;
      case 208: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy182 = createIndexOption(pCxt, yymsp[-6].minor.yy334, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), NULL, yymsp[0].minor.yy182); }
        break;
      case 209: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy182 = createIndexOption(pCxt, yymsp[-8].minor.yy334, releaseRawExprNode(pCxt, yymsp[-4].minor.yy182), releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), yymsp[0].minor.yy182); }
        break;
      case 212: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy182 = createFunctionNode(pCxt, &yymsp[-3].minor.yy29, yymsp[-1].minor.yy334); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 213: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy47, &yymsp[-2].minor.yy29, yymsp[0].minor.yy182, NULL); }
        break;
      case 214: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy47, &yymsp[-2].minor.yy29, NULL, &yymsp[0].minor.yy29); }
        break;
      case 215: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy47, &yymsp[0].minor.yy29); }
        break;
      case 216: /* cmd ::= DESC full_table_name */
      case 217: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==217);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy182); }
        break;
      case 218: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 219: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy47, yymsp[-1].minor.yy182, yymsp[0].minor.yy182); }
        break;
      case 221: /* analyze_opt ::= ANALYZE */
      case 229: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==229);
      case 351: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==351);
{ yymsp[0].minor.yy47 = true; }
        break;
      case 222: /* explain_options ::= */
{ yymsp[1].minor.yy182 = createDefaultExplainOptions(pCxt); }
        break;
      case 223: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy182 = setExplainVerbose(pCxt, yymsp[-2].minor.yy182, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 224: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy182 = setExplainRatio(pCxt, yymsp[-2].minor.yy182, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 225: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy334); }
        break;
      case 226: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy47, &yymsp[-5].minor.yy29, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy574, yymsp[0].minor.yy550); }
        break;
      case 227: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 230: /* bufsize_opt ::= */
{ yymsp[1].minor.yy550 = 0; }
        break;
      case 231: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy550 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 232: /* cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, &yymsp[-4].minor.yy29, &yymsp[-2].minor.yy29, yymsp[0].minor.yy182); }
        break;
      case 233: /* cmd ::= DROP STREAM stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 234: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 235: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 236: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 237: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy334); }
        break;
      case 238: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 239: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy334 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 241: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy29); }
        break;
      case 243: /* literal ::= NK_INTEGER */
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 244: /* literal ::= NK_FLOAT */
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 245: /* literal ::= NK_STRING */
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 246: /* literal ::= NK_BOOL */
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 247: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 248: /* literal ::= duration_literal */
      case 257: /* signed_literal ::= signed */ yytestcase(yyruleno==257);
      case 277: /* expression ::= literal */ yytestcase(yyruleno==277);
      case 278: /* expression ::= pseudo_column */ yytestcase(yyruleno==278);
      case 279: /* expression ::= column_reference */ yytestcase(yyruleno==279);
      case 283: /* expression ::= subquery */ yytestcase(yyruleno==283);
      case 324: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==324);
      case 328: /* boolean_primary ::= predicate */ yytestcase(yyruleno==328);
      case 330: /* common_expression ::= expression */ yytestcase(yyruleno==330);
      case 331: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==331);
      case 333: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==333);
      case 335: /* table_reference ::= table_primary */ yytestcase(yyruleno==335);
      case 336: /* table_reference ::= joined_table */ yytestcase(yyruleno==336);
      case 340: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==340);
      case 387: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==387);
      case 389: /* query_primary ::= query_specification */ yytestcase(yyruleno==389);
{ yylhsminor.yy182 = yymsp[0].minor.yy182; }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 249: /* literal ::= NULL */
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 250: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 251: /* signed ::= NK_INTEGER */
{ yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 252: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 253: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 254: /* signed ::= NK_FLOAT */
{ yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 255: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 256: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 258: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 259: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 260: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 261: /* signed_literal ::= duration_literal */
      case 357: /* select_item ::= common_expression */ yytestcase(yyruleno==357);
      case 401: /* search_condition ::= common_expression */ yytestcase(yyruleno==401);
{ yylhsminor.yy182 = releaseRawExprNode(pCxt, yymsp[0].minor.yy182); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 262: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy182 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 280: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy29, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy29, yymsp[-1].minor.yy334)); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 281: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy29, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy29, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 282: /* expression ::= function_name NK_LP expression AS type_name NK_RP */
{
                                                                                    SNodeList *p = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy182));
                                                                                    p = addValueNodeFromTypeToList(pCxt, yymsp[-1].minor.yy574, p);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy29, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-5].minor.yy29, p));
                                                                                  }
  yymsp[-5].minor.yy182 = yylhsminor.yy182;
        break;
      case 284: /* expression ::= NK_LP expression NK_RP */
      case 329: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==329);
{ yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy182)); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 285: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy182));
                                                                                  }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 286: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy182), NULL));
                                                                                  }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 287: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182))); 
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 288: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182))); 
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 289: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182))); 
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 290: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182))); 
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 291: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182))); 
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 292: /* expression_list ::= expression */
{ yylhsminor.yy334 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy182)); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 293: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, releaseRawExprNode(pCxt, yymsp[0].minor.yy182)); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 294: /* column_reference ::= column_name */
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy29, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy29)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 295: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29, createColumnNode(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29)); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 296: /* pseudo_column ::= NOW */
      case 297: /* pseudo_column ::= TODAY */ yytestcase(yyruleno==297);
      case 298: /* pseudo_column ::= ROWTS */ yytestcase(yyruleno==298);
      case 299: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==299);
      case 300: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==300);
      case 301: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==301);
      case 302: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==302);
      case 303: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==303);
      case 304: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==304);
{ yylhsminor.yy182 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy182 = yylhsminor.yy182;
        break;
      case 305: /* predicate ::= expression compare_op expression */
      case 310: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==310);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182)));
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 306: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy182), releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182)));
                                                                                  }
  yymsp[-4].minor.yy182 = yylhsminor.yy182;
        break;
      case 307: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[-5].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182)));
                                                                                  }
  yymsp[-5].minor.yy182 = yylhsminor.yy182;
        break;
      case 308: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), NULL));
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 309: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy182), NULL));
                                                                                  }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 311: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 312: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 313: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 314: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 315: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 316: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 317: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 318: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 319: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 320: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 321: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 322: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 323: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy334)); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 325: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy182), NULL));
                                                                                  }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 326: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182)));
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 327: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy182);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy182);
                                                                                    yylhsminor.yy182 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), releaseRawExprNode(pCxt, yymsp[0].minor.yy182)));
                                                                                  }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 332: /* from_clause ::= FROM table_reference_list */
      case 362: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==362);
      case 385: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==385);
{ yymsp[-1].minor.yy182 = yymsp[0].minor.yy182; }
        break;
      case 334: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy182 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy182, yymsp[0].minor.yy182, NULL); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 337: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy182 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 338: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy182 = createRealTableNode(pCxt, &yymsp[-3].minor.yy29, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 339: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy182 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy182), &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 341: /* alias_opt ::= */
{ yymsp[1].minor.yy29 = nil_token;  }
        break;
      case 342: /* alias_opt ::= table_alias */
{ yylhsminor.yy29 = yymsp[0].minor.yy29; }
  yymsp[0].minor.yy29 = yylhsminor.yy29;
        break;
      case 343: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy29 = yymsp[0].minor.yy29; }
        break;
      case 344: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 345: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==345);
{ yymsp[-2].minor.yy182 = yymsp[-1].minor.yy182; }
        break;
      case 346: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy182 = createJoinTableNode(pCxt, yymsp[-4].minor.yy162, yymsp[-5].minor.yy182, yymsp[-2].minor.yy182, yymsp[0].minor.yy182); }
  yymsp[-5].minor.yy182 = yylhsminor.yy182;
        break;
      case 347: /* join_type ::= */
{ yymsp[1].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 348: /* join_type ::= INNER */
{ yymsp[0].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 349: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy182 = createSelectStmt(pCxt, yymsp[-7].minor.yy47, yymsp[-6].minor.yy334, yymsp[-5].minor.yy182);
                                                                                    yymsp[-8].minor.yy182 = addWhereClause(pCxt, yymsp[-8].minor.yy182, yymsp[-4].minor.yy182);
                                                                                    yymsp[-8].minor.yy182 = addPartitionByClause(pCxt, yymsp[-8].minor.yy182, yymsp[-3].minor.yy334);
                                                                                    yymsp[-8].minor.yy182 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy182, yymsp[-2].minor.yy182);
                                                                                    yymsp[-8].minor.yy182 = addGroupByClause(pCxt, yymsp[-8].minor.yy182, yymsp[-1].minor.yy334);
                                                                                    yymsp[-8].minor.yy182 = addHavingClause(pCxt, yymsp[-8].minor.yy182, yymsp[0].minor.yy182);
                                                                                  }
        break;
      case 352: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy47 = false; }
        break;
      case 353: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy334 = NULL; }
        break;
      case 358: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy182 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy182), &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy182 = yylhsminor.yy182;
        break;
      case 359: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy182 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), &yymsp[0].minor.yy29); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 360: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy182 = createColumnNode(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 364: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 381: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==381);
      case 391: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==391);
{ yymsp[-2].minor.yy334 = yymsp[0].minor.yy334; }
        break;
      case 366: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy182 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy182), releaseRawExprNode(pCxt, yymsp[-1].minor.yy182)); }
        break;
      case 367: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy182 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy182)); }
        break;
      case 368: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy182 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy182), NULL, yymsp[-1].minor.yy182, yymsp[0].minor.yy182); }
        break;
      case 369: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy182 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy182), releaseRawExprNode(pCxt, yymsp[-3].minor.yy182), yymsp[-1].minor.yy182, yymsp[0].minor.yy182); }
        break;
      case 371: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy182 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy182); }
        break;
      case 373: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy182 = createFillNode(pCxt, yymsp[-1].minor.yy144, NULL); }
        break;
      case 374: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy182 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy334)); }
        break;
      case 375: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy144 = FILL_MODE_NONE; }
        break;
      case 376: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy144 = FILL_MODE_PREV; }
        break;
      case 377: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy144 = FILL_MODE_NULL; }
        break;
      case 378: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy144 = FILL_MODE_LINEAR; }
        break;
      case 379: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy144 = FILL_MODE_NEXT; }
        break;
      case 382: /* group_by_list ::= expression */
{ yylhsminor.yy334 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy182))); }
  yymsp[0].minor.yy334 = yylhsminor.yy334;
        break;
      case 383: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy334 = addNodeToList(pCxt, yymsp[-2].minor.yy334, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy182))); }
  yymsp[-2].minor.yy334 = yylhsminor.yy334;
        break;
      case 386: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy182 = addOrderByClause(pCxt, yymsp[-3].minor.yy182, yymsp[-2].minor.yy334);
                                                                                    yylhsminor.yy182 = addSlimitClause(pCxt, yylhsminor.yy182, yymsp[-1].minor.yy182);
                                                                                    yylhsminor.yy182 = addLimitClause(pCxt, yylhsminor.yy182, yymsp[0].minor.yy182);
                                                                                  }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 388: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy182 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy182, yymsp[0].minor.yy182); }
  yymsp[-3].minor.yy182 = yylhsminor.yy182;
        break;
      case 393: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 397: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==397);
{ yymsp[-1].minor.yy182 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 394: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 398: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==398);
{ yymsp[-3].minor.yy182 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 395: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 399: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==399);
{ yymsp[-3].minor.yy182 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 400: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy182 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy182); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 404: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy182 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy182), yymsp[-1].minor.yy218, yymsp[0].minor.yy487); }
  yymsp[-2].minor.yy182 = yylhsminor.yy182;
        break;
      case 405: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy218 = ORDER_ASC; }
        break;
      case 406: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy218 = ORDER_ASC; }
        break;
      case 407: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy218 = ORDER_DESC; }
        break;
      case 408: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy487 = NULL_ORDER_DEFAULT; }
        break;
      case 409: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_FIRST; }
        break;
      case 410: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
