/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 460
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy5;
  bool yy57;
  EFillMode yy214;
  EJoinType yy332;
  int32_t yy340;
  int8_t yy383;
  SDataType yy384;
  SNodeList* yy424;
  EOrder yy538;
  EOperatorType yy620;
  SNode* yy752;
  ENullOrder yy777;
  SToken yy849;
  int64_t yy869;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             714
#define YYNRULE              544
#define YYNTOKEN             324
#define YY_MAX_SHIFT         713
#define YY_MIN_SHIFTREDUCE   1060
#define YY_MAX_SHIFTREDUCE   1603
#define YY_ERROR_ACTION      1604
#define YY_ACCEPT_ACTION     1605
#define YY_NO_ACTION         1606
#define YY_MIN_REDUCE        1607
#define YY_MAX_REDUCE        2150
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3067)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1749,  407,  460, 1874,  461, 1643,  469,  367,  461, 1643,
 /*    10 */  1806, 1808,   45,   43, 1533, 1952, 1872,  590, 1630,  466,
 /*    20 */   362, 1745, 1384,   38,   37,  462, 1948,   44,   42,   41,
 /*    30 */    40,   39,  169, 1463,  459, 1382,  229,  464, 1649, 1790,
 /*    40 */   571,  320,   38,   37, 2121, 1813,   44,   42,   41,   40,
 /*    50 */    39,  602,  355,  334, 1860, 1944, 1950,  345, 1458,  570,
 /*    60 */   175, 1811, 1934,   18, 2122,  572,  613,   38,   37, 1965,
 /*    70 */  1390,   44,   42,   41,   40,   39,  468, 1410,  583,  464,
 /*    80 */  1649,   38,   37,   45,   43,   44,   42,   41,   40,   39,
 /*    90 */   354,  362,  171, 1384, 1607,   14,  603,  327,  157, 1112,
 /*   100 */  1983, 1111, 2125,   27, 1463, 1800, 1382, 1762,  586,  134,
 /*   110 */    54, 1570,  602, 1934,  603,  619, 1410,  710,  125,  124,
 /*   120 */   123,  122,  121,  120,  119,  118,  117, 1760,  126, 1458,
 /*   130 */  1113, 1605, 1465, 1466,   18,  499,   35,  276, 1492, 1964,
 /*   140 */    84, 1390,  478, 1999,   64, 1760,  103, 1966,  623, 1968,
 /*   150 */  1969,  618,  602,  613,  130, 2126, 1807, 1808,  172, 2121,
 /*   160 */  2052, 1439, 1448, 1755,  356, 2048,   14, 1464, 1467,  257,
 /*   170 */  2060,  582, 1738,  127,  581, 2125,   84, 2121,  177, 2122,
 /*   180 */  2124, 2126, 1385, 2126, 1383, 2121, 2078,   48,  710, 1262,
 /*   190 */  1263,  160,  570,  175, 1493,  377, 1714, 2122,  572, 1756,
 /*   200 */  1411, 2125, 1409, 1465, 1466, 2122, 2123, 1388, 1389,  396,
 /*   210 */  1438, 1441, 1442, 1443, 1444, 1445, 1446, 1447,  615,  611,
 /*   220 */  1456, 1457, 1459, 1460, 1461, 1462,    2,   48, 1329, 1330,
 /*   230 */   398,  394, 1439, 1448,  478,   60,  156,  547, 1464, 1467,
 /*   240 */   116, 2121,  648,  115,  114,  113,  112,  111,  110,  109,
 /*   250 */   108,  107,  339, 1385, 1560, 1383, 2127,  175,   41,   40,
 /*   260 */    39, 2122,  572, 1328, 1331,   34,  360, 1487, 1488, 1489,
 /*   270 */  1490, 1491, 1495, 1496, 1497, 1498, 1593,   60, 1388, 1389,
 /*   280 */   260, 1438, 1441, 1442, 1443, 1444, 1445, 1446, 1447,  615,
 /*   290 */   611, 1456, 1457, 1459, 1460, 1461, 1462,    2,  169,   11,
 /*   300 */    45,   43,  558, 1558, 1559, 1561, 1562,  159,  362, 1619,
 /*   310 */  1384, 1093,  227,  340,  566,  338,  337,   60,  501,   89,
 /*   320 */  1861, 1463,  503, 1382, 1219,  645,  644,  643, 1223,  642,
 /*   330 */  1225, 1226,  641, 1228,  638, 1676, 1234,  635, 1236, 1237,
 /*   340 */   632,  629,  213,  259,  502, 1952, 1458, 1409, 1751,  401,
 /*   350 */  1095,   18, 1098, 1099, 1813,   11, 1948,  164, 1390, 1948,
 /*   360 */   365,  366,  574,  495,  491,  487,  483,  210,  157,   60,
 /*   370 */  1811,   45,   43, 1468,   86,  322,  178, 1762,  532,  362,
 /*   380 */   530, 1384, 1983,   14,  178, 1944, 1950,  357, 1944, 1950,
 /*   390 */   565,  547, 1463,   49, 1382, 2121,  613,  510,  509,  613,
 /*   400 */   514,  513,  512,   85, 1411,  710,  208, 1608,  131,  508,
 /*   410 */  2127,  175,   11,  507,    9, 2122,  572, 1458,  506,  511,
 /*   420 */  1465, 1466,  267,  268,  505, 1737,  178,  266,  116, 1390,
 /*   430 */   564,  115,  114,  113,  112,  111,  110,  109,  108,  107,
 /*   440 */    38,   37,  681,  679,   44,   42,   41,   40,   39, 1439,
 /*   450 */  1448,  368, 1412, 1813,   46, 1464, 1467,   38,   37,  157,
 /*   460 */   331,   44,   42,   41,   40,   39,  178, 2067, 1762, 1811,
 /*   470 */  1385, 1537, 1383,  207,  201,   60,  710, 1409,  206,   38,
 /*   480 */    37,  474,  657,   44,   42,   41,   40,   39, 1315, 1316,
 /*   490 */  1393, 1465, 1466, 2064, 1629, 1388, 1389,  199, 1438, 1441,
 /*   500 */  1442, 1443, 1444, 1445, 1446, 1447,  615,  611, 1456, 1457,
 /*   510 */  1459, 1460, 1461, 1462,    2,  514,  513,  512,  178, 1409,
 /*   520 */  1439, 1448,  528,  131,  508,  571, 1464, 1467,  507, 2121,
 /*   530 */  1179, 2067,  655,  506,  511,  526, 2067,  524, 1934,  505,
 /*   540 */  1408, 1385,  178, 1383,  570,  175,  100,  259, 1628, 2122,
 /*   550 */   572,  148,  147,  652,  651,  650,  145, 2063,  583,  589,
 /*   560 */   135,  400, 2062,  399, 1627, 1181, 1388, 1389, 1752, 1438,
 /*   570 */  1441, 1442, 1443, 1444, 1445, 1446, 1447,  615,  611, 1456,
 /*   580 */  1457, 1459, 1460, 1461, 1462,    2,   45,   43,  603,  134,
 /*   590 */  1384, 1473, 1934, 1843,  362,  237, 1384, 1409,  713,   52,
 /*   600 */  1874,  547,  180, 1382,  187, 2121,  546, 1463, 1934, 1382,
 /*   610 */   353,  146,  283, 1871,  590,  603, 1965, 1736, 1440, 1760,
 /*   620 */  2127,  175,  375, 1600,  178, 2122,  572,  168,  583,  405,
 /*   630 */  1953, 1856, 1458,  703,  699,  695,  691,  281, 1390, 1396,
 /*   640 */    81, 1948,  183,   80, 1390, 1856, 1760, 1983,  585,  173,
 /*   650 */  2060, 2061,   94,  132, 2065,  617,  185,   45,   43,  134,
 /*   660 */  1934,  603,  619,   53,  547,  362, 1494, 1384, 2121,   46,
 /*   670 */  1944, 1950, 1626,  101, 1753,  126,  274,  583, 1463,  657,
 /*   680 */  1382,  613,  504, 2127,  175,  710, 1964,  443, 2122,  572,
 /*   690 */  1999,  710, 1760,  312, 1966,  623, 1968, 1969,  618,  616,
 /*   700 */   613,  604, 2017, 1458, 1735, 1625, 1465, 1466,  134,  599,
 /*   710 */    44,   42,   41,   40,   39, 1390, 1934, 1599,  561,  174,
 /*   720 */  2060, 2061, 1624,  132, 2065,  136,   38,   37, 2023, 1747,
 /*   730 */    44,   42,   41,   40,   39, 1439, 1448,   32, 1440, 1623,
 /*   740 */    14, 1464, 1467,  603,  424,  191,  190, 1499,  262, 1934,
 /*   750 */  1385,  605, 1383, 2024,   13,   12, 1385,  406, 1383,  228,
 /*   760 */  1622,  607,  710, 2024, 1412, 1355, 1934,  231,  176, 2060,
 /*   770 */  2061, 1412,  132, 2065, 1760, 1388, 1389, 1465, 1466,    8,
 /*   780 */   374, 1388, 1389, 1934, 1438, 1441, 1442, 1443, 1444, 1445,
 /*   790 */  1446, 1447,  615,  611, 1456, 1457, 1459, 1460, 1461, 1462,
 /*   800 */     2,  567,  562,  556, 1934,  603, 1439, 1448,  319,  157,
 /*   810 */  1407,  655, 1464, 1467, 1549, 2072, 1526,  437, 1763,  415,
 /*   820 */   450, 1813,  547,  449, 1361, 1362, 2121, 1385, 1856, 1383,
 /*   830 */   148,  147,  652,  651,  650,  145, 1760, 1812,  421,  189,
 /*   840 */   451, 2127,  175,  423, 1409, 1621, 2122,  572,  649, 1506,
 /*   850 */   575, 1804, 1388, 1389,  610, 1438, 1441, 1442, 1443, 1444,
 /*   860 */  1445, 1446, 1447,  615,  611, 1456, 1457, 1459, 1460, 1461,
 /*   870 */  1462,    2, 1618,  653, 1617,  670, 1804, 1730,  158,  654,
 /*   880 */  1616,   31, 1804,  296,  335, 1673,  603,   38,   37, 1934,
 /*   890 */  1530,   44,   42,   41,   40,   39,  411,  294,   70,   33,
 /*   900 */   429,   69, 1615, 1098, 1099,   38,   37,  184, 1390,   44,
 /*   910 */    42,   41,   40,   39,  236,  408, 1934, 1760, 1934,  195,
 /*   920 */   456,  454,  290,  669, 1934, 1790,  447,  542,  409,  442,
 /*   930 */   441,  440,  439,  436,  435,  434,  433,  432,  428,  427,
 /*   940 */   426,  425,  336,  418,  417,  416, 1934,  413,  412,  333,
 /*   950 */   687,  686,  685,  684,  372,   60,  683,  682,  138,  677,
 /*   960 */   676,  675,  674,  673,  672,  671,  150,  667,  666,  665,
 /*   970 */   371,  370,  662,  661,  660,  659,  658, 1112,  503, 1111,
 /*   980 */    50, 1921,    3, 1526,  235, 1440, 1614,  578, 1613, 1612,
 /*   990 */   603,  603,  212,  603,  102,  603,  655, 1611, 1484,  519,
 /*  1000 */   502,  140, 1392,  128,  430,  476, 1965,  477, 1113, 1757,
 /*  1010 */  1743,  603,  535,  603,  529,  148,  147,  652,  651,  650,
 /*  1020 */   145, 1760, 1760,   87, 1760,  142, 1760,  543,  226,  384,
 /*  1030 */  1934,  232, 1934, 1934,   78,   77,  404, 1983, 1610,  182,
 /*  1040 */   614, 1934, 1760,  522, 1760,  620,  218,  647,  516,  216,
 /*  1050 */  1934, 1650,  619,  225,  547, 1602, 1603,  318, 2121, 1141,
 /*  1060 */   392,   71,  390,  386,  382,  379,  376,  603, 1965,  220,
 /*  1070 */  1715,  576,  219, 2127,  175,   62, 1964,  603, 2122,  572,
 /*  1080 */  1999,  587, 1934,  103, 1966,  623, 1968, 1969,  618,   67,
 /*  1090 */   613,  271,   66,  137, 1142,  143, 2023, 2052, 1760, 1983,
 /*  1100 */   705,  356, 2048,  603,  178,  603,  603,  586, 1760,  603,
 /*  1110 */   603,   79, 1934,  222,  619,  224,  221,  598,  223,  600,
 /*  1120 */   601, 1663, 1965,  277,  369,  241,   47, 1557,  264,   99,
 /*  1130 */    68, 1529, 1656, 1654, 1760,  144, 1760, 1760, 1964,   96,
 /*  1140 */  1760, 1760, 1999,  515, 1620,  103, 1966,  623, 1968, 1969,
 /*  1150 */   618, 1395,  613, 1983,  517,  520,  146,  172, 2092, 2052,
 /*  1160 */   254,  620,   62,  356, 2048,  211, 1934,   47,  619,  663,
 /*  1170 */    13,   12,   47, 1955,  559,  664,  248,  243, 1326,  627,
 /*  1180 */   269, 1965,  595,  144, 1984, 2079,  146,  273,  129,  373,
 /*  1190 */   144, 1160, 1964, 1865, 2082, 1644, 1999, 1158,  584,  103,
 /*  1200 */  1966,  623, 1968, 1969,  618, 1801,  613,  256, 1212,  253,
 /*  1210 */   579, 2141, 1983, 2052, 1500,    1,  378,  356, 2048, 1449,
 /*  1220 */   620, 1957,    4,  383,  289, 1934, 1348,  619, 2086,  332,
 /*  1230 */   284, 1240,  188,  410, 1412, 1244,  445, 1866, 1251, 1407,
 /*  1240 */  1249,  414,  149,  419,  431, 1858,  438, 1965,  444,  446,
 /*  1250 */   452, 1964,  192,  455,  453, 1999,  457, 1413,  103, 1966,
 /*  1260 */   623, 1968, 1969,  618,  458,  613,  467, 1965,  470, 1415,
 /*  1270 */  2141,  198, 2052, 1410,  471,  200,  356, 2048, 1983, 1414,
 /*  1280 */   472, 1416,  203,  473,  475,  479,  620, 2099, 1115,  498,
 /*  1290 */   205, 1934,   82,  619,   83,  209,  496,  500, 1983,  497,
 /*  1300 */  1750,  106,  321,  215, 1746,  534,  620, 1911,  536,  285,
 /*  1310 */   217, 1934,  537,  619,  151,  538,  230, 1964,  544,  233,
 /*  1320 */   152, 1999, 1748, 1744,  103, 1966,  623, 1968, 1969,  618,
 /*  1330 */   153,  613,  154,  560, 1910, 2098, 2141, 1964, 2052,  551,
 /*  1340 */   593, 1999,  356, 2048,  103, 1966,  623, 1968, 1969,  618,
 /*  1350 */  2083,  613,  541,  554, 2097,  239, 2141,  557, 2052,  359,
 /*  1360 */   358,  346,  356, 2048, 1965, 2093,  242,  563,    7, 1398,
 /*  1370 */  2074,  569,  552, 2115,  247,  550,  549,  580, 2144, 1526,
 /*  1380 */  1463, 2120, 1391,  577,  347,  255,  252,  133, 1411,  588,
 /*  1390 */   286,  350, 2068,  591,  592, 1983,  261, 1882, 1881, 1880,
 /*  1400 */   352,  287,  597,  620,  596, 1458,   91,  288, 1934,   93,
 /*  1410 */   619, 1761,   59, 2033,   95,  165,  250, 1390,  625, 1805,
 /*  1420 */  1731,  706,  280, 1965,  249,  251,  709,  291,  707,   51,
 /*  1430 */   315,  295,  323,  293, 1964,  324, 1928,  300, 1999, 1927,
 /*  1440 */   314,  103, 1966,  623, 1968, 1969,  618,  304,  613,   75,
 /*  1450 */  1926, 1925,   76, 2141, 1983, 2052, 1922,  380,  381,  356,
 /*  1460 */  2048, 1376,  620, 1377,  609,  181,  385, 1934, 1920,  619,
 /*  1470 */  2071,  389,  387,  388, 1919,  391, 1918,  393, 1917,  395,
 /*  1480 */  1916,  397, 1351, 1350, 1893, 1892,  402,  403, 1891, 1890,
 /*  1490 */  1306, 1851, 1850, 1964, 1848,  139, 1847, 1999, 1846, 1849,
 /*  1500 */   103, 1966,  623, 1968, 1969,  618, 1845,  613, 1844, 1842,
 /*  1510 */  1841, 1840, 2027, 1965, 2052,  186,  420, 1839,  356, 2048,
 /*  1520 */   422, 1838, 1837, 1836, 1835, 1834, 1833, 1832, 1831, 1399,
 /*  1530 */  1830, 1394, 1829, 1828, 1827, 1826, 1825, 1824, 1823,  141,
 /*  1540 */  1822, 1821, 1820, 1819, 1983, 1818, 1817, 1816,  448, 1815,
 /*  1550 */  1814, 1308,  620, 1187, 1402, 1404, 1678, 1934,  193,  619,
 /*  1560 */  1677,  194, 1675, 1639,  170, 1101,  611, 1456, 1457, 1459,
 /*  1570 */  1460, 1461, 1462,  196, 1638, 1965, 1906, 1900,   73, 1100,
 /*  1580 */  1889,  204, 1888, 1964,  197, 1868, 1739, 1999, 1674, 1672,
 /*  1590 */   103, 1966,  623, 1968, 1969,  618,   74,  613, 1965, 1954,
 /*  1600 */   463,  465, 2025,  202, 2052,  480, 1983,  481,  356, 2048,
 /*  1610 */   482, 1670, 1134,  484,  620, 1668,  485,  489,  486, 1934,
 /*  1620 */   490,  619,  488, 1666, 1653,  492, 1652, 1635, 1741, 1983,
 /*  1630 */   494,  493, 1256, 1740, 1255, 1178, 1177,  620, 1176, 1175,
 /*  1640 */   678, 1172, 1934,  680,  619, 1964, 1664, 1170, 1171, 1999,
 /*  1650 */  1657, 1169,  103, 1966,  623, 1968, 1969,  618,  341,  613,
 /*  1660 */   518,  342,   61,  214,  606, 1965, 2052, 1655, 1964,  343,
 /*  1670 */   356, 2048, 1999, 1634, 1633,  104, 1966,  623, 1968, 1969,
 /*  1680 */   618, 1632,  613,  521,  523,  527,  525, 1366, 1965, 2052,
 /*  1690 */   105, 1368, 1365, 2051, 2048,  531, 1983,   26, 1905, 1357,
 /*  1700 */  1899,  155,  539, 1887,  620, 1885,   19, 2126,   16, 1934,
 /*  1710 */  1572,  619,   28,  238,  553,  555,  240, 1556,   55, 1983,
 /*  1720 */    58,  245,  246,   30,  163,  244,   29,  620, 1548,  540,
 /*  1730 */  1955,   20, 1934, 1592,  619, 1964,  344,  234,   88, 1999,
 /*  1740 */  1593,   63,  104, 1966,  623, 1968, 1969,  618, 1587,  613,
 /*  1750 */    21, 1965,   17, 1586,  348, 1591, 2052, 1590,  621,  349,
 /*  1760 */   608, 2048, 1999,  545,    5,  104, 1966,  623, 1968, 1969,
 /*  1770 */   618, 1965,  613,  258, 1523,    6,   57,  166, 1522, 2052,
 /*  1780 */  1886, 1884, 1983,  326, 2048, 1883,   22, 1867,  263, 1554,
 /*  1790 */   620,  265,  270,   90,   65, 1934,   92,  619,  275,  272,
 /*  1800 */   594,   23, 1983,   12,   10, 1485, 1400,   96, 1453, 2002,
 /*  1810 */   620,  612,  167, 1451,  179, 1934,   36,  619, 1431, 1450,
 /*  1820 */  1475, 1964,   15,  626,   24, 1999,  364, 1423,  161, 1966,
 /*  1830 */   623, 1968, 1969,  618, 1474,  613,   25,  630, 1241,  624,
 /*  1840 */  1965, 1964,  628,  633, 1238, 1999, 1235,  631,  162, 1966,
 /*  1850 */   623, 1968, 1969,  618,  622,  613,  634,  636, 1229,  637,
 /*  1860 */   639,   56, 1227,  640, 1233, 1232, 1218,  646, 1231,  548,
 /*  1870 */  2089, 1983, 1230,   97,  278, 1250, 1246,   98, 1132,  620,
 /*  1880 */   656,   72, 1166, 1165, 1934, 1164,  619, 1163, 1162, 1185,
 /*  1890 */  1161, 1159, 1157, 1156, 1965, 1155,  668, 1153, 1152, 1151,
 /*  1900 */   573, 2142, 1150,  279, 1149, 1182, 1148, 1147, 1180, 1144,
 /*  1910 */  1964, 1965, 1143, 1140, 1999, 1138, 1139,  104, 1966,  623,
 /*  1920 */  1968, 1969,  618, 1137,  613, 1983, 1671,  688,  690, 1669,
 /*  1930 */   689, 2052,  692,  620,  693,  694, 2049, 1667, 1934,  696,
 /*  1940 */   619,  698, 1983, 1665,  700,  702,  697,  701, 1651,  704,
 /*  1950 */   620, 1090, 1631,  282,  708, 1934, 1386,  619,  292,  711,
 /*  1960 */   712, 1606, 1606, 1606, 1964, 1965, 1606, 1606, 1999, 1606,
 /*  1970 */  1606,  161, 1966,  623, 1968, 1969,  618, 1606,  613, 1606,
 /*  1980 */  1606, 1964, 1606, 1965, 1606, 1999, 1606, 1606,  306, 1966,
 /*  1990 */   623, 1968, 1969,  618, 1606,  613, 1983, 1606, 1606, 1606,
 /*  2000 */  1606, 1606, 1606, 1606,  620, 1606, 1606, 1606, 1606, 1934,
 /*  2010 */  1606,  619, 1606, 2090, 1983, 1606, 1606, 1606, 1606,  351,
 /*  2020 */  1606, 1606,  620, 1606, 1606, 1606, 1606, 1934, 1606,  619,
 /*  2030 */  1606, 1606,  568, 1606, 1606, 1964, 1606, 1965, 1606, 1999,
 /*  2040 */  1606, 1606,  162, 1966,  623, 1968, 1969,  618, 1606,  613,
 /*  2050 */  1606, 1606, 1606, 1964, 1606, 1965, 1606, 1999, 1606, 1606,
 /*  2060 */   313, 1966,  623, 1968, 1969,  618, 1606,  613, 1983, 1606,
 /*  2070 */  1606, 1606, 1606, 1606, 1606, 1606,  617, 1606, 1606, 1606,
 /*  2080 */  1606, 1934, 1606,  619, 1606, 1606, 1983, 1606, 1606, 1606,
 /*  2090 */  1606,  361, 1606, 1606,  620, 2143, 1606, 1606, 1606, 1934,
 /*  2100 */  1606,  619, 1606, 1606, 1606, 1606, 1606, 1964, 1606, 1606,
 /*  2110 */  1965, 1999, 1606, 1606,  312, 1966,  623, 1968, 1969,  618,
 /*  2120 */  1606,  613, 1606, 2018, 1606, 1964, 1606, 1606, 1606, 1999,
 /*  2130 */  1965, 1606,  313, 1966,  623, 1968, 1969,  618, 1606,  613,
 /*  2140 */  1606, 1983, 1606, 1606, 1606, 1606,  363, 1606, 1606,  620,
 /*  2150 */  1606, 1606, 1606, 1606, 1934, 1606,  619, 1606, 1606, 1606,
 /*  2160 */  1606, 1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,  620,
 /*  2170 */  1606, 1606, 1606, 1606, 1934, 1606,  619, 1606, 1606, 1606,
 /*  2180 */  1964, 1606, 1606, 1606, 1999, 1606, 1606,  313, 1966,  623,
 /*  2190 */  1968, 1969,  618, 1606,  613, 1606, 1606, 1965, 1606, 1606,
 /*  2200 */   533, 1606, 1606, 1606, 1999, 1606, 1606,  308, 1966,  623,
 /*  2210 */  1968, 1969,  618, 1606,  613, 1606, 1606, 1606, 1606, 1606,
 /*  2220 */  1606, 1606, 1965, 1606, 1606, 1606, 1606, 1606, 1983, 1606,
 /*  2230 */  1606, 1606, 1606, 1606, 1606, 1606,  620, 1606, 1606, 1606,
 /*  2240 */  1606, 1934, 1606,  619, 1606, 1606, 1606, 1606, 1606, 1965,
 /*  2250 */  1606, 1606, 1606, 1983, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2260 */  1606,  620, 1606, 1606, 1606, 1606, 1934, 1964,  619, 1606,
 /*  2270 */  1606, 1999, 1606, 1606,  297, 1966,  623, 1968, 1969,  618,
 /*  2280 */  1983,  613, 1606, 1606, 1606, 1606, 1606, 1606,  620, 1606,
 /*  2290 */  1606, 1606, 1964, 1934, 1606,  619, 1999, 1606, 1606,  298,
 /*  2300 */  1966,  623, 1968, 1969,  618, 1606,  613, 1606, 1606, 1965,
 /*  2310 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1964,
 /*  2320 */  1606, 1606, 1606, 1999, 1606, 1606,  299, 1966,  623, 1968,
 /*  2330 */  1969,  618, 1965,  613, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2340 */  1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,  620, 1606,
 /*  2350 */  1606, 1606, 1606, 1934, 1606,  619, 1606, 1606, 1606, 1606,
 /*  2360 */  1606, 1606, 1606, 1983, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2370 */  1606,  620, 1606, 1606, 1606, 1606, 1934, 1606,  619, 1964,
 /*  2380 */  1606, 1606, 1606, 1999, 1606, 1606,  305, 1966,  623, 1968,
 /*  2390 */  1969,  618, 1965,  613, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2400 */  1606, 1606, 1964, 1606, 1606, 1606, 1999, 1606, 1606,  309,
 /*  2410 */  1966,  623, 1968, 1969,  618, 1606,  613, 1606, 1606, 1965,
 /*  2420 */  1606, 1606, 1606, 1983, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2430 */  1606,  620, 1606, 1606, 1606, 1606, 1934, 1606,  619, 1606,
 /*  2440 */  1606, 1606, 1606, 1606, 1965, 1606, 1606, 1606, 1606, 1606,
 /*  2450 */  1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,  620, 1606,
 /*  2460 */  1606, 1606, 1964, 1934, 1606,  619, 1999, 1606, 1606,  301,
 /*  2470 */  1966,  623, 1968, 1969,  618, 1983,  613, 1606, 1606, 1606,
 /*  2480 */  1606, 1606, 1606,  620, 1606, 1606, 1606, 1606, 1934, 1964,
 /*  2490 */   619, 1606, 1606, 1999, 1606, 1606,  310, 1966,  623, 1968,
 /*  2500 */  1969,  618, 1965,  613, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2510 */  1606, 1606, 1606, 1606, 1964, 1606, 1606, 1606, 1999, 1965,
 /*  2520 */  1606,  302, 1966,  623, 1968, 1969,  618, 1606,  613, 1606,
 /*  2530 */  1606, 1606, 1606, 1983, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2540 */  1606,  620, 1606, 1606, 1606, 1606, 1934, 1606,  619, 1606,
 /*  2550 */  1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,  620, 1606,
 /*  2560 */  1606, 1606, 1606, 1934, 1606,  619, 1606, 1606, 1606, 1606,
 /*  2570 */  1606, 1965, 1964, 1606, 1606, 1606, 1999, 1606, 1606,  311,
 /*  2580 */  1966,  623, 1968, 1969,  618, 1606,  613, 1606, 1606, 1964,
 /*  2590 */  1606, 1606, 1606, 1999, 1965, 1606,  303, 1966,  623, 1968,
 /*  2600 */  1969,  618, 1983,  613, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2610 */   620, 1606, 1606, 1606, 1606, 1934, 1606,  619, 1606, 1606,
 /*  2620 */  1606, 1606, 1606, 1965, 1606, 1983, 1606, 1606, 1606, 1606,
 /*  2630 */  1606, 1606, 1606,  620, 1606, 1606, 1606, 1606, 1934, 1606,
 /*  2640 */   619, 1964, 1606, 1606, 1606, 1999, 1606, 1606,  316, 1966,
 /*  2650 */   623, 1968, 1969,  618, 1983,  613, 1606, 1606, 1606, 1606,
 /*  2660 */  1606, 1606,  620, 1606, 1964, 1606, 1606, 1934, 1999,  619,
 /*  2670 */  1606,  317, 1966,  623, 1968, 1969,  618, 1606,  613, 1606,
 /*  2680 */  1606, 1965, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2690 */  1606, 1606, 1606, 1964, 1606, 1606, 1606, 1999, 1606, 1965,
 /*  2700 */  1977, 1966,  623, 1968, 1969,  618, 1606,  613, 1606, 1606,
 /*  2710 */  1606, 1606, 1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2720 */   620, 1606, 1606, 1606, 1606, 1934, 1606,  619, 1606, 1606,
 /*  2730 */  1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,  620, 1606,
 /*  2740 */  1606, 1606, 1606, 1934, 1606,  619, 1606, 1606, 1606, 1606,
 /*  2750 */  1606, 1964, 1606, 1606, 1606, 1999, 1606, 1606, 1976, 1966,
 /*  2760 */   623, 1968, 1969,  618, 1965,  613, 1606, 1606, 1606, 1964,
 /*  2770 */  1606, 1606, 1606, 1999, 1606, 1606, 1975, 1966,  623, 1968,
 /*  2780 */  1969,  618, 1606,  613, 1606, 1606, 1965, 1606, 1606, 1606,
 /*  2790 */  1606, 1606, 1606, 1606, 1606, 1983, 1606, 1606, 1606, 1606,
 /*  2800 */  1606, 1606, 1606,  620, 1606, 1606, 1606, 1606, 1934, 1606,
 /*  2810 */   619, 1606, 1606, 1606, 1606, 1606, 1606, 1983, 1606, 1606,
 /*  2820 */  1606, 1606, 1606, 1606, 1606,  620, 1606, 1606, 1606, 1606,
 /*  2830 */  1934, 1606,  619, 1606, 1964, 1606, 1606, 1606, 1999, 1606,
 /*  2840 */  1606,  328, 1966,  623, 1968, 1969,  618, 1965,  613, 1606,
 /*  2850 */  1606, 1606, 1606, 1606, 1606, 1606, 1964, 1606, 1606, 1606,
 /*  2860 */  1999, 1606, 1606,  329, 1966,  623, 1968, 1969,  618, 1965,
 /*  2870 */   613, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1983, 1606,
 /*  2880 */  1606, 1606, 1606, 1606, 1606, 1606,  620, 1606, 1606, 1606,
 /*  2890 */  1606, 1934, 1606,  619, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2900 */  1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,  620, 1606,
 /*  2910 */  1606, 1606, 1606, 1934, 1606,  619, 1606, 1964, 1606, 1606,
 /*  2920 */  1606, 1999, 1606, 1606,  325, 1966,  623, 1968, 1969,  618,
 /*  2930 */  1965,  613, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1964,
 /*  2940 */  1606, 1606, 1606, 1999, 1606, 1606,  330, 1966,  623, 1968,
 /*  2950 */  1969,  618, 1606,  613, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2960 */  1606, 1983, 1606, 1606, 1606, 1606, 1606, 1606, 1606,  620,
 /*  2970 */  1606, 1606, 1606, 1606, 1934, 1606,  619, 1606, 1606, 1606,
 /*  2980 */  1606, 1606, 1965, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  2990 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  3000 */   621, 1606, 1606, 1606, 1999, 1606, 1606,  308, 1966,  623,
 /*  3010 */  1968, 1969,  618, 1983,  613, 1606, 1606, 1606, 1606, 1606,
 /*  3020 */  1606,  620, 1606, 1606, 1606, 1606, 1934, 1606,  619, 1606,
 /*  3030 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  3040 */  1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606, 1606,
 /*  3050 */  1606, 1606, 1964, 1606, 1606, 1606, 1999, 1606, 1606,  307,
 /*  3060 */  1966,  623, 1968, 1969,  618, 1606,  613,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   359,  335,  331,  373,  333,  334,  331,  369,  333,  334,
 /*    10 */   372,  373,   12,   13,   14,  360,  386,  387,  327,   14,
 /*    20 */    20,  359,   22,    8,    9,   20,  371,   12,   13,   14,
 /*    30 */    15,   16,  358,   33,  332,   35,  351,  335,  336,  354,
 /*    40 */   430,  375,    8,    9,  434,  358,   12,   13,   14,   15,
 /*    50 */    16,   20,  365,  379,  380,  400,  401,  402,   58,  449,
 /*    60 */   450,  374,  371,   63,  454,  455,  411,    8,    9,  327,
 /*    70 */    70,   12,   13,   14,   15,   16,  332,   20,  335,  335,
 /*    80 */   336,    8,    9,   12,   13,   12,   13,   14,   15,   16,
 /*    90 */   350,   20,  357,   22,    0,   95,  335,   63,  358,   20,
 /*   100 */   358,   22,    3,   44,   33,  370,   35,  367,  366,  366,
 /*   110 */   349,   96,   20,  371,  335,  373,   20,  117,   24,   25,
 /*   120 */    26,   27,   28,   29,   30,   31,   32,  366,  349,   58,
 /*   130 */    51,  324,  132,  133,   63,  356,  419,  420,  104,  397,
 /*   140 */   341,   70,   62,  401,    4,  366,  404,  405,  406,  407,
 /*   150 */   408,  409,   20,  411,  355,  430,  372,  373,  416,  434,
 /*   160 */   418,  161,  162,  364,  422,  423,   95,  167,  168,  426,
 /*   170 */   427,  428,    0,  430,  431,  450,  341,  434,  436,  454,
 /*   180 */   455,  430,  182,    3,  184,  434,  444,   95,  117,  132,
 /*   190 */   133,  342,  449,  450,  160,  388,  347,  454,  455,  364,
 /*   200 */    20,  450,   20,  132,  133,  454,  455,  207,  208,  177,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,   95,  132,  133,
 /*   230 */   198,  199,  161,  162,   62,   95,  163,  430,  167,  168,
 /*   240 */    21,  434,  106,   24,   25,   26,   27,   28,   29,   30,
 /*   250 */    31,   32,   37,  182,  207,  184,  449,  450,   14,   15,
 /*   260 */    16,  454,  455,  167,  168,  231,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,   96,   95,  207,  208,
 /*   280 */    58,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  358,  228,
 /*   300 */    12,   13,  255,  256,  257,  258,  259,  326,   20,  328,
 /*   310 */    22,    4,  127,   98,   20,  100,  101,   95,  103,   97,
 /*   320 */   380,   33,  107,   35,  108,  109,  110,  111,  112,  113,
 /*   330 */   114,  115,  116,  117,  118,    0,  120,  121,  122,  123,
 /*   340 */   124,  125,   33,  163,  129,  360,   58,   20,  360,  388,
 /*   350 */    43,   63,   45,   46,  358,  228,  371,   48,   70,  371,
 /*   360 */   350,  365,  263,   54,   55,   56,   57,   58,  358,   95,
 /*   370 */   374,   12,   13,   14,  189,  190,  244,  367,  193,   20,
 /*   380 */   195,   22,  358,   95,  244,  400,  401,  402,  400,  401,
 /*   390 */   366,  430,   33,   95,   35,  434,  411,  344,  345,  411,
 /*   400 */    65,   66,   67,   94,   20,  117,   97,    0,   73,   74,
 /*   410 */   449,  450,  228,   78,  230,  454,  455,   58,   83,   84,
 /*   420 */   132,  133,  126,  127,   89,    0,  244,  131,   21,   70,
 /*   430 */   406,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   440 */     8,    9,  344,  345,   12,   13,   14,   15,   16,  161,
 /*   450 */   162,  350,   20,  358,   95,  167,  168,    8,    9,  358,
 /*   460 */   365,   12,   13,   14,   15,   16,  244,  403,  367,  374,
 /*   470 */   182,   14,  184,  164,  165,   95,  117,   20,  169,    8,
 /*   480 */     9,  172,   62,   12,   13,   14,   15,   16,  161,  162,
 /*   490 */    35,  132,  133,  429,  327,  207,  208,  188,  210,  211,
 /*   500 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   510 */   222,  223,  224,  225,  226,   65,   66,   67,  244,   20,
 /*   520 */   161,  162,   21,   73,   74,  430,  167,  168,   78,  434,
 /*   530 */    35,  403,  107,   83,   84,   34,  403,   36,  371,   89,
 /*   540 */    20,  182,  244,  184,  449,  450,  339,  163,  327,  454,
 /*   550 */   455,  126,  127,  128,  129,  130,  131,  429,  335,  388,
 /*   560 */   353,  181,  429,  183,  327,   70,  207,  208,  361,  210,
 /*   570 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   580 */   221,  222,  223,  224,  225,  226,   12,   13,  335,  366,
 /*   590 */    22,   14,  371,    0,   20,  163,   22,   20,   19,  163,
 /*   600 */   373,  430,  349,   35,   58,  434,  170,   33,  371,   35,
 /*   610 */   383,   44,   33,  386,  387,  335,  327,    0,  161,  366,
 /*   620 */   449,  450,  388,  174,  244,  454,  455,   48,  335,  349,
 /*   630 */   360,  366,   58,   54,   55,   56,   57,   58,   70,  184,
 /*   640 */    94,  371,  377,   97,   70,  366,  366,  358,  425,  426,
 /*   650 */   427,  428,  339,  430,  431,  366,  377,   12,   13,  366,
 /*   660 */   371,  335,  373,   96,  430,   20,  160,   22,  434,   95,
 /*   670 */   400,  401,  327,   94,  361,  349,   97,  335,   33,   62,
 /*   680 */    35,  411,  356,  449,  450,  117,  397,   79,  454,  455,
 /*   690 */   401,  117,  366,  404,  405,  406,  407,  408,  409,  410,
 /*   700 */   411,  412,  413,   58,    0,  327,  132,  133,  366,  130,
 /*   710 */    12,   13,   14,   15,   16,   70,  371,  268,  166,  426,
 /*   720 */   427,  428,  327,  430,  431,  414,    8,    9,  417,  359,
 /*   730 */    12,   13,   14,   15,   16,  161,  162,  231,  161,  327,
 /*   740 */    95,  167,  168,  335,  151,  137,  138,  241,  169,  371,
 /*   750 */   182,  415,  184,  417,    1,    2,  182,  349,  184,  126,
 /*   760 */   327,  415,  117,  417,   20,  186,  371,  188,  426,  427,
 /*   770 */   428,   20,  430,  431,  366,  207,  208,  132,  133,   39,
 /*   780 */   388,  207,  208,  371,  210,  211,  212,  213,  214,  215,
 /*   790 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   800 */   226,  249,  250,  251,  371,  335,  161,  162,   18,  358,
 /*   810 */    20,  107,  167,  168,   96,  242,  243,   27,  367,  349,
 /*   820 */    30,  358,  430,   33,  191,  192,  434,  182,  366,  184,
 /*   830 */   126,  127,  128,  129,  130,  131,  366,  374,   48,  377,
 /*   840 */    50,  449,  450,   53,   20,  327,  454,  455,  368,   96,
 /*   850 */    44,  371,  207,  208,   63,  210,  211,  212,  213,  214,
 /*   860 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  224,
 /*   870 */   225,  226,  327,  368,  327,  346,  371,  348,   18,  368,
 /*   880 */   327,    2,  371,   23,   94,    0,  335,    8,    9,  371,
 /*   890 */     4,   12,   13,   14,   15,   16,  106,   37,   38,    2,
 /*   900 */   349,   41,  327,   45,   46,    8,    9,  163,   70,   12,
 /*   910 */    13,   14,   15,   16,  163,   22,  371,  366,  371,   59,
 /*   920 */    60,   61,  351,   70,  371,  354,  136,  392,   35,  139,
 /*   930 */   140,  141,  142,  143,  144,  145,  146,  147,  148,  149,
 /*   940 */   150,  151,  152,  153,  154,  155,  371,  157,  158,  159,
 /*   950 */    65,   66,   67,   68,   69,   95,   71,   72,   73,   74,
 /*   960 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   970 */    85,   86,   87,   88,   89,   90,   91,   20,  107,   22,
 /*   980 */    42,    0,   44,  243,   58,  161,  327,   44,  327,  327,
 /*   990 */   335,  335,   35,  335,  134,  335,  107,  327,  207,    4,
 /*  1000 */   129,   42,   35,   44,  349,  349,  327,  349,   51,  349,
 /*  1010 */   359,  335,  388,  335,   19,  126,  127,  128,  129,  130,
 /*  1020 */   131,  366,  366,   97,  366,  349,  366,  349,   33,   48,
 /*  1030 */   371,  359,  371,  371,  174,  175,  176,  358,  327,  179,
 /*  1040 */   359,  371,  366,   48,  366,  366,   99,  359,   53,  102,
 /*  1050 */   371,    0,  373,   58,  430,  132,  133,  197,  434,   35,
 /*  1060 */   200,  106,  202,  203,  204,  205,  206,  335,  327,   99,
 /*  1070 */   347,  265,  102,  449,  450,   44,  397,  335,  454,  455,
 /*  1080 */   401,  349,  371,  404,  405,  406,  407,  408,  409,   94,
 /*  1090 */   411,  349,   97,  414,   70,  416,  417,  418,  366,  358,
 /*  1100 */    49,  422,  423,  335,  244,  335,  335,  366,  366,  335,
 /*  1110 */   335,  156,  371,   99,  373,   99,  102,  349,  102,  349,
 /*  1120 */   349,    0,  327,  349,  349,   44,   44,   96,   44,   95,
 /*  1130 */    44,  245,    0,    0,  366,   44,  366,  366,  397,  105,
 /*  1140 */   366,  366,  401,   22,  328,  404,  405,  406,  407,  408,
 /*  1150 */   409,  184,  411,  358,   22,   22,   44,  416,  381,  418,
 /*  1160 */   458,  366,   44,  422,  423,  337,  371,   44,  373,   13,
 /*  1170 */     1,    2,   44,   47,  447,   13,  441,   96,   96,   44,
 /*  1180 */    96,  327,   96,   44,  358,  444,   44,   96,   44,  337,
 /*  1190 */    44,   35,  397,  381,  381,  334,  401,   35,  432,  404,
 /*  1200 */   405,  406,  407,  408,  409,  370,  411,  451,   96,  424,
 /*  1210 */   267,  416,  358,  418,   96,  435,  399,  422,  423,   96,
 /*  1220 */   366,   95,  246,   48,   96,  371,  180,  373,  433,  398,
 /*  1230 */   390,   96,   42,  378,   20,   96,  160,  381,   96,   20,
 /*  1240 */    96,  378,   96,  376,  335,  335,  378,  327,  376,  376,
 /*  1250 */    93,  397,  335,  335,  343,  401,  335,   20,  404,  405,
 /*  1260 */   406,  407,  408,  409,  329,  411,  329,  327,  394,   20,
 /*  1270 */   416,  341,  418,   20,  373,  341,  422,  423,  358,   20,
 /*  1280 */   336,   20,  341,  389,  336,  335,  366,  433,   52,  329,
 /*  1290 */   341,  371,  341,  373,  341,  341,  338,  358,  358,  338,
 /*  1300 */   358,  335,  329,  358,  358,  196,  366,  371,  396,  394,
 /*  1310 */   358,  371,  187,  373,  358,  393,  339,  397,  335,  339,
 /*  1320 */   358,  401,  358,  358,  404,  405,  406,  407,  408,  409,
 /*  1330 */   358,  411,  358,  254,  371,  440,  416,  397,  418,  371,
 /*  1340 */   253,  401,  422,  423,  404,  405,  406,  407,  408,  409,
 /*  1350 */   381,  411,  373,  433,  440,  384,  416,  371,  418,   12,
 /*  1360 */    13,  371,  422,  423,  327,  381,  384,  371,  260,   22,
 /*  1370 */   443,  173,  262,  433,  442,  261,  247,  266,  459,  243,
 /*  1380 */    33,  453,   35,  264,  269,  452,  399,  366,   20,  335,
 /*  1390 */   384,  336,  403,  371,  371,  358,  339,  371,  371,  371,
 /*  1400 */   371,  384,  382,  366,  165,   58,  339,  354,  371,  339,
 /*  1410 */   373,  366,   95,  421,   95,  440,  438,   70,  362,  371,
 /*  1420 */   348,   36,  339,  327,  439,  437,  329,  335,  330,  391,
 /*  1430 */   395,  325,  385,  340,  397,  385,    0,  352,  401,    0,
 /*  1440 */   352,  404,  405,  406,  407,  408,  409,  352,  411,  189,
 /*  1450 */     0,    0,   42,  416,  358,  418,    0,   35,  201,  422,
 /*  1460 */   423,   35,  366,   35,  117,   35,  201,  371,    0,  373,
 /*  1470 */   433,  201,   35,   35,    0,  201,    0,   35,    0,   22,
 /*  1480 */     0,   35,  184,  182,    0,    0,  178,  177,    0,    0,
 /*  1490 */    47,    0,    0,  397,    0,   42,    0,  401,    0,    0,
 /*  1500 */   404,  405,  406,  407,  408,  409,    0,  411,    0,    0,
 /*  1510 */     0,    0,  416,  327,  418,  151,   35,    0,  422,  423,
 /*  1520 */   151,    0,    0,    0,    0,    0,    0,    0,    0,  182,
 /*  1530 */     0,  184,    0,    0,    0,    0,    0,    0,    0,   42,
 /*  1540 */     0,    0,    0,    0,  358,    0,    0,    0,  135,    0,
 /*  1550 */     0,   22,  366,   35,  207,  208,    0,  371,   58,  373,
 /*  1560 */     0,   58,    0,    0,   44,   14,  219,  220,  221,  222,
 /*  1570 */   223,  224,  225,   42,    0,  327,    0,    0,   39,   14,
 /*  1580 */     0,  173,    0,  397,   40,    0,    0,  401,    0,    0,
 /*  1590 */   404,  405,  406,  407,  408,  409,   39,  411,  327,   47,
 /*  1600 */    47,   47,  416,   39,  418,   35,  358,   48,  422,  423,
 /*  1610 */    39,    0,   64,   35,  366,    0,   48,   48,   39,  371,
 /*  1620 */    39,  373,   35,    0,    0,   35,    0,    0,    0,  358,
 /*  1630 */    39,   48,   35,    0,   22,   35,   35,  366,   35,   35,
 /*  1640 */    44,   35,  371,   44,  373,  397,    0,   22,   35,  401,
 /*  1650 */     0,   35,  404,  405,  406,  407,  408,  409,   22,  411,
 /*  1660 */    50,   22,  104,  102,  416,  327,  418,    0,  397,   22,
 /*  1670 */   422,  423,  401,    0,    0,  404,  405,  406,  407,  408,
 /*  1680 */   409,    0,  411,   35,   35,   22,   35,   35,  327,  418,
 /*  1690 */    20,   96,   35,  422,  423,  194,  358,   95,    0,   35,
 /*  1700 */     0,  185,   22,    0,  366,    0,   44,    3,  248,  371,
 /*  1710 */    96,  373,   95,   95,  227,  252,   96,   96,  163,  358,
 /*  1720 */    44,   44,   47,   44,   95,   95,   95,  366,   96,  163,
 /*  1730 */    47,  248,  371,   96,  373,  397,  163,  165,   95,  401,
 /*  1740 */    96,    3,  404,  405,  406,  407,  408,  409,   35,  411,
 /*  1750 */    44,  327,  248,   35,   35,   35,  418,   35,  397,   35,
 /*  1760 */   422,  423,  401,  171,  170,  404,  405,  406,  407,  408,
 /*  1770 */   409,  327,  411,   47,   96,  170,   44,   47,   96,  418,
 /*  1780 */     0,    0,  358,  422,  423,    0,   95,    0,   96,   96,
 /*  1790 */   366,   95,   95,   39,   95,  371,   95,  373,   47,  164,
 /*  1800 */   166,   44,  358,    2,  229,  207,   22,  105,   96,   95,
 /*  1810 */   366,   95,   47,   96,   47,  371,   95,  373,   22,   96,
 /*  1820 */   227,  397,   95,   35,   95,  401,   35,   96,  404,  405,
 /*  1830 */   406,  407,  408,  409,  227,  411,   95,   35,   96,  106,
 /*  1840 */   327,  397,   95,   35,   96,  401,   96,   95,  404,  405,
 /*  1850 */   406,  407,  408,  409,  209,  411,   95,   35,   96,   95,
 /*  1860 */    35,  242,   96,   95,  119,  119,   22,  107,  119,  445,
 /*  1870 */   446,  358,  119,   95,   44,   35,   22,   95,   64,  366,
 /*  1880 */    63,   95,   35,   35,  371,   35,  373,   35,   35,   70,
 /*  1890 */    35,   35,   35,   35,  327,   35,   92,   35,   35,   35,
 /*  1900 */   456,  457,   22,   44,   35,   70,   35,   35,   35,   35,
 /*  1910 */   397,  327,   35,   35,  401,   22,   35,  404,  405,  406,
 /*  1920 */   407,  408,  409,   35,  411,  358,    0,   35,   39,    0,
 /*  1930 */    48,  418,   35,  366,   48,   39,  423,    0,  371,   35,
 /*  1940 */   373,   39,  358,    0,   35,   39,   48,   48,    0,   35,
 /*  1950 */   366,   35,    0,   22,   21,  371,   22,  373,   22,   21,
 /*  1960 */    20,  460,  460,  460,  397,  327,  460,  460,  401,  460,
 /*  1970 */   460,  404,  405,  406,  407,  408,  409,  460,  411,  460,
 /*  1980 */   460,  397,  460,  327,  460,  401,  460,  460,  404,  405,
 /*  1990 */   406,  407,  408,  409,  460,  411,  358,  460,  460,  460,
 /*  2000 */   460,  460,  460,  460,  366,  460,  460,  460,  460,  371,
 /*  2010 */   460,  373,  460,  446,  358,  460,  460,  460,  460,  363,
 /*  2020 */   460,  460,  366,  460,  460,  460,  460,  371,  460,  373,
 /*  2030 */   460,  460,  448,  460,  460,  397,  460,  327,  460,  401,
 /*  2040 */   460,  460,  404,  405,  406,  407,  408,  409,  460,  411,
 /*  2050 */   460,  460,  460,  397,  460,  327,  460,  401,  460,  460,
 /*  2060 */   404,  405,  406,  407,  408,  409,  460,  411,  358,  460,
 /*  2070 */   460,  460,  460,  460,  460,  460,  366,  460,  460,  460,
 /*  2080 */   460,  371,  460,  373,  460,  460,  358,  460,  460,  460,
 /*  2090 */   460,  363,  460,  460,  366,  457,  460,  460,  460,  371,
 /*  2100 */   460,  373,  460,  460,  460,  460,  460,  397,  460,  460,
 /*  2110 */   327,  401,  460,  460,  404,  405,  406,  407,  408,  409,
 /*  2120 */   460,  411,  460,  413,  460,  397,  460,  460,  460,  401,
 /*  2130 */   327,  460,  404,  405,  406,  407,  408,  409,  460,  411,
 /*  2140 */   460,  358,  460,  460,  460,  460,  363,  460,  460,  366,
 /*  2150 */   460,  460,  460,  460,  371,  460,  373,  460,  460,  460,
 /*  2160 */   460,  358,  460,  460,  460,  460,  460,  460,  460,  366,
 /*  2170 */   460,  460,  460,  460,  371,  460,  373,  460,  460,  460,
 /*  2180 */   397,  460,  460,  460,  401,  460,  460,  404,  405,  406,
 /*  2190 */   407,  408,  409,  460,  411,  460,  460,  327,  460,  460,
 /*  2200 */   397,  460,  460,  460,  401,  460,  460,  404,  405,  406,
 /*  2210 */   407,  408,  409,  460,  411,  460,  460,  460,  460,  460,
 /*  2220 */   460,  460,  327,  460,  460,  460,  460,  460,  358,  460,
 /*  2230 */   460,  460,  460,  460,  460,  460,  366,  460,  460,  460,
 /*  2240 */   460,  371,  460,  373,  460,  460,  460,  460,  460,  327,
 /*  2250 */   460,  460,  460,  358,  460,  460,  460,  460,  460,  460,
 /*  2260 */   460,  366,  460,  460,  460,  460,  371,  397,  373,  460,
 /*  2270 */   460,  401,  460,  460,  404,  405,  406,  407,  408,  409,
 /*  2280 */   358,  411,  460,  460,  460,  460,  460,  460,  366,  460,
 /*  2290 */   460,  460,  397,  371,  460,  373,  401,  460,  460,  404,
 /*  2300 */   405,  406,  407,  408,  409,  460,  411,  460,  460,  327,
 /*  2310 */   460,  460,  460,  460,  460,  460,  460,  460,  460,  397,
 /*  2320 */   460,  460,  460,  401,  460,  460,  404,  405,  406,  407,
 /*  2330 */   408,  409,  327,  411,  460,  460,  460,  460,  460,  460,
 /*  2340 */   358,  460,  460,  460,  460,  460,  460,  460,  366,  460,
 /*  2350 */   460,  460,  460,  371,  460,  373,  460,  460,  460,  460,
 /*  2360 */   460,  460,  460,  358,  460,  460,  460,  460,  460,  460,
 /*  2370 */   460,  366,  460,  460,  460,  460,  371,  460,  373,  397,
 /*  2380 */   460,  460,  460,  401,  460,  460,  404,  405,  406,  407,
 /*  2390 */   408,  409,  327,  411,  460,  460,  460,  460,  460,  460,
 /*  2400 */   460,  460,  397,  460,  460,  460,  401,  460,  460,  404,
 /*  2410 */   405,  406,  407,  408,  409,  460,  411,  460,  460,  327,
 /*  2420 */   460,  460,  460,  358,  460,  460,  460,  460,  460,  460,
 /*  2430 */   460,  366,  460,  460,  460,  460,  371,  460,  373,  460,
 /*  2440 */   460,  460,  460,  460,  327,  460,  460,  460,  460,  460,
 /*  2450 */   358,  460,  460,  460,  460,  460,  460,  460,  366,  460,
 /*  2460 */   460,  460,  397,  371,  460,  373,  401,  460,  460,  404,
 /*  2470 */   405,  406,  407,  408,  409,  358,  411,  460,  460,  460,
 /*  2480 */   460,  460,  460,  366,  460,  460,  460,  460,  371,  397,
 /*  2490 */   373,  460,  460,  401,  460,  460,  404,  405,  406,  407,
 /*  2500 */   408,  409,  327,  411,  460,  460,  460,  460,  460,  460,
 /*  2510 */   460,  460,  460,  460,  397,  460,  460,  460,  401,  327,
 /*  2520 */   460,  404,  405,  406,  407,  408,  409,  460,  411,  460,
 /*  2530 */   460,  460,  460,  358,  460,  460,  460,  460,  460,  460,
 /*  2540 */   460,  366,  460,  460,  460,  460,  371,  460,  373,  460,
 /*  2550 */   358,  460,  460,  460,  460,  460,  460,  460,  366,  460,
 /*  2560 */   460,  460,  460,  371,  460,  373,  460,  460,  460,  460,
 /*  2570 */   460,  327,  397,  460,  460,  460,  401,  460,  460,  404,
 /*  2580 */   405,  406,  407,  408,  409,  460,  411,  460,  460,  397,
 /*  2590 */   460,  460,  460,  401,  327,  460,  404,  405,  406,  407,
 /*  2600 */   408,  409,  358,  411,  460,  460,  460,  460,  460,  460,
 /*  2610 */   366,  460,  460,  460,  460,  371,  460,  373,  460,  460,
 /*  2620 */   460,  460,  460,  327,  460,  358,  460,  460,  460,  460,
 /*  2630 */   460,  460,  460,  366,  460,  460,  460,  460,  371,  460,
 /*  2640 */   373,  397,  460,  460,  460,  401,  460,  460,  404,  405,
 /*  2650 */   406,  407,  408,  409,  358,  411,  460,  460,  460,  460,
 /*  2660 */   460,  460,  366,  460,  397,  460,  460,  371,  401,  373,
 /*  2670 */   460,  404,  405,  406,  407,  408,  409,  460,  411,  460,
 /*  2680 */   460,  327,  460,  460,  460,  460,  460,  460,  460,  460,
 /*  2690 */   460,  460,  460,  397,  460,  460,  460,  401,  460,  327,
 /*  2700 */   404,  405,  406,  407,  408,  409,  460,  411,  460,  460,
 /*  2710 */   460,  460,  358,  460,  460,  460,  460,  460,  460,  460,
 /*  2720 */   366,  460,  460,  460,  460,  371,  460,  373,  460,  460,
 /*  2730 */   358,  460,  460,  460,  460,  460,  460,  460,  366,  460,
 /*  2740 */   460,  460,  460,  371,  460,  373,  460,  460,  460,  460,
 /*  2750 */   460,  397,  460,  460,  460,  401,  460,  460,  404,  405,
 /*  2760 */   406,  407,  408,  409,  327,  411,  460,  460,  460,  397,
 /*  2770 */   460,  460,  460,  401,  460,  460,  404,  405,  406,  407,
 /*  2780 */   408,  409,  460,  411,  460,  460,  327,  460,  460,  460,
 /*  2790 */   460,  460,  460,  460,  460,  358,  460,  460,  460,  460,
 /*  2800 */   460,  460,  460,  366,  460,  460,  460,  460,  371,  460,
 /*  2810 */   373,  460,  460,  460,  460,  460,  460,  358,  460,  460,
 /*  2820 */   460,  460,  460,  460,  460,  366,  460,  460,  460,  460,
 /*  2830 */   371,  460,  373,  460,  397,  460,  460,  460,  401,  460,
 /*  2840 */   460,  404,  405,  406,  407,  408,  409,  327,  411,  460,
 /*  2850 */   460,  460,  460,  460,  460,  460,  397,  460,  460,  460,
 /*  2860 */   401,  460,  460,  404,  405,  406,  407,  408,  409,  327,
 /*  2870 */   411,  460,  460,  460,  460,  460,  460,  460,  358,  460,
 /*  2880 */   460,  460,  460,  460,  460,  460,  366,  460,  460,  460,
 /*  2890 */   460,  371,  460,  373,  460,  460,  460,  460,  460,  460,
 /*  2900 */   358,  460,  460,  460,  460,  460,  460,  460,  366,  460,
 /*  2910 */   460,  460,  460,  371,  460,  373,  460,  397,  460,  460,
 /*  2920 */   460,  401,  460,  460,  404,  405,  406,  407,  408,  409,
 /*  2930 */   327,  411,  460,  460,  460,  460,  460,  460,  460,  397,
 /*  2940 */   460,  460,  460,  401,  460,  460,  404,  405,  406,  407,
 /*  2950 */   408,  409,  460,  411,  460,  460,  460,  460,  460,  460,
 /*  2960 */   460,  358,  460,  460,  460,  460,  460,  460,  460,  366,
 /*  2970 */   460,  460,  460,  460,  371,  460,  373,  460,  460,  460,
 /*  2980 */   460,  460,  327,  460,  460,  460,  460,  460,  460,  460,
 /*  2990 */   460,  460,  460,  460,  460,  460,  460,  460,  460,  460,
 /*  3000 */   397,  460,  460,  460,  401,  460,  460,  404,  405,  406,
 /*  3010 */   407,  408,  409,  358,  411,  460,  460,  460,  460,  460,
 /*  3020 */   460,  366,  460,  460,  460,  460,  371,  460,  373,  460,
 /*  3030 */   460,  460,  460,  460,  460,  460,  460,  460,  460,  460,
 /*  3040 */   460,  460,  460,  460,  460,  460,  460,  460,  460,  460,
 /*  3050 */   460,  460,  397,  460,  460,  460,  401,  460,  460,  404,
 /*  3060 */   405,  406,  407,  408,  409,  460,  411,
};
#define YY_SHIFT_COUNT    (713)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1952)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   860,    0,   71,    0,  288,  288,  288,  288,  288,  288,
 /*    10 */   288,  288,  288,  288,  288,  359,  574,  574,  645,  574,
 /*    20 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    30 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    40 */   574,  574,  574,  574,  574,  574,  574,  574,  132,  182,
 /*    50 */    92,  380,  222,  274,  298,  274,   92,   92, 1347, 1347,
 /*    60 */   274, 1347, 1347,  140,  274,   96,   31,   31,   96,  307,
 /*    70 */   307,  327,   57,    5,    5,   31,   31,   31,   31,   31,
 /*    80 */    31,   31,   31,   31,   31,   80,   31,   31,  294,   31,
 /*    90 */    31,   31,  499,   31,   31,  499,   31,  499,  499,  499,
 /*   100 */    31,  420,  790,   34,   34,  219,  450,  568,  568,  568,
 /*   110 */   568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
 /*   120 */   568,  568,  568,  568,  568,  568,  215,  180,  327,   57,
 /*   130 */   172,  495,  384,  384,  384,  617,  184,  184,  495,  520,
 /*   140 */   520,  520,  136,  127,  499,  838,  499,  838,  838,  136,
 /*   150 */   853,  216,  216,  216,  216,  216,  216,  216,  579,  407,
 /*   160 */   335,  432,  449,   47,  957,  552,  457,  577,   79,  744,
 /*   170 */   858,  871,  751,  573,  740,   99,  573,  938,  886,  824,
 /*   180 */   976, 1175, 1046, 1190, 1214, 1190, 1076, 1219, 1219, 1190,
 /*   190 */  1076, 1076, 1157, 1219, 1219, 1219, 1237, 1237, 1249,   80,
 /*   200 */  1253,   80, 1259, 1261,   80, 1259,   80,   80,   80, 1219,
 /*   210 */    80, 1236, 1236, 1237,  499,  499,  499,  499,  499,  499,
 /*   220 */   499,  499,  499,  499,  499, 1219, 1237,  838,  838, 1109,
 /*   230 */  1249,  420, 1125, 1253,  420, 1219, 1214, 1214,  838, 1079,
 /*   240 */  1087,  838, 1079, 1087,  838,  838,  499, 1108, 1198, 1079,
 /*   250 */  1110, 1114, 1129,  976, 1115, 1111, 1119, 1136,  520, 1368,
 /*   260 */  1219, 1259,  420, 1087,  838,  838,  838,  838,  838, 1087,
 /*   270 */   838, 1239,  420,  136,  420,  520, 1317, 1319,  838,  853,
 /*   280 */  1219,  420, 1385, 1237, 3067, 3067, 3067, 3067, 3067, 3067,
 /*   290 */  3067, 3067, 3067,  885,  309,   94,  995,   15,   59,  718,
 /*   300 */   425,  879,  897,   73,  704,  471,  471,  471,  471,  471,
 /*   310 */   471,  471,  471,  471,  889,  185,  698,  698,   32,  546,
 /*   320 */   608,  501,  633,  296,  296,  244,  753,  506,  244,  244,
 /*   330 */   244,  567,  981,  893,  959,  955,  593,  947,  970, 1014,
 /*   340 */  1016, 1121, 1132, 1133,  926, 1031, 1081,  923,  806,  943,
 /*   350 */   436, 1082, 1084, 1086, 1091, 1112, 1169, 1118,  455,  967,
 /*   360 */   791, 1123, 1126, 1128, 1135, 1139, 1142, 1144, 1146, 1034,
 /*   370 */  1156, 1162, 1024, 1051, 1436, 1439, 1260, 1450, 1451, 1410,
 /*   380 */  1456, 1422, 1257, 1426, 1428, 1430, 1265, 1468, 1437, 1438,
 /*   390 */  1270, 1474, 1274, 1476, 1442, 1478, 1457, 1480, 1446, 1298,
 /*   400 */  1301, 1484, 1485, 1308, 1310, 1488, 1489, 1443, 1491, 1492,
 /*   410 */  1494, 1453, 1496, 1498, 1499, 1506, 1508, 1509, 1510, 1511,
 /*   420 */  1364, 1481, 1517, 1369, 1521, 1522, 1523, 1524, 1525, 1526,
 /*   430 */  1527, 1528, 1530, 1532, 1533, 1534, 1535, 1536, 1537, 1497,
 /*   440 */  1538, 1540, 1541, 1542, 1543, 1529, 1545, 1546, 1547, 1413,
 /*   450 */  1549, 1550, 1518, 1556, 1500, 1560, 1503, 1562, 1563, 1531,
 /*   460 */  1539, 1520, 1552, 1551, 1553, 1565, 1554, 1574, 1544, 1557,
 /*   470 */  1576, 1577, 1580, 1564, 1408, 1582, 1585, 1586, 1548, 1588,
 /*   480 */  1589, 1570, 1559, 1571, 1611, 1578, 1568, 1579, 1615, 1587,
 /*   490 */  1569, 1581, 1623, 1590, 1583, 1591, 1624, 1626, 1627, 1628,
 /*   500 */  1558, 1561, 1597, 1612, 1633, 1600, 1601, 1603, 1604, 1596,
 /*   510 */  1599, 1606, 1613, 1625, 1616, 1646, 1636, 1650, 1639, 1610,
 /*   520 */  1667, 1647, 1648, 1673, 1649, 1674, 1651, 1681, 1663, 1670,
 /*   530 */  1652, 1657, 1501, 1595, 1602, 1698, 1555, 1664, 1700, 1516,
 /*   540 */  1680, 1566, 1572, 1703, 1705, 1573, 1592, 1704, 1662, 1460,
 /*   550 */  1617, 1614, 1618, 1594, 1487, 1605, 1463, 1620, 1676, 1621,
 /*   560 */  1629, 1630, 1631, 1632, 1677, 1675, 1683, 1643, 1679, 1483,
 /*   570 */  1637, 1644, 1738, 1706, 1504, 1713, 1718, 1719, 1720, 1722,
 /*   580 */  1724, 1678, 1682, 1726, 1619, 1732, 1730, 1780, 1781, 1785,
 /*   590 */  1691, 1692, 1693, 1696, 1697, 1634, 1699, 1787, 1754, 1635,
 /*   600 */  1701, 1702, 1552, 1751, 1757, 1593, 1575, 1607, 1801, 1784,
 /*   610 */  1598, 1714, 1712, 1716, 1717, 1721, 1723, 1765, 1727, 1729,
 /*   620 */  1767, 1731, 1796, 1645, 1741, 1733, 1742, 1788, 1791, 1747,
 /*   630 */  1748, 1802, 1752, 1750, 1808, 1761, 1762, 1822, 1764, 1766,
 /*   640 */  1825, 1768, 1745, 1746, 1749, 1753, 1844, 1760, 1778, 1830,
 /*   650 */  1782, 1840, 1786, 1830, 1830, 1854, 1814, 1817, 1847, 1848,
 /*   660 */  1850, 1852, 1853, 1855, 1856, 1857, 1858, 1860, 1819, 1804,
 /*   670 */  1859, 1862, 1863, 1864, 1880, 1869, 1871, 1872, 1835, 1596,
 /*   680 */  1873, 1599, 1874, 1877, 1878, 1881, 1893, 1888, 1926, 1892,
 /*   690 */  1882, 1889, 1929, 1897, 1886, 1896, 1937, 1904, 1898, 1902,
 /*   700 */  1943, 1909, 1899, 1906, 1948, 1914, 1916, 1952, 1931, 1933,
 /*   710 */  1934, 1936, 1938, 1940,
};
#define YY_REDUCE_COUNT (292)
#define YY_REDUCE_MIN   (-390)
#define YY_REDUCE_MAX   (2655)
static const short yy_reduce_ofst[] = {
 /*     0 */  -193, -258,  679,  741,  795,  854,  920,  940, 1037, 1096,
 /*    10 */  1186, 1248, 1271, 1338, 1361,  289, 1424, 1444, 1513, 1567,
 /*    20 */  1584, 1638, 1656, 1710, 1728, 1783, 1803, 1870, 1895, 1922,
 /*    30 */  1982, 2005, 2065, 2092, 2117, 2175, 2192, 2244, 2267, 2296,
 /*    40 */  2354, 2372, 2437, 2459, 2520, 2542, 2603, 2655, -257,   95,
 /*    50 */   223,  -39,  171,  234,  392,  624,  293,  342, -345,  -15,
 /*    60 */  -390,  -12,  270, -275, -249,  227, -221,  326, -370, -329,
 /*    70 */  -325, -326, -362, -298, -256, -239,  253,  280,  408,  470,
 /*    80 */   551,  655,  656,  658,  660, -201,  676,  678,   24,  732,
 /*    90 */   742,  768, -260,  770,  771, -313,  774,   10,   -4,  101,
 /*   100 */   775,  207, -334, -283, -283,  -19, -151, -309,  167,  221,
 /*   110 */   237,  345,  378,  395,  412,  433,  518,  545,  547,  553,
 /*   120 */   575,  659,  661,  662,  670,  711, -265,   64,  -60, -216,
 /*   130 */  -165,   53,   64,  128,  133,  313,  336,  346,   98,  265,
 /*   140 */   279,  462, -315,  311,  451,  480,  463,  505,  511,  571,
 /*   150 */   529, -359, -338,  370,  651,  672,  681,  688,  535,  816,
 /*   160 */   723,  777,  702,  727,  828,  735,  826,  826,  852,  812,
 /*   170 */   861,  835,  813,  766,  766,  756,  766,  785,  780,  826,
 /*   180 */   817,  831,  840,  855,  856,  863,  867,  909,  910,  868,
 /*   190 */   872,  873,  911,  917,  918,  921,  935,  937,  874,  930,
 /*   200 */   901,  934,  944,  894,  941,  948,  949,  951,  953,  950,
 /*   210 */   954,  958,  961,  960,  939,  942,  945,  946,  952,  956,
 /*   220 */   962,  964,  965,  972,  974,  966,  973,  936,  963,  912,
 /*   230 */   915,  977,  922,  979,  980,  983,  969,  984,  968,  895,
 /*   240 */   971,  986,  914,  982,  990,  996,  826,  927,  932,  975,
 /*   250 */   985,  978,  988,  987,  919,  928,  933,  766, 1021,  989,
 /*   260 */  1054, 1055, 1057, 1006, 1022, 1023, 1026, 1027, 1028, 1017,
 /*   270 */  1029, 1020, 1067, 1053, 1070, 1045,  992, 1056, 1048, 1072,
 /*   280 */  1092, 1083, 1098, 1097, 1038, 1035, 1047, 1050, 1085, 1088,
 /*   290 */  1095, 1093, 1106,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    10 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    20 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    30 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    40 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    50 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    60 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    70 */  1604, 1859, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*    80 */  1604, 1604, 1604, 1604, 1604, 1682, 1604, 1604, 1604, 1604,
 /*    90 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   100 */  1604, 1680, 1852, 2054, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   110 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   120 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 2066, 1604, 1604,
 /*   130 */  1682, 1604, 2066, 2066, 2066, 1680, 2026, 2026, 1604, 1604,
 /*   140 */  1604, 1604, 1789, 1604, 1604, 1604, 1604, 1604, 1604, 1789,
 /*   150 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1901, 1604,
 /*   160 */  1604, 2091, 2145, 1604, 1604, 2094, 1604, 1604, 1604, 1864,
 /*   170 */  1604, 1742, 2081, 2058, 2072, 2129, 2059, 2056, 2075, 1604,
 /*   180 */  2085, 1604, 1894, 1857, 1604, 1857, 1854, 1604, 1604, 1857,
 /*   190 */  1854, 1854, 1733, 1604, 1604, 1604, 1604, 1604, 1604, 1682,
 /*   200 */  1604, 1682, 1604, 1604, 1682, 1604, 1682, 1682, 1682, 1604,
 /*   210 */  1682, 1661, 1661, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   220 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1914,
 /*   230 */  1604, 1680, 1903, 1604, 1680, 1604, 1604, 1604, 1604, 2102,
 /*   240 */  2100, 1604, 2102, 2100, 1604, 1604, 1604, 2114, 2110, 2102,
 /*   250 */  2118, 2116, 2087, 2085, 2148, 2135, 2131, 2072, 1604, 1604,
 /*   260 */  1604, 1604, 1680, 2100, 1604, 1604, 1604, 1604, 1604, 2100,
 /*   270 */  1604, 1604, 1680, 1604, 1680, 1604, 1604, 1758, 1604, 1604,
 /*   280 */  1604, 1680, 1636, 1604, 1896, 1907, 1879, 1879, 1792, 1792,
 /*   290 */  1792, 1683, 1609, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   300 */  1604, 1604, 1604, 1604, 1604, 2113, 2112, 1982, 1604, 2030,
 /*   310 */  2029, 2028, 2019, 1981, 1754, 1604, 1980, 1979, 1604, 1604,
 /*   320 */  1604, 1604, 1604, 1870, 1869, 1973, 1604, 1604, 1974, 1972,
 /*   330 */  1971, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   340 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 2132, 2136,
 /*   350 */  1604, 1604, 1604, 1604, 1604, 1604, 2055, 1604, 1604, 1604,
 /*   360 */  1604, 1604, 1956, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   370 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   380 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   390 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   400 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   410 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   420 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   430 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   440 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   450 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   460 */  1604, 1641, 1961, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   470 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   480 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   490 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   500 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1721,
 /*   510 */  1720, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   520 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   530 */  1604, 1604, 1604, 1964, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   540 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 2128, 2088, 1604,
 /*   550 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   560 */  1604, 1604, 1604, 1604, 1604, 1604, 1956, 1604, 2111, 1604,
 /*   570 */  1604, 2126, 1604, 2130, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   580 */  1604, 2065, 2061, 1604, 1604, 2057, 1604, 1604, 1604, 1604,
 /*   590 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   600 */  1604, 1604, 1955, 1604, 2016, 1604, 1604, 1604, 2050, 1604,
 /*   610 */  1604, 2001, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   620 */  1604, 1964, 1604, 1967, 1604, 1604, 1604, 1604, 1604, 1786,
 /*   630 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   640 */  1604, 1604, 1771, 1769, 1768, 1767, 1604, 1764, 1604, 1799,
 /*   650 */  1604, 1604, 1604, 1795, 1794, 1604, 1604, 1604, 1604, 1604,
 /*   660 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   670 */  1701, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1693,
 /*   680 */  1604, 1692, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   690 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   700 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*   710 */  1604, 1604, 1604, 1604,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  270,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  270,  /*      AFTER => ABORT */
  270,  /*     ATTACH => ABORT */
  270,  /*     BEFORE => ABORT */
  270,  /*      BEGIN => ABORT */
  270,  /*     BITAND => ABORT */
  270,  /*     BITNOT => ABORT */
  270,  /*      BITOR => ABORT */
  270,  /*     BLOCKS => ABORT */
  270,  /*     CHANGE => ABORT */
  270,  /*      COMMA => ABORT */
  270,  /*    COMPACT => ABORT */
  270,  /*     CONCAT => ABORT */
  270,  /*   CONFLICT => ABORT */
  270,  /*       COPY => ABORT */
  270,  /*   DEFERRED => ABORT */
  270,  /* DELIMITERS => ABORT */
  270,  /*     DETACH => ABORT */
  270,  /*     DIVIDE => ABORT */
  270,  /*        DOT => ABORT */
  270,  /*       EACH => ABORT */
  270,  /*       FAIL => ABORT */
  270,  /*       FILE => ABORT */
  270,  /*        FOR => ABORT */
  270,  /*       GLOB => ABORT */
  270,  /*         ID => ABORT */
  270,  /*  IMMEDIATE => ABORT */
  270,  /*     IMPORT => ABORT */
  270,  /*  INITIALLY => ABORT */
  270,  /*    INSTEAD => ABORT */
  270,  /*     ISNULL => ABORT */
  270,  /*        KEY => ABORT */
  270,  /*    MODULES => ABORT */
  270,  /*  NK_BITNOT => ABORT */
  270,  /*    NK_SEMI => ABORT */
  270,  /*    NOTNULL => ABORT */
  270,  /*         OF => ABORT */
  270,  /*       PLUS => ABORT */
  270,  /*  PRIVILEGE => ABORT */
  270,  /*      RAISE => ABORT */
  270,  /*    REPLACE => ABORT */
  270,  /*   RESTRICT => ABORT */
  270,  /*        ROW => ABORT */
  270,  /*       SEMI => ABORT */
  270,  /*       STAR => ABORT */
  270,  /*  STATEMENT => ABORT */
  270,  /*     STRICT => ABORT */
  270,  /*     STRING => ABORT */
  270,  /*      TIMES => ABORT */
  270,  /*     UPDATE => ABORT */
  270,  /*     VALUES => ABORT */
  270,  /*   VARIABLE => ABORT */
  270,  /*       VIEW => ABORT */
  270,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "COUNT",
  /*  168 */ "LAST_ROW",
  /*  169 */ "TOPIC",
  /*  170 */ "WITH",
  /*  171 */ "META",
  /*  172 */ "CONSUMER",
  /*  173 */ "GROUP",
  /*  174 */ "DESC",
  /*  175 */ "DESCRIBE",
  /*  176 */ "RESET",
  /*  177 */ "QUERY",
  /*  178 */ "CACHE",
  /*  179 */ "EXPLAIN",
  /*  180 */ "ANALYZE",
  /*  181 */ "VERBOSE",
  /*  182 */ "NK_BOOL",
  /*  183 */ "RATIO",
  /*  184 */ "NK_FLOAT",
  /*  185 */ "OUTPUTTYPE",
  /*  186 */ "AGGREGATE",
  /*  187 */ "BUFSIZE",
  /*  188 */ "STREAM",
  /*  189 */ "INTO",
  /*  190 */ "TRIGGER",
  /*  191 */ "AT_ONCE",
  /*  192 */ "WINDOW_CLOSE",
  /*  193 */ "IGNORE",
  /*  194 */ "EXPIRED",
  /*  195 */ "FILL_HISTORY",
  /*  196 */ "SUBTABLE",
  /*  197 */ "KILL",
  /*  198 */ "CONNECTION",
  /*  199 */ "TRANSACTION",
  /*  200 */ "BALANCE",
  /*  201 */ "VGROUP",
  /*  202 */ "MERGE",
  /*  203 */ "REDISTRIBUTE",
  /*  204 */ "SPLIT",
  /*  205 */ "DELETE",
  /*  206 */ "INSERT",
  /*  207 */ "NULL",
  /*  208 */ "NK_QUESTION",
  /*  209 */ "NK_ARROW",
  /*  210 */ "ROWTS",
  /*  211 */ "QSTART",
  /*  212 */ "QEND",
  /*  213 */ "QDURATION",
  /*  214 */ "WSTART",
  /*  215 */ "WEND",
  /*  216 */ "WDURATION",
  /*  217 */ "IROWTS",
  /*  218 */ "CAST",
  /*  219 */ "NOW",
  /*  220 */ "TODAY",
  /*  221 */ "TIMEZONE",
  /*  222 */ "CLIENT_VERSION",
  /*  223 */ "SERVER_VERSION",
  /*  224 */ "SERVER_STATUS",
  /*  225 */ "CURRENT_USER",
  /*  226 */ "CASE",
  /*  227 */ "END",
  /*  228 */ "WHEN",
  /*  229 */ "THEN",
  /*  230 */ "ELSE",
  /*  231 */ "BETWEEN",
  /*  232 */ "IS",
  /*  233 */ "NK_LT",
  /*  234 */ "NK_GT",
  /*  235 */ "NK_LE",
  /*  236 */ "NK_GE",
  /*  237 */ "NK_NE",
  /*  238 */ "MATCH",
  /*  239 */ "NMATCH",
  /*  240 */ "CONTAINS",
  /*  241 */ "IN",
  /*  242 */ "JOIN",
  /*  243 */ "INNER",
  /*  244 */ "SELECT",
  /*  245 */ "DISTINCT",
  /*  246 */ "WHERE",
  /*  247 */ "PARTITION",
  /*  248 */ "BY",
  /*  249 */ "SESSION",
  /*  250 */ "STATE_WINDOW",
  /*  251 */ "EVENT_WINDOW",
  /*  252 */ "START",
  /*  253 */ "SLIDING",
  /*  254 */ "FILL",
  /*  255 */ "VALUE",
  /*  256 */ "NONE",
  /*  257 */ "PREV",
  /*  258 */ "LINEAR",
  /*  259 */ "NEXT",
  /*  260 */ "HAVING",
  /*  261 */ "RANGE",
  /*  262 */ "EVERY",
  /*  263 */ "ORDER",
  /*  264 */ "SLIMIT",
  /*  265 */ "SOFFSET",
  /*  266 */ "LIMIT",
  /*  267 */ "OFFSET",
  /*  268 */ "ASC",
  /*  269 */ "NULLS",
  /*  270 */ "ABORT",
  /*  271 */ "AFTER",
  /*  272 */ "ATTACH",
  /*  273 */ "BEFORE",
  /*  274 */ "BEGIN",
  /*  275 */ "BITAND",
  /*  276 */ "BITNOT",
  /*  277 */ "BITOR",
  /*  278 */ "BLOCKS",
  /*  279 */ "CHANGE",
  /*  280 */ "COMMA",
  /*  281 */ "COMPACT",
  /*  282 */ "CONCAT",
  /*  283 */ "CONFLICT",
  /*  284 */ "COPY",
  /*  285 */ "DEFERRED",
  /*  286 */ "DELIMITERS",
  /*  287 */ "DETACH",
  /*  288 */ "DIVIDE",
  /*  289 */ "DOT",
  /*  290 */ "EACH",
  /*  291 */ "FAIL",
  /*  292 */ "FILE",
  /*  293 */ "FOR",
  /*  294 */ "GLOB",
  /*  295 */ "ID",
  /*  296 */ "IMMEDIATE",
  /*  297 */ "IMPORT",
  /*  298 */ "INITIALLY",
  /*  299 */ "INSTEAD",
  /*  300 */ "ISNULL",
  /*  301 */ "KEY",
  /*  302 */ "MODULES",
  /*  303 */ "NK_BITNOT",
  /*  304 */ "NK_SEMI",
  /*  305 */ "NOTNULL",
  /*  306 */ "OF",
  /*  307 */ "PLUS",
  /*  308 */ "PRIVILEGE",
  /*  309 */ "RAISE",
  /*  310 */ "REPLACE",
  /*  311 */ "RESTRICT",
  /*  312 */ "ROW",
  /*  313 */ "SEMI",
  /*  314 */ "STAR",
  /*  315 */ "STATEMENT",
  /*  316 */ "STRICT",
  /*  317 */ "STRING",
  /*  318 */ "TIMES",
  /*  319 */ "UPDATE",
  /*  320 */ "VALUES",
  /*  321 */ "VARIABLE",
  /*  322 */ "VIEW",
  /*  323 */ "WAL",
  /*  324 */ "cmd",
  /*  325 */ "account_options",
  /*  326 */ "alter_account_options",
  /*  327 */ "literal",
  /*  328 */ "alter_account_option",
  /*  329 */ "user_name",
  /*  330 */ "sysinfo_opt",
  /*  331 */ "privileges",
  /*  332 */ "priv_level",
  /*  333 */ "priv_type_list",
  /*  334 */ "priv_type",
  /*  335 */ "db_name",
  /*  336 */ "topic_name",
  /*  337 */ "dnode_endpoint",
  /*  338 */ "force_opt",
  /*  339 */ "not_exists_opt",
  /*  340 */ "db_options",
  /*  341 */ "exists_opt",
  /*  342 */ "alter_db_options",
  /*  343 */ "speed_opt",
  /*  344 */ "integer_list",
  /*  345 */ "variable_list",
  /*  346 */ "retention_list",
  /*  347 */ "alter_db_option",
  /*  348 */ "retention",
  /*  349 */ "full_table_name",
  /*  350 */ "column_def_list",
  /*  351 */ "tags_def_opt",
  /*  352 */ "table_options",
  /*  353 */ "multi_create_clause",
  /*  354 */ "tags_def",
  /*  355 */ "multi_drop_clause",
  /*  356 */ "alter_table_clause",
  /*  357 */ "alter_table_options",
  /*  358 */ "column_name",
  /*  359 */ "type_name",
  /*  360 */ "signed_literal",
  /*  361 */ "create_subtable_clause",
  /*  362 */ "specific_cols_opt",
  /*  363 */ "expression_list",
  /*  364 */ "drop_table_clause",
  /*  365 */ "col_name_list",
  /*  366 */ "table_name",
  /*  367 */ "column_def",
  /*  368 */ "duration_list",
  /*  369 */ "rollup_func_list",
  /*  370 */ "alter_table_option",
  /*  371 */ "duration_literal",
  /*  372 */ "rollup_func_name",
  /*  373 */ "function_name",
  /*  374 */ "col_name",
  /*  375 */ "db_name_cond_opt",
  /*  376 */ "like_pattern_opt",
  /*  377 */ "table_name_cond",
  /*  378 */ "from_db_opt",
  /*  379 */ "tag_list_opt",
  /*  380 */ "tag_item",
  /*  381 */ "column_alias",
  /*  382 */ "index_options",
  /*  383 */ "func_list",
  /*  384 */ "sliding_opt",
  /*  385 */ "sma_stream_opt",
  /*  386 */ "func",
  /*  387 */ "sma_func_name",
  /*  388 */ "query_or_subquery",
  /*  389 */ "cgroup_name",
  /*  390 */ "analyze_opt",
  /*  391 */ "explain_options",
  /*  392 */ "agg_func_opt",
  /*  393 */ "bufsize_opt",
  /*  394 */ "stream_name",
  /*  395 */ "stream_options",
  /*  396 */ "subtable_opt",
  /*  397 */ "expression",
  /*  398 */ "dnode_list",
  /*  399 */ "where_clause_opt",
  /*  400 */ "signed",
  /*  401 */ "literal_func",
  /*  402 */ "literal_list",
  /*  403 */ "table_alias",
  /*  404 */ "expr_or_subquery",
  /*  405 */ "pseudo_column",
  /*  406 */ "column_reference",
  /*  407 */ "function_expression",
  /*  408 */ "case_when_expression",
  /*  409 */ "star_func",
  /*  410 */ "star_func_para_list",
  /*  411 */ "noarg_func",
  /*  412 */ "other_para_list",
  /*  413 */ "star_func_para",
  /*  414 */ "when_then_list",
  /*  415 */ "case_when_else_opt",
  /*  416 */ "common_expression",
  /*  417 */ "when_then_expr",
  /*  418 */ "predicate",
  /*  419 */ "compare_op",
  /*  420 */ "in_op",
  /*  421 */ "in_predicate_value",
  /*  422 */ "boolean_value_expression",
  /*  423 */ "boolean_primary",
  /*  424 */ "from_clause_opt",
  /*  425 */ "table_reference_list",
  /*  426 */ "table_reference",
  /*  427 */ "table_primary",
  /*  428 */ "joined_table",
  /*  429 */ "alias_opt",
  /*  430 */ "subquery",
  /*  431 */ "parenthesized_joined_table",
  /*  432 */ "join_type",
  /*  433 */ "search_condition",
  /*  434 */ "query_specification",
  /*  435 */ "set_quantifier_opt",
  /*  436 */ "select_list",
  /*  437 */ "partition_by_clause_opt",
  /*  438 */ "range_opt",
  /*  439 */ "every_opt",
  /*  440 */ "fill_opt",
  /*  441 */ "twindow_clause_opt",
  /*  442 */ "group_by_clause_opt",
  /*  443 */ "having_clause_opt",
  /*  444 */ "select_item",
  /*  445 */ "partition_list",
  /*  446 */ "partition_item",
  /*  447 */ "fill_mode",
  /*  448 */ "group_by_list",
  /*  449 */ "query_expression",
  /*  450 */ "query_simple",
  /*  451 */ "order_by_clause_opt",
  /*  452 */ "slimit_clause_opt",
  /*  453 */ "limit_clause_opt",
  /*  454 */ "union_query_expression",
  /*  455 */ "query_simple_or_subquery",
  /*  456 */ "sort_specification_list",
  /*  457 */ "sort_specification",
  /*  458 */ "ordering_specification_opt",
  /*  459 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 261 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 262 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "func_list ::= func",
 /* 265 */ "func_list ::= func_list NK_COMMA func",
 /* 266 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 267 */ "sma_func_name ::= function_name",
 /* 268 */ "sma_func_name ::= COUNT",
 /* 269 */ "sma_func_name ::= FIRST",
 /* 270 */ "sma_func_name ::= LAST",
 /* 271 */ "sma_func_name ::= LAST_ROW",
 /* 272 */ "sma_stream_opt ::=",
 /* 273 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 274 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 275 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 278 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 279 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 280 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 281 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 282 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 283 */ "cmd ::= DESC full_table_name",
 /* 284 */ "cmd ::= DESCRIBE full_table_name",
 /* 285 */ "cmd ::= RESET QUERY CACHE",
 /* 286 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 287 */ "analyze_opt ::=",
 /* 288 */ "analyze_opt ::= ANALYZE",
 /* 289 */ "explain_options ::=",
 /* 290 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 291 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 292 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 293 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 294 */ "agg_func_opt ::=",
 /* 295 */ "agg_func_opt ::= AGGREGATE",
 /* 296 */ "bufsize_opt ::=",
 /* 297 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 298 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 299 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 300 */ "stream_options ::=",
 /* 301 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 302 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 303 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 304 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 305 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 306 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 307 */ "subtable_opt ::=",
 /* 308 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 309 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 310 */ "cmd ::= KILL QUERY NK_STRING",
 /* 311 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 312 */ "cmd ::= BALANCE VGROUP",
 /* 313 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 314 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 315 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 316 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 317 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 318 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 319 */ "cmd ::= query_or_subquery",
 /* 320 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 321 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 322 */ "literal ::= NK_INTEGER",
 /* 323 */ "literal ::= NK_FLOAT",
 /* 324 */ "literal ::= NK_STRING",
 /* 325 */ "literal ::= NK_BOOL",
 /* 326 */ "literal ::= TIMESTAMP NK_STRING",
 /* 327 */ "literal ::= duration_literal",
 /* 328 */ "literal ::= NULL",
 /* 329 */ "literal ::= NK_QUESTION",
 /* 330 */ "duration_literal ::= NK_VARIABLE",
 /* 331 */ "signed ::= NK_INTEGER",
 /* 332 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 333 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 334 */ "signed ::= NK_FLOAT",
 /* 335 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 336 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 337 */ "signed_literal ::= signed",
 /* 338 */ "signed_literal ::= NK_STRING",
 /* 339 */ "signed_literal ::= NK_BOOL",
 /* 340 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 341 */ "signed_literal ::= duration_literal",
 /* 342 */ "signed_literal ::= NULL",
 /* 343 */ "signed_literal ::= literal_func",
 /* 344 */ "signed_literal ::= NK_QUESTION",
 /* 345 */ "literal_list ::= signed_literal",
 /* 346 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 347 */ "db_name ::= NK_ID",
 /* 348 */ "table_name ::= NK_ID",
 /* 349 */ "column_name ::= NK_ID",
 /* 350 */ "function_name ::= NK_ID",
 /* 351 */ "table_alias ::= NK_ID",
 /* 352 */ "column_alias ::= NK_ID",
 /* 353 */ "user_name ::= NK_ID",
 /* 354 */ "topic_name ::= NK_ID",
 /* 355 */ "stream_name ::= NK_ID",
 /* 356 */ "cgroup_name ::= NK_ID",
 /* 357 */ "expr_or_subquery ::= expression",
 /* 358 */ "expression ::= literal",
 /* 359 */ "expression ::= pseudo_column",
 /* 360 */ "expression ::= column_reference",
 /* 361 */ "expression ::= function_expression",
 /* 362 */ "expression ::= case_when_expression",
 /* 363 */ "expression ::= NK_LP expression NK_RP",
 /* 364 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 365 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 371 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 372 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 373 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 374 */ "expression_list ::= expr_or_subquery",
 /* 375 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 376 */ "column_reference ::= column_name",
 /* 377 */ "column_reference ::= table_name NK_DOT column_name",
 /* 378 */ "pseudo_column ::= ROWTS",
 /* 379 */ "pseudo_column ::= TBNAME",
 /* 380 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 381 */ "pseudo_column ::= QSTART",
 /* 382 */ "pseudo_column ::= QEND",
 /* 383 */ "pseudo_column ::= QDURATION",
 /* 384 */ "pseudo_column ::= WSTART",
 /* 385 */ "pseudo_column ::= WEND",
 /* 386 */ "pseudo_column ::= WDURATION",
 /* 387 */ "pseudo_column ::= IROWTS",
 /* 388 */ "pseudo_column ::= QTAGS",
 /* 389 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 390 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 391 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 392 */ "function_expression ::= literal_func",
 /* 393 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 394 */ "literal_func ::= NOW",
 /* 395 */ "noarg_func ::= NOW",
 /* 396 */ "noarg_func ::= TODAY",
 /* 397 */ "noarg_func ::= TIMEZONE",
 /* 398 */ "noarg_func ::= DATABASE",
 /* 399 */ "noarg_func ::= CLIENT_VERSION",
 /* 400 */ "noarg_func ::= SERVER_VERSION",
 /* 401 */ "noarg_func ::= SERVER_STATUS",
 /* 402 */ "noarg_func ::= CURRENT_USER",
 /* 403 */ "noarg_func ::= USER",
 /* 404 */ "star_func ::= COUNT",
 /* 405 */ "star_func ::= FIRST",
 /* 406 */ "star_func ::= LAST",
 /* 407 */ "star_func ::= LAST_ROW",
 /* 408 */ "star_func_para_list ::= NK_STAR",
 /* 409 */ "star_func_para_list ::= other_para_list",
 /* 410 */ "other_para_list ::= star_func_para",
 /* 411 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 412 */ "star_func_para ::= expr_or_subquery",
 /* 413 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 414 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 415 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 416 */ "when_then_list ::= when_then_expr",
 /* 417 */ "when_then_list ::= when_then_list when_then_expr",
 /* 418 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 419 */ "case_when_else_opt ::=",
 /* 420 */ "case_when_else_opt ::= ELSE common_expression",
 /* 421 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 422 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 423 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 424 */ "predicate ::= expr_or_subquery IS NULL",
 /* 425 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 426 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 427 */ "compare_op ::= NK_LT",
 /* 428 */ "compare_op ::= NK_GT",
 /* 429 */ "compare_op ::= NK_LE",
 /* 430 */ "compare_op ::= NK_GE",
 /* 431 */ "compare_op ::= NK_NE",
 /* 432 */ "compare_op ::= NK_EQ",
 /* 433 */ "compare_op ::= LIKE",
 /* 434 */ "compare_op ::= NOT LIKE",
 /* 435 */ "compare_op ::= MATCH",
 /* 436 */ "compare_op ::= NMATCH",
 /* 437 */ "compare_op ::= CONTAINS",
 /* 438 */ "in_op ::= IN",
 /* 439 */ "in_op ::= NOT IN",
 /* 440 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 441 */ "boolean_value_expression ::= boolean_primary",
 /* 442 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 443 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 444 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 445 */ "boolean_primary ::= predicate",
 /* 446 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 447 */ "common_expression ::= expr_or_subquery",
 /* 448 */ "common_expression ::= boolean_value_expression",
 /* 449 */ "from_clause_opt ::=",
 /* 450 */ "from_clause_opt ::= FROM table_reference_list",
 /* 451 */ "table_reference_list ::= table_reference",
 /* 452 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 453 */ "table_reference ::= table_primary",
 /* 454 */ "table_reference ::= joined_table",
 /* 455 */ "table_primary ::= table_name alias_opt",
 /* 456 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 457 */ "table_primary ::= subquery alias_opt",
 /* 458 */ "table_primary ::= parenthesized_joined_table",
 /* 459 */ "alias_opt ::=",
 /* 460 */ "alias_opt ::= table_alias",
 /* 461 */ "alias_opt ::= AS table_alias",
 /* 462 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 463 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 464 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 465 */ "join_type ::=",
 /* 466 */ "join_type ::= INNER",
 /* 467 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 468 */ "set_quantifier_opt ::=",
 /* 469 */ "set_quantifier_opt ::= DISTINCT",
 /* 470 */ "set_quantifier_opt ::= ALL",
 /* 471 */ "select_list ::= select_item",
 /* 472 */ "select_list ::= select_list NK_COMMA select_item",
 /* 473 */ "select_item ::= NK_STAR",
 /* 474 */ "select_item ::= common_expression",
 /* 475 */ "select_item ::= common_expression column_alias",
 /* 476 */ "select_item ::= common_expression AS column_alias",
 /* 477 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 478 */ "where_clause_opt ::=",
 /* 479 */ "where_clause_opt ::= WHERE search_condition",
 /* 480 */ "partition_by_clause_opt ::=",
 /* 481 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 482 */ "partition_list ::= partition_item",
 /* 483 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 484 */ "partition_item ::= expr_or_subquery",
 /* 485 */ "partition_item ::= expr_or_subquery column_alias",
 /* 486 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 487 */ "twindow_clause_opt ::=",
 /* 488 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 489 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 490 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 491 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 492 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 493 */ "sliding_opt ::=",
 /* 494 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 495 */ "fill_opt ::=",
 /* 496 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 497 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 498 */ "fill_mode ::= NONE",
 /* 499 */ "fill_mode ::= PREV",
 /* 500 */ "fill_mode ::= NULL",
 /* 501 */ "fill_mode ::= LINEAR",
 /* 502 */ "fill_mode ::= NEXT",
 /* 503 */ "group_by_clause_opt ::=",
 /* 504 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 505 */ "group_by_list ::= expr_or_subquery",
 /* 506 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 507 */ "having_clause_opt ::=",
 /* 508 */ "having_clause_opt ::= HAVING search_condition",
 /* 509 */ "range_opt ::=",
 /* 510 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 511 */ "every_opt ::=",
 /* 512 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 513 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 514 */ "query_simple ::= query_specification",
 /* 515 */ "query_simple ::= union_query_expression",
 /* 516 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 517 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 518 */ "query_simple_or_subquery ::= query_simple",
 /* 519 */ "query_simple_or_subquery ::= subquery",
 /* 520 */ "query_or_subquery ::= query_expression",
 /* 521 */ "query_or_subquery ::= subquery",
 /* 522 */ "order_by_clause_opt ::=",
 /* 523 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 524 */ "slimit_clause_opt ::=",
 /* 525 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 526 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 527 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 528 */ "limit_clause_opt ::=",
 /* 529 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 530 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 531 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 532 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 533 */ "subquery ::= NK_LP subquery NK_RP",
 /* 534 */ "search_condition ::= common_expression",
 /* 535 */ "sort_specification_list ::= sort_specification",
 /* 536 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 537 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 538 */ "ordering_specification_opt ::=",
 /* 539 */ "ordering_specification_opt ::= ASC",
 /* 540 */ "ordering_specification_opt ::= DESC",
 /* 541 */ "null_ordering_opt ::=",
 /* 542 */ "null_ordering_opt ::= NULLS FIRST",
 /* 543 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 324: /* cmd */
    case 327: /* literal */
    case 340: /* db_options */
    case 342: /* alter_db_options */
    case 348: /* retention */
    case 349: /* full_table_name */
    case 352: /* table_options */
    case 356: /* alter_table_clause */
    case 357: /* alter_table_options */
    case 360: /* signed_literal */
    case 361: /* create_subtable_clause */
    case 364: /* drop_table_clause */
    case 367: /* column_def */
    case 371: /* duration_literal */
    case 372: /* rollup_func_name */
    case 374: /* col_name */
    case 375: /* db_name_cond_opt */
    case 376: /* like_pattern_opt */
    case 377: /* table_name_cond */
    case 378: /* from_db_opt */
    case 380: /* tag_item */
    case 382: /* index_options */
    case 384: /* sliding_opt */
    case 385: /* sma_stream_opt */
    case 386: /* func */
    case 388: /* query_or_subquery */
    case 391: /* explain_options */
    case 395: /* stream_options */
    case 396: /* subtable_opt */
    case 397: /* expression */
    case 399: /* where_clause_opt */
    case 400: /* signed */
    case 401: /* literal_func */
    case 404: /* expr_or_subquery */
    case 405: /* pseudo_column */
    case 406: /* column_reference */
    case 407: /* function_expression */
    case 408: /* case_when_expression */
    case 413: /* star_func_para */
    case 415: /* case_when_else_opt */
    case 416: /* common_expression */
    case 417: /* when_then_expr */
    case 418: /* predicate */
    case 421: /* in_predicate_value */
    case 422: /* boolean_value_expression */
    case 423: /* boolean_primary */
    case 424: /* from_clause_opt */
    case 425: /* table_reference_list */
    case 426: /* table_reference */
    case 427: /* table_primary */
    case 428: /* joined_table */
    case 430: /* subquery */
    case 431: /* parenthesized_joined_table */
    case 433: /* search_condition */
    case 434: /* query_specification */
    case 438: /* range_opt */
    case 439: /* every_opt */
    case 440: /* fill_opt */
    case 441: /* twindow_clause_opt */
    case 443: /* having_clause_opt */
    case 444: /* select_item */
    case 446: /* partition_item */
    case 449: /* query_expression */
    case 450: /* query_simple */
    case 452: /* slimit_clause_opt */
    case 453: /* limit_clause_opt */
    case 454: /* union_query_expression */
    case 455: /* query_simple_or_subquery */
    case 457: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy752)); 
}
      break;
    case 325: /* account_options */
    case 326: /* alter_account_options */
    case 328: /* alter_account_option */
    case 343: /* speed_opt */
    case 393: /* bufsize_opt */
{
 
}
      break;
    case 329: /* user_name */
    case 332: /* priv_level */
    case 335: /* db_name */
    case 336: /* topic_name */
    case 337: /* dnode_endpoint */
    case 358: /* column_name */
    case 366: /* table_name */
    case 373: /* function_name */
    case 381: /* column_alias */
    case 387: /* sma_func_name */
    case 389: /* cgroup_name */
    case 394: /* stream_name */
    case 403: /* table_alias */
    case 409: /* star_func */
    case 411: /* noarg_func */
    case 429: /* alias_opt */
{
 
}
      break;
    case 330: /* sysinfo_opt */
{
 
}
      break;
    case 331: /* privileges */
    case 333: /* priv_type_list */
    case 334: /* priv_type */
{
 
}
      break;
    case 338: /* force_opt */
    case 339: /* not_exists_opt */
    case 341: /* exists_opt */
    case 390: /* analyze_opt */
    case 392: /* agg_func_opt */
    case 435: /* set_quantifier_opt */
{
 
}
      break;
    case 344: /* integer_list */
    case 345: /* variable_list */
    case 346: /* retention_list */
    case 350: /* column_def_list */
    case 351: /* tags_def_opt */
    case 353: /* multi_create_clause */
    case 354: /* tags_def */
    case 355: /* multi_drop_clause */
    case 362: /* specific_cols_opt */
    case 363: /* expression_list */
    case 365: /* col_name_list */
    case 368: /* duration_list */
    case 369: /* rollup_func_list */
    case 379: /* tag_list_opt */
    case 383: /* func_list */
    case 398: /* dnode_list */
    case 402: /* literal_list */
    case 410: /* star_func_para_list */
    case 412: /* other_para_list */
    case 414: /* when_then_list */
    case 436: /* select_list */
    case 437: /* partition_by_clause_opt */
    case 442: /* group_by_clause_opt */
    case 445: /* partition_list */
    case 448: /* group_by_list */
    case 451: /* order_by_clause_opt */
    case 456: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy424)); 
}
      break;
    case 347: /* alter_db_option */
    case 370: /* alter_table_option */
{
 
}
      break;
    case 359: /* type_name */
{
 
}
      break;
    case 419: /* compare_op */
    case 420: /* in_op */
{
 
}
      break;
    case 432: /* join_type */
{
 
}
      break;
    case 447: /* fill_mode */
{
 
}
      break;
    case 458: /* ordering_specification_opt */
{
 
}
      break;
    case 459: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  324,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  324,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  325,    0 }, /* (2) account_options ::= */
  {  325,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  325,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  325,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  325,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  325,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  325,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  325,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  325,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  325,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  326,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  326,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  328,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  328,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  328,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  328,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  328,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  328,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  328,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  328,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  328,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  328,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  324,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  324,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  324,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  324,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  324,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  330,    0 }, /* (29) sysinfo_opt ::= */
  {  330,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  324,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  324,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  331,   -1 }, /* (33) privileges ::= ALL */
  {  331,   -1 }, /* (34) privileges ::= priv_type_list */
  {  331,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  333,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  333,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  334,   -1 }, /* (38) priv_type ::= READ */
  {  334,   -1 }, /* (39) priv_type ::= WRITE */
  {  332,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  332,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  332,   -1 }, /* (42) priv_level ::= topic_name */
  {  324,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  324,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  324,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  324,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  324,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  324,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  324,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  324,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  337,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  337,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  337,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  338,    0 }, /* (54) force_opt ::= */
  {  338,   -1 }, /* (55) force_opt ::= FORCE */
  {  324,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  324,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  324,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  324,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  324,   -2 }, /* (68) cmd ::= USE db_name */
  {  324,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  324,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  324,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  339,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  339,    0 }, /* (73) not_exists_opt ::= */
  {  341,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  341,    0 }, /* (75) exists_opt ::= */
  {  340,    0 }, /* (76) db_options ::= */
  {  340,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  340,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  340,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  340,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  340,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  340,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  340,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  340,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  340,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  340,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  340,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  340,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  340,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  340,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  340,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  340,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  340,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  340,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  340,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  340,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  340,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  340,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  340,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  340,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  342,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  342,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  347,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  347,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  347,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  347,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  347,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  347,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  347,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  347,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  347,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  347,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  344,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  344,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  345,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  345,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  346,   -1 }, /* (123) retention_list ::= retention */
  {  346,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  348,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  343,    0 }, /* (126) speed_opt ::= */
  {  343,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  324,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  324,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  324,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  324,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  324,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  324,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  324,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  356,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  356,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  356,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  356,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  356,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  356,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  356,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  356,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  356,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  356,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  353,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  353,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  361,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  355,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  355,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  364,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  362,    0 }, /* (151) specific_cols_opt ::= */
  {  362,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  349,   -1 }, /* (153) full_table_name ::= table_name */
  {  349,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  350,   -1 }, /* (155) column_def_list ::= column_def */
  {  350,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  367,   -2 }, /* (157) column_def ::= column_name type_name */
  {  367,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  359,   -1 }, /* (159) type_name ::= BOOL */
  {  359,   -1 }, /* (160) type_name ::= TINYINT */
  {  359,   -1 }, /* (161) type_name ::= SMALLINT */
  {  359,   -1 }, /* (162) type_name ::= INT */
  {  359,   -1 }, /* (163) type_name ::= INTEGER */
  {  359,   -1 }, /* (164) type_name ::= BIGINT */
  {  359,   -1 }, /* (165) type_name ::= FLOAT */
  {  359,   -1 }, /* (166) type_name ::= DOUBLE */
  {  359,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  359,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  359,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  359,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  359,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  359,   -1 }, /* (174) type_name ::= JSON */
  {  359,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  359,   -1 }, /* (177) type_name ::= BLOB */
  {  359,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (179) type_name ::= DECIMAL */
  {  359,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  359,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  351,    0 }, /* (182) tags_def_opt ::= */
  {  351,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  354,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  352,    0 }, /* (185) table_options ::= */
  {  352,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  352,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  352,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  352,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  352,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  352,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  352,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  357,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  357,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  370,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  370,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  368,   -1 }, /* (197) duration_list ::= duration_literal */
  {  368,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  369,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  369,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  372,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  372,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  372,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  365,   -1 }, /* (204) col_name_list ::= col_name */
  {  365,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  374,   -1 }, /* (206) col_name ::= column_name */
  {  324,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  324,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  324,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  324,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  324,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  324,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  324,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  324,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  324,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  324,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  324,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  324,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  324,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  324,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  324,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  324,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  324,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  324,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  324,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  324,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  324,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  324,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  324,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  324,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  324,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  324,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  324,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  324,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  324,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  324,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  324,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  324,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  324,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  324,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  324,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  324,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  324,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  324,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  375,    0 }, /* (245) db_name_cond_opt ::= */
  {  375,   -2 }, /* (246) db_name_cond_opt ::= db_name NK_DOT */
  {  376,    0 }, /* (247) like_pattern_opt ::= */
  {  376,   -2 }, /* (248) like_pattern_opt ::= LIKE NK_STRING */
  {  377,   -1 }, /* (249) table_name_cond ::= table_name */
  {  378,    0 }, /* (250) from_db_opt ::= */
  {  378,   -2 }, /* (251) from_db_opt ::= FROM db_name */
  {  379,    0 }, /* (252) tag_list_opt ::= */
  {  379,   -1 }, /* (253) tag_list_opt ::= tag_item */
  {  379,   -3 }, /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  380,   -1 }, /* (255) tag_item ::= TBNAME */
  {  380,   -1 }, /* (256) tag_item ::= QTAGS */
  {  380,   -1 }, /* (257) tag_item ::= column_name */
  {  380,   -2 }, /* (258) tag_item ::= column_name column_alias */
  {  380,   -3 }, /* (259) tag_item ::= column_name AS column_alias */
  {  324,   -8 }, /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  324,   -4 }, /* (261) cmd ::= DROP INDEX exists_opt full_table_name */
  {  382,  -10 }, /* (262) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  382,  -12 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,   -1 }, /* (264) func_list ::= func */
  {  383,   -3 }, /* (265) func_list ::= func_list NK_COMMA func */
  {  386,   -4 }, /* (266) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  387,   -1 }, /* (267) sma_func_name ::= function_name */
  {  387,   -1 }, /* (268) sma_func_name ::= COUNT */
  {  387,   -1 }, /* (269) sma_func_name ::= FIRST */
  {  387,   -1 }, /* (270) sma_func_name ::= LAST */
  {  387,   -1 }, /* (271) sma_func_name ::= LAST_ROW */
  {  385,    0 }, /* (272) sma_stream_opt ::= */
  {  385,   -3 }, /* (273) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  385,   -3 }, /* (274) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  385,   -3 }, /* (275) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  324,   -6 }, /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  324,   -7 }, /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  324,   -9 }, /* (278) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  324,   -7 }, /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  324,   -9 }, /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  324,   -4 }, /* (281) cmd ::= DROP TOPIC exists_opt topic_name */
  {  324,   -7 }, /* (282) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  324,   -2 }, /* (283) cmd ::= DESC full_table_name */
  {  324,   -2 }, /* (284) cmd ::= DESCRIBE full_table_name */
  {  324,   -3 }, /* (285) cmd ::= RESET QUERY CACHE */
  {  324,   -4 }, /* (286) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  390,    0 }, /* (287) analyze_opt ::= */
  {  390,   -1 }, /* (288) analyze_opt ::= ANALYZE */
  {  391,    0 }, /* (289) explain_options ::= */
  {  391,   -3 }, /* (290) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  391,   -3 }, /* (291) explain_options ::= explain_options RATIO NK_FLOAT */
  {  324,  -10 }, /* (292) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  324,   -4 }, /* (293) cmd ::= DROP FUNCTION exists_opt function_name */
  {  392,    0 }, /* (294) agg_func_opt ::= */
  {  392,   -1 }, /* (295) agg_func_opt ::= AGGREGATE */
  {  393,    0 }, /* (296) bufsize_opt ::= */
  {  393,   -2 }, /* (297) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  324,  -11 }, /* (298) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  324,   -4 }, /* (299) cmd ::= DROP STREAM exists_opt stream_name */
  {  395,    0 }, /* (300) stream_options ::= */
  {  395,   -3 }, /* (301) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  395,   -3 }, /* (302) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  395,   -4 }, /* (303) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  395,   -3 }, /* (304) stream_options ::= stream_options WATERMARK duration_literal */
  {  395,   -4 }, /* (305) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  395,   -3 }, /* (306) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  396,    0 }, /* (307) subtable_opt ::= */
  {  396,   -4 }, /* (308) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  324,   -3 }, /* (309) cmd ::= KILL CONNECTION NK_INTEGER */
  {  324,   -3 }, /* (310) cmd ::= KILL QUERY NK_STRING */
  {  324,   -3 }, /* (311) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  324,   -2 }, /* (312) cmd ::= BALANCE VGROUP */
  {  324,   -4 }, /* (313) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  324,   -4 }, /* (314) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  324,   -3 }, /* (315) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  398,   -2 }, /* (316) dnode_list ::= DNODE NK_INTEGER */
  {  398,   -3 }, /* (317) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  324,   -4 }, /* (318) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  324,   -1 }, /* (319) cmd ::= query_or_subquery */
  {  324,   -7 }, /* (320) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  324,   -4 }, /* (321) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  327,   -1 }, /* (322) literal ::= NK_INTEGER */
  {  327,   -1 }, /* (323) literal ::= NK_FLOAT */
  {  327,   -1 }, /* (324) literal ::= NK_STRING */
  {  327,   -1 }, /* (325) literal ::= NK_BOOL */
  {  327,   -2 }, /* (326) literal ::= TIMESTAMP NK_STRING */
  {  327,   -1 }, /* (327) literal ::= duration_literal */
  {  327,   -1 }, /* (328) literal ::= NULL */
  {  327,   -1 }, /* (329) literal ::= NK_QUESTION */
  {  371,   -1 }, /* (330) duration_literal ::= NK_VARIABLE */
  {  400,   -1 }, /* (331) signed ::= NK_INTEGER */
  {  400,   -2 }, /* (332) signed ::= NK_PLUS NK_INTEGER */
  {  400,   -2 }, /* (333) signed ::= NK_MINUS NK_INTEGER */
  {  400,   -1 }, /* (334) signed ::= NK_FLOAT */
  {  400,   -2 }, /* (335) signed ::= NK_PLUS NK_FLOAT */
  {  400,   -2 }, /* (336) signed ::= NK_MINUS NK_FLOAT */
  {  360,   -1 }, /* (337) signed_literal ::= signed */
  {  360,   -1 }, /* (338) signed_literal ::= NK_STRING */
  {  360,   -1 }, /* (339) signed_literal ::= NK_BOOL */
  {  360,   -2 }, /* (340) signed_literal ::= TIMESTAMP NK_STRING */
  {  360,   -1 }, /* (341) signed_literal ::= duration_literal */
  {  360,   -1 }, /* (342) signed_literal ::= NULL */
  {  360,   -1 }, /* (343) signed_literal ::= literal_func */
  {  360,   -1 }, /* (344) signed_literal ::= NK_QUESTION */
  {  402,   -1 }, /* (345) literal_list ::= signed_literal */
  {  402,   -3 }, /* (346) literal_list ::= literal_list NK_COMMA signed_literal */
  {  335,   -1 }, /* (347) db_name ::= NK_ID */
  {  366,   -1 }, /* (348) table_name ::= NK_ID */
  {  358,   -1 }, /* (349) column_name ::= NK_ID */
  {  373,   -1 }, /* (350) function_name ::= NK_ID */
  {  403,   -1 }, /* (351) table_alias ::= NK_ID */
  {  381,   -1 }, /* (352) column_alias ::= NK_ID */
  {  329,   -1 }, /* (353) user_name ::= NK_ID */
  {  336,   -1 }, /* (354) topic_name ::= NK_ID */
  {  394,   -1 }, /* (355) stream_name ::= NK_ID */
  {  389,   -1 }, /* (356) cgroup_name ::= NK_ID */
  {  404,   -1 }, /* (357) expr_or_subquery ::= expression */
  {  397,   -1 }, /* (358) expression ::= literal */
  {  397,   -1 }, /* (359) expression ::= pseudo_column */
  {  397,   -1 }, /* (360) expression ::= column_reference */
  {  397,   -1 }, /* (361) expression ::= function_expression */
  {  397,   -1 }, /* (362) expression ::= case_when_expression */
  {  397,   -3 }, /* (363) expression ::= NK_LP expression NK_RP */
  {  397,   -2 }, /* (364) expression ::= NK_PLUS expr_or_subquery */
  {  397,   -2 }, /* (365) expression ::= NK_MINUS expr_or_subquery */
  {  397,   -3 }, /* (366) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  397,   -3 }, /* (367) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  397,   -3 }, /* (368) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  397,   -3 }, /* (369) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  397,   -3 }, /* (370) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  397,   -3 }, /* (371) expression ::= column_reference NK_ARROW NK_STRING */
  {  397,   -3 }, /* (372) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  397,   -3 }, /* (373) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  363,   -1 }, /* (374) expression_list ::= expr_or_subquery */
  {  363,   -3 }, /* (375) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  406,   -1 }, /* (376) column_reference ::= column_name */
  {  406,   -3 }, /* (377) column_reference ::= table_name NK_DOT column_name */
  {  405,   -1 }, /* (378) pseudo_column ::= ROWTS */
  {  405,   -1 }, /* (379) pseudo_column ::= TBNAME */
  {  405,   -3 }, /* (380) pseudo_column ::= table_name NK_DOT TBNAME */
  {  405,   -1 }, /* (381) pseudo_column ::= QSTART */
  {  405,   -1 }, /* (382) pseudo_column ::= QEND */
  {  405,   -1 }, /* (383) pseudo_column ::= QDURATION */
  {  405,   -1 }, /* (384) pseudo_column ::= WSTART */
  {  405,   -1 }, /* (385) pseudo_column ::= WEND */
  {  405,   -1 }, /* (386) pseudo_column ::= WDURATION */
  {  405,   -1 }, /* (387) pseudo_column ::= IROWTS */
  {  405,   -1 }, /* (388) pseudo_column ::= QTAGS */
  {  407,   -4 }, /* (389) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  407,   -4 }, /* (390) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  407,   -6 }, /* (391) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  407,   -1 }, /* (392) function_expression ::= literal_func */
  {  401,   -3 }, /* (393) literal_func ::= noarg_func NK_LP NK_RP */
  {  401,   -1 }, /* (394) literal_func ::= NOW */
  {  411,   -1 }, /* (395) noarg_func ::= NOW */
  {  411,   -1 }, /* (396) noarg_func ::= TODAY */
  {  411,   -1 }, /* (397) noarg_func ::= TIMEZONE */
  {  411,   -1 }, /* (398) noarg_func ::= DATABASE */
  {  411,   -1 }, /* (399) noarg_func ::= CLIENT_VERSION */
  {  411,   -1 }, /* (400) noarg_func ::= SERVER_VERSION */
  {  411,   -1 }, /* (401) noarg_func ::= SERVER_STATUS */
  {  411,   -1 }, /* (402) noarg_func ::= CURRENT_USER */
  {  411,   -1 }, /* (403) noarg_func ::= USER */
  {  409,   -1 }, /* (404) star_func ::= COUNT */
  {  409,   -1 }, /* (405) star_func ::= FIRST */
  {  409,   -1 }, /* (406) star_func ::= LAST */
  {  409,   -1 }, /* (407) star_func ::= LAST_ROW */
  {  410,   -1 }, /* (408) star_func_para_list ::= NK_STAR */
  {  410,   -1 }, /* (409) star_func_para_list ::= other_para_list */
  {  412,   -1 }, /* (410) other_para_list ::= star_func_para */
  {  412,   -3 }, /* (411) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  413,   -1 }, /* (412) star_func_para ::= expr_or_subquery */
  {  413,   -3 }, /* (413) star_func_para ::= table_name NK_DOT NK_STAR */
  {  408,   -4 }, /* (414) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  408,   -5 }, /* (415) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  414,   -1 }, /* (416) when_then_list ::= when_then_expr */
  {  414,   -2 }, /* (417) when_then_list ::= when_then_list when_then_expr */
  {  417,   -4 }, /* (418) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  415,    0 }, /* (419) case_when_else_opt ::= */
  {  415,   -2 }, /* (420) case_when_else_opt ::= ELSE common_expression */
  {  418,   -3 }, /* (421) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  418,   -5 }, /* (422) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  418,   -6 }, /* (423) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  418,   -3 }, /* (424) predicate ::= expr_or_subquery IS NULL */
  {  418,   -4 }, /* (425) predicate ::= expr_or_subquery IS NOT NULL */
  {  418,   -3 }, /* (426) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  419,   -1 }, /* (427) compare_op ::= NK_LT */
  {  419,   -1 }, /* (428) compare_op ::= NK_GT */
  {  419,   -1 }, /* (429) compare_op ::= NK_LE */
  {  419,   -1 }, /* (430) compare_op ::= NK_GE */
  {  419,   -1 }, /* (431) compare_op ::= NK_NE */
  {  419,   -1 }, /* (432) compare_op ::= NK_EQ */
  {  419,   -1 }, /* (433) compare_op ::= LIKE */
  {  419,   -2 }, /* (434) compare_op ::= NOT LIKE */
  {  419,   -1 }, /* (435) compare_op ::= MATCH */
  {  419,   -1 }, /* (436) compare_op ::= NMATCH */
  {  419,   -1 }, /* (437) compare_op ::= CONTAINS */
  {  420,   -1 }, /* (438) in_op ::= IN */
  {  420,   -2 }, /* (439) in_op ::= NOT IN */
  {  421,   -3 }, /* (440) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  422,   -1 }, /* (441) boolean_value_expression ::= boolean_primary */
  {  422,   -2 }, /* (442) boolean_value_expression ::= NOT boolean_primary */
  {  422,   -3 }, /* (443) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  422,   -3 }, /* (444) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  423,   -1 }, /* (445) boolean_primary ::= predicate */
  {  423,   -3 }, /* (446) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  416,   -1 }, /* (447) common_expression ::= expr_or_subquery */
  {  416,   -1 }, /* (448) common_expression ::= boolean_value_expression */
  {  424,    0 }, /* (449) from_clause_opt ::= */
  {  424,   -2 }, /* (450) from_clause_opt ::= FROM table_reference_list */
  {  425,   -1 }, /* (451) table_reference_list ::= table_reference */
  {  425,   -3 }, /* (452) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  426,   -1 }, /* (453) table_reference ::= table_primary */
  {  426,   -1 }, /* (454) table_reference ::= joined_table */
  {  427,   -2 }, /* (455) table_primary ::= table_name alias_opt */
  {  427,   -4 }, /* (456) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  427,   -2 }, /* (457) table_primary ::= subquery alias_opt */
  {  427,   -1 }, /* (458) table_primary ::= parenthesized_joined_table */
  {  429,    0 }, /* (459) alias_opt ::= */
  {  429,   -1 }, /* (460) alias_opt ::= table_alias */
  {  429,   -2 }, /* (461) alias_opt ::= AS table_alias */
  {  431,   -3 }, /* (462) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  431,   -3 }, /* (463) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  428,   -6 }, /* (464) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  432,    0 }, /* (465) join_type ::= */
  {  432,   -1 }, /* (466) join_type ::= INNER */
  {  434,  -12 }, /* (467) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  435,    0 }, /* (468) set_quantifier_opt ::= */
  {  435,   -1 }, /* (469) set_quantifier_opt ::= DISTINCT */
  {  435,   -1 }, /* (470) set_quantifier_opt ::= ALL */
  {  436,   -1 }, /* (471) select_list ::= select_item */
  {  436,   -3 }, /* (472) select_list ::= select_list NK_COMMA select_item */
  {  444,   -1 }, /* (473) select_item ::= NK_STAR */
  {  444,   -1 }, /* (474) select_item ::= common_expression */
  {  444,   -2 }, /* (475) select_item ::= common_expression column_alias */
  {  444,   -3 }, /* (476) select_item ::= common_expression AS column_alias */
  {  444,   -3 }, /* (477) select_item ::= table_name NK_DOT NK_STAR */
  {  399,    0 }, /* (478) where_clause_opt ::= */
  {  399,   -2 }, /* (479) where_clause_opt ::= WHERE search_condition */
  {  437,    0 }, /* (480) partition_by_clause_opt ::= */
  {  437,   -3 }, /* (481) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  445,   -1 }, /* (482) partition_list ::= partition_item */
  {  445,   -3 }, /* (483) partition_list ::= partition_list NK_COMMA partition_item */
  {  446,   -1 }, /* (484) partition_item ::= expr_or_subquery */
  {  446,   -2 }, /* (485) partition_item ::= expr_or_subquery column_alias */
  {  446,   -3 }, /* (486) partition_item ::= expr_or_subquery AS column_alias */
  {  441,    0 }, /* (487) twindow_clause_opt ::= */
  {  441,   -6 }, /* (488) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  441,   -4 }, /* (489) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  441,   -6 }, /* (490) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  441,   -8 }, /* (491) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  441,   -7 }, /* (492) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  384,    0 }, /* (493) sliding_opt ::= */
  {  384,   -4 }, /* (494) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  440,    0 }, /* (495) fill_opt ::= */
  {  440,   -4 }, /* (496) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  440,   -6 }, /* (497) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  447,   -1 }, /* (498) fill_mode ::= NONE */
  {  447,   -1 }, /* (499) fill_mode ::= PREV */
  {  447,   -1 }, /* (500) fill_mode ::= NULL */
  {  447,   -1 }, /* (501) fill_mode ::= LINEAR */
  {  447,   -1 }, /* (502) fill_mode ::= NEXT */
  {  442,    0 }, /* (503) group_by_clause_opt ::= */
  {  442,   -3 }, /* (504) group_by_clause_opt ::= GROUP BY group_by_list */
  {  448,   -1 }, /* (505) group_by_list ::= expr_or_subquery */
  {  448,   -3 }, /* (506) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  443,    0 }, /* (507) having_clause_opt ::= */
  {  443,   -2 }, /* (508) having_clause_opt ::= HAVING search_condition */
  {  438,    0 }, /* (509) range_opt ::= */
  {  438,   -6 }, /* (510) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  439,    0 }, /* (511) every_opt ::= */
  {  439,   -4 }, /* (512) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  449,   -4 }, /* (513) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  450,   -1 }, /* (514) query_simple ::= query_specification */
  {  450,   -1 }, /* (515) query_simple ::= union_query_expression */
  {  454,   -4 }, /* (516) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  454,   -3 }, /* (517) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  455,   -1 }, /* (518) query_simple_or_subquery ::= query_simple */
  {  455,   -1 }, /* (519) query_simple_or_subquery ::= subquery */
  {  388,   -1 }, /* (520) query_or_subquery ::= query_expression */
  {  388,   -1 }, /* (521) query_or_subquery ::= subquery */
  {  451,    0 }, /* (522) order_by_clause_opt ::= */
  {  451,   -3 }, /* (523) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  452,    0 }, /* (524) slimit_clause_opt ::= */
  {  452,   -2 }, /* (525) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  452,   -4 }, /* (526) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  452,   -4 }, /* (527) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  453,    0 }, /* (528) limit_clause_opt ::= */
  {  453,   -2 }, /* (529) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  453,   -4 }, /* (530) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  453,   -4 }, /* (531) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  430,   -3 }, /* (532) subquery ::= NK_LP query_expression NK_RP */
  {  430,   -3 }, /* (533) subquery ::= NK_LP subquery NK_RP */
  {  433,   -1 }, /* (534) search_condition ::= common_expression */
  {  456,   -1 }, /* (535) sort_specification_list ::= sort_specification */
  {  456,   -3 }, /* (536) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  457,   -3 }, /* (537) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  458,    0 }, /* (538) ordering_specification_opt ::= */
  {  458,   -1 }, /* (539) ordering_specification_opt ::= ASC */
  {  458,   -1 }, /* (540) ordering_specification_opt ::= DESC */
  {  459,    0 }, /* (541) null_ordering_opt ::= */
  {  459,   -2 }, /* (542) null_ordering_opt ::= NULLS FIRST */
  {  459,   -2 }, /* (543) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,325,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy849, &yymsp[-1].minor.yy0, yymsp[0].minor.yy383); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy849, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy849, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy849, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy849); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy383 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy383 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy869, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy849); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy869, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy849); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy869 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy869 = yymsp[0].minor.yy869; }
  yymsp[0].minor.yy869 = yylhsminor.yy869;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy869 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy869 = yymsp[-2].minor.yy869 | yymsp[0].minor.yy869; }
  yymsp[-2].minor.yy869 = yylhsminor.yy869;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy869 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy869 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy849 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy849 = yylhsminor.yy849;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy849 = yymsp[-2].minor.yy849; }
  yymsp[-2].minor.yy849 = yylhsminor.yy849;
        break;
      case 42: /* priv_level ::= topic_name */
      case 267: /* sma_func_name ::= function_name */ yytestcase(yyruleno==267);
      case 460: /* alias_opt ::= table_alias */ yytestcase(yyruleno==460);
{ yylhsminor.yy849 = yymsp[0].minor.yy849; }
  yymsp[0].minor.yy849 = yylhsminor.yy849;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy849, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy57); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy849, yymsp[0].minor.yy57); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 268: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==268);
      case 269: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==269);
      case 270: /* sma_func_name ::= LAST */ yytestcase(yyruleno==270);
      case 271: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==271);
      case 347: /* db_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* table_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* column_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* function_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* table_alias ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* column_alias ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* user_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* topic_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* stream_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 395: /* noarg_func ::= NOW */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= TODAY */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= USER */ yytestcase(yyruleno==403);
      case 404: /* star_func ::= COUNT */ yytestcase(yyruleno==404);
      case 405: /* star_func ::= FIRST */ yytestcase(yyruleno==405);
      case 406: /* star_func ::= LAST */ yytestcase(yyruleno==406);
      case 407: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==407);
{ yylhsminor.yy849 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy849 = yylhsminor.yy849;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 287: /* analyze_opt ::= */ yytestcase(yyruleno==287);
      case 294: /* agg_func_opt ::= */ yytestcase(yyruleno==294);
      case 468: /* set_quantifier_opt ::= */ yytestcase(yyruleno==468);
{ yymsp[1].minor.yy57 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 288: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==288);
      case 295: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==295);
      case 469: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==469);
{ yymsp[0].minor.yy57 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy57, &yymsp[-1].minor.yy849, yymsp[0].minor.yy752); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy57, &yymsp[0].minor.yy849); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy849); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy849, yymsp[0].minor.yy752); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy849); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy849, yymsp[0].minor.yy340); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy57 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy57 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy752 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_KEEP, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_RETENTIONS, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-3].minor.yy752, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-3].minor.yy752, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy752 = setDatabaseOption(pCxt, yymsp[-2].minor.yy752, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy752 = createAlterDatabaseOptions(pCxt); yylhsminor.yy752 = setAlterDatabaseOption(pCxt, yylhsminor.yy752, &yymsp[0].minor.yy5); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy752 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy752, &yymsp[0].minor.yy5); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy5.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy5.type = DB_OPTION_KEEP; yymsp[-1].minor.yy5.pList = yymsp[0].minor.yy424; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_PAGES; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_WAL; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy5.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 317: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==317);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy424 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 264: /* func_list ::= func */ yytestcase(yyruleno==264);
      case 345: /* literal_list ::= signed_literal */ yytestcase(yyruleno==345);
      case 410: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==410);
      case 416: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==416);
      case 471: /* select_list ::= select_item */ yytestcase(yyruleno==471);
      case 482: /* partition_list ::= partition_item */ yytestcase(yyruleno==482);
      case 535: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==535);
{ yylhsminor.yy424 = createNodeList(pCxt, yymsp[0].minor.yy752); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==265);
      case 346: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==346);
      case 411: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==411);
      case 472: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==472);
      case 483: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==483);
      case 536: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==536);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, yymsp[0].minor.yy752); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy752 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 126: /* speed_opt ::= */
      case 296: /* bufsize_opt ::= */ yytestcase(yyruleno==296);
{ yymsp[1].minor.yy340 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 297: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==297);
{ yymsp[-1].minor.yy340 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy57, yymsp[-5].minor.yy752, yymsp[-3].minor.yy424, yymsp[-1].minor.yy424, yymsp[0].minor.yy752); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy57, yymsp[0].minor.yy752); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 319: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==319);
{ pCxt->pRootNode = yymsp[0].minor.yy752; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy752); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy752 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy752, yymsp[0].minor.yy752); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy752 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy752, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy849, yymsp[0].minor.yy384); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy752 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy752, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy849); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy752 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy752, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy849, yymsp[0].minor.yy384); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy752 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy752, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy849, &yymsp[0].minor.yy849); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy752 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy752, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy849, yymsp[0].minor.yy384); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy752 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy752, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy849); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy752 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy752, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy849, yymsp[0].minor.yy384); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy752 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy752, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy849, &yymsp[0].minor.yy849); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy752 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy752, &yymsp[-2].minor.yy849, yymsp[0].minor.yy752); }
  yymsp[-5].minor.yy752 = yylhsminor.yy752;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 417: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==417);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-1].minor.yy424, yymsp[0].minor.yy752); }
  yymsp[-1].minor.yy424 = yylhsminor.yy424;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy752 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy57, yymsp[-8].minor.yy752, yymsp[-6].minor.yy752, yymsp[-5].minor.yy424, yymsp[-2].minor.yy424, yymsp[0].minor.yy752); }
  yymsp[-9].minor.yy752 = yylhsminor.yy752;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy752 = createDropTableClause(pCxt, yymsp[-1].minor.yy57, yymsp[0].minor.yy752); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 480: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==480);
      case 503: /* group_by_clause_opt ::= */ yytestcase(yyruleno==503);
      case 522: /* order_by_clause_opt ::= */ yytestcase(yyruleno==522);
{ yymsp[1].minor.yy424 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy752 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy849, NULL); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy752 = createRealTableNode(pCxt, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy849, NULL); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy752 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy849, yymsp[0].minor.yy384, NULL); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy752 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy849, yymsp[-2].minor.yy384, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy384 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy384 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy384 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy384 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy384 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy384 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy384 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy384 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy384 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy384 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy384 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 409: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==409);
{ yylhsminor.yy424 = yymsp[0].minor.yy424; }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy752 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-2].minor.yy752, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-2].minor.yy752, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-2].minor.yy752, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-4].minor.yy752, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-2].minor.yy752, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-4].minor.yy752, TABLE_OPTION_SMA, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-2].minor.yy752, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy752 = createAlterTableOptions(pCxt); yylhsminor.yy752 = setTableOption(pCxt, yylhsminor.yy752, yymsp[0].minor.yy5.type, &yymsp[0].minor.yy5.val); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy752 = setTableOption(pCxt, yymsp[-1].minor.yy752, yymsp[0].minor.yy5.type, &yymsp[0].minor.yy5.val); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy5.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy5.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy5.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 374: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==374);
{ yylhsminor.yy424 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy752)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 375: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==375);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, releaseRawExprNode(pCxt, yymsp[0].minor.yy752)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy752 = createFunctionNode(pCxt, &yymsp[0].minor.yy849, NULL); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy752 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy752 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy849); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy752, yymsp[0].minor.yy752, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy752, yymsp[0].minor.yy752, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy752, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy752, yymsp[-1].minor.yy752, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy849); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy752); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy752); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy752); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy752); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy752, yymsp[-1].minor.yy752, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy752, yymsp[0].minor.yy752, yymsp[-3].minor.yy424); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy752 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy752 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy849); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 247: /* like_pattern_opt ::= */
      case 307: /* subtable_opt ::= */ yytestcase(yyruleno==307);
      case 419: /* case_when_else_opt ::= */ yytestcase(yyruleno==419);
      case 449: /* from_clause_opt ::= */ yytestcase(yyruleno==449);
      case 478: /* where_clause_opt ::= */ yytestcase(yyruleno==478);
      case 487: /* twindow_clause_opt ::= */ yytestcase(yyruleno==487);
      case 493: /* sliding_opt ::= */ yytestcase(yyruleno==493);
      case 495: /* fill_opt ::= */ yytestcase(yyruleno==495);
      case 507: /* having_clause_opt ::= */ yytestcase(yyruleno==507);
      case 509: /* range_opt ::= */ yytestcase(yyruleno==509);
      case 511: /* every_opt ::= */ yytestcase(yyruleno==511);
      case 524: /* slimit_clause_opt ::= */ yytestcase(yyruleno==524);
      case 528: /* limit_clause_opt ::= */ yytestcase(yyruleno==528);
{ yymsp[1].minor.yy752 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy752 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy849); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy752 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy849); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy752 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy752 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy849), &yymsp[0].minor.yy849); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy752 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy849), &yymsp[0].minor.yy849); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy57, yymsp[-3].minor.yy752, yymsp[-1].minor.yy752, NULL, yymsp[0].minor.yy752); }
        break;
      case 261: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy57, yymsp[0].minor.yy752); }
        break;
      case 262: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy752 = createIndexOption(pCxt, yymsp[-7].minor.yy424, releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), NULL, yymsp[-1].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy752 = createIndexOption(pCxt, yymsp[-9].minor.yy424, releaseRawExprNode(pCxt, yymsp[-5].minor.yy752), releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), yymsp[-1].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 266: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy752 = createFunctionNode(pCxt, &yymsp[-3].minor.yy849, yymsp[-1].minor.yy424); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 272: /* sma_stream_opt ::= */
      case 300: /* stream_options ::= */ yytestcase(yyruleno==300);
{ yymsp[1].minor.yy752 = createStreamOptions(pCxt); }
        break;
      case 273: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 304: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==304);
{ ((SStreamOptions*)yymsp[-2].minor.yy752)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy752); yylhsminor.yy752 = yymsp[-2].minor.yy752; }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 274: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy752)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy752); yylhsminor.yy752 = yymsp[-2].minor.yy752; }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 275: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy752)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy752); yylhsminor.yy752 = yymsp[-2].minor.yy752; }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy57, &yymsp[-2].minor.yy849, yymsp[0].minor.yy752); }
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy57, &yymsp[-3].minor.yy849, &yymsp[0].minor.yy849, false); }
        break;
      case 278: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy57, &yymsp[-5].minor.yy849, &yymsp[0].minor.yy849, true); }
        break;
      case 279: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy57, &yymsp[-3].minor.yy849, yymsp[0].minor.yy752, false); }
        break;
      case 280: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy57, &yymsp[-5].minor.yy849, yymsp[0].minor.yy752, true); }
        break;
      case 281: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy57, &yymsp[0].minor.yy849); }
        break;
      case 282: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy57, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy849); }
        break;
      case 283: /* cmd ::= DESC full_table_name */
      case 284: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==284);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy752); }
        break;
      case 285: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 286: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy57, yymsp[-1].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 289: /* explain_options ::= */
{ yymsp[1].minor.yy752 = createDefaultExplainOptions(pCxt); }
        break;
      case 290: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy752 = setExplainVerbose(pCxt, yymsp[-2].minor.yy752, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 291: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy752 = setExplainRatio(pCxt, yymsp[-2].minor.yy752, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 292: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy57, yymsp[-8].minor.yy57, &yymsp[-5].minor.yy849, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy384, yymsp[0].minor.yy340); }
        break;
      case 293: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy57, &yymsp[0].minor.yy849); }
        break;
      case 298: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy57, &yymsp[-7].minor.yy849, yymsp[-4].minor.yy752, yymsp[-6].minor.yy752, yymsp[-3].minor.yy424, yymsp[-2].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 299: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy57, &yymsp[0].minor.yy849); }
        break;
      case 301: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy752)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy752 = yymsp[-2].minor.yy752; }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 302: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy752)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy752 = yymsp[-2].minor.yy752; }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 303: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy752)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy752)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy752); yylhsminor.yy752 = yymsp[-3].minor.yy752; }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 305: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy752)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy752 = yymsp[-3].minor.yy752; }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 306: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy752)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy752 = yymsp[-2].minor.yy752; }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 308: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 494: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==494);
      case 512: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==512);
{ yymsp[-3].minor.yy752 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy752); }
        break;
      case 309: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 310: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 312: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 313: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 314: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy424); }
        break;
      case 315: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 316: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 318: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 320: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy752, yymsp[-2].minor.yy424, yymsp[0].minor.yy752); }
        break;
      case 321: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy752, NULL, yymsp[0].minor.yy752); }
        break;
      case 322: /* literal ::= NK_INTEGER */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 323: /* literal ::= NK_FLOAT */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 324: /* literal ::= NK_STRING */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 325: /* literal ::= NK_BOOL */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 326: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 327: /* literal ::= duration_literal */
      case 337: /* signed_literal ::= signed */ yytestcase(yyruleno==337);
      case 357: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==357);
      case 358: /* expression ::= literal */ yytestcase(yyruleno==358);
      case 359: /* expression ::= pseudo_column */ yytestcase(yyruleno==359);
      case 360: /* expression ::= column_reference */ yytestcase(yyruleno==360);
      case 361: /* expression ::= function_expression */ yytestcase(yyruleno==361);
      case 362: /* expression ::= case_when_expression */ yytestcase(yyruleno==362);
      case 392: /* function_expression ::= literal_func */ yytestcase(yyruleno==392);
      case 441: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==441);
      case 445: /* boolean_primary ::= predicate */ yytestcase(yyruleno==445);
      case 447: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==447);
      case 448: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==448);
      case 451: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==451);
      case 453: /* table_reference ::= table_primary */ yytestcase(yyruleno==453);
      case 454: /* table_reference ::= joined_table */ yytestcase(yyruleno==454);
      case 458: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==458);
      case 514: /* query_simple ::= query_specification */ yytestcase(yyruleno==514);
      case 515: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==515);
      case 518: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==518);
      case 520: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==520);
{ yylhsminor.yy752 = yymsp[0].minor.yy752; }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 328: /* literal ::= NULL */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 329: /* literal ::= NK_QUESTION */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 330: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 331: /* signed ::= NK_INTEGER */
{ yylhsminor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 332: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 333: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 334: /* signed ::= NK_FLOAT */
{ yylhsminor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 335: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 336: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 338: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 339: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 340: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 341: /* signed_literal ::= duration_literal */
      case 343: /* signed_literal ::= literal_func */ yytestcase(yyruleno==343);
      case 412: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==412);
      case 474: /* select_item ::= common_expression */ yytestcase(yyruleno==474);
      case 484: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==484);
      case 519: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==519);
      case 521: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==521);
      case 534: /* search_condition ::= common_expression */ yytestcase(yyruleno==534);
{ yylhsminor.yy752 = releaseRawExprNode(pCxt, yymsp[0].minor.yy752); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 342: /* signed_literal ::= NULL */
{ yylhsminor.yy752 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 344: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy752 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 363: /* expression ::= NK_LP expression NK_RP */
      case 446: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==446);
      case 533: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==533);
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy752)); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 364: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy752));
                                                                                  }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 365: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy752), NULL));
                                                                                  }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 366: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752))); 
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 367: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752))); 
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 368: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752))); 
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 369: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752))); 
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 370: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 371: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 372: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 373: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 376: /* column_reference ::= column_name */
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy849, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy849)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 377: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy849, createColumnNode(pCxt, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy849)); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 378: /* pseudo_column ::= ROWTS */
      case 379: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==379);
      case 381: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= QEND */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= WEND */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==388);
      case 394: /* literal_func ::= NOW */ yytestcase(yyruleno==394);
{ yylhsminor.yy752 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 380: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy849)))); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 389: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 390: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==390);
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy849, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy849, yymsp[-1].minor.yy424)); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 391: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), yymsp[-1].minor.yy384)); }
  yymsp[-5].minor.yy752 = yylhsminor.yy752;
        break;
      case 393: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy849, NULL)); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 408: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy424 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 413: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 477: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==477);
{ yylhsminor.yy752 = createColumnNode(pCxt, &yymsp[-2].minor.yy849, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 414: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy424, yymsp[-1].minor.yy752)); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 415: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), yymsp[-2].minor.yy424, yymsp[-1].minor.yy752)); }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 418: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy752 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)); }
        break;
      case 420: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy752 = releaseRawExprNode(pCxt, yymsp[0].minor.yy752); }
        break;
      case 421: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 426: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==426);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy620, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 422: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy752), releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-4].minor.yy752 = yylhsminor.yy752;
        break;
      case 423: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy752), releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-5].minor.yy752 = yylhsminor.yy752;
        break;
      case 424: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), NULL));
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 425: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), NULL));
                                                                                  }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 427: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy620 = OP_TYPE_LOWER_THAN; }
        break;
      case 428: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy620 = OP_TYPE_GREATER_THAN; }
        break;
      case 429: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy620 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 430: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy620 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 431: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy620 = OP_TYPE_NOT_EQUAL; }
        break;
      case 432: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy620 = OP_TYPE_EQUAL; }
        break;
      case 433: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy620 = OP_TYPE_LIKE; }
        break;
      case 434: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy620 = OP_TYPE_NOT_LIKE; }
        break;
      case 435: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy620 = OP_TYPE_MATCH; }
        break;
      case 436: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy620 = OP_TYPE_NMATCH; }
        break;
      case 437: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy620 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 438: /* in_op ::= IN */
{ yymsp[0].minor.yy620 = OP_TYPE_IN; }
        break;
      case 439: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy620 = OP_TYPE_NOT_IN; }
        break;
      case 440: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 442: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy752), NULL));
                                                                                  }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 443: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 444: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy752);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy752);
                                                                                    yylhsminor.yy752 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), releaseRawExprNode(pCxt, yymsp[0].minor.yy752)));
                                                                                  }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 450: /* from_clause_opt ::= FROM table_reference_list */
      case 479: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==479);
      case 508: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==508);
{ yymsp[-1].minor.yy752 = yymsp[0].minor.yy752; }
        break;
      case 452: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy752 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy752, yymsp[0].minor.yy752, NULL); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 455: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy752 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy849, &yymsp[0].minor.yy849); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 456: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy752 = createRealTableNode(pCxt, &yymsp[-3].minor.yy849, &yymsp[-1].minor.yy849, &yymsp[0].minor.yy849); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 457: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy752 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy752), &yymsp[0].minor.yy849); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 459: /* alias_opt ::= */
{ yymsp[1].minor.yy849 = nil_token;  }
        break;
      case 461: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy849 = yymsp[0].minor.yy849; }
        break;
      case 462: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 463: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==463);
{ yymsp[-2].minor.yy752 = yymsp[-1].minor.yy752; }
        break;
      case 464: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy752 = createJoinTableNode(pCxt, yymsp[-4].minor.yy332, yymsp[-5].minor.yy752, yymsp[-2].minor.yy752, yymsp[0].minor.yy752); }
  yymsp[-5].minor.yy752 = yylhsminor.yy752;
        break;
      case 465: /* join_type ::= */
{ yymsp[1].minor.yy332 = JOIN_TYPE_INNER; }
        break;
      case 466: /* join_type ::= INNER */
{ yymsp[0].minor.yy332 = JOIN_TYPE_INNER; }
        break;
      case 467: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy752 = createSelectStmt(pCxt, yymsp[-10].minor.yy57, yymsp[-9].minor.yy424, yymsp[-8].minor.yy752);
                                                                                    yymsp[-11].minor.yy752 = addWhereClause(pCxt, yymsp[-11].minor.yy752, yymsp[-7].minor.yy752);
                                                                                    yymsp[-11].minor.yy752 = addPartitionByClause(pCxt, yymsp[-11].minor.yy752, yymsp[-6].minor.yy424);
                                                                                    yymsp[-11].minor.yy752 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy752, yymsp[-2].minor.yy752);
                                                                                    yymsp[-11].minor.yy752 = addGroupByClause(pCxt, yymsp[-11].minor.yy752, yymsp[-1].minor.yy424);
                                                                                    yymsp[-11].minor.yy752 = addHavingClause(pCxt, yymsp[-11].minor.yy752, yymsp[0].minor.yy752);
                                                                                    yymsp[-11].minor.yy752 = addRangeClause(pCxt, yymsp[-11].minor.yy752, yymsp[-5].minor.yy752);
                                                                                    yymsp[-11].minor.yy752 = addEveryClause(pCxt, yymsp[-11].minor.yy752, yymsp[-4].minor.yy752);
                                                                                    yymsp[-11].minor.yy752 = addFillClause(pCxt, yymsp[-11].minor.yy752, yymsp[-3].minor.yy752);
                                                                                  }
        break;
      case 470: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy57 = false; }
        break;
      case 473: /* select_item ::= NK_STAR */
{ yylhsminor.yy752 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy752 = yylhsminor.yy752;
        break;
      case 475: /* select_item ::= common_expression column_alias */
      case 485: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==485);
{ yylhsminor.yy752 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy752), &yymsp[0].minor.yy849); }
  yymsp[-1].minor.yy752 = yylhsminor.yy752;
        break;
      case 476: /* select_item ::= common_expression AS column_alias */
      case 486: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==486);
{ yylhsminor.yy752 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), &yymsp[0].minor.yy849); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 481: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 504: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==504);
      case 523: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==523);
{ yymsp[-2].minor.yy424 = yymsp[0].minor.yy424; }
        break;
      case 488: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy752 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), releaseRawExprNode(pCxt, yymsp[-1].minor.yy752)); }
        break;
      case 489: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy752 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy752)); }
        break;
      case 490: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy752 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), NULL, yymsp[-1].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 491: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy752 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy752), releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), yymsp[-1].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 492: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy752 = createEventWindowNode(pCxt, yymsp[-3].minor.yy752, yymsp[0].minor.yy752); }
        break;
      case 496: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy752 = createFillNode(pCxt, yymsp[-1].minor.yy214, NULL); }
        break;
      case 497: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy752 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
        break;
      case 498: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy214 = FILL_MODE_NONE; }
        break;
      case 499: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy214 = FILL_MODE_PREV; }
        break;
      case 500: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy214 = FILL_MODE_NULL; }
        break;
      case 501: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy214 = FILL_MODE_LINEAR; }
        break;
      case 502: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy214 = FILL_MODE_NEXT; }
        break;
      case 505: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy424 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy752))); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 506: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy752))); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 510: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy752 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy752), releaseRawExprNode(pCxt, yymsp[-1].minor.yy752)); }
        break;
      case 513: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy752 = addOrderByClause(pCxt, yymsp[-3].minor.yy752, yymsp[-2].minor.yy424);
                                                                                    yylhsminor.yy752 = addSlimitClause(pCxt, yylhsminor.yy752, yymsp[-1].minor.yy752);
                                                                                    yylhsminor.yy752 = addLimitClause(pCxt, yylhsminor.yy752, yymsp[0].minor.yy752);
                                                                                  }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 516: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy752 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy752, yymsp[0].minor.yy752); }
  yymsp[-3].minor.yy752 = yylhsminor.yy752;
        break;
      case 517: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy752 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy752, yymsp[0].minor.yy752); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 525: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 529: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==529);
{ yymsp[-1].minor.yy752 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 526: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 530: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==530);
{ yymsp[-3].minor.yy752 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 527: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 531: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==531);
{ yymsp[-3].minor.yy752 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 532: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy752 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy752); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 537: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy752 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy752), yymsp[-1].minor.yy538, yymsp[0].minor.yy777); }
  yymsp[-2].minor.yy752 = yylhsminor.yy752;
        break;
      case 538: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy538 = ORDER_ASC; }
        break;
      case 539: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy538 = ORDER_ASC; }
        break;
      case 540: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy538 = ORDER_DESC; }
        break;
      case 541: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy777 = NULL_ORDER_DEFAULT; }
        break;
      case 542: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy777 = NULL_ORDER_FIRST; }
        break;
      case 543: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy777 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
