/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 471
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNode* yy140;
  EFillMode yy174;
  int32_t yy214;
  SNodeList* yy220;
  int64_t yy303;
  bool yy587;
  SDataType yy682;
  ENullOrder yy697;
  EOperatorType yy794;
  SAlterOption yy809;
  EJoinType yy852;
  int8_t yy857;
  EOrder yy866;
  SToken yy881;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             751
#define YYNRULE              571
#define YYNTOKEN             328
#define YY_MAX_SHIFT         750
#define YY_MIN_SHIFTREDUCE   1116
#define YY_MAX_SHIFTREDUCE   1686
#define YY_ERROR_ACTION      1687
#define YY_ACCEPT_ACTION     1688
#define YY_NO_ACTION         1689
#define YY_MIN_REDUCE        1690
#define YY_MAX_REDUCE        2260
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2669)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   387,  376,  490, 2072,  491, 1726,  603, 1841,  161,  164,
 /*    10 */  2231, 1149,   45,   43, 1614,  363,  176, 1854, 1854,  549,
 /*    20 */   384, 1843, 1463,  615, 1903,  602,  182, 1971, 1247, 2058,
 /*    30 */  2232,  604, 2054, 1544,  559, 1461, 2090,  351, 1954,  375,
 /*    40 */  2054, 1246, 1968,  627,  618, 1971,   13,   12,  236, 2040,
 /*    50 */  1151,  656, 1154, 1155, 1488,  166,  139, 1702, 1539, 1488,
 /*    60 */  1969,  627, 1905,  552,   18, 1905, 2050, 2056,  546,  349,
 /*    70 */  1688, 1469,  362,  235, 2050, 2056,  365,  650, 1903,  640,
 /*    80 */  2071, 1903,  429,  178, 2107,  650, 2235,  109, 2073,  660,
 /*    90 */  2075, 2076,  655,  639,  650,  132, 1892,  747, 2236,  179,
 /*   100 */    14, 2160,  529,  476,  389,  378, 2156, 1898, 1900,  167,
 /*   110 */    45,   43, 1852,  625,   69, 1490, 1798,   68,  384,  184,
 /*   120 */  1463,  269, 2168,  614,  332,  133,  613, 2186,  508, 2231,
 /*   130 */  1490, 1544,  499, 1461,  491, 1726, 1546, 1547,  397,  603,
 /*   140 */   621,   31,  396, 2231,  602,  182, 1587,   38,   37, 2232,
 /*   150 */   604,   44,   42,   41,   40,   39, 1539,  489,  602,  182,
 /*   160 */   494, 1732,   18, 2232,  604, 1489, 1519, 1529, 1713, 1469,
 /*   170 */  1756,  122, 1545, 1548,  121,  120,  119,  118,  117,  116,
 /*   180 */   115,  114,  113,  578,  598,  578, 1464, 2231, 1462, 2231,
 /*   190 */    44,   42,   41,   40,   39,  747, 1676,  639,   14,  694,
 /*   200 */  1382, 1383, 2237,  182, 2237,  182,  593, 2232,  604, 2232,
 /*   210 */   604,  176, 1467, 1468, 2040, 1518, 1521, 1522, 1523, 1524,
 /*   220 */  1525, 1526, 1527, 1528,  652,  648, 1537, 1538, 1540, 1541,
 /*   230 */  1542, 1543,    2, 1955, 1546, 1547,  724,  723,  722,  721,
 /*   240 */   394, 1712,  720,  719,  143,  714,  713,  712,  711,  710,
 /*   250 */   709,  708,  156,  704,  703,  702,  393,  392,  699,  698,
 /*   260 */   697,  696,  695,  271, 1519, 1529,  639,  567,   38,   37,
 /*   270 */  1545, 1548,   44,   42,   41,   40,   39,   48,  271,  640,
 /*   280 */  1491, 1327, 1328,  467, 1464,  692, 1462, 2040,  238,  599,
 /*   290 */   594,  587,  237,   38,   37,  132, 1487,   44,   42,   41,
 /*   300 */    40,   39,  534,  154,  153,  689,  688,  687,  151,   86,
 /*   310 */  1467, 1468, 1852, 1518, 1521, 1522, 1523, 1524, 1525, 1526,
 /*   320 */  1527, 1528,  652,  648, 1537, 1538, 1540, 1541, 1542, 1543,
 /*   330 */     2,   11,   45,   43, 1848,  498,  626, 2059,  494, 1732,
 /*   340 */   384, 1293, 1463,  423,  198,  197,   48,  422, 2054,  344,
 /*   350 */    89,  339,  606, 1544,  361, 1461,  560, 1284,  682,  681,
 /*   360 */   680, 1288,  679, 1290, 1291,  678,  675,  466, 1299,  672,
 /*   370 */  1301, 1302,  669,  666, 1691,  194,   35,  290, 1539, 1829,
 /*   380 */   496, 2072, 2050, 2056,   18,  506,  492, 1964,  578,  610,
 /*   390 */  2033, 1469, 2231,  650, 1573,  122, 1899, 1900,  121,  120,
 /*   400 */   119,  118,  117,  116,  115,  114,  113, 2237,  182,   86,
 /*   410 */   281,  282, 2232,  604, 2090,  280,   83,  747, 1618,   82,
 /*   420 */    14, 1168,  657, 1167, 1488,  353,  185, 2040,  249,  656,
 /*   430 */    45,   43, 1549,   61, 1847,  578,  222, 1554,  384, 2231,
 /*   440 */  1463,   38,   37, 1488,   49,   44,   42,   41,   40,   39,
 /*   450 */  1574, 1544, 1169, 1461, 2237,  182, 1546, 1547, 2071, 2232,
 /*   460 */   604,  100, 2107,  272,  106,  109, 2073,  660, 2075, 2076,
 /*   470 */   655, 1690,  650, 1711, 1710,  142, 1539,  149, 2131, 2160,
 /*   480 */   140,  718,  716,  378, 2156, 1845, 1519, 1529, 1844, 1469,
 /*   490 */  1759,  692, 1545, 1548, 1746,  131,  130,  129,  128,  127,
 /*   500 */   126,  125,  124,  123,   11,   61, 1464,   92, 1462,  154,
 /*   510 */   153,  689,  688,  687,  151,  747,  545, 1488,   46, 2040,
 /*   520 */  2040,   34,  382, 1568, 1569, 1570, 1571, 1572, 1576, 1577,
 /*   530 */  1578, 1579, 1467, 1468, 1469, 1518, 1521, 1522, 1523, 1524,
 /*   540 */  1525, 1526, 1527, 1528,  652,  648, 1537, 1538, 1540, 1541,
 /*   550 */  1542, 1543,    2, 1251, 1546, 1547,  544,  543,  542,  544,
 /*   560 */   543,  542, 1489,  685,  136,  538, 1250,  136,  538,  537,
 /*   570 */  1520, 1611,  537, 2090,  536,  541, 2058,  536,  541, 2072,
 /*   580 */   535,  597,  185,  535, 1519, 1529,  615, 2054,  706, 1520,
 /*   590 */  1545, 1548,  558,  185,   38,   37,   65,   61,   44,   42,
 /*   600 */    41,   40,   39,   33, 1464,  556, 1462,  554, 1491,   38,
 /*   610 */    37, 1683, 2090,   44,   42,   41,   40,   39,  611,  139,
 /*   620 */   618, 2050, 2056,  366, 1837, 2040,  596,  656,  478, 1839,
 /*   630 */  1467, 1468,  650, 1518, 1521, 1522, 1523, 1524, 1525, 1526,
 /*   640 */  1527, 1528,  652,  648, 1537, 1538, 1540, 1541, 1542, 1543,
 /*   650 */     2,   45,   43,   61,  185, 1905, 2071,  640,  239,  384,
 /*   660 */  2107, 1463,  372,  109, 2073,  660, 2075, 2076,  655, 1642,
 /*   670 */   650, 1903, 1544,  187, 1461,  179,  577, 2160, 1399, 1400,
 /*   680 */  1950,  378, 2156,  617,  180, 2168, 2169, 1653,  137, 2173,
 /*   690 */  1852,  190,   61,  640,   38,   37, 2072, 1539,   44,   42,
 /*   700 */    41,   40,   39, 2187,   41,   40,   39, 1682, 1835,   54,
 /*   710 */  1469,  626, 1709,  684, 1398, 1401,  590,  589, 1640, 1641,
 /*   720 */  1643, 1644, 1645, 1437, 1438, 2175, 1852,   38,   37, 2090,
 /*   730 */    27,   44,   42,   41,   40,   39,  747,  657,  421,   46,
 /*   740 */   420, 2236, 2040, 2236,  656, 2231,  185, 2231,   52,   45,
 /*   750 */    43, 2172, 2175,  640, 2034, 1236,  191,  384, 2040, 1463,
 /*   760 */   624, 2235, 1964, 2235,  419, 2232, 2234, 2232, 2233,  427,
 /*   770 */  1544,  387, 1461, 2071,  640, 1546, 1547, 2107, 2171,  164,
 /*   780 */   168, 2073,  660, 2075, 2076,  655, 1852,  650, 1854,  626,
 /*   790 */   241, 1238,  416,  640, 1905, 1539, 1708,  640, 2072,  578,
 /*   800 */   640,  377,  185, 2231, 1707, 1519, 1529, 1852, 1469,  428,
 /*   810 */  1903, 1545, 1548,  437,  418,  414,  452, 1610, 2237,  182,
 /*   820 */  1630,  579, 2197, 2232,  604, 1464, 1852, 1462,  390, 1828,
 /*   830 */  1852, 2090, 1935, 1852,  747,  430,  164,   14,  635,  657,
 /*   840 */  1964,  185, 2040,  615, 2040, 1854,  656, 1168,  431, 1167,
 /*   850 */  2040, 1467, 1468, 1575, 1518, 1521, 1522, 1523, 1524, 1525,
 /*   860 */  1526, 1527, 1528,  652,  648, 1537, 1538, 1540, 1541, 1542,
 /*   870 */  1543,    2, 1488, 1546, 1547, 2071,  139,  244, 1169, 2107,
 /*   880 */  1706, 1705,  109, 2073,  660, 2075, 2076,  655,  165,  650,
 /*   890 */  1905, 2058,  694,  310, 2135,  615, 2160,  388,  540,  539,
 /*   900 */   378, 2156, 2054, 1519, 1529, 1704, 1903,  308,   72, 1545,
 /*   910 */  1548,   71,  141,   38,   37, 2131,    8,   44,   42,   41,
 /*   920 */    40,   39, 2175, 1464,   32, 1462, 2040, 2040,  139,  205,
 /*   930 */   486,  484,  481, 1701, 1580, 1700, 2050, 2056,  379, 1154,
 /*   940 */  1155,  181, 2168, 2169, 2072,  137, 2173,  650, 2170, 1467,
 /*   950 */  1468, 2040, 1518, 1521, 1522, 1523, 1524, 1525, 1526, 1527,
 /*   960 */  1528,  652,  648, 1537, 1538, 1540, 1541, 1542, 1543,    2,
 /*   970 */    61,  335,  640, 1486, 2072, 2180, 1607, 2090, 1699, 2040,
 /*   980 */   460, 2040,  651,  474,  640,  657,  473,  447,  453, 1703,
 /*   990 */  2040, 1698,  656,  183, 2168, 2169,  446,  137, 2173, 1697,
 /*  1000 */   507,  443,   11,  475,    9, 1852,  445, 2090,  108, 1799,
 /*  1010 */   640,  640,  373,   13,   12,  657, 1827, 1852, 1520,  152,
 /*  1020 */  2040, 2071,  656,  640, 2040, 2107, 1849,  623,  109, 2073,
 /*  1030 */   660, 2075, 2076,  655,  642,  650, 2132, 2040,  640,  574,
 /*  1040 */  2251, 1696, 2160, 1852, 1852, 2040,  378, 2156,   80,   79,
 /*  1050 */   426, 2071,  352,  189,  619, 2107, 1852, 2194,  327, 2073,
 /*  1060 */   660, 2075, 2076,  655,  433,  650,  644, 1695, 2132, 1463,
 /*  1070 */  1491, 1852,  333,  163, 1694,  412,   53,  410,  406,  402,
 /*  1080 */   399,  419, 1461, 1950, 1950, 1693, 2008, 2040,  573, 2072,
 /*  1090 */   707,  565, 1814,  471,  192,  196,  465,  464,  463,  462,
 /*  1100 */   459,  458,  457,  456,  455,  451,  450,  449,  448,  334,
 /*  1110 */   440,  439,  438, 2040,  435,  434,  350,  647, 1469,  185,
 /*  1120 */  2040, 2200, 2090, 1905,  164, 1607,  640, 1472,  692,  640,
 /*  1130 */   657, 2040,  240, 1855, 2026, 2040,  578,  656, 2072, 1904,
 /*  1140 */  2231,  356,  285,  533,  747,  637,  154,  153,  689,  688,
 /*  1150 */   687,  151,   73, 1198,  686, 2237,  182, 1896,  266, 1852,
 /*  1160 */  2232,  604, 1852,  591,  532,  640, 2071,  640,  607,  690,
 /*  1170 */  2107, 2090, 1896,  109, 2073,  660, 2075, 2076,  655,  657,
 /*  1180 */   650,  638,  404,  291, 2040, 2251,  656, 2160, 1830, 1199,
 /*  1190 */   691,  378, 2156, 1896,  221,  640,  304, 2072, 1852, 1882,
 /*  1200 */  1852,   81, 2207,   51,  145,    3,  134,  357, 1471,  355,
 /*  1210 */   354,  391,  531,  247,  228, 2071,  533,  226,  248, 2107,
 /*  1220 */  2072,  105,  109, 2073,  660, 2075, 2076,  655, 1852,  650,
 /*  1230 */  2090,  102,  147, 1464, 2251, 1462, 2160,  532,  657,  230,
 /*  1240 */   378, 2156,  229, 2040,  232,  656,  234,  231, 1739,  233,
 /*  1250 */  1737,  585,  562, 2090,  561,  152,  152,   90,  260, 1467,
 /*  1260 */  1468,  657,   63,   63,  253, 1565, 2040,  700,  656,  152,
 /*  1270 */   547,   47,  550,  278, 2071, 1685, 1686,   70, 2107,  150,
 /*  1280 */  1475,  109, 2073,  660, 2075, 2076,  655, 2061,  650, 1217,
 /*  1290 */   152, 2091,  395, 2251, 1959, 2160, 1727, 2071, 2072,  378,
 /*  1300 */  2156, 2107,   63,  701,  109, 2073,  660, 2075, 2076,  655,
 /*  1310 */  2225,  650, 1432, 1435,  381,  380, 2251,   47, 2160, 1639,
 /*  1320 */  1638,  255,  378, 2156, 1477, 1215,  622, 1733, 1396, 2190,
 /*  1330 */   283, 2090, 1893, 2179,  632, 1544,  287, 1470,  616,  657,
 /*  1340 */  2063,  268,    1,  223, 2040,   47,  656, 1277,   38,   37,
 /*  1350 */   664,  150,   44,   42,   41,   40,   39, 2072,  171, 1581,
 /*  1360 */  1539, 1474,  152,  135,  525,  521,  517,  513,  220,  265,
 /*  1370 */     4,  398,  403, 1469, 1530, 2071,  742,  348,  150, 2107,
 /*  1380 */  2072, 1419,  109, 2073,  660, 2075, 2076,  655,  298,  650,
 /*  1390 */  2090,  195,  432, 1491, 2133,  608, 2160, 1960,  657,  646,
 /*  1400 */   378, 2156,  303, 2040,  436,  656,  469, 1305, 1309,   87,
 /*  1410 */   441, 1486,  218, 2090,  454, 1952,  461,  468,  470, 1316,
 /*  1420 */  1314,  657,  480,  479,  477,  199, 2040,  200,  656,  482,
 /*  1430 */   483, 1492,  202,  485, 2071,  155,  487, 1494, 2107,  488,
 /*  1440 */   497,  109, 2073,  660, 2075, 2076,  655,  500,  650, 1489,
 /*  1450 */   208,  501, 1493,  643,  210, 2160,  502, 2071, 1495,  378,
 /*  1460 */  2156, 2107, 2072,  503,  110, 2073,  660, 2075, 2076,  655,
 /*  1470 */   213,  650,  505,  215,   84,   85,  509, 1171, 2160,  217,
 /*  1480 */   211,  219, 2159, 2156,  216,  526,  504,  527, 1478,  528,
 /*  1490 */  1473,  530, 2017,  564, 2014, 2090,  338, 1842,  566,  112,
 /*  1500 */  2013,   88,  209,  657,  148,  225,  299,  242, 2040,  245,
 /*  1510 */   656, 2072, 1838,  227, 1481, 1483,  157,  158, 1840,  568,
 /*  1520 */   575, 1836,  159,  160,  569,  572,  592,  648, 1537, 1538,
 /*  1530 */  1540, 1541, 1542, 1543, 2072, 2206,  630, 2191, 2201, 2071,
 /*  1540 */  2205, 2182,  582, 2107, 2090,  588,  110, 2073,  660, 2075,
 /*  1550 */  2076,  655,  657,  650,  367,  595,  601, 2040,  261,  656,
 /*  1560 */  2160,  251,  254,    7,  645, 2156,  259, 2090,  583,  580,
 /*  1570 */   581,  172, 2254,  138,  263,  654, 2230,  264,  609,  368,
 /*  1580 */  2040,  612,  656, 1490, 1607, 2176,  620,  262,  658,  371,
 /*  1590 */  1496,  300, 2107,  628,  273,  110, 2073,  660, 2075, 2076,
 /*  1600 */   655,  629,  650,   95, 1965, 1979, 2072,  267, 1978, 2160,
 /*  1610 */   633, 2071,  634,  343, 2156, 2107, 1977,   97,  326, 2073,
 /*  1620 */   660, 2075, 2076,  655,  653,  650,  641, 2125,  301, 2072,
 /*  1630 */   374,  302,   99, 1853,   60,  101, 2141,  662, 1815, 2090,
 /*  1640 */  1897,  743,  294,  750,  305,  744,  746,  657,  329,  340,
 /*  1650 */   341,   50, 2040,  314,  656,  309,  307,  297, 2032, 2031,
 /*  1660 */  2030,   77, 2090, 2072, 2027,  400,  401, 1454, 1455,  188,
 /*  1670 */   657,  405,  175,  328,  318, 2040,  407,  656,  740,  736,
 /*  1680 */   732,  728,  295, 2071, 2025,  408,  409, 2107, 2024, 2072,
 /*  1690 */   169, 2073,  660, 2075, 2076,  655, 2090,  650,  411, 2023,
 /*  1700 */   413, 2022,  415, 2021,  657,  417, 2071,   78, 1422, 2040,
 /*  1710 */  2107,  656, 1421,  110, 2073,  660, 2075, 2076,  655, 1991,
 /*  1720 */   650, 1990, 2090,  107, 1989,  424,  288, 2160,  425, 1988,
 /*  1730 */   657, 1987, 2157, 1373, 1943, 2040, 1942,  656, 1940,  144,
 /*  1740 */  2071, 1939,  605, 2252, 2107, 1938, 1941,  168, 2073,  660,
 /*  1750 */  2075, 2076,  655, 2072,  650, 1937, 1936, 1934,  636,  193,
 /*  1760 */   442, 1931,  444, 1945, 1930, 1929, 2071, 1933, 1932, 1928,
 /*  1770 */  2107, 1927, 1926,  320, 2073,  660, 2075, 2076,  655, 1925,
 /*  1780 */   650, 1924, 1923, 1922, 1921, 2072, 2090, 1920, 1919, 2198,
 /*  1790 */  1918, 1917, 1916,  275,  657,  146, 1915, 1914,  274, 2040,
 /*  1800 */  1913,  656, 1944, 1912, 1911, 1910, 1909, 1375, 1908, 1907,
 /*  1810 */  2072,  472, 1906,  336, 1426, 1248,  243,  600, 2090,  337,
 /*  1820 */  1252, 1762, 1761, 1760,  201, 1758,  654, 1722,  203, 1244,
 /*  1830 */  2071, 2040,  204,  656, 2107, 1721, 2060,  169, 2073,  660,
 /*  1840 */  2075, 2076,  655, 2090,  650,  177,  493, 1157,  383,  206,
 /*  1850 */    75,  657, 1156,  207,   76, 2004, 2040,  495,  656, 2072,
 /*  1860 */  1998, 1986, 2071,  212,  214, 1985, 2107, 1963, 1831,  326,
 /*  1870 */  2073,  660, 2075, 2076,  655, 2072,  650, 1757, 2126, 1191,
 /*  1880 */  1755,  510,  511,  512, 1753,  514,  516, 2071,  515, 1751,
 /*  1890 */  2253, 2107, 2090,  518,  327, 2073,  660, 2075, 2076,  655,
 /*  1900 */   657,  650,  519,  520, 1749, 2040,  522,  656, 2090,  524,
 /*  1910 */   523, 1736, 1735,  385, 1321, 1320,  657, 1718, 1833, 1832,
 /*  1920 */  1235, 2040, 1234,  656, 2072,   62,  224, 1233, 1227, 1232,
 /*  1930 */   715, 1229,  717, 1747, 1228, 1226,  563,  358, 1740, 1738,
 /*  1940 */  2107, 2072,  359,  322, 2073,  660, 2075, 2076,  655,  360,
 /*  1950 */   650,  548, 2071, 1717, 1716, 1715, 2107, 2090, 2072,  327,
 /*  1960 */  2073,  660, 2075, 2076,  655,  657,  650,  551,  557,  553,
 /*  1970 */  2040,  555,  656, 1446, 2090, 1442,  111, 1444, 1441, 2003,
 /*  1980 */  1428,   26,  657,   66, 1997,   55,  570, 2040,  571,  656,
 /*  1990 */  1984, 2090, 1982,  576, 2236,   19,  246,  364, 1655,  657,
 /*  2000 */    16, 2071,   28,  250, 2040, 2107,  656, 2072,  311, 2073,
 /*  2010 */   660, 2075, 2076,  655,  584,  650,  586,  162, 2071,    5,
 /*  2020 */     6,   58, 2107, 2072,   59,  312, 2073,  660, 2075, 2076,
 /*  2030 */   655,  252,  650,  257,  258, 2071, 1637,  170,   30, 2107,
 /*  2040 */  2090, 2072,  313, 2073,  660, 2075, 2076,  655,  657,  650,
 /*  2050 */   256, 2061,   29, 2040,   64,  656, 2090,   21, 1629,   91,
 /*  2060 */  1670, 1675, 1676, 1669,  657,  369, 1674, 1673,  370, 2040,
 /*  2070 */  1604,  656, 1603,  270, 2090, 1983,  173, 1981,   56,   57,
 /*  2080 */  1980, 1962,  657,   20, 2071,   93,   94, 2040, 2107,  656,
 /*  2090 */  2072,  319, 2073,  660, 2075, 2076,  655,  276,  650,   22,
 /*  2100 */  2071,   17,  277, 1635, 2107,  279, 2072,  323, 2073,  660,
 /*  2110 */  2075, 2076,  655, 1961,  650,  284,   67,   96, 2071,  631,
 /*  2120 */    98,  102, 2107, 2090,   10,  315, 2073,  660, 2075, 2076,
 /*  2130 */   655,  657,  650,  289,  286,   23, 2040, 1556,  656, 2090,
 /*  2140 */  1555,   12, 1479, 1566, 2110,  174, 1534,  657,  649,  186,
 /*  2150 */  1532, 1511, 2040,   36,  656, 1531,   15,   24,  659, 1503,
 /*  2160 */    25,  663, 1306, 2072,  665,  386,  661, 2071, 1303,  667,
 /*  2170 */   668, 2107, 1300,  670,  324, 2073,  660, 2075, 2076,  655,
 /*  2180 */  2072,  650,  671, 2071,  673, 1294, 1292, 2107,  674,  676,
 /*  2190 */   316, 2073,  660, 2075, 2076,  655, 2090,  650, 1283,  677,
 /*  2200 */   103,  292, 1298,  104,  657,  683, 1315,   74, 1311, 2040,
 /*  2210 */  1297,  656, 1296, 2090,  693, 1295, 1189, 1223, 1222, 1221,
 /*  2220 */  1220,  657, 1219, 1218, 1216, 1214, 2040, 1213,  656, 2072,
 /*  2230 */  1212, 1242, 1207,  705, 1210,  293, 1209, 1208, 1206, 1205,
 /*  2240 */  2071, 1204, 1237, 1239, 2107, 2072, 1201,  325, 2073,  660,
 /*  2250 */  2075, 2076,  655, 1200,  650, 1197, 1196, 2071, 1195, 1194,
 /*  2260 */  1754, 2107, 2090,  725,  317, 2073,  660, 2075, 2076,  655,
 /*  2270 */   657,  650,  727,  726, 1752, 2040,  729,  656, 2090,  730,
 /*  2280 */  1750,  731,  733,  734,  735, 1748,  657,  737,  738,  739,
 /*  2290 */  1734, 2040,  741,  656, 2072, 1714, 1146,  296,  745, 1689,
 /*  2300 */  1465,  306,  748,  749, 1689, 1689, 2071, 1689, 1689, 1689,
 /*  2310 */  2107, 1689, 1689,  330, 2073,  660, 2075, 2076,  655, 2072,
 /*  2320 */   650, 1689, 2071, 1689, 1689, 1689, 2107, 2090, 1689,  331,
 /*  2330 */  2073,  660, 2075, 2076,  655,  657,  650, 1689, 1689, 1689,
 /*  2340 */  2040, 1689,  656, 2072, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2350 */  1689, 1689, 2090, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2360 */   657, 1689, 1689, 1689, 1689, 2040, 1689,  656, 1689, 1689,
 /*  2370 */  1689, 2071, 1689, 1689, 1689, 2107, 2090, 1689, 2084, 2073,
 /*  2380 */   660, 2075, 2076,  655,  657,  650, 1689, 1689, 1689, 2040,
 /*  2390 */  1689,  656, 1689, 1689, 1689, 1689, 2071, 1689, 1689, 1689,
 /*  2400 */  2107, 1689, 1689, 2083, 2073,  660, 2075, 2076,  655, 1689,
 /*  2410 */   650, 1689, 1689, 1689, 2072, 1689, 1689, 1689, 1689, 1689,
 /*  2420 */  2071, 1689, 1689, 1689, 2107, 1689, 1689, 2082, 2073,  660,
 /*  2430 */  2075, 2076,  655, 1689,  650, 1689, 2072, 1689, 1689, 1689,
 /*  2440 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 2090, 1689, 1689,
 /*  2450 */  1689, 1689, 1689, 1689, 1689,  657, 1689, 1689, 1689, 1689,
 /*  2460 */  2040, 1689,  656, 2072, 1689, 1689, 1689, 1689, 1689, 2090,
 /*  2470 */  1689, 1689, 1689, 1689, 1689, 1689, 1689,  657, 1689, 1689,
 /*  2480 */  1689, 1689, 2040, 1689,  656, 1689, 1689, 1689, 1689, 1689,
 /*  2490 */  1689, 2071, 1689, 1689, 1689, 2107, 2090, 1689,  345, 2073,
 /*  2500 */   660, 2075, 2076,  655,  657,  650, 1689, 1689, 1689, 2040,
 /*  2510 */  1689,  656, 2072, 2071, 1689, 1689, 1689, 2107, 1689, 1689,
 /*  2520 */   346, 2073,  660, 2075, 2076,  655, 1689,  650, 2072, 1689,
 /*  2530 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2540 */  2071, 1689, 1689, 1689, 2107, 2090, 1689,  342, 2073,  660,
 /*  2550 */  2075, 2076,  655,  657,  650, 1689, 1689, 1689, 2040, 1689,
 /*  2560 */   656, 2090, 1689, 1689, 1689, 1689, 1689, 1689, 1689,  657,
 /*  2570 */  1689, 1689, 1689, 1689, 2040, 1689,  656, 2072, 1689, 1689,
 /*  2580 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 2071,
 /*  2590 */  1689, 1689, 1689, 2107, 1689, 1689,  347, 2073,  660, 2075,
 /*  2600 */  2076,  655, 1689,  650, 1689,  658, 1689, 1689, 1689, 2107,
 /*  2610 */  2090, 1689,  322, 2073,  660, 2075, 2076,  655,  657,  650,
 /*  2620 */  1689, 1689, 1689, 2040, 1689,  656, 1689, 1689, 1689, 1689,
 /*  2630 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2640 */  1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689, 1689,
 /*  2650 */  1689, 1689, 1689, 1689, 2071, 1689, 1689, 1689, 2107, 1689,
 /*  2660 */  1689,  321, 2073,  660, 2075, 2076,  655, 1689,  650,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   356,  356,  335,  331,  337,  338,  441,  365,  364,  364,
 /*    10 */   445,    4,   12,   13,   14,  371,  364,  373,  373,    4,
 /*    20 */    20,  366,   22,  339,  380,  460,  461,  379,   22,  366,
 /*    30 */   465,  466,  377,   33,   19,   35,  364,  385,  386,  391,
 /*    40 */   377,   35,  394,  395,  372,  379,    1,    2,   33,  377,
 /*    50 */    43,  379,   45,   46,   20,  330,  372,  332,   58,   20,
 /*    60 */   394,  395,  364,   48,   64,  364,  411,  412,   53,  371,
 /*    70 */   328,   71,  371,   58,  411,  412,  413,  422,  380,  339,
 /*    80 */   408,  380,  339,  363,  412,  422,    3,  415,  416,  417,
 /*    90 */   418,  419,  420,   20,  422,  355,  376,   97,    3,  427,
 /*   100 */   100,  429,  362,   97,  375,  433,  434,  378,  379,  346,
 /*   110 */    12,   13,  372,   20,   99,   20,  353,  102,   20,  447,
 /*   120 */    22,  437,  438,  439,  381,  441,  442,  455,   63,  445,
 /*   130 */    20,   33,  335,   35,  337,  338,  136,  137,  396,  441,
 /*   140 */   396,    2,  400,  445,  460,  461,  101,    8,    9,  465,
 /*   150 */   466,   12,   13,   14,   15,   16,   58,  336,  460,  461,
 /*   160 */   339,  340,   64,  465,  466,   20,  166,  167,  331,   71,
 /*   170 */     0,   21,  172,  173,   24,   25,   26,   27,   28,   29,
 /*   180 */    30,   31,   32,  441,   20,  441,  186,  445,  188,  445,
 /*   190 */    12,   13,   14,   15,   16,   97,  101,   20,  100,   63,
 /*   200 */   166,  167,  460,  461,  460,  461,  171,  465,  466,  465,
 /*   210 */   466,  364,  212,  213,  377,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  386,  136,  137,   66,   67,   68,   69,
 /*   240 */    70,  331,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   250 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   260 */    90,   91,   92,  168,  166,  167,   20,  111,    8,    9,
 /*   270 */   172,  173,   12,   13,   14,   15,   16,  100,  168,  339,
 /*   280 */    20,  136,  137,   80,  186,  112,  188,  377,  131,  254,
 /*   290 */   255,  256,  135,    8,    9,  355,   20,   12,   13,   14,
 /*   300 */    15,   16,  362,  130,  131,  132,  133,  134,  135,  345,
 /*   310 */   212,  213,  372,  215,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,   12,   13,  370,  336,  339,  366,  339,  340,
 /*   340 */    20,   97,   22,  396,  141,  142,  100,  400,  377,   64,
 /*   350 */   193,  194,  269,   33,  197,   35,  199,  113,  114,  115,
 /*   360 */   116,  117,  118,  119,  120,  121,  122,  164,  124,  125,
 /*   370 */   126,  127,  128,  129,    0,   58,  430,  431,   58,    0,
 /*   380 */    14,  331,  411,  412,   64,  388,   20,  390,  441,   44,
 /*   390 */   396,   71,  445,  422,  109,   21,  378,  379,   24,   25,
 /*   400 */    26,   27,   28,   29,   30,   31,   32,  460,  461,  345,
 /*   410 */   130,  131,  465,  466,  364,  135,   99,   97,   14,  102,
 /*   420 */   100,   20,  372,   22,   20,  361,  249,  377,  168,  379,
 /*   430 */    12,   13,   14,  100,  370,  441,   35,   14,   20,  445,
 /*   440 */    22,    8,    9,   20,  100,   12,   13,   14,   15,   16,
 /*   450 */   165,   33,   51,   35,  460,  461,  136,  137,  408,  465,
 /*   460 */   466,  343,  412,   58,  343,  415,  416,  417,  418,  419,
 /*   470 */   420,    0,  422,  331,  331,  425,   58,  427,  428,  429,
 /*   480 */   359,  350,  351,  433,  434,  367,  166,  167,  367,   71,
 /*   490 */     0,  112,  172,  173,    0,   24,   25,   26,   27,   28,
 /*   500 */    29,   30,   31,   32,  233,  100,  186,  102,  188,  130,
 /*   510 */   131,  132,  133,  134,  135,   97,   22,   20,  100,  377,
 /*   520 */   377,  236,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   530 */   245,  246,  212,  213,   71,  215,  216,  217,  218,  219,
 /*   540 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   550 */   230,  231,  232,   22,  136,  137,   66,   67,   68,   66,
 /*   560 */    67,   68,   20,  111,   74,   75,   35,   74,   75,   79,
 /*   570 */   166,    4,   79,  364,   84,   85,  366,   84,   85,  331,
 /*   580 */    90,  372,  249,   90,  166,  167,  339,  377,   71,  166,
 /*   590 */   172,  173,   21,  249,    8,    9,    4,  100,   12,   13,
 /*   600 */    14,   15,   16,    2,  186,   34,  188,   36,   20,    8,
 /*   610 */     9,  178,  364,   12,   13,   14,   15,   16,  273,  372,
 /*   620 */   372,  411,  412,  413,  365,  377,  417,  379,   97,  365,
 /*   630 */   212,  213,  422,  215,  216,  217,  218,  219,  220,  221,
 /*   640 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   650 */   232,   12,   13,  100,  249,  364,  408,  339,  130,   20,
 /*   660 */   412,   22,  371,  415,  416,  417,  418,  419,  420,  212,
 /*   670 */   422,  380,   33,  355,   35,  427,   96,  429,  136,  137,
 /*   680 */   372,  433,  434,  436,  437,  438,  439,  101,  441,  442,
 /*   690 */   372,  383,  100,  339,    8,    9,  331,   58,   12,   13,
 /*   700 */    14,   15,   16,  455,   14,   15,   16,  274,  365,  355,
 /*   710 */    71,  339,  331,  365,  172,  173,  259,  260,  261,  262,
 /*   720 */   263,  264,  265,  195,  196,  414,  372,    8,    9,  364,
 /*   730 */    44,   12,   13,   14,   15,   16,   97,  372,  185,  100,
 /*   740 */   187,  441,  377,  441,  379,  445,  249,  445,  168,   12,
 /*   750 */    13,  440,  414,  339,  396,   35,  168,   20,  377,   22,
 /*   760 */   388,  461,  390,  461,  211,  465,  466,  465,  466,  355,
 /*   770 */    33,  356,   35,  408,  339,  136,  137,  412,  440,  364,
 /*   780 */   415,  416,  417,  418,  419,  420,  372,  422,  373,  339,
 /*   790 */   355,   71,  181,  339,  364,   58,  331,  339,  331,  441,
 /*   800 */   339,  371,  249,  445,  331,  166,  167,  372,   71,  355,
 /*   810 */   380,  172,  173,  355,  203,  204,  355,  250,  460,  461,
 /*   820 */   101,  456,  457,  465,  466,  186,  372,  188,  356,    0,
 /*   830 */   372,  364,    0,  372,   97,   22,  364,  100,  388,  372,
 /*   840 */   390,  249,  377,  339,  377,  373,  379,   20,   35,   22,
 /*   850 */   377,  212,  213,  165,  215,  216,  217,  218,  219,  220,
 /*   860 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   870 */   231,  232,   20,  136,  137,  408,  372,  365,   51,  412,
 /*   880 */   331,  331,  415,  416,  417,  418,  419,  420,   18,  422,
 /*   890 */   364,  366,   63,   23,  427,  339,  429,  371,  350,  351,
 /*   900 */   433,  434,  377,  166,  167,  331,  380,   37,   38,  172,
 /*   910 */   173,   41,  425,    8,    9,  428,   39,   12,   13,   14,
 /*   920 */    15,   16,  414,  186,  236,  188,  377,  377,  372,   59,
 /*   930 */    60,   61,   62,  331,  246,  331,  411,  412,  413,   45,
 /*   940 */    46,  437,  438,  439,  331,  441,  442,  422,  440,  212,
 /*   950 */   213,  377,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   960 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*   970 */   100,   18,  339,   20,  331,  247,  248,  364,  331,  377,
 /*   980 */    27,  377,  365,   30,  339,  372,   33,  155,  355,  332,
 /*   990 */   377,  331,  379,  437,  438,  439,  164,  441,  442,  331,
 /*  1000 */   355,   48,  233,   50,  235,  372,   53,  364,  138,  353,
 /*  1010 */   339,  339,  369,    1,    2,  372,    0,  372,  166,   44,
 /*  1020 */   377,  408,  379,  339,  377,  412,  355,  355,  415,  416,
 /*  1030 */   417,  418,  419,  420,  426,  422,  428,  377,  339,  355,
 /*  1040 */   427,  331,  429,  372,  372,  377,  433,  434,  178,  179,
 /*  1050 */   180,  408,   99,  183,  355,  412,  372,  444,  415,  416,
 /*  1060 */   417,  418,  419,  420,  111,  422,  426,  331,  428,   22,
 /*  1070 */    20,  372,  202,  168,  331,  205,  101,  207,  208,  209,
 /*  1080 */   210,  211,   35,  372,  372,  331,  360,  377,  401,  331,
 /*  1090 */   352,  396,  354,  140,  383,  383,  143,  144,  145,  146,
 /*  1100 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  156,
 /*  1110 */   157,  158,  159,  377,  161,  162,  163,   64,   71,  249,
 /*  1120 */   377,  387,  364,  364,  364,  248,  339,   35,  112,  339,
 /*  1130 */   372,  377,  406,  373,    0,  377,  441,  379,  331,  380,
 /*  1140 */   445,   37,  355,  112,   97,  355,  130,  131,  132,  133,
 /*  1150 */   134,  135,  111,   35,  374,  460,  461,  377,  469,  372,
 /*  1160 */   465,  466,  372,  458,  133,  339,  408,  339,   44,  374,
 /*  1170 */   412,  364,  377,  415,  416,  417,  418,  419,  420,  372,
 /*  1180 */   422,  355,   48,  355,  377,  427,  379,  429,    0,   71,
 /*  1190 */   374,  433,  434,  377,  341,  339,  357,  331,  372,  360,
 /*  1200 */   372,  160,  444,   42,   42,   44,   44,  103,   35,  105,
 /*  1210 */   106,  355,  108,   58,  104,  408,  112,  107,  168,  412,
 /*  1220 */   331,  100,  415,  416,  417,  418,  419,  420,  372,  422,
 /*  1230 */   364,  110,   44,  186,  427,  188,  429,  133,  372,  104,
 /*  1240 */   433,  434,  107,  377,  104,  379,  104,  107,    0,  107,
 /*  1250 */     0,  444,  198,  364,  200,   44,   44,  102,  452,  212,
 /*  1260 */   213,  372,   44,   44,   44,  212,  377,   13,  379,   44,
 /*  1270 */    22,   44,   22,   44,  408,  136,  137,   44,  412,   44,
 /*  1280 */   188,  415,  416,  417,  418,  419,  420,   47,  422,   35,
 /*  1290 */    44,  364,  341,  427,  387,  429,  338,  408,  331,  433,
 /*  1300 */   434,  412,   44,   13,  415,  416,  417,  418,  419,  420,
 /*  1310 */   444,  422,  101,  101,   12,   13,  427,   44,  429,  101,
 /*  1320 */   101,  101,  433,  434,   22,   35,  101,    0,  101,  387,
 /*  1330 */   101,  364,  376,  444,  101,   33,  101,   35,  443,  372,
 /*  1340 */   100,  462,  446,   33,  377,   44,  379,  101,    8,    9,
 /*  1350 */    44,   44,   12,   13,   14,   15,   16,  331,   48,  101,
 /*  1360 */    58,  188,   44,   44,   54,   55,   56,   57,   58,  435,
 /*  1370 */   251,  410,   48,   71,  101,  408,   49,  409,   44,  412,
 /*  1380 */   331,  184,  415,  416,  417,  418,  419,  420,  398,  422,
 /*  1390 */   364,   42,  384,   20,  427,  271,  429,  387,  372,   97,
 /*  1400 */   433,  434,  101,  377,  384,  379,  165,  101,  101,   99,
 /*  1410 */   382,   20,  102,  364,  339,  339,  384,  382,  382,  101,
 /*  1420 */   101,  372,  349,   98,   95,  348,  377,  339,  379,   94,
 /*  1430 */   347,   20,  339,  339,  408,  101,  339,   20,  412,  333,
 /*  1440 */   333,  415,  416,  417,  418,  419,  420,  403,  422,   20,
 /*  1450 */   345,  379,   20,  427,  345,  429,  340,  408,   20,  433,
 /*  1460 */   434,  412,  331,  397,  415,  416,  417,  418,  419,  420,
 /*  1470 */   345,  422,  340,  345,  345,  345,  339,   52,  429,  169,
 /*  1480 */   170,  345,  433,  434,  174,  342,  176,  342,  186,  333,
 /*  1490 */   188,  364,  377,  201,  377,  364,  333,  364,  407,  339,
 /*  1500 */   377,  100,  192,  372,  405,  364,  403,  343,  377,  343,
 /*  1510 */   379,  331,  364,  364,  212,  213,  364,  364,  364,  191,
 /*  1520 */   339,  364,  364,  364,  402,  379,  258,  225,  226,  227,
 /*  1530 */   228,  229,  230,  231,  331,  451,  257,  387,  387,  408,
 /*  1540 */   451,  454,  377,  412,  364,  377,  415,  416,  417,  418,
 /*  1550 */   419,  420,  372,  422,  377,  377,  177,  377,  450,  379,
 /*  1560 */   429,  392,  392,  266,  433,  434,  453,  364,  268,  252,
 /*  1570 */   267,  451,  470,  372,  448,  372,  464,  410,  270,  275,
 /*  1580 */   377,  272,  379,   20,  248,  414,  339,  449,  408,  340,
 /*  1590 */    20,  392,  412,  377,  343,  415,  416,  417,  418,  419,
 /*  1600 */   420,  377,  422,  343,  390,  377,  331,  463,  377,  429,
 /*  1610 */   170,  408,  389,  433,  434,  412,  377,  343,  415,  416,
 /*  1620 */   417,  418,  419,  420,  421,  422,  423,  424,  392,  331,
 /*  1630 */   377,  360,  343,  372,  100,  100,  432,  368,  354,  364,
 /*  1640 */   377,   36,  343,   19,  339,  334,  333,  372,  404,  393,
 /*  1650 */   393,  399,  377,  358,  379,  329,  344,   33,    0,    0,
 /*  1660 */     0,   42,  364,  331,    0,   35,  206,   35,   35,   35,
 /*  1670 */   372,  206,   48,  358,  358,  377,   35,  379,   54,   55,
 /*  1680 */    56,   57,   58,  408,    0,   35,  206,  412,    0,  331,
 /*  1690 */   415,  416,  417,  418,  419,  420,  364,  422,  206,    0,
 /*  1700 */    35,    0,   22,    0,  372,   35,  408,  193,  188,  377,
 /*  1710 */   412,  379,  186,  415,  416,  417,  418,  419,  420,    0,
 /*  1720 */   422,    0,  364,   99,    0,  182,  102,  429,  181,    0,
 /*  1730 */   372,    0,  434,   47,    0,  377,    0,  379,    0,   42,
 /*  1740 */   408,    0,  467,  468,  412,    0,    0,  415,  416,  417,
 /*  1750 */   418,  419,  420,  331,  422,    0,    0,    0,  134,  155,
 /*  1760 */    35,    0,  155,    0,    0,    0,  408,    0,    0,    0,
 /*  1770 */   412,    0,    0,  415,  416,  417,  418,  419,  420,    0,
 /*  1780 */   422,    0,    0,    0,    0,  331,  364,    0,    0,  457,
 /*  1790 */     0,    0,    0,  169,  372,   42,    0,    0,  174,  377,
 /*  1800 */     0,  379,    0,    0,    0,    0,    0,   22,    0,    0,
 /*  1810 */   331,  139,    0,   96,  190,   22,  192,  459,  364,   96,
 /*  1820 */    22,    0,    0,    0,   58,    0,  372,    0,   58,   35,
 /*  1830 */   408,  377,   58,  379,  412,    0,   47,  415,  416,  417,
 /*  1840 */   418,  419,  420,  364,  422,   44,   47,   14,  369,   42,
 /*  1850 */    39,  372,   14,   40,   39,    0,  377,   47,  379,  331,
 /*  1860 */     0,    0,  408,   39,  177,    0,  412,    0,    0,  415,
 /*  1870 */   416,  417,  418,  419,  420,  331,  422,    0,  424,   65,
 /*  1880 */     0,   35,   48,   39,    0,   35,   39,  408,   48,    0,
 /*  1890 */   468,  412,  364,   35,  415,  416,  417,  418,  419,  420,
 /*  1900 */   372,  422,   48,   39,    0,  377,   35,  379,  364,   39,
 /*  1910 */    48,    0,    0,  369,   35,   22,  372,    0,    0,    0,
 /*  1920 */    35,  377,   35,  379,  331,  109,  107,   35,   22,   35,
 /*  1930 */    44,   35,   44,    0,   35,   35,  408,   22,    0,    0,
 /*  1940 */   412,  331,   22,  415,  416,  417,  418,  419,  420,   22,
 /*  1950 */   422,   50,  408,    0,    0,    0,  412,  364,  331,  415,
 /*  1960 */   416,  417,  418,  419,  420,  372,  422,   35,   22,   35,
 /*  1970 */   377,   35,  379,  101,  364,   35,   20,   35,   35,    0,
 /*  1980 */    35,  100,  372,  100,    0,  168,   22,  377,  168,  379,
 /*  1990 */     0,  364,    0,  175,    3,   44,  170,  168,  101,  372,
 /*  2000 */   253,  408,  100,  100,  377,  412,  379,  331,  415,  416,
 /*  2010 */   417,  418,  419,  420,   98,  422,   95,  189,  408,   96,
 /*  2020 */    96,   44,  412,  331,   44,  415,  416,  417,  418,  419,
 /*  2030 */   420,  101,  422,   44,   47,  408,  101,  100,   44,  412,
 /*  2040 */   364,  331,  415,  416,  417,  418,  419,  420,  372,  422,
 /*  2050 */   100,   47,  100,  377,    3,  379,  364,   44,  101,  100,
 /*  2060 */    35,  101,  101,   35,  372,   35,   35,   35,   35,  377,
 /*  2070 */   101,  379,  101,   47,  364,    0,   47,    0,  247,   44,
 /*  2080 */     0,    0,  372,  253,  408,  100,   39,  377,  412,  379,
 /*  2090 */   331,  415,  416,  417,  418,  419,  420,   47,  422,  100,
 /*  2100 */   408,  253,  101,  101,  412,  100,  331,  415,  416,  417,
 /*  2110 */   418,  419,  420,    0,  422,  100,  100,   39,  408,  171,
 /*  2120 */   100,  110,  412,  364,  234,  415,  416,  417,  418,  419,
 /*  2130 */   420,  372,  422,   47,  169,   44,  377,   98,  379,  364,
 /*  2140 */    98,    2,   22,  212,  100,   47,  101,  372,  100,   47,
 /*  2150 */   101,   22,  377,  100,  379,  101,  100,  100,  214,  101,
 /*  2160 */   100,   35,  101,  331,  100,   35,  111,  408,  101,   35,
 /*  2170 */   100,  412,  101,   35,  415,  416,  417,  418,  419,  420,
 /*  2180 */   331,  422,  100,  408,   35,  101,  101,  412,  100,   35,
 /*  2190 */   415,  416,  417,  418,  419,  420,  364,  422,   22,  100,
 /*  2200 */   100,   44,  123,  100,  372,  112,   35,  100,   22,  377,
 /*  2210 */   123,  379,  123,  364,   64,  123,   65,   35,   35,   35,
 /*  2220 */    35,  372,   35,   35,   35,   35,  377,   35,  379,  331,
 /*  2230 */    35,   71,   22,   93,   35,   44,   35,   35,   35,   35,
 /*  2240 */   408,   35,   35,   71,  412,  331,   35,  415,  416,  417,
 /*  2250 */   418,  419,  420,   35,  422,   35,   35,  408,   22,   35,
 /*  2260 */     0,  412,  364,   35,  415,  416,  417,  418,  419,  420,
 /*  2270 */   372,  422,   39,   48,    0,  377,   35,  379,  364,   48,
 /*  2280 */     0,   39,   35,   48,   39,    0,  372,   35,   48,   39,
 /*  2290 */     0,  377,   35,  379,  331,    0,   35,   22,   21,  471,
 /*  2300 */    22,   22,   21,   20,  471,  471,  408,  471,  471,  471,
 /*  2310 */   412,  471,  471,  415,  416,  417,  418,  419,  420,  331,
 /*  2320 */   422,  471,  408,  471,  471,  471,  412,  364,  471,  415,
 /*  2330 */   416,  417,  418,  419,  420,  372,  422,  471,  471,  471,
 /*  2340 */   377,  471,  379,  331,  471,  471,  471,  471,  471,  471,
 /*  2350 */   471,  471,  364,  471,  471,  471,  471,  471,  471,  471,
 /*  2360 */   372,  471,  471,  471,  471,  377,  471,  379,  471,  471,
 /*  2370 */   471,  408,  471,  471,  471,  412,  364,  471,  415,  416,
 /*  2380 */   417,  418,  419,  420,  372,  422,  471,  471,  471,  377,
 /*  2390 */   471,  379,  471,  471,  471,  471,  408,  471,  471,  471,
 /*  2400 */   412,  471,  471,  415,  416,  417,  418,  419,  420,  471,
 /*  2410 */   422,  471,  471,  471,  331,  471,  471,  471,  471,  471,
 /*  2420 */   408,  471,  471,  471,  412,  471,  471,  415,  416,  417,
 /*  2430 */   418,  419,  420,  471,  422,  471,  331,  471,  471,  471,
 /*  2440 */   471,  471,  471,  471,  471,  471,  471,  364,  471,  471,
 /*  2450 */   471,  471,  471,  471,  471,  372,  471,  471,  471,  471,
 /*  2460 */   377,  471,  379,  331,  471,  471,  471,  471,  471,  364,
 /*  2470 */   471,  471,  471,  471,  471,  471,  471,  372,  471,  471,
 /*  2480 */   471,  471,  377,  471,  379,  471,  471,  471,  471,  471,
 /*  2490 */   471,  408,  471,  471,  471,  412,  364,  471,  415,  416,
 /*  2500 */   417,  418,  419,  420,  372,  422,  471,  471,  471,  377,
 /*  2510 */   471,  379,  331,  408,  471,  471,  471,  412,  471,  471,
 /*  2520 */   415,  416,  417,  418,  419,  420,  471,  422,  331,  471,
 /*  2530 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2540 */   408,  471,  471,  471,  412,  364,  471,  415,  416,  417,
 /*  2550 */   418,  419,  420,  372,  422,  471,  471,  471,  377,  471,
 /*  2560 */   379,  364,  471,  471,  471,  471,  471,  471,  471,  372,
 /*  2570 */   471,  471,  471,  471,  377,  471,  379,  331,  471,  471,
 /*  2580 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  408,
 /*  2590 */   471,  471,  471,  412,  471,  471,  415,  416,  417,  418,
 /*  2600 */   419,  420,  471,  422,  471,  408,  471,  471,  471,  412,
 /*  2610 */   364,  471,  415,  416,  417,  418,  419,  420,  372,  422,
 /*  2620 */   471,  471,  471,  377,  471,  379,  471,  471,  471,  471,
 /*  2630 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2640 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2650 */   471,  471,  471,  471,  408,  471,  471,  471,  412,  471,
 /*  2660 */   471,  415,  416,  417,  418,  419,  420,  471,  422,
};
#define YY_SHIFT_COUNT    (750)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2295)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   870,    0,   98,    0,  320,  320,  320,  320,  320,  320,
 /*    10 */   320,  320,  320,  320,  320,  418,  639,  639,  737,  639,
 /*    20 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    30 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    40 */   639,  639,  639,  639,  639,  639,  639,  639,  177,  497,
 /*    50 */   553,  246,  405,  333,  344,  333,  246,  246, 1302, 1302,
 /*    60 */  1302,  333, 1302, 1302,  592,  333,   39,  542,   73,   73,
 /*    70 */   542,    7,    7,   34,  145,  366,  366,   73,   73,   73,
 /*    80 */    73,   73,   73,   73,   93,   73,   73,   65,   39,   73,
 /*    90 */    73,  164,   73,   39,   73,   93,   73,   93,   39,   73,
 /*   100 */    73,   39,   73,   39,   39,   39,   73,  136,  953,  285,
 /*   110 */   285,  150,  493, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
 /*   120 */  1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
 /*   130 */  1047, 1047, 1104,   95,   34,  145,  720,  110,  110,  110,
 /*   140 */   829,  769,  769,  720,  276,  276,  276,   65,  156,  271,
 /*   150 */    39,  463,   39,  463,  463,  452,  517,  244,  244,  244,
 /*   160 */   244,  244,  244,  244,  244, 1624,  374,  490,  260,  433,
 /*   170 */   457,  401,   35,  404,  423,  827,  588,  894, 1031, 1050,
 /*   180 */   728,  877,   83,  728, 1161,  567,  852, 1119, 1324, 1197,
 /*   190 */  1349, 1373, 1349, 1241, 1391, 1391, 1349, 1241, 1241, 1325,
 /*   200 */  1329, 1391, 1335, 1391, 1391, 1391, 1411, 1411, 1417,   65,
 /*   210 */  1429,   65, 1432, 1438,   65, 1432,   65,   65,   65, 1391,
 /*   220 */    65, 1425, 1425, 1411,   39,   39,   39,   39,   39,   39,
 /*   230 */    39,   39,   39,   39,   39, 1391, 1411,  463,  463,  463,
 /*   240 */  1292, 1401, 1417,  136, 1328, 1429,  136, 1391, 1373, 1373,
 /*   250 */   463, 1268, 1279,  463, 1268, 1279,  463,  463,   39, 1297,
 /*   260 */  1379, 1268, 1300, 1303, 1317, 1119, 1304, 1309, 1308, 1336,
 /*   270 */   276, 1563, 1391, 1432,  136,  136, 1570, 1279,  463,  463,
 /*   280 */   463,  463,  463, 1279,  463, 1440,  136,  452,  136,  276,
 /*   290 */  1534, 1535,  463,  517, 1391,  136, 1605, 1411, 2669, 2669,
 /*   300 */  2669, 2669, 2669, 2669, 2669, 2669, 2669,  170, 1310,  471,
 /*   310 */    15,  586,  686,  719,  379,  139,  601,  905, 1016, 1340,
 /*   320 */  1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340,  173,  157,
 /*   330 */   178,  178,  203,  611,  832,  317,    6,  531,  571,  528,
 /*   340 */   280,  280,  690,   45,  688,  690,  690,  690, 1134,  975,
 /*   350 */   813, 1162, 1041, 1188, 1110, 1135, 1140, 1142,  494, 1248,
 /*   360 */  1250, 1054, 1211, 1212, 1155, 1218, 1219, 1220, 1139, 1124,
 /*   370 */   345,  580, 1225, 1227, 1229, 1233, 1235, 1246, 1012, 1258,
 /*   380 */  1092, 1173, 1053, 1273, 1240, 1301, 1306, 1307, 1318, 1319,
 /*   390 */  1334, 1121, 1254, 1290, 1118, 1327, 1658, 1659, 1660, 1619,
 /*   400 */  1664, 1630, 1460, 1632, 1633, 1634, 1465, 1684, 1641, 1650,
 /*   410 */  1480, 1688, 1492, 1699, 1665, 1701, 1680, 1703, 1670, 1514,
 /*   420 */  1520, 1526, 1719, 1721, 1724, 1543, 1547, 1729, 1731, 1686,
 /*   430 */  1734, 1736, 1738, 1697, 1741, 1745, 1746, 1755, 1756, 1757,
 /*   440 */  1767, 1768, 1604, 1725, 1761, 1607, 1763, 1764, 1765, 1769,
 /*   450 */  1771, 1772, 1779, 1781, 1782, 1783, 1784, 1787, 1788, 1790,
 /*   460 */  1791, 1792, 1753, 1796, 1797, 1800, 1802, 1803, 1804, 1785,
 /*   470 */  1805, 1806, 1808, 1672, 1809, 1812, 1793, 1717, 1798, 1723,
 /*   480 */  1821, 1766, 1794, 1822, 1770, 1823, 1774, 1825, 1827, 1807,
 /*   490 */  1811, 1801, 1789, 1833, 1799, 1838, 1810, 1835, 1813, 1815,
 /*   500 */  1855, 1860, 1861, 1824, 1687, 1865, 1867, 1868, 1814, 1877,
 /*   510 */  1880, 1846, 1834, 1844, 1884, 1850, 1840, 1847, 1889, 1858,
 /*   520 */  1854, 1864, 1904, 1871, 1862, 1870, 1911, 1912, 1917, 1918,
 /*   530 */  1816, 1819, 1879, 1893, 1919, 1885, 1887, 1892, 1894, 1886,
 /*   540 */  1888, 1896, 1899, 1906, 1900, 1933, 1915, 1938, 1920, 1901,
 /*   550 */  1939, 1927, 1932, 1953, 1934, 1954, 1936, 1955, 1946, 1956,
 /*   560 */  1940, 1942, 1943, 1872, 1881, 1979, 1817, 1883, 1945, 1984,
 /*   570 */  1828, 1964, 1820, 1826, 1990, 1992, 1829, 1818, 1991, 1951,
 /*   580 */  1747, 1902, 1897, 1903, 1923, 1916, 1924, 1921, 1930, 1977,
 /*   590 */  1980, 1935, 1937, 1950, 1952, 1957, 1989, 1987, 2004, 1959,
 /*   600 */  1994, 1830, 1960, 1961, 2051, 2013, 1848, 2025, 2028, 2030,
 /*   610 */  2031, 2032, 2033, 1969, 1971, 2026, 1831, 2035, 2029, 2075,
 /*   620 */  2077, 2080, 2081, 1985, 2047, 1789, 2050, 1999, 2001, 2002,
 /*   630 */  2005, 2015, 1948, 2016, 2113, 2078, 1965, 2020, 2011, 1789,
 /*   640 */  2086, 2091, 2039, 1890, 2042, 2139, 2120, 1931, 2044, 2045,
 /*   650 */  2048, 2049, 2053, 2054, 2098, 2056, 2057, 2102, 2058, 2129,
 /*   660 */  1944, 2060, 2055, 2061, 2126, 2130, 2064, 2067, 2134, 2070,
 /*   670 */  2071, 2138, 2082, 2084, 2149, 2088, 2085, 2154, 2099, 2079,
 /*   680 */  2087, 2089, 2092, 2176, 2093, 2100, 2157, 2103, 2171, 2107,
 /*   690 */  2157, 2157, 2186, 2151, 2150, 2182, 2183, 2184, 2185, 2187,
 /*   700 */  2188, 2189, 2190, 2192, 2195, 2160, 2140, 2191, 2199, 2201,
 /*   710 */  2202, 2210, 2203, 2204, 2206, 2172, 1886, 2207, 1888, 2211,
 /*   720 */  2218, 2220, 2221, 2236, 2224, 2260, 2228, 2225, 2233, 2274,
 /*   730 */  2241, 2231, 2242, 2280, 2247, 2235, 2245, 2285, 2252, 2240,
 /*   740 */  2250, 2290, 2257, 2261, 2295, 2275, 2277, 2278, 2279, 2281,
 /*   750 */  2283,
};
#define YY_REDUCE_COUNT (306)
#define YY_REDUCE_MIN   (-435)
#define YY_REDUCE_MAX   (2246)
static const short yy_reduce_ofst[] = {
 /*     0 */  -258, -328,   50,  248,  613,  758,  807,  866,  889,  467,
 /*    10 */   967, 1026, 1049, 1131, 1180, 1203,  365, 1275, 1298, 1332,
 /*    20 */  1358, 1422,  643, 1454, 1479, 1544, 1528, 1593, 1610, 1627,
 /*    30 */  1676, 1692, 1710, 1759, 1775, 1832, 1849, 1898, 1914, 1963,
 /*    40 */  1988, 2012, 2083, 2105, 2132, 2181, 2197, 2246, -316, -302,
 /*    50 */   -53,  247, -256,   -6,  358,  695,  504,  556, -337,  210,
 /*    60 */   525, -435, -345,  -29,  300,  302, -356, -352, -260,  -60,
 /*    70 */  -334, -333, -203, -348, -271, -179,   -1,  318,  354,  414,
 /*    80 */   454,  458,  461,  633,   -3,  645,  671,   64, -299,  435,
 /*    90 */   684,  209,  699,  291,  672,  372,  787,  450, -355,  790,
 /*   100 */   826,  430,  828,  415,  526,  472,  856,  121, -257,  -54,
 /*   110 */   -54, -275, -237, -163,  -90,  142,  143,  381,  465,  473,
 /*   120 */   549,  550,  574,  602,  604,  647,  660,  668,  710,  736,
 /*   130 */   743,  754, -280,  311, -153,   18,  548,  311,  338,  508,
 /*   140 */   118,  608,  640,  131,  308,  711,  712,  -36,  726,  487,
 /*   150 */   760,  780,  759,  795,  816,  839,  738, -358,  259,  264,
 /*   160 */   343,  348,  512,  617,  348,  687,  657,  656,  734,  689,
 /*   170 */   705,  853,  806,  927,  927,  951,  907,  958,  956,  942,
 /*   180 */   895,  895,  879,  895,  934,  896,  927,  961,  968,  990,
 /*   190 */  1008, 1010, 1020, 1028, 1075, 1076, 1032, 1035, 1036, 1073,
 /*   200 */  1077, 1088, 1083, 1093, 1094, 1097, 1106, 1107, 1044, 1105,
 /*   210 */  1072, 1109, 1116, 1066, 1125, 1132, 1128, 1129, 1130, 1137,
 /*   220 */  1136, 1143, 1145, 1156, 1127, 1133, 1141, 1148, 1149, 1152,
 /*   230 */  1153, 1154, 1157, 1158, 1159, 1160, 1163, 1115, 1117, 1123,
 /*   240 */  1091, 1099, 1103, 1164, 1122, 1146, 1166, 1181, 1150, 1151,
 /*   250 */  1165, 1084, 1169, 1168, 1089, 1170, 1177, 1178,  927, 1087,
 /*   260 */  1113, 1120, 1108, 1138, 1126, 1167, 1102, 1112, 1144,  895,
 /*   270 */  1201, 1171, 1247, 1249, 1251, 1260, 1214, 1199, 1216, 1224,
 /*   280 */  1228, 1231, 1239, 1236, 1253, 1223, 1274, 1271, 1289, 1261,
 /*   290 */  1204, 1269, 1263, 1284, 1305, 1299, 1311, 1313, 1252, 1244,
 /*   300 */  1256, 1257, 1295, 1315, 1316, 1312, 1326,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    10 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    20 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    30 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    40 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    50 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    60 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    70 */  1687, 1687, 1687, 1953, 1687, 1687, 1687, 1687, 1687, 1687,
 /*    80 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1766, 1687, 1687,
 /*    90 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   100 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1764, 1946, 2162,
 /*   110 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   120 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   130 */  1687, 1687, 1687, 2174, 1687, 1687, 1687, 2174, 2174, 2174,
 /*   140 */  1764, 2134, 2134, 1687, 1687, 1687, 1687, 1766, 2007, 1687,
 /*   150 */  1687, 1687, 1687, 1687, 1687, 1881, 1687, 1687, 1687, 1687,
 /*   160 */  1687, 1905, 1687, 1687, 1687, 1999, 1687, 1687, 2199, 2255,
 /*   170 */  1687, 1687, 2202, 1687, 1687, 1687, 1958, 1687, 1834, 2189,
 /*   180 */  2166, 2180, 2239, 2167, 2164, 2183, 1687, 2193, 1687, 1992,
 /*   190 */  1951, 1687, 1951, 1948, 1687, 1687, 1951, 1948, 1948, 1823,
 /*   200 */  1819, 1687, 1817, 1687, 1687, 1687, 1687, 1687, 1687, 1766,
 /*   210 */  1687, 1766, 1687, 1687, 1766, 1687, 1766, 1766, 1766, 1687,
 /*   220 */  1766, 1744, 1744, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   230 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   240 */  2019, 2005, 1687, 1764, 2001, 1687, 1764, 1687, 1687, 1687,
 /*   250 */  1687, 2210, 2208, 1687, 2210, 2208, 1687, 1687, 1687, 2224,
 /*   260 */  2220, 2210, 2228, 2226, 2195, 2193, 2258, 2245, 2241, 2180,
 /*   270 */  1687, 1687, 1687, 1687, 1764, 1764, 1687, 2208, 1687, 1687,
 /*   280 */  1687, 1687, 1687, 2208, 1687, 1687, 1764, 1687, 1764, 1687,
 /*   290 */  1687, 1850, 1687, 1687, 1687, 1764, 1719, 1687, 1994, 2010,
 /*   300 */  1976, 1976, 1884, 1884, 1884, 1767, 1692, 1687, 1687, 1687,
 /*   310 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2223,
 /*   320 */  2222, 2089, 1687, 2138, 2137, 2136, 2127, 2088, 1846, 1687,
 /*   330 */  2087, 2086, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   340 */  1967, 1966, 2080, 1687, 1687, 2081, 2079, 2078, 1687, 1687,
 /*   350 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   360 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2242,
 /*   370 */  2246, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2163, 1687,
 /*   380 */  1687, 1687, 1687, 1687, 2062, 1687, 1687, 1687, 1687, 1687,
 /*   390 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   400 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   410 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   420 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   430 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   440 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   450 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   460 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   470 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   480 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   490 */  1687, 1724, 2067, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   500 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   510 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   520 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   530 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1805,
 /*   540 */  1804, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   550 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   560 */  1687, 1687, 1687, 2071, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   570 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2238, 2196,
 /*   580 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   590 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2062, 1687,
 /*   600 */  2221, 1687, 1687, 2236, 1687, 2240, 1687, 1687, 1687, 1687,
 /*   610 */  1687, 1687, 1687, 2173, 2169, 1687, 1687, 2165, 1687, 1687,
 /*   620 */  1687, 1687, 1687, 1687, 1687, 2070, 1687, 1687, 1687, 1687,
 /*   630 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2061,
 /*   640 */  1687, 2124, 1687, 1687, 1687, 2158, 1687, 1687, 2109, 1687,
 /*   650 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 2071, 1687,
 /*   660 */  2074, 1687, 1687, 1687, 1687, 1687, 1878, 1687, 1687, 1687,
 /*   670 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1863,
 /*   680 */  1861, 1860, 1859, 1687, 1856, 1687, 1891, 1687, 1687, 1687,
 /*   690 */  1887, 1886, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   700 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1785, 1687, 1687,
 /*   710 */  1687, 1687, 1687, 1687, 1687, 1687, 1777, 1687, 1776, 1687,
 /*   720 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   730 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   740 */  1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687, 1687,
 /*   750 */  1687,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  276,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  276,  /*      AFTER => ABORT */
  276,  /*     ATTACH => ABORT */
  276,  /*     BEFORE => ABORT */
  276,  /*      BEGIN => ABORT */
  276,  /*     BITAND => ABORT */
  276,  /*     BITNOT => ABORT */
  276,  /*      BITOR => ABORT */
  276,  /*     BLOCKS => ABORT */
  276,  /*     CHANGE => ABORT */
  276,  /*      COMMA => ABORT */
  276,  /*     CONCAT => ABORT */
  276,  /*   CONFLICT => ABORT */
  276,  /*       COPY => ABORT */
  276,  /*   DEFERRED => ABORT */
  276,  /* DELIMITERS => ABORT */
  276,  /*     DETACH => ABORT */
  276,  /*     DIVIDE => ABORT */
  276,  /*        DOT => ABORT */
  276,  /*       EACH => ABORT */
  276,  /*       FAIL => ABORT */
  276,  /*       FILE => ABORT */
  276,  /*        FOR => ABORT */
  276,  /*       GLOB => ABORT */
  276,  /*         ID => ABORT */
  276,  /*  IMMEDIATE => ABORT */
  276,  /*     IMPORT => ABORT */
  276,  /*  INITIALLY => ABORT */
  276,  /*    INSTEAD => ABORT */
  276,  /*     ISNULL => ABORT */
  276,  /*        KEY => ABORT */
  276,  /*    MODULES => ABORT */
  276,  /*  NK_BITNOT => ABORT */
  276,  /*    NK_SEMI => ABORT */
  276,  /*    NOTNULL => ABORT */
  276,  /*         OF => ABORT */
  276,  /*       PLUS => ABORT */
  276,  /*  PRIVILEGE => ABORT */
  276,  /*      RAISE => ABORT */
  276,  /*    REPLACE => ABORT */
  276,  /*   RESTRICT => ABORT */
  276,  /*        ROW => ABORT */
  276,  /*       SEMI => ABORT */
  276,  /*       STAR => ABORT */
  276,  /*  STATEMENT => ABORT */
  276,  /*     STRICT => ABORT */
  276,  /*     STRING => ABORT */
  276,  /*      TIMES => ABORT */
  276,  /*     VALUES => ABORT */
  276,  /*   VARIABLE => ABORT */
  276,  /*       VIEW => ABORT */
  276,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "STREAM",
  /*  193 */ "INTO",
  /*  194 */ "TRIGGER",
  /*  195 */ "AT_ONCE",
  /*  196 */ "WINDOW_CLOSE",
  /*  197 */ "IGNORE",
  /*  198 */ "EXPIRED",
  /*  199 */ "FILL_HISTORY",
  /*  200 */ "UPDATE",
  /*  201 */ "SUBTABLE",
  /*  202 */ "KILL",
  /*  203 */ "CONNECTION",
  /*  204 */ "TRANSACTION",
  /*  205 */ "BALANCE",
  /*  206 */ "VGROUP",
  /*  207 */ "MERGE",
  /*  208 */ "REDISTRIBUTE",
  /*  209 */ "SPLIT",
  /*  210 */ "DELETE",
  /*  211 */ "INSERT",
  /*  212 */ "NULL",
  /*  213 */ "NK_QUESTION",
  /*  214 */ "NK_ARROW",
  /*  215 */ "ROWTS",
  /*  216 */ "QSTART",
  /*  217 */ "QEND",
  /*  218 */ "QDURATION",
  /*  219 */ "WSTART",
  /*  220 */ "WEND",
  /*  221 */ "WDURATION",
  /*  222 */ "IROWTS",
  /*  223 */ "ISFILLED",
  /*  224 */ "CAST",
  /*  225 */ "NOW",
  /*  226 */ "TODAY",
  /*  227 */ "TIMEZONE",
  /*  228 */ "CLIENT_VERSION",
  /*  229 */ "SERVER_VERSION",
  /*  230 */ "SERVER_STATUS",
  /*  231 */ "CURRENT_USER",
  /*  232 */ "CASE",
  /*  233 */ "WHEN",
  /*  234 */ "THEN",
  /*  235 */ "ELSE",
  /*  236 */ "BETWEEN",
  /*  237 */ "IS",
  /*  238 */ "NK_LT",
  /*  239 */ "NK_GT",
  /*  240 */ "NK_LE",
  /*  241 */ "NK_GE",
  /*  242 */ "NK_NE",
  /*  243 */ "MATCH",
  /*  244 */ "NMATCH",
  /*  245 */ "CONTAINS",
  /*  246 */ "IN",
  /*  247 */ "JOIN",
  /*  248 */ "INNER",
  /*  249 */ "SELECT",
  /*  250 */ "DISTINCT",
  /*  251 */ "WHERE",
  /*  252 */ "PARTITION",
  /*  253 */ "BY",
  /*  254 */ "SESSION",
  /*  255 */ "STATE_WINDOW",
  /*  256 */ "EVENT_WINDOW",
  /*  257 */ "SLIDING",
  /*  258 */ "FILL",
  /*  259 */ "VALUE",
  /*  260 */ "VALUE_F",
  /*  261 */ "NONE",
  /*  262 */ "PREV",
  /*  263 */ "NULL_F",
  /*  264 */ "LINEAR",
  /*  265 */ "NEXT",
  /*  266 */ "HAVING",
  /*  267 */ "RANGE",
  /*  268 */ "EVERY",
  /*  269 */ "ORDER",
  /*  270 */ "SLIMIT",
  /*  271 */ "SOFFSET",
  /*  272 */ "LIMIT",
  /*  273 */ "OFFSET",
  /*  274 */ "ASC",
  /*  275 */ "NULLS",
  /*  276 */ "ABORT",
  /*  277 */ "AFTER",
  /*  278 */ "ATTACH",
  /*  279 */ "BEFORE",
  /*  280 */ "BEGIN",
  /*  281 */ "BITAND",
  /*  282 */ "BITNOT",
  /*  283 */ "BITOR",
  /*  284 */ "BLOCKS",
  /*  285 */ "CHANGE",
  /*  286 */ "COMMA",
  /*  287 */ "CONCAT",
  /*  288 */ "CONFLICT",
  /*  289 */ "COPY",
  /*  290 */ "DEFERRED",
  /*  291 */ "DELIMITERS",
  /*  292 */ "DETACH",
  /*  293 */ "DIVIDE",
  /*  294 */ "DOT",
  /*  295 */ "EACH",
  /*  296 */ "FAIL",
  /*  297 */ "FILE",
  /*  298 */ "FOR",
  /*  299 */ "GLOB",
  /*  300 */ "ID",
  /*  301 */ "IMMEDIATE",
  /*  302 */ "IMPORT",
  /*  303 */ "INITIALLY",
  /*  304 */ "INSTEAD",
  /*  305 */ "ISNULL",
  /*  306 */ "KEY",
  /*  307 */ "MODULES",
  /*  308 */ "NK_BITNOT",
  /*  309 */ "NK_SEMI",
  /*  310 */ "NOTNULL",
  /*  311 */ "OF",
  /*  312 */ "PLUS",
  /*  313 */ "PRIVILEGE",
  /*  314 */ "RAISE",
  /*  315 */ "REPLACE",
  /*  316 */ "RESTRICT",
  /*  317 */ "ROW",
  /*  318 */ "SEMI",
  /*  319 */ "STAR",
  /*  320 */ "STATEMENT",
  /*  321 */ "STRICT",
  /*  322 */ "STRING",
  /*  323 */ "TIMES",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "priv_type_list",
  /*  338 */ "priv_type",
  /*  339 */ "db_name",
  /*  340 */ "topic_name",
  /*  341 */ "dnode_endpoint",
  /*  342 */ "force_opt",
  /*  343 */ "not_exists_opt",
  /*  344 */ "db_options",
  /*  345 */ "exists_opt",
  /*  346 */ "alter_db_options",
  /*  347 */ "speed_opt",
  /*  348 */ "start_opt",
  /*  349 */ "end_opt",
  /*  350 */ "integer_list",
  /*  351 */ "variable_list",
  /*  352 */ "retention_list",
  /*  353 */ "alter_db_option",
  /*  354 */ "retention",
  /*  355 */ "full_table_name",
  /*  356 */ "column_def_list",
  /*  357 */ "tags_def_opt",
  /*  358 */ "table_options",
  /*  359 */ "multi_create_clause",
  /*  360 */ "tags_def",
  /*  361 */ "multi_drop_clause",
  /*  362 */ "alter_table_clause",
  /*  363 */ "alter_table_options",
  /*  364 */ "column_name",
  /*  365 */ "type_name",
  /*  366 */ "signed_literal",
  /*  367 */ "create_subtable_clause",
  /*  368 */ "specific_cols_opt",
  /*  369 */ "expression_list",
  /*  370 */ "drop_table_clause",
  /*  371 */ "col_name_list",
  /*  372 */ "table_name",
  /*  373 */ "column_def",
  /*  374 */ "duration_list",
  /*  375 */ "rollup_func_list",
  /*  376 */ "alter_table_option",
  /*  377 */ "duration_literal",
  /*  378 */ "rollup_func_name",
  /*  379 */ "function_name",
  /*  380 */ "col_name",
  /*  381 */ "db_name_cond_opt",
  /*  382 */ "like_pattern_opt",
  /*  383 */ "table_name_cond",
  /*  384 */ "from_db_opt",
  /*  385 */ "tag_list_opt",
  /*  386 */ "tag_item",
  /*  387 */ "column_alias",
  /*  388 */ "full_index_name",
  /*  389 */ "index_options",
  /*  390 */ "index_name",
  /*  391 */ "func_list",
  /*  392 */ "sliding_opt",
  /*  393 */ "sma_stream_opt",
  /*  394 */ "func",
  /*  395 */ "sma_func_name",
  /*  396 */ "query_or_subquery",
  /*  397 */ "cgroup_name",
  /*  398 */ "analyze_opt",
  /*  399 */ "explain_options",
  /*  400 */ "insert_query",
  /*  401 */ "agg_func_opt",
  /*  402 */ "bufsize_opt",
  /*  403 */ "stream_name",
  /*  404 */ "stream_options",
  /*  405 */ "col_list_opt",
  /*  406 */ "tag_def_or_ref_opt",
  /*  407 */ "subtable_opt",
  /*  408 */ "expression",
  /*  409 */ "dnode_list",
  /*  410 */ "where_clause_opt",
  /*  411 */ "signed",
  /*  412 */ "literal_func",
  /*  413 */ "literal_list",
  /*  414 */ "table_alias",
  /*  415 */ "expr_or_subquery",
  /*  416 */ "pseudo_column",
  /*  417 */ "column_reference",
  /*  418 */ "function_expression",
  /*  419 */ "case_when_expression",
  /*  420 */ "star_func",
  /*  421 */ "star_func_para_list",
  /*  422 */ "noarg_func",
  /*  423 */ "other_para_list",
  /*  424 */ "star_func_para",
  /*  425 */ "when_then_list",
  /*  426 */ "case_when_else_opt",
  /*  427 */ "common_expression",
  /*  428 */ "when_then_expr",
  /*  429 */ "predicate",
  /*  430 */ "compare_op",
  /*  431 */ "in_op",
  /*  432 */ "in_predicate_value",
  /*  433 */ "boolean_value_expression",
  /*  434 */ "boolean_primary",
  /*  435 */ "from_clause_opt",
  /*  436 */ "table_reference_list",
  /*  437 */ "table_reference",
  /*  438 */ "table_primary",
  /*  439 */ "joined_table",
  /*  440 */ "alias_opt",
  /*  441 */ "subquery",
  /*  442 */ "parenthesized_joined_table",
  /*  443 */ "join_type",
  /*  444 */ "search_condition",
  /*  445 */ "query_specification",
  /*  446 */ "set_quantifier_opt",
  /*  447 */ "select_list",
  /*  448 */ "partition_by_clause_opt",
  /*  449 */ "range_opt",
  /*  450 */ "every_opt",
  /*  451 */ "fill_opt",
  /*  452 */ "twindow_clause_opt",
  /*  453 */ "group_by_clause_opt",
  /*  454 */ "having_clause_opt",
  /*  455 */ "select_item",
  /*  456 */ "partition_list",
  /*  457 */ "partition_item",
  /*  458 */ "fill_mode",
  /*  459 */ "group_by_list",
  /*  460 */ "query_expression",
  /*  461 */ "query_simple",
  /*  462 */ "order_by_clause_opt",
  /*  463 */ "slimit_clause_opt",
  /*  464 */ "limit_clause_opt",
  /*  465 */ "union_query_expression",
  /*  466 */ "query_simple_or_subquery",
  /*  467 */ "sort_specification_list",
  /*  468 */ "sort_specification",
  /*  469 */ "ordering_specification_opt",
  /*  470 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "start_opt ::=",
 /* 130 */ "start_opt ::= START WITH NK_INTEGER",
 /* 131 */ "start_opt ::= START WITH NK_STRING",
 /* 132 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 133 */ "end_opt ::=",
 /* 134 */ "end_opt ::= END WITH NK_INTEGER",
 /* 135 */ "end_opt ::= END WITH NK_STRING",
 /* 136 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 137 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 138 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 139 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 140 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 141 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 142 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 143 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 144 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 145 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 146 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 147 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 148 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 149 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 150 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 151 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 152 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 153 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 154 */ "multi_create_clause ::= create_subtable_clause",
 /* 155 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 156 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 157 */ "multi_drop_clause ::= drop_table_clause",
 /* 158 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 159 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 160 */ "specific_cols_opt ::=",
 /* 161 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 162 */ "full_table_name ::= table_name",
 /* 163 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 164 */ "column_def_list ::= column_def",
 /* 165 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 166 */ "column_def ::= column_name type_name",
 /* 167 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 168 */ "type_name ::= BOOL",
 /* 169 */ "type_name ::= TINYINT",
 /* 170 */ "type_name ::= SMALLINT",
 /* 171 */ "type_name ::= INT",
 /* 172 */ "type_name ::= INTEGER",
 /* 173 */ "type_name ::= BIGINT",
 /* 174 */ "type_name ::= FLOAT",
 /* 175 */ "type_name ::= DOUBLE",
 /* 176 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= TIMESTAMP",
 /* 178 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= TINYINT UNSIGNED",
 /* 180 */ "type_name ::= SMALLINT UNSIGNED",
 /* 181 */ "type_name ::= INT UNSIGNED",
 /* 182 */ "type_name ::= BIGINT UNSIGNED",
 /* 183 */ "type_name ::= JSON",
 /* 184 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 185 */ "type_name ::= MEDIUMBLOB",
 /* 186 */ "type_name ::= BLOB",
 /* 187 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 188 */ "type_name ::= DECIMAL",
 /* 189 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 191 */ "tags_def_opt ::=",
 /* 192 */ "tags_def_opt ::= tags_def",
 /* 193 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 194 */ "table_options ::=",
 /* 195 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 196 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 197 */ "table_options ::= table_options WATERMARK duration_list",
 /* 198 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 199 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 200 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 201 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 202 */ "alter_table_options ::= alter_table_option",
 /* 203 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 204 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 205 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 206 */ "duration_list ::= duration_literal",
 /* 207 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 208 */ "rollup_func_list ::= rollup_func_name",
 /* 209 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 210 */ "rollup_func_name ::= function_name",
 /* 211 */ "rollup_func_name ::= FIRST",
 /* 212 */ "rollup_func_name ::= LAST",
 /* 213 */ "col_name_list ::= col_name",
 /* 214 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 215 */ "col_name ::= column_name",
 /* 216 */ "cmd ::= SHOW DNODES",
 /* 217 */ "cmd ::= SHOW USERS",
 /* 218 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 219 */ "cmd ::= SHOW DATABASES",
 /* 220 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 221 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 222 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 223 */ "cmd ::= SHOW MNODES",
 /* 224 */ "cmd ::= SHOW QNODES",
 /* 225 */ "cmd ::= SHOW FUNCTIONS",
 /* 226 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 227 */ "cmd ::= SHOW STREAMS",
 /* 228 */ "cmd ::= SHOW ACCOUNTS",
 /* 229 */ "cmd ::= SHOW APPS",
 /* 230 */ "cmd ::= SHOW CONNECTIONS",
 /* 231 */ "cmd ::= SHOW LICENCES",
 /* 232 */ "cmd ::= SHOW GRANTS",
 /* 233 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 234 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 235 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 236 */ "cmd ::= SHOW QUERIES",
 /* 237 */ "cmd ::= SHOW SCORES",
 /* 238 */ "cmd ::= SHOW TOPICS",
 /* 239 */ "cmd ::= SHOW VARIABLES",
 /* 240 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 241 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 242 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 243 */ "cmd ::= SHOW BNODES",
 /* 244 */ "cmd ::= SHOW SNODES",
 /* 245 */ "cmd ::= SHOW CLUSTER",
 /* 246 */ "cmd ::= SHOW TRANSACTIONS",
 /* 247 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 248 */ "cmd ::= SHOW CONSUMERS",
 /* 249 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 250 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 251 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 252 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 253 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 254 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 255 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 256 */ "db_name_cond_opt ::=",
 /* 257 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 258 */ "like_pattern_opt ::=",
 /* 259 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 260 */ "table_name_cond ::= table_name",
 /* 261 */ "from_db_opt ::=",
 /* 262 */ "from_db_opt ::= FROM db_name",
 /* 263 */ "tag_list_opt ::=",
 /* 264 */ "tag_list_opt ::= tag_item",
 /* 265 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 266 */ "tag_item ::= TBNAME",
 /* 267 */ "tag_item ::= QTAGS",
 /* 268 */ "tag_item ::= column_name",
 /* 269 */ "tag_item ::= column_name column_alias",
 /* 270 */ "tag_item ::= column_name AS column_alias",
 /* 271 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 272 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 273 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 274 */ "full_index_name ::= index_name",
 /* 275 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 276 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 277 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 278 */ "func_list ::= func",
 /* 279 */ "func_list ::= func_list NK_COMMA func",
 /* 280 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 281 */ "sma_func_name ::= function_name",
 /* 282 */ "sma_func_name ::= COUNT",
 /* 283 */ "sma_func_name ::= FIRST",
 /* 284 */ "sma_func_name ::= LAST",
 /* 285 */ "sma_func_name ::= LAST_ROW",
 /* 286 */ "sma_stream_opt ::=",
 /* 287 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 288 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 289 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 290 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 291 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 292 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 293 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 294 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 295 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 296 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 297 */ "cmd ::= DESC full_table_name",
 /* 298 */ "cmd ::= DESCRIBE full_table_name",
 /* 299 */ "cmd ::= RESET QUERY CACHE",
 /* 300 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 301 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 302 */ "analyze_opt ::=",
 /* 303 */ "analyze_opt ::= ANALYZE",
 /* 304 */ "explain_options ::=",
 /* 305 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 306 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 307 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 308 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 309 */ "agg_func_opt ::=",
 /* 310 */ "agg_func_opt ::= AGGREGATE",
 /* 311 */ "bufsize_opt ::=",
 /* 312 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 313 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 314 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 315 */ "col_list_opt ::=",
 /* 316 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 317 */ "tag_def_or_ref_opt ::=",
 /* 318 */ "tag_def_or_ref_opt ::= tags_def",
 /* 319 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 320 */ "stream_options ::=",
 /* 321 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 322 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 323 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 324 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 325 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 326 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 327 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 328 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 329 */ "subtable_opt ::=",
 /* 330 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 331 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 332 */ "cmd ::= KILL QUERY NK_STRING",
 /* 333 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 334 */ "cmd ::= BALANCE VGROUP",
 /* 335 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 336 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 337 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 338 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 339 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 340 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 341 */ "cmd ::= query_or_subquery",
 /* 342 */ "cmd ::= insert_query",
 /* 343 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 344 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 345 */ "literal ::= NK_INTEGER",
 /* 346 */ "literal ::= NK_FLOAT",
 /* 347 */ "literal ::= NK_STRING",
 /* 348 */ "literal ::= NK_BOOL",
 /* 349 */ "literal ::= TIMESTAMP NK_STRING",
 /* 350 */ "literal ::= duration_literal",
 /* 351 */ "literal ::= NULL",
 /* 352 */ "literal ::= NK_QUESTION",
 /* 353 */ "duration_literal ::= NK_VARIABLE",
 /* 354 */ "signed ::= NK_INTEGER",
 /* 355 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 356 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 357 */ "signed ::= NK_FLOAT",
 /* 358 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 359 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 360 */ "signed_literal ::= signed",
 /* 361 */ "signed_literal ::= NK_STRING",
 /* 362 */ "signed_literal ::= NK_BOOL",
 /* 363 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 364 */ "signed_literal ::= duration_literal",
 /* 365 */ "signed_literal ::= NULL",
 /* 366 */ "signed_literal ::= literal_func",
 /* 367 */ "signed_literal ::= NK_QUESTION",
 /* 368 */ "literal_list ::= signed_literal",
 /* 369 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 370 */ "db_name ::= NK_ID",
 /* 371 */ "table_name ::= NK_ID",
 /* 372 */ "column_name ::= NK_ID",
 /* 373 */ "function_name ::= NK_ID",
 /* 374 */ "table_alias ::= NK_ID",
 /* 375 */ "column_alias ::= NK_ID",
 /* 376 */ "user_name ::= NK_ID",
 /* 377 */ "topic_name ::= NK_ID",
 /* 378 */ "stream_name ::= NK_ID",
 /* 379 */ "cgroup_name ::= NK_ID",
 /* 380 */ "index_name ::= NK_ID",
 /* 381 */ "expr_or_subquery ::= expression",
 /* 382 */ "expression ::= literal",
 /* 383 */ "expression ::= pseudo_column",
 /* 384 */ "expression ::= column_reference",
 /* 385 */ "expression ::= function_expression",
 /* 386 */ "expression ::= case_when_expression",
 /* 387 */ "expression ::= NK_LP expression NK_RP",
 /* 388 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 389 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 390 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 391 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 392 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 393 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 394 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 395 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 396 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 397 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 398 */ "expression_list ::= expr_or_subquery",
 /* 399 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 400 */ "column_reference ::= column_name",
 /* 401 */ "column_reference ::= table_name NK_DOT column_name",
 /* 402 */ "pseudo_column ::= ROWTS",
 /* 403 */ "pseudo_column ::= TBNAME",
 /* 404 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 405 */ "pseudo_column ::= QSTART",
 /* 406 */ "pseudo_column ::= QEND",
 /* 407 */ "pseudo_column ::= QDURATION",
 /* 408 */ "pseudo_column ::= WSTART",
 /* 409 */ "pseudo_column ::= WEND",
 /* 410 */ "pseudo_column ::= WDURATION",
 /* 411 */ "pseudo_column ::= IROWTS",
 /* 412 */ "pseudo_column ::= ISFILLED",
 /* 413 */ "pseudo_column ::= QTAGS",
 /* 414 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 415 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 416 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 417 */ "function_expression ::= literal_func",
 /* 418 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 419 */ "literal_func ::= NOW",
 /* 420 */ "noarg_func ::= NOW",
 /* 421 */ "noarg_func ::= TODAY",
 /* 422 */ "noarg_func ::= TIMEZONE",
 /* 423 */ "noarg_func ::= DATABASE",
 /* 424 */ "noarg_func ::= CLIENT_VERSION",
 /* 425 */ "noarg_func ::= SERVER_VERSION",
 /* 426 */ "noarg_func ::= SERVER_STATUS",
 /* 427 */ "noarg_func ::= CURRENT_USER",
 /* 428 */ "noarg_func ::= USER",
 /* 429 */ "star_func ::= COUNT",
 /* 430 */ "star_func ::= FIRST",
 /* 431 */ "star_func ::= LAST",
 /* 432 */ "star_func ::= LAST_ROW",
 /* 433 */ "star_func_para_list ::= NK_STAR",
 /* 434 */ "star_func_para_list ::= other_para_list",
 /* 435 */ "other_para_list ::= star_func_para",
 /* 436 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 437 */ "star_func_para ::= expr_or_subquery",
 /* 438 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 439 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 440 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 441 */ "when_then_list ::= when_then_expr",
 /* 442 */ "when_then_list ::= when_then_list when_then_expr",
 /* 443 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 444 */ "case_when_else_opt ::=",
 /* 445 */ "case_when_else_opt ::= ELSE common_expression",
 /* 446 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 447 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 448 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 449 */ "predicate ::= expr_or_subquery IS NULL",
 /* 450 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 451 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 452 */ "compare_op ::= NK_LT",
 /* 453 */ "compare_op ::= NK_GT",
 /* 454 */ "compare_op ::= NK_LE",
 /* 455 */ "compare_op ::= NK_GE",
 /* 456 */ "compare_op ::= NK_NE",
 /* 457 */ "compare_op ::= NK_EQ",
 /* 458 */ "compare_op ::= LIKE",
 /* 459 */ "compare_op ::= NOT LIKE",
 /* 460 */ "compare_op ::= MATCH",
 /* 461 */ "compare_op ::= NMATCH",
 /* 462 */ "compare_op ::= CONTAINS",
 /* 463 */ "in_op ::= IN",
 /* 464 */ "in_op ::= NOT IN",
 /* 465 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 466 */ "boolean_value_expression ::= boolean_primary",
 /* 467 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 468 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 469 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 470 */ "boolean_primary ::= predicate",
 /* 471 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 472 */ "common_expression ::= expr_or_subquery",
 /* 473 */ "common_expression ::= boolean_value_expression",
 /* 474 */ "from_clause_opt ::=",
 /* 475 */ "from_clause_opt ::= FROM table_reference_list",
 /* 476 */ "table_reference_list ::= table_reference",
 /* 477 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 478 */ "table_reference ::= table_primary",
 /* 479 */ "table_reference ::= joined_table",
 /* 480 */ "table_primary ::= table_name alias_opt",
 /* 481 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 482 */ "table_primary ::= subquery alias_opt",
 /* 483 */ "table_primary ::= parenthesized_joined_table",
 /* 484 */ "alias_opt ::=",
 /* 485 */ "alias_opt ::= table_alias",
 /* 486 */ "alias_opt ::= AS table_alias",
 /* 487 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 488 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 489 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 490 */ "join_type ::=",
 /* 491 */ "join_type ::= INNER",
 /* 492 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 493 */ "set_quantifier_opt ::=",
 /* 494 */ "set_quantifier_opt ::= DISTINCT",
 /* 495 */ "set_quantifier_opt ::= ALL",
 /* 496 */ "select_list ::= select_item",
 /* 497 */ "select_list ::= select_list NK_COMMA select_item",
 /* 498 */ "select_item ::= NK_STAR",
 /* 499 */ "select_item ::= common_expression",
 /* 500 */ "select_item ::= common_expression column_alias",
 /* 501 */ "select_item ::= common_expression AS column_alias",
 /* 502 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 503 */ "where_clause_opt ::=",
 /* 504 */ "where_clause_opt ::= WHERE search_condition",
 /* 505 */ "partition_by_clause_opt ::=",
 /* 506 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 507 */ "partition_list ::= partition_item",
 /* 508 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 509 */ "partition_item ::= expr_or_subquery",
 /* 510 */ "partition_item ::= expr_or_subquery column_alias",
 /* 511 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 512 */ "twindow_clause_opt ::=",
 /* 513 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 514 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 515 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 516 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 517 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 518 */ "sliding_opt ::=",
 /* 519 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 520 */ "fill_opt ::=",
 /* 521 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 522 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 523 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 524 */ "fill_mode ::= NONE",
 /* 525 */ "fill_mode ::= PREV",
 /* 526 */ "fill_mode ::= NULL",
 /* 527 */ "fill_mode ::= NULL_F",
 /* 528 */ "fill_mode ::= LINEAR",
 /* 529 */ "fill_mode ::= NEXT",
 /* 530 */ "group_by_clause_opt ::=",
 /* 531 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 532 */ "group_by_list ::= expr_or_subquery",
 /* 533 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 534 */ "having_clause_opt ::=",
 /* 535 */ "having_clause_opt ::= HAVING search_condition",
 /* 536 */ "range_opt ::=",
 /* 537 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 538 */ "every_opt ::=",
 /* 539 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 540 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 541 */ "query_simple ::= query_specification",
 /* 542 */ "query_simple ::= union_query_expression",
 /* 543 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 544 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 545 */ "query_simple_or_subquery ::= query_simple",
 /* 546 */ "query_simple_or_subquery ::= subquery",
 /* 547 */ "query_or_subquery ::= query_expression",
 /* 548 */ "query_or_subquery ::= subquery",
 /* 549 */ "order_by_clause_opt ::=",
 /* 550 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 551 */ "slimit_clause_opt ::=",
 /* 552 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 553 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 554 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 555 */ "limit_clause_opt ::=",
 /* 556 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 557 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 558 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 559 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 560 */ "subquery ::= NK_LP subquery NK_RP",
 /* 561 */ "search_condition ::= common_expression",
 /* 562 */ "sort_specification_list ::= sort_specification",
 /* 563 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 564 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 565 */ "ordering_specification_opt ::=",
 /* 566 */ "ordering_specification_opt ::= ASC",
 /* 567 */ "ordering_specification_opt ::= DESC",
 /* 568 */ "null_ordering_opt ::=",
 /* 569 */ "null_ordering_opt ::= NULLS FIRST",
 /* 570 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 344: /* db_options */
    case 346: /* alter_db_options */
    case 348: /* start_opt */
    case 349: /* end_opt */
    case 354: /* retention */
    case 355: /* full_table_name */
    case 358: /* table_options */
    case 362: /* alter_table_clause */
    case 363: /* alter_table_options */
    case 366: /* signed_literal */
    case 367: /* create_subtable_clause */
    case 370: /* drop_table_clause */
    case 373: /* column_def */
    case 377: /* duration_literal */
    case 378: /* rollup_func_name */
    case 380: /* col_name */
    case 381: /* db_name_cond_opt */
    case 382: /* like_pattern_opt */
    case 383: /* table_name_cond */
    case 384: /* from_db_opt */
    case 386: /* tag_item */
    case 388: /* full_index_name */
    case 389: /* index_options */
    case 392: /* sliding_opt */
    case 393: /* sma_stream_opt */
    case 394: /* func */
    case 396: /* query_or_subquery */
    case 399: /* explain_options */
    case 400: /* insert_query */
    case 404: /* stream_options */
    case 407: /* subtable_opt */
    case 408: /* expression */
    case 410: /* where_clause_opt */
    case 411: /* signed */
    case 412: /* literal_func */
    case 415: /* expr_or_subquery */
    case 416: /* pseudo_column */
    case 417: /* column_reference */
    case 418: /* function_expression */
    case 419: /* case_when_expression */
    case 424: /* star_func_para */
    case 426: /* case_when_else_opt */
    case 427: /* common_expression */
    case 428: /* when_then_expr */
    case 429: /* predicate */
    case 432: /* in_predicate_value */
    case 433: /* boolean_value_expression */
    case 434: /* boolean_primary */
    case 435: /* from_clause_opt */
    case 436: /* table_reference_list */
    case 437: /* table_reference */
    case 438: /* table_primary */
    case 439: /* joined_table */
    case 441: /* subquery */
    case 442: /* parenthesized_joined_table */
    case 444: /* search_condition */
    case 445: /* query_specification */
    case 449: /* range_opt */
    case 450: /* every_opt */
    case 451: /* fill_opt */
    case 452: /* twindow_clause_opt */
    case 454: /* having_clause_opt */
    case 455: /* select_item */
    case 457: /* partition_item */
    case 460: /* query_expression */
    case 461: /* query_simple */
    case 463: /* slimit_clause_opt */
    case 464: /* limit_clause_opt */
    case 465: /* union_query_expression */
    case 466: /* query_simple_or_subquery */
    case 468: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy140)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 347: /* speed_opt */
    case 402: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 336: /* priv_level */
    case 339: /* db_name */
    case 340: /* topic_name */
    case 341: /* dnode_endpoint */
    case 364: /* column_name */
    case 372: /* table_name */
    case 379: /* function_name */
    case 387: /* column_alias */
    case 390: /* index_name */
    case 395: /* sma_func_name */
    case 397: /* cgroup_name */
    case 403: /* stream_name */
    case 414: /* table_alias */
    case 420: /* star_func */
    case 422: /* noarg_func */
    case 440: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 337: /* priv_type_list */
    case 338: /* priv_type */
{
 
}
      break;
    case 342: /* force_opt */
    case 343: /* not_exists_opt */
    case 345: /* exists_opt */
    case 398: /* analyze_opt */
    case 401: /* agg_func_opt */
    case 446: /* set_quantifier_opt */
{
 
}
      break;
    case 350: /* integer_list */
    case 351: /* variable_list */
    case 352: /* retention_list */
    case 356: /* column_def_list */
    case 357: /* tags_def_opt */
    case 359: /* multi_create_clause */
    case 360: /* tags_def */
    case 361: /* multi_drop_clause */
    case 368: /* specific_cols_opt */
    case 369: /* expression_list */
    case 371: /* col_name_list */
    case 374: /* duration_list */
    case 375: /* rollup_func_list */
    case 385: /* tag_list_opt */
    case 391: /* func_list */
    case 405: /* col_list_opt */
    case 406: /* tag_def_or_ref_opt */
    case 409: /* dnode_list */
    case 413: /* literal_list */
    case 421: /* star_func_para_list */
    case 423: /* other_para_list */
    case 425: /* when_then_list */
    case 447: /* select_list */
    case 448: /* partition_by_clause_opt */
    case 453: /* group_by_clause_opt */
    case 456: /* partition_list */
    case 459: /* group_by_list */
    case 462: /* order_by_clause_opt */
    case 467: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy220)); 
}
      break;
    case 353: /* alter_db_option */
    case 376: /* alter_table_option */
{
 
}
      break;
    case 365: /* type_name */
{
 
}
      break;
    case 430: /* compare_op */
    case 431: /* in_op */
{
 
}
      break;
    case 443: /* join_type */
{
 
}
      break;
    case 458: /* fill_mode */
{
 
}
      break;
    case 469: /* ordering_specification_opt */
{
 
}
      break;
    case 470: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  328,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  337,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  337,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  338,   -1 }, /* (38) priv_type ::= READ */
  {  338,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -1 }, /* (42) priv_level ::= topic_name */
  {  328,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  341,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  341,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  341,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  342,    0 }, /* (54) force_opt ::= */
  {  342,   -1 }, /* (55) force_opt ::= FORCE */
  {  328,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (68) cmd ::= USE db_name */
  {  328,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  343,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  343,    0 }, /* (74) not_exists_opt ::= */
  {  345,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  345,    0 }, /* (76) exists_opt ::= */
  {  344,    0 }, /* (77) db_options ::= */
  {  344,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  344,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  344,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  344,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  344,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  344,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  344,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  344,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  344,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  344,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  344,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  344,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  344,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  344,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  344,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  344,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  344,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  344,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  344,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  344,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  344,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  344,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  344,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  344,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  346,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  346,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  353,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  353,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  353,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  353,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  353,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  353,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  353,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  353,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  353,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  353,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  350,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  350,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  351,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  351,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  352,   -1 }, /* (124) retention_list ::= retention */
  {  352,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  354,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  347,    0 }, /* (127) speed_opt ::= */
  {  347,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  348,    0 }, /* (129) start_opt ::= */
  {  348,   -3 }, /* (130) start_opt ::= START WITH NK_INTEGER */
  {  348,   -3 }, /* (131) start_opt ::= START WITH NK_STRING */
  {  348,   -4 }, /* (132) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  349,    0 }, /* (133) end_opt ::= */
  {  349,   -3 }, /* (134) end_opt ::= END WITH NK_INTEGER */
  {  349,   -3 }, /* (135) end_opt ::= END WITH NK_STRING */
  {  349,   -4 }, /* (136) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  328,   -9 }, /* (137) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (138) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (139) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (140) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (141) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (142) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (143) cmd ::= ALTER STABLE alter_table_clause */
  {  362,   -2 }, /* (144) alter_table_clause ::= full_table_name alter_table_options */
  {  362,   -5 }, /* (145) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  362,   -4 }, /* (146) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  362,   -5 }, /* (147) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  362,   -5 }, /* (148) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  362,   -5 }, /* (149) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  362,   -4 }, /* (150) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  362,   -5 }, /* (151) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  362,   -5 }, /* (152) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  362,   -6 }, /* (153) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  359,   -1 }, /* (154) multi_create_clause ::= create_subtable_clause */
  {  359,   -2 }, /* (155) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  367,  -10 }, /* (156) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  361,   -1 }, /* (157) multi_drop_clause ::= drop_table_clause */
  {  361,   -3 }, /* (158) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  370,   -2 }, /* (159) drop_table_clause ::= exists_opt full_table_name */
  {  368,    0 }, /* (160) specific_cols_opt ::= */
  {  368,   -3 }, /* (161) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  355,   -1 }, /* (162) full_table_name ::= table_name */
  {  355,   -3 }, /* (163) full_table_name ::= db_name NK_DOT table_name */
  {  356,   -1 }, /* (164) column_def_list ::= column_def */
  {  356,   -3 }, /* (165) column_def_list ::= column_def_list NK_COMMA column_def */
  {  373,   -2 }, /* (166) column_def ::= column_name type_name */
  {  373,   -4 }, /* (167) column_def ::= column_name type_name COMMENT NK_STRING */
  {  365,   -1 }, /* (168) type_name ::= BOOL */
  {  365,   -1 }, /* (169) type_name ::= TINYINT */
  {  365,   -1 }, /* (170) type_name ::= SMALLINT */
  {  365,   -1 }, /* (171) type_name ::= INT */
  {  365,   -1 }, /* (172) type_name ::= INTEGER */
  {  365,   -1 }, /* (173) type_name ::= BIGINT */
  {  365,   -1 }, /* (174) type_name ::= FLOAT */
  {  365,   -1 }, /* (175) type_name ::= DOUBLE */
  {  365,   -4 }, /* (176) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (177) type_name ::= TIMESTAMP */
  {  365,   -4 }, /* (178) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  365,   -2 }, /* (179) type_name ::= TINYINT UNSIGNED */
  {  365,   -2 }, /* (180) type_name ::= SMALLINT UNSIGNED */
  {  365,   -2 }, /* (181) type_name ::= INT UNSIGNED */
  {  365,   -2 }, /* (182) type_name ::= BIGINT UNSIGNED */
  {  365,   -1 }, /* (183) type_name ::= JSON */
  {  365,   -4 }, /* (184) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (185) type_name ::= MEDIUMBLOB */
  {  365,   -1 }, /* (186) type_name ::= BLOB */
  {  365,   -4 }, /* (187) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (188) type_name ::= DECIMAL */
  {  365,   -4 }, /* (189) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  365,   -6 }, /* (190) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  357,    0 }, /* (191) tags_def_opt ::= */
  {  357,   -1 }, /* (192) tags_def_opt ::= tags_def */
  {  360,   -4 }, /* (193) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  358,    0 }, /* (194) table_options ::= */
  {  358,   -3 }, /* (195) table_options ::= table_options COMMENT NK_STRING */
  {  358,   -3 }, /* (196) table_options ::= table_options MAX_DELAY duration_list */
  {  358,   -3 }, /* (197) table_options ::= table_options WATERMARK duration_list */
  {  358,   -5 }, /* (198) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  358,   -3 }, /* (199) table_options ::= table_options TTL NK_INTEGER */
  {  358,   -5 }, /* (200) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  358,   -3 }, /* (201) table_options ::= table_options DELETE_MARK duration_list */
  {  363,   -1 }, /* (202) alter_table_options ::= alter_table_option */
  {  363,   -2 }, /* (203) alter_table_options ::= alter_table_options alter_table_option */
  {  376,   -2 }, /* (204) alter_table_option ::= COMMENT NK_STRING */
  {  376,   -2 }, /* (205) alter_table_option ::= TTL NK_INTEGER */
  {  374,   -1 }, /* (206) duration_list ::= duration_literal */
  {  374,   -3 }, /* (207) duration_list ::= duration_list NK_COMMA duration_literal */
  {  375,   -1 }, /* (208) rollup_func_list ::= rollup_func_name */
  {  375,   -3 }, /* (209) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  378,   -1 }, /* (210) rollup_func_name ::= function_name */
  {  378,   -1 }, /* (211) rollup_func_name ::= FIRST */
  {  378,   -1 }, /* (212) rollup_func_name ::= LAST */
  {  371,   -1 }, /* (213) col_name_list ::= col_name */
  {  371,   -3 }, /* (214) col_name_list ::= col_name_list NK_COMMA col_name */
  {  380,   -1 }, /* (215) col_name ::= column_name */
  {  328,   -2 }, /* (216) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (217) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (218) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (219) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (220) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (221) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (222) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (223) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (224) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (225) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (226) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (227) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (228) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (229) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (230) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (231) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (232) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (233) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (234) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (235) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (236) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (237) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (238) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (239) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (240) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (241) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (242) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (243) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (244) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (245) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (246) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (247) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (248) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (249) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (250) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (251) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (252) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (253) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (254) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (255) cmd ::= SHOW CLUSTER ALIVE */
  {  381,    0 }, /* (256) db_name_cond_opt ::= */
  {  381,   -2 }, /* (257) db_name_cond_opt ::= db_name NK_DOT */
  {  382,    0 }, /* (258) like_pattern_opt ::= */
  {  382,   -2 }, /* (259) like_pattern_opt ::= LIKE NK_STRING */
  {  383,   -1 }, /* (260) table_name_cond ::= table_name */
  {  384,    0 }, /* (261) from_db_opt ::= */
  {  384,   -2 }, /* (262) from_db_opt ::= FROM db_name */
  {  385,    0 }, /* (263) tag_list_opt ::= */
  {  385,   -1 }, /* (264) tag_list_opt ::= tag_item */
  {  385,   -3 }, /* (265) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  386,   -1 }, /* (266) tag_item ::= TBNAME */
  {  386,   -1 }, /* (267) tag_item ::= QTAGS */
  {  386,   -1 }, /* (268) tag_item ::= column_name */
  {  386,   -2 }, /* (269) tag_item ::= column_name column_alias */
  {  386,   -3 }, /* (270) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (271) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (272) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (273) cmd ::= DROP INDEX exists_opt full_index_name */
  {  388,   -1 }, /* (274) full_index_name ::= index_name */
  {  388,   -3 }, /* (275) full_index_name ::= db_name NK_DOT index_name */
  {  389,  -10 }, /* (276) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  389,  -12 }, /* (277) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  391,   -1 }, /* (278) func_list ::= func */
  {  391,   -3 }, /* (279) func_list ::= func_list NK_COMMA func */
  {  394,   -4 }, /* (280) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  395,   -1 }, /* (281) sma_func_name ::= function_name */
  {  395,   -1 }, /* (282) sma_func_name ::= COUNT */
  {  395,   -1 }, /* (283) sma_func_name ::= FIRST */
  {  395,   -1 }, /* (284) sma_func_name ::= LAST */
  {  395,   -1 }, /* (285) sma_func_name ::= LAST_ROW */
  {  393,    0 }, /* (286) sma_stream_opt ::= */
  {  393,   -3 }, /* (287) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  393,   -3 }, /* (288) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  393,   -3 }, /* (289) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (290) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (291) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (292) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (293) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (294) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (295) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (296) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (297) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (298) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (299) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (300) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (301) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  398,    0 }, /* (302) analyze_opt ::= */
  {  398,   -1 }, /* (303) analyze_opt ::= ANALYZE */
  {  399,    0 }, /* (304) explain_options ::= */
  {  399,   -3 }, /* (305) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  399,   -3 }, /* (306) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (307) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (308) cmd ::= DROP FUNCTION exists_opt function_name */
  {  401,    0 }, /* (309) agg_func_opt ::= */
  {  401,   -1 }, /* (310) agg_func_opt ::= AGGREGATE */
  {  402,    0 }, /* (311) bufsize_opt ::= */
  {  402,   -2 }, /* (312) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (313) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (314) cmd ::= DROP STREAM exists_opt stream_name */
  {  405,    0 }, /* (315) col_list_opt ::= */
  {  405,   -3 }, /* (316) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (317) tag_def_or_ref_opt ::= */
  {  406,   -1 }, /* (318) tag_def_or_ref_opt ::= tags_def */
  {  406,   -4 }, /* (319) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  404,    0 }, /* (320) stream_options ::= */
  {  404,   -3 }, /* (321) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  404,   -3 }, /* (322) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  404,   -4 }, /* (323) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  404,   -3 }, /* (324) stream_options ::= stream_options WATERMARK duration_literal */
  {  404,   -4 }, /* (325) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  404,   -3 }, /* (326) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  404,   -3 }, /* (327) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  404,   -4 }, /* (328) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  407,    0 }, /* (329) subtable_opt ::= */
  {  407,   -4 }, /* (330) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (331) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (332) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (333) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (334) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (335) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (336) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (337) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  409,   -2 }, /* (338) dnode_list ::= DNODE NK_INTEGER */
  {  409,   -3 }, /* (339) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (340) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (341) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (342) cmd ::= insert_query */
  {  400,   -7 }, /* (343) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  400,   -4 }, /* (344) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (345) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (346) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (347) literal ::= NK_STRING */
  {  331,   -1 }, /* (348) literal ::= NK_BOOL */
  {  331,   -2 }, /* (349) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (350) literal ::= duration_literal */
  {  331,   -1 }, /* (351) literal ::= NULL */
  {  331,   -1 }, /* (352) literal ::= NK_QUESTION */
  {  377,   -1 }, /* (353) duration_literal ::= NK_VARIABLE */
  {  411,   -1 }, /* (354) signed ::= NK_INTEGER */
  {  411,   -2 }, /* (355) signed ::= NK_PLUS NK_INTEGER */
  {  411,   -2 }, /* (356) signed ::= NK_MINUS NK_INTEGER */
  {  411,   -1 }, /* (357) signed ::= NK_FLOAT */
  {  411,   -2 }, /* (358) signed ::= NK_PLUS NK_FLOAT */
  {  411,   -2 }, /* (359) signed ::= NK_MINUS NK_FLOAT */
  {  366,   -1 }, /* (360) signed_literal ::= signed */
  {  366,   -1 }, /* (361) signed_literal ::= NK_STRING */
  {  366,   -1 }, /* (362) signed_literal ::= NK_BOOL */
  {  366,   -2 }, /* (363) signed_literal ::= TIMESTAMP NK_STRING */
  {  366,   -1 }, /* (364) signed_literal ::= duration_literal */
  {  366,   -1 }, /* (365) signed_literal ::= NULL */
  {  366,   -1 }, /* (366) signed_literal ::= literal_func */
  {  366,   -1 }, /* (367) signed_literal ::= NK_QUESTION */
  {  413,   -1 }, /* (368) literal_list ::= signed_literal */
  {  413,   -3 }, /* (369) literal_list ::= literal_list NK_COMMA signed_literal */
  {  339,   -1 }, /* (370) db_name ::= NK_ID */
  {  372,   -1 }, /* (371) table_name ::= NK_ID */
  {  364,   -1 }, /* (372) column_name ::= NK_ID */
  {  379,   -1 }, /* (373) function_name ::= NK_ID */
  {  414,   -1 }, /* (374) table_alias ::= NK_ID */
  {  387,   -1 }, /* (375) column_alias ::= NK_ID */
  {  333,   -1 }, /* (376) user_name ::= NK_ID */
  {  340,   -1 }, /* (377) topic_name ::= NK_ID */
  {  403,   -1 }, /* (378) stream_name ::= NK_ID */
  {  397,   -1 }, /* (379) cgroup_name ::= NK_ID */
  {  390,   -1 }, /* (380) index_name ::= NK_ID */
  {  415,   -1 }, /* (381) expr_or_subquery ::= expression */
  {  408,   -1 }, /* (382) expression ::= literal */
  {  408,   -1 }, /* (383) expression ::= pseudo_column */
  {  408,   -1 }, /* (384) expression ::= column_reference */
  {  408,   -1 }, /* (385) expression ::= function_expression */
  {  408,   -1 }, /* (386) expression ::= case_when_expression */
  {  408,   -3 }, /* (387) expression ::= NK_LP expression NK_RP */
  {  408,   -2 }, /* (388) expression ::= NK_PLUS expr_or_subquery */
  {  408,   -2 }, /* (389) expression ::= NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (390) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  408,   -3 }, /* (391) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (392) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  408,   -3 }, /* (393) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  408,   -3 }, /* (394) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  408,   -3 }, /* (395) expression ::= column_reference NK_ARROW NK_STRING */
  {  408,   -3 }, /* (396) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  408,   -3 }, /* (397) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  369,   -1 }, /* (398) expression_list ::= expr_or_subquery */
  {  369,   -3 }, /* (399) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  417,   -1 }, /* (400) column_reference ::= column_name */
  {  417,   -3 }, /* (401) column_reference ::= table_name NK_DOT column_name */
  {  416,   -1 }, /* (402) pseudo_column ::= ROWTS */
  {  416,   -1 }, /* (403) pseudo_column ::= TBNAME */
  {  416,   -3 }, /* (404) pseudo_column ::= table_name NK_DOT TBNAME */
  {  416,   -1 }, /* (405) pseudo_column ::= QSTART */
  {  416,   -1 }, /* (406) pseudo_column ::= QEND */
  {  416,   -1 }, /* (407) pseudo_column ::= QDURATION */
  {  416,   -1 }, /* (408) pseudo_column ::= WSTART */
  {  416,   -1 }, /* (409) pseudo_column ::= WEND */
  {  416,   -1 }, /* (410) pseudo_column ::= WDURATION */
  {  416,   -1 }, /* (411) pseudo_column ::= IROWTS */
  {  416,   -1 }, /* (412) pseudo_column ::= ISFILLED */
  {  416,   -1 }, /* (413) pseudo_column ::= QTAGS */
  {  418,   -4 }, /* (414) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  418,   -4 }, /* (415) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  418,   -6 }, /* (416) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  418,   -1 }, /* (417) function_expression ::= literal_func */
  {  412,   -3 }, /* (418) literal_func ::= noarg_func NK_LP NK_RP */
  {  412,   -1 }, /* (419) literal_func ::= NOW */
  {  422,   -1 }, /* (420) noarg_func ::= NOW */
  {  422,   -1 }, /* (421) noarg_func ::= TODAY */
  {  422,   -1 }, /* (422) noarg_func ::= TIMEZONE */
  {  422,   -1 }, /* (423) noarg_func ::= DATABASE */
  {  422,   -1 }, /* (424) noarg_func ::= CLIENT_VERSION */
  {  422,   -1 }, /* (425) noarg_func ::= SERVER_VERSION */
  {  422,   -1 }, /* (426) noarg_func ::= SERVER_STATUS */
  {  422,   -1 }, /* (427) noarg_func ::= CURRENT_USER */
  {  422,   -1 }, /* (428) noarg_func ::= USER */
  {  420,   -1 }, /* (429) star_func ::= COUNT */
  {  420,   -1 }, /* (430) star_func ::= FIRST */
  {  420,   -1 }, /* (431) star_func ::= LAST */
  {  420,   -1 }, /* (432) star_func ::= LAST_ROW */
  {  421,   -1 }, /* (433) star_func_para_list ::= NK_STAR */
  {  421,   -1 }, /* (434) star_func_para_list ::= other_para_list */
  {  423,   -1 }, /* (435) other_para_list ::= star_func_para */
  {  423,   -3 }, /* (436) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  424,   -1 }, /* (437) star_func_para ::= expr_or_subquery */
  {  424,   -3 }, /* (438) star_func_para ::= table_name NK_DOT NK_STAR */
  {  419,   -4 }, /* (439) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  419,   -5 }, /* (440) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  425,   -1 }, /* (441) when_then_list ::= when_then_expr */
  {  425,   -2 }, /* (442) when_then_list ::= when_then_list when_then_expr */
  {  428,   -4 }, /* (443) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  426,    0 }, /* (444) case_when_else_opt ::= */
  {  426,   -2 }, /* (445) case_when_else_opt ::= ELSE common_expression */
  {  429,   -3 }, /* (446) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  429,   -5 }, /* (447) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -6 }, /* (448) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -3 }, /* (449) predicate ::= expr_or_subquery IS NULL */
  {  429,   -4 }, /* (450) predicate ::= expr_or_subquery IS NOT NULL */
  {  429,   -3 }, /* (451) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  430,   -1 }, /* (452) compare_op ::= NK_LT */
  {  430,   -1 }, /* (453) compare_op ::= NK_GT */
  {  430,   -1 }, /* (454) compare_op ::= NK_LE */
  {  430,   -1 }, /* (455) compare_op ::= NK_GE */
  {  430,   -1 }, /* (456) compare_op ::= NK_NE */
  {  430,   -1 }, /* (457) compare_op ::= NK_EQ */
  {  430,   -1 }, /* (458) compare_op ::= LIKE */
  {  430,   -2 }, /* (459) compare_op ::= NOT LIKE */
  {  430,   -1 }, /* (460) compare_op ::= MATCH */
  {  430,   -1 }, /* (461) compare_op ::= NMATCH */
  {  430,   -1 }, /* (462) compare_op ::= CONTAINS */
  {  431,   -1 }, /* (463) in_op ::= IN */
  {  431,   -2 }, /* (464) in_op ::= NOT IN */
  {  432,   -3 }, /* (465) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  433,   -1 }, /* (466) boolean_value_expression ::= boolean_primary */
  {  433,   -2 }, /* (467) boolean_value_expression ::= NOT boolean_primary */
  {  433,   -3 }, /* (468) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  433,   -3 }, /* (469) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  434,   -1 }, /* (470) boolean_primary ::= predicate */
  {  434,   -3 }, /* (471) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  427,   -1 }, /* (472) common_expression ::= expr_or_subquery */
  {  427,   -1 }, /* (473) common_expression ::= boolean_value_expression */
  {  435,    0 }, /* (474) from_clause_opt ::= */
  {  435,   -2 }, /* (475) from_clause_opt ::= FROM table_reference_list */
  {  436,   -1 }, /* (476) table_reference_list ::= table_reference */
  {  436,   -3 }, /* (477) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  437,   -1 }, /* (478) table_reference ::= table_primary */
  {  437,   -1 }, /* (479) table_reference ::= joined_table */
  {  438,   -2 }, /* (480) table_primary ::= table_name alias_opt */
  {  438,   -4 }, /* (481) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  438,   -2 }, /* (482) table_primary ::= subquery alias_opt */
  {  438,   -1 }, /* (483) table_primary ::= parenthesized_joined_table */
  {  440,    0 }, /* (484) alias_opt ::= */
  {  440,   -1 }, /* (485) alias_opt ::= table_alias */
  {  440,   -2 }, /* (486) alias_opt ::= AS table_alias */
  {  442,   -3 }, /* (487) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  442,   -3 }, /* (488) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  439,   -6 }, /* (489) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  443,    0 }, /* (490) join_type ::= */
  {  443,   -1 }, /* (491) join_type ::= INNER */
  {  445,  -12 }, /* (492) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  446,    0 }, /* (493) set_quantifier_opt ::= */
  {  446,   -1 }, /* (494) set_quantifier_opt ::= DISTINCT */
  {  446,   -1 }, /* (495) set_quantifier_opt ::= ALL */
  {  447,   -1 }, /* (496) select_list ::= select_item */
  {  447,   -3 }, /* (497) select_list ::= select_list NK_COMMA select_item */
  {  455,   -1 }, /* (498) select_item ::= NK_STAR */
  {  455,   -1 }, /* (499) select_item ::= common_expression */
  {  455,   -2 }, /* (500) select_item ::= common_expression column_alias */
  {  455,   -3 }, /* (501) select_item ::= common_expression AS column_alias */
  {  455,   -3 }, /* (502) select_item ::= table_name NK_DOT NK_STAR */
  {  410,    0 }, /* (503) where_clause_opt ::= */
  {  410,   -2 }, /* (504) where_clause_opt ::= WHERE search_condition */
  {  448,    0 }, /* (505) partition_by_clause_opt ::= */
  {  448,   -3 }, /* (506) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  456,   -1 }, /* (507) partition_list ::= partition_item */
  {  456,   -3 }, /* (508) partition_list ::= partition_list NK_COMMA partition_item */
  {  457,   -1 }, /* (509) partition_item ::= expr_or_subquery */
  {  457,   -2 }, /* (510) partition_item ::= expr_or_subquery column_alias */
  {  457,   -3 }, /* (511) partition_item ::= expr_or_subquery AS column_alias */
  {  452,    0 }, /* (512) twindow_clause_opt ::= */
  {  452,   -6 }, /* (513) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  452,   -4 }, /* (514) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  452,   -6 }, /* (515) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -8 }, /* (516) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -7 }, /* (517) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  392,    0 }, /* (518) sliding_opt ::= */
  {  392,   -4 }, /* (519) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  451,    0 }, /* (520) fill_opt ::= */
  {  451,   -4 }, /* (521) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  451,   -6 }, /* (522) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  451,   -6 }, /* (523) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  458,   -1 }, /* (524) fill_mode ::= NONE */
  {  458,   -1 }, /* (525) fill_mode ::= PREV */
  {  458,   -1 }, /* (526) fill_mode ::= NULL */
  {  458,   -1 }, /* (527) fill_mode ::= NULL_F */
  {  458,   -1 }, /* (528) fill_mode ::= LINEAR */
  {  458,   -1 }, /* (529) fill_mode ::= NEXT */
  {  453,    0 }, /* (530) group_by_clause_opt ::= */
  {  453,   -3 }, /* (531) group_by_clause_opt ::= GROUP BY group_by_list */
  {  459,   -1 }, /* (532) group_by_list ::= expr_or_subquery */
  {  459,   -3 }, /* (533) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  454,    0 }, /* (534) having_clause_opt ::= */
  {  454,   -2 }, /* (535) having_clause_opt ::= HAVING search_condition */
  {  449,    0 }, /* (536) range_opt ::= */
  {  449,   -6 }, /* (537) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  450,    0 }, /* (538) every_opt ::= */
  {  450,   -4 }, /* (539) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  460,   -4 }, /* (540) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  461,   -1 }, /* (541) query_simple ::= query_specification */
  {  461,   -1 }, /* (542) query_simple ::= union_query_expression */
  {  465,   -4 }, /* (543) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  465,   -3 }, /* (544) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  466,   -1 }, /* (545) query_simple_or_subquery ::= query_simple */
  {  466,   -1 }, /* (546) query_simple_or_subquery ::= subquery */
  {  396,   -1 }, /* (547) query_or_subquery ::= query_expression */
  {  396,   -1 }, /* (548) query_or_subquery ::= subquery */
  {  462,    0 }, /* (549) order_by_clause_opt ::= */
  {  462,   -3 }, /* (550) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  463,    0 }, /* (551) slimit_clause_opt ::= */
  {  463,   -2 }, /* (552) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  463,   -4 }, /* (553) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  463,   -4 }, /* (554) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  464,    0 }, /* (555) limit_clause_opt ::= */
  {  464,   -2 }, /* (556) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  464,   -4 }, /* (557) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  464,   -4 }, /* (558) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  441,   -3 }, /* (559) subquery ::= NK_LP query_expression NK_RP */
  {  441,   -3 }, /* (560) subquery ::= NK_LP subquery NK_RP */
  {  444,   -1 }, /* (561) search_condition ::= common_expression */
  {  467,   -1 }, /* (562) sort_specification_list ::= sort_specification */
  {  467,   -3 }, /* (563) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  468,   -3 }, /* (564) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  469,    0 }, /* (565) ordering_specification_opt ::= */
  {  469,   -1 }, /* (566) ordering_specification_opt ::= ASC */
  {  469,   -1 }, /* (567) ordering_specification_opt ::= DESC */
  {  470,    0 }, /* (568) null_ordering_opt ::= */
  {  470,   -2 }, /* (569) null_ordering_opt ::= NULLS FIRST */
  {  470,   -2 }, /* (570) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy0, yymsp[0].minor.yy857); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy857 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy857 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy303 = yymsp[0].minor.yy303; }
  yymsp[0].minor.yy303 = yylhsminor.yy303;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy303 = yymsp[-2].minor.yy303 | yymsp[0].minor.yy303; }
  yymsp[-2].minor.yy303 = yylhsminor.yy303;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy881; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 42: /* priv_level ::= topic_name */
      case 281: /* sma_func_name ::= function_name */ yytestcase(yyruleno==281);
      case 485: /* alias_opt ::= table_alias */ yytestcase(yyruleno==485);
{ yylhsminor.yy881 = yymsp[0].minor.yy881; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy881, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy587); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy587); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 282: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==282);
      case 283: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==283);
      case 284: /* sma_func_name ::= LAST */ yytestcase(yyruleno==284);
      case 285: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==285);
      case 370: /* db_name ::= NK_ID */ yytestcase(yyruleno==370);
      case 371: /* table_name ::= NK_ID */ yytestcase(yyruleno==371);
      case 372: /* column_name ::= NK_ID */ yytestcase(yyruleno==372);
      case 373: /* function_name ::= NK_ID */ yytestcase(yyruleno==373);
      case 374: /* table_alias ::= NK_ID */ yytestcase(yyruleno==374);
      case 375: /* column_alias ::= NK_ID */ yytestcase(yyruleno==375);
      case 376: /* user_name ::= NK_ID */ yytestcase(yyruleno==376);
      case 377: /* topic_name ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* stream_name ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* index_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 420: /* noarg_func ::= NOW */ yytestcase(yyruleno==420);
      case 421: /* noarg_func ::= TODAY */ yytestcase(yyruleno==421);
      case 422: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==422);
      case 423: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==423);
      case 424: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==424);
      case 425: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==425);
      case 426: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==426);
      case 427: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= USER */ yytestcase(yyruleno==428);
      case 429: /* star_func ::= COUNT */ yytestcase(yyruleno==429);
      case 430: /* star_func ::= FIRST */ yytestcase(yyruleno==430);
      case 431: /* star_func ::= LAST */ yytestcase(yyruleno==431);
      case 432: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==432);
{ yylhsminor.yy881 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 302: /* analyze_opt ::= */ yytestcase(yyruleno==302);
      case 309: /* agg_func_opt ::= */ yytestcase(yyruleno==309);
      case 493: /* set_quantifier_opt ::= */ yytestcase(yyruleno==493);
{ yymsp[1].minor.yy587 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 303: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==303);
      case 310: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==310);
      case 494: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==494);
{ yymsp[0].minor.yy587 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy587, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy214); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy881, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy587 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy587 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy140 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_KEEP, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_RETENTIONS, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy140 = createAlterDatabaseOptions(pCxt); yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yylhsminor.yy140, &yymsp[0].minor.yy809); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy140, &yymsp[0].minor.yy809); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy809.type = DB_OPTION_KEEP; yymsp[-1].minor.yy809.pList = yymsp[0].minor.yy220; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_PAGES; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_WAL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 339: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==339);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy220 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 124: /* retention_list ::= retention */
      case 154: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==154);
      case 157: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==157);
      case 164: /* column_def_list ::= column_def */ yytestcase(yyruleno==164);
      case 208: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==208);
      case 213: /* col_name_list ::= col_name */ yytestcase(yyruleno==213);
      case 264: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==264);
      case 278: /* func_list ::= func */ yytestcase(yyruleno==278);
      case 368: /* literal_list ::= signed_literal */ yytestcase(yyruleno==368);
      case 435: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==435);
      case 441: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==441);
      case 496: /* select_list ::= select_item */ yytestcase(yyruleno==496);
      case 507: /* partition_list ::= partition_item */ yytestcase(yyruleno==507);
      case 562: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==562);
{ yylhsminor.yy220 = createNodeList(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 158: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==158);
      case 165: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==165);
      case 209: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==209);
      case 214: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==214);
      case 265: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==265);
      case 279: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==279);
      case 369: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==369);
      case 436: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==436);
      case 497: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==497);
      case 508: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==508);
      case 563: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==563);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy140 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 127: /* speed_opt ::= */
      case 311: /* bufsize_opt ::= */ yytestcase(yyruleno==311);
{ yymsp[1].minor.yy214 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 312: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==312);
{ yymsp[-1].minor.yy214 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* start_opt ::= */
      case 133: /* end_opt ::= */ yytestcase(yyruleno==133);
      case 258: /* like_pattern_opt ::= */ yytestcase(yyruleno==258);
      case 329: /* subtable_opt ::= */ yytestcase(yyruleno==329);
      case 444: /* case_when_else_opt ::= */ yytestcase(yyruleno==444);
      case 474: /* from_clause_opt ::= */ yytestcase(yyruleno==474);
      case 503: /* where_clause_opt ::= */ yytestcase(yyruleno==503);
      case 512: /* twindow_clause_opt ::= */ yytestcase(yyruleno==512);
      case 518: /* sliding_opt ::= */ yytestcase(yyruleno==518);
      case 520: /* fill_opt ::= */ yytestcase(yyruleno==520);
      case 534: /* having_clause_opt ::= */ yytestcase(yyruleno==534);
      case 536: /* range_opt ::= */ yytestcase(yyruleno==536);
      case 538: /* every_opt ::= */ yytestcase(yyruleno==538);
      case 551: /* slimit_clause_opt ::= */ yytestcase(yyruleno==551);
      case 555: /* limit_clause_opt ::= */ yytestcase(yyruleno==555);
{ yymsp[1].minor.yy140 = NULL; }
        break;
      case 130: /* start_opt ::= START WITH NK_INTEGER */
      case 134: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==134);
{ yymsp[-2].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 131: /* start_opt ::= START WITH NK_STRING */
      case 135: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==135);
{ yymsp[-2].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 132: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 136: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==136);
{ yymsp[-3].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 137: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 139: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==139);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy220, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 138: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 140: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 141: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 142: /* cmd ::= ALTER TABLE alter_table_clause */
      case 341: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==341);
      case 342: /* cmd ::= insert_query */ yytestcase(yyruleno==342);
{ pCxt->pRootNode = yymsp[0].minor.yy140; }
        break;
      case 143: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy140); }
        break;
      case 144: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy140 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 145: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 146: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 147: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 148: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 149: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 150: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 151: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 152: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 153: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy140 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy140, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 155: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 442: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==442);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy220 = yylhsminor.yy220;
        break;
      case 156: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy140 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy587, yymsp[-8].minor.yy140, yymsp[-6].minor.yy140, yymsp[-5].minor.yy220, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-9].minor.yy140 = yylhsminor.yy140;
        break;
      case 159: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy140 = createDropTableClause(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 160: /* specific_cols_opt ::= */
      case 191: /* tags_def_opt ::= */ yytestcase(yyruleno==191);
      case 263: /* tag_list_opt ::= */ yytestcase(yyruleno==263);
      case 315: /* col_list_opt ::= */ yytestcase(yyruleno==315);
      case 317: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==317);
      case 505: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==505);
      case 530: /* group_by_clause_opt ::= */ yytestcase(yyruleno==530);
      case 549: /* order_by_clause_opt ::= */ yytestcase(yyruleno==549);
{ yymsp[1].minor.yy220 = NULL; }
        break;
      case 161: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 316: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==316);
{ yymsp[-2].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 162: /* full_table_name ::= table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 163: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 166: /* column_def ::= column_name type_name */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682, NULL); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 167: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-2].minor.yy682, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 168: /* type_name ::= BOOL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 169: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 170: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 171: /* type_name ::= INT */
      case 172: /* type_name ::= INTEGER */ yytestcase(yyruleno==172);
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 173: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 174: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 175: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 176: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 178: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 180: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 181: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 182: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 183: /* type_name ::= JSON */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 184: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 185: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 186: /* type_name ::= BLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 187: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 188: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 189: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 190: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 192: /* tags_def_opt ::= tags_def */
      case 318: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==318);
      case 434: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==434);
{ yylhsminor.yy220 = yymsp[0].minor.yy220; }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 193: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 319: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==319);
{ yymsp[-3].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 194: /* table_options ::= */
{ yymsp[1].minor.yy140 = createDefaultTableOptions(pCxt); }
        break;
      case 195: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 196: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 197: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 198: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 199: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 200: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_SMA, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 201: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 202: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy140 = createAlterTableOptions(pCxt); yylhsminor.yy140 = setTableOption(pCxt, yylhsminor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 203: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 204: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 205: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 206: /* duration_list ::= duration_literal */
      case 398: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==398);
{ yylhsminor.yy220 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 207: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 399: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==399);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 210: /* rollup_func_name ::= function_name */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 211: /* rollup_func_name ::= FIRST */
      case 212: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==212);
      case 267: /* tag_item ::= QTAGS */ yytestcase(yyruleno==267);
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 215: /* col_name ::= column_name */
      case 268: /* tag_item ::= column_name */ yytestcase(yyruleno==268);
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 216: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 218: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 219: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 220: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 221: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 222: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy140, NULL, OP_TYPE_LIKE); }
        break;
      case 223: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 224: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 227: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 228: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 229: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 230: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW LICENCES */
      case 232: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 233: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 234: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 235: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 236: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 237: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 238: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 239: /* cmd ::= SHOW VARIABLES */
      case 240: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==240);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 241: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 242: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy140); }
        break;
      case 243: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 244: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 245: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 246: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 247: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 248: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 249: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 250: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 251: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140, yymsp[-3].minor.yy220); }
        break;
      case 252: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 253: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 254: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy140,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 255: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 256: /* db_name_cond_opt ::= */
      case 261: /* from_db_opt ::= */ yytestcase(yyruleno==261);
{ yymsp[1].minor.yy140 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 257: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 259: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 260: /* table_name_cond ::= table_name */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 262: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 266: /* tag_item ::= TBNAME */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 269: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 270: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 271: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy587, yymsp[-3].minor.yy140, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 272: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy140, yymsp[-1].minor.yy220, NULL); }
        break;
      case 273: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 274: /* full_index_name ::= index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 275: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 276: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy140 = createIndexOption(pCxt, yymsp[-7].minor.yy220, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 277: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy140 = createIndexOption(pCxt, yymsp[-9].minor.yy220, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 280: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 286: /* sma_stream_opt ::= */
      case 320: /* stream_options ::= */ yytestcase(yyruleno==320);
{ yymsp[1].minor.yy140 = createStreamOptions(pCxt); }
        break;
      case 287: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 288: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 289: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 290: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 291: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy881, false); }
        break;
      case 292: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, &yymsp[0].minor.yy881, true); }
        break;
      case 293: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, yymsp[0].minor.yy140, false); }
        break;
      case 294: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, yymsp[0].minor.yy140, true); }
        break;
      case 295: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 296: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 297: /* cmd ::= DESC full_table_name */
      case 298: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==298);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 299: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 300: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 301: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==301);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy587, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 304: /* explain_options ::= */
{ yymsp[1].minor.yy140 = createDefaultExplainOptions(pCxt); }
        break;
      case 305: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy140 = setExplainVerbose(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 306: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy140 = setExplainRatio(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 307: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy587, yymsp[-8].minor.yy587, &yymsp[-5].minor.yy881, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy682, yymsp[0].minor.yy214); }
        break;
      case 308: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 313: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy587, &yymsp[-8].minor.yy881, yymsp[-5].minor.yy140, yymsp[-7].minor.yy140, yymsp[-3].minor.yy220, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, yymsp[-4].minor.yy220); }
        break;
      case 314: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 321: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 322: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==322);
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 323: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 324: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 325: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 326: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 327: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 328: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 330: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 519: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==519);
      case 539: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==539);
{ yymsp[-3].minor.yy140 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy140); }
        break;
      case 331: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 332: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 333: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 334: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 335: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 336: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy220); }
        break;
      case 337: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 338: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 340: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 343: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy140 = createInsertStmt(pCxt, yymsp[-4].minor.yy140, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 344: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy140 = createInsertStmt(pCxt, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 345: /* literal ::= NK_INTEGER */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 346: /* literal ::= NK_FLOAT */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 347: /* literal ::= NK_STRING */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 348: /* literal ::= NK_BOOL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 349: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 350: /* literal ::= duration_literal */
      case 360: /* signed_literal ::= signed */ yytestcase(yyruleno==360);
      case 381: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==381);
      case 382: /* expression ::= literal */ yytestcase(yyruleno==382);
      case 383: /* expression ::= pseudo_column */ yytestcase(yyruleno==383);
      case 384: /* expression ::= column_reference */ yytestcase(yyruleno==384);
      case 385: /* expression ::= function_expression */ yytestcase(yyruleno==385);
      case 386: /* expression ::= case_when_expression */ yytestcase(yyruleno==386);
      case 417: /* function_expression ::= literal_func */ yytestcase(yyruleno==417);
      case 466: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==466);
      case 470: /* boolean_primary ::= predicate */ yytestcase(yyruleno==470);
      case 472: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==472);
      case 473: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==473);
      case 476: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==476);
      case 478: /* table_reference ::= table_primary */ yytestcase(yyruleno==478);
      case 479: /* table_reference ::= joined_table */ yytestcase(yyruleno==479);
      case 483: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==483);
      case 541: /* query_simple ::= query_specification */ yytestcase(yyruleno==541);
      case 542: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==542);
      case 545: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==545);
      case 547: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==547);
{ yylhsminor.yy140 = yymsp[0].minor.yy140; }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 351: /* literal ::= NULL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 352: /* literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 353: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 354: /* signed ::= NK_INTEGER */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 355: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 356: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 357: /* signed ::= NK_FLOAT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 358: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 359: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 361: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 362: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 363: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 364: /* signed_literal ::= duration_literal */
      case 366: /* signed_literal ::= literal_func */ yytestcase(yyruleno==366);
      case 437: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==437);
      case 499: /* select_item ::= common_expression */ yytestcase(yyruleno==499);
      case 509: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==509);
      case 546: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==546);
      case 548: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==548);
      case 561: /* search_condition ::= common_expression */ yytestcase(yyruleno==561);
{ yylhsminor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 365: /* signed_literal ::= NULL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 367: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 387: /* expression ::= NK_LP expression NK_RP */
      case 471: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==471);
      case 560: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==560);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 388: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy140));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 389: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 390: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 391: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 392: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 393: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 394: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 395: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 396: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 397: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 400: /* column_reference ::= column_name */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy881, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 401: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 402: /* pseudo_column ::= ROWTS */
      case 403: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==403);
      case 405: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==405);
      case 406: /* pseudo_column ::= QEND */ yytestcase(yyruleno==406);
      case 407: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==407);
      case 408: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==408);
      case 409: /* pseudo_column ::= WEND */ yytestcase(yyruleno==409);
      case 410: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==410);
      case 411: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==411);
      case 412: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==413);
      case 419: /* literal_func ::= NOW */ yytestcase(yyruleno==419);
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 404: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy881)))); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 414: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 415: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==415);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 416: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy682)); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 418: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy881, NULL)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 433: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy220 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 438: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 502: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==502);
{ yylhsminor.yy140 = createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 439: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 440: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 443: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy140 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
        break;
      case 445: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
        break;
      case 446: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 451: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==451);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy794, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 447: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 448: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 449: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 450: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL));
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 452: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_THAN; }
        break;
      case 453: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_THAN; }
        break;
      case 454: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 455: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 456: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy794 = OP_TYPE_NOT_EQUAL; }
        break;
      case 457: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy794 = OP_TYPE_EQUAL; }
        break;
      case 458: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy794 = OP_TYPE_LIKE; }
        break;
      case 459: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_LIKE; }
        break;
      case 460: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_MATCH; }
        break;
      case 461: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_NMATCH; }
        break;
      case 462: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy794 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 463: /* in_op ::= IN */
{ yymsp[0].minor.yy794 = OP_TYPE_IN; }
        break;
      case 464: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_IN; }
        break;
      case 465: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 467: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 468: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 469: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 475: /* from_clause_opt ::= FROM table_reference_list */
      case 504: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==504);
      case 535: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==535);
{ yymsp[-1].minor.yy140 = yymsp[0].minor.yy140; }
        break;
      case 477: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 480: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 481: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 482: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy140 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 484: /* alias_opt ::= */
{ yymsp[1].minor.yy881 = nil_token;  }
        break;
      case 486: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy881 = yymsp[0].minor.yy881; }
        break;
      case 487: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 488: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==488);
{ yymsp[-2].minor.yy140 = yymsp[-1].minor.yy140; }
        break;
      case 489: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, yymsp[-4].minor.yy852, yymsp[-5].minor.yy140, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 490: /* join_type ::= */
{ yymsp[1].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 491: /* join_type ::= INNER */
{ yymsp[0].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 492: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy140 = createSelectStmt(pCxt, yymsp[-10].minor.yy587, yymsp[-9].minor.yy220, yymsp[-8].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addWhereClause(pCxt, yymsp[-11].minor.yy140, yymsp[-7].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addPartitionByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-6].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy140, yymsp[-2].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addGroupByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-1].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addHavingClause(pCxt, yymsp[-11].minor.yy140, yymsp[0].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addRangeClause(pCxt, yymsp[-11].minor.yy140, yymsp[-5].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addEveryClause(pCxt, yymsp[-11].minor.yy140, yymsp[-4].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addFillClause(pCxt, yymsp[-11].minor.yy140, yymsp[-3].minor.yy140);
                                                                                  }
        break;
      case 495: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy587 = false; }
        break;
      case 498: /* select_item ::= NK_STAR */
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 500: /* select_item ::= common_expression column_alias */
      case 510: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==510);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 501: /* select_item ::= common_expression AS column_alias */
      case 511: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==511);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 506: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 531: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==531);
      case 550: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==550);
{ yymsp[-2].minor.yy220 = yymsp[0].minor.yy220; }
        break;
      case 513: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy140 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 514: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy140 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 515: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 516: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 517: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy140 = createEventWindowNode(pCxt, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 521: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy140 = createFillNode(pCxt, yymsp[-1].minor.yy174, NULL); }
        break;
      case 522: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 523: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 524: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy174 = FILL_MODE_NONE; }
        break;
      case 525: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy174 = FILL_MODE_PREV; }
        break;
      case 526: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL; }
        break;
      case 527: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL_F; }
        break;
      case 528: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy174 = FILL_MODE_LINEAR; }
        break;
      case 529: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy174 = FILL_MODE_NEXT; }
        break;
      case 532: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy220 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 533: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 537: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy140 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 540: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy140 = addOrderByClause(pCxt, yymsp[-3].minor.yy140, yymsp[-2].minor.yy220);
                                                                                    yylhsminor.yy140 = addSlimitClause(pCxt, yylhsminor.yy140, yymsp[-1].minor.yy140);
                                                                                    yylhsminor.yy140 = addLimitClause(pCxt, yylhsminor.yy140, yymsp[0].minor.yy140);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 543: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 544: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 552: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 556: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==556);
{ yymsp[-1].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 553: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 557: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==557);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 554: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 558: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==558);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 559: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 564: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy140 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[-1].minor.yy866, yymsp[0].minor.yy697); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 565: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy866 = ORDER_ASC; }
        break;
      case 566: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy866 = ORDER_ASC; }
        break;
      case 567: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy866 = ORDER_DESC; }
        break;
      case 568: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy697 = NULL_ORDER_DEFAULT; }
        break;
      case 569: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_FIRST; }
        break;
      case 570: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
