/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 471
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNode* yy140;
  EFillMode yy174;
  int32_t yy214;
  SNodeList* yy220;
  int64_t yy303;
  bool yy587;
  SDataType yy682;
  ENullOrder yy697;
  EOperatorType yy794;
  SAlterOption yy809;
  EJoinType yy852;
  int8_t yy857;
  EOrder yy866;
  SToken yy881;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             745
#define YYNRULE              565
#define YYNTOKEN             329
#define YY_MAX_SHIFT         744
#define YY_MIN_SHIFTREDUCE   1105
#define YY_MAX_SHIFTREDUCE   1669
#define YY_ERROR_ACTION      1670
#define YY_ACCEPT_ACTION     1671
#define YY_NO_ACTION         1672
#define YY_MIN_REDUCE        1673
#define YY_MAX_REDUCE        2237
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3086)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   483,  384,  484, 1709, 1925,  492, 1818,  484, 1709,  161,
 /*    10 */    35,  289,   45,   43, 1597,  190,  360, 2031, 1829,  178,
 /*    20 */   381,  633, 1446,   38,   37, 1878, 2049,   44,   42,   41,
 /*    30 */    40,   39, 1867, 1527,  386, 1444, 2213, 1873, 1875, 1471,
 /*    40 */  2208,  482,   38,   37,  487, 1715,   44,   42,   41,   40,
 /*    50 */    39, 1673, 2027, 2033,  615,  609, 2212, 2067, 1522,   27,
 /*    60 */  2209, 2211,  489,  644,   18,  612,   65, 2152,  485,  176,
 /*    70 */  2017, 1452,  650, 1946,  633,  131,  130,  129,  128,  127,
 /*    80 */   126,  125,  124,  123,   45,   43,  139, 1472, 1944,  621,
 /*    90 */   348, 1929,  381, 2149, 1446,  194,   14,   48,  341,  619,
 /*   100 */   572, 1880, 2048,  501, 2208, 1527, 2084, 1444,  346,  109,
 /*   110 */  2050,  654, 2052, 2053,  649,  106,  644, 1878,  741, 2214,
 /*   120 */   182,  179,  426, 2137, 2209,  598,  633,  375, 2133,  140,
 /*   130 */  1522, 2036,   83, 1529, 1530,   82,   18, 1819, 1471, 1556,
 /*   140 */  1473,  184, 2031, 1452,   44,   42,   41,   40,   39, 2163,
 /*   150 */   167,  464,  268, 2145,  608, 1781,  133,  607,   61, 1446,
 /*   160 */  2208, 1471,  331, 1502, 1512,  373,  609, 2213,   14, 1528,
 /*   170 */  1531, 2208, 1444,  164, 1803,  596,  182, 2027, 2033,  597,
 /*   180 */  2209,  598, 1829, 2208, 1447, 2067, 1445, 2212,  644, 1910,
 /*   190 */   741, 2209, 2210,  591, 1874, 1875, 1557,  139,  596,  182,
 /*   200 */  1308, 1309,   48, 2209,  598, 1529, 1530, 1601, 1452,  198,
 /*   210 */   197, 1450, 1451, 1471, 1501, 1504, 1505, 1506, 1507, 1508,
 /*   220 */  1509, 1510, 1511,  646,  642, 1520, 1521, 1523, 1524, 1525,
 /*   230 */  1526,    2,  463,  533,  532, 1502, 1512,  688,  634,  590,
 /*   240 */   122, 1528, 1531,  121,  120,  119,  118,  117,  116,  115,
 /*   250 */   114,  113,  132,  712,  710,  741, 1447,  491, 1445,  522,
 /*   260 */   487, 1715,  611,  180, 2145, 2146,  620,  137, 2150, 1827,
 /*   270 */    34,  379, 1551, 1552, 1553, 1554, 1555, 1559, 1560, 1561,
 /*   280 */  1562, 1363, 1364, 1450, 1451,  270, 1501, 1504, 1505, 1506,
 /*   290 */  1507, 1508, 1509, 1510, 1511,  646,  642, 1520, 1521, 1523,
 /*   300 */  1524, 1525, 1526,    2, 1503,   11,   45,   43, 1742, 1471,
 /*   310 */  1946,  185, 1880,  499,  381, 1939, 1446, 1696, 1625,  359,
 /*   320 */  2049, 1447,  372, 1445,  592, 1943,  621, 1527, 1878, 1444,
 /*   330 */  1265,  676,  675,  674, 1269,  673, 1271, 1272,  672, 1274,
 /*   340 */   669,  444, 1280,  666, 1282, 1283,  663,  660, 1450, 1451,
 /*   350 */   443, 2067, 1522, 1695, 1472,  185, 1503, 1470,   18,  651,
 /*   360 */  1157, 2017, 1156,  634, 2017, 1452,  650,  584,  583, 1623,
 /*   370 */  1624, 1626, 1627, 1628,  537,  536,  535,  132,   45,   43,
 /*   380 */  1532,  688,  136,  531,  527,   61,  381,  530, 1446, 1985,
 /*   390 */    14, 1158,  529,  534, 1827,  587, 2048, 2017,  528, 1527,
 /*   400 */  2084, 1444, 1880,  109, 2050,  654, 2052, 2053,  649,  369,
 /*   410 */   644, 1138,  741,  142, 1674,  149, 2108, 2137, 1878,   31,
 /*   420 */   634,  375, 2133,   61, 1522,   38,   37, 1529, 1530,   44,
 /*   430 */    42,   41,   40,   39,  187,  122,  238, 1452,  121,  120,
 /*   440 */   119,  118,  117,  116,  115,  114,  113,  537,  536,  535,
 /*   450 */  1140, 1827, 1143, 1144, 1452,  136,  531, 1502, 1512, 1558,
 /*   460 */   530, 1225,   46, 1528, 1531,  529,  534, 1380, 1381,   38,
 /*   470 */    37,  528,  560,   44,   42,   41,   40,   39, 1447,   86,
 /*   480 */  1445,  593,  588,  581,  741,   38,   37,  246,  271,   44,
 /*   490 */    42,   41,   40,   39,  420,   49, 2010, 1227,  419, 1529,
 /*   500 */  1530, 1537, 1823, 1379, 1382, 1450, 1451, 1471, 1501, 1504,
 /*   510 */  1505, 1506, 1507, 1508, 1509, 1510, 1511,  646,  642, 1520,
 /*   520 */  1521, 1523, 1524, 1525, 1526,    2,   61,   90,   92, 1502,
 /*   530 */  1512,  413,  604,   32,  744, 1528, 1531,  236,  185, 2213,
 /*   540 */   572,  235,  572, 1563, 2208, 1804, 2208,  166,  296, 1685,
 /*   550 */  1447,  679, 1445,  176,  415,  411, 1473,  100, 1636, 2214,
 /*   560 */   182, 2214,  182,  175, 2209,  598, 2209,  598,  620,  734,
 /*   570 */   730,  726,  722,  294, 1613, 1930,  185, 1450, 1451, 1820,
 /*   580 */  1501, 1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511,  646,
 /*   590 */   642, 1520, 1521, 1523, 1524, 1525, 1526,    2,   45,   43,
 /*   600 */   620,   89,  336,  221, 1880,  358,  381,  553, 1446,   86,
 /*   610 */   107,  374, 2049,  287, 1157,  618, 1156, 1939,  171, 1527,
 /*   620 */  1878, 1444,   11,  350,  518,  514,  510,  506,  218,  220,
 /*   630 */    38,   37, 1822, 1659,   44,   42,   41,   40,   39,  700,
 /*   640 */   542, 1694, 1474, 2067, 1522, 1158,  630,  629,  185, 1939,
 /*   650 */  1503,  612,  634,  686,  427,  552, 2017, 1452,  650,  280,
 /*   660 */   281,   41,   40,   39,  279,   87,   54,  428,  216,  234,
 /*   670 */    45,   43,  154,  153,  683,  682,  681,  151,  381,  185,
 /*   680 */  1446,  274,   46, 1827,  545, 2017,  273,  609, 2048,  539,
 /*   690 */  1816, 1527, 2084, 1444,  233,  109, 2050,  654, 2052, 2053,
 /*   700 */   649,  270,  644, 1407,  741, 1812,  241,  179,  634, 2137,
 /*   710 */  1814,  634,  634,  375, 2133,   11, 1522,    9,  139, 1529,
 /*   720 */  1530,  636,  424, 2109, 1880,  425,  434, 1925,  597, 1452,
 /*   730 */   567,   69, 2208, 1693,   68, 2164,  215,  209,  192, 1827,
 /*   740 */  1879,  214, 1827, 1827,  497, 1686, 1925,  596,  182, 1502,
 /*   750 */  1512,  237, 2209,  598,   14, 1528, 1531,  196,  551,   38,
 /*   760 */    37,  207,  605,   44,   42,   41,   40,   39,   33,  353,
 /*   770 */  1447,  549, 1445,  547,   38,   37,  741, 2017,   44,   42,
 /*   780 */    41,   40,   39, 1880,  181, 2145, 2146,  248,  137, 2150,
 /*   790 */   385, 1529, 1530, 1671, 2152, 2011, 1810, 1450, 1451, 1878,
 /*   800 */  1501, 1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511,  646,
 /*   810 */   642, 1520, 1521, 1523, 1524, 1525, 1526,    2, 1420, 1421,
 /*   820 */  2148, 1502, 1512,  334, 2152, 1469,  680, 1528, 1531, 1871,
 /*   830 */   678,  354,  457,  352,  351,  471,  524,  634,  470,  384,
 /*   840 */   526,  572, 1447,  141, 1445, 2208, 2108,  164, 1692, 1691,
 /*   850 */  2147,  449,   61,  440,  684,  472, 1829, 1871,  442,  394,
 /*   860 */  2214,  182,  525,  393,  685, 2209,  598, 1871, 1827, 1450,
 /*   870 */  1451, 1690, 1501, 1504, 1505, 1506, 1507, 1508, 1509, 1510,
 /*   880 */  1511,  646,  642, 1520, 1521, 1523, 1524, 1525, 1526,    2,
 /*   890 */   387,  152, 2017, 2017,  165, 2003, 1689,  634,  164,  309,
 /*   900 */   349, 1739, 1802, 2212,  638,  572, 2109, 1829,  641, 2208,
 /*   910 */   164,  450,  430,  307,   72, 2017, 1594,   71,  303, 1830,
 /*   920 */   701, 1857, 1797,  243, 2214,  182,    8, 1666, 1827, 2209,
 /*   930 */   598,   13,   12, 1143, 1144,  203,  479,  477,  474,  418,
 /*   940 */  2017,  417,  468,  401,   53,  462,  461,  460,  459,  456,
 /*   950 */   455,  454,  453,  452,  448,  447,  446,  445,  333,  437,
 /*   960 */   436,  435, 1688,  432,  431,  347,  416,  718,  717,  716,
 /*   970 */   715,  391,   61,  714,  713,  143,  708,  707,  706,  705,
 /*   980 */   704,  703,  702,  156,  698,  697,  696,  390,  389,  693,
 /*   990 */   692,  691,  690,  689,   38,   37, 1782,  609,   44,   42,
 /*  1000 */    41,   40,   39, 1474,  645,  185, 2017, 1687,   38,   37,
 /*  1010 */   686,  108,   44,   42,   41,   40,   39, 2177,  686, 1684,
 /*  1020 */    73, 1683,  558,  601,  526, 2049, 1665, 1570,  139,  154,
 /*  1030 */   153,  683,  682,  681,  151,  634,  634,  154,  153,  683,
 /*  1040 */   682,  681,  151,  265,  634,  634,  525,  634,  634,  500,
 /*  1050 */  1824, 2017,   80,   79,  423, 1548, 2067,  189,  239,  568,
 /*  1060 */   634,  613,  617, 2017,  651, 2017, 1827, 1827,  572, 2017,
 /*  1070 */    81,  650, 2208,  585,  284, 1827, 1827,  332, 1827, 1827,
 /*  1080 */   409,  219,  407,  403,  399,  396,  416, 2214,  182,  259,
 /*  1090 */   634, 1827, 2209,  598,  183, 2145, 2146, 1682,  137, 2150,
 /*  1100 */   634, 2048,  634, 2049,  631, 2084, 1681, 2035,  109, 2050,
 /*  1110 */   654, 2052, 2053,  649,  632,  644,  290, 1474, 2031, 1680,
 /*  1120 */  2228, 1827, 2137, 1729, 1679,  185,  375, 2133,  392,  634,
 /*  1130 */  1678, 1827, 1677, 1827, 2067, 1590, 2049, 2171, 2157, 1590,
 /*  1140 */  1676, 2017,  651,  388,   51,  538,    3, 2017,  191,  650,
 /*  1150 */  2017,  163, 1805, 2027, 2033,  362,  145,  555,  134,  554,
 /*  1160 */  1827, 2035, 1593, 2017,  644, 1455,  226, 2067, 2017,  224,
 /*  1170 */   600, 1934, 2031, 1454, 2017,  651, 2017, 1722,  228, 2048,
 /*  1180 */  2017,  227,  650, 2084, 2017, 2068,  109, 2050,  654, 2052,
 /*  1190 */  2053,  649,  230,  644,  232,  229,  147,  231, 2228,  540,
 /*  1200 */  2137, 1710,  152, 2049,  375, 2133, 2035, 2027, 2033,  363,
 /*  1210 */  1720,  152, 2048,   63,   63, 2184, 2084, 2031,  644,  109,
 /*  1220 */  2050,  654, 2052, 2053,  649,  252,  644,  152, 1668, 1669,
 /*  1230 */  1868, 2228,  543, 2137, 2067,  378,  377,  375, 2133,   47,
 /*  1240 */    13,   12,  651, 2167,  277, 1460,  610, 2017,  579,  650,
 /*  1250 */    52,  602, 2027, 2033,  376, 1415, 1527,  571, 1453, 2038,
 /*  1260 */    70,  105,  247,  644, 1418,  150, 1622, 1621, 2049,  152,
 /*  1270 */    63,  102,   47,   47,  658,  267,  150,  152,  254, 2048,
 /*  1280 */   616, 1522,  135, 2084,  150, 1187,  109, 2050,  654, 2052,
 /*  1290 */  2053,  649, 1377,  644, 1452,  694,  264,  282, 2228, 2067,
 /*  1300 */  2137, 2049,    1,    4,  375, 2133,  695,  651, 2040,  395,
 /*  1310 */   400, 1400, 2017,  626,  650, 2202, 1458, 1206,  286, 1716,
 /*  1320 */   345, 1188, 1258, 1564, 1457, 1513,  302, 1286, 1204, 1290,
 /*  1330 */  1297,  297, 2067,  195,  429, 1295, 1935,  155, 1474,  433,
 /*  1340 */   651,  640,  466,  438, 2048, 2017, 1469,  650, 2084,  451,
 /*  1350 */  1927,  109, 2050,  654, 2052, 2053,  649,  458,  644,  465,
 /*  1360 */   473,  467,  475, 2228,  476, 2137,  200,  478,  736,  375,
 /*  1370 */  2133,  480, 1475,  481,  490, 1477,  493, 2048,  206, 1472,
 /*  1380 */  2156, 2084,  494,  208,  109, 2050,  654, 2052, 2053,  649,
 /*  1390 */  1476,  644,  495, 1478,  496,  211, 2112, 2049, 2137,  498,
 /*  1400 */   213,   84,  375, 2133,  502,   85,  217, 1461, 1160, 1456,
 /*  1410 */   519,  520,  112,  521,  335,  557,  523, 1994, 1991, 1817,
 /*  1420 */   223, 1990,  559,   88, 1813,  225,  157,  148, 2067,  569,
 /*  1430 */   240,  298,  158, 1815, 1464, 1466,  651, 1811,  159,  160,
 /*  1440 */   563, 2017,  562,  650,  561,  242,  586,  642, 1520, 1521,
 /*  1450 */  1523, 1524, 1525, 1526,  244,  566, 2183, 2168, 2049, 2178,
 /*  1460 */   576,  624, 2182,  582,  364,    7,  589, 2159,  260,  595,
 /*  1470 */   258,  577,  250, 2048,  253,  172,  575, 2084,  261,  574,
 /*  1480 */   109, 2050,  654, 2052, 2053,  649,  606,  644,  603, 2067,
 /*  1490 */   365,  262, 2110, 2231, 2137, 1590,  266,  651,  375, 2133,
 /*  1500 */  2207,  263, 2017,  138,  650, 1473,  614, 2153, 2049,  368,
 /*  1510 */  1940, 1479,  622,  299,  627,  272,   95,  623, 1954, 1953,
 /*  1520 */  1952,  371,  300,  628, 1828, 1872,   97,   60,   99,  101,
 /*  1530 */  2118, 2049,  301,  304, 2048,  293,  737,   50, 2084, 2067,
 /*  1540 */   738,  109, 2050,  654, 2052, 2053,  649,  651,  644, 1798,
 /*  1550 */   328,  337, 2017,  637,  650, 2137,  656, 2009,  740,  375,
 /*  1560 */  2133,  313, 2067,  327,  317,  306,  338,  308, 2008, 2007,
 /*  1570 */   651,   77, 2004,  397,  398, 2017, 1437,  650, 1438,  188,
 /*  1580 */   402, 2049, 2002,  404, 2048,  405,  406, 2001, 2084,  408,
 /*  1590 */  2000,  110, 2050,  654, 2052, 2053,  649,  410,  644, 1999,
 /*  1600 */   412, 1998,  414,   78, 1403, 2137, 1402, 2048, 1966, 2136,
 /*  1610 */  2133, 2084, 2067, 1965,  110, 2050,  654, 2052, 2053,  649,
 /*  1620 */   651,  644, 1964,  421,  422, 2017, 1963,  650, 2137, 1962,
 /*  1630 */  1354, 2049,  639, 2133, 1918, 1917, 1915,  144, 1914, 1913,
 /*  1640 */  1916, 1912, 1911, 1909, 1908, 1907,  193,  439, 2049, 1906,
 /*  1650 */   441, 1920, 1905, 1904, 1903, 1902, 1901,  652, 1900, 1899,
 /*  1660 */  1898, 2084, 2067, 1897,  110, 2050,  654, 2052, 2053,  649,
 /*  1670 */   648,  644, 1896, 1895, 1894, 2017, 1893,  650, 2137, 2067,
 /*  1680 */  1892, 1891,  340, 2133, 1890, 1889, 1888,  651,  146, 1919,
 /*  1690 */  1887, 1886, 2017, 1356,  650,  469, 1882, 1881, 2049, 1885,
 /*  1700 */  1884, 1883, 1745, 1233, 1744,  199,  201, 2048, 1743, 1741,
 /*  1710 */  1705, 2084,  204,  177,  325, 2050,  654, 2052, 2053,  649,
 /*  1720 */   647,  644,  635, 2102, 2048,  202,   75, 1146, 2084, 2067,
 /*  1730 */  2037,  168, 2050,  654, 2052, 2053,  649,  651,  644,  486,
 /*  1740 */  1145,  488, 2017, 1704,  650,  205,   76, 1981, 1973, 1961,
 /*  1750 */   210,  212, 1960, 1938, 1806, 1740, 1738,  503, 1180,  505,
 /*  1760 */  1736, 2049,  504,  507,  508, 1734,  509,  511,  513,  512,
 /*  1770 */  1732,  515,  573, 2174, 2048, 1719,  517, 1718, 2084,  516,
 /*  1780 */  1701,  169, 2050,  654, 2052, 2053,  649, 1808,  644, 1301,
 /*  1790 */  1807, 1730, 2067,   62, 1302,  709, 1224, 1223, 1222, 1221,
 /*  1800 */   651,  222,  711, 1218, 1217, 2017, 1216,  650, 1215, 1723,
 /*  1810 */   355,  356, 1721,  544,  357, 1700,  541,  546, 1699, 1698,
 /*  1820 */   548,  550, 2049,  111, 1980, 1972,   55, 1411,  564, 1425,
 /*  1830 */  1427, 1424, 1429,  599, 2229,   26,   66, 2048, 1959, 1409,
 /*  1840 */   565, 2084, 1957,  361,  110, 2050,  654, 2052, 2053,  649,
 /*  1850 */   570,  644,  162, 2067, 2213,   19,   16,  578, 2137,  580,
 /*  1860 */    58,  651,   20, 2134,   59,  256, 2017,   28,  650, 1638,
 /*  1870 */   245,  251, 2049, 1620,  257,  249, 2038,  170,    5,  255,
 /*  1880 */    30,   64,   29,   21,   17, 1653, 1958,    6, 2049,   57,
 /*  1890 */  1652,  366, 1657, 1656, 1612, 1658,   91,  367, 2048, 1659,
 /*  1900 */   269, 1956, 2084, 2067, 1587,  168, 2050,  654, 2052, 2053,
 /*  1910 */   649,  651,  644,   56, 1586,  173, 2017, 1955,  650, 2067,
 /*  1920 */  1937,   94,   93,  275,   22,  625,  278,  651,  276, 1618,
 /*  1930 */   283,   67, 2017, 1936,  650,   96,   98,  288,   23,  102,
 /*  1940 */    12, 1462, 2087,  643, 1549, 1517, 1515, 2175, 2048, 2049,
 /*  1950 */  1539,   10, 2084,  174,  186,  319, 2050,  654, 2052, 2053,
 /*  1960 */   649,   36,  644, 1514, 2048, 2049, 1538,  285, 2084,   15,
 /*  1970 */    24,  169, 2050,  654, 2052, 2053,  649, 1486,  644, 1494,
 /*  1980 */  2067,   25,  655,  657, 1287,  370,  383,  659,  651, 1284,
 /*  1990 */   661,  662, 1279, 2017, 1281,  650, 2067,  664,  665,  594,
 /*  2000 */  1275,  667, 1273,  670,  648,  668,  671, 1264, 1278, 2017,
 /*  2010 */   103,  650,  677, 1277,  291, 1296, 1292,  104, 1276,   74,
 /*  2020 */   687,  653, 1212, 1178, 2230, 2048, 1211, 2049, 1210, 2084,
 /*  2030 */  1209, 1208,  326, 2050,  654, 2052, 2053,  649, 1207,  644,
 /*  2040 */  1231, 2048, 1205, 1203, 2049, 2084, 1202, 1201,  325, 2050,
 /*  2050 */   654, 2052, 2053,  649,  699,  644, 1199, 2103, 2067,  292,
 /*  2060 */  1198, 1197, 2049,  380, 1196, 1195,  651, 1194, 1193, 1228,
 /*  2070 */  1226, 2017, 1190,  650, 1189, 2067, 1186, 1184, 1185, 1183,
 /*  2080 */   382, 1737,  719,  651,  720,  721, 1735,  723, 2017,  725,
 /*  2090 */   650, 1733,  727, 2067, 1731,  729,  724,  728,  733,  731,
 /*  2100 */  1717,  651,  732, 2048,  735, 1135, 2017, 2084,  650, 1697,
 /*  2110 */   326, 2050,  654, 2052, 2053,  649,  739,  644,  295, 1448,
 /*  2120 */  2048,  305,  742,  743, 2084, 2049, 1672,  326, 2050,  654,
 /*  2130 */  2052, 2053,  649, 1672,  644, 1672, 1672, 1672,  556, 1672,
 /*  2140 */  1672, 1672, 2084, 1672, 1672,  321, 2050,  654, 2052, 2053,
 /*  2150 */   649, 1672,  644, 1672, 1672, 1672, 2067, 1672, 1672, 1672,
 /*  2160 */  1672, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672, 2017,
 /*  2170 */  1672,  650, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2180 */  1672, 1672, 1672, 1672, 1672, 1672, 2049, 1672, 1672, 1672,
 /*  2190 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2200 */  1672, 2048, 1672, 1672, 1672, 2084, 1672, 1672,  310, 2050,
 /*  2210 */   654, 2052, 2053,  649, 1672,  644, 1672, 2067, 1672, 1672,
 /*  2220 */  1672, 2049, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672,
 /*  2230 */  2017, 1672,  650, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2240 */  1672, 1672, 1672, 1672, 2049, 1672, 1672, 1672, 1672, 1672,
 /*  2250 */  1672, 1672, 2067, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2260 */   651, 1672, 2048, 1672, 1672, 2017, 2084,  650, 1672,  311,
 /*  2270 */  2050,  654, 2052, 2053,  649, 2067,  644, 1672, 1672, 1672,
 /*  2280 */  1672, 1672, 1672,  651, 1672, 1672, 1672, 1672, 2017, 1672,
 /*  2290 */   650, 1672, 1672, 1672, 1672, 1672, 1672, 2048, 1672, 1672,
 /*  2300 */  1672, 2084, 1672, 1672,  312, 2050,  654, 2052, 2053,  649,
 /*  2310 */  1672,  644, 1672, 2049, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2320 */  2048, 1672, 1672, 1672, 2084, 1672, 1672,  318, 2050,  654,
 /*  2330 */  2052, 2053,  649, 1672,  644, 1672, 1672, 2049, 1672, 1672,
 /*  2340 */  1672, 1672, 1672, 1672, 2067, 1672, 1672, 1672, 1672, 1672,
 /*  2350 */  1672, 1672,  651, 1672, 1672, 1672, 1672, 2017, 1672,  650,
 /*  2360 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 2067, 1672,
 /*  2370 */  1672, 1672, 1672, 1672, 1672, 1672,  651, 1672, 1672, 1672,
 /*  2380 */  1672, 2017, 1672,  650, 1672, 1672, 1672, 1672, 1672, 2048,
 /*  2390 */  1672, 1672, 1672, 2084, 1672, 2049,  322, 2050,  654, 2052,
 /*  2400 */  2053,  649, 1672,  644, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2410 */  1672, 1672, 1672, 2048, 1672, 1672, 2049, 2084, 1672, 1672,
 /*  2420 */   314, 2050,  654, 2052, 2053,  649, 2067,  644, 1672, 1672,
 /*  2430 */  1672, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672, 2017,
 /*  2440 */  1672,  650, 1672, 1672, 1672, 2049, 1672, 2067, 1672, 1672,
 /*  2450 */  1672, 1672, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672,
 /*  2460 */  2017, 1672,  650, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2470 */  1672, 2048, 1672, 1672, 1672, 2084, 2067, 1672,  323, 2050,
 /*  2480 */   654, 2052, 2053,  649,  651,  644, 1672, 1672, 1672, 2017,
 /*  2490 */  1672,  650, 2048, 1672, 1672, 1672, 2084, 1672, 1672,  315,
 /*  2500 */  2050,  654, 2052, 2053,  649, 1672,  644, 1672, 1672, 1672,
 /*  2510 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 2049,
 /*  2520 */  1672, 2048, 1672, 1672, 1672, 2084, 1672, 1672,  324, 2050,
 /*  2530 */   654, 2052, 2053,  649, 1672,  644, 1672, 1672, 2049, 1672,
 /*  2540 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2550 */  2067, 1672, 1672, 1672, 2049, 1672, 1672, 1672,  651, 1672,
 /*  2560 */  1672, 1672, 1672, 2017, 1672,  650, 1672, 1672, 1672, 2067,
 /*  2570 */  1672, 1672, 1672, 1672, 1672, 1672, 1672,  651, 1672, 1672,
 /*  2580 */  1672, 1672, 2017, 1672,  650, 2067, 1672, 1672, 1672, 1672,
 /*  2590 */  1672, 1672, 1672,  651, 1672, 2048, 1672, 1672, 2017, 2084,
 /*  2600 */   650, 1672,  316, 2050,  654, 2052, 2053,  649, 1672,  644,
 /*  2610 */  1672, 1672, 1672, 1672, 2048, 1672, 2049, 1672, 2084, 1672,
 /*  2620 */  1672,  329, 2050,  654, 2052, 2053,  649, 1672,  644, 1672,
 /*  2630 */  2048, 1672, 1672, 1672, 2084, 1672, 1672,  330, 2050,  654,
 /*  2640 */  2052, 2053,  649, 1672,  644, 1672, 1672, 2067, 1672, 1672,
 /*  2650 */  1672, 1672, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672,
 /*  2660 */  2017, 1672,  650, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2670 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 2049, 1672, 1672,
 /*  2680 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2690 */  1672, 1672, 2048, 1672, 1672, 1672, 2084, 1672, 1672, 2061,
 /*  2700 */  2050,  654, 2052, 2053,  649, 1672,  644, 1672, 2067, 1672,
 /*  2710 */  1672, 1672, 1672, 1672, 1672, 1672,  651, 1672, 1672, 1672,
 /*  2720 */  1672, 2017, 1672,  650, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2730 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2740 */  1672, 1672, 1672, 1672, 1672, 1672, 2049, 1672, 1672, 1672,
 /*  2750 */  1672, 1672, 1672, 2048, 1672, 1672, 1672, 2084, 1672, 1672,
 /*  2760 */  2060, 2050,  654, 2052, 2053,  649, 1672,  644, 1672, 1672,
 /*  2770 */  1672, 1672, 2049, 1672, 1672, 1672, 1672, 2067, 1672, 1672,
 /*  2780 */  1672, 1672, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672,
 /*  2790 */  2017, 1672,  650, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2800 */  1672, 1672, 1672, 2067, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2810 */  1672,  651, 1672, 1672, 1672, 1672, 2017, 1672,  650, 1672,
 /*  2820 */  1672, 1672, 2048, 1672, 1672, 1672, 2084, 1672, 1672, 2059,
 /*  2830 */  2050,  654, 2052, 2053,  649, 2049,  644, 1672, 1672, 1672,
 /*  2840 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 2048, 1672,
 /*  2850 */  1672, 1672, 2084, 1672, 2049,  342, 2050,  654, 2052, 2053,
 /*  2860 */   649, 1672,  644, 1672, 1672, 1672, 2067, 1672, 1672, 1672,
 /*  2870 */  1672, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672, 2017,
 /*  2880 */  1672,  650, 1672, 1672, 1672, 2067, 1672, 1672, 1672, 1672,
 /*  2890 */  1672, 1672, 1672,  651, 1672, 1672, 1672, 1672, 2017, 1672,
 /*  2900 */   650, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2910 */  1672, 2048, 1672, 1672, 1672, 2084, 1672, 2049,  343, 2050,
 /*  2920 */   654, 2052, 2053,  649, 1672,  644, 1672, 1672, 1672, 1672,
 /*  2930 */  2048, 1672, 1672, 2049, 2084, 1672, 1672,  339, 2050,  654,
 /*  2940 */  2052, 2053,  649, 1672,  644, 1672, 1672, 1672, 2067, 1672,
 /*  2950 */  1672, 1672, 1672, 1672, 1672, 1672,  651, 1672, 1672, 1672,
 /*  2960 */  1672, 2017, 1672,  650, 2067, 1672, 1672, 1672, 1672, 1672,
 /*  2970 */  1672, 1672,  651, 1672, 1672, 1672, 1672, 2017, 1672,  650,
 /*  2980 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  2990 */  1672, 1672, 1672, 2048, 1672, 2049, 1672, 2084, 1672, 1672,
 /*  3000 */   344, 2050,  654, 2052, 2053,  649, 1672,  644, 1672,  652,
 /*  3010 */  1672, 1672, 1672, 2084, 1672, 1672,  321, 2050,  654, 2052,
 /*  3020 */  2053,  649, 1672,  644, 1672, 1672, 2067, 1672, 1672, 1672,
 /*  3030 */  1672, 1672, 1672, 1672,  651, 1672, 1672, 1672, 1672, 2017,
 /*  3040 */  1672,  650, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  3050 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  3060 */  1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672, 1672,
 /*  3070 */  1672, 2048, 1672, 1672, 1672, 2084, 1672, 1672,  320, 2050,
 /*  3080 */   654, 2052, 2053,  649, 1672,  644,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   336,  355,  338,  339,  371,  336,  365,  338,  339,  363,
 /*    10 */   430,  431,   12,   13,   14,  382,  370,  376,  372,  362,
 /*    20 */    20,   20,   22,    8,    9,  379,  332,   12,   13,   14,
 /*    30 */    15,   16,  375,   33,  374,   35,  441,  377,  378,   20,
 /*    40 */   445,  337,    8,    9,  340,  341,   12,   13,   14,   15,
 /*    50 */    16,    0,  411,  412,  395,  340,  461,  363,   58,   44,
 /*    60 */   465,  466,   14,  422,   64,  371,    4,  414,   20,  363,
 /*    70 */   376,   71,  378,  378,   20,   24,   25,   26,   27,   28,
 /*    80 */    29,   30,   31,   32,   12,   13,  371,   20,  393,  394,
 /*    90 */   384,  385,   20,  440,   22,   58,   96,   96,   64,   20,
 /*   100 */   441,  363,  408,   63,  445,   33,  412,   35,  370,  415,
 /*   110 */   416,  417,  418,  419,  420,  344,  422,  379,  118,  460,
 /*   120 */   461,  427,  340,  429,  465,  466,   20,  433,  434,  358,
 /*   130 */    58,  365,   95,  133,  134,   98,   64,  366,   20,  105,
 /*   140 */    20,  447,  376,   71,   12,   13,   14,   15,   16,  455,
 /*   150 */   347,   80,  437,  438,  439,  352,  441,  442,   96,   22,
 /*   160 */   445,   20,  380,  163,  164,  355,  340,  441,   96,  169,
 /*   170 */   170,  445,   35,  363,    0,  460,  461,  411,  412,  441,
 /*   180 */   465,  466,  372,  445,  184,  363,  186,  461,  422,    0,
 /*   190 */   118,  465,  466,  371,  377,  378,  162,  371,  460,  461,
 /*   200 */   133,  134,   96,  465,  466,  133,  134,   14,   71,  138,
 /*   210 */   139,  211,  212,   20,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  161,  349,  350,  163,  164,   63,  340,  417,
 /*   240 */    21,  169,  170,   24,   25,   26,   27,   28,   29,   30,
 /*   250 */    31,   32,  354,  349,  350,  118,  184,  337,  186,  361,
 /*   260 */   340,  341,  436,  437,  438,  439,  340,  441,  442,  371,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  244,  245,
 /*   280 */   246,  163,  164,  211,  212,  165,  214,  215,  216,  217,
 /*   290 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   300 */   228,  229,  230,  231,  163,  233,   12,   13,    0,   20,
 /*   310 */   378,  249,  363,  387,   20,  389,   22,  332,  211,  370,
 /*   320 */   332,  184,  390,  186,   20,  393,  394,   33,  379,   35,
 /*   330 */   109,  110,  111,  112,  113,  114,  115,  116,  117,  118,
 /*   340 */   119,  152,  121,  122,  123,  124,  125,  126,  211,  212,
 /*   350 */   161,  363,   58,  332,   20,  249,  163,   20,   64,  371,
 /*   360 */    20,  376,   22,  340,  376,   71,  378,  260,  261,  262,
 /*   370 */   263,  264,  265,  266,   66,   67,   68,  354,   12,   13,
 /*   380 */    14,   63,   74,   75,  361,   96,   20,   79,   22,  359,
 /*   390 */    96,   51,   84,   85,  371,  168,  408,  376,   90,   33,
 /*   400 */   412,   35,  363,  415,  416,  417,  418,  419,  420,  370,
 /*   410 */   422,    4,  118,  425,    0,  427,  428,  429,  379,    2,
 /*   420 */   340,  433,  434,   96,   58,    8,    9,  133,  134,   12,
 /*   430 */    13,   14,   15,   16,  354,   21,  406,   71,   24,   25,
 /*   440 */    26,   27,   28,   29,   30,   31,   32,   66,   67,   68,
 /*   450 */    43,  371,   45,   46,   71,   74,   75,  163,  164,  162,
 /*   460 */    79,   35,   96,  169,  170,   84,   85,  133,  134,    8,
 /*   470 */     9,   90,  107,   12,   13,   14,   15,   16,  184,  346,
 /*   480 */   186,  254,  255,  256,  118,    8,    9,   58,   58,   12,
 /*   490 */    13,   14,   15,   16,  395,   96,  395,   71,  399,  133,
 /*   500 */   134,   14,  369,  169,  170,  211,  212,   20,  214,  215,
 /*   510 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   520 */   226,  227,  228,  229,  230,  231,   96,   98,   98,  163,
 /*   530 */   164,  179,   44,  236,   19,  169,  170,  128,  249,    3,
 /*   540 */   441,  132,  441,  246,  445,    0,  445,  331,   33,  333,
 /*   550 */   184,  107,  186,  363,  202,  203,   20,  344,   97,  460,
 /*   560 */   461,  460,  461,   48,  465,  466,  465,  466,  340,   54,
 /*   570 */    55,   56,   57,   58,   97,  385,  249,  211,  212,  366,
 /*   580 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   590 */   224,  225,  226,  227,  228,  229,  230,  231,   12,   13,
 /*   600 */   340,  192,  193,   33,  363,  196,   20,  198,   22,  346,
 /*   610 */    95,  370,  332,   98,   20,  387,   22,  389,   48,   33,
 /*   620 */   379,   35,  233,  360,   54,   55,   56,   57,   58,   35,
 /*   630 */     8,    9,  369,   97,   12,   13,   14,   15,   16,   71,
 /*   640 */     4,  332,   20,  363,   58,   51,  131,  387,  249,  389,
 /*   650 */   163,  371,  340,  108,   22,   19,  376,   71,  378,  127,
 /*   660 */   128,   14,   15,   16,  132,   95,  354,   35,   98,   33,
 /*   670 */    12,   13,  127,  128,  129,  130,  131,  132,   20,  249,
 /*   680 */    22,  166,   96,  371,   48,  376,  171,  340,  408,   53,
 /*   690 */   364,   33,  412,   35,   58,  415,  416,  417,  418,  419,
 /*   700 */   420,  165,  422,  188,  118,  364,  191,  427,  340,  429,
 /*   710 */   364,  340,  340,  433,  434,  233,   58,  235,  371,  133,
 /*   720 */   134,  426,  354,  428,  363,  354,  354,  371,  441,   71,
 /*   730 */   400,   95,  445,  332,   98,  455,  166,  167,  382,  371,
 /*   740 */   379,  171,  371,  371,  174,  333,  371,  460,  461,  163,
 /*   750 */   164,  127,  465,  466,   96,  169,  170,  382,   21,    8,
 /*   760 */     9,  191,  274,   12,   13,   14,   15,   16,    2,   37,
 /*   770 */   184,   34,  186,   36,    8,    9,  118,  376,   12,   13,
 /*   780 */    14,   15,   16,  363,  437,  438,  439,  165,  441,  442,
 /*   790 */   370,  133,  134,  329,  414,  395,  364,  211,  212,  379,
 /*   800 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   810 */   224,  225,  226,  227,  228,  229,  230,  231,  194,  195,
 /*   820 */   440,  163,  164,   18,  414,   20,  373,  169,  170,  376,
 /*   830 */   364,   99,   27,  101,  102,   30,  104,  340,   33,  355,
 /*   840 */   108,  441,  184,  425,  186,  445,  428,  363,  332,  332,
 /*   850 */   440,  354,   96,   48,  373,   50,  372,  376,   53,  395,
 /*   860 */   460,  461,  130,  399,  373,  465,  466,  376,  371,  211,
 /*   870 */   212,  332,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   880 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   890 */   355,   44,  376,  376,   18,    0,  332,  340,  363,   23,
 /*   900 */    95,    0,    0,    3,  426,  441,  428,  372,   64,  445,
 /*   910 */   363,  354,  107,   37,   38,  376,    4,   41,  356,  372,
 /*   920 */   351,  359,  353,  364,  460,  461,   39,  176,  371,  465,
 /*   930 */   466,    1,    2,   45,   46,   59,   60,   61,   62,  183,
 /*   940 */   376,  185,  137,   48,   97,  140,  141,  142,  143,  144,
 /*   950 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   960 */   155,  156,  332,  158,  159,  160,  210,   66,   67,   68,
 /*   970 */    69,   70,   96,   72,   73,   74,   75,   76,   77,   78,
 /*   980 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   990 */    89,   90,   91,   92,    8,    9,  352,  340,   12,   13,
 /*  1000 */    14,   15,   16,   20,  364,  249,  376,  332,    8,    9,
 /*  1010 */   108,  135,   12,   13,   14,   15,   16,  386,  108,  332,
 /*  1020 */   107,  332,  395,   44,  108,  332,  275,   97,  371,  127,
 /*  1030 */   128,  129,  130,  131,  132,  340,  340,  127,  128,  129,
 /*  1040 */   130,  131,  132,  469,  340,  340,  130,  340,  340,  354,
 /*  1050 */   354,  376,  176,  177,  178,  211,  363,  181,  354,  354,
 /*  1060 */   340,  354,  354,  376,  371,  376,  371,  371,  441,  376,
 /*  1070 */   157,  378,  445,  458,  354,  371,  371,  201,  371,  371,
 /*  1080 */   204,  342,  206,  207,  208,  209,  210,  460,  461,  452,
 /*  1090 */   340,  371,  465,  466,  437,  438,  439,  332,  441,  442,
 /*  1100 */   340,  408,  340,  332,  354,  412,  332,  365,  415,  416,
 /*  1110 */   417,  418,  419,  420,  354,  422,  354,   20,  376,  332,
 /*  1120 */   427,  371,  429,    0,  332,  249,  433,  434,  342,  340,
 /*  1130 */   332,  371,  332,  371,  363,  248,  332,  444,  247,  248,
 /*  1140 */   332,  376,  371,  354,   42,   22,   44,  376,  165,  378,
 /*  1150 */   376,  165,    0,  411,  412,  413,   42,  197,   44,  199,
 /*  1160 */   371,  365,  250,  376,  422,   35,  100,  363,  376,  103,
 /*  1170 */   270,  386,  376,   35,  376,  371,  376,    0,  100,  408,
 /*  1180 */   376,  103,  378,  412,  376,  363,  415,  416,  417,  418,
 /*  1190 */   419,  420,  100,  422,  100,  103,   44,  103,  427,   22,
 /*  1200 */   429,  339,   44,  332,  433,  434,  365,  411,  412,  413,
 /*  1210 */     0,   44,  408,   44,   44,  444,  412,  376,  422,  415,
 /*  1220 */   416,  417,  418,  419,  420,   44,  422,   44,  133,  134,
 /*  1230 */   375,  427,   22,  429,  363,   12,   13,  433,  434,   44,
 /*  1240 */     1,    2,  371,  386,   44,   22,  443,  376,  444,  378,
 /*  1250 */   165,  272,  411,  412,  413,   97,   33,  172,   35,   47,
 /*  1260 */    44,   96,  165,  422,   97,   44,   97,   97,  332,   44,
 /*  1270 */    44,  106,   44,   44,   44,  462,   44,   44,   97,  408,
 /*  1280 */    97,   58,   44,  412,   44,   35,  415,  416,  417,  418,
 /*  1290 */   419,  420,   97,  422,   71,   13,  435,   97,  427,  363,
 /*  1300 */   429,  332,  446,  251,  433,  434,   13,  371,   96,  410,
 /*  1310 */    48,  182,  376,   97,  378,  444,  186,   35,   97,    0,
 /*  1320 */   409,   71,   97,   97,  186,   97,   97,   97,   35,   97,
 /*  1330 */    97,  397,  363,   42,  383,   97,  386,   97,   20,  383,
 /*  1340 */   371,  118,  162,  381,  408,  376,   20,  378,  412,  340,
 /*  1350 */   340,  415,  416,  417,  418,  419,  420,  383,  422,  381,
 /*  1360 */   340,  381,   94,  427,  348,  429,  340,  340,   49,  433,
 /*  1370 */   434,  340,   20,  334,  334,   20,  403,  408,  346,   20,
 /*  1380 */   444,  412,  378,  346,  415,  416,  417,  418,  419,  420,
 /*  1390 */    20,  422,  341,   20,  396,  346,  427,  332,  429,  341,
 /*  1400 */   346,  346,  433,  434,  340,  346,  346,  184,   52,  186,
 /*  1410 */   343,  343,  340,  334,  334,  200,  363,  376,  376,  363,
 /*  1420 */   363,  376,  407,   96,  363,  363,  363,  405,  363,  340,
 /*  1430 */   344,  403,  363,  363,  211,  212,  371,  363,  363,  363,
 /*  1440 */   402,  376,  190,  378,  189,  401,  259,  224,  225,  226,
 /*  1450 */   227,  228,  229,  230,  344,  378,  451,  386,  332,  386,
 /*  1460 */   376,  258,  451,  376,  376,  267,  376,  454,  450,  175,
 /*  1470 */   453,  269,  391,  408,  391,  451,  268,  412,  449,  252,
 /*  1480 */   415,  416,  417,  418,  419,  420,  273,  422,  271,  363,
 /*  1490 */   276,  448,  427,  470,  429,  248,  463,  371,  433,  434,
 /*  1500 */   464,  410,  376,  371,  378,   20,  340,  414,  332,  341,
 /*  1510 */   389,   20,  376,  391,  167,  344,  344,  376,  376,  376,
 /*  1520 */   376,  376,  391,  388,  371,  376,  344,   96,  344,   96,
 /*  1530 */   432,  332,  359,  340,  408,  344,   36,  398,  412,  363,
 /*  1540 */   335,  415,  416,  417,  418,  419,  420,  371,  422,  353,
 /*  1550 */   404,  392,  376,  427,  378,  429,  367,    0,  334,  433,
 /*  1560 */   434,  357,  363,  357,  357,  345,  392,  330,    0,    0,
 /*  1570 */   371,   42,    0,   35,  205,  376,   35,  378,   35,   35,
 /*  1580 */   205,  332,    0,   35,  408,   35,  205,    0,  412,  205,
 /*  1590 */     0,  415,  416,  417,  418,  419,  420,   35,  422,    0,
 /*  1600 */    22,    0,   35,  192,  186,  429,  184,  408,    0,  433,
 /*  1610 */   434,  412,  363,    0,  415,  416,  417,  418,  419,  420,
 /*  1620 */   371,  422,    0,  180,  179,  376,    0,  378,  429,    0,
 /*  1630 */    47,  332,  433,  434,    0,    0,    0,   42,    0,    0,
 /*  1640 */     0,    0,    0,    0,    0,    0,  152,   35,  332,    0,
 /*  1650 */   152,    0,    0,    0,    0,    0,    0,  408,    0,    0,
 /*  1660 */     0,  412,  363,    0,  415,  416,  417,  418,  419,  420,
 /*  1670 */   371,  422,    0,    0,    0,  376,    0,  378,  429,  363,
 /*  1680 */     0,    0,  433,  434,    0,    0,    0,  371,   42,    0,
 /*  1690 */     0,    0,  376,   22,  378,  136,    0,    0,  332,    0,
 /*  1700 */     0,    0,    0,   35,    0,   58,   58,  408,    0,    0,
 /*  1710 */     0,  412,   42,   44,  415,  416,  417,  418,  419,  420,
 /*  1720 */   421,  422,  423,  424,  408,   58,   39,   14,  412,  363,
 /*  1730 */    47,  415,  416,  417,  418,  419,  420,  371,  422,   47,
 /*  1740 */    14,   47,  376,    0,  378,   40,   39,    0,    0,    0,
 /*  1750 */    39,  175,    0,    0,    0,    0,    0,   35,   65,   39,
 /*  1760 */     0,  332,   48,   35,   48,    0,   39,   35,   39,   48,
 /*  1770 */     0,   35,  456,  457,  408,    0,   39,    0,  412,   48,
 /*  1780 */     0,  415,  416,  417,  418,  419,  420,    0,  422,   22,
 /*  1790 */     0,    0,  363,  105,   35,   44,   35,   35,   35,   35,
 /*  1800 */   371,  103,   44,   35,   35,  376,   22,  378,   35,    0,
 /*  1810 */    22,   22,    0,   35,   22,    0,   50,   35,    0,    0,
 /*  1820 */    35,   22,  332,   20,    0,    0,  165,   22,   22,   35,
 /*  1830 */    35,   35,   97,  467,  468,   96,   96,  408,    0,   35,
 /*  1840 */   165,  412,    0,  165,  415,  416,  417,  418,  419,  420,
 /*  1850 */   173,  422,  187,  363,    3,   44,  253,  232,  429,  257,
 /*  1860 */    44,  371,  253,  434,   44,   44,  376,   96,  378,   97,
 /*  1870 */   167,   97,  332,   97,   47,   96,   47,   96,  172,   96,
 /*  1880 */    44,    3,   96,   44,  253,   35,    0,  172,  332,   44,
 /*  1890 */    35,   35,   35,   35,   97,   97,   96,   35,  408,   97,
 /*  1900 */    47,    0,  412,  363,   97,  415,  416,  417,  418,  419,
 /*  1910 */   420,  371,  422,  247,   97,   47,  376,    0,  378,  363,
 /*  1920 */     0,   39,   96,   47,   96,  168,   96,  371,   97,   97,
 /*  1930 */    96,   96,  376,    0,  378,   39,   96,   47,   44,  106,
 /*  1940 */     2,   22,   96,   96,  211,   97,   97,  457,  408,  332,
 /*  1950 */   232,  234,  412,   47,   47,  415,  416,  417,  418,  419,
 /*  1960 */   420,   96,  422,   97,  408,  332,  232,  166,  412,   96,
 /*  1970 */    96,  415,  416,  417,  418,  419,  420,   97,  422,   22,
 /*  1980 */   363,   96,  107,   35,   97,  368,   35,   96,  371,   97,
 /*  1990 */    35,   96,  120,  376,   97,  378,  363,   35,   96,  459,
 /*  2000 */    97,   35,   97,   35,  371,   96,   96,   22,  120,  376,
 /*  2010 */    96,  378,  108,  120,   44,   35,   22,   96,  120,   96,
 /*  2020 */    64,  213,   35,   65,  468,  408,   35,  332,   35,  412,
 /*  2030 */    35,   35,  415,  416,  417,  418,  419,  420,   35,  422,
 /*  2040 */    71,  408,   35,   35,  332,  412,   35,   35,  415,  416,
 /*  2050 */   417,  418,  419,  420,   93,  422,   35,  424,  363,   44,
 /*  2060 */    35,   35,  332,  368,   22,   35,  371,   35,   35,   71,
 /*  2070 */    35,  376,   35,  378,   35,  363,   35,   22,   35,   35,
 /*  2080 */   368,    0,   35,  371,   48,   39,    0,   35,  376,   39,
 /*  2090 */   378,    0,   35,  363,    0,   39,   48,   48,   39,   35,
 /*  2100 */     0,  371,   48,  408,   35,   35,  376,  412,  378,    0,
 /*  2110 */   415,  416,  417,  418,  419,  420,   21,  422,   22,   22,
 /*  2120 */   408,   22,   21,   20,  412,  332,  471,  415,  416,  417,
 /*  2130 */   418,  419,  420,  471,  422,  471,  471,  471,  408,  471,
 /*  2140 */   471,  471,  412,  471,  471,  415,  416,  417,  418,  419,
 /*  2150 */   420,  471,  422,  471,  471,  471,  363,  471,  471,  471,
 /*  2160 */   471,  471,  471,  471,  371,  471,  471,  471,  471,  376,
 /*  2170 */   471,  378,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2180 */   471,  471,  471,  471,  471,  471,  332,  471,  471,  471,
 /*  2190 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2200 */   471,  408,  471,  471,  471,  412,  471,  471,  415,  416,
 /*  2210 */   417,  418,  419,  420,  471,  422,  471,  363,  471,  471,
 /*  2220 */   471,  332,  471,  471,  471,  371,  471,  471,  471,  471,
 /*  2230 */   376,  471,  378,  471,  471,  471,  471,  471,  471,  471,
 /*  2240 */   471,  471,  471,  471,  332,  471,  471,  471,  471,  471,
 /*  2250 */   471,  471,  363,  471,  471,  471,  471,  471,  471,  471,
 /*  2260 */   371,  471,  408,  471,  471,  376,  412,  378,  471,  415,
 /*  2270 */   416,  417,  418,  419,  420,  363,  422,  471,  471,  471,
 /*  2280 */   471,  471,  471,  371,  471,  471,  471,  471,  376,  471,
 /*  2290 */   378,  471,  471,  471,  471,  471,  471,  408,  471,  471,
 /*  2300 */   471,  412,  471,  471,  415,  416,  417,  418,  419,  420,
 /*  2310 */   471,  422,  471,  332,  471,  471,  471,  471,  471,  471,
 /*  2320 */   408,  471,  471,  471,  412,  471,  471,  415,  416,  417,
 /*  2330 */   418,  419,  420,  471,  422,  471,  471,  332,  471,  471,
 /*  2340 */   471,  471,  471,  471,  363,  471,  471,  471,  471,  471,
 /*  2350 */   471,  471,  371,  471,  471,  471,  471,  376,  471,  378,
 /*  2360 */   471,  471,  471,  471,  471,  471,  471,  471,  363,  471,
 /*  2370 */   471,  471,  471,  471,  471,  471,  371,  471,  471,  471,
 /*  2380 */   471,  376,  471,  378,  471,  471,  471,  471,  471,  408,
 /*  2390 */   471,  471,  471,  412,  471,  332,  415,  416,  417,  418,
 /*  2400 */   419,  420,  471,  422,  471,  471,  471,  471,  471,  471,
 /*  2410 */   471,  471,  471,  408,  471,  471,  332,  412,  471,  471,
 /*  2420 */   415,  416,  417,  418,  419,  420,  363,  422,  471,  471,
 /*  2430 */   471,  471,  471,  471,  371,  471,  471,  471,  471,  376,
 /*  2440 */   471,  378,  471,  471,  471,  332,  471,  363,  471,  471,
 /*  2450 */   471,  471,  471,  471,  471,  371,  471,  471,  471,  471,
 /*  2460 */   376,  471,  378,  471,  471,  471,  471,  471,  471,  471,
 /*  2470 */   471,  408,  471,  471,  471,  412,  363,  471,  415,  416,
 /*  2480 */   417,  418,  419,  420,  371,  422,  471,  471,  471,  376,
 /*  2490 */   471,  378,  408,  471,  471,  471,  412,  471,  471,  415,
 /*  2500 */   416,  417,  418,  419,  420,  471,  422,  471,  471,  471,
 /*  2510 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  332,
 /*  2520 */   471,  408,  471,  471,  471,  412,  471,  471,  415,  416,
 /*  2530 */   417,  418,  419,  420,  471,  422,  471,  471,  332,  471,
 /*  2540 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2550 */   363,  471,  471,  471,  332,  471,  471,  471,  371,  471,
 /*  2560 */   471,  471,  471,  376,  471,  378,  471,  471,  471,  363,
 /*  2570 */   471,  471,  471,  471,  471,  471,  471,  371,  471,  471,
 /*  2580 */   471,  471,  376,  471,  378,  363,  471,  471,  471,  471,
 /*  2590 */   471,  471,  471,  371,  471,  408,  471,  471,  376,  412,
 /*  2600 */   378,  471,  415,  416,  417,  418,  419,  420,  471,  422,
 /*  2610 */   471,  471,  471,  471,  408,  471,  332,  471,  412,  471,
 /*  2620 */   471,  415,  416,  417,  418,  419,  420,  471,  422,  471,
 /*  2630 */   408,  471,  471,  471,  412,  471,  471,  415,  416,  417,
 /*  2640 */   418,  419,  420,  471,  422,  471,  471,  363,  471,  471,
 /*  2650 */   471,  471,  471,  471,  471,  371,  471,  471,  471,  471,
 /*  2660 */   376,  471,  378,  471,  471,  471,  471,  471,  471,  471,
 /*  2670 */   471,  471,  471,  471,  471,  471,  471,  332,  471,  471,
 /*  2680 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2690 */   471,  471,  408,  471,  471,  471,  412,  471,  471,  415,
 /*  2700 */   416,  417,  418,  419,  420,  471,  422,  471,  363,  471,
 /*  2710 */   471,  471,  471,  471,  471,  471,  371,  471,  471,  471,
 /*  2720 */   471,  376,  471,  378,  471,  471,  471,  471,  471,  471,
 /*  2730 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2740 */   471,  471,  471,  471,  471,  471,  332,  471,  471,  471,
 /*  2750 */   471,  471,  471,  408,  471,  471,  471,  412,  471,  471,
 /*  2760 */   415,  416,  417,  418,  419,  420,  471,  422,  471,  471,
 /*  2770 */   471,  471,  332,  471,  471,  471,  471,  363,  471,  471,
 /*  2780 */   471,  471,  471,  471,  471,  371,  471,  471,  471,  471,
 /*  2790 */   376,  471,  378,  471,  471,  471,  471,  471,  471,  471,
 /*  2800 */   471,  471,  471,  363,  471,  471,  471,  471,  471,  471,
 /*  2810 */   471,  371,  471,  471,  471,  471,  376,  471,  378,  471,
 /*  2820 */   471,  471,  408,  471,  471,  471,  412,  471,  471,  415,
 /*  2830 */   416,  417,  418,  419,  420,  332,  422,  471,  471,  471,
 /*  2840 */   471,  471,  471,  471,  471,  471,  471,  471,  408,  471,
 /*  2850 */   471,  471,  412,  471,  332,  415,  416,  417,  418,  419,
 /*  2860 */   420,  471,  422,  471,  471,  471,  363,  471,  471,  471,
 /*  2870 */   471,  471,  471,  471,  371,  471,  471,  471,  471,  376,
 /*  2880 */   471,  378,  471,  471,  471,  363,  471,  471,  471,  471,
 /*  2890 */   471,  471,  471,  371,  471,  471,  471,  471,  376,  471,
 /*  2900 */   378,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2910 */   471,  408,  471,  471,  471,  412,  471,  332,  415,  416,
 /*  2920 */   417,  418,  419,  420,  471,  422,  471,  471,  471,  471,
 /*  2930 */   408,  471,  471,  332,  412,  471,  471,  415,  416,  417,
 /*  2940 */   418,  419,  420,  471,  422,  471,  471,  471,  363,  471,
 /*  2950 */   471,  471,  471,  471,  471,  471,  371,  471,  471,  471,
 /*  2960 */   471,  376,  471,  378,  363,  471,  471,  471,  471,  471,
 /*  2970 */   471,  471,  371,  471,  471,  471,  471,  376,  471,  378,
 /*  2980 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2990 */   471,  471,  471,  408,  471,  332,  471,  412,  471,  471,
 /*  3000 */   415,  416,  417,  418,  419,  420,  471,  422,  471,  408,
 /*  3010 */   471,  471,  471,  412,  471,  471,  415,  416,  417,  418,
 /*  3020 */   419,  420,  471,  422,  471,  471,  363,  471,  471,  471,
 /*  3030 */   471,  471,  471,  471,  371,  471,  471,  471,  471,  376,
 /*  3040 */   471,  378,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  3050 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  3060 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  3070 */   471,  408,  471,  471,  471,  412,  471,  471,  415,  416,
 /*  3080 */   417,  418,  419,  420,  471,  422,
};
#define YY_SHIFT_COUNT    (744)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2109)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   876,    0,   72,    0,  294,  294,  294,  294,  294,  294,
 /*    10 */   294,  294,  294,  294,  294,  366,  586,  586,  658,  586,
 /*    20 */   586,  586,  586,  586,  586,  586,  586,  586,  586,  586,
 /*    30 */   586,  586,  586,  586,  586,  586,  586,  586,  586,  586,
 /*    40 */   586,  586,  586,  586,  586,  586,  586,  586,  106,  289,
 /*    50 */   756,    1,  430,  327,  399,  327,    1,    1, 1223, 1223,
 /*    60 */  1223,  327, 1223, 1223,   62,  327,   19,  334,   54,   54,
 /*    70 */   334,  407,  407,  118,   67,   48,   48,   54,   54,   54,
 /*    80 */    54,   54,   54,   54,   79,   54,   54,   40,   19,   54,
 /*    90 */    54,  304,   54,   19,   54,   79,   54,   79,   19,   54,
 /*   100 */    54,   19,   54,   19,   19,   19,   54,  318,  805,   34,
 /*   110 */    34,  219,  381,  137,  137,  137,  137,  137,  137,  137,
 /*   120 */   137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
 /*   130 */   137,  137,  732,  536,  118,   67,  426,  120,  120,  120,
 /*   140 */   174,  482,  482,  426,  337,  337,  337,   40,  365,  389,
 /*   150 */    19,  383,   19,  383,  383,  444,  568,  221,  221,  221,
 /*   160 */   221,  221,  221,  221,  221,  515,  414,  308,  622,  751,
 /*   170 */   107,  594,  227,  193,  487,  340,  983,  888,  916, 1097,
 /*   180 */   891,  887,  900,  891, 1102,  912,  141, 1052, 1262, 1129,
 /*   190 */  1291, 1318, 1291, 1180, 1326, 1326, 1291, 1180, 1180, 1326,
 /*   200 */  1268, 1326, 1326, 1326, 1352, 1352, 1355,   40, 1359,   40,
 /*   210 */  1370, 1373,   40, 1370,   40,   40,   40, 1326,   40, 1356,
 /*   220 */  1356, 1352,   19,   19,   19,   19,   19,   19,   19,   19,
 /*   230 */    19,   19,   19, 1326, 1352,  383,  383,  383, 1215, 1327,
 /*   240 */  1355,  318, 1252, 1255, 1359,  318, 1326, 1318, 1318,  383,
 /*   250 */  1187, 1203,  383, 1187, 1203,  383,  383,   19, 1198, 1294,
 /*   260 */  1187, 1202, 1208, 1227, 1052, 1214, 1213, 1217, 1247,  337,
 /*   270 */  1485, 1326, 1370,  318,  318, 1491, 1203,  383,  383,  383,
 /*   280 */   383,  383, 1203,  383, 1347,  318,  444,  318,  337, 1431,
 /*   290 */  1433,  383,  568, 1326,  318, 1500, 1352, 3086, 3086, 3086,
 /*   300 */  3086, 3086, 3086, 3086, 3086, 3086,  901,  570,   51,  636,
 /*   310 */   461,   15,  477,  545,  417,  766,  986,  902, 1000, 1000,
 /*   320 */  1000, 1000, 1000, 1000, 1000, 1000, 1000,  910,  409,  132,
 /*   330 */   132,   71,  352,  189,   37,  737,  624,  532,  532,  647,
 /*   340 */   930,  297,  647,  647,  647,  895,  847,  632, 1114,  913,
 /*   350 */  1152, 1066, 1078, 1092, 1094, 1123, 1177, 1210,  960, 1158,
 /*   360 */  1167,  429, 1169, 1170, 1181, 1095,  979,  488, 1085, 1183,
 /*   370 */  1195, 1200, 1216, 1221, 1225, 1239, 1226, 1130, 1138,  844,
 /*   380 */  1228, 1212, 1229, 1230, 1232, 1233, 1238, 1240, 1165, 1282,
 /*   390 */  1293, 1250, 1319, 1557, 1568, 1569, 1529, 1572, 1538, 1369,
 /*   400 */  1541, 1543, 1544, 1375, 1582, 1548, 1550, 1381, 1587, 1384,
 /*   410 */  1590, 1562, 1599, 1578, 1601, 1567, 1411, 1418, 1422, 1608,
 /*   420 */  1613, 1622, 1443, 1445, 1626, 1629, 1583, 1634, 1635, 1636,
 /*   430 */  1595, 1638, 1639, 1640, 1641, 1642, 1643, 1644, 1645, 1494,
 /*   440 */  1612, 1649, 1498, 1651, 1652, 1653, 1654, 1655, 1656, 1658,
 /*   450 */  1659, 1660, 1663, 1672, 1673, 1674, 1676, 1680, 1681, 1646,
 /*   460 */  1684, 1685, 1686, 1689, 1690, 1691, 1671, 1699, 1700, 1701,
 /*   470 */  1559, 1696, 1697, 1702, 1647, 1668, 1704, 1648, 1708, 1667,
 /*   480 */  1709, 1710, 1670, 1687, 1669, 1683, 1713, 1692, 1726, 1694,
 /*   490 */  1743, 1705, 1707, 1747, 1748, 1749, 1711, 1576, 1752, 1753,
 /*   500 */  1754, 1693, 1755, 1756, 1722, 1714, 1720, 1760, 1728, 1716,
 /*   510 */  1727, 1765, 1732, 1721, 1729, 1770, 1736, 1731, 1737, 1775,
 /*   520 */  1777, 1780, 1787, 1688, 1698, 1759, 1767, 1790, 1761, 1762,
 /*   530 */  1763, 1764, 1751, 1758, 1768, 1769, 1784, 1773, 1791, 1788,
 /*   540 */  1809, 1789, 1766, 1812, 1792, 1778, 1815, 1782, 1818, 1785,
 /*   550 */  1819, 1799, 1803, 1794, 1795, 1796, 1735, 1739, 1824, 1661,
 /*   560 */  1740, 1804, 1805, 1825, 1665, 1806, 1675, 1703, 1838, 1842,
 /*   570 */  1678, 1677, 1851, 1811, 1603, 1771, 1772, 1779, 1706, 1625,
 /*   580 */  1715, 1602, 1774, 1816, 1820, 1776, 1781, 1783, 1786, 1797,
 /*   590 */  1821, 1827, 1829, 1800, 1836, 1609, 1798, 1802, 1878, 1839,
 /*   600 */  1631, 1850, 1855, 1856, 1857, 1858, 1862, 1807, 1817, 1853,
 /*   610 */  1666, 1845, 1868, 1886, 1901, 1917, 1920, 1826, 1882, 1683,
 /*   620 */  1876, 1828, 1831, 1832, 1830, 1834, 1757, 1835, 1933, 1896,
 /*   630 */  1801, 1840, 1833, 1683, 1890, 1894, 1718, 1717, 1734, 1938,
 /*   640 */  1919, 1733, 1846, 1848, 1847, 1849, 1865, 1866, 1906, 1873,
 /*   650 */  1874, 1907, 1880, 1957, 1808, 1885, 1875, 1887, 1948, 1951,
 /*   660 */  1891, 1892, 1955, 1895, 1897, 1962, 1902, 1903, 1966, 1909,
 /*   670 */  1905, 1968, 1910, 1872, 1888, 1893, 1898, 1985, 1904, 1914,
 /*   680 */  1970, 1921, 1980, 1923, 1970, 1970, 1994, 1958, 1956, 1987,
 /*   690 */  1991, 1993, 1995, 1996, 2003, 2007, 2008, 2011, 2012, 1969,
 /*   700 */  1961, 2015, 2021, 2025, 2026, 2042, 2030, 2032, 2033, 1998,
 /*   710 */  1751, 2035, 1758, 2037, 2039, 2041, 2043, 2055, 2044, 2081,
 /*   720 */  2047, 2036, 2046, 2086, 2052, 2048, 2050, 2091, 2057, 2049,
 /*   730 */  2056, 2094, 2064, 2054, 2059, 2100, 2069, 2070, 2109, 2096,
 /*   740 */  2095, 2097, 2099, 2101, 2103,
};
#define YY_REDUCE_COUNT (305)
#define YY_REDUCE_MIN   (-420)
#define YY_REDUCE_MAX   (2663)
static const short yy_reduce_ofst[] = {
 /*     0 */   464, -306,  -12,  280,  693,  771,  804,  871,  936,  969,
 /*    10 */  1065, 1126, 1176, 1199, 1249, 1299, 1316, 1366, 1429, 1490,
 /*    20 */  1540, 1556, 1617, 1633, 1695, 1712, 1730, 1793, 1854, 1889,
 /*    30 */  1912, 1981, 2005, 2063, 2084, 2113, 2187, 2206, 2222, 2284,
 /*    40 */  2345, 2414, 2440, 2503, 2522, 2585, 2601, 2663, -285, -262,
 /*    50 */    99, -174, -341,  101,  400,  627,  347,  657,  742,  796,
 /*    60 */   841,  287, -359, -234, -405, -274, -354,  -68, -102,   23,
 /*    70 */  -305, -336, -331, -294, -340, -296,  -80,   80,  312,  368,
 /*    80 */   371,  372,  497,  557,  -74,  695,  696,  263,  -51,  704,
 /*    90 */   705, -178,  707,   39,  708,  228,  720,  260, -190,  750,
 /*   100 */   760,  241,  762,  484,  420,  535,  789, -229, -218, -420,
 /*   110 */  -420,  216, -197,  -15,   21,  309,  401,  516,  517,  539,
 /*   120 */   564,  630,  675,  687,  689,  765,  774,  787,  792,  798,
 /*   130 */   800,  808, -343, -347,  190, -183, -116, -347,  380,  410,
 /*   140 */   213,  295,  478,  -96, -367,  356,  375,  133,   30,  418,
 /*   150 */   547,  453,  361,  481,  491,  562,  569,  326,  341,  346,
 /*   160 */   432,  466,  559,  640,  466,  330,  412,  644,  631,  574,
 /*   170 */   615,  739,  637,  822,  822,  786,  785,  862,  855,  857,
 /*   180 */   803,  803,  813,  803,  861,  856,  822,  899,  911,  934,
 /*   190 */   951,  950,  956,  962, 1009, 1010,  974,  978,  980, 1020,
 /*   200 */  1016, 1026, 1027, 1031, 1039, 1040,  973, 1032, 1004, 1037,
 /*   210 */  1051,  998, 1049, 1058, 1054, 1055, 1059, 1064, 1060, 1067,
 /*   220 */  1068, 1079, 1053, 1056, 1057, 1061, 1062, 1063, 1069, 1070,
 /*   230 */  1074, 1075, 1076, 1072, 1080, 1041, 1042, 1045, 1015, 1022,
 /*   240 */  1028, 1086, 1038, 1044, 1077, 1110, 1089, 1071, 1073, 1084,
 /*   250 */  1005, 1081, 1087, 1011, 1083, 1088, 1090,  822, 1013, 1017,
 /*   260 */  1024, 1018, 1029, 1043, 1091, 1023, 1036, 1033,  803, 1132,
 /*   270 */  1093, 1166, 1168, 1171, 1172, 1121, 1122, 1136, 1141, 1142,
 /*   280 */  1143, 1144, 1131, 1145, 1135, 1182, 1173, 1184, 1153, 1098,
 /*   290 */  1189, 1149, 1196, 1193, 1191, 1205, 1224, 1139, 1146, 1159,
 /*   300 */  1174, 1204, 1206, 1207, 1220, 1237,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    10 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    20 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    30 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    40 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    50 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    60 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    70 */  1670, 1670, 1670, 1928, 1670, 1670, 1670, 1670, 1670, 1670,
 /*    80 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1749, 1670, 1670,
 /*    90 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   100 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1747, 1921, 2139,
 /*   110 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   120 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   130 */  1670, 1670, 1670, 2151, 1670, 1670, 1670, 2151, 2151, 2151,
 /*   140 */  1747, 2111, 2111, 1670, 1670, 1670, 1670, 1749, 1984, 1670,
 /*   150 */  1670, 1670, 1670, 1670, 1670, 1856, 1670, 1670, 1670, 1670,
 /*   160 */  1670, 1880, 1670, 1670, 1670, 1974, 1670, 1670, 2176, 2232,
 /*   170 */  1670, 1670, 2179, 1670, 1670, 1670, 1933, 1670, 1809, 2166,
 /*   180 */  2143, 2157, 2216, 2144, 2141, 2160, 1670, 2170, 1670, 1967,
 /*   190 */  1926, 1670, 1926, 1923, 1670, 1670, 1926, 1923, 1923, 1670,
 /*   200 */  1800, 1670, 1670, 1670, 1670, 1670, 1670, 1749, 1670, 1749,
 /*   210 */  1670, 1670, 1749, 1670, 1749, 1749, 1749, 1670, 1749, 1727,
 /*   220 */  1727, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   230 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1996, 1982,
 /*   240 */  1670, 1747, 1978, 1976, 1670, 1747, 1670, 1670, 1670, 1670,
 /*   250 */  2187, 2185, 1670, 2187, 2185, 1670, 1670, 1670, 2201, 2197,
 /*   260 */  2187, 2205, 2203, 2172, 2170, 2235, 2222, 2218, 2157, 1670,
 /*   270 */  1670, 1670, 1670, 1747, 1747, 1670, 2185, 1670, 1670, 1670,
 /*   280 */  1670, 1670, 2185, 1670, 1670, 1747, 1670, 1747, 1670, 1670,
 /*   290 */  1825, 1670, 1670, 1670, 1747, 1702, 1670, 1969, 1987, 1951,
 /*   300 */  1951, 1859, 1859, 1859, 1750, 1675, 1670, 1670, 1670, 1670,
 /*   310 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 2200, 2199,
 /*   320 */  2066, 1670, 2115, 2114, 2113, 2104, 2065, 1821, 1670, 2064,
 /*   330 */  2063, 1670, 1670, 1670, 1670, 1670, 1670, 1942, 1941, 2057,
 /*   340 */  1670, 1670, 2058, 2056, 2055, 1670, 1670, 1670, 1670, 1670,
 /*   350 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   360 */  1670, 1670, 1670, 1670, 1670, 1670, 2219, 2223, 1670, 1670,
 /*   370 */  1670, 1670, 1670, 1670, 1670, 2140, 1670, 1670, 1670, 1670,
 /*   380 */  1670, 2039, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   390 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   400 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   410 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   420 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   430 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   440 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   450 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   460 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   470 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   480 */  1670, 1670, 1670, 1670, 1707, 2044, 1670, 1670, 1670, 1670,
 /*   490 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   500 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   510 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   520 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   530 */  1670, 1670, 1788, 1787, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   540 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   550 */  1670, 1670, 1670, 1670, 1670, 1670, 2048, 1670, 1670, 1670,
 /*   560 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   570 */  1670, 1670, 2215, 2173, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   580 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   590 */  1670, 1670, 2039, 1670, 2198, 1670, 1670, 2213, 1670, 2217,
 /*   600 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 2150, 2146, 1670,
 /*   610 */  1670, 2142, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 2047,
 /*   620 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   630 */  1670, 1670, 1670, 2038, 1670, 2101, 1670, 1670, 1670, 2135,
 /*   640 */  1670, 1670, 2086, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   650 */  1670, 1670, 2048, 1670, 2051, 1670, 1670, 1670, 1670, 1670,
 /*   660 */  1853, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   670 */  1670, 1670, 1670, 1838, 1836, 1835, 1834, 1670, 1831, 1670,
 /*   680 */  1866, 1670, 1670, 1670, 1862, 1861, 1670, 1670, 1670, 1670,
 /*   690 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   700 */  1670, 1768, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   710 */  1760, 1670, 1759, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   720 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   730 */  1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670, 1670,
 /*   740 */  1670, 1670, 1670, 1670, 1670,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  277,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  277,  /*      AFTER => ABORT */
  277,  /*     ATTACH => ABORT */
  277,  /*     BEFORE => ABORT */
  277,  /*      BEGIN => ABORT */
  277,  /*     BITAND => ABORT */
  277,  /*     BITNOT => ABORT */
  277,  /*      BITOR => ABORT */
  277,  /*     BLOCKS => ABORT */
  277,  /*     CHANGE => ABORT */
  277,  /*      COMMA => ABORT */
  277,  /*     CONCAT => ABORT */
  277,  /*   CONFLICT => ABORT */
  277,  /*       COPY => ABORT */
  277,  /*   DEFERRED => ABORT */
  277,  /* DELIMITERS => ABORT */
  277,  /*     DETACH => ABORT */
  277,  /*     DIVIDE => ABORT */
  277,  /*        DOT => ABORT */
  277,  /*       EACH => ABORT */
  277,  /*       FAIL => ABORT */
  277,  /*       FILE => ABORT */
  277,  /*        FOR => ABORT */
  277,  /*       GLOB => ABORT */
  277,  /*         ID => ABORT */
  277,  /*  IMMEDIATE => ABORT */
  277,  /*     IMPORT => ABORT */
  277,  /*  INITIALLY => ABORT */
  277,  /*    INSTEAD => ABORT */
  277,  /*     ISNULL => ABORT */
  277,  /*        KEY => ABORT */
  277,  /*    MODULES => ABORT */
  277,  /*  NK_BITNOT => ABORT */
  277,  /*    NK_SEMI => ABORT */
  277,  /*    NOTNULL => ABORT */
  277,  /*         OF => ABORT */
  277,  /*       PLUS => ABORT */
  277,  /*  PRIVILEGE => ABORT */
  277,  /*      RAISE => ABORT */
  277,  /*    REPLACE => ABORT */
  277,  /*   RESTRICT => ABORT */
  277,  /*        ROW => ABORT */
  277,  /*       SEMI => ABORT */
  277,  /*       STAR => ABORT */
  277,  /*  STATEMENT => ABORT */
  277,  /*     STRICT => ABORT */
  277,  /*     STRING => ABORT */
  277,  /*      TIMES => ABORT */
  277,  /*     VALUES => ABORT */
  277,  /*   VARIABLE => ABORT */
  277,  /*       VIEW => ABORT */
  277,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "ALIVE",
  /*  162 */ "LIKE",
  /*  163 */ "TBNAME",
  /*  164 */ "QTAGS",
  /*  165 */ "AS",
  /*  166 */ "INDEX",
  /*  167 */ "FUNCTION",
  /*  168 */ "INTERVAL",
  /*  169 */ "COUNT",
  /*  170 */ "LAST_ROW",
  /*  171 */ "TOPIC",
  /*  172 */ "WITH",
  /*  173 */ "META",
  /*  174 */ "CONSUMER",
  /*  175 */ "GROUP",
  /*  176 */ "DESC",
  /*  177 */ "DESCRIBE",
  /*  178 */ "RESET",
  /*  179 */ "QUERY",
  /*  180 */ "CACHE",
  /*  181 */ "EXPLAIN",
  /*  182 */ "ANALYZE",
  /*  183 */ "VERBOSE",
  /*  184 */ "NK_BOOL",
  /*  185 */ "RATIO",
  /*  186 */ "NK_FLOAT",
  /*  187 */ "OUTPUTTYPE",
  /*  188 */ "AGGREGATE",
  /*  189 */ "BUFSIZE",
  /*  190 */ "LANGUAGE",
  /*  191 */ "STREAM",
  /*  192 */ "INTO",
  /*  193 */ "TRIGGER",
  /*  194 */ "AT_ONCE",
  /*  195 */ "WINDOW_CLOSE",
  /*  196 */ "IGNORE",
  /*  197 */ "EXPIRED",
  /*  198 */ "FILL_HISTORY",
  /*  199 */ "UPDATE",
  /*  200 */ "SUBTABLE",
  /*  201 */ "KILL",
  /*  202 */ "CONNECTION",
  /*  203 */ "TRANSACTION",
  /*  204 */ "BALANCE",
  /*  205 */ "VGROUP",
  /*  206 */ "MERGE",
  /*  207 */ "REDISTRIBUTE",
  /*  208 */ "SPLIT",
  /*  209 */ "DELETE",
  /*  210 */ "INSERT",
  /*  211 */ "NULL",
  /*  212 */ "NK_QUESTION",
  /*  213 */ "NK_ARROW",
  /*  214 */ "ROWTS",
  /*  215 */ "QSTART",
  /*  216 */ "QEND",
  /*  217 */ "QDURATION",
  /*  218 */ "WSTART",
  /*  219 */ "WEND",
  /*  220 */ "WDURATION",
  /*  221 */ "IROWTS",
  /*  222 */ "ISFILLED",
  /*  223 */ "CAST",
  /*  224 */ "NOW",
  /*  225 */ "TODAY",
  /*  226 */ "TIMEZONE",
  /*  227 */ "CLIENT_VERSION",
  /*  228 */ "SERVER_VERSION",
  /*  229 */ "SERVER_STATUS",
  /*  230 */ "CURRENT_USER",
  /*  231 */ "CASE",
  /*  232 */ "END",
  /*  233 */ "WHEN",
  /*  234 */ "THEN",
  /*  235 */ "ELSE",
  /*  236 */ "BETWEEN",
  /*  237 */ "IS",
  /*  238 */ "NK_LT",
  /*  239 */ "NK_GT",
  /*  240 */ "NK_LE",
  /*  241 */ "NK_GE",
  /*  242 */ "NK_NE",
  /*  243 */ "MATCH",
  /*  244 */ "NMATCH",
  /*  245 */ "CONTAINS",
  /*  246 */ "IN",
  /*  247 */ "JOIN",
  /*  248 */ "INNER",
  /*  249 */ "SELECT",
  /*  250 */ "DISTINCT",
  /*  251 */ "WHERE",
  /*  252 */ "PARTITION",
  /*  253 */ "BY",
  /*  254 */ "SESSION",
  /*  255 */ "STATE_WINDOW",
  /*  256 */ "EVENT_WINDOW",
  /*  257 */ "START",
  /*  258 */ "SLIDING",
  /*  259 */ "FILL",
  /*  260 */ "VALUE",
  /*  261 */ "VALUE_F",
  /*  262 */ "NONE",
  /*  263 */ "PREV",
  /*  264 */ "NULL_F",
  /*  265 */ "LINEAR",
  /*  266 */ "NEXT",
  /*  267 */ "HAVING",
  /*  268 */ "RANGE",
  /*  269 */ "EVERY",
  /*  270 */ "ORDER",
  /*  271 */ "SLIMIT",
  /*  272 */ "SOFFSET",
  /*  273 */ "LIMIT",
  /*  274 */ "OFFSET",
  /*  275 */ "ASC",
  /*  276 */ "NULLS",
  /*  277 */ "ABORT",
  /*  278 */ "AFTER",
  /*  279 */ "ATTACH",
  /*  280 */ "BEFORE",
  /*  281 */ "BEGIN",
  /*  282 */ "BITAND",
  /*  283 */ "BITNOT",
  /*  284 */ "BITOR",
  /*  285 */ "BLOCKS",
  /*  286 */ "CHANGE",
  /*  287 */ "COMMA",
  /*  288 */ "CONCAT",
  /*  289 */ "CONFLICT",
  /*  290 */ "COPY",
  /*  291 */ "DEFERRED",
  /*  292 */ "DELIMITERS",
  /*  293 */ "DETACH",
  /*  294 */ "DIVIDE",
  /*  295 */ "DOT",
  /*  296 */ "EACH",
  /*  297 */ "FAIL",
  /*  298 */ "FILE",
  /*  299 */ "FOR",
  /*  300 */ "GLOB",
  /*  301 */ "ID",
  /*  302 */ "IMMEDIATE",
  /*  303 */ "IMPORT",
  /*  304 */ "INITIALLY",
  /*  305 */ "INSTEAD",
  /*  306 */ "ISNULL",
  /*  307 */ "KEY",
  /*  308 */ "MODULES",
  /*  309 */ "NK_BITNOT",
  /*  310 */ "NK_SEMI",
  /*  311 */ "NOTNULL",
  /*  312 */ "OF",
  /*  313 */ "PLUS",
  /*  314 */ "PRIVILEGE",
  /*  315 */ "RAISE",
  /*  316 */ "REPLACE",
  /*  317 */ "RESTRICT",
  /*  318 */ "ROW",
  /*  319 */ "SEMI",
  /*  320 */ "STAR",
  /*  321 */ "STATEMENT",
  /*  322 */ "STRICT",
  /*  323 */ "STRING",
  /*  324 */ "TIMES",
  /*  325 */ "VALUES",
  /*  326 */ "VARIABLE",
  /*  327 */ "VIEW",
  /*  328 */ "WAL",
  /*  329 */ "cmd",
  /*  330 */ "account_options",
  /*  331 */ "alter_account_options",
  /*  332 */ "literal",
  /*  333 */ "alter_account_option",
  /*  334 */ "user_name",
  /*  335 */ "sysinfo_opt",
  /*  336 */ "privileges",
  /*  337 */ "priv_level",
  /*  338 */ "priv_type_list",
  /*  339 */ "priv_type",
  /*  340 */ "db_name",
  /*  341 */ "topic_name",
  /*  342 */ "dnode_endpoint",
  /*  343 */ "force_opt",
  /*  344 */ "not_exists_opt",
  /*  345 */ "db_options",
  /*  346 */ "exists_opt",
  /*  347 */ "alter_db_options",
  /*  348 */ "speed_opt",
  /*  349 */ "integer_list",
  /*  350 */ "variable_list",
  /*  351 */ "retention_list",
  /*  352 */ "alter_db_option",
  /*  353 */ "retention",
  /*  354 */ "full_table_name",
  /*  355 */ "column_def_list",
  /*  356 */ "tags_def_opt",
  /*  357 */ "table_options",
  /*  358 */ "multi_create_clause",
  /*  359 */ "tags_def",
  /*  360 */ "multi_drop_clause",
  /*  361 */ "alter_table_clause",
  /*  362 */ "alter_table_options",
  /*  363 */ "column_name",
  /*  364 */ "type_name",
  /*  365 */ "signed_literal",
  /*  366 */ "create_subtable_clause",
  /*  367 */ "specific_cols_opt",
  /*  368 */ "expression_list",
  /*  369 */ "drop_table_clause",
  /*  370 */ "col_name_list",
  /*  371 */ "table_name",
  /*  372 */ "column_def",
  /*  373 */ "duration_list",
  /*  374 */ "rollup_func_list",
  /*  375 */ "alter_table_option",
  /*  376 */ "duration_literal",
  /*  377 */ "rollup_func_name",
  /*  378 */ "function_name",
  /*  379 */ "col_name",
  /*  380 */ "db_name_cond_opt",
  /*  381 */ "like_pattern_opt",
  /*  382 */ "table_name_cond",
  /*  383 */ "from_db_opt",
  /*  384 */ "tag_list_opt",
  /*  385 */ "tag_item",
  /*  386 */ "column_alias",
  /*  387 */ "full_index_name",
  /*  388 */ "index_options",
  /*  389 */ "index_name",
  /*  390 */ "func_list",
  /*  391 */ "sliding_opt",
  /*  392 */ "sma_stream_opt",
  /*  393 */ "func",
  /*  394 */ "sma_func_name",
  /*  395 */ "query_or_subquery",
  /*  396 */ "cgroup_name",
  /*  397 */ "analyze_opt",
  /*  398 */ "explain_options",
  /*  399 */ "insert_query",
  /*  400 */ "agg_func_opt",
  /*  401 */ "bufsize_opt",
  /*  402 */ "language_opt",
  /*  403 */ "stream_name",
  /*  404 */ "stream_options",
  /*  405 */ "col_list_opt",
  /*  406 */ "tag_def_or_ref_opt",
  /*  407 */ "subtable_opt",
  /*  408 */ "expression",
  /*  409 */ "dnode_list",
  /*  410 */ "where_clause_opt",
  /*  411 */ "signed",
  /*  412 */ "literal_func",
  /*  413 */ "literal_list",
  /*  414 */ "table_alias",
  /*  415 */ "expr_or_subquery",
  /*  416 */ "pseudo_column",
  /*  417 */ "column_reference",
  /*  418 */ "function_expression",
  /*  419 */ "case_when_expression",
  /*  420 */ "star_func",
  /*  421 */ "star_func_para_list",
  /*  422 */ "noarg_func",
  /*  423 */ "other_para_list",
  /*  424 */ "star_func_para",
  /*  425 */ "when_then_list",
  /*  426 */ "case_when_else_opt",
  /*  427 */ "common_expression",
  /*  428 */ "when_then_expr",
  /*  429 */ "predicate",
  /*  430 */ "compare_op",
  /*  431 */ "in_op",
  /*  432 */ "in_predicate_value",
  /*  433 */ "boolean_value_expression",
  /*  434 */ "boolean_primary",
  /*  435 */ "from_clause_opt",
  /*  436 */ "table_reference_list",
  /*  437 */ "table_reference",
  /*  438 */ "table_primary",
  /*  439 */ "joined_table",
  /*  440 */ "alias_opt",
  /*  441 */ "subquery",
  /*  442 */ "parenthesized_joined_table",
  /*  443 */ "join_type",
  /*  444 */ "search_condition",
  /*  445 */ "query_specification",
  /*  446 */ "set_quantifier_opt",
  /*  447 */ "select_list",
  /*  448 */ "partition_by_clause_opt",
  /*  449 */ "range_opt",
  /*  450 */ "every_opt",
  /*  451 */ "fill_opt",
  /*  452 */ "twindow_clause_opt",
  /*  453 */ "group_by_clause_opt",
  /*  454 */ "having_clause_opt",
  /*  455 */ "select_item",
  /*  456 */ "partition_list",
  /*  457 */ "partition_item",
  /*  458 */ "fill_mode",
  /*  459 */ "group_by_list",
  /*  460 */ "query_expression",
  /*  461 */ "query_simple",
  /*  462 */ "order_by_clause_opt",
  /*  463 */ "slimit_clause_opt",
  /*  464 */ "limit_clause_opt",
  /*  465 */ "union_query_expression",
  /*  466 */ "query_simple_or_subquery",
  /*  467 */ "sort_specification_list",
  /*  468 */ "sort_specification",
  /*  469 */ "ordering_specification_opt",
  /*  470 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 247 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 248 */ "db_name_cond_opt ::=",
 /* 249 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 250 */ "like_pattern_opt ::=",
 /* 251 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 252 */ "table_name_cond ::= table_name",
 /* 253 */ "from_db_opt ::=",
 /* 254 */ "from_db_opt ::= FROM db_name",
 /* 255 */ "tag_list_opt ::=",
 /* 256 */ "tag_list_opt ::= tag_item",
 /* 257 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 258 */ "tag_item ::= TBNAME",
 /* 259 */ "tag_item ::= QTAGS",
 /* 260 */ "tag_item ::= column_name",
 /* 261 */ "tag_item ::= column_name column_alias",
 /* 262 */ "tag_item ::= column_name AS column_alias",
 /* 263 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 264 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 265 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 266 */ "full_index_name ::= index_name",
 /* 267 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 270 */ "func_list ::= func",
 /* 271 */ "func_list ::= func_list NK_COMMA func",
 /* 272 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 273 */ "sma_func_name ::= function_name",
 /* 274 */ "sma_func_name ::= COUNT",
 /* 275 */ "sma_func_name ::= FIRST",
 /* 276 */ "sma_func_name ::= LAST",
 /* 277 */ "sma_func_name ::= LAST_ROW",
 /* 278 */ "sma_stream_opt ::=",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 281 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 286 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 287 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 288 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 289 */ "cmd ::= DESC full_table_name",
 /* 290 */ "cmd ::= DESCRIBE full_table_name",
 /* 291 */ "cmd ::= RESET QUERY CACHE",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 293 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 294 */ "analyze_opt ::=",
 /* 295 */ "analyze_opt ::= ANALYZE",
 /* 296 */ "explain_options ::=",
 /* 297 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 298 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 299 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 300 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 301 */ "agg_func_opt ::=",
 /* 302 */ "agg_func_opt ::= AGGREGATE",
 /* 303 */ "bufsize_opt ::=",
 /* 304 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 305 */ "language_opt ::=",
 /* 306 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 307 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 308 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 309 */ "col_list_opt ::=",
 /* 310 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 311 */ "tag_def_or_ref_opt ::=",
 /* 312 */ "tag_def_or_ref_opt ::= tags_def",
 /* 313 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 314 */ "stream_options ::=",
 /* 315 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 316 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 317 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 318 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 319 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 320 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 321 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 322 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 323 */ "subtable_opt ::=",
 /* 324 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 325 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 326 */ "cmd ::= KILL QUERY NK_STRING",
 /* 327 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 328 */ "cmd ::= BALANCE VGROUP",
 /* 329 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 330 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 331 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 332 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 333 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 334 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 335 */ "cmd ::= query_or_subquery",
 /* 336 */ "cmd ::= insert_query",
 /* 337 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 338 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 339 */ "literal ::= NK_INTEGER",
 /* 340 */ "literal ::= NK_FLOAT",
 /* 341 */ "literal ::= NK_STRING",
 /* 342 */ "literal ::= NK_BOOL",
 /* 343 */ "literal ::= TIMESTAMP NK_STRING",
 /* 344 */ "literal ::= duration_literal",
 /* 345 */ "literal ::= NULL",
 /* 346 */ "literal ::= NK_QUESTION",
 /* 347 */ "duration_literal ::= NK_VARIABLE",
 /* 348 */ "signed ::= NK_INTEGER",
 /* 349 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 350 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 351 */ "signed ::= NK_FLOAT",
 /* 352 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 353 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 354 */ "signed_literal ::= signed",
 /* 355 */ "signed_literal ::= NK_STRING",
 /* 356 */ "signed_literal ::= NK_BOOL",
 /* 357 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 358 */ "signed_literal ::= duration_literal",
 /* 359 */ "signed_literal ::= NULL",
 /* 360 */ "signed_literal ::= literal_func",
 /* 361 */ "signed_literal ::= NK_QUESTION",
 /* 362 */ "literal_list ::= signed_literal",
 /* 363 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 364 */ "db_name ::= NK_ID",
 /* 365 */ "table_name ::= NK_ID",
 /* 366 */ "column_name ::= NK_ID",
 /* 367 */ "function_name ::= NK_ID",
 /* 368 */ "table_alias ::= NK_ID",
 /* 369 */ "column_alias ::= NK_ID",
 /* 370 */ "user_name ::= NK_ID",
 /* 371 */ "topic_name ::= NK_ID",
 /* 372 */ "stream_name ::= NK_ID",
 /* 373 */ "cgroup_name ::= NK_ID",
 /* 374 */ "index_name ::= NK_ID",
 /* 375 */ "expr_or_subquery ::= expression",
 /* 376 */ "expression ::= literal",
 /* 377 */ "expression ::= pseudo_column",
 /* 378 */ "expression ::= column_reference",
 /* 379 */ "expression ::= function_expression",
 /* 380 */ "expression ::= case_when_expression",
 /* 381 */ "expression ::= NK_LP expression NK_RP",
 /* 382 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 383 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 384 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 385 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 386 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 387 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 388 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 389 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 390 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 391 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 392 */ "expression_list ::= expr_or_subquery",
 /* 393 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 394 */ "column_reference ::= column_name",
 /* 395 */ "column_reference ::= table_name NK_DOT column_name",
 /* 396 */ "pseudo_column ::= ROWTS",
 /* 397 */ "pseudo_column ::= TBNAME",
 /* 398 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 399 */ "pseudo_column ::= QSTART",
 /* 400 */ "pseudo_column ::= QEND",
 /* 401 */ "pseudo_column ::= QDURATION",
 /* 402 */ "pseudo_column ::= WSTART",
 /* 403 */ "pseudo_column ::= WEND",
 /* 404 */ "pseudo_column ::= WDURATION",
 /* 405 */ "pseudo_column ::= IROWTS",
 /* 406 */ "pseudo_column ::= ISFILLED",
 /* 407 */ "pseudo_column ::= QTAGS",
 /* 408 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 409 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 410 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 411 */ "function_expression ::= literal_func",
 /* 412 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 413 */ "literal_func ::= NOW",
 /* 414 */ "noarg_func ::= NOW",
 /* 415 */ "noarg_func ::= TODAY",
 /* 416 */ "noarg_func ::= TIMEZONE",
 /* 417 */ "noarg_func ::= DATABASE",
 /* 418 */ "noarg_func ::= CLIENT_VERSION",
 /* 419 */ "noarg_func ::= SERVER_VERSION",
 /* 420 */ "noarg_func ::= SERVER_STATUS",
 /* 421 */ "noarg_func ::= CURRENT_USER",
 /* 422 */ "noarg_func ::= USER",
 /* 423 */ "star_func ::= COUNT",
 /* 424 */ "star_func ::= FIRST",
 /* 425 */ "star_func ::= LAST",
 /* 426 */ "star_func ::= LAST_ROW",
 /* 427 */ "star_func_para_list ::= NK_STAR",
 /* 428 */ "star_func_para_list ::= other_para_list",
 /* 429 */ "other_para_list ::= star_func_para",
 /* 430 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 431 */ "star_func_para ::= expr_or_subquery",
 /* 432 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 433 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 434 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 435 */ "when_then_list ::= when_then_expr",
 /* 436 */ "when_then_list ::= when_then_list when_then_expr",
 /* 437 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 438 */ "case_when_else_opt ::=",
 /* 439 */ "case_when_else_opt ::= ELSE common_expression",
 /* 440 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 441 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 442 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 443 */ "predicate ::= expr_or_subquery IS NULL",
 /* 444 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 445 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 446 */ "compare_op ::= NK_LT",
 /* 447 */ "compare_op ::= NK_GT",
 /* 448 */ "compare_op ::= NK_LE",
 /* 449 */ "compare_op ::= NK_GE",
 /* 450 */ "compare_op ::= NK_NE",
 /* 451 */ "compare_op ::= NK_EQ",
 /* 452 */ "compare_op ::= LIKE",
 /* 453 */ "compare_op ::= NOT LIKE",
 /* 454 */ "compare_op ::= MATCH",
 /* 455 */ "compare_op ::= NMATCH",
 /* 456 */ "compare_op ::= CONTAINS",
 /* 457 */ "in_op ::= IN",
 /* 458 */ "in_op ::= NOT IN",
 /* 459 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 460 */ "boolean_value_expression ::= boolean_primary",
 /* 461 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 462 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 463 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 464 */ "boolean_primary ::= predicate",
 /* 465 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 466 */ "common_expression ::= expr_or_subquery",
 /* 467 */ "common_expression ::= boolean_value_expression",
 /* 468 */ "from_clause_opt ::=",
 /* 469 */ "from_clause_opt ::= FROM table_reference_list",
 /* 470 */ "table_reference_list ::= table_reference",
 /* 471 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 472 */ "table_reference ::= table_primary",
 /* 473 */ "table_reference ::= joined_table",
 /* 474 */ "table_primary ::= table_name alias_opt",
 /* 475 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 476 */ "table_primary ::= subquery alias_opt",
 /* 477 */ "table_primary ::= parenthesized_joined_table",
 /* 478 */ "alias_opt ::=",
 /* 479 */ "alias_opt ::= table_alias",
 /* 480 */ "alias_opt ::= AS table_alias",
 /* 481 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 482 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 483 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 484 */ "join_type ::=",
 /* 485 */ "join_type ::= INNER",
 /* 486 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 487 */ "set_quantifier_opt ::=",
 /* 488 */ "set_quantifier_opt ::= DISTINCT",
 /* 489 */ "set_quantifier_opt ::= ALL",
 /* 490 */ "select_list ::= select_item",
 /* 491 */ "select_list ::= select_list NK_COMMA select_item",
 /* 492 */ "select_item ::= NK_STAR",
 /* 493 */ "select_item ::= common_expression",
 /* 494 */ "select_item ::= common_expression column_alias",
 /* 495 */ "select_item ::= common_expression AS column_alias",
 /* 496 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 497 */ "where_clause_opt ::=",
 /* 498 */ "where_clause_opt ::= WHERE search_condition",
 /* 499 */ "partition_by_clause_opt ::=",
 /* 500 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 501 */ "partition_list ::= partition_item",
 /* 502 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 503 */ "partition_item ::= expr_or_subquery",
 /* 504 */ "partition_item ::= expr_or_subquery column_alias",
 /* 505 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 506 */ "twindow_clause_opt ::=",
 /* 507 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 508 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 509 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 510 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 511 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 512 */ "sliding_opt ::=",
 /* 513 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 514 */ "fill_opt ::=",
 /* 515 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 516 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 517 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 518 */ "fill_mode ::= NONE",
 /* 519 */ "fill_mode ::= PREV",
 /* 520 */ "fill_mode ::= NULL",
 /* 521 */ "fill_mode ::= NULL_F",
 /* 522 */ "fill_mode ::= LINEAR",
 /* 523 */ "fill_mode ::= NEXT",
 /* 524 */ "group_by_clause_opt ::=",
 /* 525 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 526 */ "group_by_list ::= expr_or_subquery",
 /* 527 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 528 */ "having_clause_opt ::=",
 /* 529 */ "having_clause_opt ::= HAVING search_condition",
 /* 530 */ "range_opt ::=",
 /* 531 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 532 */ "every_opt ::=",
 /* 533 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 534 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 535 */ "query_simple ::= query_specification",
 /* 536 */ "query_simple ::= union_query_expression",
 /* 537 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 538 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 539 */ "query_simple_or_subquery ::= query_simple",
 /* 540 */ "query_simple_or_subquery ::= subquery",
 /* 541 */ "query_or_subquery ::= query_expression",
 /* 542 */ "query_or_subquery ::= subquery",
 /* 543 */ "order_by_clause_opt ::=",
 /* 544 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 545 */ "slimit_clause_opt ::=",
 /* 546 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 547 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 548 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 549 */ "limit_clause_opt ::=",
 /* 550 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 551 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 552 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 553 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 554 */ "subquery ::= NK_LP subquery NK_RP",
 /* 555 */ "search_condition ::= common_expression",
 /* 556 */ "sort_specification_list ::= sort_specification",
 /* 557 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 558 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 559 */ "ordering_specification_opt ::=",
 /* 560 */ "ordering_specification_opt ::= ASC",
 /* 561 */ "ordering_specification_opt ::= DESC",
 /* 562 */ "null_ordering_opt ::=",
 /* 563 */ "null_ordering_opt ::= NULLS FIRST",
 /* 564 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 329: /* cmd */
    case 332: /* literal */
    case 345: /* db_options */
    case 347: /* alter_db_options */
    case 353: /* retention */
    case 354: /* full_table_name */
    case 357: /* table_options */
    case 361: /* alter_table_clause */
    case 362: /* alter_table_options */
    case 365: /* signed_literal */
    case 366: /* create_subtable_clause */
    case 369: /* drop_table_clause */
    case 372: /* column_def */
    case 376: /* duration_literal */
    case 377: /* rollup_func_name */
    case 379: /* col_name */
    case 380: /* db_name_cond_opt */
    case 381: /* like_pattern_opt */
    case 382: /* table_name_cond */
    case 383: /* from_db_opt */
    case 385: /* tag_item */
    case 387: /* full_index_name */
    case 388: /* index_options */
    case 391: /* sliding_opt */
    case 392: /* sma_stream_opt */
    case 393: /* func */
    case 395: /* query_or_subquery */
    case 398: /* explain_options */
    case 399: /* insert_query */
    case 404: /* stream_options */
    case 407: /* subtable_opt */
    case 408: /* expression */
    case 410: /* where_clause_opt */
    case 411: /* signed */
    case 412: /* literal_func */
    case 415: /* expr_or_subquery */
    case 416: /* pseudo_column */
    case 417: /* column_reference */
    case 418: /* function_expression */
    case 419: /* case_when_expression */
    case 424: /* star_func_para */
    case 426: /* case_when_else_opt */
    case 427: /* common_expression */
    case 428: /* when_then_expr */
    case 429: /* predicate */
    case 432: /* in_predicate_value */
    case 433: /* boolean_value_expression */
    case 434: /* boolean_primary */
    case 435: /* from_clause_opt */
    case 436: /* table_reference_list */
    case 437: /* table_reference */
    case 438: /* table_primary */
    case 439: /* joined_table */
    case 441: /* subquery */
    case 442: /* parenthesized_joined_table */
    case 444: /* search_condition */
    case 445: /* query_specification */
    case 449: /* range_opt */
    case 450: /* every_opt */
    case 451: /* fill_opt */
    case 452: /* twindow_clause_opt */
    case 454: /* having_clause_opt */
    case 455: /* select_item */
    case 457: /* partition_item */
    case 460: /* query_expression */
    case 461: /* query_simple */
    case 463: /* slimit_clause_opt */
    case 464: /* limit_clause_opt */
    case 465: /* union_query_expression */
    case 466: /* query_simple_or_subquery */
    case 468: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy140)); 
}
      break;
    case 330: /* account_options */
    case 331: /* alter_account_options */
    case 333: /* alter_account_option */
    case 348: /* speed_opt */
    case 401: /* bufsize_opt */
{
 
}
      break;
    case 334: /* user_name */
    case 337: /* priv_level */
    case 340: /* db_name */
    case 341: /* topic_name */
    case 342: /* dnode_endpoint */
    case 363: /* column_name */
    case 371: /* table_name */
    case 378: /* function_name */
    case 386: /* column_alias */
    case 389: /* index_name */
    case 394: /* sma_func_name */
    case 396: /* cgroup_name */
    case 402: /* language_opt */
    case 403: /* stream_name */
    case 414: /* table_alias */
    case 420: /* star_func */
    case 422: /* noarg_func */
    case 440: /* alias_opt */
{
 
}
      break;
    case 335: /* sysinfo_opt */
{
 
}
      break;
    case 336: /* privileges */
    case 338: /* priv_type_list */
    case 339: /* priv_type */
{
 
}
      break;
    case 343: /* force_opt */
    case 344: /* not_exists_opt */
    case 346: /* exists_opt */
    case 397: /* analyze_opt */
    case 400: /* agg_func_opt */
    case 446: /* set_quantifier_opt */
{
 
}
      break;
    case 349: /* integer_list */
    case 350: /* variable_list */
    case 351: /* retention_list */
    case 355: /* column_def_list */
    case 356: /* tags_def_opt */
    case 358: /* multi_create_clause */
    case 359: /* tags_def */
    case 360: /* multi_drop_clause */
    case 367: /* specific_cols_opt */
    case 368: /* expression_list */
    case 370: /* col_name_list */
    case 373: /* duration_list */
    case 374: /* rollup_func_list */
    case 384: /* tag_list_opt */
    case 390: /* func_list */
    case 405: /* col_list_opt */
    case 406: /* tag_def_or_ref_opt */
    case 409: /* dnode_list */
    case 413: /* literal_list */
    case 421: /* star_func_para_list */
    case 423: /* other_para_list */
    case 425: /* when_then_list */
    case 447: /* select_list */
    case 448: /* partition_by_clause_opt */
    case 453: /* group_by_clause_opt */
    case 456: /* partition_list */
    case 459: /* group_by_list */
    case 462: /* order_by_clause_opt */
    case 467: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy220)); 
}
      break;
    case 352: /* alter_db_option */
    case 375: /* alter_table_option */
{
 
}
      break;
    case 364: /* type_name */
{
 
}
      break;
    case 430: /* compare_op */
    case 431: /* in_op */
{
 
}
      break;
    case 443: /* join_type */
{
 
}
      break;
    case 458: /* fill_mode */
{
 
}
      break;
    case 469: /* ordering_specification_opt */
{
 
}
      break;
    case 470: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  329,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  329,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  330,    0 }, /* (2) account_options ::= */
  {  330,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  330,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  330,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  330,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  330,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  330,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  330,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  330,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  330,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  331,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  331,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  333,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  333,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  333,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  333,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  333,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  333,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  333,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  333,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  333,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  333,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  329,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  329,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  329,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  329,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  329,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  335,    0 }, /* (29) sysinfo_opt ::= */
  {  335,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  329,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  329,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  336,   -1 }, /* (33) privileges ::= ALL */
  {  336,   -1 }, /* (34) privileges ::= priv_type_list */
  {  336,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  338,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  338,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  339,   -1 }, /* (38) priv_type ::= READ */
  {  339,   -1 }, /* (39) priv_type ::= WRITE */
  {  337,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  337,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  337,   -1 }, /* (42) priv_level ::= topic_name */
  {  329,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  329,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  329,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  329,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  329,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  329,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  329,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  329,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  342,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  342,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  342,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  343,    0 }, /* (54) force_opt ::= */
  {  343,   -1 }, /* (55) force_opt ::= FORCE */
  {  329,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  329,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  329,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  329,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  329,   -2 }, /* (68) cmd ::= USE db_name */
  {  329,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  329,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  329,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  329,   -3 }, /* (72) cmd ::= COMPACT DATABASE db_name */
  {  344,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  344,    0 }, /* (74) not_exists_opt ::= */
  {  346,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  346,    0 }, /* (76) exists_opt ::= */
  {  345,    0 }, /* (77) db_options ::= */
  {  345,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  345,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  345,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  345,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  345,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  345,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  345,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  345,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  345,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  345,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  345,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  345,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  345,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  345,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  345,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  345,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  345,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  345,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  345,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  345,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  345,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  345,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  345,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  345,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  347,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  347,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  352,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  352,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  352,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  352,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  352,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  352,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  352,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  352,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  352,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  352,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  349,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  349,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  350,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  350,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  351,   -1 }, /* (124) retention_list ::= retention */
  {  351,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  353,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  348,    0 }, /* (127) speed_opt ::= */
  {  348,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  329,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  329,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  329,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  329,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  329,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  329,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  329,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  361,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  361,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  361,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  361,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  361,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  361,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  361,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  361,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  361,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  361,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  358,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  358,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  366,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  360,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  360,   -3 }, /* (150) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  369,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  367,    0 }, /* (152) specific_cols_opt ::= */
  {  367,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  354,   -1 }, /* (154) full_table_name ::= table_name */
  {  354,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  355,   -1 }, /* (156) column_def_list ::= column_def */
  {  355,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  372,   -2 }, /* (158) column_def ::= column_name type_name */
  {  372,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  364,   -1 }, /* (160) type_name ::= BOOL */
  {  364,   -1 }, /* (161) type_name ::= TINYINT */
  {  364,   -1 }, /* (162) type_name ::= SMALLINT */
  {  364,   -1 }, /* (163) type_name ::= INT */
  {  364,   -1 }, /* (164) type_name ::= INTEGER */
  {  364,   -1 }, /* (165) type_name ::= BIGINT */
  {  364,   -1 }, /* (166) type_name ::= FLOAT */
  {  364,   -1 }, /* (167) type_name ::= DOUBLE */
  {  364,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  364,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  364,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  364,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  364,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  364,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  364,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  364,   -1 }, /* (175) type_name ::= JSON */
  {  364,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  364,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  364,   -1 }, /* (178) type_name ::= BLOB */
  {  364,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  364,   -1 }, /* (180) type_name ::= DECIMAL */
  {  364,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  364,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  356,    0 }, /* (183) tags_def_opt ::= */
  {  356,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  359,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  357,    0 }, /* (186) table_options ::= */
  {  357,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  357,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  357,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  357,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  357,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  357,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  357,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  362,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  362,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  375,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  375,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  373,   -1 }, /* (198) duration_list ::= duration_literal */
  {  373,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  374,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  374,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  377,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  377,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  377,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  370,   -1 }, /* (205) col_name_list ::= col_name */
  {  370,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  379,   -1 }, /* (207) col_name ::= column_name */
  {  329,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  329,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  329,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  329,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  329,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  329,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  329,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  329,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  329,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  329,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  329,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  329,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  329,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  329,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  329,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  329,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  329,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  329,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  329,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  329,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  329,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  329,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  329,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  329,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  329,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  329,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  329,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  329,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  329,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  329,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  329,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  329,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  329,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  329,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  329,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  329,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  329,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  329,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  329,   -3 }, /* (246) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  329,   -3 }, /* (247) cmd ::= SHOW CLUSTER ALIVE */
  {  380,    0 }, /* (248) db_name_cond_opt ::= */
  {  380,   -2 }, /* (249) db_name_cond_opt ::= db_name NK_DOT */
  {  381,    0 }, /* (250) like_pattern_opt ::= */
  {  381,   -2 }, /* (251) like_pattern_opt ::= LIKE NK_STRING */
  {  382,   -1 }, /* (252) table_name_cond ::= table_name */
  {  383,    0 }, /* (253) from_db_opt ::= */
  {  383,   -2 }, /* (254) from_db_opt ::= FROM db_name */
  {  384,    0 }, /* (255) tag_list_opt ::= */
  {  384,   -1 }, /* (256) tag_list_opt ::= tag_item */
  {  384,   -3 }, /* (257) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  385,   -1 }, /* (258) tag_item ::= TBNAME */
  {  385,   -1 }, /* (259) tag_item ::= QTAGS */
  {  385,   -1 }, /* (260) tag_item ::= column_name */
  {  385,   -2 }, /* (261) tag_item ::= column_name column_alias */
  {  385,   -3 }, /* (262) tag_item ::= column_name AS column_alias */
  {  329,   -8 }, /* (263) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  329,   -9 }, /* (264) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  329,   -4 }, /* (265) cmd ::= DROP INDEX exists_opt full_index_name */
  {  387,   -1 }, /* (266) full_index_name ::= index_name */
  {  387,   -3 }, /* (267) full_index_name ::= db_name NK_DOT index_name */
  {  388,  -10 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  388,  -12 }, /* (269) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  390,   -1 }, /* (270) func_list ::= func */
  {  390,   -3 }, /* (271) func_list ::= func_list NK_COMMA func */
  {  393,   -4 }, /* (272) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  394,   -1 }, /* (273) sma_func_name ::= function_name */
  {  394,   -1 }, /* (274) sma_func_name ::= COUNT */
  {  394,   -1 }, /* (275) sma_func_name ::= FIRST */
  {  394,   -1 }, /* (276) sma_func_name ::= LAST */
  {  394,   -1 }, /* (277) sma_func_name ::= LAST_ROW */
  {  392,    0 }, /* (278) sma_stream_opt ::= */
  {  392,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  392,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  392,   -3 }, /* (281) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  329,   -6 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  329,   -7 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  329,   -9 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  329,   -7 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  329,   -9 }, /* (286) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  329,   -4 }, /* (287) cmd ::= DROP TOPIC exists_opt topic_name */
  {  329,   -7 }, /* (288) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  329,   -2 }, /* (289) cmd ::= DESC full_table_name */
  {  329,   -2 }, /* (290) cmd ::= DESCRIBE full_table_name */
  {  329,   -3 }, /* (291) cmd ::= RESET QUERY CACHE */
  {  329,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  329,   -4 }, /* (293) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  397,    0 }, /* (294) analyze_opt ::= */
  {  397,   -1 }, /* (295) analyze_opt ::= ANALYZE */
  {  398,    0 }, /* (296) explain_options ::= */
  {  398,   -3 }, /* (297) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  398,   -3 }, /* (298) explain_options ::= explain_options RATIO NK_FLOAT */
  {  329,  -11 }, /* (299) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  329,   -4 }, /* (300) cmd ::= DROP FUNCTION exists_opt function_name */
  {  400,    0 }, /* (301) agg_func_opt ::= */
  {  400,   -1 }, /* (302) agg_func_opt ::= AGGREGATE */
  {  401,    0 }, /* (303) bufsize_opt ::= */
  {  401,   -2 }, /* (304) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  402,    0 }, /* (305) language_opt ::= */
  {  402,   -2 }, /* (306) language_opt ::= LANGUAGE NK_STRING */
  {  329,  -12 }, /* (307) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  329,   -4 }, /* (308) cmd ::= DROP STREAM exists_opt stream_name */
  {  405,    0 }, /* (309) col_list_opt ::= */
  {  405,   -3 }, /* (310) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (311) tag_def_or_ref_opt ::= */
  {  406,   -1 }, /* (312) tag_def_or_ref_opt ::= tags_def */
  {  406,   -4 }, /* (313) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  404,    0 }, /* (314) stream_options ::= */
  {  404,   -3 }, /* (315) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  404,   -3 }, /* (316) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  404,   -4 }, /* (317) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  404,   -3 }, /* (318) stream_options ::= stream_options WATERMARK duration_literal */
  {  404,   -4 }, /* (319) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  404,   -3 }, /* (320) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  404,   -3 }, /* (321) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  404,   -4 }, /* (322) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  407,    0 }, /* (323) subtable_opt ::= */
  {  407,   -4 }, /* (324) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  329,   -3 }, /* (325) cmd ::= KILL CONNECTION NK_INTEGER */
  {  329,   -3 }, /* (326) cmd ::= KILL QUERY NK_STRING */
  {  329,   -3 }, /* (327) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  329,   -2 }, /* (328) cmd ::= BALANCE VGROUP */
  {  329,   -4 }, /* (329) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  329,   -4 }, /* (330) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  329,   -3 }, /* (331) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  409,   -2 }, /* (332) dnode_list ::= DNODE NK_INTEGER */
  {  409,   -3 }, /* (333) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  329,   -4 }, /* (334) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  329,   -1 }, /* (335) cmd ::= query_or_subquery */
  {  329,   -1 }, /* (336) cmd ::= insert_query */
  {  399,   -7 }, /* (337) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  399,   -4 }, /* (338) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  332,   -1 }, /* (339) literal ::= NK_INTEGER */
  {  332,   -1 }, /* (340) literal ::= NK_FLOAT */
  {  332,   -1 }, /* (341) literal ::= NK_STRING */
  {  332,   -1 }, /* (342) literal ::= NK_BOOL */
  {  332,   -2 }, /* (343) literal ::= TIMESTAMP NK_STRING */
  {  332,   -1 }, /* (344) literal ::= duration_literal */
  {  332,   -1 }, /* (345) literal ::= NULL */
  {  332,   -1 }, /* (346) literal ::= NK_QUESTION */
  {  376,   -1 }, /* (347) duration_literal ::= NK_VARIABLE */
  {  411,   -1 }, /* (348) signed ::= NK_INTEGER */
  {  411,   -2 }, /* (349) signed ::= NK_PLUS NK_INTEGER */
  {  411,   -2 }, /* (350) signed ::= NK_MINUS NK_INTEGER */
  {  411,   -1 }, /* (351) signed ::= NK_FLOAT */
  {  411,   -2 }, /* (352) signed ::= NK_PLUS NK_FLOAT */
  {  411,   -2 }, /* (353) signed ::= NK_MINUS NK_FLOAT */
  {  365,   -1 }, /* (354) signed_literal ::= signed */
  {  365,   -1 }, /* (355) signed_literal ::= NK_STRING */
  {  365,   -1 }, /* (356) signed_literal ::= NK_BOOL */
  {  365,   -2 }, /* (357) signed_literal ::= TIMESTAMP NK_STRING */
  {  365,   -1 }, /* (358) signed_literal ::= duration_literal */
  {  365,   -1 }, /* (359) signed_literal ::= NULL */
  {  365,   -1 }, /* (360) signed_literal ::= literal_func */
  {  365,   -1 }, /* (361) signed_literal ::= NK_QUESTION */
  {  413,   -1 }, /* (362) literal_list ::= signed_literal */
  {  413,   -3 }, /* (363) literal_list ::= literal_list NK_COMMA signed_literal */
  {  340,   -1 }, /* (364) db_name ::= NK_ID */
  {  371,   -1 }, /* (365) table_name ::= NK_ID */
  {  363,   -1 }, /* (366) column_name ::= NK_ID */
  {  378,   -1 }, /* (367) function_name ::= NK_ID */
  {  414,   -1 }, /* (368) table_alias ::= NK_ID */
  {  386,   -1 }, /* (369) column_alias ::= NK_ID */
  {  334,   -1 }, /* (370) user_name ::= NK_ID */
  {  341,   -1 }, /* (371) topic_name ::= NK_ID */
  {  403,   -1 }, /* (372) stream_name ::= NK_ID */
  {  396,   -1 }, /* (373) cgroup_name ::= NK_ID */
  {  389,   -1 }, /* (374) index_name ::= NK_ID */
  {  415,   -1 }, /* (375) expr_or_subquery ::= expression */
  {  408,   -1 }, /* (376) expression ::= literal */
  {  408,   -1 }, /* (377) expression ::= pseudo_column */
  {  408,   -1 }, /* (378) expression ::= column_reference */
  {  408,   -1 }, /* (379) expression ::= function_expression */
  {  408,   -1 }, /* (380) expression ::= case_when_expression */
  {  408,   -3 }, /* (381) expression ::= NK_LP expression NK_RP */
  {  408,   -2 }, /* (382) expression ::= NK_PLUS expr_or_subquery */
  {  408,   -2 }, /* (383) expression ::= NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (384) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  408,   -3 }, /* (385) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (386) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  408,   -3 }, /* (387) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  408,   -3 }, /* (388) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  408,   -3 }, /* (389) expression ::= column_reference NK_ARROW NK_STRING */
  {  408,   -3 }, /* (390) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  408,   -3 }, /* (391) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  368,   -1 }, /* (392) expression_list ::= expr_or_subquery */
  {  368,   -3 }, /* (393) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  417,   -1 }, /* (394) column_reference ::= column_name */
  {  417,   -3 }, /* (395) column_reference ::= table_name NK_DOT column_name */
  {  416,   -1 }, /* (396) pseudo_column ::= ROWTS */
  {  416,   -1 }, /* (397) pseudo_column ::= TBNAME */
  {  416,   -3 }, /* (398) pseudo_column ::= table_name NK_DOT TBNAME */
  {  416,   -1 }, /* (399) pseudo_column ::= QSTART */
  {  416,   -1 }, /* (400) pseudo_column ::= QEND */
  {  416,   -1 }, /* (401) pseudo_column ::= QDURATION */
  {  416,   -1 }, /* (402) pseudo_column ::= WSTART */
  {  416,   -1 }, /* (403) pseudo_column ::= WEND */
  {  416,   -1 }, /* (404) pseudo_column ::= WDURATION */
  {  416,   -1 }, /* (405) pseudo_column ::= IROWTS */
  {  416,   -1 }, /* (406) pseudo_column ::= ISFILLED */
  {  416,   -1 }, /* (407) pseudo_column ::= QTAGS */
  {  418,   -4 }, /* (408) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  418,   -4 }, /* (409) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  418,   -6 }, /* (410) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  418,   -1 }, /* (411) function_expression ::= literal_func */
  {  412,   -3 }, /* (412) literal_func ::= noarg_func NK_LP NK_RP */
  {  412,   -1 }, /* (413) literal_func ::= NOW */
  {  422,   -1 }, /* (414) noarg_func ::= NOW */
  {  422,   -1 }, /* (415) noarg_func ::= TODAY */
  {  422,   -1 }, /* (416) noarg_func ::= TIMEZONE */
  {  422,   -1 }, /* (417) noarg_func ::= DATABASE */
  {  422,   -1 }, /* (418) noarg_func ::= CLIENT_VERSION */
  {  422,   -1 }, /* (419) noarg_func ::= SERVER_VERSION */
  {  422,   -1 }, /* (420) noarg_func ::= SERVER_STATUS */
  {  422,   -1 }, /* (421) noarg_func ::= CURRENT_USER */
  {  422,   -1 }, /* (422) noarg_func ::= USER */
  {  420,   -1 }, /* (423) star_func ::= COUNT */
  {  420,   -1 }, /* (424) star_func ::= FIRST */
  {  420,   -1 }, /* (425) star_func ::= LAST */
  {  420,   -1 }, /* (426) star_func ::= LAST_ROW */
  {  421,   -1 }, /* (427) star_func_para_list ::= NK_STAR */
  {  421,   -1 }, /* (428) star_func_para_list ::= other_para_list */
  {  423,   -1 }, /* (429) other_para_list ::= star_func_para */
  {  423,   -3 }, /* (430) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  424,   -1 }, /* (431) star_func_para ::= expr_or_subquery */
  {  424,   -3 }, /* (432) star_func_para ::= table_name NK_DOT NK_STAR */
  {  419,   -4 }, /* (433) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  419,   -5 }, /* (434) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  425,   -1 }, /* (435) when_then_list ::= when_then_expr */
  {  425,   -2 }, /* (436) when_then_list ::= when_then_list when_then_expr */
  {  428,   -4 }, /* (437) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  426,    0 }, /* (438) case_when_else_opt ::= */
  {  426,   -2 }, /* (439) case_when_else_opt ::= ELSE common_expression */
  {  429,   -3 }, /* (440) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  429,   -5 }, /* (441) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -6 }, /* (442) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -3 }, /* (443) predicate ::= expr_or_subquery IS NULL */
  {  429,   -4 }, /* (444) predicate ::= expr_or_subquery IS NOT NULL */
  {  429,   -3 }, /* (445) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  430,   -1 }, /* (446) compare_op ::= NK_LT */
  {  430,   -1 }, /* (447) compare_op ::= NK_GT */
  {  430,   -1 }, /* (448) compare_op ::= NK_LE */
  {  430,   -1 }, /* (449) compare_op ::= NK_GE */
  {  430,   -1 }, /* (450) compare_op ::= NK_NE */
  {  430,   -1 }, /* (451) compare_op ::= NK_EQ */
  {  430,   -1 }, /* (452) compare_op ::= LIKE */
  {  430,   -2 }, /* (453) compare_op ::= NOT LIKE */
  {  430,   -1 }, /* (454) compare_op ::= MATCH */
  {  430,   -1 }, /* (455) compare_op ::= NMATCH */
  {  430,   -1 }, /* (456) compare_op ::= CONTAINS */
  {  431,   -1 }, /* (457) in_op ::= IN */
  {  431,   -2 }, /* (458) in_op ::= NOT IN */
  {  432,   -3 }, /* (459) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  433,   -1 }, /* (460) boolean_value_expression ::= boolean_primary */
  {  433,   -2 }, /* (461) boolean_value_expression ::= NOT boolean_primary */
  {  433,   -3 }, /* (462) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  433,   -3 }, /* (463) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  434,   -1 }, /* (464) boolean_primary ::= predicate */
  {  434,   -3 }, /* (465) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  427,   -1 }, /* (466) common_expression ::= expr_or_subquery */
  {  427,   -1 }, /* (467) common_expression ::= boolean_value_expression */
  {  435,    0 }, /* (468) from_clause_opt ::= */
  {  435,   -2 }, /* (469) from_clause_opt ::= FROM table_reference_list */
  {  436,   -1 }, /* (470) table_reference_list ::= table_reference */
  {  436,   -3 }, /* (471) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  437,   -1 }, /* (472) table_reference ::= table_primary */
  {  437,   -1 }, /* (473) table_reference ::= joined_table */
  {  438,   -2 }, /* (474) table_primary ::= table_name alias_opt */
  {  438,   -4 }, /* (475) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  438,   -2 }, /* (476) table_primary ::= subquery alias_opt */
  {  438,   -1 }, /* (477) table_primary ::= parenthesized_joined_table */
  {  440,    0 }, /* (478) alias_opt ::= */
  {  440,   -1 }, /* (479) alias_opt ::= table_alias */
  {  440,   -2 }, /* (480) alias_opt ::= AS table_alias */
  {  442,   -3 }, /* (481) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  442,   -3 }, /* (482) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  439,   -6 }, /* (483) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  443,    0 }, /* (484) join_type ::= */
  {  443,   -1 }, /* (485) join_type ::= INNER */
  {  445,  -12 }, /* (486) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  446,    0 }, /* (487) set_quantifier_opt ::= */
  {  446,   -1 }, /* (488) set_quantifier_opt ::= DISTINCT */
  {  446,   -1 }, /* (489) set_quantifier_opt ::= ALL */
  {  447,   -1 }, /* (490) select_list ::= select_item */
  {  447,   -3 }, /* (491) select_list ::= select_list NK_COMMA select_item */
  {  455,   -1 }, /* (492) select_item ::= NK_STAR */
  {  455,   -1 }, /* (493) select_item ::= common_expression */
  {  455,   -2 }, /* (494) select_item ::= common_expression column_alias */
  {  455,   -3 }, /* (495) select_item ::= common_expression AS column_alias */
  {  455,   -3 }, /* (496) select_item ::= table_name NK_DOT NK_STAR */
  {  410,    0 }, /* (497) where_clause_opt ::= */
  {  410,   -2 }, /* (498) where_clause_opt ::= WHERE search_condition */
  {  448,    0 }, /* (499) partition_by_clause_opt ::= */
  {  448,   -3 }, /* (500) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  456,   -1 }, /* (501) partition_list ::= partition_item */
  {  456,   -3 }, /* (502) partition_list ::= partition_list NK_COMMA partition_item */
  {  457,   -1 }, /* (503) partition_item ::= expr_or_subquery */
  {  457,   -2 }, /* (504) partition_item ::= expr_or_subquery column_alias */
  {  457,   -3 }, /* (505) partition_item ::= expr_or_subquery AS column_alias */
  {  452,    0 }, /* (506) twindow_clause_opt ::= */
  {  452,   -6 }, /* (507) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  452,   -4 }, /* (508) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  452,   -6 }, /* (509) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -8 }, /* (510) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -7 }, /* (511) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  391,    0 }, /* (512) sliding_opt ::= */
  {  391,   -4 }, /* (513) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  451,    0 }, /* (514) fill_opt ::= */
  {  451,   -4 }, /* (515) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  451,   -6 }, /* (516) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  451,   -6 }, /* (517) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  458,   -1 }, /* (518) fill_mode ::= NONE */
  {  458,   -1 }, /* (519) fill_mode ::= PREV */
  {  458,   -1 }, /* (520) fill_mode ::= NULL */
  {  458,   -1 }, /* (521) fill_mode ::= NULL_F */
  {  458,   -1 }, /* (522) fill_mode ::= LINEAR */
  {  458,   -1 }, /* (523) fill_mode ::= NEXT */
  {  453,    0 }, /* (524) group_by_clause_opt ::= */
  {  453,   -3 }, /* (525) group_by_clause_opt ::= GROUP BY group_by_list */
  {  459,   -1 }, /* (526) group_by_list ::= expr_or_subquery */
  {  459,   -3 }, /* (527) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  454,    0 }, /* (528) having_clause_opt ::= */
  {  454,   -2 }, /* (529) having_clause_opt ::= HAVING search_condition */
  {  449,    0 }, /* (530) range_opt ::= */
  {  449,   -6 }, /* (531) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  450,    0 }, /* (532) every_opt ::= */
  {  450,   -4 }, /* (533) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  460,   -4 }, /* (534) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  461,   -1 }, /* (535) query_simple ::= query_specification */
  {  461,   -1 }, /* (536) query_simple ::= union_query_expression */
  {  465,   -4 }, /* (537) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  465,   -3 }, /* (538) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  466,   -1 }, /* (539) query_simple_or_subquery ::= query_simple */
  {  466,   -1 }, /* (540) query_simple_or_subquery ::= subquery */
  {  395,   -1 }, /* (541) query_or_subquery ::= query_expression */
  {  395,   -1 }, /* (542) query_or_subquery ::= subquery */
  {  462,    0 }, /* (543) order_by_clause_opt ::= */
  {  462,   -3 }, /* (544) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  463,    0 }, /* (545) slimit_clause_opt ::= */
  {  463,   -2 }, /* (546) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  463,   -4 }, /* (547) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  463,   -4 }, /* (548) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  464,    0 }, /* (549) limit_clause_opt ::= */
  {  464,   -2 }, /* (550) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  464,   -4 }, /* (551) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  464,   -4 }, /* (552) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  441,   -3 }, /* (553) subquery ::= NK_LP query_expression NK_RP */
  {  441,   -3 }, /* (554) subquery ::= NK_LP subquery NK_RP */
  {  444,   -1 }, /* (555) search_condition ::= common_expression */
  {  467,   -1 }, /* (556) sort_specification_list ::= sort_specification */
  {  467,   -3 }, /* (557) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  468,   -3 }, /* (558) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  469,    0 }, /* (559) ordering_specification_opt ::= */
  {  469,   -1 }, /* (560) ordering_specification_opt ::= ASC */
  {  469,   -1 }, /* (561) ordering_specification_opt ::= DESC */
  {  470,    0 }, /* (562) null_ordering_opt ::= */
  {  470,   -2 }, /* (563) null_ordering_opt ::= NULLS FIRST */
  {  470,   -2 }, /* (564) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,330,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,333,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,331,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy0, yymsp[0].minor.yy857); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy857 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy857 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy303 = yymsp[0].minor.yy303; }
  yymsp[0].minor.yy303 = yylhsminor.yy303;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy303 = yymsp[-2].minor.yy303 | yymsp[0].minor.yy303; }
  yymsp[-2].minor.yy303 = yylhsminor.yy303;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy881; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 42: /* priv_level ::= topic_name */
      case 273: /* sma_func_name ::= function_name */ yytestcase(yyruleno==273);
      case 479: /* alias_opt ::= table_alias */ yytestcase(yyruleno==479);
{ yylhsminor.yy881 = yymsp[0].minor.yy881; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy881, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy587); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy587); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 274: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST */ yytestcase(yyruleno==276);
      case 277: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==277);
      case 364: /* db_name ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* table_name ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* column_name ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* function_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 368: /* table_alias ::= NK_ID */ yytestcase(yyruleno==368);
      case 369: /* column_alias ::= NK_ID */ yytestcase(yyruleno==369);
      case 370: /* user_name ::= NK_ID */ yytestcase(yyruleno==370);
      case 371: /* topic_name ::= NK_ID */ yytestcase(yyruleno==371);
      case 372: /* stream_name ::= NK_ID */ yytestcase(yyruleno==372);
      case 373: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==373);
      case 374: /* index_name ::= NK_ID */ yytestcase(yyruleno==374);
      case 414: /* noarg_func ::= NOW */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= TODAY */ yytestcase(yyruleno==415);
      case 416: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==416);
      case 417: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==417);
      case 418: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==418);
      case 419: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==419);
      case 420: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==420);
      case 421: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==421);
      case 422: /* noarg_func ::= USER */ yytestcase(yyruleno==422);
      case 423: /* star_func ::= COUNT */ yytestcase(yyruleno==423);
      case 424: /* star_func ::= FIRST */ yytestcase(yyruleno==424);
      case 425: /* star_func ::= LAST */ yytestcase(yyruleno==425);
      case 426: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==426);
{ yylhsminor.yy881 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 294: /* analyze_opt ::= */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= */ yytestcase(yyruleno==301);
      case 487: /* set_quantifier_opt ::= */ yytestcase(yyruleno==487);
{ yymsp[1].minor.yy587 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 295: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==295);
      case 302: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==302);
      case 488: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==488);
{ yymsp[0].minor.yy587 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy587, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy214); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy587 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy587 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy140 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_KEEP, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_RETENTIONS, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy140 = createAlterDatabaseOptions(pCxt); yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yylhsminor.yy140, &yymsp[0].minor.yy809); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy140, &yymsp[0].minor.yy809); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy809.type = DB_OPTION_KEEP; yymsp[-1].minor.yy809.pList = yymsp[0].minor.yy220; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_PAGES; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_WAL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 333: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==333);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy220 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func */ yytestcase(yyruleno==270);
      case 362: /* literal_list ::= signed_literal */ yytestcase(yyruleno==362);
      case 429: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==429);
      case 435: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==435);
      case 490: /* select_list ::= select_item */ yytestcase(yyruleno==490);
      case 501: /* partition_list ::= partition_item */ yytestcase(yyruleno==501);
      case 556: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==556);
{ yylhsminor.yy220 = createNodeList(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 150: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==150);
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 257: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==257);
      case 271: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==271);
      case 363: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==363);
      case 430: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==430);
      case 491: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==491);
      case 502: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==502);
      case 557: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==557);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy140 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 127: /* speed_opt ::= */
      case 303: /* bufsize_opt ::= */ yytestcase(yyruleno==303);
{ yymsp[1].minor.yy214 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 304: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==304);
{ yymsp[-1].minor.yy214 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy220, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 335: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==335);
      case 336: /* cmd ::= insert_query */ yytestcase(yyruleno==336);
{ pCxt->pRootNode = yymsp[0].minor.yy140; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy140); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy140 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy140 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy140, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 436: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==436);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy220 = yylhsminor.yy220;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy140 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy587, yymsp[-8].minor.yy140, yymsp[-6].minor.yy140, yymsp[-5].minor.yy220, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-9].minor.yy140 = yylhsminor.yy140;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy140 = createDropTableClause(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 255: /* tag_list_opt ::= */ yytestcase(yyruleno==255);
      case 309: /* col_list_opt ::= */ yytestcase(yyruleno==309);
      case 311: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==311);
      case 499: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==499);
      case 524: /* group_by_clause_opt ::= */ yytestcase(yyruleno==524);
      case 543: /* order_by_clause_opt ::= */ yytestcase(yyruleno==543);
{ yymsp[1].minor.yy220 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 310: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==310);
{ yymsp[-2].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682, NULL); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-2].minor.yy682, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 312: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==312);
      case 428: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==428);
{ yylhsminor.yy220 = yymsp[0].minor.yy220; }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 313: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==313);
{ yymsp[-3].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy140 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_SMA, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy140 = createAlterTableOptions(pCxt); yylhsminor.yy140 = setTableOption(pCxt, yylhsminor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 392: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==392);
{ yylhsminor.yy220 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 393: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==393);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 259: /* tag_item ::= QTAGS */ yytestcase(yyruleno==259);
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 207: /* col_name ::= column_name */
      case 260: /* tag_item ::= column_name */ yytestcase(yyruleno==260);
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy140, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy140); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140, yymsp[-3].minor.yy220); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy140,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 247: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 248: /* db_name_cond_opt ::= */
      case 253: /* from_db_opt ::= */ yytestcase(yyruleno==253);
{ yymsp[1].minor.yy140 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 249: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 250: /* like_pattern_opt ::= */
      case 323: /* subtable_opt ::= */ yytestcase(yyruleno==323);
      case 438: /* case_when_else_opt ::= */ yytestcase(yyruleno==438);
      case 468: /* from_clause_opt ::= */ yytestcase(yyruleno==468);
      case 497: /* where_clause_opt ::= */ yytestcase(yyruleno==497);
      case 506: /* twindow_clause_opt ::= */ yytestcase(yyruleno==506);
      case 512: /* sliding_opt ::= */ yytestcase(yyruleno==512);
      case 514: /* fill_opt ::= */ yytestcase(yyruleno==514);
      case 528: /* having_clause_opt ::= */ yytestcase(yyruleno==528);
      case 530: /* range_opt ::= */ yytestcase(yyruleno==530);
      case 532: /* every_opt ::= */ yytestcase(yyruleno==532);
      case 545: /* slimit_clause_opt ::= */ yytestcase(yyruleno==545);
      case 549: /* limit_clause_opt ::= */ yytestcase(yyruleno==549);
{ yymsp[1].minor.yy140 = NULL; }
        break;
      case 251: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 252: /* table_name_cond ::= table_name */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 254: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 258: /* tag_item ::= TBNAME */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 261: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 262: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 263: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy587, yymsp[-3].minor.yy140, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 264: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy140, yymsp[-1].minor.yy220, NULL); }
        break;
      case 265: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 266: /* full_index_name ::= index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 267: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy140 = createIndexOption(pCxt, yymsp[-7].minor.yy220, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 269: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy140 = createIndexOption(pCxt, yymsp[-9].minor.yy220, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 272: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 278: /* sma_stream_opt ::= */
      case 314: /* stream_options ::= */ yytestcase(yyruleno==314);
{ yymsp[1].minor.yy140 = createStreamOptions(pCxt); }
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 318: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==318);
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 281: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
      case 321: /* stream_options ::= stream_options DELETE_MARK duration_literal */ yytestcase(yyruleno==321);
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy881, false); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, &yymsp[0].minor.yy881, true); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, yymsp[0].minor.yy140, false); }
        break;
      case 286: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, yymsp[0].minor.yy140, true); }
        break;
      case 287: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 288: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 289: /* cmd ::= DESC full_table_name */
      case 290: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==290);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 291: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 293: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==293);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy587, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 296: /* explain_options ::= */
{ yymsp[1].minor.yy140 = createDefaultExplainOptions(pCxt); }
        break;
      case 297: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy140 = setExplainVerbose(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 298: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy140 = setExplainRatio(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 299: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy587, yymsp[-9].minor.yy587, &yymsp[-6].minor.yy881, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy682, yymsp[-1].minor.yy214, &yymsp[0].minor.yy881); }
        break;
      case 300: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 305: /* language_opt ::= */
{ yymsp[1].minor.yy881 = nil_token; }
        break;
      case 306: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy881 = yymsp[0].minor.yy0; }
        break;
      case 307: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy587, &yymsp[-8].minor.yy881, yymsp[-5].minor.yy140, yymsp[-7].minor.yy140, yymsp[-3].minor.yy220, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, yymsp[-4].minor.yy220); }
        break;
      case 308: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 315: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 316: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 317: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy140)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy140)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-3].minor.yy140; }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 319: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy140)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy140 = yymsp[-3].minor.yy140; }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 320: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 322: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy140)->ignoreUpdate = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy140 = yymsp[-3].minor.yy140; }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 324: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 513: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==513);
      case 533: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==533);
{ yymsp[-3].minor.yy140 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy140); }
        break;
      case 325: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 326: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 327: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 328: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 329: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 330: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy220); }
        break;
      case 331: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 332: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 334: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 337: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy140 = createInsertStmt(pCxt, yymsp[-4].minor.yy140, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 338: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy140 = createInsertStmt(pCxt, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 339: /* literal ::= NK_INTEGER */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 340: /* literal ::= NK_FLOAT */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 341: /* literal ::= NK_STRING */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 342: /* literal ::= NK_BOOL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 343: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 344: /* literal ::= duration_literal */
      case 354: /* signed_literal ::= signed */ yytestcase(yyruleno==354);
      case 375: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==375);
      case 376: /* expression ::= literal */ yytestcase(yyruleno==376);
      case 377: /* expression ::= pseudo_column */ yytestcase(yyruleno==377);
      case 378: /* expression ::= column_reference */ yytestcase(yyruleno==378);
      case 379: /* expression ::= function_expression */ yytestcase(yyruleno==379);
      case 380: /* expression ::= case_when_expression */ yytestcase(yyruleno==380);
      case 411: /* function_expression ::= literal_func */ yytestcase(yyruleno==411);
      case 460: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==460);
      case 464: /* boolean_primary ::= predicate */ yytestcase(yyruleno==464);
      case 466: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==466);
      case 467: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==467);
      case 470: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==470);
      case 472: /* table_reference ::= table_primary */ yytestcase(yyruleno==472);
      case 473: /* table_reference ::= joined_table */ yytestcase(yyruleno==473);
      case 477: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==477);
      case 535: /* query_simple ::= query_specification */ yytestcase(yyruleno==535);
      case 536: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==536);
      case 539: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==539);
      case 541: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==541);
{ yylhsminor.yy140 = yymsp[0].minor.yy140; }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 345: /* literal ::= NULL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 346: /* literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 347: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 348: /* signed ::= NK_INTEGER */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 349: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 350: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 351: /* signed ::= NK_FLOAT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 352: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 353: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 355: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 356: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 357: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 358: /* signed_literal ::= duration_literal */
      case 360: /* signed_literal ::= literal_func */ yytestcase(yyruleno==360);
      case 431: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==431);
      case 493: /* select_item ::= common_expression */ yytestcase(yyruleno==493);
      case 503: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==503);
      case 540: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==540);
      case 542: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==542);
      case 555: /* search_condition ::= common_expression */ yytestcase(yyruleno==555);
{ yylhsminor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 359: /* signed_literal ::= NULL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 361: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 381: /* expression ::= NK_LP expression NK_RP */
      case 465: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==465);
      case 554: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==554);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 382: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy140));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 383: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 384: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 385: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 386: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 387: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 388: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 389: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 390: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 391: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 394: /* column_reference ::= column_name */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy881, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 395: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 396: /* pseudo_column ::= ROWTS */
      case 397: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==397);
      case 399: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= QEND */ yytestcase(yyruleno==400);
      case 401: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==401);
      case 402: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==402);
      case 403: /* pseudo_column ::= WEND */ yytestcase(yyruleno==403);
      case 404: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==404);
      case 405: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==405);
      case 406: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==406);
      case 407: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==407);
      case 413: /* literal_func ::= NOW */ yytestcase(yyruleno==413);
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 398: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy881)))); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 408: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 409: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==409);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 410: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy682)); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 412: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy881, NULL)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 427: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy220 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 432: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 496: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==496);
{ yylhsminor.yy140 = createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 433: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 434: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 437: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy140 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
        break;
      case 439: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
        break;
      case 440: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 445: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==445);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy794, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 441: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 442: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 443: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 444: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL));
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 446: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_THAN; }
        break;
      case 447: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_THAN; }
        break;
      case 448: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 449: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 450: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy794 = OP_TYPE_NOT_EQUAL; }
        break;
      case 451: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy794 = OP_TYPE_EQUAL; }
        break;
      case 452: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy794 = OP_TYPE_LIKE; }
        break;
      case 453: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_LIKE; }
        break;
      case 454: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_MATCH; }
        break;
      case 455: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_NMATCH; }
        break;
      case 456: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy794 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 457: /* in_op ::= IN */
{ yymsp[0].minor.yy794 = OP_TYPE_IN; }
        break;
      case 458: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_IN; }
        break;
      case 459: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 461: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 462: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 463: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 469: /* from_clause_opt ::= FROM table_reference_list */
      case 498: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==498);
      case 529: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==529);
{ yymsp[-1].minor.yy140 = yymsp[0].minor.yy140; }
        break;
      case 471: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 474: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 475: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 476: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy140 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 478: /* alias_opt ::= */
{ yymsp[1].minor.yy881 = nil_token;  }
        break;
      case 480: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy881 = yymsp[0].minor.yy881; }
        break;
      case 481: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 482: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==482);
{ yymsp[-2].minor.yy140 = yymsp[-1].minor.yy140; }
        break;
      case 483: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, yymsp[-4].minor.yy852, yymsp[-5].minor.yy140, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 484: /* join_type ::= */
{ yymsp[1].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 485: /* join_type ::= INNER */
{ yymsp[0].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 486: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy140 = createSelectStmt(pCxt, yymsp[-10].minor.yy587, yymsp[-9].minor.yy220, yymsp[-8].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addWhereClause(pCxt, yymsp[-11].minor.yy140, yymsp[-7].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addPartitionByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-6].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy140, yymsp[-2].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addGroupByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-1].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addHavingClause(pCxt, yymsp[-11].minor.yy140, yymsp[0].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addRangeClause(pCxt, yymsp[-11].minor.yy140, yymsp[-5].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addEveryClause(pCxt, yymsp[-11].minor.yy140, yymsp[-4].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addFillClause(pCxt, yymsp[-11].minor.yy140, yymsp[-3].minor.yy140);
                                                                                  }
        break;
      case 489: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy587 = false; }
        break;
      case 492: /* select_item ::= NK_STAR */
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 494: /* select_item ::= common_expression column_alias */
      case 504: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==504);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 495: /* select_item ::= common_expression AS column_alias */
      case 505: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==505);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 500: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 525: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==525);
      case 544: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==544);
{ yymsp[-2].minor.yy220 = yymsp[0].minor.yy220; }
        break;
      case 507: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy140 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 508: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy140 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 509: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 510: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 511: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy140 = createEventWindowNode(pCxt, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 515: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy140 = createFillNode(pCxt, yymsp[-1].minor.yy174, NULL); }
        break;
      case 516: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 517: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 518: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy174 = FILL_MODE_NONE; }
        break;
      case 519: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy174 = FILL_MODE_PREV; }
        break;
      case 520: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL; }
        break;
      case 521: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL_F; }
        break;
      case 522: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy174 = FILL_MODE_LINEAR; }
        break;
      case 523: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy174 = FILL_MODE_NEXT; }
        break;
      case 526: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy220 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 527: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 531: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy140 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 534: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy140 = addOrderByClause(pCxt, yymsp[-3].minor.yy140, yymsp[-2].minor.yy220);
                                                                                    yylhsminor.yy140 = addSlimitClause(pCxt, yylhsminor.yy140, yymsp[-1].minor.yy140);
                                                                                    yylhsminor.yy140 = addLimitClause(pCxt, yylhsminor.yy140, yymsp[0].minor.yy140);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 537: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 538: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 546: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 550: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==550);
{ yymsp[-1].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 547: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 551: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==551);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 548: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 552: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==552);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 553: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 558: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy140 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[-1].minor.yy866, yymsp[0].minor.yy697); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 559: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy866 = ORDER_ASC; }
        break;
      case 560: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy866 = ORDER_ASC; }
        break;
      case 561: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy866 = ORDER_DESC; }
        break;
      case 562: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy697 = NULL_ORDER_DEFAULT; }
        break;
      case 563: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_FIRST; }
        break;
      case 564: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
