###################################################################
#           Copyright (c) 2021 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
from util.log import *
from util.cases import *
from util.sql import *


class TDTestCase:
    def caseDescription(self):
        '''
        case1<Ganlin Zhao>: [TD-11220]<feature>: time related functions
        '''
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def getBuildPath(self):
        selfPath = os.path.dirname(os.path.realpath(__file__))

        if ("community" in selfPath):
            projPath = selfPath[:selfPath.find("community")]
        else:
            projPath = selfPath[:selfPath.find("tests")]

        for root, dirs, files in os.walk(projPath):
            if ("taosd" in files):
                rootRealPath = os.path.dirname(os.path.realpath(root))
                if ("packaging" not in rootRealPath):
                    buildPath = root[:len(root) - len("/build/bin")]
                    break
        return buildPath

    def checkTimestampEqual(self, elm, expect_elm):
        caller = inspect.getframeinfo(inspect.stack()[1][0])
        if len(elm) == len(expect_elm):
            delta = abs(int(elm[-1]) - int(expect_elm[-1]))
            if delta == 1: #ignore 1 second diff
                new_elm = expect_elm[0:-1] + elm[-1]
            else:
                new_elm = expect_elm;
            if elm == new_elm:
                tdLog.info("sql:%s, elm:%s == expect_elm:%s" % (tdSql.sql, elm, new_elm))
            else:
                args = (caller.filename, caller.lineno, tdSql.sql, elm, new_elm)
                tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)
        else:
            args = (caller.filename, caller.lineno, tdSql.sql, elm, expect_elm)
            tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)


    def run(self):
        print("running {}".format(__file__))

        #Prepare data
        #db precision "ms"
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "us"
        tdSql.execute("drop database if exists db_u")
        tdSql.execute("create database if not exists db_u precision 'us'")
        tdSql.execute('use db_u')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "ns"
        tdSql.execute("drop database if exists db_n")
        tdSql.execute("create database if not exists db_n precision 'ns'")
        tdSql.execute('use db_n')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #execute query
        print("============== STEP 1: select timezone()  ================== ")

        # db precision "ms"
        tdSql.execute('use db_m')

        timezone = 'Asia/Shanghai (CST, +0800)'

        tdSql.query("select timezone() from tb")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.query("select timezone() from ctb")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.query("select timezone() from stb")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, timezone)

        #timezone(), col
        tdSql.query("select timezone(),col_bigint from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timezone(),col_bigint from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timezone(),col_bigint from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timezone(),col_bool from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, True)
        tdSql.query("select timezone(),col_bool from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, True)
        tdSql.query("select timezone(),col_bool from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, True)

        tdSql.query("select timezone(),col_float from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timezone(),col_float from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timezone(),col_float from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timezone(),col_binary from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timezone(),col_binary from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timezone(),col_binary from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select ts, col_smallint, col_float, timezone(), col_binary, col_timestamp from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, timezone)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, timezone(), col_binary, col_timestamp from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, timezone)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, timezone(), col_binary, col_timestamp from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, timezone)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #timezone(), tag
        tdSql.query("select timezone(),tag_bigint from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timezone(),tag_bigint from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timezone(),tag_bool from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, True)
        tdSql.query("select timezone(),tag_bool from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, True)

        tdSql.query("select timezone(),tag_float from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timezone(),tag_float from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timezone(),tag_binary from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timezone(),tag_binary from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select tag_smallint, tag_float, timezone(), tag_binary, tag_timestamp from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(0, 2, timezone)
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select tag_smallint, tag_float, timezone(), tag_binary, tag_timestamp from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(0, 2, timezone)
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #timezone(),tbname
        tdSql.query("select timezone(),tbname from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "tb")
        tdSql.query("select timezone(),tbname from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "ctb")
        tdSql.query("select timezone(),tbname from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, "ctb")

        #timezone(),_c0/_C0
        tdSql.query("select timezone(),_c0 from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timezone(),_c0 from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timezone(),_c0 from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _C0,timezone() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, timezone)
        tdSql.query("select _C0,timezone() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, timezone)
        tdSql.query("select _C0,timezone() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, timezone)

        #timezone(),func()
        #can only be used with scalar functions together
        tdSql.query("select timezone(),ceil(col_bigint) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timezone(),ceil(col_bigint) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timezone(),ceil(col_bigint) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timezone(),round(col_float) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timezone(),round(col_float) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timezone(),round(col_float) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timezone(),floor(1.5) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timezone(),floor(1.5) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timezone(),floor(1.5) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select abs(-1),timezone() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, timezone)
        tdSql.query("select abs(-1),timezone() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, timezone)
        tdSql.query("select abs(-1),timezone() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, timezone)

        tdSql.query("select pow(2,2),timezone() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, timezone)
        tdSql.query("select pow(2,2),timezone() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, timezone)
        tdSql.query("select pow(2,2),timezone() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, timezone)

        #timezone(),timezone()
        tdSql.query("select timezone(),timezone(),timezone() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, timezone)
        tdSql.checkData(0, 2, timezone)
        tdSql.query("select timezone(),timezone(),timezone() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, timezone)
        tdSql.checkData(0, 2, timezone)
        tdSql.query("select timezone(),timezone(),timezone() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(0, 1, timezone)
        tdSql.checkData(0, 2, timezone)

        #timezone(),constant
        tdSql.query("select 123,123.0,true,'123',timezone() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, timezone)
        tdSql.query("select 123,123.0,true,'123',timezone() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, timezone)
        tdSql.query("select 123,123.0,true,'123',timezone() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, timezone)

        #insert some more data
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '2022-02-02 02:00:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '2022-02-02 02:00:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2022-02-02 02:00:02', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2022-02-02 02:00:02', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #order by
        tdSql.query("select timezone() from tb order by ts")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query("select timezone() from ctb order by ts")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query("select timezone() from stb order by ts")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        tdSql.query("select timezone() from tb order by ts desc")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query("select timezone() from ctb order by ts desc")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query("select timezone() from stb order by ts desc")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        #limit/offset
        tdSql.query("select timezone() from tb limit 2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.query("select timezone() from ctb limit 2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.query("select timezone() from stb limit 2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)

        tdSql.query("select timezone() from tb limit 2 offset 1")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.query("select timezone() from ctb limit 2 offset 1")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.query("select timezone() from stb limit 2 offset 1")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)

        tdSql.query("select timezone() from tb limit 1,2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.query("select timezone() from ctb limit 1,2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.query("select timezone() from stb limit 1,2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)

        #join
        tdSql.execute("create stable stb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb1 using stb1 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("create stable stb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb2 using stb2 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.query('select timezone() from tb1, tb2 where tb1.col_timestamp = tb2.col_timestamp');
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        tdSql.query('select timezone() from ctb1, ctb2 where ctb1.col_timestamp = ctb2.col_timestamp');
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        tdSql.query('select timezone() from stb1, stb2 where stb1.col_timestamp = stb2.col_timestamp and stb1.tag_int = stb2.tag_int');
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        #union all
        tdSql.query('select timezone() from tb1 union all select timezone() from tb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.checkData(3, 0, timezone)
        tdSql.checkData(4, 0, timezone)
        tdSql.checkData(5, 0, timezone)
        tdSql.query('select timezone() from ctb1 union all select timezone() from ctb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.checkData(3, 0, timezone)
        tdSql.checkData(4, 0, timezone)
        tdSql.checkData(5, 0, timezone)
        tdSql.query('select timezone() from stb1 union all select timezone() from stb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.checkData(3, 0, timezone)
        tdSql.checkData(4, 0, timezone)
        tdSql.checkData(5, 0, timezone)

        #nested query
        tdSql.query('select timezone() from (select * from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select timezone() from (select * from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select timezone() from (select * from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        tdSql.query('select timezone() from (select col_int as val from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select timezone() from (select col_int as val from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select timezone() from (select col_int as val from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        tdSql.query('select * from (select timezone() from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select * from (select timezone() from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select * from (select timezone() from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        tdSql.query('select _c0 from (select timezone() from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select _c0 from (select timezone() from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select _c0 from (select timezone() from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        tdSql.query('select timezone() from (select timezone() from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select timezone() from (select timezone() from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)
        tdSql.query('select timezone() from (select timezone() from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, timezone)
        tdSql.checkData(1, 0, timezone)
        tdSql.checkData(2, 0, timezone)

        ##ERROR CASES
        #param
        tdSql.error("select timezone(1) from tb")
        tdSql.error("select timezone(1) from ctb")
        tdSql.error("select timezone(1) from stb")
        tdSql.error("select timezone(1.0) from tb")
        tdSql.error("select timezone(1.0) from ctb")
        tdSql.error("select timezone(1.0) from stb")
        tdSql.error("select timezone(\"abc\") from tb")
        tdSql.error("select timezone(\"abc\") from ctb")
        tdSql.error("select timezone(\"abc\") from stb")
        tdSql.error("select timezone('abc') from tb")
        tdSql.error("select timezone('abc') from ctb")
        tdSql.error("select timezone('abc') from stb")
        tdSql.error("select timezone(timezone) from tb")
        tdSql.error("select timezone(timezone) from ctb")
        tdSql.error("select timezone(timezone) from stb")
        #tdSql.error("select timezone(*) from tb")
        #tdSql.error("select timezone(*) from ctb")
        #tdSql.error("select timezone(*) from stb")
        tdSql.error("select timezone(_c0) from tb")
        tdSql.error("select timezone(_c0) from ctb")
        tdSql.error("select timezone(_c0) from stb")
        tdSql.error("select timezone(_C0) from tb")
        tdSql.error("select timezone(_C0) from ctb")
        tdSql.error("select timezone(_C0) from stb")
        tdSql.error("select timezone(tbname) from tb")
        tdSql.error("select timezone(tbname) from ctb")
        tdSql.error("select timezone(tbname) from stb")
        tdSql.error("select timezone(ts) from tb")
        tdSql.error("select timezone(ts) from ctb")
        tdSql.error("select timezone(ts) from stb")
        tdSql.error("select timezone(col_timestamp) from tb")
        tdSql.error("select timezone(col_timestamp) from ctb")
        tdSql.error("select timezone(col_timestamp) from stb")
        tdSql.error("select timezone(col_bigint) from tb")
        tdSql.error("select timezone(col_bigint) from ctb")
        tdSql.error("select timezone(col_bigint) from stb")
        tdSql.error("select timezone(col_double) from tb")
        tdSql.error("select timezone(col_double) from ctb")
        tdSql.error("select timezone(col_double) from stb")
        tdSql.error("select timezone(col_bool) from tb")
        tdSql.error("select timezone(col_bool) from ctb")
        tdSql.error("select timezone(col_bool) from stb")
        tdSql.error("select timezone(col_binary) from tb")
        tdSql.error("select timezone(col_binary) from ctb")
        tdSql.error("select timezone(col_binary) from stb")
        tdSql.error("select timezone(tag_timestamp) from tb")
        tdSql.error("select timezone(tag_timestamp) from ctb")
        tdSql.error("select timezone(tag_timestamp) from stb")
        tdSql.error("select timezone(tag_bigint) from tb")
        tdSql.error("select timezone(tag_bigint) from ctb")
        tdSql.error("select timezone(tag_bigint) from stb")
        tdSql.error("select timezone(tag_double) from tb")
        tdSql.error("select timezone(tag_double) from ctb")
        tdSql.error("select timezone(tag_double) from stb")
        tdSql.error("select timezone(tag_bool) from tb")
        tdSql.error("select timezone(tag_bool) from ctb")
        tdSql.error("select timezone(tag_bool) from stb")
        tdSql.error("select timezone(tag_binary) from tb")
        tdSql.error("select timezone(tag_binary) from ctb")
        tdSql.error("select timezone(tag_binary) from stb")
        tdSql.error("select timezone(1,'abc',col_bigint) from tb")
        tdSql.error("select timezone(1,'abc',col_bigint) from ctb")
        tdSql.error("select timezone(1,'abc',col_bigint) from stb")

        #distinct
        tdSql.error("select distinct timezone() from tb")
        tdSql.error("select distinct timezone() from ctb")
        tdSql.error("select distinct timezone() from stb")

        #arithmetic
        tdSql.error("select timezone() + count(*) from tb")
        tdSql.error("select timezone() + count(*) from ctb")
        tdSql.error("select timezone() + count(*) from stb")
        tdSql.error("select timezone() + avg(col_timestamp) from tb")
        tdSql.error("select timezone() + avg(col_timestamp) from ctb")
        tdSql.error("select timezone() + avg(col_timestamp) from stb")
        tdSql.error("select timezone() + sum(col_int) from tb")
        tdSql.error("select timezone() + sum(col_int) from ctb")
        tdSql.error("select timezone() + sum(col_int) from stb")

        tdSql.error("select timezone() + max(col_timestamp) from tb")
        tdSql.error("select timezone() + max(col_timestamp) from ctb")
        tdSql.error("select timezone() + max(col_timestamp) from stb")
        tdSql.error("select timezone() + first(col_timestamp) from tb")
        tdSql.error("select timezone() + first(col_timestamp) from ctb")
        tdSql.error("select timezone() + first(col_timestamp) from stb")
        tdSql.error("select timezone() + top(col_timestamp, 1) from tb")
        tdSql.error("select timezone() + top(col_timestamp, 1) from ctb")
        tdSql.error("select timezone() + top(col_timestamp, 1) from stb")

        tdSql.error("select timezone() + ceil(col_timestamp) from tb")
        tdSql.error("select timezone() + ceil(col_timestamp) from ctb")
        tdSql.error("select timezone() + ceil(col_timestamp) from stb")
        tdSql.error("select timezone() + floor(col_int) from tb")
        tdSql.error("select timezone() + floor(col_int) from ctb")
        tdSql.error("select timezone() + floor(col_int) from stb")
        tdSql.error("select timezone() + round(1.5) from tb")
        tdSql.error("select timezone() + round(1.5) from ctb")
        tdSql.error("select timezone() + round(1.5) from stb")
        tdSql.error("select timezone() + diff(col_timestamp) from tb")
        tdSql.error("select timezone() + diff(col_timestamp) from ctb")
        tdSql.error("select timezone() + diff(col_timestamp) from stb")

        tdSql.error("select timezone() + 1 from tb")
        tdSql.error("select timezone() + 1 from ctb")
        tdSql.error("select timezone() + 1 from stb")
        tdSql.error("select timezone() + 1.5 from tb")
        tdSql.error("select timezone() + 1.5 from ctb")
        tdSql.error("select timezone() + 1.5 from stb")
        #tdSql.error("select timezone() + true from tb")
        #tdSql.error("select timezone() + true from ctb")
        #tdSql.error("select timezone() + true from stb")
        tdSql.error("select timezone() + 'abc' from tb")
        tdSql.error("select timezone() + 'abc' from ctb")
        tdSql.error("select timezone() + 'abc' from stb")
        tdSql.error("select timezone() + abc from tb")
        tdSql.error("select timezone() + abc from ctb")
        tdSql.error("select timezone() + abc from stb")
        tdSql.error("select timezone() + 1w from tb")
        tdSql.error("select timezone() + 1w from ctb")
        tdSql.error("select timezone() + 1w from stb")
        tdSql.error("select timezone() + 1d from tb")
        tdSql.error("select timezone() + 1d from ctb")
        tdSql.error("select timezone() + 1d from stb")
        tdSql.error("select timezone() + 1h from tb")
        tdSql.error("select timezone() + 1h from ctb")
        tdSql.error("select timezone() + 1h from stb")
        tdSql.error("select timezone() + 1m from tb")
        tdSql.error("select timezone() + 1m from ctb")
        tdSql.error("select timezone() + 1m from stb")
        tdSql.error("select timezone() + 1s from tb")
        tdSql.error("select timezone() + 1s from ctb")
        tdSql.error("select timezone() + 1s from stb")
        tdSql.error("select timezone() + 1a from tb")
        tdSql.error("select timezone() + 1a from ctb")
        tdSql.error("select timezone() + 1a from stb")
        tdSql.error("select timezone() + 1u from tb")
        tdSql.error("select timezone() + 1u from ctb")
        tdSql.error("select timezone() + 1u from stb")
        tdSql.error("select timezone() + 1b from tb")
        tdSql.error("select timezone() + 1b from ctb")
        tdSql.error("select timezone() + 1b from stb")

        tdSql.error("select timezone() + ts from tb")
        tdSql.error("select timezone() + ts from ctb")
        tdSql.error("select timezone() + ts from stb")
        tdSql.error("select timezone() + col_timestamp from tb")
        tdSql.error("select timezone() + col_timestamp from ctb")
        tdSql.error("select timezone() + col_timestamp from stb")
        tdSql.error("select timezone() + col_tinyint from tb")
        tdSql.error("select timezone() + col_tinyint from ctb")
        tdSql.error("select timezone() + col_tinyint from stb")
        tdSql.error("select timezone() + col_smallint from tb")
        tdSql.error("select timezone() + col_smallint from ctb")
        tdSql.error("select timezone() + col_smallint from stb")
        tdSql.error("select timezone() + col_int from tb")
        tdSql.error("select timezone() + col_int from ctb")
        tdSql.error("select timezone() + col_int from stb")
        tdSql.error("select timezone() + col_bigint from tb")
        tdSql.error("select timezone() + col_bigint from ctb")
        tdSql.error("select timezone() + col_bigint from stb")
        tdSql.error("select timezone() + col_bool from tb")
        tdSql.error("select timezone() + col_bool from ctb")
        tdSql.error("select timezone() + col_bool from stb")
        tdSql.error("select timezone() + col_float from tb")
        tdSql.error("select timezone() + col_float from ctb")
        tdSql.error("select timezone() + col_float from stb")
        tdSql.error("select timezone() + col_double from tb")
        tdSql.error("select timezone() + col_double from ctb")
        tdSql.error("select timezone() + col_double from stb")
        tdSql.error("select timezone() + col_binary from tb")
        tdSql.error("select timezone() + col_binary from ctb")
        tdSql.error("select timezone() + col_binary from stb")
        tdSql.error("select timezone() + col_nchar from tb")
        tdSql.error("select timezone() + col_nchar from ctb")
        tdSql.error("select timezone() + col_nchar from stb")

        tdSql.error("select timezone() + tag_timestamp from tb")
        tdSql.error("select timezone() + tag_timestamp from ctb")
        tdSql.error("select timezone() + tag_timestamp from stb")
        tdSql.error("select timezone() + tag_tinyint from tb")
        tdSql.error("select timezone() + tag_tinyint from ctb")
        tdSql.error("select timezone() + tag_tinyint from stb")
        tdSql.error("select timezone() + tag_smallint from tb")
        tdSql.error("select timezone() + tag_smallint from ctb")
        tdSql.error("select timezone() + tag_smallint from stb")
        tdSql.error("select timezone() + tag_int from tb")
        tdSql.error("select timezone() + tag_int from ctb")
        tdSql.error("select timezone() + tag_int from stb")
        tdSql.error("select timezone() + tag_bigint from tb")
        tdSql.error("select timezone() + tag_bigint from ctb")
        tdSql.error("select timezone() + tag_bigint from stb")
        tdSql.error("select timezone() + tag_bool from tb")
        tdSql.error("select timezone() + tag_bool from ctb")
        tdSql.error("select timezone() + tag_bool from stb")
        tdSql.error("select timezone() + tag_float from tb")
        tdSql.error("select timezone() + tag_float from ctb")
        tdSql.error("select timezone() + tag_float from stb")
        tdSql.error("select timezone() + tag_double from tb")
        tdSql.error("select timezone() + tag_double from ctb")
        tdSql.error("select timezone() + tag_double from stb")
        tdSql.error("select timezone() + tag_binary from tb")
        tdSql.error("select timezone() + tag_binary from ctb")
        tdSql.error("select timezone() + tag_binary from stb")
        tdSql.error("select timezone() + tag_nchar from tb")
        tdSql.error("select timezone() + tag_nchar from ctb")
        tdSql.error("select timezone() + tag_nchar from stb")

        tdSql.error("select timezone() + 0.5b from tb")
        tdSql.error("select timezone() + 0.5b from ctb")
        tdSql.error("select timezone() + 0.5b from stb")
        tdSql.error("select timezone() + 1.5u from tb")
        tdSql.error("select timezone() + 1.5u from ctb")
        tdSql.error("select timezone() + 1.5u from stb")
        tdSql.error("select timezone() + 2.5a from tb")
        tdSql.error("select timezone() + 2.5a from ctb")
        tdSql.error("select timezone() + 2.5a from stb")
        tdSql.error("select timezone() + 3.5s from tb")
        tdSql.error("select timezone() + 3.5s from ctb")
        tdSql.error("select timezone() + 3.5s from stb")
        tdSql.error("select timezone() + 4.5m from tb")
        tdSql.error("select timezone() + 4.5m from ctb")
        tdSql.error("select timezone() + 4.5m from stb")
        tdSql.error("select timezone() + 5.5h from tb")
        tdSql.error("select timezone() + 5.5h from ctb")
        tdSql.error("select timezone() + 5.5h from stb")
        tdSql.error("select timezone() + 6.5d from tb")
        tdSql.error("select timezone() + 6.5d from ctb")
        tdSql.error("select timezone() + 6.5d from stb")
        tdSql.error("select timezone() + 7.5w from tb")
        tdSql.error("select timezone() + 7.5w from ctb")
        tdSql.error("select timezone() + 7.5w from stb")

        tdSql.error("select timezone() - 0.5b from tb")
        tdSql.error("select timezone() - 0.5b from ctb")
        tdSql.error("select timezone() - 0.5b from stb")
        tdSql.error("select timezone() - 1.5u from tb")
        tdSql.error("select timezone() - 1.5u from ctb")
        tdSql.error("select timezone() - 1.5u from stb")
        tdSql.error("select timezone() - 2.5a from tb")
        tdSql.error("select timezone() - 2.5a from ctb")
        tdSql.error("select timezone() - 2.5a from stb")
        tdSql.error("select timezone() - 3.5s from tb")
        tdSql.error("select timezone() - 3.5s from ctb")
        tdSql.error("select timezone() - 3.5s from stb")
        tdSql.error("select timezone() - 4.5m from tb")
        tdSql.error("select timezone() - 4.5m from ctb")
        tdSql.error("select timezone() - 4.5m from stb")
        tdSql.error("select timezone() - 5.5h from tb")
        tdSql.error("select timezone() - 5.5h from ctb")
        tdSql.error("select timezone() - 5.5h from stb")
        tdSql.error("select timezone() - 6.5d from tb")
        tdSql.error("select timezone() - 6.5d from ctb")
        tdSql.error("select timezone() - 6.5d from stb")
        tdSql.error("select timezone() - 7.5w from tb")
        tdSql.error("select timezone() - 7.5w from ctb")
        tdSql.error("select timezone() - 7.5w from stb")

        tdSql.error("select timezone() * 1d from tb")
        tdSql.error("select timezone() * 1d from ctb")
        tdSql.error("select timezone() * 1d from stb")
        tdSql.error("select timezone() / 5m from tb")
        tdSql.error("select timezone() / 5m from ctb")
        tdSql.error("select timezone() / 5m from stb")
        tdSql.error("select timezone() % 10h from tb")
        tdSql.error("select timezone() % 10h from ctb")
        tdSql.error("select timezone() % 10h from stb")
        tdSql.error("select timezone() + 1a * 60b from tb")
        tdSql.error("select timezone() + 1a * 60b from ctb")
        tdSql.error("select timezone() + 1a * 60b from stb")
        tdSql.error("select timezone() + 1s * 60 from tb")
        tdSql.error("select timezone() + 1s * 60 from ctb")
        tdSql.error("select timezone() + 1s * 60 from stb")

        #timezone(), func()
        tdSql.error("select timezone(),count(*) from tb")
        tdSql.error("select timezone(),count(*) from ctb")
        tdSql.error("select timezone(),count(*) from stb")
        tdSql.error("select timezone(),avg(col_timestamp) from tb")
        tdSql.error("select timezone(),avg(col_timestamp) from ctb")
        tdSql.error("select timezone(),avg(col_timestamp) from stb")
        tdSql.error("select timezone(),sum(col_int) from tb")
        tdSql.error("select timezone(),sum(col_int) from ctb")
        tdSql.error("select timezone(),sum(col_int) from stb")

        tdSql.error("select timezone(),max(col_timestamp) from tb")
        tdSql.error("select timezone(),max(col_timestamp) from ctb")
        tdSql.error("select timezone(),max(col_timestamp) from stb")
        tdSql.error("select timezone(),first(col_timestamp) from tb")
        tdSql.error("select timezone(),first(col_timestamp) from ctb")
        tdSql.error("select timezone(),first(col_timestamp) from stb")
        tdSql.error("select timezone(),top(col_timestamp, 1) from tb")
        tdSql.error("select timezone(),top(col_timestamp, 1) from ctb")
        tdSql.error("select timezone(),top(col_timestamp, 1) from stb")

        #session
        tdSql.error("select timezone() from tb session(ts, 1d)")
        tdSql.error("select timezone() from ctb session(ts, 1h)")
        tdSql.error("select timezone() from stb session(ts, 1m)")

        #state_window
        tdSql.error('select timezone() from tb state_window(col_timestamp);')
        tdSql.error('select timezone() from tb state_window(col_tinyint);')
        tdSql.error('select timezone() from tb state_window(col_smallint);')
        tdSql.error('select timezone() from tb state_window(col_int);')
        tdSql.error('select timezone() from tb state_window(col_bigint);')
        tdSql.error('select timezone() from tb state_window(col_bool);')
        tdSql.error('select timezone() from tb state_window(col_float);')
        tdSql.error('select timezone() from tb state_window(col_double);')
        tdSql.error('select timezone() from tb state_window(col_binary);')
        tdSql.error('select timezone() from tb state_window(col_nchar);')

        #interval/sliding
        tdSql.error('select timezone() from tb interval(1y)')
        tdSql.error('select timezone() from tb interval(1n)')
        tdSql.error('select timezone() from tb interval(1w)')
        tdSql.error('select timezone() from tb interval(1d)')
        tdSql.error('select timezone() from tb interval(1h)')
        tdSql.error('select timezone() from tb interval(1s)')
        tdSql.error('select timezone() from tb interval(1y) sliding(1y)')
        tdSql.error('select timezone() from tb interval(1n) sliding(1n)')
        tdSql.error('select timezone() from tb interval(1w) sliding(1w)')
        tdSql.error('select timezone() from tb interval(1d) sliding(1d)')
        tdSql.error('select timezone() from tb interval(1h) sliding(1h)')
        tdSql.error('select timezone() from tb interval(1s) sliding(1s)')

        #group by
        tdSql.error('select timezone() from stb group by ts;')
        tdSql.error('select timezone() from stb group by col_tinyint;')
        tdSql.error('select timezone() from stb group by col_smallint;')
        tdSql.error('select timezone() from stb group by col_int;')
        tdSql.error('select timezone() from stb group by col_bigint;')
        tdSql.error('select timezone() from stb group by col_bool;')
        tdSql.error('select timezone() from stb group by col_float;')
        tdSql.error('select timezone() from stb group by col_double;')
        tdSql.error('select timezone() from stb group by col_binary;')
        tdSql.error('select timezone() from stb group by col_nchar;')

        tdSql.error('select timezone() from stb group by tag_tinyint;')
        tdSql.error('select timezone() from stb group by tag_smallint;')
        tdSql.error('select timezone() from stb group by tag_int;')
        tdSql.error('select timezone() from stb group by tag_bigint;')
        tdSql.error('select timezone() from stb group by tag_bool;')
        tdSql.error('select timezone() from stb group by tag_float;')
        tdSql.error('select timezone() from stb group by tag_double;')
        tdSql.error('select timezone() from stb group by tag_binary;')
        tdSql.error('select timezone() from stb group by tag_nchar;')

        tdSql.error('select timezone() from stb group by tbname;')

        tdSql.error('select timezone() from stb group by tag_tinyint,col_tinyint;')
        tdSql.error('select timezone() from stb group by tag_smallint,col_smallint;')
        tdSql.error('select timezone() from stb group by tag_int,col_int;')
        tdSql.error('select timezone() from stb group by tag_bigint,col_bigint;')
        tdSql.error('select timezone() from stb group by tag_bool,col_bool;')
        tdSql.error('select timezone() from stb group by tag_float,col_float;')
        tdSql.error('select timezone() from stb group by tag_double,col_double;')
        tdSql.error('select timezone() from stb group by tag_binary,col_binary;')
        tdSql.error('select timezone() from stb group by tag_nchar,col_nchar;')

        #order by
        tdSql.error('select timezone() from stb order by col_tinyint;')
        tdSql.error('select timezone() from stb order by col_tinyint desc;')
        tdSql.error('select timezone() from stb order by col_smallint;')
        tdSql.error('select timezone() from stb order by col_smallint desc;')
        tdSql.error('select timezone() from stb order by col_int;')
        tdSql.error('select timezone() from stb order by col_int desc;')
        tdSql.error('select timezone() from stb order by col_bigint;')
        tdSql.error('select timezone() from stb order by col_bigint desc;')
        tdSql.error('select timezone() from stb order by col_bool;')
        tdSql.error('select timezone() from stb order by col_bool desc;')
        tdSql.error('select timezone() from stb order by col_float;')
        tdSql.error('select timezone() from stb order by col_float desc;')
        tdSql.error('select timezone() from stb order by col_double;')
        tdSql.error('select timezone() from stb order by col_double desc;')
        tdSql.error('select timezone() from stb order by col_double;')
        tdSql.error('select timezone() from stb order by col_double desc;')

        tdSql.error('select timezone() from stb order by tag_timestamp;')
        tdSql.error('select timezone() from stb order by tag_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_tinyint;')
        tdSql.error('select timezone() from stb order by tag_tinyint desc;')
        tdSql.error('select timezone() from stb order by tag_smallint;')
        tdSql.error('select timezone() from stb order by tag_smallint desc;')
        tdSql.error('select timezone() from stb order by tag_int;')
        tdSql.error('select timezone() from stb order by tag_int desc;')
        tdSql.error('select timezone() from stb order by tag_bigint;')
        tdSql.error('select timezone() from stb order by tag_bigint desc;')
        tdSql.error('select timezone() from stb order by tag_bool;')
        tdSql.error('select timezone() from stb order by tag_bool desc;')
        tdSql.error('select timezone() from stb order by tag_float;')
        tdSql.error('select timezone() from stb order by tag_float desc;')
        tdSql.error('select timezone() from stb order by tag_double;')
        tdSql.error('select timezone() from stb order by tag_double desc;')
        tdSql.error('select timezone() from stb order by tag_double;')
        tdSql.error('select timezone() from stb order by tag_double desc;')

        tdSql.error('select timezone() from stb order by tbname;')
        tdSql.error('select timezone() from stb order by tbname desc;')

        tdSql.error('select timezone() from stb order by tag_timestamp,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_timestamp,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_tinyint,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_tinyint,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_smallint,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_smallint,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_int,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_int,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_bigint,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_bigint,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_bool,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_bool,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_float,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_float,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_double,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_double,col_timestamp desc;')
        tdSql.error('select timezone() from stb order by tag_double,col_timestamp;')
        tdSql.error('select timezone() from stb order by tag_double,col_timestamp desc;')

        tdSql.execute('drop database db_m')
        tdSql.execute('drop database db_u')
        tdSql.execute('drop database db_n')

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
