/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 461
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy32;
  SToken yy77;
  int32_t yy248;
  int8_t yy287;
  ENullOrder yy385;
  EJoinType yy560;
  SNode* yy600;
  SNodeList* yy601;
  SAlterOption yy661;
  EOperatorType yy666;
  int64_t yy717;
  EFillMode yy798;
  bool yy841;
  SDataType yy888;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             716
#define YYNRULE              545
#define YYNTOKEN             324
#define YY_MAX_SHIFT         715
#define YY_MIN_SHIFTREDUCE   1063
#define YY_MAX_SHIFTREDUCE   1607
#define YY_ERROR_ACTION      1608
#define YY_ACCEPT_ACTION     1609
#define YY_NO_ACTION         1610
#define YY_MIN_REDUCE        1611
#define YY_MAX_REDUCE        2155
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2733)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   463,  370,  464, 1647, 1810, 1812,  404, 1969, 1755,   33,
 /*    10 */   277,  170,   43,   41, 1536, 1634, 1753,  571,  168, 1951,
 /*    20 */   365, 2126, 1386, 1955, 1804,   42,   40,   39,   38,   37,
 /*    30 */  1969,  605, 1609, 1466, 1951, 1384,  570,  174, 1987,  335,
 /*    40 */  1864, 2127,  572, 1811, 1812,   52,  622,  591,  550, 1947,
 /*    50 */  1953, 1937, 2126,  621,   11,   10, 1411,  589, 1461, 1937,
 /*    60 */   615, 1987, 1764,   16, 1947, 1953,  347, 2132,  174,  586,
 /*    70 */  1392, 1412, 2127,  572, 1937,  615,  621,  462, 1968,  604,
 /*    80 */   467, 1653, 2003,   43,   41,  161, 1970,  625, 1972, 1973,
 /*    90 */   620,  365,  615, 1386,  479,   12, 1873,  380,  604,  550,
 /*   100 */   605, 1968,  159, 2126, 1466, 2003, 1384, 1718,  101, 1970,
 /*   110 */   625, 1972, 1973,  620,  124,  615,  260,  712, 2132,  174,
 /*   120 */   171,  502, 2056, 2127,  572,  229,  359, 2052, 1794, 1461,
 /*   130 */   604, 1764, 1468, 1469,   16,   97,  605,  573, 2147,  550,
 /*   140 */   176, 1392,  583, 2126,  472,   94,  464, 1647, 2082, 1509,
 /*   150 */   124,  157, 1182,   59,   46,   86,  297,  507, 2132,  174,
 /*   160 */   592, 1442, 1451, 2127,  572,  471,   12, 1764,  467, 1653,
 /*   170 */   295,   67,  356,  132,   66, 1877, 2071,  517,  516,  515,
 /*   180 */  1387, 1680, 1385, 1265, 1266,  129,  511, 1184,  712, 1956,
 /*   190 */   510,  357,  194,  459,  457,  509,  514, 1318, 1319,  156,
 /*   200 */  1951,  508, 2068, 1468, 1469,   46, 1390, 1391, 1766, 1441,
 /*   210 */  1444, 1445, 1446, 1447, 1448, 1449, 1450,  617,  613, 1459,
 /*   220 */  1460, 1462, 1463, 1464, 1465, 1467, 1470,    2,   59,  605,
 /*   230 */  1947, 1953, 1442, 1451,  257, 2064,  582,  590,  125,  581,
 /*   240 */  1413,  615, 2126,  179,  469, 1411,  517,  516,  515,  168,
 /*   250 */   465, 1387,  227, 1385,  129,  511,  226,  570,  174,  510,
 /*   260 */  1764,   50, 2127,  572,  509,  514,  549,  100,   36,   35,
 /*   270 */   508, 1865,   42,   40,   39,   38,   37, 1390, 1391,  378,
 /*   280 */  1441, 1444, 1445, 1446, 1447, 1448, 1449, 1450,  617,  613,
 /*   290 */  1459, 1460, 1462, 1463, 1464, 1465, 1467, 1470,    2,  522,
 /*   300 */     9,   43,   41,  177,  177,   75,   74,  407,   92,  365,
 /*   310 */   181, 1386,   83,  323,  532, 1987,  345,   98,  533, 1969,
 /*   320 */    59,  550, 1466,  565, 1384, 2126, 1817,  145,  225,  319,
 /*   330 */  1757,  133,  395,  358,  393,  389,  385,  382,  379, 1756,
 /*   340 */  2132,  174, 1815,  525, 1955, 2127,  572, 1461,  519,  368,
 /*   350 */  1987,   63,   16,  224,  371, 1951, 1574,  156,  622, 1392,
 /*   360 */  2131,  481,  156, 1937,  564,  621, 1766,   39,   38,   37,
 /*   370 */   591, 1766,   43,   41, 1471,  566,   59, 1413,  177,   51,
 /*   380 */   365, 1969, 1386,  259,   12, 1947, 1953,  348,   59,   65,
 /*   390 */  1968,   81,   64, 1466, 2003, 1384,  615,  101, 1970,  625,
 /*   400 */  1972, 1973,  620,    9,  615,  128,  712,  135, 1497,  142,
 /*   410 */  2027, 2056, 1987, 1742, 1759,  359, 2052,  600, 1461, 1873,
 /*   420 */   622, 1468, 1469,  268,  269, 1937, 1096,  621,  267, 1740,
 /*   430 */  1392, 1222,  647,  646,  645, 1226,  644, 1228, 1229,  643,
 /*   440 */  1231,  640,   59, 1237,  637, 1239, 1240,  634,  631,  650,
 /*   450 */  1442, 1451, 1968, 1597, 1412,   44, 2003, 1611,  186,  102,
 /*   460 */  1970,  625, 1972, 1973,  620, 1098,  615, 1101, 1102, 1387,
 /*   470 */   177, 1385,  403, 2056,  402,  481, 1411,  712, 2053,  410,
 /*   480 */    30,  123,  122,  121,  120,  119,  118,  117,  116,  115,
 /*   490 */  1502,  659, 1468, 1469,   78, 1390, 1391,   77, 1441, 1444,
 /*   500 */  1445, 1446, 1447, 1448, 1449, 1450,  617,  613, 1459, 1460,
 /*   510 */  1462, 1463, 1464, 1465, 1467, 1470,    2,  513,  512,  321,
 /*   520 */   259, 1442, 1451, 1612,  114,  605,  177,  113,  112,  111,
 /*   530 */   110,  109,  108,  107,  106,  105,   81,  659,  177,  408,
 /*   540 */  1387,  158, 1385, 1623,  114, 1410, 1633,  113,  112,  111,
 /*   550 */   110,  109,  108,  107,  106,  105, 1764,   36,   35, 1760,
 /*   560 */  1969,   42,   40,   39,   38,   37, 1390, 1391,   47, 1441,
 /*   570 */  1444, 1445, 1446, 1447, 1448, 1449, 1450,  617,  613, 1459,
 /*   580 */  1460, 1462, 1463, 1464, 1465, 1467, 1470,    2,   43,   41,
 /*   590 */  1937, 1987,  177,   25,  411,  446,  365,  592, 1386,  586,
 /*   600 */   340, 1115, 1392, 1114, 1937,  561,  621,  412,    9, 1466,
 /*   610 */     7, 1384, 1878, 1817, 1817,  607,  211, 2028,   36,   35,
 /*   620 */   369,  332,   42,   40,   39,   38,   37,    6, 1632, 1815,
 /*   630 */  1815, 1968, 1116, 1955, 1461, 2003,  531,  583,  101, 1970,
 /*   640 */   625, 1972, 1973,  620, 1951,  615, 1392, 1563,  605,  529,
 /*   650 */   171,  527, 2056,  190,  189,  583,  359, 2052, 2071,   43,
 /*   660 */    41,  341,  409,  339,  338,  671,  504,  365,  132, 1386,
 /*   670 */   506,   44, 1937,  328, 1947, 1953,  360, 1749, 2083, 1764,
 /*   680 */  1466,  399, 1384, 1414, 2067,  615,  132,  571, 1540,  567,
 /*   690 */   562, 2126,  505,  712, 1411,  558,  557, 1561, 1562, 1564,
 /*   700 */  1565, 1566,  545,  401,  397, 1461,  570,  174, 1468, 1469,
 /*   710 */  1631, 2127,  572,  228, 1495, 2131, 1630, 1392,  177, 2126,
 /*   720 */    36,   35,  605, 1751,   42,   40,   39,   38,   37,  173,
 /*   730 */  2064, 2065, 1414,  130, 2069, 2130,  418, 1442, 1451, 2127,
 /*   740 */  2129, 2131,   12, 2071, 1476, 2126,  585,  172, 2064, 2065,
 /*   750 */  1411,  130, 2069, 1764, 1937, 1747, 1387,  609, 1385, 2028,
 /*   760 */  1937, 2130,  506, 1629,  712, 2127, 2128,   36,   35, 2066,
 /*   770 */  1496,   42,   40,   39,   38,   37, 1361, 1362,  134, 1468,
 /*   780 */  1469, 2027, 1390, 1391,  505, 1441, 1444, 1445, 1446, 1447,
 /*   790 */  1448, 1449, 1450,  617,  613, 1459, 1460, 1462, 1463, 1464,
 /*   800 */  1465, 1467, 1470,    2,  320, 2130, 1409, 1937, 1442, 1451,
 /*   810 */  1115,  232, 1114,  440,  683,  681,  453,   36,   35,  452,
 /*   820 */  1860,   42,   40,   39,   38,   37,  183, 1387, 1677, 1385,
 /*   830 */   651,  182, 1529, 1808,  424, 1443,  454, 1628, 1533,  426,
 /*   840 */  1627, 1116,   32,  363, 1490, 1491, 1492, 1493, 1494, 1498,
 /*   850 */  1499, 1500, 1501, 1390, 1391, 1552, 1441, 1444, 1445, 1446,
 /*   860 */  1447, 1448, 1449, 1450,  617,  613, 1459, 1460, 1462, 1463,
 /*   870 */  1464, 1465, 1467, 1470,    2,  237,   29, 1626,  616, 1625,
 /*   880 */   336, 1937,   36,   35, 1937,  649,   42,   40,   39,   38,
 /*   890 */    37, 1443,  414,  689,  688,  687,  686,  375, 1622,  685,
 /*   900 */   684,  136,  679,  678,  677,  676,  675,  674,  673,  149,
 /*   910 */   669,  668,  667,  374,  373,  664,  663,  662,  661,  660,
 /*   920 */  1621, 1937,  450, 1937, 1969,  445,  444,  443,  442,  439,
 /*   930 */   438,  437,  436,  435,  431,  430,  429,  428,  337,  421,
 /*   940 */   420,  419, 1937,  416,  415,  334, 1620, 1969, 1619, 1860,
 /*   950 */  1860,  291,  362,  361, 1794, 1987, 1618,  605,  605, 1414,
 /*   960 */   184,  188, 1400,  622, 1937,  605,  605, 1617, 1937, 1741,
 /*   970 */   621,  432,  433, 1466,  156, 1393, 1411,  583, 1987,  372,
 /*   980 */   480, 1604,  672, 1767, 1734, 1817,  622, 1624, 1764, 1764,
 /*   990 */  1937, 1937, 1937,  621,  377, 1968, 1764, 1764, 1461, 2003,
 /*  1000 */  1937, 1816,  101, 1970,  625, 1972, 1973,  620,  132,  615,
 /*  1010 */  1392, 1937, 1101, 1102, 2146, 1616, 2056, 1719, 1968, 1615,
 /*  1020 */   359, 2052, 2003, 1847, 1614,  101, 1970,  625, 1972, 1973,
 /*  1030 */   620, 2090,  615, 1969,  575,   31,  550, 2146, 2096, 2056,
 /*  1040 */  2126,   36,   35,  359, 2052,   42,   40,   39,   38,   37,
 /*  1050 */   655, 2076, 1529, 1808, 2120, 2132,  174,  611, 1924, 1937,
 /*  1060 */  2127,  572,  656, 1937, 1987, 1808,  574,  212, 1937,  175,
 /*  1070 */  2064, 2065,  622,  130, 2069,  210,  657, 1937, 1603,  621,
 /*  1080 */  1532, 1667,  163, 1660,   48,  138,    3,  126,  498,  494,
 /*  1090 */   490,  486,  209,   68,  254,  147,  146,  654,  653,  652,
 /*  1100 */   144,  578,  236,  518, 1968,  520,  387,  535, 2003,  534,
 /*  1110 */  1969,  101, 1970,  625, 1972, 1973,  620, 1443,  615,  605,
 /*  1120 */  1401,  217, 1396, 2146,  215, 2056, 1606, 1607,   82,  359,
 /*  1130 */  2052,  207, 1395, 1761, 1969,  665,  219,  235, 1386,  218,
 /*  1140 */  2075, 1987,   61,   76,   61,  241, 1404, 1406,  657,  622,
 /*  1150 */  1764, 1384,  605, 1658, 1937, 1394,  621, 1163,  613, 1459,
 /*  1160 */  1460, 1462, 1463, 1464, 1465, 1987,  140,  147,  146,  654,
 /*  1170 */   653,  652,  144,  622,  427,  523,   84,  612, 1937, 1969,
 /*  1180 */   621, 1968,  559, 1764,  221, 2003, 1392,  220,  101, 1970,
 /*  1190 */   625, 1972, 1973,  620, 1560,  615, 1559,  243,  206,  200,
 /*  1200 */  2031,  205, 2056,   45,  477, 1968,  359, 2052,  248, 2003,
 /*  1210 */  1987, 1739,  101, 1970,  625, 1972, 1973,  620,  622,  615,
 /*  1220 */   198,   11,   10, 1937, 2029,  621, 2056, 1988,  376,  265,
 /*  1230 */   359, 2052,  605,  712, 1969,   36,   35,  605, 1869,   42,
 /*  1240 */    40,   39,   38,   37, 1648,  141,  546,  143,  145,   61,
 /*  1250 */  1968,  587,  605,  605, 2003, 1331,  576,  101, 1970,  625,
 /*  1260 */  1972, 1973,  620, 1764,  615, 1987,  272,  602, 1764,  608,
 /*  1270 */  1805, 2056,  605,  622,  223,  359, 2052,  222, 1937, 1398,
 /*  1280 */   621,  270,  538, 1764, 1764, 2086,  603,   36,   35,  584,
 /*  1290 */  1969,   42,   40,   39,   38,   37, 1387,  597, 1385,  274,
 /*  1300 */  1215, 1503, 1397, 1764,   45, 1968, 1958,   45,  629, 2003,
 /*  1310 */   143,  145,  102, 1970,  625, 1972, 1973,  620,  657,  615,
 /*  1320 */  1487, 1987, 1390, 1391,  550,  579, 2056, 1654, 2126,  622,
 /*  1330 */  2055, 2052,  127,  605, 1937, 1969,  621,  147,  146,  654,
 /*  1340 */   653,  652,  144, 2132,  174,  666,  143,  278, 2127,  572,
 /*  1350 */  1144,  256,  253,    4, 1960,    1, 1452,  381, 1969,  290,
 /*  1360 */  1243, 1968, 1247, 1254, 1764, 2003, 1987, 1161,  102, 1970,
 /*  1370 */   625, 1972, 1973,  620,  622,  615,  707,  386,  333, 1937,
 /*  1380 */  1348,  621, 2056,  285, 1252, 1145,  610, 2052,  187, 1987,
 /*  1390 */   155,  413, 1414, 1870,  417,  448,  422,  619,  148, 1409,
 /*  1400 */   434, 1862, 1937,  441,  621,  447,  623,  455,  449,  191,
 /*  1410 */  2003,  456,  458,  102, 1970,  625, 1972, 1973,  620,  460,
 /*  1420 */   615, 1415,  461,  470, 1417,  473,  474, 2056,  197, 1968,
 /*  1430 */   199,  327, 2052, 2003, 1416,  475,  313, 1970,  625, 1972,
 /*  1440 */  1973,  620,  618,  615,  606, 2021, 1969, 1418,  202,  476,
 /*  1450 */   204,  478,   79,   80,  208, 1118,  482,  501,  539, 1915,
 /*  1460 */   503,  499, 1969,  500,  537,  322, 1754,  104,  214,  540,
 /*  1470 */   286, 2087,  541,  230, 1912, 1750,  216, 1987,  544,  233,
 /*  1480 */   547,  560,  150,  595,  151,  622, 2102, 1752, 1748,  152,
 /*  1490 */  1937,  153,  621, 1987,    5, 2101, 2078,  569, 1911,  247,
 /*  1500 */   555,  622,  553,  164,  249,  552, 1937,  251,  621,  250,
 /*  1510 */   554,  350,  556,  349,  563, 2149,  580, 1968, 1969, 2097,
 /*  1520 */   577, 2003, 1529,  239,  160, 1970,  625, 1972, 1973,  620,
 /*  1530 */   242,  615,  131, 1968, 2125,  255, 1413, 2003,  261, 1419,
 /*  1540 */   160, 1970,  625, 1972, 1973,  620, 1969,  615,  252, 1987,
 /*  1550 */  2072,  588, 1874,  353,  593,  287,  288,  622,  594, 1883,
 /*  1560 */  1882, 1881, 1937,  355,  621,  551, 2093,  598,   89,  599,
 /*  1570 */    58,   91,  289, 1765, 2037,   93,  627, 1987, 1735, 1809,
 /*  1580 */   292,  281, 2094,  709,  708,  622,   49,  711,  301, 1968,
 /*  1590 */  1937,  316,  621, 2003,  294,  315,  307, 1970,  625, 1972,
 /*  1600 */  1973,  620,  324,  615,  305,  296, 1931, 1930, 1969,  325,
 /*  1610 */    72, 1929, 1928,   73, 1925,  383,  384, 1968, 1378, 1379,
 /*  1620 */   715, 2003,  180, 1923,  161, 1970,  625, 1972, 1973,  620,
 /*  1630 */   388,  615,  390,  391,  284,  392, 1922,  394, 1921, 1987,
 /*  1640 */   568, 1920,  398,  396,  354, 1919, 1351,  622,  400,  167,
 /*  1650 */  1350, 1894, 1937, 1893,  621,  705,  701,  697,  693,  282,
 /*  1660 */   405, 1892,  406, 1969, 1309, 1855, 1854, 1852,  137, 1851,
 /*  1670 */  1850, 1853, 1849, 1848, 1846, 1845, 1844, 2148, 1891, 1968,
 /*  1680 */   185,  423, 1843, 2003,  425, 1842,  314, 1970,  625, 1972,
 /*  1690 */  1973,  620, 1841,  615, 1987,   99, 1840, 1839,  275, 1838,
 /*  1700 */  1837, 1836,  619, 1835, 1834, 1833, 1832, 1937, 1831,  621,
 /*  1710 */  1830, 1829, 1828, 1827, 1826, 1825, 1824, 1823, 1822,  139,
 /*  1720 */  1311, 1821, 1820,  451, 1819, 1969, 1190, 1682, 1681, 1679,
 /*  1730 */  1643,  601, 1818,   70, 1968,  195, 1957,  192, 2003,  193,
 /*  1740 */  1642,  313, 1970,  625, 1972, 1973,  620, 1104,  615,  466,
 /*  1750 */  2022,  169, 1103, 1907, 1901, 1969, 1987, 1890, 1889, 1872,
 /*  1760 */   196,  364,   71,  203,  622, 1743,  468, 1678,  262, 1937,
 /*  1770 */   201,  621, 1676, 1137,  483,  485, 1674,  487, 1672,  491,
 /*  1780 */   489, 1670,  484,  488, 1657, 1355, 1987,  231,  493,  497,
 /*  1790 */   495,  366, 1656,  492,  622,  496, 1968, 1639, 1745, 1937,
 /*  1800 */  2003,  621, 1258,  314, 1970,  625, 1972, 1973,  620, 1259,
 /*  1810 */   615, 1744, 1181, 1969, 1180,  680, 1173, 1179, 1178,  682,
 /*  1820 */  1175, 1174, 1172, 1668,  342, 1661, 1968,  213,  343, 1969,
 /*  1830 */  2003, 1659,  344,  314, 1970,  625, 1972, 1973,  620,  521,
 /*  1840 */   615,   60,  524, 1638, 1987, 1637, 1636,  526,  528,  530,
 /*  1850 */  1366, 1368,  622,  103, 1365, 1906, 1370, 1937,   24,  621,
 /*  1860 */  1987, 1357, 1900,  154,  542, 1888, 1886, 2131,  622, 1576,
 /*  1870 */    14,   18,   17, 1937, 1969,  621,   56,   62,   57,  245,
 /*  1880 */    15,   28,   19,   26,  536,  238,  246,  240, 2003, 1558,
 /*  1890 */  1969,  309, 1970,  625, 1972, 1973,  620, 1551,  615,  162,
 /*  1900 */  1968, 1958, 1591,  244, 2003, 1987,   53,  298, 1970,  625,
 /*  1910 */  1972, 1973,  620,  622,  615,  543,  234,  548, 1937,   27,
 /*  1920 */   621, 1987, 1590,  351,  346, 1596,  258, 1595, 1594,  622,
 /*  1930 */   352,   85,  165,   54, 1937, 1887,  621, 1597,   55, 1885,
 /*  1940 */  1526, 1884, 1871, 1525,  263, 1968,   20,   88,  264, 2003,
 /*  1950 */   276,  266,  299, 1970,  625, 1972, 1973,  620,  271,  615,
 /*  1960 */    21, 1968,  596,  273, 1556, 2003,   87, 1969,  300, 1970,
 /*  1970 */   625, 1972, 1973,  620,   94,  615,   90,   10, 1402, 2006,
 /*  1980 */   166,  178, 1456, 1434,  614,  628, 1454,  367,  626,  632,
 /*  1990 */  1478, 1969, 1453,   34,    8,   13, 1477,   22, 1987,  635,
 /*  2000 */  1426, 1488,   23, 1221,  638, 1244,  622,  630,  624, 1241,
 /*  2010 */   633, 1937,  636,  621, 1238, 1232,  639,  641, 1230,  642,
 /*  2020 */  1236,  648, 1987,   95, 1235, 1234,   96,  279, 1253, 1233,
 /*  2030 */   622,   69, 1249, 1169, 1135, 1937,  658,  621, 1968, 1168,
 /*  2040 */  1167, 1166, 2003, 1165, 1164,  306, 1970,  625, 1972, 1973,
 /*  2050 */   620, 1162,  615, 1969, 1160, 1159, 1158, 1188,  670,  280,
 /*  2060 */  1156, 1155, 1968, 1154, 1153, 1152, 2003, 1151, 1150,  310,
 /*  2070 */  1970,  625, 1972, 1973,  620, 1183,  615, 1185, 1147, 1146,
 /*  2080 */  1143, 1142, 1141, 1969, 1987, 1140, 1675,  690,  692,  691,
 /*  2090 */  1673,  694,  622, 1671,  696,  695,  698, 1937,  700,  621,
 /*  2100 */  1669,  699,  702,  704, 1655,  703,  706, 1093, 1635,  283,
 /*  2110 */   710, 1610,  714, 1388, 1987, 1610,  293,  713, 1610, 1610,
 /*  2120 */  1610, 1610,  622, 1610, 1968, 1610, 1610, 1937, 2003,  621,
 /*  2130 */  1610,  302, 1970,  625, 1972, 1973,  620, 1610,  615, 1610,
 /*  2140 */  1610, 1969, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2150 */  1610, 1610, 1610, 1610, 1968, 1610, 1610, 1969, 2003, 1610,
 /*  2160 */  1610,  311, 1970,  625, 1972, 1973,  620, 1610,  615, 1610,
 /*  2170 */  1610, 1610, 1987, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2180 */   622, 1610, 1610, 1610, 1610, 1937, 1610,  621, 1987, 1610,
 /*  2190 */  1610, 1610, 1610, 1610, 1610, 1610,  622, 1610, 1610, 1610,
 /*  2200 */  1610, 1937, 1969,  621, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2210 */  1610, 1610, 1968, 1610, 1610, 1610, 2003, 1610, 1969,  303,
 /*  2220 */  1970,  625, 1972, 1973,  620, 1610,  615, 1610, 1968, 1610,
 /*  2230 */  1610, 1610, 2003, 1987, 1610,  312, 1970,  625, 1972, 1973,
 /*  2240 */   620,  622,  615, 1610, 1610, 1610, 1937, 1610,  621, 1987,
 /*  2250 */  1610, 1610, 1610, 1610, 1610, 1610, 1610,  622, 1610, 1610,
 /*  2260 */  1610, 1610, 1937, 1610,  621, 1610, 1610, 1610, 1610, 1610,
 /*  2270 */  1610, 1610, 1610, 1968, 1610, 1610, 1610, 2003, 1610, 1610,
 /*  2280 */   304, 1970,  625, 1972, 1973,  620, 1610,  615, 1610, 1968,
 /*  2290 */  1610, 1610, 1610, 2003, 1610, 1969,  317, 1970,  625, 1972,
 /*  2300 */  1973,  620, 1610,  615, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2310 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1969,
 /*  2320 */  1610, 1610, 1610, 1610, 1610, 1610, 1987, 1610, 1610, 1610,
 /*  2330 */  1610, 1610, 1610, 1610,  622, 1610, 1610, 1610, 1610, 1937,
 /*  2340 */  1610,  621, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2350 */  1987, 1610, 1610, 1610, 1610, 1610, 1610, 1610,  622, 1610,
 /*  2360 */  1610, 1610, 1610, 1937, 1610,  621, 1968, 1610, 1610, 1610,
 /*  2370 */  2003, 1610, 1610,  318, 1970,  625, 1972, 1973,  620, 1610,
 /*  2380 */   615, 1969, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2390 */  1968, 1610, 1610, 1610, 2003, 1610, 1610, 1981, 1970,  625,
 /*  2400 */  1972, 1973,  620, 1610,  615, 1610, 1610, 1610, 1610, 1610,
 /*  2410 */  1610, 1969, 1987, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2420 */   622, 1610, 1610, 1610, 1610, 1937, 1610,  621, 1610, 1610,
 /*  2430 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2440 */  1610, 1610, 1987, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2450 */   622, 1610, 1968, 1610, 1610, 1937, 2003,  621, 1610, 1980,
 /*  2460 */  1970,  625, 1972, 1973,  620, 1610,  615, 1610, 1610, 1969,
 /*  2470 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2480 */  1610, 1610, 1968, 1610, 1610, 1969, 2003, 1610, 1610, 1979,
 /*  2490 */  1970,  625, 1972, 1973,  620, 1610,  615, 1610, 1610, 1610,
 /*  2500 */  1987, 1610, 1610, 1610, 1610, 1610, 1610, 1610,  622, 1610,
 /*  2510 */  1610, 1610, 1610, 1937, 1610,  621, 1987, 1610, 1610, 1610,
 /*  2520 */  1610, 1610, 1610, 1610,  622, 1610, 1610, 1610, 1610, 1937,
 /*  2530 */  1969,  621, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2540 */  1968, 1610, 1610, 1610, 2003, 1610, 1969,  329, 1970,  625,
 /*  2550 */  1972, 1973,  620, 1610,  615, 1610, 1968, 1610, 1610, 1610,
 /*  2560 */  2003, 1987, 1610,  330, 1970,  625, 1972, 1973,  620,  622,
 /*  2570 */   615, 1610, 1610, 1610, 1937, 1610,  621, 1987, 1610, 1610,
 /*  2580 */  1610, 1610, 1610, 1610, 1610,  622, 1610, 1610, 1610, 1610,
 /*  2590 */  1937, 1610,  621, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2600 */  1610, 1968, 1610, 1610, 1610, 2003, 1610, 1610,  326, 1970,
 /*  2610 */   625, 1972, 1973,  620, 1610,  615, 1610, 1968, 1610, 1610,
 /*  2620 */  1610, 2003, 1610, 1969,  331, 1970,  625, 1972, 1973,  620,
 /*  2630 */  1610,  615, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610,
 /*  2640 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1969, 1610, 1610,
 /*  2650 */  1610, 1610, 1610, 1610, 1987, 1610, 1610, 1610, 1610, 1610,
 /*  2660 */  1610, 1610,  622, 1610, 1610, 1610, 1610, 1937, 1610,  621,
 /*  2670 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1987, 1610,
 /*  2680 */  1610, 1610, 1610, 1610, 1610, 1610,  622, 1610, 1610, 1610,
 /*  2690 */  1610, 1937, 1610,  621,  623, 1610, 1610, 1610, 2003, 1610,
 /*  2700 */  1610,  309, 1970,  625, 1972, 1973,  620, 1610,  615, 1610,
 /*  2710 */  1610, 1610, 1610, 1610, 1610, 1610, 1610, 1610, 1968, 1610,
 /*  2720 */  1610, 1610, 2003, 1610, 1610,  308, 1970,  625, 1972, 1973,
 /*  2730 */   620, 1610,  615,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   331,  369,  333,  334,  372,  373,  389,  327,  360,  420,
 /*    10 */   421,  357,   12,   13,   14,  327,  359,  431,  358,  371,
 /*    20 */    20,  435,   22,  360,  370,   12,   13,   14,   15,   16,
 /*    30 */   327,  335,  324,   33,  371,   35,  450,  451,  358,  379,
 /*    40 */   380,  455,  456,  372,  373,  349,  366,  335,  431,  401,
 /*    50 */   402,  371,  435,  373,    1,    2,   20,  389,   58,  371,
 /*    60 */   412,  358,  366,   63,  401,  402,  403,  450,  451,  366,
 /*    70 */    70,   20,  455,  456,  371,  412,  373,  332,  398,   20,
 /*    80 */   335,  336,  402,   12,   13,  405,  406,  407,  408,  409,
 /*    90 */   410,   20,  412,   22,  382,   95,  384,  389,   20,  431,
 /*   100 */   335,  398,  342,  435,   33,  402,   35,  347,  405,  406,
 /*   110 */   407,  408,  409,  410,  349,  412,   58,  117,  450,  451,
 /*   120 */   417,  356,  419,  455,  456,  351,  423,  424,  354,   58,
 /*   130 */    20,  366,  132,  133,   63,   95,  335,  457,  458,  431,
 /*   140 */   437,   70,  335,  435,  331,  105,  333,  334,  445,   96,
 /*   150 */   349,   18,   35,   95,   95,   97,   23,  356,  450,  451,
 /*   160 */   373,  161,  162,  455,  456,  332,   95,  366,  335,  336,
 /*   170 */    37,   38,  385,  366,   41,  388,  404,   65,   66,   67,
 /*   180 */   180,    0,  182,  132,  133,   73,   74,   70,  117,  360,
 /*   190 */    78,  350,   59,   60,   61,   83,   84,  161,  162,  358,
 /*   200 */   371,   89,  430,  132,  133,   95,  206,  207,  367,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,   95,  335,
 /*   230 */   401,  402,  161,  162,  427,  428,  429,   20,  431,  432,
 /*   240 */    20,  412,  435,  349,   14,   20,   65,   66,   67,  358,
 /*   250 */    20,  180,  127,  182,   73,   74,  131,  450,  451,   78,
 /*   260 */   366,  163,  455,  456,   83,   84,  168,  134,    8,    9,
 /*   270 */    89,  380,   12,   13,   14,   15,   16,  206,  207,  389,
 /*   280 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,    4,
 /*   300 */   229,   12,   13,  245,  245,  172,  173,  174,  339,   20,
 /*   310 */   177,   22,  187,  188,   19,  358,  191,  339,  193,  327,
 /*   320 */    95,  431,   33,  366,   35,  435,  358,   44,   33,  196,
 /*   330 */   361,  353,  199,  365,  201,  202,  203,  204,  205,  361,
 /*   340 */   450,  451,  374,   48,  360,  455,  456,   58,   53,  350,
 /*   350 */   358,    4,   63,   58,  350,  371,   96,  358,  366,   70,
 /*   360 */     3,   62,  358,  371,  407,  373,  367,   14,   15,   16,
 /*   370 */   335,  367,   12,   13,   14,   20,   95,   20,  245,   96,
 /*   380 */    20,  327,   22,  163,   95,  401,  402,  403,   95,   94,
 /*   390 */   398,  341,   97,   33,  402,   35,  412,  405,  406,  407,
 /*   400 */   408,  409,  410,  229,  412,  355,  117,  415,  160,  417,
 /*   410 */   418,  419,  358,    0,  364,  423,  424,  382,   58,  384,
 /*   420 */   366,  132,  133,  126,  127,  371,    4,  373,  131,    0,
 /*   430 */    70,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*   440 */   117,  118,   95,  120,  121,  122,  123,  124,  125,  106,
 /*   450 */   161,  162,  398,   96,   20,   95,  402,    0,   58,  405,
 /*   460 */   406,  407,  408,  409,  410,   43,  412,   45,   46,  180,
 /*   470 */   245,  182,  179,  419,  181,   62,   20,  117,  424,  335,
 /*   480 */   232,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   490 */   242,   62,  132,  133,   94,  206,  207,   97,  209,  210,
 /*   500 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   510 */   221,  222,  223,  224,  225,  226,  227,  344,  345,  375,
 /*   520 */   163,  161,  162,    0,   21,  335,  245,   24,   25,   26,
 /*   530 */    27,   28,   29,   30,   31,   32,  341,   62,  245,  349,
 /*   540 */   180,  326,  182,  328,   21,   20,  327,   24,   25,   26,
 /*   550 */    27,   28,   29,   30,   31,   32,  366,    8,    9,  364,
 /*   560 */   327,   12,   13,   14,   15,   16,  206,  207,   95,  209,
 /*   570 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   580 */   220,  221,  222,  223,  224,  225,  226,  227,   12,   13,
 /*   590 */   371,  358,  245,   44,   22,   79,   20,  373,   22,  366,
 /*   600 */    37,   20,   70,   22,  371,  166,  373,   35,  229,   33,
 /*   610 */   231,   35,  388,  358,  358,  416,   35,  418,    8,    9,
 /*   620 */   365,  365,   12,   13,   14,   15,   16,   39,  327,  374,
 /*   630 */   374,  398,   51,  360,   58,  402,   21,  335,  405,  406,
 /*   640 */   407,  408,  409,  410,  371,  412,   70,  206,  335,   34,
 /*   650 */   417,   36,  419,  137,  138,  335,  423,  424,  404,   12,
 /*   660 */    13,   98,  349,  100,  101,   70,  103,   20,  366,   22,
 /*   670 */   107,   95,  371,   63,  401,  402,  403,  359,  445,  366,
 /*   680 */    33,  175,   35,   20,  430,  412,  366,  431,   14,  250,
 /*   690 */   251,  435,  129,  117,   20,  254,  255,  256,  257,  258,
 /*   700 */   259,  260,  393,  197,  198,   58,  450,  451,  132,  133,
 /*   710 */   327,  455,  456,  126,  104,  431,  327,   70,  245,  435,
 /*   720 */     8,    9,  335,  359,   12,   13,   14,   15,   16,  427,
 /*   730 */   428,  429,   20,  431,  432,  451,  349,  161,  162,  455,
 /*   740 */   456,  431,   95,  404,   14,  435,  426,  427,  428,  429,
 /*   750 */    20,  431,  432,  366,  371,  359,  180,  416,  182,  418,
 /*   760 */   371,  451,  107,  327,  117,  455,  456,    8,    9,  430,
 /*   770 */   160,   12,   13,   14,   15,   16,  189,  190,  415,  132,
 /*   780 */   133,  418,  206,  207,  129,  209,  210,  211,  212,  213,
 /*   790 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   800 */   224,  225,  226,  227,   18,    3,   20,  371,  161,  162,
 /*   810 */    20,  359,   22,   27,  344,  345,   30,    8,    9,   33,
 /*   820 */   366,   12,   13,   14,   15,   16,  163,  180,    0,  182,
 /*   830 */   368,  377,  244,  371,   48,  161,   50,  327,    4,   53,
 /*   840 */   327,   51,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   850 */   240,  241,  242,  206,  207,   96,  209,  210,  211,  212,
 /*   860 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   870 */   223,  224,  225,  226,  227,  163,    2,  327,  359,  327,
 /*   880 */    94,  371,    8,    9,  371,  359,   12,   13,   14,   15,
 /*   890 */    16,  161,  106,   65,   66,   67,   68,   69,  327,   71,
 /*   900 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   910 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   920 */   327,  371,  136,  371,  327,  139,  140,  141,  142,  143,
 /*   930 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,
 /*   940 */   154,  155,  371,  157,  158,  159,  327,  327,  327,  366,
 /*   950 */   366,  351,   12,   13,  354,  358,  327,  335,  335,   20,
 /*   960 */   377,  377,   22,  366,  371,  335,  335,  327,  371,    0,
 /*   970 */   373,  349,  349,   33,  358,   35,   20,  335,  358,  349,
 /*   980 */   349,  172,  346,  367,  348,  358,  366,  328,  366,  366,
 /*   990 */   371,  371,  371,  373,  389,  398,  366,  366,   58,  402,
 /*  1000 */   371,  374,  405,  406,  407,  408,  409,  410,  366,  412,
 /*  1010 */    70,  371,   45,   46,  417,  327,  419,  347,  398,  327,
 /*  1020 */   423,  424,  402,    0,  327,  405,  406,  407,  408,  409,
 /*  1030 */   410,  434,  412,  327,   44,    2,  431,  417,  381,  419,
 /*  1040 */   435,    8,    9,  423,  424,   12,   13,   14,   15,   16,
 /*  1050 */   368,  243,  244,  371,  434,  450,  451,  117,    0,  371,
 /*  1060 */   455,  456,  368,  371,  358,  371,  264,   33,  371,  427,
 /*  1070 */   428,  429,  366,  431,  432,  337,  107,  371,  269,  373,
 /*  1080 */   246,    0,   48,    0,   42,   42,   44,   44,   54,   55,
 /*  1090 */    56,   57,   58,  106,  459,  126,  127,  128,  129,  130,
 /*  1100 */   131,   44,  163,   22,  398,   22,   48,  192,  402,  194,
 /*  1110 */   327,  405,  406,  407,  408,  409,  410,  161,  412,  335,
 /*  1120 */   180,   99,  182,  417,  102,  419,  132,  133,   94,  423,
 /*  1130 */   424,   97,   35,  349,  327,   13,   99,   58,   22,  102,
 /*  1140 */   434,  358,   44,  156,   44,   44,  206,  207,  107,  366,
 /*  1150 */   366,   35,  335,    0,  371,   35,  373,   35,  218,  219,
 /*  1160 */   220,  221,  222,  223,  224,  358,  349,  126,  127,  128,
 /*  1170 */   129,  130,  131,  366,  151,   22,   97,   63,  371,  327,
 /*  1180 */   373,  398,  448,  366,   99,  402,   70,  102,  405,  406,
 /*  1190 */   407,  408,  409,  410,   96,  412,   96,   96,  164,  165,
 /*  1200 */   417,  167,  419,   44,  170,  398,  423,  424,  442,  402,
 /*  1210 */   358,    0,  405,  406,  407,  408,  409,  410,  366,  412,
 /*  1220 */   186,    1,    2,  371,  417,  373,  419,  358,  337,   44,
 /*  1230 */   423,  424,  335,  117,  327,    8,    9,  335,  381,   12,
 /*  1240 */    13,   14,   15,   16,  334,   44,  349,   44,   44,   44,
 /*  1250 */   398,  349,  335,  335,  402,   96,  266,  405,  406,  407,
 /*  1260 */   408,  409,  410,  366,  412,  358,  349,  349,  366,  417,
 /*  1270 */   370,  419,  335,  366,   99,  423,  424,  102,  371,  182,
 /*  1280 */   373,   96,  389,  366,  366,  381,  349,    8,    9,  433,
 /*  1290 */   327,   12,   13,   14,   15,   16,  180,   96,  182,   96,
 /*  1300 */    96,   96,  182,  366,   44,  398,   47,   44,   44,  402,
 /*  1310 */    44,   44,  405,  406,  407,  408,  409,  410,  107,  412,
 /*  1320 */   206,  358,  206,  207,  431,  268,  419,    0,  435,  366,
 /*  1330 */   423,  424,   44,  335,  371,  327,  373,  126,  127,  128,
 /*  1340 */   129,  130,  131,  450,  451,   13,   44,  349,  455,  456,
 /*  1350 */    35,  452,  425,  247,   95,  436,   96,  400,  327,   96,
 /*  1360 */    96,  398,   96,   96,  366,  402,  358,   35,  405,  406,
 /*  1370 */   407,  408,  409,  410,  366,  412,   49,   48,  399,  371,
 /*  1380 */   178,  373,  419,  391,   96,   70,  423,  424,   42,  358,
 /*  1390 */   163,  378,   20,  381,  378,  160,  376,  366,   96,   20,
 /*  1400 */   335,  335,  371,  378,  373,  376,  398,   93,  376,  335,
 /*  1410 */   402,  343,  335,  405,  406,  407,  408,  409,  410,  335,
 /*  1420 */   412,   20,  329,  329,   20,  395,  373,  419,  341,  398,
 /*  1430 */   341,  423,  424,  402,   20,  336,  405,  406,  407,  408,
 /*  1440 */   409,  410,  411,  412,  413,  414,  327,   20,  341,  390,
 /*  1450 */   341,  336,  341,  341,  341,   52,  335,  329,  397,  371,
 /*  1460 */   358,  338,  327,  338,  195,  329,  358,  335,  358,  185,
 /*  1470 */   395,  381,  394,  339,  371,  358,  358,  358,  373,  339,
 /*  1480 */   335,  253,  358,  252,  358,  366,  441,  358,  358,  358,
 /*  1490 */   371,  358,  373,  358,  261,  441,  444,  171,  371,  443,
 /*  1500 */   263,  366,  262,  441,  440,  248,  371,  438,  373,  439,
 /*  1510 */   371,  270,  371,  371,  371,  460,  267,  398,  327,  381,
 /*  1520 */   265,  402,  244,  386,  405,  406,  407,  408,  409,  410,
 /*  1530 */   386,  412,  366,  398,  454,  453,   20,  402,  339,   20,
 /*  1540 */   405,  406,  407,  408,  409,  410,  327,  412,  400,  358,
 /*  1550 */   404,  335,  384,  336,  371,  386,  386,  366,  371,  371,
 /*  1560 */   371,  371,  371,  371,  373,  446,  447,  165,  339,  383,
 /*  1570 */    95,  339,  354,  366,  422,   95,  362,  358,  348,  371,
 /*  1580 */   335,  339,  447,  330,   36,  366,  392,  329,  352,  398,
 /*  1590 */   371,  396,  373,  402,  340,  352,  405,  406,  407,  408,
 /*  1600 */   409,  410,  387,  412,  352,  325,    0,    0,  327,  387,
 /*  1610 */   187,    0,    0,   42,    0,   35,  200,  398,   35,   35,
 /*  1620 */    19,  402,   35,    0,  405,  406,  407,  408,  409,  410,
 /*  1630 */   200,  412,   35,   35,   33,  200,    0,  200,    0,  358,
 /*  1640 */   449,    0,   22,   35,  363,    0,  182,  366,   35,   48,
 /*  1650 */   180,    0,  371,    0,  373,   54,   55,   56,   57,   58,
 /*  1660 */   176,    0,  175,  327,   47,    0,    0,    0,   42,    0,
 /*  1670 */     0,    0,    0,    0,    0,    0,    0,  458,    0,  398,
 /*  1680 */   151,   35,    0,  402,  151,    0,  405,  406,  407,  408,
 /*  1690 */   409,  410,    0,  412,  358,   94,    0,    0,   97,    0,
 /*  1700 */     0,    0,  366,    0,    0,    0,    0,  371,    0,  373,
 /*  1710 */     0,    0,    0,    0,    0,    0,    0,    0,    0,   42,
 /*  1720 */    22,    0,    0,  135,    0,  327,   35,    0,    0,    0,
 /*  1730 */     0,  130,    0,   39,  398,   42,   47,   58,  402,   58,
 /*  1740 */     0,  405,  406,  407,  408,  409,  410,   14,  412,   47,
 /*  1750 */   414,   44,   14,    0,    0,  327,  358,    0,    0,    0,
 /*  1760 */    40,  363,   39,  171,  366,    0,   47,    0,  167,  371,
 /*  1770 */    39,  373,    0,   64,   35,   39,    0,   35,    0,   35,
 /*  1780 */    39,    0,   48,   48,    0,  184,  358,  186,   39,   39,
 /*  1790 */    35,  363,    0,   48,  366,   48,  398,    0,    0,  371,
 /*  1800 */   402,  373,   22,  405,  406,  407,  408,  409,  410,   35,
 /*  1810 */   412,    0,   35,  327,   35,   44,   22,   35,   35,   44,
 /*  1820 */    35,   35,   35,    0,   22,    0,  398,  102,   22,  327,
 /*  1830 */   402,    0,   22,  405,  406,  407,  408,  409,  410,   50,
 /*  1840 */   412,  104,   35,    0,  358,    0,    0,   35,   35,   22,
 /*  1850 */    35,   35,  366,   20,   35,    0,   96,  371,   95,  373,
 /*  1860 */   358,   35,    0,  183,   22,    0,    0,    3,  366,   96,
 /*  1870 */   249,  249,   44,  371,  327,  373,   44,    3,   44,   44,
 /*  1880 */   249,   44,   44,   95,  398,   95,   47,   96,  402,   96,
 /*  1890 */   327,  405,  406,  407,  408,  409,  410,   96,  412,   95,
 /*  1900 */   398,   47,   35,   95,  402,  358,  163,  405,  406,  407,
 /*  1910 */   408,  409,  410,  366,  412,  163,  165,  169,  371,   95,
 /*  1920 */   373,  358,   35,   35,  163,   96,   47,   35,   35,  366,
 /*  1930 */    35,   95,   47,  243,  371,    0,  373,   96,   44,    0,
 /*  1940 */    96,    0,    0,   96,   47,  398,   95,   39,   96,  402,
 /*  1950 */    47,   95,  405,  406,  407,  408,  409,  410,   95,  412,
 /*  1960 */    44,  398,  166,  164,   96,  402,   95,  327,  405,  406,
 /*  1970 */   407,  408,  409,  410,  105,  412,   95,    2,   22,   95,
 /*  1980 */    47,   47,   96,   22,   95,   35,   96,   35,  106,   35,
 /*  1990 */   228,  327,   96,   95,  230,   95,  228,   95,  358,   35,
 /*  2000 */    96,  206,   95,   22,   35,   96,  366,   95,  208,   96,
 /*  2010 */    95,  371,   95,  373,   96,   96,   95,   35,   96,   95,
 /*  2020 */   119,  107,  358,   95,  119,  119,   95,   44,   35,  119,
 /*  2030 */   366,   95,   22,   35,   64,  371,   63,  373,  398,   35,
 /*  2040 */    35,   35,  402,   35,   35,  405,  406,  407,  408,  409,
 /*  2050 */   410,   35,  412,  327,   35,   35,   35,   70,   92,   44,
 /*  2060 */    35,   35,  398,   35,   22,   35,  402,   35,   35,  405,
 /*  2070 */   406,  407,  408,  409,  410,   35,  412,   70,   35,   35,
 /*  2080 */    35,   35,   22,  327,  358,   35,    0,   35,   39,   48,
 /*  2090 */     0,   35,  366,    0,   39,   48,   35,  371,   39,  373,
 /*  2100 */     0,   48,   35,   39,    0,   48,   35,   35,    0,   22,
 /*  2110 */    21,  461,   20,   22,  358,  461,   22,   21,  461,  461,
 /*  2120 */   461,  461,  366,  461,  398,  461,  461,  371,  402,  373,
 /*  2130 */   461,  405,  406,  407,  408,  409,  410,  461,  412,  461,
 /*  2140 */   461,  327,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2150 */   461,  461,  461,  461,  398,  461,  461,  327,  402,  461,
 /*  2160 */   461,  405,  406,  407,  408,  409,  410,  461,  412,  461,
 /*  2170 */   461,  461,  358,  461,  461,  461,  461,  461,  461,  461,
 /*  2180 */   366,  461,  461,  461,  461,  371,  461,  373,  358,  461,
 /*  2190 */   461,  461,  461,  461,  461,  461,  366,  461,  461,  461,
 /*  2200 */   461,  371,  327,  373,  461,  461,  461,  461,  461,  461,
 /*  2210 */   461,  461,  398,  461,  461,  461,  402,  461,  327,  405,
 /*  2220 */   406,  407,  408,  409,  410,  461,  412,  461,  398,  461,
 /*  2230 */   461,  461,  402,  358,  461,  405,  406,  407,  408,  409,
 /*  2240 */   410,  366,  412,  461,  461,  461,  371,  461,  373,  358,
 /*  2250 */   461,  461,  461,  461,  461,  461,  461,  366,  461,  461,
 /*  2260 */   461,  461,  371,  461,  373,  461,  461,  461,  461,  461,
 /*  2270 */   461,  461,  461,  398,  461,  461,  461,  402,  461,  461,
 /*  2280 */   405,  406,  407,  408,  409,  410,  461,  412,  461,  398,
 /*  2290 */   461,  461,  461,  402,  461,  327,  405,  406,  407,  408,
 /*  2300 */   409,  410,  461,  412,  461,  461,  461,  461,  461,  461,
 /*  2310 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  327,
 /*  2320 */   461,  461,  461,  461,  461,  461,  358,  461,  461,  461,
 /*  2330 */   461,  461,  461,  461,  366,  461,  461,  461,  461,  371,
 /*  2340 */   461,  373,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2350 */   358,  461,  461,  461,  461,  461,  461,  461,  366,  461,
 /*  2360 */   461,  461,  461,  371,  461,  373,  398,  461,  461,  461,
 /*  2370 */   402,  461,  461,  405,  406,  407,  408,  409,  410,  461,
 /*  2380 */   412,  327,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2390 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2400 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  461,
 /*  2410 */   461,  327,  358,  461,  461,  461,  461,  461,  461,  461,
 /*  2420 */   366,  461,  461,  461,  461,  371,  461,  373,  461,  461,
 /*  2430 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2440 */   461,  461,  358,  461,  461,  461,  461,  461,  461,  461,
 /*  2450 */   366,  461,  398,  461,  461,  371,  402,  373,  461,  405,
 /*  2460 */   406,  407,  408,  409,  410,  461,  412,  461,  461,  327,
 /*  2470 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2480 */   461,  461,  398,  461,  461,  327,  402,  461,  461,  405,
 /*  2490 */   406,  407,  408,  409,  410,  461,  412,  461,  461,  461,
 /*  2500 */   358,  461,  461,  461,  461,  461,  461,  461,  366,  461,
 /*  2510 */   461,  461,  461,  371,  461,  373,  358,  461,  461,  461,
 /*  2520 */   461,  461,  461,  461,  366,  461,  461,  461,  461,  371,
 /*  2530 */   327,  373,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2540 */   398,  461,  461,  461,  402,  461,  327,  405,  406,  407,
 /*  2550 */   408,  409,  410,  461,  412,  461,  398,  461,  461,  461,
 /*  2560 */   402,  358,  461,  405,  406,  407,  408,  409,  410,  366,
 /*  2570 */   412,  461,  461,  461,  371,  461,  373,  358,  461,  461,
 /*  2580 */   461,  461,  461,  461,  461,  366,  461,  461,  461,  461,
 /*  2590 */   371,  461,  373,  461,  461,  461,  461,  461,  461,  461,
 /*  2600 */   461,  398,  461,  461,  461,  402,  461,  461,  405,  406,
 /*  2610 */   407,  408,  409,  410,  461,  412,  461,  398,  461,  461,
 /*  2620 */   461,  402,  461,  327,  405,  406,  407,  408,  409,  410,
 /*  2630 */   461,  412,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2640 */   461,  461,  461,  461,  461,  461,  461,  327,  461,  461,
 /*  2650 */   461,  461,  461,  461,  358,  461,  461,  461,  461,  461,
 /*  2660 */   461,  461,  366,  461,  461,  461,  461,  371,  461,  373,
 /*  2670 */   461,  461,  461,  461,  461,  461,  461,  461,  358,  461,
 /*  2680 */   461,  461,  461,  461,  461,  461,  366,  461,  461,  461,
 /*  2690 */   461,  371,  461,  373,  398,  461,  461,  461,  402,  461,
 /*  2700 */   461,  405,  406,  407,  408,  409,  410,  461,  412,  461,
 /*  2710 */   461,  461,  461,  461,  461,  461,  461,  461,  398,  461,
 /*  2720 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2730 */   410,  461,  412,
};
#define YY_SHIFT_COUNT    (715)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2108)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   133,    0,   71,    0,  289,  289,  289,  289,  289,  289,
 /*    10 */   289,  289,  289,  360,  576,  576,  647,  576,  576,  576,
 /*    20 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    30 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    40 */   576,  576,  576,  576,  576,  576,   59,  225,  110,  293,
 /*    50 */    58,  281,  473,  281,  110,  110,  940,  940,  940,  281,
 /*    60 */   940,  940,  347,  281,   78,   78,  422,  422,   36,   51,
 /*    70 */   230,  230,   78,   78,   78,   78,   78,   78,   78,  217,
 /*    80 */    78,   78,  299,   78,   78,  355,   78,  434,   78,  217,
 /*    90 */   456,   78,   78,  456,   78,  456,  456,  456,   78,  475,
 /*   100 */   786,  610,  610,  503,  112, 1116, 1116, 1116, 1116, 1116,
 /*   110 */  1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116, 1116,
 /*   120 */  1116, 1116, 1116, 1116,  563,  357,   36,   51,  413,  117,
 /*   130 */   220,  220,  220,  429,  379,  379,  117,  525,  525,  525,
 /*   140 */   343,  434,  174,  456,  532,  456,  532,  532,  343,  595,
 /*   150 */   323,  323,  323,  323,  323,  323,  323, 1601,  523,  181,
 /*   160 */   712,  809,  441,  581,  439,  674,  730,  790,  663,  967,
 /*   170 */   655,  939,  808,  588,  802,  808, 1042,  834,  956, 1106,
 /*   180 */  1329, 1202, 1346, 1372, 1346, 1235, 1379, 1379, 1346, 1235,
 /*   190 */  1235, 1314, 1379, 1379, 1379, 1401, 1401, 1404,  299,  434,
 /*   200 */   299, 1414, 1427,  299, 1414,  299,  299,  299, 1379,  299,
 /*   210 */  1403, 1403, 1401,  456,  456,  456,  456,  456,  456,  456,
 /*   220 */   456,  456,  456,  456, 1379, 1401,  532,  532,  532, 1269,
 /*   230 */  1404,  475, 1284,  434,  475, 1379, 1372, 1372,  532, 1228,
 /*   240 */  1231,  532, 1228, 1231,  532,  532,  456, 1233, 1326, 1228,
 /*   250 */  1237, 1240, 1257, 1106, 1241, 1249, 1255, 1278,  525, 1516,
 /*   260 */  1379, 1414,  475, 1519, 1231,  532,  532,  532,  532,  532,
 /*   270 */  1231,  532, 1402,  475,  343,  475,  525, 1475, 1480,  532,
 /*   280 */   595, 1379,  475, 1548, 1401, 2733, 2733, 2733, 2733, 2733,
 /*   290 */  2733, 2733, 2733, 2733,  828, 1034,  457,  295,  260,  549,
 /*   300 */   759,  969,  874, 1033, 1227, 1211, 1279, 1279, 1279, 1279,
 /*   310 */  1279, 1279, 1279, 1279, 1279, 1041,  125,   13,   13,  506,
 /*   320 */   400,  516,  615,  587,  297,  297,  353,   53,  248,  353,
 /*   330 */   353,  353,  283, 1058,  572, 1043,  987, 1023, 1022, 1037,
 /*   340 */  1085, 1175, 1081, 1083, 1153,  915, 1079, 1098, 1100, 1101,
 /*   350 */   994,  990, 1057,   98, 1159, 1185, 1201, 1203, 1204, 1220,
 /*   360 */  1205, 1097, 1120, 1114, 1260, 1259, 1263, 1264, 1266, 1267,
 /*   370 */  1288, 1302,   40, 1122, 1332, 1315, 1327, 1606, 1607, 1423,
 /*   380 */  1611, 1612, 1571, 1614, 1580, 1416, 1583, 1584, 1587, 1430,
 /*   390 */  1623, 1597, 1598, 1435, 1636, 1437, 1638, 1608, 1641, 1620,
 /*   400 */  1645, 1613, 1464, 1470, 1651, 1653, 1484, 1487, 1661, 1678,
 /*   410 */  1617, 1665, 1666, 1667, 1626, 1669, 1670, 1671, 1672, 1673,
 /*   420 */  1674, 1675, 1676, 1529, 1646, 1682, 1533, 1685, 1692, 1696,
 /*   430 */  1697, 1699, 1700, 1701, 1703, 1704, 1705, 1706, 1708, 1710,
 /*   440 */  1711, 1712, 1677, 1713, 1714, 1715, 1716, 1717, 1698, 1718,
 /*   450 */  1721, 1722, 1588, 1724, 1732, 1691, 1727, 1679, 1728, 1681,
 /*   460 */  1729, 1730, 1693, 1694, 1707, 1689, 1733, 1702, 1738, 1719,
 /*   470 */  1740, 1720, 1723, 1753, 1754, 1757, 1731, 1592, 1758, 1759,
 /*   480 */  1765, 1709, 1767, 1772, 1739, 1734, 1736, 1776, 1742, 1735,
 /*   490 */  1741, 1778, 1744, 1745, 1749, 1781, 1755, 1747, 1750, 1784,
 /*   500 */  1792, 1797, 1798, 1737, 1725, 1774, 1780, 1811, 1777, 1779,
 /*   510 */  1782, 1783, 1771, 1775, 1785, 1786, 1794, 1787, 1823, 1802,
 /*   520 */  1825, 1806, 1789, 1831, 1810, 1807, 1843, 1812, 1845, 1813,
 /*   530 */  1846, 1827, 1833, 1815, 1816, 1819, 1760, 1763, 1855, 1743,
 /*   540 */  1826, 1862, 1680, 1842, 1752, 1751, 1865, 1866, 1761, 1748,
 /*   550 */  1864, 1828, 1621, 1788, 1773, 1790, 1791, 1832, 1834, 1793,
 /*   560 */  1804, 1808, 1824, 1801, 1835, 1839, 1854, 1836, 1837, 1622,
 /*   570 */  1829, 1841, 1874, 1838, 1631, 1867, 1887, 1888, 1892, 1893,
 /*   580 */  1895, 1844, 1847, 1879, 1690, 1894, 1885, 1935, 1939, 1941,
 /*   590 */  1689, 1897, 1851, 1852, 1868, 1856, 1863, 1796, 1871, 1942,
 /*   600 */  1908, 1799, 1881, 1869, 1689, 1903, 1916, 1762, 1764, 1768,
 /*   610 */  1975, 1956, 1795, 1884, 1886, 1889, 1890, 1898, 1896, 1933,
 /*   620 */  1900, 1902, 1934, 1904, 1961, 1800, 1907, 1882, 1909, 1950,
 /*   630 */  1952, 1912, 1913, 1954, 1915, 1918, 1964, 1917, 1919, 1969,
 /*   640 */  1921, 1922, 1982, 1924, 1901, 1905, 1906, 1910, 1981, 1914,
 /*   650 */  1928, 1983, 1931, 1993, 1936, 1983, 1983, 2010, 1970, 1973,
 /*   660 */  1998, 2004, 2005, 2006, 2008, 2009, 2016, 2019, 2020, 2021,
 /*   670 */  1987, 1966, 2015, 2025, 2026, 2028, 2042, 2030, 2032, 2033,
 /*   680 */  2007, 1771, 2040, 1775, 2043, 2044, 2045, 2046, 2060, 2050,
 /*   690 */  2086, 2052, 2041, 2049, 2090, 2056, 2047, 2055, 2093, 2061,
 /*   700 */  2053, 2059, 2100, 2067, 2057, 2064, 2104, 2071, 2072, 2108,
 /*   710 */  2087, 2089, 2091, 2094, 2096, 2092,
};
#define YY_REDUCE_COUNT (293)
#define YY_REDUCE_MIN   (-414)
#define YY_REDUCE_MAX   (2320)
static const short yy_reduce_ofst[] = {
 /*     0 */  -292, -297,   -8,  233,  597,  620,  706,  783,  807,  852,
 /*    10 */   907,  963, 1008, 1031, 1119, -320,   54, 1135, 1191, 1219,
 /*    20 */  1281, 1336, 1398, 1428, 1486, 1502, 1547, 1563, 1640, 1664,
 /*    30 */  1726, 1756, 1814, 1830, 1875, 1891, 1968, 1992, 2054, 2084,
 /*    40 */  2142, 2158, 2203, 2219, 2296, 2320, -193,  256,  320, -383,
 /*    50 */  -332, -110,  605,  893,  302,  642, -337,  -16,  273, -414,
 /*    60 */  -352, -171,  284,  310, -235, -199, -331, -187, -340, -368,
 /*    70 */  -255, -167, -304, -106,  190,  313,  387,  622,  623, -288,
 /*    80 */   631,  784,   50,  817,  897,  -43,  902, -213,  917,   35,
 /*    90 */  -159,  918,  937,  -32,  998,   -1,  255,    4,  630,  -22,
 /*   100 */   144, -411, -411,  215, -240, -312,  219,  301,  383,  389,
 /*   110 */   436,  510,  513,  550,  552,  571,  593,  619,  621,  629,
 /*   120 */   640,  688,  692,  697, -346, -228, -109, -329,  195,  173,
 /*   130 */  -228,  254,  339,  -31,  199,  341,  470,  454,  583,  584,
 /*   140 */  -226,  224,  363,  616,  462,  627,  682,  694,  600,  636,
 /*   150 */  -343,  318,  364,  396,  452,  519,  526,  309,  659,  670,
 /*   160 */   657,  635,  734,  738,  766,  869,  869,  891,  857,  910,
 /*   170 */   900,  904,  856,  856,  899,  856,  927,  919,  869,  957,
 /*   180 */   979,  992, 1013, 1012, 1016, 1020, 1065, 1066, 1025, 1029,
 /*   190 */  1032, 1068, 1074, 1077, 1084, 1093, 1094, 1030, 1087, 1053,
 /*   200 */  1089, 1099, 1059, 1107, 1115, 1109, 1111, 1112, 1121, 1113,
 /*   210 */  1123, 1125, 1128, 1102, 1108, 1110, 1117, 1118, 1124, 1126,
 /*   220 */  1129, 1130, 1131, 1133, 1132, 1136, 1088, 1103, 1127, 1061,
 /*   230 */  1075, 1134, 1078, 1105, 1140, 1145, 1090, 1138, 1139, 1045,
 /*   240 */  1137, 1141, 1054, 1144, 1142, 1143,  869, 1052, 1056, 1062,
 /*   250 */  1064, 1070, 1069, 1148, 1055, 1080, 1082,  856, 1166, 1146,
 /*   260 */  1216, 1217, 1199, 1168, 1169, 1183, 1187, 1188, 1189, 1190,
 /*   270 */  1170, 1192, 1186, 1229, 1218, 1232, 1207, 1152, 1214, 1208,
 /*   280 */  1230, 1245, 1242, 1253, 1258, 1194, 1195, 1215, 1222, 1236,
 /*   290 */  1243, 1252, 1254, 1280,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    10 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    20 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    30 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    40 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    50 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    60 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1863, 1608,
 /*    70 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    80 */  1608, 1608, 1686, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*    90 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1684,
 /*   100 */  1856, 2058, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   110 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   120 */  1608, 1608, 1608, 1608, 1608, 2070, 1608, 1608, 1686, 1608,
 /*   130 */  2070, 2070, 2070, 1684, 2030, 2030, 1608, 1608, 1608, 1608,
 /*   140 */  1793, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1793, 1608,
 /*   150 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1902, 1608, 1608,
 /*   160 */  2095, 2150, 1608, 1608, 2098, 1608, 1608, 1608, 1868, 1608,
 /*   170 */  1746, 2085, 2062, 2076, 2134, 2063, 2060, 2079, 1608, 2089,
 /*   180 */  1608, 1895, 1861, 1608, 1861, 1858, 1608, 1608, 1861, 1858,
 /*   190 */  1858, 1737, 1608, 1608, 1608, 1608, 1608, 1608, 1686, 1608,
 /*   200 */  1686, 1608, 1608, 1686, 1608, 1686, 1686, 1686, 1608, 1686,
 /*   210 */  1665, 1665, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   220 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1917,
 /*   230 */  1608, 1684, 1904, 1608, 1684, 1608, 1608, 1608, 1608, 2105,
 /*   240 */  2103, 1608, 2105, 2103, 1608, 1608, 1608, 2119, 2115, 2105,
 /*   250 */  2123, 2121, 2091, 2089, 2153, 2140, 2136, 2076, 1608, 1608,
 /*   260 */  1608, 1608, 1684, 1608, 2103, 1608, 1608, 1608, 1608, 1608,
 /*   270 */  2103, 1608, 1608, 1684, 1608, 1684, 1608, 1608, 1762, 1608,
 /*   280 */  1608, 1608, 1684, 1640, 1608, 1897, 1908, 1880, 1880, 1796,
 /*   290 */  1796, 1796, 1687, 1613, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   300 */  1608, 1608, 1608, 1608, 1608, 1608, 2118, 2117, 1986, 1608,
 /*   310 */  2034, 2033, 2032, 2023, 1985, 1758, 1608, 1984, 1983, 1608,
 /*   320 */  1608, 1608, 1608, 1608, 1876, 1875, 1977, 1608, 1608, 1978,
 /*   330 */  1976, 1975, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   340 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   350 */  1608, 2137, 2141, 1608, 1608, 1608, 1608, 1608, 1608, 2059,
 /*   360 */  1608, 1608, 1608, 1608, 1608, 1959, 1608, 1608, 1608, 1608,
 /*   370 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   380 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   390 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   400 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   410 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   420 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   430 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   440 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   450 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   460 */  1608, 1608, 1608, 1608, 1645, 1964, 1608, 1608, 1608, 1608,
 /*   470 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   480 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   490 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   500 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   510 */  1608, 1608, 1725, 1724, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   520 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   530 */  1608, 1608, 1608, 1608, 1608, 1608, 1968, 1608, 1608, 1608,
 /*   540 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   550 */  2133, 2092, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   560 */  1608, 1608, 1608, 1608, 1608, 1608, 1959, 1608, 2116, 1608,
 /*   570 */  1608, 2131, 1608, 2135, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   580 */  1608, 2069, 2065, 1608, 1608, 2061, 1608, 1608, 1608, 1608,
 /*   590 */  1967, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   600 */  1608, 1608, 1608, 1608, 1958, 1608, 2020, 1608, 1608, 1608,
 /*   610 */  2054, 1608, 1608, 2005, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   620 */  1608, 1608, 1608, 1968, 1608, 1971, 1608, 1608, 1608, 1608,
 /*   630 */  1608, 1790, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   640 */  1608, 1608, 1608, 1608, 1775, 1773, 1772, 1771, 1608, 1768,
 /*   650 */  1608, 1803, 1608, 1608, 1608, 1799, 1798, 1608, 1608, 1608,
 /*   660 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   670 */  1608, 1608, 1705, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   680 */  1608, 1697, 1608, 1696, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   690 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   700 */  1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608, 1608,
 /*   710 */  1608, 1608, 1608, 1608, 1608, 1608,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  271,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  271,  /*      AFTER => ABORT */
  271,  /*     ATTACH => ABORT */
  271,  /*     BEFORE => ABORT */
  271,  /*      BEGIN => ABORT */
  271,  /*     BITAND => ABORT */
  271,  /*     BITNOT => ABORT */
  271,  /*      BITOR => ABORT */
  271,  /*     BLOCKS => ABORT */
  271,  /*     CHANGE => ABORT */
  271,  /*      COMMA => ABORT */
  271,  /*    COMPACT => ABORT */
  271,  /*     CONCAT => ABORT */
  271,  /*   CONFLICT => ABORT */
  271,  /*       COPY => ABORT */
  271,  /*   DEFERRED => ABORT */
  271,  /* DELIMITERS => ABORT */
  271,  /*     DETACH => ABORT */
  271,  /*     DIVIDE => ABORT */
  271,  /*        DOT => ABORT */
  271,  /*       EACH => ABORT */
  271,  /*       FAIL => ABORT */
  271,  /*       FILE => ABORT */
  271,  /*        FOR => ABORT */
  271,  /*       GLOB => ABORT */
  271,  /*         ID => ABORT */
  271,  /*  IMMEDIATE => ABORT */
  271,  /*     IMPORT => ABORT */
  271,  /*  INITIALLY => ABORT */
  271,  /*    INSTEAD => ABORT */
  271,  /*     ISNULL => ABORT */
  271,  /*        KEY => ABORT */
  271,  /*    MODULES => ABORT */
  271,  /*  NK_BITNOT => ABORT */
  271,  /*    NK_SEMI => ABORT */
  271,  /*    NOTNULL => ABORT */
  271,  /*         OF => ABORT */
  271,  /*       PLUS => ABORT */
  271,  /*  PRIVILEGE => ABORT */
  271,  /*      RAISE => ABORT */
  271,  /*    REPLACE => ABORT */
  271,  /*   RESTRICT => ABORT */
  271,  /*        ROW => ABORT */
  271,  /*       SEMI => ABORT */
  271,  /*       STAR => ABORT */
  271,  /*  STATEMENT => ABORT */
  271,  /*     STRICT => ABORT */
  271,  /*     STRING => ABORT */
  271,  /*      TIMES => ABORT */
  271,  /*     VALUES => ABORT */
  271,  /*   VARIABLE => ABORT */
  271,  /*       VIEW => ABORT */
  271,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "TOPIC",
  /*  168 */ "WITH",
  /*  169 */ "META",
  /*  170 */ "CONSUMER",
  /*  171 */ "GROUP",
  /*  172 */ "DESC",
  /*  173 */ "DESCRIBE",
  /*  174 */ "RESET",
  /*  175 */ "QUERY",
  /*  176 */ "CACHE",
  /*  177 */ "EXPLAIN",
  /*  178 */ "ANALYZE",
  /*  179 */ "VERBOSE",
  /*  180 */ "NK_BOOL",
  /*  181 */ "RATIO",
  /*  182 */ "NK_FLOAT",
  /*  183 */ "OUTPUTTYPE",
  /*  184 */ "AGGREGATE",
  /*  185 */ "BUFSIZE",
  /*  186 */ "STREAM",
  /*  187 */ "INTO",
  /*  188 */ "TRIGGER",
  /*  189 */ "AT_ONCE",
  /*  190 */ "WINDOW_CLOSE",
  /*  191 */ "IGNORE",
  /*  192 */ "EXPIRED",
  /*  193 */ "FILL_HISTORY",
  /*  194 */ "UPDATE",
  /*  195 */ "SUBTABLE",
  /*  196 */ "KILL",
  /*  197 */ "CONNECTION",
  /*  198 */ "TRANSACTION",
  /*  199 */ "BALANCE",
  /*  200 */ "VGROUP",
  /*  201 */ "MERGE",
  /*  202 */ "REDISTRIBUTE",
  /*  203 */ "SPLIT",
  /*  204 */ "DELETE",
  /*  205 */ "INSERT",
  /*  206 */ "NULL",
  /*  207 */ "NK_QUESTION",
  /*  208 */ "NK_ARROW",
  /*  209 */ "ROWTS",
  /*  210 */ "QSTART",
  /*  211 */ "QEND",
  /*  212 */ "QDURATION",
  /*  213 */ "WSTART",
  /*  214 */ "WEND",
  /*  215 */ "WDURATION",
  /*  216 */ "IROWTS",
  /*  217 */ "CAST",
  /*  218 */ "NOW",
  /*  219 */ "TODAY",
  /*  220 */ "TIMEZONE",
  /*  221 */ "CLIENT_VERSION",
  /*  222 */ "SERVER_VERSION",
  /*  223 */ "SERVER_STATUS",
  /*  224 */ "CURRENT_USER",
  /*  225 */ "COUNT",
  /*  226 */ "LAST_ROW",
  /*  227 */ "CASE",
  /*  228 */ "END",
  /*  229 */ "WHEN",
  /*  230 */ "THEN",
  /*  231 */ "ELSE",
  /*  232 */ "BETWEEN",
  /*  233 */ "IS",
  /*  234 */ "NK_LT",
  /*  235 */ "NK_GT",
  /*  236 */ "NK_LE",
  /*  237 */ "NK_GE",
  /*  238 */ "NK_NE",
  /*  239 */ "MATCH",
  /*  240 */ "NMATCH",
  /*  241 */ "CONTAINS",
  /*  242 */ "IN",
  /*  243 */ "JOIN",
  /*  244 */ "INNER",
  /*  245 */ "SELECT",
  /*  246 */ "DISTINCT",
  /*  247 */ "WHERE",
  /*  248 */ "PARTITION",
  /*  249 */ "BY",
  /*  250 */ "SESSION",
  /*  251 */ "STATE_WINDOW",
  /*  252 */ "SLIDING",
  /*  253 */ "FILL",
  /*  254 */ "VALUE",
  /*  255 */ "VALUE_F",
  /*  256 */ "NONE",
  /*  257 */ "PREV",
  /*  258 */ "NULL_F",
  /*  259 */ "LINEAR",
  /*  260 */ "NEXT",
  /*  261 */ "HAVING",
  /*  262 */ "RANGE",
  /*  263 */ "EVERY",
  /*  264 */ "ORDER",
  /*  265 */ "SLIMIT",
  /*  266 */ "SOFFSET",
  /*  267 */ "LIMIT",
  /*  268 */ "OFFSET",
  /*  269 */ "ASC",
  /*  270 */ "NULLS",
  /*  271 */ "ABORT",
  /*  272 */ "AFTER",
  /*  273 */ "ATTACH",
  /*  274 */ "BEFORE",
  /*  275 */ "BEGIN",
  /*  276 */ "BITAND",
  /*  277 */ "BITNOT",
  /*  278 */ "BITOR",
  /*  279 */ "BLOCKS",
  /*  280 */ "CHANGE",
  /*  281 */ "COMMA",
  /*  282 */ "COMPACT",
  /*  283 */ "CONCAT",
  /*  284 */ "CONFLICT",
  /*  285 */ "COPY",
  /*  286 */ "DEFERRED",
  /*  287 */ "DELIMITERS",
  /*  288 */ "DETACH",
  /*  289 */ "DIVIDE",
  /*  290 */ "DOT",
  /*  291 */ "EACH",
  /*  292 */ "FAIL",
  /*  293 */ "FILE",
  /*  294 */ "FOR",
  /*  295 */ "GLOB",
  /*  296 */ "ID",
  /*  297 */ "IMMEDIATE",
  /*  298 */ "IMPORT",
  /*  299 */ "INITIALLY",
  /*  300 */ "INSTEAD",
  /*  301 */ "ISNULL",
  /*  302 */ "KEY",
  /*  303 */ "MODULES",
  /*  304 */ "NK_BITNOT",
  /*  305 */ "NK_SEMI",
  /*  306 */ "NOTNULL",
  /*  307 */ "OF",
  /*  308 */ "PLUS",
  /*  309 */ "PRIVILEGE",
  /*  310 */ "RAISE",
  /*  311 */ "REPLACE",
  /*  312 */ "RESTRICT",
  /*  313 */ "ROW",
  /*  314 */ "SEMI",
  /*  315 */ "STAR",
  /*  316 */ "STATEMENT",
  /*  317 */ "STRICT",
  /*  318 */ "STRING",
  /*  319 */ "TIMES",
  /*  320 */ "VALUES",
  /*  321 */ "VARIABLE",
  /*  322 */ "VIEW",
  /*  323 */ "WAL",
  /*  324 */ "cmd",
  /*  325 */ "account_options",
  /*  326 */ "alter_account_options",
  /*  327 */ "literal",
  /*  328 */ "alter_account_option",
  /*  329 */ "user_name",
  /*  330 */ "sysinfo_opt",
  /*  331 */ "privileges",
  /*  332 */ "priv_level",
  /*  333 */ "priv_type_list",
  /*  334 */ "priv_type",
  /*  335 */ "db_name",
  /*  336 */ "topic_name",
  /*  337 */ "dnode_endpoint",
  /*  338 */ "force_opt",
  /*  339 */ "not_exists_opt",
  /*  340 */ "db_options",
  /*  341 */ "exists_opt",
  /*  342 */ "alter_db_options",
  /*  343 */ "speed_opt",
  /*  344 */ "integer_list",
  /*  345 */ "variable_list",
  /*  346 */ "retention_list",
  /*  347 */ "alter_db_option",
  /*  348 */ "retention",
  /*  349 */ "full_table_name",
  /*  350 */ "column_def_list",
  /*  351 */ "tags_def_opt",
  /*  352 */ "table_options",
  /*  353 */ "multi_create_clause",
  /*  354 */ "tags_def",
  /*  355 */ "multi_drop_clause",
  /*  356 */ "alter_table_clause",
  /*  357 */ "alter_table_options",
  /*  358 */ "column_name",
  /*  359 */ "type_name",
  /*  360 */ "signed_literal",
  /*  361 */ "create_subtable_clause",
  /*  362 */ "specific_cols_opt",
  /*  363 */ "expression_list",
  /*  364 */ "drop_table_clause",
  /*  365 */ "col_name_list",
  /*  366 */ "table_name",
  /*  367 */ "column_def",
  /*  368 */ "duration_list",
  /*  369 */ "rollup_func_list",
  /*  370 */ "alter_table_option",
  /*  371 */ "duration_literal",
  /*  372 */ "rollup_func_name",
  /*  373 */ "function_name",
  /*  374 */ "col_name",
  /*  375 */ "db_name_cond_opt",
  /*  376 */ "like_pattern_opt",
  /*  377 */ "table_name_cond",
  /*  378 */ "from_db_opt",
  /*  379 */ "tag_list_opt",
  /*  380 */ "tag_item",
  /*  381 */ "column_alias",
  /*  382 */ "full_index_name",
  /*  383 */ "index_options",
  /*  384 */ "index_name",
  /*  385 */ "func_list",
  /*  386 */ "sliding_opt",
  /*  387 */ "sma_stream_opt",
  /*  388 */ "func",
  /*  389 */ "query_or_subquery",
  /*  390 */ "cgroup_name",
  /*  391 */ "analyze_opt",
  /*  392 */ "explain_options",
  /*  393 */ "agg_func_opt",
  /*  394 */ "bufsize_opt",
  /*  395 */ "stream_name",
  /*  396 */ "stream_options",
  /*  397 */ "subtable_opt",
  /*  398 */ "expression",
  /*  399 */ "dnode_list",
  /*  400 */ "where_clause_opt",
  /*  401 */ "signed",
  /*  402 */ "literal_func",
  /*  403 */ "literal_list",
  /*  404 */ "table_alias",
  /*  405 */ "expr_or_subquery",
  /*  406 */ "pseudo_column",
  /*  407 */ "column_reference",
  /*  408 */ "function_expression",
  /*  409 */ "case_when_expression",
  /*  410 */ "star_func",
  /*  411 */ "star_func_para_list",
  /*  412 */ "noarg_func",
  /*  413 */ "other_para_list",
  /*  414 */ "star_func_para",
  /*  415 */ "when_then_list",
  /*  416 */ "case_when_else_opt",
  /*  417 */ "common_expression",
  /*  418 */ "when_then_expr",
  /*  419 */ "predicate",
  /*  420 */ "compare_op",
  /*  421 */ "in_op",
  /*  422 */ "in_predicate_value",
  /*  423 */ "boolean_value_expression",
  /*  424 */ "boolean_primary",
  /*  425 */ "from_clause_opt",
  /*  426 */ "table_reference_list",
  /*  427 */ "table_reference",
  /*  428 */ "table_primary",
  /*  429 */ "joined_table",
  /*  430 */ "alias_opt",
  /*  431 */ "subquery",
  /*  432 */ "parenthesized_joined_table",
  /*  433 */ "join_type",
  /*  434 */ "search_condition",
  /*  435 */ "query_specification",
  /*  436 */ "set_quantifier_opt",
  /*  437 */ "select_list",
  /*  438 */ "partition_by_clause_opt",
  /*  439 */ "range_opt",
  /*  440 */ "every_opt",
  /*  441 */ "fill_opt",
  /*  442 */ "twindow_clause_opt",
  /*  443 */ "group_by_clause_opt",
  /*  444 */ "having_clause_opt",
  /*  445 */ "select_item",
  /*  446 */ "partition_list",
  /*  447 */ "partition_item",
  /*  448 */ "fill_mode",
  /*  449 */ "group_by_list",
  /*  450 */ "query_expression",
  /*  451 */ "query_simple",
  /*  452 */ "order_by_clause_opt",
  /*  453 */ "slimit_clause_opt",
  /*  454 */ "limit_clause_opt",
  /*  455 */ "union_query_expression",
  /*  456 */ "query_simple_or_subquery",
  /*  457 */ "sort_specification_list",
  /*  458 */ "sort_specification",
  /*  459 */ "ordering_specification_opt",
  /*  460 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 261 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 262 */ "full_index_name ::= index_name",
 /* 263 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 266 */ "func_list ::= func",
 /* 267 */ "func_list ::= func_list NK_COMMA func",
 /* 268 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 269 */ "sma_stream_opt ::=",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 271 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 272 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 278 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 279 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 280 */ "cmd ::= DESC full_table_name",
 /* 281 */ "cmd ::= DESCRIBE full_table_name",
 /* 282 */ "cmd ::= RESET QUERY CACHE",
 /* 283 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 284 */ "analyze_opt ::=",
 /* 285 */ "analyze_opt ::= ANALYZE",
 /* 286 */ "explain_options ::=",
 /* 287 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 288 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 289 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 290 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 291 */ "agg_func_opt ::=",
 /* 292 */ "agg_func_opt ::= AGGREGATE",
 /* 293 */ "bufsize_opt ::=",
 /* 294 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 295 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 296 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 297 */ "stream_options ::=",
 /* 298 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 299 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 300 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 301 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 302 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 303 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 304 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 305 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 306 */ "subtable_opt ::=",
 /* 307 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 308 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 309 */ "cmd ::= KILL QUERY NK_STRING",
 /* 310 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 311 */ "cmd ::= BALANCE VGROUP",
 /* 312 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 313 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 314 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 315 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 316 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 317 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 318 */ "cmd ::= query_or_subquery",
 /* 319 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 320 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 321 */ "literal ::= NK_INTEGER",
 /* 322 */ "literal ::= NK_FLOAT",
 /* 323 */ "literal ::= NK_STRING",
 /* 324 */ "literal ::= NK_BOOL",
 /* 325 */ "literal ::= TIMESTAMP NK_STRING",
 /* 326 */ "literal ::= duration_literal",
 /* 327 */ "literal ::= NULL",
 /* 328 */ "literal ::= NK_QUESTION",
 /* 329 */ "duration_literal ::= NK_VARIABLE",
 /* 330 */ "signed ::= NK_INTEGER",
 /* 331 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 332 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 333 */ "signed ::= NK_FLOAT",
 /* 334 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 335 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 336 */ "signed_literal ::= signed",
 /* 337 */ "signed_literal ::= NK_STRING",
 /* 338 */ "signed_literal ::= NK_BOOL",
 /* 339 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 340 */ "signed_literal ::= duration_literal",
 /* 341 */ "signed_literal ::= NULL",
 /* 342 */ "signed_literal ::= literal_func",
 /* 343 */ "signed_literal ::= NK_QUESTION",
 /* 344 */ "literal_list ::= signed_literal",
 /* 345 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 346 */ "db_name ::= NK_ID",
 /* 347 */ "table_name ::= NK_ID",
 /* 348 */ "column_name ::= NK_ID",
 /* 349 */ "function_name ::= NK_ID",
 /* 350 */ "table_alias ::= NK_ID",
 /* 351 */ "column_alias ::= NK_ID",
 /* 352 */ "user_name ::= NK_ID",
 /* 353 */ "topic_name ::= NK_ID",
 /* 354 */ "stream_name ::= NK_ID",
 /* 355 */ "cgroup_name ::= NK_ID",
 /* 356 */ "index_name ::= NK_ID",
 /* 357 */ "expr_or_subquery ::= expression",
 /* 358 */ "expression ::= literal",
 /* 359 */ "expression ::= pseudo_column",
 /* 360 */ "expression ::= column_reference",
 /* 361 */ "expression ::= function_expression",
 /* 362 */ "expression ::= case_when_expression",
 /* 363 */ "expression ::= NK_LP expression NK_RP",
 /* 364 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 365 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 371 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 372 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 373 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 374 */ "expression_list ::= expr_or_subquery",
 /* 375 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 376 */ "column_reference ::= column_name",
 /* 377 */ "column_reference ::= table_name NK_DOT column_name",
 /* 378 */ "pseudo_column ::= ROWTS",
 /* 379 */ "pseudo_column ::= TBNAME",
 /* 380 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 381 */ "pseudo_column ::= QSTART",
 /* 382 */ "pseudo_column ::= QEND",
 /* 383 */ "pseudo_column ::= QDURATION",
 /* 384 */ "pseudo_column ::= WSTART",
 /* 385 */ "pseudo_column ::= WEND",
 /* 386 */ "pseudo_column ::= WDURATION",
 /* 387 */ "pseudo_column ::= IROWTS",
 /* 388 */ "pseudo_column ::= QTAGS",
 /* 389 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 390 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 391 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 392 */ "function_expression ::= literal_func",
 /* 393 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 394 */ "literal_func ::= NOW",
 /* 395 */ "noarg_func ::= NOW",
 /* 396 */ "noarg_func ::= TODAY",
 /* 397 */ "noarg_func ::= TIMEZONE",
 /* 398 */ "noarg_func ::= DATABASE",
 /* 399 */ "noarg_func ::= CLIENT_VERSION",
 /* 400 */ "noarg_func ::= SERVER_VERSION",
 /* 401 */ "noarg_func ::= SERVER_STATUS",
 /* 402 */ "noarg_func ::= CURRENT_USER",
 /* 403 */ "noarg_func ::= USER",
 /* 404 */ "star_func ::= COUNT",
 /* 405 */ "star_func ::= FIRST",
 /* 406 */ "star_func ::= LAST",
 /* 407 */ "star_func ::= LAST_ROW",
 /* 408 */ "star_func_para_list ::= NK_STAR",
 /* 409 */ "star_func_para_list ::= other_para_list",
 /* 410 */ "other_para_list ::= star_func_para",
 /* 411 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 412 */ "star_func_para ::= expr_or_subquery",
 /* 413 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 414 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 415 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 416 */ "when_then_list ::= when_then_expr",
 /* 417 */ "when_then_list ::= when_then_list when_then_expr",
 /* 418 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 419 */ "case_when_else_opt ::=",
 /* 420 */ "case_when_else_opt ::= ELSE common_expression",
 /* 421 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 422 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 423 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 424 */ "predicate ::= expr_or_subquery IS NULL",
 /* 425 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 426 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 427 */ "compare_op ::= NK_LT",
 /* 428 */ "compare_op ::= NK_GT",
 /* 429 */ "compare_op ::= NK_LE",
 /* 430 */ "compare_op ::= NK_GE",
 /* 431 */ "compare_op ::= NK_NE",
 /* 432 */ "compare_op ::= NK_EQ",
 /* 433 */ "compare_op ::= LIKE",
 /* 434 */ "compare_op ::= NOT LIKE",
 /* 435 */ "compare_op ::= MATCH",
 /* 436 */ "compare_op ::= NMATCH",
 /* 437 */ "compare_op ::= CONTAINS",
 /* 438 */ "in_op ::= IN",
 /* 439 */ "in_op ::= NOT IN",
 /* 440 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 441 */ "boolean_value_expression ::= boolean_primary",
 /* 442 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 443 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 444 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 445 */ "boolean_primary ::= predicate",
 /* 446 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 447 */ "common_expression ::= expr_or_subquery",
 /* 448 */ "common_expression ::= boolean_value_expression",
 /* 449 */ "from_clause_opt ::=",
 /* 450 */ "from_clause_opt ::= FROM table_reference_list",
 /* 451 */ "table_reference_list ::= table_reference",
 /* 452 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 453 */ "table_reference ::= table_primary",
 /* 454 */ "table_reference ::= joined_table",
 /* 455 */ "table_primary ::= table_name alias_opt",
 /* 456 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 457 */ "table_primary ::= subquery alias_opt",
 /* 458 */ "table_primary ::= parenthesized_joined_table",
 /* 459 */ "alias_opt ::=",
 /* 460 */ "alias_opt ::= table_alias",
 /* 461 */ "alias_opt ::= AS table_alias",
 /* 462 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 463 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 464 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 465 */ "join_type ::=",
 /* 466 */ "join_type ::= INNER",
 /* 467 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 468 */ "set_quantifier_opt ::=",
 /* 469 */ "set_quantifier_opt ::= DISTINCT",
 /* 470 */ "set_quantifier_opt ::= ALL",
 /* 471 */ "select_list ::= select_item",
 /* 472 */ "select_list ::= select_list NK_COMMA select_item",
 /* 473 */ "select_item ::= NK_STAR",
 /* 474 */ "select_item ::= common_expression",
 /* 475 */ "select_item ::= common_expression column_alias",
 /* 476 */ "select_item ::= common_expression AS column_alias",
 /* 477 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 478 */ "where_clause_opt ::=",
 /* 479 */ "where_clause_opt ::= WHERE search_condition",
 /* 480 */ "partition_by_clause_opt ::=",
 /* 481 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 482 */ "partition_list ::= partition_item",
 /* 483 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 484 */ "partition_item ::= expr_or_subquery",
 /* 485 */ "partition_item ::= expr_or_subquery column_alias",
 /* 486 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 487 */ "twindow_clause_opt ::=",
 /* 488 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 489 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 490 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 491 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 492 */ "sliding_opt ::=",
 /* 493 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 494 */ "fill_opt ::=",
 /* 495 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 496 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 497 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 498 */ "fill_mode ::= NONE",
 /* 499 */ "fill_mode ::= PREV",
 /* 500 */ "fill_mode ::= NULL",
 /* 501 */ "fill_mode ::= NULL_F",
 /* 502 */ "fill_mode ::= LINEAR",
 /* 503 */ "fill_mode ::= NEXT",
 /* 504 */ "group_by_clause_opt ::=",
 /* 505 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 506 */ "group_by_list ::= expr_or_subquery",
 /* 507 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 508 */ "having_clause_opt ::=",
 /* 509 */ "having_clause_opt ::= HAVING search_condition",
 /* 510 */ "range_opt ::=",
 /* 511 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 512 */ "every_opt ::=",
 /* 513 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 514 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 515 */ "query_simple ::= query_specification",
 /* 516 */ "query_simple ::= union_query_expression",
 /* 517 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 518 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 519 */ "query_simple_or_subquery ::= query_simple",
 /* 520 */ "query_simple_or_subquery ::= subquery",
 /* 521 */ "query_or_subquery ::= query_expression",
 /* 522 */ "query_or_subquery ::= subquery",
 /* 523 */ "order_by_clause_opt ::=",
 /* 524 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 525 */ "slimit_clause_opt ::=",
 /* 526 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 527 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 528 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 529 */ "limit_clause_opt ::=",
 /* 530 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 531 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 532 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 533 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 534 */ "subquery ::= NK_LP subquery NK_RP",
 /* 535 */ "search_condition ::= common_expression",
 /* 536 */ "sort_specification_list ::= sort_specification",
 /* 537 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 538 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 539 */ "ordering_specification_opt ::=",
 /* 540 */ "ordering_specification_opt ::= ASC",
 /* 541 */ "ordering_specification_opt ::= DESC",
 /* 542 */ "null_ordering_opt ::=",
 /* 543 */ "null_ordering_opt ::= NULLS FIRST",
 /* 544 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 324: /* cmd */
    case 327: /* literal */
    case 340: /* db_options */
    case 342: /* alter_db_options */
    case 348: /* retention */
    case 349: /* full_table_name */
    case 352: /* table_options */
    case 356: /* alter_table_clause */
    case 357: /* alter_table_options */
    case 360: /* signed_literal */
    case 361: /* create_subtable_clause */
    case 364: /* drop_table_clause */
    case 367: /* column_def */
    case 371: /* duration_literal */
    case 372: /* rollup_func_name */
    case 374: /* col_name */
    case 375: /* db_name_cond_opt */
    case 376: /* like_pattern_opt */
    case 377: /* table_name_cond */
    case 378: /* from_db_opt */
    case 380: /* tag_item */
    case 382: /* full_index_name */
    case 383: /* index_options */
    case 386: /* sliding_opt */
    case 387: /* sma_stream_opt */
    case 388: /* func */
    case 389: /* query_or_subquery */
    case 392: /* explain_options */
    case 396: /* stream_options */
    case 397: /* subtable_opt */
    case 398: /* expression */
    case 400: /* where_clause_opt */
    case 401: /* signed */
    case 402: /* literal_func */
    case 405: /* expr_or_subquery */
    case 406: /* pseudo_column */
    case 407: /* column_reference */
    case 408: /* function_expression */
    case 409: /* case_when_expression */
    case 414: /* star_func_para */
    case 416: /* case_when_else_opt */
    case 417: /* common_expression */
    case 418: /* when_then_expr */
    case 419: /* predicate */
    case 422: /* in_predicate_value */
    case 423: /* boolean_value_expression */
    case 424: /* boolean_primary */
    case 425: /* from_clause_opt */
    case 426: /* table_reference_list */
    case 427: /* table_reference */
    case 428: /* table_primary */
    case 429: /* joined_table */
    case 431: /* subquery */
    case 432: /* parenthesized_joined_table */
    case 434: /* search_condition */
    case 435: /* query_specification */
    case 439: /* range_opt */
    case 440: /* every_opt */
    case 441: /* fill_opt */
    case 442: /* twindow_clause_opt */
    case 444: /* having_clause_opt */
    case 445: /* select_item */
    case 447: /* partition_item */
    case 450: /* query_expression */
    case 451: /* query_simple */
    case 453: /* slimit_clause_opt */
    case 454: /* limit_clause_opt */
    case 455: /* union_query_expression */
    case 456: /* query_simple_or_subquery */
    case 458: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy600)); 
}
      break;
    case 325: /* account_options */
    case 326: /* alter_account_options */
    case 328: /* alter_account_option */
    case 343: /* speed_opt */
    case 394: /* bufsize_opt */
{
 
}
      break;
    case 329: /* user_name */
    case 332: /* priv_level */
    case 335: /* db_name */
    case 336: /* topic_name */
    case 337: /* dnode_endpoint */
    case 358: /* column_name */
    case 366: /* table_name */
    case 373: /* function_name */
    case 381: /* column_alias */
    case 384: /* index_name */
    case 390: /* cgroup_name */
    case 395: /* stream_name */
    case 404: /* table_alias */
    case 410: /* star_func */
    case 412: /* noarg_func */
    case 430: /* alias_opt */
{
 
}
      break;
    case 330: /* sysinfo_opt */
{
 
}
      break;
    case 331: /* privileges */
    case 333: /* priv_type_list */
    case 334: /* priv_type */
{
 
}
      break;
    case 338: /* force_opt */
    case 339: /* not_exists_opt */
    case 341: /* exists_opt */
    case 391: /* analyze_opt */
    case 393: /* agg_func_opt */
    case 436: /* set_quantifier_opt */
{
 
}
      break;
    case 344: /* integer_list */
    case 345: /* variable_list */
    case 346: /* retention_list */
    case 350: /* column_def_list */
    case 351: /* tags_def_opt */
    case 353: /* multi_create_clause */
    case 354: /* tags_def */
    case 355: /* multi_drop_clause */
    case 362: /* specific_cols_opt */
    case 363: /* expression_list */
    case 365: /* col_name_list */
    case 368: /* duration_list */
    case 369: /* rollup_func_list */
    case 379: /* tag_list_opt */
    case 385: /* func_list */
    case 399: /* dnode_list */
    case 403: /* literal_list */
    case 411: /* star_func_para_list */
    case 413: /* other_para_list */
    case 415: /* when_then_list */
    case 437: /* select_list */
    case 438: /* partition_by_clause_opt */
    case 443: /* group_by_clause_opt */
    case 446: /* partition_list */
    case 449: /* group_by_list */
    case 452: /* order_by_clause_opt */
    case 457: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy601)); 
}
      break;
    case 347: /* alter_db_option */
    case 370: /* alter_table_option */
{
 
}
      break;
    case 359: /* type_name */
{
 
}
      break;
    case 420: /* compare_op */
    case 421: /* in_op */
{
 
}
      break;
    case 433: /* join_type */
{
 
}
      break;
    case 448: /* fill_mode */
{
 
}
      break;
    case 459: /* ordering_specification_opt */
{
 
}
      break;
    case 460: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  324,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  324,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  325,    0 }, /* (2) account_options ::= */
  {  325,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  325,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  325,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  325,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  325,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  325,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  325,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  325,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  325,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  326,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  326,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  328,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  328,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  328,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  328,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  328,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  328,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  328,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  328,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  328,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  328,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  324,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  324,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  324,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  324,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  324,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  330,    0 }, /* (29) sysinfo_opt ::= */
  {  330,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  324,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  324,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  331,   -1 }, /* (33) privileges ::= ALL */
  {  331,   -1 }, /* (34) privileges ::= priv_type_list */
  {  331,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  333,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  333,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  334,   -1 }, /* (38) priv_type ::= READ */
  {  334,   -1 }, /* (39) priv_type ::= WRITE */
  {  332,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  332,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  332,   -1 }, /* (42) priv_level ::= topic_name */
  {  324,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  324,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  324,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  324,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  324,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  324,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  324,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  324,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  337,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  337,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  337,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  338,    0 }, /* (54) force_opt ::= */
  {  338,   -1 }, /* (55) force_opt ::= FORCE */
  {  324,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  324,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  324,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  324,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  324,   -2 }, /* (68) cmd ::= USE db_name */
  {  324,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  324,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  324,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  339,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  339,    0 }, /* (73) not_exists_opt ::= */
  {  341,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  341,    0 }, /* (75) exists_opt ::= */
  {  340,    0 }, /* (76) db_options ::= */
  {  340,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  340,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  340,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  340,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  340,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  340,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  340,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  340,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  340,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  340,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  340,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  340,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  340,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  340,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  340,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  340,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  340,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  340,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  340,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  340,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  340,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  340,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  340,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  340,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  342,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  342,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  347,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  347,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  347,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  347,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  347,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  347,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  347,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  347,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  347,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  347,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  344,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  344,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  345,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  345,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  346,   -1 }, /* (123) retention_list ::= retention */
  {  346,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  348,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  343,    0 }, /* (126) speed_opt ::= */
  {  343,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  324,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  324,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  324,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  324,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  324,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  324,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  324,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  356,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  356,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  356,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  356,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  356,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  356,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  356,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  356,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  356,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  356,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  353,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  353,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  361,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  355,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  355,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  364,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  362,    0 }, /* (151) specific_cols_opt ::= */
  {  362,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  349,   -1 }, /* (153) full_table_name ::= table_name */
  {  349,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  350,   -1 }, /* (155) column_def_list ::= column_def */
  {  350,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  367,   -2 }, /* (157) column_def ::= column_name type_name */
  {  367,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  359,   -1 }, /* (159) type_name ::= BOOL */
  {  359,   -1 }, /* (160) type_name ::= TINYINT */
  {  359,   -1 }, /* (161) type_name ::= SMALLINT */
  {  359,   -1 }, /* (162) type_name ::= INT */
  {  359,   -1 }, /* (163) type_name ::= INTEGER */
  {  359,   -1 }, /* (164) type_name ::= BIGINT */
  {  359,   -1 }, /* (165) type_name ::= FLOAT */
  {  359,   -1 }, /* (166) type_name ::= DOUBLE */
  {  359,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  359,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  359,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  359,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  359,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  359,   -1 }, /* (174) type_name ::= JSON */
  {  359,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  359,   -1 }, /* (177) type_name ::= BLOB */
  {  359,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (179) type_name ::= DECIMAL */
  {  359,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  359,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  351,    0 }, /* (182) tags_def_opt ::= */
  {  351,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  354,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  352,    0 }, /* (185) table_options ::= */
  {  352,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  352,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  352,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  352,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  352,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  352,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  352,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  357,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  357,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  370,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  370,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  368,   -1 }, /* (197) duration_list ::= duration_literal */
  {  368,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  369,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  369,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  372,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  372,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  372,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  365,   -1 }, /* (204) col_name_list ::= col_name */
  {  365,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  374,   -1 }, /* (206) col_name ::= column_name */
  {  324,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  324,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  324,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  324,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  324,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  324,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  324,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  324,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  324,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  324,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  324,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  324,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  324,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  324,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  324,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  324,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  324,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  324,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  324,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  324,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  324,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  324,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  324,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  324,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  324,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  324,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  324,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  324,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  324,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  324,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  324,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  324,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  324,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  324,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  324,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  324,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  324,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  324,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  375,    0 }, /* (245) db_name_cond_opt ::= */
  {  375,   -2 }, /* (246) db_name_cond_opt ::= db_name NK_DOT */
  {  376,    0 }, /* (247) like_pattern_opt ::= */
  {  376,   -2 }, /* (248) like_pattern_opt ::= LIKE NK_STRING */
  {  377,   -1 }, /* (249) table_name_cond ::= table_name */
  {  378,    0 }, /* (250) from_db_opt ::= */
  {  378,   -2 }, /* (251) from_db_opt ::= FROM db_name */
  {  379,    0 }, /* (252) tag_list_opt ::= */
  {  379,   -1 }, /* (253) tag_list_opt ::= tag_item */
  {  379,   -3 }, /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  380,   -1 }, /* (255) tag_item ::= TBNAME */
  {  380,   -1 }, /* (256) tag_item ::= QTAGS */
  {  380,   -1 }, /* (257) tag_item ::= column_name */
  {  380,   -2 }, /* (258) tag_item ::= column_name column_alias */
  {  380,   -3 }, /* (259) tag_item ::= column_name AS column_alias */
  {  324,   -8 }, /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  324,   -4 }, /* (261) cmd ::= DROP INDEX exists_opt full_index_name */
  {  382,   -1 }, /* (262) full_index_name ::= index_name */
  {  382,   -3 }, /* (263) full_index_name ::= db_name NK_DOT index_name */
  {  383,  -10 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,  -12 }, /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  385,   -1 }, /* (266) func_list ::= func */
  {  385,   -3 }, /* (267) func_list ::= func_list NK_COMMA func */
  {  388,   -4 }, /* (268) func ::= function_name NK_LP expression_list NK_RP */
  {  387,    0 }, /* (269) sma_stream_opt ::= */
  {  387,   -3 }, /* (270) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  387,   -3 }, /* (271) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  387,   -3 }, /* (272) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  324,   -6 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  324,   -7 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  324,   -9 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  324,   -7 }, /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  324,   -9 }, /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  324,   -4 }, /* (278) cmd ::= DROP TOPIC exists_opt topic_name */
  {  324,   -7 }, /* (279) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  324,   -2 }, /* (280) cmd ::= DESC full_table_name */
  {  324,   -2 }, /* (281) cmd ::= DESCRIBE full_table_name */
  {  324,   -3 }, /* (282) cmd ::= RESET QUERY CACHE */
  {  324,   -4 }, /* (283) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  391,    0 }, /* (284) analyze_opt ::= */
  {  391,   -1 }, /* (285) analyze_opt ::= ANALYZE */
  {  392,    0 }, /* (286) explain_options ::= */
  {  392,   -3 }, /* (287) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  392,   -3 }, /* (288) explain_options ::= explain_options RATIO NK_FLOAT */
  {  324,  -10 }, /* (289) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  324,   -4 }, /* (290) cmd ::= DROP FUNCTION exists_opt function_name */
  {  393,    0 }, /* (291) agg_func_opt ::= */
  {  393,   -1 }, /* (292) agg_func_opt ::= AGGREGATE */
  {  394,    0 }, /* (293) bufsize_opt ::= */
  {  394,   -2 }, /* (294) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  324,  -11 }, /* (295) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  324,   -4 }, /* (296) cmd ::= DROP STREAM exists_opt stream_name */
  {  396,    0 }, /* (297) stream_options ::= */
  {  396,   -3 }, /* (298) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  396,   -3 }, /* (299) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  396,   -4 }, /* (300) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  396,   -3 }, /* (301) stream_options ::= stream_options WATERMARK duration_literal */
  {  396,   -4 }, /* (302) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  396,   -3 }, /* (303) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  396,   -3 }, /* (304) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  396,   -4 }, /* (305) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  397,    0 }, /* (306) subtable_opt ::= */
  {  397,   -4 }, /* (307) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  324,   -3 }, /* (308) cmd ::= KILL CONNECTION NK_INTEGER */
  {  324,   -3 }, /* (309) cmd ::= KILL QUERY NK_STRING */
  {  324,   -3 }, /* (310) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  324,   -2 }, /* (311) cmd ::= BALANCE VGROUP */
  {  324,   -4 }, /* (312) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  324,   -4 }, /* (313) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  324,   -3 }, /* (314) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  399,   -2 }, /* (315) dnode_list ::= DNODE NK_INTEGER */
  {  399,   -3 }, /* (316) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  324,   -4 }, /* (317) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  324,   -1 }, /* (318) cmd ::= query_or_subquery */
  {  324,   -7 }, /* (319) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  324,   -4 }, /* (320) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  327,   -1 }, /* (321) literal ::= NK_INTEGER */
  {  327,   -1 }, /* (322) literal ::= NK_FLOAT */
  {  327,   -1 }, /* (323) literal ::= NK_STRING */
  {  327,   -1 }, /* (324) literal ::= NK_BOOL */
  {  327,   -2 }, /* (325) literal ::= TIMESTAMP NK_STRING */
  {  327,   -1 }, /* (326) literal ::= duration_literal */
  {  327,   -1 }, /* (327) literal ::= NULL */
  {  327,   -1 }, /* (328) literal ::= NK_QUESTION */
  {  371,   -1 }, /* (329) duration_literal ::= NK_VARIABLE */
  {  401,   -1 }, /* (330) signed ::= NK_INTEGER */
  {  401,   -2 }, /* (331) signed ::= NK_PLUS NK_INTEGER */
  {  401,   -2 }, /* (332) signed ::= NK_MINUS NK_INTEGER */
  {  401,   -1 }, /* (333) signed ::= NK_FLOAT */
  {  401,   -2 }, /* (334) signed ::= NK_PLUS NK_FLOAT */
  {  401,   -2 }, /* (335) signed ::= NK_MINUS NK_FLOAT */
  {  360,   -1 }, /* (336) signed_literal ::= signed */
  {  360,   -1 }, /* (337) signed_literal ::= NK_STRING */
  {  360,   -1 }, /* (338) signed_literal ::= NK_BOOL */
  {  360,   -2 }, /* (339) signed_literal ::= TIMESTAMP NK_STRING */
  {  360,   -1 }, /* (340) signed_literal ::= duration_literal */
  {  360,   -1 }, /* (341) signed_literal ::= NULL */
  {  360,   -1 }, /* (342) signed_literal ::= literal_func */
  {  360,   -1 }, /* (343) signed_literal ::= NK_QUESTION */
  {  403,   -1 }, /* (344) literal_list ::= signed_literal */
  {  403,   -3 }, /* (345) literal_list ::= literal_list NK_COMMA signed_literal */
  {  335,   -1 }, /* (346) db_name ::= NK_ID */
  {  366,   -1 }, /* (347) table_name ::= NK_ID */
  {  358,   -1 }, /* (348) column_name ::= NK_ID */
  {  373,   -1 }, /* (349) function_name ::= NK_ID */
  {  404,   -1 }, /* (350) table_alias ::= NK_ID */
  {  381,   -1 }, /* (351) column_alias ::= NK_ID */
  {  329,   -1 }, /* (352) user_name ::= NK_ID */
  {  336,   -1 }, /* (353) topic_name ::= NK_ID */
  {  395,   -1 }, /* (354) stream_name ::= NK_ID */
  {  390,   -1 }, /* (355) cgroup_name ::= NK_ID */
  {  384,   -1 }, /* (356) index_name ::= NK_ID */
  {  405,   -1 }, /* (357) expr_or_subquery ::= expression */
  {  398,   -1 }, /* (358) expression ::= literal */
  {  398,   -1 }, /* (359) expression ::= pseudo_column */
  {  398,   -1 }, /* (360) expression ::= column_reference */
  {  398,   -1 }, /* (361) expression ::= function_expression */
  {  398,   -1 }, /* (362) expression ::= case_when_expression */
  {  398,   -3 }, /* (363) expression ::= NK_LP expression NK_RP */
  {  398,   -2 }, /* (364) expression ::= NK_PLUS expr_or_subquery */
  {  398,   -2 }, /* (365) expression ::= NK_MINUS expr_or_subquery */
  {  398,   -3 }, /* (366) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  398,   -3 }, /* (367) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  398,   -3 }, /* (368) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  398,   -3 }, /* (369) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  398,   -3 }, /* (370) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  398,   -3 }, /* (371) expression ::= column_reference NK_ARROW NK_STRING */
  {  398,   -3 }, /* (372) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  398,   -3 }, /* (373) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  363,   -1 }, /* (374) expression_list ::= expr_or_subquery */
  {  363,   -3 }, /* (375) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  407,   -1 }, /* (376) column_reference ::= column_name */
  {  407,   -3 }, /* (377) column_reference ::= table_name NK_DOT column_name */
  {  406,   -1 }, /* (378) pseudo_column ::= ROWTS */
  {  406,   -1 }, /* (379) pseudo_column ::= TBNAME */
  {  406,   -3 }, /* (380) pseudo_column ::= table_name NK_DOT TBNAME */
  {  406,   -1 }, /* (381) pseudo_column ::= QSTART */
  {  406,   -1 }, /* (382) pseudo_column ::= QEND */
  {  406,   -1 }, /* (383) pseudo_column ::= QDURATION */
  {  406,   -1 }, /* (384) pseudo_column ::= WSTART */
  {  406,   -1 }, /* (385) pseudo_column ::= WEND */
  {  406,   -1 }, /* (386) pseudo_column ::= WDURATION */
  {  406,   -1 }, /* (387) pseudo_column ::= IROWTS */
  {  406,   -1 }, /* (388) pseudo_column ::= QTAGS */
  {  408,   -4 }, /* (389) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  408,   -4 }, /* (390) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  408,   -6 }, /* (391) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  408,   -1 }, /* (392) function_expression ::= literal_func */
  {  402,   -3 }, /* (393) literal_func ::= noarg_func NK_LP NK_RP */
  {  402,   -1 }, /* (394) literal_func ::= NOW */
  {  412,   -1 }, /* (395) noarg_func ::= NOW */
  {  412,   -1 }, /* (396) noarg_func ::= TODAY */
  {  412,   -1 }, /* (397) noarg_func ::= TIMEZONE */
  {  412,   -1 }, /* (398) noarg_func ::= DATABASE */
  {  412,   -1 }, /* (399) noarg_func ::= CLIENT_VERSION */
  {  412,   -1 }, /* (400) noarg_func ::= SERVER_VERSION */
  {  412,   -1 }, /* (401) noarg_func ::= SERVER_STATUS */
  {  412,   -1 }, /* (402) noarg_func ::= CURRENT_USER */
  {  412,   -1 }, /* (403) noarg_func ::= USER */
  {  410,   -1 }, /* (404) star_func ::= COUNT */
  {  410,   -1 }, /* (405) star_func ::= FIRST */
  {  410,   -1 }, /* (406) star_func ::= LAST */
  {  410,   -1 }, /* (407) star_func ::= LAST_ROW */
  {  411,   -1 }, /* (408) star_func_para_list ::= NK_STAR */
  {  411,   -1 }, /* (409) star_func_para_list ::= other_para_list */
  {  413,   -1 }, /* (410) other_para_list ::= star_func_para */
  {  413,   -3 }, /* (411) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  414,   -1 }, /* (412) star_func_para ::= expr_or_subquery */
  {  414,   -3 }, /* (413) star_func_para ::= table_name NK_DOT NK_STAR */
  {  409,   -4 }, /* (414) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  409,   -5 }, /* (415) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  415,   -1 }, /* (416) when_then_list ::= when_then_expr */
  {  415,   -2 }, /* (417) when_then_list ::= when_then_list when_then_expr */
  {  418,   -4 }, /* (418) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  416,    0 }, /* (419) case_when_else_opt ::= */
  {  416,   -2 }, /* (420) case_when_else_opt ::= ELSE common_expression */
  {  419,   -3 }, /* (421) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  419,   -5 }, /* (422) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  419,   -6 }, /* (423) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  419,   -3 }, /* (424) predicate ::= expr_or_subquery IS NULL */
  {  419,   -4 }, /* (425) predicate ::= expr_or_subquery IS NOT NULL */
  {  419,   -3 }, /* (426) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  420,   -1 }, /* (427) compare_op ::= NK_LT */
  {  420,   -1 }, /* (428) compare_op ::= NK_GT */
  {  420,   -1 }, /* (429) compare_op ::= NK_LE */
  {  420,   -1 }, /* (430) compare_op ::= NK_GE */
  {  420,   -1 }, /* (431) compare_op ::= NK_NE */
  {  420,   -1 }, /* (432) compare_op ::= NK_EQ */
  {  420,   -1 }, /* (433) compare_op ::= LIKE */
  {  420,   -2 }, /* (434) compare_op ::= NOT LIKE */
  {  420,   -1 }, /* (435) compare_op ::= MATCH */
  {  420,   -1 }, /* (436) compare_op ::= NMATCH */
  {  420,   -1 }, /* (437) compare_op ::= CONTAINS */
  {  421,   -1 }, /* (438) in_op ::= IN */
  {  421,   -2 }, /* (439) in_op ::= NOT IN */
  {  422,   -3 }, /* (440) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  423,   -1 }, /* (441) boolean_value_expression ::= boolean_primary */
  {  423,   -2 }, /* (442) boolean_value_expression ::= NOT boolean_primary */
  {  423,   -3 }, /* (443) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  423,   -3 }, /* (444) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  424,   -1 }, /* (445) boolean_primary ::= predicate */
  {  424,   -3 }, /* (446) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  417,   -1 }, /* (447) common_expression ::= expr_or_subquery */
  {  417,   -1 }, /* (448) common_expression ::= boolean_value_expression */
  {  425,    0 }, /* (449) from_clause_opt ::= */
  {  425,   -2 }, /* (450) from_clause_opt ::= FROM table_reference_list */
  {  426,   -1 }, /* (451) table_reference_list ::= table_reference */
  {  426,   -3 }, /* (452) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  427,   -1 }, /* (453) table_reference ::= table_primary */
  {  427,   -1 }, /* (454) table_reference ::= joined_table */
  {  428,   -2 }, /* (455) table_primary ::= table_name alias_opt */
  {  428,   -4 }, /* (456) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  428,   -2 }, /* (457) table_primary ::= subquery alias_opt */
  {  428,   -1 }, /* (458) table_primary ::= parenthesized_joined_table */
  {  430,    0 }, /* (459) alias_opt ::= */
  {  430,   -1 }, /* (460) alias_opt ::= table_alias */
  {  430,   -2 }, /* (461) alias_opt ::= AS table_alias */
  {  432,   -3 }, /* (462) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  432,   -3 }, /* (463) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  429,   -6 }, /* (464) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  433,    0 }, /* (465) join_type ::= */
  {  433,   -1 }, /* (466) join_type ::= INNER */
  {  435,  -12 }, /* (467) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  436,    0 }, /* (468) set_quantifier_opt ::= */
  {  436,   -1 }, /* (469) set_quantifier_opt ::= DISTINCT */
  {  436,   -1 }, /* (470) set_quantifier_opt ::= ALL */
  {  437,   -1 }, /* (471) select_list ::= select_item */
  {  437,   -3 }, /* (472) select_list ::= select_list NK_COMMA select_item */
  {  445,   -1 }, /* (473) select_item ::= NK_STAR */
  {  445,   -1 }, /* (474) select_item ::= common_expression */
  {  445,   -2 }, /* (475) select_item ::= common_expression column_alias */
  {  445,   -3 }, /* (476) select_item ::= common_expression AS column_alias */
  {  445,   -3 }, /* (477) select_item ::= table_name NK_DOT NK_STAR */
  {  400,    0 }, /* (478) where_clause_opt ::= */
  {  400,   -2 }, /* (479) where_clause_opt ::= WHERE search_condition */
  {  438,    0 }, /* (480) partition_by_clause_opt ::= */
  {  438,   -3 }, /* (481) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  446,   -1 }, /* (482) partition_list ::= partition_item */
  {  446,   -3 }, /* (483) partition_list ::= partition_list NK_COMMA partition_item */
  {  447,   -1 }, /* (484) partition_item ::= expr_or_subquery */
  {  447,   -2 }, /* (485) partition_item ::= expr_or_subquery column_alias */
  {  447,   -3 }, /* (486) partition_item ::= expr_or_subquery AS column_alias */
  {  442,    0 }, /* (487) twindow_clause_opt ::= */
  {  442,   -6 }, /* (488) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  442,   -4 }, /* (489) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  442,   -6 }, /* (490) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  442,   -8 }, /* (491) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  386,    0 }, /* (492) sliding_opt ::= */
  {  386,   -4 }, /* (493) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  441,    0 }, /* (494) fill_opt ::= */
  {  441,   -4 }, /* (495) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  441,   -6 }, /* (496) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  441,   -6 }, /* (497) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  448,   -1 }, /* (498) fill_mode ::= NONE */
  {  448,   -1 }, /* (499) fill_mode ::= PREV */
  {  448,   -1 }, /* (500) fill_mode ::= NULL */
  {  448,   -1 }, /* (501) fill_mode ::= NULL_F */
  {  448,   -1 }, /* (502) fill_mode ::= LINEAR */
  {  448,   -1 }, /* (503) fill_mode ::= NEXT */
  {  443,    0 }, /* (504) group_by_clause_opt ::= */
  {  443,   -3 }, /* (505) group_by_clause_opt ::= GROUP BY group_by_list */
  {  449,   -1 }, /* (506) group_by_list ::= expr_or_subquery */
  {  449,   -3 }, /* (507) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  444,    0 }, /* (508) having_clause_opt ::= */
  {  444,   -2 }, /* (509) having_clause_opt ::= HAVING search_condition */
  {  439,    0 }, /* (510) range_opt ::= */
  {  439,   -6 }, /* (511) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  440,    0 }, /* (512) every_opt ::= */
  {  440,   -4 }, /* (513) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  450,   -4 }, /* (514) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  451,   -1 }, /* (515) query_simple ::= query_specification */
  {  451,   -1 }, /* (516) query_simple ::= union_query_expression */
  {  455,   -4 }, /* (517) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  455,   -3 }, /* (518) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  456,   -1 }, /* (519) query_simple_or_subquery ::= query_simple */
  {  456,   -1 }, /* (520) query_simple_or_subquery ::= subquery */
  {  389,   -1 }, /* (521) query_or_subquery ::= query_expression */
  {  389,   -1 }, /* (522) query_or_subquery ::= subquery */
  {  452,    0 }, /* (523) order_by_clause_opt ::= */
  {  452,   -3 }, /* (524) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  453,    0 }, /* (525) slimit_clause_opt ::= */
  {  453,   -2 }, /* (526) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  453,   -4 }, /* (527) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  453,   -4 }, /* (528) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  454,    0 }, /* (529) limit_clause_opt ::= */
  {  454,   -2 }, /* (530) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  454,   -4 }, /* (531) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  454,   -4 }, /* (532) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  431,   -3 }, /* (533) subquery ::= NK_LP query_expression NK_RP */
  {  431,   -3 }, /* (534) subquery ::= NK_LP subquery NK_RP */
  {  434,   -1 }, /* (535) search_condition ::= common_expression */
  {  457,   -1 }, /* (536) sort_specification_list ::= sort_specification */
  {  457,   -3 }, /* (537) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  458,   -3 }, /* (538) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  459,    0 }, /* (539) ordering_specification_opt ::= */
  {  459,   -1 }, /* (540) ordering_specification_opt ::= ASC */
  {  459,   -1 }, /* (541) ordering_specification_opt ::= DESC */
  {  460,    0 }, /* (542) null_ordering_opt ::= */
  {  460,   -2 }, /* (543) null_ordering_opt ::= NULLS FIRST */
  {  460,   -2 }, /* (544) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,325,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy0, yymsp[0].minor.yy287); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy287 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy287 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy717 = yymsp[0].minor.yy717; }
  yymsp[0].minor.yy717 = yylhsminor.yy717;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy717 = yymsp[-2].minor.yy717 | yymsp[0].minor.yy717; }
  yymsp[-2].minor.yy717 = yylhsminor.yy717;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy77; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 42: /* priv_level ::= topic_name */
      case 460: /* alias_opt ::= table_alias */ yytestcase(yyruleno==460);
{ yylhsminor.yy77 = yymsp[0].minor.yy77; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy77, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy841); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy841); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 346: /* db_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* table_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* column_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* function_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* table_alias ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* column_alias ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* user_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* topic_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* stream_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* index_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 395: /* noarg_func ::= NOW */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= TODAY */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= USER */ yytestcase(yyruleno==403);
      case 404: /* star_func ::= COUNT */ yytestcase(yyruleno==404);
      case 405: /* star_func ::= FIRST */ yytestcase(yyruleno==405);
      case 406: /* star_func ::= LAST */ yytestcase(yyruleno==406);
      case 407: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==407);
{ yylhsminor.yy77 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 284: /* analyze_opt ::= */ yytestcase(yyruleno==284);
      case 291: /* agg_func_opt ::= */ yytestcase(yyruleno==291);
      case 468: /* set_quantifier_opt ::= */ yytestcase(yyruleno==468);
{ yymsp[1].minor.yy841 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 285: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==285);
      case 292: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==292);
      case 469: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==469);
{ yymsp[0].minor.yy841 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy841, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy248); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy841 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy841 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy600 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_KEEP, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_RETENTIONS, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy600 = createAlterDatabaseOptions(pCxt); yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yylhsminor.yy600, &yymsp[0].minor.yy661); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy600, &yymsp[0].minor.yy661); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy661.type = DB_OPTION_KEEP; yymsp[-1].minor.yy661.pList = yymsp[0].minor.yy601; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_PAGES; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_WAL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 316: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==316);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy601 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 266: /* func_list ::= func */ yytestcase(yyruleno==266);
      case 344: /* literal_list ::= signed_literal */ yytestcase(yyruleno==344);
      case 410: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==410);
      case 416: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==416);
      case 471: /* select_list ::= select_item */ yytestcase(yyruleno==471);
      case 482: /* partition_list ::= partition_item */ yytestcase(yyruleno==482);
      case 536: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==536);
{ yylhsminor.yy601 = createNodeList(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 267: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==267);
      case 345: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==345);
      case 411: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==411);
      case 472: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==472);
      case 483: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==483);
      case 537: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==537);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy600 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 126: /* speed_opt ::= */
      case 293: /* bufsize_opt ::= */ yytestcase(yyruleno==293);
{ yymsp[1].minor.yy248 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 294: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==294);
{ yymsp[-1].minor.yy248 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-5].minor.yy600, yymsp[-3].minor.yy601, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 318: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==318);
{ pCxt->pRootNode = yymsp[0].minor.yy600; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy600); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy600 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy600 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy600, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 417: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==417);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy601 = yylhsminor.yy601;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy600 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy841, yymsp[-8].minor.yy600, yymsp[-6].minor.yy600, yymsp[-5].minor.yy601, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-9].minor.yy600 = yylhsminor.yy600;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy600 = createDropTableClause(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 480: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==480);
      case 504: /* group_by_clause_opt ::= */ yytestcase(yyruleno==504);
      case 523: /* order_by_clause_opt ::= */ yytestcase(yyruleno==523);
{ yymsp[1].minor.yy601 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888, NULL); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-2].minor.yy888, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 409: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==409);
{ yylhsminor.yy601 = yymsp[0].minor.yy601; }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy600 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_SMA, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy600 = createAlterTableOptions(pCxt); yylhsminor.yy600 = setTableOption(pCxt, yylhsminor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 374: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==374);
{ yylhsminor.yy601 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 375: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==375);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy600, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy600); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600, yymsp[-3].minor.yy601); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy600 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 247: /* like_pattern_opt ::= */
      case 306: /* subtable_opt ::= */ yytestcase(yyruleno==306);
      case 419: /* case_when_else_opt ::= */ yytestcase(yyruleno==419);
      case 449: /* from_clause_opt ::= */ yytestcase(yyruleno==449);
      case 478: /* where_clause_opt ::= */ yytestcase(yyruleno==478);
      case 487: /* twindow_clause_opt ::= */ yytestcase(yyruleno==487);
      case 492: /* sliding_opt ::= */ yytestcase(yyruleno==492);
      case 494: /* fill_opt ::= */ yytestcase(yyruleno==494);
      case 508: /* having_clause_opt ::= */ yytestcase(yyruleno==508);
      case 510: /* range_opt ::= */ yytestcase(yyruleno==510);
      case 512: /* every_opt ::= */ yytestcase(yyruleno==512);
      case 525: /* slimit_clause_opt ::= */ yytestcase(yyruleno==525);
      case 529: /* limit_clause_opt ::= */ yytestcase(yyruleno==529);
{ yymsp[1].minor.yy600 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy841, yymsp[-3].minor.yy600, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 261: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 262: /* full_index_name ::= index_name */
{ yylhsminor.yy600 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 263: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy600 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy600 = createIndexOption(pCxt, yymsp[-7].minor.yy601, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 265: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy600 = createIndexOption(pCxt, yymsp[-9].minor.yy601, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 268: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 269: /* sma_stream_opt ::= */
      case 297: /* stream_options ::= */ yytestcase(yyruleno==297);
{ yymsp[1].minor.yy600 = createStreamOptions(pCxt); }
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 301: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==301);
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 271: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 272: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
      case 304: /* stream_options ::= stream_options DELETE_MARK duration_literal */ yytestcase(yyruleno==304);
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy77, false); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[0].minor.yy77, true); }
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, yymsp[0].minor.yy600, false); }
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, yymsp[0].minor.yy600, true); }
        break;
      case 278: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 279: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 280: /* cmd ::= DESC full_table_name */
      case 281: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==281);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 282: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 283: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy841, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 286: /* explain_options ::= */
{ yymsp[1].minor.yy600 = createDefaultExplainOptions(pCxt); }
        break;
      case 287: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy600 = setExplainVerbose(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 288: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy600 = setExplainRatio(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 289: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-8].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy888, yymsp[0].minor.yy248); }
        break;
      case 290: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 295: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy841, &yymsp[-7].minor.yy77, yymsp[-4].minor.yy600, yymsp[-6].minor.yy600, yymsp[-3].minor.yy601, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 296: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 298: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 299: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 300: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 302: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 303: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 305: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->ignoreUpdate = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 307: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 493: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==493);
      case 513: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==513);
{ yymsp[-3].minor.yy600 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy600); }
        break;
      case 308: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 309: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 310: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 312: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 313: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy601); }
        break;
      case 314: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 315: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 317: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 319: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy600, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 320: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 321: /* literal ::= NK_INTEGER */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 322: /* literal ::= NK_FLOAT */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 323: /* literal ::= NK_STRING */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 324: /* literal ::= NK_BOOL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 325: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 326: /* literal ::= duration_literal */
      case 336: /* signed_literal ::= signed */ yytestcase(yyruleno==336);
      case 357: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==357);
      case 358: /* expression ::= literal */ yytestcase(yyruleno==358);
      case 359: /* expression ::= pseudo_column */ yytestcase(yyruleno==359);
      case 360: /* expression ::= column_reference */ yytestcase(yyruleno==360);
      case 361: /* expression ::= function_expression */ yytestcase(yyruleno==361);
      case 362: /* expression ::= case_when_expression */ yytestcase(yyruleno==362);
      case 392: /* function_expression ::= literal_func */ yytestcase(yyruleno==392);
      case 441: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==441);
      case 445: /* boolean_primary ::= predicate */ yytestcase(yyruleno==445);
      case 447: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==447);
      case 448: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==448);
      case 451: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==451);
      case 453: /* table_reference ::= table_primary */ yytestcase(yyruleno==453);
      case 454: /* table_reference ::= joined_table */ yytestcase(yyruleno==454);
      case 458: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==458);
      case 515: /* query_simple ::= query_specification */ yytestcase(yyruleno==515);
      case 516: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==516);
      case 519: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==519);
      case 521: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==521);
{ yylhsminor.yy600 = yymsp[0].minor.yy600; }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 327: /* literal ::= NULL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 328: /* literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 329: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 330: /* signed ::= NK_INTEGER */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 331: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 332: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 333: /* signed ::= NK_FLOAT */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 334: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 335: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 337: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 338: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 339: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 340: /* signed_literal ::= duration_literal */
      case 342: /* signed_literal ::= literal_func */ yytestcase(yyruleno==342);
      case 412: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==412);
      case 474: /* select_item ::= common_expression */ yytestcase(yyruleno==474);
      case 484: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==484);
      case 520: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==520);
      case 522: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==522);
      case 535: /* search_condition ::= common_expression */ yytestcase(yyruleno==535);
{ yylhsminor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 341: /* signed_literal ::= NULL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 343: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 363: /* expression ::= NK_LP expression NK_RP */
      case 446: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==446);
      case 534: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==534);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 364: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy600));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 365: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 366: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 367: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 368: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 369: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 370: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 371: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 372: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 373: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 376: /* column_reference ::= column_name */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy77, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 377: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 378: /* pseudo_column ::= ROWTS */
      case 379: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==379);
      case 381: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= QEND */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= WEND */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==388);
      case 394: /* literal_func ::= NOW */ yytestcase(yyruleno==394);
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 380: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy77)))); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 389: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 390: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==390);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 391: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy888)); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 393: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy77, NULL)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 408: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy601 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 413: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 477: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==477);
{ yylhsminor.yy600 = createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 414: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 415: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 418: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy600 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
        break;
      case 420: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
        break;
      case 421: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 426: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==426);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy666, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 422: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 423: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 424: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), NULL));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 425: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL));
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 427: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_THAN; }
        break;
      case 428: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_THAN; }
        break;
      case 429: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 430: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 431: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy666 = OP_TYPE_NOT_EQUAL; }
        break;
      case 432: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy666 = OP_TYPE_EQUAL; }
        break;
      case 433: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy666 = OP_TYPE_LIKE; }
        break;
      case 434: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_LIKE; }
        break;
      case 435: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_MATCH; }
        break;
      case 436: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_NMATCH; }
        break;
      case 437: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy666 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 438: /* in_op ::= IN */
{ yymsp[0].minor.yy666 = OP_TYPE_IN; }
        break;
      case 439: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_IN; }
        break;
      case 440: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 442: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 443: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 444: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 450: /* from_clause_opt ::= FROM table_reference_list */
      case 479: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==479);
      case 509: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==509);
{ yymsp[-1].minor.yy600 = yymsp[0].minor.yy600; }
        break;
      case 452: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 455: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 456: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 457: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy600 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 459: /* alias_opt ::= */
{ yymsp[1].minor.yy77 = nil_token;  }
        break;
      case 461: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy77 = yymsp[0].minor.yy77; }
        break;
      case 462: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 463: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==463);
{ yymsp[-2].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 464: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, yymsp[-4].minor.yy560, yymsp[-5].minor.yy600, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 465: /* join_type ::= */
{ yymsp[1].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 466: /* join_type ::= INNER */
{ yymsp[0].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 467: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy600 = createSelectStmt(pCxt, yymsp[-10].minor.yy841, yymsp[-9].minor.yy601, yymsp[-8].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addWhereClause(pCxt, yymsp[-11].minor.yy600, yymsp[-7].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addPartitionByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-6].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy600, yymsp[-2].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addGroupByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-1].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addHavingClause(pCxt, yymsp[-11].minor.yy600, yymsp[0].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addRangeClause(pCxt, yymsp[-11].minor.yy600, yymsp[-5].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addEveryClause(pCxt, yymsp[-11].minor.yy600, yymsp[-4].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addFillClause(pCxt, yymsp[-11].minor.yy600, yymsp[-3].minor.yy600);
                                                                                  }
        break;
      case 470: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy841 = false; }
        break;
      case 473: /* select_item ::= NK_STAR */
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 475: /* select_item ::= common_expression column_alias */
      case 485: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==485);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 476: /* select_item ::= common_expression AS column_alias */
      case 486: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==486);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 481: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 505: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==505);
      case 524: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==524);
{ yymsp[-2].minor.yy601 = yymsp[0].minor.yy601; }
        break;
      case 488: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy600 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 489: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy600 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 490: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 491: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 495: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy600 = createFillNode(pCxt, yymsp[-1].minor.yy798, NULL); }
        break;
      case 496: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy600 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
        break;
      case 497: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy600 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
        break;
      case 498: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy798 = FILL_MODE_NONE; }
        break;
      case 499: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy798 = FILL_MODE_PREV; }
        break;
      case 500: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy798 = FILL_MODE_NULL; }
        break;
      case 501: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy798 = FILL_MODE_NULL_F; }
        break;
      case 502: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy798 = FILL_MODE_LINEAR; }
        break;
      case 503: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy798 = FILL_MODE_NEXT; }
        break;
      case 506: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy601 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 507: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 511: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy600 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 514: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy600 = addOrderByClause(pCxt, yymsp[-3].minor.yy600, yymsp[-2].minor.yy601);
                                                                                    yylhsminor.yy600 = addSlimitClause(pCxt, yylhsminor.yy600, yymsp[-1].minor.yy600);
                                                                                    yylhsminor.yy600 = addLimitClause(pCxt, yylhsminor.yy600, yymsp[0].minor.yy600);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 517: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 518: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 526: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 530: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==530);
{ yymsp[-1].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 527: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 531: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==531);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 528: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 532: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==532);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 533: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 538: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy600 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), yymsp[-1].minor.yy32, yymsp[0].minor.yy385); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 539: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy32 = ORDER_ASC; }
        break;
      case 540: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy32 = ORDER_ASC; }
        break;
      case 541: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy32 = ORDER_DESC; }
        break;
      case 542: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy385 = NULL_ORDER_DEFAULT; }
        break;
      case 543: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_FIRST; }
        break;
      case 544: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
