/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 268
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy106;
  EFillMode yy142;
  SNode* yy176;
  SToken yy225;
  EJoinType yy236;
  SAlterOption yy325;
  EOperatorType yy404;
  SDataType yy448;
  ENullOrder yy465;
  bool yy505;
  int32_t yy508;
  SNodeList* yy512;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             432
#define YYNRULE              346
#define YYNTOKEN             172
#define YY_MAX_SHIFT         431
#define YY_MIN_SHIFTREDUCE   673
#define YY_MAX_SHIFTREDUCE   1018
#define YY_ERROR_ACTION      1019
#define YY_ACCEPT_ACTION     1020
#define YY_NO_ACTION         1021
#define YY_MIN_REDUCE        1022
#define YY_MAX_REDUCE        1367
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1291)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1225,   43,  306, 1237, 1114,  350, 1221, 1227,  238, 1110,
 /*    10 */    89, 1201,   31,   29,   27,   26,   25, 1253, 1120,   24,
 /*    20 */   170, 1346,  226, 1253,  347,   31,   29,   27,   26,   25,
 /*    30 */   347,  363,  363, 1103, 1345,  362,   66,  270, 1344, 1225,
 /*    40 */   349, 1237,  307,  280, 1213, 1221, 1226,  212, 1065,  335,
 /*    50 */   321,  362, 1125, 1125,   61, 1238, 1239, 1242, 1285,  879,
 /*    60 */   212, 1253,  211, 1281,  246,  363,  271, 1346,  347,  894,
 /*    70 */  1122, 1192, 1194,  239, 1346,  106, 1092,  924,  349,  271,
 /*    80 */   117,  104, 1213,   12, 1344,  189, 1125,  117, 1155, 1127,
 /*    90 */   924, 1344,  107, 1238, 1239, 1242, 1023,  416,  415,  414,
 /*   100 */   413,  412,  411,  410,  409,  408,  407,  406,  405,  404,
 /*   110 */   403,  402,  401,  400,  399,   43,  925,   78,  926,  346,
 /*   120 */    77,   76,   75,   74,   73,   72,   71,   70,   69,  925,
 /*   130 */   336, 1359, 1121,   23,  233,   21,  919,  920,  921,  922,
 /*   140 */   923,  927,  928,  929,  883,  930,   23,  233, 1102,  919,
 /*   150 */   920,  921,  922,  923,  927,  928,  929,    9,    8, 1237,
 /*   160 */   362,  782,  386,  385,  384,  786,  383,  788,  789,  382,
 /*   170 */   791,  379,  309,  797,  376,  799,  800,  373,  370, 1253,
 /*   180 */    30,   28,  363, 1172,   98,  118,  334,  360,  235,  225,
 /*   190 */   861,   30,   28,  961, 1170,  105,  349, 1034,  284,  235,
 /*   200 */  1213,  861,  283, 1125, 1237,  395,  859,  916,   12,  394,
 /*   210 */    62, 1238, 1239, 1242, 1285,   11,  251,  859,  228, 1281,
 /*   220 */   112, 1253,  363,  285, 1253,  937,   11,   66,  347, 1116,
 /*   230 */   396,  334,  166,  881,  286,   52,    1,  109,  313, 1312,
 /*   240 */   219,  349,  210, 1125,  243, 1213,  165,    1, 1165,  393,
 /*   250 */   392,  391, 1118,  390,  324,   62, 1238, 1239, 1242, 1285,
 /*   260 */   428, 1225,  284,  228, 1281,  112,  283, 1221, 1226, 1172,
 /*   270 */  1213,  428,  860,  325, 1237,  240,  220,  104,  218,  217,
 /*   280 */  1170,  282,  118,  860, 1313, 1128,  118,  285,  710, 1299,
 /*   290 */   709,  862,  865,  201, 1253,  907,   31,   29,   27,   26,
 /*   300 */    25,  347,  862,  865,  201,  882,  907, 1296,  711, 1101,
 /*   310 */  1237,  349, 1045,   78,  118, 1213,   77,   76,   75,   74,
 /*   320 */    73,   72,   71,   70,   69,   62, 1238, 1239, 1242, 1285,
 /*   330 */  1253,  424,  423,  228, 1281, 1358,  363,  347,  245,  350,
 /*   340 */  1237,  361,   30,   28, 1319, 1202,  104,  349,   30,   28,
 /*   350 */   235, 1213,  861, 1213, 1127,  398,  235, 1125,  861,  709,
 /*   360 */  1253,   62, 1238, 1239, 1242, 1285,  985,  347,  859,  228,
 /*   370 */  1281, 1358,  968, 1172,  859,  278,  338,  349,  881,  247,
 /*   380 */  1342, 1213,  320,   11, 1170, 1044,  317,  983,  984,  986,
 /*   390 */   987,   62, 1238, 1239, 1242, 1285, 1237,  398,    7,  228,
 /*   400 */  1281, 1358,  339,  906,    1,  908,  909,  910,  911,  912,
 /*   410 */  1303,  880, 1299,  326,  322,  342, 1253,   30,   28,  348,
 /*   420 */  1068,   59,  428,  347, 1172,  235, 1213,  861,  428, 1043,
 /*   430 */  1295,   93, 1189,  349,  860, 1193,  960, 1213, 1117,  120,
 /*   440 */   860,  363,  335,  859, 1304,  956,  184,  202, 1238, 1239,
 /*   450 */  1242, 1014, 1015,  862,  865,  201,  248,  907,  389,  862,
 /*   460 */   865,  201, 1125,  907,  104,  259, 1112, 1346,  879,  292,
 /*   470 */  1213,  287, 1127,    7,  291,  252,  118,  290,  264,  288,
 /*   480 */   117, 1035,  289,  982, 1344,  340, 1237,  265,   31,   29,
 /*   490 */    27,   26,   25,   30,   28,   41, 1299,  428,    6,  363,
 /*   500 */   343,  235,  137,  861,  249,  135, 1253,   30,   28,  860,
 /*   510 */   122,  121, 1061,  347, 1294,  235, 1237,  861,  139,  859,
 /*   520 */  1125,  138,  884,  349,   27,   26,   25, 1213,  862,  865,
 /*   530 */   201, 1108,  907,  859,  293,  337, 1253,   63, 1238, 1239,
 /*   540 */  1242, 1285, 1056,  347,  388, 1284, 1281, 1042, 1093,    7,
 /*   550 */  1054,  318,  167,  349, 1172,  263, 1041, 1213,  258,  257,
 /*   560 */   256,  255,  254,    1,  295, 1171,  431,   63, 1238, 1239,
 /*   570 */  1242, 1285,  298,  428, 1237,  345, 1281,  868,  141,  959,
 /*   580 */   187,  140, 1040,   88,  160,  860,  277,  428, 1213,  420,
 /*   590 */  1039,  186,  331, 1166, 1253,  156, 1038, 1213, 1037,  860,
 /*   600 */   956,  347, 1100,  304,  862,  865,  201,  154,  907,    9,
 /*   610 */     8,  349, 1315,   92,   60, 1213,  302,  182,  862,  865,
 /*   620 */   201,  332,  907, 1213,  151,   63, 1238, 1239, 1242, 1285,
 /*   630 */   143, 1213,  335,  142, 1282, 1237, 1036, 1213, 1254, 1213,
 /*   640 */    90, 1017, 1018,  871, 1237,  169,   58,  867,  359, 1033,
 /*   650 */   163, 1292,  330, 1032,  329, 1253,   54, 1346, 1031,  395,
 /*   660 */  1030,  879,  347,  394, 1253,  312,  931, 1029,  147,    2,
 /*   670 */   117,  347,  349, 1237, 1344, 1028, 1213, 1213,   32,  234,
 /*   680 */  1020,  349, 1237,  119,  396, 1213,  206, 1238, 1239, 1242,
 /*   690 */  1213, 1237, 1191, 1253, 1213,  204, 1238, 1239, 1242, 1213,
 /*   700 */   347, 1213, 1253,  393,  392,  391,  253,  390, 1213,  347,
 /*   710 */   349, 1253, 1027,  870, 1213,  261, 1213,  314,  347,  349,
 /*   720 */   887, 1237,  260, 1213,  206, 1238, 1239, 1242,  349,  250,
 /*   730 */   262,  124, 1213,  205, 1238, 1239, 1242,  242,  241, 1237,
 /*   740 */   266, 1253,  107, 1238, 1239, 1242, 1026,  873,  347,  267,
 /*   750 */   886,  268,  194, 1213, 1346,  127,  331,  196,  349, 1253,
 /*   760 */    42, 1025, 1213,  866,  269,  327,  347,  117, 1237,  195,
 /*   770 */   891, 1344,  207, 1238, 1239, 1242,  349,   92,  130,  123,
 /*   780 */  1213, 1360,   32,  232,  272,  885,   20, 1213, 1253,  854,
 /*   790 */   206, 1238, 1239, 1242,  279,  347,   31,   29,   27,   26,
 /*   800 */    25,   32, 1213,   68,   90,  349, 1022,  281, 1115, 1213,
 /*   810 */   134, 1231,  236,  333,  113, 1292, 1293,  364, 1297,  206,
 /*   820 */  1238, 1239, 1242, 1229, 1237, 1111,  136,  100,  101,  869,
 /*   830 */    87,   86,   85,   84,   83,   82,   81,   80,   79,  861,
 /*   840 */    64,  175,  355, 1113, 1253,  181, 1237,  132,  874,  865,
 /*   850 */   111,  347, 1237,  173,   95,  859,  276,   96,  131,  775,
 /*   860 */  1109,  349,  102,  103,  224, 1213, 1253,  308,  146,  311,
 /*   870 */   770,   98, 1253,  347, 1237,  199, 1238, 1239, 1242,  347,
 /*   880 */   118,   44,   41,  349,  129,  310,  331, 1213,  149,  349,
 /*   890 */   884, 1316,  319, 1213, 1253, 1326,  152,  208, 1238, 1239,
 /*   900 */  1242,  347, 1237,  200, 1238, 1239, 1242,   92,  803,  428,
 /*   910 */  1237,  349,  807,  353,  316, 1213,  865, 1325,    5,  155,
 /*   920 */   368,  860, 1253,  227,   96,  209, 1238, 1239, 1242,  347,
 /*   930 */  1253,  128,  323, 1306,   90,  125,  159,  347, 1237,  349,
 /*   940 */   862,  865,  315, 1213,  114, 1292, 1293,  349, 1297,  328,
 /*   950 */     4, 1213,  161, 1250, 1238, 1239, 1242, 1237, 1253,   22,
 /*   960 */   110, 1249, 1238, 1239, 1242,  347, 1237,  956,  813,   31,
 /*   970 */    29,   27,   26,   25,  883,  349,  812, 1253, 1300, 1213,
 /*   980 */    97,   91,   33,  162,  347, 1237, 1253,  229,   98, 1248,
 /*   990 */  1238, 1239, 1242,  347,  349, 1361,  344,  341, 1213, 1343,
 /*  1000 */   168,   17, 1267,  349,   99, 1253,  356, 1213,  215, 1238,
 /*  1010 */  1239, 1242,  347, 1237, 1200,  351,   96,  214, 1238, 1239,
 /*  1020 */  1242,  352,  349,  177, 1199,  237, 1213,  357,  331,  358,
 /*  1030 */   179,  188,   51, 1253, 1126,   53,  216, 1238, 1239, 1242,
 /*  1040 */   347, 1237,  366,  297,  190,  185,  427,  197,  198,   92,
 /*  1050 */   349,  193, 1207,  192, 1213,  837, 1184, 1183,  305,   94,
 /*  1060 */  1182, 1253, 1181, 1180,  213, 1238, 1239, 1242,  347, 1179,
 /*  1070 */  1178, 1177,  145, 1176, 1175,  300,   90,  839,  349, 1174,
 /*  1080 */   294, 1173, 1213,  144, 1067, 1206,  115, 1292, 1293, 1197,
 /*  1090 */  1297,  126,  203, 1238, 1239, 1242, 1104,  722, 1066, 1064,
 /*  1100 */   292,  275,  287,  273,  274,  291,   40, 1053,  290,   39,
 /*  1110 */   288, 1052, 1049,  289, 1106,   31,   29,   27,   26,   25,
 /*  1120 */    67,  133,  818, 1105,  820,  819,  750, 1062,  749,  748,
 /*  1130 */   747,  746,  745, 1057,  296,  221, 1055,  222,  223,  299,
 /*  1140 */  1048,  301, 1047,  303,   65, 1205, 1204,   36, 1196,  148,
 /*  1150 */    45,  150,   14,    3,   15,   34,   32,   37,  158,   19,
 /*  1160 */  1229,   48,   10,  164,    8,  917,  153, 1003, 1002,  230,
 /*  1170 */  1007,  981,  894,  108,  354, 1006,  157,  231,  975,  974,
 /*  1180 */  1195,  180,  875, 1021,  116,   46,   47, 1021, 1021,  953,
 /*  1190 */  1021,  952, 1021, 1021,  178, 1008, 1063, 1051, 1050,  367,
 /*  1200 */  1021,  244, 1021,  371,  892,  781,   35,  172, 1021,   16,
 /*  1210 */   979,   13,   18,  374,  171,  174,  377,  176,   49,  380,
 /*  1220 */    50,  425, 1021, 1021,   38,  815,  809,  426,  804,  742,
 /*  1230 */   811,   54,  369,  810, 1228,  183,  801,  365,  372, 1021,
 /*  1240 */   798,  375,  734,  792,  378,  422,  790,  381,  741,  740,
 /*  1250 */   720,  739,  397,   55,  738,  737,  736,  735,   56,  733,
 /*  1260 */   796,  418,  795,  794,  387,  732,  793,  731,   57,  730,
 /*  1270 */   729,  728,  727,  726,  725,  417, 1046,  421,  863,  191,
 /*  1280 */   429,  419,  430, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
 /*  1290 */   814,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   216,  183,  181,  175,  196,  212,  222,  223,  215,  196,
 /*    10 */   192,  218,   12,   13,   14,   15,   16,  195,  200,  231,
 /*    20 */   232,  246,  199,  195,  202,   12,   13,   14,   15,   16,
 /*    30 */   202,  181,  181,    0,  259,   20,  186,  186,  263,  216,
 /*    40 */   212,  175,  221,  193,  216,  222,  223,   47,    0,  221,
 /*    50 */   228,   20,  202,  202,  226,  227,  228,  229,  230,   20,
 /*    60 */    47,  195,  234,  235,  204,  181,   46,  246,  202,   69,
 /*    70 */   186,  211,  212,  187,  246,  184,  185,   77,  212,   46,
 /*    80 */   259,  195,  216,   68,  263,  188,  202,  259,  191,  203,
 /*    90 */    77,  263,  226,  227,  228,  229,    0,   49,   50,   51,
 /*   100 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
 /*   110 */    62,   63,   64,   65,   66,  183,  116,   21,  116,   47,
 /*   120 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  116,
 /*   130 */   264,  265,  200,  133,  134,  133,  136,  137,  138,  139,
 /*   140 */   140,  141,  142,  143,   20,  143,  133,  134,    0,  136,
 /*   150 */   137,  138,  139,  140,  141,  142,  143,    1,    2,  175,
 /*   160 */    20,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   170 */    92,   93,   69,   95,   96,   97,   98,   99,  100,  195,
 /*   180 */    12,   13,  181,  195,   81,  146,  202,  186,   20,  201,
 /*   190 */    22,   12,   13,   14,  206,  174,  212,  176,   57,   20,
 /*   200 */   216,   22,   61,  202,  175,   57,   38,  135,   68,   61,
 /*   210 */   226,  227,  228,  229,  230,   47,  181,   38,  234,  235,
 /*   220 */   236,  195,  181,   82,  195,   69,   47,  186,  202,  175,
 /*   230 */    82,  202,  248,   20,  193,  180,   68,  194,  254,  255,
 /*   240 */    35,  212,  207,  202,  199,  216,  122,   68,  205,  101,
 /*   250 */   102,  103,  197,  105,  228,  226,  227,  228,  229,  230,
 /*   260 */    92,  216,   57,  234,  235,  236,   61,  222,  223,  195,
 /*   270 */   216,   92,  104,   20,  175,  201,   71,  195,   73,   74,
 /*   280 */   206,   76,  146,  104,  255,  203,  146,   82,   20,  224,
 /*   290 */    22,  123,  124,  125,  195,  127,   12,   13,   14,   15,
 /*   300 */    16,  202,  123,  124,  125,   20,  127,  242,   40,    0,
 /*   310 */   175,  212,  175,   21,  146,  216,   24,   25,   26,   27,
 /*   320 */    28,   29,   30,   31,   32,  226,  227,  228,  229,  230,
 /*   330 */   195,  178,  179,  234,  235,  236,  181,  202,  187,  212,
 /*   340 */   175,  186,   12,   13,  245,  218,  195,  212,   12,   13,
 /*   350 */    20,  216,   22,  216,  203,   46,   20,  202,   22,   22,
 /*   360 */   195,  226,  227,  228,  229,  230,  135,  202,   38,  234,
 /*   370 */   235,  236,   14,  195,   38,   38,    3,  212,   20,  201,
 /*   380 */   245,  216,  120,   47,  206,  175,  155,  156,  157,  158,
 /*   390 */   159,  226,  227,  228,  229,  230,  175,   46,   68,  234,
 /*   400 */   235,  236,   81,  126,   68,  128,  129,  130,  131,  132,
 /*   410 */   245,   20,  224,  151,  152,   81,  195,   12,   13,   14,
 /*   420 */     0,  180,   92,  202,  195,   20,  216,   22,   92,  175,
 /*   430 */   242,  190,  202,  212,  104,  206,    4,  216,  197,  209,
 /*   440 */   104,  181,  221,   38,  144,  145,  186,  226,  227,  228,
 /*   450 */   229,  167,  168,  123,  124,  125,  187,  127,   79,  123,
 /*   460 */   124,  125,  202,  127,  195,   63,  196,  246,   20,   49,
 /*   470 */   216,   51,  203,   68,   54,   27,  146,   57,   30,   59,
 /*   480 */   259,  176,   62,   69,  263,  164,  175,   39,   12,   13,
 /*   490 */    14,   15,   16,   12,   13,   81,  224,   92,   43,  181,
 /*   500 */   166,   20,   72,   22,  186,   75,  195,   12,   13,  104,
 /*   510 */   108,  109,    0,  202,  242,   20,  175,   22,   72,   38,
 /*   520 */   202,   75,   20,  212,   14,   15,   16,  216,  123,  124,
 /*   530 */   125,  196,  127,   38,   22,  162,  195,  226,  227,  228,
 /*   540 */   229,  230,    0,  202,  196,  234,  235,  175,  185,   68,
 /*   550 */     0,  257,  266,  212,  195,  107,  175,  216,  110,  111,
 /*   560 */   112,  113,  114,   68,   22,  206,   19,  226,  227,  228,
 /*   570 */   229,  230,   22,   92,  175,  234,  235,   38,   72,  147,
 /*   580 */    33,   75,  175,   36,  251,  104,  178,   92,  216,   42,
 /*   590 */   175,   44,  181,  205,  195,   69,  175,  216,  175,  104,
 /*   600 */   145,  202,    0,   21,  123,  124,  125,   81,  127,    1,
 /*   610 */     2,  212,  225,  202,   67,  216,   34,   70,  123,  124,
 /*   620 */   125,  244,  127,  216,  122,  226,  227,  228,  229,  230,
 /*   630 */    72,  216,  221,   75,  235,  175,  175,  216,  195,  216,
 /*   640 */   229,  170,  171,  104,  175,  260,   68,   38,  101,  175,
 /*   650 */   239,  240,  241,  175,  243,  195,   78,  246,  175,   57,
 /*   660 */   175,   20,  202,   61,  195,  118,   69,  175,  121,  247,
 /*   670 */   259,  202,  212,  175,  263,  175,  216,  216,   81,  219,
 /*   680 */   172,  212,  175,  115,   82,  216,  226,  227,  228,  229,
 /*   690 */   216,  175,  181,  195,  216,  226,  227,  228,  229,  216,
 /*   700 */   202,  216,  195,  101,  102,  103,  210,  105,  216,  202,
 /*   710 */   212,  195,  175,  104,  216,  116,  216,  219,  202,  212,
 /*   720 */    20,  175,  208,  216,  226,  227,  228,  229,  212,  221,
 /*   730 */   208,  183,  216,  226,  227,  228,  229,   12,   13,  175,
 /*   740 */   181,  195,  226,  227,  228,  229,  175,   22,  202,  220,
 /*   750 */    20,  202,   18,  216,  246,  183,  181,   23,  212,  195,
 /*   760 */   183,  175,  216,   38,  213,  258,  202,  259,  175,   35,
 /*   770 */    69,  263,  226,  227,  228,  229,  212,  202,  183,   45,
 /*   780 */   216,  265,   81,  219,  181,   20,    2,  216,  195,   69,
 /*   790 */   226,  227,  228,  229,  177,  202,   12,   13,   14,   15,
 /*   800 */    16,   81,  216,  181,  229,  212,    0,  195,  195,  216,
 /*   810 */   195,   68,  219,  238,  239,  240,  241,   92,  243,  226,
 /*   820 */   227,  228,  229,   80,  175,  195,  195,  195,  195,  104,
 /*   830 */    24,   25,   26,   27,   28,   29,   30,   31,   32,   22,
 /*   840 */   106,   69,   69,  195,  195,   69,  175,   33,  123,  124,
 /*   850 */    36,  202,  175,   81,   81,   38,   42,   81,   44,   69,
 /*   860 */   195,  212,  195,  195,  177,  216,  195,  220,  180,  213,
 /*   870 */    69,   81,  195,  202,  175,  226,  227,  228,  229,  202,
 /*   880 */   146,   67,   81,  212,   70,  202,  181,  216,  180,  212,
 /*   890 */    20,  225,  154,  216,  195,  256,  217,  226,  227,  228,
 /*   900 */   229,  202,  175,  226,  227,  228,  229,  202,   69,   92,
 /*   910 */   175,  212,   69,  153,  216,  216,  124,  256,  161,  217,
 /*   920 */    81,  104,  195,  216,   81,  226,  227,  228,  229,  202,
 /*   930 */   195,  117,  216,  253,  229,  121,  252,  202,  175,  212,
 /*   940 */   123,  124,  149,  216,  239,  240,  241,  212,  243,  160,
 /*   950 */   148,  216,  249,  226,  227,  228,  229,  175,  195,    2,
 /*   960 */   250,  226,  227,  228,  229,  202,  175,  145,   69,   12,
 /*   970 */    13,   14,   15,   16,   20,  212,   69,  195,  224,  216,
 /*   980 */    81,  202,  115,  237,  202,  175,  195,  169,   81,  226,
 /*   990 */   227,  228,  229,  202,  212,  267,  165,  163,  216,  262,
 /*  1000 */   261,   68,  233,  212,   69,  195,  119,  216,  226,  227,
 /*  1010 */   228,  229,  202,  175,  217,  216,   81,  226,  227,  228,
 /*  1020 */   229,  216,  212,  202,  217,  216,  216,  214,  181,  213,
 /*  1030 */   180,  191,  180,  195,  202,   68,  226,  227,  228,  229,
 /*  1040 */   202,  175,  198,    4,  181,  180,  177,  189,  189,  202,
 /*  1050 */   212,  173,    0,  182,  216,   80,    0,    0,   19,  115,
 /*  1060 */     0,  195,    0,    0,  226,  227,  228,  229,  202,    0,
 /*  1070 */     0,    0,   33,    0,    0,   36,  229,   22,  212,    0,
 /*  1080 */    41,    0,  216,   44,    0,    0,  239,  240,  241,    0,
 /*  1090 */   243,   43,  226,  227,  228,  229,    0,   48,    0,    0,
 /*  1100 */    49,   43,   51,   38,   36,   54,   67,    0,   57,   70,
 /*  1110 */    59,    0,    0,   62,    0,   12,   13,   14,   15,   16,
 /*  1120 */    77,   75,   22,    0,   38,   38,   38,    0,   38,   38,
 /*  1130 */    38,   38,   38,    0,   39,   22,    0,   22,   22,   38,
 /*  1140 */     0,   22,    0,   22,   20,    0,    0,  122,    0,   43,
 /*  1150 */    68,  117,  150,   81,  150,  144,   81,   81,   81,   81,
 /*  1160 */    80,    4,  150,   80,    2,  135,   69,   38,   38,   38,
 /*  1170 */    38,   69,   69,   68,  120,   38,   68,   38,   69,   69,
 /*  1180 */     0,  117,   22,  268,   80,   68,   68,  268,  268,   69,
 /*  1190 */   268,   69,  268,  268,   43,   69,    0,    0,    0,   38,
 /*  1200 */   268,   38,  268,   38,   69,   22,   81,   69,  268,   81,
 /*  1210 */    69,   68,   68,   38,   80,   68,   38,   68,   68,   38,
 /*  1220 */    68,   22,  268,  268,   68,   38,   22,   21,   69,   22,
 /*  1230 */    38,   78,   68,   38,   80,   80,   69,   79,   68,  268,
 /*  1240 */    69,   68,   22,   69,   68,   37,   69,   68,   38,   38,
 /*  1250 */    48,   38,   47,   68,   38,   38,   38,   38,   68,   38,
 /*  1260 */    94,   36,   94,   94,   82,   38,   94,   38,   68,   38,
 /*  1270 */    38,   38,   38,   38,   38,   38,    0,   38,   22,   22,
 /*  1280 */    21,   43,   20,  268,  268,  268,  268,  268,  268,  268,
 /*  1290 */   104,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1300 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1310 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1320 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1330 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1340 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1350 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1360 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1370 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1380 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1390 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1400 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1410 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1420 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1430 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1440 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1450 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1460 */   268,  268,  268,
};
#define YY_SHIFT_COUNT    (431)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1276)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   734,  168,  179,  336,  336,  336,  336,  330,  336,  336,
 /*    10 */   481,  495,  140,  405,  481,  481,  481,  481,  481,  481,
 /*    20 */   481,  481,  481,  481,  481,  481,  481,  481,  481,  481,
 /*    30 */   481,  481,  481,   15,   15,   15,   39,  725,  725,   31,
 /*    40 */    31,  725,   31,   31,   20,  213,  253,  253,  136,  285,
 /*    50 */   213,   31,   31,  213,   31,  213,  285,  213,  213,   31,
 /*    60 */   351,    0,   13,   13,  448,  292,  205,  817, 1051,  817,
 /*    70 */   817,  817,  817,  817,  817,  817,  817,  817,  817,  817,
 /*    80 */   817,  817,  817,  817,  817,  817,  817,  817,  268,   33,
 /*    90 */   124,  124,  124,  309,  391,  285,  213,  213,  213,  379,
 /*   100 */    78,   78,   78,   78,   78,   96,  420,  284,  231,  141,
 /*   110 */   262,  337,  502,  300,  455,  300,  358,  373,  432,  641,
 /*   120 */   568,  599,  599,  641,  700,   20,  391,  730,   20,   20,
 /*   130 */   641,   20,  765,  213,  213,  213,  213,  213,  213,  213,
 /*   140 */   213,  213,  213,  213,  641,  765,  700,  351,  391,  730,
 /*   150 */   351,  870,  738,  760,  792,  738,  760,  792,  792,  757,
 /*   160 */   789,  793,  802,  822,  391,  954,  867,  818,  831,  834,
 /*   170 */   933,  213,  760,  792,  792,  760,  792,  887,  391,  730,
 /*   180 */   351,  379,  351,  391,  967,  641,  351,  765, 1291, 1291,
 /*   190 */  1291, 1291,   48,  806,  547,  814, 1039,  148,  602,  784,
 /*   200 */   957,  277, 1103,  476,  476,  476,  476,  476,  476,  476,
 /*   210 */   402,  156,    2,  510,  510,  510,  510,  430,  446,  506,
 /*   220 */   558,  512,  542,  550,  582,  103,  414,  526,  608,  471,
 /*   230 */   321,  334,  597,   72,  701,  743,  720,  772,  773,  776,
 /*   240 */   790,  539,  609,  801,  839,  843,  899,  907,  935,  578,
 /*   250 */  1052,  975, 1056, 1057,  944, 1060, 1062, 1063, 1069, 1070,
 /*   260 */  1071, 1055, 1073, 1074, 1079, 1081, 1084, 1085, 1089, 1048,
 /*   270 */  1096, 1049, 1098, 1099, 1065, 1068, 1058, 1107, 1111, 1112,
 /*   280 */  1114, 1043, 1046, 1086, 1087, 1100, 1123, 1088, 1090, 1091,
 /*   290 */  1092, 1093, 1094, 1127, 1113, 1133, 1115, 1095, 1136, 1116,
 /*   300 */  1101, 1140, 1119, 1142, 1121, 1124, 1145, 1146, 1025, 1148,
 /*   310 */  1082, 1106, 1034, 1072, 1075, 1002, 1097, 1076, 1102, 1105,
 /*   320 */  1108, 1109, 1117, 1110, 1077, 1080, 1118, 1078, 1004, 1120,
 /*   330 */  1122, 1083, 1011, 1125, 1104, 1126, 1128, 1012, 1157, 1129,
 /*   340 */  1130, 1131, 1132, 1137, 1139, 1162, 1030, 1134, 1135, 1143,
 /*   350 */  1144, 1138, 1141, 1147, 1149, 1054, 1150, 1180, 1151, 1064,
 /*   360 */  1152, 1153, 1154, 1155, 1160, 1156, 1158, 1159, 1161, 1163,
 /*   370 */  1164, 1167, 1165, 1170, 1171, 1175, 1173, 1174, 1178, 1176,
 /*   380 */  1177, 1181, 1179, 1166, 1168, 1169, 1172, 1183, 1182, 1185,
 /*   390 */  1187, 1186, 1190, 1200, 1192, 1195, 1204, 1202, 1205, 1207,
 /*   400 */  1210, 1211, 1213, 1216, 1217, 1218, 1219, 1220, 1221, 1227,
 /*   410 */  1229, 1231, 1232, 1233, 1234, 1235, 1236, 1196, 1237, 1225,
 /*   420 */  1238, 1197, 1239, 1208, 1198, 1276, 1199, 1206, 1256, 1257,
 /*   430 */  1259, 1262,
};
#define YY_REDUCE_COUNT (191)
#define YY_REDUCE_MIN   (-225)
#define YY_REDUCE_MAX   (878)
static const short yy_reduce_ofst[] = {
 /*     0 */   508, -172,  -16,   29,   99,  135,  165,  221,  311,  341,
 /*    10 */  -134,  399,  411,  460,  498,  507,  516,  564,  593,  469,
 /*    20 */   546,  649,  671,  677,  699,  727,  735,  763,  782,  791,
 /*    30 */   810,  838,  866,  575,  705,  847, -179, -177,   45, -150,
 /*    40 */    41, -216, -149, -116, -182,  -12, -178,   26, -225, -207,
 /*    50 */  -114,    1,  155,   74,  260,  151, -140,  178,  269,  318,
 /*    60 */   241, -212, -212, -212,   35,   21,   43,   54, -109,  137,
 /*    70 */   210,  254,  372,  381,  407,  415,  421,  423,  461,  474,
 /*    80 */   478,  483,  485,  492,  500,  537,  571,  586,  153,  -68,
 /*    90 */    65,  188,  272,   55,  230,  127,   82,  229,  359, -103,
 /*   100 */  -192, -187,  270,  335,  348,  305,  363,  286,  294,  388,
 /*   110 */   333,  408,  387,  377,  377,  377,  443,  385,  422,  511,
 /*   120 */   496,  514,  522,  559,  529,  548,  549,  551,  572,  577,
 /*   130 */   603,  595,  617,  612,  613,  615,  630,  631,  632,  633,
 /*   140 */   648,  665,  667,  668,  622,  687,  647,  688,  683,  656,
 /*   150 */   708,  666,  639,  679,  698,  661,  702,  707,  716,  680,
 /*   160 */   684,  710,  703,  377,  779,  754,  746,  728,  737,  739,
 /*   170 */   769,  443,  797,  799,  805,  807,  809,  813,  821,  816,
 /*   180 */   850,  840,  852,  832,  844,  863,  865,  869,  858,  859,
 /*   190 */   871,  878,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*    10 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*    20 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*    30 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*    40 */  1019, 1019, 1019, 1019, 1072, 1019, 1019, 1019, 1019, 1019,
 /*    50 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*    60 */  1070, 1019, 1287, 1019, 1185, 1019, 1019, 1019, 1019, 1019,
 /*    70 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*    80 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1072,
 /*    90 */  1298, 1298, 1298, 1070, 1019, 1019, 1019, 1019, 1019, 1154,
 /*   100 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1362, 1019, 1107,
 /*   110 */  1322, 1019, 1314, 1290, 1304, 1291, 1019, 1347, 1307, 1019,
 /*   120 */  1190, 1187, 1187, 1019, 1019, 1072, 1019, 1019, 1072, 1072,
 /*   130 */  1019, 1072, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   140 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1070, 1019, 1019,
 /*   150 */  1070, 1019, 1329, 1327, 1019, 1329, 1327, 1019, 1019, 1341,
 /*   160 */  1337, 1320, 1318, 1304, 1019, 1019, 1019, 1365, 1353, 1349,
 /*   170 */  1019, 1019, 1327, 1019, 1019, 1327, 1019, 1198, 1019, 1019,
 /*   180 */  1070, 1019, 1070, 1019, 1123, 1019, 1070, 1019, 1157, 1157,
 /*   190 */  1073, 1024, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   200 */  1019, 1019, 1019, 1252, 1340, 1339, 1251, 1264, 1263, 1262,
 /*   210 */  1019, 1019, 1019, 1246, 1247, 1245, 1244, 1019, 1019, 1019,
 /*   220 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1288, 1019,
 /*   230 */  1350, 1354, 1019, 1019, 1019, 1230, 1019, 1019, 1019, 1019,
 /*   240 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   250 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   260 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   270 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   280 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   290 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   300 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   310 */  1019, 1019, 1019, 1311, 1321, 1019, 1019, 1019, 1019, 1019,
 /*   320 */  1019, 1019, 1019, 1019, 1019, 1230, 1019, 1338, 1019, 1297,
 /*   330 */  1293, 1019, 1019, 1289, 1019, 1019, 1348, 1019, 1019, 1019,
 /*   340 */  1019, 1019, 1019, 1019, 1019, 1283, 1019, 1019, 1019, 1019,
 /*   350 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   360 */  1019, 1019, 1229, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   370 */  1151, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   380 */  1019, 1019, 1019, 1136, 1134, 1133, 1132, 1019, 1129, 1019,
 /*   390 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   400 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   410 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   420 */  1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
 /*   430 */  1019, 1019,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "TABLE",
  /*   68 */ "NK_LP",
  /*   69 */ "NK_RP",
  /*   70 */ "STABLE",
  /*   71 */ "ADD",
  /*   72 */ "COLUMN",
  /*   73 */ "MODIFY",
  /*   74 */ "RENAME",
  /*   75 */ "TAG",
  /*   76 */ "SET",
  /*   77 */ "NK_EQ",
  /*   78 */ "USING",
  /*   79 */ "TAGS",
  /*   80 */ "NK_DOT",
  /*   81 */ "NK_COMMA",
  /*   82 */ "COMMENT",
  /*   83 */ "BOOL",
  /*   84 */ "TINYINT",
  /*   85 */ "SMALLINT",
  /*   86 */ "INT",
  /*   87 */ "INTEGER",
  /*   88 */ "BIGINT",
  /*   89 */ "FLOAT",
  /*   90 */ "DOUBLE",
  /*   91 */ "BINARY",
  /*   92 */ "TIMESTAMP",
  /*   93 */ "NCHAR",
  /*   94 */ "UNSIGNED",
  /*   95 */ "JSON",
  /*   96 */ "VARCHAR",
  /*   97 */ "MEDIUMBLOB",
  /*   98 */ "BLOB",
  /*   99 */ "VARBINARY",
  /*  100 */ "DECIMAL",
  /*  101 */ "SMA",
  /*  102 */ "ROLLUP",
  /*  103 */ "FILE_FACTOR",
  /*  104 */ "NK_FLOAT",
  /*  105 */ "DELAY",
  /*  106 */ "SHOW",
  /*  107 */ "DATABASES",
  /*  108 */ "TABLES",
  /*  109 */ "STABLES",
  /*  110 */ "MNODES",
  /*  111 */ "MODULES",
  /*  112 */ "QNODES",
  /*  113 */ "FUNCTIONS",
  /*  114 */ "INDEXES",
  /*  115 */ "FROM",
  /*  116 */ "LIKE",
  /*  117 */ "INDEX",
  /*  118 */ "FULLTEXT",
  /*  119 */ "FUNCTION",
  /*  120 */ "INTERVAL",
  /*  121 */ "TOPIC",
  /*  122 */ "AS",
  /*  123 */ "NK_BOOL",
  /*  124 */ "NK_VARIABLE",
  /*  125 */ "NK_UNDERLINE",
  /*  126 */ "ROWTS",
  /*  127 */ "TBNAME",
  /*  128 */ "QSTARTTS",
  /*  129 */ "QENDTS",
  /*  130 */ "WSTARTTS",
  /*  131 */ "WENDTS",
  /*  132 */ "WDURATION",
  /*  133 */ "BETWEEN",
  /*  134 */ "IS",
  /*  135 */ "NULL",
  /*  136 */ "NK_LT",
  /*  137 */ "NK_GT",
  /*  138 */ "NK_LE",
  /*  139 */ "NK_GE",
  /*  140 */ "NK_NE",
  /*  141 */ "MATCH",
  /*  142 */ "NMATCH",
  /*  143 */ "IN",
  /*  144 */ "JOIN",
  /*  145 */ "INNER",
  /*  146 */ "SELECT",
  /*  147 */ "DISTINCT",
  /*  148 */ "WHERE",
  /*  149 */ "PARTITION",
  /*  150 */ "BY",
  /*  151 */ "SESSION",
  /*  152 */ "STATE_WINDOW",
  /*  153 */ "SLIDING",
  /*  154 */ "FILL",
  /*  155 */ "VALUE",
  /*  156 */ "NONE",
  /*  157 */ "PREV",
  /*  158 */ "LINEAR",
  /*  159 */ "NEXT",
  /*  160 */ "GROUP",
  /*  161 */ "HAVING",
  /*  162 */ "ORDER",
  /*  163 */ "SLIMIT",
  /*  164 */ "SOFFSET",
  /*  165 */ "LIMIT",
  /*  166 */ "OFFSET",
  /*  167 */ "ASC",
  /*  168 */ "DESC",
  /*  169 */ "NULLS",
  /*  170 */ "FIRST",
  /*  171 */ "LAST",
  /*  172 */ "cmd",
  /*  173 */ "account_options",
  /*  174 */ "alter_account_options",
  /*  175 */ "literal",
  /*  176 */ "alter_account_option",
  /*  177 */ "user_name",
  /*  178 */ "dnode_endpoint",
  /*  179 */ "dnode_host_name",
  /*  180 */ "not_exists_opt",
  /*  181 */ "db_name",
  /*  182 */ "db_options",
  /*  183 */ "exists_opt",
  /*  184 */ "alter_db_options",
  /*  185 */ "alter_db_option",
  /*  186 */ "full_table_name",
  /*  187 */ "column_def_list",
  /*  188 */ "tags_def_opt",
  /*  189 */ "table_options",
  /*  190 */ "multi_create_clause",
  /*  191 */ "tags_def",
  /*  192 */ "multi_drop_clause",
  /*  193 */ "alter_table_clause",
  /*  194 */ "alter_table_options",
  /*  195 */ "column_name",
  /*  196 */ "type_name",
  /*  197 */ "create_subtable_clause",
  /*  198 */ "specific_tags_opt",
  /*  199 */ "literal_list",
  /*  200 */ "drop_table_clause",
  /*  201 */ "col_name_list",
  /*  202 */ "table_name",
  /*  203 */ "column_def",
  /*  204 */ "func_name_list",
  /*  205 */ "alter_table_option",
  /*  206 */ "col_name",
  /*  207 */ "db_name_cond_opt",
  /*  208 */ "like_pattern_opt",
  /*  209 */ "table_name_cond",
  /*  210 */ "from_db_opt",
  /*  211 */ "func_name",
  /*  212 */ "function_name",
  /*  213 */ "index_name",
  /*  214 */ "index_options",
  /*  215 */ "func_list",
  /*  216 */ "duration_literal",
  /*  217 */ "sliding_opt",
  /*  218 */ "func",
  /*  219 */ "expression_list",
  /*  220 */ "topic_name",
  /*  221 */ "query_expression",
  /*  222 */ "signed",
  /*  223 */ "signed_literal",
  /*  224 */ "table_alias",
  /*  225 */ "column_alias",
  /*  226 */ "expression",
  /*  227 */ "pseudo_column",
  /*  228 */ "column_reference",
  /*  229 */ "subquery",
  /*  230 */ "predicate",
  /*  231 */ "compare_op",
  /*  232 */ "in_op",
  /*  233 */ "in_predicate_value",
  /*  234 */ "boolean_value_expression",
  /*  235 */ "boolean_primary",
  /*  236 */ "common_expression",
  /*  237 */ "from_clause",
  /*  238 */ "table_reference_list",
  /*  239 */ "table_reference",
  /*  240 */ "table_primary",
  /*  241 */ "joined_table",
  /*  242 */ "alias_opt",
  /*  243 */ "parenthesized_joined_table",
  /*  244 */ "join_type",
  /*  245 */ "search_condition",
  /*  246 */ "query_specification",
  /*  247 */ "set_quantifier_opt",
  /*  248 */ "select_list",
  /*  249 */ "where_clause_opt",
  /*  250 */ "partition_by_clause_opt",
  /*  251 */ "twindow_clause_opt",
  /*  252 */ "group_by_clause_opt",
  /*  253 */ "having_clause_opt",
  /*  254 */ "select_sublist",
  /*  255 */ "select_item",
  /*  256 */ "fill_opt",
  /*  257 */ "fill_mode",
  /*  258 */ "group_by_list",
  /*  259 */ "query_expression_body",
  /*  260 */ "order_by_clause_opt",
  /*  261 */ "slimit_clause_opt",
  /*  262 */ "limit_clause_opt",
  /*  263 */ "query_primary",
  /*  264 */ "sort_specification_list",
  /*  265 */ "sort_specification",
  /*  266 */ "ordering_specification_opt",
  /*  267 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP NK_INTEGER",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "alter_db_options ::= alter_db_option",
 /*  71 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  72 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  73 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  74 */ "alter_db_option ::= KEEP NK_INTEGER",
 /*  75 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  76 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  77 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  78 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  79 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  80 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  81 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  82 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  83 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  84 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  85 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  86 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  87 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  88 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  89 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  90 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  91 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  92 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  93 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  94 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  95 */ "multi_create_clause ::= create_subtable_clause",
 /*  96 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /*  97 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /*  98 */ "multi_drop_clause ::= drop_table_clause",
 /*  99 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 100 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 101 */ "specific_tags_opt ::=",
 /* 102 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 103 */ "full_table_name ::= table_name",
 /* 104 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 105 */ "column_def_list ::= column_def",
 /* 106 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 107 */ "column_def ::= column_name type_name",
 /* 108 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 109 */ "type_name ::= BOOL",
 /* 110 */ "type_name ::= TINYINT",
 /* 111 */ "type_name ::= SMALLINT",
 /* 112 */ "type_name ::= INT",
 /* 113 */ "type_name ::= INTEGER",
 /* 114 */ "type_name ::= BIGINT",
 /* 115 */ "type_name ::= FLOAT",
 /* 116 */ "type_name ::= DOUBLE",
 /* 117 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 118 */ "type_name ::= TIMESTAMP",
 /* 119 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 120 */ "type_name ::= TINYINT UNSIGNED",
 /* 121 */ "type_name ::= SMALLINT UNSIGNED",
 /* 122 */ "type_name ::= INT UNSIGNED",
 /* 123 */ "type_name ::= BIGINT UNSIGNED",
 /* 124 */ "type_name ::= JSON",
 /* 125 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 126 */ "type_name ::= MEDIUMBLOB",
 /* 127 */ "type_name ::= BLOB",
 /* 128 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= DECIMAL",
 /* 130 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 131 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 132 */ "tags_def_opt ::=",
 /* 133 */ "tags_def_opt ::= tags_def",
 /* 134 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 135 */ "table_options ::=",
 /* 136 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 137 */ "table_options ::= table_options KEEP NK_INTEGER",
 /* 138 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 139 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 140 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 141 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 142 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 143 */ "alter_table_options ::= alter_table_option",
 /* 144 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 145 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 146 */ "alter_table_option ::= KEEP NK_INTEGER",
 /* 147 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 148 */ "col_name_list ::= col_name",
 /* 149 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 150 */ "col_name ::= column_name",
 /* 151 */ "cmd ::= SHOW DNODES",
 /* 152 */ "cmd ::= SHOW USERS",
 /* 153 */ "cmd ::= SHOW DATABASES",
 /* 154 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 155 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 156 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 157 */ "cmd ::= SHOW MNODES",
 /* 158 */ "cmd ::= SHOW MODULES",
 /* 159 */ "cmd ::= SHOW QNODES",
 /* 160 */ "cmd ::= SHOW FUNCTIONS",
 /* 161 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 162 */ "cmd ::= SHOW STREAMS",
 /* 163 */ "db_name_cond_opt ::=",
 /* 164 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 165 */ "like_pattern_opt ::=",
 /* 166 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 167 */ "table_name_cond ::= table_name",
 /* 168 */ "from_db_opt ::=",
 /* 169 */ "from_db_opt ::= FROM db_name",
 /* 170 */ "func_name_list ::= func_name",
 /* 171 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 172 */ "func_name ::= function_name",
 /* 173 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 174 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 175 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 176 */ "index_options ::=",
 /* 177 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 178 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 179 */ "func_list ::= func",
 /* 180 */ "func_list ::= func_list NK_COMMA func",
 /* 181 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 182 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 183 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 184 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 185 */ "cmd ::= query_expression",
 /* 186 */ "literal ::= NK_INTEGER",
 /* 187 */ "literal ::= NK_FLOAT",
 /* 188 */ "literal ::= NK_STRING",
 /* 189 */ "literal ::= NK_BOOL",
 /* 190 */ "literal ::= TIMESTAMP NK_STRING",
 /* 191 */ "literal ::= duration_literal",
 /* 192 */ "duration_literal ::= NK_VARIABLE",
 /* 193 */ "signed ::= NK_INTEGER",
 /* 194 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 195 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 196 */ "signed ::= NK_FLOAT",
 /* 197 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 198 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 199 */ "signed_literal ::= signed",
 /* 200 */ "signed_literal ::= NK_STRING",
 /* 201 */ "signed_literal ::= NK_BOOL",
 /* 202 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 203 */ "signed_literal ::= duration_literal",
 /* 204 */ "literal_list ::= signed_literal",
 /* 205 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 206 */ "db_name ::= NK_ID",
 /* 207 */ "table_name ::= NK_ID",
 /* 208 */ "column_name ::= NK_ID",
 /* 209 */ "function_name ::= NK_ID",
 /* 210 */ "table_alias ::= NK_ID",
 /* 211 */ "column_alias ::= NK_ID",
 /* 212 */ "user_name ::= NK_ID",
 /* 213 */ "index_name ::= NK_ID",
 /* 214 */ "topic_name ::= NK_ID",
 /* 215 */ "expression ::= literal",
 /* 216 */ "expression ::= pseudo_column",
 /* 217 */ "expression ::= column_reference",
 /* 218 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 219 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 220 */ "expression ::= subquery",
 /* 221 */ "expression ::= NK_LP expression NK_RP",
 /* 222 */ "expression ::= NK_PLUS expression",
 /* 223 */ "expression ::= NK_MINUS expression",
 /* 224 */ "expression ::= expression NK_PLUS expression",
 /* 225 */ "expression ::= expression NK_MINUS expression",
 /* 226 */ "expression ::= expression NK_STAR expression",
 /* 227 */ "expression ::= expression NK_SLASH expression",
 /* 228 */ "expression ::= expression NK_REM expression",
 /* 229 */ "expression_list ::= expression",
 /* 230 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 231 */ "column_reference ::= column_name",
 /* 232 */ "column_reference ::= table_name NK_DOT column_name",
 /* 233 */ "pseudo_column ::= NK_UNDERLINE ROWTS",
 /* 234 */ "pseudo_column ::= TBNAME",
 /* 235 */ "pseudo_column ::= NK_UNDERLINE QSTARTTS",
 /* 236 */ "pseudo_column ::= NK_UNDERLINE QENDTS",
 /* 237 */ "pseudo_column ::= NK_UNDERLINE WSTARTTS",
 /* 238 */ "pseudo_column ::= NK_UNDERLINE WENDTS",
 /* 239 */ "pseudo_column ::= NK_UNDERLINE WDURATION",
 /* 240 */ "predicate ::= expression compare_op expression",
 /* 241 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 242 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 243 */ "predicate ::= expression IS NULL",
 /* 244 */ "predicate ::= expression IS NOT NULL",
 /* 245 */ "predicate ::= expression in_op in_predicate_value",
 /* 246 */ "compare_op ::= NK_LT",
 /* 247 */ "compare_op ::= NK_GT",
 /* 248 */ "compare_op ::= NK_LE",
 /* 249 */ "compare_op ::= NK_GE",
 /* 250 */ "compare_op ::= NK_NE",
 /* 251 */ "compare_op ::= NK_EQ",
 /* 252 */ "compare_op ::= LIKE",
 /* 253 */ "compare_op ::= NOT LIKE",
 /* 254 */ "compare_op ::= MATCH",
 /* 255 */ "compare_op ::= NMATCH",
 /* 256 */ "in_op ::= IN",
 /* 257 */ "in_op ::= NOT IN",
 /* 258 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 259 */ "boolean_value_expression ::= boolean_primary",
 /* 260 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 261 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 262 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 263 */ "boolean_primary ::= predicate",
 /* 264 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 265 */ "common_expression ::= expression",
 /* 266 */ "common_expression ::= boolean_value_expression",
 /* 267 */ "from_clause ::= FROM table_reference_list",
 /* 268 */ "table_reference_list ::= table_reference",
 /* 269 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 270 */ "table_reference ::= table_primary",
 /* 271 */ "table_reference ::= joined_table",
 /* 272 */ "table_primary ::= table_name alias_opt",
 /* 273 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 274 */ "table_primary ::= subquery alias_opt",
 /* 275 */ "table_primary ::= parenthesized_joined_table",
 /* 276 */ "alias_opt ::=",
 /* 277 */ "alias_opt ::= table_alias",
 /* 278 */ "alias_opt ::= AS table_alias",
 /* 279 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 280 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 281 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 282 */ "join_type ::=",
 /* 283 */ "join_type ::= INNER",
 /* 284 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 285 */ "set_quantifier_opt ::=",
 /* 286 */ "set_quantifier_opt ::= DISTINCT",
 /* 287 */ "set_quantifier_opt ::= ALL",
 /* 288 */ "select_list ::= NK_STAR",
 /* 289 */ "select_list ::= select_sublist",
 /* 290 */ "select_sublist ::= select_item",
 /* 291 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 292 */ "select_item ::= common_expression",
 /* 293 */ "select_item ::= common_expression column_alias",
 /* 294 */ "select_item ::= common_expression AS column_alias",
 /* 295 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 296 */ "where_clause_opt ::=",
 /* 297 */ "where_clause_opt ::= WHERE search_condition",
 /* 298 */ "partition_by_clause_opt ::=",
 /* 299 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 300 */ "twindow_clause_opt ::=",
 /* 301 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 302 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP",
 /* 303 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 304 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 305 */ "sliding_opt ::=",
 /* 306 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 307 */ "fill_opt ::=",
 /* 308 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 309 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 310 */ "fill_mode ::= NONE",
 /* 311 */ "fill_mode ::= PREV",
 /* 312 */ "fill_mode ::= NULL",
 /* 313 */ "fill_mode ::= LINEAR",
 /* 314 */ "fill_mode ::= NEXT",
 /* 315 */ "group_by_clause_opt ::=",
 /* 316 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 317 */ "group_by_list ::= expression",
 /* 318 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 319 */ "having_clause_opt ::=",
 /* 320 */ "having_clause_opt ::= HAVING search_condition",
 /* 321 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 322 */ "query_expression_body ::= query_primary",
 /* 323 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 324 */ "query_primary ::= query_specification",
 /* 325 */ "order_by_clause_opt ::=",
 /* 326 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 327 */ "slimit_clause_opt ::=",
 /* 328 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 329 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 330 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 331 */ "limit_clause_opt ::=",
 /* 332 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 333 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 334 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 335 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 336 */ "search_condition ::= common_expression",
 /* 337 */ "sort_specification_list ::= sort_specification",
 /* 338 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 339 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 340 */ "ordering_specification_opt ::=",
 /* 341 */ "ordering_specification_opt ::= ASC",
 /* 342 */ "ordering_specification_opt ::= DESC",
 /* 343 */ "null_ordering_opt ::=",
 /* 344 */ "null_ordering_opt ::= NULLS FIRST",
 /* 345 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 172: /* cmd */
    case 175: /* literal */
    case 182: /* db_options */
    case 184: /* alter_db_options */
    case 186: /* full_table_name */
    case 189: /* table_options */
    case 193: /* alter_table_clause */
    case 194: /* alter_table_options */
    case 197: /* create_subtable_clause */
    case 200: /* drop_table_clause */
    case 203: /* column_def */
    case 206: /* col_name */
    case 207: /* db_name_cond_opt */
    case 208: /* like_pattern_opt */
    case 209: /* table_name_cond */
    case 210: /* from_db_opt */
    case 211: /* func_name */
    case 214: /* index_options */
    case 216: /* duration_literal */
    case 217: /* sliding_opt */
    case 218: /* func */
    case 221: /* query_expression */
    case 222: /* signed */
    case 223: /* signed_literal */
    case 226: /* expression */
    case 227: /* pseudo_column */
    case 228: /* column_reference */
    case 229: /* subquery */
    case 230: /* predicate */
    case 233: /* in_predicate_value */
    case 234: /* boolean_value_expression */
    case 235: /* boolean_primary */
    case 236: /* common_expression */
    case 237: /* from_clause */
    case 238: /* table_reference_list */
    case 239: /* table_reference */
    case 240: /* table_primary */
    case 241: /* joined_table */
    case 243: /* parenthesized_joined_table */
    case 245: /* search_condition */
    case 246: /* query_specification */
    case 249: /* where_clause_opt */
    case 251: /* twindow_clause_opt */
    case 253: /* having_clause_opt */
    case 255: /* select_item */
    case 256: /* fill_opt */
    case 259: /* query_expression_body */
    case 261: /* slimit_clause_opt */
    case 262: /* limit_clause_opt */
    case 263: /* query_primary */
    case 265: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy176)); 
}
      break;
    case 173: /* account_options */
    case 174: /* alter_account_options */
    case 176: /* alter_account_option */
{
 
}
      break;
    case 177: /* user_name */
    case 178: /* dnode_endpoint */
    case 179: /* dnode_host_name */
    case 181: /* db_name */
    case 195: /* column_name */
    case 202: /* table_name */
    case 212: /* function_name */
    case 213: /* index_name */
    case 220: /* topic_name */
    case 224: /* table_alias */
    case 225: /* column_alias */
    case 242: /* alias_opt */
{
 
}
      break;
    case 180: /* not_exists_opt */
    case 183: /* exists_opt */
    case 247: /* set_quantifier_opt */
{
 
}
      break;
    case 185: /* alter_db_option */
    case 205: /* alter_table_option */
{
 
}
      break;
    case 187: /* column_def_list */
    case 188: /* tags_def_opt */
    case 190: /* multi_create_clause */
    case 191: /* tags_def */
    case 192: /* multi_drop_clause */
    case 198: /* specific_tags_opt */
    case 199: /* literal_list */
    case 201: /* col_name_list */
    case 204: /* func_name_list */
    case 215: /* func_list */
    case 219: /* expression_list */
    case 248: /* select_list */
    case 250: /* partition_by_clause_opt */
    case 252: /* group_by_clause_opt */
    case 254: /* select_sublist */
    case 258: /* group_by_list */
    case 260: /* order_by_clause_opt */
    case 264: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy512)); 
}
      break;
    case 196: /* type_name */
{
 
}
      break;
    case 231: /* compare_op */
    case 232: /* in_op */
{
 
}
      break;
    case 244: /* join_type */
{
 
}
      break;
    case 257: /* fill_mode */
{
 
}
      break;
    case 266: /* ordering_specification_opt */
{
 
}
      break;
    case 267: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  172,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  172,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  173,    0 }, /* (2) account_options ::= */
  {  173,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  173,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  173,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  173,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  173,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  173,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  173,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  173,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  173,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  174,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  174,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  176,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  176,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  176,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  176,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  176,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  176,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  176,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  176,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  176,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  176,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  172,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  172,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  172,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  172,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  172,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  172,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  172,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  172,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  172,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  172,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  172,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  172,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  178,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  179,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  179,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  172,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  172,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  172,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  172,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  172,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  172,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  172,   -2 }, /* (45) cmd ::= USE db_name */
  {  172,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  180,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  180,    0 }, /* (48) not_exists_opt ::= */
  {  183,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  183,    0 }, /* (50) exists_opt ::= */
  {  182,    0 }, /* (51) db_options ::= */
  {  182,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  182,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  182,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  182,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  182,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  182,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  182,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  182,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  182,   -3 }, /* (60) db_options ::= db_options KEEP NK_INTEGER */
  {  182,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  182,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  182,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  182,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  182,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  182,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  182,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  182,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  182,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  184,   -1 }, /* (70) alter_db_options ::= alter_db_option */
  {  184,   -2 }, /* (71) alter_db_options ::= alter_db_options alter_db_option */
  {  185,   -2 }, /* (72) alter_db_option ::= BLOCKS NK_INTEGER */
  {  185,   -2 }, /* (73) alter_db_option ::= FSYNC NK_INTEGER */
  {  185,   -2 }, /* (74) alter_db_option ::= KEEP NK_INTEGER */
  {  185,   -2 }, /* (75) alter_db_option ::= WAL NK_INTEGER */
  {  185,   -2 }, /* (76) alter_db_option ::= QUORUM NK_INTEGER */
  {  185,   -2 }, /* (77) alter_db_option ::= CACHELAST NK_INTEGER */
  {  172,   -9 }, /* (78) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  172,   -3 }, /* (79) cmd ::= CREATE TABLE multi_create_clause */
  {  172,   -9 }, /* (80) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  172,   -3 }, /* (81) cmd ::= DROP TABLE multi_drop_clause */
  {  172,   -4 }, /* (82) cmd ::= DROP STABLE exists_opt full_table_name */
  {  172,   -3 }, /* (83) cmd ::= ALTER TABLE alter_table_clause */
  {  172,   -3 }, /* (84) cmd ::= ALTER STABLE alter_table_clause */
  {  193,   -2 }, /* (85) alter_table_clause ::= full_table_name alter_table_options */
  {  193,   -5 }, /* (86) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  193,   -4 }, /* (87) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  193,   -5 }, /* (88) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  193,   -5 }, /* (89) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  193,   -5 }, /* (90) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  193,   -4 }, /* (91) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  193,   -5 }, /* (92) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  193,   -5 }, /* (93) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  193,   -6 }, /* (94) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  190,   -1 }, /* (95) multi_create_clause ::= create_subtable_clause */
  {  190,   -2 }, /* (96) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  197,   -9 }, /* (97) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  192,   -1 }, /* (98) multi_drop_clause ::= drop_table_clause */
  {  192,   -2 }, /* (99) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  200,   -2 }, /* (100) drop_table_clause ::= exists_opt full_table_name */
  {  198,    0 }, /* (101) specific_tags_opt ::= */
  {  198,   -3 }, /* (102) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  186,   -1 }, /* (103) full_table_name ::= table_name */
  {  186,   -3 }, /* (104) full_table_name ::= db_name NK_DOT table_name */
  {  187,   -1 }, /* (105) column_def_list ::= column_def */
  {  187,   -3 }, /* (106) column_def_list ::= column_def_list NK_COMMA column_def */
  {  203,   -2 }, /* (107) column_def ::= column_name type_name */
  {  203,   -4 }, /* (108) column_def ::= column_name type_name COMMENT NK_STRING */
  {  196,   -1 }, /* (109) type_name ::= BOOL */
  {  196,   -1 }, /* (110) type_name ::= TINYINT */
  {  196,   -1 }, /* (111) type_name ::= SMALLINT */
  {  196,   -1 }, /* (112) type_name ::= INT */
  {  196,   -1 }, /* (113) type_name ::= INTEGER */
  {  196,   -1 }, /* (114) type_name ::= BIGINT */
  {  196,   -1 }, /* (115) type_name ::= FLOAT */
  {  196,   -1 }, /* (116) type_name ::= DOUBLE */
  {  196,   -4 }, /* (117) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  196,   -1 }, /* (118) type_name ::= TIMESTAMP */
  {  196,   -4 }, /* (119) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  196,   -2 }, /* (120) type_name ::= TINYINT UNSIGNED */
  {  196,   -2 }, /* (121) type_name ::= SMALLINT UNSIGNED */
  {  196,   -2 }, /* (122) type_name ::= INT UNSIGNED */
  {  196,   -2 }, /* (123) type_name ::= BIGINT UNSIGNED */
  {  196,   -1 }, /* (124) type_name ::= JSON */
  {  196,   -4 }, /* (125) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  196,   -1 }, /* (126) type_name ::= MEDIUMBLOB */
  {  196,   -1 }, /* (127) type_name ::= BLOB */
  {  196,   -4 }, /* (128) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  196,   -1 }, /* (129) type_name ::= DECIMAL */
  {  196,   -4 }, /* (130) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  196,   -6 }, /* (131) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  188,    0 }, /* (132) tags_def_opt ::= */
  {  188,   -1 }, /* (133) tags_def_opt ::= tags_def */
  {  191,   -4 }, /* (134) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  189,    0 }, /* (135) table_options ::= */
  {  189,   -3 }, /* (136) table_options ::= table_options COMMENT NK_STRING */
  {  189,   -3 }, /* (137) table_options ::= table_options KEEP NK_INTEGER */
  {  189,   -3 }, /* (138) table_options ::= table_options TTL NK_INTEGER */
  {  189,   -5 }, /* (139) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  189,   -5 }, /* (140) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  189,   -3 }, /* (141) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  189,   -3 }, /* (142) table_options ::= table_options DELAY NK_INTEGER */
  {  194,   -1 }, /* (143) alter_table_options ::= alter_table_option */
  {  194,   -2 }, /* (144) alter_table_options ::= alter_table_options alter_table_option */
  {  205,   -2 }, /* (145) alter_table_option ::= COMMENT NK_STRING */
  {  205,   -2 }, /* (146) alter_table_option ::= KEEP NK_INTEGER */
  {  205,   -2 }, /* (147) alter_table_option ::= TTL NK_INTEGER */
  {  201,   -1 }, /* (148) col_name_list ::= col_name */
  {  201,   -3 }, /* (149) col_name_list ::= col_name_list NK_COMMA col_name */
  {  206,   -1 }, /* (150) col_name ::= column_name */
  {  172,   -2 }, /* (151) cmd ::= SHOW DNODES */
  {  172,   -2 }, /* (152) cmd ::= SHOW USERS */
  {  172,   -2 }, /* (153) cmd ::= SHOW DATABASES */
  {  172,   -4 }, /* (154) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  172,   -4 }, /* (155) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  172,   -3 }, /* (156) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  172,   -2 }, /* (157) cmd ::= SHOW MNODES */
  {  172,   -2 }, /* (158) cmd ::= SHOW MODULES */
  {  172,   -2 }, /* (159) cmd ::= SHOW QNODES */
  {  172,   -2 }, /* (160) cmd ::= SHOW FUNCTIONS */
  {  172,   -5 }, /* (161) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  172,   -2 }, /* (162) cmd ::= SHOW STREAMS */
  {  207,    0 }, /* (163) db_name_cond_opt ::= */
  {  207,   -2 }, /* (164) db_name_cond_opt ::= db_name NK_DOT */
  {  208,    0 }, /* (165) like_pattern_opt ::= */
  {  208,   -2 }, /* (166) like_pattern_opt ::= LIKE NK_STRING */
  {  209,   -1 }, /* (167) table_name_cond ::= table_name */
  {  210,    0 }, /* (168) from_db_opt ::= */
  {  210,   -2 }, /* (169) from_db_opt ::= FROM db_name */
  {  204,   -1 }, /* (170) func_name_list ::= func_name */
  {  204,   -3 }, /* (171) func_name_list ::= func_name_list NK_COMMA col_name */
  {  211,   -1 }, /* (172) func_name ::= function_name */
  {  172,   -8 }, /* (173) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  172,  -10 }, /* (174) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  172,   -6 }, /* (175) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  214,    0 }, /* (176) index_options ::= */
  {  214,   -9 }, /* (177) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  214,  -11 }, /* (178) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  215,   -1 }, /* (179) func_list ::= func */
  {  215,   -3 }, /* (180) func_list ::= func_list NK_COMMA func */
  {  218,   -4 }, /* (181) func ::= function_name NK_LP expression_list NK_RP */
  {  172,   -6 }, /* (182) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  172,   -6 }, /* (183) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  172,   -4 }, /* (184) cmd ::= DROP TOPIC exists_opt topic_name */
  {  172,   -1 }, /* (185) cmd ::= query_expression */
  {  175,   -1 }, /* (186) literal ::= NK_INTEGER */
  {  175,   -1 }, /* (187) literal ::= NK_FLOAT */
  {  175,   -1 }, /* (188) literal ::= NK_STRING */
  {  175,   -1 }, /* (189) literal ::= NK_BOOL */
  {  175,   -2 }, /* (190) literal ::= TIMESTAMP NK_STRING */
  {  175,   -1 }, /* (191) literal ::= duration_literal */
  {  216,   -1 }, /* (192) duration_literal ::= NK_VARIABLE */
  {  222,   -1 }, /* (193) signed ::= NK_INTEGER */
  {  222,   -2 }, /* (194) signed ::= NK_PLUS NK_INTEGER */
  {  222,   -2 }, /* (195) signed ::= NK_MINUS NK_INTEGER */
  {  222,   -1 }, /* (196) signed ::= NK_FLOAT */
  {  222,   -2 }, /* (197) signed ::= NK_PLUS NK_FLOAT */
  {  222,   -2 }, /* (198) signed ::= NK_MINUS NK_FLOAT */
  {  223,   -1 }, /* (199) signed_literal ::= signed */
  {  223,   -1 }, /* (200) signed_literal ::= NK_STRING */
  {  223,   -1 }, /* (201) signed_literal ::= NK_BOOL */
  {  223,   -2 }, /* (202) signed_literal ::= TIMESTAMP NK_STRING */
  {  223,   -1 }, /* (203) signed_literal ::= duration_literal */
  {  199,   -1 }, /* (204) literal_list ::= signed_literal */
  {  199,   -3 }, /* (205) literal_list ::= literal_list NK_COMMA signed_literal */
  {  181,   -1 }, /* (206) db_name ::= NK_ID */
  {  202,   -1 }, /* (207) table_name ::= NK_ID */
  {  195,   -1 }, /* (208) column_name ::= NK_ID */
  {  212,   -1 }, /* (209) function_name ::= NK_ID */
  {  224,   -1 }, /* (210) table_alias ::= NK_ID */
  {  225,   -1 }, /* (211) column_alias ::= NK_ID */
  {  177,   -1 }, /* (212) user_name ::= NK_ID */
  {  213,   -1 }, /* (213) index_name ::= NK_ID */
  {  220,   -1 }, /* (214) topic_name ::= NK_ID */
  {  226,   -1 }, /* (215) expression ::= literal */
  {  226,   -1 }, /* (216) expression ::= pseudo_column */
  {  226,   -1 }, /* (217) expression ::= column_reference */
  {  226,   -4 }, /* (218) expression ::= function_name NK_LP expression_list NK_RP */
  {  226,   -4 }, /* (219) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  226,   -1 }, /* (220) expression ::= subquery */
  {  226,   -3 }, /* (221) expression ::= NK_LP expression NK_RP */
  {  226,   -2 }, /* (222) expression ::= NK_PLUS expression */
  {  226,   -2 }, /* (223) expression ::= NK_MINUS expression */
  {  226,   -3 }, /* (224) expression ::= expression NK_PLUS expression */
  {  226,   -3 }, /* (225) expression ::= expression NK_MINUS expression */
  {  226,   -3 }, /* (226) expression ::= expression NK_STAR expression */
  {  226,   -3 }, /* (227) expression ::= expression NK_SLASH expression */
  {  226,   -3 }, /* (228) expression ::= expression NK_REM expression */
  {  219,   -1 }, /* (229) expression_list ::= expression */
  {  219,   -3 }, /* (230) expression_list ::= expression_list NK_COMMA expression */
  {  228,   -1 }, /* (231) column_reference ::= column_name */
  {  228,   -3 }, /* (232) column_reference ::= table_name NK_DOT column_name */
  {  227,   -2 }, /* (233) pseudo_column ::= NK_UNDERLINE ROWTS */
  {  227,   -1 }, /* (234) pseudo_column ::= TBNAME */
  {  227,   -2 }, /* (235) pseudo_column ::= NK_UNDERLINE QSTARTTS */
  {  227,   -2 }, /* (236) pseudo_column ::= NK_UNDERLINE QENDTS */
  {  227,   -2 }, /* (237) pseudo_column ::= NK_UNDERLINE WSTARTTS */
  {  227,   -2 }, /* (238) pseudo_column ::= NK_UNDERLINE WENDTS */
  {  227,   -2 }, /* (239) pseudo_column ::= NK_UNDERLINE WDURATION */
  {  230,   -3 }, /* (240) predicate ::= expression compare_op expression */
  {  230,   -5 }, /* (241) predicate ::= expression BETWEEN expression AND expression */
  {  230,   -6 }, /* (242) predicate ::= expression NOT BETWEEN expression AND expression */
  {  230,   -3 }, /* (243) predicate ::= expression IS NULL */
  {  230,   -4 }, /* (244) predicate ::= expression IS NOT NULL */
  {  230,   -3 }, /* (245) predicate ::= expression in_op in_predicate_value */
  {  231,   -1 }, /* (246) compare_op ::= NK_LT */
  {  231,   -1 }, /* (247) compare_op ::= NK_GT */
  {  231,   -1 }, /* (248) compare_op ::= NK_LE */
  {  231,   -1 }, /* (249) compare_op ::= NK_GE */
  {  231,   -1 }, /* (250) compare_op ::= NK_NE */
  {  231,   -1 }, /* (251) compare_op ::= NK_EQ */
  {  231,   -1 }, /* (252) compare_op ::= LIKE */
  {  231,   -2 }, /* (253) compare_op ::= NOT LIKE */
  {  231,   -1 }, /* (254) compare_op ::= MATCH */
  {  231,   -1 }, /* (255) compare_op ::= NMATCH */
  {  232,   -1 }, /* (256) in_op ::= IN */
  {  232,   -2 }, /* (257) in_op ::= NOT IN */
  {  233,   -3 }, /* (258) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  234,   -1 }, /* (259) boolean_value_expression ::= boolean_primary */
  {  234,   -2 }, /* (260) boolean_value_expression ::= NOT boolean_primary */
  {  234,   -3 }, /* (261) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  234,   -3 }, /* (262) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  235,   -1 }, /* (263) boolean_primary ::= predicate */
  {  235,   -3 }, /* (264) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  236,   -1 }, /* (265) common_expression ::= expression */
  {  236,   -1 }, /* (266) common_expression ::= boolean_value_expression */
  {  237,   -2 }, /* (267) from_clause ::= FROM table_reference_list */
  {  238,   -1 }, /* (268) table_reference_list ::= table_reference */
  {  238,   -3 }, /* (269) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  239,   -1 }, /* (270) table_reference ::= table_primary */
  {  239,   -1 }, /* (271) table_reference ::= joined_table */
  {  240,   -2 }, /* (272) table_primary ::= table_name alias_opt */
  {  240,   -4 }, /* (273) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  240,   -2 }, /* (274) table_primary ::= subquery alias_opt */
  {  240,   -1 }, /* (275) table_primary ::= parenthesized_joined_table */
  {  242,    0 }, /* (276) alias_opt ::= */
  {  242,   -1 }, /* (277) alias_opt ::= table_alias */
  {  242,   -2 }, /* (278) alias_opt ::= AS table_alias */
  {  243,   -3 }, /* (279) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  243,   -3 }, /* (280) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  241,   -6 }, /* (281) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  244,    0 }, /* (282) join_type ::= */
  {  244,   -1 }, /* (283) join_type ::= INNER */
  {  246,   -9 }, /* (284) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  247,    0 }, /* (285) set_quantifier_opt ::= */
  {  247,   -1 }, /* (286) set_quantifier_opt ::= DISTINCT */
  {  247,   -1 }, /* (287) set_quantifier_opt ::= ALL */
  {  248,   -1 }, /* (288) select_list ::= NK_STAR */
  {  248,   -1 }, /* (289) select_list ::= select_sublist */
  {  254,   -1 }, /* (290) select_sublist ::= select_item */
  {  254,   -3 }, /* (291) select_sublist ::= select_sublist NK_COMMA select_item */
  {  255,   -1 }, /* (292) select_item ::= common_expression */
  {  255,   -2 }, /* (293) select_item ::= common_expression column_alias */
  {  255,   -3 }, /* (294) select_item ::= common_expression AS column_alias */
  {  255,   -3 }, /* (295) select_item ::= table_name NK_DOT NK_STAR */
  {  249,    0 }, /* (296) where_clause_opt ::= */
  {  249,   -2 }, /* (297) where_clause_opt ::= WHERE search_condition */
  {  250,    0 }, /* (298) partition_by_clause_opt ::= */
  {  250,   -3 }, /* (299) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  251,    0 }, /* (300) twindow_clause_opt ::= */
  {  251,   -6 }, /* (301) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  251,   -4 }, /* (302) twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
  {  251,   -6 }, /* (303) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  251,   -8 }, /* (304) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  217,    0 }, /* (305) sliding_opt ::= */
  {  217,   -4 }, /* (306) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  256,    0 }, /* (307) fill_opt ::= */
  {  256,   -4 }, /* (308) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  256,   -6 }, /* (309) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  257,   -1 }, /* (310) fill_mode ::= NONE */
  {  257,   -1 }, /* (311) fill_mode ::= PREV */
  {  257,   -1 }, /* (312) fill_mode ::= NULL */
  {  257,   -1 }, /* (313) fill_mode ::= LINEAR */
  {  257,   -1 }, /* (314) fill_mode ::= NEXT */
  {  252,    0 }, /* (315) group_by_clause_opt ::= */
  {  252,   -3 }, /* (316) group_by_clause_opt ::= GROUP BY group_by_list */
  {  258,   -1 }, /* (317) group_by_list ::= expression */
  {  258,   -3 }, /* (318) group_by_list ::= group_by_list NK_COMMA expression */
  {  253,    0 }, /* (319) having_clause_opt ::= */
  {  253,   -2 }, /* (320) having_clause_opt ::= HAVING search_condition */
  {  221,   -4 }, /* (321) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  259,   -1 }, /* (322) query_expression_body ::= query_primary */
  {  259,   -4 }, /* (323) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  263,   -1 }, /* (324) query_primary ::= query_specification */
  {  260,    0 }, /* (325) order_by_clause_opt ::= */
  {  260,   -3 }, /* (326) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  261,    0 }, /* (327) slimit_clause_opt ::= */
  {  261,   -2 }, /* (328) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  261,   -4 }, /* (329) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  261,   -4 }, /* (330) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  262,    0 }, /* (331) limit_clause_opt ::= */
  {  262,   -2 }, /* (332) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  262,   -4 }, /* (333) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  262,   -4 }, /* (334) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  229,   -3 }, /* (335) subquery ::= NK_LP query_expression NK_RP */
  {  245,   -1 }, /* (336) search_condition ::= common_expression */
  {  264,   -1 }, /* (337) sort_specification_list ::= sort_specification */
  {  264,   -3 }, /* (338) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  265,   -3 }, /* (339) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  266,    0 }, /* (340) ordering_specification_opt ::= */
  {  266,   -1 }, /* (341) ordering_specification_opt ::= ASC */
  {  266,   -1 }, /* (342) ordering_specification_opt ::= DESC */
  {  267,    0 }, /* (343) null_ordering_opt ::= */
  {  267,   -2 }, /* (344) null_ordering_opt ::= NULLS FIRST */
  {  267,   -2 }, /* (345) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,173,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,174,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,173,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,175,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,176,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,174,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,176,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,175,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy225, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 206: /* db_name ::= NK_ID */ yytestcase(yyruleno==206);
      case 207: /* table_name ::= NK_ID */ yytestcase(yyruleno==207);
      case 208: /* column_name ::= NK_ID */ yytestcase(yyruleno==208);
      case 209: /* function_name ::= NK_ID */ yytestcase(yyruleno==209);
      case 210: /* table_alias ::= NK_ID */ yytestcase(yyruleno==210);
      case 211: /* column_alias ::= NK_ID */ yytestcase(yyruleno==211);
      case 212: /* user_name ::= NK_ID */ yytestcase(yyruleno==212);
      case 213: /* index_name ::= NK_ID */ yytestcase(yyruleno==213);
      case 214: /* topic_name ::= NK_ID */ yytestcase(yyruleno==214);
{ yylhsminor.yy225 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy505, &yymsp[-1].minor.yy225, yymsp[0].minor.yy176); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy505, &yymsp[0].minor.yy225); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy176); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy505 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 285: /* set_quantifier_opt ::= */ yytestcase(yyruleno==285);
{ yymsp[1].minor.yy505 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy505 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy176 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 60: /* db_options ::= db_options KEEP NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 70: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy176 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy176 = setDatabaseOption(pCxt, yylhsminor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 71: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-1].minor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 72: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 73: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_KEEP; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 75: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_WAL; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 80: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==80);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy505, yymsp[-5].minor.yy176, yymsp[-3].minor.yy512, yymsp[-1].minor.yy512, yymsp[0].minor.yy176); }
        break;
      case 79: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy512); }
        break;
      case 81: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy512); }
        break;
      case 82: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy505, yymsp[0].minor.yy176); }
        break;
      case 83: /* cmd ::= ALTER TABLE alter_table_clause */
      case 84: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==84);
      case 185: /* cmd ::= query_expression */ yytestcase(yyruleno==185);
{ pCxt->pRootNode = yymsp[0].minor.yy176; }
        break;
      case 85: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy176 = createAlterTableOption(pCxt, yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 86: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 87: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy176 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy176, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 88: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 89: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy176 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 90: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 91: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy176 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy176, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 92: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 93: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy176 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 94: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy176 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy176, &yymsp[-2].minor.yy225, yymsp[0].minor.yy176); }
  yymsp[-5].minor.yy176 = yylhsminor.yy176;
        break;
      case 95: /* multi_create_clause ::= create_subtable_clause */
      case 98: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==98);
      case 105: /* column_def_list ::= column_def */ yytestcase(yyruleno==105);
      case 148: /* col_name_list ::= col_name */ yytestcase(yyruleno==148);
      case 170: /* func_name_list ::= func_name */ yytestcase(yyruleno==170);
      case 179: /* func_list ::= func */ yytestcase(yyruleno==179);
      case 204: /* literal_list ::= signed_literal */ yytestcase(yyruleno==204);
      case 290: /* select_sublist ::= select_item */ yytestcase(yyruleno==290);
      case 337: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==337);
{ yylhsminor.yy512 = createNodeList(pCxt, yymsp[0].minor.yy176); }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 96: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 99: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==99);
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-1].minor.yy512, yymsp[0].minor.yy176); }
  yymsp[-1].minor.yy512 = yylhsminor.yy512;
        break;
      case 97: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy176 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy505, yymsp[-7].minor.yy176, yymsp[-5].minor.yy176, yymsp[-4].minor.yy512, yymsp[-1].minor.yy512); }
  yymsp[-8].minor.yy176 = yylhsminor.yy176;
        break;
      case 100: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy176 = createDropTableClause(pCxt, yymsp[-1].minor.yy505, yymsp[0].minor.yy176); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 101: /* specific_tags_opt ::= */
      case 132: /* tags_def_opt ::= */ yytestcase(yyruleno==132);
      case 298: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==298);
      case 315: /* group_by_clause_opt ::= */ yytestcase(yyruleno==315);
      case 325: /* order_by_clause_opt ::= */ yytestcase(yyruleno==325);
{ yymsp[1].minor.yy512 = NULL; }
        break;
      case 102: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy512 = yymsp[-1].minor.yy512; }
        break;
      case 103: /* full_table_name ::= table_name */
{ yylhsminor.yy176 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 104: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy176 = createRealTableNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, NULL); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 106: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 149: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==149);
      case 171: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==171);
      case 180: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==180);
      case 205: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==205);
      case 291: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==291);
      case 338: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==338);
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-2].minor.yy512, yymsp[0].minor.yy176); }
  yymsp[-2].minor.yy512 = yylhsminor.yy512;
        break;
      case 107: /* column_def ::= column_name type_name */
{ yylhsminor.yy176 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448, NULL); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 108: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy176 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 109: /* type_name ::= BOOL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 110: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 111: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 112: /* type_name ::= INT */
      case 113: /* type_name ::= INTEGER */ yytestcase(yyruleno==113);
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 114: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 115: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 116: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 117: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 118: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 119: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 120: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 121: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 122: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 123: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 124: /* type_name ::= JSON */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 125: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 126: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 127: /* type_name ::= BLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 128: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 130: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 131: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 133: /* tags_def_opt ::= tags_def */
      case 289: /* select_list ::= select_sublist */ yytestcase(yyruleno==289);
{ yylhsminor.yy512 = yymsp[0].minor.yy512; }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 134: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy512 = yymsp[-1].minor.yy512; }
        break;
      case 135: /* table_options ::= */
{ yymsp[1].minor.yy176 = createDefaultTableOptions(pCxt); }
        break;
      case 136: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 137: /* table_options ::= table_options KEEP NK_INTEGER */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 138: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 139: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy176 = setTableSmaOption(pCxt, yymsp[-4].minor.yy176, yymsp[-1].minor.yy512); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 140: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy176 = setTableRollupOption(pCxt, yymsp[-4].minor.yy176, yymsp[-1].minor.yy512); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 141: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 142: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 143: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy176 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy176 = setTableOption(pCxt, yylhsminor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 144: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-1].minor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 145: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 146: /* alter_table_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 147: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 150: /* col_name ::= column_name */
{ yylhsminor.yy176 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 151: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 152: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 153: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 154: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 155: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 156: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy176, NULL); }
        break;
      case 157: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 158: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 159: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 160: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 161: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 162: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 163: /* db_name_cond_opt ::= */
      case 168: /* from_db_opt ::= */ yytestcase(yyruleno==168);
{ yymsp[1].minor.yy176 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 164: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 165: /* like_pattern_opt ::= */
      case 176: /* index_options ::= */ yytestcase(yyruleno==176);
      case 296: /* where_clause_opt ::= */ yytestcase(yyruleno==296);
      case 300: /* twindow_clause_opt ::= */ yytestcase(yyruleno==300);
      case 305: /* sliding_opt ::= */ yytestcase(yyruleno==305);
      case 307: /* fill_opt ::= */ yytestcase(yyruleno==307);
      case 319: /* having_clause_opt ::= */ yytestcase(yyruleno==319);
      case 327: /* slimit_clause_opt ::= */ yytestcase(yyruleno==327);
      case 331: /* limit_clause_opt ::= */ yytestcase(yyruleno==331);
{ yymsp[1].minor.yy176 = NULL; }
        break;
      case 166: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 167: /* table_name_cond ::= table_name */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 169: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy225); }
        break;
      case 172: /* func_name ::= function_name */
{ yylhsminor.yy176 = createFunctionNode(pCxt, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 173: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy505, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy225, NULL, yymsp[0].minor.yy176); }
        break;
      case 174: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy505, &yymsp[-5].minor.yy225, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy512, NULL); }
        break;
      case 175: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy505, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 177: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy176 = createIndexOption(pCxt, yymsp[-6].minor.yy512, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), NULL, yymsp[0].minor.yy176); }
        break;
      case 178: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy176 = createIndexOption(pCxt, yymsp[-8].minor.yy512, releaseRawExprNode(pCxt, yymsp[-4].minor.yy176), releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), yymsp[0].minor.yy176); }
        break;
      case 181: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy176 = createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy512); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 182: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy505, &yymsp[-2].minor.yy225, yymsp[0].minor.yy176, NULL); }
        break;
      case 183: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy505, &yymsp[-2].minor.yy225, NULL, &yymsp[0].minor.yy225); }
        break;
      case 184: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy505, &yymsp[0].minor.yy225); }
        break;
      case 186: /* literal ::= NK_INTEGER */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 187: /* literal ::= NK_FLOAT */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 188: /* literal ::= NK_STRING */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 189: /* literal ::= NK_BOOL */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 190: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 191: /* literal ::= duration_literal */
      case 199: /* signed_literal ::= signed */ yytestcase(yyruleno==199);
      case 215: /* expression ::= literal */ yytestcase(yyruleno==215);
      case 216: /* expression ::= pseudo_column */ yytestcase(yyruleno==216);
      case 217: /* expression ::= column_reference */ yytestcase(yyruleno==217);
      case 220: /* expression ::= subquery */ yytestcase(yyruleno==220);
      case 259: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==259);
      case 263: /* boolean_primary ::= predicate */ yytestcase(yyruleno==263);
      case 265: /* common_expression ::= expression */ yytestcase(yyruleno==265);
      case 266: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==266);
      case 268: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==268);
      case 270: /* table_reference ::= table_primary */ yytestcase(yyruleno==270);
      case 271: /* table_reference ::= joined_table */ yytestcase(yyruleno==271);
      case 275: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==275);
      case 322: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==322);
      case 324: /* query_primary ::= query_specification */ yytestcase(yyruleno==324);
{ yylhsminor.yy176 = yymsp[0].minor.yy176; }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 192: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 193: /* signed ::= NK_INTEGER */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 194: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 195: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 196: /* signed ::= NK_FLOAT */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 197: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 198: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 200: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 201: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 202: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 203: /* signed_literal ::= duration_literal */
      case 336: /* search_condition ::= common_expression */ yytestcase(yyruleno==336);
{ yylhsminor.yy176 = releaseRawExprNode(pCxt, yymsp[0].minor.yy176); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 218: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy512)); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 219: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy225, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 221: /* expression ::= NK_LP expression NK_RP */
      case 264: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==264);
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176)); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 222: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy176));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 223: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[0].minor.yy176), NULL));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 224: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 225: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 226: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 227: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 228: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 229: /* expression_list ::= expression */
{ yylhsminor.yy512 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176)); }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 230: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-2].minor.yy512, releaseRawExprNode(pCxt, yymsp[0].minor.yy176)); }
  yymsp[-2].minor.yy512 = yylhsminor.yy512;
        break;
      case 231: /* column_reference ::= column_name */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy225, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 232: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225)); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 233: /* pseudo_column ::= NK_UNDERLINE ROWTS */
      case 235: /* pseudo_column ::= NK_UNDERLINE QSTARTTS */ yytestcase(yyruleno==235);
      case 236: /* pseudo_column ::= NK_UNDERLINE QENDTS */ yytestcase(yyruleno==236);
      case 237: /* pseudo_column ::= NK_UNDERLINE WSTARTTS */ yytestcase(yyruleno==237);
      case 238: /* pseudo_column ::= NK_UNDERLINE WENDTS */ yytestcase(yyruleno==238);
      case 239: /* pseudo_column ::= NK_UNDERLINE WDURATION */ yytestcase(yyruleno==239);
{
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy176 = createRawExprNode(pCxt, &t, createFunctionNode(pCxt, &t, NULL));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 234: /* pseudo_column ::= TBNAME */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 240: /* predicate ::= expression compare_op expression */
      case 245: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==245);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy404, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 241: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy176), releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 242: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[-5].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-5].minor.yy176 = yylhsminor.yy176;
        break;
      case 243: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), NULL));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 244: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), NULL));
                                                                                  }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 246: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy404 = OP_TYPE_LOWER_THAN; }
        break;
      case 247: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy404 = OP_TYPE_GREATER_THAN; }
        break;
      case 248: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy404 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 249: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy404 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 250: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy404 = OP_TYPE_NOT_EQUAL; }
        break;
      case 251: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy404 = OP_TYPE_EQUAL; }
        break;
      case 252: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy404 = OP_TYPE_LIKE; }
        break;
      case 253: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy404 = OP_TYPE_NOT_LIKE; }
        break;
      case 254: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy404 = OP_TYPE_MATCH; }
        break;
      case 255: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy404 = OP_TYPE_NMATCH; }
        break;
      case 256: /* in_op ::= IN */
{ yymsp[0].minor.yy404 = OP_TYPE_IN; }
        break;
      case 257: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy404 = OP_TYPE_NOT_IN; }
        break;
      case 258: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy512)); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 260: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy176), NULL));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 261: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 262: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 267: /* from_clause ::= FROM table_reference_list */
      case 297: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==297);
      case 320: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==320);
{ yymsp[-1].minor.yy176 = yymsp[0].minor.yy176; }
        break;
      case 269: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy176 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy176, yymsp[0].minor.yy176, NULL); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 272: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy176 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 273: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy176 = createRealTableNode(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 274: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy176 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 276: /* alias_opt ::= */
{ yymsp[1].minor.yy225 = nil_token;  }
        break;
      case 277: /* alias_opt ::= table_alias */
{ yylhsminor.yy225 = yymsp[0].minor.yy225; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 278: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy225 = yymsp[0].minor.yy225; }
        break;
      case 279: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 280: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==280);
{ yymsp[-2].minor.yy176 = yymsp[-1].minor.yy176; }
        break;
      case 281: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy176 = createJoinTableNode(pCxt, yymsp[-4].minor.yy236, yymsp[-5].minor.yy176, yymsp[-2].minor.yy176, yymsp[0].minor.yy176); }
  yymsp[-5].minor.yy176 = yylhsminor.yy176;
        break;
      case 282: /* join_type ::= */
{ yymsp[1].minor.yy236 = JOIN_TYPE_INNER; }
        break;
      case 283: /* join_type ::= INNER */
{ yymsp[0].minor.yy236 = JOIN_TYPE_INNER; }
        break;
      case 284: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy176 = createSelectStmt(pCxt, yymsp[-7].minor.yy505, yymsp[-6].minor.yy512, yymsp[-5].minor.yy176);
                                                                                    yymsp[-8].minor.yy176 = addWhereClause(pCxt, yymsp[-8].minor.yy176, yymsp[-4].minor.yy176);
                                                                                    yymsp[-8].minor.yy176 = addPartitionByClause(pCxt, yymsp[-8].minor.yy176, yymsp[-3].minor.yy512);
                                                                                    yymsp[-8].minor.yy176 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy176, yymsp[-2].minor.yy176);
                                                                                    yymsp[-8].minor.yy176 = addGroupByClause(pCxt, yymsp[-8].minor.yy176, yymsp[-1].minor.yy512);
                                                                                    yymsp[-8].minor.yy176 = addHavingClause(pCxt, yymsp[-8].minor.yy176, yymsp[0].minor.yy176);
                                                                                  }
        break;
      case 286: /* set_quantifier_opt ::= DISTINCT */
{ yymsp[0].minor.yy505 = true; }
        break;
      case 287: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy505 = false; }
        break;
      case 288: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy512 = NULL; }
        break;
      case 292: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176), &t);
                                                                                  }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 293: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy176 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 294: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy176 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 295: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy176 = createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 299: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 316: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==316);
      case 326: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==326);
{ yymsp[-2].minor.yy512 = yymsp[0].minor.yy512; }
        break;
      case 301: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy176 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), releaseRawExprNode(pCxt, yymsp[-1].minor.yy176)); }
        break;
      case 302: /* twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
{ yymsp[-3].minor.yy176 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176)); }
        break;
      case 303: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy176 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), NULL, yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 304: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy176 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy176), releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 306: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy176 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy176); }
        break;
      case 308: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy176 = createFillNode(pCxt, yymsp[-1].minor.yy142, NULL); }
        break;
      case 309: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy176 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy512)); }
        break;
      case 310: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy142 = FILL_MODE_NONE; }
        break;
      case 311: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy142 = FILL_MODE_PREV; }
        break;
      case 312: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy142 = FILL_MODE_NULL; }
        break;
      case 313: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy142 = FILL_MODE_LINEAR; }
        break;
      case 314: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy142 = FILL_MODE_NEXT; }
        break;
      case 317: /* group_by_list ::= expression */
{ yylhsminor.yy512 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 318: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-2].minor.yy512, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); }
  yymsp[-2].minor.yy512 = yylhsminor.yy512;
        break;
      case 321: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy176 = addOrderByClause(pCxt, yymsp[-3].minor.yy176, yymsp[-2].minor.yy512);
                                                                                    yylhsminor.yy176 = addSlimitClause(pCxt, yylhsminor.yy176, yymsp[-1].minor.yy176);
                                                                                    yylhsminor.yy176 = addLimitClause(pCxt, yylhsminor.yy176, yymsp[0].minor.yy176);
                                                                                  }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 323: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy176 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy176, yymsp[0].minor.yy176); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 328: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 332: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==332);
{ yymsp[-1].minor.yy176 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 329: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 333: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==333);
{ yymsp[-3].minor.yy176 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 330: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 334: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==334);
{ yymsp[-3].minor.yy176 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 335: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy176); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 339: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy176 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), yymsp[-1].minor.yy106, yymsp[0].minor.yy465); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 340: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy106 = ORDER_ASC; }
        break;
      case 341: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy106 = ORDER_ASC; }
        break;
      case 342: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy106 = ORDER_DESC; }
        break;
      case 343: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy465 = NULL_ORDER_DEFAULT; }
        break;
      case 344: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy465 = NULL_ORDER_FIRST; }
        break;
      case 345: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy465 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
