/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 459
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy20;
  SNode* yy74;
  ENullOrder yy109;
  SToken yy317;
  EOrder yy326;
  bool yy335;
  int8_t yy449;
  int64_t yy531;
  EJoinType yy630;
  SAlterOption yy767;
  EFillMode yy828;
  int32_t yy856;
  SNodeList* yy874;
  SDataType yy898;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             715
#define YYNRULE              540
#define YYNTOKEN             324
#define YY_MAX_SHIFT         714
#define YY_MIN_SHIFTREDUCE   1057
#define YY_MAX_SHIFTREDUCE   1596
#define YY_ERROR_ACTION      1597
#define YY_ACCEPT_ACTION     1598
#define YY_NO_ACTION         1599
#define YY_MIN_REDUCE        1600
#define YY_MAX_REDUCE        2139
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2586)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1954,  460, 1743,  461, 1636,  571,  590,   35,  276, 2110,
 /*    10 */   160, 1807,   45,   43, 1526, 1708,  353, 2115,  331, 1865,
 /*    20 */   362, 2110, 1377, 1600,  570,  175,  603, 1805,  354, 2111,
 /*    30 */   572, 1972,  159, 1456, 1612, 1375,  157, 2114, 1403,  586,
 /*    40 */    54, 2111, 2113,  401, 1923, 1756,  619,  124,  123,  122,
 /*    50 */   121,  120,  119,  118,  117,  116,  466, 1754, 1451,  602,
 /*    60 */    38,   37,  462,   18,   44,   42,   41,   40,   39, 1953,
 /*    70 */  1383,  171,  469, 1988,  461, 1636,  102, 1955,  623, 1957,
 /*    80 */  1958,  618,  571,  613, 1794,  547, 2110, 2056,  172, 2110,
 /*    90 */  2041, 1523, 1745,  169,  356, 2037,   14,   60,  603, 1954,
 /*   100 */  1941,  570,  175, 1937, 2116,  175, 2111,  572,  177, 2111,
 /*   110 */   572, 1937,  125, 2053,  334, 1854, 2067,  115,  711,  499,
 /*   120 */   114,  113,  112,  111,  110,  109,  108,  107,  106, 1754,
 /*   130 */  1972, 1933, 1939, 1458, 1459,   48, 1598, 1807,  620, 1933,
 /*   140 */  1939,  345,  613, 1923,  355,  619,   45,   43, 1910, 1563,
 /*   150 */   613, 1260, 1261, 1805,  362, 1731, 1377,  367, 1807, 1954,
 /*   160 */  1800, 1802, 1432, 1441, 1109,  366, 1108, 1456, 1953, 1375,
 /*   170 */   603, 1109, 1988, 1108, 1805,  102, 1955,  623, 1957, 1958,
 /*   180 */   618, 1378,  613, 1376,  180,  136,  212,  143, 2012, 2041,
 /*   190 */  1972,  260, 1451,  356, 2037, 1110,  384,   18,  586,  377,
 /*   200 */   602, 1754, 1110, 1923, 1383,  619, 1381, 1382,  602, 1431,
 /*   210 */  1434, 1435, 1436, 1437, 1438, 1439, 1440,  615,  611, 1449,
 /*   220 */  1450, 1452, 1453, 1454, 1455, 1457, 1460,    2, 1953,   60,
 /*   230 */    14,   87, 1988, 1954,  227,  102, 1955,  623, 1957, 1958,
 /*   240 */   618,  547,  613, 1402,  648, 2110,  178,  172,   82, 2041,
 /*   250 */  1090,  561,  711,  356, 2037,   44,   42,   41,   40,   39,
 /*   260 */  2116,  175,  129,  655, 1972, 2111,  572, 1458, 1459,  267,
 /*   270 */   268, 1749,  620,   64,  266, 2068,   48, 1923, 1402,  619,
 /*   280 */    45,   43,  148,  147,  652,  651,  650,  145,  362, 1092,
 /*   290 */  1377, 1095, 1096, 1954,   84,  322, 1432, 1441,  532,  583,
 /*   300 */   530, 1456, 1953, 1375,  459,  528, 1988,  464, 1642,  102,
 /*   310 */  1955,  623, 1957, 1958,  618, 1378,  613, 1376,  526,   60,
 /*   320 */   524, 2016, 1732, 2041, 1972, 1729, 1451,  356, 2037,  590,
 /*   330 */   133,   18,  620, 1522,  567,  562,  556, 1923, 1383,  619,
 /*   340 */  1381, 1382, 1866, 1431, 1434, 1435, 1436, 1437, 1438, 1439,
 /*   350 */  1440,  615,  611, 1449, 1450, 1452, 1453, 1454, 1455, 1457,
 /*   360 */  1460,    2, 1953,   11,   14,   60, 1988, 1801, 1802,  102,
 /*   370 */  1955,  623, 1957, 1958,  618, 2115,  613,   60,  178, 2110,
 /*   380 */  1807, 2130,   49, 2041,  478, 1623,  711,  356, 2037,  257,
 /*   390 */  2049,  582,  407,  126,  581, 2114, 1806, 2110, 2075, 2111,
 /*   400 */  2112, 1458, 1459,   38,   37,  603,  228,   44,   42,   41,
 /*   410 */    40,   39,  570,  175,   45,   43, 1461, 2111,  572,  125,
 /*   420 */  1313, 1314,  362,  478, 1377,  178,  504, 1954, 1530, 1923,
 /*   430 */  1432, 1441,  320,  655, 1402, 1456, 1754, 1375, 2056,  468,
 /*   440 */    38,   37,  464, 1642,   44,   42,   41,   40,   39, 1378,
 /*   450 */   566, 1376,  148,  147,  652,  651,  650,  145, 1972, 1466,
 /*   460 */  1451,  400,  187,  399, 2052, 1402,  620,  589,  178, 1354,
 /*   470 */  1355, 1923, 1383,  619, 1381, 1382,   27, 1431, 1434, 1435,
 /*   480 */  1436, 1437, 1438, 1439, 1440,  615,  611, 1449, 1450, 1452,
 /*   490 */  1453, 1454, 1455, 1457, 1460,    2, 1953,  169,   46,   79,
 /*   500 */  1988, 1403,   78,  102, 1955,  623, 1957, 1958,  618,  547,
 /*   510 */   613,  510,  509, 2110,  178, 2130, 1972, 2041,  655, 1855,
 /*   520 */   711,  356, 2037, 1622,  565, 1402,  178,   82, 2116,  175,
 /*   530 */   213,  178, 2088, 2111,  572, 1458, 1459,  148,  147,  652,
 /*   540 */   651,  650,  145,   13,   12,  164,  603, 1621,   45,   43,
 /*   550 */  1750,  495,  491,  487,  483,  210,  362, 1837, 1377,  603,
 /*   560 */   405,  682,  680,  564, 1432, 1441,  396, 1923, 1593, 1456,
 /*   570 */  1404, 1375, 1601,  406,   38,   37, 1433, 1754,   44,   42,
 /*   580 */    41,   40,   39, 1378, 2056, 1376, 1405,  398,  394,  443,
 /*   590 */  1754, 1923,   83,  115, 1451,  208,  114,  113,  112,  111,
 /*   600 */   110,  109,  108,  107,  106, 1553, 1383, 1433, 1381, 1382,
 /*   610 */  2051, 1431, 1434, 1435, 1436, 1437, 1438, 1439, 1440,  615,
 /*   620 */   611, 1449, 1450, 1452, 1453, 1454, 1455, 1457, 1460,    2,
 /*   630 */   359,  358,   46, 2115, 1401,  603, 1177,   38,   37, 1499,
 /*   640 */  1391,   44,   42,   41,   40,   39,  657,  191,  190,  415,
 /*   650 */  1404, 1456,  157, 1384,  711,  558, 1551, 1552, 1554, 1555,
 /*   660 */  1620, 1757,  207,  201, 1592,  206, 1754,   31,  474, 1458,
 /*   670 */  1459, 1179, 1619,   38,   37,   99, 1451,   44,   42,   41,
 /*   680 */    40,   39,   45,   43,  199,   41,   40,   39, 1383,  134,
 /*   690 */   362,   11, 1377,  514,  513,  512,  714, 1746, 1432, 1441,
 /*   700 */  1405,  130,  508, 1456, 1923, 1375,  507,  603,  603,  424,
 /*   710 */   283, 1730,  506,  511,  259, 1487, 1923, 1378,  505, 1376,
 /*   720 */  1618,  429,  430, 1617,  408,  168, 1542, 1586, 1451, 1405,
 /*   730 */   237,  704,  700,  696,  692,  281,  609,  409, 1754, 1754,
 /*   740 */  1383,  135, 1381, 1382, 2012, 1431, 1434, 1435, 1436, 1437,
 /*   750 */  1438, 1439, 1440,  615,  611, 1449, 1450, 1452, 1453, 1454,
 /*   760 */  1455, 1457, 1460,    2, 1923, 1616,   14, 1923, 1739,  603,
 /*   770 */   365,  603,  100,  657, 1383,  274,  368,   11,  157,    9,
 /*   780 */   319, 1669, 1400,  476,  157,  477,   32, 1756,  711,  437,
 /*   790 */  1615, 1614,  450, 1756,  259,  449, 1492, 1095, 1096, 1392,
 /*   800 */  1754, 1387, 1754, 1458, 1459, 1611, 1610,   33,  599, 1923,
 /*   810 */   421,  669,  451,   38,   37,  423, 1609,   44,   42,   41,
 /*   820 */    40,   39,   38,   37, 1395, 1397,   44,   42,   41,   40,
 /*   830 */    39, 1608, 1432, 1441, 1923, 1923,  611, 1449, 1450, 1452,
 /*   840 */  1453, 1454, 1455,    8,  184,  262,  514,  513,  512, 1923,
 /*   850 */  1923, 1378,   93, 1376,  130,  508, 1607,  335, 1666,  507,
 /*   860 */  1923,  605, 1348, 2013,  231,  506,  511, 1850,  607,  411,
 /*   870 */  2013,  505, 2114,  236, 1747, 1923, 1381, 1382,  183, 1431,
 /*   880 */  1434, 1435, 1436, 1437, 1438, 1439, 1440,  615,  611, 1449,
 /*   890 */  1450, 1452, 1453, 1454, 1455, 1457, 1460,    2,  229,  447,
 /*   900 */  1923, 1784,  442,  441,  440,  439,  436,  435,  434,  433,
 /*   910 */   432,  428,  427,  426,  425,  336,  418,  417,  416, 1944,
 /*   920 */   413,  412,  333,  688,  687,  686,  685,  372,  583,  684,
 /*   930 */   683,  137,  678,  677,  676,  675,  674,  673,  672,  671,
 /*   940 */   150,  667,  666,  665,  371,  370,  662,  661,  660,  659,
 /*   950 */   658,  158, 1606, 1605, 1402,  235,  296,   38,   37,  133,
 /*   960 */  1377,   44,   42,   41,   40,   39, 1942,  603, 1946,  503,
 /*   970 */   294,   68,  649, 1375,   67, 1798,  603, 1937,  156,   38,
 /*   980 */    37, 1751, 1954,   44,   42,   41,   40,   39, 1850, 1850,
 /*   990 */   141,  502,  195,  456,  454,   85, 1923, 1923, 1754,  185,
 /*  1000 */   189,  653,  339,  575, 1798, 1933, 1939, 1754, 1383, 1604,
 /*  1010 */   603,  654,  327, 1972, 1798, 1741,  613,  585,  173, 2049,
 /*  1020 */  2050,  620,  131, 2054,  543,  670, 1923, 1724,  619,   60,
 /*  1030 */  1217,  645,  644,  643, 1221,  642, 1223, 1224,  641, 1226,
 /*  1040 */   638, 1754, 1232,  635, 1234, 1235,  632,  629, 1519,  290,
 /*  1050 */  1603, 1953, 1784, 1923, 1485, 1988,  711,  603,  102, 1955,
 /*  1060 */   623, 1957, 1958,  618,  340,  613,  338,  337,  101,  501,
 /*  1070 */  2130,  587, 2041,  503, 1954, 1386,  356, 2037,  603, 2061,
 /*  1080 */  1519,  583, 1656,  603,  603,  603,  603,  554, 1754,   50,
 /*  1090 */    69,    3,  271,  146, 1923,  502, 1433,  598,  600,  601,
 /*  1100 */   277,  139,  610,  127,  515, 1972,   76,   75,  404, 1754,
 /*  1110 */  1486,  182,  133,  620, 1754, 1754, 1754, 1754, 1923, 1378,
 /*  1120 */   619, 1376, 1385,  218,  220,  583,  216,  219,  603,  318,
 /*  1130 */  1595, 1596,  392,  574,  390,  386,  382,  379,  376,  578,
 /*  1140 */    77,   62,  369, 1953, 1381, 1382,   53, 1988,  241,  542,
 /*  1150 */   102, 1955,  623, 1957, 1958,  618,  133,  613, 1649, 1754,
 /*  1160 */   375, 1954, 2130,  222, 2041,   47,  221,  224,  356, 2037,
 /*  1170 */   223,  174, 2049, 2050, 1647,  131, 2054, 1737,  178, 2104,
 /*  1180 */   517,   34,  360, 1480, 1481, 1482, 1483, 1484, 1488, 1489,
 /*  1190 */  1490, 1491, 1972,   52, 1550, 1613,  520,  232,  546,  264,
 /*  1200 */   620,  243,  547,  614, 1954, 1923, 2110,  619,  142,  144,
 /*  1210 */   647,  146,   62,   13,   12,  176, 2049, 2050, 1324,  131,
 /*  1220 */  2054, 2116,  175, 1389, 2081,  576, 2111,  572, 1709,  254,
 /*  1230 */  1953,  663, 1954,   47, 1988, 1972,   47,  102, 1955,  623,
 /*  1240 */  1957, 1958,  618,  620,  613, 1477,  664, 1643, 1923, 2130,
 /*  1250 */   619, 2041,  269, 1158,  627,  356, 2037,   98, 1138,  559,
 /*  1260 */   211,  595,  273, 1972, 1210, 1493, 2060,   95, 1156,  248,
 /*  1270 */  1388,  620,  144, 1953, 1973, 1954, 1923, 1988,  619,  146,
 /*  1280 */   102, 1955,  623, 1957, 1958,  618, 1442,  613,  128,  289,
 /*  1290 */   144,  373, 2014, 1139, 2041, 1859,  706, 1637,  356, 2037,
 /*  1300 */   374, 1953, 1795, 2071,  584, 1988, 1972, 1238,  102, 1955,
 /*  1310 */   623, 1957, 1958,  618,  620,  613,  256,  253,    1, 1923,
 /*  1320 */   606,  619, 2041,    4,  378, 1242,  356, 2037,  383, 1341,
 /*  1330 */   535,  284, 1249,  332,  188,  410, 1405, 1860,  414,  445,
 /*  1340 */  1954, 1247,  547,  149, 1953,  419, 2110, 1400, 1988,  431,
 /*  1350 */  1852,  103, 1955,  623, 1957, 1958,  618,  438,  613,  452,
 /*  1360 */   444, 2116,  175,  579, 1954, 2041, 2111,  572,  446, 2040,
 /*  1370 */  2037, 1972,  547,  453, 1406,  458, 2110,  192,  455,  620,
 /*  1380 */   457,  467, 1408, 1954, 1923,  198,  619,  470, 1407,  471,
 /*  1390 */   472, 2116,  175, 1409,  200, 1972, 2111,  572,  473,  203,
 /*  1400 */   475,  205,   80,  620,  479, 1112,   81,  209, 1923, 1953,
 /*  1410 */   619,  496,  497, 1988, 1972,  498,  103, 1955,  623, 1957,
 /*  1420 */  1958,  618,  620,  613,  105,  534,  500, 1923, 1744,  619,
 /*  1430 */  2041,  321, 2072, 1953,  608, 2037, 1954, 1988,  215, 1740,
 /*  1440 */   162, 1955,  623, 1957, 1958,  618,  217,  613,  151,  152,
 /*  1450 */  1742, 1738,  621,  230,  153, 1900, 1988, 1954,  154,  103,
 /*  1460 */  1955,  623, 1957, 1958,  618, 1899,  613, 1972,  537,  538,
 /*  1470 */   536,  285,  541, 2041,  233,  617,  544,  326, 2037, 2082,
 /*  1480 */  1923,  551,  619,  557,  560,  593,  346, 2087, 1972,  239,
 /*  1490 */   242,  563,  573, 2131, 2086,    7,  620,  569,  549, 2063,
 /*  1500 */   552, 1923,  550,  619,  577, 1953,  252, 1519,  250, 1988,
 /*  1510 */  1954, 1941,  312, 1955,  623, 1957, 1958,  618,  616,  613,
 /*  1520 */   604, 2006, 1937,  249,  247,  347, 1953,  580,  132, 1404,
 /*  1530 */  1988, 2109,  588,  161, 1955,  623, 1957, 1958,  618, 2057,
 /*  1540 */   613, 1972,  165,  251,  350,  261,  591,  286,  592,  620,
 /*  1550 */  1933, 1939,  357, 1871, 1923, 1870,  619, 1869,  352, 2133,
 /*  1560 */   287,  613,  255, 1954,  596,   90,   92,  597,  288, 1755,
 /*  1570 */    59,   94, 2022,  625,  548, 2078, 1799,  291,  707, 1953,
 /*  1580 */  1725,  708,  280, 1988, 1954,  710,  103, 1955,  623, 1957,
 /*  1590 */  1958,  618,   51,  613, 1972,  315,  295,  300,  323,  293,
 /*  1600 */  2041,  324,  620, 1917,  314, 2038, 1954, 1923, 1916,  619,
 /*  1610 */   304,   73, 1915, 1914,   74, 1972, 1911,  380,  381, 1369,
 /*  1620 */  1370,  181,  385,  620, 1909,  387,  388,  389, 1923, 1908,
 /*  1630 */   619,  391, 1953, 1907,  393, 1906, 1988, 1972, 1905,  161,
 /*  1640 */  1955,  623, 1957, 1958,  618,  620,  613,  395, 1344,  397,
 /*  1650 */  1923, 1343,  619, 1953, 1882, 1881,  403, 1988,  402, 1880,
 /*  1660 */   306, 1955,  623, 1957, 1958,  618, 1879,  613, 1304, 1845,
 /*  1670 */  1844, 1842, 1954,  138, 1841, 1953, 1840, 1843, 1839, 1988,
 /*  1680 */   186, 2079,  162, 1955,  623, 1957, 1958,  618, 1838,  613,
 /*  1690 */   519, 1836, 1954, 1835, 1834,  420, 1833,  422, 1832, 1831,
 /*  1700 */  1830, 1829, 1828, 1972,  568,  529, 1827, 1826,  351, 1825,
 /*  1710 */  1824,  620, 1823, 1822, 1821, 1820, 1923, 1819,  619,  226,
 /*  1720 */  1818,  140, 1817, 1972, 1816, 1815, 1814, 1813, 1812, 1811,
 /*  1730 */  1306,  617, 1810,  448,  522, 2132, 1923, 1809,  619,  516,
 /*  1740 */  1808, 1953, 1671,  193,  225, 1988, 1185, 1954,  313, 1955,
 /*  1750 */   623, 1957, 1958,  618, 1670,  613, 1668, 1632,   71, 1098,
 /*  1760 */   196, 1953, 1097, 1954, 1631, 1988, 1895,  170,  312, 1955,
 /*  1770 */   623, 1957, 1958,  618,  194,  613,  197, 2007, 1972, 1889,
 /*  1780 */  1943,   66,  463,  361,   65,  465,  620, 1878,   72,  202,
 /*  1790 */   204, 1923, 1877,  619, 1972, 1862, 1733, 1667, 1131,  363,
 /*  1800 */  1665,  481,  620,  480,  482, 1663, 1954, 1923,  484,  619,
 /*  1810 */   486,  485, 1661,  490, 1659,  488, 1953,  489,  492, 1646,
 /*  1820 */  1988,  494, 1645,  313, 1955,  623, 1957, 1958,  618,  493,
 /*  1830 */   613, 1628, 1953, 1735,  214,   61, 1988, 1972, 1254,  313,
 /*  1840 */  1955,  623, 1957, 1958,  618,  620,  613, 1253, 1734, 1954,
 /*  1850 */  1923, 1176,  619, 1175,  679, 1174, 1168,  681, 1173, 1170,
 /*  1860 */  1657, 1169, 1167,  341, 1650, 1954,  342,  518, 1648,  343,
 /*  1870 */   521, 1627, 1626,  523,  525,  533, 1625,  527,  104, 1988,
 /*  1880 */  1972, 1359,  308, 1955,  623, 1957, 1958,  618,  620,  613,
 /*  1890 */   531, 1358, 1894, 1923,   26,  619, 1972, 1350, 1361, 1888,
 /*  1900 */   539, 1876, 1874,   55,  620,  155, 2115,  540, 1565, 1923,
 /*  1910 */   234,  619,   16,   19,   58,  344, 1954,  545, 1953,  245,
 /*  1920 */   553,    5, 1988,   30,   28,  297, 1955,  623, 1957, 1958,
 /*  1930 */   618,  246,  613, 1954, 1953,  555,  238, 1944, 1988,    6,
 /*  1940 */   240,  298, 1955,  623, 1957, 1958,  618, 1972,  613, 1549,
 /*  1950 */   163,   63,   20,  244,   21,  620, 1541,   29, 1580,   86,
 /*  1960 */  1923, 1579,  619, 1585, 1972,  348, 1584, 1583,  349,  258,
 /*  1970 */  1586, 1516,  620,   57, 1515,  166, 1875, 1923, 1873,  619,
 /*  1980 */  1872,   22,  594,  263, 1547, 1953, 1861,  265, 1954, 1988,
 /*  1990 */    17,  270,  299, 1955,  623, 1957, 1958,  618,   56,  613,
 /*  2000 */    88,   89, 1953,   91,   95,  275, 1988, 1954,   23,  305,
 /*  2010 */  1955,  623, 1957, 1958,  618,  272,  613, 1468,   10, 1972,
 /*  2020 */    12, 1467, 1393, 1991,  167, 1424,  179,  620,  624,  626,
 /*  2030 */   612, 1954, 1923, 1446,  619, 1478,  364, 1444, 1972,   36,
 /*  2040 */   622, 1443,   15,   24,  630,   25,  620, 1416, 1239,  628,
 /*  2050 */   631, 1923, 1236,  619, 1233,  633,  634, 1953, 1227,  636,
 /*  2060 */  1225, 1988, 1972,  637,  309, 1955,  623, 1957, 1958,  618,
 /*  2070 */   620,  613,  639, 1216,  646, 1923, 1953,  619,  640, 1231,
 /*  2080 */  1988,   96,  278,  301, 1955,  623, 1957, 1958,  618, 1954,
 /*  2090 */   613, 1230, 1229, 1228,   97, 1248, 1244,  656,   70, 1129,
 /*  2100 */  1953, 1164, 1163, 1162, 1988, 1954, 1161,  310, 1955,  623,
 /*  2110 */  1957, 1958,  618, 1160,  613, 1159, 1157, 1155, 1154, 1153,
 /*  2120 */  1972,  668, 1183,  279, 1149, 1151, 1150, 1148,  620, 1147,
 /*  2130 */  1146, 1145, 1144, 1923, 1180,  619, 1972, 1135, 1178, 1141,
 /*  2140 */  1664, 1140,  690, 1137,  620, 1136, 1134,  689, 1954, 1923,
 /*  2150 */  1662,  619,  691,  693, 1660,  695,  697,  694, 1953,  699,
 /*  2160 */  1658,  701, 1988,  703, 1954,  302, 1955,  623, 1957, 1958,
 /*  2170 */   618,  698,  613,  702, 1953,  282,  705, 1087, 1988, 1972,
 /*  2180 */  1644,  311, 1955,  623, 1957, 1958,  618,  620,  613, 1624,
 /*  2190 */   709,  712, 1923, 1379,  619, 1972,  292,  713, 1599, 1599,
 /*  2200 */  1599, 1599, 1599,  620, 1599, 1599, 1599, 1954, 1923, 1599,
 /*  2210 */   619, 1599, 1599, 1599, 1599, 1599, 1599, 1953, 1599, 1599,
 /*  2220 */  1599, 1988, 1599, 1954,  303, 1955,  623, 1957, 1958,  618,
 /*  2230 */  1599,  613, 1599, 1953, 1599, 1599, 1599, 1988, 1972, 1599,
 /*  2240 */   316, 1955,  623, 1957, 1958,  618,  620,  613, 1599, 1599,
 /*  2250 */  1599, 1923, 1599,  619, 1972, 1599, 1599, 1599, 1599, 1599,
 /*  2260 */  1599, 1599,  620, 1599, 1599, 1599, 1954, 1923, 1599,  619,
 /*  2270 */  1599, 1599, 1599, 1599, 1599, 1599, 1953, 1599, 1599, 1599,
 /*  2280 */  1988, 1599, 1599,  317, 1955,  623, 1957, 1958,  618, 1599,
 /*  2290 */   613, 1599, 1953, 1599, 1599, 1599, 1988, 1972, 1599, 1966,
 /*  2300 */  1955,  623, 1957, 1958,  618,  620,  613, 1599, 1599, 1599,
 /*  2310 */  1923, 1599,  619, 1599, 1599, 1599, 1599, 1954, 1599, 1599,
 /*  2320 */  1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599,
 /*  2330 */  1599, 1599, 1599, 1599, 1954, 1953, 1599, 1599, 1599, 1988,
 /*  2340 */  1599, 1599, 1965, 1955,  623, 1957, 1958,  618, 1972,  613,
 /*  2350 */  1599, 1599, 1599, 1599, 1599, 1599,  620, 1599, 1599, 1599,
 /*  2360 */  1954, 1923, 1599,  619, 1599, 1972, 1599, 1599, 1599, 1599,
 /*  2370 */  1599, 1599, 1599,  620, 1599, 1599, 1599, 1599, 1923, 1599,
 /*  2380 */   619, 1599, 1599, 1599, 1599, 1599, 1953, 1599, 1599, 1599,
 /*  2390 */  1988, 1972, 1599, 1964, 1955,  623, 1957, 1958,  618,  620,
 /*  2400 */   613, 1599, 1599, 1953, 1923, 1599,  619, 1988, 1599, 1599,
 /*  2410 */   328, 1955,  623, 1957, 1958,  618, 1954,  613, 1599, 1599,
 /*  2420 */  1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1599, 1953,
 /*  2430 */  1599, 1599, 1954, 1988, 1599, 1599,  329, 1955,  623, 1957,
 /*  2440 */  1958,  618, 1599,  613, 1599, 1599, 1599, 1972, 1599, 1599,
 /*  2450 */  1599, 1599, 1599, 1599, 1599,  620, 1599, 1599, 1599, 1599,
 /*  2460 */  1923, 1599,  619, 1972, 1599, 1599, 1599, 1599, 1599, 1599,
 /*  2470 */  1599,  620, 1599, 1599, 1599, 1599, 1923, 1599,  619, 1599,
 /*  2480 */  1599, 1599, 1599, 1599, 1599, 1953, 1954, 1599, 1599, 1988,
 /*  2490 */  1599, 1599,  325, 1955,  623, 1957, 1958,  618, 1599,  613,
 /*  2500 */  1599, 1953, 1954, 1599, 1599, 1988, 1599, 1599,  330, 1955,
 /*  2510 */   623, 1957, 1958,  618, 1599,  613, 1599, 1972, 1599, 1599,
 /*  2520 */  1599, 1599, 1599, 1599, 1599,  620, 1599, 1599, 1599, 1599,
 /*  2530 */  1923, 1599,  619, 1972, 1599, 1599, 1599, 1599, 1599, 1599,
 /*  2540 */  1599,  620, 1599, 1599, 1599, 1599, 1923, 1599,  619, 1599,
 /*  2550 */  1599, 1599, 1599, 1599, 1599,  621, 1599, 1599, 1599, 1988,
 /*  2560 */  1599, 1599,  308, 1955,  623, 1957, 1958,  618, 1599,  613,
 /*  2570 */  1599, 1953, 1599, 1599, 1599, 1988, 1599, 1599,  307, 1955,
 /*  2580 */   623, 1957, 1958,  618, 1599,  613,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   327,  331,  359,  333,  334,  429,  373,  418,  419,  433,
 /*    10 */   342,  358,   12,   13,   14,  347,  383,  429,  365,  386,
 /*    20 */    20,  433,   22,    0,  448,  449,  335,  374,  350,  453,
 /*    30 */   454,  358,  326,   33,  328,   35,  358,  449,   20,  366,
 /*    40 */   349,  453,  454,  387,  371,  367,  373,   24,   25,   26,
 /*    50 */    27,   28,   29,   30,   31,   32,   14,  366,   58,   20,
 /*    60 */     8,    9,   20,   63,   12,   13,   14,   15,   16,  396,
 /*    70 */    70,  357,  331,  400,  333,  334,  403,  404,  405,  406,
 /*    80 */   407,  408,  429,  410,  370,  429,  433,  402,  415,  433,
 /*    90 */   417,    4,  360,  358,  421,  422,   96,   96,  335,  327,
 /*   100 */   360,  448,  449,  371,  448,  449,  453,  454,  435,  453,
 /*   110 */   454,  371,  349,  428,  379,  380,  443,   21,  118,  356,
 /*   120 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  366,
 /*   130 */   358,  399,  400,  133,  134,   96,  324,  358,  366,  399,
 /*   140 */   400,  401,  410,  371,  365,  373,   12,   13,    0,   97,
 /*   150 */   410,  133,  134,  374,   20,    0,   22,  369,  358,  327,
 /*   160 */   372,  373,  162,  163,   20,  365,   22,   33,  396,   35,
 /*   170 */   335,   20,  400,   22,  374,  403,  404,  405,  406,  407,
 /*   180 */   408,  181,  410,  183,  349,  413,   35,  415,  416,  417,
 /*   190 */   358,   58,   58,  421,  422,   51,   48,   63,  366,  387,
 /*   200 */    20,  366,   51,  371,   70,  373,  206,  207,   20,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  396,   96,
 /*   230 */    96,   98,  400,  327,  128,  403,  404,  405,  406,  407,
 /*   240 */   408,  429,  410,   20,  107,  433,  245,  415,  341,  417,
 /*   250 */     4,  167,  118,  421,  422,   12,   13,   14,   15,   16,
 /*   260 */   448,  449,  355,  108,  358,  453,  454,  133,  134,  127,
 /*   270 */   128,  364,  366,    4,  132,  443,   96,  371,   20,  373,
 /*   280 */    12,   13,  127,  128,  129,  130,  131,  132,   20,   43,
 /*   290 */    22,   45,   46,  327,  188,  189,  162,  163,  192,  335,
 /*   300 */   194,   33,  396,   35,  332,   21,  400,  335,  336,  403,
 /*   310 */   404,  405,  406,  407,  408,  181,  410,  183,   34,   96,
 /*   320 */    36,  415,    0,  417,  358,    0,   58,  421,  422,  373,
 /*   330 */   366,   63,  366,  246,  250,  251,  252,  371,   70,  373,
 /*   340 */   206,  207,  386,  209,  210,  211,  212,  213,  214,  215,
 /*   350 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   360 */   226,  227,  396,  229,   96,   96,  400,  372,  373,  403,
 /*   370 */   404,  405,  406,  407,  408,  429,  410,   96,  245,  433,
 /*   380 */   358,  415,   96,  417,   62,  327,  118,  421,  422,  425,
 /*   390 */   426,  427,  335,  429,  430,  449,  374,  433,  432,  453,
 /*   400 */   454,  133,  134,    8,    9,  335,  127,   12,   13,   14,
 /*   410 */    15,   16,  448,  449,   12,   13,   14,  453,  454,  349,
 /*   420 */   162,  163,   20,   62,   22,  245,  356,  327,   14,  371,
 /*   430 */   162,  163,  375,  108,   20,   33,  366,   35,  402,  332,
 /*   440 */     8,    9,  335,  336,   12,   13,   14,   15,   16,  181,
 /*   450 */    20,  183,  127,  128,  129,  130,  131,  132,  358,   14,
 /*   460 */    58,  180,   58,  182,  428,   20,  366,  387,  245,  190,
 /*   470 */   191,  371,   70,  373,  206,  207,   44,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   490 */   222,  223,  224,  225,  226,  227,  396,  358,   96,   95,
 /*   500 */   400,   20,   98,  403,  404,  405,  406,  407,  408,  429,
 /*   510 */   410,  344,  345,  433,  245,  415,  358,  417,  108,  380,
 /*   520 */   118,  421,  422,  327,  366,   20,  245,  341,  448,  449,
 /*   530 */    33,  245,  432,  453,  454,  133,  134,  127,  128,  129,
 /*   540 */   130,  131,  132,    1,    2,   48,  335,  327,   12,   13,
 /*   550 */   364,   54,   55,   56,   57,   58,   20,    0,   22,  335,
 /*   560 */   349,  344,  345,  405,  162,  163,  176,  371,  173,   33,
 /*   570 */    20,   35,    0,  349,    8,    9,  162,  366,   12,   13,
 /*   580 */    14,   15,   16,  181,  402,  183,   20,  197,  198,   80,
 /*   590 */   366,  371,   95,   21,   58,   98,   24,   25,   26,   27,
 /*   600 */    28,   29,   30,   31,   32,  206,   70,  162,  206,  207,
 /*   610 */   428,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   620 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   630 */    12,   13,   96,    3,   20,  335,   35,    8,    9,   97,
 /*   640 */    22,   12,   13,   14,   15,   16,   62,  138,  139,  349,
 /*   650 */    20,   33,  358,   35,  118,  256,  257,  258,  259,  260,
 /*   660 */   327,  367,  165,  166,  269,  168,  366,    2,  171,  133,
 /*   670 */   134,   70,  327,    8,    9,  339,   58,   12,   13,   14,
 /*   680 */    15,   16,   12,   13,  187,   14,   15,   16,   70,  353,
 /*   690 */    20,  229,   22,   65,   66,   67,   19,  361,  162,  163,
 /*   700 */    20,   73,   74,   33,  371,   35,   78,  335,  335,  152,
 /*   710 */    33,    0,   84,   85,  164,  161,  371,  181,   90,  183,
 /*   720 */   327,  349,  349,  327,   22,   48,   97,   97,   58,   20,
 /*   730 */   164,   54,   55,   56,   57,   58,  118,   35,  366,  366,
 /*   740 */    70,  413,  206,  207,  416,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   760 */   224,  225,  226,  227,  371,  327,   96,  371,  359,  335,
 /*   770 */   350,  335,   95,   62,   70,   98,  350,  229,  358,  231,
 /*   780 */    18,    0,   20,  349,  358,  349,  232,  367,  118,   27,
 /*   790 */   327,  327,   30,  367,  164,   33,  242,   45,   46,  181,
 /*   800 */   366,  183,  366,  133,  134,  327,  327,    2,  131,  371,
 /*   810 */    48,   70,   50,    8,    9,   53,  327,   12,   13,   14,
 /*   820 */    15,   16,    8,    9,  206,  207,   12,   13,   14,   15,
 /*   830 */    16,  327,  162,  163,  371,  371,  218,  219,  220,  221,
 /*   840 */   222,  223,  224,   39,  164,  168,   65,   66,   67,  371,
 /*   850 */   371,  181,  339,  183,   73,   74,  327,   95,    0,   78,
 /*   860 */   371,  414,  185,  416,  187,   84,   85,  366,  414,  107,
 /*   870 */   416,   90,    3,  164,  361,  371,  206,  207,  377,  209,
 /*   880 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   890 */   220,  221,  222,  223,  224,  225,  226,  227,  351,  137,
 /*   900 */   371,  354,  140,  141,  142,  143,  144,  145,  146,  147,
 /*   910 */   148,  149,  150,  151,  152,  153,  154,  155,  156,   47,
 /*   920 */   158,  159,  160,   65,   66,   67,   68,   69,  335,   71,
 /*   930 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   940 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   950 */    92,   18,  327,  327,   20,   58,   23,    8,    9,  366,
 /*   960 */    22,   12,   13,   14,   15,   16,  360,  335,   96,  108,
 /*   970 */    37,   38,  368,   35,   41,  371,  335,  371,  164,    8,
 /*   980 */     9,  349,  327,   12,   13,   14,   15,   16,  366,  366,
 /*   990 */   349,  130,   59,   60,   61,   98,  371,  371,  366,  377,
 /*  1000 */   377,  368,   37,   44,  371,  399,  400,  366,   70,  327,
 /*  1010 */   335,  368,   63,  358,  371,  359,  410,  424,  425,  426,
 /*  1020 */   427,  366,  429,  430,  349,  346,  371,  348,  373,   96,
 /*  1030 */   109,  110,  111,  112,  113,  114,  115,  116,  117,  118,
 /*  1040 */   119,  366,  121,  122,  123,  124,  125,  126,  244,  351,
 /*  1050 */   327,  396,  354,  371,  105,  400,  118,  335,  403,  404,
 /*  1060 */   405,  406,  407,  408,   99,  410,  101,  102,  135,  104,
 /*  1070 */   415,  349,  417,  108,  327,   35,  421,  422,  335,  243,
 /*  1080 */   244,  335,    0,  335,  335,  335,  335,  432,  366,   42,
 /*  1090 */   107,   44,  349,   44,  371,  130,  162,  349,  349,  349,
 /*  1100 */   349,   42,   63,   44,   22,  358,  173,  174,  175,  366,
 /*  1110 */   161,  178,  366,  366,  366,  366,  366,  366,  371,  181,
 /*  1120 */   373,  183,   35,  100,  100,  335,  103,  103,  335,  196,
 /*  1130 */   133,  134,  199,  264,  201,  202,  203,  204,  205,   44,
 /*  1140 */   157,   44,  349,  396,  206,  207,   97,  400,   44,  391,
 /*  1150 */   403,  404,  405,  406,  407,  408,  366,  410,    0,  366,
 /*  1160 */   387,  327,  415,  100,  417,   44,  103,  100,  421,  422,
 /*  1170 */   103,  425,  426,  427,    0,  429,  430,  359,  245,  432,
 /*  1180 */    22,  232,  233,  234,  235,  236,  237,  238,  239,  240,
 /*  1190 */   241,  242,  358,  164,   97,  328,   22,  359,  169,   44,
 /*  1200 */   366,   97,  429,  359,  327,  371,  433,  373,   44,   44,
 /*  1210 */   359,   44,   44,    1,    2,  425,  426,  427,   97,  429,
 /*  1220 */   430,  448,  449,  183,  381,  266,  453,  454,  347,  457,
 /*  1230 */   396,   13,  327,   44,  400,  358,   44,  403,  404,  405,
 /*  1240 */   406,  407,  408,  366,  410,  206,   13,    0,  371,  415,
 /*  1250 */   373,  417,   97,   35,   44,  421,  422,   96,   35,  446,
 /*  1260 */   337,   97,   97,  358,   97,   97,  432,  106,   35,  440,
 /*  1270 */   183,  366,   44,  396,  358,  327,  371,  400,  373,   44,
 /*  1280 */   403,  404,  405,  406,  407,  408,   97,  410,   44,   97,
 /*  1290 */    44,  337,  415,   70,  417,  381,   49,  334,  421,  422,
 /*  1300 */   387,  396,  370,  381,  431,  400,  358,   97,  403,  404,
 /*  1310 */   405,  406,  407,  408,  366,  410,  450,  423,  434,  371,
 /*  1320 */   415,  373,  417,  247,  398,   97,  421,  422,   48,  179,
 /*  1330 */   387,  389,   97,  397,   42,  378,   20,  381,  378,  161,
 /*  1340 */   327,   97,  429,   97,  396,  376,  433,   20,  400,  335,
 /*  1350 */   335,  403,  404,  405,  406,  407,  408,  378,  410,   94,
 /*  1360 */   376,  448,  449,  268,  327,  417,  453,  454,  376,  421,
 /*  1370 */   422,  358,  429,  343,   20,  329,  433,  335,  335,  366,
 /*  1380 */   335,  329,   20,  327,  371,  341,  373,  393,   20,  373,
 /*  1390 */   336,  448,  449,   20,  341,  358,  453,  454,  388,  341,
 /*  1400 */   336,  341,  341,  366,  335,   52,  341,  341,  371,  396,
 /*  1410 */   373,  338,  338,  400,  358,  329,  403,  404,  405,  406,
 /*  1420 */   407,  408,  366,  410,  335,  195,  358,  371,  358,  373,
 /*  1430 */   417,  329,  381,  396,  421,  422,  327,  400,  358,  358,
 /*  1440 */   403,  404,  405,  406,  407,  408,  358,  410,  358,  358,
 /*  1450 */   358,  358,  396,  339,  358,  371,  400,  327,  358,  403,
 /*  1460 */   404,  405,  406,  407,  408,  371,  410,  358,  186,  392,
 /*  1470 */   395,  393,  373,  417,  339,  366,  335,  421,  422,  381,
 /*  1480 */   371,  371,  373,  371,  255,  254,  371,  439,  358,  384,
 /*  1490 */   384,  371,  455,  456,  439,  261,  366,  172,  248,  442,
 /*  1500 */   263,  371,  262,  373,  265,  396,  398,  244,  437,  400,
 /*  1510 */   327,  360,  403,  404,  405,  406,  407,  408,  409,  410,
 /*  1520 */   411,  412,  371,  438,  441,  270,  396,  267,  366,   20,
 /*  1530 */   400,  452,  335,  403,  404,  405,  406,  407,  408,  402,
 /*  1540 */   410,  358,  439,  436,  336,  339,  371,  384,  371,  366,
 /*  1550 */   399,  400,  401,  371,  371,  371,  373,  371,  371,  458,
 /*  1560 */   384,  410,  451,  327,  166,  339,  339,  382,  354,  366,
 /*  1570 */    96,   96,  420,  362,  444,  445,  371,  335,   36,  396,
 /*  1580 */   348,  330,  339,  400,  327,  329,  403,  404,  405,  406,
 /*  1590 */   407,  408,  390,  410,  358,  394,  325,  352,  385,  340,
 /*  1600 */   417,  385,  366,    0,  352,  422,  327,  371,    0,  373,
 /*  1610 */   352,  188,    0,    0,   42,  358,    0,   35,  200,   35,
 /*  1620 */    35,   35,  200,  366,    0,   35,   35,  200,  371,    0,
 /*  1630 */   373,  200,  396,    0,   35,    0,  400,  358,    0,  403,
 /*  1640 */   404,  405,  406,  407,  408,  366,  410,   22,  183,   35,
 /*  1650 */   371,  181,  373,  396,    0,    0,  176,  400,  177,    0,
 /*  1660 */   403,  404,  405,  406,  407,  408,    0,  410,   47,    0,
 /*  1670 */     0,    0,  327,   42,    0,  396,    0,    0,    0,  400,
 /*  1680 */   152,  445,  403,  404,  405,  406,  407,  408,    0,  410,
 /*  1690 */     4,    0,  327,    0,    0,   35,    0,  152,    0,    0,
 /*  1700 */     0,    0,    0,  358,  447,   19,    0,    0,  363,    0,
 /*  1710 */     0,  366,    0,    0,    0,    0,  371,    0,  373,   33,
 /*  1720 */     0,   42,    0,  358,    0,    0,    0,    0,    0,    0,
 /*  1730 */    22,  366,    0,  136,   48,  456,  371,    0,  373,   53,
 /*  1740 */     0,  396,    0,   58,   58,  400,   35,  327,  403,  404,
 /*  1750 */   405,  406,  407,  408,    0,  410,    0,    0,   39,   14,
 /*  1760 */    42,  396,   14,  327,    0,  400,    0,   44,  403,  404,
 /*  1770 */   405,  406,  407,  408,   58,  410,   40,  412,  358,    0,
 /*  1780 */    47,   95,   47,  363,   98,   47,  366,    0,   39,   39,
 /*  1790 */   172,  371,    0,  373,  358,    0,    0,    0,   64,  363,
 /*  1800 */     0,   48,  366,   35,   39,    0,  327,  371,   35,  373,
 /*  1810 */    39,   48,    0,   39,    0,   35,  396,   48,   35,    0,
 /*  1820 */   400,   39,    0,  403,  404,  405,  406,  407,  408,   48,
 /*  1830 */   410,    0,  396,    0,  103,  105,  400,  358,   35,  403,
 /*  1840 */   404,  405,  406,  407,  408,  366,  410,   22,    0,  327,
 /*  1850 */   371,   35,  373,   35,   44,   35,   22,   44,   35,   35,
 /*  1860 */     0,   35,   35,   22,    0,  327,   22,   50,    0,   22,
 /*  1870 */    35,    0,    0,   35,   35,  396,    0,   22,   20,  400,
 /*  1880 */   358,   35,  403,  404,  405,  406,  407,  408,  366,  410,
 /*  1890 */   193,   35,    0,  371,   96,  373,  358,   35,   97,    0,
 /*  1900 */    22,    0,    0,  164,  366,  184,    3,  164,   97,  371,
 /*  1910 */   166,  373,  249,   44,   44,  164,  327,  170,  396,   44,
 /*  1920 */   228,  169,  400,   44,   96,  403,  404,  405,  406,  407,
 /*  1930 */   408,   47,  410,  327,  396,  253,   96,   47,  400,  169,
 /*  1940 */    97,  403,  404,  405,  406,  407,  408,  358,  410,   97,
 /*  1950 */    96,    3,  249,   96,   44,  366,   97,   96,   35,   96,
 /*  1960 */   371,   35,  373,   97,  358,   35,   35,   35,   35,   47,
 /*  1970 */    97,   97,  366,   44,   97,   47,    0,  371,    0,  373,
 /*  1980 */     0,   96,  167,   97,   97,  396,    0,   96,  327,  400,
 /*  1990 */   249,   96,  403,  404,  405,  406,  407,  408,  243,  410,
 /*  2000 */    96,   39,  396,   96,  106,   47,  400,  327,   44,  403,
 /*  2010 */   404,  405,  406,  407,  408,  165,  410,  228,  230,  358,
 /*  2020 */     2,  228,   22,   96,   47,   22,   47,  366,  107,   35,
 /*  2030 */    96,  327,  371,   97,  373,  206,   35,   97,  358,   96,
 /*  2040 */   208,   97,   96,   96,   35,   96,  366,   97,   97,   96,
 /*  2050 */    96,  371,   97,  373,   97,   35,   96,  396,   97,   35,
 /*  2060 */    97,  400,  358,   96,  403,  404,  405,  406,  407,  408,
 /*  2070 */   366,  410,   35,   22,  108,  371,  396,  373,   96,  120,
 /*  2080 */   400,   96,   44,  403,  404,  405,  406,  407,  408,  327,
 /*  2090 */   410,  120,  120,  120,   96,   35,   22,   63,   96,   64,
 /*  2100 */   396,   35,   35,   35,  400,  327,   35,  403,  404,  405,
 /*  2110 */   406,  407,  408,   35,  410,   35,   35,   35,   35,   35,
 /*  2120 */   358,   93,   70,   44,   22,   35,   35,   35,  366,   22,
 /*  2130 */    35,   35,   35,  371,   70,  373,  358,   22,   35,   35,
 /*  2140 */     0,   35,   48,   35,  366,   35,   35,   35,  327,  371,
 /*  2150 */     0,  373,   39,   35,    0,   39,   35,   48,  396,   39,
 /*  2160 */     0,   35,  400,   39,  327,  403,  404,  405,  406,  407,
 /*  2170 */   408,   48,  410,   48,  396,   22,   35,   35,  400,  358,
 /*  2180 */     0,  403,  404,  405,  406,  407,  408,  366,  410,    0,
 /*  2190 */    21,   21,  371,   22,  373,  358,   22,   20,  459,  459,
 /*  2200 */   459,  459,  459,  366,  459,  459,  459,  327,  371,  459,
 /*  2210 */   373,  459,  459,  459,  459,  459,  459,  396,  459,  459,
 /*  2220 */   459,  400,  459,  327,  403,  404,  405,  406,  407,  408,
 /*  2230 */   459,  410,  459,  396,  459,  459,  459,  400,  358,  459,
 /*  2240 */   403,  404,  405,  406,  407,  408,  366,  410,  459,  459,
 /*  2250 */   459,  371,  459,  373,  358,  459,  459,  459,  459,  459,
 /*  2260 */   459,  459,  366,  459,  459,  459,  327,  371,  459,  373,
 /*  2270 */   459,  459,  459,  459,  459,  459,  396,  459,  459,  459,
 /*  2280 */   400,  459,  459,  403,  404,  405,  406,  407,  408,  459,
 /*  2290 */   410,  459,  396,  459,  459,  459,  400,  358,  459,  403,
 /*  2300 */   404,  405,  406,  407,  408,  366,  410,  459,  459,  459,
 /*  2310 */   371,  459,  373,  459,  459,  459,  459,  327,  459,  459,
 /*  2320 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2330 */   459,  459,  459,  459,  327,  396,  459,  459,  459,  400,
 /*  2340 */   459,  459,  403,  404,  405,  406,  407,  408,  358,  410,
 /*  2350 */   459,  459,  459,  459,  459,  459,  366,  459,  459,  459,
 /*  2360 */   327,  371,  459,  373,  459,  358,  459,  459,  459,  459,
 /*  2370 */   459,  459,  459,  366,  459,  459,  459,  459,  371,  459,
 /*  2380 */   373,  459,  459,  459,  459,  459,  396,  459,  459,  459,
 /*  2390 */   400,  358,  459,  403,  404,  405,  406,  407,  408,  366,
 /*  2400 */   410,  459,  459,  396,  371,  459,  373,  400,  459,  459,
 /*  2410 */   403,  404,  405,  406,  407,  408,  327,  410,  459,  459,
 /*  2420 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  396,
 /*  2430 */   459,  459,  327,  400,  459,  459,  403,  404,  405,  406,
 /*  2440 */   407,  408,  459,  410,  459,  459,  459,  358,  459,  459,
 /*  2450 */   459,  459,  459,  459,  459,  366,  459,  459,  459,  459,
 /*  2460 */   371,  459,  373,  358,  459,  459,  459,  459,  459,  459,
 /*  2470 */   459,  366,  459,  459,  459,  459,  371,  459,  373,  459,
 /*  2480 */   459,  459,  459,  459,  459,  396,  327,  459,  459,  400,
 /*  2490 */   459,  459,  403,  404,  405,  406,  407,  408,  459,  410,
 /*  2500 */   459,  396,  327,  459,  459,  400,  459,  459,  403,  404,
 /*  2510 */   405,  406,  407,  408,  459,  410,  459,  358,  459,  459,
 /*  2520 */   459,  459,  459,  459,  459,  366,  459,  459,  459,  459,
 /*  2530 */   371,  459,  373,  358,  459,  459,  459,  459,  459,  459,
 /*  2540 */   459,  366,  459,  459,  459,  459,  371,  459,  373,  459,
 /*  2550 */   459,  459,  459,  459,  459,  396,  459,  459,  459,  400,
 /*  2560 */   459,  459,  403,  404,  405,  406,  407,  408,  459,  410,
 /*  2570 */   459,  396,  459,  459,  459,  400,  459,  459,  403,  404,
 /*  2580 */   405,  406,  407,  408,  459,  410,
};
#define YY_SHIFT_COUNT    (714)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2189)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   933,    0,  134,    0,  268,  268,  268,  268,  268,  268,
 /*    10 */   268,  268,  268,  268,  268,  402,  536,  536,  670,  536,
 /*    20 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*    30 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*    40 */   536,  536,  536,  536,  536,  536,  536,  536,  180,  223,
 /*    50 */    39,  281,  133,    1,  286,    1,   39,   39,  618,  618,
 /*    60 */     1,  618,  618,  269,    1,  188,  188,  246,  246,  258,
 /*    70 */    18,   42,   42,  188,  188,  188,  188,  188,  188,  188,
 /*    80 */   188,  188,  188,  361,  188,  188,  430,  188,  481,  188,
 /*    90 */   188,  505,  188,  188,  505,  188,  505,  505,  505,  188,
 /*   100 */   584,  762,  949,  949,   96,  628,  938,  938,  938,  938,
 /*   110 */   938,  938,  938,  938,  938,  938,  938,  938,  938,  938,
 /*   120 */   938,  938,  938,  938,  938,  965,  630,  258,   18,  322,
 /*   130 */   601,  550,  550,  550,  711,  548,  548,  601,  614,  614,
 /*   140 */   614,  137,  481,  462,  505,  704,  505,  704,  704,  137,
 /*   150 */   741,  921,  921,  921,  921,  921,  921,  921,  677,  572,
 /*   160 */   781,  566,  395,  399,  151,   84,  414,  445,  144,  680,
 /*   170 */   752,  861,  709,  836,  804,  869,  836, 1047,   87,  934,
 /*   180 */  1076, 1280, 1150, 1292, 1316, 1292, 1178, 1327, 1327, 1292,
 /*   190 */  1178, 1178, 1265, 1327, 1327, 1327, 1354, 1354, 1362,  361,
 /*   200 */   481,  361, 1368, 1373,  361, 1368,  361,  361,  361, 1327,
 /*   210 */   361, 1353, 1353, 1354,  505,  505,  505,  505,  505,  505,
 /*   220 */   505,  505,  505,  505,  505, 1327, 1354,  704,  704, 1230,
 /*   230 */  1362,  584, 1282,  481,  584, 1327, 1316, 1316,  704, 1229,
 /*   240 */  1231,  704, 1229, 1231,  704,  704,  505, 1234, 1325, 1229,
 /*   250 */  1237, 1240, 1250, 1076, 1255, 1260, 1239, 1263,  614, 1509,
 /*   260 */  1327, 1368,  584, 1231,  704,  704,  704,  704,  704, 1231,
 /*   270 */   704, 1398,  584,  137,  584,  614, 1474, 1475,  704,  741,
 /*   280 */  1327,  584, 1542, 1354, 2586, 2586, 2586, 2586, 2586, 2586,
 /*   290 */  2586, 2586, 2586,  858,  497,   23, 1686,   52,  432,  629,
 /*   300 */   155,  665,  805,  814,  325,  971,  971,  971,  971,  971,
 /*   310 */   971,  971,  971,  971,  410,  106,  243,  243,  390,  404,
 /*   320 */   509,  284,  279,  142,  142,  671,  542,  554,  671,  671,
 /*   330 */   671, 1049,  148,  702, 1059,  983,  557, 1023, 1024, 1063,
 /*   340 */  1067, 1082, 1158, 1174,  897, 1097, 1104,  997,  959, 1095,
 /*   350 */  1029, 1121, 1155, 1164, 1165, 1167, 1212, 1168, 1040, 1087,
 /*   360 */  1039, 1189,  872, 1192, 1210, 1228, 1235, 1244, 1246, 1161,
 /*   370 */  1218, 1233, 1223, 1247, 1603, 1608, 1423, 1612, 1613, 1572,
 /*   380 */  1616, 1582, 1418, 1584, 1585, 1586, 1422, 1624, 1590, 1591,
 /*   390 */  1427, 1629, 1431, 1633, 1599, 1635, 1625, 1638, 1614, 1465,
 /*   400 */  1470, 1654, 1655, 1481, 1480, 1659, 1666, 1621, 1669, 1670,
 /*   410 */  1671, 1631, 1674, 1676, 1677, 1678, 1688, 1691, 1693, 1694,
 /*   420 */  1528, 1660, 1696, 1545, 1698, 1699, 1700, 1701, 1702, 1706,
 /*   430 */  1707, 1709, 1710, 1712, 1713, 1714, 1715, 1717, 1720, 1679,
 /*   440 */  1722, 1724, 1725, 1726, 1727, 1708, 1728, 1729, 1732, 1597,
 /*   450 */  1737, 1740, 1711, 1742, 1685, 1754, 1716, 1756, 1757, 1718,
 /*   460 */  1719, 1723, 1733, 1745, 1735, 1748, 1738, 1764, 1736, 1749,
 /*   470 */  1766, 1779, 1787, 1750, 1618, 1792, 1795, 1796, 1734, 1797,
 /*   480 */  1800, 1768, 1753, 1765, 1805, 1773, 1763, 1771, 1812, 1780,
 /*   490 */  1769, 1774, 1814, 1783, 1781, 1782, 1819, 1822, 1831, 1833,
 /*   500 */  1730, 1731, 1803, 1825, 1848, 1816, 1818, 1820, 1823, 1810,
 /*   510 */  1813, 1824, 1826, 1834, 1827, 1860, 1841, 1864, 1844, 1817,
 /*   520 */  1868, 1847, 1835, 1871, 1838, 1872, 1839, 1876, 1855, 1858,
 /*   530 */  1846, 1856, 1697, 1801, 1798, 1892, 1739, 1862, 1899, 1721,
 /*   540 */  1878, 1743, 1744, 1901, 1902, 1751, 1747, 1903, 1869, 1663,
 /*   550 */  1828, 1811, 1840, 1752, 1692, 1770, 1682, 1843, 1870, 1852,
 /*   560 */  1854, 1857, 1861, 1859, 1875, 1884, 1890, 1863, 1879, 1703,
 /*   570 */  1866, 1873, 1948, 1910, 1741, 1923, 1926, 1930, 1931, 1932,
 /*   580 */  1933, 1874, 1877, 1922, 1755, 1929, 1928, 1976, 1978, 1980,
 /*   590 */  1885, 1886, 1887, 1891, 1895, 1815, 1904, 1986, 1962, 1850,
 /*   600 */  1907, 1898, 1733, 1958, 1964, 1789, 1788, 1793, 2018, 2000,
 /*   610 */  1829, 1927, 1936, 1934, 1940, 1943, 1944, 1977, 1946, 1947,
 /*   620 */  1979, 1950, 2003, 1832, 1949, 1921, 1951, 1994, 2001, 1953,
 /*   630 */  1955, 2009, 1954, 1957, 2020, 1960, 1961, 2024, 1967, 1963,
 /*   640 */  2037, 1982, 1959, 1971, 1972, 1973, 2051, 1966, 1985, 2038,
 /*   650 */  1998, 2060, 2002, 2038, 2038, 2074, 2035, 2034, 2066, 2067,
 /*   660 */  2068, 2071, 2078, 2080, 2081, 2082, 2083, 2084, 2052, 2028,
 /*   670 */  2079, 2090, 2091, 2102, 2092, 2107, 2095, 2096, 2097, 2064,
 /*   680 */  1810, 2103, 1813, 2104, 2106, 2108, 2110, 2115, 2111, 2140,
 /*   690 */  2112, 2094, 2113, 2150, 2118, 2109, 2116, 2154, 2121, 2123,
 /*   700 */  2120, 2160, 2126, 2125, 2124, 2180, 2141, 2142, 2189, 2153,
 /*   710 */  2169, 2171, 2174, 2170, 2177,
};
#define YY_REDUCE_COUNT (292)
#define YY_REDUCE_MIN   (-424)
#define YY_REDUCE_MAX   (2175)
static const short yy_reduce_ofst[] = {
 /*     0 */  -188, -327, -228, -168,  -34,  100,  655,  747,  834,  -94,
 /*    10 */   877,  905,  948, 1013, 1056, 1109, 1130, 1037, 1183, 1236,
 /*    20 */  1257, 1279, 1345, 1365, 1420, 1436, 1479, 1522, 1538, 1589,
 /*    30 */  1606, 1661, 1680, 1704, 1762, 1778, 1821, 1837, 1880, 1896,
 /*    40 */  1939, 1990, 2007, 2033, 2089, 2105, 2159, 2175,  -36, -347,
 /*    50 */   593, -344,   80,  773,  913,  943,  746,  790, -260, 1151,
 /*    60 */  -424, -268,  606, -412,  -54, -237,   70, -330, -259, -265,
 /*    70 */  -212,  -28,  107, -309, -165,  211,  224,  300,  372,  373,
 /*    80 */   434,  436,  632,  -93,  641,  675,  158,  722, -367,  743,
 /*    90 */   748, -322,  749,  750, -221,  751,  420, -200,  426,  793,
 /*   100 */   336,   57, -411, -411, -294, -332,   58,  196,  220,  333,
 /*   110 */   345,  393,  396,  438,  463,  464,  478,  479,  489,  504,
 /*   120 */   529,  625,  626,  682,  723, -286, -315,  139,   -5,  186,
 /*   130 */   167, -315,   36,  182,  513,  447,  454,  217,  501,  622,
 /*   140 */   623,  547,  -44,  328,  294,  604,   22,  633,  643,  698,
 /*   150 */   679, -357,  409,  656,  818,  838,  844,  851,  758,  867,
 /*   160 */   881,  843,  772,  813,  923,  829,  916,  916,  954,  914,
 /*   170 */   963,  932,  922,  873,  873,  866,  873,  894,  884,  916,
 /*   180 */   926,  936,  942,  957,  956,  960,  969, 1014, 1015,  979,
 /*   190 */   984,  992, 1030, 1042, 1043, 1045, 1046, 1052,  994, 1044,
 /*   200 */  1016, 1053, 1054, 1010, 1058, 1064, 1060, 1061, 1065, 1069,
 /*   210 */  1066, 1073, 1074, 1086, 1068, 1070, 1080, 1081, 1088, 1090,
 /*   220 */  1091, 1092, 1093, 1096, 1100, 1089, 1102, 1084, 1094, 1075,
 /*   230 */  1078, 1114, 1077, 1099, 1135, 1141, 1051, 1098, 1110, 1048,
 /*   240 */  1105, 1112, 1055, 1106, 1115, 1120,  916, 1057, 1083, 1103,
 /*   250 */  1085, 1071, 1107, 1108, 1101, 1079, 1111,  873, 1162, 1137,
 /*   260 */  1197, 1208, 1206, 1163, 1175, 1177, 1182, 1184, 1186, 1176,
 /*   270 */  1187, 1185, 1226, 1214, 1227, 1203, 1152, 1211, 1205, 1232,
 /*   280 */  1242, 1243, 1251, 1256, 1202, 1201, 1213, 1216, 1245, 1252,
 /*   290 */  1258, 1259, 1271,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    10 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    20 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    30 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    40 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    50 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    60 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1853,
 /*    70 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    80 */  1597, 1597, 1597, 1675, 1597, 1597, 1597, 1597, 1597, 1597,
 /*    90 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   100 */  1673, 1846, 2043, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   110 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   120 */  1597, 1597, 1597, 1597, 1597, 1597, 2055, 1597, 1597, 1675,
 /*   130 */  1597, 2055, 2055, 2055, 1673, 2015, 2015, 1597, 1597, 1597,
 /*   140 */  1597, 1783, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1783,
 /*   150 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1890, 1597,
 /*   160 */  1597, 2080, 2134, 1597, 1597, 2083, 1597, 1597, 1597, 1858,
 /*   170 */  1597, 1736, 2070, 2047, 2061, 2118, 2048, 2045, 2064, 1597,
 /*   180 */  2074, 1597, 1883, 1851, 1597, 1851, 1848, 1597, 1597, 1851,
 /*   190 */  1848, 1848, 1727, 1597, 1597, 1597, 1597, 1597, 1597, 1675,
 /*   200 */  1597, 1675, 1597, 1597, 1675, 1597, 1675, 1675, 1675, 1597,
 /*   210 */  1675, 1654, 1654, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   220 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1903,
 /*   230 */  1597, 1673, 1892, 1597, 1673, 1597, 1597, 1597, 1597, 2091,
 /*   240 */  2089, 1597, 2091, 2089, 1597, 1597, 1597, 2103, 2099, 2091,
 /*   250 */  2107, 2105, 2076, 2074, 2137, 2124, 2120, 2061, 1597, 1597,
 /*   260 */  1597, 1597, 1673, 2089, 1597, 1597, 1597, 1597, 1597, 2089,
 /*   270 */  1597, 1597, 1673, 1597, 1673, 1597, 1597, 1752, 1597, 1597,
 /*   280 */  1597, 1673, 1629, 1597, 1885, 1896, 1868, 1868, 1786, 1786,
 /*   290 */  1786, 1676, 1602, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   300 */  1597, 1597, 1597, 1597, 1597, 2102, 2101, 1971, 1597, 2019,
 /*   310 */  2018, 2017, 2008, 1970, 1748, 1597, 1969, 1968, 1597, 1597,
 /*   320 */  1597, 1597, 1597, 1864, 1863, 1962, 1597, 1597, 1963, 1961,
 /*   330 */  1960, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   340 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 2121, 2125,
 /*   350 */  1597, 1597, 1597, 1597, 1597, 1597, 2044, 1597, 1597, 1597,
 /*   360 */  1597, 1597, 1945, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   370 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   380 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   390 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   400 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   410 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   420 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   430 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   440 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   450 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   460 */  1597, 1634, 1950, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   470 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   480 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   490 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   500 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1715,
 /*   510 */  1714, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   520 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   530 */  1597, 1597, 1597, 1953, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   540 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 2117, 2077, 1597,
 /*   550 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   560 */  1597, 1597, 1597, 1597, 1597, 1597, 1945, 1597, 2100, 1597,
 /*   570 */  1597, 2115, 1597, 2119, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   580 */  1597, 2054, 2050, 1597, 1597, 2046, 1597, 1597, 1597, 1597,
 /*   590 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   600 */  1597, 1597, 1944, 1597, 2005, 1597, 1597, 1597, 2039, 1597,
 /*   610 */  1597, 1990, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   620 */  1597, 1953, 1597, 1956, 1597, 1597, 1597, 1597, 1597, 1780,
 /*   630 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   640 */  1597, 1597, 1765, 1763, 1762, 1761, 1597, 1758, 1597, 1793,
 /*   650 */  1597, 1597, 1597, 1789, 1788, 1597, 1597, 1597, 1597, 1597,
 /*   660 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   670 */  1695, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   680 */  1686, 1597, 1685, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   690 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   700 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*   710 */  1597, 1597, 1597, 1597, 1597,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  271,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  271,  /*      AFTER => ABORT */
  271,  /*     ATTACH => ABORT */
  271,  /*     BEFORE => ABORT */
  271,  /*      BEGIN => ABORT */
  271,  /*     BITAND => ABORT */
  271,  /*     BITNOT => ABORT */
  271,  /*      BITOR => ABORT */
  271,  /*     BLOCKS => ABORT */
  271,  /*     CHANGE => ABORT */
  271,  /*      COMMA => ABORT */
  271,  /*    COMPACT => ABORT */
  271,  /*     CONCAT => ABORT */
  271,  /*   CONFLICT => ABORT */
  271,  /*       COPY => ABORT */
  271,  /*   DEFERRED => ABORT */
  271,  /* DELIMITERS => ABORT */
  271,  /*     DETACH => ABORT */
  271,  /*     DIVIDE => ABORT */
  271,  /*        DOT => ABORT */
  271,  /*       EACH => ABORT */
  271,  /*       FAIL => ABORT */
  271,  /*       FILE => ABORT */
  271,  /*        FOR => ABORT */
  271,  /*       GLOB => ABORT */
  271,  /*         ID => ABORT */
  271,  /*  IMMEDIATE => ABORT */
  271,  /*     IMPORT => ABORT */
  271,  /*  INITIALLY => ABORT */
  271,  /*    INSTEAD => ABORT */
  271,  /*     ISNULL => ABORT */
  271,  /*        KEY => ABORT */
  271,  /*    MODULES => ABORT */
  271,  /*  NK_BITNOT => ABORT */
  271,  /*    NK_SEMI => ABORT */
  271,  /*    NOTNULL => ABORT */
  271,  /*         OF => ABORT */
  271,  /*       PLUS => ABORT */
  271,  /*  PRIVILEGE => ABORT */
  271,  /*      RAISE => ABORT */
  271,  /*    REPLACE => ABORT */
  271,  /*   RESTRICT => ABORT */
  271,  /*        ROW => ABORT */
  271,  /*       SEMI => ABORT */
  271,  /*       STAR => ABORT */
  271,  /*  STATEMENT => ABORT */
  271,  /*     STRING => ABORT */
  271,  /*      TIMES => ABORT */
  271,  /*     UPDATE => ABORT */
  271,  /*     VALUES => ABORT */
  271,  /*   VARIABLE => ABORT */
  271,  /*       VIEW => ABORT */
  271,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "STRICT",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "TOPIC",
  /*  169 */ "WITH",
  /*  170 */ "META",
  /*  171 */ "CONSUMER",
  /*  172 */ "GROUP",
  /*  173 */ "DESC",
  /*  174 */ "DESCRIBE",
  /*  175 */ "RESET",
  /*  176 */ "QUERY",
  /*  177 */ "CACHE",
  /*  178 */ "EXPLAIN",
  /*  179 */ "ANALYZE",
  /*  180 */ "VERBOSE",
  /*  181 */ "NK_BOOL",
  /*  182 */ "RATIO",
  /*  183 */ "NK_FLOAT",
  /*  184 */ "OUTPUTTYPE",
  /*  185 */ "AGGREGATE",
  /*  186 */ "BUFSIZE",
  /*  187 */ "STREAM",
  /*  188 */ "INTO",
  /*  189 */ "TRIGGER",
  /*  190 */ "AT_ONCE",
  /*  191 */ "WINDOW_CLOSE",
  /*  192 */ "IGNORE",
  /*  193 */ "EXPIRED",
  /*  194 */ "FILL_HISTORY",
  /*  195 */ "SUBTABLE",
  /*  196 */ "KILL",
  /*  197 */ "CONNECTION",
  /*  198 */ "TRANSACTION",
  /*  199 */ "BALANCE",
  /*  200 */ "VGROUP",
  /*  201 */ "MERGE",
  /*  202 */ "REDISTRIBUTE",
  /*  203 */ "SPLIT",
  /*  204 */ "DELETE",
  /*  205 */ "INSERT",
  /*  206 */ "NULL",
  /*  207 */ "NK_QUESTION",
  /*  208 */ "NK_ARROW",
  /*  209 */ "ROWTS",
  /*  210 */ "QSTART",
  /*  211 */ "QEND",
  /*  212 */ "QDURATION",
  /*  213 */ "WSTART",
  /*  214 */ "WEND",
  /*  215 */ "WDURATION",
  /*  216 */ "IROWTS",
  /*  217 */ "CAST",
  /*  218 */ "NOW",
  /*  219 */ "TODAY",
  /*  220 */ "TIMEZONE",
  /*  221 */ "CLIENT_VERSION",
  /*  222 */ "SERVER_VERSION",
  /*  223 */ "SERVER_STATUS",
  /*  224 */ "CURRENT_USER",
  /*  225 */ "COUNT",
  /*  226 */ "LAST_ROW",
  /*  227 */ "CASE",
  /*  228 */ "END",
  /*  229 */ "WHEN",
  /*  230 */ "THEN",
  /*  231 */ "ELSE",
  /*  232 */ "BETWEEN",
  /*  233 */ "IS",
  /*  234 */ "NK_LT",
  /*  235 */ "NK_GT",
  /*  236 */ "NK_LE",
  /*  237 */ "NK_GE",
  /*  238 */ "NK_NE",
  /*  239 */ "MATCH",
  /*  240 */ "NMATCH",
  /*  241 */ "CONTAINS",
  /*  242 */ "IN",
  /*  243 */ "JOIN",
  /*  244 */ "INNER",
  /*  245 */ "SELECT",
  /*  246 */ "DISTINCT",
  /*  247 */ "WHERE",
  /*  248 */ "PARTITION",
  /*  249 */ "BY",
  /*  250 */ "SESSION",
  /*  251 */ "STATE_WINDOW",
  /*  252 */ "EVENT_WINDOW",
  /*  253 */ "START",
  /*  254 */ "SLIDING",
  /*  255 */ "FILL",
  /*  256 */ "VALUE",
  /*  257 */ "NONE",
  /*  258 */ "PREV",
  /*  259 */ "LINEAR",
  /*  260 */ "NEXT",
  /*  261 */ "HAVING",
  /*  262 */ "RANGE",
  /*  263 */ "EVERY",
  /*  264 */ "ORDER",
  /*  265 */ "SLIMIT",
  /*  266 */ "SOFFSET",
  /*  267 */ "LIMIT",
  /*  268 */ "OFFSET",
  /*  269 */ "ASC",
  /*  270 */ "NULLS",
  /*  271 */ "ABORT",
  /*  272 */ "AFTER",
  /*  273 */ "ATTACH",
  /*  274 */ "BEFORE",
  /*  275 */ "BEGIN",
  /*  276 */ "BITAND",
  /*  277 */ "BITNOT",
  /*  278 */ "BITOR",
  /*  279 */ "BLOCKS",
  /*  280 */ "CHANGE",
  /*  281 */ "COMMA",
  /*  282 */ "COMPACT",
  /*  283 */ "CONCAT",
  /*  284 */ "CONFLICT",
  /*  285 */ "COPY",
  /*  286 */ "DEFERRED",
  /*  287 */ "DELIMITERS",
  /*  288 */ "DETACH",
  /*  289 */ "DIVIDE",
  /*  290 */ "DOT",
  /*  291 */ "EACH",
  /*  292 */ "FAIL",
  /*  293 */ "FILE",
  /*  294 */ "FOR",
  /*  295 */ "GLOB",
  /*  296 */ "ID",
  /*  297 */ "IMMEDIATE",
  /*  298 */ "IMPORT",
  /*  299 */ "INITIALLY",
  /*  300 */ "INSTEAD",
  /*  301 */ "ISNULL",
  /*  302 */ "KEY",
  /*  303 */ "MODULES",
  /*  304 */ "NK_BITNOT",
  /*  305 */ "NK_SEMI",
  /*  306 */ "NOTNULL",
  /*  307 */ "OF",
  /*  308 */ "PLUS",
  /*  309 */ "PRIVILEGE",
  /*  310 */ "RAISE",
  /*  311 */ "REPLACE",
  /*  312 */ "RESTRICT",
  /*  313 */ "ROW",
  /*  314 */ "SEMI",
  /*  315 */ "STAR",
  /*  316 */ "STATEMENT",
  /*  317 */ "STRING",
  /*  318 */ "TIMES",
  /*  319 */ "UPDATE",
  /*  320 */ "VALUES",
  /*  321 */ "VARIABLE",
  /*  322 */ "VIEW",
  /*  323 */ "WAL",
  /*  324 */ "cmd",
  /*  325 */ "account_options",
  /*  326 */ "alter_account_options",
  /*  327 */ "literal",
  /*  328 */ "alter_account_option",
  /*  329 */ "user_name",
  /*  330 */ "sysinfo_opt",
  /*  331 */ "privileges",
  /*  332 */ "priv_level",
  /*  333 */ "priv_type_list",
  /*  334 */ "priv_type",
  /*  335 */ "db_name",
  /*  336 */ "topic_name",
  /*  337 */ "dnode_endpoint",
  /*  338 */ "force_opt",
  /*  339 */ "not_exists_opt",
  /*  340 */ "db_options",
  /*  341 */ "exists_opt",
  /*  342 */ "alter_db_options",
  /*  343 */ "speed_opt",
  /*  344 */ "integer_list",
  /*  345 */ "variable_list",
  /*  346 */ "retention_list",
  /*  347 */ "alter_db_option",
  /*  348 */ "retention",
  /*  349 */ "full_table_name",
  /*  350 */ "column_def_list",
  /*  351 */ "tags_def_opt",
  /*  352 */ "table_options",
  /*  353 */ "multi_create_clause",
  /*  354 */ "tags_def",
  /*  355 */ "multi_drop_clause",
  /*  356 */ "alter_table_clause",
  /*  357 */ "alter_table_options",
  /*  358 */ "column_name",
  /*  359 */ "type_name",
  /*  360 */ "signed_literal",
  /*  361 */ "create_subtable_clause",
  /*  362 */ "specific_cols_opt",
  /*  363 */ "expression_list",
  /*  364 */ "drop_table_clause",
  /*  365 */ "col_name_list",
  /*  366 */ "table_name",
  /*  367 */ "column_def",
  /*  368 */ "duration_list",
  /*  369 */ "rollup_func_list",
  /*  370 */ "alter_table_option",
  /*  371 */ "duration_literal",
  /*  372 */ "rollup_func_name",
  /*  373 */ "function_name",
  /*  374 */ "col_name",
  /*  375 */ "db_name_cond_opt",
  /*  376 */ "like_pattern_opt",
  /*  377 */ "table_name_cond",
  /*  378 */ "from_db_opt",
  /*  379 */ "tag_list_opt",
  /*  380 */ "tag_item",
  /*  381 */ "column_alias",
  /*  382 */ "index_options",
  /*  383 */ "func_list",
  /*  384 */ "sliding_opt",
  /*  385 */ "sma_stream_opt",
  /*  386 */ "func",
  /*  387 */ "query_or_subquery",
  /*  388 */ "cgroup_name",
  /*  389 */ "analyze_opt",
  /*  390 */ "explain_options",
  /*  391 */ "agg_func_opt",
  /*  392 */ "bufsize_opt",
  /*  393 */ "stream_name",
  /*  394 */ "stream_options",
  /*  395 */ "subtable_opt",
  /*  396 */ "expression",
  /*  397 */ "dnode_list",
  /*  398 */ "where_clause_opt",
  /*  399 */ "signed",
  /*  400 */ "literal_func",
  /*  401 */ "literal_list",
  /*  402 */ "table_alias",
  /*  403 */ "expr_or_subquery",
  /*  404 */ "pseudo_column",
  /*  405 */ "column_reference",
  /*  406 */ "function_expression",
  /*  407 */ "case_when_expression",
  /*  408 */ "star_func",
  /*  409 */ "star_func_para_list",
  /*  410 */ "noarg_func",
  /*  411 */ "other_para_list",
  /*  412 */ "star_func_para",
  /*  413 */ "when_then_list",
  /*  414 */ "case_when_else_opt",
  /*  415 */ "common_expression",
  /*  416 */ "when_then_expr",
  /*  417 */ "predicate",
  /*  418 */ "compare_op",
  /*  419 */ "in_op",
  /*  420 */ "in_predicate_value",
  /*  421 */ "boolean_value_expression",
  /*  422 */ "boolean_primary",
  /*  423 */ "from_clause_opt",
  /*  424 */ "table_reference_list",
  /*  425 */ "table_reference",
  /*  426 */ "table_primary",
  /*  427 */ "joined_table",
  /*  428 */ "alias_opt",
  /*  429 */ "subquery",
  /*  430 */ "parenthesized_joined_table",
  /*  431 */ "join_type",
  /*  432 */ "search_condition",
  /*  433 */ "query_specification",
  /*  434 */ "set_quantifier_opt",
  /*  435 */ "select_list",
  /*  436 */ "partition_by_clause_opt",
  /*  437 */ "range_opt",
  /*  438 */ "every_opt",
  /*  439 */ "fill_opt",
  /*  440 */ "twindow_clause_opt",
  /*  441 */ "group_by_clause_opt",
  /*  442 */ "having_clause_opt",
  /*  443 */ "select_item",
  /*  444 */ "partition_list",
  /*  445 */ "partition_item",
  /*  446 */ "fill_mode",
  /*  447 */ "group_by_list",
  /*  448 */ "query_expression",
  /*  449 */ "query_simple",
  /*  450 */ "order_by_clause_opt",
  /*  451 */ "slimit_clause_opt",
  /*  452 */ "limit_clause_opt",
  /*  453 */ "union_query_expression",
  /*  454 */ "query_simple_or_subquery",
  /*  455 */ "sort_specification_list",
  /*  456 */ "sort_specification",
  /*  457 */ "ordering_specification_opt",
  /*  458 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options STRICT NK_STRING",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "db_name_cond_opt ::=",
 /* 247 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 248 */ "like_pattern_opt ::=",
 /* 249 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 250 */ "table_name_cond ::= table_name",
 /* 251 */ "from_db_opt ::=",
 /* 252 */ "from_db_opt ::= FROM db_name",
 /* 253 */ "tag_list_opt ::=",
 /* 254 */ "tag_list_opt ::= tag_item",
 /* 255 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 256 */ "tag_item ::= TBNAME",
 /* 257 */ "tag_item ::= QTAGS",
 /* 258 */ "tag_item ::= column_name",
 /* 259 */ "tag_item ::= column_name column_alias",
 /* 260 */ "tag_item ::= column_name AS column_alias",
 /* 261 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 262 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "func_list ::= func",
 /* 266 */ "func_list ::= func_list NK_COMMA func",
 /* 267 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 268 */ "sma_stream_opt ::=",
 /* 269 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 271 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 272 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 277 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 278 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 279 */ "cmd ::= DESC full_table_name",
 /* 280 */ "cmd ::= DESCRIBE full_table_name",
 /* 281 */ "cmd ::= RESET QUERY CACHE",
 /* 282 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 283 */ "analyze_opt ::=",
 /* 284 */ "analyze_opt ::= ANALYZE",
 /* 285 */ "explain_options ::=",
 /* 286 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 287 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 288 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 289 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 290 */ "agg_func_opt ::=",
 /* 291 */ "agg_func_opt ::= AGGREGATE",
 /* 292 */ "bufsize_opt ::=",
 /* 293 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 294 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 295 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 296 */ "stream_options ::=",
 /* 297 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 298 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 299 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 300 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 301 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 302 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 303 */ "subtable_opt ::=",
 /* 304 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 305 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 306 */ "cmd ::= KILL QUERY NK_STRING",
 /* 307 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 308 */ "cmd ::= BALANCE VGROUP",
 /* 309 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 310 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 311 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 312 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 313 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 314 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 315 */ "cmd ::= query_or_subquery",
 /* 316 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 317 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 318 */ "literal ::= NK_INTEGER",
 /* 319 */ "literal ::= NK_FLOAT",
 /* 320 */ "literal ::= NK_STRING",
 /* 321 */ "literal ::= NK_BOOL",
 /* 322 */ "literal ::= TIMESTAMP NK_STRING",
 /* 323 */ "literal ::= duration_literal",
 /* 324 */ "literal ::= NULL",
 /* 325 */ "literal ::= NK_QUESTION",
 /* 326 */ "duration_literal ::= NK_VARIABLE",
 /* 327 */ "signed ::= NK_INTEGER",
 /* 328 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 329 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 330 */ "signed ::= NK_FLOAT",
 /* 331 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 332 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 333 */ "signed_literal ::= signed",
 /* 334 */ "signed_literal ::= NK_STRING",
 /* 335 */ "signed_literal ::= NK_BOOL",
 /* 336 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 337 */ "signed_literal ::= duration_literal",
 /* 338 */ "signed_literal ::= NULL",
 /* 339 */ "signed_literal ::= literal_func",
 /* 340 */ "signed_literal ::= NK_QUESTION",
 /* 341 */ "literal_list ::= signed_literal",
 /* 342 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 343 */ "db_name ::= NK_ID",
 /* 344 */ "table_name ::= NK_ID",
 /* 345 */ "column_name ::= NK_ID",
 /* 346 */ "function_name ::= NK_ID",
 /* 347 */ "table_alias ::= NK_ID",
 /* 348 */ "column_alias ::= NK_ID",
 /* 349 */ "user_name ::= NK_ID",
 /* 350 */ "topic_name ::= NK_ID",
 /* 351 */ "stream_name ::= NK_ID",
 /* 352 */ "cgroup_name ::= NK_ID",
 /* 353 */ "expr_or_subquery ::= expression",
 /* 354 */ "expression ::= literal",
 /* 355 */ "expression ::= pseudo_column",
 /* 356 */ "expression ::= column_reference",
 /* 357 */ "expression ::= function_expression",
 /* 358 */ "expression ::= case_when_expression",
 /* 359 */ "expression ::= NK_LP expression NK_RP",
 /* 360 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 361 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 362 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 363 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 367 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 368 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 370 */ "expression_list ::= expr_or_subquery",
 /* 371 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 372 */ "column_reference ::= column_name",
 /* 373 */ "column_reference ::= table_name NK_DOT column_name",
 /* 374 */ "pseudo_column ::= ROWTS",
 /* 375 */ "pseudo_column ::= TBNAME",
 /* 376 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 377 */ "pseudo_column ::= QSTART",
 /* 378 */ "pseudo_column ::= QEND",
 /* 379 */ "pseudo_column ::= QDURATION",
 /* 380 */ "pseudo_column ::= WSTART",
 /* 381 */ "pseudo_column ::= WEND",
 /* 382 */ "pseudo_column ::= WDURATION",
 /* 383 */ "pseudo_column ::= IROWTS",
 /* 384 */ "pseudo_column ::= QTAGS",
 /* 385 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 386 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 387 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 388 */ "function_expression ::= literal_func",
 /* 389 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 390 */ "literal_func ::= NOW",
 /* 391 */ "noarg_func ::= NOW",
 /* 392 */ "noarg_func ::= TODAY",
 /* 393 */ "noarg_func ::= TIMEZONE",
 /* 394 */ "noarg_func ::= DATABASE",
 /* 395 */ "noarg_func ::= CLIENT_VERSION",
 /* 396 */ "noarg_func ::= SERVER_VERSION",
 /* 397 */ "noarg_func ::= SERVER_STATUS",
 /* 398 */ "noarg_func ::= CURRENT_USER",
 /* 399 */ "noarg_func ::= USER",
 /* 400 */ "star_func ::= COUNT",
 /* 401 */ "star_func ::= FIRST",
 /* 402 */ "star_func ::= LAST",
 /* 403 */ "star_func ::= LAST_ROW",
 /* 404 */ "star_func_para_list ::= NK_STAR",
 /* 405 */ "star_func_para_list ::= other_para_list",
 /* 406 */ "other_para_list ::= star_func_para",
 /* 407 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 408 */ "star_func_para ::= expr_or_subquery",
 /* 409 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 410 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 411 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 412 */ "when_then_list ::= when_then_expr",
 /* 413 */ "when_then_list ::= when_then_list when_then_expr",
 /* 414 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 415 */ "case_when_else_opt ::=",
 /* 416 */ "case_when_else_opt ::= ELSE common_expression",
 /* 417 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 418 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 419 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 420 */ "predicate ::= expr_or_subquery IS NULL",
 /* 421 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 422 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 423 */ "compare_op ::= NK_LT",
 /* 424 */ "compare_op ::= NK_GT",
 /* 425 */ "compare_op ::= NK_LE",
 /* 426 */ "compare_op ::= NK_GE",
 /* 427 */ "compare_op ::= NK_NE",
 /* 428 */ "compare_op ::= NK_EQ",
 /* 429 */ "compare_op ::= LIKE",
 /* 430 */ "compare_op ::= NOT LIKE",
 /* 431 */ "compare_op ::= MATCH",
 /* 432 */ "compare_op ::= NMATCH",
 /* 433 */ "compare_op ::= CONTAINS",
 /* 434 */ "in_op ::= IN",
 /* 435 */ "in_op ::= NOT IN",
 /* 436 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 437 */ "boolean_value_expression ::= boolean_primary",
 /* 438 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 439 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 440 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 441 */ "boolean_primary ::= predicate",
 /* 442 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 443 */ "common_expression ::= expr_or_subquery",
 /* 444 */ "common_expression ::= boolean_value_expression",
 /* 445 */ "from_clause_opt ::=",
 /* 446 */ "from_clause_opt ::= FROM table_reference_list",
 /* 447 */ "table_reference_list ::= table_reference",
 /* 448 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 449 */ "table_reference ::= table_primary",
 /* 450 */ "table_reference ::= joined_table",
 /* 451 */ "table_primary ::= table_name alias_opt",
 /* 452 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 453 */ "table_primary ::= subquery alias_opt",
 /* 454 */ "table_primary ::= parenthesized_joined_table",
 /* 455 */ "alias_opt ::=",
 /* 456 */ "alias_opt ::= table_alias",
 /* 457 */ "alias_opt ::= AS table_alias",
 /* 458 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 459 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 460 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 461 */ "join_type ::=",
 /* 462 */ "join_type ::= INNER",
 /* 463 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 464 */ "set_quantifier_opt ::=",
 /* 465 */ "set_quantifier_opt ::= DISTINCT",
 /* 466 */ "set_quantifier_opt ::= ALL",
 /* 467 */ "select_list ::= select_item",
 /* 468 */ "select_list ::= select_list NK_COMMA select_item",
 /* 469 */ "select_item ::= NK_STAR",
 /* 470 */ "select_item ::= common_expression",
 /* 471 */ "select_item ::= common_expression column_alias",
 /* 472 */ "select_item ::= common_expression AS column_alias",
 /* 473 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 474 */ "where_clause_opt ::=",
 /* 475 */ "where_clause_opt ::= WHERE search_condition",
 /* 476 */ "partition_by_clause_opt ::=",
 /* 477 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 478 */ "partition_list ::= partition_item",
 /* 479 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 480 */ "partition_item ::= expr_or_subquery",
 /* 481 */ "partition_item ::= expr_or_subquery column_alias",
 /* 482 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 483 */ "twindow_clause_opt ::=",
 /* 484 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 485 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 486 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 487 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 488 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 489 */ "sliding_opt ::=",
 /* 490 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 491 */ "fill_opt ::=",
 /* 492 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 493 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 494 */ "fill_mode ::= NONE",
 /* 495 */ "fill_mode ::= PREV",
 /* 496 */ "fill_mode ::= NULL",
 /* 497 */ "fill_mode ::= LINEAR",
 /* 498 */ "fill_mode ::= NEXT",
 /* 499 */ "group_by_clause_opt ::=",
 /* 500 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 501 */ "group_by_list ::= expr_or_subquery",
 /* 502 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 503 */ "having_clause_opt ::=",
 /* 504 */ "having_clause_opt ::= HAVING search_condition",
 /* 505 */ "range_opt ::=",
 /* 506 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 507 */ "every_opt ::=",
 /* 508 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 509 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 510 */ "query_simple ::= query_specification",
 /* 511 */ "query_simple ::= union_query_expression",
 /* 512 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 513 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 514 */ "query_simple_or_subquery ::= query_simple",
 /* 515 */ "query_simple_or_subquery ::= subquery",
 /* 516 */ "query_or_subquery ::= query_expression",
 /* 517 */ "query_or_subquery ::= subquery",
 /* 518 */ "order_by_clause_opt ::=",
 /* 519 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 520 */ "slimit_clause_opt ::=",
 /* 521 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 522 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 523 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 524 */ "limit_clause_opt ::=",
 /* 525 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 526 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 527 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 528 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 529 */ "subquery ::= NK_LP subquery NK_RP",
 /* 530 */ "search_condition ::= common_expression",
 /* 531 */ "sort_specification_list ::= sort_specification",
 /* 532 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 533 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 534 */ "ordering_specification_opt ::=",
 /* 535 */ "ordering_specification_opt ::= ASC",
 /* 536 */ "ordering_specification_opt ::= DESC",
 /* 537 */ "null_ordering_opt ::=",
 /* 538 */ "null_ordering_opt ::= NULLS FIRST",
 /* 539 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 324: /* cmd */
    case 327: /* literal */
    case 340: /* db_options */
    case 342: /* alter_db_options */
    case 348: /* retention */
    case 349: /* full_table_name */
    case 352: /* table_options */
    case 356: /* alter_table_clause */
    case 357: /* alter_table_options */
    case 360: /* signed_literal */
    case 361: /* create_subtable_clause */
    case 364: /* drop_table_clause */
    case 367: /* column_def */
    case 371: /* duration_literal */
    case 372: /* rollup_func_name */
    case 374: /* col_name */
    case 375: /* db_name_cond_opt */
    case 376: /* like_pattern_opt */
    case 377: /* table_name_cond */
    case 378: /* from_db_opt */
    case 380: /* tag_item */
    case 382: /* index_options */
    case 384: /* sliding_opt */
    case 385: /* sma_stream_opt */
    case 386: /* func */
    case 387: /* query_or_subquery */
    case 390: /* explain_options */
    case 394: /* stream_options */
    case 395: /* subtable_opt */
    case 396: /* expression */
    case 398: /* where_clause_opt */
    case 399: /* signed */
    case 400: /* literal_func */
    case 403: /* expr_or_subquery */
    case 404: /* pseudo_column */
    case 405: /* column_reference */
    case 406: /* function_expression */
    case 407: /* case_when_expression */
    case 412: /* star_func_para */
    case 414: /* case_when_else_opt */
    case 415: /* common_expression */
    case 416: /* when_then_expr */
    case 417: /* predicate */
    case 420: /* in_predicate_value */
    case 421: /* boolean_value_expression */
    case 422: /* boolean_primary */
    case 423: /* from_clause_opt */
    case 424: /* table_reference_list */
    case 425: /* table_reference */
    case 426: /* table_primary */
    case 427: /* joined_table */
    case 429: /* subquery */
    case 430: /* parenthesized_joined_table */
    case 432: /* search_condition */
    case 433: /* query_specification */
    case 437: /* range_opt */
    case 438: /* every_opt */
    case 439: /* fill_opt */
    case 440: /* twindow_clause_opt */
    case 442: /* having_clause_opt */
    case 443: /* select_item */
    case 445: /* partition_item */
    case 448: /* query_expression */
    case 449: /* query_simple */
    case 451: /* slimit_clause_opt */
    case 452: /* limit_clause_opt */
    case 453: /* union_query_expression */
    case 454: /* query_simple_or_subquery */
    case 456: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy74)); 
}
      break;
    case 325: /* account_options */
    case 326: /* alter_account_options */
    case 328: /* alter_account_option */
    case 343: /* speed_opt */
    case 392: /* bufsize_opt */
{
 
}
      break;
    case 329: /* user_name */
    case 332: /* priv_level */
    case 335: /* db_name */
    case 336: /* topic_name */
    case 337: /* dnode_endpoint */
    case 358: /* column_name */
    case 366: /* table_name */
    case 373: /* function_name */
    case 381: /* column_alias */
    case 388: /* cgroup_name */
    case 393: /* stream_name */
    case 402: /* table_alias */
    case 408: /* star_func */
    case 410: /* noarg_func */
    case 428: /* alias_opt */
{
 
}
      break;
    case 330: /* sysinfo_opt */
{
 
}
      break;
    case 331: /* privileges */
    case 333: /* priv_type_list */
    case 334: /* priv_type */
{
 
}
      break;
    case 338: /* force_opt */
    case 339: /* not_exists_opt */
    case 341: /* exists_opt */
    case 389: /* analyze_opt */
    case 391: /* agg_func_opt */
    case 434: /* set_quantifier_opt */
{
 
}
      break;
    case 344: /* integer_list */
    case 345: /* variable_list */
    case 346: /* retention_list */
    case 350: /* column_def_list */
    case 351: /* tags_def_opt */
    case 353: /* multi_create_clause */
    case 354: /* tags_def */
    case 355: /* multi_drop_clause */
    case 362: /* specific_cols_opt */
    case 363: /* expression_list */
    case 365: /* col_name_list */
    case 368: /* duration_list */
    case 369: /* rollup_func_list */
    case 379: /* tag_list_opt */
    case 383: /* func_list */
    case 397: /* dnode_list */
    case 401: /* literal_list */
    case 409: /* star_func_para_list */
    case 411: /* other_para_list */
    case 413: /* when_then_list */
    case 435: /* select_list */
    case 436: /* partition_by_clause_opt */
    case 441: /* group_by_clause_opt */
    case 444: /* partition_list */
    case 447: /* group_by_list */
    case 450: /* order_by_clause_opt */
    case 455: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy874)); 
}
      break;
    case 347: /* alter_db_option */
    case 370: /* alter_table_option */
{
 
}
      break;
    case 359: /* type_name */
{
 
}
      break;
    case 418: /* compare_op */
    case 419: /* in_op */
{
 
}
      break;
    case 431: /* join_type */
{
 
}
      break;
    case 446: /* fill_mode */
{
 
}
      break;
    case 457: /* ordering_specification_opt */
{
 
}
      break;
    case 458: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  324,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  324,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  325,    0 }, /* (2) account_options ::= */
  {  325,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  325,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  325,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  325,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  325,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  325,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  325,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  325,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  325,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  326,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  326,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  328,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  328,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  328,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  328,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  328,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  328,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  328,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  328,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  328,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  328,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  324,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  324,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  324,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  324,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  324,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  330,    0 }, /* (29) sysinfo_opt ::= */
  {  330,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  324,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  324,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  331,   -1 }, /* (33) privileges ::= ALL */
  {  331,   -1 }, /* (34) privileges ::= priv_type_list */
  {  331,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  333,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  333,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  334,   -1 }, /* (38) priv_type ::= READ */
  {  334,   -1 }, /* (39) priv_type ::= WRITE */
  {  332,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  332,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  332,   -1 }, /* (42) priv_level ::= topic_name */
  {  324,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  324,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  324,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  324,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  324,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  324,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  324,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  324,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  337,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  337,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  337,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  338,    0 }, /* (54) force_opt ::= */
  {  338,   -1 }, /* (55) force_opt ::= FORCE */
  {  324,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  324,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  324,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  324,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  324,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  324,   -2 }, /* (68) cmd ::= USE db_name */
  {  324,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  324,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  324,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  339,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  339,    0 }, /* (73) not_exists_opt ::= */
  {  341,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  341,    0 }, /* (75) exists_opt ::= */
  {  340,    0 }, /* (76) db_options ::= */
  {  340,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  340,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  340,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  340,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  340,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  340,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  340,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  340,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  340,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  340,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  340,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  340,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  340,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  340,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  340,   -3 }, /* (92) db_options ::= db_options STRICT NK_STRING */
  {  340,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  340,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  340,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  340,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  340,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  340,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  340,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  340,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  340,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  340,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  340,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  340,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  340,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  342,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  342,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  347,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  347,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  347,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  347,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  347,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  347,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  347,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  347,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  347,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  347,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  344,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  344,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  345,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  345,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  346,   -1 }, /* (124) retention_list ::= retention */
  {  346,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  348,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  343,    0 }, /* (127) speed_opt ::= */
  {  343,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  324,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  324,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  324,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  324,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  324,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  324,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  324,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  356,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  356,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  356,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  356,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  356,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  356,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  356,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  356,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  356,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  356,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  353,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  353,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  361,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  355,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  355,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  364,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  362,    0 }, /* (152) specific_cols_opt ::= */
  {  362,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  349,   -1 }, /* (154) full_table_name ::= table_name */
  {  349,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  350,   -1 }, /* (156) column_def_list ::= column_def */
  {  350,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  367,   -2 }, /* (158) column_def ::= column_name type_name */
  {  367,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  359,   -1 }, /* (160) type_name ::= BOOL */
  {  359,   -1 }, /* (161) type_name ::= TINYINT */
  {  359,   -1 }, /* (162) type_name ::= SMALLINT */
  {  359,   -1 }, /* (163) type_name ::= INT */
  {  359,   -1 }, /* (164) type_name ::= INTEGER */
  {  359,   -1 }, /* (165) type_name ::= BIGINT */
  {  359,   -1 }, /* (166) type_name ::= FLOAT */
  {  359,   -1 }, /* (167) type_name ::= DOUBLE */
  {  359,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  359,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  359,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  359,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  359,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  359,   -1 }, /* (175) type_name ::= JSON */
  {  359,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  359,   -1 }, /* (178) type_name ::= BLOB */
  {  359,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  359,   -1 }, /* (180) type_name ::= DECIMAL */
  {  359,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  359,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  351,    0 }, /* (183) tags_def_opt ::= */
  {  351,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  354,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  352,    0 }, /* (186) table_options ::= */
  {  352,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  352,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  352,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  352,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  352,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  352,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  352,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  357,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  357,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  370,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  370,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  368,   -1 }, /* (198) duration_list ::= duration_literal */
  {  368,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  369,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  369,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  372,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  372,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  372,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  365,   -1 }, /* (205) col_name_list ::= col_name */
  {  365,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  374,   -1 }, /* (207) col_name ::= column_name */
  {  324,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  324,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  324,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  324,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  324,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  324,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  324,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  324,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  324,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  324,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  324,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  324,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  324,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  324,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  324,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  324,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  324,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  324,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  324,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  324,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  324,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  324,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  324,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  324,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  324,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  324,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  324,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  324,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  324,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  324,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  324,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  324,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  324,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  324,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  324,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  324,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  324,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  324,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  375,    0 }, /* (246) db_name_cond_opt ::= */
  {  375,   -2 }, /* (247) db_name_cond_opt ::= db_name NK_DOT */
  {  376,    0 }, /* (248) like_pattern_opt ::= */
  {  376,   -2 }, /* (249) like_pattern_opt ::= LIKE NK_STRING */
  {  377,   -1 }, /* (250) table_name_cond ::= table_name */
  {  378,    0 }, /* (251) from_db_opt ::= */
  {  378,   -2 }, /* (252) from_db_opt ::= FROM db_name */
  {  379,    0 }, /* (253) tag_list_opt ::= */
  {  379,   -1 }, /* (254) tag_list_opt ::= tag_item */
  {  379,   -3 }, /* (255) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  380,   -1 }, /* (256) tag_item ::= TBNAME */
  {  380,   -1 }, /* (257) tag_item ::= QTAGS */
  {  380,   -1 }, /* (258) tag_item ::= column_name */
  {  380,   -2 }, /* (259) tag_item ::= column_name column_alias */
  {  380,   -3 }, /* (260) tag_item ::= column_name AS column_alias */
  {  324,   -8 }, /* (261) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  324,   -4 }, /* (262) cmd ::= DROP INDEX exists_opt full_table_name */
  {  382,  -10 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  382,  -12 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,   -1 }, /* (265) func_list ::= func */
  {  383,   -3 }, /* (266) func_list ::= func_list NK_COMMA func */
  {  386,   -4 }, /* (267) func ::= function_name NK_LP expression_list NK_RP */
  {  385,    0 }, /* (268) sma_stream_opt ::= */
  {  385,   -3 }, /* (269) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  385,   -3 }, /* (270) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  385,   -3 }, /* (271) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  324,   -6 }, /* (272) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  324,   -7 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  324,   -9 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  324,   -7 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  324,   -9 }, /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  324,   -4 }, /* (277) cmd ::= DROP TOPIC exists_opt topic_name */
  {  324,   -7 }, /* (278) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  324,   -2 }, /* (279) cmd ::= DESC full_table_name */
  {  324,   -2 }, /* (280) cmd ::= DESCRIBE full_table_name */
  {  324,   -3 }, /* (281) cmd ::= RESET QUERY CACHE */
  {  324,   -4 }, /* (282) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  389,    0 }, /* (283) analyze_opt ::= */
  {  389,   -1 }, /* (284) analyze_opt ::= ANALYZE */
  {  390,    0 }, /* (285) explain_options ::= */
  {  390,   -3 }, /* (286) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  390,   -3 }, /* (287) explain_options ::= explain_options RATIO NK_FLOAT */
  {  324,  -10 }, /* (288) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  324,   -4 }, /* (289) cmd ::= DROP FUNCTION exists_opt function_name */
  {  391,    0 }, /* (290) agg_func_opt ::= */
  {  391,   -1 }, /* (291) agg_func_opt ::= AGGREGATE */
  {  392,    0 }, /* (292) bufsize_opt ::= */
  {  392,   -2 }, /* (293) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  324,  -11 }, /* (294) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  324,   -4 }, /* (295) cmd ::= DROP STREAM exists_opt stream_name */
  {  394,    0 }, /* (296) stream_options ::= */
  {  394,   -3 }, /* (297) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  394,   -3 }, /* (298) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  394,   -4 }, /* (299) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  394,   -3 }, /* (300) stream_options ::= stream_options WATERMARK duration_literal */
  {  394,   -4 }, /* (301) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  394,   -3 }, /* (302) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  395,    0 }, /* (303) subtable_opt ::= */
  {  395,   -4 }, /* (304) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  324,   -3 }, /* (305) cmd ::= KILL CONNECTION NK_INTEGER */
  {  324,   -3 }, /* (306) cmd ::= KILL QUERY NK_STRING */
  {  324,   -3 }, /* (307) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  324,   -2 }, /* (308) cmd ::= BALANCE VGROUP */
  {  324,   -4 }, /* (309) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  324,   -4 }, /* (310) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  324,   -3 }, /* (311) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  397,   -2 }, /* (312) dnode_list ::= DNODE NK_INTEGER */
  {  397,   -3 }, /* (313) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  324,   -4 }, /* (314) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  324,   -1 }, /* (315) cmd ::= query_or_subquery */
  {  324,   -7 }, /* (316) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  324,   -4 }, /* (317) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  327,   -1 }, /* (318) literal ::= NK_INTEGER */
  {  327,   -1 }, /* (319) literal ::= NK_FLOAT */
  {  327,   -1 }, /* (320) literal ::= NK_STRING */
  {  327,   -1 }, /* (321) literal ::= NK_BOOL */
  {  327,   -2 }, /* (322) literal ::= TIMESTAMP NK_STRING */
  {  327,   -1 }, /* (323) literal ::= duration_literal */
  {  327,   -1 }, /* (324) literal ::= NULL */
  {  327,   -1 }, /* (325) literal ::= NK_QUESTION */
  {  371,   -1 }, /* (326) duration_literal ::= NK_VARIABLE */
  {  399,   -1 }, /* (327) signed ::= NK_INTEGER */
  {  399,   -2 }, /* (328) signed ::= NK_PLUS NK_INTEGER */
  {  399,   -2 }, /* (329) signed ::= NK_MINUS NK_INTEGER */
  {  399,   -1 }, /* (330) signed ::= NK_FLOAT */
  {  399,   -2 }, /* (331) signed ::= NK_PLUS NK_FLOAT */
  {  399,   -2 }, /* (332) signed ::= NK_MINUS NK_FLOAT */
  {  360,   -1 }, /* (333) signed_literal ::= signed */
  {  360,   -1 }, /* (334) signed_literal ::= NK_STRING */
  {  360,   -1 }, /* (335) signed_literal ::= NK_BOOL */
  {  360,   -2 }, /* (336) signed_literal ::= TIMESTAMP NK_STRING */
  {  360,   -1 }, /* (337) signed_literal ::= duration_literal */
  {  360,   -1 }, /* (338) signed_literal ::= NULL */
  {  360,   -1 }, /* (339) signed_literal ::= literal_func */
  {  360,   -1 }, /* (340) signed_literal ::= NK_QUESTION */
  {  401,   -1 }, /* (341) literal_list ::= signed_literal */
  {  401,   -3 }, /* (342) literal_list ::= literal_list NK_COMMA signed_literal */
  {  335,   -1 }, /* (343) db_name ::= NK_ID */
  {  366,   -1 }, /* (344) table_name ::= NK_ID */
  {  358,   -1 }, /* (345) column_name ::= NK_ID */
  {  373,   -1 }, /* (346) function_name ::= NK_ID */
  {  402,   -1 }, /* (347) table_alias ::= NK_ID */
  {  381,   -1 }, /* (348) column_alias ::= NK_ID */
  {  329,   -1 }, /* (349) user_name ::= NK_ID */
  {  336,   -1 }, /* (350) topic_name ::= NK_ID */
  {  393,   -1 }, /* (351) stream_name ::= NK_ID */
  {  388,   -1 }, /* (352) cgroup_name ::= NK_ID */
  {  403,   -1 }, /* (353) expr_or_subquery ::= expression */
  {  396,   -1 }, /* (354) expression ::= literal */
  {  396,   -1 }, /* (355) expression ::= pseudo_column */
  {  396,   -1 }, /* (356) expression ::= column_reference */
  {  396,   -1 }, /* (357) expression ::= function_expression */
  {  396,   -1 }, /* (358) expression ::= case_when_expression */
  {  396,   -3 }, /* (359) expression ::= NK_LP expression NK_RP */
  {  396,   -2 }, /* (360) expression ::= NK_PLUS expr_or_subquery */
  {  396,   -2 }, /* (361) expression ::= NK_MINUS expr_or_subquery */
  {  396,   -3 }, /* (362) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  396,   -3 }, /* (363) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  396,   -3 }, /* (364) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  396,   -3 }, /* (365) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  396,   -3 }, /* (366) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  396,   -3 }, /* (367) expression ::= column_reference NK_ARROW NK_STRING */
  {  396,   -3 }, /* (368) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  396,   -3 }, /* (369) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  363,   -1 }, /* (370) expression_list ::= expr_or_subquery */
  {  363,   -3 }, /* (371) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  405,   -1 }, /* (372) column_reference ::= column_name */
  {  405,   -3 }, /* (373) column_reference ::= table_name NK_DOT column_name */
  {  404,   -1 }, /* (374) pseudo_column ::= ROWTS */
  {  404,   -1 }, /* (375) pseudo_column ::= TBNAME */
  {  404,   -3 }, /* (376) pseudo_column ::= table_name NK_DOT TBNAME */
  {  404,   -1 }, /* (377) pseudo_column ::= QSTART */
  {  404,   -1 }, /* (378) pseudo_column ::= QEND */
  {  404,   -1 }, /* (379) pseudo_column ::= QDURATION */
  {  404,   -1 }, /* (380) pseudo_column ::= WSTART */
  {  404,   -1 }, /* (381) pseudo_column ::= WEND */
  {  404,   -1 }, /* (382) pseudo_column ::= WDURATION */
  {  404,   -1 }, /* (383) pseudo_column ::= IROWTS */
  {  404,   -1 }, /* (384) pseudo_column ::= QTAGS */
  {  406,   -4 }, /* (385) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  406,   -4 }, /* (386) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  406,   -6 }, /* (387) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  406,   -1 }, /* (388) function_expression ::= literal_func */
  {  400,   -3 }, /* (389) literal_func ::= noarg_func NK_LP NK_RP */
  {  400,   -1 }, /* (390) literal_func ::= NOW */
  {  410,   -1 }, /* (391) noarg_func ::= NOW */
  {  410,   -1 }, /* (392) noarg_func ::= TODAY */
  {  410,   -1 }, /* (393) noarg_func ::= TIMEZONE */
  {  410,   -1 }, /* (394) noarg_func ::= DATABASE */
  {  410,   -1 }, /* (395) noarg_func ::= CLIENT_VERSION */
  {  410,   -1 }, /* (396) noarg_func ::= SERVER_VERSION */
  {  410,   -1 }, /* (397) noarg_func ::= SERVER_STATUS */
  {  410,   -1 }, /* (398) noarg_func ::= CURRENT_USER */
  {  410,   -1 }, /* (399) noarg_func ::= USER */
  {  408,   -1 }, /* (400) star_func ::= COUNT */
  {  408,   -1 }, /* (401) star_func ::= FIRST */
  {  408,   -1 }, /* (402) star_func ::= LAST */
  {  408,   -1 }, /* (403) star_func ::= LAST_ROW */
  {  409,   -1 }, /* (404) star_func_para_list ::= NK_STAR */
  {  409,   -1 }, /* (405) star_func_para_list ::= other_para_list */
  {  411,   -1 }, /* (406) other_para_list ::= star_func_para */
  {  411,   -3 }, /* (407) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  412,   -1 }, /* (408) star_func_para ::= expr_or_subquery */
  {  412,   -3 }, /* (409) star_func_para ::= table_name NK_DOT NK_STAR */
  {  407,   -4 }, /* (410) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  407,   -5 }, /* (411) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  413,   -1 }, /* (412) when_then_list ::= when_then_expr */
  {  413,   -2 }, /* (413) when_then_list ::= when_then_list when_then_expr */
  {  416,   -4 }, /* (414) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  414,    0 }, /* (415) case_when_else_opt ::= */
  {  414,   -2 }, /* (416) case_when_else_opt ::= ELSE common_expression */
  {  417,   -3 }, /* (417) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  417,   -5 }, /* (418) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  417,   -6 }, /* (419) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  417,   -3 }, /* (420) predicate ::= expr_or_subquery IS NULL */
  {  417,   -4 }, /* (421) predicate ::= expr_or_subquery IS NOT NULL */
  {  417,   -3 }, /* (422) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  418,   -1 }, /* (423) compare_op ::= NK_LT */
  {  418,   -1 }, /* (424) compare_op ::= NK_GT */
  {  418,   -1 }, /* (425) compare_op ::= NK_LE */
  {  418,   -1 }, /* (426) compare_op ::= NK_GE */
  {  418,   -1 }, /* (427) compare_op ::= NK_NE */
  {  418,   -1 }, /* (428) compare_op ::= NK_EQ */
  {  418,   -1 }, /* (429) compare_op ::= LIKE */
  {  418,   -2 }, /* (430) compare_op ::= NOT LIKE */
  {  418,   -1 }, /* (431) compare_op ::= MATCH */
  {  418,   -1 }, /* (432) compare_op ::= NMATCH */
  {  418,   -1 }, /* (433) compare_op ::= CONTAINS */
  {  419,   -1 }, /* (434) in_op ::= IN */
  {  419,   -2 }, /* (435) in_op ::= NOT IN */
  {  420,   -3 }, /* (436) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  421,   -1 }, /* (437) boolean_value_expression ::= boolean_primary */
  {  421,   -2 }, /* (438) boolean_value_expression ::= NOT boolean_primary */
  {  421,   -3 }, /* (439) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  421,   -3 }, /* (440) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  422,   -1 }, /* (441) boolean_primary ::= predicate */
  {  422,   -3 }, /* (442) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  415,   -1 }, /* (443) common_expression ::= expr_or_subquery */
  {  415,   -1 }, /* (444) common_expression ::= boolean_value_expression */
  {  423,    0 }, /* (445) from_clause_opt ::= */
  {  423,   -2 }, /* (446) from_clause_opt ::= FROM table_reference_list */
  {  424,   -1 }, /* (447) table_reference_list ::= table_reference */
  {  424,   -3 }, /* (448) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  425,   -1 }, /* (449) table_reference ::= table_primary */
  {  425,   -1 }, /* (450) table_reference ::= joined_table */
  {  426,   -2 }, /* (451) table_primary ::= table_name alias_opt */
  {  426,   -4 }, /* (452) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  426,   -2 }, /* (453) table_primary ::= subquery alias_opt */
  {  426,   -1 }, /* (454) table_primary ::= parenthesized_joined_table */
  {  428,    0 }, /* (455) alias_opt ::= */
  {  428,   -1 }, /* (456) alias_opt ::= table_alias */
  {  428,   -2 }, /* (457) alias_opt ::= AS table_alias */
  {  430,   -3 }, /* (458) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  430,   -3 }, /* (459) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  427,   -6 }, /* (460) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  431,    0 }, /* (461) join_type ::= */
  {  431,   -1 }, /* (462) join_type ::= INNER */
  {  433,  -12 }, /* (463) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  434,    0 }, /* (464) set_quantifier_opt ::= */
  {  434,   -1 }, /* (465) set_quantifier_opt ::= DISTINCT */
  {  434,   -1 }, /* (466) set_quantifier_opt ::= ALL */
  {  435,   -1 }, /* (467) select_list ::= select_item */
  {  435,   -3 }, /* (468) select_list ::= select_list NK_COMMA select_item */
  {  443,   -1 }, /* (469) select_item ::= NK_STAR */
  {  443,   -1 }, /* (470) select_item ::= common_expression */
  {  443,   -2 }, /* (471) select_item ::= common_expression column_alias */
  {  443,   -3 }, /* (472) select_item ::= common_expression AS column_alias */
  {  443,   -3 }, /* (473) select_item ::= table_name NK_DOT NK_STAR */
  {  398,    0 }, /* (474) where_clause_opt ::= */
  {  398,   -2 }, /* (475) where_clause_opt ::= WHERE search_condition */
  {  436,    0 }, /* (476) partition_by_clause_opt ::= */
  {  436,   -3 }, /* (477) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  444,   -1 }, /* (478) partition_list ::= partition_item */
  {  444,   -3 }, /* (479) partition_list ::= partition_list NK_COMMA partition_item */
  {  445,   -1 }, /* (480) partition_item ::= expr_or_subquery */
  {  445,   -2 }, /* (481) partition_item ::= expr_or_subquery column_alias */
  {  445,   -3 }, /* (482) partition_item ::= expr_or_subquery AS column_alias */
  {  440,    0 }, /* (483) twindow_clause_opt ::= */
  {  440,   -6 }, /* (484) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  440,   -4 }, /* (485) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  440,   -6 }, /* (486) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  440,   -8 }, /* (487) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  440,   -7 }, /* (488) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  384,    0 }, /* (489) sliding_opt ::= */
  {  384,   -4 }, /* (490) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  439,    0 }, /* (491) fill_opt ::= */
  {  439,   -4 }, /* (492) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  439,   -6 }, /* (493) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  446,   -1 }, /* (494) fill_mode ::= NONE */
  {  446,   -1 }, /* (495) fill_mode ::= PREV */
  {  446,   -1 }, /* (496) fill_mode ::= NULL */
  {  446,   -1 }, /* (497) fill_mode ::= LINEAR */
  {  446,   -1 }, /* (498) fill_mode ::= NEXT */
  {  441,    0 }, /* (499) group_by_clause_opt ::= */
  {  441,   -3 }, /* (500) group_by_clause_opt ::= GROUP BY group_by_list */
  {  447,   -1 }, /* (501) group_by_list ::= expr_or_subquery */
  {  447,   -3 }, /* (502) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  442,    0 }, /* (503) having_clause_opt ::= */
  {  442,   -2 }, /* (504) having_clause_opt ::= HAVING search_condition */
  {  437,    0 }, /* (505) range_opt ::= */
  {  437,   -6 }, /* (506) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  438,    0 }, /* (507) every_opt ::= */
  {  438,   -4 }, /* (508) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  448,   -4 }, /* (509) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  449,   -1 }, /* (510) query_simple ::= query_specification */
  {  449,   -1 }, /* (511) query_simple ::= union_query_expression */
  {  453,   -4 }, /* (512) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  453,   -3 }, /* (513) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  454,   -1 }, /* (514) query_simple_or_subquery ::= query_simple */
  {  454,   -1 }, /* (515) query_simple_or_subquery ::= subquery */
  {  387,   -1 }, /* (516) query_or_subquery ::= query_expression */
  {  387,   -1 }, /* (517) query_or_subquery ::= subquery */
  {  450,    0 }, /* (518) order_by_clause_opt ::= */
  {  450,   -3 }, /* (519) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  451,    0 }, /* (520) slimit_clause_opt ::= */
  {  451,   -2 }, /* (521) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  451,   -4 }, /* (522) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  451,   -4 }, /* (523) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  452,    0 }, /* (524) limit_clause_opt ::= */
  {  452,   -2 }, /* (525) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  452,   -4 }, /* (526) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  452,   -4 }, /* (527) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  429,   -3 }, /* (528) subquery ::= NK_LP query_expression NK_RP */
  {  429,   -3 }, /* (529) subquery ::= NK_LP subquery NK_RP */
  {  432,   -1 }, /* (530) search_condition ::= common_expression */
  {  455,   -1 }, /* (531) sort_specification_list ::= sort_specification */
  {  455,   -3 }, /* (532) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  456,   -3 }, /* (533) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  457,    0 }, /* (534) ordering_specification_opt ::= */
  {  457,   -1 }, /* (535) ordering_specification_opt ::= ASC */
  {  457,   -1 }, /* (536) ordering_specification_opt ::= DESC */
  {  458,    0 }, /* (537) null_ordering_opt ::= */
  {  458,   -2 }, /* (538) null_ordering_opt ::= NULLS FIRST */
  {  458,   -2 }, /* (539) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,325,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy317, &yymsp[-1].minor.yy0, yymsp[0].minor.yy449); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy449 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy449 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy531, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy531, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy531 = yymsp[0].minor.yy531; }
  yymsp[0].minor.yy531 = yylhsminor.yy531;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy531 = yymsp[-2].minor.yy531 | yymsp[0].minor.yy531; }
  yymsp[-2].minor.yy531 = yylhsminor.yy531;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy317 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy317 = yylhsminor.yy317;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy317 = yymsp[-2].minor.yy317; }
  yymsp[-2].minor.yy317 = yylhsminor.yy317;
        break;
      case 42: /* priv_level ::= topic_name */
      case 456: /* alias_opt ::= table_alias */ yytestcase(yyruleno==456);
{ yylhsminor.yy317 = yymsp[0].minor.yy317; }
  yymsp[0].minor.yy317 = yylhsminor.yy317;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy317, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy335); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy335); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 343: /* db_name ::= NK_ID */ yytestcase(yyruleno==343);
      case 344: /* table_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* column_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* function_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* table_alias ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* column_alias ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* user_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* topic_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* stream_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 391: /* noarg_func ::= NOW */ yytestcase(yyruleno==391);
      case 392: /* noarg_func ::= TODAY */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= USER */ yytestcase(yyruleno==399);
      case 400: /* star_func ::= COUNT */ yytestcase(yyruleno==400);
      case 401: /* star_func ::= FIRST */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= LAST */ yytestcase(yyruleno==402);
      case 403: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==403);
{ yylhsminor.yy317 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy317 = yylhsminor.yy317;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 283: /* analyze_opt ::= */ yytestcase(yyruleno==283);
      case 290: /* agg_func_opt ::= */ yytestcase(yyruleno==290);
      case 464: /* set_quantifier_opt ::= */ yytestcase(yyruleno==464);
{ yymsp[1].minor.yy335 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 284: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==284);
      case 291: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==291);
      case 465: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==465);
{ yymsp[0].minor.yy335 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy335, &yymsp[-1].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy856); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy335 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy335 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy74 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_KEEP, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 92: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_RETENTIONS, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-3].minor.yy74, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-3].minor.yy74, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy74 = createAlterDatabaseOptions(pCxt); yylhsminor.yy74 = setAlterDatabaseOption(pCxt, yylhsminor.yy74, &yymsp[0].minor.yy767); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy74 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy74, &yymsp[0].minor.yy767); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy767.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy767.type = DB_OPTION_KEEP; yymsp[-1].minor.yy767.pList = yymsp[0].minor.yy874; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_PAGES; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_WAL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 313: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==313);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy874 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==254);
      case 265: /* func_list ::= func */ yytestcase(yyruleno==265);
      case 341: /* literal_list ::= signed_literal */ yytestcase(yyruleno==341);
      case 406: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==406);
      case 412: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==412);
      case 467: /* select_list ::= select_item */ yytestcase(yyruleno==467);
      case 478: /* partition_list ::= partition_item */ yytestcase(yyruleno==478);
      case 531: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==531);
{ yylhsminor.yy874 = createNodeList(pCxt, yymsp[0].minor.yy74); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 255: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==255);
      case 266: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==266);
      case 342: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==342);
      case 407: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==407);
      case 468: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==468);
      case 479: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==479);
      case 532: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==532);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy74 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 127: /* speed_opt ::= */
      case 292: /* bufsize_opt ::= */ yytestcase(yyruleno==292);
{ yymsp[1].minor.yy856 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 293: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==293);
{ yymsp[-1].minor.yy856 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy335, yymsp[-5].minor.yy74, yymsp[-3].minor.yy874, yymsp[-1].minor.yy874, yymsp[0].minor.yy74); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 315: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==315);
{ pCxt->pRootNode = yymsp[0].minor.yy74; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy74); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy74 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy74 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy74, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy74 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy74 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy74, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy74 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy74 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy74, &yymsp[-2].minor.yy317, yymsp[0].minor.yy74); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 413: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==413);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-1].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy874 = yylhsminor.yy874;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy74 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy335, yymsp[-8].minor.yy74, yymsp[-6].minor.yy74, yymsp[-5].minor.yy874, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-9].minor.yy74 = yylhsminor.yy74;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy74 = createDropTableClause(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 253: /* tag_list_opt ::= */ yytestcase(yyruleno==253);
      case 476: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==476);
      case 499: /* group_by_clause_opt ::= */ yytestcase(yyruleno==499);
      case 518: /* order_by_clause_opt ::= */ yytestcase(yyruleno==518);
{ yymsp[1].minor.yy874 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy74 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy317, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy74 = createRealTableNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317, NULL); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy74 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898, NULL); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy74 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-2].minor.yy898, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 405: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==405);
{ yylhsminor.yy874 = yymsp[0].minor.yy874; }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy74 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-4].minor.yy74, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-4].minor.yy74, TABLE_OPTION_SMA, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy74 = createAlterTableOptions(pCxt); yylhsminor.yy74 = setTableOption(pCxt, yylhsminor.yy74, yymsp[0].minor.yy767.type, &yymsp[0].minor.yy767.val); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy767.type, &yymsp[0].minor.yy767.val); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy767.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy767.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 370: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==370);
{ yylhsminor.yy874 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 371: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==371);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[0].minor.yy317, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 257: /* tag_item ::= QTAGS */ yytestcase(yyruleno==257);
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 207: /* col_name ::= column_name */
      case 258: /* tag_item ::= column_name */ yytestcase(yyruleno==258);
{ yylhsminor.yy74 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy317); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy74, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy74, yymsp[-1].minor.yy74, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy74); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy74); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy74); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy74); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy74, yymsp[-1].minor.yy74, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74, yymsp[-3].minor.yy874); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* db_name_cond_opt ::= */
      case 251: /* from_db_opt ::= */ yytestcase(yyruleno==251);
{ yymsp[1].minor.yy74 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 247: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy74 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 248: /* like_pattern_opt ::= */
      case 303: /* subtable_opt ::= */ yytestcase(yyruleno==303);
      case 415: /* case_when_else_opt ::= */ yytestcase(yyruleno==415);
      case 445: /* from_clause_opt ::= */ yytestcase(yyruleno==445);
      case 474: /* where_clause_opt ::= */ yytestcase(yyruleno==474);
      case 483: /* twindow_clause_opt ::= */ yytestcase(yyruleno==483);
      case 489: /* sliding_opt ::= */ yytestcase(yyruleno==489);
      case 491: /* fill_opt ::= */ yytestcase(yyruleno==491);
      case 503: /* having_clause_opt ::= */ yytestcase(yyruleno==503);
      case 505: /* range_opt ::= */ yytestcase(yyruleno==505);
      case 507: /* every_opt ::= */ yytestcase(yyruleno==507);
      case 520: /* slimit_clause_opt ::= */ yytestcase(yyruleno==520);
      case 524: /* limit_clause_opt ::= */ yytestcase(yyruleno==524);
{ yymsp[1].minor.yy74 = NULL; }
        break;
      case 249: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 250: /* table_name_cond ::= table_name */
{ yylhsminor.yy74 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy317); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 252: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy74 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 256: /* tag_item ::= TBNAME */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 259: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy317), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 260: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy317), &yymsp[0].minor.yy317); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 261: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy335, yymsp[-3].minor.yy74, yymsp[-1].minor.yy74, NULL, yymsp[0].minor.yy74); }
        break;
      case 262: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy74 = createIndexOption(pCxt, yymsp[-7].minor.yy874, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy74 = createIndexOption(pCxt, yymsp[-9].minor.yy874, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 267: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-1].minor.yy874); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 268: /* sma_stream_opt ::= */
      case 296: /* stream_options ::= */ yytestcase(yyruleno==296);
{ yymsp[1].minor.yy74 = createStreamOptions(pCxt); }
        break;
      case 269: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 300: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==300);
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 271: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 272: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy335, &yymsp[-2].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy335, &yymsp[-3].minor.yy317, &yymsp[0].minor.yy317, false); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy335, &yymsp[-5].minor.yy317, &yymsp[0].minor.yy317, true); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy335, &yymsp[-3].minor.yy317, yymsp[0].minor.yy74, false); }
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy335, &yymsp[-5].minor.yy317, yymsp[0].minor.yy74, true); }
        break;
      case 277: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 278: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy335, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 279: /* cmd ::= DESC full_table_name */
      case 280: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==280);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy74); }
        break;
      case 281: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 282: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy335, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 285: /* explain_options ::= */
{ yymsp[1].minor.yy74 = createDefaultExplainOptions(pCxt); }
        break;
      case 286: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy74 = setExplainVerbose(pCxt, yymsp[-2].minor.yy74, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 287: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy74 = setExplainRatio(pCxt, yymsp[-2].minor.yy74, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 288: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy335, yymsp[-8].minor.yy335, &yymsp[-5].minor.yy317, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy898, yymsp[0].minor.yy856); }
        break;
      case 289: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 294: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy335, &yymsp[-7].minor.yy317, yymsp[-4].minor.yy74, yymsp[-6].minor.yy74, yymsp[-3].minor.yy874, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 295: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 297: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 298: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 299: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy74)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy74)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-3].minor.yy74; }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 301: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy74)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy74 = yymsp[-3].minor.yy74; }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 302: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 304: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 490: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==490);
      case 508: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==508);
{ yymsp[-3].minor.yy74 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy74); }
        break;
      case 305: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 306: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 308: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 309: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 310: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy874); }
        break;
      case 311: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 312: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 314: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 316: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy74, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
        break;
      case 317: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy74, NULL, yymsp[0].minor.yy74); }
        break;
      case 318: /* literal ::= NK_INTEGER */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 319: /* literal ::= NK_FLOAT */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 320: /* literal ::= NK_STRING */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 321: /* literal ::= NK_BOOL */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 322: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 323: /* literal ::= duration_literal */
      case 333: /* signed_literal ::= signed */ yytestcase(yyruleno==333);
      case 353: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==353);
      case 354: /* expression ::= literal */ yytestcase(yyruleno==354);
      case 355: /* expression ::= pseudo_column */ yytestcase(yyruleno==355);
      case 356: /* expression ::= column_reference */ yytestcase(yyruleno==356);
      case 357: /* expression ::= function_expression */ yytestcase(yyruleno==357);
      case 358: /* expression ::= case_when_expression */ yytestcase(yyruleno==358);
      case 388: /* function_expression ::= literal_func */ yytestcase(yyruleno==388);
      case 437: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==437);
      case 441: /* boolean_primary ::= predicate */ yytestcase(yyruleno==441);
      case 443: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==443);
      case 444: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==444);
      case 447: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==447);
      case 449: /* table_reference ::= table_primary */ yytestcase(yyruleno==449);
      case 450: /* table_reference ::= joined_table */ yytestcase(yyruleno==450);
      case 454: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==454);
      case 510: /* query_simple ::= query_specification */ yytestcase(yyruleno==510);
      case 511: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==511);
      case 514: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==514);
      case 516: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==516);
{ yylhsminor.yy74 = yymsp[0].minor.yy74; }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 324: /* literal ::= NULL */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 325: /* literal ::= NK_QUESTION */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 326: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 327: /* signed ::= NK_INTEGER */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 328: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 329: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 330: /* signed ::= NK_FLOAT */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 331: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 332: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 334: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 335: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 336: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 337: /* signed_literal ::= duration_literal */
      case 339: /* signed_literal ::= literal_func */ yytestcase(yyruleno==339);
      case 408: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==408);
      case 470: /* select_item ::= common_expression */ yytestcase(yyruleno==470);
      case 480: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==480);
      case 515: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==515);
      case 517: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==517);
      case 530: /* search_condition ::= common_expression */ yytestcase(yyruleno==530);
{ yylhsminor.yy74 = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 338: /* signed_literal ::= NULL */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 340: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy74 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 359: /* expression ::= NK_LP expression NK_RP */
      case 442: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==442);
      case 529: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==529);
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 360: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy74));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 361: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy74), NULL));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 362: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 363: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 364: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 365: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 366: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 367: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 368: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 369: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 372: /* column_reference ::= column_name */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy317, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy317)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 373: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317, createColumnNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 374: /* pseudo_column ::= ROWTS */
      case 375: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==375);
      case 377: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==377);
      case 378: /* pseudo_column ::= QEND */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= WEND */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==384);
      case 390: /* literal_func ::= NOW */ yytestcase(yyruleno==390);
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 376: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy317)))); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 385: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 386: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==386);
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-1].minor.yy874)); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 387: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy898)); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 389: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy317, NULL)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 404: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy874 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 409: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 473: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==473);
{ yylhsminor.yy74 = createColumnNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 410: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy874, yymsp[-1].minor.yy74)); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 411: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-2].minor.yy874, yymsp[-1].minor.yy74)); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 414: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy74 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
        break;
      case 416: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy74 = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); }
        break;
      case 417: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 422: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==422);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy20, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 418: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy74), releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 419: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 420: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), NULL));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 421: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL));
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 423: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_THAN; }
        break;
      case 424: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_THAN; }
        break;
      case 425: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 426: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 427: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy20 = OP_TYPE_NOT_EQUAL; }
        break;
      case 428: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy20 = OP_TYPE_EQUAL; }
        break;
      case 429: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy20 = OP_TYPE_LIKE; }
        break;
      case 430: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_LIKE; }
        break;
      case 431: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_MATCH; }
        break;
      case 432: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_NMATCH; }
        break;
      case 433: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy20 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 434: /* in_op ::= IN */
{ yymsp[0].minor.yy20 = OP_TYPE_IN; }
        break;
      case 435: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_IN; }
        break;
      case 436: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 438: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy74), NULL));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 439: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 440: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 446: /* from_clause_opt ::= FROM table_reference_list */
      case 475: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==475);
      case 504: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==504);
{ yymsp[-1].minor.yy74 = yymsp[0].minor.yy74; }
        break;
      case 448: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy74 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, NULL); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 451: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy74 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 452: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy74 = createRealTableNode(pCxt, &yymsp[-3].minor.yy317, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 453: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy74 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 455: /* alias_opt ::= */
{ yymsp[1].minor.yy317 = nil_token;  }
        break;
      case 457: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy317 = yymsp[0].minor.yy317; }
        break;
      case 458: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 459: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==459);
{ yymsp[-2].minor.yy74 = yymsp[-1].minor.yy74; }
        break;
      case 460: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy74 = createJoinTableNode(pCxt, yymsp[-4].minor.yy630, yymsp[-5].minor.yy74, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 461: /* join_type ::= */
{ yymsp[1].minor.yy630 = JOIN_TYPE_INNER; }
        break;
      case 462: /* join_type ::= INNER */
{ yymsp[0].minor.yy630 = JOIN_TYPE_INNER; }
        break;
      case 463: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy74 = createSelectStmt(pCxt, yymsp[-10].minor.yy335, yymsp[-9].minor.yy874, yymsp[-8].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addWhereClause(pCxt, yymsp[-11].minor.yy74, yymsp[-7].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addPartitionByClause(pCxt, yymsp[-11].minor.yy74, yymsp[-6].minor.yy874);
                                                                                    yymsp[-11].minor.yy74 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy74, yymsp[-2].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addGroupByClause(pCxt, yymsp[-11].minor.yy74, yymsp[-1].minor.yy874);
                                                                                    yymsp[-11].minor.yy74 = addHavingClause(pCxt, yymsp[-11].minor.yy74, yymsp[0].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addRangeClause(pCxt, yymsp[-11].minor.yy74, yymsp[-5].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addEveryClause(pCxt, yymsp[-11].minor.yy74, yymsp[-4].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addFillClause(pCxt, yymsp[-11].minor.yy74, yymsp[-3].minor.yy74);
                                                                                  }
        break;
      case 466: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy335 = false; }
        break;
      case 469: /* select_item ::= NK_STAR */
{ yylhsminor.yy74 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 471: /* select_item ::= common_expression column_alias */
      case 481: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==481);
{ yylhsminor.yy74 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 472: /* select_item ::= common_expression AS column_alias */
      case 482: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==482);
{ yylhsminor.yy74 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 477: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 500: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==500);
      case 519: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==519);
{ yymsp[-2].minor.yy874 = yymsp[0].minor.yy874; }
        break;
      case 484: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy74 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 485: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy74 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 486: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy74 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 487: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy74 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 488: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy74 = createEventWindowNode(pCxt, yymsp[-3].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 492: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy74 = createFillNode(pCxt, yymsp[-1].minor.yy828, NULL); }
        break;
      case 493: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy74 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
        break;
      case 494: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy828 = FILL_MODE_NONE; }
        break;
      case 495: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy828 = FILL_MODE_PREV; }
        break;
      case 496: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy828 = FILL_MODE_NULL; }
        break;
      case 497: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy828 = FILL_MODE_LINEAR; }
        break;
      case 498: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy828 = FILL_MODE_NEXT; }
        break;
      case 501: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy874 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 502: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 506: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy74 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 509: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy74 = addOrderByClause(pCxt, yymsp[-3].minor.yy74, yymsp[-2].minor.yy874);
                                                                                    yylhsminor.yy74 = addSlimitClause(pCxt, yylhsminor.yy74, yymsp[-1].minor.yy74);
                                                                                    yylhsminor.yy74 = addLimitClause(pCxt, yylhsminor.yy74, yymsp[0].minor.yy74);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 512: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy74 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 513: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy74 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 521: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 525: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==525);
{ yymsp[-1].minor.yy74 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 522: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 526: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==526);
{ yymsp[-3].minor.yy74 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 523: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 527: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==527);
{ yymsp[-3].minor.yy74 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 528: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy74); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 533: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy74 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), yymsp[-1].minor.yy326, yymsp[0].minor.yy109); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 534: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy326 = ORDER_ASC; }
        break;
      case 535: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy326 = ORDER_ASC; }
        break;
      case 536: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy326 = ORDER_DESC; }
        break;
      case 537: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy109 = NULL_ORDER_DEFAULT; }
        break;
      case 538: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_FIRST; }
        break;
      case 539: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
