###################################################################
#           Copyright (c) 2021 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
from util.log import *
from util.cases import *
from util.sql import *


class TDTestCase:
    def caseDescription(self):
        '''
        case1<Ganlin Zhao>: [TD-11220]<feature>: time related functions
        '''
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def getBuildPath(self):
        selfPath = os.path.dirname(os.path.realpath(__file__))

        if ("community" in selfPath):
            projPath = selfPath[:selfPath.find("community")]
        else:
            projPath = selfPath[:selfPath.find("tests")]

        for root, dirs, files in os.walk(projPath):
            if ("taosd" in files):
                rootRealPath = os.path.dirname(os.path.realpath(root))
                if ("packaging" not in rootRealPath):
                    buildPath = root[:len(root) - len("/build/bin")]
                    break
        return buildPath

    def getISOTimeFmt(self, epoch, precision = None, delta = datetime.timedelta(hours = 8)):
        if precision == "m":
            time = datetime.datetime.fromtimestamp(epoch / 1000, tz = datetime.timezone(delta))
            time_str = time.strftime("%Y-%m-%dT%H:%M:%S.%f%z")
            tz = time_str[-5:]
            return time_str[:-8] + tz
        elif precision == "u":
            time = datetime.datetime.fromtimestamp(epoch / 1000000, tz = datetime.timezone(delta))
            return time.strftime("%Y-%m-%dT%H:%M:%S.%f%z")
        elif precision == "n":
            time = datetime.datetime.fromtimestamp(epoch / 1000000000, tz = datetime.timezone(delta))
            time_str = time.strftime("%Y-%m-%dT%H:%M:%S.%f%z")
            tz = time_str[-5:]
            nanoDigits = str(epoch)[-3:]
            return time_str[:-5] + nanoDigits + tz

        else:
            time = datetime.datetime.fromtimestamp(epoch, tz = datetime.timezone(delta))
            return time.strftime("%Y-%m-%dT%H:%M:%S%z")

    def checkTimestampEqual(self, elm, expect_elm):
        caller = inspect.getframeinfo(inspect.stack()[1][0])
        if len(elm) == len(expect_elm):
            delta = abs(int(elm[-1]) - int(expect_elm[-1]))
            if delta == 1: #ignore 1 second diff
                new_elm = expect_elm[0:-1] + elm[-1]
            else:
                new_elm = expect_elm;
            if elm == new_elm:
                tdLog.info("sql:%s, elm:%s == expect_elm:%s" % (tdSql.sql, elm, new_elm))
            else:
                args = (caller.filename, caller.lineno, tdSql.sql, elm, new_elm)
                tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)
        else:
            args = (caller.filename, caller.lineno, tdSql.sql, elm, expect_elm)
            tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)


    def run(self):
        print("running {}".format(__file__))

        #Prepare data
        #db precision "ms"
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp1 timestamp, col_timestamp2 timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp1 timestamp, col_timestamp2 timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '1970-01-01 08:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '1970-01-01 08:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "us"
        tdSql.execute("drop database if exists db_u")
        tdSql.execute("create database if not exists db_u precision 'us'")
        tdSql.execute('use db_u')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp1 timestamp, col_timestamp2 timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp1 timestamp, col_timestamp2 timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '1970-01-01 08:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '1970-01-01 08:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "ns"
        tdSql.execute("drop database if exists db_n")
        tdSql.execute("create database if not exists db_n precision 'ns'")
        tdSql.execute('use db_n')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp1 timestamp, col_timestamp2 timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp1 timestamp, col_timestamp2 timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '1970-01-01 08:00:00', '1970-01-01 08:01:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '1970-01-01 08:00:00', '1970-01-01 08:01:01'1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #execute query
        print("============== STEP 1: select timediff() with milliesecond db precision ================== ")

        tdSql.execute('use db_m')
        #epoch as input
        ts1 = 61
        ts2 = 0
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = 93015030 #1972-12-12 13:30:30 GMT+08:00
        ts2 = 93019240 #1972-12-12 14:40:40 GMT+08:00
        delta = ts2 - ts1
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts2 = 1645018230 #2022-02-16 13:30:30 GMT+08:00
        ts1 = 1643779830 #2022-02-02 13:30:30 GMT+08:00
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        ts1 = 1643779832123 #2022-2-2 13:30:32.123 GMT+08:00
        ts2 = 1643779830000 #2022-2-2 13:30:30.000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = 1643779830123456 #2022-2-2 13:30:32.123456 GMT+08:00
        ts2 = 1643779830000000 #2022-2-2 13:30:32.000000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = 1643779830123456789 #2022-2-2 13:30:32.123456789 GMT+08:00
        ts2 = 1643779830000000000 #2022-2-2 13:30:32.000000000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        #datetime string as input
        ts1 = "1970-01-01 08:01:01" # 61
        ts2 = "1970-01-01 08:00:00" # 61

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "1972-12-12 13:30:30" # 92986230
        ts2 = "1972-12-12 14:40:40" # 92990440
        delta = abs(92986230 - 92990440)
        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "2022-02-16 13:30:30" #1644989430
        ts2 = "2022-02-02 13:30:30" #1643779830

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        ts1 = "2022-2-2 13:30:32.123" #1643779832123
        ts2 = "2022-2-2 13:30:30.000" #1643779830000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "2022-2-2 13:30:32.123456" # 1643779830123456
        ts2 = "2022-2-2 13:30:32.000000" # 1643779830000000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = "2022-2-2 13:30:32.123456789" #1643779830123456789
        ts2 = "2022-2-2 13:30:32.000000000" #1643779830000000000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        #timestamp column as input
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', '1972-12-12 14:40:40', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2022-02-2 13:30:30', '2022-02-16 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', '2022-02-02 13:30:30.000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', '2022-02-02 13:30:30.000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', '2022-02-02 13:30:30.000000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', '1972-12-12 14:40:40', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2022-02-2 13:30:30', '2022-02-16 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', '2022-02-02 13:30:30.000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', '2022-02-02 13:30:30.000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', '2022-02-02 13:30:30.000000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")


        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        #timestamp column and epoch as input
        #epoch 0
        tdSql.query("select timediff(0, col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)

        tdSql.query("select timediff(0, col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        tdSql.query("select timediff(0, col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff(0, col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff(0, col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)

        tdSql.query("select timediff(0, col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff(0, col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff(0, col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)

        tdSql.query("select timediff(0, col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff(0, col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff(0, col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)

        tdSql.query("select timediff(0, col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff(0, col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff(0, col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)

        tdSql.query("select timediff(0, col_timestamp2, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff(0, col_timestamp2, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff(0, col_timestamp2, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)

        #epoch 1643779830 2022-2-2 13:30:30 GMT+08:00
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        #timestamp column and date-time string as input
        #"1970-01-01 08:00:00"
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)


        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)


        #"2022-2-2 13:30:30" GMT+08:00
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123000)
        rest = tdSql.checkData(5, 0, 123000)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)


        print("============== STEP 2: select timediff() with microsecond db precision ================== ")

        tdSql.execute('use db_u')

        #epoch as input
        ts1 = 61
        ts2 = 0
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = 93015030 #1972-12-12 13:30:30 GMT+08:00
        ts2 = 93019240 #1972-12-12 14:40:40 GMT+08:00
        delta = ts2 - ts1
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts2 = 1645018230 #2022-02-16 13:30:30 GMT+08:00
        ts1 = 1643779830 #2022-02-02 13:30:30 GMT+08:00
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        ts1 = 1643779832123 #2022-2-2 13:30:32.123 GMT+08:00
        ts2 = 1643779830000 #2022-2-2 13:30:30.000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = 1643779830123456 #2022-2-2 13:30:32.123456 GMT+08:00
        ts2 = 1643779830000000 #2022-2-2 13:30:32.000000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = 1643779830123456789 #2022-2-2 13:30:32.123456789 GMT+08:00
        ts2 = 1643779830000000000 #2022-2-2 13:30:32.000000000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        #datetime string as input
        ts1 = "1970-01-01 08:01:01" # 61
        ts2 = "1970-01-01 08:00:00" # 61

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "1972-12-12 13:30:30" # 92986230
        ts2 = "1972-12-12 14:40:40" # 92990440
        delta = abs(92986230 - 92990440)
        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "2022-02-16 13:30:30" #1644989430
        ts2 = "2022-02-02 13:30:30" #1643779830

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        ts1 = "2022-2-2 13:30:32.123" #1643779832123
        ts2 = "2022-2-2 13:30:30.000" #1643779830000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "2022-2-2 13:30:32.123456" # 1643779830123456
        ts2 = "2022-2-2 13:30:32.000000" # 1643779830000000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = "2022-2-2 13:30:32.123456789" #1643779830123456789
        ts2 = "2022-2-2 13:30:32.000000000" #1643779830000000000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        #timestamp column as input
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', '1972-12-12 14:40:40', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2022-02-2 13:30:30', '2022-02-16 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', '2022-02-02 13:30:30.000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', '2022-02-02 13:30:30.000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', '2022-02-02 13:30:30.000000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', '1972-12-12 14:40:40', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2022-02-2 13:30:30', '2022-02-16 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', '2022-02-02 13:30:30.000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', '2022-02-02 13:30:30.000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', '2022-02-02 13:30:30.000000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")


        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        #timestamp column and epoch as input
        #epoch 0
        tdSql.query("select timediff(0, col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)

        tdSql.query("select timediff(0, col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        tdSql.query("select timediff(0, col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff(0, col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff(0, col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)

        tdSql.query("select timediff(0, col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff(0, col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff(0, col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)

        tdSql.query("select timediff(0, col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff(0, col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff(0, col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)

        tdSql.query("select timediff(0, col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff(0, col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff(0, col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)

        tdSql.query("select timediff(0, col_timestamp2, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff(0, col_timestamp2, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff(0, col_timestamp2, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)

        #epoch 1643779830 2022-2-2 13:30:30 GMT+08:00
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        #timestamp column and date-time string as input
        #"1970-01-01 08:00:00"
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)


        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)


        #"2022-2-2 13:30:30" GMT+08:00
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        print("============== STEP 3: select timediff() with nanosecond db precision ================== ")

        tdSql.execute('use db_n')

        #epoch as input
        ts1 = 61
        ts2 = 0
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = 93015030 #1972-12-12 13:30:30 GMT+08:00
        ts2 = 93019240 #1972-12-12 14:40:40 GMT+08:00
        delta = ts2 - ts1
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts2 = 1645018230 #2022-02-16 13:30:30 GMT+08:00
        ts1 = 1643779830 #2022-02-02 13:30:30 GMT+08:00
        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400000)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1238400)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20640)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 344)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        ts1 = 1643779832123 #2022-2-2 13:30:32.123 GMT+08:00
        ts2 = 1643779830000 #2022-2-2 13:30:30.000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = 1643779830123456 #2022-2-2 13:30:32.123456 GMT+08:00
        ts2 = 1643779830000000 #2022-2-2 13:30:32.000000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = 1643779830123456789 #2022-2-2 13:30:32.123456789 GMT+08:00
        ts2 = 1643779830000000000 #2022-2-2 13:30:32.000000000 GMT+08:00

        tdSql.query("select timediff(%d, %d, 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff(%d, %d, 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff(%d, %d, 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff(%d, %d, 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff(%d, %d, 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff(%d, %d, 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff(%d, %d, 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        #datetime string as input
        ts1 = "1970-01-01 08:01:01" # 61
        ts2 = "1970-01-01 08:00:00" # 61

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 61)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "1972-12-12 13:30:30" # 92986230
        ts2 = "1972-12-12 14:40:40" # 92990440
        delta = abs(92986230 - 92990440)
        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta * 1000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, delta)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(delta / 60))

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, int(int(delta / 60) / 60))

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "2022-02-16 13:30:30" #1644989430
        ts2 = "2022-02-02 13:30:30" #1643779830

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600000)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1209600)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 20160)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 336)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 14)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        ts1 = "2022-2-2 13:30:32.123" #1643779832123
        ts2 = "2022-2-2 13:30:30.000" #1643779830000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123000)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)


        ts1 = "2022-2-2 13:30:32.123456" # 1643779830123456
        ts2 = "2022-2-2 13:30:32.000000" # 1643779830000000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        ts1 = "2022-2-2 13:30:32.123456789" #1643779830123456789
        ts2 = "2022-2-2 13:30:32.000000000" #1643779830000000000

        tdSql.query("select timediff('%s', '%s', 1u) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)
        tdSql.query("select timediff('%s', '%s', 1u) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123456)

        tdSql.query("select timediff('%s', '%s', 1a) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)
        tdSql.query("select timediff('%s', '%s', 1a) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 123)

        tdSql.query("select timediff('%s', '%s', 1s) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1s) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1m) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1m) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1h) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1h) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1d) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1d) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select timediff('%s', '%s', 1w) from tb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from ctb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.query("select timediff('%s', '%s', 1w) from stb" %(ts1, ts2))
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        #timestamp column as input
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', '1972-12-12 14:40:40', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2022-02-2 13:30:30', '2022-02-16 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', '2022-02-02 13:30:30.000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', '2022-02-02 13:30:30.000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', '2022-02-02 13:30:30.000000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '1972-12-12 13:30:30', '1972-12-12 14:40:40', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2022-02-2 13:30:30', '2022-02-16 13:30:30', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:03', '2022-02-02 13:30:30.123', '2022-02-02 13:30:30.000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:04', '2022-02-02 13:30:30.123456', '2022-02-02 13:30:30.000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:05', '2022-02-02 13:30:30.123456789', '2022-02-02 13:30:30.000000000', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")


        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 4210)
        rest = tdSql.checkData(2, 0, 1209600)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 70)
        rest = tdSql.checkData(2, 0, 20160)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1)
        rest = tdSql.checkData(2, 0, 336)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 0)
        rest = tdSql.checkData(2, 0, 14)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        #timestamp column and epoch as input
        #epoch 0
        tdSql.query("select timediff(0, col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)

        tdSql.query("select timediff(0, col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        tdSql.query("select timediff(0, col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff(0, col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff(0, col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)

        tdSql.query("select timediff(0, col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff(0, col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff(0, col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)

        tdSql.query("select timediff(0, col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff(0, col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff(0, col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)

        tdSql.query("select timediff(0, col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff(0, col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff(0, col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)

        tdSql.query("select timediff(0, col_timestamp2, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff(0, col_timestamp2, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff(0, col_timestamp2, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)

        #epoch 1643779830 2022-2-2 13:30:30 GMT+08:00
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, 1643779830, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        #timestamp column and date-time string as input
        #"1970-01-01 08:00:00"
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)


        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61)
        rest = tdSql.checkData(1, 0, 92990440)
        rest = tdSql.checkData(2, 0, 1644989430)
        rest = tdSql.checkData(3, 0, 1643779830)
        rest = tdSql.checkData(4, 0, 1643779830)
        rest = tdSql.checkData(5, 0, 1643779830)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1)
        rest = tdSql.checkData(1, 0, 1549840)
        rest = tdSql.checkData(2, 0, 27416490)
        rest = tdSql.checkData(3, 0, 27396330)
        rest = tdSql.checkData(4, 0, 27396330)
        rest = tdSql.checkData(5, 0, 27396330)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 25830)
        rest = tdSql.checkData(2, 0, 456941)
        rest = tdSql.checkData(3, 0, 456605)
        rest = tdSql.checkData(4, 0, 456605)
        rest = tdSql.checkData(5, 0, 456605)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 1076)
        rest = tdSql.checkData(2, 0, 19039)
        rest = tdSql.checkData(3, 0, 19025)
        rest = tdSql.checkData(4, 0, 19025)
        rest = tdSql.checkData(5, 0, 19025)

        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2, 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 0)
        rest = tdSql.checkData(1, 0, 153)
        rest = tdSql.checkData(2, 0, 2719)
        rest = tdSql.checkData(3, 0, 2717)
        rest = tdSql.checkData(4, 0, 2717)
        rest = tdSql.checkData(5, 0, 2717)


        #"2022-2-2 13:30:30" GMT+08:00
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1u) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000000)
        rest = tdSql.checkData(1, 0, 1550793600000000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1a) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830000)
        rest = tdSql.checkData(1, 0, 1550793600000)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1s) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 1643779830)
        rest = tdSql.checkData(1, 0, 1550793600)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1m) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 27396330)
        rest = tdSql.checkData(1, 0, 25846560)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1h) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 456605)
        rest = tdSql.checkData(1, 0, 430776)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1d) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 19025)
        rest = tdSql.checkData(1, 0, 17949)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)
        tdSql.query("select timediff(col_timestamp1, '2022-2-2 13:30:30', 1w) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 2717)
        rest = tdSql.checkData(1, 0, 2564)
        rest = tdSql.checkData(2, 0, 0)
        rest = tdSql.checkData(3, 0, 0)
        rest = tdSql.checkData(4, 0, 0)
        rest = tdSql.checkData(5, 0, 0)

        print("============== STEP 4: select timetruncate() no time unit given ================== ")

        tdSql.execute('use db_m')
        #epoch as input
        ts1 = 61
        ts2 = 0
        tdSql.query("select timediff(%d, %d) from tb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d) from ctb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff(%d, %d) from stb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000)

        #datetime string as input
        ts1 = "1970-01-01 08:01:01" # 61
        ts2 = "1970-01-01 08:00:00" # 61

        tdSql.query("select timediff('%s', '%s') from tb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s') from ctb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000)
        tdSql.query("select timediff('%s', '%s') from stb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000)

        #timestamp column as input
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 4210000)
        rest = tdSql.checkData(2, 0, 1209600000)
        rest = tdSql.checkData(3, 0, 123)
        rest = tdSql.checkData(4, 0, 123)
        rest = tdSql.checkData(5, 0, 123)

        #timestamp column and epoch as input
        #epoch 0
        tdSql.query("select timediff(0, col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff(0, col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        #timestamp column and date-time string as input
        #"1970-01-01 08:00:00"
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000)
        rest = tdSql.checkData(1, 0, 92990440000)
        rest = tdSql.checkData(2, 0, 1644989430000)
        rest = tdSql.checkData(3, 0, 1643779830000)
        rest = tdSql.checkData(4, 0, 1643779830000)
        rest = tdSql.checkData(5, 0, 1643779830000)

        tdSql.execute('use db_u')
        #epoch as input
        ts1 = 61
        ts2 = 0
        tdSql.query("select timediff(%d, %d) from tb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d) from ctb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff(%d, %d) from stb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000)

        #datetime string as input
        ts1 = "1970-01-01 08:01:01" # 61
        ts2 = "1970-01-01 08:00:00" # 61

        tdSql.query("select timediff('%s', '%s') from tb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s') from ctb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000)
        tdSql.query("select timediff('%s', '%s') from stb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000)

        #timestamp column as input
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 4210000000)
        rest = tdSql.checkData(2, 0, 1209600000000)
        rest = tdSql.checkData(3, 0, 123000)
        rest = tdSql.checkData(4, 0, 123456)
        rest = tdSql.checkData(5, 0, 123456)

        #timestamp column and epoch as input
        #epoch 0
        tdSql.query("select timediff(0, col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff(0, col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)

        #timestamp column and date-time string as input
        #"1970-01-01 08:00:00"
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000)
        rest = tdSql.checkData(1, 0, 92990440000000)
        rest = tdSql.checkData(2, 0, 1644989430000000)
        rest = tdSql.checkData(3, 0, 1643779830000000)
        rest = tdSql.checkData(4, 0, 1643779830000000)
        rest = tdSql.checkData(5, 0, 1643779830000000)

        tdSql.execute('use db_n')
        #epoch as input
        ts1 = 61
        ts2 = 0
        tdSql.query("select timediff(%d, %d) from tb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000000)
        tdSql.query("select timediff(%d, %d) from ctb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000000)
        tdSql.query("select timediff(%d, %d) from stb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000000)

        #datetime string as input
        ts1 = "1970-01-01 08:01:01" # 61
        ts2 = "1970-01-01 08:00:00" # 61

        tdSql.query("select timediff('%s', '%s') from tb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000000)
        tdSql.query("select timediff('%s', '%s') from ctb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000000)
        tdSql.query("select timediff('%s', '%s') from stb" %(ts1, ts2))
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 61000000000)

        #timestamp column as input
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 4210000000000)
        rest = tdSql.checkData(2, 0, 1209600000000000)
        rest = tdSql.checkData(3, 0, 123000000)
        rest = tdSql.checkData(4, 0, 123456000)
        rest = tdSql.checkData(5, 0, 123456789)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 4210000000000)
        rest = tdSql.checkData(2, 0, 1209600000000000)
        rest = tdSql.checkData(3, 0, 123000000)
        rest = tdSql.checkData(4, 0, 123456000)
        rest = tdSql.checkData(5, 0, 123456789)
        tdSql.query("select timediff(col_timestamp1, col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 4210000000000)
        rest = tdSql.checkData(2, 0, 1209600000000000)
        rest = tdSql.checkData(3, 0, 123000000)
        rest = tdSql.checkData(4, 0, 123456000)
        rest = tdSql.checkData(5, 0, 123456789)

        #timestamp column and epoch as input
        #epoch 0
        tdSql.query("select timediff(0, col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 92990440000000000)
        rest = tdSql.checkData(2, 0, 1644989430000000000)
        rest = tdSql.checkData(3, 0, 1643779830000000000)
        rest = tdSql.checkData(4, 0, 1643779830000000000)
        rest = tdSql.checkData(5, 0, 1643779830000000000)
        tdSql.query("select timediff(0, col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 92990440000000000)
        rest = tdSql.checkData(2, 0, 1644989430000000000)
        rest = tdSql.checkData(3, 0, 1643779830000000000)
        rest = tdSql.checkData(4, 0, 1643779830000000000)
        rest = tdSql.checkData(5, 0, 1643779830000000000)
        tdSql.query("select timediff(0, col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 92990440000000000)
        rest = tdSql.checkData(2, 0, 1644989430000000000)
        rest = tdSql.checkData(3, 0, 1643779830000000000)
        rest = tdSql.checkData(4, 0, 1643779830000000000)
        rest = tdSql.checkData(5, 0, 1643779830000000000)

        #timestamp column and date-time string as input
        #"1970-01-01 08:00:00"
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from tb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 92990440000000000)
        rest = tdSql.checkData(2, 0, 1644989430000000000)
        rest = tdSql.checkData(3, 0, 1643779830000000000)
        rest = tdSql.checkData(4, 0, 1643779830000000000)
        rest = tdSql.checkData(5, 0, 1643779830000000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from ctb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 92990440000000000)
        rest = tdSql.checkData(2, 0, 1644989430000000000)
        rest = tdSql.checkData(3, 0, 1643779830000000000)
        rest = tdSql.checkData(4, 0, 1643779830000000000)
        rest = tdSql.checkData(5, 0, 1643779830000000000)
        tdSql.query("select timediff('1970-01-01 08:00:00', col_timestamp2) from stb")
        tdSql.checkRows(6)
        rest = tdSql.checkData(0, 0, 61000000000)
        rest = tdSql.checkData(1, 0, 92990440000000000)
        rest = tdSql.checkData(2, 0, 1644989430000000000)
        rest = tdSql.checkData(3, 0, 1643779830000000000)
        rest = tdSql.checkData(4, 0, 1643779830000000000)
        rest = tdSql.checkData(5, 0, 1643779830000000000)

        print("============== STEP 5: select timediff() other use cases ================== ")
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #timediff(), col
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_bigint from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_bigint from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_bigint from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_bool from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, True)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_bool from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, True)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_bool from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, True)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_float from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_float from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_float from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_binary from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_binary from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),col_binary from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select ts, col_smallint, col_float, timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h), col_binary, col_timestamp from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, 1)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h), col_binary, col_timestamp from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, 1)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h), col_binary, col_timestamp from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        tdSql.checkData(0, 3, 1)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #timediff('2022-02-02 03:02:02', ), tag
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_bigint from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_bigint from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_bool from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, True)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_bool from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, True)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_float from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_float from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_binary from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tag_binary from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select tag_smallint, tag_float, timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h), tag_binary, tag_timestamp from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(0, 2, 1)
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select tag_smallint, tag_float, timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h), tag_binary, tag_timestamp from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(0, 2, 1)
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #timediff('2022-02-02 03:02:02', ),tbname
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tbname from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "tb")
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tbname from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "ctb")
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),tbname from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "ctb")

        #timediff('2022-02-02 03:02:02', ),_c0/_C0
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),_c0 from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),_c0 from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),_c0 from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _C0,timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.query("select _C0,timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.query("select _C0,timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)

        #timediff('2022-02-02 03:02:02', ),func()
        #can only be used with scalar functions together
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),ceil(col_bigint) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),ceil(col_bigint) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),ceil(col_bigint) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),round(col_float) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),round(col_float) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),round(col_float) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),floor(1.5) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),floor(1.5) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),floor(1.5) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select abs(-1),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select abs(-1),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select abs(-1),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select pow(2,2),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select pow(2,2),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select pow(2,2),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(0, 1, 1)

        #timediff('2022-02-02 03:02:02', ),timediff('2022-02-02 03:02:02', )
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h),timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1)

        #timediff('2022-02-02 03:02:02', ),constant
        tdSql.query("select 123,123.0,true,'123',timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, 1)
        tdSql.query("select 123,123.0,true,'123',timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, 1)
        tdSql.query("select 123,123.0,true,'123',timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb" )
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        tdSql.checkData(0, 4, 1)

        #insert some more data
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.001', '2022-02-02 02:00:00.001', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:00.002', '2022-02-02 02:00:00.002', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #order by
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb order by ts" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.checkEqual(str(res), '2022-02-02 02:00:00')
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb order by ts" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb order by ts" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb order by ts desc" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb order by ts desc" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb order by ts desc" )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        #limit/offset
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb limit 2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb limit 2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb limit 2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb limit 2 offset 1" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb limit 2 offset 1" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb limit 2 offset 1" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)

        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from tb limit 1,2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from ctb limit 1,2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.query("select timediff('2022-02-02 03:02:02', '2022-02-02 02:02:02', 1h) from stb limit 1,2" )
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)


        #join
        tdSql.execute("create stable stb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb1 using stb1 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("create stable stb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb2 using stb2 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.000', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.001', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00.002', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from tb1, tb2 where tb1.col_timestamp = tb2.col_timestamp' );
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from ctb1, ctb2 where ctb1.col_timestamp = ctb2.col_timestamp' );
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from stb1, stb2 where stb1.col_timestamp = stb2.col_timestamp and stb1.tag_int = stb2.tag_int' );
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        #union all
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from tb1 union all select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from tb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.checkData(3, 0, 1)
        tdSql.checkData(4, 0, 1)
        tdSql.checkData(5, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from ctb1 union all select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from ctb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.checkData(3, 0, 1)
        tdSql.checkData(4, 0, 1)
        tdSql.checkData(5, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from stb1 union all select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from stb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.checkData(3, 0, 1)
        tdSql.checkData(4, 0, 1)
        tdSql.checkData(5, 0, 1)
        #nested query
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select * from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select * from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select * from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select col_int as val from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select col_int as val from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select col_int as val from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select * from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select * from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select * from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select _c0 from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from tb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select _c0 from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from ctb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select _c0 from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from stb)' )
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from (select timediff(\'2022-02-02 03:02:02\', \'2022-02-02 02:02:02\', 1h) from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        ##ERROR CASES
        #param
        tdSql.error("select timediff(1) from tb")
        tdSql.error("select timediff(1) from ctb")
        tdSql.error("select timediff(1) from stb")
        tdSql.error("select timediff(1.0) from tb")
        tdSql.error("select timediff(1.0) from ctb")
        tdSql.error("select timediff(1.0) from stb")
        tdSql.error("select timediff(true) from tb")
        tdSql.error("select timediff(true) from ctb")
        tdSql.error("select timediff(true) from stb")
        tdSql.error("select timediff(\"abc\") from tb")
        tdSql.error("select timediff(\"abc\") from ctb")
        tdSql.error("select timediff(\"abc\") from stb")
        tdSql.error("select timediff(abc) from tb")
        tdSql.error("select timediff(abc) from ctb")
        tdSql.error("select timediff(abc) from stb")
        tdSql.error("select timediff(col_timestamp) from tb")
        tdSql.error("select timediff(col_timestamp) from ctb")
        tdSql.error("select timediff(col_timestamp) from stb")
        tdSql.error("select timediff(tag_timestamp) from tb")
        tdSql.error("select timediff(tag_timestamp) from ctb")
        tdSql.error("select timediff(tag_timestamp) from stb")

        #tdSql.error("select timediff(-1, 1s) from tb")
        #tdSql.error("select timediff(-1, 1s) from ctb")
        #tdSql.error("select timediff(-1, 1s) from stb")
        #tdSql.error("select timediff(1, 1s) from tb")
        #tdSql.error("select timediff(1, 1s) from ctb")
        #tdSql.error("select timediff(1, 1s) from stb")
        tdSql.error("select timediff(1, true, 1s) from tb")
        tdSql.error("select timediff(1, true, 1s) from ctb")
        tdSql.error("select timediff(1, true, 1s) from stb")
        tdSql.error("select timediff(1, 1.5, 1s) from tb")
        tdSql.error("select timediff(1, 1.5, 1s) from ctb")
        tdSql.error("select timediff(1, 1.5, 1s) from stb")
        #tdSql.error("select timediff('abc', 1s) from tb")
        #tdSql.error("select timediff('abc', 1s) from ctb")
        #tdSql.error("select timediff('abc', 1s) from stb")
        tdSql.error("select timediff(1,*, 1s) from tb")
        tdSql.error("select timediff(1,*, 1s) from ctb")
        tdSql.error("select timediff(1,*, 1s) from stb")
        tdSql.error("select timediff(1, tbname, 1s) from tb")
        tdSql.error("select timediff(1, tbname, 1s) from ctb")
        tdSql.error("select timediff(1, tbname, 1s) from stb")
        tdSql.error("select timediff(1, col_bigint, 1s) from tb")
        tdSql.error("select timediff(1, col_bigint, 1s) from ctb")
        tdSql.error("select timediff(1, col_bigint, 1s) from stb")
        tdSql.error("select timediff(1, col_double, 1s) from tb")
        tdSql.error("select timediff(1, col_double, 1s) from ctb")
        tdSql.error("select timediff(1, col_double, 1s) from stb")
        tdSql.error("select timediff(1, col_bool, 1s) from tb")
        tdSql.error("select timediff(1, col_bool, 1s) from ctb")
        tdSql.error("select timediff(1, col_bool, 1s) from stb")
        tdSql.error("select timediff(1, col_binary, 1s) from tb")
        tdSql.error("select timediff(1, col_binary, 1s) from ctb")
        tdSql.error("select timediff(1, col_binary, 1s) from stb")
        tdSql.error("select timediff(1, tag_timestamp, 1s) from tb")
        tdSql.error("select timediff(1, tag_timestamp, 1s) from ctb")
        tdSql.error("select timediff(1, tag_timestamp, 1s) from stb")
        tdSql.error("select timediff(1, tag_bigint, 1s) from tb")
        tdSql.error("select timediff(1, tag_bigint, 1s) from ctb")
        tdSql.error("select timediff(1, tag_bigint, 1s) from stb")
        tdSql.error("select timediff(1, tag_double, 1s) from tb")
        tdSql.error("select timediff(1, tag_double, 1s) from ctb")
        tdSql.error("select timediff(1, tag_double, 1s) from stb")
        tdSql.error("select timediff(1, tag_bool, 1s) from tb")
        tdSql.error("select timediff(1, tag_bool, 1s) from ctb")
        tdSql.error("select timediff(1, tag_bool, 1s) from stb")
        tdSql.error("select timediff(1, tag_binary, 1s) from tb")
        tdSql.error("select timediff(1, tag_binary, 1s) from ctb")
        tdSql.error("select timediff(1, tag_binary, 1s) from stb")


        tdSql.error("select timediff(0,1,1) from tb")
        tdSql.error("select timediff(0,1,1) from ctb")
        tdSql.error("select timediff(0,1,1) from stb")
        tdSql.error("select timediff(0,1,true) from tb")
        tdSql.error("select timediff(0,1,true) from ctb")
        tdSql.error("select timediff(0,1,true) from stb")
        tdSql.error("select timediff(0,1,1.5) from tb")
        tdSql.error("select timediff(0,1,1.5) from ctb")
        tdSql.error("select timediff(0,1,1.5) from stb")
        tdSql.error("select timediff(0,1,'abc') from tb")
        tdSql.error("select timediff(0,1,'abc') from ctb")
        tdSql.error("select timediff(0,1,'abc') from stb")
        tdSql.error("select timediff(0,1,*) from tb")
        tdSql.error("select timediff(0,1,*) from ctb")
        tdSql.error("select timediff(0,1,*) from stb")
        tdSql.error("select timediff(0,1,tbname) from tb")
        tdSql.error("select timediff(0,1,tbname) from ctb")
        tdSql.error("select timediff(0,1,tbname) from stb")
        tdSql.error("select timediff(0,1,col_bigint) from tb")
        tdSql.error("select timediff(0,1,col_bigint) from ctb")
        tdSql.error("select timediff(0,1,col_bigint) from stb")
        tdSql.error("select timediff(0,1,col_double) from tb")
        tdSql.error("select timediff(0,1,col_double) from ctb")
        tdSql.error("select timediff(0,1,col_double) from stb")
        tdSql.error("select timediff(0,1,col_bool) from tb")
        tdSql.error("select timediff(0,1,col_bool) from ctb")
        tdSql.error("select timediff(0,1,col_bool) from stb")
        tdSql.error("select timediff(0,1,col_binary) from tb")
        tdSql.error("select timediff(0,1,col_binary) from ctb")
        tdSql.error("select timediff(0,1,col_binary) from stb")
        tdSql.error("select timediff(0,1,tag_timestamp) from tb")
        tdSql.error("select timediff(0,1,tag_timestamp) from ctb")
        tdSql.error("select timediff(0,1,tag_timestamp) from stb")
        tdSql.error("select timediff(0,1,tag_bigint) from tb")
        tdSql.error("select timediff(0,1,tag_bigint) from ctb")
        tdSql.error("select timediff(0,1,tag_bigint) from stb")
        tdSql.error("select timediff(0,1,tag_double) from tb")
        tdSql.error("select timediff(0,1,tag_double) from ctb")
        tdSql.error("select timediff(0,1,tag_double) from stb")
        tdSql.error("select timediff(0,1,tag_bool) from tb")
        tdSql.error("select timediff(0,1,tag_bool) from ctb")
        tdSql.error("select timediff(0,1,tag_bool) from stb")
        tdSql.error("select timediff(0,1,tag_binary) from tb")
        tdSql.error("select timediff(0,1,tag_binary) from ctb")
        tdSql.error("select timediff(0,1,tag_binary) from stb")

        tdSql.error("select timediff(0, 1, 1s, col_bigint) from tb")
        tdSql.error("select timediff(0, 1, 1s, col_bigint) from ctb")
        tdSql.error("select timediff(0, 1, 1s, col_bigint) from stb")

        #distinct
        tdSql.error("select distinct timediff(0, 1) from tb")
        tdSql.error("select distinct timediff(0, 1) from ctb")
        tdSql.error("select distinct timediff(0, 1) from stb")

        #arithmetic
        tdSql.error("select timediff(0, 1) + count(*) from tb")
        tdSql.error("select timediff(0, 1) + count(*) from ctb")
        tdSql.error("select timediff(0, 1) + count(*) from stb")
        tdSql.error("select timediff(0, 1) + avg(col_timestamp) from tb")
        tdSql.error("select timediff(0, 1) + avg(col_timestamp) from ctb")
        tdSql.error("select timediff(0, 1) + avg(col_timestamp) from stb")
        tdSql.error("select timediff(0, 1) + sum(col_int) from tb")
        tdSql.error("select timediff(0, 1) + sum(col_int) from ctb")
        tdSql.error("select timediff(0, 1) + sum(col_int) from stb")

        tdSql.error("select timediff(0, 1) + max(col_timestamp) from tb")
        tdSql.error("select timediff(0, 1) + max(col_timestamp) from ctb")
        tdSql.error("select timediff(0, 1) + max(col_timestamp) from stb")
        tdSql.error("select timediff(0, 1) + first(col_timestamp) from tb")
        tdSql.error("select timediff(0, 1) + first(col_timestamp) from ctb")
        tdSql.error("select timediff(0, 1) + first(col_timestamp) from stb")
        tdSql.error("select timediff(0, 1) + top(col_timestamp, 1) from tb")
        tdSql.error("select timediff(0, 1) + top(col_timestamp, 1) from ctb")
        tdSql.error("select timediff(0, 1) + top(col_timestamp, 1) from stb")

        #tdSql.error("select timediff(0, 1) + ceil(col_float) from tb")
        #tdSql.error("select timediff(0, 1) + ceil(col_float) from ctb")
        #tdSql.error("select timediff(0, 1) + ceil(col_float) from stb")
        #tdSql.error("select timediff(0, 1) + floor(col_int) from tb")
        #tdSql.error("select timediff(0, 1) + floor(col_int) from ctb")
        #tdSql.error("select timediff(0, 1) + floor(col_int) from stb")
        #tdSql.error("select timediff(0, 1) + round(1.5) from tb")
        #tdSql.error("select timediff(0, 1) + round(1.5) from ctb")
        #tdSql.error("select timediff(0, 1) + round(1.5) from stb")
        tdSql.error("select timediff(0, 1) + diff(col_timestamp) from tb")
        tdSql.error("select timediff(0, 1) + diff(col_timestamp) from ctb")
        tdSql.error("select timediff(0, 1) + diff(col_timestamp) from stb")

        #tdSql.error("select timediff(0, 1) + 1 from tb")
        #tdSql.error("select timediff(0, 1) + 1 from ctb")
        #tdSql.error("select timediff(0, 1) + 1 from stb")
        #tdSql.error("select timediff(0, 1) + 1.5 from tb")
        #tdSql.error("select timediff(0, 1) + 1.5 from ctb")
        #tdSql.error("select timediff(0, 1) + 1.5 from stb")
        #tdSql.error("select timediff(0, 1) + true from tb")
        #tdSql.error("select timediff(0, 1) + true from ctb")
        #tdSql.error("select timediff(0, 1) + true from stb")
        tdSql.error("select timediff(0, 1) + 'abc' from tb")
        tdSql.error("select timediff(0, 1) + 'abc' from ctb")
        tdSql.error("select timediff(0, 1) + 'abc' from stb")
        tdSql.error("select timediff(0, 1) + abc from tb")
        tdSql.error("select timediff(0, 1) + abc from ctb")
        tdSql.error("select timediff(0, 1) + abc from stb")

        tdSql.error("select timediff(0, 1) + ts from tb")
        tdSql.error("select timediff(0, 1) + ts from ctb")
        tdSql.error("select timediff(0, 1) + ts from stb")
        tdSql.error("select timediff(0, 1) + col_timestamp from tb")
        tdSql.error("select timediff(0, 1) + col_timestamp from ctb")
        tdSql.error("select timediff(0, 1) + col_timestamp from stb")
        #tdSql.error("select timediff(0, 1) + col_tinyint from tb")
        #tdSql.error("select timediff(0, 1) + col_tinyint from ctb")
        #tdSql.error("select timediff(0, 1) + col_tinyint from stb")
        #tdSql.error("select timediff(0, 1) + col_smallint from tb")
        #tdSql.error("select timediff(0, 1) + col_smallint from ctb")
        #tdSql.error("select timediff(0, 1) + col_smallint from stb")
        #tdSql.error("select timediff(0, 1) + col_int from tb")
        #tdSql.error("select timediff(0, 1) + col_int from ctb")
        #tdSql.error("select timediff(0, 1) + col_int from stb")
        #tdSql.error("select timediff(0, 1) + col_bigint from tb")
        #tdSql.error("select timediff(0, 1) + col_bigint from ctb")
        #tdSql.error("select timediff(0, 1) + col_bigint from stb")
        #tdSql.error("select timediff(0, 1) + col_bool from tb")
        #tdSql.error("select timediff(0, 1) + col_bool from ctb")
        #tdSql.error("select timediff(0, 1) + col_bool from stb")
        #tdSql.error("select timediff(0, 1) + col_float from tb")
        #tdSql.error("select timediff(0, 1) + col_float from ctb")
        #tdSql.error("select timediff(0, 1) + col_float from stb")
        #tdSql.error("select timediff(0, 1) + col_double from tb")
        #tdSql.error("select timediff(0, 1) + col_double from ctb")
        #tdSql.error("select timediff(0, 1) + col_double from stb")
        tdSql.error("select timediff(0, 1) + col_binary from tb")
        tdSql.error("select timediff(0, 1) + col_binary from ctb")
        tdSql.error("select timediff(0, 1) + col_binary from stb")
        tdSql.error("select timediff(0, 1) + col_nchar from tb")
        tdSql.error("select timediff(0, 1) + col_nchar from ctb")
        tdSql.error("select timediff(0, 1) + col_nchar from stb")

        tdSql.error("select timediff(0, 1) + tag_timestamp from tb")
        tdSql.error("select timediff(0, 1) + tag_timestamp from ctb")
        tdSql.error("select timediff(0, 1) + tag_timestamp from stb")
        tdSql.error("select timediff(0, 1) + tag_tinyint from tb")
        tdSql.error("select timediff(0, 1) + tag_tinyint from ctb")
        tdSql.error("select timediff(0, 1) + tag_tinyint from stb")
        tdSql.error("select timediff(0, 1) + tag_smallint from tb")
        tdSql.error("select timediff(0, 1) + tag_smallint from ctb")
        tdSql.error("select timediff(0, 1) + tag_smallint from stb")
        tdSql.error("select timediff(0, 1) + tag_int from tb")
        tdSql.error("select timediff(0, 1) + tag_int from ctb")
        tdSql.error("select timediff(0, 1) + tag_int from stb")
        tdSql.error("select timediff(0, 1) + tag_bigint from tb")
        tdSql.error("select timediff(0, 1) + tag_bigint from ctb")
        tdSql.error("select timediff(0, 1) + tag_bigint from stb")
        tdSql.error("select timediff(0, 1) + tag_bool from tb")
        tdSql.error("select timediff(0, 1) + tag_bool from ctb")
        tdSql.error("select timediff(0, 1) + tag_bool from stb")
        tdSql.error("select timediff(0, 1) + tag_float from tb")
        tdSql.error("select timediff(0, 1) + tag_float from ctb")
        tdSql.error("select timediff(0, 1) + tag_float from stb")
        tdSql.error("select timediff(0, 1) + tag_double from tb")
        tdSql.error("select timediff(0, 1) + tag_double from ctb")
        tdSql.error("select timediff(0, 1) + tag_double from stb")
        tdSql.error("select timediff(0, 1) + tag_binary from tb")
        tdSql.error("select timediff(0, 1) + tag_binary from ctb")
        tdSql.error("select timediff(0, 1) + tag_binary from stb")
        tdSql.error("select timediff(0, 1) + tag_nchar from tb")
        tdSql.error("select timediff(0, 1) + tag_nchar from ctb")
        tdSql.error("select timediff(0, 1) + tag_nchar from stb")

        #tdSql.error("select timediff(0, 1) + 0.5b from tb")
        #tdSql.error("select timediff(0, 1) + 0.5b from ctb")
        #tdSql.error("select timediff(0, 1) + 0.5b from stb")
        #tdSql.error("select timediff(0, 1) + 1.5u from tb")
        #tdSql.error("select timediff(0, 1) + 1.5u from ctb")
        #tdSql.error("select timediff(0, 1) + 1.5u from stb")
        #tdSql.error("select timediff(0, 1) + 2.5a from tb")
        #tdSql.error("select timediff(0, 1) + 2.5a from ctb")
        #tdSql.error("select timediff(0, 1) + 2.5a from stb")
        #tdSql.error("select timediff(0, 1) + 3.5s from tb")
        #tdSql.error("select timediff(0, 1) + 3.5s from ctb")
        #tdSql.error("select timediff(0, 1) + 3.5s from stb")
        #tdSql.error("select timediff(0, 1) + 4.5m from tb")
        #tdSql.error("select timediff(0, 1) + 4.5m from ctb")
        #tdSql.error("select timediff(0, 1) + 4.5m from stb")
        #tdSql.error("select timediff(0, 1) + 5.5h from tb")
        #tdSql.error("select timediff(0, 1) + 5.5h from ctb")
        #tdSql.error("select timediff(0, 1) + 5.5h from stb")
        #tdSql.error("select timediff(0, 1) + 6.5d from tb")
        #tdSql.error("select timediff(0, 1) + 6.5d from ctb")
        #tdSql.error("select timediff(0, 1) + 6.5d from stb")
        #tdSql.error("select timediff(0, 1) + 7.5w from tb")
        #tdSql.error("select timediff(0, 1) + 7.5w from ctb")
        #tdSql.error("select timediff(0, 1) + 7.5w from stb")

        #tdSql.error("select timediff(0, 1) - 0.5b from tb")
        #tdSql.error("select timediff(0, 1) - 0.5b from ctb")
        #tdSql.error("select timediff(0, 1) - 0.5b from stb")
        #tdSql.error("select timediff(0, 1) - 1.5u from tb")
        #tdSql.error("select timediff(0, 1) - 1.5u from ctb")
        #tdSql.error("select timediff(0, 1) - 1.5u from stb")
        #tdSql.error("select timediff(0, 1) - 2.5a from tb")
        #tdSql.error("select timediff(0, 1) - 2.5a from ctb")
        #tdSql.error("select timediff(0, 1) - 2.5a from stb")
        #tdSql.error("select timediff(0, 1) - 3.5s from tb")
        #tdSql.error("select timediff(0, 1) - 3.5s from ctb")
        #tdSql.error("select timediff(0, 1) - 3.5s from stb")
        #tdSql.error("select timediff(0, 1) - 4.5m from tb")
        #tdSql.error("select timediff(0, 1) - 4.5m from ctb")
        #tdSql.error("select timediff(0, 1) - 4.5m from stb")
        #tdSql.error("select timediff(0, 1) - 5.5h from tb")
        #tdSql.error("select timediff(0, 1) - 5.5h from ctb")
        #tdSql.error("select timediff(0, 1) - 5.5h from stb")
        #tdSql.error("select timediff(0, 1) - 6.5d from tb")
        #tdSql.error("select timediff(0, 1) - 6.5d from ctb")
        #tdSql.error("select timediff(0, 1) - 6.5d from stb")
        #tdSql.error("select timediff(0, 1) - 7.5w from tb")
        #tdSql.error("select timediff(0, 1) - 7.5w from ctb")
        #tdSql.error("select timediff(0, 1) - 7.5w from stb")

        #tdSql.error("select timediff(0, 1) * 1d from tb")
        #tdSql.error("select timediff(0, 1) * 1d from ctb")
        #tdSql.error("select timediff(0, 1) * 1d from stb")
        #tdSql.error("select timediff(0, 1) / 5m from tb")
        #tdSql.error("select timediff(0, 1) / 5m from ctb")
        #tdSql.error("select timediff(0, 1) / 5m from stb")
        #tdSql.error("select timediff(0, 1) % 10h from tb")
        #tdSql.error("select timediff(0, 1) % 10h from ctb")
        #tdSql.error("select timediff(0, 1) % 10h from stb")
        #tdSql.error("select timediff(0, 1) + 1a * 60b from tb")
        #tdSql.error("select timediff(0, 1) + 1a * 60b from ctb")
        #tdSql.error("select timediff(0, 1) + 1a * 60b from stb")
        #tdSql.error("select timediff(0, 1) + 1s * 60 from tb")
        #tdSql.error("select timediff(0, 1) + 1s * 60 from ctb")
        #tdSql.error("select timediff(0, 1) + 1s * 60 from stb")

        #timediff(), func()
        tdSql.error("select timediff(0, 1),count(*) from tb")
        tdSql.error("select timediff(0, 1),count(*) from ctb")
        tdSql.error("select timediff(0, 1),count(*) from stb")
        tdSql.error("select timediff(0, 1),avg(col_timestamp) from tb")
        tdSql.error("select timediff(0, 1),avg(col_timestamp) from ctb")
        tdSql.error("select timediff(0, 1),avg(col_timestamp) from stb")
        tdSql.error("select timediff(0, 1),sum(col_int) from tb")
        tdSql.error("select timediff(0, 1),sum(col_int) from ctb")
        tdSql.error("select timediff(0, 1),sum(col_int) from stb")

        tdSql.error("select timediff(0, 1),max(col_timestamp) from tb")
        tdSql.error("select timediff(0, 1),max(col_timestamp) from ctb")
        tdSql.error("select timediff(0, 1),max(col_timestamp) from stb")
        tdSql.error("select timediff(0, 1),first(col_timestamp) from tb")
        tdSql.error("select timediff(0, 1),first(col_timestamp) from ctb")
        tdSql.error("select timediff(0, 1),first(col_timestamp) from stb")
        tdSql.error("select timediff(0, 1),top(col_timestamp, 1) from tb")
        tdSql.error("select timediff(0, 1),top(col_timestamp, 1) from ctb")
        tdSql.error("select timediff(0, 1),top(col_timestamp, 1) from stb")

        #session
        tdSql.error("select timediff(0, 1) from tb session(ts, 1d)")
        tdSql.error("select timediff(0, 1) from ctb session(ts, 1h)")
        tdSql.error("select timediff(0, 1) from stb session(0, 1)")

        #state_window
        tdSql.error('select timediff(0, 1) from tb state_window(col_timestamp);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_tinyint);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_smallint);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_int);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_bigint);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_bool);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_float);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_double);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_binary);')
        tdSql.error('select timediff(0, 1) from tb state_window(col_nchar);')

        #interval/sliding
        tdSql.error('select timediff(0, 1) from tb interval(1y)')
        tdSql.error('select timediff(0, 1) from tb interval(1n)')
        tdSql.error('select timediff(0, 1) from tb interval(1w)')
        tdSql.error('select timediff(0, 1) from tb interval(1d)')
        tdSql.error('select timediff(0, 1) from tb interval(1h)')
        tdSql.error('select timediff(0, 1) from tb interval(1s)')
        tdSql.error('select timediff(0, 1) from tb interval(1y) sliding(1y)')
        tdSql.error('select timediff(0, 1) from tb interval(1n) sliding(1n)')
        tdSql.error('select timediff(0, 1) from tb interval(1w) sliding(1w)')
        tdSql.error('select timediff(0, 1) from tb interval(1d) sliding(1d)')
        tdSql.error('select timediff(0, 1) from tb interval(1h) sliding(1h)')
        tdSql.error('select timediff(0, 1) from tb interval(1s) sliding(1s)')

        #group by
        tdSql.error('select timediff(0, 1) from stb group by ts;')
        tdSql.error('select timediff(0, 1) from stb group by col_tinyint;')
        tdSql.error('select timediff(0, 1) from stb group by col_smallint;')
        tdSql.error('select timediff(0, 1) from stb group by col_int;')
        tdSql.error('select timediff(0, 1) from stb group by col_bigint;')
        tdSql.error('select timediff(0, 1) from stb group by col_bool;')
        tdSql.error('select timediff(0, 1) from stb group by col_float;')
        tdSql.error('select timediff(0, 1) from stb group by col_double;')
        tdSql.error('select timediff(0, 1) from stb group by col_binary;')
        tdSql.error('select timediff(0, 1) from stb group by col_nchar;')

        tdSql.error('select timediff(0, 1) from stb group by tag_tinyint;')
        tdSql.error('select timediff(0, 1) from stb group by tag_smallint;')
        tdSql.error('select timediff(0, 1) from stb group by tag_int;')
        tdSql.error('select timediff(0, 1) from stb group by tag_bigint;')
        tdSql.error('select timediff(0, 1) from stb group by tag_bool;')
        tdSql.error('select timediff(0, 1) from stb group by tag_float;')
        tdSql.error('select timediff(0, 1) from stb group by tag_double;')
        tdSql.error('select timediff(0, 1) from stb group by tag_binary;')
        tdSql.error('select timediff(0, 1) from stb group by tag_nchar;')

        tdSql.error('select timediff(0, 1) from stb group by tbname;')

        tdSql.error('select timediff(0, 1) from stb group by tag_tinyint,col_tinyint;')
        tdSql.error('select timediff(0, 1) from stb group by tag_smallint,col_smallint;')
        tdSql.error('select timediff(0, 1) from stb group by tag_int,col_int;')
        tdSql.error('select timediff(0, 1) from stb group by tag_bigint,col_bigint;')
        tdSql.error('select timediff(0, 1) from stb group by tag_bool,col_bool;')
        tdSql.error('select timediff(0, 1) from stb group by tag_float,col_float;')
        tdSql.error('select timediff(0, 1) from stb group by tag_double,col_double;')
        tdSql.error('select timediff(0, 1) from stb group by tag_binary,col_binary;')
        tdSql.error('select timediff(0, 1) from stb group by tag_nchar,col_nchar;')

        #order by
        tdSql.error('select timediff(0, 1) from stb order by col_tinyint;')
        tdSql.error('select timediff(0, 1) from stb order by col_tinyint desc;')
        tdSql.error('select timediff(0, 1) from stb order by col_smallint;')
        tdSql.error('select timediff(0, 1) from stb order by col_smallint desc;')
        tdSql.error('select timediff(0, 1) from stb order by col_int;')
        tdSql.error('select timediff(0, 1) from stb order by col_int desc;')
        tdSql.error('select timediff(0, 1) from stb order by col_bigint;')
        tdSql.error('select timediff(0, 1) from stb order by col_bigint desc;')
        tdSql.error('select timediff(0, 1) from stb order by col_bool;')
        tdSql.error('select timediff(0, 1) from stb order by col_bool desc;')
        tdSql.error('select timediff(0, 1) from stb order by col_float;')
        tdSql.error('select timediff(0, 1) from stb order by col_float desc;')
        tdSql.error('select timediff(0, 1) from stb order by col_double;')
        tdSql.error('select timediff(0, 1) from stb order by col_double desc;')
        tdSql.error('select timediff(0, 1) from stb order by col_double;')
        tdSql.error('select timediff(0, 1) from stb order by col_double desc;')

        tdSql.error('select timediff(0, 1) from stb order by tag_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_tinyint;')
        tdSql.error('select timediff(0, 1) from stb order by tag_tinyint desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_smallint;')
        tdSql.error('select timediff(0, 1) from stb order by tag_smallint desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_int;')
        tdSql.error('select timediff(0, 1) from stb order by tag_int desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bigint;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bigint desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bool;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bool desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_float;')
        tdSql.error('select timediff(0, 1) from stb order by tag_float desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double desc;')

        tdSql.error('select timediff(0, 1) from stb order by tbname;')
        tdSql.error('select timediff(0, 1) from stb order by tbname desc;')

        tdSql.error('select timediff(0, 1) from stb order by tag_timestamp,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_timestamp,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_tinyint,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_tinyint,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_smallint,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_smallint,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_int,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_int,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bigint,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bigint,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bool,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_bool,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_float,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_float,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double,col_timestamp desc;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double,col_timestamp;')
        tdSql.error('select timediff(0, 1) from stb order by tag_double,col_timestamp desc;')

        tdSql.execute('drop database db_m')
        tdSql.execute('drop database db_u')
        tdSql.execute('drop database db_n')

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
