/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 367
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  bool yy197;
  EJoinType yy208;
  SToken yy241;
  SAlterOption yy301;
  EOrder yy362;
  SNodeList* yy368;
  EFillMode yy388;
  SDataType yy392;
  EOperatorType yy412;
  ENullOrder yy417;
  SNode* yy442;
  int32_t yy578;
  int8_t yy629;
  int64_t yy683;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             645
#define YYNRULE              473
#define YYNTOKEN             244
#define YY_MAX_SHIFT         644
#define YY_MIN_SHIFTREDUCE   938
#define YY_MAX_SHIFTREDUCE   1410
#define YY_ERROR_ACTION      1411
#define YY_ACCEPT_ACTION     1412
#define YY_NO_ACTION         1413
#define YY_MIN_REDUCE        1414
#define YY_MAX_REDUCE        1886
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2260)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    78,  415, 1726,  416, 1449,   30,  239,  423,   61,  416,
 /*    10 */  1449, 1864,   39,   37, 1864,   40,   38,   36,   35,   34,
 /*    20 */   321, 1541, 1217,  333,   69, 1863, 1593, 1595,  155, 1861,
 /*    30 */  1744, 1713, 1861, 1600,  312, 1215,  558,  115,  522,  519,
 /*    40 */   326,   26, 1710, 1696,  971,  542, 1543,   33,   32, 1598,
 /*    50 */    28,   40,   38,   36,   35,   34,   33,   32, 1744,   14,
 /*    60 */    40,   38,   36,   35,   34, 1223,  512,  119, 1706, 1712,
 /*    70 */  1757,  368, 1726,   88, 1727,  545, 1729, 1730,  541,  562,
 /*    80 */   562,   84,    1, 1797,  975,  976,   60,  314, 1793,  150,
 /*    90 */  1684,   33,   32, 1864,  120,   40,   38,   36,   35,   34,
 /*   100 */  1744,  231, 1540,  511,  641,  432,  117, 1862,  543,  498,
 /*   110 */  1825, 1861, 1864, 1696,  558,  542,  149,   60, 1288, 1289,
 /*   120 */   521,  151, 1805, 1806,  559, 1810,  154,  559,  523, 1587,
 /*   130 */  1861,   39,   37, 1347, 1726,  159, 1217,  347,  372,  321,
 /*   140 */  1757, 1217,  296,   87, 1727,  545, 1729, 1730,  541, 1215,
 /*   150 */   562,  513, 1548, 1797, 1215, 1548,  508,  295, 1793,  467,
 /*   160 */   466, 1218, 1744, 1216,  465, 1242, 1255,  116,  462, 1864,
 /*   170 */   522,  461,  460,  459, 1308, 1696,   43,  542,   14, 1223,
 /*   180 */  1241,   11,   10,  156, 1223, 1221, 1222, 1861, 1270, 1271,
 /*   190 */  1273, 1274, 1275, 1276, 1277,  538,  560, 1285, 1286, 1287,
 /*   200 */  1290,    2, 1757, 1240,  305,   88, 1727,  545, 1729, 1730,
 /*   210 */   541,  186,  562,  157,  546, 1797,  374,  157,  641,  314,
 /*   220 */  1793,  150,  324,  641, 1644,  142, 1309, 1371,  514,  509,
 /*   230 */   449,  445,  441,  437,  185, 1354, 1223, 1288, 1289,   33,
 /*   240 */    32, 1241, 1826,   40,   38,   36,   35,   34,  157, 1314,
 /*   250 */    39,   37,  306,  292,  304,  303,  596,  455,  321,   70,
 /*   260 */  1217,  457,  183, 1322,  505, 1369, 1370, 1372, 1373, 1594,
 /*   270 */  1595,   39,   37, 1215,   22, 1218,  599, 1216,  519,  321,
 /*   280 */  1218, 1217, 1216,  456,   29,  319, 1303, 1304, 1305, 1306,
 /*   290 */  1307, 1311, 1312, 1313, 1215, 1242, 1296,   14,  414, 1221,
 /*   300 */  1222,  418, 1241, 1223, 1221, 1222,  119, 1270, 1271, 1273,
 /*   310 */  1274, 1275, 1276, 1277,  538,  560, 1285, 1286, 1287, 1290,
 /*   320 */     2,  519,  182,  175, 1223,  180,  523,  101, 1539,  428,
 /*   330 */   100,   99,   98,   97,   96,   95,   94,   93,   92, 1710,
 /*   340 */   139,    8,  641, 1726, 1505,  117,   33,   32,  173,  119,
 /*   350 */    40,   38,   36,   35,   34,  481, 1288, 1289, 1714,  588,
 /*   360 */   228, 1805,  518,  641,  517, 1706, 1712, 1864,  479, 1710,
 /*   370 */   477, 1744,  988,  138,  987, 1426,  562, 1288, 1289,  543,
 /*   380 */   600,  156, 1520,  420, 1696, 1861,  542,  451,  117, 1239,
 /*   390 */    39,   37, 1291, 1120, 1121, 1706, 1712,  499,  321, 1218,
 /*   400 */  1217, 1216,  989,  152, 1805, 1806,  562, 1810, 1526,  422,
 /*   410 */  1272, 1757,  418, 1215,  284, 1727,  545, 1729, 1730,  541,
 /*   420 */  1218,  562, 1216, 1221, 1222, 1537, 1270, 1271, 1273, 1274,
 /*   430 */  1275, 1276, 1277,  538,  560, 1285, 1286, 1287, 1290,  519,
 /*   440 */  1437,  558,  594, 1223, 1221, 1222,   69, 1270, 1271, 1273,
 /*   450 */  1274, 1275, 1276, 1277,  538,  560, 1285, 1286, 1287, 1290,
 /*   460 */     9,  127,  126,  591,  590,  589,  432,  119, 1544,   33,
 /*   470 */    32, 1272,  157,   40,   38,   36,   35,   34,  988,  200,
 /*   480 */   987, 1696,  641, 1436,   33,   32,  135,  523,   40,   38,
 /*   490 */    36,   35,   34,  359,   33,   32, 1288, 1289,   40,   38,
 /*   500 */    36,   35,   34,   42,   60, 1812,  117,  559,  989,   39,
 /*   510 */    37,  464,  463,  361,  357,  559,  559,  321,  373, 1217,
 /*   520 */   296,  228, 1805,  518, 1696,  517,  111,  111, 1864, 1809,
 /*   530 */    39,   37, 1215,  453,  458, 1548,   71,  294,  321, 1218,
 /*   540 */  1217, 1216,  154, 1548, 1548, 1243, 1861,   36,   35,   34,
 /*   550 */    33,   32, 1308, 1215,   40,   38,   36,   35,   34, 1381,
 /*   560 */   612,  610, 1223, 1221, 1222, 1415, 1270, 1271, 1273, 1274,
 /*   570 */  1275, 1276, 1277,  538,  560, 1285, 1286, 1287, 1290,    9,
 /*   580 */  1524,  490,  367, 1223,  366,  405,  101, 1533, 1636,  100,
 /*   590 */    99,   98,   97,   96,   95,   94,   93,   92, 1600,  166,
 /*   600 */     2,  641,   33,   32, 1309,  332,   40,   38,   36,   35,
 /*   610 */    34,  325,  559,  331, 1598, 1288, 1289, 1414, 1435,  136,
 /*   620 */  1427,  136,  641,  375, 1455, 1361,  164, 1314, 1550,  208,
 /*   630 */  1550,  168,  167, 1434,  157,  157, 1288, 1289,  596,  201,
 /*   640 */  1548,  110,  109,  108,  107,  106,  105,  104,  103,  102,
 /*   650 */   559,   67, 1812,    7,   66,   60,  519,   73, 1218, 1696,
 /*   660 */  1216,  390,   29,  319, 1303, 1304, 1305, 1306, 1307, 1311,
 /*   670 */  1312, 1313,  636,  230, 1696, 1310, 1808, 1255, 1548, 1218,
 /*   680 */  1433, 1216, 1221, 1222,  119, 1270, 1271, 1273, 1274, 1275,
 /*   690 */  1276, 1277,  538,  560, 1285, 1286, 1287, 1290, 1315, 1199,
 /*   700 */  1200, 1535,  497, 1221, 1222, 1476, 1270, 1271, 1273, 1274,
 /*   710 */  1275, 1276, 1277,  538,  560, 1285, 1286, 1287, 1290,  334,
 /*   720 */   136, 1696,  291,  117, 1239,  137, 1040,  136, 1812, 1551,
 /*   730 */   269,  398,  592,   27,  410, 1591, 1550,   58,  153, 1805,
 /*   740 */  1806,  457, 1810, 1864,  267,   57, 1600, 1432,   56, 1479,
 /*   750 */   546,  383, 1807,  411, 1412,  385, 1042,  154, 1241,  559,
 /*   760 */  1645, 1861, 1599,  456,  169,  527,  618,  617,  616,  336,
 /*   770 */   391,  615,  614,  613,  121,  608,  607,  606,  605,  604,
 /*   780 */   603,  602,  601,  129,  597,  376,  157, 1548, 1696,   60,
 /*   790 */  1078,  585,  584,  583, 1082,  582, 1084, 1085,  581, 1087,
 /*   800 */   578, 1525, 1093,  575, 1095, 1096,  572,  569, 1523,  593,
 /*   810 */   467,  466, 1591,  338,  483,  465, 1531,  263,  116,  462,
 /*   820 */  1578,  204,  461,  460,  459,  409, 1342,   86,  404,  403,
 /*   830 */   402,  401,  400,  397,  396,  395,  394,  393,  389,  388,
 /*   840 */   387,  386,  380,  379,  378,  377,  975,  976,  559, 1244,
 /*   850 */   537, 1431, 1430,  559, 1864, 1864, 1429,  328,  327,  431,
 /*   860 */    64,   63,  371, 1428, 1545,  163,  559, 1231,  154,  154,
 /*   870 */  1726,  365, 1861, 1861, 1346,  559, 1548, 1673, 1425, 1466,
 /*   880 */  1224, 1548,  290, 1817, 1342,  355,  556,  353,  349,  345,
 /*   890 */   160,  340, 1696, 1696, 1548,  594, 1424, 1696, 1744, 1423,
 /*   900 */   530,  468,  594, 1548, 1696,  191,  543, 1506,  189, 1422,
 /*   910 */  1223, 1696, 1421,  542,  127,  126,  591,  590,  589, 1696,
 /*   920 */   157,  127,  126,  591,  590,  589,  523, 1272, 1420, 1726,
 /*   930 */  1419,  207, 1418, 1417,   52,  494,  193, 1696, 1757,  192,
 /*   940 */  1696,   87, 1727,  545, 1729, 1730,  541,  472,  562,  563,
 /*   950 */  1696, 1797,  559, 1696,  528,  295, 1793, 1744,  195,   72,
 /*   960 */   535,  194,  482,  491,  525,  543, 1461, 1864,  559, 1696,
 /*   970 */  1696, 1696,  542, 1696, 1696, 1713,  199,  211,  329,  495,
 /*   980 */  1548,  154,   11,   10,  197, 1861, 1710,  196,  470, 1226,
 /*   990 */   475,  611, 1726,  587,  469, 1459, 1548, 1757,  559,  198,
 /*  1000 */    88, 1727,  545, 1729, 1730,  541, 1232,  562, 1227,  557,
 /*  1010 */  1797,  559, 1706, 1712,  314, 1793, 1877,  473,   50,  215,
 /*  1020 */  1744,   41,  252,  562,   55, 1832, 1548,   54,  543,  559,
 /*  1030 */  1235,  362,   41, 1696,   83,  542, 1409, 1410, 1716, 1548,
 /*  1040 */   335,  560, 1285, 1286,   80,   41, 1225,  241,  506,  234,
 /*  1050 */   123,  450,  124, 1726,  222,  125, 1745, 1548, 1368,  217,
 /*  1060 */  1757, 1316,   50,   88, 1727,  545, 1729, 1730,  541, 1012,
 /*  1070 */   562,  484, 1278, 1797, 1718, 1726,  337,  314, 1793, 1877,
 /*  1080 */   567, 1744,  124,  125, 1345, 1170, 1300,  243, 1855,  543,
 /*  1090 */   551,  531,  249, 1450, 1696, 1071,  542,  112, 1588, 1013,
 /*  1100 */  1828,  124,  262, 1744,  520,  233,  236,  238,    3,    5,
 /*  1110 */   339,  543, 1239,  342,  346,  301, 1696, 1229,  542, 1040,
 /*  1120 */  1099, 1757, 1103, 1110,   89, 1727,  545, 1729, 1730,  541,
 /*  1130 */   302,  562, 1183,  392, 1797,  259, 1726, 1108, 1796, 1793,
 /*  1140 */  1638,  128,  165, 1757,  399,  406,   88, 1727,  545, 1729,
 /*  1150 */  1730,  541,  408,  562,  412, 1245, 1797,  407,  413,  421,
 /*  1160 */   314, 1793, 1877, 1248, 1744,  424,  172,  425, 1247,  426,
 /*  1170 */   174, 1816,  543, 1249, 1228,  427,  177, 1696,  429,  542,
 /*  1180 */   179, 1246,  430,  181,   68,  433,  184,  452,  454, 1726,
 /*  1190 */  1538,  188,  523, 1678, 1534,  190,  293,  130,  131,   91,
 /*  1200 */  1677, 1536,  260, 1726, 1757,  485, 1532,  276, 1727,  545,
 /*  1210 */  1729, 1730,  541,  492,  562,  132,  133, 1744,  202,  489,
 /*  1220 */   205,  209,  486,  496,  502,  543, 1244,  507,    6,  516,
 /*  1230 */  1696, 1744,  542, 1864,  311,  549,  213, 1839,  504,  543,
 /*  1240 */  1838,  313,  144,  510, 1696,  523,  542,  156,  216, 1819,
 /*  1250 */  1829, 1861,  221,  503,  224, 1726,  501, 1757,  500,  226,
 /*  1260 */   276, 1727,  545, 1729, 1730,  541,  118,  562, 1342, 1243,
 /*  1270 */    44, 1757,  529, 1726,   89, 1727,  545, 1729, 1730,  541,
 /*  1280 */   532,  562,  225, 1744, 1797, 1813, 1864,  315,  534, 1793,
 /*  1290 */    18,  540,  227, 1643,  223, 1860, 1696, 1642,  542,  232,
 /*  1300 */   154, 1744, 1778,  552, 1861,  547,  548,  553,  323,  543,
 /*  1310 */   245,   79,  554, 1549, 1696,  261,  542, 1880,  247,   77,
 /*  1320 */   526,  533,  235, 1757,  565, 1726,  283, 1727,  545, 1729,
 /*  1330 */  1730,  541,  539,  562,  536, 1769, 1592,  237, 1521,  255,
 /*  1340 */   264, 1757, 1726,  637,  140, 1727,  545, 1729, 1730,  541,
 /*  1350 */   640,  562,  638, 1744,  266,   51,  143,  285,  287,  286,
 /*  1360 */   268,  543, 1690, 1689,   62, 1688, 1696,  341,  542, 1685,
 /*  1370 */  1744,  343,  344, 1210, 1211,  161,  348, 1683,  543,  350,
 /*  1380 */   351,  352, 1682, 1696,  354,  542, 1681,  356, 1680,  524,
 /*  1390 */  1878, 1726,  358, 1757, 1679,  360,   89, 1727,  545, 1729,
 /*  1400 */  1730,  541, 1663,  562,  363,  162, 1797,  364, 1186, 1185,
 /*  1410 */  1757, 1794, 1657,  279, 1727,  545, 1729, 1730,  541, 1744,
 /*  1420 */   562, 1656,  369,  370, 1655, 1654, 1157,  543, 1631,   65,
 /*  1430 */  1630, 1629, 1696, 1628,  542, 1627, 1626,  381,  382, 1625,
 /*  1440 */   384, 1624, 1623, 1622, 1621, 1620, 1619, 1618, 1617, 1616,
 /*  1450 */  1615, 1726,  515, 1614, 1613, 1612, 1611,  122, 1610, 1757,
 /*  1460 */  1726,  170,  140, 1727,  545, 1729, 1730,  541,  113,  562,
 /*  1470 */  1609, 1608, 1607, 1606, 1605, 1604,   33,   32, 1603, 1744,
 /*  1480 */    40,   38,   36,   35,   34, 1159, 1602,  543, 1744, 1601,
 /*  1490 */  1478, 1446, 1696,  978,  542,  977,  540,  417, 1445,  171,
 /*  1500 */   148, 1696, 1671,  542,  114,  318,  419, 1665, 1879, 1726,
 /*  1510 */   178, 1652, 1640, 1527, 1477,  176, 1475, 1473,  434, 1757,
 /*  1520 */  1653, 1726,  284, 1727,  545, 1729, 1730,  541, 1757,  562,
 /*  1530 */   438,  283, 1727,  545, 1729, 1730,  541, 1744,  562,  435,
 /*  1540 */  1770,  439, 1006,  436,  440,  543, 1471,  443,  444, 1744,
 /*  1550 */  1696, 1469,  542,  442,  446,  447, 1458,  543, 1457, 1442,
 /*  1560 */   448, 1529, 1696,  320,  542, 1114, 1113, 1528,   49,  187,
 /*  1570 */  1039, 1038,  644, 1037, 1726,  322, 1036, 1757, 1033, 1467,
 /*  1580 */   284, 1727,  545, 1729, 1730,  541,  258,  562,  609, 1757,
 /*  1590 */  1726,  611,  284, 1727,  545, 1729, 1730,  541, 1032,  562,
 /*  1600 */   147, 1031, 1744,  307, 1462,  634,  630,  626,  622,  256,
 /*  1610 */   543,  308, 1460,  471,  309, 1696, 1441,  542, 1744,  474,
 /*  1620 */   476, 1407, 1440,  478, 1439,  480,  543,   90, 1670, 1193,
 /*  1630 */  1664, 1696,   53,  542,   85,  487,  134,  250,  493, 1726,
 /*  1640 */  1651,  488, 1757, 1649,  206,  270, 1727,  545, 1729, 1730,
 /*  1650 */   541,  310,  562, 1650, 1648, 1647,   23,    4, 1757, 1383,
 /*  1660 */    41,  271, 1727,  545, 1729, 1730,  541, 1744,  562,  214,
 /*  1670 */   555,  220,  212,  141,   47,  543, 1367,  218,   24,   15,
 /*  1680 */  1696, 1360,  542, 1716,  219,   25,   10,   74,   46, 1339,
 /*  1690 */   229, 1338,  145, 1400,   17, 1395, 1394,  316,   45, 1726,
 /*  1700 */   210, 1389,   16, 1406, 1399, 1398,  317, 1757, 1726, 1301,
 /*  1710 */   272, 1727,  545, 1729, 1730,  541,   19,  562,   13, 1280,
 /*  1720 */   146, 1191, 1279,  203,  158, 1263,  544, 1744,  550,   31,
 /*  1730 */    12,   20, 1639,  246,   21,  543, 1744, 1715,  251,  240,
 /*  1740 */  1696, 1365,  542,  248,  543,  242, 1233,  244,   75, 1696,
 /*  1750 */    76,  542,  564,  566, 1760,  330,  570, 1726, 1282,   80,
 /*  1760 */  1100,  561,   48,  568,  573, 1097, 1094, 1757,  571, 1726,
 /*  1770 */   278, 1727,  545, 1729, 1730,  541, 1757,  562,  574,  280,
 /*  1780 */  1727,  545, 1729, 1730,  541, 1744,  562, 1088,  576,  577,
 /*  1790 */   579, 1086,  580,  543, 1092, 1091, 1090, 1744, 1696, 1089,
 /*  1800 */   542, 1077, 1109,  586,   81,  543,  253,   82,   59, 1105,
 /*  1810 */  1696, 1004,  542,  595, 1046, 1028,  598,  254, 1026, 1025,
 /*  1820 */  1726, 1024, 1021, 1023, 1022, 1757, 1020, 1019,  273, 1727,
 /*  1830 */   545, 1729, 1730,  541, 1726,  562, 1043, 1757, 1041, 1016,
 /*  1840 */   281, 1727,  545, 1729, 1730,  541, 1015,  562, 1744, 1014,
 /*  1850 */  1011, 1010, 1009, 1474,  619,  620,  543,  621, 1472,  623,
 /*  1860 */   624, 1696, 1744,  542,  625, 1470,  627,  628,  629, 1468,
 /*  1870 */   543,  631,  633,  632, 1456, 1696,  635,  542,  968, 1438,
 /*  1880 */   643,  257,  639, 1413, 1219, 1726,  265,  642, 1757, 1413,
 /*  1890 */  1413,  274, 1727,  545, 1729, 1730,  541, 1726,  562, 1413,
 /*  1900 */  1413, 1413, 1757, 1413, 1413,  282, 1727,  545, 1729, 1730,
 /*  1910 */   541, 1726,  562, 1744, 1413, 1413, 1413, 1413, 1413, 1413,
 /*  1920 */  1413,  543, 1413, 1413, 1413, 1744, 1696, 1413,  542, 1413,
 /*  1930 */  1413, 1413, 1413,  543, 1413, 1413, 1413, 1413, 1696, 1744,
 /*  1940 */   542, 1413, 1413, 1413, 1413, 1413, 1413,  543, 1413, 1413,
 /*  1950 */  1413, 1413, 1696, 1757,  542, 1413,  275, 1727,  545, 1729,
 /*  1960 */  1730,  541, 1726,  562, 1413, 1757, 1413, 1413,  288, 1727,
 /*  1970 */   545, 1729, 1730,  541, 1413,  562, 1413, 1413, 1413, 1757,
 /*  1980 */  1413, 1413,  289, 1727,  545, 1729, 1730,  541, 1726,  562,
 /*  1990 */  1744, 1413, 1413, 1413, 1413, 1413, 1413, 1413,  543, 1413,
 /*  2000 */  1413, 1413, 1413, 1696, 1413,  542, 1413, 1413, 1413, 1413,
 /*  2010 */  1413, 1413, 1413, 1413, 1413, 1413, 1744, 1413, 1413, 1413,
 /*  2020 */  1413, 1413, 1413, 1413,  543, 1413, 1413, 1413, 1413, 1696,
 /*  2030 */  1757,  542, 1413, 1738, 1727,  545, 1729, 1730,  541, 1413,
 /*  2040 */   562, 1726, 1413, 1413, 1413, 1413, 1413, 1413, 1413, 1413,
 /*  2050 */  1413, 1413, 1413, 1726, 1413, 1413, 1757, 1413, 1413, 1737,
 /*  2060 */  1727,  545, 1729, 1730,  541, 1413,  562, 1413, 1413, 1744,
 /*  2070 */  1413, 1413, 1413, 1413, 1413, 1413, 1413,  543, 1413, 1413,
 /*  2080 */  1413, 1744, 1696, 1413,  542, 1413, 1413, 1413, 1413,  543,
 /*  2090 */  1413, 1413, 1413, 1413, 1696, 1413,  542, 1413, 1413, 1413,
 /*  2100 */  1413, 1413, 1413, 1413, 1726, 1413, 1413, 1413, 1413, 1757,
 /*  2110 */  1413, 1413, 1736, 1727,  545, 1729, 1730,  541, 1726,  562,
 /*  2120 */  1413, 1757, 1413, 1413,  299, 1727,  545, 1729, 1730,  541,
 /*  2130 */  1413,  562, 1744, 1413, 1413, 1413, 1413, 1413, 1413, 1413,
 /*  2140 */   543, 1413, 1413, 1413, 1413, 1696, 1744,  542, 1413, 1413,
 /*  2150 */  1413, 1413, 1413, 1413,  543, 1413, 1413, 1413, 1413, 1696,
 /*  2160 */  1413,  542, 1413, 1413, 1413, 1413, 1413, 1413, 1413, 1726,
 /*  2170 */  1413, 1413, 1757, 1413, 1413,  298, 1727,  545, 1729, 1730,
 /*  2180 */   541, 1726,  562, 1413, 1413, 1413, 1757, 1413, 1413,  300,
 /*  2190 */  1727,  545, 1729, 1730,  541, 1413,  562, 1744, 1413, 1413,
 /*  2200 */  1413, 1413, 1413, 1413, 1413,  543, 1413, 1413, 1413, 1744,
 /*  2210 */  1696, 1413,  542, 1413, 1413, 1413, 1413,  543, 1413, 1413,
 /*  2220 */  1413, 1413, 1696, 1413,  542, 1413, 1413, 1413, 1413, 1413,
 /*  2230 */  1413, 1413, 1413, 1413, 1413, 1413, 1413, 1757, 1413, 1413,
 /*  2240 */   297, 1727,  545, 1729, 1730,  541, 1413,  562, 1413, 1757,
 /*  2250 */  1413, 1413,  277, 1727,  545, 1729, 1730,  541, 1413,  562,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   257,  251,  247,  253,  254,  329,  330,  251,    4,  253,
 /*    10 */   254,  344,   12,   13,  344,   12,   13,   14,   15,   16,
 /*    20 */    20,  278,   22,  286,  259,  358,  289,  290,  358,  362,
 /*    30 */   275,  277,  362,  275,  280,   35,   20,  272,  283,  255,
 /*    40 */   282,    2,  288,  288,    4,  290,  281,    8,    9,  291,
 /*    50 */     2,   12,   13,   14,   15,   16,    8,    9,  275,   59,
 /*    60 */    12,   13,   14,   15,   16,   65,  283,  283,  314,  315,
 /*    70 */   315,  303,  247,  318,  319,  320,  321,  322,  323,  325,
 /*    80 */   325,  257,   82,  328,   44,   45,   82,  332,  333,  334,
 /*    90 */     0,    8,    9,  344,  270,   12,   13,   14,   15,   16,
 /*   100 */   275,  346,  278,  320,  104,   58,  322,  358,  283,  354,
 /*   110 */   355,  362,  344,  288,   20,  290,  274,   82,  118,  119,
 /*   120 */   336,  337,  338,  339,  255,  341,  358,  255,  303,  287,
 /*   130 */   362,   12,   13,   14,  247,  266,   22,   47,  266,   20,
 /*   140 */   315,   22,   59,  318,  319,  320,  321,  322,  323,   35,
 /*   150 */   325,   20,  283,  328,   35,  283,  146,  332,  333,   61,
 /*   160 */    62,  161,  275,  163,   66,   20,   83,   69,   70,  344,
 /*   170 */   283,   73,   74,   75,   91,  288,   82,  290,   59,   65,
 /*   180 */    20,    1,    2,  358,   65,  185,  186,  362,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  198,  199,
 /*   200 */   200,   82,  315,   20,   37,  318,  319,  320,  321,  322,
 /*   210 */   323,   33,  325,  213,  290,  328,  255,  213,  104,  332,
 /*   220 */   333,  334,  298,  104,  300,   47,  143,  185,  218,  219,
 /*   230 */    52,   53,   54,   55,   56,   14,   65,  118,  119,    8,
 /*   240 */     9,   20,  355,   12,   13,   14,   15,   16,  213,  166,
 /*   250 */    12,   13,   85,  292,   87,   88,   58,   90,   20,   81,
 /*   260 */    22,   94,   84,   83,  222,  223,  224,  225,  226,  289,
 /*   270 */   290,   12,   13,   35,   43,  161,   65,  163,  255,   20,
 /*   280 */   161,   22,  163,  116,  201,  202,  203,  204,  205,  206,
 /*   290 */   207,  208,  209,  210,   35,   20,   14,   59,  252,  185,
 /*   300 */   186,  255,   20,   65,  185,  186,  283,  188,  189,  190,
 /*   310 */   191,  192,  193,  194,  195,  196,  197,  198,  199,  200,
 /*   320 */    82,  255,  144,  145,   65,  147,  303,   21,  277,  151,
 /*   330 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  288,
 /*   340 */   260,   82,  104,  247,  264,  322,    8,    9,  170,  283,
 /*   350 */    12,   13,   14,   15,   16,   21,  118,  119,  277,   93,
 /*   360 */   337,  338,  339,  104,  341,  314,  315,  344,   34,  288,
 /*   370 */    36,  275,   20,  246,   22,  248,  325,  118,  119,  283,
 /*   380 */   263,  358,  265,   14,  288,  362,  290,   35,  322,   20,
 /*   390 */    12,   13,   14,  118,  119,  314,  315,  301,   20,  161,
 /*   400 */    22,  163,   50,  337,  338,  339,  325,  341,    0,  252,
 /*   410 */   189,  315,  255,   35,  318,  319,  320,  321,  322,  323,
 /*   420 */   161,  325,  163,  185,  186,  276,  188,  189,  190,  191,
 /*   430 */   192,  193,  194,  195,  196,  197,  198,  199,  200,  255,
 /*   440 */   247,   20,   94,   65,  185,  186,  259,  188,  189,  190,
 /*   450 */   191,  192,  193,  194,  195,  196,  197,  198,  199,  200,
 /*   460 */    82,  113,  114,  115,  116,  117,   58,  283,  281,    8,
 /*   470 */     9,  189,  213,   12,   13,   14,   15,   16,   20,  114,
 /*   480 */    22,  288,  104,  247,    8,    9,  148,  303,   12,   13,
 /*   490 */    14,   15,   16,  156,    8,    9,  118,  119,   12,   13,
 /*   500 */    14,   15,   16,   82,   82,  316,  322,  255,   50,   12,
 /*   510 */    13,  261,  262,  176,  177,  255,  255,   20,  266,   22,
 /*   520 */    59,  337,  338,  339,  288,  341,  266,  266,  344,  340,
 /*   530 */    12,   13,   35,  273,  273,  283,  171,  172,   20,  161,
 /*   540 */    22,  163,  358,  283,  283,   20,  362,   14,   15,   16,
 /*   550 */     8,    9,   91,   35,   12,   13,   14,   15,   16,   83,
 /*   560 */   261,  262,   65,  185,  186,    0,  188,  189,  190,  191,
 /*   570 */   192,  193,  194,  195,  196,  197,  198,  199,  200,   82,
 /*   580 */     0,  307,  160,   65,  162,   76,   21,  276,  283,   24,
 /*   590 */    25,   26,   27,   28,   29,   30,   31,   32,  275,  294,
 /*   600 */    82,  104,    8,    9,  143,  282,   12,   13,   14,   15,
 /*   610 */    16,  267,  255,  267,  291,  118,  119,    0,  247,  275,
 /*   620 */   248,  275,  104,  266,    0,   83,   56,  166,  284,   56,
 /*   630 */   284,  122,  123,  247,  213,  213,  118,  119,   58,  113,
 /*   640 */   283,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   650 */   255,   81,  316,   39,   84,   82,  255,   84,  161,  288,
 /*   660 */   163,  266,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   670 */   209,  210,   48,  148,  288,  143,  340,   83,  283,  161,
 /*   680 */   247,  163,  185,  186,  283,  188,  189,  190,  191,  192,
 /*   690 */   193,  194,  195,  196,  197,  198,  199,  200,  166,  173,
 /*   700 */   174,  276,  303,  185,  186,    0,  188,  189,  190,  191,
 /*   710 */   192,  193,  194,  195,  196,  197,  198,  199,  200,  267,
 /*   720 */   275,  288,   18,  322,   20,   18,   35,  275,  316,  284,
 /*   730 */    23,   27,  285,  201,   30,  288,  284,    3,  337,  338,
 /*   740 */   339,   94,  341,  344,   37,   38,  275,  247,   41,    0,
 /*   750 */   290,   47,  340,   49,  244,   51,   65,  358,   20,  255,
 /*   760 */   300,  362,  291,  116,   57,   43,   61,   62,   63,   64,
 /*   770 */   266,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   780 */    75,   76,   77,   78,   79,   81,  213,  283,  288,   82,
 /*   790 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   800 */   105,    0,  107,  108,  109,  110,  111,  112,    0,  285,
 /*   810 */    61,   62,  288,  303,  303,   66,  276,  268,   69,   70,
 /*   820 */   271,  276,   73,   74,   75,  121,  212,  120,  124,  125,
 /*   830 */   126,  127,  128,  129,  130,  131,  132,  133,  134,  135,
 /*   840 */   136,  137,  138,  139,  140,  141,   44,   45,  255,   20,
 /*   850 */   276,  247,  247,  255,  344,  344,  247,   12,   13,  266,
 /*   860 */   153,  154,  155,  247,  266,  158,  255,   22,  358,  358,
 /*   870 */   247,  164,  362,  362,    4,  255,  283,  266,  247,    0,
 /*   880 */    35,  283,  175,  211,  212,  178,  266,  180,  181,  182,
 /*   890 */   183,  184,  288,  288,  283,   94,  247,  288,  275,  247,
 /*   900 */    43,   22,   94,  283,  288,   86,  283,  264,   89,  247,
 /*   910 */    65,  288,  247,  290,  113,  114,  115,  116,  117,  288,
 /*   920 */   213,  113,  114,  115,  116,  117,  303,  189,  247,  247,
 /*   930 */   247,   56,  247,  247,  148,  149,   86,  288,  315,   89,
 /*   940 */   288,  318,  319,  320,  321,  322,  323,    4,  325,  104,
 /*   950 */   288,  328,  255,  288,  232,  332,  333,  275,   86,   84,
 /*   960 */    59,   89,   19,  266,  230,  283,    0,  344,  255,  288,
 /*   970 */   288,  288,  290,  288,  288,  277,   33,  148,  280,  266,
 /*   980 */   283,  358,    1,    2,   86,  362,  288,   89,   22,   35,
 /*   990 */    47,   43,  247,  276,   51,    0,  283,  315,  255,   56,
 /*  1000 */   318,  319,  320,  321,  322,  323,  161,  325,  163,  266,
 /*  1010 */   328,  255,  314,  315,  332,  333,  334,   22,   43,   43,
 /*  1020 */   275,   43,  266,  325,   81,  343,  283,   84,  283,  255,
 /*  1030 */   185,   83,   43,  288,   82,  290,  118,  119,   46,  283,
 /*  1040 */   266,  196,  197,  198,   92,   43,   35,   43,  356,  365,
 /*  1050 */    43,  256,   43,  247,  351,   43,  275,  283,   83,   83,
 /*  1060 */   315,   83,   43,  318,  319,  320,  321,  322,  323,   35,
 /*  1070 */   325,  311,   83,  328,   82,  247,  256,  332,  333,  334,
 /*  1080 */    43,  275,   43,   43,  214,   83,  185,   83,  343,  283,
 /*  1090 */    83,  234,   83,  254,  288,   83,  290,   43,  287,   65,
 /*  1100 */   317,   43,   83,  275,  342,  359,  359,  359,  345,  215,
 /*  1110 */   313,  283,   20,  255,   47,  312,  288,  163,  290,   35,
 /*  1120 */    83,  315,   83,   83,  318,  319,  320,  321,  322,  323,
 /*  1130 */   261,  325,  159,  255,  328,  305,  247,   83,  332,  333,
 /*  1140 */   255,   83,   42,  315,  295,  293,  318,  319,  320,  321,
 /*  1150 */   322,  323,  293,  325,  255,   20,  328,  143,  249,  249,
 /*  1160 */   332,  333,  334,   20,  275,  309,  259,  290,   20,  302,
 /*  1170 */   259,  343,  283,   20,  163,  304,  259,  288,  302,  290,
 /*  1180 */   259,   20,  296,  259,  259,  255,  259,  249,  275,  247,
 /*  1190 */   275,  275,  303,  288,  275,  275,  249,  275,  275,  255,
 /*  1200 */   288,  275,  309,  247,  315,  169,  275,  318,  319,  320,
 /*  1210 */   321,  322,  323,  255,  325,  275,  275,  275,  257,  290,
 /*  1220 */   257,  257,  308,  255,  288,  283,   20,  221,  227,  152,
 /*  1230 */   288,  275,  290,  344,  302,  220,  299,  350,  288,  283,
 /*  1240 */   350,  288,  350,  288,  288,  303,  290,  358,  299,  353,
 /*  1250 */   317,  362,  352,  229,  348,  247,  228,  315,  216,  313,
 /*  1260 */   318,  319,  320,  321,  322,  323,  283,  325,  212,   20,
 /*  1270 */    42,  315,  231,  247,  318,  319,  320,  321,  322,  323,
 /*  1280 */   233,  325,  347,  275,  328,  316,  344,  236,  332,  333,
 /*  1290 */    82,  283,  335,  299,  349,  361,  288,  299,  290,  360,
 /*  1300 */   358,  275,  331,  145,  362,  288,  288,  297,  288,  283,
 /*  1310 */   283,   82,  296,  283,  288,  271,  290,  366,  257,  257,
 /*  1320 */   361,  361,  360,  315,  279,  247,  318,  319,  320,  321,
 /*  1330 */   322,  323,  324,  325,  326,  327,  288,  360,  265,  257,
 /*  1340 */   255,  315,  247,   36,  318,  319,  320,  321,  322,  323,
 /*  1350 */   249,  325,  250,  275,  258,  306,  310,  269,  269,  269,
 /*  1360 */   245,  283,    0,    0,   42,    0,  288,   73,  290,    0,
 /*  1370 */   275,   35,  179,   35,   35,   35,  179,    0,  283,   35,
 /*  1380 */    35,  179,    0,  288,  179,  290,    0,   35,    0,  363,
 /*  1390 */   364,  247,   22,  315,    0,   35,  318,  319,  320,  321,
 /*  1400 */   322,  323,    0,  325,  166,   82,  328,  165,  163,  161,
 /*  1410 */   315,  333,    0,  318,  319,  320,  321,  322,  323,  275,
 /*  1420 */   325,    0,  157,  156,    0,    0,   46,  283,    0,  142,
 /*  1430 */     0,    0,  288,    0,  290,    0,    0,  137,   35,    0,
 /*  1440 */   137,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1450 */     0,  247,  357,    0,    0,    0,    0,   42,    0,  315,
 /*  1460 */   247,   42,  318,  319,  320,  321,  322,  323,   39,  325,
 /*  1470 */     0,    0,    0,    0,    0,    0,    8,    9,    0,  275,
 /*  1480 */    12,   13,   14,   15,   16,   22,    0,  283,  275,    0,
 /*  1490 */     0,    0,  288,   14,  290,   14,  283,   46,    0,   40,
 /*  1500 */    43,  288,    0,  290,   39,  301,   46,    0,  364,  247,
 /*  1510 */   152,    0,    0,    0,    0,   39,    0,    0,   35,  315,
 /*  1520 */     0,  247,  318,  319,  320,  321,  322,  323,  315,  325,
 /*  1530 */    35,  318,  319,  320,  321,  322,  323,  275,  325,   47,
 /*  1540 */   327,   47,   60,   39,   39,  283,    0,   47,   39,  275,
 /*  1550 */   288,    0,  290,   35,   35,   47,    0,  283,    0,    0,
 /*  1560 */    39,    0,  288,  301,  290,   35,   22,    0,   91,   89,
 /*  1570 */    35,   35,   19,   35,  247,  301,   35,  315,   35,    0,
 /*  1580 */   318,  319,  320,  321,  322,  323,   33,  325,   43,  315,
 /*  1590 */   247,   43,  318,  319,  320,  321,  322,  323,   35,  325,
 /*  1600 */    47,   35,  275,   22,    0,   52,   53,   54,   55,   56,
 /*  1610 */   283,   22,    0,   49,   22,  288,    0,  290,  275,   35,
 /*  1620 */    35,  153,    0,   35,    0,   22,  283,   20,    0,   35,
 /*  1630 */     0,  288,  148,  290,   81,   22,  167,   84,  150,  247,
 /*  1640 */     0,  148,  315,    0,  145,  318,  319,  320,  321,  322,
 /*  1650 */   323,  148,  325,    0,    0,    0,   82,   43,  315,   83,
 /*  1660 */    43,  318,  319,  320,  321,  322,  323,  275,  325,   83,
 /*  1670 */   117,   46,   82,   82,   43,  283,   83,   82,   82,  217,
 /*  1680 */   288,   83,  290,   46,   43,   43,    2,   82,   43,   83,
 /*  1690 */    46,   83,   46,   83,   43,   35,   35,   35,  211,  247,
 /*  1700 */   147,   83,  217,  235,   35,   35,   35,  315,  247,  185,
 /*  1710 */   318,  319,  320,  321,  322,  323,   43,  325,  217,   83,
 /*  1720 */    46,  168,   83,  170,   46,   22,  187,  275,  146,   82,
 /*  1730 */    82,   82,    0,   39,   82,  283,  275,   46,   46,   83,
 /*  1740 */   288,   83,  290,  144,  283,   82,   22,   82,   82,  288,
 /*  1750 */    82,  290,   93,   35,   82,   35,   35,  247,   83,   92,
 /*  1760 */    83,   82,   82,   82,   35,   83,   83,  315,   82,  247,
 /*  1770 */   318,  319,  320,  321,  322,  323,  315,  325,   82,  318,
 /*  1780 */   319,  320,  321,  322,  323,  275,  325,   83,   35,   82,
 /*  1790 */    35,   83,   82,  283,  106,  106,  106,  275,  288,  106,
 /*  1800 */   290,   22,   35,   94,   82,  283,   43,   82,   82,   22,
 /*  1810 */   288,   60,  290,   59,   65,   35,   80,   43,   35,   35,
 /*  1820 */   247,   35,   22,   35,   35,  315,   35,   35,  318,  319,
 /*  1830 */   320,  321,  322,  323,  247,  325,   65,  315,   35,   35,
 /*  1840 */   318,  319,  320,  321,  322,  323,   35,  325,  275,   35,
 /*  1850 */    35,   35,   35,    0,   35,   47,  283,   39,    0,   35,
 /*  1860 */    47,  288,  275,  290,   39,    0,   35,   47,   39,    0,
 /*  1870 */   283,   35,   39,   47,    0,  288,   35,  290,   35,    0,
 /*  1880 */    20,   22,   21,  367,   22,  247,   22,   21,  315,  367,
 /*  1890 */   367,  318,  319,  320,  321,  322,  323,  247,  325,  367,
 /*  1900 */   367,  367,  315,  367,  367,  318,  319,  320,  321,  322,
 /*  1910 */   323,  247,  325,  275,  367,  367,  367,  367,  367,  367,
 /*  1920 */   367,  283,  367,  367,  367,  275,  288,  367,  290,  367,
 /*  1930 */   367,  367,  367,  283,  367,  367,  367,  367,  288,  275,
 /*  1940 */   290,  367,  367,  367,  367,  367,  367,  283,  367,  367,
 /*  1950 */   367,  367,  288,  315,  290,  367,  318,  319,  320,  321,
 /*  1960 */   322,  323,  247,  325,  367,  315,  367,  367,  318,  319,
 /*  1970 */   320,  321,  322,  323,  367,  325,  367,  367,  367,  315,
 /*  1980 */   367,  367,  318,  319,  320,  321,  322,  323,  247,  325,
 /*  1990 */   275,  367,  367,  367,  367,  367,  367,  367,  283,  367,
 /*  2000 */   367,  367,  367,  288,  367,  290,  367,  367,  367,  367,
 /*  2010 */   367,  367,  367,  367,  367,  367,  275,  367,  367,  367,
 /*  2020 */   367,  367,  367,  367,  283,  367,  367,  367,  367,  288,
 /*  2030 */   315,  290,  367,  318,  319,  320,  321,  322,  323,  367,
 /*  2040 */   325,  247,  367,  367,  367,  367,  367,  367,  367,  367,
 /*  2050 */   367,  367,  367,  247,  367,  367,  315,  367,  367,  318,
 /*  2060 */   319,  320,  321,  322,  323,  367,  325,  367,  367,  275,
 /*  2070 */   367,  367,  367,  367,  367,  367,  367,  283,  367,  367,
 /*  2080 */   367,  275,  288,  367,  290,  367,  367,  367,  367,  283,
 /*  2090 */   367,  367,  367,  367,  288,  367,  290,  367,  367,  367,
 /*  2100 */   367,  367,  367,  367,  247,  367,  367,  367,  367,  315,
 /*  2110 */   367,  367,  318,  319,  320,  321,  322,  323,  247,  325,
 /*  2120 */   367,  315,  367,  367,  318,  319,  320,  321,  322,  323,
 /*  2130 */   367,  325,  275,  367,  367,  367,  367,  367,  367,  367,
 /*  2140 */   283,  367,  367,  367,  367,  288,  275,  290,  367,  367,
 /*  2150 */   367,  367,  367,  367,  283,  367,  367,  367,  367,  288,
 /*  2160 */   367,  290,  367,  367,  367,  367,  367,  367,  367,  247,
 /*  2170 */   367,  367,  315,  367,  367,  318,  319,  320,  321,  322,
 /*  2180 */   323,  247,  325,  367,  367,  367,  315,  367,  367,  318,
 /*  2190 */   319,  320,  321,  322,  323,  367,  325,  275,  367,  367,
 /*  2200 */   367,  367,  367,  367,  367,  283,  367,  367,  367,  275,
 /*  2210 */   288,  367,  290,  367,  367,  367,  367,  283,  367,  367,
 /*  2220 */   367,  367,  288,  367,  290,  367,  367,  367,  367,  367,
 /*  2230 */   367,  367,  367,  367,  367,  367,  367,  315,  367,  367,
 /*  2240 */   318,  319,  320,  321,  322,  323,  367,  325,  367,  315,
 /*  2250 */   367,  367,  318,  319,  320,  321,  322,  323,  367,  325,
};
#define YY_SHIFT_COUNT    (644)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1879)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   707,    0,    0,  119,  238,  238,  238,  238,  259,  259,
 /*    10 */   238,  238,  378,  497,  518,  497,  497,  497,  497,  497,
 /*    20 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*    30 */   497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
 /*    40 */   497,  497,  421,  421,   94,   94,   94,  845,  845,  845,
 /*    50 */   845,  422,  573,   35,   16,   16,   40,   40,    4,  275,
 /*    60 */    35,   35,   16,   16,   16,   16,   16,   16,   16,   16,
 /*    70 */    47,   16,   16,   16,  131,  145,  160,   16,   16,  160,
 /*    80 */    16,  160,  160,  160,   16,  198,  704,   83,  461,  461,
 /*    90 */   306,   98,  114,  114,  114,  114,  114,  114,  114,  114,
 /*   100 */   114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
 /*   110 */   114,  167,  275,  369,  369,  408,  691,  525,  525,  525,
 /*   120 */   580,  691,  183,  145,  160,  160,  171,  171,  266,  211,
 /*   130 */   695,  695,  695,  695,  695,  695,  695, 1553,  565,  749,
 /*   140 */  1468,   42,  352,  365,   10,  221,  282,  458,  802,  647,
 /*   150 */   829,  672,  614,  672,  734,  734,  734,  870,  738,  894,
 /*   160 */  1092, 1067, 1084,  973, 1092, 1092, 1100, 1014, 1014, 1092,
 /*   170 */  1135, 1135, 1143,   47,  145,   47, 1148, 1153,   47, 1148,
 /*   180 */    47, 1161,   47,   47, 1092,   47, 1135,  160,  160,  160,
 /*   190 */   160,  160,  160,  160,  160,  160,  160,  160, 1092, 1135,
 /*   200 */   171,  171, 1143,  198, 1036,  145,  198, 1092, 1092, 1148,
 /*   210 */   198, 1206,  171, 1006, 1015,  171, 1006, 1015,  171,  171,
 /*   220 */   160, 1001, 1077, 1006, 1024, 1028, 1042,  894, 1056,  183,
 /*   230 */  1249, 1228, 1047, 1041, 1051, 1047, 1041, 1047, 1041, 1208,
 /*   240 */  1015,  171,  171, 1015,  171, 1158,  183, 1161,  198,  266,
 /*   250 */   198,  183, 1229,  171,  211, 1092,  198, 1307, 1135, 2260,
 /*   260 */  2260, 2260, 2260, 2260, 2260, 2260,  705,  178,  617,  943,
 /*   270 */   476,  231,  542,   39,   48,  338,  594,  486,  486,  486,
 /*   280 */   486,  486,  486,  486,  486,  801,  808,  348,    3,    3,
 /*   290 */   337,  570,  509,  334,  526,  180,  532,  533,  533,  533,
 /*   300 */   533,   90,  948,  819,  850,  872,  898,  879,  966,  995,
 /*   310 */   875,  786,  975,  976,  981,  918,  722,  857,  978,  901,
 /*   320 */   989,  992, 1002, 1004, 1007, 1009, 1012,  954, 1011, 1019,
 /*   330 */  1037, 1039, 1040, 1054, 1058,  952, 1034,  624, 1362, 1363,
 /*   340 */  1322, 1365, 1294, 1369, 1336, 1193, 1338, 1339, 1340, 1197,
 /*   350 */  1377, 1344, 1345, 1202, 1382, 1205, 1386, 1352, 1388, 1370,
 /*   360 */  1394, 1360, 1402, 1323, 1238, 1242, 1245, 1248, 1412, 1421,
 /*   370 */  1265, 1267, 1424, 1425, 1380, 1428, 1287, 1430, 1431, 1433,
 /*   380 */  1435, 1436, 1300, 1403, 1439, 1303, 1441, 1442, 1443, 1444,
 /*   390 */  1445, 1446, 1447, 1448, 1449, 1450, 1453, 1454, 1455, 1456,
 /*   400 */  1415, 1458, 1470, 1471, 1472, 1473, 1474, 1463, 1475, 1478,
 /*   410 */  1486, 1489, 1490, 1491, 1419, 1429, 1457, 1479, 1451, 1481,
 /*   420 */  1460, 1498, 1459, 1465, 1502, 1507, 1520, 1476, 1358, 1511,
 /*   430 */  1512, 1513, 1482, 1514, 1516, 1483, 1492, 1504, 1517, 1495,
 /*   440 */  1494, 1505, 1546, 1518, 1500, 1509, 1551, 1519, 1508, 1521,
 /*   450 */  1556, 1558, 1559, 1561, 1477, 1480, 1530, 1544, 1567, 1535,
 /*   460 */  1536, 1538, 1541, 1545, 1548, 1543, 1563, 1566, 1579, 1581,
 /*   470 */  1604, 1589, 1564, 1612, 1592, 1584, 1616, 1585, 1622, 1588,
 /*   480 */  1624, 1603, 1607, 1628, 1484, 1594, 1630, 1469, 1613, 1493,
 /*   490 */  1499, 1640, 1643, 1503, 1488, 1653, 1654, 1655, 1614, 1617,
 /*   500 */  1462, 1574, 1576, 1590, 1586, 1631, 1593, 1591, 1595, 1596,
 /*   510 */  1598, 1641, 1625, 1637, 1605, 1642, 1485, 1606, 1608, 1644,
 /*   520 */  1487, 1645, 1646, 1610, 1651, 1501, 1618, 1660, 1661, 1662,
 /*   530 */  1669, 1670, 1671, 1618, 1684, 1524, 1673, 1636, 1647, 1639,
 /*   540 */  1674, 1648, 1649, 1678, 1703, 1539, 1652, 1656, 1658, 1663,
 /*   550 */  1665, 1582, 1666, 1732, 1694, 1599, 1668, 1667, 1691, 1692,
 /*   560 */  1672, 1675, 1679, 1724, 1680, 1659, 1677, 1718, 1720, 1681,
 /*   570 */  1682, 1721, 1686, 1683, 1729, 1696, 1704, 1753, 1707, 1708,
 /*   580 */  1755, 1710, 1688, 1689, 1690, 1693, 1779, 1709, 1722, 1725,
 /*   590 */  1767, 1726, 1763, 1763, 1787, 1751, 1754, 1780, 1749, 1736,
 /*   600 */  1774, 1783, 1784, 1786, 1788, 1789, 1800, 1791, 1792, 1771,
 /*   610 */  1545, 1803, 1548, 1804, 1811, 1814, 1815, 1816, 1817, 1853,
 /*   620 */  1819, 1808, 1818, 1858, 1824, 1813, 1825, 1865, 1831, 1820,
 /*   630 */  1829, 1869, 1836, 1826, 1833, 1874, 1841, 1843, 1879, 1859,
 /*   640 */  1861, 1862, 1864, 1866, 1860,
};
#define YY_REDUCE_COUNT (265)
#define YY_REDUCE_MIN   (-333)
#define YY_REDUCE_MAX   (1934)
static const short yy_reduce_ofst[] = {
 /*     0 */   510, -175,  623, -245, -113,  682,  745,  828,  889,  942,
 /*    10 */   806,  956, 1008, 1026, 1078,   96, 1095, 1144, 1204, 1213,
 /*    20 */  1262, 1274, 1327, 1343, 1392, 1452, 1461, 1510, 1522, 1573,
 /*    30 */  1587, 1638, 1650, 1664, 1715, 1741, 1794, 1806, 1857, 1871,
 /*    40 */  1922, 1934,   23,  184, -216,   66,  401, -246,  698,   51,
 /*    50 */    81, -232,  399,  511,  260,  261, -250, -244, -333, -263,
 /*    60 */  -330, -251, -131, -128,  252,  357,  395,  504,  593,  598,
 /*    70 */  -235,  611,  697,  713, -217,  -76,  344,  620,  743, -242,
 /*    80 */   756,  346,  323,  452,  774, -176,  -39, -324, -324, -324,
 /*    90 */   127,   80,  193,  236,  371,  386,  433,  500,  604,  605,
 /*   100 */   609,  616,  631,  649,  652,  662,  665,  681,  683,  685,
 /*   110 */   686, -158,  -20,   46,  157,  187,  250,  189,  336,  412,
 /*   120 */  -257,  299,  305,  460,  445,  471,  447,  524,  549,  117,
 /*   130 */   149,  311,  425,  540,  545,  574,  717,  274,  372,  643,
 /*   140 */   684,  692,  795,  760,  703,  781,  781,  820,  839,  811,
 /*   150 */   783,  762,  762,  762,  746,  747,  748,  763,  781,  797,
 /*   160 */   858,  803,  869,  830,  878,  885,  849,  852,  859,  899,
 /*   170 */   909,  910,  856,  907,  877,  911,  867,  871,  917,  876,
 /*   180 */   921,  886,  924,  925,  930,  927,  938,  913,  915,  916,
 /*   190 */   919,  920,  922,  923,  926,  931,  940,  941,  944,  947,
 /*   200 */   905,  912,  893,  961,  914,  929,  963,  958,  968,  932,
 /*   210 */   964,  933,  936,  887,  937,  950,  890,  949,  953,  955,
 /*   220 */   781,  896,  900,  892,  945,  906,  935,  946,  762,  983,
 /*   230 */   969,  957,  934,  939,  951,  959,  962,  960,  977,  971,
 /*   240 */   994, 1017, 1018,  998, 1020, 1010, 1027, 1016, 1061, 1044,
 /*   250 */  1062, 1030, 1045, 1048, 1073, 1085, 1082, 1102, 1101, 1049,
 /*   260 */  1046, 1088, 1089, 1090, 1096, 1115,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    10 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    20 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    30 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    40 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    50 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    60 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    70 */  1483, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*    80 */  1411, 1411, 1411, 1411, 1411, 1481, 1632, 1411, 1799, 1411,
 /*    90 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   100 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   110 */  1411, 1411, 1411, 1411, 1411, 1483, 1411, 1811, 1811, 1811,
 /*   120 */  1481, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1577, 1411,
 /*   130 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1666, 1411, 1411,
 /*   140 */  1881, 1411, 1411, 1672, 1835, 1411, 1411, 1411, 1411, 1530,
 /*   150 */  1827, 1803, 1817, 1804, 1866, 1866, 1866, 1820, 1411, 1831,
 /*   160 */  1411, 1411, 1411, 1658, 1411, 1411, 1637, 1634, 1634, 1411,
 /*   170 */  1411, 1411, 1411, 1483, 1411, 1483, 1411, 1411, 1483, 1411,
 /*   180 */  1483, 1411, 1483, 1483, 1411, 1483, 1411, 1411, 1411, 1411,
 /*   190 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   200 */  1411, 1411, 1411, 1481, 1668, 1411, 1481, 1411, 1411, 1411,
 /*   210 */  1481, 1411, 1411, 1842, 1840, 1411, 1842, 1840, 1411, 1411,
 /*   220 */  1411, 1854, 1850, 1842, 1858, 1856, 1833, 1831, 1817, 1411,
 /*   230 */  1411, 1801, 1872, 1868, 1884, 1872, 1868, 1872, 1868, 1411,
 /*   240 */  1840, 1411, 1411, 1840, 1411, 1641, 1411, 1411, 1481, 1411,
 /*   250 */  1481, 1411, 1546, 1411, 1411, 1411, 1481, 1443, 1411, 1660,
 /*   260 */  1674, 1580, 1580, 1580, 1484, 1416, 1411, 1411, 1411, 1411,
 /*   270 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1743, 1853, 1852,
 /*   280 */  1775, 1774, 1773, 1771, 1742, 1411, 1411, 1542, 1741, 1740,
 /*   290 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1734, 1735, 1733,
 /*   300 */  1732, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   310 */  1411, 1411, 1411, 1411, 1800, 1411, 1869, 1873, 1411, 1411,
 /*   320 */  1411, 1717, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   330 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   340 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   350 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   360 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   370 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   380 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   390 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   400 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   410 */  1411, 1411, 1411, 1411, 1411, 1411, 1448, 1411, 1411, 1411,
 /*   420 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   430 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   440 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   450 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   460 */  1411, 1411, 1411, 1511, 1510, 1411, 1411, 1411, 1411, 1411,
 /*   470 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   480 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   490 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1824, 1834,
 /*   500 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   510 */  1411, 1411, 1411, 1717, 1411, 1851, 1411, 1810, 1806, 1411,
 /*   520 */  1411, 1802, 1411, 1411, 1867, 1411, 1411, 1411, 1411, 1411,
 /*   530 */  1411, 1411, 1411, 1411, 1795, 1411, 1768, 1411, 1411, 1411,
 /*   540 */  1411, 1411, 1411, 1411, 1411, 1728, 1411, 1411, 1411, 1411,
 /*   550 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1716, 1411,
 /*   560 */  1759, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1574,
 /*   570 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   580 */  1411, 1411, 1559, 1557, 1556, 1555, 1411, 1552, 1411, 1411,
 /*   590 */  1411, 1411, 1583, 1582, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   600 */  1503, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   610 */  1494, 1411, 1493, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   620 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   630 */  1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411, 1411,
 /*   640 */  1411, 1411, 1411, 1411, 1411,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  237,  /*  NK_BITNOT => ID */
  237,  /*     INSERT => ID */
  237,  /*     VALUES => ID */
  237,  /*     IMPORT => ID */
  237,  /*    NK_SEMI => ID */
  237,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "IF",
  /*   59 */ "NOT",
  /*   60 */ "EXISTS",
  /*   61 */ "BUFFER",
  /*   62 */ "CACHELAST",
  /*   63 */ "COMP",
  /*   64 */ "DURATION",
  /*   65 */ "NK_VARIABLE",
  /*   66 */ "FSYNC",
  /*   67 */ "MAXROWS",
  /*   68 */ "MINROWS",
  /*   69 */ "KEEP",
  /*   70 */ "PAGES",
  /*   71 */ "PAGESIZE",
  /*   72 */ "PRECISION",
  /*   73 */ "REPLICA",
  /*   74 */ "STRICT",
  /*   75 */ "WAL",
  /*   76 */ "VGROUPS",
  /*   77 */ "SINGLE_STABLE",
  /*   78 */ "RETENTIONS",
  /*   79 */ "SCHEMALESS",
  /*   80 */ "NK_COLON",
  /*   81 */ "TABLE",
  /*   82 */ "NK_LP",
  /*   83 */ "NK_RP",
  /*   84 */ "STABLE",
  /*   85 */ "ADD",
  /*   86 */ "COLUMN",
  /*   87 */ "MODIFY",
  /*   88 */ "RENAME",
  /*   89 */ "TAG",
  /*   90 */ "SET",
  /*   91 */ "NK_EQ",
  /*   92 */ "USING",
  /*   93 */ "TAGS",
  /*   94 */ "COMMENT",
  /*   95 */ "BOOL",
  /*   96 */ "TINYINT",
  /*   97 */ "SMALLINT",
  /*   98 */ "INT",
  /*   99 */ "INTEGER",
  /*  100 */ "BIGINT",
  /*  101 */ "FLOAT",
  /*  102 */ "DOUBLE",
  /*  103 */ "BINARY",
  /*  104 */ "TIMESTAMP",
  /*  105 */ "NCHAR",
  /*  106 */ "UNSIGNED",
  /*  107 */ "JSON",
  /*  108 */ "VARCHAR",
  /*  109 */ "MEDIUMBLOB",
  /*  110 */ "BLOB",
  /*  111 */ "VARBINARY",
  /*  112 */ "DECIMAL",
  /*  113 */ "MAX_DELAY",
  /*  114 */ "WATERMARK",
  /*  115 */ "ROLLUP",
  /*  116 */ "TTL",
  /*  117 */ "SMA",
  /*  118 */ "FIRST",
  /*  119 */ "LAST",
  /*  120 */ "SHOW",
  /*  121 */ "DATABASES",
  /*  122 */ "TABLES",
  /*  123 */ "STABLES",
  /*  124 */ "MNODES",
  /*  125 */ "MODULES",
  /*  126 */ "QNODES",
  /*  127 */ "FUNCTIONS",
  /*  128 */ "INDEXES",
  /*  129 */ "ACCOUNTS",
  /*  130 */ "APPS",
  /*  131 */ "CONNECTIONS",
  /*  132 */ "LICENCE",
  /*  133 */ "GRANTS",
  /*  134 */ "QUERIES",
  /*  135 */ "SCORES",
  /*  136 */ "TOPICS",
  /*  137 */ "VARIABLES",
  /*  138 */ "BNODES",
  /*  139 */ "SNODES",
  /*  140 */ "CLUSTER",
  /*  141 */ "TRANSACTIONS",
  /*  142 */ "DISTRIBUTED",
  /*  143 */ "LIKE",
  /*  144 */ "INDEX",
  /*  145 */ "FUNCTION",
  /*  146 */ "INTERVAL",
  /*  147 */ "TOPIC",
  /*  148 */ "AS",
  /*  149 */ "WITH",
  /*  150 */ "META",
  /*  151 */ "CONSUMER",
  /*  152 */ "GROUP",
  /*  153 */ "DESC",
  /*  154 */ "DESCRIBE",
  /*  155 */ "RESET",
  /*  156 */ "QUERY",
  /*  157 */ "CACHE",
  /*  158 */ "EXPLAIN",
  /*  159 */ "ANALYZE",
  /*  160 */ "VERBOSE",
  /*  161 */ "NK_BOOL",
  /*  162 */ "RATIO",
  /*  163 */ "NK_FLOAT",
  /*  164 */ "COMPACT",
  /*  165 */ "VNODES",
  /*  166 */ "IN",
  /*  167 */ "OUTPUTTYPE",
  /*  168 */ "AGGREGATE",
  /*  169 */ "BUFSIZE",
  /*  170 */ "STREAM",
  /*  171 */ "INTO",
  /*  172 */ "TRIGGER",
  /*  173 */ "AT_ONCE",
  /*  174 */ "WINDOW_CLOSE",
  /*  175 */ "KILL",
  /*  176 */ "CONNECTION",
  /*  177 */ "TRANSACTION",
  /*  178 */ "BALANCE",
  /*  179 */ "VGROUP",
  /*  180 */ "MERGE",
  /*  181 */ "REDISTRIBUTE",
  /*  182 */ "SPLIT",
  /*  183 */ "SYNCDB",
  /*  184 */ "DELETE",
  /*  185 */ "NULL",
  /*  186 */ "NK_QUESTION",
  /*  187 */ "NK_ARROW",
  /*  188 */ "ROWTS",
  /*  189 */ "TBNAME",
  /*  190 */ "QSTARTTS",
  /*  191 */ "QENDTS",
  /*  192 */ "WSTARTTS",
  /*  193 */ "WENDTS",
  /*  194 */ "WDURATION",
  /*  195 */ "CAST",
  /*  196 */ "NOW",
  /*  197 */ "TODAY",
  /*  198 */ "TIMEZONE",
  /*  199 */ "COUNT",
  /*  200 */ "LAST_ROW",
  /*  201 */ "BETWEEN",
  /*  202 */ "IS",
  /*  203 */ "NK_LT",
  /*  204 */ "NK_GT",
  /*  205 */ "NK_LE",
  /*  206 */ "NK_GE",
  /*  207 */ "NK_NE",
  /*  208 */ "MATCH",
  /*  209 */ "NMATCH",
  /*  210 */ "CONTAINS",
  /*  211 */ "JOIN",
  /*  212 */ "INNER",
  /*  213 */ "SELECT",
  /*  214 */ "DISTINCT",
  /*  215 */ "WHERE",
  /*  216 */ "PARTITION",
  /*  217 */ "BY",
  /*  218 */ "SESSION",
  /*  219 */ "STATE_WINDOW",
  /*  220 */ "SLIDING",
  /*  221 */ "FILL",
  /*  222 */ "VALUE",
  /*  223 */ "NONE",
  /*  224 */ "PREV",
  /*  225 */ "LINEAR",
  /*  226 */ "NEXT",
  /*  227 */ "HAVING",
  /*  228 */ "RANGE",
  /*  229 */ "EVERY",
  /*  230 */ "ORDER",
  /*  231 */ "SLIMIT",
  /*  232 */ "SOFFSET",
  /*  233 */ "LIMIT",
  /*  234 */ "OFFSET",
  /*  235 */ "ASC",
  /*  236 */ "NULLS",
  /*  237 */ "ID",
  /*  238 */ "NK_BITNOT",
  /*  239 */ "INSERT",
  /*  240 */ "VALUES",
  /*  241 */ "IMPORT",
  /*  242 */ "NK_SEMI",
  /*  243 */ "FILE",
  /*  244 */ "cmd",
  /*  245 */ "account_options",
  /*  246 */ "alter_account_options",
  /*  247 */ "literal",
  /*  248 */ "alter_account_option",
  /*  249 */ "user_name",
  /*  250 */ "sysinfo_opt",
  /*  251 */ "privileges",
  /*  252 */ "priv_level",
  /*  253 */ "priv_type_list",
  /*  254 */ "priv_type",
  /*  255 */ "db_name",
  /*  256 */ "dnode_endpoint",
  /*  257 */ "not_exists_opt",
  /*  258 */ "db_options",
  /*  259 */ "exists_opt",
  /*  260 */ "alter_db_options",
  /*  261 */ "integer_list",
  /*  262 */ "variable_list",
  /*  263 */ "retention_list",
  /*  264 */ "alter_db_option",
  /*  265 */ "retention",
  /*  266 */ "full_table_name",
  /*  267 */ "column_def_list",
  /*  268 */ "tags_def_opt",
  /*  269 */ "table_options",
  /*  270 */ "multi_create_clause",
  /*  271 */ "tags_def",
  /*  272 */ "multi_drop_clause",
  /*  273 */ "alter_table_clause",
  /*  274 */ "alter_table_options",
  /*  275 */ "column_name",
  /*  276 */ "type_name",
  /*  277 */ "signed_literal",
  /*  278 */ "create_subtable_clause",
  /*  279 */ "specific_tags_opt",
  /*  280 */ "literal_list",
  /*  281 */ "drop_table_clause",
  /*  282 */ "col_name_list",
  /*  283 */ "table_name",
  /*  284 */ "column_def",
  /*  285 */ "duration_list",
  /*  286 */ "rollup_func_list",
  /*  287 */ "alter_table_option",
  /*  288 */ "duration_literal",
  /*  289 */ "rollup_func_name",
  /*  290 */ "function_name",
  /*  291 */ "col_name",
  /*  292 */ "db_name_cond_opt",
  /*  293 */ "like_pattern_opt",
  /*  294 */ "table_name_cond",
  /*  295 */ "from_db_opt",
  /*  296 */ "index_name",
  /*  297 */ "index_options",
  /*  298 */ "func_list",
  /*  299 */ "sliding_opt",
  /*  300 */ "func",
  /*  301 */ "expression_list",
  /*  302 */ "topic_name",
  /*  303 */ "query_expression",
  /*  304 */ "cgroup_name",
  /*  305 */ "analyze_opt",
  /*  306 */ "explain_options",
  /*  307 */ "agg_func_opt",
  /*  308 */ "bufsize_opt",
  /*  309 */ "stream_name",
  /*  310 */ "stream_options",
  /*  311 */ "into_opt",
  /*  312 */ "dnode_list",
  /*  313 */ "where_clause_opt",
  /*  314 */ "signed",
  /*  315 */ "literal_func",
  /*  316 */ "table_alias",
  /*  317 */ "column_alias",
  /*  318 */ "expression",
  /*  319 */ "pseudo_column",
  /*  320 */ "column_reference",
  /*  321 */ "function_expression",
  /*  322 */ "subquery",
  /*  323 */ "star_func",
  /*  324 */ "star_func_para_list",
  /*  325 */ "noarg_func",
  /*  326 */ "other_para_list",
  /*  327 */ "star_func_para",
  /*  328 */ "predicate",
  /*  329 */ "compare_op",
  /*  330 */ "in_op",
  /*  331 */ "in_predicate_value",
  /*  332 */ "boolean_value_expression",
  /*  333 */ "boolean_primary",
  /*  334 */ "common_expression",
  /*  335 */ "from_clause_opt",
  /*  336 */ "table_reference_list",
  /*  337 */ "table_reference",
  /*  338 */ "table_primary",
  /*  339 */ "joined_table",
  /*  340 */ "alias_opt",
  /*  341 */ "parenthesized_joined_table",
  /*  342 */ "join_type",
  /*  343 */ "search_condition",
  /*  344 */ "query_specification",
  /*  345 */ "set_quantifier_opt",
  /*  346 */ "select_list",
  /*  347 */ "partition_by_clause_opt",
  /*  348 */ "range_opt",
  /*  349 */ "every_opt",
  /*  350 */ "fill_opt",
  /*  351 */ "twindow_clause_opt",
  /*  352 */ "group_by_clause_opt",
  /*  353 */ "having_clause_opt",
  /*  354 */ "select_sublist",
  /*  355 */ "select_item",
  /*  356 */ "fill_mode",
  /*  357 */ "group_by_list",
  /*  358 */ "query_expression_body",
  /*  359 */ "order_by_clause_opt",
  /*  360 */ "slimit_clause_opt",
  /*  361 */ "limit_clause_opt",
  /*  362 */ "query_primary",
  /*  363 */ "sort_specification_list",
  /*  364 */ "sort_specification",
  /*  365 */ "ordering_specification_opt",
  /*  366 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  67 */ "not_exists_opt ::=",
 /*  68 */ "exists_opt ::= IF EXISTS",
 /*  69 */ "exists_opt ::=",
 /*  70 */ "db_options ::=",
 /*  71 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  72 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  73 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  74 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  75 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  76 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  77 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  78 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  79 */ "db_options ::= db_options KEEP integer_list",
 /*  80 */ "db_options ::= db_options KEEP variable_list",
 /*  81 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  82 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  83 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  84 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  85 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  86 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  87 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  88 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  89 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  90 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  91 */ "alter_db_options ::= alter_db_option",
 /*  92 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  93 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  94 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  95 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  96 */ "alter_db_option ::= KEEP integer_list",
 /*  97 */ "alter_db_option ::= KEEP variable_list",
 /*  98 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  99 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 100 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 101 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 102 */ "integer_list ::= NK_INTEGER",
 /* 103 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 104 */ "variable_list ::= NK_VARIABLE",
 /* 105 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 106 */ "retention_list ::= retention",
 /* 107 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 108 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 109 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 110 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 111 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 112 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 113 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 114 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 115 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 116 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 117 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 118 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 119 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 120 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 121 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 122 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 123 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 125 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 126 */ "multi_create_clause ::= create_subtable_clause",
 /* 127 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 128 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 129 */ "multi_drop_clause ::= drop_table_clause",
 /* 130 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 131 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 132 */ "specific_tags_opt ::=",
 /* 133 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 134 */ "full_table_name ::= table_name",
 /* 135 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 136 */ "column_def_list ::= column_def",
 /* 137 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 138 */ "column_def ::= column_name type_name",
 /* 139 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 140 */ "type_name ::= BOOL",
 /* 141 */ "type_name ::= TINYINT",
 /* 142 */ "type_name ::= SMALLINT",
 /* 143 */ "type_name ::= INT",
 /* 144 */ "type_name ::= INTEGER",
 /* 145 */ "type_name ::= BIGINT",
 /* 146 */ "type_name ::= FLOAT",
 /* 147 */ "type_name ::= DOUBLE",
 /* 148 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 149 */ "type_name ::= TIMESTAMP",
 /* 150 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 151 */ "type_name ::= TINYINT UNSIGNED",
 /* 152 */ "type_name ::= SMALLINT UNSIGNED",
 /* 153 */ "type_name ::= INT UNSIGNED",
 /* 154 */ "type_name ::= BIGINT UNSIGNED",
 /* 155 */ "type_name ::= JSON",
 /* 156 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= MEDIUMBLOB",
 /* 158 */ "type_name ::= BLOB",
 /* 159 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= DECIMAL",
 /* 161 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 163 */ "tags_def_opt ::=",
 /* 164 */ "tags_def_opt ::= tags_def",
 /* 165 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 166 */ "table_options ::=",
 /* 167 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 168 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 169 */ "table_options ::= table_options WATERMARK duration_list",
 /* 170 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 171 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 172 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 173 */ "alter_table_options ::= alter_table_option",
 /* 174 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 175 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 176 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 177 */ "duration_list ::= duration_literal",
 /* 178 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 179 */ "rollup_func_list ::= rollup_func_name",
 /* 180 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 181 */ "rollup_func_name ::= function_name",
 /* 182 */ "rollup_func_name ::= FIRST",
 /* 183 */ "rollup_func_name ::= LAST",
 /* 184 */ "col_name_list ::= col_name",
 /* 185 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 186 */ "col_name ::= column_name",
 /* 187 */ "cmd ::= SHOW DNODES",
 /* 188 */ "cmd ::= SHOW USERS",
 /* 189 */ "cmd ::= SHOW DATABASES",
 /* 190 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 193 */ "cmd ::= SHOW MNODES",
 /* 194 */ "cmd ::= SHOW MODULES",
 /* 195 */ "cmd ::= SHOW QNODES",
 /* 196 */ "cmd ::= SHOW FUNCTIONS",
 /* 197 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 198 */ "cmd ::= SHOW STREAMS",
 /* 199 */ "cmd ::= SHOW ACCOUNTS",
 /* 200 */ "cmd ::= SHOW APPS",
 /* 201 */ "cmd ::= SHOW CONNECTIONS",
 /* 202 */ "cmd ::= SHOW LICENCE",
 /* 203 */ "cmd ::= SHOW GRANTS",
 /* 204 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 205 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 206 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 207 */ "cmd ::= SHOW QUERIES",
 /* 208 */ "cmd ::= SHOW SCORES",
 /* 209 */ "cmd ::= SHOW TOPICS",
 /* 210 */ "cmd ::= SHOW VARIABLES",
 /* 211 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 212 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 213 */ "cmd ::= SHOW BNODES",
 /* 214 */ "cmd ::= SHOW SNODES",
 /* 215 */ "cmd ::= SHOW CLUSTER",
 /* 216 */ "cmd ::= SHOW TRANSACTIONS",
 /* 217 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 218 */ "db_name_cond_opt ::=",
 /* 219 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 220 */ "like_pattern_opt ::=",
 /* 221 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 222 */ "table_name_cond ::= table_name",
 /* 223 */ "from_db_opt ::=",
 /* 224 */ "from_db_opt ::= FROM db_name",
 /* 225 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 226 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 227 */ "index_options ::=",
 /* 228 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 229 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 230 */ "func_list ::= func",
 /* 231 */ "func_list ::= func_list NK_COMMA func",
 /* 232 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 233 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 234 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 235 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 236 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 237 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 238 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 239 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 240 */ "cmd ::= DESC full_table_name",
 /* 241 */ "cmd ::= DESCRIBE full_table_name",
 /* 242 */ "cmd ::= RESET QUERY CACHE",
 /* 243 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 244 */ "analyze_opt ::=",
 /* 245 */ "analyze_opt ::= ANALYZE",
 /* 246 */ "explain_options ::=",
 /* 247 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 248 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 249 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 250 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 251 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 252 */ "agg_func_opt ::=",
 /* 253 */ "agg_func_opt ::= AGGREGATE",
 /* 254 */ "bufsize_opt ::=",
 /* 255 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 256 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 257 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 258 */ "into_opt ::=",
 /* 259 */ "into_opt ::= INTO full_table_name",
 /* 260 */ "stream_options ::=",
 /* 261 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 262 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 263 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 264 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 265 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 266 */ "cmd ::= KILL QUERY NK_STRING",
 /* 267 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 268 */ "cmd ::= BALANCE VGROUP",
 /* 269 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 270 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 271 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 272 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 273 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 274 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 275 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 276 */ "cmd ::= query_expression",
 /* 277 */ "literal ::= NK_INTEGER",
 /* 278 */ "literal ::= NK_FLOAT",
 /* 279 */ "literal ::= NK_STRING",
 /* 280 */ "literal ::= NK_BOOL",
 /* 281 */ "literal ::= TIMESTAMP NK_STRING",
 /* 282 */ "literal ::= duration_literal",
 /* 283 */ "literal ::= NULL",
 /* 284 */ "literal ::= NK_QUESTION",
 /* 285 */ "duration_literal ::= NK_VARIABLE",
 /* 286 */ "signed ::= NK_INTEGER",
 /* 287 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 288 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 289 */ "signed ::= NK_FLOAT",
 /* 290 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 291 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 292 */ "signed_literal ::= signed",
 /* 293 */ "signed_literal ::= NK_STRING",
 /* 294 */ "signed_literal ::= NK_BOOL",
 /* 295 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 296 */ "signed_literal ::= duration_literal",
 /* 297 */ "signed_literal ::= NULL",
 /* 298 */ "signed_literal ::= literal_func",
 /* 299 */ "literal_list ::= signed_literal",
 /* 300 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 301 */ "db_name ::= NK_ID",
 /* 302 */ "table_name ::= NK_ID",
 /* 303 */ "column_name ::= NK_ID",
 /* 304 */ "function_name ::= NK_ID",
 /* 305 */ "table_alias ::= NK_ID",
 /* 306 */ "column_alias ::= NK_ID",
 /* 307 */ "user_name ::= NK_ID",
 /* 308 */ "index_name ::= NK_ID",
 /* 309 */ "topic_name ::= NK_ID",
 /* 310 */ "stream_name ::= NK_ID",
 /* 311 */ "cgroup_name ::= NK_ID",
 /* 312 */ "expression ::= literal",
 /* 313 */ "expression ::= pseudo_column",
 /* 314 */ "expression ::= column_reference",
 /* 315 */ "expression ::= function_expression",
 /* 316 */ "expression ::= subquery",
 /* 317 */ "expression ::= NK_LP expression NK_RP",
 /* 318 */ "expression ::= NK_PLUS expression",
 /* 319 */ "expression ::= NK_MINUS expression",
 /* 320 */ "expression ::= expression NK_PLUS expression",
 /* 321 */ "expression ::= expression NK_MINUS expression",
 /* 322 */ "expression ::= expression NK_STAR expression",
 /* 323 */ "expression ::= expression NK_SLASH expression",
 /* 324 */ "expression ::= expression NK_REM expression",
 /* 325 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 326 */ "expression ::= expression NK_BITAND expression",
 /* 327 */ "expression ::= expression NK_BITOR expression",
 /* 328 */ "expression_list ::= expression",
 /* 329 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 330 */ "column_reference ::= column_name",
 /* 331 */ "column_reference ::= table_name NK_DOT column_name",
 /* 332 */ "pseudo_column ::= ROWTS",
 /* 333 */ "pseudo_column ::= TBNAME",
 /* 334 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 335 */ "pseudo_column ::= QSTARTTS",
 /* 336 */ "pseudo_column ::= QENDTS",
 /* 337 */ "pseudo_column ::= WSTARTTS",
 /* 338 */ "pseudo_column ::= WENDTS",
 /* 339 */ "pseudo_column ::= WDURATION",
 /* 340 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 341 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 342 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 343 */ "function_expression ::= literal_func",
 /* 344 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 345 */ "literal_func ::= NOW",
 /* 346 */ "noarg_func ::= NOW",
 /* 347 */ "noarg_func ::= TODAY",
 /* 348 */ "noarg_func ::= TIMEZONE",
 /* 349 */ "star_func ::= COUNT",
 /* 350 */ "star_func ::= FIRST",
 /* 351 */ "star_func ::= LAST",
 /* 352 */ "star_func ::= LAST_ROW",
 /* 353 */ "star_func_para_list ::= NK_STAR",
 /* 354 */ "star_func_para_list ::= other_para_list",
 /* 355 */ "other_para_list ::= star_func_para",
 /* 356 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 357 */ "star_func_para ::= expression",
 /* 358 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 359 */ "predicate ::= expression compare_op expression",
 /* 360 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 361 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 362 */ "predicate ::= expression IS NULL",
 /* 363 */ "predicate ::= expression IS NOT NULL",
 /* 364 */ "predicate ::= expression in_op in_predicate_value",
 /* 365 */ "compare_op ::= NK_LT",
 /* 366 */ "compare_op ::= NK_GT",
 /* 367 */ "compare_op ::= NK_LE",
 /* 368 */ "compare_op ::= NK_GE",
 /* 369 */ "compare_op ::= NK_NE",
 /* 370 */ "compare_op ::= NK_EQ",
 /* 371 */ "compare_op ::= LIKE",
 /* 372 */ "compare_op ::= NOT LIKE",
 /* 373 */ "compare_op ::= MATCH",
 /* 374 */ "compare_op ::= NMATCH",
 /* 375 */ "compare_op ::= CONTAINS",
 /* 376 */ "in_op ::= IN",
 /* 377 */ "in_op ::= NOT IN",
 /* 378 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 379 */ "boolean_value_expression ::= boolean_primary",
 /* 380 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 381 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 382 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 383 */ "boolean_primary ::= predicate",
 /* 384 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 385 */ "common_expression ::= expression",
 /* 386 */ "common_expression ::= boolean_value_expression",
 /* 387 */ "from_clause_opt ::=",
 /* 388 */ "from_clause_opt ::= FROM table_reference_list",
 /* 389 */ "table_reference_list ::= table_reference",
 /* 390 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 391 */ "table_reference ::= table_primary",
 /* 392 */ "table_reference ::= joined_table",
 /* 393 */ "table_primary ::= table_name alias_opt",
 /* 394 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 395 */ "table_primary ::= subquery alias_opt",
 /* 396 */ "table_primary ::= parenthesized_joined_table",
 /* 397 */ "alias_opt ::=",
 /* 398 */ "alias_opt ::= table_alias",
 /* 399 */ "alias_opt ::= AS table_alias",
 /* 400 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 401 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 402 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 403 */ "join_type ::=",
 /* 404 */ "join_type ::= INNER",
 /* 405 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 406 */ "set_quantifier_opt ::=",
 /* 407 */ "set_quantifier_opt ::= DISTINCT",
 /* 408 */ "set_quantifier_opt ::= ALL",
 /* 409 */ "select_list ::= NK_STAR",
 /* 410 */ "select_list ::= select_sublist",
 /* 411 */ "select_sublist ::= select_item",
 /* 412 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 413 */ "select_item ::= common_expression",
 /* 414 */ "select_item ::= common_expression column_alias",
 /* 415 */ "select_item ::= common_expression AS column_alias",
 /* 416 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 417 */ "where_clause_opt ::=",
 /* 418 */ "where_clause_opt ::= WHERE search_condition",
 /* 419 */ "partition_by_clause_opt ::=",
 /* 420 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 421 */ "twindow_clause_opt ::=",
 /* 422 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 423 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 424 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 425 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 426 */ "sliding_opt ::=",
 /* 427 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 428 */ "fill_opt ::=",
 /* 429 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 430 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 431 */ "fill_mode ::= NONE",
 /* 432 */ "fill_mode ::= PREV",
 /* 433 */ "fill_mode ::= NULL",
 /* 434 */ "fill_mode ::= LINEAR",
 /* 435 */ "fill_mode ::= NEXT",
 /* 436 */ "group_by_clause_opt ::=",
 /* 437 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 438 */ "group_by_list ::= expression",
 /* 439 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 440 */ "having_clause_opt ::=",
 /* 441 */ "having_clause_opt ::= HAVING search_condition",
 /* 442 */ "range_opt ::=",
 /* 443 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 444 */ "every_opt ::=",
 /* 445 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 446 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 447 */ "query_expression_body ::= query_primary",
 /* 448 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 449 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 450 */ "query_primary ::= query_specification",
 /* 451 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 452 */ "order_by_clause_opt ::=",
 /* 453 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 454 */ "slimit_clause_opt ::=",
 /* 455 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 456 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 457 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 458 */ "limit_clause_opt ::=",
 /* 459 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 460 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 461 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 462 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 463 */ "search_condition ::= common_expression",
 /* 464 */ "sort_specification_list ::= sort_specification",
 /* 465 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 466 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 467 */ "ordering_specification_opt ::=",
 /* 468 */ "ordering_specification_opt ::= ASC",
 /* 469 */ "ordering_specification_opt ::= DESC",
 /* 470 */ "null_ordering_opt ::=",
 /* 471 */ "null_ordering_opt ::= NULLS FIRST",
 /* 472 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 244: /* cmd */
    case 247: /* literal */
    case 258: /* db_options */
    case 260: /* alter_db_options */
    case 265: /* retention */
    case 266: /* full_table_name */
    case 269: /* table_options */
    case 273: /* alter_table_clause */
    case 274: /* alter_table_options */
    case 277: /* signed_literal */
    case 278: /* create_subtable_clause */
    case 281: /* drop_table_clause */
    case 284: /* column_def */
    case 288: /* duration_literal */
    case 289: /* rollup_func_name */
    case 291: /* col_name */
    case 292: /* db_name_cond_opt */
    case 293: /* like_pattern_opt */
    case 294: /* table_name_cond */
    case 295: /* from_db_opt */
    case 297: /* index_options */
    case 299: /* sliding_opt */
    case 300: /* func */
    case 303: /* query_expression */
    case 306: /* explain_options */
    case 310: /* stream_options */
    case 311: /* into_opt */
    case 313: /* where_clause_opt */
    case 314: /* signed */
    case 315: /* literal_func */
    case 318: /* expression */
    case 319: /* pseudo_column */
    case 320: /* column_reference */
    case 321: /* function_expression */
    case 322: /* subquery */
    case 327: /* star_func_para */
    case 328: /* predicate */
    case 331: /* in_predicate_value */
    case 332: /* boolean_value_expression */
    case 333: /* boolean_primary */
    case 334: /* common_expression */
    case 335: /* from_clause_opt */
    case 336: /* table_reference_list */
    case 337: /* table_reference */
    case 338: /* table_primary */
    case 339: /* joined_table */
    case 341: /* parenthesized_joined_table */
    case 343: /* search_condition */
    case 344: /* query_specification */
    case 348: /* range_opt */
    case 349: /* every_opt */
    case 350: /* fill_opt */
    case 351: /* twindow_clause_opt */
    case 353: /* having_clause_opt */
    case 355: /* select_item */
    case 358: /* query_expression_body */
    case 360: /* slimit_clause_opt */
    case 361: /* limit_clause_opt */
    case 362: /* query_primary */
    case 364: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy442)); 
}
      break;
    case 245: /* account_options */
    case 246: /* alter_account_options */
    case 248: /* alter_account_option */
    case 308: /* bufsize_opt */
{
 
}
      break;
    case 249: /* user_name */
    case 252: /* priv_level */
    case 255: /* db_name */
    case 256: /* dnode_endpoint */
    case 275: /* column_name */
    case 283: /* table_name */
    case 290: /* function_name */
    case 296: /* index_name */
    case 302: /* topic_name */
    case 304: /* cgroup_name */
    case 309: /* stream_name */
    case 316: /* table_alias */
    case 317: /* column_alias */
    case 323: /* star_func */
    case 325: /* noarg_func */
    case 340: /* alias_opt */
{
 
}
      break;
    case 250: /* sysinfo_opt */
{
 
}
      break;
    case 251: /* privileges */
    case 253: /* priv_type_list */
    case 254: /* priv_type */
{
 
}
      break;
    case 257: /* not_exists_opt */
    case 259: /* exists_opt */
    case 305: /* analyze_opt */
    case 307: /* agg_func_opt */
    case 345: /* set_quantifier_opt */
{
 
}
      break;
    case 261: /* integer_list */
    case 262: /* variable_list */
    case 263: /* retention_list */
    case 267: /* column_def_list */
    case 268: /* tags_def_opt */
    case 270: /* multi_create_clause */
    case 271: /* tags_def */
    case 272: /* multi_drop_clause */
    case 279: /* specific_tags_opt */
    case 280: /* literal_list */
    case 282: /* col_name_list */
    case 285: /* duration_list */
    case 286: /* rollup_func_list */
    case 298: /* func_list */
    case 301: /* expression_list */
    case 312: /* dnode_list */
    case 324: /* star_func_para_list */
    case 326: /* other_para_list */
    case 346: /* select_list */
    case 347: /* partition_by_clause_opt */
    case 352: /* group_by_clause_opt */
    case 354: /* select_sublist */
    case 357: /* group_by_list */
    case 359: /* order_by_clause_opt */
    case 363: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy368)); 
}
      break;
    case 264: /* alter_db_option */
    case 287: /* alter_table_option */
{
 
}
      break;
    case 276: /* type_name */
{
 
}
      break;
    case 329: /* compare_op */
    case 330: /* in_op */
{
 
}
      break;
    case 342: /* join_type */
{
 
}
      break;
    case 356: /* fill_mode */
{
 
}
      break;
    case 365: /* ordering_specification_opt */
{
 
}
      break;
    case 366: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  244,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  244,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  245,    0 }, /* (2) account_options ::= */
  {  245,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  245,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  245,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  245,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  245,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  245,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  245,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  245,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  245,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  246,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  246,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  248,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  248,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  248,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  248,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  248,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  248,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  248,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  248,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  248,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  248,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  244,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  244,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  244,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  244,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  244,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  250,    0 }, /* (29) sysinfo_opt ::= */
  {  250,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  244,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  244,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  251,   -1 }, /* (33) privileges ::= ALL */
  {  251,   -1 }, /* (34) privileges ::= priv_type_list */
  {  253,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  253,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  254,   -1 }, /* (37) priv_type ::= READ */
  {  254,   -1 }, /* (38) priv_type ::= WRITE */
  {  252,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  252,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  244,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  244,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  244,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  244,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  244,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  244,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  244,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  244,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  256,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  256,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  256,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  244,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  244,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  244,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  244,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  244,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  244,   -2 }, /* (64) cmd ::= USE db_name */
  {  244,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  257,   -3 }, /* (66) not_exists_opt ::= IF NOT EXISTS */
  {  257,    0 }, /* (67) not_exists_opt ::= */
  {  259,   -2 }, /* (68) exists_opt ::= IF EXISTS */
  {  259,    0 }, /* (69) exists_opt ::= */
  {  258,    0 }, /* (70) db_options ::= */
  {  258,   -3 }, /* (71) db_options ::= db_options BUFFER NK_INTEGER */
  {  258,   -3 }, /* (72) db_options ::= db_options CACHELAST NK_INTEGER */
  {  258,   -3 }, /* (73) db_options ::= db_options COMP NK_INTEGER */
  {  258,   -3 }, /* (74) db_options ::= db_options DURATION NK_INTEGER */
  {  258,   -3 }, /* (75) db_options ::= db_options DURATION NK_VARIABLE */
  {  258,   -3 }, /* (76) db_options ::= db_options FSYNC NK_INTEGER */
  {  258,   -3 }, /* (77) db_options ::= db_options MAXROWS NK_INTEGER */
  {  258,   -3 }, /* (78) db_options ::= db_options MINROWS NK_INTEGER */
  {  258,   -3 }, /* (79) db_options ::= db_options KEEP integer_list */
  {  258,   -3 }, /* (80) db_options ::= db_options KEEP variable_list */
  {  258,   -3 }, /* (81) db_options ::= db_options PAGES NK_INTEGER */
  {  258,   -3 }, /* (82) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  258,   -3 }, /* (83) db_options ::= db_options PRECISION NK_STRING */
  {  258,   -3 }, /* (84) db_options ::= db_options REPLICA NK_INTEGER */
  {  258,   -3 }, /* (85) db_options ::= db_options STRICT NK_INTEGER */
  {  258,   -3 }, /* (86) db_options ::= db_options WAL NK_INTEGER */
  {  258,   -3 }, /* (87) db_options ::= db_options VGROUPS NK_INTEGER */
  {  258,   -3 }, /* (88) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  258,   -3 }, /* (89) db_options ::= db_options RETENTIONS retention_list */
  {  258,   -3 }, /* (90) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  260,   -1 }, /* (91) alter_db_options ::= alter_db_option */
  {  260,   -2 }, /* (92) alter_db_options ::= alter_db_options alter_db_option */
  {  264,   -2 }, /* (93) alter_db_option ::= BUFFER NK_INTEGER */
  {  264,   -2 }, /* (94) alter_db_option ::= CACHELAST NK_INTEGER */
  {  264,   -2 }, /* (95) alter_db_option ::= FSYNC NK_INTEGER */
  {  264,   -2 }, /* (96) alter_db_option ::= KEEP integer_list */
  {  264,   -2 }, /* (97) alter_db_option ::= KEEP variable_list */
  {  264,   -2 }, /* (98) alter_db_option ::= PAGES NK_INTEGER */
  {  264,   -2 }, /* (99) alter_db_option ::= REPLICA NK_INTEGER */
  {  264,   -2 }, /* (100) alter_db_option ::= STRICT NK_INTEGER */
  {  264,   -2 }, /* (101) alter_db_option ::= WAL NK_INTEGER */
  {  261,   -1 }, /* (102) integer_list ::= NK_INTEGER */
  {  261,   -3 }, /* (103) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  262,   -1 }, /* (104) variable_list ::= NK_VARIABLE */
  {  262,   -3 }, /* (105) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  263,   -1 }, /* (106) retention_list ::= retention */
  {  263,   -3 }, /* (107) retention_list ::= retention_list NK_COMMA retention */
  {  265,   -3 }, /* (108) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  244,   -9 }, /* (109) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  244,   -3 }, /* (110) cmd ::= CREATE TABLE multi_create_clause */
  {  244,   -9 }, /* (111) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  244,   -3 }, /* (112) cmd ::= DROP TABLE multi_drop_clause */
  {  244,   -4 }, /* (113) cmd ::= DROP STABLE exists_opt full_table_name */
  {  244,   -3 }, /* (114) cmd ::= ALTER TABLE alter_table_clause */
  {  244,   -3 }, /* (115) cmd ::= ALTER STABLE alter_table_clause */
  {  273,   -2 }, /* (116) alter_table_clause ::= full_table_name alter_table_options */
  {  273,   -5 }, /* (117) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  273,   -4 }, /* (118) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  273,   -5 }, /* (119) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  273,   -5 }, /* (120) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  273,   -5 }, /* (121) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  273,   -4 }, /* (122) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  273,   -5 }, /* (123) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  273,   -5 }, /* (124) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  273,   -6 }, /* (125) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  270,   -1 }, /* (126) multi_create_clause ::= create_subtable_clause */
  {  270,   -2 }, /* (127) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  278,  -10 }, /* (128) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  272,   -1 }, /* (129) multi_drop_clause ::= drop_table_clause */
  {  272,   -2 }, /* (130) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  281,   -2 }, /* (131) drop_table_clause ::= exists_opt full_table_name */
  {  279,    0 }, /* (132) specific_tags_opt ::= */
  {  279,   -3 }, /* (133) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  266,   -1 }, /* (134) full_table_name ::= table_name */
  {  266,   -3 }, /* (135) full_table_name ::= db_name NK_DOT table_name */
  {  267,   -1 }, /* (136) column_def_list ::= column_def */
  {  267,   -3 }, /* (137) column_def_list ::= column_def_list NK_COMMA column_def */
  {  284,   -2 }, /* (138) column_def ::= column_name type_name */
  {  284,   -4 }, /* (139) column_def ::= column_name type_name COMMENT NK_STRING */
  {  276,   -1 }, /* (140) type_name ::= BOOL */
  {  276,   -1 }, /* (141) type_name ::= TINYINT */
  {  276,   -1 }, /* (142) type_name ::= SMALLINT */
  {  276,   -1 }, /* (143) type_name ::= INT */
  {  276,   -1 }, /* (144) type_name ::= INTEGER */
  {  276,   -1 }, /* (145) type_name ::= BIGINT */
  {  276,   -1 }, /* (146) type_name ::= FLOAT */
  {  276,   -1 }, /* (147) type_name ::= DOUBLE */
  {  276,   -4 }, /* (148) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  276,   -1 }, /* (149) type_name ::= TIMESTAMP */
  {  276,   -4 }, /* (150) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  276,   -2 }, /* (151) type_name ::= TINYINT UNSIGNED */
  {  276,   -2 }, /* (152) type_name ::= SMALLINT UNSIGNED */
  {  276,   -2 }, /* (153) type_name ::= INT UNSIGNED */
  {  276,   -2 }, /* (154) type_name ::= BIGINT UNSIGNED */
  {  276,   -1 }, /* (155) type_name ::= JSON */
  {  276,   -4 }, /* (156) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  276,   -1 }, /* (157) type_name ::= MEDIUMBLOB */
  {  276,   -1 }, /* (158) type_name ::= BLOB */
  {  276,   -4 }, /* (159) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  276,   -1 }, /* (160) type_name ::= DECIMAL */
  {  276,   -4 }, /* (161) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  276,   -6 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  268,    0 }, /* (163) tags_def_opt ::= */
  {  268,   -1 }, /* (164) tags_def_opt ::= tags_def */
  {  271,   -4 }, /* (165) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  269,    0 }, /* (166) table_options ::= */
  {  269,   -3 }, /* (167) table_options ::= table_options COMMENT NK_STRING */
  {  269,   -3 }, /* (168) table_options ::= table_options MAX_DELAY duration_list */
  {  269,   -3 }, /* (169) table_options ::= table_options WATERMARK duration_list */
  {  269,   -5 }, /* (170) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  269,   -3 }, /* (171) table_options ::= table_options TTL NK_INTEGER */
  {  269,   -5 }, /* (172) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  274,   -1 }, /* (173) alter_table_options ::= alter_table_option */
  {  274,   -2 }, /* (174) alter_table_options ::= alter_table_options alter_table_option */
  {  287,   -2 }, /* (175) alter_table_option ::= COMMENT NK_STRING */
  {  287,   -2 }, /* (176) alter_table_option ::= TTL NK_INTEGER */
  {  285,   -1 }, /* (177) duration_list ::= duration_literal */
  {  285,   -3 }, /* (178) duration_list ::= duration_list NK_COMMA duration_literal */
  {  286,   -1 }, /* (179) rollup_func_list ::= rollup_func_name */
  {  286,   -3 }, /* (180) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  289,   -1 }, /* (181) rollup_func_name ::= function_name */
  {  289,   -1 }, /* (182) rollup_func_name ::= FIRST */
  {  289,   -1 }, /* (183) rollup_func_name ::= LAST */
  {  282,   -1 }, /* (184) col_name_list ::= col_name */
  {  282,   -3 }, /* (185) col_name_list ::= col_name_list NK_COMMA col_name */
  {  291,   -1 }, /* (186) col_name ::= column_name */
  {  244,   -2 }, /* (187) cmd ::= SHOW DNODES */
  {  244,   -2 }, /* (188) cmd ::= SHOW USERS */
  {  244,   -2 }, /* (189) cmd ::= SHOW DATABASES */
  {  244,   -4 }, /* (190) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  244,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  244,   -3 }, /* (192) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  244,   -2 }, /* (193) cmd ::= SHOW MNODES */
  {  244,   -2 }, /* (194) cmd ::= SHOW MODULES */
  {  244,   -2 }, /* (195) cmd ::= SHOW QNODES */
  {  244,   -2 }, /* (196) cmd ::= SHOW FUNCTIONS */
  {  244,   -5 }, /* (197) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  244,   -2 }, /* (198) cmd ::= SHOW STREAMS */
  {  244,   -2 }, /* (199) cmd ::= SHOW ACCOUNTS */
  {  244,   -2 }, /* (200) cmd ::= SHOW APPS */
  {  244,   -2 }, /* (201) cmd ::= SHOW CONNECTIONS */
  {  244,   -2 }, /* (202) cmd ::= SHOW LICENCE */
  {  244,   -2 }, /* (203) cmd ::= SHOW GRANTS */
  {  244,   -4 }, /* (204) cmd ::= SHOW CREATE DATABASE db_name */
  {  244,   -4 }, /* (205) cmd ::= SHOW CREATE TABLE full_table_name */
  {  244,   -4 }, /* (206) cmd ::= SHOW CREATE STABLE full_table_name */
  {  244,   -2 }, /* (207) cmd ::= SHOW QUERIES */
  {  244,   -2 }, /* (208) cmd ::= SHOW SCORES */
  {  244,   -2 }, /* (209) cmd ::= SHOW TOPICS */
  {  244,   -2 }, /* (210) cmd ::= SHOW VARIABLES */
  {  244,   -3 }, /* (211) cmd ::= SHOW LOCAL VARIABLES */
  {  244,   -4 }, /* (212) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  244,   -2 }, /* (213) cmd ::= SHOW BNODES */
  {  244,   -2 }, /* (214) cmd ::= SHOW SNODES */
  {  244,   -2 }, /* (215) cmd ::= SHOW CLUSTER */
  {  244,   -2 }, /* (216) cmd ::= SHOW TRANSACTIONS */
  {  244,   -4 }, /* (217) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  292,    0 }, /* (218) db_name_cond_opt ::= */
  {  292,   -2 }, /* (219) db_name_cond_opt ::= db_name NK_DOT */
  {  293,    0 }, /* (220) like_pattern_opt ::= */
  {  293,   -2 }, /* (221) like_pattern_opt ::= LIKE NK_STRING */
  {  294,   -1 }, /* (222) table_name_cond ::= table_name */
  {  295,    0 }, /* (223) from_db_opt ::= */
  {  295,   -2 }, /* (224) from_db_opt ::= FROM db_name */
  {  244,   -8 }, /* (225) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  244,   -4 }, /* (226) cmd ::= DROP INDEX exists_opt index_name */
  {  297,    0 }, /* (227) index_options ::= */
  {  297,   -9 }, /* (228) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  297,  -11 }, /* (229) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  298,   -1 }, /* (230) func_list ::= func */
  {  298,   -3 }, /* (231) func_list ::= func_list NK_COMMA func */
  {  300,   -4 }, /* (232) func ::= function_name NK_LP expression_list NK_RP */
  {  244,   -6 }, /* (233) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  244,   -7 }, /* (234) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  244,   -9 }, /* (235) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  244,   -7 }, /* (236) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  244,   -9 }, /* (237) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  244,   -4 }, /* (238) cmd ::= DROP TOPIC exists_opt topic_name */
  {  244,   -7 }, /* (239) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  244,   -2 }, /* (240) cmd ::= DESC full_table_name */
  {  244,   -2 }, /* (241) cmd ::= DESCRIBE full_table_name */
  {  244,   -3 }, /* (242) cmd ::= RESET QUERY CACHE */
  {  244,   -4 }, /* (243) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  305,    0 }, /* (244) analyze_opt ::= */
  {  305,   -1 }, /* (245) analyze_opt ::= ANALYZE */
  {  306,    0 }, /* (246) explain_options ::= */
  {  306,   -3 }, /* (247) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  306,   -3 }, /* (248) explain_options ::= explain_options RATIO NK_FLOAT */
  {  244,   -6 }, /* (249) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  244,  -10 }, /* (250) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  244,   -4 }, /* (251) cmd ::= DROP FUNCTION exists_opt function_name */
  {  307,    0 }, /* (252) agg_func_opt ::= */
  {  307,   -1 }, /* (253) agg_func_opt ::= AGGREGATE */
  {  308,    0 }, /* (254) bufsize_opt ::= */
  {  308,   -2 }, /* (255) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  244,   -8 }, /* (256) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  244,   -4 }, /* (257) cmd ::= DROP STREAM exists_opt stream_name */
  {  311,    0 }, /* (258) into_opt ::= */
  {  311,   -2 }, /* (259) into_opt ::= INTO full_table_name */
  {  310,    0 }, /* (260) stream_options ::= */
  {  310,   -3 }, /* (261) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  310,   -3 }, /* (262) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  310,   -4 }, /* (263) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  310,   -3 }, /* (264) stream_options ::= stream_options WATERMARK duration_literal */
  {  244,   -3 }, /* (265) cmd ::= KILL CONNECTION NK_INTEGER */
  {  244,   -3 }, /* (266) cmd ::= KILL QUERY NK_STRING */
  {  244,   -3 }, /* (267) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  244,   -2 }, /* (268) cmd ::= BALANCE VGROUP */
  {  244,   -4 }, /* (269) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  244,   -4 }, /* (270) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  244,   -3 }, /* (271) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  312,   -2 }, /* (272) dnode_list ::= DNODE NK_INTEGER */
  {  312,   -3 }, /* (273) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  244,   -3 }, /* (274) cmd ::= SYNCDB db_name REPLICA */
  {  244,   -4 }, /* (275) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  244,   -1 }, /* (276) cmd ::= query_expression */
  {  247,   -1 }, /* (277) literal ::= NK_INTEGER */
  {  247,   -1 }, /* (278) literal ::= NK_FLOAT */
  {  247,   -1 }, /* (279) literal ::= NK_STRING */
  {  247,   -1 }, /* (280) literal ::= NK_BOOL */
  {  247,   -2 }, /* (281) literal ::= TIMESTAMP NK_STRING */
  {  247,   -1 }, /* (282) literal ::= duration_literal */
  {  247,   -1 }, /* (283) literal ::= NULL */
  {  247,   -1 }, /* (284) literal ::= NK_QUESTION */
  {  288,   -1 }, /* (285) duration_literal ::= NK_VARIABLE */
  {  314,   -1 }, /* (286) signed ::= NK_INTEGER */
  {  314,   -2 }, /* (287) signed ::= NK_PLUS NK_INTEGER */
  {  314,   -2 }, /* (288) signed ::= NK_MINUS NK_INTEGER */
  {  314,   -1 }, /* (289) signed ::= NK_FLOAT */
  {  314,   -2 }, /* (290) signed ::= NK_PLUS NK_FLOAT */
  {  314,   -2 }, /* (291) signed ::= NK_MINUS NK_FLOAT */
  {  277,   -1 }, /* (292) signed_literal ::= signed */
  {  277,   -1 }, /* (293) signed_literal ::= NK_STRING */
  {  277,   -1 }, /* (294) signed_literal ::= NK_BOOL */
  {  277,   -2 }, /* (295) signed_literal ::= TIMESTAMP NK_STRING */
  {  277,   -1 }, /* (296) signed_literal ::= duration_literal */
  {  277,   -1 }, /* (297) signed_literal ::= NULL */
  {  277,   -1 }, /* (298) signed_literal ::= literal_func */
  {  280,   -1 }, /* (299) literal_list ::= signed_literal */
  {  280,   -3 }, /* (300) literal_list ::= literal_list NK_COMMA signed_literal */
  {  255,   -1 }, /* (301) db_name ::= NK_ID */
  {  283,   -1 }, /* (302) table_name ::= NK_ID */
  {  275,   -1 }, /* (303) column_name ::= NK_ID */
  {  290,   -1 }, /* (304) function_name ::= NK_ID */
  {  316,   -1 }, /* (305) table_alias ::= NK_ID */
  {  317,   -1 }, /* (306) column_alias ::= NK_ID */
  {  249,   -1 }, /* (307) user_name ::= NK_ID */
  {  296,   -1 }, /* (308) index_name ::= NK_ID */
  {  302,   -1 }, /* (309) topic_name ::= NK_ID */
  {  309,   -1 }, /* (310) stream_name ::= NK_ID */
  {  304,   -1 }, /* (311) cgroup_name ::= NK_ID */
  {  318,   -1 }, /* (312) expression ::= literal */
  {  318,   -1 }, /* (313) expression ::= pseudo_column */
  {  318,   -1 }, /* (314) expression ::= column_reference */
  {  318,   -1 }, /* (315) expression ::= function_expression */
  {  318,   -1 }, /* (316) expression ::= subquery */
  {  318,   -3 }, /* (317) expression ::= NK_LP expression NK_RP */
  {  318,   -2 }, /* (318) expression ::= NK_PLUS expression */
  {  318,   -2 }, /* (319) expression ::= NK_MINUS expression */
  {  318,   -3 }, /* (320) expression ::= expression NK_PLUS expression */
  {  318,   -3 }, /* (321) expression ::= expression NK_MINUS expression */
  {  318,   -3 }, /* (322) expression ::= expression NK_STAR expression */
  {  318,   -3 }, /* (323) expression ::= expression NK_SLASH expression */
  {  318,   -3 }, /* (324) expression ::= expression NK_REM expression */
  {  318,   -3 }, /* (325) expression ::= column_reference NK_ARROW NK_STRING */
  {  318,   -3 }, /* (326) expression ::= expression NK_BITAND expression */
  {  318,   -3 }, /* (327) expression ::= expression NK_BITOR expression */
  {  301,   -1 }, /* (328) expression_list ::= expression */
  {  301,   -3 }, /* (329) expression_list ::= expression_list NK_COMMA expression */
  {  320,   -1 }, /* (330) column_reference ::= column_name */
  {  320,   -3 }, /* (331) column_reference ::= table_name NK_DOT column_name */
  {  319,   -1 }, /* (332) pseudo_column ::= ROWTS */
  {  319,   -1 }, /* (333) pseudo_column ::= TBNAME */
  {  319,   -3 }, /* (334) pseudo_column ::= table_name NK_DOT TBNAME */
  {  319,   -1 }, /* (335) pseudo_column ::= QSTARTTS */
  {  319,   -1 }, /* (336) pseudo_column ::= QENDTS */
  {  319,   -1 }, /* (337) pseudo_column ::= WSTARTTS */
  {  319,   -1 }, /* (338) pseudo_column ::= WENDTS */
  {  319,   -1 }, /* (339) pseudo_column ::= WDURATION */
  {  321,   -4 }, /* (340) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  321,   -4 }, /* (341) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  321,   -6 }, /* (342) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  321,   -1 }, /* (343) function_expression ::= literal_func */
  {  315,   -3 }, /* (344) literal_func ::= noarg_func NK_LP NK_RP */
  {  315,   -1 }, /* (345) literal_func ::= NOW */
  {  325,   -1 }, /* (346) noarg_func ::= NOW */
  {  325,   -1 }, /* (347) noarg_func ::= TODAY */
  {  325,   -1 }, /* (348) noarg_func ::= TIMEZONE */
  {  323,   -1 }, /* (349) star_func ::= COUNT */
  {  323,   -1 }, /* (350) star_func ::= FIRST */
  {  323,   -1 }, /* (351) star_func ::= LAST */
  {  323,   -1 }, /* (352) star_func ::= LAST_ROW */
  {  324,   -1 }, /* (353) star_func_para_list ::= NK_STAR */
  {  324,   -1 }, /* (354) star_func_para_list ::= other_para_list */
  {  326,   -1 }, /* (355) other_para_list ::= star_func_para */
  {  326,   -3 }, /* (356) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  327,   -1 }, /* (357) star_func_para ::= expression */
  {  327,   -3 }, /* (358) star_func_para ::= table_name NK_DOT NK_STAR */
  {  328,   -3 }, /* (359) predicate ::= expression compare_op expression */
  {  328,   -5 }, /* (360) predicate ::= expression BETWEEN expression AND expression */
  {  328,   -6 }, /* (361) predicate ::= expression NOT BETWEEN expression AND expression */
  {  328,   -3 }, /* (362) predicate ::= expression IS NULL */
  {  328,   -4 }, /* (363) predicate ::= expression IS NOT NULL */
  {  328,   -3 }, /* (364) predicate ::= expression in_op in_predicate_value */
  {  329,   -1 }, /* (365) compare_op ::= NK_LT */
  {  329,   -1 }, /* (366) compare_op ::= NK_GT */
  {  329,   -1 }, /* (367) compare_op ::= NK_LE */
  {  329,   -1 }, /* (368) compare_op ::= NK_GE */
  {  329,   -1 }, /* (369) compare_op ::= NK_NE */
  {  329,   -1 }, /* (370) compare_op ::= NK_EQ */
  {  329,   -1 }, /* (371) compare_op ::= LIKE */
  {  329,   -2 }, /* (372) compare_op ::= NOT LIKE */
  {  329,   -1 }, /* (373) compare_op ::= MATCH */
  {  329,   -1 }, /* (374) compare_op ::= NMATCH */
  {  329,   -1 }, /* (375) compare_op ::= CONTAINS */
  {  330,   -1 }, /* (376) in_op ::= IN */
  {  330,   -2 }, /* (377) in_op ::= NOT IN */
  {  331,   -3 }, /* (378) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  332,   -1 }, /* (379) boolean_value_expression ::= boolean_primary */
  {  332,   -2 }, /* (380) boolean_value_expression ::= NOT boolean_primary */
  {  332,   -3 }, /* (381) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  332,   -3 }, /* (382) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  333,   -1 }, /* (383) boolean_primary ::= predicate */
  {  333,   -3 }, /* (384) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  334,   -1 }, /* (385) common_expression ::= expression */
  {  334,   -1 }, /* (386) common_expression ::= boolean_value_expression */
  {  335,    0 }, /* (387) from_clause_opt ::= */
  {  335,   -2 }, /* (388) from_clause_opt ::= FROM table_reference_list */
  {  336,   -1 }, /* (389) table_reference_list ::= table_reference */
  {  336,   -3 }, /* (390) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  337,   -1 }, /* (391) table_reference ::= table_primary */
  {  337,   -1 }, /* (392) table_reference ::= joined_table */
  {  338,   -2 }, /* (393) table_primary ::= table_name alias_opt */
  {  338,   -4 }, /* (394) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  338,   -2 }, /* (395) table_primary ::= subquery alias_opt */
  {  338,   -1 }, /* (396) table_primary ::= parenthesized_joined_table */
  {  340,    0 }, /* (397) alias_opt ::= */
  {  340,   -1 }, /* (398) alias_opt ::= table_alias */
  {  340,   -2 }, /* (399) alias_opt ::= AS table_alias */
  {  341,   -3 }, /* (400) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  341,   -3 }, /* (401) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  339,   -6 }, /* (402) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  342,    0 }, /* (403) join_type ::= */
  {  342,   -1 }, /* (404) join_type ::= INNER */
  {  344,  -12 }, /* (405) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  345,    0 }, /* (406) set_quantifier_opt ::= */
  {  345,   -1 }, /* (407) set_quantifier_opt ::= DISTINCT */
  {  345,   -1 }, /* (408) set_quantifier_opt ::= ALL */
  {  346,   -1 }, /* (409) select_list ::= NK_STAR */
  {  346,   -1 }, /* (410) select_list ::= select_sublist */
  {  354,   -1 }, /* (411) select_sublist ::= select_item */
  {  354,   -3 }, /* (412) select_sublist ::= select_sublist NK_COMMA select_item */
  {  355,   -1 }, /* (413) select_item ::= common_expression */
  {  355,   -2 }, /* (414) select_item ::= common_expression column_alias */
  {  355,   -3 }, /* (415) select_item ::= common_expression AS column_alias */
  {  355,   -3 }, /* (416) select_item ::= table_name NK_DOT NK_STAR */
  {  313,    0 }, /* (417) where_clause_opt ::= */
  {  313,   -2 }, /* (418) where_clause_opt ::= WHERE search_condition */
  {  347,    0 }, /* (419) partition_by_clause_opt ::= */
  {  347,   -3 }, /* (420) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  351,    0 }, /* (421) twindow_clause_opt ::= */
  {  351,   -6 }, /* (422) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  351,   -4 }, /* (423) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  351,   -6 }, /* (424) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  351,   -8 }, /* (425) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  299,    0 }, /* (426) sliding_opt ::= */
  {  299,   -4 }, /* (427) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  350,    0 }, /* (428) fill_opt ::= */
  {  350,   -4 }, /* (429) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  350,   -6 }, /* (430) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  356,   -1 }, /* (431) fill_mode ::= NONE */
  {  356,   -1 }, /* (432) fill_mode ::= PREV */
  {  356,   -1 }, /* (433) fill_mode ::= NULL */
  {  356,   -1 }, /* (434) fill_mode ::= LINEAR */
  {  356,   -1 }, /* (435) fill_mode ::= NEXT */
  {  352,    0 }, /* (436) group_by_clause_opt ::= */
  {  352,   -3 }, /* (437) group_by_clause_opt ::= GROUP BY group_by_list */
  {  357,   -1 }, /* (438) group_by_list ::= expression */
  {  357,   -3 }, /* (439) group_by_list ::= group_by_list NK_COMMA expression */
  {  353,    0 }, /* (440) having_clause_opt ::= */
  {  353,   -2 }, /* (441) having_clause_opt ::= HAVING search_condition */
  {  348,    0 }, /* (442) range_opt ::= */
  {  348,   -6 }, /* (443) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  349,    0 }, /* (444) every_opt ::= */
  {  349,   -4 }, /* (445) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  303,   -4 }, /* (446) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  358,   -1 }, /* (447) query_expression_body ::= query_primary */
  {  358,   -4 }, /* (448) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  358,   -3 }, /* (449) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  362,   -1 }, /* (450) query_primary ::= query_specification */
  {  362,   -6 }, /* (451) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  359,    0 }, /* (452) order_by_clause_opt ::= */
  {  359,   -3 }, /* (453) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  360,    0 }, /* (454) slimit_clause_opt ::= */
  {  360,   -2 }, /* (455) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  360,   -4 }, /* (456) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  360,   -4 }, /* (457) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  361,    0 }, /* (458) limit_clause_opt ::= */
  {  361,   -2 }, /* (459) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  361,   -4 }, /* (460) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  361,   -4 }, /* (461) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  322,   -3 }, /* (462) subquery ::= NK_LP query_expression NK_RP */
  {  343,   -1 }, /* (463) search_condition ::= common_expression */
  {  363,   -1 }, /* (464) sort_specification_list ::= sort_specification */
  {  363,   -3 }, /* (465) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  364,   -3 }, /* (466) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  365,    0 }, /* (467) ordering_specification_opt ::= */
  {  365,   -1 }, /* (468) ordering_specification_opt ::= ASC */
  {  365,   -1 }, /* (469) ordering_specification_opt ::= DESC */
  {  366,    0 }, /* (470) null_ordering_opt ::= */
  {  366,   -2 }, /* (471) null_ordering_opt ::= NULLS FIRST */
  {  366,   -2 }, /* (472) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,245,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,246,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,245,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,247,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,248,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,246,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,248,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,247,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy241, &yymsp[-1].minor.yy0, yymsp[0].minor.yy629); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy241, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy241, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy241, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy241); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy629 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy629 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy683, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy241); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy683, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy241); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy683 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy683 = yymsp[0].minor.yy683; }
  yymsp[0].minor.yy683 = yylhsminor.yy683;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy683 = yymsp[-2].minor.yy683 | yymsp[0].minor.yy683; }
  yymsp[-2].minor.yy683 = yylhsminor.yy683;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy683 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy683 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy241 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy241 = yylhsminor.yy241;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy241 = yymsp[-2].minor.yy241; }
  yymsp[-2].minor.yy241 = yylhsminor.yy241;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy241, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy241); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 301: /* db_name ::= NK_ID */ yytestcase(yyruleno==301);
      case 302: /* table_name ::= NK_ID */ yytestcase(yyruleno==302);
      case 303: /* column_name ::= NK_ID */ yytestcase(yyruleno==303);
      case 304: /* function_name ::= NK_ID */ yytestcase(yyruleno==304);
      case 305: /* table_alias ::= NK_ID */ yytestcase(yyruleno==305);
      case 306: /* column_alias ::= NK_ID */ yytestcase(yyruleno==306);
      case 307: /* user_name ::= NK_ID */ yytestcase(yyruleno==307);
      case 308: /* index_name ::= NK_ID */ yytestcase(yyruleno==308);
      case 309: /* topic_name ::= NK_ID */ yytestcase(yyruleno==309);
      case 310: /* stream_name ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==311);
      case 346: /* noarg_func ::= NOW */ yytestcase(yyruleno==346);
      case 347: /* noarg_func ::= TODAY */ yytestcase(yyruleno==347);
      case 348: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==348);
      case 349: /* star_func ::= COUNT */ yytestcase(yyruleno==349);
      case 350: /* star_func ::= FIRST */ yytestcase(yyruleno==350);
      case 351: /* star_func ::= LAST */ yytestcase(yyruleno==351);
      case 352: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==352);
{ yylhsminor.yy241 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy241 = yylhsminor.yy241;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy197, &yymsp[-1].minor.yy241, yymsp[0].minor.yy442); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy197, &yymsp[0].minor.yy241); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy241); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy241, yymsp[0].minor.yy442); }
        break;
      case 66: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy197 = true; }
        break;
      case 67: /* not_exists_opt ::= */
      case 69: /* exists_opt ::= */ yytestcase(yyruleno==69);
      case 244: /* analyze_opt ::= */ yytestcase(yyruleno==244);
      case 252: /* agg_func_opt ::= */ yytestcase(yyruleno==252);
      case 406: /* set_quantifier_opt ::= */ yytestcase(yyruleno==406);
{ yymsp[1].minor.yy197 = false; }
        break;
      case 68: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy197 = true; }
        break;
      case 70: /* db_options ::= */
{ yymsp[1].minor.yy442 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 71: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 72: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 73: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 74: /* db_options ::= db_options DURATION NK_INTEGER */
      case 75: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==75);
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 76: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 77: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 78: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 79: /* db_options ::= db_options KEEP integer_list */
      case 80: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==80);
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_KEEP, yymsp[0].minor.yy368); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 81: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 82: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 83: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 84: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 85: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 86: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 87: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 88: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 89: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_RETENTIONS, yymsp[0].minor.yy368); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 90: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy442 = setDatabaseOption(pCxt, yymsp[-2].minor.yy442, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 91: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy442 = createAlterDatabaseOptions(pCxt); yylhsminor.yy442 = setAlterDatabaseOption(pCxt, yylhsminor.yy442, &yymsp[0].minor.yy301); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 92: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy442 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy442, &yymsp[0].minor.yy301); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 93: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 94: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= KEEP integer_list */
      case 97: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==97);
{ yymsp[-1].minor.yy301.type = DB_OPTION_KEEP; yymsp[-1].minor.yy301.pList = yymsp[0].minor.yy368; }
        break;
      case 98: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_PAGES; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_STRICT; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 101: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy301.type = DB_OPTION_WAL; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy368 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy368 = yylhsminor.yy368;
        break;
      case 103: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 273: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==273);
{ yylhsminor.yy368 = addNodeToList(pCxt, yymsp[-2].minor.yy368, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy368 = yylhsminor.yy368;
        break;
      case 104: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy368 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy368 = yylhsminor.yy368;
        break;
      case 105: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy368 = addNodeToList(pCxt, yymsp[-2].minor.yy368, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy368 = yylhsminor.yy368;
        break;
      case 106: /* retention_list ::= retention */
      case 126: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==126);
      case 129: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==129);
      case 136: /* column_def_list ::= column_def */ yytestcase(yyruleno==136);
      case 179: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==179);
      case 184: /* col_name_list ::= col_name */ yytestcase(yyruleno==184);
      case 230: /* func_list ::= func */ yytestcase(yyruleno==230);
      case 299: /* literal_list ::= signed_literal */ yytestcase(yyruleno==299);
      case 355: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==355);
      case 411: /* select_sublist ::= select_item */ yytestcase(yyruleno==411);
      case 464: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==464);
{ yylhsminor.yy368 = createNodeList(pCxt, yymsp[0].minor.yy442); }
  yymsp[0].minor.yy368 = yylhsminor.yy368;
        break;
      case 107: /* retention_list ::= retention_list NK_COMMA retention */
      case 137: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==185);
      case 231: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==231);
      case 300: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==300);
      case 356: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==356);
      case 412: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==412);
      case 465: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==465);
{ yylhsminor.yy368 = addNodeToList(pCxt, yymsp[-2].minor.yy368, yymsp[0].minor.yy442); }
  yymsp[-2].minor.yy368 = yylhsminor.yy368;
        break;
      case 108: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy442 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 109: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 111: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==111);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy197, yymsp[-5].minor.yy442, yymsp[-3].minor.yy368, yymsp[-1].minor.yy368, yymsp[0].minor.yy442); }
        break;
      case 110: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy368); }
        break;
      case 112: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy368); }
        break;
      case 113: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy197, yymsp[0].minor.yy442); }
        break;
      case 114: /* cmd ::= ALTER TABLE alter_table_clause */
      case 115: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==115);
      case 276: /* cmd ::= query_expression */ yytestcase(yyruleno==276);
{ pCxt->pRootNode = yymsp[0].minor.yy442; }
        break;
      case 116: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy442 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy442, yymsp[0].minor.yy442); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 117: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy442 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy442, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy241, yymsp[0].minor.yy392); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 118: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy442 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy442, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy241); }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 119: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy442 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy442, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy241, yymsp[0].minor.yy392); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 120: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy442 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy442, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy241, &yymsp[0].minor.yy241); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 121: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy442 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy442, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy241, yymsp[0].minor.yy392); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 122: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy442 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy442, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy241); }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 123: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy442 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy442, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy241, yymsp[0].minor.yy392); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 124: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy442 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy442, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy241, &yymsp[0].minor.yy241); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 125: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy442 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy442, &yymsp[-2].minor.yy241, yymsp[0].minor.yy442); }
  yymsp[-5].minor.yy442 = yylhsminor.yy442;
        break;
      case 127: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 130: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==130);
{ yylhsminor.yy368 = addNodeToList(pCxt, yymsp[-1].minor.yy368, yymsp[0].minor.yy442); }
  yymsp[-1].minor.yy368 = yylhsminor.yy368;
        break;
      case 128: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy442 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy197, yymsp[-8].minor.yy442, yymsp[-6].minor.yy442, yymsp[-5].minor.yy368, yymsp[-2].minor.yy368, yymsp[0].minor.yy442); }
  yymsp[-9].minor.yy442 = yylhsminor.yy442;
        break;
      case 131: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy442 = createDropTableClause(pCxt, yymsp[-1].minor.yy197, yymsp[0].minor.yy442); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 132: /* specific_tags_opt ::= */
      case 163: /* tags_def_opt ::= */ yytestcase(yyruleno==163);
      case 419: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==419);
      case 436: /* group_by_clause_opt ::= */ yytestcase(yyruleno==436);
      case 452: /* order_by_clause_opt ::= */ yytestcase(yyruleno==452);
{ yymsp[1].minor.yy368 = NULL; }
        break;
      case 133: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy368 = yymsp[-1].minor.yy368; }
        break;
      case 134: /* full_table_name ::= table_name */
{ yylhsminor.yy442 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy241, NULL); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 135: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy442 = createRealTableNode(pCxt, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy241, NULL); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 138: /* column_def ::= column_name type_name */
{ yylhsminor.yy442 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy241, yymsp[0].minor.yy392, NULL); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 139: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy442 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy241, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 140: /* type_name ::= BOOL */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 141: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 142: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 143: /* type_name ::= INT */
      case 144: /* type_name ::= INTEGER */ yytestcase(yyruleno==144);
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 145: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 146: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 147: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 148: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy392 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 149: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 150: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy392 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 151: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy392 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 152: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy392 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 153: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy392 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 154: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy392 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 155: /* type_name ::= JSON */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 156: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy392 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 158: /* type_name ::= BLOB */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 159: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy392 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy392 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy392 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy392 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 164: /* tags_def_opt ::= tags_def */
      case 354: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==354);
      case 410: /* select_list ::= select_sublist */ yytestcase(yyruleno==410);
{ yylhsminor.yy368 = yymsp[0].minor.yy368; }
  yymsp[0].minor.yy368 = yylhsminor.yy368;
        break;
      case 165: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy368 = yymsp[-1].minor.yy368; }
        break;
      case 166: /* table_options ::= */
{ yymsp[1].minor.yy442 = createDefaultTableOptions(pCxt); }
        break;
      case 167: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy442 = setTableOption(pCxt, yymsp[-2].minor.yy442, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 168: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy442 = setTableOption(pCxt, yymsp[-2].minor.yy442, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy368); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 169: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy442 = setTableOption(pCxt, yymsp[-2].minor.yy442, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy368); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 170: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy442 = setTableOption(pCxt, yymsp[-4].minor.yy442, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy368); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 171: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy442 = setTableOption(pCxt, yymsp[-2].minor.yy442, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 172: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy442 = setTableOption(pCxt, yymsp[-4].minor.yy442, TABLE_OPTION_SMA, yymsp[-1].minor.yy368); }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 173: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy442 = createAlterTableOptions(pCxt); yylhsminor.yy442 = setTableOption(pCxt, yylhsminor.yy442, yymsp[0].minor.yy301.type, &yymsp[0].minor.yy301.val); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 174: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy442 = setTableOption(pCxt, yymsp[-1].minor.yy442, yymsp[0].minor.yy301.type, &yymsp[0].minor.yy301.val); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 175: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy301.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 176: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy301.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy301.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* duration_list ::= duration_literal */
      case 328: /* expression_list ::= expression */ yytestcase(yyruleno==328);
{ yylhsminor.yy368 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy442)); }
  yymsp[0].minor.yy368 = yylhsminor.yy368;
        break;
      case 178: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 329: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==329);
{ yylhsminor.yy368 = addNodeToList(pCxt, yymsp[-2].minor.yy368, releaseRawExprNode(pCxt, yymsp[0].minor.yy442)); }
  yymsp[-2].minor.yy368 = yylhsminor.yy368;
        break;
      case 181: /* rollup_func_name ::= function_name */
{ yylhsminor.yy442 = createFunctionNode(pCxt, &yymsp[0].minor.yy241, NULL); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 182: /* rollup_func_name ::= FIRST */
      case 183: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==183);
{ yylhsminor.yy442 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 186: /* col_name ::= column_name */
{ yylhsminor.yy442 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy241); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 187: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 188: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 189: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 190: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy442, yymsp[0].minor.yy442, OP_TYPE_LIKE); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy442, yymsp[0].minor.yy442, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy442, NULL, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 195: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 196: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 197: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy442, yymsp[-1].minor.yy442, OP_TYPE_EQUAL); }
        break;
      case 198: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 199: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 200: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 201: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 202: /* cmd ::= SHOW LICENCE */
      case 203: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==203);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 204: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy241); }
        break;
      case 205: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy442); }
        break;
      case 206: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy442); }
        break;
      case 207: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 208: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 209: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 210: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 211: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 213: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 216: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy442); }
        break;
      case 218: /* db_name_cond_opt ::= */
      case 223: /* from_db_opt ::= */ yytestcase(yyruleno==223);
{ yymsp[1].minor.yy442 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 219: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy241); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 220: /* like_pattern_opt ::= */
      case 227: /* index_options ::= */ yytestcase(yyruleno==227);
      case 258: /* into_opt ::= */ yytestcase(yyruleno==258);
      case 387: /* from_clause_opt ::= */ yytestcase(yyruleno==387);
      case 417: /* where_clause_opt ::= */ yytestcase(yyruleno==417);
      case 421: /* twindow_clause_opt ::= */ yytestcase(yyruleno==421);
      case 426: /* sliding_opt ::= */ yytestcase(yyruleno==426);
      case 428: /* fill_opt ::= */ yytestcase(yyruleno==428);
      case 440: /* having_clause_opt ::= */ yytestcase(yyruleno==440);
      case 442: /* range_opt ::= */ yytestcase(yyruleno==442);
      case 444: /* every_opt ::= */ yytestcase(yyruleno==444);
      case 454: /* slimit_clause_opt ::= */ yytestcase(yyruleno==454);
      case 458: /* limit_clause_opt ::= */ yytestcase(yyruleno==458);
{ yymsp[1].minor.yy442 = NULL; }
        break;
      case 221: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 222: /* table_name_cond ::= table_name */
{ yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy241); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 224: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy241); }
        break;
      case 225: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy197, &yymsp[-3].minor.yy241, &yymsp[-1].minor.yy241, NULL, yymsp[0].minor.yy442); }
        break;
      case 226: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy197, &yymsp[0].minor.yy241); }
        break;
      case 228: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy442 = createIndexOption(pCxt, yymsp[-6].minor.yy368, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), NULL, yymsp[0].minor.yy442); }
        break;
      case 229: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy442 = createIndexOption(pCxt, yymsp[-8].minor.yy368, releaseRawExprNode(pCxt, yymsp[-4].minor.yy442), releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), yymsp[0].minor.yy442); }
        break;
      case 232: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy442 = createFunctionNode(pCxt, &yymsp[-3].minor.yy241, yymsp[-1].minor.yy368); }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 233: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy197, &yymsp[-2].minor.yy241, yymsp[0].minor.yy442); }
        break;
      case 234: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy197, &yymsp[-3].minor.yy241, &yymsp[0].minor.yy241, false); }
        break;
      case 235: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy197, &yymsp[-5].minor.yy241, &yymsp[0].minor.yy241, true); }
        break;
      case 236: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy197, &yymsp[-3].minor.yy241, yymsp[0].minor.yy442, false); }
        break;
      case 237: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy197, &yymsp[-5].minor.yy241, yymsp[0].minor.yy442, true); }
        break;
      case 238: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy197, &yymsp[0].minor.yy241); }
        break;
      case 239: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy197, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy241); }
        break;
      case 240: /* cmd ::= DESC full_table_name */
      case 241: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==241);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy442); }
        break;
      case 242: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 243: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy197, yymsp[-1].minor.yy442, yymsp[0].minor.yy442); }
        break;
      case 245: /* analyze_opt ::= ANALYZE */
      case 253: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==253);
      case 407: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==407);
{ yymsp[0].minor.yy197 = true; }
        break;
      case 246: /* explain_options ::= */
{ yymsp[1].minor.yy442 = createDefaultExplainOptions(pCxt); }
        break;
      case 247: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy442 = setExplainVerbose(pCxt, yymsp[-2].minor.yy442, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 248: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy442 = setExplainRatio(pCxt, yymsp[-2].minor.yy442, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 249: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy368); }
        break;
      case 250: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy197, yymsp[-8].minor.yy197, &yymsp[-5].minor.yy241, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy392, yymsp[0].minor.yy578); }
        break;
      case 251: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy197, &yymsp[0].minor.yy241); }
        break;
      case 254: /* bufsize_opt ::= */
{ yymsp[1].minor.yy578 = 0; }
        break;
      case 255: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy578 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 256: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy197, &yymsp[-4].minor.yy241, yymsp[-2].minor.yy442, yymsp[-3].minor.yy442, yymsp[0].minor.yy442); }
        break;
      case 257: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy197, &yymsp[0].minor.yy241); }
        break;
      case 259: /* into_opt ::= INTO full_table_name */
      case 388: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==388);
      case 418: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==418);
      case 441: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==441);
{ yymsp[-1].minor.yy442 = yymsp[0].minor.yy442; }
        break;
      case 260: /* stream_options ::= */
{ yymsp[1].minor.yy442 = createStreamOptions(pCxt); }
        break;
      case 261: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy442)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy442 = yymsp[-2].minor.yy442; }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 262: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy442)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy442 = yymsp[-2].minor.yy442; }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 263: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy442)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy442)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy442); yylhsminor.yy442 = yymsp[-3].minor.yy442; }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 264: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy442)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy442); yylhsminor.yy442 = yymsp[-2].minor.yy442; }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 265: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 266: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 267: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 268: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 269: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 270: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy368); }
        break;
      case 271: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 272: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy368 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 274: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy241); }
        break;
      case 275: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy442, yymsp[0].minor.yy442); }
        break;
      case 277: /* literal ::= NK_INTEGER */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 278: /* literal ::= NK_FLOAT */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 279: /* literal ::= NK_STRING */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 280: /* literal ::= NK_BOOL */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 281: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 282: /* literal ::= duration_literal */
      case 292: /* signed_literal ::= signed */ yytestcase(yyruleno==292);
      case 312: /* expression ::= literal */ yytestcase(yyruleno==312);
      case 313: /* expression ::= pseudo_column */ yytestcase(yyruleno==313);
      case 314: /* expression ::= column_reference */ yytestcase(yyruleno==314);
      case 315: /* expression ::= function_expression */ yytestcase(yyruleno==315);
      case 316: /* expression ::= subquery */ yytestcase(yyruleno==316);
      case 343: /* function_expression ::= literal_func */ yytestcase(yyruleno==343);
      case 379: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==379);
      case 383: /* boolean_primary ::= predicate */ yytestcase(yyruleno==383);
      case 385: /* common_expression ::= expression */ yytestcase(yyruleno==385);
      case 386: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==386);
      case 389: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==389);
      case 391: /* table_reference ::= table_primary */ yytestcase(yyruleno==391);
      case 392: /* table_reference ::= joined_table */ yytestcase(yyruleno==392);
      case 396: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==396);
      case 447: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==447);
      case 450: /* query_primary ::= query_specification */ yytestcase(yyruleno==450);
{ yylhsminor.yy442 = yymsp[0].minor.yy442; }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 283: /* literal ::= NULL */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 284: /* literal ::= NK_QUESTION */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 285: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 286: /* signed ::= NK_INTEGER */
{ yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 287: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 288: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 289: /* signed ::= NK_FLOAT */
{ yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 290: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 291: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 293: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 294: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 295: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 296: /* signed_literal ::= duration_literal */
      case 298: /* signed_literal ::= literal_func */ yytestcase(yyruleno==298);
      case 357: /* star_func_para ::= expression */ yytestcase(yyruleno==357);
      case 413: /* select_item ::= common_expression */ yytestcase(yyruleno==413);
      case 463: /* search_condition ::= common_expression */ yytestcase(yyruleno==463);
{ yylhsminor.yy442 = releaseRawExprNode(pCxt, yymsp[0].minor.yy442); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 297: /* signed_literal ::= NULL */
{ yylhsminor.yy442 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 317: /* expression ::= NK_LP expression NK_RP */
      case 384: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==384);
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy442)); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 318: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy442));
                                                                                  }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 319: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy442), NULL));
                                                                                  }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 320: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442))); 
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 321: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442))); 
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 322: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442))); 
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 323: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442))); 
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 324: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 325: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 326: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 327: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 330: /* column_reference ::= column_name */
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy241, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy241)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 331: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy241, createColumnNode(pCxt, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy241)); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 332: /* pseudo_column ::= ROWTS */
      case 333: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==333);
      case 335: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==335);
      case 336: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==336);
      case 337: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==337);
      case 338: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==338);
      case 339: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==339);
      case 345: /* literal_func ::= NOW */ yytestcase(yyruleno==345);
{ yylhsminor.yy442 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy442 = yylhsminor.yy442;
        break;
      case 334: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy241)))); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 340: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 341: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==341);
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy241, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy241, yymsp[-1].minor.yy368)); }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 342: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy442), yymsp[-1].minor.yy392)); }
  yymsp[-5].minor.yy442 = yylhsminor.yy442;
        break;
      case 344: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy241, NULL)); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 353: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy368 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy368 = yylhsminor.yy368;
        break;
      case 358: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 416: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==416);
{ yylhsminor.yy442 = createColumnNode(pCxt, &yymsp[-2].minor.yy241, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 359: /* predicate ::= expression compare_op expression */
      case 364: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==364);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy412, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 360: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy442), releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-4].minor.yy442 = yylhsminor.yy442;
        break;
      case 361: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy442), releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-5].minor.yy442 = yylhsminor.yy442;
        break;
      case 362: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), NULL));
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 363: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy442), NULL));
                                                                                  }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 365: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy412 = OP_TYPE_LOWER_THAN; }
        break;
      case 366: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy412 = OP_TYPE_GREATER_THAN; }
        break;
      case 367: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy412 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 368: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy412 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 369: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy412 = OP_TYPE_NOT_EQUAL; }
        break;
      case 370: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy412 = OP_TYPE_EQUAL; }
        break;
      case 371: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy412 = OP_TYPE_LIKE; }
        break;
      case 372: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy412 = OP_TYPE_NOT_LIKE; }
        break;
      case 373: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy412 = OP_TYPE_MATCH; }
        break;
      case 374: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy412 = OP_TYPE_NMATCH; }
        break;
      case 375: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy412 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 376: /* in_op ::= IN */
{ yymsp[0].minor.yy412 = OP_TYPE_IN; }
        break;
      case 377: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy412 = OP_TYPE_NOT_IN; }
        break;
      case 378: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy368)); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 380: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy442), NULL));
                                                                                  }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 381: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 382: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy442);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy442);
                                                                                    yylhsminor.yy442 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), releaseRawExprNode(pCxt, yymsp[0].minor.yy442)));
                                                                                  }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 390: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy442 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy442, yymsp[0].minor.yy442, NULL); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 393: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy442 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy241, &yymsp[0].minor.yy241); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 394: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy442 = createRealTableNode(pCxt, &yymsp[-3].minor.yy241, &yymsp[-1].minor.yy241, &yymsp[0].minor.yy241); }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 395: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy442 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy442), &yymsp[0].minor.yy241); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 397: /* alias_opt ::= */
{ yymsp[1].minor.yy241 = nil_token;  }
        break;
      case 398: /* alias_opt ::= table_alias */
{ yylhsminor.yy241 = yymsp[0].minor.yy241; }
  yymsp[0].minor.yy241 = yylhsminor.yy241;
        break;
      case 399: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy241 = yymsp[0].minor.yy241; }
        break;
      case 400: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 401: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==401);
{ yymsp[-2].minor.yy442 = yymsp[-1].minor.yy442; }
        break;
      case 402: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy442 = createJoinTableNode(pCxt, yymsp[-4].minor.yy208, yymsp[-5].minor.yy442, yymsp[-2].minor.yy442, yymsp[0].minor.yy442); }
  yymsp[-5].minor.yy442 = yylhsminor.yy442;
        break;
      case 403: /* join_type ::= */
{ yymsp[1].minor.yy208 = JOIN_TYPE_INNER; }
        break;
      case 404: /* join_type ::= INNER */
{ yymsp[0].minor.yy208 = JOIN_TYPE_INNER; }
        break;
      case 405: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy442 = createSelectStmt(pCxt, yymsp[-10].minor.yy197, yymsp[-9].minor.yy368, yymsp[-8].minor.yy442);
                                                                                    yymsp[-11].minor.yy442 = addWhereClause(pCxt, yymsp[-11].minor.yy442, yymsp[-7].minor.yy442);
                                                                                    yymsp[-11].minor.yy442 = addPartitionByClause(pCxt, yymsp[-11].minor.yy442, yymsp[-6].minor.yy368);
                                                                                    yymsp[-11].minor.yy442 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy442, yymsp[-2].minor.yy442);
                                                                                    yymsp[-11].minor.yy442 = addGroupByClause(pCxt, yymsp[-11].minor.yy442, yymsp[-1].minor.yy368);
                                                                                    yymsp[-11].minor.yy442 = addHavingClause(pCxt, yymsp[-11].minor.yy442, yymsp[0].minor.yy442);
                                                                                    yymsp[-11].minor.yy442 = addRangeClause(pCxt, yymsp[-11].minor.yy442, yymsp[-5].minor.yy442);
                                                                                    yymsp[-11].minor.yy442 = addEveryClause(pCxt, yymsp[-11].minor.yy442, yymsp[-4].minor.yy442);
                                                                                    yymsp[-11].minor.yy442 = addFillClause(pCxt, yymsp[-11].minor.yy442, yymsp[-3].minor.yy442);
                                                                                  }
        break;
      case 408: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy197 = false; }
        break;
      case 409: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy368 = NULL; }
        break;
      case 414: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy442 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy442), &yymsp[0].minor.yy241); }
  yymsp[-1].minor.yy442 = yylhsminor.yy442;
        break;
      case 415: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy442 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), &yymsp[0].minor.yy241); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 420: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 437: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==437);
      case 453: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==453);
{ yymsp[-2].minor.yy368 = yymsp[0].minor.yy368; }
        break;
      case 422: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy442 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy442), releaseRawExprNode(pCxt, yymsp[-1].minor.yy442)); }
        break;
      case 423: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy442 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy442)); }
        break;
      case 424: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy442 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy442), NULL, yymsp[-1].minor.yy442, yymsp[0].minor.yy442); }
        break;
      case 425: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy442 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy442), releaseRawExprNode(pCxt, yymsp[-3].minor.yy442), yymsp[-1].minor.yy442, yymsp[0].minor.yy442); }
        break;
      case 427: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 445: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==445);
{ yymsp[-3].minor.yy442 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy442); }
        break;
      case 429: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy442 = createFillNode(pCxt, yymsp[-1].minor.yy388, NULL); }
        break;
      case 430: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy442 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy368)); }
        break;
      case 431: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy388 = FILL_MODE_NONE; }
        break;
      case 432: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy388 = FILL_MODE_PREV; }
        break;
      case 433: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy388 = FILL_MODE_NULL; }
        break;
      case 434: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy388 = FILL_MODE_LINEAR; }
        break;
      case 435: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy388 = FILL_MODE_NEXT; }
        break;
      case 438: /* group_by_list ::= expression */
{ yylhsminor.yy368 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy442))); }
  yymsp[0].minor.yy368 = yylhsminor.yy368;
        break;
      case 439: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy368 = addNodeToList(pCxt, yymsp[-2].minor.yy368, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy442))); }
  yymsp[-2].minor.yy368 = yylhsminor.yy368;
        break;
      case 443: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy442 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy442), releaseRawExprNode(pCxt, yymsp[-1].minor.yy442)); }
        break;
      case 446: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy442 = addOrderByClause(pCxt, yymsp[-3].minor.yy442, yymsp[-2].minor.yy368);
                                                                                    yylhsminor.yy442 = addSlimitClause(pCxt, yylhsminor.yy442, yymsp[-1].minor.yy442);
                                                                                    yylhsminor.yy442 = addLimitClause(pCxt, yylhsminor.yy442, yymsp[0].minor.yy442);
                                                                                  }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 448: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy442 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy442, yymsp[0].minor.yy442); }
  yymsp[-3].minor.yy442 = yylhsminor.yy442;
        break;
      case 449: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy442 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy442, yymsp[0].minor.yy442); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 451: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy442 = yymsp[-4].minor.yy442; }
  yy_destructor(yypParser,359,&yymsp[-3].minor);
  yy_destructor(yypParser,360,&yymsp[-2].minor);
  yy_destructor(yypParser,361,&yymsp[-1].minor);
        break;
      case 455: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 459: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==459);
{ yymsp[-1].minor.yy442 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 456: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 460: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==460);
{ yymsp[-3].minor.yy442 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 457: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 461: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==461);
{ yymsp[-3].minor.yy442 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 462: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy442 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy442); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 466: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy442 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy442), yymsp[-1].minor.yy362, yymsp[0].minor.yy417); }
  yymsp[-2].minor.yy442 = yylhsminor.yy442;
        break;
      case 467: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy362 = ORDER_ASC; }
        break;
      case 468: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy362 = ORDER_ASC; }
        break;
      case 469: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy362 = ORDER_DESC; }
        break;
      case 470: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy417 = NULL_ORDER_DEFAULT; }
        break;
      case 471: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy417 = NULL_ORDER_FIRST; }
        break;
      case 472: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy417 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
