---
sidebar_label: 运算符
title: 运算符
description: TDengine 支持的所有运算符
---

## 算术运算符

| #   | **运算符** | **支持的类型** | **说明**                   |
| --- | :--------: | -------------- | -------------------------- |
| 1   |    +, -    | 数值类型       | 表达正数和负数，一元运算符 |
| 2   |    +, -    | 数值类型       | 表示加法和减法，二元运算符 |
| 3   |   \*, /    | 数值类型       | 表示乘法和除法，二元运算符 |
| 4   |     %      | 数值类型       | 表示取余运算，二元运算符   |

## 位运算符

| #   | **运算符** | **支持的类型** | **说明**           |
| --- | :--------: | -------------- | ------------------ |
| 1   |     &      | 数值类型       | 按位与，二元运算符 |
| 2   |     \|     | 数值类型       | 按位或，二元运算符 |

## JSON 运算符

`->` 运算符可以对 JSON 类型的列按键取值。`->` 左侧是列标识符，右侧是键的字符串常量，如 `col->'name'`，返回键 `'name'` 的值。

## 集合运算符

集合运算符将两个查询的结果合并为一个结果。包含集合运算符的查询称之为复合查询。复合查询中每条查询的选择列表中的相应表达式在数量上必须匹配，且结果类型以第一条查询为准，后续查询的结果类型必须可转换到第一条查询的结果类型，转换规则同 CAST 函数。

TDengine 支持 `UNION ALL` 和 `UNION` 操作符。UNION ALL 将查询返回的结果集合并返回，并不去重。UNION 将查询返回的结果集合并并去重后返回。在同一个 SQL 语句中，集合操作符最多支持 100 个。

## 比较运算符

| #   |    **运算符**     | **支持的类型**                                                       | **说明**             |
| --- | :---------------: | -------------------------------------------------------------------- | -------------------- |
| 1   |         =         | 除 BLOB、MEDIUMBLOB 和 JSON 外的所有类型                             | 相等                 |
| 2   |      <\>, !=      | 除 BLOB、MEDIUMBLOB 和 JSON 外的所有类型，且不可以为表的时间戳主键列 | 不相等               |
| 3   |      \>, <       | 除 BLOB、MEDIUMBLOB 和 JSON 外的所有类型                             | 大于，小于           |
| 4   |     \>=, <=      | 除 BLOB、MEDIUMBLOB 和 JSON 外的所有类型                             | 大于等于，小于等于   |
| 5   |   IS [NOT] NULL   | 所有类型                                                             | 是否为空值           |
| 6   | [NOT] BETWEEN AND | 除 BOOL、BLOB、MEDIUMBLOB 和 JSON 外的所有类型                       | 闭区间比较           |
| 7   |        IN         | 除 BLOB、MEDIUMBLOB 和 JSON 外的所有类型，且不可以为表的时间戳主键列 | 与列表内的任意值相等 |
| 8   |       LIKE        | BINARY、NCHAR 和 VARCHAR                                             | 通配符匹配           |
| 9   |   MATCH, NMATCH   | BINARY、NCHAR 和 VARCHAR                                             | 正则表达式匹配       |
| 10  |     CONTAINS      | JSON                                                                 | JSON 中是否存在某键  |

LIKE 条件使用通配符字符串进行匹配检查，规则如下：

- '%'（百分号）匹配 0 到任意个字符；'\_'（下划线）匹配单个任意 ASCII 字符。
- 如果希望匹配字符串中原本就带有的 \_（下划线）字符，那么可以在通配符字符串中写作 \_，即加一个反斜线来进行转义。
- 通配符字符串最长不能超过 100 字节。不建议使用太长的通配符字符串，否则将有可能严重影响 LIKE 操作的执行性能。

MATCH 条件和 NMATCH 条件使用正则表达式进行匹配，规则如下：

- 支持符合 POSIX 规范的正则表达式，具体规范内容可参见 Regular Expressions。
- 只能针对子表名（即 tbname）、字符串类型的标签值进行正则表达式过滤，不支持普通列的过滤。
- 正则匹配字符串长度不能超过 128 字节。可以通过参数 maxRegexStringLen 设置和调整最大允许的正则匹配字符串，该参数是客户端配置参数，需要重启客户端才能生效

## 逻辑运算符

| #   | **运算符** | **支持的类型** | **说明**                                                                    |
| --- | :--------: | -------------- | --------------------------------------------------------------------------- |
| 1   |    AND     | BOOL           | 逻辑与，如果两个条件均为 TRUE， 则返回 TRUE。如果任一为 FALSE，则返回 FALSE |
| 2   |     OR     | BOOL           | 逻辑或，如果任一条件为 TRUE， 则返回 TRUE。如果两者都是 FALSE，则返回 FALSE |

TDengine 在计算逻辑条件时，会进行短路径优化，即对于 AND，第一个条件为 FALSE，则不再计算第二个条件，直接返回 FALSE；对于 OR，第一个条件为 TRUE，则不再计算第二个条件，直接返回 TRUE。
