/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 449
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  bool yy39;
  SToken yy181;
  EJoinType yy202;
  int32_t yy276;
  SNodeList* yy282;
  int8_t yy293;
  ENullOrder yy305;
  SDataType yy380;
  EFillMode yy381;
  SAlterOption yy645;
  EOperatorType yy682;
  SNode* yy778;
  int64_t yy831;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             695
#define YYNRULE              523
#define YYNTOKEN             317
#define YY_MAX_SHIFT         694
#define YY_MIN_SHIFTREDUCE   1026
#define YY_MAX_SHIFTREDUCE   1548
#define YY_ERROR_ACTION      1549
#define YY_ACCEPT_ACTION     1550
#define YY_NO_ACTION         1551
#define YY_MIN_REDUCE        1552
#define YY_MAX_REDUCE        2074
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2993)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1876,   34,  267, 1876, 1805, 1059,  447, 1890,  448, 1587,
 /*    10 */  1692, 1872,   44,   42, 1872,  455,  394,  448, 1587, 1690,
 /*    20 */   349, 1872, 1329,   43,   41,   40,   39,   38, 1355,   40,
 /*    30 */    39,   38,  156, 1409, 1564, 1327, 1908, 1868, 1874,  337,
 /*    40 */  1868, 1874,  343,  587,  588, 1063, 1064, 1868, 1874, 1858,
 /*    50 */   594,  600,   30,  594,  310, 1575, 1404,  587,   37,   36,
 /*    60 */   594,   17,   43,   41,   40,   39,   38, 1890, 1335,   44,
 /*    70 */    42, 1479, 1888, 1076,  464, 1075, 1924,  349,  572, 1329,
 /*    80 */    97, 1889, 1891,  604, 1893, 1894,  599, 1574,  594, 2050,
 /*    90 */  1409,  637, 1327,  168,    1, 1977, 1908, 1858, 1355,  342,
 /*   100 */  1973,  587,  335, 1077,  601,  584, 1356, 2045, 1753, 1858,
 /*   110 */   154,  600,  173, 1404, 1573,  336,  691,   46,   17, 1703,
 /*   120 */  2003,  546,  571,  171, 1751, 1335, 1678, 2046,  573, 1858,
 /*   130 */  1411, 1412,  602,   52,  132, 1845, 1924, 1553, 1223, 1224,
 /*   140 */    98,  348, 1891,  604, 1893, 1894,  599,  533,  594,  354,
 /*   150 */  1701,    1, 1746, 1748,  334, 1977, 1858, 1802,  110,  314,
 /*   160 */  1973,  109,  108,  107,  106,  105,  104,  103,  102,  101,
 /*   170 */  2045,  130,  157,  691,  452,   46, 1330, 1656, 1328,   58,
 /*   180 */  1352, 1538,  371,  513, 1572,  571,  171, 1411, 1412,  227,
 /*   190 */  2046,  573,  586,  169, 1985, 1986,  511, 1990,  509, 1354,
 /*   200 */  1333, 1334, 1992, 1384, 1385, 1387, 1388, 1389, 1390, 1391,
 /*   210 */  1392, 1393, 1394,  596,  592, 1402, 1403, 1405, 1406, 1407,
 /*   220 */  1408, 1410, 1413,    3,  205,  446, 1858,   58,  450,   81,
 /*   230 */  1989,  454,  635, 1330,  450, 1328, 1617,  220,  161, 1676,
 /*   240 */  1731,  174, 1505,  481,  477,  473,  469,  204, 1877,  266,
 /*   250 */    47,  145,  144,  632,  631,  630,  629, 1333, 1334, 1872,
 /*   260 */  1384, 1385, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394,
 /*   270 */   596,  592, 1402, 1403, 1405, 1406, 1407, 1408, 1410, 1413,
 /*   280 */     3,   44,   42,   11,   78, 1868, 1874,  202,   11,  349,
 /*   290 */     9, 1329,  559, 1503, 1504, 1506, 1507,  219,  594,  499,
 /*   300 */   498,  497, 1409,  584, 1327,   58,  110,  126,  493,  109,
 /*   310 */   108,  107,  106,  105,  104,  103,  102,  101,  492,  496,
 /*   320 */   567,  635,  174,  546,  491, 1404,  174,   62, 1747, 1748,
 /*   330 */    17, 2050,  132, 1890,  167,  176, 1679, 1335,   44,   42,
 /*   340 */   145,  144,  632,  631,  630,  635,  349, 1740, 1329,  584,
 /*   350 */   201,  195, 1701,  200,   79,  312, 1753,  460,  536, 1409,
 /*   360 */  2045, 1327, 1908,    1,  145,  144,  632,  631,  630,  130,
 /*   370 */   588, 1908, 1752,  193,  174, 1858, 2049,  600,  132,  566,
 /*   380 */  2046, 2048, 1404, 1141, 1354,  691,  387,   17,  386,  233,
 /*   390 */   234,  170, 1985, 1986, 1335, 1990,  464,  174, 1888, 1411,
 /*   400 */  1412,   87, 1924, 1552, 1353,  352,   97, 1889, 1891,  604,
 /*   410 */  1893, 1894,  599,  154,  594,  121, 1143,   58,  565,  168,
 /*   420 */     1, 1977, 1703, 1694,  546,  342, 1973,  119,  118,  117,
 /*   430 */   116,  115,  114,  113,  112,  111,  120,  264, 1985,  583,
 /*   440 */    77,  582,  691,  485, 2045, 1330, 2004, 1328,  312,  495,
 /*   450 */   494,  536,  174, 1701,  125, 1753, 1411, 1412,   58,  571,
 /*   460 */   171, 1571,  353, 1696, 2046,  573,  548, 1686, 1949, 1333,
 /*   470 */  1334, 1751, 1384, 1385, 1387, 1388, 1389, 1390, 1391, 1392,
 /*   480 */  1393, 1394,  596,  592, 1402, 1403, 1405, 1406, 1407, 1408,
 /*   490 */  1410, 1413,    3,  562,   11,  550, 1801, 1949,  307,  432,
 /*   500 */   662,  660, 1330, 1858, 1328,   77, 1181,  626,  625,  624,
 /*   510 */  1185,  623, 1187, 1188,  622, 1190,  619, 1570, 1196,  616,
 /*   520 */  1198, 1199,  613,  610, 1569, 2050, 1333, 1334, 1697, 1384,
 /*   530 */  1385, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394,  596,
 /*   540 */   592, 1402, 1403, 1405, 1406, 1407, 1408, 1410, 1413,    3,
 /*   550 */    44,   42,  533,  546, 2045,  185,  184, 1568,  349, 1858,
 /*   560 */  1329, 1076, 1803, 1075,  174,  120, 1858, 1992, 1063, 1064,
 /*   570 */  2049, 1409,  490, 1327, 2046, 2047,  483,  383,  568,  563,
 /*   580 */    37,   36, 1701, 1890,   43,   41,   40,   39,   38,  546,
 /*   590 */  1483, 1077, 1357, 1992, 1404, 1988, 1354,  385,  381, 1858,
 /*   600 */   128,  392, 1890, 1948,  546,  174, 1335,   44,   42, 1414,
 /*   610 */   181,  546, 1908, 1567,  546,  349,  393, 1329, 1701,  524,
 /*   620 */   601, 1987,  325,  403, 2049, 1858,  417,  600, 1409, 1753,
 /*   630 */  1327, 1908,    8, 1701, 1335, 1440,  319,  546, 1356,  601,
 /*   640 */  1701,  546,  649, 1701, 1858, 1751,  600,   74,  602,  418,
 /*   650 */    73, 1404, 1924,  462,  691, 1858,  294,  348, 1891,  604,
 /*   660 */  1893, 1894,  599, 1335,  594, 1476, 1701, 1888, 1411, 1412,
 /*   670 */  1701, 1924,  232, 2050,  572,   97, 1889, 1891,  604, 1893,
 /*   680 */  1894,  599,  326,  594,  324,  323, 2045,  487, 2065,    8,
 /*   690 */  1977,  489,   37,   36,  342, 1973,   43,   41,   40,   39,
 /*   700 */    38,  571,  171, 2045, 2011,   31, 2046,  573,  546,  395,
 /*   710 */  1795,  691, 1677,  488, 1330, 1445, 1328, 1550,  571,  171,
 /*   720 */   268,  179,  396, 2046,  573, 1411, 1412,   26, 1419, 1795,
 /*   730 */    13,   12, 1307, 1308, 1354,  243, 1566, 1701, 1333, 1334,
 /*   740 */   180, 1384, 1385, 1387, 1388, 1389, 1390, 1391, 1392, 1393,
 /*   750 */  1394,  596,  592, 1402, 1403, 1405, 1406, 1407, 1408, 1410,
 /*   760 */  1413,    3,   37,   36,  546, 1538,   43,   41,   40,   39,
 /*   770 */    38, 1330,  637, 1328, 1795,  489,  463,  364, 1858,  174,
 /*   780 */  1386,  266,   37,   36, 1563,  183,   43,   41,   40,   39,
 /*   790 */    38, 1357, 1562, 1701,  529, 1333, 1334,  488, 1384, 1385,
 /*   800 */  1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394,  596,  592,
 /*   810 */  1402, 1403, 1405, 1406, 1407, 1408, 1410, 1413,    3,   44,
 /*   820 */    42,  546, 1329, 2045, 1452, 1354, 1858,  349, 1800, 1329,
 /*   830 */   307, 1997, 1472, 1698, 1858, 1327, 1561,   94, 2051,  171,
 /*   840 */  1409,  546, 1327, 2046,  573,  546, 1560,  499,  498,  497,
 /*   850 */  1701,  127, 1890,  137, 1688,  126,  493,  525,  650, 1693,
 /*   860 */  1671,  546, 1559, 1404, 1558, 1557,  492,  496, 1335, 1556,
 /*   870 */  1701, 1890,  491,  530, 1701, 1335,   44,   42, 1858,  575,
 /*   880 */   546, 1908, 1555,  546,  349,  576, 1329,  143, 1858,  601,
 /*   890 */  1701,    7,  237,  546, 1858,  542,  600, 1409, 1684, 1327,
 /*   900 */  1908,    8,  355, 1475, 1858,  544, 1858, 1858,  601, 1701,
 /*   910 */   154, 1858, 1701, 1858,  226,  600,  691, 1888, 1386, 1703,
 /*   920 */  1404, 1924, 1701,  691, 1858,  158, 1889, 1891,  604, 1893,
 /*   930 */  1894,  599, 1335,  594,  242,  402, 1888, 1411, 1412,   51,
 /*   940 */  1924,  546, 1545,  546,   97, 1889, 1891,  604, 1893, 1894,
 /*   950 */   599,  154,  594,  545,   80,  356,  223, 2065,    1, 1977,
 /*   960 */  1704,  595,  633,  342, 1973, 1744,  551, 2014,  634,  591,
 /*   970 */  1701, 1744, 1701, 2039,  279, 1604, 1330, 1731, 1328,   45,
 /*   980 */   691,   48,    4, 1330,   72, 1328,  210,  212,  214,  208,
 /*   990 */   211,  213,  231,  216, 1411, 1412,  215,  500,   50,  528,
 /*  1000 */  1333, 1334, 1547, 1548,   13,   12,  138, 1333, 1334, 1386,
 /*  1010 */  1384, 1385, 1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394,
 /*  1020 */   596,  592, 1402, 1403, 1405, 1406, 1407, 1408, 1410, 1413,
 /*  1030 */     3, 1278,  628, 1657, 1565,  579, 1338, 1544, 1599, 1597,
 /*  1040 */  1330,  142, 1328,   32,  235, 2017, 1879,   60,  261,   37,
 /*  1050 */    36,  143,   60,   43,   41,   40,   39,   38,  539, 1337,
 /*  1060 */   502,  505, 1103,  247, 1333, 1334, 1614, 1384, 1385, 1387,
 /*  1070 */  1388, 1389, 1390, 1391, 1392, 1393, 1394,  596,  592, 1402,
 /*  1080 */  1403, 1405, 1406, 1407, 1408, 1410, 1413,    3,  309,  482,
 /*  1090 */  1352,   93, 1472,  239, 1881, 1104,  643,  425,  644, 1446,
 /*  1100 */   437,   90,  577, 1174, 1502,  255,   37,   36, 1430,  560,
 /*  1110 */    43,   41,   40,   39,   38,  250,   45,  410, 1123,  438,
 /*  1120 */  1121,  412, 1909,  360, 1588, 1741, 2007,  585,  263,  668,
 /*  1130 */   667,  666,  665,  359,   45,  664,  663,  133,  658,  657,
 /*  1140 */   656,  655,  654,  653,  652,  651,  147,  647,  646,  645,
 /*  1150 */   358,  357,  642,  641,  640,  639,  638,  155,  260,    2,
 /*  1160 */     5,  370,  285,  322,  365,  320,   37,   36, 1395, 1294,
 /*  1170 */    43,   41,   40,   39,   38,  398,  283,   66,  388, 1341,
 /*  1180 */    65, 1593,  275,  608,   37,   36,  278,  182,   43,   41,
 /*  1190 */    40,   39,   38, 1515,  142,  529,  189,  443,  441, 1352,
 /*  1200 */   397,  401, 1340,  436,  419, 1890,  431,  430,  429,  428,
 /*  1210 */   427,  424,  423,  422,  421,  420,  416,  415,  414,  413,
 /*  1220 */   407,  406,  405,  404, 2045,  400,  399,  321, 1797,  686,
 /*  1230 */   426,  440,  434,   58, 1908, 1202,  143,  433,  122, 2051,
 /*  1240 */   171,  435,  601,  186, 2046,  573, 1206, 1858,  439,  600,
 /*  1250 */   142,   37,   36, 1495,  580,   43,   41,   40,   39,   38,
 /*  1260 */   442, 1358,  444,  445,  453, 1360,  456,  192,  457,  194,
 /*  1270 */  1888,   96, 1359, 1361, 1924,  458,  459,  197,   97, 1889,
 /*  1280 */  1891,  604, 1893, 1894,  599,  461,  594,  199, 1213,  129,
 /*  1290 */  1211,  141, 1948, 1977,   75,  465,   76,  342, 1973,  484,
 /*  1300 */   203,  532,  146,  362,  315,  486, 1691,   71,   70,  391,
 /*  1310 */   361,  100,  178,  311,  207, 1687, 1890,  516,  529,  209,
 /*  1320 */   529,  148,  149, 1689,  518, 1685,  276,  529,  150,  308,
 /*  1330 */   151, 1836,  379,  519,  377,  373,  369,  366,  363,  153,
 /*  1340 */   221,  520,  523,  224,  526, 1908, 1438, 2045,  228, 2045,
 /*  1350 */   531,  558,  139,  601,  140,  534, 2045,  541, 1858,  540,
 /*  1360 */   600,  517, 2051,  171, 2051,  171,  331, 2046,  573, 2046,
 /*  1370 */   573, 2051,  171, 1835, 1807,   84, 2046,  573,  529,  537,
 /*  1380 */   174, 1888,  277,  333,   86, 1924, 1702, 1357,  554,   97,
 /*  1390 */  1889, 1891,  604, 1893, 1894,  599,  561,  594, 2008, 2018,
 /*  1400 */  2023, 1439, 2065,  245, 1977,  556,  557, 2045,  342, 1973,
 /*  1410 */   694,  338,  249,  564, 2022,    6,  570,  254, 1996,  555,
 /*  1420 */  1999, 1890, 2051,  171,  274,  553,  257, 2046,  573,  552,
 /*  1430 */   339,  162,  581,  256,  259,  131, 2044, 2068,  165,  578,
 /*  1440 */   258, 1472, 1356,  684,  680,  676,  672,  272, 1993,   57,
 /*  1450 */  1908,   88,  606, 1958, 1745, 1672,  262,  280,  601,  584,
 /*  1460 */   271,  687,   49, 1858, 1890,  600,  688,  292,  690,  306,
 /*  1470 */   303,   33,  346, 1433, 1434, 1435, 1436, 1437, 1441, 1442,
 /*  1480 */  1443, 1444,  284, 1852,   95,  302, 1888,  240,  132, 1851,
 /*  1490 */  1924,   68,  282, 1908,   97, 1889, 1891,  604, 1893, 1894,
 /*  1500 */   599,  601,  594, 1850, 1849,   69, 1858, 1952,  600, 1977,
 /*  1510 */  1846,  345,  344,  342, 1973,  367,  368, 1890,  372, 1321,
 /*  1520 */   543, 1343, 1322,  177, 1844,  130,  374,  375,  376, 1888,
 /*  1530 */  1843,  378, 1409, 1924, 1336, 1842,  380,   97, 1889, 1891,
 /*  1540 */   604, 1893, 1894,  599,  384,  594, 1908,  172, 1985, 1986,
 /*  1550 */  1950, 1990, 1977,  229,  601, 1404,  342, 1973, 1841, 1858,
 /*  1560 */   382,  600, 1840, 1297, 1296, 1818, 1817, 1335,  389,  390,
 /*  1570 */  1890, 1301, 1816,  222, 1815, 1266, 1790, 1789, 1787,  134,
 /*  1580 */  1786, 1785, 1888, 1788,  135, 1784, 1924, 1783, 1782, 1781,
 /*  1590 */    97, 1889, 1891,  604, 1893, 1894,  599, 1780,  594, 1908,
 /*  1600 */  1779,  408,  409,  549,  411, 1977, 1778,  601, 1777,  342,
 /*  1610 */  1973, 1776, 1858, 1890,  600,  590, 1775, 1774, 1773, 1772,
 /*  1620 */  1771, 1770, 1769, 1768, 1767, 1766, 1765, 1764,  136, 1763,
 /*  1630 */  1762, 1761, 1760, 1759, 1758, 1888, 1268, 1757, 1756, 1924,
 /*  1640 */  1755, 1754, 1908,   98, 1889, 1891,  604, 1893, 1894,  599,
 /*  1650 */   601,  594, 1619, 1618,  187, 1858, 1616,  600, 1977,  188,
 /*  1660 */  1584,  449, 1976, 1973, 1066, 1065, 1890,  123, 1583, 1831,
 /*  1670 */  1149, 1825, 1814,  198, 1813, 1344, 1799, 1339, 1888,  166,
 /*  1680 */  1680,  190, 1924,  191,  124,  196,   98, 1889, 1891,  604,
 /*  1690 */  1893, 1894,  599, 1615,  594, 1908, 1613,  466,  468, 1347,
 /*  1700 */  1349, 1977,  467,  598,  451,  589, 1973, 1611, 1858,  472,
 /*  1710 */   600, 1096,  470,  592, 1402, 1403, 1405, 1406, 1407, 1408,
 /*  1720 */   471, 1609, 1890,  474,  476,  475, 1607,  478,  479,  480,
 /*  1730 */  1596, 1888, 1595, 1580, 1682, 1924, 1217, 1216, 1681,  300,
 /*  1740 */  1889, 1891,  604, 1893, 1894,  599,  597,  594,  547, 1942,
 /*  1750 */  1133, 1908, 1140,  659, 1139, 1138,  661,   59,  206,  601,
 /*  1760 */  1135, 1605, 1134,  327, 1858, 1600,  600,  328, 1598,  329,
 /*  1770 */  1132,  503,  506, 1579,  508, 1578, 1577,  510,  512,   99,
 /*  1780 */  1830, 1313, 1824,   25, 1890, 1303,  152, 1888,  521,  504,
 /*  1790 */  1812, 1924, 1810, 1811, 2050,  159, 1889, 1891,  604, 1893,
 /*  1800 */  1894,  599, 1809,  594,  514,   53, 1808,  522,  225,  230,
 /*  1810 */    18, 1806, 1311, 1908, 1798,   90,  241,  236,  218, 1421,
 /*  1820 */    83,  601,   19,   82,  330,   85, 1858,  538,  600,   20,
 /*  1830 */   527,   10,  507, 1420,  238,   15,  501,   27,   56, 1517,
 /*  1840 */   244,  217, 1890,  246, 1499,  248,  160,  574, 2066, 1888,
 /*  1850 */  1501,  535,  251, 1924,   28,  252,  253,   98, 1889, 1891,
 /*  1860 */   604, 1893, 1894,  599, 1890,  594, 1494, 1879,   89,   29,
 /*  1870 */    61, 1908, 1977, 1537,   22, 1532,  332, 1974,   64,  601,
 /*  1880 */  1531,   63, 1538,  340, 1858, 1536,  600, 1535,  341, 1469,
 /*  1890 */   265, 1468,   55, 1908,   12, 1345, 1399, 1878, 1431, 1927,
 /*  1900 */   163,  598,  593,  164, 1397,  175, 1858, 1888,  600,   35,
 /*  1910 */    14, 1924,   21, 1396,   23,  301, 1889, 1891,  604, 1893,
 /*  1920 */  1894,  599,   54,  594, 1890, 1369, 1377,   16,   24, 1888,
 /*  1930 */   605, 1203,  607, 1924,  351,  609,  611,  300, 1889, 1891,
 /*  1940 */   604, 1893, 1894,  599,  614,  594,  617, 1943,  620, 1180,
 /*  1950 */  1200, 1197,  612, 1908,  615,  603, 1191,  618, 1212, 1189,
 /*  1960 */   621,  601,  269, 1208, 1195, 1194, 1858, 1890,  600,   91,
 /*  1970 */    92,   67, 1094,  636, 1129,  627, 1147, 1128, 1127, 1126,
 /*  1980 */  1193, 1125, 1124,  270, 1890, 1122, 1192, 1120, 1119, 1888,
 /*  1990 */  1118,  648, 1116, 1924, 1115, 1114, 1908,  158, 1889, 1891,
 /*  2000 */   604, 1893, 1894,  599,  601,  594, 1113, 1112, 1100, 1858,
 /*  2010 */  1111,  600, 1110, 1908, 1109, 1142, 1106, 1144, 1105, 1102,
 /*  2020 */  1612,  601, 1101, 1099,  669,  670, 1858, 1610,  600,  671,
 /*  2030 */   673,  675, 1888, 1608,  677,  679, 1924, 1606, 1890, 2015,
 /*  2040 */   296, 1889, 1891,  604, 1893, 1894,  599,  674,  594, 1888,
 /*  2050 */   678,  681,  682, 1924,  683, 1594, 1890,  159, 1889, 1891,
 /*  2060 */   604, 1893, 1894,  599,  685,  594, 1056, 1908, 1576,  273,
 /*  2070 */   689,  692,  347, 1331,  281,  601,  693, 1551, 1551, 1551,
 /*  2080 */  1858, 1551,  600, 1551,  569, 1908, 1551, 1551, 1551, 1551,
 /*  2090 */   350, 1551, 1551,  601, 1551, 1551, 1551, 1551, 1858, 1551,
 /*  2100 */   600, 1551, 1551, 1888, 1551, 1551, 1551, 1924, 1551, 1551,
 /*  2110 */  2067,  301, 1889, 1891,  604, 1893, 1894,  599, 1890,  594,
 /*  2120 */  1551, 1888, 1551, 1551, 1551, 1924, 1551, 1551, 1551,  301,
 /*  2130 */  1889, 1891,  604, 1893, 1894,  599, 1551,  594, 1551, 1551,
 /*  2140 */  1551, 1551, 1890, 1551, 1551, 1551, 1551, 1908, 1551, 1551,
 /*  2150 */  1551, 1551, 1551, 1551, 1551,  601, 1551, 1551, 1551, 1551,
 /*  2160 */  1858, 1551,  600, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2170 */  1551, 1908, 1551, 1551, 1551, 1551, 1551, 1551, 1551,  601,
 /*  2180 */  1551, 1551, 1551,  515, 1858, 1890,  600, 1924, 1551, 1551,
 /*  2190 */  1551,  294, 1889, 1891,  604, 1893, 1894,  599, 1551,  594,
 /*  2200 */  1551, 1551, 1551, 1551, 1551, 1890, 1551, 1888, 1551, 1551,
 /*  2210 */  1551, 1924, 1551, 1551, 1908,  286, 1889, 1891,  604, 1893,
 /*  2220 */  1894,  599,  601,  594, 1551, 1551, 1551, 1858, 1551,  600,
 /*  2230 */  1551, 1551, 1551, 1551, 1908, 1551, 1551, 1551, 1551, 1551,
 /*  2240 */  1551, 1551,  601, 1551, 1551, 1551, 1551, 1858, 1551,  600,
 /*  2250 */  1888, 1551, 1551, 1551, 1924, 1551, 1551, 1551,  287, 1889,
 /*  2260 */  1891,  604, 1893, 1894,  599, 1551,  594, 1551, 1890, 1551,
 /*  2270 */  1888, 1551, 1551, 1551, 1924, 1551, 1551, 1551,  288, 1889,
 /*  2280 */  1891,  604, 1893, 1894,  599, 1551,  594, 1890, 1551, 1551,
 /*  2290 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1908, 1551, 1551,
 /*  2300 */  1551, 1551, 1551, 1551, 1551,  601, 1551, 1551, 1551, 1551,
 /*  2310 */  1858, 1551,  600, 1551, 1551, 1551, 1908, 1551, 1551, 1551,
 /*  2320 */  1551, 1551, 1551, 1551,  601, 1551, 1551, 1551, 1551, 1858,
 /*  2330 */  1890,  600, 1551, 1888, 1551, 1551, 1551, 1924, 1551, 1551,
 /*  2340 */  1551,  295, 1889, 1891,  604, 1893, 1894,  599, 1551,  594,
 /*  2350 */  1551, 1551, 1888, 1551, 1551, 1551, 1924, 1551, 1551, 1908,
 /*  2360 */   297, 1889, 1891,  604, 1893, 1894,  599,  601,  594, 1551,
 /*  2370 */  1551, 1551, 1858, 1551,  600, 1551, 1551, 1551, 1551, 1551,
 /*  2380 */  1551, 1890, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2390 */  1551, 1551, 1551, 1551, 1551, 1888, 1551, 1551, 1551, 1924,
 /*  2400 */  1551, 1890, 1551,  289, 1889, 1891,  604, 1893, 1894,  599,
 /*  2410 */  1908,  594, 1551, 1551, 1551, 1551, 1551, 1551,  601, 1551,
 /*  2420 */  1551, 1551, 1551, 1858, 1551,  600, 1551, 1551, 1551, 1551,
 /*  2430 */  1908, 1551, 1551, 1551, 1551, 1551, 1551, 1551,  601, 1551,
 /*  2440 */  1551, 1551, 1551, 1858, 1551,  600, 1888, 1551, 1551, 1551,
 /*  2450 */  1924, 1551, 1890, 1551,  298, 1889, 1891,  604, 1893, 1894,
 /*  2460 */   599, 1551,  594, 1551, 1551, 1551, 1888, 1551, 1551, 1551,
 /*  2470 */  1924, 1551, 1551, 1551,  290, 1889, 1891,  604, 1893, 1894,
 /*  2480 */   599, 1908,  594, 1551, 1551, 1551, 1551, 1551, 1551,  601,
 /*  2490 */  1551, 1551, 1551, 1551, 1858, 1551,  600, 1551, 1551, 1551,
 /*  2500 */  1551, 1551, 1551, 1551, 1551, 1890, 1551, 1551, 1551, 1551,
 /*  2510 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1888, 1551, 1551,
 /*  2520 */  1551, 1924, 1551, 1551, 1551,  299, 1889, 1891,  604, 1893,
 /*  2530 */  1894,  599, 1551,  594, 1908, 1551, 1551, 1551, 1551, 1551,
 /*  2540 */  1551, 1551,  601, 1551, 1551, 1551, 1551, 1858, 1890,  600,
 /*  2550 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2560 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1890, 1551,
 /*  2570 */  1888, 1551, 1551, 1551, 1924, 1551, 1551, 1908,  291, 1889,
 /*  2580 */  1891,  604, 1893, 1894,  599,  601,  594, 1551, 1551, 1551,
 /*  2590 */  1858, 1551,  600, 1551, 1551, 1551, 1551, 1908, 1551, 1551,
 /*  2600 */  1551, 1551, 1551, 1551, 1551,  601, 1551, 1551, 1551, 1551,
 /*  2610 */  1858, 1551,  600, 1888, 1551, 1551, 1551, 1924, 1551, 1551,
 /*  2620 */  1551,  304, 1889, 1891,  604, 1893, 1894,  599, 1551,  594,
 /*  2630 */  1551, 1890, 1551, 1888, 1551, 1551, 1551, 1924, 1551, 1551,
 /*  2640 */  1551,  305, 1889, 1891,  604, 1893, 1894,  599, 1551,  594,
 /*  2650 */  1890, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2660 */  1908, 1551, 1551, 1551, 1551, 1551, 1551, 1551,  601, 1551,
 /*  2670 */  1551, 1551, 1551, 1858, 1551,  600, 1551, 1551, 1551, 1908,
 /*  2680 */  1551, 1551, 1551, 1551, 1551, 1551, 1551,  601, 1551, 1551,
 /*  2690 */  1551, 1551, 1858, 1890,  600, 1551, 1888, 1551, 1551, 1551,
 /*  2700 */  1924, 1551, 1551, 1551, 1902, 1889, 1891,  604, 1893, 1894,
 /*  2710 */   599, 1551,  594, 1551, 1551, 1888, 1551, 1551, 1551, 1924,
 /*  2720 */  1551, 1551, 1908, 1901, 1889, 1891,  604, 1893, 1894,  599,
 /*  2730 */   601,  594, 1551, 1551, 1551, 1858, 1551,  600, 1551, 1551,
 /*  2740 */  1551, 1551, 1551, 1551, 1890, 1551, 1551, 1551, 1551, 1551,
 /*  2750 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1888, 1551,
 /*  2760 */  1551, 1551, 1924, 1551, 1890, 1551, 1900, 1889, 1891,  604,
 /*  2770 */  1893, 1894,  599, 1908,  594, 1551, 1551, 1551, 1551, 1551,
 /*  2780 */  1551,  601, 1551, 1551, 1551, 1551, 1858, 1551,  600, 1551,
 /*  2790 */  1551, 1551, 1551, 1908, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2800 */  1551,  601, 1551, 1551, 1551, 1551, 1858, 1551,  600, 1888,
 /*  2810 */  1551, 1551, 1551, 1924, 1551, 1890, 1551,  316, 1889, 1891,
 /*  2820 */   604, 1893, 1894,  599, 1551,  594, 1551, 1551, 1551, 1888,
 /*  2830 */  1551, 1551, 1551, 1924, 1551, 1551, 1551,  317, 1889, 1891,
 /*  2840 */   604, 1893, 1894,  599, 1908,  594, 1551, 1551, 1551, 1551,
 /*  2850 */  1551, 1551,  601, 1551, 1551, 1551, 1551, 1858, 1551,  600,
 /*  2860 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1890, 1551,
 /*  2870 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2880 */  1888, 1551, 1551, 1551, 1924, 1551, 1551, 1551,  313, 1889,
 /*  2890 */  1891,  604, 1893, 1894,  599, 1551,  594, 1908, 1551, 1551,
 /*  2900 */  1551, 1551, 1551, 1551, 1551,  601, 1551, 1551, 1551, 1551,
 /*  2910 */  1858, 1890,  600, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2920 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2930 */  1551, 1551, 1551, 1888, 1551, 1551, 1551, 1924, 1551, 1551,
 /*  2940 */  1908,  318, 1889, 1891,  604, 1893, 1894,  599,  601,  594,
 /*  2950 */  1551, 1551, 1551, 1858, 1551,  600, 1551, 1551, 1551, 1551,
 /*  2960 */  1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551, 1551,
 /*  2970 */  1551, 1551, 1551, 1551, 1551, 1551, 1888, 1551, 1551, 1551,
 /*  2980 */  1924, 1551, 1551, 1551,  293, 1889, 1891,  604, 1893, 1894,
 /*  2990 */   599, 1551,  594,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   351,  409,  410,  351,    0,    4,  324,  320,  326,  327,
 /*    10 */   351,  362,   12,   13,  362,  324,  328,  326,  327,  350,
 /*    20 */    20,  362,   22,   12,   13,   14,   15,   16,   20,   14,
 /*    30 */    15,   16,  319,   33,  321,   35,  349,  388,  389,  390,
 /*    40 */   388,  389,  390,   20,  357,   44,   45,  388,  389,  362,
 /*    50 */   401,  364,    2,  401,  366,  320,   56,   20,    8,    9,
 /*    60 */   401,   61,   12,   13,   14,   15,   16,  320,   68,   12,
 /*    70 */    13,   14,  385,   20,   60,   22,  389,   20,  394,   22,
 /*    80 */   393,  394,  395,  396,  397,  398,  399,  320,  401,    3,
 /*    90 */    33,   60,   35,  406,   94,  408,  349,  362,   20,  412,
 /*   100 */   413,   20,  341,   50,  357,  328,   20,  423,  349,  362,
 /*   110 */   349,  364,  425,   56,  320,  356,  116,   94,   61,  358,
 /*   120 */   433,  328,  438,  439,  365,   68,    0,  443,  444,  362,
 /*   130 */   130,  131,  385,  340,  357,    0,  389,    0,  130,  131,
 /*   140 */   393,  394,  395,  396,  397,  398,  399,  364,  401,  360,
 /*   150 */   357,   94,  363,  364,  371,  408,  362,  374,   21,  412,
 /*   160 */   413,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   170 */   423,  394,  333,  116,   14,   94,  176,  338,  178,   94,
 /*   180 */    20,   95,   47,   21,  320,  438,  439,  130,  131,   56,
 /*   190 */   443,  444,  415,  416,  417,  418,   34,  420,   36,   20,
 /*   200 */   200,  201,  391,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,   33,  325,  362,   94,  328,   96,
 /*   230 */   419,  325,  106,  176,  328,  178,    0,  342,   47,    0,
 /*   240 */   345,  241,  200,   52,   53,   54,   55,   56,  351,  163,
 /*   250 */    94,  125,  126,  127,  128,  129,  105,  200,  201,  362,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   280 */   223,   12,   13,  225,   93,  388,  389,   96,  225,   20,
 /*   290 */   227,   22,  250,  251,  252,  253,  254,  126,  401,   63,
 /*   300 */    64,   65,   33,  328,   35,   94,   21,   71,   72,   24,
 /*   310 */    25,   26,   27,   28,   29,   30,   31,   32,   82,   83,
 /*   320 */    20,  106,  241,  328,   88,   56,  241,    4,  363,  364,
 /*   330 */    61,  394,  357,  320,  348,  340,    0,   68,   12,   13,
 /*   340 */   125,  126,  127,  128,  129,  106,   20,  361,   22,  328,
 /*   350 */   159,  160,  357,  162,  183,  184,  349,  166,  187,   33,
 /*   360 */   423,   35,  349,   94,  125,  126,  127,  128,  129,  394,
 /*   370 */   357,  349,  365,  182,  241,  362,  439,  364,  357,  357,
 /*   380 */   443,  444,   56,   35,   20,  116,  175,   61,  177,  125,
 /*   390 */   126,  416,  417,  418,   68,  420,   60,  241,  385,  130,
 /*   400 */   131,  330,  389,    0,   20,  341,  393,  394,  395,  396,
 /*   410 */   397,  398,  399,  349,  401,  394,   68,   94,  396,  406,
 /*   420 */    94,  408,  358,  352,  328,  412,  413,   24,   25,   26,
 /*   430 */    27,   28,   29,   30,   31,   32,  340,  416,  417,  418,
 /*   440 */   332,  420,  116,  347,  423,  176,  433,  178,  184,  335,
 /*   450 */   336,  187,  241,  357,  346,  349,  130,  131,   94,  438,
 /*   460 */   439,  320,  356,  355,  443,  444,  405,  350,  407,  200,
 /*   470 */   201,  365,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   480 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   490 */   221,  222,  223,  161,  225,  405,  373,  407,  375,   78,
 /*   500 */   335,  336,  176,  362,  178,  332,  107,  108,  109,  110,
 /*   510 */   111,  112,  113,  114,  115,  116,  117,  320,  119,  120,
 /*   520 */   121,  122,  123,  124,  320,  394,  200,  201,  355,  203,
 /*   530 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   540 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   550 */    12,   13,  364,  328,  423,  134,  135,  320,   20,  362,
 /*   560 */    22,   20,  374,   22,  241,  340,  362,  391,   44,   45,
 /*   570 */   439,   33,  347,   35,  443,  444,   35,  171,  246,  247,
 /*   580 */     8,    9,  357,  320,   12,   13,   14,   15,   16,  328,
 /*   590 */    14,   50,   20,  391,   56,  419,   20,  191,  192,  362,
 /*   600 */   404,  340,  320,  407,  328,  241,   68,   12,   13,   14,
 /*   610 */    56,  328,  349,  320,  328,   20,  340,   22,  357,  381,
 /*   620 */   357,  419,   37,  340,    3,  362,  340,  364,   33,  349,
 /*   630 */    35,  349,   94,  357,   68,  158,  356,  328,   20,  357,
 /*   640 */   357,  328,   68,  357,  362,  365,  364,   93,  385,  340,
 /*   650 */    96,   56,  389,  340,  116,  362,  393,  394,  395,  396,
 /*   660 */   397,  398,  399,   68,  401,    4,  357,  385,  130,  131,
 /*   670 */   357,  389,  125,    3,  394,  393,  394,  395,  396,  397,
 /*   680 */   398,  399,   97,  401,   99,  100,  423,  102,  406,   94,
 /*   690 */   408,  106,    8,    9,  412,  413,   12,   13,   14,   15,
 /*   700 */    16,  438,  439,  423,  422,  228,  443,  444,  328,   22,
 /*   710 */   357,  116,    0,  128,  176,  238,  178,  317,  438,  439,
 /*   720 */   340,  368,   35,  443,  444,  130,  131,   43,   14,  357,
 /*   730 */     1,    2,  185,  186,   20,  163,  320,  357,  200,  201,
 /*   740 */   368,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   750 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   760 */   222,  223,    8,    9,  328,   95,   12,   13,   14,   15,
 /*   770 */    16,  176,   60,  178,  357,  106,  340,  377,  362,  241,
 /*   780 */   204,  163,    8,    9,  320,  368,   12,   13,   14,   15,
 /*   790 */    16,   20,  320,  357,  394,  200,  201,  128,  203,  204,
 /*   800 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   810 */   215,  216,  217,  218,  219,  220,  221,  222,  223,   12,
 /*   820 */    13,  328,   22,  423,   95,   20,  362,   20,  373,   22,
 /*   830 */   375,  239,  240,  340,  362,   35,  320,  330,  438,  439,
 /*   840 */    33,  328,   35,  443,  444,  328,  320,   63,   64,   65,
 /*   850 */   357,  344,  320,  340,  350,   71,   72,  340,  337,  352,
 /*   860 */   339,  328,  320,   56,  320,  320,   82,   83,   68,  320,
 /*   870 */   357,  320,   88,  340,  357,   68,   12,   13,  362,  258,
 /*   880 */   328,  349,  320,  328,   20,   43,   22,   43,  362,  357,
 /*   890 */   357,   39,  340,  328,  362,  340,  364,   33,  350,   35,
 /*   900 */   349,   94,  341,  242,  362,  340,  362,  362,  357,  357,
 /*   910 */   349,  362,  357,  362,   56,  364,  116,  385,  204,  358,
 /*   920 */    56,  389,  357,  116,  362,  393,  394,  395,  396,  397,
 /*   930 */   398,  399,   68,  401,  163,  105,  385,  130,  131,   95,
 /*   940 */   389,  328,  168,  328,  393,  394,  395,  396,  397,  398,
 /*   950 */   399,  349,  401,  340,   96,  340,  350,  406,   94,  408,
 /*   960 */   358,  350,  359,  412,  413,  362,  434,  435,  359,   61,
 /*   970 */   357,  362,  357,  422,  342,    0,  176,  345,  178,   43,
 /*   980 */   116,   42,   43,  176,  154,  178,   98,   98,   98,  101,
 /*   990 */   101,  101,   43,   98,  130,  131,  101,   22,  163,  164,
 /*  1000 */   200,  201,  130,  131,    1,    2,   43,  200,  201,  204,
 /*  1010 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*  1020 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*  1030 */   223,   95,  350,  338,  321,   43,   35,  263,    0,    0,
 /*  1040 */   176,   43,  178,    2,   95,  392,   46,   43,  447,    8,
 /*  1050 */     9,   43,   43,   12,   13,   14,   15,   16,   95,   35,
 /*  1060 */    22,   22,   35,   43,  200,  201,    0,  203,  204,  205,
 /*  1070 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1080 */   216,  217,  218,  219,  220,  221,  222,  223,   18,  329,
 /*  1090 */    20,   94,  240,   95,   94,   68,   13,   27,   13,   95,
 /*  1100 */    30,  104,  260,   95,   95,  430,    8,    9,  200,  436,
 /*  1110 */    12,   13,   14,   15,   16,   95,   43,   47,   35,   49,
 /*  1120 */    35,   51,  349,  329,  327,  361,  392,  421,  440,   63,
 /*  1130 */    64,   65,   66,   67,   43,   69,   70,   71,   72,   73,
 /*  1140 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*  1150 */    84,   85,   86,   87,   88,   89,   90,   18,  414,  424,
 /*  1160 */   243,   47,   23,   93,  387,  386,    8,    9,   95,  174,
 /*  1170 */    12,   13,   14,   15,   16,  105,   37,   38,  377,  178,
 /*  1180 */    41,    0,  379,   43,    8,    9,   95,   42,   12,   13,
 /*  1190 */    14,   15,   16,   95,   43,  394,   57,   58,   59,   20,
 /*  1200 */   369,  369,  178,  133,  328,  320,  136,  137,  138,  139,
 /*  1210 */   140,  141,  142,  143,  144,  145,  146,  147,  148,  149,
 /*  1220 */   150,  151,  152,  153,  423,  155,  156,  157,  328,   48,
 /*  1230 */   369,  334,  158,   94,  349,   95,   43,  367,   43,  438,
 /*  1240 */   439,  367,  357,  328,  443,  444,   95,  362,   92,  364,
 /*  1250 */    43,    8,    9,   95,  262,   12,   13,   14,   15,   16,
 /*  1260 */   328,   20,  328,  322,  322,   20,  383,  332,  364,  332,
 /*  1270 */   385,  132,   20,   20,  389,  376,  378,  332,  393,  394,
 /*  1280 */   395,  396,  397,  398,  399,  376,  401,  332,   95,  404,
 /*  1290 */    95,  406,  407,  408,  332,  328,  332,  412,  413,  322,
 /*  1300 */   332,  377,   95,  377,   61,  349,  349,  168,  169,  170,
 /*  1310 */   377,  328,  173,  322,  349,  349,  320,  189,  394,  349,
 /*  1320 */   394,  349,  349,  349,  384,  349,  383,  394,  349,  190,
 /*  1330 */   349,  362,  193,  181,  195,  196,  197,  198,  199,  163,
 /*  1340 */   330,  382,  364,  330,  328,  349,  103,  423,  330,  423,
 /*  1350 */   328,  248,  372,  357,  372,  362,  423,  370,  362,  160,
 /*  1360 */   364,  377,  438,  439,  438,  439,  376,  443,  444,  443,
 /*  1370 */   444,  438,  439,  362,  362,  330,  443,  444,  394,  362,
 /*  1380 */   241,  385,  345,  362,  330,  389,  357,   20,  362,  393,
 /*  1390 */   394,  395,  396,  397,  398,  399,  249,  401,  392,  392,
 /*  1400 */   429,  158,  406,  372,  408,  362,  362,  423,  412,  413,
 /*  1410 */    19,  362,  372,  362,  429,  255,  167,  431,  422,  257,
 /*  1420 */   432,  320,  438,  439,   33,  256,  427,  443,  444,  244,
 /*  1430 */   264,  429,  261,  428,  387,  357,  442,  448,   47,  259,
 /*  1440 */   426,  240,   20,   52,   53,   54,   55,   56,  391,   94,
 /*  1450 */   349,   94,  353,  411,  362,  339,  441,  328,  357,  328,
 /*  1460 */   330,   36,  380,  362,  320,  364,  323,  343,  322,  375,
 /*  1470 */   343,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*  1480 */   237,  238,  318,    0,   93,  343,  385,   96,  357,    0,
 /*  1490 */   389,  183,  331,  349,  393,  394,  395,  396,  397,  398,
 /*  1500 */   399,  357,  401,    0,    0,   42,  362,  406,  364,  408,
 /*  1510 */     0,   12,   13,  412,  413,   35,  194,  320,  194,   35,
 /*  1520 */   129,   22,   35,   35,    0,  394,   35,   35,  194,  385,
 /*  1530 */     0,  194,   33,  389,   35,    0,   35,  393,  394,  395,
 /*  1540 */   396,  397,  398,  399,   35,  401,  349,  416,  417,  418,
 /*  1550 */   406,  420,  408,  162,  357,   56,  412,  413,    0,  362,
 /*  1560 */    22,  364,    0,  178,  176,    0,    0,   68,  172,  171,
 /*  1570 */   320,  180,    0,  182,    0,   46,    0,    0,    0,   42,
 /*  1580 */     0,    0,  385,    0,   42,    0,  389,    0,    0,    0,
 /*  1590 */   393,  394,  395,  396,  397,  398,  399,    0,  401,  349,
 /*  1600 */     0,  149,   35,  406,  149,  408,    0,  357,    0,  412,
 /*  1610 */   413,    0,  362,  320,  364,  116,    0,    0,    0,    0,
 /*  1620 */     0,    0,    0,    0,    0,    0,    0,    0,   42,    0,
 /*  1630 */     0,    0,    0,    0,    0,  385,   22,    0,    0,  389,
 /*  1640 */     0,    0,  349,  393,  394,  395,  396,  397,  398,  399,
 /*  1650 */   357,  401,    0,    0,   56,  362,    0,  364,  408,   56,
 /*  1660 */     0,   46,  412,  413,   14,   14,  320,   39,    0,    0,
 /*  1670 */    35,    0,    0,  167,    0,  176,    0,  178,  385,   43,
 /*  1680 */     0,   42,  389,   40,   39,   39,  393,  394,  395,  396,
 /*  1690 */   397,  398,  399,    0,  401,  349,    0,   35,   39,  200,
 /*  1700 */   201,  408,   47,  357,   46,  412,  413,    0,  362,   39,
 /*  1710 */   364,   62,   35,  214,  215,  216,  217,  218,  219,  220,
 /*  1720 */    47,    0,  320,   35,   39,   47,    0,   35,   47,   39,
 /*  1730 */     0,  385,    0,    0,    0,  389,   35,   22,    0,  393,
 /*  1740 */   394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
 /*  1750 */    22,  349,   35,   43,   35,   35,   43,  103,  101,  357,
 /*  1760 */    35,    0,   35,   22,  362,    0,  364,   22,    0,   22,
 /*  1770 */    35,   49,   35,    0,   35,    0,    0,   35,   22,   20,
 /*  1780 */     0,   95,    0,   94,  320,   35,  179,  385,   22,    4,
 /*  1790 */     0,  389,    0,    0,    3,  393,  394,  395,  396,  397,
 /*  1800 */   398,  399,    0,  401,   19,  163,    0,  163,  160,   95,
 /*  1810 */    94,    0,   35,  349,    0,  104,   46,   94,   33,  224,
 /*  1820 */    39,  357,   43,   94,  163,   94,  362,  161,  364,   43,
 /*  1830 */   165,  226,   47,  224,  159,  245,   51,   94,   43,   95,
 /*  1840 */    94,   56,  320,   95,   95,   94,   94,  445,  446,  385,
 /*  1850 */    95,  188,   94,  389,   94,   43,   46,  393,  394,  395,
 /*  1860 */   396,  397,  398,  399,  320,  401,   95,   46,   94,   43,
 /*  1870 */     3,  349,  408,   95,   43,   35,  354,  413,   93,  357,
 /*  1880 */    35,   96,   95,   35,  362,   35,  364,   35,   35,   95,
 /*  1890 */    46,   95,   43,  349,    2,   22,   95,   46,  200,   94,
 /*  1900 */    46,  357,   94,   46,   95,   46,  362,  385,  364,   94,
 /*  1910 */    94,  389,  245,   95,   94,  393,  394,  395,  396,  397,
 /*  1920 */   398,  399,  239,  401,  320,   95,   22,  245,   94,  385,
 /*  1930 */   105,   95,   35,  389,   35,   94,   35,  393,  394,  395,
 /*  1940 */   396,  397,  398,  399,   35,  401,   35,  403,   35,   22,
 /*  1950 */    95,   95,   94,  349,   94,  202,   95,   94,   35,   95,
 /*  1960 */    94,  357,   43,   22,  118,  118,  362,  320,  364,   94,
 /*  1970 */    94,   94,   62,   61,   35,  106,   68,   35,   35,   35,
 /*  1980 */   118,   35,   35,   43,  320,   35,  118,   35,   35,  385,
 /*  1990 */    35,   91,   35,  389,   35,   22,  349,  393,  394,  395,
 /*  2000 */   396,  397,  398,  399,  357,  401,   35,   22,   22,  362,
 /*  2010 */    35,  364,   35,  349,   35,   35,   35,   68,   35,   35,
 /*  2020 */     0,  357,   35,   35,   35,   47,  362,    0,  364,   39,
 /*  2030 */    35,   39,  385,    0,   35,   39,  389,    0,  320,  435,
 /*  2040 */   393,  394,  395,  396,  397,  398,  399,   47,  401,  385,
 /*  2050 */    47,   35,   47,  389,   39,    0,  320,  393,  394,  395,
 /*  2060 */   396,  397,  398,  399,   35,  401,   35,  349,    0,   22,
 /*  2070 */    21,   21,  354,   22,   22,  357,   20,  449,  449,  449,
 /*  2080 */   362,  449,  364,  449,  437,  349,  449,  449,  449,  449,
 /*  2090 */   354,  449,  449,  357,  449,  449,  449,  449,  362,  449,
 /*  2100 */   364,  449,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2110 */   446,  393,  394,  395,  396,  397,  398,  399,  320,  401,
 /*  2120 */   449,  385,  449,  449,  449,  389,  449,  449,  449,  393,
 /*  2130 */   394,  395,  396,  397,  398,  399,  449,  401,  449,  449,
 /*  2140 */   449,  449,  320,  449,  449,  449,  449,  349,  449,  449,
 /*  2150 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2160 */   362,  449,  364,  449,  449,  449,  449,  449,  449,  449,
 /*  2170 */   449,  349,  449,  449,  449,  449,  449,  449,  449,  357,
 /*  2180 */   449,  449,  449,  385,  362,  320,  364,  389,  449,  449,
 /*  2190 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2200 */   449,  449,  449,  449,  449,  320,  449,  385,  449,  449,
 /*  2210 */   449,  389,  449,  449,  349,  393,  394,  395,  396,  397,
 /*  2220 */   398,  399,  357,  401,  449,  449,  449,  362,  449,  364,
 /*  2230 */   449,  449,  449,  449,  349,  449,  449,  449,  449,  449,
 /*  2240 */   449,  449,  357,  449,  449,  449,  449,  362,  449,  364,
 /*  2250 */   385,  449,  449,  449,  389,  449,  449,  449,  393,  394,
 /*  2260 */   395,  396,  397,  398,  399,  449,  401,  449,  320,  449,
 /*  2270 */   385,  449,  449,  449,  389,  449,  449,  449,  393,  394,
 /*  2280 */   395,  396,  397,  398,  399,  449,  401,  320,  449,  449,
 /*  2290 */   449,  449,  449,  449,  449,  449,  449,  349,  449,  449,
 /*  2300 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2310 */   362,  449,  364,  449,  449,  449,  349,  449,  449,  449,
 /*  2320 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2330 */   320,  364,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2340 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2350 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  349,
 /*  2360 */   393,  394,  395,  396,  397,  398,  399,  357,  401,  449,
 /*  2370 */   449,  449,  362,  449,  364,  449,  449,  449,  449,  449,
 /*  2380 */   449,  320,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2390 */   449,  449,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2400 */   449,  320,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2410 */   349,  401,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2420 */   449,  449,  449,  362,  449,  364,  449,  449,  449,  449,
 /*  2430 */   349,  449,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2440 */   449,  449,  449,  362,  449,  364,  385,  449,  449,  449,
 /*  2450 */   389,  449,  320,  449,  393,  394,  395,  396,  397,  398,
 /*  2460 */   399,  449,  401,  449,  449,  449,  385,  449,  449,  449,
 /*  2470 */   389,  449,  449,  449,  393,  394,  395,  396,  397,  398,
 /*  2480 */   399,  349,  401,  449,  449,  449,  449,  449,  449,  357,
 /*  2490 */   449,  449,  449,  449,  362,  449,  364,  449,  449,  449,
 /*  2500 */   449,  449,  449,  449,  449,  320,  449,  449,  449,  449,
 /*  2510 */   449,  449,  449,  449,  449,  449,  449,  385,  449,  449,
 /*  2520 */   449,  389,  449,  449,  449,  393,  394,  395,  396,  397,
 /*  2530 */   398,  399,  449,  401,  349,  449,  449,  449,  449,  449,
 /*  2540 */   449,  449,  357,  449,  449,  449,  449,  362,  320,  364,
 /*  2550 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2560 */   449,  449,  449,  449,  449,  449,  449,  449,  320,  449,
 /*  2570 */   385,  449,  449,  449,  389,  449,  449,  349,  393,  394,
 /*  2580 */   395,  396,  397,  398,  399,  357,  401,  449,  449,  449,
 /*  2590 */   362,  449,  364,  449,  449,  449,  449,  349,  449,  449,
 /*  2600 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2610 */   362,  449,  364,  385,  449,  449,  449,  389,  449,  449,
 /*  2620 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2630 */   449,  320,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2640 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2650 */   320,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2660 */   349,  449,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2670 */   449,  449,  449,  362,  449,  364,  449,  449,  449,  349,
 /*  2680 */   449,  449,  449,  449,  449,  449,  449,  357,  449,  449,
 /*  2690 */   449,  449,  362,  320,  364,  449,  385,  449,  449,  449,
 /*  2700 */   389,  449,  449,  449,  393,  394,  395,  396,  397,  398,
 /*  2710 */   399,  449,  401,  449,  449,  385,  449,  449,  449,  389,
 /*  2720 */   449,  449,  349,  393,  394,  395,  396,  397,  398,  399,
 /*  2730 */   357,  401,  449,  449,  449,  362,  449,  364,  449,  449,
 /*  2740 */   449,  449,  449,  449,  320,  449,  449,  449,  449,  449,
 /*  2750 */   449,  449,  449,  449,  449,  449,  449,  449,  385,  449,
 /*  2760 */   449,  449,  389,  449,  320,  449,  393,  394,  395,  396,
 /*  2770 */   397,  398,  399,  349,  401,  449,  449,  449,  449,  449,
 /*  2780 */   449,  357,  449,  449,  449,  449,  362,  449,  364,  449,
 /*  2790 */   449,  449,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2800 */   449,  357,  449,  449,  449,  449,  362,  449,  364,  385,
 /*  2810 */   449,  449,  449,  389,  449,  320,  449,  393,  394,  395,
 /*  2820 */   396,  397,  398,  399,  449,  401,  449,  449,  449,  385,
 /*  2830 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2840 */   396,  397,  398,  399,  349,  401,  449,  449,  449,  449,
 /*  2850 */   449,  449,  357,  449,  449,  449,  449,  362,  449,  364,
 /*  2860 */   449,  449,  449,  449,  449,  449,  449,  449,  320,  449,
 /*  2870 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2880 */   385,  449,  449,  449,  389,  449,  449,  449,  393,  394,
 /*  2890 */   395,  396,  397,  398,  399,  449,  401,  349,  449,  449,
 /*  2900 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2910 */   362,  320,  364,  449,  449,  449,  449,  449,  449,  449,
 /*  2920 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2930 */   449,  449,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2940 */   349,  393,  394,  395,  396,  397,  398,  399,  357,  401,
 /*  2950 */   449,  449,  449,  362,  449,  364,  449,  449,  449,  449,
 /*  2960 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2970 */   449,  449,  449,  449,  449,  449,  385,  449,  449,  449,
 /*  2980 */   389,  449,  449,  449,  393,  394,  395,  396,  397,  398,
 /*  2990 */   399,  449,  401,
};
#define YY_SHIFT_COUNT    (694)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2068)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1139,    0,   57,  269,   57,  326,  326,  326,  538,  326,
 /*    10 */   326,  326,  326,  326,  595,  807,  807,  864,  807,  807,
 /*    20 */   807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
 /*    30 */   807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
 /*    40 */   807,  807,  807,  807,  807,  807,   81,  364,   23,  211,
 /*    50 */   133,   85,  156,   85,   23,   23, 1499, 1499,   85, 1499,
 /*    60 */  1499,  323,   85,   37,   37,    1,    1,    8,   37,   37,
 /*    70 */    37,   37,   37,   37,   37,   37,   37,   37,   14,   37,
 /*    80 */    37,   37,   78,   37,   37,  179,   37,   37,  179,  300,
 /*    90 */    37,  179,  179,  179,   37,   31, 1070, 1243, 1243,  285,
 /*   100 */   784,  800,  800,  800,  800,  800,  800,  800,  800,  800,
 /*   110 */   800,  800,  800,  800,  800,  800,  800,  800,  800,  800,
 /*   120 */   585,   86,    8,  160,  160,  336,  348,  712,   63,   63,
 /*   130 */   618,  618,  618,  348,  384,  384,  384,  151,   78,    4,
 /*   140 */     4,   58,  179,  179,  566,  566,  151,  574,  399,  399,
 /*   150 */   399,  399,  399,  399,  399, 1391,  137,  236,  572,  774,
 /*   160 */    42,  541,  332,  576,  714,   53,  524,  669,  771,  592,
 /*   170 */   852,  621,  592,  939,  661,  805,  917, 1114,  995, 1145,
 /*   180 */  1145, 1179, 1179, 1145, 1074, 1074, 1156, 1179, 1179, 1179,
 /*   190 */  1241, 1241, 1245,   14,   78,   14, 1252, 1253,   14, 1252,
 /*   200 */    14,   14,   14, 1179,   14, 1241,  179,  179,  179,  179,
 /*   210 */   179,  179,  179,  179,  179,  179,  179, 1179, 1241,  566,
 /*   220 */  1128, 1245,   31, 1152,   78,   31, 1179, 1179, 1252,   31,
 /*   230 */  1103,  566,  566,  566,  566, 1103,  566, 1199,   31,  151,
 /*   240 */    31,  384, 1367, 1367,  566, 1147, 1103,  566,  566, 1147,
 /*   250 */  1103,  566,  566,  179, 1160, 1249, 1147, 1162, 1169, 1185,
 /*   260 */   917, 1166, 1171, 1180, 1201,  384, 1422, 1355, 1357,  566,
 /*   270 */   574, 1179,   31, 1425, 1241, 2993, 2993, 2993, 2993, 2993,
 /*   280 */  2993, 2993, 1066,  191,  403, 1785, 1098,  684, 1158,   50,
 /*   290 */  1041, 1176,  126,  754,  754,  754,  754,  754,  754,  754,
 /*   300 */   754,  754,  239,  215,   11,   11,  171,  264,  406,  554,
 /*   310 */   421,  162,  547,   15,  729,  477,   15,   15,   15,  844,
 /*   320 */   135,  687,  830,  888,  889,  890,  895,  975, 1038, 1039,
 /*   330 */   858,  835,  936,  949,  963,  998, 1008, 1009, 1020,  872,
 /*   340 */   842,  992, 1003, 1004, 1001, 1024,  908, 1073,  670, 1000,
 /*   350 */  1091, 1140, 1151, 1193, 1195, 1207,  997, 1083, 1085, 1027,
 /*   360 */  1181, 1483, 1489, 1308, 1503, 1504, 1463, 1510, 1480, 1322,
 /*   370 */  1484, 1487, 1488, 1324, 1524, 1491, 1492, 1334, 1530, 1337,
 /*   380 */  1535, 1501, 1558, 1538, 1562, 1509, 1385, 1388, 1565, 1566,
 /*   390 */  1396, 1398, 1572, 1574, 1529, 1576, 1577, 1578, 1537, 1580,
 /*   400 */  1581, 1583, 1542, 1585, 1587, 1588, 1589, 1597, 1600, 1452,
 /*   410 */  1567, 1606, 1455, 1608, 1611, 1616, 1617, 1618, 1619, 1620,
 /*   420 */  1621, 1622, 1623, 1624, 1625, 1626, 1627, 1586, 1629, 1630,
 /*   430 */  1631, 1632, 1633, 1634, 1614, 1637, 1638, 1640, 1641, 1635,
 /*   440 */  1652, 1598, 1653, 1603, 1656, 1660, 1639, 1628, 1636, 1650,
 /*   450 */  1615, 1651, 1658, 1668, 1643, 1645, 1669, 1671, 1672, 1646,
 /*   460 */  1506, 1674, 1676, 1680, 1649, 1693, 1696, 1662, 1655, 1659,
 /*   470 */  1707, 1677, 1673, 1670, 1721, 1688, 1678, 1685, 1726, 1692,
 /*   480 */  1681, 1690, 1730, 1732, 1733, 1734, 1654, 1657, 1701, 1715,
 /*   490 */  1738, 1717, 1719, 1720, 1710, 1713, 1725, 1727, 1728, 1735,
 /*   500 */  1761, 1741, 1765, 1745, 1722, 1768, 1747, 1737, 1773, 1739,
 /*   510 */  1775, 1742, 1776, 1756, 1759, 1686, 1689, 1780, 1642, 1750,
 /*   520 */  1782, 1607, 1766, 1644, 1648, 1790, 1792, 1661, 1665, 1791,
 /*   530 */  1793, 1802, 1806, 1716, 1714, 1777, 1663, 1811, 1723, 1666,
 /*   540 */  1729, 1814, 1781, 1675, 1731, 1711, 1770, 1779, 1595, 1605,
 /*   550 */  1609, 1786, 1590, 1743, 1744, 1746, 1748, 1749, 1751, 1795,
 /*   560 */  1755, 1752, 1758, 1760, 1771, 1812, 1810, 1821, 1774, 1826,
 /*   570 */  1667, 1778, 1787, 1867, 1831, 1682, 1840, 1845, 1848, 1850,
 /*   580 */  1852, 1853, 1794, 1796, 1844, 1683, 1849, 1851, 1854, 1892,
 /*   590 */  1873, 1698, 1805, 1801, 1808, 1809, 1815, 1818, 1857, 1816,
 /*   600 */  1820, 1859, 1830, 1904, 1753, 1834, 1825, 1836, 1897, 1899,
 /*   610 */  1841, 1855, 1901, 1858, 1856, 1909, 1860, 1861, 1911, 1863,
 /*   620 */  1864, 1913, 1866, 1846, 1847, 1862, 1868, 1927, 1869, 1875,
 /*   630 */  1876, 1923, 1877, 1919, 1919, 1941, 1910, 1912, 1939, 1942,
 /*   640 */  1943, 1944, 1946, 1947, 1950, 1952, 1953, 1955, 1908, 1900,
 /*   650 */  1940, 1957, 1959, 1973, 1971, 1985, 1975, 1977, 1979, 1949,
 /*   660 */  1710, 1980, 1713, 1981, 1983, 1984, 1987, 1986, 1988, 2020,
 /*   670 */  1989, 1978, 1990, 2027, 1995, 2000, 1992, 2033, 1999, 2003,
 /*   680 */  1996, 2037, 2016, 2005, 2015, 2055, 2029, 2031, 2068, 2047,
 /*   690 */  2049, 2051, 2052, 2050, 2056,
};
#define YY_REDUCE_COUNT (281)
#define YY_REDUCE_MIN   (-408)
#define YY_REDUCE_MAX   (2591)
static const short yy_reduce_ofst[] = {
 /*     0 */   400, -253, -313,  885,   13,  282,  551,  996,  263, 1101,
 /*    10 */  1144, 1197, 1250, 1293, 1346,  532, 1402, 1464, 1522, 1544,
 /*    20 */  1604, 1647, 1664, 1718, 1736, 1798, 1822, 1865, 1885, 1948,
 /*    30 */  1967, 2010, 2061, 2081, 2132, 2185, 2228, 2248, 2311, 2330,
 /*    40 */  2373, 2424, 2444, 2495, 2548, 2591,   21,  280, -223,  801,
 /*    50 */   924,  926,  933,  984,  -25, 1131, -351, -348, -316, -341,
 /*    60 */  -103,  -63,  131,   96,  225, -318, -309, -211, -207,   -5,
 /*    70 */   261,  276,  283,  286,  309,  313,  436,  493,  108,  513,
 /*    80 */   517,  533, -217,  552,  555, -239,  565,  613, -241,   22,
 /*    90 */   380,   64,  106,  561,  615,  507, -312, -408, -408, -287,
 /*   100 */  -161, -265, -233, -206, -136,  141,  197,  204,  237,  293,
 /*   110 */   416,  464,  472,  516,  526,  542,  544,  545,  549,  562,
 /*   120 */   -14, -189,  -35, -100,  -94,  173,  114,   71,   61,   90,
 /*   130 */  -189,  176,  202,  165,  353,  372,  417, -105,  188,  123,
 /*   140 */   455,  196,  602,    7,  603,  609,  632,  521, -331,  117,
 /*   150 */   504,  548,  606,  611,  682,  238,  713,  695,  653,  601,
 /*   160 */   673,  760,  675,  773,  773,  794,  797,  764,  734,  706,
 /*   170 */   706,  688,  706,  744,  735,  773,  777,  779,  803,  831,
 /*   180 */   832,  876,  900,  861,  870,  874,  897,  915,  932,  934,
 /*   190 */   941,  942,  883,  935,  904,  937,  899,  898,  945,  909,
 /*   200 */   955,  962,  964,  967,  968,  977,  956,  957,  965,  966,
 /*   210 */   970,  972,  973,  974,  976,  979,  981,  983,  991,  969,
 /*   220 */   940,  943, 1010,  959,  978, 1013, 1016, 1022,  990, 1018,
 /*   230 */   980,  993, 1011, 1012, 1017,  982, 1021,  987, 1045, 1037,
 /*   240 */  1054, 1029, 1006, 1007, 1026,  971, 1031, 1043, 1044,  985,
 /*   250 */  1040, 1049, 1051,  773,  988,  986, 1002, 1005,  999, 1014,
 /*   260 */  1047,  989,  994, 1015,  706, 1078, 1057, 1042, 1099, 1092,
 /*   270 */  1116, 1129, 1130, 1143, 1146, 1082, 1094, 1124, 1127, 1142,
 /*   280 */  1161, 1164,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    10 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    20 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    30 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    40 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    50 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    60 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    70 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1623, 1549,
 /*    80 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*    90 */  1549, 1549, 1549, 1549, 1549, 1621, 1791, 1979, 1549, 1549,
 /*   100 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   110 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   120 */  1549, 1991, 1549, 1549, 1549, 1623, 1549, 1621, 1951, 1951,
 /*   130 */  1991, 1991, 1991, 1549, 1549, 1549, 1549, 1730, 1549, 1832,
 /*   140 */  1832, 1549, 1549, 1549, 1549, 1549, 1730, 1549, 1549, 1549,
 /*   150 */  1549, 1549, 1549, 1549, 1549, 1826, 1549, 1549, 2016, 2069,
 /*   160 */  1549, 1549, 2019, 1549, 1549, 1549, 1549, 1683, 2006, 1983,
 /*   170 */  1997, 2053, 1984, 1981, 2000, 1549, 2010, 1549, 1819, 1796,
 /*   180 */  1796, 1549, 1549, 1796, 1793, 1793, 1674, 1549, 1549, 1549,
 /*   190 */  1549, 1549, 1549, 1623, 1549, 1623, 1549, 1549, 1623, 1549,
 /*   200 */  1623, 1623, 1623, 1549, 1623, 1549, 1549, 1549, 1549, 1549,
 /*   210 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   220 */  1838, 1549, 1621, 1828, 1549, 1621, 1549, 1549, 1549, 1621,
 /*   230 */  2024, 1549, 1549, 1549, 1549, 2024, 1549, 1549, 1621, 1549,
 /*   240 */  1621, 1549, 1549, 1549, 1549, 2026, 2024, 1549, 1549, 2026,
 /*   250 */  2024, 1549, 1549, 1549, 2038, 2034, 2026, 2042, 2040, 2012,
 /*   260 */  2010, 2072, 2059, 2055, 1997, 1549, 1549, 1549, 1699, 1549,
 /*   270 */  1549, 1549, 1621, 1581, 1549, 1821, 1832, 1733, 1733, 1733,
 /*   280 */  1624, 1554, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   290 */  1549, 1549, 1549, 1907, 1549, 2037, 2036, 1955, 1954, 1953,
 /*   300 */  1944, 1906, 1549, 1695, 1905, 1904, 1549, 1549, 1549, 1549,
 /*   310 */  1549, 1549, 1549, 1898, 1549, 1549, 1899, 1897, 1896, 1549,
 /*   320 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   330 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   340 */  2056, 2060, 1980, 1549, 1549, 1549, 1549, 1549, 1889, 1880,
 /*   350 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   360 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   370 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   380 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   390 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   400 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   410 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   420 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   430 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   440 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1586, 1549,
 /*   450 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   460 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   470 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   480 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   490 */  1549, 1549, 1549, 1549, 1663, 1662, 1549, 1549, 1549, 1549,
 /*   500 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   510 */  1549, 1549, 1549, 1549, 1549, 1888, 1549, 1549, 1549, 1549,
 /*   520 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 2052,
 /*   530 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1836, 1549, 1549,
 /*   540 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1941, 1549, 1549,
 /*   550 */  1549, 2013, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   560 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1880, 1549, 2035,
 /*   570 */  1549, 1549, 2050, 1549, 2054, 1549, 1549, 1549, 1549, 1549,
 /*   580 */  1549, 1549, 1990, 1986, 1549, 1549, 1982, 1879, 1549, 1975,
 /*   590 */  1549, 1549, 1926, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   600 */  1549, 1549, 1888, 1549, 1892, 1549, 1549, 1549, 1549, 1549,
 /*   610 */  1727, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   620 */  1549, 1549, 1549, 1712, 1710, 1709, 1708, 1549, 1705, 1549,
 /*   630 */  1549, 1549, 1549, 1736, 1735, 1549, 1549, 1549, 1549, 1549,
 /*   640 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   650 */  1643, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   660 */  1634, 1549, 1633, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   670 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   680 */  1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549, 1549,
 /*   690 */  1549, 1549, 1549, 1549, 1549,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  265,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  265,  /*      AFTER => ABORT */
  265,  /*     ATTACH => ABORT */
  265,  /*     BEFORE => ABORT */
  265,  /*      BEGIN => ABORT */
  265,  /*     BITAND => ABORT */
  265,  /*     BITNOT => ABORT */
  265,  /*      BITOR => ABORT */
  265,  /*     BLOCKS => ABORT */
  265,  /*     CHANGE => ABORT */
  265,  /*      COMMA => ABORT */
  265,  /*    COMPACT => ABORT */
  265,  /*     CONCAT => ABORT */
  265,  /*   CONFLICT => ABORT */
  265,  /*       COPY => ABORT */
  265,  /*   DEFERRED => ABORT */
  265,  /* DELIMITERS => ABORT */
  265,  /*     DETACH => ABORT */
  265,  /*     DIVIDE => ABORT */
  265,  /*        DOT => ABORT */
  265,  /*       EACH => ABORT */
  265,  /*       FAIL => ABORT */
  265,  /*       FILE => ABORT */
  265,  /*        FOR => ABORT */
  265,  /*       GLOB => ABORT */
  265,  /*         ID => ABORT */
  265,  /*  IMMEDIATE => ABORT */
  265,  /*     IMPORT => ABORT */
  265,  /*  INITIALLY => ABORT */
  265,  /*    INSTEAD => ABORT */
  265,  /*     ISNULL => ABORT */
  265,  /*        KEY => ABORT */
  265,  /*  NK_BITNOT => ABORT */
  265,  /*    NK_SEMI => ABORT */
  265,  /*    NOTNULL => ABORT */
  265,  /*         OF => ABORT */
  265,  /*       PLUS => ABORT */
  265,  /*  PRIVILEGE => ABORT */
  265,  /*      RAISE => ABORT */
  265,  /*    REPLACE => ABORT */
  265,  /*   RESTRICT => ABORT */
  265,  /*        ROW => ABORT */
  265,  /*       SEMI => ABORT */
  265,  /*       STAR => ABORT */
  265,  /*  STATEMENT => ABORT */
  265,  /*     STRING => ABORT */
  265,  /*      TIMES => ABORT */
  265,  /*     UPDATE => ABORT */
  265,  /*     VALUES => ABORT */
  265,  /*   VARIABLE => ABORT */
  265,  /*       VIEW => ABORT */
  265,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "MODULES",
  /*  138 */ "QNODES",
  /*  139 */ "FUNCTIONS",
  /*  140 */ "INDEXES",
  /*  141 */ "ACCOUNTS",
  /*  142 */ "APPS",
  /*  143 */ "CONNECTIONS",
  /*  144 */ "LICENCES",
  /*  145 */ "GRANTS",
  /*  146 */ "QUERIES",
  /*  147 */ "SCORES",
  /*  148 */ "TOPICS",
  /*  149 */ "VARIABLES",
  /*  150 */ "BNODES",
  /*  151 */ "SNODES",
  /*  152 */ "CLUSTER",
  /*  153 */ "TRANSACTIONS",
  /*  154 */ "DISTRIBUTED",
  /*  155 */ "CONSUMERS",
  /*  156 */ "SUBSCRIPTIONS",
  /*  157 */ "VNODES",
  /*  158 */ "LIKE",
  /*  159 */ "INDEX",
  /*  160 */ "FUNCTION",
  /*  161 */ "INTERVAL",
  /*  162 */ "TOPIC",
  /*  163 */ "AS",
  /*  164 */ "WITH",
  /*  165 */ "META",
  /*  166 */ "CONSUMER",
  /*  167 */ "GROUP",
  /*  168 */ "DESC",
  /*  169 */ "DESCRIBE",
  /*  170 */ "RESET",
  /*  171 */ "QUERY",
  /*  172 */ "CACHE",
  /*  173 */ "EXPLAIN",
  /*  174 */ "ANALYZE",
  /*  175 */ "VERBOSE",
  /*  176 */ "NK_BOOL",
  /*  177 */ "RATIO",
  /*  178 */ "NK_FLOAT",
  /*  179 */ "OUTPUTTYPE",
  /*  180 */ "AGGREGATE",
  /*  181 */ "BUFSIZE",
  /*  182 */ "STREAM",
  /*  183 */ "INTO",
  /*  184 */ "TRIGGER",
  /*  185 */ "AT_ONCE",
  /*  186 */ "WINDOW_CLOSE",
  /*  187 */ "IGNORE",
  /*  188 */ "EXPIRED",
  /*  189 */ "SUBTABLE",
  /*  190 */ "KILL",
  /*  191 */ "CONNECTION",
  /*  192 */ "TRANSACTION",
  /*  193 */ "BALANCE",
  /*  194 */ "VGROUP",
  /*  195 */ "MERGE",
  /*  196 */ "REDISTRIBUTE",
  /*  197 */ "SPLIT",
  /*  198 */ "DELETE",
  /*  199 */ "INSERT",
  /*  200 */ "NULL",
  /*  201 */ "NK_QUESTION",
  /*  202 */ "NK_ARROW",
  /*  203 */ "ROWTS",
  /*  204 */ "TBNAME",
  /*  205 */ "QSTART",
  /*  206 */ "QEND",
  /*  207 */ "QDURATION",
  /*  208 */ "WSTART",
  /*  209 */ "WEND",
  /*  210 */ "WDURATION",
  /*  211 */ "IROWTS",
  /*  212 */ "QTAGS",
  /*  213 */ "CAST",
  /*  214 */ "NOW",
  /*  215 */ "TODAY",
  /*  216 */ "TIMEZONE",
  /*  217 */ "CLIENT_VERSION",
  /*  218 */ "SERVER_VERSION",
  /*  219 */ "SERVER_STATUS",
  /*  220 */ "CURRENT_USER",
  /*  221 */ "COUNT",
  /*  222 */ "LAST_ROW",
  /*  223 */ "CASE",
  /*  224 */ "END",
  /*  225 */ "WHEN",
  /*  226 */ "THEN",
  /*  227 */ "ELSE",
  /*  228 */ "BETWEEN",
  /*  229 */ "IS",
  /*  230 */ "NK_LT",
  /*  231 */ "NK_GT",
  /*  232 */ "NK_LE",
  /*  233 */ "NK_GE",
  /*  234 */ "NK_NE",
  /*  235 */ "MATCH",
  /*  236 */ "NMATCH",
  /*  237 */ "CONTAINS",
  /*  238 */ "IN",
  /*  239 */ "JOIN",
  /*  240 */ "INNER",
  /*  241 */ "SELECT",
  /*  242 */ "DISTINCT",
  /*  243 */ "WHERE",
  /*  244 */ "PARTITION",
  /*  245 */ "BY",
  /*  246 */ "SESSION",
  /*  247 */ "STATE_WINDOW",
  /*  248 */ "SLIDING",
  /*  249 */ "FILL",
  /*  250 */ "VALUE",
  /*  251 */ "NONE",
  /*  252 */ "PREV",
  /*  253 */ "LINEAR",
  /*  254 */ "NEXT",
  /*  255 */ "HAVING",
  /*  256 */ "RANGE",
  /*  257 */ "EVERY",
  /*  258 */ "ORDER",
  /*  259 */ "SLIMIT",
  /*  260 */ "SOFFSET",
  /*  261 */ "LIMIT",
  /*  262 */ "OFFSET",
  /*  263 */ "ASC",
  /*  264 */ "NULLS",
  /*  265 */ "ABORT",
  /*  266 */ "AFTER",
  /*  267 */ "ATTACH",
  /*  268 */ "BEFORE",
  /*  269 */ "BEGIN",
  /*  270 */ "BITAND",
  /*  271 */ "BITNOT",
  /*  272 */ "BITOR",
  /*  273 */ "BLOCKS",
  /*  274 */ "CHANGE",
  /*  275 */ "COMMA",
  /*  276 */ "COMPACT",
  /*  277 */ "CONCAT",
  /*  278 */ "CONFLICT",
  /*  279 */ "COPY",
  /*  280 */ "DEFERRED",
  /*  281 */ "DELIMITERS",
  /*  282 */ "DETACH",
  /*  283 */ "DIVIDE",
  /*  284 */ "DOT",
  /*  285 */ "EACH",
  /*  286 */ "FAIL",
  /*  287 */ "FILE",
  /*  288 */ "FOR",
  /*  289 */ "GLOB",
  /*  290 */ "ID",
  /*  291 */ "IMMEDIATE",
  /*  292 */ "IMPORT",
  /*  293 */ "INITIALLY",
  /*  294 */ "INSTEAD",
  /*  295 */ "ISNULL",
  /*  296 */ "KEY",
  /*  297 */ "NK_BITNOT",
  /*  298 */ "NK_SEMI",
  /*  299 */ "NOTNULL",
  /*  300 */ "OF",
  /*  301 */ "PLUS",
  /*  302 */ "PRIVILEGE",
  /*  303 */ "RAISE",
  /*  304 */ "REPLACE",
  /*  305 */ "RESTRICT",
  /*  306 */ "ROW",
  /*  307 */ "SEMI",
  /*  308 */ "STAR",
  /*  309 */ "STATEMENT",
  /*  310 */ "STRING",
  /*  311 */ "TIMES",
  /*  312 */ "UPDATE",
  /*  313 */ "VALUES",
  /*  314 */ "VARIABLE",
  /*  315 */ "VIEW",
  /*  316 */ "WAL",
  /*  317 */ "cmd",
  /*  318 */ "account_options",
  /*  319 */ "alter_account_options",
  /*  320 */ "literal",
  /*  321 */ "alter_account_option",
  /*  322 */ "user_name",
  /*  323 */ "sysinfo_opt",
  /*  324 */ "privileges",
  /*  325 */ "priv_level",
  /*  326 */ "priv_type_list",
  /*  327 */ "priv_type",
  /*  328 */ "db_name",
  /*  329 */ "dnode_endpoint",
  /*  330 */ "not_exists_opt",
  /*  331 */ "db_options",
  /*  332 */ "exists_opt",
  /*  333 */ "alter_db_options",
  /*  334 */ "speed_opt",
  /*  335 */ "integer_list",
  /*  336 */ "variable_list",
  /*  337 */ "retention_list",
  /*  338 */ "alter_db_option",
  /*  339 */ "retention",
  /*  340 */ "full_table_name",
  /*  341 */ "column_def_list",
  /*  342 */ "tags_def_opt",
  /*  343 */ "table_options",
  /*  344 */ "multi_create_clause",
  /*  345 */ "tags_def",
  /*  346 */ "multi_drop_clause",
  /*  347 */ "alter_table_clause",
  /*  348 */ "alter_table_options",
  /*  349 */ "column_name",
  /*  350 */ "type_name",
  /*  351 */ "signed_literal",
  /*  352 */ "create_subtable_clause",
  /*  353 */ "specific_cols_opt",
  /*  354 */ "expression_list",
  /*  355 */ "drop_table_clause",
  /*  356 */ "col_name_list",
  /*  357 */ "table_name",
  /*  358 */ "column_def",
  /*  359 */ "duration_list",
  /*  360 */ "rollup_func_list",
  /*  361 */ "alter_table_option",
  /*  362 */ "duration_literal",
  /*  363 */ "rollup_func_name",
  /*  364 */ "function_name",
  /*  365 */ "col_name",
  /*  366 */ "db_name_cond_opt",
  /*  367 */ "like_pattern_opt",
  /*  368 */ "table_name_cond",
  /*  369 */ "from_db_opt",
  /*  370 */ "index_options",
  /*  371 */ "func_list",
  /*  372 */ "sliding_opt",
  /*  373 */ "sma_stream_opt",
  /*  374 */ "func",
  /*  375 */ "stream_options",
  /*  376 */ "topic_name",
  /*  377 */ "query_or_subquery",
  /*  378 */ "cgroup_name",
  /*  379 */ "analyze_opt",
  /*  380 */ "explain_options",
  /*  381 */ "agg_func_opt",
  /*  382 */ "bufsize_opt",
  /*  383 */ "stream_name",
  /*  384 */ "subtable_opt",
  /*  385 */ "expression",
  /*  386 */ "dnode_list",
  /*  387 */ "where_clause_opt",
  /*  388 */ "signed",
  /*  389 */ "literal_func",
  /*  390 */ "literal_list",
  /*  391 */ "table_alias",
  /*  392 */ "column_alias",
  /*  393 */ "expr_or_subquery",
  /*  394 */ "subquery",
  /*  395 */ "pseudo_column",
  /*  396 */ "column_reference",
  /*  397 */ "function_expression",
  /*  398 */ "case_when_expression",
  /*  399 */ "star_func",
  /*  400 */ "star_func_para_list",
  /*  401 */ "noarg_func",
  /*  402 */ "other_para_list",
  /*  403 */ "star_func_para",
  /*  404 */ "when_then_list",
  /*  405 */ "case_when_else_opt",
  /*  406 */ "common_expression",
  /*  407 */ "when_then_expr",
  /*  408 */ "predicate",
  /*  409 */ "compare_op",
  /*  410 */ "in_op",
  /*  411 */ "in_predicate_value",
  /*  412 */ "boolean_value_expression",
  /*  413 */ "boolean_primary",
  /*  414 */ "from_clause_opt",
  /*  415 */ "table_reference_list",
  /*  416 */ "table_reference",
  /*  417 */ "table_primary",
  /*  418 */ "joined_table",
  /*  419 */ "alias_opt",
  /*  420 */ "parenthesized_joined_table",
  /*  421 */ "join_type",
  /*  422 */ "search_condition",
  /*  423 */ "query_specification",
  /*  424 */ "set_quantifier_opt",
  /*  425 */ "select_list",
  /*  426 */ "partition_by_clause_opt",
  /*  427 */ "range_opt",
  /*  428 */ "every_opt",
  /*  429 */ "fill_opt",
  /*  430 */ "twindow_clause_opt",
  /*  431 */ "group_by_clause_opt",
  /*  432 */ "having_clause_opt",
  /*  433 */ "select_item",
  /*  434 */ "partition_list",
  /*  435 */ "partition_item",
  /*  436 */ "fill_mode",
  /*  437 */ "group_by_list",
  /*  438 */ "query_expression",
  /*  439 */ "query_simple",
  /*  440 */ "order_by_clause_opt",
  /*  441 */ "slimit_clause_opt",
  /*  442 */ "limit_clause_opt",
  /*  443 */ "union_query_expression",
  /*  444 */ "query_simple_or_subquery",
  /*  445 */ "sort_specification_list",
  /*  446 */ "sort_specification",
  /*  447 */ "ordering_specification_opt",
  /*  448 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 107 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 108 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 109 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 110 */ "alter_db_option ::= KEEP integer_list",
 /* 111 */ "alter_db_option ::= KEEP variable_list",
 /* 112 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 114 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 115 */ "integer_list ::= NK_INTEGER",
 /* 116 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 117 */ "variable_list ::= NK_VARIABLE",
 /* 118 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 119 */ "retention_list ::= retention",
 /* 120 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 121 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 122 */ "speed_opt ::=",
 /* 123 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 124 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 125 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 126 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 127 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 128 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 129 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 130 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 131 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 132 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 134 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 136 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 141 */ "multi_create_clause ::= create_subtable_clause",
 /* 142 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 143 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 144 */ "multi_drop_clause ::= drop_table_clause",
 /* 145 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 146 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 147 */ "specific_cols_opt ::=",
 /* 148 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 149 */ "full_table_name ::= table_name",
 /* 150 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 151 */ "column_def_list ::= column_def",
 /* 152 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 153 */ "column_def ::= column_name type_name",
 /* 154 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 155 */ "type_name ::= BOOL",
 /* 156 */ "type_name ::= TINYINT",
 /* 157 */ "type_name ::= SMALLINT",
 /* 158 */ "type_name ::= INT",
 /* 159 */ "type_name ::= INTEGER",
 /* 160 */ "type_name ::= BIGINT",
 /* 161 */ "type_name ::= FLOAT",
 /* 162 */ "type_name ::= DOUBLE",
 /* 163 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 164 */ "type_name ::= TIMESTAMP",
 /* 165 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= TINYINT UNSIGNED",
 /* 167 */ "type_name ::= SMALLINT UNSIGNED",
 /* 168 */ "type_name ::= INT UNSIGNED",
 /* 169 */ "type_name ::= BIGINT UNSIGNED",
 /* 170 */ "type_name ::= JSON",
 /* 171 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 172 */ "type_name ::= MEDIUMBLOB",
 /* 173 */ "type_name ::= BLOB",
 /* 174 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 175 */ "type_name ::= DECIMAL",
 /* 176 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 178 */ "tags_def_opt ::=",
 /* 179 */ "tags_def_opt ::= tags_def",
 /* 180 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 181 */ "table_options ::=",
 /* 182 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 183 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 184 */ "table_options ::= table_options WATERMARK duration_list",
 /* 185 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 186 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 187 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 188 */ "alter_table_options ::= alter_table_option",
 /* 189 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 190 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 191 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 192 */ "duration_list ::= duration_literal",
 /* 193 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 194 */ "rollup_func_list ::= rollup_func_name",
 /* 195 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 196 */ "rollup_func_name ::= function_name",
 /* 197 */ "rollup_func_name ::= FIRST",
 /* 198 */ "rollup_func_name ::= LAST",
 /* 199 */ "col_name_list ::= col_name",
 /* 200 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 201 */ "col_name ::= column_name",
 /* 202 */ "cmd ::= SHOW DNODES",
 /* 203 */ "cmd ::= SHOW USERS",
 /* 204 */ "cmd ::= SHOW DATABASES",
 /* 205 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 206 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 207 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 208 */ "cmd ::= SHOW MNODES",
 /* 209 */ "cmd ::= SHOW MODULES",
 /* 210 */ "cmd ::= SHOW QNODES",
 /* 211 */ "cmd ::= SHOW FUNCTIONS",
 /* 212 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 213 */ "cmd ::= SHOW STREAMS",
 /* 214 */ "cmd ::= SHOW ACCOUNTS",
 /* 215 */ "cmd ::= SHOW APPS",
 /* 216 */ "cmd ::= SHOW CONNECTIONS",
 /* 217 */ "cmd ::= SHOW LICENCES",
 /* 218 */ "cmd ::= SHOW GRANTS",
 /* 219 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 220 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 221 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 222 */ "cmd ::= SHOW QUERIES",
 /* 223 */ "cmd ::= SHOW SCORES",
 /* 224 */ "cmd ::= SHOW TOPICS",
 /* 225 */ "cmd ::= SHOW VARIABLES",
 /* 226 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 227 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 228 */ "cmd ::= SHOW BNODES",
 /* 229 */ "cmd ::= SHOW SNODES",
 /* 230 */ "cmd ::= SHOW CLUSTER",
 /* 231 */ "cmd ::= SHOW TRANSACTIONS",
 /* 232 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 233 */ "cmd ::= SHOW CONSUMERS",
 /* 234 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 235 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 236 */ "cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt",
 /* 237 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 238 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 239 */ "db_name_cond_opt ::=",
 /* 240 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 241 */ "like_pattern_opt ::=",
 /* 242 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 243 */ "table_name_cond ::= table_name",
 /* 244 */ "from_db_opt ::=",
 /* 245 */ "from_db_opt ::= FROM db_name",
 /* 246 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 247 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 248 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 249 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 250 */ "func_list ::= func",
 /* 251 */ "func_list ::= func_list NK_COMMA func",
 /* 252 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 253 */ "sma_stream_opt ::=",
 /* 254 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 255 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 256 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 257 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 258 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 259 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 260 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 261 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 262 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 263 */ "cmd ::= DESC full_table_name",
 /* 264 */ "cmd ::= DESCRIBE full_table_name",
 /* 265 */ "cmd ::= RESET QUERY CACHE",
 /* 266 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 267 */ "analyze_opt ::=",
 /* 268 */ "analyze_opt ::= ANALYZE",
 /* 269 */ "explain_options ::=",
 /* 270 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 271 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 272 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 273 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 274 */ "agg_func_opt ::=",
 /* 275 */ "agg_func_opt ::= AGGREGATE",
 /* 276 */ "bufsize_opt ::=",
 /* 277 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 278 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 279 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 280 */ "stream_options ::=",
 /* 281 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 282 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 283 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 284 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 285 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 286 */ "subtable_opt ::=",
 /* 287 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 288 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 289 */ "cmd ::= KILL QUERY NK_STRING",
 /* 290 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 291 */ "cmd ::= BALANCE VGROUP",
 /* 292 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 293 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 294 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 295 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 296 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 297 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 298 */ "cmd ::= query_or_subquery",
 /* 299 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 300 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 301 */ "literal ::= NK_INTEGER",
 /* 302 */ "literal ::= NK_FLOAT",
 /* 303 */ "literal ::= NK_STRING",
 /* 304 */ "literal ::= NK_BOOL",
 /* 305 */ "literal ::= TIMESTAMP NK_STRING",
 /* 306 */ "literal ::= duration_literal",
 /* 307 */ "literal ::= NULL",
 /* 308 */ "literal ::= NK_QUESTION",
 /* 309 */ "duration_literal ::= NK_VARIABLE",
 /* 310 */ "signed ::= NK_INTEGER",
 /* 311 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 312 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 313 */ "signed ::= NK_FLOAT",
 /* 314 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 315 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 316 */ "signed_literal ::= signed",
 /* 317 */ "signed_literal ::= NK_STRING",
 /* 318 */ "signed_literal ::= NK_BOOL",
 /* 319 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 320 */ "signed_literal ::= duration_literal",
 /* 321 */ "signed_literal ::= NULL",
 /* 322 */ "signed_literal ::= literal_func",
 /* 323 */ "signed_literal ::= NK_QUESTION",
 /* 324 */ "literal_list ::= signed_literal",
 /* 325 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 326 */ "db_name ::= NK_ID",
 /* 327 */ "table_name ::= NK_ID",
 /* 328 */ "column_name ::= NK_ID",
 /* 329 */ "function_name ::= NK_ID",
 /* 330 */ "table_alias ::= NK_ID",
 /* 331 */ "column_alias ::= NK_ID",
 /* 332 */ "user_name ::= NK_ID",
 /* 333 */ "topic_name ::= NK_ID",
 /* 334 */ "stream_name ::= NK_ID",
 /* 335 */ "cgroup_name ::= NK_ID",
 /* 336 */ "expr_or_subquery ::= expression",
 /* 337 */ "expr_or_subquery ::= subquery",
 /* 338 */ "expression ::= literal",
 /* 339 */ "expression ::= pseudo_column",
 /* 340 */ "expression ::= column_reference",
 /* 341 */ "expression ::= function_expression",
 /* 342 */ "expression ::= case_when_expression",
 /* 343 */ "expression ::= NK_LP expression NK_RP",
 /* 344 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 345 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 346 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 347 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 348 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 349 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 350 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 351 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 352 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 353 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 354 */ "expression_list ::= expr_or_subquery",
 /* 355 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 356 */ "column_reference ::= column_name",
 /* 357 */ "column_reference ::= table_name NK_DOT column_name",
 /* 358 */ "pseudo_column ::= ROWTS",
 /* 359 */ "pseudo_column ::= TBNAME",
 /* 360 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 361 */ "pseudo_column ::= QSTART",
 /* 362 */ "pseudo_column ::= QEND",
 /* 363 */ "pseudo_column ::= QDURATION",
 /* 364 */ "pseudo_column ::= WSTART",
 /* 365 */ "pseudo_column ::= WEND",
 /* 366 */ "pseudo_column ::= WDURATION",
 /* 367 */ "pseudo_column ::= IROWTS",
 /* 368 */ "pseudo_column ::= QTAGS",
 /* 369 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 370 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 371 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 372 */ "function_expression ::= literal_func",
 /* 373 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 374 */ "literal_func ::= NOW",
 /* 375 */ "noarg_func ::= NOW",
 /* 376 */ "noarg_func ::= TODAY",
 /* 377 */ "noarg_func ::= TIMEZONE",
 /* 378 */ "noarg_func ::= DATABASE",
 /* 379 */ "noarg_func ::= CLIENT_VERSION",
 /* 380 */ "noarg_func ::= SERVER_VERSION",
 /* 381 */ "noarg_func ::= SERVER_STATUS",
 /* 382 */ "noarg_func ::= CURRENT_USER",
 /* 383 */ "noarg_func ::= USER",
 /* 384 */ "star_func ::= COUNT",
 /* 385 */ "star_func ::= FIRST",
 /* 386 */ "star_func ::= LAST",
 /* 387 */ "star_func ::= LAST_ROW",
 /* 388 */ "star_func_para_list ::= NK_STAR",
 /* 389 */ "star_func_para_list ::= other_para_list",
 /* 390 */ "other_para_list ::= star_func_para",
 /* 391 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 392 */ "star_func_para ::= expr_or_subquery",
 /* 393 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 394 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 395 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 396 */ "when_then_list ::= when_then_expr",
 /* 397 */ "when_then_list ::= when_then_list when_then_expr",
 /* 398 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 399 */ "case_when_else_opt ::=",
 /* 400 */ "case_when_else_opt ::= ELSE common_expression",
 /* 401 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 402 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 403 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 404 */ "predicate ::= expr_or_subquery IS NULL",
 /* 405 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 406 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 407 */ "compare_op ::= NK_LT",
 /* 408 */ "compare_op ::= NK_GT",
 /* 409 */ "compare_op ::= NK_LE",
 /* 410 */ "compare_op ::= NK_GE",
 /* 411 */ "compare_op ::= NK_NE",
 /* 412 */ "compare_op ::= NK_EQ",
 /* 413 */ "compare_op ::= LIKE",
 /* 414 */ "compare_op ::= NOT LIKE",
 /* 415 */ "compare_op ::= MATCH",
 /* 416 */ "compare_op ::= NMATCH",
 /* 417 */ "compare_op ::= CONTAINS",
 /* 418 */ "in_op ::= IN",
 /* 419 */ "in_op ::= NOT IN",
 /* 420 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 421 */ "boolean_value_expression ::= boolean_primary",
 /* 422 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 423 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 424 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 425 */ "boolean_primary ::= predicate",
 /* 426 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 427 */ "common_expression ::= expr_or_subquery",
 /* 428 */ "common_expression ::= boolean_value_expression",
 /* 429 */ "from_clause_opt ::=",
 /* 430 */ "from_clause_opt ::= FROM table_reference_list",
 /* 431 */ "table_reference_list ::= table_reference",
 /* 432 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 433 */ "table_reference ::= table_primary",
 /* 434 */ "table_reference ::= joined_table",
 /* 435 */ "table_primary ::= table_name alias_opt",
 /* 436 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 437 */ "table_primary ::= subquery alias_opt",
 /* 438 */ "table_primary ::= parenthesized_joined_table",
 /* 439 */ "alias_opt ::=",
 /* 440 */ "alias_opt ::= table_alias",
 /* 441 */ "alias_opt ::= AS table_alias",
 /* 442 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 443 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 444 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 445 */ "join_type ::=",
 /* 446 */ "join_type ::= INNER",
 /* 447 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 448 */ "set_quantifier_opt ::=",
 /* 449 */ "set_quantifier_opt ::= DISTINCT",
 /* 450 */ "set_quantifier_opt ::= ALL",
 /* 451 */ "select_list ::= select_item",
 /* 452 */ "select_list ::= select_list NK_COMMA select_item",
 /* 453 */ "select_item ::= NK_STAR",
 /* 454 */ "select_item ::= common_expression",
 /* 455 */ "select_item ::= common_expression column_alias",
 /* 456 */ "select_item ::= common_expression AS column_alias",
 /* 457 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 458 */ "where_clause_opt ::=",
 /* 459 */ "where_clause_opt ::= WHERE search_condition",
 /* 460 */ "partition_by_clause_opt ::=",
 /* 461 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 462 */ "partition_list ::= partition_item",
 /* 463 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 464 */ "partition_item ::= expr_or_subquery",
 /* 465 */ "partition_item ::= expr_or_subquery column_alias",
 /* 466 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 467 */ "twindow_clause_opt ::=",
 /* 468 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 469 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 470 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 471 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 472 */ "sliding_opt ::=",
 /* 473 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 474 */ "fill_opt ::=",
 /* 475 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 476 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 477 */ "fill_mode ::= NONE",
 /* 478 */ "fill_mode ::= PREV",
 /* 479 */ "fill_mode ::= NULL",
 /* 480 */ "fill_mode ::= LINEAR",
 /* 481 */ "fill_mode ::= NEXT",
 /* 482 */ "group_by_clause_opt ::=",
 /* 483 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 484 */ "group_by_list ::= expr_or_subquery",
 /* 485 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 486 */ "having_clause_opt ::=",
 /* 487 */ "having_clause_opt ::= HAVING search_condition",
 /* 488 */ "range_opt ::=",
 /* 489 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 490 */ "every_opt ::=",
 /* 491 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 492 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 493 */ "query_simple ::= query_specification",
 /* 494 */ "query_simple ::= union_query_expression",
 /* 495 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 496 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 497 */ "query_simple_or_subquery ::= query_simple",
 /* 498 */ "query_simple_or_subquery ::= subquery",
 /* 499 */ "query_or_subquery ::= query_expression",
 /* 500 */ "query_or_subquery ::= subquery",
 /* 501 */ "order_by_clause_opt ::=",
 /* 502 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 503 */ "slimit_clause_opt ::=",
 /* 504 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 505 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 506 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 507 */ "limit_clause_opt ::=",
 /* 508 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 509 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 510 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 511 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 512 */ "subquery ::= NK_LP subquery NK_RP",
 /* 513 */ "search_condition ::= common_expression",
 /* 514 */ "sort_specification_list ::= sort_specification",
 /* 515 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 516 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 517 */ "ordering_specification_opt ::=",
 /* 518 */ "ordering_specification_opt ::= ASC",
 /* 519 */ "ordering_specification_opt ::= DESC",
 /* 520 */ "null_ordering_opt ::=",
 /* 521 */ "null_ordering_opt ::= NULLS FIRST",
 /* 522 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 317: /* cmd */
    case 320: /* literal */
    case 331: /* db_options */
    case 333: /* alter_db_options */
    case 339: /* retention */
    case 340: /* full_table_name */
    case 343: /* table_options */
    case 347: /* alter_table_clause */
    case 348: /* alter_table_options */
    case 351: /* signed_literal */
    case 352: /* create_subtable_clause */
    case 355: /* drop_table_clause */
    case 358: /* column_def */
    case 362: /* duration_literal */
    case 363: /* rollup_func_name */
    case 365: /* col_name */
    case 366: /* db_name_cond_opt */
    case 367: /* like_pattern_opt */
    case 368: /* table_name_cond */
    case 369: /* from_db_opt */
    case 370: /* index_options */
    case 372: /* sliding_opt */
    case 373: /* sma_stream_opt */
    case 374: /* func */
    case 375: /* stream_options */
    case 377: /* query_or_subquery */
    case 380: /* explain_options */
    case 384: /* subtable_opt */
    case 385: /* expression */
    case 387: /* where_clause_opt */
    case 388: /* signed */
    case 389: /* literal_func */
    case 393: /* expr_or_subquery */
    case 394: /* subquery */
    case 395: /* pseudo_column */
    case 396: /* column_reference */
    case 397: /* function_expression */
    case 398: /* case_when_expression */
    case 403: /* star_func_para */
    case 405: /* case_when_else_opt */
    case 406: /* common_expression */
    case 407: /* when_then_expr */
    case 408: /* predicate */
    case 411: /* in_predicate_value */
    case 412: /* boolean_value_expression */
    case 413: /* boolean_primary */
    case 414: /* from_clause_opt */
    case 415: /* table_reference_list */
    case 416: /* table_reference */
    case 417: /* table_primary */
    case 418: /* joined_table */
    case 420: /* parenthesized_joined_table */
    case 422: /* search_condition */
    case 423: /* query_specification */
    case 427: /* range_opt */
    case 428: /* every_opt */
    case 429: /* fill_opt */
    case 430: /* twindow_clause_opt */
    case 432: /* having_clause_opt */
    case 433: /* select_item */
    case 435: /* partition_item */
    case 438: /* query_expression */
    case 439: /* query_simple */
    case 441: /* slimit_clause_opt */
    case 442: /* limit_clause_opt */
    case 443: /* union_query_expression */
    case 444: /* query_simple_or_subquery */
    case 446: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy778)); 
}
      break;
    case 318: /* account_options */
    case 319: /* alter_account_options */
    case 321: /* alter_account_option */
    case 334: /* speed_opt */
    case 382: /* bufsize_opt */
{
 
}
      break;
    case 322: /* user_name */
    case 325: /* priv_level */
    case 328: /* db_name */
    case 329: /* dnode_endpoint */
    case 349: /* column_name */
    case 357: /* table_name */
    case 364: /* function_name */
    case 376: /* topic_name */
    case 378: /* cgroup_name */
    case 383: /* stream_name */
    case 391: /* table_alias */
    case 392: /* column_alias */
    case 399: /* star_func */
    case 401: /* noarg_func */
    case 419: /* alias_opt */
{
 
}
      break;
    case 323: /* sysinfo_opt */
{
 
}
      break;
    case 324: /* privileges */
    case 326: /* priv_type_list */
    case 327: /* priv_type */
{
 
}
      break;
    case 330: /* not_exists_opt */
    case 332: /* exists_opt */
    case 379: /* analyze_opt */
    case 381: /* agg_func_opt */
    case 424: /* set_quantifier_opt */
{
 
}
      break;
    case 335: /* integer_list */
    case 336: /* variable_list */
    case 337: /* retention_list */
    case 341: /* column_def_list */
    case 342: /* tags_def_opt */
    case 344: /* multi_create_clause */
    case 345: /* tags_def */
    case 346: /* multi_drop_clause */
    case 353: /* specific_cols_opt */
    case 354: /* expression_list */
    case 356: /* col_name_list */
    case 359: /* duration_list */
    case 360: /* rollup_func_list */
    case 371: /* func_list */
    case 386: /* dnode_list */
    case 390: /* literal_list */
    case 400: /* star_func_para_list */
    case 402: /* other_para_list */
    case 404: /* when_then_list */
    case 425: /* select_list */
    case 426: /* partition_by_clause_opt */
    case 431: /* group_by_clause_opt */
    case 434: /* partition_list */
    case 437: /* group_by_list */
    case 440: /* order_by_clause_opt */
    case 445: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy282)); 
}
      break;
    case 338: /* alter_db_option */
    case 361: /* alter_table_option */
{
 
}
      break;
    case 350: /* type_name */
{
 
}
      break;
    case 409: /* compare_op */
    case 410: /* in_op */
{
 
}
      break;
    case 421: /* join_type */
{
 
}
      break;
    case 436: /* fill_mode */
{
 
}
      break;
    case 447: /* ordering_specification_opt */
{
 
}
      break;
    case 448: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  317,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  317,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  318,    0 }, /* (2) account_options ::= */
  {  318,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  318,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  318,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  318,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  318,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  318,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  318,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  318,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  318,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  319,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  319,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  321,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  321,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  321,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  321,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  321,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  321,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  321,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  321,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  321,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  321,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  317,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  317,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  317,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  317,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  317,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  323,    0 }, /* (29) sysinfo_opt ::= */
  {  323,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  317,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  317,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  324,   -1 }, /* (33) privileges ::= ALL */
  {  324,   -1 }, /* (34) privileges ::= priv_type_list */
  {  326,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  326,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  327,   -1 }, /* (37) priv_type ::= READ */
  {  327,   -1 }, /* (38) priv_type ::= WRITE */
  {  325,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  325,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  317,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  317,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  317,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  317,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  317,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  317,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  317,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  317,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  329,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  329,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  329,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  317,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  317,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  317,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  317,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  317,   -2 }, /* (64) cmd ::= USE db_name */
  {  317,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  317,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  317,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  330,    0 }, /* (69) not_exists_opt ::= */
  {  332,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  332,    0 }, /* (71) exists_opt ::= */
  {  331,    0 }, /* (72) db_options ::= */
  {  331,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  331,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  331,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  331,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  331,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  331,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  331,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  331,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  331,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  331,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  331,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  331,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  331,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  331,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  331,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  331,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  331,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  331,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  331,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  331,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  331,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  331,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  331,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  331,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  331,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  333,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  333,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  338,   -2 }, /* (106) alter_db_option ::= BUFFER NK_INTEGER */
  {  338,   -2 }, /* (107) alter_db_option ::= CACHEMODEL NK_STRING */
  {  338,   -2 }, /* (108) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  338,   -2 }, /* (109) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -2 }, /* (110) alter_db_option ::= KEEP integer_list */
  {  338,   -2 }, /* (111) alter_db_option ::= KEEP variable_list */
  {  338,   -2 }, /* (112) alter_db_option ::= PAGES NK_INTEGER */
  {  338,   -2 }, /* (113) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  338,   -2 }, /* (114) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  335,   -1 }, /* (115) integer_list ::= NK_INTEGER */
  {  335,   -3 }, /* (116) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  336,   -1 }, /* (117) variable_list ::= NK_VARIABLE */
  {  336,   -3 }, /* (118) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  337,   -1 }, /* (119) retention_list ::= retention */
  {  337,   -3 }, /* (120) retention_list ::= retention_list NK_COMMA retention */
  {  339,   -3 }, /* (121) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  334,    0 }, /* (122) speed_opt ::= */
  {  334,   -2 }, /* (123) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  317,   -9 }, /* (124) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  317,   -3 }, /* (125) cmd ::= CREATE TABLE multi_create_clause */
  {  317,   -9 }, /* (126) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  317,   -3 }, /* (127) cmd ::= DROP TABLE multi_drop_clause */
  {  317,   -4 }, /* (128) cmd ::= DROP STABLE exists_opt full_table_name */
  {  317,   -3 }, /* (129) cmd ::= ALTER TABLE alter_table_clause */
  {  317,   -3 }, /* (130) cmd ::= ALTER STABLE alter_table_clause */
  {  347,   -2 }, /* (131) alter_table_clause ::= full_table_name alter_table_options */
  {  347,   -5 }, /* (132) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  347,   -4 }, /* (133) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  347,   -5 }, /* (134) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  347,   -5 }, /* (135) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  347,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  347,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  347,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  347,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  347,   -6 }, /* (140) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  344,   -1 }, /* (141) multi_create_clause ::= create_subtable_clause */
  {  344,   -2 }, /* (142) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  352,  -10 }, /* (143) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  346,   -1 }, /* (144) multi_drop_clause ::= drop_table_clause */
  {  346,   -2 }, /* (145) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  355,   -2 }, /* (146) drop_table_clause ::= exists_opt full_table_name */
  {  353,    0 }, /* (147) specific_cols_opt ::= */
  {  353,   -3 }, /* (148) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  340,   -1 }, /* (149) full_table_name ::= table_name */
  {  340,   -3 }, /* (150) full_table_name ::= db_name NK_DOT table_name */
  {  341,   -1 }, /* (151) column_def_list ::= column_def */
  {  341,   -3 }, /* (152) column_def_list ::= column_def_list NK_COMMA column_def */
  {  358,   -2 }, /* (153) column_def ::= column_name type_name */
  {  358,   -4 }, /* (154) column_def ::= column_name type_name COMMENT NK_STRING */
  {  350,   -1 }, /* (155) type_name ::= BOOL */
  {  350,   -1 }, /* (156) type_name ::= TINYINT */
  {  350,   -1 }, /* (157) type_name ::= SMALLINT */
  {  350,   -1 }, /* (158) type_name ::= INT */
  {  350,   -1 }, /* (159) type_name ::= INTEGER */
  {  350,   -1 }, /* (160) type_name ::= BIGINT */
  {  350,   -1 }, /* (161) type_name ::= FLOAT */
  {  350,   -1 }, /* (162) type_name ::= DOUBLE */
  {  350,   -4 }, /* (163) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (164) type_name ::= TIMESTAMP */
  {  350,   -4 }, /* (165) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -2 }, /* (166) type_name ::= TINYINT UNSIGNED */
  {  350,   -2 }, /* (167) type_name ::= SMALLINT UNSIGNED */
  {  350,   -2 }, /* (168) type_name ::= INT UNSIGNED */
  {  350,   -2 }, /* (169) type_name ::= BIGINT UNSIGNED */
  {  350,   -1 }, /* (170) type_name ::= JSON */
  {  350,   -4 }, /* (171) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (172) type_name ::= MEDIUMBLOB */
  {  350,   -1 }, /* (173) type_name ::= BLOB */
  {  350,   -4 }, /* (174) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (175) type_name ::= DECIMAL */
  {  350,   -4 }, /* (176) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  350,   -6 }, /* (177) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  342,    0 }, /* (178) tags_def_opt ::= */
  {  342,   -1 }, /* (179) tags_def_opt ::= tags_def */
  {  345,   -4 }, /* (180) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  343,    0 }, /* (181) table_options ::= */
  {  343,   -3 }, /* (182) table_options ::= table_options COMMENT NK_STRING */
  {  343,   -3 }, /* (183) table_options ::= table_options MAX_DELAY duration_list */
  {  343,   -3 }, /* (184) table_options ::= table_options WATERMARK duration_list */
  {  343,   -5 }, /* (185) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  343,   -3 }, /* (186) table_options ::= table_options TTL NK_INTEGER */
  {  343,   -5 }, /* (187) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  348,   -1 }, /* (188) alter_table_options ::= alter_table_option */
  {  348,   -2 }, /* (189) alter_table_options ::= alter_table_options alter_table_option */
  {  361,   -2 }, /* (190) alter_table_option ::= COMMENT NK_STRING */
  {  361,   -2 }, /* (191) alter_table_option ::= TTL NK_INTEGER */
  {  359,   -1 }, /* (192) duration_list ::= duration_literal */
  {  359,   -3 }, /* (193) duration_list ::= duration_list NK_COMMA duration_literal */
  {  360,   -1 }, /* (194) rollup_func_list ::= rollup_func_name */
  {  360,   -3 }, /* (195) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  363,   -1 }, /* (196) rollup_func_name ::= function_name */
  {  363,   -1 }, /* (197) rollup_func_name ::= FIRST */
  {  363,   -1 }, /* (198) rollup_func_name ::= LAST */
  {  356,   -1 }, /* (199) col_name_list ::= col_name */
  {  356,   -3 }, /* (200) col_name_list ::= col_name_list NK_COMMA col_name */
  {  365,   -1 }, /* (201) col_name ::= column_name */
  {  317,   -2 }, /* (202) cmd ::= SHOW DNODES */
  {  317,   -2 }, /* (203) cmd ::= SHOW USERS */
  {  317,   -2 }, /* (204) cmd ::= SHOW DATABASES */
  {  317,   -4 }, /* (205) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  317,   -4 }, /* (206) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  317,   -3 }, /* (207) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  317,   -2 }, /* (208) cmd ::= SHOW MNODES */
  {  317,   -2 }, /* (209) cmd ::= SHOW MODULES */
  {  317,   -2 }, /* (210) cmd ::= SHOW QNODES */
  {  317,   -2 }, /* (211) cmd ::= SHOW FUNCTIONS */
  {  317,   -5 }, /* (212) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  317,   -2 }, /* (213) cmd ::= SHOW STREAMS */
  {  317,   -2 }, /* (214) cmd ::= SHOW ACCOUNTS */
  {  317,   -2 }, /* (215) cmd ::= SHOW APPS */
  {  317,   -2 }, /* (216) cmd ::= SHOW CONNECTIONS */
  {  317,   -2 }, /* (217) cmd ::= SHOW LICENCES */
  {  317,   -2 }, /* (218) cmd ::= SHOW GRANTS */
  {  317,   -4 }, /* (219) cmd ::= SHOW CREATE DATABASE db_name */
  {  317,   -4 }, /* (220) cmd ::= SHOW CREATE TABLE full_table_name */
  {  317,   -4 }, /* (221) cmd ::= SHOW CREATE STABLE full_table_name */
  {  317,   -2 }, /* (222) cmd ::= SHOW QUERIES */
  {  317,   -2 }, /* (223) cmd ::= SHOW SCORES */
  {  317,   -2 }, /* (224) cmd ::= SHOW TOPICS */
  {  317,   -2 }, /* (225) cmd ::= SHOW VARIABLES */
  {  317,   -3 }, /* (226) cmd ::= SHOW LOCAL VARIABLES */
  {  317,   -4 }, /* (227) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  317,   -2 }, /* (228) cmd ::= SHOW BNODES */
  {  317,   -2 }, /* (229) cmd ::= SHOW SNODES */
  {  317,   -2 }, /* (230) cmd ::= SHOW CLUSTER */
  {  317,   -2 }, /* (231) cmd ::= SHOW TRANSACTIONS */
  {  317,   -4 }, /* (232) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  317,   -2 }, /* (233) cmd ::= SHOW CONSUMERS */
  {  317,   -2 }, /* (234) cmd ::= SHOW SUBSCRIPTIONS */
  {  317,   -5 }, /* (235) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  317,   -6 }, /* (236) cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
  {  317,   -3 }, /* (237) cmd ::= SHOW VNODES NK_INTEGER */
  {  317,   -3 }, /* (238) cmd ::= SHOW VNODES NK_STRING */
  {  366,    0 }, /* (239) db_name_cond_opt ::= */
  {  366,   -2 }, /* (240) db_name_cond_opt ::= db_name NK_DOT */
  {  367,    0 }, /* (241) like_pattern_opt ::= */
  {  367,   -2 }, /* (242) like_pattern_opt ::= LIKE NK_STRING */
  {  368,   -1 }, /* (243) table_name_cond ::= table_name */
  {  369,    0 }, /* (244) from_db_opt ::= */
  {  369,   -2 }, /* (245) from_db_opt ::= FROM db_name */
  {  317,   -8 }, /* (246) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  317,   -4 }, /* (247) cmd ::= DROP INDEX exists_opt full_table_name */
  {  370,  -10 }, /* (248) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  370,  -12 }, /* (249) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  371,   -1 }, /* (250) func_list ::= func */
  {  371,   -3 }, /* (251) func_list ::= func_list NK_COMMA func */
  {  374,   -4 }, /* (252) func ::= function_name NK_LP expression_list NK_RP */
  {  373,    0 }, /* (253) sma_stream_opt ::= */
  {  373,   -3 }, /* (254) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  373,   -3 }, /* (255) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  317,   -6 }, /* (256) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  317,   -7 }, /* (257) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  317,   -9 }, /* (258) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  317,   -7 }, /* (259) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  317,   -9 }, /* (260) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  317,   -4 }, /* (261) cmd ::= DROP TOPIC exists_opt topic_name */
  {  317,   -7 }, /* (262) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  317,   -2 }, /* (263) cmd ::= DESC full_table_name */
  {  317,   -2 }, /* (264) cmd ::= DESCRIBE full_table_name */
  {  317,   -3 }, /* (265) cmd ::= RESET QUERY CACHE */
  {  317,   -4 }, /* (266) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  379,    0 }, /* (267) analyze_opt ::= */
  {  379,   -1 }, /* (268) analyze_opt ::= ANALYZE */
  {  380,    0 }, /* (269) explain_options ::= */
  {  380,   -3 }, /* (270) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  380,   -3 }, /* (271) explain_options ::= explain_options RATIO NK_FLOAT */
  {  317,  -10 }, /* (272) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  317,   -4 }, /* (273) cmd ::= DROP FUNCTION exists_opt function_name */
  {  381,    0 }, /* (274) agg_func_opt ::= */
  {  381,   -1 }, /* (275) agg_func_opt ::= AGGREGATE */
  {  382,    0 }, /* (276) bufsize_opt ::= */
  {  382,   -2 }, /* (277) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  317,  -11 }, /* (278) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  317,   -4 }, /* (279) cmd ::= DROP STREAM exists_opt stream_name */
  {  375,    0 }, /* (280) stream_options ::= */
  {  375,   -3 }, /* (281) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  375,   -3 }, /* (282) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  375,   -4 }, /* (283) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  375,   -3 }, /* (284) stream_options ::= stream_options WATERMARK duration_literal */
  {  375,   -4 }, /* (285) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  384,    0 }, /* (286) subtable_opt ::= */
  {  384,   -4 }, /* (287) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  317,   -3 }, /* (288) cmd ::= KILL CONNECTION NK_INTEGER */
  {  317,   -3 }, /* (289) cmd ::= KILL QUERY NK_STRING */
  {  317,   -3 }, /* (290) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  317,   -2 }, /* (291) cmd ::= BALANCE VGROUP */
  {  317,   -4 }, /* (292) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  317,   -4 }, /* (293) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  317,   -3 }, /* (294) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  386,   -2 }, /* (295) dnode_list ::= DNODE NK_INTEGER */
  {  386,   -3 }, /* (296) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  317,   -4 }, /* (297) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  317,   -1 }, /* (298) cmd ::= query_or_subquery */
  {  317,   -7 }, /* (299) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  317,   -4 }, /* (300) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  320,   -1 }, /* (301) literal ::= NK_INTEGER */
  {  320,   -1 }, /* (302) literal ::= NK_FLOAT */
  {  320,   -1 }, /* (303) literal ::= NK_STRING */
  {  320,   -1 }, /* (304) literal ::= NK_BOOL */
  {  320,   -2 }, /* (305) literal ::= TIMESTAMP NK_STRING */
  {  320,   -1 }, /* (306) literal ::= duration_literal */
  {  320,   -1 }, /* (307) literal ::= NULL */
  {  320,   -1 }, /* (308) literal ::= NK_QUESTION */
  {  362,   -1 }, /* (309) duration_literal ::= NK_VARIABLE */
  {  388,   -1 }, /* (310) signed ::= NK_INTEGER */
  {  388,   -2 }, /* (311) signed ::= NK_PLUS NK_INTEGER */
  {  388,   -2 }, /* (312) signed ::= NK_MINUS NK_INTEGER */
  {  388,   -1 }, /* (313) signed ::= NK_FLOAT */
  {  388,   -2 }, /* (314) signed ::= NK_PLUS NK_FLOAT */
  {  388,   -2 }, /* (315) signed ::= NK_MINUS NK_FLOAT */
  {  351,   -1 }, /* (316) signed_literal ::= signed */
  {  351,   -1 }, /* (317) signed_literal ::= NK_STRING */
  {  351,   -1 }, /* (318) signed_literal ::= NK_BOOL */
  {  351,   -2 }, /* (319) signed_literal ::= TIMESTAMP NK_STRING */
  {  351,   -1 }, /* (320) signed_literal ::= duration_literal */
  {  351,   -1 }, /* (321) signed_literal ::= NULL */
  {  351,   -1 }, /* (322) signed_literal ::= literal_func */
  {  351,   -1 }, /* (323) signed_literal ::= NK_QUESTION */
  {  390,   -1 }, /* (324) literal_list ::= signed_literal */
  {  390,   -3 }, /* (325) literal_list ::= literal_list NK_COMMA signed_literal */
  {  328,   -1 }, /* (326) db_name ::= NK_ID */
  {  357,   -1 }, /* (327) table_name ::= NK_ID */
  {  349,   -1 }, /* (328) column_name ::= NK_ID */
  {  364,   -1 }, /* (329) function_name ::= NK_ID */
  {  391,   -1 }, /* (330) table_alias ::= NK_ID */
  {  392,   -1 }, /* (331) column_alias ::= NK_ID */
  {  322,   -1 }, /* (332) user_name ::= NK_ID */
  {  376,   -1 }, /* (333) topic_name ::= NK_ID */
  {  383,   -1 }, /* (334) stream_name ::= NK_ID */
  {  378,   -1 }, /* (335) cgroup_name ::= NK_ID */
  {  393,   -1 }, /* (336) expr_or_subquery ::= expression */
  {  393,   -1 }, /* (337) expr_or_subquery ::= subquery */
  {  385,   -1 }, /* (338) expression ::= literal */
  {  385,   -1 }, /* (339) expression ::= pseudo_column */
  {  385,   -1 }, /* (340) expression ::= column_reference */
  {  385,   -1 }, /* (341) expression ::= function_expression */
  {  385,   -1 }, /* (342) expression ::= case_when_expression */
  {  385,   -3 }, /* (343) expression ::= NK_LP expression NK_RP */
  {  385,   -2 }, /* (344) expression ::= NK_PLUS expr_or_subquery */
  {  385,   -2 }, /* (345) expression ::= NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (346) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  385,   -3 }, /* (347) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (348) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  385,   -3 }, /* (349) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  385,   -3 }, /* (350) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  385,   -3 }, /* (351) expression ::= column_reference NK_ARROW NK_STRING */
  {  385,   -3 }, /* (352) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  385,   -3 }, /* (353) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  354,   -1 }, /* (354) expression_list ::= expr_or_subquery */
  {  354,   -3 }, /* (355) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  396,   -1 }, /* (356) column_reference ::= column_name */
  {  396,   -3 }, /* (357) column_reference ::= table_name NK_DOT column_name */
  {  395,   -1 }, /* (358) pseudo_column ::= ROWTS */
  {  395,   -1 }, /* (359) pseudo_column ::= TBNAME */
  {  395,   -3 }, /* (360) pseudo_column ::= table_name NK_DOT TBNAME */
  {  395,   -1 }, /* (361) pseudo_column ::= QSTART */
  {  395,   -1 }, /* (362) pseudo_column ::= QEND */
  {  395,   -1 }, /* (363) pseudo_column ::= QDURATION */
  {  395,   -1 }, /* (364) pseudo_column ::= WSTART */
  {  395,   -1 }, /* (365) pseudo_column ::= WEND */
  {  395,   -1 }, /* (366) pseudo_column ::= WDURATION */
  {  395,   -1 }, /* (367) pseudo_column ::= IROWTS */
  {  395,   -1 }, /* (368) pseudo_column ::= QTAGS */
  {  397,   -4 }, /* (369) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  397,   -4 }, /* (370) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  397,   -6 }, /* (371) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  397,   -1 }, /* (372) function_expression ::= literal_func */
  {  389,   -3 }, /* (373) literal_func ::= noarg_func NK_LP NK_RP */
  {  389,   -1 }, /* (374) literal_func ::= NOW */
  {  401,   -1 }, /* (375) noarg_func ::= NOW */
  {  401,   -1 }, /* (376) noarg_func ::= TODAY */
  {  401,   -1 }, /* (377) noarg_func ::= TIMEZONE */
  {  401,   -1 }, /* (378) noarg_func ::= DATABASE */
  {  401,   -1 }, /* (379) noarg_func ::= CLIENT_VERSION */
  {  401,   -1 }, /* (380) noarg_func ::= SERVER_VERSION */
  {  401,   -1 }, /* (381) noarg_func ::= SERVER_STATUS */
  {  401,   -1 }, /* (382) noarg_func ::= CURRENT_USER */
  {  401,   -1 }, /* (383) noarg_func ::= USER */
  {  399,   -1 }, /* (384) star_func ::= COUNT */
  {  399,   -1 }, /* (385) star_func ::= FIRST */
  {  399,   -1 }, /* (386) star_func ::= LAST */
  {  399,   -1 }, /* (387) star_func ::= LAST_ROW */
  {  400,   -1 }, /* (388) star_func_para_list ::= NK_STAR */
  {  400,   -1 }, /* (389) star_func_para_list ::= other_para_list */
  {  402,   -1 }, /* (390) other_para_list ::= star_func_para */
  {  402,   -3 }, /* (391) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  403,   -1 }, /* (392) star_func_para ::= expr_or_subquery */
  {  403,   -3 }, /* (393) star_func_para ::= table_name NK_DOT NK_STAR */
  {  398,   -4 }, /* (394) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  398,   -5 }, /* (395) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  404,   -1 }, /* (396) when_then_list ::= when_then_expr */
  {  404,   -2 }, /* (397) when_then_list ::= when_then_list when_then_expr */
  {  407,   -4 }, /* (398) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  405,    0 }, /* (399) case_when_else_opt ::= */
  {  405,   -2 }, /* (400) case_when_else_opt ::= ELSE common_expression */
  {  408,   -3 }, /* (401) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  408,   -5 }, /* (402) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -6 }, /* (403) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -3 }, /* (404) predicate ::= expr_or_subquery IS NULL */
  {  408,   -4 }, /* (405) predicate ::= expr_or_subquery IS NOT NULL */
  {  408,   -3 }, /* (406) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  409,   -1 }, /* (407) compare_op ::= NK_LT */
  {  409,   -1 }, /* (408) compare_op ::= NK_GT */
  {  409,   -1 }, /* (409) compare_op ::= NK_LE */
  {  409,   -1 }, /* (410) compare_op ::= NK_GE */
  {  409,   -1 }, /* (411) compare_op ::= NK_NE */
  {  409,   -1 }, /* (412) compare_op ::= NK_EQ */
  {  409,   -1 }, /* (413) compare_op ::= LIKE */
  {  409,   -2 }, /* (414) compare_op ::= NOT LIKE */
  {  409,   -1 }, /* (415) compare_op ::= MATCH */
  {  409,   -1 }, /* (416) compare_op ::= NMATCH */
  {  409,   -1 }, /* (417) compare_op ::= CONTAINS */
  {  410,   -1 }, /* (418) in_op ::= IN */
  {  410,   -2 }, /* (419) in_op ::= NOT IN */
  {  411,   -3 }, /* (420) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  412,   -1 }, /* (421) boolean_value_expression ::= boolean_primary */
  {  412,   -2 }, /* (422) boolean_value_expression ::= NOT boolean_primary */
  {  412,   -3 }, /* (423) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  412,   -3 }, /* (424) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  413,   -1 }, /* (425) boolean_primary ::= predicate */
  {  413,   -3 }, /* (426) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  406,   -1 }, /* (427) common_expression ::= expr_or_subquery */
  {  406,   -1 }, /* (428) common_expression ::= boolean_value_expression */
  {  414,    0 }, /* (429) from_clause_opt ::= */
  {  414,   -2 }, /* (430) from_clause_opt ::= FROM table_reference_list */
  {  415,   -1 }, /* (431) table_reference_list ::= table_reference */
  {  415,   -3 }, /* (432) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  416,   -1 }, /* (433) table_reference ::= table_primary */
  {  416,   -1 }, /* (434) table_reference ::= joined_table */
  {  417,   -2 }, /* (435) table_primary ::= table_name alias_opt */
  {  417,   -4 }, /* (436) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  417,   -2 }, /* (437) table_primary ::= subquery alias_opt */
  {  417,   -1 }, /* (438) table_primary ::= parenthesized_joined_table */
  {  419,    0 }, /* (439) alias_opt ::= */
  {  419,   -1 }, /* (440) alias_opt ::= table_alias */
  {  419,   -2 }, /* (441) alias_opt ::= AS table_alias */
  {  420,   -3 }, /* (442) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  420,   -3 }, /* (443) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  418,   -6 }, /* (444) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  421,    0 }, /* (445) join_type ::= */
  {  421,   -1 }, /* (446) join_type ::= INNER */
  {  423,  -12 }, /* (447) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  424,    0 }, /* (448) set_quantifier_opt ::= */
  {  424,   -1 }, /* (449) set_quantifier_opt ::= DISTINCT */
  {  424,   -1 }, /* (450) set_quantifier_opt ::= ALL */
  {  425,   -1 }, /* (451) select_list ::= select_item */
  {  425,   -3 }, /* (452) select_list ::= select_list NK_COMMA select_item */
  {  433,   -1 }, /* (453) select_item ::= NK_STAR */
  {  433,   -1 }, /* (454) select_item ::= common_expression */
  {  433,   -2 }, /* (455) select_item ::= common_expression column_alias */
  {  433,   -3 }, /* (456) select_item ::= common_expression AS column_alias */
  {  433,   -3 }, /* (457) select_item ::= table_name NK_DOT NK_STAR */
  {  387,    0 }, /* (458) where_clause_opt ::= */
  {  387,   -2 }, /* (459) where_clause_opt ::= WHERE search_condition */
  {  426,    0 }, /* (460) partition_by_clause_opt ::= */
  {  426,   -3 }, /* (461) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  434,   -1 }, /* (462) partition_list ::= partition_item */
  {  434,   -3 }, /* (463) partition_list ::= partition_list NK_COMMA partition_item */
  {  435,   -1 }, /* (464) partition_item ::= expr_or_subquery */
  {  435,   -2 }, /* (465) partition_item ::= expr_or_subquery column_alias */
  {  435,   -3 }, /* (466) partition_item ::= expr_or_subquery AS column_alias */
  {  430,    0 }, /* (467) twindow_clause_opt ::= */
  {  430,   -6 }, /* (468) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  430,   -4 }, /* (469) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  430,   -6 }, /* (470) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  430,   -8 }, /* (471) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  372,    0 }, /* (472) sliding_opt ::= */
  {  372,   -4 }, /* (473) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  429,    0 }, /* (474) fill_opt ::= */
  {  429,   -4 }, /* (475) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  429,   -6 }, /* (476) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  436,   -1 }, /* (477) fill_mode ::= NONE */
  {  436,   -1 }, /* (478) fill_mode ::= PREV */
  {  436,   -1 }, /* (479) fill_mode ::= NULL */
  {  436,   -1 }, /* (480) fill_mode ::= LINEAR */
  {  436,   -1 }, /* (481) fill_mode ::= NEXT */
  {  431,    0 }, /* (482) group_by_clause_opt ::= */
  {  431,   -3 }, /* (483) group_by_clause_opt ::= GROUP BY group_by_list */
  {  437,   -1 }, /* (484) group_by_list ::= expr_or_subquery */
  {  437,   -3 }, /* (485) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  432,    0 }, /* (486) having_clause_opt ::= */
  {  432,   -2 }, /* (487) having_clause_opt ::= HAVING search_condition */
  {  427,    0 }, /* (488) range_opt ::= */
  {  427,   -6 }, /* (489) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  428,    0 }, /* (490) every_opt ::= */
  {  428,   -4 }, /* (491) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  438,   -4 }, /* (492) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  439,   -1 }, /* (493) query_simple ::= query_specification */
  {  439,   -1 }, /* (494) query_simple ::= union_query_expression */
  {  443,   -4 }, /* (495) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  443,   -3 }, /* (496) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  444,   -1 }, /* (497) query_simple_or_subquery ::= query_simple */
  {  444,   -1 }, /* (498) query_simple_or_subquery ::= subquery */
  {  377,   -1 }, /* (499) query_or_subquery ::= query_expression */
  {  377,   -1 }, /* (500) query_or_subquery ::= subquery */
  {  440,    0 }, /* (501) order_by_clause_opt ::= */
  {  440,   -3 }, /* (502) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  441,    0 }, /* (503) slimit_clause_opt ::= */
  {  441,   -2 }, /* (504) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  441,   -4 }, /* (505) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  441,   -4 }, /* (506) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  442,    0 }, /* (507) limit_clause_opt ::= */
  {  442,   -2 }, /* (508) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  442,   -4 }, /* (509) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  442,   -4 }, /* (510) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  394,   -3 }, /* (511) subquery ::= NK_LP query_expression NK_RP */
  {  394,   -3 }, /* (512) subquery ::= NK_LP subquery NK_RP */
  {  422,   -1 }, /* (513) search_condition ::= common_expression */
  {  445,   -1 }, /* (514) sort_specification_list ::= sort_specification */
  {  445,   -3 }, /* (515) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  446,   -3 }, /* (516) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  447,    0 }, /* (517) ordering_specification_opt ::= */
  {  447,   -1 }, /* (518) ordering_specification_opt ::= ASC */
  {  447,   -1 }, /* (519) ordering_specification_opt ::= DESC */
  {  448,    0 }, /* (520) null_ordering_opt ::= */
  {  448,   -2 }, /* (521) null_ordering_opt ::= NULLS FIRST */
  {  448,   -2 }, /* (522) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,318,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,319,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,318,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,319,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,321,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy0, yymsp[0].minor.yy293); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy293 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy293 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy831 = yymsp[0].minor.yy831; }
  yymsp[0].minor.yy831 = yylhsminor.yy831;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy831 = yymsp[-2].minor.yy831 | yymsp[0].minor.yy831; }
  yymsp[-2].minor.yy831 = yylhsminor.yy831;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy181; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy181, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 326: /* db_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* table_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* column_name ::= NK_ID */ yytestcase(yyruleno==328);
      case 329: /* function_name ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* table_alias ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* column_alias ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* user_name ::= NK_ID */ yytestcase(yyruleno==332);
      case 333: /* topic_name ::= NK_ID */ yytestcase(yyruleno==333);
      case 334: /* stream_name ::= NK_ID */ yytestcase(yyruleno==334);
      case 335: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==335);
      case 375: /* noarg_func ::= NOW */ yytestcase(yyruleno==375);
      case 376: /* noarg_func ::= TODAY */ yytestcase(yyruleno==376);
      case 377: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==377);
      case 378: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==378);
      case 379: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==379);
      case 380: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==380);
      case 381: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==381);
      case 382: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==382);
      case 383: /* noarg_func ::= USER */ yytestcase(yyruleno==383);
      case 384: /* star_func ::= COUNT */ yytestcase(yyruleno==384);
      case 385: /* star_func ::= FIRST */ yytestcase(yyruleno==385);
      case 386: /* star_func ::= LAST */ yytestcase(yyruleno==386);
      case 387: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==387);
{ yylhsminor.yy181 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy39, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy276); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy39 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 267: /* analyze_opt ::= */ yytestcase(yyruleno==267);
      case 274: /* agg_func_opt ::= */ yytestcase(yyruleno==274);
      case 448: /* set_quantifier_opt ::= */ yytestcase(yyruleno==448);
{ yymsp[1].minor.yy39 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy39 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy778 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_KEEP, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_RETENTIONS, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy778 = createAlterDatabaseOptions(pCxt); yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yylhsminor.yy778, &yymsp[0].minor.yy645); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy778, &yymsp[0].minor.yy645); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 106: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= KEEP integer_list */
      case 111: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==111);
{ yymsp[-1].minor.yy645.type = DB_OPTION_KEEP; yymsp[-1].minor.yy645.pList = yymsp[0].minor.yy282; }
        break;
      case 112: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_PAGES; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_WAL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 116: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 296: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==296);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 117: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy282 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 118: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 119: /* retention_list ::= retention */
      case 141: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==141);
      case 144: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==144);
      case 151: /* column_def_list ::= column_def */ yytestcase(yyruleno==151);
      case 194: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==194);
      case 199: /* col_name_list ::= col_name */ yytestcase(yyruleno==199);
      case 250: /* func_list ::= func */ yytestcase(yyruleno==250);
      case 324: /* literal_list ::= signed_literal */ yytestcase(yyruleno==324);
      case 390: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==390);
      case 396: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==396);
      case 451: /* select_list ::= select_item */ yytestcase(yyruleno==451);
      case 462: /* partition_list ::= partition_item */ yytestcase(yyruleno==462);
      case 514: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==514);
{ yylhsminor.yy282 = createNodeList(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 120: /* retention_list ::= retention_list NK_COMMA retention */
      case 152: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==152);
      case 195: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==195);
      case 200: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==200);
      case 251: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==251);
      case 325: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==325);
      case 391: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==391);
      case 452: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==452);
      case 463: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==463);
      case 515: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==515);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 121: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy778 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 122: /* speed_opt ::= */
      case 276: /* bufsize_opt ::= */ yytestcase(yyruleno==276);
{ yymsp[1].minor.yy276 = 0; }
        break;
      case 123: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 277: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==277);
{ yymsp[-1].minor.yy276 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 124: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 126: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==126);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-5].minor.yy778, yymsp[-3].minor.yy282, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 125: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 127: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 128: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 129: /* cmd ::= ALTER TABLE alter_table_clause */
      case 298: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==298);
{ pCxt->pRootNode = yymsp[0].minor.yy778; }
        break;
      case 130: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy778); }
        break;
      case 131: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy778 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 132: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 133: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 134: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 135: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 140: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy778 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy778, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 142: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 145: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==145);
      case 397: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==397);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy282 = yylhsminor.yy282;
        break;
      case 143: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy778 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy39, yymsp[-8].minor.yy778, yymsp[-6].minor.yy778, yymsp[-5].minor.yy282, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-9].minor.yy778 = yylhsminor.yy778;
        break;
      case 146: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy778 = createDropTableClause(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 147: /* specific_cols_opt ::= */
      case 178: /* tags_def_opt ::= */ yytestcase(yyruleno==178);
      case 460: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==460);
      case 482: /* group_by_clause_opt ::= */ yytestcase(yyruleno==482);
      case 501: /* order_by_clause_opt ::= */ yytestcase(yyruleno==501);
{ yymsp[1].minor.yy282 = NULL; }
        break;
      case 148: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 149: /* full_table_name ::= table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 150: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 153: /* column_def ::= column_name type_name */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380, NULL); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 154: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-2].minor.yy380, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 155: /* type_name ::= BOOL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 156: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 157: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 158: /* type_name ::= INT */
      case 159: /* type_name ::= INTEGER */ yytestcase(yyruleno==159);
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 160: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 161: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 162: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 163: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 164: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 165: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 167: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 168: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 169: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 170: /* type_name ::= JSON */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 171: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 172: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 173: /* type_name ::= BLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 174: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 175: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 176: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 177: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 179: /* tags_def_opt ::= tags_def */
      case 389: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==389);
{ yylhsminor.yy282 = yymsp[0].minor.yy282; }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 180: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 181: /* table_options ::= */
{ yymsp[1].minor.yy778 = createDefaultTableOptions(pCxt); }
        break;
      case 182: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 183: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 184: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 185: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 186: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 187: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_SMA, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 188: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy778 = createAlterTableOptions(pCxt); yylhsminor.yy778 = setTableOption(pCxt, yylhsminor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 189: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 190: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 191: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 192: /* duration_list ::= duration_literal */
      case 354: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==354);
{ yylhsminor.yy282 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 193: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 355: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==355);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 196: /* rollup_func_name ::= function_name */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 197: /* rollup_func_name ::= FIRST */
      case 198: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==198);
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 201: /* col_name ::= column_name */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 202: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 203: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 204: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 205: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 206: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 207: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy778, NULL, OP_TYPE_LIKE); }
        break;
      case 208: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 210: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 211: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 212: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 213: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 214: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 215: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 216: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW LICENCES */
      case 218: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==218);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 219: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 220: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 221: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 222: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 223: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 224: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 225: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 226: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 227: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 228: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 230: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 231: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 232: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 233: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 234: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 235: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 236: /* cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLE_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 237: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 238: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 239: /* db_name_cond_opt ::= */
      case 244: /* from_db_opt ::= */ yytestcase(yyruleno==244);
{ yymsp[1].minor.yy778 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 240: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 241: /* like_pattern_opt ::= */
      case 286: /* subtable_opt ::= */ yytestcase(yyruleno==286);
      case 399: /* case_when_else_opt ::= */ yytestcase(yyruleno==399);
      case 429: /* from_clause_opt ::= */ yytestcase(yyruleno==429);
      case 458: /* where_clause_opt ::= */ yytestcase(yyruleno==458);
      case 467: /* twindow_clause_opt ::= */ yytestcase(yyruleno==467);
      case 472: /* sliding_opt ::= */ yytestcase(yyruleno==472);
      case 474: /* fill_opt ::= */ yytestcase(yyruleno==474);
      case 486: /* having_clause_opt ::= */ yytestcase(yyruleno==486);
      case 488: /* range_opt ::= */ yytestcase(yyruleno==488);
      case 490: /* every_opt ::= */ yytestcase(yyruleno==490);
      case 503: /* slimit_clause_opt ::= */ yytestcase(yyruleno==503);
      case 507: /* limit_clause_opt ::= */ yytestcase(yyruleno==507);
{ yymsp[1].minor.yy778 = NULL; }
        break;
      case 242: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 243: /* table_name_cond ::= table_name */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 245: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy181); }
        break;
      case 246: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy39, yymsp[-3].minor.yy778, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 247: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 248: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy778 = createIndexOption(pCxt, yymsp[-7].minor.yy282, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 249: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy778 = createIndexOption(pCxt, yymsp[-9].minor.yy282, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 252: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 253: /* sma_stream_opt ::= */
      case 280: /* stream_options ::= */ yytestcase(yyruleno==280);
{ yymsp[1].minor.yy778 = createStreamOptions(pCxt); }
        break;
      case 254: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 284: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==284);
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 255: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 256: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 257: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy181, false); }
        break;
      case 258: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[0].minor.yy181, true); }
        break;
      case 259: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, yymsp[0].minor.yy778, false); }
        break;
      case 260: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, yymsp[0].minor.yy778, true); }
        break;
      case 261: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 262: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 263: /* cmd ::= DESC full_table_name */
      case 264: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==264);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 265: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 266: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy39, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 268: /* analyze_opt ::= ANALYZE */
      case 275: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==275);
      case 449: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==449);
{ yymsp[0].minor.yy39 = true; }
        break;
      case 269: /* explain_options ::= */
{ yymsp[1].minor.yy778 = createDefaultExplainOptions(pCxt); }
        break;
      case 270: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy778 = setExplainVerbose(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 271: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy778 = setExplainRatio(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 272: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-8].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy380, yymsp[0].minor.yy276); }
        break;
      case 273: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 278: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy39, &yymsp[-7].minor.yy181, yymsp[-4].minor.yy778, yymsp[-6].minor.yy778, yymsp[-3].minor.yy282, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 279: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 281: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 282: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 283: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 285: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 287: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 473: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==473);
      case 491: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==491);
{ yymsp[-3].minor.yy778 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy778); }
        break;
      case 288: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 289: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 290: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 291: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 292: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 293: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy282); }
        break;
      case 294: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 295: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 297: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 299: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy778, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 300: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 301: /* literal ::= NK_INTEGER */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 302: /* literal ::= NK_FLOAT */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 303: /* literal ::= NK_STRING */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 304: /* literal ::= NK_BOOL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 305: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 306: /* literal ::= duration_literal */
      case 316: /* signed_literal ::= signed */ yytestcase(yyruleno==316);
      case 336: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==336);
      case 337: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==337);
      case 338: /* expression ::= literal */ yytestcase(yyruleno==338);
      case 339: /* expression ::= pseudo_column */ yytestcase(yyruleno==339);
      case 340: /* expression ::= column_reference */ yytestcase(yyruleno==340);
      case 341: /* expression ::= function_expression */ yytestcase(yyruleno==341);
      case 342: /* expression ::= case_when_expression */ yytestcase(yyruleno==342);
      case 372: /* function_expression ::= literal_func */ yytestcase(yyruleno==372);
      case 421: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==421);
      case 425: /* boolean_primary ::= predicate */ yytestcase(yyruleno==425);
      case 427: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==427);
      case 428: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==428);
      case 431: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==431);
      case 433: /* table_reference ::= table_primary */ yytestcase(yyruleno==433);
      case 434: /* table_reference ::= joined_table */ yytestcase(yyruleno==434);
      case 438: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==438);
      case 493: /* query_simple ::= query_specification */ yytestcase(yyruleno==493);
      case 494: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==494);
      case 497: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==497);
      case 499: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==499);
{ yylhsminor.yy778 = yymsp[0].minor.yy778; }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 307: /* literal ::= NULL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 308: /* literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 309: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 310: /* signed ::= NK_INTEGER */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 311: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 312: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 313: /* signed ::= NK_FLOAT */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 314: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 315: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 317: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 318: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 319: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 320: /* signed_literal ::= duration_literal */
      case 322: /* signed_literal ::= literal_func */ yytestcase(yyruleno==322);
      case 392: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==392);
      case 454: /* select_item ::= common_expression */ yytestcase(yyruleno==454);
      case 464: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==464);
      case 498: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==498);
      case 500: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==500);
      case 513: /* search_condition ::= common_expression */ yytestcase(yyruleno==513);
{ yylhsminor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 321: /* signed_literal ::= NULL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 323: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 343: /* expression ::= NK_LP expression NK_RP */
      case 426: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==426);
      case 512: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==512);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 344: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy778));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 345: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 346: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 347: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 348: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 349: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 350: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 351: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 352: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 353: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 356: /* column_reference ::= column_name */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy181, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 357: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 358: /* pseudo_column ::= ROWTS */
      case 359: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==359);
      case 361: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==361);
      case 362: /* pseudo_column ::= QEND */ yytestcase(yyruleno==362);
      case 363: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==363);
      case 364: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==364);
      case 365: /* pseudo_column ::= WEND */ yytestcase(yyruleno==365);
      case 366: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==366);
      case 367: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==367);
      case 368: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==368);
      case 374: /* literal_func ::= NOW */ yytestcase(yyruleno==374);
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 360: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy181)))); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 369: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 370: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==370);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 371: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy380)); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 373: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy181, NULL)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 388: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy282 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 393: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 457: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==457);
{ yylhsminor.yy778 = createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 394: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 395: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 398: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy778 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
        break;
      case 400: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
        break;
      case 401: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 406: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==406);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy682, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 402: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 403: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 404: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), NULL));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 405: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL));
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 407: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_THAN; }
        break;
      case 408: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_THAN; }
        break;
      case 409: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 410: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 411: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy682 = OP_TYPE_NOT_EQUAL; }
        break;
      case 412: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy682 = OP_TYPE_EQUAL; }
        break;
      case 413: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy682 = OP_TYPE_LIKE; }
        break;
      case 414: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_LIKE; }
        break;
      case 415: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_MATCH; }
        break;
      case 416: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_NMATCH; }
        break;
      case 417: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy682 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 418: /* in_op ::= IN */
{ yymsp[0].minor.yy682 = OP_TYPE_IN; }
        break;
      case 419: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_IN; }
        break;
      case 420: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 422: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 423: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 424: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 430: /* from_clause_opt ::= FROM table_reference_list */
      case 459: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==459);
      case 487: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==487);
{ yymsp[-1].minor.yy778 = yymsp[0].minor.yy778; }
        break;
      case 432: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 435: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 436: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 437: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy778 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 439: /* alias_opt ::= */
{ yymsp[1].minor.yy181 = nil_token;  }
        break;
      case 440: /* alias_opt ::= table_alias */
{ yylhsminor.yy181 = yymsp[0].minor.yy181; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 441: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy181 = yymsp[0].minor.yy181; }
        break;
      case 442: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 443: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==443);
{ yymsp[-2].minor.yy778 = yymsp[-1].minor.yy778; }
        break;
      case 444: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, yymsp[-4].minor.yy202, yymsp[-5].minor.yy778, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 445: /* join_type ::= */
{ yymsp[1].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 446: /* join_type ::= INNER */
{ yymsp[0].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 447: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy778 = createSelectStmt(pCxt, yymsp[-10].minor.yy39, yymsp[-9].minor.yy282, yymsp[-8].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addWhereClause(pCxt, yymsp[-11].minor.yy778, yymsp[-7].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addPartitionByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-6].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy778, yymsp[-2].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addGroupByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-1].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addHavingClause(pCxt, yymsp[-11].minor.yy778, yymsp[0].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addRangeClause(pCxt, yymsp[-11].minor.yy778, yymsp[-5].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addEveryClause(pCxt, yymsp[-11].minor.yy778, yymsp[-4].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addFillClause(pCxt, yymsp[-11].minor.yy778, yymsp[-3].minor.yy778);
                                                                                  }
        break;
      case 450: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy39 = false; }
        break;
      case 453: /* select_item ::= NK_STAR */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 455: /* select_item ::= common_expression column_alias */
      case 465: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==465);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 456: /* select_item ::= common_expression AS column_alias */
      case 466: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==466);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 461: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 483: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==483);
      case 502: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==502);
{ yymsp[-2].minor.yy282 = yymsp[0].minor.yy282; }
        break;
      case 468: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy778 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 469: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy778 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 470: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 471: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 475: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy778 = createFillNode(pCxt, yymsp[-1].minor.yy381, NULL); }
        break;
      case 476: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy778 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
        break;
      case 477: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy381 = FILL_MODE_NONE; }
        break;
      case 478: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy381 = FILL_MODE_PREV; }
        break;
      case 479: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy381 = FILL_MODE_NULL; }
        break;
      case 480: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy381 = FILL_MODE_LINEAR; }
        break;
      case 481: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy381 = FILL_MODE_NEXT; }
        break;
      case 484: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy282 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 485: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 489: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy778 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 492: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy778 = addOrderByClause(pCxt, yymsp[-3].minor.yy778, yymsp[-2].minor.yy282);
                                                                                    yylhsminor.yy778 = addSlimitClause(pCxt, yylhsminor.yy778, yymsp[-1].minor.yy778);
                                                                                    yylhsminor.yy778 = addLimitClause(pCxt, yylhsminor.yy778, yymsp[0].minor.yy778);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 495: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 496: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 504: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 508: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==508);
{ yymsp[-1].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 505: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 509: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==509);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 506: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 510: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==510);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 511: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 516: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy778 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), yymsp[-1].minor.yy14, yymsp[0].minor.yy305); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 517: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 518: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 519: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 520: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy305 = NULL_ORDER_DEFAULT; }
        break;
      case 521: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_FIRST; }
        break;
      case 522: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
