/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 371
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy81;
  int64_t yy179;
  ENullOrder yy193;
  bool yy215;
  EFillMode yy256;
  EOrder yy372;
  int8_t yy439;
  SDataType yy490;
  int32_t yy550;
  EJoinType yy568;
  SNodeList* yy656;
  EOperatorType yy688;
  SNode* yy714;
  SToken yy729;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             656
#define YYNRULE              478
#define YYNTOKEN             247
#define YY_MAX_SHIFT         655
#define YY_MIN_SHIFTREDUCE   950
#define YY_MAX_SHIFTREDUCE   1427
#define YY_ERROR_ACTION      1428
#define YY_ACCEPT_ACTION     1429
#define YY_NO_ACTION         1430
#define YY_MIN_REDUCE        1431
#define YY_MAX_REDUCE        1908
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2427)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   425, 1886,  426, 1466,  433,  570,  426, 1466,  140,  331,
 /*    10 */  1443,  380,   39,   37, 1555, 1885,  111,  138, 1735, 1883,
 /*    20 */   327,  318, 1234,  463,  569, 1735, 1568,  529,  335, 1732,
 /*    30 */    36,   35,   34, 1566,  101, 1232, 1732,  100,   99,   98,
 /*    40 */    97,   96,   95,   94,   93,   92,   33,   32,  297, 1748,
 /*    50 */    40,   38,   36,   35,   34,  119, 1728, 1734, 1666,  374,
 /*    60 */    14,   30,  241, 1728, 1734, 1748, 1240,  573,   40,   38,
 /*    70 */    36,   35,   34, 1000,  573,  999,  430, 1766,  442,   39,
 /*    80 */    37, 1364, 1256,    1,  523,  553,   60,  327,  461, 1234,
 /*    90 */  1718,  569,  552, 1766,  141,  117, 1259,   60, 1523, 1886,
 /*   100 */   569,  550, 1232, 1001,  570,  652, 1718,  533,  552,  531,
 /*   110 */   153, 1827, 1828,  156, 1832,  161, 1258, 1883, 1779, 1305,
 /*   120 */  1306,   87, 1749,  555, 1751, 1752,  551,   14,  573,  983,
 /*   130 */  1454, 1819, 1566, 1240, 1779,  299, 1815,  288, 1749,  555,
 /*   140 */  1751, 1752,  551,  549,  573,  546, 1791, 1886,  655,  166,
 /*   150 */     2,   33,   32, 1738,   43,   40,   38,   36,   35,   34,
 /*   160 */  1766,  158,  263,   42, 1235, 1883, 1233,   61,  522,  987,
 /*   170 */   988, 1718,  652,   58,  311,   67,  149,  373,   66,  372,
 /*   180 */  1453,  645,  641,  637,  633,  261, 1305, 1306, 1238, 1239,
 /*   190 */  1740, 1287, 1288, 1290, 1291, 1292, 1293, 1294,  548,  571,
 /*   200 */  1302, 1303, 1304, 1307, 1557, 1259,  521,  529,  296,  339,
 /*   210 */  1256,   85, 1611, 1613,  255, 1732,  159,  406, 1371,  159,
 /*   220 */   418, 1718, 1886,  312, 1258,  310,  309, 1398,  465,  605,
 /*   230 */   159, 1235,  467, 1233, 1656,  119,  157,  391,  203,  419,
 /*   240 */  1883,  393, 1728, 1734,  210,  168,   60,  566,  129,  128,
 /*   250 */   602,  601,  600,  573,  466, 1238, 1239,  607, 1287, 1288,
 /*   260 */  1290, 1291, 1292, 1293, 1294,  548,  571, 1302, 1303, 1304,
 /*   270 */  1307,   60,  384,   73, 1257,  117,   33,   32,  570,  212,
 /*   280 */    40,   38,   36,   35,   34,   39,   37, 1496,   69,  378,
 /*   290 */   154, 1827, 1828,  327, 1832, 1234,  159,   71,  305, 1240,
 /*   300 */  1208,  115,  205, 1736, 1133, 1134, 1566,  611, 1232, 1538,
 /*   310 */  1561,  599,  417,  610, 1732,  412,  411,  410,  409,  408,
 /*   320 */   405,  404,  403,  402,  401,  397,  396,  395,  394,  388,
 /*   330 */   387,  386,  385,   14,  382,  381,   39,   37, 1234, 1240,
 /*   340 */  1748, 1728, 1734, 1363,  327,   69, 1234, 1388, 1618,  477,
 /*   350 */   476, 1232,  573, 1551,  475,  332,    2,  116,  472, 1232,
 /*   360 */   518,  471,  470,  469, 1616,   33,   32, 1562, 1766,   40,
 /*   370 */    38,   36,   35,   34,   11,   10,  553, 1886,  652,  159,
 /*   380 */   138, 1718, 1240,  552,  515, 1386, 1387, 1389, 1390, 1569,
 /*   390 */  1240, 1884, 1305, 1306,  556, 1883, 1289,  570,  533, 1452,
 /*   400 */    22, 1544,  330,  535,  159, 1663, 1451,    8,  379, 1779,
 /*   410 */  1612, 1613,   87, 1749,  555, 1751, 1752,  551, 1450,  573,
 /*   420 */   570,  652, 1819,  570, 1424, 1566,  299, 1815,  337,  652,
 /*   430 */  1260,  383,  524,  519,  398,  245,  138, 1235, 1886, 1233,
 /*   440 */  1718,  477,  476, 1305, 1306, 1568,  475, 1718, 1566,  116,
 /*   450 */   472, 1566,  156,  471,  470,  469, 1883, 1339, 1053, 1718,
 /*   460 */   442, 1238, 1239,  365, 1287, 1288, 1290, 1291, 1292, 1293,
 /*   470 */  1294,  548,  571, 1302, 1303, 1304, 1307,   39,   37, 1308,
 /*   480 */  1235,  570, 1233,  367,  363,  327, 1618, 1234, 1235, 1055,
 /*   490 */  1233,  340,  399,  338, 1449, 1313,  556, 1216, 1217,  138,
 /*   500 */  1232, 1258, 1616, 1553, 1238, 1239, 1423, 1664, 1568, 1566,
 /*   510 */  1327, 1549, 1238, 1239, 1748, 1287, 1288, 1290, 1291, 1292,
 /*   520 */  1293, 1294,  548,  571, 1302, 1303, 1304, 1307,   39,   37,
 /*   530 */  1000, 1240,  999, 1332,  424, 1718,  327,  428, 1234,  206,
 /*   540 */   159,  547, 1766,  529,   39,   37,  246,  247,    9, 1431,
 /*   550 */   532, 1232,  327, 1448, 1234, 1718, 1362,  552,   33,   32,
 /*   560 */  1001,  232,   40,   38,   36,   35,   34, 1232,   27, 1748,
 /*   570 */   652,  119, 1447,  110,  109,  108,  107,  106,  105,  104,
 /*   580 */   103,  102, 1240, 1779, 1305, 1306,   88, 1749,  555, 1751,
 /*   590 */  1752,  551,  570,  573, 1718,   84, 1819, 1766, 1240,    9,
 /*   600 */   320, 1815,  152,  441,  491,  553,  598,  305,  120, 1446,
 /*   610 */  1718,  117,  552, 1718,  233,    2, 1558,  489, 1261,  487,
 /*   620 */  1566,  652,  508, 1847,  474,  473,  155, 1827, 1828, 1235,
 /*   630 */  1832, 1233,  623,  621, 1378, 1305, 1306,  652, 1779,  507,
 /*   640 */  1542,  142, 1749,  555, 1751, 1752,  551, 1543,  573,  500,
 /*   650 */  1718, 1305, 1306, 1238, 1239,  413, 1287, 1288, 1290, 1291,
 /*   660 */  1292, 1293, 1294,  548,  571, 1302, 1303, 1304, 1307, 1444,
 /*   670 */    33,   32,  570, 1289,   40,   38,   36,   35,   34, 1886,
 /*   680 */  1235,  236, 1233, 1563,   33,   32,  534, 1900,   40,   38,
 /*   690 */    36,   35,   34,  156, 1839, 1359, 1235, 1883, 1233,  607,
 /*   700 */  1566,  170,  169,  432, 1238, 1239,  428, 1287, 1288, 1290,
 /*   710 */  1291, 1292, 1293, 1294,  548,  571, 1302, 1303, 1304, 1307,
 /*   720 */  1238, 1239,    7, 1287, 1288, 1290, 1291, 1292, 1293, 1294,
 /*   730 */   548,  571, 1302, 1303, 1304, 1307,  139,  151,  493,   33,
 /*   740 */    32,  274,  605,   40,   38,   36,   35,   34, 1834,  213,
 /*   750 */  1605,  603, 1445, 1442, 1609,  272,   57, 1493, 1432,   56,
 /*   760 */  1272,  129,  128,  602,  601,  600, 1524, 1441, 1440, 1748,
 /*   770 */  1439, 1834, 1831, 1438, 1834,  172,  421, 1437, 1886,  101,
 /*   780 */  1258,   78,  100,   99,   98,   97,   96,   95,   94,   93,
 /*   790 */    92,  300,  156, 1718, 1718, 1830, 1883, 1766, 1829, 1243,
 /*   800 */  1662,   60, 1559,  306, 1661,  532, 1436,  306, 1718, 1718,
 /*   810 */  1718, 1718,  552,  137, 1718, 1272, 1706, 1435, 1718,  629,
 /*   820 */   628,  627,  342, 1325,  626,  625,  624,  121,  619,  618,
 /*   830 */   617,  616,  615,  614,  613,  612,  131,  608, 1779,   86,
 /*   840 */  1434,   88, 1749,  555, 1751, 1752,  551, 1718,  573,  604,
 /*   850 */   545, 1819, 1609, 1618,   26,  320, 1815,  152, 1718,  268,
 /*   860 */    33,   32, 1596,  353,   40,   38,   36,   35,   34, 1617,
 /*   870 */  1429,  987,  988,  467,   64,   63,  377, 1326, 1848,  165,
 /*   880 */    28, 1718, 1748,   52,  504,  371,   33,   32,  622, 1483,
 /*   890 */    40,   38,   36,   35,   34,  466,  295,  516, 1359,  361,
 /*   900 */  1331,  359,  355,  351,  162,  346, 1478,  537,   33,   32,
 /*   910 */  1766,  478,   40,   38,   36,   35,   34,  194,  553, 1242,
 /*   920 */   192,  570,  570, 1718,  196,  552, 1476,  195,  480,  368,
 /*   930 */  1246,  344, 1695,  501,  159,   29,  325, 1320, 1321, 1322,
 /*   940 */  1323, 1324, 1328, 1329, 1330, 1541,   50, 1748,  483, 1566,
 /*   950 */  1566, 1779, 1289,  460,   88, 1749,  555, 1751, 1752,  551,
 /*   960 */   300,  573,  198,  570, 1819,  197,   11,   10,  320, 1815,
 /*   970 */  1899, 1886,  494,  200,  111, 1766,  199,  217, 1317, 1854,
 /*   980 */   224,  468,  540,  553,  209,  156,   41, 1385, 1718, 1883,
 /*   990 */   552, 1566, 1325, 1091,  596,  595,  594, 1095,  593, 1097,
 /*  1000 */  1098,  592, 1100,  589,  570, 1106,  586, 1108, 1109,  583,
 /*  1010 */   580, 1426, 1427,   72,  570,  505, 1779,  570,  219,   88,
 /*  1020 */  1749,  555, 1751, 1752,  551,  567,  573, 1333,  568, 1819,
 /*  1030 */  1767,   41, 1566,  320, 1815, 1899,   41,  243,  123,   83,
 /*  1040 */   605,  126, 1566,  570, 1877, 1566, 1326,  570, 1748,   80,
 /*  1050 */  1245,  482,  127, 1472,  257,   50,  578, 1025,  341,  129,
 /*  1060 */   128,  602,  601,  600,  343, 1467,  492, 1606, 1850, 1331,
 /*  1070 */   530, 1566, 1295,  126,  235, 1566, 1766, 1184,  248,  562,
 /*  1080 */   202,    5,  254,  238,  553,  240,    3,  529, 1026, 1718,
 /*  1090 */  1748,  552,  345, 1084,  485, 1256,  267, 1112,  479,  538,
 /*  1100 */   127,  647,  112,  201,   29,  325, 1320, 1321, 1322, 1323,
 /*  1110 */  1324, 1328, 1329, 1330, 1116,  119,  126, 1779, 1766,  348,
 /*  1120 */    88, 1749,  555, 1751, 1752,  551,  553,  573,  352,   55,
 /*  1130 */  1819, 1718,   54,  552,  320, 1815, 1899,  533,  307, 1053,
 /*  1140 */   308, 1123, 1200, 1121,  264, 1838,  400,  167,  533, 1658,
 /*  1150 */   415, 1748,  407,  414,  416,  117,  420,  130, 1262, 1779,
 /*  1160 */   422,  423,  281, 1749,  555, 1751, 1752,  551,  529,  573,
 /*  1170 */   230, 1827,  528,  431,  527, 1265,  541, 1886,  175, 1766,
 /*  1180 */   434,  177, 1264,  435,  436, 1266,  180,  553, 1886,  437,
 /*  1190 */   439,  158, 1718,  182,  552, 1883,  119, 1263,  440,  184,
 /*  1200 */    68,  462,  158,  187,  443, 1748, 1883,  464, 1556,  533,
 /*  1210 */   191, 1552,  298,  193,  132,  495,   91,  496,  533,  265,
 /*  1220 */  1779,  204,  133,  281, 1749,  555, 1751, 1752,  551, 1554,
 /*  1230 */   573, 1550,  134, 1766,  207,  135,  117,  502, 1700,  506,
 /*  1240 */  1261,  553,  211,  499, 1851,  517, 1718, 1748,  552, 1886,
 /*  1250 */   512,  230, 1827,  528,  559,  527,    6,  514, 1886,  317,
 /*  1260 */   319, 1861, 1860,  156,  215,  218,  520, 1883, 1841,  526,
 /*  1270 */  1748,  223,  156,  513, 1779, 1766, 1883,   89, 1749,  555,
 /*  1280 */  1751, 1752,  551,  553,  573,  511,  510, 1819, 1718,  228,
 /*  1290 */   552, 1818, 1815, 1359,  146,  225,  118, 1260, 1766,   44,
 /*  1300 */   226,  542,  539, 1835,   18,  321,  553,  229,  124,  557,
 /*  1310 */   558, 1718,  563,  552, 1699,  227, 1779,  125, 1668,   89,
 /*  1320 */  1749,  555, 1751, 1752,  551, 1800,  573, 1748,  560, 1819,
 /*  1330 */   329,  250, 1882,  544, 1815,  234,  564,  565,  536, 1779,
 /*  1340 */  1902,  237,   89, 1749,  555, 1751, 1752,  551,  239,  573,
 /*  1350 */   543,  252, 1819,  266,   77, 1766, 1567, 1816,   79,  269,
 /*  1360 */  1610, 1539,  576,  553,  648,  649,  260,  651, 1718, 1748,
 /*  1370 */   552,   51,  290,  273,  292,  291, 1712,  145,  271, 1711,
 /*  1380 */    62, 1748,  509, 1710,  347, 1707,  349,  350, 1227, 1228,
 /*  1390 */   163,  354, 1705,  356,  357,  358, 1779, 1766, 1704,  289,
 /*  1400 */  1749,  555, 1751, 1752,  551,  553,  573,  360, 1703, 1766,
 /*  1410 */  1718,  364,  552,  362, 1702, 1701,  366,  553, 1685,  164,
 /*  1420 */   369,  370, 1718, 1679,  552, 1203, 1202, 1678,  375,  376,
 /*  1430 */  1677, 1676, 1172, 1651, 1650, 1649,   65, 1648, 1779, 1647,
 /*  1440 */  1646,  284, 1749,  555, 1751, 1752,  551, 1645,  573, 1644,
 /*  1450 */  1779,  389,  390,  142, 1749,  555, 1751, 1752,  551, 1643,
 /*  1460 */   573,  392, 1642, 1641, 1640, 1639, 1638, 1637, 1636, 1635,
 /*  1470 */  1634, 1633, 1632, 1631, 1748, 1174, 1622, 1621,  122, 1628,
 /*  1480 */   525, 1630, 1629, 1627, 1626, 1625, 1624, 1623, 1620, 1619,
 /*  1490 */  1497, 1495, 1748, 1463,  171,  113,  173,  427,  150, 1901,
 /*  1500 */  1462, 1693, 1766,  429, 1687, 1675,  990,  181,  989, 1674,
 /*  1510 */   553, 1660, 1545, 1019,  174, 1718, 1494,  552, 1492,  114,
 /*  1520 */  1766, 1490, 1488, 1486, 1475,  445, 1474, 1459,  550,  324,
 /*  1530 */   444,  448, 1547, 1718, 1748,  552,  179,  446,  450, 1546,
 /*  1540 */    49,  452,  454, 1779,   53,  456,  289, 1749,  555, 1751,
 /*  1550 */  1752,  551, 1126,  573,  449,  453,  458, 1748,  620, 1484,
 /*  1560 */   457, 1779, 1766, 1127,  288, 1749,  555, 1751, 1752,  551,
 /*  1570 */   553,  573, 1052, 1792,  622, 1718, 1051,  552, 1050, 1049,
 /*  1580 */   313, 1046, 1045, 1044, 1479, 1766,  314,  481, 1477,  326,
 /*  1590 */   484,  315,  190,  553, 1458,  486, 1457,  488, 1718, 1456,
 /*  1600 */   552,  189,  490, 1779, 1692,   90,  289, 1749,  555, 1751,
 /*  1610 */  1752,  551,  328,  573, 1210,  144, 1686,  497, 1673, 1748,
 /*  1620 */   459,  455,  451,  447,  188, 1671, 1779, 1672,  136,  289,
 /*  1630 */  1749,  555, 1751, 1752,  551, 1670,  573, 1669, 1400,   15,
 /*  1640 */     4,   41,   16,   47,   23,  221,  214, 1766,   25,  216,
 /*  1650 */    70, 1384,  222,  186, 1377,  553,  143,  220,   24,   74,
 /*  1660 */  1718, 1748,  552, 1738,   45,  498, 1356,  208,  231,   46,
 /*  1670 */  1355,  316,   17, 1417,  147, 1406, 1412, 1411,  503,  322,
 /*  1680 */    13, 1416, 1415,  323,   10, 1297,   19, 1296, 1779, 1766,
 /*  1690 */    31,  275, 1749,  555, 1751, 1752,  551,  553,  573,  148,
 /*  1700 */   160, 1280, 1718,   12,  552,  242,   20,   21, 1667, 1659,
 /*  1710 */   251, 1748,   80,  253, 1382,  185,  178,  244,  183,  249,
 /*  1720 */  1737, 1318,  438,   75,  554, 1748,  561,  256,   76, 1250,
 /*  1730 */  1779,  577, 1782,  276, 1749,  555, 1751, 1752,  551, 1766,
 /*  1740 */   573,  176, 1299,  572,   48,  575, 1113,  553,  336,  579,
 /*  1750 */   581, 1110, 1718, 1766,  552,  582,  584, 1107,  585,  587,
 /*  1760 */  1101,  553, 1099,  588,  590, 1090, 1718,  591,  552,   81,
 /*  1770 */  1105, 1104, 1103,   82, 1122, 1102,  258,   59,  597, 1748,
 /*  1780 */  1779, 1118,  606,  277, 1749,  555, 1751, 1752,  551, 1017,
 /*  1790 */   573, 1041, 1059,  259, 1779,  609, 1039,  283, 1749,  555,
 /*  1800 */  1751, 1752,  551, 1038,  573, 1037, 1036, 1766, 1035, 1034,
 /*  1810 */  1033, 1032, 1056, 1054, 1029,  553, 1028, 1027, 1024, 1023,
 /*  1820 */  1718, 1748,  552, 1022, 1491,  630, 1489,  631,  632,  634,
 /*  1830 */   636, 1487,  635,  638,  640, 1485,  642, 1473,  644,  639,
 /*  1840 */  1748,  646,  980,  643, 1455,  262,  650,  654, 1779, 1766,
 /*  1850 */  1236,  285, 1749,  555, 1751, 1752,  551,  553,  573, 1430,
 /*  1860 */   270,  653, 1718, 1748,  552, 1430, 1430, 1430, 1766, 1430,
 /*  1870 */  1430, 1430, 1430, 1430, 1430, 1430,  553, 1430, 1430, 1430,
 /*  1880 */  1430, 1718, 1748,  552, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  1890 */  1779, 1766, 1430,  278, 1749,  555, 1751, 1752,  551,  553,
 /*  1900 */   573, 1430, 1430, 1430, 1718, 1430,  552, 1430, 1430, 1779,
 /*  1910 */  1766, 1430,  286, 1749,  555, 1751, 1752,  551,  553,  573,
 /*  1920 */  1430, 1430, 1430, 1718, 1430,  552, 1430, 1430, 1430, 1430,
 /*  1930 */  1430, 1430, 1779, 1430, 1430,  279, 1749,  555, 1751, 1752,
 /*  1940 */   551, 1430,  573, 1748, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  1950 */  1430, 1779, 1430, 1430,  287, 1749,  555, 1751, 1752,  551,
 /*  1960 */  1430,  573, 1748, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  1970 */  1430, 1766, 1430, 1430, 1430, 1430, 1430, 1430, 1430,  553,
 /*  1980 */  1430, 1430, 1430, 1430, 1718, 1748,  552, 1430, 1430, 1430,
 /*  1990 */  1766, 1430, 1430, 1430, 1430, 1430, 1430, 1430,  553, 1430,
 /*  2000 */  1430, 1430, 1430, 1718, 1748,  552, 1430, 1430, 1430, 1430,
 /*  2010 */  1430, 1430, 1779, 1766, 1430,  280, 1749,  555, 1751, 1752,
 /*  2020 */   551,  553,  573, 1430, 1430, 1430, 1718, 1430,  552, 1430,
 /*  2030 */  1430, 1779, 1766, 1430,  293, 1749,  555, 1751, 1752,  551,
 /*  2040 */   553,  573, 1430, 1430, 1430, 1718, 1430,  552, 1430, 1430,
 /*  2050 */  1430, 1430, 1430, 1430, 1779, 1430, 1430,  294, 1749,  555,
 /*  2060 */  1751, 1752,  551, 1430,  573, 1430, 1748, 1430, 1430, 1430,
 /*  2070 */  1430, 1430, 1430, 1779, 1430, 1430, 1760, 1749,  555, 1751,
 /*  2080 */  1752,  551, 1430,  573, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2090 */  1430, 1748, 1430, 1430, 1766, 1430, 1430, 1430, 1430, 1430,
 /*  2100 */  1430, 1430,  553, 1430, 1430, 1430, 1430, 1718, 1748,  552,
 /*  2110 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1766,
 /*  2120 */  1430, 1430, 1430, 1430, 1430, 1430, 1430,  553, 1430, 1430,
 /*  2130 */  1430, 1430, 1718, 1748,  552, 1779, 1766, 1430, 1759, 1749,
 /*  2140 */   555, 1751, 1752,  551,  553,  573, 1430, 1430, 1430, 1718,
 /*  2150 */  1748,  552, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2160 */  1779, 1766, 1430, 1758, 1749,  555, 1751, 1752,  551,  553,
 /*  2170 */   573, 1430, 1430, 1430, 1718, 1430,  552, 1779, 1766, 1430,
 /*  2180 */   303, 1749,  555, 1751, 1752,  551,  553,  573, 1430, 1430,
 /*  2190 */  1430, 1718, 1430,  552, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2200 */  1430, 1430, 1779, 1430, 1430,  302, 1749,  555, 1751, 1752,
 /*  2210 */   551, 1430,  573, 1748, 1430, 1430, 1430, 1430, 1430, 1779,
 /*  2220 */  1430, 1430,  304, 1749,  555, 1751, 1752,  551, 1430,  573,
 /*  2230 */  1748, 1430, 1430, 1430, 1430, 1430, 1430,  334,  333, 1430,
 /*  2240 */  1430, 1766, 1430, 1430, 1430, 1430, 1430, 1248, 1430,  553,
 /*  2250 */  1430, 1430, 1430, 1430, 1718, 1430,  552, 1430, 1766, 1430,
 /*  2260 */  1241, 1430, 1430, 1430, 1430, 1430,  553, 1430, 1430, 1430,
 /*  2270 */  1430, 1718, 1430,  552, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2280 */  1430, 1430, 1779, 1430, 1430,  301, 1749,  555, 1751, 1752,
 /*  2290 */   551, 1240,  573, 1430, 1430, 1430, 1430, 1430, 1430, 1779,
 /*  2300 */  1430, 1430,  282, 1749,  555, 1751, 1752,  551, 1430,  573,
 /*  2310 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2320 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2330 */   574, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2340 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2350 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2360 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2370 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2380 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1249,
 /*  2390 */  1430, 1244, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2400 */  1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2410 */  1430, 1430, 1430, 1252, 1430, 1430, 1430, 1430, 1430, 1430,
 /*  2420 */  1430, 1430, 1430, 1430,  571, 1302, 1303,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   254,  348,  256,  257,  254,  258,  256,  257,  249,  270,
 /*    10 */   251,  258,   12,   13,  279,  362,  269,  278,  280,  366,
 /*    20 */    20,  283,   22,  276,   20,  280,  287,  258,  283,  291,
 /*    30 */    14,   15,   16,  286,   21,   35,  291,   24,   25,   26,
 /*    40 */    27,   28,   29,   30,   31,   32,    8,    9,  295,  250,
 /*    50 */    12,   13,   14,   15,   16,  286,  318,  319,    0,  308,
 /*    60 */    60,  333,  334,  318,  319,  250,   66,  329,   12,   13,
 /*    70 */    14,   15,   16,   20,  329,   22,   14,  278,   59,   12,
 /*    80 */    13,   14,   20,   83,   20,  286,   83,   20,   35,   22,
 /*    90 */   291,   20,  293,  278,  263,  326,   20,   83,  267,  348,
 /*   100 */    20,  286,   35,   50,  258,  105,  291,  308,  293,  340,
 /*   110 */   341,  342,  343,  362,  345,  269,   20,  366,  319,  119,
 /*   120 */   120,  322,  323,  324,  325,  326,  327,   60,  329,    4,
 /*   130 */   250,  332,  286,   66,  319,  336,  337,  322,  323,  324,
 /*   140 */   325,  326,  327,  328,  329,  330,  331,  348,   19,   56,
 /*   150 */    83,    8,    9,   46,   83,   12,   13,   14,   15,   16,
 /*   160 */   278,  362,   33,   83,  164,  366,  166,    4,  286,   44,
 /*   170 */    45,  291,  105,    3,   37,   82,   47,  163,   85,  165,
 /*   180 */   250,   52,   53,   54,   55,   56,  119,  120,  188,  189,
 /*   190 */    83,  191,  192,  193,  194,  195,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  280,   20,  324,  258,   18,  289,
 /*   210 */    20,   82,  292,  293,   85,  291,  216,   27,   14,  216,
 /*   220 */    30,  291,  348,   86,   20,   88,   89,   84,   91,   95,
 /*   230 */   216,  164,   95,  166,  286,  286,  362,   47,  115,   49,
 /*   240 */   366,   51,  318,  319,   56,  297,   83,  118,  114,  115,
 /*   250 */   116,  117,  118,  329,  117,  188,  189,   59,  191,  192,
 /*   260 */   193,  194,  195,  196,  197,  198,  199,  200,  201,  202,
 /*   270 */   203,   83,   82,   85,   20,  326,    8,    9,  258,  150,
 /*   280 */    12,   13,   14,   15,   16,   12,   13,    0,  262,  269,
 /*   290 */   341,  342,  343,   20,  345,   22,  216,  174,  175,   66,
 /*   300 */   171,  275,  173,  280,  119,  120,  286,  266,   35,  268,
 /*   310 */   284,   94,  122,   66,  291,  125,  126,  127,  128,  129,
 /*   320 */   130,  131,  132,  133,  134,  135,  136,  137,  138,  139,
 /*   330 */   140,  141,  142,   60,  144,  145,   12,   13,   22,   66,
 /*   340 */   250,  318,  319,    4,   20,  262,   22,  188,  278,   62,
 /*   350 */    63,   35,  329,  279,   67,  285,   83,   70,   71,   35,
 /*   360 */   149,   74,   75,   76,  294,    8,    9,  284,  278,   12,
 /*   370 */    13,   14,   15,   16,    1,    2,  286,  348,  105,  216,
 /*   380 */   278,  291,   66,  293,  225,  226,  227,  228,  229,  287,
 /*   390 */    66,  362,  119,  120,  293,  366,  192,  258,  308,  250,
 /*   400 */    43,    0,  301,  233,  216,  304,  250,   83,  269,  319,
 /*   410 */   292,  293,  322,  323,  324,  325,  326,  327,  250,  329,
 /*   420 */   258,  105,  332,  258,  156,  286,  336,  337,  270,  105,
 /*   430 */    20,  269,  221,  222,  269,  114,  278,  164,  348,  166,
 /*   440 */   291,   62,   63,  119,  120,  287,   67,  291,  286,   70,
 /*   450 */    71,  286,  362,   74,   75,   76,  366,   84,   35,  291,
 /*   460 */    59,  188,  189,  159,  191,  192,  193,  194,  195,  196,
 /*   470 */   197,  198,  199,  200,  201,  202,  203,   12,   13,   14,
 /*   480 */   164,  258,  166,  179,  180,   20,  278,   22,  164,   66,
 /*   490 */   166,  270,  269,  285,  250,   14,  293,  176,  177,  278,
 /*   500 */    35,   20,  294,  279,  188,  189,  238,  304,  287,  286,
 /*   510 */   146,  279,  188,  189,  250,  191,  192,  193,  194,  195,
 /*   520 */   196,  197,  198,  199,  200,  201,  202,  203,   12,   13,
 /*   530 */    20,   66,   22,  169,  255,  291,   20,  258,   22,  279,
 /*   540 */   216,  279,  278,  258,   12,   13,  114,  115,   83,    0,
 /*   550 */   286,   35,   20,  250,   22,  291,  217,  293,    8,    9,
 /*   560 */    50,  151,   12,   13,   14,   15,   16,   35,  204,  250,
 /*   570 */   105,  286,  250,   24,   25,   26,   27,   28,   29,   30,
 /*   580 */    31,   32,   66,  319,  119,  120,  322,  323,  324,  325,
 /*   590 */   326,  327,  258,  329,  291,  260,  332,  278,   66,   83,
 /*   600 */   336,  337,  338,  269,   21,  286,  279,  175,  273,  250,
 /*   610 */   291,  326,  293,  291,  350,   83,  281,   34,   20,   36,
 /*   620 */   286,  105,  358,  359,  264,  265,  341,  342,  343,  164,
 /*   630 */   345,  166,  264,  265,   84,  119,  120,  105,  319,  308,
 /*   640 */     0,  322,  323,  324,  325,  326,  327,    0,  329,  312,
 /*   650 */   291,  119,  120,  188,  189,   77,  191,  192,  193,  194,
 /*   660 */   195,  196,  197,  198,  199,  200,  201,  202,  203,  251,
 /*   670 */     8,    9,  258,  192,   12,   13,   14,   15,   16,  348,
 /*   680 */   164,  369,  166,  269,    8,    9,  367,  368,   12,   13,
 /*   690 */    14,   15,   16,  362,  214,  215,  164,  366,  166,   59,
 /*   700 */   286,  123,  124,  255,  188,  189,  258,  191,  192,  193,
 /*   710 */   194,  195,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   720 */   188,  189,   39,  191,  192,  193,  194,  195,  196,  197,
 /*   730 */   198,  199,  200,  201,  202,  203,   18,  277,  308,    8,
 /*   740 */     9,   23,   95,   12,   13,   14,   15,   16,  320,  151,
 /*   750 */   290,  288,  250,  250,  291,   37,   38,    0,    0,   41,
 /*   760 */    84,  114,  115,  116,  117,  118,  267,  250,  250,  250,
 /*   770 */   250,  320,  344,  250,  320,   57,   58,  250,  348,   21,
 /*   780 */    20,  260,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   790 */    32,   60,  362,  291,  291,  344,  366,  278,  344,   35,
 /*   800 */   303,   83,  281,  306,  303,  286,  250,  306,  291,  291,
 /*   810 */   291,  291,  293,  151,  291,   84,    0,  250,  291,   62,
 /*   820 */    63,   64,   65,   92,   67,   68,   69,   70,   71,   72,
 /*   830 */    73,   74,   75,   76,   77,   78,   79,   80,  319,  121,
 /*   840 */   250,  322,  323,  324,  325,  326,  327,  291,  329,  288,
 /*   850 */    60,  332,  291,  278,    2,  336,  337,  338,  291,  271,
 /*   860 */     8,    9,  274,   47,   12,   13,   14,   15,   16,  294,
 /*   870 */   247,   44,   45,   95,  156,  157,  158,  146,  359,  161,
 /*   880 */     2,  291,  250,  151,  152,  167,    8,    9,   43,    0,
 /*   890 */    12,   13,   14,   15,   16,  117,  178,  360,  215,  181,
 /*   900 */   169,  183,  184,  185,  186,  187,    0,   43,    8,    9,
 /*   910 */   278,   22,   12,   13,   14,   15,   16,   87,  286,   35,
 /*   920 */    90,  258,  258,  291,   87,  293,    0,   90,   22,   84,
 /*   930 */   166,  308,  269,  269,  216,  204,  205,  206,  207,  208,
 /*   940 */   209,  210,  211,  212,  213,    0,   43,  250,   22,  286,
 /*   950 */   286,  319,  192,  259,  322,  323,  324,  325,  326,  327,
 /*   960 */    60,  329,   87,  258,  332,   90,    1,    2,  336,  337,
 /*   970 */   338,  348,  315,   87,  269,  278,   90,   43,  188,  347,
 /*   980 */   355,  276,   43,  286,   56,  362,   43,   84,  291,  366,
 /*   990 */   293,  286,   92,   96,   97,   98,   99,  100,  101,  102,
 /*  1000 */   103,  104,  105,  106,  258,  108,  109,  110,  111,  112,
 /*  1010 */   113,  119,  120,   85,  258,  269,  319,  258,   84,  322,
 /*  1020 */   323,  324,  325,  326,  327,  269,  329,   84,  269,  332,
 /*  1030 */   278,   43,  286,  336,  337,  338,   43,   43,   43,   83,
 /*  1040 */    95,   43,  286,  258,  347,  286,  146,  258,  250,   93,
 /*  1050 */   166,    4,   43,    0,  269,   43,   43,   35,  269,  114,
 /*  1060 */   115,  116,  117,  118,  259,  257,   19,  290,  321,  169,
 /*  1070 */   346,  286,   84,   43,  363,  286,  278,   84,   84,   84,
 /*  1080 */    33,  218,   84,  363,  286,  363,  349,  258,   66,  291,
 /*  1090 */   250,  293,  317,   84,   47,   20,   84,   84,   51,  235,
 /*  1100 */    43,   48,   43,   56,  204,  205,  206,  207,  208,  209,
 /*  1110 */   210,  211,  212,  213,   84,  286,   43,  319,  278,  258,
 /*  1120 */   322,  323,  324,  325,  326,  327,  286,  329,   47,   82,
 /*  1130 */   332,  291,   85,  293,  336,  337,  338,  308,  316,   35,
 /*  1140 */   264,   84,  162,   84,  310,  347,  258,   42,  308,  258,
 /*  1150 */   146,  250,  298,  296,  296,  326,  258,   84,   20,  319,
 /*  1160 */   258,  252,  322,  323,  324,  325,  326,  327,  258,  329,
 /*  1170 */   341,  342,  343,  252,  345,   20,  237,  348,  262,  278,
 /*  1180 */   314,  262,   20,  293,  307,   20,  262,  286,  348,  309,
 /*  1190 */   307,  362,  291,  262,  293,  366,  286,   20,  299,  262,
 /*  1200 */   262,  252,  362,  262,  258,  250,  366,  278,  278,  308,
 /*  1210 */   278,  278,  252,  278,  278,  172,  258,  313,  308,  314,
 /*  1220 */   319,  260,  278,  322,  323,  324,  325,  326,  327,  278,
 /*  1230 */   329,  278,  278,  278,  260,  278,  326,  258,  291,  258,
 /*  1240 */    20,  286,  260,  293,  321,  224,  291,  250,  293,  348,
 /*  1250 */   291,  341,  342,  343,  223,  345,  230,  291,  348,  307,
 /*  1260 */   291,  354,  354,  362,  302,  302,  291,  366,  357,  155,
 /*  1270 */   250,  356,  362,  232,  319,  278,  366,  322,  323,  324,
 /*  1280 */   325,  326,  327,  286,  329,  231,  219,  332,  291,  317,
 /*  1290 */   293,  336,  337,  215,  354,  353,  286,   20,  278,   42,
 /*  1300 */   352,  236,  234,  320,   83,  239,  286,  339,  302,  291,
 /*  1310 */   291,  291,  148,  293,  291,  351,  319,  302,  291,  322,
 /*  1320 */   323,  324,  325,  326,  327,  335,  329,  250,  291,  332,
 /*  1330 */   291,  286,  365,  336,  337,  364,  300,  299,  365,  319,
 /*  1340 */   370,  364,  322,  323,  324,  325,  326,  327,  364,  329,
 /*  1350 */   365,  260,  332,  274,  260,  278,  286,  337,   83,  258,
 /*  1360 */   291,  268,  282,  286,   36,  253,  260,  252,  291,  250,
 /*  1370 */   293,  311,  272,  248,  272,  272,    0,  306,  261,    0,
 /*  1380 */    42,  250,  305,    0,   74,    0,   35,  182,   35,   35,
 /*  1390 */    35,  182,    0,   35,   35,  182,  319,  278,    0,  322,
 /*  1400 */   323,  324,  325,  326,  327,  286,  329,  182,    0,  278,
 /*  1410 */   291,   22,  293,   35,    0,    0,   35,  286,    0,   83,
 /*  1420 */   169,  168,  291,    0,  293,  166,  164,    0,  160,  159,
 /*  1430 */     0,    0,   46,    0,    0,    0,  143,    0,  319,    0,
 /*  1440 */     0,  322,  323,  324,  325,  326,  327,    0,  329,    0,
 /*  1450 */   319,  138,   35,  322,  323,  324,  325,  326,  327,    0,
 /*  1460 */   329,  138,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1470 */     0,    0,    0,    0,  250,   22,    0,    0,   42,    0,
 /*  1480 */   361,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1490 */     0,    0,  250,    0,   56,   39,   42,   46,   43,  368,
 /*  1500 */     0,    0,  278,   46,    0,    0,   14,  155,   14,    0,
 /*  1510 */   286,    0,    0,   61,   40,  291,    0,  293,    0,   39,
 /*  1520 */   278,    0,    0,    0,    0,   47,    0,    0,  286,  305,
 /*  1530 */    35,   35,    0,  291,  250,  293,   39,   39,   39,    0,
 /*  1540 */    92,   35,   39,  319,  151,   35,  322,  323,  324,  325,
 /*  1550 */   326,  327,   22,  329,   47,   47,   39,  250,   43,    0,
 /*  1560 */    47,  319,  278,   35,  322,  323,  324,  325,  326,  327,
 /*  1570 */   286,  329,   35,  331,   43,  291,   35,  293,   35,   35,
 /*  1580 */    22,   35,   35,   35,    0,  278,   22,   49,    0,  305,
 /*  1590 */    35,   22,   90,  286,    0,   35,    0,   35,  291,    0,
 /*  1600 */   293,   33,   22,  319,    0,   20,  322,  323,  324,  325,
 /*  1610 */   326,  327,  305,  329,   35,   47,    0,   22,    0,  250,
 /*  1620 */    52,   53,   54,   55,   56,    0,  319,    0,  170,  322,
 /*  1630 */   323,  324,  325,  326,  327,    0,  329,    0,   84,  220,
 /*  1640 */    43,   43,  220,   43,   83,   43,   83,  278,   43,   84,
 /*  1650 */    82,   84,   46,   85,   84,  286,   83,   83,   83,   83,
 /*  1660 */   291,  250,  293,   46,  214,  151,   84,  148,   46,   43,
 /*  1670 */    84,  151,   43,   84,   46,   84,   35,   35,  153,   35,
 /*  1680 */   220,   35,   35,   35,    2,   84,   43,   84,  319,  278,
 /*  1690 */    83,  322,  323,  324,  325,  326,  327,  286,  329,   46,
 /*  1700 */    46,   22,  291,   83,  293,   84,   83,   83,    0,    0,
 /*  1710 */    39,  250,   93,  147,   84,  147,  148,   83,  150,   83,
 /*  1720 */    46,  188,  154,   83,  190,  250,  149,   46,   83,   22,
 /*  1730 */   319,   35,   83,  322,  323,  324,  325,  326,  327,  278,
 /*  1740 */   329,  173,   84,   83,   83,   94,   84,  286,   35,   83,
 /*  1750 */    35,   84,  291,  278,  293,   83,   35,   84,   83,   35,
 /*  1760 */    84,  286,   84,   83,   35,   22,  291,   83,  293,   83,
 /*  1770 */   107,  107,  107,   83,   35,  107,   43,   83,   95,  250,
 /*  1780 */   319,   22,   60,  322,  323,  324,  325,  326,  327,   61,
 /*  1790 */   329,   35,   66,   43,  319,   81,   35,  322,  323,  324,
 /*  1800 */   325,  326,  327,   35,  329,   35,   35,  278,   35,   22,
 /*  1810 */    35,   35,   66,   35,   35,  286,   35,   35,   35,   35,
 /*  1820 */   291,  250,  293,   35,    0,   35,    0,   47,   39,   35,
 /*  1830 */    39,    0,   47,   35,   39,    0,   35,    0,   39,   47,
 /*  1840 */   250,   35,   35,   47,    0,   22,   21,   20,  319,  278,
 /*  1850 */    22,  322,  323,  324,  325,  326,  327,  286,  329,  371,
 /*  1860 */    22,   21,  291,  250,  293,  371,  371,  371,  278,  371,
 /*  1870 */   371,  371,  371,  371,  371,  371,  286,  371,  371,  371,
 /*  1880 */   371,  291,  250,  293,  371,  371,  371,  371,  371,  371,
 /*  1890 */   319,  278,  371,  322,  323,  324,  325,  326,  327,  286,
 /*  1900 */   329,  371,  371,  371,  291,  371,  293,  371,  371,  319,
 /*  1910 */   278,  371,  322,  323,  324,  325,  326,  327,  286,  329,
 /*  1920 */   371,  371,  371,  291,  371,  293,  371,  371,  371,  371,
 /*  1930 */   371,  371,  319,  371,  371,  322,  323,  324,  325,  326,
 /*  1940 */   327,  371,  329,  250,  371,  371,  371,  371,  371,  371,
 /*  1950 */   371,  319,  371,  371,  322,  323,  324,  325,  326,  327,
 /*  1960 */   371,  329,  250,  371,  371,  371,  371,  371,  371,  371,
 /*  1970 */   371,  278,  371,  371,  371,  371,  371,  371,  371,  286,
 /*  1980 */   371,  371,  371,  371,  291,  250,  293,  371,  371,  371,
 /*  1990 */   278,  371,  371,  371,  371,  371,  371,  371,  286,  371,
 /*  2000 */   371,  371,  371,  291,  250,  293,  371,  371,  371,  371,
 /*  2010 */   371,  371,  319,  278,  371,  322,  323,  324,  325,  326,
 /*  2020 */   327,  286,  329,  371,  371,  371,  291,  371,  293,  371,
 /*  2030 */   371,  319,  278,  371,  322,  323,  324,  325,  326,  327,
 /*  2040 */   286,  329,  371,  371,  371,  291,  371,  293,  371,  371,
 /*  2050 */   371,  371,  371,  371,  319,  371,  371,  322,  323,  324,
 /*  2060 */   325,  326,  327,  371,  329,  371,  250,  371,  371,  371,
 /*  2070 */   371,  371,  371,  319,  371,  371,  322,  323,  324,  325,
 /*  2080 */   326,  327,  371,  329,  371,  371,  371,  371,  371,  371,
 /*  2090 */   371,  250,  371,  371,  278,  371,  371,  371,  371,  371,
 /*  2100 */   371,  371,  286,  371,  371,  371,  371,  291,  250,  293,
 /*  2110 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  278,
 /*  2120 */   371,  371,  371,  371,  371,  371,  371,  286,  371,  371,
 /*  2130 */   371,  371,  291,  250,  293,  319,  278,  371,  322,  323,
 /*  2140 */   324,  325,  326,  327,  286,  329,  371,  371,  371,  291,
 /*  2150 */   250,  293,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2160 */   319,  278,  371,  322,  323,  324,  325,  326,  327,  286,
 /*  2170 */   329,  371,  371,  371,  291,  371,  293,  319,  278,  371,
 /*  2180 */   322,  323,  324,  325,  326,  327,  286,  329,  371,  371,
 /*  2190 */   371,  291,  371,  293,  371,  371,  371,  371,  371,  371,
 /*  2200 */   371,  371,  319,  371,  371,  322,  323,  324,  325,  326,
 /*  2210 */   327,  371,  329,  250,  371,  371,  371,  371,  371,  319,
 /*  2220 */   371,  371,  322,  323,  324,  325,  326,  327,  371,  329,
 /*  2230 */   250,  371,  371,  371,  371,  371,  371,   12,   13,  371,
 /*  2240 */   371,  278,  371,  371,  371,  371,  371,   22,  371,  286,
 /*  2250 */   371,  371,  371,  371,  291,  371,  293,  371,  278,  371,
 /*  2260 */    35,  371,  371,  371,  371,  371,  286,  371,  371,  371,
 /*  2270 */   371,  291,  371,  293,  371,  371,  371,  371,  371,  371,
 /*  2280 */   371,  371,  319,  371,  371,  322,  323,  324,  325,  326,
 /*  2290 */   327,   66,  329,  371,  371,  371,  371,  371,  371,  319,
 /*  2300 */   371,  371,  322,  323,  324,  325,  326,  327,  371,  329,
 /*  2310 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2320 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2330 */   105,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2340 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2350 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2360 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2370 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2380 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  164,
 /*  2390 */   371,  166,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2400 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2410 */   371,  371,  371,  188,  371,  371,  371,  371,  371,  371,
 /*  2420 */   371,  371,  371,  371,  199,  200,  201,  371,  371,  371,
 /*  2430 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2440 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2450 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2460 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2470 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*  2480 */   371,  371,  371,  371,  371,
};
#define YY_SHIFT_COUNT    (655)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2225)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   718,    0,    0,   67,  273,  273,  273,  273,  324,  324,
 /*    10 */   273,  273,  465,  516,  532,  516,  516,  516,  516,  516,
 /*    20 */   516,  516,  516,  516,  516,  516,  516,  516,  516,  516,
 /*    30 */   516,  516,  516,  516,  516,  516,  516,  516,  516,  516,
 /*    40 */   516,  516,   80,   80,   71,   71,   71, 2225, 2225, 2225,
 /*    50 */  2225,   14,  188,    3,    4,    4,  125,  125,  163,  185,
 /*    60 */     3,    3,    4,    4,    4,    4,    4,    4,    4,    4,
 /*    70 */    19,    4,    4,    4,   64,   76,   96,    4,    4,   96,
 /*    80 */     4,   96,   96,   96,    4,  198,  190,  731,  900,  900,
 /*    90 */    13,  379,  316,  316,  316,  316,  316,  316,  316,  316,
 /*   100 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*   110 */   316,  137,  185,   62,   62,  401,  423,  410,  410,  410,
 /*   120 */   640,  423,  254,   76,   58,   58,   96,   96,  233,  233,
 /*   130 */   217,  247,  897,  897,  897,  897,  897,  897,  897,  129,
 /*   140 */   758,  287,  268,  159,   53,  123,  211,  204,  481,  510,
 /*   150 */   827,  778,  598,  480,  683,  480,  170,  170,  170,  339,
 /*   160 */   760,  863, 1075, 1081, 1104,  980, 1075, 1075, 1105, 1004,
 /*   170 */  1004, 1075, 1075, 1138, 1138, 1155,   19,   76,   19, 1162,
 /*   180 */  1165,   19, 1162,   19, 1177,   19,   19, 1075,   19, 1138,
 /*   190 */    96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
 /*   200 */    96, 1075, 1138,  233, 1155,  198, 1043,   76,  198, 1075,
 /*   210 */  1075, 1162,  198, 1220,  233, 1021, 1031,  233, 1021, 1031,
 /*   220 */   233,  233,   96, 1026, 1114, 1021, 1041, 1054, 1067,  863,
 /*   230 */  1078,  254, 1277, 1257, 1065, 1068, 1066, 1065, 1068, 1065,
 /*   240 */  1068, 1221, 1031,  233,  233,  233,  233,  233, 1031,  233,
 /*   250 */  1164,  254, 1177,  198,  217,  198,  254, 1275,  233,  247,
 /*   260 */  1075,  198, 1328, 1138, 2427, 2427, 2427, 2427, 2427, 2427,
 /*   270 */  2427,  757, 1568,  549, 1047,  143,  357,  550,  852,  878,
 /*   280 */   662,  676,   38,   38,   38,   38,   38,   38,   38,   38,
 /*   290 */   647,  945,  134,   56,   56,  304,   93,  578,  583,  373,
 /*   300 */   364,   16,   16,   16,   16,  321,  432,  816,  845,  830,
 /*   310 */   837,  875,  886,  889,  906,  926,  928,  732,  903,  934,
 /*   320 */   965,  892,  864,  939,  943,  790,  988,  107,  993,  994,
 /*   330 */   995,  998, 1009,  764,  884, 1012, 1013, 1030, 1057, 1059,
 /*   340 */  1073,  956, 1022, 1053, 1376, 1379, 1338, 1383, 1310, 1385,
 /*   350 */  1351, 1205, 1353, 1354, 1355, 1209, 1392, 1358, 1359, 1213,
 /*   360 */  1398, 1225, 1408, 1378, 1414, 1389, 1415, 1381, 1418, 1336,
 /*   370 */  1251, 1253, 1259, 1262, 1423, 1427, 1268, 1270, 1430, 1431,
 /*   380 */  1386, 1433, 1434, 1435, 1293, 1437, 1439, 1440, 1447, 1449,
 /*   390 */  1313, 1417, 1459, 1323, 1462, 1463, 1464, 1465, 1466, 1467,
 /*   400 */  1468, 1469, 1470, 1471, 1472, 1473, 1481, 1482, 1436, 1479,
 /*   410 */  1483, 1484, 1485, 1486, 1487, 1453, 1476, 1477, 1488, 1489,
 /*   420 */  1490, 1438, 1491, 1493, 1454, 1456, 1455, 1492, 1451, 1494,
 /*   430 */  1457, 1500, 1474, 1480, 1501, 1504, 1505, 1497, 1352, 1509,
 /*   440 */  1511, 1512, 1452, 1516, 1518, 1495, 1478, 1498, 1521, 1496,
 /*   450 */  1507, 1499, 1522, 1506, 1508, 1503, 1523, 1510, 1513, 1517,
 /*   460 */  1524, 1526, 1527, 1532, 1448, 1502, 1528, 1530, 1539, 1537,
 /*   470 */  1541, 1543, 1544, 1515, 1531, 1546, 1547, 1548, 1559, 1558,
 /*   480 */  1584, 1564, 1538, 1588, 1569, 1555, 1594, 1560, 1596, 1562,
 /*   490 */  1599, 1580, 1585, 1604, 1393, 1579, 1616, 1458, 1595, 1514,
 /*   500 */  1519, 1618, 1625, 1520, 1525, 1627, 1635, 1637, 1597, 1598,
 /*   510 */  1419, 1561, 1554, 1563, 1565, 1600, 1567, 1573, 1574, 1575,
 /*   520 */  1570, 1602, 1606, 1617, 1576, 1605, 1422, 1582, 1586, 1622,
 /*   530 */  1450, 1626, 1628, 1589, 1629, 1460, 1591, 1641, 1642, 1644,
 /*   540 */  1646, 1647, 1648, 1591, 1682, 1533, 1643, 1601, 1607, 1603,
 /*   550 */  1653, 1620, 1623, 1654, 1679, 1534, 1624, 1621, 1630, 1634,
 /*   560 */  1708, 1636, 1577, 1640, 1709, 1671, 1566, 1645, 1619, 1674,
 /*   570 */  1681, 1649, 1658, 1660, 1707, 1661, 1651, 1662, 1696, 1713,
 /*   580 */  1666, 1667, 1715, 1672, 1673, 1721, 1675, 1676, 1724, 1680,
 /*   590 */  1678, 1729, 1684, 1663, 1664, 1665, 1668, 1743, 1683, 1686,
 /*   600 */  1690, 1739, 1694, 1733, 1733, 1759, 1728, 1722, 1756, 1726,
 /*   610 */  1714, 1750, 1761, 1768, 1770, 1771, 1773, 1787, 1775, 1776,
 /*   620 */  1746, 1515, 1778, 1531, 1779, 1781, 1782, 1783, 1784, 1788,
 /*   630 */  1824, 1790, 1780, 1789, 1826, 1794, 1785, 1791, 1831, 1798,
 /*   640 */  1792, 1795, 1835, 1801, 1796, 1799, 1837, 1806, 1807, 1844,
 /*   650 */  1823, 1825, 1828, 1838, 1840, 1827,
};
#define YY_REDUCE_COUNT (270)
#define YY_REDUCE_MIN   (-347)
#define YY_REDUCE_MAX   (1980)
static const short yy_reduce_ofst[] = {
 /*     0 */   623, -201,   90,  264,  519,  632,  697,  798,  840,  901,
 /*    10 */   955,  997, -185,  319, 1020, 1077, 1119, 1131, 1224, 1242,
 /*    20 */  1284, 1307, 1369, 1411, 1461, 1475, 1529, 1571, 1590, 1613,
 /*    30 */  1632, 1693, 1712, 1735, 1754, 1816, 1841, 1858, 1883, 1900,
 /*    40 */  1963, 1980,  829,  910, -231,  -51,  285, -262, -255,  -76,
 /*    50 */    23, -249,  331,  430, -253,  705, -254, -250, -347,  -80,
 /*    60 */  -126,   29, -154,   20,  139,  162,  165,  223,  334,  414,
 /*    70 */    26,  663,  664,  746, -118,  101, -261,  756,  759,   70,
 /*    80 */   785,  158,  208,  221,  789,  335, -247, -272, -272, -272,
 /*    90 */  -241, -169, -120,  -70,  149,  156,  168,  244,  303,  322,
 /*   100 */   359,  502,  503,  517,  518,  520,  523,  527,  556,  567,
 /*   110 */   590,  460,  118,  279,  448,   83,  360,  428,  451,  454,
 /*   120 */   521,  368,  -52,  203,  497,  501,  102,  575,  463,  561,
 /*   130 */   588,   41, -265,   74,  224,  232,  260,  262,  327,  337,
 /*   140 */   418,  499,  312,  537,  694,  657,  625,  752,  752,  805,
 /*   150 */   808,  777,  747,  724,  724,  724,  711,  720,  722,  737,
 /*   160 */   752,  775,  861,  822,  876,  834,  888,  891,  854,  857,
 /*   170 */   858,  898,  902,  909,  921,  866,  916,  890,  919,  877,
 /*   180 */   880,  924,  883,  931,  899,  937,  938,  946,  941,  949,
 /*   190 */   929,  930,  932,  933,  935,  936,  944,  951,  953,  954,
 /*   200 */   957,  958,  960,  947,  905,  961,  904,  950,  974,  979,
 /*   210 */   981,  952,  982,  923,  959,  907,  962,  966,  908,  963,
 /*   220 */   969,  975,  752,  911,  915,  940,  942,  948,  964,  972,
 /*   230 */   724, 1010,  983,  968,  967,  971,  970,  973,  977,  985,
 /*   240 */   984,  990, 1006, 1018, 1019, 1023, 1027, 1037, 1015, 1039,
 /*   250 */  1036, 1045, 1038, 1091, 1079, 1094, 1070, 1080, 1069, 1093,
 /*   260 */  1101, 1106, 1112, 1115, 1060, 1071, 1100, 1102, 1103, 1117,
 /*   270 */  1125,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    10 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    20 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    30 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    40 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    50 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    60 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    70 */  1501, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*    80 */  1428, 1428, 1428, 1428, 1428, 1499, 1652, 1428, 1821, 1428,
 /*    90 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   100 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   110 */  1428, 1428, 1428, 1428, 1428, 1501, 1428, 1833, 1833, 1833,
 /*   120 */  1499, 1428, 1428, 1428, 1696, 1696, 1428, 1428, 1428, 1428,
 /*   130 */  1595, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1688,
 /*   140 */  1428, 1428, 1903, 1428, 1428, 1694, 1857, 1428, 1428, 1428,
 /*   150 */  1428, 1548, 1849, 1825, 1839, 1826, 1888, 1888, 1888, 1842,
 /*   160 */  1428, 1853, 1428, 1428, 1428, 1680, 1428, 1428, 1657, 1654,
 /*   170 */  1654, 1428, 1428, 1428, 1428, 1428, 1501, 1428, 1501, 1428,
 /*   180 */  1428, 1501, 1428, 1501, 1428, 1501, 1501, 1428, 1501, 1428,
 /*   190 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   200 */  1428, 1428, 1428, 1428, 1428, 1499, 1690, 1428, 1499, 1428,
 /*   210 */  1428, 1428, 1499, 1428, 1428, 1864, 1862, 1428, 1864, 1862,
 /*   220 */  1428, 1428, 1428, 1876, 1872, 1864, 1880, 1878, 1855, 1853,
 /*   230 */  1839, 1428, 1428, 1823, 1894, 1890, 1906, 1894, 1890, 1894,
 /*   240 */  1890, 1428, 1862, 1428, 1428, 1428, 1428, 1428, 1862, 1428,
 /*   250 */  1428, 1428, 1428, 1499, 1428, 1499, 1428, 1564, 1428, 1428,
 /*   260 */  1428, 1499, 1460, 1428, 1682, 1696, 1598, 1598, 1598, 1502,
 /*   270 */  1433, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   280 */  1428, 1428, 1765, 1875, 1874, 1797, 1796, 1795, 1793, 1764,
 /*   290 */  1428, 1428, 1560, 1763, 1762, 1428, 1428, 1428, 1428, 1428,
 /*   300 */  1428, 1756, 1757, 1755, 1754, 1428, 1428, 1428, 1428, 1428,
 /*   310 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   320 */  1822, 1428, 1891, 1895, 1428, 1428, 1428, 1739, 1428, 1428,
 /*   330 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   340 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   350 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   360 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   370 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   380 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   390 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   400 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   410 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   420 */  1428, 1428, 1428, 1428, 1428, 1428, 1465, 1428, 1428, 1428,
 /*   430 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   440 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   450 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   460 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   470 */  1428, 1428, 1428, 1529, 1528, 1428, 1428, 1428, 1428, 1428,
 /*   480 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   490 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   500 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1846, 1856,
 /*   510 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   520 */  1428, 1428, 1428, 1739, 1428, 1873, 1428, 1832, 1828, 1428,
 /*   530 */  1428, 1824, 1428, 1428, 1889, 1428, 1428, 1428, 1428, 1428,
 /*   540 */  1428, 1428, 1428, 1428, 1817, 1428, 1790, 1428, 1428, 1428,
 /*   550 */  1428, 1428, 1428, 1428, 1428, 1750, 1428, 1428, 1428, 1428,
 /*   560 */  1700, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1738,
 /*   570 */  1428, 1781, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   580 */  1592, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   590 */  1428, 1428, 1428, 1577, 1575, 1574, 1573, 1428, 1570, 1428,
 /*   600 */  1428, 1428, 1428, 1601, 1600, 1428, 1428, 1428, 1428, 1428,
 /*   610 */  1428, 1521, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   620 */  1428, 1512, 1428, 1511, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   630 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   640 */  1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428, 1428,
 /*   650 */  1428, 1428, 1428, 1428, 1428, 1428,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  240,  /*  NK_BITNOT => ID */
  240,  /*     INSERT => ID */
  240,  /*     VALUES => ID */
  240,  /*     IMPORT => ID */
  240,  /*    NK_SEMI => ID */
  240,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "IF",
  /*   60 */ "NOT",
  /*   61 */ "EXISTS",
  /*   62 */ "BUFFER",
  /*   63 */ "CACHELAST",
  /*   64 */ "COMP",
  /*   65 */ "DURATION",
  /*   66 */ "NK_VARIABLE",
  /*   67 */ "FSYNC",
  /*   68 */ "MAXROWS",
  /*   69 */ "MINROWS",
  /*   70 */ "KEEP",
  /*   71 */ "PAGES",
  /*   72 */ "PAGESIZE",
  /*   73 */ "PRECISION",
  /*   74 */ "REPLICA",
  /*   75 */ "STRICT",
  /*   76 */ "WAL",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "NK_COLON",
  /*   82 */ "TABLE",
  /*   83 */ "NK_LP",
  /*   84 */ "NK_RP",
  /*   85 */ "STABLE",
  /*   86 */ "ADD",
  /*   87 */ "COLUMN",
  /*   88 */ "MODIFY",
  /*   89 */ "RENAME",
  /*   90 */ "TAG",
  /*   91 */ "SET",
  /*   92 */ "NK_EQ",
  /*   93 */ "USING",
  /*   94 */ "TAGS",
  /*   95 */ "COMMENT",
  /*   96 */ "BOOL",
  /*   97 */ "TINYINT",
  /*   98 */ "SMALLINT",
  /*   99 */ "INT",
  /*  100 */ "INTEGER",
  /*  101 */ "BIGINT",
  /*  102 */ "FLOAT",
  /*  103 */ "DOUBLE",
  /*  104 */ "BINARY",
  /*  105 */ "TIMESTAMP",
  /*  106 */ "NCHAR",
  /*  107 */ "UNSIGNED",
  /*  108 */ "JSON",
  /*  109 */ "VARCHAR",
  /*  110 */ "MEDIUMBLOB",
  /*  111 */ "BLOB",
  /*  112 */ "VARBINARY",
  /*  113 */ "DECIMAL",
  /*  114 */ "MAX_DELAY",
  /*  115 */ "WATERMARK",
  /*  116 */ "ROLLUP",
  /*  117 */ "TTL",
  /*  118 */ "SMA",
  /*  119 */ "FIRST",
  /*  120 */ "LAST",
  /*  121 */ "SHOW",
  /*  122 */ "DATABASES",
  /*  123 */ "TABLES",
  /*  124 */ "STABLES",
  /*  125 */ "MNODES",
  /*  126 */ "MODULES",
  /*  127 */ "QNODES",
  /*  128 */ "FUNCTIONS",
  /*  129 */ "INDEXES",
  /*  130 */ "ACCOUNTS",
  /*  131 */ "APPS",
  /*  132 */ "CONNECTIONS",
  /*  133 */ "LICENCE",
  /*  134 */ "GRANTS",
  /*  135 */ "QUERIES",
  /*  136 */ "SCORES",
  /*  137 */ "TOPICS",
  /*  138 */ "VARIABLES",
  /*  139 */ "BNODES",
  /*  140 */ "SNODES",
  /*  141 */ "CLUSTER",
  /*  142 */ "TRANSACTIONS",
  /*  143 */ "DISTRIBUTED",
  /*  144 */ "CONSUMERS",
  /*  145 */ "SUBSCRIPTIONS",
  /*  146 */ "LIKE",
  /*  147 */ "INDEX",
  /*  148 */ "FUNCTION",
  /*  149 */ "INTERVAL",
  /*  150 */ "TOPIC",
  /*  151 */ "AS",
  /*  152 */ "WITH",
  /*  153 */ "META",
  /*  154 */ "CONSUMER",
  /*  155 */ "GROUP",
  /*  156 */ "DESC",
  /*  157 */ "DESCRIBE",
  /*  158 */ "RESET",
  /*  159 */ "QUERY",
  /*  160 */ "CACHE",
  /*  161 */ "EXPLAIN",
  /*  162 */ "ANALYZE",
  /*  163 */ "VERBOSE",
  /*  164 */ "NK_BOOL",
  /*  165 */ "RATIO",
  /*  166 */ "NK_FLOAT",
  /*  167 */ "COMPACT",
  /*  168 */ "VNODES",
  /*  169 */ "IN",
  /*  170 */ "OUTPUTTYPE",
  /*  171 */ "AGGREGATE",
  /*  172 */ "BUFSIZE",
  /*  173 */ "STREAM",
  /*  174 */ "INTO",
  /*  175 */ "TRIGGER",
  /*  176 */ "AT_ONCE",
  /*  177 */ "WINDOW_CLOSE",
  /*  178 */ "KILL",
  /*  179 */ "CONNECTION",
  /*  180 */ "TRANSACTION",
  /*  181 */ "BALANCE",
  /*  182 */ "VGROUP",
  /*  183 */ "MERGE",
  /*  184 */ "REDISTRIBUTE",
  /*  185 */ "SPLIT",
  /*  186 */ "SYNCDB",
  /*  187 */ "DELETE",
  /*  188 */ "NULL",
  /*  189 */ "NK_QUESTION",
  /*  190 */ "NK_ARROW",
  /*  191 */ "ROWTS",
  /*  192 */ "TBNAME",
  /*  193 */ "QSTARTTS",
  /*  194 */ "QENDTS",
  /*  195 */ "WSTARTTS",
  /*  196 */ "WENDTS",
  /*  197 */ "WDURATION",
  /*  198 */ "CAST",
  /*  199 */ "NOW",
  /*  200 */ "TODAY",
  /*  201 */ "TIMEZONE",
  /*  202 */ "COUNT",
  /*  203 */ "LAST_ROW",
  /*  204 */ "BETWEEN",
  /*  205 */ "IS",
  /*  206 */ "NK_LT",
  /*  207 */ "NK_GT",
  /*  208 */ "NK_LE",
  /*  209 */ "NK_GE",
  /*  210 */ "NK_NE",
  /*  211 */ "MATCH",
  /*  212 */ "NMATCH",
  /*  213 */ "CONTAINS",
  /*  214 */ "JOIN",
  /*  215 */ "INNER",
  /*  216 */ "SELECT",
  /*  217 */ "DISTINCT",
  /*  218 */ "WHERE",
  /*  219 */ "PARTITION",
  /*  220 */ "BY",
  /*  221 */ "SESSION",
  /*  222 */ "STATE_WINDOW",
  /*  223 */ "SLIDING",
  /*  224 */ "FILL",
  /*  225 */ "VALUE",
  /*  226 */ "NONE",
  /*  227 */ "PREV",
  /*  228 */ "LINEAR",
  /*  229 */ "NEXT",
  /*  230 */ "HAVING",
  /*  231 */ "RANGE",
  /*  232 */ "EVERY",
  /*  233 */ "ORDER",
  /*  234 */ "SLIMIT",
  /*  235 */ "SOFFSET",
  /*  236 */ "LIMIT",
  /*  237 */ "OFFSET",
  /*  238 */ "ASC",
  /*  239 */ "NULLS",
  /*  240 */ "ID",
  /*  241 */ "NK_BITNOT",
  /*  242 */ "INSERT",
  /*  243 */ "VALUES",
  /*  244 */ "IMPORT",
  /*  245 */ "NK_SEMI",
  /*  246 */ "FILE",
  /*  247 */ "cmd",
  /*  248 */ "account_options",
  /*  249 */ "alter_account_options",
  /*  250 */ "literal",
  /*  251 */ "alter_account_option",
  /*  252 */ "user_name",
  /*  253 */ "sysinfo_opt",
  /*  254 */ "privileges",
  /*  255 */ "priv_level",
  /*  256 */ "priv_type_list",
  /*  257 */ "priv_type",
  /*  258 */ "db_name",
  /*  259 */ "dnode_endpoint",
  /*  260 */ "not_exists_opt",
  /*  261 */ "db_options",
  /*  262 */ "exists_opt",
  /*  263 */ "alter_db_options",
  /*  264 */ "integer_list",
  /*  265 */ "variable_list",
  /*  266 */ "retention_list",
  /*  267 */ "alter_db_option",
  /*  268 */ "retention",
  /*  269 */ "full_table_name",
  /*  270 */ "column_def_list",
  /*  271 */ "tags_def_opt",
  /*  272 */ "table_options",
  /*  273 */ "multi_create_clause",
  /*  274 */ "tags_def",
  /*  275 */ "multi_drop_clause",
  /*  276 */ "alter_table_clause",
  /*  277 */ "alter_table_options",
  /*  278 */ "column_name",
  /*  279 */ "type_name",
  /*  280 */ "signed_literal",
  /*  281 */ "create_subtable_clause",
  /*  282 */ "specific_tags_opt",
  /*  283 */ "literal_list",
  /*  284 */ "drop_table_clause",
  /*  285 */ "col_name_list",
  /*  286 */ "table_name",
  /*  287 */ "column_def",
  /*  288 */ "duration_list",
  /*  289 */ "rollup_func_list",
  /*  290 */ "alter_table_option",
  /*  291 */ "duration_literal",
  /*  292 */ "rollup_func_name",
  /*  293 */ "function_name",
  /*  294 */ "col_name",
  /*  295 */ "db_name_cond_opt",
  /*  296 */ "like_pattern_opt",
  /*  297 */ "table_name_cond",
  /*  298 */ "from_db_opt",
  /*  299 */ "index_name",
  /*  300 */ "index_options",
  /*  301 */ "func_list",
  /*  302 */ "sliding_opt",
  /*  303 */ "sma_stream_opt",
  /*  304 */ "func",
  /*  305 */ "expression_list",
  /*  306 */ "stream_options",
  /*  307 */ "topic_name",
  /*  308 */ "query_expression",
  /*  309 */ "cgroup_name",
  /*  310 */ "analyze_opt",
  /*  311 */ "explain_options",
  /*  312 */ "agg_func_opt",
  /*  313 */ "bufsize_opt",
  /*  314 */ "stream_name",
  /*  315 */ "into_opt",
  /*  316 */ "dnode_list",
  /*  317 */ "where_clause_opt",
  /*  318 */ "signed",
  /*  319 */ "literal_func",
  /*  320 */ "table_alias",
  /*  321 */ "column_alias",
  /*  322 */ "expression",
  /*  323 */ "pseudo_column",
  /*  324 */ "column_reference",
  /*  325 */ "function_expression",
  /*  326 */ "subquery",
  /*  327 */ "star_func",
  /*  328 */ "star_func_para_list",
  /*  329 */ "noarg_func",
  /*  330 */ "other_para_list",
  /*  331 */ "star_func_para",
  /*  332 */ "predicate",
  /*  333 */ "compare_op",
  /*  334 */ "in_op",
  /*  335 */ "in_predicate_value",
  /*  336 */ "boolean_value_expression",
  /*  337 */ "boolean_primary",
  /*  338 */ "common_expression",
  /*  339 */ "from_clause_opt",
  /*  340 */ "table_reference_list",
  /*  341 */ "table_reference",
  /*  342 */ "table_primary",
  /*  343 */ "joined_table",
  /*  344 */ "alias_opt",
  /*  345 */ "parenthesized_joined_table",
  /*  346 */ "join_type",
  /*  347 */ "search_condition",
  /*  348 */ "query_specification",
  /*  349 */ "set_quantifier_opt",
  /*  350 */ "select_list",
  /*  351 */ "partition_by_clause_opt",
  /*  352 */ "range_opt",
  /*  353 */ "every_opt",
  /*  354 */ "fill_opt",
  /*  355 */ "twindow_clause_opt",
  /*  356 */ "group_by_clause_opt",
  /*  357 */ "having_clause_opt",
  /*  358 */ "select_sublist",
  /*  359 */ "select_item",
  /*  360 */ "fill_mode",
  /*  361 */ "group_by_list",
  /*  362 */ "query_expression_body",
  /*  363 */ "order_by_clause_opt",
  /*  364 */ "slimit_clause_opt",
  /*  365 */ "limit_clause_opt",
  /*  366 */ "query_primary",
  /*  367 */ "sort_specification_list",
  /*  368 */ "sort_specification",
  /*  369 */ "ordering_specification_opt",
  /*  370 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  68 */ "not_exists_opt ::=",
 /*  69 */ "exists_opt ::= IF EXISTS",
 /*  70 */ "exists_opt ::=",
 /*  71 */ "db_options ::=",
 /*  72 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  73 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  74 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  75 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  76 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  77 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  78 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  79 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options KEEP integer_list",
 /*  81 */ "db_options ::= db_options KEEP variable_list",
 /*  82 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  83 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  85 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  86 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  87 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "alter_db_options ::= alter_db_option",
 /*  93 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  94 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  95 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  96 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  97 */ "alter_db_option ::= KEEP integer_list",
 /*  98 */ "alter_db_option ::= KEEP variable_list",
 /*  99 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 100 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 101 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 102 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 103 */ "integer_list ::= NK_INTEGER",
 /* 104 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 105 */ "variable_list ::= NK_VARIABLE",
 /* 106 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 107 */ "retention_list ::= retention",
 /* 108 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 109 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 110 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 111 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 112 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 113 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 114 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 115 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 116 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 117 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 118 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 123 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 124 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 125 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 126 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 127 */ "multi_create_clause ::= create_subtable_clause",
 /* 128 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 129 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 130 */ "multi_drop_clause ::= drop_table_clause",
 /* 131 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 132 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 133 */ "specific_tags_opt ::=",
 /* 134 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 135 */ "full_table_name ::= table_name",
 /* 136 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 137 */ "column_def_list ::= column_def",
 /* 138 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 139 */ "column_def ::= column_name type_name",
 /* 140 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 141 */ "type_name ::= BOOL",
 /* 142 */ "type_name ::= TINYINT",
 /* 143 */ "type_name ::= SMALLINT",
 /* 144 */ "type_name ::= INT",
 /* 145 */ "type_name ::= INTEGER",
 /* 146 */ "type_name ::= BIGINT",
 /* 147 */ "type_name ::= FLOAT",
 /* 148 */ "type_name ::= DOUBLE",
 /* 149 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 150 */ "type_name ::= TIMESTAMP",
 /* 151 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 152 */ "type_name ::= TINYINT UNSIGNED",
 /* 153 */ "type_name ::= SMALLINT UNSIGNED",
 /* 154 */ "type_name ::= INT UNSIGNED",
 /* 155 */ "type_name ::= BIGINT UNSIGNED",
 /* 156 */ "type_name ::= JSON",
 /* 157 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 158 */ "type_name ::= MEDIUMBLOB",
 /* 159 */ "type_name ::= BLOB",
 /* 160 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 161 */ "type_name ::= DECIMAL",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 164 */ "tags_def_opt ::=",
 /* 165 */ "tags_def_opt ::= tags_def",
 /* 166 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 167 */ "table_options ::=",
 /* 168 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 169 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 170 */ "table_options ::= table_options WATERMARK duration_list",
 /* 171 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 172 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 173 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 174 */ "alter_table_options ::= alter_table_option",
 /* 175 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 176 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 177 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 178 */ "duration_list ::= duration_literal",
 /* 179 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 180 */ "rollup_func_list ::= rollup_func_name",
 /* 181 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 182 */ "rollup_func_name ::= function_name",
 /* 183 */ "rollup_func_name ::= FIRST",
 /* 184 */ "rollup_func_name ::= LAST",
 /* 185 */ "col_name_list ::= col_name",
 /* 186 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 187 */ "col_name ::= column_name",
 /* 188 */ "cmd ::= SHOW DNODES",
 /* 189 */ "cmd ::= SHOW USERS",
 /* 190 */ "cmd ::= SHOW DATABASES",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 193 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 194 */ "cmd ::= SHOW MNODES",
 /* 195 */ "cmd ::= SHOW MODULES",
 /* 196 */ "cmd ::= SHOW QNODES",
 /* 197 */ "cmd ::= SHOW FUNCTIONS",
 /* 198 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 199 */ "cmd ::= SHOW STREAMS",
 /* 200 */ "cmd ::= SHOW ACCOUNTS",
 /* 201 */ "cmd ::= SHOW APPS",
 /* 202 */ "cmd ::= SHOW CONNECTIONS",
 /* 203 */ "cmd ::= SHOW LICENCE",
 /* 204 */ "cmd ::= SHOW GRANTS",
 /* 205 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 206 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 207 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 208 */ "cmd ::= SHOW QUERIES",
 /* 209 */ "cmd ::= SHOW SCORES",
 /* 210 */ "cmd ::= SHOW TOPICS",
 /* 211 */ "cmd ::= SHOW VARIABLES",
 /* 212 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 213 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 214 */ "cmd ::= SHOW BNODES",
 /* 215 */ "cmd ::= SHOW SNODES",
 /* 216 */ "cmd ::= SHOW CLUSTER",
 /* 217 */ "cmd ::= SHOW TRANSACTIONS",
 /* 218 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 219 */ "cmd ::= SHOW CONSUMERS",
 /* 220 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 221 */ "db_name_cond_opt ::=",
 /* 222 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 223 */ "like_pattern_opt ::=",
 /* 224 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 225 */ "table_name_cond ::= table_name",
 /* 226 */ "from_db_opt ::=",
 /* 227 */ "from_db_opt ::= FROM db_name",
 /* 228 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 229 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 230 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 231 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 232 */ "func_list ::= func",
 /* 233 */ "func_list ::= func_list NK_COMMA func",
 /* 234 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 235 */ "sma_stream_opt ::=",
 /* 236 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 237 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 238 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 239 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 242 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 243 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 244 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 245 */ "cmd ::= DESC full_table_name",
 /* 246 */ "cmd ::= DESCRIBE full_table_name",
 /* 247 */ "cmd ::= RESET QUERY CACHE",
 /* 248 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 249 */ "analyze_opt ::=",
 /* 250 */ "analyze_opt ::= ANALYZE",
 /* 251 */ "explain_options ::=",
 /* 252 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 253 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 254 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 255 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 256 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 257 */ "agg_func_opt ::=",
 /* 258 */ "agg_func_opt ::= AGGREGATE",
 /* 259 */ "bufsize_opt ::=",
 /* 260 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 261 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 262 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 263 */ "into_opt ::=",
 /* 264 */ "into_opt ::= INTO full_table_name",
 /* 265 */ "stream_options ::=",
 /* 266 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 267 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 268 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 269 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 270 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 271 */ "cmd ::= KILL QUERY NK_STRING",
 /* 272 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 273 */ "cmd ::= BALANCE VGROUP",
 /* 274 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 275 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 276 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 277 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 278 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 279 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 280 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 281 */ "cmd ::= query_expression",
 /* 282 */ "literal ::= NK_INTEGER",
 /* 283 */ "literal ::= NK_FLOAT",
 /* 284 */ "literal ::= NK_STRING",
 /* 285 */ "literal ::= NK_BOOL",
 /* 286 */ "literal ::= TIMESTAMP NK_STRING",
 /* 287 */ "literal ::= duration_literal",
 /* 288 */ "literal ::= NULL",
 /* 289 */ "literal ::= NK_QUESTION",
 /* 290 */ "duration_literal ::= NK_VARIABLE",
 /* 291 */ "signed ::= NK_INTEGER",
 /* 292 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 293 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 294 */ "signed ::= NK_FLOAT",
 /* 295 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 296 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 297 */ "signed_literal ::= signed",
 /* 298 */ "signed_literal ::= NK_STRING",
 /* 299 */ "signed_literal ::= NK_BOOL",
 /* 300 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 301 */ "signed_literal ::= duration_literal",
 /* 302 */ "signed_literal ::= NULL",
 /* 303 */ "signed_literal ::= literal_func",
 /* 304 */ "literal_list ::= signed_literal",
 /* 305 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 306 */ "db_name ::= NK_ID",
 /* 307 */ "table_name ::= NK_ID",
 /* 308 */ "column_name ::= NK_ID",
 /* 309 */ "function_name ::= NK_ID",
 /* 310 */ "table_alias ::= NK_ID",
 /* 311 */ "column_alias ::= NK_ID",
 /* 312 */ "user_name ::= NK_ID",
 /* 313 */ "index_name ::= NK_ID",
 /* 314 */ "topic_name ::= NK_ID",
 /* 315 */ "stream_name ::= NK_ID",
 /* 316 */ "cgroup_name ::= NK_ID",
 /* 317 */ "expression ::= literal",
 /* 318 */ "expression ::= pseudo_column",
 /* 319 */ "expression ::= column_reference",
 /* 320 */ "expression ::= function_expression",
 /* 321 */ "expression ::= subquery",
 /* 322 */ "expression ::= NK_LP expression NK_RP",
 /* 323 */ "expression ::= NK_PLUS expression",
 /* 324 */ "expression ::= NK_MINUS expression",
 /* 325 */ "expression ::= expression NK_PLUS expression",
 /* 326 */ "expression ::= expression NK_MINUS expression",
 /* 327 */ "expression ::= expression NK_STAR expression",
 /* 328 */ "expression ::= expression NK_SLASH expression",
 /* 329 */ "expression ::= expression NK_REM expression",
 /* 330 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 331 */ "expression ::= expression NK_BITAND expression",
 /* 332 */ "expression ::= expression NK_BITOR expression",
 /* 333 */ "expression_list ::= expression",
 /* 334 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 335 */ "column_reference ::= column_name",
 /* 336 */ "column_reference ::= table_name NK_DOT column_name",
 /* 337 */ "pseudo_column ::= ROWTS",
 /* 338 */ "pseudo_column ::= TBNAME",
 /* 339 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 340 */ "pseudo_column ::= QSTARTTS",
 /* 341 */ "pseudo_column ::= QENDTS",
 /* 342 */ "pseudo_column ::= WSTARTTS",
 /* 343 */ "pseudo_column ::= WENDTS",
 /* 344 */ "pseudo_column ::= WDURATION",
 /* 345 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 346 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 347 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 348 */ "function_expression ::= literal_func",
 /* 349 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 350 */ "literal_func ::= NOW",
 /* 351 */ "noarg_func ::= NOW",
 /* 352 */ "noarg_func ::= TODAY",
 /* 353 */ "noarg_func ::= TIMEZONE",
 /* 354 */ "star_func ::= COUNT",
 /* 355 */ "star_func ::= FIRST",
 /* 356 */ "star_func ::= LAST",
 /* 357 */ "star_func ::= LAST_ROW",
 /* 358 */ "star_func_para_list ::= NK_STAR",
 /* 359 */ "star_func_para_list ::= other_para_list",
 /* 360 */ "other_para_list ::= star_func_para",
 /* 361 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 362 */ "star_func_para ::= expression",
 /* 363 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 364 */ "predicate ::= expression compare_op expression",
 /* 365 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 366 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 367 */ "predicate ::= expression IS NULL",
 /* 368 */ "predicate ::= expression IS NOT NULL",
 /* 369 */ "predicate ::= expression in_op in_predicate_value",
 /* 370 */ "compare_op ::= NK_LT",
 /* 371 */ "compare_op ::= NK_GT",
 /* 372 */ "compare_op ::= NK_LE",
 /* 373 */ "compare_op ::= NK_GE",
 /* 374 */ "compare_op ::= NK_NE",
 /* 375 */ "compare_op ::= NK_EQ",
 /* 376 */ "compare_op ::= LIKE",
 /* 377 */ "compare_op ::= NOT LIKE",
 /* 378 */ "compare_op ::= MATCH",
 /* 379 */ "compare_op ::= NMATCH",
 /* 380 */ "compare_op ::= CONTAINS",
 /* 381 */ "in_op ::= IN",
 /* 382 */ "in_op ::= NOT IN",
 /* 383 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 384 */ "boolean_value_expression ::= boolean_primary",
 /* 385 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 386 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 387 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 388 */ "boolean_primary ::= predicate",
 /* 389 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 390 */ "common_expression ::= expression",
 /* 391 */ "common_expression ::= boolean_value_expression",
 /* 392 */ "from_clause_opt ::=",
 /* 393 */ "from_clause_opt ::= FROM table_reference_list",
 /* 394 */ "table_reference_list ::= table_reference",
 /* 395 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 396 */ "table_reference ::= table_primary",
 /* 397 */ "table_reference ::= joined_table",
 /* 398 */ "table_primary ::= table_name alias_opt",
 /* 399 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 400 */ "table_primary ::= subquery alias_opt",
 /* 401 */ "table_primary ::= parenthesized_joined_table",
 /* 402 */ "alias_opt ::=",
 /* 403 */ "alias_opt ::= table_alias",
 /* 404 */ "alias_opt ::= AS table_alias",
 /* 405 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 406 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 407 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 408 */ "join_type ::=",
 /* 409 */ "join_type ::= INNER",
 /* 410 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 411 */ "set_quantifier_opt ::=",
 /* 412 */ "set_quantifier_opt ::= DISTINCT",
 /* 413 */ "set_quantifier_opt ::= ALL",
 /* 414 */ "select_list ::= NK_STAR",
 /* 415 */ "select_list ::= select_sublist",
 /* 416 */ "select_sublist ::= select_item",
 /* 417 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 418 */ "select_item ::= common_expression",
 /* 419 */ "select_item ::= common_expression column_alias",
 /* 420 */ "select_item ::= common_expression AS column_alias",
 /* 421 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 422 */ "where_clause_opt ::=",
 /* 423 */ "where_clause_opt ::= WHERE search_condition",
 /* 424 */ "partition_by_clause_opt ::=",
 /* 425 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 426 */ "twindow_clause_opt ::=",
 /* 427 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 428 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 429 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 430 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 431 */ "sliding_opt ::=",
 /* 432 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 433 */ "fill_opt ::=",
 /* 434 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 435 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 436 */ "fill_mode ::= NONE",
 /* 437 */ "fill_mode ::= PREV",
 /* 438 */ "fill_mode ::= NULL",
 /* 439 */ "fill_mode ::= LINEAR",
 /* 440 */ "fill_mode ::= NEXT",
 /* 441 */ "group_by_clause_opt ::=",
 /* 442 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 443 */ "group_by_list ::= expression",
 /* 444 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 445 */ "having_clause_opt ::=",
 /* 446 */ "having_clause_opt ::= HAVING search_condition",
 /* 447 */ "range_opt ::=",
 /* 448 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 449 */ "every_opt ::=",
 /* 450 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 451 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 452 */ "query_expression_body ::= query_primary",
 /* 453 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 454 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 455 */ "query_primary ::= query_specification",
 /* 456 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 457 */ "order_by_clause_opt ::=",
 /* 458 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 459 */ "slimit_clause_opt ::=",
 /* 460 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 461 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 462 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 463 */ "limit_clause_opt ::=",
 /* 464 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 465 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 466 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 467 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 468 */ "search_condition ::= common_expression",
 /* 469 */ "sort_specification_list ::= sort_specification",
 /* 470 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 471 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 472 */ "ordering_specification_opt ::=",
 /* 473 */ "ordering_specification_opt ::= ASC",
 /* 474 */ "ordering_specification_opt ::= DESC",
 /* 475 */ "null_ordering_opt ::=",
 /* 476 */ "null_ordering_opt ::= NULLS FIRST",
 /* 477 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 247: /* cmd */
    case 250: /* literal */
    case 261: /* db_options */
    case 263: /* alter_db_options */
    case 268: /* retention */
    case 269: /* full_table_name */
    case 272: /* table_options */
    case 276: /* alter_table_clause */
    case 277: /* alter_table_options */
    case 280: /* signed_literal */
    case 281: /* create_subtable_clause */
    case 284: /* drop_table_clause */
    case 287: /* column_def */
    case 291: /* duration_literal */
    case 292: /* rollup_func_name */
    case 294: /* col_name */
    case 295: /* db_name_cond_opt */
    case 296: /* like_pattern_opt */
    case 297: /* table_name_cond */
    case 298: /* from_db_opt */
    case 300: /* index_options */
    case 302: /* sliding_opt */
    case 303: /* sma_stream_opt */
    case 304: /* func */
    case 306: /* stream_options */
    case 308: /* query_expression */
    case 311: /* explain_options */
    case 315: /* into_opt */
    case 317: /* where_clause_opt */
    case 318: /* signed */
    case 319: /* literal_func */
    case 322: /* expression */
    case 323: /* pseudo_column */
    case 324: /* column_reference */
    case 325: /* function_expression */
    case 326: /* subquery */
    case 331: /* star_func_para */
    case 332: /* predicate */
    case 335: /* in_predicate_value */
    case 336: /* boolean_value_expression */
    case 337: /* boolean_primary */
    case 338: /* common_expression */
    case 339: /* from_clause_opt */
    case 340: /* table_reference_list */
    case 341: /* table_reference */
    case 342: /* table_primary */
    case 343: /* joined_table */
    case 345: /* parenthesized_joined_table */
    case 347: /* search_condition */
    case 348: /* query_specification */
    case 352: /* range_opt */
    case 353: /* every_opt */
    case 354: /* fill_opt */
    case 355: /* twindow_clause_opt */
    case 357: /* having_clause_opt */
    case 359: /* select_item */
    case 362: /* query_expression_body */
    case 364: /* slimit_clause_opt */
    case 365: /* limit_clause_opt */
    case 366: /* query_primary */
    case 368: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy714)); 
}
      break;
    case 248: /* account_options */
    case 249: /* alter_account_options */
    case 251: /* alter_account_option */
    case 313: /* bufsize_opt */
{
 
}
      break;
    case 252: /* user_name */
    case 255: /* priv_level */
    case 258: /* db_name */
    case 259: /* dnode_endpoint */
    case 278: /* column_name */
    case 286: /* table_name */
    case 293: /* function_name */
    case 299: /* index_name */
    case 307: /* topic_name */
    case 309: /* cgroup_name */
    case 314: /* stream_name */
    case 320: /* table_alias */
    case 321: /* column_alias */
    case 327: /* star_func */
    case 329: /* noarg_func */
    case 344: /* alias_opt */
{
 
}
      break;
    case 253: /* sysinfo_opt */
{
 
}
      break;
    case 254: /* privileges */
    case 256: /* priv_type_list */
    case 257: /* priv_type */
{
 
}
      break;
    case 260: /* not_exists_opt */
    case 262: /* exists_opt */
    case 310: /* analyze_opt */
    case 312: /* agg_func_opt */
    case 349: /* set_quantifier_opt */
{
 
}
      break;
    case 264: /* integer_list */
    case 265: /* variable_list */
    case 266: /* retention_list */
    case 270: /* column_def_list */
    case 271: /* tags_def_opt */
    case 273: /* multi_create_clause */
    case 274: /* tags_def */
    case 275: /* multi_drop_clause */
    case 282: /* specific_tags_opt */
    case 283: /* literal_list */
    case 285: /* col_name_list */
    case 288: /* duration_list */
    case 289: /* rollup_func_list */
    case 301: /* func_list */
    case 305: /* expression_list */
    case 316: /* dnode_list */
    case 328: /* star_func_para_list */
    case 330: /* other_para_list */
    case 350: /* select_list */
    case 351: /* partition_by_clause_opt */
    case 356: /* group_by_clause_opt */
    case 358: /* select_sublist */
    case 361: /* group_by_list */
    case 363: /* order_by_clause_opt */
    case 367: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy656)); 
}
      break;
    case 267: /* alter_db_option */
    case 290: /* alter_table_option */
{
 
}
      break;
    case 279: /* type_name */
{
 
}
      break;
    case 333: /* compare_op */
    case 334: /* in_op */
{
 
}
      break;
    case 346: /* join_type */
{
 
}
      break;
    case 360: /* fill_mode */
{
 
}
      break;
    case 369: /* ordering_specification_opt */
{
 
}
      break;
    case 370: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  247,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  247,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  248,    0 }, /* (2) account_options ::= */
  {  248,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  248,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  248,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  248,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  248,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  248,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  248,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  248,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  248,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  249,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  249,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  251,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  251,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  251,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  251,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  251,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  251,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  251,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  251,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  251,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  251,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  247,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  247,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  247,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  247,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  247,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  253,    0 }, /* (29) sysinfo_opt ::= */
  {  253,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  247,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  247,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  254,   -1 }, /* (33) privileges ::= ALL */
  {  254,   -1 }, /* (34) privileges ::= priv_type_list */
  {  256,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  256,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  257,   -1 }, /* (37) priv_type ::= READ */
  {  257,   -1 }, /* (38) priv_type ::= WRITE */
  {  255,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  255,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  247,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  247,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  247,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  247,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  247,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  247,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  247,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  247,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  259,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  259,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  259,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  247,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  247,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  247,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  247,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  247,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  247,   -2 }, /* (64) cmd ::= USE db_name */
  {  247,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  247,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  260,   -3 }, /* (67) not_exists_opt ::= IF NOT EXISTS */
  {  260,    0 }, /* (68) not_exists_opt ::= */
  {  262,   -2 }, /* (69) exists_opt ::= IF EXISTS */
  {  262,    0 }, /* (70) exists_opt ::= */
  {  261,    0 }, /* (71) db_options ::= */
  {  261,   -3 }, /* (72) db_options ::= db_options BUFFER NK_INTEGER */
  {  261,   -3 }, /* (73) db_options ::= db_options CACHELAST NK_INTEGER */
  {  261,   -3 }, /* (74) db_options ::= db_options COMP NK_INTEGER */
  {  261,   -3 }, /* (75) db_options ::= db_options DURATION NK_INTEGER */
  {  261,   -3 }, /* (76) db_options ::= db_options DURATION NK_VARIABLE */
  {  261,   -3 }, /* (77) db_options ::= db_options FSYNC NK_INTEGER */
  {  261,   -3 }, /* (78) db_options ::= db_options MAXROWS NK_INTEGER */
  {  261,   -3 }, /* (79) db_options ::= db_options MINROWS NK_INTEGER */
  {  261,   -3 }, /* (80) db_options ::= db_options KEEP integer_list */
  {  261,   -3 }, /* (81) db_options ::= db_options KEEP variable_list */
  {  261,   -3 }, /* (82) db_options ::= db_options PAGES NK_INTEGER */
  {  261,   -3 }, /* (83) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  261,   -3 }, /* (84) db_options ::= db_options PRECISION NK_STRING */
  {  261,   -3 }, /* (85) db_options ::= db_options REPLICA NK_INTEGER */
  {  261,   -3 }, /* (86) db_options ::= db_options STRICT NK_INTEGER */
  {  261,   -3 }, /* (87) db_options ::= db_options WAL NK_INTEGER */
  {  261,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  261,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  261,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  261,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  263,   -1 }, /* (92) alter_db_options ::= alter_db_option */
  {  263,   -2 }, /* (93) alter_db_options ::= alter_db_options alter_db_option */
  {  267,   -2 }, /* (94) alter_db_option ::= BUFFER NK_INTEGER */
  {  267,   -2 }, /* (95) alter_db_option ::= CACHELAST NK_INTEGER */
  {  267,   -2 }, /* (96) alter_db_option ::= FSYNC NK_INTEGER */
  {  267,   -2 }, /* (97) alter_db_option ::= KEEP integer_list */
  {  267,   -2 }, /* (98) alter_db_option ::= KEEP variable_list */
  {  267,   -2 }, /* (99) alter_db_option ::= PAGES NK_INTEGER */
  {  267,   -2 }, /* (100) alter_db_option ::= REPLICA NK_INTEGER */
  {  267,   -2 }, /* (101) alter_db_option ::= STRICT NK_INTEGER */
  {  267,   -2 }, /* (102) alter_db_option ::= WAL NK_INTEGER */
  {  264,   -1 }, /* (103) integer_list ::= NK_INTEGER */
  {  264,   -3 }, /* (104) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  265,   -1 }, /* (105) variable_list ::= NK_VARIABLE */
  {  265,   -3 }, /* (106) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  266,   -1 }, /* (107) retention_list ::= retention */
  {  266,   -3 }, /* (108) retention_list ::= retention_list NK_COMMA retention */
  {  268,   -3 }, /* (109) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  247,   -9 }, /* (110) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  247,   -3 }, /* (111) cmd ::= CREATE TABLE multi_create_clause */
  {  247,   -9 }, /* (112) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  247,   -3 }, /* (113) cmd ::= DROP TABLE multi_drop_clause */
  {  247,   -4 }, /* (114) cmd ::= DROP STABLE exists_opt full_table_name */
  {  247,   -3 }, /* (115) cmd ::= ALTER TABLE alter_table_clause */
  {  247,   -3 }, /* (116) cmd ::= ALTER STABLE alter_table_clause */
  {  276,   -2 }, /* (117) alter_table_clause ::= full_table_name alter_table_options */
  {  276,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  276,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  276,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  276,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  276,   -5 }, /* (122) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  276,   -4 }, /* (123) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  276,   -5 }, /* (124) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  276,   -5 }, /* (125) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  276,   -6 }, /* (126) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  273,   -1 }, /* (127) multi_create_clause ::= create_subtable_clause */
  {  273,   -2 }, /* (128) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  281,  -10 }, /* (129) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  275,   -1 }, /* (130) multi_drop_clause ::= drop_table_clause */
  {  275,   -2 }, /* (131) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  284,   -2 }, /* (132) drop_table_clause ::= exists_opt full_table_name */
  {  282,    0 }, /* (133) specific_tags_opt ::= */
  {  282,   -3 }, /* (134) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  269,   -1 }, /* (135) full_table_name ::= table_name */
  {  269,   -3 }, /* (136) full_table_name ::= db_name NK_DOT table_name */
  {  270,   -1 }, /* (137) column_def_list ::= column_def */
  {  270,   -3 }, /* (138) column_def_list ::= column_def_list NK_COMMA column_def */
  {  287,   -2 }, /* (139) column_def ::= column_name type_name */
  {  287,   -4 }, /* (140) column_def ::= column_name type_name COMMENT NK_STRING */
  {  279,   -1 }, /* (141) type_name ::= BOOL */
  {  279,   -1 }, /* (142) type_name ::= TINYINT */
  {  279,   -1 }, /* (143) type_name ::= SMALLINT */
  {  279,   -1 }, /* (144) type_name ::= INT */
  {  279,   -1 }, /* (145) type_name ::= INTEGER */
  {  279,   -1 }, /* (146) type_name ::= BIGINT */
  {  279,   -1 }, /* (147) type_name ::= FLOAT */
  {  279,   -1 }, /* (148) type_name ::= DOUBLE */
  {  279,   -4 }, /* (149) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  279,   -1 }, /* (150) type_name ::= TIMESTAMP */
  {  279,   -4 }, /* (151) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  279,   -2 }, /* (152) type_name ::= TINYINT UNSIGNED */
  {  279,   -2 }, /* (153) type_name ::= SMALLINT UNSIGNED */
  {  279,   -2 }, /* (154) type_name ::= INT UNSIGNED */
  {  279,   -2 }, /* (155) type_name ::= BIGINT UNSIGNED */
  {  279,   -1 }, /* (156) type_name ::= JSON */
  {  279,   -4 }, /* (157) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  279,   -1 }, /* (158) type_name ::= MEDIUMBLOB */
  {  279,   -1 }, /* (159) type_name ::= BLOB */
  {  279,   -4 }, /* (160) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  279,   -1 }, /* (161) type_name ::= DECIMAL */
  {  279,   -4 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  279,   -6 }, /* (163) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  271,    0 }, /* (164) tags_def_opt ::= */
  {  271,   -1 }, /* (165) tags_def_opt ::= tags_def */
  {  274,   -4 }, /* (166) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  272,    0 }, /* (167) table_options ::= */
  {  272,   -3 }, /* (168) table_options ::= table_options COMMENT NK_STRING */
  {  272,   -3 }, /* (169) table_options ::= table_options MAX_DELAY duration_list */
  {  272,   -3 }, /* (170) table_options ::= table_options WATERMARK duration_list */
  {  272,   -5 }, /* (171) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  272,   -3 }, /* (172) table_options ::= table_options TTL NK_INTEGER */
  {  272,   -5 }, /* (173) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  277,   -1 }, /* (174) alter_table_options ::= alter_table_option */
  {  277,   -2 }, /* (175) alter_table_options ::= alter_table_options alter_table_option */
  {  290,   -2 }, /* (176) alter_table_option ::= COMMENT NK_STRING */
  {  290,   -2 }, /* (177) alter_table_option ::= TTL NK_INTEGER */
  {  288,   -1 }, /* (178) duration_list ::= duration_literal */
  {  288,   -3 }, /* (179) duration_list ::= duration_list NK_COMMA duration_literal */
  {  289,   -1 }, /* (180) rollup_func_list ::= rollup_func_name */
  {  289,   -3 }, /* (181) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  292,   -1 }, /* (182) rollup_func_name ::= function_name */
  {  292,   -1 }, /* (183) rollup_func_name ::= FIRST */
  {  292,   -1 }, /* (184) rollup_func_name ::= LAST */
  {  285,   -1 }, /* (185) col_name_list ::= col_name */
  {  285,   -3 }, /* (186) col_name_list ::= col_name_list NK_COMMA col_name */
  {  294,   -1 }, /* (187) col_name ::= column_name */
  {  247,   -2 }, /* (188) cmd ::= SHOW DNODES */
  {  247,   -2 }, /* (189) cmd ::= SHOW USERS */
  {  247,   -2 }, /* (190) cmd ::= SHOW DATABASES */
  {  247,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  247,   -4 }, /* (192) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  247,   -3 }, /* (193) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  247,   -2 }, /* (194) cmd ::= SHOW MNODES */
  {  247,   -2 }, /* (195) cmd ::= SHOW MODULES */
  {  247,   -2 }, /* (196) cmd ::= SHOW QNODES */
  {  247,   -2 }, /* (197) cmd ::= SHOW FUNCTIONS */
  {  247,   -5 }, /* (198) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  247,   -2 }, /* (199) cmd ::= SHOW STREAMS */
  {  247,   -2 }, /* (200) cmd ::= SHOW ACCOUNTS */
  {  247,   -2 }, /* (201) cmd ::= SHOW APPS */
  {  247,   -2 }, /* (202) cmd ::= SHOW CONNECTIONS */
  {  247,   -2 }, /* (203) cmd ::= SHOW LICENCE */
  {  247,   -2 }, /* (204) cmd ::= SHOW GRANTS */
  {  247,   -4 }, /* (205) cmd ::= SHOW CREATE DATABASE db_name */
  {  247,   -4 }, /* (206) cmd ::= SHOW CREATE TABLE full_table_name */
  {  247,   -4 }, /* (207) cmd ::= SHOW CREATE STABLE full_table_name */
  {  247,   -2 }, /* (208) cmd ::= SHOW QUERIES */
  {  247,   -2 }, /* (209) cmd ::= SHOW SCORES */
  {  247,   -2 }, /* (210) cmd ::= SHOW TOPICS */
  {  247,   -2 }, /* (211) cmd ::= SHOW VARIABLES */
  {  247,   -3 }, /* (212) cmd ::= SHOW LOCAL VARIABLES */
  {  247,   -4 }, /* (213) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  247,   -2 }, /* (214) cmd ::= SHOW BNODES */
  {  247,   -2 }, /* (215) cmd ::= SHOW SNODES */
  {  247,   -2 }, /* (216) cmd ::= SHOW CLUSTER */
  {  247,   -2 }, /* (217) cmd ::= SHOW TRANSACTIONS */
  {  247,   -4 }, /* (218) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  247,   -2 }, /* (219) cmd ::= SHOW CONSUMERS */
  {  247,   -2 }, /* (220) cmd ::= SHOW SUBSCRIPTIONS */
  {  295,    0 }, /* (221) db_name_cond_opt ::= */
  {  295,   -2 }, /* (222) db_name_cond_opt ::= db_name NK_DOT */
  {  296,    0 }, /* (223) like_pattern_opt ::= */
  {  296,   -2 }, /* (224) like_pattern_opt ::= LIKE NK_STRING */
  {  297,   -1 }, /* (225) table_name_cond ::= table_name */
  {  298,    0 }, /* (226) from_db_opt ::= */
  {  298,   -2 }, /* (227) from_db_opt ::= FROM db_name */
  {  247,   -8 }, /* (228) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  247,   -4 }, /* (229) cmd ::= DROP INDEX exists_opt index_name */
  {  300,  -10 }, /* (230) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  300,  -12 }, /* (231) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  301,   -1 }, /* (232) func_list ::= func */
  {  301,   -3 }, /* (233) func_list ::= func_list NK_COMMA func */
  {  304,   -4 }, /* (234) func ::= function_name NK_LP expression_list NK_RP */
  {  303,    0 }, /* (235) sma_stream_opt ::= */
  {  303,   -3 }, /* (236) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  303,   -3 }, /* (237) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  247,   -6 }, /* (238) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  247,   -7 }, /* (239) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  247,   -9 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  247,   -7 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  247,   -9 }, /* (242) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  247,   -4 }, /* (243) cmd ::= DROP TOPIC exists_opt topic_name */
  {  247,   -7 }, /* (244) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  247,   -2 }, /* (245) cmd ::= DESC full_table_name */
  {  247,   -2 }, /* (246) cmd ::= DESCRIBE full_table_name */
  {  247,   -3 }, /* (247) cmd ::= RESET QUERY CACHE */
  {  247,   -4 }, /* (248) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  310,    0 }, /* (249) analyze_opt ::= */
  {  310,   -1 }, /* (250) analyze_opt ::= ANALYZE */
  {  311,    0 }, /* (251) explain_options ::= */
  {  311,   -3 }, /* (252) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  311,   -3 }, /* (253) explain_options ::= explain_options RATIO NK_FLOAT */
  {  247,   -6 }, /* (254) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  247,  -10 }, /* (255) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  247,   -4 }, /* (256) cmd ::= DROP FUNCTION exists_opt function_name */
  {  312,    0 }, /* (257) agg_func_opt ::= */
  {  312,   -1 }, /* (258) agg_func_opt ::= AGGREGATE */
  {  313,    0 }, /* (259) bufsize_opt ::= */
  {  313,   -2 }, /* (260) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  247,   -8 }, /* (261) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  247,   -4 }, /* (262) cmd ::= DROP STREAM exists_opt stream_name */
  {  315,    0 }, /* (263) into_opt ::= */
  {  315,   -2 }, /* (264) into_opt ::= INTO full_table_name */
  {  306,    0 }, /* (265) stream_options ::= */
  {  306,   -3 }, /* (266) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  306,   -3 }, /* (267) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  306,   -4 }, /* (268) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  306,   -3 }, /* (269) stream_options ::= stream_options WATERMARK duration_literal */
  {  247,   -3 }, /* (270) cmd ::= KILL CONNECTION NK_INTEGER */
  {  247,   -3 }, /* (271) cmd ::= KILL QUERY NK_STRING */
  {  247,   -3 }, /* (272) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  247,   -2 }, /* (273) cmd ::= BALANCE VGROUP */
  {  247,   -4 }, /* (274) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  247,   -4 }, /* (275) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  247,   -3 }, /* (276) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  316,   -2 }, /* (277) dnode_list ::= DNODE NK_INTEGER */
  {  316,   -3 }, /* (278) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  247,   -3 }, /* (279) cmd ::= SYNCDB db_name REPLICA */
  {  247,   -4 }, /* (280) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  247,   -1 }, /* (281) cmd ::= query_expression */
  {  250,   -1 }, /* (282) literal ::= NK_INTEGER */
  {  250,   -1 }, /* (283) literal ::= NK_FLOAT */
  {  250,   -1 }, /* (284) literal ::= NK_STRING */
  {  250,   -1 }, /* (285) literal ::= NK_BOOL */
  {  250,   -2 }, /* (286) literal ::= TIMESTAMP NK_STRING */
  {  250,   -1 }, /* (287) literal ::= duration_literal */
  {  250,   -1 }, /* (288) literal ::= NULL */
  {  250,   -1 }, /* (289) literal ::= NK_QUESTION */
  {  291,   -1 }, /* (290) duration_literal ::= NK_VARIABLE */
  {  318,   -1 }, /* (291) signed ::= NK_INTEGER */
  {  318,   -2 }, /* (292) signed ::= NK_PLUS NK_INTEGER */
  {  318,   -2 }, /* (293) signed ::= NK_MINUS NK_INTEGER */
  {  318,   -1 }, /* (294) signed ::= NK_FLOAT */
  {  318,   -2 }, /* (295) signed ::= NK_PLUS NK_FLOAT */
  {  318,   -2 }, /* (296) signed ::= NK_MINUS NK_FLOAT */
  {  280,   -1 }, /* (297) signed_literal ::= signed */
  {  280,   -1 }, /* (298) signed_literal ::= NK_STRING */
  {  280,   -1 }, /* (299) signed_literal ::= NK_BOOL */
  {  280,   -2 }, /* (300) signed_literal ::= TIMESTAMP NK_STRING */
  {  280,   -1 }, /* (301) signed_literal ::= duration_literal */
  {  280,   -1 }, /* (302) signed_literal ::= NULL */
  {  280,   -1 }, /* (303) signed_literal ::= literal_func */
  {  283,   -1 }, /* (304) literal_list ::= signed_literal */
  {  283,   -3 }, /* (305) literal_list ::= literal_list NK_COMMA signed_literal */
  {  258,   -1 }, /* (306) db_name ::= NK_ID */
  {  286,   -1 }, /* (307) table_name ::= NK_ID */
  {  278,   -1 }, /* (308) column_name ::= NK_ID */
  {  293,   -1 }, /* (309) function_name ::= NK_ID */
  {  320,   -1 }, /* (310) table_alias ::= NK_ID */
  {  321,   -1 }, /* (311) column_alias ::= NK_ID */
  {  252,   -1 }, /* (312) user_name ::= NK_ID */
  {  299,   -1 }, /* (313) index_name ::= NK_ID */
  {  307,   -1 }, /* (314) topic_name ::= NK_ID */
  {  314,   -1 }, /* (315) stream_name ::= NK_ID */
  {  309,   -1 }, /* (316) cgroup_name ::= NK_ID */
  {  322,   -1 }, /* (317) expression ::= literal */
  {  322,   -1 }, /* (318) expression ::= pseudo_column */
  {  322,   -1 }, /* (319) expression ::= column_reference */
  {  322,   -1 }, /* (320) expression ::= function_expression */
  {  322,   -1 }, /* (321) expression ::= subquery */
  {  322,   -3 }, /* (322) expression ::= NK_LP expression NK_RP */
  {  322,   -2 }, /* (323) expression ::= NK_PLUS expression */
  {  322,   -2 }, /* (324) expression ::= NK_MINUS expression */
  {  322,   -3 }, /* (325) expression ::= expression NK_PLUS expression */
  {  322,   -3 }, /* (326) expression ::= expression NK_MINUS expression */
  {  322,   -3 }, /* (327) expression ::= expression NK_STAR expression */
  {  322,   -3 }, /* (328) expression ::= expression NK_SLASH expression */
  {  322,   -3 }, /* (329) expression ::= expression NK_REM expression */
  {  322,   -3 }, /* (330) expression ::= column_reference NK_ARROW NK_STRING */
  {  322,   -3 }, /* (331) expression ::= expression NK_BITAND expression */
  {  322,   -3 }, /* (332) expression ::= expression NK_BITOR expression */
  {  305,   -1 }, /* (333) expression_list ::= expression */
  {  305,   -3 }, /* (334) expression_list ::= expression_list NK_COMMA expression */
  {  324,   -1 }, /* (335) column_reference ::= column_name */
  {  324,   -3 }, /* (336) column_reference ::= table_name NK_DOT column_name */
  {  323,   -1 }, /* (337) pseudo_column ::= ROWTS */
  {  323,   -1 }, /* (338) pseudo_column ::= TBNAME */
  {  323,   -3 }, /* (339) pseudo_column ::= table_name NK_DOT TBNAME */
  {  323,   -1 }, /* (340) pseudo_column ::= QSTARTTS */
  {  323,   -1 }, /* (341) pseudo_column ::= QENDTS */
  {  323,   -1 }, /* (342) pseudo_column ::= WSTARTTS */
  {  323,   -1 }, /* (343) pseudo_column ::= WENDTS */
  {  323,   -1 }, /* (344) pseudo_column ::= WDURATION */
  {  325,   -4 }, /* (345) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  325,   -4 }, /* (346) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  325,   -6 }, /* (347) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  325,   -1 }, /* (348) function_expression ::= literal_func */
  {  319,   -3 }, /* (349) literal_func ::= noarg_func NK_LP NK_RP */
  {  319,   -1 }, /* (350) literal_func ::= NOW */
  {  329,   -1 }, /* (351) noarg_func ::= NOW */
  {  329,   -1 }, /* (352) noarg_func ::= TODAY */
  {  329,   -1 }, /* (353) noarg_func ::= TIMEZONE */
  {  327,   -1 }, /* (354) star_func ::= COUNT */
  {  327,   -1 }, /* (355) star_func ::= FIRST */
  {  327,   -1 }, /* (356) star_func ::= LAST */
  {  327,   -1 }, /* (357) star_func ::= LAST_ROW */
  {  328,   -1 }, /* (358) star_func_para_list ::= NK_STAR */
  {  328,   -1 }, /* (359) star_func_para_list ::= other_para_list */
  {  330,   -1 }, /* (360) other_para_list ::= star_func_para */
  {  330,   -3 }, /* (361) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  331,   -1 }, /* (362) star_func_para ::= expression */
  {  331,   -3 }, /* (363) star_func_para ::= table_name NK_DOT NK_STAR */
  {  332,   -3 }, /* (364) predicate ::= expression compare_op expression */
  {  332,   -5 }, /* (365) predicate ::= expression BETWEEN expression AND expression */
  {  332,   -6 }, /* (366) predicate ::= expression NOT BETWEEN expression AND expression */
  {  332,   -3 }, /* (367) predicate ::= expression IS NULL */
  {  332,   -4 }, /* (368) predicate ::= expression IS NOT NULL */
  {  332,   -3 }, /* (369) predicate ::= expression in_op in_predicate_value */
  {  333,   -1 }, /* (370) compare_op ::= NK_LT */
  {  333,   -1 }, /* (371) compare_op ::= NK_GT */
  {  333,   -1 }, /* (372) compare_op ::= NK_LE */
  {  333,   -1 }, /* (373) compare_op ::= NK_GE */
  {  333,   -1 }, /* (374) compare_op ::= NK_NE */
  {  333,   -1 }, /* (375) compare_op ::= NK_EQ */
  {  333,   -1 }, /* (376) compare_op ::= LIKE */
  {  333,   -2 }, /* (377) compare_op ::= NOT LIKE */
  {  333,   -1 }, /* (378) compare_op ::= MATCH */
  {  333,   -1 }, /* (379) compare_op ::= NMATCH */
  {  333,   -1 }, /* (380) compare_op ::= CONTAINS */
  {  334,   -1 }, /* (381) in_op ::= IN */
  {  334,   -2 }, /* (382) in_op ::= NOT IN */
  {  335,   -3 }, /* (383) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  336,   -1 }, /* (384) boolean_value_expression ::= boolean_primary */
  {  336,   -2 }, /* (385) boolean_value_expression ::= NOT boolean_primary */
  {  336,   -3 }, /* (386) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  336,   -3 }, /* (387) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  337,   -1 }, /* (388) boolean_primary ::= predicate */
  {  337,   -3 }, /* (389) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  338,   -1 }, /* (390) common_expression ::= expression */
  {  338,   -1 }, /* (391) common_expression ::= boolean_value_expression */
  {  339,    0 }, /* (392) from_clause_opt ::= */
  {  339,   -2 }, /* (393) from_clause_opt ::= FROM table_reference_list */
  {  340,   -1 }, /* (394) table_reference_list ::= table_reference */
  {  340,   -3 }, /* (395) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  341,   -1 }, /* (396) table_reference ::= table_primary */
  {  341,   -1 }, /* (397) table_reference ::= joined_table */
  {  342,   -2 }, /* (398) table_primary ::= table_name alias_opt */
  {  342,   -4 }, /* (399) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  342,   -2 }, /* (400) table_primary ::= subquery alias_opt */
  {  342,   -1 }, /* (401) table_primary ::= parenthesized_joined_table */
  {  344,    0 }, /* (402) alias_opt ::= */
  {  344,   -1 }, /* (403) alias_opt ::= table_alias */
  {  344,   -2 }, /* (404) alias_opt ::= AS table_alias */
  {  345,   -3 }, /* (405) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  345,   -3 }, /* (406) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  343,   -6 }, /* (407) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  346,    0 }, /* (408) join_type ::= */
  {  346,   -1 }, /* (409) join_type ::= INNER */
  {  348,  -12 }, /* (410) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  349,    0 }, /* (411) set_quantifier_opt ::= */
  {  349,   -1 }, /* (412) set_quantifier_opt ::= DISTINCT */
  {  349,   -1 }, /* (413) set_quantifier_opt ::= ALL */
  {  350,   -1 }, /* (414) select_list ::= NK_STAR */
  {  350,   -1 }, /* (415) select_list ::= select_sublist */
  {  358,   -1 }, /* (416) select_sublist ::= select_item */
  {  358,   -3 }, /* (417) select_sublist ::= select_sublist NK_COMMA select_item */
  {  359,   -1 }, /* (418) select_item ::= common_expression */
  {  359,   -2 }, /* (419) select_item ::= common_expression column_alias */
  {  359,   -3 }, /* (420) select_item ::= common_expression AS column_alias */
  {  359,   -3 }, /* (421) select_item ::= table_name NK_DOT NK_STAR */
  {  317,    0 }, /* (422) where_clause_opt ::= */
  {  317,   -2 }, /* (423) where_clause_opt ::= WHERE search_condition */
  {  351,    0 }, /* (424) partition_by_clause_opt ::= */
  {  351,   -3 }, /* (425) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  355,    0 }, /* (426) twindow_clause_opt ::= */
  {  355,   -6 }, /* (427) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  355,   -4 }, /* (428) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  355,   -6 }, /* (429) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  355,   -8 }, /* (430) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  302,    0 }, /* (431) sliding_opt ::= */
  {  302,   -4 }, /* (432) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  354,    0 }, /* (433) fill_opt ::= */
  {  354,   -4 }, /* (434) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  354,   -6 }, /* (435) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  360,   -1 }, /* (436) fill_mode ::= NONE */
  {  360,   -1 }, /* (437) fill_mode ::= PREV */
  {  360,   -1 }, /* (438) fill_mode ::= NULL */
  {  360,   -1 }, /* (439) fill_mode ::= LINEAR */
  {  360,   -1 }, /* (440) fill_mode ::= NEXT */
  {  356,    0 }, /* (441) group_by_clause_opt ::= */
  {  356,   -3 }, /* (442) group_by_clause_opt ::= GROUP BY group_by_list */
  {  361,   -1 }, /* (443) group_by_list ::= expression */
  {  361,   -3 }, /* (444) group_by_list ::= group_by_list NK_COMMA expression */
  {  357,    0 }, /* (445) having_clause_opt ::= */
  {  357,   -2 }, /* (446) having_clause_opt ::= HAVING search_condition */
  {  352,    0 }, /* (447) range_opt ::= */
  {  352,   -6 }, /* (448) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  353,    0 }, /* (449) every_opt ::= */
  {  353,   -4 }, /* (450) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  308,   -4 }, /* (451) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  362,   -1 }, /* (452) query_expression_body ::= query_primary */
  {  362,   -4 }, /* (453) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  362,   -3 }, /* (454) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  366,   -1 }, /* (455) query_primary ::= query_specification */
  {  366,   -6 }, /* (456) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  363,    0 }, /* (457) order_by_clause_opt ::= */
  {  363,   -3 }, /* (458) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  364,    0 }, /* (459) slimit_clause_opt ::= */
  {  364,   -2 }, /* (460) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  364,   -4 }, /* (461) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  364,   -4 }, /* (462) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  365,    0 }, /* (463) limit_clause_opt ::= */
  {  365,   -2 }, /* (464) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  365,   -4 }, /* (465) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  365,   -4 }, /* (466) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  326,   -3 }, /* (467) subquery ::= NK_LP query_expression NK_RP */
  {  347,   -1 }, /* (468) search_condition ::= common_expression */
  {  367,   -1 }, /* (469) sort_specification_list ::= sort_specification */
  {  367,   -3 }, /* (470) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  368,   -3 }, /* (471) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  369,    0 }, /* (472) ordering_specification_opt ::= */
  {  369,   -1 }, /* (473) ordering_specification_opt ::= ASC */
  {  369,   -1 }, /* (474) ordering_specification_opt ::= DESC */
  {  370,    0 }, /* (475) null_ordering_opt ::= */
  {  370,   -2 }, /* (476) null_ordering_opt ::= NULLS FIRST */
  {  370,   -2 }, /* (477) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,248,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,249,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,248,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,250,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,251,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,249,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,251,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,250,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy729, &yymsp[-1].minor.yy0, yymsp[0].minor.yy439); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy729, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy729, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy729, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy729); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy439 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy439 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy179, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy729); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy179, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy729); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy179 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy179 = yymsp[0].minor.yy179; }
  yymsp[0].minor.yy179 = yylhsminor.yy179;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy179 = yymsp[-2].minor.yy179 | yymsp[0].minor.yy179; }
  yymsp[-2].minor.yy179 = yylhsminor.yy179;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy179 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy179 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy729 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy729 = yylhsminor.yy729;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy729 = yymsp[-2].minor.yy729; }
  yymsp[-2].minor.yy729 = yylhsminor.yy729;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy729, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy729); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 306: /* db_name ::= NK_ID */ yytestcase(yyruleno==306);
      case 307: /* table_name ::= NK_ID */ yytestcase(yyruleno==307);
      case 308: /* column_name ::= NK_ID */ yytestcase(yyruleno==308);
      case 309: /* function_name ::= NK_ID */ yytestcase(yyruleno==309);
      case 310: /* table_alias ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* column_alias ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* user_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* index_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* topic_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* stream_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 351: /* noarg_func ::= NOW */ yytestcase(yyruleno==351);
      case 352: /* noarg_func ::= TODAY */ yytestcase(yyruleno==352);
      case 353: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==353);
      case 354: /* star_func ::= COUNT */ yytestcase(yyruleno==354);
      case 355: /* star_func ::= FIRST */ yytestcase(yyruleno==355);
      case 356: /* star_func ::= LAST */ yytestcase(yyruleno==356);
      case 357: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==357);
{ yylhsminor.yy729 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy729 = yylhsminor.yy729;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy215, &yymsp[-1].minor.yy729, yymsp[0].minor.yy714); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy215, &yymsp[0].minor.yy729); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy729); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy729, yymsp[0].minor.yy714); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy729); }
        break;
      case 67: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy215 = true; }
        break;
      case 68: /* not_exists_opt ::= */
      case 70: /* exists_opt ::= */ yytestcase(yyruleno==70);
      case 249: /* analyze_opt ::= */ yytestcase(yyruleno==249);
      case 257: /* agg_func_opt ::= */ yytestcase(yyruleno==257);
      case 411: /* set_quantifier_opt ::= */ yytestcase(yyruleno==411);
{ yymsp[1].minor.yy215 = false; }
        break;
      case 69: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy215 = true; }
        break;
      case 71: /* db_options ::= */
{ yymsp[1].minor.yy714 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 72: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 73: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 74: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 75: /* db_options ::= db_options DURATION NK_INTEGER */
      case 76: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==76);
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 77: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 78: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 79: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 80: /* db_options ::= db_options KEEP integer_list */
      case 81: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==81);
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_KEEP, yymsp[0].minor.yy656); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 82: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 83: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 84: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 85: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 86: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 87: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_RETENTIONS, yymsp[0].minor.yy656); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy714 = setDatabaseOption(pCxt, yymsp[-2].minor.yy714, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 92: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy714 = createAlterDatabaseOptions(pCxt); yylhsminor.yy714 = setAlterDatabaseOption(pCxt, yylhsminor.yy714, &yymsp[0].minor.yy81); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 93: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy714 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy714, &yymsp[0].minor.yy81); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 94: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy81.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy81.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy81.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= KEEP integer_list */
      case 98: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==98);
{ yymsp[-1].minor.yy81.type = DB_OPTION_KEEP; yymsp[-1].minor.yy81.pList = yymsp[0].minor.yy656; }
        break;
      case 99: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy81.type = DB_OPTION_PAGES; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy81.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 101: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy81.type = DB_OPTION_STRICT; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy81.type = DB_OPTION_WAL; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy656 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy656 = yylhsminor.yy656;
        break;
      case 104: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 278: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==278);
{ yylhsminor.yy656 = addNodeToList(pCxt, yymsp[-2].minor.yy656, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy656 = yylhsminor.yy656;
        break;
      case 105: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy656 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy656 = yylhsminor.yy656;
        break;
      case 106: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy656 = addNodeToList(pCxt, yymsp[-2].minor.yy656, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy656 = yylhsminor.yy656;
        break;
      case 107: /* retention_list ::= retention */
      case 127: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==127);
      case 130: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==130);
      case 137: /* column_def_list ::= column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name */ yytestcase(yyruleno==185);
      case 232: /* func_list ::= func */ yytestcase(yyruleno==232);
      case 304: /* literal_list ::= signed_literal */ yytestcase(yyruleno==304);
      case 360: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==360);
      case 416: /* select_sublist ::= select_item */ yytestcase(yyruleno==416);
      case 469: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==469);
{ yylhsminor.yy656 = createNodeList(pCxt, yymsp[0].minor.yy714); }
  yymsp[0].minor.yy656 = yylhsminor.yy656;
        break;
      case 108: /* retention_list ::= retention_list NK_COMMA retention */
      case 138: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==138);
      case 181: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==181);
      case 186: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==186);
      case 233: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==233);
      case 305: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==305);
      case 361: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==361);
      case 417: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==417);
      case 470: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==470);
{ yylhsminor.yy656 = addNodeToList(pCxt, yymsp[-2].minor.yy656, yymsp[0].minor.yy714); }
  yymsp[-2].minor.yy656 = yylhsminor.yy656;
        break;
      case 109: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy714 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 110: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 112: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==112);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy215, yymsp[-5].minor.yy714, yymsp[-3].minor.yy656, yymsp[-1].minor.yy656, yymsp[0].minor.yy714); }
        break;
      case 111: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy656); }
        break;
      case 113: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy656); }
        break;
      case 114: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy215, yymsp[0].minor.yy714); }
        break;
      case 115: /* cmd ::= ALTER TABLE alter_table_clause */
      case 116: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==116);
      case 281: /* cmd ::= query_expression */ yytestcase(yyruleno==281);
{ pCxt->pRootNode = yymsp[0].minor.yy714; }
        break;
      case 117: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy714 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy714, yymsp[0].minor.yy714); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy714 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy714, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy729, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy714 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy714, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy729); }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy714 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy714, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy729, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy714 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy714, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy729, &yymsp[0].minor.yy729); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 122: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy714 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy714, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy729, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 123: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy714 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy714, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy729); }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 124: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy714 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy714, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy729, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 125: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy714 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy714, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy729, &yymsp[0].minor.yy729); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 126: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy714 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy714, &yymsp[-2].minor.yy729, yymsp[0].minor.yy714); }
  yymsp[-5].minor.yy714 = yylhsminor.yy714;
        break;
      case 128: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 131: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==131);
{ yylhsminor.yy656 = addNodeToList(pCxt, yymsp[-1].minor.yy656, yymsp[0].minor.yy714); }
  yymsp[-1].minor.yy656 = yylhsminor.yy656;
        break;
      case 129: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy714 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy215, yymsp[-8].minor.yy714, yymsp[-6].minor.yy714, yymsp[-5].minor.yy656, yymsp[-2].minor.yy656, yymsp[0].minor.yy714); }
  yymsp[-9].minor.yy714 = yylhsminor.yy714;
        break;
      case 132: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy714 = createDropTableClause(pCxt, yymsp[-1].minor.yy215, yymsp[0].minor.yy714); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 133: /* specific_tags_opt ::= */
      case 164: /* tags_def_opt ::= */ yytestcase(yyruleno==164);
      case 424: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==424);
      case 441: /* group_by_clause_opt ::= */ yytestcase(yyruleno==441);
      case 457: /* order_by_clause_opt ::= */ yytestcase(yyruleno==457);
{ yymsp[1].minor.yy656 = NULL; }
        break;
      case 134: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy656 = yymsp[-1].minor.yy656; }
        break;
      case 135: /* full_table_name ::= table_name */
{ yylhsminor.yy714 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy729, NULL); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 136: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy714 = createRealTableNode(pCxt, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy729, NULL); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 139: /* column_def ::= column_name type_name */
{ yylhsminor.yy714 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy729, yymsp[0].minor.yy490, NULL); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 140: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy714 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy729, yymsp[-2].minor.yy490, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 141: /* type_name ::= BOOL */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 142: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 143: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 144: /* type_name ::= INT */
      case 145: /* type_name ::= INTEGER */ yytestcase(yyruleno==145);
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 146: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 147: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 148: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 149: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 150: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 151: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 152: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 153: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 154: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 155: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 156: /* type_name ::= JSON */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 157: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 158: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 159: /* type_name ::= BLOB */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 160: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 161: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 163: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy490 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 165: /* tags_def_opt ::= tags_def */
      case 359: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==359);
      case 415: /* select_list ::= select_sublist */ yytestcase(yyruleno==415);
{ yylhsminor.yy656 = yymsp[0].minor.yy656; }
  yymsp[0].minor.yy656 = yylhsminor.yy656;
        break;
      case 166: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy656 = yymsp[-1].minor.yy656; }
        break;
      case 167: /* table_options ::= */
{ yymsp[1].minor.yy714 = createDefaultTableOptions(pCxt); }
        break;
      case 168: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy714 = setTableOption(pCxt, yymsp[-2].minor.yy714, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 169: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy714 = setTableOption(pCxt, yymsp[-2].minor.yy714, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy656); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 170: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy714 = setTableOption(pCxt, yymsp[-2].minor.yy714, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy656); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 171: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy714 = setTableOption(pCxt, yymsp[-4].minor.yy714, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy656); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 172: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy714 = setTableOption(pCxt, yymsp[-2].minor.yy714, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 173: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy714 = setTableOption(pCxt, yymsp[-4].minor.yy714, TABLE_OPTION_SMA, yymsp[-1].minor.yy656); }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 174: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy714 = createAlterTableOptions(pCxt); yylhsminor.yy714 = setTableOption(pCxt, yylhsminor.yy714, yymsp[0].minor.yy81.type, &yymsp[0].minor.yy81.val); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 175: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy714 = setTableOption(pCxt, yymsp[-1].minor.yy714, yymsp[0].minor.yy81.type, &yymsp[0].minor.yy81.val); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 176: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy81.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy81.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy81.val = yymsp[0].minor.yy0; }
        break;
      case 178: /* duration_list ::= duration_literal */
      case 333: /* expression_list ::= expression */ yytestcase(yyruleno==333);
{ yylhsminor.yy656 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy714)); }
  yymsp[0].minor.yy656 = yylhsminor.yy656;
        break;
      case 179: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 334: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==334);
{ yylhsminor.yy656 = addNodeToList(pCxt, yymsp[-2].minor.yy656, releaseRawExprNode(pCxt, yymsp[0].minor.yy714)); }
  yymsp[-2].minor.yy656 = yylhsminor.yy656;
        break;
      case 182: /* rollup_func_name ::= function_name */
{ yylhsminor.yy714 = createFunctionNode(pCxt, &yymsp[0].minor.yy729, NULL); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 183: /* rollup_func_name ::= FIRST */
      case 184: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==184);
{ yylhsminor.yy714 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 187: /* col_name ::= column_name */
{ yylhsminor.yy714 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy729); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 188: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 189: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 190: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy714, yymsp[0].minor.yy714, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy714, yymsp[0].minor.yy714, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy714, NULL, OP_TYPE_LIKE); }
        break;
      case 194: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 195: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 196: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 197: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 198: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy714, yymsp[-1].minor.yy714, OP_TYPE_EQUAL); }
        break;
      case 199: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 200: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 201: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 202: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 203: /* cmd ::= SHOW LICENCE */
      case 204: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==204);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 205: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy729); }
        break;
      case 206: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy714); }
        break;
      case 207: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy714); }
        break;
      case 208: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 209: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 210: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 211: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 213: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 214: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 217: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy714); }
        break;
      case 219: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 220: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 221: /* db_name_cond_opt ::= */
      case 226: /* from_db_opt ::= */ yytestcase(yyruleno==226);
{ yymsp[1].minor.yy714 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 222: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy729); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 223: /* like_pattern_opt ::= */
      case 263: /* into_opt ::= */ yytestcase(yyruleno==263);
      case 392: /* from_clause_opt ::= */ yytestcase(yyruleno==392);
      case 422: /* where_clause_opt ::= */ yytestcase(yyruleno==422);
      case 426: /* twindow_clause_opt ::= */ yytestcase(yyruleno==426);
      case 431: /* sliding_opt ::= */ yytestcase(yyruleno==431);
      case 433: /* fill_opt ::= */ yytestcase(yyruleno==433);
      case 445: /* having_clause_opt ::= */ yytestcase(yyruleno==445);
      case 447: /* range_opt ::= */ yytestcase(yyruleno==447);
      case 449: /* every_opt ::= */ yytestcase(yyruleno==449);
      case 459: /* slimit_clause_opt ::= */ yytestcase(yyruleno==459);
      case 463: /* limit_clause_opt ::= */ yytestcase(yyruleno==463);
{ yymsp[1].minor.yy714 = NULL; }
        break;
      case 224: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 225: /* table_name_cond ::= table_name */
{ yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy729); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 227: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy729); }
        break;
      case 228: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy215, &yymsp[-3].minor.yy729, &yymsp[-1].minor.yy729, NULL, yymsp[0].minor.yy714); }
        break;
      case 229: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy215, &yymsp[0].minor.yy729); }
        break;
      case 230: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy714 = createIndexOption(pCxt, yymsp[-7].minor.yy656, releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), NULL, yymsp[-1].minor.yy714, yymsp[0].minor.yy714); }
        break;
      case 231: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy714 = createIndexOption(pCxt, yymsp[-9].minor.yy656, releaseRawExprNode(pCxt, yymsp[-5].minor.yy714), releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), yymsp[-1].minor.yy714, yymsp[0].minor.yy714); }
        break;
      case 234: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy714 = createFunctionNode(pCxt, &yymsp[-3].minor.yy729, yymsp[-1].minor.yy656); }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 235: /* sma_stream_opt ::= */
      case 265: /* stream_options ::= */ yytestcase(yyruleno==265);
{ yymsp[1].minor.yy714 = createStreamOptions(pCxt); }
        break;
      case 236: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 269: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==269);
{ ((SStreamOptions*)yymsp[-2].minor.yy714)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy714); yylhsminor.yy714 = yymsp[-2].minor.yy714; }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 237: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy714)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy714); yylhsminor.yy714 = yymsp[-2].minor.yy714; }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 238: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy215, &yymsp[-2].minor.yy729, yymsp[0].minor.yy714); }
        break;
      case 239: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy215, &yymsp[-3].minor.yy729, &yymsp[0].minor.yy729, false); }
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy215, &yymsp[-5].minor.yy729, &yymsp[0].minor.yy729, true); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy215, &yymsp[-3].minor.yy729, yymsp[0].minor.yy714, false); }
        break;
      case 242: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy215, &yymsp[-5].minor.yy729, yymsp[0].minor.yy714, true); }
        break;
      case 243: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy215, &yymsp[0].minor.yy729); }
        break;
      case 244: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy215, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy729); }
        break;
      case 245: /* cmd ::= DESC full_table_name */
      case 246: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==246);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy714); }
        break;
      case 247: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 248: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy215, yymsp[-1].minor.yy714, yymsp[0].minor.yy714); }
        break;
      case 250: /* analyze_opt ::= ANALYZE */
      case 258: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==258);
      case 412: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==412);
{ yymsp[0].minor.yy215 = true; }
        break;
      case 251: /* explain_options ::= */
{ yymsp[1].minor.yy714 = createDefaultExplainOptions(pCxt); }
        break;
      case 252: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy714 = setExplainVerbose(pCxt, yymsp[-2].minor.yy714, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 253: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy714 = setExplainRatio(pCxt, yymsp[-2].minor.yy714, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 254: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy656); }
        break;
      case 255: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy215, yymsp[-8].minor.yy215, &yymsp[-5].minor.yy729, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy490, yymsp[0].minor.yy550); }
        break;
      case 256: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy215, &yymsp[0].minor.yy729); }
        break;
      case 259: /* bufsize_opt ::= */
{ yymsp[1].minor.yy550 = 0; }
        break;
      case 260: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy550 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 261: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy215, &yymsp[-4].minor.yy729, yymsp[-2].minor.yy714, yymsp[-3].minor.yy714, yymsp[0].minor.yy714); }
        break;
      case 262: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy215, &yymsp[0].minor.yy729); }
        break;
      case 264: /* into_opt ::= INTO full_table_name */
      case 393: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==393);
      case 423: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==423);
      case 446: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==446);
{ yymsp[-1].minor.yy714 = yymsp[0].minor.yy714; }
        break;
      case 266: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy714)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy714 = yymsp[-2].minor.yy714; }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 267: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy714)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy714 = yymsp[-2].minor.yy714; }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 268: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy714)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy714)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy714); yylhsminor.yy714 = yymsp[-3].minor.yy714; }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 270: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 271: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 272: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 273: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 274: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 275: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy656); }
        break;
      case 276: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 277: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy656 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 279: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy729); }
        break;
      case 280: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy714, yymsp[0].minor.yy714); }
        break;
      case 282: /* literal ::= NK_INTEGER */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 283: /* literal ::= NK_FLOAT */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 284: /* literal ::= NK_STRING */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 285: /* literal ::= NK_BOOL */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 286: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 287: /* literal ::= duration_literal */
      case 297: /* signed_literal ::= signed */ yytestcase(yyruleno==297);
      case 317: /* expression ::= literal */ yytestcase(yyruleno==317);
      case 318: /* expression ::= pseudo_column */ yytestcase(yyruleno==318);
      case 319: /* expression ::= column_reference */ yytestcase(yyruleno==319);
      case 320: /* expression ::= function_expression */ yytestcase(yyruleno==320);
      case 321: /* expression ::= subquery */ yytestcase(yyruleno==321);
      case 348: /* function_expression ::= literal_func */ yytestcase(yyruleno==348);
      case 384: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==384);
      case 388: /* boolean_primary ::= predicate */ yytestcase(yyruleno==388);
      case 390: /* common_expression ::= expression */ yytestcase(yyruleno==390);
      case 391: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==391);
      case 394: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==394);
      case 396: /* table_reference ::= table_primary */ yytestcase(yyruleno==396);
      case 397: /* table_reference ::= joined_table */ yytestcase(yyruleno==397);
      case 401: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==401);
      case 452: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==452);
      case 455: /* query_primary ::= query_specification */ yytestcase(yyruleno==455);
{ yylhsminor.yy714 = yymsp[0].minor.yy714; }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 288: /* literal ::= NULL */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 289: /* literal ::= NK_QUESTION */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 290: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 291: /* signed ::= NK_INTEGER */
{ yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 292: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 293: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 294: /* signed ::= NK_FLOAT */
{ yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 295: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 296: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 298: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 299: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 300: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 301: /* signed_literal ::= duration_literal */
      case 303: /* signed_literal ::= literal_func */ yytestcase(yyruleno==303);
      case 362: /* star_func_para ::= expression */ yytestcase(yyruleno==362);
      case 418: /* select_item ::= common_expression */ yytestcase(yyruleno==418);
      case 468: /* search_condition ::= common_expression */ yytestcase(yyruleno==468);
{ yylhsminor.yy714 = releaseRawExprNode(pCxt, yymsp[0].minor.yy714); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 302: /* signed_literal ::= NULL */
{ yylhsminor.yy714 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 322: /* expression ::= NK_LP expression NK_RP */
      case 389: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==389);
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy714)); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 323: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy714));
                                                                                  }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 324: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy714), NULL));
                                                                                  }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 325: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714))); 
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 326: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714))); 
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 327: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714))); 
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 328: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714))); 
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 329: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 330: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 331: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 332: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 335: /* column_reference ::= column_name */
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy729, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy729)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 336: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy729, createColumnNode(pCxt, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy729)); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 337: /* pseudo_column ::= ROWTS */
      case 338: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==338);
      case 340: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==340);
      case 341: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==341);
      case 342: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==342);
      case 343: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==343);
      case 344: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==344);
      case 350: /* literal_func ::= NOW */ yytestcase(yyruleno==350);
{ yylhsminor.yy714 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy714 = yylhsminor.yy714;
        break;
      case 339: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy729)))); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 345: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 346: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==346);
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy729, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy729, yymsp[-1].minor.yy656)); }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 347: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), yymsp[-1].minor.yy490)); }
  yymsp[-5].minor.yy714 = yylhsminor.yy714;
        break;
      case 349: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy729, NULL)); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 358: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy656 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy656 = yylhsminor.yy656;
        break;
      case 363: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 421: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==421);
{ yylhsminor.yy714 = createColumnNode(pCxt, &yymsp[-2].minor.yy729, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 364: /* predicate ::= expression compare_op expression */
      case 369: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==369);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy688, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 365: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy714), releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-4].minor.yy714 = yylhsminor.yy714;
        break;
      case 366: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy714), releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-5].minor.yy714 = yylhsminor.yy714;
        break;
      case 367: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), NULL));
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 368: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), NULL));
                                                                                  }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 370: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy688 = OP_TYPE_LOWER_THAN; }
        break;
      case 371: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy688 = OP_TYPE_GREATER_THAN; }
        break;
      case 372: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy688 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 373: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy688 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 374: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy688 = OP_TYPE_NOT_EQUAL; }
        break;
      case 375: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy688 = OP_TYPE_EQUAL; }
        break;
      case 376: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy688 = OP_TYPE_LIKE; }
        break;
      case 377: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy688 = OP_TYPE_NOT_LIKE; }
        break;
      case 378: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy688 = OP_TYPE_MATCH; }
        break;
      case 379: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy688 = OP_TYPE_NMATCH; }
        break;
      case 380: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy688 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 381: /* in_op ::= IN */
{ yymsp[0].minor.yy688 = OP_TYPE_IN; }
        break;
      case 382: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy688 = OP_TYPE_NOT_IN; }
        break;
      case 383: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy656)); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 385: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy714), NULL));
                                                                                  }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 386: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 387: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy714);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy714);
                                                                                    yylhsminor.yy714 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), releaseRawExprNode(pCxt, yymsp[0].minor.yy714)));
                                                                                  }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 395: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy714 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy714, yymsp[0].minor.yy714, NULL); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 398: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy714 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy729, &yymsp[0].minor.yy729); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 399: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy714 = createRealTableNode(pCxt, &yymsp[-3].minor.yy729, &yymsp[-1].minor.yy729, &yymsp[0].minor.yy729); }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 400: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy714 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy714), &yymsp[0].minor.yy729); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 402: /* alias_opt ::= */
{ yymsp[1].minor.yy729 = nil_token;  }
        break;
      case 403: /* alias_opt ::= table_alias */
{ yylhsminor.yy729 = yymsp[0].minor.yy729; }
  yymsp[0].minor.yy729 = yylhsminor.yy729;
        break;
      case 404: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy729 = yymsp[0].minor.yy729; }
        break;
      case 405: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 406: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==406);
{ yymsp[-2].minor.yy714 = yymsp[-1].minor.yy714; }
        break;
      case 407: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy714 = createJoinTableNode(pCxt, yymsp[-4].minor.yy568, yymsp[-5].minor.yy714, yymsp[-2].minor.yy714, yymsp[0].minor.yy714); }
  yymsp[-5].minor.yy714 = yylhsminor.yy714;
        break;
      case 408: /* join_type ::= */
{ yymsp[1].minor.yy568 = JOIN_TYPE_INNER; }
        break;
      case 409: /* join_type ::= INNER */
{ yymsp[0].minor.yy568 = JOIN_TYPE_INNER; }
        break;
      case 410: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy714 = createSelectStmt(pCxt, yymsp[-10].minor.yy215, yymsp[-9].minor.yy656, yymsp[-8].minor.yy714);
                                                                                    yymsp[-11].minor.yy714 = addWhereClause(pCxt, yymsp[-11].minor.yy714, yymsp[-7].minor.yy714);
                                                                                    yymsp[-11].minor.yy714 = addPartitionByClause(pCxt, yymsp[-11].minor.yy714, yymsp[-6].minor.yy656);
                                                                                    yymsp[-11].minor.yy714 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy714, yymsp[-2].minor.yy714);
                                                                                    yymsp[-11].minor.yy714 = addGroupByClause(pCxt, yymsp[-11].minor.yy714, yymsp[-1].minor.yy656);
                                                                                    yymsp[-11].minor.yy714 = addHavingClause(pCxt, yymsp[-11].minor.yy714, yymsp[0].minor.yy714);
                                                                                    yymsp[-11].minor.yy714 = addRangeClause(pCxt, yymsp[-11].minor.yy714, yymsp[-5].minor.yy714);
                                                                                    yymsp[-11].minor.yy714 = addEveryClause(pCxt, yymsp[-11].minor.yy714, yymsp[-4].minor.yy714);
                                                                                    yymsp[-11].minor.yy714 = addFillClause(pCxt, yymsp[-11].minor.yy714, yymsp[-3].minor.yy714);
                                                                                  }
        break;
      case 413: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy215 = false; }
        break;
      case 414: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy656 = NULL; }
        break;
      case 419: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy714 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy714), &yymsp[0].minor.yy729); }
  yymsp[-1].minor.yy714 = yylhsminor.yy714;
        break;
      case 420: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy714 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), &yymsp[0].minor.yy729); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 425: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 442: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==442);
      case 458: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==458);
{ yymsp[-2].minor.yy656 = yymsp[0].minor.yy656; }
        break;
      case 427: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy714 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), releaseRawExprNode(pCxt, yymsp[-1].minor.yy714)); }
        break;
      case 428: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy714 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy714)); }
        break;
      case 429: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy714 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), NULL, yymsp[-1].minor.yy714, yymsp[0].minor.yy714); }
        break;
      case 430: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy714 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy714), releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), yymsp[-1].minor.yy714, yymsp[0].minor.yy714); }
        break;
      case 432: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 450: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==450);
{ yymsp[-3].minor.yy714 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy714); }
        break;
      case 434: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy714 = createFillNode(pCxt, yymsp[-1].minor.yy256, NULL); }
        break;
      case 435: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy714 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy656)); }
        break;
      case 436: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy256 = FILL_MODE_NONE; }
        break;
      case 437: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy256 = FILL_MODE_PREV; }
        break;
      case 438: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy256 = FILL_MODE_NULL; }
        break;
      case 439: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy256 = FILL_MODE_LINEAR; }
        break;
      case 440: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy256 = FILL_MODE_NEXT; }
        break;
      case 443: /* group_by_list ::= expression */
{ yylhsminor.yy656 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy714))); }
  yymsp[0].minor.yy656 = yylhsminor.yy656;
        break;
      case 444: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy656 = addNodeToList(pCxt, yymsp[-2].minor.yy656, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy714))); }
  yymsp[-2].minor.yy656 = yylhsminor.yy656;
        break;
      case 448: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy714 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy714), releaseRawExprNode(pCxt, yymsp[-1].minor.yy714)); }
        break;
      case 451: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy714 = addOrderByClause(pCxt, yymsp[-3].minor.yy714, yymsp[-2].minor.yy656);
                                                                                    yylhsminor.yy714 = addSlimitClause(pCxt, yylhsminor.yy714, yymsp[-1].minor.yy714);
                                                                                    yylhsminor.yy714 = addLimitClause(pCxt, yylhsminor.yy714, yymsp[0].minor.yy714);
                                                                                  }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 453: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy714 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy714, yymsp[0].minor.yy714); }
  yymsp[-3].minor.yy714 = yylhsminor.yy714;
        break;
      case 454: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy714 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy714, yymsp[0].minor.yy714); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 456: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy714 = yymsp[-4].minor.yy714; }
  yy_destructor(yypParser,363,&yymsp[-3].minor);
  yy_destructor(yypParser,364,&yymsp[-2].minor);
  yy_destructor(yypParser,365,&yymsp[-1].minor);
        break;
      case 460: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 464: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==464);
{ yymsp[-1].minor.yy714 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 461: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 465: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==465);
{ yymsp[-3].minor.yy714 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 462: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 466: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==466);
{ yymsp[-3].minor.yy714 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 467: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy714 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy714); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 471: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy714 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy714), yymsp[-1].minor.yy372, yymsp[0].minor.yy193); }
  yymsp[-2].minor.yy714 = yylhsminor.yy714;
        break;
      case 472: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy372 = ORDER_ASC; }
        break;
      case 473: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy372 = ORDER_ASC; }
        break;
      case 474: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy372 = ORDER_DESC; }
        break;
      case 475: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy193 = NULL_ORDER_DEFAULT; }
        break;
      case 476: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy193 = NULL_ORDER_FIRST; }
        break;
      case 477: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy193 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
