/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 459
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy20;
  SNode* yy74;
  ENullOrder yy109;
  SToken yy317;
  EOrder yy326;
  bool yy335;
  int8_t yy449;
  int64_t yy531;
  EJoinType yy630;
  SAlterOption yy767;
  EFillMode yy828;
  int32_t yy856;
  SNodeList* yy874;
  SDataType yy898;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             711
#define YYNRULE              541
#define YYNTOKEN             322
#define YY_MAX_SHIFT         710
#define YY_MIN_SHIFTREDUCE   1054
#define YY_MAX_SHIFTREDUCE   1594
#define YY_ERROR_ACTION      1595
#define YY_ACCEPT_ACTION     1596
#define YY_NO_ACTION         1597
#define YY_MIN_REDUCE        1598
#define YY_MAX_REDUCE        2138
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2723)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   459,  353,  460, 1634,  566,  600,  578, 2114, 2109,  155,
 /*    10 */  1940, 2109,   43,   41, 1525,   39,   38,   37, 1753,  123,
 /*    20 */   361, 1936, 1375,  565,  173,  599,  498, 2113, 2110,  567,
 /*    30 */  1954, 2110, 2112, 1455, 1400, 1373, 1751,  131,  468,  406,
 /*    40 */   460, 1634,   36,   35, 1940,  586,   42,   40,   39,   38,
 /*    50 */    37, 1932, 1938,  344,  541, 1936,  167,  578, 1450,  465,
 /*    60 */   585, 1972,  610,   16,  366,  461, 1804, 1797, 1799,  581,
 /*    70 */  1381,  599, 1401,  330, 1922,  158,  616,  333, 1851,  319,
 /*    80 */  1705, 1972, 1802,   43,   41, 1932, 1938,  356,  131,  560,
 /*    90 */   477,  361,  475, 1375, 1860,   12,  610,  326,  172, 2049,
 /*   100 */  2050, 1953,  129, 2054, 1455, 1988, 1373, 2113,  100, 1955,
 /*   110 */   620, 1957, 1958,  615,  600,  610, 1106,  707, 1105,  654,
 /*   120 */   170,  458, 2041,  599,  463, 1640,  355, 2037,  123, 1450,
 /*   130 */   559,  210, 1457, 1458,   16,  503,   33,  275, 1484,  566,
 /*   140 */   175, 1381,  157, 2109, 1610, 1751,   46, 1107, 2067,  255,
 /*   150 */  2049,  577,  578,  124,  576, 1621, 1954, 2109,  565,  173,
 /*   160 */   600, 1431, 1440, 2110,  567,  578,   12,   42,   40,   39,
 /*   170 */    38,   37,  565,  173,   52, 1309, 1310, 2110,  567,   97,
 /*   180 */  1376,  586, 1374,  131, 1256, 1257,  467, 1972,  707,  463,
 /*   190 */  1640, 1751, 1402,  132, 1485,  614,  131,  561,   46, 1922,
 /*   200 */  1922, 1743,  616, 1457, 1458, 1379, 1380,   62, 1430, 1433,
 /*   210 */  1434, 1435, 1436, 1437, 1438, 1439,  612,  608, 1448, 1449,
 /*   220 */  1451, 1452, 1453, 1454, 1456, 1459,    2, 1953,  595,   58,
 /*   230 */  1860, 1988, 1431, 1440,  311, 1955,  620, 1957, 1958,  615,
 /*   240 */   613,  610,  601, 2006,  174, 2049, 2050, 1400,  129, 2054,
 /*   250 */   338, 1376, 2056, 1374, 1798, 1799,  580,  171, 2049, 2050,
 /*   260 */   556,  129, 2054, 1620,   58,   32,  359, 1479, 1480, 1481,
 /*   270 */  1482, 1483, 1487, 1488, 1489, 1490, 1379, 1380, 2053, 1430,
 /*   280 */  1433, 1434, 1435, 1436, 1437, 1438, 1439,  612,  608, 1448,
 /*   290 */  1449, 1451, 1452, 1453, 1454, 1456, 1459,    2,   58,    9,
 /*   300 */    43,   41, 1667,   47, 1551, 1596, 1847, 1922,  361, 1529,
 /*   310 */  1375,  339, 1729,  337,  336, 1400,  500,  181, 1954, 1619,
 /*   320 */   502, 1455,   58, 1373, 1213,  642,  641,  640, 1217,  639,
 /*   330 */  1219, 1220,  638, 1222,  635,  257, 1228,  632, 1230, 1231,
 /*   340 */   629,  626,  501,  562,  557,  258, 1450,  176,  399, 1972,
 /*   350 */   398,   16,  553, 1549, 1550, 1552, 1553,  617, 1381, 1106,
 /*   360 */  1173, 1105, 1922, 1922,  616,  569,  395,  513,  512,  511,
 /*   370 */   376,   43,   41, 1460,  477,  128,  507,  400,  176,  361,
 /*   380 */   506, 1375,   58,   12,   85,  505,  510,  397,  393, 1953,
 /*   390 */  1107,  504, 1455, 1988, 1373, 1175,  100, 1955,  620, 1957,
 /*   400 */  1958,  615, 1954,  610,   80,  707,  134, 1618,  141, 2012,
 /*   410 */  2041,  600,  546,  176,  355, 2037, 2109, 1450,  127,  546,
 /*   420 */  1457, 1458,  169, 2109, 1401,  178,  226, 1746,  573, 1381,
 /*   430 */  1617, 2115,  173, 1972, 1599, 1791, 2110,  567, 2115,  173,
 /*   440 */  1375,  617, 1751, 2110,  567,  167, 1922,  176,  616, 1431,
 /*   450 */  1440, 1922,  176, 1373,   44,  113, 1432,  587,  112,  111,
 /*   460 */   110,  109,  108,  107,  106,  105,  104, 1852, 1376,  352,
 /*   470 */  1374,  176, 1864, 1953, 1922,  227,  707, 1988, 1781, 1804,
 /*   480 */   160, 1955,  620, 1957, 1958,  615,  354,  610, 1381, 1352,
 /*   490 */  1353, 1457, 1458, 1379, 1380, 1802, 1430, 1433, 1434, 1435,
 /*   500 */  1436, 1437, 1438, 1439,  612,  608, 1448, 1449, 1451, 1452,
 /*   510 */  1453, 1454, 1456, 1459,    2,  509,  508,  678,  676,  113,
 /*   520 */  1431, 1440,  112,  111,  110,  109,  108,  107,  106,  105,
 /*   530 */   104,  176,  568, 2130,  364,  707,  513,  512,  511, 1376,
 /*   540 */   367, 1374,  155, 1804,  128,  507, 1465, 1909,  155,  506,
 /*   550 */   365, 1753, 1400, 1403,  505,  510, 1728, 1753, 1954, 1802,
 /*   560 */   504,  266,  267, 1400, 1379, 1380,  265, 1430, 1433, 1434,
 /*   570 */  1435, 1436, 1437, 1438, 1439,  612,  608, 1448, 1449, 1451,
 /*   580 */  1452, 1453, 1454, 1456, 1459,    2,   43,   41, 1598, 1972,
 /*   590 */  1616,  600,  185,  527,  361,  383, 1375,  581, 1376, 1727,
 /*   600 */  1374, 1615, 1922, 1399,  616,  404,  525, 1455,  523, 1373,
 /*   610 */  1742,  600,  122,  121,  120,  119,  118,  117,  116,  115,
 /*   620 */   114, 1936, 1751, 1379, 1380,  405,   11,   10,   77, 1953,
 /*   630 */  1614,   76, 1450, 1988, 1922, 1613,  100, 1955,  620, 1957,
 /*   640 */  1958,  615, 1751,  610, 1381, 1922,   91,   80,  170,  574,
 /*   650 */  2041, 1932, 1938,  133,  355, 2037, 2012,   43,   41,  600,
 /*   660 */   518,  654,  610,  652, 2114,  361, 1954, 1375, 1744,   44,
 /*   670 */  1747,  442, 1612,  414, 1922,  528, 2068,  587, 1455, 1922,
 /*   680 */  1373, 1402,  146,  145,  649,  648,  647,  143,   29,  224,
 /*   690 */  1751,  707, 1865, 1432,   36,   35,  182, 1972,   42,   40,
 /*   700 */    39,   38,   37, 1450,  521,  617, 1457, 1458, 1609,  515,
 /*   710 */  1922, 1608,  616, 2056,  223, 1381, 1922, 1607, 2114,   36,
 /*   720 */    35, 1498, 2109,   42,   40,   39,   38,   37, 1522,  189,
 /*   730 */   188, 1403, 1641, 1486, 2056, 1431, 1440, 1953, 2113, 2052,
 /*   740 */    12, 1988, 2110, 2111,  101, 1955,  620, 1957, 1958,  615,
 /*   750 */    64,  610, 1922,   63, 1376, 1922, 1374, 1584, 2041,   31,
 /*   760 */  2051, 1922,  707, 2038, 1606,   36,   35, 1605,  225,   42,
 /*   770 */    40,   39,   38,   37,    9, 1604, 1087, 1457, 1458, 1379,
 /*   780 */  1380,  702, 1430, 1433, 1434, 1435, 1436, 1437, 1438, 1439,
 /*   790 */   612,  608, 1448, 1449, 1451, 1452, 1453, 1454, 1456, 1459,
 /*   800 */     2,  318, 1384, 1398,   30, 1603, 1431, 1440, 1922,  710,
 /*   810 */   436, 1922,  155,  449, 1491, 1089,  448, 1092, 1093, 1922,
 /*   820 */   602, 1754, 2013,  282,  257, 1376, 1664, 1374,   82,  321,
 /*   830 */  1847,  420,  531,  450,  529,    9,  422,    7,  166, 1834,
 /*   840 */   604,  183, 2013,    6,  700,  696,  692,  688,  280, 1922,
 /*   850 */  1379, 1380, 1726, 1430, 1433, 1434, 1435, 1436, 1437, 1438,
 /*   860 */  1439,  612,  608, 1448, 1449, 1451, 1452, 1453, 1454, 1456,
 /*   870 */  1459,    2, 1804, 1403,  235,   36,   35,  334, 1400,   42,
 /*   880 */    40,   39,   38,   37,   98, 1847,  607,  273, 1803,  410,
 /*   890 */   645,  684,  683,  682,  681,  371,  187,  680,  679,  135,
 /*   900 */   674,  673,  672,  671,  670,  669,  668,  148,  664,  663,
 /*   910 */   662,  370,  369,  659,  658,  657,  656,  655,  646,  446,
 /*   920 */   596, 1795,  441,  440,  439,  438,  435,  434,  433,  432,
 /*   930 */   431,  427,  426,  425,  424,  335,  417,  416,  415, 1381,
 /*   940 */   412,  411,  332,  156, 1092, 1093,   36,   35,  295, 1387,
 /*   950 */    42,   40,   39,   38,   37, 1602, 1601,  260, 1954,  652,
 /*   960 */   666,  650,  293,   66, 1795,  289,   65,  651, 1781, 1521,
 /*   970 */  1795,  667, 1740, 1721, 1346,   48,  229,    3,  146,  145,
 /*   980 */   649,  648,  647,  143,  193,  455,  453,   36,   35, 1972,
 /*   990 */   423,   42,   40,   39,   38,   37,  502,  617, 1943, 1922,
 /*  1000 */  1922,  600, 1922,  652,  616, 1736,   36,   35, 2061, 1518,
 /*  1010 */    42,   40,   39,   38,   37,  428,  234,  233,  501, 1432,
 /*  1020 */    58,  600,  146,  145,  649,  648,  647,  143, 1476, 1953,
 /*  1030 */   154,  600, 1751, 1988, 1561,  429,  100, 1955,  620, 1957,
 /*  1040 */  1958,  615,   25,  610,  144,  476, 1945, 1518, 2129,  137,
 /*  1050 */  2041,  125, 1751,  407,  355, 2037,   83, 1738,   67,   99,
 /*  1060 */   600, 1954, 1751,   36,   35, 2075,  408,   42,   40,   39,
 /*  1070 */    38,   37,   36,   35, 1748, 1734,   42,   40,   39,   38,
 /*  1080 */    37,  600,  216,  218,  570,  214,  217,  600, 1654, 1383,
 /*  1090 */   220, 1751, 1972,  219, 1647,  139,   51,   74,   73,  403,
 /*  1100 */   617,  542,  180,  600,   60, 1922, 1954,  616,   75, 1645,
 /*  1110 */   514,  222, 1751, 1941,  221,  239,  516,  582, 1751,   45,
 /*  1120 */   317, 1593, 1594,  391, 1936,  389,  385,  381,  378,  375,
 /*  1130 */   263,  519, 1953,  600, 1751,  600, 1988, 1972, 1611,  100,
 /*  1140 */  1955,  620, 1957, 1958,  615,  617,  610,  270,  140,  597,
 /*  1150 */  1922, 2129,  616, 2041, 1932, 1938, 1548,  355, 2037, 1706,
 /*  1160 */  1541,  600,  600,  230, 1751,  610, 1751,  241, 2103,  176,
 /*  1170 */   142, 1322,  611,   50,  144,  598,  276, 1953,  545, 1954,
 /*  1180 */    60, 1988,  268,  252,  100, 1955,  620, 1957, 1958,  615,
 /*  1190 */   660,  610, 1751, 1751,  358,  357, 2129,  600, 2041,   45,
 /*  1200 */   592,   45,  355, 2037, 1389,   11,   10,  661,  644,   96,
 /*  1210 */  1972,  368, 1154, 2060, 2081, 1455,  624, 1382,  617,   93,
 /*  1220 */   211,  584,  272, 1922,  374,  616, 1206, 1591, 1751, 1152,
 /*  1230 */   209,  554, 1492,  246, 1954,  162, 1386,  142, 1973,  372,
 /*  1240 */  1450,  494,  490,  486,  482,  208,  144, 1856, 1635,  126,
 /*  1250 */  1953, 1441, 1381,  288, 1988, 1792,  142,  100, 1955,  620,
 /*  1260 */  1957, 1958,  615,  546,  610, 1972,  546, 2109, 1234, 2016,
 /*  1270 */  2109, 2041, 1135,  617,  579,  355, 2037, 2071, 1922,  251,
 /*  1280 */   616,   81, 2115,  173,  206, 2115,  173, 2110,  567, 1238,
 /*  1290 */  2110,  567,  254,    1,  373,    4,  382,  331, 1245,  606,
 /*  1300 */   377, 1243, 1339,  571,  283, 1953,  186, 1136,  147, 1988,
 /*  1310 */   409, 1403,  100, 1955,  620, 1957, 1958,  615, 1857,  610,
 /*  1320 */   413, 1590,  444,  418, 2014, 1398, 2041,  430, 1849,  437,
 /*  1330 */   355, 2037,  443,  451,  452,  445,  546,  190,  454,  456,
 /*  1340 */  2109, 1404,  457,  466, 1406,  470, 1954,  534,  469, 1405,
 /*  1350 */   196,  205,  199,  198,  204, 2115,  173,  473,  471, 1407,
 /*  1360 */  2110,  567, 1390,  472, 1385,  201,  474,  203,   78,   79,
 /*  1370 */   478, 1109,  207,  197,  495,  496, 1954, 1972,  499,  497,
 /*  1380 */   103, 1741, 1899,  213,  320,  617, 1898, 1393, 1395,  546,
 /*  1390 */  1922, 1737,  616, 2109,  533,  284,  535,  215,  149,  608,
 /*  1400 */  1448, 1449, 1451, 1452, 1453, 1454,  150, 1972, 2115,  173,
 /*  1410 */   228,  536, 1739, 2110,  567,  617,  540, 1953, 1735,  151,
 /*  1420 */  1922, 1988,  616,  152,  100, 1955,  620, 1957, 1958,  615,
 /*  1430 */   231,  610, 1954,  543,  550,  537,  603, 2072, 2041,  590,
 /*  1440 */  2082,  555,  355, 2037,    5,  552,  345, 1953, 2087,  558,
 /*  1450 */   237, 1988, 1954,  240,  101, 1955,  620, 1957, 1958,  615,
 /*  1460 */  2063,  610, 2086, 1972,  564,  548,  551,  549, 2041,  572,
 /*  1470 */   250,  617, 2040, 2037,  247,  245, 1922,  346,  616,  575,
 /*  1480 */   130,  248, 1518, 1972,  249,  163, 1402, 2057,  349,  583,
 /*  1490 */   259,  617, 1408, 1861,  285,  593, 1922,  588,  616,  286,
 /*  1500 */   589, 1870, 1869, 1953, 1868, 2108,  351, 1988,   88, 1752,
 /*  1510 */   101, 1955,  620, 1957, 1958,  615,  287,  610,   90,  594,
 /*  1520 */  1954,  253,   57,  618, 2041, 2022, 2132, 1988,  605, 2037,
 /*  1530 */   101, 1955,  620, 1957, 1958,  615, 1954,  610,   92,  622,
 /*  1540 */   279,  703, 1796, 1722, 2041,  704,  290,  706,  325, 2037,
 /*  1550 */    49, 1972,  314,  322,  323,  294, 1916, 1915,   71,  617,
 /*  1560 */    72,  292, 1914, 1913, 1922, 1910,  616, 1972,  379,  299,
 /*  1570 */  1367,  313,  303,  380, 1368,  617,  179, 1908,  384,  386,
 /*  1580 */  1922,  387,  616,  388, 1907,  390, 1906,  392, 1905,  394,
 /*  1590 */  1904, 1953, 1342,  396, 1341, 1988, 1881, 1954,  159, 1955,
 /*  1600 */   620, 1957, 1958,  615, 1880,  610,  401, 1953,  402, 1879,
 /*  1610 */  1878, 1988, 1842, 1300,  159, 1955,  620, 1957, 1958,  615,
 /*  1620 */  1841,  610, 1839,  136, 1838, 1837, 1840, 1836, 1972,  184,
 /*  1630 */   419, 1830,  421, 1829, 1828, 1827,  617, 1835, 1833,  547,
 /*  1640 */  2078, 1922, 1954,  616, 1832, 1831, 1826, 1825, 1824, 1823,
 /*  1650 */  1822, 1821, 1820, 1819, 1818, 1817, 2079, 1816, 1815,  138,
 /*  1660 */  1814, 1813, 1812, 1811, 1810, 1302, 1809, 1808, 1953, 1807,
 /*  1670 */  1806,  447, 1988, 1972, 1181,  305, 1955,  620, 1957, 1958,
 /*  1680 */   615,  617,  610, 1805, 1669, 1668, 1922, 1666,  616, 1630,
 /*  1690 */   191, 1095, 1094, 1629,  192, 1894, 1888, 1877,  194,  202,
 /*  1700 */  1876, 1859, 1730, 1954,   69, 1128, 1942, 1665, 1663, 1661,
 /*  1710 */  1659,   70,  168, 1953,  479,  195, 1657, 1988,  462,  563,
 /*  1720 */   160, 1955,  620, 1957, 1958,  615, 1954,  610,  464,  200,
 /*  1730 */   480,  481, 1644,  483, 1972, 1643,  484, 1626,  485,  350,
 /*  1740 */   487,  491,  617,  489, 1732, 1249,   59, 1922, 1731,  616,
 /*  1750 */  1250,  488,  493, 1172, 1171, 1170, 1169, 1972,  675,  492,
 /*  1760 */  1166,  677, 1164, 1165, 1163,  614, 1655,  340, 1648,  341,
 /*  1770 */  1922, 1646,  616, 2131, 1953,  212,  517,  342, 1988, 1625,
 /*  1780 */  1624,  312, 1955,  620, 1957, 1958,  615, 1954,  610,  520,
 /*  1790 */  1623,  522,  524,  102,  526, 1357, 1356, 1953,  530, 1893,
 /*  1800 */  1348, 1988, 1887,   53,  311, 1955,  620, 1957, 1958,  615,
 /*  1810 */  1875,  610, 1873, 2007,  538, 1874, 2114, 1954, 1972,   17,
 /*  1820 */  1359,   14,   56,  360,  244,   24,  617, 1563,   26,  236,
 /*  1830 */   243, 1922,  238,  616, 1547, 1540,  161,  242, 1943,   28,
 /*  1840 */  1954,   27,   18,  539,   84,   61, 1583, 1584, 1972,   19,
 /*  1850 */    15,  232, 1578,  362,  343, 1577,  617,  347, 1953,  153,
 /*  1860 */  1582, 1922, 1988,  616, 1581,  312, 1955,  620, 1957, 1958,
 /*  1870 */   615, 1972,  610,  348,  256,   55, 1872, 1515, 1514,  617,
 /*  1880 */   164,  544, 1871,  261, 1922, 1954,  616, 1858, 1953,   20,
 /*  1890 */    87,  264, 1988,  262, 1545,  312, 1955,  620, 1957, 1958,
 /*  1900 */   615, 1954,  610,  269,   86,   93,   89,  274,   21,   10,
 /*  1910 */  1391,  532, 1445, 1991,  609, 1988, 1972,  271,  307, 1955,
 /*  1920 */   620, 1957, 1958,  615,  617,  610, 1443,   34,  591, 1922,
 /*  1930 */  1442,  616, 1972,  165,   13,   22,   54,  177, 1423, 1415,
 /*  1940 */   617,   23,  625,  621, 1235, 1922,  623,  616,  363, 1467,
 /*  1950 */  1232,  628,  627,  630, 1954, 1229, 1953, 1477,  631,  633,
 /*  1960 */  1988, 1223,  634,  296, 1955,  620, 1957, 1958,  615, 1221,
 /*  1970 */   610,  619, 1953,  636,  637, 1212, 1988, 1227,  643,  297,
 /*  1980 */  1955,  620, 1957, 1958,  615, 1972,  610,    8, 1226, 1225,
 /*  1990 */  1466, 1224,   94,  617,  277,   95, 1244, 1240, 1922, 1954,
 /*  2000 */   616,   68, 1160, 1126,  653, 1159, 1158, 1157, 1156, 1155,
 /*  2010 */  1179, 1153, 1151, 1150, 1149,  665, 1147, 1146, 1145, 1144,
 /*  2020 */  1143, 1142, 1141, 1174,  278, 1953, 1176, 1138, 1137, 1988,
 /*  2030 */  1972, 1134,  298, 1955,  620, 1957, 1958,  615,  617,  610,
 /*  2040 */  1133, 1132, 1131, 1922, 1662,  616,  685,  686,  687, 1660,
 /*  2050 */   689,  690, 1954,  691, 1658,  693,  694,  695, 1656,  697,
 /*  2060 */   698,  699, 1642,  701, 1084, 1622,  709,  281, 1954,  705,
 /*  2070 */  1953, 1597, 1377,  291, 1988, 1597,  708,  304, 1955,  620,
 /*  2080 */  1957, 1958,  615, 1972,  610, 1597, 1597, 1597, 1597, 1597,
 /*  2090 */  1597,  617, 1597, 1597, 1597, 1597, 1922, 1597,  616, 1972,
 /*  2100 */  1597, 1597, 1597, 1597, 1597, 1597, 1597,  617, 1597, 1597,
 /*  2110 */  1597, 1597, 1922, 1954,  616, 1597, 1597, 1597, 1597, 1597,
 /*  2120 */  1597, 1597, 1597, 1953, 1597, 1597, 1597, 1988, 1597, 1597,
 /*  2130 */   308, 1955,  620, 1957, 1958,  615, 1597,  610, 1597, 1953,
 /*  2140 */  1597, 1597, 1597, 1988, 1972, 1597,  300, 1955,  620, 1957,
 /*  2150 */  1958,  615,  617,  610, 1597, 1597, 1597, 1922, 1597,  616,
 /*  2160 */  1597, 1597, 1597, 1597, 1597, 1597, 1954, 1597, 1597, 1597,
 /*  2170 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*  2180 */  1597, 1597, 1954, 1597, 1953, 1597, 1597, 1597, 1988, 1597,
 /*  2190 */  1597,  309, 1955,  620, 1957, 1958,  615, 1972,  610, 1597,
 /*  2200 */  1597, 1597, 1597, 1597, 1597,  617, 1597, 1597, 1597, 1597,
 /*  2210 */  1922, 1597,  616, 1972, 1597, 1597, 1597, 1597, 1597, 1597,
 /*  2220 */  1597,  617, 1597, 1597, 1597, 1597, 1922, 1954,  616, 1597,
 /*  2230 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1953, 1597, 1597,
 /*  2240 */  1597, 1988, 1597, 1597,  301, 1955,  620, 1957, 1958,  615,
 /*  2250 */  1954,  610, 1597, 1953, 1597, 1597, 1597, 1988, 1972, 1597,
 /*  2260 */   310, 1955,  620, 1957, 1958,  615,  617,  610, 1597, 1597,
 /*  2270 */  1597, 1922, 1597,  616, 1597, 1597, 1597, 1597, 1597, 1597,
 /*  2280 */  1954, 1972, 1597, 1597, 1597, 1597, 1597, 1597, 1597,  617,
 /*  2290 */  1597, 1597, 1597, 1597, 1922, 1597,  616, 1597, 1953, 1597,
 /*  2300 */  1597, 1597, 1988, 1597, 1597,  302, 1955,  620, 1957, 1958,
 /*  2310 */   615, 1972,  610, 1597, 1597, 1597, 1597, 1597, 1597,  617,
 /*  2320 */  1597, 1953, 1597, 1597, 1922, 1988,  616, 1597,  315, 1955,
 /*  2330 */   620, 1957, 1958,  615, 1597,  610, 1597, 1597, 1597, 1597,
 /*  2340 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*  2350 */  1597, 1953, 1597, 1597, 1597, 1988, 1954, 1597,  316, 1955,
 /*  2360 */   620, 1957, 1958,  615, 1597,  610, 1597, 1597, 1597, 1597,
 /*  2370 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1954, 1597,
 /*  2380 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1972, 1597, 1597,
 /*  2390 */  1597, 1597, 1597, 1597, 1597,  617, 1597, 1597, 1597, 1597,
 /*  2400 */  1922, 1597,  616, 1597, 1597, 1597, 1597, 1597, 1597, 1972,
 /*  2410 */  1597, 1597, 1597, 1597, 1597, 1597, 1597,  617, 1597, 1597,
 /*  2420 */  1597, 1597, 1922, 1597,  616, 1597, 1597, 1953, 1597, 1597,
 /*  2430 */  1597, 1988, 1597, 1954, 1966, 1955,  620, 1957, 1958,  615,
 /*  2440 */  1597,  610, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1953,
 /*  2450 */  1597, 1597, 1597, 1988, 1597, 1597, 1965, 1955,  620, 1957,
 /*  2460 */  1958,  615, 1597,  610, 1972, 1597, 1597, 1597, 1597, 1597,
 /*  2470 */  1597, 1597,  617, 1597, 1597, 1597, 1597, 1922, 1954,  616,
 /*  2480 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*  2490 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*  2500 */  1597, 1597, 1597, 1597, 1953, 1597, 1597, 1597, 1988, 1972,
 /*  2510 */  1597, 1964, 1955,  620, 1957, 1958,  615,  617,  610, 1597,
 /*  2520 */  1597, 1597, 1922, 1954,  616, 1597, 1597, 1597, 1597, 1597,
 /*  2530 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1954,
 /*  2540 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1953,
 /*  2550 */  1597, 1597, 1597, 1988, 1972, 1597,  327, 1955,  620, 1957,
 /*  2560 */  1958,  615,  617,  610, 1597, 1597, 1597, 1922, 1597,  616,
 /*  2570 */  1972, 1597, 1597, 1597, 1597, 1597, 1597, 1597,  617, 1597,
 /*  2580 */  1597, 1597, 1597, 1922, 1954,  616, 1597, 1597, 1597, 1597,
 /*  2590 */  1597, 1597, 1597, 1597, 1953, 1597, 1597, 1597, 1988, 1597,
 /*  2600 */  1597,  328, 1955,  620, 1957, 1958,  615, 1954,  610, 1597,
 /*  2610 */  1953, 1597, 1597, 1597, 1988, 1972, 1597,  324, 1955,  620,
 /*  2620 */  1957, 1958,  615,  617,  610, 1597, 1597, 1597, 1922, 1597,
 /*  2630 */   616, 1597, 1597, 1597, 1597, 1597, 1597, 1954, 1972, 1597,
 /*  2640 */  1597, 1597, 1597, 1597, 1597, 1597,  617, 1597, 1597, 1597,
 /*  2650 */  1597, 1922, 1597,  616, 1597, 1953, 1597, 1597, 1597, 1988,
 /*  2660 */  1597, 1597,  329, 1955,  620, 1957, 1958,  615, 1972,  610,
 /*  2670 */  1597, 1597, 1597, 1597, 1597, 1597,  617, 1597,  618, 1597,
 /*  2680 */  1597, 1922, 1988,  616, 1597,  307, 1955,  620, 1957, 1958,
 /*  2690 */   615, 1597,  610, 1597, 1597, 1597, 1597, 1597, 1597, 1597,
 /*  2700 */  1597, 1597, 1597, 1597, 1597, 1597, 1597, 1597, 1953, 1597,
 /*  2710 */  1597, 1597, 1988, 1597, 1597,  306, 1955,  620, 1957, 1958,
 /*  2720 */   615, 1597,  610,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   329,  348,  331,  332,  429,  333,  333,  429,  433,  356,
 /*    10 */   358,  433,   12,   13,   14,   14,   15,   16,  365,  347,
 /*    20 */    20,  369,   22,  448,  449,   20,  354,  449,  453,  454,
 /*    30 */   325,  453,  454,   33,   20,   35,  364,  364,  329,  333,
 /*    40 */   331,  332,    8,    9,  358,  333,   12,   13,   14,   15,
 /*    50 */    16,  399,  400,  401,  391,  369,  356,  333,   58,   14,
 /*    60 */    20,  356,  410,   63,  367,   20,  356,  370,  371,  364,
 /*    70 */    70,   20,   20,  363,  369,  340,  371,  377,  378,  373,
 /*    80 */   345,  356,  372,   12,   13,  399,  400,  401,  364,  364,
 /*    90 */    62,   20,  380,   22,  382,   95,  410,   63,  425,  426,
 /*   100 */   427,  396,  429,  430,   33,  400,   35,    3,  403,  404,
 /*   110 */   405,  406,  407,  408,  333,  410,   20,  117,   22,   62,
 /*   120 */   415,  330,  417,   20,  333,  334,  421,  422,  347,   58,
 /*   130 */   405,   35,  132,  133,   63,  354,  418,  419,  104,  429,
 /*   140 */   435,   70,  324,  433,  326,  364,   95,   51,  443,  425,
 /*   150 */   426,  427,  333,  429,  430,  325,  325,  433,  448,  449,
 /*   160 */   333,  161,  162,  453,  454,  333,   95,   12,   13,   14,
 /*   170 */    15,   16,  448,  449,  347,  161,  162,  453,  454,  337,
 /*   180 */   180,  333,  182,  364,  132,  133,  330,  356,  117,  333,
 /*   190 */   334,  364,   20,  351,  160,  364,  364,   20,   95,  369,
 /*   200 */   369,  359,  371,  132,  133,  205,  206,    4,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  396,  380,   95,
 /*   230 */   382,  400,  161,  162,  403,  404,  405,  406,  407,  408,
 /*   240 */   409,  410,  411,  412,  425,  426,  427,   20,  429,  430,
 /*   250 */    37,  180,  402,  182,  370,  371,  424,  425,  426,  427,
 /*   260 */   166,  429,  430,  325,   95,  231,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  205,  206,  428,  208,
 /*   280 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,   95,  228,
 /*   300 */    12,   13,    0,   95,  205,  322,  364,  369,   20,   14,
 /*   310 */    22,   98,    0,  100,  101,   20,  103,  375,  325,  325,
 /*   320 */   107,   33,   95,   35,  108,  109,  110,  111,  112,  113,
 /*   330 */   114,  115,  116,  117,  118,  163,  120,  121,  122,  123,
 /*   340 */   124,  125,  129,  249,  250,   58,   58,  244,  179,  356,
 /*   350 */   181,   63,  253,  254,  255,  256,  257,  364,   70,   20,
 /*   360 */    35,   22,  369,  369,  371,  261,  175,   65,   66,   67,
 /*   370 */   387,   12,   13,   14,   62,   73,   74,  387,  244,   20,
 /*   380 */    78,   22,   95,   95,   97,   83,   84,  196,  197,  396,
 /*   390 */    51,   89,   33,  400,   35,   70,  403,  404,  405,  406,
 /*   400 */   407,  408,  325,  410,  339,  117,  413,  325,  415,  416,
 /*   410 */   417,  333,  429,  244,  421,  422,  433,   58,  353,  429,
 /*   420 */   132,  133,  355,  433,   20,  347,  126,  362,   44,   70,
 /*   430 */   325,  448,  449,  356,    0,  368,  453,  454,  448,  449,
 /*   440 */    22,  364,  364,  453,  454,  356,  369,  244,  371,  161,
 /*   450 */   162,  369,  244,   35,   95,   21,  161,  371,   24,   25,
 /*   460 */    26,   27,   28,   29,   30,   31,   32,  378,  180,  383,
 /*   470 */   182,  244,  386,  396,  369,  349,  117,  400,  352,  356,
 /*   480 */   403,  404,  405,  406,  407,  408,  363,  410,   70,  189,
 /*   490 */   190,  132,  133,  205,  206,  372,  208,  209,  210,  211,
 /*   500 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   510 */   222,  223,  224,  225,  226,  342,  343,  342,  343,   21,
 /*   520 */   161,  162,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   530 */    32,  244,  455,  456,  348,  117,   65,   66,   67,  180,
 /*   540 */   348,  182,  356,  356,   73,   74,   14,    0,  356,   78,
 /*   550 */   363,  365,   20,   20,   83,   84,    0,  365,  325,  372,
 /*   560 */    89,  126,  127,   20,  205,  206,  131,  208,  209,  210,
 /*   570 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   580 */   221,  222,  223,  224,  225,  226,   12,   13,    0,  356,
 /*   590 */   325,  333,   58,   21,   20,   48,   22,  364,  180,    0,
 /*   600 */   182,  325,  369,   20,  371,  347,   34,   33,   36,   35,
 /*   610 */   358,  333,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   620 */    32,  369,  364,  205,  206,  347,    1,    2,   94,  396,
 /*   630 */   325,   97,   58,  400,  369,  325,  403,  404,  405,  406,
 /*   640 */   407,  408,  364,  410,   70,  369,  337,  339,  415,  265,
 /*   650 */   417,  399,  400,  413,  421,  422,  416,   12,   13,  333,
 /*   660 */     4,   62,  410,  107,    3,   20,  325,   22,  359,   95,
 /*   670 */   362,   79,  325,  347,  369,   19,  443,  371,   33,  369,
 /*   680 */    35,   20,  126,  127,  128,  129,  130,  131,    2,   33,
 /*   690 */   364,  117,  386,  161,    8,    9,  163,  356,   12,   13,
 /*   700 */    14,   15,   16,   58,   48,  364,  132,  133,  325,   53,
 /*   710 */   369,  325,  371,  402,   58,   70,  369,  325,  429,    8,
 /*   720 */     9,   96,  433,   12,   13,   14,   15,   16,    4,  137,
 /*   730 */   138,   20,    0,  160,  402,  161,  162,  396,  449,  428,
 /*   740 */    95,  400,  453,  454,  403,  404,  405,  406,  407,  408,
 /*   750 */    94,  410,  369,   97,  180,  369,  182,   96,  417,    2,
 /*   760 */   428,  369,  117,  422,  325,    8,    9,  325,  127,   12,
 /*   770 */    13,   14,   15,   16,  228,  325,    4,  132,  133,  205,
 /*   780 */   206,   49,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   790 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   800 */   226,   18,   35,   20,  231,  325,  161,  162,  369,   19,
 /*   810 */    27,  369,  356,   30,  241,   43,   33,   45,   46,  369,
 /*   820 */   414,  365,  416,   33,  163,  180,    0,  182,  187,  188,
 /*   830 */   364,   48,  191,   50,  193,  228,   53,  230,   48,    0,
 /*   840 */   414,  375,  416,   39,   54,   55,   56,   57,   58,  369,
 /*   850 */   205,  206,    0,  208,  209,  210,  211,  212,  213,  214,
 /*   860 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  224,
 /*   870 */   225,  226,  356,   20,  163,    8,    9,   94,   20,   12,
 /*   880 */    13,   14,   15,   16,   94,  364,   63,   97,  372,  106,
 /*   890 */   106,   65,   66,   67,   68,   69,  375,   71,   72,   73,
 /*   900 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   910 */    84,   85,   86,   87,   88,   89,   90,   91,  366,  136,
 /*   920 */   130,  369,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   930 */   147,  148,  149,  150,  151,  152,  153,  154,  155,   70,
 /*   940 */   157,  158,  159,   18,   45,   46,    8,    9,   23,  182,
 /*   950 */    12,   13,   14,   15,   16,  325,  325,  167,  325,  107,
 /*   960 */    70,  366,   37,   38,  369,  349,   41,  366,  352,  245,
 /*   970 */   369,  344,  357,  346,  184,   42,  186,   44,  126,  127,
 /*   980 */   128,  129,  130,  131,   59,   60,   61,    8,    9,  356,
 /*   990 */   151,   12,   13,   14,   15,   16,  107,  364,   47,  369,
 /*  1000 */   369,  333,  369,  107,  371,  357,    8,    9,  242,  243,
 /*  1010 */    12,   13,   14,   15,   16,  347,  163,   58,  129,  161,
 /*  1020 */    95,  333,  126,  127,  128,  129,  130,  131,  205,  396,
 /*  1030 */   163,  333,  364,  400,   96,  347,  403,  404,  405,  406,
 /*  1040 */   407,  408,   44,  410,   44,  347,   95,  243,  415,   42,
 /*  1050 */   417,   44,  364,   22,  421,  422,   97,  357,  106,  134,
 /*  1060 */   333,  325,  364,    8,    9,  432,   35,   12,   13,   14,
 /*  1070 */    15,   16,    8,    9,  347,  357,   12,   13,   14,   15,
 /*  1080 */    16,  333,   99,   99,   44,  102,  102,  333,    0,   35,
 /*  1090 */    99,  364,  356,  102,    0,  347,   96,  172,  173,  174,
 /*  1100 */   364,  347,  177,  333,   44,  369,  325,  371,  156,    0,
 /*  1110 */    22,   99,  364,  358,  102,   44,   22,  347,  364,   44,
 /*  1120 */   195,  132,  133,  198,  369,  200,  201,  202,  203,  204,
 /*  1130 */    44,   22,  396,  333,  364,  333,  400,  356,  326,  403,
 /*  1140 */   404,  405,  406,  407,  408,  364,  410,  347,   44,  347,
 /*  1150 */   369,  415,  371,  417,  399,  400,   96,  421,  422,  345,
 /*  1160 */    96,  333,  333,  357,  364,  410,  364,   96,  432,  244,
 /*  1170 */    44,   96,  357,  163,   44,  347,  347,  396,  168,  325,
 /*  1180 */    44,  400,   96,  457,  403,  404,  405,  406,  407,  408,
 /*  1190 */    13,  410,  364,  364,   12,   13,  415,  333,  417,   44,
 /*  1200 */    96,   44,  421,  422,   22,    1,    2,   13,  357,   95,
 /*  1210 */   356,  347,   35,  432,  379,   33,   44,   35,  364,  105,
 /*  1220 */    33,  387,   96,  369,  387,  371,   96,  172,  364,   35,
 /*  1230 */   335,  446,   96,  440,  325,   48,  182,   44,  356,  335,
 /*  1240 */    58,   54,   55,   56,   57,   58,   44,  379,  332,   44,
 /*  1250 */   396,   96,   70,   96,  400,  368,   44,  403,  404,  405,
 /*  1260 */   406,  407,  408,  429,  410,  356,  429,  433,   96,  415,
 /*  1270 */   433,  417,   35,  364,  431,  421,  422,  379,  369,  423,
 /*  1280 */   371,   94,  448,  449,   97,  448,  449,  453,  454,   96,
 /*  1290 */   453,  454,  450,  434,  387,  246,   48,  397,   96,  117,
 /*  1300 */   398,   96,  178,  263,  389,  396,   42,   70,   96,  400,
 /*  1310 */   376,   20,  403,  404,  405,  406,  407,  408,  379,  410,
 /*  1320 */   376,  266,  160,  374,  415,   20,  417,  333,  333,  376,
 /*  1330 */   421,  422,  374,   93,  341,  374,  429,  333,  333,  333,
 /*  1340 */   433,   20,  327,  327,   20,  371,  325,  387,  393,   20,
 /*  1350 */   339,  164,  165,  339,  167,  448,  449,  170,  334,   20,
 /*  1360 */   453,  454,  180,  388,  182,  339,  334,  339,  339,  339,
 /*  1370 */   333,   52,  339,  186,  336,  336,  325,  356,  356,  327,
 /*  1380 */   333,  356,  369,  356,  327,  364,  369,  205,  206,  429,
 /*  1390 */   369,  356,  371,  433,  194,  393,  395,  356,  356,  217,
 /*  1400 */   218,  219,  220,  221,  222,  223,  356,  356,  448,  449,
 /*  1410 */   337,  185,  356,  453,  454,  364,  371,  396,  356,  356,
 /*  1420 */   369,  400,  371,  356,  403,  404,  405,  406,  407,  408,
 /*  1430 */   337,  410,  325,  333,  369,  392,  415,  379,  417,  251,
 /*  1440 */   379,  252,  421,  422,  258,  369,  369,  396,  439,  369,
 /*  1450 */   384,  400,  325,  384,  403,  404,  405,  406,  407,  408,
 /*  1460 */   442,  410,  439,  356,  171,  247,  260,  259,  417,  262,
 /*  1470 */   398,  364,  421,  422,  438,  441,  369,  267,  371,  264,
 /*  1480 */   364,  437,  243,  356,  436,  439,   20,  402,  334,  333,
 /*  1490 */   337,  364,   20,  382,  384,  165,  369,  369,  371,  384,
 /*  1500 */   369,  369,  369,  396,  369,  452,  369,  400,  337,  364,
 /*  1510 */   403,  404,  405,  406,  407,  408,  352,  410,  337,  381,
 /*  1520 */   325,  451,   95,  396,  417,  420,  458,  400,  421,  422,
 /*  1530 */   403,  404,  405,  406,  407,  408,  325,  410,   95,  360,
 /*  1540 */   337,   36,  369,  346,  417,  328,  333,  327,  421,  422,
 /*  1550 */   390,  356,  394,  385,  385,  323,    0,    0,  187,  364,
 /*  1560 */    42,  338,    0,    0,  369,    0,  371,  356,   35,  350,
 /*  1570 */    35,  350,  350,  199,   35,  364,   35,    0,  199,   35,
 /*  1580 */   369,   35,  371,  199,    0,  199,    0,   35,    0,   22,
 /*  1590 */     0,  396,  182,   35,  180,  400,    0,  325,  403,  404,
 /*  1600 */   405,  406,  407,  408,    0,  410,  176,  396,  175,    0,
 /*  1610 */     0,  400,    0,   47,  403,  404,  405,  406,  407,  408,
 /*  1620 */     0,  410,    0,   42,    0,    0,    0,    0,  356,  151,
 /*  1630 */    35,    0,  151,    0,    0,    0,  364,    0,    0,  444,
 /*  1640 */   445,  369,  325,  371,    0,    0,    0,    0,    0,    0,
 /*  1650 */     0,    0,    0,    0,    0,    0,  445,    0,    0,   42,
 /*  1660 */     0,    0,    0,    0,    0,   22,    0,    0,  396,    0,
 /*  1670 */     0,  135,  400,  356,   35,  403,  404,  405,  406,  407,
 /*  1680 */   408,  364,  410,    0,    0,    0,  369,    0,  371,    0,
 /*  1690 */    58,   14,   14,    0,   58,    0,    0,    0,   42,  171,
 /*  1700 */     0,    0,    0,  325,   39,   64,   47,    0,    0,    0,
 /*  1710 */     0,   39,   44,  396,   35,   40,    0,  400,   47,  447,
 /*  1720 */   403,  404,  405,  406,  407,  408,  325,  410,   47,   39,
 /*  1730 */    48,   39,    0,   35,  356,    0,   48,    0,   39,  361,
 /*  1740 */    35,   35,  364,   39,    0,   22,  104,  369,    0,  371,
 /*  1750 */    35,   48,   39,   35,   35,   35,   35,  356,   44,   48,
 /*  1760 */    35,   44,   22,   35,   35,  364,    0,   22,    0,   22,
 /*  1770 */   369,    0,  371,  456,  396,  102,   50,   22,  400,    0,
 /*  1780 */     0,  403,  404,  405,  406,  407,  408,  325,  410,   35,
 /*  1790 */     0,   35,   35,   20,   22,   35,   35,  396,  192,    0,
 /*  1800 */    35,  400,    0,  163,  403,  404,  405,  406,  407,  408,
 /*  1810 */     0,  410,    0,  412,   22,    0,    3,  325,  356,   44,
 /*  1820 */    96,  248,   44,  361,   47,   95,  364,   96,   95,   95,
 /*  1830 */    44,  369,   96,  371,   96,   96,   95,   95,   47,   44,
 /*  1840 */   325,   95,  248,  163,   95,    3,   96,   96,  356,   44,
 /*  1850 */   248,  165,   35,  361,  163,   35,  364,   35,  396,  183,
 /*  1860 */    35,  369,  400,  371,   35,  403,  404,  405,  406,  407,
 /*  1870 */   408,  356,  410,   35,   47,   44,    0,   96,   96,  364,
 /*  1880 */    47,  169,    0,   47,  369,  325,  371,    0,  396,   95,
 /*  1890 */    39,   95,  400,   96,   96,  403,  404,  405,  406,  407,
 /*  1900 */   408,  325,  410,   95,   95,  105,   95,   47,   44,    2,
 /*  1910 */    22,  396,   96,   95,   95,  400,  356,  164,  403,  404,
 /*  1920 */   405,  406,  407,  408,  364,  410,   96,   95,  166,  369,
 /*  1930 */    96,  371,  356,   47,   95,   95,  242,   47,   22,   96,
 /*  1940 */   364,   95,   95,  106,   96,  369,   35,  371,   35,  227,
 /*  1950 */    96,   95,   35,   35,  325,   96,  396,  205,   95,   35,
 /*  1960 */   400,   96,   95,  403,  404,  405,  406,  407,  408,   96,
 /*  1970 */   410,  207,  396,   35,   95,   22,  400,  119,  107,  403,
 /*  1980 */   404,  405,  406,  407,  408,  356,  410,  229,  119,  119,
 /*  1990 */   227,  119,   95,  364,   44,   95,   35,   22,  369,  325,
 /*  2000 */   371,   95,   35,   64,   63,   35,   35,   35,   35,   35,
 /*  2010 */    70,   35,   35,   35,   35,   92,   35,   35,   35,   22,
 /*  2020 */    35,   35,   35,   35,   44,  396,   70,   35,   35,  400,
 /*  2030 */   356,   35,  403,  404,  405,  406,  407,  408,  364,  410,
 /*  2040 */    35,   22,   35,  369,    0,  371,   35,   48,   39,    0,
 /*  2050 */    35,   48,  325,   39,    0,   35,   48,   39,    0,   35,
 /*  2060 */    48,   39,    0,   35,   35,    0,   20,   22,  325,   21,
 /*  2070 */   396,  459,   22,   22,  400,  459,   21,  403,  404,  405,
 /*  2080 */   406,  407,  408,  356,  410,  459,  459,  459,  459,  459,
 /*  2090 */   459,  364,  459,  459,  459,  459,  369,  459,  371,  356,
 /*  2100 */   459,  459,  459,  459,  459,  459,  459,  364,  459,  459,
 /*  2110 */   459,  459,  369,  325,  371,  459,  459,  459,  459,  459,
 /*  2120 */   459,  459,  459,  396,  459,  459,  459,  400,  459,  459,
 /*  2130 */   403,  404,  405,  406,  407,  408,  459,  410,  459,  396,
 /*  2140 */   459,  459,  459,  400,  356,  459,  403,  404,  405,  406,
 /*  2150 */   407,  408,  364,  410,  459,  459,  459,  369,  459,  371,
 /*  2160 */   459,  459,  459,  459,  459,  459,  325,  459,  459,  459,
 /*  2170 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2180 */   459,  459,  325,  459,  396,  459,  459,  459,  400,  459,
 /*  2190 */   459,  403,  404,  405,  406,  407,  408,  356,  410,  459,
 /*  2200 */   459,  459,  459,  459,  459,  364,  459,  459,  459,  459,
 /*  2210 */   369,  459,  371,  356,  459,  459,  459,  459,  459,  459,
 /*  2220 */   459,  364,  459,  459,  459,  459,  369,  325,  371,  459,
 /*  2230 */   459,  459,  459,  459,  459,  459,  459,  396,  459,  459,
 /*  2240 */   459,  400,  459,  459,  403,  404,  405,  406,  407,  408,
 /*  2250 */   325,  410,  459,  396,  459,  459,  459,  400,  356,  459,
 /*  2260 */   403,  404,  405,  406,  407,  408,  364,  410,  459,  459,
 /*  2270 */   459,  369,  459,  371,  459,  459,  459,  459,  459,  459,
 /*  2280 */   325,  356,  459,  459,  459,  459,  459,  459,  459,  364,
 /*  2290 */   459,  459,  459,  459,  369,  459,  371,  459,  396,  459,
 /*  2300 */   459,  459,  400,  459,  459,  403,  404,  405,  406,  407,
 /*  2310 */   408,  356,  410,  459,  459,  459,  459,  459,  459,  364,
 /*  2320 */   459,  396,  459,  459,  369,  400,  371,  459,  403,  404,
 /*  2330 */   405,  406,  407,  408,  459,  410,  459,  459,  459,  459,
 /*  2340 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2350 */   459,  396,  459,  459,  459,  400,  325,  459,  403,  404,
 /*  2360 */   405,  406,  407,  408,  459,  410,  459,  459,  459,  459,
 /*  2370 */   459,  459,  459,  459,  459,  459,  459,  459,  325,  459,
 /*  2380 */   459,  459,  459,  459,  459,  459,  459,  356,  459,  459,
 /*  2390 */   459,  459,  459,  459,  459,  364,  459,  459,  459,  459,
 /*  2400 */   369,  459,  371,  459,  459,  459,  459,  459,  459,  356,
 /*  2410 */   459,  459,  459,  459,  459,  459,  459,  364,  459,  459,
 /*  2420 */   459,  459,  369,  459,  371,  459,  459,  396,  459,  459,
 /*  2430 */   459,  400,  459,  325,  403,  404,  405,  406,  407,  408,
 /*  2440 */   459,  410,  459,  459,  459,  459,  459,  459,  459,  396,
 /*  2450 */   459,  459,  459,  400,  459,  459,  403,  404,  405,  406,
 /*  2460 */   407,  408,  459,  410,  356,  459,  459,  459,  459,  459,
 /*  2470 */   459,  459,  364,  459,  459,  459,  459,  369,  325,  371,
 /*  2480 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2490 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  459,
 /*  2500 */   459,  459,  459,  459,  396,  459,  459,  459,  400,  356,
 /*  2510 */   459,  403,  404,  405,  406,  407,  408,  364,  410,  459,
 /*  2520 */   459,  459,  369,  325,  371,  459,  459,  459,  459,  459,
 /*  2530 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  325,
 /*  2540 */   459,  459,  459,  459,  459,  459,  459,  459,  459,  396,
 /*  2550 */   459,  459,  459,  400,  356,  459,  403,  404,  405,  406,
 /*  2560 */   407,  408,  364,  410,  459,  459,  459,  369,  459,  371,
 /*  2570 */   356,  459,  459,  459,  459,  459,  459,  459,  364,  459,
 /*  2580 */   459,  459,  459,  369,  325,  371,  459,  459,  459,  459,
 /*  2590 */   459,  459,  459,  459,  396,  459,  459,  459,  400,  459,
 /*  2600 */   459,  403,  404,  405,  406,  407,  408,  325,  410,  459,
 /*  2610 */   396,  459,  459,  459,  400,  356,  459,  403,  404,  405,
 /*  2620 */   406,  407,  408,  364,  410,  459,  459,  459,  369,  459,
 /*  2630 */   371,  459,  459,  459,  459,  459,  459,  325,  356,  459,
 /*  2640 */   459,  459,  459,  459,  459,  459,  364,  459,  459,  459,
 /*  2650 */   459,  369,  459,  371,  459,  396,  459,  459,  459,  400,
 /*  2660 */   459,  459,  403,  404,  405,  406,  407,  408,  356,  410,
 /*  2670 */   459,  459,  459,  459,  459,  459,  364,  459,  396,  459,
 /*  2680 */   459,  369,  400,  371,  459,  403,  404,  405,  406,  407,
 /*  2690 */   408,  459,  410,  459,  459,  459,  459,  459,  459,  459,
 /*  2700 */   459,  459,  459,  459,  459,  459,  459,  459,  396,  459,
 /*  2710 */   459,  459,  400,  459,  459,  403,  404,  405,  406,  407,
 /*  2720 */   408,  459,  410,
};
#define YY_SHIFT_COUNT    (710)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2065)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   925,    0,   71,    0,  288,  288,  288,  288,  288,  288,
 /*    10 */   288,  288,  288,  359,  574,  574,  645,  574,  574,  574,
 /*    20 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    30 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    40 */   574,  574,  574,  574,  574,  574,  103,  227,   51,  169,
 /*    50 */   287,  134,  208,  134,   51,   51, 1182, 1182,  134, 1182,
 /*    60 */  1182,  203,  134,    5,    5,  772,  772,   14,   52,   45,
 /*    70 */    45,    5,    5,    5,    5,    5,    5,    5,   40,    5,
 /*    80 */     5,   28,    5,    5,  177,    5,  404,    5,   40,  543,
 /*    90 */     5,    5,  543,    5,  543,  543,  543,    5,   57,  783,
 /*   100 */    34,   34,  498,  471,  418,  418,  418,  418,  418,  418,
 /*   110 */   418,  418,  418,  418,  418,  418,  418,  418,  418,  418,
 /*   120 */   418,  418,  418,  213,  661,   14,   52,  312,  325,  172,
 /*   130 */   172,  172,  599,  607,  607,  325,  583,  583,  583,  784,
 /*   140 */   404,  546,  543,  869,  543,  869,  869,  784,  890,  216,
 /*   150 */   216,  216,  216,  216,  216,  216,  790,  434,  302,  711,
 /*   160 */  1055,   99,   96,   94,  295,  532,  339,  533,  899,  889,
 /*   170 */   853,  766,  804,  104,  766,  933,  724,  858, 1049, 1248,
 /*   180 */  1124, 1264, 1291, 1264, 1162, 1305, 1305, 1264, 1162, 1162,
 /*   190 */  1240, 1305, 1305, 1305, 1321, 1321, 1324,   28,  404,   28,
 /*   200 */  1329, 1339,   28, 1329,   28,   28,   28, 1305,   28, 1319,
 /*   210 */  1319, 1321,  543,  543,  543,  543,  543,  543,  543,  543,
 /*   220 */   543,  543,  543, 1305, 1321,  869,  869, 1200, 1324,   57,
 /*   230 */  1226,  404,   57, 1305, 1291, 1291,  869, 1189, 1188,  869,
 /*   240 */  1189, 1188,  869,  869,  543, 1186, 1293, 1189, 1206, 1208,
 /*   250 */  1218, 1049, 1210, 1215, 1207, 1239,  583, 1466, 1305, 1329,
 /*   260 */    57, 1472, 1188,  869,  869,  869,  869,  869, 1188,  869,
 /*   270 */  1330,   57,  784,   57,  583, 1427, 1443,  869,  890, 1305,
 /*   280 */    57, 1505, 1321, 2723, 2723, 2723, 2723, 2723, 2723, 2723,
 /*   290 */  2723, 2723,  826, 1187,  588,  656,  938,  998, 1064,  556,
 /*   300 */   686,  757,  867,  852,  979,  979,  979,  979,  979,  979,
 /*   310 */   979,  979,  979,  896,  641,  155,  155,  191,  534,  592,
 /*   320 */   572,  300,  435,  435,    1,  625,  573,    1,    1,    1,
 /*   330 */  1000,  547, 1031, 1007,  952,  839,  983,  984,  991, 1012,
 /*   340 */  1088, 1094, 1109,  959, 1060, 1071,  989, 1040,  384, 1010,
 /*   350 */  1075, 1086, 1104, 1126, 1130, 1204, 1136,  767, 1054,  823,
 /*   360 */  1155,  951, 1157, 1172, 1193, 1202, 1205, 1212, 1114, 1177,
 /*   370 */  1194, 1237,  732, 1556, 1557, 1371, 1562, 1563, 1518, 1565,
 /*   380 */  1533, 1374, 1535, 1539, 1541, 1379, 1577, 1544, 1546, 1384,
 /*   390 */  1584, 1386, 1586, 1552, 1588, 1567, 1590, 1558, 1410, 1414,
 /*   400 */  1596, 1604, 1430, 1433, 1609, 1610, 1566, 1612, 1620, 1622,
 /*   410 */  1581, 1624, 1625, 1626, 1627, 1637, 1638, 1644, 1645, 1478,
 /*   420 */  1595, 1631, 1481, 1633, 1634, 1635, 1646, 1647, 1648, 1649,
 /*   430 */  1650, 1651, 1652, 1653, 1654, 1655, 1657, 1658, 1617, 1660,
 /*   440 */  1661, 1662, 1663, 1664, 1643, 1666, 1667, 1669, 1536, 1670,
 /*   450 */  1683, 1639, 1684, 1632, 1685, 1636, 1687, 1689, 1656, 1665,
 /*   460 */  1668, 1659, 1677, 1671, 1678, 1681, 1693, 1675, 1672, 1695,
 /*   470 */  1696, 1697, 1690, 1528, 1700, 1701, 1702, 1641, 1707, 1708,
 /*   480 */  1679, 1682, 1692, 1709, 1698, 1688, 1699, 1710, 1705, 1703,
 /*   490 */  1704, 1716, 1706, 1711, 1713, 1732, 1735, 1737, 1744, 1642,
 /*   500 */  1673, 1715, 1723, 1748, 1718, 1719, 1720, 1721, 1714, 1717,
 /*   510 */  1725, 1728, 1740, 1729, 1766, 1745, 1768, 1747, 1726, 1771,
 /*   520 */  1755, 1754, 1779, 1756, 1780, 1757, 1790, 1772, 1773, 1760,
 /*   530 */  1761, 1606, 1724, 1730, 1799, 1640, 1765, 1802, 1676, 1792,
 /*   540 */  1680, 1686, 1810, 1812, 1691, 1712, 1813, 1775, 1573, 1733,
 /*   550 */  1731, 1734, 1736, 1778, 1738, 1741, 1742, 1746, 1739, 1786,
 /*   560 */  1777, 1791, 1749, 1795, 1594, 1750, 1751, 1842, 1805, 1602,
 /*   570 */  1817, 1820, 1822, 1825, 1829, 1838, 1781, 1782, 1827, 1694,
 /*   580 */  1831, 1833, 1815, 1876, 1882, 1659, 1836, 1794, 1797, 1798,
 /*   590 */  1796, 1808, 1762, 1809, 1887, 1851, 1753, 1811, 1800, 1659,
 /*   600 */  1860, 1864, 1722, 1758, 1763, 1907, 1888, 1752, 1818, 1816,
 /*   610 */  1819, 1830, 1832, 1834, 1886, 1839, 1840, 1890, 1843, 1916,
 /*   620 */  1764, 1846, 1837, 1848, 1911, 1913, 1847, 1854, 1917, 1856,
 /*   630 */  1859, 1918, 1863, 1865, 1924, 1867, 1873, 1938, 1879, 1858,
 /*   640 */  1869, 1870, 1872, 1953, 1871, 1897, 1950, 1900, 1961, 1906,
 /*   650 */  1950, 1950, 1975, 1939, 1941, 1967, 1970, 1971, 1972, 1973,
 /*   660 */  1974, 1976, 1977, 1978, 1979, 1940, 1923, 1980, 1981, 1982,
 /*   670 */  1983, 1997, 1985, 1986, 1987, 1956, 1714, 1988, 1717, 1992,
 /*   680 */  1993, 1996, 2005, 2019, 2007, 2044, 2011, 1999, 2009, 2049,
 /*   690 */  2015, 2003, 2014, 2054, 2020, 2008, 2018, 2058, 2024, 2012,
 /*   700 */  2022, 2062, 2028, 2029, 2065, 2045, 2048, 2050, 2051, 2055,
 /*   710 */  2046,
};
#define YY_REDUCE_COUNT (291)
#define YY_REDUCE_MIN   (-425)
#define YY_REDUCE_MAX   (2312)
static const short yy_reduce_ofst[] = {
 /*     0 */   -17, -295,   -7,  233,  633,  736,  781,  854,  909, 1021,
 /*    10 */  1051, 1107, 1127, -169, 1195,   77,  341, 1211, 1272, 1317,
 /*    20 */  1378, 1401, 1462, 1492, 1515, 1560, 1576, 1629, 1674, 1727,
 /*    30 */  1743, 1788, 1841, 1857, 1902, 1925, 1955, 2031, 2053, 2108,
 /*    40 */  2153, 2198, 2214, 2259, 2282, 2312, -276, -290, -168,  -10,
 /*    50 */   834,  837,  907,  960, -327, -181, -348, -314, -425,  252,
 /*    60 */   755, -422,  289, -328, -219, -329, -291, -300, -303, -209,
 /*    70 */  -144, -173,   78,  258,  278,  326,  668,  688, -288,  698,
 /*    80 */   727,   65,  748,  754, -275,  770,   86,  800, -152, -347,
 /*    90 */   802,  828,  123,  829,  186,  187,  192,  864, -158, -294,
 /*   100 */  -282, -282, -182, -265, -170,  -62,   -6,   82,  105,  265,
 /*   110 */   276,  305,  310,  347,  383,  386,  392,  439,  442,  450,
 /*   120 */   480,  630,  631,   67, -150,   89, -116,  308,  173, -150,
 /*   130 */   311,  332,  309,  406,  426,  175,  -58,  466,  521,  126,
 /*   140 */   306,  240,  456,  552,  516,  595,  601,  616,  627,  615,
 /*   150 */   648,  700,  718,  806,  815,  851, -337,  812,  814,  835,
 /*   160 */   726,  785,  895,  793,  882,  882,  904,  868,  916,  887,
 /*   170 */   898,  843,  843,  842,  843,  856,  859,  882,  902,  900,
 /*   180 */   915,  934,  939,  944,  949,  994,  995,  953,  958,  961,
 /*   190 */   993, 1004, 1005, 1006, 1015, 1016,  955, 1011,  974, 1014,
 /*   200 */  1024,  975, 1026, 1032, 1028, 1029, 1030, 1037, 1033, 1038,
 /*   210 */  1039, 1052, 1022, 1025, 1027, 1035, 1041, 1042, 1050, 1056,
 /*   220 */  1062, 1063, 1067, 1047, 1057, 1013, 1017, 1001, 1002, 1073,
 /*   230 */  1043, 1045, 1093, 1100, 1058, 1061, 1065, 1009, 1066, 1076,
 /*   240 */  1023, 1069, 1077, 1080,  882, 1018, 1034, 1046, 1036, 1044,
 /*   250 */  1048, 1072, 1068, 1053, 1070,  843, 1116, 1085, 1156, 1154,
 /*   260 */  1153, 1111, 1110, 1128, 1131, 1132, 1133, 1135, 1115, 1137,
 /*   270 */  1138, 1171, 1164, 1181, 1145, 1105, 1179, 1173, 1197, 1213,
 /*   280 */  1203, 1217, 1220, 1160, 1158, 1168, 1169, 1219, 1221, 1222,
 /*   290 */  1223, 1232,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    10 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    20 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    30 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    40 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    50 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    60 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1850, 1595, 1595,
 /*    70 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    80 */  1595, 1673, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*    90 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1671, 1843,
 /*   100 */  2043, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   110 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   120 */  1595, 1595, 1595, 1595, 2055, 1595, 1595, 1673, 1595, 2055,
 /*   130 */  2055, 2055, 1671, 2015, 2015, 1595, 1595, 1595, 1595, 1780,
 /*   140 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1780, 1595, 1595,
 /*   150 */  1595, 1595, 1595, 1595, 1595, 1595, 1889, 1595, 1595, 2080,
 /*   160 */  2133, 1595, 1595, 2083, 1595, 1595, 1595, 1855, 1595, 1733,
 /*   170 */  2070, 2047, 2061, 2117, 2048, 2045, 2064, 1595, 2074, 1595,
 /*   180 */  1882, 1848, 1595, 1848, 1845, 1595, 1595, 1848, 1845, 1845,
 /*   190 */  1724, 1595, 1595, 1595, 1595, 1595, 1595, 1673, 1595, 1673,
 /*   200 */  1595, 1595, 1673, 1595, 1673, 1673, 1673, 1595, 1673, 1652,
 /*   210 */  1652, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   220 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1902, 1595, 1671,
 /*   230 */  1891, 1595, 1671, 1595, 1595, 1595, 1595, 2090, 2088, 1595,
 /*   240 */  2090, 2088, 1595, 1595, 1595, 2102, 2098, 2090, 2106, 2104,
 /*   250 */  2076, 2074, 2136, 2123, 2119, 2061, 1595, 1595, 1595, 1595,
 /*   260 */  1671, 1595, 2088, 1595, 1595, 1595, 1595, 1595, 2088, 1595,
 /*   270 */  1595, 1671, 1595, 1671, 1595, 1595, 1749, 1595, 1595, 1595,
 /*   280 */  1671, 1627, 1595, 1884, 1895, 1867, 1867, 1783, 1783, 1783,
 /*   290 */  1674, 1600, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   300 */  1595, 1595, 1595, 1595, 2101, 2100, 1971, 1595, 2019, 2018,
 /*   310 */  2017, 2008, 1970, 1745, 1595, 1969, 1968, 1595, 1595, 1595,
 /*   320 */  1595, 1595, 1863, 1862, 1962, 1595, 1595, 1963, 1961, 1960,
 /*   330 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   340 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 2120, 2124, 1595,
 /*   350 */  1595, 1595, 1595, 1595, 1595, 2044, 1595, 1595, 1595, 1595,
 /*   360 */  1595, 1944, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   370 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   380 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   390 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   400 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   410 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   420 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   430 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   440 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   450 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   460 */  1632, 1949, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   470 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   480 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   490 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   500 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1712, 1711,
 /*   510 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   520 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   530 */  1595, 1595, 1953, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   540 */  1595, 1595, 1595, 1595, 1595, 1595, 2116, 2077, 1595, 1595,
 /*   550 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   560 */  1595, 1944, 1595, 2099, 1595, 1595, 2114, 1595, 2118, 1595,
 /*   570 */  1595, 1595, 1595, 1595, 1595, 1595, 2054, 2050, 1595, 1595,
 /*   580 */  2046, 1595, 1595, 1595, 1595, 1952, 1595, 1595, 1595, 1595,
 /*   590 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1943,
 /*   600 */  1595, 2005, 1595, 1595, 1595, 2039, 1595, 1595, 1990, 1595,
 /*   610 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1953, 1595,
 /*   620 */  1956, 1595, 1595, 1595, 1595, 1595, 1777, 1595, 1595, 1595,
 /*   630 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1762,
 /*   640 */  1760, 1759, 1758, 1595, 1755, 1595, 1790, 1595, 1595, 1595,
 /*   650 */  1786, 1785, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   660 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1692, 1595, 1595,
 /*   670 */  1595, 1595, 1595, 1595, 1595, 1595, 1684, 1595, 1683, 1595,
 /*   680 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   690 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   700 */  1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595, 1595,
 /*   710 */  1595,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  268,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  268,  /*      AFTER => ABORT */
  268,  /*     ATTACH => ABORT */
  268,  /*     BEFORE => ABORT */
  268,  /*      BEGIN => ABORT */
  268,  /*     BITAND => ABORT */
  268,  /*     BITNOT => ABORT */
  268,  /*      BITOR => ABORT */
  268,  /*     BLOCKS => ABORT */
  268,  /*     CHANGE => ABORT */
  268,  /*      COMMA => ABORT */
  268,  /*    COMPACT => ABORT */
  268,  /*     CONCAT => ABORT */
  268,  /*   CONFLICT => ABORT */
  268,  /*       COPY => ABORT */
  268,  /*   DEFERRED => ABORT */
  268,  /* DELIMITERS => ABORT */
  268,  /*     DETACH => ABORT */
  268,  /*     DIVIDE => ABORT */
  268,  /*        DOT => ABORT */
  268,  /*       EACH => ABORT */
  268,  /*       FAIL => ABORT */
  268,  /*       FILE => ABORT */
  268,  /*        FOR => ABORT */
  268,  /*       GLOB => ABORT */
  268,  /*         ID => ABORT */
  268,  /*  IMMEDIATE => ABORT */
  268,  /*     IMPORT => ABORT */
  268,  /*  INITIALLY => ABORT */
  268,  /*    INSTEAD => ABORT */
  268,  /*     ISNULL => ABORT */
  268,  /*        KEY => ABORT */
  268,  /*    MODULES => ABORT */
  268,  /*  NK_BITNOT => ABORT */
  268,  /*    NK_SEMI => ABORT */
  268,  /*    NOTNULL => ABORT */
  268,  /*         OF => ABORT */
  268,  /*       PLUS => ABORT */
  268,  /*  PRIVILEGE => ABORT */
  268,  /*      RAISE => ABORT */
  268,  /*    REPLACE => ABORT */
  268,  /*   RESTRICT => ABORT */
  268,  /*        ROW => ABORT */
  268,  /*       SEMI => ABORT */
  268,  /*       STAR => ABORT */
  268,  /*  STATEMENT => ABORT */
  268,  /*     STRICT => ABORT */
  268,  /*     STRING => ABORT */
  268,  /*      TIMES => ABORT */
  268,  /*     UPDATE => ABORT */
  268,  /*     VALUES => ABORT */
  268,  /*   VARIABLE => ABORT */
  268,  /*       VIEW => ABORT */
  268,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "TOPIC",
  /*  168 */ "WITH",
  /*  169 */ "META",
  /*  170 */ "CONSUMER",
  /*  171 */ "GROUP",
  /*  172 */ "DESC",
  /*  173 */ "DESCRIBE",
  /*  174 */ "RESET",
  /*  175 */ "QUERY",
  /*  176 */ "CACHE",
  /*  177 */ "EXPLAIN",
  /*  178 */ "ANALYZE",
  /*  179 */ "VERBOSE",
  /*  180 */ "NK_BOOL",
  /*  181 */ "RATIO",
  /*  182 */ "NK_FLOAT",
  /*  183 */ "OUTPUTTYPE",
  /*  184 */ "AGGREGATE",
  /*  185 */ "BUFSIZE",
  /*  186 */ "STREAM",
  /*  187 */ "INTO",
  /*  188 */ "TRIGGER",
  /*  189 */ "AT_ONCE",
  /*  190 */ "WINDOW_CLOSE",
  /*  191 */ "IGNORE",
  /*  192 */ "EXPIRED",
  /*  193 */ "FILL_HISTORY",
  /*  194 */ "SUBTABLE",
  /*  195 */ "KILL",
  /*  196 */ "CONNECTION",
  /*  197 */ "TRANSACTION",
  /*  198 */ "BALANCE",
  /*  199 */ "VGROUP",
  /*  200 */ "MERGE",
  /*  201 */ "REDISTRIBUTE",
  /*  202 */ "SPLIT",
  /*  203 */ "DELETE",
  /*  204 */ "INSERT",
  /*  205 */ "NULL",
  /*  206 */ "NK_QUESTION",
  /*  207 */ "NK_ARROW",
  /*  208 */ "ROWTS",
  /*  209 */ "QSTART",
  /*  210 */ "QEND",
  /*  211 */ "QDURATION",
  /*  212 */ "WSTART",
  /*  213 */ "WEND",
  /*  214 */ "WDURATION",
  /*  215 */ "IROWTS",
  /*  216 */ "CAST",
  /*  217 */ "NOW",
  /*  218 */ "TODAY",
  /*  219 */ "TIMEZONE",
  /*  220 */ "CLIENT_VERSION",
  /*  221 */ "SERVER_VERSION",
  /*  222 */ "SERVER_STATUS",
  /*  223 */ "CURRENT_USER",
  /*  224 */ "COUNT",
  /*  225 */ "LAST_ROW",
  /*  226 */ "CASE",
  /*  227 */ "END",
  /*  228 */ "WHEN",
  /*  229 */ "THEN",
  /*  230 */ "ELSE",
  /*  231 */ "BETWEEN",
  /*  232 */ "IS",
  /*  233 */ "NK_LT",
  /*  234 */ "NK_GT",
  /*  235 */ "NK_LE",
  /*  236 */ "NK_GE",
  /*  237 */ "NK_NE",
  /*  238 */ "MATCH",
  /*  239 */ "NMATCH",
  /*  240 */ "CONTAINS",
  /*  241 */ "IN",
  /*  242 */ "JOIN",
  /*  243 */ "INNER",
  /*  244 */ "SELECT",
  /*  245 */ "DISTINCT",
  /*  246 */ "WHERE",
  /*  247 */ "PARTITION",
  /*  248 */ "BY",
  /*  249 */ "SESSION",
  /*  250 */ "STATE_WINDOW",
  /*  251 */ "SLIDING",
  /*  252 */ "FILL",
  /*  253 */ "VALUE",
  /*  254 */ "NONE",
  /*  255 */ "PREV",
  /*  256 */ "LINEAR",
  /*  257 */ "NEXT",
  /*  258 */ "HAVING",
  /*  259 */ "RANGE",
  /*  260 */ "EVERY",
  /*  261 */ "ORDER",
  /*  262 */ "SLIMIT",
  /*  263 */ "SOFFSET",
  /*  264 */ "LIMIT",
  /*  265 */ "OFFSET",
  /*  266 */ "ASC",
  /*  267 */ "NULLS",
  /*  268 */ "ABORT",
  /*  269 */ "AFTER",
  /*  270 */ "ATTACH",
  /*  271 */ "BEFORE",
  /*  272 */ "BEGIN",
  /*  273 */ "BITAND",
  /*  274 */ "BITNOT",
  /*  275 */ "BITOR",
  /*  276 */ "BLOCKS",
  /*  277 */ "CHANGE",
  /*  278 */ "COMMA",
  /*  279 */ "COMPACT",
  /*  280 */ "CONCAT",
  /*  281 */ "CONFLICT",
  /*  282 */ "COPY",
  /*  283 */ "DEFERRED",
  /*  284 */ "DELIMITERS",
  /*  285 */ "DETACH",
  /*  286 */ "DIVIDE",
  /*  287 */ "DOT",
  /*  288 */ "EACH",
  /*  289 */ "FAIL",
  /*  290 */ "FILE",
  /*  291 */ "FOR",
  /*  292 */ "GLOB",
  /*  293 */ "ID",
  /*  294 */ "IMMEDIATE",
  /*  295 */ "IMPORT",
  /*  296 */ "INITIALLY",
  /*  297 */ "INSTEAD",
  /*  298 */ "ISNULL",
  /*  299 */ "KEY",
  /*  300 */ "MODULES",
  /*  301 */ "NK_BITNOT",
  /*  302 */ "NK_SEMI",
  /*  303 */ "NOTNULL",
  /*  304 */ "OF",
  /*  305 */ "PLUS",
  /*  306 */ "PRIVILEGE",
  /*  307 */ "RAISE",
  /*  308 */ "REPLACE",
  /*  309 */ "RESTRICT",
  /*  310 */ "ROW",
  /*  311 */ "SEMI",
  /*  312 */ "STAR",
  /*  313 */ "STATEMENT",
  /*  314 */ "STRICT",
  /*  315 */ "STRING",
  /*  316 */ "TIMES",
  /*  317 */ "UPDATE",
  /*  318 */ "VALUES",
  /*  319 */ "VARIABLE",
  /*  320 */ "VIEW",
  /*  321 */ "WAL",
  /*  322 */ "cmd",
  /*  323 */ "account_options",
  /*  324 */ "alter_account_options",
  /*  325 */ "literal",
  /*  326 */ "alter_account_option",
  /*  327 */ "user_name",
  /*  328 */ "sysinfo_opt",
  /*  329 */ "privileges",
  /*  330 */ "priv_level",
  /*  331 */ "priv_type_list",
  /*  332 */ "priv_type",
  /*  333 */ "db_name",
  /*  334 */ "topic_name",
  /*  335 */ "dnode_endpoint",
  /*  336 */ "force_opt",
  /*  337 */ "not_exists_opt",
  /*  338 */ "db_options",
  /*  339 */ "exists_opt",
  /*  340 */ "alter_db_options",
  /*  341 */ "speed_opt",
  /*  342 */ "integer_list",
  /*  343 */ "variable_list",
  /*  344 */ "retention_list",
  /*  345 */ "alter_db_option",
  /*  346 */ "retention",
  /*  347 */ "full_table_name",
  /*  348 */ "column_def_list",
  /*  349 */ "tags_def_opt",
  /*  350 */ "table_options",
  /*  351 */ "multi_create_clause",
  /*  352 */ "tags_def",
  /*  353 */ "multi_drop_clause",
  /*  354 */ "alter_table_clause",
  /*  355 */ "alter_table_options",
  /*  356 */ "column_name",
  /*  357 */ "type_name",
  /*  358 */ "signed_literal",
  /*  359 */ "create_subtable_clause",
  /*  360 */ "specific_cols_opt",
  /*  361 */ "expression_list",
  /*  362 */ "drop_table_clause",
  /*  363 */ "col_name_list",
  /*  364 */ "table_name",
  /*  365 */ "column_def",
  /*  366 */ "duration_list",
  /*  367 */ "rollup_func_list",
  /*  368 */ "alter_table_option",
  /*  369 */ "duration_literal",
  /*  370 */ "rollup_func_name",
  /*  371 */ "function_name",
  /*  372 */ "col_name",
  /*  373 */ "db_name_cond_opt",
  /*  374 */ "like_pattern_opt",
  /*  375 */ "table_name_cond",
  /*  376 */ "from_db_opt",
  /*  377 */ "tag_list_opt",
  /*  378 */ "tag_item",
  /*  379 */ "column_alias",
  /*  380 */ "full_index_name",
  /*  381 */ "index_options",
  /*  382 */ "index_name",
  /*  383 */ "func_list",
  /*  384 */ "sliding_opt",
  /*  385 */ "sma_stream_opt",
  /*  386 */ "func",
  /*  387 */ "query_or_subquery",
  /*  388 */ "cgroup_name",
  /*  389 */ "analyze_opt",
  /*  390 */ "explain_options",
  /*  391 */ "agg_func_opt",
  /*  392 */ "bufsize_opt",
  /*  393 */ "stream_name",
  /*  394 */ "stream_options",
  /*  395 */ "subtable_opt",
  /*  396 */ "expression",
  /*  397 */ "dnode_list",
  /*  398 */ "where_clause_opt",
  /*  399 */ "signed",
  /*  400 */ "literal_func",
  /*  401 */ "literal_list",
  /*  402 */ "table_alias",
  /*  403 */ "expr_or_subquery",
  /*  404 */ "pseudo_column",
  /*  405 */ "column_reference",
  /*  406 */ "function_expression",
  /*  407 */ "case_when_expression",
  /*  408 */ "star_func",
  /*  409 */ "star_func_para_list",
  /*  410 */ "noarg_func",
  /*  411 */ "other_para_list",
  /*  412 */ "star_func_para",
  /*  413 */ "when_then_list",
  /*  414 */ "case_when_else_opt",
  /*  415 */ "common_expression",
  /*  416 */ "when_then_expr",
  /*  417 */ "predicate",
  /*  418 */ "compare_op",
  /*  419 */ "in_op",
  /*  420 */ "in_predicate_value",
  /*  421 */ "boolean_value_expression",
  /*  422 */ "boolean_primary",
  /*  423 */ "from_clause_opt",
  /*  424 */ "table_reference_list",
  /*  425 */ "table_reference",
  /*  426 */ "table_primary",
  /*  427 */ "joined_table",
  /*  428 */ "alias_opt",
  /*  429 */ "subquery",
  /*  430 */ "parenthesized_joined_table",
  /*  431 */ "join_type",
  /*  432 */ "search_condition",
  /*  433 */ "query_specification",
  /*  434 */ "set_quantifier_opt",
  /*  435 */ "select_list",
  /*  436 */ "partition_by_clause_opt",
  /*  437 */ "range_opt",
  /*  438 */ "every_opt",
  /*  439 */ "fill_opt",
  /*  440 */ "twindow_clause_opt",
  /*  441 */ "group_by_clause_opt",
  /*  442 */ "having_clause_opt",
  /*  443 */ "select_item",
  /*  444 */ "partition_list",
  /*  445 */ "partition_item",
  /*  446 */ "fill_mode",
  /*  447 */ "group_by_list",
  /*  448 */ "query_expression",
  /*  449 */ "query_simple",
  /*  450 */ "order_by_clause_opt",
  /*  451 */ "slimit_clause_opt",
  /*  452 */ "limit_clause_opt",
  /*  453 */ "union_query_expression",
  /*  454 */ "query_simple_or_subquery",
  /*  455 */ "sort_specification_list",
  /*  456 */ "sort_specification",
  /*  457 */ "ordering_specification_opt",
  /*  458 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 261 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 262 */ "full_index_name ::= index_name",
 /* 263 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 266 */ "func_list ::= func",
 /* 267 */ "func_list ::= func_list NK_COMMA func",
 /* 268 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 269 */ "sma_stream_opt ::=",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 271 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 272 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 278 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 279 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 280 */ "cmd ::= DESC full_table_name",
 /* 281 */ "cmd ::= DESCRIBE full_table_name",
 /* 282 */ "cmd ::= RESET QUERY CACHE",
 /* 283 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 284 */ "analyze_opt ::=",
 /* 285 */ "analyze_opt ::= ANALYZE",
 /* 286 */ "explain_options ::=",
 /* 287 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 288 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 289 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 290 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 291 */ "agg_func_opt ::=",
 /* 292 */ "agg_func_opt ::= AGGREGATE",
 /* 293 */ "bufsize_opt ::=",
 /* 294 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 295 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 296 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 297 */ "stream_options ::=",
 /* 298 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 299 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 300 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 301 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 302 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 303 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 304 */ "subtable_opt ::=",
 /* 305 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 306 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 307 */ "cmd ::= KILL QUERY NK_STRING",
 /* 308 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 309 */ "cmd ::= BALANCE VGROUP",
 /* 310 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 311 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 312 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 313 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 314 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 315 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 316 */ "cmd ::= query_or_subquery",
 /* 317 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 318 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 319 */ "literal ::= NK_INTEGER",
 /* 320 */ "literal ::= NK_FLOAT",
 /* 321 */ "literal ::= NK_STRING",
 /* 322 */ "literal ::= NK_BOOL",
 /* 323 */ "literal ::= TIMESTAMP NK_STRING",
 /* 324 */ "literal ::= duration_literal",
 /* 325 */ "literal ::= NULL",
 /* 326 */ "literal ::= NK_QUESTION",
 /* 327 */ "duration_literal ::= NK_VARIABLE",
 /* 328 */ "signed ::= NK_INTEGER",
 /* 329 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 330 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 331 */ "signed ::= NK_FLOAT",
 /* 332 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 333 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 334 */ "signed_literal ::= signed",
 /* 335 */ "signed_literal ::= NK_STRING",
 /* 336 */ "signed_literal ::= NK_BOOL",
 /* 337 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 338 */ "signed_literal ::= duration_literal",
 /* 339 */ "signed_literal ::= NULL",
 /* 340 */ "signed_literal ::= literal_func",
 /* 341 */ "signed_literal ::= NK_QUESTION",
 /* 342 */ "literal_list ::= signed_literal",
 /* 343 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 344 */ "db_name ::= NK_ID",
 /* 345 */ "table_name ::= NK_ID",
 /* 346 */ "column_name ::= NK_ID",
 /* 347 */ "function_name ::= NK_ID",
 /* 348 */ "table_alias ::= NK_ID",
 /* 349 */ "column_alias ::= NK_ID",
 /* 350 */ "user_name ::= NK_ID",
 /* 351 */ "topic_name ::= NK_ID",
 /* 352 */ "stream_name ::= NK_ID",
 /* 353 */ "cgroup_name ::= NK_ID",
 /* 354 */ "index_name ::= NK_ID",
 /* 355 */ "expr_or_subquery ::= expression",
 /* 356 */ "expression ::= literal",
 /* 357 */ "expression ::= pseudo_column",
 /* 358 */ "expression ::= column_reference",
 /* 359 */ "expression ::= function_expression",
 /* 360 */ "expression ::= case_when_expression",
 /* 361 */ "expression ::= NK_LP expression NK_RP",
 /* 362 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 363 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 369 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 370 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 371 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 372 */ "expression_list ::= expr_or_subquery",
 /* 373 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 374 */ "column_reference ::= column_name",
 /* 375 */ "column_reference ::= table_name NK_DOT column_name",
 /* 376 */ "pseudo_column ::= ROWTS",
 /* 377 */ "pseudo_column ::= TBNAME",
 /* 378 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 379 */ "pseudo_column ::= QSTART",
 /* 380 */ "pseudo_column ::= QEND",
 /* 381 */ "pseudo_column ::= QDURATION",
 /* 382 */ "pseudo_column ::= WSTART",
 /* 383 */ "pseudo_column ::= WEND",
 /* 384 */ "pseudo_column ::= WDURATION",
 /* 385 */ "pseudo_column ::= IROWTS",
 /* 386 */ "pseudo_column ::= QTAGS",
 /* 387 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 388 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 389 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 390 */ "function_expression ::= literal_func",
 /* 391 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 392 */ "literal_func ::= NOW",
 /* 393 */ "noarg_func ::= NOW",
 /* 394 */ "noarg_func ::= TODAY",
 /* 395 */ "noarg_func ::= TIMEZONE",
 /* 396 */ "noarg_func ::= DATABASE",
 /* 397 */ "noarg_func ::= CLIENT_VERSION",
 /* 398 */ "noarg_func ::= SERVER_VERSION",
 /* 399 */ "noarg_func ::= SERVER_STATUS",
 /* 400 */ "noarg_func ::= CURRENT_USER",
 /* 401 */ "noarg_func ::= USER",
 /* 402 */ "star_func ::= COUNT",
 /* 403 */ "star_func ::= FIRST",
 /* 404 */ "star_func ::= LAST",
 /* 405 */ "star_func ::= LAST_ROW",
 /* 406 */ "star_func_para_list ::= NK_STAR",
 /* 407 */ "star_func_para_list ::= other_para_list",
 /* 408 */ "other_para_list ::= star_func_para",
 /* 409 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 410 */ "star_func_para ::= expr_or_subquery",
 /* 411 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 412 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 413 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 414 */ "when_then_list ::= when_then_expr",
 /* 415 */ "when_then_list ::= when_then_list when_then_expr",
 /* 416 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 417 */ "case_when_else_opt ::=",
 /* 418 */ "case_when_else_opt ::= ELSE common_expression",
 /* 419 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 420 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 421 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 422 */ "predicate ::= expr_or_subquery IS NULL",
 /* 423 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 424 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 425 */ "compare_op ::= NK_LT",
 /* 426 */ "compare_op ::= NK_GT",
 /* 427 */ "compare_op ::= NK_LE",
 /* 428 */ "compare_op ::= NK_GE",
 /* 429 */ "compare_op ::= NK_NE",
 /* 430 */ "compare_op ::= NK_EQ",
 /* 431 */ "compare_op ::= LIKE",
 /* 432 */ "compare_op ::= NOT LIKE",
 /* 433 */ "compare_op ::= MATCH",
 /* 434 */ "compare_op ::= NMATCH",
 /* 435 */ "compare_op ::= CONTAINS",
 /* 436 */ "in_op ::= IN",
 /* 437 */ "in_op ::= NOT IN",
 /* 438 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 439 */ "boolean_value_expression ::= boolean_primary",
 /* 440 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 441 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 442 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 443 */ "boolean_primary ::= predicate",
 /* 444 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 445 */ "common_expression ::= expr_or_subquery",
 /* 446 */ "common_expression ::= boolean_value_expression",
 /* 447 */ "from_clause_opt ::=",
 /* 448 */ "from_clause_opt ::= FROM table_reference_list",
 /* 449 */ "table_reference_list ::= table_reference",
 /* 450 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 451 */ "table_reference ::= table_primary",
 /* 452 */ "table_reference ::= joined_table",
 /* 453 */ "table_primary ::= table_name alias_opt",
 /* 454 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 455 */ "table_primary ::= subquery alias_opt",
 /* 456 */ "table_primary ::= parenthesized_joined_table",
 /* 457 */ "alias_opt ::=",
 /* 458 */ "alias_opt ::= table_alias",
 /* 459 */ "alias_opt ::= AS table_alias",
 /* 460 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 461 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 462 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 463 */ "join_type ::=",
 /* 464 */ "join_type ::= INNER",
 /* 465 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 466 */ "set_quantifier_opt ::=",
 /* 467 */ "set_quantifier_opt ::= DISTINCT",
 /* 468 */ "set_quantifier_opt ::= ALL",
 /* 469 */ "select_list ::= select_item",
 /* 470 */ "select_list ::= select_list NK_COMMA select_item",
 /* 471 */ "select_item ::= NK_STAR",
 /* 472 */ "select_item ::= common_expression",
 /* 473 */ "select_item ::= common_expression column_alias",
 /* 474 */ "select_item ::= common_expression AS column_alias",
 /* 475 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 476 */ "where_clause_opt ::=",
 /* 477 */ "where_clause_opt ::= WHERE search_condition",
 /* 478 */ "partition_by_clause_opt ::=",
 /* 479 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 480 */ "partition_list ::= partition_item",
 /* 481 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 482 */ "partition_item ::= expr_or_subquery",
 /* 483 */ "partition_item ::= expr_or_subquery column_alias",
 /* 484 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 485 */ "twindow_clause_opt ::=",
 /* 486 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 487 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 488 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 489 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 490 */ "sliding_opt ::=",
 /* 491 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 492 */ "fill_opt ::=",
 /* 493 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 494 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 495 */ "fill_mode ::= NONE",
 /* 496 */ "fill_mode ::= PREV",
 /* 497 */ "fill_mode ::= NULL",
 /* 498 */ "fill_mode ::= LINEAR",
 /* 499 */ "fill_mode ::= NEXT",
 /* 500 */ "group_by_clause_opt ::=",
 /* 501 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 502 */ "group_by_list ::= expr_or_subquery",
 /* 503 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 504 */ "having_clause_opt ::=",
 /* 505 */ "having_clause_opt ::= HAVING search_condition",
 /* 506 */ "range_opt ::=",
 /* 507 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 508 */ "every_opt ::=",
 /* 509 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 510 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 511 */ "query_simple ::= query_specification",
 /* 512 */ "query_simple ::= union_query_expression",
 /* 513 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 514 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 515 */ "query_simple_or_subquery ::= query_simple",
 /* 516 */ "query_simple_or_subquery ::= subquery",
 /* 517 */ "query_or_subquery ::= query_expression",
 /* 518 */ "query_or_subquery ::= subquery",
 /* 519 */ "order_by_clause_opt ::=",
 /* 520 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 521 */ "slimit_clause_opt ::=",
 /* 522 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 523 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 524 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 525 */ "limit_clause_opt ::=",
 /* 526 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 527 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 528 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 529 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 530 */ "subquery ::= NK_LP subquery NK_RP",
 /* 531 */ "search_condition ::= common_expression",
 /* 532 */ "sort_specification_list ::= sort_specification",
 /* 533 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 534 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 535 */ "ordering_specification_opt ::=",
 /* 536 */ "ordering_specification_opt ::= ASC",
 /* 537 */ "ordering_specification_opt ::= DESC",
 /* 538 */ "null_ordering_opt ::=",
 /* 539 */ "null_ordering_opt ::= NULLS FIRST",
 /* 540 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 322: /* cmd */
    case 325: /* literal */
    case 338: /* db_options */
    case 340: /* alter_db_options */
    case 346: /* retention */
    case 347: /* full_table_name */
    case 350: /* table_options */
    case 354: /* alter_table_clause */
    case 355: /* alter_table_options */
    case 358: /* signed_literal */
    case 359: /* create_subtable_clause */
    case 362: /* drop_table_clause */
    case 365: /* column_def */
    case 369: /* duration_literal */
    case 370: /* rollup_func_name */
    case 372: /* col_name */
    case 373: /* db_name_cond_opt */
    case 374: /* like_pattern_opt */
    case 375: /* table_name_cond */
    case 376: /* from_db_opt */
    case 378: /* tag_item */
    case 380: /* full_index_name */
    case 381: /* index_options */
    case 384: /* sliding_opt */
    case 385: /* sma_stream_opt */
    case 386: /* func */
    case 387: /* query_or_subquery */
    case 390: /* explain_options */
    case 394: /* stream_options */
    case 395: /* subtable_opt */
    case 396: /* expression */
    case 398: /* where_clause_opt */
    case 399: /* signed */
    case 400: /* literal_func */
    case 403: /* expr_or_subquery */
    case 404: /* pseudo_column */
    case 405: /* column_reference */
    case 406: /* function_expression */
    case 407: /* case_when_expression */
    case 412: /* star_func_para */
    case 414: /* case_when_else_opt */
    case 415: /* common_expression */
    case 416: /* when_then_expr */
    case 417: /* predicate */
    case 420: /* in_predicate_value */
    case 421: /* boolean_value_expression */
    case 422: /* boolean_primary */
    case 423: /* from_clause_opt */
    case 424: /* table_reference_list */
    case 425: /* table_reference */
    case 426: /* table_primary */
    case 427: /* joined_table */
    case 429: /* subquery */
    case 430: /* parenthesized_joined_table */
    case 432: /* search_condition */
    case 433: /* query_specification */
    case 437: /* range_opt */
    case 438: /* every_opt */
    case 439: /* fill_opt */
    case 440: /* twindow_clause_opt */
    case 442: /* having_clause_opt */
    case 443: /* select_item */
    case 445: /* partition_item */
    case 448: /* query_expression */
    case 449: /* query_simple */
    case 451: /* slimit_clause_opt */
    case 452: /* limit_clause_opt */
    case 453: /* union_query_expression */
    case 454: /* query_simple_or_subquery */
    case 456: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy74)); 
}
      break;
    case 323: /* account_options */
    case 324: /* alter_account_options */
    case 326: /* alter_account_option */
    case 341: /* speed_opt */
    case 392: /* bufsize_opt */
{
 
}
      break;
    case 327: /* user_name */
    case 330: /* priv_level */
    case 333: /* db_name */
    case 334: /* topic_name */
    case 335: /* dnode_endpoint */
    case 356: /* column_name */
    case 364: /* table_name */
    case 371: /* function_name */
    case 379: /* column_alias */
    case 382: /* index_name */
    case 388: /* cgroup_name */
    case 393: /* stream_name */
    case 402: /* table_alias */
    case 408: /* star_func */
    case 410: /* noarg_func */
    case 428: /* alias_opt */
{
 
}
      break;
    case 328: /* sysinfo_opt */
{
 
}
      break;
    case 329: /* privileges */
    case 331: /* priv_type_list */
    case 332: /* priv_type */
{
 
}
      break;
    case 336: /* force_opt */
    case 337: /* not_exists_opt */
    case 339: /* exists_opt */
    case 389: /* analyze_opt */
    case 391: /* agg_func_opt */
    case 434: /* set_quantifier_opt */
{
 
}
      break;
    case 342: /* integer_list */
    case 343: /* variable_list */
    case 344: /* retention_list */
    case 348: /* column_def_list */
    case 349: /* tags_def_opt */
    case 351: /* multi_create_clause */
    case 352: /* tags_def */
    case 353: /* multi_drop_clause */
    case 360: /* specific_cols_opt */
    case 361: /* expression_list */
    case 363: /* col_name_list */
    case 366: /* duration_list */
    case 367: /* rollup_func_list */
    case 377: /* tag_list_opt */
    case 383: /* func_list */
    case 397: /* dnode_list */
    case 401: /* literal_list */
    case 409: /* star_func_para_list */
    case 411: /* other_para_list */
    case 413: /* when_then_list */
    case 435: /* select_list */
    case 436: /* partition_by_clause_opt */
    case 441: /* group_by_clause_opt */
    case 444: /* partition_list */
    case 447: /* group_by_list */
    case 450: /* order_by_clause_opt */
    case 455: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy874)); 
}
      break;
    case 345: /* alter_db_option */
    case 368: /* alter_table_option */
{
 
}
      break;
    case 357: /* type_name */
{
 
}
      break;
    case 418: /* compare_op */
    case 419: /* in_op */
{
 
}
      break;
    case 431: /* join_type */
{
 
}
      break;
    case 446: /* fill_mode */
{
 
}
      break;
    case 457: /* ordering_specification_opt */
{
 
}
      break;
    case 458: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  322,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  322,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  323,    0 }, /* (2) account_options ::= */
  {  323,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  323,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  323,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  323,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  323,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  323,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  323,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  323,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  323,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  324,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  324,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  326,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  326,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  326,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  326,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  326,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  326,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  326,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  326,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  326,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  326,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  322,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  322,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  322,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  322,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  322,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  328,    0 }, /* (29) sysinfo_opt ::= */
  {  328,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  322,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  322,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  329,   -1 }, /* (33) privileges ::= ALL */
  {  329,   -1 }, /* (34) privileges ::= priv_type_list */
  {  329,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  331,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  331,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  332,   -1 }, /* (38) priv_type ::= READ */
  {  332,   -1 }, /* (39) priv_type ::= WRITE */
  {  330,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  330,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  330,   -1 }, /* (42) priv_level ::= topic_name */
  {  322,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  322,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  322,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  322,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  322,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  322,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  322,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  322,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  335,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  335,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  335,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  336,    0 }, /* (54) force_opt ::= */
  {  336,   -1 }, /* (55) force_opt ::= FORCE */
  {  322,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  322,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  322,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  322,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  322,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  322,   -2 }, /* (68) cmd ::= USE db_name */
  {  322,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  322,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  322,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  337,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  337,    0 }, /* (73) not_exists_opt ::= */
  {  339,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  339,    0 }, /* (75) exists_opt ::= */
  {  338,    0 }, /* (76) db_options ::= */
  {  338,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  338,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  338,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  338,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  338,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  338,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  338,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  338,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  338,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  338,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  338,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  338,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  338,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  338,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  338,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  338,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  338,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  338,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  338,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  338,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  338,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  338,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  338,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  338,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  338,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  338,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  338,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  340,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  340,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  345,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  345,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  345,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  345,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  345,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  345,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  345,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  345,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  345,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  342,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  342,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  343,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  343,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  344,   -1 }, /* (123) retention_list ::= retention */
  {  344,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  346,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  341,    0 }, /* (126) speed_opt ::= */
  {  341,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  322,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  322,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  322,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  322,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  322,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  322,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  322,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  354,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  354,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  354,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  354,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  354,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  354,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  354,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  354,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  354,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  354,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  351,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  351,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  359,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  353,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  353,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  362,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  360,    0 }, /* (151) specific_cols_opt ::= */
  {  360,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  347,   -1 }, /* (153) full_table_name ::= table_name */
  {  347,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  348,   -1 }, /* (155) column_def_list ::= column_def */
  {  348,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  365,   -2 }, /* (157) column_def ::= column_name type_name */
  {  365,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  357,   -1 }, /* (159) type_name ::= BOOL */
  {  357,   -1 }, /* (160) type_name ::= TINYINT */
  {  357,   -1 }, /* (161) type_name ::= SMALLINT */
  {  357,   -1 }, /* (162) type_name ::= INT */
  {  357,   -1 }, /* (163) type_name ::= INTEGER */
  {  357,   -1 }, /* (164) type_name ::= BIGINT */
  {  357,   -1 }, /* (165) type_name ::= FLOAT */
  {  357,   -1 }, /* (166) type_name ::= DOUBLE */
  {  357,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  357,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  357,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  357,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  357,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  357,   -1 }, /* (174) type_name ::= JSON */
  {  357,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  357,   -1 }, /* (177) type_name ::= BLOB */
  {  357,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  357,   -1 }, /* (179) type_name ::= DECIMAL */
  {  357,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  357,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  349,    0 }, /* (182) tags_def_opt ::= */
  {  349,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  352,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  350,    0 }, /* (185) table_options ::= */
  {  350,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  350,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  350,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  350,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  350,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  350,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  350,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  355,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  355,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  368,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  368,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  366,   -1 }, /* (197) duration_list ::= duration_literal */
  {  366,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  367,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  367,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  370,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  370,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  370,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  363,   -1 }, /* (204) col_name_list ::= col_name */
  {  363,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  372,   -1 }, /* (206) col_name ::= column_name */
  {  322,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  322,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  322,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  322,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  322,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  322,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  322,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  322,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  322,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  322,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  322,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  322,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  322,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  322,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  322,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  322,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  322,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  322,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  322,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  322,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  322,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  322,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  322,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  322,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  322,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  322,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  322,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  322,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  322,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  322,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  322,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  322,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  322,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  322,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  322,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  322,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  322,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  322,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  373,    0 }, /* (245) db_name_cond_opt ::= */
  {  373,   -2 }, /* (246) db_name_cond_opt ::= db_name NK_DOT */
  {  374,    0 }, /* (247) like_pattern_opt ::= */
  {  374,   -2 }, /* (248) like_pattern_opt ::= LIKE NK_STRING */
  {  375,   -1 }, /* (249) table_name_cond ::= table_name */
  {  376,    0 }, /* (250) from_db_opt ::= */
  {  376,   -2 }, /* (251) from_db_opt ::= FROM db_name */
  {  377,    0 }, /* (252) tag_list_opt ::= */
  {  377,   -1 }, /* (253) tag_list_opt ::= tag_item */
  {  377,   -3 }, /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  378,   -1 }, /* (255) tag_item ::= TBNAME */
  {  378,   -1 }, /* (256) tag_item ::= QTAGS */
  {  378,   -1 }, /* (257) tag_item ::= column_name */
  {  378,   -2 }, /* (258) tag_item ::= column_name column_alias */
  {  378,   -3 }, /* (259) tag_item ::= column_name AS column_alias */
  {  322,   -8 }, /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  322,   -4 }, /* (261) cmd ::= DROP INDEX exists_opt full_index_name */
  {  380,   -1 }, /* (262) full_index_name ::= index_name */
  {  380,   -3 }, /* (263) full_index_name ::= db_name NK_DOT index_name */
  {  381,  -10 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  381,  -12 }, /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,   -1 }, /* (266) func_list ::= func */
  {  383,   -3 }, /* (267) func_list ::= func_list NK_COMMA func */
  {  386,   -4 }, /* (268) func ::= function_name NK_LP expression_list NK_RP */
  {  385,    0 }, /* (269) sma_stream_opt ::= */
  {  385,   -3 }, /* (270) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  385,   -3 }, /* (271) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  385,   -3 }, /* (272) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  322,   -6 }, /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  322,   -7 }, /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  322,   -9 }, /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  322,   -7 }, /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  322,   -9 }, /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  322,   -4 }, /* (278) cmd ::= DROP TOPIC exists_opt topic_name */
  {  322,   -7 }, /* (279) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  322,   -2 }, /* (280) cmd ::= DESC full_table_name */
  {  322,   -2 }, /* (281) cmd ::= DESCRIBE full_table_name */
  {  322,   -3 }, /* (282) cmd ::= RESET QUERY CACHE */
  {  322,   -4 }, /* (283) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  389,    0 }, /* (284) analyze_opt ::= */
  {  389,   -1 }, /* (285) analyze_opt ::= ANALYZE */
  {  390,    0 }, /* (286) explain_options ::= */
  {  390,   -3 }, /* (287) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  390,   -3 }, /* (288) explain_options ::= explain_options RATIO NK_FLOAT */
  {  322,  -10 }, /* (289) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  322,   -4 }, /* (290) cmd ::= DROP FUNCTION exists_opt function_name */
  {  391,    0 }, /* (291) agg_func_opt ::= */
  {  391,   -1 }, /* (292) agg_func_opt ::= AGGREGATE */
  {  392,    0 }, /* (293) bufsize_opt ::= */
  {  392,   -2 }, /* (294) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  322,  -11 }, /* (295) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  322,   -4 }, /* (296) cmd ::= DROP STREAM exists_opt stream_name */
  {  394,    0 }, /* (297) stream_options ::= */
  {  394,   -3 }, /* (298) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  394,   -3 }, /* (299) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  394,   -4 }, /* (300) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  394,   -3 }, /* (301) stream_options ::= stream_options WATERMARK duration_literal */
  {  394,   -4 }, /* (302) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  394,   -3 }, /* (303) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  395,    0 }, /* (304) subtable_opt ::= */
  {  395,   -4 }, /* (305) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  322,   -3 }, /* (306) cmd ::= KILL CONNECTION NK_INTEGER */
  {  322,   -3 }, /* (307) cmd ::= KILL QUERY NK_STRING */
  {  322,   -3 }, /* (308) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  322,   -2 }, /* (309) cmd ::= BALANCE VGROUP */
  {  322,   -4 }, /* (310) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  322,   -4 }, /* (311) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  322,   -3 }, /* (312) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  397,   -2 }, /* (313) dnode_list ::= DNODE NK_INTEGER */
  {  397,   -3 }, /* (314) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  322,   -4 }, /* (315) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  322,   -1 }, /* (316) cmd ::= query_or_subquery */
  {  322,   -7 }, /* (317) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  322,   -4 }, /* (318) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  325,   -1 }, /* (319) literal ::= NK_INTEGER */
  {  325,   -1 }, /* (320) literal ::= NK_FLOAT */
  {  325,   -1 }, /* (321) literal ::= NK_STRING */
  {  325,   -1 }, /* (322) literal ::= NK_BOOL */
  {  325,   -2 }, /* (323) literal ::= TIMESTAMP NK_STRING */
  {  325,   -1 }, /* (324) literal ::= duration_literal */
  {  325,   -1 }, /* (325) literal ::= NULL */
  {  325,   -1 }, /* (326) literal ::= NK_QUESTION */
  {  369,   -1 }, /* (327) duration_literal ::= NK_VARIABLE */
  {  399,   -1 }, /* (328) signed ::= NK_INTEGER */
  {  399,   -2 }, /* (329) signed ::= NK_PLUS NK_INTEGER */
  {  399,   -2 }, /* (330) signed ::= NK_MINUS NK_INTEGER */
  {  399,   -1 }, /* (331) signed ::= NK_FLOAT */
  {  399,   -2 }, /* (332) signed ::= NK_PLUS NK_FLOAT */
  {  399,   -2 }, /* (333) signed ::= NK_MINUS NK_FLOAT */
  {  358,   -1 }, /* (334) signed_literal ::= signed */
  {  358,   -1 }, /* (335) signed_literal ::= NK_STRING */
  {  358,   -1 }, /* (336) signed_literal ::= NK_BOOL */
  {  358,   -2 }, /* (337) signed_literal ::= TIMESTAMP NK_STRING */
  {  358,   -1 }, /* (338) signed_literal ::= duration_literal */
  {  358,   -1 }, /* (339) signed_literal ::= NULL */
  {  358,   -1 }, /* (340) signed_literal ::= literal_func */
  {  358,   -1 }, /* (341) signed_literal ::= NK_QUESTION */
  {  401,   -1 }, /* (342) literal_list ::= signed_literal */
  {  401,   -3 }, /* (343) literal_list ::= literal_list NK_COMMA signed_literal */
  {  333,   -1 }, /* (344) db_name ::= NK_ID */
  {  364,   -1 }, /* (345) table_name ::= NK_ID */
  {  356,   -1 }, /* (346) column_name ::= NK_ID */
  {  371,   -1 }, /* (347) function_name ::= NK_ID */
  {  402,   -1 }, /* (348) table_alias ::= NK_ID */
  {  379,   -1 }, /* (349) column_alias ::= NK_ID */
  {  327,   -1 }, /* (350) user_name ::= NK_ID */
  {  334,   -1 }, /* (351) topic_name ::= NK_ID */
  {  393,   -1 }, /* (352) stream_name ::= NK_ID */
  {  388,   -1 }, /* (353) cgroup_name ::= NK_ID */
  {  382,   -1 }, /* (354) index_name ::= NK_ID */
  {  403,   -1 }, /* (355) expr_or_subquery ::= expression */
  {  396,   -1 }, /* (356) expression ::= literal */
  {  396,   -1 }, /* (357) expression ::= pseudo_column */
  {  396,   -1 }, /* (358) expression ::= column_reference */
  {  396,   -1 }, /* (359) expression ::= function_expression */
  {  396,   -1 }, /* (360) expression ::= case_when_expression */
  {  396,   -3 }, /* (361) expression ::= NK_LP expression NK_RP */
  {  396,   -2 }, /* (362) expression ::= NK_PLUS expr_or_subquery */
  {  396,   -2 }, /* (363) expression ::= NK_MINUS expr_or_subquery */
  {  396,   -3 }, /* (364) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  396,   -3 }, /* (365) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  396,   -3 }, /* (366) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  396,   -3 }, /* (367) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  396,   -3 }, /* (368) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  396,   -3 }, /* (369) expression ::= column_reference NK_ARROW NK_STRING */
  {  396,   -3 }, /* (370) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  396,   -3 }, /* (371) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  361,   -1 }, /* (372) expression_list ::= expr_or_subquery */
  {  361,   -3 }, /* (373) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  405,   -1 }, /* (374) column_reference ::= column_name */
  {  405,   -3 }, /* (375) column_reference ::= table_name NK_DOT column_name */
  {  404,   -1 }, /* (376) pseudo_column ::= ROWTS */
  {  404,   -1 }, /* (377) pseudo_column ::= TBNAME */
  {  404,   -3 }, /* (378) pseudo_column ::= table_name NK_DOT TBNAME */
  {  404,   -1 }, /* (379) pseudo_column ::= QSTART */
  {  404,   -1 }, /* (380) pseudo_column ::= QEND */
  {  404,   -1 }, /* (381) pseudo_column ::= QDURATION */
  {  404,   -1 }, /* (382) pseudo_column ::= WSTART */
  {  404,   -1 }, /* (383) pseudo_column ::= WEND */
  {  404,   -1 }, /* (384) pseudo_column ::= WDURATION */
  {  404,   -1 }, /* (385) pseudo_column ::= IROWTS */
  {  404,   -1 }, /* (386) pseudo_column ::= QTAGS */
  {  406,   -4 }, /* (387) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  406,   -4 }, /* (388) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  406,   -6 }, /* (389) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  406,   -1 }, /* (390) function_expression ::= literal_func */
  {  400,   -3 }, /* (391) literal_func ::= noarg_func NK_LP NK_RP */
  {  400,   -1 }, /* (392) literal_func ::= NOW */
  {  410,   -1 }, /* (393) noarg_func ::= NOW */
  {  410,   -1 }, /* (394) noarg_func ::= TODAY */
  {  410,   -1 }, /* (395) noarg_func ::= TIMEZONE */
  {  410,   -1 }, /* (396) noarg_func ::= DATABASE */
  {  410,   -1 }, /* (397) noarg_func ::= CLIENT_VERSION */
  {  410,   -1 }, /* (398) noarg_func ::= SERVER_VERSION */
  {  410,   -1 }, /* (399) noarg_func ::= SERVER_STATUS */
  {  410,   -1 }, /* (400) noarg_func ::= CURRENT_USER */
  {  410,   -1 }, /* (401) noarg_func ::= USER */
  {  408,   -1 }, /* (402) star_func ::= COUNT */
  {  408,   -1 }, /* (403) star_func ::= FIRST */
  {  408,   -1 }, /* (404) star_func ::= LAST */
  {  408,   -1 }, /* (405) star_func ::= LAST_ROW */
  {  409,   -1 }, /* (406) star_func_para_list ::= NK_STAR */
  {  409,   -1 }, /* (407) star_func_para_list ::= other_para_list */
  {  411,   -1 }, /* (408) other_para_list ::= star_func_para */
  {  411,   -3 }, /* (409) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  412,   -1 }, /* (410) star_func_para ::= expr_or_subquery */
  {  412,   -3 }, /* (411) star_func_para ::= table_name NK_DOT NK_STAR */
  {  407,   -4 }, /* (412) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  407,   -5 }, /* (413) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  413,   -1 }, /* (414) when_then_list ::= when_then_expr */
  {  413,   -2 }, /* (415) when_then_list ::= when_then_list when_then_expr */
  {  416,   -4 }, /* (416) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  414,    0 }, /* (417) case_when_else_opt ::= */
  {  414,   -2 }, /* (418) case_when_else_opt ::= ELSE common_expression */
  {  417,   -3 }, /* (419) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  417,   -5 }, /* (420) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  417,   -6 }, /* (421) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  417,   -3 }, /* (422) predicate ::= expr_or_subquery IS NULL */
  {  417,   -4 }, /* (423) predicate ::= expr_or_subquery IS NOT NULL */
  {  417,   -3 }, /* (424) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  418,   -1 }, /* (425) compare_op ::= NK_LT */
  {  418,   -1 }, /* (426) compare_op ::= NK_GT */
  {  418,   -1 }, /* (427) compare_op ::= NK_LE */
  {  418,   -1 }, /* (428) compare_op ::= NK_GE */
  {  418,   -1 }, /* (429) compare_op ::= NK_NE */
  {  418,   -1 }, /* (430) compare_op ::= NK_EQ */
  {  418,   -1 }, /* (431) compare_op ::= LIKE */
  {  418,   -2 }, /* (432) compare_op ::= NOT LIKE */
  {  418,   -1 }, /* (433) compare_op ::= MATCH */
  {  418,   -1 }, /* (434) compare_op ::= NMATCH */
  {  418,   -1 }, /* (435) compare_op ::= CONTAINS */
  {  419,   -1 }, /* (436) in_op ::= IN */
  {  419,   -2 }, /* (437) in_op ::= NOT IN */
  {  420,   -3 }, /* (438) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  421,   -1 }, /* (439) boolean_value_expression ::= boolean_primary */
  {  421,   -2 }, /* (440) boolean_value_expression ::= NOT boolean_primary */
  {  421,   -3 }, /* (441) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  421,   -3 }, /* (442) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  422,   -1 }, /* (443) boolean_primary ::= predicate */
  {  422,   -3 }, /* (444) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  415,   -1 }, /* (445) common_expression ::= expr_or_subquery */
  {  415,   -1 }, /* (446) common_expression ::= boolean_value_expression */
  {  423,    0 }, /* (447) from_clause_opt ::= */
  {  423,   -2 }, /* (448) from_clause_opt ::= FROM table_reference_list */
  {  424,   -1 }, /* (449) table_reference_list ::= table_reference */
  {  424,   -3 }, /* (450) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  425,   -1 }, /* (451) table_reference ::= table_primary */
  {  425,   -1 }, /* (452) table_reference ::= joined_table */
  {  426,   -2 }, /* (453) table_primary ::= table_name alias_opt */
  {  426,   -4 }, /* (454) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  426,   -2 }, /* (455) table_primary ::= subquery alias_opt */
  {  426,   -1 }, /* (456) table_primary ::= parenthesized_joined_table */
  {  428,    0 }, /* (457) alias_opt ::= */
  {  428,   -1 }, /* (458) alias_opt ::= table_alias */
  {  428,   -2 }, /* (459) alias_opt ::= AS table_alias */
  {  430,   -3 }, /* (460) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  430,   -3 }, /* (461) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  427,   -6 }, /* (462) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  431,    0 }, /* (463) join_type ::= */
  {  431,   -1 }, /* (464) join_type ::= INNER */
  {  433,  -12 }, /* (465) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  434,    0 }, /* (466) set_quantifier_opt ::= */
  {  434,   -1 }, /* (467) set_quantifier_opt ::= DISTINCT */
  {  434,   -1 }, /* (468) set_quantifier_opt ::= ALL */
  {  435,   -1 }, /* (469) select_list ::= select_item */
  {  435,   -3 }, /* (470) select_list ::= select_list NK_COMMA select_item */
  {  443,   -1 }, /* (471) select_item ::= NK_STAR */
  {  443,   -1 }, /* (472) select_item ::= common_expression */
  {  443,   -2 }, /* (473) select_item ::= common_expression column_alias */
  {  443,   -3 }, /* (474) select_item ::= common_expression AS column_alias */
  {  443,   -3 }, /* (475) select_item ::= table_name NK_DOT NK_STAR */
  {  398,    0 }, /* (476) where_clause_opt ::= */
  {  398,   -2 }, /* (477) where_clause_opt ::= WHERE search_condition */
  {  436,    0 }, /* (478) partition_by_clause_opt ::= */
  {  436,   -3 }, /* (479) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  444,   -1 }, /* (480) partition_list ::= partition_item */
  {  444,   -3 }, /* (481) partition_list ::= partition_list NK_COMMA partition_item */
  {  445,   -1 }, /* (482) partition_item ::= expr_or_subquery */
  {  445,   -2 }, /* (483) partition_item ::= expr_or_subquery column_alias */
  {  445,   -3 }, /* (484) partition_item ::= expr_or_subquery AS column_alias */
  {  440,    0 }, /* (485) twindow_clause_opt ::= */
  {  440,   -6 }, /* (486) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  440,   -4 }, /* (487) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  440,   -6 }, /* (488) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  440,   -8 }, /* (489) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  384,    0 }, /* (490) sliding_opt ::= */
  {  384,   -4 }, /* (491) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  439,    0 }, /* (492) fill_opt ::= */
  {  439,   -4 }, /* (493) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  439,   -6 }, /* (494) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  446,   -1 }, /* (495) fill_mode ::= NONE */
  {  446,   -1 }, /* (496) fill_mode ::= PREV */
  {  446,   -1 }, /* (497) fill_mode ::= NULL */
  {  446,   -1 }, /* (498) fill_mode ::= LINEAR */
  {  446,   -1 }, /* (499) fill_mode ::= NEXT */
  {  441,    0 }, /* (500) group_by_clause_opt ::= */
  {  441,   -3 }, /* (501) group_by_clause_opt ::= GROUP BY group_by_list */
  {  447,   -1 }, /* (502) group_by_list ::= expr_or_subquery */
  {  447,   -3 }, /* (503) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  442,    0 }, /* (504) having_clause_opt ::= */
  {  442,   -2 }, /* (505) having_clause_opt ::= HAVING search_condition */
  {  437,    0 }, /* (506) range_opt ::= */
  {  437,   -6 }, /* (507) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  438,    0 }, /* (508) every_opt ::= */
  {  438,   -4 }, /* (509) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  448,   -4 }, /* (510) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  449,   -1 }, /* (511) query_simple ::= query_specification */
  {  449,   -1 }, /* (512) query_simple ::= union_query_expression */
  {  453,   -4 }, /* (513) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  453,   -3 }, /* (514) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  454,   -1 }, /* (515) query_simple_or_subquery ::= query_simple */
  {  454,   -1 }, /* (516) query_simple_or_subquery ::= subquery */
  {  387,   -1 }, /* (517) query_or_subquery ::= query_expression */
  {  387,   -1 }, /* (518) query_or_subquery ::= subquery */
  {  450,    0 }, /* (519) order_by_clause_opt ::= */
  {  450,   -3 }, /* (520) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  451,    0 }, /* (521) slimit_clause_opt ::= */
  {  451,   -2 }, /* (522) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  451,   -4 }, /* (523) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  451,   -4 }, /* (524) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  452,    0 }, /* (525) limit_clause_opt ::= */
  {  452,   -2 }, /* (526) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  452,   -4 }, /* (527) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  452,   -4 }, /* (528) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  429,   -3 }, /* (529) subquery ::= NK_LP query_expression NK_RP */
  {  429,   -3 }, /* (530) subquery ::= NK_LP subquery NK_RP */
  {  432,   -1 }, /* (531) search_condition ::= common_expression */
  {  455,   -1 }, /* (532) sort_specification_list ::= sort_specification */
  {  455,   -3 }, /* (533) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  456,   -3 }, /* (534) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  457,    0 }, /* (535) ordering_specification_opt ::= */
  {  457,   -1 }, /* (536) ordering_specification_opt ::= ASC */
  {  457,   -1 }, /* (537) ordering_specification_opt ::= DESC */
  {  458,    0 }, /* (538) null_ordering_opt ::= */
  {  458,   -2 }, /* (539) null_ordering_opt ::= NULLS FIRST */
  {  458,   -2 }, /* (540) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,323,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,324,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,323,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,324,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,326,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy317, &yymsp[-1].minor.yy0, yymsp[0].minor.yy449); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy317, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy449 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy449 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy531, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy531, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy531 = yymsp[0].minor.yy531; }
  yymsp[0].minor.yy531 = yylhsminor.yy531;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy531 = yymsp[-2].minor.yy531 | yymsp[0].minor.yy531; }
  yymsp[-2].minor.yy531 = yylhsminor.yy531;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy531 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy317 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy317 = yylhsminor.yy317;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy317 = yymsp[-2].minor.yy317; }
  yymsp[-2].minor.yy317 = yylhsminor.yy317;
        break;
      case 42: /* priv_level ::= topic_name */
      case 458: /* alias_opt ::= table_alias */ yytestcase(yyruleno==458);
{ yylhsminor.yy317 = yymsp[0].minor.yy317; }
  yymsp[0].minor.yy317 = yylhsminor.yy317;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy317, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy335); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy335); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 344: /* db_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* table_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* column_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* function_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* table_alias ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* column_alias ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* user_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* topic_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* stream_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* index_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 393: /* noarg_func ::= NOW */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= TODAY */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= USER */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= COUNT */ yytestcase(yyruleno==402);
      case 403: /* star_func ::= FIRST */ yytestcase(yyruleno==403);
      case 404: /* star_func ::= LAST */ yytestcase(yyruleno==404);
      case 405: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==405);
{ yylhsminor.yy317 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy317 = yylhsminor.yy317;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 284: /* analyze_opt ::= */ yytestcase(yyruleno==284);
      case 291: /* agg_func_opt ::= */ yytestcase(yyruleno==291);
      case 466: /* set_quantifier_opt ::= */ yytestcase(yyruleno==466);
{ yymsp[1].minor.yy335 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 285: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==285);
      case 292: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==292);
      case 467: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==467);
{ yymsp[0].minor.yy335 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy335, &yymsp[-1].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy856); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy335 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy335 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy74 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_KEEP, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_RETENTIONS, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-3].minor.yy74, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-3].minor.yy74, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy74 = setDatabaseOption(pCxt, yymsp[-2].minor.yy74, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy74 = createAlterDatabaseOptions(pCxt); yylhsminor.yy74 = setAlterDatabaseOption(pCxt, yylhsminor.yy74, &yymsp[0].minor.yy767); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy74 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy74, &yymsp[0].minor.yy767); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy767.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy767.type = DB_OPTION_KEEP; yymsp[-1].minor.yy767.pList = yymsp[0].minor.yy874; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_PAGES; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_WAL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy767.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 314: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==314);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy874 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 266: /* func_list ::= func */ yytestcase(yyruleno==266);
      case 342: /* literal_list ::= signed_literal */ yytestcase(yyruleno==342);
      case 408: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==408);
      case 414: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==414);
      case 469: /* select_list ::= select_item */ yytestcase(yyruleno==469);
      case 480: /* partition_list ::= partition_item */ yytestcase(yyruleno==480);
      case 532: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==532);
{ yylhsminor.yy874 = createNodeList(pCxt, yymsp[0].minor.yy74); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 267: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==267);
      case 343: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==343);
      case 409: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==409);
      case 470: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==470);
      case 481: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==481);
      case 533: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==533);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy74 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 126: /* speed_opt ::= */
      case 293: /* bufsize_opt ::= */ yytestcase(yyruleno==293);
{ yymsp[1].minor.yy856 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 294: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==294);
{ yymsp[-1].minor.yy856 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy335, yymsp[-5].minor.yy74, yymsp[-3].minor.yy874, yymsp[-1].minor.yy874, yymsp[0].minor.yy74); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 316: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==316);
{ pCxt->pRootNode = yymsp[0].minor.yy74; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy74); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy74 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy74 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy74, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy74 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy74 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy74, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy74 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy74 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy74, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy74 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy74, &yymsp[-2].minor.yy317, yymsp[0].minor.yy74); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 415: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==415);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-1].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy874 = yylhsminor.yy874;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy74 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy335, yymsp[-8].minor.yy74, yymsp[-6].minor.yy74, yymsp[-5].minor.yy874, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
  yymsp[-9].minor.yy74 = yylhsminor.yy74;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy74 = createDropTableClause(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 478: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==478);
      case 500: /* group_by_clause_opt ::= */ yytestcase(yyruleno==500);
      case 519: /* order_by_clause_opt ::= */ yytestcase(yyruleno==519);
{ yymsp[1].minor.yy874 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy74 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy317, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy74 = createRealTableNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317, NULL); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy74 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy317, yymsp[0].minor.yy898, NULL); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy74 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-2].minor.yy898, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy898 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy898 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 407: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==407);
{ yylhsminor.yy874 = yymsp[0].minor.yy874; }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy74 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-4].minor.yy74, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-4].minor.yy74, TABLE_OPTION_SMA, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-2].minor.yy74, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy74 = createAlterTableOptions(pCxt); yylhsminor.yy74 = setTableOption(pCxt, yylhsminor.yy74, yymsp[0].minor.yy767.type, &yymsp[0].minor.yy767.val); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy74 = setTableOption(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy767.type, &yymsp[0].minor.yy767.val); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy767.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy767.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy767.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 372: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==372);
{ yylhsminor.yy874 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 373: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==373);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[0].minor.yy317, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy74 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy317); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy74, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy74, yymsp[-1].minor.yy74, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy74); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy74); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy74); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy74); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy74, yymsp[-1].minor.yy74, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74, yymsp[-3].minor.yy874); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy74 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy74 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 247: /* like_pattern_opt ::= */
      case 304: /* subtable_opt ::= */ yytestcase(yyruleno==304);
      case 417: /* case_when_else_opt ::= */ yytestcase(yyruleno==417);
      case 447: /* from_clause_opt ::= */ yytestcase(yyruleno==447);
      case 476: /* where_clause_opt ::= */ yytestcase(yyruleno==476);
      case 485: /* twindow_clause_opt ::= */ yytestcase(yyruleno==485);
      case 490: /* sliding_opt ::= */ yytestcase(yyruleno==490);
      case 492: /* fill_opt ::= */ yytestcase(yyruleno==492);
      case 504: /* having_clause_opt ::= */ yytestcase(yyruleno==504);
      case 506: /* range_opt ::= */ yytestcase(yyruleno==506);
      case 508: /* every_opt ::= */ yytestcase(yyruleno==508);
      case 521: /* slimit_clause_opt ::= */ yytestcase(yyruleno==521);
      case 525: /* limit_clause_opt ::= */ yytestcase(yyruleno==525);
{ yymsp[1].minor.yy74 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy74 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy317); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy74 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy317); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy317), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy74 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy317), &yymsp[0].minor.yy317); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy335, yymsp[-3].minor.yy74, yymsp[-1].minor.yy74, NULL, yymsp[0].minor.yy74); }
        break;
      case 261: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy335, yymsp[0].minor.yy74); }
        break;
      case 262: /* full_index_name ::= index_name */
{ yylhsminor.yy74 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy317); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 263: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy74 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy74 = createIndexOption(pCxt, yymsp[-7].minor.yy874, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 265: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy74 = createIndexOption(pCxt, yymsp[-9].minor.yy874, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 268: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy74 = createFunctionNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-1].minor.yy874); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 269: /* sma_stream_opt ::= */
      case 297: /* stream_options ::= */ yytestcase(yyruleno==297);
{ yymsp[1].minor.yy74 = createStreamOptions(pCxt); }
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 301: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==301);
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 271: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 272: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy335, &yymsp[-2].minor.yy317, yymsp[0].minor.yy74); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy335, &yymsp[-3].minor.yy317, &yymsp[0].minor.yy317, false); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy335, &yymsp[-5].minor.yy317, &yymsp[0].minor.yy317, true); }
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy335, &yymsp[-3].minor.yy317, yymsp[0].minor.yy74, false); }
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy335, &yymsp[-5].minor.yy317, yymsp[0].minor.yy74, true); }
        break;
      case 278: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 279: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy335, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317); }
        break;
      case 280: /* cmd ::= DESC full_table_name */
      case 281: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==281);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy74); }
        break;
      case 282: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 283: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy335, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 286: /* explain_options ::= */
{ yymsp[1].minor.yy74 = createDefaultExplainOptions(pCxt); }
        break;
      case 287: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy74 = setExplainVerbose(pCxt, yymsp[-2].minor.yy74, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 288: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy74 = setExplainRatio(pCxt, yymsp[-2].minor.yy74, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 289: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy335, yymsp[-8].minor.yy335, &yymsp[-5].minor.yy317, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy898, yymsp[0].minor.yy856); }
        break;
      case 290: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 295: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy335, &yymsp[-7].minor.yy317, yymsp[-4].minor.yy74, yymsp[-6].minor.yy74, yymsp[-3].minor.yy874, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 296: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy335, &yymsp[0].minor.yy317); }
        break;
      case 298: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 299: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 300: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy74)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy74)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); yylhsminor.yy74 = yymsp[-3].minor.yy74; }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 302: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy74)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy74 = yymsp[-3].minor.yy74; }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 303: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy74)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy74 = yymsp[-2].minor.yy74; }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 305: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 491: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==491);
      case 509: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==509);
{ yymsp[-3].minor.yy74 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy74); }
        break;
      case 306: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 308: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 309: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 310: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy874); }
        break;
      case 312: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 313: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 315: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 317: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy74, yymsp[-2].minor.yy874, yymsp[0].minor.yy74); }
        break;
      case 318: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy74, NULL, yymsp[0].minor.yy74); }
        break;
      case 319: /* literal ::= NK_INTEGER */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 320: /* literal ::= NK_FLOAT */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 321: /* literal ::= NK_STRING */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 322: /* literal ::= NK_BOOL */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 323: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 324: /* literal ::= duration_literal */
      case 334: /* signed_literal ::= signed */ yytestcase(yyruleno==334);
      case 355: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==355);
      case 356: /* expression ::= literal */ yytestcase(yyruleno==356);
      case 357: /* expression ::= pseudo_column */ yytestcase(yyruleno==357);
      case 358: /* expression ::= column_reference */ yytestcase(yyruleno==358);
      case 359: /* expression ::= function_expression */ yytestcase(yyruleno==359);
      case 360: /* expression ::= case_when_expression */ yytestcase(yyruleno==360);
      case 390: /* function_expression ::= literal_func */ yytestcase(yyruleno==390);
      case 439: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==439);
      case 443: /* boolean_primary ::= predicate */ yytestcase(yyruleno==443);
      case 445: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==445);
      case 446: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==446);
      case 449: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==449);
      case 451: /* table_reference ::= table_primary */ yytestcase(yyruleno==451);
      case 452: /* table_reference ::= joined_table */ yytestcase(yyruleno==452);
      case 456: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==456);
      case 511: /* query_simple ::= query_specification */ yytestcase(yyruleno==511);
      case 512: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==512);
      case 515: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==515);
      case 517: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==517);
{ yylhsminor.yy74 = yymsp[0].minor.yy74; }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 325: /* literal ::= NULL */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 326: /* literal ::= NK_QUESTION */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 327: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 328: /* signed ::= NK_INTEGER */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 329: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 330: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 331: /* signed ::= NK_FLOAT */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 332: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 333: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 335: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 336: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 337: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 338: /* signed_literal ::= duration_literal */
      case 340: /* signed_literal ::= literal_func */ yytestcase(yyruleno==340);
      case 410: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==410);
      case 472: /* select_item ::= common_expression */ yytestcase(yyruleno==472);
      case 482: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==482);
      case 516: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==516);
      case 518: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==518);
      case 531: /* search_condition ::= common_expression */ yytestcase(yyruleno==531);
{ yylhsminor.yy74 = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 339: /* signed_literal ::= NULL */
{ yylhsminor.yy74 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 341: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy74 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 361: /* expression ::= NK_LP expression NK_RP */
      case 444: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==444);
      case 530: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==530);
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 362: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy74));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 363: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy74), NULL));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 364: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 365: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 366: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 367: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 368: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 369: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 370: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 371: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 374: /* column_reference ::= column_name */
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy317, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy317)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 375: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317, createColumnNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy317)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 376: /* pseudo_column ::= ROWTS */
      case 377: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==377);
      case 379: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= QEND */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= WEND */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==386);
      case 392: /* literal_func ::= NOW */ yytestcase(yyruleno==392);
{ yylhsminor.yy74 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 378: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy317)))); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 387: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 388: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==388);
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy317, yymsp[-1].minor.yy874)); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 389: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy898)); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 391: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy317, NULL)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 406: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy874 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 411: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 475: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==475);
{ yylhsminor.yy74 = createColumnNode(pCxt, &yymsp[-2].minor.yy317, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 412: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy874, yymsp[-1].minor.yy74)); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 413: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-2].minor.yy874, yymsp[-1].minor.yy74)); }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 416: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy74 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)); }
        break;
      case 418: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy74 = releaseRawExprNode(pCxt, yymsp[0].minor.yy74); }
        break;
      case 419: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 424: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==424);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy20, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 420: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy74), releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-4].minor.yy74 = yylhsminor.yy74;
        break;
      case 421: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 422: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), NULL));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 423: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL));
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 425: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_THAN; }
        break;
      case 426: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_THAN; }
        break;
      case 427: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy20 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 428: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy20 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 429: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy20 = OP_TYPE_NOT_EQUAL; }
        break;
      case 430: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy20 = OP_TYPE_EQUAL; }
        break;
      case 431: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy20 = OP_TYPE_LIKE; }
        break;
      case 432: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_LIKE; }
        break;
      case 433: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_MATCH; }
        break;
      case 434: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy20 = OP_TYPE_NMATCH; }
        break;
      case 435: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy20 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 436: /* in_op ::= IN */
{ yymsp[0].minor.yy20 = OP_TYPE_IN; }
        break;
      case 437: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy20 = OP_TYPE_NOT_IN; }
        break;
      case 438: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 440: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy74), NULL));
                                                                                  }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 441: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 442: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy74);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy74);
                                                                                    yylhsminor.yy74 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), releaseRawExprNode(pCxt, yymsp[0].minor.yy74)));
                                                                                  }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 448: /* from_clause_opt ::= FROM table_reference_list */
      case 477: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==477);
      case 505: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==505);
{ yymsp[-1].minor.yy74 = yymsp[0].minor.yy74; }
        break;
      case 450: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy74 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy74, yymsp[0].minor.yy74, NULL); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 453: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy74 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 454: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy74 = createRealTableNode(pCxt, &yymsp[-3].minor.yy317, &yymsp[-1].minor.yy317, &yymsp[0].minor.yy317); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 455: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy74 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 457: /* alias_opt ::= */
{ yymsp[1].minor.yy317 = nil_token;  }
        break;
      case 459: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy317 = yymsp[0].minor.yy317; }
        break;
      case 460: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 461: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==461);
{ yymsp[-2].minor.yy74 = yymsp[-1].minor.yy74; }
        break;
      case 462: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy74 = createJoinTableNode(pCxt, yymsp[-4].minor.yy630, yymsp[-5].minor.yy74, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-5].minor.yy74 = yylhsminor.yy74;
        break;
      case 463: /* join_type ::= */
{ yymsp[1].minor.yy630 = JOIN_TYPE_INNER; }
        break;
      case 464: /* join_type ::= INNER */
{ yymsp[0].minor.yy630 = JOIN_TYPE_INNER; }
        break;
      case 465: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy74 = createSelectStmt(pCxt, yymsp[-10].minor.yy335, yymsp[-9].minor.yy874, yymsp[-8].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addWhereClause(pCxt, yymsp[-11].minor.yy74, yymsp[-7].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addPartitionByClause(pCxt, yymsp[-11].minor.yy74, yymsp[-6].minor.yy874);
                                                                                    yymsp[-11].minor.yy74 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy74, yymsp[-2].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addGroupByClause(pCxt, yymsp[-11].minor.yy74, yymsp[-1].minor.yy874);
                                                                                    yymsp[-11].minor.yy74 = addHavingClause(pCxt, yymsp[-11].minor.yy74, yymsp[0].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addRangeClause(pCxt, yymsp[-11].minor.yy74, yymsp[-5].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addEveryClause(pCxt, yymsp[-11].minor.yy74, yymsp[-4].minor.yy74);
                                                                                    yymsp[-11].minor.yy74 = addFillClause(pCxt, yymsp[-11].minor.yy74, yymsp[-3].minor.yy74);
                                                                                  }
        break;
      case 468: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy335 = false; }
        break;
      case 471: /* select_item ::= NK_STAR */
{ yylhsminor.yy74 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy74 = yylhsminor.yy74;
        break;
      case 473: /* select_item ::= common_expression column_alias */
      case 483: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==483);
{ yylhsminor.yy74 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-1].minor.yy74 = yylhsminor.yy74;
        break;
      case 474: /* select_item ::= common_expression AS column_alias */
      case 484: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==484);
{ yylhsminor.yy74 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), &yymsp[0].minor.yy317); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 479: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 501: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==501);
      case 520: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==520);
{ yymsp[-2].minor.yy874 = yymsp[0].minor.yy874; }
        break;
      case 486: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy74 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 487: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy74 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 488: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy74 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), NULL, yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 489: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy74 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy74), releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), yymsp[-1].minor.yy74, yymsp[0].minor.yy74); }
        break;
      case 493: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy74 = createFillNode(pCxt, yymsp[-1].minor.yy828, NULL); }
        break;
      case 494: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy74 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
        break;
      case 495: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy828 = FILL_MODE_NONE; }
        break;
      case 496: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy828 = FILL_MODE_PREV; }
        break;
      case 497: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy828 = FILL_MODE_NULL; }
        break;
      case 498: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy828 = FILL_MODE_LINEAR; }
        break;
      case 499: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy828 = FILL_MODE_NEXT; }
        break;
      case 502: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy874 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 503: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy74))); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 507: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy74 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy74), releaseRawExprNode(pCxt, yymsp[-1].minor.yy74)); }
        break;
      case 510: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy74 = addOrderByClause(pCxt, yymsp[-3].minor.yy74, yymsp[-2].minor.yy874);
                                                                                    yylhsminor.yy74 = addSlimitClause(pCxt, yylhsminor.yy74, yymsp[-1].minor.yy74);
                                                                                    yylhsminor.yy74 = addLimitClause(pCxt, yylhsminor.yy74, yymsp[0].minor.yy74);
                                                                                  }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 513: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy74 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-3].minor.yy74 = yylhsminor.yy74;
        break;
      case 514: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy74 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy74, yymsp[0].minor.yy74); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 522: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 526: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==526);
{ yymsp[-1].minor.yy74 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 523: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 527: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==527);
{ yymsp[-3].minor.yy74 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 524: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 528: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==528);
{ yymsp[-3].minor.yy74 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 529: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy74 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy74); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 534: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy74 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy74), yymsp[-1].minor.yy326, yymsp[0].minor.yy109); }
  yymsp[-2].minor.yy74 = yylhsminor.yy74;
        break;
      case 535: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy326 = ORDER_ASC; }
        break;
      case 536: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy326 = ORDER_ASC; }
        break;
      case 537: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy326 = ORDER_DESC; }
        break;
      case 538: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy109 = NULL_ORDER_DEFAULT; }
        break;
      case 539: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_FIRST; }
        break;
      case 540: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
